local DGV = DugisGuideViewer
if not DGV then return end

local TaxiData = DGV:RegisterModule("TaxiData")
TaxiData.essential = true

--Possible modes: "veiled-den", "lights-purchase"
TaxiData.currentBeaconMode = "unknown"

function TaxiData:Initialize()

	local fullData
	function TaxiData:GetFullData()
		--107457 Druid
		--98968 Hunter 
		--93465 Death Knight 
		--98114 Alliance Skyfire Triage Camp Stormheim
		--98113 Alliance Lorna's Watch Stormheim
		--98108 Alliance Greywatch Stormheim
		--92560 Horde Cullen's Post Stormheim
		if not fullData then
			fullData = {
	["Neutral"] = {},
	["Horde"] = {
	[1] = {
		[11798] = {
			direct = "2995",
			m = 80,
			f = 0,
			coord = 1902015812,
			requirements = "cls:DRUID",
			overridePlayerData = true
		},	
		[52060] = {
			"3615:3310", -- [1]
			"3615:4312", -- [2]
			"2995:6726", -- [3]
			"39330:40358:40769:7824", -- [4]
			"39330:39898", -- [5]
			"3615:8610", -- [6]
			"3615:3310:11139", -- [7]
			"3615:34927:34429:11901", -- [8]
			"3615:34927:12616", -- [9]
			"3615:34927:12616:22931:43073:43085:12740", -- [10]
			"39330:39898:15178", -- [11]
			"39330:40358:40769:7824:10583", -- [12]
			"3615:16227", -- [13]
			"3615:34927:12616:22931", -- [14]
			"39330:40358", -- [15]
			"3615:34927:34429", -- [16]
			"3615:34927", -- [17]
			"3615:34927:34943", -- [18]
			"3615:4312:35141", -- [19]
			"2995:35139:35140", -- [20]
			"2995:35139", -- [21]
			"2995:35556:35562:35315", -- [22]
			"2995:35556:35478", -- [23]
			"2995:35556", -- [24]
			"2995:35556:35562", -- [25]
			"39330:40358:40769:7824:39175", -- [26]
			"2995:40809", -- [27]
			"3615:40558", -- [28]
			"39330:40358:40769", -- [29]
			"39330:40358:40769:7824:41215", -- [30]
			"3615:3310:41140:41142", -- [31]
			"3615:3310:41140", -- [32]
			"39330:40358:40769:7824:41214", -- [33]
			"3615:4312:41246", -- [34]
			"3615:3310:43549:50084", -- [35]
			"3615:3310:43549:50084:53783", -- [36]
			"3615:3310:43549:50084:41861", -- [37]
			"39330:39898:41605:40473", -- [38]
			"39330:39898:41605", -- [39]
			"3615:34927:12616:22931:43073", -- [40]
			"3615:34927:12616:22931:43079", -- [41]
			"3615:34927:12616:22931:43073:43085", -- [42]
			"3615:3310:37005", -- [43]
			"3615:8610:43328", -- [44]
			"3615:3310:43549", -- [45]
			"39330:40358:40769:7824:41215:48275", -- [46]
			"39330:39898:15178:48274", -- [47]
			"39330:39898:15178:48274:48273", -- [48]
			"3615:34927:12616:36728", -- [49]
			"3615:3310:43549:50084:54393", -- [50]
			--["name"] = "Vendetta Point, Southern Barrens",
			["m"] = 199,
			["f"] = 0,
			["direct"] = "2995:3615:44399:11899:39340:39330",
			["coord"] = 1784969748,
		},
		[35556] = {
			"2995:3310", -- [1]
			"2995:3615", -- [2]
			"35478:4312", -- [3]
			"2995:44399", -- [4]
			"35478:6726", -- [5]
			"2995:7824", -- [6]
			"2995:52060:39330:39898", -- [7]
			"2995:8610", -- [8]
			"2995:8610:11139", -- [9]
			"2995:52060:11899", -- [10]
			"35478:4312:11901", -- [11]
			"2995:3615:34927:12616", -- [12]
			"2995:3615:34927:12616:22931:43073:43085:12740", -- [13]
			"35478:6726:40473:41605:15178", -- [14]
			"2995:52060", -- [15]
			"2995:7824:10583", -- [16]
			"2995:3615:16227", -- [17]
			"2995:3615:34927:12616:22931", -- [18]
			"2995:52060:39330:40358", -- [19]
			"35478:4312:34429", -- [20]
			"2995:3615:34927", -- [21]
			"2995:35139:35140:34943", -- [22]
			"35478:4312:35141", -- [23]
			"2995:35139:35140", -- [24]
			"2995:35139", -- [25]
			"35562:35315", -- [26]
			"2995:7824:39175", -- [27]
			"2995:39340", -- [28]
			"2995:52060:39330", -- [29]
			"2995:40809", -- [30]
			"2995:3615:40558", -- [31]
			"2995:52060:39330:40358:40769", -- [32]
			"2995:7824:41215", -- [33]
			"2995:3310:41140:41142", -- [34]
			"2995:3310:41140", -- [35]
			"2995:7824:41214", -- [36]
			"35478:4312:41246", -- [37]
			"2995:3310:43549:50084", -- [38]
			"2995:3310:43549:50084:53783", -- [39]
			"2995:3310:43549:50084:41861", -- [40]
			"35478:6726:40473", -- [41]
			"35478:6726:40473:41605", -- [42]
			"2995:3615:34927:12616:22931:43073", -- [43]
			"2995:3615:34927:12616:22931:43079", -- [44]
			"2995:3615:34927:12616:22931:43073:43085", -- [45]
			"2995:3310:37005", -- [46]
			"2995:8610:43328", -- [47]
			"2995:3310:43549", -- [48]
			"2995:7824:41215:48275", -- [49]
			"35478:6726:40473:41605:15178:48274", -- [50]
			"35478:6726:40473:41605:15178:48274:48273", -- [51]
			"2995:3615:34927:12616:36728", -- [52]
			"2995:3310:43549:50084:54393", -- [53]
			--["name"] = "Thunk's Abode, Desolace",
			["m"] = 66,
			["coord"] = 3034666036,
			["direct"] = "2995:35478:35562",
			["f"] = 0,
		},
		[8610] = {
			"12616:34943:35140:4312", -- [1]
			"3310:3615:44399", -- [2]
			"2995:6726", -- [3]
			"3310:7824", -- [4]
			"3310:3615:52060:39330:39898", -- [5]
			"3310:16227:11899", -- [6]
			"12616:34429:11901", -- [7]
			"11139:12740", -- [8]
			"3310:3615:52060:39330:39898:15178", -- [9]
			"3310:3615:52060", -- [10]
			"3310:7824:10583", -- [11]
			"3310:16227", -- [12]
			"12616:22931", -- [13]
			"3310:16227:11899:40358", -- [14]
			"12616:34429", -- [15]
			"12616:34927", -- [16]
			"12616:34943", -- [17]
			"12616:34429:35141", -- [18]
			"12616:34943:35140", -- [19]
			"3310:3615:35139", -- [20]
			"12616:34943:35140:4312:35315", -- [21]
			"2995:35556:35478", -- [22]
			"2995:35556", -- [23]
			"12616:34943:35140:4312:35315:35562", -- [24]
			"3310:7824:39175", -- [25]
			"3310:3615:39340", -- [26]
			"3310:3615:52060:39330", -- [27]
			"2995:40809", -- [28]
			"3310:40558", -- [29]
			"3310:16227:11899:40358:40769", -- [30]
			"3310:7824:41215", -- [31]
			"3310:41140:41142", -- [32]
			"3310:41140", -- [33]
			"3310:7824:41214", -- [34]
			"12616:34943:35140:41246", -- [35]
			"36728:43549:50084", -- [36]
			"36728:43549:50084:53783", -- [37]
			"36728:43549:50084:41861", -- [38]
			"2995:6726:40473", -- [39]
			"3310:3615:52060:39330:39898:41605", -- [40]
			"11139:43085:43073", -- [41]
			"12616:22931:43079", -- [42]
			"11139:43085", -- [43]
			"36728:43549", -- [44]
			"3310:7824:41215:48275", -- [45]
			"3310:3615:52060:39330:39898:15178:48274", -- [46]
			"3310:3615:52060:39330:39898:15178:48274:48273", -- [47]
			"36728:43549:50084:54393", -- [48]
			--["name"] = "Bilgewater Harbor, Azshara",
			["m"] = 76,
			["f"] = 0,
			["direct"] = "2995:3310:3615:11139:12616:37005:43328:36728",
			["coord"] = 2275573679,
		},
		[39340] = {
			"3615:3310", -- [1]
			"3615:4312", -- [2]
			"52060:44399", -- [3]
			"2995:6726", -- [4]
			"52060:39330:40358:40769:7824", -- [5]
			"52060:39330:39898", -- [6]
			"3615:8610", -- [7]
			"3615:3310:11139", -- [8]
			"52060:11899", -- [9]
			"3615:34927:34429:11901", -- [10]
			"3615:34927:12616", -- [11]
			"3615:34927:12616:22931:43073:43085:12740", -- [12]
			"52060:39330:39898:15178", -- [13]
			"52060:39330:40358:40769:7824:10583", -- [14]
			"3615:16227", -- [15]
			"3615:34927:12616:22931", -- [16]
			"52060:39330:40358", -- [17]
			"3615:34927:34429", -- [18]
			"3615:34927", -- [19]
			"3615:34927:34943", -- [20]
			"2995:35139:35141", -- [21]
			"2995:35139:35140", -- [22]
			"2995:35139", -- [23]
			"2995:35556:35562:35315", -- [24]
			"2995:35556:35478", -- [25]
			"2995:35556", -- [26]
			"2995:35556:35562", -- [27]
			"52060:39330:40358:40769:7824:39175", -- [28]
			"2995:40809", -- [29]
			"3615:40558", -- [30]
			"52060:39330:40358:40769", -- [31]
			"52060:39330:40358:40769:7824:41215", -- [32]
			"3615:3310:41140:41142", -- [33]
			"3615:3310:41140", -- [34]
			"52060:39330:40358:40769:7824:41214", -- [35]
			"3615:4312:41246", -- [36]
			"3615:3310:43549:50084", -- [37]
			"3615:3310:43549:50084:53783", -- [38]
			"3615:3310:43549:50084:41861", -- [39]
			"2995:6726:40473", -- [40]
			"52060:39330:39898:41605", -- [41]
			"3615:34927:12616:22931:43073", -- [42]
			"3615:34927:12616:22931:43079", -- [43]
			"3615:34927:12616:22931:43073:43085", -- [44]
			"3615:3310:37005", -- [45]
			"3615:8610:43328", -- [46]
			"3615:3310:43549", -- [47]
			"52060:39330:40358:40769:7824:41215:48275", -- [48]
			"52060:39330:39898:15178:48274", -- [49]
			"52060:39330:39898:15178:48274:48273", -- [50]
			"3615:34927:12616:36728", -- [51]
			"3615:3310:43549:50084:54393", -- [52]
			--["name"] = "Hunter's Hill, Southern Barrens",
			["m"] = 199,
			["f"] = 0,
			["direct"] = "2995:3615:52060:39330",
			["coord"] = 1707619315,
		},
		[35562] = {
			"35556:2995", -- [1]
			"35556:2995:3310", -- [2]
			"35556:2995:3615", -- [3]
			"35315:4312", -- [4]
			"35556:2995:44399", -- [5]
			"35556:2995:7824", -- [6]
			"35315:39898", -- [7]
			"35556:2995:8610", -- [8]
			"35556:2995:8610:11139", -- [9]
			"35556:2995:52060:11899", -- [10]
			"35315:4312:11901", -- [11]
			"35315:4312:35140:34943:12616", -- [12]
			"35315:4312:34429:22931:43073:43085:12740", -- [13]
			"35315:6726:40473:41605:15178", -- [14]
			"35556:2995:52060", -- [15]
			"35315:6726:40473:41605:15178:39175:10583", -- [16]
			"35556:2995:3615:16227", -- [17]
			"35315:4312:34429:22931", -- [18]
			"35556:2995:52060:39330:40358", -- [19]
			"35315:4312:34429", -- [20]
			"35556:2995:3615:34927", -- [21]
			"35315:4312:35140:34943", -- [22]
			"35315:4312:35141", -- [23]
			"35315:4312:35140", -- [24]
			"35556:2995:35139", -- [25]
			"35315:6726:40473:41605:15178:39175", -- [26]
			"35556:2995:39340", -- [27]
			"35556:2995:52060:39330", -- [28]
			"35556:2995:40809", -- [29]
			"35556:2995:3615:40558", -- [30]
			"35556:2995:52060:39330:40358:40769", -- [31]
			"35556:2995:7824:41215", -- [32]
			"35556:2995:3310:41140:41142", -- [33]
			"35556:2995:3310:41140", -- [34]
			"35556:2995:7824:41214", -- [35]
			"35315:4312:41246", -- [36]
			"35556:2995:3310:43549:50084", -- [37]
			"35556:2995:3310:43549:50084:53783", -- [38]
			"35556:2995:3310:43549:50084:41861", -- [39]
			"35315:6726:40473", -- [40]
			"35315:6726:40473:41605", -- [41]
			"35315:4312:34429:22931:43073", -- [42]
			"35315:4312:34429:22931:43079", -- [43]
			"35315:4312:34429:22931:43073:43085", -- [44]
			"35556:2995:3310:37005", -- [45]
			"35556:2995:8610:43328", -- [46]
			"35556:2995:3310:43549", -- [47]
			"35315:6726:40473:41605:15178:48274:48275", -- [48]
			"35315:6726:40473:41605:15178:48274", -- [49]
			"35315:6726:40473:41605:15178:48274:48273", -- [50]
			"35315:4312:35140:34943:12616:36728", -- [51]
			"35556:2995:3310:43549:50084:54393", -- [52]
			--["name"] = "Ethel Rethor, Desolace",
			["m"] = 66,
			["coord"] = 1675838727,
			["direct"] = "6726:35315:35478:35556",
			["f"] = 0,
		},
		[40358] = {
			"11899:52060:2995", -- [1]
			"11899:16227:3310", -- [2]
			"11899:52060:3615", -- [3]
			"11899:52060:3615:4312", -- [4]
			"44399:39898:41605:40473:6726", -- [5]
			"40769:7824", -- [6]
			"44399:39898", -- [7]
			"11899:16227:3310:8610", -- [8]
			"11899:16227:3310:11139", -- [9]
			"11899:52060:3615:34927:34429:11901", -- [10]
			"11899:52060:3615:34927:12616", -- [11]
			"11899:52060:3615:34927:12616:22931:43073:43085:12740", -- [12]
			"40769:7824:39175:15178", -- [13]
			"11899:52060", -- [14]
			"40769:7824:10583", -- [15]
			"11899:16227", -- [16]
			"11899:52060:3615:34927:12616:22931", -- [17]
			"11899:52060:3615:34927:34429", -- [18]
			"11899:52060:3615:34927", -- [19]
			"11899:52060:3615:34927:34943", -- [20]
			"11899:52060:3615:4312:35141", -- [21]
			"11899:52060:2995:35139:35140", -- [22]
			"11899:52060:2995:35139", -- [23]
			"11899:52060:2995:35556:35562:35315", -- [24]
			"11899:52060:2995:35556:35478", -- [25]
			"11899:52060:2995:35556", -- [26]
			"11899:52060:2995:35556:35562", -- [27]
			"40769:7824:39175", -- [28]
			"11899:52060:39340", -- [29]
			"11899:52060:2995:40809", -- [30]
			"11899:52060:3615:40558", -- [31]
			"40769:7824:41215", -- [32]
			"11899:16227:3310:41140:41142", -- [33]
			"11899:16227:3310:41140", -- [34]
			"40769:7824:41214", -- [35]
			"11899:52060:3615:4312:41246", -- [36]
			"11899:16227:3310:43549:50084", -- [37]
			"11899:16227:3310:43549:50084:53783", -- [38]
			"11899:16227:3310:43549:50084:41861", -- [39]
			"44399:39898:41605:40473", -- [40]
			"44399:39898:41605", -- [41]
			"11899:52060:3615:34927:12616:22931:43073", -- [42]
			"11899:52060:3615:34927:12616:22931:43079", -- [43]
			"11899:52060:3615:34927:12616:22931:43073:43085", -- [44]
			"11899:16227:3310:37005", -- [45]
			"11899:16227:3310:8610:43328", -- [46]
			"11899:16227:3310:43549", -- [47]
			"40769:7824:41215:48275", -- [48]
			"40769:7824:39175:15178:48274", -- [49]
			"40769:7824:41215:48275:48273", -- [50]
			"11899:16227:3310:36728", -- [51]
			"11899:16227:3310:43549:50084:54393", -- [52]
			--["name"] = "Mudsprocket, Dustwallow Marsh",
			["m"] = 70,
			["coord"] = 1841609026,
			["direct"] = "44399:11899:39330:40769",
			["f"] = 0,
		},
		[12740] = {
			"43085:43073:22931:34429:4312:35139:2995", -- [1]
			"41861:50084:43549:3310", -- [2]
			"43085:43073:22931:12616:34927:3615", -- [3]
			"43085:43073:22931:34429:4312", -- [4]
			"43085:43073:22931:12616:34927:3615:44399", -- [5]
			"43085:43073:22931:34429:4312:6726", -- [6]
			"41861:50084:43549:3310:7824", -- [7]
			"43085:43073:22931:12616:34927:3615:52060:39330:39898", -- [8]
			"11139:8610", -- [9]
			"43085:43073:22931:12616:34927:3615:52060:11899", -- [10]
			"43085:43073:22931:34429:11901", -- [11]
			"43085:43073:22931:12616", -- [12]
			"43085:43073:22931:12616:34927:3615:52060:39330:39898:15178", -- [13]
			"43085:43073:22931:12616:34927:3615:52060", -- [14]
			"41861:50084:43549:3310:7824:10583", -- [15]
			"41861:50084:43549:3310:16227", -- [16]
			"43085:43073:22931", -- [17]
			"43085:43073:22931:12616:34927:3615:52060:39330:40358", -- [18]
			"43085:43073:22931:34429", -- [19]
			"43085:43073:22931:12616:34927", -- [20]
			"43085:43073:22931:34429:34943", -- [21]
			"43085:43073:22931:34429:35141", -- [22]
			"43085:43073:22931:34429:34943:35140", -- [23]
			"43085:43073:22931:34429:4312:35139", -- [24]
			"43085:43073:22931:34429:4312:35315", -- [25]
			"43085:43073:22931:34429:4312:35478", -- [26]
			"43085:43073:22931:34429:4312:35478:35556", -- [27]
			"43085:43073:22931:34429:4312:35315:35562", -- [28]
			"41861:50084:43549:3310:7824:39175", -- [29]
			"43085:43073:22931:12616:34927:3615:39340", -- [30]
			"43085:43073:22931:12616:34927:3615:52060:39330", -- [31]
			"43085:43073:22931:34429:4312:35139:2995:40809", -- [32]
			"41861:50084:43549:3310:40558", -- [33]
			"43085:43073:22931:12616:34927:3615:52060:39330:40358:40769", -- [34]
			"41861:50084:43549:3310:7824:41215", -- [35]
			"41861:50084:43549:3310:41140:41142", -- [36]
			"41861:50084:43549:3310:41140", -- [37]
			"41861:50084:43549:3310:7824:41214", -- [38]
			"43085:43073:22931:34429:35141:41246", -- [39]
			"41861:50084", -- [40]
			"41861:53783", -- [41]
			"43085:43073:22931:34429:4312:6726:40473", -- [42]
			"43085:43073:22931:12616:34927:3615:52060:39330:39898:41605", -- [43]
			"43085:43073", -- [44]
			"43085:43073:43079", -- [45]
			"11139:8610:37005", -- [46]
			"11139:8610:43328", -- [47]
			"41861:50084:43549", -- [48]
			"41861:50084:43549:3310:7824:41215:48275", -- [49]
			"43085:43073:22931:12616:34927:3615:52060:39330:39898:15178:48274", -- [50]
			"43085:43073:22931:12616:34927:3615:52060:39330:39898:15178:48274:48273", -- [51]
			"41861:50084:43549:36728", -- [52]
			"41861:50084:54393", -- [53]
			--["name"] = "Moonglade",
			["m"] = 80,
			["f"] = 0,
			["direct"] = "11139:41861:43085",
			["coord"] = 1380886992,
		},
		[41246] = {
			"4312:35139:2995", -- [1]
			"35140:34927:3310", -- [2]
			"4312:3615", -- [3]
			"4312:35139:2995:44399", -- [4]
			"4312:6726", -- [5]
			"4312:35139:2995:7824", -- [6]
			"4312:35139:2995:52060:39330:39898", -- [7]
			"35140:34943:12616:36728:8610", -- [8]
			"35141:34429:22931:43073:43085:11139", -- [9]
			"4312:35139:2995:52060:11899", -- [10]
			"35141:11901", -- [11]
			"35140:34943:12616", -- [12]
			"35141:34429:22931:43073:43085:12740", -- [13]
			"4312:6726:40473:41605:15178", -- [14]
			"4312:35139:2995:52060", -- [15]
			"4312:6726:40473:41605:15178:39175:10583", -- [16]
			"4312:3615:16227", -- [17]
			"35141:34429:22931", -- [18]
			"4312:35139:2995:52060:39330:40358", -- [19]
			"35141:34429", -- [20]
			"35140:34927", -- [21]
			"35140:34943", -- [22]
			"4312:35139", -- [23]
			"4312:35315", -- [24]
			"4312:35478", -- [25]
			"4312:35478:35556", -- [26]
			"4312:35315:35562", -- [27]
			"4312:6726:40473:41605:15178:39175", -- [28]
			"4312:35139:2995:39340", -- [29]
			"4312:35139:2995:52060:39330", -- [30]
			"4312:35139:2995:40809", -- [31]
			"35140:34927:40558", -- [32]
			"4312:35139:2995:52060:39330:40358:40769", -- [33]
			"4312:35139:2995:7824:41215", -- [34]
			"35140:34927:3310:41140:41142", -- [35]
			"35140:34927:3310:41140", -- [36]
			"4312:35139:2995:7824:41214", -- [37]
			"35140:34943:12616:36728:43549:50084", -- [38]
			"35140:34943:12616:36728:43549:50084:53783", -- [39]
			"35140:34943:12616:36728:43549:50084:41861", -- [40]
			"4312:6726:40473", -- [41]
			"4312:6726:40473:41605", -- [42]
			"35141:34429:22931:43073", -- [43]
			"35141:34429:22931:43079", -- [44]
			"35141:34429:22931:43073:43085", -- [45]
			"35140:34943:12616:36728:8610:37005", -- [46]
			"35140:34943:12616:36728:8610:43328", -- [47]
			"35140:34943:12616:36728:43549", -- [48]
			"4312:6726:40473:41605:15178:48274:48275", -- [49]
			"4312:6726:40473:41605:15178:48274", -- [50]
			"4312:6726:40473:41605:15178:48274:48273", -- [51]
			"35140:34943:12616:36728", -- [52]
			"35140:34943:12616:36728:43549:50084:54393", -- [53]
			--["name"] = "The Sludgewerks, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "4312:35141:35140",
			["coord"] = 2311153336,
		},
		[40809] = {
			"2995:3310", -- [1]
			"2995:3615", -- [2]
			"2995:35139:4312", -- [3]
			"2995:44399", -- [4]
			"2995:6726", -- [5]
			"2995:7824", -- [6]
			"2995:52060:39330:39898", -- [7]
			"2995:8610", -- [8]
			"2995:8610:11139", -- [9]
			"2995:52060:11899", -- [10]
			"2995:35139:35141:11901", -- [11]
			"2995:3615:34927:12616", -- [12]
			"2995:3615:34927:12616:22931:43073:43085:12740", -- [13]
			"2995:52060:39330:39898:15178", -- [14]
			"2995:52060", -- [15]
			"2995:7824:10583", -- [16]
			"2995:3615:16227", -- [17]
			"2995:3615:34927:12616:22931", -- [18]
			"2995:52060:39330:40358", -- [19]
			"2995:35139:4312:34429", -- [20]
			"2995:3615:34927", -- [21]
			"2995:35139:35140:34943", -- [22]
			"2995:35139:35141", -- [23]
			"2995:35139:35140", -- [24]
			"2995:35139", -- [25]
			"2995:35556:35562:35315", -- [26]
			"2995:35556:35478", -- [27]
			"2995:35556", -- [28]
			"2995:35556:35562", -- [29]
			"2995:7824:39175", -- [30]
			"2995:39340", -- [31]
			"2995:52060:39330", -- [32]
			"2995:3615:40558", -- [33]
			"2995:52060:39330:40358:40769", -- [34]
			"2995:7824:41215", -- [35]
			"2995:3310:41140:41142", -- [36]
			"2995:3310:41140", -- [37]
			"2995:7824:41214", -- [38]
			"2995:35139:4312:41246", -- [39]
			"2995:3310:43549:50084", -- [40]
			"2995:3310:43549:50084:53783", -- [41]
			"2995:3310:43549:50084:41861", -- [42]
			"2995:6726:40473", -- [43]
			"2995:52060:39330:39898:41605", -- [44]
			"2995:3615:34927:12616:22931:43073", -- [45]
			"2995:3615:34927:12616:22931:43079", -- [46]
			"2995:3615:34927:12616:22931:43073:43085", -- [47]
			"2995:3310:37005", -- [48]
			"2995:8610:43328", -- [49]
			"2995:3310:43549", -- [50]
			"2995:7824:41215:48275", -- [51]
			"2995:52060:39330:39898:15178:48274", -- [52]
			"2995:52060:39330:39898:15178:48274:48273", -- [53]
			"2995:3615:34927:12616:36728", -- [54]
			"2995:3310:43549:50084:54393", -- [55]
			--["name"] = "Bloodhoof Village, Mulgore",
			["m"] = 7,
			["f"] = 0,
			["direct"] = "2995",
			["coord"] = 2035783201,
		},
		[35141] = {
			"35139:2995", -- [1]
			"34429:12616:3310", -- [2]
			"35139:3615", -- [3]
			"35139:2995:44399", -- [4]
			"41246:4312:6726", -- [5]
			"35139:2995:7824", -- [6]
			"35139:2995:52060:39330:39898", -- [7]
			"34429:12616:36728:8610", -- [8]
			"34429:22931:43073:43085:11139", -- [9]
			"35139:2995:52060:11899", -- [10]
			"34429:12616", -- [11]
			"34429:22931:43073:43085:12740", -- [12]
			"41246:4312:6726:40473:41605:15178", -- [13]
			"35139:2995:52060", -- [14]
			"35139:2995:7824:10583", -- [15]
			"35139:3615:16227", -- [16]
			"34429:22931", -- [17]
			"35139:2995:52060:39330:40358", -- [18]
			"35140:34927", -- [19]
			"34429:34943", -- [20]
			"41246:4312:35315", -- [21]
			"41246:4312:35478", -- [22]
			"41246:4312:35478:35556", -- [23]
			"41246:4312:35315:35562", -- [24]
			"41246:4312:6726:40473:41605:15178:39175", -- [25]
			"35139:2995:39340", -- [26]
			"35139:2995:52060:39330", -- [27]
			"35139:2995:40809", -- [28]
			"35139:3615:40558", -- [29]
			"35139:2995:52060:39330:40358:40769", -- [30]
			"35139:2995:7824:41215", -- [31]
			"34429:12616:3310:41140:41142", -- [32]
			"34429:12616:3310:41140", -- [33]
			"35139:2995:7824:41214", -- [34]
			"34429:12616:36728:43549:50084", -- [35]
			"34429:12616:36728:43549:50084:53783", -- [36]
			"34429:12616:36728:43549:50084:41861", -- [37]
			"41246:4312:6726:40473", -- [38]
			"41246:4312:6726:40473:41605", -- [39]
			"34429:22931:43073", -- [40]
			"34429:22931:43079", -- [41]
			"34429:22931:43073:43085", -- [42]
			"34429:12616:36728:8610:37005", -- [43]
			"34429:12616:36728:8610:43328", -- [44]
			"34429:12616:36728:43549", -- [45]
			"41246:4312:6726:40473:41605:15178:48274:48275", -- [46]
			"41246:4312:6726:40473:41605:15178:48274", -- [47]
			"41246:4312:6726:40473:41605:15178:48274:48273", -- [48]
			"34429:12616:36728", -- [49]
			"34429:12616:36728:43549:50084:54393", -- [50]
			--["name"] = "Cliffwalker Post, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "4312:11901:34429:35140:35139:41246",
			["coord"] = 1936477991,
		},
		[39175] = {
			"7824:2995", -- [1]
			"7824:16227:3310", -- [2]
			"7824:3615", -- [3]
			"7824:2995:35139:4312", -- [4]
			"7824:44399", -- [5]
			"7824:39898:41605:40473:6726", -- [6]
			"7824:39898", -- [7]
			"7824:16227:3310:8610", -- [8]
			"7824:16227:3310:11139", -- [9]
			"7824:40769:40358:11899", -- [10]
			"7824:3615:34927:34429:11901", -- [11]
			"7824:3615:34927:12616", -- [12]
			"7824:16227:3310:43549:50084:41861:12740", -- [13]
			"7824:40769:40358:11899:52060", -- [14]
			"7824:16227", -- [15]
			"7824:3615:34927:12616:22931", -- [16]
			"7824:40769:40358", -- [17]
			"7824:3615:34927:34429", -- [18]
			"7824:3615:34927", -- [19]
			"7824:3615:34927:34943", -- [20]
			"7824:2995:35139:35141", -- [21]
			"7824:2995:35139:35140", -- [22]
			"7824:2995:35139", -- [23]
			"7824:2995:35556:35562:35315", -- [24]
			"7824:2995:35556:35478", -- [25]
			"7824:2995:35556", -- [26]
			"7824:2995:35556:35562", -- [27]
			"7824:40769:40358:11899:52060:39340", -- [28]
			"7824:40769:40358:39330", -- [29]
			"7824:2995:40809", -- [30]
			"7824:3615:40558", -- [31]
			"7824:40769", -- [32]
			"7824:41215", -- [33]
			"7824:16227:3310:41140:41142", -- [34]
			"7824:16227:3310:41140", -- [35]
			"7824:41214", -- [36]
			"7824:2995:35139:4312:41246", -- [37]
			"7824:16227:3310:43549:50084", -- [38]
			"7824:16227:3310:43549:50084:53783", -- [39]
			"7824:16227:3310:43549:50084:41861", -- [40]
			"7824:39898:41605:40473", -- [41]
			"7824:39898:41605", -- [42]
			"7824:3615:34927:12616:22931:43073", -- [43]
			"7824:3615:34927:12616:22931:43079", -- [44]
			"7824:3615:34927:12616:22931:43073:43085", -- [45]
			"7824:16227:3310:37005", -- [46]
			"7824:16227:3310:8610:43328", -- [47]
			"7824:16227:3310:43549", -- [48]
			"7824:41215:48275", -- [49]
			"7824:41215:48275:48274", -- [50]
			"7824:41215:48275:48273", -- [51]
			"7824:16227:3310:36728", -- [52]
			"7824:16227:3310:43549:50084:54393", -- [53]
			--["name"] = "Mossy Pile, Un'Goro Crater",
			["m"] = 78,
			["coord"] = 1890412268,
			["direct"] = "7824:10583",
			["f"] = 0,
		},
		[43085] = {
			"43073:22931:34429:4312:35139:2995", -- [1]
			"43073:22931:12616:3310", -- [2]
			"43073:22931:12616:34927:3615", -- [3]
			"43073:22931:34429:4312", -- [4]
			"43073:22931:12616:34927:3615:44399", -- [5]
			"43073:22931:34429:4312:6726", -- [6]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824", -- [7]
			"43073:22931:12616:34927:3615:52060:39330:39898", -- [8]
			"11139:8610", -- [9]
			"43073:22931:12616:34927:3615:52060:11899", -- [10]
			"43073:22931:34429:11901", -- [11]
			"43073:22931:12616", -- [12]
			"43073:22931:12616:34927:3615:52060:39330:39898:15178", -- [13]
			"43073:22931:12616:34927:3615:52060", -- [14]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:10583", -- [15]
			"43073:22931:12616:34927:3615:16227", -- [16]
			"43073:22931", -- [17]
			"43073:22931:12616:34927:3615:52060:39330:40358", -- [18]
			"43073:22931:34429", -- [19]
			"43073:22931:12616:34927", -- [20]
			"43073:22931:34429:34943", -- [21]
			"43073:22931:34429:35141", -- [22]
			"43073:22931:34429:34943:35140", -- [23]
			"43073:22931:34429:4312:35139", -- [24]
			"43073:22931:34429:4312:35315", -- [25]
			"43073:22931:34429:4312:35478", -- [26]
			"43073:22931:34429:4312:35478:35556", -- [27]
			"43073:22931:34429:4312:35315:35562", -- [28]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:39175", -- [29]
			"43073:22931:12616:34927:3615:39340", -- [30]
			"43073:22931:12616:34927:3615:52060:39330", -- [31]
			"43073:22931:34429:4312:35139:2995:40809", -- [32]
			"43073:22931:12616:34927:40558", -- [33]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769", -- [34]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:41215", -- [35]
			"43073:22931:12616:3310:41140:41142", -- [36]
			"43073:22931:12616:3310:41140", -- [37]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:41214", -- [38]
			"43073:22931:34429:35141:41246", -- [39]
			"12740:41861:50084", -- [40]
			"12740:41861:53783", -- [41]
			"12740:41861", -- [42]
			"43073:22931:34429:4312:6726:40473", -- [43]
			"43073:22931:12616:34927:3615:52060:39330:39898:41605", -- [44]
			"43073:43079", -- [45]
			"11139:8610:37005", -- [46]
			"11139:8610:43328", -- [47]
			"12740:41861:50084:43549", -- [48]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:41215:48275", -- [49]
			"43073:22931:12616:34927:3615:52060:39330:39898:15178:48274", -- [50]
			"43073:22931:12616:34927:3615:52060:39330:39898:15178:48274:48273", -- [51]
			"43073:22931:12616:36728", -- [52]
			"12740:41861:50084:54393", -- [53]
			--["name"] = "Irontree Clearing, Felwood",
			["m"] = 77,
			["f"] = 0,
			["direct"] = "11139:12740:43073",
			["coord"] = 2421691862,
		},
		[54393] = {
			"50084:43549:3310:3615:2995", -- [1]
			"50084:43549:3310", -- [2]
			"50084:43549:3310:3615", -- [3]
			"50084:43549:36728:12616:34943:35140:4312", -- [4]
			"50084:43549:3310:3615:44399", -- [5]
			"50084:43549:36728:12616:34943:35140:4312:6726", -- [6]
			"50084:43549:3310:7824", -- [7]
			"50084:43549:3310:3615:52060:39330:39898", -- [8]
			"50084:43549:36728:8610", -- [9]
			"50084:41861:11139", -- [10]
			"50084:43549:3310:16227:11899", -- [11]
			"50084:43549:36728:12616:34429:11901", -- [12]
			"50084:43549:36728:12616", -- [13]
			"50084:41861:12740", -- [14]
			"50084:43549:3310:3615:52060:39330:39898:15178", -- [15]
			"50084:43549:3310:3615:52060", -- [16]
			"50084:43549:3310:7824:10583", -- [17]
			"50084:43549:3310:16227", -- [18]
			"50084:43549:36728:12616:22931", -- [19]
			"50084:43549:3310:16227:11899:40358", -- [20]
			"50084:43549:36728:12616:34429", -- [21]
			"50084:43549:36728:12616:34927", -- [22]
			"50084:43549:36728:12616:34943", -- [23]
			"50084:43549:36728:12616:34429:35141", -- [24]
			"50084:43549:36728:12616:34943:35140", -- [25]
			"50084:43549:36728:12616:34943:35140:35139", -- [26]
			"50084:43549:36728:12616:34943:35140:4312:35315", -- [27]
			"50084:43549:36728:12616:34943:35140:4312:35478", -- [28]
			"50084:43549:3310:3615:2995:35556", -- [29]
			"50084:43549:36728:12616:34943:35140:4312:35315:35562", -- [30]
			"50084:43549:3310:7824:39175", -- [31]
			"50084:43549:3310:3615:39340", -- [32]
			"50084:43549:3310:3615:52060:39330", -- [33]
			"50084:43549:3310:3615:2995:40809", -- [34]
			"50084:43549:3310:40558", -- [35]
			"50084:43549:3310:16227:11899:40358:40769", -- [36]
			"50084:43549:3310:7824:41215", -- [37]
			"50084:43549:3310:41140:41142", -- [38]
			"50084:43549:3310:41140", -- [39]
			"50084:43549:3310:7824:41214", -- [40]
			"50084:43549:36728:12616:34943:35140:41246", -- [41]
			"50084:53783", -- [42]
			"50084:41861", -- [43]
			"50084:43549:36728:12616:34943:35140:4312:6726:40473", -- [44]
			"50084:43549:3310:3615:52060:39330:39898:41605", -- [45]
			"50084:41861:12740:43085:43073", -- [46]
			"50084:43549:36728:12616:22931:43079", -- [47]
			"50084:41861:12740:43085", -- [48]
			"50084:43549:36728:8610:37005", -- [49]
			"50084:43549:36728:8610:43328", -- [50]
			"50084:43549", -- [51]
			"50084:43549:3310:7824:41215:48275", -- [52]
			"50084:43549:3310:3615:52060:39330:39898:15178:48274", -- [53]
			"50084:43549:3310:3615:52060:39330:39898:15178:48274:48273", -- [54]
			"50084:43549:36728", -- [55]
			--["name"] = "Sanctuary of Malorne, Hyjal",
			["m"] = 198,
			["f"] = 0,
			["direct"] = "50084",
			["coord"] = 1192010387,
		},
		[43073] = {
			"22931:34429:4312:35139:2995", -- [1]
			"22931:12616:3310", -- [2]
			"22931:12616:34927:3615", -- [3]
			"22931:34429:4312", -- [4]
			"22931:12616:34927:3615:44399", -- [5]
			"22931:34429:4312:6726", -- [6]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824", -- [7]
			"22931:12616:34927:3615:52060:39330:39898", -- [8]
			"43085:11139:8610", -- [9]
			"43085:11139", -- [10]
			"22931:12616:34927:3615:52060:11899", -- [11]
			"22931:34429:11901", -- [12]
			"22931:12616", -- [13]
			"43085:12740", -- [14]
			"22931:12616:34927:3615:52060:39330:39898:15178", -- [15]
			"22931:12616:34927:3615:52060", -- [16]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:10583", -- [17]
			"22931:12616:34927:3615:16227", -- [18]
			"22931:12616:34927:3615:52060:39330:40358", -- [19]
			"22931:34429", -- [20]
			"22931:12616:34927", -- [21]
			"22931:34429:34943", -- [22]
			"22931:34429:35141", -- [23]
			"22931:34429:34943:35140", -- [24]
			"22931:34429:4312:35139", -- [25]
			"22931:34429:4312:35315", -- [26]
			"22931:34429:4312:35478", -- [27]
			"22931:34429:4312:35478:35556", -- [28]
			"22931:34429:4312:35315:35562", -- [29]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:39175", -- [30]
			"22931:12616:34927:3615:39340", -- [31]
			"22931:12616:34927:3615:52060:39330", -- [32]
			"22931:34429:4312:35139:2995:40809", -- [33]
			"22931:12616:34927:40558", -- [34]
			"22931:12616:34927:3615:52060:39330:40358:40769", -- [35]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:41215", -- [36]
			"22931:12616:3310:41140:41142", -- [37]
			"22931:12616:3310:41140", -- [38]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:41214", -- [39]
			"22931:34429:35141:41246", -- [40]
			"43085:12740:41861:50084", -- [41]
			"43085:12740:41861:53783", -- [42]
			"43085:12740:41861", -- [43]
			"22931:34429:4312:6726:40473", -- [44]
			"22931:12616:34927:3615:52060:39330:39898:41605", -- [45]
			"43085:11139:8610:37005", -- [46]
			"43085:11139:8610:43328", -- [47]
			"22931:12616:36728:43549", -- [48]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:41215:48275", -- [49]
			"22931:12616:34927:3615:52060:39330:39898:15178:48274", -- [50]
			"22931:12616:34927:3615:52060:39330:39898:15178:48274:48273", -- [51]
			"22931:12616:36728", -- [52]
			"43085:12740:41861:50084:54393", -- [53]
			--["name"] = "Whisperwind Grove, Felwood",
			["m"] = 77,
			["f"] = 0,
			["direct"] = "22931:43079:43085",
			["coord"] = 1872382313,
		},
		[36728] = {
			"3310:3615:2995", -- [1]
			"3310:3615", -- [2]
			"12616:34943:35140:4312", -- [3]
			"3310:3615:44399", -- [4]
			"12616:34943:35140:4312:6726", -- [5]
			"3310:7824", -- [6]
			"3310:3615:52060:39330:39898", -- [7]
			"8610:11139", -- [8]
			"3310:16227:11899", -- [9]
			"12616:34429:11901", -- [10]
			"43549:50084:41861:12740", -- [11]
			"3310:3615:52060:39330:39898:15178", -- [12]
			"3310:3615:52060", -- [13]
			"3310:7824:10583", -- [14]
			"3310:16227", -- [15]
			"12616:22931", -- [16]
			"3310:16227:11899:40358", -- [17]
			"12616:34429", -- [18]
			"12616:34927", -- [19]
			"12616:34943", -- [20]
			"12616:34429:35141", -- [21]
			"12616:34943:35140", -- [22]
			"12616:34943:35140:35139", -- [23]
			"12616:34943:35140:4312:35315", -- [24]
			"12616:34943:35140:4312:35478", -- [25]
			"3310:3615:2995:35556", -- [26]
			"12616:34943:35140:4312:35315:35562", -- [27]
			"3310:7824:39175", -- [28]
			"3310:3615:39340", -- [29]
			"3310:3615:52060:39330", -- [30]
			"3310:3615:2995:40809", -- [31]
			"3310:40558", -- [32]
			"3310:16227:11899:40358:40769", -- [33]
			"3310:7824:41215", -- [34]
			"3310:41140:41142", -- [35]
			"3310:41140", -- [36]
			"3310:7824:41214", -- [37]
			"12616:34943:35140:41246", -- [38]
			"43549:50084", -- [39]
			"43549:50084:53783", -- [40]
			"43549:50084:41861", -- [41]
			"12616:34943:35140:4312:6726:40473", -- [42]
			"3310:3615:52060:39330:39898:41605", -- [43]
			"12616:22931:43073", -- [44]
			"12616:22931:43079", -- [45]
			"12616:22931:43073:43085", -- [46]
			"8610:37005", -- [47]
			"8610:43328", -- [48]
			"3310:7824:41215:48275", -- [49]
			"3310:3615:52060:39330:39898:15178:48274", -- [50]
			"3310:3615:52060:39330:39898:15178:48274:48273", -- [51]
			"43549:50084:54393", -- [52]
			--["name"] = "Valormok, Azshara",
			["m"] = 76,
			["f"] = 0,
			["direct"] = "3310:8610:12616:43549",
			["coord"] = 614114972,
		},
		[41140] = {
			"3310:3615:2995", -- [1]
			"3310:3615", -- [2]
			"3310:3615:4312", -- [3]
			"3310:3615:44399", -- [4]
			"3310:3615:2995:6726", -- [5]
			"3310:7824", -- [6]
			"3310:3615:52060:39330:39898", -- [7]
			"3310:8610", -- [8]
			"3310:11139", -- [9]
			"3310:16227:11899", -- [10]
			"3310:12616:34429:11901", -- [11]
			"3310:12616", -- [12]
			"3310:43549:50084:41861:12740", -- [13]
			"3310:3615:52060:39330:39898:15178", -- [14]
			"3310:3615:52060", -- [15]
			"3310:7824:10583", -- [16]
			"3310:16227", -- [17]
			"3310:12616:22931", -- [18]
			"3310:16227:11899:40358", -- [19]
			"3310:12616:34429", -- [20]
			"3310:34927", -- [21]
			"3310:12616:34943", -- [22]
			"3310:12616:34429:35141", -- [23]
			"3310:12616:34943:35140", -- [24]
			"3310:3615:35139", -- [25]
			"3310:3615:2995:35556:35562:35315", -- [26]
			"3310:3615:2995:35556:35478", -- [27]
			"3310:3615:2995:35556", -- [28]
			"3310:3615:2995:35556:35562", -- [29]
			"3310:7824:39175", -- [30]
			"3310:3615:39340", -- [31]
			"3310:3615:52060:39330", -- [32]
			"3310:3615:2995:40809", -- [33]
			"3310:40558", -- [34]
			"3310:16227:11899:40358:40769", -- [35]
			"3310:7824:41215", -- [36]
			"3310:7824:41214", -- [37]
			"3310:12616:34943:35140:41246", -- [38]
			"3310:43549:50084", -- [39]
			"3310:43549:50084:53783", -- [40]
			"3310:43549:50084:41861", -- [41]
			"3310:3615:2995:6726:40473", -- [42]
			"3310:3615:52060:39330:39898:41605", -- [43]
			"3310:12616:22931:43073", -- [44]
			"3310:12616:22931:43079", -- [45]
			"3310:12616:22931:43073:43085", -- [46]
			"3310:37005", -- [47]
			"3310:8610:43328", -- [48]
			"3310:43549", -- [49]
			"3310:7824:41215:48275", -- [50]
			"3310:3615:52060:39330:39898:15178:48274", -- [51]
			"3310:3615:52060:39330:39898:15178:48274:48273", -- [52]
			"3310:36728", -- [53]
			"3310:43549:50084:54393", -- [54]
			--["name"] = "Razor Hill, Durotar",
			["m"] = 1,
			["f"] = 0,
			["direct"] = "3310:41142",
			["coord"] = 2277863354,
		},
		[41142] = {
			"41140:3310:3615:2995", -- [1]
			"41140:3310", -- [2]
			"41140:3310:3615", -- [3]
			"41140:3310:3615:4312", -- [4]
			"41140:3310:3615:44399", -- [5]
			"41140:3310:3615:2995:6726", -- [6]
			"41140:3310:7824", -- [7]
			"41140:3310:3615:52060:39330:39898", -- [8]
			"41140:3310:8610", -- [9]
			"41140:3310:11139", -- [10]
			"41140:3310:16227:11899", -- [11]
			"41140:3310:12616:34429:11901", -- [12]
			"41140:3310:12616", -- [13]
			"41140:3310:43549:50084:41861:12740", -- [14]
			"41140:3310:3615:52060:39330:39898:15178", -- [15]
			"41140:3310:3615:52060", -- [16]
			"41140:3310:7824:10583", -- [17]
			"41140:3310:16227", -- [18]
			"41140:3310:12616:22931", -- [19]
			"41140:3310:16227:11899:40358", -- [20]
			"41140:3310:12616:34429", -- [21]
			"41140:3310:34927", -- [22]
			"41140:3310:12616:34943", -- [23]
			"41140:3310:12616:34429:35141", -- [24]
			"41140:3310:12616:34943:35140", -- [25]
			"41140:3310:3615:35139", -- [26]
			"41140:3310:3615:2995:35556:35562:35315", -- [27]
			"41140:3310:3615:2995:35556:35478", -- [28]
			"41140:3310:3615:2995:35556", -- [29]
			"41140:3310:3615:2995:35556:35562", -- [30]
			"41140:3310:7824:39175", -- [31]
			"41140:3310:3615:39340", -- [32]
			"41140:3310:3615:52060:39330", -- [33]
			"41140:3310:3615:2995:40809", -- [34]
			"41140:3310:40558", -- [35]
			"41140:3310:16227:11899:40358:40769", -- [36]
			"41140:3310:7824:41215", -- [37]
			"41140:3310:7824:41214", -- [38]
			"41140:3310:12616:34943:35140:41246", -- [39]
			"41140:3310:43549:50084", -- [40]
			"41140:3310:43549:50084:53783", -- [41]
			"41140:3310:43549:50084:41861", -- [42]
			"41140:3310:3615:2995:6726:40473", -- [43]
			"41140:3310:3615:52060:39330:39898:41605", -- [44]
			"41140:3310:12616:22931:43073", -- [45]
			"41140:3310:12616:22931:43079", -- [46]
			"41140:3310:12616:22931:43073:43085", -- [47]
			"41140:3310:37005", -- [48]
			"41140:3310:8610:43328", -- [49]
			"41140:3310:43549", -- [50]
			"41140:3310:7824:41215:48275", -- [51]
			"41140:3310:3615:52060:39330:39898:15178:48274", -- [52]
			"41140:3310:3615:52060:39330:39898:15178:48274:48273", -- [53]
			"41140:3310:36728", -- [54]
			"41140:3310:43549:50084:54393", -- [55]
			--["name"] = "Sen'jin Village, Durotar",
			["m"] = 1,
			["f"] = 0,
			["direct"] = "41140",
			["coord"] = 2378218495,
		},
		[48274] = {
			"15178:39898:44399:2995", -- [1]
			"15178:39898:44399:11899:16227:3310", -- [2]
			"15178:39898:39330:52060:3615", -- [3]
			"15178:41605:40473:6726:35478:4312", -- [4]
			"15178:39898:44399", -- [5]
			"15178:41605:40473:6726", -- [6]
			"15178:39175:7824", -- [7]
			"15178:39898", -- [8]
			"15178:39898:39330:52060:3615:8610", -- [9]
			"15178:39898:44399:11899:16227:3310:11139", -- [10]
			"15178:39898:44399:11899", -- [11]
			"15178:41605:40473:6726:35478:4312:11901", -- [12]
			"15178:39898:39330:52060:3615:34927:12616", -- [13]
			"15178:39898:39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [14]
			"15178:39898:39330:52060", -- [15]
			"15178:39175:10583", -- [16]
			"15178:39898:44399:11899:16227", -- [17]
			"15178:39898:39330:52060:3615:34927:12616:22931", -- [18]
			"15178:39898:44399:40358", -- [19]
			"15178:39898:39330:52060:3615:34927:34429", -- [20]
			"15178:39898:39330:52060:3615:34927", -- [21]
			"15178:39898:39330:52060:3615:34927:34943", -- [22]
			"15178:41605:40473:6726:35478:4312:35141", -- [23]
			"15178:41605:40473:6726:35478:4312:35140", -- [24]
			"15178:41605:40473:6726:35139", -- [25]
			"15178:41605:40473:6726:35315", -- [26]
			"15178:41605:40473:6726:35478", -- [27]
			"15178:41605:40473:6726:35478:35556", -- [28]
			"15178:41605:40473:6726:35315:35562", -- [29]
			"15178:39175", -- [30]
			"15178:39898:39330:39340", -- [31]
			"15178:39898:39330", -- [32]
			"15178:39898:44399:2995:40809", -- [33]
			"15178:39898:39330:52060:3615:40558", -- [34]
			"15178:39175:7824:40769", -- [35]
			"48275:41215", -- [36]
			"15178:39898:44399:11899:16227:3310:41140:41142", -- [37]
			"15178:39898:44399:11899:16227:3310:41140", -- [38]
			"48275:41215:41214", -- [39]
			"15178:41605:40473:6726:35478:4312:41246", -- [40]
			"15178:39898:44399:11899:16227:3310:43549:50084", -- [41]
			"15178:39898:44399:11899:16227:3310:43549:50084:53783", -- [42]
			"15178:39898:44399:11899:16227:3310:43549:50084:41861", -- [43]
			"15178:41605:40473", -- [44]
			"15178:41605", -- [45]
			"15178:39898:39330:52060:3615:34927:12616:22931:43073", -- [46]
			"15178:39898:39330:52060:3615:34927:12616:22931:43079", -- [47]
			"15178:39898:39330:52060:3615:34927:12616:22931:43073:43085", -- [48]
			"15178:39898:44399:11899:16227:3310:37005", -- [49]
			"15178:39898:39330:52060:3615:8610:43328", -- [50]
			"15178:39898:44399:11899:16227:3310:43549", -- [51]
			"15178:39898:39330:52060:3615:34927:12616:36728", -- [52]
			"15178:39898:44399:11899:16227:3310:43549:50084:54393", -- [53]
			--["name"] = "Oasis of Vir'sar, Uldum",
			["m"] = 249,
			["coord"] = 1144395128,
			["direct"] = "15178:48275:48273",
			["f"] = 0,
		},
		[11899] = {
			"52060:3615:4312", -- [1]
			"52060:2995:6726", -- [2]
			"39330:39898", -- [3]
			"16227:3310:8610", -- [4]
			"16227:3310:11139", -- [5]
			"52060:3615:34927:34429:11901", -- [6]
			"52060:3615:34927:12616", -- [7]
			"52060:3615:34927:12616:22931:43073:43085:12740", -- [8]
			"39330:39898:15178", -- [9]
			"40358:40769:7824:10583", -- [10]
			"52060:3615:34927:12616:22931", -- [11]
			"52060:3615:34927:34429", -- [12]
			"52060:3615:34927", -- [13]
			"52060:3615:34927:34943", -- [14]
			"52060:3615:4312:35141", -- [15]
			"52060:2995:35139:35140", -- [16]
			"52060:2995:35139", -- [17]
			"52060:2995:35556:35562:35315", -- [18]
			"52060:2995:35556:35478", -- [19]
			"52060:2995:35556", -- [20]
			"52060:2995:35556:35562", -- [21]
			"40358:40769:7824:39175", -- [22]
			"52060:39340", -- [23]
			"52060:2995:40809", -- [24]
			"52060:3615:40558", -- [25]
			"40358:40769", -- [26]
			"40358:40769:7824:41215", -- [27]
			"16227:3310:41140:41142", -- [28]
			"16227:3310:41140", -- [29]
			"40358:40769:7824:41214", -- [30]
			"52060:3615:4312:41246", -- [31]
			"16227:3310:43549:50084", -- [32]
			"16227:3310:43549:50084:53783", -- [33]
			"16227:3310:43549:50084:41861", -- [34]
			"39330:39898:41605:40473", -- [35]
			"39330:39898:41605", -- [36]
			"52060:3615:34927:12616:22931:43073", -- [37]
			"52060:3615:34927:12616:22931:43079", -- [38]
			"52060:3615:34927:12616:22931:43073:43085", -- [39]
			"16227:3310:37005", -- [40]
			"16227:3310:8610:43328", -- [41]
			"16227:3310:43549", -- [42]
			"40358:40769:7824:41215:48275", -- [43]
			"39330:39898:15178:48274", -- [44]
			"40358:40769:7824:41215:48275:48273", -- [45]
			"16227:3310:36728", -- [46]
			"16227:3310:43549:50084:54393", -- [47]
			--["name"] = "Brackenwall Village, Dustwallow Marsh",
			["m"] = 70,
			["f"] = 0,
			["direct"] = "2995:3310:3615:44399:7824:52060:16227:40358:39330",
			["coord"] = 1527533948,
		},
		[35478] = {
			"35556:2995", -- [1]
			"35556:2995:3310", -- [2]
			"35556:2995:3615", -- [3]
			"35556:2995:44399", -- [4]
			"35556:2995:7824", -- [5]
			"6726:39898", -- [6]
			"35556:2995:8610", -- [7]
			"35556:2995:8610:11139", -- [8]
			"35556:2995:52060:11899", -- [9]
			"4312:11901", -- [10]
			"4312:35140:34943:12616", -- [11]
			"4312:34429:22931:43073:43085:12740", -- [12]
			"6726:40473:41605:15178", -- [13]
			"35556:2995:52060", -- [14]
			"6726:40473:41605:15178:39175:10583", -- [15]
			"35556:2995:3615:16227", -- [16]
			"4312:34429:22931", -- [17]
			"35556:2995:52060:39330:40358", -- [18]
			"4312:34429", -- [19]
			"35556:2995:3615:34927", -- [20]
			"4312:35140:34943", -- [21]
			"4312:35141", -- [22]
			"4312:35140", -- [23]
			"35556:2995:35139", -- [24]
			"6726:40473:41605:15178:39175", -- [25]
			"35556:2995:39340", -- [26]
			"35556:2995:52060:39330", -- [27]
			"35556:2995:40809", -- [28]
			"35556:2995:3615:40558", -- [29]
			"35556:2995:52060:39330:40358:40769", -- [30]
			"35556:2995:7824:41215", -- [31]
			"35556:2995:3310:41140:41142", -- [32]
			"35556:2995:3310:41140", -- [33]
			"35556:2995:7824:41214", -- [34]
			"4312:41246", -- [35]
			"35556:2995:3310:43549:50084", -- [36]
			"35556:2995:3310:43549:50084:53783", -- [37]
			"35556:2995:3310:43549:50084:41861", -- [38]
			"6726:40473", -- [39]
			"6726:40473:41605", -- [40]
			"4312:34429:22931:43073", -- [41]
			"4312:34429:22931:43079", -- [42]
			"4312:34429:22931:43073:43085", -- [43]
			"35556:2995:3310:37005", -- [44]
			"35556:2995:8610:43328", -- [45]
			"35556:2995:3310:43549", -- [46]
			"6726:40473:41605:15178:48274:48275", -- [47]
			"6726:40473:41605:15178:48274", -- [48]
			"6726:40473:41605:15178:48274:48273", -- [49]
			"4312:35140:34943:12616:36728", -- [50]
			"35556:2995:3310:43549:50084:54393", -- [51]
			--["name"] = "Karnum's Glade, Desolace",
			["m"] = 66,
			["coord"] = 2479390534,
			["direct"] = "4312:6726:35315:35556:35562",
			["f"] = 0,
		},
		[4312] = {
			"3615:3310", -- [1]
			"35139:2995:44399", -- [2]
			"35139:2995:7824", -- [3]
			"35139:2995:52060:39330:39898", -- [4]
			"35140:34943:12616:36728:8610", -- [5]
			"34429:22931:43073:43085:11139", -- [6]
			"35139:2995:52060:11899", -- [7]
			"35140:34943:12616", -- [8]
			"34429:22931:43073:43085:12740", -- [9]
			"6726:40473:41605:15178", -- [10]
			"35139:2995:52060", -- [11]
			"6726:40473:41605:15178:39175:10583", -- [12]
			"3615:16227", -- [13]
			"34429:22931", -- [14]
			"35139:2995:52060:39330:40358", -- [15]
			"35140:34927", -- [16]
			"35140:34943", -- [17]
			"35478:35556", -- [18]
			"35315:35562", -- [19]
			"6726:40473:41605:15178:39175", -- [20]
			"35139:2995:39340", -- [21]
			"35139:2995:52060:39330", -- [22]
			"35139:2995:40809", -- [23]
			"3615:40558", -- [24]
			"35139:2995:52060:39330:40358:40769", -- [25]
			"35139:2995:7824:41215", -- [26]
			"3615:3310:41140:41142", -- [27]
			"3615:3310:41140", -- [28]
			"35139:2995:7824:41214", -- [29]
			"35140:34943:12616:36728:43549:50084", -- [30]
			"35140:34943:12616:36728:43549:50084:53783", -- [31]
			"35140:34943:12616:36728:43549:50084:41861", -- [32]
			"6726:40473", -- [33]
			"6726:40473:41605", -- [34]
			"34429:22931:43073", -- [35]
			"34429:22931:43079", -- [36]
			"34429:22931:43073:43085", -- [37]
			"35140:34943:12616:36728:8610:37005", -- [38]
			"35140:34943:12616:36728:8610:43328", -- [39]
			"35140:34943:12616:36728:43549", -- [40]
			"6726:40473:41605:15178:48274:48275", -- [41]
			"6726:40473:41605:15178:48274", -- [42]
			"6726:40473:41605:15178:48274:48273", -- [43]
			"35140:34943:12616:36728", -- [44]
			"35140:34943:12616:36728:43549:50084:54393", -- [45]
			--["name"] = "Sun Rock Retreat, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "2995:3615:6726:11901:34429:35141:35140:35139:35315:35478:41246",
			["coord"] = 2083298982,
		},
		[41215] = {
			"7824:2995", -- [1]
			"7824:16227:3310", -- [2]
			"7824:3615", -- [3]
			"7824:2995:35139:4312", -- [4]
			"7824:44399", -- [5]
			"48275:48274:15178:41605:40473:6726", -- [6]
			"7824:39898", -- [7]
			"7824:16227:3310:8610", -- [8]
			"7824:16227:3310:11139", -- [9]
			"7824:40769:40358:11899", -- [10]
			"7824:3615:34927:34429:11901", -- [11]
			"7824:3615:34927:12616", -- [12]
			"7824:16227:3310:43549:50084:41861:12740", -- [13]
			"48275:48274:15178", -- [14]
			"7824:40769:40358:11899:52060", -- [15]
			"7824:10583", -- [16]
			"7824:16227", -- [17]
			"7824:3615:34927:12616:22931", -- [18]
			"7824:40769:40358", -- [19]
			"7824:3615:34927:34429", -- [20]
			"7824:3615:34927", -- [21]
			"7824:3615:34927:34943", -- [22]
			"7824:2995:35139:35141", -- [23]
			"7824:2995:35139:35140", -- [24]
			"7824:2995:35139", -- [25]
			"48275:48274:15178:41605:40473:6726:35315", -- [26]
			"7824:2995:35556:35478", -- [27]
			"7824:2995:35556", -- [28]
			"7824:2995:35556:35562", -- [29]
			"7824:39175", -- [30]
			"7824:40769:40358:11899:52060:39340", -- [31]
			"7824:40769:40358:39330", -- [32]
			"7824:2995:40809", -- [33]
			"7824:3615:40558", -- [34]
			"7824:40769", -- [35]
			"7824:16227:3310:41140:41142", -- [36]
			"7824:16227:3310:41140", -- [37]
			"7824:2995:35139:4312:41246", -- [38]
			"7824:16227:3310:43549:50084", -- [39]
			"7824:16227:3310:43549:50084:53783", -- [40]
			"7824:16227:3310:43549:50084:41861", -- [41]
			"48275:48274:15178:41605:40473", -- [42]
			"48275:48274:15178:41605", -- [43]
			"7824:3615:34927:12616:22931:43073", -- [44]
			"7824:3615:34927:12616:22931:43079", -- [45]
			"7824:3615:34927:12616:22931:43073:43085", -- [46]
			"7824:16227:3310:37005", -- [47]
			"7824:16227:3310:8610:43328", -- [48]
			"7824:16227:3310:43549", -- [49]
			"48275:48274", -- [50]
			"48275:48273", -- [51]
			"7824:16227:3310:36728", -- [52]
			"7824:16227:3310:43549:50084:54393", -- [53]
			--["name"] = "Dawnrise Expedition, Tanaris",
			["m"] = 71,
			["coord"] = 1431946726,
			["direct"] = "7824:41214:48275",
			["f"] = 0,
		},
		[48273] = {
			"48274:15178:39898:44399:2995", -- [1]
			"48275:41215:7824:16227:3310", -- [2]
			"48274:15178:39898:39330:52060:3615", -- [3]
			"48274:15178:41605:40473:6726:35478:4312", -- [4]
			"48274:15178:39898:44399", -- [5]
			"48274:15178:41605:40473:6726", -- [6]
			"48275:41215:7824", -- [7]
			"48274:15178:39898", -- [8]
			"48275:41215:7824:16227:3310:8610", -- [9]
			"48275:41215:7824:16227:3310:11139", -- [10]
			"48274:15178:39898:44399:11899", -- [11]
			"48274:15178:41605:40473:6726:35478:4312:11901", -- [12]
			"48274:15178:39898:39330:52060:3615:34927:12616", -- [13]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [14]
			"48274:15178", -- [15]
			"48274:15178:39898:39330:52060", -- [16]
			"48274:15178:39175:10583", -- [17]
			"48275:41215:7824:16227", -- [18]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931", -- [19]
			"48275:41215:7824:40769:40358", -- [20]
			"48274:15178:39898:39330:52060:3615:34927:34429", -- [21]
			"48274:15178:39898:39330:52060:3615:34927", -- [22]
			"48274:15178:39898:39330:52060:3615:34927:34943", -- [23]
			"48274:15178:41605:40473:6726:35478:4312:35141", -- [24]
			"48274:15178:41605:40473:6726:35478:4312:35140", -- [25]
			"48274:15178:41605:40473:6726:35139", -- [26]
			"48274:15178:41605:40473:6726:35315", -- [27]
			"48274:15178:41605:40473:6726:35478", -- [28]
			"48274:15178:41605:40473:6726:35478:35556", -- [29]
			"48274:15178:41605:40473:6726:35315:35562", -- [30]
			"48274:15178:39175", -- [31]
			"48274:15178:39898:39330:39340", -- [32]
			"48274:15178:39898:39330", -- [33]
			"48274:15178:39898:44399:2995:40809", -- [34]
			"48274:15178:39898:39330:52060:3615:40558", -- [35]
			"48275:41215:7824:40769", -- [36]
			"48275:41215", -- [37]
			"48275:41215:7824:16227:3310:41140:41142", -- [38]
			"48275:41215:7824:16227:3310:41140", -- [39]
			"48275:41215:41214", -- [40]
			"48274:15178:41605:40473:6726:35478:4312:41246", -- [41]
			"48275:41215:7824:16227:3310:43549:50084", -- [42]
			"48275:41215:7824:16227:3310:43549:50084:53783", -- [43]
			"48275:41215:7824:16227:3310:43549:50084:41861", -- [44]
			"48274:15178:41605:40473", -- [45]
			"48274:15178:41605", -- [46]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931:43073", -- [47]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931:43079", -- [48]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931:43073:43085", -- [49]
			"48275:41215:7824:16227:3310:37005", -- [50]
			"48275:41215:7824:16227:3310:8610:43328", -- [51]
			"48275:41215:7824:16227:3310:43549", -- [52]
			"48275:41215:7824:16227:3310:36728", -- [53]
			"48275:41215:7824:16227:3310:43549:50084:54393", -- [54]
			--["name"] = "Schnottz's Landing, Uldum",
			["m"] = 249,
			["coord"] = 958375507,
			["direct"] = "48275:48274",
			["f"] = 0,
		},
		[48275] = {
			"41215:7824:2995", -- [1]
			"41215:7824:16227:3310", -- [2]
			"41215:7824:3615", -- [3]
			"48274:15178:41605:40473:6726:35478:4312", -- [4]
			"48274:15178:39898:44399", -- [5]
			"48274:15178:41605:40473:6726", -- [6]
			"41215:7824", -- [7]
			"48274:15178:39898", -- [8]
			"41215:7824:16227:3310:8610", -- [9]
			"41215:7824:16227:3310:11139", -- [10]
			"41215:7824:40769:40358:11899", -- [11]
			"48274:15178:41605:40473:6726:35478:4312:11901", -- [12]
			"41215:7824:3615:34927:12616", -- [13]
			"41215:7824:16227:3310:43549:50084:41861:12740", -- [14]
			"48274:15178", -- [15]
			"41215:7824:40769:40358:11899:52060", -- [16]
			"48274:15178:39175:10583", -- [17]
			"41215:7824:16227", -- [18]
			"41215:7824:3615:34927:12616:22931", -- [19]
			"41215:7824:40769:40358", -- [20]
			"41215:7824:3615:34927:34429", -- [21]
			"41215:7824:3615:34927", -- [22]
			"41215:7824:3615:34927:34943", -- [23]
			"48274:15178:41605:40473:6726:35478:4312:35141", -- [24]
			"48274:15178:41605:40473:6726:35478:4312:35140", -- [25]
			"41215:7824:2995:35139", -- [26]
			"48274:15178:41605:40473:6726:35315", -- [27]
			"48274:15178:41605:40473:6726:35478", -- [28]
			"48274:15178:41605:40473:6726:35478:35556", -- [29]
			"48274:15178:41605:40473:6726:35315:35562", -- [30]
			"48274:15178:39175", -- [31]
			"41215:7824:40769:40358:11899:52060:39340", -- [32]
			"48274:15178:39898:39330", -- [33]
			"41215:7824:2995:40809", -- [34]
			"41215:7824:3615:40558", -- [35]
			"41215:7824:40769", -- [36]
			"41215:7824:16227:3310:41140:41142", -- [37]
			"41215:7824:16227:3310:41140", -- [38]
			"41215:41214", -- [39]
			"48274:15178:41605:40473:6726:35478:4312:41246", -- [40]
			"41215:7824:16227:3310:43549:50084", -- [41]
			"41215:7824:16227:3310:43549:50084:53783", -- [42]
			"41215:7824:16227:3310:43549:50084:41861", -- [43]
			"48274:15178:41605:40473", -- [44]
			"48274:15178:41605", -- [45]
			"41215:7824:3615:34927:12616:22931:43073", -- [46]
			"41215:7824:3615:34927:12616:22931:43079", -- [47]
			"41215:7824:3615:34927:12616:22931:43073:43085", -- [48]
			"41215:7824:16227:3310:37005", -- [49]
			"41215:7824:16227:3310:8610:43328", -- [50]
			"41215:7824:16227:3310:43549", -- [51]
			"41215:7824:16227:3310:36728", -- [52]
			"41215:7824:16227:3310:43549:50084:54393", -- [53]
			--["name"] = "Ramkahen, Uldum",
			["m"] = 249,
			["coord"] = 2416399851,
			["direct"] = "41215:48274:48273",
			["f"] = 0,
		},
		[39898] = {
			"44399:11899:16227:3310", -- [1]
			"41605:40473:6726:35478:4312", -- [2]
			"39330:52060:3615:8610", -- [3]
			"44399:11899:16227:3310:11139", -- [4]
			"44399:11899", -- [5]
			"39330:52060:3615:34927:34429:11901", -- [6]
			"39330:52060:3615:34927:12616", -- [7]
			"39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [8]
			"39330:52060", -- [9]
			"15178:39175:10583", -- [10]
			"44399:11899:16227", -- [11]
			"39330:52060:3615:34927:12616:22931", -- [12]
			"44399:40358", -- [13]
			"39330:52060:3615:34927:34429", -- [14]
			"39330:52060:3615:34927", -- [15]
			"39330:52060:3615:34927:34943", -- [16]
			"41605:40473:6726:35478:4312:35141", -- [17]
			"44399:2995:35139:35140", -- [18]
			"44399:2995:35139", -- [19]
			"41605:40473:6726:35478", -- [20]
			"41605:40473:6726:35478:35556", -- [21]
			"35315:35562", -- [22]
			"15178:39175", -- [23]
			"39330:39340", -- [24]
			"44399:2995:40809", -- [25]
			"39330:52060:3615:40558", -- [26]
			"44399:40769", -- [27]
			"44399:40769:7824:41215", -- [28]
			"44399:11899:16227:3310:41140:41142", -- [29]
			"44399:11899:16227:3310:41140", -- [30]
			"44399:40769:7824:41214", -- [31]
			"41605:40473:6726:35478:4312:41246", -- [32]
			"44399:11899:16227:3310:43549:50084", -- [33]
			"44399:11899:16227:3310:43549:50084:53783", -- [34]
			"44399:11899:16227:3310:43549:50084:41861", -- [35]
			"41605:40473", -- [36]
			"39330:52060:3615:34927:12616:22931:43073", -- [37]
			"39330:52060:3615:34927:12616:22931:43079", -- [38]
			"39330:52060:3615:34927:12616:22931:43073:43085", -- [39]
			"44399:11899:16227:3310:37005", -- [40]
			"39330:52060:3615:8610:43328", -- [41]
			"44399:11899:16227:3310:43549", -- [42]
			"15178:48274:48275", -- [43]
			"15178:48274", -- [44]
			"15178:48274:48273", -- [45]
			"39330:52060:3615:34927:12616:36728", -- [46]
			"44399:11899:16227:3310:43549:50084:54393", -- [47]
			--["name"] = "Camp Mojache, Feralas",
			["m"] = 69,
			["coord"] = 3239670129,
			["direct"] = "2995:3615:44399:6726:7824:15178:35315:39330:41605",
			["f"] = 0,
		},
		[11139] = {
			"8610:2995", -- [1]
			"8610:3310:3615", -- [2]
			"43085:43073:22931:34429:4312", -- [3]
			"8610:3310:3615:44399", -- [4]
			"43085:43073:22931:34429:4312:6726", -- [5]
			"8610:3310:7824", -- [6]
			"8610:3310:3615:52060:39330:39898", -- [7]
			"8610:3310:16227:11899", -- [8]
			"43085:43073:22931:34429:11901", -- [9]
			"8610:12616", -- [10]
			"8610:3310:3615:52060:39330:39898:15178", -- [11]
			"8610:3310:3615:52060", -- [12]
			"8610:3310:7824:10583", -- [13]
			"8610:3310:16227", -- [14]
			"43085:43073:22931", -- [15]
			"8610:3310:16227:11899:40358", -- [16]
			"43085:43073:22931:34429", -- [17]
			"8610:12616:34927", -- [18]
			"8610:12616:34943", -- [19]
			"43085:43073:22931:34429:35141", -- [20]
			"8610:12616:34943:35140", -- [21]
			"8610:3310:3615:35139", -- [22]
			"43085:43073:22931:34429:4312:35315", -- [23]
			"43085:43073:22931:34429:4312:35478", -- [24]
			"8610:2995:35556", -- [25]
			"43085:43073:22931:34429:4312:35315:35562", -- [26]
			"8610:3310:7824:39175", -- [27]
			"8610:3310:3615:39340", -- [28]
			"8610:3310:3615:52060:39330", -- [29]
			"8610:2995:40809", -- [30]
			"8610:3310:40558", -- [31]
			"8610:3310:16227:11899:40358:40769", -- [32]
			"8610:3310:7824:41215", -- [33]
			"8610:3310:41140:41142", -- [34]
			"8610:3310:41140", -- [35]
			"8610:3310:7824:41214", -- [36]
			"43085:43073:22931:34429:35141:41246", -- [37]
			"41861:50084", -- [38]
			"41861:53783", -- [39]
			"43085:43073:22931:34429:4312:6726:40473", -- [40]
			"8610:3310:3615:52060:39330:39898:41605", -- [41]
			"43085:43073", -- [42]
			"43085:43073:43079", -- [43]
			"8610:37005", -- [44]
			"8610:43328", -- [45]
			"41861:50084:43549", -- [46]
			"8610:3310:7824:41215:48275", -- [47]
			"8610:3310:3615:52060:39330:39898:15178:48274", -- [48]
			"8610:3310:3615:52060:39330:39898:15178:48274:48273", -- [49]
			"8610:36728", -- [50]
			"41861:50084:54393", -- [51]
			--["name"] = "Everlook, Winterspring",
			["m"] = 83,
			["f"] = 0,
			["direct"] = "3310:8610:12740:41861:43085",
			["coord"] = 2527689643,
		},
		[11901] = {
			"12616:3310", -- [1]
			"35141:35139:2995:44399", -- [2]
			"4312:6726", -- [3]
			"35141:35139:2995:7824", -- [4]
			"35141:35139:2995:52060:39330:39898", -- [5]
			"12616:36728:8610", -- [6]
			"22931:43073:43085:11139", -- [7]
			"35141:35139:2995:52060:11899", -- [8]
			"22931:43073:43085:12740", -- [9]
			"4312:6726:40473:41605:15178", -- [10]
			"35141:35139:2995:52060", -- [11]
			"35141:35139:2995:7824:10583", -- [12]
			"3615:16227", -- [13]
			"35141:35139:2995:52060:39330:40358", -- [14]
			"34429:34943:34927", -- [15]
			"34429:34943", -- [16]
			"35141:35140", -- [17]
			"35141:35139", -- [18]
			"4312:35315", -- [19]
			"4312:35478", -- [20]
			"4312:35478:35556", -- [21]
			"4312:35315:35562", -- [22]
			"4312:6726:40473:41605:15178:39175", -- [23]
			"35141:35139:2995:39340", -- [24]
			"35141:35139:2995:52060:39330", -- [25]
			"35141:35139:2995:40809", -- [26]
			"34429:34943:34927:40558", -- [27]
			"35141:35139:2995:52060:39330:40358:40769", -- [28]
			"35141:35139:2995:7824:41215", -- [29]
			"12616:3310:41140:41142", -- [30]
			"12616:3310:41140", -- [31]
			"35141:35139:2995:7824:41214", -- [32]
			"35141:41246", -- [33]
			"12616:36728:43549:50084", -- [34]
			"12616:36728:43549:50084:53783", -- [35]
			"12616:36728:43549:50084:41861", -- [36]
			"4312:6726:40473", -- [37]
			"4312:6726:40473:41605", -- [38]
			"22931:43073", -- [39]
			"22931:43079", -- [40]
			"22931:43073:43085", -- [41]
			"12616:36728:8610:37005", -- [42]
			"12616:36728:8610:43328", -- [43]
			"12616:36728:43549", -- [44]
			"4312:6726:40473:41605:15178:48274:48275", -- [45]
			"4312:6726:40473:41605:15178:48274", -- [46]
			"4312:6726:40473:41605:15178:48274:48273", -- [47]
			"12616:36728", -- [48]
			"12616:36728:43549:50084:54393", -- [49]
			--["name"] = "Zoram'gar Outpost, Ashenvale",
			["m"] = 63,
			["f"] = 0,
			["direct"] = "2995:3615:4312:12616:22931:34429:35141",
			["coord"] = 482367485,
		},
		[41605] = {
			"40473:6726:35478:35556:2995", -- [1]
			"39898:44399:11899:16227:3310", -- [2]
			"39898:39330:52060:3615", -- [3]
			"40473:6726:35478:4312", -- [4]
			"39898:44399", -- [5]
			"40473:6726", -- [6]
			"39898:44399:40769:7824", -- [7]
			"39898:39330:52060:3615:8610", -- [8]
			"39898:44399:11899:16227:3310:11139", -- [9]
			"39898:44399:11899", -- [10]
			"40473:6726:35478:4312:11901", -- [11]
			"39898:39330:52060:3615:34927:12616", -- [12]
			"39898:39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [13]
			"39898:39330:52060", -- [14]
			"15178:39175:10583", -- [15]
			"39898:44399:11899:16227", -- [16]
			"39898:39330:52060:3615:34927:12616:22931", -- [17]
			"39898:44399:40358", -- [18]
			"40473:6726:35478:4312:34429", -- [19]
			"39898:39330:52060:3615:34927", -- [20]
			"40473:6726:35478:4312:35140:34943", -- [21]
			"40473:6726:35478:4312:35141", -- [22]
			"40473:6726:35478:4312:35140", -- [23]
			"40473:6726:35139", -- [24]
			"40473:6726:35315", -- [25]
			"40473:6726:35478", -- [26]
			"40473:6726:35478:35556", -- [27]
			"40473:6726:35315:35562", -- [28]
			"15178:39175", -- [29]
			"39898:39330:39340", -- [30]
			"39898:39330", -- [31]
			"40473:6726:35478:35556:2995:40809", -- [32]
			"39898:39330:52060:3615:40558", -- [33]
			"39898:44399:40769", -- [34]
			"15178:48274:48275:41215", -- [35]
			"39898:44399:11899:16227:3310:41140:41142", -- [36]
			"39898:44399:11899:16227:3310:41140", -- [37]
			"39898:44399:40769:7824:41214", -- [38]
			"40473:6726:35478:4312:41246", -- [39]
			"39898:44399:11899:16227:3310:43549:50084", -- [40]
			"39898:44399:11899:16227:3310:43549:50084:53783", -- [41]
			"39898:44399:11899:16227:3310:43549:50084:41861", -- [42]
			"39898:39330:52060:3615:34927:12616:22931:43073", -- [43]
			"39898:39330:52060:3615:34927:12616:22931:43079", -- [44]
			"39898:39330:52060:3615:34927:12616:22931:43073:43085", -- [45]
			"39898:44399:11899:16227:3310:37005", -- [46]
			"39898:39330:52060:3615:8610:43328", -- [47]
			"39898:44399:11899:16227:3310:43549", -- [48]
			"15178:48274:48275", -- [49]
			"15178:48274", -- [50]
			"15178:48274:48273", -- [51]
			"39898:39330:52060:3615:34927:12616:36728", -- [52]
			"39898:44399:11899:16227:3310:43549:50084:54393", -- [53]
			--["name"] = "Stonemaul Hold, Feralas",
			["m"] = 69,
			["coord"] = 2189786049,
			["direct"] = "39898:15178:40473",
			["f"] = 0,
		},
		[15178] = {
			"39898:44399:2995", -- [1]
			"39898:44399:11899:16227:3310", -- [2]
			"39898:39330:52060:3615", -- [3]
			"41605:40473:6726:35478:4312", -- [4]
			"39898:44399", -- [5]
			"41605:40473:6726", -- [6]
			"39898:39330:52060:3615:8610", -- [7]
			"39898:44399:11899:16227:3310:11139", -- [8]
			"39898:44399:11899", -- [9]
			"41605:40473:6726:35478:4312:11901", -- [10]
			"39898:39330:52060:3615:34927:12616", -- [11]
			"39898:39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [12]
			"39898:39330:52060", -- [13]
			"39898:44399:11899:16227", -- [14]
			"39898:39330:52060:3615:34927:12616:22931", -- [15]
			"39898:44399:40358", -- [16]
			"39898:39330:52060:3615:34927:34429", -- [17]
			"39898:39330:52060:3615:34927", -- [18]
			"39898:39330:52060:3615:34927:34943", -- [19]
			"41605:40473:6726:35478:4312:35141", -- [20]
			"41605:40473:6726:35478:4312:35140", -- [21]
			"41605:40473:6726:35139", -- [22]
			"41605:40473:6726:35315", -- [23]
			"41605:40473:6726:35478", -- [24]
			"41605:40473:6726:35478:35556", -- [25]
			"41605:40473:6726:35315:35562", -- [26]
			"39898:39330:39340", -- [27]
			"39898:39330", -- [28]
			"39898:44399:2995:40809", -- [29]
			"39898:39330:52060:3615:40558", -- [30]
			"39175:7824:40769", -- [31]
			"48274:48275:41215", -- [32]
			"39898:44399:11899:16227:3310:41140:41142", -- [33]
			"39898:44399:11899:16227:3310:41140", -- [34]
			"39175:7824:41214", -- [35]
			"41605:40473:6726:35478:4312:41246", -- [36]
			"39898:44399:11899:16227:3310:43549:50084", -- [37]
			"39898:44399:11899:16227:3310:43549:50084:53783", -- [38]
			"39898:44399:11899:16227:3310:43549:50084:41861", -- [39]
			"41605:40473", -- [40]
			"39898:39330:52060:3615:34927:12616:22931:43073", -- [41]
			"39898:39330:52060:3615:34927:12616:22931:43079", -- [42]
			"39898:39330:52060:3615:34927:12616:22931:43073:43085", -- [43]
			"39898:44399:11899:16227:3310:37005", -- [44]
			"39898:39330:52060:3615:8610:43328", -- [45]
			"39898:44399:11899:16227:3310:43549", -- [46]
			"48274:48275", -- [47]
			"48274:48273", -- [48]
			"39898:39330:52060:3615:34927:12616:36728", -- [49]
			"39898:44399:11899:16227:3310:43549:50084:54393", -- [50]
			--["name"] = "Cenarion Hold, Silithus",
			["m"] = 81,
			["coord"] = 2269468846,
			["direct"] = "7824:39898:10583:39175:41605:48274",
			["f"] = 0,
		},
		[41861] = {
			"50084:43549:3310:3615:2995", -- [1]
			"50084:43549:3310", -- [2]
			"50084:43549:3310:3615", -- [3]
			"50084:43549:36728:12616:34943:35140:4312", -- [4]
			"50084:43549:3310:3615:44399", -- [5]
			"50084:43549:36728:12616:34943:35140:4312:6726", -- [6]
			"50084:43549:3310:7824", -- [7]
			"50084:43549:3310:3615:52060:39330:39898", -- [8]
			"50084:43549:36728:8610", -- [9]
			"50084:43549:3310:16227:11899", -- [10]
			"50084:43549:36728:12616:34429:11901", -- [11]
			"50084:43549:36728:12616", -- [12]
			"50084:43549:3310:3615:52060:39330:39898:15178", -- [13]
			"50084:43549:3310:3615:52060", -- [14]
			"50084:43549:3310:7824:10583", -- [15]
			"50084:43549:3310:16227", -- [16]
			"50084:43549:36728:12616:22931", -- [17]
			"50084:43549:3310:16227:11899:40358", -- [18]
			"50084:43549:36728:12616:34429", -- [19]
			"50084:43549:36728:12616:34927", -- [20]
			"50084:43549:36728:12616:34943", -- [21]
			"50084:43549:36728:12616:34429:35141", -- [22]
			"50084:43549:36728:12616:34943:35140", -- [23]
			"50084:43549:36728:12616:34943:35140:35139", -- [24]
			"50084:43549:36728:12616:34943:35140:4312:35315", -- [25]
			"50084:43549:36728:12616:34943:35140:4312:35478", -- [26]
			"50084:43549:3310:3615:2995:35556", -- [27]
			"50084:43549:36728:12616:34943:35140:4312:35315:35562", -- [28]
			"50084:43549:3310:7824:39175", -- [29]
			"50084:43549:3310:3615:39340", -- [30]
			"50084:43549:3310:3615:52060:39330", -- [31]
			"50084:43549:3310:3615:2995:40809", -- [32]
			"50084:43549:3310:40558", -- [33]
			"50084:43549:3310:16227:11899:40358:40769", -- [34]
			"50084:43549:3310:7824:41215", -- [35]
			"50084:43549:3310:41140:41142", -- [36]
			"50084:43549:3310:41140", -- [37]
			"50084:43549:3310:7824:41214", -- [38]
			"50084:43549:36728:12616:34943:35140:41246", -- [39]
			"50084:43549:36728:12616:34943:35140:4312:6726:40473", -- [40]
			"50084:43549:3310:3615:52060:39330:39898:41605", -- [41]
			"12740:43085:43073", -- [42]
			"12740:43085:43073:43079", -- [43]
			"12740:43085", -- [44]
			"50084:43549:36728:8610:37005", -- [45]
			"50084:43549:36728:8610:43328", -- [46]
			"50084:43549", -- [47]
			"50084:43549:3310:7824:41215:48275", -- [48]
			"50084:43549:3310:3615:52060:39330:39898:15178:48274", -- [49]
			"50084:43549:3310:3615:52060:39330:39898:15178:48274:48273", -- [50]
			"50084:43549:36728", -- [51]
			"50084:54393", -- [52]
			--["name"] = "Nordrassil, Hyjal",
			["m"] = 198,
			["f"] = 0,
			["direct"] = "11139:12740:50084:53783",
			["coord"] = 2671195983,
		},
		[34429] = {
			"4312:35139:2995", -- [1]
			"12616:3310", -- [2]
			"34943:34927:3615", -- [3]
			"34943:34927:3615:44399", -- [4]
			"4312:6726", -- [5]
			"34943:34927:3615:52060:39330:40358:40769:7824", -- [6]
			"34943:34927:3615:52060:39330:39898", -- [7]
			"12616:36728:8610", -- [8]
			"22931:43073:43085:11139", -- [9]
			"34943:34927:3615:52060:11899", -- [10]
			"22931:43073:43085:12740", -- [11]
			"4312:6726:40473:41605:15178", -- [12]
			"34943:34927:3615:52060", -- [13]
			"34943:34927:3615:52060:39330:40358:40769:7824:10583", -- [14]
			"34943:34927:3615:16227", -- [15]
			"34943:34927:3615:52060:39330:40358", -- [16]
			"34943:35140", -- [17]
			"4312:35139", -- [18]
			"4312:35315", -- [19]
			"4312:35478", -- [20]
			"4312:35478:35556", -- [21]
			"4312:35315:35562", -- [22]
			"34943:34927:3615:52060:39330:40358:40769:7824:39175", -- [23]
			"34943:34927:3615:39340", -- [24]
			"34943:34927:3615:52060:39330", -- [25]
			"4312:35139:2995:40809", -- [26]
			"34943:34927:40558", -- [27]
			"34943:34927:3615:52060:39330:40358:40769", -- [28]
			"34943:34927:3615:52060:39330:40358:40769:7824:41215", -- [29]
			"12616:3310:41140:41142", -- [30]
			"12616:3310:41140", -- [31]
			"34943:34927:3615:52060:39330:40358:40769:7824:41214", -- [32]
			"35141:41246", -- [33]
			"12616:36728:43549:50084", -- [34]
			"12616:36728:43549:50084:53783", -- [35]
			"12616:36728:43549:50084:41861", -- [36]
			"4312:6726:40473", -- [37]
			"4312:6726:40473:41605", -- [38]
			"22931:43073", -- [39]
			"22931:43079", -- [40]
			"22931:43073:43085", -- [41]
			"12616:36728:8610:37005", -- [42]
			"12616:36728:8610:43328", -- [43]
			"12616:36728:43549", -- [44]
			"4312:6726:40473:41605:15178:48274:48275", -- [45]
			"4312:6726:40473:41605:15178:48274", -- [46]
			"4312:6726:40473:41605:15178:48274:48273", -- [47]
			"12616:36728", -- [48]
			"12616:36728:43549:50084:54393", -- [49]
			--["name"] = "Hellscream's Watch, Ashenvale",
			["m"] = 63,
			["f"] = 0,
			["direct"] = "4312:11901:12616:22931:34927:34943:35141",
			["coord"] = 1637772326,
		},
		[40769] = {
			"40358:11899:52060:2995", -- [1]
			"40358:11899:16227:3310", -- [2]
			"40358:11899:52060:3615", -- [3]
			"40358:11899:52060:3615:4312", -- [4]
			"44399:39898:41605:40473:6726", -- [5]
			"44399:39898", -- [6]
			"40358:11899:16227:3310:8610", -- [7]
			"40358:11899:16227:3310:11139", -- [8]
			"40358:11899", -- [9]
			"40358:11899:52060:3615:34927:34429:11901", -- [10]
			"40358:11899:52060:3615:34927:12616", -- [11]
			"40358:11899:52060:3615:34927:12616:22931:43073:43085:12740", -- [12]
			"7824:39175:15178", -- [13]
			"40358:11899:52060", -- [14]
			"7824:10583", -- [15]
			"40358:11899:16227", -- [16]
			"40358:11899:52060:3615:34927:12616:22931", -- [17]
			"40358:11899:52060:3615:34927:34429", -- [18]
			"40358:11899:52060:3615:34927", -- [19]
			"40358:11899:52060:3615:34927:34943", -- [20]
			"40358:11899:52060:3615:4312:35141", -- [21]
			"40358:11899:52060:2995:35139:35140", -- [22]
			"40358:11899:52060:2995:35139", -- [23]
			"44399:39898:35315", -- [24]
			"40358:11899:52060:2995:35556:35478", -- [25]
			"40358:11899:52060:2995:35556", -- [26]
			"40358:11899:52060:2995:35556:35562", -- [27]
			"7824:39175", -- [28]
			"40358:11899:52060:39340", -- [29]
			"40358:39330", -- [30]
			"40358:11899:52060:2995:40809", -- [31]
			"40358:11899:52060:3615:40558", -- [32]
			"7824:41215", -- [33]
			"40358:11899:16227:3310:41140:41142", -- [34]
			"40358:11899:16227:3310:41140", -- [35]
			"7824:41214", -- [36]
			"40358:11899:52060:3615:4312:41246", -- [37]
			"40358:11899:16227:3310:43549:50084", -- [38]
			"40358:11899:16227:3310:43549:50084:53783", -- [39]
			"40358:11899:16227:3310:43549:50084:41861", -- [40]
			"44399:39898:41605:40473", -- [41]
			"44399:39898:41605", -- [42]
			"40358:11899:52060:3615:34927:12616:22931:43073", -- [43]
			"40358:11899:52060:3615:34927:12616:22931:43079", -- [44]
			"40358:11899:52060:3615:34927:12616:22931:43073:43085", -- [45]
			"40358:11899:16227:3310:37005", -- [46]
			"40358:11899:16227:3310:8610:43328", -- [47]
			"40358:11899:16227:3310:43549", -- [48]
			"7824:41215:48275", -- [49]
			"7824:39175:15178:48274", -- [50]
			"7824:41215:48275:48273", -- [51]
			"40358:11899:16227:3310:36728", -- [52]
			"40358:11899:16227:3310:43549:50084:54393", -- [53]
			--["name"] = "Fizzle & Pozzik's Speedbarge, Thousand Needles",
			["m"] = 64,
			["coord"] = 3397892142,
			["direct"] = "44399:7824:40358",
			["f"] = 0,
		},
		[35315] = {
			"35562:35556:2995", -- [1]
			"35562:35556:2995:3310", -- [2]
			"35562:35556:2995:3615", -- [3]
			"39898:44399", -- [4]
			"35562:35556:2995:7824", -- [5]
			"35562:35556:2995:8610", -- [6]
			"35562:35556:2995:8610:11139", -- [7]
			"35562:35556:2995:52060:11899", -- [8]
			"4312:11901", -- [9]
			"4312:35140:34943:12616", -- [10]
			"4312:34429:22931:43073:43085:12740", -- [11]
			"6726:40473:41605:15178", -- [12]
			"35562:35556:2995:52060", -- [13]
			"6726:40473:41605:15178:39175:10583", -- [14]
			"35562:35556:2995:3615:16227", -- [15]
			"4312:34429:22931", -- [16]
			"35562:35556:2995:52060:39330:40358", -- [17]
			"4312:34429", -- [18]
			"35562:35556:2995:3615:34927", -- [19]
			"4312:35140:34943", -- [20]
			"4312:35141", -- [21]
			"4312:35140", -- [22]
			"35562:35556:2995:35139", -- [23]
			"35562:35556", -- [24]
			"6726:40473:41605:15178:39175", -- [25]
			"35562:35556:2995:39340", -- [26]
			"35562:35556:2995:52060:39330", -- [27]
			"35562:35556:2995:40809", -- [28]
			"35562:35556:2995:3615:40558", -- [29]
			"35562:35556:2995:52060:39330:40358:40769", -- [30]
			"35562:35556:2995:7824:41215", -- [31]
			"35562:35556:2995:3310:41140:41142", -- [32]
			"35562:35556:2995:3310:41140", -- [33]
			"35562:35556:2995:7824:41214", -- [34]
			"4312:41246", -- [35]
			"4312:35140:34943:12616:36728:43549:50084", -- [36]
			"4312:35140:34943:12616:36728:43549:50084:53783", -- [37]
			"4312:35140:34943:12616:36728:43549:50084:41861", -- [38]
			"6726:40473", -- [39]
			"6726:40473:41605", -- [40]
			"4312:34429:22931:43073", -- [41]
			"4312:34429:22931:43079", -- [42]
			"4312:34429:22931:43073:43085", -- [43]
			"35562:35556:2995:3310:37005", -- [44]
			"35562:35556:2995:8610:43328", -- [45]
			"4312:35140:34943:12616:36728:43549", -- [46]
			"6726:40473:41605:15178:48274:48275", -- [47]
			"6726:40473:41605:15178:48274", -- [48]
			"6726:40473:41605:15178:48274:48273", -- [49]
			"4312:35140:34943:12616:36728", -- [50]
			"4312:35140:34943:12616:36728:43549:50084:54393", -- [51]
			--["name"] = "Furien's Post, Desolace",
			["m"] = 66,
			["coord"] = 1901743131,
			["direct"] = "4312:6726:39898:35478:35562",
			["f"] = 0,
		},
		[3615] = {
			"2995:6726", -- [1]
			"3310:11139", -- [2]
			"34927:12616:22931:43073:43085:12740", -- [3]
			"52060:39330:39898:15178", -- [4]
			"52060:39330:40358:40769:7824:10583", -- [5]
			"34927:12616:22931", -- [6]
			"52060:39330:40358", -- [7]
			"34927:34429", -- [8]
			"34927:34943", -- [9]
			"4312:35141", -- [10]
			"4312:35140", -- [11]
			"2995:35556:35562:35315", -- [12]
			"2995:35556:35478", -- [13]
			"2995:35556", -- [14]
			"2995:35556:35562", -- [15]
			"52060:39330:40358:40769:7824:39175", -- [16]
			"52060:39330", -- [17]
			"2995:40809", -- [18]
			"52060:39330:40358:40769", -- [19]
			"52060:39330:40358:40769:7824:41215", -- [20]
			"3310:41140:41142", -- [21]
			"3310:41140", -- [22]
			"52060:39330:40358:40769:7824:41214", -- [23]
			"4312:41246", -- [24]
			"3310:43549:50084", -- [25]
			"3310:43549:50084:53783", -- [26]
			"3310:43549:50084:41861", -- [27]
			"2995:6726:40473", -- [28]
			"52060:39330:39898:41605", -- [29]
			"34927:12616:22931:43073", -- [30]
			"34927:12616:22931:43079", -- [31]
			"34927:12616:22931:43073:43085", -- [32]
			"3310:37005", -- [33]
			"8610:43328", -- [34]
			"3310:43549", -- [35]
			"52060:39330:40358:40769:7824:41215:48275", -- [36]
			"52060:39330:39898:15178:48274", -- [37]
			"52060:39330:39898:15178:48274:48273", -- [38]
			"34927:12616:36728", -- [39]
			"3310:43549:50084:54393", -- [40]
			--["name"] = "The Crossroads, Northern Barrens",
			["m"] = 10,
			["f"] = 0,
			["direct"] = "2995:3310:4312:44399:7824:39898:8610:11899:11901:12616:52060:16227:34927:35139:39340:40558",
			["coord"] = 2091619965,
		},
		[3310] = {
			"3615:4312", -- [1]
			"3615:44399", -- [2]
			"3615:2995:6726", -- [3]
			"3615:52060:39330:39898", -- [4]
			"12616:34429:11901", -- [5]
			"43549:50084:41861:12740", -- [6]
			"3615:52060", -- [7]
			"7824:10583", -- [8]
			"12616:22931", -- [9]
			"16227:11899:40358", -- [10]
			"12616:34429", -- [11]
			"12616:34943", -- [12]
			"12616:34429:35141", -- [13]
			"12616:34943:35140", -- [14]
			"3615:35139", -- [15]
			"3615:2995:35556:35562:35315", -- [16]
			"3615:2995:35556:35478", -- [17]
			"3615:2995:35556", -- [18]
			"3615:2995:35556:35562", -- [19]
			"7824:39175", -- [20]
			"3615:39340", -- [21]
			"3615:52060:39330", -- [22]
			"3615:2995:40809", -- [23]
			"16227:11899:40358:40769", -- [24]
			"7824:41215", -- [25]
			"41140:41142", -- [26]
			"7824:41214", -- [27]
			"12616:34943:35140:41246", -- [28]
			"43549:50084", -- [29]
			"43549:50084:53783", -- [30]
			"43549:50084:41861", -- [31]
			"3615:2995:6726:40473", -- [32]
			"3615:52060:39330:39898:41605", -- [33]
			"12616:22931:43073", -- [34]
			"12616:22931:43079", -- [35]
			"12616:22931:43073:43085", -- [36]
			"8610:43328", -- [37]
			"7824:41215:48275", -- [38]
			"7824:41215:48275:48274", -- [39]
			"7824:41215:48275:48273", -- [40]
			"43549:50084:54393", -- [41]
			--["name"] = "Orgrimmar, Durotar",
			["m"] = 85,
			["coord"] = 2132580095,
			["direct"] = "2995:3615:7824:8610:11139:11899:12616:16227:34927:40558:41140:37005:43549:36728",
			["f"] = 0,
		},
		[34943] = {
			"35140:35139:2995", -- [1]
			"34927:3310", -- [2]
			"34927:3615", -- [3]
			"35140:4312", -- [4]
			"34927:3615:44399", -- [5]
			"35140:4312:6726", -- [6]
			"34927:3615:52060:39330:40358:40769:7824", -- [7]
			"34927:3615:52060:39330:39898", -- [8]
			"12616:36728:8610", -- [9]
			"12616:36728:8610:11139", -- [10]
			"34927:3615:52060:11899", -- [11]
			"34429:11901", -- [12]
			"34429:22931:43073:43085:12740", -- [13]
			"34927:3615:52060:39330:39898:15178", -- [14]
			"34927:3615:52060", -- [15]
			"34927:3615:52060:39330:40358:40769:7824:10583", -- [16]
			"34927:3615:16227", -- [17]
			"34429:22931", -- [18]
			"34927:3615:52060:39330:40358", -- [19]
			"34429:35141", -- [20]
			"35140:35139", -- [21]
			"35140:4312:35315", -- [22]
			"35140:4312:35478", -- [23]
			"35140:35139:2995:35556", -- [24]
			"35140:4312:35315:35562", -- [25]
			"34927:3615:52060:39330:40358:40769:7824:39175", -- [26]
			"34927:3615:39340", -- [27]
			"34927:3615:52060:39330", -- [28]
			"35140:35139:2995:40809", -- [29]
			"34927:40558", -- [30]
			"34927:3615:52060:39330:40358:40769", -- [31]
			"34927:3615:52060:39330:40358:40769:7824:41215", -- [32]
			"34927:3310:41140:41142", -- [33]
			"34927:3310:41140", -- [34]
			"34927:3615:52060:39330:40358:40769:7824:41214", -- [35]
			"35140:41246", -- [36]
			"12616:36728:43549:50084", -- [37]
			"12616:36728:43549:50084:53783", -- [38]
			"12616:36728:43549:50084:41861", -- [39]
			"35140:4312:6726:40473", -- [40]
			"34927:3615:52060:39330:39898:41605", -- [41]
			"34429:22931:43073", -- [42]
			"34429:22931:43079", -- [43]
			"34429:22931:43073:43085", -- [44]
			"12616:36728:8610:37005", -- [45]
			"12616:36728:8610:43328", -- [46]
			"12616:36728:43549", -- [47]
			"34927:3615:52060:39330:40358:40769:7824:41215:48275", -- [48]
			"34927:3615:52060:39330:39898:15178:48274", -- [49]
			"34927:3615:52060:39330:39898:15178:48274:48273", -- [50]
			"12616:36728", -- [51]
			"12616:36728:43549:50084:54393", -- [52]
			--["name"] = "Silverwind Refuge, Ashenvale",
			["m"] = 63,
			["f"] = 0,
			["direct"] = "12616:34429:34927:35140",
			["coord"] = 2118297444,
		},
		[10583] = {
			"7824:2995", -- [1]
			"7824:16227:3310", -- [2]
			"7824:3615", -- [3]
			"39175:15178:41605:40473:6726:35478:4312", -- [4]
			"7824:44399", -- [5]
			"39175:15178:41605:40473:6726", -- [6]
			"39175:15178:39898", -- [7]
			"7824:16227:3310:8610", -- [8]
			"7824:16227:3310:11139", -- [9]
			"7824:40769:40358:11899", -- [10]
			"7824:3615:34927:34429:11901", -- [11]
			"7824:3615:34927:12616", -- [12]
			"7824:16227:3310:43549:50084:41861:12740", -- [13]
			"7824:40769:40358:11899:52060", -- [14]
			"7824:16227", -- [15]
			"7824:3615:34927:12616:22931", -- [16]
			"7824:40769:40358", -- [17]
			"7824:3615:34927:34429", -- [18]
			"7824:3615:34927", -- [19]
			"7824:3615:34927:34943", -- [20]
			"7824:2995:35139:35141", -- [21]
			"7824:2995:35139:35140", -- [22]
			"7824:2995:35139", -- [23]
			"39175:15178:41605:40473:6726:35315", -- [24]
			"39175:15178:41605:40473:6726:35478", -- [25]
			"39175:15178:41605:40473:6726:35478:35556", -- [26]
			"39175:15178:41605:40473:6726:35315:35562", -- [27]
			"7824:40769:40358:11899:52060:39340", -- [28]
			"7824:40769:40358:39330", -- [29]
			"7824:2995:40809", -- [30]
			"7824:3615:40558", -- [31]
			"7824:40769", -- [32]
			"7824:41215", -- [33]
			"7824:16227:3310:41140:41142", -- [34]
			"7824:16227:3310:41140", -- [35]
			"7824:41214", -- [36]
			"39175:15178:41605:40473:6726:35478:4312:41246", -- [37]
			"7824:16227:3310:43549:50084", -- [38]
			"7824:16227:3310:43549:50084:53783", -- [39]
			"7824:16227:3310:43549:50084:41861", -- [40]
			"39175:15178:41605:40473", -- [41]
			"39175:15178:41605", -- [42]
			"7824:3615:34927:12616:22931:43073", -- [43]
			"7824:3615:34927:12616:22931:43079", -- [44]
			"7824:3615:34927:12616:22931:43073:43085", -- [45]
			"7824:16227:3310:37005", -- [46]
			"7824:16227:3310:8610:43328", -- [47]
			"7824:16227:3310:43549", -- [48]
			"39175:15178:48274:48275", -- [49]
			"39175:15178:48274", -- [50]
			"39175:15178:48274:48273", -- [51]
			"7824:16227:3310:36728", -- [52]
			"7824:16227:3310:43549:50084:54393", -- [53]
			--["name"] = "Marshal's Stand, Un'Goro Crater",
			["m"] = 78,
			["coord"] = 2408031264,
			["direct"] = "7824:15178:39175",
			["f"] = 0,
		},
		[6726] = {
			"35478:35556:2995:3310", -- [1]
			"35139:3615", -- [2]
			"39898:44399", -- [3]
			"39898:44399:40769:7824", -- [4]
			"35478:35556:2995:8610", -- [5]
			"35478:35556:2995:8610:11139", -- [6]
			"35478:35556:2995:52060:11899", -- [7]
			"35478:4312:11901", -- [8]
			"35478:4312:35140:34943:12616", -- [9]
			"35478:4312:34429:22931:43073:43085:12740", -- [10]
			"40473:41605:15178", -- [11]
			"35478:35556:2995:52060", -- [12]
			"40473:41605:15178:39175:10583", -- [13]
			"35139:3615:16227", -- [14]
			"35478:4312:34429:22931", -- [15]
			"39898:44399:40358", -- [16]
			"35478:4312:34429", -- [17]
			"35139:3615:34927", -- [18]
			"35478:4312:35140:34943", -- [19]
			"35478:4312:35141", -- [20]
			"35478:4312:35140", -- [21]
			"35478:35556", -- [22]
			"40473:41605:15178:39175", -- [23]
			"35478:35556:2995:39340", -- [24]
			"35478:35556:2995:52060:39330", -- [25]
			"35478:35556:2995:40809", -- [26]
			"35139:3615:40558", -- [27]
			"39898:44399:40769", -- [28]
			"40473:41605:15178:48274:48275:41215", -- [29]
			"35478:35556:2995:3310:41140:41142", -- [30]
			"35478:35556:2995:3310:41140", -- [31]
			"39898:44399:40769:7824:41214", -- [32]
			"35478:4312:41246", -- [33]
			"35478:35556:2995:3310:43549:50084", -- [34]
			"35478:35556:2995:3310:43549:50084:53783", -- [35]
			"35478:35556:2995:3310:43549:50084:41861", -- [36]
			"40473:41605", -- [37]
			"35478:4312:34429:22931:43073", -- [38]
			"35478:4312:34429:22931:43079", -- [39]
			"35478:4312:34429:22931:43073:43085", -- [40]
			"35478:35556:2995:3310:37005", -- [41]
			"35478:35556:2995:8610:43328", -- [42]
			"35478:35556:2995:3310:43549", -- [43]
			"40473:41605:15178:48274:48275", -- [44]
			"40473:41605:15178:48274", -- [45]
			"40473:41605:15178:48274:48273", -- [46]
			"35478:4312:35140:34943:12616:36728", -- [47]
			"35478:35556:2995:3310:43549:50084:54393", -- [48]
			--["name"] = "Shadowprey Village, Desolace",
			["m"] = 66,
			["coord"] = 926137739,
			["direct"] = "2995:4312:39898:35139:35315:35478:35562:40473",
			["f"] = 0,
		},
		[44399] = {
			"11899:16227:3310", -- [1]
			"3615:4312", -- [2]
			"39898:41605:40473:6726", -- [3]
			"11899:16227:3310:8610", -- [4]
			"11899:16227:3310:11139", -- [5]
			"3615:34927:34429:11901", -- [6]
			"3615:34927:12616", -- [7]
			"3615:34927:12616:22931:43073:43085:12740", -- [8]
			"39898:15178", -- [9]
			"40769:7824:10583", -- [10]
			"11899:16227", -- [11]
			"3615:34927:12616:22931", -- [12]
			"3615:34927:34429", -- [13]
			"3615:34927", -- [14]
			"3615:34927:34943", -- [15]
			"2995:35139:35141", -- [16]
			"2995:35139:35140", -- [17]
			"2995:35139", -- [18]
			"39898:35315", -- [19]
			"39898:41605:40473:6726:35478", -- [20]
			"2995:35556", -- [21]
			"39898:35315:35562", -- [22]
			"40769:7824:39175", -- [23]
			"52060:39340", -- [24]
			"2995:40809", -- [25]
			"3615:40558", -- [26]
			"40769:7824:41215", -- [27]
			"11899:16227:3310:41140:41142", -- [28]
			"11899:16227:3310:41140", -- [29]
			"40769:7824:41214", -- [30]
			"3615:4312:41246", -- [31]
			"11899:16227:3310:43549:50084", -- [32]
			"11899:16227:3310:43549:50084:53783", -- [33]
			"11899:16227:3310:43549:50084:41861", -- [34]
			"39898:41605:40473", -- [35]
			"39898:41605", -- [36]
			"3615:34927:12616:22931:43073", -- [37]
			"3615:34927:12616:22931:43079", -- [38]
			"3615:34927:12616:22931:43073:43085", -- [39]
			"11899:16227:3310:37005", -- [40]
			"11899:16227:3310:8610:43328", -- [41]
			"11899:16227:3310:43549", -- [42]
			"39898:15178:48274:48275", -- [43]
			"39898:15178:48274", -- [44]
			"39898:15178:48274:48273", -- [45]
			"3615:34927:12616:36728", -- [46]
			"11899:16227:3310:43549:50084:54393", -- [47]
			--["name"] = "Westreach Summit, Thousand Needles",
			["m"] = 64,
			["coord"] = 481959428,
			["direct"] = "2995:3615:7824:39898:11899:52060:40358:39330:40769",
			["f"] = 0,
		},
		[35140] = {
			"35139:2995", -- [1]
			"34927:3310", -- [2]
			"35139:3615", -- [3]
			"35139:2995:44399", -- [4]
			"4312:6726", -- [5]
			"35139:2995:7824", -- [6]
			"35139:2995:52060:39330:39898", -- [7]
			"34943:12616:36728:8610", -- [8]
			"34943:12616:36728:8610:11139", -- [9]
			"35139:2995:52060:11899", -- [10]
			"35141:11901", -- [11]
			"34943:12616", -- [12]
			"34943:34429:22931:43073:43085:12740", -- [13]
			"4312:6726:40473:41605:15178", -- [14]
			"35139:2995:52060", -- [15]
			"35139:2995:7824:10583", -- [16]
			"35139:3615:16227", -- [17]
			"34943:34429:22931", -- [18]
			"35139:2995:52060:39330:40358", -- [19]
			"34943:34429", -- [20]
			"4312:35315", -- [21]
			"4312:35478", -- [22]
			"35139:2995:35556", -- [23]
			"4312:35315:35562", -- [24]
			"35139:2995:7824:39175", -- [25]
			"35139:2995:39340", -- [26]
			"35139:2995:52060:39330", -- [27]
			"35139:2995:40809", -- [28]
			"34927:40558", -- [29]
			"35139:2995:52060:39330:40358:40769", -- [30]
			"35139:2995:7824:41215", -- [31]
			"34927:3310:41140:41142", -- [32]
			"34927:3310:41140", -- [33]
			"35139:2995:7824:41214", -- [34]
			"34943:12616:36728:43549:50084", -- [35]
			"34943:12616:36728:43549:50084:53783", -- [36]
			"34943:12616:36728:43549:50084:41861", -- [37]
			"4312:6726:40473", -- [38]
			"4312:6726:40473:41605", -- [39]
			"34943:34429:22931:43073", -- [40]
			"34943:34429:22931:43079", -- [41]
			"34943:34429:22931:43073:43085", -- [42]
			"34943:12616:36728:8610:37005", -- [43]
			"34943:12616:36728:8610:43328", -- [44]
			"34943:12616:36728:43549", -- [45]
			"4312:6726:40473:41605:15178:48274:48275", -- [46]
			"4312:6726:40473:41605:15178:48274", -- [47]
			"4312:6726:40473:41605:15178:48274:48273", -- [48]
			"34943:12616:36728", -- [49]
			"34943:12616:36728:43549:50084:54393", -- [50]
			--["name"] = "Krom'gar Fortress, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "4312:34927:34943:35141:35139:41246",
			["coord"] = 2857476284,
		},
		[35139] = {
			"3615:3310", -- [1]
			"2995:44399", -- [2]
			"2995:7824", -- [3]
			"2995:52060:39330:39898", -- [4]
			"3615:8610", -- [5]
			"3615:3310:11139", -- [6]
			"2995:52060:11899", -- [7]
			"35141:11901", -- [8]
			"3615:34927:12616", -- [9]
			"4312:34429:22931:43073:43085:12740", -- [10]
			"2995:52060:39330:39898:15178", -- [11]
			"2995:52060", -- [12]
			"2995:7824:10583", -- [13]
			"3615:16227", -- [14]
			"4312:34429:22931", -- [15]
			"2995:52060:39330:40358", -- [16]
			"4312:34429", -- [17]
			"3615:34927", -- [18]
			"35140:34943", -- [19]
			"4312:35315", -- [20]
			"2995:35556:35478", -- [21]
			"2995:35556", -- [22]
			"2995:35556:35562", -- [23]
			"2995:7824:39175", -- [24]
			"2995:39340", -- [25]
			"2995:52060:39330", -- [26]
			"2995:40809", -- [27]
			"3615:40558", -- [28]
			"2995:52060:39330:40358:40769", -- [29]
			"2995:7824:41215", -- [30]
			"3615:3310:41140:41142", -- [31]
			"3615:3310:41140", -- [32]
			"2995:7824:41214", -- [33]
			"4312:41246", -- [34]
			"3615:3310:43549:50084", -- [35]
			"3615:3310:43549:50084:53783", -- [36]
			"3615:3310:43549:50084:41861", -- [37]
			"6726:40473", -- [38]
			"6726:40473:41605", -- [39]
			"4312:34429:22931:43073", -- [40]
			"4312:34429:22931:43079", -- [41]
			"4312:34429:22931:43073:43085", -- [42]
			"3615:3310:37005", -- [43]
			"3615:8610:43328", -- [44]
			"3615:3310:43549", -- [45]
			"2995:7824:41215:48275", -- [46]
			"2995:52060:39330:39898:15178:48274", -- [47]
			"2995:52060:39330:39898:15178:48274:48273", -- [48]
			"3615:34927:12616:36728", -- [49]
			"3615:3310:43549:50084:54393", -- [50]
			--["name"] = "Malaka'jin, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "2995:3615:4312:6726:35141:35140",
			["coord"] = 3032343762,
		},
		[22931] = {
			"34429:4312:35139:2995", -- [1]
			"12616:3310", -- [2]
			"12616:34927:3615", -- [3]
			"34429:4312", -- [4]
			"12616:34927:3615:44399", -- [5]
			"34429:4312:6726", -- [6]
			"12616:34927:3615:52060:39330:40358:40769:7824", -- [7]
			"12616:34927:3615:52060:39330:39898", -- [8]
			"12616:36728:8610", -- [9]
			"43073:43085:11139", -- [10]
			"12616:34927:3615:52060:11899", -- [11]
			"43073:43085:12740", -- [12]
			"12616:34927:3615:52060:39330:39898:15178", -- [13]
			"12616:34927:3615:52060", -- [14]
			"12616:34927:3615:52060:39330:40358:40769:7824:10583", -- [15]
			"12616:34927:3615:16227", -- [16]
			"12616:34927:3615:52060:39330:40358", -- [17]
			"12616:34927", -- [18]
			"34429:34943", -- [19]
			"34429:35141", -- [20]
			"34429:34943:35140", -- [21]
			"34429:4312:35139", -- [22]
			"34429:4312:35315", -- [23]
			"34429:4312:35478", -- [24]
			"34429:4312:35478:35556", -- [25]
			"34429:4312:35315:35562", -- [26]
			"12616:34927:3615:52060:39330:40358:40769:7824:39175", -- [27]
			"12616:34927:3615:39340", -- [28]
			"12616:34927:3615:52060:39330", -- [29]
			"34429:4312:35139:2995:40809", -- [30]
			"12616:34927:40558", -- [31]
			"12616:34927:3615:52060:39330:40358:40769", -- [32]
			"12616:34927:3615:52060:39330:40358:40769:7824:41215", -- [33]
			"12616:3310:41140:41142", -- [34]
			"12616:3310:41140", -- [35]
			"12616:34927:3615:52060:39330:40358:40769:7824:41214", -- [36]
			"34429:35141:41246", -- [37]
			"12616:36728:43549:50084", -- [38]
			"12616:36728:43549:50084:53783", -- [39]
			"12616:36728:43549:50084:41861", -- [40]
			"34429:4312:6726:40473", -- [41]
			"12616:34927:3615:52060:39330:39898:41605", -- [42]
			"43073:43085", -- [43]
			"12616:36728:8610:37005", -- [44]
			"12616:36728:8610:43328", -- [45]
			"12616:36728:43549", -- [46]
			"12616:34927:3615:52060:39330:40358:40769:7824:41215:48275", -- [47]
			"12616:34927:3615:52060:39330:39898:15178:48274", -- [48]
			"12616:34927:3615:52060:39330:39898:15178:48274:48273", -- [49]
			"12616:36728", -- [50]
			"12616:36728:43549:50084:54393", -- [51]
			--["name"] = "Emerald Sanctuary, Felwood",
			["m"] = 77,
			["f"] = 0,
			["direct"] = "11901:12616:34429:43073:43079",
			["coord"] = 2212089545,
		},
		[50084] = {
			"43549:3310:3615:2995", -- [1]
			"43549:3310", -- [2]
			"43549:3310:3615", -- [3]
			"43549:36728:12616:34943:35140:4312", -- [4]
			"43549:3310:3615:44399", -- [5]
			"43549:36728:12616:34943:35140:4312:6726", -- [6]
			"43549:3310:7824", -- [7]
			"43549:3310:3615:52060:39330:39898", -- [8]
			"43549:36728:8610", -- [9]
			"41861:11139", -- [10]
			"43549:3310:16227:11899", -- [11]
			"43549:36728:12616:34429:11901", -- [12]
			"43549:36728:12616", -- [13]
			"41861:12740", -- [14]
			"43549:3310:3615:52060:39330:39898:15178", -- [15]
			"43549:3310:3615:52060", -- [16]
			"43549:3310:7824:10583", -- [17]
			"43549:3310:16227", -- [18]
			"43549:36728:12616:22931", -- [19]
			"43549:3310:16227:11899:40358", -- [20]
			"43549:36728:12616:34429", -- [21]
			"43549:36728:12616:34927", -- [22]
			"43549:36728:12616:34943", -- [23]
			"43549:36728:12616:34429:35141", -- [24]
			"43549:36728:12616:34943:35140", -- [25]
			"43549:36728:12616:34943:35140:35139", -- [26]
			"43549:36728:12616:34943:35140:4312:35315", -- [27]
			"43549:36728:12616:34943:35140:4312:35478", -- [28]
			"43549:3310:3615:2995:35556", -- [29]
			"43549:36728:12616:34943:35140:4312:35315:35562", -- [30]
			"43549:3310:7824:39175", -- [31]
			"43549:3310:3615:39340", -- [32]
			"43549:3310:3615:52060:39330", -- [33]
			"43549:3310:3615:2995:40809", -- [34]
			"43549:3310:40558", -- [35]
			"43549:3310:16227:11899:40358:40769", -- [36]
			"43549:3310:7824:41215", -- [37]
			"43549:3310:41140:41142", -- [38]
			"43549:3310:41140", -- [39]
			"43549:3310:7824:41214", -- [40]
			"43549:36728:12616:34943:35140:41246", -- [41]
			"43549:36728:12616:34943:35140:4312:6726:40473", -- [42]
			"43549:3310:3615:52060:39330:39898:41605", -- [43]
			"41861:12740:43085:43073", -- [44]
			"43549:36728:12616:22931:43079", -- [45]
			"41861:12740:43085", -- [46]
			"43549:36728:8610:37005", -- [47]
			"43549:36728:8610:43328", -- [48]
			"43549:3310:7824:41215:48275", -- [49]
			"43549:3310:3615:52060:39330:39898:15178:48274", -- [50]
			"43549:3310:3615:52060:39330:39898:15178:48274:48273", -- [51]
			"43549:36728", -- [52]
			["direct"] = "53783:41861:43549:54393",
			["f"] = 0,
			["m"] = 198,
			["coord"] = 1766616413,
		},
		[37005] = {
			"3310:3615:2995", -- [1]
			"3310:3615", -- [2]
			"3310:3615:4312", -- [3]
			"3310:3615:44399", -- [4]
			"3310:3615:2995:6726", -- [5]
			"3310:7824", -- [6]
			"3310:3615:52060:39330:39898", -- [7]
			"8610:11139", -- [8]
			"3310:16227:11899", -- [9]
			"3310:12616:34429:11901", -- [10]
			"3310:12616", -- [11]
			"8610:11139:12740", -- [12]
			"3310:3615:52060:39330:39898:15178", -- [13]
			"3310:3615:52060", -- [14]
			"3310:7824:10583", -- [15]
			"3310:16227", -- [16]
			"3310:12616:22931", -- [17]
			"3310:16227:11899:40358", -- [18]
			"3310:12616:34429", -- [19]
			"3310:34927", -- [20]
			"3310:12616:34943", -- [21]
			"3310:12616:34429:35141", -- [22]
			"3310:12616:34943:35140", -- [23]
			"3310:3615:35139", -- [24]
			"3310:3615:2995:35556:35562:35315", -- [25]
			"3310:3615:2995:35556:35478", -- [26]
			"3310:3615:2995:35556", -- [27]
			"3310:3615:2995:35556:35562", -- [28]
			"3310:7824:39175", -- [29]
			"3310:3615:39340", -- [30]
			"3310:3615:52060:39330", -- [31]
			"3310:3615:2995:40809", -- [32]
			"3310:40558", -- [33]
			"3310:16227:11899:40358:40769", -- [34]
			"3310:7824:41215", -- [35]
			"3310:41140:41142", -- [36]
			"3310:41140", -- [37]
			"3310:7824:41214", -- [38]
			"3310:12616:34943:35140:41246", -- [39]
			"8610:36728:43549:50084", -- [40]
			"8610:36728:43549:50084:53783", -- [41]
			"8610:36728:43549:50084:41861", -- [42]
			"3310:3615:2995:6726:40473", -- [43]
			"3310:3615:52060:39330:39898:41605", -- [44]
			"8610:11139:43085:43073", -- [45]
			"3310:12616:22931:43079", -- [46]
			"8610:11139:43085", -- [47]
			"8610:43328", -- [48]
			"8610:36728:43549", -- [49]
			"3310:7824:41215:48275", -- [50]
			"3310:3615:52060:39330:39898:15178:48274", -- [51]
			"3310:3615:52060:39330:39898:15178:48274:48273", -- [52]
			"8610:36728", -- [53]
			"8610:36728:43549:50084:54393", -- [54]
			--["name"] = "Southern Rocketway, Azshara",
			["m"] = 76,
			["f"] = 0,
			["direct"] = "3310:8610",
			["coord"] = 2213068365,
		},
		[34927] = {
			"3615:2995", -- [1]
			"35140:4312", -- [2]
			"3615:44399", -- [3]
			"3615:2995:6726", -- [4]
			"3615:52060:39330:40358:40769:7824", -- [5]
			"3615:52060:39330:39898", -- [6]
			"12616:36728:8610", -- [7]
			"12616:36728:8610:11139", -- [8]
			"3615:52060:11899", -- [9]
			"34429:11901", -- [10]
			"12616:22931:43073:43085:12740", -- [11]
			"3615:52060:39330:39898:15178", -- [12]
			"3615:52060", -- [13]
			"3615:52060:39330:40358:40769:7824:10583", -- [14]
			"3615:16227", -- [15]
			"12616:22931", -- [16]
			"3615:52060:39330:40358", -- [17]
			"34429:35141", -- [18]
			"3615:35139", -- [19]
			"35140:4312:35315", -- [20]
			"3615:2995:35556:35478", -- [21]
			"3615:2995:35556", -- [22]
			"3615:2995:35556:35562", -- [23]
			"3615:52060:39330:40358:40769:7824:39175", -- [24]
			"3615:39340", -- [25]
			"3615:52060:39330", -- [26]
			"3615:2995:40809", -- [27]
			"3615:52060:39330:40358:40769", -- [28]
			"3615:52060:39330:40358:40769:7824:41215", -- [29]
			"3310:41140:41142", -- [30]
			"3310:41140", -- [31]
			"3615:52060:39330:40358:40769:7824:41214", -- [32]
			"35140:41246", -- [33]
			"12616:36728:43549:50084", -- [34]
			"12616:36728:43549:50084:53783", -- [35]
			"12616:36728:43549:50084:41861", -- [36]
			"3615:2995:6726:40473", -- [37]
			"3615:52060:39330:39898:41605", -- [38]
			"12616:22931:43073", -- [39]
			"12616:22931:43079", -- [40]
			"12616:22931:43073:43085", -- [41]
			"3310:37005", -- [42]
			"12616:36728:8610:43328", -- [43]
			"12616:36728:43549", -- [44]
			"3615:52060:39330:40358:40769:7824:41215:48275", -- [45]
			"3615:52060:39330:39898:15178:48274", -- [46]
			"3615:52060:39330:39898:15178:48274:48273", -- [47]
			"12616:36728", -- [48]
			"12616:36728:43549:50084:54393", -- [49]
			--["name"] = "The Mor'Shan Ramparts, Ashenvale",
			["m"] = 10,
			["f"] = 0,
			["direct"] = "3310:3615:12616:34429:34943:35140:40558",
			["coord"] = 1802381409,
		},
		[40558] = {
			"3615:2995", -- [1]
			"3615:4312", -- [2]
			"3615:44399", -- [3]
			"3615:2995:6726", -- [4]
			"3615:52060:39330:40358:40769:7824", -- [5]
			"3615:52060:39330:39898", -- [6]
			"3310:8610", -- [7]
			"3310:11139", -- [8]
			"3615:52060:11899", -- [9]
			"34927:34429:11901", -- [10]
			"34927:12616", -- [11]
			"34927:12616:22931:43073:43085:12740", -- [12]
			"3615:52060:39330:39898:15178", -- [13]
			"3615:52060", -- [14]
			"3615:52060:39330:40358:40769:7824:10583", -- [15]
			"3615:16227", -- [16]
			"34927:12616:22931", -- [17]
			"3615:52060:39330:40358", -- [18]
			"34927:34429", -- [19]
			"34927:34943", -- [20]
			"34927:34429:35141", -- [21]
			"34927:35140", -- [22]
			"3615:35139", -- [23]
			"3615:2995:35556:35562:35315", -- [24]
			"3615:2995:35556:35478", -- [25]
			"3615:2995:35556", -- [26]
			"3615:2995:35556:35562", -- [27]
			"3615:52060:39330:40358:40769:7824:39175", -- [28]
			"3615:39340", -- [29]
			"3615:52060:39330", -- [30]
			"3615:2995:40809", -- [31]
			"3615:52060:39330:40358:40769", -- [32]
			"3615:52060:39330:40358:40769:7824:41215", -- [33]
			"3310:41140:41142", -- [34]
			"3310:41140", -- [35]
			"3615:52060:39330:40358:40769:7824:41214", -- [36]
			"34927:35140:41246", -- [37]
			"3310:43549:50084", -- [38]
			"3310:43549:50084:53783", -- [39]
			"3310:43549:50084:41861", -- [40]
			"3615:2995:6726:40473", -- [41]
			"3615:52060:39330:39898:41605", -- [42]
			"34927:12616:22931:43073", -- [43]
			"34927:12616:22931:43079", -- [44]
			"34927:12616:22931:43073:43085", -- [45]
			"3310:37005", -- [46]
			"3310:8610:43328", -- [47]
			"3310:43549", -- [48]
			"3615:52060:39330:40358:40769:7824:41215:48275", -- [49]
			"3615:52060:39330:39898:15178:48274", -- [50]
			"3615:52060:39330:39898:15178:48274:48273", -- [51]
			"3310:36728", -- [52]
			"3310:43549:50084:54393", -- [53]
			--["name"] = "Nozzlepot's Outpost, Northern Barrens",
			["m"] = 10,
			["f"] = 0,
			["direct"] = "3310:3615:34927",
			["coord"] = 2678860788,
		},
		[40473] = {
			"6726:35478:35556:2995", -- [1]
			"6726:35478:35556:2995:3310", -- [2]
			"6726:35139:3615", -- [3]
			"6726:35478:4312", -- [4]
			"41605:39898:44399", -- [5]
			"41605:39898:44399:40769:7824", -- [6]
			"41605:39898", -- [7]
			"6726:35478:35556:2995:8610", -- [8]
			"6726:35478:35556:2995:8610:11139", -- [9]
			"41605:39898:44399:11899", -- [10]
			"6726:35478:4312:11901", -- [11]
			"6726:35478:4312:35140:34943:12616", -- [12]
			"6726:35478:4312:34429:22931:43073:43085:12740", -- [13]
			"41605:15178", -- [14]
			"41605:39898:39330:52060", -- [15]
			"41605:15178:39175:10583", -- [16]
			"6726:35139:3615:16227", -- [17]
			"6726:35478:4312:34429:22931", -- [18]
			"41605:39898:44399:40358", -- [19]
			"6726:35478:4312:34429", -- [20]
			"6726:35139:3615:34927", -- [21]
			"6726:35478:4312:35140:34943", -- [22]
			"6726:35478:4312:35141", -- [23]
			"6726:35478:4312:35140", -- [24]
			"6726:35139", -- [25]
			"6726:35315", -- [26]
			"6726:35478", -- [27]
			"6726:35478:35556", -- [28]
			"6726:35315:35562", -- [29]
			"41605:15178:39175", -- [30]
			"6726:35478:35556:2995:39340", -- [31]
			"41605:39898:39330", -- [32]
			"6726:35478:35556:2995:40809", -- [33]
			"6726:35139:3615:40558", -- [34]
			"41605:39898:44399:40769", -- [35]
			"41605:15178:48274:48275:41215", -- [36]
			"6726:35478:35556:2995:3310:41140:41142", -- [37]
			"6726:35478:35556:2995:3310:41140", -- [38]
			"41605:39898:44399:40769:7824:41214", -- [39]
			"6726:35478:4312:41246", -- [40]
			"6726:35478:35556:2995:3310:43549:50084", -- [41]
			"6726:35478:35556:2995:3310:43549:50084:53783", -- [42]
			"6726:35478:35556:2995:3310:43549:50084:41861", -- [43]
			"6726:35478:4312:34429:22931:43073", -- [44]
			"6726:35478:4312:34429:22931:43079", -- [45]
			"6726:35478:4312:34429:22931:43073:43085", -- [46]
			"6726:35478:35556:2995:3310:37005", -- [47]
			"6726:35478:35556:2995:8610:43328", -- [48]
			"6726:35478:35556:2995:3310:43549", -- [49]
			"41605:15178:48274:48275", -- [50]
			"41605:15178:48274", -- [51]
			"41605:15178:48274:48273", -- [52]
			"6726:35478:4312:35140:34943:12616:36728", -- [53]
			"6726:35478:35556:2995:3310:43549:50084:54393", -- [54]
			--["name"] = "Camp Ataya, Feralas",
			["m"] = 69,
			["coord"] = 1782589281,
			["direct"] = "6726:41605",
			["f"] = 0,
		},
		[16227] = {
			"3615:2995", -- [1]
			"3615:4312", -- [2]
			"11899:44399", -- [3]
			"3615:2995:6726", -- [4]
			"11899:39330:39898", -- [5]
			"3310:8610", -- [6]
			"3310:11139", -- [7]
			"3615:34927:34429:11901", -- [8]
			"3615:34927:12616", -- [9]
			"3310:43549:50084:41861:12740", -- [10]
			"11899:39330:39898:15178", -- [11]
			"3615:52060", -- [12]
			"7824:10583", -- [13]
			"3615:34927:12616:22931", -- [14]
			"11899:40358", -- [15]
			"3615:34927:34429", -- [16]
			"3615:34927", -- [17]
			"3615:34927:34943", -- [18]
			"3615:4312:35141", -- [19]
			"3615:4312:35140", -- [20]
			"3615:35139", -- [21]
			"3615:2995:35556:35562:35315", -- [22]
			"3615:2995:35556:35478", -- [23]
			"3615:2995:35556", -- [24]
			"3615:2995:35556:35562", -- [25]
			"7824:39175", -- [26]
			"3615:39340", -- [27]
			"11899:39330", -- [28]
			"3615:2995:40809", -- [29]
			"3615:40558", -- [30]
			"11899:40358:40769", -- [31]
			"7824:41215", -- [32]
			"3310:41140:41142", -- [33]
			"3310:41140", -- [34]
			"7824:41214", -- [35]
			"3615:4312:41246", -- [36]
			"3310:43549:50084", -- [37]
			"3310:43549:50084:53783", -- [38]
			"3310:43549:50084:41861", -- [39]
			"3615:2995:6726:40473", -- [40]
			"11899:39330:39898:41605", -- [41]
			"3615:34927:12616:22931:43073", -- [42]
			"3615:34927:12616:22931:43079", -- [43]
			"3615:34927:12616:22931:43073:43085", -- [44]
			"3310:37005", -- [45]
			"3310:8610:43328", -- [46]
			"3310:43549", -- [47]
			"7824:41215:48275", -- [48]
			"11899:39330:39898:15178:48274", -- [49]
			"7824:41215:48275:48273", -- [50]
			"3310:36728", -- [51]
			"3310:43549:50084:54393", -- [52]
			--["name"] = "Ratchet, Northern Barrens",
			["m"] = 10,
			["f"] = 0,
			["direct"] = "3310:3615:7824:11899",
			["coord"] = 2971382975,
		},
		[43328] = {
			"8610:2995", -- [1]
			"8610:3310", -- [2]
			"8610:3310:3615", -- [3]
			"8610:12616:34943:35140:4312", -- [4]
			"8610:3310:3615:44399", -- [5]
			"8610:2995:6726", -- [6]
			"8610:3310:7824", -- [7]
			"8610:3310:3615:52060:39330:39898", -- [8]
			"8610:11139", -- [9]
			"8610:3310:16227:11899", -- [10]
			"8610:12616:34429:11901", -- [11]
			"8610:12616", -- [12]
			"8610:11139:12740", -- [13]
			"8610:3310:3615:52060:39330:39898:15178", -- [14]
			"8610:3310:3615:52060", -- [15]
			"8610:3310:7824:10583", -- [16]
			"8610:3310:16227", -- [17]
			"8610:12616:22931", -- [18]
			"8610:3310:16227:11899:40358", -- [19]
			"8610:12616:34429", -- [20]
			"8610:12616:34927", -- [21]
			"8610:12616:34943", -- [22]
			"8610:12616:34429:35141", -- [23]
			"8610:12616:34943:35140", -- [24]
			"8610:3310:3615:35139", -- [25]
			"8610:12616:34943:35140:4312:35315", -- [26]
			"8610:2995:35556:35478", -- [27]
			"8610:2995:35556", -- [28]
			"8610:12616:34943:35140:4312:35315:35562", -- [29]
			"8610:3310:7824:39175", -- [30]
			"8610:3310:3615:39340", -- [31]
			"8610:3310:3615:52060:39330", -- [32]
			"8610:2995:40809", -- [33]
			"8610:3310:40558", -- [34]
			"8610:3310:16227:11899:40358:40769", -- [35]
			"8610:3310:7824:41215", -- [36]
			"8610:3310:41140:41142", -- [37]
			"8610:3310:41140", -- [38]
			"8610:3310:7824:41214", -- [39]
			"8610:12616:34943:35140:41246", -- [40]
			"8610:36728:43549:50084", -- [41]
			"8610:36728:43549:50084:53783", -- [42]
			"8610:36728:43549:50084:41861", -- [43]
			"8610:2995:6726:40473", -- [44]
			"8610:3310:3615:52060:39330:39898:41605", -- [45]
			"8610:11139:43085:43073", -- [46]
			"8610:12616:22931:43079", -- [47]
			"8610:11139:43085", -- [48]
			"8610:37005", -- [49]
			"8610:36728:43549", -- [50]
			"8610:3310:7824:41215:48275", -- [51]
			"8610:3310:3615:52060:39330:39898:15178:48274", -- [52]
			"8610:3310:3615:52060:39330:39898:15178:48274:48273", -- [53]
			"8610:36728", -- [54]
			"8610:36728:43549:50084:54393", -- [55]
			--["name"] = "Northern Rocketway, Azshara",
			["m"] = 76,
			["f"] = 0,
			["direct"] = "8610",
			["coord"] = 2857448856,
		},
		[12616] = {
			"34927:3615:2995", -- [1]
			"34943:35140:4312", -- [2]
			"34927:3615:44399", -- [3]
			"34943:35140:4312:6726", -- [4]
			"34927:3615:52060:39330:40358:40769:7824", -- [5]
			"34927:3615:52060:39330:39898", -- [6]
			"36728:8610:11139", -- [7]
			"34927:3615:52060:11899", -- [8]
			"22931:43073:43085:12740", -- [9]
			"34927:3615:52060:39330:39898:15178", -- [10]
			"34927:3615:52060", -- [11]
			"34927:3615:52060:39330:40358:40769:7824:10583", -- [12]
			"34927:3615:16227", -- [13]
			"34927:3615:52060:39330:40358", -- [14]
			"34429:35141", -- [15]
			"34943:35140", -- [16]
			"34943:35140:35139", -- [17]
			"34943:35140:4312:35315", -- [18]
			"34943:35140:4312:35478", -- [19]
			"34927:3615:2995:35556", -- [20]
			"34943:35140:4312:35315:35562", -- [21]
			"34927:3615:52060:39330:40358:40769:7824:39175", -- [22]
			"34927:3615:39340", -- [23]
			"34927:3615:52060:39330", -- [24]
			"34927:3615:2995:40809", -- [25]
			"34927:40558", -- [26]
			"34927:3615:52060:39330:40358:40769", -- [27]
			"34927:3615:52060:39330:40358:40769:7824:41215", -- [28]
			"3310:41140:41142", -- [29]
			"3310:41140", -- [30]
			"34927:3615:52060:39330:40358:40769:7824:41214", -- [31]
			"34943:35140:41246", -- [32]
			"36728:43549:50084", -- [33]
			"36728:43549:50084:53783", -- [34]
			"36728:43549:50084:41861", -- [35]
			"34943:35140:4312:6726:40473", -- [36]
			"34927:3615:52060:39330:39898:41605", -- [37]
			"22931:43073", -- [38]
			"22931:43079", -- [39]
			"22931:43073:43085", -- [40]
			"36728:8610:37005", -- [41]
			"36728:8610:43328", -- [42]
			"36728:43549", -- [43]
			"34927:3615:52060:39330:40358:40769:7824:41215:48275", -- [44]
			"34927:3615:52060:39330:39898:15178:48274", -- [45]
			"34927:3615:52060:39330:39898:15178:48274:48273", -- [46]
			"36728:43549:50084:54393", -- [47]
			--["name"] = "Splintertree Post, Ashenvale",
			["m"] = 63,
			["f"] = 0,
			["direct"] = "3310:3615:8610:11901:22931:34429:34927:34943:36728",
			["coord"] = 3146423777,
		},
		[2995] = {
			"8610:11139", -- [1]
			"3615:34927:12616", -- [2]
			"3615:34927:12616:22931:43073:43085:12740", -- [3]
			"52060:39330:39898:15178", -- [4]
			"7824:10583", -- [5]
			"3615:16227", -- [6]
			"3615:34927:12616:22931", -- [7]
			"52060:39330:40358", -- [8]
			"35139:4312:34429", -- [9]
			"3615:34927", -- [10]
			"35139:35140:34943", -- [11]
			"35139:35141", -- [12]
			"35139:35140", -- [13]
			"35556:35562:35315", -- [14]
			"35556:35478", -- [15]
			"35556:35562", -- [16]
			"7824:39175", -- [17]
			"52060:39330", -- [18]
			"3615:40558", -- [19]
			"52060:39330:40358:40769", -- [20]
			"7824:41215", -- [21]
			"3310:41140:41142", -- [22]
			"3310:41140", -- [23]
			"7824:41214", -- [24]
			"35139:4312:41246", -- [25]
			"3310:43549:50084", -- [26]
			"3310:43549:50084:53783", -- [27]
			"3310:43549:50084:41861", -- [28]
			"6726:40473", -- [29]
			"52060:39330:39898:41605", -- [30]
			"3615:34927:12616:22931:43073", -- [31]
			"3615:34927:12616:22931:43079", -- [32]
			"3615:34927:12616:22931:43073:43085", -- [33]
			"3310:37005", -- [34]
			"8610:43328", -- [35]
			"3310:43549", -- [36]
			"7824:41215:48275", -- [37]
			"52060:39330:39898:15178:48274", -- [38]
			"52060:39330:39898:15178:48274:48273", -- [39]
			"3615:34927:12616:36728", -- [40]
			"3310:43549:50084:54393", -- [41]
			--["name"] = "Thunder Bluff, Mulgore",
			["m"] = 88,
			["f"] = 0,
			["direct"] = "3310:3615:4312:44399:6726:7824:39898:8610:11899:11901:52060:35139:35556:39340:40809",
			["coord"] = 2003861436,
		},
		[43079] = {
			"22931:34429:4312:35139:2995", -- [1]
			"22931:12616:3310", -- [2]
			"22931:12616:34927:3615", -- [3]
			"22931:34429:4312", -- [4]
			"22931:12616:34927:3615:44399", -- [5]
			"22931:34429:4312:6726", -- [6]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824", -- [7]
			"22931:12616:34927:3615:52060:39330:39898", -- [8]
			"22931:12616:36728:8610", -- [9]
			"43073:43085:11139", -- [10]
			"22931:12616:34927:3615:52060:11899", -- [11]
			"22931:34429:11901", -- [12]
			"22931:12616", -- [13]
			"43073:43085:12740", -- [14]
			"22931:12616:34927:3615:52060:39330:39898:15178", -- [15]
			"22931:12616:34927:3615:52060", -- [16]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:10583", -- [17]
			"22931:12616:34927:3615:16227", -- [18]
			"22931:12616:34927:3615:52060:39330:40358", -- [19]
			"22931:34429", -- [20]
			"22931:12616:34927", -- [21]
			"22931:34429:34943", -- [22]
			"22931:34429:35141", -- [23]
			"22931:34429:34943:35140", -- [24]
			"22931:34429:4312:35139", -- [25]
			"22931:34429:4312:35315", -- [26]
			"22931:34429:4312:35478", -- [27]
			"22931:34429:4312:35478:35556", -- [28]
			"22931:34429:4312:35315:35562", -- [29]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:39175", -- [30]
			"22931:12616:34927:3615:39340", -- [31]
			"22931:12616:34927:3615:52060:39330", -- [32]
			"22931:34429:4312:35139:2995:40809", -- [33]
			"22931:12616:34927:40558", -- [34]
			"22931:12616:34927:3615:52060:39330:40358:40769", -- [35]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:41215", -- [36]
			"22931:12616:3310:41140:41142", -- [37]
			"22931:12616:3310:41140", -- [38]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:41214", -- [39]
			"22931:34429:35141:41246", -- [40]
			"22931:12616:36728:43549:50084", -- [41]
			"22931:12616:36728:43549:50084:53783", -- [42]
			"43073:43085:12740:41861", -- [43]
			"22931:34429:4312:6726:40473", -- [44]
			"22931:12616:34927:3615:52060:39330:39898:41605", -- [45]
			"43073:43085", -- [46]
			"22931:12616:36728:8610:37005", -- [47]
			"22931:12616:36728:8610:43328", -- [48]
			"22931:12616:36728:43549", -- [49]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:41215:48275", -- [50]
			"22931:12616:34927:3615:52060:39330:39898:15178:48274", -- [51]
			"22931:12616:34927:3615:52060:39330:39898:15178:48274:48273", -- [52]
			"22931:12616:36728", -- [53]
			"22931:12616:36728:43549:50084:54393", -- [54]
			--["name"] = "Wildheart Point, Felwood",
			["m"] = 77,
			["f"] = 0,
			["direct"] = "22931:43073",
			["coord"] = 1899863695,
		},
		[41214] = {
			"7824:2995", -- [1]
			"7824:16227:3310", -- [2]
			"7824:3615", -- [3]
			"7824:2995:35139:4312", -- [4]
			"7824:44399", -- [5]
			"7824:39898:41605:40473:6726", -- [6]
			"7824:39898", -- [7]
			"7824:16227:3310:8610", -- [8]
			"7824:16227:3310:11139", -- [9]
			"7824:40769:40358:11899", -- [10]
			"7824:3615:34927:34429:11901", -- [11]
			"7824:3615:34927:12616", -- [12]
			"7824:16227:3310:43549:50084:41861:12740", -- [13]
			"7824:39175:15178", -- [14]
			"7824:40769:40358:11899:52060", -- [15]
			"7824:10583", -- [16]
			"7824:16227", -- [17]
			"7824:3615:34927:12616:22931", -- [18]
			"7824:40769:40358", -- [19]
			"7824:3615:34927:34429", -- [20]
			"7824:3615:34927", -- [21]
			"7824:3615:34927:34943", -- [22]
			"7824:2995:35139:35141", -- [23]
			"7824:2995:35139:35140", -- [24]
			"7824:2995:35139", -- [25]
			"7824:2995:35556:35562:35315", -- [26]
			"7824:2995:35556:35478", -- [27]
			"7824:2995:35556", -- [28]
			"7824:2995:35556:35562", -- [29]
			"7824:39175", -- [30]
			"7824:40769:40358:11899:52060:39340", -- [31]
			"7824:40769:40358:39330", -- [32]
			"7824:2995:40809", -- [33]
			"7824:3615:40558", -- [34]
			"7824:40769", -- [35]
			"7824:16227:3310:41140:41142", -- [36]
			"7824:16227:3310:41140", -- [37]
			"7824:2995:35139:4312:41246", -- [38]
			"7824:16227:3310:43549:50084", -- [39]
			"7824:16227:3310:43549:50084:53783", -- [40]
			"7824:16227:3310:43549:50084:41861", -- [41]
			"7824:39898:41605:40473", -- [42]
			"7824:39898:41605", -- [43]
			"7824:3615:34927:12616:22931:43073", -- [44]
			"7824:3615:34927:12616:22931:43079", -- [45]
			"7824:3615:34927:12616:22931:43073:43085", -- [46]
			"7824:16227:3310:37005", -- [47]
			"7824:16227:3310:8610:43328", -- [48]
			"7824:16227:3310:43549", -- [49]
			"41215:48275", -- [50]
			"41215:48275:48274", -- [51]
			"41215:48275:48273", -- [52]
			"7824:16227:3310:36728", -- [53]
			"7824:16227:3310:43549:50084:54393", -- [54]
			--["name"] = "Bootlegger Outpost, Tanaris",
			["m"] = 71,
			["coord"] = 2397215500,
			["direct"] = "7824:41215",
			["f"] = 0,
		},
		[7824] = {
			"2995:35139:4312", -- [1]
			"39898:41605:40473:6726", -- [2]
			"16227:3310:8610", -- [3]
			"16227:3310:11139", -- [4]
			"3615:34927:34429:11901", -- [5]
			"3615:34927:12616", -- [6]
			"16227:3310:43549:50084:41861:12740", -- [7]
			"40769:40358:11899:52060", -- [8]
			"3615:34927:12616:22931", -- [9]
			"40769:40358", -- [10]
			"3615:34927:34429", -- [11]
			"3615:34927", -- [12]
			"3615:34927:34943", -- [13]
			"2995:35139:35141", -- [14]
			"2995:35139:35140", -- [15]
			"2995:35139", -- [16]
			"2995:35556:35562:35315", -- [17]
			"2995:35556:35478", -- [18]
			"2995:35556", -- [19]
			"2995:35556:35562", -- [20]
			"40769:40358:11899:52060:39340", -- [21]
			"40769:40358:39330", -- [22]
			"2995:40809", -- [23]
			"3615:40558", -- [24]
			"16227:3310:41140:41142", -- [25]
			"16227:3310:41140", -- [26]
			"2995:35139:4312:41246", -- [27]
			"16227:3310:43549:50084", -- [28]
			"16227:3310:43549:50084:53783", -- [29]
			"16227:3310:43549:50084:41861", -- [30]
			"39898:41605:40473", -- [31]
			"39898:41605", -- [32]
			"3615:34927:12616:22931:43073", -- [33]
			"3615:34927:12616:22931:43079", -- [34]
			"3615:34927:12616:22931:43073:43085", -- [35]
			"16227:3310:37005", -- [36]
			"16227:3310:8610:43328", -- [37]
			"16227:3310:43549", -- [38]
			"41215:48275", -- [39]
			"39175:15178:48274", -- [40]
			"41215:48275:48273", -- [41]
			"16227:3310:36728", -- [42]
			"16227:3310:43549:50084:54393", -- [43]
			--["name"] = "Gadgetzan, Tanaris",
			["m"] = 71,
			["coord"] = 2233812594,
			["direct"] = "2995:3310:3615:44399:39898:11899:15178:10583:16227:39175:40769:41215:41214",
			["f"] = 0,
		},
		[43549] = {
			"3310:3615:2995", -- [1]
			"3310:3615", -- [2]
			"36728:12616:34943:35140:4312", -- [3]
			"3310:3615:44399", -- [4]
			"36728:12616:34943:35140:4312:6726", -- [5]
			"3310:7824", -- [6]
			"3310:3615:52060:39330:39898", -- [7]
			"36728:8610", -- [8]
			"50084:41861:11139", -- [9]
			"3310:16227:11899", -- [10]
			"36728:12616:34429:11901", -- [11]
			"36728:12616", -- [12]
			"50084:41861:12740", -- [13]
			"3310:3615:52060:39330:39898:15178", -- [14]
			"3310:3615:52060", -- [15]
			"3310:7824:10583", -- [16]
			"3310:16227", -- [17]
			"36728:12616:22931", -- [18]
			"3310:16227:11899:40358", -- [19]
			"36728:12616:34429", -- [20]
			"36728:12616:34927", -- [21]
			"36728:12616:34943", -- [22]
			"36728:12616:34429:35141", -- [23]
			"36728:12616:34943:35140", -- [24]
			"36728:12616:34943:35140:35139", -- [25]
			"36728:12616:34943:35140:4312:35315", -- [26]
			"36728:12616:34943:35140:4312:35478", -- [27]
			"3310:3615:2995:35556", -- [28]
			"36728:12616:34943:35140:4312:35315:35562", -- [29]
			"3310:7824:39175", -- [30]
			"3310:3615:39340", -- [31]
			"3310:3615:52060:39330", -- [32]
			"3310:3615:2995:40809", -- [33]
			"3310:40558", -- [34]
			"3310:16227:11899:40358:40769", -- [35]
			"3310:7824:41215", -- [36]
			"3310:41140:41142", -- [37]
			"3310:41140", -- [38]
			"3310:7824:41214", -- [39]
			"36728:12616:34943:35140:41246", -- [40]
			"50084:53783", -- [41]
			"50084:41861", -- [42]
			"36728:12616:34943:35140:4312:6726:40473", -- [43]
			"3310:3615:52060:39330:39898:41605", -- [44]
			"36728:12616:22931:43073", -- [45]
			"36728:12616:22931:43079", -- [46]
			"50084:41861:12740:43085", -- [47]
			"36728:8610:37005", -- [48]
			"36728:8610:43328", -- [49]
			"3310:7824:41215:48275", -- [50]
			"3310:3615:52060:39330:39898:15178:48274", -- [51]
			"3310:3615:52060:39330:39898:15178:48274:48273", -- [52]
			"50084:54393", -- [53]
			--["name"] = "Gates of Sothann, Hyjal",
			["m"] = 198,
			["f"] = 0,
			["direct"] = "3310:50084:36728",
			["coord"] = 3072770348,
		},
		[39330] = {
			"52060:2995", -- [1]
			"11899:16227:3310", -- [2]
			"52060:3615", -- [3]
			"52060:3615:4312", -- [4]
			"39898:41605:40473:6726", -- [5]
			"40358:40769:7824", -- [6]
			"52060:3615:8610", -- [7]
			"11899:16227:3310:11139", -- [8]
			"52060:3615:34927:34429:11901", -- [9]
			"52060:3615:34927:12616", -- [10]
			"52060:3615:34927:12616:22931:43073:43085:12740", -- [11]
			"39898:15178", -- [12]
			"40358:40769:7824:10583", -- [13]
			"11899:16227", -- [14]
			"52060:3615:34927:12616:22931", -- [15]
			"52060:3615:34927:34429", -- [16]
			"52060:3615:34927", -- [17]
			"52060:3615:34927:34943", -- [18]
			"52060:3615:4312:35141", -- [19]
			"52060:2995:35139:35140", -- [20]
			"52060:2995:35139", -- [21]
			"52060:2995:35556:35562:35315", -- [22]
			"52060:2995:35556:35478", -- [23]
			"52060:2995:35556", -- [24]
			"52060:2995:35556:35562", -- [25]
			"40358:40769:7824:39175", -- [26]
			"52060:2995:40809", -- [27]
			"52060:3615:40558", -- [28]
			"40358:40769", -- [29]
			"40358:40769:7824:41215", -- [30]
			"11899:16227:3310:41140:41142", -- [31]
			"11899:16227:3310:41140", -- [32]
			"40358:40769:7824:41214", -- [33]
			"52060:3615:4312:41246", -- [34]
			"11899:16227:3310:43549:50084", -- [35]
			"11899:16227:3310:43549:50084:53783", -- [36]
			"11899:16227:3310:43549:50084:41861", -- [37]
			"39898:41605:40473", -- [38]
			"39898:41605", -- [39]
			"52060:3615:34927:12616:22931:43073", -- [40]
			"52060:3615:34927:12616:22931:43079", -- [41]
			"52060:3615:34927:12616:22931:43073:43085", -- [42]
			"11899:16227:3310:37005", -- [43]
			"52060:3615:8610:43328", -- [44]
			"11899:16227:3310:43549", -- [45]
			"40358:40769:7824:41215:48275", -- [46]
			"39898:15178:48274", -- [47]
			"39898:15178:48274:48273", -- [48]
			"52060:3615:34927:12616:36728", -- [49]
			"11899:16227:3310:43549:50084:54393", -- [50]
			--["name"] = "Desolation Hold, Southern Barrens",
			["m"] = 199,
			["f"] = 0,
			["direct"] = "44399:39898:11899:52060:40358:39340",
			["coord"] = 1769714932,
		},
		[53783] = {
			"50084:43549:3310:3615:2995", -- [1]
			"50084:43549:3310", -- [2]
			"50084:43549:3310:3615", -- [3]
			"50084:43549:36728:12616:34943:35140:4312", -- [4]
			"50084:43549:3310:3615:44399", -- [5]
			"50084:43549:36728:12616:34943:35140:4312:6726", -- [6]
			"50084:43549:3310:7824", -- [7]
			"50084:43549:3310:3615:52060:39330:39898", -- [8]
			"50084:43549:36728:8610", -- [9]
			"41861:11139", -- [10]
			"50084:43549:3310:16227:11899", -- [11]
			"50084:43549:36728:12616:34429:11901", -- [12]
			"50084:43549:36728:12616", -- [13]
			"41861:12740", -- [14]
			"50084:43549:3310:3615:52060:39330:39898:15178", -- [15]
			"50084:43549:3310:3615:52060", -- [16]
			"50084:43549:3310:7824:10583", -- [17]
			"50084:43549:3310:16227", -- [18]
			"50084:43549:36728:12616:22931", -- [19]
			"50084:43549:3310:16227:11899:40358", -- [20]
			"50084:43549:36728:12616:34429", -- [21]
			"50084:43549:36728:12616:34927", -- [22]
			"50084:43549:36728:12616:34943", -- [23]
			"50084:43549:36728:12616:34429:35141", -- [24]
			"50084:43549:36728:12616:34943:35140", -- [25]
			"50084:43549:36728:12616:34943:35140:35139", -- [26]
			"50084:43549:36728:12616:34943:35140:4312:35315", -- [27]
			"50084:43549:36728:12616:34943:35140:4312:35478", -- [28]
			"50084:43549:3310:3615:2995:35556", -- [29]
			"50084:43549:36728:12616:34943:35140:4312:35315:35562", -- [30]
			"50084:43549:3310:7824:39175", -- [31]
			"50084:43549:3310:3615:39340", -- [32]
			"50084:43549:3310:3615:52060:39330", -- [33]
			"50084:43549:3310:3615:2995:40809", -- [34]
			"50084:43549:3310:40558", -- [35]
			"50084:43549:3310:16227:11899:40358:40769", -- [36]
			"50084:43549:3310:7824:41215", -- [37]
			"50084:43549:3310:41140:41142", -- [38]
			"50084:43549:3310:41140", -- [39]
			"50084:43549:3310:7824:41214", -- [40]
			"50084:43549:36728:12616:34943:35140:41246", -- [41]
			"50084:43549:36728:12616:34943:35140:4312:6726:40473", -- [42]
			"50084:43549:3310:3615:52060:39330:39898:41605", -- [43]
			"41861:12740:43085:43073", -- [44]
			"50084:43549:36728:12616:22931:43079", -- [45]
			"41861:12740:43085", -- [46]
			"50084:43549:36728:8610:37005", -- [47]
			"50084:43549:36728:8610:43328", -- [48]
			"50084:43549", -- [49]
			"50084:43549:3310:7824:41215:48275", -- [50]
			"50084:43549:3310:3615:52060:39330:39898:15178:48274", -- [51]
			"50084:43549:3310:3615:52060:39330:39898:15178:48274:48273", -- [52]
			"50084:43549:36728", -- [53]
			"50084:54393", -- [54]
			--["name"] = "Grove of Aessina, Hyjal",
			["m"] = 198,
			["f"] = 0,
			["direct"] = "50084:41861",
			["coord"] = 841047383,
		},
	}, -- [1]
	[2] = {
		[43114] = {
			"43121:6026:43086:13177:2861:2851:2389:2226", -- [1]
			"43121:6026:43086:13177:2861:4551", -- [2]
			"43121:6026:43086:13177:2861:2851:2389", -- [3]
			"43121:6026:43086:13177:2861:2851", -- [4]
			"2858:1387", -- [5]
			"43121:6026:43086:13177:2861", -- [6]
			"43121:6026", -- [7]
			"43121:6026:43086:13177:2861:44407:12636", -- [8]
			"43121:6026:43086:13177", -- [9]
			"43121:6026:43086:13177:3305", -- [10]
			"43121:6026:43086:13177:2861:2851:4314", -- [11]
			"43121:6026:43086:13177:2861:44407:12636:16189:16192", -- [12]
			"43121:6026:43086:13177:2861:44407:12636:16189", -- [13]
			"43121:6026:43086:13177:2861:2851:43573:37888:44232:44233", -- [14]
			"43121:6026:43086:13177:2861:44407:12636:44230:28621", -- [15]
			"43121:6026:43086:13177:2861:44407:12636:44230", -- [16]
			"43121:6026:43086:13177:2861:2851:43573:37888:44232", -- [17]
			"43121:6026:43086:13177:2861:44407:12636:24851", -- [18]
			"43121:6026:43086:13177:2861:44407:12636:24851:26560", -- [19]
			"43121:6026:43086:13177:2861:2851:43573:37888", -- [20]
			"43121:6026:43086:13177:2861:2851:43573:46004:37915", -- [21]
			"43121:6026:43086:13177:2861:2851:43573:46004:37915:43124", -- [22]
			"2858:43053", -- [23]
			"2858:43053:43052", -- [24]
			"43121:6026:43086", -- [25]
			"43121:6026:43086:13177:2861:2851:43104", -- [26]
			"43121:6026:43086:13177:2861:2851:43573", -- [27]
			"43121:6026:43086:13177:2861:44407:12636:16189:44036", -- [28]
			"43121:6026:43086:13177:2861:2851:43573:37888:44232:44231", -- [29]
			"43121:6026:43086:13177:2861:44407:12636:16189:16192:44244", -- [30]
			"43121:6026:43086:13177:2861:44408", -- [31]
			"43121:6026:43086:13177:2861:44407", -- [32]
			"43121:6026:43086:13177:2861:2851:43573:46004:37915:44825", -- [33]
			"43121:6026:43086:13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [34]
			"43121:6026:43086:13177:2861:2851:43573:46004", -- [35]
			"43121:6026:43086:13177:2861:2851:43573:46004:46011", -- [36]
			"43121:6026:43086:13177:2861:2851:43104:47661:47644:47655:46552", -- [37]
			"43121:6026:43086:13177:2861:47121:47133:47116", -- [38]
			"43121:6026:43086:13177:2861:47121:47133", -- [39]
			"43121:6026:43086:13177:2861:47121", -- [40]
			"43121:6026:43086:13177:2861:47121:47133:47156", -- [41]
			"43121:6026:43086:13177:2861:47174:47061", -- [42]
			"43121:6026:43086:13177:2861:47174", -- [43]
			"43121:6026:43086:13177:2861:2851:43104:47661:47644", -- [44]
			"43121:6026:43086:13177:2861:2851:43104:47661:47644:47655", -- [45]
			"43121:6026:43086:13177:2861:2851:43104:47661", -- [46]
			"43121:6026:43086:13177:2861:2851:2389:47665", -- [47]
			"43121:6026:43086:13177:2861:2851:43573:46004:46011:47875", -- [48]
			"43121:6026:43086:13177:48321:48318:47927", -- [49]
			"43121:6026:43086:13177:48321:48318", -- [50]
			"43121:6026:43086:13177:48321", -- [51]
			"43121:6026:43086:13177:2861:2851:43573:46004:37915:44825:50463", -- [52]
			["direct"] = "2858:43121",
			["coord"] = 2189605479,
			["m"] = 17,
			["f"] = 0,
		},
		[13177] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"1387:2858", -- [5]
			"2861:44407:12636", -- [6]
			"2861:2851:4314", -- [7]
			"2861:44407:12636:16189:16192", -- [8]
			"2861:44407:12636:16189", -- [9]
			"2861:2851:43573:37888:44232:44233", -- [10]
			"2861:44407:12636:44230:28621", -- [11]
			"2861:44407:12636:44230", -- [12]
			"2861:2851:43573:37888:44232", -- [13]
			"2861:44407:12636:24851", -- [14]
			"2861:44407:12636:24851:26560", -- [15]
			"2861:2851:43573:37888", -- [16]
			"2861:2851:43573:46004:37915", -- [17]
			"2861:2851:43573:46004:37915:43124", -- [18]
			"1387:43053", -- [19]
			"1387:43052", -- [20]
			"2861:2851:43104", -- [21]
			"2861:2851:43573", -- [22]
			"2861:44407:12636:16189:44036", -- [23]
			"2861:2851:43573:37888:44232:44231", -- [24]
			"2861:44407:12636:16189:16192:44244", -- [25]
			"2861:44408", -- [26]
			"2861:44407", -- [27]
			"2861:2851:43573:46004:37915:44825", -- [28]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [29]
			"2861:2851:43573:46004", -- [30]
			"2861:2851:43573:46004:46011", -- [31]
			"2861:2851:43104:47661:47644:47655:46552", -- [32]
			"2861:47121:47133:47116", -- [33]
			"2861:47121:47133", -- [34]
			"2861:47121", -- [35]
			"2861:47121:47133:47156", -- [36]
			"2861:47174:47061", -- [37]
			"2861:47174", -- [38]
			"2861:2851:43104:47661:47644", -- [39]
			"2861:2851:43104:47661:47644:47655", -- [40]
			"2861:2851:43104:47661", -- [41]
			"2861:2851:2389:47665", -- [42]
			"2861:2851:43573:46004:46011:47875", -- [43]
			"48321:48318:47927", -- [44]
			"48321:48318", -- [45]
			"2861:2851:43573:46004:37915:44825:50463", -- [46]
			"43086:6026:85734", -- [47]
			--["name"] = "Flame Crest, Burning Steppes",
			["m"] = 36,
			["f"] = 0,
			["direct"] = "1387:2861:6026:3305:43086:48321",
			["coord"] = 2330279398,
		},
		[28621] = {
			"44232:37888:37915:44825:2226", -- [1]
			"44232:37888:4551", -- [2]
			"44232:37888:2389", -- [3]
			"44232:37888:43573:2851", -- [4]
			"44230:12636:44407:2861:2858", -- [5]
			"44230:12636:44407:2861:1387", -- [6]
			"44230:12636:44407:2861", -- [7]
			"44230:12636:44407:2861:13177:43086:6026", -- [8]
			"44230:12636", -- [9]
			"44230:12636:44407:2861:13177", -- [10]
			"44230:12636:44407:2861:3305", -- [11]
			"44230:12636:4314", -- [12]
			"44230:12636:16189:16192", -- [13]
			"44230:12636:16189", -- [14]
			"44230:12636:24851", -- [15]
			"44230:12636:24851:26560", -- [16]
			"44232:37888", -- [17]
			"44232:37888:37915", -- [18]
			"44232:37888:37915:43124", -- [19]
			"44230:12636:44407:2861:1387:43053", -- [20]
			"44230:12636:44407:2861:1387:43052", -- [21]
			"44230:12636:44407:2861:13177:43086", -- [22]
			"44232:37888:2389:43104", -- [23]
			"44232:37888:43573", -- [24]
			"44230:12636:16189:44036", -- [25]
			"44230:44231", -- [26]
			"44230:12636:16189:16192:44244", -- [27]
			"44230:12636:44407:44408", -- [28]
			"44230:12636:44407", -- [29]
			"44232:37888:37915:44825", -- [30]
			"44232:37888:37915:44825:2226:46552:45479", -- [31]
			"44232:37888:46011:46004", -- [32]
			"44232:37888:46011", -- [33]
			"44232:37888:37915:44825:2226:46552", -- [34]
			"44232:37888:43573:2851:47121:47133:47116", -- [35]
			"44232:37888:43573:2851:47121:47133", -- [36]
			"44232:37888:43573:2851:47121", -- [37]
			"44232:37888:43573:2851:47121:47133:47156", -- [38]
			"44232:37888:43573:2851:47121:47133:47156:47061", -- [39]
			"44232:37888:43573:2851:47174", -- [40]
			"44232:37888:2389:47644", -- [41]
			"44232:37888:2389:47644:47655", -- [42]
			"44232:37888:2389:47661", -- [43]
			"44232:37888:37915:47665", -- [44]
			"44233:47875", -- [45]
			"44230:12636:44407:2861:3305:47927", -- [46]
			"44230:12636:44407:2861:13177:48321:48318", -- [47]
			"44230:12636:44407:2861:13177:48321", -- [48]
			"44232:37888:37915:44825:50463", -- [49]
			"44230:12636:44407:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Northpass Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 2202547784,
			["direct"] = "44233:44230:44232",
			["f"] = 0,
		},
		[47156] = {
			"47133:47121:2851:2389:2226", -- [1]
			"47133:47121:2851:43573:46004:37915:4551", -- [2]
			"47133:47121:2851:2389", -- [3]
			"47133:47121:2851", -- [4]
			"47133:47121:2861:2858", -- [5]
			"47133:47121:2861:1387", -- [6]
			"47133:47121:2861", -- [7]
			"47133:47121:2861:13177:43086:6026", -- [8]
			"47133:47121:2851:43573:37888:12636", -- [9]
			"47133:47121:2861:13177", -- [10]
			"47133:47121:2861:3305", -- [11]
			"47133:47121:2851:4314", -- [12]
			"47133:47121:2851:43573:37888:12636:16189:16192", -- [13]
			"47133:47121:2851:43573:37888:12636:16189", -- [14]
			"47133:47121:2851:43573:37888:44232:44233", -- [15]
			"47133:47121:2851:43573:37888:44232:28621", -- [16]
			"47133:47121:2851:43573:37888:44232:44231:44230", -- [17]
			"47133:47121:2851:43573:37888:44232", -- [18]
			"47133:47121:2851:43573:37888:12636:24851", -- [19]
			"47133:47121:2851:43573:37888:12636:24851:26560", -- [20]
			"47133:47121:2851:43573:37888", -- [21]
			"47133:47121:2851:43573:46004:37915", -- [22]
			"47133:47121:2851:43573:46004:37915:43124", -- [23]
			"47133:47121:2861:1387:43053", -- [24]
			"47133:47121:2861:1387:43052", -- [25]
			"47133:47121:2861:13177:43086", -- [26]
			"47133:47121:2851:43104", -- [27]
			"47133:47121:2851:43573", -- [28]
			"47133:47121:2851:43573:37888:12636:16189:44036", -- [29]
			"47133:47121:2851:43573:37888:44232:44231", -- [30]
			"47133:47121:2851:43573:37888:12636:16189:16192:44244", -- [31]
			"47133:47121:2861:44408", -- [32]
			"47133:47121:2861:44407", -- [33]
			"47133:47121:2851:43573:46004:37915:44825", -- [34]
			"47133:47121:2851:43104:47661:47644:47655:46552:45479", -- [35]
			"47133:47121:2851:43573:46004", -- [36]
			"47133:47121:2851:43573:46004:46011", -- [37]
			"47133:47121:2851:43104:47661:47644:47655:46552", -- [38]
			"47133:47121", -- [39]
			"47133:47121:2851:43104:47661:47644", -- [40]
			"47133:47121:2851:43104:47661:47644:47655", -- [41]
			"47133:47121:2851:43104:47661", -- [42]
			"47133:47121:2851:2389:47665", -- [43]
			"47133:47121:2851:43573:46004:46011:47875", -- [44]
			"47133:47121:2861:3305:47927", -- [45]
			"47133:47121:2861:13177:48321:48318", -- [46]
			"47133:47121:2861:13177:48321", -- [47]
			"47133:47121:2851:43573:46004:37915:44825:50463", -- [48]
			"47133:47121:2861:13177:43086:6026:85734", -- [49]
			--["name"] = "Bloodgulch, Twilight Highlands",
			["m"] = 241,
			["f"] = 0,
			["direct"] = "47116:47133:47061:47174",
			["coord"] = 2322885606,
		},
		[43573] = {
			"2389:2226", -- [1]
			"46004:37915:4551", -- [2]
			"2851:2861:2858", -- [3]
			"2851:2861:1387", -- [4]
			"2851:2861", -- [5]
			"2851:2861:13177:43086:6026", -- [6]
			"37888:12636", -- [7]
			"2851:2861:13177", -- [8]
			"2851:2861:3305", -- [9]
			"37888:12636:16189:16192", -- [10]
			"37888:12636:16189", -- [11]
			"37888:44232:44233", -- [12]
			"37888:44232:28621", -- [13]
			"37888:44232:44231:44230", -- [14]
			"37888:44232", -- [15]
			"37888:12636:24851", -- [16]
			"37888:12636:24851:26560", -- [17]
			"46004:37915", -- [18]
			"46004:37915:43124", -- [19]
			"2851:2861:1387:43053", -- [20]
			"2851:2861:1387:43052", -- [21]
			"2851:2861:13177:43086", -- [22]
			"2851:43104", -- [23]
			"37888:12636:16189:44036", -- [24]
			"37888:44232:44231", -- [25]
			"37888:12636:16189:16192:44244", -- [26]
			"2851:2861:44408", -- [27]
			"2851:2861:44407", -- [28]
			"46004:37915:44825", -- [29]
			"2389:47644:47655:46552:45479", -- [30]
			"46004:46011", -- [31]
			"2389:47644:47655:46552", -- [32]
			"2851:47121:47133:47116", -- [33]
			"2851:47121:47133", -- [34]
			"2851:47121", -- [35]
			"2851:47121:47133:47156", -- [36]
			"2851:47121:47133:47156:47061", -- [37]
			"2851:47174", -- [38]
			"2389:47644", -- [39]
			"2389:47644:47655", -- [40]
			"2389:47661", -- [41]
			"2389:47665", -- [42]
			"46004:46011:47875", -- [43]
			"2851:2861:3305:47927", -- [44]
			"2851:2861:13177:48321:48318", -- [45]
			"2851:2861:13177:48321", -- [46]
			"46004:37915:44825:50463", -- [47]
			"2851:2861:13177:43086:6026:85734", -- [48]
			--["name"] = "Hiri'watha Research Station, The Hinterlands",
			["m"] = 26,
			["f"] = 0,
			["direct"] = "2389:2851:4314:37888:46004",
			["coord"] = 1390908635,
		},
		[43124] = {
			"44825:2226", -- [1]
			"37915:2389", -- [2]
			"37915:46004:43573:2851", -- [3]
			"37915:46004:43573:2851:2861:2858", -- [4]
			"37915:46004:43573:2851:2861:1387", -- [5]
			"37915:46004:43573:2851:2861", -- [6]
			"37915:46004:43573:2851:2861:13177:43086:6026", -- [7]
			"37915:37888:12636", -- [8]
			"37915:46004:43573:2851:2861:13177", -- [9]
			"37915:46004:43573:2851:2861:3305", -- [10]
			"37915:46004:43573:4314", -- [11]
			"37915:37888:12636:16189:16192", -- [12]
			"37915:37888:12636:16189", -- [13]
			"37915:46004:46011:47875:44233", -- [14]
			"37915:37888:44232:28621", -- [15]
			"37915:37888:44232:44231:44230", -- [16]
			"37915:37888:44232", -- [17]
			"37915:37888:12636:24851", -- [18]
			"37915:37888:12636:24851:26560", -- [19]
			"37915:37888", -- [20]
			"37915:46004:43573:2851:2861:1387:43053", -- [21]
			"37915:46004:43573:2851:2861:1387:43052", -- [22]
			"37915:46004:43573:2851:2861:13177:43086", -- [23]
			"37915:2389:43104", -- [24]
			"37915:46004:43573", -- [25]
			"37915:37888:12636:16189:44036", -- [26]
			"37915:37888:44232:44231", -- [27]
			"37915:37888:12636:16189:16192:44244", -- [28]
			"37915:46004:43573:2851:2861:44408", -- [29]
			"37915:46004:43573:2851:2861:44407", -- [30]
			"44825:2226:46552:45479", -- [31]
			"37915:46004", -- [32]
			"37915:46004:46011", -- [33]
			"44825:2226:46552", -- [34]
			"37915:46004:43573:2851:47121:47133:47116", -- [35]
			"37915:46004:43573:2851:47121:47133", -- [36]
			"37915:46004:43573:2851:47121", -- [37]
			"37915:46004:43573:2851:47121:47133:47156", -- [38]
			"37915:46004:43573:2851:47121:47133:47156:47061", -- [39]
			"37915:46004:43573:2851:47174", -- [40]
			"37915:2389:47644", -- [41]
			"44825:2226:46552:47655", -- [42]
			"37915:2389:47661", -- [43]
			"37915:47665", -- [44]
			"37915:46004:46011:47875", -- [45]
			"37915:46004:43573:2851:2861:3305:47927", -- [46]
			"37915:46004:43573:2851:2861:13177:48321:48318", -- [47]
			"37915:46004:43573:2851:2861:13177:48321", -- [48]
			"44825:50463", -- [49]
			"37915:46004:43573:2851:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Brill, Tirisfal Glades",
			["m"] = 18,
			["f"] = 0,
			["direct"] = "4551:37915:44825",
			["coord"] = 2529461497,
		},
		[37915] = {
			"44825:2226", -- [1]
			"46004:43573:2851", -- [2]
			"46004:43573:2851:2861:2858", -- [3]
			"46004:43573:2851:2861:1387", -- [4]
			"46004:43573:2851:2861", -- [5]
			"46004:43573:2851:2861:13177:43086:6026", -- [6]
			"37888:12636", -- [7]
			"46004:43573:2851:2861:13177", -- [8]
			"46004:43573:2851:2861:3305", -- [9]
			"46004:43573:4314", -- [10]
			"37888:12636:16189:16192", -- [11]
			"37888:12636:16189", -- [12]
			"46004:46011:47875:44233", -- [13]
			"37888:44232:28621", -- [14]
			"37888:44232:44231:44230", -- [15]
			"37888:44232", -- [16]
			"37888:12636:24851", -- [17]
			"37888:12636:24851:26560", -- [18]
			"46004:43573:2851:2861:1387:43053", -- [19]
			"46004:43573:2851:2861:1387:43052", -- [20]
			"46004:43573:2851:2861:13177:43086", -- [21]
			"2389:43104", -- [22]
			"46004:43573", -- [23]
			"37888:12636:16189:44036", -- [24]
			"37888:44232:44231", -- [25]
			"37888:12636:16189:16192:44244", -- [26]
			"46004:43573:2851:2861:44408", -- [27]
			"46004:43573:2851:2861:44407", -- [28]
			"44825:2226:46552:45479", -- [29]
			"46004:46011", -- [30]
			"44825:2226:46552", -- [31]
			"46004:43573:2851:47121:47133:47116", -- [32]
			"46004:43573:2851:47121:47133", -- [33]
			"46004:43573:2851:47121", -- [34]
			"46004:43573:2851:47121:47133:47156", -- [35]
			"46004:43573:2851:47121:47133:47156:47061", -- [36]
			"46004:43573:2851:47174", -- [37]
			"2389:47644", -- [38]
			"2389:47644:47655", -- [39]
			"2389:47661", -- [40]
			"46004:46011:47875", -- [41]
			"46004:43573:2851:2861:3305:47927", -- [42]
			"46004:43573:2851:2861:13177:48321:48318", -- [43]
			"46004:43573:2851:2861:13177:48321", -- [44]
			"44825:50463", -- [45]
			"46004:43573:2851:2861:13177:43086:6026:85734", -- [46]
			--["name"] = "The Bulwark, Tirisfal",
			["m"] = 18,
			["f"] = 0,
			["direct"] = "4551:2389:37888:43124:44825:46004:47665",
			["coord"] = 3587421025,
		},
		[44408] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"2861:2858", -- [5]
			"2861:1387", -- [6]
			"2861:13177:43086:6026", -- [7]
			"44407:12636", -- [8]
			"2861:13177", -- [9]
			"2861:3305", -- [10]
			"2861:2851:4314", -- [11]
			"44407:12636:16189:16192", -- [12]
			"44407:12636:16189", -- [13]
			"44407:12636:44230:44233", -- [14]
			"44407:12636:44230:28621", -- [15]
			"44407:12636:44230", -- [16]
			"44407:12636:44231:44232", -- [17]
			"44407:12636:24851", -- [18]
			"44407:12636:24851:26560", -- [19]
			"2861:2851:43573:37888", -- [20]
			"2861:2851:43573:46004:37915", -- [21]
			"2861:2851:43573:46004:37915:43124", -- [22]
			"2861:1387:43053", -- [23]
			"2861:1387:43052", -- [24]
			"2861:13177:43086", -- [25]
			"2861:2851:43104", -- [26]
			"2861:2851:43573", -- [27]
			"44407:12636:16189:44036", -- [28]
			"44407:12636:44231", -- [29]
			"44407:12636:16189:16192:44244", -- [30]
			"2861:2851:43573:46004:37915:44825", -- [31]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [32]
			"2861:2851:43573:46004", -- [33]
			"2861:2851:43573:46004:46011", -- [34]
			"2861:2851:43104:47661:47644:47655:46552", -- [35]
			"2861:47121:47133:47116", -- [36]
			"2861:47121:47133", -- [37]
			"2861:47121", -- [38]
			"2861:47121:47133:47156", -- [39]
			"2861:47174:47061", -- [40]
			"2861:47174", -- [41]
			"2861:2851:43104:47661:47644", -- [42]
			"2861:2851:43104:47661:47644:47655", -- [43]
			"2861:2851:43104:47661", -- [44]
			"2861:2851:2389:47665", -- [45]
			"2861:2851:43573:46004:46011:47875", -- [46]
			"2861:3305:47927", -- [47]
			"2861:13177:48321:48318", -- [48]
			"2861:13177:48321", -- [49]
			"2861:2851:43573:46004:37915:44825:50463", -- [50]
			"2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Bloodwatcher Point, Badlands",
			["m"] = 15,
			["f"] = 0,
			["direct"] = "2861:44407",
			["coord"] = 2250867271,
		},
		[24851] = {
			"12636:37888:37915:44825:2226", -- [1]
			"12636:37888:4551", -- [2]
			"12636:37888:2389", -- [3]
			"12636:4314:2851", -- [4]
			"12636:44407:2861:2858", -- [5]
			"12636:44407:2861:1387", -- [6]
			"12636:44407:2861", -- [7]
			"12636:44407:2861:13177:43086:6026", -- [8]
			"12636:44407:2861:13177", -- [9]
			"12636:44407:2861:3305", -- [10]
			"12636:4314", -- [11]
			"16189:16192", -- [12]
			"12636:44230:44233", -- [13]
			"12636:44230:28621", -- [14]
			"12636:44230", -- [15]
			"12636:44231:44232", -- [16]
			"12636:37888", -- [17]
			"12636:37888:37915", -- [18]
			"12636:37888:37915:43124", -- [19]
			"12636:44407:2861:1387:43053", -- [20]
			"12636:44407:2861:1387:43052", -- [21]
			"12636:44407:2861:13177:43086", -- [22]
			"12636:37888:2389:43104", -- [23]
			"12636:37888:43573", -- [24]
			"16189:44036", -- [25]
			"12636:44231", -- [26]
			"16189:16192:44244", -- [27]
			"12636:44407:44408", -- [28]
			"12636:44407", -- [29]
			"12636:37888:37915:44825", -- [30]
			"12636:37888:37915:44825:2226:46552:45479", -- [31]
			"12636:37888:46011:46004", -- [32]
			"12636:37888:46011", -- [33]
			"12636:37888:37915:44825:2226:46552", -- [34]
			"12636:4314:2851:47121:47133:47116", -- [35]
			"12636:4314:2851:47121:47133", -- [36]
			"12636:4314:2851:47121", -- [37]
			"12636:4314:2851:47121:47133:47156", -- [38]
			"12636:4314:2851:47121:47133:47156:47061", -- [39]
			"12636:4314:2851:47174", -- [40]
			"12636:37888:2389:47644", -- [41]
			"12636:37888:2389:47644:47655", -- [42]
			"12636:37888:2389:47661", -- [43]
			"12636:37888:37915:47665", -- [44]
			"12636:44230:44233:47875", -- [45]
			"12636:44407:2861:3305:47927", -- [46]
			"12636:44407:2861:13177:48321:48318", -- [47]
			"12636:44407:2861:13177:48321", -- [48]
			"12636:37888:37915:44825:50463", -- [49]
			"12636:44407:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Zul'Aman, Ghostlands",
			["m"] = 95,
			["coord"] = 3207244762,
			["direct"] = "12636:16189:26560",
			["f"] = 0,
		},
		[6026] = {
			"43086:13177:2861:2851:2389:2226", -- [1]
			"43086:13177:2861:4551", -- [2]
			"43086:13177:2861:2851:2389", -- [3]
			"43086:13177:2861:2851", -- [4]
			"43086:13177:2861:44407:12636", -- [5]
			"43086:13177:3305", -- [6]
			"43086:13177:2861:2851:4314", -- [7]
			"43086:13177:2861:44407:12636:16189:16192", -- [8]
			"43086:13177:2861:44407:12636:16189", -- [9]
			"43086:13177:2861:2851:43573:37888:44232:44233", -- [10]
			"43086:13177:2861:44407:12636:44230:28621", -- [11]
			"43086:13177:2861:44407:12636:44230", -- [12]
			"43086:13177:2861:2851:43573:37888:44232", -- [13]
			"43086:13177:2861:44407:12636:24851", -- [14]
			"43086:13177:2861:44407:12636:24851:26560", -- [15]
			"43086:13177:2861:2851:43573:37888", -- [16]
			"43086:13177:2861:2851:43573:46004:37915", -- [17]
			"43086:13177:2861:2851:43573:46004:37915:43124", -- [18]
			"1387:43053", -- [19]
			"85734:43052", -- [20]
			"43086:13177:2861:2851:43104", -- [21]
			"43086:13177:2861:2851:43573", -- [22]
			"43086:13177:2861:44407:12636:16189:44036", -- [23]
			"43086:13177:2861:2851:43573:37888:44232:44231", -- [24]
			"43086:13177:2861:44407:12636:16189:16192:44244", -- [25]
			"43086:13177:2861:44408", -- [26]
			"43086:13177:2861:44407", -- [27]
			"43086:13177:2861:2851:43573:46004:37915:44825", -- [28]
			"43086:13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [29]
			"43086:13177:2861:2851:43573:46004", -- [30]
			"43086:13177:2861:2851:43573:46004:46011", -- [31]
			"43086:13177:2861:2851:43104:47661:47644:47655:46552", -- [32]
			"43086:13177:2861:47121:47133:47116", -- [33]
			"43086:13177:2861:47121:47133", -- [34]
			"43086:13177:2861:47121", -- [35]
			"43086:13177:2861:47121:47133:47156", -- [36]
			"43086:13177:2861:47174:47061", -- [37]
			"43086:13177:2861:47174", -- [38]
			"43086:13177:2861:2851:43104:47661:47644", -- [39]
			"43086:13177:2861:2851:43104:47661:47644:47655", -- [40]
			"43086:13177:2861:2851:43104:47661", -- [41]
			"43086:13177:2861:2851:2389:47665", -- [42]
			"43086:13177:2861:2851:43573:46004:46011:47875", -- [43]
			"43086:13177:48321:48318:47927", -- [44]
			"43086:13177:48321:48318", -- [45]
			"43086:13177:48321", -- [46]
			"43086:13177:2861:2851:43573:46004:37915:44825:50463", -- [47]
			--["name"] = "Stonard, Swamp of Sorrows",
			["m"] = 51,
			["coord"] = 2051378439,
			["direct"] = "2858:1387:2861:13177:43086",
			["f"] = 0,
		},
		[3305] = {
			"2861:2851:2389:2226", -- [1]
			"43220:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"13177:1387:2858", -- [5]
			"13177:1387", -- [6]
			"13177:43086:6026", -- [7]
			"2861:44407:12636", -- [8]
			"2861:2851:4314", -- [9]
			"2861:44407:12636:16189:16192", -- [10]
			"2861:44407:12636:16189", -- [11]
			"2861:2851:43573:37888:44232:44233", -- [12]
			"2861:44407:12636:44230:28621", -- [13]
			"2861:44407:12636:44230", -- [14]
			"2861:2851:43573:37888:44232", -- [15]
			"2861:44407:12636:24851", -- [16]
			"2861:44407:12636:24851:26560", -- [17]
			"2861:2851:43573:37888", -- [18]
			"2861:2851:43573:46004:37915", -- [19]
			"2861:2851:43573:46004:37915:43124", -- [20]
			"13177:1387:43053", -- [21]
			"13177:1387:43052", -- [22]
			"13177:43086", -- [23]
			"2861:2851:43104", -- [24]
			"2861:2851:43573", -- [25]
			"2861:44407:12636:16189:44036", -- [26]
			"2861:2851:43573:37888:44232:44231", -- [27]
			"2861:44407:12636:16189:16192:44244", -- [28]
			"2861:44408", -- [29]
			"2861:44407", -- [30]
			"2861:2851:43573:46004:37915:44825", -- [31]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [32]
			"2861:2851:43573:46004", -- [33]
			"2861:2851:43573:46004:46011", -- [34]
			"2861:2851:43104:47661:47644:47655:46552", -- [35]
			"2861:47121:47133:47116", -- [36]
			"2861:47121:47133", -- [37]
			"2861:47121", -- [38]
			"2861:47121:47133:47156", -- [39]
			"2861:47174:47061", -- [40]
			"2861:47174", -- [41]
			"2861:2851:43104:47661:47644", -- [42]
			"2861:2851:43104:47661:47644:47655", -- [43]
			"2861:2851:43104:47661", -- [44]
			"2861:2851:2389:47665", -- [45]
			"2861:2851:43573:46004:46011:47875", -- [46]
			"47927:48318", -- [47]
			"13177:48321", -- [48]
			"2861:2851:43573:46004:37915:44825:50463", -- [49]
			"13177:43086:6026:85734", -- [50]
			["direct"] = "2861:13177:43220:47927",
			["m"] = 32,
			["coord"] = 1496010313,
			["f"] = 0,
		},
		[45479] = {
			"2226:4551", -- [1]
			"46552:47655:47644:2389", -- [2]
			"46552:47655:47644:47661:43104:2851", -- [3]
			"46552:47655:47644:47661:43104:2851:2861:2858", -- [4]
			"46552:47655:47644:47661:43104:2851:2861:1387", -- [5]
			"46552:47655:47644:47661:43104:2851:2861", -- [6]
			"46552:47655:47644:47661:43104:2851:2861:13177:43086:6026", -- [7]
			"46552:47655:47644:2389:37888:12636", -- [8]
			"46552:47655:47644:47661:43104:2851:2861:13177", -- [9]
			"46552:47655:47644:47661:43104:2851:2861:3305", -- [10]
			"46552:47655:47644:2389:4314", -- [11]
			"46552:47655:47644:2389:37888:12636:16189:16192", -- [12]
			"46552:47655:47644:2389:37888:12636:16189", -- [13]
			"2226:44825:37915:46004:46011:47875:44233", -- [14]
			"46552:47655:47644:2389:37888:44232:28621", -- [15]
			"46552:47655:47644:2389:37888:44232:44231:44230", -- [16]
			"46552:47655:47644:2389:37888:44232", -- [17]
			"46552:47655:47644:2389:37888:12636:24851", -- [18]
			"46552:47655:47644:2389:37888:12636:24851:26560", -- [19]
			"46552:47655:47644:2389:37888", -- [20]
			"2226:44825:37915", -- [21]
			"2226:44825:43124", -- [22]
			"46552:47655:47644:47661:43104:2851:2861:1387:43053", -- [23]
			"46552:47655:47644:47661:43104:2851:2861:1387:43052", -- [24]
			"46552:47655:47644:47661:43104:2851:2861:13177:43086", -- [25]
			"46552:47655:47644:47661:43104", -- [26]
			"46552:47655:47644:2389:43573", -- [27]
			"46552:47655:47644:2389:37888:12636:16189:44036", -- [28]
			"46552:47655:47644:2389:37888:44232:44231", -- [29]
			"46552:47655:47644:2389:37888:12636:16189:16192:44244", -- [30]
			"46552:47655:47644:47661:43104:2851:2861:44408", -- [31]
			"46552:47655:47644:47661:43104:2851:2861:44407", -- [32]
			"2226:44825", -- [33]
			"2226:44825:37915:46004", -- [34]
			"2226:44825:37915:46004:46011", -- [35]
			"46552:47655:47644:47661:43104:2851:47121:47133:47116", -- [36]
			"46552:47655:47644:47661:43104:2851:47121:47133", -- [37]
			"46552:47655:47644:47661:43104:2851:47121", -- [38]
			"46552:47655:47644:47661:43104:2851:47121:47133:47156", -- [39]
			"46552:47655:47644:47661:43104:2851:47121:47133:47156:47061", -- [40]
			"46552:47655:47644:47661:43104:2851:47174", -- [41]
			"46552:47655:47644", -- [42]
			"46552:47655", -- [43]
			"46552:47655:47644:47661", -- [44]
			"46552:47655:47644:2389:47665", -- [45]
			"2226:44825:37915:46004:46011:47875", -- [46]
			"46552:47655:47644:47661:43104:2851:2861:3305:47927", -- [47]
			"46552:47655:47644:47661:43104:2851:2861:13177:48321:48318", -- [48]
			"46552:47655:47644:47661:43104:2851:2861:13177:48321", -- [49]
			"2226:50463", -- [50]
			"46552:47655:47644:47661:43104:2851:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Forsaken Forward Command, Gilneas",
			["m"] = 217,
			["f"] = 0,
			["direct"] = "2226:46552",
			["coord"] = 2460364228,
		},
		[46552] = {
			"2226:4551", -- [1]
			"47655:47644:2389", -- [2]
			"47655:47644:47661:43104:2851", -- [3]
			"47655:47644:47661:43104:2851:2861:2858", -- [4]
			"47655:47644:47661:43104:2851:2861:1387", -- [5]
			"47655:47644:47661:43104:2851:2861", -- [6]
			"47655:47644:47661:43104:2851:2861:13177:43086:6026", -- [7]
			"47655:47644:2389:37888:12636", -- [8]
			"47655:47644:47661:43104:2851:2861:13177", -- [9]
			"47655:47644:47661:43104:2851:2861:3305", -- [10]
			"47655:47644:2389:4314", -- [11]
			"47655:47644:2389:37888:12636:16189:16192", -- [12]
			"47655:47644:2389:37888:12636:16189", -- [13]
			"47655:47644:2389:37888:44232:44233", -- [14]
			"47655:47644:2389:37888:44232:28621", -- [15]
			"47655:47644:2389:37888:44232:44231:44230", -- [16]
			"47655:47644:2389:37888:44232", -- [17]
			"47655:47644:2389:37888:12636:24851", -- [18]
			"47655:47644:2389:37888:12636:24851:26560", -- [19]
			"47655:47644:2389:37888", -- [20]
			"2226:44825:37915", -- [21]
			"2226:44825:43124", -- [22]
			"47655:47644:47661:43104:2851:2861:1387:43053", -- [23]
			"47655:47644:47661:43104:2851:2861:1387:43052", -- [24]
			"47655:47644:47661:43104:2851:2861:13177:43086", -- [25]
			"47655:47644:47661:43104", -- [26]
			"47655:47644:2389:43573", -- [27]
			"47655:47644:2389:37888:12636:16189:44036", -- [28]
			"47655:47644:2389:37888:44232:44231", -- [29]
			"47655:47644:2389:37888:12636:16189:16192:44244", -- [30]
			"47655:47644:47661:43104:2851:2861:44408", -- [31]
			"47655:47644:47661:43104:2851:2861:44407", -- [32]
			"2226:44825", -- [33]
			"2226:44825:37915:46004", -- [34]
			"2226:44825:37915:46004:46011", -- [35]
			"47655:47644:47661:43104:2851:47121:47133:47116", -- [36]
			"47655:47644:47661:43104:2851:47121:47133", -- [37]
			"47655:47644:47661:43104:2851:47121", -- [38]
			"47655:47644:47661:43104:2851:47121:47133:47156", -- [39]
			"47655:47644:47661:43104:2851:47121:47133:47156:47061", -- [40]
			"47655:47644:47661:43104:2851:47174", -- [41]
			"47655:47644", -- [42]
			"47655:47644:47661", -- [43]
			"47655:47644:2389:47665", -- [44]
			"2226:44825:37915:46004:46011:47875", -- [45]
			"47655:47644:47661:43104:2851:2861:3305:47927", -- [46]
			"47655:47644:47661:43104:2851:2861:13177:48321:48318", -- [47]
			"47655:47644:47661:43104:2851:2861:13177:48321", -- [48]
			"2226:50463", -- [49]
			"47655:47644:47661:43104:2851:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "The Forsaken Front, Silverpine Forest",
			["m"] = 21,
			["f"] = 0,
			["direct"] = "2226:45479:47655",
			["coord"] = 2186060496,
		},
		[47121] = {
			"2851:2389:2226", -- [1]
			"2851:43573:46004:37915:4551", -- [2]
			"2851:2389", -- [3]
			"2861:2858", -- [4]
			"2861:1387", -- [5]
			"2861:13177:43086:6026", -- [6]
			"2851:43573:37888:12636", -- [7]
			"2861:13177", -- [8]
			"2861:3305", -- [9]
			"2851:4314", -- [10]
			"2851:43573:37888:12636:16189:16192", -- [11]
			"2851:43573:37888:12636:16189", -- [12]
			"2851:43573:37888:44232:44233", -- [13]
			"2851:43573:37888:44232:28621", -- [14]
			"2851:43573:37888:44232:44231:44230", -- [15]
			"2851:43573:37888:44232", -- [16]
			"2851:43573:37888:12636:24851", -- [17]
			"2851:43573:37888:12636:24851:26560", -- [18]
			"2851:43573:37888", -- [19]
			"2851:43573:46004:37915", -- [20]
			"2851:43573:46004:37915:43124", -- [21]
			"2861:1387:43053", -- [22]
			"2861:1387:43052", -- [23]
			"2861:13177:43086", -- [24]
			"2851:43104", -- [25]
			"2851:43573", -- [26]
			"2851:43573:37888:12636:16189:44036", -- [27]
			"2851:43573:37888:44232:44231", -- [28]
			"2851:43573:37888:12636:16189:16192:44244", -- [29]
			"2861:44408", -- [30]
			"2861:44407", -- [31]
			"2851:43573:46004:37915:44825", -- [32]
			"2851:43104:47661:47644:47655:46552:45479", -- [33]
			"2851:43573:46004", -- [34]
			"2851:43573:46004:46011", -- [35]
			"2851:43104:47661:47644:47655:46552", -- [36]
			"47133:47116", -- [37]
			"47133:47156", -- [38]
			"47133:47156:47061", -- [39]
			"47133:47156:47174", -- [40]
			"2851:43104:47661:47644", -- [41]
			"2851:43104:47661:47644:47655", -- [42]
			"2851:43104:47661", -- [43]
			"2851:2389:47665", -- [44]
			"2851:43573:46004:46011:47875", -- [45]
			"2861:3305:47927", -- [46]
			"2861:13177:48321:48318", -- [47]
			"2861:13177:48321", -- [48]
			"2851:43573:46004:37915:44825:50463", -- [49]
			"2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Vermillion Redoubt, Twilight Highlands",
			["m"] = 241,
			["f"] = 0,
			["direct"] = "2851:2861:47133",
			["coord"] = 1225146328,
		},
		[44036] = {
			"16189:12636:37888:37915:44825:2226", -- [1]
			"16189:12636:37888:4551", -- [2]
			"16189:12636:37888:2389", -- [3]
			"16189:12636:4314:2851", -- [4]
			"16189:12636:44407:2861:2858", -- [5]
			"16189:12636:44407:2861:1387", -- [6]
			"16189:12636:44407:2861", -- [7]
			"16189:12636:44407:2861:13177:43086:6026", -- [8]
			"16189:12636", -- [9]
			"16189:12636:44407:2861:13177", -- [10]
			"16189:12636:44407:2861:3305", -- [11]
			"16189:12636:4314", -- [12]
			"16189:12636:44230:44233", -- [13]
			"16189:12636:44230:28621", -- [14]
			"16189:12636:44230", -- [15]
			"16189:12636:44231:44232", -- [16]
			"16189:24851", -- [17]
			"16192:26560", -- [18]
			"16189:12636:37888", -- [19]
			"16189:12636:37888:37915", -- [20]
			"16189:12636:37888:37915:43124", -- [21]
			"16189:12636:44407:2861:1387:43053", -- [22]
			"16189:12636:44407:2861:1387:43052", -- [23]
			"16189:12636:44407:2861:13177:43086", -- [24]
			"16189:12636:37888:2389:43104", -- [25]
			"16189:12636:37888:43573", -- [26]
			"16189:12636:44231", -- [27]
			"16192:44244", -- [28]
			"16189:12636:44407:44408", -- [29]
			"16189:12636:44407", -- [30]
			"16189:12636:37888:37915:44825", -- [31]
			"16189:12636:37888:37915:44825:2226:46552:45479", -- [32]
			"16189:12636:37888:46011:46004", -- [33]
			"16189:12636:37888:46011", -- [34]
			"16189:12636:37888:37915:44825:2226:46552", -- [35]
			"16189:12636:4314:2851:47121:47133:47116", -- [36]
			"16189:12636:4314:2851:47121:47133", -- [37]
			"16189:12636:4314:2851:47121", -- [38]
			"16189:12636:4314:2851:47121:47133:47156", -- [39]
			"16189:12636:4314:2851:47121:47133:47156:47061", -- [40]
			"16189:12636:4314:2851:47174", -- [41]
			"16189:12636:37888:2389:47644", -- [42]
			"16189:12636:37888:2389:47644:47655", -- [43]
			"16189:12636:37888:2389:47661", -- [44]
			"16189:12636:37888:37915:47665", -- [45]
			"16189:12636:44230:44233:47875", -- [46]
			"16189:12636:44407:2861:3305:47927", -- [47]
			"16189:12636:44407:2861:13177:48321:48318", -- [48]
			"16189:12636:44407:2861:13177:48321", -- [49]
			"16189:12636:37888:37915:44825:50463", -- [50]
			"16189:12636:44407:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Fairbreeze Village, Eversong Woods",
			["m"] = 94,
			["coord"] = 1889448706,
			["direct"] = "16192:16189",
			["f"] = 0,
		},
		[46004] = {
			"37915:44825:2226", -- [1]
			"37915:4551", -- [2]
			"37915:2389", -- [3]
			"43573:2851", -- [4]
			"43573:2851:2861:2858", -- [5]
			"43573:2851:2861:1387", -- [6]
			"43573:2851:2861", -- [7]
			"43573:2851:2861:13177:43086:6026", -- [8]
			"46011:37888:12636", -- [9]
			"43573:2851:2861:13177", -- [10]
			"43573:2851:2861:3305", -- [11]
			"43573:4314", -- [12]
			"46011:37888:12636:16189:16192", -- [13]
			"46011:37888:12636:16189", -- [14]
			"46011:47875:44233", -- [15]
			"46011:37888:44232:28621", -- [16]
			"46011:37888:44232:44231:44230", -- [17]
			"46011:37888:44232", -- [18]
			"46011:37888:12636:24851", -- [19]
			"46011:37888:12636:24851:26560", -- [20]
			"46011:37888", -- [21]
			"37915:43124", -- [22]
			"43573:2851:2861:1387:43053", -- [23]
			"43573:2851:2861:1387:43052", -- [24]
			"43573:2851:2861:13177:43086", -- [25]
			"37915:2389:43104", -- [26]
			"46011:37888:12636:16189:44036", -- [27]
			"46011:37888:44232:44231", -- [28]
			"46011:37888:12636:16189:16192:44244", -- [29]
			"43573:2851:2861:44408", -- [30]
			"43573:2851:2861:44407", -- [31]
			"37915:44825", -- [32]
			"37915:44825:2226:46552:45479", -- [33]
			"37915:44825:2226:46552", -- [34]
			"43573:2851:47121:47133:47116", -- [35]
			"43573:2851:47121:47133", -- [36]
			"43573:2851:47121", -- [37]
			"43573:2851:47121:47133:47156", -- [38]
			"43573:2851:47121:47133:47156:47061", -- [39]
			"43573:2851:47174", -- [40]
			"37915:2389:47644", -- [41]
			"37915:2389:47644:47655", -- [42]
			"37915:2389:47661", -- [43]
			"37915:47665", -- [44]
			"46011:47875", -- [45]
			"43573:2851:2861:3305:47927", -- [46]
			"43573:2851:2861:13177:48321:48318", -- [47]
			"43573:2851:2861:13177:48321", -- [48]
			"37915:44825:50463", -- [49]
			"43573:2851:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Andorhal, Western Plaguelands",
			["m"] = 22,
			["coord"] = 2001315236,
			["direct"] = "37915:43573:46011",
			["f"] = 0,
		},
		[26560] = {
			"24851:12636:37888:37915:44825:2226", -- [1]
			"24851:12636:37888:4551", -- [2]
			"24851:12636:37888:2389", -- [3]
			"24851:12636:4314:2851", -- [4]
			"24851:12636:44407:2861:2858", -- [5]
			"24851:12636:44407:2861:1387", -- [6]
			"24851:12636:44407:2861", -- [7]
			"24851:12636:44407:2861:13177:43086:6026", -- [8]
			"24851:12636", -- [9]
			"24851:12636:44407:2861:13177", -- [10]
			"24851:12636:44407:2861:3305", -- [11]
			"24851:12636:4314", -- [12]
			"16192:16189", -- [13]
			"24851:12636:44230:44233", -- [14]
			"24851:12636:44230:28621", -- [15]
			"24851:12636:44230", -- [16]
			"24851:12636:44231:44232", -- [17]
			"24851:12636:37888", -- [18]
			"24851:12636:37888:37915", -- [19]
			"24851:12636:37888:37915:43124", -- [20]
			"24851:12636:44407:2861:1387:43053", -- [21]
			"24851:12636:44407:2861:1387:43052", -- [22]
			"24851:12636:44407:2861:13177:43086", -- [23]
			"24851:12636:37888:2389:43104", -- [24]
			"24851:12636:37888:43573", -- [25]
			"16192:44036", -- [26]
			"24851:12636:44231", -- [27]
			"16192:44244", -- [28]
			"24851:12636:44407:44408", -- [29]
			"24851:12636:44407", -- [30]
			"24851:12636:37888:37915:44825", -- [31]
			"24851:12636:37888:37915:44825:2226:46552:45479", -- [32]
			"24851:12636:37888:46011:46004", -- [33]
			"24851:12636:37888:46011", -- [34]
			"24851:12636:37888:37915:44825:2226:46552", -- [35]
			"24851:12636:4314:2851:47121:47133:47116", -- [36]
			"24851:12636:4314:2851:47121:47133", -- [37]
			"24851:12636:4314:2851:47121", -- [38]
			"24851:12636:4314:2851:47121:47133:47156", -- [39]
			"24851:12636:4314:2851:47121:47133:47156:47061", -- [40]
			"24851:12636:4314:2851:47174", -- [41]
			"24851:12636:37888:2389:47644", -- [42]
			"24851:12636:37888:2389:47644:47655", -- [43]
			"24851:12636:37888:2389:47661", -- [44]
			"24851:12636:37888:37915:47665", -- [45]
			"24851:12636:44230:44233:47875", -- [46]
			"24851:12636:44407:2861:3305:47927", -- [47]
			"24851:12636:44407:2861:13177:48321:48318", -- [48]
			"24851:12636:44407:2861:13177:48321", -- [49]
			"24851:12636:37888:37915:44825:50463", -- [50]
			"24851:12636:44407:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Shattered Sun Staging Area",
			["m"] = 122,
			["coord"] = 2073575464,
			["direct"] = "16192:24851",
			["f"] = 0,
		},
		[44231] = {
			"44232:37888:37915:44825:2226", -- [1]
			"44232:37888:4551", -- [2]
			"44232:37888:2389", -- [3]
			"44232:37888:43573:2851", -- [4]
			"12636:44407:2861:2858", -- [5]
			"12636:44407:2861:1387", -- [6]
			"12636:44407:2861", -- [7]
			"12636:44407:2861:13177:43086:6026", -- [8]
			"12636:44407:2861:13177", -- [9]
			"12636:44407:2861:3305", -- [10]
			"12636:4314", -- [11]
			"12636:16189:16192", -- [12]
			"12636:16189", -- [13]
			"44230:28621", -- [14]
			"12636:24851", -- [15]
			"12636:24851:26560", -- [16]
			"44232:37888", -- [17]
			"44232:37888:37915", -- [18]
			"44232:37888:37915:43124", -- [19]
			"12636:44407:2861:1387:43053", -- [20]
			"12636:44407:2861:1387:43052", -- [21]
			"12636:44407:2861:13177:43086", -- [22]
			"44232:37888:2389:43104", -- [23]
			"44232:37888:43573", -- [24]
			"12636:16189:44036", -- [25]
			"12636:16189:16192:44244", -- [26]
			"12636:44407:44408", -- [27]
			"12636:44407", -- [28]
			"44232:37888:37915:44825", -- [29]
			"44232:37888:37915:44825:2226:46552:45479", -- [30]
			"44232:37888:46011:46004", -- [31]
			"44232:37888:46011", -- [32]
			"44232:37888:37915:44825:2226:46552", -- [33]
			"44232:37888:43573:2851:47121:47133:47116", -- [34]
			"44232:37888:43573:2851:47121:47133", -- [35]
			"44232:37888:43573:2851:47121", -- [36]
			"44232:37888:43573:2851:47121:47133:47156", -- [37]
			"44232:37888:43573:2851:47121:47133:47156:47061", -- [38]
			"44232:37888:43573:2851:47174", -- [39]
			"44232:37888:2389:47644", -- [40]
			"44232:37888:2389:47644:47655", -- [41]
			"44232:37888:2389:47661", -- [42]
			"44232:37888:37915:47665", -- [43]
			"44233:47875", -- [44]
			"12636:44407:2861:3305:47927", -- [45]
			"12636:44407:2861:13177:48321:48318", -- [46]
			"12636:44407:2861:13177:48321", -- [47]
			"44232:37888:37915:44825:50463", -- [48]
			"12636:44407:2861:13177:43086:6026:85734", -- [49]
			--["name"] = "Light's Shield Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 2262927709,
			["direct"] = "12636:44233:44230:44232",
			["f"] = 0,
		},
		[44233] = {
			"44232:37888:37915:44825:2226", -- [1]
			"44232:37888:4551", -- [2]
			"44232:37888:2389", -- [3]
			"44232:37888:43573:2851", -- [4]
			"44230:12636:44407:2861:2858", -- [5]
			"44230:12636:44407:2861:1387", -- [6]
			"44230:12636:44407:2861", -- [7]
			"44230:12636:44407:2861:13177:43086:6026", -- [8]
			"44230:12636", -- [9]
			"44230:12636:44407:2861:13177", -- [10]
			"44230:12636:44407:2861:3305", -- [11]
			"44230:12636:4314", -- [12]
			"44230:12636:16189:16192", -- [13]
			"44230:12636:16189", -- [14]
			"44230:12636:24851", -- [15]
			"44230:12636:24851:26560", -- [16]
			"44232:37888", -- [17]
			"44232:37888:37915", -- [18]
			"44232:37888:37915:43124", -- [19]
			"44230:12636:44407:2861:1387:43053", -- [20]
			"44230:12636:44407:2861:1387:43052", -- [21]
			"44230:12636:44407:2861:13177:43086", -- [22]
			"44232:37888:2389:43104", -- [23]
			"44232:37888:43573", -- [24]
			"44230:12636:16189:44036", -- [25]
			"44230:12636:16189:16192:44244", -- [26]
			"44230:12636:44407:44408", -- [27]
			"44230:12636:44407", -- [28]
			"44232:37888:37915:44825", -- [29]
			"44232:37888:37915:44825:2226:46552:45479", -- [30]
			"47875:46011:46004", -- [31]
			"47875:46011", -- [32]
			"44232:37888:37915:44825:2226:46552", -- [33]
			"44232:37888:43573:2851:47121:47133:47116", -- [34]
			"44232:37888:43573:2851:47121:47133", -- [35]
			"44232:37888:43573:2851:47121", -- [36]
			"44232:37888:43573:2851:47121:47133:47156", -- [37]
			"44232:37888:43573:2851:47121:47133:47156:47061", -- [38]
			"44232:37888:43573:2851:47174", -- [39]
			"44232:37888:2389:47644", -- [40]
			"44232:37888:2389:47644:47655", -- [41]
			"44232:37888:2389:47661", -- [42]
			"44232:37888:37915:47665", -- [43]
			"44230:12636:44407:2861:3305:47927", -- [44]
			"44230:12636:44407:2861:13177:48321:48318", -- [45]
			"44230:12636:44407:2861:13177:48321", -- [46]
			"44232:37888:37915:44825:50463", -- [47]
			"44230:12636:44407:2861:13177:43086:6026:85734", -- [48]
			--["name"] = "Plaguewood Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 794904154,
			["direct"] = "28621:44230:44232:44231:47875",
			["f"] = 0,
		},
		[47133] = {
			"47121:2851:2389:2226", -- [1]
			"47121:2851:43573:46004:37915:4551", -- [2]
			"47121:2851:2389", -- [3]
			"47121:2851", -- [4]
			"47121:2861:2858", -- [5]
			"47121:2861:1387", -- [6]
			"47121:2861", -- [7]
			"47121:2861:13177:43086:6026", -- [8]
			"47121:2851:43573:37888:12636", -- [9]
			"47121:2861:13177", -- [10]
			"47121:2861:3305", -- [11]
			"47121:2851:4314", -- [12]
			"47121:2851:43573:37888:12636:16189:16192", -- [13]
			"47121:2851:43573:37888:12636:16189", -- [14]
			"47121:2851:43573:37888:44232:44233", -- [15]
			"47121:2851:43573:37888:44232:28621", -- [16]
			"47121:2851:43573:37888:44232:44231:44230", -- [17]
			"47121:2851:43573:37888:44232", -- [18]
			"47121:2851:43573:37888:12636:24851", -- [19]
			"47121:2851:43573:37888:12636:24851:26560", -- [20]
			"47121:2851:43573:37888", -- [21]
			"47121:2851:43573:46004:37915", -- [22]
			"47121:2851:43573:46004:37915:43124", -- [23]
			"47121:2861:1387:43053", -- [24]
			"47121:2861:1387:43052", -- [25]
			"47121:2861:13177:43086", -- [26]
			"47121:2851:43104", -- [27]
			"47121:2851:43573", -- [28]
			"47121:2851:43573:37888:12636:16189:44036", -- [29]
			"47121:2851:43573:37888:44232:44231", -- [30]
			"47121:2851:43573:37888:12636:16189:16192:44244", -- [31]
			"47121:2861:44408", -- [32]
			"47121:2861:44407", -- [33]
			"47121:2851:43573:46004:37915:44825", -- [34]
			"47121:2851:43104:47661:47644:47655:46552:45479", -- [35]
			"47121:2851:43573:46004", -- [36]
			"47121:2851:43573:46004:46011", -- [37]
			"47121:2851:43104:47661:47644:47655:46552", -- [38]
			"47156:47061", -- [39]
			"47156:47174", -- [40]
			"47121:2851:43104:47661:47644", -- [41]
			"47121:2851:43104:47661:47644:47655", -- [42]
			"47121:2851:43104:47661", -- [43]
			"47121:2851:2389:47665", -- [44]
			"47121:2851:43573:46004:46011:47875", -- [45]
			"47121:2861:3305:47927", -- [46]
			"47121:2861:13177:48321:48318", -- [47]
			"47121:2861:13177:48321", -- [48]
			"47121:2851:43573:46004:37915:44825:50463", -- [49]
			"47121:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "The Gullet, Twilight Highlands",
			["m"] = 241,
			["f"] = 0,
			["direct"] = "47116:47121:47156",
			["coord"] = 1582457212,
		},
		[48318] = {
			"48321:13177:2861:2851:2389:2226", -- [1]
			"47927:3305:43220:4551", -- [2]
			"48321:13177:2861:2851:2389", -- [3]
			"48321:13177:2861:2851", -- [4]
			"48321:13177:1387:2858", -- [5]
			"48321:13177:1387", -- [6]
			"48321:13177:2861", -- [7]
			"48321:13177:43086:6026", -- [8]
			"48321:13177:2861:44407:12636", -- [9]
			"48321:13177", -- [10]
			"47927:3305", -- [11]
			"48321:13177:2861:2851:4314", -- [12]
			"48321:13177:2861:44407:12636:16189:16192", -- [13]
			"48321:13177:2861:44407:12636:16189", -- [14]
			"48321:13177:2861:2851:43573:37888:44232:44233", -- [15]
			"48321:13177:2861:44407:12636:44230:28621", -- [16]
			"48321:13177:2861:44407:12636:44230", -- [17]
			"48321:13177:2861:2851:43573:37888:44232", -- [18]
			"48321:13177:2861:44407:12636:24851", -- [19]
			"48321:13177:2861:44407:12636:24851:26560", -- [20]
			"48321:13177:2861:2851:43573:37888", -- [21]
			"48321:13177:2861:2851:43573:46004:37915", -- [22]
			"48321:13177:2861:2851:43573:46004:37915:43124", -- [23]
			"48321:13177:1387:43053", -- [24]
			"48321:13177:1387:43052", -- [25]
			"48321:13177:43086", -- [26]
			"48321:13177:2861:2851:43104", -- [27]
			"48321:13177:2861:2851:43573", -- [28]
			"48321:13177:2861:44407:12636:16189:44036", -- [29]
			"48321:13177:2861:2851:43573:37888:44232:44231", -- [30]
			"48321:13177:2861:44407:12636:16189:16192:44244", -- [31]
			"48321:13177:2861:44408", -- [32]
			"48321:13177:2861:44407", -- [33]
			"48321:13177:2861:2851:43573:46004:37915:44825", -- [34]
			"48321:13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [35]
			"48321:13177:2861:2851:43573:46004", -- [36]
			"48321:13177:2861:2851:43573:46004:46011", -- [37]
			"48321:13177:2861:2851:43104:47661:47644:47655:46552", -- [38]
			"48321:13177:2861:47121:47133:47116", -- [39]
			"48321:13177:2861:47121:47133", -- [40]
			"48321:13177:2861:47121", -- [41]
			"48321:13177:2861:47121:47133:47156", -- [42]
			"48321:13177:2861:47174:47061", -- [43]
			"48321:13177:2861:47174", -- [44]
			"48321:13177:2861:2851:43104:47661:47644", -- [45]
			"48321:13177:2861:2851:43104:47661:47644:47655", -- [46]
			"48321:13177:2861:2851:43104:47661", -- [47]
			"48321:13177:2861:2851:2389:47665", -- [48]
			"48321:13177:2861:2851:43573:46004:46011:47875", -- [49]
			"48321:13177:2861:2851:43573:46004:37915:44825:50463", -- [50]
			"48321:13177:43086:6026:85734", -- [51]
			--["name"] = "Flamestar Post, Burning Steppes",
			["m"] = 36,
			["f"] = 0,
			["direct"] = "47927:48321",
			["coord"] = 764708591,
		},
		[46011] = {
			"46004:37915:44825:2226", -- [1]
			"46004:37915:4551", -- [2]
			"37888:2389", -- [3]
			"46004:43573:2851", -- [4]
			"46004:43573:2851:2861:2858", -- [5]
			"46004:43573:2851:2861:1387", -- [6]
			"46004:43573:2851:2861", -- [7]
			"46004:43573:2851:2861:13177:43086:6026", -- [8]
			"37888:12636", -- [9]
			"46004:43573:2851:2861:13177", -- [10]
			"46004:43573:2851:2861:3305", -- [11]
			"46004:43573:4314", -- [12]
			"37888:12636:16189:16192", -- [13]
			"37888:12636:16189", -- [14]
			"47875:44233", -- [15]
			"37888:44232:28621", -- [16]
			"37888:44232:44231:44230", -- [17]
			"37888:44232", -- [18]
			"37888:12636:24851", -- [19]
			"37888:12636:24851:26560", -- [20]
			"46004:37915", -- [21]
			"46004:37915:43124", -- [22]
			"46004:43573:2851:2861:1387:43053", -- [23]
			"46004:43573:2851:2861:1387:43052", -- [24]
			"46004:43573:2851:2861:13177:43086", -- [25]
			"37888:2389:43104", -- [26]
			"46004:43573", -- [27]
			"37888:12636:16189:44036", -- [28]
			"37888:44232:44231", -- [29]
			"37888:12636:16189:16192:44244", -- [30]
			"46004:43573:2851:2861:44408", -- [31]
			"37888:12636:44407", -- [32]
			"46004:37915:44825", -- [33]
			"46004:37915:44825:2226:46552:45479", -- [34]
			"46004:37915:44825:2226:46552", -- [35]
			"46004:43573:2851:47121:47133:47116", -- [36]
			"46004:43573:2851:47121:47133", -- [37]
			"46004:43573:2851:47121", -- [38]
			"46004:43573:2851:47121:47133:47156", -- [39]
			"46004:43573:2851:47121:47133:47156:47061", -- [40]
			"46004:43573:2851:47174", -- [41]
			"37888:2389:47644", -- [42]
			"37888:2389:47644:47655", -- [43]
			"37888:2389:47661", -- [44]
			"46004:37915:47665", -- [45]
			"46004:43573:2851:2861:3305:47927", -- [46]
			"46004:43573:2851:2861:13177:48321:48318", -- [47]
			"46004:43573:2851:2861:13177:48321", -- [48]
			"46004:37915:44825:50463", -- [49]
			"46004:43573:2851:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "The Menders' Stead, Western Plaguelands",
			["m"] = 22,
			["coord"] = 2169931306,
			["direct"] = "37888:46004:47875",
			["f"] = 0,
		},
		[4314] = {
			"43573:2389:2226", -- [1]
			"2851:2861:2858", -- [2]
			"2851:2861:1387", -- [3]
			"2851:2861", -- [4]
			"2851:2861:13177:43086:6026", -- [5]
			"2851:2861:13177", -- [6]
			"2851:2861:3305", -- [7]
			"12636:16189:16192", -- [8]
			"12636:16189", -- [9]
			"12636:44230:44233", -- [10]
			"12636:44230:28621", -- [11]
			"12636:44230", -- [12]
			"43573:37888:44232", -- [13]
			"12636:24851", -- [14]
			"12636:24851:26560", -- [15]
			"43573:37888", -- [16]
			"43573:46004:37915", -- [17]
			"43573:46004:37915:43124", -- [18]
			"2851:2861:1387:43053", -- [19]
			"2851:2861:1387:43052", -- [20]
			"2851:2861:13177:43086", -- [21]
			"2851:43104", -- [22]
			"12636:16189:44036", -- [23]
			"12636:44231", -- [24]
			"12636:16189:16192:44244", -- [25]
			"2851:2861:44408", -- [26]
			"2851:2861:44407", -- [27]
			"43573:46004:37915:44825", -- [28]
			"43573:2389:47644:47655:46552:45479", -- [29]
			"43573:46004", -- [30]
			"43573:46004:46011", -- [31]
			"43573:2389:47644:47655:46552", -- [32]
			"2851:47121:47133:47116", -- [33]
			"2851:47121:47133", -- [34]
			"2851:47121", -- [35]
			"2851:47121:47133:47156", -- [36]
			"2851:47121:47133:47156:47061", -- [37]
			"2851:47174", -- [38]
			"43573:2389:47644", -- [39]
			"43573:2389:47644:47655", -- [40]
			"43573:2389:47661", -- [41]
			"43573:2389:47665", -- [42]
			"43573:46004:46011:47875", -- [43]
			"2851:2861:3305:47927", -- [44]
			"2851:2861:13177:48321:48318", -- [45]
			"2851:2861:13177:48321", -- [46]
			"43573:46004:37915:44825:50463", -- [47]
			"2851:2861:13177:43086:6026:85734", -- [48]
			--["name"] = "Revantusk Village, The Hinterlands",
			["m"] = 26,
			["f"] = 0,
			["direct"] = "4551:2389:2851:12636:43573",
			["coord"] = 3509047718,
		},
		[44232] = {
			"37888:37915:44825:2226", -- [1]
			"37888:4551", -- [2]
			"37888:2389", -- [3]
			"37888:43573:2851", -- [4]
			"37888:43573:2851:2861:2858", -- [5]
			"37888:43573:2851:2861:1387", -- [6]
			"37888:43573:2851:2861", -- [7]
			"37888:43573:2851:2861:13177:43086:6026", -- [8]
			"44231:12636", -- [9]
			"37888:43573:2851:2861:13177", -- [10]
			"37888:43573:2851:2861:3305", -- [11]
			"37888:43573:4314", -- [12]
			"44231:12636:16189:16192", -- [13]
			"44231:12636:16189", -- [14]
			"44231:44230", -- [15]
			"44231:12636:24851", -- [16]
			"44231:12636:24851:26560", -- [17]
			"37888:37915", -- [18]
			"37888:37915:43124", -- [19]
			"37888:43573:2851:2861:1387:43053", -- [20]
			"37888:43573:2851:2861:1387:43052", -- [21]
			"37888:43573:2851:2861:13177:43086", -- [22]
			"37888:2389:43104", -- [23]
			"37888:43573", -- [24]
			"44231:12636:16189:44036", -- [25]
			"44231:12636:16189:16192:44244", -- [26]
			"44231:12636:44407:44408", -- [27]
			"44231:12636:44407", -- [28]
			"37888:37915:44825", -- [29]
			"37888:37915:44825:2226:46552:45479", -- [30]
			"37888:46011:46004", -- [31]
			"37888:46011", -- [32]
			"37888:37915:44825:2226:46552", -- [33]
			"37888:43573:2851:47121:47133:47116", -- [34]
			"37888:43573:2851:47121:47133", -- [35]
			"37888:43573:2851:47121", -- [36]
			"37888:43573:2851:47121:47133:47156", -- [37]
			"37888:43573:2851:47121:47133:47156:47061", -- [38]
			"37888:43573:2851:47174", -- [39]
			"37888:2389:47644", -- [40]
			"37888:2389:47644:47655", -- [41]
			"37888:2389:47661", -- [42]
			"37888:37915:47665", -- [43]
			"44233:47875", -- [44]
			"37888:43573:2851:2861:3305:47927", -- [45]
			"37888:43573:2851:2861:13177:48321:48318", -- [46]
			"37888:43573:2851:2861:13177:48321", -- [47]
			"37888:37915:44825:50463", -- [48]
			"37888:43573:2851:2861:13177:43086:6026:85734", -- [49]
			--["name"] = "Crown Guard Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 1497804315,
			["direct"] = "44233:28621:37888:44231",
			["f"] = 0,
		},
		[4551] = {
			"2861:2858", -- [1]
			"2861:1387", -- [2]
			"2861:13177:43086:6026", -- [3]
			"2861:13177", -- [4]
			"43220:3305", -- [5]
			"37888:12636:16189:16192", -- [6]
			"37888:12636:16189", -- [7]
			"37915:46004:46011:47875:44233", -- [8]
			"37888:44232:28621", -- [9]
			"37888:44232:44231:44230", -- [10]
			"37888:44232", -- [11]
			"37888:12636:24851", -- [12]
			"37888:12636:24851:26560", -- [13]
			"2861:1387:43053", -- [14]
			"2861:1387:43052", -- [15]
			"2861:13177:43086", -- [16]
			"37915:46004:43573", -- [17]
			"37888:12636:16189:44036", -- [18]
			"37888:44232:44231", -- [19]
			"37888:12636:16189:16192:44244", -- [20]
			"2861:44408", -- [21]
			"2861:44407", -- [22]
			"2226:46552:45479", -- [23]
			"37915:46004", -- [24]
			"37915:46004:46011", -- [25]
			"2226:46552", -- [26]
			"2389:2851:47121:47133:47116", -- [27]
			"2389:2851:47121:47133", -- [28]
			"2389:2851:47121", -- [29]
			"2389:2851:47121:47133:47156", -- [30]
			"2389:2851:47121:47133:47156:47061", -- [31]
			"2389:2851:47174", -- [32]
			"2389:47644", -- [33]
			"2226:46552:47655", -- [34]
			"2389:47661", -- [35]
			"37915:47665", -- [36]
			"37915:46004:46011:47875", -- [37]
			"43220:3305:47927", -- [38]
			"2861:13177:48321:48318", -- [39]
			"2861:13177:48321", -- [40]
			"44825:50463", -- [41]
			"2861:13177:43086:6026:85734", -- [42]
			--["name"] = "Undercity, Tirisfal",
			["m"] = 90,
			["f"] = 0,
			["direct"] = "2226:2389:2851:2861:12636:4314:37888:37915:43124:43104:44825",
			["coord"] = 2715646852,
		},
		[2858] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"2861:44407:12636", -- [5]
			"1387:13177", -- [6]
			"1387:13177:3305", -- [7]
			"2861:2851:4314", -- [8]
			"2861:44407:12636:16189:16192", -- [9]
			"2861:44407:12636:16189", -- [10]
			"2861:2851:43573:37888:44232:44233", -- [11]
			"2861:44407:12636:44230:28621", -- [12]
			"2861:44407:12636:44230", -- [13]
			"2861:2851:43573:37888:44232", -- [14]
			"2861:44407:12636:24851", -- [15]
			"2861:44407:12636:24851:26560", -- [16]
			"2861:2851:43573:37888", -- [17]
			"2861:2851:43573:46004:37915", -- [18]
			"2861:2851:43573:46004:37915:43124", -- [19]
			"43053:43052", -- [20]
			"6026:43086", -- [21]
			"2861:2851:43104", -- [22]
			"2861:2851:43573", -- [23]
			"2861:44407:12636:16189:44036", -- [24]
			"2861:2851:43573:37888:44232:44231", -- [25]
			"2861:44407:12636:16189:16192:44244", -- [26]
			"2861:44408", -- [27]
			"2861:44407", -- [28]
			"2861:2851:43573:46004:37915:44825", -- [29]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [30]
			"2861:2851:43573:46004", -- [31]
			"2861:2851:43573:46004:46011", -- [32]
			"2861:2851:43104:47661:47644:47655:46552", -- [33]
			"2861:47121:47133:47116", -- [34]
			"2861:47121:47133", -- [35]
			"2861:47121", -- [36]
			"2861:47121:47133:47156", -- [37]
			"2861:47174:47061", -- [38]
			"2861:47174", -- [39]
			"2861:2851:43104:47661:47644", -- [40]
			"2861:2851:43104:47661:47644:47655", -- [41]
			"2861:2851:43104:47661", -- [42]
			"2861:2851:2389:47665", -- [43]
			"2861:2851:43573:46004:46011:47875", -- [44]
			"1387:13177:48321:48318:47927", -- [45]
			"1387:13177:48321:48318", -- [46]
			"1387:13177:48321", -- [47]
			"2861:2851:43573:46004:37915:44825:50463", -- [48]
			"43053:43052:85734", -- [49]
			--["name"] = "Booty Bay, Stranglethorn",
			["m"] = 210,
			["f"] = 0,
			["direct"] = "1387:2861:6026:43053",
			["coord"] = 1742060479,
		},
		[43052] = {
			"1387:2861:2851:2389:2226", -- [1]
			"1387:2861:4551", -- [2]
			"1387:2861:2851:2389", -- [3]
			"1387:2861:2851", -- [4]
			"43053:2858", -- [5]
			"1387:2861", -- [6]
			"85734:6026", -- [7]
			"1387:2861:44407:12636", -- [8]
			"1387:13177", -- [9]
			"1387:13177:3305", -- [10]
			"1387:2861:2851:4314", -- [11]
			"1387:2861:44407:12636:16189:16192", -- [12]
			"1387:2861:44407:12636:16189", -- [13]
			"1387:2861:2851:43573:37888:44232:44233", -- [14]
			"1387:2861:44407:12636:44230:28621", -- [15]
			"1387:2861:44407:12636:44230", -- [16]
			"1387:2861:2851:43573:37888:44232", -- [17]
			"1387:2861:44407:12636:24851", -- [18]
			"1387:2861:44407:12636:24851:26560", -- [19]
			"1387:2861:2851:43573:37888", -- [20]
			"1387:2861:2851:43573:46004:37915", -- [21]
			"1387:2861:2851:43573:46004:37915:43124", -- [22]
			"85734:6026:43086", -- [23]
			"1387:2861:2851:43104", -- [24]
			"1387:2861:2851:43573", -- [25]
			"1387:2861:44407:12636:16189:44036", -- [26]
			"1387:2861:2851:43573:37888:44232:44231", -- [27]
			"1387:2861:44407:12636:16189:16192:44244", -- [28]
			"1387:2861:44408", -- [29]
			"1387:2861:44407", -- [30]
			"1387:2861:2851:43573:46004:37915:44825", -- [31]
			"1387:2861:2851:43104:47661:47644:47655:46552:45479", -- [32]
			"1387:2861:2851:43573:46004", -- [33]
			"1387:2861:2851:43573:46004:46011", -- [34]
			"1387:2861:2851:43104:47661:47644:47655:46552", -- [35]
			"1387:2861:47121:47133:47116", -- [36]
			"1387:2861:47121:47133", -- [37]
			"1387:2861:47121", -- [38]
			"1387:2861:47121:47133:47156", -- [39]
			"1387:2861:47174:47061", -- [40]
			"1387:2861:47174", -- [41]
			"1387:2861:2851:43104:47661:47644", -- [42]
			"1387:2861:2851:43104:47661:47644:47655", -- [43]
			"1387:2861:2851:43104:47661", -- [44]
			"1387:2861:2851:2389:47665", -- [45]
			"1387:2861:2851:43573:46004:46011:47875", -- [46]
			"1387:13177:48321:48318:47927", -- [47]
			"1387:13177:48321:48318", -- [48]
			"1387:13177:48321", -- [49]
			"1387:2861:2851:43573:46004:37915:44825:50463", -- [50]
			--["name"] = "Bambala, Stranglethorn",
			["m"] = 50,
			["f"] = 0,
			["direct"] = "1387:43053:85734",
			["coord"] = 2679465147,
		},
		[37888] = {
			"37915:44825:2226", -- [1]
			"43573:2851", -- [2]
			"43573:2851:2861:2858", -- [3]
			"43573:2851:2861:1387", -- [4]
			"43573:2851:2861", -- [5]
			"43573:2851:2861:13177:43086:6026", -- [6]
			"43573:2851:2861:13177", -- [7]
			"43573:2851:2861:3305", -- [8]
			"43573:4314", -- [9]
			"12636:16189:16192", -- [10]
			"12636:16189", -- [11]
			"44232:44233", -- [12]
			"44232:28621", -- [13]
			"44232:44231:44230", -- [14]
			"12636:24851", -- [15]
			"12636:24851:26560", -- [16]
			"37915:43124", -- [17]
			"43573:2851:2861:1387:43053", -- [18]
			"43573:2851:2861:1387:43052", -- [19]
			"43573:2851:2861:13177:43086", -- [20]
			"2389:43104", -- [21]
			"12636:16189:44036", -- [22]
			"44232:44231", -- [23]
			"12636:16189:16192:44244", -- [24]
			"43573:2851:2861:44408", -- [25]
			"12636:44407", -- [26]
			"37915:44825", -- [27]
			"37915:44825:2226:46552:45479", -- [28]
			"46011:46004", -- [29]
			"37915:44825:2226:46552", -- [30]
			"43573:2851:47121:47133:47116", -- [31]
			"43573:2851:47121:47133", -- [32]
			"43573:2851:47121", -- [33]
			"43573:2851:47121:47133:47156", -- [34]
			"43573:2851:47121:47133:47156:47061", -- [35]
			"43573:2851:47174", -- [36]
			"2389:47644", -- [37]
			"2389:47644:47655", -- [38]
			"2389:47661", -- [39]
			"37915:47665", -- [40]
			"46011:47875", -- [41]
			"43573:2851:2861:3305:47927", -- [42]
			"43573:2851:2861:13177:48321:48318", -- [43]
			"43573:2851:2861:13177:48321", -- [44]
			"37915:44825:50463", -- [45]
			"43573:2851:2861:13177:43086:6026:85734", -- [46]
			--["name"] = "Thondroril River, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 433629293,
			["direct"] = "4551:2389:12636:44232:37915:43573:46011",
			["f"] = 0,
		},
		[47655] = {
			"46552:2226", -- [1]
			"46552:2226:4551", -- [2]
			"47644:2389", -- [3]
			"47644:47661:43104:2851", -- [4]
			"47644:47661:43104:2851:2861:2858", -- [5]
			"47644:47661:43104:2851:2861:1387", -- [6]
			"47644:47661:43104:2851:2861", -- [7]
			"47644:47661:43104:2851:2861:13177:43086:6026", -- [8]
			"47644:2389:37888:12636", -- [9]
			"47644:47661:43104:2851:2861:13177", -- [10]
			"47644:47661:43104:2851:2861:3305", -- [11]
			"47644:2389:4314", -- [12]
			"47644:2389:37888:12636:16189:16192", -- [13]
			"47644:2389:37888:12636:16189", -- [14]
			"47644:2389:37888:44232:44233", -- [15]
			"47644:2389:37888:44232:28621", -- [16]
			"47644:2389:37888:44232:44231:44230", -- [17]
			"47644:2389:37888:44232", -- [18]
			"47644:2389:37888:12636:24851", -- [19]
			"47644:2389:37888:12636:24851:26560", -- [20]
			"47644:2389:37888", -- [21]
			"47644:2389:37915", -- [22]
			"47644:2389:37915:43124", -- [23]
			"47644:47661:43104:2851:2861:1387:43053", -- [24]
			"47644:47661:43104:2851:2861:1387:43052", -- [25]
			"47644:47661:43104:2851:2861:13177:43086", -- [26]
			"47644:47661:43104", -- [27]
			"47644:2389:43573", -- [28]
			"47644:2389:37888:12636:16189:44036", -- [29]
			"47644:2389:37888:44232:44231", -- [30]
			"47644:2389:37888:12636:16189:16192:44244", -- [31]
			"47644:47661:43104:2851:2861:44408", -- [32]
			"47644:47661:43104:2851:2861:44407", -- [33]
			"46552:2226:44825", -- [34]
			"46552:45479", -- [35]
			"47644:2389:37915:46004", -- [36]
			"47644:2389:37915:46004:46011", -- [37]
			"47644:47661:43104:2851:47121:47133:47116", -- [38]
			"47644:47661:43104:2851:47121:47133", -- [39]
			"47644:47661:43104:2851:47121", -- [40]
			"47644:47661:43104:2851:47121:47133:47156", -- [41]
			"47644:47661:43104:2851:47121:47133:47156:47061", -- [42]
			"47644:47661:43104:2851:47174", -- [43]
			"47644:47661", -- [44]
			"47644:2389:47665", -- [45]
			"47644:2389:37915:46004:46011:47875", -- [46]
			"47644:47661:43104:2851:2861:3305:47927", -- [47]
			"47644:47661:43104:2851:2861:13177:48321:48318", -- [48]
			"47644:47661:43104:2851:2861:13177:48321", -- [49]
			"46552:2226:50463", -- [50]
			"47644:47661:43104:2851:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Southpoint Gate, Hillsbrad",
			["m"] = 25,
			["f"] = 0,
			["direct"] = "46552:47644",
			["coord"] = 1249420485,
		},
		[43121] = {
			"6026:43086:13177:2861:2851:2389:2226", -- [1]
			"6026:43086:13177:2861:4551", -- [2]
			"6026:43086:13177:2861:2851:2389", -- [3]
			"6026:43086:13177:2861:2851", -- [4]
			"43114:2858", -- [5]
			"6026:1387", -- [6]
			"6026:43086:13177:2861", -- [7]
			"6026:43086:13177:2861:44407:12636", -- [8]
			"6026:43086:13177", -- [9]
			"6026:43086:13177:3305", -- [10]
			"6026:43086:13177:2861:2851:4314", -- [11]
			"6026:43086:13177:2861:44407:12636:16189:16192", -- [12]
			"6026:43086:13177:2861:44407:12636:16189", -- [13]
			"6026:43086:13177:2861:2851:43573:37888:44232:44233", -- [14]
			"6026:43086:13177:2861:44407:12636:44230:28621", -- [15]
			"6026:43086:13177:2861:44407:12636:44230", -- [16]
			"6026:43086:13177:2861:2851:43573:37888:44232", -- [17]
			"6026:43086:13177:2861:44407:12636:24851", -- [18]
			"6026:43086:13177:2861:44407:12636:24851:26560", -- [19]
			"6026:43086:13177:2861:2851:43573:37888", -- [20]
			"6026:43086:13177:2861:2851:43573:46004:37915", -- [21]
			"6026:43086:13177:2861:2851:43573:46004:37915:43124", -- [22]
			"6026:1387:43053", -- [23]
			"6026:1387:43052", -- [24]
			"6026:43086", -- [25]
			"6026:43086:13177:2861:2851:43104", -- [26]
			"6026:43086:13177:2861:2851:43573", -- [27]
			"6026:43086:13177:2861:44407:12636:16189:44036", -- [28]
			"6026:43086:13177:2861:2851:43573:37888:44232:44231", -- [29]
			"6026:43086:13177:2861:44407:12636:16189:16192:44244", -- [30]
			"6026:43086:13177:2861:44408", -- [31]
			"6026:43086:13177:2861:44407", -- [32]
			"6026:43086:13177:2861:2851:43573:46004:37915:44825", -- [33]
			"6026:43086:13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [34]
			"6026:43086:13177:2861:2851:43573:46004", -- [35]
			"6026:43086:13177:2861:2851:43573:46004:46011", -- [36]
			"6026:43086:13177:2861:2851:43104:47661:47644:47655:46552", -- [37]
			"6026:43086:13177:2861:47121:47133:47116", -- [38]
			"6026:43086:13177:2861:47121:47133", -- [39]
			"6026:43086:13177:2861:47121", -- [40]
			"6026:43086:13177:2861:47121:47133:47156", -- [41]
			"6026:43086:13177:2861:47174:47061", -- [42]
			"6026:43086:13177:2861:47174", -- [43]
			"6026:43086:13177:2861:2851:43104:47661:47644", -- [44]
			"6026:43086:13177:2861:2851:43104:47661:47644:47655", -- [45]
			"6026:43086:13177:2861:2851:43104:47661", -- [46]
			"6026:43086:13177:2861:2851:2389:47665", -- [47]
			"6026:43086:13177:2861:2851:43573:46004:46011:47875", -- [48]
			"6026:43086:13177:48321:48318:47927", -- [49]
			"6026:43086:13177:48321:48318", -- [50]
			"6026:43086:13177:48321", -- [51]
			"6026:43086:13177:2861:2851:43573:46004:37915:44825:50463", -- [52]
			--["name"] = "Dreadmaul Hold, Blasted Lands",
			["m"] = 17,
			["coord"] = 1871324316,
			["direct"] = "6026:43114",
			["f"] = 0,
		},
		[43220] = {
			"4551:2226", -- [1]
			"4551:2389", -- [2]
			"3305:2861:2851", -- [3]
			"3305:13177:1387:2858", -- [4]
			"3305:13177:1387", -- [5]
			"3305:2861", -- [6]
			"3305:13177:43086:6026", -- [7]
			"4551:37888:12636", -- [8]
			"3305:13177", -- [9]
			"3305:2861:2851:4314", -- [10]
			"4551:37888:12636:16189:16192", -- [11]
			"4551:37888:12636:16189", -- [12]
			"4551:37915:46004:46011:47875:44233", -- [13]
			"4551:37888:44232:28621", -- [14]
			"4551:37888:44232:44231:44230", -- [15]
			"4551:37888:44232", -- [16]
			"4551:37888:12636:24851", -- [17]
			"4551:37888:12636:24851:26560", -- [18]
			"4551:37888", -- [19]
			"4551:37915", -- [20]
			"4551:43124", -- [21]
			"3305:13177:1387:43053", -- [22]
			"3305:13177:1387:43052", -- [23]
			"3305:13177:43086", -- [24]
			"3305:2861:2851:43104", -- [25]
			"3305:2861:2851:43573", -- [26]
			"4551:37888:12636:16189:44036", -- [27]
			"4551:37888:44232:44231", -- [28]
			"4551:37888:12636:16189:16192:44244", -- [29]
			"3305:2861:44408", -- [30]
			"3305:2861:44407", -- [31]
			"4551:44825", -- [32]
			"4551:2226:46552:45479", -- [33]
			"4551:37915:46004", -- [34]
			"4551:37915:46004:46011", -- [35]
			"4551:2226:46552", -- [36]
			"3305:2861:47121:47133:47116", -- [37]
			"3305:2861:47121:47133", -- [38]
			"3305:2861:47121", -- [39]
			"3305:2861:47121:47133:47156", -- [40]
			"3305:2861:47174:47061", -- [41]
			"3305:2861:47174", -- [42]
			"4551:2389:47644", -- [43]
			"4551:2226:46552:47655", -- [44]
			"4551:2389:47661", -- [45]
			"4551:37915:47665", -- [46]
			"4551:37915:46004:46011:47875", -- [47]
			"3305:47927", -- [48]
			"3305:47927:48318", -- [49]
			"3305:13177:48321", -- [50]
			"4551:44825:50463", -- [51]
			"3305:13177:43086:6026:85734", -- [52]
			--["name"] = "Sandy Beach, Vashj'ir",
			["m"] = 205,
			["direct"] = "4551:3305",
			["coord"] = 2621458599,
			["f"] = 0,
		},
		[47661] = {
			"2389:2226", -- [1]
			"2389:4551", -- [2]
			"43104:2851", -- [3]
			"43104:2851:2861:2858", -- [4]
			"43104:2851:2861:1387", -- [5]
			"43104:2851:2861", -- [6]
			"43104:2851:2861:13177:43086:6026", -- [7]
			"2389:37888:12636", -- [8]
			"43104:2851:2861:13177", -- [9]
			"43104:2851:2861:3305", -- [10]
			"2389:4314", -- [11]
			"2389:37888:12636:16189:16192", -- [12]
			"2389:37888:12636:16189", -- [13]
			"2389:37888:44232:44233", -- [14]
			"2389:37888:44232:28621", -- [15]
			"2389:37888:44232:44231:44230", -- [16]
			"2389:37888:44232", -- [17]
			"2389:37888:12636:24851", -- [18]
			"2389:37888:12636:24851:26560", -- [19]
			"2389:37888", -- [20]
			"2389:37915", -- [21]
			"2389:37915:43124", -- [22]
			"43104:2851:2861:1387:43053", -- [23]
			"43104:2851:2861:1387:43052", -- [24]
			"43104:2851:2861:13177:43086", -- [25]
			"2389:43573", -- [26]
			"2389:37888:12636:16189:44036", -- [27]
			"2389:37888:44232:44231", -- [28]
			"2389:37888:12636:16189:16192:44244", -- [29]
			"43104:2851:2861:44408", -- [30]
			"43104:2851:2861:44407", -- [31]
			"2389:37915:44825", -- [32]
			"47644:47655:46552:45479", -- [33]
			"2389:37915:46004", -- [34]
			"2389:37915:46004:46011", -- [35]
			"47644:47655:46552", -- [36]
			"43104:2851:47121:47133:47116", -- [37]
			"43104:2851:47121:47133", -- [38]
			"43104:2851:47121", -- [39]
			"43104:2851:47121:47133:47156", -- [40]
			"43104:2851:47121:47133:47156:47061", -- [41]
			"43104:2851:47174", -- [42]
			"47644:47655", -- [43]
			"2389:47665", -- [44]
			"2389:37915:46004:46011:47875", -- [45]
			"43104:2851:2861:3305:47927", -- [46]
			"43104:2851:2861:13177:48321:48318", -- [47]
			"43104:2851:2861:13177:48321", -- [48]
			"2389:2226:50463", -- [49]
			"43104:2851:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Eastpoint Tower, Hillsbrad",
			["m"] = 25,
			["f"] = 0,
			["direct"] = "2389:43104:47644",
			["coord"] = 2562564542,
		},
		[2851] = {
			"2389:2226", -- [1]
			"2861:2858", -- [2]
			"2861:1387", -- [3]
			"2861:13177:43086:6026", -- [4]
			"43573:37888:12636", -- [5]
			"2861:13177", -- [6]
			"2861:3305", -- [7]
			"43573:37888:12636:16189:16192", -- [8]
			"43573:37888:12636:16189", -- [9]
			"43573:37888:44232:44233", -- [10]
			"43573:37888:44232:28621", -- [11]
			"43573:37888:44232:44231:44230", -- [12]
			"43573:37888:44232", -- [13]
			"43573:37888:12636:24851", -- [14]
			"43573:37888:12636:24851:26560", -- [15]
			"43573:37888", -- [16]
			"43573:46004:37915", -- [17]
			"43573:46004:37915:43124", -- [18]
			"2861:1387:43053", -- [19]
			"2861:1387:43052", -- [20]
			"2861:13177:43086", -- [21]
			"43573:37888:12636:16189:44036", -- [22]
			"43573:37888:44232:44231", -- [23]
			"43573:37888:12636:16189:16192:44244", -- [24]
			"2861:44408", -- [25]
			"2861:44407", -- [26]
			"43573:46004:37915:44825", -- [27]
			"43104:47661:47644:47655:46552:45479", -- [28]
			"43573:46004", -- [29]
			"43573:46004:46011", -- [30]
			"43104:47661:47644:47655:46552", -- [31]
			"47121:47133:47116", -- [32]
			"47121:47133", -- [33]
			"47121:47133:47156", -- [34]
			"47121:47133:47156:47061", -- [35]
			"43104:47661:47644", -- [36]
			"43104:47661:47644:47655", -- [37]
			"43104:47661", -- [38]
			"2389:47665", -- [39]
			"43573:46004:46011:47875", -- [40]
			"2861:3305:47927", -- [41]
			"2861:13177:48321:48318", -- [42]
			"2861:13177:48321", -- [43]
			"43573:46004:37915:44825:50463", -- [44]
			"2861:13177:43086:6026:85734", -- [45]
			--["name"] = "Hammerfall, Arathi",
			["m"] = 14,
			["f"] = 0,
			["direct"] = "4551:2389:2861:4314:43104:43573:47121:47174",
			["coord"] = 2927252869,
		},
		[47665] = {
			"2389:2226", -- [1]
			"37915:4551", -- [2]
			"2389:2851", -- [3]
			"2389:2851:2861:2858", -- [4]
			"2389:2851:2861:1387", -- [5]
			"2389:2851:2861", -- [6]
			"2389:2851:2861:13177:43086:6026", -- [7]
			"37915:37888:12636", -- [8]
			"2389:2851:2861:13177", -- [9]
			"2389:2851:2861:3305", -- [10]
			"2389:4314", -- [11]
			"37915:37888:12636:16189:16192", -- [12]
			"37915:37888:12636:16189", -- [13]
			"37915:46004:46011:47875:44233", -- [14]
			"37915:37888:44232:28621", -- [15]
			"37915:37888:44232:44231:44230", -- [16]
			"37915:37888:44232", -- [17]
			"37915:37888:12636:24851", -- [18]
			"37915:37888:12636:24851:26560", -- [19]
			"37915:37888", -- [20]
			"37915:43124", -- [21]
			"2389:2851:2861:1387:43053", -- [22]
			"2389:2851:2861:1387:43052", -- [23]
			"2389:2851:2861:13177:43086", -- [24]
			"2389:43104", -- [25]
			"2389:43573", -- [26]
			"37915:37888:12636:16189:44036", -- [27]
			"37915:37888:44232:44231", -- [28]
			"37915:37888:12636:16189:16192:44244", -- [29]
			"2389:2851:2861:44408", -- [30]
			"2389:2851:2861:44407", -- [31]
			"37915:44825", -- [32]
			"2389:47644:47655:46552:45479", -- [33]
			"37915:46004", -- [34]
			"37915:46004:46011", -- [35]
			"2389:47644:47655:46552", -- [36]
			"2389:2851:47121:47133:47116", -- [37]
			"2389:2851:47121:47133", -- [38]
			"2389:2851:47121", -- [39]
			"2389:2851:47121:47133:47156", -- [40]
			"2389:2851:47121:47133:47156:47061", -- [41]
			"2389:2851:47174", -- [42]
			"2389:47644", -- [43]
			"2389:47644:47655", -- [44]
			"2389:47661", -- [45]
			"37915:46004:46011:47875", -- [46]
			"2389:2851:2861:3305:47927", -- [47]
			"2389:2851:2861:13177:48321:48318", -- [48]
			"2389:2851:2861:13177:48321", -- [49]
			"37915:44825:50463", -- [50]
			"2389:2851:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Strahnbrad, Alterac Mountains",
			["m"] = 25,
			["coord"] = 2499298249,
			["direct"] = "2389:37915",
			["f"] = 0,
		},
		[16189] = {
			"12636:37888:37915:44825:2226", -- [1]
			"12636:37888:4551", -- [2]
			"12636:37888:2389", -- [3]
			"12636:4314:2851", -- [4]
			"12636:44407:2861:2858", -- [5]
			"12636:44407:2861:1387", -- [6]
			"12636:44407:2861", -- [7]
			"12636:44407:2861:13177:43086:6026", -- [8]
			"12636:44407:2861:13177", -- [9]
			"12636:44407:2861:3305", -- [10]
			"12636:4314", -- [11]
			"12636:44230:44233", -- [12]
			"12636:44230:28621", -- [13]
			"12636:44230", -- [14]
			"12636:44231:44232", -- [15]
			"16192:26560", -- [16]
			"12636:37888", -- [17]
			"12636:37888:37915", -- [18]
			"12636:37888:37915:43124", -- [19]
			"12636:44407:2861:1387:43053", -- [20]
			"12636:44407:2861:1387:43052", -- [21]
			"12636:44407:2861:13177:43086", -- [22]
			"12636:37888:2389:43104", -- [23]
			"12636:37888:43573", -- [24]
			"12636:44231", -- [25]
			"16192:44244", -- [26]
			"12636:44407:44408", -- [27]
			"12636:44407", -- [28]
			"12636:37888:37915:44825", -- [29]
			"12636:37888:37915:44825:2226:46552:45479", -- [30]
			"12636:37888:46011:46004", -- [31]
			"12636:37888:46011", -- [32]
			"12636:37888:37915:44825:2226:46552", -- [33]
			"12636:4314:2851:47121:47133:47116", -- [34]
			"12636:4314:2851:47121:47133", -- [35]
			"12636:4314:2851:47121", -- [36]
			"12636:4314:2851:47121:47133:47156", -- [37]
			"12636:4314:2851:47121:47133:47156:47061", -- [38]
			"12636:4314:2851:47174", -- [39]
			"12636:37888:2389:47644", -- [40]
			"12636:37888:2389:47644:47655", -- [41]
			"12636:37888:2389:47661", -- [42]
			"12636:37888:37915:47665", -- [43]
			"12636:44230:44233:47875", -- [44]
			"12636:44407:2861:3305:47927", -- [45]
			"12636:44407:2861:13177:48321:48318", -- [46]
			"12636:44407:2861:13177:48321", -- [47]
			"12636:37888:37915:44825:50463", -- [48]
			"12636:44407:2861:13177:43086:6026:85734", -- [49]
			--["name"] = "Tranquillien, Ghostlands",
			["m"] = 95,
			["coord"] = 1953517111,
			["direct"] = "12636:16192:24851:44036",
			["f"] = 0,
		},
		[50463] = {
			"44825:4551", -- [1]
			"2226:2389", -- [2]
			"2226:2389:2851", -- [3]
			"2226:2389:2851:2861:2858", -- [4]
			"2226:2389:2851:2861:1387", -- [5]
			"2226:2389:2851:2861", -- [6]
			"2226:2389:2851:2861:13177:43086:6026", -- [7]
			"44825:37915:37888:12636", -- [8]
			"2226:2389:2851:2861:13177", -- [9]
			"2226:2389:2851:2861:3305", -- [10]
			"2226:2389:4314", -- [11]
			"44825:37915:37888:12636:16189:16192", -- [12]
			"44825:37915:37888:12636:16189", -- [13]
			"44825:37915:46004:46011:47875:44233", -- [14]
			"44825:37915:37888:44232:28621", -- [15]
			"44825:37915:37888:44232:44231:44230", -- [16]
			"44825:37915:37888:44232", -- [17]
			"44825:37915:37888:12636:24851", -- [18]
			"44825:37915:37888:12636:24851:26560", -- [19]
			"44825:37915:37888", -- [20]
			"44825:37915", -- [21]
			"44825:43124", -- [22]
			"2226:2389:2851:2861:1387:43053", -- [23]
			"2226:2389:2851:2861:1387:43052", -- [24]
			"2226:2389:2851:2861:13177:43086", -- [25]
			"2226:2389:43104", -- [26]
			"44825:37915:46004:43573", -- [27]
			"44825:37915:37888:12636:16189:44036", -- [28]
			"44825:37915:37888:44232:44231", -- [29]
			"44825:37915:37888:12636:16189:16192:44244", -- [30]
			"2226:2389:2851:2861:44408", -- [31]
			"2226:2389:2851:2861:44407", -- [32]
			"2226:46552:45479", -- [33]
			"44825:37915:46004", -- [34]
			"44825:37915:46004:46011", -- [35]
			"2226:46552", -- [36]
			"2226:2389:2851:47121:47133:47116", -- [37]
			"2226:2389:2851:47121:47133", -- [38]
			"2226:2389:2851:47121", -- [39]
			"2226:2389:2851:47121:47133:47156", -- [40]
			"2226:2389:2851:47121:47133:47156:47061", -- [41]
			"2226:2389:2851:47174", -- [42]
			"2226:46552:47655:47644", -- [43]
			"2226:46552:47655", -- [44]
			"2226:46552:47655:47644:47661", -- [45]
			"44825:37915:47665", -- [46]
			"44825:37915:46004:46011:47875", -- [47]
			"2226:2389:2851:2861:3305:47927", -- [48]
			"2226:2389:2851:2861:13177:48321:48318", -- [49]
			"2226:2389:2851:2861:13177:48321", -- [50]
			"2226:2389:2851:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Forsaken Rear Guard, Silverpine Forest",
			["m"] = 21,
			["f"] = 0,
			["direct"] = "2226:44825",
			["coord"] = 1971861489,
		},
		[43053] = {
			"1387:2861:2851:2389:2226", -- [1]
			"1387:2861:4551", -- [2]
			"1387:2861:2851:2389", -- [3]
			"1387:2861:2851", -- [4]
			"1387:2861", -- [5]
			"1387:6026", -- [6]
			"1387:2861:44407:12636", -- [7]
			"1387:13177", -- [8]
			"1387:13177:3305", -- [9]
			"1387:2861:2851:4314", -- [10]
			"1387:2861:44407:12636:16189:16192", -- [11]
			"1387:2861:44407:12636:16189", -- [12]
			"1387:2861:2851:43573:37888:44232:44233", -- [13]
			"1387:2861:44407:12636:44230:28621", -- [14]
			"1387:2861:44407:12636:44230", -- [15]
			"1387:2861:2851:43573:37888:44232", -- [16]
			"1387:2861:44407:12636:24851", -- [17]
			"1387:2861:44407:12636:24851:26560", -- [18]
			"1387:2861:2851:43573:37888", -- [19]
			"1387:2861:2851:43573:46004:37915", -- [20]
			"1387:2861:2851:43573:46004:37915:43124", -- [21]
			"1387:6026:43086", -- [22]
			"1387:2861:2851:43104", -- [23]
			"1387:2861:2851:43573", -- [24]
			"1387:2861:44407:12636:16189:44036", -- [25]
			"1387:2861:2851:43573:37888:44232:44231", -- [26]
			"1387:2861:44407:12636:16189:16192:44244", -- [27]
			"1387:2861:44408", -- [28]
			"1387:2861:44407", -- [29]
			"1387:2861:2851:43573:46004:37915:44825", -- [30]
			"1387:2861:2851:43104:47661:47644:47655:46552:45479", -- [31]
			"1387:2861:2851:43573:46004", -- [32]
			"1387:2861:2851:43573:46004:46011", -- [33]
			"1387:2861:2851:43104:47661:47644:47655:46552", -- [34]
			"1387:2861:47121:47133:47116", -- [35]
			"1387:2861:47121:47133", -- [36]
			"1387:2861:47121", -- [37]
			"1387:2861:47121:47133:47156", -- [38]
			"1387:2861:47174:47061", -- [39]
			"1387:2861:47174", -- [40]
			"1387:2861:2851:43104:47661:47644", -- [41]
			"1387:2861:2851:43104:47661:47644:47655", -- [42]
			"1387:2861:2851:43104:47661", -- [43]
			"1387:2861:2851:2389:47665", -- [44]
			"1387:2861:2851:43573:46004:46011:47875", -- [45]
			"1387:13177:48321:48318:47927", -- [46]
			"1387:13177:48321:48318", -- [47]
			"1387:13177:48321", -- [48]
			"1387:2861:2851:43573:46004:37915:44825:50463", -- [49]
			"43052:85734", -- [50]
			--["name"] = "Hardwrench Hideaway, Stranglethorn",
			["m"] = 210,
			["f"] = 0,
			["direct"] = "2858:1387:43052",
			["coord"] = 1508985618,
		},
		[85734] = {
			"6026:43086:13177:2861:2851:2389:2226", -- [1]
			"6026:43086:13177:2861:4551", -- [2]
			"6026:43086:13177:2861:2851:2389", -- [3]
			"6026:43086:13177:2861:2851", -- [4]
			"43052:43053:2858", -- [5]
			"43052:1387", -- [6]
			"6026:43086:13177:2861", -- [7]
			"6026:43086:13177:2861:44407:12636", -- [8]
			"6026:43086:13177", -- [9]
			"6026:43086:13177:3305", -- [10]
			"6026:43086:13177:2861:2851:4314", -- [11]
			"6026:43086:13177:2861:44407:12636:16189:16192", -- [12]
			"6026:43086:13177:2861:44407:12636:16189", -- [13]
			"6026:43086:13177:2861:2851:43573:37888:44232:44233", -- [14]
			"6026:43086:13177:2861:44407:12636:44230:28621", -- [15]
			"6026:43086:13177:2861:44407:12636:44230", -- [16]
			"6026:43086:13177:2861:2851:43573:37888:44232", -- [17]
			"6026:43086:13177:2861:44407:12636:24851", -- [18]
			"6026:43086:13177:2861:44407:12636:24851:26560", -- [19]
			"6026:43086:13177:2861:2851:43573:37888", -- [20]
			"6026:43086:13177:2861:2851:43573:46004:37915", -- [21]
			"6026:43086:13177:2861:2851:43573:46004:37915:43124", -- [22]
			"43052:43053", -- [23]
			"6026:43086", -- [24]
			"6026:43086:13177:2861:2851:43104", -- [25]
			"6026:43086:13177:2861:2851:43573", -- [26]
			"6026:43086:13177:2861:44407:12636:16189:44036", -- [27]
			"6026:43086:13177:2861:2851:43573:37888:44232:44231", -- [28]
			"6026:43086:13177:2861:44407:12636:16189:16192:44244", -- [29]
			"6026:43086:13177:2861:44408", -- [30]
			"6026:43086:13177:2861:44407", -- [31]
			"6026:43086:13177:2861:2851:43573:46004:37915:44825", -- [32]
			"6026:43086:13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [33]
			"6026:43086:13177:2861:2851:43573:46004", -- [34]
			"6026:43086:13177:2861:2851:43573:46004:46011", -- [35]
			"6026:43086:13177:2861:2851:43104:47661:47644:47655:46552", -- [36]
			"6026:43086:13177:2861:47121:47133:47116", -- [37]
			"6026:43086:13177:2861:47121:47133", -- [38]
			"6026:43086:13177:2861:47121", -- [39]
			"6026:43086:13177:2861:47121:47133:47156", -- [40]
			"6026:43086:13177:2861:47174:47061", -- [41]
			"6026:43086:13177:2861:47174", -- [42]
			"6026:43086:13177:2861:2851:43104:47661:47644", -- [43]
			"6026:43086:13177:2861:2851:43104:47661:47644:47655", -- [44]
			"6026:43086:13177:2861:2851:43104:47661", -- [45]
			"6026:43086:13177:2861:2851:2389:47665", -- [46]
			"6026:43086:13177:2861:2851:43573:46004:46011:47875", -- [47]
			"6026:43086:13177:48321:48318:47927", -- [48]
			"6026:43086:13177:48321:48318", -- [49]
			"6026:43086:13177:48321", -- [50]
			"6026:43086:13177:2861:2851:43573:46004:37915:44825:50463", -- [51]
			--["name"] = "Shattered Landing, Blasted Lands",
			["m"] = 17,
			["coord"] = 3131014275,
			["direct"] = "6026:43052",
			["f"] = 0,
		},
		[47927] = {
			"3305:2861:2851:2389:2226", -- [1]
			"3305:43220:4551", -- [2]
			"3305:2861:2851:2389", -- [3]
			"3305:2861:2851", -- [4]
			"3305:13177:1387:2858", -- [5]
			"3305:13177:1387", -- [6]
			"3305:2861", -- [7]
			"3305:13177:43086:6026", -- [8]
			"3305:2861:44407:12636", -- [9]
			"3305:13177", -- [10]
			"3305:2861:2851:4314", -- [11]
			"3305:2861:44407:12636:16189:16192", -- [12]
			"3305:2861:44407:12636:16189", -- [13]
			"3305:2861:2851:43573:37888:44232:44233", -- [14]
			"3305:2861:44407:12636:44230:28621", -- [15]
			"3305:2861:44407:12636:44230", -- [16]
			"3305:2861:2851:43573:37888:44232", -- [17]
			"3305:2861:44407:12636:24851", -- [18]
			"3305:2861:44407:12636:24851:26560", -- [19]
			"3305:2861:2851:43573:37888", -- [20]
			"3305:2861:2851:43573:46004:37915", -- [21]
			"3305:2861:2851:43573:46004:37915:43124", -- [22]
			"3305:13177:1387:43053", -- [23]
			"3305:13177:1387:43052", -- [24]
			"3305:13177:43086", -- [25]
			"3305:2861:2851:43104", -- [26]
			"3305:2861:2851:43573", -- [27]
			"3305:2861:44407:12636:16189:44036", -- [28]
			"3305:2861:2851:43573:37888:44232:44231", -- [29]
			"3305:2861:44407:12636:16189:16192:44244", -- [30]
			"3305:2861:44408", -- [31]
			"3305:2861:44407", -- [32]
			"3305:2861:2851:43573:46004:37915:44825", -- [33]
			"3305:2861:2851:43104:47661:47644:47655:46552:45479", -- [34]
			"3305:2861:2851:43573:46004", -- [35]
			"3305:2861:2851:43573:46004:46011", -- [36]
			"3305:2861:2851:43104:47661:47644:47655:46552", -- [37]
			"3305:2861:47121:47133:47116", -- [38]
			"3305:2861:47121:47133", -- [39]
			"3305:2861:47121", -- [40]
			"3305:2861:47121:47133:47156", -- [41]
			"3305:2861:47174:47061", -- [42]
			"3305:2861:47174", -- [43]
			"3305:2861:2851:43104:47661:47644", -- [44]
			"3305:2861:2851:43104:47661:47644:47655", -- [45]
			"3305:2861:2851:43104:47661", -- [46]
			"3305:2861:2851:2389:47665", -- [47]
			"3305:2861:2851:43573:46004:46011:47875", -- [48]
			"48318:48321", -- [49]
			"3305:2861:2851:43573:46004:37915:44825:50463", -- [50]
			"3305:13177:43086:6026:85734", -- [51]
			--["name"] = "Iron Summit, Searing Gorge",
			["m"] = 32,
			["coord"] = 1758769171,
			["direct"] = "3305:48318",
			["f"] = 0,
		},
		[47116] = {
			"47133:47121:2851:2389:2226", -- [1]
			"47133:47121:2851:43573:46004:37915:4551", -- [2]
			"47133:47121:2851:2389", -- [3]
			"47133:47121:2851", -- [4]
			"47133:47121:2861:2858", -- [5]
			"47133:47121:2861:1387", -- [6]
			"47133:47121:2861", -- [7]
			"47133:47121:2861:13177:43086:6026", -- [8]
			"47133:47121:2851:43573:37888:12636", -- [9]
			"47133:47121:2861:13177", -- [10]
			"47133:47121:2861:3305", -- [11]
			"47133:47121:2851:4314", -- [12]
			"47133:47121:2851:43573:37888:12636:16189:16192", -- [13]
			"47133:47121:2851:43573:37888:12636:16189", -- [14]
			"47133:47121:2851:43573:37888:44232:44233", -- [15]
			"47133:47121:2851:43573:37888:44232:28621", -- [16]
			"47133:47121:2851:43573:37888:44232:44231:44230", -- [17]
			"47133:47121:2851:43573:37888:44232", -- [18]
			"47133:47121:2851:43573:37888:12636:24851", -- [19]
			"47133:47121:2851:43573:37888:12636:24851:26560", -- [20]
			"47133:47121:2851:43573:37888", -- [21]
			"47133:47121:2851:43573:46004:37915", -- [22]
			"47133:47121:2851:43573:46004:37915:43124", -- [23]
			"47133:47121:2861:1387:43053", -- [24]
			"47133:47121:2861:1387:43052", -- [25]
			"47133:47121:2861:13177:43086", -- [26]
			"47133:47121:2851:43104", -- [27]
			"47133:47121:2851:43573", -- [28]
			"47133:47121:2851:43573:37888:12636:16189:44036", -- [29]
			"47133:47121:2851:43573:37888:44232:44231", -- [30]
			"47133:47121:2851:43573:37888:12636:16189:16192:44244", -- [31]
			"47133:47121:2861:44408", -- [32]
			"47133:47121:2861:44407", -- [33]
			"47133:47121:2851:43573:46004:37915:44825", -- [34]
			"47133:47121:2851:43104:47661:47644:47655:46552:45479", -- [35]
			"47133:47121:2851:43573:46004", -- [36]
			"47133:47121:2851:43573:46004:46011", -- [37]
			"47133:47121:2851:43104:47661:47644:47655:46552", -- [38]
			"47133:47121", -- [39]
			"47156:47061", -- [40]
			"47133:47121:2851:43104:47661:47644", -- [41]
			"47133:47121:2851:43104:47661:47644:47655", -- [42]
			"47133:47121:2851:43104:47661", -- [43]
			"47133:47121:2851:2389:47665", -- [44]
			"47133:47121:2851:43573:46004:46011:47875", -- [45]
			"47133:47121:2861:3305:47927", -- [46]
			"47133:47121:2861:13177:48321:48318", -- [47]
			"47133:47121:2861:13177:48321", -- [48]
			"47133:47121:2851:43573:46004:37915:44825:50463", -- [49]
			"47133:47121:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Crushblow, Twilight Highlands",
			["m"] = 241,
			["f"] = 0,
			["direct"] = "47133:47156:47174",
			["coord"] = 1965474545,
		},
		[16192] = {
			"16189:12636:37888:37915:44825:2226", -- [1]
			"16189:12636:37888:4551", -- [2]
			"16189:12636:37888:2389", -- [3]
			"16189:12636:4314:2851", -- [4]
			"16189:12636:44407:2861:2858", -- [5]
			"16189:12636:44407:2861:1387", -- [6]
			"16189:12636:44407:2861", -- [7]
			"16189:12636:44407:2861:13177:43086:6026", -- [8]
			"16189:12636", -- [9]
			"16189:12636:44407:2861:13177", -- [10]
			"16189:12636:44407:2861:3305", -- [11]
			"16189:12636:4314", -- [12]
			"16189:12636:44230:44233", -- [13]
			"16189:12636:44230:28621", -- [14]
			"16189:12636:44230", -- [15]
			"16189:12636:44231:44232", -- [16]
			"16189:24851", -- [17]
			"16189:12636:37888", -- [18]
			"16189:12636:37888:37915", -- [19]
			"16189:12636:37888:37915:43124", -- [20]
			"16189:12636:44407:2861:1387:43053", -- [21]
			"16189:12636:44407:2861:1387:43052", -- [22]
			"16189:12636:44407:2861:13177:43086", -- [23]
			"16189:12636:37888:2389:43104", -- [24]
			"16189:12636:37888:43573", -- [25]
			"16189:12636:44231", -- [26]
			"16189:12636:44407:44408", -- [27]
			"16189:12636:44407", -- [28]
			"16189:12636:37888:37915:44825", -- [29]
			"16189:12636:37888:37915:44825:2226:46552:45479", -- [30]
			"16189:12636:37888:46011:46004", -- [31]
			"16189:12636:37888:46011", -- [32]
			"16189:12636:37888:37915:44825:2226:46552", -- [33]
			"16189:12636:4314:2851:47121:47133:47116", -- [34]
			"16189:12636:4314:2851:47121:47133", -- [35]
			"16189:12636:4314:2851:47121", -- [36]
			"16189:12636:4314:2851:47121:47133:47156", -- [37]
			"16189:12636:4314:2851:47121:47133:47156:47061", -- [38]
			"16189:12636:4314:2851:47174", -- [39]
			"16189:12636:37888:2389:47644", -- [40]
			"16189:12636:37888:2389:47644:47655", -- [41]
			"16189:12636:37888:2389:47661", -- [42]
			"16189:12636:37888:37915:47665", -- [43]
			"16189:12636:44230:44233:47875", -- [44]
			"16189:12636:44407:2861:3305:47927", -- [45]
			"16189:12636:44407:2861:13177:48321:48318", -- [46]
			"16189:12636:44407:2861:13177:48321", -- [47]
			"16189:12636:37888:37915:44825:50463", -- [48]
			"16189:12636:44407:2861:13177:43086:6026:85734", -- [49]
			--["name"] = "Silvermoon City",
			["m"] = 94,
			["coord"] = 2335736303,
			["direct"] = "16189:26560:44036:44244",
			["f"] = 0,
		},
		[44407] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"2861:2858", -- [5]
			"2861:1387", -- [6]
			"2861:13177:43086:6026", -- [7]
			"2861:13177", -- [8]
			"2861:3305", -- [9]
			"2861:2851:4314", -- [10]
			"12636:16189:16192", -- [11]
			"12636:16189", -- [12]
			"12636:44230:44233", -- [13]
			"12636:44230:28621", -- [14]
			"12636:44230", -- [15]
			"12636:44231:44232", -- [16]
			"12636:24851", -- [17]
			"12636:24851:26560", -- [18]
			"2861:2851:43573:37888", -- [19]
			"2861:2851:43573:46004:37915", -- [20]
			"2861:2851:43573:46004:37915:43124", -- [21]
			"2861:1387:43053", -- [22]
			"2861:1387:43052", -- [23]
			"2861:13177:43086", -- [24]
			"2861:2851:43104", -- [25]
			"2861:2851:43573", -- [26]
			"12636:16189:44036", -- [27]
			"12636:44231", -- [28]
			"12636:16189:16192:44244", -- [29]
			"2861:2851:43573:46004:37915:44825", -- [30]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [31]
			"2861:2851:43573:46004", -- [32]
			"2861:2851:43573:46004:46011", -- [33]
			"2861:2851:43104:47661:47644:47655:46552", -- [34]
			"2861:47121:47133:47116", -- [35]
			"2861:47121:47133", -- [36]
			"2861:47121", -- [37]
			"2861:47121:47133:47156", -- [38]
			"2861:47174:47061", -- [39]
			"2861:47174", -- [40]
			"2861:2851:43104:47661:47644", -- [41]
			"2861:2851:43104:47661:47644:47655", -- [42]
			"2861:2851:43104:47661", -- [43]
			"2861:2851:2389:47665", -- [44]
			"2861:2851:43573:46004:46011:47875", -- [45]
			"2861:3305:47927", -- [46]
			"2861:13177:48321:48318", -- [47]
			"2861:13177:48321", -- [48]
			"2861:2851:43573:46004:37915:44825:50463", -- [49]
			"2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Fuselight, Badlands",
			["m"] = 15,
			["f"] = 0,
			["direct"] = "2861:12636:44408",
			["coord"] = 2759481903,
		},
		[1387] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"2861:44407:12636", -- [5]
			"13177:3305", -- [6]
			"2861:2851:4314", -- [7]
			"2861:44407:12636:16189:16192", -- [8]
			"2861:44407:12636:16189", -- [9]
			"2861:2851:43573:37888:44232:44233", -- [10]
			"2861:44407:12636:44230:28621", -- [11]
			"2861:44407:12636:44230", -- [12]
			"2861:2851:43573:37888:44232", -- [13]
			"2861:44407:12636:24851", -- [14]
			"2861:44407:12636:24851:26560", -- [15]
			"2861:2851:43573:37888", -- [16]
			"2861:2851:43573:46004:37915", -- [17]
			"2861:2851:43573:46004:37915:43124", -- [18]
			"6026:43086", -- [19]
			"2861:2851:43104", -- [20]
			"2861:2851:43573", -- [21]
			"2861:44407:12636:16189:44036", -- [22]
			"2861:2851:43573:37888:44232:44231", -- [23]
			"2861:44407:12636:16189:16192:44244", -- [24]
			"2861:44408", -- [25]
			"2861:44407", -- [26]
			"2861:2851:43573:46004:37915:44825", -- [27]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [28]
			"2861:2851:43573:46004", -- [29]
			"2861:2851:43573:46004:46011", -- [30]
			"2861:2851:43104:47661:47644:47655:46552", -- [31]
			"2861:47121:47133:47116", -- [32]
			"2861:47121:47133", -- [33]
			"2861:47121", -- [34]
			"2861:47121:47133:47156", -- [35]
			"2861:47174:47061", -- [36]
			"2861:47174", -- [37]
			"2861:2851:43104:47661:47644", -- [38]
			"2861:2851:43104:47661:47644:47655", -- [39]
			"2861:2851:43104:47661", -- [40]
			"2861:2851:2389:47665", -- [41]
			"2861:2851:43573:46004:46011:47875", -- [42]
			"13177:48321:48318:47927", -- [43]
			"13177:48321:48318", -- [44]
			"13177:48321", -- [45]
			"2861:2851:43573:46004:37915:44825:50463", -- [46]
			"43052:85734", -- [47]
			--["name"] = "Grom'gol, Stranglethorn",
			["m"] = 50,
			["f"] = 0,
			["direct"] = "2858:2861:6026:13177:43053:43052",
			["coord"] = 1673429731,
		},
		[43086] = {
			"13177:2861:2851:2389:2226", -- [1]
			"13177:2861:4551", -- [2]
			"13177:2861:2851:2389", -- [3]
			"13177:2861:2851", -- [4]
			"6026:2858", -- [5]
			"6026:1387", -- [6]
			"13177:2861", -- [7]
			"13177:2861:44407:12636", -- [8]
			"13177:3305", -- [9]
			"13177:2861:2851:4314", -- [10]
			"13177:2861:44407:12636:16189:16192", -- [11]
			"13177:2861:44407:12636:16189", -- [12]
			"13177:2861:2851:43573:37888:44232:44233", -- [13]
			"13177:2861:44407:12636:44230:28621", -- [14]
			"13177:2861:44407:12636:44230", -- [15]
			"13177:2861:2851:43573:37888:44232", -- [16]
			"13177:2861:44407:12636:24851", -- [17]
			"13177:2861:44407:12636:24851:26560", -- [18]
			"13177:2861:2851:43573:37888", -- [19]
			"13177:2861:2851:43573:46004:37915", -- [20]
			"13177:2861:2851:43573:46004:37915:43124", -- [21]
			"6026:1387:43053", -- [22]
			"6026:85734:43052", -- [23]
			"13177:2861:2851:43104", -- [24]
			"13177:2861:2851:43573", -- [25]
			"13177:2861:44407:12636:16189:44036", -- [26]
			"13177:2861:2851:43573:37888:44232:44231", -- [27]
			"13177:2861:44407:12636:16189:16192:44244", -- [28]
			"13177:2861:44408", -- [29]
			"13177:2861:44407", -- [30]
			"13177:2861:2851:43573:46004:37915:44825", -- [31]
			"13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [32]
			"13177:2861:2851:43573:46004", -- [33]
			"13177:2861:2851:43573:46004:46011", -- [34]
			"13177:2861:2851:43104:47661:47644:47655:46552", -- [35]
			"13177:2861:47121:47133:47116", -- [36]
			"13177:2861:47121:47133", -- [37]
			"13177:2861:47121", -- [38]
			"13177:2861:47121:47133:47156", -- [39]
			"13177:2861:47174:47061", -- [40]
			"13177:2861:47174", -- [41]
			"13177:2861:2851:43104:47661:47644", -- [42]
			"13177:2861:2851:43104:47661:47644:47655", -- [43]
			"13177:2861:2851:43104:47661", -- [44]
			"13177:2861:2851:2389:47665", -- [45]
			"13177:2861:2851:43573:46004:46011:47875", -- [46]
			"13177:48321:48318:47927", -- [47]
			"13177:48321:48318", -- [48]
			"13177:48321", -- [49]
			"13177:2861:2851:43573:46004:37915:44825:50463", -- [50]
			"6026:85734", -- [51]
			--["name"] = "Bogpaddle, Swamp of Sorrows",
			["m"] = 51,
			["f"] = 0,
			["direct"] = "6026:13177",
			["coord"] = 3096714937,
		},
		[2226] = {
			"2389:2851", -- [1]
			"2389:2851:2861:2858", -- [2]
			"2389:2851:2861:1387", -- [3]
			"2389:2851:2861", -- [4]
			"2389:2851:2861:13177:43086:6026", -- [5]
			"44825:37915:37888:12636", -- [6]
			"2389:2851:2861:13177", -- [7]
			"2389:2851:2861:3305", -- [8]
			"2389:4314", -- [9]
			"44825:37915:37888:12636:16189:16192", -- [10]
			"44825:37915:37888:12636:16189", -- [11]
			"44825:37915:46004:46011:47875:44233", -- [12]
			"44825:37915:37888:44232:28621", -- [13]
			"44825:37915:37888:44232:44231:44230", -- [14]
			"44825:37915:37888:44232", -- [15]
			"44825:37915:37888:12636:24851", -- [16]
			"44825:37915:37888:12636:24851:26560", -- [17]
			"44825:37915:37888", -- [18]
			"44825:37915", -- [19]
			"44825:43124", -- [20]
			"2389:2851:2861:1387:43053", -- [21]
			"2389:2851:2861:1387:43052", -- [22]
			"2389:2851:2861:13177:43086", -- [23]
			"2389:43104", -- [24]
			"2389:43573", -- [25]
			"44825:37915:37888:12636:16189:44036", -- [26]
			"44825:37915:37888:44232:44231", -- [27]
			"44825:37915:37888:12636:16189:16192:44244", -- [28]
			"2389:2851:2861:44408", -- [29]
			"2389:2851:2861:44407", -- [30]
			"44825:37915:46004", -- [31]
			"44825:37915:46004:46011", -- [32]
			"2389:2851:47121:47133:47116", -- [33]
			"2389:2851:47121:47133", -- [34]
			"2389:2851:47121", -- [35]
			"2389:2851:47121:47133:47156", -- [36]
			"2389:2851:47121:47133:47156:47061", -- [37]
			"2389:2851:47174", -- [38]
			"46552:47655:47644", -- [39]
			"46552:47655", -- [40]
			"46552:47655:47644:47661", -- [41]
			"2389:47665", -- [42]
			"44825:37915:46004:46011:47875", -- [43]
			"2389:2851:2861:3305:47927", -- [44]
			"2389:2851:2861:13177:48321:48318", -- [45]
			"2389:2851:2861:13177:48321", -- [46]
			"2389:2851:2861:13177:43086:6026:85734", -- [47]
			--["name"] = "The Sepulcher, Silverpine Forest",
			["m"] = 21,
			["f"] = 0,
			["direct"] = "4551:2389:44825:45479:46552:50463",
			["coord"] = 1953000628,
		},
		[47061] = {
			"47174:2851:2389:2226", -- [1]
			"47174:2851:43573:46004:37915:4551", -- [2]
			"47174:2851:2389", -- [3]
			"47174:2851", -- [4]
			"47174:2861:2858", -- [5]
			"47174:2861:1387", -- [6]
			"47174:2861", -- [7]
			"47174:2861:13177:43086:6026", -- [8]
			"47174:2851:43573:37888:12636", -- [9]
			"47174:2861:13177", -- [10]
			"47174:2861:3305", -- [11]
			"47174:2851:4314", -- [12]
			"47174:2851:43573:37888:12636:16189:16192", -- [13]
			"47174:2851:43573:37888:12636:16189", -- [14]
			"47174:2851:43573:37888:44232:44233", -- [15]
			"47174:2851:43573:37888:44232:28621", -- [16]
			"47174:2851:43573:37888:44232:44231:44230", -- [17]
			"47174:2851:43573:37888:44232", -- [18]
			"47174:2851:43573:37888:12636:24851", -- [19]
			"47174:2851:43573:37888:12636:24851:26560", -- [20]
			"47174:2851:43573:37888", -- [21]
			"47174:2851:43573:46004:37915", -- [22]
			"47174:2851:43573:46004:37915:43124", -- [23]
			"47174:2861:1387:43053", -- [24]
			"47174:2861:1387:43052", -- [25]
			"47174:2861:13177:43086", -- [26]
			"47174:2851:43104", -- [27]
			"47174:2851:43573", -- [28]
			"47174:2851:43573:37888:12636:16189:44036", -- [29]
			"47174:2851:43573:37888:44232:44231", -- [30]
			"47174:2851:43573:37888:12636:16189:16192:44244", -- [31]
			"47174:2861:44408", -- [32]
			"47174:2861:44407", -- [33]
			"47174:2851:43573:46004:37915:44825", -- [34]
			"47174:2851:43104:47661:47644:47655:46552:45479", -- [35]
			"47174:2851:43573:46004", -- [36]
			"47174:2851:43573:46004:46011", -- [37]
			"47174:2851:43104:47661:47644:47655:46552", -- [38]
			"47174:47116", -- [39]
			"47156:47133", -- [40]
			"47156:47133:47121", -- [41]
			"47174:2851:43104:47661:47644", -- [42]
			"47174:2851:43104:47661:47644:47655", -- [43]
			"47174:2851:43104:47661", -- [44]
			"47174:2851:2389:47665", -- [45]
			"47174:2851:43573:46004:46011:47875", -- [46]
			"47174:2861:3305:47927", -- [47]
			"47174:2861:13177:48321:48318", -- [48]
			"47174:2861:13177:48321", -- [49]
			"47174:2851:43573:46004:37915:44825:50463", -- [50]
			"47174:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "The Krazzworks, Twilight Highlands",
			["m"] = 241,
			["f"] = 0,
			["direct"] = "47156:47174",
			["coord"] = 3236441458,
		},
		[48321] = {
			"13177:2861:2851:2389:2226", -- [1]
			"13177:2861:4551", -- [2]
			"13177:2861:2851:2389", -- [3]
			"13177:2861:2851", -- [4]
			"13177:1387:2858", -- [5]
			"13177:1387", -- [6]
			"13177:2861", -- [7]
			"13177:43086:6026", -- [8]
			"13177:2861:44407:12636", -- [9]
			"13177:3305", -- [10]
			"13177:2861:2851:4314", -- [11]
			"13177:2861:44407:12636:16189:16192", -- [12]
			"13177:2861:44407:12636:16189", -- [13]
			"13177:2861:2851:43573:37888:44232:44233", -- [14]
			"13177:2861:44407:12636:44230:28621", -- [15]
			"13177:2861:44407:12636:44230", -- [16]
			"13177:2861:2851:43573:37888:44232", -- [17]
			"13177:2861:44407:12636:24851", -- [18]
			"13177:2861:44407:12636:24851:26560", -- [19]
			"13177:2861:2851:43573:37888", -- [20]
			"13177:2861:2851:43573:46004:37915", -- [21]
			"13177:2861:2851:43573:46004:37915:43124", -- [22]
			"13177:1387:43053", -- [23]
			"13177:1387:43052", -- [24]
			"13177:43086", -- [25]
			"13177:2861:2851:43104", -- [26]
			"13177:2861:2851:43573", -- [27]
			"13177:2861:44407:12636:16189:44036", -- [28]
			"13177:2861:2851:43573:37888:44232:44231", -- [29]
			"13177:2861:44407:12636:16189:16192:44244", -- [30]
			"13177:2861:44408", -- [31]
			"13177:2861:44407", -- [32]
			"13177:2861:2851:43573:46004:37915:44825", -- [33]
			"13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [34]
			"13177:2861:2851:43573:46004", -- [35]
			"13177:2861:2851:43573:46004:46011", -- [36]
			"13177:2861:2851:43104:47661:47644:47655:46552", -- [37]
			"13177:2861:47121:47133:47116", -- [38]
			"13177:2861:47121:47133", -- [39]
			"13177:2861:47121", -- [40]
			"13177:2861:47121:47133:47156", -- [41]
			"13177:2861:47174:47061", -- [42]
			"13177:2861:47174", -- [43]
			"13177:2861:2851:43104:47661:47644", -- [44]
			"13177:2861:2851:43104:47661:47644:47655", -- [45]
			"13177:2861:2851:43104:47661", -- [46]
			"13177:2861:2851:2389:47665", -- [47]
			"13177:2861:2851:43573:46004:46011:47875", -- [48]
			"48318:47927", -- [49]
			"13177:2861:2851:43573:46004:37915:44825:50463", -- [50]
			"13177:43086:6026:85734", -- [51]
			--["name"] = "Chiselgrip, Burning Steppes",
			["m"] = 36,
			["f"] = 0,
			["direct"] = "13177:48318",
			["coord"] = 1982425941,
		},
		[12636] = {
			"37888:37915:44825:2226", -- [1]
			"37888:2389", -- [2]
			"4314:2851", -- [3]
			"44407:2861:2858", -- [4]
			"44407:2861:1387", -- [5]
			"44407:2861", -- [6]
			"44407:2861:13177:43086:6026", -- [7]
			"44407:2861:13177", -- [8]
			"44407:2861:3305", -- [9]
			"16189:16192", -- [10]
			"44230:44233", -- [11]
			"44230:28621", -- [12]
			"44231:44232", -- [13]
			"24851:26560", -- [14]
			"37888:37915", -- [15]
			"37888:37915:43124", -- [16]
			"44407:2861:1387:43053", -- [17]
			"44407:2861:1387:43052", -- [18]
			"44407:2861:13177:43086", -- [19]
			"37888:2389:43104", -- [20]
			"37888:43573", -- [21]
			"16189:44036", -- [22]
			"16189:16192:44244", -- [23]
			"44407:44408", -- [24]
			"37888:37915:44825", -- [25]
			"37888:37915:44825:2226:46552:45479", -- [26]
			"37888:46011:46004", -- [27]
			"37888:46011", -- [28]
			"37888:37915:44825:2226:46552", -- [29]
			"4314:2851:47121:47133:47116", -- [30]
			"4314:2851:47121:47133", -- [31]
			"4314:2851:47121", -- [32]
			"4314:2851:47121:47133:47156", -- [33]
			"4314:2851:47121:47133:47156:47061", -- [34]
			"4314:2851:47174", -- [35]
			"37888:2389:47644", -- [36]
			"37888:2389:47644:47655", -- [37]
			"37888:2389:47661", -- [38]
			"37888:37915:47665", -- [39]
			"44230:44233:47875", -- [40]
			"44407:2861:3305:47927", -- [41]
			"44407:2861:13177:48321:48318", -- [42]
			"44407:2861:13177:48321", -- [43]
			"37888:37915:44825:50463", -- [44]
			"44407:2861:13177:43086:6026:85734", -- [45]
			--["name"] = "Light's Hope Chapel, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 3255470232,
			["direct"] = "4551:4314:16189:44230:24851:37888:44231:44407",
			["f"] = 0,
		},
		[44230] = {
			"44231:44232:37888:37915:44825:2226", -- [1]
			"44231:44232:37888:4551", -- [2]
			"44231:44232:37888:2389", -- [3]
			"44231:44232:37888:43573:2851", -- [4]
			"12636:44407:2861:2858", -- [5]
			"12636:44407:2861:1387", -- [6]
			"12636:44407:2861", -- [7]
			"12636:44407:2861:13177:43086:6026", -- [8]
			"12636:44407:2861:13177", -- [9]
			"12636:44407:2861:3305", -- [10]
			"12636:4314", -- [11]
			"12636:16189:16192", -- [12]
			"12636:16189", -- [13]
			"44231:44232", -- [14]
			"12636:24851", -- [15]
			"12636:24851:26560", -- [16]
			"44231:44232:37888", -- [17]
			"44231:44232:37888:37915", -- [18]
			"44231:44232:37888:37915:43124", -- [19]
			"12636:44407:2861:1387:43053", -- [20]
			"12636:44407:2861:1387:43052", -- [21]
			"12636:44407:2861:13177:43086", -- [22]
			"44231:44232:37888:2389:43104", -- [23]
			"44231:44232:37888:43573", -- [24]
			"12636:16189:44036", -- [25]
			"12636:16189:16192:44244", -- [26]
			"12636:44407:44408", -- [27]
			"12636:44407", -- [28]
			"44231:44232:37888:37915:44825", -- [29]
			"44231:44232:37888:37915:44825:2226:46552:45479", -- [30]
			"44231:44232:37888:46011:46004", -- [31]
			"44231:44232:37888:46011", -- [32]
			"44231:44232:37888:37915:44825:2226:46552", -- [33]
			"44231:44232:37888:43573:2851:47121:47133:47116", -- [34]
			"44231:44232:37888:43573:2851:47121:47133", -- [35]
			"44231:44232:37888:43573:2851:47121", -- [36]
			"44231:44232:37888:43573:2851:47121:47133:47156", -- [37]
			"44231:44232:37888:43573:2851:47121:47133:47156:47061", -- [38]
			"44231:44232:37888:43573:2851:47174", -- [39]
			"44231:44232:37888:2389:47644", -- [40]
			"44231:44232:37888:2389:47644:47655", -- [41]
			"44231:44232:37888:2389:47661", -- [42]
			"44231:44232:37888:37915:47665", -- [43]
			"44233:47875", -- [44]
			"12636:44407:2861:3305:47927", -- [45]
			"12636:44407:2861:13177:48321:48318", -- [46]
			"12636:44407:2861:13177:48321", -- [47]
			"44231:44232:37888:37915:44825:50463", -- [48]
			"12636:44407:2861:13177:43086:6026:85734", -- [49]
			--["name"] = "Eastwall Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 2644471905,
			["direct"] = "12636:44233:28621:44231",
			["f"] = 0,
		},
		[2861] = {
			"2851:2389:2226", -- [1]
			"2851:2389", -- [2]
			"44407:12636", -- [3]
			"2851:4314", -- [4]
			"44407:12636:16189:16192", -- [5]
			"44407:12636:16189", -- [6]
			"2851:43573:37888:44232:44233", -- [7]
			"44407:12636:44230:28621", -- [8]
			"44407:12636:44230", -- [9]
			"2851:43573:37888:44232", -- [10]
			"44407:12636:24851", -- [11]
			"44407:12636:24851:26560", -- [12]
			"2851:43573:37888", -- [13]
			"2851:43573:46004:37915", -- [14]
			"2851:43573:46004:37915:43124", -- [15]
			"1387:43053", -- [16]
			"1387:43052", -- [17]
			"13177:43086", -- [18]
			"2851:43104", -- [19]
			"2851:43573", -- [20]
			"44407:12636:16189:44036", -- [21]
			"2851:43573:37888:44232:44231", -- [22]
			"44407:12636:16189:16192:44244", -- [23]
			"2851:43573:46004:37915:44825", -- [24]
			"2851:43104:47661:47644:47655:46552:45479", -- [25]
			"2851:43573:46004", -- [26]
			"2851:43573:46004:46011", -- [27]
			"2851:43104:47661:47644:47655:46552", -- [28]
			"47121:47133:47116", -- [29]
			"47121:47133", -- [30]
			"47121:47133:47156", -- [31]
			"47174:47061", -- [32]
			"2851:43104:47661:47644", -- [33]
			"2851:43104:47661:47644:47655", -- [34]
			"2851:43104:47661", -- [35]
			"2851:2389:47665", -- [36]
			"2851:43573:46004:46011:47875", -- [37]
			"3305:47927", -- [38]
			"13177:48321:48318", -- [39]
			"13177:48321", -- [40]
			"2851:43573:46004:37915:44825:50463", -- [41]
			"13177:43086:6026:85734", -- [42]
			--["name"] = "New Kargath, Badlands",
			["m"] = 15,
			["f"] = 0,
			["direct"] = "4551:2851:2858:1387:6026:13177:3305:44408:44407:47121:47174",
			["coord"] = 740452012,
		},
		[44825] = {
			"2226:2389", -- [1]
			"2226:2389:2851", -- [2]
			"2226:2389:2851:2861:2858", -- [3]
			"2226:2389:2851:2861:1387", -- [4]
			"2226:2389:2851:2861", -- [5]
			"2226:2389:2851:2861:13177:43086:6026", -- [6]
			"37915:37888:12636", -- [7]
			"2226:2389:2851:2861:13177", -- [8]
			"2226:2389:2851:2861:3305", -- [9]
			"37915:46004:43573:4314", -- [10]
			"37915:37888:12636:16189:16192", -- [11]
			"37915:37888:12636:16189", -- [12]
			"37915:46004:46011:47875:44233", -- [13]
			"37915:37888:44232:28621", -- [14]
			"37915:37888:44232:44231:44230", -- [15]
			"37915:37888:44232", -- [16]
			"37915:37888:12636:24851", -- [17]
			"37915:37888:12636:24851:26560", -- [18]
			"37915:37888", -- [19]
			"2226:2389:2851:2861:1387:43053", -- [20]
			"2226:2389:2851:2861:1387:43052", -- [21]
			"2226:2389:2851:2861:13177:43086", -- [22]
			"2226:2389:43104", -- [23]
			"37915:46004:43573", -- [24]
			"37915:37888:12636:16189:44036", -- [25]
			"37915:37888:44232:44231", -- [26]
			"37915:37888:12636:16189:16192:44244", -- [27]
			"2226:2389:2851:2861:44408", -- [28]
			"2226:2389:2851:2861:44407", -- [29]
			"2226:46552:45479", -- [30]
			"37915:46004", -- [31]
			"37915:46004:46011", -- [32]
			"2226:46552", -- [33]
			"2226:2389:2851:47121:47133:47116", -- [34]
			"2226:2389:2851:47121:47133", -- [35]
			"2226:2389:2851:47121", -- [36]
			"2226:2389:2851:47121:47133:47156", -- [37]
			"2226:2389:2851:47121:47133:47156:47061", -- [38]
			"2226:2389:2851:47174", -- [39]
			"2226:46552:47655:47644", -- [40]
			"2226:46552:47655", -- [41]
			"2226:46552:47655:47644:47661", -- [42]
			"37915:47665", -- [43]
			"37915:46004:46011:47875", -- [44]
			"2226:2389:2851:2861:3305:47927", -- [45]
			"2226:2389:2851:2861:13177:48321:48318", -- [46]
			"2226:2389:2851:2861:13177:48321", -- [47]
			"2226:2389:2851:2861:13177:43086:6026:85734", -- [48]
			--["name"] = "Forsaken High Command, Silverpine Forest",
			["m"] = 21,
			["f"] = 0,
			["direct"] = "2226:4551:37915:43124:50463",
			["coord"] = 2486769270,
		},
		[47875] = {
			"46011:46004:37915:44825:2226", -- [1]
			"46011:46004:37915:4551", -- [2]
			"46011:37888:2389", -- [3]
			"46011:46004:43573:2851", -- [4]
			"46011:46004:43573:2851:2861:2858", -- [5]
			"46011:46004:43573:2851:2861:1387", -- [6]
			"46011:46004:43573:2851:2861", -- [7]
			"46011:46004:43573:2851:2861:13177:43086:6026", -- [8]
			"44233:44230:12636", -- [9]
			"46011:46004:43573:2851:2861:13177", -- [10]
			"46011:46004:43573:2851:2861:3305", -- [11]
			"46011:46004:43573:4314", -- [12]
			"44233:44230:12636:16189:16192", -- [13]
			"44233:44230:12636:16189", -- [14]
			"44233:28621", -- [15]
			"44233:44230", -- [16]
			"44233:44232", -- [17]
			"44233:44230:12636:24851", -- [18]
			"44233:44230:12636:24851:26560", -- [19]
			"46011:37888", -- [20]
			"46011:46004:37915", -- [21]
			"46011:46004:37915:43124", -- [22]
			"46011:46004:43573:2851:2861:1387:43053", -- [23]
			"46011:46004:43573:2851:2861:1387:43052", -- [24]
			"46011:46004:43573:2851:2861:13177:43086", -- [25]
			"46011:37888:2389:43104", -- [26]
			"46011:46004:43573", -- [27]
			"44233:44230:12636:16189:44036", -- [28]
			"44233:44231", -- [29]
			"44233:44230:12636:16189:16192:44244", -- [30]
			"44233:44230:12636:44407:44408", -- [31]
			"44233:44230:12636:44407", -- [32]
			"46011:46004:37915:44825", -- [33]
			"46011:46004:37915:44825:2226:46552:45479", -- [34]
			"46011:46004", -- [35]
			"46011:46004:37915:44825:2226:46552", -- [36]
			"46011:46004:43573:2851:47121:47133:47116", -- [37]
			"46011:46004:43573:2851:47121:47133", -- [38]
			"46011:46004:43573:2851:47121", -- [39]
			"46011:46004:43573:2851:47121:47133:47156", -- [40]
			"46011:46004:43573:2851:47121:47133:47156:47061", -- [41]
			"46011:46004:43573:2851:47174", -- [42]
			"46011:37888:2389:47644", -- [43]
			"46011:37888:2389:47644:47655", -- [44]
			"46011:37888:2389:47661", -- [45]
			"46011:46004:37915:47665", -- [46]
			"46011:46004:43573:2851:2861:3305:47927", -- [47]
			"46011:46004:43573:2851:2861:13177:48321:48318", -- [48]
			"46011:46004:43573:2851:2861:13177:48321", -- [49]
			"46011:46004:37915:44825:50463", -- [50]
			"46011:46004:43573:2851:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Hearthglen, Western Plaguelands",
			["m"] = 22,
			["coord"] = 1914908428,
			["direct"] = "44233:46011",
			["f"] = 0,
		},
		[43104] = {
			"2389:2226", -- [1]
			"2851:2861:2858", -- [2]
			"2851:2861:1387", -- [3]
			"2851:2861", -- [4]
			"2851:2861:13177:43086:6026", -- [5]
			"2389:37888:12636", -- [6]
			"2851:2861:13177", -- [7]
			"2851:2861:3305", -- [8]
			"2851:4314", -- [9]
			"2389:37888:12636:16189:16192", -- [10]
			"2389:37888:12636:16189", -- [11]
			"2389:37888:44232:44233", -- [12]
			"2389:37888:44232:28621", -- [13]
			"2389:37888:44232:44231:44230", -- [14]
			"2389:37888:44232", -- [15]
			"2389:37888:12636:24851", -- [16]
			"2389:37888:12636:24851:26560", -- [17]
			"2389:37888", -- [18]
			"2389:37915", -- [19]
			"2389:37915:43124", -- [20]
			"2851:2861:1387:43053", -- [21]
			"2851:2861:1387:43052", -- [22]
			"2851:2861:13177:43086", -- [23]
			"2851:43573", -- [24]
			"2389:37888:12636:16189:44036", -- [25]
			"2389:37888:44232:44231", -- [26]
			"2389:37888:12636:16189:16192:44244", -- [27]
			"2851:2861:44408", -- [28]
			"2851:2861:44407", -- [29]
			"2389:37915:44825", -- [30]
			"47661:47644:47655:46552:45479", -- [31]
			"2389:37915:46004", -- [32]
			"2389:37915:46004:46011", -- [33]
			"47661:47644:47655:46552", -- [34]
			"2851:47121:47133:47116", -- [35]
			"2851:47121:47133", -- [36]
			"2851:47121", -- [37]
			"2851:47121:47133:47156", -- [38]
			"2851:47121:47133:47156:47061", -- [39]
			"2851:47174", -- [40]
			"47661:47644", -- [41]
			"47661:47644:47655", -- [42]
			"2389:47665", -- [43]
			"2389:37915:46004:46011:47875", -- [44]
			"2851:2861:3305:47927", -- [45]
			"2851:2861:13177:48321:48318", -- [46]
			"2851:2861:13177:48321", -- [47]
			"2389:2226:50463", -- [48]
			"2851:2861:13177:43086:6026:85734", -- [49]
			--["name"] = "Galen's Fall, Arathi",
			["m"] = 14,
			["f"] = 0,
			["direct"] = "4551:2389:2851:47661",
			["coord"] = 566516098,
		},
		[2389] = {
			"2851:2861:2858", -- [1]
			"2851:2861:1387", -- [2]
			"2851:2861", -- [3]
			"2851:2861:13177:43086:6026", -- [4]
			"37888:12636", -- [5]
			"2851:2861:13177", -- [6]
			"2851:2861:3305", -- [7]
			"37888:12636:16189:16192", -- [8]
			"37888:12636:16189", -- [9]
			"37888:44232:44233", -- [10]
			"37888:44232:28621", -- [11]
			"37888:44232:44231:44230", -- [12]
			"37888:44232", -- [13]
			"37888:12636:24851", -- [14]
			"37888:12636:24851:26560", -- [15]
			"37915:43124", -- [16]
			"2851:2861:1387:43053", -- [17]
			"2851:2861:1387:43052", -- [18]
			"2851:2861:13177:43086", -- [19]
			"37888:12636:16189:44036", -- [20]
			"37888:44232:44231", -- [21]
			"37888:12636:16189:16192:44244", -- [22]
			"2851:2861:44408", -- [23]
			"2851:2861:44407", -- [24]
			"37915:44825", -- [25]
			"47644:47655:46552:45479", -- [26]
			"37915:46004", -- [27]
			"37915:46004:46011", -- [28]
			"47644:47655:46552", -- [29]
			"2851:47121:47133:47116", -- [30]
			"2851:47121:47133", -- [31]
			"2851:47121", -- [32]
			"2851:47121:47133:47156", -- [33]
			"2851:47121:47133:47156:47061", -- [34]
			"2851:47174", -- [35]
			"47644:47655", -- [36]
			"37915:46004:46011:47875", -- [37]
			"2851:2861:3305:47927", -- [38]
			"2851:2861:13177:48321:48318", -- [39]
			"2851:2861:13177:48321", -- [40]
			"2226:50463", -- [41]
			"2851:2861:13177:43086:6026:85734", -- [42]
			--["name"] = "Tarren Mill, Hillsbrad",
			["m"] = 25,
			["coord"] = 2406250079,
			["direct"] = "2226:4551:2851:4314:37888:37915:43104:43573:47644:47661:47665",
			["f"] = 0,
		},
		[47644] = {
			"47655:46552:2226", -- [1]
			"2389:4551", -- [2]
			"47661:43104:2851", -- [3]
			"47661:43104:2851:2861:2858", -- [4]
			"47661:43104:2851:2861:1387", -- [5]
			"47661:43104:2851:2861", -- [6]
			"47661:43104:2851:2861:13177:43086:6026", -- [7]
			"2389:37888:12636", -- [8]
			"47661:43104:2851:2861:13177", -- [9]
			"47661:43104:2851:2861:3305", -- [10]
			"2389:4314", -- [11]
			"2389:37888:12636:16189:16192", -- [12]
			"2389:37888:12636:16189", -- [13]
			"2389:37888:44232:44233", -- [14]
			"2389:37888:44232:28621", -- [15]
			"2389:37888:44232:44231:44230", -- [16]
			"2389:37888:44232", -- [17]
			"2389:37888:12636:24851", -- [18]
			"2389:37888:12636:24851:26560", -- [19]
			"2389:37888", -- [20]
			"2389:37915", -- [21]
			"2389:37915:43124", -- [22]
			"47661:43104:2851:2861:1387:43053", -- [23]
			"47661:43104:2851:2861:1387:43052", -- [24]
			"47661:43104:2851:2861:13177:43086", -- [25]
			"47661:43104", -- [26]
			"2389:43573", -- [27]
			"2389:37888:12636:16189:44036", -- [28]
			"2389:37888:44232:44231", -- [29]
			"2389:37888:12636:16189:16192:44244", -- [30]
			"47661:43104:2851:2861:44408", -- [31]
			"47661:43104:2851:2861:44407", -- [32]
			"2389:37915:44825", -- [33]
			"47655:46552:45479", -- [34]
			"2389:37915:46004", -- [35]
			"2389:37915:46004:46011", -- [36]
			"47655:46552", -- [37]
			"47661:43104:2851:47121:47133:47116", -- [38]
			"47661:43104:2851:47121:47133", -- [39]
			"47661:43104:2851:47121", -- [40]
			"47661:43104:2851:47121:47133:47156", -- [41]
			"47661:43104:2851:47121:47133:47156:47061", -- [42]
			"47661:43104:2851:47174", -- [43]
			"2389:47665", -- [44]
			"2389:37915:46004:46011:47875", -- [45]
			"47661:43104:2851:2861:3305:47927", -- [46]
			"47661:43104:2851:2861:13177:48321:48318", -- [47]
			"47661:43104:2851:2861:13177:48321", -- [48]
			"47655:46552:2226:50463", -- [49]
			"47661:43104:2851:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Ruins of Southshore, Hillsbrad",
			["m"] = 25,
			["f"] = 0,
			["direct"] = "2389:47655:47661",
			["coord"] = 2107943229,
		},
		[44244] = {
			"16192:16189:12636:37888:37915:44825:2226", -- [1]
			"16192:16189:12636:37888:4551", -- [2]
			"16192:16189:12636:37888:2389", -- [3]
			"16192:16189:12636:4314:2851", -- [4]
			"16192:16189:12636:44407:2861:2858", -- [5]
			"16192:16189:12636:44407:2861:1387", -- [6]
			"16192:16189:12636:44407:2861", -- [7]
			"16192:16189:12636:44407:2861:13177:43086:6026", -- [8]
			"16192:16189:12636", -- [9]
			"16192:16189:12636:44407:2861:13177", -- [10]
			"16192:16189:12636:44407:2861:3305", -- [11]
			"16192:16189:12636:4314", -- [12]
			"16192:16189", -- [13]
			"16192:16189:12636:44230:44233", -- [14]
			"16192:16189:12636:44230:28621", -- [15]
			"16192:16189:12636:44230", -- [16]
			"16192:16189:12636:44231:44232", -- [17]
			"16192:16189:24851", -- [18]
			"16192:26560", -- [19]
			"16192:16189:12636:37888", -- [20]
			"16192:16189:12636:37888:37915", -- [21]
			"16192:16189:12636:37888:37915:43124", -- [22]
			"16192:16189:12636:44407:2861:1387:43053", -- [23]
			"16192:16189:12636:44407:2861:1387:43052", -- [24]
			"16192:16189:12636:44407:2861:13177:43086", -- [25]
			"16192:16189:12636:37888:2389:43104", -- [26]
			"16192:16189:12636:37888:43573", -- [27]
			"16192:44036", -- [28]
			"16192:16189:12636:44231", -- [29]
			"16192:16189:12636:44407:44408", -- [30]
			"16192:16189:12636:44407", -- [31]
			"16192:16189:12636:37888:37915:44825", -- [32]
			"16192:16189:12636:37888:37915:44825:2226:46552:45479", -- [33]
			"16192:16189:12636:37888:46011:46004", -- [34]
			"16192:16189:12636:37888:46011", -- [35]
			"16192:16189:12636:37888:37915:44825:2226:46552", -- [36]
			"16192:16189:12636:4314:2851:47121:47133:47116", -- [37]
			"16192:16189:12636:4314:2851:47121:47133", -- [38]
			"16192:16189:12636:4314:2851:47121", -- [39]
			"16192:16189:12636:4314:2851:47121:47133:47156", -- [40]
			"16192:16189:12636:4314:2851:47121:47133:47156:47061", -- [41]
			"16192:16189:12636:4314:2851:47174", -- [42]
			"16192:16189:12636:37888:2389:47644", -- [43]
			"16192:16189:12636:37888:2389:47644:47655", -- [44]
			"16192:16189:12636:37888:2389:47661", -- [45]
			"16192:16189:12636:37888:37915:47665", -- [46]
			"16192:16189:12636:44230:44233:47875", -- [47]
			"16192:16189:12636:44407:2861:3305:47927", -- [48]
			"16192:16189:12636:44407:2861:13177:48321:48318", -- [49]
			"16192:16189:12636:44407:2861:13177:48321", -- [50]
			"16192:16189:12636:37888:37915:44825:50463", -- [51]
			"16192:16189:12636:44407:2861:13177:43086:6026:85734", -- [52]
			--["name"] = "Falconwing Square, Eversong Woods",
			["m"] = 94,
			["coord"] = 1987999758,
			["direct"] = "16192",
			["f"] = 0,
		},
		[47174] = {
			"2851:2389:2226", -- [1]
			"2851:43573:46004:37915:4551", -- [2]
			"2851:2389", -- [3]
			"2861:2858", -- [4]
			"2861:1387", -- [5]
			"2861:13177:43086:6026", -- [6]
			"2851:43573:37888:12636", -- [7]
			"2861:13177", -- [8]
			"2861:3305", -- [9]
			"2851:4314", -- [10]
			"2851:43573:37888:12636:16189:16192", -- [11]
			"2851:43573:37888:12636:16189", -- [12]
			"2851:43573:37888:44232:44233", -- [13]
			"2851:43573:37888:44232:28621", -- [14]
			"2851:43573:37888:44232:44231:44230", -- [15]
			"2851:43573:37888:44232", -- [16]
			"2851:43573:37888:12636:24851", -- [17]
			"2851:43573:37888:12636:24851:26560", -- [18]
			"2851:43573:37888", -- [19]
			"2851:43573:46004:37915", -- [20]
			"2851:43573:46004:37915:43124", -- [21]
			"2861:1387:43053", -- [22]
			"2861:1387:43052", -- [23]
			"2861:13177:43086", -- [24]
			"2851:43104", -- [25]
			"2851:43573", -- [26]
			"2851:43573:37888:12636:16189:44036", -- [27]
			"2851:43573:37888:44232:44231", -- [28]
			"2851:43573:37888:12636:16189:16192:44244", -- [29]
			"2861:44408", -- [30]
			"2861:44407", -- [31]
			"2851:43573:46004:37915:44825", -- [32]
			"2851:43104:47661:47644:47655:46552:45479", -- [33]
			"2851:43573:46004", -- [34]
			"2851:43573:46004:46011", -- [35]
			"2851:43104:47661:47644:47655:46552", -- [36]
			"47156:47133", -- [37]
			"47156:47133:47121", -- [38]
			"2851:43104:47661:47644", -- [39]
			"2851:43104:47661:47644:47655", -- [40]
			"2851:43104:47661", -- [41]
			"2851:2389:47665", -- [42]
			"2851:43573:46004:46011:47875", -- [43]
			"2861:3305:47927", -- [44]
			"2861:13177:48321:48318", -- [45]
			"2861:13177:48321", -- [46]
			"2851:43573:46004:37915:44825:50463", -- [47]
			"2861:13177:43086:6026:85734", -- [48]
			--["name"] = "Dragonmaw Port, Twilight Highlands",
			["m"] = 241,
			["f"] = 0,
			["direct"] = "2851:2861:47116:47156:47061",
			["coord"] = 3171256117,
		},
	}, -- [2]
	[1467] = {
		[22455] = {
			"20762:18942:16587", -- [1]
			"20762:18942", -- [2]
			"20762:18791", -- [3]
			"20762:18940:18808", -- [4]
			"20762:18940:18807:19317", -- [5]
			"20762:18940:18807", -- [6]
			"20762:18940", -- [7]
			"20762:18942:16587:18930", -- [8]
			"18938:19583", -- [9]
			"20762:18940:18807:19317:19581", -- [10]
			"20762:18942:16587:19558", -- [11]
			"18938:20515", -- [12]
			"18953:22216", -- [13]
			["direct"] = "18938:18953:20762",
			["f"] = 0,
			["m"] = 105,
			["coord"] = 3279595658,
		},
		[18953] = {
			"20762:18942:16587", -- [1]
			"20762:18942", -- [2]
			"18791:18808", -- [3]
			"20762:18940:18807:19317", -- [4]
			"20762:18940:18807", -- [5]
			"20762:18940", -- [6]
			"20762:18942:16587:18930", -- [7]
			"20762:18940:18807:19317:19581", -- [8]
			"20762:18942:16587:19558", -- [9]
			"18938:20515", -- [10]
			["direct"] = "18791:18938:19583:20762:22216:22455",
			["coord"] = 2236451551,
			["m"] = 105,
			["f"] = 0,
		},
		[19558] = {
			"16587:18942", -- [1]
			"16587:18942:18791", -- [2]
			"16587:18942:18808", -- [3]
			"16587:18942:20762:22455:18938", -- [4]
			"16587:18807:19317", -- [5]
			"16587:18942:20762:18953", -- [6]
			"16587:18807", -- [7]
			"16587:18940", -- [8]
			"16587:18930", -- [9]
			"16587:18942:20762:22455:18938:19583", -- [10]
			"16587:18807:19317:19581", -- [11]
			"16587:18942:20762:22455:18938:20515", -- [12]
			"16587:18942:20762", -- [13]
			"16587:18942:20762:18953:22216", -- [14]
			"16587:18942:20762:22455", -- [15]
			["direct"] = "16587",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 2645348352,
		},
		[18940] = {
			"20762:22455:18938", -- [1]
			"18807:19317", -- [2]
			"20762:18953", -- [3]
			"16587:18930", -- [4]
			"20762:22455:18938:19583", -- [5]
			"18807:19317:19581", -- [6]
			"16587:19558", -- [7]
			"20762:22455:18938:20515", -- [8]
			"20762:18953:22216", -- [9]
			"20762:22455", -- [10]
			["direct"] = "16587:18942:18791:18808:18807:20762",
			["f"] = 0,
			["m"] = 111,
			["coord"] = 2745330149,
		},
		[18942] = {
			"20762:22455:18938", -- [1]
			"18940:18807:19317", -- [2]
			"20762:18953", -- [3]
			"18940:18807", -- [4]
			"16587:18930", -- [5]
			"20762:22455:18938:19583", -- [6]
			"18940:18807:19317:19581", -- [7]
			"16587:19558", -- [8]
			"20762:22455:18938:20515", -- [9]
			"20762:18953:22216", -- [10]
			"20762:22455", -- [11]
			["direct"] = "16587:18791:18808:18940:20762",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 1196333511,
		},
		[16587] = {
			"18942:18791", -- [1]
			"18942:18808", -- [2]
			"18942:20762:22455:18938", -- [3]
			"18807:19317", -- [4]
			"18942:20762:18953", -- [5]
			"18942:20762:22455:18938:19583", -- [6]
			"18807:19317:19581", -- [7]
			"18942:20762:22455:18938:20515", -- [8]
			"18942:20762", -- [9]
			"18942:20762:18953:22216", -- [10]
			"18942:20762:22455", -- [11]
			["direct"] = "18942:18807:18940:18930:19558",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 2416663840,
		},
		[19317] = {
			"18807:16587", -- [1]
			"18807:18940:18942", -- [2]
			"18807:18940:18791", -- [3]
			"18807:18940:18808", -- [4]
			"18807:18940:20762:22455:18938", -- [5]
			"18807:18940:20762:18953", -- [6]
			"18807:18940", -- [7]
			"18807:16587:18930", -- [8]
			"18807:18940:20762:22455:18938:19583", -- [9]
			"18807:16587:19558", -- [10]
			"18807:18940:20762:22455:18938:20515", -- [11]
			"18807:18940:20762", -- [12]
			"18807:18940:20762:18953:22216", -- [13]
			"18807:18940:20762:22455", -- [14]
			["direct"] = "18807:19581",
			["f"] = 0,
			["m"] = 104,
			["coord"] = 1302481601,
		},
		[19581] = {
			"19317:18807:16587", -- [1]
			"19317:18807:18940:18942", -- [2]
			"19317:18807:18940:18791", -- [3]
			"19317:18807:18940:18808", -- [4]
			"19317:18807:18940:20762:22455:18938", -- [5]
			"19317:18807:18940:20762:18953", -- [6]
			"19317:18807", -- [7]
			"19317:18807:18940", -- [8]
			"19317:18807:16587:18930", -- [9]
			"19317:18807:18940:20762:22455:18938:19583", -- [10]
			"19317:18807:16587:19558", -- [11]
			"19317:18807:18940:20762:22455:18938:20515", -- [12]
			"19317:18807:18940:20762", -- [13]
			"19317:18807:18940:20762:18953:22216", -- [14]
			"19317:18807:18940:20762:22455", -- [15]
			["direct"] = "19317",
			["f"] = 0,
			["m"] = 104,
			["coord"] = 2717011449,
		},
		[18791] = {
			"18942:16587", -- [1]
			"18953:18938", -- [2]
			"18940:18807:19317", -- [3]
			"18940:18807", -- [4]
			"18942:16587:18930", -- [5]
			"18953:18938:19583", -- [6]
			"18940:18807:19317:19581", -- [7]
			"18942:16587:19558", -- [8]
			"18953:18938:20515", -- [9]
			"18953:22216", -- [10]
			"18953:22455", -- [11]
			["direct"] = "18942:18808:18953:18940:20762",
			["f"] = 0,
			["m"] = 102,
			["coord"] = 1417380620,
		},
		[18807] = {
			"18940:18942", -- [1]
			"18940:18791", -- [2]
			"18940:18808", -- [3]
			"18940:20762:22455:18938", -- [4]
			"18940:20762:18953", -- [5]
			"16587:18930", -- [6]
			"18940:20762:22455:18938:19583", -- [7]
			"19317:19581", -- [8]
			"16587:19558", -- [9]
			"18940:20762:22455:18938:20515", -- [10]
			"18940:20762", -- [11]
			"18940:20762:18953:22216", -- [12]
			"18940:20762:22455", -- [13]
			["direct"] = "16587:19317:18940",
			["f"] = 0,
			["m"] = 108,
			["coord"] = 2115268468,
		},
		[18938] = {
			"22455:20762:18942:16587", -- [1]
			"22455:20762:18942", -- [2]
			"22455:20762:18791", -- [3]
			"22455:20762:18940:18808", -- [4]
			"22455:20762:18940:18807:19317", -- [5]
			"22455:20762:18940:18807", -- [6]
			"22455:20762:18940", -- [7]
			"22455:20762:18942:16587:18930", -- [8]
			"22455:20762:18940:18807:19317:19581", -- [9]
			"22455:20762:18942:16587:19558", -- [10]
			"22455:20762", -- [11]
			["direct"] = "18953:19583:20515:22216:22455",
			["f"] = 0,
			["m"] = 109,
			["coord"] = 1451533221,
		},
		[18808] = {
			"18942:16587", -- [1]
			"18791:18953:18938", -- [2]
			"18940:18807:19317", -- [3]
			"18791:18953", -- [4]
			"18940:18807", -- [5]
			"18942:16587:18930", -- [6]
			"18791:18953:18938:19583", -- [7]
			"18940:18807:19317:19581", -- [8]
			"18942:16587:19558", -- [9]
			"18791:18953:18938:20515", -- [10]
			"18940:20762", -- [11]
			"18791:18953:22216", -- [12]
			"18940:20762:22455", -- [13]
			["direct"] = "18942:18791:18940",
			["f"] = 0,
			["m"] = 107,
			["coord"] = 2458409611,
		},
		[18930] = {
			"18942:18791", -- [1]
			"18942:18808", -- [2]
			"18942:20762:22455:18938", -- [3]
			"16587:18807:19317", -- [4]
			"18942:20762:18953", -- [5]
			"16587:18807", -- [6]
			"16587:18940", -- [7]
			"18942:20762:22455:18938:19583", -- [8]
			"16587:18807:19317:19581", -- [9]
			"16587:19558", -- [10]
			"18942:20762:22455:18938:20515", -- [11]
			"18942:20762", -- [12]
			"18942:20762:18953:22216", -- [13]
			"18942:20762:22455", -- [14]
			["direct"] = "16587:18942",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 3752950617,
		},
		[20762] = {
			"18942:16587", -- [1]
			"18940:18808", -- [2]
			"22455:18938", -- [3]
			"18940:18807:19317", -- [4]
			"18940:18807", -- [5]
			"18942:16587:18930", -- [6]
			"22455:18938:19583", -- [7]
			"18940:18807:19317:19581", -- [8]
			"18942:16587:19558", -- [9]
			"22455:18938:20515", -- [10]
			"18953:22216", -- [11]
			["direct"] = "18942:18791:18953:18940:22455",
			["f"] = 0,
			["m"] = 102,
			["coord"] = 3639643342,
		},
		[19583] = {
			"18938:22455:20762:18942:16587", -- [1]
			"18938:22455:20762:18942", -- [2]
			"18953:18791", -- [3]
			"18938:22455:20762:18940:18808", -- [4]
			"18938:22455:20762:18940:18807:19317", -- [5]
			"18938:22455:20762:18940:18807", -- [6]
			"18938:22455:20762:18940", -- [7]
			"18938:22455:20762:18942:16587:18930", -- [8]
			"18938:22455:20762:18940:18807:19317:19581", -- [9]
			"18938:22455:20762:18942:16587:19558", -- [10]
			"18938:22455:20762", -- [11]
			"18938:22216", -- [12]
			"18938:22455", -- [13]
			["direct"] = "18938:18953:20515",
			["f"] = 0,
			["m"] = 109,
			["coord"] = 1944213875,
		},
		[20515] = {
			"18938:22455:20762:18942:16587", -- [1]
			"18938:22455:20762:18942", -- [2]
			"18938:22455:20762:18791", -- [3]
			"18938:22455:20762:18940:18808", -- [4]
			"18938:22455:20762:18940:18807:19317", -- [5]
			"18938:18953", -- [6]
			"18938:22455:20762:18940:18807", -- [7]
			"18938:22455:20762:18940", -- [8]
			"18938:22455:20762:18942:16587:18930", -- [9]
			"18938:22455:20762:18940:18807:19317:19581", -- [10]
			"18938:22455:20762:18942:16587:19558", -- [11]
			"18938:22455:20762", -- [12]
			"18938:22216", -- [13]
			"18938:22455", -- [14]
			["direct"] = "18938:19583",
			["f"] = 0,
			["m"] = 109,
			["coord"] = 2800462568,
		},
		[22216] = {
			"18953:20762:18942:16587", -- [1]
			"18953:20762:18942", -- [2]
			"18953:18791", -- [3]
			"18953:18791:18808", -- [4]
			"18953:20762:18940:18807:19317", -- [5]
			"18953:20762:18940:18807", -- [6]
			"18953:20762:18940", -- [7]
			"18953:20762:18942:16587:18930", -- [8]
			"18938:19583", -- [9]
			"18953:20762:18940:18807:19317:19581", -- [10]
			"18953:20762:18942:16587:19558", -- [11]
			"18938:20515", -- [12]
			"18953:20762", -- [13]
			"18953:22455", -- [14]
			["direct"] = "18938:18953",
			["coord"] = 2648008034,
			["m"] = 105,
			["f"] = 0,
		},
	}, -- [3]
	[4] = {
		[26852] = {
			"26844:24155", -- [1]
			"24032:27344", -- [2]
			"26845:26851:26566:26847:24795:27046", -- [3]
			"26845:26851", -- [4]
			"26845:26851:26566", -- [5]
			"26845:28196:28195:25288", -- [6]
			"26845:26851:26566:26847", -- [7]
			"26845:26851:26566:26847:26848", -- [8]
			"26845:26851:26850", -- [9]
			"26845:26851:26566:26847:24795", -- [10]
			"26845:28196", -- [11]
			"26844:28197", -- [12]
			"26845:28196:28195", -- [13]
			"28618:28623", -- [14]
			"28618:28615", -- [15]
			"28618:28623:28624", -- [16]
			"28618:28615:28674:28574", -- [17]
			"28618:28615:28674", -- [18]
			"28618:28615:29721", -- [19]
			"28618:28623:28624:32571", -- [20]
			"28618:28615:29721:29757", -- [21]
			"28618:28615:29721:29762", -- [22]
			"28618:28615:28674:31069:31078", -- [23]
			"28618:28615:29721:29757:29951", -- [24]
			"28618:28615:29721:29757:29950", -- [25]
			"28618:28623:28624:30569", -- [26]
			"26845:26851:26566:30870", -- [27]
			"28618:28615:28674:31069:30314", -- [28]
			"28618:28615:28674:30433", -- [29]
			"28618:28615:28674:31069", -- [30]
			"28618:28615:30269", -- [31]
			"28618:28615:28674:33849", -- [32]
			"28618:28615:28674:28574:28037", -- [33]
			["m"] = 116,
			["coord"] = 942974243,
			["direct"] = "24032:26844:26853:26845:28618",
			["f"] = 0,
		},
		[26853] = {
			"24032:24155", -- [1]
			"28618:28615:26850:26566:26847:24795:27046", -- [2]
			"24032:26844", -- [3]
			"28618:28615:26851", -- [4]
			"26852:26845", -- [5]
			"28618:28615:26850:26566", -- [6]
			"28618:28615:28674:25288", -- [7]
			"28618:28615:26850:26566:26847", -- [8]
			"28618:28615:28674:28574:26848", -- [9]
			"28618:28615:26850", -- [10]
			"28618:28615:26850:26566:26847:24795", -- [11]
			"26852:26845:28196", -- [12]
			"24032:26844:28197", -- [13]
			"26852:26845:28196:28195", -- [14]
			"28618:28615", -- [15]
			"28618:28615:28674:28574", -- [16]
			"28618:28615:28674", -- [17]
			"28618:28615:29721", -- [18]
			"28624:32571", -- [19]
			"28618:28615:29721:29757", -- [20]
			"28624:29762", -- [21]
			"28618:28615:28674:31069:31078", -- [22]
			"28624:29951", -- [23]
			"28618:28615:29721:29757:29950", -- [24]
			"28624:30569", -- [25]
			"28618:28615:28674:30870", -- [26]
			"28618:28615:28674:31069:30314", -- [27]
			"28618:28615:28674:30433", -- [28]
			"28618:28615:28674:31069", -- [29]
			"28618:28615:30269", -- [30]
			"28618:28615:28674:33849", -- [31]
			"28618:28615:28674:28574:28037", -- [32]
			["m"] = 116,
			["coord"] = 2789373946,
			["direct"] = "27344:24032:26852:28623:28618:28624",
			["f"] = 0,
		},
		[28618] = {
			"26852:26844:24155", -- [1]
			"26853:27344", -- [2]
			"26853:24032", -- [3]
			"28615:26850:26566:26847:24795:27046", -- [4]
			"26852:26844", -- [5]
			"28615:26851", -- [6]
			"28615:26850:26566", -- [7]
			"28615:28674:25288", -- [8]
			"28615:26850:26566:26847", -- [9]
			"28615:28674:28574:26848", -- [10]
			"28615:26850", -- [11]
			"28615:26850:26566:26847:24795", -- [12]
			"28615:26851:28196", -- [13]
			"26852:26844:28197", -- [14]
			"28615:26851:28196:28195", -- [15]
			"28623:28624", -- [16]
			"28615:28674:28574", -- [17]
			"28615:28674", -- [18]
			"28615:29721", -- [19]
			"28623:28624:32571", -- [20]
			"28615:29721:29757", -- [21]
			"28615:29721:29762", -- [22]
			"28615:28674:31069:31078", -- [23]
			"28615:29721:29757:29951", -- [24]
			"28615:29721:29757:29950", -- [25]
			"28623:28624:30569", -- [26]
			"28615:28674:30870", -- [27]
			"28615:28674:31069:30314", -- [28]
			"28615:28674:30433", -- [29]
			"28615:28674:31069", -- [30]
			"28615:30269", -- [31]
			"28615:28674:33849", -- [32]
			"28615:28674:28574:28037", -- [33]
			["m"] = 121,
			["f"] = 0,
			["direct"] = "26853:26852:26845:28623:28615",
			["coord"] = 1381678745,
		},
		[31078] = {
			"30870:26566:26845:24155", -- [1]
			"30870:26566:26845:26852:24032:27344", -- [2]
			"30870:26566:26845:26852:24032", -- [3]
			"28574:26848:24795:27046", -- [4]
			"30870:26566:26845:26844", -- [5]
			"30870:26566:26845:26852:26853", -- [6]
			"30870:26566:26845:26852", -- [7]
			"30870:26566:26851", -- [8]
			"30870:26566:26845", -- [9]
			"30870:26566", -- [10]
			"28574:26848:25288", -- [11]
			"30870:26847", -- [12]
			"28574:26848", -- [13]
			"30870:26566:26850", -- [14]
			"28574:26848:24795", -- [15]
			"30870:26566:28196", -- [16]
			"30870:26566:26845:26844:28197", -- [17]
			"30870:26847:28195", -- [18]
			"31069:30433:28674:28615:28623", -- [19]
			"31069:30433:28674:28615", -- [20]
			"31069:30433:28674:28615:28618", -- [21]
			"30314:29950:29951:28624", -- [22]
			"31069:30433:28674", -- [23]
			"31069:30433:28674:29721", -- [24]
			"30314:29950:29951:32571", -- [25]
			"30314:29950:29757", -- [26]
			"30314:29950:29951:29762", -- [27]
			"30314:29950:29951", -- [28]
			"30314:29950", -- [29]
			"30314:29950:29951:28624:30569", -- [30]
			"31069:30433", -- [31]
			"31069:30433:28674:30269", -- [32]
			"30314:33849", -- [33]
			"28037:26848:24795:27046", -- [34]
			"28037:26848:25288", -- [35]
			"28037:26848", -- [36]
			"28037:26848:24795", -- [37]
			["direct"] = "28574:28037:30870:30314:31069",
			["f"] = 0,
			["m"] = 118,
			["coord"] = 831814222,
		},
		[28623] = {
			"26853:24032:24155", -- [1]
			"26853:27344", -- [2]
			"26853:24032", -- [3]
			"28615:26850:26566:26847:24795:27046", -- [4]
			"28618:26852:26844", -- [5]
			"28618:26852", -- [6]
			"28615:26851", -- [7]
			"28618:26845", -- [8]
			"28615:26850:26566", -- [9]
			"28615:28674:25288", -- [10]
			"28615:26850:26566:26847", -- [11]
			"28615:28674:28574:26848", -- [12]
			"28615:26850", -- [13]
			"28615:26850:26566:26847:24795", -- [14]
			"28615:26851:28196", -- [15]
			"28618:26852:26844:28197", -- [16]
			"28615:26851:28196:28195", -- [17]
			"28615:28674:28574", -- [18]
			"28615:28674", -- [19]
			"28615:29721", -- [20]
			"28624:32571", -- [21]
			"28615:29721:29757", -- [22]
			"28624:29762", -- [23]
			"28615:28674:31069:31078", -- [24]
			"28624:29951", -- [25]
			"28615:29721:29757:29950", -- [26]
			"28624:30569", -- [27]
			"28615:28674:30870", -- [28]
			"28615:28674:31069:30314", -- [29]
			"28615:28674:30433", -- [30]
			"28615:28674:31069", -- [31]
			"28615:30269", -- [32]
			"28615:28674:33849", -- [33]
			"28615:28674:28574:28037", -- [34]
			["direct"] = "26853:28615:28618:28624",
			["f"] = 0,
			["m"] = 121,
			["coord"] = 1782293786,
		},
		[28624] = {
			"26853:24032:24155", -- [1]
			"26853:27344", -- [2]
			"26853:24032", -- [3]
			"28623:28615:26850:26566:26847:24795:27046", -- [4]
			"26853:24032:26844", -- [5]
			"28623:28618:26852", -- [6]
			"28623:28615:26851", -- [7]
			"28623:28618:26845", -- [8]
			"28623:28615:26850:26566", -- [9]
			"28623:28615:28674:25288", -- [10]
			"28623:28615:26850:26566:26847", -- [11]
			"28623:28615:28674:28574:26848", -- [12]
			"28623:28615:26850", -- [13]
			"28623:28615:26850:26566:26847:24795", -- [14]
			"28623:28615:26851:28196", -- [15]
			"26853:24032:26844:28197", -- [16]
			"28623:28615:26851:28196:28195", -- [17]
			"28623:28615", -- [18]
			"28623:28618", -- [19]
			"28623:28615:28674:28574", -- [20]
			"28623:28615:28674", -- [21]
			"28623:28615:29721", -- [22]
			"29762:29757", -- [23]
			"28623:28615:28674:31069:31078", -- [24]
			"29951:29950", -- [25]
			"28623:28615:28674:30870", -- [26]
			"29951:29950:30314", -- [27]
			"28623:28615:28674:30433", -- [28]
			"28623:28615:28674:31069", -- [29]
			"28623:28615:30269", -- [30]
			"29951:29950:33849", -- [31]
			"28623:28615:28674:28574:28037", -- [32]
			["m"] = 121,

			["f"] = 0,
			["direct"] = "26853:28623:32571:29762:29951:30569",
			["coord"] = 2575864175,
		},
		[25288] = {
			"26847:26566:26845:24155", -- [1]
			"26847:26566:26845:26852:24032:27344", -- [2]
			"26847:26566:26845:26852:24032", -- [3]
			"24795:27046", -- [4]
			"26847:26566:26845:26844", -- [5]
			"26847:26566:26845:26852:26853", -- [6]
			"26847:26566:26845:26852", -- [7]
			"26847:26566:26851", -- [8]
			"26847:26566:26845", -- [9]
			"26847:26566", -- [10]
			"26847:26566:26850", -- [11]
			"28195:28196", -- [12]
			"28195:28196:28197", -- [13]
			"26847:26566:26851:28615:28623", -- [14]
			"26847:26566:26851:28615", -- [15]
			"26847:26566:26845:28618", -- [16]
			"26847:26566:26851:28615:28623:28624", -- [17]
			"26848:28574", -- [18]
			"28674:29721", -- [19]
			"28674:29721:32571", -- [20]
			"28674:29721:29757", -- [21]
			"28674:29721:29762", -- [22]
			"26848:28574:31078", -- [23]
			"28674:29721:29757:29951", -- [24]
			"26848:28574:31078:30314:29950", -- [25]
			"26847:26566:26851:28615:28623:28624:30569", -- [26]
			"26847:30870", -- [27]
			"26848:28574:31078:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"28674:30269", -- [31]
			"26848:28574:31078:30314:33849", -- [32]
			"26848:28037", -- [33]
			"26848:28037:31078", -- [34]
			"26848:28037:31078:30314:29950", -- [35]
			"26848:28037:31078:30314", -- [36]
			"26848:28037:31078:30314:33849", -- [37]
			["m"] = 114,
			["f"] = 0,
			["direct"] = "26847:26848:24795:28195:28674",
			["coord"] = 1731232670,
		},
		[24155] = {
			"28197:28196:28195:26847:24795:27046", -- [1]
			"24032:26853", -- [2]
			"26844:26852", -- [3]
			"26845:26851", -- [4]
			"26845:26851:26566", -- [5]
			"28197:28196:28195:25288", -- [6]
			"28197:28196:28195:26847", -- [7]
			"28197:28196:28195:26847:26848", -- [8]
			"26845:26851:26850", -- [9]
			"28197:28196:28195:26847:24795", -- [10]
			"28197:28196", -- [11]
			"28197:28196:28195", -- [12]
			"24032:26853:28623", -- [13]
			"26844:26852:28618:28615", -- [14]
			"26844:26852:28618", -- [15]
			"24032:26853:28624", -- [16]
			"26845:26851:26566:30870:28574", -- [17]
			"26844:26852:28618:28615:28674", -- [18]
			"26844:26852:28618:28615:29721", -- [19]
			"24032:26853:28624:32571", -- [20]
			"26844:26852:28618:28615:29721:29757", -- [21]
			"24032:26853:28624:29762", -- [22]
			"26844:26852:28618:28615:28674:31069:31078", -- [23]
			"24032:26853:28624:29951", -- [24]
			"26844:26852:28618:28615:29721:29757:29950", -- [25]
			"24032:26853:28624:30569", -- [26]
			"26845:26851:26566:30870", -- [27]
			"26844:26852:28618:28615:28674:31069:30314", -- [28]
			"26844:26852:28618:28615:28674:30433", -- [29]
			"26844:26852:28618:28615:28674:31069", -- [30]
			"26844:26852:28618:28615:30269", -- [31]
			"26844:26852:28618:28615:28674:33849", -- [32]
			"28197:28196:28195:26847:26848:28037", -- [33]
			["m"] = 117,
			["coord"] = 2235214962,
			["direct"] = "27344:24032:26844:26845:28197",
			["f"] = 0,
		},
		[24032] = {
			"26844:26845:26851:26566:26847:24795:27046", -- [1]
			"26844:26845:26851", -- [2]
			"26844:26845", -- [3]
			"26844:26845:26851:26566", -- [4]
			"26844:26845:28196:28195:25288", -- [5]
			"26844:26845:26851:26566:26847", -- [6]
			"26844:26845:26851:26566:26847:26848", -- [7]
			"26844:26845:26851:26850", -- [8]
			"26844:26845:26851:26566:26847:24795", -- [9]
			"26844:26845:28196", -- [10]
			"26844:28197", -- [11]
			"26844:26845:28196:28195", -- [12]
			"26853:28623", -- [13]
			"26853:28618:28615", -- [14]
			"26853:28618", -- [15]
			"26853:28624", -- [16]
			"26853:28618:28615:28674:28574", -- [17]
			"26853:28618:28615:28674", -- [18]
			"26853:28618:28615:29721", -- [19]
			"26853:28624:32571", -- [20]
			"26853:28618:28615:29721:29757", -- [21]
			"26853:28624:29762", -- [22]
			"26853:28618:28615:28674:31069:31078", -- [23]
			"26853:28624:29951", -- [24]
			"26853:28618:28615:29721:29757:29950", -- [25]
			"26853:28624:30569", -- [26]
			"26844:26845:26851:26566:30870", -- [27]
			"26853:28618:28615:28674:31069:30314", -- [28]
			"26853:28618:28615:28674:30433", -- [29]
			"26853:28618:28615:28674:31069", -- [30]
			"26853:28618:28615:30269", -- [31]
			"26853:28618:28615:28674:33849", -- [32]
			"26853:28618:28615:28674:28574:28037", -- [33]
			["m"] = 117,
			["coord"] = 2127502707,
			["direct"] = "24155:27344:26844:26853:26852",
			["f"] = 0,
		},
		[28195] = {
			"28196:28197:24155", -- [1]
			"28196:26845:26852:24032:27344", -- [2]
			"28196:26845:26852:24032", -- [3]
			"26847:24795:27046", -- [4]
			"28196:26845:26844", -- [5]
			"28196:26845:26852:26853", -- [6]
			"28196:26845:26852", -- [7]
			"26847:26566:26851", -- [8]
			"28196:26845", -- [9]
			"26847:26566", -- [10]
			"26847:26848", -- [11]
			"26847:26566:26850", -- [12]
			"26847:24795", -- [13]
			"28196:28197", -- [14]
			"28196:26845:28615:28623", -- [15]
			"28196:26845:28615", -- [16]
			"28196:26845:28618", -- [17]
			"28196:26845:28615:28623:28624", -- [18]
			"26847:26848:28574", -- [19]
			"26847:26566:26850:28674", -- [20]
			"26847:26566:26850:28674:29721", -- [21]
			"26847:26566:26850:28674:29721:32571", -- [22]
			"26847:26566:26850:28674:29721:29757", -- [23]
			"26847:26566:26850:28674:29721:29762", -- [24]
			"26847:30870:31078", -- [25]
			"26847:26566:26850:28674:29721:29757:29951", -- [26]
			"26847:30870:30314:29950", -- [27]
			"28196:26845:28615:28623:28624:30569", -- [28]
			"26847:30870", -- [29]
			"26847:30870:30314", -- [30]
			"26847:26566:26850:28674:30433", -- [31]
			"26847:30870:31069", -- [32]
			"28196:26845:28615:30269", -- [33]
			"26847:30870:30314:33849", -- [34]
			"26847:26848:28037", -- [35]
			["direct"] = "25288:26847:28196",
			["coord"] = 3371205577,
			["m"] = 114,
			["f"] = 0,
		},
		[28196] = {
			"28197:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"28195:26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"28195:25288", -- [8]
			"28195:26847", -- [9]
			"28195:26847:26848", -- [10]
			"26851:26850", -- [11]
			"28195:26847:24795", -- [12]
			"26845:28615:28623", -- [13]
			"26845:28615", -- [14]
			"26845:28618", -- [15]
			"26845:28615:28623:28624", -- [16]
			"26566:30870:28574", -- [17]
			"28674:29721", -- [18]
			"28674:29721:32571", -- [19]
			"28674:29721:29757", -- [20]
			"28674:29721:29762", -- [21]
			"26566:30870:31078", -- [22]
			"28674:29721:29757:29951", -- [23]
			"28674:29721:29757:29950", -- [24]
			"26845:28615:28623:28624:30569", -- [25]
			"26566:30870", -- [26]
			"28674:31069:30314", -- [27]
			"28674:30433", -- [28]
			"28674:31069", -- [29]
			"26845:28615:30269", -- [30]
			"28674:33849", -- [31]
			"28195:26847:26848:28037", -- [32]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "26851:26845:26566:28197:28195:28674",
			["coord"] = 2081603196,
		},
		[28197] = {
			"24155:27344", -- [1]
			"26844:24032", -- [2]
			"28196:28195:26847:24795:27046", -- [3]
			"26844:24032:26853", -- [4]
			"26844:26852", -- [5]
			"26844:26845:26851", -- [6]
			"26844:26845", -- [7]
			"28196:26566", -- [8]
			"28196:28195:25288", -- [9]
			"28196:28195:26847", -- [10]
			"28196:28195:26847:26848", -- [11]
			"26844:26845:26851:26850", -- [12]
			"28196:28195:26847:24795", -- [13]
			"28196:28195", -- [14]
			"26844:26852:28618:28623", -- [15]
			"26844:26852:28618:28615", -- [16]
			"26844:26852:28618", -- [17]
			"26844:24032:26853:28624", -- [18]
			"28196:26566:30870:28574", -- [19]
			"26844:26852:28618:28615:28674", -- [20]
			"26844:26852:28618:28615:29721", -- [21]
			"26844:24032:26853:28624:32571", -- [22]
			"26844:26852:28618:28615:29721:29757", -- [23]
			"26844:24032:26853:28624:29762", -- [24]
			"28196:26566:30870:31078", -- [25]
			"26844:26852:28618:28615:29721:29757:29951", -- [26]
			"26844:26852:28618:28615:29721:29757:29950", -- [27]
			"26844:24032:26853:28624:30569", -- [28]
			"28196:26566:30870", -- [29]
			"26844:26852:28618:28615:28674:31069:30314", -- [30]
			"26844:26852:28618:28615:28674:30433", -- [31]
			"26844:26852:28618:28615:28674:31069", -- [32]
			"26844:26852:28618:28615:30269", -- [33]
			"26844:26852:28618:28615:28674:33849", -- [34]
			"28196:28195:26847:26848:28037", -- [35]
			["direct"] = "24155:26844:28196",
			["f"] = 0,
			["m"] = 117,
			["coord"] = 1058378765,
		},
		[26566] = {
			"26845:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"26847:25288", -- [8]
			"26847:26848", -- [9]
			"26847:24795", -- [10]
			"26845:26844:28197", -- [11]
			"26847:28195", -- [12]
			"26851:28615:28623", -- [13]
			"26851:28615", -- [14]
			"26845:28618", -- [15]
			"26851:28615:28623:28624", -- [16]
			"30870:28574", -- [17]
			"26850:28674", -- [18]
			"26850:28674:29721", -- [19]
			"26850:28674:29721:32571", -- [20]
			"26850:28674:29721:29757", -- [21]
			"26850:28674:29721:29762", -- [22]
			"30870:31078", -- [23]
			"26850:28674:29721:29757:29951", -- [24]
			"26850:28674:29721:29757:29950", -- [25]
			"26851:28615:28623:28624:30569", -- [26]
			"30870:30314", -- [27]
			"26850:28674:30433", -- [28]
			"26850:28674:31069", -- [29]
			"26850:28674:30269", -- [30]
			"26850:28674:33849", -- [31]
			"26847:26848:28037", -- [32]
			["m"] = 115,
			["coord"] = 1609331968,
			["direct"] = "26851:26845:26847:26850:28196:30870",
			["f"] = 0,
		},
		[29721] = {
			"28615:28618:26852:26844:24155", -- [1]
			"28615:28618:26853:27344", -- [2]
			"28615:28618:26853:24032", -- [3]
			"28674:25288:24795:27046", -- [4]
			"28615:28618:26852:26844", -- [5]
			"28615:28618:26853", -- [6]
			"28615:28618:26852", -- [7]
			"28615:26851", -- [8]
			"28615:26845", -- [9]
			"28674:26850:26566", -- [10]
			"28674:25288", -- [11]
			"28674:26850:26566:26847", -- [12]
			"28674:28574:26848", -- [13]
			"28674:26850", -- [14]
			"28674:25288:24795", -- [15]
			"28615:26851:28196", -- [16]
			"28615:28618:26852:26844:28197", -- [17]
			"28615:26851:28196:28195", -- [18]
			"28615:28623", -- [19]
			"28615:28618", -- [20]
			"28615:28623:28624", -- [21]
			"28674:28574", -- [22]
			"28674:31069:31078", -- [23]
			"29757:29951", -- [24]
			"29757:29950", -- [25]
			"28615:28623:28624:30569", -- [26]
			"28674:30870", -- [27]
			"29757:29950:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"29757:29950:33849", -- [31]
			"28674:28574:28037", -- [32]
			["m"] = 120,
			["coord"] = 1750521958,
			["direct"] = "28615:28674:32571:29757:29762:30269",
			["f"] = 0,
		},
		[30569] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"28624:28623:28615:26850:26566:26847:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"28624:28623:28618:26852", -- [7]
			"28624:28623:28615:26851", -- [8]
			"28624:28623:28618:26845", -- [9]
			"28624:28623:28615:26850:26566", -- [10]
			"28624:28623:28615:28674:25288", -- [11]
			"28624:28623:28615:26850:26566:26847", -- [12]
			"28624:28623:28615:28674:28574:26848", -- [13]
			"28624:28623:28615:26850", -- [14]
			"28624:28623:28615:26850:26566:26847:24795", -- [15]
			"28624:28623:28615:26851:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"28624:28623:28615:26851:28196:28195", -- [18]
			"28624:28623", -- [19]
			"28624:28623:28615", -- [20]
			"28624:28623:28618", -- [21]
			"28624:28623:28615:28674:28574", -- [22]
			"28624:28623:28615:28674", -- [23]
			"28624:28623:28615:29721", -- [24]
			"28624:32571", -- [25]
			"28624:29762:29757", -- [26]
			"28624:29762", -- [27]
			"28624:28623:28615:28674:31069:31078", -- [28]
			"28624:29951", -- [29]
			"28624:29951:29950", -- [30]
			"28624:28623:28615:28674:30870", -- [31]
			"28624:29951:29950:30314", -- [32]
			"28624:28623:28615:28674:30433", -- [33]
			"28624:28623:28615:28674:31069", -- [34]
			"28624:28623:28615:30269", -- [35]
			"28624:29951:29950:33849", -- [36]
			"28624:28623:28615:28674:28574:28037", -- [37]
			["direct"] = "28624",
			["coord"] = 3025877835,
			["m"] = 121,
			["f"] = 0,
		},
		[33849] = {
			"29950:29951:28624:26853:24032:24155", -- [1]
			"31069:30433:28674:27344", -- [2]
			"29950:29951:28624:26853:24032", -- [3]
			"30314:30870:26847:24795:27046", -- [4]
			"31069:30433:28674:28615:28618:26852:26844", -- [5]
			"29950:29951:28624:26853", -- [6]
			"31069:30433:28674:28615:28618:26852", -- [7]
			"31069:30433:28674:26851", -- [8]
			"31069:30433:28674:26850:26845", -- [9]
			"31069:30433:28674:26850:26566", -- [10]
			"30314:30870:26847:25288", -- [11]
			"30314:30870:26847", -- [12]
			"30314:31078:28574:26848", -- [13]
			"31069:30433:28674:26850", -- [14]
			"30314:30870:26847:24795", -- [15]
			"31069:30433:28674:28196", -- [16]
			"31069:30433:28674:28615:28618:26852:26844:28197", -- [17]
			"30314:30870:26847:28195", -- [18]
			"31069:30433:28674:28615:28623", -- [19]
			"31069:30433:28674:28615", -- [20]
			"31069:30433:28674:28615:28618", -- [21]
			"29950:29951:28624", -- [22]
			"30314:31078:28574", -- [23]
			"29950:29757:29721", -- [24]
			"29950:29951:32571", -- [25]
			"29950:29757", -- [26]
			"29950:29951:29762", -- [27]
			"30314:31078", -- [28]
			"29950:29951", -- [29]
			"29950:29951:28624:30569", -- [30]
			"30314:30870", -- [31]
			"31069:30433", -- [32]
			"31069:30433:28674:30269", -- [33]
			"30314:31078:28037:26848", -- [34]
			"30314:31078:28037", -- [35]			
			["direct"] = "28674:29950:30314:31069",
			["coord"] = 3118086692,
			["m"] = 118,
			["f"] = 0,
		},
		[29951] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"29950:30314:30870:26847:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"29757:29721:28615:28618:26852", -- [7]
			"29757:29721:28615:26851", -- [8]
			"29757:29721:28615:26845", -- [9]
			"29757:30433:28674:26850:26566", -- [10]
			"29757:30433:28674:25288", -- [11]
			"29950:30314:30870:26847", -- [12]
			"29950:30314:31078:28574:26848", -- [13]
			"29757:30433:28674:26850", -- [14]
			"29950:30314:30870:26847:24795", -- [15]
			"29757:30433:28674:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"29950:30314:30870:26847:28195", -- [18]
			"28624:28623", -- [19]
			"29757:29721:28615", -- [20]
			"29757:29721:28615:28618", -- [21]
			"29950:30314:31078:28574", -- [22]
			"29757:30433:28674", -- [23]
			"29757:29721", -- [24]
			"29950:30314:31078", -- [25]
			"28624:30569", -- [26]
			"29950:30314:30870", -- [27]
			"29950:30314", -- [28]
			"29757:30433", -- [29]
			"29757:30433:31069", -- [30]
			"29757:29721:30269", -- [31]
			"29950:33849", -- [32]
			"29950:30314:31078:28037:26848", -- [33]
			"29950:30314:31078:28037", -- [34]			
			["m"] = 120,
			["coord"] = 1911834618,
			["direct"] = "28624:32571:29757:29762:29950",
			["f"] = 0,
		},
		[29757] = {
			"29721:28615:28618:26852:26844:24155", -- [1]
			"29762:28624:26853:27344", -- [2]
			"29762:28624:26853:24032", -- [3]
			"30433:28674:25288:24795:27046", -- [4]
			"29721:28615:28618:26852:26844", -- [5]
			"29762:28624:26853", -- [6]
			"29721:28615:28618:26852", -- [7]
			"29721:28615:26851", -- [8]
			"29721:28615:26845", -- [9]
			"30433:28674:26850:26566", -- [10]
			"30433:28674:25288", -- [11]
			"30433:31069:30870:26847", -- [12]
			"30433:28674:28574:26848", -- [13]
			"30433:28674:26850", -- [14]
			"30433:28674:25288:24795", -- [15]
			"30433:28674:28196", -- [16]
			"29721:28615:28618:26852:26844:28197", -- [17]
			"30433:31069:30870:26847:28195", -- [18]
			"29721:28615:28623", -- [19]
			"29721:28615", -- [20]
			"29721:28615:28618", -- [21]
			"29762:28624", -- [22]
			"30433:28674:28574", -- [23]
			"30433:28674", -- [24]
			"29762:32571", -- [25]
			"29950:30314:31078", -- [26]
			"29762:28624:30569", -- [27]
			"30433:31069:30870", -- [28]
			"29950:30314", -- [29]
			"30433:31069", -- [30]
			"29721:30269", -- [31]
			"29950:33849", -- [32]
			"29950:30314:31078:28037", -- [33]			
			["m"] = 120,
			["coord"] = 1555988062,
			["direct"] = "29721:29762:29951:29950:30433",
			["f"] = 0,
		},
		[31069] = {
			"30433:28674:26850:26845:24155", -- [1]
			"30433:28674:27344", -- [2]
			"30433:28674:28615:28618:26853:24032", -- [3]
			"30870:26847:24795:27046", -- [4]
			"30433:28674:28615:28618:26852:26844", -- [5]
			"30433:28674:28615:28618:26853", -- [6]
			"30433:28674:28615:28618:26852", -- [7]
			"30433:28674:26851", -- [8]
			"30433:28674:26850:26845", -- [9]
			"30433:28674:26850:26566", -- [10]
			"30870:26847:25288", -- [11]
			"30870:26847", -- [12]
			"30870:28574:26848", -- [13]
			"30433:28674:26850", -- [14]
			"30870:26847:24795", -- [15]
			"30433:28674:28196", -- [16]
			"30433:28674:28615:28618:26852:26844:28197", -- [17]
			"30870:26847:28195", -- [18]
			"30433:28674:28615:28623", -- [19]
			"30433:28674:28615", -- [20]
			"30433:28674:28615:28618", -- [21]
			"30433:28674:28615:28623:28624", -- [22]
			"30870:28574", -- [23]
			"30433:28674:29721", -- [24]
			"30433:28674:29721:32571", -- [25]
			"30433:29757", -- [26]
			"30433:28674:29721:29762", -- [27]
			"30433:29757:29951", -- [28]
			"33849:29950", -- [29]
			"30433:28674:28615:28623:28624:30569", -- [30]
			"30433:28674:30269", -- [31]
			"30870:28574:28037", -- [1]			
			["m"] = 118,
			["coord"] = 3408050485,
			["direct"] = "28674:31078:30870:30314:30433:33849",
			["f"] = 0,
		},
		[28674] = {
			"26850:26845:24155", -- [1]
			"28615:28618:26853:24032", -- [2]
			"25288:24795:27046", -- [3]
			"28615:28618:26852:26844", -- [4]
			"28615:28618:26853", -- [5]
			"28615:28618:26852", -- [6]
			"26850:26845", -- [7]
			"26850:26566", -- [8]
			"26850:26566:26847", -- [9]
			"28574:26848", -- [10]
			"25288:24795", -- [11]
			"28615:28618:26852:26844:28197", -- [12]
			"26850:26566:26847:28195", -- [13]
			"28615:28623", -- [14]
			"28615:28618", -- [15]
			"28615:28623:28624", -- [16]
			"29721:32571", -- [17]
			"29721:29757", -- [18]
			"29721:29762", -- [19]
			"31069:31078", -- [20]
			"29721:29757:29951", -- [21]
			"29721:29757:29950", -- [22]
			"28615:28623:28624:30569", -- [23]
			"31069:30314", -- [24]
			"28574:28037", -- [25]
			"28574:28037", -- [26]			
			["m"] = 125,
			["coord"] = 3111024148,
			["direct"] = "27344:26851:25288:26850:28196:28615:28574:29721:30870:30433:31069:30269:33849",
			["f"] = 0,
		},
		[29950] = {
			"29951:28624:26853:24032:24155", -- [1]
			"29951:28624:26853:27344", -- [2]
			"29951:28624:26853:24032", -- [3]
			"30314:30870:26847:24795:27046", -- [4]
			"29757:29721:28615:28618:26852:26844", -- [5]
			"29951:28624:26853", -- [6]
			"29757:29721:28615:28618:26852", -- [7]
			"29757:29721:28615:26851", -- [8]
			"29757:29721:28615:26845", -- [9]
			"29757:30433:28674:26850:26566", -- [10]
			"30314:30870:26847:25288", -- [11]
			"30314:30870:26847", -- [12]
			"30314:31078:28574:26848", -- [13]
			"29757:30433:28674:26850", -- [14]
			"30314:30870:26847:24795", -- [15]
			"29757:30433:28674:28196", -- [16]
			"29757:29721:28615:28618:26852:26844:28197", -- [17]
			"30314:30870:26847:28195", -- [18]
			"29757:29721:28615:28623", -- [19]
			"29757:29721:28615", -- [20]
			"29757:29721:28615:28618", -- [21]
			"29951:28624", -- [22]
			"30314:31078:28574", -- [23]
			"29757:30433:28674", -- [24]
			"29757:29721", -- [25]
			"29951:32571", -- [26]
			"29951:29762", -- [27]
			"30314:31078", -- [28]
			"29951:28624:30569", -- [29]
			"30314:30870", -- [30]
			"29757:30433", -- [31]
			"33849:31069", -- [32]
			"29757:29721:30269", -- [33]
			"30314:31078:28037:26848", -- [34]
			"30314:31078:28037", -- [35]			
			["direct"] = "29757:29951:30314:33849",
			["coord"] = 1315200266,
			["m"] = 120,
			["f"] = 0,
		},
		[24795] = {
			"26847:26566:26845:24155", -- [1]
			"26847:26566:26845:26852:24032:27344", -- [2]
			"26847:26566:26845:26852:24032", -- [3]
			"26847:26566:26845:26844", -- [4]
			"26847:26566:26845:26852:26853", -- [5]
			"26847:26566:26845:26852", -- [6]
			"26847:26566:26851", -- [7]
			"26847:26566:26845", -- [8]
			"26847:26566", -- [9]
			"26847:26566:26850", -- [10]
			"26847:28195:28196", -- [11]
			"26847:26566:26845:26844:28197", -- [12]
			"26847:28195", -- [13]
			"26847:26566:26851:28615:28623", -- [14]
			"26847:26566:26851:28615", -- [15]
			"26847:26566:26845:28618", -- [16]
			"26847:26566:26851:28615:28623:28624", -- [17]
			"26848:28574", -- [18]
			"26847:26566:26850:28674", -- [19]
			"26847:26566:26850:28674:29721", -- [20]
			"26847:26566:26850:28674:29721:32571", -- [21]
			"26847:26566:26850:28674:29721:29757", -- [22]
			"26847:26566:26850:28674:29721:29762", -- [23]
			"26848:28574:31078", -- [24]
			"26848:28574:31078:30314:29950:29951", -- [25]
			"26848:28574:31078:30314:29950", -- [26]
			"26847:26566:26851:28615:28623:28624:30569", -- [27]
			"26847:30870", -- [28]
			"26848:28574:31078:30314", -- [29]
			"26847:26566:26850:28674:30433", -- [30]
			"26847:30870:31069", -- [31]
			"26847:26566:26850:28674:30269", -- [32]
			"26848:28574:31078:30314:33849", -- [33]
			"26848:28037", -- [34]
			"26848:28037:31078", -- [35]
			"26848:28037:31078:30314:29950:29951", -- [36]
			"26848:28037:31078:30314:29950", -- [37]
			"26848:28037:31078:30314", -- [38]
			"26848:28037:31078:30314:33849", -- [39]			
			["direct"] = "27046:25288:26847:26848",
			["f"] = 0,
			["m"] = 114,
			["coord"] = 1939560416,
		},
		[32571] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"29721:28674:25288:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"28624:28623:28618:26852", -- [7]
			"29721:28615:26851", -- [8]
			"29721:28615:26845", -- [9]
			"29721:28674:26850:26566", -- [10]
			"29721:28674:25288", -- [11]
			"29721:28674:26850:26566:26847", -- [12]
			"29721:28674:28574:26848", -- [13]
			"29721:28674:26850", -- [14]
			"29721:28674:25288:24795", -- [15]
			"29721:28615:26851:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"29721:28615:26851:28196:28195", -- [18]
			"28624:28623", -- [19]
			"29721:28615", -- [20]
			"28624:28623:28618", -- [21]
			"29721:28674:28574", -- [22]
			"29721:28674", -- [23]
			"29951:29757", -- [24]
			"29951:29950:30314:31078", -- [25]
			"29951:29950", -- [26]
			"28624:30569", -- [27]
			"29721:28674:30870", -- [28]
			"29951:29950:30314", -- [29]
			"29721:28674:30433", -- [30]
			"29721:28674:31069", -- [31]
			"29721:30269", -- [32]
			"29951:29950:33849", -- [33]
			"29721:28674:28574:28037", -- [34]
			"29762:29757", -- [35]
			["direct"] = "28624:29721:29762:29951",
			["coord"] = 2686753797,
			["m"] = 120,
			["f"] = 0,
		},
		[30870] = {
			"26566:26845:24155", -- [1]
			"26566:26845:26852:24032:27344", -- [2]
			"26566:26845:26852:24032", -- [3]
			"26847:24795:27046", -- [4]
			"26566:26845:26844", -- [5]
			"26566:26845:26852:26853", -- [6]
			"26566:26845:26852", -- [7]
			"26566:26851", -- [8]
			"26566:26845", -- [9]
			"26847:25288", -- [10]
			"28574:26848", -- [11]
			"26566:26850", -- [12]
			"26847:24795", -- [13]
			"26566:28196", -- [14]
			"26566:26845:26844:28197", -- [15]
			"26847:28195", -- [16]
			"28674:28615:28623", -- [17]
			"28674:28615", -- [18]
			"28674:28615:28618", -- [19]
			"28674:28615:28623:28624", -- [20]
			"28674:29721", -- [21]
			"28674:29721:32571", -- [22]
			"28674:29721:29757", -- [23]
			"28674:29721:29762", -- [24]
			"28674:29721:29757:29951", -- [25]
			"30314:29950", -- [26]
			"28674:28615:28623:28624:30569", -- [27]
			"28674:30433", -- [28]
			"28674:30269", -- [29]
			"30314:33849", -- [30]
			"28574:28037", -- [31]
			["m"] = 123,
			["coord"] = 929192263,
			["direct"] = "26566:26847:28574:28674:31078:30314:31069",
			["f"] = 0,
		},
		[28037] = {
			"26848:26847:26566:26845:24155", -- [1]
			"26848:26847:26566:26845:26852:24032:27344", -- [2]
			"26848:26847:26566:26845:26852:24032", -- [3]
			"26848:24795:27046", -- [4]
			"26848:26847:26566:26845:26844", -- [5]
			"26848:26847:26566:26845:26852:26853", -- [6]
			"26848:26847:26566:26845:26852", -- [7]
			"26848:26847:26566:26851", -- [8]
			"26848:26847:26566:26845", -- [9]
			"26848:26847:26566", -- [10]
			"26848:25288", -- [11]
			"26848:26847", -- [12]
			"26848:26847:26566:26850", -- [13]
			"26848:24795", -- [14]
			"26848:26847:28195:28196", -- [15]
			"26848:26847:26566:26845:26844:28197", -- [16]
			"26848:26847:28195", -- [17]
			"28574:28674:28615:28623", -- [18]
			"28574:28674:28615", -- [19]
			"28574:28674:28615:28618", -- [20]
			"28574:28674:28615:28623:28624", -- [21]
			"28574:28674", -- [22]
			"28574:28674:29721", -- [23]
			"28574:28674:29721:32571", -- [24]
			"31078:30314:29950:29757", -- [25]
			"28574:28674:29721:29762", -- [26]
			"31078:30314:29950:29951", -- [27]
			"31078:30314:29950", -- [28]
			"28574:28674:28615:28623:28624:30569", -- [29]
			"28574:30870", -- [30]
			"31078:30314", -- [31]
			"28574:28674:30433", -- [32]
			"31078:31069", -- [33]
			"28574:28674:30269", -- [34]
			"31078:30314:33849", -- [35]
			["direct"] = "26848:28574:31078",
			["coord"] = 1083348327,
			["m"] = 119,
			["f"] = 0,
			["requirements"] = "qid:12523"
		},		
		[29762] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"29721:28674:25288:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"28624:28623:28618:26852", -- [7]
			"29721:28615:26851", -- [8]
			"29721:28615:26845", -- [9]
			"29721:28674:26850:26566", -- [10]
			"29721:28674:25288", -- [11]
			"29721:28674:26850:26566:26847", -- [12]
			"29721:28674:28574:26848", -- [13]
			"29721:28674:26850", -- [14]
			"29721:28674:25288:24795", -- [15]
			"29721:28615:26851:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"29721:28615:26851:28196:28195", -- [18]
			"28624:28623", -- [19]
			"29721:28615", -- [20]
			"28624:28623:28618", -- [21]
			"29721:28674:28574", -- [22]
			"29721:28674", -- [23]
			"29951:29950:30314:31078", -- [24]
			"29951:29950", -- [25]
			"28624:30569", -- [26]
			"29721:28674:30870", -- [27]
			"29951:29950:30314", -- [28]
			"29757:30433", -- [29]
			"29757:30433:31069", -- [30]
			"29721:30269", -- [31]
			"29951:29950:33849", -- [32]
			"29951:29950:30314:31078:28037", -- [33]
			["m"] = 120,
			["coord"] = 2809037259,
			["direct"] = "28624:29721:32571:29757:29951",
			["f"] = 0,
		},
		[27344] = {
			"24032:26844:26845:26851:26566:26847:24795:27046", -- [1]
			"24032:26844", -- [2]
			"24032:26852", -- [3]
			"24032:26844:26845:26851", -- [4]
			"24032:26844:26845", -- [5]
			"24032:26844:26845:26851:26566", -- [6]
			"24032:26844:26845:28196:28195:25288", -- [7]
			"24032:26844:26845:26851:26566:26847", -- [8]
			"24032:26844:26845:26851:26566:26847:26848", -- [9]
			"26853:28618:28615:26850", -- [10]
			"24032:26844:26845:26851:26566:26847:24795", -- [11]
			"24032:26844:26845:28196", -- [12]
			"24155:28197", -- [13]
			"24032:26844:26845:28196:28195", -- [14]
			"26853:28623", -- [15]
			"26853:28618:28615", -- [16]
			"26853:28618", -- [17]
			"26853:28624", -- [18]
			"28674:28574", -- [19]
			"26853:28618:28615:29721", -- [20]
			"26853:28624:32571", -- [21]
			"26853:28618:28615:29721:29757", -- [22]
			"26853:28624:29762", -- [23]
			"28674:31069:31078", -- [24]
			"26853:28624:29951", -- [25]
			"26853:28618:28615:29721:29757:29950", -- [26]
			"26853:28624:30569", -- [27]
			"28674:30870", -- [28]
			"28674:31069:30314", -- [29]
			"28674:30433", -- [30]
			"28674:31069", -- [31]
			"26853:28618:28615:30269", -- [32]
			"28674:33849", -- [33]
			"28674:28574:28037", -- [34]
			["direct"] = "24155:24032:26853:28674",
			["coord"] = 3394259988,
			["m"] = 117,
			["f"] = 0,
		},
		[30269] = {
			"28615:28618:26852:26844:24155", -- [1]
			"28615:28618:26853:27344", -- [2]
			"28615:28618:26853:24032", -- [3]
			"28674:25288:24795:27046", -- [4]
			"28615:28618:26852:26844", -- [5]
			"28615:28618:26853", -- [6]
			"28615:28618:26852", -- [7]
			"28615:26851", -- [8]
			"28615:26845", -- [9]
			"28674:26850:26566", -- [10]
			"28674:25288", -- [11]
			"28674:26850:26566:26847", -- [12]
			"28674:28574:26848", -- [13]
			"28674:26850", -- [14]
			"28674:25288:24795", -- [15]
			"28615:26851:28196", -- [16]
			"28615:28618:26852:26844:28197", -- [17]
			"28615:26851:28196:28195", -- [18]
			"28615:28623", -- [19]
			"28615:28618", -- [20]
			"28615:28623:28624", -- [21]
			"28674:28574", -- [22]
			"29721:32571", -- [23]
			"29721:29757", -- [24]
			"29721:29762", -- [25]
			"28674:31069:31078", -- [26]
			"29721:29757:29951", -- [27]
			"29721:29757:29950", -- [28]
			"28615:28623:28624:30569", -- [29]
			"28674:30870", -- [30]
			"28674:31069:30314", -- [31]
			"28674:30433", -- [32]
			"28674:31069", -- [33]
			"28674:33849", -- [34]
			"28674:28574:28037", -- [269]			
			["direct"] = "28615:28674:29721",
			["f"] = 0,
			["m"] = 127,
			["coord"] = 3370746011,
		},
		[30433] = {
			"28674:26850:26845:24155", -- [1]
			"28674:27344", -- [2]
			"28674:28615:28618:26853:24032", -- [3]
			"28674:25288:24795:27046", -- [4]
			"28674:28615:28618:26852:26844", -- [5]
			"28674:28615:28618:26853", -- [6]
			"28674:28615:28618:26852", -- [7]
			"28674:26851", -- [8]
			"28674:26850:26845", -- [9]
			"28674:26850:26566", -- [10]
			"28674:25288", -- [11]
			"31069:30870:26847", -- [12]
			"28674:28574:26848", -- [13]
			"28674:26850", -- [14]
			"28674:25288:24795", -- [15]
			"28674:28196", -- [16]
			"28674:28615:28618:26852:26844:28197", -- [17]
			"31069:30870:26847:28195", -- [18]
			"28674:28615:28623", -- [19]
			"28674:28615", -- [20]
			"28674:28615:28618", -- [21]
			"28674:28615:28623:28624", -- [22]
			"28674:28574", -- [23]
			"28674:29721", -- [24]
			"28674:29721:32571", -- [25]
			"28674:29721:29762", -- [26]
			"31069:31078", -- [27]
			"29757:29951", -- [28]
			"29757:29950", -- [29]
			"28674:28615:28623:28624:30569", -- [30]
			"31069:30870", -- [31]
			"28674:30269", -- [32]
			"31069:33849", -- [33]
			"28674:28574:28037", -- [34]
			["direct"] = "28674:29757:30314:31069",
			["f"] = 0,
			["m"] = 118,
			["coord"] = 3770468289,
		},
		[27046] = {
			"24795:26847:26566:26845:24155", -- [1]
			"24795:26847:26566:26845:26852:24032:27344", -- [2]
			"24795:26847:26566:26845:26852:24032", -- [3]
			"24795:26847:26566:26845:26844", -- [4]
			"24795:26847:26566:26845:26852:26853", -- [5]
			"24795:26847:26566:26845:26852", -- [6]
			"24795:26847:26566:26851", -- [7]
			"24795:26847:26566:26845", -- [8]
			"24795:26847:26566", -- [9]
			"24795:25288", -- [10]
			"24795:26847", -- [11]
			"24795:26848", -- [12]
			"24795:26847:26566:26850", -- [13]
			"24795:26847:28195:28196", -- [14]
			"24795:26847:26566:26845:26844:28197", -- [15]
			"24795:26847:28195", -- [16]
			"24795:26847:26566:26851:28615:28623", -- [17]
			"24795:26847:26566:26851:28615", -- [18]
			"24795:26847:26566:26845:28618", -- [19]
			"24795:26847:26566:26851:28615:28623:28624", -- [20]
			"24795:26848:28574", -- [21]
			"24795:26847:26566:26850:28674", -- [22]
			"24795:26847:26566:26850:28674:29721", -- [23]
			"24795:26847:26566:26850:28674:29721:32571", -- [24]
			"24795:26847:26566:26850:28674:29721:29757", -- [25]
			"24795:26847:26566:26850:28674:29721:29762", -- [26]
			"24795:26848:28574:31078", -- [27]
			"24795:26848:28574:31078:30314:29950:29951", -- [28]
			"24795:26848:28574:31078:30314:29950", -- [29]
			"24795:26847:26566:26851:28615:28623:28624:30569", -- [30]
			"24795:26847:30870", -- [31]
			"24795:26848:28574:31078:30314", -- [32]
			"24795:26847:26566:26850:28674:30433", -- [33]
			"24795:26847:30870:31069", -- [34]
			"24795:26847:26566:26850:28674:30269", -- [35]
			"24795:26848:28574:31078:30314:33849", -- [36]
			"24795:26848:28037", -- [37]
			"24795:26848:28037:31078", -- [38]
			"24795:26848:28037:31078:30314:29950:29951", -- [39]
			"24795:26848:28037:31078:30314:29950", -- [40]
			"24795:26848:28037:31078:30314", -- [41]
			"24795:26848:28037:31078:30314:33849", -- [43]			
			["direct"] = "24795",
			["f"] = 0,
			["m"] = 114,
			["coord"] = 1422481428,
		},
		[26844] = {
			"24032:27344", -- [1]
			"26845:26851:26566:26847:24795:27046", -- [2]
			"24032:26853", -- [3]
			"26845:26851", -- [4]
			"26845:26851:26566", -- [5]
			"26845:28196:28195:25288", -- [6]
			"26845:26851:26566:26847", -- [7]
			"26845:26851:26566:26847:26848", -- [8]
			"26845:26851:26850", -- [9]
			"26845:26851:26566:26847:24795", -- [10]
			"26845:28196", -- [11]
			"26845:28196:28195", -- [12]
			"26852:28618:28623", -- [13]
			"26852:28618:28615", -- [14]
			"26852:28618", -- [15]
			"24032:26853:28624", -- [16]
			"26845:26851:26566:30870:28574", -- [17]
			"26852:28618:28615:28674", -- [18]
			"26852:28618:28615:29721", -- [19]
			"24032:26853:28624:32571", -- [20]
			"26852:28618:28615:29721:29757", -- [21]
			"24032:26853:28624:29762", -- [22]
			"26852:28618:28615:28674:31069:31078", -- [23]
			"26852:28618:28615:29721:29757:29951", -- [24]
			"26852:28618:28615:29721:29757:29950", -- [25]
			"24032:26853:28624:30569", -- [26]
			"26845:26851:26566:30870", -- [27]
			"26852:28618:28615:28674:31069:30314", -- [28]
			"26852:28618:28615:28674:30433", -- [29]
			"26852:28618:28615:28674:31069", -- [30]
			"26852:28618:28615:30269", -- [31]
			"26852:28618:28615:28674:33849", -- [32]
			"26845:26851:26566:26847:26848:28037", -- [33]
			["m"] = 117,
			["coord"] = 1115308011,
			["direct"] = "24155:24032:26852:26845:28197",
			["f"] = 0,
		},
		[26845] = {
			"26852:24032:27344", -- [1]
			"26852:24032", -- [2]
			"26851:26566:26847:24795:27046", -- [3]
			"26852:26853", -- [4]
			"28196:28195:25288", -- [5]
			"26851:26566:26847", -- [6]
			"26851:26566:26847:26848", -- [7]
			"26851:26566:26847:24795", -- [8]
			"26844:28197", -- [9]
			"28196:28195", -- [10]
			"28615:28623", -- [11]
			"28615:28623:28624", -- [12]
			"26851:26566:30870:28574", -- [13]
			"26851:28674", -- [14]
			"28615:29721", -- [15]
			"28615:29721:32571", -- [16]
			"28615:29721:29757", -- [17]
			"28615:29721:29762", -- [18]
			"26851:26566:30870:31078", -- [19]
			"28615:29721:29757:29951", -- [20]
			"28615:29721:29757:29950", -- [21]
			"28615:28623:28624:30569", -- [22]
			"26851:26566:30870", -- [23]
			"26851:28674:31069:30314", -- [24]
			"26851:28674:30433", -- [25]
			"26851:28674:31069", -- [26]
			"28615:30269", -- [27]
			"26851:28674:33849", -- [28]
			"26851:26566:26847:26848:28037", -- [29]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "24155:26844:26852:26851:26566:26850:28196:28615:28618",
			["coord"] = 3285163912,
		},
		[28574] = {
			"30870:26566:26845:24155", -- [1]
			"30870:26566:26845:26852:24032:27344", -- [2]
			"30870:26566:26845:26852:24032", -- [3]
			"26848:24795:27046", -- [4]
			"30870:26566:26845:26844", -- [5]
			"28674:28615:28618:26853", -- [6]
			"30870:26566:26845:26852", -- [7]
			"30870:26566:26851", -- [8]
			"30870:26566:26845", -- [9]
			"30870:26566", -- [10]
			"26848:25288", -- [11]
			"26848:26847", -- [12]
			"30870:26566:26850", -- [13]
			"26848:24795", -- [14]
			"30870:26566:28196", -- [15]
			"30870:26566:26845:26844:28197", -- [16]
			"26848:26847:28195", -- [17]
			"28674:28615:28623", -- [18]
			"28674:28615", -- [19]
			"28674:28615:28618", -- [20]
			"28674:28615:28623:28624", -- [21]
			"28674:29721", -- [22]
			"28674:29721:32571", -- [23]
			"28674:29721:29757", -- [24]
			"28674:29721:29762", -- [25]
			"31078:30314:29950:29951", -- [26]
			"31078:30314:29950", -- [27]
			"28674:28615:28623:28624:30569", -- [28]
			"31078:30314", -- [29]
			"28674:30433", -- [30]
			"28674:31069", -- [31]
			"28674:30269", -- [32]
			"31078:30314:33849", -- [33]
			["direct"] = "26848:28037:28674:31078:30870",
			["coord"] = 2150407428,
			["m"] = 119,
			["f"] = 0,
		},
		[26847] = {
			"26566:26845:24155", -- [1]
			"26566:26845:26852:24032:27344", -- [2]
			"26566:26845:26852:24032", -- [3]
			"24795:27046", -- [4]
			"26566:26845:26844", -- [5]
			"26566:26845:26852:26853", -- [6]
			"26566:26845:26852", -- [7]
			"26566:26851", -- [8]
			"26566:26845", -- [9]
			"26566:26850", -- [10]
			"28195:28196", -- [11]
			"26566:26845:26844:28197", -- [12]
			"26566:26851:28615:28623", -- [13]
			"26566:26851:28615", -- [14]
			"26566:26845:28618", -- [15]
			"26566:26851:28615:28623:28624", -- [16]
			"26848:28574", -- [17]
			"26566:26850:28674", -- [18]
			"26566:26850:28674:29721", -- [19]
			"26566:26850:28674:29721:32571", -- [20]
			"26566:26850:28674:29721:29757", -- [21]
			"26566:26850:28674:29721:29762", -- [22]
			"30870:31078", -- [23]
			"26566:26850:28674:29721:29757:29951", -- [24]
			"30870:30314:29950", -- [25]
			"26566:26851:28615:28623:28624:30569", -- [26]
			"30870:30314", -- [27]
			"26566:26850:28674:30433", -- [28]
			"30870:31069", -- [29]
			"26566:26850:28674:30269", -- [30]
			"30870:30314:33849", -- [31]
			"26848:28037", -- [32]
			["m"] = 114,
			["coord"] = 3338821751,
			["direct"] = "26566:25288:26848:24795:28195:30870",
			["f"] = 0,
		},
		[26848] = {
			"26847:26566:26845:24155", -- [1]
			"26847:26566:26845:26852:24032:27344", -- [2]
			"26847:26566:26845:26852:24032", -- [3]
			"24795:27046", -- [4]
			"26847:26566:26845:26844", -- [5]
			"26847:26566:26845:26852:26853", -- [6]
			"26847:26566:26845:26852", -- [7]
			"26847:26566:26851", -- [8]
			"26847:26566:26845", -- [9]
			"26847:26566", -- [10]
			"26847:26566:26850", -- [11]
			"26847:28195:28196", -- [12]
			"26847:26566:26845:26844:28197", -- [13]
			"26847:28195", -- [14]
			"26847:26566:26851:28615:28623", -- [15]
			"26847:26566:26851:28615", -- [16]
			"26847:26566:26845:28618", -- [17]
			"26847:26566:26851:28615:28623:28624", -- [18]
			"28574:28674", -- [19]
			"28574:28674:29721", -- [20]
			"28574:28674:29721:32571", -- [21]
			"28574:28674:29721:29757", -- [22]
			"28574:28674:29721:29762", -- [23]
			"28574:31078", -- [24]
			"28574:31078:30314:29950:29951", -- [25]
			"28574:31078:30314:29950", -- [26]
			"26847:26566:26851:28615:28623:28624:30569", -- [27]
			"28574:30870", -- [28]
			"28574:31078:30314", -- [29]
			"28574:28674:30433", -- [30]
			"28574:28674:31069", -- [31]
			"28574:28674:30269", -- [32]
			"28574:31078:30314:33849", -- [33]
			"28037:31078", -- [34]
			"28037:31078:30314:29950:29951", -- [35]
			"28037:31078:30314:29950", -- [36]
			"28037:31078:30314", -- [37]
			"28037:31078:30314:33849", -- [38]			
			["direct"] = "25288:26847:24795:28574:28037",
			["f"] = 0,
			["m"] = 114,
			["coord"] = 2129861678,
		},
		[30314] = {
			"30870:26566:26845:24155", -- [1]
			"30433:28674:27344", -- [2]
			"30433:28674:28615:28618:26853:24032", -- [3]
			"30870:26847:24795:27046", -- [4]
			"30870:26566:26845:26844", -- [5]
			"30433:28674:28615:28618:26853", -- [6]
			"30433:28674:28615:28618:26852", -- [7]
			"30433:28674:26851", -- [8]
			"30870:26566:26845", -- [9]
			"30870:26566", -- [10]
			"30870:26847:25288", -- [11]
			"30870:26847", -- [12]
			"31078:28574:26848", -- [13]
			"30433:28674:26850", -- [14]
			"30870:26847:24795", -- [15]
			"30870:26566:28196", -- [16]
			"30870:26566:26845:26844:28197", -- [17]
			"30870:26847:28195", -- [18]
			"30433:28674:28615:28623", -- [19]
			"30433:28674:28615", -- [20]
			"30433:28674:28615:28618", -- [21]
			"29950:29951:28624", -- [22]
			"31078:28574", -- [23]
			"30433:28674", -- [24]
			"30433:28674:29721", -- [25]
			"29950:29951:32571", -- [26]
			"29950:29757", -- [27]
			"29950:29951:29762", -- [28]
			"29950:29951", -- [29]
			"29950:29951:28624:30569", -- [30]
			"30433:28674:30269", -- [31]
			"31078:28037:26848", -- [32]
			"31078:28037", -- [33]			
			["m"] = 118,
			["coord"] = 1878408808,
			["direct"] = "31078:29950:30870:30433:31069:33849",
			["f"] = 0,
		},
		[26850] = {
			"26845:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"26566:26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"26566:26847:25288", -- [8]
			"26566:26847", -- [9]
			"26566:26847:26848", -- [10]
			"26566:26847:24795", -- [11]
			"26566:28196", -- [12]
			"26845:26844:28197", -- [13]
			"26566:26847:28195", -- [14]
			"28615:28623", -- [15]
			"28615:28618", -- [16]
			"28615:28623:28624", -- [17]
			"26566:30870:28574", -- [18]
			"28674:29721", -- [19]
			"28674:29721:32571", -- [20]
			"28674:29721:29757", -- [21]
			"28674:29721:29762", -- [22]
			"28674:31069:31078", -- [23]
			"28674:29721:29757:29951", -- [24]
			"28674:29721:29757:29950", -- [25]
			"28615:28623:28624:30569", -- [26]
			"26566:30870", -- [27]
			"28674:31069:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"28674:30269", -- [31]
			"28674:33849", -- [32]
			"26566:26847:26848:28037", -- [33]
			["m"] = 115,
			["coord"] = 1884760835,
			["direct"] = "26851:26845:26566:28615:28674",
			["f"] = 0,
		},
		[26851] = {
			"26845:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"26566:26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"26566:26847:25288", -- [8]
			"26566:26847", -- [9]
			"26566:26847:26848", -- [10]
			"26566:26847:24795", -- [11]
			"26845:26844:28197", -- [12]
			"28196:28195", -- [13]
			"28615:28623", -- [14]
			"28615:28618", -- [15]
			"28615:28623:28624", -- [16]
			"26566:30870:28574", -- [17]
			"28615:29721", -- [18]
			"28615:29721:32571", -- [19]
			"28615:29721:29757", -- [20]
			"28615:29721:29762", -- [21]
			"26566:30870:31078", -- [22]
			"28615:29721:29757:29951", -- [23]
			"28615:29721:29757:29950", -- [24]
			"28615:28623:28624:30569", -- [25]
			"26566:30870", -- [26]
			"28674:31069:30314", -- [27]
			"28674:30433", -- [28]
			"28674:31069", -- [29]
			"28615:30269", -- [30]
			"28674:33849", -- [31]
			"26566:26847:26848:28037", -- [32]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "26845:26566:26850:28196:28615:28674",
			["coord"] = 2588115855,
		},
		[28615] = {
			"28618:26852:26844:24155", -- [1]
			"28618:26853:27344", -- [2]
			"28618:26853:24032", -- [3]
			"26850:26566:26847:24795:27046", -- [4]
			"28618:26852:26844", -- [5]
			"28618:26853", -- [6]
			"28618:26852", -- [7]
			"26850:26566", -- [8]
			"28674:25288", -- [9]
			"26850:26566:26847", -- [10]
			"28674:28574:26848", -- [11]
			"26850:26566:26847:24795", -- [12]
			"26851:28196", -- [13]
			"28618:26852:26844:28197", -- [14]
			"26851:28196:28195", -- [15]
			"28623:28624", -- [16]
			"28674:28574", -- [17]
			"29721:32571", -- [18]
			"29721:29757", -- [19]
			"29721:29762", -- [20]
			"28674:31069:31078", -- [21]
			"29721:29757:29951", -- [22]
			"29721:29757:29950", -- [23]
			"28623:28624:30569", -- [24]
			"28674:30870", -- [25]
			"28674:31069:30314", -- [26]
			"28674:30433", -- [27]
			"28674:31069", -- [28]
			"28674:33849", -- [29]
			"28674:28574:28037", -- [30]
			["m"] = 121,
			["f"] = 0,
			["direct"] = "26851:26845:26850:28623:28618:28674:29721:30269",
			["coord"] = 603962466,
		},
	}, -- [4]
	[6] = {
		[65863] = {
			"61122:60230:60952", -- [1]
			"61122:60230:59186", -- [2]
			"61122:60230:59186:59732", -- [3]
			"62901:61473:61745:61474:66227:59736:59735:59733", -- [4]
			"62901:61473:61745:61474:66227:59736:59735", -- [5]
			"62901:61473:61745:61474:66227:59736", -- [6]
			"62901:61473:61745:61474:66227", -- [7]
			"61122:60230", -- [8]
			"61122:60231", -- [9]
			"61122:60231:60232", -- [10]
			"61122:60231:59046", -- [11]
			"62903:63500:63501:58843", -- [12]
			"62903:63500:63501:58843:59047", -- [13]
			"62903:63500:63501:58843:65189", -- [14]
			"62903:63500:63501:58843:59047:60441", -- [15]
			"62901:61473:61745:61474", -- [16]
			"62901:61512:60416:61504:61118", -- [17]
			"62901:61473:61745", -- [18]
			"62901:61512:60416:61504:61118:61511", -- [19]
			"62901:61512:60416:61504", -- [20]
			"62901:61512:60416", -- [21]
			"62901:61473", -- [22]
			"62901:61512", -- [23]
			"61122:62658:61759", -- [24]
			"61122:62658", -- [25]
			"62901:62898", -- [26]
			"62901:62898:62909", -- [27]
			"62903:63500:63501", -- [28]
			"62903:63500:63501:63498", -- [29]
			"62903:63500", -- [30]
			"62903:63500:63497", -- [31]
			"61122:60230:59186:64310", -- [32]
			"62903:63500:63501:65511", -- [33]
			"61122:60230:59186:71939", -- [34]
			--["name"] = "Serpent's Spine, Kun-Lai Summit",
			["m"] = 379,
			["direct"] = "62901:62903:61122",
			["coord"] = 1545786979,
			["f"] = 0,
		},
		[60441] = {
			"59046:60230:60952", -- [1]
			"59046:60230:59186", -- [2]
			"59046:60230:59186:59732", -- [3]
			"59046:60230:59186:59735:59733", -- [4]
			"59046:60230:59186:59735", -- [5]
			"59046:60230:60952:59736", -- [6]
			"59046:60230:60952:66227", -- [7]
			"59046:60230", -- [8]
			"59046:60231", -- [9]
			"59046:60232", -- [10]
			"65189:58843", -- [11]
			"59046:60231:62658:61759:61474", -- [12]
			"59046:60231:62658:61759:61474:61118", -- [13]
			"59046:60231:62658:61759:61474:61745", -- [14]
			"59046:60231:62658:61759:61474:61118:61511", -- [15]
			"59046:60231:62658:61759:61474:61504", -- [16]
			"59046:60231:62658:61759:61474:61745:60416", -- [17]
			"59046:60231:62658:61759:61474:61745:61473", -- [18]
			"59046:60231:62658:61759:61474:61745:60416:61512", -- [19]
			"59046:60231:62658:61759", -- [20]
			"59046:60231:62658", -- [21]
			"59046:60231:61122:65863:62901", -- [22]
			"65189:59047:63501:63500:62903", -- [23]
			"65189:59047:63501:63500:62903:62898", -- [24]
			"65189:59047:63501:63500:62903:62898:62909", -- [25]
			"59046:60231:61122", -- [26]
			"65189:59047:63501", -- [27]
			"65189:59047:63501:63498", -- [28]
			"65189:59047:63501:63500", -- [29]
			"65189:59047:63501:63497", -- [30]
			"59046:60230:59186:64310", -- [31]
			"65189:59047:63501:65511", -- [32]
			"59046:60231:61122:65863", -- [33]
			"59046:60230:59186:71939", -- [34]
			--["name"] = "Marista, Krasarang Wilds",
			["m"] = 418,
			["f"] = 0,
			["direct"] = "59046:59047:65189",
			["coord"] = 2250621975,
		},
		[62658] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"61759:61474:66227", -- [7]
			"60231:60232", -- [8]
			"60231:59046", -- [9]
			"60231:58843", -- [10]
			"60231:58843:59047", -- [11]
			"60231:65189", -- [12]
			"60231:59046:60441", -- [13]
			"61759:61474", -- [14]
			"61759:61474:61118", -- [15]
			"61759:61474:61745", -- [16]
			"61759:61474:61118:61511", -- [17]
			"61759:61474:61504", -- [18]
			"61759:61474:61745:60416", -- [19]
			"61759:61474:61745:61473", -- [20]
			"61759:61474:61745:60416:61512", -- [21]
			"61122:65863:62901", -- [22]
			"61759:61474:61745:61473:62903", -- [23]
			"61759:61474:61745:61473:62903:62898", -- [24]
			"61759:61474:61745:61473:62903:62898:62909", -- [25]
			"60231:58843:63501", -- [26]
			"60231:58843:63501:63498", -- [27]
			"61122:63500", -- [28]
			"61122:63497", -- [29]
			"60230:59186:64310", -- [30]
			"60231:58843:63501:65511", -- [31]
			"61122:65863", -- [32]
			"60230:59186:71939", -- [33]
			--["name"] = "Grassy Cline, Valley of the Four Winds",
			["m"] = 376,
			["f"] = 0,
			["direct"] = "60230:60231:61759:61122",
			["coord"] = 3041672744,
		},
		[61473] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:66227:59736:59735:59733", -- [4]
			"61745:61474:66227:59736:59735", -- [5]
			"61745:61474:66227:59736", -- [6]
			"61745:61474:66227", -- [7]
			"61745:61474:61759:60230", -- [8]
			"61745:61474:61759:62658:60231", -- [9]
			"61745:61474:60232", -- [10]
			"61745:61474:61759:62658:60231:59046", -- [11]
			"62903:63500:63501:58843", -- [12]
			"62903:63500:63501:58843:59047", -- [13]
			"62903:63500:63501:58843:65189", -- [14]
			"62903:63500:63501:58843:59047:60441", -- [15]
			"61745:61474", -- [16]
			"60416:61504:61118", -- [17]
			"60416:61504:61118:61511", -- [18]
			"60416:61504", -- [19]
			"60416:61512", -- [20]
			"61745:61474:61759", -- [21]
			"61745:61474:61759:62658", -- [22]
			"62903:62898", -- [23]
			"62903:62898:62909", -- [24]
			"61745:61122", -- [25]
			"62903:63500:63501", -- [26]
			"62903:63500:63501:63498", -- [27]
			"62903:63500", -- [28]
			"62903:63500:63497", -- [29]
			"61745:61474:61759:60230:59186:64310", -- [30]
			"62903:63500:63501:65511", -- [31]
			"62903:65863", -- [32]
			"61745:61474:61759:60230:59186:71939", -- [33]
			["direct"] = "61745:60416:62901:62903",
			["m"] = 379,
			["coord"] = 1887954259,
			["f"] = 0,
		},
		[64310] = {
			"59186:59732", -- [1]
			"59186:59735:59733", -- [2]
			"59186:59735", -- [3]
			"59186:59736", -- [4]
			"60952:66227", -- [5]
			"60952:60230", -- [6]
			"60952:60230:60231", -- [7]
			"60952:60230:60232", -- [8]
			"60952:60230:59046", -- [9]
			"60952:60230:60231:58843", -- [10]
			"60952:60230:59046:59047", -- [11]
			"60952:60230:60231:65189", -- [12]
			"60952:60230:59046:60441", -- [13]
			"60952:60230:61759:61474", -- [14]
			"60952:60230:61759:61474:61118", -- [15]
			"60952:60230:61759:61474:61745", -- [16]
			"60952:60230:61759:61474:61118:61511", -- [17]
			"60952:60230:61759:61474:61504", -- [18]
			"60952:60230:61759:61474:61745:60416", -- [19]
			"60952:60230:61759:61474:61745:61473", -- [20]
			"60952:60230:61759:61474:61745:60416:61512", -- [21]
			"60952:60230:61759", -- [22]
			"60952:60230:62658", -- [23]
			"60952:60230:62658:61122:65863:62901", -- [24]
			"60952:60230:61759:61474:61745:61473:62903", -- [25]
			"60952:60230:61759:61474:61745:61473:62903:62898", -- [26]
			"60952:60230:61759:61474:61745:61473:62903:62898:62909", -- [27]
			"60952:60230:62658:61122", -- [28]
			"60952:60230:60231:58843:63501", -- [29]
			"60952:60230:60231:58843:63501:63498", -- [30]
			"60952:60230:62658:61122:63500", -- [31]
			"60952:60230:62658:61122:63497", -- [32]
			"60952:60230:60231:58843:63501:65511", -- [33]
			"60952:60230:62658:61122:65863", -- [34]
			"59186:71939", -- [35]
			--["name"] = "Serpent's Overlook, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "60952:59186",
			["coord"] = 1851699009,
		},
		[65511] = {
			"63501:58843:60231:60230:60952", -- [1]
			"63501:58843:60231:60230:59186", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60230:59186:59735:59733", -- [4]
			"63501:58843:60231:60230:59186:59735", -- [5]
			"63501:58843:60231:60230:60952:59736", -- [6]
			"63501:61122:66227", -- [7]
			"63501:58843:60231:60230", -- [8]
			"63501:58843:60231", -- [9]
			"63501:58843:60231:60232", -- [10]
			"63501:58843:60231:59046", -- [11]
			"63501:58843", -- [12]
			"63501:58843:59047", -- [13]
			"63501:58843:65189", -- [14]
			"63501:58843:59047:60441", -- [15]
			"63501:58843:60231:62658:61759:61474", -- [16]
			"63501:63500:62903:61473:60416:61504:61118", -- [17]
			"63501:63500:62903:61473:61745", -- [18]
			"63501:63500:62903:61473:60416:61504:61118:61511", -- [19]
			"63501:63500:62903:61473:60416:61504", -- [20]
			"63501:63500:62903:61473:60416", -- [21]
			"63501:63500:62903:61473", -- [22]
			"63501:63497:61512", -- [23]
			"63501:58843:60231:62658:61759", -- [24]
			"63501:58843:60231:62658", -- [25]
			"63501:63500:62903:62901", -- [26]
			"63501:63500:62903", -- [27]
			"63501:63500:62903:62898", -- [28]
			"63501:63500:62903:62898:62909", -- [29]
			"63501:61122", -- [30]
			"63501:63500", -- [31]
			"63501:63497", -- [32]
			"63501:58843:60231:60230:59186:64310", -- [33]
			"63501:63500:62903:65863", -- [34]
			"63501:58843:60231:60230:59186:71939", -- [35]
			--["name"] = "The Briny Muck, Dread Wastes",
			["m"] = 422,
			["f"] = 0,
			["direct"] = "63501:63498",
			["coord"] = 1829473930,
		},
		[63497] = {
			"61122:60230:60952", -- [1]
			"61122:60230:59186", -- [2]
			"61122:60230:59186:59732", -- [3]
			"61122:66227:59736:59735:59733", -- [4]
			"61122:66227:59736:59735", -- [5]
			"61122:66227:59736", -- [6]
			"61122:66227", -- [7]
			"61122:60230", -- [8]
			"63501:58843:60231", -- [9]
			"63501:58843:60231:60232", -- [10]
			"63501:58843:60231:59046", -- [11]
			"63501:58843", -- [12]
			"63501:58843:59047", -- [13]
			"63501:58843:65189", -- [14]
			"63501:58843:59047:60441", -- [15]
			"61122:61474", -- [16]
			"61122:61745:61118", -- [17]
			"61122:61745", -- [18]
			"61122:61745:61511", -- [19]
			"61122:61745:61504", -- [20]
			"61512:60416", -- [21]
			"63500:62903:61473", -- [22]
			"61122:62658:61759", -- [23]
			"61122:62658", -- [24]
			"63500:62903:62901", -- [25]
			"63500:62903", -- [26]
			"63500:62903:62898", -- [27]
			"63500:62903:62898:62909", -- [28]
			"61122:60230:59186:64310", -- [29]
			"63501:65511", -- [30]
			"63500:62903:65863", -- [31]
			"61122:60230:59186:71939", -- [32]
			--["name"] = "Serpent's Spine, Vale of Eternal Blossoms",
			["direct"] = "61512:61122:63501:63498:63500",
			["f"] = 0,
			["m"] = 390,
			["coord"] = 603966145,
		},
		[63501] = {
			"58843:60231:60230:60952", -- [1]
			"58843:60231:60230:59186", -- [2]
			"58843:60231:60230:59186:59732", -- [3]
			"58843:60231:60230:59186:59735:59733", -- [4]
			"58843:60231:60230:59186:59735", -- [5]
			"58843:60231:60230:60952:59736", -- [6]
			"61122:66227", -- [7]
			"58843:60231:60230", -- [8]
			"58843:60231", -- [9]
			"58843:60231:60232", -- [10]
			"58843:60231:59046", -- [11]
			"58843:65189", -- [12]
			"58843:59047:60441", -- [13]
			"58843:60231:62658:61759:61474", -- [14]
			"63500:62903:61473:60416:61504:61118", -- [15]
			"63500:62903:61473:61745", -- [16]
			"63500:62903:61473:60416:61504:61118:61511", -- [17]
			"63500:62903:61473:60416:61504", -- [18]
			"63500:62903:61473:60416", -- [19]
			"63500:62903:61473", -- [20]
			"63497:61512", -- [21]
			"58843:60231:62658:61759", -- [22]
			"58843:60231:62658", -- [23]
			"63500:62903:62901", -- [24]
			"63500:62903", -- [25]
			"63500:62903:62898", -- [26]
			"63500:62903:62898:62909", -- [27]
			"58843:60231:60230:59186:64310", -- [28]
			"63500:62903:65863", -- [29]
			"58843:60231:60230:59186:71939", -- [30]
			--["name"] = "Klaxxi'vess, Dread Wastes",
			["direct"] = "58843:59047:61122:63498:63500:63497:65511",
			["f"] = 0,
			["m"] = 422,
			["coord"] = 2397264188,
		},
		[60416] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:66227:59736:59735:59733", -- [4]
			"61745:61474:66227:59736:59735", -- [5]
			"61745:61474:66227:59736", -- [6]
			"61745:61474:66227", -- [7]
			"61745:61474:61759:60230", -- [8]
			"61745:61474:61759:62658:60231", -- [9]
			"61745:61474:60232", -- [10]
			"61745:61474:61759:62658:60231:59046", -- [11]
			"61473:62903:63500:63501:58843", -- [12]
			"61473:62903:63500:63501:58843:59047", -- [13]
			"61473:62903:63500:63501:58843:65189", -- [14]
			"61473:62903:63500:63501:58843:59047:60441", -- [15]
			"61745:61474", -- [16]
			"61504:61118", -- [17]
			"61504:61118:61511", -- [18]
			"61745:61474:61759", -- [19]
			"61745:61474:61759:62658", -- [20]
			"61512:62901", -- [21]
			"61473:62903", -- [22]
			"61512:62901:62898", -- [23]
			"61512:62901:62898:62909", -- [24]
			"61745:61122", -- [25]
			"61473:62903:63500:63501", -- [26]
			"61473:62903:63500:63501:63498", -- [27]
			"61473:62903:63500", -- [28]
			"61512:63497", -- [29]
			"61745:61474:61759:60230:59186:64310", -- [30]
			"61473:62903:63500:63501:65511", -- [31]
			"61512:62901:65863", -- [32]
			"61745:61474:61759:60230:59186:71939", -- [33]
			--["name"] = "Kota Basecamp, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "61745:61504:61473:61512",
			["coord"] = 1836691981,
		},
		[58843] = {
			"60231:60230:60952", -- [1]
			"60231:60230:59186", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60230:59186:59735:59733", -- [4]
			"60231:60230:59186:59735", -- [5]
			"60231:60230:60952:59736", -- [6]
			"60231:62658:61759:61474:66227", -- [7]
			"60231:60230", -- [8]
			"60231:60232", -- [9]
			"60231:59046", -- [10]
			"59047:60441", -- [11]
			"60231:62658:61759:61474", -- [12]
			"60231:62658:61759:61474:61118", -- [13]
			"60231:62658:61759:61474:61745", -- [14]
			"60231:62658:61759:61474:61118:61511", -- [15]
			"60231:62658:61759:61474:61504", -- [16]
			"63501:63500:62903:61473:60416", -- [17]
			"63501:63500:62903:61473", -- [18]
			"63501:63497:61512", -- [19]
			"60231:62658:61759", -- [20]
			"60231:62658", -- [21]
			"63501:63500:62903:62901", -- [22]
			"63501:63500:62903", -- [23]
			"63501:63500:62903:62898", -- [24]
			"63501:63500:62903:62898:62909", -- [25]
			"60231:61122", -- [26]
			"63501:63498", -- [27]
			"63501:63500", -- [28]
			"63501:63497", -- [29]
			"60231:60230:59186:64310", -- [30]
			"63501:65511", -- [31]
			"63501:63500:62903:65863", -- [32]
			"60231:60230:59186:71939", -- [33]
			--["name"] = "Stoneplow, Valley of the Four Winds",
			["m"] = 376,
			["f"] = 0,
			["direct"] = "60231:59047:65189:63501",
			["coord"] = 867145194,
		},
		[60231] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"62658:61759:61474:66227", -- [7]
			"58843:59047", -- [8]
			"59046:60441", -- [9]
			"62658:61759:61474", -- [10]
			"62658:61759:61474:61118", -- [11]
			"62658:61759:61474:61745", -- [12]
			"62658:61759:61474:61118:61511", -- [13]
			"62658:61759:61474:61504", -- [14]
			"62658:61759:61474:61745:60416", -- [15]
			"62658:61759:61474:61745:61473", -- [16]
			"62658:61759:61474:61745:60416:61512", -- [17]
			"62658:61759", -- [18]
			"61122:65863:62901", -- [19]
			"58843:63501:63500:62903", -- [20]
			"58843:63501:63500:62903:62898", -- [21]
			"58843:63501:63500:62903:62898:62909", -- [22]
			"58843:63501", -- [23]
			"58843:63501:63498", -- [24]
			"58843:63501:63500", -- [25]
			"58843:63501:63497", -- [26]
			"60230:59186:64310", -- [27]
			"58843:63501:65511", -- [28]
			"61122:65863", -- [29]
			"60230:59186:71939", -- [30]
			--["name"] = "Halfhill, Valley of the Four Winds",
			["direct"] = "60230:60232:59046:58843:65189:62658:61122",
			["f"] = 0,
			["m"] = 376,
			["coord"] = 2423292124,
		},
		[61745] = {
			"61474:61759:60230:60952", -- [1]
			"61474:61759:60230:59186", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:66227:59736:59735:59733", -- [4]
			"61474:66227:59736:59735", -- [5]
			"61474:66227:59736", -- [6]
			"61474:66227", -- [7]
			"61474:61759:60230", -- [8]
			"61474:61759:62658:60231", -- [9]
			"61474:60232", -- [10]
			"61474:61759:62658:60231:59046", -- [11]
			"61474:61759:62658:60231:58843", -- [12]
			"61474:61759:62658:60231:58843:59047", -- [13]
			"61474:61759:62658:60231:65189", -- [14]
			"61474:61759:62658:60231:59046:60441", -- [15]
			"60416:61512", -- [16]
			"61474:61759", -- [17]
			"61474:61759:62658", -- [18]
			"61473:62901", -- [19]
			"61473:62903", -- [20]
			"61473:62903:62898", -- [21]
			"61473:62903:62898:62909", -- [22]
			"61473:62903:63500:63501", -- [23]
			"61473:62903:63500:63501:63498", -- [24]
			"61473:62903:63500", -- [25]
			"61122:63497", -- [26]
			"61474:61759:60230:59186:64310", -- [27]
			"61473:62903:63500:63501:65511", -- [28]
			"61473:62903:65863", -- [29]
			"61474:61759:60230:59186:71939", -- [30]
			--["name"] = "Eastwind Rest, Kun-Lai Summit",
			["direct"] = "61474:61118:61511:61504:60416:61473:61122",
			["f"] = 0,
			["m"] = 379,
			["coord"] = 2682375861,
		},
		[59733] = {
			"59735:59736:60952", -- [1]
			"59735:59186", -- [2]
			"59735:59736", -- [3]
			"59735:59736:66227", -- [4]
			"59735:59186:60230", -- [5]
			"59735:59186:60230:60231", -- [6]
			"59735:59186:60230:60232", -- [7]
			"59735:59186:60230:59046", -- [8]
			"59735:59186:60230:60231:58843", -- [9]
			"59735:59186:60230:59046:59047", -- [10]
			"59735:59186:60230:60231:65189", -- [11]
			"59735:59186:60230:59046:60441", -- [12]
			"59735:59736:66227:61474", -- [13]
			"59735:59736:66227:61474:61118", -- [14]
			"59735:59736:66227:61474:61745", -- [15]
			"59735:59736:66227:61474:61118:61511", -- [16]
			"59735:59736:66227:61474:61504", -- [17]
			"59735:59736:66227:61474:61745:60416", -- [18]
			"59735:59736:66227:61474:61745:61473", -- [19]
			"59735:59736:66227:61474:61745:60416:61512", -- [20]
			"59735:59186:60230:61759", -- [21]
			"59735:59186:60230:62658", -- [22]
			"59735:59736:66227:61474:61745:61473:62901", -- [23]
			"59735:59736:66227:61474:61745:61473:62903", -- [24]
			"59735:59736:66227:61474:61745:61473:62903:62898", -- [25]
			"59735:59736:66227:61474:61745:61473:62903:62898:62909", -- [26]
			"59735:59736:66227:61122", -- [27]
			"59735:59186:60230:60231:58843:63501", -- [28]
			"59735:59186:60230:60231:58843:63501:63498", -- [29]
			"59735:59736:66227:61474:61745:61473:62903:63500", -- [30]
			"59735:59736:66227:61122:63497", -- [31]
			"59735:59186:64310", -- [32]
			"59735:59186:60230:60231:58843:63501:65511", -- [33]
			"59735:59736:66227:61474:61745:61473:62903:65863", -- [34]
			"59735:59186:71939", -- [35]
			--["name"] = "Sri-La Village, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59732:59735",
			["coord"] = 2380414099,
		},
		[59735] = {
			"59736:60952", -- [1]
			"59186:59732", -- [2]
			"59736:66227", -- [3]
			"59186:60230", -- [4]
			"59186:60230:60231", -- [5]
			"59186:60230:60232", -- [6]
			"59186:60230:59046", -- [7]
			"59186:60230:60231:58843", -- [8]
			"59186:60230:59046:59047", -- [9]
			"59186:60230:60231:65189", -- [10]
			"59186:60230:59046:60441", -- [11]
			"59736:66227:61474", -- [12]
			"59736:66227:61474:61118", -- [13]
			"59736:66227:61474:61745", -- [14]
			"59736:66227:61474:61118:61511", -- [15]
			"59736:66227:61474:61504", -- [16]
			"59736:66227:61474:61745:60416", -- [17]
			"59736:66227:61474:61745:61473", -- [18]
			"59736:66227:61474:61745:60416:61512", -- [19]
			"59186:60230:61759", -- [20]
			"59186:60230:62658", -- [21]
			"59736:66227:61474:61745:61473:62901", -- [22]
			"59736:66227:61474:61745:61473:62903", -- [23]
			"59736:66227:61474:61745:61473:62903:62898", -- [24]
			"59736:66227:61474:61745:61473:62903:62898:62909", -- [25]
			"59736:66227:61122", -- [26]
			"59186:60230:60231:58843:63501", -- [27]
			"59186:60230:60231:58843:63501:63498", -- [28]
			"59736:66227:61474:61745:61473:62903:63500", -- [29]
			"59736:66227:61122:63497", -- [30]
			"59186:64310", -- [31]
			"59186:60230:60231:58843:63501:65511", -- [32]
			"59736:66227:61474:61745:61473:62903:65863", -- [33]
			"59186:71939", -- [34]
			--["name"] = "Emperor's Omen, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59186:59733:59736",
			["coord"] = 2184266963,
		},
		[59046] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"60230:60952:66227", -- [7]
			"60231:58843", -- [8]
			"59047:65189", -- [9]
			"60231:62658:61759:61474", -- [10]
			"60231:62658:61759:61474:61118", -- [11]
			"60231:62658:61759:61474:61745", -- [12]
			"60231:62658:61759:61474:61118:61511", -- [13]
			"60231:62658:61759:61474:61504", -- [14]
			"60231:62658:61759:61474:61745:60416", -- [15]
			"60231:62658:61759:61474:61745:61473", -- [16]
			"60231:62658:61759:61474:61745:60416:61512", -- [17]
			"60231:62658:61759", -- [18]
			"60231:62658", -- [19]
			"60231:61122:65863:62901", -- [20]
			"60231:58843:63501:63500:62903", -- [21]
			"60231:58843:63501:63500:62903:62898", -- [22]
			"60231:58843:63501:63500:62903:62898:62909", -- [23]
			"60231:61122", -- [24]
			"60231:58843:63501", -- [25]
			"60231:58843:63501:63498", -- [26]
			"60231:58843:63501:63500", -- [27]
			"60231:58843:63501:63497", -- [28]
			"60230:59186:64310", -- [29]
			"60231:58843:63501:65511", -- [30]
			"60231:61122:65863", -- [31]
			"60230:59186:71939", -- [32]
			--["name"] = "Thunder Cleft, Krasarang Wilds",
			["direct"] = "60230:60231:60232:59047:60441",
			["f"] = 0,
			["m"] = 418,
			["coord"] = 2543992551,
		},
		[61759] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"61474:66227", -- [7]
			"62658:60231", -- [8]
			"60230:60232", -- [9]
			"62658:60231:59046", -- [10]
			"62658:60231:58843", -- [11]
			"62658:60231:58843:59047", -- [12]
			"62658:60231:65189", -- [13]
			"62658:60231:59046:60441", -- [14]
			"61474:61118", -- [15]
			"61474:61745", -- [16]
			"61474:61118:61511", -- [17]
			"61474:61504", -- [18]
			"61474:61745:60416", -- [19]
			"61474:61745:61473", -- [20]
			"61474:61745:60416:61512", -- [21]
			"61474:61745:61473:62901", -- [22]
			"61474:61745:61473:62903", -- [23]
			"61474:61745:61473:62903:62898", -- [24]
			"61474:61745:61473:62903:62898:62909", -- [25]
			"62658:61122", -- [26]
			"62658:60231:58843:63501", -- [27]
			"62658:60231:58843:63501:63498", -- [28]
			"62658:61122:63500", -- [29]
			"62658:61122:63497", -- [30]
			"60230:59186:64310", -- [31]
			"62658:60231:58843:63501:65511", -- [32]
			"62658:61122:65863", -- [33]
			"60230:59186:71939", -- [34]
			--["name"] = "Tavern in the Mists, The Veiled Stair",
			["m"] = 433,
			["f"] = 0,
			["direct"] = "60230:61474:62658",
			["coord"] = 2433204651,
		},
		[61511] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:66227:59736:59735:59733", -- [4]
			"61745:61474:66227:59736:59735", -- [5]
			"61745:61474:66227:59736", -- [6]
			"61745:61474:66227", -- [7]
			"61745:61474:61759:60230", -- [8]
			"61745:61474:61759:62658:60231", -- [9]
			"61745:61474:60232", -- [10]
			"61745:61474:61759:62658:60231:59046", -- [11]
			"61745:61474:61759:62658:60231:58843", -- [12]
			"61745:61474:61759:62658:60231:58843:59047", -- [13]
			"61745:61474:61759:62658:60231:65189", -- [14]
			"61745:61474:61759:62658:60231:59046:60441", -- [15]
			"61745:61474", -- [16]
			"61504:60416", -- [17]
			"61745:61473", -- [18]
			"61504:60416:61512", -- [19]
			"61745:61474:61759", -- [20]
			"61745:61474:61759:62658", -- [21]
			"61504:60416:61512:62901", -- [22]
			"61745:61473:62903", -- [23]
			"61504:60416:61512:62901:62898", -- [24]
			"61504:60416:61512:62901:62898:62909", -- [25]
			"61745:61122", -- [26]
			"61745:61473:62903:63500:63501", -- [27]
			"61745:61473:62903:63500:63501:63498", -- [28]
			"61745:61473:62903:63500", -- [29]
			"61745:61122:63497", -- [30]
			"61745:61474:61759:60230:59186:64310", -- [31]
			"61745:61473:62903:63500:63501:65511", -- [32]
			"61504:60416:61512:62901:65863", -- [33]
			"61745:61474:61759:60230:59186:71939", -- [34]
			--["name"] = "Zouchin Village, Kun-Lai Summit",
			["m"] = 379,
			["direct"] = "61118:61745:61504",
			["f"] = 0,
			["coord"] = 2681031944,
		},
		[62901] = {
			"61473:61745:61474:61759:60230:60952", -- [1]
			"61473:61745:61474:61759:60230:59186", -- [2]
			"61473:61745:61474:61759:60230:59186:59732", -- [3]
			"61473:61745:61474:66227:59736:59735:59733", -- [4]
			"61473:61745:61474:66227:59736:59735", -- [5]
			"61473:61745:61474:66227:59736", -- [6]
			"61473:61745:61474:66227", -- [7]
			"61473:61745:61474:61759:60230", -- [8]
			"65863:61122:60231", -- [9]
			"61473:61745:61474:60232", -- [10]
			"65863:61122:60231:59046", -- [11]
			"62903:63500:63501:58843", -- [12]
			"62903:63500:63501:58843:59047", -- [13]
			"62903:63500:63501:58843:65189", -- [14]
			"62903:63500:63501:58843:59047:60441", -- [15]
			"61473:61745:61474", -- [16]
			"61512:60416:61504:61118", -- [17]
			"61473:61745", -- [18]
			"61512:60416:61504:61118:61511", -- [19]
			"61512:60416:61504", -- [20]
			"61512:60416", -- [21]
			"61473:61745:61474:61759", -- [22]
			"61473:61745:61474:61759:62658", -- [23]
			"62898:62909", -- [24]
			"65863:61122", -- [25]
			"62903:63500:63501", -- [26]
			"62903:63500:63501:63498", -- [27]
			"62903:63500", -- [28]
			"62903:63500:63497", -- [29]
			"61473:61745:61474:61759:60230:59186:64310", -- [30]
			"62903:63500:63501:65511", -- [31]
			"61473:61745:61474:61759:60230:59186:71939", -- [32]
			--["name"] = "Longying Outpost, Townlong Steppes",
			["direct"] = "61473:61512:62903:62898:65863",
			["m"] = 388,
			["coord"] = 3054473921,
			["f"] = 0,
		},
		[59186] = {
			"59735:59733", -- [1]
			"60230:60231", -- [2]
			"60230:60232", -- [3]
			"60230:59046", -- [4]
			"60230:60231:58843", -- [5]
			"60230:59046:59047", -- [6]
			"60230:60231:65189", -- [7]
			"60230:59046:60441", -- [8]
			"60230:61759:61474", -- [9]
			"60230:61759:61474:61118", -- [10]
			"60230:61759:61474:61745", -- [11]
			"60230:61759:61474:61118:61511", -- [12]
			"60230:61759:61474:61504", -- [13]
			"60230:61759:61474:61745:60416", -- [14]
			"60230:61759:61474:61745:61473", -- [15]
			"60230:61759:61474:61745:60416:61512", -- [16]
			"60230:61759", -- [17]
			"60230:62658", -- [18]
			"61122:65863:62901", -- [19]
			"60230:61759:61474:61745:61473:62903", -- [20]
			"60230:61759:61474:61745:61473:62903:62898", -- [21]
			"60230:61759:61474:61745:61473:62903:62898:62909", -- [22]
			"60230:60231:58843:63501", -- [23]
			"60230:60231:58843:63501:63498", -- [24]
			"61122:63500", -- [25]
			"61122:63497", -- [26]
			"60230:60231:58843:63501:65511", -- [27]
			"61122:65863", -- [28]
			--["name"] = "Dawn's Blossom, Jade Forest",
			["direct"] = "60952:59732:59735:59736:66227:60230:61122:64310:71939",
			["m"] = 371,
			["coord"] = 2019849771,
			["f"] = 0,
		},
		[60952] = {
			"59186:59732", -- [1]
			"59736:59735:59733", -- [2]
			"59736:59735", -- [3]
			"60230:60231", -- [4]
			"60230:60232", -- [5]
			"60230:59046", -- [6]
			"60230:60231:58843", -- [7]
			"60230:59046:59047", -- [8]
			"60230:60231:65189", -- [9]
			"60230:59046:60441", -- [10]
			"60230:61759:61474", -- [11]
			"60230:61759:61474:61118", -- [12]
			"60230:61759:61474:61745", -- [13]
			"60230:61759:61474:61118:61511", -- [14]
			"60230:61759:61474:61504", -- [15]
			"60230:61759:61474:61745:60416", -- [16]
			"60230:61759:61474:61745:61473", -- [17]
			"60230:61759:61474:61745:60416:61512", -- [18]
			"60230:61759", -- [19]
			"60230:62658", -- [20]
			"60230:62658:61122:65863:62901", -- [21]
			"60230:61759:61474:61745:61473:62903", -- [22]
			"60230:61759:61474:61745:61473:62903:62898", -- [23]
			"60230:61759:61474:61745:61473:62903:62898:62909", -- [24]
			"60230:62658:61122", -- [25]
			"60230:60231:58843:63501", -- [26]
			"60230:60231:58843:63501:63498", -- [27]
			"60230:62658:61122:63500", -- [28]
			"60230:62658:61122:63497", -- [29]
			"60230:60231:58843:63501:65511", -- [30]
			"60230:62658:61122:65863", -- [31]
			"59186:71939", -- [32]
			--["name"] = "Grookin Hill, Jade Forest",
			["direct"] = "59186:59736:66227:60230:64310",
			["f"] = 0,
			["m"] = 371,
			["coord"] = 1193048794,
		},
		[62909] = {
			"62898:62903:61473:61745:61474:61759:60230:60952", -- [1]
			"62898:62903:61473:61745:61474:61759:60230:59186", -- [2]
			"62898:62903:61473:61745:61474:61759:60230:59186:59732", -- [3]
			"62898:62903:61473:61745:61474:66227:59736:59735:59733", -- [4]
			"62898:62903:61473:61745:61474:66227:59736:59735", -- [5]
			"62898:62903:61473:61745:61474:66227:59736", -- [6]
			"62898:62903:61473:61745:61474:66227", -- [7]
			"62898:62903:61473:61745:61474:61759:60230", -- [8]
			"62898:62903:63500:63501:58843:60231", -- [9]
			"62898:62903:63500:63501:58843:60231:60232", -- [10]
			"62898:62903:63500:63501:58843:60231:59046", -- [11]
			"62898:62903:63500:63501:58843", -- [12]
			"62898:62903:63500:63501:58843:59047", -- [13]
			"62898:62903:63500:63501:58843:65189", -- [14]
			"62898:62903:63500:63501:58843:59047:60441", -- [15]
			"62898:62903:61473:61745:61474", -- [16]
			"62898:62901:61512:60416:61504:61118", -- [17]
			"62898:62903:61473:61745", -- [18]
			"62898:62901:61512:60416:61504:61118:61511", -- [19]
			"62898:62901:61512:60416:61504", -- [20]
			"62898:62901:61512:60416", -- [21]
			"62898:62903:61473", -- [22]
			"62898:62901:61512", -- [23]
			"62898:62903:61473:61745:61474:61759", -- [24]
			"62898:62903:61473:61745:61474:61759:62658", -- [25]
			"62898:62901", -- [26]
			"62898:62903", -- [27]
			"62898:62903:65863:61122", -- [28]
			"62898:62903:63500:63501", -- [29]
			"62898:62903:63500:63501:63498", -- [30]
			"62898:62903:63500", -- [31]
			"62898:62903:63500:63497", -- [32]
			"62898:62903:61473:61745:61474:61759:60230:59186:64310", -- [33]
			"62898:62903:63500:63501:65511", -- [34]
			"62898:62903:65863", -- [35]
			"62898:62903:61473:61745:61474:61759:60230:59186:71939", -- [36]
			--["name"] = "Shado-Pan Garrison, Townlong Steppes",
			["m"] = 388,
			["f"] = 0,
			["direct"] = "62898",
			["coord"] = 2149824560,
		},
		[65189] = {
			"60231:60230:60952", -- [1]
			"60231:60230:59186", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60230:59186:59735:59733", -- [4]
			"60231:60230:59186:59735", -- [5]
			"60231:60230:60952:59736", -- [6]
			"60231:62658:61759:61474:66227", -- [7]
			"60231:60230", -- [8]
			"59047:59046:60232", -- [9]
			"59047:59046", -- [10]
			"60231:62658:61759:61474", -- [11]
			"60231:62658:61759:61474:61118", -- [12]
			"60231:62658:61759:61474:61745", -- [13]
			"60231:62658:61759:61474:61118:61511", -- [14]
			"60231:62658:61759:61474:61504", -- [15]
			"59047:63501:63500:62903:61473:60416", -- [16]
			"59047:63501:63500:62903:61473", -- [17]
			"59047:63501:63497:61512", -- [18]
			"60231:62658:61759", -- [19]
			"60231:62658", -- [20]
			"59047:63501:63500:62903:62901", -- [21]
			"59047:63501:63500:62903", -- [22]
			"59047:63501:63500:62903:62898", -- [23]
			"59047:63501:63500:62903:62898:62909", -- [24]
			"60231:61122", -- [25]
			"59047:63501", -- [26]
			"59047:63501:63498", -- [27]
			"59047:63501:63500", -- [28]
			"59047:63501:63497", -- [29]
			"60231:60230:59186:64310", -- [30]
			"59047:63501:65511", -- [31]
			"59047:63501:63500:62903:65863", -- [32]
			"60231:60230:59186:71939", -- [33]
			--["name"] = "Cradle of Chi-Ji, Krasarang Wilds",
			["m"] = 418,
			["f"] = 0,
			["direct"] = "60231:58843:59047:60441",
			["coord"] = 1341694345,
		},
		[61474] = {
			"61759:60230:60952", -- [1]
			"61759:60230:59186", -- [2]
			"61759:60230:59186:59732", -- [3]
			"66227:59736:59735:59733", -- [4]
			"66227:59736:59735", -- [5]
			"66227:59736", -- [6]
			"61759:60230", -- [7]
			"61759:62658:60231", -- [8]
			"61759:62658:60231:59046", -- [9]
			"61759:62658:60231:58843", -- [10]
			"61759:62658:60231:58843:59047", -- [11]
			"61759:62658:60231:65189", -- [12]
			"61759:62658:60231:59046:60441", -- [13]
			"61118:61511", -- [14]
			"61745:60416", -- [15]
			"61745:61473", -- [16]
			"61745:60416:61512", -- [17]
			"61759:62658", -- [18]
			"61745:61473:62901", -- [19]
			"61745:61473:62903", -- [20]
			"61745:61473:62903:62898", -- [21]
			"61745:61473:62903:62898:62909", -- [22]
			"61745:61473:62903:63500:63501", -- [23]
			"61122:63497:63498", -- [24]
			"61745:61473:62903:63500", -- [25]
			"61122:63497", -- [26]
			"61759:60230:59186:64310", -- [27]
			"61745:61473:62903:63500:63501:65511", -- [28]
			"61745:61473:62903:65863", -- [29]
			"61759:60230:59186:71939", -- [30]
			--["name"] = "Binan Village, Kun-Lai Summit",
			["direct"] = "66227:60232:61118:61745:61504:61759:61122",
			["f"] = 0,
			["m"] = 379,
			["coord"] = 3113808134,
		},
		[61512] = {
			"60416:61745:61474:61759:60230:60952", -- [1]
			"60416:61745:61474:61759:60230:59186", -- [2]
			"60416:61745:61474:61759:60230:59186:59732", -- [3]
			"60416:61745:61474:66227:59736:59735:59733", -- [4]
			"60416:61745:61474:66227:59736:59735", -- [5]
			"60416:61745:61474:66227:59736", -- [6]
			"60416:61745:61474:66227", -- [7]
			"60416:61745:61474:61759:60230", -- [8]
			"60416:61745:61474:61759:62658:60231", -- [9]
			"60416:61745:61474:60232", -- [10]
			"60416:61745:61474:61759:62658:60231:59046", -- [11]
			"62901:62903:63500:63501:58843", -- [12]
			"62901:62903:63500:63501:58843:59047", -- [13]
			"62901:62903:63500:63501:58843:65189", -- [14]
			"62901:62903:63500:63501:58843:59047:60441", -- [15]
			"60416:61745:61474", -- [16]
			"60416:61504:61118", -- [17]
			"60416:61745", -- [18]
			"60416:61504:61118:61511", -- [19]
			"60416:61504", -- [20]
			"60416:61473", -- [21]
			"60416:61745:61474:61759", -- [22]
			"60416:61745:61474:61759:62658", -- [23]
			"62901:62903", -- [24]
			"62901:62898", -- [25]
			"62901:62898:62909", -- [26]
			"62901:65863:61122", -- [27]
			"62901:62903:63500:63501", -- [28]
			"63497:63498", -- [29]
			"62901:62903:63500", -- [30]
			"60416:61745:61474:61759:60230:59186:64310", -- [31]
			"62901:62903:63500:63501:65511", -- [32]
			"62901:65863", -- [33]
			"60416:61745:61474:61759:60230:59186:71939", -- [34]
			--["name"] = "Winter's Blossom, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "60416:62901:63497",
			["coord"] = 1483577174,
		},
		[63498] = {
			"63501:58843:60231:60230:60952", -- [1]
			"63501:58843:60231:60230:59186", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60230:59186:59735:59733", -- [4]
			"63501:58843:60231:60230:59186:59735", -- [5]
			"63501:58843:60231:60230:60952:59736", -- [6]
			"63497:61122:66227", -- [7]
			"63501:58843:60231:60230", -- [8]
			"63501:58843:60231", -- [9]
			"63501:58843:60231:60232", -- [10]
			"63501:58843:60231:59046", -- [11]
			"63501:58843", -- [12]
			"63501:58843:59047", -- [13]
			"63501:58843:65189", -- [14]
			"63501:58843:59047:60441", -- [15]
			"63497:61122:61474", -- [16]
			"63501:63500:62903:61473:60416:61504:61118", -- [17]
			"63501:63500:62903:61473:61745", -- [18]
			"63501:63500:62903:61473:60416:61504:61118:61511", -- [19]
			"63501:63500:62903:61473:60416:61504", -- [20]
			"63501:63500:62903:61473:60416", -- [21]
			"63501:63500:62903:61473", -- [22]
			"63497:61512", -- [23]
			"63501:58843:60231:62658:61759", -- [24]
			"63501:58843:60231:62658", -- [25]
			"63501:63500:62903:62901", -- [26]
			"63501:63500:62903", -- [27]
			"63501:63500:62903:62898", -- [28]
			"63501:63500:62903:62898:62909", -- [29]
			"63497:61122", -- [30]
			"63501:63500", -- [31]
			"63501:58843:60231:60230:59186:64310", -- [32]
			"63501:63500:62903:65863", -- [33]
			"63501:58843:60231:60230:59186:71939", -- [34]
			--["name"] = "Soggy's Gamble, Dread Wastes",
			["m"] = 422,
			["f"] = 0,
			["direct"] = "63501:63497:65511",
			["coord"] = 2410197898,
		},
		[63500] = {
			"63501:58843:60231:60230:60952", -- [1]
			"63501:58843:60231:60230:59186", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"62903:61473:61745:61474:66227:59736:59735:59733", -- [4]
			"62903:61473:61745:61474:66227:59736:59735", -- [5]
			"62903:61473:61745:61474:66227:59736", -- [6]
			"62903:61473:61745:61474:66227", -- [7]
			"63501:58843:60231:60230", -- [8]
			"63501:58843:60231", -- [9]
			"63501:58843:60231:60232", -- [10]
			"63501:58843:60231:59046", -- [11]
			"63501:58843", -- [12]
			"63501:58843:59047", -- [13]
			"63501:58843:65189", -- [14]
			"63501:58843:59047:60441", -- [15]
			"62903:61473:61745:61474", -- [16]
			"62903:61473:60416:61504:61118", -- [17]
			"62903:61473:61745", -- [18]
			"62903:61473:60416:61504:61118:61511", -- [19]
			"62903:61473:60416:61504", -- [20]
			"62903:61473:60416", -- [21]
			"62903:61473", -- [22]
			"62903:62901:61512", -- [23]
			"63501:58843:60231:62658:61759", -- [24]
			"63501:58843:60231:62658", -- [25]
			"62903:62901", -- [26]
			"62903:62898", -- [27]
			"62903:62898:62909", -- [28]
			"63501:63498", -- [29]
			"63501:58843:60231:60230:59186:64310", -- [30]
			"63501:65511", -- [31]
			"62903:65863", -- [32]
			"63501:58843:60231:60230:59186:71939", -- [33]
			--["name"] = "The Sunset Brewgarden, Dread Wastes",
			["m"] = 422,
			["f"] = 0,
			["direct"] = "62903:61122:63501:63497",
			["coord"] = 2156797729,
		},
		[62898] = {
			"62903:61473:61745:61474:61759:60230:60952", -- [1]
			"62903:61473:61745:61474:61759:60230:59186", -- [2]
			"62903:61473:61745:61474:61759:60230:59186:59732", -- [3]
			"62903:61473:61745:61474:66227:59736:59735:59733", -- [4]
			"62903:61473:61745:61474:66227:59736:59735", -- [5]
			"62903:61473:61745:61474:66227:59736", -- [6]
			"62903:61473:61745:61474:66227", -- [7]
			"62903:61473:61745:61474:61759:60230", -- [8]
			"62903:63500:63501:58843:60231", -- [9]
			"62903:63500:63501:58843:60231:60232", -- [10]
			"62903:63500:63501:58843:60231:59046", -- [11]
			"62903:63500:63501:58843", -- [12]
			"62903:63500:63501:58843:59047", -- [13]
			"62903:63500:63501:58843:65189", -- [14]
			"62903:63500:63501:58843:59047:60441", -- [15]
			"62903:61473:61745:61474", -- [16]
			"62901:61512:60416:61504:61118", -- [17]
			"62903:61473:61745", -- [18]
			"62901:61512:60416:61504:61118:61511", -- [19]
			"62901:61512:60416:61504", -- [20]
			"62901:61512:60416", -- [21]
			"62903:61473", -- [22]
			"62901:61512", -- [23]
			"62903:61473:61745:61474:61759", -- [24]
			"62903:61473:61745:61474:61759:62658", -- [25]
			"62903:65863:61122", -- [26]
			"62903:63500:63501", -- [27]
			"62903:63500:63501:63498", -- [28]
			"62903:63500", -- [29]
			"62903:63500:63497", -- [30]
			"62903:61473:61745:61474:61759:60230:59186:64310", -- [31]
			"62903:63500:63501:65511", -- [32]
			"62903:65863", -- [33]
			"62903:61473:61745:61474:61759:60230:59186:71939", -- [34]
			--["name"] = "Rensai's Watchpost, Townlong Steppes",
			["m"] = 388,
			["f"] = 0,
			["direct"] = "62901:62903:62909",
			["coord"] = 2329659992,
		},
		[61504] = {
			"61474:61759:60230:60952", -- [1]
			"61474:61759:60230:59186", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:66227:59736:59735:59733", -- [4]
			"61474:66227:59736:59735", -- [5]
			"61474:66227:59736", -- [6]
			"61474:66227", -- [7]
			"61474:61759:60230", -- [8]
			"61474:61759:62658:60231", -- [9]
			"61474:60232", -- [10]
			"61474:61759:62658:60231:59046", -- [11]
			"61474:61759:62658:60231:58843", -- [12]
			"61474:61759:62658:60231:58843:59047", -- [13]
			"61474:61759:62658:60231:65189", -- [14]
			"61474:61759:62658:60231:59046:60441", -- [15]
			"60416:61473", -- [16]
			"60416:61512", -- [17]
			"61474:61759", -- [18]
			"61474:61759:62658", -- [19]
			"60416:61512:62901", -- [20]
			"60416:61473:62903", -- [21]
			"60416:61512:62901:62898", -- [22]
			"60416:61512:62901:62898:62909", -- [23]
			"61745:61122", -- [24]
			"60416:61473:62903:63500:63501", -- [25]
			"60416:61473:62903:63500:63501:63498", -- [26]
			"60416:61473:62903:63500", -- [27]
			"61745:61122:63497", -- [28]
			"61474:61759:60230:59186:64310", -- [29]
			"60416:61473:62903:63500:63501:65511", -- [30]
			"60416:61512:62901:65863", -- [31]
			"61474:61759:60230:59186:71939", -- [32]
			--["name"] = "One Keg, Kun-Lai Summit",
			["direct"] = "61474:61118:61745:61511:60416",
			["f"] = 0,
			["m"] = 379,
			["coord"] = 2481101060,
		},
		[60230] = {
			"59186:59732", -- [1]
			"59186:59735:59733", -- [2]
			"59186:59735", -- [3]
			"60952:59736", -- [4]
			"60952:66227", -- [5]
			"60231:58843", -- [6]
			"59046:59047", -- [7]
			"60231:65189", -- [8]
			"59046:60441", -- [9]
			"61759:61474", -- [10]
			"61759:61474:61118", -- [11]
			"61759:61474:61745", -- [12]
			"61759:61474:61118:61511", -- [13]
			"61759:61474:61504", -- [14]
			"61759:61474:61745:60416", -- [15]
			"61759:61474:61745:61473", -- [16]
			"61759:61474:61745:60416:61512", -- [17]
			"62658:61122:65863:62901", -- [18]
			"61759:61474:61745:61473:62903", -- [19]
			"61759:61474:61745:61473:62903:62898", -- [20]
			"61759:61474:61745:61473:62903:62898:62909", -- [21]
			"60231:58843:63501", -- [22]
			"60231:58843:63501:63498", -- [23]
			"62658:61122:63500", -- [24]
			"62658:61122:63497", -- [25]
			"59186:64310", -- [26]
			"60231:58843:63501:65511", -- [27]
			"62658:61122:65863", -- [28]
			"59186:71939", -- [29]
			--["name"] = "Pang's Stead, Valley of the Four Winds",
			["direct"] = "60952:59186:60231:60232:59046:61759:62658:61122",
			["f"] = 0,
			["m"] = 376,
			["coord"] = 3629594111,
		},
		[60232] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"60230:60952:66227", -- [7]
			"60231:58843", -- [8]
			"59046:59047", -- [9]
			"60231:65189", -- [10]
			"59046:60441", -- [11]
			"61474:61118", -- [12]
			"61474:61745", -- [13]
			"61474:61118:61511", -- [14]
			"61474:61504", -- [15]
			"61474:61745:60416", -- [16]
			"61474:61745:61473", -- [17]
			"61474:61745:60416:61512", -- [18]
			"60230:61759", -- [19]
			"60230:62658", -- [20]
			"60231:61122:65863:62901", -- [21]
			"61474:61745:61473:62903", -- [22]
			"61474:61745:61473:62903:62898", -- [23]
			"61474:61745:61473:62903:62898:62909", -- [24]
			"60231:61122", -- [25]
			"60231:58843:63501", -- [26]
			"60231:58843:63501:63498", -- [27]
			"60231:58843:63501:63500", -- [28]
			"60231:58843:63501:63497", -- [29]
			"60230:59186:64310", -- [30]
			"60231:58843:63501:65511", -- [31]
			"60231:61122:65863", -- [32]
			"60230:59186:71939", -- [33]
			--["name"] = "Zhu's Watch, Krasarang Wilds",
			["m"] = 418,
			["f"] = 0,
			["direct"] = "60230:60231:59046:61474",
			["coord"] = 3294762427,
		},
		[62903] = {
			"61473:61745:61474:61759:60230:60952", -- [1]
			"61473:61745:61474:61759:60230:59186", -- [2]
			"61473:61745:61474:61759:60230:59186:59732", -- [3]
			"61473:61745:61474:66227:59736:59735:59733", -- [4]
			"61473:61745:61474:66227:59736:59735", -- [5]
			"61473:61745:61474:66227:59736", -- [6]
			"61473:61745:61474:66227", -- [7]
			"61473:61745:61474:61759:60230", -- [8]
			"63500:63501:58843:60231", -- [9]
			"63500:63501:58843:60231:60232", -- [10]
			"63500:63501:58843:60231:59046", -- [11]
			"63500:63501:58843", -- [12]
			"63500:63501:58843:59047", -- [13]
			"63500:63501:58843:65189", -- [14]
			"63500:63501:58843:59047:60441", -- [15]
			"61473:61745:61474", -- [16]
			"61473:60416:61504:61118", -- [17]
			"61473:61745", -- [18]
			"61473:60416:61504:61118:61511", -- [19]
			"61473:60416:61504", -- [20]
			"61473:60416", -- [21]
			"62901:61512", -- [22]
			"61473:61745:61474:61759", -- [23]
			"61473:61745:61474:61759:62658", -- [24]
			"62898:62909", -- [25]
			"65863:61122", -- [26]
			"63500:63501", -- [27]
			"63500:63501:63498", -- [28]
			"63500:63497", -- [29]
			"61473:61745:61474:61759:60230:59186:64310", -- [30]
			"63500:63501:65511", -- [31]
			"61473:61745:61474:61759:60230:59186:71939", -- [32]
			--["name"] = "Gao-Ran Battlefront, Townlong Steppes",
			["direct"] = "61473:62901:62898:63500:65863",
			["f"] = 0,
			["m"] = 388,
			["coord"] = 3196440686,
		},
		[61118] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:66227:59736:59735:59733", -- [4]
			"61745:61474:66227:59736:59735", -- [5]
			"61745:61474:66227:59736", -- [6]
			"61745:61474:66227", -- [7]
			"61745:61474:61759:60230", -- [8]
			"61745:61474:61759:62658:60231", -- [9]
			"61745:61474:60232", -- [10]
			"61745:61474:61759:62658:60231:59046", -- [11]
			"61745:61474:61759:62658:60231:58843", -- [12]
			"61745:61474:61759:62658:60231:58843:59047", -- [13]
			"61745:61474:61759:62658:60231:65189", -- [14]
			"61745:61474:61759:62658:60231:59046:60441", -- [15]
			"61504:60416", -- [16]
			"61745:61473", -- [17]
			"61504:60416:61512", -- [18]
			"61745:61474:61759", -- [19]
			"61745:61474:61759:62658", -- [20]
			"61504:60416:61512:62901", -- [21]
			"61745:61473:62903", -- [22]
			"61745:61473:62903:62898", -- [23]
			"61745:61473:62903:62898:62909", -- [24]
			"61745:61122", -- [25]
			"61745:61473:62903:63500:63501", -- [26]
			"61745:61473:62903:63500:63501:63498", -- [27]
			"61745:61473:62903:63500", -- [28]
			"61745:61122:63497", -- [29]
			"61745:61474:61759:60230:59186:64310", -- [30]
			"61745:61473:62903:63500:63501:65511", -- [31]
			"61504:60416:61512:62901:65863", -- [32]
			"61745:61474:61759:60230:59186:71939", -- [33]
			--["name"] = "Temple of the White Tiger, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "61474:61745:61511:61504",
			["coord"] = 2847310268,
		},
		[59736] = {
			"59186:59732", -- [1]
			"59735:59733", -- [2]
			"60952:60230", -- [3]
			"60952:60230:60231", -- [4]
			"60952:60230:60232", -- [5]
			"60952:60230:59046", -- [6]
			"60952:60230:60231:58843", -- [7]
			"60952:60230:59046:59047", -- [8]
			"60952:60230:60231:65189", -- [9]
			"60952:60230:59046:60441", -- [10]
			"66227:61474", -- [11]
			"66227:61474:61118", -- [12]
			"66227:61474:61745", -- [13]
			"66227:61474:61118:61511", -- [14]
			"66227:61474:61504", -- [15]
			"66227:61474:61745:60416", -- [16]
			"66227:61474:61745:61473", -- [17]
			"66227:61474:61745:60416:61512", -- [18]
			"60952:60230:61759", -- [19]
			"60952:60230:62658", -- [20]
			"66227:61474:61745:61473:62901", -- [21]
			"66227:61474:61745:61473:62903", -- [22]
			"66227:61474:61745:61473:62903:62898", -- [23]
			"66227:61474:61745:61473:62903:62898:62909", -- [24]
			"66227:61122", -- [25]
			"60952:60230:60231:58843:63501", -- [26]
			"60952:60230:60231:58843:63501:63498", -- [27]
			"66227:61474:61745:61473:62903:63500", -- [28]
			"66227:61122:63497", -- [29]
			"59186:64310", -- [30]
			"60952:60230:60231:58843:63501:65511", -- [31]
			"66227:61474:61745:61473:62903:65863", -- [32]
			"59186:71939", -- [33]
			--["name"] = "Tian Monastery, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "60952:59186:59735:66227",
			["coord"] = 1871527691,
		},
		[61122] = {
			"60230:60952", -- [1]
			"60230:59186:59732", -- [2]
			"66227:59736:59735:59733", -- [3]
			"66227:59736:59735", -- [4]
			"66227:59736", -- [5]
			"60231:60232", -- [6]
			"60231:59046", -- [7]
			"60231:58843", -- [8]
			"60231:58843:59047", -- [9]
			"60231:65189", -- [10]
			"60231:59046:60441", -- [11]
			"61745:61118", -- [12]
			"61745:61511", -- [13]
			"61745:61504", -- [14]
			"61745:60416", -- [15]
			"61745:61473", -- [16]
			"65863:62901:61512", -- [17]
			"62658:61759", -- [18]
			"65863:62901", -- [19]
			"65863:62903", -- [20]
			"65863:62901:62898", -- [21]
			"65863:62901:62898:62909", -- [22]
			"63497:63498", -- [23]
			"60230:59186:64310", -- [24]
			"63501:65511", -- [25]
			"60230:59186:71939", -- [26]
			--["name"] = "Shrine of Two Moons, Vale of Eternal Blossoms",
			["direct"] = "59186:66227:60230:60231:61474:61745:62658:63501:63500:63497:65863",
			["f"] = 0,
			["m"] = 390,
			["coord"] = 2690660296,
		},
		[59732] = {
			"59186:60952", -- [1]
			"59186:59735", -- [2]
			"59186:59736", -- [3]
			"59186:66227", -- [4]
			"59186:60230", -- [5]
			"59186:60230:60231", -- [6]
			"59186:60230:60232", -- [7]
			"59186:60230:59046", -- [8]
			"59186:60230:60231:58843", -- [9]
			"59186:60230:59046:59047", -- [10]
			"59186:60230:60231:65189", -- [11]
			"59186:60230:59046:60441", -- [12]
			"59186:60230:61759:61474", -- [13]
			"59186:60230:61759:61474:61118", -- [14]
			"59186:60230:61759:61474:61745", -- [15]
			"59186:60230:61759:61474:61118:61511", -- [16]
			"59186:60230:61759:61474:61504", -- [17]
			"59186:60230:61759:61474:61745:60416", -- [18]
			"59186:60230:61759:61474:61745:61473", -- [19]
			"59186:60230:61759:61474:61745:60416:61512", -- [20]
			"59186:60230:61759", -- [21]
			"59186:60230:62658", -- [22]
			"59186:61122:65863:62901", -- [23]
			"59186:60230:61759:61474:61745:61473:62903", -- [24]
			"59186:60230:61759:61474:61745:61473:62903:62898", -- [25]
			"59186:60230:61759:61474:61745:61473:62903:62898:62909", -- [26]
			"59186:61122", -- [27]
			"59186:60230:60231:58843:63501", -- [28]
			"59186:60230:60231:58843:63501:63498", -- [29]
			"59186:61122:63500", -- [30]
			"59186:61122:63497", -- [31]
			"59186:64310", -- [32]
			"59186:60230:60231:58843:63501:65511", -- [33]
			"59186:61122:65863", -- [34]
			"59186:71939", -- [35]
			--["name"] = "The Arboretum, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59186:59733",
			["coord"] = 2449305813,
		},
		[59047] = {
			"59046:60230:60952", -- [1]
			"59046:60230:59186", -- [2]
			"59046:60230:59186:59732", -- [3]
			"59046:60230:59186:59735:59733", -- [4]
			"59046:60230:59186:59735", -- [5]
			"59046:60230:60952:59736", -- [6]
			"59046:60230:60952:66227", -- [7]
			"59046:60230", -- [8]
			"59046:60231", -- [9]
			"59046:60232", -- [10]
			"59046:60231:62658:61759:61474", -- [11]
			"59046:60231:62658:61759:61474:61118", -- [12]
			"59046:60231:62658:61759:61474:61745", -- [13]
			"59046:60231:62658:61759:61474:61118:61511", -- [14]
			"59046:60231:62658:61759:61474:61504", -- [15]
			"63501:63500:62903:61473:60416", -- [16]
			"63501:63500:62903:61473", -- [17]
			"63501:63497:61512", -- [18]
			"59046:60231:62658:61759", -- [19]
			"59046:60231:62658", -- [20]
			"63501:63500:62903:62901", -- [21]
			"63501:63500:62903", -- [22]
			"63501:63500:62903:62898", -- [23]
			"63501:63500:62903:62898:62909", -- [24]
			"59046:60231:61122", -- [25]
			"63501:63498", -- [26]
			"63501:63500", -- [27]
			"63501:63497", -- [28]
			"59046:60230:59186:64310", -- [29]
			"63501:65511", -- [30]
			"63501:63500:62903:65863", -- [31]
			"59046:60230:59186:71939", -- [32]
			--["name"] = "Dawnchaser Retreat, Krasarang Wilds",
			["direct"] = "59046:58843:65189:60441:63501",
			["f"] = 0,
			["m"] = 418,
			["coord"] = 1243906316,
		},
		[71939] = {
			"59186:60952", -- [1]
			"59186:59732", -- [2]
			"59186:59735:59733", -- [3]
			"59186:59735", -- [4]
			"59186:59736", -- [5]
			"59186:66227", -- [6]
			"59186:60230", -- [7]
			"59186:60230:60231", -- [8]
			"59186:60230:60232", -- [9]
			"59186:60230:59046", -- [10]
			"59186:60230:60231:58843", -- [11]
			"59186:60230:59046:59047", -- [12]
			"59186:60230:60231:65189", -- [13]
			"59186:60230:59046:60441", -- [14]
			"59186:60230:61759:61474", -- [15]
			"59186:60230:61759:61474:61118", -- [16]
			"59186:60230:61759:61474:61745", -- [17]
			"59186:60230:61759:61474:61118:61511", -- [18]
			"59186:60230:61759:61474:61504", -- [19]
			"59186:60230:61759:61474:61745:60416", -- [20]
			"59186:60230:61759:61474:61745:61473", -- [21]
			"59186:60230:61759:61474:61745:60416:61512", -- [22]
			"59186:60230:61759", -- [23]
			"59186:60230:62658", -- [24]
			"59186:61122:65863:62901", -- [25]
			"59186:60230:61759:61474:61745:61473:62903", -- [26]
			"59186:60230:61759:61474:61745:61473:62903:62898", -- [27]
			"59186:60230:61759:61474:61745:61473:62903:62898:62909", -- [28]
			"59186:61122", -- [29]
			"59186:60230:60231:58843:63501", -- [30]
			"59186:60230:60231:58843:63501:63498", -- [31]
			"59186:61122:63500", -- [32]
			"59186:61122:63497", -- [33]
			"59186:64310", -- [34]
			"59186:60230:60231:58843:63501:65511", -- [35]
			"59186:61122:65863", -- [36]
			--["name"] = "Huojin Landing, Timeless Isle",
			["m"] = 554,
			["f"] = 0,
			["direct"] = "59186",
			["coord"] = 940008994,
		},
		[66227] = {
			"59186:59732", -- [1]
			"59736:59735:59733", -- [2]
			"59736:59735", -- [3]
			"60952:60230", -- [4]
			"61474:61759:62658:60231", -- [5]
			"60952:60230:60232", -- [6]
			"60952:60230:59046", -- [7]
			"61474:61759:62658:60231:58843", -- [8]
			"61474:61759:62658:60231:58843:59047", -- [9]
			"61474:61759:62658:60231:65189", -- [10]
			"60952:60230:59046:60441", -- [11]
			"61474:61118", -- [12]
			"61474:61745", -- [13]
			"61474:61118:61511", -- [14]
			"61474:61504", -- [15]
			"61474:61745:60416", -- [16]
			"61474:61745:61473", -- [17]
			"61474:61745:60416:61512", -- [18]
			"61474:61759", -- [19]
			"61474:61759:62658", -- [20]
			"61474:61745:61473:62901", -- [21]
			"61474:61745:61473:62903", -- [22]
			"61474:61745:61473:62903:62898", -- [23]
			"61474:61745:61473:62903:62898:62909", -- [24]
			"61122:63501", -- [25]
			"61122:63497:63498", -- [26]
			"61474:61745:61473:62903:63500", -- [27]
			"61122:63497", -- [28]
			"59186:64310", -- [29]
			"61122:63501:65511", -- [30]
			"61474:61745:61473:62903:65863", -- [31]
			"59186:71939", -- [32]
			--["name"] = "Honeydew Village, Jade Forest",
			["direct"] = "60952:59186:59736:61474:61122",
			["f"] = 0,
			["m"] = 371,
			["coord"] = 1207707634,
		},
	},
	},
	["Alliance"] = {
	[1] = {
		[4321] = {
		"16227:4267:33253:3841:3838",
		"39212:39210:35136:4407",
		"40367:41383",
		"16227:4267:33253:3841:10897",
		"16227:4267:22931:12578:11138",
		"16227:4267:22931:12578",
		"7823:39175:15177",
		"7823:10583",
		"16227:4267:33253:3841:3838:17555:17554",
		"16227:4267:33253:3841:3838:17555",
		"16227:4267:22931",
		"16227:4267:22935",
		"16227:4267:34374",
		"16227:4267:33253",
		"39212:39210:34378",
		"39212:39210:35136:35137",
		"39212:39210:35136",
		"39212:39210:35136:6706:35138",
		"39212:39210:35136:6706:35481",
		"39212:39210:35136:6706:35478",
		"39212:39210:35136:6706:35556",
		"39212:39210:35136:6706:35562",
		"7823:39175",
		"39212:39210",
		"40358:39211",
		"16227:4267:33253:3841:3838:40552:40553",
		"16227:4267:33253:3841:3838:40552",
		"40358:40768",
		"7823:40827",
		"7823:41214",
		"39212:39210:35136:35137:41240",
		"40367:41383:40966",
		"40367:41580",
		"16227:4267:22931:43073",
		"16227:4267:22931:43079",
		"16227:4267:33253:3841:3838:17555:43991",
		"7823:40827:48275",
		"7823:39175:15177:48274",
		"7823:40827:48275:48273",
		--["name"] = "Theramore, Dustwallow Marsh",
		["m"] = 70,
		["f"] = 0,
		["direct"] = "3841:4267:40367:6706:7823:16227:40358:39212",
		["coord"] = 2897314579,
		},
		[12578] = {
		"3841:3838",
		"33253:4267",
		"33253:4267:34378:6706:35481:40966:41383:41580:40367",
		"33253:4267:16227:4321",
		"33253:4407",
		"33253:4267:34378:6706",
		"33253:4267:34378:39210:39211:40358:40768:7823",
		"33253:4267:34378:6706:35481:40966:41383",
		"33253:4267:34378:6706:35481:40966:41383:15177",
		"33253:4267:34378:39210:39211:40358:40768:7823:10583",
		"33253:4267:16227",
		"3841:3838:17555:17554",
		"3841:3838:17555",
		"22931:22935",
		"33253:4267:34378:39210:39211:40358",
		"33253:34374",
		"33253:4267:34378",
		"33253:4267:34378:35137",
		"33253:4267:34378:35136",
		"33253:4407:35138",
		"33253:4267:34378:6706:35481",
		"33253:4267:34378:6706:35478",
		"33253:4267:34378:6706:35556",
		"33253:4267:34378:6706:35562",
		"33253:4267:34378:6706:35481:40966:41383:15177:39175",
		"33253:4267:34378:39210",
		"33253:4267:34378:39210:39212",
		"33253:4267:34378:39210:39211",
		"3841:3838:40552:40553",
		"3841:3838:40552",
		"33253:4267:34378:39210:39211:40358:40768",
		"33253:4267:34378:39210:39211:40358:40768:7823:40827",
		"33253:4267:34378:39210:39211:40358:40768:7823:41214",
		"33253:4407:41240",
		"33253:4267:34378:6706:35481:40966",
		"33253:4267:34378:6706:35481:40966:41383:41580",
		"43073:43079",
		"3841:3838:17555:43991",
		"33253:4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"33253:4267:34378:6706:35481:40966:41383:15177:48274",
		"33253:4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Talonbranch Glade, Felwood",
		["m"] = 77,
		["f"] = 0,
		["direct"] = "3841:10897:11138:22931:33253:43073",
		["coord"] = 2601533647,
		},
		[35556] = {
		"6706:34378:4267:33253:3841",
		"6706:34378:4267:33253:3841:3838",
		"6706:34378:4267",
		"35478:35481:40966:41383:41580:40367",
		"6706:35136:39210:39212:4321",
		"6706:4407",
		"6706:35136:39210:39211:40358:40768:7823",
		"35478:35481:40966:41383",
		"6706:34378:4267:33253:3841:10897",
		"6706:34378:4267:22931:12578:11138",
		"6706:34378:4267:22931:12578",
		"35478:35481:40966:41383:15177",
		"35478:35481:40966:41383:15177:39175:10583",
		"6706:35136:39210:16227",
		"6706:34378:4267:33253:3841:3838:17555:17554",
		"6706:34378:4267:33253:3841:3838:17555",
		"6706:34378:4267:22931",
		"6706:34378:4267:22935",
		"6706:35136:39210:39211:40358",
		"6706:34378:4267:34374",
		"6706:34378:4267:33253",
		"6706:34378",
		"6706:35137",
		"6706:35136",
		"6706:35138",
		"35478:35481",
		"35478:35481:40966:41383:15177:39175",
		"6706:35136:39210",
		"6706:35136:39210:39212",
		"6706:35136:39210:39211",
		"6706:34378:4267:33253:3841:3838:40552:40553",
		"6706:34378:4267:33253:3841:3838:40552",
		"6706:35136:39210:39211:40358:40768",
		"6706:35136:39210:39211:40358:40768:7823:40827",
		"6706:35136:39210:39211:40358:40768:7823:41214",
		"6706:35138:41240",
		"35478:35481:40966",
		"35478:35481:40966:41383:41580",
		"6706:34378:4267:22931:43073",
		"6706:34378:4267:22931:43079",
		"6706:34378:4267:33253:3841:3838:17555:43991",
		"35478:35481:40966:41383:15177:48274:48275",
		"35478:35481:40966:41383:15177:48274",
		"35478:35481:40966:41383:15177:48274:48273",
		--["name"] = "Thunk's Abode, Desolace",
		["m"] = 66,
		["f"] = 0,
		["direct"] = "6706:35478:35562",
		["coord"] = 3034666036,
		},
		[39212] = {
		"16227:4267:33253:3841",
		"16227:4267:33253:3841:3838",
		"16227:4267",
		"4321:40367",
		"39210:35136:4407",
		"39210:35136:6706",
		"4321:7823",
		"4321:40367:41383",
		"16227:4267:33253:3841:10897",
		"16227:4267:22931:12578:11138",
		"16227:4267:22931:12578",
		"4321:7823:39175:15177",
		"4321:7823:10583",
		"16227:4267:33253:3841:3838:17555:17554",
		"16227:4267:33253:3841:3838:17555",
		"16227:4267:22931",
		"16227:4267:22935",
		"4321:40358",
		"16227:4267:34374",
		"16227:4267:33253",
		"39210:34378",
		"39210:35136:35137",
		"39210:35136",
		"39210:35136:6706:35138",
		"39210:35136:6706:35481",
		"39210:35136:6706:35478",
		"39210:35136:6706:35556",
		"39210:35136:6706:35562",
		"4321:7823:39175",
		"16227:4267:33253:3841:3838:40552:40553",
		"16227:4267:33253:3841:3838:40552",
		"4321:40358:40768",
		"4321:7823:40827",
		"4321:7823:41214",
		"39210:35136:35137:41240",
		"39210:35136:6706:35481:40966",
		"4321:40367:41580",
		"16227:4267:22931:43073",
		"16227:4267:22931:43079",
		"16227:4267:33253:3841:3838:17555:43991",
		"4321:7823:40827:48275",
		"4321:7823:39175:15177:48274",
		"4321:7823:40827:48275:48273",
		--["name"] = "Northwatch Hold, Southern Barrens",
		["m"] = 199,
		["f"] = 0,
		["direct"] = "4321:16227:39210:39211",
		["coord"] = 2849601694,
		},
		[35562] = {
		"6706:34378:4267:33253:3841",
		"6706:34378:4267:33253:3841:3838",
		"6706:34378:4267",
		"35481:40966:41383:41580:40367",
		"6706:35136:39210:39212:4321",
		"35478:4407",
		"35481:40966:41383:15177:39175:7823",
		"35481:40966:41383",
		"6706:34378:4267:33253:3841:10897",
		"6706:34378:4267:22931:12578:11138",
		"6706:34378:4267:22931:12578",
		"35481:40966:41383:15177",
		"35481:40966:41383:15177:39175:10583",
		"6706:35136:39210:16227",
		"6706:34378:4267:33253:3841:3838:17555:17554",
		"6706:34378:4267:33253:3841:3838:17555",
		"6706:34378:4267:22931",
		"6706:34378:4267:22935",
		"6706:35136:39210:39211:40358",
		"6706:34378:4267:34374",
		"6706:34378:4267:33253",
		"6706:34378",
		"6706:35137",
		"6706:35136",
		"6706:35138",
		"35481:40966:41383:15177:39175",
		"6706:35136:39210",
		"6706:35136:39210:39212",
		"6706:35136:39210:39211",
		"6706:34378:4267:33253:3841:3838:40552:40553",
		"6706:34378:4267:33253:3841:3838:40552",
		"6706:35136:39210:39211:40358:40768",
		"35481:40966:41383:15177:48274:48275:40827",
		"35481:40966:41383:15177:39175:7823:41214",
		"6706:35138:41240",
		"35481:40966",
		"35481:40966:41383:41580",
		"6706:34378:4267:22931:43073",
		"6706:34378:4267:22931:43079",
		"6706:34378:4267:33253:3841:3838:17555:43991",
		"35481:40966:41383:15177:48274:48275",
		"35481:40966:41383:15177:48274",
		"35481:40966:41383:15177:48274:48273",
		--["name"] = "Ethel Rethor, Desolace",
		["m"] = 66,
		["f"] = 0,
		["direct"] = "6706:35481:35478:35556",
		["coord"] = 1676035340,
		},
		[41240] = {
		"4407:3841",
		"4407:3841:3838",
		"35137:34378:4267",
		"35138:41383:41580:40367",
		"35137:35136:39210:39212:4321",
		"35137:6706",
		"35137:35136:39210:39211:40358:40768:7823",
		"35138:41383",
		"4407:3841:10897",
		"35137:34378:4267:22931:12578:11138",
		"35137:34378:4267:22931:12578",
		"35138:41383:15177",
		"35138:41383:15177:39175:10583",
		"35137:35136:39210:16227",
		"4407:3841:3838:17555:17554",
		"4407:3841:3838:17555",
		"35137:34378:4267:22931",
		"35137:34378:4267:22935",
		"35137:35136:39210:39211:40358",
		"4407:34374",
		"35137:34378:4267:33253",
		"35137:34378",
		"35137:35136",
		"35137:6706:35481",
		"35137:6706:35478",
		"35137:6706:35556",
		"35137:6706:35562",
		"35138:41383:15177:39175",
		"35137:35136:39210",
		"35137:35136:39210:39212",
		"35137:35136:39210:39211",
		"4407:3841:3838:40552:40553",
		"4407:3841:3838:40552",
		"35137:35136:39210:39211:40358:40768",
		"35137:35136:39210:39211:40358:40768:7823:40827",
		"35137:35136:39210:39211:40358:40768:7823:41214",
		"35137:6706:35481:40966",
		"35138:41383:41580",
		"35137:34378:4267:22931:43073",
		"35137:34378:4267:22931:43079",
		"4407:3841:3838:17555:43991",
		"35138:41383:15177:48274:48275",
		"35138:41383:15177:48274",
		"35138:41383:15177:48274:48273",
		--["name"] = "Mirkfallon Post, Stonetalon Mountains",
		["m"] = 65,
		["f"] = 0,
		["direct"] = "4407:35137:35138",
		["coord"] = 2087224264,
		},
		[43073] = {
		"12578:3841",
		"12578:3841:3838",
		"22931:4267",
		"22931:4267:34378:6706:35481:40966:41383:41580:40367",
		"22931:4267:16227:4321",
		"43079:33253:4407",
		"22931:4267:34378:6706",
		"22931:4267:34378:39210:39211:40358:40768:7823",
		"22931:4267:34378:6706:35481:40966:41383",
		"12578:10897",
		"12578:11138",
		"22931:4267:34378:6706:35481:40966:41383:15177",
		"22931:4267:34378:39210:39211:40358:40768:7823:10583",
		"22931:4267:16227",
		"12578:3841:3838:17555:17554",
		"12578:3841:3838:17555",
		"22931:22935",
		"22931:4267:34378:39210:39211:40358",
		"43079:33253:34374",
		"43079:33253",
		"22931:4267:34378",
		"22931:4267:34378:35137",
		"22931:4267:34378:35136",
		"43079:33253:4407:35138",
		"22931:4267:34378:6706:35481",
		"22931:4267:34378:6706:35478",
		"22931:4267:34378:6706:35556",
		"22931:4267:34378:6706:35562",
		"22931:4267:34378:6706:35481:40966:41383:15177:39175",
		"22931:4267:34378:39210",
		"22931:4267:34378:39210:39212",
		"22931:4267:34378:39210:39211",
		"12578:3841:3838:40552:40553",
		"12578:3841:3838:40552",
		"22931:4267:34378:39210:39211:40358:40768",
		"22931:4267:34378:39210:39211:40358:40768:7823:40827",
		"22931:4267:34378:39210:39211:40358:40768:7823:41214",
		"22931:4267:34378:35137:41240",
		"22931:4267:34378:6706:35481:40966",
		"22931:4267:34378:6706:35481:40966:41383:41580",
		"12578:3841:3838:17555:43991",
		"22931:4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"22931:4267:34378:6706:35481:40966:41383:15177:48274",
		"22931:4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Whisperwind Grove, Felwood",
		["m"] = 77,
		["f"] = 0,
		["direct"] = "12578:22931:43079",
		["coord"] = 1872382313,
		},
		[35137] = {
		"34378:4267:33253:3841",
		"34378:4267:33253:3841:3838",
		"34378:4267",
		"6706:35481:40966:41383:41580:40367",
		"35136:39210:39212:4321",
		"35136:39210:39211:40358:40768:7823",
		"6706:35481:40966:41383",
		"34378:4267:33253:3841:10897",
		"34378:4267:22931:12578:11138",
		"34378:4267:22931:12578",
		"6706:35481:40966:41383:15177",
		"6706:35481:40966:41383:15177:39175:10583",
		"35136:39210:16227",
		"34378:4267:33253:3841:3838:17555:17554",
		"34378:4267:33253:3841:3838:17555",
		"34378:4267:22931",
		"34378:4267:22935",
		"35136:39210:39211:40358",
		"34378:4267:34374",
		"34378:4267:33253",
		"6706:35481",
		"6706:35478",
		"6706:35556",
		"6706:35562",
		"6706:35481:40966:41383:15177:39175",
		"35136:39210",
		"35136:39210:39212",
		"35136:39210:39211",
		"34378:4267:33253:3841:3838:40552:40553",
		"34378:4267:33253:3841:3838:40552",
		"35136:39210:39211:40358:40768",
		"35136:39210:39211:40358:40768:7823:40827",
		"35136:39210:39211:40358:40768:7823:41214",
		"6706:35481:40966",
		"6706:35481:40966:41383:41580",
		"34378:4267:22931:43073",
		"34378:4267:22931:43079",
		"34378:4267:33253:3841:3838:17555:43991",
		"6706:35481:40966:41383:15177:48274:48275",
		"6706:35481:40966:41383:15177:48274",
		"6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Windshear Hold, Stonetalon Mountains",
		["m"] = 65,
		["f"] = 0,
		["direct"] = "4407:6706:34378:35136:35138:41240",
		["coord"] = 2525399807,
		},
		[43079] = {
		"33253:3841",
		"33253:3841:3838",
		"22931:4267",
		"22931:4267:34378:6706:35481:40966:41383:41580:40367",
		"22931:4267:16227:4321",
		"33253:4407",
		"22931:4267:34378:6706",
		"22931:4267:34378:39210:39211:40358:40768:7823",
		"22931:4267:34378:6706:35481:40966:41383",
		"43073:12578:10897",
		"43073:12578:11138",
		"43073:12578",
		"22931:4267:34378:6706:35481:40966:41383:15177",
		"22931:4267:34378:39210:39211:40358:40768:7823:10583",
		"22931:4267:16227",
		"33253:3841:3838:17555:17554",
		"33253:3841:3838:17555",
		"22931:22935",
		"22931:4267:34378:39210:39211:40358",
		"33253:34374",
		"22931:4267:34378",
		"22931:4267:34378:35137",
		"22931:4267:34378:35136",
		"33253:4407:35138",
		"22931:4267:34378:6706:35481",
		"22931:4267:34378:6706:35478",
		"22931:4267:34378:6706:35556",
		"22931:4267:34378:6706:35562",
		"22931:4267:34378:6706:35481:40966:41383:15177:39175",
		"22931:4267:34378:39210",
		"22931:4267:34378:39210:39212",
		"22931:4267:34378:39210:39211",
		"33253:3841:3838:40552:40553",
		"33253:3841:3838:40552",
		"22931:4267:34378:39210:39211:40358:40768",
		"22931:4267:34378:39210:39211:40358:40768:7823:40827",
		"22931:4267:34378:39210:39211:40358:40768:7823:41214",
		"22931:4267:34378:35137:41240",
		"22931:4267:34378:6706:35481:40966",
		"22931:4267:34378:6706:35481:40966:41383:41580",
		"33253:3841:3838:17555:43991",
		"22931:4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"22931:4267:34378:6706:35481:40966:41383:15177:48274",
		"22931:4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Wildheart Point, Felwood",
		["m"] = 77,
		["f"] = 0,
		["direct"] = "22931:33253:43073",
		["coord"] = 1901436515,
		},
		[33253] = {
		"3841:3838",
		"4267:34378:6706:35481:40966:41383:41580:40367",
		"4267:16227:4321",
		"4267:34378:6706",
		"4267:34378:39210:39211:40358:40768:7823",
		"4267:34378:6706:35481:40966:41383",
		"3841:10897",
		"12578:11138",
		"4267:34378:6706:35481:40966:41383:15177",
		"4267:34378:39210:39211:40358:40768:7823:10583",
		"4267:16227",
		"3841:3838:17555:17554",
		"3841:3838:17555",
		"22931:22935",
		"4267:34378:39210:39211:40358",
		"4267:34378",
		"4267:34378:35137",
		"4267:34378:35136",
		"4407:35138",
		"4267:34378:6706:35481",
		"4267:34378:6706:35478",
		"4267:34378:6706:35556",
		"4267:34378:6706:35562",
		"4267:34378:6706:35481:40966:41383:15177:39175",
		"4267:34378:39210",
		"4267:34378:39210:39212",
		"4267:34378:39210:39211",
		"3841:3838:40552:40553",
		"3841:3838:40552",
		"4267:34378:39210:39211:40358:40768",
		"4267:34378:39210:39211:40358:40768:7823:40827",
		"4267:34378:39210:39211:40358:40768:7823:41214",
		"4407:41240",
		"4267:34378:6706:35481:40966",
		"4267:34378:6706:35481:40966:41383:41580",
		"43079:43073",
		"3841:3838:17555:43991",
		"4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"4267:34378:6706:35481:40966:41383:15177:48274",
		"4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Grove of the Ancients, Darkshore",
		["m"] = 62,
		["f"] = 0,
		["direct"] = "3841:4267:4407:12578:22931:34374:43079",
		["coord"] = 1906098474,
		},
		[11138] = {
		"10897:3841",
		"10897:3841:3838",
		"12578:33253:4267",
		"12578:33253:4267:34378:6706:35481:40966:41383:41580:40367",
		"12578:33253:4267:16227:4321",
		"12578:33253:4407",
		"12578:33253:4267:34378:6706",
		"12578:33253:4267:34378:39210:39211:40358:40768:7823",
		"12578:33253:4267:34378:6706:35481:40966:41383",
		"12578:33253:4267:34378:6706:35481:40966:41383:15177",
		"12578:33253:4267:34378:39210:39211:40358:40768:7823:10583",
		"12578:33253:4267:16227",
		"10897:3841:3838:17555:17554",
		"10897:3841:3838:17555",
		"12578:22931",
		"12578:22931:22935",
		"12578:33253:4267:34378:39210:39211:40358",
		"12578:33253:34374",
		"12578:33253",
		"12578:33253:4267:34378",
		"12578:33253:4267:34378:35137",
		"12578:33253:4267:34378:35136",
		"12578:33253:4407:35138",
		"12578:33253:4267:34378:6706:35481",
		"12578:33253:4267:34378:6706:35478",
		"12578:33253:4267:34378:6706:35556",
		"12578:33253:4267:34378:6706:35562",
		"12578:33253:4267:34378:6706:35481:40966:41383:15177:39175",
		"12578:33253:4267:34378:39210",
		"12578:33253:4267:34378:39210:39212",
		"12578:33253:4267:34378:39210:39211",
		"10897:3841:3838:40552:40553",
		"10897:3841:3838:40552",
		"12578:33253:4267:34378:39210:39211:40358:40768",
		"12578:33253:4267:34378:39210:39211:40358:40768:7823:40827",
		"12578:33253:4267:34378:39210:39211:40358:40768:7823:41214",
		"12578:33253:4407:41240",
		"12578:33253:4267:34378:6706:35481:40966",
		"12578:33253:4267:34378:6706:35481:40966:41383:41580",
		"12578:43073",
		"12578:43073:43079",
		"10897:3841:3838:17555:43991",
		"12578:33253:4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"12578:33253:4267:34378:6706:35481:40966:41383:15177:48274",
		"12578:33253:4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Everlook, Winterspring",
		["m"] = 83,
		["f"] = 0,
		["direct"] = "10897:12578",
		["coord"] = 2619374768,
		},
		[3841] = {
		"33253:4267:34378:6706:35481:40966:41383:41580:40367",
		"33253:4267:34378:39210:39211:40358:40768:7823",
		"12578:11138",
		"33253:4267:34378:6706:35481:40966:41383:15177",
		"33253:4267:34378:39210:39211:40358:40768:7823:10583",
		"33253:4267:16227",
		"3838:17555:17554",
		"3838:17555",
		"33253:22931",
		"33253:22931:22935",
		"33253:4267:34378:39210:39211:40358",
		"33253:34374",
		"33253:4267:34378",
		"33253:4267:34378:35137",
		"33253:4267:34378:35136",
		"33253:4407:35138",
		"33253:4267:34378:6706:35481",
		"33253:4267:34378:6706:35478",
		"33253:4267:34378:6706:35556",
		"33253:4267:34378:6706:35562",
		"33253:4267:34378:6706:35481:40966:41383:15177:39175",
		"33253:4267:34378:39210",
		"33253:4267:34378:39210:39212",
		"33253:4267:34378:39210:39211",
		"3838:40552:40553",
		"3838:40552",
		"33253:4267:34378:39210:39211:40358:40768",
		"33253:4267:34378:39210:39211:40358:40768:7823:40827",
		"33253:4267:34378:39210:39211:40358:40768:7823:41214",
		"33253:4407:41240",
		"33253:4267:34378:6706:35481:40966",
		"33253:4267:34378:6706:35481:40966:41383:41580",
		"12578:43073",
		"33253:43079",
		"3838:17555:43991",
		"33253:4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"33253:4267:34378:6706:35481:40966:41383:15177:48274",
		"33253:4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Lor'danel, Darkshore",
		["m"] = 62,
		["f"] = 0,
		["direct"] = "3838:4267:4321:4407:6706:41383:10897:12578:33253",
		["coord"] = 2221223248,
		},
		[7823] = {
		"40768:40358:39211:39210:34378:4267:33253:3841",
		"40768:40358:39211:39210:34378:4267:33253:3841:3838",
		"40768:40358:39211:39210:34378:4267",
		"40768:40358:39211:39210:35136:4407",
		"40768:40358:39211:39210:35136:6706",
		"40367:41383",
		"40768:40358:39211:39210:34378:4267:33253:3841:10897",
		"40768:40358:39211:39210:34378:4267:22931:12578:11138",
		"40768:40358:39211:39210:34378:4267:22931:12578",
		"40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:17554",
		"40768:40358:39211:39210:34378:4267:33253:3841:3838:17555",
		"40768:40358:39211:39210:34378:4267:22931",
		"40768:40358:39211:39210:34378:4267:22935",
		"40768:40358",
		"40768:40358:39211:39210:34378:4267:34374",
		"40768:40358:39211:39210:34378:4267:33253",
		"40768:40358:39211:39210:34378",
		"40768:40358:39211:39210:35136:35137",
		"40768:40358:39211:39210:35136",
		"40768:40358:39211:39210:35136:6706:35138",
		"40367:41383:40966:35481",
		"40768:40358:39211:39210:35136:6706:35478",
		"40768:40358:39211:39210:35136:6706:35556",
		"40768:40358:39211:39210:35136:6706:35562",
		"40768:40358:39211:39210",
		"4321:39212",
		"40768:40358:39211",
		"40768:40358:39211:39210:34378:4267:33253:3841:3838:40552:40553",
		"40768:40358:39211:39210:34378:4267:33253:3841:3838:40552",
		"40768:40358:39211:39210:35136:35137:41240",
		"40367:41383:40966",
		"40367:41580",
		"40768:40358:39211:39210:34378:4267:22931:43073",
		"40768:40358:39211:39210:34378:4267:22931:43079",
		"40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:43991",
		"40827:48275",
		"39175:15177:48274",
		"40827:48275:48273",
		--["name"] = "Gadgetzan, Tanaris",
		["m"] = 71,
		["f"] = 0,
		["direct"] = "40367:4321:15177:10583:16227:39175:40768:40827:41214",
		["coord"] = 2206681944,
		},
		[40827] = {
		"7823:40768:40358:39211:39210:34378:4267:33253:3841",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838",
		"7823:40768:40358:39211:39210:34378:4267",
		"7823:40367",
		"7823:4321",
		"7823:40768:40358:39211:39210:35136:4407",
		"7823:40768:40358:39211:39210:35136:6706",
		"48275:48274:15177:41383",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:10897",
		"7823:40768:40358:39211:39210:34378:4267:22931:12578:11138",
		"7823:40768:40358:39211:39210:34378:4267:22931:12578",
		"48275:48274:15177",
		"7823:10583",
		"7823:16227",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:17554",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555",
		"7823:40768:40358:39211:39210:34378:4267:22931",
		"7823:40768:40358:39211:39210:34378:4267:22935",
		"7823:40768:40358",
		"7823:40768:40358:39211:39210:34378:4267:34374",
		"7823:40768:40358:39211:39210:34378:4267:33253",
		"7823:40768:40358:39211:39210:34378",
		"7823:40768:40358:39211:39210:35136:35137",
		"7823:40768:40358:39211:39210:35136",
		"7823:40768:40358:39211:39210:35136:6706:35138",
		"48275:48274:15177:41383:40966:35481",
		"48275:48274:15177:41383:40966:35481:35478",
		"7823:40768:40358:39211:39210:35136:6706:35556",
		"48275:48274:15177:41383:40966:35481:35562",
		"7823:39175",
		"7823:40768:40358:39211:39210",
		"7823:4321:39212",
		"7823:40768:40358:39211",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552:40553",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552",
		"7823:40768",
		"7823:40768:40358:39211:39210:35136:35137:41240",
		"48275:48274:15177:41383:40966",
		"7823:40367:41580",
		"7823:40768:40358:39211:39210:34378:4267:22931:43073",
		"7823:40768:40358:39211:39210:34378:4267:22931:43079",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:43991",
		"48275:48274",
		"48275:48273",
		--["name"] = "Gunstan's Dig, Tanaris",
		["m"] = 71,
		["f"] = 0,
		["direct"] = "7823:41214:48275",
		["coord"] = 1720043118,
		},
		[40768] = {
		"40358:39211:39210:34378:4267:33253:3841",
		"40358:39211:39210:34378:4267:33253:3841:3838",
		"40358:39211:39210:34378:4267",
		"40358:4321",
		"40358:39211:39210:35136:4407",
		"40358:39211:39210:35136:6706",
		"40367:41383",
		"40358:39211:39210:34378:4267:33253:3841:10897",
		"40358:39211:39210:34378:4267:22931:12578:11138",
		"40358:39211:39210:34378:4267:22931:12578",
		"7823:39175:15177",
		"7823:10583",
		"40358:4321:16227",
		"40358:39211:39210:34378:4267:33253:3841:3838:17555:17554",
		"40358:39211:39210:34378:4267:33253:3841:3838:17555",
		"40358:39211:39210:34378:4267:22931",
		"40358:39211:39210:34378:4267:22935",
		"40358:39211:39210:34378:4267:34374",
		"40358:39211:39210:34378:4267:33253",
		"40358:39211:39210:34378",
		"40358:39211:39210:35136:35137",
		"40358:39211:39210:35136",
		"40358:39211:39210:35136:6706:35138",
		"40367:41383:40966:35481",
		"40358:39211:39210:35136:6706:35478",
		"40358:39211:39210:35136:6706:35556",
		"40358:39211:39210:35136:6706:35562",
		"7823:39175",
		"40358:39211:39210",
		"40358:4321:39212",
		"40358:39211",
		"40358:39211:39210:34378:4267:33253:3841:3838:40552:40553",
		"40358:39211:39210:34378:4267:33253:3841:3838:40552",
		"7823:40827",
		"7823:41214",
		"40358:39211:39210:35136:35137:41240",
		"40367:41383:40966",
		"40367:41580",
		"40358:39211:39210:34378:4267:22931:43073",
		"40358:39211:39210:34378:4267:22931:43079",
		"40358:39211:39210:34378:4267:33253:3841:3838:17555:43991",
		"7823:40827:48275",
		"7823:39175:15177:48274",
		"7823:40827:48275:48273",
		--["name"] = "Fizzle & Pozzik's Speedbarge, Thousand Needles",
		["m"] = 64,
		["f"] = 0,
		["direct"] = "40367:7823:40358",
		["coord"] = 3399661601,
		},
		[17554] = {
		"17555:3838:3841",
		"17555:3838",
		"17555:3838:3841:33253:4267",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383:41580:40367",
		"17555:3838:3841:33253:4267:16227:4321",
		"17555:3838:3841:33253:4407",
		"17555:3838:3841:33253:4267:34378:6706",
		"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383",
		"17555:3838:3841:10897",
		"17555:3838:3841:12578:11138",
		"17555:3838:3841:12578",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177",
		"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:10583",
		"17555:3838:3841:33253:4267:16227",
		"17555:3838:3841:33253:22931",
		"17555:3838:3841:33253:22931:22935",
		"17555:3838:3841:33253:4267:34378:39210:39211:40358",
		"17555:3838:3841:33253:34374",
		"17555:3838:3841:33253",
		"17555:3838:3841:33253:4267:34378",
		"17555:3838:3841:33253:4267:34378:35137",
		"17555:3838:3841:33253:4267:34378:35136",
		"17555:3838:3841:33253:4407:35138",
		"17555:3838:3841:33253:4267:34378:6706:35481",
		"17555:3838:3841:33253:4267:34378:6706:35478",
		"17555:3838:3841:33253:4267:34378:6706:35556",
		"17555:3838:3841:33253:4267:34378:6706:35562",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:39175",
		"17555:3838:3841:33253:4267:34378:39210",
		"17555:3838:3841:33253:4267:34378:39210:39212",
		"17555:3838:3841:33253:4267:34378:39210:39211",
		"17555:3838:40552:40553",
		"17555:3838:40552",
		"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768",
		"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:40827",
		"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:41214",
		"17555:3838:3841:33253:4407:41240",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383:41580",
		"17555:3838:3841:12578:43073",
		"17555:3838:3841:33253:43079",
		"17555:43991",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Blood Watch, Bloodmyst Isle",
		["m"] = 106,
		["f"] = 0,
		["direct"] = "17555",
		["coord"] = 2479065609,
		},
		[6706] = {
		"34378:4267:33253:3841:3838",
		"34378:4267",
		"35481:40966:41383:41580:40367",
		"35136:39210:39211:40358:40768:7823",
		"34378:4267:33253:3841:10897",
		"34378:4267:22931:12578:11138",
		"34378:4267:22931:12578",
		"35481:40966:41383:15177",
		"35481:40966:41383:15177:39175:10583",
		"35136:39210:16227",
		"34378:4267:33253:3841:3838:17555:17554",
		"34378:4267:33253:3841:3838:17555",
		"34378:4267:22931",
		"34378:4267:22935",
		"35136:39210:39211:40358",
		"34378:4267:34374",
		"34378:4267:33253",
		"35481:40966:41383:15177:39175",
		"35136:39210",
		"35136:39210:39212",
		"35136:39210:39211",
		"34378:4267:33253:3841:3838:40552:40553",
		"34378:4267:33253:3841:3838:40552",
		"35136:39210:39211:40358:40768",
		"35136:39210:39211:40358:40768:7823:40827",
		"35136:39210:39211:40358:40768:7823:41214",
		"35138:41240",
		"35481:40966",
		"35481:40966:41383:41580",
		"34378:4267:22931:43073",
		"34378:4267:22931:43079",
		"34378:4267:33253:3841:3838:17555:43991",
		"35481:40966:41383:15177:48274:48275",
		"35481:40966:41383:15177:48274",
		"35481:40966:41383:15177:48274:48273",
		--["name"] = "Nijel's Point, Desolace",
		["m"] = 66,
		["f"] = 0,
		["direct"] = "3841:4321:4407:41383:34378:35137:35136:35138:35481:35478:35556:35562",
		["coord"] = 2777619127,
		},
		[4407] = {
		"3841:3838",
		"35481:40966:41383:41580:40367",
		"35136:39210:39212:4321",
		"35136:39210:39211:40358:40768:7823",
		"35481:40966:41383",
		"3841:10897",
		"33253:12578:11138",
		"33253:12578",
		"35481:40966:41383:15177",
		"35481:40966:41383:15177:39175:10583",
		"35136:39210:16227",
		"3841:3838:17555:17554",
		"3841:3838:17555",
		"34378:4267:22931",
		"34378:4267:22935",
		"35136:39210:39211:40358",
		"6706:35556",
		"6706:35562",
		"35481:40966:41383:15177:39175",
		"35136:39210",
		"35136:39210:39212",
		"35136:39210:39211",
		"3841:3838:40552:40553",
		"3841:3838:40552",
		"35136:39210:39211:40358:40768",
		"35136:39210:39211:40358:40768:7823:40827",
		"35136:39210:39211:40358:40768:7823:41214",
		"35481:40966",
		"35481:40966:41383:41580",
		"33253:43079:43073",
		"33253:43079",
		"3841:3838:17555:43991",
		"35481:40966:41383:15177:48274:48275",
		"35481:40966:41383:15177:48274",
		"35481:40966:41383:15177:48274:48273",
		--["name"] = "Thal'darah Overlook, Stonetalon Mountains",
		["m"] = 65,
		["f"] = 0,
		["direct"] = "3841:4267:6706:34374:33253:34378:35137:35136:35138:35481:35478:41240",
		["coord"] = 1720996301,
		},
		[43991] = {
		"17555:3838:3841",
		"17555:3838",
		"17555:3838:3841:33253:4267",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383:41580:40367",
		"17555:3838:3841:33253:4267:16227:4321",
		"17555:3838:3841:33253:4407",
		"17555:3838:3841:33253:4267:34378:6706",
		"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383",
		"17555:3838:3841:10897",
		"17555:3838:3841:12578:11138",
		"17555:3838:3841:12578",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177",
		"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:10583",
		"17555:3838:3841:33253:4267:16227",
		"17555:17554",
		"17555:3838:3841:33253:22931",
		"17555:3838:3841:33253:22931:22935",
		"17555:3838:3841:33253:4267:34378:39210:39211:40358",
		"17555:3838:3841:33253:34374",
		"17555:3838:3841:33253",
		"17555:3838:3841:33253:4267:34378",
		"17555:3838:3841:33253:4267:34378:35137",
		"17555:3838:3841:33253:4267:34378:35136",
		"17555:3838:3841:33253:4407:35138",
		"17555:3838:3841:33253:4267:34378:6706:35481",
		"17555:3838:3841:33253:4267:34378:6706:35478",
		"17555:3838:3841:33253:4267:34378:6706:35556",
		"17555:3838:3841:33253:4267:34378:6706:35562",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:39175",
		"17555:3838:3841:33253:4267:34378:39210",
		"17555:3838:3841:33253:4267:34378:39210:39212",
		"17555:3838:3841:33253:4267:34378:39210:39211",
		"17555:3838:40552:40553",
		"17555:3838:40552",
		"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768",
		"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:40827",
		"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:41214",
		"17555:3838:3841:33253:4407:41240",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383:41580",
		"17555:3838:3841:12578:43073",
		"17555:3838:3841:33253:43079",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274",
		"17555:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Azure Watch, Azuremyst Isle",
		["m"] = 97,
		["f"] = 0,
		["direct"] = "17555",
		["coord"] = 2131721734,
		},
		[15177] = {
		"41383:3841",
		"41383:3841:3838",
		"41383:6706:34378:4267",
		"41383:41580:40367",
		"39175:7823:4321",
		"41383:35138:4407",
		"41383:6706",
		"41383:3841:10897",
		"41383:6706:34378:4267:22931:12578:11138",
		"41383:6706:34378:4267:22931:12578",
		"39175:7823:16227",
		"41383:3841:3838:17555:17554",
		"41383:3841:3838:17555",
		"41383:6706:34378:4267:22931",
		"41383:6706:34378:4267:22935",
		"39175:7823:40768:40358",
		"41383:35138:4407:34374",
		"41383:6706:34378:4267:33253",
		"41383:6706:34378",
		"41383:6706:35137",
		"41383:6706:35136",
		"41383:35138",
		"41383:40966:35481",
		"41383:40966:35481:35478",
		"41383:40966:35481:35478:35556",
		"41383:40966:35481:35562",
		"41383:6706:35136:39210",
		"39175:7823:4321:39212",
		"39175:7823:40768:40358:39211",
		"41383:3841:3838:40552:40553",
		"41383:3841:3838:40552",
		"39175:7823:40768",
		"48274:48275:40827",
		"39175:7823:41214",
		"41383:35138:41240",
		"41383:40966",
		"41383:41580",
		"41383:6706:34378:4267:22931:43073",
		"41383:6706:34378:4267:22931:43079",
		"41383:3841:3838:17555:43991",
		"48274:48275",
		"48274:48273",
		--["name"] = "Cenarion Hold, Silithus",
		["m"] = 81,
		["f"] = 0,
		["direct"] = "7823:41383:10583:39175:48274",
		["coord"] = 2337494023,
		},
		[39211] = {
		"39210:34378:4267:33253:3841",
		"39210:34378:4267:33253:3841:3838",
		"39210:34378:4267",
		"40358:40367",
		"40358:4321",
		"39210:35136:4407",
		"39210:35136:6706",
		"40358:40768:7823",
		"40358:40367:41383",
		"39210:34378:4267:33253:3841:10897",
		"39210:34378:4267:22931:12578:11138",
		"39210:34378:4267:22931:12578",
		"40358:40768:7823:39175:15177",
		"40358:40768:7823:10583",
		"39212:16227",
		"39210:34378:4267:33253:3841:3838:17555:17554",
		"39210:34378:4267:33253:3841:3838:17555",
		"39210:34378:4267:22931",
		"39210:34378:4267:22935",
		"39210:34378:4267:34374",
		"39210:34378:4267:33253",
		"39210:34378",
		"39210:35136:35137",
		"39210:35136",
		"39210:35136:6706:35138",
		"39210:35136:6706:35481",
		"39210:35136:6706:35478",
		"39210:35136:6706:35556",
		"39210:35136:6706:35562",
		"40358:40768:7823:39175",
		"39210:34378:4267:33253:3841:3838:40552:40553",
		"39210:34378:4267:33253:3841:3838:40552",
		"40358:40768",
		"40358:40768:7823:40827",
		"40358:40768:7823:41214",
		"39210:35136:35137:41240",
		"40358:40367:41383:40966",
		"40358:40367:41580",
		"39210:34378:4267:22931:43073",
		"39210:34378:4267:22931:43079",
		"39210:34378:4267:33253:3841:3838:17555:43991",
		"40358:40768:7823:40827:48275",
		"40358:40768:7823:39175:15177:48274",
		"40358:40768:7823:40827:48275:48273",
		--["name"] = "Fort Triumph, Southern Barrens",
		["m"] = 199,
		["f"] = 0,
		["direct"] = "40358:39210:39212",
		["coord"] = 2112990626,
		},
		[4267] = {
		"33253:3841:3838",
		"34378:6706:35481:40966:41383:41580:40367",
		"34378:6706",
		"34378:39210:39211:40358:40768:7823",
		"34378:6706:35481:40966:41383",
		"33253:3841:10897",
		"22931:12578:11138",
		"22931:12578",
		"34378:6706:35481:40966:41383:15177",
		"34378:39210:39211:40358:40768:7823:10583",
		"33253:3841:3838:17555:17554",
		"33253:3841:3838:17555",
		"34378:39210:39211:40358",
		"34378:35137",
		"34378:35136",
		"34378:35137:41240:35138",
		"34378:6706:35481",
		"34378:6706:35478",
		"34378:6706:35556",
		"34378:6706:35562",
		"34378:6706:35481:40966:41383:15177:39175",
		"34378:39210",
		"34378:39210:39212",
		"34378:39210:39211",
		"33253:3841:3838:40552:40553",
		"33253:3841:3838:40552",
		"34378:39210:39211:40358:40768",
		"34378:39210:39211:40358:40768:7823:40827",
		"34378:39210:39211:40358:40768:7823:41214",
		"34378:35137:41240",
		"34378:6706:35481:40966",
		"34378:6706:35481:40966:41383:41580",
		"22931:43073",
		"22931:43079",
		"33253:3841:3838:17555:43991",
		"34378:6706:35481:40966:41383:15177:48274:48275",
		"34378:6706:35481:40966:41383:15177:48274",
		"34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Astranaar, Ashenvale",
		["m"] = 63,
		["f"] = 0,
		["direct"] = "3841:4321:4407:16227:22931:22935:34374:33253:34378",
		["coord"] = 1479113436,
		},
		[40553] = {
		"40552:3838:3841",
		"40552:3838",
		"40552:3838:3841:33253:4267",
		"40552:3838:3841:33253:4267:34378:6706:35481:40966:41383:41580:40367",
		"40552:3838:3841:33253:4267:16227:4321",
		"40552:3838:3841:33253:4407",
		"40552:3838:3841:33253:4267:34378:6706",
		"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823",
		"40552:3838:3841:33253:4267:34378:6706:35481:40966:41383",
		"40552:3838:3841:10897",
		"40552:3838:3841:12578:11138",
		"40552:3838:3841:12578",
		"40552:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177",
		"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:10583",
		"40552:3838:3841:33253:4267:16227",
		"40552:3838:17555:17554",
		"40552:3838:17555",
		"40552:3838:3841:33253:22931",
		"40552:3838:3841:33253:22931:22935",
		"40552:3838:3841:33253:4267:34378:39210:39211:40358",
		"40552:3838:3841:33253:34374",
		"40552:3838:3841:33253",
		"40552:3838:3841:33253:4267:34378",
		"40552:3838:3841:33253:4267:34378:35137",
		"40552:3838:3841:33253:4267:34378:35136",
		"40552:3838:3841:33253:4407:35138",
		"40552:3838:3841:33253:4267:34378:6706:35481",
		"40552:3838:3841:33253:4267:34378:6706:35478",
		"40552:3838:3841:33253:4267:34378:6706:35556",
		"40552:3838:3841:33253:4267:34378:6706:35562",
		"40552:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:39175",
		"40552:3838:3841:33253:4267:34378:39210",
		"40552:3838:3841:33253:4267:34378:39210:39212",
		"40552:3838:3841:33253:4267:34378:39210:39211",
		"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768",
		"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:40827",
		"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:41214",
		"40552:3838:3841:33253:4407:41240",
		"40552:3838:3841:33253:4267:34378:6706:35481:40966",
		"40552:3838:3841:33253:4267:34378:6706:35481:40966:41383:41580",
		"40552:3838:3841:12578:43073",
		"40552:3838:3841:33253:43079",
		"40552:3838:17555:43991",
		"40552:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"40552:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274",
		"40552:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Dolanaar, Teldrassil",
		["m"] = 57,
		["coord"] = 2381611283,
		["direct"] = "40552",
		["f"] = 0,
		},
		[35478] = {
		"6706:34378:4267:33253:3841",
		"6706:34378:4267:33253:3841:3838",
		"6706:34378:4267",
		"35481:40966:41383:41580:40367",
		"6706:35136:39210:39212:4321",
		"35481:40966:41383:15177:39175:7823",
		"35481:40966:41383",
		"6706:34378:4267:33253:3841:10897",
		"6706:34378:4267:22931:12578:11138",
		"6706:34378:4267:22931:12578",
		"35481:40966:41383:15177",
		"35481:40966:41383:15177:39175:10583",
		"6706:35136:39210:16227",
		"6706:34378:4267:33253:3841:3838:17555:17554",
		"6706:34378:4267:33253:3841:3838:17555",
		"6706:34378:4267:22931",
		"6706:34378:4267:22935",
		"6706:35136:39210:39211:40358",
		"6706:34378:4267:34374",
		"6706:34378:4267:33253",
		"6706:34378",
		"6706:35137",
		"6706:35136",
		"6706:35138",
		"35481:40966:41383:15177:39175",
		"6706:35136:39210",
		"6706:35136:39210:39212",
		"6706:35136:39210:39211",
		"6706:34378:4267:33253:3841:3838:40552:40553",
		"6706:34378:4267:33253:3841:3838:40552",
		"6706:35136:39210:39211:40358:40768",
		"35481:40966:41383:15177:48274:48275:40827",
		"35481:40966:41383:15177:39175:7823:41214",
		"6706:35138:41240",
		"35481:40966",
		"35481:40966:41383:41580",
		"6706:34378:4267:22931:43073",
		"6706:34378:4267:22931:43079",
		"6706:34378:4267:33253:3841:3838:17555:43991",
		"35481:40966:41383:15177:48274:48275",
		"35481:40966:41383:15177:48274",
		"35481:40966:41383:15177:48274:48273",
		--["name"] = "Karnum's Glade, Desolace",
		["m"] = 66,
		["f"] = 0,
		["direct"] = "4407:6706:35481:35556:35562",
		["coord"] = 2481225630,
		},
		[40966] = {
		"35481:4407:3841",
		"35481:4407:3841:3838",
		"35481:6706:34378:4267",
		"41383:41580:40367",
		"41383:41580:40367:40358:4321",
		"35481:4407",
		"35481:6706",
		"41383:15177:39175:7823",
		"35481:4407:3841:10897",
		"35481:6706:34378:4267:22931:12578:11138",
		"35481:6706:34378:4267:22931:12578",
		"41383:15177",
		"41383:15177:39175:10583",
		"35481:6706:35136:39210:16227",
		"35481:4407:3841:3838:17555:17554",
		"35481:4407:3841:3838:17555",
		"35481:6706:34378:4267:22931",
		"35481:6706:34378:4267:22935",
		"41383:41580:40367:40358",
		"35481:4407:34374",
		"35481:4407:33253",
		"35481:6706:34378",
		"35481:6706:35137",
		"35481:6706:35136",
		"35481:6706:35138",
		"35481:35478",
		"35481:35478:35556",
		"35481:35562",
		"41383:15177:39175",
		"35481:6706:35136:39210",
		"35481:6706:35136:39210:39212",
		"41383:41580:40367:40358:39211",
		"35481:4407:3841:3838:40552:40553",
		"35481:4407:3841:3838:40552",
		"41383:41580:40367:40768",
		"41383:15177:48274:48275:40827",
		"41383:15177:39175:7823:41214",
		"35481:6706:35138:41240",
		"41383:41580",
		"35481:6706:34378:4267:22931:43073",
		"35481:6706:34378:4267:22931:43079",
		"35481:4407:3841:3838:17555:43991",
		"41383:15177:48274:48275",
		"41383:15177:48274",
		"41383:15177:48274:48273",
		--["name"] = "Dreamer's Rest, Feralas",
		["m"] = 69,
		["f"] = 0,
		["direct"] = "41383:35481",
		["coord"] = 2156735114,
		},
		[10897] = {
		"3841:3838",
		"3841:33253:4267",
		"3841:33253:4267:34378:6706:35481:40966:41383:41580:40367",
		"3841:33253:4267:16227:4321",
		"3841:33253:4407",
		"3841:33253:4267:34378:6706",
		"3841:33253:4267:34378:39210:39211:40358:40768:7823",
		"3841:33253:4267:34378:6706:35481:40966:41383",
		"3841:33253:4267:34378:6706:35481:40966:41383:15177",
		"3841:33253:4267:34378:39210:39211:40358:40768:7823:10583",
		"3841:33253:4267:16227",
		"3841:3838:17555:17554",
		"3841:3838:17555",
		"12578:22931",
		"12578:22931:22935",
		"3841:33253:4267:34378:39210:39211:40358",
		"3841:33253:34374",
		"3841:33253",
		"3841:33253:4267:34378",
		"3841:33253:4267:34378:35137",
		"3841:33253:4267:34378:35136",
		"3841:33253:4407:35138",
		"3841:33253:4267:34378:6706:35481",
		"3841:33253:4267:34378:6706:35478",
		"3841:33253:4267:34378:6706:35556",
		"3841:33253:4267:34378:6706:35562",
		"3841:33253:4267:34378:6706:35481:40966:41383:15177:39175",
		"3841:33253:4267:34378:39210",
		"3841:33253:4267:34378:39210:39212",
		"3841:33253:4267:34378:39210:39211",
		"3841:3838:40552:40553",
		"3841:3838:40552",
		"3841:33253:4267:34378:39210:39211:40358:40768",
		"3841:33253:4267:34378:39210:39211:40358:40768:7823:40827",
		"3841:33253:4267:34378:39210:39211:40358:40768:7823:41214",
		"3841:33253:4407:41240",
		"3841:33253:4267:34378:6706:35481:40966",
		"3841:33253:4267:34378:6706:35481:40966:41383:41580",
		"12578:43073",
		"12578:43073:43079",
		"3841:3838:17555:43991",
		"3841:33253:4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"3841:33253:4267:34378:6706:35481:40966:41383:15177:48274",
		"3841:33253:4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Moonglade",
		["m"] = 80,
		["f"] = 0,
		["direct"] = "3841:11138:12578",
		["coord"] = 2063379560,
		},
		[39175] = {
		"15177:41383:3841",
		"15177:41383:3841:3838",
		"7823:40768:40358:39211:39210:34378:4267",
		"15177:41383:41580:40367",
		"7823:4321",
		"15177:41383:35138:4407",
		"15177:41383:6706",
		"15177:41383",
		"15177:41383:3841:10897",
		"7823:40768:40358:39211:39210:34378:4267:22931:12578:11138",
		"7823:40768:40358:39211:39210:34378:4267:22931:12578",
		"7823:16227",
		"15177:41383:3841:3838:17555:17554",
		"15177:41383:3841:3838:17555",
		"7823:40768:40358:39211:39210:34378:4267:22931",
		"7823:40768:40358:39211:39210:34378:4267:22935",
		"7823:40768:40358",
		"15177:41383:35138:4407:34374",
		"7823:40768:40358:39211:39210:34378:4267:33253",
		"7823:40768:40358:39211:39210:34378",
		"15177:41383:6706:35137",
		"7823:40768:40358:39211:39210:35136",
		"15177:41383:35138",
		"15177:41383:40966:35481",
		"15177:41383:40966:35481:35478",
		"15177:41383:40966:35481:35478:35556",
		"15177:41383:40966:35481:35562",
		"7823:40768:40358:39211:39210",
		"7823:4321:39212",
		"7823:40768:40358:39211",
		"15177:41383:3841:3838:40552:40553",
		"15177:41383:3841:3838:40552",
		"7823:40768",
		"7823:40827",
		"7823:41214",
		"15177:41383:35138:41240",
		"15177:41383:40966",
		"15177:41383:41580",
		"7823:40768:40358:39211:39210:34378:4267:22931:43073",
		"7823:40768:40358:39211:39210:34378:4267:22931:43079",
		"15177:41383:3841:3838:17555:43991",
		"15177:48274:48275",
		"15177:48274",
		"15177:48274:48273",
		--["name"] = "Mossy Pile, Un'Goro Crater",
		["m"] = 78,
		["f"] = 0,
		["direct"] = "7823:15177:10583",
		["coord"] = 1893754668,
		},
		[10583] = {
		"7823:40768:40358:39211:39210:34378:4267:33253:3841",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838",
		"7823:40768:40358:39211:39210:34378:4267",
		"7823:40367",
		"7823:4321",
		"39175:15177:41383:35138:4407",
		"39175:15177:41383:6706",
		"39175:15177:41383",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:10897",
		"7823:40768:40358:39211:39210:34378:4267:22931:12578:11138",
		"7823:40768:40358:39211:39210:34378:4267:22931:12578",
		"7823:16227",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:17554",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555",
		"7823:40768:40358:39211:39210:34378:4267:22931",
		"7823:40768:40358:39211:39210:34378:4267:22935",
		"7823:40768:40358",
		"7823:40768:40358:39211:39210:34378:4267:34374",
		"7823:40768:40358:39211:39210:34378:4267:33253",
		"7823:40768:40358:39211:39210:34378",
		"7823:40768:40358:39211:39210:35136:35137",
		"7823:40768:40358:39211:39210:35136",
		"39175:15177:41383:35138",
		"39175:15177:41383:40966:35481",
		"39175:15177:41383:40966:35481:35478",
		"39175:15177:41383:40966:35481:35478:35556",
		"39175:15177:41383:40966:35481:35562",
		"7823:40768:40358:39211:39210",
		"7823:4321:39212",
		"7823:40768:40358:39211",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552:40553",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552",
		"7823:40768",
		"7823:40827",
		"7823:41214",
		"39175:15177:41383:35138:41240",
		"39175:15177:41383:40966",
		"39175:15177:41383:41580",
		"7823:40768:40358:39211:39210:34378:4267:22931:43073",
		"7823:40768:40358:39211:39210:34378:4267:22931:43079",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:43991",
		"39175:15177:48274:48275",
		"39175:15177:48274",
		"39175:15177:48274:48273",
		--["name"] = "Marshal's Stand, Un'Goro Crater",
		["m"] = 78,
		["f"] = 0,
		["direct"] = "7823:15177:39175",
		["coord"] = 2408031264,
		},
		[35136] = {
		"34378:4267:33253:3841",
		"34378:4267:33253:3841:3838",
		"34378:4267",
		"6706:35481:40966:41383:41580:40367",
		"39210:39212:4321",
		"39210:39211:40358:40768:7823",
		"6706:35481:40966:41383",
		"34378:4267:33253:3841:10897",
		"34378:4267:22931:12578:11138",
		"34378:4267:22931:12578",
		"6706:35481:40966:41383:15177",
		"39210:39211:40358:40768:7823:10583",
		"39210:16227",
		"34378:4267:33253:3841:3838:17555:17554",
		"34378:4267:33253:3841:3838:17555",
		"34378:4267:22931",
		"34378:4267:22935",
		"39210:39211:40358",
		"34378:4267:34374",
		"34378:4267:33253",
		"6706:35481",
		"6706:35478",
		"6706:35556",
		"6706:35562",
		"39210:39211:40358:40768:7823:39175",
		"39210:39212",
		"39210:39211",
		"34378:4267:33253:3841:3838:40552:40553",
		"34378:4267:33253:3841:3838:40552",
		"39210:39211:40358:40768",
		"39210:39211:40358:40768:7823:40827",
		"39210:39211:40358:40768:7823:41214",
		"35137:41240",
		"6706:35481:40966",
		"6706:35481:40966:41383:41580",
		"34378:4267:22931:43073",
		"34378:4267:22931:43079",
		"34378:4267:33253:3841:3838:17555:43991",
		"39210:39211:40358:40768:7823:40827:48275",
		"6706:35481:40966:41383:15177:48274",
		"6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Northwatch Expedition Base Camp, Stonetalon Mountains",
		["m"] = 65,
		["f"] = 0,
		["direct"] = "4407:6706:34378:35137:35138:39210",
		["coord"] = 3045445139,
		},
		[35138] = {
		"4407:3841",
		"4407:3841:3838",
		"41240:35137:34378:4267",
		"41383:41580:40367",
		"35136:39210:39212:4321",
		"35136:39210:39211:40358:40768:7823",
		"4407:3841:10897",
		"4407:33253:12578:11138",
		"4407:33253:12578",
		"41383:15177",
		"41383:15177:39175:10583",
		"35136:39210:16227",
		"4407:3841:3838:17555:17554",
		"4407:3841:3838:17555",
		"41240:35137:34378:4267:22931",
		"41240:35137:34378:4267:22935",
		"35136:39210:39211:40358",
		"4407:34374",
		"4407:33253",
		"41240:35137:34378",
		"6706:35481",
		"6706:35478",
		"6706:35556",
		"6706:35562",
		"41383:15177:39175",
		"35136:39210",
		"35136:39210:39212",
		"35136:39210:39211",
		"4407:3841:3838:40552:40553",
		"4407:3841:3838:40552",
		"35136:39210:39211:40358:40768",
		"35136:39210:39211:40358:40768:7823:40827",
		"35136:39210:39211:40358:40768:7823:41214",
		"6706:35481:40966",
		"41383:41580",
		"41240:35137:34378:4267:22931:43073",
		"4407:33253:43079",
		"4407:3841:3838:17555:43991",
		"41383:15177:48274:48275",
		"41383:15177:48274",
		"41383:15177:48274:48273",
		--["name"] = "Farwatcher's Glen, Stonetalon Mountains",
		["m"] = 65,
		["f"] = 0,
		["direct"] = "4407:6706:41383:35137:35136:41240",
		["coord"] = 1375116844,
		},
		[35481] = {
		"4407:3841",
		"4407:3841:3838",
		"6706:34378:4267",
		"40966:41383:41580:40367",
		"40966:41383:41580:40367:40358:4321",
		"40966:41383:15177:39175:7823",
		"4407:3841:10897",
		"6706:34378:4267:22931:12578:11138",
		"6706:34378:4267:22931:12578",
		"40966:41383:15177",
		"40966:41383:15177:39175:10583",
		"6706:35136:39210:16227",
		"4407:3841:3838:17555:17554",
		"4407:3841:3838:17555",
		"6706:34378:4267:22931",
		"6706:34378:4267:22935",
		"40966:41383:41580:40367:40358",
		"4407:34374",
		"4407:33253",
		"6706:34378",
		"6706:35137",
		"6706:35136",
		"6706:35138",
		"35478:35556",
		"40966:41383:15177:39175",
		"6706:35136:39210",
		"6706:35136:39210:39212",
		"6706:35136:39210:39211",
		"4407:3841:3838:40552:40553",
		"4407:3841:3838:40552",
		"40966:41383:41580:40367:40768",
		"40966:41383:15177:48274:48275:40827",
		"40966:41383:15177:39175:7823:41214",
		"6706:35138:41240",
		"40966:41383:41580",
		"6706:34378:4267:22931:43073",
		"6706:34378:4267:22931:43079",
		"4407:3841:3838:17555:43991",
		"40966:41383:15177:48274:48275",
		"40966:41383:15177:48274",
		"40966:41383:15177:48274:48273",
		--["name"] = "Thargad's Camp, Desolace",
		["m"] = 66,
		["f"] = 0,
		["direct"] = "4407:6706:41383:35478:35562:40966",
		["coord"] = 1581758285,
		},
		[34374] = {
		"33253:3841",
		"33253:3841:3838",
		"4267:34378:6706:35481:40966:41383:41580:40367",
		"4267:16227:4321",
		"4267:34378:6706",
		"4267:34378:39210:39211:40358:40768:7823",
		"4267:34378:6706:35481:40966:41383",
		"33253:3841:10897",
		"33253:12578:11138",
		"33253:12578",
		"4267:34378:6706:35481:40966:41383:15177",
		"4267:34378:39210:39211:40358:40768:7823:10583",
		"4267:16227",
		"33253:3841:3838:17555:17554",
		"33253:3841:3838:17555",
		"4267:22935",
		"4267:34378:39210:39211:40358",
		"4267:34378",
		"4267:34378:35137",
		"4267:34378:35136",
		"4407:35138",
		"4267:34378:6706:35481",
		"4267:34378:6706:35478",
		"4267:34378:6706:35556",
		"4267:34378:6706:35562",
		"4267:34378:6706:35481:40966:41383:15177:39175",
		"4267:34378:39210",
		"4267:34378:39210:39212",
		"4267:34378:39210:39211",
		"33253:3841:3838:40552:40553",
		"33253:3841:3838:40552",
		"4267:34378:39210:39211:40358:40768",
		"4267:34378:39210:39211:40358:40768:7823:40827",
		"4267:34378:39210:39211:40358:40768:7823:41214",
		"4407:41240",
		"4267:34378:6706:35481:40966",
		"4267:34378:6706:35481:40966:41383:41580",
		"33253:43079:43073",
		"33253:43079",
		"33253:3841:3838:17555:43991",
		"4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"4267:34378:6706:35481:40966:41383:15177:48274",
		"4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Blackfathom Camp, Ashenvale",
		["m"] = 63,
		["f"] = 0,
		["direct"] = "4267:4407:22931:33253",
		["coord"] = 778908870,
		},
		[22931] = {
		"33253:3841",
		"33253:3841:3838",
		"4267:34378:6706:35481:40966:41383:41580:40367",
		"4267:16227:4321",
		"4267:34378:4407",
		"4267:34378:6706",
		"4267:34378:39210:39211:40358:40768:7823",
		"4267:34378:6706:35481:40966:41383",
		"12578:10897",
		"12578:11138",
		"4267:34378:6706:35481:40966:41383:15177",
		"4267:34378:39210:39211:40358:40768:7823:10583",
		"4267:16227",
		"33253:3841:3838:17555:17554",
		"33253:3841:3838:17555",
		"4267:34378:39210:39211:40358",
		"4267:34378",
		"4267:34378:35137",
		"4267:34378:35136",
		"4267:34378:35137:41240:35138",
		"4267:34378:6706:35481",
		"4267:34378:6706:35478",
		"4267:34378:6706:35556",
		"4267:34378:6706:35562",
		"4267:34378:6706:35481:40966:41383:15177:39175",
		"4267:34378:39210",
		"4267:34378:39210:39212",
		"4267:34378:39210:39211",
		"33253:3841:3838:40552:40553",
		"33253:3841:3838:40552",
		"4267:34378:39210:39211:40358:40768",
		"4267:34378:39210:39211:40358:40768:7823:40827",
		"4267:34378:39210:39211:40358:40768:7823:41214",
		"4267:34378:35137:41240",
		"4267:34378:6706:35481:40966",
		"4267:34378:6706:35481:40966:41383:41580",
		"33253:3841:3838:17555:43991",
		"4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"4267:34378:6706:35481:40966:41383:15177:48274",
		"4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Emerald Sanctuary, Felwood",
		["m"] = 77,
		["f"] = 0,
		["direct"] = "4267:12578:22935:34374:33253:43073:43079",
		["coord"] = 2212089545,
		},
		[41383] = {
		"3841:3838",
		"6706:34378:4267",
		"41580:40367:40358:4321",
		"35138:4407",
		"15177:39175:7823",
		"3841:10897",
		"6706:34378:4267:22931:12578:11138",
		"6706:34378:4267:22931:12578",
		"15177:39175:10583",
		"41580:40367:40358:4321:16227",
		"3841:3838:17555:17554",
		"3841:3838:17555",
		"6706:34378:4267:22931",
		"6706:34378:4267:22935",
		"41580:40367:40358",
		"35138:4407:34374",
		"6706:34378:4267:33253",
		"6706:34378",
		"6706:35137",
		"6706:35136",
		"40966:35481:35478",
		"40966:35481:35478:35556",
		"40966:35481:35562",
		"15177:39175",
		"6706:35136:39210",
		"41580:40367:40358:4321:39212",
		"41580:40367:40358:39211",
		"3841:3838:40552:40553",
		"3841:3838:40552",
		"41580:40367:40768",
		"15177:48274:48275:40827",
		"15177:39175:7823:41214",
		"35138:41240",
		"6706:34378:4267:22931:43073",
		"6706:34378:4267:22931:43079",
		"3841:3838:17555:43991",
		"15177:48274:48275",
		"15177:48274",
		"15177:48274:48273",
		--["name"] = "Feathermoon, Feralas",
		["m"] = 69,
		["f"] = 0,
		["direct"] = "3841:40367:6706:15177:35138:35481:40966:41580",
		["coord"] = 2009625603,
		},
		[40358] = {
		"39211:39210:34378:4267:33253:3841",
		"39211:39210:34378:4267:33253:3841:3838",
		"39211:39210:34378:4267",
		"39211:39210:35136:4407",
		"39211:39210:35136:6706",
		"40768:7823",
		"40367:41383",
		"39211:39210:34378:4267:33253:3841:10897",
		"39211:39210:34378:4267:22931:12578:11138",
		"39211:39210:34378:4267:22931:12578",
		"40768:7823:39175:15177",
		"40768:7823:10583",
		"4321:16227",
		"39211:39210:34378:4267:33253:3841:3838:17555:17554",
		"39211:39210:34378:4267:33253:3841:3838:17555",
		"39211:39210:34378:4267:22931",
		"39211:39210:34378:4267:22935",
		"39211:39210:34378:4267:34374",
		"39211:39210:34378:4267:33253",
		"39211:39210:34378",
		"39211:39210:35136:35137",
		"39211:39210:35136",
		"39211:39210:35136:6706:35138",
		"40367:41383:40966:35481",
		"39211:39210:35136:6706:35478",
		"39211:39210:35136:6706:35556",
		"39211:39210:35136:6706:35562",
		"40768:7823:39175",
		"39211:39210",
		"4321:39212",
		"39211:39210:34378:4267:33253:3841:3838:40552:40553",
		"39211:39210:34378:4267:33253:3841:3838:40552",
		"40768:7823:40827",
		"40768:7823:41214",
		"39211:39210:35136:35137:41240",
		"40367:41383:40966",
		"40367:41580",
		"39211:39210:34378:4267:22931:43073",
		"39211:39210:34378:4267:22931:43079",
		"39211:39210:34378:4267:33253:3841:3838:17555:43991",
		"40768:7823:40827:48275",
		"40768:7823:39175:15177:48274",
		"40768:7823:40827:48275:48273",
		--["name"] = "Mudsprocket, Dustwallow Marsh",
		["m"] = 70,
		["f"] = 0,
		["direct"] = "40367:4321:39211:40768",
		["coord"] = 1842198888,
		},
		[40367] = {
		"41383:3841",
		"41383:3841:3838",
		"41383:6706:34378:4267",
		"41383:35138:4407",
		"41383:6706",
		"41383:3841:10897",
		"41383:6706:34378:4267:22931:12578:11138",
		"41383:6706:34378:4267:22931:12578",
		"41383:15177",
		"41383:15177:39175:10583",
		"40358:4321:16227",
		"41383:3841:3838:17555:17554",
		"41383:3841:3838:17555",
		"41383:6706:34378:4267:22931",
		"41383:6706:34378:4267:22935",
		"41383:35138:4407:34374",
		"41383:6706:34378:4267:33253",
		"41383:6706:34378",
		"41383:6706:35137",
		"41383:6706:35136",
		"41383:35138",
		"41383:40966:35481",
		"41383:40966:35481:35478",
		"41383:40966:35481:35478:35556",
		"41383:40966:35481:35562",
		"41383:15177:39175",
		"40358:39211:39210",
		"40358:4321:39212",
		"40358:39211",
		"41383:3841:3838:40552:40553",
		"41383:3841:3838:40552",
		"7823:40827",
		"7823:41214",
		"41383:35138:41240",
		"41383:40966",
		"41383:6706:34378:4267:22931:43073",
		"41383:6706:34378:4267:22931:43079",
		"41383:3841:3838:17555:43991",
		"41383:15177:48274:48275",
		"41383:15177:48274",
		"41383:15177:48274:48273",
		--["name"] = "Shadebough, Feralas",
		["m"] = 69,
		["f"] = 0,
		["direct"] = "4321:7823:41383:40358:40768:41580",
		["coord"] = 3318714714,
		},
		[22935] = {
		"22931:33253:3841",
		"22931:33253:3841:3838",
		"4267:34378:6706:35481:40966:41383:41580:40367",
		"4267:16227:4321",
		"4267:34378:4407",
		"4267:34378:6706",
		"4267:34378:39210:39211:40358:40768:7823",
		"4267:34378:6706:35481:40966:41383",
		"22931:12578:10897",
		"22931:12578:11138",
		"22931:12578",
		"4267:34378:6706:35481:40966:41383:15177",
		"4267:34378:39210:39211:40358:40768:7823:10583",
		"4267:16227",
		"22931:33253:3841:3838:17555:17554",
		"22931:33253:3841:3838:17555",
		"4267:34378:39210:39211:40358",
		"4267:34374",
		"22931:33253",
		"4267:34378",
		"4267:34378:35137",
		"4267:34378:35136",
		"4267:34378:35137:41240:35138",
		"4267:34378:6706:35481",
		"4267:34378:6706:35478",
		"4267:34378:6706:35556",
		"4267:34378:6706:35562",
		"4267:34378:6706:35481:40966:41383:15177:39175",
		"4267:34378:39210",
		"4267:34378:39210:39212",
		"4267:34378:39210:39211",
		"22931:33253:3841:3838:40552:40553",
		"22931:33253:3841:3838:40552",
		"4267:34378:39210:39211:40358:40768",
		"4267:34378:39210:39211:40358:40768:7823:40827",
		"4267:34378:39210:39211:40358:40768:7823:41214",
		"4267:34378:35137:41240",
		"4267:34378:6706:35481:40966",
		"4267:34378:6706:35481:40966:41383:41580",
		"22931:43073",
		"22931:43079",
		"22931:33253:3841:3838:17555:43991",
		"4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"4267:34378:6706:35481:40966:41383:15177:48274",
		"4267:34378:6706:35481:40966:41383:15177:48274:48273",
		["direct"] = "4267:22931",
		["f"] = 0,
		["m"] = 63,
		["coord"] = 3653594953,
		},
		[41580] = {
		"41383:3841",
		"41383:3841:3838",
		"41383:6706:34378:4267",
		"40367:40358:4321",
		"41383:35138:4407",
		"41383:6706",
		"40367:7823",
		"41383:3841:10897",
		"41383:6706:34378:4267:22931:12578:11138",
		"41383:6706:34378:4267:22931:12578",
		"41383:15177",
		"41383:15177:39175:10583",
		"40367:40358:4321:16227",
		"41383:3841:3838:17555:17554",
		"41383:3841:3838:17555",
		"41383:6706:34378:4267:22931",
		"41383:6706:34378:4267:22935",
		"40367:40358",
		"41383:35138:4407:34374",
		"41383:6706:34378:4267:33253",
		"41383:6706:34378",
		"41383:6706:35137",
		"41383:6706:35136",
		"41383:35138",
		"41383:40966:35481",
		"41383:40966:35481:35478",
		"41383:40966:35481:35478:35556",
		"41383:40966:35481:35562",
		"41383:15177:39175",
		"41383:6706:35136:39210",
		"40367:40358:4321:39212",
		"40367:40358:39211",
		"41383:3841:3838:40552:40553",
		"41383:3841:3838:40552",
		"40367:40768",
		"40367:7823:40827",
		"40367:7823:41214",
		"41383:35138:41240",
		"41383:40966",
		"41383:6706:34378:4267:22931:43073",
		"41383:6706:34378:4267:22931:43079",
		"41383:3841:3838:17555:43991",
		"41383:15177:48274:48275",
		"41383:15177:48274",
		"41383:15177:48274:48273",
		--["name"] = "Tower of Estulan, Feralas",
		["m"] = 69,
		["f"] = 0,
		["direct"] = "40367:41383",
		["coord"] = 2449377781,
		},
		[16227] = {
		"4267:33253:3841",
		"4267:33253:3841:3838",
		"4321:40367",
		"39210:35136:4407",
		"39210:35136:6706",
		"4321:40367:41383",
		"4267:33253:3841:10897",
		"4267:22931:12578:11138",
		"4267:22931:12578",
		"7823:39175:15177",
		"7823:10583",
		"4267:33253:3841:3838:17555:17554",
		"4267:33253:3841:3838:17555",
		"4267:22931",
		"4267:22935",
		"4321:40358",
		"4267:34374",
		"4267:33253",
		"39210:34378",
		"39210:35136:35137",
		"39210:35136",
		"39210:35136:6706:35138",
		"39210:35136:6706:35481",
		"39210:35136:6706:35478",
		"39210:35136:6706:35556",
		"39210:35136:6706:35562",
		"7823:39175",
		"39212:39211",
		"4267:33253:3841:3838:40552:40553",
		"4267:33253:3841:3838:40552",
		"4321:40358:40768",
		"7823:40827",
		"7823:41214",
		"39210:35136:35137:41240",
		"39210:35136:6706:35481:40966",
		"4321:40367:41580",
		"4267:22931:43073",
		"4267:22931:43079",
		"4267:33253:3841:3838:17555:43991",
		"7823:40827:48275",
		"7823:39175:15177:48274",
		"7823:40827:48275:48273",
		--["name"] = "Ratchet, Northern Barrens",
		["m"] = 10,
		["f"] = 0,
		["direct"] = "4267:4321:7823:39210:39212",
		["coord"] = 2971382975,
		},
		[34378] = {
		"4267:33253:3841",
		"4267:33253:3841:3838",
		"6706:35481:40966:41383:41580:40367",
		"39210:39212:4321",
		"39210:39211:40358:40768:7823",
		"6706:35481:40966:41383",
		"4267:33253:3841:10897",
		"4267:22931:12578:11138",
		"4267:22931:12578",
		"6706:35481:40966:41383:15177",
		"39210:39211:40358:40768:7823:10583",
		"39210:16227",
		"4267:33253:3841:3838:17555:17554",
		"4267:33253:3841:3838:17555",
		"4267:22931",
		"4267:22935",
		"39210:39211:40358",
		"4267:34374",
		"4267:33253",
		"35137:41240:35138",
		"6706:35481",
		"6706:35478",
		"6706:35556",
		"6706:35562",
		"6706:35481:40966:41383:15177:39175",
		"39210:39212",
		"39210:39211",
		"4267:33253:3841:3838:40552:40553",
		"4267:33253:3841:3838:40552",
		"39210:39211:40358:40768",
		"39210:39211:40358:40768:7823:40827",
		"39210:39211:40358:40768:7823:41214",
		"35137:41240",
		"6706:35481:40966",
		"6706:35481:40966:41383:41580",
		"4267:22931:43073",
		"4267:22931:43079",
		"4267:33253:3841:3838:17555:43991",
		"6706:35481:40966:41383:15177:48274:48275",
		"6706:35481:40966:41383:15177:48274",
		"6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Stardust Spire, Ashenvale",
		["m"] = 63,
		["f"] = 0,
		["direct"] = "4267:4407:6706:35137:35136:39210",
		["coord"] = 1505998935,
		},
		[48275] = {
		"48274:15177:41383:3841",
		"48274:15177:41383:3841:3838",
		"40827:7823:40768:40358:39211:39210:34378:4267",
		"48274:15177:41383:41580:40367",
		"40827:7823:4321",
		"48274:15177:41383:35138:4407",
		"48274:15177:41383:6706",
		"40827:7823",
		"48274:15177:41383",
		"48274:15177:41383:3841:10897",
		"40827:7823:40768:40358:39211:39210:34378:4267:22931:12578:11138",
		"40827:7823:40768:40358:39211:39210:34378:4267:22931:12578",
		"48274:15177",
		"48274:15177:39175:10583",
		"40827:7823:16227",
		"48274:15177:41383:3841:3838:17555:17554",
		"48274:15177:41383:3841:3838:17555",
		"40827:7823:40768:40358:39211:39210:34378:4267:22931",
		"40827:7823:40768:40358:39211:39210:34378:4267:22935",
		"40827:7823:40768:40358",
		"48274:15177:41383:35138:4407:34374",
		"40827:7823:40768:40358:39211:39210:34378:4267:33253",
		"40827:7823:40768:40358:39211:39210:34378",
		"48274:15177:41383:6706:35137",
		"40827:7823:40768:40358:39211:39210:35136",
		"48274:15177:41383:35138",
		"48274:15177:41383:40966:35481",
		"48274:15177:41383:40966:35481:35478",
		"48274:15177:41383:40966:35481:35478:35556",
		"48274:15177:41383:40966:35481:35562",
		"48274:15177:39175",
		"40827:7823:40768:40358:39211:39210",
		"40827:7823:4321:39212",
		"40827:7823:40768:40358:39211",
		"48274:15177:41383:3841:3838:40552:40553",
		"48274:15177:41383:3841:3838:40552",
		"40827:7823:40768",
		"40827:41214",
		"48274:15177:41383:35138:41240",
		"48274:15177:41383:40966",
		"48274:15177:41383:41580",
		"40827:7823:40768:40358:39211:39210:34378:4267:22931:43073",
		"40827:7823:40768:40358:39211:39210:34378:4267:22931:43079",
		"48274:15177:41383:3841:3838:17555:43991",
		--["name"] = "Ramkahen, Uldum",
		["m"] = 249,
		["f"] = 0,
		["direct"] = "40827:48274:48273",
		["coord"] = 2415678988,
		},
		[48273] = {
		"48274:15177:41383:3841",
		"48274:15177:41383:3841:3838",
		"48274:15177:41383:6706:34378:4267",
		"48274:15177:41383:41580:40367",
		"48275:40827:7823:4321",
		"48274:15177:41383:35138:4407",
		"48274:15177:41383:6706",
		"48275:40827:7823",
		"48274:15177:41383",
		"48274:15177:41383:3841:10897",
		"48274:15177:41383:6706:34378:4267:22931:12578:11138",
		"48274:15177:41383:6706:34378:4267:22931:12578",
		"48274:15177",
		"48274:15177:39175:10583",
		"48275:40827:7823:16227",
		"48274:15177:41383:3841:3838:17555:17554",
		"48274:15177:41383:3841:3838:17555",
		"48274:15177:41383:6706:34378:4267:22931",
		"48274:15177:41383:6706:34378:4267:22935",
		"48275:40827:7823:40768:40358",
		"48274:15177:41383:35138:4407:34374",
		"48274:15177:41383:6706:34378:4267:33253",
		"48274:15177:41383:6706:34378",
		"48274:15177:41383:6706:35137",
		"48274:15177:41383:6706:35136",
		"48274:15177:41383:35138",
		"48274:15177:41383:40966:35481",
		"48274:15177:41383:40966:35481:35478",
		"48274:15177:41383:40966:35481:35478:35556",
		"48274:15177:41383:40966:35481:35562",
		"48274:15177:39175",
		"48275:40827:7823:40768:40358:39211:39210",
		"48275:40827:7823:4321:39212",
		"48275:40827:7823:40768:40358:39211",
		"48274:15177:41383:3841:3838:40552:40553",
		"48274:15177:41383:3841:3838:40552",
		"48275:40827:7823:40768",
		"48275:40827",
		"48275:40827:41214",
		"48274:15177:41383:35138:41240",
		"48274:15177:41383:40966",
		"48274:15177:41383:41580",
		"48274:15177:41383:6706:34378:4267:22931:43073",
		"48274:15177:41383:6706:34378:4267:22931:43079",
		"48274:15177:41383:3841:3838:17555:43991",
		--["name"] = "Schnottz's Landing, Uldum",
		["m"] = 249,
		["f"] = 0,
		["direct"] = "48275:48274",
		["coord"] = 958375507,
		},
		[40552] = {
		"3838:3841",
		"3838:3841:33253:4267",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383:41580:40367",
		"3838:3841:33253:4267:16227:4321",
		"3838:3841:33253:4407",
		"3838:3841:33253:4267:34378:6706",
		"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383",
		"3838:3841:10897",
		"3838:3841:12578:11138",
		"3838:3841:12578",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383:15177",
		"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:10583",
		"3838:3841:33253:4267:16227",
		"3838:17555:17554",
		"3838:17555",
		"3838:3841:33253:22931",
		"3838:3841:33253:22931:22935",
		"3838:3841:33253:4267:34378:39210:39211:40358",
		"3838:3841:33253:34374",
		"3838:3841:33253",
		"3838:3841:33253:4267:34378",
		"3838:3841:33253:4267:34378:35137",
		"3838:3841:33253:4267:34378:35136",
		"3838:3841:33253:4407:35138",
		"3838:3841:33253:4267:34378:6706:35481",
		"3838:3841:33253:4267:34378:6706:35478",
		"3838:3841:33253:4267:34378:6706:35556",
		"3838:3841:33253:4267:34378:6706:35562",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:39175",
		"3838:3841:33253:4267:34378:39210",
		"3838:3841:33253:4267:34378:39210:39212",
		"3838:3841:33253:4267:34378:39210:39211",
		"3838:3841:33253:4267:34378:39210:39211:40358:40768",
		"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:40827",
		"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:41214",
		"3838:3841:33253:4407:41240",
		"3838:3841:33253:4267:34378:6706:35481:40966",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383:41580",
		"3838:3841:12578:43073",
		"3838:3841:33253:43079",
		"3838:17555:43991",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Darnassus, Teldrassil",
		["m"] = 89,
		["coord"] = 1577286546,
		["direct"] = "3838:40553",
		["f"] = 0,
		},
		[41214] = {
		"7823:40768:40358:39211:39210:34378:4267:33253:3841",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838",
		"7823:40768:40358:39211:39210:34378:4267",
		"7823:40367",
		"7823:4321",
		"7823:40768:40358:39211:39210:35136:4407",
		"7823:40768:40358:39211:39210:35136:6706",
		"7823:40367:41383",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:10897",
		"7823:40768:40358:39211:39210:34378:4267:22931:12578:11138",
		"7823:40768:40358:39211:39210:34378:4267:22931:12578",
		"7823:39175:15177",
		"7823:10583",
		"7823:16227",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:17554",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555",
		"7823:40768:40358:39211:39210:34378:4267:22931",
		"7823:40768:40358:39211:39210:34378:4267:22935",
		"7823:40768:40358",
		"7823:40768:40358:39211:39210:34378:4267:34374",
		"7823:40768:40358:39211:39210:34378:4267:33253",
		"7823:40768:40358:39211:39210:34378",
		"7823:40768:40358:39211:39210:35136:35137",
		"7823:40768:40358:39211:39210:35136",
		"7823:40768:40358:39211:39210:35136:6706:35138",
		"7823:40367:41383:40966:35481",
		"7823:40768:40358:39211:39210:35136:6706:35478",
		"7823:40768:40358:39211:39210:35136:6706:35556",
		"7823:40768:40358:39211:39210:35136:6706:35562",
		"7823:39175",
		"7823:40768:40358:39211:39210",
		"7823:4321:39212",
		"7823:40768:40358:39211",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552:40553",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552",
		"7823:40768",
		"7823:40768:40358:39211:39210:35136:35137:41240",
		"7823:40367:41383:40966",
		"7823:40367:41580",
		"7823:40768:40358:39211:39210:34378:4267:22931:43073",
		"7823:40768:40358:39211:39210:34378:4267:22931:43079",
		"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:43991",
		"40827:48275",
		"40827:48275:48274",
		"40827:48275:48273",
		--["name"] = "Bootlegger Outpost, Tanaris",
		["m"] = 71,
		["f"] = 0,
		["direct"] = "7823:40827",
		["coord"] = 2398853933,
		},
		[3838] = {
		"3841:33253:4267",
		"3841:33253:4267:34378:6706:35481:40966:41383:41580:40367",
		"3841:33253:4267:16227:4321",
		"3841:33253:4407",
		"3841:33253:4267:34378:6706",
		"3841:33253:4267:34378:39210:39211:40358:40768:7823",
		"3841:33253:4267:34378:6706:35481:40966:41383",
		"3841:10897",
		"3841:12578:11138",
		"3841:12578",
		"3841:33253:4267:34378:6706:35481:40966:41383:15177",
		"3841:33253:4267:34378:39210:39211:40358:40768:7823:10583",
		"3841:33253:4267:16227",
		"17555:17554",
		"3841:33253:22931",
		"3841:33253:22931:22935",
		"3841:33253:4267:34378:39210:39211:40358",
		"3841:33253:34374",
		"3841:33253",
		"3841:33253:4267:34378",
		"3841:33253:4267:34378:35137",
		"3841:33253:4267:34378:35136",
		"3841:33253:4407:35138",
		"3841:33253:4267:34378:6706:35481",
		"3841:33253:4267:34378:6706:35478",
		"3841:33253:4267:34378:6706:35556",
		"3841:33253:4267:34378:6706:35562",
		"3841:33253:4267:34378:6706:35481:40966:41383:15177:39175",
		"3841:33253:4267:34378:39210",
		"3841:33253:4267:34378:39210:39212",
		"3841:33253:4267:34378:39210:39211",
		"40552:40553",
		"3841:33253:4267:34378:39210:39211:40358:40768",
		"3841:33253:4267:34378:39210:39211:40358:40768:7823:40827",
		"3841:33253:4267:34378:39210:39211:40358:40768:7823:41214",
		"3841:33253:4407:41240",
		"3841:33253:4267:34378:6706:35481:40966",
		"3841:33253:4267:34378:6706:35481:40966:41383:41580",
		"3841:12578:43073",
		"3841:33253:43079",
		"17555:43991",
		"3841:33253:4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"3841:33253:4267:34378:6706:35481:40966:41383:15177:48274",
		"3841:33253:4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "Rut'theran Village, Teldrassil",
		["m"] = 57,
		["coord"] = 2380063334,
		["direct"] = "3841:17555:40552",
		["f"] = 0,
		},
		[48274] = {
		"15177:41383:3841",
		"15177:41383:3841:3838",
		"15177:41383:6706:34378:4267",
		"15177:41383:41580:40367",
		"15177:39175:7823:4321",
		"15177:41383:35138:4407",
		"15177:41383:6706",
		"15177:39175:7823",
		"15177:41383",
		"15177:41383:3841:10897",
		"15177:41383:6706:34378:4267:22931:12578:11138",
		"15177:41383:6706:34378:4267:22931:12578",
		"15177:39175:10583",
		"15177:39175:7823:16227",
		"15177:41383:3841:3838:17555:17554",
		"15177:41383:3841:3838:17555",
		"15177:41383:6706:34378:4267:22931",
		"15177:41383:6706:34378:4267:22935",
		"15177:39175:7823:40768:40358",
		"15177:41383:35138:4407:34374",
		"15177:41383:6706:34378:4267:33253",
		"15177:41383:6706:34378",
		"15177:41383:6706:35137",
		"15177:41383:6706:35136",
		"15177:41383:35138",
		"15177:41383:40966:35481",
		"15177:41383:40966:35481:35478",
		"15177:41383:40966:35481:35478:35556",
		"15177:41383:40966:35481:35562",
		"15177:39175",
		"15177:41383:6706:35136:39210",
		"15177:39175:7823:4321:39212",
		"15177:39175:7823:40768:40358:39211",
		"15177:41383:3841:3838:40552:40553",
		"15177:41383:3841:3838:40552",
		"15177:39175:7823:40768",
		"48275:40827",
		"48275:40827:41214",
		"15177:41383:35138:41240",
		"15177:41383:40966",
		"15177:41383:41580",
		"15177:41383:6706:34378:4267:22931:43073",
		"15177:41383:6706:34378:4267:22931:43079",
		"15177:41383:3841:3838:17555:43991",
		--["name"] = "Oasis of Vir'sar, Uldum",
		["m"] = 249,
		["f"] = 0,
		["direct"] = "15177:48275:48273",
		["coord"] = 1142297964,
		},
		[17555] = {
		"3838:3841",
		"3838:3841:33253:4267",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383:41580:40367",
		"3838:3841:33253:4267:16227:4321",
		"3838:3841:33253:4407",
		"3838:3841:33253:4267:34378:6706",
		"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383",
		"3838:3841:10897",
		"3838:3841:12578:11138",
		"3838:3841:12578",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383:15177",
		"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:10583",
		"3838:3841:33253:4267:16227",
		"3838:3841:33253:22931",
		"3838:3841:33253:22931:22935",
		"3838:3841:33253:4267:34378:39210:39211:40358",
		"3838:3841:33253:34374",
		"3838:3841:33253",
		"3838:3841:33253:4267:34378",
		"3838:3841:33253:4267:34378:35137",
		"3838:3841:33253:4267:34378:35136",
		"3838:3841:33253:4407:35138",
		"3838:3841:33253:4267:34378:6706:35481",
		"3838:3841:33253:4267:34378:6706:35478",
		"3838:3841:33253:4267:34378:6706:35556",
		"3838:3841:33253:4267:34378:6706:35562",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:39175",
		"3838:3841:33253:4267:34378:39210",
		"3838:3841:33253:4267:34378:39210:39212",
		"3838:3841:33253:4267:34378:39210:39211",
		"3838:40552:40553",
		"3838:40552",
		"3838:3841:33253:4267:34378:39210:39211:40358:40768",
		"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:40827",
		"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:41214",
		"3838:3841:33253:4407:41240",
		"3838:3841:33253:4267:34378:6706:35481:40966",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383:41580",
		"3838:3841:12578:43073",
		"3838:3841:33253:43079",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274:48275",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274",
		"3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:48274:48273",
		--["name"] = "The Exodar",
		["m"] = 103,
		["f"] = 0,
		["direct"] = "3838:17554:43991",
		["coord"] = 2335858098,
		},
		[39210] = {
		"34378:4267:33253:3841",
		"34378:4267:33253:3841:3838",
		"34378:4267",
		"39211:40358:40367",
		"39212:4321",
		"35136:4407",
		"35136:6706",
		"39211:40358:40768:7823",
		"35136:6706:35481:40966:41383",
		"34378:4267:33253:3841:10897",
		"34378:4267:22931:12578:11138",
		"34378:4267:22931:12578",
		"35136:6706:35481:40966:41383:15177",
		"39211:40358:40768:7823:10583",
		"34378:4267:33253:3841:3838:17555:17554",
		"34378:4267:33253:3841:3838:17555",
		"34378:4267:22931",
		"34378:4267:22935",
		"39211:40358",
		"34378:4267:34374",
		"34378:4267:33253",
		"35136:35137",
		"35136:6706:35138",
		"35136:6706:35481",
		"35136:6706:35478",
		"35136:6706:35556",
		"35136:6706:35562",
		"39211:40358:40768:7823:39175",
		"34378:4267:33253:3841:3838:40552:40553",
		"34378:4267:33253:3841:3838:40552",
		"39211:40358:40768",
		"39211:40358:40768:7823:40827",
		"39211:40358:40768:7823:41214",
		"35136:35137:41240",
		"35136:6706:35481:40966",
		"35136:6706:35481:40966:41383:41580",
		"34378:4267:22931:43073",
		"34378:4267:22931:43079",
		"34378:4267:33253:3841:3838:17555:43991",
		"39211:40358:40768:7823:40827:48275",
		"35136:6706:35481:40966:41383:15177:48274",
		"39211:40358:40768:7823:40827:48275:48273",
		--["name"] = "Honor's Stand, Southern Barrens",
		["m"] = 199,
		["f"] = 0,
		["direct"] = "16227:34378:35136:39212:39211",
		["coord"] = 1673731057,
		},
		},
	[2] = {
	[8609] = {
	"2409:523",
	"43087:43088:931",
	"43087:43086:2299:2941:1573",
	"43087:43086:2299:44410:44409:1572:1571",
	"43087:43086:2299:44410:44409:1572",
	"43087:43086:2299:44410:44409:1572:2835",
	"43107:2859",
	"43087:43086:2299:44410:44409:1572:2835:8018",
	"43087:43086:2299:44410:44409:1572:2835:8018:12596",
	"43087:43086:2299:44410:44407:12617",
	"43087:43086:2299:2941",
	"43087:43086:2299:44410:44407:12617:44230:44233",
	"43087:43086:2299:44410:44407:12617:44230:28621",
	"43087:43086:2299:44410:44407:12617:44230",
	"43087:43086:2299:44410:44407:12617:44231:44232",
	"2409:43045",
	"43087:43086:2299:44410:44407:12617:24851",
	"43087:43086:2299:2941:1573:26560",
	"43087:43086:2299:44410:44407:12617:29480",
	"43087:43086:2299:44410:44409:1572:2835:8018:12596:37888",
	"43087:43086:2299:44410:44409:1572:41321:41322:41323",
	"43087:43086:2299:44410:44409:1572:41321:41322",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325",
	"43087:43086:2299:44410:44409:1572:41321",
	"43087:43086:2299:44410:44407:41332",
	"2409:42983",
	"2409:523:42426",
	"2409:523:42406",
	"43087:43088:931:43000",
	"2409:43045:43042",
	"2409:43045:43042:43043",
	"43087:43086:43072",
	"43087:43086",
	"43087:43088",
	"43087:43086:2299:2941:1573:43290",
	"43087:43086:43072:43371",
	"43087:43086:2299:44410:44409:1572:2835:43570",
	"43087:43086:2299:2941:1573:43701",
	"43087:43086:2299:44410:44409:1572:43702",
	"2409:43697",
	"43087:43086:2299:44410:44407:12617:44231",
	"43087:43086:2299:44410:44409",
	"43087:43086:2299:44410",
	"43087:43086:2299:44410:44407",
	"43087:43086:2299:44410:44409:1572:2835:8018:46006",
	"43087:43086:2299:44410:44409:1572:2835:8018:46006:46011",
	"43087:43086:2299:44410:44409:1572:47119",
	"43087:43086:2299:44410:44409:1572:47119:47147:47118",
	"43087:43086:2299:44410:44409:1572:47119:47147",
	"43087:43086:2299:44410:44409:1572:47119:47147:47154",
	"43087:43086:2299:44410:44409:1572:47119:47155",
	"43087:43086:2299:44410:44409:1572:2835:8018:46006:46011:47875",
	"43087:43086:2299:2941:47927",
	"43087:43086:2299:48321:48318",
	"43087:43086:2299:48321",
	--["name"] = "Nethergarde Keep, Blasted Lands",
	["m"] = 17,
	["f"] = 0,
	["direct"] = "352:2409:2299:43087:43107",
	["coord"] = 2629056373,
	},
	[2941] = {
	"352:523",
	"2299:931",
	"1573:1571",
	"2299:931:2409",
	"1572:2835",
	"352:2859",
	"1572:2835:8018",
	"2299:43086:43087:8609",
	"1573:12596",
	"1572:2835:43570:12617",
	"1573:12596:46011:47875:44233",
	"1572:2835:43570:12617:44230:28621",
	"1572:2835:43570:12617:44230",
	"1573:12596:37888:44232",
	"352:43045",
	"1572:2835:43570:12617:24851",
	"1573:26560",
	"1572:2835:43570:12617:29480",
	"1573:12596:37888",
	"1572:41321:41322:41323",
	"1572:41321:41322",
	"1572:41321:41322:41325",
	"1572:41321",
	"1572:41332",
	"352:42983",
	"352:523:42426",
	"352:42406",
	"2299:931:43000",
	"352:43045:43042",
	"352:43045:43042:43043",
	"2299:43086:43072",
	"2299:43086:43087",
	"2299:43086",
	"2299:931:43088",
	"2299:43086:43087:8609:43107",
	"1573:43290",
	"2299:931:43371",
	"1572:2835:43570",
	"1573:43701",
	"1572:43702",
	"352:523:43697",
	"1572:2835:43570:12617:44231",
	"1572:44409",
	"2299:44410",
	"1572:44409:44407",
	"1573:12596:46006",
	"1573:12596:46011",
	"1572:47119",
	"1572:47119:47147:47118",
	"1572:47119:47147",
	"1572:47119:47147:47154",
	"1572:47119:47155",
	"1573:12596:46011:47875",
	"47927:48318",
	"47927:48318:48321",
	--["name"] = "Thorium Point, Searing Gorge",
	["m"] = 32,
	["coord"] = 1627868895,
	["direct"] = "352:1573:1572:2299:47927",
	["f"] = 0,
	},
	[47154] = {
	"47147:47119:1572:2941:352",
	"47147:47119:1572:2941:352:523",
	"47147:47119:1572:44409:44410:2299:931",
	"47147:47119:1572:1573",
	"47147:47119:1572:1571",
	"47147:47119:1572",
	"47147:47119:1572:44409:44410:2299:931:2409",
	"47147:47119:1572:2835",
	"47147:47119:1572:2941:352:2859",
	"47147:47119:1572:2835:8018",
	"47147:47119:1572:44409:44410:2299:43086:43087:8609",
	"47147:47119:1572:2835:8018:12596",
	"47147:47119:1572:2835:43570:12617",
	"47147:47119:1572:44409:44410:2299",
	"47147:47119:1572:2941",
	"47147:47119:1572:2835:43570:12617:44230:44233",
	"47147:47119:1572:2835:43570:12617:44230:28621",
	"47147:47119:1572:2835:43570:12617:44230",
	"47147:47119:1572:2835:8018:12596:37888:44232",
	"47147:47119:1572:2941:352:43045",
	"47147:47119:1572:2835:43570:12617:24851",
	"47147:47119:1572:1573:26560",
	"47147:47119:1572:2835:43570:12617:29480",
	"47147:47119:1572:2835:8018:12596:37888",
	"47147:47119:1572:41321:41322:41323",
	"47147:47119:1572:41321:41322",
	"47147:47119:1572:41321:41322:41325",
	"47147:47119:1572:41321",
	"47147:47119:1572:41332",
	"47147:47119:1572:2941:352:42983",
	"47147:47119:1572:2941:352:523:42426",
	"47147:47119:1572:2941:352:42406",
	"47147:47119:1572:44409:44410:2299:931:43000",
	"47147:47119:1572:2941:352:43045:43042",
	"47147:47119:1572:2941:352:43045:43042:43043",
	"47147:47119:1572:44409:44410:2299:43086:43072",
	"47147:47119:1572:44409:44410:2299:43086:43087",
	"47147:47119:1572:44409:44410:2299:43086",
	"47147:47119:1572:44409:44410:2299:931:43088",
	"47147:47119:1572:44409:44410:2299:43086:43087:8609:43107",
	"47147:47119:1572:1573:43290",
	"47147:47119:1572:44409:44410:2299:931:43371",
	"47147:47119:1572:2835:43570",
	"47147:47119:1572:43702:43701",
	"47147:47119:1572:43702",
	"47147:47119:1572:2941:352:523:43697",
	"47147:47119:1572:2835:43570:12617:44231",
	"47147:47119:1572:44409",
	"47147:47119:1572:44409:44410",
	"47147:47119:1572:44409:44407",
	"47147:47119:1572:2835:8018:46006",
	"47147:47119:1572:2835:8018:46006:46011",
	"47147:47119",
	"47147:47119:1572:2835:8018:46006:46011:47875",
	"47147:47119:1572:2941:47927",
	"47147:47119:1572:2941:47927:48318",
	"47147:47119:1572:44409:44410:2299:48321",
	--["name"] = "Thundermar, Twilight Highlands",
	["m"] = 241,
	["f"] = 0,
	["direct"] = "47118:47147:47155",
	["coord"] = 2083407912,
	},
	[28621] = {
	"44232:37888:12596:1573:2941:352",
	"44230:12617:44407:44410:2299:931:523",
	"44230:12617:44407:44410:2299:931",
	"44232:37888:12596:1573",
	"44230:12617:43570:2835:1571",
	"44230:12617:43570:2835:1572",
	"44230:12617:44407:44410:2299:931:2409",
	"44230:12617:43570:2835",
	"44230:12617:44407:44410:2299:931:2409:43045:2859",
	"44232:37888:12596:8018",
	"44230:12617:44407:44410:2299:43086:43087:8609",
	"44232:37888:12596",
	"44230:12617",
	"44230:12617:44407:44410:2299",
	"44232:37888:12596:1573:2941",
	"44230:12617:44407:44410:2299:931:2409:43045",
	"44230:12617:24851",
	"44230:12617:26560",
	"44230:12617:29480",
	"44232:37888",
	"44230:12617:43570:2835:41325:41323",
	"44230:12617:43570:2835:41325:41322",
	"44230:12617:43570:2835:41325",
	"44230:12617:43570:2835:41325:41322:41321",
	"44230:12617:44407:41332",
	"44230:12617:44407:44410:2299:931:43000:42983",
	"44230:12617:44407:44410:2299:931:523:42426",
	"44232:37888:12596:1573:2941:352:42406",
	"44230:12617:44407:44410:2299:931:43000",
	"44230:12617:44407:44410:2299:931:2409:43045:43042",
	"44230:12617:44407:44410:2299:931:2409:43045:43042:43043",
	"44230:12617:44407:44410:2299:43086:43072",
	"44230:12617:44407:44410:2299:43086:43087",
	"44230:12617:44407:44410:2299:43086",
	"44230:12617:44407:44410:2299:931:43088",
	"44230:12617:44407:44410:2299:43086:43087:8609:43107",
	"44232:37888:12596:1573:43290",
	"44230:12617:44407:44410:2299:931:43371",
	"44230:12617:43570",
	"44232:37888:12596:1573:43701",
	"44232:37888:12596:1573:43702",
	"44230:12617:44407:44410:2299:931:2409:43697",
	"44230:44231",
	"44230:12617:44407:44409",
	"44230:12617:44407:44410",
	"44230:12617:44407",
	"44232:37888:46011:46006",
	"44232:37888:46011",
	"44230:12617:43570:2835:1572:47119",
	"44230:12617:43570:2835:1572:47119:47147:47118",
	"44230:12617:43570:2835:1572:47119:47147",
	"44230:12617:43570:2835:1572:47119:47147:47154",
	"44230:12617:43570:2835:1572:47119:47155",
	"44233:47875",
	"44232:37888:12596:1573:2941:47927",
	"44232:37888:12596:1573:2941:47927:48318",
	"44230:12617:44407:44410:2299:48321",
	--["name"] = "Northpass Tower, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 2202547784,
	["direct"] = "44233:44230:44232",
	["f"] = 0,
	},
	[43000] = {
	"42983:352",
	"42983:352:523",
	"931:2299:2941:1573",
	"931:2299:44410:44409:1572:1571",
	"931:2299:44410:44409:1572",
	"931:2409",
	"931:2299:44410:44409:1572:2835",
	"931:2409:43045:2859",
	"931:2299:44410:44409:1572:2835:8018",
	"931:43088:43087:8609",
	"931:2299:44410:44409:1572:2835:8018:12596",
	"931:2299:44410:44407:12617",
	"931:2299",
	"931:2299:2941",
	"931:2299:44410:44407:12617:44230:44233",
	"931:2299:44410:44407:12617:44230:28621",
	"931:2299:44410:44407:12617:44230",
	"931:2299:44410:44407:12617:44231:44232",
	"931:2409:43045",
	"931:2299:44410:44407:12617:24851",
	"931:2299:2941:1573:26560",
	"931:2299:44410:44407:12617:29480",
	"931:2299:44410:44409:1572:2835:8018:12596:37888",
	"931:2299:44410:44409:1572:41321:41322:41323",
	"931:2299:44410:44409:1572:41321:41322",
	"931:2299:44410:44409:1572:41321:41322:41325",
	"931:2299:44410:44409:1572:41321",
	"931:2299:44410:44407:41332",
	"42983:352:523:42426",
	"42983:352:42406",
	"931:2409:43045:43042",
	"931:2409:43045:43042:43043",
	"931:43371:43072",
	"931:43088:43087",
	"931:43371:43072:43086",
	"931:43088",
	"931:43088:43087:8609:43107",
	"931:2299:2941:1573:43290",
	"931:43371",
	"931:2299:44410:44409:1572:2835:43570",
	"931:2299:2941:1573:43701",
	"931:2299:44410:44409:1572:43702",
	"931:2409:43697",
	"931:2299:44410:44407:12617:44231",
	"931:2299:44410:44409",
	"931:2299:44410",
	"931:2299:44410:44407",
	"931:2299:44410:44409:1572:2835:8018:46006",
	"931:2299:44410:44409:1572:2835:8018:46006:46011",
	"931:2299:44410:44409:1572:47119",
	"931:2299:44410:44409:1572:47119:47147:47118",
	"931:2299:44410:44409:1572:47119:47147",
	"931:2299:44410:44409:1572:47119:47147:47154",
	"931:2299:44410:44409:1572:47119:47155",
	"931:2299:44410:44409:1572:2835:8018:46006:46011:47875",
	"931:2299:2941:47927",
	"931:2299:48321:48318",
	"931:2299:48321",
	--["name"] = "Eastvale Logging Camp, Elwynn",
	["m"] = 37,
	["coord"] = 3516508745,
	["direct"] = "931:42983",
	["f"] = 0,
	},
	[1573] = {
	"2941:352:523",
	"2941:2299:931",
	"2941:2299:931:2409",
	"2941:352:2859",
	"2941:2299:43086:43087:8609",
	"2941:2299",
	"12596:46011:47875:44233",
	"12617:44230:28621",
	"12617:44230",
	"12596:37888:44232",
	"2941:352:43045",
	"12617:24851",
	"12617:29480",
	"12596:37888",
	"1571:41323",
	"1572:41321:41322",
	"1571:41323:41325",
	"1572:41321",
	"1572:41332",
	"2941:352:42983",
	"2941:352:523:42426",
	"2941:352:42406",
	"2941:2299:931:43000",
	"2941:352:43045:43042",
	"2941:352:43045:43042:43043",
	"2941:2299:43086:43072",
	"2941:2299:43086:43087",
	"2941:2299:43086",
	"2941:2299:931:43088",
	"2941:2299:43086:43087:8609:43107",
	"2941:2299:931:43371",
	"2835:43570",
	"2941:352:523:43697",
	"12617:44231",
	"1572:44409",
	"1572:44409:44410",
	"1572:44409:44407",
	"12596:46006",
	"12596:46011",
	"1572:47119",
	"1572:47119:47147:47118",
	"1572:47119:47147",
	"1572:47119:47147:47154",
	"1572:47119:47155",
	"12596:46011:47875",
	"2941:47927",
	"2941:47927:48318",
	"2941:47927:48318:48321",
	--["name"] = "Ironforge, Dun Morogh",
	["m"] = 87,
	["coord"] = 2400090763,
	["direct"] = "352:1571:1572:2835:8018:12596:12617:2941:26560:43290:43701:43702",
	["f"] = 0,
	},
	[43697] = {
	"523:352",
	"2409:931",
	"523:352:1573",
	"523:352:1573:1571",
	"2409:931:2299:44410:44409:1572",
	"2409:931:2299:44410:44409:1572:2835",
	"43045:2859",
	"2409:931:2299:44410:44409:1572:2835:8018",
	"2409:8609",
	"523:352:1573:12596",
	"2409:931:2299:44410:44407:12617",
	"2409:931:2299",
	"523:352:2941",
	"2409:931:2299:44410:44407:12617:44230:44233",
	"2409:931:2299:44410:44407:12617:44230:28621",
	"2409:931:2299:44410:44407:12617:44230",
	"2409:931:2299:44410:44407:12617:44231:44232",
	"2409:931:2299:44410:44407:12617:24851",
	"523:352:1573:26560",
	"2409:931:2299:44410:44407:12617:29480",
	"523:352:1573:12596:37888",
	"2409:931:2299:44410:44409:1572:41321:41322:41323",
	"2409:931:2299:44410:44409:1572:41321:41322",
	"2409:931:2299:44410:44409:1572:41321:41322:41325",
	"2409:931:2299:44410:44409:1572:41321",
	"2409:931:2299:44410:44407:41332",
	"2409:42983",
	"523:42426",
	"523:42406",
	"2409:931:43000",
	"43045:43042",
	"43045:43042:43043",
	"2409:931:43371:43072",
	"2409:8609:43087",
	"2409:931:43371:43072:43086",
	"2409:931:43088",
	"2409:8609:43107",
	"523:352:1573:43290",
	"2409:931:43371",
	"2409:931:2299:44410:44409:1572:2835:43570",
	"523:352:1573:43701",
	"2409:931:2299:44410:44409:1572:43702",
	"2409:931:2299:44410:44407:12617:44231",
	"2409:931:2299:44410:44409",
	"2409:931:2299:44410",
	"2409:931:2299:44410:44407",
	"2409:931:2299:44410:44409:1572:2835:8018:46006",
	"2409:931:2299:44410:44409:1572:2835:8018:46006:46011",
	"2409:931:2299:44410:44409:1572:47119",
	"2409:931:2299:44410:44409:1572:47119:47147:47118",
	"2409:931:2299:44410:44409:1572:47119:47147",
	"2409:931:2299:44410:44409:1572:47119:47147:47154",
	"2409:931:2299:44410:44409:1572:47119:47155",
	"2409:931:2299:44410:44409:1572:2835:8018:46006:46011:47875",
	"523:352:2941:47927",
	"2409:931:2299:48321:48318",
	"2409:931:2299:48321",
	--["name"] = "Raven Hill, Duskwood",
	["m"] = 47,
	["coord"] = 903123160,
	["direct"] = "523:2409:43045",
	["f"] = 0,
	},
	[46006] = {
	"12596:1573:2941:352",
	"12596:1573:2941:352:523",
	"12596:1573:2941:2299:931",
	"12596:1573",
	"8018:2835:1571",
	"8018:2835:1572",
	"12596:1573:2941:2299:931:2409",
	"8018:2835",
	"12596:1573:2941:352:2859",
	"12596:1573:2941:2299:43086:43087:8609",
	"46011:37888:12617",
	"12596:1573:2941:2299",
	"12596:1573:2941",
	"46011:47875:44233",
	"46011:37888:44232:28621",
	"46011:37888:44232:44231:44230",
	"46011:37888:44232",
	"12596:1573:2941:352:43045",
	"46011:37888:12617:24851",
	"46011:37888:12617:26560",
	"46011:37888:12617:29480",
	"46011:37888",
	"8018:2835:41325:41323",
	"8018:2835:41325:41322",
	"8018:2835:41325",
	"8018:2835:41325:41322:41321",
	"8018:2835:1572:41332",
	"12596:1573:2941:352:42983",
	"12596:1573:2941:352:523:42426",
	"12596:1573:2941:352:42406",
	"12596:1573:2941:2299:931:43000",
	"12596:1573:2941:352:43045:43042",
	"12596:1573:2941:352:43045:43042:43043",
	"12596:1573:2941:2299:43086:43072",
	"12596:1573:2941:2299:43086:43087",
	"12596:1573:2941:2299:43086",
	"12596:1573:2941:2299:931:43088",
	"12596:1573:2941:2299:43086:43087:8609:43107",
	"12596:1573:2941:2299:931:43371",
	"8018:43570",
	"12596:1573:43701",
	"12596:1573:43702",
	"12596:1573:2941:352:523:43697",
	"46011:37888:44232:44231",
	"8018:2835:1572:44409",
	"8018:2835:1572:44409:44410",
	"8018:2835:1572:44409:44407",
	"8018:2835:1572:47119",
	"8018:2835:1572:47119:47147:47118",
	"8018:2835:1572:47119:47147",
	"8018:2835:1572:47119:47147:47154",
	"8018:2835:1572:47119:47155",
	"46011:47875",
	"12596:1573:2941:47927",
	"12596:1573:2941:47927:48318",
	"12596:1573:2941:47927:48318:48321",
	--["name"] = "Andorhal, Western Plaguelands",
	["m"] = 22,
	["coord"] = 1692905936,
	["direct"] = "8018:12596:46011",
	["f"] = 0,
	},
	[43701] = {
	"1573:2941:352",
	"1573:2941:352:523",
	"1573:2941:2299:931",
	"1573:1571",
	"43702:1572",
	"1573:2941:2299:931:2409",
	"1573:2835",
	"1573:2941:352:2859",
	"1573:8018",
	"1573:2941:2299:43086:43087:8609",
	"1573:12596",
	"1573:12617",
	"1573:2941:2299",
	"1573:2941",
	"1573:12596:46011:47875:44233",
	"1573:12617:44230:28621",
	"1573:12617:44230",
	"1573:12596:37888:44232",
	"1573:2941:352:43045",
	"1573:12617:24851",
	"1573:26560",
	"1573:12617:29480",
	"1573:12596:37888",
	"1573:1571:41323",
	"43702:1572:41321:41322",
	"43702:1572:41321:41322:41325",
	"43702:1572:41321",
	"43702:1572:41332",
	"1573:2941:352:42983",
	"1573:2941:352:523:42426",
	"1573:2941:352:42406",
	"1573:2941:2299:931:43000",
	"1573:2941:352:43045:43042",
	"1573:2941:352:43045:43042:43043",
	"1573:2941:2299:43086:43072",
	"1573:2941:2299:43086:43087",
	"1573:2941:2299:43086",
	"1573:2941:2299:931:43088",
	"1573:2941:2299:43086:43087:8609:43107",
	"1573:43290",
	"1573:2941:2299:931:43371",
	"1573:2835:43570",
	"1573:2941:352:523:43697",
	"1573:12617:44231",
	"43702:1572:44409",
	"43702:1572:44409:44410",
	"43702:1572:44409:44407",
	"1573:12596:46006",
	"1573:12596:46011",
	"43702:1572:47119",
	"43702:1572:47119:47147:47118",
	"43702:1572:47119:47147",
	"43702:1572:47119:47147:47154",
	"43702:1572:47119:47155",
	"1573:12596:46011:47875",
	"1573:2941:47927",
	"1573:2941:47927:48318",
	"1573:2941:47927:48318:48321",
	--["name"] = "Kharanos, Dun Morogh",
	["m"] = 27,
	["coord"] = 2308343503,
	["direct"] = "1573:43702",
	["f"] = 0,
	},
	[47875] = {
	"46011:12596:1573:2941:352",
	"46011:12596:1573:2941:352:523",
	"46011:12596:1573:2941:2299:931",
	"46011:12596:1573",
	"46011:46006:8018:2835:1571",
	"46011:46006:8018:2835:1572",
	"46011:12596:1573:2941:2299:931:2409",
	"46011:46006:8018:2835",
	"46011:12596:1573:2941:352:2859",
	"46011:46006:8018",
	"46011:12596:1573:2941:2299:43086:43087:8609",
	"46011:12596",
	"44233:44230:12617",
	"46011:12596:1573:2941:2299",
	"46011:12596:1573:2941",
	"44233:28621",
	"44233:44230",
	"44233:44232",
	"46011:12596:1573:2941:352:43045",
	"44233:44230:12617:24851",
	"44233:44230:12617:26560",
	"44233:44230:12617:29480",
	"46011:37888",
	"46011:46006:8018:2835:41325:41323",
	"46011:46006:8018:2835:41325:41322",
	"46011:46006:8018:2835:41325",
	"46011:46006:8018:2835:41325:41322:41321",
	"46011:46006:8018:2835:1572:41332",
	"46011:12596:1573:2941:352:42983",
	"46011:12596:1573:2941:352:523:42426",
	"46011:12596:1573:2941:352:42406",
	"46011:12596:1573:2941:2299:931:43000",
	"46011:12596:1573:2941:352:43045:43042",
	"46011:12596:1573:2941:352:43045:43042:43043",
	"46011:12596:1573:2941:2299:43086:43072",
	"46011:12596:1573:2941:2299:43086:43087",
	"46011:12596:1573:2941:2299:43086",
	"46011:12596:1573:2941:2299:931:43088",
	"46011:12596:1573:2941:2299:43086:43087:8609:43107",
	"46011:12596:1573:43290",
	"46011:12596:1573:2941:2299:931:43371",
	"46011:37888:43570",
	"46011:12596:1573:43701",
	"46011:12596:1573:43702",
	"46011:12596:1573:2941:352:523:43697",
	"44233:44231",
	"46011:46006:8018:2835:1572:44409",
	"46011:46006:8018:2835:1572:44409:44410",
	"46011:46006:8018:2835:1572:44409:44407",
	"46011:46006",
	"46011:46006:8018:2835:1572:47119",
	"46011:46006:8018:2835:1572:47119:47147:47118",
	"46011:46006:8018:2835:1572:47119:47147",
	"46011:46006:8018:2835:1572:47119:47147:47154",
	"46011:46006:8018:2835:1572:47119:47155",
	"46011:12596:1573:2941:47927",
	"46011:12596:1573:2941:47927:48318",
	"46011:12596:1573:2941:47927:48318:48321",
	--["name"] = "Hearthglen, Western Plaguelands",
	["m"] = 22,
	["coord"] = 1914908428,
	["direct"] = "44233:46011",
	["f"] = 0,
	},
	[42406] = {
	"523:931",
	"352:1573",
	"352:1573:1571",
	"352:2941:1572",
	"523:43697:2409",
	"352:2941:1572:2835",
	"523:43045:2859",
	"352:1573:8018",
	"523:43697:2409:8609",
	"352:1573:12596",
	"352:2941:1572:2835:43570:12617",
	"352:2299",
	"352:2941",
	"352:1573:12596:46011:47875:44233",
	"352:2941:1572:2835:43570:12617:44230:28621",
	"352:2941:1572:2835:43570:12617:44230",
	"352:1573:12596:37888:44232",
	"523:43045",
	"352:2941:1572:2835:43570:12617:24851",
	"352:1573:26560",
	"352:2941:1572:2835:43570:12617:29480",
	"352:1573:12596:37888",
	"352:2941:1572:41321:41322:41323",
	"352:2941:1572:41321:41322",
	"352:2941:1572:41321:41322:41325",
	"352:2941:1572:41321",
	"352:2941:1572:41332",
	"352:42983",
	"523:42426",
	"352:42983:43000",
	"523:43045:43042",
	"523:43045:43042:43043",
	"523:931:43371:43072",
	"523:931:43088:43087",
	"523:931:43371:43072:43086",
	"523:931:43088",
	"523:43697:2409:8609:43107",
	"352:1573:43290",
	"523:931:43371",
	"352:2941:1572:2835:43570",
	"352:1573:43701",
	"352:1573:43702",
	"523:43697",
	"352:2941:1572:2835:43570:12617:44231",
	"352:2299:44410:44409",
	"352:2299:44410",
	"352:2299:44410:44407",
	"352:1573:12596:46006",
	"352:1573:12596:46011",
	"352:2941:1572:47119",
	"352:2941:1572:47119:47147:47118",
	"352:2941:1572:47119:47147",
	"352:2941:1572:47119:47147:47154",
	"352:2941:1572:47119:47155",
	"352:1573:12596:46011:47875",
	"352:2941:47927",
	"352:2941:47927:48318",
	"352:2299:48321",
	--["name"] = "Furlbrow's Pumpkin Farm, Westfall",
	["m"] = 52,
	["coord"] = 2138583068,
	["direct"] = "352:523",
	["f"] = 0,
	},
	[46011] = {
	"12596:1573:2941:352",
	"12596:1573:2941:352:523",
	"12596:1573:2941:2299:931",
	"12596:1573",
	"46006:8018:2835:1571",
	"46006:8018:2835:1572",
	"12596:1573:2941:2299:931:2409",
	"46006:8018:2835",
	"12596:1573:2941:352:2859",
	"46006:8018",
	"12596:1573:2941:2299:43086:43087:8609",
	"37888:12617",
	"12596:1573:2941:2299",
	"12596:1573:2941",
	"47875:44233",
	"37888:44232:28621",
	"37888:44232:44231:44230",
	"37888:44232",
	"12596:1573:2941:352:43045",
	"37888:12617:24851",
	"37888:12617:26560",
	"37888:12617:29480",
	"46006:8018:2835:41325:41323",
	"46006:8018:2835:41325:41322",
	"46006:8018:2835:41325",
	"46006:8018:2835:41325:41322:41321",
	"46006:8018:2835:1572:41332",
	"12596:1573:2941:352:42983",
	"12596:1573:2941:352:523:42426",
	"12596:1573:2941:352:42406",
	"12596:1573:2941:2299:931:43000",
	"12596:1573:2941:352:43045:43042",
	"12596:1573:2941:352:43045:43042:43043",
	"12596:1573:2941:2299:43086:43072",
	"12596:1573:2941:2299:43086:43087",
	"12596:1573:2941:2299:43086",
	"12596:1573:2941:2299:931:43088",
	"12596:1573:2941:2299:43086:43087:8609:43107",
	"12596:1573:43290",
	"12596:1573:2941:2299:931:43371",
	"37888:43570",
	"12596:1573:43701",
	"12596:1573:43702",
	"12596:1573:2941:352:523:43697",
	"37888:44232:44231",
	"46006:8018:2835:1572:44409",
	"46006:8018:2835:1572:44409:44410",
	"46006:8018:2835:1572:44409:44407",
	"46006:8018:2835:1572:47119",
	"46006:8018:2835:1572:47119:47147:47118",
	"46006:8018:2835:1572:47119:47147",
	"46006:8018:2835:1572:47119:47147:47154",
	"46006:8018:2835:1572:47119:47155",
	"12596:1573:2941:47927",
	"12596:1573:2941:47927:48318",
	"12596:1573:2941:47927:48318:48321",
	--["name"] = "The Menders' Stead, Western Plaguelands",
	["m"] = 22,
	["coord"] = 2170193372,
	["direct"] = "12596:37888:46006:47875",
	["f"] = 0,
	},
	[24851] = {
	"12617:43570:2835:1572:2941:352",
	"12617:44407:44410:2299:931:523",
	"12617:44407:44410:2299:931",
	"12617:1573",
	"12617:43570:2835:1571",
	"12617:43570:2835:1572",
	"12617:44407:44410:2299:931:2409",
	"12617:43570:2835",
	"12617:44407:44410:2299:931:2409:43045:2859",
	"12617:8018",
	"12617:44407:44410:2299:43086:43087:8609",
	"12617:12596",
	"12617:44407:44410:2299",
	"12617:43570:2835:1572:2941",
	"12617:44230:44233",
	"12617:44230:28621",
	"12617:44230",
	"12617:44231:44232",
	"12617:44407:44410:2299:931:2409:43045",
	"12617:29480",
	"12617:37888",
	"12617:43570:2835:41325:41323",
	"12617:43570:2835:41325:41322",
	"12617:43570:2835:41325",
	"12617:43570:2835:41325:41322:41321",
	"12617:44407:41332",
	"12617:44407:44410:2299:931:43000:42983",
	"12617:44407:44410:2299:931:523:42426",
	"12617:43570:2835:1572:2941:352:42406",
	"12617:44407:44410:2299:931:43000",
	"12617:44407:44410:2299:931:2409:43045:43042",
	"12617:44407:44410:2299:931:2409:43045:43042:43043",
	"12617:44407:44410:2299:43086:43072",
	"12617:44407:44410:2299:43086:43087",
	"12617:44407:44410:2299:43086",
	"12617:44407:44410:2299:931:43088",
	"12617:44407:44410:2299:43086:43087:8609:43107",
	"12617:1573:43290",
	"12617:44407:44410:2299:931:43371",
	"12617:43570",
	"12617:1573:43701",
	"12617:43570:2835:1572:43702",
	"12617:44407:44410:2299:931:2409:43697",
	"12617:44231",
	"12617:44407:44409",
	"12617:44407:44410",
	"12617:44407",
	"12617:37888:46011:46006",
	"12617:37888:46011",
	"12617:43570:2835:1572:47119",
	"12617:43570:2835:1572:47119:47147:47118",
	"12617:43570:2835:1572:47119:47147",
	"12617:43570:2835:1572:47119:47147:47154",
	"12617:43570:2835:1572:47119:47155",
	"12617:44230:44233:47875",
	"12617:43570:2835:1572:2941:47927",
	"12617:44407:44410:2299:48321:48318",
	"12617:44407:44410:2299:48321",
	--["name"] = "Zul'Aman, Ghostlands",
	["m"] = 95,
	["direct"] = "12617:26560",
	["coord"] = 3210652679,
	["f"] = 0,
	},
	[12617] = {
	"43570:2835:1572:2941:352",
	"44407:44410:2299:931:523",
	"44407:44410:2299:931",
	"43570:2835:1571",
	"43570:2835:1572",
	"44407:44410:2299:931:2409",
	"43570:2835",
	"44407:44410:2299:931:2409:43045:2859",
	"44407:44410:2299:43086:43087:8609",
	"44407:44410:2299",
	"43570:2835:1572:2941",
	"44230:44233",
	"44230:28621",
	"44231:44232",
	"44407:44410:2299:931:2409:43045",
	"43570:2835:41325:41323",
	"43570:2835:41325:41322",
	"43570:2835:41325",
	"43570:2835:41325:41322:41321",
	"44407:41332",
	"44407:44410:2299:931:43000:42983",
	"44407:44410:2299:931:523:42426",
	"43570:2835:1572:2941:352:42406",
	"44407:44410:2299:931:43000",
	"44407:44410:2299:931:2409:43045:43042",
	"44407:44410:2299:931:2409:43045:43042:43043",
	"44407:44410:2299:43086:43072",
	"44407:44410:2299:43086:43087",
	"44407:44410:2299:43086",
	"44407:44410:2299:931:43088",
	"44407:44410:2299:43086:43087:8609:43107",
	"1573:43290",
	"44407:44410:2299:931:43371",
	"1573:43701",
	"43570:2835:1572:43702",
	"44407:44410:2299:931:2409:43697",
	"44407:44409",
	"44407:44410",
	"37888:46011:46006",
	"37888:46011",
	"43570:2835:1572:47119",
	"43570:2835:1572:47119:47147:47118",
	"43570:2835:1572:47119:47147",
	"43570:2835:1572:47119:47147:47154",
	"43570:2835:1572:47119:47155",
	"44230:44233:47875",
	"43570:2835:1572:2941:47927",
	"44407:44410:2299:48321:48318",
	"44407:44410:2299:48321",
	--["name"] = "Light's Hope Chapel, Eastern Plaguelands",
	["m"] = 23,
	["direct"] = "1573:8018:12596:44230:24851:26560:29480:37888:43570:44231:44407",
	["coord"] = 3253045378,
	["f"] = 0,
	},
	[47147] = {
	"47119:1572:2941:352",
	"47119:1572:2941:352:523",
	"47119:1572:44409:44410:2299:931",
	"47119:1572:1573",
	"47119:1572:1571",
	"47119:1572",
	"47119:1572:44409:44410:2299:931:2409",
	"47119:1572:2835",
	"47119:1572:2941:352:2859",
	"47119:1572:2835:8018",
	"47119:1572:44409:44410:2299:43086:43087:8609",
	"47119:1572:2835:8018:12596",
	"47119:1572:2835:43570:12617",
	"47119:1572:44409:44410:2299",
	"47119:1572:2941",
	"47119:1572:2835:43570:12617:44230:44233",
	"47119:1572:2835:43570:12617:44230:28621",
	"47119:1572:2835:43570:12617:44230",
	"47119:1572:2835:8018:12596:37888:44232",
	"47119:1572:2941:352:43045",
	"47119:1572:2835:43570:12617:24851",
	"47119:1572:1573:26560",
	"47119:1572:2835:43570:12617:29480",
	"47119:1572:2835:8018:12596:37888",
	"47119:1572:41321:41322:41323",
	"47119:1572:41321:41322",
	"47119:1572:41321:41322:41325",
	"47119:1572:41321",
	"47119:1572:41332",
	"47119:1572:2941:352:42983",
	"47119:1572:2941:352:523:42426",
	"47119:1572:2941:352:42406",
	"47119:1572:44409:44410:2299:931:43000",
	"47119:1572:2941:352:43045:43042",
	"47119:1572:2941:352:43045:43042:43043",
	"47119:1572:44409:44410:2299:43086:43072",
	"47119:1572:44409:44410:2299:43086:43087",
	"47119:1572:44409:44410:2299:43086",
	"47119:1572:44409:44410:2299:931:43088",
	"47119:1572:44409:44410:2299:43086:43087:8609:43107",
	"47119:1572:1573:43290",
	"47119:1572:44409:44410:2299:931:43371",
	"47119:1572:2835:43570",
	"47119:1572:43702:43701",
	"47119:1572:43702",
	"47119:1572:2941:352:523:43697",
	"47119:1572:2835:43570:12617:44231",
	"47119:1572:44409",
	"47119:1572:44409:44410",
	"47119:1572:44409:44407",
	"47119:1572:2835:8018:46006",
	"47119:1572:2835:8018:46006:46011",
	"47119:1572:2835:8018:46006:46011:47875",
	"47119:1572:2941:47927",
	"47119:1572:2941:47927:48318",
	"47119:1572:44409:44410:2299:48321",
	--["name"] = "Firebeard's Patrol, Twilight Highlands",
	["m"] = 241,
	["f"] = 0,
	["direct"] = "47119:47118:47154:47155",
	["coord"] = 2593428401,
	},
	[41321] = {
	"1572:2941:352",
	"1572:2941:352:523",
	"1572:44409:44410:2299:931",
	"1572:1573",
	"41322:41323:1571",
	"1572:44409:44410:2299:931:2409",
	"41322:41325:2835",
	"1572:2941:352:2859",
	"41322:41325:2835:8018",
	"1572:44409:44410:2299:43086:43087:8609",
	"41322:41325:2835:8018:12596",
	"41322:41325:2835:43570:12617",
	"1572:44409:44410:2299",
	"1572:2941",
	"41322:41325:2835:43570:12617:44230:44233",
	"41322:41325:2835:43570:12617:44230:28621",
	"41322:41325:2835:43570:12617:44230",
	"41322:41325:2835:8018:12596:37888:44232",
	"1572:2941:352:43045",
	"41322:41325:2835:43570:12617:24851",
	"41322:41325:2835:43570:12617:26560",
	"41322:41325:2835:43570:12617:29480",
	"41322:41325:2835:8018:12596:37888",
	"41322:41323",
	"41322:41325",
	"1572:41332",
	"1572:2941:352:42983",
	"1572:2941:352:523:42426",
	"1572:2941:352:42406",
	"1572:44409:44410:2299:931:43000",
	"1572:2941:352:43045:43042",
	"1572:2941:352:43045:43042:43043",
	"1572:44409:44410:2299:43086:43072",
	"1572:44409:44410:2299:43086:43087",
	"1572:44409:44410:2299:43086",
	"1572:44409:44410:2299:931:43088",
	"1572:44409:44410:2299:43086:43087:8609:43107",
	"1572:1573:43290",
	"1572:44409:44410:2299:931:43371",
	"41322:41325:2835:43570",
	"1572:43702:43701",
	"1572:43702",
	"1572:2941:352:523:43697",
	"41322:41325:2835:43570:12617:44231",
	"1572:44409",
	"1572:44409:44410",
	"1572:44409:44407",
	"41322:41325:2835:8018:46006",
	"41322:41325:2835:8018:46006:46011",
	"1572:47119",
	"1572:47119:47147:47118",
	"1572:47119:47147",
	"1572:47119:47147:47154",
	"1572:47119:47155",
	"41322:41325:2835:8018:46006:46011:47875",
	"1572:2941:47927",
	"1572:2941:47927:48318",
	"1572:44409:44410:2299:48321",
	--["name"] = "Slabchisel's Survey, Wetlands",
	["m"] = 56,
	["coord"] = 2442638918,
	["direct"] = "1572:41322",
	["f"] = 0,
	},
	[47119] = {
	"1572:2941:352",
	"1572:2941:352:523",
	"1572:44409:44410:2299:931",
	"1572:1573",
	"1572:1571",
	"1572:44409:44410:2299:931:2409",
	"1572:2835",
	"1572:2941:352:2859",
	"1572:2835:8018",
	"1572:44409:44410:2299:43086:43087:8609",
	"1572:2835:8018:12596",
	"1572:2835:43570:12617",
	"1572:44409:44410:2299",
	"1572:2941",
	"1572:2835:43570:12617:44230:44233",
	"1572:2835:43570:12617:44230:28621",
	"1572:2835:43570:12617:44230",
	"1572:2835:8018:12596:37888:44232",
	"1572:2941:352:43045",
	"1572:2835:43570:12617:24851",
	"1572:1573:26560",
	"1572:2835:43570:12617:29480",
	"1572:2835:8018:12596:37888",
	"1572:41321:41322:41323",
	"1572:41321:41322",
	"1572:41321:41322:41325",
	"1572:41321",
	"1572:41332",
	"1572:2941:352:42983",
	"1572:2941:352:523:42426",
	"1572:2941:352:42406",
	"1572:44409:44410:2299:931:43000",
	"1572:2941:352:43045:43042",
	"1572:2941:352:43045:43042:43043",
	"1572:44409:44410:2299:43086:43072",
	"1572:44409:44410:2299:43086:43087",
	"1572:44409:44410:2299:43086",
	"1572:44409:44410:2299:931:43088",
	"1572:44409:44410:2299:43086:43087:8609:43107",
	"1572:1573:43290",
	"1572:44409:44410:2299:931:43371",
	"1572:2835:43570",
	"1572:43702:43701",
	"1572:43702",
	"1572:2941:352:523:43697",
	"1572:2835:43570:12617:44231",
	"1572:44409",
	"1572:44409:44410",
	"1572:44409:44407",
	"1572:2835:8018:46006",
	"1572:2835:8018:46006:46011",
	"47147:47118",
	"47147:47154",
	"1572:2835:8018:46006:46011:47875",
	"1572:2941:47927",
	"1572:2941:47927:48318",
	"1572:44409:44410:2299:48321",
	--["name"] = "Highbank, Twilight Highlands",
	["m"] = 241,
	["coord"] = 3508978958,
	["direct"] = "1572:47147:47155",
	["f"] = 0,
	},
	[48318] = {
	"47927:2941:352",
	"48321:2299:931:523",
	"48321:2299:931",
	"47927:2941:1573",
	"47927:2941:1573:1571",
	"47927:2941:1572",
	"48321:2299:931:2409",
	"47927:2941:1572:2835",
	"48321:2299:931:2409:43045:2859",
	"47927:2941:1572:2835:8018",
	"48321:2299:43086:43087:8609",
	"47927:2941:1573:12596",
	"47927:2941:1572:2835:43570:12617",
	"48321:2299",
	"47927:2941",
	"47927:2941:1573:12596:46011:47875:44233",
	"47927:2941:1572:2835:43570:12617:44230:28621",
	"47927:2941:1572:2835:43570:12617:44230",
	"47927:2941:1573:12596:37888:44232",
	"48321:2299:931:2409:43045",
	"47927:2941:1572:2835:43570:12617:24851",
	"47927:2941:1573:26560",
	"47927:2941:1572:2835:43570:12617:29480",
	"47927:2941:1573:12596:37888",
	"47927:2941:1572:41321:41322:41323",
	"47927:2941:1572:41321:41322",
	"47927:2941:1572:41321:41322:41325",
	"47927:2941:1572:41321",
	"47927:2941:1572:41332",
	"48321:2299:931:43000:42983",
	"48321:2299:931:523:42426",
	"47927:2941:352:42406",
	"48321:2299:931:43000",
	"48321:2299:931:2409:43045:43042",
	"48321:2299:931:2409:43045:43042:43043",
	"48321:2299:43086:43072",
	"48321:2299:43086:43087",
	"48321:2299:43086",
	"48321:2299:931:43088",
	"48321:2299:43086:43087:8609:43107",
	"47927:2941:1573:43290",
	"48321:2299:931:43371",
	"47927:2941:1572:2835:43570",
	"47927:2941:1573:43701",
	"47927:2941:1572:43702",
	"48321:2299:931:2409:43697",
	"47927:2941:1572:2835:43570:12617:44231",
	"48321:2299:44410:44409",
	"48321:2299:44410",
	"48321:2299:44410:44407",
	"47927:2941:1573:12596:46006",
	"47927:2941:1573:12596:46011",
	"47927:2941:1572:47119",
	"47927:2941:1572:47119:47147:47118",
	"47927:2941:1572:47119:47147",
	"47927:2941:1572:47119:47147:47154",
	"47927:2941:1572:47119:47155",
	"47927:2941:1573:12596:46011:47875",
	--["name"] = "Flamestar Post, Burning Steppes",
	["m"] = 36,
	["coord"] = 764708591,
	["direct"] = "47927:48321",
	["f"] = 0,
	},
	[43371] = {
	"931:352",
	"931:523",
	"931:2299:2941:1573",
	"931:2299:44410:44409:1572:1571",
	"931:2299:44410:44409:1572",
	"931:2409",
	"931:2299:44410:44409:1572:2835",
	"931:2409:43045:2859",
	"931:2299:44410:44409:1572:2835:8018",
	"43072:43086:43087:8609",
	"931:2299:44410:44409:1572:2835:8018:12596",
	"931:2299:44410:44407:12617",
	"931:2299",
	"931:2299:2941",
	"931:2299:44410:44407:12617:44230:44233",
	"931:2299:44410:44407:12617:44230:28621",
	"931:2299:44410:44407:12617:44230",
	"931:2299:44410:44407:12617:44231:44232",
	"931:2409:43045",
	"931:2299:44410:44407:12617:24851",
	"931:2299:2941:1573:26560",
	"931:2299:44410:44407:12617:29480",
	"931:2299:44410:44409:1572:2835:8018:12596:37888",
	"931:2299:44410:44409:1572:41321:41322:41323",
	"931:2299:44410:44409:1572:41321:41322",
	"931:2299:44410:44409:1572:41321:41322:41325",
	"931:2299:44410:44409:1572:41321",
	"931:2299:44410:44407:41332",
	"931:43000:42983",
	"931:523:42426",
	"931:352:42406",
	"931:43000",
	"931:2409:43045:43042",
	"931:2409:43045:43042:43043",
	"43072:43086:43087",
	"43072:43086",
	"931:43088",
	"43072:43086:43087:8609:43107",
	"931:2299:2941:1573:43290",
	"931:2299:44410:44409:1572:2835:43570",
	"931:2299:2941:1573:43701",
	"931:2299:44410:44409:1572:43702",
	"931:2409:43697",
	"931:2299:44410:44407:12617:44231",
	"931:2299:44410:44409",
	"931:2299:44410",
	"931:2299:44410:44407",
	"931:2299:44410:44409:1572:2835:8018:46006",
	"931:2299:44410:44409:1572:2835:8018:46006:46011",
	"931:2299:44410:44409:1572:47119",
	"931:2299:44410:44409:1572:47119:47147:47118",
	"931:2299:44410:44409:1572:47119:47147",
	"931:2299:44410:44409:1572:47119:47147:47154",
	"931:2299:44410:44409:1572:47119:47155",
	"931:2299:44410:44409:1572:2835:8018:46006:46011:47875",
	"931:2299:2941:47927",
	"931:2299:48321:48318",
	"931:2299:48321",
	--["name"] = "Camp Everstill, Redridge",
	["m"] = 49,
	["f"] = 0,
	["direct"] = "931:43072",
	["coord"] = 2270333779,
	},
	[931] = {
	"2299:2941:1573",
	"2299:44410:44409:1572:1571",
	"2299:44410:44409:1572",
	"2299:44410:44409:1572:2835",
	"2409:43045:2859",
	"2299:44410:44409:1572:2835:8018",
	"43088:43087:8609",
	"2299:44410:44409:1572:2835:8018:12596",
	"2299:44410:44407:12617",
	"2299:2941",
	"2299:44410:44407:12617:44230:44233",
	"2299:44410:44407:12617:44230:28621",
	"2299:44410:44407:12617:44230",
	"2299:44410:44407:12617:44231:44232",
	"2409:43045",
	"2299:44410:44407:12617:24851",
	"2299:2941:1573:26560",
	"2299:44410:44407:12617:29480",
	"2299:44410:44409:1572:2835:8018:12596:37888",
	"2299:44410:44409:1572:41321:41322:41323",
	"2299:44410:44409:1572:41321:41322",
	"2299:44410:44409:1572:41321:41322:41325",
	"2299:44410:44409:1572:41321",
	"2299:44410:44407:41332",
	"43000:42983",
	"523:42426",
	"352:42406",
	"2409:43045:43042",
	"2409:43045:43042:43043",
	"43371:43072",
	"43088:43087",
	"43371:43072:43086",
	"43088:43087:8609:43107",
	"2299:2941:1573:43290",
	"2299:44410:44409:1572:2835:43570",
	"2299:2941:1573:43701",
	"2299:44410:44409:1572:43702",
	"2409:43697",
	"2299:44410:44407:12617:44231",
	"2299:44410:44409",
	"2299:44410",
	"2299:44410:44407",
	"2299:44410:44409:1572:2835:8018:46006",
	"2299:44410:44409:1572:2835:8018:46006:46011",
	"2299:44410:44409:1572:47119",
	"2299:44410:44409:1572:47119:47147:47118",
	"2299:44410:44409:1572:47119:47147",
	"2299:44410:44409:1572:47119:47147:47154",
	"2299:44410:44409:1572:47119:47155",
	"2299:44410:44409:1572:2835:8018:46006:46011:47875",
	"2299:2941:47927",
	"2299:48321:48318",
	"2299:48321",
	--["name"] = "Lakeshire, Redridge",
	["m"] = 49,
	["f"] = 0,
	["direct"] = "352:523:2409:2299:43000:43088:43371",
	["coord"] = 1259768070,
	},
	[26560] = {
	"12617:43570:2835:1572:2941:352",
	"12617:44407:44410:2299:931:523",
	"12617:44407:44410:2299:931",
	"12617:1573",
	"12617:43570:2835:1571",
	"12617:43570:2835:1572",
	"12617:44407:44410:2299:931:2409",
	"12617:43570:2835",
	"12617:44407:44410:2299:931:2409:43045:2859",
	"12617:8018",
	"12617:44407:44410:2299:43086:43087:8609",
	"12617:12596",
	"12617:44407:44410:2299",
	"12617:43570:2835:1572:2941",
	"12617:44230:44233",
	"12617:44230:28621",
	"12617:44230",
	"12617:44231:44232",
	"12617:44407:44410:2299:931:2409:43045",
	"12617:29480",
	"12617:37888",
	"12617:43570:2835:41325:41323",
	"12617:43570:2835:41325:41322",
	"12617:43570:2835:41325",
	"12617:43570:2835:41325:41322:41321",
	"12617:44407:41332",
	"12617:44407:44410:2299:931:43000:42983",
	"12617:44407:44410:2299:931:523:42426",
	"12617:43570:2835:1572:2941:352:42406",
	"12617:44407:44410:2299:931:43000",
	"12617:44407:44410:2299:931:2409:43045:43042",
	"12617:44407:44410:2299:931:2409:43045:43042:43043",
	"12617:44407:44410:2299:43086:43072",
	"12617:44407:44410:2299:43086:43087",
	"12617:44407:44410:2299:43086",
	"12617:44407:44410:2299:931:43088",
	"12617:44407:44410:2299:43086:43087:8609:43107",
	"12617:1573:43290",
	"12617:44407:44410:2299:931:43371",
	"12617:43570",
	"12617:1573:43701",
	"12617:43570:2835:1572:43702",
	"12617:44407:44410:2299:931:2409:43697",
	"12617:44231",
	"12617:44407:44409",
	"12617:44407:44410",
	"12617:44407",
	"12617:37888:46011:46006",
	"12617:37888:46011",
	"12617:43570:2835:1572:47119",
	"12617:43570:2835:1572:47119:47147:47118",
	"12617:43570:2835:1572:47119:47147",
	"12617:43570:2835:1572:47119:47147:47154",
	"12617:43570:2835:1572:47119:47155",
	"12617:44230:44233:47875",
	"12617:43570:2835:1572:2941:47927",
	"12617:44407:44410:2299:48321:48318",
	"12617:44407:44410:2299:48321",
	--["name"] = "Shattered Sun Staging Area",
	["m"] = 122,
	["coord"] = 2073575464,
	["direct"] = "12617:24851",
	["f"] = 0,
	},
	[44231] = {
	"44232:37888:12596:1573:2941:352",
	"12617:44407:44410:2299:931:523",
	"12617:44407:44410:2299:931",
	"44232:37888:12596:1573",
	"12617:43570:2835:1571",
	"12617:43570:2835:1572",
	"12617:44407:44410:2299:931:2409",
	"12617:43570:2835",
	"12617:44407:44410:2299:931:2409:43045:2859",
	"44232:37888:12596:8018",
	"12617:44407:44410:2299:43086:43087:8609",
	"44232:37888:12596",
	"12617:44407:44410:2299",
	"44232:37888:12596:1573:2941",
	"44230:28621",
	"12617:44407:44410:2299:931:2409:43045",
	"12617:24851",
	"12617:26560",
	"12617:29480",
	"44232:37888",
	"12617:43570:2835:41325:41323",
	"12617:43570:2835:41325:41322",
	"12617:43570:2835:41325",
	"12617:43570:2835:41325:41322:41321",
	"12617:44407:41332",
	"44232:37888:12596:1573:2941:352:42983",
	"12617:44407:44410:2299:931:523:42426",
	"44232:37888:12596:1573:2941:352:42406",
	"12617:44407:44410:2299:931:43000",
	"12617:44407:44410:2299:931:2409:43045:43042",
	"12617:44407:44410:2299:931:2409:43045:43042:43043",
	"12617:44407:44410:2299:43086:43072",
	"12617:44407:44410:2299:43086:43087",
	"12617:44407:44410:2299:43086",
	"12617:44407:44410:2299:931:43088",
	"12617:44407:44410:2299:43086:43087:8609:43107",
	"44232:37888:12596:1573:43290",
	"12617:44407:44410:2299:931:43371",
	"12617:43570",
	"44232:37888:12596:1573:43701",
	"44232:37888:12596:1573:43702",
	"12617:44407:44410:2299:931:2409:43697",
	"12617:44407:44409",
	"12617:44407:44410",
	"12617:44407",
	"44232:37888:46011:46006",
	"44232:37888:46011",
	"12617:43570:2835:1572:47119",
	"12617:43570:2835:1572:47119:47147:47118",
	"12617:43570:2835:1572:47119:47147",
	"12617:43570:2835:1572:47119:47147:47154",
	"12617:43570:2835:1572:47119:47155",
	"44233:47875",
	"44232:37888:12596:1573:2941:47927",
	"44232:37888:12596:1573:2941:47927:48318",
	"12617:44407:44410:2299:48321",
	--["name"] = "Light's Shield Tower, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 2262927709,
	["direct"] = "12617:44233:44230:44232",
	["f"] = 0,
	},
	[44233] = {
	"44232:37888:12596:1573:2941:352",
	"44232:37888:12596:1573:2941:352:523",
	"44230:12617:44407:44410:2299:931",
	"44232:37888:12596:1573",
	"44230:12617:43570:2835:1571",
	"44230:12617:43570:2835:1572",
	"44230:12617:44407:44410:2299:931:2409",
	"44230:12617:43570:2835",
	"44232:37888:12596:1573:2941:352:2859",
	"44232:37888:12596:8018",
	"44230:12617:44407:44410:2299:43086:43087:8609",
	"44232:37888:12596",
	"44230:12617",
	"44230:12617:44407:44410:2299",
	"44232:37888:12596:1573:2941",
	"44230:12617:44407:44410:2299:931:2409:43045",
	"44230:12617:24851",
	"44230:12617:26560",
	"44230:12617:29480",
	"44232:37888",
	"44230:12617:43570:2835:41325:41323",
	"44230:12617:43570:2835:41325:41322",
	"44230:12617:43570:2835:41325",
	"44230:12617:43570:2835:41325:41322:41321",
	"44230:12617:44407:41332",
	"44232:37888:12596:1573:2941:352:42983",
	"44232:37888:12596:1573:2941:352:523:42426",
	"44232:37888:12596:1573:2941:352:42406",
	"44230:12617:44407:44410:2299:931:43000",
	"44230:12617:44407:44410:2299:931:2409:43045:43042",
	"44230:12617:44407:44410:2299:931:2409:43045:43042:43043",
	"44230:12617:44407:44410:2299:43086:43072",
	"44230:12617:44407:44410:2299:43086:43087",
	"44230:12617:44407:44410:2299:43086",
	"44230:12617:44407:44410:2299:931:43088",
	"44230:12617:44407:44410:2299:43086:43087:8609:43107",
	"44232:37888:12596:1573:43290",
	"44230:12617:44407:44410:2299:931:43371",
	"44230:12617:43570",
	"44232:37888:12596:1573:43701",
	"44232:37888:12596:1573:43702",
	"44230:12617:44407:44410:2299:931:2409:43697",
	"44230:12617:44407:44409",
	"44230:12617:44407:44410",
	"44230:12617:44407",
	"47875:46011:46006",
	"47875:46011",
	"44230:12617:43570:2835:1572:47119",
	"44230:12617:43570:2835:1572:47119:47147:47118",
	"44230:12617:43570:2835:1572:47119:47147",
	"44230:12617:43570:2835:1572:47119:47147:47154",
	"44230:12617:43570:2835:1572:47119:47155",
	"44232:37888:12596:1573:2941:47927",
	"44232:37888:12596:1573:2941:47927:48318",
	"44230:12617:44407:44410:2299:48321",
	--["name"] = "Plaguewood Tower, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 794052176,
	["direct"] = "28621:44230:44232:44231:47875",
	["f"] = 0,
	},
	[43290] = {
	"1573:2941:352",
	"1573:2941:352:523",
	"1573:2941:2299:931",
	"1573:1571",
	"1573:1572",
	"1573:2941:2299:931:2409",
	"1573:2835",
	"1573:2941:352:2859",
	"1573:8018",
	"1573:2941:2299:43086:43087:8609",
	"1573:12596",
	"1573:12617",
	"1573:2941:2299",
	"1573:2941",
	"1573:12596:46011:47875:44233",
	"1573:12617:44230:28621",
	"1573:12617:44230",
	"1573:12596:37888:44232",
	"1573:2941:352:43045",
	"1573:12617:24851",
	"1573:26560",
	"1573:12617:29480",
	"1573:12596:37888",
	"1573:1571:41323",
	"1573:1572:41321:41322",
	"1573:1571:41323:41325",
	"1573:1572:41321",
	"1573:1572:41332",
	"1573:2941:352:42983",
	"1573:2941:352:523:42426",
	"1573:2941:352:42406",
	"1573:2941:2299:931:43000",
	"1573:2941:352:43045:43042",
	"1573:2941:352:43045:43042:43043",
	"1573:2941:2299:43086:43072",
	"1573:2941:2299:43086:43087",
	"1573:2941:2299:43086",
	"1573:2941:2299:931:43088",
	"1573:2941:2299:43086:43087:8609:43107",
	"1573:2941:2299:931:43371",
	"1573:2835:43570",
	"1573:43701",
	"1573:43702",
	"1573:2941:352:523:43697",
	"1573:12617:44231",
	"1573:1572:44409",
	"1573:1572:44409:44410",
	"1573:1572:44409:44407",
	"1573:12596:46006",
	"1573:12596:46011",
	"1573:1572:47119",
	"1573:1572:47119:47147:47118",
	"1573:1572:47119:47147",
	"1573:1572:47119:47147:47154",
	"1573:1572:47119:47155",
	"1573:12596:46011:47875",
	"1573:2941:47927",
	"1573:2941:47927:48318",
	"1573:2941:47927:48318:48321",
	--["name"] = "Sandy Beach, Vashj'ir",
	["m"] = 205,
	["coord"] = 2450205674,
	["direct"] = "1573",
	["f"] = 0,
	},
	[44230] = {
	"12617:43570:2835:1572:2941:352",
	"12617:44407:44410:2299:931:523",
	"12617:44407:44410:2299:931",
	"44231:44232:37888:12596:1573",
	"12617:43570:2835:1571",
	"12617:43570:2835:1572",
	"12617:44407:44410:2299:931:2409",
	"12617:43570:2835",
	"12617:44407:44410:2299:931:2409:43045:2859",
	"12617:8018",
	"12617:44407:44410:2299:43086:43087:8609",
	"44231:44232:37888:12596",
	"12617:44407:44410:2299",
	"12617:43570:2835:1572:2941",
	"44231:44232",
	"12617:44407:44410:2299:931:2409:43045",
	"12617:24851",
	"12617:26560",
	"12617:29480",
	"44231:44232:37888",
	"12617:43570:2835:41325:41323",
	"12617:43570:2835:41325:41322",
	"12617:43570:2835:41325",
	"12617:43570:2835:41325:41322:41321",
	"12617:44407:41332",
	"12617:44407:44410:2299:931:43000:42983",
	"12617:44407:44410:2299:931:523:42426",
	"12617:43570:2835:1572:2941:352:42406",
	"12617:44407:44410:2299:931:43000",
	"12617:44407:44410:2299:931:2409:43045:43042",
	"12617:44407:44410:2299:931:2409:43045:43042:43043",
	"12617:44407:44410:2299:43086:43072",
	"12617:44407:44410:2299:43086:43087",
	"12617:44407:44410:2299:43086",
	"12617:44407:44410:2299:931:43088",
	"12617:44407:44410:2299:43086:43087:8609:43107",
	"44231:44232:37888:12596:1573:43290",
	"12617:44407:44410:2299:931:43371",
	"12617:43570",
	"44231:44232:37888:12596:1573:43701",
	"12617:43570:2835:1572:43702",
	"12617:44407:44410:2299:931:2409:43697",
	"12617:44407:44409",
	"12617:44407:44410",
	"12617:44407",
	"44231:44232:37888:46011:46006",
	"44231:44232:37888:46011",
	"12617:43570:2835:1572:47119",
	"12617:43570:2835:1572:47119:47147:47118",
	"12617:43570:2835:1572:47119:47147",
	"12617:43570:2835:1572:47119:47147:47154",
	"12617:43570:2835:1572:47119:47155",
	"44233:47875",
	"12617:43570:2835:1572:2941:47927",
	"12617:44407:44410:2299:48321:48318",
	"12617:44407:44410:2299:48321",
	--["name"] = "Eastwall Tower, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 2644471905,
	["direct"] = "12617:44233:28621:44231",
	["f"] = 0,
	},
	[43042] = {
	"43045:352",
	"43045:523",
	"43045:2409:931",
	"43045:352:1573",
	"43045:352:1573:1571",
	"43045:2409:931:2299:44410:44409:1572",
	"43045:2409",
	"43045:2409:931:2299:44410:44409:1572:2835",
	"43043:2859",
	"43045:2409:931:2299:44410:44409:1572:2835:8018",
	"43045:2409:8609",
	"43045:352:1573:12596",
	"43045:2409:931:2299:44410:44407:12617",
	"43045:2409:931:2299",
	"43045:352:2941",
	"43045:2409:931:2299:44410:44407:12617:44230:44233",
	"43045:2409:931:2299:44410:44407:12617:44230:28621",
	"43045:2409:931:2299:44410:44407:12617:44230",
	"43045:352:1573:12596:37888:44232",
	"43045:2409:931:2299:44410:44407:12617:24851",
	"43045:352:1573:26560",
	"43045:2409:931:2299:44410:44407:12617:29480",
	"43045:352:1573:12596:37888",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41323",
	"43045:2409:931:2299:44410:44409:1572:41321:41322",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325",
	"43045:2409:931:2299:44410:44409:1572:41321",
	"43045:2409:931:2299:44410:44407:41332",
	"43045:2409:42983",
	"43045:523:42426",
	"43045:523:42406",
	"43045:2409:931:43000",
	"43045:2409:931:43371:43072",
	"43045:2409:8609:43087",
	"43045:2409:931:43371:43072:43086",
	"43045:2409:931:43088",
	"43043:2859:43107",
	"43045:352:1573:43290",
	"43045:2409:931:43371",
	"43045:2409:931:2299:44410:44409:1572:2835:43570",
	"43045:352:1573:43701",
	"43045:2409:931:2299:44410:44409:1572:43702",
	"43045:43697",
	"43045:2409:931:2299:44410:44407:12617:44231",
	"43045:2409:931:2299:44410:44409",
	"43045:2409:931:2299:44410",
	"43045:2409:931:2299:44410:44407",
	"43045:352:1573:12596:46006",
	"43045:352:1573:12596:46011",
	"43045:2409:931:2299:44410:44409:1572:47119",
	"43045:2409:931:2299:44410:44409:1572:47119:47147:47118",
	"43045:2409:931:2299:44410:44409:1572:47119:47147",
	"43045:2409:931:2299:44410:44409:1572:47119:47147:47154",
	"43045:2409:931:2299:44410:44409:1572:47119:47155",
	"43045:352:1573:12596:46011:47875",
	"43045:352:2941:47927",
	"43045:2409:931:2299:48321:48318",
	"43045:2409:931:2299:48321",
	--["name"] = "Fort Livingston, Stranglethorn",
	["m"] = 50,
	["coord"] = 2260380048,
	["direct"] = "43045:43043",
	["f"] = 0,
	},
	[43107] = {
	"8609:2409:352",
	"8609:2409:523",
	"8609:43087:43088:931",
	"8609:43087:43086:2299:2941:1573",
	"8609:43087:43086:2299:44410:44409:1572:1571",
	"8609:43087:43086:2299:44410:44409:1572",
	"8609:2409",
	"8609:43087:43086:2299:44410:44409:1572:2835",
	"8609:43087:43086:2299:44410:44409:1572:2835:8018",
	"8609:43087:43086:2299:44410:44409:1572:2835:8018:12596",
	"8609:43087:43086:2299:44410:44407:12617",
	"8609:43087:43086:2299",
	"8609:43087:43086:2299:2941",
	"8609:43087:43086:2299:44410:44407:12617:44230:44233",
	"8609:43087:43086:2299:44410:44407:12617:44230:28621",
	"8609:43087:43086:2299:44410:44407:12617:44230",
	"8609:43087:43086:2299:44410:44407:12617:44231:44232",
	"8609:2409:43045",
	"8609:43087:43086:2299:44410:44407:12617:24851",
	"8609:43087:43086:2299:2941:1573:26560",
	"8609:43087:43086:2299:44410:44407:12617:29480",
	"8609:43087:43086:2299:44410:44409:1572:2835:8018:12596:37888",
	"8609:43087:43086:2299:44410:44409:1572:41321:41322:41323",
	"8609:43087:43086:2299:44410:44409:1572:41321:41322",
	"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325",
	"8609:43087:43086:2299:44410:44409:1572:41321",
	"8609:43087:43086:2299:44410:44407:41332",
	"8609:2409:42983",
	"8609:2409:523:42426",
	"8609:2409:523:42406",
	"8609:43087:43088:931:43000",
	"2859:43043:43042",
	"2859:43043",
	"8609:43087:43086:43072",
	"8609:43087",
	"8609:43087:43086",
	"8609:43087:43088",
	"8609:43087:43086:2299:2941:1573:43290",
	"8609:43087:43086:43072:43371",
	"8609:43087:43086:2299:44410:44409:1572:2835:43570",
	"8609:43087:43086:2299:2941:1573:43701",
	"8609:43087:43086:2299:44410:44409:1572:43702",
	"8609:2409:43697",
	"8609:43087:43086:2299:44410:44407:12617:44231",
	"8609:43087:43086:2299:44410:44409",
	"8609:43087:43086:2299:44410",
	"8609:43087:43086:2299:44410:44407",
	"8609:43087:43086:2299:44410:44409:1572:2835:8018:46006",
	"8609:43087:43086:2299:44410:44409:1572:2835:8018:46006:46011",
	"8609:43087:43086:2299:44410:44409:1572:47119",
	"8609:43087:43086:2299:44410:44409:1572:47119:47147:47118",
	"8609:43087:43086:2299:44410:44409:1572:47119:47147",
	"8609:43087:43086:2299:44410:44409:1572:47119:47147:47154",
	"8609:43087:43086:2299:44410:44409:1572:47119:47155",
	"8609:43087:43086:2299:44410:44409:1572:2835:8018:46006:46011:47875",
	"8609:43087:43086:2299:2941:47927",
	"8609:43087:43086:2299:48321:48318",
	"8609:43087:43086:2299:48321",
	--["name"] = "Surwich, Blasted Lands",
	["m"] = 17,
	["f"] = 0,
	["direct"] = "2859:8609",
	["coord"] = 2023220330,
	},
	[42983] = {
	"352:523",
	"43000:931",
	"352:1573",
	"352:1573:1571",
	"352:2941:1572",
	"352:2941:1572:2835",
	"352:2859",
	"352:1573:8018",
	"2409:8609",
	"352:1573:12596",
	"352:2941:1572:2835:43570:12617",
	"43000:931:2299",
	"352:2941",
	"352:1573:12596:46011:47875:44233",
	"352:2941:1572:2835:43570:12617:44230:28621",
	"352:2941:1572:2835:43570:12617:44230",
	"352:1573:12596:37888:44232",
	"2409:43045",
	"352:2941:1572:2835:43570:12617:24851",
	"352:1573:26560",
	"352:2941:1572:2835:43570:12617:29480",
	"352:1573:12596:37888",
	"352:2941:1572:41321:41322:41323",
	"352:2941:1572:41321:41322",
	"352:2941:1572:41321:41322:41325",
	"352:2941:1572:41321",
	"352:2941:1572:41332",
	"352:523:42426",
	"352:42406",
	"2409:43045:43042",
	"2409:43045:43042:43043",
	"43000:931:43371:43072",
	"43000:931:43088:43087",
	"43000:931:43371:43072:43086",
	"43000:931:43088",
	"2409:8609:43107",
	"352:1573:43290",
	"43000:931:43371",
	"352:2941:1572:2835:43570",
	"352:1573:43701",
	"352:1573:43702",
	"352:523:43697",
	"352:2941:1572:2835:43570:12617:44231",
	"43000:931:2299:44410:44409",
	"43000:931:2299:44410",
	"43000:931:2299:44410:44407",
	"352:1573:12596:46006",
	"352:1573:12596:46011",
	"352:2941:1572:47119",
	"352:2941:1572:47119:47147:47118",
	"352:2941:1572:47119:47147",
	"352:2941:1572:47119:47147:47154",
	"352:2941:1572:47119:47155",
	"352:1573:12596:46011:47875",
	"352:2941:47927",
	"43000:931:2299:48321:48318",
	"43000:931:2299:48321",
	--["name"] = "Goldshire, Elwynn",
	["m"] = 37,
	["coord"] = 1792976232,
	["direct"] = "352:2409:43000",
	["f"] = 0,
	},
	[2409] = {
	"931:2299:2941:1573",
	"931:2299:44410:44409:1572:1571",
	"931:2299:44410:44409:1572",
	"931:2299:44410:44409:1572:2835",
	"931:2299:44410:44409:1572:2835:8018",
	"931:2299:44410:44409:1572:2835:8018:12596",
	"931:2299:44410:44407:12617",
	"931:2299",
	"931:2299:2941",
	"931:2299:44410:44407:12617:44230:44233",
	"931:2299:44410:44407:12617:44230:28621",
	"931:2299:44410:44407:12617:44230",
	"931:2299:44410:44407:12617:44231:44232",
	"931:2299:44410:44407:12617:24851",
	"931:2299:2941:1573:26560",
	"931:2299:44410:44407:12617:29480",
	"931:2299:44410:44409:1572:2835:8018:12596:37888",
	"931:2299:44410:44409:1572:41321:41322:41323",
	"931:2299:44410:44409:1572:41321:41322",
	"931:2299:44410:44409:1572:41321:41322:41325",
	"931:2299:44410:44409:1572:41321",
	"931:2299:44410:44407:41332",
	"523:42426",
	"523:42406",
	"931:43000",
	"43045:43042",
	"43045:43042:43043",
	"931:43371:43072",
	"8609:43087",
	"931:43371:43072:43086",
	"931:43088",
	"8609:43107",
	"931:2299:2941:1573:43290",
	"931:43371",
	"931:2299:44410:44409:1572:2835:43570",
	"931:2299:2941:1573:43701",
	"931:2299:44410:44409:1572:43702",
	"931:2299:44410:44407:12617:44231",
	"931:2299:44410:44409",
	"931:2299:44410",
	"931:2299:44410:44407",
	"931:2299:44410:44409:1572:2835:8018:46006",
	"931:2299:44410:44409:1572:2835:8018:46006:46011",
	"931:2299:44410:44409:1572:47119",
	"931:2299:44410:44409:1572:47119:47147:47118",
	"931:2299:44410:44409:1572:47119:47147",
	"931:2299:44410:44409:1572:47119:47147:47154",
	"931:2299:44410:44409:1572:47119:47155",
	"931:2299:44410:44409:1572:2835:8018:46006:46011:47875",
	"931:2299:2941:47927",
	"931:2299:48321:48318",
	"931:2299:48321",
	--["name"] = "Darkshire, Duskwood",
	["m"] = 47,
	["coord"] = 3333124519,
	["direct"] = "352:523:931:2859:8609:43045:42983:43697",
	["f"] = 0,
	},
	[1571] = {
	"1573:2941:352",
	"1573:2941:352:523",
	"1573:2941:2299:931",
	"1573:2941:2299:931:2409",
	"1573:2941:352:2859",
	"2835:8018",
	"1573:2941:2299:43086:43087:8609",
	"2835:8018:12596",
	"2835:43570:12617",
	"1573:2941:2299",
	"1573:2941",
	"2835:43570:12617:44230:44233",
	"2835:43570:12617:44230:28621",
	"2835:43570:12617:44230",
	"2835:8018:12596:37888:44232",
	"1573:2941:352:43045",
	"2835:43570:12617:24851",
	"2835:43570:12617:26560",
	"2835:43570:12617:29480",
	"2835:8018:12596:37888",
	"41323:41322",
	"41323:41325",
	"41323:41322:41321",
	"1572:41332",
	"1573:2941:352:42983",
	"1573:2941:352:523:42426",
	"1573:2941:352:42406",
	"1573:2941:2299:931:43000",
	"1573:2941:352:43045:43042",
	"1573:2941:352:43045:43042:43043",
	"1573:2941:2299:43086:43072",
	"1573:2941:2299:43086:43087",
	"1573:2941:2299:43086",
	"1573:2941:2299:931:43088",
	"1573:2941:2299:43086:43087:8609:43107",
	"1573:43290",
	"1573:2941:2299:931:43371",
	"2835:43570",
	"1573:43701",
	"1573:43702",
	"1573:2941:352:523:43697",
	"2835:43570:12617:44231",
	"1572:44409",
	"1572:44409:44410",
	"1572:44409:44407",
	"2835:8018:46006",
	"2835:8018:46006:46011",
	"1572:47119",
	"1572:47119:47147:47118",
	"1572:47119:47147",
	"1572:47119:47147:47154",
	"1572:47119:47155",
	"2835:8018:46006:46011:47875",
	"1573:2941:47927",
	"1573:2941:47927:48318",
	"1573:2941:47927:48318:48321",
	--["name"] = "Menethil Harbor, Wetlands",
	["m"] = 56,
	["f"] = 0,
	["direct"] = "1573:1572:2835:41323",
	["coord"] = 405575776,
	},
	[2299] = {
	"931:523",
	"2941:1573",
	"44410:44409:1572:1571",
	"44410:44409:1572",
	"931:2409",
	"44410:44409:1572:2835",
	"931:2409:43045:2859",
	"44410:44409:1572:2835:8018",
	"44410:44409:1572:2835:8018:12596",
	"44410:44407:12617",
	"44410:44407:12617:44230:44233",
	"44410:44407:12617:44230:28621",
	"44410:44407:12617:44230",
	"44410:44407:12617:44231:44232",
	"931:2409:43045",
	"44410:44407:12617:24851",
	"2941:1573:26560",
	"44410:44407:12617:29480",
	"44410:44409:1572:2835:8018:12596:37888",
	"44410:44409:1572:41321:41322:41323",
	"44410:44409:1572:41321:41322",
	"44410:44409:1572:41321:41322:41325",
	"44410:44409:1572:41321",
	"44410:44407:41332",
	"931:43000:42983",
	"931:523:42426",
	"352:42406",
	"931:43000",
	"931:2409:43045:43042",
	"931:2409:43045:43042:43043",
	"43086:43072",
	"43086:43087",
	"931:43088",
	"43086:43087:8609:43107",
	"2941:1573:43290",
	"931:43371",
	"44410:44409:1572:2835:43570",
	"2941:1573:43701",
	"44410:44409:1572:43702",
	"931:2409:43697",
	"44410:44407:12617:44231",
	"44410:44409",
	"44410:44407",
	"44410:44409:1572:2835:8018:46006",
	"44410:44409:1572:2835:8018:46006:46011",
	"44410:44409:1572:47119",
	"44410:44409:1572:47119:47147:47118",
	"44410:44409:1572:47119:47147",
	"44410:44409:1572:47119:47147:47154",
	"44410:44409:1572:47119:47155",
	"44410:44409:1572:2835:8018:46006:46011:47875",
	"2941:47927",
	"48321:48318",
	--["name"] = "Morgan's Vigil, Burning Steppes",
	["m"] = 36,
	["f"] = 0,
	["direct"] = "352:931:8609:2941:43086:44410:48321",
	["coord"] = 3098257441,
	},
	[37888] = {
	"12596:1573:2941:352",
	"12596:1573:2941:352:523",
	"12596:1573:2941:2299:931",
	"12596:1573",
	"12596:8018:2835:1571",
	"12596:8018:2835:1572",
	"12596:1573:2941:2299:931:2409",
	"12596:8018:2835",
	"12596:1573:2941:352:2859",
	"12596:8018",
	"12596:1573:2941:2299:43086:43087:8609",
	"12596:1573:2941:2299",
	"12596:1573:2941",
	"44232:44233",
	"44232:28621",
	"44232:44231:44230",
	"12596:1573:2941:352:43045",
	"12617:24851",
	"12617:26560",
	"12617:29480",
	"12596:8018:2835:41325:41323",
	"12596:8018:2835:41325:41322",
	"12596:8018:2835:41325",
	"12596:8018:2835:41325:41322:41321",
	"12596:8018:2835:1572:41332",
	"12596:1573:2941:352:42983",
	"12596:1573:2941:352:523:42426",
	"12596:1573:2941:352:42406",
	"12596:1573:2941:2299:931:43000",
	"12596:1573:2941:352:43045:43042",
	"12596:1573:2941:352:43045:43042:43043",
	"12596:1573:2941:2299:43086:43072",
	"12596:1573:2941:2299:43086:43087",
	"12596:1573:2941:2299:43086",
	"12596:1573:2941:2299:931:43088",
	"12596:1573:2941:2299:43086:43087:8609:43107",
	"12596:1573:43290",
	"12596:1573:2941:2299:931:43371",
	"12596:1573:43701",
	"12596:1573:43702",
	"12596:1573:2941:352:523:43697",
	"44232:44231",
	"12596:8018:2835:1572:44409",
	"12596:8018:2835:1572:44409:44410",
	"12617:44407",
	"46011:46006",
	"12596:8018:2835:1572:47119",
	"12596:8018:2835:1572:47119:47147:47118",
	"12596:8018:2835:1572:47119:47147",
	"12596:8018:2835:1572:47119:47147:47154",
	"12596:8018:2835:1572:47119:47155",
	"46011:47875",
	"12596:1573:2941:47927",
	"12596:1573:2941:47927:48318",
	"12596:1573:2941:47927:48318:48321",
	--["name"] = "Thondroril River, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 433629293,
	["direct"] = "12596:12617:44232:43570:46011",
	["f"] = 0,
	},
	[42426] = {
	"523:352",
	"523:931",
	"523:352:1573",
	"523:352:1573:1571",
	"523:352:2941:1572",
	"523:43697:2409",
	"523:352:2941:1572:2835",
	"523:43045:2859",
	"523:352:1573:8018",
	"523:43697:2409:8609",
	"523:352:1573:12596",
	"523:352:2941:1572:2835:43570:12617",
	"523:931:2299",
	"523:352:2941",
	"523:352:1573:12596:46011:47875:44233",
	"523:352:2941:1572:2835:43570:12617:44230:28621",
	"523:352:2941:1572:2835:43570:12617:44230",
	"523:352:1573:12596:37888:44232",
	"523:43045",
	"523:352:2941:1572:2835:43570:12617:24851",
	"523:352:1573:26560",
	"523:352:2941:1572:2835:43570:12617:29480",
	"523:352:1573:12596:37888",
	"523:352:2941:1572:41321:41322:41323",
	"523:352:2941:1572:41321:41322",
	"523:352:2941:1572:41321:41322:41325",
	"523:352:2941:1572:41321",
	"523:931:2299:44410:44407:41332",
	"523:352:42983",
	"523:42406",
	"523:352:42983:43000",
	"523:43045:43042",
	"523:43045:43042:43043",
	"523:931:43371:43072",
	"523:931:43088:43087",
	"523:931:43371:43072:43086",
	"523:931:43088",
	"523:43697:2409:8609:43107",
	"523:352:1573:43290",
	"523:931:43371",
	"523:352:2941:1572:2835:43570",
	"523:352:1573:43701",
	"523:352:1573:43702",
	"523:43697",
	"523:352:2941:1572:2835:43570:12617:44231",
	"523:931:2299:44410:44409",
	"523:931:2299:44410",
	"523:931:2299:44410:44407",
	"523:352:1573:12596:46006",
	"523:352:1573:12596:46011",
	"523:352:2941:1572:47119",
	"523:352:2941:1572:47119:47147:47118",
	"523:352:2941:1572:47119:47147",
	"523:352:2941:1572:47119:47147:47154",
	"523:352:2941:1572:47119:47155",
	"523:352:1573:12596:46011:47875",
	"523:352:2941:47927",
	"523:931:2299:48321:48318",
	"523:931:2299:48321",
	--["name"] = "Moonbrook, Westfall",
	["m"] = 52,
	["coord"] = 1808507401,
	["direct"] = "523",
	["f"] = 0,
	},
	[41325] = {
	"41322:41321:1572:2941:352",
	"41322:41321:1572:2941:352:523",
	"41322:41321:1572:44409:44410:2299:931",
	"41323:1571:1573",
	"41323:1571",
	"41322:41321:1572",
	"41322:41321:1572:44409:44410:2299:931:2409",
	"41322:41321:1572:2941:352:2859",
	"2835:8018",
	"41322:41321:1572:44409:44410:2299:43086:43087:8609",
	"2835:8018:12596",
	"2835:43570:12617",
	"41322:41321:1572:44409:44410:2299",
	"41322:41321:1572:2941",
	"2835:43570:12617:44230:44233",
	"2835:43570:12617:44230:28621",
	"2835:43570:12617:44230",
	"2835:8018:12596:37888:44232",
	"41322:41321:1572:2941:352:43045",
	"2835:43570:12617:24851",
	"2835:43570:12617:26560",
	"2835:43570:12617:29480",
	"2835:8018:12596:37888",
	"41322:41321",
	"41322:41321:1572:41332",
	"41322:41321:1572:2941:352:42983",
	"41322:41321:1572:2941:352:523:42426",
	"41322:41321:1572:2941:352:42406",
	"41322:41321:1572:44409:44410:2299:931:43000",
	"41322:41321:1572:2941:352:43045:43042",
	"41322:41321:1572:2941:352:43045:43042:43043",
	"41322:41321:1572:44409:44410:2299:43086:43072",
	"41322:41321:1572:44409:44410:2299:43086:43087",
	"41322:41321:1572:44409:44410:2299:43086",
	"41322:41321:1572:44409:44410:2299:931:43088",
	"41322:41321:1572:44409:44410:2299:43086:43087:8609:43107",
	"41323:1571:1573:43290",
	"41322:41321:1572:44409:44410:2299:931:43371",
	"2835:43570",
	"41323:1571:1573:43701",
	"41322:41321:1572:43702",
	"41322:41321:1572:2941:352:523:43697",
	"2835:43570:12617:44231",
	"41322:41321:1572:44409",
	"41322:41321:1572:44409:44410",
	"41322:41321:1572:44409:44407",
	"2835:8018:46006",
	"2835:8018:46006:46011",
	"41322:41321:1572:47119",
	"41322:41321:1572:47119:47147:47118",
	"41322:41321:1572:47119:47147",
	"41322:41321:1572:47119:47147:47154",
	"41322:41321:1572:47119:47155",
	"2835:8018:46006:46011:47875",
	"41322:41321:1572:2941:47927",
	"41322:41321:1572:2941:47927:48318",
	"41322:41321:1572:44409:44410:2299:48321",
	--["name"] = "Dun Modr, Wetlands",
	["m"] = 56,
	["direct"] = "2835:41323:41322",
	["coord"] = 2142515064,
	["f"] = 0,
	},
	[12596] = {
	"1573:2941:352",
	"1573:2941:352:523",
	"1573:2941:2299:931",
	"8018:2835:1571",
	"8018:2835:1572",
	"1573:2941:2299:931:2409",
	"8018:2835",
	"1573:2941:352:2859",
	"1573:2941:2299:43086:43087:8609",
	"1573:2941:2299",
	"1573:2941",
	"46011:47875:44233",
	"37888:44232:28621",
	"37888:44232:44231:44230",
	"37888:44232",
	"1573:2941:352:43045",
	"12617:24851",
	"12617:26560",
	"12617:29480",
	"8018:2835:41325:41323",
	"8018:2835:41325:41322",
	"8018:2835:41325",
	"8018:2835:41325:41322:41321",
	"8018:2835:1572:41332",
	"1573:2941:352:42983",
	"1573:2941:352:523:42426",
	"1573:2941:352:42406",
	"1573:2941:2299:931:43000",
	"1573:2941:352:43045:43042",
	"1573:2941:352:43045:43042:43043",
	"1573:2941:2299:43086:43072",
	"1573:2941:2299:43086:43087",
	"1573:2941:2299:43086",
	"1573:2941:2299:931:43088",
	"1573:2941:2299:43086:43087:8609:43107",
	"1573:43290",
	"1573:2941:2299:931:43371",
	"8018:43570",
	"1573:43701",
	"1573:43702",
	"1573:2941:352:523:43697",
	"37888:44232:44231",
	"8018:2835:1572:44409",
	"8018:2835:1572:44409:44410",
	"8018:2835:1572:44409:44407",
	"8018:2835:1572:47119",
	"8018:2835:1572:47119:47147:47118",
	"8018:2835:1572:47119:47147",
	"8018:2835:1572:47119:47147:47154",
	"8018:2835:1572:47119:47155",
	"46011:47875",
	"1573:2941:47927",
	"1573:2941:47927:48318",
	"1573:2941:47927:48318:48321",
	--["name"] = "Chillwind Camp, Western Plaguelands",
	["m"] = 22,
	["coord"] = 1844042137,
	["direct"] = "1573:8018:12617:37888:46006:46011",
	["f"] = 0,
	},
	[2835] = {
	"1572:2941:352",
	"1572:2941:352:523",
	"1572:44409:44410:2299:931",
	"1572:44409:44410:2299:931:2409",
	"1572:2941:352:2859",
	"1572:44409:44410:2299:43086:43087:8609",
	"8018:12596",
	"43570:12617",
	"1572:44409:44410:2299",
	"1572:2941",
	"43570:12617:44230:44233",
	"43570:12617:44230:28621",
	"43570:12617:44230",
	"8018:12596:37888:44232",
	"1572:2941:352:43045",
	"43570:12617:24851",
	"43570:12617:26560",
	"43570:12617:29480",
	"8018:12596:37888",
	"41325:41323",
	"41325:41322",
	"41325:41322:41321",
	"1572:41332",
	"1572:2941:352:42983",
	"1572:2941:352:523:42426",
	"1572:2941:352:42406",
	"1572:44409:44410:2299:931:43000",
	"1572:2941:352:43045:43042",
	"1572:2941:352:43045:43042:43043",
	"1572:44409:44410:2299:43086:43072",
	"1572:44409:44410:2299:43086:43087",
	"1572:44409:44410:2299:43086",
	"1572:44409:44410:2299:931:43088",
	"1572:44409:44410:2299:43086:43087:8609:43107",
	"1571:1573:43290",
	"1572:44409:44410:2299:931:43371",
	"1571:1573:43701",
	"1572:43702",
	"1572:2941:352:523:43697",
	"43570:12617:44231",
	"1572:44409",
	"1572:44409:44410",
	"1572:44409:44407",
	"8018:46006",
	"8018:46006:46011",
	"1572:47119",
	"1572:47119:47147:47118",
	"1572:47119:47147",
	"1572:47119:47147:47154",
	"1572:47119:47155",
	"8018:46006:46011:47875",
	"1572:2941:47927",
	"1572:2941:47927:48318",
	"1572:44409:44410:2299:48321",
	--["name"] = "Refuge Pointe, Arathi",
	["m"] = 14,
	["coord"] = 1714518352,
	["direct"] = "1573:1571:1572:8018:41325:43570",
	["f"] = 0,
	},
	[47118] = {
	"47147:47119:1572:2941:352",
	"47147:47119:1572:2941:352:523",
	"47147:47119:1572:44409:44410:2299:931",
	"47147:47119:1572:1573",
	"47147:47119:1572:1571",
	"47147:47119:1572",
	"47147:47119:1572:44409:44410:2299:931:2409",
	"47147:47119:1572:2835",
	"47147:47119:1572:2941:352:2859",
	"47147:47119:1572:2835:8018",
	"47147:47119:1572:44409:44410:2299:43086:43087:8609",
	"47147:47119:1572:2835:8018:12596",
	"47147:47119:1572:2835:43570:12617",
	"47147:47119:1572:44409:44410:2299",
	"47147:47119:1572:2941",
	"47147:47119:1572:2835:43570:12617:44230:44233",
	"47147:47119:1572:2835:43570:12617:44230:28621",
	"47147:47119:1572:2835:43570:12617:44230",
	"47147:47119:1572:2835:8018:12596:37888:44232",
	"47147:47119:1572:2941:352:43045",
	"47147:47119:1572:2835:43570:12617:24851",
	"47147:47119:1572:1573:26560",
	"47147:47119:1572:2835:43570:12617:29480",
	"47147:47119:1572:2835:8018:12596:37888",
	"47147:47119:1572:41321:41322:41323",
	"47147:47119:1572:41321:41322",
	"47147:47119:1572:41321:41322:41325",
	"47147:47119:1572:41321",
	"47147:47119:1572:41332",
	"47147:47119:1572:2941:352:42983",
	"47147:47119:1572:2941:352:523:42426",
	"47147:47119:1572:2941:352:42406",
	"47147:47119:1572:44409:44410:2299:931:43000",
	"47147:47119:1572:2941:352:43045:43042",
	"47147:47119:1572:2941:352:43045:43042:43043",
	"47147:47119:1572:44409:44410:2299:43086:43072",
	"47147:47119:1572:44409:44410:2299:43086:43087",
	"47147:47119:1572:44409:44410:2299:43086",
	"47147:47119:1572:44409:44410:2299:931:43088",
	"47147:47119:1572:44409:44410:2299:43086:43087:8609:43107",
	"47147:47119:1572:1573:43290",
	"47147:47119:1572:44409:44410:2299:931:43371",
	"47147:47119:1572:2835:43570",
	"47147:47119:1572:43702:43701",
	"47147:47119:1572:43702",
	"47147:47119:1572:2941:352:523:43697",
	"47147:47119:1572:2835:43570:12617:44231",
	"47147:47119:1572:44409",
	"47147:47119:1572:44409:44410",
	"47147:47119:1572:44409:44407",
	"47147:47119:1572:2835:8018:46006",
	"47147:47119:1572:2835:8018:46006:46011",
	"47147:47119",
	"47154:47155",
	"47147:47119:1572:2835:8018:46006:46011:47875",
	"47147:47119:1572:2941:47927",
	"47147:47119:1572:2941:47927:48318",
	"47147:47119:1572:44409:44410:2299:48321",
	--["name"] = "Victor's Point, Twilight Highlands",
	["m"] = 241,
	["f"] = 0,
	["direct"] = "47147:47154",
	["coord"] = 1883476665,
	},
	[2859] = {
	"43045:2409:931",
	"352:1573",
	"352:1573:1571",
	"43045:2409:931:2299:44410:44409:1572",
	"43045:2409:931:2299:44410:44409:1572:2835",
	"43045:2409:931:2299:44410:44409:1572:2835:8018",
	"43107:8609",
	"352:1573:12596",
	"43045:2409:931:2299:44410:44407:12617",
	"43045:2409:931:2299",
	"352:2941",
	"352:1573:12596:46011:47875:44233",
	"43045:2409:931:2299:44410:44407:12617:44230:28621",
	"43045:2409:931:2299:44410:44407:12617:44230",
	"352:1573:12596:37888:44232",
	"43045:2409:931:2299:44410:44407:12617:24851",
	"352:1573:26560",
	"43045:2409:931:2299:44410:44407:12617:29480",
	"352:1573:12596:37888",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41323",
	"43045:2409:931:2299:44410:44409:1572:41321:41322",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325",
	"43045:2409:931:2299:44410:44409:1572:41321",
	"43045:2409:931:2299:44410:44407:41332",
	"352:42983",
	"523:42426",
	"523:42406",
	"43045:2409:931:43000",
	"43043:43042",
	"43045:2409:931:43371:43072",
	"43107:8609:43087",
	"43107:8609:43087:43086",
	"43045:2409:931:43088",
	"352:1573:43290",
	"43045:2409:931:43371",
	"43045:2409:931:2299:44410:44409:1572:2835:43570",
	"352:1573:43701",
	"352:1573:43702",
	"43045:43697",
	"43045:2409:931:2299:44410:44407:12617:44231",
	"43045:2409:931:2299:44410:44409",
	"43045:2409:931:2299:44410",
	"43045:2409:931:2299:44410:44407",
	"352:1573:12596:46006",
	"352:1573:12596:46011",
	"43045:2409:931:2299:44410:44409:1572:47119",
	"43045:2409:931:2299:44410:44409:1572:47119:47147:47118",
	"43045:2409:931:2299:44410:44409:1572:47119:47147",
	"43045:2409:931:2299:44410:44409:1572:47119:47147:47154",
	"43045:2409:931:2299:44410:44409:1572:47119:47155",
	"352:1573:12596:46011:47875",
	"352:2941:47927",
	"43045:2409:931:2299:48321:48318",
	"43045:2409:931:2299:48321",
	--["name"] = "Booty Bay, Stranglethorn",
	["m"] = 210,
	["f"] = 0,
	["direct"] = "352:523:2409:43045:43043:43107",
	["coord"] = 1789640278,
	},
	[43072] = {
	"43371:931:352",
	"43371:931:523",
	"43371:931",
	"43371:931:2299:2941:1573",
	"43371:931:2299:44410:44409:1572:1571",
	"43371:931:2299:44410:44409:1572",
	"43371:931:2409",
	"43371:931:2299:44410:44409:1572:2835",
	"43371:931:2409:43045:2859",
	"43371:931:2299:44410:44409:1572:2835:8018",
	"43086:43087:8609",
	"43371:931:2299:44410:44409:1572:2835:8018:12596",
	"43371:931:2299:44410:44407:12617",
	"43371:931:2299",
	"43371:931:2299:2941",
	"43371:931:2299:44410:44407:12617:44230:44233",
	"43371:931:2299:44410:44407:12617:44230:28621",
	"43371:931:2299:44410:44407:12617:44230",
	"43371:931:2299:44410:44407:12617:44231:44232",
	"43371:931:2409:43045",
	"43371:931:2299:44410:44407:12617:24851",
	"43371:931:2299:2941:1573:26560",
	"43371:931:2299:44410:44407:12617:29480",
	"43371:931:2299:44410:44409:1572:2835:8018:12596:37888",
	"43371:931:2299:44410:44409:1572:41321:41322:41323",
	"43371:931:2299:44410:44409:1572:41321:41322",
	"43371:931:2299:44410:44409:1572:41321:41322:41325",
	"43371:931:2299:44410:44409:1572:41321",
	"43371:931:2299:44410:44407:41332",
	"43371:931:43000:42983",
	"43371:931:523:42426",
	"43371:931:352:42406",
	"43371:931:43000",
	"43371:931:2409:43045:43042",
	"43371:931:2409:43045:43042:43043",
	"43086:43087",
	"43371:931:43088",
	"43086:43087:8609:43107",
	"43371:931:2299:2941:1573:43290",
	"43371:931:2299:44410:44409:1572:2835:43570",
	"43371:931:2299:2941:1573:43701",
	"43371:931:2299:44410:44409:1572:43702",
	"43371:931:2409:43697",
	"43371:931:2299:44410:44407:12617:44231",
	"43371:931:2299:44410:44409",
	"43371:931:2299:44410",
	"43371:931:2299:44410:44407",
	"43371:931:2299:44410:44409:1572:2835:8018:46006",
	"43371:931:2299:44410:44409:1572:2835:8018:46006:46011",
	"43371:931:2299:44410:44409:1572:47119",
	"43371:931:2299:44410:44409:1572:47119:47147:47118",
	"43371:931:2299:44410:44409:1572:47119:47147",
	"43371:931:2299:44410:44409:1572:47119:47147:47154",
	"43371:931:2299:44410:44409:1572:47119:47155",
	"43371:931:2299:44410:44409:1572:2835:8018:46006:46011:47875",
	"43371:931:2299:2941:47927",
	"43371:931:2299:48321:48318",
	"43371:931:2299:48321",
	--["name"] = "Shalewind Canyon, Redridge",
	["m"] = 49,
	["f"] = 0,
	["direct"] = "43086:43371",
	["coord"] = 3344410749,
	},
	[44409] = {
	"44410:2299:352",
	"44410:2299:931:523",
	"44410:2299:931",
	"1572:1573",
	"1572:1571",
	"44410:2299:931:2409",
	"1572:2835",
	"44410:2299:931:2409:43045:2859",
	"1572:2835:8018",
	"44410:2299:43086:43087:8609",
	"1572:2835:8018:12596",
	"1572:2835:43570:12617",
	"44410:2299",
	"1572:2941",
	"1572:2835:43570:12617:44230:44233",
	"1572:2835:43570:12617:44230:28621",
	"1572:2835:43570:12617:44230",
	"1572:2835:8018:12596:37888:44232",
	"44410:2299:931:2409:43045",
	"1572:2835:43570:12617:24851",
	"1572:1573:26560",
	"1572:2835:43570:12617:29480",
	"1572:2835:8018:12596:37888",
	"1572:41321:41322:41323",
	"1572:41321:41322",
	"1572:41321:41322:41325",
	"1572:41321",
	"44407:41332",
	"44410:2299:931:43000:42983",
	"44410:2299:931:523:42426",
	"44410:2299:352:42406",
	"44410:2299:931:43000",
	"44410:2299:931:2409:43045:43042",
	"44410:2299:931:2409:43045:43042:43043",
	"44410:2299:43086:43072",
	"44410:2299:43086:43087",
	"44410:2299:43086",
	"44410:2299:931:43088",
	"44410:2299:43086:43087:8609:43107",
	"1572:1573:43290",
	"44410:2299:931:43371",
	"1572:2835:43570",
	"1572:43702:43701",
	"1572:43702",
	"44410:2299:931:2409:43697",
	"1572:2835:43570:12617:44231",
	"1572:2835:8018:46006",
	"1572:2835:8018:46006:46011",
	"1572:47119",
	"1572:47119:47147:47118",
	"1572:47119:47147",
	"1572:47119:47147:47154",
	"1572:47119:47155",
	"1572:2835:8018:46006:46011:47875",
	"1572:2941:47927",
	"44410:2299:48321:48318",
	"44410:2299:48321",
	--["name"] = "Dustwind Dig, Badlands",
	["m"] = 15,
	["f"] = 0,
	["direct"] = "1572:44410:44407",
	["coord"] = 2096716950,
	},
	[43702] = {
	"1572:2941:352",
	"1572:2941:352:523",
	"1572:44409:44410:2299:931",
	"1573:1571",
	"1572:44409:44410:2299:931:2409",
	"1572:2835",
	"1572:2941:352:2859",
	"1572:2835:8018",
	"1572:44409:44410:2299:43086:43087:8609",
	"1573:12596",
	"1572:2835:43570:12617",
	"1572:44409:44410:2299",
	"1572:2941",
	"1572:2835:43570:12617:44230:44233",
	"1572:2835:43570:12617:44230:28621",
	"1572:2835:43570:12617:44230",
	"1573:12596:37888:44232",
	"1572:2941:352:43045",
	"1572:2835:43570:12617:24851",
	"1573:26560",
	"1572:2835:43570:12617:29480",
	"1573:12596:37888",
	"1572:41321:41322:41323",
	"1572:41321:41322",
	"1572:41321:41322:41325",
	"1572:41321",
	"1572:41332",
	"1572:2941:352:42983",
	"1572:2941:352:523:42426",
	"1572:2941:352:42406",
	"1572:44409:44410:2299:931:43000",
	"1572:2941:352:43045:43042",
	"1572:2941:352:43045:43042:43043",
	"1572:44409:44410:2299:43086:43072",
	"1572:44409:44410:2299:43086:43087",
	"1572:44409:44410:2299:43086",
	"1572:44409:44410:2299:931:43088",
	"1572:44409:44410:2299:43086:43087:8609:43107",
	"1573:43290",
	"1572:44409:44410:2299:931:43371",
	"1572:2835:43570",
	"1572:2941:352:523:43697",
	"1572:2835:43570:12617:44231",
	"1572:44409",
	"1572:44409:44410",
	"1572:44409:44407",
	"1573:12596:46006",
	"1573:12596:46011",
	"1572:47119",
	"1572:47119:47147:47118",
	"1572:47119:47147",
	"1572:47119:47147:47154",
	"1572:47119:47155",
	"1573:12596:46011:47875",
	"1572:2941:47927",
	"1572:2941:47927:48318",
	"1572:44409:44410:2299:48321",
	--["name"] = "Gol'Bolar Quarry, Dun Morogh",
	["m"] = 27,
	["coord"] = 3258616573,
	["direct"] = "1573:1572:43701",
	["f"] = 0,
	},
	[29480] = {
	"12617:43570:2835:1572:2941:352",
	"12617:44407:44410:2299:931:523",
	"12617:44407:44410:2299:931",
	"12617:1573",
	"12617:43570:2835:1571",
	"12617:43570:2835:1572",
	"12617:44407:44410:2299:931:2409",
	"12617:43570:2835",
	"12617:44407:44410:2299:931:2409:43045:2859",
	"12617:8018",
	"12617:44407:44410:2299:43086:43087:8609",
	"12617:12596",
	"12617:44407:44410:2299",
	"12617:43570:2835:1572:2941",
	"12617:44230:44233",
	"12617:44230:28621",
	"12617:44230",
	"12617:44231:44232",
	"12617:44407:44410:2299:931:2409:43045",
	"12617:24851",
	"12617:26560",
	"12617:37888",
	"12617:43570:2835:41325:41323",
	"12617:43570:2835:41325:41322",
	"12617:43570:2835:41325",
	"12617:43570:2835:41325:41322:41321",
	"12617:44407:41332",
	"12617:44407:44410:2299:931:43000:42983",
	"12617:44407:44410:2299:931:523:42426",
	"12617:43570:2835:1572:2941:352:42406",
	"12617:44407:44410:2299:931:43000",
	"12617:44407:44410:2299:931:2409:43045:43042",
	"12617:44407:44410:2299:931:2409:43045:43042:43043",
	"12617:44407:44410:2299:43086:43072",
	"12617:44407:44410:2299:43086:43087",
	"12617:44407:44410:2299:43086",
	"12617:44407:44410:2299:931:43088",
	"12617:44407:44410:2299:43086:43087:8609:43107",
	"12617:44407:44410:2299:931:43371",
	"12617:43570",
	"12617:1573:43701",
	"12617:43570:2835:1572:43702",
	"12617:44407:44410:2299:931:2409:43697",
	"12617:44231",
	"12617:44407:44409",
	"12617:44407:44410",
	"12617:44407",
	"12617:37888:46011:46006",
	"12617:37888:46011",
	"12617:43570:2835:1572:47119",
	"12617:43570:2835:1572:47119:47147:47118",
	"12617:43570:2835:1572:47119:47147",
	"12617:43570:2835:1572:47119:47147:47154",
	"12617:43570:2835:1572:47119:47155",
	"12617:44230:44233:47875",
	"12617:43570:2835:1572:2941:47927",
	"12617:44407:44410:2299:48321:48318",
	"12617:44407:44410:2299:48321",
	--["name"] = "Acherus: The Ebon Hold",
	["m"] = 23,
	["coord"] = 3600449731,
	["direct"] = "12617",
	["f"] = 0,
	},
	[47927] = {
	"2941:352",
	"2941:352:523",
	"2941:2299:931",
	"2941:1573",
	"2941:1573:1571",
	"2941:1572",
	"2941:2299:931:2409",
	"2941:1572:2835",
	"2941:352:2859",
	"2941:1572:2835:8018",
	"2941:2299:43086:43087:8609",
	"2941:1573:12596",
	"2941:1572:2835:43570:12617",
	"2941:2299",
	"2941:1573:12596:46011:47875:44233",
	"2941:1572:2835:43570:12617:44230:28621",
	"2941:1572:2835:43570:12617:44230",
	"2941:1573:12596:37888:44232",
	"2941:352:43045",
	"2941:1572:2835:43570:12617:24851",
	"2941:1573:26560",
	"2941:1572:2835:43570:12617:29480",
	"2941:1573:12596:37888",
	"2941:1572:41321:41322:41323",
	"2941:1572:41321:41322",
	"2941:1572:41321:41322:41325",
	"2941:1572:41321",
	"2941:1572:41332",
	"2941:352:42983",
	"2941:352:523:42426",
	"2941:352:42406",
	"2941:2299:931:43000",
	"2941:352:43045:43042",
	"2941:352:43045:43042:43043",
	"2941:2299:43086:43072",
	"2941:2299:43086:43087",
	"2941:2299:43086",
	"2941:2299:931:43088",
	"2941:2299:43086:43087:8609:43107",
	"2941:1573:43290",
	"2941:2299:931:43371",
	"2941:1572:2835:43570",
	"2941:1573:43701",
	"2941:1572:43702",
	"2941:352:523:43697",
	"2941:1572:2835:43570:12617:44231",
	"2941:1572:44409",
	"2941:2299:44410",
	"2941:1572:44409:44407",
	"2941:1573:12596:46006",
	"2941:1573:12596:46011",
	"2941:1572:47119",
	"2941:1572:47119:47147:47118",
	"2941:1572:47119:47147",
	"2941:1572:47119:47147:47154",
	"2941:1572:47119:47155",
	"2941:1573:12596:46011:47875",
	"48318:48321",
	--["name"] = "Iron Summit, Searing Gorge",
	["m"] = 32,
	["coord"] = 1758769171,
	["direct"] = "2941:48318",
	["f"] = 0,
	},
	[8018] = {
	"2835:1572:2941:352",
	"2835:1572:2941:352:523",
	"2835:1572:44409:44410:2299:931",
	"2835:1571",
	"2835:1572",
	"2835:1572:44409:44410:2299:931:2409",
	"2835:1572:2941:352:2859",
	"2835:1572:44409:44410:2299:43086:43087:8609",
	"2835:1572:44409:44410:2299",
	"2835:1572:2941",
	"46006:46011:47875:44233",
	"43570:12617:44230:28621",
	"43570:12617:44230",
	"12596:37888:44232",
	"2835:1572:2941:352:43045",
	"43570:12617:24851",
	"43570:12617:26560",
	"43570:12617:29480",
	"12596:37888",
	"2835:41325:41323",
	"2835:41325:41322",
	"2835:41325",
	"2835:41325:41322:41321",
	"2835:1572:41332",
	"2835:1572:2941:352:42983",
	"2835:1572:2941:352:523:42426",
	"2835:1572:2941:352:42406",
	"2835:1572:44409:44410:2299:931:43000",
	"2835:1572:2941:352:43045:43042",
	"2835:1572:2941:352:43045:43042:43043",
	"2835:1572:44409:44410:2299:43086:43072",
	"2835:1572:44409:44410:2299:43086:43087",
	"2835:1572:44409:44410:2299:43086",
	"2835:1572:44409:44410:2299:931:43088",
	"2835:1572:44409:44410:2299:43086:43087:8609:43107",
	"1573:43290",
	"2835:1572:44409:44410:2299:931:43371",
	"1573:43701",
	"2835:1572:43702",
	"2835:1572:2941:352:523:43697",
	"12596:37888:44232:44231",
	"2835:1572:44409",
	"2835:1572:44409:44410",
	"2835:1572:44409:44407",
	"46006:46011",
	"2835:1572:47119",
	"2835:1572:47119:47147:47118",
	"2835:1572:47119:47147",
	"2835:1572:47119:47147:47154",
	"2835:1572:47119:47155",
	"46006:46011:47875",
	"2835:1572:2941:47927",
	"2835:1572:2941:47927:48318",
	"2835:1572:44409:44410:2299:48321",
	--["name"] = "Aerie Peak, The Hinterlands",
	["m"] = 26,
	["coord"] = 477263357,
	["direct"] = "1573:2835:12596:12617:43570:46006",
	["f"] = 0,
	},
	[41322] = {
	"41321:1572:2941:352",
	"41321:1572:2941:352:523",
	"41321:1572:44409:44410:2299:931",
	"41323:1571:1573",
	"41323:1571",
	"41321:1572",
	"41321:1572:44409:44410:2299:931:2409",
	"41325:2835",
	"41321:1572:2941:352:2859",
	"41325:2835:8018",
	"41321:1572:44409:44410:2299:43086:43087:8609",
	"41325:2835:8018:12596",
	"41325:2835:43570:12617",
	"41321:1572:44409:44410:2299",
	"41321:1572:2941",
	"41325:2835:43570:12617:44230:44233",
	"41325:2835:43570:12617:44230:28621",
	"41325:2835:43570:12617:44230",
	"41325:2835:8018:12596:37888:44232",
	"41321:1572:2941:352:43045",
	"41325:2835:43570:12617:24851",
	"41325:2835:43570:12617:26560",
	"41325:2835:43570:12617:29480",
	"41325:2835:8018:12596:37888",
	"41321:1572:41332",
	"41321:1572:2941:352:42983",
	"41321:1572:2941:352:523:42426",
	"41321:1572:2941:352:42406",
	"41321:1572:44409:44410:2299:931:43000",
	"41321:1572:2941:352:43045:43042",
	"41321:1572:2941:352:43045:43042:43043",
	"41321:1572:44409:44410:2299:43086:43072",
	"41321:1572:44409:44410:2299:43086:43087",
	"41321:1572:44409:44410:2299:43086",
	"41321:1572:44409:44410:2299:931:43088",
	"41321:1572:44409:44410:2299:43086:43087:8609:43107",
	"41323:1571:1573:43290",
	"41321:1572:44409:44410:2299:931:43371",
	"41325:2835:43570",
	"41321:1572:43702:43701",
	"41321:1572:43702",
	"41321:1572:2941:352:523:43697",
	"41325:2835:43570:12617:44231",
	"41321:1572:44409",
	"41321:1572:44409:44410",
	"41321:1572:44409:44407",
	"41325:2835:8018:46006",
	"41325:2835:8018:46006:46011",
	"41321:1572:47119",
	"41321:1572:47119:47147:47118",
	"41321:1572:47119:47147",
	"41321:1572:47119:47147:47154",
	"41321:1572:47119:47155",
	"41325:2835:8018:46006:46011:47875",
	"41321:1572:2941:47927",
	"41321:1572:2941:47927:48318",
	"41321:1572:44409:44410:2299:48321",
	--["name"] = "Greenwarden's Grove, Wetlands",
	["m"] = 56,
	["coord"] = 2418961312,
	["direct"] = "41323:41325:41321",
	["f"] = 0,
	},
	[1572] = {
	"2941:352",
	"2941:352:523",
	"44409:44410:2299:931",
	"44409:44410:2299:931:2409",
	"2941:352:2859",
	"2835:8018",
	"44409:44410:2299:43086:43087:8609",
	"2835:8018:12596",
	"2835:43570:12617",
	"44409:44410:2299",
	"2835:43570:12617:44230:44233",
	"2835:43570:12617:44230:28621",
	"2835:43570:12617:44230",
	"2835:8018:12596:37888:44232",
	"2941:352:43045",
	"2835:43570:12617:24851",
	"1573:26560",
	"2835:43570:12617:29480",
	"2835:8018:12596:37888",
	"41321:41322:41323",
	"41321:41322",
	"41321:41322:41325",
	"2941:352:42983",
	"2941:352:523:42426",
	"2941:352:42406",
	"44409:44410:2299:931:43000",
	"2941:352:43045:43042",
	"2941:352:43045:43042:43043",
	"44409:44410:2299:43086:43072",
	"44409:44410:2299:43086:43087",
	"44409:44410:2299:43086",
	"44409:44410:2299:931:43088",
	"44409:44410:2299:43086:43087:8609:43107",
	"1573:43290",
	"44409:44410:2299:931:43371",
	"2835:43570",
	"43702:43701",
	"2941:352:523:43697",
	"2835:43570:12617:44231",
	"44409:44410",
	"44409:44407",
	"2835:8018:46006",
	"2835:8018:46006:46011",
	"47119:47147:47118",
	"47119:47147",
	"47119:47147:47154",
	"47119:47155",
	"2835:8018:46006:46011:47875",
	"2941:47927",
	"2941:47927:48318",
	"44409:44410:2299:48321",
	--["name"] = "Thelsamar, Loch Modan",
	["m"] = 48,
	["f"] = 0,
	["direct"] = "1573:1571:2835:2941:41321:41332:43702:44409:47119",
	["coord"] = 1456439905,
	},
	[44407] = {
	"44410:2299:352",
	"44410:2299:931:523",
	"44410:2299:931",
	"44409:1572:1573",
	"44409:1572:1571",
	"44409:1572",
	"44410:2299:931:2409",
	"44409:1572:2835",
	"44410:2299:931:2409:43045:2859",
	"44409:1572:2835:8018",
	"44410:2299:43086:43087:8609",
	"44409:1572:2835:8018:12596",
	"44410:2299",
	"44409:1572:2941",
	"12617:44230:44233",
	"12617:44230:28621",
	"12617:44230",
	"12617:44231:44232",
	"44410:2299:931:2409:43045",
	"12617:24851",
	"12617:26560",
	"12617:29480",
	"44409:1572:2835:8018:12596:37888",
	"44409:1572:41321:41322:41323",
	"44409:1572:41321:41322",
	"44409:1572:41321:41322:41325",
	"44409:1572:41321",
	"44410:2299:931:43000:42983",
	"44410:2299:931:523:42426",
	"44410:2299:352:42406",
	"44410:2299:931:43000",
	"44410:2299:931:2409:43045:43042",
	"44410:2299:931:2409:43045:43042:43043",
	"44410:2299:43086:43072",
	"44410:2299:43086:43087",
	"44410:2299:43086",
	"44410:2299:931:43088",
	"44410:2299:43086:43087:8609:43107",
	"44409:1572:1573:43290",
	"44410:2299:931:43371",
	"44409:1572:2835:43570",
	"44409:1572:43702:43701",
	"44409:1572:43702",
	"44410:2299:931:2409:43697",
	"12617:44231",
	"44409:1572:2835:8018:46006",
	"44409:1572:2835:8018:46006:46011",
	"44409:1572:47119",
	"44409:1572:47119:47147:47118",
	"44409:1572:47119:47147",
	"44409:1572:47119:47147:47154",
	"44409:1572:47119:47155",
	"44409:1572:2835:8018:46006:46011:47875",
	"44409:1572:2941:47927",
	"44410:2299:48321:48318",
	"44410:2299:48321",
	--["name"] = "Fuselight, Badlands",
	["m"] = 15,
	["f"] = 0,
	["direct"] = "12617:41332:44409:44410",
	["coord"] = 2759547439,
	},
	[43086] = {
	"43072:43371:931:352",
	"43072:43371:931:523",
	"43072:43371:931",
	"2299:2941:1573",
	"2299:44410:44409:1572:1571",
	"2299:44410:44409:1572",
	"43072:43371:931:2409",
	"2299:44410:44409:1572:2835",
	"43087:8609:43107:2859",
	"2299:44410:44409:1572:2835:8018",
	"43087:8609",
	"2299:44410:44409:1572:2835:8018:12596",
	"2299:44410:44407:12617",
	"2299:2941",
	"2299:44410:44407:12617:44230:44233",
	"2299:44410:44407:12617:44230:28621",
	"2299:44410:44407:12617:44230",
	"2299:44410:44407:12617:44231:44232",
	"43072:43371:931:2409:43045",
	"2299:44410:44407:12617:24851",
	"2299:2941:1573:26560",
	"2299:44410:44407:12617:29480",
	"2299:44410:44409:1572:2835:8018:12596:37888",
	"2299:44410:44409:1572:41321:41322:41323",
	"2299:44410:44409:1572:41321:41322",
	"2299:44410:44409:1572:41321:41322:41325",
	"2299:44410:44409:1572:41321",
	"2299:44410:44407:41332",
	"43072:43371:931:43000:42983",
	"43072:43371:931:523:42426",
	"43072:43371:931:352:42406",
	"43072:43371:931:43000",
	"43072:43371:931:2409:43045:43042",
	"43072:43371:931:2409:43045:43042:43043",
	"43087:43088",
	"43087:8609:43107",
	"2299:2941:1573:43290",
	"43072:43371",
	"2299:44410:44409:1572:2835:43570",
	"2299:2941:1573:43701",
	"2299:44410:44409:1572:43702",
	"43072:43371:931:2409:43697",
	"2299:44410:44407:12617:44231",
	"2299:44410:44409",
	"2299:44410",
	"2299:44410:44407",
	"2299:44410:44409:1572:2835:8018:46006",
	"2299:44410:44409:1572:2835:8018:46006:46011",
	"2299:44410:44409:1572:47119",
	"2299:44410:44409:1572:47119:47147:47118",
	"2299:44410:44409:1572:47119:47147",
	"2299:44410:44409:1572:47119:47147:47154",
	"2299:44410:44409:1572:47119:47155",
	"2299:44410:44409:1572:2835:8018:46006:46011:47875",
	"2299:2941:47927",
	"2299:48321:48318",
	"2299:48321",
	["direct"] = "2299:43072:43087",
	["m"] = 51,
	["coord"] = 3097042676,
	["f"] = 0,
	},
	[43088] = {
	"931:352",
	"931:523",
	"931:2299:2941:1573",
	"931:2299:44410:44409:1572:1571",
	"931:2299:44410:44409:1572",
	"931:2409",
	"931:2299:44410:44409:1572:2835",
	"931:2409:43045:2859",
	"931:2299:44410:44409:1572:2835:8018",
	"43087:8609",
	"931:2299:44410:44409:1572:2835:8018:12596",
	"931:2299:44410:44407:12617",
	"931:2299",
	"931:2299:2941",
	"931:2299:44410:44407:12617:44230:44233",
	"931:2299:44410:44407:12617:44230:28621",
	"931:2299:44410:44407:12617:44230",
	"931:2299:44410:44407:12617:44231:44232",
	"931:2409:43045",
	"931:2299:44410:44407:12617:24851",
	"931:2299:2941:1573:26560",
	"931:2299:44410:44407:12617:29480",
	"931:2299:44410:44409:1572:2835:8018:12596:37888",
	"931:2299:44410:44409:1572:41321:41322:41323",
	"931:2299:44410:44409:1572:41321:41322",
	"931:2299:44410:44409:1572:41321:41322:41325",
	"931:2299:44410:44409:1572:41321",
	"931:2299:44410:44407:41332",
	"931:43000:42983",
	"931:523:42426",
	"931:352:42406",
	"931:43000",
	"931:2409:43045:43042",
	"931:2409:43045:43042:43043",
	"931:43371:43072",
	"43087:43086",
	"43087:8609:43107",
	"931:2299:2941:1573:43290",
	"931:43371",
	"931:2299:44410:44409:1572:2835:43570",
	"931:2299:2941:1573:43701",
	"931:2299:44410:44409:1572:43702",
	"931:2409:43697",
	"931:2299:44410:44407:12617:44231",
	"931:2299:44410:44409",
	"931:2299:44410",
	"931:2299:44410:44407",
	"931:2299:44410:44409:1572:2835:8018:46006",
	"931:2299:44410:44409:1572:2835:8018:46006:46011",
	"931:2299:44410:44409:1572:47119",
	"931:2299:44410:44409:1572:47119:47147:47118",
	"931:2299:44410:44409:1572:47119:47147",
	"931:2299:44410:44409:1572:47119:47147:47154",
	"931:2299:44410:44409:1572:47119:47155",
	"931:2299:44410:44409:1572:2835:8018:46006:46011:47875",
	"931:2299:2941:47927",
	"931:2299:48321:48318",
	"931:2299:48321",
	--["name"] = "The Harborage, Swamp of Sorrows",
	["m"] = 51,
	["f"] = 0,
	["direct"] = "931:43087",
	["coord"] = 1320573246,
	},
	[43570] = {
	"2835:1572:2941:352",
	"2835:1572:2941:352:523",
	"2835:1572:44409:44410:2299:931",
	"2835:1571:1573",
	"2835:1571",
	"2835:1572",
	"2835:1572:44409:44410:2299:931:2409",
	"2835:1572:2941:352:2859",
	"2835:1572:44409:44410:2299:43086:43087:8609",
	"8018:12596",
	"2835:1572:44409:44410:2299",
	"2835:1572:2941",
	"12617:44230:44233",
	"12617:44230:28621",
	"12617:44230",
	"12617:44231:44232",
	"2835:1572:2941:352:43045",
	"12617:24851",
	"12617:26560",
	"12617:29480",
	"2835:41325:41323",
	"2835:41325:41322",
	"2835:41325",
	"2835:41325:41322:41321",
	"2835:1572:41332",
	"2835:1572:2941:352:42983",
	"2835:1572:2941:352:523:42426",
	"2835:1572:2941:352:42406",
	"2835:1572:44409:44410:2299:931:43000",
	"2835:1572:2941:352:43045:43042",
	"2835:1572:2941:352:43045:43042:43043",
	"2835:1572:44409:44410:2299:43086:43072",
	"2835:1572:44409:44410:2299:43086:43087",
	"2835:1572:44409:44410:2299:43086",
	"2835:1572:44409:44410:2299:931:43088",
	"2835:1572:44409:44410:2299:43086:43087:8609:43107",
	"2835:1571:1573:43290",
	"2835:1572:44409:44410:2299:931:43371",
	"2835:1571:1573:43701",
	"2835:1572:43702",
	"2835:1572:2941:352:523:43697",
	"12617:44231",
	"2835:1572:44409",
	"2835:1572:44409:44410",
	"2835:1572:44409:44407",
	"8018:46006",
	"37888:46011",
	"2835:1572:47119",
	"2835:1572:47119:47147:47118",
	"2835:1572:47119:47147",
	"2835:1572:47119:47147:47154",
	"2835:1572:47119:47155",
	"37888:46011:47875",
	"2835:1572:2941:47927",
	"2835:1572:2941:47927:48318",
	"2835:1572:44409:44410:2299:48321",
	--["name"] = "Stormfeather Outpost, The Hinterlands",
	["m"] = 26,
	["coord"] = 2822861603,
	["direct"] = "2835:8018:12617:37888",
	["f"] = 0,
	},
	[48321] = {
	"2299:352",
	"2299:931:523",
	"2299:931",
	"48318:47927:2941:1573",
	"48318:47927:2941:1573:1571",
	"2299:44410:44409:1572",
	"2299:931:2409",
	"2299:44410:44409:1572:2835",
	"2299:931:2409:43045:2859",
	"2299:44410:44409:1572:2835:8018",
	"2299:43086:43087:8609",
	"48318:47927:2941:1573:12596",
	"2299:44410:44407:12617",
	"48318:47927:2941",
	"2299:44410:44407:12617:44230:44233",
	"2299:44410:44407:12617:44230:28621",
	"2299:44410:44407:12617:44230",
	"48318:47927:2941:1573:12596:37888:44232",
	"2299:931:2409:43045",
	"2299:44410:44407:12617:24851",
	"48318:47927:2941:1573:26560",
	"2299:44410:44407:12617:29480",
	"48318:47927:2941:1573:12596:37888",
	"2299:44410:44409:1572:41321:41322:41323",
	"2299:44410:44409:1572:41321:41322",
	"2299:44410:44409:1572:41321:41322:41325",
	"2299:44410:44409:1572:41321",
	"2299:44410:44407:41332",
	"2299:931:43000:42983",
	"2299:931:523:42426",
	"2299:352:42406",
	"2299:931:43000",
	"2299:931:2409:43045:43042",
	"2299:931:2409:43045:43042:43043",
	"2299:43086:43072",
	"2299:43086:43087",
	"2299:43086",
	"2299:931:43088",
	"2299:43086:43087:8609:43107",
	"48318:47927:2941:1573:43290",
	"2299:931:43371",
	"2299:44410:44409:1572:2835:43570",
	"48318:47927:2941:1573:43701",
	"2299:44410:44409:1572:43702",
	"2299:931:2409:43697",
	"2299:44410:44407:12617:44231",
	"2299:44410:44409",
	"2299:44410",
	"2299:44410:44407",
	"48318:47927:2941:1573:12596:46006",
	"48318:47927:2941:1573:12596:46011",
	"2299:44410:44409:1572:47119",
	"2299:44410:44409:1572:47119:47147:47118",
	"2299:44410:44409:1572:47119:47147",
	"2299:44410:44409:1572:47119:47147:47154",
	"2299:44410:44409:1572:47119:47155",
	"48318:47927:2941:1573:12596:46011:47875",
	"48318:47927",
	--["name"] = "Chiselgrip, Burning Steppes",
	["m"] = 36,
	["coord"] = 1986095967,
	["direct"] = "2299:48318",
	["f"] = 0,
	},
	[47155] = {
	"47119:1572:2941:352",
	"47119:1572:2941:352:523",
	"47119:1572:44409:44410:2299:931",
	"47119:1572:1573",
	"47119:1572:1571",
	"47119:1572",
	"47119:1572:44409:44410:2299:931:2409",
	"47119:1572:2835",
	"47119:1572:2941:352:2859",
	"47119:1572:2835:8018",
	"47119:1572:44409:44410:2299:43086:43087:8609",
	"47119:1572:2835:8018:12596",
	"47119:1572:2835:43570:12617",
	"47119:1572:44409:44410:2299",
	"47119:1572:2941",
	"47119:1572:2835:43570:12617:44230:44233",
	"47119:1572:2835:43570:12617:44230:28621",
	"47119:1572:2835:43570:12617:44230",
	"47119:1572:2835:8018:12596:37888:44232",
	"47119:1572:2941:352:43045",
	"47119:1572:2835:43570:12617:24851",
	"47119:1572:1573:26560",
	"47119:1572:2835:43570:12617:29480",
	"47119:1572:2835:8018:12596:37888",
	"47119:1572:41321:41322:41323",
	"47119:1572:41321:41322",
	"47119:1572:41321:41322:41325",
	"47119:1572:41321",
	"47119:1572:41332",
	"47119:1572:2941:352:42983",
	"47119:1572:2941:352:523:42426",
	"47119:1572:2941:352:42406",
	"47119:1572:44409:44410:2299:931:43000",
	"47119:1572:2941:352:43045:43042",
	"47119:1572:2941:352:43045:43042:43043",
	"47119:1572:44409:44410:2299:43086:43072",
	"47119:1572:44409:44410:2299:43086:43087",
	"47119:1572:44409:44410:2299:43086",
	"47119:1572:44409:44410:2299:931:43088",
	"47119:1572:44409:44410:2299:43086:43087:8609:43107",
	"47119:1572:1573:43290",
	"47119:1572:44409:44410:2299:931:43371",
	"47119:1572:2835:43570",
	"47119:1572:43702:43701",
	"47119:1572:43702",
	"47119:1572:2941:352:523:43697",
	"47119:1572:2835:43570:12617:44231",
	"47119:1572:44409",
	"47119:1572:44409:44410",
	"47119:1572:44409:44407",
	"47119:1572:2835:8018:46006",
	"47119:1572:2835:8018:46006:46011",
	"47154:47118",
	"47119:1572:2835:8018:46006:46011:47875",
	"47119:1572:2941:47927",
	"47119:1572:2941:47927:48318",
	"47119:1572:44409:44410:2299:48321",
	--["name"] = "Kirthaven, Twilight Highlands",
	["m"] = 241,
	["f"] = 0,
	["direct"] = "47119:47147:47154",
	["coord"] = 2436376277,
	},
	[41332] = {
	"1572:2941:352",
	"1572:2941:352:523",
	"44407:44410:2299:931",
	"1572:1573",
	"1572:1571",
	"44407:44410:2299:931:2409",
	"1572:2835",
	"44407:44410:2299:931:2409:43045:2859",
	"1572:2835:8018",
	"44407:44410:2299:43086:43087:8609",
	"1572:2835:8018:12596",
	"1572:2835:43570:12617",
	"44407:44410:2299",
	"1572:2941",
	"1572:2835:43570:12617:44230:44233",
	"1572:2835:43570:12617:44230:28621",
	"1572:2835:43570:12617:44230",
	"1572:2835:8018:12596:37888:44232",
	"44407:44410:2299:931:2409:43045",
	"1572:2835:43570:12617:24851",
	"1572:1573:26560",
	"1572:2835:43570:12617:29480",
	"1572:2835:8018:12596:37888",
	"1572:41321:41322:41323",
	"1572:41321:41322",
	"1572:41321:41322:41325",
	"1572:41321",
	"1572:2941:352:42983",
	"1572:2941:352:523:42426",
	"1572:2941:352:42406",
	"44407:44410:2299:931:43000",
	"44407:44410:2299:931:2409:43045:43042",
	"44407:44410:2299:931:2409:43045:43042:43043",
	"44407:44410:2299:43086:43072",
	"44407:44410:2299:43086:43087",
	"44407:44410:2299:43086",
	"44407:44410:2299:931:43088",
	"44407:44410:2299:43086:43087:8609:43107",
	"1572:1573:43290",
	"44407:44410:2299:931:43371",
	"1572:2835:43570",
	"1572:43702:43701",
	"1572:43702",
	"44407:44410:2299:931:2409:43697",
	"1572:2835:43570:12617:44231",
	"44407:44409",
	"44407:44410",
	"1572:2835:8018:46006",
	"1572:2835:8018:46006:46011",
	"1572:47119",
	"1572:47119:47147:47118",
	"1572:47119:47147",
	"1572:47119:47147:47154",
	"1572:47119:47155",
	"1572:2835:8018:46006:46011:47875",
	"1572:2941:47927",
	"1572:2941:47927:48318",
	"44407:44410:2299:48321",
	--["name"] = "Farstrider Lodge, Loch Modan",
	["m"] = 48,
	["f"] = 0,
	["direct"] = "1572:44407",
	["coord"] = 3518473298,
	},
	[44232] = {
	"37888:12596:1573:2941:352",
	"37888:12596:1573:2941:352:523",
	"44231:12617:44407:44410:2299:931",
	"37888:12596:1573",
	"37888:12596:8018:2835:1571",
	"37888:12596:8018:2835:1572",
	"44231:12617:44407:44410:2299:931:2409",
	"37888:12596:8018:2835",
	"37888:12596:1573:2941:352:2859",
	"37888:12596:8018",
	"44231:12617:44407:44410:2299:43086:43087:8609",
	"37888:12596",
	"44231:12617",
	"44231:12617:44407:44410:2299",
	"37888:12596:1573:2941",
	"44231:44230",
	"37888:12596:1573:2941:352:43045",
	"44231:12617:24851",
	"44231:12617:26560",
	"44231:12617:29480",
	"37888:12596:8018:2835:41325:41323",
	"37888:12596:8018:2835:41325:41322",
	"37888:12596:8018:2835:41325",
	"37888:12596:8018:2835:41325:41322:41321",
	"44231:12617:44407:41332",
	"37888:12596:1573:2941:352:42983",
	"37888:12596:1573:2941:352:523:42426",
	"37888:12596:1573:2941:352:42406",
	"44231:12617:44407:44410:2299:931:43000",
	"37888:12596:1573:2941:352:43045:43042",
	"37888:12596:1573:2941:352:43045:43042:43043",
	"44231:12617:44407:44410:2299:43086:43072",
	"44231:12617:44407:44410:2299:43086:43087",
	"44231:12617:44407:44410:2299:43086",
	"44231:12617:44407:44410:2299:931:43088",
	"44231:12617:44407:44410:2299:43086:43087:8609:43107",
	"37888:12596:1573:43290",
	"44231:12617:44407:44410:2299:931:43371",
	"37888:43570",
	"37888:12596:1573:43701",
	"37888:12596:1573:43702",
	"37888:12596:1573:2941:352:523:43697",
	"44231:12617:44407:44409",
	"44231:12617:44407:44410",
	"44231:12617:44407",
	"37888:46011:46006",
	"37888:46011",
	"37888:12596:8018:2835:1572:47119",
	"37888:12596:8018:2835:1572:47119:47147:47118",
	"37888:12596:8018:2835:1572:47119:47147",
	"37888:12596:8018:2835:1572:47119:47147:47154",
	"37888:12596:8018:2835:1572:47119:47155",
	"44233:47875",
	"37888:12596:1573:2941:47927",
	"37888:12596:1573:2941:47927:48318",
	"37888:12596:1573:2941:47927:48318:48321",
	--["name"] = "Crown Guard Tower, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 1497804314,
	["direct"] = "44233:28621:37888:44231",
	["f"] = 0,
	},
	[44410] = {
	"2299:352",
	"2299:931:523",
	"2299:931",
	"44409:1572:1573",
	"44409:1572:1571",
	"44409:1572",
	"2299:931:2409",
	"44409:1572:2835",
	"2299:931:2409:43045:2859",
	"44409:1572:2835:8018",
	"2299:43086:43087:8609",
	"44409:1572:2835:8018:12596",
	"44407:12617",
	"2299:2941",
	"44407:12617:44230:44233",
	"44407:12617:44230:28621",
	"44407:12617:44230",
	"44407:12617:44231:44232",
	"2299:931:2409:43045",
	"44407:12617:24851",
	"44407:12617:26560",
	"44407:12617:29480",
	"44409:1572:2835:8018:12596:37888",
	"44409:1572:41321:41322:41323",
	"44409:1572:41321:41322",
	"44409:1572:41321:41322:41325",
	"44409:1572:41321",
	"44407:41332",
	"2299:931:43000:42983",
	"2299:931:523:42426",
	"2299:352:42406",
	"2299:931:43000",
	"2299:931:2409:43045:43042",
	"2299:931:2409:43045:43042:43043",
	"2299:43086:43072",
	"2299:43086:43087",
	"2299:43086",
	"2299:931:43088",
	"2299:43086:43087:8609:43107",
	"44409:1572:1573:43290",
	"2299:931:43371",
	"44409:1572:2835:43570",
	"44409:1572:43702:43701",
	"44409:1572:43702",
	"2299:931:2409:43697",
	"44407:12617:44231",
	"44409:1572:2835:8018:46006",
	"44409:1572:2835:8018:46006:46011",
	"44409:1572:47119",
	"44409:1572:47119:47147:47118",
	"44409:1572:47119:47147",
	"44409:1572:47119:47147:47154",
	"44409:1572:47119:47155",
	"44409:1572:2835:8018:46006:46011:47875",
	"2299:2941:47927",
	"2299:48321:48318",
	"2299:48321",
	--["name"] = "Dragon's Mouth, Badlands",
	["m"] = 15,
	["f"] = 0,
	["direct"] = "2299:44409:44407",
	["coord"] = 935302066,
	},
	[41323] = {
	"41322:41321:1572:2941:352",
	"41322:41321:1572:2941:352:523",
	"41322:41321:1572:44409:44410:2299:931",
	"1571:1573",
	"41322:41321:1572",
	"41322:41321:1572:44409:44410:2299:931:2409",
	"41325:2835",
	"41322:41321:1572:2941:352:2859",
	"41325:2835:8018",
	"41322:41321:1572:44409:44410:2299:43086:43087:8609",
	"41325:2835:8018:12596",
	"41325:2835:43570:12617",
	"41322:41321:1572:44409:44410:2299",
	"41322:41321:1572:2941",
	"41325:2835:43570:12617:44230:44233",
	"41325:2835:43570:12617:44230:28621",
	"41325:2835:43570:12617:44230",
	"41325:2835:8018:12596:37888:44232",
	"41322:41321:1572:2941:352:43045",
	"41325:2835:43570:12617:24851",
	"41325:2835:43570:12617:26560",
	"41325:2835:43570:12617:29480",
	"41325:2835:8018:12596:37888",
	"41322:41321",
	"41322:41321:1572:41332",
	"41322:41321:1572:2941:352:42983",
	"41322:41321:1572:2941:352:523:42426",
	"41322:41321:1572:2941:352:42406",
	"41322:41321:1572:44409:44410:2299:931:43000",
	"41322:41321:1572:2941:352:43045:43042",
	"41322:41321:1572:2941:352:43045:43042:43043",
	"41322:41321:1572:44409:44410:2299:43086:43072",
	"41322:41321:1572:44409:44410:2299:43086:43087",
	"41322:41321:1572:44409:44410:2299:43086",
	"41322:41321:1572:44409:44410:2299:931:43088",
	"41322:41321:1572:44409:44410:2299:43086:43087:8609:43107",
	"1571:1573:43290",
	"41322:41321:1572:44409:44410:2299:931:43371",
	"41325:2835:43570",
	"1571:1573:43701",
	"41322:41321:1572:43702",
	"41322:41321:1572:2941:352:523:43697",
	"41325:2835:43570:12617:44231",
	"41322:41321:1572:44409",
	"41322:41321:1572:44409:44410",
	"41322:41321:1572:44409:44407",
	"41325:2835:8018:46006",
	"41325:2835:8018:46006:46011",
	"41322:41321:1572:47119",
	"41322:41321:1572:47119:47147:47118",
	"41322:41321:1572:47119:47147",
	"41322:41321:1572:47119:47147:47154",
	"41322:41321:1572:47119:47155",
	"41325:2835:8018:46006:46011:47875",
	"41322:41321:1572:2941:47927",
	"41322:41321:1572:2941:47927:48318",
	"41322:41321:1572:44409:44410:2299:48321",
	--["name"] = "Whelgar's Retreat, Wetlands",
	["m"] = 56,
	["coord"] = 1661625304,
	["direct"] = "1571:41322:41325",
	["f"] = 0,
	},
	[43087] = {
	"43088:931:352",
	"43088:931:523",
	"43088:931",
	"43086:2299:2941:1573",
	"43086:2299:44410:44409:1572:1571",
	"43086:2299:44410:44409:1572",
	"8609:2409",
	"43086:2299:44410:44409:1572:2835",
	"8609:43107:2859",
	"43086:2299:44410:44409:1572:2835:8018",
	"43086:2299:44410:44409:1572:2835:8018:12596",
	"43086:2299:44410:44407:12617",
	"43086:2299",
	"43086:2299:2941",
	"43086:2299:44410:44407:12617:44230:44233",
	"43086:2299:44410:44407:12617:44230:28621",
	"43086:2299:44410:44407:12617:44230",
	"43086:2299:44410:44407:12617:44231:44232",
	"8609:2409:43045",
	"43086:2299:44410:44407:12617:24851",
	"43086:2299:2941:1573:26560",
	"43086:2299:44410:44407:12617:29480",
	"43086:2299:44410:44409:1572:2835:8018:12596:37888",
	"43086:2299:44410:44409:1572:41321:41322:41323",
	"43086:2299:44410:44409:1572:41321:41322",
	"43086:2299:44410:44409:1572:41321:41322:41325",
	"43086:2299:44410:44409:1572:41321",
	"43086:2299:44410:44407:41332",
	"43088:931:43000:42983",
	"43088:931:523:42426",
	"43088:931:352:42406",
	"43088:931:43000",
	"8609:2409:43045:43042",
	"8609:2409:43045:43042:43043",
	"43086:43072",
	"8609:43107",
	"43086:2299:2941:1573:43290",
	"43086:43072:43371",
	"43086:2299:44410:44409:1572:2835:43570",
	"43086:2299:2941:1573:43701",
	"43086:2299:44410:44409:1572:43702",
	"8609:2409:43697",
	"43086:2299:44410:44407:12617:44231",
	"43086:2299:44410:44409",
	"43086:2299:44410",
	"43086:2299:44410:44407",
	"43086:2299:44410:44409:1572:2835:8018:46006",
	"43086:2299:44410:44409:1572:2835:8018:46006:46011",
	"43086:2299:44410:44409:1572:47119",
	"43086:2299:44410:44409:1572:47119:47147:47118",
	"43086:2299:44410:44409:1572:47119:47147",
	"43086:2299:44410:44409:1572:47119:47147:47154",
	"43086:2299:44410:44409:1572:47119:47155",
	"43086:2299:44410:44409:1572:2835:8018:46006:46011:47875",
	"43086:2299:2941:47927",
	"43086:2299:48321:48318",
	"43086:2299:48321",
	--["name"] = "Marshtide Watch, Swamp of Sorrows",
	["m"] = 51,
	["f"] = 0,
	["direct"] = "8609:43086:43088",
	["coord"] = 3006816802,
	},
	[43043] = {
	"43042:43045:352",
	"43042:43045:523",
	"43042:43045:2409:931",
	"43042:43045:352:1573",
	"43042:43045:352:1573:1571",
	"43042:43045:2409:931:2299:44410:44409:1572",
	"43042:43045:2409",
	"43042:43045:2409:931:2299:44410:44409:1572:2835",
	"43042:43045:2409:931:2299:44410:44409:1572:2835:8018",
	"43042:43045:2409:8609",
	"43042:43045:352:1573:12596",
	"43042:43045:2409:931:2299:44410:44407:12617",
	"43042:43045:2409:931:2299",
	"43042:43045:352:2941",
	"43042:43045:2409:931:2299:44410:44407:12617:44230:44233",
	"43042:43045:2409:931:2299:44410:44407:12617:44230:28621",
	"43042:43045:2409:931:2299:44410:44407:12617:44230",
	"43042:43045:352:1573:12596:37888:44232",
	"43042:43045",
	"43042:43045:2409:931:2299:44410:44407:12617:24851",
	"43042:43045:352:1573:26560",
	"43042:43045:2409:931:2299:44410:44407:12617:29480",
	"43042:43045:352:1573:12596:37888",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41323",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325",
	"43042:43045:2409:931:2299:44410:44409:1572:41321",
	"43042:43045:2409:931:2299:44410:44407:41332",
	"43042:43045:2409:42983",
	"43042:43045:523:42426",
	"43042:43045:523:42406",
	"43042:43045:2409:931:43000",
	"43042:43045:2409:931:43371:43072",
	"43042:43045:2409:8609:43087",
	"43042:43045:2409:931:43371:43072:43086",
	"43042:43045:2409:931:43088",
	"2859:43107",
	"43042:43045:352:1573:43290",
	"43042:43045:2409:931:43371",
	"43042:43045:2409:931:2299:44410:44409:1572:2835:43570",
	"43042:43045:352:1573:43701",
	"43042:43045:2409:931:2299:44410:44409:1572:43702",
	"43042:43045:43697",
	"43042:43045:2409:931:2299:44410:44407:12617:44231",
	"43042:43045:2409:931:2299:44410:44409",
	"43042:43045:2409:931:2299:44410",
	"43042:43045:2409:931:2299:44410:44407",
	"43042:43045:352:1573:12596:46006",
	"43042:43045:352:1573:12596:46011",
	"43042:43045:2409:931:2299:44410:44409:1572:47119",
	"43042:43045:2409:931:2299:44410:44409:1572:47119:47147:47118",
	"43042:43045:2409:931:2299:44410:44409:1572:47119:47147",
	"43042:43045:2409:931:2299:44410:44409:1572:47119:47147:47154",
	"43042:43045:2409:931:2299:44410:44409:1572:47119:47155",
	"43042:43045:352:1573:12596:46011:47875",
	"43042:43045:352:2941:47927",
	"43042:43045:2409:931:2299:48321:48318",
	"43042:43045:2409:931:2299:48321",
	--["name"] = "Explorers' League Digsite, Stranglethorn",
	["m"] = 210,
	["coord"] = 2389469569,
	["direct"] = "2859:43042",
	["f"] = 0,
	},
	[43045] = {
	"2409:931",
	"352:1573",
	"352:1573:1571",
	"2409:931:2299:44410:44409:1572",
	"2409:931:2299:44410:44409:1572:2835",
	"2409:931:2299:44410:44409:1572:2835:8018",
	"2409:8609",
	"352:1573:12596",
	"2409:931:2299:44410:44407:12617",
	"2409:931:2299",
	"352:2941",
	"2409:931:2299:44410:44407:12617:44230:44233",
	"2409:931:2299:44410:44407:12617:44230:28621",
	"2409:931:2299:44410:44407:12617:44230",
	"352:1573:12596:37888:44232",
	"2409:931:2299:44410:44407:12617:24851",
	"352:1573:26560",
	"2409:931:2299:44410:44407:12617:29480",
	"352:1573:12596:37888",
	"2409:931:2299:44410:44409:1572:41321:41322:41323",
	"2409:931:2299:44410:44409:1572:41321:41322",
	"2409:931:2299:44410:44409:1572:41321:41322:41325",
	"2409:931:2299:44410:44409:1572:41321",
	"2409:931:2299:44410:44407:41332",
	"2409:42983",
	"523:42426",
	"523:42406",
	"2409:931:43000",
	"43042:43043",
	"2409:931:43371:43072",
	"2409:8609:43087",
	"2409:931:43371:43072:43086",
	"2409:931:43088",
	"2409:8609:43107",
	"352:1573:43290",
	"2409:931:43371",
	"2409:931:2299:44410:44409:1572:2835:43570",
	"352:1573:43701",
	"2409:931:2299:44410:44409:1572:43702",
	"2409:931:2299:44410:44407:12617:44231",
	"2409:931:2299:44410:44409",
	"2409:931:2299:44410",
	"2409:931:2299:44410:44407",
	"352:1573:12596:46006",
	"352:1573:12596:46011",
	"2409:931:2299:44410:44409:1572:47119",
	"2409:931:2299:44410:44409:1572:47119:47147:47118",
	"2409:931:2299:44410:44409:1572:47119:47147",
	"2409:931:2299:44410:44409:1572:47119:47147:47154",
	"2409:931:2299:44410:44409:1572:47119:47155",
	"352:1573:12596:46011:47875",
	"352:2941:47927",
	"2409:931:2299:48321:48318",
	"2409:931:2299:48321",
	--["name"] = "Rebel Camp, Stranglethorn Vale",
	["m"] = 50,
	["coord"] = 2053775016,
	["direct"] = "352:523:2409:2859:43042:43697",
	["f"] = 0,
	},
	[352] = {
	"1573:1571",
	"2941:1572",
	"2941:1572:2835",
	"1573:8018",
	"1573:12596",
	"2941:1572:2835:43570:12617",
	"1573:12596:46011:47875:44233",
	"2941:1572:2835:43570:12617:44230:28621",
	"2941:1572:2835:43570:12617:44230",
	"1573:12596:37888:44232",
	"2941:1572:2835:43570:12617:24851",
	"1573:26560",
	"2941:1572:2835:43570:12617:29480",
	"1573:12596:37888",
	"2941:1572:41321:41322:41323",
	"2941:1572:41321:41322",
	"2941:1572:41321:41322:41325",
	"2941:1572:41321",
	"2941:1572:41332",
	"523:42426",
	"42983:43000",
	"43045:43042",
	"43045:43042:43043",
	"931:43371:43072",
	"931:43088:43087",
	"931:43371:43072:43086",
	"931:43088",
	"8609:43107",
	"1573:43290",
	"931:43371",
	"2941:1572:2835:43570",
	"1573:43701",
	"1573:43702",
	"523:43697",
	"2941:1572:2835:43570:12617:44231",
	"2299:44410:44409",
	"2299:44410",
	"2299:44410:44407",
	"1573:12596:46006",
	"1573:12596:46011",
	"2941:1572:47119",
	"2941:1572:47119:47147:47118",
	"2941:1572:47119:47147",
	"2941:1572:47119:47147:47154",
	"2941:1572:47119:47155",
	"1573:12596:46011:47875",
	"2941:47927",
	"2941:47927:48318",
	"2299:48321",
	--["name"] = "Stormwind, Elwynn",
	["m"] = 84,
	["f"] = 0,
	["direct"] = "523:931:1573:2409:2859:8609:2299:2941:43045:42983:42406",
	["coord"] = 3044260406,
	},
	[523] = {
	"352:1573",
	"352:1573:1571",
	"352:2941:1572",
	"352:2941:1572:2835",
	"352:1573:8018",
	"43697:2409:8609",
	"352:1573:12596",
	"352:2941:1572:2835:43570:12617",
	"931:2299",
	"352:2941",
	"352:1573:12596:46011:47875:44233",
	"352:2941:1572:2835:43570:12617:44230:28621",
	"352:2941:1572:2835:43570:12617:44230",
	"352:1573:12596:37888:44232",
	"352:2941:1572:2835:43570:12617:24851",
	"352:1573:26560",
	"352:2941:1572:2835:43570:12617:29480",
	"352:1573:12596:37888",
	"352:2941:1572:41321:41322:41323",
	"352:2941:1572:41321:41322",
	"352:2941:1572:41321:41322:41325",
	"352:2941:1572:41321",
	"931:2299:44410:44407:41332",
	"352:42983",
	"352:42983:43000",
	"43045:43042",
	"43045:43042:43043",
	"931:43371:43072",
	"931:43088:43087",
	"931:43371:43072:43086",
	"931:43088",
	"43697:2409:8609:43107",
	"352:1573:43290",
	"931:43371",
	"352:2941:1572:2835:43570",
	"352:1573:43701",
	"352:1573:43702",
	"352:2941:1572:2835:43570:12617:44231",
	"931:2299:44410:44409",
	"931:2299:44410",
	"931:2299:44410:44407",
	"352:1573:12596:46006",
	"352:1573:12596:46011",
	"352:2941:1572:47119",
	"352:2941:1572:47119:47147:47118",
	"352:2941:1572:47119:47147",
	"352:2941:1572:47119:47147:47154",
	"352:2941:1572:47119:47155",
	"352:1573:12596:46011:47875",
	"352:2941:47927",
	"931:2299:48321:48318",
	"931:2299:48321",
	--["name"] = "Sentinel Hill, Westfall",
	["m"] = 52,
	["coord"] = 2432532065,
	["direct"] = "352:931:2409:2859:43045:42426:42406:43697",
	["f"] = 0,
	},
	},
	[4] = {
	[26881] = {
	"26878:23859:23736",
	"26878:26880:24061",
	"26878:23859",
	"26602:24795:27046",
	"26878:26880",
	"26878:26880:26876",
	"26602:24795",
	"28196:28197",
	"26878:28615:28623",
	"26878:28615",
	"26878:28618",
	"26878:28615:28623:28624",
	"26602:28574",
	"26877:28674",
	"26877:28674:29721",
	"26877:28674:30433:29750",
	"30869:31078",
	"26877:28674:30433:29750:29951",
	"26877:28674:30433:29750:29950",
	"26878:28615:28623:28624:30569",
	"26877:28674:30433",
	"26878:30271",
	"26877:28674:33849",
	--["name"] = "Stars' Rest, Dragonblight",
	["direct"] = "26878:26879:26602:26877:26851:28196:28195:30869",
	["f"] = 0,
	["m"] = 115,
	["coord"] = 1252167108,
	},
	[26851] = {
	"26878:23859:23736",
	"26878:26880:24061",
	"26878:23859",
	"26881:26602:24795:27046",
	"26881:26879",
	"26881:26602",
	"26878:26880",
	"26878:26880:26876",
	"26881:26602:24795",
	"26878:23859:28197",
	"26881:28195",
	"26877:30869",
	"28615:28623",
	"26878:28618",
	"28615:28623:28624",
	"26877:30869:28574",
	"28615:29721",
	"28674:30433:29750",
	"26877:30869:31078",
	"28674:30433:29750:29951",
	"28674:30433:29750:29950",
	"28615:28623:28624:30569",
	"28674:30433",
	"26878:30271",
	"28674:33849",
	--["name"] = "Wyrmrest Temple, Dragonblight",
	["direct"] = "26878:26881:26877:28196:28615:28674",
	["f"] = 0,
	["m"] = 115,
	["coord"] = 2588050319,
	},
	[28623] = {
	"26876:24061:23736",
	"26876:24061",
	"28618:26880:23859",
	"28615:26851:26881:26602:24795:27046",
	"28618:26878",
	"28615:26851:26881:26879",
	"28615:26851:26881:26602",
	"28615:26851:26881",
	"28615:26877",
	"28615:26851",
	"28618:26880",
	"28615:26851:26881:26602:24795",
	"28615:26851:28196",
	"28618:26880:23859:28197",
	"28615:26851:26881:28195",
	"28615:26877:30869",
	"28615:28674:28574",
	"28615:28674",
	"28615:29721",
	"28615:29721:29750",
	"28615:26877:30869:31078",
	"28624:29951",
	"28615:29721:29750:29950",
	"28624:30569",
	"28615:28674:30433",
	"28615:30271",
	"28615:28674:33849",
	--["name"] = "The Argent Stand, Zul'Drak",
	["direct"] = "26876:28615:28618:28624",
	["coord"] = 1782359323,
	["m"] = 121,
	["f"] = 0,
	},
	[24795] = {
	"26602:28195:28196:28197:23736",
	"26602:26881:26878:26880:24061",
	"26602:26881:26878:23859",
	"26602:26881:26878",
	"26602:26881",
	"26602:26881:26877",
	"26602:26881:26851",
	"26602:26881:26878:26880",
	"26602:26881:26878:26880:26876",
	"26602:28195:28196",
	"26602:28195:28196:28197",
	"26602:28195",
	"26602:26881:30869",
	"26602:26881:26878:28615:28623",
	"26602:26881:26878:28615",
	"26602:26881:26878:28618",
	"26602:26881:26878:28615:28623:28624",
	"26602:28574",
	"26602:28574:28674",
	"26602:28574:28674:29721",
	"26602:28574:28674:30433:29750",
	"26602:28574:31078",
	"26602:28574:28674:30433:29750:29951",
	"26602:28574:28674:30433:29750:29950",
	"26602:26881:26878:28615:28623:28624:30569",
	"26602:28574:28674:30433",
	"26602:28574:28674:30271",
	"26602:28574:28674:33849",
	--["name"] = "Amber Ledge, Borean Tundra",
	["direct"] = "27046:26879:26602",
	["f"] = 0,
	["m"] = 114,
	["coord"] = 1941854002,
	},
	[28624] = {
	"26876:24061:23736",
	"26876:24061",
	"26876:26880:23859",
	"28623:28615:26851:26881:26602:24795:27046",
	"28623:28618:26878",
	"28623:28615:26851:26881:26879",
	"28623:28615:26851:26881:26602",
	"28623:28615:26851:26881",
	"28623:28615:26877",
	"28623:28615:26851",
	"26876:26880",
	"28623:28615:26851:26881:26602:24795",
	"28623:28615:26851:28196",
	"26876:26880:23859:28197",
	"28623:28615:26851:26881:28195",
	"28623:28615:26877:30869",
	"28623:28615",
	"28623:28618",
	"28623:28615:28674:28574",
	"28623:28615:28674",
	"28623:28615:29721",
	"28623:28615:29721:29750",
	"28623:28615:26877:30869:31078",
	"29951:29950",
	"28623:28615:28674:30433",
	"28623:28615:30271",
	"29951:29950:33849",
	--["name"] = "Zim'Torga, Zul'Drak",
	["direct"] = "26876:28623:29951:30569",
	["coord"] = 2575798639,
	["m"] = 121,
	["f"] = 0,
	},
	[26879] = {
	"28195:28196:28197:23736",
	"28195:28196:26878:26880:24061",
	"28195:28196:26878:23859",
	"24795:27046",
	"28195:28196:26878",
	"26881:26877",
	"28195:28196:26851",
	"28195:28196:26878:26880",
	"28195:28196:26878:26880:26876",
	"28195:28196",
	"28195:28196:28197",
	"26881:30869",
	"28195:28196:26878:28615:28623",
	"28195:28196:26878:28615",
	"28195:28196:26878:28618",
	"28195:28196:26878:28615:28623:28624",
	"26602:28574",
	"28674:29721",
	"28674:30433:29750",
	"26602:28574:31078",
	"28674:30433:29750:29951",
	"28674:30433:29750:29950",
	"28195:28196:26878:28615:28623:28624:30569",
	"28674:30433",
	"28674:30271",
	"28674:33849",
	--["name"] = "Valiance Keep, Borean Tundra",
	["direct"] = "26602:26881:24795:28195:28674",
	["f"] = 0,
	["m"] = 114,
	["coord"] = 2530782958,
	},
	[29721] = {
	"28615:26878:23859:23736",
	"28615:28623:26876:24061",
	"28615:26878:23859",
	"28615:26851:26881:26602:24795:27046",
	"28615:26878",
	"28615:26851:26881:26879",
	"28615:26851:26881:26602",
	"28615:26851:26881",
	"28615:26877",
	"28615:26851",
	"28615:28618:26880",
	"28615:28623:26876",
	"28615:26851:26881:26602:24795",
	"28615:26851:28196",
	"28615:26878:23859:28197",
	"28615:26851:26881:28195",
	"28674:30869",
	"28615:28623",
	"28615:28618",
	"28615:28623:28624",
	"28674:28574",
	"28674:30869:31078",
	"29750:29951",
	"29750:29950",
	"28615:28623:28624:30569",
	"29750:30433",
	"29750:29950:33849",
	--["name"] = "K3, The Storm Peaks",
	["direct"] = "28615:28674:29750:30271",
	["coord"] = 1747966094,
	["m"] = 120,
	["f"] = 0,
	},
	[30569] = {
	"28624:26876:24061:23736",
	"28624:26876:24061",
	"28624:26876:26880:23859",
	"28624:28623:28615:26851:26881:26602:24795:27046",
	"28624:28623:28618:26878",
	"28624:28623:28615:26851:26881:26879",
	"28624:28623:28615:26851:26881:26602",
	"28624:28623:28615:26851:26881",
	"28624:28623:28615:26877",
	"28624:28623:28615:26851",
	"28624:26876:26880",
	"28624:26876",
	"28624:28623:28615:26851:26881:26602:24795",
	"28624:28623:28615:26851:28196",
	"28624:26876:26880:23859:28197",
	"28624:28623:28615:26851:26881:28195",
	"28624:28623:28615:26877:30869",
	"28624:28623",
	"28624:28623:28615",
	"28624:28623:28618",
	"28624:28623:28615:28674:28574",
	"28624:28623:28615:28674",
	"28624:28623:28615:29721",
	"28624:28623:28615:29721:29750",
	"28624:28623:28615:26877:30869:31078",
	"28624:29951",
	"28624:29951:29950",
	"28624:28623:28615:28674:30433",
	"28624:28623:28615:30271",
	"28624:29951:29950:33849",
	--["name"] = "Gundrak, Zul'Drak",
	["direct"] = "28624",
	["coord"] = 3025877834,
	["m"] = 121,
	["f"] = 0,
	},
	[29950] = {
	"29951:28624:26876:24061:23736",
	"29951:28624:26876:24061",
	"29750:29721:28615:26878:23859",
	"29750:30433:28674:28574:26602:24795:27046",
	"29750:29721:28615:26878",
	"29750:30433:28674:26879",
	"29750:30433:28674:28574:26602",
	"29750:30433:28674:26877:26881",
	"29750:30433:28674:26877",
	"29750:29721:28615:26851",
	"29750:29721:28615:28618:26880",
	"29951:28624:26876",
	"29750:30433:28674:28574:26602:24795",
	"29750:30433:28674:28196",
	"29750:29721:28615:26878:23859:28197",
	"29750:30433:28674:26877:26881:28195",
	"29750:30433:28674:30869",
	"29750:29721:28615:28623",
	"29750:29721:28615",
	"29750:29721:28615:28618",
	"29951:28624",
	"29750:30433:28674:28574",
	"29750:30433:28674",
	"29750:29721",
	"29750:30433:28674:30869:31078",
	"29951:28624:30569",
	"29750:30433",
	"29750:29721:30271",
	--["name"] = "Bouldercrag's Refuge, The Storm Peaks",
	["direct"] = "29750:29951:33849",
	["coord"] = 1315003687,
	["m"] = 120,
	["f"] = 0,
	},
	[24061] = {
	"26880:26878:26881:26602:24795:27046",
	"26880:26878",
	"26880:26878:26881:26879",
	"26880:26878:26881:26602",
	"26880:26878:26881",
	"26880:26878:26877",
	"26880:26878:26851",
	"26880:26878:26881:26602:24795",
	"26880:26878:28196",
	"23859:28197",
	"26880:26878:26881:28195",
	"26880:26878:26877:30869",
	"26876:28623",
	"26880:28618:28615",
	"26880:28618",
	"26876:28624",
	"26880:26878:26877:30869:28574",
	"26880:28618:28615:28674",
	"26880:28618:28615:29721",
	"26880:28618:28615:29721:29750",
	"26880:26878:26877:30869:31078",
	"26876:28624:29951",
	"26880:28618:28615:29721:29750:29950",
	"26876:28624:30569",
	"26880:28618:28615:28674:30433",
	"26880:28618:28615:30271",
	"26880:28618:28615:28674:33849",
	--["name"] = "Fort Wildervar, Howling Fjord",
	["direct"] = "23736:23859:26880:26876",
	["coord"] = 2579048738,
	["m"] = 117,
	["f"] = 0,
	},
	[27046] = {
	"24795:26602:28195:28196:28197:23736",
	"24795:26602:26881:26878:26880:24061",
	"24795:26602:26881:26878:23859",
	"24795:26602:26881:26878",
	"24795:26879",
	"24795:26602",
	"24795:26602:26881",
	"24795:26602:26881:26877",
	"24795:26602:26881:26851",
	"24795:26602:26881:26878:26880",
	"24795:26602:26881:26878:26880:26876",
	"24795:26602:28195:28196",
	"24795:26602:28195:28196:28197",
	"24795:26602:28195",
	"24795:26602:26881:30869",
	"24795:26602:26881:26878:28615:28623",
	"24795:26602:26881:26878:28615",
	"24795:26602:26881:26878:28618",
	"24795:26602:26881:26878:28615:28623:28624",
	"24795:26602:28574",
	"24795:26602:28574:28674",
	"24795:26602:28574:28674:29721",
	"24795:26602:28574:28674:30433:29750",
	"24795:26602:28574:31078",
	"24795:26602:28574:28674:30433:29750:29951",
	"24795:26602:28574:28674:30433:29750:29950",
	"24795:26602:26881:26878:28615:28623:28624:30569",
	"24795:26602:28574:28674:30433",
	"24795:26602:28574:28674:30271",
	"24795:26602:28574:28674:33849",
	--["name"] = "Transitus Shield, Coldarra",
	["direct"] = "24795",
	["f"] = 0,
	["m"] = 114,
	["coord"] = 1422481428,
	},
	[28674] = {
	"28615:28623:26876:24061",
	"30271:26878:23859",
	"28574:26602:24795:27046",
	"30271:26878",
	"28574:26602",
	"26877:26881",
	"30271:26878:26880",
	"28615:28623:26876",
	"28574:26602:24795",
	"30271:26878:23859:28197",
	"26877:26881:28195",
	"28615:28623",
	"28615:28618",
	"28615:28623:28624",
	"30433:29750",
	"30869:31078",
	"30433:29750:29951",
	"30433:29750:29950",
	"28615:28623:28624:30569",
	--["name"] = "Dalaran",
	["direct"] = "23736:26879:26877:26851:28196:30869:28615:28574:29721:30433:30271:33849",
	["coord"] = 3122361585,
	["m"] = 125,
	["f"] = 0,
	},
	[30271] = {
	"26878:23859:23736",
	"28615:28623:26876:24061",
	"26878:23859",
	"26878:26881:26602:24795:27046",
	"28674:26879",
	"26878:26881:26602",
	"26878:26881",
	"28674:26877",
	"26878:26851",
	"26878:26880",
	"28615:28623:26876",
	"26878:26881:26602:24795",
	"26878:28196",
	"26878:23859:28197",
	"26878:26881:28195",
	"28674:30869",
	"28615:28623",
	"28615:28618",
	"28615:28623:28624",
	"28674:28574",
	"29721:29750",
	"28674:30869:31078",
	"29721:29750:29951",
	"29721:29750:29950",
	"28615:28623:28624:30569",
	"28674:30433",
	"28674:33849",
	--["name"] = "Windrunner's Overlook, Crystalsong Forest",
	["direct"] = "26878:28615:28674:29721",
	["coord"] = 3097546464,
	["m"] = 127,
	["f"] = 0,
	},
	[26877] = {
	"26878:23859:23736",
	"26878:26880:24061",
	"26878:23859",
	"26881:26602:24795:27046",
	"26881:26879",
	"26881:26602",
	"26878:26880",
	"26878:26880:26876",
	"26881:26602:24795",
	"26851:28196",
	"26878:23859:28197",
	"26881:28195",
	"28615:28623",
	"28615:28618",
	"28615:28623:28624",
	"30869:28574",
	"28674:29721",
	"28674:30433:29750",
	"30869:31078",
	"28674:30433:29750:29951",
	"28674:30433:29750:29950",
	"28615:28623:28624:30569",
	"28674:30433",
	"28674:30271",
	"28674:33849",
	--["name"] = "Fordragon Hold, Dragonblight",
	["direct"] = "26878:26881:26851:30869:28615:28674",
	["f"] = 0,
	["m"] = 115,
	["coord"] = 1698316841,
	},
	[28195] = {
	"28196:28197:23736",
	"28196:26878:26880:24061",
	"28196:26878:23859",
	"26879:24795:27046",
	"28196:26878",
	"26881:26877",
	"28196:26851",
	"28196:26878:26880",
	"28196:26878:26880:26876",
	"26879:24795",
	"28196:28197",
	"26881:30869",
	"28196:26878:28615:28623",
	"28196:26878:28615",
	"28196:26878:28618",
	"28196:26878:28615:28623:28624",
	"26602:28574",
	"28196:28674",
	"28196:28674:29721",
	"28196:28674:30433:29750",
	"26602:28574:31078",
	"28196:28674:30433:29750:29951",
	"28196:28674:30433:29750:29950",
	"28196:26878:28615:28623:28624:30569",
	"28196:28674:30433",
	"28196:26878:30271",
	"28196:28674:33849",
	--["name"] = "Unu'pe, Borean Tundra",
	["direct"] = "26879:26602:26881:28196",
	["f"] = 0,
	["m"] = 114,
	["coord"] = 3373761499,
	},
	[26878] = {
	"23859:23736",
	"26880:24061",
	"26881:26602:24795:27046",
	"26881:26879",
	"26881:26602",
	"26880:26876",
	"26881:26602:24795",
	"23859:28197",
	"26881:28195",
	"26877:30869",
	"28615:28623",
	"28615:28623:28624",
	"26877:30869:28574",
	"30271:28674",
	"28615:29721",
	"28615:29721:29750",
	"26877:30869:31078",
	"28615:29721:29750:29951",
	"28615:29721:29750:29950",
	"28615:28623:28624:30569",
	"30271:28674:30433",
	"30271:28674:33849",
	--["name"] = "Wintergarde Keep, Dragonblight",
	["direct"] = "23859:26881:26877:26851:26880:28196:28615:28618:30271",
	["f"] = 0,
	["m"] = 115,
	["coord"] = 3309862785,
	},
	[28196] = {
	"28197:23736",
	"26878:26880:24061",
	"26878:23859",
	"26881:26602:24795:27046",
	"26881:26879",
	"26881:26602",
	"26851:26877",
	"26878:26880",
	"26878:26880:26876",
	"26881:26602:24795",
	"26881:30869",
	"26878:28615:28623",
	"26878:28615",
	"26878:28618",
	"26878:28615:28623:28624",
	"26881:26602:28574",
	"28674:29721",
	"28674:30433:29750",
	"26881:30869:31078",
	"28674:30433:29750:29951",
	"28674:30433:29750:29950",
	"26878:28615:28623:28624:30569",
	"28674:30433",
	"26878:30271",
	"28674:33849",
	--["name"] = "Moa'ki, Dragonblight",
	["direct"] = "26878:26881:26851:28197:28195:28674",
	["f"] = 0,
	["m"] = 115,
	["coord"] = 2081865321,
	},
	[28615] = {
	"26878:23859:23736",
	"28623:26876:24061",
	"26878:23859",
	"26851:26881:26602:24795:27046",
	"26851:26881:26879",
	"26851:26881:26602",
	"26851:26881",
	"28618:26880",
	"28623:26876",
	"26851:26881:26602:24795",
	"26851:28196",
	"26878:23859:28197",
	"26851:26881:28195",
	"26877:30869",
	"28623:28624",
	"28674:28574",
	"29721:29750",
	"26877:30869:31078",
	"29721:29750:29951",
	"29721:29750:29950",
	"28623:28624:30569",
	"28674:30433",
	"28674:33849",
	--["name"] = "Ebon Watch, Zul'Drak",
	["direct"] = "26878:26877:26851:28623:28618:28674:29721:30271",
	["coord"] = 602061951,
	["m"] = 121,
	["f"] = 0,
	},
	[28197] = {
	"23859:24061",
	"28196:26881:26602:24795:27046",
	"23859:26878",
	"28196:26881:26879",
	"28196:26881:26602",
	"28196:26881",
	"23859:26878:26877",
	"23859:26878:26851",
	"23859:26880",
	"23859:26880:26876",
	"28196:26881:26602:24795",
	"28196:28195",
	"28196:26881:30869",
	"23859:26880:28618:28623",
	"23859:26880:28618:28615",
	"23859:26880:28618",
	"23859:26880:28618:28623:28624",
	"28196:26881:26602:28574",
	"23859:26880:28618:28615:28674",
	"23859:26880:28618:28615:29721",
	"23859:26880:28618:28615:29721:29750",
	"28196:26881:30869:31078",
	"23859:26880:28618:28615:29721:29750:29951",
	"23859:26880:28618:28615:29721:29750:29950",
	"23859:26880:28618:28623:28624:30569",
	"23859:26880:28618:28615:28674:30433",
	"23859:26880:28618:28615:30271",
	"23859:26880:28618:28615:28674:33849",
	--["name"] = "Kamagua, Howling Fjord",
	["direct"] = "23736:23859:28196",
	["f"] = 0,
	["m"] = 117,
	["coord"] = 1058378722,
	},
	[26880] = {
	"23859:23736",
	"26878:26881:26602:24795:27046",
	"26878:26881:26879",
	"26878:26881:26602",
	"26878:26881",
	"26878:26877",
	"26878:26851",
	"26878:26881:26602:24795",
	"26878:28196",
	"23859:28197",
	"26878:26881:28195",
	"26878:26877:30869",
	"28618:28623",
	"28618:28615",
	"28618:28623:28624",
	"26878:26877:30869:28574",
	"28618:28615:28674",
	"28618:28615:29721",
	"28618:28615:29721:29750",
	"26878:26877:30869:31078",
	"28618:28615:29721:29750:29951",
	"28618:28615:29721:29750:29950",
	"28618:28623:28624:30569",
	"28618:28615:28674:30433",
	"28618:28615:30271",
	"28618:28615:28674:33849",
	--["name"] = "Amberpine Lodge, Grizzly Hills",
	["direct"] = "24061:23859:26878:26876:28618",
	["f"] = 0,
	["m"] = 116,
	["coord"] = 1344706412,
	},
	[29750] = {
	"29721:28615:26878:23859:23736",
	"29721:28615:28623:26876:24061",
	"29721:28615:26878:23859",
	"30433:28674:28574:26602:24795:27046",
	"29721:28615:26878",
	"30433:28674:26879",
	"30433:28674:28574:26602",
	"30433:28674:26877:26881",
	"30433:28674:26877",
	"29721:28615:26851",
	"29721:28615:28618:26880",
	"29721:28615:28623:26876",
	"30433:28674:28574:26602:24795",
	"30433:28674:28196",
	"29721:28615:26878:23859:28197",
	"30433:28674:26877:26881:28195",
	"30433:28674:30869",
	"29721:28615:28623",
	"29721:28615",
	"29721:28615:28618",
	"29721:28615:28623:28624",
	"30433:28674:28574",
	"30433:28674",
	"30433:28674:30869:31078",
	"29721:28615:28623:28624:30569",
	"29721:30271",
	"29950:33849",
	--["name"] = "Frosthold, The Storm Peaks",
	["direct"] = "29721:29951:29950:30433",
	["coord"] = 1267646062,
	["m"] = 120,
	["f"] = 0,
	},
	[26602] = {
	"28195:28196:28197:23736",
	"26881:26878:26880:24061",
	"26881:26878:23859",
	"24795:27046",
	"26881:26878",
	"26881:26877",
	"26881:26851",
	"26881:26878:26880",
	"26881:26878:26880:26876",
	"28195:28196",
	"28195:28196:28197",
	"26881:30869",
	"26881:26878:28615:28623",
	"26881:26878:28615",
	"26881:26878:28618",
	"26881:26878:28615:28623:28624",
	"28574:28674",
	"28574:28674:29721",
	"28574:28674:30433:29750",
	"28574:31078",
	"28574:28674:30433:29750:29951",
	"28574:28674:30433:29750:29950",
	"26881:26878:28615:28623:28624:30569",
	"28574:28674:30433",
	"28574:28674:30271",
	"28574:28674:33849",
	--["name"] = "Fizzcrank Airstrip, Borean Tundra",
	["direct"] = "26879:26881:24795:28195:28574",
	["f"] = 0,
	["m"] = 114,
	["coord"] = 2427204436,
	},
	[23859] = {
	"26878:26881:26602:24795:27046",
	"26878:26881:26879",
	"26878:26881:26602",
	"26878:26881",
	"26878:26877",
	"26878:26851",
	"26880:26876",
	"26878:26881:26602:24795",
	"28197:28196",
	"26878:26881:28195",
	"26878:26877:30869",
	"26880:28618:28623",
	"26880:28618:28615",
	"26880:28618",
	"26880:28618:28623:28624",
	"26878:26877:30869:28574",
	"26880:28618:28615:28674",
	"26880:28618:28615:29721",
	"26880:28618:28615:29721:29750",
	"26878:26877:30869:31078",
	"26880:28618:28615:29721:29750:29951",
	"26880:28618:28615:29721:29750:29950",
	"26880:28618:28623:28624:30569",
	"26880:28618:28615:28674:30433",
	"26880:28618:28615:30271",
	"26880:28618:28615:28674:33849",
	--["name"] = "Westguard Keep, Howling Fjord",
	["direct"] = "23736:24061:26878:26880:28197",
	["f"] = 0,
	["m"] = 117,
	["coord"] = 1342271660,
	},
	[29951] = {
	"28624:26876:24061:23736",
	"28624:26876:24061",
	"28624:26876:26880:23859",
	"29750:30433:28674:28574:26602:24795:27046",
	"29750:29721:28615:26878",
	"29750:30433:28674:26879",
	"29750:30433:28674:28574:26602",
	"29750:30433:28674:26877:26881",
	"29750:30433:28674:26877",
	"29750:29721:28615:26851",
	"28624:26876:26880",
	"28624:26876",
	"29750:30433:28674:28574:26602:24795",
	"29750:30433:28674:28196",
	"28624:26876:26880:23859:28197",
	"29750:30433:28674:26877:26881:28195",
	"29750:30433:28674:30869",
	"28624:28623",
	"29750:29721:28615",
	"28624:28623:28618",
	"29750:30433:28674:28574",
	"29750:30433:28674",
	"29750:29721",
	"29750:30433:28674:30869:31078",
	"28624:30569",
	"29750:30433",
	"29750:29721:30271",
	"29950:33849",
	--["name"] = "Ulduar, The Storm Peaks",
	["direct"] = "28624:29750:29950",
	["coord"] = 1911769082,
	["m"] = 120,
	["f"] = 0,
	},
	[23736] = {
	"23859:26878:26881:26602:24795:27046",
	"23859:26878",
	"23859:26878:26881:26879",
	"23859:26878:26881:26602",
	"23859:26878:26881",
	"23859:26878:26877",
	"23859:26878:26851",
	"23859:26880",
	"24061:26876",
	"23859:26878:26881:26602:24795",
	"28197:28196",
	"28197:28196:28195",
	"23859:26878:26877:30869",
	"24061:26876:28623",
	"23859:26880:28618:28615",
	"23859:26880:28618",
	"24061:26876:28624",
	"28674:28574",
	"23859:26880:28618:28615:29721",
	"23859:26880:28618:28615:29721:29750",
	"23859:26878:26877:30869:31078",
	"24061:26876:28624:29951",
	"23859:26880:28618:28615:29721:29750:29950",
	"24061:26876:28624:30569",
	"28674:30433",
	"23859:26880:28618:28615:30271",
	"28674:33849",
	--["name"] = "Valgarde Port, Howling Fjord",
	["direct"] = "24061:23859:28197:28674",
	["coord"] = 2565906925,
	["m"] = 117,
	["f"] = 0,
	},
	[28618] = {
	"26880:23859:23736",
	"26880:24061",
	"26880:23859",
	"28615:26851:26881:26602:24795:27046",
	"28615:26851:26881:26879",
	"28615:26851:26881:26602",
	"28615:26851:26881",
	"28615:26877",
	"28615:26851",
	"28623:26876",
	"28615:26851:26881:26602:24795",
	"28615:26851:28196",
	"26880:23859:28197",
	"28615:26851:26881:28195",
	"28615:26877:30869",
	"28623:28624",
	"28615:28674:28574",
	"28615:28674",
	"28615:29721",
	"28615:29721:29750",
	"28615:26877:30869:31078",
	"28615:29721:29750:29951",
	"28615:29721:29750:29950",
	"28623:28624:30569",
	"28615:28674:30433",
	"28615:30271",
	"28615:28674:33849",
	--["name"] = "Light's Breach, Zul'Drak",
	["direct"] = "26878:26880:28623:28615",
	["coord"] = 1381744281,
	["m"] = 121,
	["f"] = 0,
	},
	[30433] = {
	"28674:23736",
	"28674:28615:28623:26876:24061",
	"28674:30271:26878:23859",
	"28674:28574:26602:24795:27046",
	"28674:30271:26878",
	"28674:26879",
	"28674:28574:26602",
	"28674:26877:26881",
	"28674:26877",
	"28674:26851",
	"28674:30271:26878:26880",
	"28674:28615:28623:26876",
	"28674:28574:26602:24795",
	"28674:28196",
	"28674:30271:26878:23859:28197",
	"28674:26877:26881:28195",
	"28674:30869",
	"28674:28615:28623",
	"28674:28615",
	"28674:28615:28618",
	"28674:28615:28623:28624",
	"28674:28574",
	"28674:29721",
	"28674:30869:31078",
	"29750:29951",
	"29750:29950",
	"28674:28615:28623:28624:30569",
	"28674:30271",
	"28674:33849",
	--["name"] = "The Argent Vanguard, Icecrown",
	["direct"] = "28674:29750",
	["coord"] = 3770468288,
	["m"] = 118,
	["f"] = 0,
	},
	[31078] = {
	"30869:26877:26878:23859:23736",
	"30869:26877:26878:26880:24061",
	"30869:26877:26878:23859",
	"28574:26602:24795:27046",
	"30869:26877:26878",
	"28574:26602:26879",
	"28574:26602",
	"30869:26881",
	"30869:26877",
	"30869:26877:26851",
	"30869:26877:26878:26880",
	"30869:26877:26878:26880:26876",
	"28574:26602:24795",
	"30869:26881:28196",
	"30869:26877:26878:23859:28197",
	"28574:26602:28195",
	"30869:26877:28615:28623",
	"30869:26877:28615",
	"30869:26877:28615:28618",
	"30869:26877:28615:28623:28624",
	"30869:28674",
	"30869:28674:29721",
	"30869:28674:30433:29750",
	"30869:28674:30433:29750:29951",
	"30869:28674:30433:29750:29950",
	"30869:26877:28615:28623:28624:30569",
	"30869:28674:30433",
	"30869:28674:30271",
	"30869:28674:33849",
	--["name"] = "Death's Rise, Icecrown",
	["direct"] = "30869:28574",
	["f"] = 0,
	["m"] = 118,
	["coord"] = 832731736,
	},
	[28574] = {
	"30869:26877:26878:23859:23736",
	"30869:26877:26878:26880:24061",
	"30869:26877:26878:23859",
	"26602:24795:27046",
	"30869:26877:26878",
	"26602:26879",
	"26602:26881",
	"30869:26877",
	"30869:26877:26851",
	"30869:26877:26878:26880",
	"28674:28615:28623:26876",
	"26602:24795",
	"26602:28195:28196",
	"26602:28195:28196:28197",
	"26602:28195",
	"28674:28615:28623",
	"28674:28615",
	"28674:28615:28618",
	"28674:28615:28623:28624",
	"28674:29721",
	"28674:30433:29750",
	"28674:30433:29750:29951",
	"28674:30433:29750:29950",
	"28674:28615:28623:28624:30569",
	"28674:30433",
	"28674:30271",
	"28674:33849",
	--["name"] = "River's Heart, Sholazar Basin",
	["direct"] = "26602:30869:28674:31078",
	["f"] = 0,
	["m"] = 119,
	["coord"] = 2152176865,
	},
	[33849] = {
	"28674:23736",
	"29950:29951:28624:26876:24061",
	"28674:30271:26878:23859",
	"28674:28574:26602:24795:27046",
	"28674:30271:26878",
	"28674:26879",
	"28674:28574:26602",
	"28674:26877:26881",
	"28674:26877",
	"28674:26851",
	"28674:30271:26878:26880",
	"29950:29951:28624:26876",
	"28674:28574:26602:24795",
	"28674:28196",
	"28674:30271:26878:23859:28197",
	"28674:26877:26881:28195",
	"28674:30869",
	"29950:29750:29721:28615:28623",
	"29950:29750:29721:28615",
	"29950:29750:29721:28615:28618",
	"29950:29951:28624",
	"28674:28574",
	"29950:29750:29721",
	"29950:29750",
	"28674:30869:31078",
	"29950:29951",
	"29950:29951:28624:30569",
	"29950:29750:30433",
	"28674:30271",
	["m"] = 118,
	["coord"] = 3117496817,
	["direct"] = "28674:29950",
	["f"] = 0,
	},
	[30869] = {
	"26877:26878:23859:23736",
	"26877:26878:26880:24061",
	"26877:26878:23859",
	"28574:26602:24795:27046",
	"26877:26878",
	"26881:26879",
	"28574:26602",
	"26877:26851",
	"26877:26878:26880",
	"26877:26878:26880:26876",
	"28574:26602:24795",
	"26881:28196",
	"26877:26878:23859:28197",
	"26881:28195",
	"26877:28615:28623",
	"26877:28615",
	"26877:28615:28618",
	"26877:28615:28623:28624",
	"28674:29721",
	"28674:30433:29750",
	"28674:30433:29750:29951",
	"28674:30433:29750:29950",
	"26877:28615:28623:28624:30569",
	"28674:30433",
	"28674:30271",
	"28674:33849",
	--["name"] = "Valiance Landing Camp, Wintergrasp",
	["direct"] = "26881:26877:28574:28674:31078",
	["f"] = 0,
	["m"] = 123,
	["coord"] = 3094499198,
	},
	[26876] = {
	"24061:23736",
	"26880:23859",
	"26880:26878:26881:26602:24795:27046",
	"26880:26878",
	"26880:26878:26881:26879",
	"26880:26878:26881:26602",
	"26880:26878:26881",
	"28623:28615:26877",
	"26880:26878:26851",
	"26880:26878:26881:26602:24795",
	"26880:26878:28196",
	"26880:23859:28197",
	"26880:26878:26881:28195",
	"28623:28615:26877:30869",
	"28623:28615",
	"28623:28618",
	"28623:28615:28674:28574",
	"28623:28615:28674",
	"28623:28615:29721",
	"28623:28615:29721:29750",
	"28623:28615:26877:30869:31078",
	"28624:29951",
	"28624:29951:29950",
	"28624:30569",
	"28623:28615:28674:30433",
	"28623:28615:30271",
	"28623:28615:28674:33849",
	--["name"] = "Westfall Brigade, Grizzly Hills",
	["direct"] = "24061:26880:28623:28624",
	["coord"] = 2572305445,
	["m"] = 116,
	["f"] = 0,
	},
	},
	[6] = {
	[60441] = {
	"65189:60231:60230:59186",
	"65189:60231:60230:59186:66023",
	"65189:60231:60230:59186:59732",
	"65189:60231:60230:59186:59727",
	"65189:60231:60230:59186:59735:59733",
	"65189:60231:60230:59186:59735",
	"65189:60231:60230:59186:59736",
	"65189:60231:60230:59186:56737",
	"65189:60231:60230",
	"65189:60231",
	"65189:58843",
	"65189:60231:62658",
	"65189:60231:61121",
	"65189:59048:63501",
	"65189:59048:63501:63498",
	"65189:60231:60230:59186:64310",
	"65189:59048:63501:65511",
	"65189:60231:61121:65865",
	--["name"] = "Marista, Krasarang Wilds",
	["direct"] = "59048:65189",
	["f"] = 0,
	["m"] = 418,
	["coord"] = 2251015149,
	},
	[62658] = {
	"60230:59186",
	"60230:59186:66023",
	"60230:59186:59732",
	"60230:59186:59727",
	"60230:59186:59735:59733",
	"60230:59186:59735",
	"60230:59186:59736",
	"60230:59186:56737",
	"60230:59186:64310",
	--["name"] = "Grassy Cline, Valley of the Four Winds",
	["m"] = 376,
	["f"] = 0,
	["direct"] = "60230:61121",
	["coord"] = 3043769801,
	},
	[61473] = {
	"62903:63500:63501:58843:60231:60230:59186",
	"62903:63500:63501:58843:60231:60232:66023",
	"62903:63500:63501:58843:60231:60230:59186:59732",
	"62903:63500:63501:58843:60231:60230:59186:59727",
	"62903:63500:63501:58843:60231:60230:59186:59735:59733",
	"62903:63500:63501:58843:60231:60230:59186:59735",
	"62903:63500:63501:58843:60231:60230:59186:59736",
	"62903:63500:63501:58843:60231:60232:66023:56737",
	"62903:63500:63501:58843:60231:60230",
	"62903:63500:63501:58843:60231",
	"62903:63500:63501:58843:60231:60232",
	"62903:63500:63501:58843:59049",
	"62903:63500:63501:58843",
	"62903:63500:63501:59048",
	"62903:63500:63501:59048:65189",
	"62903:63500:63501:59048:60441",
	"62903:63500:63501:58843:60231:62658:61759",
	"62903:63500:63501:58843:60231:62658",
	"62903:62898",
	"62903:62898:62909",
	"62903:63500:61121",
	"62903:63500:63501",
	"62903:63500:63501:63498",
	"62903:63500",
	"62903:63500:63497",
	"62903:63500:63501:58843:60231:60230:59186:64310",
	"62903:63500:63501:65511",
	"62903:63500:61121:65865",
	--["name"] = "Shado-Pan Fallback, Kun-Lai Summit",
	["direct"] = "62901:62903",
	["f"] = 0,
	["m"] = 379,
	["coord"] = 1885922581,
	},
	[64310] = {
	"59186:61121",
	--["name"] = "Serpent's Overlook, Jade Forest",
	["m"] = 371,
	["f"] = 0,
	["direct"] = "59186",
	["coord"] = 1852354380,
	},
	[65511] = {
	"63501:58843:60231:60230:59186",
	"63501:61121:66023",
	"63501:58843:60231:60230:59186:59732",
	"63501:58843:60231:60230:59186:59727",
	"63501:58843:60231:60230:59186:59735:59733",
	"63501:58843:60231:60230:59186:59735",
	"63501:58843:60231:60230:59186:59736",
	"63501:58843:60231:60230:59186:56737",
	"63501:58843:60231:60230",
	"63501:58843:60231",
	"63501:58843",
	"63501:58843:60231:62658",
	"63501:61121",
	"63501:58843:60231:60230:59186:64310",
	"63501:61121:65865",
	--["name"] = "The Briny Muck, Dread Wastes",
	["m"] = 422,
	["f"] = 0,
	["direct"] = "63501",
	["coord"] = 1829801648,
	},
	[63497] = {
	"61121:60230:59186",
	"61121:66023",
	"61121:60230:59186:59732",
	"61121:60230:59186:59727",
	"61121:60230:59186:59735:59733",
	"61121:60230:59186:59735",
	"61121:60230:59186:59736",
	"61121:66023:56737",
	"61121:60230",
	"61121:60231",
	"61121:60231:60232",
	"61121:60231:59049",
	"63501:58843",
	"63501:59048",
	"63501:59048:65189",
	"63501:59048:60441",
	"61121:62658:61759",
	"61121:62658",
	"61121:60230:59186:64310",
	"63501:65511",
	"61121:65865",
	--["name"] = "Serpent's Spine, Vale of Eternal Blossoms",
	["direct"] = "61121:63501:63498",
	["f"] = 0,
	["m"] = 390,
	["coord"] = 605866716,
	},
	[63501] = {
	"58843:60231:60230:59186",
	"61121:66023",
	"58843:60231:60230:59186:59732",
	"58843:60231:60230:59186:59727",
	"58843:60231:60230:59186:59735:59733",
	"58843:60231:60230:59186:59735",
	"58843:60231:60230:59186:59736",
	"58843:60231:60230:59186:56737",
	"58843:60231:60230",
	"58843:60231",
	"58843:60231:62658",
	"58843:60231:60230:59186:64310",
	"61121:65865",
	--["name"] = "Klaxxi'vess, Dread Wastes",
	["m"] = 422,
	["f"] = 0,
	["direct"] = "58843:61121",
	["coord"] = 2394249583,
	},
	[58843] = {
	"60231:60230:59186",
	"60231:60230:59186:66023",
	"60231:60230:59186:59732",
	"60231:60230:59186:59727",
	"60231:60230:59186:59735:59733",
	"60231:60230:59186:59735",
	"60231:60230:59186:59736",
	"60231:60230:59186:56737",
	"60231:60230",
	"60231:62658",
	"60231:61121",
	"60231:60230:59186:64310",
	--["name"] = "Stoneplow, Valley of the Four Winds",
	["m"] = 376,
	["f"] = 0,
	["direct"] = "60231",
	["coord"] = 872453665,
	},
	[60231] = {
	"60230:59186",
	"60230:59186:66023",
	"60230:59186:59732",
	"60230:59186:59727",
	"60230:59186:59735:59733",
	"60230:59186:59735",
	"60230:59186:59736",
	"60230:59186:56737",
	"60230:59186:64310",
	--["name"] = "Halfhill, Valley of the Four Winds",
	["m"] = 376,
	["f"] = 0,
	["direct"] = "60230:62658:61121",
	["coord"] = 2421915908,
	},
	[59733] = {
	"59732:59186",
	"59732:59727:66023",
	"59732:59727",
	"59732:59727:56737",
	"59732:59186:61121",
	"59732:59186:64310",
	--["name"] = "Sri-La Village, Jade Forest",
	["direct"] = "59732",
	["f"] = 0,
	["m"] = 371,
	["coord"] = 2379365582,
	},
	[59735] = {
	"59186:66023",
	"59186:59732",
	"59186:59727",
	"59186:56737",
	"59186:61121",
	"59186:64310",
	--["name"] = "Emperor's Omen, Jade Forest",
	["direct"] = "59186:59733",
	["f"] = 0,
	["m"] = 371,
	["coord"] = 2182890659,
	},
	[59048] = {
	"60231:60230:59186",
	"60231:60230:59186:66023",
	"60231:60230:59186:59732",
	"60231:60230:59186:59727",
	"60231:60230:59186:59735:59733",
	"60231:60230:59186:59735",
	"60231:60230:59186:59736",
	"60231:60230:59186:56737",
	"60231:60230",
	"60231:62658",
	"60231:61121",
	"63501:63498",
	"60231:60230:59186:64310",
	"63501:65511",
	"60231:61121:65865",
	--["name"] = "Sentinel Basecamp, Krasarang Wilds",
	["m"] = 418,
	["f"] = 0,
	["direct"] = "60231:58843:63501",
	["coord"] = 1079268840,
	},
	[61759] = {
	"60230:59186",
	"60230:60232:66023",
	"60230:59186:59732",
	"60230:59186:59727",
	"60230:59186:59735:59733",
	"60230:59186:59735",
	"60230:59186:59736",
	"60230:60232:66023:56737",
	"62658:60231",
	"60230:60232",
	"62658:60231:59049",
	"62658:60231:58843",
	"62658:60231:59048",
	"62658:60231:65189",
	"62658:60231:59049:60441",
	"62658:61121",
	"62658:60231:58843:63501",
	"62658:60231:58843:63501:63498",
	"60230:59186:64310",
	"62658:60231:58843:63501:65511",
	"62658:61121:65865",
	--["name"] = "Tavern in the Mists, The Veiled Stair",
	["direct"] = "60230:62658",
	["f"] = 0,
	["m"] = 433,
	["coord"] = 2430321062,
	},
	[65865] = {
	"61121:60230:59186",
	"61121:66023",
	"61121:60230:59186:59732",
	"61121:60230:59186:59727",
	"61121:60230:59186:59735:59733",
	"61121:60230:59186:59735",
	"61121:60230:59186:59736",
	"61121:66023:56737",
	"61121:60230",
	"61121:60231",
	"61121:60231:58843",
	"61121:62658",
	"61121:60230:59186:64310",
	--["name"] = "The Lion's Redoubt, Dread Wastes",
	["m"] = 424,
	["f"] = 0,
	["direct"] = "61121",
	["coord"] = 1814536081,
	},
	[62901] = {
	"62903:63500:63501:58843:60231:60230:59186",
	"62903:63500:63501:58843:60231:60232:66023",
	"62903:63500:63501:58843:60231:60230:59186:59732",
	"62903:63500:63501:58843:60231:60230:59186:59727",
	"62903:63500:63501:58843:60231:60230:59186:59735:59733",
	"62903:63500:63501:58843:60231:60230:59186:59735",
	"62903:63500:63501:58843:60231:60230:59186:59736",
	"62903:63500:63501:58843:60231:60232:66023:56737",
	"62903:63500:63501:58843:60231:60230",
	"62903:63500:63501:58843:60231",
	"62903:63500:63501:58843:60231:60232",
	"62903:63500:63501:58843:59049",
	"62903:63500:63501:58843",
	"62903:63500:63501:59048",
	"62903:63500:63501:59048:65189",
	"62903:63500:63501:59048:60441",
	"62903:63500:63501:58843:60231:62658:61759",
	"62903:63500:63501:58843:60231:62658",
	"62903:63500:61121",
	"62903:63500:63501",
	"62903:63500:63501:63498",
	"62903:63500",
	"62903:63500:63497",
	"62903:63500:63501:58843:60231:60230:59186:64310",
	"62903:63500:63501:65511",
	"62903:63500:61121:65865",
	--["name"] = "Longying Outpost, Townlong Steppes",
	["direct"] = "62903:62898",
	["f"] = 0,
	["m"] = 388,
	["coord"] = 3053294295,
	},
	[59186] = {
	--["name"] = "Dawn's Blossom, Jade Forest",
	["direct"] = "61121",
	["f"] = 0,
	["m"] = 371,
	["coord"] = 2020177479,
	},
	[62909] = {
	"62898:62903:63500:63501:58843:60231:60230:59186",
	"62898:62903:63500:63501:58843:60231:60232:66023",
	"62898:62903:63500:63501:58843:60231:60230:59186:59732",
	"62898:62903:63500:63501:58843:60231:60230:59186:59727",
	"62898:62903:63500:63501:58843:60231:60230:59186:59735:59733",
	"62898:62903:63500:63501:58843:60231:60230:59186:59735",
	"62898:62903:63500:63501:58843:60231:60230:59186:59736",
	"62898:62903:63500:63501:58843:60231:60232:66023:56737",
	"62898:62903:63500:63501:58843:60231:60230",
	"62898:62903:63500:63501:58843:60231",
	"62898:62903:63500:63501:58843:60231:60232",
	"62898:62903:63500:63501:58843:59049",
	"62898:62903:63500:63501:58843",
	"62898:62903:63500:63501:59048",
	"62898:62903:63500:63501:59048:65189",
	"62898:62903:63500:63501:59048:60441",
	"62898:62903:63500:63501:58843:60231:62658:61759",
	"62898:62903:63500:63501:58843:60231:62658",
	"62898:62901",
	"62898:62903",
	"62898:62903:63500:61121",
	"62898:62903:63500:63501",
	"62898:62903:63500:63501:63498",
	"62898:62903:63500",
	"62898:62903:63500:63497",
	"62898:62903:63500:63501:58843:60231:60230:59186:64310",
	"62898:62903:63500:63501:65511",
	"62898:62903:63500:61121:65865",
	--["name"] = "Shado-Pan Garrison, Townlong Steppes",
	["direct"] = "62898",
	["f"] = 0,
	["m"] = 388,
	["coord"] = 2149431390,
	},
	[56737] = {
	"66023:61121",
	--["name"] = "Pearlfin Village, Jade Forest",
	["m"] = 371,
	["f"] = 0,
	["direct"] = "59186:66023:64310",
	["coord"] = 2489373496,
	},
	[66023] = {
	"59186:64310",
	--["name"] = "Paw'Don Village, Jade Forest",
	["m"] = 371,
	["f"] = 0,
	["direct"] = "59186:61121",
	["coord"] = 1976424948,
	},
	[65189] = {
	"60231:60230:59186",
	"60231:60230:59186:66023",
	"60231:60230:59186:59732",
	"60231:60230:59186:59727",
	"60231:60230:59186:59735:59733",
	"60231:60230:59186:59735",
	"60231:60230:59186:59736",
	"60231:60230:59186:56737",
	"60231:60230",
	"60231:62658",
	"60231:61121",
	"59048:63501",
	"59048:63501:63498",
	"60231:60230:59186:64310",
	"59048:63501:65511",
	"60231:61121:65865",
	--["name"] = "Cradle of Chi-Ji, Krasarang Wilds",
	["m"] = 418,
	["f"] = 0,
	["direct"] = "60231:58843:59048",
	["coord"] = 1337958774,
	},
	[61474] = {
	"61759:60230:59186",
	"61759:60230:59186:59732",
	"61759:60230:59186:59727",
	"61759:60230:59186:59735:59733",
	"61759:60230:59186:59735",
	"61759:60230:59186:59736",
	"66023:56737",
	"61759:60230",
	"61759:62658:60231",
	"61759:62658:60231:59049",
	"61759:62658:60231:58843",
	"61759:62658:60231:59048",
	"61759:62658:60231:65189",
	"61759:62658:60231:59049:60441",
	"61121:63500:62903:61473",
	"61759:62658",
	"61121:63500:62903:62901",
	"61121:63500:62903",
	"61121:63500:62903:62898",
	"61121:63500:62903:62898:62909",
	"61759:62658:60231:58843:63501",
	"61121:63497:63498",
	"61121:63500",
	"61121:63497",
	"61759:60230:59186:64310",
	"61759:62658:60231:58843:63501:65511",
	"61121:65865",
	--["name"] = "Binan Village, Kun-Lai Summit",
	["direct"] = "66023:60232:61759:61121",
	["f"] = 0,
	["m"] = 379,
	["coord"] = 3115315451,
	},
	[62903] = {
	"63500:63501:58843:60231:60230:59186",
	"63500:63501:58843:60231:60232:66023",
	"63500:63501:58843:60231:60230:59186:59732",
	"63500:63501:58843:60231:60230:59186:59727",
	"63500:63501:58843:60231:60230:59186:59735:59733",
	"63500:63501:58843:60231:60230:59186:59735",
	"63500:63501:58843:60231:60230:59186:59736",
	"63500:63501:58843:60231:60232:66023:56737",
	"63500:63501:58843:60231:60230",
	"63500:63501:58843:60231",
	"63500:63501:58843:60231:60232",
	"63500:63501:58843:59049",
	"63500:63501:58843",
	"63500:63501:59048",
	"63500:63501:59048:65189",
	"63500:63501:59048:60441",
	"63500:63501:58843:60231:62658:61759",
	"63500:63501:58843:60231:62658",
	"63500:61121",
	"63500:63501",
	"63500:63501:63498",
	"63500:63497",
	"63500:63501:58843:60231:60230:59186:64310",
	"63500:63501:65511",
	"63500:61121:65865",
	--["name"] = "Gao-Ran Battlefront, Townlong Steppes",
	["direct"] = "63500",
	["f"] = 0,
	["m"] = 388,
	["coord"] = 3196702879,
	},
	[63498] = {
	"63501:58843:60231:60230:59186",
	"63501:61121:66023",
	"63501:58843:60231:60230:59186:59732",
	"63501:58843:60231:60230:59186:59727",
	"63501:58843:60231:60230:59186:59735:59733",
	"63501:58843:60231:60230:59186:59735",
	"63501:58843:60231:60230:59186:59736",
	"63501:58843:60231:60230:59186:56737",
	"63501:58843:60231:60230",
	"63501:58843:60231",
	"63501:58843",
	"63501:58843:60231:62658",
	"63501:61121",
	"63501:58843:60231:60230:59186:64310",
	"63501:61121:65865",
	--["name"] = "Soggy's Gamble, Dread Wastes",
	["m"] = 422,
	["f"] = 0,
	["direct"] = "63501:65511",
	["coord"] = 2410984350,
	},
	[63500] = {
	"63501:58843:60231:60230:59186",
	"63501:58843:60231:60232:66023",
	"63501:58843:60231:60230:59186:59732",
	"63501:58843:60231:60230:59186:59727",
	"63501:58843:60231:60230:59186:59735:59733",
	"63501:58843:60231:60230:59186:59735",
	"63501:58843:60231:60230:59186:59736",
	"63501:58843:60231:60232:66023:56737",
	"63501:58843:60231:60230",
	"63501:58843:60231",
	"63501:58843:60231:60232",
	"63501:58843:59049",
	"63501:58843",
	"63501:59048",
	"63501:59048:65189",
	"63501:59048:60441",
	"63501:58843:60231:62658:61759",
	"63501:58843:60231:62658",
	"63501:63498",
	"63501:58843:60231:60230:59186:64310",
	"63501:65511",
	"61121:65865",
	--["name"] = "The Sunset Brewgarden, Dread Wastes",
	["direct"] = "61121:63501:63497",
	["f"] = 0,
	["m"] = 422,
	["coord"] = 2157977395,
	},
	[61511] = {
	"61118:61474:61759:60230:59186",
	"61118:61474:66023",
	"61118:61474:61759:60230:59186:59732",
	"61118:61474:61759:60230:59186:59727",
	"61118:61474:61759:60230:59186:59735:59733",
	"61118:61474:61759:60230:59186:59735",
	"61118:61474:61759:60230:59186:59736",
	"61118:61474:66023:56737",
	"61118:61474:61759:60230",
	"61118:61474:61759:62658:60231",
	"61118:61474:60232",
	"61118:61474:61759:62658:60231:59049",
	"61118:61474:61759:62658:60231:58843",
	"61118:61474:61759:62658:60231:59048",
	"61118:61474:61759:62658:60231:65189",
	"61118:61474:61759:62658:60231:59049:60441",
	"61118:61474",
	"61118:61474:61121:63500:62903:61473",
	"61118:61474:61759",
	"61118:61474:61759:62658",
	"61118:61474:61121:63500:62903:62901",
	"61118:61474:61121:63500:62903",
	"61118:61474:61121:63500:62903:62898",
	"61118:61474:61121:63500:62903:62898:62909",
	"61118:61474:61121",
	"61118:61474:61759:62658:60231:58843:63501",
	"61118:61474:61121:63497:63498",
	"61118:61474:61121:63500",
	"61118:61474:61121:63497",
	"61118:61474:61759:60230:59186:64310",
	"61118:61474:61759:62658:60231:58843:63501:65511",
	"61118:61474:61121:65865",
	--["name"] = "Zouchin Village, Kun-Lai Summit",
	["direct"] = "61118:61504",
	["f"] = 0,
	["m"] = 379,
	["coord"] = 2680573261,
	},
	[59727] = {
	"66023:61121",
	"56737:64310",
	--["name"] = "Jade Temple Grounds, Jade Forest",
	["direct"] = "59186:66023:56737",
	["f"] = 0,
	["m"] = 371,
	["coord"] = 2343411249,
	},
	[60230] = {
	"59186:66023",
	"59186:59732",
	"59186:59727",
	"59186:59735:59733",
	"59186:59735",
	"59186:59736",
	"59186:56737",
	"59186:64310",
	--["name"] = "Pang's Stead, Valley of the Four Winds",
	["direct"] = "59186:61121",
	["f"] = 0,
	["m"] = 376,
	["coord"] = 3631887926,
	},
	[60232] = {
	"60230:59186",
	"60230:59186:59732",
	"66023:59727",
	"60230:59186:59735:59733",
	"60230:59186:59735",
	"60230:59186:59736",
	"66023:56737",
	"60231:59049",
	"60231:58843",
	"60231:59048",
	"60231:65189",
	"60231:59049:60441",
	"60230:62658",
	"60231:61121",
	"60231:58843:63501",
	"60231:58843:63501:63498",
	"66023:56737:64310",
	"60231:58843:63501:65511",
	"60231:61121:65865",
	--["name"] = "Zhu's Watch, Krasarang Wilds",
	["direct"] = "66023:60230:60231",
	["f"] = 0,
	["m"] = 418,
	["coord"] = 3295483243,
	},
	[61121] = {
	--["name"] = "Shrine of Seven Stars, Vale of Eternal Blossoms",
	["direct"] = "59186",
	["f"] = 0,
	["m"] = 390,
	["coord"] = 3634995084,
	},
	[61118] = {
	"61474:61759:60230:59186",
	"61474:66023",
	"61474:61759:60230:59186:59732",
	"61474:61759:60230:59186:59727",
	"61474:61759:60230:59186:59735:59733",
	"61474:61759:60230:59186:59735",
	"61474:61759:60230:59186:59736",
	"61474:66023:56737",
	"61474:61759:60230",
	"61474:61759:62658:60231",
	"61474:60232",
	"61474:61759:62658:60231:59049",
	"61474:61759:62658:60231:58843",
	"61474:61759:62658:60231:59048",
	"61474:61759:62658:60231:65189",
	"61474:61759:62658:60231:59049:60441",
	"61474:61121:63500:62903:61473",
	"61474:61759",
	"61474:61759:62658",
	"61474:61121:63500:62903:62901",
	"61474:61121:63500:62903",
	"61474:61121:63500:62903:62898",
	"61474:61121:63500:62903:62898:62909",
	"61474:61121",
	"61474:61759:62658:60231:58843:63501",
	"61474:61121:63497:63498",
	"61474:61121:63500",
	"61474:61121:63497",
	"61474:61759:60230:59186:64310",
	"61474:61759:62658:60231:58843:63501:65511",
	"61474:61121:65865",
	--["name"] = "Temple of the White Tiger, Kun-Lai Summit",
	["direct"] = "61474:61504",
	["f"] = 0,
	["m"] = 379,
	["coord"] = 2848424441,
	},
	[62898] = {
	"62903:63500:63501:58843:60231:60230:59186",
	"62903:63500:63501:58843:60231:60232:66023",
	"62903:63500:63501:58843:60231:60230:59186:59732",
	"62903:63500:63501:58843:60231:60230:59186:59727",
	"62903:63500:63501:58843:60231:60230:59186:59735:59733",
	"62903:63500:63501:58843:60231:60230:59186:59735",
	"62903:63500:63501:58843:60231:60230:59186:59736",
	"62903:63500:63501:58843:60231:60232:66023:56737",
	"62903:63500:63501:58843:60231:60230",
	"62903:63500:63501:58843:60231",
	"62903:63500:63501:58843:60231:60232",
	"62903:63500:63501:58843:59049",
	"62903:63500:63501:58843",
	"62903:63500:63501:59048",
	"62903:63500:63501:59048:65189",
	"62903:63500:63501:59048:60441",
	"62903:63500:63501:58843:60231:62658:61759",
	"62903:63500:63501:58843:60231:62658",
	"62903:63500:61121",
	"62903:63500:63501",
	"62903:63500:63501:63498",
	"62903:63500",
	"62903:63500:63497",
	"62903:63500:63501:58843:60231:60230:59186:64310",
	"62903:63500:63501:65511",
	"62903:63500:61121:65865",
	--["name"] = "Rensai's Watchpost, Townlong Steppes",
	["direct"] = "62903",
	["f"] = 0,
	["m"] = 388,
	["coord"] = 2333461070,
	},
	[59736] = {
	"59186:66023",
	"59186:59732",
	"59186:59727",
	"59735:59733",
	"59186:56737",
	"59186:61121",
	"59186:64310",
	--["name"] = "Tian Monastery, Jade Forest",
	["direct"] = "59186:59735",
	["f"] = 0,
	["m"] = 371,
	["coord"] = 1870347949,
	},
	[59732] = {
	"59727:66023",
	"59727:56737",
	"59186:61121",
	"59186:64310",
	--["name"] = "The Arboretum, Jade Forest",
	["m"] = 371,
	["f"] = 0,
	["direct"] = "59186:59727",
	["coord"] = 2448453840,
	},
	[61504] = {
	"61474:61759:60230:59186",
	"61474:66023",
	"61474:61759:60230:59186:59732",
	"61474:61759:60230:59186:59727",
	"61474:61759:60230:59186:59735:59733",
	"61474:61759:60230:59186:59735",
	"61474:61759:60230:59186:59736",
	"61474:66023:56737",
	"61474:61759:60230",
	"61474:61759:62658:60231",
	"61474:60232",
	"61474:61759:62658:60231:59049",
	"61474:61759:62658:60231:58843",
	"61474:61759:62658:60231:59048",
	"61474:61759:62658:60231:65189",
	"61474:61759:62658:60231:59049:60441",
	"61474:61121:63500:62903:61473",
	"61474:61759",
	"61474:61759:62658",
	"61474:61121:63500:62903:62901",
	"61474:61121:63500:62903",
	"61474:61121:63500:62903:62898",
	"61474:61121:63500:62903:62898:62909",
	"61474:61121",
	"61474:61759:62658:60231:58843:63501",
	"61474:61121:63497:63498",
	"61474:61121:63500",
	"61474:61121:63497",
	"61474:61759:60230:59186:64310",
	"61474:61759:62658:60231:58843:63501:65511",
	"61474:61121:65865",
	--["name"] = "One Keg, Kun-Lai Summit",
	["direct"] = "61474",
	["f"] = 0,
	["m"] = 379,
	["coord"] = 2479921382,
	},
	[59049] = {
	"60231:60230:59186",
	"60231:60230:59186:66023",
	"60231:60230:59186:59732",
	"60231:60230:59186:59727",
	"60231:60230:59186:59735:59733",
	"60231:60230:59186:59735",
	"60231:60230:59186:59736",
	"60231:60230:59186:56737",
	"60231:60230",
	"60231:62658",
	"60231:61121",
	"59048:63501",
	"59048:63501:63498",
	"60231:60230:59186:64310",
	"59048:63501:65511",
	"60231:61121:65865",
	--["name"] = "The Incursion, Krasarang Wilds",
	["m"] = 418,
	["f"] = 0,
	["direct"] = "60231:58843:59048:65189:60441",
	["coord"] = 2909033241,
	},
	[61512] = {
	"63497:61121:60230:59186",
	"63497:61121:66023",
	"63497:61121:60230:59186:59732",
	"63497:61121:60230:59186:59727",
	"63497:61121:60230:59186:59735:59733",
	"63497:61121:60230:59186:59735",
	"63497:61121:60230:59186:59736",
	"63497:61121:66023:56737",
	"63497:61121:60230",
	"62901:62903:63500:63501:58843:60231",
	"62901:62903:63500:63501:58843:60231:60232",
	"62901:62903:63500:63501:58843:59049",
	"62901:62903:63500:63501:58843",
	"62901:62903:63500:63501:59048",
	"62901:62903:63500:63501:59048:65189",
	"62901:62903:63500:63501:59048:60441",
	"63497:61121:61474",
	"63497:61121:61474:61118",
	"63497:61121:61474:61118:61511",
	"63497:61121:61474:61504",
	"62901:61473",
	"63497:61121:62658:61759",
	"63497:61121:62658",
	"62901:62903",
	"62901:62898",
	"62901:62898:62909",
	"63497:61121",
	"62901:62903:63500:63501",
	"63497:63498",
	"62901:62903:63500",
	"63497:61121:60230:59186:64310",
	"62901:62903:63500:63501:65511",
	"63497:61121:65865",
	["direct"] = "62901:63497",
	["f"] = 0,
	["m"] = 379,
	["coord"] = 1484167001,
	},
	},
	[1467] = {
		[22485] = {
		"18788:18785:16822",
		"18788:18785",
		"18788:18789",
		"18788:18940:18809",
		"18937:18938",
		"18788:18940:18809:18939",
		"18788:18940",
		"18788:18785:16822:18931",
		"18937:19583",
		"18937:18938:20515",
		"18937:21107",
		"18937:22216",
		--["name"] = "Orebor Harborage, Zangarmarsh",
		["m"] = 102,
		["coord"] = 1773488635,
		["direct"] = "18788:18937",
		["f"] = 0,
		},
		[18938] = {
		"21107:18788:18785:16822",
		"21107:18788:18785",
		"21107:18788",
		"21107:18788:18789",
		"21107:18788:18940:18809",
		"21107:18788:18940:18809:18939",
		"21107:18788:18940",
		"21107:18788:18785:16822:18931",
		"18937:22485",
		--["name"] = "Area 52, Netherstorm",
		["m"] = 109,
		["coord"] = 1450877870,
		["direct"] = "18937:19583:20515:21107:22216",
		["f"] = 0,
		},
		[19583] = {
		"18938:21107:18788:18785:16822",
		"18938:21107:18788:18785",
		"18938:21107:18788",
		"18938:21107:18788:18789",
		"18938:21107:18788:18940:18809",
		"18938:21107:18788:18940:18809:18939",
		"18938:21107:18788:18940",
		"18938:21107:18788:18785:16822:18931",
		"18938:21107",
		"18938:22216",
		"18937:22485",
		--["name"] = "The Stormspire, Netherstorm",
		["m"] = 109,
		["coord"] = 1944213875,
		["direct"] = "18938:18937:20515",
		["f"] = 0,
		},
		[18937] = {
		"18788:18785:16822",
		"18788:18785",
		"18788:18789",
		"18788:18940:18809",
		"18788:18940:18809:18939",
		"18788:18940",
		"18788:18785:16822:18931",
		"18938:20515",
		--["name"] = "Sylvanaar, Blade's Edge Mountains",
		["direct"] = "18788:18938:19583:21107:22216:22485",
		["coord"] = 1624022391,
		["m"] = 105,
		["f"] = 0,
		},
		[18931] = {
		"18785:18788",
		"16822:18940:18789",
		"16822:18809",
		"18785:18788:21107:18938",
		"16822:18809:18939",
		"18785:18788:18937",
		"16822:18940",
		"18785:18788:21107:18938:19583",
		"18785:18788:21107:18938:20515",
		"18785:18788:21107",
		"18785:18788:21107:22216",
		"18785:18788:22485",
		--["name"] = "Hellfire Peninsula, The Dark Portal",
		["m"] = 100,
		["f"] = 0,
		["direct"] = "16822:18785",
		["coord"] = 3755312742,
		},
		[18785] = {
		"18788:18789",
		"16822:18809",
		"18788:21107:18938",
		"16822:18809:18939",
		"18788:18937",
		"18788:18940",
		"16822:18931",
		"18788:21107:18938:19583",
		"18788:21107:18938:20515",
		"18788:21107",
		"18788:21107:22216",
		"18788:22485",
		--["name"] = "Temple of Telhamat, Hellfire Peninsula",
		["m"] = 100,
		["f"] = 0,
		["direct"] = "16822:18788",
		["coord"] = 1079402317,
		},
		[18939] = {
		"18809:16822",
		"18809:16822:18785",
		"18809:18940:18788",
		"18809:18789",
		"18809:18940:18788:21107:18938",
		"18809:18940:18788:18937",
		"18809:18940",
		"18809:16822:18931",
		"18809:18940:18788:21107:18938:19583",
		"18809:18940:18788:21107:18938:20515",
		"18809:18940:18788:21107",
		"18809:18940:18788:21107:22216",
		"18809:18940:18788:22485",
		["direct"] = "18809",
		["coord"] = 1612942864,
		["m"] = 104,
		["f"] = 0,
		},
		[18789] = {
		"18940:16822",
		"18788:18785",
		"18788:21107:18938",
		"18809:18939",
		"18788:18937",
		"18940:16822:18931",
		"18788:21107:18938:19583",
		"18788:21107:18938:20515",
		"18788:21107",
		"18788:21107:22216",
		"18788:22485",
		--["name"] = "Telaar, Nagrand",
		["m"] = 107,
		["coord"] = 2326118486,
		["direct"] = "18788:18809:18940",
		["f"] = 0,
		},
		[21107] = {
		"18788:18785:16822",
		"18788:18785",
		"18788:18789",
		"18788:18940:18809",
		"18788:18940:18809:18939",
		"18788:18940",
		"18788:18785:16822:18931",
		"18938:19583",
		"18938:20515",
		"18937:22485",
		--["name"] = "Toshley's Station, Blade's Edge Mountains",
		["m"] = 105,
		["coord"] = 2623648912,
		["direct"] = "18788:18938:18937:22216",
		["f"] = 0,
		},
		[18940] = {
		"18788:18785",
		"18788:21107:18938",
		"18809:18939",
		"18788:18937",
		"16822:18931",
		"18788:21107:18938:19583",
		"18788:21107:18938:20515",
		"18788:21107",
		"18788:21107:22216",
		"18788:22485",
		--["name"] = "Shattrath, Terokkar Forest",
		["m"] = 111,
		["coord"] = 2749327666,
		["direct"] = "16822:18788:18789:18809",
		["f"] = 0,
		},
		[20515] = {
		"18938:21107:18788:18785:16822",
		"18938:21107:18788:18785",
		"18938:21107:18788",
		"18938:21107:18788:18789",
		"18938:21107:18788:18940:18809",
		"18938:21107:18788:18940:18809:18939",
		"18938:18937",
		"18938:21107:18788:18940",
		"18938:21107:18788:18785:16822:18931",
		"18938:21107",
		"18938:22216",
		"18938:18937:22485",
		--["name"] = "Cosmowrench, Netherstorm",
		["m"] = 109,
		["coord"] = 2800528103,
		["direct"] = "18938:19583",
		["f"] = 0,
		},
		[18809] = {
		"16822:18785",
		"18940:18788",
		"18940:18788:21107:18938",
		"18940:18788:18937",
		"16822:18931",
		"18940:18788:21107:18938:19583",
		"18940:18788:21107:18938:20515",
		"18940:18788:21107",
		"18940:18788:21107:22216",
		"18940:18788:22485",
		--["name"] = "Allerian Stronghold, Terokkar Forest",
		["m"] = 108,
		["coord"] = 2553384368,
		["direct"] = "16822:18789:18939:18940",
		["f"] = 0,
		},
		[22216] = {
		"21107:18788:18785:16822",
		"21107:18788:18785",
		"21107:18788",
		"21107:18788:18789",
		"21107:18788:18940:18809",
		"21107:18788:18940:18809:18939",
		"21107:18788:18940",
		"21107:18788:18785:16822:18931",
		"18938:19583",
		"18938:20515",
		"18937:22485",
		--["name"] = "Evergrove, Blade's Edge Mountains",
		["m"] = 105,
		["coord"] = 2648008034,
		["direct"] = "18938:18937:21107",
		["f"] = 0,
		},
		[16822] = {
		"18785:18788",
		"18940:18789",
		"18785:18788:21107:18938",
		"18809:18939",
		"18785:18788:18937",
		"18785:18788:21107:18938:19583",
		"18785:18788:21107:18938:20515",
		"18785:18788:21107",
		"18785:18788:21107:22216",
		"18785:18788:22485",
		--["name"] = "Honor Hold, Hellfire Peninsula",
		["m"] = 100,
		["f"] = 0,
		["direct"] = "18785:18809:18940:18931",
		["coord"] = 2347147191,
		},
		[18788] = {
		"18785:16822",
		"18940:18809",
		"21107:18938",
		"18940:18809:18939",
		"18785:16822:18931",
		"21107:18938:19583",
		"21107:18938:20515",
		"21107:22216",
		--["name"] = "Telredor, Zangarmarsh",
		["direct"] = "18785:18789:18937:18940:21107:22485",
		["f"] = 0,
		["m"] = 102,
		["coord"] = 2914419579,
		},
		},
	}
}
		end
		local faction = UnitFactionGroup("player")
      
        --Checking for dynamic flight nodes

        --Saving original subtable for Argus (9) for further use.
        TaxiData.copies = TaxiData.copies or {}
        TaxiData.copies[faction] = TaxiData.copies[faction] or {}
        TaxiData.copies[faction][9] = TaxiData.copies[faction][9] or LuaUtils:clone(fullData[faction][9])
        
        --Restoring original table
        fullData[faction][9] = LuaUtils:clone(TaxiData.copies[faction][9])
        
        local result = fullData[faction]
        
        --Checking for mode
        if TaxiData.currentBeaconMode == "veiled-den" then
            result[9][125410] = nil
        end
        
        if TaxiData.currentBeaconMode == "lights-purchase" then
            result[9][125409] = nil
        end
        
		return result
	end

	TaxiData.NonZeroOpenWorldFloors = {
		[125] = 1,
		[85] = 1
	}
	TaxiData.ZoneTransData ={
		[1] = {
			[103] = {
				[97] = 3433929949,
			},
			[97] = {
				[106] = 1795621192,
				[103] = 1489008043,
				[468] = 2844428923,
			},
			[1] = {
				[10] = 1470197635,
				[85] = 1958355245,
				[463] = 2660224514,
				[461] = 2133634463,
				[5] = "54.9,9.5-5::83.2,53.6", -- Skull Rock
				[3] = "59.0,58.3-3::32.0,51.8", -- Tiragarde Keep
				[6] = "52.8,28.6-6::50.3,90.5", -- Dustwind Cave
				[2] = "45.4,56.1-2::72.4,89.4", -- Burning Blade Coven
			},		
			[5] = { 
				[1] = "83.2,53.6-1::54.9,9.5",
			},
			[3] = { 
				[1] = "32.0,51.8-1::59.0,58.3",
				[4] = "41.9,30.9-4::32.4,30.3", -- Great Hall
			},			
			[4] = { 
				[3] = "32.4,30.3-3::41.9,30.9", -- Tiragarde Keep
			},
			[6] = { 
				[1] = "50.3,90.5-1::52.8,28.6",
			},			
			[64] = {
				[69] = 406263579,
				[71] = 3243834296,
				[70] = 3050468349,
			},
			[10] = {
				[63] = 1845697429,
				[85] = 3159950357,
				[1] = 2970904252,
				[11] = "38.9,69.2-11::22.5,88.6", -- Wailing Caverns Cave Entrance
			},
			[11] = {
				[10] = "22.5,88.6-11::38.9,69.2",
			},
			[77] = {
				[63] = 2331042556,
				[80] = 2847019394,
				[83] = 2724926957,
			},
			[88] = {
				[7] = 2105215084,
			},
			[7] = {
				[88] = 1733059236,
				[199] = 3009779660,
				[462] = 1931589573,
				[8] = "34.8,61.3-8::76.9,56.3", -- Palemane Rock
				[9] = "60.8,47.4-9::39.6,90.7|59.3,36.6-9::30.4,14.6|59.2,44.0-9::28.6,65.2", -- The Venture Co. Mine
			},
			[8] = {
				[7] = "76.9,56.3-7::34.8,61.3",
			},
			[9] = {
				[7] = "39.6,90.7-7::60.8,47.4|30.4,14.6-7::59.3,36.6|28.6,65.2-7::59.2,44.0",
			},			
			[76] = {
				[63] = 381269507,
				[85] = 1149093758,
			},
			[66] = {
				[65] = 2319717125,
				[69] = 1870330894,
				[67]  = "28.9,62.6-67::24.6,43.5", -- Wicked Grotto **Only Way to Get To Felspore Cavern**
			},
			[67] = {
				[68] = "29.5,62.5-68::47.4,88.1|27.7,33.7-68::45.5,78.2", -- Felspore Cavern
				[66] = "24.6,43.5-66::28.9,62.6"
			},
			[68] = {
				[67] = "29.5,62.5-67::27.7,33.7|27.7,33.7-67::29.5,62.5",
			},			
			[69] = {
				[66] = 1956579161,
				[64] = 3887818503,
			},
			[198] = {
				[83] = 3704448369,
			},
			[80] = {
				[77] = 1562050176,
				[83] = 1257957714,
			},
			[199] = {				
				[7] = 1721598701,
				[65] = 1294080134,
				[70] = 2346437017,
			},
			[57] = {
				[89] = 1664252166,
				[460] = 2593026176,
				[60] = "45.6,50.6-60::52.6,15.5", -- Banethil Barrow Den (Upper Den)
				[59] = "54.5,46.3-59::77.6,81.7", -- Fel Rock				
			},
			[59] = {
				[57] = "77.6,81.7-57::54.5,46.3",
			},
			[60] = {
				[57] = "52.6,15.5-57::45.6,50.6",
				[60] = "52.6,15.5-60::45.6,50.6",
				[61] = "24.6,86.0-61::29.9,76.4|54.2,36.5-61::46.7,39.7", -- Banethil Barrow Den (Lower Den)
			},
			[61] = {
				[60] = "29.9,76.4-60::24.6,86.0|46.7,39.7-60::54.2,36.5",
			},
			[62] = {
				[63] = 1812196334,
			},
			[63] = {
				[77] = 2377663454,
				[10] = 2954680867,
				[76] = 4142825201,
				[62] = 1050876964,
				[65] = 1589169969,
			},
			[460] = {
				[57] = 2379214874,
				[58] = "39.3,30.4-58::45.4,90.3", -- Shadowthread Cave
			},
			[58] = { 
				[460] = "45.4,90.3-460::39.3,30.4", -- Shadowthread Cave
			},
			[70] = {
				[199] = 1405712634,
				[64] = 2113466014,
			},
			[461] = {
				[1] = 3014370725,
				[2] = "53.0,21.3-2::72.2,89.7", -- Burning Blade Coven
			},
			[2] = {
				[461] = "72.2,89.7-461::53.0,21.3",
				[1] = "72.4,89.4-1::45.4,56.1",
			},
			[106] = {
				[97] = 2800021803,
			},
			[462] = {
				[7] = 1167338360,
			},
			[249] = {
				[71] = 2967485327,
			},
			[463] = {
				[1] = 1773300482,
				[464] = "59.3,21.8-464::53.9,80.5",
			},
			[464] = {
				[463] = "53.9,80.5-463::59.3,21.8",
			},
			[71] = {
				[78] = 1196131805,
				[249] = 1057205090,
				[64] = 2199730562,
				[72] = "35.3,42.6-72::55.9,36.4|34.8,41.6-72::50.4,25.1|34.5,42.4-72::47.5,33.6", -- The Noxious Lair
				[73] = "54.5,69.8-73::42.2,39.4|55.5,68.2-73::51.5,24.3", -- The Gaping Chasm		
				[74] = "64.76,49.98-74::52.94,29.33", -- Timeless Tunnel / Caverns of Time			
			},
			[72] = {
				[71] = "55.9,36.4-71::35.3,42.6|50.4,25.1-71::34.8,41.6|47.5,33.6-71::34.5,42.4",
			},
			[73] = {
				[71] = "42.2,39.4-71::54.5,69.8|51.5,24.3-71::55.5,68.2",
			},
			[74] = {
				[71] = "52.94,29.33-71::64.76,49.98",
				[75] = "34.18,75.00-75::61.10,53.32",
			},	
			[75] = {
				[74] = "61.10,53.32-74::34.18,75.00",
			},		
			[78] = {
				[81] = 1213602709,
				[71] = 3023237278,
			},
			[83] = {
				[77] = 738031305,
				[80] = 744254074,
				[198] = 2513823810,
			},			
			[85] = {
				[10] = 1060613085,
				[1] = 2142499060,
				[76] = 3309962086,
				[86] = "42.05,61.21-86::24.30,72.48|46.20,66.98-86::35.26,91.81|55.57,51.30-86::78.31,16.39"	
			},
			[86] ={
				[85] = "24.30,72.48-85::42.05,61.21|35.26,91.81-85::46.20,66.98|78.31,16.39-85::55.57,51.30"	
			},
			[81] = {
				[78] = 3699253762,
				[82] = "70.4,15.9-82::15.1,70.0",
			},
			[82] = {
				[81] = "15.1,70.0-81::70.4,15.9",
			},
			[468] = {
				[97] = 900696814,
			},
			[65] = {
				[63] = 3156244453,
				[66] = 1526582946,
				[199] = 3479170838,
			},
			[89] = {
				[57] = 3427234998,
			},
			[131] = {
				[130] = "47.47,32.24-130::50.63,92.88", 
			},
			[130] = {
				[131] = "50.63,92.88-131::47.47,32.24", 
			},
			[297] = {
				[298] = "89.7,49.8-298::24.9,49.4|67.5,52.6-298::66.7,48.5", 
				[299] = "66.5,48.3-299::45.9,47.6", 
			},
			[298] = {
				[297] = "24.9,49.4-297::89.7,49.8|66.7,48.5-297::67.5,52.6", 
			},
			[299] = {
				[297] = "45.9,47.6-297::66.5,48.3", 
			},
			[236] = {
				[237] = "39.22,34.98-237::56.27,24.42",
				[237] = "31.69,72.04-237::48.30,74.24",
				[237] = "20.79,19.09-237::44.12,13.38",
				[238] = "29.47,42.67-238::75.94,39.95",
			},
			[237] = {
				[236] = "56.27,24.42-236::39.22,34.98",
				[236] = "48.30,74.24-236::31.69,72.04",
				[236] = "44.12,13.38-236::20.79,19.09",
			},			
			[238] = {			
				[236] = "75.94,39.95-236::29.47,42.67",
			},
			[239] = {
				[240] = "46.43,63.58-240::61.27,82.67", 
			},
			[240] = {
				[239] = "61.27,82.67-239::46.43,63.58", 
			},
			[221] = {
				[222] = "61.51,71.88-222::39.21,31.65", 
			},
			[222] = {
				[221] = "39.21,31.65-221::61.51,71.88", 
				[223] = "47.24,79.12-223::43.60,61.06", 
			},
			[223] = {
				[222] = "43.60,61.06-222::47.24,79.12", 
			},
			[280] = {
				[281] = "15.53,56.75-281::28.99,4.84", 
			},
			[281] = {
				[280] = "28.99,4.84-280::15.53,56.75", 
			},			
		}, -- [1]
		[2] = {
			[27] = {
				[87] = 2527877552,
				[469] = 2130605098,
				[48] = "3840901933|3978316396",
				[427] = 1810672610,
				[29] = "48.9,52.6-29::60.8,92.0",  -- Grizzled Den
				[28] = "42.7,64.1-28::60.6,11.0|41.1,70.0-28::38.0,91.1",  -- Coldridge Pass
			},
			[29] = { 
				[27] = "60.8,92.0-27::48.9,52.6",  -- Grizzled Den
			},
			[28] = {
				[27] = "60.6,11.0-27::42.7,64.1|38.0,91.1-27::41.1,70.0",  -- Coldridge Pass
			},			
			[30] = { 
				[469] = "79.5,84.2-469::32.6,37.0", --Gnome Starter
			},
			[241] = {
				[56] = 1168925923,
			},
			[51] = {
				[17] = 1545318364,
				[42] = 543985368,
				[36] = 2862222456,
			},
			[467] = {
				[94] = 2987642217,
			},
			[469] = {
				[27] = 3478884470,
				[470] = "33.3,66.4-470::94.6,58.1", -- Frostmane Hold
				[30] = "32.6,37.0-30::79.5,84.2", --Gnome Starter
			},
			[470] = {
				[469] = "94.6,58.1-469::33.3,66.4", -- Frostmane Hold
			},
			[244] = {
				[245] = 1768041979,
			},
			[52] = {
				[37] = 2659068836,
				[47] = 2940772449,
				[55] = "43.8,73.4-55::69.3,23.7:downstairs",
				[54] = "44.5,24.7-54::41.1,94.1",
			},
			[55] = {
				[52] = "69.3,23.7-52::43.8,73.4:upstairs"
			},
			[54] = {
				[52] = "41.1,94.1-52::44.5,24.7"
			},			
			[84] = {
				[37] = 3161450937,
			},
			[14] = {
				[56] = 1693579510,
				[25] = 562777441,
			},
			[18] = {
				[21] = 2331622734,
				[22] = 3910974364,
				[90] = 2671814662,
				[465] = 1601212705,
				[19] = "82.6,33.5-19::17.3,82.9|82.3,32.6-19::14.5,73.1", -- Scarlet Monastery Entrance
				[18] = "15.41,56.13",
			},
			[18] = {
				[18] = "37.16,6.98",
			},			
			[19] = {
				[18] = "17.3,82.9-18::82.6,33.5|14.5,73.1-18::82.3,32.6", -- Scarlet Monastery Entrance
			},
			[25] = {
				[21] = 1337762526,
				[22] = 2934649478,
				[26] = 3104147899,
				[14] = 3032070019,
			},
			[32] = {
				[48] = 4054845869,
				[36] = 1476521034,
				[15] = 3529215275,
			},
			[33] =  {
				[36] = "34.8,85.6-36::46.47,18.25", -- Blackrock Spire north entrance
				[35] = "46.8,50.8-35::58.2,88.5", -- Blackrock Depths chain again - silly two-zone clone dungeon
			},
			[35] = { 
				[36] = "40.2,57.9-36::46.2,62.9",
				[33] = "58.2,88.5-33::46.8,50.8", -- Blackrock Depths chain again - silly two-zone clone dungeon
			},			
			[42] = {
				[51] = 2689686655,
				[47] = 1163549248,
			},
			[56] = {
				[14] = 2189891355,
				[48] = 2400379773,
				[241] = 3616833899,
			},
			[210] = {
				[50] = 2685678982,
			},
			[425] = {
				[37] = 1092537854,
			},
			[427] = {
				[27] = 4036248582,
				[428] = "52.0,84.6-428::12.8,36.8", -- Frostmane Hovel
			},
			[428] = {
				[427] = "12.8,36.8-427::52.0,84.6", -- Frostmane Hovel
			},
			[90] = {
				[18] = 2913666833,
			},
			[21] = {
				[18] = 2934637875,
				[25] = 3185036675,
			},
			[36] = {
				[49] = 2859589483,
				[51] = 3630552257,
				[32] = 852114287,
				[36] = "21.0,38.0-36::49.50,88.66", -- Blackrock Spire south entrance
			},
			[36] = {
				[36] = "72.0,43.2-36::60.5,27.8|66.8,60.7-36::41.7,79.6", -- Blackrock Caverns foyer
				[36] = "46.8,50.8-36::58.2,88.5", -- Blackrock Depths chain
				[33] = "46.47,18.25-33::34.8,85.6", -- Blackrock Spire north entrance
			},
			[36] = {
				[36] = "60.5,27.8-36::72.0,43.2|41.7,79.6-36::66.8,60.7", -- Blackrock Caverns foyer
			},
			[36] = {
				[36] = "58.2,88.5-36::46.8,50.8", -- Blackrock Depths chain
				[35] = "46.2,62.9-35::40.2,57.9",
			},
			[47] = {
				[50] = 1943786361,
				[49] = 4083356780,
				[42] = 3728566501,
				[37] = 4047378737,
				[52] = 339059421,
			},
			[465] = {
				[18] = 3150262706,
				[466] = "29.7,30.7-466::87.3,52.0", -- Night's Web Hollow
			},
			[466] = {
				[465] = "87.3,52.0-465::29.7,30.7", -- Night's Web Hollow
			},
			[468] = {
				[97] = 1219726622,
			},
			[245] = {
				[244] = 2878338652,
			},
			[48] = {
				[56] = 1100943173,
				[32] = 678422584,
				[27] = "387554517|631584798",
			},
			[94] = {
				[467] = 1751864058,
				[110] = 2427748285,
				[95] = 2085874872,
			},
			[95] = {
				[94] = 2077236833,
				[96] = "66.4,28.5-96::94.0,35.6|58.3,27.5-96::10.0,26.0", -- Amani Catacombs
			},
			[96] = {
				[94] = "94.0,35.6-95::66.4,28.5",
				[94] = "10.0,26.0-95::58.3,27.5",		
			},			
			[37] = {
				[425] = 1972928331,
				[52] = 848547206,
				[84] = 1576634545,
				[49] = 4202739599,
				[47] = 4017346597,
				[40] = "61.7,53.7-40::48.9,90.1", --Jaspermind
				[38] = "38.9,82.3-38::39.9,88.0", --Fargomine
				[39] = "38.5,81.5-39::35.2,68.4", --Fargomine Lower				
			},
			[38] = { 
				[39] = "55.4,36.3-39::56.3,26.0", --Fargomine Lower
				[37] = "39.9,88.0-37::38.9,82.3", --Fargomine
			},
			[40] = { 
				[37] = "48.9,90.1-37::61.7,53.7", --Fargomine Lower			
			},
			[39] = { 
				[37] = "35.2,68.4-37::38.5,81.5", --Fargomine Lower			
			},
			[49] = {
				[37] = 638231076,
				[36] = 1812475232,
				[47] = 395627354,
			},
			[87] = {
				[27] = 171899504,
			},
			[22] = {
				[25] = 1886904705,
				[23] = 3097395133,
				[18] = 1496292123,
				[26] = 2812599147,
			},
			[205] = {
				[201] = 2640525056,
			},
			[97] = {
				[106] = 1795687940,
				[103] = 1591899449,
				[468] = 21556250390,
				[98] = "26.9,76.3-98::59.5,88.1", -- Tides' Hollow
				[99] = "45.3,19.4-99::21.2,94.6", -- Stillpine Hold				
			},
			[98] = { 
				[97] = "59.5,88.1-97::26.9,76.3", -- Tides' Hollow
			},
			[99] = { 
				[97] = "21.2,94.6-97::45.3,19.4", -- Stillpine Hold	
			},			
			[103] = {
				[97] = 3830487849,
			},
			[26] = {
				[25] = 99658880,
				[22] = 919484303,
			},
			[50] = {
				[47] = 2233733506,
				[210] = 2202845188,
			},
			[15] = {
				[32] = 355632487,
				[16] = "41.6,11.6-16::75.6,36.5", --Uldaman Entrance
			},
			[16] = {
				[15] = "75.6,36.5-15::41.6,11.6", --Uldaman Entrance
			},
			[201] = {
				[205] = 2101920817,
			},
			[106] = {
				[97] = 2800154388,
			},
			[17] = {
				[51] = 2099055262,
			},
			[23] = {
				[22] = 422815847,
				[24] = "75.67,52.26",
			},
			[24] = {
				[23] = "36.2,97.23",
				--requirements = "cls:PALADIN",
			},
			[110] = {
				[94] = 3086544408,
			},
			[250] = {
				[252] = "66.1,51.1-252::66.0,49.2|56.7,48.3-252::58.4,47.7",
				[251] = "59.8,70.2-251::64.8,70.9|59.4,63.9-251::59.5,59.3",
			},
			[251] = {
				[250] = "64.8,70.9-250::59.8,70.2|59.5,59.3-250::59.4,63.9",
				[252] = "53.2,52.8-252::57.0,51.2|51.1,74.2-252::49.9,74.1",
			},
			[252] = {
				[250] = "58.4,47.7-250::56.7,48.3|66.0,49.2-250::66.1,51.1",
				[251] = "49.9,74.1-251::51.1,74.2|57.0,51.2-251::53.2,52.8",
				[253] = "46.5,65.8-253::45.1,59.5|55.1,37.6-253::47.2,42.7",
			},
			[253] = {
				[252] = "47.2,42.7-252::55.1,37.6|45.1,59.5-252::46.5,65.8",
				[254] = "37.2,34.2-254::37.1,32.1",
			},
			[254] = {
				[253] = "37.1,32.1-253::37.2,34.2",
				[255] = "33.3,13.3-255::30.4,18.7",
			},
			[255] = {
				[254] = "30.4,18.7-254::33.3,13.3",
				[250] = "29.0,41.4-250::28.4,36.1",
			},
			[250] = {
				[255] = "28.4,36.1-255::29.0,41.4|30.7,42.7-255::30.6,41.6|36.4,43.3-255::36.1,41.3", --cliff
			},
			[226] = {
				[227] = "57.67,50.98-227::81.36,46.02|47.05,86.94-227::75.38,74.06|34.33,61.78-227::61.73,61.55",
			},
			[227] = {
				[226] = "75.38,74.06-226::47.05,86.94|61.73,61.55-226::34.33,61.78",			
				[228] = "35.21,88.08-228::38.60,50.33",
			},
			[228] = {
				[227] = "38.60,50.33-227::35.21,88.08",
				[229] = "48.26,71.95-229::71.25,77.54",			
			},
			[229] = {
				[228] = "71.25,77.54-228::48.26,71.95",			
			},
			[431] = {
				[432] = "55.5,13.8-432::47.8,91.1",			
			},
			[432] = {
				[431] = "47.8,91.1-431::55.5,13.8",			
			},
			[435] = {
				[436] = "48.4,88.5-436::49.1,11.2",			
			},
			[436] = {
				[435] = "49.1,11.2-435::48.4,88.5",			
			},
			[476] = {
				[477] = "81.8,23.9-477::76.0,26.5",
			},
			[477] = {				
				[476] = "76.0,26.5-476::81.8,23.9",
				[478] = "57.5,92.2-478::49.7,19.2",
			},
			[478] = {				
				[477] = "49.7,19.2-477::57.5,92.2",
				[479] = "49.8,24.0-479::49.6,28.2",
			},
			[479] = {
				[478] = "49.6,28.2-478::49.8,24.0",
			},
			[310] = {			
				[311] = "14.78,88.35-311::27.49,87.84",
				[316] = "34.01,70.58-316::23.69,75.12",
			},
			[311] = {			
				[310] = "60.03,13.01-310::38.18,39.14|27.49,87.84-310::14.78,88.35",
			},			
			[316] = {			
				[312] = "45.49,25.23-312::44.44,61.70",
			},
			[312] = {	
				[316] = "60.72,31.88-316::47.37,19.47",
				[313] = "45.86,92.67-313::48.93,77.89",
			},
			[313] = {	
				[312] = "48.93,77.89-312::45.86,92.67",
				[314] = "34.60,55.37-314::48.94,77.32",
			},
			[314] = {	
				[313] = "48.94,77.32-313::34.60,55.37|56.86,44.93-313::54.68,54.74",
				[315] = "34.62,57.88-315::48.75,90.71",
			},
			[315] = {	
				[314] = "48.75,90.71-314::34.62,57.88",
			},
			[230] = {	
				[231] = "46.08,9.57-231::64.77,43.35",
			},
			[231] = {	
				[230] = "64.77,43.35-230::46.08,9.57",
			},
			[291] = {	
				[292] = "65.48,60.02-292::16.97,88.45",
			},
			[292] = {	
				[291] = "16.97,88.45-291::65.48,60.02",
			},
			[283] = {
				[284] = "52.05,20.12-284::29.97,17.32|49.93,12.98-284::29.37,13.13",
			},
			[284] = {
				[291] = "29.37,13.13-283::49.93,12.98",
			},			
			[348] = {
				[349] = "83.13,49.50-348::83.07,43.77", 
			},		
			[349] = {
				[348] = "83.07,43.77-349::83.13,49.50", 
			},			
		}, -- [2]
		[1467] = {
			[100] = {
				[108] = 1432676590,
				[102] = 368738667,
			},
			[104] = {
				[108] = 888817067,
			},
			[102] = {
				[100] = 3741099940,
				[107] = "900773613|2874795116",
				[108] = 3548704455,
				[105] = 3022278272,
			},
			[105] = {
				[109] = 3629336664,
				[102] = 2302474188,
			},
			[107] = {
				[102] = "1457660635|3253816387",
			},
			[108] = {
				[102] = 1401359768,
				[100] = 2597989984,
				[104] = 3178728030,
			},
			[109] = {
				[105] = 941198995,
			},
			[263] = {
				[264] = "49.85,29.26-264::51.23,28.93|51.38,27.47-264::51.48,29.20|48.01,77.81-264::46.24,79.55|36.64,73.70-264::35.59,72.57", 
			},
			[264] = {
				[263] = "51.23,28.93-263::49.85,29.26|46.24,79.55-263::48.01,77.81", 
			},
			[267] = {
				[268] = "41.73,22.82-268::41.77,31.54", 
			},
			[268] = {
				[267] = "41.77,31.54-267::41.73,22.82", 
			},
			[269] = {
				[270] = "65.11,35.34-270::89.26,43.76", 
			},	
			[270] = {
				[270] = "89.26,43.76-270::65.11,35.34", 
				[271] = "36.51,57.12-271::26.97,88.52", 
			},
			[271] = {
				[270] = "26.97,88.52-270::36.51,57.12", 
			},
			[258] = {
				[259] = "48.71,95.13-259::53.33,94.35", 
			},
			[259] = {
				[258] = "53.33,94.35-258::48.71,95.13|44.61,27.42-258::51.57,27.55", 
			},
			[256] = {
				[257] = "44.67,17.68-257::22.77,12.22", 
			},
			[257] = {
				[256] = "22.77,12.22-256::44.67,17.68", 
			},
			[348] = {
				[349] = "82.88,44.83-349::83.15,55.44", 
			},
			[349] = {
				[348] = "83.15,55.44-348::82.88,44.83", 
			},			
		}, -- [3]
		[4] = {
			[114] = {
				[115] = 4163853514,
				[119] = 2230065484,
			},
			[115] = {
				[127] = 2609191972,
				[114] = 493915578,
				[116] = 4002522347,
				[121] = 3821812493,
			},
			[116] = {
				[115] = 400075761,
				[121] = "736775540|1915439138|2605984477",
				[117] = "1545330826|2878324328",
			},
			[117] = {
				[116] = "1137584778|2295139559",
			},
			[118] = {
				[127] = 3826438157,
				[120] = 3560455606,
			},
			[119] = {
				[114] = 1332540447,
			},
			[120] = {
				[127] = 1402136832,
				[118] = 963928072,
			},
			[121] = {
				[115] = 656663382,
				[127] = 393783875,
				[116] = "1213658859|2452812115|3178746509",
			},
			[127] = {
				[115] = 1930214601,
				[120] = 3034797940,
				[121] = 3945829320,
				[118] = 2502836928,
			},
			[125] = {
				[126] = "35.3,44.8-125::33.6,45.63-125::38.8,45.1-126::34.3,43.3|59.76,47.37-125::61.2,49.0-125::38.8,45.1-126::64.4,48.6|48.1,32.4-126::48.2,32.4",
			},
			[126] = {
				[125] = "38.8,45.1-125::35.3,44.8-125::33.6,45.63-125::35.3,44.8|64.4,48.6-125::38.8,45.1-125::61.2,49.0-125::59.76,47.37",
			},
			[138] = {
				[139] = "89.0,53.8-139::57.0,21.3",
			},
			[139] = {
				[138] = "57.0,21.3-138::89.0,53.8",
			},
			[133] = {
				[134] = "48.5,84.7-134::34.8,64.5",
			},
			[134] = {
				[133] = "34.8,64.5-133::48.5,84.7",
				[135] = "53.5,25.3-135::33.1,40.7",
			},	
			[135] = {
				[134] = "33.1,40.7-134::53.5,25.3",
			},	
			[136] = {
				[137] = "31.1,75.0-137::42.3,76.6|45.9,82.6-137::54.2,79.1|54.7,18.0-137::59.6,34.1",
			},
			[137] = {
				[136] = "42.3,76.6-136::31.1,75.0|54.2,79.1-136::45.9,82.6|59.6,34.1-136::54.7,18.0",
			},
			[158] = {
				[159] = "41.0,37.3-159::70.6,31.6",
				[157] = "50.3,60.4-157::22.0,50.7",
			},
			[159] = {
				[158] = "70.6,31.6-158::41.0,37.3",
			},
			[160] = {
				[161] = "64.4,71.6-161::50.5,71.5",
			},				
			[161] = {
				[160] = "50.5,71.5-160::64.4,71.6",
			},				
		}, -- [1]
		[5] = {
			[174] = {
				[175] = "31.2,78.6-175::48.1,90.0", -- Kaja'mite Cavern
				[176] = "70.0,48.0-176::50.0,10.8", -- Volcanoth's Lair
			},
			[175] = { 
				[174] = "48.1,90.0-174::31.2,78.6", -- Kaja'mite Cavern
			},
			[176] = {
				[174] = "50.0,10.8-174::70.0,48.0", -- Volcanoth's Lair
			},
			[194] = {
				[197] = "65.6,86.7-197::64.0,19.6", -- Kaja'Mine Copper
				[196] = "74.3,83.3-196::32.9,31.0", -- Kaja'Mine Silver
				[195] = "70.9,76.5-195::41.0,75.5", -- Kaja'Mine Gold
			},
			[197] = {
				[194] = "64.0,19.6-194::65.6,86.7", -- Kaja'Mine Copper
			},
			[196] = {
				[194] = "32.9,31.0-194::74.3,83.3", -- Kaja'Mine Silver
			},
			[195] = {
				[194] = "41.0,75.5-194::70.9,76.5", -- Kaja'Mine Gold
			},
			[322] = {
				[323] = "48.9,82.1-323::51.0,53.0|50.0,39.7-323::50.0,90.1",
			},
			[323] = {
				[322] = "51.0,53.0-322::48.9,82.1|50.0,90.1-322::50.0,39.7",
			},
			[207] ={
				[208] = "62.78,78.04-208::40.43,14.38",
			},
			[208] ={
				[207] = "40.43,14.38-207::62.78,78.04",
				[209] = "73.95,79.27-209::65.61,72.72",
			},
			[209] ={
				[208] = "65.61,72.72-208::73.95,79.27",
			},
		}, -- [5]
		[6] = {
			[376] = {
				[418] = "3561129410|510389304",
				[433] = 3034134506,
				[371] = 3845402834,
			},
			[379] = {
				[390] = 2382097092,
				[433] = 3172202871,
				[388] = 1257154184,
				[383] = "52.9,71.3-383::56.5,15.9", --The Deeper
				[382] = "50.3,61.7-382::74.9,91.5", -- Knucklethump Hole
				[381] = "73.2,73.5-381::11.5,30.0", -- Pranksters' Hollow
				[380] = "59.1,52.5-380::66.9,82.3", -- Howlingwind Cavern
				[385] = "53.0,46.5-385::88.3,54.8", -- Tomb of Conquerors
				[386] = "33.1,26.6-386::52.2,11.6", -- Ruins of Korune
				[434] = "73.2,94.6-434::25.1,12.5", -- The Ancient Passage
			},
			[382] = {
				[379] = "74.9,91.5-379::50.3,61.7", -- Knucklethump Hole
			},
			[381] = {
				[379] = "11.5,30.0-379::73.2,73.5", -- Pranksters' Hollow
			},
			[380] = {
				[379] = "66.9,82.3-379::59.1,52.5", -- Howlingwind Cavern
			},
			[385] = {
				[379] = "88.3,54.8-379::53.0,46.5", -- Tomb of Conquerors
			},	
			[383] = { 
				[384] = "52.4,65.5-384::51.6,55.9", --The Deeper2
				[379] = "56.5,15.9-379::52.9,71.3", --The Deeper
			},
			[386] = { 
				[387] = "30.9,75.9-387::34.3,76.1", -- Crypt of Korune
				[379] = "52.2,11.6-379::33.1,26.6" -- Ruins of Korune
			},
			[903] = {
				[390] = "53.8,87.0-390::61.5,18.8|26.8,80.7-390::59.1,17.9|77.4,69.0-390::63.5,17.0",  -- main / west / east
			},			
			[903] = {
				[390] = "53.8,87.0-390::61.5,18.8|26.8,80.7-390::59.1,17.9|77.4,69.0-390::63.5,17.0",  -- main / west / east
				[903] = "22.1,54.4-903::27.8,80.6|36.6,21.7-903::38.3,36.6|77.5,42.6-903::74.4,70.3|58.0,18.5-903::55.8,30.0" -- west staircase / west hall / east staircase / east hall
 			},
			[903] = {						
				[903] = "51.28,76.12|27.8,80.6-903::22.1,54.4|38.3,36.6-903::36.6,21.7|74.4,70.3-903::77.5,42.6|55.8,30.0-903::58.0,18.5" -- balcony jump / west staircase / west hall / east staircase / east hall
			},				
			[390] = {
				[379] = 1886394282,
				[903] = 2637705065,
				[391] = "61.5,18.8-391::53.8,87.0|59.1,17.9-391::26.8,80.7|63.5,17.0-391::77.4,69.0", -- main / west / east
				[903] = "61.5,18.8-903::53.8,87.0|59.1,17.9-903::26.8,80.7|63.5,17.0-903::77.4,69.0", -- main / west / east
				[393] = "86.8,64.3-393::38.6,28.4|85.6,67.4-393::25.5,55.8|89.1,63.5-393::60.3,18.0", -- main / west / east				
				[395] = "22.2,26.3-395::54.0,88.2", -- Guo-Lai Halls
				--[requirements] = "qid:31511,31512"
			},
 			[395] = {
 				[390] = "54.0,88.2-390::22.2,26.3", -- Guo-Lai Halls
				[396] = "64.2,18.8-396::66.9,17.7" -- The Hall of Serpent
 			},
			[396] = {
				[395] = "66.9,17.7-396::64.2,18.8" -- The Hall of Serpent
			},			
			[393] = {
				[390] = "38.6,28.4-390::86.8,64.3|25.5,55.8-390::85.6,67.4|60.3,18.0-390::89.1,63.5",  -- main / west / east
				[394] = "33.6,78.3-394::30.6,52.0|70.4,33.5-394::61.7,18.4|52.4,78.9-394::56.1,75.7|66.4,63.3-394::68.4,63.3" -- west staircase / east staircase / west hall / east hall
			},
			[394] = {
				[393] = "47.5,38.0|30.6,52.0-393::33.6,78.3|61.7,18.4-393::70.4,33.5|56.1,75.7-393::52.4,78.9|68.4,63.3-393::66.4,63.3" -- balcony jump
			},					
			[433] = {
				[376] = 2169764215,
				[379] = 1424956768,
				[434] = "50.6,40.4-434::63.1,86.4|57.3,13.6-434::77.6,36.7", -- The Ancient Passage
			},
			[434] = {
				[433] = "63.1,86.4-433::50.6,40.4|77.6,36.7-433::57.3,13.6", -- The Ancient Passage
				[379] = "25.1,12.5-379::73.2,94.6", -- The Ancient Passage
			},
			[371] = {
				[376] = 1406642189,
				[372] = "45.9,28.9-372::75.7,24.7", -- Greenstone Quarry (Outisde --> Upper Quarry)
				[374] = "57.7,31.7-374::76.8,20.0", -- The Widow's Wail (Outside of Cave --> Inside Cave)
				[375] = "57.5,27.7-375::82.4,47.7", -- Oona Kagu (Outside of Cave --> Inside Cave)				
			},
			[372] = { 
				[371] = "75.7,24.7-371::45.9,28.9", -- Greenstone Quarry (Outisde --> Upper Quarry)
				[373] = "39.8,38.0-373::51.2,51.0", -- Greenstone Quarry (Upper Quarry --> Lower Quarry)
			},
			[373] = { 
				[372] = "51.2,51.0-372::39.8,38.0", -- Greenstone Quarry (Upper Quarry --> Lower Quarry)
			},
			[374] = { 
				[371] = "76.8,20.0-371::57.7,31.7", -- The Widow's Wail (Outside of Cave --> Inside Cave)
			},
			[375] = { 
				[371] = "82.4,47.7-371::57.5,27.7", -- Oona Kagu (Outside of Cave --> Inside Cave)			
			},			
			[388] = {
				[422] = 2498947948,
				[379] = 3044437654,
				[389] = "33.02,61.24-389::20.15,68.46", -- Niuzao Catacombs
			},
			[389] = {
				[388] = "20.15,68.46-388::33.02,61.24", -- Niuzao Catacombs
			},
			[418] = {
				[376] = "322804459|1673604347",
				[419] = "80.3,17.8-419::33.3,24.4",
			},
			[419] = {
				[420] = "61.6,51.8-420::59.5,36.7",
				[418] = "33.3,24.4-418::80.3,17.8",
			},
			[420] = {
				[420] = "59.5,36.7-419::61.6,51.8",
				[421] = "62.7,39.6-421::82.3,36.0",
			},	
			[421] = {
				[420] = "82.3,36.0-420::62.7,39.6",
			},				
			[422] = {
				[388] = 1927748412,
			},
			[504] = {
				[505] = "54.6,29.1-505::73.1,51.3|49.3,25.5-505::38.8,27.1|49.3,25.5-505::38.8,27.1", --Ghostly Veins
				[506] = "62.4,40.3-506::66.1,77.9", --The Swollen Vault
			},
			[505] = {
				[504] = "73.1,51.3-504::54.6,29.1|38.8,27.1-504::49.3,25.5|38.8,27.1-504::49.3,25.5", --Ghostly Veins
			},
			[506] = {
				[504] = "66.1,77.9-504::62.4,40.3", --The Swollen Vault
			},
			[554] = {
				[555] = "43.3,40.8-555::44.4,81.0", --Cavern of Lost Spirits
			},
			[555] = { 
				[554] =  "44.4,81.0-554::43.3,40.8", --Cavern of Lost Spirits
			},
			[439] = {
				[440] = "28.1,61.1-440::32.8,59.2",
			},
			[440] = {
				[439] = "32.8,59.2-439::28.1,61.1",
				[441] = "81.5,58.5-441::33.8,77.9",
			},
			[441] = {
				[440] = "33.8,77.9-440::75.5,33.5",
				[442] = "75.5,33.5-442::57.6,31.1",
			},
			[442] = {
				[441] = "57.6,31.1-441::75.5,33.5",
			},
			[458] = {
				[457] = "50.3,73.9-457::21.6,53.6",
			},
			[459] = {
				[457] = "53.2,81.9-457::57.1,80.7",
			},
			[457] = {
				[458] = "21.6,53.6-458::50.3,73.9",
				[459] = "57.1,80.7-459::53.2,81.9",
			},
			[453] = {
				[454] = "49.0,67.0-454::55.8,18.9",
			},
			[454] = {
				[453] = "55.8,18.9-453::49.0,67.0",
				[455] = "71.5,76.2-455::58.8,24.3",
			},
			[455] = {				
				[454] = "58.8,24.3-454::71.5,76.2",
			},
			[429] = {				
				[430] = "27.4,62.7-430::39.0,22.0|27.0,68.7-430::46.6,42.5",
			},
			[430] = {				
				[429] = "39.0,22.0-429::27.4,62.7|46.6,42.5-429::27.0,68.7",
			},
			[444] = {			
				[445] = "56.0,88.0-445::21.0,85.6",
				[446] = "36.5,81.8-446::76.9,81.4|22.1,69.1-446::12.3,19.2",
				[443] = "30.7,35.0-443::17.0,72.6|44.7,40.1-443::51.3,83.9",				
			},
			[445] = {			
				[444] = "21.0,85.6-444::56.0,88.0",		
			},
			[446] = {			
				[444] = "76.9,81.4-444::36.5,81.8|12.3,19.2-444::22.1,69.1",	
			},
			[443] = {			
				[444] = "17.0,72.6-444::30.7,35.0|51.3,83.9-444::44.7,40.1",	
			},
			[437] = {			
				[438] = "46.3,33.1-438::50.0,50.8",	
			},
			[438] = {			
				[437] = "50.0,50.8-437::46.3,33.1",	
			},			
		}, -- [6]
		[7] = {
			[585] = {
				[525] = "16.21,73.99|57.18,6.60|12.2,72.4",
				[586] = "63.4,72.8-586::65.4,55.0", --Frostwall Mine
			},
			[590] = {
				[525] = "16.21,73.99|57.18,6.60|12.2,72.4",
			},
			[981] = {
				[525] = "16.21,73.99|57.18,6.60|12.2,72.4",
			},	
			[982] = {
				[525] = "16.21,73.99|57.18,6.60|12.2,72.4",
			},										
			[525] = {
				[585] = "44.15,68.52|49.63,60.27|44.3,68.7",
				[590] = "44.15,68.52|49.63,60.27|44.3,68.7",
				[981] = "44.15,68.52|49.63,60.27|44.3,68.7",
				[982] = "44.15,68.52|49.63,60.27|44.3,68.7",
				[543] = "87.9,72.4",
				[529] = "29.7,41.5-529::71.3,89.6", --Sootstained Mines
				[533] = "65.4,17.5-533::27.6,19.3", --Snowfall Alcove
				[531] = "46.0,33.4-531::33.2,51.5", --Grulloc's Grotto
				[530] = "63.3,65.7-530::24.6,58.6", --The Hunter's Hall
				[526] = "20.9,41.9-526::0.5,68.3|23.9,35.1", --Bladespire Citadel	
			},
			[526] = {
				[525] = "0.5,68.3-525::20.9,41.9|16.7,33.08",
				[527] = "55.3,25.8-527::55.7,18.7", --Bladespire Citadel				
			},
			[527] = {
				[526] = "55.7,18.7-527::55.3,25.8", --Bladespire Citadel				
			},
			[529] = {
				[525] = "71.3,89.6-525::29.7,41.5", --Sootstained Mines
			},
			[533] = {
				[525] = "27.6,19.3-525::65.4,17.5", --Snowfall Alcove
			},
			[531] = {
				[525] = "33.2,51.5-525::46.0,33.4", --Grulloc's Grotto
				[532] = "41.9,32.8-532::42.0,32.9", --Grulloc's Lair
			},
			[532] = {
				[531] = "42.0,32.9-531::41.9,32.8", --Grulloc's Lair
			},
			[530] = {
				[525] = "24.6,58.6-525::63.3,65.7", --The Hunter's Hall
			},
			[535] = {
				[550] = "29.7,56.3",
				[543] = "69.9,0.7",
				[539] = "81.0,58.2",
				[542] = "41.9,98.3|57.2,91.3",
				[537] = "41.4,60.1-537::49.6,90.4", --Tomb of Souls
				[536] = "58.7,65.0-535::58.9,64.8-536::34.5,29.4", --Tomb of Lights
				[538] = "46.7,63.6-538::42.0,34.6", --The Breached Ossuary
			},
			[537] = {
				[535] = "49.6,90.4-535::41.4,60.1", --Tomb of Souls
			},
			[536] = {
				[535] = "34.5,29.4-535::58.9,64.8-535::58.7,65.0", --Tomb of Lights
			},
			[550] = {
				[535] = "92.4,72.2",
				[552] = "67.0,49.6-552::11.8,77.1", --Vault of the Titan
				[553] = "55.0,61.97-553::79.1,37.8", --The Underpale
			},
			[552] = {
				[550] = "11.8,77.1-550::67.0,49.6", --Vault of the Titan
			},
			[553] = {
				[550] = "8.5,60.1-550::47.3,64.5-550::47.0,62.0|79.1,37.8-550::55.0,61.97", --The Underpale
			},			
			[543] = {
				[535] = "41.6,95.2",
				[525] = "35.9,78.3",
				[544] = "48.3,94.0-544::59.1,17.6", --Moira's Bastion
				[546] = "43.7,48.3-546::65.5,83.7", --Fissure of Fury				
				[548] = "54.1,55.9-548::71.3,73.6", --Cragplume Crater	
			},
			[548] = {
				[543] = "571.3,73.6-543::54.1,55.9", --Cragplume Crater					
				[549] = "70.0,45.7-549::65.5,54.7", --Cragplume Crater				
			},
			[549] = {
				[548] = "65.5,54.7-548::70.0,45.7", --Cragplume Crater					
			},			
			[544] = {
				[543] = "59.1,17.6-543::48.3,94.0", --Moira's Bastion
				[545] = "58.7,83.1-545::59.4,84.5", --The Armory
			},
			[546] = {
				[543] = "65.5,83.7-543::43.7,48.3", --Fissure of Fury	
				[547] = "68.3,51.5-547::64.7,60.8", --Heart of Fury
			},			
			[545] = {
				[544] = "59.4,84.5-544::58.7,83.1", --The Armory
			},
			[547] = {
				[546] = "64.7,60.8-546::68.3,51.5", --Heart of Fury
			},
			[539] = {
				[535] = "18.9,12.2",
				[572] = "32.3,23.0",
				[542] = "23.0,45.4",
				[540] = "24.2,33.2-540::82.1,35.7", --Bloodthorn Cave
				[579] = "32.27,23.16-579::62.86,91.31|27.37,15.71",
				[582] = "32.27,23.16-579::62.86,91.31|27.37,15.71",
				[974] = "32.27,23.16-579::62.86,91.31|27.37,15.71",
				[585] = "32.27,23.16-579::62.86,91.31|27.37,15.71",
			},
			[540] = {
				[539] = "24.2,33.2-539::82.1,35.7", --Bloodthorn Cave
			},
			[542] = {
				[535] = "22.2,21.3|37.3,14.4",
				[539] = "65.2,18.6",
			},
			[572] = {
				[539] = "53.4,63.1",
			},
			[579] = {
				[580] = "66.8,42.6-580::67.9,63.6", --Lunarfall Excavation
				[539] = "62.86,91.31-539::32.27,23.16",
			},
			[582] = {
				[539] = "62.86,91.31-539::32.27,23.16",
			},	
			[974] = {
				[539] = "62.86,91.31-539::32.27,23.16",
			},
			[975] = {
				[539] = "62.86,91.31-539::32.27,23.16",
			},								
			[580] = {
				[579] = "67.9,63.6-579::66.8,42.6", --Lunarfall Excavation
			},
			[588] = {
				[624] = "42.0,23.4-624::48.3,80.9", --Warspear
			},
			[624] = {
				[588] = "48.3,80.9-588::42.0,23.4",
			},
		}, -- [7]
		[8] = {
			[680] ={ --Suramar
				[630] = "21.36,63.81-630::66.72,18.38",
				[641] = "17.39,25.44-641::68.18,66.44",
				[634] = "63.85,35.66-634::33.55,77.08",
				[682] = "35.70,82.27-682::25.39,89.84",
				[684] = "22.85,35.76-684::49.58,66.94",
				[688] = "41.62,38.99-688::20.25,33.24",
				[689] = "35.70,24.30-689::49.28,88.09",
				[690] = "24.35,19.43-690::63.53,87.13",
				[687] = "59.37,43.03-687::55.25,89.33",		
				[686] = "65.95,42.06-686::56.37,86.81",	
				[683] = "34.54,84.24-683::41.94,25.50",													
			},
			[690] = {
				[680] = "63.53,87.13-680::24.35,19.43",
			},
			[687] = {
				[680] = "55.25,89.33-680::59.37,43.03",
			},
			[686] = {
				[680] = "56.37,86.81-680::65.95,42.06",
			},
			[683] = {
				[680] = "41.94,25.50-680::34.54,84.24",
			},												
			[689] = {
				[680] = "49.28,88.09-680::35.70,24.30",
			},
			[682] = { --Felsoul Hold
				[680] = "25.39,89.84-680::35.70,82.27",
			},			
			[684] = { --Falanaar Tunnels
				[680] = "49.58,66.94-680::22.85,35.76",
				[685] = "32.86,72.06-685::48.77,14.75",
			},
			[685] = { --Falanaar Tunnels 2
				[684] = "48.77,14.75-684::32.86,72.06",
			},			
			[688] = { --Ley Station Anora
				[680] = "20.25,33.24-688::41.62,38.99",
			},
			[739] = { --Trueshot Lodge Hunter only
				[650] = "46.43,4.00", 
				requirements = "cls:HUNTER",
			},
			[650] = { --High Mountain
				[739] = "34.34,46.77", --Hunter only
				[641] = "26.06,62.98-641::69.85,28.12",
				[634] = "59.59,68.67-634::27.16,38.97",
				[750] = "49.05,55.21-750::58.86,14.81|50.14,63.75-750::66.59,68.44|44.91,65.68-750::33.69,77.56|44.10,59.38-750::31.71,41.56|45.02,56.07-750::32.79,16.93",
				[655] = "38.36,61.30-655::73.12,78.46",
				[651] = "41.39,72.51-651::17.60,27.90",
				[653] = "37.59,33.44-653::51.82,18.62",
				[654] = "41.27,46.34-654::52.69,88.76|38.93,43.21-654::32.66,60.74",
				[657] = "44.73,72.22-657::23.51,42.65|44.77,72.25-657::22.83,42.62",
				[659] = "42.56,25.42-659::20.96,78.85",
				[658] = "47.66,84.15-658::42.18,90.39",
			},
			[651] = { --Bitestone Enclave
				[650] = "17.60,27.90-650::41.39,72.51",
			},			
			[653] = { --Cave of the Blood Trial
				[650] = "51.82,18.62-650::37.59,33.44",
			},				
			[654] = { --Mucksnout Den
				[650] = "52.69,88.76-650::41.27,46.34|32.66,60.74-650::38.93,43.21",
			},
			[655] = { --Lifespring Cavern
				[650] = "73.12,78.46-650::38.36,61.30",
				[656] = "40.21,58.37-656::36.71,78.52",
			},
			[656] = { --Lifespring Cavern
				[655] = "36.71,78.52-655::40.21,58.37",
			},
			[657] = { --Neltharion's Vault
				[650] = "23.51,42.65-650::44.73,72.22",
				[658] = "49.79,86.56-658::45.36,16.75",				
			},		
			[658] = { --Neltharion's Vault floor 2
				[657] = "45.36,16.75-657::49.79,86.56",
				[650] = "42.18,90.39-650::47.66,84.15",
			},				
			[659] = { --Stonedark Grotto
				[650] = "20.96,78.85-650::42.52,25.5",
			},	
			[750] ={ --Thunder Totem
				[650] = "58.86,14.81-650::49.05,55.21|66.59,68.44-650::50.14,63.75|33.69,77.56-650::44.91,65.68|31.71,41.56-650::44.10,59.38|32.79,16.93-650::45.02,56.07",
				[750] = "49.17,45.95|45.95,59.09|27.77,79.22|36.4,45.53|42.73,35.61",
			},
			[750] = { --Thunder Totem lower floor
				[750] = "48.50,12.12|26.96,44.33|23.23,82.26|59.13,87.72|68.75,49.81",
			},			
			[634] ={ --Stormheim
				[650] = "27.16,38.97-650::59.59,68.67",
				[680] = "33.55,77.08-680::63.85,35.66",		
				[635] = "84.10,9.56-635::74.87,58.75",
				[636] = "29.98,55.33-636::60.27,18.51",
				[639] = "47.61,44.82-639::26.13,71.32",
				[637] = "42.81,81.79-637::73.08,66.85",				
			},
			[635] ={ --Tomb of the Old Kings
				[634] = "74.87,58.75-634::84.10,9.56",
			},
			[637] ={ --Thorignir Refuge
				[634] = "73.08,66.85-634::42.81,81.79",
				[638] = "38.93,50.62-638::49.54,41.6",
			},			
			[638] ={ --Thorignir Refuge floor 2
				[637] = "49.54,41.6-637::38.93,50.62",
			},			
			[636] ={ --Stormscale Cavern
				[634] = "60.27,18.51-634::29.98,55.33",
			},
			[639] ={ --Aggramar's Vault
				[634] = "26.13,71.32-634::47.61,44.82",
			},			
			[626] ={ --Dalaran Halls of Shadows (
				[627] = "77.45,83.91",
				requirements = "cls:ROGUE",
			},
			[627] ={ --Dalaran Legion
				[628] = "60.94,49.48|33.25,46.16",
				[629] = "49.40,47.58",
				[626] = "54.37,69.26",
			},
			[628] ={ --Dalaran Underbelly
				[627] = "73.36,61.88|25.52,57.21",
			},
			[629] ={ --Dalaran Chamber of Guardian	
				[627] = "64.89,22.22",
			},
			[630] ={ --Azuna
				[680] = "66.72,18.38-680::21.36,63.81",
				[641] = "52.68,7.05-641::58.76,92.49",
				[631] = "53.75,40.33-631::62.53,85.59",
				[632] = "43.65,14.11-630::47.92,50.68|49.01,58.89-632::55.77,90.84",
			},
			[631] ={ --Nar'thalas Academy
				[630] = "62.53,85.59-630::53.75,40.33",
			},
			[632] ={ --Oceanus Cove
				[630] = "47.92,50.68-632::43.65,14.11|55.77,90.84-630::49.01,58.89",
			},
			[641] ={ --Val'Shara
				[680] = "68.18,66.44-680::17.39,25.44",
				[630] = "58.76,92.49-630::52.68,7.05",
				[650] = "69.85,28.12-650::26.06,62.98",
				[642] = "40.50,44.95-642::38.05,87.16",
				[643] = "50.00,85.54-643::66.87,25.82",
				[747] = "45.17,33.75|39.53,18.80",
			},
			[642] ={ --Darkpens
				[641] = "38.05,87.16-641::40.50,44.95",
			},
			[643] ={ --Sleeper's Barrow
				[641] = "66.87,25.82-641::50.00,85.54",
				[644] = "33.96,58.58-644::26.19,61.88|61.13,47.06-644::76.66,56.56",
			},
			[644] ={ --Sleeper's Barrow floor 2
				[643] = "26.19,61.88-643::33.96,58.58|76.66,56.56-643::61.13,47.06",	
			},
			[747] = { --Dreamgrove Druid Only
				[641] = "76.08,93.59|40.93,0.00",
				requirements = "cls:DRUID",
			},
			[647] = {  -- Ebon Hold Death Knight only
				[648] = "34.71,36.84"
			},
			[648] = {  -- Ebon Hold Death Knight only
				[647] = "33.34,35.63"			
			},
			[708] = { --Maw of Souls Broken Isle
				[706] = "89.50,52.91",
			},
			[706] = {
				[708] = "88.10,58.26",
			},
			[704] = { --Hall of Valor
				[705] = "38.86,75.04-705::68.83,27.40",
			},
			[705] = { --Hall of Valor
				[704] = "68.83,27.40-705::38.86,75.04",
				[703] = "47.75,72.16-703::51.32,7.05",
			},
			[703] = { --Hall of Valor
				[705] = "51.32,7.05-705::47.75,72.16",
			},			
		},-- [8]		
		[9] = {
			[831] = {
				[832] = "58.61,41.52-832::59.18,45.96|42.03,52.75-832::43.45,55.88",
			}, 
			[832] = {
				[831] = "59.18,45.96-831::58.61,41.52|43.45,55.88-831::42.03,52.75",
			}, 
			[830] = {
				[833] = "50.32,17.33-833::66.69,86.09",
			}, 
			[833] = {
				[830] = "66.69,86.09-830::50.32,17.33",
			}, 						
			[883] = {
				[884] = "60.48,43.40-884::60.48,43.40|45.08,49.56-884::47.02,53.56",
			},
			[884] = {
				[883] = "60.48,43.40-883::60.48,43.40|47.02,53.56-883::45.08,49.56",
			},
			[886] = {
				[887] = "46.08,38.63-887::49.68,39.34|50.42,61.98-887::53.67,58.07",
			},	
			[887] = {
				[886] = "49.68,39.34-886::46.08,38.63|53.67,58.07-886::50.42,61.98",
			},						
		},-- [7]
		[10] = {
		},-- [10]
		[11] = {
		},-- [10]	
		[12] = {		
			[889] = {
				[890] = "66.63,35.06-890::89.47,46.94",
			}, 
			[890] = {
				[889] = "89.47,46.94-889::66.63,35.06",
			},					
			[710] = { --Vault of the Wardens
				[711] = "24.37,18.20-711::46.75,48.16",
			},
			[711] = { --Vault of the Wardens
				[710] = "46.75,48.16-710::24.37,18.20",
				[712] = "34.17,48.43-712::52.28,18.21",
			},
			[712] = { --Vault of the Wardens
				[711] = "52.28,18.21-711::34.17,48.43",
			},			
			[751] = { --Black Rook Hold Broken Isle
				[752] = "65.31,87.54-752::20.38,31.85",
			},
			[752] = {
				[751] = "20.38,31.85-751::65.31,87.54",
				[753] = "47.82,29.46-753::72.42,76.93",				
			},			
			[753] = {
				[752] = "72.42,76.93-752::47.82,29.46",
				[754] = "39.23,57.99-754::38.03,73.37",
			},	
			[754] = {
				[753] = "38.03,73.37-753::39.23,57.99",
				[755] = "47.94,64.81-755::52.42,43.71",
			},					
			[755] = {
				[754] = "52.42,43.71-754::47.94,64.81",
				[756] = "59.59,65.93-756::66.71,68.23",
			},
			[756] = {
				[755] = "66.71,68.23-755::59.59,65.93",
			},			
			[202] = {
				[678] = "65.81,21.16-678::67.33,42.46|29.02,75.75-678::54.62,60.95|23.29,62.42-678::51.71,55.42",
			},
			[678] = {
				[202] = "67.33,42.46-202::65.81,21.16|54.62,60.95-202::29.02,75.75|58.10,61.49-678::59.35,61.97-202::40.52,81.77",
				[678] = "28.8,51.2-678::69.9,63.4", -- Greymane Manor
				[678] = "76.6,31.1-678::28.5,70.0", -- Emberstone Mine
			},
			[678] = {
				[678] = "28.5,70.0-678::76.6,31.1", -- Emberstone Mine
			},
			[678] = {
				[678] = "69.9,63.4-678::28.8,51.2", -- Greymane Manor
				[678] = "60.3,46.2-678::56.1,46.5", -- Greymane Manor
			},						
			[678] = {
				[678] = "56.1,46.5-678::60.3,46.2", -- Greymane Manor
			},			
			[720] ={ --Mardum,Demon Hunter Order Hall
				[721] = "69.61,53.97-721::66.51,53.88|48.97,54.38-721::52.08,54.13",
			},
			[721] ={ --Mardum,Demon Hunter Order Hall
				[720] = "66.51,53.88-720::69.61,53.97|52.08,54.13-720::48.97,54.38",
			},
			[734] ={ --Hall of Guardian,Mage Order Hall
				[735] = "60.58,48.67|71.50,58.36|48.81,54.70",
			},
			[735] ={ --Hall of Guardian,Mage Order Hall
				[734] = "57.85,70.42|72.21,77.96|42.49,73.01",
			},
			[698] ={ --Icecrown Citadel Death Knight
				[699] = "59.83,27.53|1039:2:49.62,14.35",
				[700] = "59.70,0.00",				 
			},			
			[699] ={
				[698] = "49.62,14.35|1039:1:59.83,27.53",
			},
			[700] ={
				[698] = "51.81,84.32",
			},
			[672] ={ 
				[673] = "63.69,53.85-673::48.63,16.66",
			},
			[673] ={
				[672] = "48.63,16.66-672::63.69,53.85",
			},
			[674] ={
				[672] = "57.60,85.10",
			},
			[672] ={
				[674] = "64.30,24.77",
			},
			[775] ={
				[776] = "73.30,52.63-776::33.95,44.65",
			},
			[776] ={
				[775] = "33.95,44.65-775::73.30,52.63",
			},
			[762] ={ --Court of Stars
				[763] = "63.36,65.91-763::38.42,40.67",
			},
			[763] ={
				[762] = "38.42,40.67-762::63.36,65.913",				
				[761] = "47.80,39.54-761::54.76,53.74",
			},
			[761] ={
				[763] = "54.76,53.74-763::47.80,39.54",
			},		
			[892] = {
				[893] = "24.57,49.70-893::42.15,71.73",
			},
			[893]  = {
				[892] = "42.15,71.73-892::24.57,49.70",
			},				
		},-- [12] 
		}
	
	--[[
	[1]="Kalimdor",
	[2]="Eastern Kingdoms",
	[1467]="Outland",
	[4] ="Northrend",
	]]
	
	TaxiData.UnboundTeleportData = 
	{
		[1] = {		
			[3565] = "3565:1457::1866975591:fac:Alliance", --Darnassus
			[49359] = "49359:1445::2834857324:fac:Alliance", --Theramore
			[32271] = "32271:1947::2045286692:fac:Alliance", --Exodar
			[3567] = "3567:86::2073797938", --Orgrimmar
			[3566] = "3566:1456::954018606:fac:Horde", --Thunder Bluff
			[18960] = "18960:1450::2416595707", --Moonglade
			[63353] = "89158:86::2073797938", --Shroud of Cooperation (Orgrimmar)
			[63207] = "89158:86::2073797938", --Wrap of Unity (Orgrimmar)
			[65274] = "89158:86::2073797938", --Cloak of Coordination (Orgrimmar)
			[18984] = "23442:1452::2560458565", --Dimensional Ripper - Everlook
			[18986] = "23441:1446::2243577666", --Ultrasafe Transporter: Gadgetzan
			[147787] = "147787:1454::49.96,37.74", -- Astral Fixation Glyph Horde			
		}, --Kalimdor
		[2] = {
			[88342] = "88342:245::3164314613:fac:Alliance", --Tol Barad (Alliance)
			[3561] = "3561:1453::2129976708:fac:Alliance", --Stormwind
			[3562] = "3562:1455::1095636371:fac:Alliance", --Ironforge
			[32272] = "32272:1954::2502242627:fac:Horde", --Silvermoon
			[49358] = "49358:1435::2140835548:fac:Horde", --Stonard
			[88344] = "88344:245::2362231206:fac:Horde", --Tol Barad (Horde)
			[3563] = "3563:1458::3632736717:fac:Horde", --Undercity
			[50977] = "50977:1423::3595665426:nqid:39757", --Death Gate
			[63352] = "89157:1453::2129976708", --Shroud of Cooperation (Stormwind)
			[63206] = "89157:1453::2129976708", --Wrap of Unity (Stormwind)
			[65360] = "89157:1453::2129976708", --Cloak of Coordination (Stormwind)
			[50287] = "71436:210::1760214267", --Boots of the Bay
			[63379] = "88342:245::3164314613", --Baradin's Wardens Tabard
			[63378] = "88344:245::2362231206", --Hellscream's Reach Tabard
			[147787] = "147787:1453::74.44,18.41", -- Astral Fixation Glyph Alliance
		}, --Eastern Kingdom
		[1467] = {
			[33690] = "33690:1955::2360895231:fac:Alliance", --Shattrath (Alliance)
			[35715] = "35715:1955::2276621818:fac:Horde", --Shattrath (Horde)
			[32757] = "41234:1948::2785374313", --Blessed Medallion of Karabor
			[30544] = "36941:1949::2594219684", --Ultrasafe Transporter: Toshley's Station
			[30542] = "36890:1953::1416536782", --Dimensional Ripper - Area 52		
			[33690] = "33690:1955::54.97,40.23:fac:Alliance", --Teleport: Shattrath		
			[35715] = "35715:1955::53.01,49.21:fac:Horde", --Teleport: Shattrath	
		},
		[4] = {
			[53140] = "53140:125::2401859529", --Dalaran
			[40586] = "53140:125::2401859529", --Kirin Tor Rings
			[48954] = "53140:125::2401859529",
			[48955] = "53140:125::2401859529",
			[48956] = "53140:125::2401859529",
			[48957] = "53140:125::2401859529",
			[45688] = "53140:125::2401859529",
			[45689] = "53140:125::2401859529",
			[45690] = "53140:125::2401859529",
			[45691] = "53140:125::2401859529",
			[44934] = "53140:125::2401859529",
			[44935] = "53140:125::2401859529",
			[51560] = "53140:125::2401859529",
			[51558] = "53140:125::2401859529",
			[51559] = "53140:125::2401859529",
			[51557] = "53140:125::2401859529",
			[40585] = "53140:125::2401859529",
			[46874] = "66238:118::2979412471", --Argent Crusader's Tabard
			[52251] = "53142:125::2401859529", --Jaina's Locket
			[265225] = "265225:118::76.97,18.66:qid:53586", --Mole Machine, Icecrown
			[265225] = "265225:115::45.35,49.92:qid:53596", --Mole Machine, Dragonblight
		}, --Northrend		
		[5] = {
			[58487] = "80256:207::2146995710", --Potion of Deepholm "Teleport: Deepholm spellId=80256"
		}, --The Maelstrom,
		[6] = {
			[126892] = "126892:379::2088922605:nqid:40236", --Zen Pilgrimage
			[132621] = "132621:390::3706756171", --Shrine of Seven Stars
			[132627] = "132627:390::2684434398", --Shrine of Two Moons
			[95568] = "140300:504::1223263341:fac:Horde:map:504:nqid:32212/140300:504::1429164925:qid:32212:fac:Horde:map:504", --Sunreaver beacon Item > Crimson treader/Dawnseeker's Promontory
			[95567] = ":504::1499325734:fac:Alliance:map:504:nqid:32644/:504::2775759894:qid:32644:fac:Alliance:map:504:", --Kirin Tor Beacon item > Seabolt/Violet Rise
			[265225] = "265225:379::57.68,62.81:qid:53595", --Mole Machine, Kun-Lai Summit
			[265225] = "265225:376::31.51,73.59:qid:53598", --Mole Machine, Valley of the Four Winds
		}, --Pandaria		
	}
	
	TaxiData.LocalPortalData = 
	{
		[1] = {
			":103::47.59,62.15:89::43.47,78.67:fac:Alliance", --Exodar - Darnassus
			":89::44.24,78.71:103::47.62,59.82:fac:Alliance", --Darnassus - Exodar
			":57::2366366369:57::1180925002:fac:Alliance", --Darnassus -Ruth'eran Village
			":57::1180925002:57::2366366369:fac:Alliance",

			":85::2099405507:249::2357680044:fac:Horde", -- Orgrimmar - Uldum 
			":85::2193449478:198::2726706133:qid:25316:fac:Horde", -- Orgrimmar - Mount Hyjal 
			":198::2726444692:85::2153275645:qid:25316:fac:Horde", -- Mount Hyjal - Orgrimmar 
		}, -- Kalimdor
		[2] = {
			":84::3144429320:245::3164314613:lvl:85:fac:Alliance", --Earthshrine Portals - Stormwind - Tol Barad
			":245::3231225522:84::3152031439:lvl:85:fac:Alliance", --Tol Barad - Stormwind
			":84::3148098344:204::2392504928:qid:14482:fac:Alliance", --Stormwind - Vash'jir 
			":84::3235981837:241::3413624609:qid:27545:fac:Alliance", --Stormwind - Twilight Highlands 
			":241::3413624609:84::3228510985:qid:27545:fac:Alliance", --Twilight Highlands - Stormwind 

			":18::2553392291:110::2174102044:fac:Horde", --Tirisfal Glades - Silvermoon City
			":110::2174102044:18::2553392291:fac:Horde", -- Silvermoon City - Tirisfal Glades
			":84::48.96,87.31:17::53.90,46.08:lvl:90:fac:Alliance", --Stormwind > Blasted Lands
			--":17::66.38,27.99:84::49.59,86.53:lvl:90:fac:Alliance", --Blasted Lands > Stormwind

			":23::2335446644:95::2215245500", --Eastern Plaguelands - Ghostlands
			":95::2215245500:23::2335446644",
			":348::4.39,49.60:122::47.10,30.69", --Magister Terrace > Isle of Quel Dana's 			
		}, --Eastern Kingdom
		[1467] = {}, -- Outland
		[4] = {
			":125::2401597390:127::679177647", --Dalaran - Violet Strand
			":127::679177647:125::2401859529", --Violet Strand - Dalaran
			":120::1761860185:120::2171392414:qid:12821", -- Stormpeaks - K3 > Garm's rise 
			":120::2177618368:120::1760352901:qid:12821", -- Stormpeaks - Garm's rise > K3
		}, --Northrend
		[5] = {
			":207::2115993802:207::2449285749:qid:26709", --Temple of Earth - Therazane's Throne
			":207::2458657461:207::2117501295:qid:26709",
		}, -- The Maelstrom
		[6] = {
			":388::2081272548:388::1244281130:qid:31110", -- Portal of Shan'ze Dao (req QID 31110)
			":388::1245722781:388::2086515473:qid:31110",
			
			":504::1517676512:388::2136977500:qid:32681:fac:Alliance:nqid:32644", --Seabolt  > Shado-pan garrison
			":388::2136453069:504::1497359875:qid:32681:fac:Alliance:nqid:32644", --Shado-pan garrison > Seabolt
			":504::1499129096:504::1358485115:qid:32681:fac:Alliance:nqid:32644", --Seabolt >Za'Tual  Portal
			":504::1358616136:504::1493755012:qid:32681:fac:Alliance:nqid:32644", --Za'Tual > Seabolt Portal
			
			":388::2175450088:504::1218414481:qid:32680:fac:Horde:nqid:32212", --Shado-pan garrison >Crimson Treader 
			":504::1218414481:388::2175450088:qid:32680:fac:Horde:nqid:32212",
			":504::1223263341:504::1420003137:qid:32680:fac:Horde:nqid:32212", -- Crimson Treader > Court of Bones
			":504::1227392755:504::1420003137:qid:32680:fac:Horde:nqid:32212", --Crimson Treader 2 > Court of Bones
			":504::1420003137:504::1223263341:qid:32680:fac:Horde:nqid:32212", -- Court of Bones > Crimson Treader
			
			":504::2779429917:388::49.70,68.70:qid:32644:fac:Alliance", -- Violet Rise > Shadopan Garrison
			":388::49.70,68.70:504::2752231817:qid:32644:fac:Alliance",  -- Shadopan Garrison > Violet Rise
			
			":504::1426543539:388::2177350473:qid:32212:fac:Horde", -- Dawnseeker's Promontory > Shadopan Garrison
			":388::2175515622:504::1427985159:qid:32212:fac:Horde",  -- Shadopan Garrison > Dawnseeker's Promontory
		}, -- Pandaria
		[7] = {
			":585::75.16,48.60:624::44.42,35.53:qid:36614:fac:Horde",  -- Garrison Tier 3 > Ashran
			":585::62.07,11.64:543::46.39,69.73:qid:34078:fac:Horde",  -- Garrison Tier 3 (mole machine) > Gorgrond
			":579::70.20,27.50:622::31.70,52.50:qid:36615:fac:Alliance",  -- Garrison Tier 3 > Ashran
			":579::58.84,69.03:543::52.91,59.77:qid:34033:fac:Alliance",  -- Garrison Tier 3 (mole machine) > Gorgrond		
			":534::61.02,47.35:624::44.42,35.53:qid:37935:fac:Horde", -- Vol'mar (Tanaan) > Ashran
			":624::53.09,43.91:534::60.87,47.30:qid:37935:fac:Horde", -- Ashran > Vol'mar (Tanaan)	
			":534::57.46,60.46:622::31.71,52.48:qid:38445:fac:Alliance", -- Lion's Watch (Tanaan) > Ashran			
			":622::36.42,41.24:534::57.53,60.32:qid:38445:fac:Alliance", -- Ashran > Lion's Watch (Tanaan)				
			":538::50.27,56.83:534::60.87,47.30:qid:38416:fac:Horde", -- Vol'mar Portal from Talador after completing Garrison Campaign: Onslaught at Auchindoun
			":538::52.35,55.17:534::57.53,60.32:qid:38562:fac:Alliance", -- Lion's Watch Portal from Talador after completing Garrison Campaign: Onslaught at Auchindoun			
		}, -- Draenor
		[8] = {	
			":680::36.75,45.05:680::54.46,69.43:qid:44740",--Shal'Aran > Astravar Harbor
			":680::54.46,69.43:680::36.75,45.05:qid:44740",--Astravar Harbor > Shal'Aran
			":680::36.12,45.74:682::52.35,36.76:qid:41575",--Shal'Aran > Felsoul Hold
			":682::53.54,36.71:680::36.40,45.09:qid:41575",--Felsoul Hold > Shal'Aran 
			--":680::36.35,44.92:680::36.31,46.89:qid:40956",--Shal'Aran > Ruins of Elune'eth
			--":680::36.11,47.24:680::36.40,45.09:qid:40956",--Ruins of Elune'eth > Shal'Aran 
			":680::36.17,45.04:680::43.61,79.10:qid:43811",-- Shal'Aran  > Lunastre Estate
			":680::43.69,79.24:680::36.40,45.09:qid:43811",--Lunastre Estate > Shal'Aran 			
			":680::35.90,45.55:684::41.37,15.05:qid:42230",--Shal'Aran > Falanaar			
			":684::40.93,13.76:680::36.40,45.09:qid:42230",--Falanaar > Shal'Aran 		
			":680::43.40,60.63:680::36.70,44.67:qid:43813",--Sanctum of Order > Shal'Aran 		
			":680::36.70,44.67:680::43.40,60.63:qid:43813",--Shal'Aran > Sanctum of Order
			":680::36.01,45.25:680::30.79,10.87:qid:43808",--Shal'Aran > Moon Guard Stronghold
			":680::30.83,11.02:680::36.40,45.09:qid:43808",--Moon Guard Stronghold > Shal'Aran
			":680::36.48,44.75:680::47.45,81.97:qid:42487", --Shal'Aran to The Waning Crescent
			":680::47.73,81.38:680::36.40,45.09:qid:42487",	--The Waning Crescent to Shal'Aran
			":680::36.92,44.66:680::42.17,35.38:qid:43809",	--Shal'Aran to Tel'anor
			":680::42.03,35.24:680::36.40,45.09:qid:43809",	--Tel'anor to Shal'Aran
			":680::36.95,45.00:680::64.09,60.80:qid:44084",	--Shal'Aran to Twilight Vineyards
			":680::64.00,60.43:680::36.40,45.09:qid:44084",	--Twilight Vineyards to Shal'Aran			
			":680::36.48,44.75:680::47.45,81.97:qid:42487:nqid:38649", --Shal'Aran to The Waning Crescent
			":680::47.73,81.38:680::36.40,45.09:qid:42487:nqid:38649", --The Waning Crescent to Shal'Aran
			":680::36.49,44.75:680::52.04,78.87:qid:42889", --Shal'Aran to Evermoon Terrace
			":680::51.98,78.75:680::36.40,45.09:qid:42889", --Evermoon Terrace to Shal'Aran							
			
			--":627::49.40,47.58:629::63.39,23.87",--Dalaran Legion > Dalaran Chamber of Guardian
			--":629::64.85,21.11:627::49.04,48.03",--Dalaran Chamber of Guardian > Dalaran Chamber of Guardian
			":739::48.68,43.36:627::60.89,44.75:cls:HUNTER:qid:40959", --Trueshot Lodge > Dalaran Legion		
			":747::56.63,43.03:627::60.89,44.75:cls:DRUID:qid:40653", --Dreamgrove > Dalaran Legion	
			":648::24.97,33.76:627::60.89,44.75:cls:DEATHKNIGHT", --Ebon Hold Legion > Dalaran Legion
			":634::30.08,40.71:627::60.89,44.75", --Stormheim > Dalaran Legion

			--":646::46.34,62.24:680::36.41,46.91:qid:46286", --Broken Shore > Shal'Aran, Suramar
			--":646::46.42,62.10:634::60.23,51.01:qid:46286", --Broken Shore > Valdisdall, Stormheim
			--":646::46.50,61.93:641::55.00,72.61:qid:46286", --Broken Shore > Lorlathil, Val'Sharah
			--":646::46.44,61.70:630::47.00,40.89:qid:46286", --Broken Shore > Crumbled Palace, Azsuna
			--":646::46.29,61.62:750::39.22,45.71:qid:46286", --Broken Shore > Highmountain				
		}, --Broken Isles
		[9] = {
			":831::43.35,23.36:830::62.59,81.79::Grand Artificer Romuul:qid:48440", --Speak to Grand Artificer Romuul > To Krookun
		}, -- Argus
	}

	TaxiData.StaticPortalData = 
	{
		[1] = {
			":84::3231790199:249::2357680044:qid:28112:fac:Alliance", --Stormwind - Uldum 
			":84::3271962584:198::2726771682:qid:25316:fac:Alliance", --Stormwind - Hyjal 
			":394::3039579669:103::2045286692:fac:Alliance", -- Shrine of Two Moons (Vale of Eternal Blossom) > Exodar
			":394::3315494796:89::1866975591:fac:Alliance", -- Shrine of Two Moons (Vale of Eternal Blossom) > Darnassus 

			":119::1729483743:78::2164593732:qid:12548",--Scholazar Waygate
			--":125::1099858771:71::2802351988", --Caverns of Time, Tanaris

			":125::2378907982:86::2073797938:fac:Horde", --Dalaran - Orgrimmar
			":111::2441641203:86::2073797938:fac:Horde", --Shattrath - Orgrimmar			
			":207::2187364330:85::2153275645:qid:27203:fac:Horde", -- Deepholm - Orgrimmar 
			":245::2418199529:85::2153275645:lvl:85:fac:Horde", -- Tol Barad - Orgrimmar
			":241::3159001355:85::2153275645:qid:26830:fac:Horde", -- Twilight Highlands - Orgrimmar 
			":371::1224680418:85::2948491323:lvl:85:qid:29690:fac:Horde", -- Jade Forest > Orgrimmar (req level 85 and QID 29690)
			":392::3161283759:88::954018606:fac:Horde", -- Shrine of Two Moons (Vale of Eternal Blossom) > Thunder Bluff 
			":392::3151523164:85::2948491323:fac:Horde", -- Shrine of Two Moons (Vale of Eternal Blossom) > Orgrimmar					
			":379::2084401036:85::2948491323:fac:Horde", -- Shrine of the Ox > Orgrimmar
			
			--":17::72.66,49.50:86::48.28,64.53:lvl:90:fac:Horde", --Blasted Lands > Orgrimmar
			":100::89.22,49.45:86::48.28,64.53:fac:Horde", --Hellfire Peninsula by Dark Portal > Orgrimmar 
			--":100::3804330527:86::2073797938:fac:Horde", --Hellfire Peninsula below steps > Orgrimmar

			--":622::63.52,64.31:89::43.47,78.67:fac:Alliance", -- Ashran, Stormshield > Darnassus
			--":624::60.70,51.60:86::48.28,64.53:fac:Horde", -- Ashran, Warspear > Orgrimmar
			--":624::50.00,24.40:88::22.20,16.90:fac:Horde", -- Ashran, Warspear > Thunder Bluff	

			--":627::37.62,66.68:103::47.62,59.82:fac:Alliance",--Dalaran Legion > Exodar
			--":627::38.29,65.58:89::43.47,78.67:fac:Alliance",--Dalaran Legion > Darnassus
			--":627::55.28,23.99:86::48.28,64.53:fac:Horde",--Dalaran Legion > Orgrimmar Cleft of Shadow
			--":627::56.91,22.05:88::22.21,16.87:fac:Horde",--Dalaran Legion > Thunderbluff			
			--":629::38.59,79.66:74::54.60,28.30",--Dalaran > Caverns of Time
			
			--":715::53.05,52.56:198::59.29,25.83:cls:DRUID:qid:40645",--Emerald Dreamway > Mount Hyjal
			--":715::26.12,79.59:80::67.59,60.19:cls:DRUID:qid:40645",--Emerald Dreamway > Moonglade		
			--":715::23.57,38.88:12::41.26,63.90:cls:DRUID:qid:40645",--Emerald Dreamway > Feralas		
			--":42::58.22,27.41:86::48.28,64.53:fac:Horde", --Dalaran Deadwind Pass > Orgrimmar					
		}, --Kalimdor
		[2] = {
			":125::1696505856:84::2129976708:fac:Alliance", --Dalaran - Stormwind
			":111::2456714084:84::2129976708:fac:Alliance", --Shattrath - Stormwind
			
			":100::89.22,51.00:84::49.59,86.53:fac:Alliance", --Hellfire Peninsula by Dark Portal - Stormwind
			":100::3806758706:84::2129976708:fac:Alliance", --Hellfire Peninsula  below steps - Stormwind
			
			":207::2083949011:84::3197841138:qid:27203:fac:Alliance", --Deepholm - Stormwind 
			":198::2688891702:84::3197841138:qid:25316:fac:Alliance", --Hyjal - Stormwind 
			":371::1985796596:84::2909154183:lvl:85:qid:31732:fac:Alliance", -- Jade Forest > Stormwind City (req level 85 and QID 31732)
			":394::3068615786:84::2129976708:fac:Alliance", -- Shrine of Two Moons (Vale of Eternal Blossom) > Stormwind City
			":394::3181996224:87::1095636371:fac:Alliance", -- Shrine of Two Moons (Vale of Eternal Blossom) > Ironforge 
			":379::2103078662:84::2909154183:fac:Alliance", -- Shrine of the Ox > Stormwind City

			":86::44.82,68.03:17::53.90,46.08:lvl:90:fac:Horde", --Orgrimmar > Blasted Lands
			
			":85::2114215292:204::2206309382:qid:25924:fac:Horde", -- Orgrimmar - Vash'jir 
			":85::2036032665:245::2395589879:lvl:85:fac:Horde", -- Orgrimmar - Tol Barad
			":85::2157012196:241::3162474671:qid:26830:fac:Horde", -- Orgrimmar - Twilight Highlands 
			":392::3188030255:90::3632736717:fac:Horde", -- Shrine of Two Moons (Vale of Eternal Blossom) > Undercity
			":392::3255207587:110::2502242627:fac:Horde", -- Shrine of Two Moons (Vale of Eternal Blossom) > Silvermoon 
			":100::3839328398:17::2363198085:lvl:58",--Dark Portal - you can't go back to Azeroth this way anymore in patch 6.0.2
			":111::2095934371:122::2072270917", --Sun's Reach Sanctum
			
			--":622::51.43,50.82:87::25.51,8.43:fac:Alliance", -- Ashran, Stormshield > Ironforge
			--":622::60.80,37.80:84::49.60,86.50:fac:Alliance", -- Ashran, Stormshield > Stormwind
			--":624::63.30,24.17:90::84.58,16.33:fac:Horde", -- Ashran, Warspear > Undercity	

			--":627::38.85,64.38:87::25.51,8.43:fac:Alliance",--Dalaran Legion > Ironforge
			--":627::39.50,63.17:84::49.59,86.53:fac:Alliance",--Dalaran Legion > Stormwind
			--":627::57.89,21.90:110::58.33,19.15:fac:Horde",--Dalaran Legion > Silvermoon
			--":627::55.95,22.81:90::84.58,16.33:fac:Horde",--Dalaran Legion > Undercity
			--":629::32.04,71.84:42::47.24,75.40",-- Dalaran > Karazhan
			--":629::28.80,77.39:25::30.91,36.34",--Dalaran > Dalaran Crater			
			
			--":715::50.27,65.20:26::62.48,23.50:cls:DRUID:qid:40645", --Emerald Dreamway > Hinterlands
			--":715::39.81,68.92:47::46.59,37.06:cls:DRUID:qid:40645", --Emerald Dreamway > Duskwood	
			
			--":627::32.67,69.76:24::38.63,62.61:fac:Alliance:cls:PALADIN:qid:38576", --Dalaran Legion > Paladin Order Hall
			--":627::61.92,13.49:24::39.42,61.46:fac:Horde:cls:PALADIN:qid:38576", --Dalaran Legion > Paladin Order Hall			
			--":42::38.82,64.2:84::49.59,86.53:fac:Alliance", --Dalaran Deadwind Pass > Stormwind
			--":84::80.25,34.83:42::72.60,46.05:qid:40718:fac:Alliance:nqid:44663",--Stormwind > Dalaran Legion
			--":86::36.32,71.14:42::72.60,46.05:qid:40718:fac:Horde:nqid:44184",--Orgrimmar Cleft of Shadow > Dalaran Legion				
		}, --Eastern Kingdom
		[1467] = {
			":17::2363198085:100::3839328398:lvl:58",--Blasted Lands Dark Portal > Hellfire Peninsula (not available after level 90 or completing qid 36881)			
			":392::2734854841:111::2276621818:fac:Horde", -- Shrine of Two Moons (Vale of Eternal Blossom) > Shattrath 			
			":394::2938734527:111::2276621818:fac:Alliance", -- Shrine of Two Moons (Vale of Eternal Blossom) > Shattrath 

			--":86::30.31,58.28:100::89.15,49.56:lvl:58:fac:Horde", --Orgrimmar > Hellfire Peninsula		
			--":88::23.18,13.50:100::89.15,49.56:lvl:58:fac:Horde", -- Thunderbluff > Hellfire Peninsula	
			--":90::85.26,17.00:100::89.15,49.56:lvl:58:fac:Horde", -- Undercity > Hellfire Peninsula	
			--":110::58.42,21.03:100::89.15,49.56:lvl:58:fac:Horde", -- Silvermoon > Hellfire Peninsula
			
			--":84::49.93,87.01:100::89.17,50.86:lvl:58:fac:Alliance", --Stormwind > Hellfire Peninsula
			--":89::43.99,78.17:100::89.15,49.56:lvl:58:fac:Alliance", -- Darnassus > Hellfire Peninsula	
			--":103::48.16,63.03:100::89.15,49.56:lvl:58:fac:Alliance", -- Exodar > Hellfire Peninsula
			--":87::27.20,7.05:100::89.15,49.56:lvl:58:fac:Alliance", -- Ironforge > Hellfire Peninsula
			
			--":629::35.59,85.21:111::53.01,49.21",--Dalaran > Shattrath			
		}, --Outland
		[4] = {
			":394::2660459684:125::2401859529:fac:Alliance", -- Shrine of Two Moons (Vale of Eternal Blossom) > Dalaran 
			":392::2648137077:125::2401859529:fac:Horde", -- Shrine of Two Moons (Vale of Eternal Blossom) > Dalaran 
			":78::2164593732:119::1729483743:qid:12548",--Scholazar Waygate
			
			--":629::30.93,84.15:115::59.72,52.88",--Dalaran > Wyrmrest Temple			
			
			--":715::31.76,26.62:116::50.43,29.75:cls:DRUID:qid:40645",--Emerald Dreamway > Grizzly Hills	
		}, --Northrend
		[5] = {
			":84::3143512645:207::2092992794:qid:27203:fac:Alliance", --Stormwind - Deepholm 
			":85::2183552263:207::2172946312:qid:27203:fac:Horde", -- Orgrimmar - Deepholm  
		}, --Maelstrom
		[6] = {		
			--":627::36.55,66.88:390::86.30,61.05:fac:Alliance",--Dalaran Legion > Vale of Eternal Blossoms
			--":627::55.03,25.63:390::62.50,21.82:fac:Horde",--Dalaran Legion > Vale of Eternal Blossoms	
			":85::2948491323:371::1224680418:lvl:85:qid:29690:fac:Horde", -- Orgrimmar > Jade Forest (req level 85 and QID 29690)
			":84::2952866787:371::1983502790:lvl:85:qid:31732:fac:Alliance", -- Stormwind City > Jade Forest (req level 85 and QID 31732)					
		},-- Pandaria
		[7] = {
			":17::54.94,53.88:624::44.42,35.53:qid:34446:fac:Horde",--Blasted Lands Dark Portal > Warspear, Ashran	
			":17::54.94,53.88:622::31.71,52.48:qid:35884:fac:Alliance", --Blasted Lands Dark Portal > Stormshield, Ashran	
			":85::47.65,72.19:624::44.42,35.53:qid:34446:fac:Horde", --Orgrimmar > Warspear, Ashran			
			":84::87.54,35.22:622::31.71,52.48:qid:35884:fac:Alliance", --Stormwind > Stormshield, Ashran				
		}, -- Draenor
		[8] = {
			":832::43.39,25.49:627::60.92,44.73:qid:48440", -- The Vindicaar, Krokuun > Dalaran Legion
			":884::49.39,25.84:627::60.92,44.73:qid:48081", -- The Vindicaar, Mac'Aree > Dalaran Legion
			":887::35.07,56.02:627::60.92,44.73:qid:48199", -- The Vindicaar, Antoran Waste > Dalaran Legion				
			":888::49.78,8.80:627::39.65,50.54", -- Whisper of Frightened World Scenario > Dalaran Legion
						
			":709::52.40,57.17:627::60.92,44.73:cls:MONK", --Monk Order Hall > Dalaran Legion
			
			":734::57.31,90.12:627::60.92,44.73:cls:MAGE", --Mage Order Hall > Dalaran Legion			
			":734::55.10,39.97:630::57.91,15.11:spell:223413:cls:MAGE", --Mage Order Hall > Azsuna (Teleporation Nexus)
			":734::56.64,44.37:650::31.40,63.80:spell:223413:cls:MAGE", --Mage Order Hall > Highmountain (Teleporation Nexus)
			":734::66.84,46.01:641::51.30,56.10:spell:223413:cls:MAGE", --Mage Order Hall > Val'shara (Teleporation Nexus)
			":734::67.09,41.96:634::31.34,60.51:spell:223413:cls:MAGE", --Mage Order Hall > Stormheim (Teleporation Nexus)						
			
			":24::37.79,63.84:627::33.20,68.89:fac:Alliance:cls:PALADIN:qid:38576", --Paladin Order Hall > Dalaran Legion
			":24::37.79,63.84:627::61.27,14.82:fac:Horde:cls:PALADIN:qid:38576", --Paladin Order Hall > Dalaran Legion
			":715::45.52,23.93:747::51.60,35.07:cls:DRUID:qid:40645", --Emerald Dreamway > Dreamgrove			

			":84::80.25,34.83:627::60.92,44.73:qid:44663:fac:Alliance",--Stormwind > Dalaran Legion
			":86::36.32,71.14:627::60.92,44.73:qid:44184:fac:Horde",--Orgrimmar Cleft of Shadow > Dalaran Legion			
			":702::49.80,80.71:627::39.48,57.31:cls:PRIEST:fac:Alliance", --Dalaran <-> Halls of Shadow 
			":702::49.80,80.71:627::63.00,17.70:cls:PRIEST:fac:Horde", --Dalaran <-> Halls of Shadow 				
			":695::58.34,24.98:635::60.18,52.23:cls:WARRIOR:qid:39803",	-- Stormheim: Jump to Skyhold	
			":695::58.34,24.98:630::47.58,28.08:cls:WARRIOR:qid:38443",	-- Azsuna: Jump to Skyhold
			":695::58.34,24.98:641::54.71,74.89:cls:WARRIOR:qid:38384",	-- Val'sharah: Jump to Skyhold
			":695::58.34,24.98:750::39.73,42.11:cls:WARRIOR:qid:38907",	-- Highmountain: Jump to Skyhold
			":695::58.34,24.98:680::33.08,48.20:cls:WARRIOR:qid:42229",	-- Suramar: Jump to Skyhold			
		}, -- Broken Isles
		[9] = {
			":627::74.26,49.29:831::61.15,81.37:qid:48440", --Dalaran Legion >  The Vindicaar, Krokuun 
		}, -- Argus
		[10] = {
		}, -- Reserve
		[11] = {
		}, -- Reserve		
		[12] = {
			":198::59.07,26.10:715::51.59,51.88:cls:DRUID:qid:40645", --Mount Hyjal > Emerald Dreamway 
			":198::59.07,26.10:715::51.59,51.88:cls:DRUID:qid:40645",--Mount Hyjal > Emerald Dreamway 
			":26::62.32,22.79:715::49.42,62.50:cls:DRUID:qid:40645",-- Hinterlands > Emerald Dreamway
			":47::46.56,35.86:715::38.84,66.00:cls:DRUID:qid:40645",--Duskwood > Emerald Dreamway
			":747::55.43,22.41:715::45.10,26.48:cls:DRUID:qid:40645",--Dreamgrove > Emerald Dreamway
			":116::50.35,29.32:715::32.40,29.53:cls:DRUID:qid:40645",--Grizzly Hills > Emerald Dreamway
			":80::67.96,60.23:715::26.31,77.76:cls:DRUID:qid:40645",--Moonglade > Emerald Dreamway
			":12::51.31,10.68:715::26.31,77.76:cls:DRUID:qid:40645",--Feralas > Emerald Dreamway
			":119::88.43,53.00:888::43.69,82.00", --Sholazar Basin > Whisper of Frightened World Scenario
			":627::39.48,57.31:702::49.80,80.71:cls:PRIEST:fac:Alliance", --Dalaran <-> Halls of Shadow 
			":627::63.00,17.70:702::49.80,80.71:cls:PRIEST:fac:Horde", --Dalaran <-> Halls of Shadow 						
		}, -- Instances
	}
	
	TaxiData.BoatData = 
	{
		[1] = {
			"84::955813727:57::2362896356:270:Boat:fac:Alliance", --Stormwind City - Teldrassil 50s
			"56::272670565:70::3073413201:264:Boat:fac:Alliance", --Wetlands - Dustwallow Marsh 48s
			"97::875530934:62::2245715211:292:Boat:fac:Alliance", --Azuremist Isle - Ashenvale 56s
			"62::2245715211:97::875530934:296:Boat:fac:Alliance", --Ashenvale - Azuremist Isle 60s

			"210::1678683040:10::3012803443:282:Boat", ----Booty Bay - Ratchet - 58s

			"50::1593804318:85::2254211082:280:Zeppelin:fac:Horde", -- Northern Stranglethorn - Orgrimmar
			"18::2606863965:85::2181467902:290:Zeppelin:fac:Horde", -- Tirisfal - Orgrimmar
			"114::1777174847:85::1924243316:392:Zeppelin:fac:Horde", -- Borean Tundra - Orgrimmar - 110s
		},
		[2] = {
			"57::2362896356:84::955813727:270:Boat:fac:Alliance", --Teldrassil - Stormwind City 50s
			"70::3073413201:56::272670565:264:Boat:fac:Alliance", --Dustwallow Marsh - Wetlands
			"114::2567090641:84::760365605:315:Boat:fac:Alliance", --Borean Tundra - Stormwind City 55s	
			"117::2637144144:56::201690863:541:Boat:fac:Alliance", --Howling Fjord - Stormwind City 110s

			"85::2181467902:18::2606863965:310:Zeppelin:fac:Horde", -- Orgrimmar - Tirisfal
			"85::2254211082:50::1593804318:290:Zeppelin:fac:Horde", -- Orgrimmar - Stranglethorn,	

			"10::3012803443:210::1678683040:270:Boat", --Ratchet - Booty Bay - 46s

			"50::1610252894:18::2656081735:422:Zeppelin:fac:Horde", --Stranglethorn - Tirisfal
			"18::2656081735:50::1610252894:379:Zeppelin:fac:Horde", --Tirisfal - Stranglethorn
			"117::3337701479:18::2535495452:245:Zeppelin:fac:Horde", -- Howling Fjord - Tirisfal Glades - 40s
			"87::3281945379:84::2979483730:100:Tram:fac:Alliance", --Deeprun Tram
			"84::2979483730:87::3281945379:100:Tram:fac:Alliance",
			"74:17:55.01,28.08:75:18:47.49,37.22:54:Steward of Time:qid:10279", --Timeless Tunnel 
		},
		[1467] = {
		},
		[4] = {
			"84::760365605:114::2567090641:345:Boat:fac:Alliance", --Stormwind City - Borean Tundra 85s
			"56::201690863:117::2637144144:632:Boat:fac:Alliance", --Stormwind City - Howling Fjord 201s

			"85::1924243316:114::1777174847:334:Zeppelin:fac:Horde", -- Orgrimmar - Borean Tundra - 52s
			"18::2535495452:117::3337701479:250:Zeppelin:fac:Horde", -- Tirisfal - Howling Fjord - 45s

			"115::2131282115:117::1009226723:686:Boat", --Moa'ki Harbor - Kamagua - 190s
			"117::1009226723:115::2131282115:682:Boat", --Kamagua - Moa'ki Harbor - 186s
			"114::3388442954:115::2059323792:601:Boat", -- Unu'pe - Moa'ki Harbor - 157s
			"115::2059323792:114::3388442954:611:Boat", -- Moa'ki Harbor - Unu'pe - 167s
		},
		[5] = {
		},
		[6] = {
		},
		[7] = {
			"534::60.02,47.43:534::55.59,27.17:29:B2 Personnel Relocator:qid:38599:fac:Horde", -- B-2 Personnel Relocator  - Vol'mar (Tanaan) > Throne of Kil'jaeden - 29s
			"534::57.67,58.73:534::55.51,27.29:29:Gnomish Flying Machine:qid:38603:fac:Alliance", -- Gnomish Flying Machine  - Lion's Watch (Tanaan) > Throne of Kil'jaeden - 29s			
		}, --Draenor
		[8] = {
			"627::72.77,41.30:739::36.64,27.83:11:Great Eagle:cls:HUNTER:qid:40959",--Great Eagle - Dalaran > Trueshot Lodge -6s Hunter only
		}, --Broken Isle
		[9] = {
		}, --Argus
		[10] = {
		},	--Reserve
		[11] = {
		},	--Reserve
		[12] = {
		},	-- Instances
	}
	
	--Debug ShowLocation:  player location=38::3259134883
	--Debug ShowLocation:  player location=687::2146904192
	--465::2046724389 ramparts 797
	TaxiData.InstancePortals = 
	{
		[349] = "122::61.22,30.87:349::42.53,90.01",
		[577] = "17::54.94,53.88:577::54.73,48.27:lvl:90:qid:34398",--Blasted Lands Dark Portal > Tanaan Jungle Intro 
		[220] = "51::3259134883:220::2146904192",
		[301] = "199::1748955555:301::3001799783",
		[318] = "23::1185816005:317::2921456245/23::1882008728:318::2909461735", --Main/Service
		[242] = "35::1717971845:242::1490339627",
		[325] = "249::3299006578:325::2324441864",
		[246] = "100::2039252267:246::2625957271",
		[133] = "117::2460186528:133::2975120097",
		[138] = "120::1949054645:138::316967360",
		[256] = "108::1473161206:256::1894957121",
		[260] = "108::1702083690:260::945299423",
		[262] = "102::2331269136:262::1274785221",
		[265] = "102::2102352740:265::856826426",
		[267] = "109::3033117347:267::2122175945",
		[272] = "108::1702531976:272::1439640643",
		[347] = "100::2043971888:347::2150085669",
		[274] = "75::1155357671:274::997736316",
		[453] = "390::3474609012:453::1228354551",
		[157] = "115::1114997325:157::405466854",
		[279] = "11::2375133036:279::1967102164",
		[225] = "84::2165549504:225::2150477391",
		[444] = "379::1576237465:444::3646459805/379::1576237465:444::3646459805",
		[435] = "19::2980659265:435::3251270975",
		[280] = "68::1902691418:281::1206868705/68::2250521837:280::3370692411/67:21:3367275921:280::2669758500", --Pristine Waters/Purple/Orange
		[219] = "71::1684485747:219::2430986452",
		[226] = "30::1288486715:226::2762951203",
		[291] = "55::1108116176:291::1138172493",
		[476] = "22::2967845535:476::777427943/22::2964830866:476::1678481470",
		[300] = "64::2046508171:300::1021784096",
		[235] = "69::64.84,30.22:239::288186885/69::2590265376:236::4012360269/69::2684764087:235::3055021942",
		[310] = "21::1922018698:310::2983304213",
		[258] = "108::1930602486:258::3150339420",
		[324] = "207::2048689425:324::2330914914",
		[261] = "100::1973519561:261::2050877397",
		[129] = "114::1181106818:129::1554833735",
		[132] = "115::1222804583:132::3822111372",
		[136] = "117::2459268979:136::1910778180",
		[140] = "120::1696482538:140::1477467308",
		[142] = "114::1181106818:142::2632808910",
		[153] = "121::3269342625:153::2533576487",
		[253] = "36::80.4,40.7:253::37.9,41.5",
		[160] = "121::1224924810:160::1261883201",
		[168] = "125::2946348082:168::1982135028",
		[263] = "102::2159957331:263::755452975",
		[266] = "109::3082063006:266::3847842096",
		[269] = "109::3199308713:269::1772146982",
		[273] = "75::1559090429:273::2235957346",
		[459] = "388::1490341986:459::2787434102",
		[439] = "376::1546170597:439::3410191777",
		[130] = "75::2465321844:130::3758536268",
		[429] = "371::2413794361:429::1348629299",
		[213] = "86::70.13,48.23:213::2680493100",
		[431] = "19::3371537661:431::1473177255",
		[277] = "249::2600641704:277::1364929268",
		[437] = "390::678608306:437::2632835268",
		[221] = "63::709499964:221::1902189386",
		[283] = "36::3006498930:283::1375253364",
		[230] = "16::1576226062:230::2878913059",
		[293] = "241::822053332:293::521834115",
		[297] = "249::2967373722:297::2143678450",
		[322] = "204::2984525817:322::2141053406",
		[338] = "198::27.50,56.29:338::52.96,83.85:qid:29199",
		[621] = "543::59.6,45.6:621::72.4,55.7",
		[573] = "525::49.6,24.6:573::51.5,83.3",
		[595] = "543::44.9,13.5:595::30.6,44.5",
		[593] = "535::46.4,73.8:593::49.7,90.2",
		[542] = "542::35.6,33.7:542::60.55,25.8",
		[606] = "543::55.05,31.3:606::32.4,31.9",
		[574] = "539::31.8,42.6:574::12.0,68.4",
		[616] = "36::78.95,34.08:616::37.1,32.5",		
		--Raid portals
		[232] = "36::54.1,83.1:232::26.5,24.3",
		[320] = "327::46.78,7.45:320::52.00,26.92",
		[247] = "327::58.92,14.29:247::60.51,11.70",
		[287] = "36::64.3,70.9:287::52.5,83.6",
		[350] = "42::47.0,74.9:350::58.8,76.1",
		[330] = "105::69.16,23.81:330::81.87,78.12",
		[331] = "100::47.49,52.09:331::62.72,18.04",
		[332] = "102::51.9,33.0:332::13.5,61.2",
		[334] = "109::73.8,63.7:334::50.0,90.6",
		[329] = "75::35.62,15.76:329::10.68,64.74",
		[341] = "104::71.03,46.39:341::21.89,59.54",
		[336] = "507::44.25,45.59:336::30.93,36.41",
		[248] = "70::52.93,77.72:248::33.99,20.75",
		[166] = "115::87.47,51.19:166::54.00,49.68",
		[166] = "115::87.47,51.19:166::54.00,49.68",
		[141] = "114::27.6,26.6:141::32.0,59.2",
		[148] = "120::41.57,17.74:148::52.68,95.01",
		[186] = "118::53.83,87.12:186::38.98,7.28",
		[172] = "118::75.10,21.79:172::63.95,52.45",
		[155] = "115::60.01,56.86:155::64.40,50.09",
		[200] = "115::61.26,52.67:200::48.99,29.42",
		[156] = "123::50.07,11.61:156::49.26,86.60",
		[410] = "75::61.75,26.60:410::50.10,84.43",
		[282] = "244::46.2,47.9:282::48.0,91.8",
		[328] = "249::38.5,80.5:328::47.2,75.8/748::38.5,80.5:328::47.2,75.8",
		[285] = "36::23.19,26.46:285::46.89,62.55",
		[294] = "241::34.04,77.91:294::39.38,54.24",
		[368] = "198::47.34,78.00:368::25.03,92.59",
		[456] = "433::48.43,61.56:456::93.32,49.34",
		[474] = "422::38.92,35.02:474::34.28,89.45",
		[471] = "379::59.57,39.25:471::75.22,74.09",
		[508] = "504::63.62,32.25:508::31.16,25.92",
		--Legion Order Halls
		[720] = "627::97.96,69.27:720::59.31,91.30:cls:DEMONHUNTER", --Dalaran <-> Mardum
		[695] = "627::75.18,47.16:695::58.34,24.98:cls:WARRIOR:qid:42815", --Dalaran <-> Skyhold
		[726] = "627::67.13,48.17:726::29.92,51.96:cls:SHAMAN", --Dalaran <-> Maelstrom
		[737] = "726::26.71,41.32:737::53.59,16.00:cls:SHAMAN:qid:43002",	-- Portal to Vortex Pinnacle
		[738] = "726::31.08,61.02:738::25.02,92.64:cls:SHAMAN:qid:42208",	-- Portal to the Firelands		
		[717] = "628::27.90,44.48:717::75.37,38.11:cls:WARLOCK", --Dalaran Underbelly <-> Dreadscar Rift
		[723] = "627::67.22,69.48:723::50.69,83.17",
		--Legion dungeons
		[732] = "627::67.50,69.78:732::50.93,82.09", -- The Violet Hold
		[751] = "641::37.15,50.24:751::29.21,6.35", -- Black Rook Hold
		[733] = "641::59.03,31.18:733::36.54,13.50", -- Darkheart Thicket
		[731] = "650::49.56,68.63:731::96.66,39.22", -- Netfal Lair
		[749] = "680::41.11,61.67:749::48.01,20.07", -- The Arcway
		[705] = "634::72.64,70.52:705::47.71,7.56", -- Hall of Valor
		[713] = "630::61.15,41.13:713::47.12,87.89", -- Eye of Azshara
		[707] = "634::52.54,45.25:707::47.18,81.20", -- Maw of Souls
		[710] = "630::48.07,82.13:710::69.38,77.47", -- Vault of the Wardens
		[762] = "680::50.99,65.59:762::10.20,69.30", -- Court of Stars	
	}
	
	function TaxiData:GetLookupTable()
		local DugisFlightmasterLookupTable_ = {
				["Horde"] = {
					[1] = {
						[1939506853] = 35140,
						[1646686700] = 35478,
						[2310458218] = 12740,
						[1930457152] = 2995,
						[2565650323] = 41861,
						[1807388684] = 41246,
						[2532477175] = 40558,
						[2437241789] = 11899,
						[2407969102] = 43481,
						[2221655382] = 43085,
						[1498315032] = 35562,
						[3178343768] = 43328,
						[2393798706] = 3615,
						[3032324273] = 37005,
						[1748700206] = 48273,
						[2137625487] = 34943,
						[2705690562] = 3310,
						[2505002193] = 40358,
						[2099335041] = 44399,
						[1600801893] = 41605,
						[2749416576] = 11139,
						[2657100164] = 41214,
						[2091691683] = 43079,
						[2239981108] = 52060,
						[2207657332] = 10583,
						[1900564059] = 39898,
						[3046482471] = 8610,
						[2776858543] = 41140,
						[1788097844] = 15178,
						[1750048793] = 11901,
						[1749251898] = 35556,
						[2119768530] = 48275,
						[2235324992] = 39330,
						[2216457329] = 39340,
						[2371033357] = 41215,
						[1716622299] = 35141,
						[1539995705] = 35315,
						[2023791849] = 34429,
						[1483955310] = 40473,
						[2084879558] = 43073,
						[2670042181] = 36728,
						[2169480865] = 22931,
						[1359768128] = 6726,
						[1752139522] = 4312,
						[2798679203] = 41142,
						[2608673339] = 7824,
						[2002609320] = 40809,
						[2325580167] = 34927,
						[2128950184] = 39175,
						[2626239730] = 40769,
						[2381223183] = 12616,
						[1796089025] = 48274,
						[1981709226] = 35139,
						[2601481071] = 16227,
						[1539999686] = 35315,
						[2137615472] = 34943,
						[2099359870] = 44399,
						[1749256389] = 35556,
						[1498318567] = 35562,
						[1752135933] = 4312,
						[1359779263] = 6726,
						[2119820845] = 48275,
						[1788136139] = 15178,
						[2023777046] = 34429,
						[3046464984] = 8610,
						[1900589476] = 39898,
						[2128989271] = 39175,
						[2749381503] = 11139,
						[1939503450] = 35140,
						[1483973521] = 40473,
						[1930465215] = 2995,
						[2084848441] = 43073,
						[2169461086] = 22931,
						[1796135742] = 48274,
						[1748759505] = 48273,
						[2091667804] = 43079,
						[2235344319] = 39330,
						[2532472584] = 40558,
						[2221619881] = 43085,
						[1600828314] = 41605,
						[2776858705] = 41140,
						[2002623319] = 40809,
						[2216463246] = 39340,
						[2657148539] = 41214,
						[2798685020] = 41142,
						[2626274061] = 40769,
						[1750032358] = 11901,
						[3032311630] = 37005,
						[1646693907] = 35478,
						[2670027706] = 36728,
						[2381212400] = 12616,
						[2371086066] = 41215,
						[2705682493] = 3310,
						[2393802701] = 3615,
						[2325575288] = 34927,
						[1981711445] = 35139,
						[2207699595] = 10583,
						[2310419605] = 12740,
						[2437260354] = 11899,
						[1716612132] = 35141,
						[2601487504] = 16227,
						[3178320551] = 43328,
						[1807380467] = 41246,
						[2608713156] = 7824,
						[2505028398] = 40358,
					}, -- [1]
					[2] = {
						[2192746602] = 2861,
						[2116137724] = 48321,
						[2318874107] = 6026,
						[1975949432] = 47665,
						[2533789001] = 4314,
						[1603312722] = 50463,
						[2539245533] = 16192,
						[2066522207] = 46004,
						[2091688833] = 46011,
						[2479247668] = 28621,
						[1982838015] = 48318,
						[2552981499] = 47116,
						[2618454681] = 47156,
						[2785638968] = 47061,
						[2626640099] = 12636,
						[1808016533] = 1387,
						[2482932769] = 47133,
						[2053614637] = 47875,
						[2116111619] = 48321,
						[1276272778] = 43216,
						[1310681638] = 40852,
						[2192725909] = 2861,
						[2231673892] = 37888,
						[2552993796] = 47116,
						[1753813642] = 2858,
						[2282270027] = 44233,
						[1203546511] = 40871,
						[2483039999] = 44244,
						[1190830934] = 40851,
						[2318912004] = 6026,
						[1600689968] = 2226,
						[1634111979] = 46552,
						[2380618851] = 44232,
						[2785641927] = 47061,
						[2479271627] = 28621,
						[1276288885] = 43216,
						[1960219334] = 2389,
						[1975936903] = 47665,
						[2621094050] = 24851,
						[2285951721] = 43114,
						[2674939944] = 29480,
						[2541136223] = 44230,
						[1275043705] = 43220,
						[2410036321] = 43086,
						[1634102804] = 46552,
						[1203525232] = 40871,
						[2053592018] = 47875,
						[2156023867] = 13177,
						[2485501917] = 16189,
						[1909814003] = 47644,
						[1678008431] = 44825,
						[2539204642] = 16192,
						[1678024592] = 44825,
						[1789894880] = 4551,
						[1951258765] = 43052,
						[2014293089] = 47927,
						[1190812841] = 40851,
						[1909820684] = 47644,
						[1275027590] = 43220,
						[2487703797] = 44231,
						[1993910101] = 3305,
						[1774364450] = 43124,
						[2353900130] = 44408,
						[2351330614] = 2851,
						[2250674868] = 43573,
						[2285905174] = 43114,
						[2156048324] = 13177,
						[2351336137] = 2851,
						[2533782198] = 4314,
						[2250665291] = 43573,
						[2482926558] = 47133,
						[2626660124] = 12636,
						[923838186] = 40873,
						[2621065053] = 24851,
						[1753869685] = 2858,
						[1764920717] = 47655,
						[2246062527] = 43121,
						[2541115040] = 44230,
						[1986621979] = 47661,
						[923818261] = 40873,
						[2407769986] = 44407,
						[2066314632] = 43104,
						[2282246836] = 44233,
						[2502954868] = 26560,
						[2014270366] = 47927,
						[1722213167] = 43053,
						[1940365895] = 37915,
						[1600678095] = 2226,
						[1993889962] = 3305,
						[2246102592] = 43121,
						[2407749757] = 44407,
						[1951213426] = 43052,
						[1789878047] = 4551,
						[2618461542] = 47156,
						[1808063338] = 1387,
						[2674960343] = 29480,
						[2380637084] = 44232,
						[1986629092] = 47661,
						[2231655387] = 37888,
						[1603298221] = 50463,
						[1982810880] = 48318,
						[1960209721] = 2389,
						[2485469218] = 16189,
						[1774344413] = 43124,
						[2467220021] = 44036,
						[2483081472] = 44244,
						[1940348344] = 37915,
						[1764913778] = 47655,
						[1722162384] = 43053,
						[2487723786] = 44231,
						[2410070942] = 43086,
						[2066505632] = 46004,
						[2091670654] = 46011,
						[2467182026] = 44036,
						[2066319991] = 43104,
						[1310692825] = 40852,
						[2353878429] = 44408,
						[2503012491] = 26560,
						[2483667227] = 16189,
						[2502226244] = 26560,
						[2773708612] = 47174,
						[2481115663] = 44244,
						[2464271191] = 44036,
						[2540622063] = 16192,
						[2627320308] = 24851,
						[2417522681] = 47121,
						[1585482455] = 45479,	
					}, -- [2]
					[1467] = {
						[2088412348] = 22455,
						[1809299595] = 22216,
						[2813755181] = 16587,
						[3087972485] = 20515,
						[1809758335] = 22216,
						[1879462931] = 18940,
						[1238261784] = 18808,
						[3375527608] = 18930,
						[2186364124] = 18807,
						[3088693370] = 20515,
						[2910019311] = 19558,
						[1879004184] = 18940,
						[2813034292] = 16587,
						[1909488729] = 20762,
						[1627368829] = 18953,
						[3376314033] = 18930,
						[2909298421] = 19558,
						[2299948583] = 18942,
						[2698891571] = 19583,
						[1237934110] = 18808,
						[998997764] = 18791,
						[2839821169] = 19317,
						[999259900] = 18791,
						[2186888408] = 18807,
						[2476128963] = 18938,
						[1909947474] = 20762,
						[2699612454] = 19583,
						[2476718775] = 18938,
						[2087888070] = 22455,
						[1627762035] = 18953,
						[3473422962] = 19581,
						[2840476525] = 19317,
						[2299424302] = 18942,
						[3472570998] = 19581,
						[3375532359] = 18930,
						[1909490598] = 20762,
						[2813034699] = 16587,
						[2476098876] = 18938,
						[2087869241] = 22455,
						[2299433425] = 18942,
						[1809270644] = 22216,
						[1627345538] = 18953,
						[3087943546] = 20515,
						[998998267] = 18791,
						[2186394403] = 18807,
						[2698849996] = 19583,
						[2839856270] = 19317,
						[2909315338] = 19558,
						[1879026663] = 18940,
						[1237950433] = 18808,
					}, -- [3]
					[4] = {
						[710965549] = 24795,
						[2662048826] = 29721,
						[3625614836] = 26853,
						[1945992653] = 26566,
						[3093804746] = 32571,
						[2122172959] = 33849,
						[2240194498] = 31069,
						[2998105025] = 26852,
						[783517659] = 26848,
						[3368656235] = 28624,
						[3112343855] = 28623,
						[710834483] = 24795,
						[2301327938] = 26851,
						[1346408695] = 30870,
						[2562693715] = 30269,
						[2387125203] = 30433,
						[1233942249] = 26847,
						[2462960145] = 29950,
						[3631629425] = 24155,
						[2731840556] = 28615,
						[1051105526] = 28574,
						[1346146558] = 30870,
						[3624893946] = 26853,
						[1619118336] = 30314,
						[783386594] = 26848,
						[2998694843] = 26852,
						[3194577076] = 26844,
						[4085472652] = 27344,
						[4084686224] = 27344,
						[2239735754] = 31069,
						[2737426576] = 29951,
						[2300869192] = 26851,
						[2555147128] = 26845,
						[2046267307] = 26850,
						[3590220211] = 24032,
						[2386666460] = 30433,
						[3150626508] = 29762,
						[2045874098] = 26850,
						[2117626883] = 28196,
						[2982384570] = 28618,
						[2117233672] = 28196,
						[635989542] = 25288,
						[3368000883] = 28624,
						[1246260764] = 28195,
						[3632284782] = 24155,
						[2554622845] = 26845,
						[3094394561] = 32571,
						[3589499320] = 24032,
						[1245998625] = 28195,
						[2562169435] = 30269,
						[2244910606] = 28674,
						[2982974387] = 28618,
						[519665918] = 27046,
						[1196800187] = 31078,
						[3195232431] = 26844,
						[2574303193] = 29757,
						[1234204387] = 26847,
						[2245369350] = 28674,
						[519796984] = 27046,
						[2731250740] = 28615,
						[1619446006] = 30314,
						[3172158153] = 28197,
						[2573778914] = 29757,
						[636120608] = 25288,
						[1196603588] = 31078,
						[2463418887] = 29950,
						[1051302126] = 28574,
						[2122566165] = 33849,
						[1946320327] = 26566,
						[3171568333] = 28197,
						[3111754039] = 28623,
						[2737950853] = 29951,
						[3150036693] = 29762,
						[2662573106] = 29721,
						[3513298943] = 30569,
						[3514019830] = 30569,
						[3111741128] = 28623,
						[2737385327] = 29951,
						[2662030277] = 29721,
						[1196574523] = 31078,
						[2998111294] = 26852,
						[783382557] = 26848,
						[4084703855] = 27344,
						[2573746205] = 29757,
						[2300872119] = 26851,
						[2117243895] = 28196,
						[3194593099] = 26844,
						[2244895217] = 28674,
						[2554629250] = 26845,
						[1945993778] = 26566,
						[1051092745] = 28574,
						[2982374469] = 28618,
						[2731240395] = 28615,
						[2386648100] = 30433,
						[3631659918] = 24155,
						[2122135008] = 33849,
						[1246007774] = 28195,
						[3513274368] = 30569,
						[2562155940] = 30269,
						[519669505] = 27046,
						[2462922222] = 29950,
						[3589510727] = 24032,
						[3367985804] = 28624,
						[1233946902] = 26847,
						[3150004522] = 29762,
						[635998681] = 25288,
						[3171595570] = 28197,
						[2045866061] = 26850,
						[3624894981] = 26853,
						[710837964] = 24795,
						[2386666460] = 30433,
					}, -- [4]
					[5] = {
					}, -- [5]
					[6] = {
						[2277268127] = 60231,
						[2621210092] = 60952,
						[926647860] = 62909,
						[2679068492] = 60232,
						[2675403544] = 60230,
						[2108657621] = 61745,
						[2267490683] = 60441,
						[1690732510] = 61473,
						[1306616602] = 63501,
						[1051022107] = 65511,
						[1663801820] = 60416,
						[1511492887] = 65863,
						[3007998314] = 64310,
						[3358949848] = 59732,
						[4109522603] = 71939,
						[1545025962] = 67785,
						[1013547100] = 62898,
						[2122154343] = 61122,
						[2002952869] = 61504,
						[1763661309] = 58843,
						[1478009660] = 61512,
						[2195630801] = 61118,
						[3318519372] = 59733,
						[2481350988] = 62658,
						[2518642760] = 61759,
						[1909207695] = 65189,
						[1198421130] = 63500,
						[1677618316] = 63497,
						[3106766785] = 59186,
						[3019674964] = 59736,
						[1432190566] = 62903,
						[3297079304] = 59727,
						[2383170682] = 59046,
						[2108472654] = 61511,
						[1870674713] = 59047,
						[1312376832] = 63498,
						[2335278021] = 61474,
						[2629017190] = 66227,
						[1363644994] = 62901,
						[3203306257] = 59735,
						[1763682818] = 58843,
						[2277287264] = 60231,
						[1306631397] = 63501,
						[2002935130] = 61504,
						[1477991619] = 61512,
						[1198426997] = 63500,
						[1432191385] = 62903,
						[1511486184] = 65863,
						[3203296494] = 59735,
						[2679089331] = 60232,
						[1690728481] = 61473,
						[2383197061] = 59046,
						[2195608878] = 61118,
						[2629001625] = 66227,
						[2267534980] = 60441,
						[1051045092] = 65511,
						[2108441265] = 61511,
						[2335276090] = 61474,
						[2675414247] = 60230,
						[1312405503] = 63498,
						[2122153624] = 61122,
						[1870709990] = 59047,
						[1663788579] = 60416,
						[3318507956] = 59733,
						[3358948903] = 59732,
						[3008009877] = 64310,
						[926644683] = 62909,
						[3019664043] = 59736,
						[1363635645] = 62901,
						[1909247344] = 65189,
						[1013546915] = 62898,
						[1677628275] = 63497,
						[3297087479] = 59727,
						[3106766910] = 59186,
					}, -- [6]
					[7] = {
						[3682508319] = 86049,
						[1327082146] = 76879,
						[2023007459] = 76784,
						[3033894337] = 90550,
						[2228714847] = 81057,
						[2849865920] = 90562,
						[1449557251] = 82346,
						[2051622078] = 82612,
						[2825928193] = 81285,
						[1781096451] = 81068,
						[2157790275] = 84498,
						[2010468491] = 84509,
						[2466469133] = 88584,
						[1137542115] = 88668,
						[2171191576] = 85829,
						[1194116485] = 76783,
						[1075622900] = 76781,
						[1508818438] = 76787,
						[2222091314] = 81354,
						[2856739411] = 76850,
						[1922921746] = 81064,
						[1031579647] = 76782,
						[1454743961] = 79407,
						[3105635144] = 83427,
						[1306363821] = 82844,
						[2339017462] = 84508,
						[2331543711] = 90552,
						[1863493000] = 87707,
						[2245775101] = 84700,
						[2796930990] = 88757,
						[2245610624] = 84515,
						[947878640] = 82340,
						[1397586424] = 83924,
						[2544154943] = 84714,
						[2305536368] = 86492,
						[2308613451] = 81055,
						[2407482689] = 84504,
						[2208208390] = 84495,
						[1988720216] = 81058,
						[2562429398] = 90560,
						[1974101381] = 81078,
						[2082703637] = 81053,
						[2608759988] = 92809,
						[2377744351] = 80932,
						[946039438] = 88653,
						[2800652311] = 92808,
						[1512944010] = 78699,
						[2390045142] = 82511,		
					}, -- [7]
					[8] = {
						[1978711876] = 111323,
						[2384041580] = 120118,
						[18995436] = 88110,
						[564959682] = 100468,
						[2547805550] = 98105,
						[1093419261] = 111675,
						[-174683914] = 93940,
						[809891352] = 109572,
						[684135089] = 97870,
						[1291646671] = 109469,
						[980554536] = 97868,
						[-627476601] = 114837,
						[2296628156] = 109451,
						[257455014] = 111418,
						[2574732264] = 111420,
						[1491993053] = 97860,
						[1050471725] = 94973,
						[176908820] = 93447,
						[3583901196] = 111314,
						[2067685090] = 109457,
						[895666011] = 100550,
						[800585275] = 98968,
						[1302172265] = 96565,
						[2099122421] = 109467,
						[1932349851] = 114718,
						[1932153259] = 114718,
						[1642108020] = 98966,
						[1286592907] = 95688,
						[1491599927] = 97860,
						[-118429483] = 109571,
						[849831990] = 114666,
						[229603755] = 109558,
						[1684156675] = 98972,
						[137006010] = 108888,
						[143458971] = 90556,
						[2904263091] = 93465,
						[224955037] = 100459,
						[1326034001] = 96813,
						[1726859689] = 100559,
						[-106613654] = 90639,
						[1634845258] = 109789,
						[1977794372] = 111323,
						[2726404212] = 98161,
						[402305259] = 112866,
						[2269547839] = 92560,
						[2474296903] = 111327,
						[2021969766] = 98124,
						[-405286328] = 110971,
						[1060574754] = 112926,
						[1108567104] = 98066,
						[-647374160] = 109561,
						[654770499] = 111624,
						[-149302116] = 107457,
						[1888714003] = 120272,
					}, -- [8]        
					[9] = {
						[1466046384] = 125410,
						[2269085877] = 122509,
						[3006054690] = 123260,
						[2549596973] = 124313,
						[1526882578] = 125514,
						[3690196369] = 123139,
						[1640058734] = 123258,
						[3574901573] = 124569,
						[2019823281] = 125350,
						[2019881294] = 125350,
						[3391801083] = 118830,
						[3391764740] = 118830,
						[3690140270] = 123139,
						[2107614615] = 126951,
						[2269085514] = 122509,
						[1475131416] = 125407,
						[3006021341] = 123260,
						[2549562578] = 124313,
						[1475102695] = 125407,
						[1640083601] = 123258,
						[2235929843] = 125461,
						[2235919116] = 125461,
						[2107595368] = 126951,
						[1526898413] = 125514,
						[3574879418] = 124569,
						[1466099791] = 125410,			
					}, -- [9]
					},
				["Alliance"] = {
					[1] = {
						[1985380184] = 35136,
						[2266480180] = 12578,
						[2374617930] = 10897,
						[1762645253] = 3838,
						[2772550740] = 11138,
						[1664389997] = 4407,
						[1909673696] = 33253,
						[1753123674] = 41240,
						[2626274061] = 40768,
						[2206172846] = 39210,
						[2266448331] = 12578,
						[2600718012] = 7823,
						[1992528097] = 34378,
						[890782121] = 17555,
						[1549578787] = 41383,
						[2119820845] = 48275,
						[1048003660] = 43991,
						[2505028398] = 40358,
						[1909698847] = 33253,
						[2128950184] = 39175,
						[1763239087] = 40553,
						[1753117861] = 41240,
						[1799501241] = 15177,
						[2128989271] = 39175,
						[1591368666] = 40966,
						[946852292] = 17554,
						[1480889594] = 35481,
						[1763187536] = 40553,
						[2732676252] = 4321,
						[1480878853] = 35481,
						[2119768530] = 48275,
						[2084848441] = 43073,
						[2169461086] = 22931,
						[1859357231] = 35137,
						[1674884687] = 41580,
						[1701805647] = 6706,
						[946810427] = 17554,
						[1748700206] = 48273,
						[1922648138] = 40367,
						[2339134390] = 39211,
						[1762601722] = 3838,
						[2207657332] = 10583,
						[2500828262] = 22935,
						[2657100164] = 41214,
						[2601481071] = 16227,
						[2564266367] = 39212,
						[1820285527] = 34374,
						[2657148539] = 41214,
						[2772515755] = 11138,
						[1664380050] = 4407,
						[1591387173] = 40966,
						[1985380519] = 35136,
						[1580500758] = 35138,
						[1820304808] = 34374,
						[2505002193] = 40358,
						[1986763412] = 4267,
						[2564253312] = 39212,
						[1674856880] = 41580,
						[2732698467] = 4321,
						[2339152969] = 39211,
						[890814038] = 17555,
						[1796089025] = 48274,
						[1796135742] = 48274,
						[1922676661] = 40367,
						[2374579381] = 10897,
						[2091691683] = 43079,
						[1799539270] = 15177,
						[1993356465] = 3841,
						[2207699595] = 10583,
						[1498315032] = 35562,
						[2626239730] = 40768,
						[2457003777] = 40827,
						[1993395022] = 3841,
						[2091667804] = 43079,
						[1749251898] = 35556,
						[1646686700] = 35478,
						[1048034227] = 43991,
						[2500813721] = 22935,
						[2601487504] = 16227,
						[2084879558] = 43073,
						[1549553116] = 41383,
						[1859352016] = 35137,
						[1473045937] = 40552,
						[1986749803] = 4267,
						[2206169425] = 39210,
						[2600677699] = 7823,
						[1701806512] = 6706,
						[2456951038] = 40827,
						[1646693907] = 35478,
						[2169480865] = 22931,
						[1748759505] = 48273,
						[1472993870] = 40552,
						[1749256389] = 35556,
						[1498318567] = 35562,
						[1992519454] = 34378,
						[1580497129] = 35138,
						[2565650323] = 41861,
						[2246423335] = 53783,
						[1039449084] = 43991,
						[2307631897] = 54393,
						[2635704202] = 43549,
						[884260542] = 17555,
						[939578135] = 17554,
						[2407969102] = 50084,
					}, -- [1]
					[2] = {
						[1982838015] = 48318,
						[2342203432] = 8609,
						[2091670654] = 46011,
						[2282246836] = 44233,
						[1891557145] = 43042,
						[2479247668] = 28621,
						[2024718667] = 43000,
						[2002151442] = 1573,
						[1842551305] = 43043,
						[2204927976] = 2835,
						[2464178316] = 41332,
						[2126547383] = 41323,
						[2835060811] = 47119,
						[2674939944] = 29480,
						[2410070942] = 43086,
						[2238606942] = 41321,
						[2235266442] = 41322,
						[1246061497] = 43290,
						[2021039910] = 46006,
						[2407749757] = 44407,
						[2402011014] = 43087,
						[2238232427] = 2299,
						[2538040796] = 47118,
						[1310692825] = 40852,
						[2502954868] = 26560,
						[1982810880] = 48318,
						[2626312417] = 12617,
						[2668008001] = 47147,
						[2337036369] = 44409,
						[2282270027] = 44233,
						[2252914953] = 43371,
						[2018036361] = 2409,
						[2065260580] = 43702,
						[2667998654] = 47147,
						[2348694842] = 43072,
						[2162606305] = 931,
						[2265129342] = 43107,
						[2621094050] = 24851,
						[2503012491] = 26560,
						[1817166060] = 42983,
						[2014270366] = 47927,
						[1187358689] = 40867,
						[2014293089] = 47927,
						[2238204052] = 2299,
						[2265177729] = 43107,
						[1945800380] = 1571,
						[2348729029] = 43072,
						[1639857018] = 42406,
						[2213237863] = 44410,
						[2380618851] = 44232,
						[2004068175] = 2941,
						[2639234297] = 47155,
						[2621065053] = 24851,
						[2126542408] = 41323,
						[2266799426] = 1572,
						[1817132819] = 42983,
						[2213260184] = 44410,
						[1842603510] = 43043,
						[2266784445] = 1572,
						[1862193638] = 43045,
						[2410036321] = 43086,
						[1891508454] = 43042,
						[2252881654] = 43371,
						[2091688833] = 46011,
						[1982838015] = 48318,
						[1639892101] = 42406,
						[1246075974] = 43290,
						[2442106293] = 43570,
						[1756806055] = 352,
						[1187338270] = 40867,
						[2538050083] = 47118,
						[2255275778] = 43088,
						[2162573086] = 931,
						[2479271627] = 28621,
						[2626332446] = 12617,
						[2541115040] = 44230,
						[943434347] = 40866,
						[2407769986] = 44407,
						[1903664994] = 43701,
						[1675610844] = 523,
						[1760619959] = 2859,
						[2487723786] = 44231,
						[2043124534] = 12596,
						[1945792835] = 1571,
						[1599746623] = 42426,
						[1190830934] = 40851,
						[2835048372] = 47119,
						[2380637084] = 44232,
						[1190812841] = 40851,
						[2116137724] = 48321,
						[2002163693] = 1573,
						[2128505483] = 8018,
						[2065276891] = 43702,
						[2574616842] = 47154,
						[2674960343] = 29480,
						[2235271797] = 41322,
						[2128516468] = 8018,
						[1862151705] = 43045,
						[2043110601] = 12596,
						[1599786432] = 42426,
						[2639231750] = 47155,
						[1903648925] = 43701,
						[2464194419] = 41332,
						[2442095178] = 43570,
						[2231673892] = 37888,
						[2401974393] = 43087,
						[2487703797] = 44231,
						[1310681638] = 40852,
						[2197324974] = 41325,
						[1675572515] = 523,
						[2017998198] = 2409,
						[2342244311] = 8609,
						[2197322577] = 41325,
						[1756775512] = 352,
						[2255239421] = 43088,
						[1760563784] = 2859,
						[2024685236] = 43000,
						[2053614637] = 47875,
						[2337056686] = 44409,
						[1790037123] = 43697,
						[1789997948] = 43697,
						[2541136223] = 44230,
						[2053592018] = 47875,
						[2238615969] = 41321,
						[2204923927] = 2835,
						[2574612213] = 47154,
						[2231655387] = 37888,
						[2021023961] = 46006,
						[1248173027] = 43287,
						[1248158748] = 43287,
						[2116111619] = 48321,
						[2004048048] = 2941,
						[943412628] = 40866,
						[2627320308] = 24851,
						[2502226244] = 26560,
						[1244353240] = 43295,
						[2417522681] = 47121,
					}, -- [2]
					[1467] = {
						[2379299865] = 18809,
						[2698891571] = 19583,
						[2476128963] = 18938,
						[2250211687] = 18785,
						[2783734882] = 16822,
						[3087972485] = 20515,
						[2379334630] = 18809,
						[1879004184] = 18940,
						[1612349158] = 18788,
						[1798545715] = 21107,
						[1809270644] = 22216,
						[2783744925] = 16822,
						[1612349721] = 18788,
						[3377695844] = 18931,
						[3377689499] = 18931,
						[2250210968] = 18785,
						[2980108457] = 18939,
						[2476098876] = 18938,
						[1356552189] = 18937,
						[2698849996] = 19583,
						[1356572674] = 18937,
						[1144942947] = 22485,
						[1798528716] = 21107,
						[1879026663] = 18940,
						[1177796227] = 18789,
						[3087943546] = 20515,
						[1177764220] = 18789,
						[1809299595] = 22216,
						[2980063062] = 18939,
						[1144950428] = 22485,
						[1145212563] = 22485,
						[3473422962] = 19581,
						[1879462931] = 18940,
						[3088693370] = 20515,
						[1612742366] = 18788,
						[2784455771] = 16822,
						[2379824149] = 18809,
						[2250735248] = 18785,
						[3378541460] = 18931,
						[2699612454] = 19583,
						[1356900343] = 18937,
						[3472570998] = 19581,
						[3214442547] = 20234,
						[2980783955] = 18939,
						[2476718775] = 18938,
						[1809758335] = 22216,
						[3215228971] = 20234,
						[1799004456] = 21107,
						[1178026360] = 18789,
					}, -- [3]
					[4] = {
						[1816426448] = 26881,
						[2244895217] = 28674,
						[1051105526] = 28574,
						[2117233672] = 28196,
						[2514063659] = 30271,
						[2731250740] = 28615,
						[1979025961] = 26877,
						[1196603588] = 31078,
						[3171568333] = 28197,
						[1816430639] = 26881,
						[2386648100] = 30433,
						[932864864] = 26879,
						[2462960145] = 29950,
						[3367985804] = 28624,
						[2662030277] = 29721,
						[3761223885] = 23736,
						[519669505] = 27046,
						[2562620227] = 26878,
						[1051092745] = 28574,
						[710834483] = 24795,
						[1762693695] = 30869,
						[1762684352] = 30869,
						[2562622652] = 26878,
						[3513274368] = 30569,
						[2300869192] = 26851,
						[2117243895] = 28196,
						[1245998625] = 28195,
						[932879519] = 26879,
						[2662048826] = 29721,
						[3134486235] = 26880,
						[2122172959] = 33849,
						[3766445740] = 24061,
						[3551163978] = 26876,
						[2737385327] = 29951,
						[1246007774] = 28195,
						[2737426576] = 29951,
						[3282742263] = 23859,
						[894205406] = 26602,
						[2441522221] = 29750,
						[2731240395] = 28615,
						[3171595570] = 28197,
						[3551168949] = 26876,
						[894206497] = 26602,
						[2982374469] = 28618,
						[3282719752] = 23859,
						[3368000883] = 28624,
						[710837964] = 24795,
						[3513298943] = 30569,
						[3111741128] = 28623,
						[2244910606] = 28674,
						[3134490916] = 26880,
						[3761194802] = 23736,
						[3766458707] = 24061,
						[1196574523] = 31078,
						[2300872119] = 26851,
						[2441499602] = 29750,
						[2122135008] = 33849,
						[2462922222] = 29950,
						[2514054868] = 30271,
						[1979020758] = 26877,
						[2982384570] = 28618,
						[519665918] = 27046,
						[3111754039] = 28623,
						[2386666460] = 30433,
						[752327275] = 28037,
						[710965549] = 24795,
						[1051302126] = 28574,
						[3093804746] = 32571,
						[2240194498] = 31069,
						[3368656235] = 28624,
						[3112343855] = 28623,
						[2301327938] = 26851,
						[2387125203] = 30433,
						[752196211] = 28037,
						[2731840556] = 28615,
						[1619118336] = 30314,
						[3172158153] = 28197,
						[2239735754] = 31069,
						[1979419170] = 26877,
						[894337563] = 26602,
						[2245369350] = 28674,
						[2563078973] = 26878,
						[3761915694] = 23736,
						[2514522404] = 30271,
						[1816819658] = 26881,
						[3767166631] = 24061,
						[1246260764] = 28195,
						[2441980965] = 29750,
						[933061467] = 26879,
						[1763021368] = 30869,
						[519796984] = 27046,
						[2117626883] = 28196,
						[2982974387] = 28618,
						[3094394561] = 32571,
						[3551889838] = 26876,
						[3514019830] = 30569,
						[2737950853] = 29951,
						[1619446006] = 30314,
						[2463418887] = 29950,
						[2122566165] = 33849,
						[3135076053] = 26880,
						[1196800187] = 31078,
						[2662573106] = 29721,
						[3283309572] = 23859,
					}, -- [4]
					[5] = {
					}, -- [5]
					[6] = {
						[1763682818] = 58843,
						[3318519372] = 59733,
						[2277287264] = 60231,
						[1306631397] = 63501,
						[1805695363] = 59048,
						[2675403544] = 60230,
						[3297079304] = 59727,
						[926647860] = 62909,
						[1051022107] = 65511,
						[1478009660] = 61512,
						[3358948903] = 59732,
						[2481362611] = 62658,
						[1198426997] = 63500,
						[3019674964] = 59736,
						[1909207695] = 65189,
						[1677618316] = 63497,
						[1432191385] = 62903,
						[1651219345] = 65865,
						[2481350988] = 62658,
						[3203296494] = 59735,
						[2277268127] = 60231,
						[2527377622] = 59049,
						[1690732510] = 61473,
						[2679089331] = 60232,
						[3007998314] = 64310,
						[1690728481] = 61473,
						[2324329135] = 61121,
						[2267490683] = 60441,
						[1198421130] = 63500,
						[3081742138] = 66023,
						[1432190566] = 62903,
						[3081722053] = 66023,
						[2518650807] = 61759,
						[2195608878] = 61118,
						[1312376832] = 63498,
						[3358949848] = 59732,
						[2335276090] = 61474,
						[3203306257] = 59735,
						[1306616602] = 63501,
						[2267534980] = 60441,
						[2518642760] = 61759,
						[1805665916] = 59048,
						[1051045092] = 65511,
						[1363635645] = 62901,
						[1909247344] = 65189,
						[2108472654] = 61511,
						[2324335952] = 61121,
						[1013547100] = 62898,
						[1312405503] = 63498,
						[3106766910] = 59186,
						[3106766785] = 59186,
						[2108441265] = 61511,
						[3008009877] = 64310,
						[3318507956] = 59733,
						[3019664043] = 59736,
						[1763661309] = 58843,
						[3382139745] = 56737,
						[3382158494] = 56737,
						[1651205230] = 65865,
						[2335278021] = 61474,
						[2679068492] = 60232,
						[926644683] = 62909,
						[2527348521] = 59049,
						[2195630801] = 61118,
						[1363644994] = 62901,
						[2675414247] = 60230,
						[2002935130] = 61504,
						[2002952869] = 61504,
						[1013546915] = 62898,
						[1677628275] = 63497,
						[3297087479] = 59727,
						[1477991619] = 61512,
						[1663801820] = 60416,
						[1833974186] = 67785,
						[1916374186] = 61744,
						[2876196273] = 68226,
						[4120529915] = 71940,
					}, -- [6]
					[7] = {
						[2857654484] = 76840,
						[2796930990] = 88757,
						[3098039271] = 76851,
						[2316407185] = 84507,
						[2849865920] = 90562,
						[3086507483] = 81289,
						[3291631833] = 86685,
						[2800652311] = 92808,
						[3655828487] = 85959,
						[1157329663] = 82309,
						[2825928193] = 81285,
						[1781096451] = 81068,
						[2157790275] = 84498,
						[1979409659] = 81077,
						[2466469133] = 88584,
						[1142914900] = 81250,
						[3057536127] = 81284,
						[1137542115] = 88668,
						[2993653503] = 90960,
						[1508818438] = 76787,
						[2222091314] = 81354,
						[2856739411] = 76850,
						[2390045142] = 82511,
						[2592696226] = 81103,
						[2305536368] = 86492,
						[2245610624] = 84515,
						[1306363821] = 82844,
						[1922921746] = 81064,
						[2083562462] = 84993,
						[2695933771] = 81884,
						[2562429398] = 90560,
						[2340129309] = 91940,
						[2043361547] = 83567,
						[2770357642] = 76839,
						[1397586424] = 83924,
						[2110160818] = 81061,
						[2407482689] = 84504,
						[2212987478] = 81060,
						[2245775101] = 84700,
						[3105635144] = 83427,
						[2377744351] = 80932,
						[2544154943] = 84714,
						[2372758630] = 81067,
						[2317328129] = 81888,
						[2608759988] = 92809,
						[966296888] = 87395,
						[946039438] = 88653,
						[2454760877] = 81074,
						[2010468491] = 84509,
						[2171191576] = 85829,
					}, -- [7]
					[8] = {
						[1978711876] = 111323,
						[2384041580] = 120118,
						[18995436] = 88110,
						[564959682] = 100468,
						[1093419261] = 111675,
						[-174683914] = 93940,
						[809891352] = 109572,
						[684135089] = 97870,
						[1291646671] = 109469,
						[980554536] = 97868,
						[-627476601] = 114837,
						[2296628156] = 109451,
						[257455014] = 111418,
						[2574732264] = 111420,
						[1050471725] = 94973,
						[1634845258] = 109789,
						[3583901196] = 111314,
						[2067685090] = 109457,
						[895666011] = 100550,
						[800585275] = 98968,
						[1302172265] = 96565,
						[2099122421] = 109467,
						[143458971] = 90556,
						[1932153259] = 114718,
						[1642108020] = 98966,
						[2726404212] = 98161,
						[1938530605] = 98114,
						[3062008817] = 98108,
						[-118429483] = 109571,
						[849831990] = 114666,
						[229603755] = 109558,
						[1684156675] = 98972,
						[1932349851] = 114718,
						[2904263091] = 93465,
						[176908820] = 93447,
						[224955037] = 100459,
						[1286592907] = 95688,
						[1726859689] = 100559,
						[-106613654] = 90639,
						[137006010] = 108888,
						[1977794372] = 111323,
						[1491599927] = 97860,
						[402305259] = 112866,
						[-647374160] = 109561,
						[2474296903] = 111327,
						[2049147486] = 98113,
						[-405286328] = 110971,
						[1060574754] = 112926,
						[1108567104] = 98066,
						[1326034001] = 96813,
						[654770499] = 111624,
						[-149302116] = 107457,
						[1888714003] = 120272,
					}, -- [8]        
					[9] = {
						[1466046384] = 125410,
						[2269085877] = 122509,
						[3006054690] = 123260,
						[2549596973] = 124313,
						[1526882578] = 125514,
						[3690196369] = 123139,
						[1640058734] = 123258,
						[3574901573] = 124569,
						[2019823281] = 125350,
						[2019881294] = 125350,
						[3391801083] = 118830,
						[3391764740] = 118830,
						[3690140270] = 123139,
						[2107614615] = 126951,
						[2269085514] = 122509,
						[1475131416] = 125407,
						[3006021341] = 123260,
						[2549562578] = 124313,
						[1475102695] = 125407,
						[1640083601] = 123258,
						[2235929843] = 125461,
						[2235919116] = 125461,
						[2107595368] = 126951,
						[1526898413] = 125514,
						[3574879418] = 124569,
						[1466099791] = 125410,
					}, -- [9]
					}
	}

				--Merging tables
		if not DugisFlightmasterLookupTable then
			DugisFlightmasterLookupTable = {}
		end
		local faction = UnitFactionGroup("player")
		for faction, factionData in pairs(DugisFlightmasterLookupTable_) do
			if not DugisFlightmasterLookupTable[faction] then
				DugisFlightmasterLookupTable[faction] = {}
			end

			for continentId, continentData in pairs(factionData or {}) do
				if not DugisFlightmasterLookupTable[faction][continentId] then
					DugisFlightmasterLookupTable[faction][continentId] = {}
				end

				for coords, npcId in pairs(continentData or {}) do
					DugisFlightmasterLookupTable[faction][continentId][coords] = npcId
				end	
			end
		end
		local faction = UnitFactionGroup("player")
		return DugisFlightmasterLookupTable[faction]
	end
	

	function TaxiData:Load()
	end
	
	function TaxiData:Unload()
	end
    
    function TaxiData:IsFerryMaster(npcId)
        local ferryMastersList = {
        } 
        
        return npcId and ferryMastersList[npcId]
    end
	
end
