DugisGearFinder = {}

local DGV = DugisGuideViewer
local DugisGearFinder = DugisGearFinder
local LuaUtils = _G.LuaUtils

-------- Configuration ----------

DugisGearFinder.optimized = true


--Classes used for filtering purposes
local ANY = -1
local WARRIOR     = 1
local PALADIN     = 2
local HUNTER      = 3
local ROGUE       = 4
local PRIEST      = 5
local DEATHKNIGHT = 6
local SHAMAN      = 7
local MAGE        = 8
local WARLOCK     = 9
local MONK        = 10
local DRUID       = 11
local DEMONHUNTER = 12

---------------------------------

if not DugisGearFinderData then
   DugisGearFinderData = {}
   

   DugisGearFinderData["Blackfathom Deeps (20-24)"] = {
      dungeonmap=719, normal=1,
      { boss="4887", name="Ghamoo-ra",
      ALL={
      6907,
      6908,
      },
      },
      { boss="4831", name="Lady Sarevess",
      ALL={
      888,
      3078,
      11121,
      },
      },
      { boss="6243", name="Gelihast",
      ALL={
      6906,
      6905,
      1470,
      },
      },
      { boss="12876", name="Baron Aquanis",
      ALL={
      16782,
      },
      },
      { boss="4832", name="Twilight Lord Kelris",
      ALL={
      1155,
      6903,
      },
      },
      { boss="4830", name="Old Serra'kis",
      ALL={
      6901,
      6904,
      6902,
      },
      },
      { boss="4829", name="Aku'mai",
      ALL={
      6911,
      6910,
      6909,
      },
      },
      }
      DugisGearFinderData["Blackrock Depths: Prison (52-55)"] = {
      dungeonmap=1584, normal=1,
      { boss="9025", name="Lord Roccor",
      ALL={
      22234,
      11632,
      11631,
      22397,
      11630,
      11813,
      },
      },
      { boss="9018", name="High Interrogator Gerstahn ",
      ALL={
      11623,
      11624,
      22240,
      11625,
      11140,
      },
      },
      { boss="9319", name="Houndmaster Grebmar",
      ALL={
      11626,
      11627,
      11628,
      11629,
      },
      },
      { boss="9027", name="Gorosh the Dervish",
      ALL={
      11726,
      11729,
      11730,
      11728,
      11731,
      22271,
      22257,
      22266,
      },
      },
      { boss="9028", name="Grizzle",
      ALL={
      11722,
      11703,
      22270,
      11702,
      11610,
      },
      },
      { boss="9029", name="Eviscerator",
      ALL={
      11685,
      11679,
      11686,
      },
      },
      { boss="9030", name="Ok'thor the Breaker",
      ALL={
      11665,
      11662,
      11824,
      },
      },
      { boss="9031", name="Anub'shiah",
      ALL={
      11678,
      11677,
      11675,
      },
      },
      { boss="9032", name="Hedrum the Creeper",
      ALL={
      11633,
      11634,
      11635,
      },
      },
      { boss="9024", name="Pyromancer Loregrain",
      ALL={
      11747,
      11749,
      11748,
      11750,
      11207,
      },
      },
      { boss="9438", name="Dark Coffer",
      ALL={
      11197,
      22256,
      22205,
      22255,
      22254,
      11923,
      11945,
      11946,
      11752,
      11751,
      11753,
      },
      },
      { boss="9041", name="Warder Stilgiss",
      ALL={
      11782,
      22241,
      11783,
      11784,
      },
      },
      { boss="9042", name="Verek",
      ALL={
      11755,
      22242,
      },
      },
      { boss="9476", name="Watchman Doomgrip",
      ALL={
      22205,
      22255,
      22256,
      22254,
      },
      },
      { boss="9056", name="Fineous Darkvire",
      ALL={
      11839,
      22223,
      11842,
      11841,
      11840,
      },
      },
      { boss="9017", name="Lord Incendius",
      ALL={
      11766,
      11764,
      11765,
      11767,
      19268,
      11768,
      },
      },
      { boss="9016", name="Bael'Gar",
      ALL={
      11807,
      11802,
      11805,
      11803,
      },
      },
      { boss="9033", name="General Angerforge",
      ALL={
      11820,
      11821,
      11815,
      11817,
      11816,
      11841,
      },
      },
      { boss="8983", name="Golem Lord Argelmach",
      ALL={
      11823,
      11822,
      11669,
      11819,
      },
      },
      { boss="9537", name="Guzzler",
      ALL={
      11735,
      18043,
      22275,
      18044,
      18592,
      11612,
      2662,
      2663,
      11742,
      12793,
      12791,
      18653,
      13483,
      15759,
      11325,
      11602,
      },
      },
      { boss="9502", name="Phalanx",
      ALL={
      11746,
      22212,
      11745,
      11744,
      11743,
      },
      },
      { boss="9156", name="Ambassador Flamelash",
      ALL={
      11808,
      11812,
      11814,
      11832,
      11809,
      23320,
      },
      },
      { boss="8923", name="Panzor the Invincible",
      ALL={
      22245,
      11787,
      11785,
      11786,
      },
      },
      { boss="9034", name="Chest of The Seven",
      ALL={
      11925,
      11926,
      11929,
      11927,
      11920,
      11923,
      11922,
      11921,
      },
      },
      { boss="9938", name="Magmus",
      ALL={
      11935,
      22395,
      22400,
      22208,
      },
      },
      { boss="8929", name="Princess Moira Bronzebeard ",
      ALL={
      12557,
      12554,
      12556,
      12553,
      },
      },
      { boss="9019", name="Emperor Dagran Thaurissan",
      ALL={
      11684,
      16724,
      11933,
      11930,
      11924,
      22204,
      22207,
      11934,
      11810,
      11928,
      11931,
      11932,
      12033,
      },
      },
      { boss="16059", name="Theldren - Tier 0.5 Sets",
      ALL={
      22305,
      22330,
      22318,
      22317,
      },
      },
      }
      DugisGearFinderData["Raid: Blackwing Lair"] = {
      dungeonmap=2677, normal=1,
      { boss="12435", name="Razorgore the Untamed",
      ALL={
      16926,
      16918,
      16934,
      16911,
      16904,
      16935,
      16943,
      16951,
      16959,
      19336,
      19337,
      19370,
      19369,
      19335,
      19334,
      },
      },
      { boss="13020", name="Vaelastrasz the Corrupt",
      ALL={
      16925,
      16818,
      16933,
      16910,
      16903,
      16936,
      16944,
      16952,
      16960,
      19339,
      19340,
      19372,
      19371,
      19348,
      19346,
      },
      },
      { boss="12017", name="Broodlord Lashlayer",
      ALL={
      16919,
      16912,
      16927,
      16906,
      16898,
      16941,
      16949,
      16957,
      16965,
      19341,
      19342,
      19373,
      19374,
      19350,
      19351,
      20383,
      },
      },
      { boss="11983", name="Firemaw",
      ALL={
      16920,
      16913,
      16928,
      16907,
      16899,
      16940,
      16948,
      16956,
      16964,
      19344,
      19343,
      19394,
      19398,
      19399,
      19400,
      19396,
      19401,
      19402,
      19365,
      19353,
      19355,
      19397,
      19395,
      },
      },
      { boss="14601", name="Ebonroc",
      ALL={
      16920,
      16913,
      16928,
      16907,
      16899,
      16940,
      16948,
      16956,
      16964,
      19345,
      19406,
      19395,
      19394,
      19407,
      19396,
      19405,
      19368,
      19353,
      19355,
      19403,
      19397,
      },
      },
      { boss="11981", name="Flamegor",
      ALL={
      16920,
      16913,
      16928,
      16907,
      16899,
      16940,
      16948,
      16956,
      16964,
      19395,
      19431,
      19394,
      19430,
      19396,
      19433,
      19367,
      19353,
      19357,
      19355,
      19432,
      19397,
      },
      },
      { boss="14020", name="Chromaggus",
      ALL={
      16924,
      16917,
      16932,
      16832,
      16902,
      16937,
      16945,
      16953,
      16961,
      19389,
      19386,
      19390,
      19388,
      19393,
      19392,
      19385,
      19391,
      19387,
      19361,
      19349,
      19347,
      19352,
      },
      },
      { boss="11583", name="Nefarian",
      ALL={
      16923,
      16916,
      16931,
      16905,
      16897,
      16942,
      16950,
      16958,
      16966,
      19003,
      19360,
      19363,
      19364,
      19356,
      19375,
      19377,
      19378,
      19380,
      19381,
      19376,
      19382,
      19379,
      11938,
      17962,
      17963,
      17964,
      17965,
      17969,
      },
      },
      }
      DugisGearFinderData["Dire Maul East"] = {
      dungeonmap=2557, normal=1,
      { boss="14354", name="Pusillin",
      ALL={
      18267,
      18249,
      },
      },
      { boss="11490", name="Zevrim Thornhoof",
      ALL={
      18319,
      18313,
      18323,
      18308,
      18306,
      },
      },
      { boss="13280", name="Hydrospawn",
      ALL={
      18317,
      18322,
      18324,
      19268,
      18305,
      18307,
      },
      },
      { boss="14327", name="Lethtendris",
      ALL={
      18325,
      18311,
      18301,
      18302,
      },
      },
      { boss="11492", name="Alzzin the Wildshaper",
      ALL={
      18328,
      18312,
      18309,
      18326,
      18327,
      18318,
      18321,
      18310,
      18314,
      18315,
      },
      },
      { boss="16097", name="Isalien - Tier 0.5 Sets",
      ALL={
      22304,
      22472,
      22401,
      22345,
      22315,
      22314,
      },
      },
      }
      DugisGearFinderData["Dire Maul North"] = {
      dungeonmap=2558, normal=1,
      { boss="14326", name="Guard Mol'dar",
      ALL={
      18494,
      18493,
      18496,
      18497,
      18498,
      18450,
      18458,
      18459,
      18451,
      18462,
      18463,
      18464,
      18460,
      18250,
      18268,
      },
      },
      { boss="14322", name="Stomper Kreeg",
      ALL={
      18425,
      },
      },
      { boss="14321", name="Guard Fengus",
      ALL={
      18450,
      18458,
      18459,
      18451,
      18462,
      18463,
      18464,
      18460,
      18250,
      18266,
      },
      },
      { boss="14323", name="Guard Slip'kik",
      ALL={
      18494,
      18493,
      18496,
      18497,
      18498,
      18450,
      18458,
      18459,
      18451,
      18462,
      18463,
      18464,
      18460,
      18250,
      },
      },
      { boss="14338", name="Knot Thimblejack's Cache",
      ALL={
      18414,
      18517,
      18518,
      18519,
      18415,
      18416,
      18417,
      18418,
      18514,
      18515,
      18516,
      18258,
      18240,
      },
      },
      { boss="14325", name="Captain Kromcrush",
      ALL={
      18503,
      18505,
      18507,
      18502,
      },
      },
      { boss="14324", name="Cho'Rush the Observer",
      ALL={
      18490,
      18483,
      18485,
      18484,
      },
      },
      { boss="11501", name="King Gordok",
      ALL={
      18526,
      18525,
      18527,
      18524,
      18521,
      18522,
      18523,
      18520,
      19258,
      18780,
      },
      },
      { boss="14324", name="Tribute",
      ALL={
      18538,
      18528,
      18495,
      18532,
      18530,
      18533,
      18529,
      18500,
      18537,
      18499,
      18531,
      18534,
      18479,
      18480,
      18478,
      18475,
      18477,
      18476,
      18482,
      18481,
      18655,
      },
      },
      }
      DugisGearFinderData["Dire Maul West"] = {
      dungeonmap=2559, normal=1,
      { boss="11489", name="Tendris Warpwood",
      ALL={
      18393,
      18390,
      18352,
      18353,
      },
      },
      { boss="11488", name="Illyanna Ravenoak",
      ALL={
      18383,
      18386,
      18349,
      18347,
      },
      },
      { boss="11487", name="Magister Kalendris",
      ALL={
      18374,
      18397,
      18371,
      18350,
      18351,
      22309,
      },
      },
      { boss="11467", name="Tsu'zee",
      ALL={
      18387,
      18346,
      18345,
      },
      },
      { boss="11496", name="Immol'thar",
      ALL={
      18381,
      18384,
      18389,
      18385,
      18394,
      18377,
      18391,
      18379,
      18370,
      18372,
      },
      },
      { boss="11486", name="Prince Tortheldrin",
      ALL={
      18382,
      18373,
      18375,
      18378,
      18380,
      18395,
      18388,
      18396,
      18376,
      18392,
      },
      },
      { boss="14371", name="Shen'dralar Provisioner",
      ALL={
      },
      },
      { boss="14506", name="Lord Hel'nurath",
      ALL={
      18757,
      18754,
      18755,
      18756,
      },
      },
      }
      DugisGearFinderData["Gnomeregan (25-29)"] = {
      dungeonmap=721, normal=1,
      { boss="6231", name="Techbot",
      ALL={
      9444,
      },
      },
      { boss="7361", name="Grubbis",
      ALL={
      9445,
      },
      },
      { boss="7079", name="Viscous Fallout",
      ALL={
      9454,
      9453,
      9452,
      },
      },
      { boss="6235", name="Electrocutioner 6000",
      ALL={
      9447,
      9446,
      9448,
      6893,
      },
      },
      { boss="6229", name="Crowd Pummeler 9-60",
      ALL={
      9449,
      9450,
      },
      },
      { boss="6228", name="Dark Iron Ambassador",
      ALL={
      9455,
      9456,
      9457,
      },
      },
      { boss="7800", name="Mekgineer Thermaplugg",
      ALL={
      9492,
      9461,
      9458,
      9459,
      4415,
      4413,
      4411,
      7742,
      },
      },
      }
      DugisGearFinderData["Lower Blackrock Spire"] = {
      dungeonmap=1583, normal=1,
      { boss="10263", name="Burning Felguard",
      ALL={
      13181,
      13182,
      },
      },
      { boss="9219", name="Spirestone Butcher",
      ALL={
      12608,
      13286,
      },
      },
      { boss="9196", name="Highlord Omokk",
      ALL={
      13166,
      13168,
      13170,
      13169,
      13167,
      12336,
      12534,
      },
      },
      { boss="9218", name="Spirestone Battle Lord",
      ALL={
      13284,
      13285,
      },
      },
      { boss="9217", name="Spirestone Lord Magus",
      ALL={
      13282,
      13283,
      13261,
      },
      },
      { boss="9236", name="Shadow Hunter Vosh'gajin",
      ALL={
      16712,
      13257,
      12626,
      13255,
      12653,
      12651,
      12654,
      },
      },
      { boss="9237", name="War Master Voone",
      ALL={
      16676,
      13177,
      13178,
      13179,
      22231,
      13173,
      12582,
      12335,
      },
      },
      { boss="9596", name="Bannok Grimaxe",
      ALL={
      12637,
      12634,
      12621,
      12838,
      },
      },
      { boss="10596", name="Mother Smolderweb",
      ALL={
      16715,
      13244,
      13213,
      13183,
      },
      },
      { boss="10376", name="Crystal Fang",
      ALL={
      13185,
      13184,
      13218,
      },
      },
      { boss="10584", name="Urok Doomhowl",
      ALL={
      16670,
      13258,
      22232,
      13259,
      18784,
      },
      },
      { boss="9736", name="Quartermaster Zigris",
      ALL={
      13247,
      13253,
      13252,
      12835,
      },
      },
      { boss="10220", name="Halycon",
      ALL={
      13212,
      22313,
      13211,
      13210,
      },
      },
      { boss="10268", name="Gizrul the Slavener",
      ALL={
      16718,
      13208,
      13206,
      13205,
      },
      },
      { boss="9718", name="Ghok Bashguud",
      ALL={
      13203,
      13198,
      13204,
      },
      },
      { boss="9568", name="Overlord Wyrmthalak",
      ALL={
      13143,
      16679,
      13162,
      13164,
      22321,
      13163,
      13148,
      13161,
      12337,
      12780,
      },
      },
      { boss="16080", name="Mor Grayhoof - Tier 0.5 Sets",
      ALL={
      22306,
      22325,
      22319,
      22398,
      22322,
      },
      },
      }
      DugisGearFinderData["Maraudon Purple (45-49)"] = {
      dungeonmap=2100, normal=1,
      { boss="12236", name="Lord Vyletongue",
      ALL={
      17755,
      17754,
      17752,
      },
      },
      }
      DugisGearFinderData["Maraudon Orange (45-49)"] = {
      dungeonmap=2101, normal=1,
      { boss="13282", name="Noxxion",
      ALL={
      17746,
      17744,
      17745,
      },
      },
      { boss="12258", name="Razorlash",
      ALL={
      17749,
      17748,
      17750,
      17751,
      },
      },
      { boss="12237", name="Meshlok the Harvester",
      ALL={
      17767,
      17741,
      17742,
      },
      },
      { boss="12225", name="Celebras the Cursed",
      ALL={
      17740,
      17739,
      17738,
      },
      },
      }
      DugisGearFinderData["Maraudon Inner (45-49)"] = {
      dungeonmap=2102, normal=1,
      { boss="12203", name="Landslide",
      ALL={
      17734,
      17736,
      17737,
      17943,
      },
      },
      { boss="13601", name="Tinkerer Gizlock",
      ALL={
      17718,
      17717,
      17719,
      },
      },
      { boss="13596", name="Rotgrip",
      ALL={
      17732,
      17728,
      17730,
      },
      },
      { boss="12201", name="Princess Theradras",
      ALL={
      17780,
      17715,
      17707,
      17714,
      17711,
      17713,
      17710,
      17766,
      },
      },
      }
      DugisGearFinderData["Raid: Molten Core"] = {
      dungeonmap=2717, normal=1,
      { boss="12118", name="Lucifron",
      ALL={
      16800,
      16805,
      16829,
      16837,
      16859,
      16863,
      18870,
      17109,
      19145,
      19146,
      18872,
      18875,
      18861,
      18879,
      19147,
      17077,
      18878,
      16665,
      },
      },
      { boss="11982", name="Magmadar",
      ALL={
      16814,
      16796,
      16810,
      16822,
      16835,
      16847,
      16843,
      16855,
      16867,
      18203,
      17065,
      18829,
      18823,
      19143,
      19136,
      18861,
      19144,
      18824,
      18821,
      18820,
      19142,
      17069,
      17073,
      18822,
      },
      },
      { boss="12259", name="Gehennas",
      ALL={
      16812,
      16826,
      16849,
      16839,
      16860,
      16862,
      18870,
      19145,
      19146,
      18872,
      18875,
      18861,
      18879,
      19147,
      17077,
      18878,
      },
      },
      { boss="12057", name="Garr",
      ALL={
      18564,
      16813,
      16795,
      16808,
      16821,
      16834,
      16846,
      16842,
      16854,
      16866,
      18829,
      18823,
      19143,
      19136,
      18861,
      19144,
      18824,
      18821,
      18820,
      19142,
      17066,
      17071,
      17105,
      18832,
      18822,
      },
      },
      { boss="12264", name="Shazzrah",
      ALL={
      16811,
      16801,
      16803,
      16824,
      16831,
      16852,
      18870,
      19145,
      19146,
      18872,
      18875,
      18861,
      18879,
      19147,
      17077,
      18878,
      },
      },
      { boss="12056", name="Baron Geddon",
      ALL={
      18563,
      16797,
      16807,
      16836,
      16844,
      16856,
      18829,
      18823,
      19143,
      19136,
      18861,
      19144,
      18824,
      18821,
      17110,
      18820,
      19142,
      18822,
      },
      },
      { boss="11988", name="Golemagg the Incinerator",
      ALL={
      16815,
      16798,
      16809,
      16820,
      16833,
      16845,
      16841,
      16853,
      16865,
      17203,
      18829,
      18823,
      19143,
      19136,
      18861,
      19144,
      18824,
      18821,
      18820,
      19142,
      17072,
      17103,
      18822,
      18842,
      },
      },
      { boss="12098", name="Sulfuron Harbinger",
      ALL={
      16816,
      16823,
      16848,
      16868,
      18870,
      19145,
      19146,
      18872,
      18875,
      18861,
      18879,
      19147,
      17077,
      18878,
      17074,
      },
      },
      { boss="12018", name="Majordomo Executus",
      ALL={
      19139,
      18810,
      18811,
      18808,
      18809,
      18812,
      18806,
      19140,
      18805,
      18803,
      18703,
      18646,
      },
      },
      { boss="11502", name="Ragnaros",
      ALL={
      17204,
      19017,
      16922,
      16915,
      16930,
      16909,
      16901,
      16938,
      16946,
      16954,
      16962,
      17082,
      18817,
      18814,
      17102,
      17107,
      19137,
      17063,
      19138,
      18815,
      17106,
      18816,
      17104,
      17076,
      },
      },
      }
      DugisGearFinderData["Raid: Naxxramas"] = {
      dungeonmap=3456, normal=1,
      { boss="15956", name="Anub'Rekhan",
      ALL={
      22726,
      22727,
      22369,
      22362,
      22355,
      22935,
      22938,
      22936,
      22939,
      22937,
      },
      },
      { boss="15953", name="Grand Widow Faerlina",
      ALL={
      22726,
      22727,
      22369,
      22362,
      22355,
      22943,
      22941,
      22940,
      22942,
      22806,
      },
      },
      { boss="15952", name="Maexxna",
      ALL={
      22726,
      22727,
      22371,
      22364,
      22357,
      22947,
      23220,
      22954,
      22807,
      22804,
      },
      },
      { boss="15954", name="Noth the Plaguebringer",
      ALL={
      22726,
      22727,
      22370,
      22363,
      22356,
      23030,
      23031,
      23028,
      23029,
      23006,
      23005,
      22816,
      },
      },
      { boss="15936", name="Heigan the Unclean",
      ALL={
      22726,
      22727,
      22370,
      22363,
      22356,
      23035,
      23033,
      23019,
      23036,
      23068,
      },
      },
      { boss="16011", name="Loatheb",
      ALL={
      22726,
      22727,
      22366,
      22359,
      22352,
      23038,
      23037,
      23042,
      23039,
      22800,
      },
      },
      { boss="16061", name="Instructor Razuvious",
      ALL={
      22726,
      22727,
      22372,
      22365,
      22358,
      23017,
      23219,
      23018,
      23004,
      23009,
      23014,
      },
      },
      { boss="16060", name="Gothik the Harvester",
      ALL={
      22726,
      22727,
      22372,
      22365,
      22358,
      23032,
      23020,
      23023,
      23021,
      23073,
      },
      },
      { boss="16064", name="The Four Horsemen",
      ALL={
      22726,
      22727,
      22351,
      22350,
      22349,
      23071,
      23025,
      23027,
      22811,
      22809,
      22691,
      },
      },
      { boss="16028", name="Patchwerk",
      ALL={
      22726,
      22727,
      22368,
      22361,
      22354,
      22960,
      22961,
      22820,
      22818,
      22815,
      },
      },
      { boss="15931", name="Grobbulus",
      ALL={
      22726,
      22727,
      22368,
      22361,
      22354,
      22968,
      22967,
      22810,
      22803,
      22988,
      },
      },
      { boss="15932", name="Gluth",
      ALL={
      22726,
      22727,
      22983,
      22981,
      22994,
      23075,
      22813,
      22368,
      22369,
      22370,
      22372,
      22361,
      22362,
      22363,
      22365,
      22354,
      22355,
      22356,
      22358,
      },
      },
      { boss="15928", name="Thaddius",
      ALL={
      22726,
      22727,
      22367,
      22360,
      22353,
      23000,
      23070,
      23001,
      22808,
      22801,
      },
      },
      { boss="15989", name="Sapphiron",
      ALL={
      23050,
      23045,
      23040,
      23047,
      23041,
      23046,
      23049,
      23048,
      23043,
      23242,
      23549,
      23548,
      23545,
      23547,
      },
      },
      { boss="15990", name="Kel'Thuzad",
      ALL={
      23057,
      23053,
      22812,
      22821,
      22819,
      22802,
      23056,
      23054,
      23577,
      22798,
      22799,
      22520,
      23061,
      23062,
      23063,
      23060,
      23064,
      23067,
      23065,
      23066,
      23059,
      22733,
      },
      },
      }
      DugisGearFinderData["Raid: Onyxia"] = {
      dungeonmap=2159, normal=1,
      { boss="10184", name="Onyxia",
      ALL={
      16921,
      16914,
      16929,
      16908,
      16900,
      16939,
      16947,
      16955,
      16963,
      18423,
      15410,
      18705,
      18205,
      17078,
      18813,
      17064,
      17067,
      17068,
      17075,
      17966,
      11938,
      17962,
      17963,
      17964,
      17965,
      17969,
      },
      },
      }
      DugisGearFinderData["Razorfen Downs (33-38)"] = {
      dungeonmap=722, normal=1,
      { boss="7355", name="Tuten'kash",
      ALL={
      10776,
      10775,
      10777,
      },
      },
      { boss="14686", name="Lady Falther'ess",
      ALL={
      23178,
      23177,
      },
      },
      { boss="7357", name="Mordresh Fire Eye",
      ALL={
      10769,
      10771,
      10770,
      },
      },
      { boss="8567", name="Glutton",
      ALL={
      10774,
      10772,
      },
      },
      { boss="7354", name="Ragglesnout",
      ALL={
      10768,
      10767,
      10758,
      },
      },
      { boss="7358", name="Amnennar the Coldbringer",
      ALL={
      10763,
      10762,
      10764,
      10761,
      10765,
      },
      },
      { boss="7356", name="Plaguemaw the Rotting",
      ALL={
      10766,
      10760,
      },
      },
      { boss="8696", name="Henry Stern",
      ALL={
      3826,
      10841,
      },
      },
      }
      DugisGearFinderData["Razorfen Kraul (23-28)"] = {
      dungeonmap=491, normal=1,
      { boss="4424", name="Aggem Thorncurse",
      ALL={
      6681,
      },
      },
      { boss="4428", name="Death Speaker Jargba",
      ALL={
      2816,
      6685,
      6682,
      },
      },
      { boss="4420", name="Overlord Ramtusk",
      ALL={
      6687,
      6686,
      },
      },
      { boss="4438", name="Razorfen Spearhide",
      ALL={
      6679,
      },
      },
      { boss="4422", name="Agathelos the Raging",
      ALL={
      6691,
      6690,
      },
      },
      { boss="4425", name="Blind Hunter",
      ALL={
      6695,
      6697,
      6696,
      },
      },
      { boss="4421", name="Charlga Razorflank",
      ALL={
      6693,
      6694,
      6692,
      17008,
      },
      },
      { boss="4842", name="Earthcaller Halmgar",
      ALL={
      6689,
      6688,
      },
      },
      }
      DugisGearFinderData["Scarlet Monestary Armory (34-39)"] = {
      dungeonmap=796, normal=1,
      { boss="3975", name="Herod",
      ALL={
      7719,
      7718,
      10330,
      7717,
      },
      },
      }
      DugisGearFinderData["Scarlet Monestary Cathedral (34-39)"] = {
      dungeonmap=797, normal=1,
      { boss="4542", name="High Inquisitor Fairbanks",
      ALL={
      19507,
      19508,
      19509,
      },
      },
      { boss="3976", name="Scarlet Commander Mograine",
      ALL={
      7724,
      10330,
      7726,
      7723,
      },
      },
      { boss="3977", name="High Inquisitor Whitemane",
      ALL={
      7720,
      7722,
      7721,
      },
      },
      }
      DugisGearFinderData["Scarlet Monestary Graveyard (27-33)"] = {
      dungeonmap=798, normal=1,
      { boss="3983", name="Interrogator Vishas",
      ALL={
      7682,
      7683,
      },
      },
      { boss="6490", name="Azshir the Sleepless",
      ALL={
      7709,
      7708,
      7731,
      },
      },
      { boss="6488", name="Fallen Champion",
      ALL={
      7691,
      7690,
      7689,
      },
      },
      { boss="6489", name="Ironspine",
      ALL={
      7688,
      7687,
      7686,
      },
      },
      { boss="4543", name="Bloodmage Thalnos",
      ALL={
      7685,
      7684,
      },
      },
      }
      DugisGearFinderData["Scarlet Monestary Library (27-33)"] = {
      dungeonmap=799, normal=1,
      { boss="3974", name="Houndmaster Loksey",
      ALL={
      7710,
      7756,
      3456,
      },
      },
      { boss="6487", name="Arcanist Doan",
      ALL={
      7714,
      7713,
      7712,
      7711,
      },
      },
      }
      DugisGearFinderData["Scholomance (55-58)"] = {
      dungeonmap=2057, normal=1,
      { boss="14861", name="Blood Steward of Kirtonos",
      ALL={
      13523,
      },
      },
      { boss="10506", name="Kirtonos the Herald",
      ALL={
      16734,
      13960,
      13955,
      13969,
      13957,
      13956,
      13967,
      14024,
      13983,
      },
      },
      { boss="10503", name="Jandice Barov",
      ALL={
      16701,
      14548,
      18689,
      14543,
      14545,
      18690,
      14541,
      22394,
      13523,
      },
      },
      { boss="11622", name="Rattlegore",
      ALL={
      16711,
      14539,
      14538,
      18686,
      14537,
      14528,
      14531,
      18782,
      13873,
      },
      },
      { boss="14516", name="Death Knight Darkreaver",
      ALL={
      18760,
      18761,
      18758,
      18759,
      },
      },
      { boss="10433", name="Marduk Blackpool",
      ALL={
      18692,
      14576,
      },
      },
      { boss="10432", name="Vectus",
      ALL={
      18691,
      14577,
      },
      },
      { boss="10508", name="Ras Frostwhisper",
      ALL={
      13314,
      16689,
      14503,
      14340,
      18693,
      14525,
      14502,
      14522,
      18694,
      18695,
      18696,
      13952,
      14487,
      13521,
      },
      },
      { boss="10505", name="Instructor Malicia",
      ALL={
      16710,
      18681,
      14633,
      14626,
      14637,
      14611,
      14624,
      14629,
      14640,
      14615,
      14622,
      14636,
      14614,
      14620,
      14632,
      14638,
      18682,
      14612,
      14623,
      14631,
      14641,
      14616,
      14621,
      18684,
      23201,
      23200,
      18680,
      18683,
      },
      },
      { boss="11261", name="Doctor Theolen Krastinov",
      ALL={
      16684,
      14617,
      18681,
      14633,
      14626,
      14637,
      14611,
      14624,
      14629,
      14640,
      14615,
      14622,
      14636,
      14614,
      14620,
      14632,
      14638,
      18682,
      14612,
      14623,
      14631,
      14641,
      14616,
      14621,
      18684,
      23201,
      23200,
      18680,
      18683,
      },
      },
      { boss="10901", name="Lorekeeper Polkelt",
      ALL={
      16705,
      18681,
      14633,
      14626,
      14637,
      14611,
      14624,
      14629,
      14640,
      14615,
      14622,
      14636,
      14614,
      14620,
      14632,
      14638,
      18682,
      14612,
      14623,
      14631,
      14641,
      14616,
      14621,
      18684,
      23201,
      23200,
      18680,
      18683,
      },
      },
      { boss="10507", name="The Ravenian",
      ALL={
      16716,
      18681,
      14633,
      14626,
      14637,
      14611,
      14624,
      14629,
      14640,
      14615,
      14622,
      14636,
      14614,
      14620,
      14632,
      14638,
      18682,
      14612,
      14623,
      14631,
      14641,
      14616,
      14621,
      18684,
      23201,
      23200,
      18680,
      18683,
      },
      },
      { boss="10504", name="Lord Alexei Barov",
      ALL={
      16722,
      18681,
      14633,
      14626,
      14637,
      14611,
      14624,
      14629,
      14640,
      14615,
      14622,
      14636,
      14614,
      14620,
      14632,
      14638,
      18682,
      14612,
      14623,
      14631,
      14641,
      14616,
      14621,
      18684,
      23201,
      23200,
      18680,
      18683,
      },
      },
      { boss="10502", name="Lady Illucia Barov",
      ALL={
      18681,
      14633,
      14626,
      14637,
      14611,
      14624,
      14629,
      14640,
      14615,
      14622,
      14636,
      14614,
      14620,
      14632,
      14638,
      18682,
      14612,
      14623,
      14631,
      14641,
      14616,
      14621,
      18684,
      23201,
      23200,
      18680,
      18683,
      },
      },
      { boss="1853", name="Darkmaster Gandling",
      ALL={
      13937,
      14514,
      16693,
      16686,
      16698,
      16707,
      16720,
      16677,
      16667,
      16727,
      16731,
      13944,
      13951,
      13950,
      13398,
      22433,
      13938,
      13953,
      13964,
      19276,
      13501,
      },
      },
      { boss="14516", name="Death Knight Darkreaver",
      ALL={
      18760,
      18761,
      18758,
      18759,
      },
      },
      { boss="16118", name="Kormok - Tier 0.5 Sets",
      ALL={
      22303,
      22326,
      22331,
      22332,
      22333,
      },
      },
      }
      DugisGearFinderData["Shadowfang Keep (18-22)"] = {
      dungeonmap=209, normal=1,
      { boss="3914", name="Rethilgore",
      ALL={
      5254,
      },
      },
      { boss="3865", name="Fel Steed / Shadow Charger",
      ALL={
      6341,
      932,
      },
      },
      { boss="3886", name="Razorclaw the Butcher",
      ALL={
      1292,
      6226,
      6633,
      },
      },
      { boss="3887", name="Baron Silverlaine",
      ALL={
      6321,
      6323,
      },
      },
      { boss="4278", name="Commander Springvale",
      ALL={
      6320,
      3191,
      },
      },
      { boss="14682", name="Sever",
      ALL={
      23173,
      23171,
      },
      },
      { boss="4279", name="Odo the Blindwatcher",
      ALL={
      6318,
      6319,
      },
      },
      { boss="3872", name="Deathsworn Captain",
      ALL={
      6642,
      6641,
      },
      },
      { boss="4627", name="Arugal's Voidwalker",
      ALL={
      5943,
      },
      },
      { boss="4274", name="Fenrus the Devourer",
      ALL={
      6340,
      3230,
      },
      },
      { boss="3927", name="Wolf Master Nandos",
      ALL={
      3748,
      6314,
      },
      },
      { boss="4275", name="Archmage Arugal",
      ALL={
      6324,
      6392,
      6220,
      },
      },
      }
      DugisGearFinderData["Stratholme Living (55-60)"] = {
      dungeonmap=2017, normal=1,
      { boss="10393", name="Skul",
      ALL={
      13395,
      13394,
      13396,
      },
      },
      { boss="10558", name="Hearthsinger Forresten",
      ALL={
      13378,
      13384,
      13383,
      13379,
      },
      },
      { boss="10516", name="The Unforgiven",
      ALL={
      16717,
      13404,
      13405,
      13409,
      13408,
      },
      },
      { boss="10808", name="Timmy the Cruel",
      ALL={
      13400,
      13403,
      13402,
      13401,
      },
      },
      { boss="10997", name="Cannon Master Willey",
      ALL={
      16708,
      22407,
      22403,
      22405,
      18721,
      13381,
      13382,
      13380,
      13377,
      22404,
      22406,
      12839,
      },
      },
      { boss="10811", name="Archivist Galford",
      ALL={
      16692,
      13386,
      13387,
      18716,
      13385,
      12811,
      22897,
      },
      },
      { boss="10812", name="Balnazzar",
      ALL={
      13353,
      14512,
      16725,
      13359,
      18718,
      12103,
      18720,
      13358,
      13369,
      13360,
      18717,
      22334,
      13348,
      13520,
      13250,
      },
      },
      { boss="11143", name="Postmaster Malown",
      ALL={
      16682,
      13390,
      13388,
      13389,
      13391,
      13392,
      13393,
      },
      },
      }
      DugisGearFinderData["Stratholme Undead (55-60)"] = {
      dungeonmap=2018, normal=1,
      { boss="10435", name="Magistrate Barthilas",
      ALL={
      18727,
      13376,
      18726,
      18722,
      23198,
      18725,
      12382,
      },
      },
      { boss="10809", name="Stonespine",
      ALL={
      13397,
      13954,
      13399,
      },
      },
      { boss="10436", name="Baroness Anastari",
      ALL={
      16704,
      18728,
      18730,
      18729,
      13534,
      13538,
      13535,
      13537,
      13539,
      13514,
      },
      },
      { boss="10437", name="Nerub'enkan",
      ALL={
      16675,
      18740,
      18739,
      18738,
      13529,
      13533,
      13532,
      13531,
      13530,
      13508,
      },
      },
      { boss="10438", name="Maleki the Pallid",
      ALL={
      16691,
      18734,
      18735,
      13524,
      18737,
      13528,
      13525,
      13526,
      13527,
      13509,
      12833,
      },
      },
      { boss="10439", name="Ramstein the Gorger",
      ALL={
      16737,
      18723,
      13374,
      13373,
      13515,
      13375,
      13372,
      },
      },
      { boss="10440", name="Baron Rivendare",
      ALL={
      13335,
      13505,
      22411,
      22412,
      13340,
      13346,
      22409,
      13344,
      22410,
      13345,
      22408,
      13349,
      13368,
      13361,
      16694,
      16687,
      16699,
      16709,
      16719,
      16678,
      16668,
      16728,
      16732,
      },
      },
      }
      DugisGearFinderData["The Deadmines (15-20"] = {
      dungeonmap=1581, normal=1,
      { boss="644", name="Rhahk'Zor",
      ALL={
      872,
      5187,
      },
      },
      { boss="3586", name="Miner Johnson",
      ALL={
      5443,
      5444,
      },
      },
      { boss="643", name="Sneed",
      ALL={
      5194,
      5195,
      },
      },
      { boss="642", name="Sneed's Shredder",
      ALL={
      1937,
      2169,
      },
      },
      { boss="1763", name="Gilnid",
      ALL={
      1156,
      5199,
      },
      },
      { boss="646", name="Mr. Smite",
      ALL={
      7230,
      5192,
      5196,
      },
      },
      { boss="647", name="Captain Greenskin",
      ALL={
      5201,
      10403,
      5200,
      },
      },
      { boss="639", name="Edwin VanCleef",
      ALL={
      5193,
      5202,
      10399,
      5191,
      2874,
      },
      },
      { boss="645", name="Cookie",
      ALL={
      5198,
      5197,
      8490,
      },
      },
      }
      DugisGearFinderData["Raid: The Ruins of Ahn'Qiraj"] = {
      dungeonmap=3429, normal=1,
      { boss="15348", name="Kurinnaxx",
      ALL={
      21499,
      21498,
      21502,
      21501,
      21500,
      21503,
      20885,
      20889,
      20888,
      20884,
      },
      },
      { boss="15341", name="General Rajaxx",
      ALL={
      21493,
      21492,
      21496,
      21494,
      21495,
      21497,
      20885,
      20889,
      20888,
      20884,
      },
      },
      { boss="15340", name="Moam",
      ALL={
      21472,
      21467,
      21479,
      21471,
      21455,
      21468,
      21474,
      21470,
      21469,
      21476,
      21475,
      21477,
      21473,
      20890,
      20886,
      20888,
      20884,
      22220,
      },
      },
      { boss="15370", name="Buru the Gorger",
      ALL={
      21487,
      21486,
      21485,
      21491,
      21489,
      21490,
      21488,
      20890,
      20886,
      20885,
      20889,
      20888,
      20884,
      },
      },
      { boss="15369", name="Ayamiss the Hunter",
      ALL={
      21479,
      21478,
      21466,
      21484,
      21480,
      21482,
      21481,
      21483,
      20890,
      20886,
      20885,
      20889,
      20888,
      20884,
      },
      },
      { boss="15339", name="Ossirian the Unscarred",
      ALL={
      21460,
      21454,
      21453,
      21456,
      21464,
      21457,
      21462,
      21458,
      21463,
      21461,
      21459,
      21715,
      21452,
      20890,
      20886,
      20888,
      20884,
      21220,
      },
      },
      }
      DugisGearFinderData["Raid: The Temple of Ahn'Qiraj"] = {
      dungeonmap=3428, normal=1,
      { boss="15263", name="The Prophet Skeram",
      ALL={
      21699,
      21814,
      21708,
      21698,
      21705,
      21704,
      21706,
      21702,
      21700,
      21701,
      21707,
      21703,
      21128,
      21237,
      21232,
      22222,
      },
      },
      { boss="15543", name="Bug Trio",
      ALL={
      21693,
      21694,
      21697,
      21696,
      21692,
      21695,
      21237,
      21232,
      21680,
      21681,
      21685,
      21603,
      21690,
      21689,
      21691,
      21688,
      21686,
      21684,
      21683,
      21682,
      21687,
      },
      },
      { boss="15516", name="Battleguard Sartura",
      ALL={
      21669,
      21678,
      21671,
      21672,
      21674,
      21675,
      21676,
      21668,
      21667,
      21648,
      21670,
      21666,
      21673,
      21237,
      21232,
      },
      },
      { boss="15510", name="Fankriss the Unyielding",
      ALL={
      21665,
      21639,
      21627,
      21663,
      21652,
      21651,
      21645,
      21650,
      21635,
      21664,
      21647,
      22402,
      22396,
      21237,
      21232,
      },
      },
      { boss="15299", name="Viscidus",
      ALL={
      21624,
      21623,
      21626,
      21622,
      21677,
      21625,
      22399,
      21237,
      21232,
      20928,
      20932,
      },
      },
      { boss="15509", name="Princess Huhuran",
      ALL={
      21621,
      21618,
      21619,
      21617,
      21620,
      21616,
      21237,
      21232,
      20928,
      20932,
      },
      },
      { boss="15275", name="Twin Emperors",
      ALL={
      20930,
      21602,
      21599,
      21598,
      21600,
      21601,
      21597,
      20735,
      21232,
      20926,
      21608,
      21604,
      21605,
      21609,
      21607,
      21606,
      21679,
      20726,
      21237,
      },
      },
      { boss="15517", name="Ouro",
      ALL={
      21615,
      21611,
      23558,
      23570,
      21610,
      23557,
      21237,
      21232,
      20927,
      20931,
      },
      },
      { boss="15727", name="C'Thun",
      ALL={
      22732,
      21583,
      22731,
      22730,
      21582,
      21586,
      21585,
      21581,
      21596,
      21579,
      21839,
      21126,
      21134,
      20929,
      20933,
      21221,
      22734,
      },
      },
      }
      DugisGearFinderData["Sunken Temple (48-52)"] = {
      dungeonmap=1477, normal=1,
      { boss="5716", name="Balcony Minibosses",
      ALL={
      10783,
      10784,
      10787,
      10788,
      10785,
      10786,
      20606,
      20607,
      20608,
      },
      },
      { boss="8580", name="Atal'alarion",
      ALL={
      10800,
      10798,
      10799,
      },
      },
      { boss="5708", name="Spawn of Hakkar",
      ALL={
      10801,
      10802,
      },
      },
      { boss="8443", name="Avatar of Hakkar",
      ALL={
      12462,
      10843,
      10845,
      10842,
      10846,
      10838,
      10844,
      },
      },
      { boss="5710", name="Jammal'an the Prophet",
      ALL={
      10806,
      10808,
      10807,
      },
      },
      { boss="5711", name="Ogom the Wretched",
      ALL={
      10805,
      10803,
      10804,
      },
      },
      { boss="5721", name="Dreamscythe",
      ALL={
      12465,
      12466,
      12464,
      10797,
      12463,
      12243,
      10795,
      10796,
      },
      },
      { boss="5720", name="Weaver",
      ALL={
      12465,
      12466,
      12464,
      10797,
      12463,
      12243,
      10795,
      10796,
      },
      },
      { boss="5722", name="Hazzas",
      ALL={
      12465,
      12466,
      12464,
      10797,
      12463,
      12243,
      10795,
      10796,
      },
      },
      { boss="5719", name="Morphaz",
      ALL={
      12465,
      12466,
      12464,
      10797,
      12463,
      12243,
      10795,
      10796,
      },
      },
      { boss="5709", name="Shade of Eranikus",
      ALL={
      10847,
      10833,
      10829,
      10836,
      10835,
      10837,
      10828,
      10454,
      },
      },
      }
      DugisGearFinderData["Uldaman (39-45)"] = {
      dungeonmap=1337, normal=1,
      { boss="6907", name="Eric 'The Swift'",
      ALL={
      9394,
      9398,
      2459,
      },
      },
      { boss="6906", name="Baelog",
      ALL={
      9401,
      9399,
      9400,
      },
      },
      { boss="6908", name="Olaf",
      ALL={
      9404,
      9403,
      1177,
      },
      },
      { boss="6910", name="Revelosh",
      ALL={
      9389,
      9388,
      9390,
      9387,
      7741,
      },
      },
      { boss="7228", name="Ironaya",
      ALL={
      9409,
      9407,
      9408,
      },
      },
      { boss="7206", name="Ancient Stone Keeper",
      ALL={
      9410,
      9411,
      },
      },
      { boss="7291", name="Galgann Firehammer",
      ALL={
      11310,
      9412,
      11311,
      9419,
      },
      },
      { boss="4854", name="Grimlok",
      ALL={
      9415,
      9416,
      9414,
      },
      },
      { boss="2748", name="Archaedas",
      ALL={
      11118,
      9413,
      9418,
      },
      },
      }
      DugisGearFinderData["Raid: Upper Blackrock Spire"] = {
      dungeonmap=1582, normal=1,
      { boss="9816", name="Pyroguard Emberseer",
      ALL={
      16672,
      12929,
      12927,
      12905,
      12926,
      23320,
      },
      },
      { boss="10264", name="Solakar Flamewreath",
      ALL={
      16695,
      12609,
      12603,
      12589,
      12606,
      18657,
      },
      },
      { boss="10509", name="Jed Runewatcher",
      ALL={
      12604,
      12930,
      12605,
      },
      },
      { boss="10899", name="Goraluk Anvilcrack ",
      ALL={
      13502,
      13498,
      18047,
      18048,
      12834,
      12837,
      18779,
      12806,
      12696,
      },
      },
      { boss="10339", name="Gyth",
      ALL={
      12871,
      16669,
      22225,
      12960,
      12953,
      12952,
      13522,
      },
      },
      { boss="10429", name="Warchief Rend Blackhand",
      ALL={
      12590,
      16733,
      12587,
      12588,
      12936,
      18104,
      12935,
      18102,
      22247,
      18103,
      12940,
      12939,
      12583,
      },
      },
      { boss="10430", name="The Beast",
      ALL={
      12731,
      16729,
      12967,
      12968,
      12966,
      12965,
      12963,
      12964,
      22311,
      12709,
      12969,
      24101,
      19227,
      },
      },
      { boss="10363", name="General Drakkisath",
      ALL={
      12592,
      22267,
      13141,
      22269,
      13142,
      13098,
      22268,
      22253,
      12602,
      15730,
      13519,
      16690,
      16688,
      16700,
      16721,
      16706,
      16674,
      16666,
      16726,
      16730,
      },
      },
      { boss="16042", name="Lord Valthalak - Tier 0.5 Sets",
      ALL={
      22302,
      22340,
      22337,
      22343,
      22342,
      22339,
      22336,
      22335,
      },
      },
      }
      DugisGearFinderData["The Wailing Caverns (15-21)"] = {
      dungeonmap=718, normal=1,
      { boss="3669", name="Lord Cobrahn",
      ALL={
      6460,
      10410,
      6465,
      },
      },
      { boss="3671", name="Lady Anacondra",
      ALL={
      10412,
      5404,
      6446,
      },
      },
      { boss="3653", name="Kresh",
      ALL={
      13245,
      6447,
      },
      },
      { boss="3670", name="Lord Pythas",
      ALL={
      6472,
      6473,
      },
      },
      { boss="3674", name="Skum",
      ALL={
      6449,
      6448,
      },
      },
      { boss="3673", name="Lord Serpentis",
      ALL={
      6469,
      5970,
      10411,
      6459,
      },
      },
      { boss="5775", name="Verdan the Everliving",
      ALL={
      6630,
      6631,
      6629,
      },
      },
      { boss="3654", name="Mutanus the Devourer",
      ALL={
      6461,
      6627,
      6463,
      10441,
      },
      },
      { boss="5912", name="Deviate Faerie Dragon",
      ALL={
      5243,
      6632,
      },
      },
      }
      DugisGearFinderData["Raid: World Bosses"] = {
      dungeonmap=0, normal=1,
      { boss="6109", name="Azuregos",
      ALL={
      19132,
      18208,
      18541,
      18547,
      18545,
      19131,
      19130,
      17070,
      18202,
      18542,
      18704,
      11938,
      17962,
      17963,
      17964,
      17965,
      17969,
      },
      },
      { boss="12397", name="Lord Kazzak",
      ALL={
      18546,
      17111,
      18204,
      19135,
      18544,
      19134,
      19133,
      18543,
      17112,
      17113,
      18665,
      11938,
      17962,
      17963,
      17964,
      17965,
      17969,
      },
      },
      { boss="14888", name="Lethon",
      ALL={
      20628,
      20626,
      20630,
      20625,
      20627,
      20629,
      20579,
      20615,
      20616,
      20618,
      20617,
      20619,
      20582,
      20644,
      20600,
      20580,
      20581,
      20381,
      11938,
      17962,
      17963,
      17964,
      17965,
      17969,
      },
      },
      { boss="14889", name="Emeriss",
      ALL={
      20623,
      20622,
      20624,
      20621,
      20599,
      20579,
      20615,
      20616,
      20618,
      20617,
      20619,
      20582,
      20644,
      20600,
      20580,
      20581,
      11938,
      17962,
      17963,
      17964,
      17965,
      17969,
      },
      },
      { boss="14890", name="Taerar",
      ALL={
      20633,
      20631,
      20634,
      20632,
      20577,
      20579,
      20615,
      20616,
      20618,
      20617,
      20619,
      20582,
      20644,
      20600,
      20580,
      20581,
      11938,
      17962,
      17963,
      17964,
      17965,
      17969,
      },
      },
      { boss="14887", name="Ysondre",
      ALL={
      20637,
      20635,
      20638,
      20639,
      20636,
      20578,
      20579,
      20615,
      20616,
      20618,
      20617,
      20619,
      20582,
      20644,
      20600,
      20580,
      20581,
      11938,
      17962,
      17963,
      17964,
      17965,
      17969,
      },
      },
      }
      DugisGearFinderData["Zul'Farrak (42-47)"] = {
      dungeonmap=1176, normal=1,
      { boss="8127", name="Antu'sul",
      ALL={
      9640,
      9641,
      9639,
      9379,
      },
      },
      { boss="7272", name="Theka the Martyr",
      ALL={
      10660,
      },
      },
      { boss="7271", name="Witch Doctor Zum'rah",
      ALL={
      18083,
      18082,
      },
      },
      { boss="7796", name="Nekrum Gutchewer",
      ALL={
      9471,
      },
      },
      { boss="7275", name="Shadowpriest Sezz'ziz",
      ALL={
      9470,
      9473,
      9474,
      9475,
      },
      },
      { boss="10081", name="Dustwraith",
      ALL={
      12471,
      },
      },
      { boss="7274", name="Sandfury Executioner",
      ALL={
      8444,
      },
      },
      { boss="7604", name="Sergeant Bly",
      ALL={
      8548,
      },
      },
      { boss="7795", name="Hydromancer Velratha",
      ALL={
      9234,
      10661,
      },
      },
      { boss="7273", name="Gahz'rilla",
      ALL={
      9469,
      9467,
      },
      },
      { boss="7267", name="Chief Ukorz Sandscalp",
      ALL={
      9479,
      9476,
      9478,
      9477,
      11086,
      },
      },
      { boss="10082", name="Zerillis",
      ALL={
      12470,
      },
      },
      }
      DugisGearFinderData["Raid: Zul'Gurub"] = {
      dungeonmap=1977, normal=1,
      { boss="14517", name="High Priestess Jeklik",
      ALL={
      19721,
      19724,
      19723,
      19722,
      19717,
      19716,
      19718,
      19719,
      19720,
      19918,
      19923,
      19928,
      20262,
      20265,
      19920,
      19915,
      },
      },
      { boss="14507", name="High Priest Venoxis",
      ALL={
      19721,
      19724,
      19723,
      19722,
      19717,
      19716,
      19718,
      19719,
      19720,
      19904,
      19903,
      19907,
      19906,
      19905,
      19900,
      },
      },
      { boss="14510", name="High Priestess Mar'li",
      ALL={
      19721,
      19724,
      19723,
      19722,
      19717,
      19716,
      19718,
      19719,
      19720,
      20032,
      19927,
      19871,
      19919,
      19925,
      19930,
      },
      },
      { boss="11382", name="Bloodlord Mandokir",
      ALL={
      19721,
      19724,
      19723,
      19722,
      19717,
      19716,
      19718,
      19719,
      19720,
      22637,
      19872,
      20038,
      19867,
      19866,
      19874,
      19878,
      19870,
      19869,
      19895,
      19877,
      19873,
      19863,
      19893,
      },
      },
      { boss="15082", name="Gri'lek",
      ALL={
      19961,
      19962,
      19939,
      },
      },
      { boss="15083", name="Hazza'rah",
      ALL={
      19967,
      19968,
      19942,
      },
      },
      { boss="15084", name="Renataki",
      ALL={
      19964,
      19963,
      19940,
      },
      },
      { boss="15085", name="Wushoolay",
      ALL={
      19993,
      19965,
      19941,
      },
      },
      { boss="15114", name="Gahz'ranka",
      ALL={
      19945,
      19944,
      19947,
      19946,
      22739,
      },
      },
      { boss="14509", name="High Priest Thekal",
      ALL={
      19721,
      19724,
      19723,
      19722,
      19717,
      19716,
      19718,
      19719,
      19720,
      19902,
      19897,
      19896,
      19899,
      20260,
      20266,
      19898,
      19901,
      },
      },
      { boss="14515", name="High Priestess Arlokk",
      ALL={
      19721,
      19724,
      19723,
      19722,
      19717,
      19716,
      19718,
      19719,
      19720,
      19910,
      19909,
      19913,
      19912,
      19922,
      19914,
      },
      },
      { boss="11380", name="Jin'do the Hexxer",
      ALL={
      19721,
      19724,
      19723,
      19722,
      19717,
      19716,
      19718,
      19719,
      19720,
      22637,
      19885,
      19891,
      19890,
      19884,
      19886,
      19875,
      19888,
      19929,
      19894,
      19889,
      19887,
      19892,
      },
      },
      { boss="14834", name="Hakkar",
      ALL={
      19857,
      20257,
      20264,
      19855,
      19876,
      19856,
      19861,
      19853,
      19862,
      19864,
      19865,
      19852,
      19859,
      19854,
      19802,
      },
      },
      }
DugisGearFinderData["Auchenai Crypts"] = {
dungeonmap=9101, normal=1,
{ boss="18371", name="Shirrak the Dead Watcher",
ALL={
27410,
27409,
27408,
26055,
25964,
},
},
{ boss="18373", name="Exarch Maladaar",
ALL={
27411,
27415,
27414,
27413,
27416,
27412,
21525,
},
},
}
DugisGearFinderData["Auchenai Crypts (Heroic)"] = {
dungeonmap="9101H", heroic=1,
{ boss="18371", name="Shirrak the Dead Watcher",
ALL={
30587,
30588,
30586,
27866,
27493,
27865,
27845,
27847,
27846,
},
},
{ boss="18373", name="Exarch Maladaar",
ALL={
29354,
29257,
29244,
27867,
27871,
27869,
27523,
27872,
21525,
33836,
30587,
30588,
30586,
27870,
},
},
{ boss="18478", name="Avatar of the Martyred",
ALL={
27878,
28268,
27876,
27937,
27877,
27797,
},
},
}
DugisGearFinderData["Hellfire Ramparts"] = {
dungeonmap=9102, normal=1,
{ boss="17306", name="Watchkeeper Gargolmar",
ALL={
24024,
24023,
24022,
24021,
24020,
23881,
},
},
{ boss="17308", name="Omor the Unscarred",
ALL={
24090,
24091,
24073,
24096,
24094,
24069,
23886,
},
},
{ boss="17537", name="Nazan & Vazruden",
ALL={
24150,
24083,
24063,
24046,
24064,
24045,
24154,
24151,
24044,
24155,
},
},
}
DugisGearFinderData["Hellfire Ramparts (Heroic)"] = {
dungeonmap="9102H", heroic=1,
{ boss="17306", name="Watchkeeper Gargolmar",
ALL={
30593,
30594,
30592,
27448,
27451,
27450,
27447,
27449,
23881,
},
},
{ boss="17308", name="Omor the Unscarred",
ALL={
27466,
27462,
27467,
27478,
27539,
27906,
27464,
27895,
27477,
27463,
27476,
23886,
30593,
30594,
30592,
27465,
},
},
{ boss="17537", name="Nazan & Vazruden",
ALL={
29264,
32077,
29238,
29346,
27452,
27461,
27456,
27454,
27458,
27455,
27459,
27457,
30593,
30594,
30592,
27453,
27460,
},
},
}
DugisGearFinderData["Magister's Terrace"] = {
dungeonmap=9103, normal=1,
{ boss="24723", name="Selin Fireheart",
ALL={
34702,
34697,
34701,
34698,
34700,
34699,
},
},
{ boss="24744", name="Vexallus",
ALL={
34708,
34705,
34707,
34704,
34706,
34703,
},
},
{ boss="24560", name="Priestess Delrissa",
ALL={
34792,
34788,
34791,
34789,
34790,
34783,
35756,
},
},
{ boss="24664", name="Kael'thas Sunstrider",
ALL={
34810,
34808,
34809,
34799,
34807,
34625,
35311,
35304,
34157,
34793,
34796,
34795,
34798,
34794,
34797,
35504,
},
},
}
DugisGearFinderData["Magister's Terrace (Heroic)"] = {
dungeonmap="9103H", heroic=1,
{ boss="24723", name="Selin Fireheart",
ALL={
34602,
34601,
34604,
34603,
35275,
},
},
{ boss="24744", name="Vexallus",
ALL={
34607,
34605,
34606,
34608,
35275,
},
},
{ boss="24560", name="Priestess Delrissa",
ALL={
34473,
34471,
34470,
34472,
35756,
35275,
},
},
{ boss="24664", name="Kael'thas Sunstrider",
ALL={
34610,
34613,
34614,
34615,
34612,
34611,
34609,
34616,
35513,
35504,
35311,
35304,
},
},
}
DugisGearFinderData["Mana-Tombs"] = {
dungeonmap=9104, normal=1,
{ boss="18341", name="Pandemonius",
ALL={
25941,
25942,
25940,
25943,
28166,
25939,
},
},
{ boss="18343", name="Tavarok",
ALL={
25945,
25946,
25947,
25952,
25944,
25950,
},
},
{ boss="18344", name="Nexus-Prince Shaffar",
ALL={
25957,
25955,
25956,
25954,
25962,
25953,
22921,
28490,
},
},
}
DugisGearFinderData["Mana-Tombs (Heroic)"] = {
dungeonmap="9104H", heroic=1,
{ boss="18341", name="Pandemonius",
ALL={
30584,
30585,
30583,
27816,
27818,
27813,
27815,
27814,
27817,
},
},
{ boss="18343", name="Tavarok",
ALL={
30584,
30585,
30583,
27824,
27821,
27825,
27826,
27823,
27822,
},
},
{ boss="18344", name="Nexus-Prince Shaffar",
ALL={
29240,
30535,
29352,
32082,
27831,
27843,
27827,
27835,
27844,
27798,
33835,
28490,
30584,
30585,
30583,
27837,
27828,
28400,
27829,
27840,
27842,
22921,
},
},
{ boss="22930", name="Yor <Void Hound of Shaffar>",
ALL={
31919,
31920,
31921,
31922,
31923,
31924,
31554,
31562,
31570,
31578,
30584,
30585,
30583,
},
},
}
DugisGearFinderData["Old Hillsbrad Foothills"] = {
dungeonmap=9105, normal=1,
{ boss="17848", name="Lieutenant Drake",
ALL={
27423,
27418,
27417,
27420,
27436,
},
},
{ boss="17862", name="Captain Skarloc",
ALL={
27428,
27430,
27427,
27424,
27426,
21524,
22927,
},
},
{ boss="18096", name="Epoch Hunter",
ALL={
24173,
27433,
27434,
27440,
27432,
27431,
},
},
{ boss="28132", name="Don Carlos",
ALL={
38276,
38329,
},
},
}
DugisGearFinderData["Old Hillsbrad Foothills (Heroic)"] = {
dungeonmap="9105H", heroic=1,
{ boss="17848", name="Lieutenant Drake",
ALL={
30589,
30591,
30590,
28212,
28214,
28215,
28211,
28213,
28210,
},
},
{ boss="17862", name="Captain Skarloc",
ALL={
30589,
30591,
30590,
28218,
28220,
28219,
28221,
28217,
28216,
21524,
22927,
},
},
{ boss="18096", name="Epoch Hunter",
ALL={
29250,
29246,
29357,
30534,
30536,
27911,
28344,
28233,
27904,
28227,
28223,
28226,
28222,
30589,
30591,
30590,
24173,
28191,
28224,
28401,
28225,
33847,
},
},
{ boss="28132", name="Don Carlos",
ALL={
38506,
38276,
38329,
},
},
}
DugisGearFinderData["Sethekk Halls"] = {
dungeonmap=9106, normal=1,
{ boss="18472", name="Darkweaver Syth",
ALL={
27919,
27914,
27915,
27918,
27917,
27916,
24160,
27633,
},
},
{ boss="18473", name="Talon King Ikiss",
ALL={
27946,
27981,
27985,
27925,
27980,
27986,
27632,
27991,
27948,
27838,
27875,
27776,
27936,
},
},
}
DugisGearFinderData["Sethekk Halls (Heroic)"] = {
dungeonmap="9106H", heroic=1,
{ boss="18472", name="Darkweaver Syth",
ALL={
30553,
30554,
30552,
27919,
27914,
27915,
27918,
27917,
27916,
24160,
27633,
25461,
},
},
{ boss="18473", name="Talon King Ikiss",
ALL={
29249,
29259,
32073,
29355,
27946,
27981,
27985,
27925,
27980,
27986,
27991,
30553,
30554,
30552,
27948,
27838,
27875,
27776,
27936,
27632,
33834,
},
},
{ boss="23035", name="Anzu",
ALL={
32768,
30553,
30554,
30552,
32769,
32778,
32779,
32781,
32780,
},
},
}
DugisGearFinderData["Shadow Labyrinth"] = {
dungeonmap=9107, normal=1,
{ boss="18731", name="Ambassador Hellmaw",
ALL={
27889,
27888,
27884,
27886,
27887,
27885,
},
},
{ boss="18667", name="Blackheart the Inciter",
ALL={
27892,
27893,
28134,
27891,
27890,
25728,
30808,
27468,
},
},
{ boss="18732", name="Grandmaster Vorpil",
ALL={
27897,
27900,
27901,
27898,
21525,
30827,
27775,
},
},
{ boss="18708", name="Murmur",
ALL={
24309,
27902,
27912,
27913,
27905,
27903,
27910,
27778,
28232,
28230,
27908,
27909,
27803,
},
},
{ boss="22890", name="First Fragment Guardian",
ALL={
24514,
},
},
}
DugisGearFinderData["Shadow Labyrinth (Heroic)"] = {
dungeonmap="9107H", heroic=1,
{ boss="18731", name="Ambassador Hellmaw",
ALL={
30563,
30559,
30560,
27889,
27888,
27884,
27886,
27887,
27885,
},
},
{ boss="18667", name="Blackheart the Inciter",
ALL={
30563,
30559,
30560,
27892,
27893,
28134,
27891,
27890,
25728,
30808,
27468,
},
},
{ boss="18732", name="Grandmaster Vorpil",
ALL={
30563,
30559,
30560,
27897,
27900,
27901,
27898,
21525,
30827,
27775,
},
},
{ boss="18708", name="Murmur",
ALL={
30532,
29357,
29261,
29353,
27902,
27912,
27913,
27905,
27903,
27910,
31722,
30563,
30559,
30560,
24309,
27778,
28232,
28230,
27908,
27909,
27803,
33840,
},
},
}
DugisGearFinderData["The Arcatraz"] = {
dungeonmap=9108, normal=1,
{ boss="20870", name="Zereketh the Unboun",
ALL={
28373,
28374,
28384,
28375,
28372,
},
},
{ boss="20885", name="Dalliah the Doomsayer",
ALL={
24308,
28391,
28390,
28387,
28392,
28386,
},
},
{ boss="20886", name="Wrath-Scryer Soccothrates",
ALL={
28396,
28398,
28394,
28393,
28397,
},
},
{ boss="20912", name="Harbinger Skyriss",
ALL={
28406,
28419,
28407,
28418,
28412,
28416,
28415,
28413,
28414,
28231,
28403,
28205,
},
},
{ boss="22892", name="Third Fragment Guardian",
ALL={
24488,
},
},
}
DugisGearFinderData["The Arcatraz (Heroic)"] = {
dungeonmap="9108H", heroic=1,
{ boss="20870", name="Zereketh the Unboun",
ALL={
30582,
30575,
30581,
28373,
28374,
28384,
28375,
28372,
},
},
{ boss="20885", name="Dalliah the Doomsayer",
ALL={
30582,
30575,
30581,
28391,
28390,
28387,
28392,
28386,
24308,
},
},
{ boss="20886", name="Wrath-Scryer Soccothrates",
ALL={
30582,
30575,
30581,
28396,
28398,
28394,
28393,
28397,
},
},
{ boss="20912", name="Harbinger Skyriss",
ALL={
29241,
29248,
29252,
29360,
28406,
28419,
28407,
28418,
28412,
28416,
33861,
30582,
30575,
30581,
28415,
28413,
28414,
28231,
28403,
28205,
},
},
}
DugisGearFinderData["The Black Morass"] = {
dungeonmap=9109, normal=1,
{ boss="17879", name="Chrono Lord Deja",
ALL={
27988,
27994,
27995,
27993,
27996,
27987,
29675,
},
},
{ boss="17880", name="Temporus",
ALL={
28185,
28186,
28034,
28187,
28184,
28033,
},
},
{ boss="17881", name="Aeonus",
ALL={
28206,
28194,
28207,
28190,
28189,
28188,
28193,
27509,
27873,
28192,
27977,
27839,
},
},
}
DugisGearFinderData["The Black Morass (Heroic)"] = {
dungeonmap="9109H", heroic=1,
{ boss="17879", name="Chrono Lord Deja",
ALL={
30558,
30556,
30555,
27988,
27994,
27995,
27993,
27996,
27987,
29675,
},
},
{ boss="17880", name="Temporus",
ALL={
30558,
30556,
30555,
28185,
28186,
28034,
28187,
28184,
28033,
},
},
{ boss="17881", name="Aeonus",
ALL={
30531,
29247,
29253,
29356,
28206,
28194,
28207,
28190,
28189,
28188,
33858,
30558,
30556,
30555,
28193,
27509,
27873,
28192,
27977,
27839,
},
},
}
DugisGearFinderData["The Blood Furnace"] = {
dungeonmap=9110, normal=1,
{ boss="17381", name="The Maker",
ALL={
24388,
24387,
24385,
24386,
24384,
},
},
{ boss="17380", name="Broggok",
ALL={
24392,
24393,
24391,
24390,
24389,
},
},
{ boss="17377", name="Keli'dan the Breaker",
ALL={
24397,
24395,
24398,
24396,
24394,
},
},
}
DugisGearFinderData["The Blood Furnace (Heroic)"] = {
dungeonmap="9110H", heroic=1,
{ boss="17381", name="The Maker",
ALL={
30601,
30600,
30602,
27485,
27488,
27483,
27487,
27484,
},
},
{ boss="17380", name="Broggok",
ALL={
30601,
30600,
30602,
27848,
27492,
27489,
27491,
27490,
},
},
{ boss="17377", name="Keli'dan the Breaker",
ALL={
32080,
29245,
29239,
29347,
27506,
27514,
27522,
27494,
27505,
27788,
27495,
28121,
30601,
30600,
30602,
28264,
27497,
27512,
27507,
33814,
},
},
}
DugisGearFinderData["The Botanica"] = {
dungeonmap=9111, normal=1,
{ boss="17976", name="Commander Sarannis",
ALL={
28301,
28304,
28306,
28296,
28311,
28769,
},
},
{ boss="17975", name="High Botanist Freywinn",
ALL={
28317,
28318,
28321,
28315,
28316,
23617,
21524,
31744,
},
},
{ boss="17978", name="Thorngrin the Tender",
ALL={
24310,
28324,
28327,
28323,
28322,
28325,
},
},
{ boss="17980", name="Laj",
ALL={
28328,
28338,
28340,
28339,
27739,
},
},
{ boss="17977", name="Warp Splinter",
ALL={
24311,
28371,
28342,
28347,
28343,
28370,
28345,
28367,
28341,
31085,
28229,
28348,
28349,
28228,
28350,
},
},
}
DugisGearFinderData["The Botanica (Heroic)"] = {
dungeonmap="9111H", heroic=1,
{ boss="17976", name="Commander Sarannis",
ALL={
30574,
30572,
30573,
28301,
28304,
28306,
28296,
28311,
},
},
{ boss="17975", name="High Botanist Freywinn",
ALL={
30574,
30572,
30573,
28317,
28318,
28321,
28315,
28316,
21524,
23617,
31744,
},
},
{ boss="17978", name="Thorngrin the Tender",
ALL={
30574,
30572,
30573,
24310,
28324,
28327,
28323,
28322,
28325,
},
},
{ boss="17980", name="Laj",
ALL={
30574,
30572,
30573,
28328,
28338,
28340,
28339,
27739,
},
},
{ boss="17977", name="Warp Splinter",
ALL={
29258,
29262,
32072,
29359,
28371,
28342,
28347,
28343,
28370,
28345,
28367,
28341,
30574,
30572,
30573,
24311,
28229,
28348,
28349,
28228,
28350,
31085,
33859,
},
},
}
DugisGearFinderData["The Mechanar"] = {
dungeonmap=9112, normal=1,
{ boss="19219", name="Mechano-Lord Capacitus",
ALL={
28256,
28255,
28254,
28257,
28253,
35582,
},
},
{ boss="19221", name="Nethermancer Sepethrea",
ALL={
28262,
28259,
28260,
28263,
28258,
21524,
22920,
},
},
{ boss="19220", name="Pathaleon the Calculator",
ALL={
28269,
28266,
28265,
28288,
27899,
28267,
28286,
21907,
31086,
28278,
28202,
28204,
28275,
28285,
},
},
}
DugisGearFinderData["The Mechanar (Heroic)"] = {
dungeonmap="9112H", heroic=1,
{ boss="19219", name="Mechano-Lord Capacitus",
ALL={
30565,
30566,
30564,
28256,
28255,
28254,
28257,
28253,
35582,
},
},
{ boss="19221", name="Nethermancer Sepethrea",
ALL={
30565,
30566,
30564,
28262,
28259,
28260,
28263,
28258,
21524,
22920,
},
},
{ boss="19220", name="Pathaleon the Calculator",
ALL={
29251,
32076,
30533,
29362,
28269,
28266,
28265,
28288,
27899,
28267,
28286,
21907,
30565,
30566,
30564,
28278,
28202,
28204,
28275,
28285,
33860,
31086,
},
},
}
DugisGearFinderData["The Shattered Halls"] = {
dungeonmap=9113, normal=1,
{ boss="16807", name="Grand Warlock Nethekurse",
ALL={
24312,
27519,
27517,
27521,
27520,
27518,
21525,
23735,
},
},
{ boss="16809", name="Warbringer O'mrogg",
ALL={
27525,
27868,
27524,
27526,
30829,
27802,
},
},
{ boss="16808", name="Warchief Kargath Bladefist",
ALL={
27527,
27529,
27534,
27533,
27538,
27540,
23723,
27536,
27537,
27531,
27474,
27528,
27535,
},
},
}
DugisGearFinderData["The Shattered Halls (Heroic)"] = {
dungeonmap="9113H", heroic=1,
{ boss="16807", name="Grand Warlock Nethekurse",
ALL={
24312,
30548,
30547,
30546,
27519,
27517,
27521,
27520,
27518,
23735,
25462,
21525,
},
},
{ boss="20923", name="Blood Guard Porung",
ALL={
30548,
30547,
30546,
30709,
30707,
30708,
30705,
30710,
},
},
{ boss="16809", name="Warbringer O'mrogg",
ALL={
30548,
30547,
30546,
27525,
27868,
27524,
27526,
30829,
27802,
},
},
{ boss="16808", name="Warchief Kargath Bladefist",
ALL={
29255,
29263,
29254,
29348,
27527,
27529,
27534,
27533,
27538,
27540,
23723,
33815,
30548,
30547,
30546,
27536,
27537,
27531,
27474,
27528,
27535,
},
},
{ boss="17301", name="Shattered Hand Executioner",
ALL={
31716,
},
},
}
DugisGearFinderData["The Slave Pens"] = {
dungeonmap=9114, normal=1,
{ boss="17941", name="Mennu the Betrayer",
ALL={
24359,
24357,
24360,
24356,
24361,
29674,
},
},
{ boss="17991", name="Rokmar the Crackler",
ALL={
24379,
24376,
24378,
24380,
24381,
},
},
{ boss="17942", name="Quagmirran",
ALL={
24362,
24365,
24366,
24363,
24364,
},
},
}
DugisGearFinderData["The Slave Pens (Heroic)"] = {
dungeonmap="9114", heroic=1,
{ boss="17941", name="Mennu the Betrayer",
ALL={
30604,
30605,
30603,
27542,
27545,
27541,
27546,
27544,
27543,
29674,
},
},
{ boss="17991", name="Rokmar the Crackler",
ALL={
30604,
30605,
30603,
27550,
27547,
28124,
27549,
27548,
27551,
},
},
{ boss="17942", name="Quagmirran",
ALL={
29242,
30538,
32078,
29349,
27712,
27800,
28337,
27672,
27742,
33821,
30604,
30605,
30603,
27796,
27713,
27740,
27683,
27714,
27673,
27741,
},
},
}
DugisGearFinderData["The Steamvault"] = {
dungeonmap=9115, normal=1,
{ boss="17797", name="Hydromancer Thespia",
ALL={
27789,
27787,
27783,
27784,
30828,
27508,
},
},
{ boss="17796", name="Mekgineer Steamrigger",
ALL={
27793,
27790,
27792,
27791,
27794,
},
},
{ boss="17798", name="Warlord Kalithresh",
ALL={
24313,
27804,
27799,
27795,
27806,
27805,
27738,
27737,
27801,
27510,
27874,
28203,
27475,
},
},
}
DugisGearFinderData["The Steamvault (Heroic)"] = {
dungeonmap="9115H", heroic=1,
{ boss="17797", name="Hydromancer Thespia",
ALL={
30550,
30551,
30549,
27789,
27787,
27783,
27784,
30828,
27508,
},
},
{ boss="17796", name="Mekgineer Steamrigger",
ALL={
30550,
30551,
30549,
27793,
27790,
27792,
27791,
27794,
},
},
{ boss="17798", name="Warlord Kalithresh",
ALL={
30543,
29243,
29463,
29351,
27804,
27799,
27795,
27806,
27805,
31721,
33827,
24313,
30550,
30551,
30549,
27738,
27737,
27801,
27510,
27874,
28203,
27475,
},
},
}
DugisGearFinderData["The Underbog"] = {
dungeonmap=9116, normal=1,
{ boss="17770", name="Hungarfen",
ALL={
24450,
24452,
24451,
24413,
27631,
},
},
{ boss="18105", name="Ghaz'an",
ALL={
24459,
24458,
24460,
24462,
24461,
},
},
{ boss="17826", name="Swamplord Musel'ek",
ALL={
24454,
24455,
24457,
24456,
24453,
},
},
{ boss="17882", name="The Black Stalker",
ALL={
24481,
24466,
24465,
24463,
24464,
24248,
},
},
}
DugisGearFinderData["The Underbog (Heroic)"] = {
dungeonmap="9116H", heroic=1,
{ boss="17770", name="Hungarfen",
ALL={
30606,
30607,
30608,
27746,
27745,
27743,
27748,
27744,
27747,
},
},
{ boss="18105", name="Ghaz'an",
ALL={
30606,
30607,
30608,
27760,
27759,
27755,
27758,
27761,
27757,
},
},
{ boss="17826", name="Swamplord Musel'ek",
ALL={
30606,
30607,
30608,
27764,
27763,
27765,
27766,
27762,
27767,
},
},
{ boss="17882", name="The Black Stalker",
ALL={
29265,
30541,
32081,
29350,
27781,
27768,
27938,
27773,
27779,
27780,
27896,
27770,
30606,
30607,
30608,
27907,
27771,
27769,
27772,
24248,
33826,
},
},
}
DugisGearFinderData["Raid: Black Temple"] = {
dungeonmap=9117, normal=1,
{ boss="22887", name="High Warlord Naj'entus",
ALL={
32239,
32240,
32377,
32241,
32234,
32242,
32232,
32243,
32245,
32238,
32247,
32237,
32236,
32248,
},
},
{ boss="22898", name="Supremus",
ALL={
32256,
32252,
32259,
32251,
32258,
32250,
32260,
32261,
32257,
32254,
32262,
32255,
32253,
},
},
{ boss="22841", name="Shade of Akama",
ALL={
32273,
32270,
32513,
32265,
32271,
32264,
32275,
32276,
32279,
32278,
32263,
32268,
32266,
32361,
},
},
{ boss="22871", name="Teron Gorefiend",
ALL={
32323,
32329,
32327,
32324,
32328,
32510,
32280,
32512,
32330,
32348,
32326,
32325,
},
},
{ boss="22948", name="Gurtogg Bloodboil",
ALL={
32337,
32338,
32340,
32339,
32334,
32342,
32333,
32341,
32335,
32501,
32269,
32344,
32343,
},
},
{ boss="22856", name="Reliquary of the Lost",
ALL={
32353,
32351,
32347,
32352,
32517,
32346,
32354,
32345,
32349,
32362,
32350,
32332,
32363,
},
},
{ boss="22947", name="Mother Shahraz",
ALL={
32367,
32366,
32365,
32370,
32368,
32369,
31101,
31103,
31102,
},
},
{ boss="23426", name="The Illidari Council",
ALL={
32331,
32519,
32518,
32376,
32373,
32505,
31098,
31100,
31099,
},
},
{ boss="22917", name="Illidan Stormrage",
ALL={
32524,
32525,
32235,
32521,
32497,
32483,
32496,
32837,
32838,
31089,
31091,
31090,
32471,
32500,
32374,
32375,
32336,
},
},
}
DugisGearFinderData["Raid: Gruul's Lair"] = {
dungeonmap=9118, normal=1,
{ boss="18831", name="High King Maulgar",
ALL={
28797,
28799,
28796,
28801,
28795,
28800,
29763,
29764,
29762,
},
},
{ boss="19044", name="Gruul the Dragonkiller",
ALL={
28804,
28803,
28828,
28827,
28810,
28824,
28822,
28823,
28830,
31750,
29766,
29767,
29765,
28802,
28794,
28825,
28826,
},
},
}
DugisGearFinderData["Raid: Hyjal Summit"] = {
dungeonmap=9119, normal=1,
{ boss="17767", name="Rage Winterchill",
ALL={
30871,
30870,
30863,
30868,
30864,
30869,
30873,
30866,
30862,
30861,
30865,
30872,
32459,
},
},
{ boss="17808", name="Anetheron",
ALL={
30884,
30888,
30885,
30879,
30886,
30887,
30880,
30878,
30874,
30881,
30883,
30882,
},
},
{ boss="17888", name="Kaz'rogal",
ALL={
30895,
30916,
30894,
30917,
30914,
30891,
30892,
30919,
30893,
30915,
30918,
30889,
},
},
{ boss="17842", name="Azgalor",
ALL={
30899,
30898,
30900,
30896,
30897,
30901,
31092,
31094,
31093,
},
},
{ boss="17968", name="Archimonde",
ALL={
30913,
30912,
30905,
30907,
30904,
30903,
30911,
30910,
30902,
30908,
30909,
30906,
31097,
31095,
31096,
},
},
}
DugisGearFinderData["Raid: Karazhan"] = {
dungeonmap=9120, normal=1,
{ boss="16152", name="Attumen the Huntsman",
ALL={
28477,
28507,
28508,
28453,
28506,
28503,
28454,
28502,
28505,
28509,
28510,
28504,
30480,
23809,
},
},
{ boss="16181", name="Rokad the Ravager",
ALL={
30684,
30685,
30686,
30687,
},
},
{ boss="16180", name="Shadikith the Glider",
ALL={
30680,
30681,
30682,
30683,
},
},
{ boss="16179", name="Hyakiss the Lurker",
ALL={
30675,
30676,
30677,
30678,
},
},
{ boss="15687", name="Moroes",
ALL={
28529,
28570,
28565,
28545,
28567,
28566,
28569,
28530,
28528,
28525,
28568,
28524,
22559,
},
},
{ boss="16457", name="Maiden of Virtue",
ALL={
28511,
28515,
28517,
28514,
28521,
28520,
28519,
28512,
28518,
28516,
28523,
28522,
},
},
{ boss="18168", name="The Wizard of Oz",
ALL={
28586,
28585,
28587,
28588,
28594,
28591,
28589,
28593,
28590,
28592,
},
},
{ boss="17521", name="The Big Bad Wolf",
ALL={
28582,
28583,
28584,
28581,
28594,
28591,
28589,
28593,
28590,
28592,
},
},
{ boss="17533", name="Romulo and Julianne",
ALL={
28578,
28579,
28572,
28573,
28594,
28591,
28589,
28593,
28590,
28592,
},
},
{ boss="15691", name="The Curator",
ALL={
28612,
28647,
28631,
28621,
28649,
28633,
29757,
29758,
29756,
},
},
{ boss="15688", name="Terestian Illhoof",
ALL={
28660,
28653,
28652,
28654,
28655,
28656,
28662,
28661,
28785,
28657,
28658,
28659,
22561,
},
},
{ boss="16524", name="Shade of Aran",
ALL={
28672,
28726,
28670,
28663,
28669,
28671,
28666,
23933,
28674,
28675,
28727,
28728,
28673,
22560,
},
},
{ boss="15689", name="Netherspite",
ALL={
28744,
28742,
28732,
28741,
28735,
28740,
28743,
28733,
28731,
28730,
28734,
28729,
},
},
{ boss="15690", name="Prince Malchezaar",
ALL={
28765,
28766,
28764,
28762,
28763,
28757,
28770,
28768,
28767,
28773,
28771,
28772,
29760,
29761,
29759,
},
},
{ boss="17225", name="Nightbane",
ALL={
28602,
28600,
28601,
28599,
28610,
28597,
28608,
31751,
24139,
28609,
28603,
28604,
28611,
28606,
},
},
}
DugisGearFinderData["Raid: Magtheridon's Lair"] = {
dungeonmap=9121, normal=1,
{ boss="17257", name="Magtheridon",
ALL={
28777,
28780,
28776,
28778,
28775,
28779,
28789,
28781,
28774,
28782,
29458,
28783,
29754,
29753,
29755,
32385,
34845,
34846,
},
},
}
DugisGearFinderData["Raid: Serpentshrine Cavern"] = {
dungeonmap=9122, normal=1,
{ boss="21216", name="Hydross the Unstable",
ALL={
30056,
32516,
30050,
30055,
30047,
30054,
30048,
30053,
30052,
33055,
30664,
30629,
30049,
30051,
},
},
{ boss="21217", name="The Lurker Below",
ALL={
30064,
30067,
30062,
30060,
30066,
30065,
30057,
30059,
30061,
33054,
30665,
30063,
30058,
},
},
{ boss="21215", name="Leotheras the Blind",
ALL={
30092,
30097,
30091,
30096,
30627,
30095,
30239,
30240,
30241,
},
},
{ boss="21214", name="Fathom-Lord Karathress",
ALL={
30100,
30101,
30099,
30663,
30626,
30090,
30245,
30246,
30247,
},
},
{ boss="21213", name="Morogrim Tidewalker",
ALL={
30098,
30079,
30075,
30085,
30068,
30084,
30081,
30008,
30083,
33058,
30720,
30082,
30080,
},
},
{ boss="21212", name="Lady Vashj",
ALL={
30107,
30111,
30106,
30104,
30102,
30112,
30109,
30110,
30621,
30103,
30108,
30105,
30242,
30243,
30244,
29906,
},
},
}
DugisGearFinderData["Raid: Sunwell Plateau"] = {
dungeonmap=9123, normal=1,
{ boss="24850", name="Kalecgos",
ALL={
34170,
34386,
34169,
34384,
34168,
34167,
34382,
34166,
34165,
34164,
34848,
34851,
34852,
},
},
{ boss="24882", name="Brutallus",
ALL={
34181,
34180,
34381,
34178,
34177,
34179,
34176,
34853,
34854,
34855,
},
},
{ boss="25038", name="Felmyst",
ALL={
34352,
34188,
34385,
34186,
34383,
34184,
34185,
34182,
34856,
34857,
34858,
},
},
{ boss="25166", name="Eredar Twins",
ALL={
34205,
34190,
34210,
34202,
34393,
34209,
34391,
34195,
34392,
34194,
34208,
34390,
34192,
34388,
34193,
34389,
35290,
35291,
35292,
34204,
34189,
34206,
34197,
34199,
34203,
34198,
34196,
},
},
{ boss="25741", name="M'uru",
ALL={
34232,
34233,
34399,
34212,
34398,
34211,
34397,
34234,
34408,
34229,
34396,
34228,
34215,
34394,
34240,
34216,
34395,
34213,
34230,
35282,
35283,
35284,
34427,
34430,
34429,
34428,
34214,
34231,
},
},
{ boss="25315", name="Kil'jaeden",
ALL={
34241,
34242,
34339,
34405,
34340,
34342,
34406,
34344,
34244,
34404,
34245,
34403,
34333,
34332,
34402,
34343,
34243,
34401,
34345,
34400,
34341,
34334,
34329,
34247,
34335,
34331,
34336,
34337,
},
},
}
DugisGearFinderData["Raid: Tempest Keep"] = {
dungeonmap=9124, normal=1,
{ boss="19514", name="Al'ar",
ALL={
29925,
29918,
29947,
29921,
29922,
29920,
30448,
30447,
29923,
32944,
29948,
29924,
29949,
},
},
{ boss="19516", name="Void Reaver",
ALL={
29986,
29984,
29985,
29983,
32515,
30619,
30450,
30248,
30249,
30250,
},
},
{ boss="18805", name="High Astromancer Solarian",
ALL={
29977,
29972,
29966,
29976,
29951,
29965,
29950,
32267,
30446,
30449,
29962,
29981,
29982,
},
},
{ boss="19622", name="Kael'thas Sunstrider",
ALL={
29992,
29989,
29994,
29990,
29987,
29995,
29991,
29998,
29997,
29993,
29996,
29988,
30236,
30237,
30238,
32458,
32405,
29905,
},
},
}
DugisGearFinderData["Raid: Zul'Aman"] = {
dungeonmap=9125, normal=1,
{ boss="23574", name="Akil'zon",
ALL={
33286,
33215,
33216,
33281,
33293,
33214,
33283,
},
},
{ boss="23576", name="Nalorakk",
ALL={
33203,
33285,
33211,
33206,
33327,
33191,
33640,
},
},
{ boss="23578", name="Jan'alai",
ALL={
33357,
33356,
33329,
33328,
33354,
33326,
33332,
},
},
{ boss="23577", name="Halazzi",
ALL={
33317,
33300,
33322,
33533,
33299,
33303,
33297,
},
},
{ boss="24239", name="Hex Lord Malacrass",
ALL={
33592,
33453,
33463,
33432,
33464,
33421,
33446,
33829,
34029,
33828,
33389,
33298,
33388,
33465,
},
},
{ boss="23863", name="Zul'jin",
ALL={
33471,
33479,
33469,
33473,
33466,
33830,
33831,
33467,
33478,
33476,
33468,
33474,
33102,
},
},
}
     

DugisGearFinderData["Ahn'kahet: The Old Kingdom"] = {
normal=1, dungeonmap=619,
{ boss="29309", name="Elder Nadox",
ALL={
35607,
35608,
35606,
},
},
{ boss="29311", name="Herald Volazj",
ALL={
35612,
35613,
35614,
},
},
{ boss="29308", name="Prince Taldaram",
ALL={
35611,
35610,
35609,
},
},
{ boss="29310", name="Jedoga Shadowseeker",
ALL={
43278,
43279,
43277,
21524,
},
},
}
DugisGearFinderData["Ahn'kahet: The Old Kingdom (Heroic)"] = {
heroic=1, dungeonmap="619H",
{ boss="30258", name="Amanitar",
ALL={
47241,
43287,
43286,
43285,
43284,
},
},
{ boss="29309", name="Elder Nadox",
ALL={
47241,
37594,
37593,
37592,
37591,
},
},
{ boss="29311", name="Herald Volazj",
ALL={
47241,
37622,
37623,
37620,
37619,
37616,
37618,
37617,
37615,
41790,
43102,
},
},
{ boss="29308", name="Prince Taldaram",
ALL={
47241,
37613,
37614,
37612,
37595,
},
},
{ boss="29310", name="Jedoga Shadowseeker",
ALL={
47241,
43283,
43280,
43282,
43281,
21524,
},
},
}
DugisGearFinderData["Azjol-Nerub"] = {
normal=1, dungeonmap=601,
{ boss="28921", name="Hadronox",
ALL={
35660,
35659,
35658,
},
},
{ boss="29120", name="Anub'arak",
ALL={
35663,
35662,
35661,
43411,
},
},
{ boss="28684", name="Krik'thir the Gatewatcher",
ALL={
35657,
35656,
35655,
},
},
}
DugisGearFinderData["Azjol-Nerub (Heroic)"] = {
heroic=1, dungeonmap="601H",
{ boss="28921", name="Hadronox",
ALL={
47241,
37222,
37230,
37221,
37220,
},
},
{ boss="29120", name="Anub'arak",
ALL={
47241,
37242,
37240,
37241,
37238,
37236,
37237,
37232,
37235,
41796,
43102,
},
},
{ boss="28684", name="Krik'thir the Gatewatcher",
ALL={
47241,
37218,
37219,
37217,
37216,
},
},
}
DugisGearFinderData["Drak'Tharon Keep"] = {
normal=1, dungeonmap=600,
{ boss="26630", name="Trollgore",
ALL={
35620,
35619,
35618,
},
},
{ boss="27483", name="King Dred",
ALL={
35635,
35634,
35633,
},
},
{ boss="26631", name="Novos the Summoner",
ALL={
35632,
35631,
35630,
},
},
{ boss="26632", name="The Prophet Tharon'ja",
ALL={
35638,
35637,
35636,
},
},
}
DugisGearFinderData["Drak'Tharon Keep (Heroic)"] = {
heroic=1, dungeonmap="600H",
{ boss="26630", name="Trollgore",
ALL={
47241,
37715,
37714,
37717,
37712,
},
},
{ boss="27483", name="King Dred",
ALL={
47241,
37725,
37724,
37726,
37723,
},
},
{ boss="26631", name="Novos the Summoner",
ALL={
47241,
37722,
37718,
37721,
},
},
{ boss="26632", name="The Prophet Tharon'ja",
ALL={
47241,
37798,
37791,
37788,
37784,
37735,
37732,
37734,
37733,
41795,
43102,
},
},
}
DugisGearFinderData["Gundrak"] = {
normal=1, dungeonmap=604,
{ boss="29307", name="Drakkari Colossus",
ALL={
35591,
35592,
35590,
},
},
{ boss="29304", name="Slad'ran",
ALL={
35584,
35585,
35583,
},
},
{ boss="29306", name="Gal'darah",
ALL={
43305,
43309,
43306,
},
},
{ boss="29305", name="Moorabi",
ALL={
35588,
35589,
35587,
},
},
}
DugisGearFinderData["Gundrak (Heroic)"] = {
heroic=1, dungeonmap="604H",
{ boss="29307", name="Drakkari Colossus",
ALL={
47241,
37637,
37636,
37634,
37635,
},
},
{ boss="29304", name="Slad'ran",
ALL={
47241,
37629,
37628,
37627,
37626,
},
},
{ boss="29306", name="Gal'darah",
ALL={
47241,
37643,
37644,
37645,
37642,
37641,
37640,
37639,
37638,
43102,
},
},
{ boss="29305", name="Moorabi",
ALL={
47241,
37630,
37633,
37632,
37631,
},
},
{ boss="29932", name="Eck the Ferocious",
ALL={
47241,
43313,
43312,
43311,
43310,
},
},
}
DugisGearFinderData["Halls of Lightning"] = {
normal=1, dungeonmap=602,
{ boss="28923", name="Loken",
ALL={
36991,
36996,
36992,
36995,
36988,
36993,
36994,
36989,
41799,
43151,
},
},
{ boss="28546", name="Ionar",
ALL={
39536,
39657,
39534,
39535,
},
},
{ boss="28586", name="General Bjarngrim",
ALL={
36982,
36979,
36980,
36981,
},
},
{ boss="28587", name="Volkhan",
ALL={
36983,
36985,
36986,
36984,
},
},
}
DugisGearFinderData["Halls of Lightning (Heroic)"] = {
heroic=1, dungeonmap="602H",
{ boss="28923", name="Loken",
ALL={
47241,
37854,
37853,
37855,
37852,
37851,
37850,
37849,
37848,
41799,
43102,
},
},
{ boss="28546", name="Ionar",
ALL={
47241,
37846,
37845,
37826,
37844,
},
},
{ boss="28586", name="General Bjarngrim",
ALL={
47241,
37825,
37818,
37814,
37826,
},
},
{ boss="28587", name="Volkhan",
ALL={
47241,
37840,
37843,
37842,
37841,
},
},
}
DugisGearFinderData["Halls of Reflection"] = {
normal=1, dungeonmap=668,
{ boss="38113", name="Marwyn",
ALL={
49834,
49838,
49837,
49836,
49833,
49835,
},
},
{ boss="37226", name="The Lich King",
ALL={
49842,
49849,
49848,
49841,
49847,
49851,
49843,
49846,
49839,
49840,
49845,
49844,
},
},
{ boss="38112", name="Falric",
ALL={
49832,
49828,
49830,
49831,
49829,
49827,
},
},
}
DugisGearFinderData["Halls of Reflection (Heroic)"] = {
heroic=1, dungeonmap="668H",
{ boss="38113", name="Marwyn",
ALL={
50298,
50299,
50300,
50297,
50260,
50296,
},
},
{ boss="37226", name="The Lich King",
ALL={
50314,
50312,
50308,
50304,
50311,
50305,
50310,
50313,
50306,
50309,
50302,
50303,
},
},
{ boss="38112", name="Falric",
ALL={
50292,
50293,
50295,
50294,
50290,
50291,
},
},
}
DugisGearFinderData["Halls of Stone"] = {
normal=1, dungeonmap=599,
{ boss="27978", name="Sjonnir The Ironshaper",
ALL={
35679,
35678,
35680,
},
},
{ boss="27975", name="Maiden of Grief",
ALL={
38614,
38613,
38611,
},
},
{ boss="27977", name="Krystallus",
ALL={
35673,
35672,
35670,
},
},
{ boss="28234", name="The Tribunal of Ages",
ALL={
35677,
35676,
35675,
},
},
}
DugisGearFinderData["Halls of Stone (Heroic)"] = {
heroic=1, dungeonmap="599H",
{ boss="27978", name="Sjonnir The Ironshaper",
ALL={
47241,
37669,
37668,
37670,
37667,
37666,
37658,
37657,
37660,
41792,
43102,
},
},
{ boss="27975", name="Maiden of Grief",
ALL={
47241,
38616,
38615,
38617,
38618,
},
},
{ boss="27977", name="Krystallus",
ALL={
47241,
37652,
37650,
37651,
},
},
{ boss="28234", name="The Tribunal of Ages",
ALL={
47241,
37655,
37656,
37654,
37653,
},
},
}
DugisGearFinderData["Pit of Saron"] = {
normal=1, dungeonmap=658,
{ boss="36477", name="Krick and Ick",
ALL={
49809,
49810,
49811,
49808,
49812,
49807,
},
},
{ boss="36658", name="Scourgelord Tyrannus",
ALL={
49823,
49825,
49822,
49817,
49824,
49826,
49820,
49819,
49816,
49818,
49821,
49813,
},
},
{ boss="36494", name="Forgemaster Garfrost",
ALL={
49805,
49806,
49804,
49803,
49802,
49801,
},
},
}
DugisGearFinderData["Pit of Saron (Heroic)"] = {
heroic=1, dungeonmap="658H",
{ boss="36477", name="Krick and Ick",
ALL={
50266,
50263,
50264,
50265,
50235,
50262,
},
},
{ boss="36658", name="Scourgelord Tyrannus",
ALL={
50286,
50269,
50270,
50283,
50272,
50285,
50284,
50271,
50259,
50268,
50267,
50273,
},
},
{ boss="36494", name="Forgemaster Garfrost",
ALL={
50233,
50234,
50230,
50229,
50228,
50227,
},
},
}
DugisGearFinderData["The Culling of Stratholme"] = {
normal=1, dungeonmap=595,
{ boss="26533", name="Mal'Ganis",
ALL={
37113,
37114,
37110,
37109,
37111,
37108,
37112,
37107,
},
},
{ boss="26530", name="Salramm the Fleshcrafter",
ALL={
37084,
37095,
37088,
37086,
},
},
{ boss="26529", name="Meathook",
ALL={
37083,
37082,
37079,
37081,
},
},
{ boss="32273", name="Infinite Corruptor",
ALL={
47241,
43951,
},
},
{ boss="26532", name="Chrono-Lord Epoch",
ALL={
37106,
37105,
37096,
37099,
},
},
}
DugisGearFinderData["The Culling of Stratholme (Heroic)"] = {
heroic=1, dungeonmap="595H",
{ boss="26530", name="Salramm the Fleshcrafter",
ALL={
47241,
37684,
37682,
37683,
37681,
},
},
{ boss="26533", name="Mal'Ganis",
ALL={
47241,
37696,
37695,
37694,
37693,
43085,
37691,
37690,
37689,
37692,
43102,
},
},
{ boss="26529", name="Meathook",
ALL={
47241,
37680,
37678,
37679,
37675,
},
},
{ boss="26532", name="Chrono-Lord Epoch",
ALL={
47241,
37687,
37686,
37688,
37685,
},
},
}
DugisGearFinderData["The Forge of Souls"] = {
normal=1, dungeonmap=632,
{ boss="36497", name="Bronjahm",
ALL={
49788,
49785,
49786,
49787,
49784,
49783,
50317,
50316,
},
},
{ boss="36502", name="Devourer of Souls",
ALL={
49792,
49796,
49798,
49791,
49797,
49794,
49795,
49799,
49800,
49789,
49790,
49793,
},
},
}
DugisGearFinderData["The Forge of Souls (Heroic)"] = {
heroic=1, dungeonmap="632H",
{ boss="36497", name="Bronjahm",
ALL={
50193,
50197,
50194,
50196,
50191,
50169,
50317,
50316,
},
},
{ boss="36502", name="Devourer of Souls",
ALL={
50213,
50206,
50212,
50214,
50209,
50208,
50207,
50215,
50211,
50198,
50203,
50210,
},
},
}
DugisGearFinderData["The Nexus"] = {
normal=1, dungeonmap=576,
{ boss="26731", name="Grand Magus Telestra",
ALL={
35605,
35604,
35617,
21524,
},
},
{ boss="26723", name="Keristrasza",
ALL={
35596,
35595,
35597,
},
},
{ boss="26763", name="Anomalus",
ALL={
35599,
35600,
35598,
},
},
{ boss="26794", name="Ormorok the Tree-Shaper",
ALL={
35602,
35603,
35601,
},
},
}
DugisGearFinderData["The Nexus (Heroic)"] = {
heroic=1, dungeonmap="576H",
{ boss="26731", name="Grand Magus Telestra",
ALL={
47241,
37139,
37138,
37135,
37134,
21524,
},
},
{ boss="26723", name="Keristrasza",
ALL={
47241,
37172,
37170,
37171,
37169,
37165,
37167,
37166,
37162,
41794,
43102,
},
},
{ boss="26763", name="Anomalus",
ALL={
47241,
37149,
37144,
37150,
37141,
},
},
{ boss="26798", name="Commander Kolurg",
ALL={
47241,
37728,
37731,
37730,
37729,
},
},
{ boss="26794", name="Ormorok the Tree-Shaper",
ALL={
47241,
37153,
37155,
37152,
37151,
},
},
}
DugisGearFinderData["The Oculus"] = {
normal=1, dungeonmap=578,
{ boss="27655", name="Mage-Lord Urom",
ALL={
36954,
36951,
36953,
36952,
21525,
},
},
{ boss="27447", name="Varos Cloudstrider",
ALL={
36947,
36949,
36948,
36950,
},
},
{ boss="27654", name="Drakos the Interrogator",
ALL={
36945,
36946,
36943,
36944,
},
},
{ boss="27656", name="Ley-Guardian Eregos",
ALL={
36973,
36971,
36969,
36974,
36961,
36972,
36962,
36975,
41798,
},
},
}
DugisGearFinderData["The Oculus (Heroic)"] = {
heroic=1, dungeonmap="578H",
{ boss="27655", name="Mage-Lord Urom",
ALL={
47241,
37289,
37288,
37195,
37264,
21525,
},
},
{ boss="27447", name="Varos Cloudstrider",
ALL={
47241,
37261,
37262,
37263,
37260,
},
},
{ boss="27654", name="Drakos the Interrogator",
ALL={
47241,
37258,
37256,
37257,
37255,
},
},
{ boss="27656", name="Ley-Guardian Eregos",
ALL={
47241,
37361,
37363,
37362,
37360,
37291,
37294,
37293,
37292,
43102,
},
},
}
DugisGearFinderData["The Violet Hold"] = {
normal=1, dungeonmap=608,
{ boss="29266", name="Xevozz",
ALL={
35644,
35642,
},
},
{ boss="29314", name="Zuramat the Obliterator",
ALL={
43353,
43358,
},
},
{ boss="29313", name="Ichoron",
ALL={
35647,
35643,
},
},
{ boss="31134", name="Cyanigosa",
ALL={
35650,
35651,
35649,
},
},
{ boss="29316", name="Moragg",
ALL={
43387,
43382,
},
},
{ boss="29315", name="Erekem",
ALL={
43363,
43375,
},
},
{ boss="29312", name="Lavanthor",
ALL={
35646,
35645,
},
},
}
DugisGearFinderData["The Violet Hold (Heroic)"] = {
heroic=1, dungeonmap="608H",
{ boss="29266", name="Xevozz",
ALL={
47241,
37867,
37868,
37861,
},
},
{ boss="29314", name="Zuramat the Obliterator",
ALL={
47241,
43403,
43402,
43404,
},
},
{ boss="29313", name="Ichoron",
ALL={
47241,
43401,
37862,
37869,
},
},
{ boss="31134", name="Cyanigosa",
ALL={
47241,
37884,
37886,
43500,
37883,
37876,
37875,
37874,
37873,
41791,
43102,
},
},
{ boss="29316", name="Moragg",
ALL={
47241,
43410,
43408,
43409,
},
},
{ boss="29315", name="Erekem",
ALL={
47241,
43406,
43405,
43407,
},
},
{ boss="29312", name="Lavanthor",
ALL={
47241,
37870,
37872,
37871,
},
},
}
DugisGearFinderData["Trial of the Champion"] = {
normal=1, dungeonmap=650,
{ boss="35119", name="Eadric the Pure",
ALL={
47181,
47185,
47210,
47177,
47202,
47178,
47176,
47197,
47201,
47199,
47200,
47213,
},
},
{ boss="34705", name="Faction Champions",
ALL={
47173,
47170,
47174,
47175,
47172,
47171,
},
},
{ boss="35451", name="The Black Knight",
ALL={
47232,
47226,
47230,
47221,
47231,
47228,
47220,
47229,
47227,
47222,
47215,
47216,
},
},
{ boss="34928", name="Argent Confessor Paletress",
ALL={
47181,
47218,
47185,
47217,
47177,
47178,
47211,
47176,
47212,
47219,
47213,
47214,
},
},
}
DugisGearFinderData["Trial of the Champion (Heroic)"] = {
heroic=1, dungeonmap="650H",
{ boss="35119", name="Eadric the Pure",
ALL={
47241,
47501,
47496,
47498,
47504,
47497,
47502,
47495,
47503,
47494,
47500,
47509,
47508,
44990,
},
},
{ boss="34705", name="Faction Champions",
ALL={
47241,
47249,
47248,
47250,
47244,
47243,
47493,
44990,
},
},
{ boss="35451", name="The Black Knight",
ALL={
47241,
47564,
47527,
47560,
47529,
47561,
47563,
47565,
47567,
47562,
47566,
47569,
49682,
47568,
43102,
44990,
},
},
{ boss="34928", name="Argent Confessor Paletress",
ALL={
47241,
47498,
47496,
47245,
47497,
47514,
47510,
47495,
47511,
47494,
47512,
47500,
47522,
44990,
},
},
}
DugisGearFinderData["Utgarde Keep"] = {
normal=1, dungeonmap=574,
{ boss="23953", name="Prince Keleseth",
ALL={
35572,
35571,
35570,
},
},
{ boss="24200", name="Skarvald the Constructor",
ALL={
35575,
35574,
35573,
},
},
{ boss="23954", name="Ingvar the Plunderer",
ALL={
35577,
35578,
35576,
33330,
},
},
}
DugisGearFinderData["Utgarde Keep (Heroic)"] = {
heroic=1, dungeonmap="574H",
{ boss="23953", name="Prince Keleseth",
ALL={
47241,
37180,
37178,
37179,
37177,
},
},
{ boss="24200", name="Skarvald the Constructor",
ALL={
47241,
37183,
37184,
37182,
37181,
},
},
{ boss="23954", name="Ingvar the Plunderer",
ALL={
47241,
37194,
37193,
37192,
37191,
37189,
37188,
37186,
37190,
41793,
43102,
},
},
}
DugisGearFinderData["Utgarde Pinnacle"] = {
normal=1, dungeonmap=575,
{ boss="26693", name="Skadi the Ruthless",
ALL={
37055,
37057,
37056,
37053,
},
},
{ boss="26861", name="King Ymiron",
ALL={
37067,
37062,
37066,
37058,
37064,
37060,
37065,
37061,
41797,
},
},
{ boss="26687", name="Gortok Palehoof",
ALL={
37048,
37052,
37051,
37050,
},
},
{ boss="26668", name="Svala Sorrowgrave",
ALL={
37043,
37040,
37037,
37038,
},
},
}
DugisGearFinderData["Utgarde Pinnacle (Heroic)"] = {
heroic=1, dungeonmap="575H",
{ boss="26693", name="Skadi the Ruthless",
ALL={
47241,
44151,
37389,
37379,
37377,
37384,
},
},
{ boss="26861", name="King Ymiron",
ALL={
47241,
37408,
37409,
37407,
37401,
37398,
37395,
37397,
37390,
41797,
43102,
},
},
{ boss="26687", name="Gortok Palehoof",
ALL={
47241,
37374,
37373,
37376,
37371,
},
},
{ boss="26668", name="Svala Sorrowgrave",
ALL={
47241,
37370,
37369,
37368,
37367,
},
},
}
DugisGearFinderData["Raid: Naxxramas (10)"] = {
normal=1, dungeonmap="533_10",
{ boss="15953", name="Grand Widow Faerlina",
ALL={
39216,
39215,
39196,
39217,
39194,
39198,
39195,
39197,
39199,
39200,
},
},
{ boss="15928", name="Thaddius",
ALL={
39295,
39294,
39293,
39292,
39291,
40619,
40620,
40621,
},
},
{ boss="15989", name="Sapphiron",
ALL={
39415,
39404,
39409,
39408,
39399,
39405,
39403,
39398,
39401,
39407,
44569,
44582,
},
},
{ boss="16060", name="Gothik the Harvester",
ALL={
39390,
39386,
39391,
39379,
39345,
39369,
39392,
39389,
39388,
39344,
},
},
{ boss="15931", name="Grobbulus",
ALL={
39284,
39285,
39283,
39279,
39278,
39280,
39282,
39277,
39281,
39276,
},
},
{ boss="16061", name="Instructor Razuvious",
ALL={
39297,
39310,
39309,
39299,
39308,
39307,
39306,
39298,
39311,
39296,
},
},
{ boss="16064", name="The Four Horsemen",
ALL={
39396,
39397,
39395,
39393,
39394,
40610,
40611,
40612,
},
},
{ boss="15954", name="Noth the Plaguebringer",
ALL={
39241,
39242,
39240,
39237,
39243,
39236,
39239,
39235,
39234,
39244,
},
},
{ boss="15952", name="Maexxna",
ALL={
39225,
39230,
39224,
39228,
39232,
39231,
39229,
39226,
39221,
39233,
},
},
{ boss="15932", name="Gluth",
ALL={
39272,
39284,
39396,
39309,
39237,
39279,
39191,
39215,
39294,
39248,
39194,
39251,
39379,
39188,
39345,
39146,
39232,
39193,
39388,
39200,
39344,
39281,
39394,
40622,
40623,
40624,
40610,
40611,
40612,
40619,
40620,
40621,
},
},
{ boss="16028", name="Patchwerk",
ALL={
39272,
39273,
39275,
39274,
39267,
39262,
39261,
39271,
39270,
},
},
{ boss="15956", name="Anub'Rekhan",
ALL={
39192,
39190,
39191,
39189,
39188,
39139,
39146,
39193,
39141,
39140,
},
},
{ boss="15990", name="Kel'Thuzad",
ALL={
39425,
39421,
39416,
39424,
39420,
39417,
39423,
39422,
39426,
39419,
40616,
40617,
40618,
},
},
{ boss="16011", name="Loatheb",
ALL={
39259,
39260,
39258,
39257,
39256,
40622,
40623,
40624,
},
},
{ boss="15936", name="Heigan the Unclean",
ALL={
39252,
39254,
39247,
39248,
39251,
39249,
39246,
39250,
39245,
39255,
},
},
}
DugisGearFinderData["Raid: Naxxramas (25)"] = {
normal=1, dungeonmap="533_25",
{ boss="15953", name="Grand Widow Faerlina",
ALL={
39732,
39731,
39733,
39735,
39756,
39727,
39724,
39734,
39723,
39725,
39729,
39726,
40071,
40065,
40069,
40064,
40080,
40075,
40107,
40108,
40074,
39757,
39728,
39730,
},
},
{ boss="15952", name="Maexxna",
ALL={
40250,
40254,
40252,
40253,
40251,
40062,
40060,
39768,
40063,
39765,
39761,
40061,
39762,
39760,
39767,
39764,
39759,
40257,
40255,
40258,
40256,
39766,
39763,
39758,
},
},
{ boss="16011", name="Loatheb",
ALL={
40247,
40246,
40249,
40243,
40242,
40241,
40240,
40244,
40239,
40245,
40637,
40638,
40639,
},
},
{ boss="16060", name="Gothik the Harvester",
ALL={
40250,
40254,
40252,
40253,
40251,
40339,
40338,
40329,
40341,
40333,
40340,
40331,
40328,
40334,
40332,
40330,
40257,
40255,
40258,
40256,
40342,
40337,
40336,
40335,
},
},
{ boss="15931", name="Grobbulus",
ALL={
40250,
40254,
40252,
40253,
40251,
40287,
40286,
40351,
40289,
40277,
40285,
40288,
40283,
40282,
40275,
40279,
40274,
40278,
40257,
40255,
40258,
40256,
40281,
40280,
40284,
},
},
{ boss="16061", name="Instructor Razuvious",
ALL={
40325,
40326,
40305,
40319,
40323,
40315,
40324,
40327,
40306,
40316,
40317,
40318,
40320,
40071,
40065,
40069,
40064,
40080,
40075,
40107,
40074,
40321,
40322,
},
},
{ boss="15928", name="Thaddius",
ALL={
40303,
40301,
40296,
40304,
40299,
40302,
40298,
40294,
40297,
40300,
40634,
40635,
40636,
},
},
{ boss="15954", name="Noth the Plaguebringer",
ALL={
40602,
40198,
40197,
40186,
40200,
40193,
40196,
40184,
40185,
40188,
40187,
40071,
40065,
40069,
40064,
40080,
40075,
40107,
40074,
40192,
40191,
40189,
40190,
},
},
{ boss="16064", name="The Four Horsemen",
ALL={
40349,
40344,
40352,
40347,
40350,
40345,
40343,
40348,
40346,
40625,
40626,
40627,
},
},
{ boss="15990", name="Kel'Thuzad",
ALL={
40405,
40403,
40398,
40387,
40399,
40383,
40386,
40396,
40402,
40384,
40395,
40388,
40401,
40400,
40385,
40631,
40632,
40633,
},
},
{ boss="16028", name="Patchwerk",
ALL={
40271,
40269,
40260,
40270,
40262,
40272,
40261,
40263,
40259,
40071,
40065,
40069,
40064,
40080,
40075,
40107,
40074,
40273,
40267,
40268,
40264,
40266,
40265,
},
},
{ boss="15956", name="Anub'Rekhan",
ALL={
39719,
39721,
39720,
39722,
39701,
39702,
39718,
39704,
39703,
39717,
39706,
40071,
40065,
40069,
40064,
40080,
40075,
40107,
40074,
39714,
40208,
39716,
39712,
},
},
{ boss="15932", name="Gluth",
ALL={
40247,
40289,
40602,
39733,
40303,
40326,
40296,
39768,
40319,
40260,
40205,
40270,
40193,
40209,
40302,
39718,
40242,
39760,
40185,
40203,
40332,
40188,
40259,
40204,
39717,
40206,
40297,
40350,
40191,
40281,
39714,
39730,
40343,
40239,
40280,
39716,
40265,
40346,
40637,
40638,
40639,
40625,
40626,
40627,
40634,
40635,
40636,
},
},
{ boss="15989", name="Sapphiron",
ALL={
40381,
40380,
40376,
40362,
40379,
40367,
40366,
40377,
40365,
40363,
40378,
40374,
40369,
40370,
40375,
40371,
40373,
40372,
40382,
40368,
44577,
44581,
},
},
{ boss="15936", name="Heigan the Unclean",
ALL={
40250,
40254,
40252,
40253,
40251,
40234,
40236,
40238,
40205,
40235,
40209,
40201,
40237,
40203,
40210,
40204,
40206,
40257,
40255,
40258,
40256,
40207,
40208,
40233,
},
},
}
DugisGearFinderData["Raid: The Eye of Eternity (25)"] = {
normal=1, dungeonmap="616_25",
{ boss="28859", name="Malygos",
ALL={
40526,
40519,
40511,
40486,
40474,
40491,
40488,
40489,
40497,
40475,
43952,
44569,
44650,
44658,
44660,
44659,
44657,
40562,
40555,
40194,
40561,
40560,
40558,
40594,
40539,
40541,
40566,
40543,
40588,
40564,
40549,
40590,
40589,
40592,
40591,
40532,
40531,
43952,
44577,
44650,
44664,
44662,
44665,
44661,
},
},
}
DugisGearFinderData["Raid: Ulduar (10)"] = {
normal=1, dungeonmap="603_10",
{ boss="33271", name="General Vezax",
ALL={
45038,
46017,
45514,
45508,
45512,
45504,
45513,
45502,
45505,
45501,
45503,
45515,
45507,
45509,
45145,
45498,
45511,
45520,
45519,
45517,
45518,
45516,
},
},
{ boss="33186", name="Razorscale",
ALL={
45038,
46017,
45138,
45150,
45146,
45149,
45141,
45151,
45143,
45140,
45139,
45148,
45510,
45144,
45142,
45147,
45137,
},
},
{ boss="32930", name="Kologarn",
ALL={
45038,
46017,
45272,
45275,
45273,
45265,
45274,
45264,
45269,
45268,
45267,
45262,
45263,
45271,
45270,
45266,
45261,
},
},
{ boss="33118", name="Ignis the Furnace Master",
ALL={
45038,
46017,
45186,
45185,
45162,
45164,
45187,
45167,
45161,
45166,
45157,
45168,
45158,
45169,
45165,
45171,
45170,
},
},
{ boss="32906", name="Freya",
ALL={
45038,
46017,
45483,
45482,
45481,
45480,
45479,
45653,
45654,
45655,
46110,
45486,
45488,
45487,
45485,
45484,
45613,
45814,
},
},
{ boss="33350", name="Mimiron",
ALL={
45038,
46017,
45493,
45492,
45491,
45490,
45489,
45641,
45642,
45643,
45496,
45497,
45663,
45495,
45494,
45620,
45816,
},
},
{ boss="32845", name="Hodir",
ALL={
45038,
46017,
45453,
45454,
45452,
45451,
45450,
45632,
45633,
45634,
45461,
45462,
45460,
45459,
45612,
45457,
45815,
},
},
{ boss="33288", name="Yogg-Saron",
ALL={
45038,
46017,
45529,
45532,
45523,
45524,
45531,
45525,
45530,
45522,
45527,
45521,
45656,
45657,
45658,
45537,
45536,
45534,
45535,
45533,
},
},
{ boss="33113", name="Flame Leviathan",
ALL={
45038,
46017,
45117,
45119,
45108,
45118,
45109,
45107,
45111,
45116,
45113,
45106,
45112,
45115,
45114,
45110,
45086,
45135,
45136,
45134,
45133,
45132,
},
},
{ boss="32867", name="The Iron Council",
ALL={
45038,
46017,
45224,
45240,
45238,
45237,
45232,
45227,
45239,
45226,
45225,
45228,
45193,
45236,
45235,
45233,
45234,
45242,
45245,
45244,
45241,
45243,
45607,
45857,
},
},
{ boss="33293", name="XT-002 Deconstructor",
ALL={
45038,
46017,
45253,
45258,
45260,
45259,
45249,
45251,
45252,
45248,
45250,
45247,
45254,
45255,
45246,
45256,
45257,
45446,
45444,
45445,
45443,
45442,
},
},
{ boss="32871", name="Algalon the Observer",
ALL={
45665,
45619,
45611,
45616,
45610,
45615,
45594,
45599,
45617,
45620,
45607,
45612,
45613,
45587,
45570,
45609,
46053,
45588,
45618,
45608,
45614,
},
},
{ boss="32865", name="Thorim",
ALL={
45038,
46017,
45468,
45467,
45469,
45466,
45463,
45638,
45639,
45640,
45473,
45474,
45472,
45471,
45570,
45470,
45817,
},
},
{ boss="33515", name="Auriaya",
ALL={
45038,
46017,
45319,
45435,
45441,
45439,
45325,
45440,
45320,
45334,
45434,
45326,
45438,
45436,
45437,
45315,
45327,
},
},
}
DugisGearFinderData["Raid: Ulduar (25)"] = {
normal=1, dungeonmap="603_25",
{ boss="33271", name="General Vezax",
ALL={
46014,
46013,
46012,
46009,
46346,
45997,
46008,
46015,
46010,
46011,
45996,
46032,
46034,
46036,
46035,
46033,
},
},
{ boss="33186", name="Razorscale",
ALL={
45306,
45302,
45301,
45307,
45299,
45305,
45304,
45303,
45308,
45298,
},
},
{ boss="33113", name="Flame Leviathan",
ALL={
45289,
45291,
45288,
45283,
45285,
45292,
45286,
45284,
45287,
45282,
45293,
45300,
45295,
45297,
45296,
},
},
{ boss="33293", name="XT-002 Deconstructor",
ALL={
45694,
45677,
45686,
45687,
45679,
45676,
45680,
45675,
45685,
45682,
45869,
45867,
45871,
45868,
45870,
},
},
{ boss="32906", name="Freya",
ALL={
45940,
45941,
45935,
45936,
45934,
45644,
45645,
45646,
46110,
45943,
45945,
45946,
45947,
45294,
45788,
},
},
{ boss="33350", name="Mimiron",
ALL={
45973,
45976,
45974,
45975,
45972,
45647,
45648,
45649,
45993,
45989,
45982,
45988,
45990,
45787,
},
},
{ boss="33515", name="Auriaya",
ALL={
45832,
45865,
45864,
45709,
45711,
45712,
45708,
45866,
45707,
45713,
},
},
{ boss="33288", name="Yogg-Saron",
ALL={
46030,
46019,
46028,
46022,
46021,
46024,
46016,
46031,
46025,
46018,
45635,
45636,
45637,
46068,
46095,
46096,
46097,
46067,
},
},
{ boss="32865", name="Thorim",
ALL={
45893,
45927,
45894,
45895,
45892,
45659,
45660,
45661,
45928,
45933,
45931,
45929,
45930,
45784,
},
},
{ boss="32867", name="The Iron Council",
ALL={
45322,
45423,
45324,
45378,
45329,
45333,
45330,
45418,
45332,
45331,
45455,
45447,
45456,
45449,
45448,
45506,
},
},
{ boss="33118", name="Ignis the Furnace Master",
ALL={
45317,
45318,
45312,
45316,
45321,
45310,
45313,
45314,
45311,
45309,
},
},
{ boss="32871", name="Algalon the Observer",
ALL={
46042,
46045,
46050,
46043,
46049,
46044,
46037,
46039,
46041,
46047,
46040,
46048,
46046,
46038,
46051,
46052,
46320,
46321,
46322,
46323,
},
},
{ boss="32930", name="Kologarn",
ALL={
45704,
45701,
45697,
45698,
45696,
45699,
45702,
45703,
45700,
45695,
},
},
{ boss="32845", name="Hodir",
ALL={
45873,
45464,
45874,
45458,
45872,
45650,
45651,
45652,
45888,
45876,
45886,
45887,
45877,
45786,
},
},
}
DugisGearFinderData["Raid: Vault of Archavon (10)"] = {
normal=1, dungeonmap="624_10",
{ boss="31125", name="Archavon the Stone Watcher",
ALL={
39492,
39493,
39495,
39497,
39498,
39500,
39515,
39517,
39519,
39523,
39528,
39530,
39538,
39539,
39543,
39544,
39546,
39547,
39554,
39555,
39557,
39558,
39560,
39564,
39579,
39580,
39582,
39588,
39589,
39591,
39592,
39593,
39595,
39597,
39601,
39603,
39606,
39607,
39609,
39611,
39612,
39617,
39618,
39620,
39622,
39623,
39624,
39626,
39629,
39630,
39632,
39633,
39634,
39636,
39638,
39639,
39641,
40781,
40782,
40783,
40801,
40802,
40803,
40840,
40841,
40842,
40904,
40925,
40937,
40988,
40989,
40999,
41005,
41025,
41031,
41079,
41085,
41135,
41141,
41162,
41203,
41284,
41291,
41296,
41302,
41308,
41314,
41648,
41653,
41659,
41665,
41765,
41771,
41857,
41862,
41872,
41919,
41925,
41938,
41950,
41957,
41969,
42001,
42003,
42015,
43959,
44083,
47241,
},
},
{ boss="33993", name="Emalon the Storm Watcher", phase="wotlk2",
ALL={
40804,
40805,
40806,
40844,
40845,
40846,
40879,
40880,
40888,
40926,
40938,
40974,
40975,
40982,
41000,
41006,
41026,
41032,
41048,
41054,
41059,
41064,
41069,
41074,
41136,
41142,
41198,
41204,
41224,
41229,
41234,
41286,
41292,
41297,
41303,
41616,
41620,
41624,
41629,
41634,
41639,
41654,
41666,
41766,
41772,
41831,
41835,
41839,
41863,
41873,
41880,
41884,
41892,
41897,
41902,
41908,
41926,
41939,
41958,
41970,
42004,
42016,
42027,
42028,
42029,
42030,
42031,
42032,
42033,
42062,
42063,
42064,
42065,
42066,
42067,
42068,
42114,
42115,
43959,
44083,
45337,
45338,
45341,
45343,
45345,
45347,
45351,
45353,
45355,
45357,
45360,
45362,
45367,
45370,
45371,
45376,
45379,
45383,
45384,
45387,
45388,
45392,
45394,
45397,
45399,
45401,
45403,
45406,
45409,
45414,
45416,
45419,
45420,
45426,
45427,
45430,
45432,
46131,
47241,
},
},
{ boss="35013", name="Koralon the Flame Watcher", phase="wotlk3",
ALL={
40807,
40808,
40809,
40847,
40848,
40849,
40881,
40882,
40889,
40927,
40939,
40976,
40977,
40983,
41001,
41007,
41027,
41033,
41051,
41055,
41060,
41065,
41070,
41075,
41137,
41143,
41199,
41205,
41225,
41230,
41235,
41287,
41293,
41298,
41304,
41617,
41621,
41625,
41630,
41635,
41640,
41655,
41667,
41767,
41773,
41832,
41836,
41840,
41864,
41874,
41881,
41885,
41893,
41898,
41903,
41909,
41927,
41940,
41959,
41971,
42005,
42017,
42034,
42035,
42036,
42037,
42038,
42039,
42040,
42069,
42070,
42071,
42072,
42073,
42074,
42075,
42116,
42117,
43959,
44083,
46373,
47241,
47773,
47775,
47800,
47802,
48067,
48069,
48097,
48099,
48153,
48155,
48183,
48185,
48190,
48192,
48244,
48246,
48276,
48278,
48296,
48298,
48337,
48339,
48367,
48369,
48387,
48389,
48457,
48459,
48502,
48504,
48559,
48561,
48596,
48598,
48628,
48630,
48653,
48655,
},
},
{ boss="38433", name="Toravon the Ice Watcher", phase="wotlk4",
ALL={
40810,
40811,
40812,
40850,
40851,
40852,
40883,
40884,
40890,
40928,
40940,
40978,
40979,
40984,
41002,
41008,
41028,
41034,
41052,
41056,
41061,
41066,
41071,
41076,
41138,
41144,
41200,
41206,
41226,
41231,
41236,
41288,
41294,
41299,
41305,
41618,
41622,
41626,
41631,
41636,
41641,
41656,
41668,
41768,
41774,
41833,
41837,
41841,
41865,
41875,
41882,
41886,
41894,
41899,
41904,
41910,
41928,
41941,
41960,
41972,
42006,
42018,
42041,
42042,
42043,
42044,
42045,
42046,
42047,
42076,
42077,
42078,
42079,
42080,
42081,
42082,
42118,
42119,
43959,
44083,
46374,
49179,
49181,
49183,
49426,
50079,
50081,
50088,
50090,
50095,
50097,
50107,
50109,
50114,
50116,
50240,
50242,
50275,
50277,
50325,
50327,
50391,
50393,
50766,
50769,
50820,
50822,
50825,
50827,
50831,
50833,
50836,
50838,
50842,
50844,
50847,
50849,
50854,
50856,
50861,
50863,
50866,
50868,
},
},
}
DugisGearFinderData["Raid: Vault of Archavon (25)"] = {
normal=1, dungeonmap="624_25",
{ boss="31125", name="Archavon the Stone Watcher",
ALL={
40423,
40420,
40422,
41997,
42016,
42004,
40415,
40417,
40418,
40445,
40448,
40449,
40454,
40457,
40458,
40460,
40462,
40463,
40466,
40468,
40469,
40471,
40472,
40493,
40495,
40496,
40500,
40503,
40504,
40506,
40508,
40509,
40512,
40514,
40515,
40517,
40520,
40522,
40523,
40525,
40527,
40529,
40544,
40545,
40547,
40550,
40552,
40556,
40559,
40563,
40567,
40569,
40570,
40572,
40574,
40575,
40577,
40579,
40580,
40583,
40784,
40785,
40786,
40804,
40805,
40806,
40844,
40845,
40846,
40905,
40926,
40938,
40990,
40991,
41000,
41006,
41026,
41032,
41080,
41086,
41136,
41142,
41198,
41204,
41286,
41292,
41297,
41303,
41309,
41315,
41649,
41654,
41660,
41666,
41766,
41772,
41858,
41863,
41873,
41920,
41926,
41939,
41951,
41958,
41970,
43959,
44083,
47241,
},
},
{ boss="33993", name="Emalon the Storm Watcher", phase="wotlk2",
ALL={
40808,
40809,
40848,
40849,
40881,
40882,
40889,
40927,
40939,
40976,
40977,
40983,
41001,
41007,
41027,
41033,
41051,
41055,
41060,
41065,
41070,
41075,
41137,
41143,
41199,
41205,
41225,
41230,
41235,
41287,
41293,
41298,
41304,
41617,
41621,
41625,
41630,
41635,
41640,
41655,
41667,
41767,
41773,
41832,
41836,
41840,
41864,
41874,
41881,
41885,
41893,
41898,
41903,
41909,
41927,
41940,
41959,
41971,
42005,
42017,
42034,
42035,
42036,
42037,
42038,
42039,
42040,
42069,
42070,
42071,
42072,
42073,
42074,
42075,
42116,
42117,
43959,
44083,
46113,
46116,
46119,
46121,
46124,
46126,
46132,
46133,
46135,
46139,
46142,
46144,
46153,
46155,
46158,
46160,
46163,
46170,
46174,
46176,
46179,
46181,
46183,
46185,
46188,
46189,
46192,
46195,
46199,
46200,
46202,
46207,
46208,
46210,
46373,
47241,
46148,
46150,
46164,
46169,
40807,
40847,
},
},
{ boss="35013", name="Koralon the Flame Watcher", phase="wotlk3",
ALL={
40810,
40811,
40812,
40850,
40851,
40852,
40883,
40884,
40890,
40928,
40940,
40978,
40979,
40984,
41002,
41008,
41028,
41034,
41052,
41056,
41061,
41066,
41071,
41076,
41138,
41144,
41200,
41206,
41226,
41231,
41236,
41288,
41294,
41299,
41305,
41618,
41622,
41626,
41631,
41636,
41641,
41656,
41668,
41768,
41774,
41833,
41837,
41841,
41865,
41875,
41882,
41886,
41894,
41899,
41904,
41910,
41928,
41941,
41960,
41972,
42006,
42018,
42041,
42042,
42043,
42044,
42045,
42046,
42047,
42076,
42077,
42078,
42079,
42080,
42081,
42082,
42118,
42119,
43959,
44083,
46374,
47241,
47770,
47772,
47803,
47805,
48064,
48066,
48094,
48096,
48150,
48152,
48180,
48182,
48193,
48195,
48239,
48241,
48271,
48273,
48301,
48303,
48332,
48334,
48362,
48364,
48392,
48394,
48462,
48464,
48497,
48499,
48554,
48556,
48591,
48593,
48623,
48625,
48658,
48660,
49179,
49181,
49183,
},
},
{ boss="38433", name="Toravon the Ice Watcher", phase="wotlk4",
ALL={
43959,
44083,
49426,
51126,
51128,
51131,
51132,
51136,
51138,
51142,
51144,
51146,
51148,
51152,
51154,
51157,
51159,
51161,
51163,
51168,
51169,
51171,
51172,
51177,
51179,
51181,
51183,
51186,
51188,
51191,
51193,
51196,
51198,
51201,
51203,
51207,
51209,
51211,
51213,
51216,
51217,
51327,
51328,
51329,
51330,
51331,
51332,
51333,
51334,
51335,
51336,
51337,
51338,
51339,
51340,
51341,
51342,
51343,
51344,
51345,
51346,
51347,
51348,
51349,
51350,
51351,
51352,
51353,
51354,
51355,
51356,
51357,
51358,
51359,
51360,
51361,
51362,
51363,
51364,
51365,
51366,
51367,
51368,
51369,
51370,
51371,
51372,
51373,
51374,
51375,
51376,
51414,
51416,
51420,
51422,
51426,
51428,
51434,
51436,
51459,
51461,
51464,
51466,
51469,
51471,
51475,
51477,
51483,
51485,
51488,
51490,
51493,
51495,
51498,
51500,
51504,
51506,
51510,
51512,
51537,
51539,
51542,
51544,
},
},
}
DugisGearFinderData["Raid: Icecrown Citadel (10)"] = {
normal=1, dungeonmap="631_10",
{ boss="36948", name="Icecrown Gunship Battle",
ALL={
50791,
50795,
50797,
50792,
50789,
50796,
50788,
50790,
50340,
50793,
50787,
50794,
},
},
{ boss="36853", name="Sindragosa",
ALL={
51790,
51783,
51789,
51792,
51785,
51782,
51786,
51787,
51026,
51779,
51784,
51788,
51791,
},
},
{ boss="37972", name="Prince Keleseth",
ALL={
51382,
51379,
51380,
51023,
51325,
51383,
51025,
51381,
51024,
51021,
51022,
51326,
},
},
{ boss="36789", name="Valithria Dreamwalker",
ALL={
51584,
51777,
51585,
51565,
51583,
51566,
51586,
51563,
51564,
51562,
51582,
51561,
},
},
{ boss="36626", name="Festergut",
ALL={
50859,
50988,
50990,
50985,
50858,
50812,
50967,
50811,
50852,
50986,
50810,
50966,
},
},
{ boss="36855", name="Lady Deathwhisper",
ALL={
50785,
50782,
50780,
50778,
50783,
50777,
50784,
50779,
50786,
50342,
50781,
50776,
},
},
{ boss="36627", name="Rotface",
ALL={
51007,
51005,
51009,
51002,
51006,
51000,
51008,
51001,
51003,
51004,
50998,
50999,
},
},
{ boss="36612", name="Lord Marrowgar",
ALL={
50764,
50773,
50774,
50762,
50775,
50772,
50763,
50339,
50771,
50761,
50759,
50760,
},
},
{ boss="36678", name="Professor Putricide",
ALL={
51020,
51017,
51013,
51015,
51019,
51014,
51018,
51012,
51016,
50341,
51011,
51010,
},
},
{ boss="37955", name="Blood-Queen Lana'thel",
ALL={
51554,
51552,
51550,
51551,
51386,
51556,
51555,
51548,
51387,
51384,
51385,
51553,
},
},
{ boss="36597", name="The Lich King",
ALL={
51801,
51803,
51800,
51795,
51798,
51796,
51799,
51797,
51802,
},
},
{ boss="37813", name="Deathbringer Saurfang",
ALL={
50807,
50804,
50799,
50806,
50800,
50801,
50802,
50808,
50809,
50803,
50798,
50805,
},
},
}
DugisGearFinderData["Raid: Icecrown Citadel (Heroic 10)"] = {
heroic=1, dungeonmap="631_10H",
{ boss="36948", name="Icecrown Gunship Battle",
ALL={
51912,
51908,
51906,
51911,
51914,
51907,
51915,
51913,
50345,
51910,
51916,
51909,
},
},
{ boss="36853", name="Sindragosa",
ALL={
51813,
51820,
51814,
51811,
51818,
51821,
51817,
51816,
51822,
52027,
52026,
52025,
51819,
51815,
51812,
},
},
{ boss="37972", name="Prince Keleseth",
ALL={
51848,
51851,
51850,
51856,
51853,
51847,
51854,
51849,
51855,
51858,
51857,
51852,
},
},
{ boss="36789", name="Valithria Dreamwalker",
ALL={
51826,
51823,
51825,
51830,
51827,
51829,
51824,
51832,
51831,
51833,
51828,
51834,
},
},
{ boss="36597", name="The Lich King",
ALL={
51941,
51939,
51942,
51947,
51944,
51946,
51943,
51945,
51940,
52027,
52026,
52025,
49908,
},
},
{ boss="37813", name="Deathbringer Saurfang",
ALL={
51896,
51899,
51904,
51897,
51903,
51902,
51901,
51895,
51894,
51900,
52027,
52026,
52025,
51905,
51898,
},
},
{ boss="36627", name="Rotface",
ALL={
51872,
51874,
51870,
51877,
51873,
51879,
51871,
51878,
51876,
51875,
51881,
51880,
},
},
{ boss="36612", name="Lord Marrowgar",
ALL={
51933,
51930,
51929,
51935,
51928,
51931,
51934,
50346,
51932,
51936,
51938,
51937,
},
},
{ boss="36626", name="Festergut",
ALL={
51888,
51883,
51882,
51885,
51889,
51891,
51886,
51892,
51890,
51884,
51893,
51887,
},
},
{ boss="37955", name="Blood-Queen Lana'thel",
ALL={
51837,
51839,
51841,
51840,
51844,
51835,
51836,
51842,
51843,
52027,
52026,
52025,
51846,
51845,
51838,
},
},
{ boss="36855", name="Lady Deathwhisper",
ALL={
51918,
51921,
51923,
51925,
51920,
51926,
51919,
51924,
51917,
50343,
51922,
51927,
},
},
{ boss="36678", name="Professor Putricide",
ALL={
51859,
51862,
51866,
51864,
51860,
51865,
51861,
51867,
51863,
50344,
52027,
52026,
52025,
51868,
51869,
},
},
}
DugisGearFinderData["Raid: Icecrown Citadel (25)"] = {
normal=1, dungeonmap="631_25",
{ boss="36948", name="Icecrown Gunship Battle",
ALL={
49998,
50006,
50011,
50001,
50009,
50000,
50003,
50002,
50010,
50274,
49908,
50005,
50008,
49999,
50359,
50352,
50411,
},
},
{ boss="36853", name="Sindragosa",
ALL={
50421,
50424,
50360,
50361,
50423,
50274,
49908,
51026,
52027,
52026,
52025,
},
},
{ boss="37972", name="Prince Keleseth",
ALL={
50074,
50172,
50176,
50073,
50171,
50177,
50071,
50072,
50175,
50075,
50174,
50170,
50173,
50184,
49919,
50274,
49908,
},
},
{ boss="36789", name="Valithria Dreamwalker",
ALL={
50205,
50418,
50417,
50202,
50188,
50187,
50199,
50192,
50416,
50190,
50195,
50185,
50186,
50183,
50472,
50274,
49908,
},
},
{ boss="36626", name="Festergut",
ALL={
50063,
50056,
50062,
50042,
50041,
50059,
50038,
50064,
50413,
50060,
50037,
50036,
50061,
50414,
50035,
50040,
50226,
50274,
49908,
},
},
{ boss="36855", name="Lady Deathwhisper",
ALL={
49991,
49994,
49987,
49996,
49988,
49993,
49986,
49995,
49983,
49989,
49985,
49990,
49982,
49992,
50034,
50274,
49908,
},
},
{ boss="36627", name="Rotface",
ALL={
50019,
50032,
50026,
50021,
50022,
50030,
50020,
50024,
50027,
50023,
50025,
50353,
50028,
50016,
50033,
50231,
50274,
49908,
},
},
{ boss="36612", name="Lord Marrowgar",
ALL={
49978,
49979,
49950,
49952,
49980,
49951,
49960,
49964,
49975,
49949,
49977,
49967,
49968,
50415,
49976,
50274,
49908,
},
},
{ boss="36597", name="The Lich King",
ALL={
50426,
50427,
50070,
50012,
50428,
49997,
50425,
50429,
49981,
52027,
52026,
52025,
50274,
49908,
},
},
{ boss="37955", name="Blood-Queen Lana'thel",
ALL={
50182,
50180,
50354,
50178,
50181,
50065,
50274,
49908,
52027,
52026,
52025,
},
},
{ boss="36678", name="Professor Putricide",
ALL={
50067,
50069,
50351,
50179,
50068,
50274,
49908,
52027,
52026,
52025,
},
},
{ boss="37813", name="Deathbringer Saurfang",
ALL={
50014,
50333,
50015,
50362,
50412,
50274,
49908,
52027,
52026,
52025,
},
},
}
DugisGearFinderData["Raid: Icecrown Citadel (Heroic 25)"] = {
heroic=1, dungeonmap="631_25H",
{ boss="36948", name="Icecrown Gunship Battle",
ALL={
50653,
50661,
50663,
50656,
50665,
50655,
50660,
50659,
50667,
50274,
49908,
50658,
50664,
50657,
50366,
50349,
50654,
},
},
{ boss="36853", name="Sindragosa",
ALL={
50633,
50636,
50365,
50364,
50635,
50274,
49908,
51026,
52030,
52029,
52028,
52027,
52026,
52025,
},
},
{ boss="37972", name="Prince Keleseth",
ALL={
50718,
50717,
50722,
50713,
50715,
50723,
50711,
50712,
50716,
50721,
50720,
50714,
50719,
50710,
50603,
50274,
49908,
},
},
{ boss="36789", name="Valithria Dreamwalker",
ALL={
50628,
50629,
50630,
50626,
50619,
50620,
50623,
50624,
50632,
50625,
50627,
50622,
50618,
50621,
50631,
50274,
49908,
},
},
{ boss="36597", name="The Lich King",
ALL={
50736,
50732,
50730,
50737,
50734,
50738,
50735,
50731,
50733,
50818,
50274,
49908,
52030,
52029,
52028,
52027,
52026,
52025,
},
},
{ boss="37813", name="Deathbringer Saurfang",
ALL={
50668,
50670,
50671,
50363,
50672,
50274,
49908,
52030,
52029,
52028,
52027,
52026,
52025,
},
},
{ boss="36678", name="Professor Putricide",
ALL={
50707,
50705,
50706,
50708,
50704,
50274,
49908,
52030,
52029,
52028,
52027,
52026,
52025,
},
},
{ boss="36612", name="Lord Marrowgar",
ALL={
50613,
50615,
50607,
50605,
50617,
50606,
50611,
50612,
50609,
50604,
50614,
50610,
50608,
50709,
50616,
50274,
49908,
},
},
{ boss="36626", name="Festergut",
ALL={
50702,
50694,
50699,
50697,
50696,
50698,
50689,
50703,
50688,
50701,
50690,
50691,
50700,
50693,
50692,
50695,
50274,
49908,
},
},
{ boss="37955", name="Blood-Queen Lana'thel",
ALL={
50724,
50728,
50726,
50727,
50725,
50729,
50274,
49908,
52030,
52029,
52028,
52027,
52026,
52025,
},
},
{ boss="36627", name="Rotface",
ALL={
50677,
50686,
50679,
50675,
50673,
50687,
50674,
50681,
50680,
50682,
50678,
50348,
50685,
50676,
50684,
50231,
50274,
49908,
},
},
{ boss="36855", name="Lady Deathwhisper",
ALL={
50643,
50651,
50646,
50649,
50645,
50652,
50640,
50650,
50639,
50647,
50642,
50644,
50641,
50648,
50638,
50274,
49908,
},
},
}
DugisGearFinderData["Raid: Trial of the Crusader (10)"] = {
normal=1, dungeonmap="649_10",
{ boss="34564", name="Anub'arak",
ALL={
47906,
47909,
47904,
47897,
47901,
47896,
47902,
47908,
47899,
47903,
47898,
47894,
47905,
47911,
47900,
47910,
47895,
47907,
},
},
{ boss="34461", name="Faction Champions",
ALL={
47873,
47878,
47875,
47876,
47877,
47880,
47882,
47879,
47881,
47874,
},
},
{ boss="34780", name="Lord Jaraxxus",
ALL={
47861,
47865,
47863,
47866,
49236,
47867,
47869,
47870,
47872,
47864,
47862,
47868,
47871,
},
},
{ boss="34497", name="The Twin Val'kyr",
ALL={
47889,
49232,
47891,
47887,
47893,
47885,
47890,
47888,
47913,
47886,
47884,
47892,
47883,
},
},
{ boss="34796", name="The Beasts of Northrend",
ALL={
47855,
47857,
47853,
47860,
47850,
47852,
47851,
47859,
47858,
47849,
47854,
47856,
},
},
}
DugisGearFinderData["Raid: Trial of the Crusader (25)"] = {
normal=1, dungeonmap="649_25",
{ boss="34564", name="Anub'arak",
ALL={
47328,
47320,
47324,
47326,
47317,
47321,
47313,
47318,
47325,
47311,
47319,
47330,
47323,
47312,
47242,
47315,
47327,
47316,
47314,
47322,
47329,
},
},
{ boss="34461", name="Faction Champions",
ALL={
47291,
47286,
47293,
47292,
47284,
47281,
47289,
47295,
47288,
47294,
47283,
47242,
47282,
47290,
47285,
47287,
},
},
{ boss="34780", name="Lord Jaraxxus",
ALL={
47275,
47274,
47270,
47277,
47280,
47268,
47279,
47273,
47269,
47242,
47272,
47278,
47271,
47276,
47266,
47267,
},
},
{ boss="34497", name="The Twin Val'kyr",
ALL={
47301,
47306,
47308,
47299,
47296,
47310,
47298,
47304,
47307,
47305,
47297,
47303,
47309,
47242,
47300,
47302,
},
},
{ boss="34796", name="The Beasts of Northrend",
ALL={
47257,
47256,
47264,
47258,
47259,
47262,
47251,
47265,
47254,
47253,
47263,
47242,
47252,
47261,
47255,
47260,
},
},
}

-----------------------------------------------------
-- Included guides for Pandaren --
-----------------------------------------------------
local includedGuidesForPandaren = {
    ["The Wandering Isle(378)"] = true,
  --["another guide"] = true,
  --["yet another guide"] = true,
}



-----------------------------------------------------
-- Exported guide name 2 Dugis guide title(id) map --
-----------------------------------------------------

--CONFIGURATION: Please set this variable to true if you wan to print missing map entries
local printMissingMapEntries = false

--MAP:
local guideName2GuideIdTitle_map = {}
guideName2GuideIdTitle_map["Maraudon Purple (45-49)"] = "Maraudon (45-49)"
guideName2GuideIdTitle_map["Maraudon Orange (45-49)"] = "Maraudon (45-49)"
guideName2GuideIdTitle_map["Maraudon Inner (45-49)"] = "Maraudon (45-49)"
guideName2GuideIdTitle_map["Scarlet Monestary Armory (34-39)"] = "Scarlet Monestary Armory / Cathedral (34-39)"
guideName2GuideIdTitle_map["Scarlet Monestary Cathedral (34-39)"] = "Scarlet Monestary Armory / Cathedral (34-39)"
guideName2GuideIdTitle_map["Scarlet Monestary Graveyard (27-33)"] = "Scarlet Monestary Graveyard / Library (27-33)"
guideName2GuideIdTitle_map["Scarlet Monestary Library (27-33)"] = "Scarlet Monestary Graveyard / Library (27-33)"
guideName2GuideIdTitle_map["Scholomance (55-58)"] = "Scholomance / Stratholme (55-58)"
guideName2GuideIdTitle_map["Stratholme Living (55-60)"] = "Scholomance / Stratholme (55-58)"
guideName2GuideIdTitle_map["Stratholme Undead (55-60)"] = "Scholomance / Stratholme (55-58)"
-- ...
-- ...
-- ...


local guideTitle2engPlayerRace = {}

-- Possible races:

-- BloodElf
-- Orc
-- Troll
-- Goblin
-- Tauren
-- Scourge (this is Undead)
-- Dwarf
-- Gnome
-- Draenei
-- Human
-- NightElf
-- Worgen
-- DeathKnight
-- Pandaren

--Examples:
--guideTitle2engPlayerRace["94(1-10 Blood Elf)#1941(1-12 Blood Elf)#94(1-13 Blood Elf)"] =  "Dwarf"
--guideTitle2engPlayerRace["1(1-4 Orc)#1(1-6 Orc)#1(1-7 Orc)"] =  {"Orc", "Human"}

guideTitle2engPlayerRace["1941(1-12 Blood Elf)#1941(1-12 Blood Elf)#1941(1-12 Blood Elf)"] =  "BloodElf"
guideTitle2engPlayerRace["1411(1-12 Orc & Troll)#1411(1-12 Orc & Troll)#1411(1-12 Orc & Troll)"] =  "Orc"
guideTitle2engPlayerRace["1411(1-12 Orc & Troll)#1411(1-12 Orc & Troll)#1411(1-12 Orc & Troll)"] =  "Troll"       
guideTitle2engPlayerRace["194(1-5 Goblin)"] =  "Goblin"      
guideTitle2engPlayerRace["1412(1-12 Tauren)#1412(1-12 Tauren)#1412(1-12 Tauren)"] =  "Tauren"      
guideTitle2engPlayerRace["1420(1-12 Undead)#1420(1-12 Undead)#1420(1-12 Undead)"] =  "Scourge"     
guideTitle2engPlayerRace["1426(1-12 Dwarf & Gnome)#1426(1-12 Dwarf & Gnome)#1426(1-12 Dwarf & Gnome)"] =  "Dwarf"
guideTitle2engPlayerRace["1426(1-12 Dwarf & Gnome)#1426(1-12 Dwarf & Gnome)#1426(1-12 Dwarf & Gnome)"] =  "Gnome"       
guideTitle2engPlayerRace["1943(1-20 Draenei)#1943(1-20 Draenei)#1943(1-20 Draenei)"] =  "Draenei"     
guideTitle2engPlayerRace["1429(1-12 Human)#1429(1-12 Human)#1429(1-12 Human)"] =  "Human"       
guideTitle2engPlayerRace["1438(1-12 Night Elf)#1438(1-12 Night Elf)#1438(1-12 Night Elf)"] =  "NightElf"    
guideTitle2engPlayerRace["539(1-12 Worgen)"] =  "Worgen"      
guideTitle2engPlayerRace["124(55-60 Death Knight)"] =  "DeathKnight" 
guideTitle2engPlayerRace["378(1-12 Pandaren)"] =  "Pandaren"    

--Extra filtering by race
guideTitle2engPlayerRace["174(5-20 Goblin)"] = "Goblin"
guideTitle2engPlayerRace["95(10-60)#95(10-60)#95(10-60)"] =  "BloodElf"    
guideTitle2engPlayerRace["106(10-60)#106(10-60)#106(10-60)"] =  "Draenei"  
guideTitle2engPlayerRace["27(5-20 Dwarf & Gnome)#27(5-20 Dwarf & Gnome)#27(5-20 Dwarf & Gnome)"] =  {"Dwarf", "Gnome"}
guideTitle2engPlayerRace["1(5-20 Orc & Troll)#1(5-20 Orc & Troll)#1(5-20 Orc & Troll)"] =  {"Orc", "Troll"}


local guideName2LevelRange = {}

guideName2LevelRange["Blackfathom Deeps (20-24)"] = {19,27}
guideName2LevelRange["Blackrock Depths: Prison (52-55)"] = {51,57}
guideName2LevelRange["Raid: Blackwing Lair"] = {60,60}
guideName2LevelRange["Dire Maul East"] = {60,60}
guideName2LevelRange["Dire Maul North"] = {60,60}
guideName2LevelRange["Dire Maul West"]  = {60,60}
guideName2LevelRange["Gnomeregan (25-29)"]  = {24,31}
guideName2LevelRange["Lower Blackrock Spire"]  = {60,60}
guideName2LevelRange["Maraudon Purple (45-49)"]  = {44,51}
guideName2LevelRange["Maraudon Orange (45-49)"]  = {44,51}
guideName2LevelRange["Maraudon Inner (45-49)"]  = {44,51}
guideName2LevelRange["Raid: Naxxramas"]  = {60,60}
guideName2LevelRange["Razorfen Downs (33-38)"]  = {32,40}
guideName2LevelRange["Razorfen Kraul (23-28)"]  = {22,30}
guideName2LevelRange["Scarlet Monestary Armory (34-39)"]  = {33,42}
guideName2LevelRange["Scarlet Monestary Cathedral (34-39)"]  = {33,42}
guideName2LevelRange["Scarlet Monestary Graveyard (27-33)"]  = {26,35}
guideName2LevelRange["Scarlet Monestary Library (27-33)"]  = {26,35}
guideName2LevelRange["Shadowfang Keep (18-22)"]  = {17,103}
guideName2LevelRange["Stratholme Living (55-60)"]  = {54,60}
guideName2LevelRange["Stratholme Undead (55-60)"]  = {54,60}
guideName2LevelRange["The Deadmines (15-20)"]  = {14,22}
guideName2LevelRange["Raid: The Ruins of Ahn'Qiraj"]  = {60,60}
guideName2LevelRange["Raid: The Temple of Ahn'Qiraj"]  = {60,60}
guideName2LevelRange["Sunken Temple (48-52)"]  = {47,103}
guideName2LevelRange["Uldaman (39-45)"]  = {38,47}
guideName2LevelRange["Raid: Upper Blackrock Spire"]  = {60,60}
guideName2LevelRange["The Wailing Caverns (15-21)"]  = {100,103}
guideName2LevelRange["Raid: World Bosses"]  = {60,60}
guideName2LevelRange["Zul'Farrak (42-47)"]  = {41,50}
guideName2LevelRange["Raid: Zul'Gurub"]  = {60,60}
guideName2LevelRange["Scholomance (55-58)"]  = {54,60}

    local englishFaction, localizedFaction = UnitFactionGroup("player")
    local _, _, classID = UnitClass("player")
    local playerLevel = UnitLevel("player")
    
    englishFaction = string.lower(englishFaction)
    
    --Processing data
    --GEARINFO: bossId=bossId1, encounterId = encounterId1, questIds = questIds1, guideTitle = guideTitle1, dungeonmap=dungeonmap1, dungeon=dungeon1, instanceId=instanceId1
    
    --{{gearId=itemId1, GEARINFO},
    -- {itemId=itemId2, GEARINFO}, ...}
    local allGearInfos = {}
    
    -- {[gearId1] = {{GEARINFO1},{GEARINFO2}...},
    -- [gearId2] = {{GEARINFO3},{GEARINFO4}...}}
    local gearId2GearInfos_map = {}
    
    --{[guideTitle1] = {gearId1, gearId2}, [guideTitle2] = {gearId3, gearId4}}
    local guideTitle2GearIds_map = {}
    
    --{[gearId] = {[questId1] = true, [questId2] = true..}, ..}
    local gearId2Quests_map = {}    
    
    --{[gearId1] = true, [gearId2] = true ..}
    local gearId2DroppedByBoss_map = {}    
    
    --{[gearId1] = {[17] = true, [1] = true, ...}}
    local gearId2PossibleDifficulties_map = {}  

    --gears only relevant for current faction (checked by guide faction)
    --{gearId1, gearId2, ...}
    local allGearIds = {}
    
    --Calculated based on all related guideTitles 
    --{[gearId] = {59, 90}, ..}
    local gearId2LevelRange = {}
    
    local gearId2isReputation = {}  
    
     
    local allGearGuides = {}
    
    local playerRace,  engPlayerRace  = UnitRace("player") 
    
    DugisGearFinder.allGearInfos = allGearInfos   
    DugisGearFinder.gearId2GearInfos_map = gearId2GearInfos_map   
    DugisGearFinder.guideTitle2GearIds_map = guideTitle2GearIds_map   
    DugisGearFinder.allGearGuides = allGearGuides   
    DugisGearFinder.gearId2DroppedByBoss_map = gearId2DroppedByBoss_map   
    DugisGearFinder.gearId2Quests_map = gearId2Quests_map   
    DugisGearFinder.gearId2PossibleDifficulties_map = gearId2PossibleDifficulties_map  
    DugisGearFinder.allGearIds = allGearIds  
    DugisGearFinder.gearId2LevelRange = gearId2LevelRange  
    DugisGearFinder.gearId2isReputation = gearId2isReputation  
	
    local i = 1
    
    function DGV.InitializeGearFinderData()
        
        LuaUtils.Profiler:Start("DGV.InitializeGearFinderData")
        
        LuaUtils:foreach(DugisGearFinderData, function(guideInfo, guideTitle)
            local guideIdTitle = guideName2GuideIdTitle_map[guideTitle] 
            local levelRange = guideName2LevelRange[guideTitle]
            
            --       min          max  
            --********|********X***|*******
            local levelMin, levelMax
            
            if levelRange then
                levelMin = levelRange[1]
                levelMax = levelRange[2]
            else
                --Getting the range automatically from the guide title
                --479(67-70)
                local textRange = ""
                if guideIdTitle then
                    -- 201(49-54)#201(50-56)#201(51-57)  OR  201(49-54)#201(50-56 XXX)#201(51-57)
                    textRange = LuaUtils:matchString(guideIdTitle, "#.-%([0-9]+-[0-9]+.-%)#")
                    
                    if textRange ~= "" then
                        textRange = textRange:match("[0-9]+-[0-9]+")
                    else
                        --479(67-70) OR 808(1-12 Pandaren)
                        textRange = LuaUtils:matchString(guideIdTitle, "[0-9]+-[0-9]+")
                        textRange = LuaUtils:trim(textRange)
                    end
                    
                end
                
                if textRange == "" then
                    textRange = LuaUtils:matchString(guideTitle, "%([0-9]+-[0-9]+")
                    textRange = textRange:gsub("%(", "")
                    textRange = LuaUtils:trim(textRange)
                end
                
                --Support for "(90+)" format
                if textRange == "" then
                    textRange = LuaUtils:matchString(guideTitle, "[0-9]*%+")
                    textRange = textRange:gsub("%+", "")
                    textRange = LuaUtils:trim(textRange)
                    
                    if textRange ~= "" then
                        local minL = tonumber(textRange)
                        if minL then
                            textRange = textRange.."-"..(minL + 2)
                        end
                    end
                end
                
                if textRange and LuaUtils:trim(textRange) ~= "" then
                    local levelMin_levelMax = LuaUtils:split(textRange, "-")
                    
                    levelMin = tonumber(levelMin_levelMax[1]) - 2
                    levelMax = tonumber(levelMin_levelMax[2]) + 2
                end
            end
            
            --The level might only increade while playing so there is no point to cache and make other operations for guides below it.
            if levelMax and playerLevel > levelMax then
                --continue the loop
                return 
            end

            
			LuaUtils:RestIfNeeded(true)
            LuaUtils:WaitForCombatEnd()

            i = i + 1
            
            local orgGuideTitle = guideTitle
            
            if guideIdTitle then
                guideTitle = guideIdTitle
            else
                if printMissingMapEntries then
                    print("Missing map entry for:", guideTitle)
                end
            end
            
            if guideTitle2engPlayerRace[guideTitle] then
                if type(guideTitle2engPlayerRace[guideTitle]) == "string" then
                    if guideTitle2engPlayerRace[guideTitle] ~= engPlayerRace then
                        return
                    end
                else --type is "table"
                    if not LuaUtils:isInTable(engPlayerRace, guideTitle2engPlayerRace[guideTitle]) then
                        return
                    end
                end
            end
--[[
      DugisGearFinderData["Classic Dungeons\\Blackwing Lair"] = {
         dungeonmap=2677, normal=1,
         { boss="12435", name="Razorgore the Untamed",
         ALL={4,5,22,332
]]
         
            local dungeonmap = guideInfo.dungeonmap
            local dungeon = guideInfo.dungeon
            local instanceId = guideInfo.instanceId
			local heroic = guideInfo.heroic
			local reputationId = guideInfo.reputationId
            
            --Difficulty
            local difficulty = guideInfo.diff
            
			if dungeon and not difficulty then
               -- difficulty = select(12, GetLFGDungeonInfo(dungeon))
            end
			
			if difficulty == 3 or difficulty == 4 then --for [10] and [25] raid 
				difficulty = 14
			elseif difficulty == 5 or difficulty == 6 then
				difficulty = 15
			end
            
            if guideInfo.manualDifficulty then
                difficulty = guideInfo.manualDifficulty 
            end
            
            for guideInfoPropertyName, guideInfoPropertyValue in pairs(guideInfo) do

               if type(guideInfoPropertyValue) == "table" then
                    local gearIds = guideInfoPropertyValue.ALL
                    local boss = guideInfoPropertyValue.boss
                    --local encounterId = guideInfoPropertyValue.encounterId
                    local class = nil
                    local questIds = guideInfoPropertyValue.quest
                    local questId = nil
            
                    local correctCurrentFaction = true
                    
                    --[[
                    if reputationId == nil then
                        local alliance_horde = questIds
                        
                        if alliance_horde then
                            if englishFaction == "alliance" and alliance_horde[1] == "none" then
                                correctCurrentFaction = false
                            end
                            
                            if englishFaction == "horde" and alliance_horde[2] == "none" then
                                correctCurrentFaction = false
                            end
                            
                            if correctCurrentFaction then
                                if englishFaction == "alliance" then
                                    questId = alliance_horde[1]
                                end
                                
                                if englishFaction == "horde" then
                                    questId = alliance_horde[2]
                                end
                            end  

                            if includedGuidesForPandaren[orgGuideTitle] then
                                questId = alliance_horde[1]
                            end
                            
                        end
                    else
                  
                        local faction = guideInfoPropertyName
                        
                        if englishFaction == "alliance" and faction == "horde" then
                            correctCurrentFaction = false
                        end
                        
                        if englishFaction == "horde" and faction == "alliance" then
                            correctCurrentFaction = false
                        end
                        
                        if not correctCurrentFaction then
                            gearIds = {}
                        end
                    end
                    ]]
                   
                    for index, value in pairs(gearIds) do
                        local valueType = type(value)
                        
                        --New class
                       -- if valueType == "table" and value.class then
                         --   class = value.class
                     --   end
                    
                            local gearId = value
                            
                            if reputationId then
                            --    gearId2isReputation[gearId] = true
                            end
                        
                            local gearInfo = {}
                            
                            gearInfo.gearId = gearId
                            gearInfo.bossId = boss
                          --  gearInfo.reputationId = reputationId
                           -- gearInfo.encounterId = encounterId
                            if questId then
                                gearInfo.questIds = {questId}
                            end
                            
                            if gearId2LevelRange[gearId] == nil then
                                gearId2LevelRange[gearId] = {}
                            end
                            
                            --min
                            if levelMin and (not gearId2LevelRange[gearId][1] or gearId2LevelRange[gearId][1] > levelMin) then
                                gearId2LevelRange[gearId][1] = levelMin
                            end
                            
                            --max
                            if levelMax and (not gearId2LevelRange[gearId][2] or gearId2LevelRange[gearId][2] < levelMax) then
                                gearId2LevelRange[gearId][2] = levelMax
                            end
                           
                            --If there is no related quest nor boss then there is no point to add the gear (the current faction might be other than related to quest)
                            --Preventing adding data relevant only for other faction
                            if questId or boss or reputationId then
                            
                                gearInfo.guideTitle = guideTitle
                                gearInfo.dungeonmap = dungeonmap
                                gearInfo.dungeon = dungeon
                                gearInfo.dungeonDifficulty = difficulty
                                gearInfo.instanceId = instanceId
                                gearInfo.gearId = gearId
                                allGearInfos[#allGearInfos + 1] = gearInfo
                                
                                if gearId2PossibleDifficulties_map[gearId] == nil then
                                    gearId2PossibleDifficulties_map[gearId] = {}
                                end
                                
                                if difficulty then
                                    gearId2PossibleDifficulties_map[gearId][difficulty] = true
                                else
                                    gearId2PossibleDifficulties_map[gearId]["empty-difficulty"] = true
                                end
                                
                                if guideTitle2GearIds_map[guideTitle] == nil then
                                    guideTitle2GearIds_map[guideTitle] = {}
                                    
                                    --Thanks to the if condition it will be added only once
                                    allGearGuides[#allGearGuides + 1] = guideTitle
                                end
                                
                                guideTitle2GearIds_map[guideTitle][#guideTitle2GearIds_map[guideTitle] + 1] = gearId
                                
                                if questId and not gearId2Quests_map[gearId]  then
                                    gearId2Quests_map[gearId] = {}
                                end
                                
                                --Optimization purposes
                                local justAddedToallGearIds = false
                                
                                --Adding data to allGearIds
                                allGearIds[#allGearIds + 1] = gearInfo
                                
                                justAddedToallGearIds = true
                                
                                if boss and not gearId2Quests_map[gearId]  then
                                    gearId2Quests_map[gearId] = {}
                                    
                                    --Adding data to allGearIds
                                    if not justAddedToallGearIds then
                                        allGearIds[#allGearIds + 1] = gearInfo
                                    end
                                end
                                
                                if questId then
                                    gearId2Quests_map[gearId][questId] = true
                                    gearId2Quests_map[gearId].amountMoreThan0 = true
                                end
                                
                                if gearInfo.bossId then
                                    gearId2DroppedByBoss_map[gearId] = true
                                end
                            end
                    end
               end
            end
        end)
        
        
        --Transfering data from allGearInfos to gearId2GearInfos_map
        for index, gearInfo in pairs(allGearInfos) do
            local gearId = gearInfo.gearId
            
            if not gearId2GearInfos_map[gearId] then
                gearId2GearInfos_map[gearId] = {}
            end
            
            local gearInfoList = gearId2GearInfos_map[gearId]
            
            gearInfoList[#gearInfoList + 1] = gearInfo
        end
        
        table.sort(allGearIds, function(a,b)
            if type(b.gearId) == "string" and type(a.gearId) == "number" then
                return true
            end
            
            return false
        end) 
        
        LuaUtils.Profiler:Stop("DGV.InitializeGearFinderData")
            
        if DugisGearFinder.optimized then
            wipe(DugisGearFinderData)
            wipe(allGearInfos)
            wipe(guideName2GuideIdTitle_map)
        end
    end
end