local DGV = DugisGuideViewer

DGV.TalentAdvisorButtonMap = {
	DEATHKNIGHT = {
		{--Blood
			["Improved Blood Presence"]=1,
			["Bladed Armor"]=2,
			["Butchery"]=3,
			["Rune Tap"]=4,
			["Scent of Blood"]=5,
			["Will of the Necropolis"]=6,
			["Blood Parasite"]=7,
			["Dancing Rune Weapon"]=8,
			["Blade Barrier"]=9,
			["Vampiric Blood"]=10,
			["Abomination's Might"]=11,
			["Improved Death Strike"]=12,
			["Toughness"]=13,
			["Bone Shield"]=14,
			["Blood-Caked Blade"]=15,
			["Sanguine Fortitude"]=16,
			["Scarlet Fever"]=17,
			["Crimson Scourge"]=18,
			["Hand of Doom"]=19,
			["Improved Blood Tap"]=20,
		},
		{--Frost
			["Endless Winter"]=1,
			["Pillar of Frost"]=2,
			["Brittle Bones"]=3,
			["Chill of the Grave"]=4,
			["Howling Blast"]=5,
			["Rime"]=6,
			["Merciless Combat"]=7,
			["Hungering Cold"]=8,
			["Nerves of Cold Steel"]=9,
			["Improved Frost Presence"]=10,
			["Runic Power Mastery"]=11,
			["Icy Reach"]=12,
			["Killing Machine"]=13,
			["Annihilation"]=14,
			["Lichborne"]=15,
			["Improved Icy Talons"]=16,
			["Chilblains"]=17,
			["Threat of Thassarian"]=18,
			["Might of the Frozen Wastes"]=19,
			["On a Pale Horse"]=20,
		},
		{--Unholy
			["Virulence"]=1,
			["Epidemic"]=2,
			["Unholy Blight"]=3,
			["Summon Gargoyle"]=4,
			["Magic Suppression"]=5,
			["Improved Unholy Presence"]=6,
			["Unholy Command"]=7,
			["Ebon Plaguebringer"]=8,
			["Runic Corruption"]=9,
			["Rage of Rivendare"]=10,
			["Dark Transformation"]=11,
			["Anti-Magic Zone"]=12,
			["Desecration"]=13,
			["Resilient Infection"]=14,
			["Unholy Frenzy"]=15,
			["Sudden Doom"]=16,
			["Morbidity"]=17,
			["Shadow Infusion"]=18,
			["Contagion"]=19,
			["Death's Advance"]=20,
		},
	},
	WARRIOR = {
		{-- Arms
			["Deep Wounds"]=1,
			["Drums of War"]=2,
			["Second Wind"]=3,
			["Sweeping Strikes"]=4,
			["Wrecking Crew"]=5,
			["Juggernaut"]=6,
			["Sudden Death"]=7,
			["Bladestorm"]=8,
			["Blood Frenzy"]=9,
			["Blitz"]=10,
			["War Academy"]=11,
			["Taste for Blood"]=12,
			["Lambs to the Slaughter"]=13,
			["Impale"]=14,
			["Field Dressing"]=15,
			["Throwdown"]=16,
			["Deadly Calm"]=17,
			["Tactical Mastery"]=18,
			["Improved Hamstring"]=19,
			["Improved Slam"]=20,
		},
		{ --Fury
			["Battle Trance"]=1,
			["Cruelty"]=2,
			["Blood Craze"]=3,
			["Enrage"]=4,
			["Piercing Howl"]=5,
			["Booming Voice"]=6,
			["Death Wish"]=7,
			["Furious Attacks"]=8,
			["Flurry"]=9,
			["Meat Cleaver"]=10,
			["Executioner"]=11,
			["Heroic Fury"]=12,
			["Rampage"]=13,
			["Bloodsurge"]=14,
			["Titan's Grip"]=15,
			["Single-Minded Fury"]=16,
			["Intensify Rage"]=17,
			["Skirmisher"]=18,
			["Raging Blow"]=19,
			["Die by the Sword"]=20,
		},
		{ --Protection
			["Incite"]=1,
			["Shield Specialization"]=2,
			["Gag Order"]=3,
			["Improved Revenge"]=4,
			["Shield Mastery"]=5,
			["Toughness"]=6,
			["Concussion Blow"]=7,
			["Blood and Thunder"]=8,
			["Last Stand"]=9,
			["Heavy Repercussions"]=10,
			["Devastate"]=11,
			["Thunderstruck"]=12,
			["Safeguard"]=13,
			["Vigilance"]=14,
			["Warbringer"]=15,
			["Sword and Board"]=16,
			["Shockwave"]=17,
			["Bastion of Defense"]=18,
			["Hold the Line"]=19,
			["Impending Victory"]=20,
		},
	},
	ROGUE = {
		{--Assassination
			["Lethality"]=1,
			["Ruthlessness"]=2,
			["Coup de Grace"]=3,
			["Puncturing Wounds"]=4,
			["Improved Expose Armor"]=5,
			["Cold Blood"]=6,
			["Overkill"]=7,
			["Seal Fate"]=8,
			["Vile Poisons"]=9,
			["Master Poisoner"]=10,
			["Quickening"]=11,
			["Deadly Brew"]=12,
			["Cut to the Chase"]=13,
			["Vendetta"]=14,
			["Deadly Momentum"]=15,
			["Blackjack"]=16,
			["Murderous Intent"]=17,
			["Venomous Wounds"]=18,
			["Deadened Nerves"]=19,
		},
		{--Combat
			["Precision"]=1,
			["Lightning Reflexes"]=2,
			["Improved Sinister Strike"]=3,
			["Improved Gouge"]=4,
			["Adrenaline Rush"]=5,
			["Improved Kick"]=6,
			["Improved Sprint"]=7,
			["Aggression"]=8,
			["Blade Twisting"]=9,
			["Combat Potency"]=10,
			["Improved Slice and Dice"]=11,
			["Throwing Specialization"]=12,
			["Savage Combat"]=13,
			["Killing Spree"]=14,
			["Improved Recuperate"]=15,
			["Reinforced Leather"]=16,
			["Restless Blades"]=17,
			["Revealing Strike"]=18,
			["Bandit's Guile"]=19,
		},
		{--Subtlety
			["Nightstalker"]=1,
			["Initiative"]=2,
			["Elusiveness"]=3,
			["Opportunity"]=4,
			["Improved Ambush"]=5,
			["Preparation"]=6,
			["Premeditation"]=7,
			["Hemorrhage"]=8,
			["Serrated Blades"]=9,
			["Cheat Death"]=10,
			["Waylay"]=11,
			["Honor Among Thieves"]=12,
			["Slaughter from the Shadows"]=13,
			["Shadow Dance"]=14,
			["Relentless Strikes"]=15,
			["Find Weakness"]=16,
			["Sanguinary Vein"]=17,
			["Enveloping Shadows"]=18,
			["Energetic Recovery"]=19,
		},
	},
	MAGE = {
		{--Arcane
			["Improved Polymorph"]=1,
			["Arcane Concentration"]=2,
			["Improved Counterspell"]=3,
			["Torment the Weak"]=4,
			["Improved Blink"]=5,
			["Presence of Mind"]=6,
			["Prismatic Cloak"]=7,
			["Arcane Potency"]=8,
			["Arcane Power"]=9,
			["Incanter's Absorption"]=10,
			["Arcane Flows"]=11,
			["Improved Mana Gem"]=12,
			["Slow"]=13,
			["Missile Barrage"]=14,
			["Netherwind Presence"]=15,
			["Focus Magic"]=16,
			["Arcane Tactics"]=17,
			["Improved Arcane Missiles"]=18,
			["Invocation"]=19,
			["Nether Vortex"]=20,
			["Improved Arcane Explosion"]=22,
		},
		{--Fire
			["Improved Fire Blast"]=1,
			["Ignite"]=2,
			["Burning Soul"]=3,
			["Impact"]=4,
			["Critical Mass"]=5,
			["Molten Shields"]=6,
			["Master of Elements"]=7,
			["Improved Scorch"]=8,
			["Blast Wave"]=9,
			["Blazing Speed"]=10,
			["Pyromaniac"]=11,
			["Combustion"]=12,
			["Molten Fury"]=13,
			["Dragon's Breath"]=14,
			["Hot Streak"]=15,
			["Living Bomb"]=16,
			["Improved Flamestrike"]=17,
			["Firestarter"]=18,
			["Cauterize"]=19,
			["Fire Power"]=20,
			["Improved Hot Streak"]=21,
		},
		{--Frost
			["Ice Floes"]=1,
			["Permafrost"]=2,
			["Icy Veins"]=3,
			["Ice Shards"]=4,
			["Early Frost"]=5,
			["Cold Snap"]=6,
			["Fingers of Frost"]=7,
			["Shattered Barrier"]=8,
			["Ice Barrier"]=9,
			["Brain Freeze"]=10,
			["Enduring Winter"]=11,
			["Deep Freeze"]=12,
			["Piercing Chill"]=13,
			["Piercing Ice"]=14,
			["Shatter"]=15,
			["Frostfire Orb"]=16,
			["Improved Cone of Cold"]=17,
			["Improved Freeze"]=18,
			["Reactive Barrier"]=19,
		},
	},
	PRIEST = {
		{--Discipline
			["Twin Disciplines"]=1,
			["Inner Sanctum"]=2,
			["Inner Focus"]=3,
			["Evangelism"]=4,
			["Mental Agility"]=5,
			["Power Word: Barrier"]=6,
			["Reflective Shield"]=7,
			["Soul Warding"]=8,
			["Divine Aegis"]=9,
			["Power Infusion"]=10,
			["Rapture"]=11,
			["Focused Will"]=12,
			["Pain Suppression"]=13,
			["Grace"]=14,
			["Improved Power Word: Shield"]=15,
			["Renewed Hope"]=16,
			["Borrowed Time"]=17,
			["Archangel"]=18,
			["Atonement"]=19,
			["Strength of Soul"]=20,
			["Train of Thought"]=21,
		},
		{--Holy
			["Divine Fury"]=1,
			["Empowered Healing"]=2,
			["Inspiration"]=3,
			["Serendipity"]=4,
			["Holy Concentration"]=5,
			["Body and Soul"]=6,
			["Divine Touch"]=7,
			["Circle of Healing"]=8,
			["Test of Faith"]=9,
			["Guardian Spirit"]=10,
			["Improved Renew"]=11,
			["Lightwell"]=12,
			["Chakra"]=13,
			["Heavenly Voice"]=14,
			["Desperate Prayer"]=15,
			["Spirit of Redemption"]=16,
			["Blessed Resilience"]=17,
			["Revelations"]=18,
			["Surge of Light"]=19,
			["Tome of Light"]=20,
			["Rapid Renewal"]=21,
		},
		{--Shadow
			["Darkness"]=1,
			["Improved Shadow Word: Pain"]=2,
			["Improved Psychic Scream"]=3,
			["Improved Mind Blast"]=4,
			["Veiled Shadows"]=5,
			["Silence"]=6,
			["Vampiric Embrace"]=7,
			["Mind Melt"]=8,
			["Improved Devouring Plague"]=9,
			["Shadowform"]=10,
			["Phantasm"]=11,
			["Shadowy Apparition"]=12,
			["Psychic Horror"]=13,
			["Vampiric Touch"]=14,
			["Pain and Suffering"]=15,
			["Dispersion"]=16,
			["Sin and Punishment"]=17,
			["Harnessed Shadows"]=18,
			["Paralysis"]=19,
			["Twisted Faith"]=20,
			["Masochism"]=21,
		},
	},
	WARLOCK = {
		{--Affliction
			["Doom and Gloom"]=1,
			["Improved Corruption"]=2,
			["Improved Life Tap"]=3,
			["Soul Siphon"]=4,
			["Improved Fear"]=5,
			["Nightfall"]=6,
			["Shadow Embrace"]=7,
			["Curse of Exhaustion"]=8,
			["Eradication"]=9,
			["Improved Howl of Terror"]=10,
			["Death's Embrace"]=11,
			["Everlasting Affliction"]=12,
			["Haunt"]=13,
			["Pandemic"]=14,
			["Jinx"]=15,
			["Soul Swap"]=16,
			["Soulburn: Seed of Corruption"]=17,
			["Siphon Life"]=18,
		},
		{--Demonology
			["Dark Arts"]=1,
			["Demonic Embrace"]=2,
			["Improved Health Funnel"]=3,
			["Master Summoner"]=4,
			["Mana Feed"]=5,
			["Molten Core"]=6,
			["Decimation"]=7,
			["Demonic Pact"]=8,
			["Metamorphosis"]=9,
			["Demonic Empowerment"]=10,
			["Ancient Grimoire"]=11,
			["Inferno"]=12,
			["Demonic Aegis"]=13,
			["Impending Doom"]=14,
			["Cremation"]=15,
			["Hand of Gul'dan"]=16,
			["Fel Synergy"]=17,
			["Demonic Rebirth"]=18,
		},
		{--Destruction
			["Shadow and Flame"]=1,
			["Bane"]=2,
			["Improved Soul Fire"]=3,
			["Shadowburn"]=4,
			["Backlash"]=5,
			["Improved Immolate"]=6,
			["Bane of Havoc"]=7,
			["Nether Protection"]=8,
			["Soul Leech"]=9,
			["Backdraft"]=10,
			["Shadowfury"]=11,
			["Empowered Imp"]=12,
			["Fire and Brimstone"]=13,
			["Chaos Bolt"]=14,
			["Emberstorm"]=15,
			["Burning Embers"]=16,
			["Improved Searing Pain"]=17,
			["Aftermath"]=18,
		},
	},
	SHAMAN = {
		{--Elemental
			["Call of Flame"]=1,
			["Concussion"]=2,
			["Convection"]=3,
			["Elemental Mastery"]=4,
			["Elemental Focus"]=5,
			["Reverberation"]=6,
			["Elemental Warding"]=7,
			["Elemental Reach"]=8,
			["Elemental Precision"]=9,
			["Earthquake"]=10,
			["Elemental Oath"]=11,
			["Lava Flows"]=12,
			["Totemic Wrath"]=13,
			["Lava Surge"]=14,
			["Acuity"]=15,
			["Feedback"]=16,
			["Rolling Thunder"]=17,
			["Earth's Grasp"]=18,
			["Fulmination"]=19,
		},
		{--Enhancement
			["Flurry"]=1,
			["Ancestral Swiftness"]=2,
			["Improved Shields"]=3,
			["Elemental Weapons"]=4,
			["Toughness"]=5,
			["Stormstrike"]=6,
			["Unleashed Rage"]=7,
			["Shamanistic Rage"]=8,
			["Static Shock"]=9,
			["Earthen Power"]=10,
			["Maelstrom Weapon"]=11,
			["Feral Spirit"]=12,
			["Searing Flames"]=13,
			["Focused Strikes"]=14,
			["Improved Lava Lash"]=15,
			["Elemental Devastation"]=16,
			["Frozen Power"]=17,
			["Totemic Reach"]=18,
			["Seasoned Winds"]=19,
		},
		{--Restoration
			["Ancestral Healing"]=1,
			["Resurgence"]=2,
			["Soothing Rains"]=3,
			["Mana Tide Totem"]=4,
			["Nature's Swiftness"]=5,
			["Tidal Focus"]=6,
			["Totemic Focus"]=7,
			["Nature's Blessing"]=8,
			["Nature's Guardian"]=9,
			["Blessing of the Eternals"]=10,
			["Ancestral Awakening"]=11,
			["Tidal Waves"]=12,
			["Riptide"]=13,
			["Improved Cleanse Spirit"]=14,
			["Focused Insight"]=15,
			["Ancestral Resolve"]=16,
			["Telluric Currents"]=17,
			["Spark of Life"]=18,
			["Cleansing Waters"]=19,
		},
	},
	DRUID = {
		{--Balance
			["Starlight Wrath"]=1,
			["Moonglow"]=2,
			["Nature's Grace"]=3,
			["Solar Beam"]=4,
			["Gale Winds"]=5,
			["Shooting Stars"]=6,
			["Balance of Power"]=7,
			["Euphoria"]=8,
			["Owlkin Frenzy"]=9,
			["Lunar Shower"]=10,
			["Force of Nature"]=11,
			["Fungal Growth"]=12,
			["Starfall"]=13,
			["Earth and Moon"]=14,
			["Moonkin Form"]=15,
			["Nature's Majesty"]=16,
			["Typhoon"]=17,
			["Genesis"]=18,
			["Dreamstate"]=19,
			["Sunfire"]=20,
		},
		{--Feral Combat
			["Thick Hide"]=1,
			["Feral Swiftness"]=2,
			["Feral Charge"]=3,
			["Stampede"]=4,
			["Nurturing Instinct"]=5,
			["Fury Swipes"]=6,
			["Brutal Impact"]=7,
			["Survival Instincts"]=8,
			["Pulverize"]=9,
			["King of the Jungle"]=10,
			["Leader of the Pack"]=11,
			["Primal Madness"]=12,
			["Blood in the Water"]=13,
			["Rend and Tear"]=14,
			["Berserk"]=15,
			["Natural Reaction"]=16,
			["Endless Carnage"]=17,
			["Infected Wounds"]=18,
			["Primal Fury"]=19,
			["Predatory Strikes"]=20,
		},
		{--Restoration
			["Blessing of the Grove"]=1,
			["Natural Shapeshifter"]=2,
			["Improved Rejuvenation"]=3,
			["Nature's Swiftness"]=4,
			["Living Seed"]=5,
			["Nature's Bounty"]=6,
			["Efflorescence"]=7,
			["Swift Rejuvenation"]=8,
			["Nature's Ward"]=9,
			["Revitalize"]=10,
			["Tree of Life"]=11,
			["Master Shapeshifter"]=12,
			["Wild Growth"]=13,
			["Empowered Touch"]=14,
			["Nature's Cure"]=15,
			["Perseverance"]=16,
			["Gift of the Earthmother"]=17,
			["Naturalist"]=18,
			["Fury of Stormrage"]=19,
			["Heart of the Wild"]=20,
		},
	},
	PALADIN = {
		{--Holy
			["Last Word"]=1,
			["Arbiter of the Light"]=2,
			["Denounce"]=3,
			["Enlightened Judgements"]=4,
			["Aura Mastery"]=5,
			["Blessed Life"]=6,
			["Sacred Cleansing"]=7,
			["Judgements of the Pure"]=8,
			["Infusion of Light"]=9,
			["Beacon of Light"]=10,
			["Tower of Radiance"]=11,
			["Divine Favor"]=12,
			["Light of Dawn"]=13,
			["Clarity of Purpose"]=14,
			["Speed of Light"]=15,
			["Daybreak"]=16,
			["Conviction"]=17,
			["Blazing Light"]=18,
			["Paragon of Virtue"]=19,
			["Protector of the Innocent"]=20,
		},
		{--Protection
			["Seals of the Pure"]=1,
			["Toughness"]=2,
			["Divine Guardian"]=3,
			["Improved Hammer of Justice"]=4,
			["Shield of the Templar"]=5,
			["Hallowed Ground"]=6,
			["Sanctuary"]=7,
			["Ardent Defender"]=8,
			["Holy Shield"]=9,
			["Sacred Duty"]=10,
			["Judgements of the Just"]=11,
			["Hammer of the Righteous"]=12,
			["Vindication"]=13,
			["Wrath of the Lightbringer"]=14,
			["Reckoning"]=15,
			["Grand Crusader"]=16,
			["Guarded by the Light"]=17,
			["Shield of the Righteous"]=18,
			["Eternal Glory"]=19,
			["Divinity"]=20,
		},
		{--Retribution
			["Divine Purpose"]=1,
			["Seals of Command"]=2,
			["Eye for an Eye"]=3,
			["Crusade"]=4,
			["The Art of War"]=5,
			["Repentance"]=6,
			["Communion"]=7,
			["Sanctified Wrath"]=8,
			["Inquiry of Faith"]=9,
			["Divine Storm"]=10,
			["Sacred Shield"]=11,
			["Acts of Sacrifice"]=12,
			["Zealotry"]=13,
			["Rule of Law"]=14,
			["Selfless Healer"]=15,
			["Sanctity of Battle"]=16,
			["Long Arm of the Law"]=17,
			["Pursuit of Justice"]=18,
			["Improved Judgement"]=19,
			["Guardian's Favor"]=20,
		},
	},
	HUNTER = {
		{--Beast Mastery
			["One with Nature"]=1,
			["Bestial Discipline"]=2,
			["Improved Kill Command"]=3,
			["Pathfinding"]=4,
			["Fervor"]=5,
			["Improved Mend Pet"]=6,
			["Frenzy"]=7,
			["Spirit Bond"]=8,
			["Ferocious Inspiration"]=9,
			["Focus Fire"]=10,
			["Invigoration"]=11,
			["Bestial Wrath"]=12,
			["Killing Streak"]=13,
			["Cobra Strikes"]=14,
			["Longevity"]=15,
			["The Beast Within"]=16,
			["Kindred Spirits"]=17,
			["Beast Mastery"]=18,
			["Crouching Tiger, Hidden Chimera"]=19,
		},
		{--Marksmanship
			["Rapid Killing"]=1,
			["Efficiency"]=2,
			["Go for the Throat"]=3,
			["Sic 'Em!"]=4,
			["Careful Aim"]=5,
			["Improved Steady Shot"]=6,
			["Readiness"]=7,
			["Concussive Barrage"]=8,
			["Bombardment"]=9,
			["Trueshot Aura"]=10,
			["Termination"]=11,
			["Master Marksman"]=12,
			["Resistance is Futile"]=13,
			["Rapid Recuperation"]=14,
			["Silencing Shot"]=15,
			["Posthaste"]=16,
			["Marked for Death"]=17,
			["Chimera Shot"]=18,
			["Piercing Shots"]=19,
		},
		{--Survival
			["Pathing"]=1,
			["Entrapment"]=2,
			["Hunter vs. Wild"]=3,
			["Survival Tactics"]=4,
			["Counterattack"]=5,
			["Improved Serpent Sting"]=6,
			["Lock and Load"]=7,
			["Resourcefulness"]=8,
			["T.N.T."]=9,
			["Toxicology"]=10,
			["Wyvern Sting"]=11,
			["Point of No Escape"]=12,
			["Noxious Stings"]=13,
			["Hunting Party"]=14,
			["Sniper Training"]=15,
			["Black Arrow"]=16,
			["Mirrored Blades"]=17,
			["Thrill of the Hunt"]=18,
			["Trap Mastery"]=19,
		},
	},
}


DGV.TalentTemplates = {
DEATHKNIGHT = { 
		["Blood Tanking 31/0/10"] = {
			order = 1,
			["Butchery"]=2,
			["Bladed Armor"]=3,
			["Scent of Blood"]=2,
			["Scarlet Fever"]=2,
			["Improved Blood Tap"]=2,
			["Abomination's Might"]=2,
			["Bone Shield"]=1,
			["Toughness"]=1,
			["Improved Blood Presence"]=2,
			["Blood Parasite"]=2,
			["Sanguine Fortitude"]=2,
			["Vampiric Blood"]=1,
			["Rune Tap"]=1,
			["Will of the Necropolis"]=3,
			["Improved Death Strike"]=3,
			["Crimson Scourge"]=2,
			["Dancing Rune Weapon"]=1,
			["Epidemic"]=3,
			["Unholy Command"]=2,
			["Morbidity"]=3,
			["Runic Power Mastery"]=1,			
		},
		["Frost Dual-Wield 5/31/5"] = {
			order = 2,
			["Nerves of Cold Steel"]=3,
			["Runic Power Mastery"]=3,
			["Annihilation"]=3,
			["Lichborne"]=1,
			["Killing Machine"]=3,
			["Merciless Combat"]=2,
			["Improved Icy Talons"]=1,
			["Brittle Bones"]=2,
			["Rime"]=3,
			["Improved Frost Presence"]=2,
			["Hungering Cold"]=1,
			["Pillar of Frost"]=1,
			["Threat of Thassarian"]=3,
			["Chill of the Grave"]=2,
			["Howling Blast"]=1,
			["Bladed Armor"]=3,
			["Butchery"]=2,
			["Virulence"]=3,
			["Epidemic"]=2,	
		},
		["Frost 2-Hand Weapon 5/31/5"] = {
			order = 3,
			["Runic Power Mastery"]=3,
			["Icy Reach"]=2,
			["Annihilation"]=3,
			["Lichborne"]=1,
			["On a Pale Horse"]=1,
			["Killing Machine"]=3,
			["Merciless Combat"]=2,
			["Improved Icy Talons"]=1,
			["Brittle Bones"]=2,
			["Rime"]=3,
			["Improved Frost Presence"]=2,
			["Hungering Cold"]=1,
			["Pillar of Frost"]=1,
			["Might of the Frozen Wastes"]=3,
			["Chill of the Grave"]=2,
			["Howling Blast"]=1,
			["Virulence"]=3,
			["Epidemic"]=2,
			["Bladed Armor"]=3,
			["Butchery"]=2,		
		},		
		["Unholy 5/5/31"] = {
			order = 4,
			["Epidemic"]=3,
			["Virulence"]=3,
			["Morbidity"]=3,
			["Unholy Command"]=1,
			["Contagion"]=2,
			["Shadow Infusion"]=3,
			["Rage of Rivendare"]=3,
			["Unholy Frenzy"]=1,
			["Runic Corruption"]=2,
			["Unholy Blight"]=1,
			["Dark Transformation"]=1,
			["Improved Unholy Presence"]=2,
			["Ebon Plaguebringer"]=2,
			["Sudden Doom"]=3,
			["Summon Gargoyle"]=1,
			["Bladed Armor"]=3,
			["Butchery"]=2,
			["Runic Power Mastery"]=3,
			["Magic Suppression"]=2,	
		},				
},
DRUID = {
	["Balance(31/0/10"] = {
		order = 1,
		["Nature's Grace"]=3,
		["Starlight Wrath"]=3,
		["Balance of Power"]=2,
		["Nature's Majesty"]=2,
		["Moonkin Form"]=1,
		["Typhoon"]=1,
		["Shooting Stars"]=2,
		["Euphoria"]=2,
		["Owlkin Frenzy"]=3,
		["Solar Beam"]=1,
		["Force of Nature"]=1,
		["Earth and Moon"]=1,
		["Sunfire"]=1,
		["Genesis"]=3,
		["Lunar Shower"]=3,
		["Fungal Growth"]=1,
		["Starfall"]=1,
		["Heart of the Wild"]=3,
		["Natural Shapeshifter"]=2,
		["Master Shapeshifter"]=1,
		["Blessing of the Grove"]=2,
		["Perseverance"]=2,
    },
	["Feral Cat 0/32/9"] = {
		order = 2,
		["Feral Swiftness"]=2,
		["Furor"]=3,
		["Fury Swipes"]=3,
		["Primal Fury"]=2,
		["King of the Jungle"]=3,
		["Feral Charge"]=1,
		["Stampede"]=2,
		["Leader of the Pack"]=1,
		["Predatory Strikes"]=2,
		["Feral Aggression"]=2,
		["Primal Madness"]=2,
		["Endless Carnage"]=2,
		["Rend and Tear"]=3,
		["Blood in the Water"]=2,
		["Berserk"]=1,
		["Heart of the Wild"]=3,
		["Natural Shapeshifter"]=2,
		["Master Shapeshifter"]=1,
		["Nurturing Instinct"]=2,
		["Perseverance"]=2,
    },	
	["Feral Tanking 0/32/9"] = {
		order = 3,
		["Feral Swiftness"]=2,
		["Furor"]=3,
		["Fury Swipes"]=3,
		["Infected Wounds"]=2,
		["Feral Charge"]=1,
		["Thick Hide"]=3,
		["Stampede"]=1,
		["Leader of the Pack"]=1,
		["Brutal Impact"]=2,
		["Primal Fury"]=2,
		["Survival Instincts"]=1,
		["Endless Carnage"]=2,
		["Natural Reaction"]=2,
		["Rend and Tear"]=3,
		["Pulverize"]=1,
		["Feral Aggression"]=2,
		["Berserk"]=1,
		["Heart of the Wild"]=3,
		["Natural Shapeshifter"]=2,
		["Master Shapeshifter"]=1,
		["Perseverance"]=3,
    },	
	["Restoration Healing 5/0/31"] = {
		order = 4,
		["Heart of the Wild"]=3,
		["Blessing of the Grove"]=2,
		["Improved Rejuvenation"]=3,
		["Naturalist"]=2,
		["Perseverance"]=3,
		["Revitalize"]=2,
		["Empowered Touch"]=2,
		["Nature's Swiftness"]=1,
		["Malfurion's Gift"]=2,
		["Wild Growth"]=1,
		["Efflorescence"]=3,
		["Natural Shapeshifter"]=2,
		["Gift of the Earthmother"]=3,
		["Swift Rejuvenation"]=1,
		["Tree of Life"]=1,
		["Nature's Grace"]=3,
		["Nature's Majesty"]=2,
		["Moonglow"]=3,
		["Genesis"]=2,		
	},
	},
HUNTER = {
	["Beast Mastery 31/5/5"] = {
		order = 1,
		["One with Nature"]=3,
		["Bestial Discipline"]=3,
		["Frenzy"]=3,
		["Improved Mend Pet"]=2,
		["Cobra Strikes"]=3,
		["Fervor"]=1,
		["Focus Fire"]=1,
		["Longevity"]=3,
		["Killing Streak"]=2,
		["Bestial Wrath"]=1,
		["Ferocious Inspiration"]=1,
		["Improved Kill Command"]=2,
		["The Beast Within"]=1,
		["Kindred Spirits"]=2,
		["Invigoration"]=2,
		["Beast Mastery"]=1,
		["Go for the Throat"]=2,
		["Efficiency"]=3,
		["Improved Serpent Sting"]=2,
		["Pathing"]=3,	
	},
	["Marksmanship 5/31/5"] = {
		order = 2,
		["Rapid Killing"]=2,
		["Efficiency"]=3,
		["Improved Steady Shot"]=3,
		["Careful Aim"]=2,
		["Piercing Shots"]=3,
		["Silencing Shot"]=1,
		["Go for the Throat"]=2,
		["Trueshot Aura"]=1,
		["Termination"]=2,
		["Bombardment"]=2,
		["Rapid Recuperation"]=2,
		["Master Marksman"]=3,
		["Marked for Death"]=2,
		["Posthaste"]=2,
		["Chimera Shot"]=1,
		["Pathing"]=3,
		["One with Nature"]=3,
		["Bestial Discipline"]=2,
		["Frenzy"]=2,
	},	
	["Survival 5/5/31"] = {
		order = 3,
		["Improved Serpent Sting"]=2,
		["Pathing"]=3,
		["Trap Mastery"]=3,
		["Survival Tactics"]=2,
		["Lock and Load"]=2,
		["Thrill of the Hunt"]=3,
		["T.N.T."]=2,
		["Resourcefulness"]=3,
		["Wyvern Sting"]=1,
		["Noxious Stings"]=2,
		["Toxicology"]=2,
		["Sniper Training"]=3,
		["Serpent Spread"]=1,
		["Hunting Party"]=1,
		["Black Arrow"]=1,
		["One with Nature"]=3,
		["Efficiency"]=3,
		["Go for the Throat"]=2,
		["Bestial Discipline"]=2,
	},		
    },
MAGE = {
	["Arcane 33/5/3"] = {
		order = 1,
		["Arcane Concentration"]=3,
		["Netherwind Presence"]=3,
		["Improved Arcane Missiles"]=2,
		["Torment the Weak"]=3,
		["Missile Barrage"]=2,
		["Presence of Mind"]=1,
		["Arcane Flows"]=2,
		["Arcane Tactics"]=1,
		["Incanter's Absorption"]=2,
		["Prismatic Cloak"]=3,
		["Slow"]=1,
		["Arcane Potency"]=2,
		["Nether Vortex"]=2,
		["Focus Magic"]=1,
		["Improved Mana Gem"]=2,
		["Arcane Power"]=1,
		["Invocation"]=2,
		["Master of Elements"]=2,
		["Burning Soul"]=3,
		["Piercing Ice"]=3,
	},
	["Fire 3/35/3"] = {
		order = 2,
		["Master of Elements"]=2,
		["Burning Soul"]=3,
		["Ignite"]=3,
		["Fire Power"]=3,
		["Blast Wave"]=1,
		["Hot Streak"]=1,
		["Improved Scorch"]=2,
		["Combustion"]=1,
		["Firestarter"]=1,
		["Improved Hot Streak"]=2,
		["Impact"]=2,
		["Dragon's Breath"]=1,
		["Improved Flamestrike"]=2,
		["Molten Fury"]=3,
		["Critical Mass"]=3,
		["Living Bomb"]=1,
		["Piercing Ice"]=3,
		["Netherwind Presence"]=3,
		["Cauterize"]=2,
		["Pyromaniac"]=2,
	},	
	["Frost 2/8/31"] = {
		order = 3,
		["Piercing Ice"]=3,
		["Early Frost"]=2,
		["Piercing Chill"]=2,
		["Improved Cone of Cold"]=2,
		["Permafrost"]=1,
		["Icy Veins"]=1,
		["Fingers of Frost"]=3,
		["Improved Freeze"]=3,
		["Cold Snap"]=1,
		["Ice Floes"]=3,
		["Ice Barrier"]=1,
		["Shatter"]=2,
		["Enduring Winter"]=1,
		["Frostfire Orb"]=2,
		["Brain Freeze"]=3,
		["Deep Freeze"]=1,
		["Master of Elements"]=2,
		["Burning Soul"]=3,
		["Ignite"]=3,
		["Netherwind Presence"]=2,	
	},	
    },
PALADIN = {
	["Holy Healing 34/5/2"] = {
		order = 1,
		["Judgements of the Pure"]=3,
		["Protector of the Innocent "]=3,
		["Clarity of Purpose"]=3,
		["Last Word"]=2,
		["Divine Favor"]=1,
		["Infusion of Light"]=2,
		["Daybreak"]=2,
		["Beacon of Light"]=1,
		["Enlightened Judgements"]=2,
		["Speed of Light"]=3,
		["Conviction"]=3,
		["Tower of Radiance"]=3,
		["Blessed Life"]=2,
		["Light of Dawn"]=1,
		["Improved Judgement"]=2,
		["Divinity"]=3,
		["Eternal Glory"]=2,
		["Sacred Cleansing"]=1,
		["Paragon of Virtue"]=1,
		["Aura Mastery"]=1,	
		},
	["Protection Tanking 0/33/8"] = {
		order = 2,
		["Seals of the Pure"]=2,
		["Divinity"]=3,
		["Toughness"]=3,
		["Judgements of the Just"]=2,
		["Sanctuary"]=3,
		["Hammer of the Righteous"]=1,
		["Hallowed Ground"]=2,
		["Shield of the Righteous"]=1,
		["Grand Crusader"]=2,
		["Reckoning"]=2,
		["Holy Shield"]=1,
		["Vindication"]=1,
		["Guarded by the Light"]=2,
		["Sacred Duty"]=2,
		["Shield of the Templar"]=3,
		["Ardent Defender"]=1,
		["Wrath of the Lightbringer"]=2,
		["Improved Judgement"]=2,
		["Crusade"]=3,
		["Pursuit of Justice"]=2,
		["Rule of Law"]=3,
		},		
	["Retribution DPS 7/2/32"] = {
			order = 3,
		["Improved Judgement"]=2,
		["Crusade"]=3,
		["Pursuit of Justice"]=2,
		["Rule of Law"]=3,
		["Communion"]=1,
		["Divine Storm"]=1,
		["The Art of War"]=3,
		["Seals of Command"]=1,
		["Sanctified Wrath"]=3,
		["Sanctity of Battle"]=1,
		["Repentance"]=1,
		["Divine Purpose"]=2,
		["Long Arm of the Law"]=2,
		["Inquiry of Faith"]=3,
		["Sacred Shield"]=1,
		["Eye for an Eye"]=2,
		["Zealotry"]=1,
		["Seals of the Pure"]=2,
		["Judgements of the Pure"]=3,
		["Arbiter of the Light"]=2,
		["Blazing Light"]=2,
		},	
	},
PRIEST = {
	["Discipline Healing 33/8/0"] = {
		order = 1,
		["Twin Disciplines"]=3,
		["Improved Power Word: Shield"]=2,
		["Soul Warding"]=2,
		["Mental Agility"]=3,
		["Renewed Hope"]=2,
		["Power Infusion"]=1,
		["Inner Focus"]=1,
		["Inner Sanctum"]=1,
		["Rapture"]=3,
		["Borrowed Time"]=2,
		["Strength of Soul"]=2,
		["Divine Aegis"]=3,
		["Grace"]=2,
		["Train of Thought"]=2,
		["Pain Suppression"]=1,
		["Power Word: Barrier"]=1,
		["Divine Fury"]=3,
		["Empowered Healing"]=3,
		["Inspiration"]=2,
		["Veiled Shadows"]=2,		
		},	
	["Holy Healing 6/32/3"] = {
		order = 2,
		["Improved Renew"]=2,
		["Divine Fury"]=3,
		["Surge of Light"]=2,
		["Inspiration"]=2,
		["Desperate Prayer"]=1,
		["Divine Touch"]=2,
		["Holy Concentration"]=2,
		["Lightwell"]=1,
		["Spirit of Redemption"]=1,
		["Serendipity"]=2,
		["Empowered Healing"]=2,
		["Chakra"]=1,
		["Revelations"]=1,
		["Tome of Light"]=2,
		["Empowered Healing"]=1,
		["Test of Faith"]=3,
		["Circle of Healing"]=1,
		["Body and Soul"]=2,
		["Guardian Spirit"]=1,
		["Veiled Shadows"]=2,
		["Darkness"]=1,
		["Twin Disciplines"]=3,
		["Mental Agility"]=3,	
		},				
	["Shadow DPS 10/0/31"] = {
		order = 3,
		["Darkness"]=3,
		["Improved Shadow Word: Pain"]=2,
		["Improved Devouring Plague"]=2,
		["Improved Mind Blast"]=3,
		["Shadowform"]=1,
		["Harnessed Shadows"]=2,
		["Twisted Faith"]=2,
		["Vampiric Embrace"]=1,
		["Masochism"]=2,
		["Mind Melt"]=2,
		["Vampiric Touch"]=1,
		["Pain and Suffering"]=2,
		["Veiled Shadows"]=2,
		["Sin and Punishment"]=2,
		["Shadowy Apparition"]=3,
		["Dispersion"]=1,
		["Twin Disciplines"]=3,
		["Mental Agility"]=2,
		["Evangelism"]=2,
		["Archangel"]=1,
		["Inner Sanctum"]=2,
		},				
    },
ROGUE = {
	["Assassination 34/0/7"] = {
			order = 1,
			["Lethality"]=3,
			["Coup de Grace"]=3,
			["Puncturing Wounds"]=3,
			["Ruthlessness"]=3,
			["Vile Poisons"]=3,
			["Cold Blood"]=1,
			["Seal Fate"]=2,
			["Quickening"]=2,
			["Master Poisoner"]=1,
			["Overkill"]=1,
			["Murderous Intent"]=2,
			["Deadly Momentum"]=1,
			["Cut to the Chase"]=3,
			["Venomous Wounds"]=2,
			["Vendetta"]=1,
			["Deadened Nerves"]=3,
			["Relentless Strikes"]=3,
			["Nightstalker"]=2,
			["Opportunity"]=2,		
		},
	["Combat 7/31/3"] = {
			order = 2,
			["Improved Sinister Strike"]=3,
			["Improved Recuperate"]=2,
			["Aggression"]=3,
			["Improved Slice and Dice"]=2,
			["Lightning Reflexes"]=3,
			["Revealing Strike"]=1,
			["Precision"]=3,
			["Combat Potency"]=3,
			["Adrenaline Rush"]=1,
			["Savage Combat"]=2,
			["Reinforced Leather"]=2,
			["Bandit's Guile"]=3,
			["Restless Blades"]=2,
			["Killing Spree"]=1,
			["Relentless Strikes"]=3,
			["Lethality"]=3,
			["Coup de Grace"]=2,
			["Ruthlessness"]=2,			
		},
	["Subtlety 8/2/31"] = {
			order = 3,
			["Relentless Strikes"]=3,
			["Improved Ambush"]=2,
			["Opportunity"]=3,
			["Elusiveness"]=2,
			["Hemorrhage"]=1,
			["Energetic Recovery"]=3,
			["Find Weakness"]=2,
			["Premeditation"]=1,
			["Honor Among Thieves"]=3,
			["Preparation"]=1,
			["Cheat Death"]=3,
			["Nightstalker"]=2,
			["Slaughter from the Shadows"]=3,
			["Initiative"]=1,
			["Shadow Dance"]=1,
			["Improved Recuperate"]=2,
			["Deadly Momentum"]=2,
			["Lethality"]=3,
			["Quickening"]=2,
			["Puncturing Wounds"]=1,					
		},	
    },
SHAMAN = {
	["Elemental DPS 34/7/0"] = {
		order = 1,
		["Concussion"]=3,
		["Acuity"]=3,
		["Elemental Precision"]=3,
		["Call of Flame"]=2,
		["Rolling Thunder"]=2,
		["Elemental Focus"]=1,
		["Elemental Reach"]=2,
		["Lava Flows"]=3,
		["Elemental Oath"]=2,
		["Fulmination"]=1,
		["Elemental Mastery"]=1,
		["Totemic Wrath"]=1,
		["Reverberation"]=2,
		["Feedback"]=3,
		["Lava Surge"]=2,
		["Earthquake"]=1,
		["Elemental Weapons"]=2,
		["Improved Shields"]=3,
		["Ancestral Swiftness"]=2,
		["Convection"]=2,
	},
	["Enhancement DPS 10/31/0"] = {
		order = 2,
		["Focused Strikes"]=3,
		["Elemental Weapons"]=2,
		["Flurry"]=3,
		["Elemental Devastation"]=3,
		["Stormstrike"]=1,
		["Static Shock"]=3,
		["Searing Flames"]=3,
		["Ancestral Swiftness"]=2,
		["Shamanistic Rage"]=1,
		["Unleashed Rage"]=2,
		["Totemic Reach"]=2,
		["Maelstrom Weapon"]=3,
		["Improved Lava Lash"]=2,
		["Feral Spirit"]=1,
		["Concussion"]=3,
		["Acuity"]=3,
		["Reverberation"]=2,
		["Elemental Precision"]=2,
	},
	["Restoration 1/9/31"] = {
		order = 3,
		["Spark of Life"]=3,
		["Ancestral Resolve"]=2,
		["Improved Water Shield"]=2,
		["Totemic Focus"]=2,
		["Tidal Focus"]=3,
		["Nature's Blessing"]=3,
		["Nature's Swiftness"]=1,
		["Ancestral Healing"]=2,
		["Soothing Rains"]=2,
		["Improved Cleanse Spirit"]=1,
		["Ancestral Awakening"]=3,
		["Mana Tide Totem"]=1,
		["Tidal Waves"]=3,
		["Cleansing Waters"]=2,
		["Riptide"]=1,
		["Improved Shields"]=3,
		["Elemental Weapons"]=2,
		["Ancestral Swiftness"]=2,
		["Totemic Reach"]=2,
		["Acuity"]=1,
	},		
    },
WARLOCK = {
	["Affliction 31/7/3"] = {
		order = 1,
		["Doom and Gloom"]=2,
		["Improved Corruption"]=3,
		["Soul Siphon"]=2,
		["Siphon Life"]=2,
		["Improved Life Tap"]=2,
		["Eradication"]=3,
		["Jinx"]=2,
		["Soul Swap"]=1,
		["Shadow Embrace"]=3,
		["Death's Embrace"]=3,
		["Nightfall"]=2,
		["Everlasting Affliction"]=3,
		["Pandemic"]=2,
		["Haunt"]=1,
		["Dark Arts"]=3,
		["Fel Synergy"]=2,
		["Mana Feed"]=2,
		["Shadow and Flame"]=3,
	},
	["Demonology 0/31/10"] = {
		order = 2,
		["Dark Arts"]=3,
		["Fel Synergy"]=2,
		["Mana Feed"]=2,
		["Demonic Aegis"]=2,
		["Demonic Rebirth"]=2,
		["Demonic Empowerment"]=1,
		["Impending Doom"]=3,
		["Hand of Gul'dan"]=1,
		["Molten Core"]=3,
		["Demonic Embrace"]=3,
		["Inferno"]=1,
		["Decimation"]=2,
		["Ancient Grimoire"]=2,
		["Cremation"]=2,
		["Demonic Pact"]=1,
		["Metamorphosis"]=1,
		["Shadow and Flame"]=3,
		["Improved Immolate"]=2,
		["Bane"]=3,
		["Emberstorm"]=2,
    },
	["Destruction 3/7/31"] = {
		order = 3,
		["Improved Immolate"]=2,
		["Shadow and Flame"]=3,
		["Emberstorm"]=2,
		["Bane"]=3,
		["Shadowburn"]=1,
		["Backdraft"]=3,
		["Improved Soul Fire"]=2,
		["Burning Embers"]=2,
		["Soul Leech"]=2,
		["Nether Ward"]=1,
		["Fire and Brimstone"]=3,
		["Shadowfury"]=1,
		["Nether Protection"]=2,
		["Empowered Imp"]=2,
		["Bane of Havoc"]=1,
		["Chaos Bolt"]=1,
		["Improved Corruption"]=3,
		["Dark Arts"]=3,
		["Fel Synergy"]=2,
		["Mana Feed"]=2,	
	},		
},
WARRIOR = {
        ["Arms DPS (33/5/3)"] = {
			order = 1,
			["War Academy"]=3,
			["Blitz"]=2,
			["Deep Wounds"]=3,
			["Second Wind"]=2,
			["Impale"]=2,
			["Taste for Blood"]=3,
			["Sweeping Strikes"]=1,
			["Blood Frenzy"]=2,
			["Drums of War"]=2,
			["Lambs to the Slaughter"]=3,
			["Juggernaut"]=1,
			["Deadly Calm"]=1,
			["Sudden Death"]=2,
			["Wrecking Crew"]=2,
			["Throwdown"]=1,
			["Bladestorm"]=1,
			["Tactical Mastery"]=2,
			["Incite"]=3,
			["Blood Craze"]=3,
			["Battle Trance"]=2,
        },
        ["Fury DPS (7/31/3)"] = {
			order = 2,
			["Battle Trance"]=3,
			["Cruelty"]=2,
			["Executioner"]=2,
			["Rude Interruption"]=2,
			["Booming Voice"]=2,
			["Flurry"]=3,
			["Death Wish"]=1,
			["Enrage"]=3,
			["Raging Blow"]=1,
			["Rampage"]=1,
			["Heroic Fury"]=1,
			["Intensify Rage"]=2,
			["Meat Cleaver"]=2,
			["Bloodsurge"]=3,
			["Skirmisher"]=2,
			["Titan's Grip"]=1,
			["War Academy"]=3,
			["Incite"]=3,
			["Field Dressing"]=2,
			["Deep Wounds"]=2,
        },
        ["Protection Tanking (8/2/31)"] = {
			order = 3,
			["Toughness"]=3,
			["Blood and Thunder"]=2,
			["Shield Mastery"]=3,
			["Hold the Line"]=2,
			["Concussion Blow"]=1,
			["Bastion of Defense"]=2,
			["Warbringer"]=1,
			["Shield Specialization"]=3,
			["Devastate"]=1,
			["Improved Revenge"]=2,
			["Thunderstruck"]=2,
			["Heavy Repercussions"]=2,
			["Gag Order"]=2,
			["Sword and Board"]=3,
			["Last Stand"]=1,
			["Shockwave"]=1,
			["Blood Craze"]=2,
			["War Academy"]=3,
			["Field Dressing"]=2,
			["Deep Wounds"]=3,	
        },
    },
}