--JU

local DGV = DugisGuideViewer
if not DGV then return end

local SF, Obj, SmallFrame = DGV:RegisterModule("StickyFrame", "Objectives", "SmallFrame")
local DebugPrint = DGV.DebugPrint

local _
--DGV.StickyFrame = SF
function SF:Initialize()
	SF.StickyQuests = {} --StickyQuests[stickyrow] = mainFrameRow
	local MAX_QUESTS = 10
	
	local function GetStickyIndex(guideIndex)
		for i, index in ipairs(SF.StickyQuests) do
			if index == guideIndex then
				return i
			end
		end
	end
	
	local function OnMouseUp(button, mouseButton)
		local index = GetStickyIndex(button.guideIndex or button:GetParent().guideIndex)
		if index and mouseButton == "LeftButton" and IsShiftKeyDown() then
			table.remove(SF.StickyQuests, index)
			DGV.Modules.StickyFrame:Update()
		end
	end
	
	local function ModelButtonOnClick(button, event)
		DGV:ShowModel(button:GetParent().guideIndex)
	end

	function SF:AddRow(questIndex)
		if not tContains(SF.StickyQuests, questIndex) and #SF.StickyQuests < MAX_QUESTS then
			table.insert(SF.StickyQuests, questIndex)    
			DGV.Modules.StickyFrame:Update()
		end
	end

	function SF:Load()
		local container = Mixin(DugisStickyFrameContainer, SmallFrame.DugisHeaderlessContainerMixin)
		container.NineSlice = DGV.RecursiveStub
		self.trackerModuleBlockTemplate = "DugisStickyFrameObjectiveBlockTemplate" --identical template, but the pools need to be kept distinct
		self.trackerModuleName = "DugisStickyFrameObjectiveModule"
		self.trackerModuleContainer = container

		local function OnDragStart()
			container:StartMoving()
		end

		local function OnDragStop()
			container:StopMovingOrSizing()
			local point, relativeTo, relativePoint, xOfs, yOfs = container:GetPoint()
			local db = DGV.chardb.StickyFrame
		
			db.pos_x = xOfs
			db.pos_y = yOfs
			db.relativePoint = relativePoint
		end

		function SF:CreateTrackerModule()
			local module = SmallFrame.CreateTrackerModule(self, "DugisStickyFrameTrackerModuleTemplate")
			container = self.trackerModuleContainer

			function module:ShouldShow()
				return DGV:UserSetting(DGV_STICKYFRAME)
			end

			function module:LayoutBackground()
				if not container.backdropInfo then
					DGV:SetFrameBackdrop(container, "Interface\\DialogFrame\\UI-DialogBox-Gold-Background", DGV:GetBorderPath(), 10, 4, 12, 5)
				end
			end

			function module:GetBlockIdentifier(stepIndex)
				return "DGVSticky"..stepIndex
			end

			module.FadeInFadeOutTabs = DGV.NoOp
			module.SetGuideForActiveTab = nil
			module.Header = DGV.RecursiveStub

			local baseOnEnter = module.OnBlockHeaderEnter
			function module:OnBlockHeaderEnter(block)
				baseOnEnter(module, block)
				SmallFrameTooltip:Hide()
				if DGV:UserSetting(DGV_STICKYFRAMESHOWDESCRIPTIONS) then return end
				if not SF.Tooltip then
					SF.Tooltip = CreateFrame( "GameTooltip", "StickyFrameTooltip", nil, "GameTooltipTemplate" )
				end
				local guideIndex = block.guideIndex
				if guideIndex then
					SF.Tooltip:SetFrameStrata("TOOLTIP")
					SF.Tooltip:SetOwner(container, "ANCHOR_TOPLEFT")
					SF.Tooltip:SetParent(container)
					SF.Tooltip:AddLine("|cffffd200"..(block.HeaderText:GetText() or "").."|r", 1, 1, 1, true)
					SF.Tooltip:AddLine(" ", 1, 1, 1, true)
					SF.Tooltip:AddLine(Obj.GetDescriptionText(guideIndex), 1, 1, 1, true)
					SF.Tooltip:Show()
				end
			end
	
			local baseOnLeave = module.OnBlockHeaderLeave
			function module:OnBlockHeaderLeave(block)
				baseOnLeave(module, block)
				SmallFrameTooltip:Hide()
				if SF.Tooltip then
					SF.Tooltip:Hide()
				end
			end
	
			local baseOnClick = module.OnBlockHeaderClick
			function module:OnBlockHeaderClick(block, mouseButton)
				baseOnClick(module, block, mouseButton)
				OnMouseUp(block, mouseButton)
			end

			local function ChkOnClick(button, event)
				local guideIndex = button:GetParent().guideIndex
				
				DGV:UpdateRowVisualizations(guideIndex)
				local mainFrameChkButton = DGV.visualRows[guideIndex].frame.Chk
				
				DugisGuideViewer_CheckButton_OnEvent(mainFrameChkButton, event)
			end
	
			function module:IsDescriptionShown()
				return DGV:UserSetting(DGV_STICKYFRAMESHOWDESCRIPTIONS)
			end
	
			local function DragPassthrough(frame)
				frame:RegisterForDrag("LeftButton")
				frame:SetMovable(true)
				frame:HookScript("OnDragStart", OnDragStart)
				frame:HookScript("OnDragStop", OnDragStop)
			end
	
			local baseUpdateSingle = module.LayoutSingle
			function module:LayoutSingle(stepIndex)
				local block = baseUpdateSingle(module, stepIndex)
				local stepState = DGV:GetQuestState(stepIndex)
				if stepState == "C" then
					block.Chk:SetCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check")
					block.Chk:SetChecked(true)
				elseif stepState == "U" then
					block.Chk:SetCheckedTexture("") 
					block.Chk:SetChecked(false)
				elseif stepState == "X" then
					block.Chk:SetCheckedTexture("Interface\\RAIDFRAME\\ReadyCheck-NotReady") 
					block.Chk:SetChecked(true)
				end
				block.ModelButton:SetShown(DGV:HasModel(stepIndex))
				block.ModelButton:SetScript("OnClick", ModelButtonOnClick)
				block.Chk:SetScript("OnClick", ChkOnClick)
				block.Desc:SetScript("OnMouseUp", OnMouseUp)
	
				DragPassthrough(block)
				DragPassthrough(block.HeaderButton)
				DragPassthrough(block.Desc)
			end
	
			function module:LayoutContents()
				local show = module:ShouldShow()
				if show then
					for stickyIndex, guideIndex in ipairs(SF.StickyQuests) do
						self:LayoutSingle(guideIndex)
					end
				end
				self:LayoutBackground()
				self:LayoutContainer(show)
			end

			return module
		end

		SF.GetTrackerModule = Obj.GetTrackerModule
		SF.Update = SmallFrame.Update
		SF.UpdateTrackerIntegration = Obj.UpdateTrackerIntegration

		container:RegisterForDrag("LeftButton")
		container:SetScript("OnDragStart", OnDragStart)
		container:SetScript("OnDragStop", OnDragStop)
		container:ClearAllPoints()
		
		local db = DGV.chardb.StickyFrame
		container:SetPoint(db.relativePoint, db.pos_x, db.pos_y)

		function SF:Clear()
			wipe(self.StickyQuests)
			self:Update()
		end
	end

	function SF:Unload()
		self:Clear()
		self.trackerModuleContainer:Hide()
		self:UpdateTrackerIntegration(true)
	end
end
