local _

--//////////////////////////////////////////

local L = DugisLocals
local DGV = DugisGuideViewer
if not DGV then return end

local SmallFrame, Objectives = DGV:RegisterModule("SmallFrame", "Objectives")--, "Guides")
DGV.SmallFrame = SmallFrame

SmallFrame.DugisHeaderlessContainerMixin = 
{
	IsInDefaultPosition = DGV.NoOp,
	Header = DGV.RecursiveStub
}

local DBMUpdate
function SmallFrame:Initialize()
	if SmallFrame.initialized then return end
	SmallFrame.initialized = true
			
	local L = DugisLocals
	local flashGroup, flash
	local container = Mixin(DugisSmallFrameContainer, self.DugisHeaderlessContainerMixin)
	local background = container.Background
	
	function SmallFrame:Reset()
		if DGV:IsSmallFrameFloating() then
			container:ClearAllPoints()	
			container:SetPoint("TOPRIGHT", UIParent, -300, -50)
		end
	end
	
	function SmallFrame:CheckButton_OnEvent(self, event)
		local guideIndex = self:GetParent().guideIndex
		if DugisGuideUser.CurrentQuestIndex then --If a guide is loaded
			if DGV:ReturnTag("NT", guideIndex) then
				--self.Chk:SetChecked(false)
                DGV.UpdateGuideVisualRows()
			elseif guideIndex==DugisGuideUser.CurrentQuestIndex and guideIndex == DGV:GetLastUsedStepIndex() then--LastGuideNumRows then
				--self.Chk:SetChecked(false)
				DugisGuideViewer:LoadNextGuide()
                DGV.UpdateGuideVisualRows()
			else
				DugisGuideViewer:SetChkToComplete(guideIndex, true)
				if guideIndex then
                    LuaUtils:Delay(0.2, function()
                        if DugisGuideViewer:GuideOn() and DugisGuideViewer.chardb.EssentialsMode ~= 1 then
                            DGV.Modules.Guides.MoveToNextQuest(DugisGuideViewer:FindNextUnchecked())
                        end
                    end)
                    
                    LuaUtils:Delay(0.3, function()
                        DGV.UpdateGuideVisualRows()
                    end)
				end
			end
		end
	end
	
	local function OnDragStart()
		if DGV:IsSmallFrameFloating() and not InCombatLockdown() then
			container:StartMoving()
		end
	end

	local function OnDragStop()
		container:StopMovingOrSizing();
		local point = container:GetPoint()
		local expandUp = nil --strmatch(point, "BOTTOM") --disabled atm
		if(point ~= "TOPLEFT" and not expandUp)
			or (point ~= "BOTTOMLEFT" and expandUp)
		then
			local x, y = container:GetLeft(), -((GetScreenHeight() or 0)  - (container:GetTop() or 0))
			container:ClearAllPoints()

			if expandUp then
				y = -y
				y = y + container:GetHeight()
				local fromBottom = GetScreenHeight() - y
				container:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT", x, fromBottom)
			else
				container:SetPoint("TOPLEFT", x, y)
			end
		end
	end	
	
	container:HookScript("OnMouseDown", OnDragStart)
	container:HookScript("OnMouseUp", OnDragStop)
	
	function SmallFrame:PlayFlashAnimation()
		LuaUtils:Delay(0.1, function()
			--if header.animating then return end -- stop flash animation spam
			if not SmallFrame.FlashFrame then
				wf_flashGroup, _, SmallFrame.FlashFrame = DGV:CreateFlashFrame(background)
			end
			
			if DGV:UserSetting(DGV_SMALLFRAMEBORDER) and (DGV:UserSetting(DGV_SMALLFRAMETRANSITION) == L["Flash"] or DGV:UserSetting(DGV_SMALLFRAMETRANSITION) == L["Scroll"]) then				
				--DGV:DebugFormat("PlayFlashAnimation showing", "flashGroup", flashGroup)
				SmallFrame.FlashFrame:Show()
				SmallFrame.FlashFrame:SetWidth(background:GetWidth() - 14)
				SmallFrame.FlashFrame:SetHeight(background:GetHeight() - 17)
				wf_flashGroup:Stop()
				wf_flashGroup:Play()
			else
				SmallFrame.FlashFrame:Hide()
			end
		end)
	end
    
	SmallFrame.Load = function()
		if SmallFrame.loaded then return end
		SmallFrame.loaded = true

		self.trackerModuleBlockTemplate = "DugisSmallFrameObjectiveBlockTemplate" --identical template, but the pools need to be kept distinct
		self.trackerModuleName = "DugisSmallFrameObjectiveModule"
		self.trackerModuleContainer = container
		function SmallFrame:CreateTrackerModule(template)
			local container = self.trackerModuleContainer
			ObjectiveTrackerManager:AddContainer(container)
			function container:UpdateHeight()
				local height = self.topModulePadding;
				if self.modules then
					for i, module in ipairs(self.modules) do
						if module then
							height = height + module:GetContentsHeight()
						end
					end
				end
				self:SetHeight(height > self.topModulePadding and height or 800);
			end
		
			function container:GetAvailableHeight()
				return 800
			end

			local module = Objectives.CreateTrackerModule(self, template)
			function module:ShouldShow()
				return not DGV:UserSetting(DGV_ANCHOREDSMALLFRAME) 
					and not PetBattleFrame:IsShown() 
					and not DBMUpdate
					and not DGV:IncompatibleAddonLoaded()
			end

			function module:LayoutContainer(show)
				if not show then
					container:Hide()
					return
				end
				container:Show()
	
				DGV.QueueInvocation(container.UpdateHeight, container)
			end

			function module:LayoutBackground()
				if DGV:UserSetting(DGV_SMALLFRAMEBORDER)
					and DGV:GuideOn() 
					and self:ShouldShow()
				then
					if not container.Background.backdropInfo then
						DGV:SetFrameBackdrop(container.Background, DGV.BACKGRND_PATH, DGV:GetBorderPath(), 10, 4, 12, 5)
					end
					container.Background:Show()
				elseif container.Background:IsShown() then
					container.Background:Hide()
				end
			end

			local baseLayoutContents = module.LayoutContents
			function module:LayoutContents()
				local show = module:ShouldShow()
				if show then
					baseLayoutContents(self)
				end
				self:LayoutBackground()
				self:LayoutContainer(show)
			end

			function module:GetBlockIdentifier(stepIndex)
				return "DGVSmall"..stepIndex
			end

			return module
		end

		SmallFrame.GetTrackerModule = Objectives.GetTrackerModule
		SmallFrame.UpdateTrackerIntegration = Objectives.UpdateTrackerIntegration
	
		function SmallFrame:Update()
			self:UpdateTrackerIntegration(not self.loaded)
			local module = self:GetTrackerModule()
			if module then
				module:MarkDirty()
			end
		end

		function DGV:OnDBMUpdate()
			DBMUpdate = DBM.Options.HideObjectivesFrame and
				not ObjectiveTrackerFrame:IsVisible() 
			SmallFrame:Update()
		end
	end
	SmallFrame.Unload = function()
		if not SmallFrame.loaded then return end
		SmallFrame.loaded = false
		--SmallFrame:Reset()
		SmallFrameTooltip:Hide()
		container:Hide()
		self:UpdateTrackerIntegration(true)
	end
        
    --This preloader is not visible. It just prevents mouse clicks.
    DGV.GUIUtils:CreatePreloader("SmallFramePreloader", container)
    SmallFramePreloader:SetFrameStrata("BACKGROUND")
    SmallFramePreloader.Icon:Hide()  

	function SmallFrame:UpdateMovable()
		local floating = not DGV:UserSetting(DGV_LOCKSMALLFRAME)
		container:EnableMouse(floating)
		container:SetFrameLevel(2)
	end
    
	SmallFrame:UpdateMovable()
end