local DGV = DugisGuideViewer
if not DGV then return end

local TaxiData = DGV:RegisterModule("TaxiData")
TaxiData.essential = true

--Possible modes: "veiled-den", "lights-purchase"
TaxiData.currentBeaconMode = "unknown"

function TaxiData:Initialize()

	local fullData
	function TaxiData:GetFullData()
		--107457 Druid
		--98968 Hunter 
		--93465 Death Knight 
		--98114 Alliance Skyfire Triage Camp Stormheim
		--98113 Alliance Lorna's Watch Stormheim
		--98108 Alliance Greywatch Stormheim
		--92560 Horde Cullen's Post Stormheim
		if not fullData then
			fullData = {
	["Neutral"] = {
	},
	["Horde"] = {
	{
	[40851] = {
	"40871:40873",
	--["name"] = "Silver Tide Hollow, Vashj'ir",
	["m"] = 205,
	["f"] = 0,
	["direct"] = "40852:40871:43216",
	["coord"] = 2127260006,
	},
	[43216] = {
	"40851:40852",
	"40851:40871",
	"40851:40871:40873",
	["direct"] = "40851",
	["m"] = 201,
	["coord"] = 2113462499,
	["f"] = 0,
	},
	[40852] = {
	"40851:40871",
	"40851:40871:40873",
	"40851:43216",
	--["name"] = "Smuggler's Scar, Vashj'ir",
	["m"] = 201,
	["coord"] = 2414301039,
	["direct"] = "40851",
	["f"] = 0,
	},
	[40871] = {
	"40851:40852",
	"40851:43216",
	--["name"] = "Legion's Rest, Vashj'ir",
	["direct"] = "40851:40873",
	["f"] = 0,
	["m"] = 205,
	["coord"] = 2178916968,
	},
	[40873] = {
	"40871:40851:40852",
	"40871:40851",
	"40871:40851:43216",
	--["name"] = "Tenebrous Cavern, Vashj'ir",
	["m"] = 204,
	["f"] = 0,
	["direct"] = "40871",
	["coord"] = 2310772866,
	},
	[227902] = {
	"227878:227801",
	"227896:227894",
	"227901:227900",
	"227878:227952",
	["direct"] = "227901:227878:227896",
	["coord"] = 1834061533,
	["m"] = 2351,
	["f"] = 0,
	},
	[227801] = {
	----["name"] = "Entrance Gate, Razorwind Shores",
	["m"] = 2351,
	["coord"] = 2352841513,
	["f"] = 0,
	},
	[227878] = {
	----["name"] = "The Common, Razorwind Shores",
	["direct"] = "227801",
	["coord"] = 2304415981,
	["m"] = 2351,
	["f"] = 0,
	},
	[227901] = {
	"227878:227801",
	----["name"] = "Runetotem's Bounty South, Razorwind Shores",
	["m"] = 2351,
	["coord"] = 2049880821,
	["direct"] = "227878",
	["f"] = 0,
	},
	[227952] = {
	"227896:227878:227801",
	"227896:227894",
	"227896:227901",
	"227896:227900",
	----["name"] = "Cragthorn Highlands, Razorwind Shores",
	["m"] = 2351,
	["coord"] = 2845806808,
	["direct"] = "227878:227896",
	["f"] = 0,
	},
	[227894] = {
	"227896:227878:227801",
	"227896:227901",
	"227896:227900",
	"227896:227878",
	----["name"] = "Saltfang Shoals East, Razorwind Shores",
	["m"] = 2351,
	["coord"] = 2927935853,
	["direct"] = "227896",
	["f"] = 0,
	},
	[227896] = {
	"227878:227801",
	----["name"] = "The Bloom, Razorwind Shores",
	["m"] = 2351,
	["coord"] = 2542254114,
	["direct"] = "227901:227900:227878",
	["f"] = 0,
	},
	[227900] = {
	"227896:227878:227801",
	"227896:227878",
	----["name"] = "The Bluffs, Razorwind Shores",
	["direct"] = "227901",
	["coord"] = 2262946094,
	["m"] = 2351,
	["f"] = 0,
	},
	[52060] = {
	"3615:3310",
	"3615:4312",
	"2995:6726",
	"39330:40358:40769:7824",
	"39330:39898",
	"3615:8610",
	"3615:3310:11139",
	"3615:34927:34429:11901",
	"3615:34927:12616",
	"3615:34927:12616:22931:43073:43085:12740",
	"39330:40358:40769:7824:10583",
	"3615:16227",
	"3615:34927:12616:22931",
	"39330:40358",
	"3615:34927:34429",
	"3615:34927",
	"3615:34927:34943",
	"3615:4312:35141",
	"2995:35139:35140",
	"2995:35139",
	"2995:35556:35562:35315",
	"2995:35556:35478",
	"2995:35556",
	"2995:35556:35562",
	"39330:40358:40769:7824:39175",
	"2995:40809",
	"3615:40558",
	"39330:40358:40769",
	"39330:40358:40769:7824:41215",
	"3615:3310:41140:41142",
	"3615:3310:41140",
	"39330:40358:40769:7824:41214",
	"3615:4312:41246",
	"3615:3310:XY-2454825450:43481",
	"3615:3310:XY-2454825450:43481:41860",
	"3615:3310:XY-2454825450:43481:41861",
	"39330:39898:41605:40473",
	"39330:39898:41605",
	"3615:34927:12616:22931:43073",
	"3615:34927:12616:22931:43079",
	"3615:34927:12616:22931:43073:43085",
	"3615:3310:37005",
	"3615:8610:43328",
	"3615:3310:XY-2454825450",
	"39330:40358:40769:7824:41215:48275",
	"39330:39898:163253",
	"39330:39898:163253:XY-1868173255",
	"3615:34927:12616:36728",
	"3615:3310:XY-2454825450:43481:54392",
	--["name"] = "Vendetta Point, Southern Barrens",
	["m"] = 199,
	["coord"] = 1784707579,
	["direct"] = "2995:3615:44399:11899:39340:39330",
	["f"] = 0,
	},
	[37005] = {
	"3310:3615:2995",
	"3310:3615",
	"3310:3615:4312",
	"3310:3615:44399",
	"3310:3615:2995:6726",
	"3310:7824",
	"3310:3615:52060:39330:39898",
	"8610:11139",
	"3310:16227:11899",
	"3310:12616:34429:11901",
	"3310:12616",
	"8610:11139:12740",
	"3310:3615:52060",
	"3310:7824:10583",
	"3310:16227",
	"3310:12616:22931",
	"3310:16227:11899:40358",
	"3310:12616:34429",
	"3310:34927",
	"3310:12616:34943",
	"3310:12616:34429:35141",
	"3310:12616:34943:35140",
	"3310:3615:35139",
	"3310:3615:2995:35556:35562:35315",
	"3310:3615:2995:35556:35478",
	"3310:3615:2995:35556",
	"3310:3615:2995:35556:35562",
	"3310:7824:39175",
	"3310:3615:39340",
	"3310:3615:52060:39330",
	"3310:3615:2995:40809",
	"3310:40558",
	"3310:16227:11899:40358:40769",
	"3310:7824:41215",
	"3310:41140:41142",
	"3310:41140",
	"3310:7824:41214",
	"3310:12616:34943:35140:41246",
	"8610:36728:XY-2454825450:43481",
	"8610:36728:XY-2454825450:43481:41860",
	"8610:36728:XY-2454825450:43481:41861",
	"3310:3615:2995:6726:40473",
	"3310:3615:52060:39330:39898:41605",
	"8610:11139:43085:43073",
	"3310:12616:22931:43079",
	"8610:11139:43085",
	"8610:43328",
	"8610:36728:XY-2454825450",
	"3310:7824:41215:48275",
	"3310:3615:52060:39330:39898:163253",
	"3310:3615:52060:39330:39898:163253:XY-1868173255",
	"8610:36728",
	"8610:36728:XY-2454825450:43481:54392",
	--["name"] = "Southern Rocketway, Azshara",
	["m"] = 76,
	["f"] = 0,
	["direct"] = "3310:8610",
	["coord"] = 2213068365,
	},
	[8610] = {
	"12616:34943:35140:4312",
	"3310:3615:44399",
	"2995:6726",
	"3310:7824",
	"3310:3615:52060:39330:39898",
	"3310:16227:11899",
	"12616:34429:11901",
	"11139:12740",
	"3310:3615:52060",
	"3310:7824:10583",
	"3310:16227",
	"12616:22931",
	"3310:16227:11899:40358",
	"12616:34429",
	"12616:34927",
	"12616:34943",
	"12616:34429:35141",
	"12616:34943:35140",
	"3310:3615:35139",
	"12616:34943:35140:4312:35315",
	"2995:35556:35478",
	"2995:35556",
	"12616:34943:35140:4312:35315:35562",
	"3310:7824:39175",
	"3310:3615:39340",
	"3310:3615:52060:39330",
	"2995:40809",
	"3310:40558",
	"3310:16227:11899:40358:40769",
	"3310:7824:41215",
	"3310:41140:41142",
	"3310:41140",
	"3310:7824:41214",
	"12616:34943:35140:41246",
	"36728:XY-2454825450:43481",
	"36728:XY-2454825450:43481:41860",
	"36728:XY-2454825450:43481:41861",
	"2995:6726:40473",
	"3310:3615:52060:39330:39898:41605",
	"11139:43085:43073",
	"12616:22931:43079",
	"11139:43085",
	"36728:XY-2454825450",
	"3310:7824:41215:48275",
	"3310:3615:52060:39330:39898:163253",
	"3310:3615:52060:39330:39898:163253:XY-1868173255",
	"36728:XY-2454825450:43481:54392",
	--["name"] = "Bilgewater Harbor, Azshara",
	["m"] = 76,
	["f"] = 0,
	["direct"] = "2995:3310:3615:11139:12616:37005:43328:36728",
	["coord"] = 2275573679,
	},
	[41860] = {
	"43481:XY-2454825450:3310:3615:2995",
	"43481:XY-2454825450:3310",
	"43481:XY-2454825450:3310:3615",
	"43481:XY-2454825450:36728:12616:34943:35140:4312",
	"43481:XY-2454825450:3310:3615:44399",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:6726",
	"43481:XY-2454825450:3310:7824",
	"43481:XY-2454825450:3310:3615:52060:39330:39898",
	"43481:XY-2454825450:36728:8610",
	"41861:11139",
	"43481:XY-2454825450:3310:16227:11899",
	"43481:XY-2454825450:36728:12616:34429:11901",
	"43481:XY-2454825450:36728:12616",
	"41861:12740",
	"43481:XY-2454825450:3310:3615:52060",
	"43481:XY-2454825450:3310:7824:10583",
	"43481:XY-2454825450:3310:16227",
	"43481:XY-2454825450:36728:12616:22931",
	"43481:XY-2454825450:3310:16227:11899:40358",
	"43481:XY-2454825450:36728:12616:34429",
	"43481:XY-2454825450:36728:12616:34927",
	"43481:XY-2454825450:36728:12616:34943",
	"43481:XY-2454825450:36728:12616:34429:35141",
	"43481:XY-2454825450:36728:12616:34943:35140",
	"43481:XY-2454825450:36728:12616:34943:35140:35139",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:35315",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:35478",
	"43481:XY-2454825450:3310:3615:2995:35556",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:35315:35562",
	"43481:XY-2454825450:3310:7824:39175",
	"43481:XY-2454825450:3310:3615:39340",
	"43481:XY-2454825450:3310:3615:52060:39330",
	"43481:XY-2454825450:3310:3615:2995:40809",
	"43481:XY-2454825450:3310:40558",
	"43481:XY-2454825450:3310:16227:11899:40358:40769",
	"43481:XY-2454825450:3310:7824:41215",
	"43481:XY-2454825450:3310:41140:41142",
	"43481:XY-2454825450:3310:41140",
	"43481:XY-2454825450:3310:7824:41214",
	"43481:XY-2454825450:36728:12616:34943:35140:41246",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:6726:40473",
	"43481:XY-2454825450:3310:3615:52060:39330:39898:41605",
	"41861:12740:43085:43073",
	"43481:XY-2454825450:36728:12616:22931:43079",
	"41861:12740:43085",
	"43481:XY-2454825450:36728:8610:37005",
	"43481:XY-2454825450:36728:8610:43328",
	"43481:XY-2454825450",
	"43481:XY-2454825450:3310:7824:41215:48275",
	"43481:XY-2454825450:3310:3615:52060:39330:39898:163253",
	"43481:XY-2454825450:3310:3615:52060:39330:39898:163253:XY-1868173255",
	"43481:XY-2454825450:36728",
	"43481:54392",
	--["name"] = "Grove of Aessina, Hyjal",
	["m"] = 198,
	["f"] = 0,
	["direct"] = "43481:41861",
	["coord"] = 839539956,
	},
	[35562] = {
	"35556:2995",
	"35556:2995:3310",
	"35556:2995:3615",
	"35315:4312",
	"35556:2995:44399",
	"35556:2995:7824",
	"35315:39898",
	"35556:2995:8610",
	"35556:2995:8610:11139",
	"35556:2995:52060:11899",
	"35315:4312:11901",
	"35315:4312:35140:34943:12616",
	"35315:4312:34429:22931:43073:43085:12740",
	"35556:2995:52060",
	"35315:6726:40473:41605:39175:10583",
	"35556:2995:3615:16227",
	"35315:4312:34429:22931",
	"35556:2995:52060:39330:40358",
	"35315:4312:34429",
	"35556:2995:3615:34927",
	"35315:4312:35140:34943",
	"35315:4312:35141",
	"35315:4312:35140",
	"35556:2995:35139",
	"35315:6726:40473:41605:39175",
	"35556:2995:39340",
	"35556:2995:52060:39330",
	"35556:2995:40809",
	"35556:2995:3615:40558",
	"35556:2995:52060:39330:40358:40769",
	"35556:2995:7824:41215",
	"35556:2995:3310:41140:41142",
	"35556:2995:3310:41140",
	"35556:2995:7824:41214",
	"35315:4312:41246",
	"35556:2995:3310:XY-2454825450:43481",
	"35556:2995:3310:XY-2454825450:43481:41860",
	"35556:2995:3310:XY-2454825450:43481:41861",
	"35315:6726:40473",
	"35315:6726:40473:41605",
	"35315:4312:34429:22931:43073",
	"35315:4312:34429:22931:43079",
	"35315:4312:34429:22931:43073:43085",
	"35556:2995:3310:37005",
	"35556:2995:8610:43328",
	"35556:2995:3310:XY-2454825450",
	"35315:6726:40473:41605:163253:48275",
	"35315:6726:40473:41605:163253",
	"35315:6726:40473:41605:163253:XY-1868173255",
	"35315:4312:35140:34943:12616:36728",
	"35556:2995:3310:XY-2454825450:43481:54392",
	--["name"] = "Ethel Rethor, Desolace",
	["m"] = 66,
	["coord"] = 1676428521,
	["direct"] = "6726:35315:35478:35556",
	["f"] = 0,
	},
	[40358] = {
	"11899:52060:2995",
	"11899:16227:3310",
	"11899:52060:3615",
	"11899:52060:3615:4312",
	"44399:39898:41605:40473:6726",
	"40769:7824",
	"44399:39898",
	"11899:16227:3310:8610",
	"11899:16227:3310:11139",
	"11899:52060:3615:34927:34429:11901",
	"11899:52060:3615:34927:12616",
	"11899:52060:3615:34927:12616:22931:43073:43085:12740",
	"11899:52060",
	"40769:7824:10583",
	"11899:16227",
	"11899:52060:3615:34927:12616:22931",
	"11899:52060:3615:34927:34429",
	"11899:52060:3615:34927",
	"11899:52060:3615:34927:34943",
	"11899:52060:3615:4312:35141",
	"11899:52060:2995:35139:35140",
	"11899:52060:2995:35139",
	"11899:52060:2995:35556:35562:35315",
	"11899:52060:2995:35556:35478",
	"11899:52060:2995:35556",
	"11899:52060:2995:35556:35562",
	"40769:7824:39175",
	"11899:52060:39340",
	"11899:52060:2995:40809",
	"11899:52060:3615:40558",
	"40769:7824:41215",
	"11899:16227:3310:41140:41142",
	"11899:16227:3310:41140",
	"40769:7824:41214",
	"11899:52060:3615:4312:41246",
	"11899:16227:3310:XY-2454825450:43481",
	"11899:16227:3310:XY-2454825450:43481:41860",
	"11899:16227:3310:XY-2454825450:43481:41861",
	"44399:39898:41605:40473",
	"44399:39898:41605",
	"11899:52060:3615:34927:12616:22931:43073",
	"11899:52060:3615:34927:12616:22931:43079",
	"11899:52060:3615:34927:12616:22931:43073:43085",
	"11899:16227:3310:37005",
	"11899:16227:3310:8610:43328",
	"11899:16227:3310:XY-2454825450",
	"40769:7824:41215:48275",
	"40769:7824:39175:163253",
	"40769:7824:41215:48275:XY-1868173255",
	"11899:16227:3310:36728",
	"11899:16227:3310:XY-2454825450:43481:54392",
	--["name"] = "Mudsprocket, Dustwallow Marsh",
	["m"] = 70,
	["f"] = 0,
	["direct"] = "44399:11899:39330:40769",
	["coord"] = 1838987631,
	},
	[12740] = {
	"43085:43073:22931:34429:4312:35139:2995",
	"41861:43481:XY-2454825450:3310",
	"43085:43073:22931:12616:34927:3615",
	"43085:43073:22931:34429:4312",
	"43085:43073:22931:12616:34927:3615:44399",
	"43085:43073:22931:34429:4312:6726",
	"41861:43481:XY-2454825450:3310:7824",
	"43085:43073:22931:12616:34927:3615:52060:39330:39898",
	"11139:8610",
	"43085:43073:22931:12616:34927:3615:52060:11899",
	"43085:43073:22931:34429:11901",
	"43085:43073:22931:12616",
	"43085:43073:22931:12616:34927:3615:52060",
	"41861:43481:XY-2454825450:3310:7824:10583",
	"41861:43481:XY-2454825450:3310:16227",
	"43085:43073:22931",
	"43085:43073:22931:12616:34927:3615:52060:39330:40358",
	"43085:43073:22931:34429",
	"43085:43073:22931:12616:34927",
	"43085:43073:22931:34429:34943",
	"43085:43073:22931:34429:35141",
	"43085:43073:22931:34429:34943:35140",
	"43085:43073:22931:34429:4312:35139",
	"43085:43073:22931:34429:4312:35315",
	"43085:43073:22931:34429:4312:35478",
	"43085:43073:22931:34429:4312:35478:35556",
	"43085:43073:22931:34429:4312:35315:35562",
	"41861:43481:XY-2454825450:3310:7824:39175",
	"43085:43073:22931:12616:34927:3615:39340",
	"43085:43073:22931:12616:34927:3615:52060:39330",
	"43085:43073:22931:34429:4312:35139:2995:40809",
	"41861:43481:XY-2454825450:3310:40558",
	"43085:43073:22931:12616:34927:3615:52060:39330:40358:40769",
	"41861:43481:XY-2454825450:3310:7824:41215",
	"41861:43481:XY-2454825450:3310:41140:41142",
	"41861:43481:XY-2454825450:3310:41140",
	"41861:43481:XY-2454825450:3310:7824:41214",
	"43085:43073:22931:34429:35141:41246",
	"41861:43481",
	"41861:41860",
	"43085:43073:22931:34429:4312:6726:40473",
	"43085:43073:22931:12616:34927:3615:52060:39330:39898:41605",
	"43085:43073",
	"43085:43073:43079",
	"11139:8610:37005",
	"11139:8610:43328",
	"41861:43481:XY-2454825450",
	"41861:43481:XY-2454825450:3310:7824:41215:48275",
	"43085:43073:22931:12616:34927:3615:52060:39330:39898:163253",
	"43085:43073:22931:12616:34927:3615:52060:39330:39898:163253:XY-1868173255",
	"41861:43481:XY-2454825450:36728",
	"41861:43481:54392",
	--["name"] = "Moonglade",
	["m"] = 80,
	["coord"] = 1384032937,
	["direct"] = "11139:41861:43085",
	["f"] = 0,
	},
	[41246] = {
	"4312:35139:2995",
	"35140:34927:3310",
	"4312:3615",
	"4312:35139:2995:44399",
	"4312:6726",
	"4312:35139:2995:7824",
	"4312:35139:2995:52060:39330:39898",
	"35140:34943:12616:36728:8610",
	"35141:34429:22931:43073:43085:11139",
	"4312:35139:2995:52060:11899",
	"35141:11901",
	"35140:34943:12616",
	"35141:34429:22931:43073:43085:12740",
	"4312:35139:2995:52060",
	"4312:35139:2995:7824:10583",
	"4312:3615:16227",
	"35141:34429:22931",
	"4312:35139:2995:52060:39330:40358",
	"35141:34429",
	"35140:34927",
	"35140:34943",
	"4312:35139",
	"4312:35315",
	"4312:35478",
	"4312:35478:35556",
	"4312:35315:35562",
	"4312:6726:40473:41605:39175",
	"4312:35139:2995:39340",
	"4312:35139:2995:52060:39330",
	"4312:35139:2995:40809",
	"35140:34927:40558",
	"4312:35139:2995:52060:39330:40358:40769",
	"4312:35139:2995:7824:41215",
	"35140:34927:3310:41140:41142",
	"35140:34927:3310:41140",
	"4312:35139:2995:7824:41214",
	"35140:34943:12616:36728:XY-2454825450:43481",
	"35140:34943:12616:36728:XY-2454825450:43481:41860",
	"35140:34943:12616:36728:XY-2454825450:43481:41861",
	"4312:6726:40473",
	"4312:6726:40473:41605",
	"35141:34429:22931:43073",
	"35141:34429:22931:43079",
	"35141:34429:22931:43073:43085",
	"35140:34943:12616:36728:8610:37005",
	"35140:34943:12616:36728:8610:43328",
	"35140:34943:12616:36728:XY-2454825450",
	"4312:6726:40473:41605:163253:48275",
	"4312:6726:40473:41605:163253",
	"4312:6726:40473:41605:163253:XY-1868173255",
	"35140:34943:12616:36728",
	"35140:34943:12616:36728:XY-2454825450:43481:54392",
	--["name"] = "The Sludgewerks, Stonetalon Mountains",
	["m"] = 65,
	["coord"] = 2312660676,
	["direct"] = "4312:35141:35140",
	["f"] = 0,
	},
	[12616] = {
	"34927:3615:2995",
	"34943:35140:4312",
	"34927:3615:44399",
	"34943:35140:4312:6726",
	"34927:3615:52060:39330:40358:40769:7824",
	"34927:3615:52060:39330:39898",
	"36728:8610:11139",
	"34927:3615:52060:11899",
	"22931:43073:43085:12740",
	"34927:3615:52060",
	"34927:3615:52060:39330:40358:40769:7824:10583",
	"34927:3615:16227",
	"34927:3615:52060:39330:40358",
	"34429:35141",
	"34943:35140",
	"34943:35140:35139",
	"34943:35140:4312:35315",
	"34943:35140:4312:35478",
	"34927:3615:2995:35556",
	"34943:35140:4312:35315:35562",
	"34927:3615:52060:39330:40358:40769:7824:39175",
	"34927:3615:39340",
	"34927:3615:52060:39330",
	"34927:3615:2995:40809",
	"34927:40558",
	"34927:3615:52060:39330:40358:40769",
	"34927:3615:52060:39330:40358:40769:7824:41215",
	"3310:41140:41142",
	"3310:41140",
	"34927:3615:52060:39330:40358:40769:7824:41214",
	"34943:35140:41246",
	"36728:XY-2454825450:43481",
	"36728:XY-2454825450:43481:41860",
	"36728:XY-2454825450:43481:41861",
	"34943:35140:4312:6726:40473",
	"34927:3615:52060:39330:39898:41605",
	"22931:43073",
	"22931:43079",
	"22931:43073:43085",
	"36728:8610:37005",
	"36728:8610:43328",
	"36728:XY-2454825450",
	"34927:3615:52060:39330:40358:40769:7824:41215:48275",
	"34927:3615:52060:39330:39898:163253",
	"34927:3615:52060:39330:39898:163253:XY-1868173255",
	"36728:XY-2454825450:43481:54392",
	--["name"] = "Splintertree Post, Ashenvale",
	["m"] = 63,
	["coord"] = 3144457649,
	["direct"] = "3310:3615:8610:11901:22931:34429:34927:34943:36728",
	["f"] = 0,
	},
	[35141] = {
	"35139:2995",
	"34429:12616:3310",
	"35139:3615",
	"35139:2995:44399",
	"41246:4312:6726",
	"35139:2995:7824",
	"35139:2995:52060:39330:39898",
	"34429:12616:36728:8610",
	"34429:22931:43073:43085:11139",
	"35139:2995:52060:11899",
	"34429:12616",
	"34429:22931:43073:43085:12740",
	"35139:2995:52060",
	"35139:2995:7824:10583",
	"35139:3615:16227",
	"34429:22931",
	"35139:2995:52060:39330:40358",
	"35140:34927",
	"34429:34943",
	"41246:4312:35315",
	"41246:4312:35478",
	"41246:4312:35478:35556",
	"41246:4312:35315:35562",
	"35139:2995:7824:39175",
	"35139:2995:39340",
	"35139:2995:52060:39330",
	"35139:2995:40809",
	"35139:3615:40558",
	"35139:2995:52060:39330:40358:40769",
	"35139:2995:7824:41215",
	"34429:12616:3310:41140:41142",
	"34429:12616:3310:41140",
	"35139:2995:7824:41214",
	"34429:12616:36728:XY-2454825450:43481",
	"34429:12616:36728:XY-2454825450:43481:41860",
	"34429:12616:36728:XY-2454825450:43481:41861",
	"41246:4312:6726:40473",
	"41246:4312:6726:40473:41605",
	"34429:22931:43073",
	"34429:22931:43079",
	"34429:22931:43073:43085",
	"34429:12616:36728:8610:37005",
	"34429:12616:36728:8610:43328",
	"34429:12616:36728:XY-2454825450",
	"41246:4312:6726:40473:41605:163253:48275",
	"41246:4312:6726:40473:41605:163253",
	"41246:4312:6726:40473:41605:163253:XY-1868173255",
	"34429:12616:36728",
	"34429:12616:36728:XY-2454825450:43481:54392",
	--["name"] = "Cliffwalker Post, Stonetalon Mountains",
	["m"] = 65,
	["coord"] = 1936477991,
	["direct"] = "4312:11901:34429:35140:35139:41246",
	["f"] = 0,
	},
	[39175] = {
	"7824:2995",
	"7824:16227:3310",
	"7824:3615",
	"41605:40473:6726:35478:4312",
	"39898:44399",
	"41605:40473:6726",
	"7824:16227:3310:8610",
	"7824:16227:3310:11139",
	"7824:40769:40358:11899",
	"7824:3615:34927:34429:11901",
	"7824:3615:34927:12616",
	"7824:16227:3310:XY-2454825450:43481:41861:12740",
	"7824:40769:40358:11899:52060",
	"7824:16227",
	"7824:3615:34927:12616:22931",
	"7824:40769:40358",
	"7824:3615:34927:34429",
	"7824:3615:34927",
	"7824:3615:34927:34943",
	"41605:40473:6726:35478:4312:35141",
	"7824:2995:35139:35140",
	"7824:2995:35139",
	"41605:40473:6726:35315",
	"41605:40473:6726:35478",
	"41605:40473:6726:35478:35556",
	"41605:40473:6726:35315:35562",
	"7824:40769:40358:11899:52060:39340",
	"7824:40769:40358:39330",
	"7824:2995:40809",
	"7824:3615:40558",
	"7824:40769",
	"7824:41215",
	"7824:16227:3310:41140:41142",
	"7824:16227:3310:41140",
	"7824:41214",
	"41605:40473:6726:35478:4312:41246",
	"7824:16227:3310:XY-2454825450:43481",
	"7824:16227:3310:XY-2454825450:43481:41860",
	"7824:16227:3310:XY-2454825450:43481:41861",
	"41605:40473",
	"7824:3615:34927:12616:22931:43073",
	"7824:3615:34927:12616:22931:43079",
	"7824:3615:34927:12616:22931:43073:43085",
	"7824:16227:3310:37005",
	"7824:16227:3310:8610:43328",
	"7824:16227:3310:XY-2454825450",
	"163253:48275",
	"163253:XY-1868173255",
	"7824:16227:3310:36728",
	"7824:16227:3310:XY-2454825450:43481:54392",
	--["name"] = "Mossy Pile, Un'Goro Crater",
	["m"] = 78,
	["f"] = 0,
	["direct"] = "7824:39898:10583:41605:163253",
	["coord"] = 1890412268,
	},
	[43085] = {
	"43073:22931:34429:4312:35139:2995",
	"43073:22931:12616:3310",
	"43073:22931:12616:34927:3615",
	"43073:22931:34429:4312",
	"43073:22931:12616:34927:3615:44399",
	"43073:22931:34429:4312:6726",
	"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824",
	"43073:22931:12616:34927:3615:52060:39330:39898",
	"11139:8610",
	"43073:22931:12616:34927:3615:52060:11899",
	"43073:22931:34429:11901",
	"43073:22931:12616",
	"43073:22931:12616:34927:3615:52060",
	"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:10583",
	"43073:22931:12616:34927:3615:16227",
	"43073:22931",
	"43073:22931:12616:34927:3615:52060:39330:40358",
	"43073:22931:34429",
	"43073:22931:12616:34927",
	"43073:22931:34429:34943",
	"43073:22931:34429:35141",
	"43073:22931:34429:34943:35140",
	"43073:22931:34429:4312:35139",
	"43073:22931:34429:4312:35315",
	"43073:22931:34429:4312:35478",
	"43073:22931:34429:4312:35478:35556",
	"43073:22931:34429:4312:35315:35562",
	"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:39175",
	"43073:22931:12616:34927:3615:39340",
	"43073:22931:12616:34927:3615:52060:39330",
	"43073:22931:34429:4312:35139:2995:40809",
	"43073:22931:12616:34927:40558",
	"43073:22931:12616:34927:3615:52060:39330:40358:40769",
	"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:41215",
	"43073:22931:12616:3310:41140:41142",
	"43073:22931:12616:3310:41140",
	"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:41214",
	"43073:22931:34429:35141:41246",
	"12740:41861:43481",
	"12740:41861:41860",
	"12740:41861",
	"43073:22931:34429:4312:6726:40473",
	"43073:22931:12616:34927:3615:52060:39330:39898:41605",
	"43073:43079",
	"11139:8610:37005",
	"11139:8610:43328",
	"12740:41861:43481:XY-2454825450",
	"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:41215:48275",
	"43073:22931:12616:34927:3615:52060:39330:39898:163253",
	"43073:22931:12616:34927:3615:52060:39330:39898:163253:XY-1868173255",
	"43073:22931:12616:36728",
	"12740:41861:43481:54392",
	--["name"] = "Irontree Clearing, Felwood",
	["m"] = 77,
	["coord"] = 2419856890,
	["direct"] = "11139:12740:43073",
	["f"] = 0,
	},
	[11139] = {
	"8610:2995",
	"8610:3310:3615",
	"43085:43073:22931:34429:4312",
	"8610:3310:3615:44399",
	"43085:43073:22931:34429:4312:6726",
	"8610:3310:7824",
	"8610:3310:3615:52060:39330:39898",
	"8610:3310:16227:11899",
	"43085:43073:22931:34429:11901",
	"8610:12616",
	"8610:3310:3615:52060",
	"8610:3310:7824:10583",
	"8610:3310:16227",
	"43085:43073:22931",
	"8610:3310:16227:11899:40358",
	"43085:43073:22931:34429",
	"8610:12616:34927",
	"8610:12616:34943",
	"43085:43073:22931:34429:35141",
	"8610:12616:34943:35140",
	"8610:3310:3615:35139",
	"43085:43073:22931:34429:4312:35315",
	"43085:43073:22931:34429:4312:35478",
	"8610:2995:35556",
	"43085:43073:22931:34429:4312:35315:35562",
	"8610:3310:7824:39175",
	"8610:3310:3615:39340",
	"8610:3310:3615:52060:39330",
	"8610:2995:40809",
	"8610:3310:40558",
	"8610:3310:16227:11899:40358:40769",
	"8610:3310:7824:41215",
	"8610:3310:41140:41142",
	"8610:3310:41140",
	"8610:3310:7824:41214",
	"43085:43073:22931:34429:35141:41246",
	"41861:43481",
	"41861:41860",
	"43085:43073:22931:34429:4312:6726:40473",
	"8610:3310:3615:52060:39330:39898:41605",
	"43085:43073",
	"43085:43073:43079",
	"8610:37005",
	"8610:43328",
	"41861:43481:XY-2454825450",
	"8610:3310:7824:41215:48275",
	"8610:3310:3615:52060:39330:39898:163253",
	"8610:3310:3615:52060:39330:39898:163253:XY-1868173255",
	"8610:36728",
	"41861:43481:54392",
	--["name"] = "Everlook, Winterspring",
	["m"] = 83,
	["coord"] = 2527689643,
	["direct"] = "3310:8610:12740:41861:43085",
	["f"] = 0,
	},
	[41140] = {
	"3310:3615:2995",
	"3310:3615",
	"3310:3615:4312",
	"3310:3615:44399",
	"3310:3615:2995:6726",
	"3310:7824",
	"3310:3615:52060:39330:39898",
	"3310:8610",
	"3310:11139",
	"3310:16227:11899",
	"3310:12616:34429:11901",
	"3310:12616",
	"3310:XY-2454825450:43481:41861:12740",
	"3310:3615:52060",
	"3310:7824:10583",
	"3310:16227",
	"3310:12616:22931",
	"3310:16227:11899:40358",
	"3310:12616:34429",
	"3310:34927",
	"3310:12616:34943",
	"3310:12616:34429:35141",
	"3310:12616:34943:35140",
	"3310:3615:35139",
	"3310:3615:2995:35556:35562:35315",
	"3310:3615:2995:35556:35478",
	"3310:3615:2995:35556",
	"3310:3615:2995:35556:35562",
	"3310:7824:39175",
	"3310:3615:39340",
	"3310:3615:52060:39330",
	"3310:3615:2995:40809",
	"3310:40558",
	"3310:16227:11899:40358:40769",
	"3310:7824:41215",
	"3310:7824:41214",
	"3310:12616:34943:35140:41246",
	"3310:XY-2454825450:43481",
	"3310:XY-2454825450:43481:41860",
	"3310:XY-2454825450:43481:41861",
	"3310:3615:2995:6726:40473",
	"3310:3615:52060:39330:39898:41605",
	"3310:12616:22931:43073",
	"3310:12616:22931:43079",
	"3310:12616:22931:43073:43085",
	"3310:37005",
	"3310:8610:43328",
	"3310:XY-2454825450",
	"3310:7824:41215:48275",
	"3310:3615:52060:39330:39898:163253",
	"3310:3615:52060:39330:39898:163253:XY-1868173255",
	"3310:36728",
	"3310:XY-2454825450:43481:54392",
	--["name"] = "Razor Hill, Durotar",
	["m"] = 1,
	["coord"] = 2281140122,
	["direct"] = "3310:41142",
	["f"] = 0,
	},
	[41142] = {
	--["name"] = "Sen'jin Village, Durotar",
	},
	[7824] = {
	"2995:35139:4312",
	"39898:41605:40473:6726",
	"16227:3310:8610",
	"16227:3310:11139",
	"3615:34927:34429:11901",
	"3615:34927:12616",
	"16227:3310:XY-2454825450:43481:41861:12740",
	"40769:40358:11899:52060",
	"3615:34927:12616:22931",
	"40769:40358",
	"3615:34927:34429",
	"3615:34927",
	"3615:34927:34943",
	"2995:35139:35141",
	"2995:35139:35140",
	"2995:35139",
	"2995:35556:35562:35315",
	"2995:35556:35478",
	"2995:35556",
	"2995:35556:35562",
	"40769:40358:11899:52060:39340",
	"40769:40358:39330",
	"2995:40809",
	"3615:40558",
	"16227:3310:41140:41142",
	"16227:3310:41140",
	"2995:35139:4312:41246",
	"16227:3310:XY-2454825450:43481",
	"16227:3310:XY-2454825450:43481:41860",
	"16227:3310:XY-2454825450:43481:41861",
	"39898:41605:40473",
	"39898:41605",
	"3615:34927:12616:22931:43073",
	"3615:34927:12616:22931:43079",
	"3615:34927:12616:22931:43073:43085",
	"16227:3310:37005",
	"16227:3310:8610:43328",
	"16227:3310:XY-2454825450",
	"41215:48275",
	"39175:163253",
	"41215:48275:XY-1868173255",
	"16227:3310:36728",
	"16227:3310:XY-2454825450:43481:54392",
	--["name"] = "Gadgetzan, Tanaris",
	["m"] = 71,
	["f"] = 0,
	["direct"] = "2995:3310:3615:44399:39898:11899:10583:16227:39175:40769:41215:41214",
	["coord"] = 2234664604,
	},
	[35478] = {
	"35556:2995",
	"35556:2995:3310",
	"35556:2995:3615",
	"35556:2995:44399",
	"35556:2995:7824",
	"6726:39898",
	"35556:2995:8610",
	"35556:2995:8610:11139",
	"35556:2995:52060:11899",
	"4312:11901",
	"4312:35140:34943:12616",
	"4312:34429:22931:43073:43085:12740",
	"35556:2995:52060",
	"6726:40473:41605:39175:10583",
	"35556:2995:3615:16227",
	"4312:34429:22931",
	"35556:2995:52060:39330:40358",
	"4312:34429",
	"35556:2995:3615:34927",
	"4312:35140:34943",
	"4312:35141",
	"4312:35140",
	"35556:2995:35139",
	"6726:40473:41605:39175",
	"35556:2995:39340",
	"35556:2995:52060:39330",
	"35556:2995:40809",
	"35556:2995:3615:40558",
	"35556:2995:52060:39330:40358:40769",
	"35556:2995:7824:41215",
	"35556:2995:3310:41140:41142",
	"35556:2995:3310:41140",
	"35556:2995:7824:41214",
	"4312:41246",
	"35556:2995:3310:XY-2454825450:43481",
	"35556:2995:3310:XY-2454825450:43481:41860",
	"35556:2995:3310:XY-2454825450:43481:41861",
	"6726:40473",
	"6726:40473:41605",
	"4312:34429:22931:43073",
	"4312:34429:22931:43079",
	"4312:34429:22931:43073:43085",
	"35556:2995:3310:37005",
	"35556:2995:8610:43328",
	"35556:2995:3310:XY-2454825450",
	"6726:40473:41605:163253:48275",
	"6726:40473:41605:163253",
	"6726:40473:41605:163253:XY-1868173255",
	"4312:35140:34943:12616:36728",
	"35556:2995:3310:XY-2454825450:43481:54392",
	--["name"] = "Karnum's Glade, Desolace",
	["m"] = 66,
	["coord"] = 2479390534,
	["direct"] = "4312:6726:35315:35556:35562",
	["f"] = 0,
	},
	[4312] = {
	"3615:3310",
	"35139:2995:44399",
	"35139:2995:7824",
	"35139:2995:52060:39330:39898",
	"35140:34943:12616:36728:8610",
	"34429:22931:43073:43085:11139",
	"35139:2995:52060:11899",
	"35140:34943:12616",
	"34429:22931:43073:43085:12740",
	"35139:2995:52060",
	"35139:2995:7824:10583",
	"3615:16227",
	"34429:22931",
	"35139:2995:52060:39330:40358",
	"35140:34927",
	"35140:34943",
	"35478:35556",
	"35315:35562",
	"6726:40473:41605:39175",
	"35139:2995:39340",
	"35139:2995:52060:39330",
	"35139:2995:40809",
	"3615:40558",
	"35139:2995:52060:39330:40358:40769",
	"35139:2995:7824:41215",
	"3615:3310:41140:41142",
	"3615:3310:41140",
	"35139:2995:7824:41214",
	"35140:34943:12616:36728:XY-2454825450:43481",
	"35140:34943:12616:36728:XY-2454825450:43481:41860",
	"35140:34943:12616:36728:XY-2454825450:43481:41861",
	"6726:40473",
	"6726:40473:41605",
	"34429:22931:43073",
	"34429:22931:43079",
	"34429:22931:43073:43085",
	"35140:34943:12616:36728:8610:37005",
	"35140:34943:12616:36728:8610:43328",
	"35140:34943:12616:36728:XY-2454825450",
	"6726:40473:41605:163253:48275",
	"6726:40473:41605:163253",
	"6726:40473:41605:163253:XY-1868173255",
	"35140:34943:12616:36728",
	"35140:34943:12616:36728:XY-2454825450:43481:54392",
	--["name"] = "Sun Rock Retreat, Stonetalon Mountains",
	["m"] = 65,
	["coord"] = 2082905737,
	["direct"] = "2995:3615:6726:11901:34429:35141:35140:35139:35315:35478:41246",
	["f"] = 0,
	},
	[41215] = {
	"7824:2995",
	"7824:16227:3310",
	"7824:3615",
	"7824:2995:35139:4312",
	"7824:44399",
	"48275:163253:41605:40473:6726",
	"7824:39898",
	"7824:16227:3310:8610",
	"7824:16227:3310:11139",
	"7824:40769:40358:11899",
	"7824:3615:34927:34429:11901",
	"7824:3615:34927:12616",
	"7824:16227:3310:XY-2454825450:43481:41861:12740",
	"7824:40769:40358:11899:52060",
	"7824:10583",
	"7824:16227",
	"7824:3615:34927:12616:22931",
	"7824:40769:40358",
	"7824:3615:34927:34429",
	"7824:3615:34927",
	"7824:3615:34927:34943",
	"7824:2995:35139:35141",
	"7824:2995:35139:35140",
	"7824:2995:35139",
	"48275:163253:41605:40473:6726:35315",
	"48275:163253:41605:40473:6726:35478",
	"7824:2995:35556",
	"7824:2995:35556:35562",
	"7824:39175",
	"7824:40769:40358:11899:52060:39340",
	"7824:40769:40358:39330",
	"7824:2995:40809",
	"7824:3615:40558",
	"7824:40769",
	"7824:16227:3310:41140:41142",
	"7824:16227:3310:41140",
	"7824:2995:35139:4312:41246",
	"7824:16227:3310:XY-2454825450:43481",
	"7824:16227:3310:XY-2454825450:43481:41860",
	"7824:16227:3310:XY-2454825450:43481:41861",
	"48275:163253:41605:40473",
	"48275:163253:41605",
	"7824:3615:34927:12616:22931:43073",
	"7824:3615:34927:12616:22931:43079",
	"7824:3615:34927:12616:22931:43073:43085",
	"7824:16227:3310:37005",
	"7824:16227:3310:8610:43328",
	"7824:16227:3310:XY-2454825450",
	"48275:163253",
	"48275:XY-1868173255",
	"7824:16227:3310:36728",
	"7824:16227:3310:XY-2454825450:43481:54392",
	--["name"] = "Dawnrise Expedition, Tanaris",
	["m"] = 71,
	["f"] = 0,
	["direct"] = "7824:41214:48275",
	["coord"] = 1431487987,
	},
	[11899] = {
	"52060:3615:4312",
	"52060:2995:6726",
	"39330:39898",
	"16227:3310:8610",
	"16227:3310:11139",
	"52060:3615:34927:34429:11901",
	"52060:3615:34927:12616",
	"52060:3615:34927:12616:22931:43073:43085:12740",
	"40358:40769:7824:10583",
	"52060:3615:34927:12616:22931",
	"52060:3615:34927:34429",
	"52060:3615:34927",
	"52060:3615:34927:34943",
	"52060:3615:4312:35141",
	"52060:2995:35139:35140",
	"52060:2995:35139",
	"52060:2995:35556:35562:35315",
	"52060:2995:35556:35478",
	"52060:2995:35556",
	"52060:2995:35556:35562",
	"40358:40769:7824:39175",
	"52060:39340",
	"52060:2995:40809",
	"52060:3615:40558",
	"40358:40769",
	"40358:40769:7824:41215",
	"16227:3310:41140:41142",
	"16227:3310:41140",
	"40358:40769:7824:41214",
	"52060:3615:4312:41246",
	"16227:3310:XY-2454825450:43481",
	"16227:3310:XY-2454825450:43481:41860",
	"16227:3310:XY-2454825450:43481:41861",
	"39330:39898:41605:40473",
	"39330:39898:41605",
	"52060:3615:34927:12616:22931:43073",
	"52060:3615:34927:12616:22931:43079",
	"52060:3615:34927:12616:22931:43073:43085",
	"16227:3310:37005",
	"16227:3310:8610:43328",
	"16227:3310:XY-2454825450",
	"40358:40769:7824:41215:48275",
	"39330:39898:163253",
	"39330:39898:163253:XY-1868173255",
	"16227:3310:36728",
	"16227:3310:XY-2454825450:43481:54392",
	--["name"] = "Brackenwall Village, Dustwallow Marsh",
	["m"] = 70,
	["f"] = 0,
	["direct"] = "2995:3310:3615:44399:7824:52060:16227:40358:39330",
	["coord"] = 1526878590,
	},
	[48275] = {
	"41215:7824:2995",
	"41215:7824:16227:3310",
	"41215:7824:3615",
	"163253:41605:40473:6726:35478:4312",
	"163253:39898:44399",
	"163253:41605:40473:6726",
	"41215:7824",
	"163253:39898",
	"41215:7824:16227:3310:8610",
	"41215:7824:16227:3310:11139",
	"41215:7824:40769:40358:11899",
	"163253:41605:40473:6726:35478:4312:11901",
	"41215:7824:3615:34927:12616",
	"41215:7824:16227:3310:XY-2454825450:43481:41861:12740",
	"163253:39898:39330:52060",
	"163253:39175:10583",
	"41215:7824:16227",
	"41215:7824:3615:34927:12616:22931",
	"41215:7824:40769:40358",
	"41215:7824:3615:34927:34429",
	"41215:7824:3615:34927",
	"41215:7824:3615:34927:34943",
	"163253:41605:40473:6726:35478:4312:35141",
	"163253:41605:40473:6726:35478:4312:35140",
	"41215:7824:2995:35139",
	"163253:41605:40473:6726:35315",
	"163253:41605:40473:6726:35478",
	"163253:41605:40473:6726:35478:35556",
	"163253:41605:40473:6726:35315:35562",
	"163253:39175",
	"163253:39898:39330:39340",
	"163253:39898:39330",
	"41215:7824:2995:40809",
	"41215:7824:3615:40558",
	"41215:7824:40769",
	"41215:7824:16227:3310:41140:41142",
	"41215:7824:16227:3310:41140",
	"41215:41214",
	"163253:41605:40473:6726:35478:4312:41246",
	"41215:7824:16227:3310:XY-2454825450:43481",
	"41215:7824:16227:3310:XY-2454825450:43481:41860",
	"41215:7824:16227:3310:XY-2454825450:43481:41861",
	"163253:41605:40473",
	"163253:41605",
	"41215:7824:3615:34927:12616:22931:43073",
	"41215:7824:3615:34927:12616:22931:43079",
	"41215:7824:3615:34927:12616:22931:43073:43085",
	"41215:7824:16227:3310:37005",
	"41215:7824:16227:3310:8610:43328",
	"41215:7824:16227:3310:XY-2454825450",
	"41215:7824:16227:3310:36728",
	"41215:7824:16227:3310:XY-2454825450:43481:54392",
	["direct"] = "41215:163253:XY-1868173255",
	["f"] = 0,
	["m"] = 1527,
	["coord"] = 2414695966,
	},
	[39898] = {
	"44399:11899:16227:3310",
	"41605:40473:6726:35478:4312",
	"39330:52060:3615:8610",
	"44399:11899:16227:3310:11139",
	"44399:11899",
	"39330:52060:3615:34927:34429:11901",
	"39330:52060:3615:34927:12616",
	"39330:52060:3615:34927:12616:22931:43073:43085:12740",
	"39330:52060",
	"39175:10583",
	"44399:11899:16227",
	"39330:52060:3615:34927:12616:22931",
	"44399:40358",
	"39330:52060:3615:34927:34429",
	"39330:52060:3615:34927",
	"39330:52060:3615:34927:34943",
	"41605:40473:6726:35478:4312:35141",
	"44399:2995:35139:35140",
	"44399:2995:35139",
	"41605:40473:6726:35478",
	"41605:40473:6726:35478:35556",
	"35315:35562",
	"39330:39340",
	"44399:2995:40809",
	"39330:52060:3615:40558",
	"44399:40769",
	"44399:40769:7824:41215",
	"44399:11899:16227:3310:41140:41142",
	"44399:11899:16227:3310:41140",
	"44399:40769:7824:41214",
	"41605:40473:6726:35478:4312:41246",
	"44399:11899:16227:3310:XY-2454825450:43481",
	"44399:11899:16227:3310:XY-2454825450:43481:41860",
	"44399:11899:16227:3310:XY-2454825450:43481:41861",
	"41605:40473",
	"39330:52060:3615:34927:12616:22931:43073",
	"39330:52060:3615:34927:12616:22931:43079",
	"39330:52060:3615:34927:12616:22931:43073:43085",
	"44399:11899:16227:3310:37005",
	"39330:52060:3615:8610:43328",
	"44399:11899:16227:3310:XY-2454825450",
	"163253:48275",
	"163253:XY-1868173255",
	"39330:52060:3615:34927:12616:36728",
	"44399:11899:16227:3310:XY-2454825450:43481:54392",
	--["name"] = "Camp Mojache, Feralas",
	["m"] = 69,
	["coord"] = 3239670129,
	["direct"] = "2995:3615:44399:6726:7824:35315:39175:39330:41605:163253",
	["f"] = 0,
	},
	[163253] = {
	"39898:44399:2995",
	"39898:44399:11899:16227:3310",
	"39898:39330:52060:3615",
	"41605:40473:6726:35478:4312",
	"39898:44399",
	"41605:40473:6726",
	"39175:7824",
	"39898:39330:52060:3615:8610",
	"39898:44399:11899:16227:3310:11139",
	"39898:44399:11899",
	"41605:40473:6726:35478:4312:11901",
	"39898:39330:52060:3615:34927:12616",
	"39898:39330:52060:3615:34927:12616:22931:43073:43085:12740",
	"39898:39330:52060",
	"39175:10583",
	"39898:44399:11899:16227",
	"39898:39330:52060:3615:34927:12616:22931",
	"39898:44399:40358",
	"39898:39330:52060:3615:34927:34429",
	"39898:39330:52060:3615:34927",
	"39898:39330:52060:3615:34927:34943",
	"41605:40473:6726:35478:4312:35141",
	"41605:40473:6726:35478:4312:35140",
	"41605:40473:6726:35139",
	"41605:40473:6726:35315",
	"41605:40473:6726:35478",
	"41605:40473:6726:35478:35556",
	"41605:40473:6726:35315:35562",
	"39898:39330:39340",
	"39898:39330",
	"39898:44399:2995:40809",
	"39898:39330:52060:3615:40558",
	"39175:7824:40769",
	"48275:41215",
	"39898:44399:11899:16227:3310:41140:41142",
	"39898:44399:11899:16227:3310:41140",
	"48275:41215:41214",
	"41605:40473:6726:35478:4312:41246",
	"39898:44399:11899:16227:3310:XY-2454825450:43481",
	"39898:44399:11899:16227:3310:XY-2454825450:43481:41860",
	"39898:44399:11899:16227:3310:XY-2454825450:43481:41861",
	"41605:40473",
	"39898:39330:52060:3615:34927:12616:22931:43073",
	"39898:39330:52060:3615:34927:12616:22931:43079",
	"39898:39330:52060:3615:34927:12616:22931:43073:43085",
	"39898:44399:11899:16227:3310:37005",
	"39898:39330:52060:3615:8610:43328",
	"39898:44399:11899:16227:3310:XY-2454825450",
	"39898:39330:52060:3615:34927:12616:36728",
	"39898:44399:11899:16227:3310:XY-2454825450:43481:54392",
	--["name"] = "Oasis of Vir'sar, Uldum",
	["m"] = 1527,
	["f"] = 0,
	["direct"] = "39898:39175:41605:48275:XY-1868173255",
	["coord"] = 1141183829,
	},
	[11901] = {
	"12616:3310",
	"35141:35139:2995:44399",
	"4312:6726",
	"35141:35139:2995:7824",
	"35141:35139:2995:52060:39330:39898",
	"12616:36728:8610",
	"22931:43073:43085:11139",
	"35141:35139:2995:52060:11899",
	"22931:43073:43085:12740",
	"35141:35139:2995:52060",
	"35141:35139:2995:7824:10583",
	"3615:16227",
	"35141:35139:2995:52060:39330:40358",
	"34429:34943:34927",
	"34429:34943",
	"35141:35140",
	"35141:35139",
	"4312:35315",
	"4312:35478",
	"4312:35478:35556",
	"4312:35315:35562",
	"4312:6726:40473:41605:39175",
	"35141:35139:2995:39340",
	"35141:35139:2995:52060:39330",
	"35141:35139:2995:40809",
	"34429:34943:34927:40558",
	"35141:35139:2995:52060:39330:40358:40769",
	"35141:35139:2995:7824:41215",
	"12616:3310:41140:41142",
	"12616:3310:41140",
	"35141:35139:2995:7824:41214",
	"35141:41246",
	"12616:36728:XY-2454825450:43481",
	"12616:36728:XY-2454825450:43481:41860",
	"12616:36728:XY-2454825450:43481:41861",
	"4312:6726:40473",
	"4312:6726:40473:41605",
	"22931:43073",
	"22931:43079",
	"22931:43073:43085",
	"12616:36728:8610:37005",
	"12616:36728:8610:43328",
	"12616:36728:XY-2454825450",
	"4312:6726:40473:41605:163253:48275",
	"4312:6726:40473:41605:163253",
	"4312:6726:40473:41605:163253:XY-1868173255",
	"12616:36728",
	"12616:36728:XY-2454825450:43481:54392",
	--["name"] = "Zoram'gar Outpost, Ashenvale",
	["m"] = 63,
	["coord"] = 481712160,
	["direct"] = "2995:3615:4312:12616:22931:34429:35141",
	["f"] = 0,
	},
	[34927] = {
	"3615:2995",
	"35140:4312",
	"3615:44399",
	"3615:2995:6726",
	"3615:52060:39330:40358:40769:7824",
	"3615:52060:39330:39898",
	"12616:36728:8610",
	"12616:36728:8610:11139",
	"3615:52060:11899",
	"34429:11901",
	"12616:22931:43073:43085:12740",
	"3615:52060",
	"3615:52060:39330:40358:40769:7824:10583",
	"3615:16227",
	"12616:22931",
	"3615:52060:39330:40358",
	"34429:35141",
	"3615:35139",
	"35140:4312:35315",
	"3615:2995:35556:35478",
	"3615:2995:35556",
	"3615:2995:35556:35562",
	"3615:52060:39330:40358:40769:7824:39175",
	"3615:39340",
	"3615:52060:39330",
	"3615:2995:40809",
	"3615:52060:39330:40358:40769",
	"3615:52060:39330:40358:40769:7824:41215",
	"3310:41140:41142",
	"3310:41140",
	"3615:52060:39330:40358:40769:7824:41214",
	"35140:41246",
	"12616:36728:XY-2454825450:43481",
	"12616:36728:XY-2454825450:43481:41860",
	"12616:36728:XY-2454825450:43481:41861",
	"3615:2995:6726:40473",
	"3615:52060:39330:39898:41605",
	"12616:22931:43073",
	"12616:22931:43079",
	"12616:22931:43073:43085",
	"3310:37005",
	"12616:36728:8610:43328",
	"12616:36728:XY-2454825450",
	"3615:52060:39330:40358:40769:7824:41215:48275",
	"3615:52060:39330:39898:163253",
	"3615:52060:39330:39898:163253:XY-1868173255",
	"12616:36728",
	"12616:36728:XY-2454825450:43481:54392",
	--["name"] = "The Mor'Shan Ramparts, Ashenvale",
	["m"] = 10,
	["coord"] = 1802381409,
	["direct"] = "3310:3615:12616:34429:34943:35140:40558",
	["f"] = 0,
	},
	[40473] = {
	"6726:35478:35556:2995",
	"6726:35478:35556:2995:3310",
	"6726:35139:3615",
	"6726:35478:4312",
	"41605:39898:44399",
	"41605:39898:44399:40769:7824",
	"41605:39898",
	"6726:35478:35556:2995:8610",
	"6726:35478:35556:2995:8610:11139",
	"41605:39898:44399:11899",
	"6726:35478:4312:11901",
	"6726:35478:4312:35140:34943:12616",
	"6726:35478:4312:34429:22931:43073:43085:12740",
	"41605:39898:39330:52060",
	"41605:39175:10583",
	"6726:35139:3615:16227",
	"6726:35478:4312:34429:22931",
	"41605:39898:44399:40358",
	"6726:35478:4312:34429",
	"6726:35139:3615:34927",
	"6726:35478:4312:35140:34943",
	"6726:35478:4312:35141",
	"6726:35478:4312:35140",
	"6726:35139",
	"6726:35315",
	"6726:35478",
	"6726:35478:35556",
	"6726:35315:35562",
	"41605:39175",
	"6726:35478:35556:2995:39340",
	"41605:39898:39330",
	"6726:35478:35556:2995:40809",
	"6726:35139:3615:40558",
	"41605:39898:44399:40769",
	"41605:163253:48275:41215",
	"6726:35478:35556:2995:3310:41140:41142",
	"6726:35478:35556:2995:3310:41140",
	"41605:39898:44399:40769:7824:41214",
	"6726:35478:4312:41246",
	"6726:35478:35556:2995:3310:XY-2454825450:43481",
	"6726:35478:35556:2995:3310:XY-2454825450:43481:41860",
	"6726:35478:35556:2995:3310:XY-2454825450:43481:41861",
	"6726:35478:4312:34429:22931:43073",
	"6726:35478:4312:34429:22931:43079",
	"6726:35478:4312:34429:22931:43073:43085",
	"6726:35478:35556:2995:3310:37005",
	"6726:35478:35556:2995:8610:43328",
	"6726:35478:35556:2995:3310:XY-2454825450",
	"41605:163253:48275",
	"41605:163253",
	"41605:163253:XY-1868173255",
	"6726:35478:4312:35140:34943:12616:36728",
	"6726:35478:35556:2995:3310:XY-2454825450:43481:54392",
	--["name"] = "Camp Ataya, Feralas",
	["m"] = 69,
	["coord"] = 1780754305,
	["direct"] = "6726:41605",
	["f"] = 0,
	},
	[41861] = {
	"43481:XY-2454825450:3310:3615:2995",
	"43481:XY-2454825450:3310",
	"43481:XY-2454825450:3310:3615",
	"43481:XY-2454825450:36728:12616:34943:35140:4312",
	"43481:XY-2454825450:3310:3615:44399",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:6726",
	"43481:XY-2454825450:3310:7824",
	"43481:XY-2454825450:3310:3615:52060:39330:39898",
	"43481:XY-2454825450:36728:8610",
	"43481:XY-2454825450:3310:16227:11899",
	"43481:XY-2454825450:36728:12616:34429:11901",
	"43481:XY-2454825450:36728:12616",
	"43481:XY-2454825450:3310:3615:52060",
	"43481:XY-2454825450:3310:7824:10583",
	"43481:XY-2454825450:3310:16227",
	"43481:XY-2454825450:36728:12616:22931",
	"43481:XY-2454825450:3310:16227:11899:40358",
	"43481:XY-2454825450:36728:12616:34429",
	"43481:XY-2454825450:36728:12616:34927",
	"43481:XY-2454825450:36728:12616:34943",
	"43481:XY-2454825450:36728:12616:34429:35141",
	"43481:XY-2454825450:36728:12616:34943:35140",
	"43481:XY-2454825450:36728:12616:34943:35140:35139",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:35315",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:35478",
	"43481:XY-2454825450:3310:3615:2995:35556",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:35315:35562",
	"43481:XY-2454825450:3310:7824:39175",
	"43481:XY-2454825450:3310:3615:39340",
	"43481:XY-2454825450:3310:3615:52060:39330",
	"43481:XY-2454825450:3310:3615:2995:40809",
	"43481:XY-2454825450:3310:40558",
	"43481:XY-2454825450:3310:16227:11899:40358:40769",
	"43481:XY-2454825450:3310:7824:41215",
	"43481:XY-2454825450:3310:41140:41142",
	"43481:XY-2454825450:3310:41140",
	"43481:XY-2454825450:3310:7824:41214",
	"43481:XY-2454825450:36728:12616:34943:35140:41246",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:6726:40473",
	"43481:XY-2454825450:3310:3615:52060:39330:39898:41605",
	"12740:43085:43073",
	"12740:43085:43073:43079",
	"12740:43085",
	"43481:XY-2454825450:36728:8610:37005",
	"43481:XY-2454825450:36728:8610:43328",
	"43481:XY-2454825450",
	"43481:XY-2454825450:3310:7824:41215:48275",
	"43481:XY-2454825450:3310:3615:52060:39330:39898:163253",
	"43481:XY-2454825450:3310:3615:52060:39330:39898:163253:XY-1868173255",
	"43481:XY-2454825450:36728",
	"43481:54392",
	--["name"] = "Nordrassil, Hyjal",
	["m"] = 198,
	["coord"] = 2668771124,
	["direct"] = "11139:12740:43481:41860",
	["f"] = 0,
	},
	[34429] = {
	"4312:35139:2995",
	"12616:3310",
	"34943:34927:3615",
	"34943:34927:3615:44399",
	"4312:6726",
	"34943:34927:3615:52060:39330:40358:40769:7824",
	"34943:34927:3615:52060:39330:39898",
	"12616:36728:8610",
	"22931:43073:43085:11139",
	"34943:34927:3615:52060:11899",
	"22931:43073:43085:12740",
	"34943:34927:3615:52060",
	"34943:34927:3615:52060:39330:40358:40769:7824:10583",
	"34943:34927:3615:16227",
	"34943:34927:3615:52060:39330:40358",
	"34943:35140",
	"4312:35139",
	"4312:35315",
	"4312:35478",
	"4312:35478:35556",
	"4312:35315:35562",
	"34943:34927:3615:52060:39330:40358:40769:7824:39175",
	"34943:34927:3615:39340",
	"34943:34927:3615:52060:39330",
	"4312:35139:2995:40809",
	"34943:34927:40558",
	"34943:34927:3615:52060:39330:40358:40769",
	"34943:34927:3615:52060:39330:40358:40769:7824:41215",
	"12616:3310:41140:41142",
	"12616:3310:41140",
	"34943:34927:3615:52060:39330:40358:40769:7824:41214",
	"35141:41246",
	"12616:36728:XY-2454825450:43481",
	"12616:36728:XY-2454825450:43481:41860",
	"12616:36728:XY-2454825450:43481:41861",
	"4312:6726:40473",
	"4312:6726:40473:41605",
	"22931:43073",
	"22931:43079",
	"22931:43073:43085",
	"12616:36728:8610:37005",
	"12616:36728:8610:43328",
	"12616:36728:XY-2454825450",
	"4312:6726:40473:41605:163253:48275",
	"4312:6726:40473:41605:163253",
	"4312:6726:40473:41605:163253:XY-1868173255",
	"12616:36728",
	"12616:36728:XY-2454825450:43481:54392",
	--["name"] = "Hellscream's Watch, Ashenvale",
	["m"] = 63,
	["coord"] = 1636330535,
	["direct"] = "4312:11901:12616:22931:34927:34943:35141",
	["f"] = 0,
	},
	[41605] = {
	"40473:6726:35478:35556:2995",
	"39898:44399:11899:16227:3310",
	"39898:39330:52060:3615",
	"40473:6726:35478:4312",
	"39898:44399",
	"40473:6726",
	"39898:44399:40769:7824",
	"39898:39330:52060:3615:8610",
	"39898:44399:11899:16227:3310:11139",
	"39898:44399:11899",
	"40473:6726:35478:4312:11901",
	"39898:39330:52060:3615:34927:12616",
	"39898:39330:52060:3615:34927:12616:22931:43073:43085:12740",
	"39898:39330:52060",
	"39175:10583",
	"39898:44399:11899:16227",
	"39898:39330:52060:3615:34927:12616:22931",
	"39898:44399:40358",
	"40473:6726:35478:4312:34429",
	"39898:39330:52060:3615:34927",
	"40473:6726:35478:4312:35140:34943",
	"40473:6726:35478:4312:35141",
	"40473:6726:35478:4312:35140",
	"40473:6726:35139",
	"40473:6726:35315",
	"40473:6726:35478",
	"40473:6726:35478:35556",
	"40473:6726:35315:35562",
	"39898:39330:39340",
	"39898:39330",
	"40473:6726:35478:35556:2995:40809",
	"39898:39330:52060:3615:40558",
	"39898:44399:40769",
	"163253:48275:41215",
	"39898:44399:11899:16227:3310:41140:41142",
	"39898:44399:11899:16227:3310:41140",
	"39898:44399:40769:7824:41214",
	"40473:6726:35478:4312:41246",
	"39898:44399:11899:16227:3310:XY-2454825450:43481",
	"39898:44399:11899:16227:3310:XY-2454825450:43481:41860",
	"39898:44399:11899:16227:3310:XY-2454825450:43481:41861",
	"39898:39330:52060:3615:34927:12616:22931:43073",
	"39898:39330:52060:3615:34927:12616:22931:43079",
	"39898:39330:52060:3615:34927:12616:22931:43073:43085",
	"39898:44399:11899:16227:3310:37005",
	"39898:39330:52060:3615:8610:43328",
	"39898:44399:11899:16227:3310:XY-2454825450",
	"163253:48275",
	"163253:XY-1868173255",
	"39898:39330:52060:3615:34927:12616:36728",
	"39898:44399:11899:16227:3310:XY-2454825450:43481:54392",
	--["name"] = "Stonemaul Hold, Feralas",
	["m"] = 69,
	["coord"] = 2189786049,
	["direct"] = "39898:39175:40473:163253",
	["f"] = 0,
	},
	[35315] = {
	"35562:35556:2995",
	"35562:35556:2995:3310",
	"35562:35556:2995:3615",
	"39898:44399",
	"35562:35556:2995:7824",
	"35562:35556:2995:8610",
	"35562:35556:2995:8610:11139",
	"35562:35556:2995:52060:11899",
	"4312:11901",
	"4312:35140:34943:12616",
	"4312:34429:22931:43073:43085:12740",
	"35562:35556:2995:52060",
	"6726:40473:41605:39175:10583",
	"35562:35556:2995:3615:16227",
	"4312:34429:22931",
	"35562:35556:2995:52060:39330:40358",
	"4312:34429",
	"35562:35556:2995:3615:34927",
	"4312:35140:34943",
	"4312:35141",
	"4312:35140",
	"35562:35556:2995:35139",
	"35562:35556",
	"6726:40473:41605:39175",
	"35562:35556:2995:39340",
	"35562:35556:2995:52060:39330",
	"35562:35556:2995:40809",
	"35562:35556:2995:3615:40558",
	"35562:35556:2995:52060:39330:40358:40769",
	"35562:35556:2995:7824:41215",
	"35562:35556:2995:3310:41140:41142",
	"35562:35556:2995:3310:41140",
	"35562:35556:2995:7824:41214",
	"4312:41246",
	"4312:35140:34943:12616:36728:XY-2454825450:43481",
	"4312:35140:34943:12616:36728:XY-2454825450:43481:41860",
	"4312:35140:34943:12616:36728:XY-2454825450:43481:41861",
	"6726:40473",
	"6726:40473:41605",
	"4312:34429:22931:43073",
	"4312:34429:22931:43079",
	"4312:34429:22931:43073:43085",
	"35562:35556:2995:3310:37005",
	"35562:35556:2995:8610:43328",
	"4312:35140:34943:12616:36728:XY-2454825450",
	"6726:40473:41605:163253:48275",
	"6726:40473:41605:163253",
	"6726:40473:41605:163253:XY-1868173255",
	"4312:35140:34943:12616:36728",
	"4312:35140:34943:12616:36728:XY-2454825450:43481:54392",
	--["name"] = "Furien's Post, Desolace",
	["m"] = 66,
	["coord"] = 1900563459,
	["direct"] = "4312:6726:39898:35478:35562",
	["f"] = 0,
	},
	[3615] = {
	"2995:6726",
	"3310:11139",
	"34927:12616:22931:43073:43085:12740",
	"52060:39330:40358:40769:7824:10583",
	"34927:12616:22931",
	"52060:39330:40358",
	"34927:34429",
	"34927:34943",
	"4312:35141",
	"4312:35140",
	"2995:35556:35562:35315",
	"2995:35556:35478",
	"2995:35556",
	"2995:35556:35562",
	"52060:39330:40358:40769:7824:39175",
	"52060:39330",
	"2995:40809",
	"52060:39330:40358:40769",
	"52060:39330:40358:40769:7824:41215",
	"3310:41140:41142",
	"3310:41140",
	"52060:39330:40358:40769:7824:41214",
	"4312:41246",
	"3310:XY-2454825450:43481",
	"3310:XY-2454825450:43481:41860",
	"3310:XY-2454825450:43481:41861",
	"2995:6726:40473",
	"52060:39330:39898:41605",
	"34927:12616:22931:43073",
	"34927:12616:22931:43079",
	"34927:12616:22931:43073:43085",
	"3310:37005",
	"8610:43328",
	"3310:XY-2454825450",
	"52060:39330:40358:40769:7824:41215:48275",
	"52060:39330:39898:163253",
	"52060:39330:39898:163253:XY-1868173255",
	"34927:12616:36728",
	"3310:XY-2454825450:43481:54392",
	--["name"] = "The Crossroads, Northern Barrens",
	["m"] = 10,
	["coord"] = 2091619965,
	["direct"] = "2995:3310:4312:44399:7824:39898:8610:11899:11901:12616:52060:16227:34927:35139:39340:40558",
	["f"] = 0,
	},
	[35140] = {
	"35139:2995",
	"34927:3310",
	"35139:3615",
	"35139:2995:44399",
	"4312:6726",
	"35139:2995:7824",
	"35139:2995:52060:39330:39898",
	"34943:12616:36728:8610",
	"34943:12616:36728:8610:11139",
	"35139:2995:52060:11899",
	"35141:11901",
	"34943:12616",
	"34943:34429:22931:43073:43085:12740",
	"35139:2995:52060",
	"35139:2995:7824:10583",
	"35139:3615:16227",
	"34943:34429:22931",
	"35139:2995:52060:39330:40358",
	"34943:34429",
	"4312:35315",
	"4312:35478",
	"35139:2995:35556",
	"4312:35315:35562",
	"35139:2995:7824:39175",
	"35139:2995:39340",
	"35139:2995:52060:39330",
	"35139:2995:40809",
	"34927:40558",
	"35139:2995:52060:39330:40358:40769",
	"35139:2995:7824:41215",
	"34927:3310:41140:41142",
	"34927:3310:41140",
	"35139:2995:7824:41214",
	"34943:12616:36728:XY-2454825450:43481",
	"34943:12616:36728:XY-2454825450:43481:41860",
	"34943:12616:36728:XY-2454825450:43481:41861",
	"4312:6726:40473",
	"4312:6726:40473:41605",
	"34943:34429:22931:43073",
	"34943:34429:22931:43079",
	"34943:34429:22931:43073:43085",
	"34943:12616:36728:8610:37005",
	"34943:12616:36728:8610:43328",
	"34943:12616:36728:XY-2454825450",
	"4312:6726:40473:41605:163253:48275",
	"4312:6726:40473:41605:163253",
	"4312:6726:40473:41605:163253:XY-1868173255",
	"34943:12616:36728",
	"34943:12616:36728:XY-2454825450:43481:54392",
	--["name"] = "Krom'gar Fortress, Stonetalon Mountains",
	["m"] = 65,
	["coord"] = 2856362169,
	["direct"] = "4312:34927:34943:35141:35139:41246",
	["f"] = 0,
	},
	[34943] = {
	"35140:35139:2995",
	"34927:3310",
	"34927:3615",
	"35140:4312",
	"34927:3615:44399",
	"35140:4312:6726",
	"34927:3615:52060:39330:40358:40769:7824",
	"34927:3615:52060:39330:39898",
	"12616:36728:8610",
	"12616:36728:8610:11139",
	"34927:3615:52060:11899",
	"34429:11901",
	"34429:22931:43073:43085:12740",
	"34927:3615:52060",
	"34927:3615:52060:39330:40358:40769:7824:10583",
	"34927:3615:16227",
	"34429:22931",
	"34927:3615:52060:39330:40358",
	"34429:35141",
	"35140:35139",
	"35140:4312:35315",
	"35140:4312:35478",
	"35140:35139:2995:35556",
	"35140:4312:35315:35562",
	"34927:3615:52060:39330:40358:40769:7824:39175",
	"34927:3615:39340",
	"34927:3615:52060:39330",
	"35140:35139:2995:40809",
	"34927:40558",
	"34927:3615:52060:39330:40358:40769",
	"34927:3615:52060:39330:40358:40769:7824:41215",
	"34927:3310:41140:41142",
	"34927:3310:41140",
	"34927:3615:52060:39330:40358:40769:7824:41214",
	"35140:41246",
	"12616:36728:XY-2454825450:43481",
	"12616:36728:XY-2454825450:43481:41860",
	"12616:36728:XY-2454825450:43481:41861",
	"35140:4312:6726:40473",
	"34927:3615:52060:39330:39898:41605",
	"34429:22931:43073",
	"34429:22931:43079",
	"34429:22931:43073:43085",
	"12616:36728:8610:37005",
	"12616:36728:8610:43328",
	"12616:36728:XY-2454825450",
	"34927:3615:52060:39330:40358:40769:7824:41215:48275",
	"34927:3615:52060:39330:39898:163253",
	"34927:3615:52060:39330:39898:163253:XY-1868173255",
	"12616:36728",
	"12616:36728:XY-2454825450:43481:54392",
	--["name"] = "Silverwind Refuge, Ashenvale",
	["m"] = 63,
	["coord"] = 2118297444,
	["direct"] = "12616:34429:34927:35140",
	["f"] = 0,
	},
	[10583] = {
	"7824:2995",
	"7824:16227:3310",
	"7824:3615",
	"7824:2995:35139:4312",
	"7824:44399",
	"39175:41605:40473:6726",
	"39175:39898",
	"7824:16227:3310:8610",
	"7824:16227:3310:11139",
	"7824:40769:40358:11899",
	"7824:3615:34927:34429:11901",
	"7824:3615:34927:12616",
	"7824:16227:3310:XY-2454825450:43481:41861:12740",
	"7824:40769:40358:11899:52060",
	"7824:16227",
	"7824:3615:34927:12616:22931",
	"7824:40769:40358",
	"7824:3615:34927:34429",
	"7824:3615:34927",
	"7824:3615:34927:34943",
	"7824:2995:35139:35141",
	"7824:2995:35139:35140",
	"7824:2995:35139",
	"39175:41605:40473:6726:35315",
	"39175:41605:40473:6726:35478",
	"7824:2995:35556",
	"39175:41605:40473:6726:35315:35562",
	"7824:40769:40358:11899:52060:39340",
	"7824:40769:40358:39330",
	"7824:2995:40809",
	"7824:3615:40558",
	"7824:40769",
	"7824:41215",
	"7824:16227:3310:41140:41142",
	"7824:16227:3310:41140",
	"7824:41214",
	"7824:2995:35139:4312:41246",
	"7824:16227:3310:XY-2454825450:43481",
	"7824:16227:3310:XY-2454825450:43481:41860",
	"7824:16227:3310:XY-2454825450:43481:41861",
	"39175:41605:40473",
	"39175:41605",
	"7824:3615:34927:12616:22931:43073",
	"7824:3615:34927:12616:22931:43079",
	"7824:3615:34927:12616:22931:43073:43085",
	"7824:16227:3310:37005",
	"7824:16227:3310:8610:43328",
	"7824:16227:3310:XY-2454825450",
	"39175:163253:48275",
	"39175:163253",
	"39175:163253:XY-1868173255",
	"7824:16227:3310:36728",
	"7824:16227:3310:XY-2454825450:43481:54392",
	--["name"] = "Marshal's Stand, Un'Goro Crater",
	["m"] = 78,
	["f"] = 0,
	["direct"] = "7824:39175",
	["coord"] = 2404099104,
	},
	[6726] = {
	"35478:35556:2995:3310",
	"35139:3615",
	"39898:44399",
	"39898:44399:40769:7824",
	"35478:35556:2995:8610",
	"35478:35556:2995:8610:11139",
	"35478:35556:2995:52060:11899",
	"35478:4312:11901",
	"35478:4312:35140:34943:12616",
	"35478:4312:34429:22931:43073:43085:12740",
	"35478:35556:2995:52060",
	"40473:41605:39175:10583",
	"35139:3615:16227",
	"35478:4312:34429:22931",
	"39898:44399:40358",
	"35478:4312:34429",
	"35139:3615:34927",
	"35478:4312:35140:34943",
	"35478:4312:35141",
	"35478:4312:35140",
	"35478:35556",
	"40473:41605:39175",
	"35478:35556:2995:39340",
	"35478:35556:2995:52060:39330",
	"35478:35556:2995:40809",
	"35139:3615:40558",
	"39898:44399:40769",
	"40473:41605:163253:48275:41215",
	"35478:35556:2995:3310:41140:41142",
	"35478:35556:2995:3310:41140",
	"39898:44399:40769:7824:41214",
	"35478:4312:41246",
	"35478:35556:2995:3310:XY-2454825450:43481",
	"35478:35556:2995:3310:XY-2454825450:43481:41860",
	"35478:35556:2995:3310:XY-2454825450:43481:41861",
	"40473:41605",
	"35478:4312:34429:22931:43073",
	"35478:4312:34429:22931:43079",
	"35478:4312:34429:22931:43073:43085",
	"35478:35556:2995:3310:37005",
	"35478:35556:2995:8610:43328",
	"35478:35556:2995:3310:XY-2454825450",
	"40473:41605:163253:48275",
	"40473:41605:163253",
	"40473:41605:163253:XY-1868173255",
	"35478:4312:35140:34943:12616:36728",
	"35478:35556:2995:3310:XY-2454825450:43481:54392",
	--["name"] = "Shadowprey Village, Desolace",
	["m"] = 66,
	["coord"] = 926137739,
	["direct"] = "2995:4312:39898:35139:35315:35478:35562:40473",
	["f"] = 0,
	},
	[43328] = {
	"8610:2995",
	"8610:3310",
	"8610:3310:3615",
	"8610:12616:34943:35140:4312",
	"8610:3310:3615:44399",
	"8610:2995:6726",
	"8610:3310:7824",
	"8610:3310:3615:52060:39330:39898",
	"8610:11139",
	"8610:3310:16227:11899",
	"8610:12616:34429:11901",
	"8610:12616",
	"8610:11139:12740",
	"8610:3310:3615:52060",
	"8610:3310:7824:10583",
	"8610:3310:16227",
	"8610:12616:22931",
	"8610:3310:16227:11899:40358",
	"8610:12616:34429",
	"8610:12616:34927",
	"8610:12616:34943",
	"8610:12616:34429:35141",
	"8610:12616:34943:35140",
	"8610:3310:3615:35139",
	"8610:12616:34943:35140:4312:35315",
	"8610:2995:35556:35478",
	"8610:2995:35556",
	"8610:12616:34943:35140:4312:35315:35562",
	"8610:3310:7824:39175",
	"8610:3310:3615:39340",
	"8610:3310:3615:52060:39330",
	"8610:2995:40809",
	"8610:3310:40558",
	"8610:3310:16227:11899:40358:40769",
	"8610:3310:7824:41215",
	"8610:3310:41140:41142",
	"8610:3310:41140",
	"8610:3310:7824:41214",
	"8610:12616:34943:35140:41246",
	"8610:36728:XY-2454825450:43481",
	"8610:36728:XY-2454825450:43481:41860",
	"8610:36728:XY-2454825450:43481:41861",
	"8610:2995:6726:40473",
	"8610:3310:3615:52060:39330:39898:41605",
	"8610:11139:43085:43073",
	"8610:12616:22931:43079",
	"8610:11139:43085",
	"8610:37005",
	"8610:36728:XY-2454825450",
	"8610:3310:7824:41215:48275",
	"8610:3310:3615:52060:39330:39898:163253",
	"8610:3310:3615:52060:39330:39898:163253:XY-1868173255",
	"8610:36728",
	"8610:36728:XY-2454825450:43481:54392",
	--["name"] = "Northern Rocketway, Azshara",
	["m"] = 76,
	["f"] = 0,
	["direct"] = "8610",
	["coord"] = 2857448856,
	},
	[40558] = {
	"3615:2995",
	"3615:4312",
	"3615:44399",
	"3615:2995:6726",
	"3615:52060:39330:40358:40769:7824",
	"3615:52060:39330:39898",
	"3310:8610",
	"3310:11139",
	"3615:52060:11899",
	"34927:34429:11901",
	"34927:12616",
	"34927:12616:22931:43073:43085:12740",
	"3615:52060",
	"3615:52060:39330:40358:40769:7824:10583",
	"3615:16227",
	"34927:12616:22931",
	"3615:52060:39330:40358",
	"34927:34429",
	"34927:34943",
	"34927:34429:35141",
	"34927:35140",
	"3615:35139",
	"3615:2995:35556:35562:35315",
	"3615:2995:35556:35478",
	"3615:2995:35556",
	"3615:2995:35556:35562",
	"3615:52060:39330:40358:40769:7824:39175",
	"3615:39340",
	"3615:52060:39330",
	"3615:2995:40809",
	"3615:52060:39330:40358:40769",
	"3615:52060:39330:40358:40769:7824:41215",
	"3310:41140:41142",
	"3310:41140",
	"3615:52060:39330:40358:40769:7824:41214",
	"34927:35140:41246",
	"3310:XY-2454825450:43481",
	"3310:XY-2454825450:43481:41860",
	"3310:XY-2454825450:43481:41861",
	"3615:2995:6726:40473",
	"3615:52060:39330:39898:41605",
	"34927:12616:22931:43073",
	"34927:12616:22931:43079",
	"34927:12616:22931:43073:43085",
	"3310:37005",
	"3310:8610:43328",
	"3310:XY-2454825450",
	"3615:52060:39330:40358:40769:7824:41215:48275",
	"3615:52060:39330:39898:163253",
	"3615:52060:39330:39898:163253:XY-1868173255",
	"3310:36728",
	"3310:XY-2454825450:43481:54392",
	--["name"] = "Nozzlepot's Outpost, Northern Barrens",
	["m"] = 10,
	["coord"] = 2677353407,
	["direct"] = "3310:3615:34927",
	["f"] = 0,
	},
	[35556] = {
	"2995:3310",
	"2995:3615",
	"35478:4312",
	"2995:44399",
	"35478:6726",
	"2995:7824",
	"2995:52060:39330:39898",
	"2995:8610",
	"2995:8610:11139",
	"2995:52060:11899",
	"35478:4312:11901",
	"2995:3615:34927:12616",
	"2995:3615:34927:12616:22931:43073:43085:12740",
	"2995:52060",
	"2995:7824:10583",
	"2995:3615:16227",
	"2995:3615:34927:12616:22931",
	"2995:52060:39330:40358",
	"35478:4312:34429",
	"2995:3615:34927",
	"2995:35139:35140:34943",
	"35478:4312:35141",
	"2995:35139:35140",
	"2995:35139",
	"35562:35315",
	"2995:7824:39175",
	"2995:39340",
	"2995:52060:39330",
	"2995:40809",
	"2995:3615:40558",
	"2995:52060:39330:40358:40769",
	"2995:7824:41215",
	"2995:3310:41140:41142",
	"2995:3310:41140",
	"2995:7824:41214",
	"35478:4312:41246",
	"2995:3310:XY-2454825450:43481",
	"2995:3310:XY-2454825450:43481:41860",
	"2995:3310:XY-2454825450:43481:41861",
	"35478:6726:40473",
	"35478:6726:40473:41605",
	"2995:3615:34927:12616:22931:43073",
	"2995:3615:34927:12616:22931:43079",
	"2995:3615:34927:12616:22931:43073:43085",
	"2995:3310:37005",
	"2995:8610:43328",
	"2995:3310:XY-2454825450",
	"2995:7824:41215:48275",
	"35478:6726:40473:41605:163253",
	"35478:6726:40473:41605:163253:XY-1868173255",
	"2995:3615:34927:12616:36728",
	"2995:3310:XY-2454825450:43481:54392",
	--["name"] = "Thunk's Abode, Desolace",
	["m"] = 66,
	["coord"] = 3034666036,
	["direct"] = "2995:35478:35562",
	["f"] = 0,
	},
	[22931] = {
	"34429:4312:35139:2995",
	"12616:3310",
	"12616:34927:3615",
	"34429:4312",
	"12616:34927:3615:44399",
	"34429:4312:6726",
	"12616:34927:3615:52060:39330:40358:40769:7824",
	"12616:34927:3615:52060:39330:39898",
	"12616:36728:8610",
	"43073:43085:11139",
	"12616:34927:3615:52060:11899",
	"43073:43085:12740",
	"12616:34927:3615:52060",
	"12616:34927:3615:52060:39330:40358:40769:7824:10583",
	"12616:34927:3615:16227",
	"12616:34927:3615:52060:39330:40358",
	"12616:34927",
	"34429:34943",
	"34429:35141",
	"34429:34943:35140",
	"34429:4312:35139",
	"34429:4312:35315",
	"34429:4312:35478",
	"34429:4312:35478:35556",
	"34429:4312:35315:35562",
	"12616:34927:3615:52060:39330:40358:40769:7824:39175",
	"12616:34927:3615:39340",
	"12616:34927:3615:52060:39330",
	"34429:4312:35139:2995:40809",
	"12616:34927:40558",
	"12616:34927:3615:52060:39330:40358:40769",
	"12616:34927:3615:52060:39330:40358:40769:7824:41215",
	"12616:3310:41140:41142",
	"12616:3310:41140",
	"12616:34927:3615:52060:39330:40358:40769:7824:41214",
	"34429:35141:41246",
	"12616:36728:XY-2454825450:43481",
	"12616:36728:XY-2454825450:43481:41860",
	"12616:36728:XY-2454825450:43481:41861",
	"34429:4312:6726:40473",
	"12616:34927:3615:52060:39330:39898:41605",
	"43073:43085",
	"12616:36728:8610:37005",
	"12616:36728:8610:43328",
	"12616:36728:XY-2454825450",
	"12616:34927:3615:52060:39330:40358:40769:7824:41215:48275",
	"12616:34927:3615:52060:39330:39898:163253",
	"12616:34927:3615:52060:39330:39898:163253:XY-1868173255",
	"12616:36728",
	"12616:36728:XY-2454825450:43481:54392",
	--["name"] = "Emerald Sanctuary, Felwood",
	["m"] = 77,
	["coord"] = 2212089545,
	["direct"] = "11901:12616:34429:43073:43079",
	["f"] = 0,
	},
	[44399] = {
	"11899:16227:3310",
	"3615:4312",
	"39898:41605:40473:6726",
	"11899:16227:3310:8610",
	"11899:16227:3310:11139",
	"3615:34927:34429:11901",
	"3615:34927:12616",
	"3615:34927:12616:22931:43073:43085:12740",
	"40769:7824:10583",
	"11899:16227",
	"3615:34927:12616:22931",
	"3615:34927:34429",
	"3615:34927",
	"3615:34927:34943",
	"2995:35139:35141",
	"2995:35139:35140",
	"2995:35139",
	"39898:35315",
	"39898:41605:40473:6726:35478",
	"2995:35556",
	"39898:35315:35562",
	"40769:7824:39175",
	"52060:39340",
	"2995:40809",
	"3615:40558",
	"40769:7824:41215",
	"11899:16227:3310:41140:41142",
	"11899:16227:3310:41140",
	"40769:7824:41214",
	"3615:4312:41246",
	"11899:16227:3310:XY-2454825450:43481",
	"11899:16227:3310:XY-2454825450:43481:41860",
	"11899:16227:3310:XY-2454825450:43481:41861",
	"39898:41605:40473",
	"39898:41605",
	"3615:34927:12616:22931:43073",
	"3615:34927:12616:22931:43079",
	"3615:34927:12616:22931:43073:43085",
	"11899:16227:3310:37005",
	"11899:16227:3310:8610:43328",
	"11899:16227:3310:XY-2454825450",
	"39898:163253:48275",
	"39898:163253",
	"39898:163253:XY-1868173255",
	"3615:34927:12616:36728",
	"11899:16227:3310:XY-2454825450:43481:54392",
	--["name"] = "Westreach Summit, Thousand Needles",
	["m"] = 64,
	["coord"] = 481959428,
	["direct"] = "2995:3615:7824:39898:11899:52060:40358:39330:40769",
	["f"] = 0,
	},
	[43481] = {
	"XY-2454825450:3310:3615:2995",
	"XY-2454825450:3310",
	"XY-2454825450:3310:3615",
	"XY-2454825450:36728:12616:34943:35140:4312",
	"XY-2454825450:3310:3615:44399",
	"XY-2454825450:36728:12616:34943:35140:4312:6726",
	"XY-2454825450:3310:7824",
	"XY-2454825450:3310:3615:52060:39330:39898",
	"XY-2454825450:36728:8610",
	"41861:11139",
	"XY-2454825450:3310:16227:11899",
	"XY-2454825450:36728:12616:34429:11901",
	"XY-2454825450:36728:12616",
	"41861:12740",
	"XY-2454825450:3310:3615:52060",
	"XY-2454825450:3310:7824:10583",
	"XY-2454825450:3310:16227",
	"XY-2454825450:36728:12616:22931",
	"XY-2454825450:3310:16227:11899:40358",
	"XY-2454825450:36728:12616:34429",
	"XY-2454825450:36728:12616:34927",
	"XY-2454825450:36728:12616:34943",
	"XY-2454825450:36728:12616:34429:35141",
	"XY-2454825450:36728:12616:34943:35140",
	"XY-2454825450:36728:12616:34943:35140:35139",
	"XY-2454825450:36728:12616:34943:35140:4312:35315",
	"XY-2454825450:36728:12616:34943:35140:4312:35478",
	"XY-2454825450:3310:3615:2995:35556",
	"XY-2454825450:36728:12616:34943:35140:4312:35315:35562",
	"XY-2454825450:3310:7824:39175",
	"XY-2454825450:3310:3615:39340",
	"XY-2454825450:3310:3615:52060:39330",
	"XY-2454825450:3310:3615:2995:40809",
	"XY-2454825450:3310:40558",
	"XY-2454825450:3310:16227:11899:40358:40769",
	"XY-2454825450:3310:7824:41215",
	"XY-2454825450:3310:41140:41142",
	"XY-2454825450:3310:41140",
	"XY-2454825450:3310:7824:41214",
	"XY-2454825450:36728:12616:34943:35140:41246",
	"XY-2454825450:36728:12616:34943:35140:4312:6726:40473",
	"XY-2454825450:3310:3615:52060:39330:39898:41605",
	"41861:12740:43085:43073",
	"XY-2454825450:36728:12616:22931:43079",
	"41861:12740:43085",
	"XY-2454825450:36728:8610:37005",
	"XY-2454825450:36728:8610:43328",
	"XY-2454825450:3310:7824:41215:48275",
	"XY-2454825450:3310:3615:52060:39330:39898:163253",
	"XY-2454825450:3310:3615:52060:39330:39898:163253:XY-1868173255",
	"XY-2454825450:36728",
	--["name"] = "Shrine of Aviana, Hyjal",
	["m"] = 198,
	["f"] = 0,
	["direct"] = "41860:41861:XY-2454825450:54392",
	["coord"] = 1767271736,
	},
	[3310] = {
	"3615:4312",
	"3615:44399",
	"3615:2995:6726",
	"3615:52060:39330:39898",
	"12616:34429:11901",
	"XY-2454825450:43481:41861:12740",
	"3615:52060",
	"7824:10583",
	"12616:22931",
	"16227:11899:40358",
	"12616:34429",
	"12616:34943",
	"12616:34429:35141",
	"12616:34943:35140",
	"3615:35139",
	"3615:2995:35556:35562:35315",
	"3615:2995:35556:35478",
	"3615:2995:35556",
	"3615:2995:35556:35562",
	"7824:39175",
	"3615:39340",
	"3615:52060:39330",
	"3615:2995:40809",
	"16227:11899:40358:40769",
	"7824:41215",
	"41140:41142",
	"7824:41214",
	"12616:34943:35140:41246",
	"XY-2454825450:43481",
	"XY-2454825450:43481:41860",
	"XY-2454825450:43481:41861",
	"3615:2995:6726:40473",
	"3615:52060:39330:39898:41605",
	"12616:22931:43073",
	"12616:22931:43079",
	"12616:22931:43073:43085",
	"8610:43328",
	"7824:41215:48275",
	"3615:52060:39330:39898:163253",
	"3615:52060:39330:39898:163253:XY-1868173255",
	"XY-2454825450:43481:54392",
	--["name"] = "Orgrimmar, Durotar",
	["m"] = 85,
	["f"] = 0,
	["direct"] = "2995:3615:7824:8610:11139:11899:12616:16227:34927:40558:41140:37005:XY-2454825450:36728",
	["coord"] = 2130352035,
	},
	[43079] = {
	"22931:34429:4312:35139:2995",
	"22931:12616:3310",
	"22931:12616:34927:3615",
	"22931:34429:4312",
	"22931:12616:34927:3615:44399",
	"22931:34429:4312:6726",
	"22931:12616:34927:3615:52060:39330:40358:40769:7824",
	"22931:12616:34927:3615:52060:39330:39898",
	"22931:12616:36728:8610",
	"43073:43085:11139",
	"22931:12616:34927:3615:52060:11899",
	"22931:34429:11901",
	"22931:12616",
	"43073:43085:12740",
	"22931:12616:34927:3615:52060",
	"22931:12616:34927:3615:52060:39330:40358:40769:7824:10583",
	"22931:12616:34927:3615:16227",
	"22931:12616:34927:3615:52060:39330:40358",
	"22931:34429",
	"22931:12616:34927",
	"22931:34429:34943",
	"22931:34429:35141",
	"22931:34429:34943:35140",
	"22931:34429:4312:35139",
	"22931:34429:4312:35315",
	"22931:34429:4312:35478",
	"22931:34429:4312:35478:35556",
	"22931:34429:4312:35315:35562",
	"22931:12616:34927:3615:52060:39330:40358:40769:7824:39175",
	"22931:12616:34927:3615:39340",
	"22931:12616:34927:3615:52060:39330",
	"22931:34429:4312:35139:2995:40809",
	"22931:12616:34927:40558",
	"22931:12616:34927:3615:52060:39330:40358:40769",
	"22931:12616:34927:3615:52060:39330:40358:40769:7824:41215",
	"22931:12616:3310:41140:41142",
	"22931:12616:3310:41140",
	"22931:12616:34927:3615:52060:39330:40358:40769:7824:41214",
	"22931:34429:35141:41246",
	"22931:12616:36728:XY-2454825450:43481",
	"22931:12616:36728:XY-2454825450:43481:41860",
	"43073:43085:12740:41861",
	"22931:34429:4312:6726:40473",
	"22931:12616:34927:3615:52060:39330:39898:41605",
	"43073:43085",
	"22931:12616:36728:8610:37005",
	"22931:12616:36728:8610:43328",
	"22931:12616:36728:XY-2454825450",
	"22931:12616:34927:3615:52060:39330:40358:40769:7824:41215:48275",
	"22931:12616:34927:3615:52060:39330:39898:163253",
	"22931:12616:34927:3615:52060:39330:39898:163253:XY-1868173255",
	"22931:12616:36728",
	"22931:12616:36728:XY-2454825450:43481:54392",
	--["name"] = "Wildheart Point, Felwood",
	["m"] = 77,
	["coord"] = 1901174384,
	["direct"] = "22931:43073",
	["f"] = 0,
	},
	[36728] = {
	"3310:3615:2995",
	"3310:3615",
	"12616:34943:35140:4312",
	"3310:3615:44399",
	"12616:34943:35140:4312:6726",
	"3310:7824",
	"3310:3615:52060:39330:39898",
	"8610:11139",
	"3310:16227:11899",
	"12616:34429:11901",
	"XY-2454825450:43481:41861:12740",
	"3310:3615:52060",
	"3310:7824:10583",
	"3310:16227",
	"12616:22931",
	"3310:16227:11899:40358",
	"12616:34429",
	"12616:34927",
	"12616:34943",
	"12616:34429:35141",
	"12616:34943:35140",
	"12616:34943:35140:35139",
	"12616:34943:35140:4312:35315",
	"12616:34943:35140:4312:35478",
	"3310:3615:2995:35556",
	"12616:34943:35140:4312:35315:35562",
	"3310:7824:39175",
	"3310:3615:39340",
	"3310:3615:52060:39330",
	"3310:3615:2995:40809",
	"3310:40558",
	"3310:16227:11899:40358:40769",
	"3310:7824:41215",
	"3310:41140:41142",
	"3310:41140",
	"3310:7824:41214",
	"12616:34943:35140:41246",
	"XY-2454825450:43481",
	"XY-2454825450:43481:41860",
	"XY-2454825450:43481:41861",
	"12616:34943:35140:4312:6726:40473",
	"3310:3615:52060:39330:39898:41605",
	"12616:22931:43073",
	"12616:22931:43079",
	"12616:22931:43073:43085",
	"8610:37005",
	"8610:43328",
	"3310:7824:41215:48275",
	"3310:3615:52060:39330:39898:163253",
	"3310:3615:52060:39330:39898:163253:XY-1868173255",
	"XY-2454825450:43481:54392",
	--["name"] = "Valormok, Azshara",
	["m"] = 76,
	["coord"] = 614114972,
	["direct"] = "3310:8610:12616:XY-2454825450",
	["f"] = 0,
	},
	[16227] = {
	"3615:2995",
	"3615:4312",
	"11899:44399",
	"3615:2995:6726",
	"11899:39330:39898",
	"3310:8610",
	"3310:11139",
	"3615:34927:34429:11901",
	"3615:34927:12616",
	"3310:XY-2454825450:43481:41861:12740",
	"3615:52060",
	"7824:10583",
	"3615:34927:12616:22931",
	"11899:40358",
	"3615:34927:34429",
	"3615:34927",
	"3615:34927:34943",
	"3615:4312:35141",
	"3615:4312:35140",
	"3615:35139",
	"3615:2995:35556:35562:35315",
	"3615:2995:35556:35478",
	"3615:2995:35556",
	"3615:2995:35556:35562",
	"7824:39175",
	"3615:39340",
	"11899:39330",
	"3615:2995:40809",
	"3615:40558",
	"11899:40358:40769",
	"7824:41215",
	"3310:41140:41142",
	"3310:41140",
	"7824:41214",
	"3615:4312:41246",
	"3310:XY-2454825450:43481",
	"3310:XY-2454825450:43481:41860",
	"3310:XY-2454825450:43481:41861",
	"3615:2995:6726:40473",
	"11899:39330:39898:41605",
	"3615:34927:12616:22931:43073",
	"3615:34927:12616:22931:43079",
	"3615:34927:12616:22931:43073:43085",
	"3310:37005",
	"3310:8610:43328",
	"3310:XY-2454825450",
	"7824:41215:48275",
	"11899:39330:39898:163253",
	"7824:41215:48275:XY-1868173255",
	"3310:36728",
	"3310:XY-2454825450:43481:54392",
	--["name"] = "Ratchet, Northern Barrens",
	["m"] = 10,
	["coord"] = 2969089312,
	["direct"] = "3310:3615:7824:11899",
	["f"] = 0,
	},
	[2995] = {
	"8610:11139",
	"3615:34927:12616",
	"3615:34927:12616:22931:43073:43085:12740",
	"7824:10583",
	"3615:16227",
	"3615:34927:12616:22931",
	"52060:39330:40358",
	"35139:4312:34429",
	"3615:34927",
	"35139:35140:34943",
	"35139:35141",
	"35139:35140",
	"35556:35562:35315",
	"35556:35478",
	"35556:35562",
	"7824:39175",
	"52060:39330",
	"3615:40558",
	"52060:39330:40358:40769",
	"7824:41215",
	"3310:41140:41142",
	"3310:41140",
	"7824:41214",
	"35139:4312:41246",
	"3310:XY-2454825450:43481",
	"3310:XY-2454825450:43481:41860",
	"3310:XY-2454825450:43481:41861",
	"6726:40473",
	"52060:39330:39898:41605",
	"3615:34927:12616:22931:43073",
	"3615:34927:12616:22931:43079",
	"3615:34927:12616:22931:43073:43085",
	"3310:37005",
	"8610:43328",
	"3310:XY-2454825450",
	"7824:41215:48275",
	"52060:39330:39898:163253",
	"52060:39330:39898:163253:XY-1868173255",
	"3615:34927:12616:36728",
	"3310:XY-2454825450:43481:54392",
	--["name"] = "Thunder Bluff, Mulgore",
	["m"] = 88,
	["coord"] = 2003861436,
	["direct"] = "3310:3615:4312:44399:6726:7824:39898:8610:11899:11901:52060:35139:35556:39340:40809",
	["f"] = 0,
	},
	[35139] = {
	"3615:3310",
	"2995:44399",
	"2995:7824",
	"2995:52060:39330:39898",
	"3615:8610",
	"3615:3310:11139",
	"2995:52060:11899",
	"35141:11901",
	"3615:34927:12616",
	"4312:34429:22931:43073:43085:12740",
	"2995:52060",
	"2995:7824:10583",
	"3615:16227",
	"4312:34429:22931",
	"2995:52060:39330:40358",
	"4312:34429",
	"3615:34927",
	"35140:34943",
	"4312:35315",
	"2995:35556:35478",
	"2995:35556",
	"2995:35556:35562",
	"2995:7824:39175",
	"2995:39340",
	"2995:52060:39330",
	"2995:40809",
	"3615:40558",
	"2995:52060:39330:40358:40769",
	"2995:7824:41215",
	"3615:3310:41140:41142",
	"3615:3310:41140",
	"2995:7824:41214",
	"4312:41246",
	"3615:3310:XY-2454825450:43481",
	"3615:3310:XY-2454825450:43481:41860",
	"3615:3310:XY-2454825450:43481:41861",
	"6726:40473",
	"6726:40473:41605",
	"4312:34429:22931:43073",
	"4312:34429:22931:43079",
	"4312:34429:22931:43073:43085",
	"3615:3310:37005",
	"3615:8610:43328",
	"3615:3310:XY-2454825450",
	"2995:7824:41215:48275",
	"2995:52060:39330:39898:163253",
	"2995:52060:39330:39898:163253:XY-1868173255",
	"3615:34927:12616:36728",
	"3615:3310:XY-2454825450:43481:54392",
	--["name"] = "Malaka'jin, Stonetalon Mountains",
	["m"] = 65,
	["coord"] = 3030115543,
	["direct"] = "2995:3615:4312:6726:35141:35140",
	["f"] = 0,
	},
	[40769] = {
	"40358:11899:52060:2995",
	"40358:11899:16227:3310",
	"40358:11899:52060:3615",
	"40358:11899:52060:3615:4312",
	"44399:39898:41605:40473:6726",
	"44399:39898",
	"40358:11899:16227:3310:8610",
	"40358:11899:16227:3310:11139",
	"40358:11899",
	"40358:11899:52060:3615:34927:34429:11901",
	"40358:11899:52060:3615:34927:12616",
	"40358:11899:52060:3615:34927:12616:22931:43073:43085:12740",
	"40358:11899:52060",
	"7824:10583",
	"40358:11899:16227",
	"40358:11899:52060:3615:34927:12616:22931",
	"40358:11899:52060:3615:34927:34429",
	"40358:11899:52060:3615:34927",
	"40358:11899:52060:3615:34927:34943",
	"40358:11899:52060:3615:4312:35141",
	"40358:11899:52060:2995:35139:35140",
	"40358:11899:52060:2995:35139",
	"44399:39898:35315",
	"40358:11899:52060:2995:35556:35478",
	"40358:11899:52060:2995:35556",
	"40358:11899:52060:2995:35556:35562",
	"7824:39175",
	"40358:11899:52060:39340",
	"40358:39330",
	"40358:11899:52060:2995:40809",
	"40358:11899:52060:3615:40558",
	"7824:41215",
	"40358:11899:16227:3310:41140:41142",
	"40358:11899:16227:3310:41140",
	"7824:41214",
	"40358:11899:52060:3615:4312:41246",
	"40358:11899:16227:3310:XY-2454825450:43481",
	"40358:11899:16227:3310:XY-2454825450:43481:41860",
	"40358:11899:16227:3310:XY-2454825450:43481:41861",
	"44399:39898:41605:40473",
	"44399:39898:41605",
	"40358:11899:52060:3615:34927:12616:22931:43073",
	"40358:11899:52060:3615:34927:12616:22931:43079",
	"40358:11899:52060:3615:34927:12616:22931:43073:43085",
	"40358:11899:16227:3310:37005",
	"40358:11899:16227:3310:8610:43328",
	"40358:11899:16227:3310:XY-2454825450",
	"7824:41215:48275",
	"7824:39175:163253",
	"7824:41215:48275:XY-1868173255",
	"40358:11899:16227:3310:36728",
	"40358:11899:16227:3310:XY-2454825450:43481:54392",
	--["name"] = "Fizzle & Pozzik's Speedbarge, Thousand Needles",
	["m"] = 64,
	["f"] = 0,
	["direct"] = "44399:7824:40358",
	["coord"] = 3400513547,
	},
	[39340] = {
	"3615:3310",
	"3615:4312",
	"52060:44399",
	"2995:6726",
	"52060:39330:40358:40769:7824",
	"52060:39330:39898",
	"3615:8610",
	"3615:3310:11139",
	"52060:11899",
	"3615:34927:34429:11901",
	"3615:34927:12616",
	"3615:34927:12616:22931:43073:43085:12740",
	"52060:39330:40358:40769:7824:10583",
	"3615:16227",
	"3615:34927:12616:22931",
	"52060:39330:40358",
	"3615:34927:34429",
	"3615:34927",
	"3615:34927:34943",
	"2995:35139:35141",
	"2995:35139:35140",
	"2995:35139",
	"2995:35556:35562:35315",
	"2995:35556:35478",
	"2995:35556",
	"2995:35556:35562",
	"52060:39330:40358:40769:7824:39175",
	"2995:40809",
	"3615:40558",
	"52060:39330:40358:40769",
	"52060:39330:40358:40769:7824:41215",
	"3615:3310:41140:41142",
	"3615:3310:41140",
	"52060:39330:40358:40769:7824:41214",
	"3615:4312:41246",
	"3615:3310:XY-2454825450:43481",
	"3615:3310:XY-2454825450:43481:41860",
	"3615:3310:XY-2454825450:43481:41861",
	"2995:6726:40473",
	"52060:39330:39898:41605",
	"3615:34927:12616:22931:43073",
	"3615:34927:12616:22931:43079",
	"3615:34927:12616:22931:43073:43085",
	"3615:3310:37005",
	"3615:8610:43328",
	"3615:3310:XY-2454825450",
	"52060:39330:40358:40769:7824:41215:48275",
	"52060:39330:39898:163253",
	"52060:39330:39898:163253:XY-1868173255",
	"3615:34927:12616:36728",
	"3615:3310:XY-2454825450:43481:54392",
	--["name"] = "Hunter's Hill, Southern Barrens",
	["m"] = 199,
	["coord"] = 1709126614,
	["direct"] = "2995:3615:52060:39330",
	["f"] = 0,
	},
	[41214] = {
	"7824:2995",
	"7824:16227:3310",
	"7824:3615",
	"7824:2995:35139:4312",
	"7824:44399",
	"7824:39898:41605:40473:6726",
	"7824:39898",
	"7824:16227:3310:8610",
	"7824:16227:3310:11139",
	"7824:40769:40358:11899",
	"7824:3615:34927:34429:11901",
	"7824:3615:34927:12616",
	"7824:16227:3310:XY-2454825450:43481:41861:12740",
	"7824:40769:40358:11899:52060",
	"7824:10583",
	"7824:16227",
	"7824:3615:34927:12616:22931",
	"7824:40769:40358",
	"7824:3615:34927:34429",
	"7824:3615:34927",
	"7824:3615:34927:34943",
	"7824:2995:35139:35141",
	"7824:2995:35139:35140",
	"7824:2995:35139",
	"7824:2995:35556:35562:35315",
	"7824:2995:35556:35478",
	"7824:2995:35556",
	"7824:2995:35556:35562",
	"7824:39175",
	"7824:40769:40358:11899:52060:39340",
	"7824:40769:40358:39330",
	"7824:2995:40809",
	"7824:3615:40558",
	"7824:40769",
	"7824:16227:3310:41140:41142",
	"7824:16227:3310:41140",
	"7824:2995:35139:4312:41246",
	"7824:16227:3310:XY-2454825450:43481",
	"7824:16227:3310:XY-2454825450:43481:41860",
	"7824:16227:3310:XY-2454825450:43481:41861",
	"7824:39898:41605:40473",
	"7824:39898:41605",
	"7824:3615:34927:12616:22931:43073",
	"7824:3615:34927:12616:22931:43079",
	"7824:3615:34927:12616:22931:43073:43085",
	"7824:16227:3310:37005",
	"7824:16227:3310:8610:43328",
	"7824:16227:3310:XY-2454825450",
	"41215:48275",
	"41215:48275:163253",
	"41215:48275:XY-1868173255",
	"7824:16227:3310:36728",
	"7824:16227:3310:XY-2454825450:43481:54392",
	--["name"] = "Bootlegger Outpost, Tanaris",
	["m"] = 71,
	["f"] = 0,
	["direct"] = "7824:41215",
	["coord"] = 2399443730,
	},
	[43073] = {
	"22931:34429:4312:35139:2995",
	"22931:12616:3310",
	"22931:12616:34927:3615",
	"22931:34429:4312",
	"22931:12616:34927:3615:44399",
	"22931:34429:4312:6726",
	"22931:12616:34927:3615:52060:39330:40358:40769:7824",
	"22931:12616:34927:3615:52060:39330:39898",
	"43085:11139:8610",
	"43085:11139",
	"22931:12616:34927:3615:52060:11899",
	"22931:34429:11901",
	"22931:12616",
	"43085:12740",
	"22931:12616:34927:3615:52060",
	"22931:12616:34927:3615:52060:39330:40358:40769:7824:10583",
	"22931:12616:34927:3615:16227",
	"22931:12616:34927:3615:52060:39330:40358",
	"22931:34429",
	"22931:12616:34927",
	"22931:34429:34943",
	"22931:34429:35141",
	"22931:34429:34943:35140",
	"22931:34429:4312:35139",
	"22931:34429:4312:35315",
	"22931:34429:4312:35478",
	"22931:34429:4312:35478:35556",
	"22931:34429:4312:35315:35562",
	"22931:12616:34927:3615:52060:39330:40358:40769:7824:39175",
	"22931:12616:34927:3615:39340",
	"22931:12616:34927:3615:52060:39330",
	"22931:34429:4312:35139:2995:40809",
	"22931:12616:34927:40558",
	"22931:12616:34927:3615:52060:39330:40358:40769",
	"22931:12616:34927:3615:52060:39330:40358:40769:7824:41215",
	"22931:12616:3310:41140:41142",
	"22931:12616:3310:41140",
	"22931:12616:34927:3615:52060:39330:40358:40769:7824:41214",
	"22931:34429:35141:41246",
	"43085:12740:41861:43481",
	"43085:12740:41861:41860",
	"43085:12740:41861",
	"22931:34429:4312:6726:40473",
	"22931:12616:34927:3615:52060:39330:39898:41605",
	"43085:11139:8610:37005",
	"43085:11139:8610:43328",
	"22931:12616:36728:XY-2454825450",
	"22931:12616:34927:3615:52060:39330:40358:40769:7824:41215:48275",
	"22931:12616:34927:3615:52060:39330:39898:163253",
	"22931:12616:34927:3615:52060:39330:39898:163253:XY-1868173255",
	"22931:12616:36728",
	"43085:12740:41861:43481:54392",
	--["name"] = "Whisperwind Grove, Felwood",
	["m"] = 77,
	["coord"] = 1871595878,
	["direct"] = "22931:43079:43085",
	["f"] = 0,
	},
	[40809] = {
	"2995:3310",
	"2995:3615",
	"2995:35139:4312",
	"2995:44399",
	"2995:6726",
	"2995:7824",
	"2995:52060:39330:39898",
	"2995:8610",
	"2995:8610:11139",
	"2995:52060:11899",
	"2995:35139:35141:11901",
	"2995:3615:34927:12616",
	"2995:3615:34927:12616:22931:43073:43085:12740",
	"2995:52060",
	"2995:7824:10583",
	"2995:3615:16227",
	"2995:3615:34927:12616:22931",
	"2995:52060:39330:40358",
	"2995:35139:4312:34429",
	"2995:3615:34927",
	"2995:35139:35140:34943",
	"2995:35139:35141",
	"2995:35139:35140",
	"2995:35139",
	"2995:35556:35562:35315",
	"2995:35556:35478",
	"2995:35556",
	"2995:35556:35562",
	"2995:7824:39175",
	"2995:39340",
	"2995:52060:39330",
	"2995:3615:40558",
	"2995:52060:39330:40358:40769",
	"2995:7824:41215",
	"2995:3310:41140:41142",
	"2995:3310:41140",
	"2995:7824:41214",
	"2995:35139:4312:41246",
	"2995:3310:XY-2454825450:43481",
	"2995:3310:XY-2454825450:43481:41860",
	"2995:3310:XY-2454825450:43481:41861",
	"2995:6726:40473",
	"2995:52060:39330:39898:41605",
	"2995:3615:34927:12616:22931:43073",
	"2995:3615:34927:12616:22931:43079",
	"2995:3615:34927:12616:22931:43073:43085",
	"2995:3310:37005",
	"2995:8610:43328",
	"2995:3310:XY-2454825450",
	"2995:7824:41215:48275",
	"2995:52060:39330:39898:163253",
	"2995:52060:39330:39898:163253:XY-1868173255",
	"2995:3615:34927:12616:36728",
	"2995:3310:XY-2454825450:43481:54392",
	--["name"] = "Bloodhoof Village, Mulgore",
	["m"] = 7,
	["f"] = 0,
	["direct"] = "2995",
	["coord"] = 2035783201,
	},
	[39330] = {
	"52060:2995",
	"11899:16227:3310",
	"52060:3615",
	"52060:3615:4312",
	"39898:41605:40473:6726",
	"40358:40769:7824",
	"52060:3615:8610",
	"11899:16227:3310:11139",
	"52060:3615:34927:34429:11901",
	"52060:3615:34927:12616",
	"52060:3615:34927:12616:22931:43073:43085:12740",
	"40358:40769:7824:10583",
	"11899:16227",
	"52060:3615:34927:12616:22931",
	"52060:3615:34927:34429",
	"52060:3615:34927",
	"52060:3615:34927:34943",
	"52060:3615:4312:35141",
	"52060:2995:35139:35140",
	"52060:2995:35139",
	"52060:2995:35556:35562:35315",
	"52060:2995:35556:35478",
	"52060:2995:35556",
	"52060:2995:35556:35562",
	"40358:40769:7824:39175",
	"52060:2995:40809",
	"52060:3615:40558",
	"40358:40769",
	"40358:40769:7824:41215",
	"11899:16227:3310:41140:41142",
	"11899:16227:3310:41140",
	"40358:40769:7824:41214",
	"52060:3615:4312:41246",
	"11899:16227:3310:XY-2454825450:43481",
	"11899:16227:3310:XY-2454825450:43481:41860",
	"11899:16227:3310:XY-2454825450:43481:41861",
	"39898:41605:40473",
	"39898:41605",
	"52060:3615:34927:12616:22931:43073",
	"52060:3615:34927:12616:22931:43079",
	"52060:3615:34927:12616:22931:43073:43085",
	"11899:16227:3310:37005",
	"52060:3615:8610:43328",
	"11899:16227:3310:XY-2454825450",
	"40358:40769:7824:41215:48275",
	"39898:163253",
	"39898:163253:XY-1868173255",
	"52060:3615:34927:12616:36728",
	"11899:16227:3310:XY-2454825450:43481:54392",
	--["name"] = "Desolation Hold, Southern Barrens",
	["m"] = 199,
	["coord"] = 1769714932,
	["direct"] = "44399:39898:11899:52060:40358:39340",
	["f"] = 0,
	},
	[54392] = {
	"43481:XY-2454825450:3310:3615:2995",
	"43481:XY-2454825450:3310",
	"43481:XY-2454825450:3310:3615",
	"43481:XY-2454825450:36728:12616:34943:35140:4312",
	"43481:XY-2454825450:3310:3615:44399",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:6726",
	"43481:XY-2454825450:3310:7824",
	"43481:XY-2454825450:3310:3615:52060:39330:39898",
	"43481:XY-2454825450:36728:8610",
	"43481:41861:11139",
	"43481:XY-2454825450:3310:16227:11899",
	"43481:XY-2454825450:36728:12616:34429:11901",
	"43481:XY-2454825450:36728:12616",
	"43481:41861:12740",
	"43481:XY-2454825450:3310:3615:52060",
	"43481:XY-2454825450:3310:7824:10583",
	"43481:XY-2454825450:3310:16227",
	"43481:XY-2454825450:36728:12616:22931",
	"43481:XY-2454825450:3310:16227:11899:40358",
	"43481:XY-2454825450:36728:12616:34429",
	"43481:XY-2454825450:36728:12616:34927",
	"43481:XY-2454825450:36728:12616:34943",
	"43481:XY-2454825450:36728:12616:34429:35141",
	"43481:XY-2454825450:36728:12616:34943:35140",
	"43481:XY-2454825450:36728:12616:34943:35140:35139",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:35315",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:35478",
	"43481:XY-2454825450:3310:3615:2995:35556",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:35315:35562",
	"43481:XY-2454825450:3310:7824:39175",
	"43481:XY-2454825450:3310:3615:39340",
	"43481:XY-2454825450:3310:3615:52060:39330",
	"43481:XY-2454825450:3310:3615:2995:40809",
	"43481:XY-2454825450:3310:40558",
	"43481:XY-2454825450:3310:16227:11899:40358:40769",
	"43481:XY-2454825450:3310:7824:41215",
	"43481:XY-2454825450:3310:41140:41142",
	"43481:XY-2454825450:3310:41140",
	"43481:XY-2454825450:3310:7824:41214",
	"43481:XY-2454825450:36728:12616:34943:35140:41246",
	"43481:41860",
	"43481:41861",
	"43481:XY-2454825450:36728:12616:34943:35140:4312:6726:40473",
	"43481:XY-2454825450:3310:3615:52060:39330:39898:41605",
	"43481:41861:12740:43085:43073",
	"43481:XY-2454825450:36728:12616:22931:43079",
	"43481:41861:12740:43085",
	"43481:XY-2454825450:36728:8610:37005",
	"43481:XY-2454825450:36728:8610:43328",
	"43481:XY-2454825450",
	"43481:XY-2454825450:3310:7824:41215:48275",
	"43481:XY-2454825450:3310:3615:52060:39330:39898:163253",
	"43481:XY-2454825450:3310:3615:52060:39330:39898:163253:XY-1868173255",
	"43481:XY-2454825450:36728",
	--["name"] = "Sanctuary of Malorne, Hyjal",
	["m"] = 198,
	["f"] = 0,
	["direct"] = "43481",
	["coord"] = 1192010396,
	},
	},
	{
	[29480] = {
	"12636:37888:37915:44825:2226",
	"12636:37888:XY-1887477213",
	"12636:37888:2389",
	"12636:4314:2851",
	"12636:44407:2861:2858",
	"12636:44407:2861:1387",
	"12636:44407:2861",
	"12636:44407:2861:13177:43086:6026",
	"12636:44407:2861:13177",
	"12636:44407:2861:3305",
	"12636:4314",
	"12636:44230:44233",
	"12636:44230:28621",
	"12636:44230",
	"12636:44231:44232",
	"12636:37888",
	"12636:37888:37915",
	"12636:37888:37915:XY-1876468864",
	"12636:44407:2861:1387:43053",
	"12636:44407:2861:1387:43052",
	"12636:44407:2861:13177:43086",
	"12636:37888:XY-1887477213:43220",
	"12636:37888:43573",
	"12636:44231",
	"12636:44407:44408",
	"12636:44407",
	"12636:37888:37915:44825",
	"12636:37888:37915:44825:2226:46552:XY-1742964349",
	"12636:37888:46011:46004",
	"12636:37888:46011",
	"12636:37888:37915:44825:2226:46552",
	"12636:4314:2851:XY-2582931773:47116",
	"12636:4314:2851:XY-2582931773:XY-2473159877:47133",
	"12636:4314:2851:XY-2582931773:XY-2473159877",
	"12636:4314:2851:XY-2582931773:47061",
	"12636:4314:2851:XY-2582931773",
	"12636:37888:2389:47644",
	"12636:37888:2389:47644:47655",
	"12636:37888:2389:47661",
	"12636:37888:37915:47665",
	"12636:44230:44233:47875",
	"12636:44407:2861:3305:47927",
	"12636:44407:2861:13177:48321:48318",
	"12636:44407:2861:13177:48321",
	"12636:37888:37915:44825:50463",
	"12636:44407:2861:13177:43086:6026:85734",
	"12636:238480:241031:251081:242011",
	"12636:238480:242913:239639:246560",
	"12636:238480:241031:249150",
	"12636:238480:241031:241036",
	"12636:238480:241031",
	"12636:238480:241031:251081",
	"12636:238480:241031:251073",
	"12636:238480:242913:239639",
	"12636:238480:242913:246564",
	"12636:238480:242913",
	"12636:238480",
	["direct"] = "12636",
	["m"] = 23,
	["coord"] = 3601629391,
	["f"] = 0,
	requirements = "cls:DEATHKNIGHT"
	},
	[13177] = {
	"2861:2851:2389:2226",
	"2861:XY-1887477213",
	"2861:2851:2389",
	"2861:2851",
	"1387:2858",
	"2861:44407:12636",
	"2861:2851:4314",
	"2861:2851:43573:37888:44232:44233",
	"2861:44407:12636:44230:28621",
	"2861:44407:12636:44230",
	"2861:2851:43573:37888:44232",
	"2861:2851:43573:37888",
	"2861:2851:43573:46004:37915",
	"2861:2851:43573:46004:37915:XY-1876468864",
	"1387:43053",
	"1387:43052",
	"3305:43220",
	"2861:2851:43573",
	"2861:2851:43573:37888:44232:44231",
	"2861:44408",
	"2861:44407",
	"2861:2851:43573:46004:37915:44825",
	"2861:2851:2389:47644:47655:46552:XY-1742964349",
	"2861:2851:43573:46004",
	"2861:2851:43573:46004:46011",
	"2861:2851:2389:47644:47655:46552",
	"2861:XY-2582931773:47116",
	"2861:XY-2582931773:XY-2473159877:47133",
	"2861:XY-2582931773:XY-2473159877",
	"2861:XY-2582931773:47061",
	"2861:XY-2582931773",
	"2861:2851:2389:47644",
	"2861:2851:2389:47644:47655",
	"2861:2851:2389:47661",
	"2861:2851:2389:47665",
	"2861:2851:43573:46004:46011:47875",
	"48321:48318:47927",
	"48321:48318",
	"2861:2851:43573:46004:37915:44825:50463",
	"43086:6026:85734",
	"2861:44407:12636:238480:241031:251081:242011",
	"2861:44407:12636:238480:242913:239639:246560",
	"2861:44407:12636:238480:241031:249150",
	"2861:44407:12636:238480:241031:241036",
	"2861:44407:12636:238480:241031",
	"2861:44407:12636:238480:241031:251081",
	"2861:44407:12636:238480:241031:251073",
	"2861:44407:12636:238480:242913:239639",
	"2861:44407:12636:238480:242913:246564",
	"2861:44407:12636:238480:242913",
	"2861:44407:12636:238480",
	--["name"] = "Flame Crest, Burning Steppes",
	["m"] = 36,
	["f"] = 0,
	["direct"] = "1387:2861:6026:3305:43086:48321",
	["coord"] = 2327723516,
	},
	[249150] = {
	"241031:238480:12636:37888:37915:44825:2226",
	"241031:238480:12636:37888:XY-1887477213",
	"241031:238480:12636:37888:2389",
	"241031:238480:12636:4314:2851",
	"241031:238480:12636:44407:2861:2858",
	"241031:238480:12636:44407:2861:1387",
	"241031:238480:12636:44407:2861",
	"241031:238480:12636:44407:2861:13177:43086:6026",
	"241031:238480:12636",
	"241031:238480:12636:44407:2861:13177",
	"241031:238480:12636:44407:2861:3305",
	"241031:238480:12636:4314",
	"241031:238480:12636:44230:44233",
	"241031:238480:12636:44230:28621",
	"241031:238480:12636:44230",
	"241031:238480:12636:44231:44232",
	"241031:238480:12636:37888",
	"241031:238480:12636:37888:37915",
	"241031:238480:12636:37888:37915:XY-1876468864",
	"241031:238480:12636:44407:2861:1387:43053",
	"241031:238480:12636:44407:2861:1387:43052",
	"241031:238480:12636:44407:2861:13177:43086",
	"241031:238480:12636:37888:XY-1887477213:43220",
	"241031:238480:12636:37888:43573",
	"241031:238480:12636:44231",
	"241031:238480:12636:44407:44408",
	"241031:238480:12636:44407",
	"241031:238480:12636:37888:37915:44825",
	"241031:238480:12636:37888:37915:44825:2226:46552:XY-1742964349",
	"241031:238480:12636:37888:46011:46004",
	"241031:238480:12636:37888:46011",
	"241031:238480:12636:37888:37915:44825:2226:46552",
	"241031:238480:12636:4314:2851:XY-2582931773:47116",
	"241031:238480:12636:4314:2851:XY-2582931773:XY-2473159877:47133",
	"241031:238480:12636:4314:2851:XY-2582931773:XY-2473159877",
	"241031:238480:12636:4314:2851:XY-2582931773:47061",
	"241031:238480:12636:4314:2851:XY-2582931773",
	"241031:238480:12636:37888:2389:47644",
	"241031:238480:12636:37888:2389:47644:47655",
	"241031:238480:12636:37888:2389:47661",
	"241031:238480:12636:37888:37915:47665",
	"241031:238480:12636:44230:44233:47875",
	"241031:238480:12636:44407:2861:3305:47927",
	"241031:238480:12636:44407:2861:13177:48321:48318",
	"241031:238480:12636:44407:2861:13177:48321",
	"241031:238480:12636:37888:37915:44825:50463",
	"241031:238480:12636:44407:2861:13177:43086:6026:85734",
	"241031:251081:242011",
	"241031:238480:242913:239639:246560",
	"241031:251081",
	"241031:251073",
	"241031:238480:242913:239639",
	"241031:251073:246564",
	"241031:238480:242913",
	"241031:238480",
	["direct"] = "241036:241031",
	["coord"] = 1456064657,
	["m"] = 2437,
	["f"] = 0,
	},
	[28621] = {
	"44232:37888:37915:44825:2226",
	"44232:37888:XY-1887477213",
	"44232:37888:2389",
	"44232:37888:43573:2851",
	"44230:12636:44407:2861:2858",
	"44230:12636:44407:2861:1387",
	"44230:12636:44407:2861",
	"44230:12636:44407:2861:13177:43086:6026",
	"44230:12636",
	"44230:12636:44407:2861:13177",
	"44230:12636:44407:2861:3305",
	"44230:12636:4314",
	"44232:37888",
	"44232:37888:37915",
	"44232:37888:37915:XY-1876468864",
	"44230:12636:44407:2861:1387:43053",
	"44230:12636:44407:2861:1387:43052",
	"44230:12636:44407:2861:13177:43086",
	"44232:37888:XY-1887477213:43220",
	"44232:37888:43573",
	"44230:44231",
	"44230:12636:44407:44408",
	"44230:12636:44407",
	"44232:37888:37915:44825",
	"44232:37888:37915:44825:2226:46552:XY-1742964349",
	"44232:37888:46011:46004",
	"44232:37888:46011",
	"44232:37888:37915:44825:2226:46552",
	"44232:37888:43573:2851:XY-2582931773:47116",
	"44232:37888:43573:2851:XY-2582931773:XY-2473159877:47133",
	"44232:37888:43573:2851:XY-2582931773:XY-2473159877",
	"44232:37888:43573:2851:XY-2582931773:47061",
	"44232:37888:43573:2851:XY-2582931773",
	"44232:37888:2389:47644",
	"44232:37888:2389:47644:47655",
	"44232:37888:2389:47661",
	"44232:37888:37915:47665",
	"44233:47875",
	"44230:12636:44407:2861:3305:47927",
	"44230:12636:44407:2861:13177:48321:48318",
	"44230:12636:44407:2861:13177:48321",
	"44232:37888:37915:44825:50463",
	"44230:12636:44407:2861:13177:43086:6026:85734",
	"44230:12636:238480:241031:251081:242011",
	"44230:12636:238480:242913:239639:246560",
	"44230:12636:238480:241031:249150",
	"44230:12636:238480:241031:241036",
	"44230:12636:238480:241031",
	"44230:12636:238480:241031:251081",
	"44230:12636:238480:241031:251073",
	"44230:12636:238480:242913:239639",
	"44230:12636:238480:242913:246564",
	"44230:12636:238480:242913",
	"44230:12636:238480",
	--["name"] = "Northpass Tower, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 2204513954,
	["direct"] = "44233:44230:44232",
	["f"] = 0,
	},
	[44825] = {
	"2226:2389",
	"2226:2389:2851",
	"2226:2389:2851:2861:2858",
	"2226:2389:2851:2861:1387",
	"2226:2389:2851:2861",
	"2226:2389:2851:2861:13177:43086:6026",
	"37915:37888:12636",
	"2226:2389:2851:2861:13177",
	"2226:2389:2851:2861:3305",
	"37915:46004:43573:4314",
	"37915:46004:46011:47875:44233",
	"37915:37888:44232:28621",
	"37915:37888:44232:44231:44230",
	"37915:37888:44232",
	"37915:37888",
	"2226:2389:2851:2861:1387:43053",
	"2226:2389:2851:2861:1387:43052",
	"2226:2389:2851:2861:13177:43086",
	"XY-1887477213:43220",
	"37915:46004:43573",
	"37915:37888:44232:44231",
	"2226:2389:2851:2861:44408",
	"2226:2389:2851:2861:44407",
	"2226:46552:XY-1742964349",
	"37915:46004",
	"37915:46004:46011",
	"2226:46552",
	"2226:2389:2851:XY-2582931773:47116",
	"2226:2389:2851:XY-2582931773:XY-2473159877:47133",
	"2226:2389:2851:XY-2582931773:XY-2473159877",
	"2226:2389:2851:XY-2582931773:47061",
	"2226:2389:2851:XY-2582931773",
	"2226:46552:47655:47644",
	"2226:46552:47655",
	"2226:46552:47655:47644:47661",
	"37915:47665",
	"37915:46004:46011:47875",
	"2226:2389:2851:2861:3305:47927",
	"2226:2389:2851:2861:13177:48321:48318",
	"2226:2389:2851:2861:13177:48321",
	"2226:2389:2851:2861:13177:43086:6026:85734",
	"37915:37888:12636:238480:241031:251081:242011",
	"37915:37888:12636:238480:242913:239639:246560",
	"37915:37888:12636:238480:241031:249150",
	"37915:37888:12636:238480:241031:241036",
	"37915:37888:12636:238480:241031",
	"37915:37888:12636:238480:241031:251081",
	"37915:37888:12636:238480:241031:251073",
	"37915:37888:12636:238480:242913:239639",
	"37915:37888:12636:238480:242913:246564",
	"37915:37888:12636:238480:242913",
	"37915:37888:12636:238480",
	--["name"] = "Forsaken High Command, Silverpine Forest",
	["m"] = 21,
	["coord"] = 2486769270,
	["direct"] = "2226:XY-1887477213:37915:XY-1876468864:50463",
	["f"] = 0,
	},
	[238480] = {
	"12636:37888:37915:44825:2226",
	"12636:37888:XY-1887477213",
	"12636:37888:2389",
	"12636:4314:2851",
	"12636:44407:2861:2858",
	"12636:44407:2861:1387",
	"12636:44407:2861",
	"12636:44407:2861:13177:43086:6026",
	"12636:44407:2861:13177",
	"12636:44407:2861:3305",
	"12636:4314",
	"12636:44230:44233",
	"12636:44230:28621",
	"12636:44230",
	"12636:44231:44232",
	"12636:37888",
	"12636:37888:37915",
	"12636:37888:37915:XY-1876468864",
	"12636:44407:2861:1387:43053",
	"12636:44407:2861:1387:43052",
	"12636:44407:2861:13177:43086",
	"12636:37888:XY-1887477213:43220",
	"12636:37888:43573",
	"12636:44231",
	"12636:44407:44408",
	"12636:44407",
	"12636:37888:37915:44825",
	"12636:37888:37915:44825:2226:46552:XY-1742964349",
	"12636:37888:46011:46004",
	"12636:37888:46011",
	"12636:37888:37915:44825:2226:46552",
	"12636:4314:2851:XY-2582931773:47116",
	"12636:4314:2851:XY-2582931773:XY-2473159877:47133",
	"12636:4314:2851:XY-2582931773:XY-2473159877",
	"12636:4314:2851:XY-2582931773:47061",
	"12636:4314:2851:XY-2582931773",
	"12636:37888:2389:47644",
	"12636:37888:2389:47644:47655",
	"12636:37888:2389:47661",
	"12636:37888:37915:47665",
	"12636:44230:44233:47875",
	"12636:44407:2861:3305:47927",
	"12636:44407:2861:13177:48321:48318",
	"12636:44407:2861:13177:48321",
	"12636:37888:37915:44825:50463",
	"12636:44407:2861:13177:43086:6026:85734",
	"241031:251081:242011",
	"242913:239639:246560",
	"241031:249150",
	"241031:241036",
	"241031:251081",
	"241031:251073",
	"242913:239639",
	"242913:246564",
	--["name"] = "Tranquillien, Eversong Woods",
	["m"] = 2395,
	["f"] = 0,
	["direct"] = "12636:241031:242913",
	["coord"] = 2053417953,
	},
	[43573] = {
	"2389:2226",
	"46004:37915:XY-1887477213",
	"2851:2861:2858",
	"2851:2861:1387",
	"2851:2861",
	"2851:2861:13177:43086:6026",
	"37888:12636",
	"2851:2861:13177",
	"2851:2861:3305",
	"37888:44232:44233",
	"37888:44232:28621",
	"37888:44232:44231:44230",
	"37888:44232",
	"46004:37915",
	"46004:37915:XY-1876468864",
	"2851:2861:1387:43053",
	"2851:2861:1387:43052",
	"2851:2861:13177:43086",
	"2851:2861:3305:43220",
	"37888:44232:44231",
	"2851:2861:44408",
	"2851:2861:44407",
	"46004:37915:44825",
	"2389:47644:47655:46552:XY-1742964349",
	"46004:46011",
	"2389:47644:47655:46552",
	"2851:XY-2582931773:47116",
	"2851:XY-2582931773:XY-2473159877:47133",
	"2851:XY-2582931773:XY-2473159877",
	"2851:XY-2582931773:47061",
	"2851:XY-2582931773",
	"2389:47644",
	"2389:47644:47655",
	"2389:47661",
	"2389:47665",
	"46004:46011:47875",
	"2851:2861:3305:47927",
	"2851:2861:13177:48321:48318",
	"2851:2861:13177:48321",
	"46004:37915:44825:50463",
	"2851:2861:13177:43086:6026:85734",
	"37888:12636:238480:241031:251081:242011",
	"37888:12636:238480:242913:239639:246560",
	"37888:12636:238480:241031:249150",
	"37888:12636:238480:241031:241036",
	"37888:12636:238480:241031",
	"37888:12636:238480:241031:251081",
	"37888:12636:238480:241031:251073",
	"37888:12636:238480:242913:239639",
	"37888:12636:238480:242913:246564",
	"37888:12636:238480:242913",
	"37888:12636:238480",
	--["name"] = "Hiri'watha Research Station, The Hinterlands",
	["m"] = 26,
	["coord"] = 1390908635,
	["direct"] = "2389:2851:4314:37888:46004",
	["f"] = 0,
	},
	[246560] = {
	"239639:242913:238480:12636:37888:37915:44825:2226",
	"239639:242913:238480:12636:37888:XY-1887477213",
	"239639:242913:238480:12636:37888:2389",
	"239639:242913:238480:12636:4314:2851",
	"239639:242913:238480:12636:44407:2861:2858",
	"239639:242913:238480:12636:44407:2861:1387",
	"239639:242913:238480:12636:44407:2861",
	"239639:242913:238480:12636:44407:2861:13177:43086:6026",
	"239639:242913:238480:12636",
	"239639:242913:238480:12636:44407:2861:13177",
	"239639:242913:238480:12636:44407:2861:3305",
	"239639:242913:238480:12636:4314",
	"239639:242913:238480:12636:44230:44233",
	"239639:242913:238480:12636:44230:28621",
	"239639:242913:238480:12636:44230",
	"239639:242913:238480:12636:44231:44232",
	"239639:242913:238480:12636:37888",
	"239639:242913:238480:12636:37888:37915",
	"239639:242913:238480:12636:37888:37915:XY-1876468864",
	"239639:242913:238480:12636:44407:2861:1387:43053",
	"239639:242913:238480:12636:44407:2861:1387:43052",
	"239639:242913:238480:12636:44407:2861:13177:43086",
	"239639:242913:238480:12636:37888:XY-1887477213:43220",
	"239639:242913:238480:12636:37888:43573",
	"239639:242913:238480:12636:44231",
	"239639:242913:238480:12636:44407:44408",
	"239639:242913:238480:12636:44407",
	"239639:242913:238480:12636:37888:37915:44825",
	"239639:242913:238480:12636:37888:37915:44825:2226:46552:XY-1742964349",
	"239639:242913:238480:12636:37888:46011:46004",
	"239639:242913:238480:12636:37888:46011",
	"239639:242913:238480:12636:37888:37915:44825:2226:46552",
	"239639:242913:238480:12636:4314:2851:XY-2582931773:47116",
	"239639:242913:238480:12636:4314:2851:XY-2582931773:XY-2473159877:47133",
	"239639:242913:238480:12636:4314:2851:XY-2582931773:XY-2473159877",
	"239639:242913:238480:12636:4314:2851:XY-2582931773:47061",
	"239639:242913:238480:12636:4314:2851:XY-2582931773",
	"239639:242913:238480:12636:37888:2389:47644",
	"239639:242913:238480:12636:37888:2389:47644:47655",
	"239639:242913:238480:12636:37888:2389:47661",
	"239639:242913:238480:12636:37888:37915:47665",
	"239639:242913:238480:12636:44230:44233:47875",
	"239639:242913:238480:12636:44407:2861:3305:47927",
	"239639:242913:238480:12636:44407:2861:13177:48321:48318",
	"239639:242913:238480:12636:44407:2861:13177:48321",
	"239639:242913:238480:12636:37888:37915:44825:50463",
	"239639:242913:238480:12636:44407:2861:13177:43086:6026:85734",
	"239639:251073:242011",
	"239639:242913:238480:241031:249150",
	"239639:251073:251081:241036",
	"239639:242913:238480:241031",
	"239639:251073:251081",
	"239639:251073",
	"239639:242913",
	"239639:242913:238480",
	--["name"] = "Terrace of the Sun, Isle of Quel'Danas",
	["m"] = 2424,
	["f"] = 0,
	["direct"] = "239639:246564",
	["coord"] = 2472236746,
	},
	[2226] = {
	"2389:2851",
	"2389:2851:2861:2858",
	"2389:2851:2861:1387",
	"2389:2851:2861",
	"2389:2851:2861:13177:43086:6026",
	"44825:37915:37888:12636",
	"2389:2851:2861:13177",
	"2389:2851:2861:3305",
	"2389:4314",
	"44825:37915:46004:46011:47875:44233",
	"44825:37915:37888:44232:28621",
	"44825:37915:37888:44232:44231:44230",
	"44825:37915:37888:44232",
	"44825:37915:37888",
	"44825:37915",
	"44825:XY-1876468864",
	"2389:2851:2861:1387:43053",
	"2389:2851:2861:1387:43052",
	"2389:2851:2861:13177:43086",
	"XY-1887477213:43220",
	"2389:43573",
	"44825:37915:37888:44232:44231",
	"2389:2851:2861:44408",
	"2389:2851:2861:44407",
	"44825:37915:46004",
	"44825:37915:46004:46011",
	"2389:2851:XY-2582931773:47116",
	"2389:2851:XY-2582931773:XY-2473159877:47133",
	"2389:2851:XY-2582931773:XY-2473159877",
	"2389:2851:XY-2582931773:47061",
	"2389:2851:XY-2582931773",
	"46552:47655:47644",
	"46552:47655",
	"46552:47655:47644:47661",
	"2389:47665",
	"44825:37915:46004:46011:47875",
	"2389:2851:2861:3305:47927",
	"2389:2851:2861:13177:48321:48318",
	"2389:2851:2861:13177:48321",
	"2389:2851:2861:13177:43086:6026:85734",
	"44825:37915:37888:12636:238480:241031:251081:242011",
	"44825:37915:37888:12636:238480:242913:239639:246560",
	"44825:37915:37888:12636:238480:241031:249150",
	"44825:37915:37888:12636:238480:241031:241036",
	"44825:37915:37888:12636:238480:241031",
	"44825:37915:37888:12636:238480:241031:251081",
	"44825:37915:37888:12636:238480:241031:251073",
	"44825:37915:37888:12636:238480:242913:239639",
	"44825:37915:37888:12636:238480:242913:246564",
	"44825:37915:37888:12636:238480:242913",
	"44825:37915:37888:12636:238480",
	--["name"] = "The Sepulcher, Silverpine Forest",
	["m"] = 21,
	["coord"] = 1951558850,
	["direct"] = "XY-1887477213:2389:44825:XY-1742964349:46552:50463",
	["f"] = 0,
	},
	[3305] = {
	"2861:2851:2389:2226",
	"43220:XY-1887477213",
	"2861:2851:2389",
	"2861:2851",
	"13177:1387:2858",
	"13177:1387",
	"13177:43086:6026",
	"2861:44407:12636",
	"2861:2851:4314",
	"2861:2851:43573:37888:44232:44233",
	"2861:44407:12636:44230:28621",
	"2861:44407:12636:44230",
	"2861:2851:43573:37888:44232",
	"2861:2851:43573:37888",
	"2861:2851:43573:46004:37915",
	"2861:2851:43573:46004:37915:XY-1876468864",
	"13177:1387:43053",
	"13177:1387:43052",
	"13177:43086",
	"2861:2851:43573",
	"2861:2851:43573:37888:44232:44231",
	"2861:44408",
	"2861:44407",
	"2861:2851:43573:46004:37915:44825",
	"2861:2851:2389:47644:47655:46552:XY-1742964349",
	"2861:2851:43573:46004",
	"2861:2851:43573:46004:46011",
	"2861:2851:2389:47644:47655:46552",
	"2861:XY-2582931773:47116",
	"2861:XY-2582931773:XY-2473159877:47133",
	"2861:XY-2582931773:XY-2473159877",
	"2861:XY-2582931773:47061",
	"2861:XY-2582931773",
	"2861:2851:2389:47644",
	"2861:2851:2389:47644:47655",
	"2861:2851:2389:47661",
	"2861:2851:2389:47665",
	"2861:2851:43573:46004:46011:47875",
	"47927:48318",
	"13177:48321",
	"2861:2851:43573:46004:37915:44825:50463",
	"13177:43086:6026:85734",
	"2861:44407:12636:238480:241031:251081:242011",
	"2861:44407:12636:238480:242913:239639:246560",
	"2861:44407:12636:238480:241031:249150",
	"2861:44407:12636:238480:241031:241036",
	"2861:44407:12636:238480:241031",
	"2861:44407:12636:238480:241031:251081",
	"2861:44407:12636:238480:241031:251073",
	"2861:44407:12636:238480:242913:239639",
	"2861:44407:12636:238480:242913:246564",
	"2861:44407:12636:238480:242913",
	"2861:44407:12636:238480",
	--["name"] = "Thorium Point, Searing Gorge",
	["m"] = 32,
	["f"] = 0,
	["direct"] = "2861:13177:43220:47927",
	["coord"] = 1497714298,
	},
	[44408] = {
	"2861:2851:2389:2226",
	"2861:XY-1887477213",
	"2861:2851:2389",
	"2861:2851",
	"2861:2858",
	"2861:1387",
	"2861:13177:43086:6026",
	"44407:12636",
	"2861:13177",
	"2861:3305",
	"2861:2851:4314",
	"44407:12636:44230:44233",
	"44407:12636:44230:28621",
	"44407:12636:44230",
	"44407:12636:44231:44232",
	"2861:2851:43573:37888",
	"2861:2851:43573:46004:37915",
	"2861:2851:43573:46004:37915:XY-1876468864",
	"2861:1387:43053",
	"2861:1387:43052",
	"2861:13177:43086",
	"2861:3305:43220",
	"2861:2851:43573",
	"44407:12636:44231",
	"2861:2851:43573:46004:37915:44825",
	"2861:2851:2389:47644:47655:46552:XY-1742964349",
	"2861:2851:43573:46004",
	"2861:2851:43573:46004:46011",
	"2861:2851:2389:47644:47655:46552",
	"2861:XY-2582931773:47116",
	"2861:XY-2582931773:XY-2473159877:47133",
	"2861:XY-2582931773:XY-2473159877",
	"2861:XY-2582931773:47061",
	"2861:XY-2582931773",
	"2861:2851:2389:47644",
	"2861:2851:2389:47644:47655",
	"2861:2851:2389:47661",
	"2861:2851:2389:47665",
	"2861:2851:43573:46004:46011:47875",
	"2861:3305:47927",
	"2861:13177:48321:48318",
	"2861:13177:48321",
	"2861:2851:43573:46004:37915:44825:50463",
	"2861:13177:43086:6026:85734",
	"44407:12636:238480:241031:251081:242011",
	"44407:12636:238480:242913:239639:246560",
	"44407:12636:238480:241031:249150",
	"44407:12636:238480:241031:241036",
	"44407:12636:238480:241031",
	"44407:12636:238480:241031:251081",
	"44407:12636:238480:241031:251073",
	"44407:12636:238480:242913:239639",
	"44407:12636:238480:242913:246564",
	"44407:12636:238480:242913",
	"44407:12636:238480",
	--["name"] = "Bloodwatcher Point, Badlands",
	["m"] = 15,
	["f"] = 0,
	["direct"] = "2861:44407",
	["coord"] = 2249425402,
	},
	[46552] = {
	"2226:XY-1887477213",
	"47655:47644:2389",
	"47655:47644:2389:2851",
	"47655:47644:2389:2851:2861:2858",
	"47655:47644:2389:2851:2861:1387",
	"47655:47644:2389:2851:2861",
	"47655:47644:2389:2851:2861:13177:43086:6026",
	"47655:47644:2389:37888:12636",
	"47655:47644:2389:2851:2861:13177",
	"47655:47644:2389:2851:2861:3305",
	"47655:47644:2389:4314",
	"47655:47644:2389:37888:44232:44233",
	"47655:47644:2389:37888:44232:28621",
	"47655:47644:2389:37888:44232:44231:44230",
	"47655:47644:2389:37888:44232",
	"47655:47644:2389:37888",
	"2226:44825:37915",
	"2226:44825:XY-1876468864",
	"47655:47644:2389:2851:2861:1387:43053",
	"47655:47644:2389:2851:2861:1387:43052",
	"47655:47644:2389:2851:2861:13177:43086",
	"2226:XY-1887477213:43220",
	"47655:47644:2389:43573",
	"47655:47644:2389:37888:44232:44231",
	"47655:47644:2389:2851:2861:44408",
	"47655:47644:2389:2851:2861:44407",
	"2226:44825",
	"2226:44825:37915:46004",
	"2226:44825:37915:46004:46011",
	"47655:47644:2389:2851:XY-2582931773:47116",
	"47655:47644:2389:2851:XY-2582931773:XY-2473159877:47133",
	"47655:47644:2389:2851:XY-2582931773:XY-2473159877",
	"47655:47644:2389:2851:XY-2582931773:47061",
	"47655:47644:2389:2851:XY-2582931773",
	"47655:47644",
	"47655:47644:47661",
	"47655:47644:2389:47665",
	"2226:44825:37915:46004:46011:47875",
	"47655:47644:2389:2851:2861:3305:47927",
	"47655:47644:2389:2851:2861:13177:48321:48318",
	"47655:47644:2389:2851:2861:13177:48321",
	"2226:50463",
	"47655:47644:2389:2851:2861:13177:43086:6026:85734",
	"47655:47644:2389:37888:12636:238480:241031:251081:242011",
	"47655:47644:2389:37888:12636:238480:242913:239639:246560",
	"47655:47644:2389:37888:12636:238480:241031:249150",
	"47655:47644:2389:37888:12636:238480:241031:241036",
	"47655:47644:2389:37888:12636:238480:241031",
	"47655:47644:2389:37888:12636:238480:241031:251081",
	"47655:47644:2389:37888:12636:238480:241031:251073",
	"47655:47644:2389:37888:12636:238480:242913:239639",
	"47655:47644:2389:37888:12636:238480:242913:246564",
	"47655:47644:2389:37888:12636:238480:242913",
	"47655:47644:2389:37888:12636:238480",
	--["name"] = "The Forsaken Front, Silverpine Forest",
	["m"] = 21,
	["coord"] = 2185142992,
	["direct"] = "2226:XY-1742964349:47655",
	["f"] = 0,
	},
	[48318] = {
	"48321:13177:2861:2851:2389:2226",
	"47927:3305:43220:XY-1887477213",
	"48321:13177:2861:2851:2389",
	"48321:13177:2861:2851",
	"48321:13177:1387:2858",
	"48321:13177:1387",
	"48321:13177:2861",
	"48321:13177:43086:6026",
	"48321:13177:2861:44407:12636",
	"48321:13177",
	"47927:3305",
	"48321:13177:2861:2851:4314",
	"48321:13177:2861:2851:43573:37888:44232:44233",
	"48321:13177:2861:44407:12636:44230:28621",
	"48321:13177:2861:44407:12636:44230",
	"48321:13177:2861:2851:43573:37888:44232",
	"48321:13177:2861:2851:43573:37888",
	"48321:13177:2861:2851:43573:46004:37915",
	"48321:13177:2861:2851:43573:46004:37915:XY-1876468864",
	"48321:13177:1387:43053",
	"48321:13177:1387:43052",
	"48321:13177:43086",
	"47927:3305:43220",
	"48321:13177:2861:2851:43573",
	"48321:13177:2861:2851:43573:37888:44232:44231",
	"48321:13177:2861:44408",
	"48321:13177:2861:44407",
	"48321:13177:2861:2851:43573:46004:37915:44825",
	"48321:13177:2861:2851:2389:47644:47655:46552:XY-1742964349",
	"48321:13177:2861:2851:43573:46004",
	"48321:13177:2861:2851:43573:46004:46011",
	"48321:13177:2861:2851:2389:47644:47655:46552",
	"48321:13177:2861:XY-2582931773:47116",
	"48321:13177:2861:XY-2582931773:XY-2473159877:47133",
	"48321:13177:2861:XY-2582931773:XY-2473159877",
	"48321:13177:2861:XY-2582931773:47061",
	"48321:13177:2861:XY-2582931773",
	"48321:13177:2861:2851:2389:47644",
	"48321:13177:2861:2851:2389:47644:47655",
	"48321:13177:2861:2851:2389:47661",
	"48321:13177:2861:2851:2389:47665",
	"48321:13177:2861:2851:43573:46004:46011:47875",
	"48321:13177:2861:2851:43573:46004:37915:44825:50463",
	"48321:13177:43086:6026:85734",
	"48321:13177:2861:44407:12636:238480:241031:251081:242011",
	"48321:13177:2861:44407:12636:238480:242913:239639:246560",
	"48321:13177:2861:44407:12636:238480:241031:249150",
	"48321:13177:2861:44407:12636:238480:241031:241036",
	"48321:13177:2861:44407:12636:238480:241031",
	"48321:13177:2861:44407:12636:238480:241031:251081",
	"48321:13177:2861:44407:12636:238480:241031:251073",
	"48321:13177:2861:44407:12636:238480:242913:239639",
	"48321:13177:2861:44407:12636:238480:242913:246564",
	"48321:13177:2861:44407:12636:238480:242913",
	"48321:13177:2861:44407:12636:238480",
	--["name"] = "Flamestar Post, Burning Steppes",
	["m"] = 36,
	["f"] = 0,
	["direct"] = "47927:48321",
	["coord"] = 764708591,
	},
	[37915] = {
	"44825:2226",
	"46004:43573:2851",
	"46004:43573:2851:2861:2858",
	"46004:43573:2851:2861:1387",
	"46004:43573:2851:2861",
	"46004:43573:2851:2861:13177:43086:6026",
	"37888:12636",
	"46004:43573:2851:2861:13177",
	"46004:43573:2851:2861:3305",
	"46004:43573:4314",
	"46004:46011:47875:44233",
	"37888:44232:28621",
	"37888:44232:44231:44230",
	"37888:44232",
	"46004:43573:2851:2861:1387:43053",
	"46004:43573:2851:2861:1387:43052",
	"46004:43573:2851:2861:13177:43086",
	"XY-1887477213:43220",
	"46004:43573",
	"37888:44232:44231",
	"46004:43573:2851:2861:44408",
	"46004:43573:2851:2861:44407",
	"44825:2226:46552:XY-1742964349",
	"46004:46011",
	"44825:2226:46552",
	"46004:43573:2851:XY-2582931773:47116",
	"46004:43573:2851:XY-2582931773:XY-2473159877:47133",
	"46004:43573:2851:XY-2582931773:XY-2473159877",
	"46004:43573:2851:XY-2582931773:47061",
	"46004:43573:2851:XY-2582931773",
	"2389:47644",
	"2389:47644:47655",
	"2389:47661",
	"46004:46011:47875",
	"46004:43573:2851:2861:3305:47927",
	"46004:43573:2851:2861:13177:48321:48318",
	"46004:43573:2851:2861:13177:48321",
	"44825:50463",
	"46004:43573:2851:2861:13177:43086:6026:85734",
	"37888:12636:238480:241031:251081:242011",
	"37888:12636:238480:242913:239639:246560",
	"37888:12636:238480:241031:249150",
	"37888:12636:238480:241031:241036",
	"37888:12636:238480:241031",
	"37888:12636:238480:241031:251081",
	"37888:12636:238480:241031:251073",
	"37888:12636:238480:242913:239639",
	"37888:12636:238480:242913:246564",
	"37888:12636:238480:242913",
	"37888:12636:238480",
	--["name"] = "The Bulwark, Tirisfal",
	["m"] = 18,
	["coord"] = 3587421025,
	["direct"] = "XY-1887477213:2389:37888:XY-1876468864:44825:46004:47665",
	["f"] = 0,
	},
	[44231] = {
	"44232:37888:37915:44825:2226",
	"44232:37888:XY-1887477213",
	"44232:37888:2389",
	"44232:37888:43573:2851",
	"12636:44407:2861:2858",
	"12636:44407:2861:1387",
	"12636:44407:2861",
	"12636:44407:2861:13177:43086:6026",
	"12636:44407:2861:13177",
	"12636:44407:2861:3305",
	"12636:4314",
	"44230:28621",
	"44232:37888",
	"44232:37888:37915",
	"44232:37888:37915:XY-1876468864",
	"12636:44407:2861:1387:43053",
	"12636:44407:2861:1387:43052",
	"12636:44407:2861:13177:43086",
	"44232:37888:XY-1887477213:43220",
	"44232:37888:43573",
	"12636:44407:44408",
	"12636:44407",
	"44232:37888:37915:44825",
	"44232:37888:37915:44825:2226:46552:XY-1742964349",
	"44232:37888:46011:46004",
	"44232:37888:46011",
	"44232:37888:37915:44825:2226:46552",
	"44232:37888:43573:2851:XY-2582931773:47116",
	"44232:37888:43573:2851:XY-2582931773:XY-2473159877:47133",
	"44232:37888:43573:2851:XY-2582931773:XY-2473159877",
	"44232:37888:43573:2851:XY-2582931773:47061",
	"44232:37888:43573:2851:XY-2582931773",
	"44232:37888:2389:47644",
	"44232:37888:2389:47644:47655",
	"44232:37888:2389:47661",
	"44232:37888:37915:47665",
	"44233:47875",
	"12636:44407:2861:3305:47927",
	"12636:44407:2861:13177:48321:48318",
	"12636:44407:2861:13177:48321",
	"44232:37888:37915:44825:50463",
	"12636:44407:2861:13177:43086:6026:85734",
	"12636:238480:241031:251081:242011",
	"12636:238480:242913:239639:246560",
	"12636:238480:241031:249150",
	"12636:238480:241031:241036",
	"12636:238480:241031",
	"12636:238480:241031:251081",
	"12636:238480:241031:251073",
	"12636:238480:242913:239639",
	"12636:238480:242913:246564",
	"12636:238480:242913",
	"12636:238480",
	--["name"] = "Light's Shield Tower, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 2262927709,
	["direct"] = "12636:44233:44230:44232",
	["f"] = 0,
	},
	[44233] = {
	"44232:37888:37915:44825:2226",
	"44232:37888:XY-1887477213",
	"44232:37888:2389",
	"44232:37888:43573:2851",
	"44230:12636:44407:2861:2858",
	"44230:12636:44407:2861:1387",
	"44230:12636:44407:2861",
	"44230:12636:44407:2861:13177:43086:6026",
	"44230:12636",
	"44230:12636:44407:2861:13177",
	"44230:12636:44407:2861:3305",
	"44230:12636:4314",
	"44232:37888",
	"44232:37888:37915",
	"44232:37888:37915:XY-1876468864",
	"44230:12636:44407:2861:1387:43053",
	"44230:12636:44407:2861:1387:43052",
	"44230:12636:44407:2861:13177:43086",
	"44232:37888:XY-1887477213:43220",
	"44232:37888:43573",
	"44230:12636:44407:44408",
	"44230:12636:44407",
	"44232:37888:37915:44825",
	"44232:37888:37915:44825:2226:46552:XY-1742964349",
	"47875:46011:46004",
	"47875:46011",
	"44232:37888:37915:44825:2226:46552",
	"44232:37888:43573:2851:XY-2582931773:47116",
	"44232:37888:43573:2851:XY-2582931773:XY-2473159877:47133",
	"44232:37888:43573:2851:XY-2582931773:XY-2473159877",
	"44232:37888:43573:2851:XY-2582931773:47061",
	"44232:37888:43573:2851:XY-2582931773",
	"44232:37888:2389:47644",
	"44232:37888:2389:47644:47655",
	"44232:37888:2389:47661",
	"44232:37888:37915:47665",
	"44230:12636:44407:2861:3305:47927",
	"44230:12636:44407:2861:13177:48321:48318",
	"44230:12636:44407:2861:13177:48321",
	"44232:37888:37915:44825:50463",
	"44230:12636:44407:2861:13177:43086:6026:85734",
	"44230:12636:238480:241031:251081:242011",
	"44230:12636:238480:242913:239639:246560",
	"44230:12636:238480:241031:249150",
	"44230:12636:238480:241031:241036",
	"44230:12636:238480:241031",
	"44230:12636:238480:241031:251081",
	"44230:12636:238480:241031:251073",
	"44230:12636:238480:242913:239639",
	"44230:12636:238480:242913:246564",
	"44230:12636:238480:242913",
	"44230:12636:238480",
	--["name"] = "Plaguewood Tower, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 794904154,
	["direct"] = "28621:44230:44232:44231:47875",
	["f"] = 0,
	},
	[47133] = {
	"XY-2473159877:XY-2582931773:2851:2389:2226",
	"XY-2473159877:XY-2582931773:2851:43573:46004:37915:XY-1887477213",
	"XY-2473159877:XY-2582931773:2851:2389",
	"XY-2473159877:XY-2582931773:2851",
	"XY-2473159877:XY-2582931773:2861:2858",
	"XY-2473159877:XY-2582931773:2861:1387",
	"XY-2473159877:XY-2582931773:2861",
	"XY-2473159877:XY-2582931773:2861:13177:43086:6026",
	"XY-2473159877:XY-2582931773:2851:43573:37888:12636",
	"XY-2473159877:XY-2582931773:2861:13177",
	"XY-2473159877:XY-2582931773:2861:3305",
	"XY-2473159877:XY-2582931773:2851:4314",
	"XY-2473159877:XY-2582931773:2851:43573:37888:44232:44233",
	"XY-2473159877:XY-2582931773:2851:43573:37888:44232:28621",
	"XY-2473159877:XY-2582931773:2851:43573:37888:44232:44231:44230",
	"XY-2473159877:XY-2582931773:2851:43573:37888:44232",
	"XY-2473159877:XY-2582931773:2851:43573:37888",
	"XY-2473159877:XY-2582931773:2851:43573:46004:37915",
	"XY-2473159877:XY-2582931773:2851:43573:46004:37915:XY-1876468864",
	"XY-2473159877:XY-2582931773:2861:1387:43053",
	"XY-2473159877:XY-2582931773:2861:1387:43052",
	"XY-2473159877:XY-2582931773:2861:13177:43086",
	"XY-2473159877:XY-2582931773:2861:3305:43220",
	"XY-2473159877:XY-2582931773:2851:43573",
	"XY-2473159877:XY-2582931773:2851:43573:37888:44232:44231",
	"XY-2473159877:XY-2582931773:2861:44408",
	"XY-2473159877:XY-2582931773:2861:44407",
	"XY-2473159877:XY-2582931773:2851:43573:46004:37915:44825",
	"XY-2473159877:XY-2582931773:2851:2389:47644:47655:46552:XY-1742964349",
	"XY-2473159877:XY-2582931773:2851:43573:46004",
	"XY-2473159877:XY-2582931773:2851:43573:46004:46011",
	"XY-2473159877:XY-2582931773:2851:2389:47644:47655:46552",
	"XY-2473159877:47061",
	"XY-2473159877:XY-2582931773",
	"XY-2473159877:XY-2582931773:2851:2389:47644",
	"XY-2473159877:XY-2582931773:2851:2389:47644:47655",
	"XY-2473159877:XY-2582931773:2851:2389:47661",
	"XY-2473159877:XY-2582931773:2851:2389:47665",
	"XY-2473159877:XY-2582931773:2851:43573:46004:46011:47875",
	"XY-2473159877:XY-2582931773:2861:3305:47927",
	"XY-2473159877:XY-2582931773:2861:13177:48321:48318",
	"XY-2473159877:XY-2582931773:2861:13177:48321",
	"XY-2473159877:XY-2582931773:2851:43573:46004:37915:44825:50463",
	"XY-2473159877:XY-2582931773:2861:13177:43086:6026:85734",
	"XY-2473159877:XY-2582931773:2851:43573:37888:12636:238480:241031:251081:242011",
	"XY-2473159877:XY-2582931773:2851:43573:37888:12636:238480:242913:239639:246560",
	"XY-2473159877:XY-2582931773:2851:43573:37888:12636:238480:241031:249150",
	"XY-2473159877:XY-2582931773:2851:43573:37888:12636:238480:241031:241036",
	"XY-2473159877:XY-2582931773:2851:43573:37888:12636:238480:241031",
	"XY-2473159877:XY-2582931773:2851:43573:37888:12636:238480:241031:251081",
	"XY-2473159877:XY-2582931773:2851:43573:37888:12636:238480:241031:251073",
	"XY-2473159877:XY-2582931773:2851:43573:37888:12636:238480:242913:239639",
	"XY-2473159877:XY-2582931773:2851:43573:37888:12636:238480:242913:246564",
	"XY-2473159877:XY-2582931773:2851:43573:37888:12636:238480:242913",
	"XY-2473159877:XY-2582931773:2851:43573:37888:12636:238480",
	--["name"] = "The Gullet, Twilight Highlands",
	["m"] = 241,
	["coord"] = 1582457212,
	["direct"] = "47116:XY-2473159877",
	["f"] = 0,
	},
	[6026] = {
	"43086:13177:2861:2851:2389:2226",
	"43086:13177:2861:XY-1887477213",
	"43086:13177:2861:2851:2389",
	"43086:13177:2861:2851",
	"43086:13177:2861:44407:12636",
	"43086:13177:3305",
	"43086:13177:2861:2851:4314",
	"43086:13177:2861:2851:43573:37888:44232:44233",
	"43086:13177:2861:44407:12636:44230:28621",
	"43086:13177:2861:44407:12636:44230",
	"43086:13177:2861:2851:43573:37888:44232",
	"43086:13177:2861:2851:43573:37888",
	"43086:13177:2861:2851:43573:46004:37915",
	"43086:13177:2861:2851:43573:46004:37915:XY-1876468864",
	"1387:43053",
	"85734:43052",
	"43086:13177:3305:43220",
	"43086:13177:2861:2851:43573",
	"43086:13177:2861:2851:43573:37888:44232:44231",
	"43086:13177:2861:44408",
	"43086:13177:2861:44407",
	"43086:13177:2861:2851:43573:46004:37915:44825",
	"43086:13177:2861:2851:2389:47644:47655:46552:XY-1742964349",
	"43086:13177:2861:2851:43573:46004",
	"43086:13177:2861:2851:43573:46004:46011",
	"43086:13177:2861:2851:2389:47644:47655:46552",
	"43086:13177:2861:XY-2582931773:47116",
	"43086:13177:2861:XY-2582931773:XY-2473159877:47133",
	"43086:13177:2861:XY-2582931773:XY-2473159877",
	"43086:13177:2861:XY-2582931773:47061",
	"43086:13177:2861:XY-2582931773",
	"43086:13177:2861:2851:2389:47644",
	"43086:13177:2861:2851:2389:47644:47655",
	"43086:13177:2861:2851:2389:47661",
	"43086:13177:2861:2851:2389:47665",
	"43086:13177:2861:2851:43573:46004:46011:47875",
	"43086:13177:48321:48318:47927",
	"43086:13177:48321:48318",
	"43086:13177:48321",
	"43086:13177:2861:2851:43573:46004:37915:44825:50463",
	"43086:13177:2861:44407:12636:238480:241031:251081:242011",
	"43086:13177:2861:44407:12636:238480:242913:239639:246560",
	"43086:13177:2861:44407:12636:238480:241031:249150",
	"43086:13177:2861:44407:12636:238480:241031:241036",
	"43086:13177:2861:44407:12636:238480:241031",
	"43086:13177:2861:44407:12636:238480:241031:251081",
	"43086:13177:2861:44407:12636:238480:241031:251073",
	"43086:13177:2861:44407:12636:238480:242913:239639",
	"43086:13177:2861:44407:12636:238480:242913:246564",
	"43086:13177:2861:44407:12636:238480:242913",
	"43086:13177:2861:44407:12636:238480",
	--["name"] = "Stonard, Swamp of Sorrows",
	["m"] = 51,
	["coord"] = 2048494949,
	["direct"] = "2858:1387:2861:13177:43086:85734",
	["f"] = 0,
	},
	[251073] = {
	"241031:238480:12636:37888:37915:44825:2226",
	"241031:238480:12636:37888:XY-1887477213",
	"241031:238480:12636:37888:2389",
	"241031:238480:12636:4314:2851",
	"241031:238480:12636:44407:2861:2858",
	"241031:238480:12636:44407:2861:1387",
	"241031:238480:12636:44407:2861",
	"241031:238480:12636:44407:2861:13177:43086:6026",
	"241031:238480:12636",
	"241031:238480:12636:44407:2861:13177",
	"241031:238480:12636:44407:2861:3305",
	"241031:238480:12636:4314",
	"241031:238480:12636:44230:44233",
	"241031:238480:12636:44230:28621",
	"241031:238480:12636:44230",
	"241031:238480:12636:44231:44232",
	"241031:238480:12636:37888",
	"241031:238480:12636:37888:37915",
	"241031:238480:12636:37888:37915:XY-1876468864",
	"241031:238480:12636:44407:2861:1387:43053",
	"241031:238480:12636:44407:2861:1387:43052",
	"241031:238480:12636:44407:2861:13177:43086",
	"241031:238480:12636:37888:XY-1887477213:43220",
	"241031:238480:12636:37888:43573",
	"241031:238480:12636:44231",
	"241031:238480:12636:44407:44408",
	"241031:238480:12636:44407",
	"241031:238480:12636:37888:37915:44825",
	"241031:238480:12636:37888:37915:44825:2226:46552:XY-1742964349",
	"241031:238480:12636:37888:46011:46004",
	"241031:238480:12636:37888:46011",
	"241031:238480:12636:37888:37915:44825:2226:46552",
	"241031:238480:12636:4314:2851:XY-2582931773:47116",
	"241031:238480:12636:4314:2851:XY-2582931773:XY-2473159877:47133",
	"241031:238480:12636:4314:2851:XY-2582931773:XY-2473159877",
	"241031:238480:12636:4314:2851:XY-2582931773:47061",
	"241031:238480:12636:4314:2851:XY-2582931773",
	"241031:238480:12636:37888:2389:47644",
	"241031:238480:12636:37888:2389:47644:47655",
	"241031:238480:12636:37888:2389:47661",
	"241031:238480:12636:37888:37915:47665",
	"241031:238480:12636:44230:44233:47875",
	"241031:238480:12636:44407:2861:3305:47927",
	"241031:238480:12636:44407:2861:13177:48321:48318",
	"241031:238480:12636:44407:2861:13177:48321",
	"241031:238480:12636:37888:37915:44825:50463",
	"241031:238480:12636:44407:2861:13177:43086:6026:85734",
	"239639:246560",
	"241031:249150",
	"251081:241036",
	"241031:238480",
	--["name"] = "Witherbark Bluffs, Zul'Aman",
	["m"] = 2437,
	["f"] = 0,
	["direct"] = "242011:241031:251081:239639:246564:242913",
	["coord"] = 1668823908,
	},
	[46004] = {
	"37915:44825:2226",
	"37915:XY-1887477213",
	"37915:2389",
	"43573:2851",
	"43573:2851:2861:2858",
	"43573:2851:2861:1387",
	"43573:2851:2861",
	"43573:2851:2861:13177:43086:6026",
	"46011:37888:12636",
	"43573:2851:2861:13177",
	"43573:2851:2861:3305",
	"43573:4314",
	"46011:47875:44233",
	"46011:37888:44232:28621",
	"46011:37888:44232:44231:44230",
	"46011:37888:44232",
	"46011:37888",
	"37915:XY-1876468864",
	"43573:2851:2861:1387:43053",
	"43573:2851:2861:1387:43052",
	"43573:2851:2861:13177:43086",
	"37915:XY-1887477213:43220",
	"46011:37888:44232:44231",
	"43573:2851:2861:44408",
	"43573:2851:2861:44407",
	"37915:44825",
	"37915:44825:2226:46552:XY-1742964349",
	"37915:44825:2226:46552",
	"43573:2851:XY-2582931773:47116",
	"43573:2851:XY-2582931773:XY-2473159877:47133",
	"43573:2851:XY-2582931773:XY-2473159877",
	"43573:2851:XY-2582931773:47061",
	"43573:2851:XY-2582931773",
	"37915:2389:47644",
	"37915:2389:47644:47655",
	"37915:2389:47661",
	"37915:47665",
	"46011:47875",
	"43573:2851:2861:3305:47927",
	"43573:2851:2861:13177:48321:48318",
	"43573:2851:2861:13177:48321",
	"37915:44825:50463",
	"43573:2851:2861:13177:43086:6026:85734",
	"46011:37888:12636:238480:241031:251081:242011",
	"46011:37888:12636:238480:242913:239639:246560",
	"46011:37888:12636:238480:241031:249150",
	"46011:37888:12636:238480:241031:241036",
	"46011:37888:12636:238480:241031",
	"46011:37888:12636:238480:241031:251081",
	"46011:37888:12636:238480:241031:251073",
	"46011:37888:12636:238480:242913:239639",
	"46011:37888:12636:238480:242913:246564",
	"46011:37888:12636:238480:242913",
	"46011:37888:12636:238480",
	--["name"] = "Andorhal, Western Plaguelands",
	["m"] = 22,
	["coord"] = 2001315236,
	["direct"] = "37915:43573:46011",
	["f"] = 0,
	},
	[251081] = {
	"241031:238480:12636:37888:37915:44825:2226",
	"241031:238480:12636:37888:XY-1887477213",
	"241031:238480:12636:37888:2389",
	"241031:238480:12636:4314:2851",
	"241031:238480:12636:44407:2861:2858",
	"241031:238480:12636:44407:2861:1387",
	"241031:238480:12636:44407:2861",
	"241031:238480:12636:44407:2861:13177:43086:6026",
	"241031:238480:12636",
	"241031:238480:12636:44407:2861:13177",
	"241031:238480:12636:44407:2861:3305",
	"241031:238480:12636:4314",
	"241031:238480:12636:44230:44233",
	"241031:238480:12636:44230:28621",
	"241031:238480:12636:44230",
	"241031:238480:12636:44231:44232",
	"241031:238480:12636:37888",
	"241031:238480:12636:37888:37915",
	"241031:238480:12636:37888:37915:XY-1876468864",
	"241031:238480:12636:44407:2861:1387:43053",
	"241031:238480:12636:44407:2861:1387:43052",
	"241031:238480:12636:44407:2861:13177:43086",
	"241031:238480:12636:37888:XY-1887477213:43220",
	"241031:238480:12636:37888:43573",
	"241031:238480:12636:44231",
	"241031:238480:12636:44407:44408",
	"241031:238480:12636:44407",
	"241031:238480:12636:37888:37915:44825",
	"241031:238480:12636:37888:37915:44825:2226:46552:XY-1742964349",
	"241031:238480:12636:37888:46011:46004",
	"241031:238480:12636:37888:46011",
	"241031:238480:12636:37888:37915:44825:2226:46552",
	"241031:238480:12636:4314:2851:XY-2582931773:47116",
	"241031:238480:12636:4314:2851:XY-2582931773:XY-2473159877:47133",
	"241031:238480:12636:4314:2851:XY-2582931773:XY-2473159877",
	"241031:238480:12636:4314:2851:XY-2582931773:47061",
	"241031:238480:12636:4314:2851:XY-2582931773",
	"241031:238480:12636:37888:2389:47644",
	"241031:238480:12636:37888:2389:47644:47655",
	"241031:238480:12636:37888:2389:47661",
	"241031:238480:12636:37888:37915:47665",
	"241031:238480:12636:44230:44233:47875",
	"241031:238480:12636:44407:2861:3305:47927",
	"241031:238480:12636:44407:2861:13177:48321:48318",
	"241031:238480:12636:44407:2861:13177:48321",
	"241031:238480:12636:37888:37915:44825:50463",
	"241031:238480:12636:44407:2861:13177:43086:6026:85734",
	"251073:239639:246560",
	"241031:249150",
	"251073:239639",
	"251073:246564",
	"251073:242913",
	"241031:238480",
	--["name"] = "Shadebasin Watch, Zul'Aman",
	["m"] = 2437,
	["f"] = 0,
	["direct"] = "242011:241036:241031:251073",
	["coord"] = 1890670110,
	},
	[43053] = {
	"1387:2861:2851:2389:2226",
	"1387:2861:XY-1887477213",
	"1387:2861:2851:2389",
	"1387:2861:2851",
	"1387:2861",
	"1387:6026",
	"1387:2861:44407:12636",
	"1387:13177",
	"1387:13177:3305",
	"1387:2861:2851:4314",
	"1387:2861:2851:43573:37888:44232:44233",
	"1387:2861:44407:12636:44230:28621",
	"1387:2861:44407:12636:44230",
	"1387:2861:2851:43573:37888:44232",
	"1387:2861:2851:43573:37888",
	"1387:2861:2851:43573:46004:37915",
	"1387:2861:2851:43573:46004:37915:XY-1876468864",
	"1387:6026:43086",
	"1387:13177:3305:43220",
	"1387:2861:2851:43573",
	"1387:2861:2851:43573:37888:44232:44231",
	"1387:2861:44408",
	"1387:2861:44407",
	"1387:2861:2851:43573:46004:37915:44825",
	"1387:2861:2851:2389:47644:47655:46552:XY-1742964349",
	"1387:2861:2851:43573:46004",
	"1387:2861:2851:43573:46004:46011",
	"1387:2861:2851:2389:47644:47655:46552",
	"1387:2861:XY-2582931773:47116",
	"1387:2861:XY-2582931773:XY-2473159877:47133",
	"1387:2861:XY-2582931773:XY-2473159877",
	"1387:2861:XY-2582931773:47061",
	"1387:2861:XY-2582931773",
	"1387:2861:2851:2389:47644",
	"1387:2861:2851:2389:47644:47655",
	"1387:2861:2851:2389:47661",
	"1387:2861:2851:2389:47665",
	"1387:2861:2851:43573:46004:46011:47875",
	"1387:13177:48321:48318:47927",
	"1387:13177:48321:48318",
	"1387:13177:48321",
	"1387:2861:2851:43573:46004:37915:44825:50463",
	"43052:85734",
	"1387:2861:44407:12636:238480:241031:251081:242011",
	"1387:2861:44407:12636:238480:242913:239639:246560",
	"1387:2861:44407:12636:238480:241031:249150",
	"1387:2861:44407:12636:238480:241031:241036",
	"1387:2861:44407:12636:238480:241031",
	"1387:2861:44407:12636:238480:241031:251081",
	"1387:2861:44407:12636:238480:241031:251073",
	"1387:2861:44407:12636:238480:242913:239639",
	"1387:2861:44407:12636:238480:242913:246564",
	"1387:2861:44407:12636:238480:242913",
	"1387:2861:44407:12636:238480",
	--["name"] = "Hardwrench Hideaway, Stranglethorn",
	["m"] = 210,
	["f"] = 0,
	["direct"] = "2858:1387:43052",
	["coord"] = 1508330313,
	},
	[46011] = {
	"46004:37915:44825:2226",
	"46004:37915:XY-1887477213",
	"37888:2389",
	"46004:43573:2851",
	"46004:43573:2851:2861:2858",
	"46004:43573:2851:2861:1387",
	"46004:43573:2851:2861",
	"46004:43573:2851:2861:13177:43086:6026",
	"37888:12636",
	"46004:43573:2851:2861:13177",
	"46004:43573:2851:2861:3305",
	"46004:43573:4314",
	"47875:44233",
	"37888:44232:28621",
	"37888:44232:44231:44230",
	"37888:44232",
	"46004:37915",
	"46004:37915:XY-1876468864",
	"46004:43573:2851:2861:1387:43053",
	"46004:43573:2851:2861:1387:43052",
	"46004:43573:2851:2861:13177:43086",
	"46004:37915:XY-1887477213:43220",
	"46004:43573",
	"37888:44232:44231",
	"46004:43573:2851:2861:44408",
	"37888:12636:44407",
	"46004:37915:44825",
	"46004:37915:44825:2226:46552:XY-1742964349",
	"46004:37915:44825:2226:46552",
	"46004:43573:2851:XY-2582931773:47116",
	"46004:43573:2851:XY-2582931773:XY-2473159877:47133",
	"46004:43573:2851:XY-2582931773:XY-2473159877",
	"46004:43573:2851:XY-2582931773:47061",
	"46004:43573:2851:XY-2582931773",
	"37888:2389:47644",
	"37888:2389:47644:47655",
	"37888:2389:47661",
	"46004:37915:47665",
	"46004:43573:2851:2861:3305:47927",
	"46004:43573:2851:2861:13177:48321:48318",
	"46004:43573:2851:2861:13177:48321",
	"46004:37915:44825:50463",
	"46004:43573:2851:2861:13177:43086:6026:85734",
	"37888:12636:238480:241031:251081:242011",
	"37888:12636:238480:242913:239639:246560",
	"37888:12636:238480:241031:249150",
	"37888:12636:238480:241031:241036",
	"37888:12636:238480:241031",
	"37888:12636:238480:241031:251081",
	"37888:12636:238480:241031:251073",
	"37888:12636:238480:242913:239639",
	"37888:12636:238480:242913:246564",
	"37888:12636:238480:242913",
	"37888:12636:238480",
	--["name"] = "The Menders' Stead, Western Plaguelands",
	["m"] = 22,
	["coord"] = 2169406908,
	["direct"] = "37888:46004:47875",
	["f"] = 0,
	},
	[43052] = {
	"1387:2861:2851:2389:2226",
	"1387:2861:XY-1887477213",
	"1387:2861:2851:2389",
	"1387:2861:2851",
	"43053:2858",
	"1387:2861",
	"85734:6026",
	"1387:2861:44407:12636",
	"1387:13177",
	"1387:13177:3305",
	"1387:2861:2851:4314",
	"1387:2861:2851:43573:37888:44232:44233",
	"1387:2861:44407:12636:44230:28621",
	"1387:2861:44407:12636:44230",
	"1387:2861:2851:43573:37888:44232",
	"1387:2861:2851:43573:37888",
	"1387:2861:2851:43573:46004:37915",
	"1387:2861:2851:43573:46004:37915:XY-1876468864",
	"85734:6026:43086",
	"1387:13177:3305:43220",
	"1387:2861:2851:43573",
	"1387:2861:2851:43573:37888:44232:44231",
	"1387:2861:44408",
	"1387:2861:44407",
	"1387:2861:2851:43573:46004:37915:44825",
	"1387:2861:2851:2389:47644:47655:46552:XY-1742964349",
	"1387:2861:2851:43573:46004",
	"1387:2861:2851:43573:46004:46011",
	"1387:2861:2851:2389:47644:47655:46552",
	"1387:2861:XY-2582931773:47116",
	"1387:2861:XY-2582931773:XY-2473159877:47133",
	"1387:2861:XY-2582931773:XY-2473159877",
	"1387:2861:XY-2582931773:47061",
	"1387:2861:XY-2582931773",
	"1387:2861:2851:2389:47644",
	"1387:2861:2851:2389:47644:47655",
	"1387:2861:2851:2389:47661",
	"1387:2861:2851:2389:47665",
	"1387:2861:2851:43573:46004:46011:47875",
	"1387:13177:48321:48318:47927",
	"1387:13177:48321:48318",
	"1387:13177:48321",
	"1387:2861:2851:43573:46004:37915:44825:50463",
	"1387:2861:44407:12636:238480:241031:251081:242011",
	"1387:2861:44407:12636:238480:242913:239639:246560",
	"1387:2861:44407:12636:238480:241031:249150",
	"1387:2861:44407:12636:238480:241031:241036",
	"1387:2861:44407:12636:238480:241031",
	"1387:2861:44407:12636:238480:241031:251081",
	"1387:2861:44407:12636:238480:241031:251073",
	"1387:2861:44407:12636:238480:242913:239639",
	"1387:2861:44407:12636:238480:242913:246564",
	"1387:2861:44407:12636:238480:242913",
	"1387:2861:44407:12636:238480",
	--["name"] = "Bambala, Stranglethorn",
	["m"] = 50,
	["f"] = 0,
	["direct"] = "1387:43053:85734",
	["coord"] = 2681037946,
	},
	[37888] = {
	"37915:44825:2226",
	"43573:2851",
	"43573:2851:2861:2858",
	"43573:2851:2861:1387",
	"43573:2851:2861",
	"43573:2851:2861:13177:43086:6026",
	"43573:2851:2861:13177",
	"43573:2851:2861:3305",
	"43573:4314",
	"44232:44233",
	"44232:28621",
	"44232:44231:44230",
	"37915:XY-1876468864",
	"43573:2851:2861:1387:43053",
	"43573:2851:2861:1387:43052",
	"43573:2851:2861:13177:43086",
	"XY-1887477213:43220",
	"44232:44231",
	"43573:2851:2861:44408",
	"12636:44407",
	"37915:44825",
	"37915:44825:2226:46552:XY-1742964349",
	"46011:46004",
	"37915:44825:2226:46552",
	"43573:2851:XY-2582931773:47116",
	"43573:2851:XY-2582931773:XY-2473159877:47133",
	"43573:2851:XY-2582931773:XY-2473159877",
	"43573:2851:XY-2582931773:47061",
	"43573:2851:XY-2582931773",
	"2389:47644",
	"2389:47644:47655",
	"2389:47661",
	"37915:47665",
	"46011:47875",
	"43573:2851:2861:3305:47927",
	"43573:2851:2861:13177:48321:48318",
	"43573:2851:2861:13177:48321",
	"37915:44825:50463",
	"43573:2851:2861:13177:43086:6026:85734",
	"12636:238480:241031:251081:242011",
	"12636:238480:242913:239639:246560",
	"12636:238480:241031:249150",
	"12636:238480:241031:241036",
	"12636:238480:241031",
	"12636:238480:241031:251081",
	"12636:238480:241031:251073",
	"12636:238480:242913:239639",
	"12636:238480:242913:246564",
	"12636:238480:242913",
	"12636:238480",
	--["name"] = "Thondroril River, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 433629293,
	["direct"] = "XY-1887477213:2389:12636:44232:37915:43573:46011",
	["f"] = 0,
	},
	[4314] = {
	"43573:2389:2226",
	"2851:2861:2858",
	"2851:2861:1387",
	"2851:2861",
	"2851:2861:13177:43086:6026",
	"2851:2861:13177",
	"2851:2861:3305",
	"12636:44230:44233",
	"12636:44230:28621",
	"12636:44230",
	"43573:37888:44232",
	"43573:37888",
	"43573:46004:37915",
	"43573:46004:37915:XY-1876468864",
	"2851:2861:1387:43053",
	"2851:2861:1387:43052",
	"2851:2861:13177:43086",
	"2851:2861:3305:43220",
	"12636:44231",
	"2851:2861:44408",
	"2851:2861:44407",
	"43573:46004:37915:44825",
	"43573:2389:47644:47655:46552:XY-1742964349",
	"43573:46004",
	"43573:46004:46011",
	"43573:2389:47644:47655:46552",
	"2851:XY-2582931773:47116",
	"2851:XY-2582931773:XY-2473159877:47133",
	"2851:XY-2582931773:XY-2473159877",
	"2851:XY-2582931773:47061",
	"2851:XY-2582931773",
	"43573:2389:47644",
	"43573:2389:47644:47655",
	"43573:2389:47661",
	"43573:2389:47665",
	"43573:46004:46011:47875",
	"2851:2861:3305:47927",
	"2851:2861:13177:48321:48318",
	"2851:2861:13177:48321",
	"43573:46004:37915:44825:50463",
	"2851:2861:13177:43086:6026:85734",
	"12636:238480:241031:251081:242011",
	"12636:238480:242913:239639:246560",
	"12636:238480:241031:249150",
	"12636:238480:241031:241036",
	"12636:238480:241031",
	"12636:238480:241031:251081",
	"12636:238480:241031:251073",
	"12636:238480:242913:239639",
	"12636:238480:242913:246564",
	"12636:238480:242913",
	"12636:238480",
	--["name"] = "Revantusk Village, The Hinterlands",
	["m"] = 26,
	["coord"] = 3509047718,
	["direct"] = "XY-1887477213:2389:2851:12636:43573",
	["f"] = 0,
	},
	[47875] = {
	"46011:46004:37915:44825:2226",
	"46011:46004:37915:XY-1887477213",
	"46011:37888:2389",
	"46011:46004:43573:2851",
	"46011:46004:43573:2851:2861:2858",
	"46011:46004:43573:2851:2861:1387",
	"46011:46004:43573:2851:2861",
	"46011:46004:43573:2851:2861:13177:43086:6026",
	"44233:44230:12636",
	"46011:46004:43573:2851:2861:13177",
	"46011:46004:43573:2851:2861:3305",
	"46011:46004:43573:4314",
	"44233:28621",
	"44233:44230",
	"44233:44232",
	"46011:37888",
	"46011:46004:37915",
	"46011:46004:37915:XY-1876468864",
	"46011:46004:43573:2851:2861:1387:43053",
	"46011:46004:43573:2851:2861:1387:43052",
	"46011:46004:43573:2851:2861:13177:43086",
	"46011:46004:37915:XY-1887477213:43220",
	"46011:46004:43573",
	"44233:44231",
	"44233:44230:12636:44407:44408",
	"44233:44230:12636:44407",
	"46011:46004:37915:44825",
	"46011:46004:37915:44825:2226:46552:XY-1742964349",
	"46011:46004",
	"46011:46004:37915:44825:2226:46552",
	"46011:46004:43573:2851:XY-2582931773:47116",
	"46011:46004:43573:2851:XY-2582931773:XY-2473159877:47133",
	"46011:46004:43573:2851:XY-2582931773:XY-2473159877",
	"46011:46004:43573:2851:XY-2582931773:47061",
	"46011:46004:43573:2851:XY-2582931773",
	"46011:37888:2389:47644",
	"46011:37888:2389:47644:47655",
	"46011:37888:2389:47661",
	"46011:46004:37915:47665",
	"46011:46004:43573:2851:2861:3305:47927",
	"46011:46004:43573:2851:2861:13177:48321:48318",
	"46011:46004:43573:2851:2861:13177:48321",
	"46011:46004:37915:44825:50463",
	"46011:46004:43573:2851:2861:13177:43086:6026:85734",
	"44233:44230:12636:238480:241031:251081:242011",
	"44233:44230:12636:238480:242913:239639:246560",
	"44233:44230:12636:238480:241031:249150",
	"44233:44230:12636:238480:241031:241036",
	"44233:44230:12636:238480:241031",
	"44233:44230:12636:238480:241031:251081",
	"44233:44230:12636:238480:241031:251073",
	"44233:44230:12636:238480:242913:239639",
	"44233:44230:12636:238480:242913:246564",
	"44233:44230:12636:238480:242913",
	"44233:44230:12636:238480",
	--["name"] = "Hearthglen, Western Plaguelands",
	["m"] = 22,
	["coord"] = 1914908428,
	["direct"] = "44233:46011",
	["f"] = 0,
	},
	[44232] = {
	"37888:37915:44825:2226",
	"37888:XY-1887477213",
	"37888:2389",
	"37888:43573:2851",
	"37888:43573:2851:2861:2858",
	"37888:43573:2851:2861:1387",
	"37888:43573:2851:2861",
	"37888:43573:2851:2861:13177:43086:6026",
	"44231:12636",
	"37888:43573:2851:2861:13177",
	"37888:43573:2851:2861:3305",
	"37888:43573:4314",
	"44231:44230",
	"37888:37915",
	"37888:37915:XY-1876468864",
	"37888:43573:2851:2861:1387:43053",
	"37888:43573:2851:2861:1387:43052",
	"37888:43573:2851:2861:13177:43086",
	"37888:XY-1887477213:43220",
	"37888:43573",
	"44231:12636:44407:44408",
	"44231:12636:44407",
	"37888:37915:44825",
	"37888:37915:44825:2226:46552:XY-1742964349",
	"37888:46011:46004",
	"37888:46011",
	"37888:37915:44825:2226:46552",
	"37888:43573:2851:XY-2582931773:47116",
	"37888:43573:2851:XY-2582931773:XY-2473159877:47133",
	"37888:43573:2851:XY-2582931773:XY-2473159877",
	"37888:43573:2851:XY-2582931773:47061",
	"37888:43573:2851:XY-2582931773",
	"37888:2389:47644",
	"37888:2389:47644:47655",
	"37888:2389:47661",
	"37888:37915:47665",
	"44233:47875",
	"37888:43573:2851:2861:3305:47927",
	"37888:43573:2851:2861:13177:48321:48318",
	"37888:43573:2851:2861:13177:48321",
	"37888:37915:44825:50463",
	"37888:43573:2851:2861:13177:43086:6026:85734",
	"44231:12636:238480:241031:251081:242011",
	"44231:12636:238480:242913:239639:246560",
	"44231:12636:238480:241031:249150",
	"44231:12636:238480:241031:241036",
	"44231:12636:238480:241031",
	"44231:12636:238480:241031:251081",
	"44231:12636:238480:241031:251073",
	"44231:12636:238480:242913:239639",
	"44231:12636:238480:242913:246564",
	"44231:12636:238480:242913",
	"44231:12636:238480",
	--["name"] = "Crown Guard Tower, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 1499704812,
	["direct"] = "44233:28621:37888:44231",
	["f"] = 0,
	},
	[47661] = {
	"2389:2226",
	"2389:XY-1887477213",
	"2389:2851",
	"2389:2851:2861:2858",
	"2389:2851:2861:1387",
	"2389:2851:2861",
	"2389:2851:2861:13177:43086:6026",
	"2389:37888:12636",
	"2389:2851:2861:13177",
	"2389:2851:2861:3305",
	"2389:4314",
	"2389:37888:44232:44233",
	"2389:37888:44232:28621",
	"2389:37888:44232:44231:44230",
	"2389:37888:44232",
	"2389:37888",
	"2389:37915",
	"2389:37915:XY-1876468864",
	"2389:2851:2861:1387:43053",
	"2389:2851:2861:1387:43052",
	"2389:2851:2861:13177:43086",
	"2389:XY-1887477213:43220",
	"2389:43573",
	"2389:37888:44232:44231",
	"2389:2851:2861:44408",
	"2389:2851:2861:44407",
	"2389:37915:44825",
	"47644:47655:46552:XY-1742964349",
	"2389:37915:46004",
	"2389:37915:46004:46011",
	"47644:47655:46552",
	"2389:2851:XY-2582931773:47116",
	"2389:2851:XY-2582931773:XY-2473159877:47133",
	"2389:2851:XY-2582931773:XY-2473159877",
	"2389:2851:XY-2582931773:47061",
	"2389:2851:XY-2582931773",
	"47644:47655",
	"2389:47665",
	"2389:37915:46004:46011:47875",
	"2389:2851:2861:3305:47927",
	"2389:2851:2861:13177:48321:48318",
	"2389:2851:2861:13177:48321",
	"2389:2226:50463",
	"2389:2851:2861:13177:43086:6026:85734",
	"2389:37888:12636:238480:241031:251081:242011",
	"2389:37888:12636:238480:242913:239639:246560",
	"2389:37888:12636:238480:241031:249150",
	"2389:37888:12636:238480:241031:241036",
	"2389:37888:12636:238480:241031",
	"2389:37888:12636:238480:241031:251081",
	"2389:37888:12636:238480:241031:251073",
	"2389:37888:12636:238480:242913:239639",
	"2389:37888:12636:238480:242913:246564",
	"2389:37888:12636:238480:242913",
	"2389:37888:12636:238480",
	--["name"] = "Eastpoint Tower, Hillsbrad",
	["m"] = 25,
	["f"] = 0,
	["direct"] = "2389:47644",
	["coord"] = 2562564542,
	},
	[2851] = {
	"2389:2226",
	"2861:2858",
	"2861:1387",
	"2861:13177:43086:6026",
	"43573:37888:12636",
	"2861:13177",
	"2861:3305",
	"43573:37888:44232:44233",
	"43573:37888:44232:28621",
	"43573:37888:44232:44231:44230",
	"43573:37888:44232",
	"43573:37888",
	"43573:46004:37915",
	"43573:46004:37915:XY-1876468864",
	"2861:1387:43053",
	"2861:1387:43052",
	"2861:13177:43086",
	"2861:3305:43220",
	"43573:37888:44232:44231",
	"2861:44408",
	"2861:44407",
	"43573:46004:37915:44825",
	"2389:47644:47655:46552:XY-1742964349",
	"43573:46004",
	"43573:46004:46011",
	"2389:47644:47655:46552",
	"XY-2582931773:47116",
	"XY-2582931773:XY-2473159877:47133",
	"XY-2582931773:XY-2473159877",
	"XY-2582931773:47061",
	"2389:47644",
	"2389:47644:47655",
	"2389:47661",
	"2389:47665",
	"43573:46004:46011:47875",
	"2861:3305:47927",
	"2861:13177:48321:48318",
	"2861:13177:48321",
	"43573:46004:37915:44825:50463",
	"2861:13177:43086:6026:85734",
	"43573:37888:12636:238480:241031:251081:242011",
	"43573:37888:12636:238480:242913:239639:246560",
	"43573:37888:12636:238480:241031:249150",
	"43573:37888:12636:238480:241031:241036",
	"43573:37888:12636:238480:241031",
	"43573:37888:12636:238480:241031:251081",
	"43573:37888:12636:238480:241031:251073",
	"43573:37888:12636:238480:242913:239639",
	"43573:37888:12636:238480:242913:246564",
	"43573:37888:12636:238480:242913",
	"43573:37888:12636:238480",
	--["name"] = "Hammerfall, Arathi",
	["m"] = 14,
	["coord"] = 2927252869,
	["direct"] = "XY-1887477213:2389:2861:4314:43573:XY-2582931773",
	["f"] = 0,
	},
	[47665] = {
	"2389:2226",
	"37915:XY-1887477213",
	"2389:2851",
	"2389:2851:2861:2858",
	"2389:2851:2861:1387",
	"2389:2851:2861",
	"2389:2851:2861:13177:43086:6026",
	"37915:37888:12636",
	"2389:2851:2861:13177",
	"2389:2851:2861:3305",
	"2389:4314",
	"37915:46004:46011:47875:44233",
	"37915:37888:44232:28621",
	"37915:37888:44232:44231:44230",
	"37915:37888:44232",
	"37915:37888",
	"37915:XY-1876468864",
	"2389:2851:2861:1387:43053",
	"2389:2851:2861:1387:43052",
	"2389:2851:2861:13177:43086",
	"37915:XY-1887477213:43220",
	"2389:43573",
	"37915:37888:44232:44231",
	"2389:2851:2861:44408",
	"2389:2851:2861:44407",
	"37915:44825",
	"2389:47644:47655:46552:XY-1742964349",
	"37915:46004",
	"37915:46004:46011",
	"2389:47644:47655:46552",
	"2389:2851:XY-2582931773:47116",
	"2389:2851:XY-2582931773:XY-2473159877:47133",
	"2389:2851:XY-2582931773:XY-2473159877",
	"2389:2851:XY-2582931773:47061",
	"2389:2851:XY-2582931773",
	"2389:47644",
	"2389:47644:47655",
	"2389:47661",
	"37915:46004:46011:47875",
	"2389:2851:2861:3305:47927",
	"2389:2851:2861:13177:48321:48318",
	"2389:2851:2861:13177:48321",
	"37915:44825:50463",
	"2389:2851:2861:13177:43086:6026:85734",
	"37915:37888:12636:238480:241031:251081:242011",
	"37915:37888:12636:238480:242913:239639:246560",
	"37915:37888:12636:238480:241031:249150",
	"37915:37888:12636:238480:241031:241036",
	"37915:37888:12636:238480:241031",
	"37915:37888:12636:238480:241031:251081",
	"37915:37888:12636:238480:241031:251073",
	"37915:37888:12636:238480:242913:239639",
	"37915:37888:12636:238480:242913:246564",
	"37915:37888:12636:238480:242913",
	"37915:37888:12636:238480",
	--["name"] = "Strahnbrad, Alterac Mountains",
	["m"] = 25,
	["coord"] = 2500477921,
	["direct"] = "2389:37915",
	["f"] = 0,
	},
	[47655] = {
	"46552:2226",
	"46552:2226:XY-1887477213",
	"47644:2389",
	"47644:2389:2851",
	"47644:2389:2851:2861:2858",
	"47644:2389:2851:2861:1387",
	"47644:2389:2851:2861",
	"47644:2389:2851:2861:13177:43086:6026",
	"47644:2389:37888:12636",
	"47644:2389:2851:2861:13177",
	"47644:2389:2851:2861:3305",
	"47644:2389:4314",
	"47644:2389:37888:44232:44233",
	"47644:2389:37888:44232:28621",
	"47644:2389:37888:44232:44231:44230",
	"47644:2389:37888:44232",
	"47644:2389:37888",
	"47644:2389:37915",
	"47644:2389:37915:XY-1876468864",
	"47644:2389:2851:2861:1387:43053",
	"47644:2389:2851:2861:1387:43052",
	"47644:2389:2851:2861:13177:43086",
	"46552:2226:XY-1887477213:43220",
	"47644:2389:43573",
	"47644:2389:37888:44232:44231",
	"47644:2389:2851:2861:44408",
	"47644:2389:2851:2861:44407",
	"46552:2226:44825",
	"46552:XY-1742964349",
	"47644:2389:37915:46004",
	"47644:2389:37915:46004:46011",
	"47644:2389:2851:XY-2582931773:47116",
	"47644:2389:2851:XY-2582931773:XY-2473159877:47133",
	"47644:2389:2851:XY-2582931773:XY-2473159877",
	"47644:2389:2851:XY-2582931773:47061",
	"47644:2389:2851:XY-2582931773",
	"47644:47661",
	"47644:2389:47665",
	"47644:2389:37915:46004:46011:47875",
	"47644:2389:2851:2861:3305:47927",
	"47644:2389:2851:2861:13177:48321:48318",
	"47644:2389:2851:2861:13177:48321",
	"46552:2226:50463",
	"47644:2389:2851:2861:13177:43086:6026:85734",
	"47644:2389:37888:12636:238480:241031:251081:242011",
	"47644:2389:37888:12636:238480:242913:239639:246560",
	"47644:2389:37888:12636:238480:241031:249150",
	"47644:2389:37888:12636:238480:241031:241036",
	"47644:2389:37888:12636:238480:241031",
	"47644:2389:37888:12636:238480:241031:251081",
	"47644:2389:37888:12636:238480:241031:251073",
	"47644:2389:37888:12636:238480:242913:239639",
	"47644:2389:37888:12636:238480:242913:246564",
	"47644:2389:37888:12636:238480:242913",
	"47644:2389:37888:12636:238480",
	--["name"] = "Southpoint Gate, Hillsbrad",
	["m"] = 25,
	["f"] = 0,
	["direct"] = "46552:47644",
	["coord"] = 1249420485,
	},
	[43220] = {
	"XY-1887477213:2226",
	"XY-1887477213:2389",
	"3305:2861:2851",
	"3305:13177:1387:2858",
	"3305:13177:1387",
	"3305:2861",
	"3305:13177:43086:6026",
	"XY-1887477213:37888:12636",
	"3305:13177",
	"3305:2861:2851:4314",
	"XY-1887477213:37915:46004:46011:47875:44233",
	"XY-1887477213:37888:44232:28621",
	"XY-1887477213:37888:44232:44231:44230",
	"XY-1887477213:37888:44232",
	"XY-1887477213:37888",
	"XY-1887477213:37915",
	"XY-1887477213:XY-1876468864",
	"3305:13177:1387:43053",
	"3305:13177:1387:43052",
	"3305:13177:43086",
	"3305:2861:2851:43573",
	"XY-1887477213:37888:44232:44231",
	"3305:2861:44408",
	"3305:2861:44407",
	"XY-1887477213:44825",
	"XY-1887477213:2226:46552:XY-1742964349",
	"XY-1887477213:37915:46004",
	"XY-1887477213:37915:46004:46011",
	"XY-1887477213:2226:46552",
	"3305:2861:XY-2582931773:47116",
	"3305:2861:XY-2582931773:XY-2473159877:47133",
	"3305:2861:XY-2582931773:XY-2473159877",
	"3305:2861:XY-2582931773:47061",
	"3305:2861:XY-2582931773",
	"XY-1887477213:2389:47644",
	"XY-1887477213:2226:46552:47655",
	"XY-1887477213:2389:47661",
	"XY-1887477213:37915:47665",
	"XY-1887477213:37915:46004:46011:47875",
	"3305:47927",
	"3305:47927:48318",
	"3305:13177:48321",
	"XY-1887477213:44825:50463",
	"3305:13177:43086:6026:85734",
	"XY-1887477213:37888:12636:238480:241031:251081:242011",
	"XY-1887477213:37888:12636:238480:242913:239639:246560",
	"XY-1887477213:37888:12636:238480:241031:249150",
	"XY-1887477213:37888:12636:238480:241031:241036",
	"XY-1887477213:37888:12636:238480:241031",
	"XY-1887477213:37888:12636:238480:241031:251081",
	"XY-1887477213:37888:12636:238480:241031:251073",
	"XY-1887477213:37888:12636:238480:242913:239639",
	"XY-1887477213:37888:12636:238480:242913:246564",
	"XY-1887477213:37888:12636:238480:242913",
	"XY-1887477213:37888:12636:238480",
	--["name"] = "Sandy Beach, Vashj'ir",
	["m"] = 205,
	["coord"] = 2621720751,
	["direct"] = "XY-1887477213:3305",
	["f"] = 0,
	},
	[246564] = {
	"242913:238480:12636:37888:37915:44825:2226",
	"242913:238480:12636:37888:XY-1887477213",
	"242913:238480:12636:37888:2389",
	"242913:238480:12636:4314:2851",
	"242913:238480:12636:44407:2861:2858",
	"242913:238480:12636:44407:2861:1387",
	"242913:238480:12636:44407:2861",
	"242913:238480:12636:44407:2861:13177:43086:6026",
	"242913:238480:12636",
	"242913:238480:12636:44407:2861:13177",
	"242913:238480:12636:44407:2861:3305",
	"242913:238480:12636:4314",
	"242913:238480:12636:44230:44233",
	"242913:238480:12636:44230:28621",
	"242913:238480:12636:44230",
	"242913:238480:12636:44231:44232",
	"242913:238480:12636:37888",
	"242913:238480:12636:37888:37915",
	"242913:238480:12636:37888:37915:XY-1876468864",
	"242913:238480:12636:44407:2861:1387:43053",
	"242913:238480:12636:44407:2861:1387:43052",
	"242913:238480:12636:44407:2861:13177:43086",
	"242913:238480:12636:37888:XY-1887477213:43220",
	"242913:238480:12636:37888:43573",
	"242913:238480:12636:44231",
	"242913:238480:12636:44407:44408",
	"242913:238480:12636:44407",
	"242913:238480:12636:37888:37915:44825",
	"242913:238480:12636:37888:37915:44825:2226:46552:XY-1742964349",
	"242913:238480:12636:37888:46011:46004",
	"242913:238480:12636:37888:46011",
	"242913:238480:12636:37888:37915:44825:2226:46552",
	"242913:238480:12636:4314:2851:XY-2582931773:47116",
	"242913:238480:12636:4314:2851:XY-2582931773:XY-2473159877:47133",
	"242913:238480:12636:4314:2851:XY-2582931773:XY-2473159877",
	"242913:238480:12636:4314:2851:XY-2582931773:47061",
	"242913:238480:12636:4314:2851:XY-2582931773",
	"242913:238480:12636:37888:2389:47644",
	"242913:238480:12636:37888:2389:47644:47655",
	"242913:238480:12636:37888:2389:47661",
	"242913:238480:12636:37888:37915:47665",
	"242913:238480:12636:44230:44233:47875",
	"242913:238480:12636:44407:2861:3305:47927",
	"242913:238480:12636:44407:2861:13177:48321:48318",
	"242913:238480:12636:44407:2861:13177:48321",
	"242913:238480:12636:37888:37915:44825:50463",
	"242913:238480:12636:44407:2861:13177:43086:6026:85734",
	"251073:242011",
	"251073:241031:249150",
	"251073:251081:241036",
	"251073:241031",
	"251073:251081",
	"242913:238480",
	--["name"] = "The Royal Exchange, Silvermoon City",
	["m"] = 2393,
	["f"] = 0,
	["direct"] = "246560:251073:239639:242913",
	["coord"] = 2979242577,
	},
	[47061] = {
	"XY-2582931773:2851:2389:2226",
	"XY-2582931773:2851:43573:46004:37915:XY-1887477213",
	"XY-2582931773:2851:2389",
	"XY-2582931773:2851",
	"XY-2582931773:2861:2858",
	"XY-2582931773:2861:1387",
	"XY-2582931773:2861",
	"XY-2582931773:2861:13177:43086:6026",
	"XY-2582931773:2851:43573:37888:12636",
	"XY-2582931773:2861:13177",
	"XY-2582931773:2861:3305",
	"XY-2582931773:2851:4314",
	"XY-2582931773:2851:43573:37888:44232:44233",
	"XY-2582931773:2851:43573:37888:44232:28621",
	"XY-2582931773:2851:43573:37888:44232:44231:44230",
	"XY-2582931773:2851:43573:37888:44232",
	"XY-2582931773:2851:43573:37888",
	"XY-2582931773:2851:43573:46004:37915",
	"XY-2582931773:2851:43573:46004:37915:XY-1876468864",
	"XY-2582931773:2861:1387:43053",
	"XY-2582931773:2861:1387:43052",
	"XY-2582931773:2861:13177:43086",
	"XY-2582931773:2861:3305:43220",
	"XY-2582931773:2851:43573",
	"XY-2582931773:2851:43573:37888:44232:44231",
	"XY-2582931773:2861:44408",
	"XY-2582931773:2861:44407",
	"XY-2582931773:2851:43573:46004:37915:44825",
	"XY-2582931773:2851:2389:47644:47655:46552:XY-1742964349",
	"XY-2582931773:2851:43573:46004",
	"XY-2582931773:2851:43573:46004:46011",
	"XY-2582931773:2851:2389:47644:47655:46552",
	"XY-2582931773:47116",
	"XY-2473159877:47133",
	"XY-2582931773:2851:2389:47644",
	"XY-2582931773:2851:2389:47644:47655",
	"XY-2582931773:2851:2389:47661",
	"XY-2582931773:2851:2389:47665",
	"XY-2582931773:2851:43573:46004:46011:47875",
	"XY-2582931773:2861:3305:47927",
	"XY-2582931773:2861:13177:48321:48318",
	"XY-2582931773:2861:13177:48321",
	"XY-2582931773:2851:43573:46004:37915:44825:50463",
	"XY-2582931773:2861:13177:43086:6026:85734",
	"XY-2582931773:2851:43573:37888:12636:238480:241031:251081:242011",
	"XY-2582931773:2851:43573:37888:12636:238480:242913:239639:246560",
	"XY-2582931773:2851:43573:37888:12636:238480:241031:249150",
	"XY-2582931773:2851:43573:37888:12636:238480:241031:241036",
	"XY-2582931773:2851:43573:37888:12636:238480:241031",
	"XY-2582931773:2851:43573:37888:12636:238480:241031:251081",
	"XY-2582931773:2851:43573:37888:12636:238480:241031:251073",
	"XY-2582931773:2851:43573:37888:12636:238480:242913:239639",
	"XY-2582931773:2851:43573:37888:12636:238480:242913:246564",
	"XY-2582931773:2851:43573:37888:12636:238480:242913",
	"XY-2582931773:2851:43573:37888:12636:238480",
	--["name"] = "The Krazzworks, Twilight Highlands",
	["m"] = 241,
	["coord"] = 3236441458,
	["direct"] = "XY-2473159877:XY-2582931773",
	["f"] = 0,
	},
	[47927] = {
	"3305:2861:2851:2389:2226",
	"3305:43220:XY-1887477213",
	"3305:2861:2851:2389",
	"3305:2861:2851",
	"3305:13177:1387:2858",
	"3305:13177:1387",
	"3305:2861",
	"3305:13177:43086:6026",
	"3305:2861:44407:12636",
	"3305:13177",
	"3305:2861:2851:4314",
	"3305:2861:2851:43573:37888:44232:44233",
	"3305:2861:44407:12636:44230:28621",
	"3305:2861:44407:12636:44230",
	"3305:2861:2851:43573:37888:44232",
	"3305:2861:2851:43573:37888",
	"3305:2861:2851:43573:46004:37915",
	"3305:2861:2851:43573:46004:37915:XY-1876468864",
	"3305:13177:1387:43053",
	"3305:13177:1387:43052",
	"3305:13177:43086",
	"3305:43220",
	"3305:2861:2851:43573",
	"3305:2861:2851:43573:37888:44232:44231",
	"3305:2861:44408",
	"3305:2861:44407",
	"3305:2861:2851:43573:46004:37915:44825",
	"3305:2861:2851:2389:47644:47655:46552:XY-1742964349",
	"3305:2861:2851:43573:46004",
	"3305:2861:2851:43573:46004:46011",
	"3305:2861:2851:2389:47644:47655:46552",
	"3305:2861:XY-2582931773:47116",
	"3305:2861:XY-2582931773:XY-2473159877:47133",
	"3305:2861:XY-2582931773:XY-2473159877",
	"3305:2861:XY-2582931773:47061",
	"3305:2861:XY-2582931773",
	"3305:2861:2851:2389:47644",
	"3305:2861:2851:2389:47644:47655",
	"3305:2861:2851:2389:47661",
	"3305:2861:2851:2389:47665",
	"3305:2861:2851:43573:46004:46011:47875",
	"48318:48321",
	"3305:2861:2851:43573:46004:37915:44825:50463",
	"3305:13177:43086:6026:85734",
	"3305:2861:44407:12636:238480:241031:251081:242011",
	"3305:2861:44407:12636:238480:242913:239639:246560",
	"3305:2861:44407:12636:238480:241031:249150",
	"3305:2861:44407:12636:238480:241031:241036",
	"3305:2861:44407:12636:238480:241031",
	"3305:2861:44407:12636:238480:241031:251081",
	"3305:2861:44407:12636:238480:241031:251073",
	"3305:2861:44407:12636:238480:242913:239639",
	"3305:2861:44407:12636:238480:242913:246564",
	"3305:2861:44407:12636:238480:242913",
	"3305:2861:44407:12636:238480",
	--["name"] = "Iron Summit, Searing Gorge",
	["m"] = 32,
	["f"] = 0,
	["direct"] = "3305:48318",
	["coord"] = 1761259473,
	},
	[50463] = {
	"44825:XY-1887477213",
	"2226:2389",
	"2226:2389:2851",
	"2226:2389:2851:2861:2858",
	"2226:2389:2851:2861:1387",
	"2226:2389:2851:2861",
	"2226:2389:2851:2861:13177:43086:6026",
	"44825:37915:37888:12636",
	"2226:2389:2851:2861:13177",
	"2226:2389:2851:2861:3305",
	"2226:2389:4314",
	"44825:37915:46004:46011:47875:44233",
	"44825:37915:37888:44232:28621",
	"44825:37915:37888:44232:44231:44230",
	"44825:37915:37888:44232",
	"44825:37915:37888",
	"44825:37915",
	"44825:XY-1876468864",
	"2226:2389:2851:2861:1387:43053",
	"2226:2389:2851:2861:1387:43052",
	"2226:2389:2851:2861:13177:43086",
	"44825:XY-1887477213:43220",
	"44825:37915:46004:43573",
	"44825:37915:37888:44232:44231",
	"2226:2389:2851:2861:44408",
	"2226:2389:2851:2861:44407",
	"2226:46552:XY-1742964349",
	"44825:37915:46004",
	"44825:37915:46004:46011",
	"2226:46552",
	"2226:2389:2851:XY-2582931773:47116",
	"2226:2389:2851:XY-2582931773:XY-2473159877:47133",
	"2226:2389:2851:XY-2582931773:XY-2473159877",
	"2226:2389:2851:XY-2582931773:47061",
	"2226:2389:2851:XY-2582931773",
	"2226:46552:47655:47644",
	"2226:46552:47655",
	"2226:46552:47655:47644:47661",
	"44825:37915:47665",
	"44825:37915:46004:46011:47875",
	"2226:2389:2851:2861:3305:47927",
	"2226:2389:2851:2861:13177:48321:48318",
	"2226:2389:2851:2861:13177:48321",
	"2226:2389:2851:2861:13177:43086:6026:85734",
	"44825:37915:37888:12636:238480:241031:251081:242011",
	"44825:37915:37888:12636:238480:242913:239639:246560",
	"44825:37915:37888:12636:238480:241031:249150",
	"44825:37915:37888:12636:238480:241031:241036",
	"44825:37915:37888:12636:238480:241031",
	"44825:37915:37888:12636:238480:241031:251081",
	"44825:37915:37888:12636:238480:241031:251073",
	"44825:37915:37888:12636:238480:242913:239639",
	"44825:37915:37888:12636:238480:242913:246564",
	"44825:37915:37888:12636:238480:242913",
	"44825:37915:37888:12636:238480",
	--["name"] = "Forsaken Rear Guard, Silverpine Forest",
	["m"] = 21,
	["coord"] = 1974745042,
	["direct"] = "2226:44825",
	["f"] = 0,
	},
	[241036] = {
	"241031:238480:12636:37888:37915:44825:2226",
	"241031:238480:12636:37888:XY-1887477213",
	"241031:238480:12636:37888:2389",
	"241031:238480:12636:4314:2851",
	"241031:238480:12636:44407:2861:2858",
	"241031:238480:12636:44407:2861:1387",
	"241031:238480:12636:44407:2861",
	"241031:238480:12636:44407:2861:13177:43086:6026",
	"241031:238480:12636",
	"241031:238480:12636:44407:2861:13177",
	"241031:238480:12636:44407:2861:3305",
	"241031:238480:12636:4314",
	"241031:238480:12636:44230:44233",
	"241031:238480:12636:44230:28621",
	"241031:238480:12636:44230",
	"241031:238480:12636:44231:44232",
	"241031:238480:12636:37888",
	"241031:238480:12636:37888:37915",
	"241031:238480:12636:37888:37915:XY-1876468864",
	"241031:238480:12636:44407:2861:1387:43053",
	"241031:238480:12636:44407:2861:1387:43052",
	"241031:238480:12636:44407:2861:13177:43086",
	"241031:238480:12636:37888:XY-1887477213:43220",
	"241031:238480:12636:37888:43573",
	"241031:238480:12636:44231",
	"241031:238480:12636:44407:44408",
	"241031:238480:12636:44407",
	"241031:238480:12636:37888:37915:44825",
	"241031:238480:12636:37888:37915:44825:2226:46552:XY-1742964349",
	"241031:238480:12636:37888:46011:46004",
	"241031:238480:12636:37888:46011",
	"241031:238480:12636:37888:37915:44825:2226:46552",
	"241031:238480:12636:4314:2851:XY-2582931773:47116",
	"241031:238480:12636:4314:2851:XY-2582931773:XY-2473159877:47133",
	"241031:238480:12636:4314:2851:XY-2582931773:XY-2473159877",
	"241031:238480:12636:4314:2851:XY-2582931773:47061",
	"241031:238480:12636:4314:2851:XY-2582931773",
	"241031:238480:12636:37888:2389:47644",
	"241031:238480:12636:37888:2389:47644:47655",
	"241031:238480:12636:37888:2389:47661",
	"241031:238480:12636:37888:37915:47665",
	"241031:238480:12636:44230:44233:47875",
	"241031:238480:12636:44407:2861:3305:47927",
	"241031:238480:12636:44407:2861:13177:48321:48318",
	"241031:238480:12636:44407:2861:13177:48321",
	"241031:238480:12636:37888:37915:44825:50463",
	"241031:238480:12636:44407:2861:13177:43086:6026:85734",
	"251081:242011",
	"241031:238480:242913:239639:246560",
	"241031:251073",
	"241031:238480:242913:239639",
	"241031:251073:246564",
	"241031:238480:242913",
	"241031:238480",
	--["name"] = "Amani'Zar Village, Zul'Aman",
	["m"] = 2437,
	["f"] = 0,
	["direct"] = "249150:241031:251081",
	["coord"] = 1926211501,
	},
	[47116] = {
	"XY-2582931773:2851:2389:2226",
	"XY-2582931773:2851:43573:46004:37915:XY-1887477213",
	"XY-2582931773:2851:2389",
	"XY-2582931773:2851",
	"XY-2582931773:2861:2858",
	"XY-2582931773:2861:1387",
	"XY-2582931773:2861",
	"XY-2582931773:2861:13177:43086:6026",
	"XY-2582931773:2851:43573:37888:12636",
	"XY-2582931773:2861:13177",
	"XY-2582931773:2861:3305",
	"XY-2582931773:2851:4314",
	"XY-2582931773:2851:43573:37888:44232:44233",
	"XY-2582931773:2851:43573:37888:44232:28621",
	"XY-2582931773:2851:43573:37888:44232:44231:44230",
	"XY-2582931773:2851:43573:37888:44232",
	"XY-2582931773:2851:43573:37888",
	"XY-2582931773:2851:43573:46004:37915",
	"XY-2582931773:2851:43573:46004:37915:XY-1876468864",
	"XY-2582931773:2861:1387:43053",
	"XY-2582931773:2861:1387:43052",
	"XY-2582931773:2861:13177:43086",
	"XY-2582931773:2861:3305:43220",
	"XY-2582931773:2851:43573",
	"XY-2582931773:2851:43573:37888:44232:44231",
	"XY-2582931773:2861:44408",
	"XY-2582931773:2861:44407",
	"XY-2582931773:2851:43573:46004:37915:44825",
	"XY-2582931773:2851:2389:47644:47655:46552:XY-1742964349",
	"XY-2582931773:2851:43573:46004",
	"XY-2582931773:2851:43573:46004:46011",
	"XY-2582931773:2851:2389:47644:47655:46552",
	"XY-2473159877:47061",
	"XY-2582931773:2851:2389:47644",
	"XY-2582931773:2851:2389:47644:47655",
	"XY-2582931773:2851:2389:47661",
	"XY-2582931773:2851:2389:47665",
	"XY-2582931773:2851:43573:46004:46011:47875",
	"XY-2582931773:2861:3305:47927",
	"XY-2582931773:2861:13177:48321:48318",
	"XY-2582931773:2861:13177:48321",
	"XY-2582931773:2851:43573:46004:37915:44825:50463",
	"XY-2582931773:2861:13177:43086:6026:85734",
	"XY-2582931773:2851:43573:37888:12636:238480:241031:251081:242011",
	"XY-2582931773:2851:43573:37888:12636:238480:242913:239639:246560",
	"XY-2582931773:2851:43573:37888:12636:238480:241031:249150",
	"XY-2582931773:2851:43573:37888:12636:238480:241031:241036",
	"XY-2582931773:2851:43573:37888:12636:238480:241031",
	"XY-2582931773:2851:43573:37888:12636:238480:241031:251081",
	"XY-2582931773:2851:43573:37888:12636:238480:241031:251073",
	"XY-2582931773:2851:43573:37888:12636:238480:242913:239639",
	"XY-2582931773:2851:43573:37888:12636:238480:242913:246564",
	"XY-2582931773:2851:43573:37888:12636:238480:242913",
	"XY-2582931773:2851:43573:37888:12636:238480",
	--["name"] = "Crushblow, Twilight Highlands",
	["m"] = 241,
	["coord"] = 1964950242,
	["direct"] = "47133:XY-2473159877:XY-2582931773",
	["f"] = 0,
	},
	[1387] = {
	"2861:2851:2389:2226",
	"2861:XY-1887477213",
	"2861:2851:2389",
	"2861:2851",
	"2861:44407:12636",
	"13177:3305",
	"2861:2851:4314",
	"2861:2851:43573:37888:44232:44233",
	"2861:44407:12636:44230:28621",
	"2861:44407:12636:44230",
	"2861:2851:43573:37888:44232",
	"2861:2851:43573:37888",
	"2861:2851:43573:46004:37915",
	"2861:2851:43573:46004:37915:XY-1876468864",
	"6026:43086",
	"13177:3305:43220",
	"2861:2851:43573",
	"2861:2851:43573:37888:44232:44231",
	"2861:44408",
	"2861:44407",
	"2861:2851:43573:46004:37915:44825",
	"2861:2851:2389:47644:47655:46552:XY-1742964349",
	"2861:2851:43573:46004",
	"2861:2851:43573:46004:46011",
	"2861:2851:2389:47644:47655:46552",
	"2861:XY-2582931773:47116",
	"2861:XY-2582931773:XY-2473159877:47133",
	"2861:XY-2582931773:XY-2473159877",
	"2861:XY-2582931773:47061",
	"2861:XY-2582931773",
	"2861:2851:2389:47644",
	"2861:2851:2389:47644:47655",
	"2861:2851:2389:47661",
	"2861:2851:2389:47665",
	"2861:2851:43573:46004:46011:47875",
	"13177:48321:48318:47927",
	"13177:48321:48318",
	"13177:48321",
	"2861:2851:43573:46004:37915:44825:50463",
	"43052:85734",
	"2861:44407:12636:238480:241031:251081:242011",
	"2861:44407:12636:238480:242913:239639:246560",
	"2861:44407:12636:238480:241031:249150",
	"2861:44407:12636:238480:241031:241036",
	"2861:44407:12636:238480:241031",
	"2861:44407:12636:238480:241031:251081",
	"2861:44407:12636:238480:241031:251073",
	"2861:44407:12636:238480:242913:239639",
	"2861:44407:12636:238480:242913:246564",
	"2861:44407:12636:238480:242913",
	"2861:44407:12636:238480",
	--["name"] = "Grom'gol, Stranglethorn",
	["m"] = 50,
	["f"] = 0,
	["direct"] = "2858:2861:6026:13177:43053:43052",
	["coord"] = 1675199251,
	},
	[43086] = {
	"13177:2861:2851:2389:2226",
	"13177:2861:XY-1887477213",
	"13177:2861:2851:2389",
	"13177:2861:2851",
	"6026:2858",
	"6026:1387",
	"13177:2861",
	"13177:2861:44407:12636",
	"13177:3305",
	"13177:2861:2851:4314",
	"13177:2861:2851:43573:37888:44232:44233",
	"13177:2861:44407:12636:44230:28621",
	"13177:2861:44407:12636:44230",
	"13177:2861:2851:43573:37888:44232",
	"13177:2861:2851:43573:37888",
	"13177:2861:2851:43573:46004:37915",
	"13177:2861:2851:43573:46004:37915:XY-1876468864",
	"6026:1387:43053",
	"6026:85734:43052",
	"13177:3305:43220",
	"13177:2861:2851:43573",
	"13177:2861:2851:43573:37888:44232:44231",
	"13177:2861:44408",
	"13177:2861:44407",
	"13177:2861:2851:43573:46004:37915:44825",
	"13177:2861:2851:2389:47644:47655:46552:XY-1742964349",
	"13177:2861:2851:43573:46004",
	"13177:2861:2851:43573:46004:46011",
	"13177:2861:2851:2389:47644:47655:46552",
	"13177:2861:XY-2582931773:47116",
	"13177:2861:XY-2582931773:XY-2473159877:47133",
	"13177:2861:XY-2582931773:XY-2473159877",
	"13177:2861:XY-2582931773:47061",
	"13177:2861:XY-2582931773",
	"13177:2861:2851:2389:47644",
	"13177:2861:2851:2389:47644:47655",
	"13177:2861:2851:2389:47661",
	"13177:2861:2851:2389:47665",
	"13177:2861:2851:43573:46004:46011:47875",
	"13177:48321:48318:47927",
	"13177:48321:48318",
	"13177:48321",
	"13177:2861:2851:43573:46004:37915:44825:50463",
	"6026:85734",
	"13177:2861:44407:12636:238480:241031:251081:242011",
	"13177:2861:44407:12636:238480:242913:239639:246560",
	"13177:2861:44407:12636:238480:241031:249150",
	"13177:2861:44407:12636:238480:241031:241036",
	"13177:2861:44407:12636:238480:241031",
	"13177:2861:44407:12636:238480:241031:251081",
	"13177:2861:44407:12636:238480:241031:251073",
	"13177:2861:44407:12636:238480:242913:239639",
	"13177:2861:44407:12636:238480:242913:246564",
	"13177:2861:44407:12636:238480:242913",
	"13177:2861:44407:12636:238480",
	--["name"] = "Bogpaddle, Swamp of Sorrows",
	["m"] = 51,
	["coord"] = 3098287836,
	["direct"] = "6026:13177",
	["f"] = 0,
	},
	[44407] = {
	"2861:2851:2389:2226",
	"2861:XY-1887477213",
	"2861:2851:2389",
	"2861:2851",
	"2861:2858",
	"2861:1387",
	"2861:13177:43086:6026",
	"2861:13177",
	"2861:3305",
	"2861:2851:4314",
	"12636:44230:44233",
	"12636:44230:28621",
	"12636:44230",
	"12636:44231:44232",
	"2861:2851:43573:37888",
	"2861:2851:43573:46004:37915",
	"2861:2851:43573:46004:37915:XY-1876468864",
	"2861:1387:43053",
	"2861:1387:43052",
	"2861:13177:43086",
	"2861:3305:43220",
	"2861:2851:43573",
	"12636:44231",
	"2861:2851:43573:46004:37915:44825",
	"2861:2851:2389:47644:47655:46552:XY-1742964349",
	"2861:2851:43573:46004",
	"2861:2851:43573:46004:46011",
	"2861:2851:2389:47644:47655:46552",
	"2861:XY-2582931773:47116",
	"2861:XY-2582931773:XY-2473159877:47133",
	"2861:XY-2582931773:XY-2473159877",
	"2861:XY-2582931773:47061",
	"2861:XY-2582931773",
	"2861:2851:2389:47644",
	"2861:2851:2389:47644:47655",
	"2861:2851:2389:47661",
	"2861:2851:2389:47665",
	"2861:2851:43573:46004:46011:47875",
	"2861:3305:47927",
	"2861:13177:48321:48318",
	"2861:13177:48321",
	"2861:2851:43573:46004:37915:44825:50463",
	"2861:13177:43086:6026:85734",
	"12636:238480:241031:251081:242011",
	"12636:238480:242913:239639:246560",
	"12636:238480:241031:249150",
	"12636:238480:241031:241036",
	"12636:238480:241031",
	"12636:238480:241031:251081",
	"12636:238480:241031:251073",
	"12636:238480:242913:239639",
	"12636:238480:242913:246564",
	"12636:238480:242913",
	"12636:238480",
	--["name"] = "Fuselight, Badlands",
	["m"] = 15,
	["f"] = 0,
	["direct"] = "2861:12636:44408",
	["coord"] = 2763151846,
	},
	[2858] = {
	"2861:2851:2389:2226",
	"2861:XY-1887477213",
	"2861:2851:2389",
	"2861:2851",
	"2861:44407:12636",
	"1387:13177",
	"1387:13177:3305",
	"2861:2851:4314",
	"2861:2851:43573:37888:44232:44233",
	"2861:44407:12636:44230:28621",
	"2861:44407:12636:44230",
	"2861:2851:43573:37888:44232",
	"2861:2851:43573:37888",
	"2861:2851:43573:46004:37915",
	"2861:2851:43573:46004:37915:XY-1876468864",
	"43053:43052",
	"6026:43086",
	"1387:13177:3305:43220",
	"2861:2851:43573",
	"2861:2851:43573:37888:44232:44231",
	"2861:44408",
	"2861:44407",
	"2861:2851:43573:46004:37915:44825",
	"2861:2851:2389:47644:47655:46552:XY-1742964349",
	"2861:2851:43573:46004",
	"2861:2851:43573:46004:46011",
	"2861:2851:2389:47644:47655:46552",
	"2861:XY-2582931773:47116",
	"2861:XY-2582931773:XY-2473159877:47133",
	"2861:XY-2582931773:XY-2473159877",
	"2861:XY-2582931773:47061",
	"2861:XY-2582931773",
	"2861:2851:2389:47644",
	"2861:2851:2389:47644:47655",
	"2861:2851:2389:47661",
	"2861:2851:2389:47665",
	"2861:2851:43573:46004:46011:47875",
	"1387:13177:48321:48318:47927",
	"1387:13177:48321:48318",
	"1387:13177:48321",
	"2861:2851:43573:46004:37915:44825:50463",
	"43053:43052:85734",
	"2861:44407:12636:238480:241031:251081:242011",
	"2861:44407:12636:238480:242913:239639:246560",
	"2861:44407:12636:238480:241031:249150",
	"2861:44407:12636:238480:241031:241036",
	"2861:44407:12636:238480:241031",
	"2861:44407:12636:238480:241031:251081",
	"2861:44407:12636:238480:241031:251073",
	"2861:44407:12636:238480:242913:239639",
	"2861:44407:12636:238480:242913:246564",
	"2861:44407:12636:238480:242913",
	"2861:44407:12636:238480",
	--["name"] = "Booty Bay, Stranglethorn",
	["m"] = 210,
	["f"] = 0,
	["direct"] = "1387:2861:6026:43053",
	["coord"] = 1743240135,
	},
	[48321] = {
	"13177:2861:2851:2389:2226",
	"13177:2861:XY-1887477213",
	"13177:2861:2851:2389",
	"13177:2861:2851",
	"13177:1387:2858",
	"13177:1387",
	"13177:2861",
	"13177:43086:6026",
	"13177:2861:44407:12636",
	"13177:3305",
	"13177:2861:2851:4314",
	"13177:2861:2851:43573:37888:44232:44233",
	"13177:2861:44407:12636:44230:28621",
	"13177:2861:44407:12636:44230",
	"13177:2861:2851:43573:37888:44232",
	"13177:2861:2851:43573:37888",
	"13177:2861:2851:43573:46004:37915",
	"13177:2861:2851:43573:46004:37915:XY-1876468864",
	"13177:1387:43053",
	"13177:1387:43052",
	"13177:43086",
	"13177:3305:43220",
	"13177:2861:2851:43573",
	"13177:2861:2851:43573:37888:44232:44231",
	"13177:2861:44408",
	"13177:2861:44407",
	"13177:2861:2851:43573:46004:37915:44825",
	"13177:2861:2851:2389:47644:47655:46552:XY-1742964349",
	"13177:2861:2851:43573:46004",
	"13177:2861:2851:43573:46004:46011",
	"13177:2861:2851:2389:47644:47655:46552",
	"13177:2861:XY-2582931773:47116",
	"13177:2861:XY-2582931773:XY-2473159877:47133",
	"13177:2861:XY-2582931773:XY-2473159877",
	"13177:2861:XY-2582931773:47061",
	"13177:2861:XY-2582931773",
	"13177:2861:2851:2389:47644",
	"13177:2861:2851:2389:47644:47655",
	"13177:2861:2851:2389:47661",
	"13177:2861:2851:2389:47665",
	"13177:2861:2851:43573:46004:46011:47875",
	"48318:47927",
	"13177:2861:2851:43573:46004:37915:44825:50463",
	"13177:43086:6026:85734",
	"13177:2861:44407:12636:238480:241031:251081:242011",
	"13177:2861:44407:12636:238480:242913:239639:246560",
	"13177:2861:44407:12636:238480:241031:249150",
	"13177:2861:44407:12636:238480:241031:241036",
	"13177:2861:44407:12636:238480:241031",
	"13177:2861:44407:12636:238480:241031:251081",
	"13177:2861:44407:12636:238480:241031:251073",
	"13177:2861:44407:12636:238480:242913:239639",
	"13177:2861:44407:12636:238480:242913:246564",
	"13177:2861:44407:12636:238480:242913",
	"13177:2861:44407:12636:238480",
	--["name"] = "Chiselgrip, Burning Steppes",
	["m"] = 36,
	["f"] = 0,
	["direct"] = "13177:48318",
	["coord"] = 1981508409,
	},
	[12636] = {
	"37888:37915:44825:2226",
	"37888:2389",
	"4314:2851",
	"44407:2861:2858",
	"44407:2861:1387",
	"44407:2861",
	"44407:2861:13177:43086:6026",
	"44407:2861:13177",
	"44407:2861:3305",
	"44230:44233",
	"44230:28621",
	"44231:44232",
	"37888:37915",
	"37888:37915:XY-1876468864",
	"44407:2861:1387:43053",
	"44407:2861:1387:43052",
	"44407:2861:13177:43086",
	"37888:XY-1887477213:43220",
	"37888:43573",
	"44407:44408",
	"37888:37915:44825",
	"37888:37915:44825:2226:46552:XY-1742964349",
	"37888:46011:46004",
	"37888:46011",
	"37888:37915:44825:2226:46552",
	"4314:2851:XY-2582931773:47116",
	"4314:2851:XY-2582931773:XY-2473159877:47133",
	"4314:2851:XY-2582931773:XY-2473159877",
	"4314:2851:XY-2582931773:47061",
	"4314:2851:XY-2582931773",
	"37888:2389:47644",
	"37888:2389:47644:47655",
	"37888:2389:47661",
	"37888:37915:47665",
	"44230:44233:47875",
	"44407:2861:3305:47927",
	"44407:2861:13177:48321:48318",
	"44407:2861:13177:48321",
	"37888:37915:44825:50463",
	"44407:2861:13177:43086:6026:85734",
	"238480:241031:251081:242011",
	"238480:242913:239639:246560",
	"238480:241031:249150",
	"238480:241031:241036",
	"238480:241031",
	"238480:241031:251081",
	"238480:241031:251073",
	"238480:242913:239639",
	"238480:242913:246564",
	"238480:242913",
	--["name"] = "Light's Hope Chapel, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 3255470232,
	["direct"] = "XY-1887477213:4314:44230:37888:44231:44407:238480",
	["f"] = 0,
	},
	[44230] = {
	"44231:44232:37888:37915:44825:2226",
	"44231:44232:37888:XY-1887477213",
	"44231:44232:37888:2389",
	"44231:44232:37888:43573:2851",
	"12636:44407:2861:2858",
	"12636:44407:2861:1387",
	"12636:44407:2861",
	"12636:44407:2861:13177:43086:6026",
	"12636:44407:2861:13177",
	"12636:44407:2861:3305",
	"12636:4314",
	"44231:44232",
	"44231:44232:37888",
	"44231:44232:37888:37915",
	"44231:44232:37888:37915:XY-1876468864",
	"12636:44407:2861:1387:43053",
	"12636:44407:2861:1387:43052",
	"12636:44407:2861:13177:43086",
	"44231:44232:37888:XY-1887477213:43220",
	"44231:44232:37888:43573",
	"12636:44407:44408",
	"12636:44407",
	"44231:44232:37888:37915:44825",
	"44231:44232:37888:37915:44825:2226:46552:XY-1742964349",
	"44231:44232:37888:46011:46004",
	"44231:44232:37888:46011",
	"44231:44232:37888:37915:44825:2226:46552",
	"44231:44232:37888:43573:2851:XY-2582931773:47116",
	"44231:44232:37888:43573:2851:XY-2582931773:XY-2473159877:47133",
	"44231:44232:37888:43573:2851:XY-2582931773:XY-2473159877",
	"44231:44232:37888:43573:2851:XY-2582931773:47061",
	"44231:44232:37888:43573:2851:XY-2582931773",
	"44231:44232:37888:2389:47644",
	"44231:44232:37888:2389:47644:47655",
	"44231:44232:37888:2389:47661",
	"44231:44232:37888:37915:47665",
	"44233:47875",
	"12636:44407:2861:3305:47927",
	"12636:44407:2861:13177:48321:48318",
	"12636:44407:2861:13177:48321",
	"44231:44232:37888:37915:44825:50463",
	"12636:44407:2861:13177:43086:6026:85734",
	"12636:238480:241031:251081:242011",
	"12636:238480:242913:239639:246560",
	"12636:238480:241031:249150",
	"12636:238480:241031:241036",
	"12636:238480:241031",
	"12636:238480:241031:251081",
	"12636:238480:241031:251073",
	"12636:238480:242913:239639",
	"12636:238480:242913:246564",
	"12636:238480:242913",
	"12636:238480",
	--["name"] = "Eastwall Tower, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 2646306920,
	["direct"] = "12636:44233:28621:44231",
	["f"] = 0,
	},
	[2861] = {
	"2851:2389:2226",
	"2851:2389",
	"44407:12636",
	"2851:4314",
	"2851:43573:37888:44232:44233",
	"44407:12636:44230:28621",
	"44407:12636:44230",
	"2851:43573:37888:44232",
	"2851:43573:37888",
	"2851:43573:46004:37915",
	"2851:43573:46004:37915:XY-1876468864",
	"1387:43053",
	"1387:43052",
	"13177:43086",
	"3305:43220",
	"2851:43573",
	"2851:43573:37888:44232:44231",
	"2851:43573:46004:37915:44825",
	"2851:2389:47644:47655:46552:XY-1742964349",
	"2851:43573:46004",
	"2851:43573:46004:46011",
	"2851:2389:47644:47655:46552",
	"XY-2582931773:47116",
	"XY-2582931773:XY-2473159877:47133",
	"XY-2582931773:XY-2473159877",
	"XY-2582931773:47061",
	"2851:2389:47644",
	"2851:2389:47644:47655",
	"2851:2389:47661",
	"2851:2389:47665",
	"2851:43573:46004:46011:47875",
	"3305:47927",
	"13177:48321:48318",
	"13177:48321",
	"2851:43573:46004:37915:44825:50463",
	"13177:43086:6026:85734",
	"44407:12636:238480:241031:251081:242011",
	"44407:12636:238480:242913:239639:246560",
	"44407:12636:238480:241031:249150",
	"44407:12636:238480:241031:241036",
	"44407:12636:238480:241031",
	"44407:12636:238480:241031:251081",
	"44407:12636:238480:241031:251073",
	"44407:12636:238480:242913:239639",
	"44407:12636:238480:242913:246564",
	"44407:12636:238480:242913",
	"44407:12636:238480",
	--["name"] = "New Kargath, Badlands",
	["m"] = 15,
	["f"] = 0,
	["direct"] = "XY-1887477213:2851:2858:1387:6026:13177:3305:44408:44407:XY-2582931773",
	["coord"] = 740320947,
	},
	[85734] = {
	"6026:43086:13177:2861:2851:2389:2226",
	"6026:43086:13177:2861:XY-1887477213",
	"6026:43086:13177:2861:2851:2389",
	"6026:43086:13177:2861:2851",
	"43052:43053:2858",
	"43052:1387",
	"6026:43086:13177:2861",
	"6026:43086:13177:2861:44407:12636",
	"6026:43086:13177",
	"6026:43086:13177:3305",
	"6026:43086:13177:2861:2851:4314",
	"6026:43086:13177:2861:2851:43573:37888:44232:44233",
	"6026:43086:13177:2861:44407:12636:44230:28621",
	"6026:43086:13177:2861:44407:12636:44230",
	"6026:43086:13177:2861:2851:43573:37888:44232",
	"6026:43086:13177:2861:2851:43573:37888",
	"6026:43086:13177:2861:2851:43573:46004:37915",
	"6026:43086:13177:2861:2851:43573:46004:37915:XY-1876468864",
	"43052:43053",
	"6026:43086",
	"6026:43086:13177:3305:43220",
	"6026:43086:13177:2861:2851:43573",
	"6026:43086:13177:2861:2851:43573:37888:44232:44231",
	"6026:43086:13177:2861:44408",
	"6026:43086:13177:2861:44407",
	"6026:43086:13177:2861:2851:43573:46004:37915:44825",
	"6026:43086:13177:2861:2851:2389:47644:47655:46552:XY-1742964349",
	"6026:43086:13177:2861:2851:43573:46004",
	"6026:43086:13177:2861:2851:43573:46004:46011",
	"6026:43086:13177:2861:2851:2389:47644:47655:46552",
	"6026:43086:13177:2861:XY-2582931773:47116",
	"6026:43086:13177:2861:XY-2582931773:XY-2473159877:47133",
	"6026:43086:13177:2861:XY-2582931773:XY-2473159877",
	"6026:43086:13177:2861:XY-2582931773:47061",
	"6026:43086:13177:2861:XY-2582931773",
	"6026:43086:13177:2861:2851:2389:47644",
	"6026:43086:13177:2861:2851:2389:47644:47655",
	"6026:43086:13177:2861:2851:2389:47661",
	"6026:43086:13177:2861:2851:2389:47665",
	"6026:43086:13177:2861:2851:43573:46004:46011:47875",
	"6026:43086:13177:48321:48318:47927",
	"6026:43086:13177:48321:48318",
	"6026:43086:13177:48321",
	"6026:43086:13177:2861:2851:43573:46004:37915:44825:50463",
	"6026:43086:13177:2861:44407:12636:238480:241031:251081:242011",
	"6026:43086:13177:2861:44407:12636:238480:242913:239639:246560",
	"6026:43086:13177:2861:44407:12636:238480:241031:249150",
	"6026:43086:13177:2861:44407:12636:238480:241031:241036",
	"6026:43086:13177:2861:44407:12636:238480:241031",
	"6026:43086:13177:2861:44407:12636:238480:241031:251081",
	"6026:43086:13177:2861:44407:12636:238480:241031:251073",
	"6026:43086:13177:2861:44407:12636:238480:242913:239639",
	"6026:43086:13177:2861:44407:12636:238480:242913:246564",
	"6026:43086:13177:2861:44407:12636:238480:242913",
	"6026:43086:13177:2861:44407:12636:238480",
	--["name"] = "Shattered Landing, Blasted Lands",
	["m"] = 17,
	["f"] = 0,
	["direct"] = "6026:43052",
	["coord"] = 3135208587,
	},
	[242011] = {
	"251081:241031:238480:12636:37888:37915:44825:2226",
	"251081:241031:238480:12636:37888:XY-1887477213",
	"251081:241031:238480:12636:37888:2389",
	"251081:241031:238480:12636:4314:2851",
	"251081:241031:238480:12636:44407:2861:2858",
	"251081:241031:238480:12636:44407:2861:1387",
	"251081:241031:238480:12636:44407:2861",
	"251081:241031:238480:12636:44407:2861:13177:43086:6026",
	"251081:241031:238480:12636",
	"251081:241031:238480:12636:44407:2861:13177",
	"251081:241031:238480:12636:44407:2861:3305",
	"251081:241031:238480:12636:4314",
	"251081:241031:238480:12636:44230:44233",
	"251081:241031:238480:12636:44230:28621",
	"251081:241031:238480:12636:44230",
	"251081:241031:238480:12636:44231:44232",
	"251081:241031:238480:12636:37888",
	"251081:241031:238480:12636:37888:37915",
	"251081:241031:238480:12636:37888:37915:XY-1876468864",
	"251081:241031:238480:12636:44407:2861:1387:43053",
	"251081:241031:238480:12636:44407:2861:1387:43052",
	"251081:241031:238480:12636:44407:2861:13177:43086",
	"251081:241031:238480:12636:37888:XY-1887477213:43220",
	"251081:241031:238480:12636:37888:43573",
	"251081:241031:238480:12636:44231",
	"251081:241031:238480:12636:44407:44408",
	"251081:241031:238480:12636:44407",
	"251081:241031:238480:12636:37888:37915:44825",
	"251081:241031:238480:12636:37888:37915:44825:2226:46552:XY-1742964349",
	"251081:241031:238480:12636:37888:46011:46004",
	"251081:241031:238480:12636:37888:46011",
	"251081:241031:238480:12636:37888:37915:44825:2226:46552",
	"251081:241031:238480:12636:4314:2851:XY-2582931773:47116",
	"251081:241031:238480:12636:4314:2851:XY-2582931773:XY-2473159877:47133",
	"251081:241031:238480:12636:4314:2851:XY-2582931773:XY-2473159877",
	"251081:241031:238480:12636:4314:2851:XY-2582931773:47061",
	"251081:241031:238480:12636:4314:2851:XY-2582931773",
	"251081:241031:238480:12636:37888:2389:47644",
	"251081:241031:238480:12636:37888:2389:47644:47655",
	"251081:241031:238480:12636:37888:2389:47661",
	"251081:241031:238480:12636:37888:37915:47665",
	"251081:241031:238480:12636:44230:44233:47875",
	"251081:241031:238480:12636:44407:2861:3305:47927",
	"251081:241031:238480:12636:44407:2861:13177:48321:48318",
	"251081:241031:238480:12636:44407:2861:13177:48321",
	"251081:241031:238480:12636:37888:37915:44825:50463",
	"251081:241031:238480:12636:44407:2861:13177:43086:6026:85734",
	"251073:239639:246560",
	"251081:241031:249150",
	"251081:241036",
	"251081:241031",
	"251073:239639",
	"251073:246564",
	"251073:242913",
	"251081:241031:238480",
	--["name"] = "Camp Stonewash, Zul'Aman",
	["m"] = 2437,
	["f"] = 0,
	["direct"] = "251081:251073",
	["coord"] = 2031501612,
	},
	[241031] = {
	"238480:12636:37888:37915:44825:2226",
	"238480:12636:37888:XY-1887477213",
	"238480:12636:37888:2389",
	"238480:12636:4314:2851",
	"238480:12636:44407:2861:2858",
	"238480:12636:44407:2861:1387",
	"238480:12636:44407:2861",
	"238480:12636:44407:2861:13177:43086:6026",
	"238480:12636",
	"238480:12636:44407:2861:13177",
	"238480:12636:44407:2861:3305",
	"238480:12636:4314",
	"238480:12636:44230:44233",
	"238480:12636:44230:28621",
	"238480:12636:44230",
	"238480:12636:44231:44232",
	"238480:12636:37888",
	"238480:12636:37888:37915",
	"238480:12636:37888:37915:XY-1876468864",
	"238480:12636:44407:2861:1387:43053",
	"238480:12636:44407:2861:1387:43052",
	"238480:12636:44407:2861:13177:43086",
	"238480:12636:37888:XY-1887477213:43220",
	"238480:12636:37888:43573",
	"238480:12636:44231",
	"238480:12636:44407:44408",
	"238480:12636:44407",
	"238480:12636:37888:37915:44825",
	"238480:12636:37888:37915:44825:2226:46552:XY-1742964349",
	"238480:12636:37888:46011:46004",
	"238480:12636:37888:46011",
	"238480:12636:37888:37915:44825:2226:46552",
	"238480:12636:4314:2851:XY-2582931773:47116",
	"238480:12636:4314:2851:XY-2582931773:XY-2473159877:47133",
	"238480:12636:4314:2851:XY-2582931773:XY-2473159877",
	"238480:12636:4314:2851:XY-2582931773:47061",
	"238480:12636:4314:2851:XY-2582931773",
	"238480:12636:37888:2389:47644",
	"238480:12636:37888:2389:47644:47655",
	"238480:12636:37888:2389:47661",
	"238480:12636:37888:37915:47665",
	"238480:12636:44230:44233:47875",
	"238480:12636:44407:2861:3305:47927",
	"238480:12636:44407:2861:13177:48321:48318",
	"238480:12636:44407:2861:13177:48321",
	"238480:12636:37888:37915:44825:50463",
	"238480:12636:44407:2861:13177:43086:6026:85734",
	"251081:242011",
	"238480:242913:239639:246560",
	"238480:242913:239639",
	"251073:246564",
	"238480:242913",
	["m"] = 2536,
	["direct"] = "249150:241036:251081:251073:238480",
	--["name"] = "Atal'Aman, Zul'Aman",
	["f"] = 0,
	},
	[2389] = {
	"2851:2861:2858",
	"2851:2861:1387",
	"2851:2861",
	"2851:2861:13177:43086:6026",
	"37888:12636",
	"2851:2861:13177",
	"2851:2861:3305",
	"37888:44232:44233",
	"37888:44232:28621",
	"37888:44232:44231:44230",
	"37888:44232",
	"37915:XY-1876468864",
	"2851:2861:1387:43053",
	"2851:2861:1387:43052",
	"2851:2861:13177:43086",
	"XY-1887477213:43220",
	"37888:44232:44231",
	"2851:2861:44408",
	"2851:2861:44407",
	"37915:44825",
	"47644:47655:46552:XY-1742964349",
	"37915:46004",
	"37915:46004:46011",
	"47644:47655:46552",
	"2851:XY-2582931773:47116",
	"2851:XY-2582931773:XY-2473159877:47133",
	"2851:XY-2582931773:XY-2473159877",
	"2851:XY-2582931773:47061",
	"2851:XY-2582931773",
	"47644:47655",
	"37915:46004:46011:47875",
	"2851:2861:3305:47927",
	"2851:2861:13177:48321:48318",
	"2851:2861:13177:48321",
	"2226:50463",
	"2851:2861:13177:43086:6026:85734",
	"37888:12636:238480:241031:251081:242011",
	"37888:12636:238480:242913:239639:246560",
	"37888:12636:238480:241031:249150",
	"37888:12636:238480:241031:241036",
	"37888:12636:238480:241031",
	"37888:12636:238480:241031:251081",
	"37888:12636:238480:241031:251073",
	"37888:12636:238480:242913:239639",
	"37888:12636:238480:242913:246564",
	"37888:12636:238480:242913",
	"37888:12636:238480",
	--["name"] = "Tarren Mill, Hillsbrad",
	["m"] = 25,
	["coord"] = 2407101964,
	["direct"] = "2226:XY-1887477213:2851:4314:37888:37915:43573:47644:47661:47665",
	["f"] = 0,
	},
	[47644] = {
	"47655:46552:2226",
	"2389:XY-1887477213",
	"2389:2851",
	"2389:2851:2861:2858",
	"2389:2851:2861:1387",
	"2389:2851:2861",
	"2389:2851:2861:13177:43086:6026",
	"2389:37888:12636",
	"2389:2851:2861:13177",
	"2389:2851:2861:3305",
	"2389:4314",
	"2389:37888:44232:44233",
	"2389:37888:44232:28621",
	"2389:37888:44232:44231:44230",
	"2389:37888:44232",
	"2389:37888",
	"2389:37915",
	"2389:37915:XY-1876468864",
	"2389:2851:2861:1387:43053",
	"2389:2851:2861:1387:43052",
	"2389:2851:2861:13177:43086",
	"2389:XY-1887477213:43220",
	"2389:43573",
	"2389:37888:44232:44231",
	"2389:2851:2861:44408",
	"2389:2851:2861:44407",
	"2389:37915:44825",
	"47655:46552:XY-1742964349",
	"2389:37915:46004",
	"2389:37915:46004:46011",
	"47655:46552",
	"2389:2851:XY-2582931773:47116",
	"2389:2851:XY-2582931773:XY-2473159877:47133",
	"2389:2851:XY-2582931773:XY-2473159877",
	"2389:2851:XY-2582931773:47061",
	"2389:2851:XY-2582931773",
	"2389:47665",
	"2389:37915:46004:46011:47875",
	"2389:2851:2861:3305:47927",
	"2389:2851:2861:13177:48321:48318",
	"2389:2851:2861:13177:48321",
	"47655:46552:2226:50463",
	"2389:2851:2861:13177:43086:6026:85734",
	"2389:37888:12636:238480:241031:251081:242011",
	"2389:37888:12636:238480:242913:239639:246560",
	"2389:37888:12636:238480:241031:249150",
	"2389:37888:12636:238480:241031:241036",
	"2389:37888:12636:238480:241031",
	"2389:37888:12636:238480:241031:251081",
	"2389:37888:12636:238480:241031:251073",
	"2389:37888:12636:238480:242913:239639",
	"2389:37888:12636:238480:242913:246564",
	"2389:37888:12636:238480:242913",
	"2389:37888:12636:238480",
	--["name"] = "Ruins of Southshore, Hillsbrad",
	["m"] = 25,
	["f"] = 0,
	["direct"] = "2389:47655:47661",
	["coord"] = 2107025790,
	},
	[242913] = {
	"238480:12636:37888:37915:44825:2226",
	"238480:12636:37888:XY-1887477213",
	"238480:12636:37888:2389",
	"238480:12636:4314:2851",
	"238480:12636:44407:2861:2858",
	"238480:12636:44407:2861:1387",
	"238480:12636:44407:2861",
	"238480:12636:44407:2861:13177:43086:6026",
	"238480:12636",
	"238480:12636:44407:2861:13177",
	"238480:12636:44407:2861:3305",
	"238480:12636:4314",
	"238480:12636:44230:44233",
	"238480:12636:44230:28621",
	"238480:12636:44230",
	"238480:12636:44231:44232",
	"238480:12636:37888",
	"238480:12636:37888:37915",
	"238480:12636:37888:37915:XY-1876468864",
	"238480:12636:44407:2861:1387:43053",
	"238480:12636:44407:2861:1387:43052",
	"238480:12636:44407:2861:13177:43086",
	"238480:12636:37888:XY-1887477213:43220",
	"238480:12636:37888:43573",
	"238480:12636:44231",
	"238480:12636:44407:44408",
	"238480:12636:44407",
	"238480:12636:37888:37915:44825",
	"238480:12636:37888:37915:44825:2226:46552:XY-1742964349",
	"238480:12636:37888:46011:46004",
	"238480:12636:37888:46011",
	"238480:12636:37888:37915:44825:2226:46552",
	"238480:12636:4314:2851:XY-2582931773:47116",
	"238480:12636:4314:2851:XY-2582931773:XY-2473159877:47133",
	"238480:12636:4314:2851:XY-2582931773:XY-2473159877",
	"238480:12636:4314:2851:XY-2582931773:47061",
	"238480:12636:4314:2851:XY-2582931773",
	"238480:12636:37888:2389:47644",
	"238480:12636:37888:2389:47644:47655",
	"238480:12636:37888:2389:47661",
	"238480:12636:37888:37915:47665",
	"238480:12636:44230:44233:47875",
	"238480:12636:44407:2861:3305:47927",
	"238480:12636:44407:2861:13177:48321:48318",
	"238480:12636:44407:2861:13177:48321",
	"238480:12636:37888:37915:44825:50463",
	"238480:12636:44407:2861:13177:43086:6026:85734",
	"251073:242011",
	"239639:246560",
	"238480:241031:249150",
	"238480:241031:241036",
	"238480:241031",
	"251073:251081",
	--["name"] = "Fairbreeze Village, Eversong Woods",
	["m"] = 2395,
	["f"] = 0,
	["direct"] = "251073:239639:246564:238480",
	["coord"] = 1918006081,
	},
	[239639] = {
	"242913:238480:12636:37888:37915:44825:2226",
	"242913:238480:12636:37888:XY-1887477213",
	"242913:238480:12636:37888:2389",
	"242913:238480:12636:4314:2851",
	"242913:238480:12636:44407:2861:2858",
	"242913:238480:12636:44407:2861:1387",
	"242913:238480:12636:44407:2861",
	"242913:238480:12636:44407:2861:13177:43086:6026",
	"242913:238480:12636",
	"242913:238480:12636:44407:2861:13177",
	"242913:238480:12636:44407:2861:3305",
	"242913:238480:12636:4314",
	"242913:238480:12636:44230:44233",
	"242913:238480:12636:44230:28621",
	"242913:238480:12636:44230",
	"242913:238480:12636:44231:44232",
	"242913:238480:12636:37888",
	"242913:238480:12636:37888:37915",
	"242913:238480:12636:37888:37915:XY-1876468864",
	"242913:238480:12636:44407:2861:1387:43053",
	"242913:238480:12636:44407:2861:1387:43052",
	"242913:238480:12636:44407:2861:13177:43086",
	"242913:238480:12636:37888:XY-1887477213:43220",
	"242913:238480:12636:37888:43573",
	"242913:238480:12636:44231",
	"242913:238480:12636:44407:44408",
	"242913:238480:12636:44407",
	"242913:238480:12636:37888:37915:44825",
	"242913:238480:12636:37888:37915:44825:2226:46552:XY-1742964349",
	"242913:238480:12636:37888:46011:46004",
	"242913:238480:12636:37888:46011",
	"242913:238480:12636:37888:37915:44825:2226:46552",
	"242913:238480:12636:4314:2851:XY-2582931773:47116",
	"242913:238480:12636:4314:2851:XY-2582931773:XY-2473159877:47133",
	"242913:238480:12636:4314:2851:XY-2582931773:XY-2473159877",
	"242913:238480:12636:4314:2851:XY-2582931773:47061",
	"242913:238480:12636:4314:2851:XY-2582931773",
	"242913:238480:12636:37888:2389:47644",
	"242913:238480:12636:37888:2389:47644:47655",
	"242913:238480:12636:37888:2389:47661",
	"242913:238480:12636:37888:37915:47665",
	"242913:238480:12636:44230:44233:47875",
	"242913:238480:12636:44407:2861:3305:47927",
	"242913:238480:12636:44407:2861:13177:48321:48318",
	"242913:238480:12636:44407:2861:13177:48321",
	"242913:238480:12636:37888:37915:44825:50463",
	"242913:238480:12636:44407:2861:13177:43086:6026:85734",
	"251073:242011",
	"242913:238480:241031:249150",
	"251073:251081:241036",
	"242913:238480:241031",
	"251073:251081",
	"242913:238480",
	--["name"] = "Sanctum of Light, Silvermoon City",
	["m"] = 2393,
	["f"] = 0,
	["direct"] = "246560:251073:246564:242913",
	["coord"] = 2189080013,
	},
	},
	{
		[22455] = {
			"20762:18942:16587", -- [1]
			"20762:18942", -- [2]
			"20762:18791", -- [3]
			"20762:18940:18808", -- [4]
			"20762:18940:18807:19317", -- [5]
			"20762:18940:18807", -- [6]
			"20762:18940", -- [7]
			"20762:18942:16587:18930", -- [8]
			"18938:19583", -- [9]
			"20762:18940:18807:19317:19581", -- [10]
			"20762:18942:16587:19558", -- [11]
			"18938:20515", -- [12]
			"18953:22216", -- [13]
			["direct"] = "18938:18953:20762",
			["f"] = 0,
			["m"] = 105,
			["coord"] = 3279595658,
		},
		[18953] = {
			"20762:18942:16587", -- [1]
			"20762:18942", -- [2]
			"18791:18808", -- [3]
			"20762:18940:18807:19317", -- [4]
			"20762:18940:18807", -- [5]
			"20762:18940", -- [6]
			"20762:18942:16587:18930", -- [7]
			"20762:18940:18807:19317:19581", -- [8]
			"20762:18942:16587:19558", -- [9]
			"18938:20515", -- [10]
			["direct"] = "18791:18938:19583:20762:22216:22455",
			["coord"] = 2236451551,
			["m"] = 105,
			["f"] = 0,
		},
		[19558] = {
			"16587:18942", -- [1]
			"16587:18942:18791", -- [2]
			"16587:18942:18808", -- [3]
			"16587:18942:20762:22455:18938", -- [4]
			"16587:18807:19317", -- [5]
			"16587:18942:20762:18953", -- [6]
			"16587:18807", -- [7]
			"16587:18940", -- [8]
			"16587:18930", -- [9]
			"16587:18942:20762:22455:18938:19583", -- [10]
			"16587:18807:19317:19581", -- [11]
			"16587:18942:20762:22455:18938:20515", -- [12]
			"16587:18942:20762", -- [13]
			"16587:18942:20762:18953:22216", -- [14]
			"16587:18942:20762:22455", -- [15]
			["direct"] = "16587",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 2645348352,
		},
		[18940] = {
			"20762:22455:18938", -- [1]
			"18807:19317", -- [2]
			"20762:18953", -- [3]
			"16587:18930", -- [4]
			"20762:22455:18938:19583", -- [5]
			"18807:19317:19581", -- [6]
			"16587:19558", -- [7]
			"20762:22455:18938:20515", -- [8]
			"20762:18953:22216", -- [9]
			"20762:22455", -- [10]
			["direct"] = "16587:18942:18791:18808:18807:20762",
			["f"] = 0,
			["m"] = 111,
			["coord"] = 2745330149,
		},
		[18942] = {
			"20762:22455:18938", -- [1]
			"18940:18807:19317", -- [2]
			"20762:18953", -- [3]
			"18940:18807", -- [4]
			"16587:18930", -- [5]
			"20762:22455:18938:19583", -- [6]
			"18940:18807:19317:19581", -- [7]
			"16587:19558", -- [8]
			"20762:22455:18938:20515", -- [9]
			"20762:18953:22216", -- [10]
			"20762:22455", -- [11]
			["direct"] = "16587:18791:18808:18940:20762",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 1196333511,
		},
		[16587] = {
			"18942:18791", -- [1]
			"18942:18808", -- [2]
			"18942:20762:22455:18938", -- [3]
			"18807:19317", -- [4]
			"18942:20762:18953", -- [5]
			"18942:20762:22455:18938:19583", -- [6]
			"18807:19317:19581", -- [7]
			"18942:20762:22455:18938:20515", -- [8]
			"18942:20762", -- [9]
			"18942:20762:18953:22216", -- [10]
			"18942:20762:22455", -- [11]
			["direct"] = "18942:18807:18940:18930:19558",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 2416663840,
		},
		[19317] = {
			"18807:16587", -- [1]
			"18807:18940:18942", -- [2]
			"18807:18940:18791", -- [3]
			"18807:18940:18808", -- [4]
			"18807:18940:20762:22455:18938", -- [5]
			"18807:18940:20762:18953", -- [6]
			"18807:18940", -- [7]
			"18807:16587:18930", -- [8]
			"18807:18940:20762:22455:18938:19583", -- [9]
			"18807:16587:19558", -- [10]
			"18807:18940:20762:22455:18938:20515", -- [11]
			"18807:18940:20762", -- [12]
			"18807:18940:20762:18953:22216", -- [13]
			"18807:18940:20762:22455", -- [14]
			["direct"] = "18807:19581",
			["f"] = 0,
			["m"] = 104,
			["coord"] = 1302481601,
		},
		[19581] = {
			"19317:18807:16587", -- [1]
			"19317:18807:18940:18942", -- [2]
			"19317:18807:18940:18791", -- [3]
			"19317:18807:18940:18808", -- [4]
			"19317:18807:18940:20762:22455:18938", -- [5]
			"19317:18807:18940:20762:18953", -- [6]
			"19317:18807", -- [7]
			"19317:18807:18940", -- [8]
			"19317:18807:16587:18930", -- [9]
			"19317:18807:18940:20762:22455:18938:19583", -- [10]
			"19317:18807:16587:19558", -- [11]
			"19317:18807:18940:20762:22455:18938:20515", -- [12]
			"19317:18807:18940:20762", -- [13]
			"19317:18807:18940:20762:18953:22216", -- [14]
			"19317:18807:18940:20762:22455", -- [15]
			["direct"] = "19317",
			["f"] = 0,
			["m"] = 104,
			["coord"] = 2717011449,
		},
		[18791] = {
			"18942:16587", -- [1]
			"18953:18938", -- [2]
			"18940:18807:19317", -- [3]
			"18940:18807", -- [4]
			"18942:16587:18930", -- [5]
			"18953:18938:19583", -- [6]
			"18940:18807:19317:19581", -- [7]
			"18942:16587:19558", -- [8]
			"18953:18938:20515", -- [9]
			"18953:22216", -- [10]
			"18953:22455", -- [11]
			["direct"] = "18942:18808:18953:18940:20762",
			["f"] = 0,
			["m"] = 102,
			["coord"] = 1417380620,
		},
		[18807] = {
			"18940:18942", -- [1]
			"18940:18791", -- [2]
			"18940:18808", -- [3]
			"18940:20762:22455:18938", -- [4]
			"18940:20762:18953", -- [5]
			"16587:18930", -- [6]
			"18940:20762:22455:18938:19583", -- [7]
			"19317:19581", -- [8]
			"16587:19558", -- [9]
			"18940:20762:22455:18938:20515", -- [10]
			"18940:20762", -- [11]
			"18940:20762:18953:22216", -- [12]
			"18940:20762:22455", -- [13]
			["direct"] = "16587:19317:18940",
			["f"] = 0,
			["m"] = 108,
			["coord"] = 2115268468,
		},
		[18938] = {
			"22455:20762:18942:16587", -- [1]
			"22455:20762:18942", -- [2]
			"22455:20762:18791", -- [3]
			"22455:20762:18940:18808", -- [4]
			"22455:20762:18940:18807:19317", -- [5]
			"22455:20762:18940:18807", -- [6]
			"22455:20762:18940", -- [7]
			"22455:20762:18942:16587:18930", -- [8]
			"22455:20762:18940:18807:19317:19581", -- [9]
			"22455:20762:18942:16587:19558", -- [10]
			"22455:20762", -- [11]
			["direct"] = "18953:19583:20515:22216:22455",
			["f"] = 0,
			["m"] = 109,
			["coord"] = 1451533221,
		},
		[18808] = {
			"18942:16587", -- [1]
			"18791:18953:18938", -- [2]
			"18940:18807:19317", -- [3]
			"18791:18953", -- [4]
			"18940:18807", -- [5]
			"18942:16587:18930", -- [6]
			"18791:18953:18938:19583", -- [7]
			"18940:18807:19317:19581", -- [8]
			"18942:16587:19558", -- [9]
			"18791:18953:18938:20515", -- [10]
			"18940:20762", -- [11]
			"18791:18953:22216", -- [12]
			"18940:20762:22455", -- [13]
			["direct"] = "18942:18791:18940",
			["f"] = 0,
			["m"] = 107,
			["coord"] = 2458409611,
		},
		[18930] = {
			"18942:18791", -- [1]
			"18942:18808", -- [2]
			"18942:20762:22455:18938", -- [3]
			"16587:18807:19317", -- [4]
			"18942:20762:18953", -- [5]
			"16587:18807", -- [6]
			"16587:18940", -- [7]
			"18942:20762:22455:18938:19583", -- [8]
			"16587:18807:19317:19581", -- [9]
			"16587:19558", -- [10]
			"18942:20762:22455:18938:20515", -- [11]
			"18942:20762", -- [12]
			"18942:20762:18953:22216", -- [13]
			"18942:20762:22455", -- [14]
			["direct"] = "16587:18942",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 3752950617,
		},
		[20762] = {
			"18942:16587", -- [1]
			"18940:18808", -- [2]
			"22455:18938", -- [3]
			"18940:18807:19317", -- [4]
			"18940:18807", -- [5]
			"18942:16587:18930", -- [6]
			"22455:18938:19583", -- [7]
			"18940:18807:19317:19581", -- [8]
			"18942:16587:19558", -- [9]
			"22455:18938:20515", -- [10]
			"18953:22216", -- [11]
			["direct"] = "18942:18791:18953:18940:22455",
			["f"] = 0,
			["m"] = 102,
			["coord"] = 3639643342,
		},
		[19583] = {
			"18938:22455:20762:18942:16587", -- [1]
			"18938:22455:20762:18942", -- [2]
			"18953:18791", -- [3]
			"18938:22455:20762:18940:18808", -- [4]
			"18938:22455:20762:18940:18807:19317", -- [5]
			"18938:22455:20762:18940:18807", -- [6]
			"18938:22455:20762:18940", -- [7]
			"18938:22455:20762:18942:16587:18930", -- [8]
			"18938:22455:20762:18940:18807:19317:19581", -- [9]
			"18938:22455:20762:18942:16587:19558", -- [10]
			"18938:22455:20762", -- [11]
			"18938:22216", -- [12]
			"18938:22455", -- [13]
			["direct"] = "18938:18953:20515",
			["f"] = 0,
			["m"] = 109,
			["coord"] = 1944213875,
		},
		[20515] = {
			"18938:22455:20762:18942:16587", -- [1]
			"18938:22455:20762:18942", -- [2]
			"18938:22455:20762:18791", -- [3]
			"18938:22455:20762:18940:18808", -- [4]
			"18938:22455:20762:18940:18807:19317", -- [5]
			"18938:18953", -- [6]
			"18938:22455:20762:18940:18807", -- [7]
			"18938:22455:20762:18940", -- [8]
			"18938:22455:20762:18942:16587:18930", -- [9]
			"18938:22455:20762:18940:18807:19317:19581", -- [10]
			"18938:22455:20762:18942:16587:19558", -- [11]
			"18938:22455:20762", -- [12]
			"18938:22216", -- [13]
			"18938:22455", -- [14]
			["direct"] = "18938:19583",
			["f"] = 0,
			["m"] = 109,
			["coord"] = 2800462568,
		},
		[22216] = {
			"18953:20762:18942:16587", -- [1]
			"18953:20762:18942", -- [2]
			"18953:18791", -- [3]
			"18953:18791:18808", -- [4]
			"18953:20762:18940:18807:19317", -- [5]
			"18953:20762:18940:18807", -- [6]
			"18953:20762:18940", -- [7]
			"18953:20762:18942:16587:18930", -- [8]
			"18938:19583", -- [9]
			"18953:20762:18940:18807:19317:19581", -- [10]
			"18953:20762:18942:16587:19558", -- [11]
			"18938:20515", -- [12]
			"18953:20762", -- [13]
			"18953:22455", -- [14]
			["direct"] = "18938:18953",
			["coord"] = 2648008034,
			["m"] = 105,
			["f"] = 0,
		},
	}, -- [3]
	{
		[26852] = {
			"26844:24155", -- [1]
			"24032:27344", -- [2]
			"26845:26851:26566:26847:24795:27046", -- [3]
			"26845:26851", -- [4]
			"26845:26851:26566", -- [5]
			"26845:28196:28195:25288", -- [6]
			"26845:26851:26566:26847", -- [7]
			"26845:26851:26566:26847:26848", -- [8]
			"26845:26851:26850", -- [9]
			"26845:26851:26566:26847:24795", -- [10]
			"26845:28196", -- [11]
			"26844:28197", -- [12]
			"26845:28196:28195", -- [13]
			"28618:28623", -- [14]
			"28618:28615", -- [15]
			"28618:28623:28624", -- [16]
			"28618:28615:28674:28574", -- [17]
			"28618:28615:28674", -- [18]
			"28618:28615:29721", -- [19]
			"28618:28623:28624:32571", -- [20]
			"28618:28615:29721:29757", -- [21]
			"28618:28615:29721:29762", -- [22]
			"28618:28615:28674:31069:31078", -- [23]
			"28618:28615:29721:29757:29951", -- [24]
			"28618:28615:29721:29757:29950", -- [25]
			"28618:28623:28624:30569", -- [26]
			"26845:26851:26566:30870", -- [27]
			"28618:28615:28674:31069:30314", -- [28]
			"28618:28615:28674:30433", -- [29]
			"28618:28615:28674:31069", -- [30]
			"28618:28615:30269", -- [31]
			"28618:28615:28674:33849", -- [32]
			"28618:28615:28674:28574:28037", -- [33]
			["m"] = 116,
			["coord"] = 942974243,
			["direct"] = "24032:26844:26853:26845:28618",
			["f"] = 0,
		},
		[26853] = {
			"24032:24155", -- [1]
			"28618:28615:26850:26566:26847:24795:27046", -- [2]
			"24032:26844", -- [3]
			"28618:28615:26851", -- [4]
			"26852:26845", -- [5]
			"28618:28615:26850:26566", -- [6]
			"28618:28615:28674:25288", -- [7]
			"28618:28615:26850:26566:26847", -- [8]
			"28618:28615:28674:28574:26848", -- [9]
			"28618:28615:26850", -- [10]
			"28618:28615:26850:26566:26847:24795", -- [11]
			"26852:26845:28196", -- [12]
			"24032:26844:28197", -- [13]
			"26852:26845:28196:28195", -- [14]
			"28618:28615", -- [15]
			"28618:28615:28674:28574", -- [16]
			"28618:28615:28674", -- [17]
			"28618:28615:29721", -- [18]
			"28624:32571", -- [19]
			"28618:28615:29721:29757", -- [20]
			"28624:29762", -- [21]
			"28618:28615:28674:31069:31078", -- [22]
			"28624:29951", -- [23]
			"28618:28615:29721:29757:29950", -- [24]
			"28624:30569", -- [25]
			"28618:28615:28674:30870", -- [26]
			"28618:28615:28674:31069:30314", -- [27]
			"28618:28615:28674:30433", -- [28]
			"28618:28615:28674:31069", -- [29]
			"28618:28615:30269", -- [30]
			"28618:28615:28674:33849", -- [31]
			"28618:28615:28674:28574:28037", -- [32]
			["m"] = 116,
			["coord"] = 2789373946,
			["direct"] = "27344:24032:26852:28623:28618:28624",
			["f"] = 0,
		},
		[28618] = {
			"26852:26844:24155", -- [1]
			"26853:27344", -- [2]
			"26853:24032", -- [3]
			"28615:26850:26566:26847:24795:27046", -- [4]
			"26852:26844", -- [5]
			"28615:26851", -- [6]
			"28615:26850:26566", -- [7]
			"28615:28674:25288", -- [8]
			"28615:26850:26566:26847", -- [9]
			"28615:28674:28574:26848", -- [10]
			"28615:26850", -- [11]
			"28615:26850:26566:26847:24795", -- [12]
			"28615:26851:28196", -- [13]
			"26852:26844:28197", -- [14]
			"28615:26851:28196:28195", -- [15]
			"28623:28624", -- [16]
			"28615:28674:28574", -- [17]
			"28615:28674", -- [18]
			"28615:29721", -- [19]
			"28623:28624:32571", -- [20]
			"28615:29721:29757", -- [21]
			"28615:29721:29762", -- [22]
			"28615:28674:31069:31078", -- [23]
			"28615:29721:29757:29951", -- [24]
			"28615:29721:29757:29950", -- [25]
			"28623:28624:30569", -- [26]
			"28615:28674:30870", -- [27]
			"28615:28674:31069:30314", -- [28]
			"28615:28674:30433", -- [29]
			"28615:28674:31069", -- [30]
			"28615:30269", -- [31]
			"28615:28674:33849", -- [32]
			"28615:28674:28574:28037", -- [33]
			["m"] = 121,
			["f"] = 0,
			["direct"] = "26853:26852:26845:28623:28615",
			["coord"] = 1381678745,
		},
		[31078] = {
			"30870:26566:26845:24155", -- [1]
			"30870:26566:26845:26852:24032:27344", -- [2]
			"30870:26566:26845:26852:24032", -- [3]
			"28574:26848:24795:27046", -- [4]
			"30870:26566:26845:26844", -- [5]
			"30870:26566:26845:26852:26853", -- [6]
			"30870:26566:26845:26852", -- [7]
			"30870:26566:26851", -- [8]
			"30870:26566:26845", -- [9]
			"30870:26566", -- [10]
			"28574:26848:25288", -- [11]
			"30870:26847", -- [12]
			"28574:26848", -- [13]
			"30870:26566:26850", -- [14]
			"28574:26848:24795", -- [15]
			"30870:26566:28196", -- [16]
			"30870:26566:26845:26844:28197", -- [17]
			"30870:26847:28195", -- [18]
			"31069:30433:28674:28615:28623", -- [19]
			"31069:30433:28674:28615", -- [20]
			"31069:30433:28674:28615:28618", -- [21]
			"30314:29950:29951:28624", -- [22]
			"31069:30433:28674", -- [23]
			"31069:30433:28674:29721", -- [24]
			"30314:29950:29951:32571", -- [25]
			"30314:29950:29757", -- [26]
			"30314:29950:29951:29762", -- [27]
			"30314:29950:29951", -- [28]
			"30314:29950", -- [29]
			"30314:29950:29951:28624:30569", -- [30]
			"31069:30433", -- [31]
			"31069:30433:28674:30269", -- [32]
			"30314:33849", -- [33]
			"28037:26848:24795:27046", -- [34]
			"28037:26848:25288", -- [35]
			"28037:26848", -- [36]
			"28037:26848:24795", -- [37]
			["direct"] = "28574:28037:30870:30314:31069",
			["f"] = 0,
			["m"] = 118,
			["coord"] = 831814222,
		},
		[28623] = {
			"26853:24032:24155", -- [1]
			"26853:27344", -- [2]
			"26853:24032", -- [3]
			"28615:26850:26566:26847:24795:27046", -- [4]
			"28618:26852:26844", -- [5]
			"28618:26852", -- [6]
			"28615:26851", -- [7]
			"28618:26845", -- [8]
			"28615:26850:26566", -- [9]
			"28615:28674:25288", -- [10]
			"28615:26850:26566:26847", -- [11]
			"28615:28674:28574:26848", -- [12]
			"28615:26850", -- [13]
			"28615:26850:26566:26847:24795", -- [14]
			"28615:26851:28196", -- [15]
			"28618:26852:26844:28197", -- [16]
			"28615:26851:28196:28195", -- [17]
			"28615:28674:28574", -- [18]
			"28615:28674", -- [19]
			"28615:29721", -- [20]
			"28624:32571", -- [21]
			"28615:29721:29757", -- [22]
			"28624:29762", -- [23]
			"28615:28674:31069:31078", -- [24]
			"28624:29951", -- [25]
			"28615:29721:29757:29950", -- [26]
			"28624:30569", -- [27]
			"28615:28674:30870", -- [28]
			"28615:28674:31069:30314", -- [29]
			"28615:28674:30433", -- [30]
			"28615:28674:31069", -- [31]
			"28615:30269", -- [32]
			"28615:28674:33849", -- [33]
			"28615:28674:28574:28037", -- [34]
			["direct"] = "26853:28615:28618:28624",
			["f"] = 0,
			["m"] = 121,
			["coord"] = 1782293786,
		},
		[28624] = {
			"26853:24032:24155", -- [1]
			"26853:27344", -- [2]
			"26853:24032", -- [3]
			"28623:28615:26850:26566:26847:24795:27046", -- [4]
			"26853:24032:26844", -- [5]
			"28623:28618:26852", -- [6]
			"28623:28615:26851", -- [7]
			"28623:28618:26845", -- [8]
			"28623:28615:26850:26566", -- [9]
			"28623:28615:28674:25288", -- [10]
			"28623:28615:26850:26566:26847", -- [11]
			"28623:28615:28674:28574:26848", -- [12]
			"28623:28615:26850", -- [13]
			"28623:28615:26850:26566:26847:24795", -- [14]
			"28623:28615:26851:28196", -- [15]
			"26853:24032:26844:28197", -- [16]
			"28623:28615:26851:28196:28195", -- [17]
			"28623:28615", -- [18]
			"28623:28618", -- [19]
			"28623:28615:28674:28574", -- [20]
			"28623:28615:28674", -- [21]
			"28623:28615:29721", -- [22]
			"29762:29757", -- [23]
			"28623:28615:28674:31069:31078", -- [24]
			"29951:29950", -- [25]
			"28623:28615:28674:30870", -- [26]
			"29951:29950:30314", -- [27]
			"28623:28615:28674:30433", -- [28]
			"28623:28615:28674:31069", -- [29]
			"28623:28615:30269", -- [30]
			"29951:29950:33849", -- [31]
			"28623:28615:28674:28574:28037", -- [32]
			["m"] = 121,

			["f"] = 0,
			["direct"] = "26853:28623:32571:29762:29951:30569",
			["coord"] = 2575864175,
		},
		[25288] = {
			"26847:26566:26845:24155", -- [1]
			"26847:26566:26845:26852:24032:27344", -- [2]
			"26847:26566:26845:26852:24032", -- [3]
			"24795:27046", -- [4]
			"26847:26566:26845:26844", -- [5]
			"26847:26566:26845:26852:26853", -- [6]
			"26847:26566:26845:26852", -- [7]
			"26847:26566:26851", -- [8]
			"26847:26566:26845", -- [9]
			"26847:26566", -- [10]
			"26847:26566:26850", -- [11]
			"28195:28196", -- [12]
			"28195:28196:28197", -- [13]
			"26847:26566:26851:28615:28623", -- [14]
			"26847:26566:26851:28615", -- [15]
			"26847:26566:26845:28618", -- [16]
			"26847:26566:26851:28615:28623:28624", -- [17]
			"26848:28574", -- [18]
			"28674:29721", -- [19]
			"28674:29721:32571", -- [20]
			"28674:29721:29757", -- [21]
			"28674:29721:29762", -- [22]
			"26848:28574:31078", -- [23]
			"28674:29721:29757:29951", -- [24]
			"26848:28574:31078:30314:29950", -- [25]
			"26847:26566:26851:28615:28623:28624:30569", -- [26]
			"26847:30870", -- [27]
			"26848:28574:31078:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"28674:30269", -- [31]
			"26848:28574:31078:30314:33849", -- [32]
			"26848:28037", -- [33]
			"26848:28037:31078", -- [34]
			"26848:28037:31078:30314:29950", -- [35]
			"26848:28037:31078:30314", -- [36]
			"26848:28037:31078:30314:33849", -- [37]
			["m"] = 114,
			["f"] = 0,
			["direct"] = "26847:26848:24795:28195:28674",
			["coord"] = 1731232670,
		},
		[24155] = {
			"28197:28196:28195:26847:24795:27046", -- [1]
			"24032:26853", -- [2]
			"26844:26852", -- [3]
			"26845:26851", -- [4]
			"26845:26851:26566", -- [5]
			"28197:28196:28195:25288", -- [6]
			"28197:28196:28195:26847", -- [7]
			"28197:28196:28195:26847:26848", -- [8]
			"26845:26851:26850", -- [9]
			"28197:28196:28195:26847:24795", -- [10]
			"28197:28196", -- [11]
			"28197:28196:28195", -- [12]
			"24032:26853:28623", -- [13]
			"26844:26852:28618:28615", -- [14]
			"26844:26852:28618", -- [15]
			"24032:26853:28624", -- [16]
			"26845:26851:26566:30870:28574", -- [17]
			"26844:26852:28618:28615:28674", -- [18]
			"26844:26852:28618:28615:29721", -- [19]
			"24032:26853:28624:32571", -- [20]
			"26844:26852:28618:28615:29721:29757", -- [21]
			"24032:26853:28624:29762", -- [22]
			"26844:26852:28618:28615:28674:31069:31078", -- [23]
			"24032:26853:28624:29951", -- [24]
			"26844:26852:28618:28615:29721:29757:29950", -- [25]
			"24032:26853:28624:30569", -- [26]
			"26845:26851:26566:30870", -- [27]
			"26844:26852:28618:28615:28674:31069:30314", -- [28]
			"26844:26852:28618:28615:28674:30433", -- [29]
			"26844:26852:28618:28615:28674:31069", -- [30]
			"26844:26852:28618:28615:30269", -- [31]
			"26844:26852:28618:28615:28674:33849", -- [32]
			"28197:28196:28195:26847:26848:28037", -- [33]
			["m"] = 117,
			["coord"] = 2235214962,
			["direct"] = "27344:24032:26844:26845:28197",
			["f"] = 0,
		},
		[24032] = {
			"26844:26845:26851:26566:26847:24795:27046", -- [1]
			"26844:26845:26851", -- [2]
			"26844:26845", -- [3]
			"26844:26845:26851:26566", -- [4]
			"26844:26845:28196:28195:25288", -- [5]
			"26844:26845:26851:26566:26847", -- [6]
			"26844:26845:26851:26566:26847:26848", -- [7]
			"26844:26845:26851:26850", -- [8]
			"26844:26845:26851:26566:26847:24795", -- [9]
			"26844:26845:28196", -- [10]
			"26844:28197", -- [11]
			"26844:26845:28196:28195", -- [12]
			"26853:28623", -- [13]
			"26853:28618:28615", -- [14]
			"26853:28618", -- [15]
			"26853:28624", -- [16]
			"26853:28618:28615:28674:28574", -- [17]
			"26853:28618:28615:28674", -- [18]
			"26853:28618:28615:29721", -- [19]
			"26853:28624:32571", -- [20]
			"26853:28618:28615:29721:29757", -- [21]
			"26853:28624:29762", -- [22]
			"26853:28618:28615:28674:31069:31078", -- [23]
			"26853:28624:29951", -- [24]
			"26853:28618:28615:29721:29757:29950", -- [25]
			"26853:28624:30569", -- [26]
			"26844:26845:26851:26566:30870", -- [27]
			"26853:28618:28615:28674:31069:30314", -- [28]
			"26853:28618:28615:28674:30433", -- [29]
			"26853:28618:28615:28674:31069", -- [30]
			"26853:28618:28615:30269", -- [31]
			"26853:28618:28615:28674:33849", -- [32]
			"26853:28618:28615:28674:28574:28037", -- [33]
			["m"] = 117,
			["coord"] = 2127502707,
			["direct"] = "24155:27344:26844:26853:26852",
			["f"] = 0,
		},
		[28195] = {
			"28196:28197:24155", -- [1]
			"28196:26845:26852:24032:27344", -- [2]
			"28196:26845:26852:24032", -- [3]
			"26847:24795:27046", -- [4]
			"28196:26845:26844", -- [5]
			"28196:26845:26852:26853", -- [6]
			"28196:26845:26852", -- [7]
			"26847:26566:26851", -- [8]
			"28196:26845", -- [9]
			"26847:26566", -- [10]
			"26847:26848", -- [11]
			"26847:26566:26850", -- [12]
			"26847:24795", -- [13]
			"28196:28197", -- [14]
			"28196:26845:28615:28623", -- [15]
			"28196:26845:28615", -- [16]
			"28196:26845:28618", -- [17]
			"28196:26845:28615:28623:28624", -- [18]
			"26847:26848:28574", -- [19]
			"26847:26566:26850:28674", -- [20]
			"26847:26566:26850:28674:29721", -- [21]
			"26847:26566:26850:28674:29721:32571", -- [22]
			"26847:26566:26850:28674:29721:29757", -- [23]
			"26847:26566:26850:28674:29721:29762", -- [24]
			"26847:30870:31078", -- [25]
			"26847:26566:26850:28674:29721:29757:29951", -- [26]
			"26847:30870:30314:29950", -- [27]
			"28196:26845:28615:28623:28624:30569", -- [28]
			"26847:30870", -- [29]
			"26847:30870:30314", -- [30]
			"26847:26566:26850:28674:30433", -- [31]
			"26847:30870:31069", -- [32]
			"28196:26845:28615:30269", -- [33]
			"26847:30870:30314:33849", -- [34]
			"26847:26848:28037", -- [35]
			["direct"] = "25288:26847:28196",
			["coord"] = 3371205577,
			["m"] = 114,
			["f"] = 0,
		},
		[28196] = {
			"28197:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"28195:26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"28195:25288", -- [8]
			"28195:26847", -- [9]
			"28195:26847:26848", -- [10]
			"26851:26850", -- [11]
			"28195:26847:24795", -- [12]
			"26845:28615:28623", -- [13]
			"26845:28615", -- [14]
			"26845:28618", -- [15]
			"26845:28615:28623:28624", -- [16]
			"26566:30870:28574", -- [17]
			"28674:29721", -- [18]
			"28674:29721:32571", -- [19]
			"28674:29721:29757", -- [20]
			"28674:29721:29762", -- [21]
			"26566:30870:31078", -- [22]
			"28674:29721:29757:29951", -- [23]
			"28674:29721:29757:29950", -- [24]
			"26845:28615:28623:28624:30569", -- [25]
			"26566:30870", -- [26]
			"28674:31069:30314", -- [27]
			"28674:30433", -- [28]
			"28674:31069", -- [29]
			"26845:28615:30269", -- [30]
			"28674:33849", -- [31]
			"28195:26847:26848:28037", -- [32]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "26851:26845:26566:28197:28195:28674",
			["coord"] = 2081603196,
		},
		[28197] = {
			"24155:27344", -- [1]
			"26844:24032", -- [2]
			"28196:28195:26847:24795:27046", -- [3]
			"26844:24032:26853", -- [4]
			"26844:26852", -- [5]
			"26844:26845:26851", -- [6]
			"26844:26845", -- [7]
			"28196:26566", -- [8]
			"28196:28195:25288", -- [9]
			"28196:28195:26847", -- [10]
			"28196:28195:26847:26848", -- [11]
			"26844:26845:26851:26850", -- [12]
			"28196:28195:26847:24795", -- [13]
			"28196:28195", -- [14]
			"26844:26852:28618:28623", -- [15]
			"26844:26852:28618:28615", -- [16]
			"26844:26852:28618", -- [17]
			"26844:24032:26853:28624", -- [18]
			"28196:26566:30870:28574", -- [19]
			"26844:26852:28618:28615:28674", -- [20]
			"26844:26852:28618:28615:29721", -- [21]
			"26844:24032:26853:28624:32571", -- [22]
			"26844:26852:28618:28615:29721:29757", -- [23]
			"26844:24032:26853:28624:29762", -- [24]
			"28196:26566:30870:31078", -- [25]
			"26844:26852:28618:28615:29721:29757:29951", -- [26]
			"26844:26852:28618:28615:29721:29757:29950", -- [27]
			"26844:24032:26853:28624:30569", -- [28]
			"28196:26566:30870", -- [29]
			"26844:26852:28618:28615:28674:31069:30314", -- [30]
			"26844:26852:28618:28615:28674:30433", -- [31]
			"26844:26852:28618:28615:28674:31069", -- [32]
			"26844:26852:28618:28615:30269", -- [33]
			"26844:26852:28618:28615:28674:33849", -- [34]
			"28196:28195:26847:26848:28037", -- [35]
			["direct"] = "24155:26844:28196",
			["f"] = 0,
			["m"] = 117,
			["coord"] = 1058378765,
		},
		[26566] = {
			"26845:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"26847:25288", -- [8]
			"26847:26848", -- [9]
			"26847:24795", -- [10]
			"26845:26844:28197", -- [11]
			"26847:28195", -- [12]
			"26851:28615:28623", -- [13]
			"26851:28615", -- [14]
			"26845:28618", -- [15]
			"26851:28615:28623:28624", -- [16]
			"30870:28574", -- [17]
			"26850:28674", -- [18]
			"26850:28674:29721", -- [19]
			"26850:28674:29721:32571", -- [20]
			"26850:28674:29721:29757", -- [21]
			"26850:28674:29721:29762", -- [22]
			"30870:31078", -- [23]
			"26850:28674:29721:29757:29951", -- [24]
			"26850:28674:29721:29757:29950", -- [25]
			"26851:28615:28623:28624:30569", -- [26]
			"30870:30314", -- [27]
			"26850:28674:30433", -- [28]
			"26850:28674:31069", -- [29]
			"26850:28674:30269", -- [30]
			"26850:28674:33849", -- [31]
			"26847:26848:28037", -- [32]
			["m"] = 115,
			["coord"] = 1609331968,
			["direct"] = "26851:26845:26847:26850:28196:30870",
			["f"] = 0,
		},
		[29721] = {
			"28615:28618:26852:26844:24155", -- [1]
			"28615:28618:26853:27344", -- [2]
			"28615:28618:26853:24032", -- [3]
			"28674:25288:24795:27046", -- [4]
			"28615:28618:26852:26844", -- [5]
			"28615:28618:26853", -- [6]
			"28615:28618:26852", -- [7]
			"28615:26851", -- [8]
			"28615:26845", -- [9]
			"28674:26850:26566", -- [10]
			"28674:25288", -- [11]
			"28674:26850:26566:26847", -- [12]
			"28674:28574:26848", -- [13]
			"28674:26850", -- [14]
			"28674:25288:24795", -- [15]
			"28615:26851:28196", -- [16]
			"28615:28618:26852:26844:28197", -- [17]
			"28615:26851:28196:28195", -- [18]
			"28615:28623", -- [19]
			"28615:28618", -- [20]
			"28615:28623:28624", -- [21]
			"28674:28574", -- [22]
			"28674:31069:31078", -- [23]
			"29757:29951", -- [24]
			"29757:29950", -- [25]
			"28615:28623:28624:30569", -- [26]
			"28674:30870", -- [27]
			"29757:29950:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"29757:29950:33849", -- [31]
			"28674:28574:28037", -- [32]
			["m"] = 120,
			["coord"] = 1750521958,
			["direct"] = "28615:28674:32571:29757:29762:30269",
			["f"] = 0,
		},
		[30569] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"28624:28623:28615:26850:26566:26847:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"28624:28623:28618:26852", -- [7]
			"28624:28623:28615:26851", -- [8]
			"28624:28623:28618:26845", -- [9]
			"28624:28623:28615:26850:26566", -- [10]
			"28624:28623:28615:28674:25288", -- [11]
			"28624:28623:28615:26850:26566:26847", -- [12]
			"28624:28623:28615:28674:28574:26848", -- [13]
			"28624:28623:28615:26850", -- [14]
			"28624:28623:28615:26850:26566:26847:24795", -- [15]
			"28624:28623:28615:26851:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"28624:28623:28615:26851:28196:28195", -- [18]
			"28624:28623", -- [19]
			"28624:28623:28615", -- [20]
			"28624:28623:28618", -- [21]
			"28624:28623:28615:28674:28574", -- [22]
			"28624:28623:28615:28674", -- [23]
			"28624:28623:28615:29721", -- [24]
			"28624:32571", -- [25]
			"28624:29762:29757", -- [26]
			"28624:29762", -- [27]
			"28624:28623:28615:28674:31069:31078", -- [28]
			"28624:29951", -- [29]
			"28624:29951:29950", -- [30]
			"28624:28623:28615:28674:30870", -- [31]
			"28624:29951:29950:30314", -- [32]
			"28624:28623:28615:28674:30433", -- [33]
			"28624:28623:28615:28674:31069", -- [34]
			"28624:28623:28615:30269", -- [35]
			"28624:29951:29950:33849", -- [36]
			"28624:28623:28615:28674:28574:28037", -- [37]
			["direct"] = "28624",
			["coord"] = 3025877835,
			["m"] = 121,
			["f"] = 0,
		},
		[33849] = {
			"29950:29951:28624:26853:24032:24155", -- [1]
			"31069:30433:28674:27344", -- [2]
			"29950:29951:28624:26853:24032", -- [3]
			"30314:30870:26847:24795:27046", -- [4]
			"31069:30433:28674:28615:28618:26852:26844", -- [5]
			"29950:29951:28624:26853", -- [6]
			"31069:30433:28674:28615:28618:26852", -- [7]
			"31069:30433:28674:26851", -- [8]
			"31069:30433:28674:26850:26845", -- [9]
			"31069:30433:28674:26850:26566", -- [10]
			"30314:30870:26847:25288", -- [11]
			"30314:30870:26847", -- [12]
			"30314:31078:28574:26848", -- [13]
			"31069:30433:28674:26850", -- [14]
			"30314:30870:26847:24795", -- [15]
			"31069:30433:28674:28196", -- [16]
			"31069:30433:28674:28615:28618:26852:26844:28197", -- [17]
			"30314:30870:26847:28195", -- [18]
			"31069:30433:28674:28615:28623", -- [19]
			"31069:30433:28674:28615", -- [20]
			"31069:30433:28674:28615:28618", -- [21]
			"29950:29951:28624", -- [22]
			"30314:31078:28574", -- [23]
			"29950:29757:29721", -- [24]
			"29950:29951:32571", -- [25]
			"29950:29757", -- [26]
			"29950:29951:29762", -- [27]
			"30314:31078", -- [28]
			"29950:29951", -- [29]
			"29950:29951:28624:30569", -- [30]
			"30314:30870", -- [31]
			"31069:30433", -- [32]
			"31069:30433:28674:30269", -- [33]
			"30314:31078:28037:26848", -- [34]
			"30314:31078:28037", -- [35]			
			["direct"] = "28674:29950:30314:31069",
			["coord"] = 3118086692,
			["m"] = 118,
			["f"] = 0,
		},
		[29951] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"29950:30314:30870:26847:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"29757:29721:28615:28618:26852", -- [7]
			"29757:29721:28615:26851", -- [8]
			"29757:29721:28615:26845", -- [9]
			"29757:30433:28674:26850:26566", -- [10]
			"29757:30433:28674:25288", -- [11]
			"29950:30314:30870:26847", -- [12]
			"29950:30314:31078:28574:26848", -- [13]
			"29757:30433:28674:26850", -- [14]
			"29950:30314:30870:26847:24795", -- [15]
			"29757:30433:28674:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"29950:30314:30870:26847:28195", -- [18]
			"28624:28623", -- [19]
			"29757:29721:28615", -- [20]
			"29757:29721:28615:28618", -- [21]
			"29950:30314:31078:28574", -- [22]
			"29757:30433:28674", -- [23]
			"29757:29721", -- [24]
			"29950:30314:31078", -- [25]
			"28624:30569", -- [26]
			"29950:30314:30870", -- [27]
			"29950:30314", -- [28]
			"29757:30433", -- [29]
			"29757:30433:31069", -- [30]
			"29757:29721:30269", -- [31]
			"29950:33849", -- [32]
			"29950:30314:31078:28037:26848", -- [33]
			"29950:30314:31078:28037", -- [34]			
			["m"] = 120,
			["coord"] = 1911834618,
			["direct"] = "28624:32571:29757:29762:29950",
			["f"] = 0,
		},
		[29757] = {
			"29721:28615:28618:26852:26844:24155", -- [1]
			"29762:28624:26853:27344", -- [2]
			"29762:28624:26853:24032", -- [3]
			"30433:28674:25288:24795:27046", -- [4]
			"29721:28615:28618:26852:26844", -- [5]
			"29762:28624:26853", -- [6]
			"29721:28615:28618:26852", -- [7]
			"29721:28615:26851", -- [8]
			"29721:28615:26845", -- [9]
			"30433:28674:26850:26566", -- [10]
			"30433:28674:25288", -- [11]
			"30433:31069:30870:26847", -- [12]
			"30433:28674:28574:26848", -- [13]
			"30433:28674:26850", -- [14]
			"30433:28674:25288:24795", -- [15]
			"30433:28674:28196", -- [16]
			"29721:28615:28618:26852:26844:28197", -- [17]
			"30433:31069:30870:26847:28195", -- [18]
			"29721:28615:28623", -- [19]
			"29721:28615", -- [20]
			"29721:28615:28618", -- [21]
			"29762:28624", -- [22]
			"30433:28674:28574", -- [23]
			"30433:28674", -- [24]
			"29762:32571", -- [25]
			"29950:30314:31078", -- [26]
			"29762:28624:30569", -- [27]
			"30433:31069:30870", -- [28]
			"29950:30314", -- [29]
			"30433:31069", -- [30]
			"29721:30269", -- [31]
			"29950:33849", -- [32]
			"29950:30314:31078:28037", -- [33]			
			["m"] = 120,
			["coord"] = 1555988062,
			["direct"] = "29721:29762:29951:29950:30433",
			["f"] = 0,
		},
		[31069] = {
			"30433:28674:26850:26845:24155", -- [1]
			"30433:28674:27344", -- [2]
			"30433:28674:28615:28618:26853:24032", -- [3]
			"30870:26847:24795:27046", -- [4]
			"30433:28674:28615:28618:26852:26844", -- [5]
			"30433:28674:28615:28618:26853", -- [6]
			"30433:28674:28615:28618:26852", -- [7]
			"30433:28674:26851", -- [8]
			"30433:28674:26850:26845", -- [9]
			"30433:28674:26850:26566", -- [10]
			"30870:26847:25288", -- [11]
			"30870:26847", -- [12]
			"30870:28574:26848", -- [13]
			"30433:28674:26850", -- [14]
			"30870:26847:24795", -- [15]
			"30433:28674:28196", -- [16]
			"30433:28674:28615:28618:26852:26844:28197", -- [17]
			"30870:26847:28195", -- [18]
			"30433:28674:28615:28623", -- [19]
			"30433:28674:28615", -- [20]
			"30433:28674:28615:28618", -- [21]
			"30433:28674:28615:28623:28624", -- [22]
			"30870:28574", -- [23]
			"30433:28674:29721", -- [24]
			"30433:28674:29721:32571", -- [25]
			"30433:29757", -- [26]
			"30433:28674:29721:29762", -- [27]
			"30433:29757:29951", -- [28]
			"33849:29950", -- [29]
			"30433:28674:28615:28623:28624:30569", -- [30]
			"30433:28674:30269", -- [31]
			"30870:28574:28037", -- [1]			
			["m"] = 118,
			["coord"] = 3408050485,
			["direct"] = "28674:31078:30870:30314:30433:33849",
			["f"] = 0,
		},
		[28674] = {
			"26850:26845:24155", -- [1]
			"28615:28618:26853:24032", -- [2]
			"25288:24795:27046", -- [3]
			"28615:28618:26852:26844", -- [4]
			"28615:28618:26853", -- [5]
			"28615:28618:26852", -- [6]
			"26850:26845", -- [7]
			"26850:26566", -- [8]
			"26850:26566:26847", -- [9]
			"28574:26848", -- [10]
			"25288:24795", -- [11]
			"28615:28618:26852:26844:28197", -- [12]
			"26850:26566:26847:28195", -- [13]
			"28615:28623", -- [14]
			"28615:28618", -- [15]
			"28615:28623:28624", -- [16]
			"29721:32571", -- [17]
			"29721:29757", -- [18]
			"29721:29762", -- [19]
			"31069:31078", -- [20]
			"29721:29757:29951", -- [21]
			"29721:29757:29950", -- [22]
			"28615:28623:28624:30569", -- [23]
			"31069:30314", -- [24]
			"28574:28037", -- [25]
			"28574:28037", -- [26]			
			["m"] = 125,
			["coord"] = 3111024148,
			["direct"] = "27344:26851:25288:26850:28196:28615:28574:29721:30870:30433:31069:30269:33849",
			["f"] = 0,
		},
		[29950] = {
			"29951:28624:26853:24032:24155", -- [1]
			"29951:28624:26853:27344", -- [2]
			"29951:28624:26853:24032", -- [3]
			"30314:30870:26847:24795:27046", -- [4]
			"29757:29721:28615:28618:26852:26844", -- [5]
			"29951:28624:26853", -- [6]
			"29757:29721:28615:28618:26852", -- [7]
			"29757:29721:28615:26851", -- [8]
			"29757:29721:28615:26845", -- [9]
			"29757:30433:28674:26850:26566", -- [10]
			"30314:30870:26847:25288", -- [11]
			"30314:30870:26847", -- [12]
			"30314:31078:28574:26848", -- [13]
			"29757:30433:28674:26850", -- [14]
			"30314:30870:26847:24795", -- [15]
			"29757:30433:28674:28196", -- [16]
			"29757:29721:28615:28618:26852:26844:28197", -- [17]
			"30314:30870:26847:28195", -- [18]
			"29757:29721:28615:28623", -- [19]
			"29757:29721:28615", -- [20]
			"29757:29721:28615:28618", -- [21]
			"29951:28624", -- [22]
			"30314:31078:28574", -- [23]
			"29757:30433:28674", -- [24]
			"29757:29721", -- [25]
			"29951:32571", -- [26]
			"29951:29762", -- [27]
			"30314:31078", -- [28]
			"29951:28624:30569", -- [29]
			"30314:30870", -- [30]
			"29757:30433", -- [31]
			"33849:31069", -- [32]
			"29757:29721:30269", -- [33]
			"30314:31078:28037:26848", -- [34]
			"30314:31078:28037", -- [35]			
			["direct"] = "29757:29951:30314:33849",
			["coord"] = 1315200266,
			["m"] = 120,
			["f"] = 0,
		},
		[24795] = {
			"26847:26566:26845:24155", -- [1]
			"26847:26566:26845:26852:24032:27344", -- [2]
			"26847:26566:26845:26852:24032", -- [3]
			"26847:26566:26845:26844", -- [4]
			"26847:26566:26845:26852:26853", -- [5]
			"26847:26566:26845:26852", -- [6]
			"26847:26566:26851", -- [7]
			"26847:26566:26845", -- [8]
			"26847:26566", -- [9]
			"26847:26566:26850", -- [10]
			"26847:28195:28196", -- [11]
			"26847:26566:26845:26844:28197", -- [12]
			"26847:28195", -- [13]
			"26847:26566:26851:28615:28623", -- [14]
			"26847:26566:26851:28615", -- [15]
			"26847:26566:26845:28618", -- [16]
			"26847:26566:26851:28615:28623:28624", -- [17]
			"26848:28574", -- [18]
			"26847:26566:26850:28674", -- [19]
			"26847:26566:26850:28674:29721", -- [20]
			"26847:26566:26850:28674:29721:32571", -- [21]
			"26847:26566:26850:28674:29721:29757", -- [22]
			"26847:26566:26850:28674:29721:29762", -- [23]
			"26848:28574:31078", -- [24]
			"26848:28574:31078:30314:29950:29951", -- [25]
			"26848:28574:31078:30314:29950", -- [26]
			"26847:26566:26851:28615:28623:28624:30569", -- [27]
			"26847:30870", -- [28]
			"26848:28574:31078:30314", -- [29]
			"26847:26566:26850:28674:30433", -- [30]
			"26847:30870:31069", -- [31]
			"26847:26566:26850:28674:30269", -- [32]
			"26848:28574:31078:30314:33849", -- [33]
			"26848:28037", -- [34]
			"26848:28037:31078", -- [35]
			"26848:28037:31078:30314:29950:29951", -- [36]
			"26848:28037:31078:30314:29950", -- [37]
			"26848:28037:31078:30314", -- [38]
			"26848:28037:31078:30314:33849", -- [39]			
			["direct"] = "27046:25288:26847:26848",
			["f"] = 0,
			["m"] = 114,
			["coord"] = 1939560416,
		},
		[32571] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"29721:28674:25288:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"28624:28623:28618:26852", -- [7]
			"29721:28615:26851", -- [8]
			"29721:28615:26845", -- [9]
			"29721:28674:26850:26566", -- [10]
			"29721:28674:25288", -- [11]
			"29721:28674:26850:26566:26847", -- [12]
			"29721:28674:28574:26848", -- [13]
			"29721:28674:26850", -- [14]
			"29721:28674:25288:24795", -- [15]
			"29721:28615:26851:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"29721:28615:26851:28196:28195", -- [18]
			"28624:28623", -- [19]
			"29721:28615", -- [20]
			"28624:28623:28618", -- [21]
			"29721:28674:28574", -- [22]
			"29721:28674", -- [23]
			"29951:29757", -- [24]
			"29951:29950:30314:31078", -- [25]
			"29951:29950", -- [26]
			"28624:30569", -- [27]
			"29721:28674:30870", -- [28]
			"29951:29950:30314", -- [29]
			"29721:28674:30433", -- [30]
			"29721:28674:31069", -- [31]
			"29721:30269", -- [32]
			"29951:29950:33849", -- [33]
			"29721:28674:28574:28037", -- [34]
			"29762:29757", -- [35]
			["direct"] = "28624:29721:29762:29951",
			["coord"] = 2686753797,
			["m"] = 120,
			["f"] = 0,
		},
		[30870] = {
			"26566:26845:24155", -- [1]
			"26566:26845:26852:24032:27344", -- [2]
			"26566:26845:26852:24032", -- [3]
			"26847:24795:27046", -- [4]
			"26566:26845:26844", -- [5]
			"26566:26845:26852:26853", -- [6]
			"26566:26845:26852", -- [7]
			"26566:26851", -- [8]
			"26566:26845", -- [9]
			"26847:25288", -- [10]
			"28574:26848", -- [11]
			"26566:26850", -- [12]
			"26847:24795", -- [13]
			"26566:28196", -- [14]
			"26566:26845:26844:28197", -- [15]
			"26847:28195", -- [16]
			"28674:28615:28623", -- [17]
			"28674:28615", -- [18]
			"28674:28615:28618", -- [19]
			"28674:28615:28623:28624", -- [20]
			"28674:29721", -- [21]
			"28674:29721:32571", -- [22]
			"28674:29721:29757", -- [23]
			"28674:29721:29762", -- [24]
			"28674:29721:29757:29951", -- [25]
			"30314:29950", -- [26]
			"28674:28615:28623:28624:30569", -- [27]
			"28674:30433", -- [28]
			"28674:30269", -- [29]
			"30314:33849", -- [30]
			"28574:28037", -- [31]
			["m"] = 123,
			["coord"] = 929192263,
			["direct"] = "26566:26847:28574:28674:31078:30314:31069",
			["f"] = 0,
		},
		[28037] = {
			"26848:26847:26566:26845:24155", -- [1]
			"26848:26847:26566:26845:26852:24032:27344", -- [2]
			"26848:26847:26566:26845:26852:24032", -- [3]
			"26848:24795:27046", -- [4]
			"26848:26847:26566:26845:26844", -- [5]
			"26848:26847:26566:26845:26852:26853", -- [6]
			"26848:26847:26566:26845:26852", -- [7]
			"26848:26847:26566:26851", -- [8]
			"26848:26847:26566:26845", -- [9]
			"26848:26847:26566", -- [10]
			"26848:25288", -- [11]
			"26848:26847", -- [12]
			"26848:26847:26566:26850", -- [13]
			"26848:24795", -- [14]
			"26848:26847:28195:28196", -- [15]
			"26848:26847:26566:26845:26844:28197", -- [16]
			"26848:26847:28195", -- [17]
			"28574:28674:28615:28623", -- [18]
			"28574:28674:28615", -- [19]
			"28574:28674:28615:28618", -- [20]
			"28574:28674:28615:28623:28624", -- [21]
			"28574:28674", -- [22]
			"28574:28674:29721", -- [23]
			"28574:28674:29721:32571", -- [24]
			"31078:30314:29950:29757", -- [25]
			"28574:28674:29721:29762", -- [26]
			"31078:30314:29950:29951", -- [27]
			"31078:30314:29950", -- [28]
			"28574:28674:28615:28623:28624:30569", -- [29]
			"28574:30870", -- [30]
			"31078:30314", -- [31]
			"28574:28674:30433", -- [32]
			"31078:31069", -- [33]
			"28574:28674:30269", -- [34]
			"31078:30314:33849", -- [35]
			["direct"] = "26848:28574:31078",
			["coord"] = 1083348327,
			["m"] = 119,
			["f"] = 0,
			["requirements"] = "qid:12523"
		},		
		[29762] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"29721:28674:25288:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"28624:28623:28618:26852", -- [7]
			"29721:28615:26851", -- [8]
			"29721:28615:26845", -- [9]
			"29721:28674:26850:26566", -- [10]
			"29721:28674:25288", -- [11]
			"29721:28674:26850:26566:26847", -- [12]
			"29721:28674:28574:26848", -- [13]
			"29721:28674:26850", -- [14]
			"29721:28674:25288:24795", -- [15]
			"29721:28615:26851:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"29721:28615:26851:28196:28195", -- [18]
			"28624:28623", -- [19]
			"29721:28615", -- [20]
			"28624:28623:28618", -- [21]
			"29721:28674:28574", -- [22]
			"29721:28674", -- [23]
			"29951:29950:30314:31078", -- [24]
			"29951:29950", -- [25]
			"28624:30569", -- [26]
			"29721:28674:30870", -- [27]
			"29951:29950:30314", -- [28]
			"29757:30433", -- [29]
			"29757:30433:31069", -- [30]
			"29721:30269", -- [31]
			"29951:29950:33849", -- [32]
			"29951:29950:30314:31078:28037", -- [33]
			["m"] = 120,
			["coord"] = 2809037259,
			["direct"] = "28624:29721:32571:29757:29951",
			["f"] = 0,
		},
		[27344] = {
			"24032:26844:26845:26851:26566:26847:24795:27046", -- [1]
			"24032:26844", -- [2]
			"24032:26852", -- [3]
			"24032:26844:26845:26851", -- [4]
			"24032:26844:26845", -- [5]
			"24032:26844:26845:26851:26566", -- [6]
			"24032:26844:26845:28196:28195:25288", -- [7]
			"24032:26844:26845:26851:26566:26847", -- [8]
			"24032:26844:26845:26851:26566:26847:26848", -- [9]
			"26853:28618:28615:26850", -- [10]
			"24032:26844:26845:26851:26566:26847:24795", -- [11]
			"24032:26844:26845:28196", -- [12]
			"24155:28197", -- [13]
			"24032:26844:26845:28196:28195", -- [14]
			"26853:28623", -- [15]
			"26853:28618:28615", -- [16]
			"26853:28618", -- [17]
			"26853:28624", -- [18]
			"28674:28574", -- [19]
			"26853:28618:28615:29721", -- [20]
			"26853:28624:32571", -- [21]
			"26853:28618:28615:29721:29757", -- [22]
			"26853:28624:29762", -- [23]
			"28674:31069:31078", -- [24]
			"26853:28624:29951", -- [25]
			"26853:28618:28615:29721:29757:29950", -- [26]
			"26853:28624:30569", -- [27]
			"28674:30870", -- [28]
			"28674:31069:30314", -- [29]
			"28674:30433", -- [30]
			"28674:31069", -- [31]
			"26853:28618:28615:30269", -- [32]
			"28674:33849", -- [33]
			"28674:28574:28037", -- [34]
			["direct"] = "24155:24032:26853:28674",
			["coord"] = 3394259988,
			["m"] = 117,
			["f"] = 0,
		},
		[30269] = {
			"28615:28618:26852:26844:24155", -- [1]
			"28615:28618:26853:27344", -- [2]
			"28615:28618:26853:24032", -- [3]
			"28674:25288:24795:27046", -- [4]
			"28615:28618:26852:26844", -- [5]
			"28615:28618:26853", -- [6]
			"28615:28618:26852", -- [7]
			"28615:26851", -- [8]
			"28615:26845", -- [9]
			"28674:26850:26566", -- [10]
			"28674:25288", -- [11]
			"28674:26850:26566:26847", -- [12]
			"28674:28574:26848", -- [13]
			"28674:26850", -- [14]
			"28674:25288:24795", -- [15]
			"28615:26851:28196", -- [16]
			"28615:28618:26852:26844:28197", -- [17]
			"28615:26851:28196:28195", -- [18]
			"28615:28623", -- [19]
			"28615:28618", -- [20]
			"28615:28623:28624", -- [21]
			"28674:28574", -- [22]
			"29721:32571", -- [23]
			"29721:29757", -- [24]
			"29721:29762", -- [25]
			"28674:31069:31078", -- [26]
			"29721:29757:29951", -- [27]
			"29721:29757:29950", -- [28]
			"28615:28623:28624:30569", -- [29]
			"28674:30870", -- [30]
			"28674:31069:30314", -- [31]
			"28674:30433", -- [32]
			"28674:31069", -- [33]
			"28674:33849", -- [34]
			"28674:28574:28037", -- [269]			
			["direct"] = "28615:28674:29721",
			["f"] = 0,
			["m"] = 127,
			["coord"] = 3370746011,
		},
		[30433] = {
			"28674:26850:26845:24155", -- [1]
			"28674:27344", -- [2]
			"28674:28615:28618:26853:24032", -- [3]
			"28674:25288:24795:27046", -- [4]
			"28674:28615:28618:26852:26844", -- [5]
			"28674:28615:28618:26853", -- [6]
			"28674:28615:28618:26852", -- [7]
			"28674:26851", -- [8]
			"28674:26850:26845", -- [9]
			"28674:26850:26566", -- [10]
			"28674:25288", -- [11]
			"31069:30870:26847", -- [12]
			"28674:28574:26848", -- [13]
			"28674:26850", -- [14]
			"28674:25288:24795", -- [15]
			"28674:28196", -- [16]
			"28674:28615:28618:26852:26844:28197", -- [17]
			"31069:30870:26847:28195", -- [18]
			"28674:28615:28623", -- [19]
			"28674:28615", -- [20]
			"28674:28615:28618", -- [21]
			"28674:28615:28623:28624", -- [22]
			"28674:28574", -- [23]
			"28674:29721", -- [24]
			"28674:29721:32571", -- [25]
			"28674:29721:29762", -- [26]
			"31069:31078", -- [27]
			"29757:29951", -- [28]
			"29757:29950", -- [29]
			"28674:28615:28623:28624:30569", -- [30]
			"31069:30870", -- [31]
			"28674:30269", -- [32]
			"31069:33849", -- [33]
			"28674:28574:28037", -- [34]
			["direct"] = "28674:29757:30314:31069",
			["f"] = 0,
			["m"] = 118,
			["coord"] = 3770468289,
		},
		[27046] = {
			"24795:26847:26566:26845:24155", -- [1]
			"24795:26847:26566:26845:26852:24032:27344", -- [2]
			"24795:26847:26566:26845:26852:24032", -- [3]
			"24795:26847:26566:26845:26844", -- [4]
			"24795:26847:26566:26845:26852:26853", -- [5]
			"24795:26847:26566:26845:26852", -- [6]
			"24795:26847:26566:26851", -- [7]
			"24795:26847:26566:26845", -- [8]
			"24795:26847:26566", -- [9]
			"24795:25288", -- [10]
			"24795:26847", -- [11]
			"24795:26848", -- [12]
			"24795:26847:26566:26850", -- [13]
			"24795:26847:28195:28196", -- [14]
			"24795:26847:26566:26845:26844:28197", -- [15]
			"24795:26847:28195", -- [16]
			"24795:26847:26566:26851:28615:28623", -- [17]
			"24795:26847:26566:26851:28615", -- [18]
			"24795:26847:26566:26845:28618", -- [19]
			"24795:26847:26566:26851:28615:28623:28624", -- [20]
			"24795:26848:28574", -- [21]
			"24795:26847:26566:26850:28674", -- [22]
			"24795:26847:26566:26850:28674:29721", -- [23]
			"24795:26847:26566:26850:28674:29721:32571", -- [24]
			"24795:26847:26566:26850:28674:29721:29757", -- [25]
			"24795:26847:26566:26850:28674:29721:29762", -- [26]
			"24795:26848:28574:31078", -- [27]
			"24795:26848:28574:31078:30314:29950:29951", -- [28]
			"24795:26848:28574:31078:30314:29950", -- [29]
			"24795:26847:26566:26851:28615:28623:28624:30569", -- [30]
			"24795:26847:30870", -- [31]
			"24795:26848:28574:31078:30314", -- [32]
			"24795:26847:26566:26850:28674:30433", -- [33]
			"24795:26847:30870:31069", -- [34]
			"24795:26847:26566:26850:28674:30269", -- [35]
			"24795:26848:28574:31078:30314:33849", -- [36]
			"24795:26848:28037", -- [37]
			"24795:26848:28037:31078", -- [38]
			"24795:26848:28037:31078:30314:29950:29951", -- [39]
			"24795:26848:28037:31078:30314:29950", -- [40]
			"24795:26848:28037:31078:30314", -- [41]
			"24795:26848:28037:31078:30314:33849", -- [43]			
			["direct"] = "24795",
			["f"] = 0,
			["m"] = 114,
			["coord"] = 1422481428,
		},
		[26844] = {
			"24032:27344", -- [1]
			"26845:26851:26566:26847:24795:27046", -- [2]
			"24032:26853", -- [3]
			"26845:26851", -- [4]
			"26845:26851:26566", -- [5]
			"26845:28196:28195:25288", -- [6]
			"26845:26851:26566:26847", -- [7]
			"26845:26851:26566:26847:26848", -- [8]
			"26845:26851:26850", -- [9]
			"26845:26851:26566:26847:24795", -- [10]
			"26845:28196", -- [11]
			"26845:28196:28195", -- [12]
			"26852:28618:28623", -- [13]
			"26852:28618:28615", -- [14]
			"26852:28618", -- [15]
			"24032:26853:28624", -- [16]
			"26845:26851:26566:30870:28574", -- [17]
			"26852:28618:28615:28674", -- [18]
			"26852:28618:28615:29721", -- [19]
			"24032:26853:28624:32571", -- [20]
			"26852:28618:28615:29721:29757", -- [21]
			"24032:26853:28624:29762", -- [22]
			"26852:28618:28615:28674:31069:31078", -- [23]
			"26852:28618:28615:29721:29757:29951", -- [24]
			"26852:28618:28615:29721:29757:29950", -- [25]
			"24032:26853:28624:30569", -- [26]
			"26845:26851:26566:30870", -- [27]
			"26852:28618:28615:28674:31069:30314", -- [28]
			"26852:28618:28615:28674:30433", -- [29]
			"26852:28618:28615:28674:31069", -- [30]
			"26852:28618:28615:30269", -- [31]
			"26852:28618:28615:28674:33849", -- [32]
			"26845:26851:26566:26847:26848:28037", -- [33]
			["m"] = 117,
			["coord"] = 1115308011,
			["direct"] = "24155:24032:26852:26845:28197",
			["f"] = 0,
		},
		[26845] = {
			"26852:24032:27344", -- [1]
			"26852:24032", -- [2]
			"26851:26566:26847:24795:27046", -- [3]
			"26852:26853", -- [4]
			"28196:28195:25288", -- [5]
			"26851:26566:26847", -- [6]
			"26851:26566:26847:26848", -- [7]
			"26851:26566:26847:24795", -- [8]
			"26844:28197", -- [9]
			"28196:28195", -- [10]
			"28615:28623", -- [11]
			"28615:28623:28624", -- [12]
			"26851:26566:30870:28574", -- [13]
			"26851:28674", -- [14]
			"28615:29721", -- [15]
			"28615:29721:32571", -- [16]
			"28615:29721:29757", -- [17]
			"28615:29721:29762", -- [18]
			"26851:26566:30870:31078", -- [19]
			"28615:29721:29757:29951", -- [20]
			"28615:29721:29757:29950", -- [21]
			"28615:28623:28624:30569", -- [22]
			"26851:26566:30870", -- [23]
			"26851:28674:31069:30314", -- [24]
			"26851:28674:30433", -- [25]
			"26851:28674:31069", -- [26]
			"28615:30269", -- [27]
			"26851:28674:33849", -- [28]
			"26851:26566:26847:26848:28037", -- [29]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "24155:26844:26852:26851:26566:26850:28196:28615:28618",
			["coord"] = 3285163912,
		},
		[28574] = {
			"30870:26566:26845:24155", -- [1]
			"30870:26566:26845:26852:24032:27344", -- [2]
			"30870:26566:26845:26852:24032", -- [3]
			"26848:24795:27046", -- [4]
			"30870:26566:26845:26844", -- [5]
			"28674:28615:28618:26853", -- [6]
			"30870:26566:26845:26852", -- [7]
			"30870:26566:26851", -- [8]
			"30870:26566:26845", -- [9]
			"30870:26566", -- [10]
			"26848:25288", -- [11]
			"26848:26847", -- [12]
			"30870:26566:26850", -- [13]
			"26848:24795", -- [14]
			"30870:26566:28196", -- [15]
			"30870:26566:26845:26844:28197", -- [16]
			"26848:26847:28195", -- [17]
			"28674:28615:28623", -- [18]
			"28674:28615", -- [19]
			"28674:28615:28618", -- [20]
			"28674:28615:28623:28624", -- [21]
			"28674:29721", -- [22]
			"28674:29721:32571", -- [23]
			"28674:29721:29757", -- [24]
			"28674:29721:29762", -- [25]
			"31078:30314:29950:29951", -- [26]
			"31078:30314:29950", -- [27]
			"28674:28615:28623:28624:30569", -- [28]
			"31078:30314", -- [29]
			"28674:30433", -- [30]
			"28674:31069", -- [31]
			"28674:30269", -- [32]
			"31078:30314:33849", -- [33]
			["direct"] = "26848:28037:28674:31078:30870",
			["coord"] = 2150407428,
			["m"] = 119,
			["f"] = 0,
		},
		[26847] = {
			"26566:26845:24155", -- [1]
			"26566:26845:26852:24032:27344", -- [2]
			"26566:26845:26852:24032", -- [3]
			"24795:27046", -- [4]
			"26566:26845:26844", -- [5]
			"26566:26845:26852:26853", -- [6]
			"26566:26845:26852", -- [7]
			"26566:26851", -- [8]
			"26566:26845", -- [9]
			"26566:26850", -- [10]
			"28195:28196", -- [11]
			"26566:26845:26844:28197", -- [12]
			"26566:26851:28615:28623", -- [13]
			"26566:26851:28615", -- [14]
			"26566:26845:28618", -- [15]
			"26566:26851:28615:28623:28624", -- [16]
			"26848:28574", -- [17]
			"26566:26850:28674", -- [18]
			"26566:26850:28674:29721", -- [19]
			"26566:26850:28674:29721:32571", -- [20]
			"26566:26850:28674:29721:29757", -- [21]
			"26566:26850:28674:29721:29762", -- [22]
			"30870:31078", -- [23]
			"26566:26850:28674:29721:29757:29951", -- [24]
			"30870:30314:29950", -- [25]
			"26566:26851:28615:28623:28624:30569", -- [26]
			"30870:30314", -- [27]
			"26566:26850:28674:30433", -- [28]
			"30870:31069", -- [29]
			"26566:26850:28674:30269", -- [30]
			"30870:30314:33849", -- [31]
			"26848:28037", -- [32]
			["m"] = 114,
			["coord"] = 3338821751,
			["direct"] = "26566:25288:26848:24795:28195:30870",
			["f"] = 0,
		},
		[26848] = {
			"26847:26566:26845:24155", -- [1]
			"26847:26566:26845:26852:24032:27344", -- [2]
			"26847:26566:26845:26852:24032", -- [3]
			"24795:27046", -- [4]
			"26847:26566:26845:26844", -- [5]
			"26847:26566:26845:26852:26853", -- [6]
			"26847:26566:26845:26852", -- [7]
			"26847:26566:26851", -- [8]
			"26847:26566:26845", -- [9]
			"26847:26566", -- [10]
			"26847:26566:26850", -- [11]
			"26847:28195:28196", -- [12]
			"26847:26566:26845:26844:28197", -- [13]
			"26847:28195", -- [14]
			"26847:26566:26851:28615:28623", -- [15]
			"26847:26566:26851:28615", -- [16]
			"26847:26566:26845:28618", -- [17]
			"26847:26566:26851:28615:28623:28624", -- [18]
			"28574:28674", -- [19]
			"28574:28674:29721", -- [20]
			"28574:28674:29721:32571", -- [21]
			"28574:28674:29721:29757", -- [22]
			"28574:28674:29721:29762", -- [23]
			"28574:31078", -- [24]
			"28574:31078:30314:29950:29951", -- [25]
			"28574:31078:30314:29950", -- [26]
			"26847:26566:26851:28615:28623:28624:30569", -- [27]
			"28574:30870", -- [28]
			"28574:31078:30314", -- [29]
			"28574:28674:30433", -- [30]
			"28574:28674:31069", -- [31]
			"28574:28674:30269", -- [32]
			"28574:31078:30314:33849", -- [33]
			"28037:31078", -- [34]
			"28037:31078:30314:29950:29951", -- [35]
			"28037:31078:30314:29950", -- [36]
			"28037:31078:30314", -- [37]
			"28037:31078:30314:33849", -- [38]			
			["direct"] = "25288:26847:24795:28574:28037",
			["f"] = 0,
			["m"] = 114,
			["coord"] = 2129861678,
		},
		[30314] = {
			"30870:26566:26845:24155", -- [1]
			"30433:28674:27344", -- [2]
			"30433:28674:28615:28618:26853:24032", -- [3]
			"30870:26847:24795:27046", -- [4]
			"30870:26566:26845:26844", -- [5]
			"30433:28674:28615:28618:26853", -- [6]
			"30433:28674:28615:28618:26852", -- [7]
			"30433:28674:26851", -- [8]
			"30870:26566:26845", -- [9]
			"30870:26566", -- [10]
			"30870:26847:25288", -- [11]
			"30870:26847", -- [12]
			"31078:28574:26848", -- [13]
			"30433:28674:26850", -- [14]
			"30870:26847:24795", -- [15]
			"30870:26566:28196", -- [16]
			"30870:26566:26845:26844:28197", -- [17]
			"30870:26847:28195", -- [18]
			"30433:28674:28615:28623", -- [19]
			"30433:28674:28615", -- [20]
			"30433:28674:28615:28618", -- [21]
			"29950:29951:28624", -- [22]
			"31078:28574", -- [23]
			"30433:28674", -- [24]
			"30433:28674:29721", -- [25]
			"29950:29951:32571", -- [26]
			"29950:29757", -- [27]
			"29950:29951:29762", -- [28]
			"29950:29951", -- [29]
			"29950:29951:28624:30569", -- [30]
			"30433:28674:30269", -- [31]
			"31078:28037:26848", -- [32]
			"31078:28037", -- [33]			
			["m"] = 118,
			["coord"] = 1878408808,
			["direct"] = "31078:29950:30870:30433:31069:33849",
			["f"] = 0,
		},
		[26850] = {
			"26845:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"26566:26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"26566:26847:25288", -- [8]
			"26566:26847", -- [9]
			"26566:26847:26848", -- [10]
			"26566:26847:24795", -- [11]
			"26566:28196", -- [12]
			"26845:26844:28197", -- [13]
			"26566:26847:28195", -- [14]
			"28615:28623", -- [15]
			"28615:28618", -- [16]
			"28615:28623:28624", -- [17]
			"26566:30870:28574", -- [18]
			"28674:29721", -- [19]
			"28674:29721:32571", -- [20]
			"28674:29721:29757", -- [21]
			"28674:29721:29762", -- [22]
			"28674:31069:31078", -- [23]
			"28674:29721:29757:29951", -- [24]
			"28674:29721:29757:29950", -- [25]
			"28615:28623:28624:30569", -- [26]
			"26566:30870", -- [27]
			"28674:31069:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"28674:30269", -- [31]
			"28674:33849", -- [32]
			"26566:26847:26848:28037", -- [33]
			["m"] = 115,
			["coord"] = 1884760835,
			["direct"] = "26851:26845:26566:28615:28674",
			["f"] = 0,
		},
		[26851] = {
			"26845:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"26566:26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"26566:26847:25288", -- [8]
			"26566:26847", -- [9]
			"26566:26847:26848", -- [10]
			"26566:26847:24795", -- [11]
			"26845:26844:28197", -- [12]
			"28196:28195", -- [13]
			"28615:28623", -- [14]
			"28615:28618", -- [15]
			"28615:28623:28624", -- [16]
			"26566:30870:28574", -- [17]
			"28615:29721", -- [18]
			"28615:29721:32571", -- [19]
			"28615:29721:29757", -- [20]
			"28615:29721:29762", -- [21]
			"26566:30870:31078", -- [22]
			"28615:29721:29757:29951", -- [23]
			"28615:29721:29757:29950", -- [24]
			"28615:28623:28624:30569", -- [25]
			"26566:30870", -- [26]
			"28674:31069:30314", -- [27]
			"28674:30433", -- [28]
			"28674:31069", -- [29]
			"28615:30269", -- [30]
			"28674:33849", -- [31]
			"26566:26847:26848:28037", -- [32]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "26845:26566:26850:28196:28615:28674",
			["coord"] = 2588115855,
		},
		[28615] = {
			"28618:26852:26844:24155", -- [1]
			"28618:26853:27344", -- [2]
			"28618:26853:24032", -- [3]
			"26850:26566:26847:24795:27046", -- [4]
			"28618:26852:26844", -- [5]
			"28618:26853", -- [6]
			"28618:26852", -- [7]
			"26850:26566", -- [8]
			"28674:25288", -- [9]
			"26850:26566:26847", -- [10]
			"28674:28574:26848", -- [11]
			"26850:26566:26847:24795", -- [12]
			"26851:28196", -- [13]
			"28618:26852:26844:28197", -- [14]
			"26851:28196:28195", -- [15]
			"28623:28624", -- [16]
			"28674:28574", -- [17]
			"29721:32571", -- [18]
			"29721:29757", -- [19]
			"29721:29762", -- [20]
			"28674:31069:31078", -- [21]
			"29721:29757:29951", -- [22]
			"29721:29757:29950", -- [23]
			"28623:28624:30569", -- [24]
			"28674:30870", -- [25]
			"28674:31069:30314", -- [26]
			"28674:30433", -- [27]
			"28674:31069", -- [28]
			"28674:33849", -- [29]
			"28674:28574:28037", -- [30]
			["m"] = 121,
			["f"] = 0,
			["direct"] = "26851:26845:26850:28623:28618:28674:29721:30269",
			["coord"] = 603962466,
		},
	}, -- [4]
	[6] = {
		[65863] = {
			"61122:60230:60952", -- [1]
			"61122:60230:59186", -- [2]
			"61122:60230:59186:59732", -- [3]
			"62901:61473:61745:61474:66227:59736:59735:59733", -- [4]
			"62901:61473:61745:61474:66227:59736:59735", -- [5]
			"62901:61473:61745:61474:66227:59736", -- [6]
			"62901:61473:61745:61474:66227", -- [7]
			"61122:60230", -- [8]
			"61122:60231", -- [9]
			"61122:60231:60232", -- [10]
			"61122:60231:59046", -- [11]
			"62903:63500:63501:58843", -- [12]
			"62903:63500:63501:58843:59047", -- [13]
			"62903:63500:63501:58843:65189", -- [14]
			"62903:63500:63501:58843:59047:60441", -- [15]
			"62901:61473:61745:61474", -- [16]
			"62901:61512:60416:61504:61118", -- [17]
			"62901:61473:61745", -- [18]
			"62901:61512:60416:61504:61118:61511", -- [19]
			"62901:61512:60416:61504", -- [20]
			"62901:61512:60416", -- [21]
			"62901:61473", -- [22]
			"62901:61512", -- [23]
			"61122:62658:61759", -- [24]
			"61122:62658", -- [25]
			"62901:62898", -- [26]
			"62901:62898:62909", -- [27]
			"62903:63500:63501", -- [28]
			"62903:63500:63501:63498", -- [29]
			"62903:63500", -- [30]
			"62903:63500:63497", -- [31]
			"61122:60230:59186:64310", -- [32]
			"62903:63500:63501:65511", -- [33]
			"61122:60230:59186:71939", -- [34]
			--["name"] = "Serpent's Spine, Kun-Lai Summit",
			["m"] = 379,
			["direct"] = "62901:62903:61122",
			["coord"] = 1545786979,
			["f"] = 0,
		},
		[60441] = {
			"59046:60230:60952", -- [1]
			"59046:60230:59186", -- [2]
			"59046:60230:59186:59732", -- [3]
			"59046:60230:59186:59735:59733", -- [4]
			"59046:60230:59186:59735", -- [5]
			"59046:60230:60952:59736", -- [6]
			"59046:60230:60952:66227", -- [7]
			"59046:60230", -- [8]
			"59046:60231", -- [9]
			"59046:60232", -- [10]
			"65189:58843", -- [11]
			"59046:60231:62658:61759:61474", -- [12]
			"59046:60231:62658:61759:61474:61118", -- [13]
			"59046:60231:62658:61759:61474:61745", -- [14]
			"59046:60231:62658:61759:61474:61118:61511", -- [15]
			"59046:60231:62658:61759:61474:61504", -- [16]
			"59046:60231:62658:61759:61474:61745:60416", -- [17]
			"59046:60231:62658:61759:61474:61745:61473", -- [18]
			"59046:60231:62658:61759:61474:61745:60416:61512", -- [19]
			"59046:60231:62658:61759", -- [20]
			"59046:60231:62658", -- [21]
			"59046:60231:61122:65863:62901", -- [22]
			"65189:59047:63501:63500:62903", -- [23]
			"65189:59047:63501:63500:62903:62898", -- [24]
			"65189:59047:63501:63500:62903:62898:62909", -- [25]
			"59046:60231:61122", -- [26]
			"65189:59047:63501", -- [27]
			"65189:59047:63501:63498", -- [28]
			"65189:59047:63501:63500", -- [29]
			"65189:59047:63501:63497", -- [30]
			"59046:60230:59186:64310", -- [31]
			"65189:59047:63501:65511", -- [32]
			"59046:60231:61122:65863", -- [33]
			"59046:60230:59186:71939", -- [34]
			--["name"] = "Marista, Krasarang Wilds",
			["m"] = 418,
			["f"] = 0,
			["direct"] = "59046:59047:65189",
			["coord"] = 2250621975,
		},
		[62658] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"61759:61474:66227", -- [7]
			"60231:60232", -- [8]
			"60231:59046", -- [9]
			"60231:58843", -- [10]
			"60231:58843:59047", -- [11]
			"60231:65189", -- [12]
			"60231:59046:60441", -- [13]
			"61759:61474", -- [14]
			"61759:61474:61118", -- [15]
			"61759:61474:61745", -- [16]
			"61759:61474:61118:61511", -- [17]
			"61759:61474:61504", -- [18]
			"61759:61474:61745:60416", -- [19]
			"61759:61474:61745:61473", -- [20]
			"61759:61474:61745:60416:61512", -- [21]
			"61122:65863:62901", -- [22]
			"61759:61474:61745:61473:62903", -- [23]
			"61759:61474:61745:61473:62903:62898", -- [24]
			"61759:61474:61745:61473:62903:62898:62909", -- [25]
			"60231:58843:63501", -- [26]
			"60231:58843:63501:63498", -- [27]
			"61122:63500", -- [28]
			"61122:63497", -- [29]
			"60230:59186:64310", -- [30]
			"60231:58843:63501:65511", -- [31]
			"61122:65863", -- [32]
			"60230:59186:71939", -- [33]
			--["name"] = "Grassy Cline, Valley of the Four Winds",
			["m"] = 376,
			["f"] = 0,
			["direct"] = "60230:60231:61759:61122",
			["coord"] = 3041672744,
		},
		[61473] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:66227:59736:59735:59733", -- [4]
			"61745:61474:66227:59736:59735", -- [5]
			"61745:61474:66227:59736", -- [6]
			"61745:61474:66227", -- [7]
			"61745:61474:61759:60230", -- [8]
			"61745:61474:61759:62658:60231", -- [9]
			"61745:61474:60232", -- [10]
			"61745:61474:61759:62658:60231:59046", -- [11]
			"62903:63500:63501:58843", -- [12]
			"62903:63500:63501:58843:59047", -- [13]
			"62903:63500:63501:58843:65189", -- [14]
			"62903:63500:63501:58843:59047:60441", -- [15]
			"61745:61474", -- [16]
			"60416:61504:61118", -- [17]
			"60416:61504:61118:61511", -- [18]
			"60416:61504", -- [19]
			"60416:61512", -- [20]
			"61745:61474:61759", -- [21]
			"61745:61474:61759:62658", -- [22]
			"62903:62898", -- [23]
			"62903:62898:62909", -- [24]
			"61745:61122", -- [25]
			"62903:63500:63501", -- [26]
			"62903:63500:63501:63498", -- [27]
			"62903:63500", -- [28]
			"62903:63500:63497", -- [29]
			"61745:61474:61759:60230:59186:64310", -- [30]
			"62903:63500:63501:65511", -- [31]
			"62903:65863", -- [32]
			"61745:61474:61759:60230:59186:71939", -- [33]
			["direct"] = "61745:60416:62901:62903",
			["m"] = 379,
			["coord"] = 1887954259,
			["f"] = 0,
		},
		[64310] = {
			"59186:59732", -- [1]
			"59186:59735:59733", -- [2]
			"59186:59735", -- [3]
			"59186:59736", -- [4]
			"60952:66227", -- [5]
			"60952:60230", -- [6]
			"60952:60230:60231", -- [7]
			"60952:60230:60232", -- [8]
			"60952:60230:59046", -- [9]
			"60952:60230:60231:58843", -- [10]
			"60952:60230:59046:59047", -- [11]
			"60952:60230:60231:65189", -- [12]
			"60952:60230:59046:60441", -- [13]
			"60952:60230:61759:61474", -- [14]
			"60952:60230:61759:61474:61118", -- [15]
			"60952:60230:61759:61474:61745", -- [16]
			"60952:60230:61759:61474:61118:61511", -- [17]
			"60952:60230:61759:61474:61504", -- [18]
			"60952:60230:61759:61474:61745:60416", -- [19]
			"60952:60230:61759:61474:61745:61473", -- [20]
			"60952:60230:61759:61474:61745:60416:61512", -- [21]
			"60952:60230:61759", -- [22]
			"60952:60230:62658", -- [23]
			"60952:60230:62658:61122:65863:62901", -- [24]
			"60952:60230:61759:61474:61745:61473:62903", -- [25]
			"60952:60230:61759:61474:61745:61473:62903:62898", -- [26]
			"60952:60230:61759:61474:61745:61473:62903:62898:62909", -- [27]
			"60952:60230:62658:61122", -- [28]
			"60952:60230:60231:58843:63501", -- [29]
			"60952:60230:60231:58843:63501:63498", -- [30]
			"60952:60230:62658:61122:63500", -- [31]
			"60952:60230:62658:61122:63497", -- [32]
			"60952:60230:60231:58843:63501:65511", -- [33]
			"60952:60230:62658:61122:65863", -- [34]
			"59186:71939", -- [35]
			--["name"] = "Serpent's Overlook, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "60952:59186",
			["coord"] = 1851699009,
		},
		[65511] = {
			"63501:58843:60231:60230:60952", -- [1]
			"63501:58843:60231:60230:59186", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60230:59186:59735:59733", -- [4]
			"63501:58843:60231:60230:59186:59735", -- [5]
			"63501:58843:60231:60230:60952:59736", -- [6]
			"63501:61122:66227", -- [7]
			"63501:58843:60231:60230", -- [8]
			"63501:58843:60231", -- [9]
			"63501:58843:60231:60232", -- [10]
			"63501:58843:60231:59046", -- [11]
			"63501:58843", -- [12]
			"63501:58843:59047", -- [13]
			"63501:58843:65189", -- [14]
			"63501:58843:59047:60441", -- [15]
			"63501:58843:60231:62658:61759:61474", -- [16]
			"63501:63500:62903:61473:60416:61504:61118", -- [17]
			"63501:63500:62903:61473:61745", -- [18]
			"63501:63500:62903:61473:60416:61504:61118:61511", -- [19]
			"63501:63500:62903:61473:60416:61504", -- [20]
			"63501:63500:62903:61473:60416", -- [21]
			"63501:63500:62903:61473", -- [22]
			"63501:63497:61512", -- [23]
			"63501:58843:60231:62658:61759", -- [24]
			"63501:58843:60231:62658", -- [25]
			"63501:63500:62903:62901", -- [26]
			"63501:63500:62903", -- [27]
			"63501:63500:62903:62898", -- [28]
			"63501:63500:62903:62898:62909", -- [29]
			"63501:61122", -- [30]
			"63501:63500", -- [31]
			"63501:63497", -- [32]
			"63501:58843:60231:60230:59186:64310", -- [33]
			"63501:63500:62903:65863", -- [34]
			"63501:58843:60231:60230:59186:71939", -- [35]
			--["name"] = "The Briny Muck, Dread Wastes",
			["m"] = 422,
			["f"] = 0,
			["direct"] = "63501:63498",
			["coord"] = 1829473930,
		},
		[63497] = {
			"61122:60230:60952", -- [1]
			"61122:60230:59186", -- [2]
			"61122:60230:59186:59732", -- [3]
			"61122:66227:59736:59735:59733", -- [4]
			"61122:66227:59736:59735", -- [5]
			"61122:66227:59736", -- [6]
			"61122:66227", -- [7]
			"61122:60230", -- [8]
			"63501:58843:60231", -- [9]
			"63501:58843:60231:60232", -- [10]
			"63501:58843:60231:59046", -- [11]
			"63501:58843", -- [12]
			"63501:58843:59047", -- [13]
			"63501:58843:65189", -- [14]
			"63501:58843:59047:60441", -- [15]
			"61122:61474", -- [16]
			"61122:61745:61118", -- [17]
			"61122:61745", -- [18]
			"61122:61745:61511", -- [19]
			"61122:61745:61504", -- [20]
			"61512:60416", -- [21]
			"63500:62903:61473", -- [22]
			"61122:62658:61759", -- [23]
			"61122:62658", -- [24]
			"63500:62903:62901", -- [25]
			"63500:62903", -- [26]
			"63500:62903:62898", -- [27]
			"63500:62903:62898:62909", -- [28]
			"61122:60230:59186:64310", -- [29]
			"63501:65511", -- [30]
			"63500:62903:65863", -- [31]
			"61122:60230:59186:71939", -- [32]
			--["name"] = "Serpent's Spine, Vale of Eternal Blossoms",
			["direct"] = "61512:61122:63501:63498:63500",
			["f"] = 0,
			["m"] = 390,
			["coord"] = 603966145,
		},
		[63501] = {
			"58843:60231:60230:60952", -- [1]
			"58843:60231:60230:59186", -- [2]
			"58843:60231:60230:59186:59732", -- [3]
			"58843:60231:60230:59186:59735:59733", -- [4]
			"58843:60231:60230:59186:59735", -- [5]
			"58843:60231:60230:60952:59736", -- [6]
			"61122:66227", -- [7]
			"58843:60231:60230", -- [8]
			"58843:60231", -- [9]
			"58843:60231:60232", -- [10]
			"58843:60231:59046", -- [11]
			"58843:65189", -- [12]
			"58843:59047:60441", -- [13]
			"58843:60231:62658:61759:61474", -- [14]
			"63500:62903:61473:60416:61504:61118", -- [15]
			"63500:62903:61473:61745", -- [16]
			"63500:62903:61473:60416:61504:61118:61511", -- [17]
			"63500:62903:61473:60416:61504", -- [18]
			"63500:62903:61473:60416", -- [19]
			"63500:62903:61473", -- [20]
			"63497:61512", -- [21]
			"58843:60231:62658:61759", -- [22]
			"58843:60231:62658", -- [23]
			"63500:62903:62901", -- [24]
			"63500:62903", -- [25]
			"63500:62903:62898", -- [26]
			"63500:62903:62898:62909", -- [27]
			"58843:60231:60230:59186:64310", -- [28]
			"63500:62903:65863", -- [29]
			"58843:60231:60230:59186:71939", -- [30]
			--["name"] = "Klaxxi'vess, Dread Wastes",
			["direct"] = "58843:59047:61122:63498:63500:63497:65511",
			["f"] = 0,
			["m"] = 422,
			["coord"] = 2397264188,
		},
		[60416] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:66227:59736:59735:59733", -- [4]
			"61745:61474:66227:59736:59735", -- [5]
			"61745:61474:66227:59736", -- [6]
			"61745:61474:66227", -- [7]
			"61745:61474:61759:60230", -- [8]
			"61745:61474:61759:62658:60231", -- [9]
			"61745:61474:60232", -- [10]
			"61745:61474:61759:62658:60231:59046", -- [11]
			"61473:62903:63500:63501:58843", -- [12]
			"61473:62903:63500:63501:58843:59047", -- [13]
			"61473:62903:63500:63501:58843:65189", -- [14]
			"61473:62903:63500:63501:58843:59047:60441", -- [15]
			"61745:61474", -- [16]
			"61504:61118", -- [17]
			"61504:61118:61511", -- [18]
			"61745:61474:61759", -- [19]
			"61745:61474:61759:62658", -- [20]
			"61512:62901", -- [21]
			"61473:62903", -- [22]
			"61512:62901:62898", -- [23]
			"61512:62901:62898:62909", -- [24]
			"61745:61122", -- [25]
			"61473:62903:63500:63501", -- [26]
			"61473:62903:63500:63501:63498", -- [27]
			"61473:62903:63500", -- [28]
			"61512:63497", -- [29]
			"61745:61474:61759:60230:59186:64310", -- [30]
			"61473:62903:63500:63501:65511", -- [31]
			"61512:62901:65863", -- [32]
			"61745:61474:61759:60230:59186:71939", -- [33]
			--["name"] = "Kota Basecamp, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "61745:61504:61473:61512",
			["coord"] = 1836691981,
		},
		[58843] = {
			"60231:60230:60952", -- [1]
			"60231:60230:59186", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60230:59186:59735:59733", -- [4]
			"60231:60230:59186:59735", -- [5]
			"60231:60230:60952:59736", -- [6]
			"60231:62658:61759:61474:66227", -- [7]
			"60231:60230", -- [8]
			"60231:60232", -- [9]
			"60231:59046", -- [10]
			"59047:60441", -- [11]
			"60231:62658:61759:61474", -- [12]
			"60231:62658:61759:61474:61118", -- [13]
			"60231:62658:61759:61474:61745", -- [14]
			"60231:62658:61759:61474:61118:61511", -- [15]
			"60231:62658:61759:61474:61504", -- [16]
			"63501:63500:62903:61473:60416", -- [17]
			"63501:63500:62903:61473", -- [18]
			"63501:63497:61512", -- [19]
			"60231:62658:61759", -- [20]
			"60231:62658", -- [21]
			"63501:63500:62903:62901", -- [22]
			"63501:63500:62903", -- [23]
			"63501:63500:62903:62898", -- [24]
			"63501:63500:62903:62898:62909", -- [25]
			"60231:61122", -- [26]
			"63501:63498", -- [27]
			"63501:63500", -- [28]
			"63501:63497", -- [29]
			"60231:60230:59186:64310", -- [30]
			"63501:65511", -- [31]
			"63501:63500:62903:65863", -- [32]
			"60231:60230:59186:71939", -- [33]
			--["name"] = "Stoneplow, Valley of the Four Winds",
			["m"] = 376,
			["f"] = 0,
			["direct"] = "60231:59047:65189:63501",
			["coord"] = 867145194,
		},
		[60231] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"62658:61759:61474:66227", -- [7]
			"58843:59047", -- [8]
			"59046:60441", -- [9]
			"62658:61759:61474", -- [10]
			"62658:61759:61474:61118", -- [11]
			"62658:61759:61474:61745", -- [12]
			"62658:61759:61474:61118:61511", -- [13]
			"62658:61759:61474:61504", -- [14]
			"62658:61759:61474:61745:60416", -- [15]
			"62658:61759:61474:61745:61473", -- [16]
			"62658:61759:61474:61745:60416:61512", -- [17]
			"62658:61759", -- [18]
			"61122:65863:62901", -- [19]
			"58843:63501:63500:62903", -- [20]
			"58843:63501:63500:62903:62898", -- [21]
			"58843:63501:63500:62903:62898:62909", -- [22]
			"58843:63501", -- [23]
			"58843:63501:63498", -- [24]
			"58843:63501:63500", -- [25]
			"58843:63501:63497", -- [26]
			"60230:59186:64310", -- [27]
			"58843:63501:65511", -- [28]
			"61122:65863", -- [29]
			"60230:59186:71939", -- [30]
			--["name"] = "Halfhill, Valley of the Four Winds",
			["direct"] = "60230:60232:59046:58843:65189:62658:61122",
			["f"] = 0,
			["m"] = 376,
			["coord"] = 2423292124,
		},
		[61745] = {
			"61474:61759:60230:60952", -- [1]
			"61474:61759:60230:59186", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:66227:59736:59735:59733", -- [4]
			"61474:66227:59736:59735", -- [5]
			"61474:66227:59736", -- [6]
			"61474:66227", -- [7]
			"61474:61759:60230", -- [8]
			"61474:61759:62658:60231", -- [9]
			"61474:60232", -- [10]
			"61474:61759:62658:60231:59046", -- [11]
			"61474:61759:62658:60231:58843", -- [12]
			"61474:61759:62658:60231:58843:59047", -- [13]
			"61474:61759:62658:60231:65189", -- [14]
			"61474:61759:62658:60231:59046:60441", -- [15]
			"60416:61512", -- [16]
			"61474:61759", -- [17]
			"61474:61759:62658", -- [18]
			"61473:62901", -- [19]
			"61473:62903", -- [20]
			"61473:62903:62898", -- [21]
			"61473:62903:62898:62909", -- [22]
			"61473:62903:63500:63501", -- [23]
			"61473:62903:63500:63501:63498", -- [24]
			"61473:62903:63500", -- [25]
			"61122:63497", -- [26]
			"61474:61759:60230:59186:64310", -- [27]
			"61473:62903:63500:63501:65511", -- [28]
			"61473:62903:65863", -- [29]
			"61474:61759:60230:59186:71939", -- [30]
			--["name"] = "Eastwind Rest, Kun-Lai Summit",
			["direct"] = "61474:61118:61511:61504:60416:61473:61122",
			["f"] = 0,
			["m"] = 379,
			["coord"] = 2682375861,
		},
		[59733] = {
			"59735:59736:60952", -- [1]
			"59735:59186", -- [2]
			"59735:59736", -- [3]
			"59735:59736:66227", -- [4]
			"59735:59186:60230", -- [5]
			"59735:59186:60230:60231", -- [6]
			"59735:59186:60230:60232", -- [7]
			"59735:59186:60230:59046", -- [8]
			"59735:59186:60230:60231:58843", -- [9]
			"59735:59186:60230:59046:59047", -- [10]
			"59735:59186:60230:60231:65189", -- [11]
			"59735:59186:60230:59046:60441", -- [12]
			"59735:59736:66227:61474", -- [13]
			"59735:59736:66227:61474:61118", -- [14]
			"59735:59736:66227:61474:61745", -- [15]
			"59735:59736:66227:61474:61118:61511", -- [16]
			"59735:59736:66227:61474:61504", -- [17]
			"59735:59736:66227:61474:61745:60416", -- [18]
			"59735:59736:66227:61474:61745:61473", -- [19]
			"59735:59736:66227:61474:61745:60416:61512", -- [20]
			"59735:59186:60230:61759", -- [21]
			"59735:59186:60230:62658", -- [22]
			"59735:59736:66227:61474:61745:61473:62901", -- [23]
			"59735:59736:66227:61474:61745:61473:62903", -- [24]
			"59735:59736:66227:61474:61745:61473:62903:62898", -- [25]
			"59735:59736:66227:61474:61745:61473:62903:62898:62909", -- [26]
			"59735:59736:66227:61122", -- [27]
			"59735:59186:60230:60231:58843:63501", -- [28]
			"59735:59186:60230:60231:58843:63501:63498", -- [29]
			"59735:59736:66227:61474:61745:61473:62903:63500", -- [30]
			"59735:59736:66227:61122:63497", -- [31]
			"59735:59186:64310", -- [32]
			"59735:59186:60230:60231:58843:63501:65511", -- [33]
			"59735:59736:66227:61474:61745:61473:62903:65863", -- [34]
			"59735:59186:71939", -- [35]
			--["name"] = "Sri-La Village, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59732:59735",
			["coord"] = 2380414099,
		},
		[59735] = {
			"59736:60952", -- [1]
			"59186:59732", -- [2]
			"59736:66227", -- [3]
			"59186:60230", -- [4]
			"59186:60230:60231", -- [5]
			"59186:60230:60232", -- [6]
			"59186:60230:59046", -- [7]
			"59186:60230:60231:58843", -- [8]
			"59186:60230:59046:59047", -- [9]
			"59186:60230:60231:65189", -- [10]
			"59186:60230:59046:60441", -- [11]
			"59736:66227:61474", -- [12]
			"59736:66227:61474:61118", -- [13]
			"59736:66227:61474:61745", -- [14]
			"59736:66227:61474:61118:61511", -- [15]
			"59736:66227:61474:61504", -- [16]
			"59736:66227:61474:61745:60416", -- [17]
			"59736:66227:61474:61745:61473", -- [18]
			"59736:66227:61474:61745:60416:61512", -- [19]
			"59186:60230:61759", -- [20]
			"59186:60230:62658", -- [21]
			"59736:66227:61474:61745:61473:62901", -- [22]
			"59736:66227:61474:61745:61473:62903", -- [23]
			"59736:66227:61474:61745:61473:62903:62898", -- [24]
			"59736:66227:61474:61745:61473:62903:62898:62909", -- [25]
			"59736:66227:61122", -- [26]
			"59186:60230:60231:58843:63501", -- [27]
			"59186:60230:60231:58843:63501:63498", -- [28]
			"59736:66227:61474:61745:61473:62903:63500", -- [29]
			"59736:66227:61122:63497", -- [30]
			"59186:64310", -- [31]
			"59186:60230:60231:58843:63501:65511", -- [32]
			"59736:66227:61474:61745:61473:62903:65863", -- [33]
			"59186:71939", -- [34]
			--["name"] = "Emperor's Omen, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59186:59733:59736",
			["coord"] = 2184266963,
		},
		[59046] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"60230:60952:66227", -- [7]
			"60231:58843", -- [8]
			"59047:65189", -- [9]
			"60231:62658:61759:61474", -- [10]
			"60231:62658:61759:61474:61118", -- [11]
			"60231:62658:61759:61474:61745", -- [12]
			"60231:62658:61759:61474:61118:61511", -- [13]
			"60231:62658:61759:61474:61504", -- [14]
			"60231:62658:61759:61474:61745:60416", -- [15]
			"60231:62658:61759:61474:61745:61473", -- [16]
			"60231:62658:61759:61474:61745:60416:61512", -- [17]
			"60231:62658:61759", -- [18]
			"60231:62658", -- [19]
			"60231:61122:65863:62901", -- [20]
			"60231:58843:63501:63500:62903", -- [21]
			"60231:58843:63501:63500:62903:62898", -- [22]
			"60231:58843:63501:63500:62903:62898:62909", -- [23]
			"60231:61122", -- [24]
			"60231:58843:63501", -- [25]
			"60231:58843:63501:63498", -- [26]
			"60231:58843:63501:63500", -- [27]
			"60231:58843:63501:63497", -- [28]
			"60230:59186:64310", -- [29]
			"60231:58843:63501:65511", -- [30]
			"60231:61122:65863", -- [31]
			"60230:59186:71939", -- [32]
			--["name"] = "Thunder Cleft, Krasarang Wilds",
			["direct"] = "60230:60231:60232:59047:60441",
			["f"] = 0,
			["m"] = 418,
			["coord"] = 2543992551,
		},
		[61759] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"61474:66227", -- [7]
			"62658:60231", -- [8]
			"60230:60232", -- [9]
			"62658:60231:59046", -- [10]
			"62658:60231:58843", -- [11]
			"62658:60231:58843:59047", -- [12]
			"62658:60231:65189", -- [13]
			"62658:60231:59046:60441", -- [14]
			"61474:61118", -- [15]
			"61474:61745", -- [16]
			"61474:61118:61511", -- [17]
			"61474:61504", -- [18]
			"61474:61745:60416", -- [19]
			"61474:61745:61473", -- [20]
			"61474:61745:60416:61512", -- [21]
			"61474:61745:61473:62901", -- [22]
			"61474:61745:61473:62903", -- [23]
			"61474:61745:61473:62903:62898", -- [24]
			"61474:61745:61473:62903:62898:62909", -- [25]
			"62658:61122", -- [26]
			"62658:60231:58843:63501", -- [27]
			"62658:60231:58843:63501:63498", -- [28]
			"62658:61122:63500", -- [29]
			"62658:61122:63497", -- [30]
			"60230:59186:64310", -- [31]
			"62658:60231:58843:63501:65511", -- [32]
			"62658:61122:65863", -- [33]
			"60230:59186:71939", -- [34]
			--["name"] = "Tavern in the Mists, The Veiled Stair",
			["m"] = 433,
			["f"] = 0,
			["direct"] = "60230:61474:62658",
			["coord"] = 2433204651,
		},
		[61511] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:66227:59736:59735:59733", -- [4]
			"61745:61474:66227:59736:59735", -- [5]
			"61745:61474:66227:59736", -- [6]
			"61745:61474:66227", -- [7]
			"61745:61474:61759:60230", -- [8]
			"61745:61474:61759:62658:60231", -- [9]
			"61745:61474:60232", -- [10]
			"61745:61474:61759:62658:60231:59046", -- [11]
			"61745:61474:61759:62658:60231:58843", -- [12]
			"61745:61474:61759:62658:60231:58843:59047", -- [13]
			"61745:61474:61759:62658:60231:65189", -- [14]
			"61745:61474:61759:62658:60231:59046:60441", -- [15]
			"61745:61474", -- [16]
			"61504:60416", -- [17]
			"61745:61473", -- [18]
			"61504:60416:61512", -- [19]
			"61745:61474:61759", -- [20]
			"61745:61474:61759:62658", -- [21]
			"61504:60416:61512:62901", -- [22]
			"61745:61473:62903", -- [23]
			"61504:60416:61512:62901:62898", -- [24]
			"61504:60416:61512:62901:62898:62909", -- [25]
			"61745:61122", -- [26]
			"61745:61473:62903:63500:63501", -- [27]
			"61745:61473:62903:63500:63501:63498", -- [28]
			"61745:61473:62903:63500", -- [29]
			"61745:61122:63497", -- [30]
			"61745:61474:61759:60230:59186:64310", -- [31]
			"61745:61473:62903:63500:63501:65511", -- [32]
			"61504:60416:61512:62901:65863", -- [33]
			"61745:61474:61759:60230:59186:71939", -- [34]
			--["name"] = "Zouchin Village, Kun-Lai Summit",
			["m"] = 379,
			["direct"] = "61118:61745:61504",
			["f"] = 0,
			["coord"] = 2681031944,
		},
		[62901] = {
			"61473:61745:61474:61759:60230:60952", -- [1]
			"61473:61745:61474:61759:60230:59186", -- [2]
			"61473:61745:61474:61759:60230:59186:59732", -- [3]
			"61473:61745:61474:66227:59736:59735:59733", -- [4]
			"61473:61745:61474:66227:59736:59735", -- [5]
			"61473:61745:61474:66227:59736", -- [6]
			"61473:61745:61474:66227", -- [7]
			"61473:61745:61474:61759:60230", -- [8]
			"65863:61122:60231", -- [9]
			"61473:61745:61474:60232", -- [10]
			"65863:61122:60231:59046", -- [11]
			"62903:63500:63501:58843", -- [12]
			"62903:63500:63501:58843:59047", -- [13]
			"62903:63500:63501:58843:65189", -- [14]
			"62903:63500:63501:58843:59047:60441", -- [15]
			"61473:61745:61474", -- [16]
			"61512:60416:61504:61118", -- [17]
			"61473:61745", -- [18]
			"61512:60416:61504:61118:61511", -- [19]
			"61512:60416:61504", -- [20]
			"61512:60416", -- [21]
			"61473:61745:61474:61759", -- [22]
			"61473:61745:61474:61759:62658", -- [23]
			"62898:62909", -- [24]
			"65863:61122", -- [25]
			"62903:63500:63501", -- [26]
			"62903:63500:63501:63498", -- [27]
			"62903:63500", -- [28]
			"62903:63500:63497", -- [29]
			"61473:61745:61474:61759:60230:59186:64310", -- [30]
			"62903:63500:63501:65511", -- [31]
			"61473:61745:61474:61759:60230:59186:71939", -- [32]
			--["name"] = "Longying Outpost, Townlong Steppes",
			["direct"] = "61473:61512:62903:62898:65863",
			["m"] = 388,
			["coord"] = 3054473921,
			["f"] = 0,
		},
		[59186] = {
			"59735:59733", -- [1]
			"60230:60231", -- [2]
			"60230:60232", -- [3]
			"60230:59046", -- [4]
			"60230:60231:58843", -- [5]
			"60230:59046:59047", -- [6]
			"60230:60231:65189", -- [7]
			"60230:59046:60441", -- [8]
			"60230:61759:61474", -- [9]
			"60230:61759:61474:61118", -- [10]
			"60230:61759:61474:61745", -- [11]
			"60230:61759:61474:61118:61511", -- [12]
			"60230:61759:61474:61504", -- [13]
			"60230:61759:61474:61745:60416", -- [14]
			"60230:61759:61474:61745:61473", -- [15]
			"60230:61759:61474:61745:60416:61512", -- [16]
			"60230:61759", -- [17]
			"60230:62658", -- [18]
			"61122:65863:62901", -- [19]
			"60230:61759:61474:61745:61473:62903", -- [20]
			"60230:61759:61474:61745:61473:62903:62898", -- [21]
			"60230:61759:61474:61745:61473:62903:62898:62909", -- [22]
			"60230:60231:58843:63501", -- [23]
			"60230:60231:58843:63501:63498", -- [24]
			"61122:63500", -- [25]
			"61122:63497", -- [26]
			"60230:60231:58843:63501:65511", -- [27]
			"61122:65863", -- [28]
			--["name"] = "Dawn's Blossom, Jade Forest",
			["direct"] = "60952:59732:59735:59736:66227:60230:61122:64310:71939",
			["m"] = 371,
			["coord"] = 2019849771,
			["f"] = 0,
		},
		[60952] = {
			"59186:59732", -- [1]
			"59736:59735:59733", -- [2]
			"59736:59735", -- [3]
			"60230:60231", -- [4]
			"60230:60232", -- [5]
			"60230:59046", -- [6]
			"60230:60231:58843", -- [7]
			"60230:59046:59047", -- [8]
			"60230:60231:65189", -- [9]
			"60230:59046:60441", -- [10]
			"60230:61759:61474", -- [11]
			"60230:61759:61474:61118", -- [12]
			"60230:61759:61474:61745", -- [13]
			"60230:61759:61474:61118:61511", -- [14]
			"60230:61759:61474:61504", -- [15]
			"60230:61759:61474:61745:60416", -- [16]
			"60230:61759:61474:61745:61473", -- [17]
			"60230:61759:61474:61745:60416:61512", -- [18]
			"60230:61759", -- [19]
			"60230:62658", -- [20]
			"60230:62658:61122:65863:62901", -- [21]
			"60230:61759:61474:61745:61473:62903", -- [22]
			"60230:61759:61474:61745:61473:62903:62898", -- [23]
			"60230:61759:61474:61745:61473:62903:62898:62909", -- [24]
			"60230:62658:61122", -- [25]
			"60230:60231:58843:63501", -- [26]
			"60230:60231:58843:63501:63498", -- [27]
			"60230:62658:61122:63500", -- [28]
			"60230:62658:61122:63497", -- [29]
			"60230:60231:58843:63501:65511", -- [30]
			"60230:62658:61122:65863", -- [31]
			"59186:71939", -- [32]
			--["name"] = "Grookin Hill, Jade Forest",
			["direct"] = "59186:59736:66227:60230:64310",
			["f"] = 0,
			["m"] = 371,
			["coord"] = 1193048794,
		},
		[62909] = {
			"62898:62903:61473:61745:61474:61759:60230:60952", -- [1]
			"62898:62903:61473:61745:61474:61759:60230:59186", -- [2]
			"62898:62903:61473:61745:61474:61759:60230:59186:59732", -- [3]
			"62898:62903:61473:61745:61474:66227:59736:59735:59733", -- [4]
			"62898:62903:61473:61745:61474:66227:59736:59735", -- [5]
			"62898:62903:61473:61745:61474:66227:59736", -- [6]
			"62898:62903:61473:61745:61474:66227", -- [7]
			"62898:62903:61473:61745:61474:61759:60230", -- [8]
			"62898:62903:63500:63501:58843:60231", -- [9]
			"62898:62903:63500:63501:58843:60231:60232", -- [10]
			"62898:62903:63500:63501:58843:60231:59046", -- [11]
			"62898:62903:63500:63501:58843", -- [12]
			"62898:62903:63500:63501:58843:59047", -- [13]
			"62898:62903:63500:63501:58843:65189", -- [14]
			"62898:62903:63500:63501:58843:59047:60441", -- [15]
			"62898:62903:61473:61745:61474", -- [16]
			"62898:62901:61512:60416:61504:61118", -- [17]
			"62898:62903:61473:61745", -- [18]
			"62898:62901:61512:60416:61504:61118:61511", -- [19]
			"62898:62901:61512:60416:61504", -- [20]
			"62898:62901:61512:60416", -- [21]
			"62898:62903:61473", -- [22]
			"62898:62901:61512", -- [23]
			"62898:62903:61473:61745:61474:61759", -- [24]
			"62898:62903:61473:61745:61474:61759:62658", -- [25]
			"62898:62901", -- [26]
			"62898:62903", -- [27]
			"62898:62903:65863:61122", -- [28]
			"62898:62903:63500:63501", -- [29]
			"62898:62903:63500:63501:63498", -- [30]
			"62898:62903:63500", -- [31]
			"62898:62903:63500:63497", -- [32]
			"62898:62903:61473:61745:61474:61759:60230:59186:64310", -- [33]
			"62898:62903:63500:63501:65511", -- [34]
			"62898:62903:65863", -- [35]
			"62898:62903:61473:61745:61474:61759:60230:59186:71939", -- [36]
			--["name"] = "Shado-Pan Garrison, Townlong Steppes",
			["m"] = 388,
			["f"] = 0,
			["direct"] = "62898",
			["coord"] = 2149824560,
		},
		[65189] = {
			"60231:60230:60952", -- [1]
			"60231:60230:59186", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60230:59186:59735:59733", -- [4]
			"60231:60230:59186:59735", -- [5]
			"60231:60230:60952:59736", -- [6]
			"60231:62658:61759:61474:66227", -- [7]
			"60231:60230", -- [8]
			"59047:59046:60232", -- [9]
			"59047:59046", -- [10]
			"60231:62658:61759:61474", -- [11]
			"60231:62658:61759:61474:61118", -- [12]
			"60231:62658:61759:61474:61745", -- [13]
			"60231:62658:61759:61474:61118:61511", -- [14]
			"60231:62658:61759:61474:61504", -- [15]
			"59047:63501:63500:62903:61473:60416", -- [16]
			"59047:63501:63500:62903:61473", -- [17]
			"59047:63501:63497:61512", -- [18]
			"60231:62658:61759", -- [19]
			"60231:62658", -- [20]
			"59047:63501:63500:62903:62901", -- [21]
			"59047:63501:63500:62903", -- [22]
			"59047:63501:63500:62903:62898", -- [23]
			"59047:63501:63500:62903:62898:62909", -- [24]
			"60231:61122", -- [25]
			"59047:63501", -- [26]
			"59047:63501:63498", -- [27]
			"59047:63501:63500", -- [28]
			"59047:63501:63497", -- [29]
			"60231:60230:59186:64310", -- [30]
			"59047:63501:65511", -- [31]
			"59047:63501:63500:62903:65863", -- [32]
			"60231:60230:59186:71939", -- [33]
			--["name"] = "Cradle of Chi-Ji, Krasarang Wilds",
			["m"] = 418,
			["f"] = 0,
			["direct"] = "60231:58843:59047:60441",
			["coord"] = 1341694345,
		},
		[61474] = {
			"61759:60230:60952", -- [1]
			"61759:60230:59186", -- [2]
			"61759:60230:59186:59732", -- [3]
			"66227:59736:59735:59733", -- [4]
			"66227:59736:59735", -- [5]
			"66227:59736", -- [6]
			"61759:60230", -- [7]
			"61759:62658:60231", -- [8]
			"61759:62658:60231:59046", -- [9]
			"61759:62658:60231:58843", -- [10]
			"61759:62658:60231:58843:59047", -- [11]
			"61759:62658:60231:65189", -- [12]
			"61759:62658:60231:59046:60441", -- [13]
			"61118:61511", -- [14]
			"61745:60416", -- [15]
			"61745:61473", -- [16]
			"61745:60416:61512", -- [17]
			"61759:62658", -- [18]
			"61745:61473:62901", -- [19]
			"61745:61473:62903", -- [20]
			"61745:61473:62903:62898", -- [21]
			"61745:61473:62903:62898:62909", -- [22]
			"61745:61473:62903:63500:63501", -- [23]
			"61122:63497:63498", -- [24]
			"61745:61473:62903:63500", -- [25]
			"61122:63497", -- [26]
			"61759:60230:59186:64310", -- [27]
			"61745:61473:62903:63500:63501:65511", -- [28]
			"61745:61473:62903:65863", -- [29]
			"61759:60230:59186:71939", -- [30]
			--["name"] = "Binan Village, Kun-Lai Summit",
			["direct"] = "66227:60232:61118:61745:61504:61759:61122",
			["f"] = 0,
			["m"] = 379,
			["coord"] = 3113808134,
		},
		[61512] = {
			"60416:61745:61474:61759:60230:60952", -- [1]
			"60416:61745:61474:61759:60230:59186", -- [2]
			"60416:61745:61474:61759:60230:59186:59732", -- [3]
			"60416:61745:61474:66227:59736:59735:59733", -- [4]
			"60416:61745:61474:66227:59736:59735", -- [5]
			"60416:61745:61474:66227:59736", -- [6]
			"60416:61745:61474:66227", -- [7]
			"60416:61745:61474:61759:60230", -- [8]
			"60416:61745:61474:61759:62658:60231", -- [9]
			"60416:61745:61474:60232", -- [10]
			"60416:61745:61474:61759:62658:60231:59046", -- [11]
			"62901:62903:63500:63501:58843", -- [12]
			"62901:62903:63500:63501:58843:59047", -- [13]
			"62901:62903:63500:63501:58843:65189", -- [14]
			"62901:62903:63500:63501:58843:59047:60441", -- [15]
			"60416:61745:61474", -- [16]
			"60416:61504:61118", -- [17]
			"60416:61745", -- [18]
			"60416:61504:61118:61511", -- [19]
			"60416:61504", -- [20]
			"60416:61473", -- [21]
			"60416:61745:61474:61759", -- [22]
			"60416:61745:61474:61759:62658", -- [23]
			"62901:62903", -- [24]
			"62901:62898", -- [25]
			"62901:62898:62909", -- [26]
			"62901:65863:61122", -- [27]
			"62901:62903:63500:63501", -- [28]
			"63497:63498", -- [29]
			"62901:62903:63500", -- [30]
			"60416:61745:61474:61759:60230:59186:64310", -- [31]
			"62901:62903:63500:63501:65511", -- [32]
			"62901:65863", -- [33]
			"60416:61745:61474:61759:60230:59186:71939", -- [34]
			--["name"] = "Winter's Blossom, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "60416:62901:63497",
			["coord"] = 1483577174,
		},
		[63498] = {
			"63501:58843:60231:60230:60952", -- [1]
			"63501:58843:60231:60230:59186", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60230:59186:59735:59733", -- [4]
			"63501:58843:60231:60230:59186:59735", -- [5]
			"63501:58843:60231:60230:60952:59736", -- [6]
			"63497:61122:66227", -- [7]
			"63501:58843:60231:60230", -- [8]
			"63501:58843:60231", -- [9]
			"63501:58843:60231:60232", -- [10]
			"63501:58843:60231:59046", -- [11]
			"63501:58843", -- [12]
			"63501:58843:59047", -- [13]
			"63501:58843:65189", -- [14]
			"63501:58843:59047:60441", -- [15]
			"63497:61122:61474", -- [16]
			"63501:63500:62903:61473:60416:61504:61118", -- [17]
			"63501:63500:62903:61473:61745", -- [18]
			"63501:63500:62903:61473:60416:61504:61118:61511", -- [19]
			"63501:63500:62903:61473:60416:61504", -- [20]
			"63501:63500:62903:61473:60416", -- [21]
			"63501:63500:62903:61473", -- [22]
			"63497:61512", -- [23]
			"63501:58843:60231:62658:61759", -- [24]
			"63501:58843:60231:62658", -- [25]
			"63501:63500:62903:62901", -- [26]
			"63501:63500:62903", -- [27]
			"63501:63500:62903:62898", -- [28]
			"63501:63500:62903:62898:62909", -- [29]
			"63497:61122", -- [30]
			"63501:63500", -- [31]
			"63501:58843:60231:60230:59186:64310", -- [32]
			"63501:63500:62903:65863", -- [33]
			"63501:58843:60231:60230:59186:71939", -- [34]
			--["name"] = "Soggy's Gamble, Dread Wastes",
			["m"] = 422,
			["f"] = 0,
			["direct"] = "63501:63497:65511",
			["coord"] = 2410197898,
		},
		[63500] = {
			"63501:58843:60231:60230:60952", -- [1]
			"63501:58843:60231:60230:59186", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"62903:61473:61745:61474:66227:59736:59735:59733", -- [4]
			"62903:61473:61745:61474:66227:59736:59735", -- [5]
			"62903:61473:61745:61474:66227:59736", -- [6]
			"62903:61473:61745:61474:66227", -- [7]
			"63501:58843:60231:60230", -- [8]
			"63501:58843:60231", -- [9]
			"63501:58843:60231:60232", -- [10]
			"63501:58843:60231:59046", -- [11]
			"63501:58843", -- [12]
			"63501:58843:59047", -- [13]
			"63501:58843:65189", -- [14]
			"63501:58843:59047:60441", -- [15]
			"62903:61473:61745:61474", -- [16]
			"62903:61473:60416:61504:61118", -- [17]
			"62903:61473:61745", -- [18]
			"62903:61473:60416:61504:61118:61511", -- [19]
			"62903:61473:60416:61504", -- [20]
			"62903:61473:60416", -- [21]
			"62903:61473", -- [22]
			"62903:62901:61512", -- [23]
			"63501:58843:60231:62658:61759", -- [24]
			"63501:58843:60231:62658", -- [25]
			"62903:62901", -- [26]
			"62903:62898", -- [27]
			"62903:62898:62909", -- [28]
			"63501:63498", -- [29]
			"63501:58843:60231:60230:59186:64310", -- [30]
			"63501:65511", -- [31]
			"62903:65863", -- [32]
			"63501:58843:60231:60230:59186:71939", -- [33]
			--["name"] = "The Sunset Brewgarden, Dread Wastes",
			["m"] = 422,
			["f"] = 0,
			["direct"] = "62903:61122:63501:63497",
			["coord"] = 2156797729,
		},
		[62898] = {
			"62903:61473:61745:61474:61759:60230:60952", -- [1]
			"62903:61473:61745:61474:61759:60230:59186", -- [2]
			"62903:61473:61745:61474:61759:60230:59186:59732", -- [3]
			"62903:61473:61745:61474:66227:59736:59735:59733", -- [4]
			"62903:61473:61745:61474:66227:59736:59735", -- [5]
			"62903:61473:61745:61474:66227:59736", -- [6]
			"62903:61473:61745:61474:66227", -- [7]
			"62903:61473:61745:61474:61759:60230", -- [8]
			"62903:63500:63501:58843:60231", -- [9]
			"62903:63500:63501:58843:60231:60232", -- [10]
			"62903:63500:63501:58843:60231:59046", -- [11]
			"62903:63500:63501:58843", -- [12]
			"62903:63500:63501:58843:59047", -- [13]
			"62903:63500:63501:58843:65189", -- [14]
			"62903:63500:63501:58843:59047:60441", -- [15]
			"62903:61473:61745:61474", -- [16]
			"62901:61512:60416:61504:61118", -- [17]
			"62903:61473:61745", -- [18]
			"62901:61512:60416:61504:61118:61511", -- [19]
			"62901:61512:60416:61504", -- [20]
			"62901:61512:60416", -- [21]
			"62903:61473", -- [22]
			"62901:61512", -- [23]
			"62903:61473:61745:61474:61759", -- [24]
			"62903:61473:61745:61474:61759:62658", -- [25]
			"62903:65863:61122", -- [26]
			"62903:63500:63501", -- [27]
			"62903:63500:63501:63498", -- [28]
			"62903:63500", -- [29]
			"62903:63500:63497", -- [30]
			"62903:61473:61745:61474:61759:60230:59186:64310", -- [31]
			"62903:63500:63501:65511", -- [32]
			"62903:65863", -- [33]
			"62903:61473:61745:61474:61759:60230:59186:71939", -- [34]
			--["name"] = "Rensai's Watchpost, Townlong Steppes",
			["m"] = 388,
			["f"] = 0,
			["direct"] = "62901:62903:62909",
			["coord"] = 2329659992,
		},
		[61504] = {
			"61474:61759:60230:60952", -- [1]
			"61474:61759:60230:59186", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:66227:59736:59735:59733", -- [4]
			"61474:66227:59736:59735", -- [5]
			"61474:66227:59736", -- [6]
			"61474:66227", -- [7]
			"61474:61759:60230", -- [8]
			"61474:61759:62658:60231", -- [9]
			"61474:60232", -- [10]
			"61474:61759:62658:60231:59046", -- [11]
			"61474:61759:62658:60231:58843", -- [12]
			"61474:61759:62658:60231:58843:59047", -- [13]
			"61474:61759:62658:60231:65189", -- [14]
			"61474:61759:62658:60231:59046:60441", -- [15]
			"60416:61473", -- [16]
			"60416:61512", -- [17]
			"61474:61759", -- [18]
			"61474:61759:62658", -- [19]
			"60416:61512:62901", -- [20]
			"60416:61473:62903", -- [21]
			"60416:61512:62901:62898", -- [22]
			"60416:61512:62901:62898:62909", -- [23]
			"61745:61122", -- [24]
			"60416:61473:62903:63500:63501", -- [25]
			"60416:61473:62903:63500:63501:63498", -- [26]
			"60416:61473:62903:63500", -- [27]
			"61745:61122:63497", -- [28]
			"61474:61759:60230:59186:64310", -- [29]
			"60416:61473:62903:63500:63501:65511", -- [30]
			"60416:61512:62901:65863", -- [31]
			"61474:61759:60230:59186:71939", -- [32]
			--["name"] = "One Keg, Kun-Lai Summit",
			["direct"] = "61474:61118:61745:61511:60416",
			["f"] = 0,
			["m"] = 379,
			["coord"] = 2481101060,
		},
		[60230] = {
			"59186:59732", -- [1]
			"59186:59735:59733", -- [2]
			"59186:59735", -- [3]
			"60952:59736", -- [4]
			"60952:66227", -- [5]
			"60231:58843", -- [6]
			"59046:59047", -- [7]
			"60231:65189", -- [8]
			"59046:60441", -- [9]
			"61759:61474", -- [10]
			"61759:61474:61118", -- [11]
			"61759:61474:61745", -- [12]
			"61759:61474:61118:61511", -- [13]
			"61759:61474:61504", -- [14]
			"61759:61474:61745:60416", -- [15]
			"61759:61474:61745:61473", -- [16]
			"61759:61474:61745:60416:61512", -- [17]
			"62658:61122:65863:62901", -- [18]
			"61759:61474:61745:61473:62903", -- [19]
			"61759:61474:61745:61473:62903:62898", -- [20]
			"61759:61474:61745:61473:62903:62898:62909", -- [21]
			"60231:58843:63501", -- [22]
			"60231:58843:63501:63498", -- [23]
			"62658:61122:63500", -- [24]
			"62658:61122:63497", -- [25]
			"59186:64310", -- [26]
			"60231:58843:63501:65511", -- [27]
			"62658:61122:65863", -- [28]
			"59186:71939", -- [29]
			--["name"] = "Pang's Stead, Valley of the Four Winds",
			["direct"] = "60952:59186:60231:60232:59046:61759:62658:61122",
			["f"] = 0,
			["m"] = 376,
			["coord"] = 3629594111,
		},
		[60232] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"60230:60952:66227", -- [7]
			"60231:58843", -- [8]
			"59046:59047", -- [9]
			"60231:65189", -- [10]
			"59046:60441", -- [11]
			"61474:61118", -- [12]
			"61474:61745", -- [13]
			"61474:61118:61511", -- [14]
			"61474:61504", -- [15]
			"61474:61745:60416", -- [16]
			"61474:61745:61473", -- [17]
			"61474:61745:60416:61512", -- [18]
			"60230:61759", -- [19]
			"60230:62658", -- [20]
			"60231:61122:65863:62901", -- [21]
			"61474:61745:61473:62903", -- [22]
			"61474:61745:61473:62903:62898", -- [23]
			"61474:61745:61473:62903:62898:62909", -- [24]
			"60231:61122", -- [25]
			"60231:58843:63501", -- [26]
			"60231:58843:63501:63498", -- [27]
			"60231:58843:63501:63500", -- [28]
			"60231:58843:63501:63497", -- [29]
			"60230:59186:64310", -- [30]
			"60231:58843:63501:65511", -- [31]
			"60231:61122:65863", -- [32]
			"60230:59186:71939", -- [33]
			--["name"] = "Zhu's Watch, Krasarang Wilds",
			["m"] = 418,
			["f"] = 0,
			["direct"] = "60230:60231:59046:61474",
			["coord"] = 3294762427,
		},
		[62903] = {
			"61473:61745:61474:61759:60230:60952", -- [1]
			"61473:61745:61474:61759:60230:59186", -- [2]
			"61473:61745:61474:61759:60230:59186:59732", -- [3]
			"61473:61745:61474:66227:59736:59735:59733", -- [4]
			"61473:61745:61474:66227:59736:59735", -- [5]
			"61473:61745:61474:66227:59736", -- [6]
			"61473:61745:61474:66227", -- [7]
			"61473:61745:61474:61759:60230", -- [8]
			"63500:63501:58843:60231", -- [9]
			"63500:63501:58843:60231:60232", -- [10]
			"63500:63501:58843:60231:59046", -- [11]
			"63500:63501:58843", -- [12]
			"63500:63501:58843:59047", -- [13]
			"63500:63501:58843:65189", -- [14]
			"63500:63501:58843:59047:60441", -- [15]
			"61473:61745:61474", -- [16]
			"61473:60416:61504:61118", -- [17]
			"61473:61745", -- [18]
			"61473:60416:61504:61118:61511", -- [19]
			"61473:60416:61504", -- [20]
			"61473:60416", -- [21]
			"62901:61512", -- [22]
			"61473:61745:61474:61759", -- [23]
			"61473:61745:61474:61759:62658", -- [24]
			"62898:62909", -- [25]
			"65863:61122", -- [26]
			"63500:63501", -- [27]
			"63500:63501:63498", -- [28]
			"63500:63497", -- [29]
			"61473:61745:61474:61759:60230:59186:64310", -- [30]
			"63500:63501:65511", -- [31]
			"61473:61745:61474:61759:60230:59186:71939", -- [32]
			--["name"] = "Gao-Ran Battlefront, Townlong Steppes",
			["direct"] = "61473:62901:62898:63500:65863",
			["f"] = 0,
			["m"] = 388,
			["coord"] = 3196440686,
		},
		[61118] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:66227:59736:59735:59733", -- [4]
			"61745:61474:66227:59736:59735", -- [5]
			"61745:61474:66227:59736", -- [6]
			"61745:61474:66227", -- [7]
			"61745:61474:61759:60230", -- [8]
			"61745:61474:61759:62658:60231", -- [9]
			"61745:61474:60232", -- [10]
			"61745:61474:61759:62658:60231:59046", -- [11]
			"61745:61474:61759:62658:60231:58843", -- [12]
			"61745:61474:61759:62658:60231:58843:59047", -- [13]
			"61745:61474:61759:62658:60231:65189", -- [14]
			"61745:61474:61759:62658:60231:59046:60441", -- [15]
			"61504:60416", -- [16]
			"61745:61473", -- [17]
			"61504:60416:61512", -- [18]
			"61745:61474:61759", -- [19]
			"61745:61474:61759:62658", -- [20]
			"61504:60416:61512:62901", -- [21]
			"61745:61473:62903", -- [22]
			"61745:61473:62903:62898", -- [23]
			"61745:61473:62903:62898:62909", -- [24]
			"61745:61122", -- [25]
			"61745:61473:62903:63500:63501", -- [26]
			"61745:61473:62903:63500:63501:63498", -- [27]
			"61745:61473:62903:63500", -- [28]
			"61745:61122:63497", -- [29]
			"61745:61474:61759:60230:59186:64310", -- [30]
			"61745:61473:62903:63500:63501:65511", -- [31]
			"61504:60416:61512:62901:65863", -- [32]
			"61745:61474:61759:60230:59186:71939", -- [33]
			--["name"] = "Temple of the White Tiger, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "61474:61745:61511:61504",
			["coord"] = 2847310268,
		},
		[59736] = {
			"59186:59732", -- [1]
			"59735:59733", -- [2]
			"60952:60230", -- [3]
			"60952:60230:60231", -- [4]
			"60952:60230:60232", -- [5]
			"60952:60230:59046", -- [6]
			"60952:60230:60231:58843", -- [7]
			"60952:60230:59046:59047", -- [8]
			"60952:60230:60231:65189", -- [9]
			"60952:60230:59046:60441", -- [10]
			"66227:61474", -- [11]
			"66227:61474:61118", -- [12]
			"66227:61474:61745", -- [13]
			"66227:61474:61118:61511", -- [14]
			"66227:61474:61504", -- [15]
			"66227:61474:61745:60416", -- [16]
			"66227:61474:61745:61473", -- [17]
			"66227:61474:61745:60416:61512", -- [18]
			"60952:60230:61759", -- [19]
			"60952:60230:62658", -- [20]
			"66227:61474:61745:61473:62901", -- [21]
			"66227:61474:61745:61473:62903", -- [22]
			"66227:61474:61745:61473:62903:62898", -- [23]
			"66227:61474:61745:61473:62903:62898:62909", -- [24]
			"66227:61122", -- [25]
			"60952:60230:60231:58843:63501", -- [26]
			"60952:60230:60231:58843:63501:63498", -- [27]
			"66227:61474:61745:61473:62903:63500", -- [28]
			"66227:61122:63497", -- [29]
			"59186:64310", -- [30]
			"60952:60230:60231:58843:63501:65511", -- [31]
			"66227:61474:61745:61473:62903:65863", -- [32]
			"59186:71939", -- [33]
			--["name"] = "Tian Monastery, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "60952:59186:59735:66227",
			["coord"] = 1871527691,
		},
		[61122] = {
			"60230:60952", -- [1]
			"60230:59186:59732", -- [2]
			"66227:59736:59735:59733", -- [3]
			"66227:59736:59735", -- [4]
			"66227:59736", -- [5]
			"60231:60232", -- [6]
			"60231:59046", -- [7]
			"60231:58843", -- [8]
			"60231:58843:59047", -- [9]
			"60231:65189", -- [10]
			"60231:59046:60441", -- [11]
			"61745:61118", -- [12]
			"61745:61511", -- [13]
			"61745:61504", -- [14]
			"61745:60416", -- [15]
			"61745:61473", -- [16]
			"65863:62901:61512", -- [17]
			"62658:61759", -- [18]
			"65863:62901", -- [19]
			"65863:62903", -- [20]
			"65863:62901:62898", -- [21]
			"65863:62901:62898:62909", -- [22]
			"63497:63498", -- [23]
			"60230:59186:64310", -- [24]
			"63501:65511", -- [25]
			"60230:59186:71939", -- [26]
			--["name"] = "Shrine of Two Moons, Vale of Eternal Blossoms",
			["direct"] = "59186:66227:60230:60231:61474:61745:62658:63501:63500:63497:65863",
			["f"] = 0,
			["m"] = 390,
			["coord"] = 2690660296,
		},
		[59732] = {
			"59186:60952", -- [1]
			"59186:59735", -- [2]
			"59186:59736", -- [3]
			"59186:66227", -- [4]
			"59186:60230", -- [5]
			"59186:60230:60231", -- [6]
			"59186:60230:60232", -- [7]
			"59186:60230:59046", -- [8]
			"59186:60230:60231:58843", -- [9]
			"59186:60230:59046:59047", -- [10]
			"59186:60230:60231:65189", -- [11]
			"59186:60230:59046:60441", -- [12]
			"59186:60230:61759:61474", -- [13]
			"59186:60230:61759:61474:61118", -- [14]
			"59186:60230:61759:61474:61745", -- [15]
			"59186:60230:61759:61474:61118:61511", -- [16]
			"59186:60230:61759:61474:61504", -- [17]
			"59186:60230:61759:61474:61745:60416", -- [18]
			"59186:60230:61759:61474:61745:61473", -- [19]
			"59186:60230:61759:61474:61745:60416:61512", -- [20]
			"59186:60230:61759", -- [21]
			"59186:60230:62658", -- [22]
			"59186:61122:65863:62901", -- [23]
			"59186:60230:61759:61474:61745:61473:62903", -- [24]
			"59186:60230:61759:61474:61745:61473:62903:62898", -- [25]
			"59186:60230:61759:61474:61745:61473:62903:62898:62909", -- [26]
			"59186:61122", -- [27]
			"59186:60230:60231:58843:63501", -- [28]
			"59186:60230:60231:58843:63501:63498", -- [29]
			"59186:61122:63500", -- [30]
			"59186:61122:63497", -- [31]
			"59186:64310", -- [32]
			"59186:60230:60231:58843:63501:65511", -- [33]
			"59186:61122:65863", -- [34]
			"59186:71939", -- [35]
			--["name"] = "The Arboretum, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59186:59733",
			["coord"] = 2449305813,
		},
		[59047] = {
			"59046:60230:60952", -- [1]
			"59046:60230:59186", -- [2]
			"59046:60230:59186:59732", -- [3]
			"59046:60230:59186:59735:59733", -- [4]
			"59046:60230:59186:59735", -- [5]
			"59046:60230:60952:59736", -- [6]
			"59046:60230:60952:66227", -- [7]
			"59046:60230", -- [8]
			"59046:60231", -- [9]
			"59046:60232", -- [10]
			"59046:60231:62658:61759:61474", -- [11]
			"59046:60231:62658:61759:61474:61118", -- [12]
			"59046:60231:62658:61759:61474:61745", -- [13]
			"59046:60231:62658:61759:61474:61118:61511", -- [14]
			"59046:60231:62658:61759:61474:61504", -- [15]
			"63501:63500:62903:61473:60416", -- [16]
			"63501:63500:62903:61473", -- [17]
			"63501:63497:61512", -- [18]
			"59046:60231:62658:61759", -- [19]
			"59046:60231:62658", -- [20]
			"63501:63500:62903:62901", -- [21]
			"63501:63500:62903", -- [22]
			"63501:63500:62903:62898", -- [23]
			"63501:63500:62903:62898:62909", -- [24]
			"59046:60231:61122", -- [25]
			"63501:63498", -- [26]
			"63501:63500", -- [27]
			"63501:63497", -- [28]
			"59046:60230:59186:64310", -- [29]
			"63501:65511", -- [30]
			"63501:63500:62903:65863", -- [31]
			"59046:60230:59186:71939", -- [32]
			--["name"] = "Dawnchaser Retreat, Krasarang Wilds",
			["direct"] = "59046:58843:65189:60441:63501",
			["f"] = 0,
			["m"] = 418,
			["coord"] = 1243906316,
		},
		[71939] = {
			"59186:60952", -- [1]
			"59186:59732", -- [2]
			"59186:59735:59733", -- [3]
			"59186:59735", -- [4]
			"59186:59736", -- [5]
			"59186:66227", -- [6]
			"59186:60230", -- [7]
			"59186:60230:60231", -- [8]
			"59186:60230:60232", -- [9]
			"59186:60230:59046", -- [10]
			"59186:60230:60231:58843", -- [11]
			"59186:60230:59046:59047", -- [12]
			"59186:60230:60231:65189", -- [13]
			"59186:60230:59046:60441", -- [14]
			"59186:60230:61759:61474", -- [15]
			"59186:60230:61759:61474:61118", -- [16]
			"59186:60230:61759:61474:61745", -- [17]
			"59186:60230:61759:61474:61118:61511", -- [18]
			"59186:60230:61759:61474:61504", -- [19]
			"59186:60230:61759:61474:61745:60416", -- [20]
			"59186:60230:61759:61474:61745:61473", -- [21]
			"59186:60230:61759:61474:61745:60416:61512", -- [22]
			"59186:60230:61759", -- [23]
			"59186:60230:62658", -- [24]
			"59186:61122:65863:62901", -- [25]
			"59186:60230:61759:61474:61745:61473:62903", -- [26]
			"59186:60230:61759:61474:61745:61473:62903:62898", -- [27]
			"59186:60230:61759:61474:61745:61473:62903:62898:62909", -- [28]
			"59186:61122", -- [29]
			"59186:60230:60231:58843:63501", -- [30]
			"59186:60230:60231:58843:63501:63498", -- [31]
			"59186:61122:63500", -- [32]
			"59186:61122:63497", -- [33]
			"59186:64310", -- [34]
			"59186:60230:60231:58843:63501:65511", -- [35]
			"59186:61122:65863", -- [36]
			--["name"] = "Huojin Landing, Timeless Isle",
			["m"] = 554,
			["f"] = 0,
			["direct"] = "59186",
			["coord"] = 940008994,
		},
		[66227] = {
			"59186:59732", -- [1]
			"59736:59735:59733", -- [2]
			"59736:59735", -- [3]
			"60952:60230", -- [4]
			"61474:61759:62658:60231", -- [5]
			"60952:60230:60232", -- [6]
			"60952:60230:59046", -- [7]
			"61474:61759:62658:60231:58843", -- [8]
			"61474:61759:62658:60231:58843:59047", -- [9]
			"61474:61759:62658:60231:65189", -- [10]
			"60952:60230:59046:60441", -- [11]
			"61474:61118", -- [12]
			"61474:61745", -- [13]
			"61474:61118:61511", -- [14]
			"61474:61504", -- [15]
			"61474:61745:60416", -- [16]
			"61474:61745:61473", -- [17]
			"61474:61745:60416:61512", -- [18]
			"61474:61759", -- [19]
			"61474:61759:62658", -- [20]
			"61474:61745:61473:62901", -- [21]
			"61474:61745:61473:62903", -- [22]
			"61474:61745:61473:62903:62898", -- [23]
			"61474:61745:61473:62903:62898:62909", -- [24]
			"61122:63501", -- [25]
			"61122:63497:63498", -- [26]
			"61474:61745:61473:62903:63500", -- [27]
			"61122:63497", -- [28]
			"59186:64310", -- [29]
			"61122:63501:65511", -- [30]
			"61474:61745:61473:62903:65863", -- [31]
			"59186:71939", -- [32]
			--["name"] = "Honeydew Village, Jade Forest",
			["direct"] = "60952:59186:59736:61474:61122",
			["f"] = 0,
			["m"] = 371,
			["coord"] = 1207707634,
		},
	},
	[7] = {
		[84700] = {
			"84714:92808:90562:76850", -- [1]
			"85829:76787:76781:76782", -- [2]
			"85829:76787:76781", -- [3]
			"85829:76787:76783", -- [4]
			"85829:76787", -- [5]
			"85829:76787:78699:76879", -- [6]
			"85829:76784", -- [7]
			"85829:76787:78699", -- [8]
			"85829:86049", -- [9]
			"85829:76784:79407", -- [10]
			"85829:81055:84508:90552:80932", -- [11]
			"85829:81055:84508:81053", -- [12]
			"85829:76784:81057", -- [13]
			"85829:76784:81064:81058", -- [14]
			"85829:76784:81064", -- [15]
			"85829:76784:81064:81068", -- [16]
			"85829:76784:81064:81078", -- [17]
			"85829:76784:81057:81354", -- [18]
			"84714:92808:90562:76850:81285", -- [19]
			"85829:76784:81057:82612", -- [20]
			"85829:76784:79407:82346:83924", -- [21]
			"85829:76784:79407:82844", -- [22]
			"85829:76784:79407:82346", -- [23]
			"85829:76784:79407:82844:82340", -- [24]
			"85829:76784:81057:81354:84515:84498", -- [25]
			"85829:76784:81057:81354:84515:84504", -- [26]
			"85829:76784:81057:81354:84515:82511", -- [27]
			"85829:81055:84508", -- [28]
			"85829:76784:81064:81078:84509", -- [29]
			"85829:84495", -- [30]
			"85829:76784:81057:81354:84515", -- [31]
			"84714:92808:90562:76850:83427", -- [32]
			"85829:76784:87707", -- [33]
			"85829:76784:81057:81354:88584", -- [34]
			"85829:76787:87395", -- [35]
			"85829:76787:87395:88653", -- [36]
			"85829:76784:79407:88668", -- [37]
			"84714:88757", -- [38]
			"84714:92808:90550", -- [39]
			"85829:81055:84508:90560", -- [40]
			"85829:81055:84508:90552", -- [41]
			"84714:92808:90562", -- [42]
			"84714:92808", -- [43]
			"84714:92808:92809", -- [44]
			--["name"] = "Iron Docks, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "81055:86492:85829:84714",
			["coord"] = 1850160084,
		},
		[84515] = {
			"84504:76850", -- [1]
			"81354:81064:79407:76782", -- [2]
			"81354:81064:79407:76781", -- [3]
			"81354:81064:76787:76783", -- [4]
			"81354:81064:76787", -- [5]
			"81354:81064:79407:76879", -- [6]
			"81057:76784", -- [7]
			"81354:81064:79407:78699", -- [8]
			"88584:86049", -- [9]
			"81354:81064:79407", -- [10]
			"81354:80932", -- [11]
			"81057:81053", -- [12]
			"81057:84495:81055", -- [13]
			"81354:81058", -- [14]
			"81354:81064", -- [15]
			"84509:81068", -- [16]
			"84509:81078", -- [17]
			"84504:81285", -- [18]
			"81354:81064:82346:83924", -- [19]
			"81354:81064:82346:82844", -- [20]
			"81354:81064:82346", -- [21]
			"81354:81064:82346:82340", -- [22]
			"81057:84508", -- [23]
			"81057:84495", -- [24]
			"81057:84495:81055:86492", -- [25]
			"81057:84495:81055:84700", -- [26]
			"84504:81285:83427", -- [27]
			"81057:84495:85829", -- [28]
			"81057:76784:87707", -- [29]
			"81057:84495:81055:84714", -- [30]
			"81354:81064:82346:82340:87395", -- [31]
			"84498:82612:88653", -- [32]
			"81354:81064:82346:82844:88668", -- [33]
			"81057:84495:81055:84714:88757", -- [34]
			"81354:80932:90562:90550", -- [35]
			"81354:80932:90560", -- [36]
			"81057:90552", -- [37]
			"81354:80932:90562", -- [38]
			"81354:80932:92809:92808", -- [39]
			"81354:80932:92809", -- [40]
			--["name"] = "Crow's Crook, Spires of Arak",
			["m"] = 542,
			["coord"] = 2222935940,
			["direct"] = "81057:81354:82612:84498:84504:82511:84509:88584",
			["f"] = 0,
		},
		[81058] = {
			"81078:76850", -- [1]
			"81064:79407:76782", -- [2]
			"81064:79407:76781", -- [3]
			"81064:76787:76783", -- [4]
			"81064:76787", -- [5]
			"81064:79407:76879", -- [6]
			"81064:76784", -- [7]
			"81064:79407:78699", -- [8]
			"81053:90552:90550:86049", -- [9]
			"81064:79407", -- [10]
			"81064:81057:80932", -- [11]
			"81053:84495:81055", -- [12]
			"81064:81068", -- [13]
			"81064:88584:81285", -- [14]
			"81078:84509:82612", -- [15]
			"81064:82346:83924", -- [16]
			"81064:82346:82844", -- [17]
			"81064:82346:82340", -- [18]
			"81078:84509:84498", -- [19]
			"81078:84509:84515:84504", -- [20]
			"81078:84509:84498:82511", -- [21]
			"81053:84508", -- [22]
			"81078:84509", -- [23]
			"81053:84495", -- [24]
			"81078:84509:84515", -- [25]
			"81064:76784:86492", -- [26]
			"81064:76784:85829:84700", -- [27]
			"81064:88584:81285:83427", -- [28]
			"81064:76784:85829", -- [29]
			"81064:76784:87707", -- [30]
			"81064:76784:86492:84714", -- [31]
			"81064:88584", -- [32]
			"81064:82346:82340:87395", -- [33]
			"81064:82346:83924:88653", -- [34]
			"81064:82346:82844:88668", -- [35]
			"81064:76784:86492:84714:88757", -- [36]
			"81053:90552:90550", -- [37]
			"81053:90552:90560", -- [38]
			"81053:90552", -- [39]
			"81053:90552:90562", -- [40]
			"81053:90552:92809:92808", -- [41]
			"81053:90552:92809", -- [42]
			--["name"] = "Durotan's Grasp, Talador",
			["m"] = 535,
			["coord"] = 2382587995,
			["direct"] = "81053:81057:81064:81078:81354:82346",
			["f"] = 0,
		},
		[82511] = {
			"84504:76850", -- [1]
			"84504:88584:81064:79407:76782", -- [2]
			"84504:88584:81064:79407:76781", -- [3]
			"84504:88584:81064:76787:76783", -- [4]
			"84504:88584:81064:76787", -- [5]
			"84504:88584:81064:79407:76879", -- [6]
			"84504:88584:81354:81057:76784", -- [7]
			"84504:88584:81064:79407:78699", -- [8]
			"84504:76850:86049", -- [9]
			"84504:88584:81354:80932", -- [10]
			"84504:88584:81354:81057:81053", -- [11]
			"84504:88584:81354:81057:84495:81055", -- [12]
			"84504:88584:81354:81057", -- [13]
			"84504:88584:81354:81058", -- [14]
			"84504:88584:81064", -- [15]
			"84498:84509:81068", -- [16]
			"84498:84509:81078", -- [17]
			"84504:88584:81354", -- [18]
			"84504:81285", -- [19]
			"84498:82612", -- [20]
			"84504:88584:81064:82346:83924", -- [21]
			"84504:88584:81064:82346:82844", -- [22]
			"84504:88584:81064:82346", -- [23]
			"84498:82612:88653:82340", -- [24]
			"84504:88584:81354:81057:84508", -- [25]
			"84498:84509", -- [26]
			"84504:88584:81354:81057:84495", -- [27]
			"84504:88584:81354:81057:84495:81055:86492", -- [28]
			"84504:88584:81354:81057:84495:81055:84700", -- [29]
			"84504:81285:83427", -- [30]
			"84504:88584:81354:81057:84495:85829", -- [31]
			"84504:88584:81354:81057:76784:87707", -- [32]
			"84504:88584:81354:81057:84495:81055:84714", -- [33]
			"84498:82612:88653:82340:87395", -- [34]
			"84498:82612:88653", -- [35]
			"84504:88584:81064:82346:82844:88668", -- [36]
			"84504:88584:81354:81057:84495:81055:84714:88757", -- [37]
			"84504:76850:90562:90550", -- [38]
			"84504:88584:81354:80932:90560", -- [39]
			"84504:88584:81354:81057:90552", -- [40]
			"84504:76850:90562", -- [41]
			"84504:76850:90562:92808", -- [42]
			"84504:88584:81354:80932:92809", -- [43]
			--["name"] = "Pinchwhistle Gearworks, Spires of Arak",
			["m"] = 542,
			["f"] = 0,
			["direct"] = "79407:84498:84504:84515:88584",
			["coord"] = 2614672287,
		},
		[76782] = {
			"79407:81057:81354:76850", -- [1]
			"76781:76783", -- [2]
			"76879:78699:76787", -- [3]
			"79407:76784", -- [4]
			"76879:78699", -- [5]
			"79407:86049", -- [6]
			"79407:81057:80932", -- [7]
			"79407:81053", -- [8]
			"79407:81055", -- [9]
			"79407:81057", -- [10]
			"79407:81053:81058", -- [11]
			"79407:81064", -- [12]
			"79407:81064:81068", -- [13]
			"79407:81064:81078", -- [14]
			"79407:81057:81354", -- [15]
			"79407:81064:88584:81285", -- [16]
			"79407:82612", -- [17]
			"79407:82346:83924", -- [18]
			"79407:82844", -- [19]
			"79407:82346", -- [20]
			"79407:82844:82340", -- [21]
			"79407:81064:81078:84509:84498", -- [22]
			"79407:81064:81078:84509:84515:84504", -- [23]
			"79407:82511", -- [24]
			"79407:81053:84508", -- [25]
			"79407:81064:81078:84509", -- [26]
			"79407:76784:84495", -- [27]
			"79407:81064:81078:84509:84515", -- [28]
			"79407:76784:86492", -- [29]
			"76879:78699:76787:85829:84700", -- [30]
			"79407:81057:83427", -- [31]
			"76879:78699:76787:85829", -- [32]
			"79407:87707", -- [33]
			"79407:76784:86492:84714", -- [34]
			"79407:81064:88584", -- [35]
			"79407:87395", -- [36]
			"79407:88668:88653", -- [37]
			"79407:88668", -- [38]
			"79407:76784:86492:84714:88757", -- [39]
			"79407:81053:90552:90550", -- [40]
			"79407:81053:90552:90560", -- [41]
			"79407:81053:90552", -- [42]
			"79407:81053:90552:90562", -- [43]
			"79407:81053:90552:92809:92808", -- [44]
			"79407:81053:90552:92809", -- [45]
			--["name"] = "Wor'gol, Frostfire Ridge",
			["m"] = 525,
			["coord"] = 928157606,
			["direct"] = "76781:76879:79407",
			["f"] = 0,
		},
		[86492] = {
			"81055:84508:90552:90562:76850", -- [1]
			"76784:79407:76782", -- [2]
			"76784:76879:76781", -- [3]
			"85829:76787:76783", -- [4]
			"85829:76787", -- [5]
			"76784:76879", -- [6]
			"76784:87707:78699", -- [7]
			"84714:86049", -- [8]
			"76784:79407", -- [9]
			"81055:84508:90552:80932", -- [10]
			"81055:84508:81053", -- [11]
			"81055:81057", -- [12]
			"81055:84508:81053:81058", -- [13]
			"76784:81064", -- [14]
			"76784:81064:81068", -- [15]
			"76784:81064:81078", -- [16]
			"81055:81057:81354", -- [17]
			"81055:81057:81285", -- [18]
			"81055:81057:82612", -- [19]
			"81055:84508:81053:82346:83924", -- [20]
			"76784:79407:82844", -- [21]
			"81055:84508:81053:82346", -- [22]
			"76784:79407:82844:82340", -- [23]
			"81055:81057:81354:84515:84498", -- [24]
			"81055:81057:81354:84515:84504", -- [25]
			"81055:81057:81354:84515:82511", -- [26]
			"81055:84508", -- [27]
			"76784:81064:81078:84509", -- [28]
			"81055:84495", -- [29]
			"81055:81057:81354:84515", -- [30]
			"81055:81057:83427", -- [31]
			"76784:87707", -- [32]
			"81055:81057:81354:88584", -- [33]
			"76784:79407:87395", -- [34]
			"76784:79407:88668:88653", -- [35]
			"76784:79407:88668", -- [36]
			"84714:88757", -- [37]
			"84714:92808:90550", -- [38]
			"81055:84508:90560", -- [39]
			"81055:84508:90552", -- [40]
			"81055:84508:90552:90562", -- [41]
			"84714:92808", -- [42]
			"81055:84508:90552:92809", -- [43]
			--["name"] = "Breaker's Crown, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "76784:81055:84700:85829:84714",
			["coord"] = 1970048188,
		},
		[81078] = {
			"81064:79407:76782", -- [1]
			"81064:79407:76781", -- [2]
			"81064:76787:76783", -- [3]
			"81064:76787", -- [4]
			"81064:79407:76879", -- [5]
			"81064:76784", -- [6]
			"81064:79407:78699", -- [7]
			"81354:80932:90562:90550:86049", -- [8]
			"81064:79407", -- [9]
			"81354:80932", -- [10]
			"81058:81053", -- [11]
			"81354:81057:84495:81055", -- [12]
			"81354:81057", -- [13]
			"84509:82612", -- [14]
			"81064:82346:83924", -- [15]
			"81064:82346:82844", -- [16]
			"81064:82346", -- [17]
			"81064:82346:82340", -- [18]
			"84509:84498", -- [19]
			"84509:84515:84504", -- [20]
			"84509:84498:82511", -- [21]
			"81354:81057:84508", -- [22]
			"81354:81057:84495", -- [23]
			"84509:84515", -- [24]
			"81064:76784:86492", -- [25]
			"81064:76784:85829:84700", -- [26]
			"81285:83427", -- [27]
			"81064:76784:85829", -- [28]
			"81064:76784:87707", -- [29]
			"81064:76784:86492:84714", -- [30]
			"81064:82346:82340:87395", -- [31]
			"81064:82346:83924:88653", -- [32]
			"81064:82346:82844:88668", -- [33]
			"81064:76784:86492:84714:88757", -- [34]
			"81354:80932:90562:90550", -- [35]
			"81354:80932:90560", -- [36]
			"81354:81057:90552", -- [37]
			"81354:80932:90562", -- [38]
			"81354:80932:92809:92808", -- [39]
			"81354:80932:92809", -- [40]
			--["name"] = "Exarch's Refuge, Talador",
			["m"] = 535,
			["coord"] = 2342432177,
			["direct"] = "76850:81058:81064:81068:81354:81285:84509:88584",
			["f"] = 0,
		},
		[82346] = {
			"81064:81078:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"79407:78699:76783", -- [4]
			"79407:76787", -- [5]
			"79407:76879", -- [6]
			"79407:76784", -- [7]
			"79407:78699", -- [8]
			"81053:90552:90550:86049", -- [9]
			"81057:80932", -- [10]
			"83924:81068", -- [11]
			"81064:81078", -- [12]
			"81058:81354", -- [13]
			"81064:88584:81285", -- [14]
			"83924:81068:84509:84498", -- [15]
			"83924:81068:84509:84515:84504", -- [16]
			"83924:81068:84509:84498:82511", -- [17]
			"81053:84508", -- [18]
			"83924:81068:84509", -- [19]
			"81053:84495", -- [20]
			"83924:81068:84509:84515", -- [21]
			"81055:86492", -- [22]
			"81055:84700", -- [23]
			"81064:88584:81285:83427", -- [24]
			"81055:85829", -- [25]
			"79407:87707", -- [26]
			"81055:84714", -- [27]
			"81064:88584", -- [28]
			"82340:87395", -- [29]
			"83924:88653", -- [30]
			"82844:88668", -- [31]
			"81055:84714:88757", -- [32]
			"81053:90552:90550", -- [33]
			"81053:90552:90560", -- [34]
			"81053:90552", -- [35]
			"81053:90552:90562", -- [36]
			"81053:90552:92809:92808", -- [37]
			"81053:90552:92809", -- [38]
			--["name"] = "Wor'var, Nagrand",
			["m"] = 550,
			["f"] = 0,
			["direct"] = "79407:81053:81055:81057:81058:81064:82612:83924:82844:82340",
			["coord"] = 3575018026,
		},
		[92808] = {
			"90562:76850", -- [1]
			"90560:84508:84495:76784:79407:76782", -- [2]
			"90560:84508:84495:76784:76879:76781", -- [3]
			"90560:84508:84495:76784:76787:76783", -- [4]
			"90560:84508:84495:76784:76787", -- [5]
			"90560:84508:84495:76784:76879", -- [6]
			"90560:84508:84495:76784", -- [7]
			"90560:84508:84495:76784:87707:78699", -- [8]
			"90550:86049", -- [9]
			"90560:84508:84495:76784:79407", -- [10]
			"92809:80932", -- [11]
			"90560:84508:81053", -- [12]
			"90560:84508:81055", -- [13]
			"90560:90552:81057", -- [14]
			"90560:84508:81053:81058", -- [15]
			"90560:84508:81053:81058:81064", -- [16]
			"90560:84508:81053:81058:81064:81068", -- [17]
			"92809:80932:81354:81078", -- [18]
			"92809:80932:81354", -- [19]
			"90562:76850:81285", -- [20]
			"90562:76850:88584:82612", -- [21]
			"90560:84508:81053:82346:83924", -- [22]
			"90560:84508:81053:82346:82844", -- [23]
			"90560:84508:81053:82346", -- [24]
			"90560:84508:81053:82346:82340", -- [25]
			"92809:80932:81354:84515:84498", -- [26]
			"90562:76850:84504", -- [27]
			"90562:76850:84504:82511", -- [28]
			"90560:84508", -- [29]
			"92809:80932:81354:81078:84509", -- [30]
			"90560:84508:84495", -- [31]
			"92809:80932:81354:84515", -- [32]
			"90560:84508:81055:86492", -- [33]
			"84714:84700", -- [34]
			"90562:76850:83427", -- [35]
			"84714:85829", -- [36]
			"90560:84508:84495:76784:87707", -- [37]
			"90562:76850:88584", -- [38]
			"90560:84508:81053:82346:82340:87395", -- [39]
			"90560:84508:81053:82346:83924:88653", -- [40]
			"90560:84508:81053:82346:82844:88668", -- [41]
			"84714:88757", -- [42]
			"90560:90552", -- [43]
			["direct"] = "84714:90550:90560:90562:92809",
			["m"] = 534,
			["coord"] = 1863937064,
			["f"] = 0,
		},
		[81354] = {
			"81064:79407:76782", -- [1]
			"81064:79407:76781", -- [2]
			"81064:76787:76783", -- [3]
			"81064:76787", -- [4]
			"81064:79407:76879", -- [5]
			"81057:76784", -- [6]
			"81064:79407:78699", -- [7]
			"80932:90562:90550:86049", -- [8]
			"81064:79407", -- [9]
			"81057:81053", -- [10]
			"81057:84495:81055", -- [11]
			"81078:81068", -- [12]
			"88584:81285", -- [13]
			"84515:84498:82612", -- [14]
			"81064:82346:83924", -- [15]
			"81064:82346:82844", -- [16]
			"81064:82346", -- [17]
			"81064:82346:82340", -- [18]
			"84515:84498", -- [19]
			"84515:84504", -- [20]
			"84515:82511", -- [21]
			"81057:84508", -- [22]
			"81078:84509", -- [23]
			"81057:84495", -- [24]
			"81057:84495:81055:86492", -- [25]
			"81057:84495:81055:84700", -- [26]
			"88584:81285:83427", -- [27]
			"81057:84495:85829", -- [28]
			"81057:76784:87707", -- [29]
			"81057:84495:81055:84714", -- [30]
			"81064:82346:82340:87395", -- [31]
			"81064:82346:83924:88653", -- [32]
			"81064:82346:82844:88668", -- [33]
			"81057:84495:81055:84714:88757", -- [34]
			"80932:90562:90550", -- [35]
			"80932:90560", -- [36]
			"81057:90552", -- [37]
			"80932:90562", -- [38]
			"80932:92809:92808", -- [39]
			"80932:92809", -- [40]
			--["name"] = "Terokkar Refuge, Talador",
			["m"] = 535,
			["coord"] = 3022164527,
			["direct"] = "76850:80932:81057:81058:81064:81078:84515:88584",
			["f"] = 0,
		},
		[84508] = {
			"90552:90562:76850", -- [1]
			"84495:76784:79407:76782", -- [2]
			"84495:76784:76879:76781", -- [3]
			"84495:76784:76787:76783", -- [4]
			"84495:76784:76787", -- [5]
			"84495:76784:76879", -- [6]
			"84495:76784", -- [7]
			"84495:76784:87707:78699", -- [8]
			"84495:76784:79407", -- [9]
			"90552:80932", -- [10]
			"81053:81058", -- [11]
			"81053:81058:81064", -- [12]
			"81053:81058:81064:81068", -- [13]
			"81053:81058:81078", -- [14]
			"81057:81354", -- [15]
			"81057:81285", -- [16]
			"81057:82612", -- [17]
			"81053:82346:83924", -- [18]
			"81053:82346:82844", -- [19]
			"81053:82346", -- [20]
			"81053:82346:82340", -- [21]
			"81057:81354:84515:84498", -- [22]
			"81057:81354:84515:84504", -- [23]
			"81057:81354:84515:82511", -- [24]
			"81053:81058:81078:84509", -- [25]
			"81057:81354:84515", -- [26]
			"81055:86492", -- [27]
			"81055:84700", -- [28]
			"81057:83427", -- [29]
			"81055:85829", -- [30]
			"84495:76784:87707", -- [31]
			"81055:84714", -- [32]
			"81057:81354:88584", -- [33]
			"81053:82346:82340:87395", -- [34]
			"81053:82346:83924:88653", -- [35]
			"81053:82346:82844:88668", -- [36]
			"81055:84714:88757", -- [37]
			"90560:90550", -- [38]
			"90552:90562", -- [39]
			"90560:92808", -- [40]
			"90552:92809", -- [41]
			--["name"] = "Bastion Rise, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "86049:81053:81055:81057:84495:90560:90552",
			["coord"] = 2037246059,
		},
		[90560] = {
			"90562:76850", -- [1]
			"84508:84495:76784:79407:76782", -- [2]
			"84508:84495:76784:76879:76781", -- [3]
			"84508:84495:76784:76787:76783", -- [4]
			"84508:84495:76784:76787", -- [5]
			"84508:84495:76784:76879", -- [6]
			"84508:84495:76784", -- [7]
			"84508:84495:76784:87707:78699", -- [8]
			"90550:86049", -- [9]
			"84508:84495:76784:79407", -- [10]
			"84508:81053", -- [11]
			"84508:81055", -- [12]
			"90552:81057", -- [13]
			"84508:81053:81058", -- [14]
			"84508:81053:81058:81064", -- [15]
			"84508:81053:81058:81064:81068", -- [16]
			"80932:81354:81078", -- [17]
			"80932:81354", -- [18]
			"90562:76850:81285", -- [19]
			"90552:81057:82612", -- [20]
			"84508:81053:82346:83924", -- [21]
			"84508:81053:82346:82844", -- [22]
			"84508:81053:82346", -- [23]
			"84508:81053:82346:82340", -- [24]
			"80932:81354:84515:84498", -- [25]
			"80932:81354:84515:84504", -- [26]
			"80932:81354:84515:82511", -- [27]
			"80932:81354:81078:84509", -- [28]
			"84508:84495", -- [29]
			"80932:81354:84515", -- [30]
			"84508:81055:86492", -- [31]
			"84508:81055:84700", -- [32]
			"90562:76850:83427", -- [33]
			"84508:81055:85829", -- [34]
			"84508:84495:76784:87707", -- [35]
			"84508:81055:84714", -- [36]
			"80932:81354:88584", -- [37]
			"84508:81053:82346:82340:87395", -- [38]
			"84508:81053:82346:83924:88653", -- [39]
			"84508:81053:82346:82844:88668", -- [40]
			"84508:81055:84714:88757", -- [41]
			--["name"] = "Aktar's Post, Tanaan Jungle",
			["m"] = 534,
			["f"] = 0,
			["direct"] = "80932:84508:90550:90552:90562:92808:92809",
			["coord"] = 1123443651,
		},
		[81055] = {
			"84508:90552:90562:76850", -- [1]
			"79407:76782", -- [2]
			"76784:76879:76781", -- [3]
			"76784:76787:76783", -- [4]
			"76784:76787", -- [5]
			"76784:76879", -- [6]
			"76784:87707:78699", -- [7]
			"84508:90552:80932", -- [8]
			"84508:81053", -- [9]
			"84508:81053:81058", -- [10]
			"84508:81053:81058:81064", -- [11]
			"84508:81053:81058:81064:81068", -- [12]
			"84508:81053:81058:81078", -- [13]
			"81057:81354", -- [14]
			"81057:81285", -- [15]
			"81057:82612", -- [16]
			"84508:81053:82346:83924", -- [17]
			"79407:82844", -- [18]
			"84508:81053:82346:82340", -- [19]
			"81057:81354:84515:84498", -- [20]
			"81057:81354:84515:84504", -- [21]
			"81057:81354:84515:82511", -- [22]
			"84508:81053:81058:81078:84509", -- [23]
			"81057:81354:84515", -- [24]
			"81057:83427", -- [25]
			"76784:87707", -- [26]
			"81057:81354:88584", -- [27]
			"79407:87395", -- [28]
			"84508:81053:82346:83924:88653", -- [29]
			"79407:88668", -- [30]
			"84714:88757", -- [31]
			"84508:90560:90550", -- [32]
			"84508:90560", -- [33]
			"84508:90552", -- [34]
			"84508:90552:90562", -- [35]
			"84508:90560:92808", -- [36]
			"84508:90552:92809", -- [37]
			--["name"] = "Beastwatch, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "76784:86049:79407:81057:82346:84508:84495:86492:84700:85829:84714",
			["coord"] = 1976152391,
		},
		[76783] = {
			"78699:79407:81057:81354:76850", -- [1]
			"76781:76782", -- [2]
			"76781:76879", -- [3]
			"76787:76784", -- [4]
			"76787:85829:86049", -- [5]
			"78699:79407", -- [6]
			"78699:79407:81057:80932", -- [7]
			"78699:79407:81053", -- [8]
			"76787:76784:81055", -- [9]
			"78699:79407:81057", -- [10]
			"78699:79407:81053:81058", -- [11]
			"78699:79407:81064", -- [12]
			"78699:79407:81064:81068", -- [13]
			"78699:79407:81064:81078", -- [14]
			"78699:79407:81057:81354", -- [15]
			"78699:79407:81064:88584:81285", -- [16]
			"78699:79407:82612", -- [17]
			"78699:79407:82346:83924", -- [18]
			"78699:79407:82844", -- [19]
			"78699:79407:82346", -- [20]
			"78699:79407:82844:82340", -- [21]
			"78699:79407:81064:81078:84509:84498", -- [22]
			"78699:79407:81064:81078:84509:84515:84504", -- [23]
			"78699:79407:82511", -- [24]
			"76787:76784:81055:84508", -- [25]
			"78699:79407:81064:81078:84509", -- [26]
			"76787:76784:84495", -- [27]
			"78699:79407:81064:81078:84509:84515", -- [28]
			"76787:85829:86492", -- [29]
			"76787:85829:84700", -- [30]
			"78699:79407:81057:83427", -- [31]
			"76787:85829", -- [32]
			"78699:87707", -- [33]
			"76787:85829:84714", -- [34]
			"78699:79407:81064:88584", -- [35]
			"78699:79407:87395", -- [36]
			"78699:79407:88668:88653", -- [37]
			"78699:79407:88668", -- [38]
			"76787:85829:84714:88757", -- [39]
			"78699:79407:81053:90552:90550", -- [40]
			"76787:76784:81055:84508:90560", -- [41]
			"78699:79407:81053:90552", -- [42]
			"78699:79407:81053:90552:90562", -- [43]
			"78699:79407:81053:90552:92809:92808", -- [44]
			"78699:79407:81053:90552:92809", -- [45]
			--["name"] = "Throm'Var, Frostfire Ridge",
			["m"] = 525,
			["coord"] = 1367283875,
			["direct"] = "76781:76787:78699",
			["f"] = 0,
		},
		[76850] = {
			"81354:81064:79407:76782", -- [1]
			"81354:81064:79407:76781", -- [2]
			"81354:81064:76787:76783", -- [3]
			"81354:81064:76787", -- [4]
			"81354:81064:79407:76879", -- [5]
			"81354:81057:76784", -- [6]
			"81354:81064:79407:78699", -- [7]
			"81354:81064:79407", -- [8]
			"81354:80932", -- [9]
			"81354:81057:81053", -- [10]
			"90562:92809:90560:84508:81055", -- [11]
			"81354:81057", -- [12]
			"81354:81058", -- [13]
			"81354:81064", -- [14]
			"81078:81068", -- [15]
			"88584:82612", -- [16]
			"81354:81064:82346:83924", -- [17]
			"81354:81064:82346:82844", -- [18]
			"81354:81064:82346", -- [19]
			"81354:81064:82346:82340", -- [20]
			"88584:84515:84498", -- [21]
			"84504:82511", -- [22]
			"90562:92809:90560:84508", -- [23]
			"88584:84515:84509", -- [24]
			"81354:81057:84495", -- [25]
			"88584:84515", -- [26]
			"90562:92809:90560:84508:81055:86492", -- [27]
			"90562:92808:84714:84700", -- [28]
			"90562:92808:84714:85829", -- [29]
			"81354:81057:76784:87707", -- [30]
			"90562:92808:84714", -- [31]
			"81354:81064:82346:82340:87395", -- [32]
			"81354:81064:82346:83924:88653", -- [33]
			"81354:81064:82346:82844:88668", -- [34]
			"90562:92808:84714:88757", -- [35]
			"90562:90550", -- [36]
			"90562:92809:90560", -- [37]
			"90562:90552", -- [38]
			"90562:92808", -- [39]
			"90562:92809", -- [40]
			--["name"] = "Exile's Rise, Shadowmoon Valley",
			["m"] = 539,
			["coord"] = 1960067326,
			["direct"] = "86049:81078:81354:81285:84504:83427:88584:90562",
			["f"] = 0,
		},
		[88584] = {
			"81064:79407:76782", -- [1]
			"81064:79407:76781", -- [2]
			"81064:76787:76783", -- [3]
			"81064:76787", -- [4]
			"81064:79407:76879", -- [5]
			"81354:81057:76784", -- [6]
			"81064:79407:78699", -- [7]
			"81064:79407", -- [8]
			"81354:80932", -- [9]
			"81354:81057:81053", -- [10]
			"81354:81057:84495:81055", -- [11]
			"81354:81058", -- [12]
			"81078:81068", -- [13]
			"81064:82346:83924", -- [14]
			"81064:82346:82844", -- [15]
			"81064:82346", -- [16]
			"81064:82346:82340", -- [17]
			"84515:84498", -- [18]
			"81354:81057:84508", -- [19]
			"84515:84509", -- [20]
			"81354:81057:84495", -- [21]
			"81354:81057:84495:81055:86492", -- [22]
			"81354:81057:84495:81055:84700", -- [23]
			"81285:83427", -- [24]
			"81354:81057:84495:85829", -- [25]
			"81354:81057:76784:87707", -- [26]
			"81354:81057:84495:81055:84714", -- [27]
			"81064:82346:82340:87395", -- [28]
			"82612:88653", -- [29]
			"81064:82346:82844:88668", -- [30]
			"81354:81057:84495:81055:84714:88757", -- [31]
			"76850:90562:90550", -- [32]
			"81354:80932:90560", -- [33]
			"81354:81057:90552", -- [34]
			"76850:90562", -- [35]
			"81354:80932:92809:92808", -- [36]
			"81354:80932:92809", -- [37]
			--["name"] = "Akeeta's Hovel, Shadowmoon Valley",
			["m"] = 542,
			["coord"] = 2820484300,
			["direct"] = "76850:86049:81057:81064:81078:81354:81285:82612:84504:82511:84515",
			["f"] = 0,
		},
		[92809] = {
			"90562:76850", -- [1]
			"90552:81053:79407:76782", -- [2]
			"90560:84508:84495:76784:76879:76781", -- [3]
			"90560:84508:84495:76784:76787:76783", -- [4]
			"90560:84508:84495:76784:76787", -- [5]
			"90560:84508:84495:76784:76879", -- [6]
			"90560:84508:84495:76784", -- [7]
			"90560:84508:84495:76784:87707:78699", -- [8]
			"92808:90550:86049", -- [9]
			"90552:81053:79407", -- [10]
			"90552:81053", -- [11]
			"90560:84508:81055", -- [12]
			"80932:81057", -- [13]
			"80932:81057:81058", -- [14]
			"80932:81057:81058:81064", -- [15]
			"80932:81354:81078:81068", -- [16]
			"80932:81354:81078", -- [17]
			"80932:81354", -- [18]
			"90562:76850:81285", -- [19]
			"80932:81354:84515:84498:82612", -- [20]
			"90552:81053:82346:83924", -- [21]
			"90552:81053:82346:82844", -- [22]
			"90552:81053:82346", -- [23]
			"90552:81053:82346:82340", -- [24]
			"80932:81354:84515:84498", -- [25]
			"80932:81354:84515:84504", -- [26]
			"80932:81354:84515:82511", -- [27]
			"90560:84508", -- [28]
			"80932:81354:81078:84509", -- [29]
			"90560:84508:84495", -- [30]
			"80932:81354:84515", -- [31]
			"90560:84508:81055:86492", -- [32]
			"92808:84714:84700", -- [33]
			"90562:76850:83427", -- [34]
			"90560:84508:81055:85829", -- [35]
			"90560:84508:84495:76784:87707", -- [36]
			"92808:84714", -- [37]
			"80932:81354:88584", -- [38]
			"90552:81053:82346:82340:87395", -- [39]
			"90552:81053:82346:83924:88653", -- [40]
			"90552:81053:82346:82844:88668", -- [41]
			"92808:84714:88757", -- [42]
			"92808:90550", -- [43]
			--["name"] = "Sha'naari Refuge, Tanaan Jungle",
			["m"] = 534,
			["f"] = 0,
			["direct"] = "80932:90560:90552:90562:92808",
			["coord"] = 1268425030,
		},
		[87395] = {
			"88668:82844:83924:81064:81078:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"76787:76783", -- [4]
			"79407:76879", -- [5]
			"79407:76784", -- [6]
			"79407:78699", -- [7]
			"79407:86049", -- [8]
			"88668:82844:82346:81057:80932", -- [9]
			"88668:82844:82346:81053", -- [10]
			"79407:81055", -- [11]
			"88668:82844:82346:81057", -- [12]
			"88668:82844:82346:81058", -- [13]
			"88668:82844:83924:81064", -- [14]
			"88668:82844:83924:81068", -- [15]
			"88668:82844:83924:81064:81078", -- [16]
			"88668:82844:83924:81064:81354", -- [17]
			"88653:82612:81285", -- [18]
			"88653:82612", -- [19]
			"88668:82844:83924", -- [20]
			"88668:82844", -- [21]
			"88668:82844:82346", -- [22]
			"88668:82844:83924:81068:84509:84498", -- [23]
			"88668:82844:83924:81068:84509:84515:84504", -- [24]
			"88668:82844:83924:81068:84509:84498:82511", -- [25]
			"88668:82844:82346:81053:84508", -- [26]
			"88668:82844:83924:81068:84509", -- [27]
			"88668:82844:82346:81053:84495", -- [28]
			"88668:82844:83924:81068:84509:84515", -- [29]
			"79407:76784:86492", -- [30]
			"79407:76784:85829:84700", -- [31]
			"88653:82612:81285:83427", -- [32]
			"79407:76784:85829", -- [33]
			"79407:87707", -- [34]
			"79407:76784:86492:84714", -- [35]
			"88668:82844:83924:81064:88584", -- [36]
			"79407:76784:86492:84714:88757", -- [37]
			"88668:82844:82346:81053:90552:90550", -- [38]
			"88668:82844:82346:81053:90552:90560", -- [39]
			"88668:82844:82346:81053:90552", -- [40]
			"88668:82844:82346:81053:90552:90562", -- [41]
			"88668:82844:82346:81053:90552:92809:92808", -- [42]
			"88668:82844:82346:81053:90552:92809", -- [43]
			--["name"] = "Rilzit's Holdfast, Nagrand",
			["m"] = 550,
			["f"] = 0,
			["direct"] = "76787:79407:82340:88653:88668",
			["coord"] = 2178240153,
		},
		[84509] = {
			"84515:84504:76850", -- [1]
			"81078:81064:79407:76782", -- [2]
			"81078:81064:79407:76781", -- [3]
			"81078:81064:76787:76783", -- [4]
			"81078:81064:76787", -- [5]
			"81078:81064:79407:76879", -- [6]
			"81078:81064:76784", -- [7]
			"81078:81064:79407:78699", -- [8]
			"84515:88584:86049", -- [9]
			"81078:81354:80932", -- [10]
			"81078:81058:81053", -- [11]
			"81078:81354:81057:84495:81055", -- [12]
			"81078:81354:81057", -- [13]
			"81078:81058", -- [14]
			"81078:81354", -- [15]
			"84515:84504:81285", -- [16]
			"81068:83924", -- [17]
			"81068:83924:82844", -- [18]
			"81078:81064:82346", -- [19]
			"81078:81064:82346:82340", -- [20]
			"84515:84504", -- [21]
			"84498:82511", -- [22]
			"81078:81354:81057:84508", -- [23]
			"81078:81354:81057:84495", -- [24]
			"81078:81064:76784:86492", -- [25]
			"81078:81064:76784:85829:84700", -- [26]
			"84515:84504:81285:83427", -- [27]
			"81078:81064:76784:85829", -- [28]
			"81078:81064:76784:87707", -- [29]
			"81078:81064:76784:86492:84714", -- [30]
			"84515:88584", -- [31]
			"81078:81064:82346:82340:87395", -- [32]
			"82612:88653", -- [33]
			"81068:83924:82844:88668", -- [34]
			"81078:81064:76784:86492:84714:88757", -- [35]
			"81078:81354:80932:90562:90550", -- [36]
			"81078:81354:80932:90560", -- [37]
			"81078:81354:81057:90552", -- [38]
			"81078:81354:80932:90562", -- [39]
			"81078:81354:80932:92809:92808", -- [40]
			"81078:81354:80932:92809", -- [41]
			--["name"] = "Apexis Excavation, Spires of Arak",
			["m"] = 542,
			["coord"] = 1586446107,
			["direct"] = "79407:81064:81068:81078:82612:84498:84515",
			["f"] = 0,
		},
		[76787] = {
			"76784:81057:81354:76850", -- [1]
			"76781:76782", -- [2]
			"78699:76879", -- [3]
			"85829:86049", -- [4]
			"76784:81057:80932", -- [5]
			"78699:79407:81053", -- [6]
			"76784:81055", -- [7]
			"76784:81057", -- [8]
			"78699:79407:81053:81058", -- [9]
			"78699:79407:81064:81068", -- [10]
			"78699:79407:81064:81078", -- [11]
			"76784:81057:81354", -- [12]
			"78699:79407:81064:88584:81285", -- [13]
			"78699:79407:82612", -- [14]
			"78699:79407:82346:83924", -- [15]
			"78699:79407:82346", -- [16]
			"87395:82340", -- [17]
			"78699:79407:81064:81078:84509:84498", -- [18]
			"78699:79407:81064:81078:84509:84515:84504", -- [19]
			"78699:79407:82511", -- [20]
			"76784:81055:84508", -- [21]
			"78699:79407:81064:81078:84509", -- [22]
			"76784:84495", -- [23]
			"78699:79407:81064:81078:84509:84515", -- [24]
			"85829:86492", -- [25]
			"85829:84700", -- [26]
			"76784:81057:83427", -- [27]
			"78699:87707", -- [28]
			"85829:84714", -- [29]
			"78699:79407:81064:88584", -- [30]
			"87395:88653", -- [31]
			"78699:79407:88668", -- [32]
			"85829:84714:88757", -- [33]
			"78699:79407:81053:90552:90550", -- [34]
			"76784:81055:84508:90560", -- [35]
			"78699:79407:81053:90552", -- [36]
			"78699:79407:81053:90552:90562", -- [37]
			"85829:84714:92808", -- [38]
			"78699:79407:81053:90552:92809", -- [39]
			--["name"] = "Bloodmaul Slag Mines, Frostfire Ridge",
			["m"] = 525,
			["coord"] = 2211067641,
			["direct"] = "76781:76783:76784:78699:79407:81064:82844:85829:87395",
			["f"] = 0,
		},
		[80932] = {
			"81354:76850", -- [1]
			"81057:79407:76782", -- [2]
			"81057:79407:76781", -- [3]
			"90552:84508:84495:76784:76787:76783", -- [4]
			"90552:84508:84495:76784:76787", -- [5]
			"81057:79407:76879", -- [6]
			"90552:84508:84495:76784", -- [7]
			"90552:84508:84495:76784:87707:78699", -- [8]
			"90562:90550:86049", -- [9]
			"81057:79407", -- [10]
			"81057:81053", -- [11]
			"90552:84508:81055", -- [12]
			"81057:81058", -- [13]
			"81057:81058:81064", -- [14]
			"81354:81078:81068", -- [15]
			"81354:81078", -- [16]
			"81354:88584:81285", -- [17]
			"81354:84515:84498:82612", -- [18]
			"81057:82346:83924", -- [19]
			"81057:82346:82844", -- [20]
			"81057:82346", -- [21]
			"81057:82346:82340", -- [22]
			"81354:84515:84498", -- [23]
			"81354:84515:84504", -- [24]
			"81354:84515:82511", -- [25]
			"90552:84508", -- [26]
			"81354:81078:84509", -- [27]
			"90552:84508:84495", -- [28]
			"81354:84515", -- [29]
			"90552:84508:81055:86492", -- [30]
			"90552:84508:81055:84700", -- [31]
			"81057:83427", -- [32]
			"90552:84508:81055:85829", -- [33]
			"90552:84508:84495:76784:87707", -- [34]
			"92809:92808:84714", -- [35]
			"81354:88584", -- [36]
			"81057:82346:82340:87395", -- [37]
			"81057:82346:83924:88653", -- [38]
			"81057:82346:82844:88668", -- [39]
			"92809:92808:84714:88757", -- [40]
			"90562:90550", -- [41]
			"92809:92808", -- [42]
			--["name"] = "Zangarra, Talador",
			["m"] = 535,
			["f"] = 0,
			["direct"] = "81057:81354:90560:90552:90562:92809",
			["coord"] = 3452649745,
		},
		[84714] = {
			"92808:90562:76850", -- [1]
			"86492:76784:79407:76782", -- [2]
			"85829:76787:76781", -- [3]
			"85829:76787:76783", -- [4]
			"85829:76787", -- [5]
			"86492:76784:76879", -- [6]
			"86492:76784", -- [7]
			"86492:76784:87707:78699", -- [8]
			"86492:76784:79407", -- [9]
			"92808:92809:80932", -- [10]
			"81055:84508:81053", -- [11]
			"81055:81057", -- [12]
			"81055:84508:81053:81058", -- [13]
			"86492:76784:81064", -- [14]
			"86492:76784:81064:81068", -- [15]
			"86492:76784:81064:81078", -- [16]
			"81055:81057:81354", -- [17]
			"92808:90562:76850:81285", -- [18]
			"81055:81057:82612", -- [19]
			"81055:84508:81053:82346:83924", -- [20]
			"86492:76784:79407:82844", -- [21]
			"81055:84508:81053:82346", -- [22]
			"86492:76784:79407:82844:82340", -- [23]
			"81055:81057:81354:84515:84498", -- [24]
			"81055:81057:81354:84515:84504", -- [25]
			"81055:81057:81354:84515:82511", -- [26]
			"81055:84508", -- [27]
			"86492:76784:81064:81078:84509", -- [28]
			"81055:84495", -- [29]
			"81055:81057:81354:84515", -- [30]
			"92808:90562:76850:83427", -- [31]
			"86492:76784:87707", -- [32]
			"81055:81057:81354:88584", -- [33]
			"86492:76784:79407:87395", -- [34]
			"81055:84508:81053:82346:83924:88653", -- [35]
			"86492:76784:79407:88668", -- [36]
			"92808:90550", -- [37]
			"92808:90560", -- [38]
			"81055:84508:90552", -- [39]
			"92808:90562", -- [40]
			"92808:92809", -- [41]
			--["name"] = "Everbloom Wilds, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "86049:81055:86492:84700:85829:88757:92808",
			["coord"] = 2448848193,
		},
		[81064] = {
			"81078:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"76787:76783", -- [4]
			"79407:76879", -- [5]
			"79407:78699", -- [6]
			"81057:80932", -- [7]
			"81058:81053", -- [8]
			"81058:81053:84495:81055", -- [9]
			"88584:81285", -- [10]
			"82346:82844", -- [11]
			"82346:82340", -- [12]
			"81078:84509:84498", -- [13]
			"81078:84509:84515:84504", -- [14]
			"81078:84509:84498:82511", -- [15]
			"81058:81053:84508", -- [16]
			"81058:81053:84495", -- [17]
			"81078:84509:84515", -- [18]
			"76784:86492", -- [19]
			"76784:85829:84700", -- [20]
			"88584:81285:83427", -- [21]
			"76784:85829", -- [22]
			"76784:87707", -- [23]
			"76784:86492:84714", -- [24]
			"82346:82340:87395", -- [25]
			"82346:83924:88653", -- [26]
			"82346:82844:88668", -- [27]
			"76784:86492:84714:88757", -- [28]
			"81057:90552:90550", -- [29]
			"81057:90552:90560", -- [30]
			"81057:90552", -- [31]
			"81057:80932:90562", -- [32]
			"81057:80932:92809:92808", -- [33]
			"81057:80932:92809", -- [34]
			--["name"] = "Shattrath City, Talador",
			["m"] = 535,
			["coord"] = 2201709926,
			["direct"] = "76787:76784:86049:79407:81057:81058:81068:81078:81354:82612:83924:82346:84509:88584",
			["f"] = 0,
		},
		[81068] = {
			"81078:76850", -- [1]
			"83924:82844:79407:76782", -- [2]
			"83924:82844:79407:76781", -- [3]
			"81078:81064:76787:76783", -- [4]
			"81078:81064:76787", -- [5]
			"83924:82844:79407:76879", -- [6]
			"81078:81064:76784", -- [7]
			"83924:82844:79407:78699", -- [8]
			"81078:81354:80932:90562:90550:86049", -- [9]
			"83924:82844:79407", -- [10]
			"81078:81354:80932", -- [11]
			"81078:81058:81053", -- [12]
			"81078:81354:81057:84495:81055", -- [13]
			"81078:81354:81057", -- [14]
			"81078:81058", -- [15]
			"81078:81354", -- [16]
			"84509:84515:84504:81285", -- [17]
			"84509:82612", -- [18]
			"83924:82844", -- [19]
			"83924:82346", -- [20]
			"83924:82340", -- [21]
			"84509:84498", -- [22]
			"84509:84515:84504", -- [23]
			"84509:84498:82511", -- [24]
			"81078:81354:81057:84508", -- [25]
			"81078:81354:81057:84495", -- [26]
			"84509:84515", -- [27]
			"81078:81064:76784:86492", -- [28]
			"81078:81064:76784:85829:84700", -- [29]
			"84509:84515:84504:81285:83427", -- [30]
			"81078:81064:76784:85829", -- [31]
			"81078:81064:76784:87707", -- [32]
			"81078:81064:76784:86492:84714", -- [33]
			"81078:88584", -- [34]
			"83924:82340:87395", -- [35]
			"83924:88653", -- [36]
			"83924:82844:88668", -- [37]
			"81078:81064:76784:86492:84714:88757", -- [38]
			"81078:81354:80932:90562:90550", -- [39]
			"81078:81354:80932:90560", -- [40]
			"81078:81354:81057:90552", -- [41]
			"81078:81354:80932:90562", -- [42]
			"81078:81354:80932:92809:92808", -- [43]
			"81078:81354:80932:92809", -- [44]
			--["name"] = "Retribution Point, Talador",
			["m"] = 535,
			["coord"] = 1810089110,
			["direct"] = "81064:81078:83924:84509",
			["f"] = 0,
		},
		[86049] = {
			"79407:76782", -- [1]
			"79407:76781", -- [2]
			"85829:76787:76783", -- [3]
			"85829:76787", -- [4]
			"79407:76879", -- [5]
			"81055:76784", -- [6]
			"81055:76784:87707:78699", -- [7]
			"90550:90562:80932", -- [8]
			"84508:81053", -- [9]
			"84508:81053:81058", -- [10]
			"81064:81068", -- [11]
			"81064:81078", -- [12]
			"90550:90562:80932:81354", -- [13]
			"88584:82612", -- [14]
			"84508:81053:82346:83924", -- [15]
			"84508:81053:82346:82844", -- [16]
			"84508:81053:82346", -- [17]
			"84508:81053:82346:82340", -- [18]
			"88584:84515:84498", -- [19]
			"88584:84504", -- [20]
			"88584:82511", -- [21]
			"88584:84515:84509", -- [22]
			"88584:84515", -- [23]
			"84714:86492", -- [24]
			"84714:84700", -- [25]
			"81055:76784:87707", -- [26]
			"79407:87395", -- [27]
			"84508:81053:82346:83924:88653", -- [28]
			"84508:81053:82346:82844:88668", -- [29]
			"84714:88757", -- [30]
			"90550:90560", -- [31]
			"90550:90552", -- [32]
			"90550:90562", -- [33]
			"90550:92808", -- [34]
			"90550:92808:92809", -- [35]
			--["name"] = "Warspear, Ashran",
			["m"] = 624,
			["f"] = 0,
			["direct"] = "76850:79407:81055:81057:81064:81285:84508:84495:83427:85829:84714:88584:90550",
			["coord"] = 1893095686,
		},
		[82612] = {
			"88584:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"79407:78699:76783", -- [4]
			"81064:76787", -- [5]
			"79407:76879", -- [6]
			"81064:76784", -- [7]
			"79407:78699", -- [8]
			"88584:86049", -- [9]
			"84515:81354:80932", -- [10]
			"81057:81053", -- [11]
			"81057:84495:81055", -- [12]
			"81064:81058", -- [13]
			"84509:81068", -- [14]
			"84509:81078", -- [15]
			"84515:81354", -- [16]
			"82346:83924", -- [17]
			"82346:82844", -- [18]
			"84498:84504", -- [19]
			"84498:82511", -- [20]
			"81057:84508", -- [21]
			"81057:84495", -- [22]
			"81064:76784:86492", -- [23]
			"81064:76784:85829:84700", -- [24]
			"81285:83427", -- [25]
			"81064:76784:85829", -- [26]
			"81064:76784:87707", -- [27]
			"81064:76784:86492:84714", -- [28]
			"88653:82340:87395", -- [29]
			"88653:88668", -- [30]
			"81064:76784:86492:84714:88757", -- [31]
			"88584:76850:90562:90550", -- [32]
			"84515:81354:80932:90560", -- [33]
			"81057:90552", -- [34]
			"88584:76850:90562", -- [35]
			"84515:81354:80932:92809:92808", -- [36]
			"84515:81354:80932:92809", -- [37]
			--["name"] = "Axefall, Spires of Arak",
			["m"] = 542,
			["coord"] = 1694068478,
			["direct"] = "79407:81057:81064:81285:82346:82340:84498:84509:84515:88584:88653",
			["f"] = 0,
		},
		[82844] = {
			"83924:81064:81078:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"79407:78699:76783", -- [4]
			"79407:76879", -- [5]
			"79407:76784", -- [6]
			"79407:78699", -- [7]
			"79407:86049", -- [8]
			"82346:81057:80932", -- [9]
			"82346:81053", -- [10]
			"79407:81055", -- [11]
			"82346:81057", -- [12]
			"82346:81058", -- [13]
			"83924:81064", -- [14]
			"83924:81068", -- [15]
			"83924:81064:81078", -- [16]
			"83924:81064:81354", -- [17]
			"83924:81068:84509:84515:84504:81285", -- [18]
			"83924:81068:84509:82612", -- [19]
			"83924:81068:84509:84498", -- [20]
			"83924:81068:84509:84515:84504", -- [21]
			"83924:81068:84509:84498:82511", -- [22]
			"82346:81053:84508", -- [23]
			"83924:81068:84509", -- [24]
			"82346:81053:84495", -- [25]
			"83924:81068:84509:84515", -- [26]
			"79407:76784:86492", -- [27]
			"79407:76784:85829:84700", -- [28]
			"83924:81068:84509:84515:84504:81285:83427", -- [29]
			"79407:76784:85829", -- [30]
			"79407:87707", -- [31]
			"79407:76784:86492:84714", -- [32]
			"83924:81064:88584", -- [33]
			"88668:87395", -- [34]
			"88668:88653", -- [35]
			"79407:76784:86492:84714:88757", -- [36]
			"82346:81053:90552:90550", -- [37]
			"82346:81053:90552:90560", -- [38]
			"82346:81053:90552", -- [39]
			"82346:81053:90552:90562", -- [40]
			"82346:81053:90552:92809:92808", -- [41]
			"82346:81053:90552:92809", -- [42]
			--["name"] = "Throne of the Elements, Nagrand",
			["m"] = 550,
			["f"] = 0,
			["direct"] = "76787:79407:83924:82346:82340:88668",
			["coord"] = 3163571228,
		},
		[78699] = {
			"79407:81057:81354:76850", -- [1]
			"76879:76782", -- [2]
			"76879:76781", -- [3]
			"87707:76784", -- [4]
			"79407:86049", -- [5]
			"79407:81057:80932", -- [6]
			"79407:81053", -- [7]
			"87707:76784:81055", -- [8]
			"79407:81057", -- [9]
			"79407:81053:81058", -- [10]
			"79407:81064", -- [11]
			"79407:81064:81068", -- [12]
			"79407:81064:81078", -- [13]
			"79407:81057:81354", -- [14]
			"79407:81064:88584:81285", -- [15]
			"79407:82612", -- [16]
			"79407:82346:83924", -- [17]
			"79407:82844", -- [18]
			"79407:82346", -- [19]
			"79407:82844:82340", -- [20]
			"79407:81064:81078:84509:84498", -- [21]
			"79407:81064:81078:84509:84515:84504", -- [22]
			"79407:82511", -- [23]
			"79407:81053:84508", -- [24]
			"79407:81064:81078:84509", -- [25]
			"87707:76784:84495", -- [26]
			"79407:81064:81078:84509:84515", -- [27]
			"87707:76784:86492", -- [28]
			"76787:85829:84700", -- [29]
			"79407:81057:83427", -- [30]
			"76787:85829", -- [31]
			"87707:76784:86492:84714", -- [32]
			"79407:81064:88584", -- [33]
			"79407:87395", -- [34]
			"79407:88668:88653", -- [35]
			"79407:88668", -- [36]
			"87707:76784:86492:84714:88757", -- [37]
			"79407:81053:90552:90550", -- [38]
			"79407:81053:90552:90560", -- [39]
			"79407:81053:90552", -- [40]
			"79407:81053:90552:90562", -- [41]
			"79407:81053:90552:92809:92808", -- [42]
			"79407:81053:90552:92809", -- [43]
			--["name"] = "Darkspear's Edge, Frostfire Ridge",
			["m"] = 525,
			["coord"] = 2222156076,
			["direct"] = "76783:76787:76879:79407:87707",
			["f"] = 0,
		},
		[79407] = {
			"81057:81354:76850", -- [1]
			"78699:76783", -- [2]
			"81057:80932", -- [3]
			"81053:81058", -- [4]
			"81064:81068", -- [5]
			"81064:81078", -- [6]
			"81057:81354", -- [7]
			"81064:88584:81285", -- [8]
			"82346:83924", -- [9]
			"81064:81078:84509:84498", -- [10]
			"81064:81078:84509:84515:84504", -- [11]
			"81053:84508", -- [12]
			"76784:84495", -- [13]
			"81064:81078:84509:84515", -- [14]
			"76784:86492", -- [15]
			"76784:85829:84700", -- [16]
			"81057:83427", -- [17]
			"76784:85829", -- [18]
			"76784:86492:84714", -- [19]
			"81064:88584", -- [20]
			"88668:88653", -- [21]
			"76784:86492:84714:88757", -- [22]
			"81053:90552:90550", -- [23]
			"81053:90552:90560", -- [24]
			"81053:90552", -- [25]
			"81053:90552:90562", -- [26]
			"81053:90552:92809:92808", -- [27]
			"81053:90552:92809", -- [28]
			["direct"] = "76782:76781:76787:76879:76784:78699:86049:81053:81055:81057:81064:82612:82844:82346:82340:82511:84509:87707:87395:88668",
			["m"] = 590,
			--["name"] = "Frostwall Garrison, Frostfire Ridge",
			["f"] = 0,
		},
		[87707] = {
			"76784:81057:81354:76850", -- [1]
			"79407:76782", -- [2]
			"78699:76879:76781", -- [3]
			"78699:76783", -- [4]
			"78699:76787", -- [5]
			"78699:76879", -- [6]
			"76784:81055:86049", -- [7]
			"76784:81057:80932", -- [8]
			"79407:81053", -- [9]
			"76784:81055", -- [10]
			"76784:81057", -- [11]
			"76784:81064:81058", -- [12]
			"76784:81064", -- [13]
			"76784:81064:81068", -- [14]
			"76784:81064:81078", -- [15]
			"76784:81057:81354", -- [16]
			"76784:81057:81285", -- [17]
			"76784:81057:82612", -- [18]
			"79407:82346:83924", -- [19]
			"79407:82844", -- [20]
			"79407:82346", -- [21]
			"79407:82844:82340", -- [22]
			"76784:81057:81354:84515:84498", -- [23]
			"76784:81057:81354:84515:84504", -- [24]
			"76784:81057:81354:84515:82511", -- [25]
			"76784:81055:84508", -- [26]
			"76784:81064:81078:84509", -- [27]
			"76784:84495", -- [28]
			"76784:81057:81354:84515", -- [29]
			"76784:86492", -- [30]
			"76784:85829:84700", -- [31]
			"76784:81057:83427", -- [32]
			"76784:85829", -- [33]
			"76784:86492:84714", -- [34]
			"76784:81057:81354:88584", -- [35]
			"79407:87395", -- [36]
			"79407:88668:88653", -- [37]
			"79407:88668", -- [38]
			"76784:86492:84714:88757", -- [39]
			"76784:81055:84508:90560:90550", -- [40]
			"76784:81055:84508:90560", -- [41]
			"76784:81055:84508:90552", -- [42]
			"76784:81055:84508:90552:90562", -- [43]
			"76784:81055:84508:90560:92808", -- [44]
			"76784:81055:84508:90552:92809", -- [45]
			--["name"] = "Wolf's Stand, Frostfire Ridge",
			["m"] = 525,
			["f"] = 0,
			["direct"] = "76784:78699:79407",
			["coord"] = 3162347895,
		},
		[84498] = {
			"84504:76850", -- [1]
			"82612:79407:76782", -- [2]
			"82612:79407:76781", -- [3]
			"82612:79407:78699:76783", -- [4]
			"84509:81078:81064:76787", -- [5]
			"82612:79407:76879", -- [6]
			"84509:81078:81064:76784", -- [7]
			"82612:79407:78699", -- [8]
			"84504:76850:86049", -- [9]
			"82612:79407", -- [10]
			"84504:88584:81354:80932", -- [11]
			"82612:81057:81053", -- [12]
			"82612:81057:84495:81055", -- [13]
			"82612:81057", -- [14]
			"84509:81078:81058", -- [15]
			"84509:81078:81064", -- [16]
			"84509:81068", -- [17]
			"84509:81078", -- [18]
			"84504:88584:81354", -- [19]
			"84504:81285", -- [20]
			"84509:81068:83924", -- [21]
			"82612:82346:82844", -- [22]
			"82612:82346", -- [23]
			"82612:88653:82340", -- [24]
			"82612:81057:84508", -- [25]
			"82612:81057:84495", -- [26]
			"84509:81078:81064:76784:86492", -- [27]
			"84509:81078:81064:76784:85829:84700", -- [28]
			"84504:81285:83427", -- [29]
			"84509:81078:81064:76784:85829", -- [30]
			"84509:81078:81064:76784:87707", -- [31]
			"84509:81078:81064:76784:86492:84714", -- [32]
			"84504:88584", -- [33]
			"82612:88653:82340:87395", -- [34]
			"82612:88653", -- [35]
			"82612:88653:88668", -- [36]
			"84509:81078:81064:76784:86492:84714:88757", -- [37]
			"84504:76850:90562:90550", -- [38]
			"84504:88584:81354:80932:90560", -- [39]
			"82612:81057:90552", -- [40]
			"84504:76850:90562", -- [41]
			"84504:76850:90562:92808", -- [42]
			"84504:88584:81354:80932:92809", -- [43]
			--["name"] = "Veil Terokk, Spires of Arak",
			["m"] = 542,
			["coord"] = 1985114355,
			["direct"] = "82612:84504:82511:84509:84515",
			["f"] = 0,
		},
		[76879] = {
			"79407:81057:81354:76850", -- [1]
			"78699:76783", -- [2]
			"78699:76787", -- [3]
			"79407:86049", -- [4]
			"79407:81057:80932", -- [5]
			"79407:81053", -- [6]
			"76784:81055", -- [7]
			"79407:81057", -- [8]
			"79407:81053:81058", -- [9]
			"79407:81064", -- [10]
			"79407:81064:81068", -- [11]
			"79407:81064:81078", -- [12]
			"79407:81057:81354", -- [13]
			"79407:81064:88584:81285", -- [14]
			"79407:82612", -- [15]
			"79407:82346:83924", -- [16]
			"79407:82844", -- [17]
			"79407:82346", -- [18]
			"79407:82844:82340", -- [19]
			"79407:81064:81078:84509:84498", -- [20]
			"79407:81064:81078:84509:84515:84504", -- [21]
			"79407:82511", -- [22]
			"79407:81053:84508", -- [23]
			"79407:81064:81078:84509", -- [24]
			"76784:84495", -- [25]
			"79407:81064:81078:84509:84515", -- [26]
			"76784:86492", -- [27]
			"78699:76787:85829:84700", -- [28]
			"79407:81057:83427", -- [29]
			"78699:76787:85829", -- [30]
			"78699:87707", -- [31]
			"76784:86492:84714", -- [32]
			"79407:81064:88584", -- [33]
			"79407:87395", -- [34]
			"79407:88668:88653", -- [35]
			"79407:88668", -- [36]
			"76784:86492:84714:88757", -- [37]
			"79407:81053:90552:90550", -- [38]
			"79407:81053:90552:90560", -- [39]
			"79407:81053:90552", -- [40]
			"79407:81053:90552:90562", -- [41]
			"79407:81053:90552:92809:92808", -- [42]
			"79407:81053:90552:92809", -- [43]
			--["name"] = "Stonefang Outpost, Frostfire Ridge",
			["m"] = 525,
			["coord"] = 1723630835,
			["direct"] = "76782:76781:76784:78699:79407",
			["f"] = 0,
		},
		[85829] = {
			"84714:92808:90562:76850", -- [1]
			"76787:76781:76782", -- [2]
			"76787:76781", -- [3]
			"76787:76783", -- [4]
			"76787:78699:76879", -- [5]
			"76787:78699", -- [6]
			"76784:79407", -- [7]
			"81055:84508:90552:80932", -- [8]
			"81055:84508:81053", -- [9]
			"76784:81057", -- [10]
			"76784:81064:81058", -- [11]
			"76784:81064", -- [12]
			"76784:81064:81068", -- [13]
			"76784:81064:81078", -- [14]
			"76784:81057:81354", -- [15]
			"76784:81057:81285", -- [16]
			"76784:81057:82612", -- [17]
			"76784:79407:82346:83924", -- [18]
			"76784:79407:82844", -- [19]
			"76784:79407:82346", -- [20]
			"76784:79407:82844:82340", -- [21]
			"76784:81057:81354:84515:84498", -- [22]
			"76784:81057:81354:84515:84504", -- [23]
			"76784:81057:81354:84515:82511", -- [24]
			"81055:84508", -- [25]
			"76784:81064:81078:84509", -- [26]
			"76784:81057:81354:84515", -- [27]
			"76784:81057:83427", -- [28]
			"76784:87707", -- [29]
			"76784:81057:81354:88584", -- [30]
			"76787:87395", -- [31]
			"76787:87395:88653", -- [32]
			"76784:79407:88668", -- [33]
			"84714:88757", -- [34]
			"84714:92808:90550", -- [35]
			"81055:84508:90560", -- [36]
			"81055:84508:90552", -- [37]
			"84714:92808:90562", -- [38]
			"84714:92808", -- [39]
			"81055:84508:90552:92809", -- [40]
			--["name"] = "Skysea Ridge, Gorgrond",
			["m"] = 543,
			["coord"] = 1700486562,
			["direct"] = "76787:76784:86049:81055:84495:86492:84700:84714",
			["f"] = 0,
		},
		[88668] = {
			"82844:83924:81064:81078:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"79407:78699:76783", -- [4]
			"79407:76787", -- [5]
			"79407:76879", -- [6]
			"79407:76784", -- [7]
			"79407:78699", -- [8]
			"79407:86049", -- [9]
			"82844:82346:81057:80932", -- [10]
			"82844:82346:81053", -- [11]
			"79407:81055", -- [12]
			"82844:82346:81057", -- [13]
			"82844:82346:81058", -- [14]
			"82844:83924:81064", -- [15]
			"82844:83924:81068", -- [16]
			"82844:83924:81064:81078", -- [17]
			"82844:83924:81064:81354", -- [18]
			"82844:83924:81068:84509:84515:84504:81285", -- [19]
			"82844:83924:81068:84509:82612", -- [20]
			"82844:82346", -- [21]
			"82844:83924:81068:84509:84498", -- [22]
			"82844:83924:81068:84509:84515:84504", -- [23]
			"82844:83924:81068:84509:84498:82511", -- [24]
			"82844:82346:81053:84508", -- [25]
			"82844:83924:81068:84509", -- [26]
			"82844:82346:81053:84495", -- [27]
			"82844:83924:81068:84509:84515", -- [28]
			"79407:76784:86492", -- [29]
			"79407:76784:85829:84700", -- [30]
			"82844:83924:81068:84509:84515:84504:81285:83427", -- [31]
			"79407:76784:85829", -- [32]
			"79407:87707", -- [33]
			"79407:76784:86492:84714", -- [34]
			"82844:83924:81064:88584", -- [35]
			"79407:76784:86492:84714:88757", -- [36]
			"82844:82346:81053:90552:90550", -- [37]
			"82844:82346:81053:90552:90560", -- [38]
			"82844:82346:81053:90552", -- [39]
			"82844:82346:81053:90552:90562", -- [40]
			"82844:82346:81053:90552:92809:92808", -- [41]
			"82844:82346:81053:90552:92809", -- [42]
			--["name"] = "Joz's Rylaks, Nagrand",
			["m"] = 550,
			["f"] = 0,
			["direct"] = "79407:83924:82844:82340:87395:88653",
			["coord"] = 2673169503,
		},
		[90562] = {
			"90552:81053:79407:76782", -- [1]
			"92809:90560:84508:84495:76784:76879:76781", -- [2]
			"92809:90560:84508:84495:76784:76787:76783", -- [3]
			"92809:90560:84508:84495:76784:76787", -- [4]
			"92809:90560:84508:84495:76784:76879", -- [5]
			"92809:90560:84508:84495:76784", -- [6]
			"92809:90560:84508:84495:76784:87707:78699", -- [7]
			"90550:86049", -- [8]
			"90552:81053:79407", -- [9]
			"90552:81053", -- [10]
			"92809:90560:84508:81055", -- [11]
			"80932:81057", -- [12]
			"80932:81057:81058", -- [13]
			"80932:81057:81058:81064", -- [14]
			"80932:81354:81078:81068", -- [15]
			"80932:81354:81078", -- [16]
			"80932:81354", -- [17]
			"76850:81285", -- [18]
			"76850:88584:82612", -- [19]
			"90552:81053:82346:83924", -- [20]
			"90552:81053:82346:82844", -- [21]
			"90552:81053:82346", -- [22]
			"90552:81053:82346:82340", -- [23]
			"76850:88584:84515:84498", -- [24]
			"76850:84504", -- [25]
			"76850:84504:82511", -- [26]
			"92809:90560:84508", -- [27]
			"80932:81354:81078:84509", -- [28]
			"92809:90560:84508:84495", -- [29]
			"76850:88584:84515", -- [30]
			"92809:90560:84508:81055:86492", -- [31]
			"92808:84714:84700", -- [32]
			"76850:83427", -- [33]
			"92808:84714:85829", -- [34]
			"92809:90560:84508:84495:76784:87707", -- [35]
			"92808:84714", -- [36]
			"76850:88584", -- [37]
			"90552:81053:82346:82340:87395", -- [38]
			"90552:81053:82346:83924:88653", -- [39]
			"90552:81053:82346:82844:88668", -- [40]
			"92808:84714:88757", -- [41]
			--["name"] = "Vault of the Earth, Tanaan Jungle",
			["m"] = 534,
			["f"] = 0,
			["direct"] = "76850:80932:90550:90560:90552:92808:92809",
			["coord"] = 2021438409,
		},
		[81053] = {
			"90552:90562:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"84495:76784:76787:76783", -- [4]
			"84495:76784:76787", -- [5]
			"79407:76879", -- [6]
			"84495:76784", -- [7]
			"79407:78699", -- [8]
			"90552:90550:86049", -- [9]
			"90552:80932", -- [10]
			"84495:81055", -- [11]
			"81058:81064", -- [12]
			"81058:81064:81068", -- [13]
			"81058:81078", -- [14]
			"81057:81354", -- [15]
			"81058:81064:88584:81285", -- [16]
			"81058:81078:84509:82612", -- [17]
			"82346:83924", -- [18]
			"82346:82844", -- [19]
			"82346:82340", -- [20]
			"81058:81078:84509:84498", -- [21]
			"81058:81078:84509:84515:84504", -- [22]
			"81058:81078:84509:84498:82511", -- [23]
			"81058:81078:84509", -- [24]
			"81058:81078:84509:84515", -- [25]
			"84495:81055:86492", -- [26]
			"84495:81055:84700", -- [27]
			"81057:83427", -- [28]
			"84495:85829", -- [29]
			"84495:76784:87707", -- [30]
			"84495:81055:84714", -- [31]
			"81058:81064:88584", -- [32]
			"82346:82340:87395", -- [33]
			"82346:83924:88653", -- [34]
			"82346:82844:88668", -- [35]
			"84495:81055:84714:88757", -- [36]
			"90552:90550", -- [37]
			"90552:90560", -- [38]
			"90552:90562", -- [39]
			"90552:92809:92808", -- [40]
			"90552:92809", -- [41]
			--["name"] = "Frostwolf Overlook, Talador",
			["m"] = 535,
			["f"] = 0,
			["direct"] = "79407:81057:81058:82346:84508:84495:90552",
			["coord"] = 2641042192,
		},
		[81057] = {
			"81354:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"76784:76787:76783", -- [4]
			"76784:76787", -- [5]
			"79407:76879", -- [6]
			"76784:87707:78699", -- [7]
			"81058:81064:81068", -- [8]
			"81058:81078", -- [9]
			"82346:83924", -- [10]
			"82346:82844", -- [11]
			"82346:82340", -- [12]
			"81354:84515:84498", -- [13]
			"81354:84515:84504", -- [14]
			"81354:84515:82511", -- [15]
			"81058:81078:84509", -- [16]
			"84495:81055:86492", -- [17]
			"84495:81055:84700", -- [18]
			"84495:85829", -- [19]
			"76784:87707", -- [20]
			"84495:81055:84714", -- [21]
			"82346:82340:87395", -- [22]
			"82346:83924:88653", -- [23]
			"82346:82844:88668", -- [24]
			"84495:81055:84714:88757", -- [25]
			"90552:90550", -- [26]
			"90552:90560", -- [27]
			"80932:90562", -- [28]
			"80932:92809:92808", -- [29]
			"80932:92809", -- [30]
			--["name"] = "Vol'jin's Pride, Talador",
			["direct"] = "76784:86049:79407:80932:81053:81055:81058:81064:81354:81285:82612:82346:84508:84495:84515:83427:88584:90552",
			["f"] = 0,
			["m"] = 535,
			["coord"] = 3040365391,
		},
		[76784] = {
			"81057:81354:76850", -- [1]
			"79407:76782", -- [2]
			"76879:76781", -- [3]
			"76787:76783", -- [4]
			"87707:78699", -- [5]
			"81055:86049", -- [6]
			"81057:80932", -- [7]
			"84495:81053", -- [8]
			"81064:81058", -- [9]
			"81064:81068", -- [10]
			"81064:81078", -- [11]
			"81057:81354", -- [12]
			"81057:81285", -- [13]
			"81057:82612", -- [14]
			"79407:82346:83924", -- [15]
			"79407:82844", -- [16]
			"79407:82346", -- [17]
			"79407:82844:82340", -- [18]
			"81057:81354:84515:84498", -- [19]
			"81057:81354:84515:84504", -- [20]
			"81057:81354:84515:82511", -- [21]
			"81055:84508", -- [22]
			"81064:81078:84509", -- [23]
			"81057:81354:84515", -- [24]
			"85829:84700", -- [25]
			"81057:83427", -- [26]
			"86492:84714", -- [27]
			"81057:81354:88584", -- [28]
			"79407:87395", -- [29]
			"79407:88668:88653", -- [30]
			"79407:88668", -- [31]
			"86492:84714:88757", -- [32]
			"81055:84508:90560:90550", -- [33]
			"81055:84508:90560", -- [34]
			"81055:84508:90552", -- [35]
			"81055:84508:90552:90562", -- [36]
			"81055:84508:90560:92808", -- [37]
			"81055:84508:90552:92809", -- [38]
			--["name"] = "Thunder Pass, Frostfire Ridge",
			["m"] = 525,
			["coord"] = 3590298597,
			["direct"] = "76787:76879:79407:81055:81057:81064:84495:86492:85829:87707",
			["f"] = 0,
		},
		[76781] = {
			"79407:81057:81354:76850", -- [1]
			"76879:76784", -- [2]
			"76879:78699", -- [3]
			"79407:86049", -- [4]
			"79407:81057:80932", -- [5]
			"79407:81053", -- [6]
			"79407:81055", -- [7]
			"79407:81057", -- [8]
			"79407:81053:81058", -- [9]
			"79407:81064", -- [10]
			"79407:81064:81068", -- [11]
			"79407:81064:81078", -- [12]
			"79407:81057:81354", -- [13]
			"79407:81064:88584:81285", -- [14]
			"79407:82612", -- [15]
			"79407:82346:83924", -- [16]
			"79407:82844", -- [17]
			"79407:82346", -- [18]
			"79407:82844:82340", -- [19]
			"79407:81064:81078:84509:84498", -- [20]
			"79407:81064:81078:84509:84515:84504", -- [21]
			"79407:82511", -- [22]
			"79407:81053:84508", -- [23]
			"79407:81064:81078:84509", -- [24]
			"76879:76784:84495", -- [25]
			"79407:81064:81078:84509:84515", -- [26]
			"76879:76784:86492", -- [27]
			"76787:85829:84700", -- [28]
			"79407:81057:83427", -- [29]
			"76787:85829", -- [30]
			"79407:87707", -- [31]
			"76879:76784:86492:84714", -- [32]
			"79407:81064:88584", -- [33]
			"79407:87395", -- [34]
			"79407:88668:88653", -- [35]
			"79407:88668", -- [36]
			"76879:76784:86492:84714:88757", -- [37]
			"79407:81053:90552:90550", -- [38]
			"79407:81053:90552:90560", -- [39]
			"79407:81053:90552", -- [40]
			"79407:81053:90552:90562", -- [41]
			"79407:81053:90552:92809:92808", -- [42]
			"79407:81053:90552:92809", -- [43]
			--["name"] = "Bladespire Citadel, Frostfire Ridge",
			["m"] = 526,
			["coord"] = 870286654,
			["direct"] = "76782:76783:76787:76879:79407",
			["f"] = 0,
		},
		[82340] = {
			"83924:81064:81078:76850", -- [1]
			"88668:79407:76782", -- [2]
			"88668:79407:76781", -- [3]
			"88668:79407:78699:76783", -- [4]
			"88668:79407:76787", -- [5]
			"88668:79407:76879", -- [6]
			"88668:79407:76784", -- [7]
			"88668:79407:78699", -- [8]
			"82346:81053:90552:90550:86049", -- [9]
			"82346:81057:80932", -- [10]
			"82346:81053", -- [11]
			"88668:79407:81055", -- [12]
			"82346:81057", -- [13]
			"82346:81058", -- [14]
			"83924:81064", -- [15]
			"83924:81068", -- [16]
			"83924:81064:81078", -- [17]
			"83924:81064:81354", -- [18]
			"88653:82612:81285", -- [19]
			"88653:82612:84498", -- [20]
			"83924:81068:84509:84515:84504", -- [21]
			"88653:82612:84498:82511", -- [22]
			"82346:81053:84508", -- [23]
			"83924:81068:84509", -- [24]
			"82346:81053:84495", -- [25]
			"83924:81068:84509:84515", -- [26]
			"88668:79407:76784:86492", -- [27]
			"88668:79407:76784:85829:84700", -- [28]
			"88653:82612:81285:83427", -- [29]
			"88668:79407:76784:85829", -- [30]
			"88668:79407:87707", -- [31]
			"88668:79407:76784:86492:84714", -- [32]
			"83924:81064:88584", -- [33]
			"88668:79407:76784:86492:84714:88757", -- [34]
			"82346:81053:90552:90550", -- [35]
			"82346:81053:90552:90560", -- [36]
			"82346:81053:90552", -- [37]
			"82346:81053:90552:90562", -- [38]
			"82346:81053:90552:92809:92808", -- [39]
			"82346:81053:90552:92809", -- [40]
			--["name"] = "Riverside Post, Nagrand",
			["m"] = 550,
			["f"] = 0,
			["direct"] = "79407:82612:83924:82844:82346:87395:88653:88668",
			["coord"] = 2125101864,
		},
		[90552] = {
			"90562:76850", -- [1]
			"81053:79407:76782", -- [2]
			"81053:79407:76781", -- [3]
			"84508:84495:76784:76787:76783", -- [4]
			"84508:84495:76784:76787", -- [5]
			"84508:84495:76784:76879", -- [6]
			"84508:84495:76784", -- [7]
			"84508:84495:76784:87707:78699", -- [8]
			"90550:86049", -- [9]
			"81053:79407", -- [10]
			"84508:81055", -- [11]
			"81053:81058", -- [12]
			"81053:81058:81064", -- [13]
			"81053:81058:81064:81068", -- [14]
			"81053:81058:81078", -- [15]
			"81057:81354", -- [16]
			"81057:81285", -- [17]
			"81057:82612", -- [18]
			"81053:82346:83924", -- [19]
			"81053:82346:82844", -- [20]
			"81053:82346", -- [21]
			"81053:82346:82340", -- [22]
			"81057:81354:84515:84498", -- [23]
			"81057:81354:84515:84504", -- [24]
			"81057:81354:84515:82511", -- [25]
			"81053:81058:81078:84509", -- [26]
			"84508:84495", -- [27]
			"81057:81354:84515", -- [28]
			"84508:81055:86492", -- [29]
			"84508:81055:84700", -- [30]
			"81057:83427", -- [31]
			"84508:81055:85829", -- [32]
			"84508:84495:76784:87707", -- [33]
			"84508:81055:84714", -- [34]
			"81057:81354:88584", -- [35]
			"81053:82346:82340:87395", -- [36]
			"81053:82346:83924:88653", -- [37]
			"81053:82346:82844:88668", -- [38]
			"84508:81055:84714:88757", -- [39]
			"92809:92808", -- [40]
			--["name"] = "The Iron Front, Tanaan Jungle",
			["m"] = 534,
			["f"] = 0,
			["direct"] = "80932:81053:81057:84508:90550:90560:90562:92809",
			["coord"] = 398823228,
		},
		[88653] = {
			"83924:81064:81078:76850", -- [1]
			"88668:79407:76782", -- [2]
			"88668:79407:76781", -- [3]
			"88668:79407:78699:76783", -- [4]
			"88668:79407:76787", -- [5]
			"88668:79407:76879", -- [6]
			"88668:79407:76784", -- [7]
			"88668:79407:78699", -- [8]
			"83924:82346:81053:90552:90550:86049", -- [9]
			"88668:79407", -- [10]
			"83924:82346:81057:80932", -- [11]
			"83924:82346:81053", -- [12]
			"83924:82346:81055", -- [13]
			"83924:82346:81057", -- [14]
			"83924:81064:81058", -- [15]
			"83924:81064", -- [16]
			"83924:81068", -- [17]
			"83924:81064:81078", -- [18]
			"83924:81064:81354", -- [19]
			"82612:81285", -- [20]
			"88668:82844", -- [21]
			"83924:82346", -- [22]
			"82612:84498", -- [23]
			"82612:84498:84504", -- [24]
			"82612:84498:82511", -- [25]
			"83924:82346:81053:84508", -- [26]
			"82612:84509", -- [27]
			"83924:82346:81053:84495", -- [28]
			"82612:84515", -- [29]
			"88668:79407:76784:86492", -- [30]
			"88668:79407:76784:85829:84700", -- [31]
			"82612:81285:83427", -- [32]
			"88668:79407:76784:85829", -- [33]
			"88668:79407:87707", -- [34]
			"88668:79407:76784:86492:84714", -- [35]
			"82612:88584", -- [36]
			"88668:79407:76784:86492:84714:88757", -- [37]
			"83924:82346:81053:90552:90550", -- [38]
			"83924:82346:81053:90552:90560", -- [39]
			"83924:82346:81053:90552", -- [40]
			"83924:82346:81053:90552:90562", -- [41]
			"83924:82346:81053:90552:92809:92808", -- [42]
			"83924:82346:81053:90552:92809", -- [43]
			--["name"] = "Nivek's Overlook, Nagrand",
			["m"] = 550,
			["f"] = 0,
			["direct"] = "82612:83924:82340:87395:88668",
			["coord"] = 2119811621,
		},
		[90550] = {
			"90562:76850", -- [1]
			"90560:84508:84495:76784:79407:76782", -- [2]
			"90560:84508:84495:76784:76879:76781", -- [3]
			"90560:84508:84495:76784:76787:76783", -- [4]
			"90560:84508:84495:76784:76787", -- [5]
			"90560:84508:84495:76784:76879", -- [6]
			"90560:84508:84495:76784", -- [7]
			"90560:84508:84495:76784:87707:78699", -- [8]
			"90560:84508:84495:76784:79407", -- [9]
			"90562:80932", -- [10]
			"90552:81053", -- [11]
			"90560:84508:81055", -- [12]
			"90552:81057", -- [13]
			"90552:81053:81058", -- [14]
			"90552:81053:81058:81064", -- [15]
			"90552:81053:81058:81064:81068", -- [16]
			"90562:80932:81354:81078", -- [17]
			"90562:80932:81354", -- [18]
			"90562:76850:81285", -- [19]
			"90562:76850:88584:82612", -- [20]
			"90552:81053:82346:83924", -- [21]
			"90552:81053:82346:82844", -- [22]
			"90552:81053:82346", -- [23]
			"90552:81053:82346:82340", -- [24]
			"90562:76850:88584:84515:84498", -- [25]
			"90562:76850:84504", -- [26]
			"90562:76850:84504:82511", -- [27]
			"90560:84508", -- [28]
			"90562:80932:81354:81078:84509", -- [29]
			"90560:84508:84495", -- [30]
			"90562:76850:88584:84515", -- [31]
			"90560:84508:81055:86492", -- [32]
			"92808:84714:84700", -- [33]
			"90562:76850:83427", -- [34]
			"92808:84714:85829", -- [35]
			"90560:84508:84495:76784:87707", -- [36]
			"92808:84714", -- [37]
			"90562:76850:88584", -- [38]
			"90552:81053:82346:82340:87395", -- [39]
			"90552:81053:82346:83924:88653", -- [40]
			"90552:81053:82346:82844:88668", -- [41]
			"92808:84714:88757", -- [42]
			"92808:92809", -- [43]
			--["name"] = "Vol'mar, Tanaan Jungle",
			["m"] = 534,
			["f"] = 0,
			["direct"] = "86049:90560:90552:90562:92808",
			["coord"] = 2596304611,
		},
		[81285] = {
			"88584:81064:79407:76782", -- [1]
			"88584:81064:79407:76781", -- [2]
			"88584:81064:76787:76783", -- [3]
			"88584:81064:76787", -- [4]
			"88584:81064:79407:76879", -- [5]
			"81057:76784", -- [6]
			"88584:81064:79407:78699", -- [7]
			"88584:81064:79407", -- [8]
			"88584:81354:80932", -- [9]
			"81057:81053", -- [10]
			"81057:84495:81055", -- [11]
			"88584:81354:81058", -- [12]
			"88584:81064", -- [13]
			"81078:81068", -- [14]
			"88584:81354", -- [15]
			"88584:81064:82346:83924", -- [16]
			"88584:81064:82346:82844", -- [17]
			"88584:81064:82346", -- [18]
			"88584:81064:82346:82340", -- [19]
			"84504:84498", -- [20]
			"84504:82511", -- [21]
			"81057:84508", -- [22]
			"82612:84509", -- [23]
			"81057:84495", -- [24]
			"84504:84515", -- [25]
			"81057:84495:81055:86492", -- [26]
			"81057:84495:81055:84700", -- [27]
			"81057:84495:85829", -- [28]
			"81057:76784:87707", -- [29]
			"76850:90562:92808:84714", -- [30]
			"88584:81064:82346:82340:87395", -- [31]
			"82612:88653", -- [32]
			"88584:81064:82346:82844:88668", -- [33]
			"76850:90562:92808:84714:88757", -- [34]
			"76850:90562:90550", -- [35]
			"88584:81354:80932:90560", -- [36]
			"81057:90552", -- [37]
			"76850:90562", -- [38]
			"76850:90562:92808", -- [39]
			"88584:81354:80932:92809", -- [40]
			--["name"] = "Socrethar's Rise, Shadowmoon Valley",
			["m"] = 539,
			["coord"] = 1884800591,
			["direct"] = "76850:86049:81057:81078:82612:84504:83427:88584",
			["f"] = 0,
		},
		[83924] = {
			"81064:81078:76850", -- [1]
			"82844:79407:76782", -- [2]
			"82844:79407:76781", -- [3]
			"82844:79407:78699:76783", -- [4]
			"82844:76787", -- [5]
			"82844:79407:76879", -- [6]
			"82844:79407:76784", -- [7]
			"82844:79407:78699", -- [8]
			"82346:81053:90552:90550:86049", -- [9]
			"82844:79407", -- [10]
			"82346:81057:80932", -- [11]
			"82346:81053", -- [12]
			"82346:81055", -- [13]
			"82346:81057", -- [14]
			"81064:81058", -- [15]
			"81064:81078", -- [16]
			"81064:81354", -- [17]
			"81068:84509:84515:84504:81285", -- [18]
			"81068:84509:82612", -- [19]
			"81068:84509:84498", -- [20]
			"81068:84509:84515:84504", -- [21]
			"81068:84509:84498:82511", -- [22]
			"82346:81053:84508", -- [23]
			"81068:84509", -- [24]
			"82346:81053:84495", -- [25]
			"81068:84509:84515", -- [26]
			"82346:81055:86492", -- [27]
			"82346:81055:84700", -- [28]
			"81068:84509:84515:84504:81285:83427", -- [29]
			"82844:79407:76784:85829", -- [30]
			"82844:79407:87707", -- [31]
			"82346:81055:84714", -- [32]
			"81064:88584", -- [33]
			"82340:87395", -- [34]
			"82844:88668", -- [35]
			"82346:81055:84714:88757", -- [36]
			"82346:81053:90552:90550", -- [37]
			"82346:81053:90552:90560", -- [38]
			"82346:81053:90552", -- [39]
			"82346:81053:90552:90562", -- [40]
			"82346:81053:90552:92809:92808", -- [41]
			"82346:81053:90552:92809", -- [42]
			--["name"] = "The Ring of Trials, Nagrand",
			["m"] = 550,
			["f"] = 0,
			["direct"] = "81064:81068:82844:82346:82340:88653",
			["coord"] = 3424812890,
		},
		[84495] = {
			"84508:90552:90562:76850", -- [1]
			"76784:79407:76782", -- [2]
			"76784:76879:76781", -- [3]
			"76784:76787:76783", -- [4]
			"76784:76787", -- [5]
			"76784:76879", -- [6]
			"76784:87707:78699", -- [7]
			"76784:79407", -- [8]
			"84508:90552:80932", -- [9]
			"81053:81058", -- [10]
			"81053:81058:81064", -- [11]
			"81053:81058:81064:81068", -- [12]
			"81053:81058:81078", -- [13]
			"81057:81354", -- [14]
			"81057:81285", -- [15]
			"81057:82612", -- [16]
			"81053:82346:83924", -- [17]
			"81053:82346:82844", -- [18]
			"81053:82346", -- [19]
			"81053:82346:82340", -- [20]
			"81057:81354:84515:84498", -- [21]
			"81057:81354:84515:84504", -- [22]
			"81057:81354:84515:82511", -- [23]
			"81053:81058:81078:84509", -- [24]
			"81057:81354:84515", -- [25]
			"81055:86492", -- [26]
			"81055:84700", -- [27]
			"81057:83427", -- [28]
			"76784:87707", -- [29]
			"81055:84714", -- [30]
			"81057:81354:88584", -- [31]
			"81053:82346:82340:87395", -- [32]
			"81053:82346:83924:88653", -- [33]
			"81053:82346:82844:88668", -- [34]
			"81055:84714:88757", -- [35]
			"84508:90560:90550", -- [36]
			"84508:90560", -- [37]
			"84508:90552", -- [38]
			"84508:90552:90562", -- [39]
			"84508:90560:92808", -- [40]
			"84508:90552:92809", -- [41]
			--["name"] = "Evermorn Springs, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "76784:86049:81053:81055:81057:84508:85829",
			["coord"] = 1774837558,
		},
		[83427] = {
			"81057:79407:76782", -- [1]
			"81057:79407:76781", -- [2]
			"81057:76784:76787:76783", -- [3]
			"81057:76784:76787", -- [4]
			"81057:79407:76879", -- [5]
			"81057:76784", -- [6]
			"81057:76784:87707:78699", -- [7]
			"81057:79407", -- [8]
			"81285:88584:81354:80932", -- [9]
			"81057:81053", -- [10]
			"81057:84495:81055", -- [11]
			"81285:88584:81354:81058", -- [12]
			"81285:88584:81064", -- [13]
			"81285:81078:81068", -- [14]
			"81285:81078", -- [15]
			"81285:88584:81354", -- [16]
			"81285:82612", -- [17]
			"81285:88584:81064:82346:83924", -- [18]
			"81285:88584:81064:82346:82844", -- [19]
			"81285:88584:81064:82346", -- [20]
			"81285:88584:81064:82346:82340", -- [21]
			"81285:84504:84498", -- [22]
			"81285:84504", -- [23]
			"81285:84504:82511", -- [24]
			"81057:84508", -- [25]
			"81285:82612:84509", -- [26]
			"81057:84495", -- [27]
			"81285:84504:84515", -- [28]
			"81057:84495:81055:86492", -- [29]
			"81057:84495:81055:84700", -- [30]
			"81057:84495:85829", -- [31]
			"81057:76784:87707", -- [32]
			"76850:90562:92808:84714", -- [33]
			"81285:88584", -- [34]
			"81285:88584:81064:82346:82340:87395", -- [35]
			"81285:82612:88653", -- [36]
			"81285:88584:81064:82346:82844:88668", -- [37]
			"76850:90562:92808:84714:88757", -- [38]
			"76850:90562:90550", -- [39]
			"76850:90562:92809:90560", -- [40]
			"81057:90552", -- [41]
			"76850:90562", -- [42]
			"76850:90562:92808", -- [43]
			"76850:90562:92809", -- [44]
			--["name"] = "Darktide Roost, Shadowmoon Valley",
			["m"] = 539,
			["coord"] = 2569326670,
			["direct"] = "76850:86049:81057:81285",
			["f"] = 0,
		},
		[84504] = {
			"88584:81064:79407:76782", -- [1]
			"88584:81064:79407:76781", -- [2]
			"88584:81064:76787:76783", -- [3]
			"88584:81064:76787", -- [4]
			"88584:81064:79407:76879", -- [5]
			"88584:81354:81057:76784", -- [6]
			"88584:81064:79407:78699", -- [7]
			"76850:86049", -- [8]
			"88584:81064:79407", -- [9]
			"88584:81354:80932", -- [10]
			"88584:81354:81057:81053", -- [11]
			"88584:81354:81057:84495:81055", -- [12]
			"88584:81354:81057", -- [13]
			"88584:81354:81058", -- [14]
			"88584:81064", -- [15]
			"84498:84509:81068", -- [16]
			"88584:81078", -- [17]
			"88584:81354", -- [18]
			"84498:82612", -- [19]
			"88584:81064:82346:83924", -- [20]
			"88584:81064:82346:82844", -- [21]
			"88584:81064:82346", -- [22]
			"88584:81064:82346:82340", -- [23]
			"88584:81354:81057:84508", -- [24]
			"84498:84509", -- [25]
			"88584:81354:81057:84495", -- [26]
			"88584:81354:81057:84495:81055:86492", -- [27]
			"88584:81354:81057:84495:81055:84700", -- [28]
			"81285:83427", -- [29]
			"88584:81354:81057:84495:85829", -- [30]
			"88584:81354:81057:76784:87707", -- [31]
			"88584:81354:81057:84495:81055:84714", -- [32]
			"88584:81064:82346:82340:87395", -- [33]
			"84498:82612:88653", -- [34]
			"88584:81064:82346:82844:88668", -- [35]
			"88584:81354:81057:84495:81055:84714:88757", -- [36]
			"76850:90562:90550", -- [37]
			"88584:81354:80932:90560", -- [38]
			"88584:81354:81057:90552", -- [39]
			"76850:90562", -- [40]
			"76850:90562:92808", -- [41]
			"88584:81354:80932:92809", -- [42]
			--["name"] = "Talon Watch, Spires of Arak",
			["m"] = 542,
			["coord"] = 2659347716,
			["direct"] = "76850:81285:84498:82511:84515:88584",
			["f"] = 0,
		},
		[88757] = {
			"84714:92808:90562:76850", -- [1]
			"84714:86492:76784:79407:76782", -- [2]
			"84714:85829:76787:76781", -- [3]
			"84714:85829:76787:76783", -- [4]
			"84714:85829:76787", -- [5]
			"84714:86492:76784:76879", -- [6]
			"84714:86492:76784", -- [7]
			"84714:86492:76784:87707:78699", -- [8]
			"84714:86049", -- [9]
			"84714:86492:76784:79407", -- [10]
			"84714:92808:92809:80932", -- [11]
			"84714:81055:84508:81053", -- [12]
			"84714:81055", -- [13]
			"84714:81055:81057", -- [14]
			"84714:81055:84508:81053:81058", -- [15]
			"84714:86492:76784:81064", -- [16]
			"84714:86492:76784:81064:81068", -- [17]
			"84714:86492:76784:81064:81078", -- [18]
			"84714:81055:81057:81354", -- [19]
			"84714:92808:90562:76850:81285", -- [20]
			"84714:81055:81057:82612", -- [21]
			"84714:81055:84508:81053:82346:83924", -- [22]
			"84714:86492:76784:79407:82844", -- [23]
			"84714:81055:84508:81053:82346", -- [24]
			"84714:86492:76784:79407:82844:82340", -- [25]
			"84714:81055:81057:81354:84515:84498", -- [26]
			"84714:81055:81057:81354:84515:84504", -- [27]
			"84714:81055:81057:81354:84515:82511", -- [28]
			"84714:81055:84508", -- [29]
			"84714:86492:76784:81064:81078:84509", -- [30]
			"84714:81055:84495", -- [31]
			"84714:81055:81057:81354:84515", -- [32]
			"84714:86492", -- [33]
			"84714:84700", -- [34]
			"84714:92808:90562:76850:83427", -- [35]
			"84714:85829", -- [36]
			"84714:86492:76784:87707", -- [37]
			"84714:81055:81057:81354:88584", -- [38]
			"84714:86492:76784:79407:87395", -- [39]
			"84714:81055:84508:81053:82346:83924:88653", -- [40]
			"84714:86492:76784:79407:88668", -- [41]
			"84714:92808:90550", -- [42]
			"84714:92808:90560", -- [43]
			"84714:81055:84508:90552", -- [44]
			"84714:92808:90562", -- [45]
			"84714:92808", -- [46]
			"84714:92808:92809", -- [47]
			--["name"] = "Everbloom Overlook, Gorgrond",
			["m"] = 543,
			["coord"] = 2952612266,
			["direct"] = "84714",
			["f"] = 0,
		},
},
	[8] = {
		[108888] = {
			"88110:90556", -- [1]
			"110971:90639", -- [2]
			"88110:90556:93447", -- [3]
			"88110:90556:93447:93940", -- [4]
			"112866:111624:114666:100550:95688", -- [5]
			"112866:111624:111675:114718:92560", -- [6]
			"112866:111624:111675:114718:111420:98105", -- [7]
			"112866:111624:111675:98966:98124", -- [8]
			"112866:111624:111675:114718:92560:98161", -- [9]
			"112866:111624:114666:100550:94973:97860", -- [10]
			"112866:111624:114666:100550:94973:97868", -- [11]
			"112866:111624:114666:100550:97870", -- [12]
			"112866:111624:114666:100550:94973:97868:98066", -- [13]
			"112866:111624:114666:96565", -- [14]
			"112866:111624:111675:98966", -- [15]
			"112866:111624:114666:100550:94973:97860:98972", -- [16]
			"112866:111624:114666:100468", -- [17]
			"88110:90556:93447:100459", -- [18]
			"112866:111624:114666:100550:94973", -- [19]
			"112866:96813", -- [20]
			"112866:111624:114666:100550", -- [21]
			"112866:111624:111675:98966:100559", -- [22]
			"112866:111624:111675:114718:92560:98161:111314", -- [23]
			"112866:96813:111323", -- [24]
			"112866:111624:111675:98966:111327", -- [25]
			"112866:111624:111675", -- [26]
			"112866:111624", -- [27]
			"112866:111624:111675:114718:111420", -- [28]
			"111418:112926", -- [29]
			"112866:111624:111675:114718", -- [30]
			"112866:111624:114666", -- [31]
			"110971:90639:114837", -- [32]
			"112866:96813:111323:93465", -- [33]
			"112866:96813:120272", -- [1]
			"112866:96813:111323:120118", -- [2]			
			["m"] = 630,
			["coord"] = 2070330066,
			["direct"] = "88110:112866:111418:110971",
			["f"] = 0,
		},
		[110971] = {
			"88110:90556", -- [1]
			"88110:112866", -- [2]
			"90639:93447", -- [3]
			"90639:93940", -- [4]
			"90639:93447:100459:100468:100550:95688", -- [5]
			"88110:90556:111675:114718:92560", -- [6]
			"88110:90556:111675:114718:111420:98105", -- [7]
			"88110:90556:111675:98966:98124", -- [8]
			"88110:90556:111675:114718:92560:98161", -- [9]
			"90639:93447:100459:100468:100550:94973:97860", -- [10]
			"90639:93447:100459:100468:100550:94973:97868", -- [11]
			"90639:93447:100459:100468:100550:97870", -- [12]
			"90639:93447:100459:100468:100550:94973:97868:98066", -- [13]
			"90639:114666:96565", -- [14]
			"88110:90556:111675:98966", -- [15]
			"90639:93447:100459:100468:100550:94973:97860:98972", -- [16]
			"90639:93447:100459:100468", -- [17]
			"90639:93447:100459", -- [18]
			"90639:93447:100459:100468:100550:94973", -- [19]
			"88110:112866:96813", -- [20]
			"90639:93447:100459:100468:100550", -- [21]
			"88110:90556:111675:98966:100559", -- [22]
			"88110:90556:111675:114718:92560:98161:111314", -- [23]
			"88110:112866:96813:111323", -- [24]
			"88110:90556:111675:98966:111327", -- [25]
			"88110:90556:111675", -- [26]
			"88110:90556:111624", -- [27]
			"108888:111418", -- [28]
			"88110:90556:111675:114718:111420", -- [29]
			"108888:111418:112926", -- [30]
			"88110:90556:111675:114718", -- [31]
			"90639:114666", -- [32]
			"90639:114837", -- [33]
			"88110:112866:96813:111323:93465", -- [34]
			"90639:93447:100459:100468:100550:98968:97868", -- [7]
			"90639:93447:100459:100468:100550:98968:97868:98066", -- [8]
			"90639:93447:100459:100468:100550:98968", -- [11]
			"90639:93940:107457", -- [20]
			"88110:112866:96813:120272", -- [1]
			"88110:112866:96813:111323:120118", -- [2]			
			["direct"] = "90639:88110:108888",
			["coord"] = 1367111308,
			["m"] = 630,
			["f"] = 0,
		},
		[94973] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"95688:100559:92560", -- [7]
			"95688:100559:92560:98105", -- [8]
			"95688:100559:98124", -- [9]
			"95688:100559:92560:98161", -- [10]
			"97868:98066", -- [11]
			"100550:96565", -- [12]
			"95688:98966", -- [13]
			"97860:98972", -- [14]
			"100550:100468", -- [15]
			"100550:100468:100459", -- [16]
			"100550:114666:111675:96813", -- [17]
			"95688:100559", -- [18]
			"100550:114666:111624:112866:108888", -- [19]
			"97860:111314", -- [20]
			"100550:114666:111675:111323", -- [21]
			"95688:100559:98124:111327", -- [22]
			"100550:114666:111675", -- [23]
			"100550:114666:111624", -- [24]
			"100550:114666:111624:112866:108888:111418", -- [25]
			"100550:114666:90639:110971", -- [26]
			"95688:100559:92560:98105:111420", -- [27]
			"100550:114666:111624:112866:112926", -- [28]
			"100550:96565:114718", -- [29]
			"100550:114666", -- [30]
			"100550:100468:100459:93940:114837", -- [31]
			"100550:96565:114718:93465", -- [32]
			"97870:107457", -- [9]
			"100550:114666:111675:111323:120272", -- [1]
			"100550:114666:111675:111323:120118", -- [2]			
			["m"] = 650,
			["f"] = 0,
			["direct"] = "95688:97860:97868:97870:100550:98968",
			["coord"] = 1728546507,
		},
		[88110] = {
			"90556:90639", -- [1]
			"90556:93447", -- [2]
			"90556:93447:93940", -- [3]
			"90556:114666:100550:95688", -- [4]
			"90556:111675:114718:92560", -- [5]
			"90556:111675:114718:111420:98105", -- [6]
			"90556:111675:98966:98124", -- [7]
			"90556:111675:114718:92560:98161", -- [8]
			"90556:114666:100550:94973:97860", -- [9]
			"90556:114666:100550:94973:97868", -- [10]
			"90556:114666:100550:97870", -- [11]
			"90556:114666:100550:94973:97868:98066", -- [12]
			"90556:114666:96565", -- [13]
			"90556:111675:98966", -- [14]
			"90556:114666:100550:94973:97860:98972", -- [15]
			"90556:93447:100459:100468", -- [16]
			"90556:93447:100459", -- [17]
			"90556:114666:100550:94973", -- [18]
			"112866:96813", -- [19]
			"90556:114666:100550", -- [20]
			"90556:111675:98966:100559", -- [21]
			"90556:111675:114718:92560:98161:111314", -- [22]
			"112866:96813:111323", -- [23]
			"90556:111675:98966:111327", -- [24]
			"90556:111675", -- [25]
			"90556:111624", -- [26]
			"108888:111418", -- [27]
			"90556:111675:114718:111420", -- [28]
			"108888:111418:112926", -- [29]
			"90556:111675:114718", -- [30]
			"90556:114666", -- [31]
			"90556:90639:114837", -- [32]
			"112866:96813:111323:93465", -- [33]
			"90556:93447:100459:107457", -- [22]
			"112866:96813:120272", -- [1]
			"112866:96813:111323:120118", -- [2]			
			["m"] = 630,
			["coord"] = 1916301339,
			["direct"] = "90556:112866:108888:110971",
			["f"] = 0,
		},
		[120118] = {
			"120272:96813:111624:90556", -- [1]
			"120272:96813:111624:90639", -- [2]
			"120272:96813:112866:88110", -- [3]
			"120272:96813:112866", -- [4]
			"111323:111675:114666:93447", -- [5]
			"111323:111675:114666:100459:93940", -- [6]
			"111323:111675:114666:100550:95688", -- [7]
			"111323:111420:98105:92560", -- [8]
			"111323:111420:98105", -- [9]
			"111323:111420:98105:92560:98124", -- [10]
			"111323:111420:98161", -- [11]
			"111323:111420:98105:92560:100559:97860", -- [12]
			"111323:111675:114666:100550:94973:97868", -- [13]
			"111323:111675:114666:100550:97870", -- [14]
			"111323:111675:114666:100550:94973:97868:98066", -- [15]
			"111323:111675:96565", -- [16]
			"111323:111675:98966", -- [17]
			"111323:111420:98105:92560:98124:98972", -- [18]
			"111323:111675:114666:100468", -- [19]
			"111323:111675:114666:100459", -- [20]
			"111323:111675:114666:100550:94973", -- [21]
			"120272:96813", -- [22]
			"111323:111675:114666:100550", -- [23]
			"111323:111420:98105:92560:100559", -- [24]
			"120272:96813:112866:108888", -- [25]
			"111323:111420:98161:111314", -- [26]
			"111323:111420:98161:111327", -- [27]
			"111323:111675", -- [28]
			"120272:96813:111624", -- [29]
			"120272:96813:111418", -- [30]
			"120272:96813:112866:88110:110971", -- [31]
			"111323:111420", -- [32]
			"111323:112926", -- [33]
			"111323:114718", -- [34]
			"111323:111675:114666", -- [35]
			"120272:96813:111624:90639:114837", -- [36]
			["m"] = 646,
			["direct"] = "111323:120272",
			["coord"] = 3035986385,
			["f"] = 0,
		},		
		[98966] = {
			"96565:114666:90556", -- [1]
			"96565:114666:90639", -- [2]
			"96565:114666:90556:88110", -- [3]
			"111675:111624:112866", -- [4]
			"96565:114666:93447", -- [5]
			"96565:114666:100459:93940", -- [6]
			"92560:98105", -- [7]
			"92560:98161", -- [8]
			"95688:94973:97868", -- [9]
			"95688:94973:97870", -- [10]
			"95688:94973:97868:98066", -- [11]
			"97860:98972", -- [12]
			"96565:100468", -- [13]
			"96565:114666:100459", -- [14]
			"95688:94973", -- [15]
			"111675:96813", -- [16]
			"95688:100550", -- [17]
			"111675:111624:112866:108888", -- [18]
			"111327:111314", -- [19]
			"114718:111323", -- [20]
			"111675:111624", -- [21]
			"111675:111624:112866:108888:111418", -- [22]
			"96565:114666:90639:110971", -- [23]
			"92560:98105:111420", -- [24]
			"111675:96813:112926", -- [25]
			"96565:114666", -- [26]
			"96565:114666:100459:93940:114837", -- [27]
			"114718:93465", -- [28]
			"114718:111323:120272", -- [1]
			"114718:111323:120118", -- [2]			
			["m"] = 650,
			["coord"] = 2441074353,
			["direct"] = "95688:92560:98124:97860:96565:100559:111327:111675:114718",
			["f"] = 0,
		},
		[120272] = {
			"96813:111624:90556", -- [1]
			"96813:111624:90639", -- [2]
			"96813:112866:88110", -- [3]
			"96813:112866", -- [4]
			"96813:111624:93447", -- [5]
			"96813:111624:93447:93940", -- [6]
			"111323:111675:114666:100550:95688", -- [7]
			"111323:111420:98105:92560", -- [8]
			"111323:111420:98105", -- [9]
			"111323:111420:98105:92560:98124", -- [10]
			"111323:111420:98161", -- [11]
			"111323:111420:98105:92560:100559:97860", -- [12]
			"111323:111675:114666:100550:94973:97868", -- [13]
			"111323:111675:114666:100550:97870", -- [14]
			"111323:111675:114666:100550:94973:97868:98066", -- [15]
			"111323:111675:96565", -- [16]
			"111323:111675:98966", -- [17]
			"111323:111420:98105:92560:98124:98972", -- [18]
			"111323:111675:114666:100468", -- [19]
			"96813:111624:93447:100459", -- [20]
			"111323:111675:114666:100550:94973", -- [21]
			"111323:111675:114666:100550", -- [22]
			"111323:111420:98105:92560:100559", -- [23]
			"96813:112866:108888", -- [24]
			"111323:111420:98161:111314", -- [25]
			"111323:111420:98161:111327", -- [26]
			"111323:111675", -- [27]
			"96813:111624", -- [28]
			"96813:111418", -- [29]
			"96813:112866:88110:110971", -- [30]
			"111323:111420", -- [31]
			"96813:112926", -- [32]
			"111323:114718", -- [33]
			"111323:111675:114666", -- [34]
			"96813:111624:90639:114837", -- [35]
			["m"] = 646,
			["direct"] = "96813:111323:120118",
			["coord"] = 1938924524,
			["f"] = 0,
		},		
		[92560] = {
			"114718:111675:90556", -- [1]
			"114718:111675:90639", -- [2]
			"114718:111675:90556:88110", -- [3]
			"114718:111675:111624:112866", -- [4]
			"114718:111675:114666:93447", -- [5]
			"114718:111675:114666:100459:93940", -- [6]
			"100559:95688", -- [7]
			"100559:97860", -- [8]
			"100559:95688:94973:97868", -- [9]
			"100559:95688:94973:97870", -- [10]
			"98124:98972:98066", -- [11]
			"98966:96565", -- [12]
			"98124:98972", -- [13]
			"100559:95688:100550:100468", -- [14]
			"114718:111675:114666:100459", -- [15]
			"100559:95688:94973", -- [16]
			"114718:96813", -- [17]
			"100559:95688:100550", -- [18]
			"114718:111675:111624:112866:108888", -- [19]
			"98161:111314", -- [20]
			"114718:111323", -- [21]
			"114718:111675", -- [22]
			"114718:111675:111624", -- [23]
			"114718:96813:111418", -- [24]
			"114718:111675:90556:88110:110971", -- [25]
			"98105:111420", -- [26]
			"114718:96813:112926", -- [27]
			"114718:111675:114666", -- [28]
			"114718:111675:90639:114837", -- [29]
			"100559:95688:94973:98968", -- [8]		
			"114718:111675:114666:100459:107457", -- [10]	
			"114718:111323:120272", -- [1]
			"114718:111323:120118", -- [2]		
			["m"] = 634,
			["f"] = 0,
			["direct"] = "98105:98124:98161:98966:100559:111327:114718",
			["coord"] = 1930074009,
		},
		[97860] = {
			"95688:100550:114666:90556", -- [1]
			"95688:100550:114666:90639", -- [2]
			"95688:100550:114666:90556:88110", -- [3]
			"95688:100550:114666:111624:112866", -- [4]
			"95688:100550:100468:100459:93447", -- [5]
			"95688:100550:100468:100459:93940", -- [6]
			"100559:92560", -- [7]
			"100559:92560:98105", -- [8]
			"98124:111327:98161", -- [9]
			"94973:97870", -- [10]
			"95688:96565", -- [11]
			"95688:100550:100468", -- [12]
			"95688:100550:100468:100459", -- [13]
			"95688:96565:111675:96813", -- [14]
			"95688:100550", -- [15]
			"95688:100550:114666:111624:112866:108888", -- [16]
			"100559:92560:114718:111323", -- [17]
			"98124:111327", -- [18]
			"95688:96565:111675", -- [19]
			"95688:100550:114666:111624", -- [20]
			"95688:100550:114666:111624:112866:108888:111418", -- [21]
			"95688:100550:114666:90639:110971", -- [22]
			"100559:92560:98105:111420", -- [23]
			"95688:96565:111675:96813:112926", -- [24]
			"100559:92560:114718", -- [25]
			"95688:100550:114666", -- [26]
			"95688:100550:100468:100459:93940:114837", -- [27]
			"98968:97870", -- [10]
			"94973:97870:107457", -- [16]
			"100559:92560:114718:111323:120272", -- [1]
			"100559:92560:114718:111323:120118", -- [2]			
			["m"] = 650,
			["f"] = 0,
			["direct"] = "95688:98124:97868:98066:98966:98972:94973:100559:111314:98968",
			["coord"] = 2258727865,
		},
		[90556] = {
			"93447:93940", -- [1]
			"114666:100550:95688", -- [2]
			"111675:114718:92560", -- [3]
			"111675:114718:111420:98105", -- [4]
			"111675:98966:98124", -- [5]
			"111675:114718:92560:98161", -- [6]
			"114666:100550:94973:97860", -- [7]
			"114666:100550:94973:97868", -- [8]
			"114666:100550:97870", -- [9]
			"114666:100550:94973:97868:98066", -- [10]
			"114666:96565", -- [11]
			"111675:98966", -- [12]
			"114666:100550:94973:97860:98972", -- [13]
			"93447:100459:100468", -- [14]
			"93447:100459", -- [15]
			"114666:100550:94973", -- [16]
			"111624:96813", -- [17]
			"114666:100550", -- [18]
			"111675:98966:100559", -- [19]
			"88110:108888", -- [20]
			"111675:114718:92560:98161:111314", -- [21]
			"111624:96813:111323", -- [22]
			"111675:98966:111327", -- [23]
			"88110:108888:111418", -- [24]
			"88110:110971", -- [25]
			"111675:114718:111420", -- [26]
			"112866:112926", -- [27]
			"111675:114718", -- [28]
			"90639:114837", -- [29]
			"114666:100550:98968:97868", -- [7]
			"114666:100550:98968:97868:98066", -- [9]
			"114666:100550:98968", -- [12]
			"93447:100459:107457", -- [18]
			"111624:96813:120272", -- [1]
			"111624:96813:111323:120118", -- [2]			
			["m"] = 630,
			["coord"] = 2077378472,
			["direct"] = "90639:88110:112866:93447:111675:111624:114666",
			["f"] = 0,
		},
		[97868] = {
			"94973:100550:114666:90556", -- [1]
			"94973:100550:114666:90639", -- [2]
			"94973:100550:114666:90556:88110", -- [3]
			"94973:100550:114666:111624:112866", -- [4]
			"94973:100550:100468:100459:93447", -- [5]
			"94973:100550:100468:100459:93940", -- [6]
			"95688:100559:92560", -- [7]
			"95688:100559:92560:98105", -- [8]
			"97860:98124", -- [9]
			"97860:98124:111327:98161", -- [10]
			"95688:96565", -- [11]
			"95688:98966", -- [12]
			"94973:100550:100468", -- [13]
			"94973:100550:100468:100459", -- [14]
			"95688:96565:111675:96813", -- [15]
			"94973:100550", -- [16]
			"95688:100559", -- [17]
			"94973:100550:114666:111624:112866:108888", -- [18]
			"98972:111314", -- [19]
			"95688:96565:111675:111323", -- [20]
			"97860:98124:111327", -- [21]
			"95688:96565:111675", -- [22]
			"94973:100550:114666:111624", -- [23]
			"94973:100550:114666:111624:112866:108888:111418", -- [24]
			"94973:100550:114666:90639:110971", -- [25]
			"95688:100559:92560:98105:111420", -- [26]
			"95688:96565:111675:96813:112926", -- [27]
			"95688:96565:114718", -- [28]
			"94973:100550:114666", -- [29]
			"94973:100550:100468:100459:93940:114837", -- [30]
			"98968:100550:114666:90556", -- [1]
			"98968:100550:114666:90639", -- [2]
			"98968:100550:114666:90556:88110", -- [3]
			"98968:100550:114666:111624:112866", -- [4]
			"98968:100550:100468:100459:93447", -- [5]
			"98968:100550:100468:100459:93940", -- [6]
			"98968:100550:100468", -- [13]
			"98968:100550:100468:100459", -- [14]
			"98968:100550:114666:111675:96813", -- [15]
			"98968:100550", -- [16]
			"98968:100550:114666:111675", -- [19]
			"98968:100550:114666:111624", -- [20]
			"98968:100550:114666:90639:110971", -- [21]			
			"98968:100550:114666", -- [24]	
			"97870:107457", -- [18]			
			"95688:96565:111675:111323:120272", -- [1]
			"95688:96565:111675:111323:120118", -- [2]			
			["m"] = 650,
			["f"] = 0,
			["direct"] = "95688:97860:97870:98066:98972:94973:98968",
			["coord"] = 1645634648,
		},
		[112866] = {
			"90556:90639", -- [1]
			"111624:93447", -- [2]
			"111624:93447:93940", -- [3]
			"111624:114666:100550:95688", -- [4]
			"111624:111675:114718:92560", -- [5]
			"111624:111675:114718:111420:98105", -- [6]
			"111624:111675:98966:98124", -- [7]
			"111624:111675:114718:92560:98161", -- [8]
			"111624:114666:100550:94973:97860", -- [9]
			"111624:114666:100550:94973:97868", -- [10]
			"111624:114666:100550:97870", -- [11]
			"111624:114666:100550:94973:97868:98066", -- [12]
			"111624:114666:96565", -- [13]
			"111624:111675:98966", -- [14]
			"111624:114666:100550:94973:97860:98972", -- [15]
			"111624:114666:100468", -- [16]
			"111624:93447:100459", -- [17]
			"111624:114666:100550:94973", -- [18]
			"111624:114666:100550", -- [19]
			"111624:111675:98966:100559", -- [20]
			"111624:111675:114718:92560:98161:111314", -- [21]
			"96813:111323", -- [22]
			"111624:111675:98966:111327", -- [23]
			"111624:111675", -- [24]
			"108888:111418", -- [25]
			"88110:110971", -- [26]
			"111624:111675:114718:111420", -- [27]
			"111624:111675:114718", -- [28]
			"111624:114666", -- [29]
			"90556:90639:114837", -- [30]
			"96813:111323:93465", -- [31]
			"111624:93447:100459:107457", -- [20]
			"96813:120272", -- [1]
			"96813:111323:120118", -- [2]			
			["m"] = 630,
			["coord"] = 2412353262,
			["direct"] = "90556:88110:96813:108888:111624:112926",
			["f"] = 0,
		},
		[100459] = {
			"93447:90556", -- [1]
			"93447:90639", -- [2]
			"93447:90556:88110", -- [3]
			"93447:90556:112866", -- [4]
			"100468:100550:95688", -- [5]
			"100468:100550:95688:100559:92560", -- [6]
			"100468:100550:95688:100559:92560:98105", -- [7]
			"100468:100550:95688:100559:98124", -- [8]
			"100468:100550:95688:100559:92560:98161", -- [9]
			"100468:100550:94973:97860", -- [10]
			"100468:100550:94973:97868", -- [11]
			"100468:100550:97870", -- [12]
			"100468:100550:94973:97868:98066", -- [13]
			"100468:96565", -- [14]
			"100468:96565:98966", -- [15]
			"100468:100550:94973:97860:98972", -- [16]
			"100468:100550:94973", -- [17]
			"114666:111675:96813", -- [18]
			"100468:100550", -- [19]
			"100468:100550:95688:100559", -- [20]
			"93447:90556:88110:108888", -- [21]
			"100468:100550:95688:100559:98124:111327:111314", -- [22]
			"114666:111675:111323", -- [23]
			"100468:100550:95688:100559:98124:111327", -- [24]
			"114666:111675", -- [25]
			"93447:111624", -- [26]
			"93447:90556:88110:108888:111418", -- [27]
			"93447:90639:110971", -- [28]
			"114666:111675:114718:111420", -- [29]
			"93447:90556:112866:112926", -- [30]
			"114666:111675:114718", -- [31]
			"93940:114837", -- [32]
			"100468:100550:98968:97868", -- [5]
			"100468:100550:98968:97868:98066", -- [6]
			"100468:100550:98968", -- [7]			
			"114666:111675:111323:120272", -- [1]
			"114666:111675:111323:120118", -- [2]			
			["m"] = 641,
			["coord"] = 2436207577,
			["direct"] = "93447:93940:100468:114666:107457",
			["f"] = 0,
		},
		[90639] = {
			"90556:88110", -- [1]
			"90556:112866", -- [2]
			"93447:100459:100468:100550:95688", -- [3]
			"111675:114718:92560", -- [4]
			"111675:114718:111420:98105", -- [5]
			"93447:100459:100468:100550:95688:100559:98124", -- [6]
			"111675:114718:92560:98161", -- [7]
			"93447:100459:100468:100550:94973:97860", -- [8]
			"93447:100459:100468:100550:94973:97868", -- [9]
			"93447:100459:100468:100550:97870", -- [10]
			"93447:100459:100468:100550:94973:97868:98066", -- [11]
			"114666:96565", -- [12]
			"114666:96565:98966", -- [13]
			"93447:100459:100468:100550:94973:97860:98972", -- [14]
			"93447:100459:100468", -- [15]
			"93447:100459", -- [16]
			"93447:100459:100468:100550:94973", -- [17]
			"111624:96813", -- [18]
			"93447:100459:100468:100550", -- [19]
			"93447:100459:100468:100550:95688:100559", -- [20]
			"110971:108888", -- [21]
			"111675:114718:92560:98161:111314", -- [22]
			"111675:111323", -- [23]
			"114666:96565:98966:111327", -- [24]
			"110971:108888:111418", -- [25]
			"111675:114718:111420", -- [26]
			"90556:112866:112926", -- [27]
			"111675:114718", -- [28]
			"111675:114718:93465", -- [29]
			"93447:100459:100468:100550:98968:97868", -- [6]
			"93447:100459:100468:100550:98968:97868:98066", -- [7]		
			"93447:100459:100468:100550:98968", -- [10]
			"93940:107457", -- [20]
			"111624:96813:120272", -- [1]
			"111675:111323:120118", -- [2]			
			["m"] = 630,
			["coord"] = 1753618256,
			["direct"] = "90556:93447:93940:111675:111624:110971:114666:114837",
			["f"] = 0,
		},
		[96565] = {
			"114666:90556", -- [1]
			"114666:90639", -- [2]
			"114666:90556:88110", -- [3]
			"114666:111624:112866", -- [4]
			"114666:93447", -- [5]
			"114666:100459:93940", -- [6]
			"98966:92560", -- [7]
			"98966:92560:98105", -- [8]
			"98966:98124", -- [9]
			"98966:92560:98161", -- [10]
			"95688:97860", -- [11]
			"100550:94973:97868", -- [12]
			"100550:97870", -- [13]
			"100550:94973:97868:98066", -- [14]
			"95688:97860:98972", -- [15]
			"114666:100459", -- [16]
			"100550:94973", -- [17]
			"111675:96813", -- [18]
			"98966:100559", -- [19]
			"114666:111624:112866:108888", -- [20]
			"98966:111327:111314", -- [21]
			"111675:111323", -- [22]
			"98966:111327", -- [23]
			"114666:111624", -- [24]
			"114666:111624:112866:108888:111418", -- [25]
			"114666:90639:110971", -- [26]
			"114718:111420", -- [27]
			"111675:96813:112926", -- [28]
			"114666:100459:93940:114837", -- [29]
			"114718:93465", -- [30]
			"100550:98968:97868", -- [7]
			"100550:98968:97868:98066", -- [9]
			"100550:98968", -- [10]			
			"114666:100459:107457", -- [2]
			"111675:111323:120272", -- [1]
			"111675:111323:120118", -- [2]			
			["m"] = 650,
			["coord"] = 2030950571,
			["direct"] = "95688:98966:100468:100550:111675:114718:114666",
			["f"] = 0,
		},
		[111323] = {
			"96813:111624:90556", -- [1]
			"96813:111624:90639", -- [2]
			"96813:112866:88110", -- [3]
			"96813:112866", -- [4]
			"111675:114666:93447", -- [5]
			"111675:114666:100459:93940", -- [6]
			"111675:114666:100550:95688", -- [7]
			"111420:98105:92560", -- [8]
			"111420:98105", -- [9]
			"111420:98105:92560:98124", -- [10]
			"111420:98161", -- [11]
			"111420:98105:92560:100559:97860", -- [12]
			"111675:114666:100550:94973:97868", -- [13]
			"111675:114666:100550:97870", -- [14]
			"111675:114666:100550:94973:97868:98066", -- [15]
			"111675:96565", -- [16]
			"111675:98966", -- [17]
			"111420:98105:92560:98124:98972", -- [18]
			"111675:114666:100468", -- [19]
			"111675:114666:100459", -- [20]
			"111675:114666:100550:94973", -- [21]
			"111675:114666:100550", -- [22]
			"111420:98105:92560:100559", -- [23]
			"96813:112866:108888", -- [24]
			"111420:98161:111314", -- [25]
			"111420:98161:111327", -- [26]
			"96813:111624", -- [27]
			"96813:111418", -- [28]
			"96813:112866:88110:110971", -- [29]
			"111675:114666", -- [30]
			"96813:111624:90639:114837", -- [31]
			["m"] = 646,
			["coord"] = 2136815043,
			["direct"] = "96813:111675:111420:112926:114718:120272:120118",
			["f"] = 0,
		},
		[111327] = {
			"92560:114718:111675:90556", -- [1]
			"92560:114718:111675:90639", -- [2]
			"92560:114718:111675:90556:88110", -- [3]
			"92560:114718:111675:111624:112866", -- [4]
			"98966:96565:114666:93447", -- [5]
			"100559:95688:100550:100468:100459:93940", -- [6]
			"100559:95688", -- [7]
			"98161:98105", -- [8]
			"98124:97860", -- [9]
			"100559:95688:94973:97868", -- [10]
			"100559:95688:94973:97870", -- [11]
			"98972:98066", -- [12]
			"98966:96565", -- [13]
			"100559:95688:100550:100468", -- [14]
			"100559:95688:100550:100468:100459", -- [15]
			"100559:95688:94973", -- [16]
			"92560:114718:96813", -- [17]
			"100559:95688:100550", -- [18]
			"92560:114718:111675:111624:112866:108888", -- [19]
			"98161:111420:111323", -- [20]
			"92560:114718:111675", -- [21]
			"92560:114718:111675:111624", -- [22]
			"92560:114718:96813:111418", -- [23]
			"92560:114718:111675:90556:88110:110971", -- [24]
			"98161:111420", -- [25]
			"92560:114718:96813:112926", -- [26]
			"92560:114718", -- [27]
			"98966:96565:114666", -- [28]
			"100559:95688:100550:100468:100459:93940:114837", -- [29]
			"100559:95688:94973:97870:107457", -- [9]
			"98161:111420:111323", -- [1]
			"98161:111420:111323:120272", -- [2]
			"98161:111420:111323:120118", -- [3]		
			["m"] = 634,
			["f"] = 0,
			["direct"] = "92560:98124:98161:98966:98972:100559:111314",
			["coord"] = 2233489604,
		},

		[98105] = {
			"92560:114718:111675:90556", -- [1]
			"92560:114718:111675:90639", -- [2]
			"92560:114718:111675:90556:88110", -- [3]
			"92560:114718:111675:111624:112866", -- [4]
			"92560:114718:111675:114666:93447", -- [5]
			"92560:114718:111675:114666:100459:93940", -- [6]
			"92560:100559:95688", -- [7]
			"92560:98124", -- [8]
			"92560:100559:97860", -- [9]
			"92560:100559:95688:94973:97868", -- [10]
			"92560:100559:95688:94973:97870", -- [11]
			"92560:98124:98972:98066", -- [12]
			"92560:98966:96565", -- [13]
			"92560:98966", -- [14]
			"92560:98124:98972", -- [15]
			"92560:100559:95688:100550:100468", -- [16]
			"92560:114718:111675:114666:100459", -- [17]
			"92560:100559:95688:94973", -- [18]
			"111420:96813", -- [19]
			"92560:100559:95688:100550", -- [20]
			"92560:100559", -- [21]
			"92560:114718:111675:111624:112866:108888", -- [22]
			"98161:111314", -- [23]
			"111420:111323", -- [24]
			"98161:111327", -- [25]
			"92560:114718:111675", -- [26]
			"92560:114718:111675:111624", -- [27]
			"111420:96813:111418", -- [28]
			"92560:114718:111675:90556:88110:110971", -- [29]
			"111420:111323:112926", -- [30]
			"92560:114718", -- [31]
			"92560:114718:111675:114666", -- [32]
			"92560:114718:111675:90639:114837", -- [33]
			"92560:100559:95688:94973:98968", -- [15]
			"92560:114718:111675:114666:100459:107457", -- [22]
			"111420:111323:120272", -- [1]
			"111420:111323:120118", -- [2]			
			["direct"] = "92560:98161:111420",
			["f"] = 0,
			["m"] = 634,
			["coord"] = 2341583537,
		},
		[93447] = {
			"90556:88110", -- [1]
			"90556:112866", -- [2]
			"100459:100468:100550:95688", -- [3]
			"114666:111675:114718:92560", -- [4]
			"114666:111675:114718:111420:98105", -- [5]
			"100459:100468:100550:95688:100559:98124", -- [6]
			"114666:111675:114718:92560:98161", -- [7]
			"100459:100468:100550:94973:97860", -- [8]
			"100459:100468:100550:94973:97868", -- [9]
			"100459:100468:100550:97870", -- [10]
			"100459:100468:100550:94973:97868:98066", -- [11]
			"114666:96565", -- [12]
			"114666:96565:98966", -- [13]
			"100459:100468:100550:94973:97860:98972", -- [14]
			"100459:100468", -- [15]
			"100459:100468:100550:94973", -- [16]
			"111624:96813", -- [17]
			"100459:100468:100550", -- [18]
			"100459:100468:100550:95688:100559", -- [19]
			"90556:88110:108888", -- [20]
			"100459:100468:100550:95688:100559:98124:111327:111314", -- [21]
			"114666:111675:111323", -- [22]
			"100459:100468:100550:95688:100559:98124:111327", -- [23]
			"114666:111675", -- [24]
			"90556:88110:108888:111418", -- [25]
			"90639:110971", -- [26]
			"114666:111675:114718:111420", -- [27]
			"90556:112866:112926", -- [28]
			"114666:111675:114718", -- [29]
			"93940:114837", -- [30]
			"114666:111675:114718:93465", -- [31]
			"100459:100468:100550:98968:97868", -- [6]
			"100459:100468:100550:98968:97868:98066", -- [7]	
			"100459:100468:100550:98968", -- [10]			
			"100459:107457", -- [20]
			"111624:96813:120272", -- [8]
			"114666:111675:111323:120118", -- [9]			
			"111624:96813:120272", -- [1]
			"114666:111675:111323:120118", -- [2]			
			["m"] = 641,
			["coord"] = 2360588730,
			["direct"] = "90556:90639:93940:100459:111624:114666",
			["f"] = 0,
		},
		[112926] = {
			"112866:90556", -- [1]
			"112866:90556:90639", -- [2]
			"112866:88110", -- [3]
			"112866:111624:93447", -- [4]
			"112866:111624:93447:93940", -- [5]
			"112866:111624:114666:100550:95688", -- [6]
			"96813:114718:92560", -- [7]
			"111323:111420:98105", -- [8]
			"96813:114718:92560:98124", -- [9]
			"111323:111420:98161", -- [10]
			"112866:111624:114666:100550:94973:97860", -- [11]
			"112866:111624:114666:100550:94973:97868", -- [12]
			"112866:111624:114666:100550:97870", -- [13]
			"112866:111624:114666:100550:94973:97868:98066", -- [14]
			"96813:111675:96565", -- [15]
			"96813:111675:98966", -- [16]
			"96813:114718:92560:98124:98972", -- [17]
			"112866:111624:114666:100468", -- [18]
			"112866:111624:93447:100459", -- [19]
			"112866:111624:114666:100550:94973", -- [20]
			"112866:111624:114666:100550", -- [21]
			"96813:111675:98966:100559", -- [22]
			"111418:108888", -- [23]
			"111323:111420:98161:111314", -- [24]
			"111323:111420:98161:111327", -- [25]
			"96813:111675", -- [26]
			"112866:111624", -- [27]
			"111418:108888:110971", -- [28]
			"111323:111420", -- [29]
			"96813:114718", -- [30]
			"112866:111624:114666", -- [31]
			"112866:90556:90639:114837", -- [32]
			["m"] = 790,
			["coord"] = 1645180346,
			["direct"] = "112866:96813:111323:111418",
			["f"] = 0,
		},
		[111418] = {
			"108888:88110:90556", -- [1]
			"108888:110971:90639", -- [2]
			"108888:88110", -- [3]
			"108888:112866", -- [4]
			"108888:88110:90556:93447", -- [5]
			"108888:88110:90556:93447:93940", -- [6]
			"108888:112866:111624:114666:100550:95688", -- [7]
			"108888:112866:111624:111675:114718:92560", -- [8]
			"96813:111420:98105", -- [9]
			"108888:112866:111624:111675:98966:98124", -- [10]
			"96813:111420:98161", -- [11]
			"108888:112866:111624:114666:100550:94973:97860", -- [12]
			"108888:112866:111624:114666:100550:94973:97868", -- [13]
			"108888:112866:111624:114666:100550:97870", -- [14]
			"108888:112866:111624:114666:100550:94973:97868:98066", -- [15]
			"108888:112866:111624:114666:96565", -- [16]
			"108888:112866:111624:111675:98966", -- [17]
			"108888:112866:111624:114666:100550:94973:97860:98972", -- [18]
			"108888:112866:111624:114666:100468", -- [19]
			"108888:88110:90556:93447:100459", -- [20]
			"108888:112866:111624:114666:100550:94973", -- [21]
			"108888:112866:111624:114666:100550", -- [22]
			"108888:112866:111624:111675:98966:100559", -- [23]
			"96813:111420:98161:111314", -- [24]
			"96813:111323", -- [25]
			"108888:112866:111624:111675:98966:111327", -- [26]
			"108888:112866:111624:111675", -- [27]
			"108888:112866:111624", -- [28]
			"108888:110971", -- [29]
			"96813:111420", -- [30]
			"108888:112866:111624:111675:114718", -- [31]
			"108888:112866:111624:114666", -- [32]
			"108888:110971:90639:114837", -- [33]
			["direct"] = "96813:108888:112926",
			["coord"] = 2223034959,
			["m"] = 630,
			["f"] = 0,
		},
		[98066] = {
			"97870:100550:114666:90556", -- [1]
			"97870:100550:114666:90639", -- [2]
			"97870:100550:114666:90556:88110", -- [3]
			"97870:100550:114666:111624:112866", -- [4]
			"97870:100550:100468:100459:93447", -- [5]
			"97870:100550:100468:100459:93940", -- [6]
			"97868:95688", -- [7]
			"98972:98124:92560", -- [8]

			"98972:98124:92560:98105", -- [9]
			"98972:98124", -- [10]
			"98972:111327:98161", -- [11]
			"97870:100550:96565", -- [12]
			"97860:100559:98966", -- [13]
			"97870:100550:100468", -- [14]
			"97870:100550:100468:100459", -- [15]
			"97868:94973", -- [16]
			"97870:100550:114666:111675:96813", -- [17]
			"97870:100550", -- [18]
			"97860:100559", -- [19]
			"97870:100550:114666:111624:112866:108888", -- [20]
			"98972:111314", -- [21]
			"98972:98124:92560:114718:111323", -- [22]
			"98972:111327", -- [23]
			"97870:100550:114666:111675", -- [24]
			"97870:100550:114666:111624", -- [25]
			"97870:100550:114666:111624:112866:108888:111418", -- [26]
			"97870:100550:114666:90639:110971", -- [27]
			"98972:111327:98161:111420", -- [28]
			"97870:100550:114666:111624:112866:112926", -- [29]
			"98972:98124:92560:114718", -- [30]
			"97870:100550:114666", -- [31]
			"97870:100550:100468:100459:93940:114837", -- [32]
			"97868:98968", -- [14]
			"97870:107457:93940", -- [1]
			"97870:107457", -- [12]
			"107457:97870", -- [11]
			"107457:97870:98066", -- [12]
			"98972:98124:92560:114718:111323:120272", -- [1]
			"98972:98124:92560:114718:111323:120118", -- [2]
			["m"] = 650,
			["f"] = 0,
			["direct"] = "97860:97868:97870:98972:107457",
			["coord"] = 1799625409,
		},
		[100468] = {
			"100459:93447:90556", -- [1]
			"100459:93447:90639", -- [2]
			"100459:93447:90556:88110", -- [3]
			"114666:111624:112866", -- [4]
			"100459:93447", -- [5]
			"100459:93940", -- [6]
			"100550:95688", -- [7]
			"100550:95688:100559:92560", -- [8]
			"100550:95688:100559:92560:98105", -- [9]
			"100550:95688:100559:98124", -- [10]
			"100550:95688:100559:92560:98161", -- [11]
			"100550:94973:97860", -- [12]
			"100550:94973:97868", -- [13]
			"100550:97870", -- [14]
			"100550:94973:97868:98066", -- [15]
			"96565:98966", -- [16]
			"100550:94973:97860:98972", -- [17]
			"100550:94973", -- [18]
			"114666:111675:96813", -- [19]
			"100550:95688:100559", -- [20]
			"114666:111624:112866:108888", -- [21]
			"100550:95688:100559:98124:111327:111314", -- [22]
			"114666:111675:111323", -- [23]
			"100550:95688:100559:98124:111327", -- [24]
			"114666:111675", -- [25]
			"114666:111624", -- [26]
			"114666:111624:112866:108888:111418", -- [27]
			"100459:93447:90639:110971", -- [28]
			"96565:114718:111420", -- [29]
			"114666:111624:112866:112926", -- [30]
			"96565:114718", -- [31]
			"100459:93940:114837", -- [32]
			"100550:98968:97868", -- [7]
			"100550:98968:97868:98066", -- [8]
			"100550:98968", -- [9]			
			"100459:107457", -- [15]
			"114666:111675:111323:120272", -- [1]
			"114666:111675:111323:120118", -- [2]			
			["m"] = 641,
			["coord"] = 2963243589,
			["direct"] = "96565:100459:100550:114666",
			["f"] = 0,
		},
		[95688] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"100559:92560", -- [7]
			"100559:92560:98105", -- [8]
			"100559:98124", -- [9]
			"100559:92560:98161", -- [10]
			"94973:97868:98066", -- [11]
			"97860:98972", -- [12]
			"100550:100468", -- [13]
			"100550:100468:100459", -- [14]
			"96565:111675:96813", -- [15]
			"100550:114666:111624:112866:108888", -- [16]
			"100559:98124:111327:111314", -- [17]
			"96565:111675:111323", -- [18]
			"100559:98124:111327", -- [19]
			"96565:111675", -- [20]
			"100550:114666:111624", -- [21]
			"100550:114666:111624:112866:108888:111418", -- [22]
			"100550:114666:90639:110971", -- [23]
			"100559:92560:98105:111420", -- [24]
			"96565:111675:96813:112926", -- [25]
			"96565:114718", -- [26]
			"100550:114666", -- [27]
			"100550:100468:100459:93940:114837", -- [28]
			"94973:97870:107457", -- [6]
			"96565:111675:111323:120272", -- [1]
			"96565:111675:111323:120118", -- [2]			
			["m"] = 750,
			["coord"] = 1919771391,
			["direct"] = "97860:97868:97870:96565:98966:94973:100550:100559:98968",
			["f"] = 0,
		},
		[114718] = {
			"111675:90556", -- [1]
			"111675:90639", -- [2]
			"111675:90556:88110", -- [3]
			"111675:111624:112866", -- [4]
			"111675:114666:93447", -- [5]
			"111675:114666:100459:93940", -- [6]
			"96565:95688", -- [7]
			"111420:98105", -- [8]
			"92560:98124", -- [9]
			"92560:98161", -- [10]
			"92560:100559:97860", -- [11]
			"96565:100550:94973:97868", -- [12]
			"96565:100550:97870", -- [13]
			"92560:98124:98972:98066", -- [14]
			"92560:98124:98972", -- [15]
			"96565:100468", -- [16]
			"111675:114666:100459", -- [17]
			"96565:100550:94973", -- [18]
			"96565:100550", -- [19]
			"92560:100559", -- [20]
			"111675:111624:112866:108888", -- [21]
			"92560:98161:111314", -- [22]
			"92560:111327", -- [23]
			"111675:111624", -- [24]
			"96813:111418", -- [25]
			"111675:90556:88110:110971", -- [26]
			"96813:112926", -- [27]
			"111675:114666", -- [28]
			"111675:90639:114837", -- [29]
			"96565:100550:98968:97868", -- [8]
			"96565:100550:98968", -- [10]
			"111675:114666:100459:107457", -- [7]
			"111323:120272", -- [1]
			"111323:120118", -- [2]			
			["m"] = 680,
			["f"] = 0,
			["direct"] = "92560:96565:98966:96813:111323:111675:111420",
			["coord"] = 2758765422,
		},
		[98972] = {
			"97860:95688:100550:114666:90556", -- [1]
			"97860:95688:100550:114666:90639", -- [2]
			"97860:95688:100550:114666:90556:88110", -- [3]
			"97860:95688:100550:114666:111624:112866", -- [4]
			"97860:95688:100550:100468:100459:93447", -- [5]
			"97860:95688:100550:100468:100459:93940", -- [6]
			"97860:95688", -- [7]
			"98124:92560", -- [8]
			"98124:92560:98105", -- [9]
			"111327:98161", -- [10]
			"97868:97870", -- [11]
			"97860:95688:96565", -- [12]
			"97860:100559:98966", -- [13]
			"97860:95688:100550:100468", -- [14]
			"97860:95688:100550:100468:100459", -- [15]
			"97860:94973", -- [16]
			"98124:92560:114718:96813", -- [17]
			"97860:95688:100550", -- [18]
			"97860:100559", -- [19]
			"97860:95688:100550:114666:111624:112866:108888", -- [20]
			"98124:92560:114718:111323", -- [21]
			"97860:95688:96565:111675", -- [22]
			"97860:95688:100550:114666:111624", -- [23]
			"97860:95688:100550:114666:111624:112866:108888:111418", -- [24]
			"97860:95688:100550:114666:90639:110971", -- [25]
			"111327:98161:111420", -- [26]
			"98124:92560:114718:96813:112926", -- [27]
			"98124:92560:114718", -- [28]
			"97860:95688:100550:114666", -- [29]
			"97860:95688:100550:100468:100459:93940:114837", -- [30]
			"97868:98968", -- [14]
			"97868:97870:107457", -- [20]
			"98124:92560:114718:111323:120272", -- [1]
			"98124:92560:114718:111323:120118", -- [2]			
			["m"] = 650,
			["f"] = 0,
			["direct"] = "98124:97860:97868:98066:111314:111327",
			["coord"] = 2493204809,
		},
		[93940] = {
			"93447:90556", -- [1]
			"93447:90556:88110", -- [2]
			"93447:90556:112866", -- [3]
			"100459:100468:100550:95688", -- [4]
			"100459:100468:100550:95688:100559:92560", -- [5]
			"100459:100468:100550:95688:100559:92560:98105", -- [6]
			"100459:100468:100550:95688:100559:98124", -- [7]
			"100459:100468:100550:95688:100559:92560:98161", -- [8]
			"100459:100468:100550:94973:97860", -- [9]
			"100459:100468:100550:94973:97868", -- [10]
			"100459:100468:100550:97870", -- [11]
			"100459:100468:100550:94973:97868:98066", -- [12]
			"100459:100468:96565", -- [13]
			"100459:100468:96565:98966", -- [14]
			"100459:100468:100550:94973:97860:98972", -- [15]
			"100459:100468", -- [16]
			"100459:100468:100550:94973", -- [17]
			"93447:111624:96813", -- [18]
			"100459:100468:100550", -- [19]
			"100459:100468:100550:95688:100559", -- [20]
			"93447:90556:88110:108888", -- [21]
			"100459:100468:100550:95688:100559:98124:111327:111314", -- [22]
			"100459:114666:111675:111323", -- [23]
			"100459:100468:100550:95688:100559:98124:111327", -- [24]
			"100459:114666:111675", -- [25]
			"93447:111624", -- [26]
			"93447:90556:88110:108888:111418", -- [27]
			"90639:110971", -- [28]
			"100459:114666:111675:114718:111420", -- [29]
			"93447:90556:112866:112926", -- [30]
			"100459:114666:111675:114718", -- [31]
			"100459:114666", -- [32]
			"93447:111624:96813:120272", -- [1]
			"100459:114666:111675:111323:120118", -- [2]			
			["m"] = 641,
			["coord"] = 1816434143,
			["direct"] = "90639:93447:100459:114837",
			["f"] = 0,
		},
		[100559] = {
			"98966:96565:114666:90556", -- [1]
			"98966:96565:114666:90639", -- [2]
			"98966:96565:114666:90556:88110", -- [3]
			"98966:111675:111624:112866", -- [4]
			"95688:100550:100468:100459:93447", -- [5]
			"95688:100550:100468:100459:93940", -- [6]
			"92560:98105", -- [7]
			"92560:98161", -- [8]
			"95688:94973:97868", -- [9]
			"95688:94973:97870", -- [10]
			"97860:98066", -- [11]
			"98966:96565", -- [12]
			"97860:98972", -- [13]
			"95688:100550:100468", -- [14]
			"95688:100550:100468:100459", -- [15]
			"95688:94973", -- [16]
			"92560:114718:96813", -- [17]
			"95688:100550", -- [18]
			"98966:111675:111624:112866:108888", -- [19]
			"98124:111327:111314", -- [20]
			"92560:114718:111323", -- [21]
			"98966:111675", -- [22]
			"98966:111675:111624", -- [23]
			"98966:111675:111624:112866:108888:111418", -- [24]
			"98966:96565:114666:90639:110971", -- [25]
			"92560:98105:111420", -- [26]
			"92560:114718:96813:112926", -- [27]
			"92560:114718", -- [28]
			"98966:96565:114666", -- [29]
			"95688:100550:100468:100459:93940:114837", -- [30]
			"95688:94973:98968", -- [10]			
			"95688:94973:97870:107457", -- [9]
			"92560:114718:111323:120272", -- [1]
			"92560:114718:111323:120118", -- [2]			
			["m"] = 650,
			["f"] = 0,
			["direct"] = "95688:92560:98124:97860:98966:111327",
			["coord"] = 2544608943,
		},
		[97870] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"94973:95688:100559:92560", -- [7]
			"94973:95688:100559:92560:98105", -- [8]
			"94973:95688:100559:98124", -- [9]
			"94973:95688:100559:92560:98161", -- [10]
			"97868:97860", -- [11]
			"100550:96565", -- [12]
			"94973:95688:98966", -- [13]
			"97868:98972", -- [14]
			"100550:100468", -- [15]
			"100550:100468:100459", -- [16]
			"100550:114666:111675:96813", -- [17]
			"94973:95688:100559", -- [18]
			"100550:114666:111624:112866:108888", -- [19]
			"97868:98972:111314", -- [20]
			"100550:114666:111675:111323", -- [21]
			"94973:95688:100559:98124:111327", -- [22]
			"100550:114666:111675", -- [23]
			"100550:114666:111624", -- [24]
			"100550:114666:111624:112866:108888:111418", -- [25]
			"100550:114666:90639:110971", -- [26]
			"94973:95688:100559:92560:98105:111420", -- [27]
			"100550:114666:111624:112866:112926", -- [28]
			"100550:96565:114718", -- [29]
			"100550:114666", -- [30]
			"100550:100468:100459:93940:114837", -- [31]
			"107457:93940", -- [1]
			"100550:114666:111675:111323:120272", -- [1]
			"100550:114666:111675:111323:120118", -- [2]			
			["m"] = 650,
			["f"] = 0,
			["direct"] = "95688:97868:98066:94973:100550:98968:107457",
			["coord"] = 1286038703,
		},
		[111675] = {
			"90556:88110", -- [1]
			"111624:112866", -- [2]
			"114666:93447", -- [3]
			"114666:100459:93940", -- [4]
			"114666:100550:95688", -- [5]
			"114718:92560", -- [6]
			"114718:111420:98105", -- [7]
			"98966:98124", -- [8]
			"114718:92560:98161", -- [9]
			"98966:97860", -- [10]
			"114666:100550:94973:97868", -- [11]
			"114666:100550:97870", -- [12]
			"114666:100550:94973:97868:98066", -- [13]
			"98966:97860:98972", -- [14]
			"114666:100468", -- [15]
			"114666:100459", -- [16]
			"114666:100550:94973", -- [17]
			"114666:100550", -- [18]
			"98966:100559", -- [19]
			"111624:112866:108888", -- [20]
			"114718:92560:98161:111314", -- [21]
			"98966:111327", -- [22]
			"111624:112866:108888:111418", -- [23]
			"90556:88110:110971", -- [24]
			"114718:111420", -- [25]
			"96813:112926", -- [26]
			"90639:114837", -- [27]
			"114666:100550:98968:97868", -- [2]
			"114666:100550:98968:97868:98066", -- [3]
			"114666:100550:98968", -- [4]
			"114666:100459:107457", -- [18]
			"111323:120272", -- [1]
			"111323:120118", -- [2]			
			["m"] = 680,
			["coord"] = 1475313302,
			["direct"] = "90556:90639:96565:98966:96813:111323:111624:114718:114666",
			["f"] = 0,
		},
		[111624] = {
			"90556:88110", -- [1]
			"93447:93940", -- [2]
			"114666:100550:95688", -- [3]
			"111675:114718:92560", -- [4]
			"111675:114718:111420:98105", -- [5]
			"111675:98966:98124", -- [6]
			"111675:114718:92560:98161", -- [7]
			"114666:100550:94973:97860", -- [8]
			"114666:100550:94973:97868", -- [9]
			"114666:100550:97870", -- [10]
			"114666:100550:94973:97868:98066", -- [11]
			"114666:96565", -- [12]
			"111675:98966", -- [13]
			"114666:100550:94973:97860:98972", -- [14]
			"114666:100468", -- [15]
			"93447:100459", -- [16]
			"114666:100550:94973", -- [17]
			"114666:100550", -- [18]
			"111675:98966:100559", -- [19]
			"112866:108888", -- [20]
			"111675:114718:92560:98161:111314", -- [21]
			"96813:111323", -- [22]
			"111675:98966:111327", -- [23]
			"112866:108888:111418", -- [24]
			"90556:88110:110971", -- [25]
			"111675:114718:111420", -- [26]
			"112866:112926", -- [27]
			"111675:114718", -- [28]
			"90639:114837", -- [29]
			"96813:111323:93465", -- [30]
			"114666:100550:98968:97868", -- [1]
			"114666:100550:98968:97868:98066", -- [2]
			"114666:100550:98968", -- [3]			
			"93447:100459:107457", -- [17]
			"96813:120272", -- [1]
			"96813:111323:120118", -- [2]			
			["m"] = 630,
			["coord"] = 2739030261,
			["direct"] = "90556:90639:112866:93447:96813:111675:114666",
			["f"] = 0,
		},
		[114837] = {
			"90639:90556", -- [1]
			"90639:90556:88110", -- [2]
			"90639:90556:112866", -- [3]
			"93940:93447", -- [4]
			"93940:100459:100468:100550:95688", -- [5]
			"93940:100459:100468:100550:95688:100559:92560", -- [6]
			"93940:100459:100468:100550:95688:100559:92560:98105", -- [7]
			"93940:100459:100468:100550:95688:100559:98124", -- [8]
			"93940:100459:100468:100550:95688:100559:92560:98161", -- [9]
			"93940:100459:100468:100550:94973:97860", -- [10]
			"93940:100459:100468:100550:94973:97868", -- [11]
			"93940:100459:100468:100550:97870", -- [12]
			"93940:100459:100468:100550:94973:97868:98066", -- [13]
			"93940:100459:100468:96565", -- [14]
			"93940:100459:100468:96565:98966", -- [15]
			"93940:100459:100468:100550:94973:97860:98972", -- [16]
			"93940:100459:100468", -- [17]
			"93940:100459", -- [18]
			"93940:100459:100468:100550:94973", -- [19]
			"90639:111624:96813", -- [20]
			"93940:100459:100468:100550", -- [21]
			"93940:100459:100468:100550:95688:100559", -- [22]
			"90639:110971:108888", -- [23]
			"93940:100459:100468:100550:95688:100559:98124:111327:111314", -- [24]
			"93940:100459:114666:111675:111323", -- [25]
			"93940:100459:100468:100550:95688:100559:98124:111327", -- [26]
			"93940:100459:114666:111675", -- [27]
			"90639:111624", -- [28]
			"90639:110971:108888:111418", -- [29]
			"90639:110971", -- [30]
			"93940:100459:114666:111675:114718:111420", -- [31]
			"90639:90556:112866:112926", -- [32]
			"93940:100459:114666:111675:114718", -- [33]
			"93940:100459:114666", -- [34]
			"90639:111624:96813:120272", -- [5]
			"93940:100459:114666:111675:111323:120118", -- [6]			
			["direct"] = "90639:93940",
			["coord"] = 1115662876,
			["m"] = 641,
			["f"] = 0,
		},
		[114666] = {
			"90556:88110", -- [1]
			"111624:112866", -- [2]
			"100459:93940", -- [3]
			"100550:95688", -- [4]
			"111675:114718:92560", -- [5]
			"111675:114718:111420:98105", -- [6]
			"96565:98966:98124", -- [7]
			"111675:114718:92560:98161", -- [8]
			"100550:94973:97860", -- [9]
			"100550:94973:97868", -- [10]
			"100550:97870", -- [11]
			"100550:94973:97868:98066", -- [12]
			"96565:98966", -- [13]
			"100550:94973:97860:98972", -- [14]
			"100550:94973", -- [15]
			"111675:96813", -- [16]
			"96565:98966:100559", -- [17]
			"111624:112866:108888", -- [18]
			"96565:98966:111327:111314", -- [19]
			"111675:111323", -- [20]
			"96565:98966:111327", -- [21]
			"111624:112866:108888:111418", -- [22]
			"90639:110971", -- [23]
			"111675:114718:111420", -- [24]
			"111624:112866:112926", -- [25]
			"111675:114718", -- [26]
			"100459:93940:114837", -- [27]
			"111675:114718:93465", -- [28]
			"100550:98968:97868", -- [5]
			"100550:98968:97868:98066", -- [6]
			"100550:98968", -- [7]			
			"100459:107457", -- [15]
			"111675:111323:120272", -- [8]
			"111675:111323:120118", -- [9]		
			"111675:111323:120272", -- [1]
			"111675:111323:120118", -- [2]			
			["m"] = 680,
			["coord"] = 1095979364,
			["direct"] = "90556:90639:93447:96565:100468:100459:100550:111675:111624",
			["f"] = 0,
		},
		[111420] = {
			"114718:111675:90556", -- [1]
			"114718:111675:90639", -- [2]
			"114718:111675:90556:88110", -- [3]
			"96813:112866", -- [4]
			"114718:111675:114666:93447", -- [5]
			"114718:111675:114666:100459:93940", -- [6]
			"98105:92560:100559:95688", -- [7]
			"98105:92560", -- [8]
			"98105:92560:98124", -- [9]
			"98105:92560:100559:97860", -- [10]
			"98105:92560:100559:95688:94973:97868", -- [11]
			"98105:92560:100559:95688:94973:97870", -- [12]
			"98105:92560:98124:98972:98066", -- [13]
			"114718:96565", -- [14]
			"98105:92560:98966", -- [15]
			"98105:92560:98124:98972", -- [16]
			"114718:96565:100468", -- [17]
			"114718:111675:114666:100459", -- [18]
			"98105:92560:100559:95688:94973", -- [19]
			"98105:92560:100559:95688:100550", -- [20]
			"98105:92560:100559", -- [21]
			"96813:112866:108888", -- [22]
			"98161:111314", -- [23]
			"98161:111327", -- [24]
			"114718:111675", -- [25]
			"114718:111675:111624", -- [26]
			"96813:111418", -- [27]
			"114718:111675:90556:88110:110971", -- [28]
			"111323:112926", -- [29]
			"114718:111675:114666", -- [30]
			"114718:111675:90639:114837", -- [31]
			"98105:92560:100559:95688:94973:98968", -- [16]
			"114718:111675:114666:100459:107457", -- [22]
			"111323:120272", -- [1]
			"111323:120118", -- [2]			
			["m"] = 634,
			["f"] = 0,
			["direct"] = "98105:98108:98161:96813:111323:114718",
			["coord"] = 2387795914,
		},
		[98124] = {
			"98966:96565:114666:90556", -- [1]
			"98966:96565:114666:90639", -- [2]
			"98966:96565:114666:90556:88110", -- [3]
			"98966:111675:111624:112866", -- [4]
			"98966:96565:114666:93447", -- [5]
			"100559:95688:100550:100468:100459:93940", -- [6]
			"100559:95688", -- [7]
			"92560:98105", -- [8]
			"111327:98161", -- [9]
			"97860:97868", -- [10]
			"100559:95688:94973:97870", -- [11]
			"98972:98066", -- [12]
			"98966:96565", -- [13]
			"100559:95688:100550:100468", -- [14]
			"100559:95688:100550:100468:100459", -- [15]
			"100559:95688:94973", -- [16]
			"92560:114718:96813", -- [17]
			"100559:95688:100550", -- [18]
			"98966:111675:111624:112866:108888", -- [19]
			"111327:111314", -- [20]
			"92560:114718:111323", -- [21]
			"98966:111675", -- [22]
			"98966:111675:111624", -- [23]
			"92560:114718:96813:111418", -- [24]
			"98966:96565:114666:90639:110971", -- [25]
			"92560:98105:111420", -- [26]
			"92560:114718:96813:112926", -- [27]
			"92560:114718", -- [28]
			"98966:96565:114666", -- [29]
			"100559:95688:100550:100468:100459:93940:114837", -- [30]
			"97860:98968", -- [10]
			"100559:95688:94973:97870:107457", -- [10]
			"92560:114718:111323:120272", -- [1]
			"92560:114718:111323:120118", -- [2]			
			["m"] = 634,
			["f"] = 0,
			["direct"] = "92560:97860:98966:98972:100559:111327",
			["coord"] = 1568099994,
		},
		[98161] = {
			"92560:114718:111675:90556", -- [1]
			"92560:114718:111675:90639", -- [2]
			"92560:114718:111675:90556:88110", -- [3]
			"92560:114718:111675:111624:112866", -- [4]
			"92560:114718:111675:114666:93447", -- [5]
			"92560:114718:111675:114666:100459:93940", -- [6]
			"92560:100559:95688", -- [7]
			"111327:98124", -- [8]
			"111327:98124:97860", -- [9]
			"92560:100559:95688:94973:97868", -- [10]
			"92560:100559:95688:94973:97870", -- [11]
			"111327:98972:98066", -- [12]
			"92560:98966:96565", -- [13]
			"92560:98966", -- [14]
			"111327:98972", -- [15]
			"92560:100559:95688:100550:100468", -- [16]
			"92560:114718:111675:114666:100459", -- [17]
			"92560:100559:95688:94973", -- [18]
			"92560:114718:96813", -- [19]
			"92560:100559:95688:100550", -- [20]
			"92560:100559", -- [21]
			"92560:114718:111675:111624:112866:108888", -- [22]
			"111420:111323", -- [23]
			"92560:114718:111675", -- [24]
			"92560:114718:111675:111624", -- [25]
			"92560:114718:96813:111418", -- [26]
			"92560:114718:111675:90556:88110:110971", -- [27]
			"92560:114718:96813:112926", -- [28]
			"92560:114718", -- [29]
			"92560:114718:111675:114666", -- [30]
			"92560:114718:111675:90639:114837", -- [31]
			"92560:100559:95688:94973:98968", -- [12]
			"92560:114718:111675:114666:100459:107457", -- [18]
			"111420:111323:120272", -- [1]
			"111420:111323:120118", -- [2]			
			["m"] = 634,
			["f"] = 0,
			["direct"] = "92560:98105:111314:111327:111420",
			["coord"] = 2606596687,
		},
		[100550] = {
			"98968:97868", -- [7]
			"98968:97868:98066", -- [8]		
			"114666:90556", -- [1]
			"114666:90639", -- [2]
			"114666:90556:88110", -- [3]
			"114666:111624:112866", -- [4]
			"100468:100459:93447", -- [5]
			"100468:100459:93940", -- [6]
			"95688:100559:92560", -- [7]
			"95688:100559:92560:98105", -- [8]
			"95688:100559:98124", -- [9]
			"95688:100559:92560:98161", -- [10]
			"94973:97860", -- [11]
			"94973:97868", -- [12]
			"94973:97868:98066", -- [13]
			"96565:98966", -- [14]
			"94973:97860:98972", -- [15]
			"100468:100459", -- [16]
			"114666:111675:96813", -- [17]
			"95688:100559", -- [18]
			"114666:111624:112866:108888", -- [19]
			"95688:100559:98124:111327:111314", -- [20]
			"114666:111675:111323", -- [21]
			"95688:100559:98124:111327", -- [22]
			"114666:111675", -- [23]
			"114666:111624", -- [24]
			"114666:111624:112866:108888:111418", -- [25]
			"114666:90639:110971", -- [26]
			"96565:114718:111420", -- [27]
			"114666:111624:112866:112926", -- [28]
			"96565:114718", -- [29]
			"100468:100459:93940:114837", -- [30]
			"96565:114718:93465", -- [31]
			"100468:100459:107457", -- [12]
			["m"] = 650,
			["f"] = 0,
			["direct"] = "95688:97870:96565:100468:94973:114666",
			["coord"] = 1540597954,
		},
		[111314] = {
			"98161:92560:114718:111675:90556", -- [1]
			"98161:92560:114718:111675:90639", -- [2]
			"98161:92560:114718:111675:90556:88110", -- [3]
			"98161:92560:114718:111675:111624:112866", -- [4]
			"97860:95688:100550:100468:100459:93447", -- [5]
			"97860:95688:100550:100468:100459:93940", -- [6]
			"97860:95688", -- [7]
			"98161:92560", -- [8]
			"98161:98105", -- [9]
			"111327:98124", -- [10]
			"97860:97868", -- [11]
			"97860:94973:97870", -- [12]
			"98972:98066", -- [13]
			"111327:98966:96565", -- [14]
			"111327:98966", -- [15]
			"97860:95688:100550:100468", -- [16]
			"97860:95688:100550:100468:100459", -- [17]
			"97860:94973", -- [18]
			"98161:92560:114718:96813", -- [19]
			"97860:95688:100550", -- [20]
			"111327:100559", -- [21]
			"98161:92560:114718:111675:111624:112866:108888", -- [22]
			"98161:111420:111323", -- [23]
			"98161:92560:114718:111675", -- [24]
			"98161:92560:114718:111675:111624", -- [25]
			"98161:92560:114718:96813:111418", -- [26]
			"98161:92560:114718:111675:90556:88110:110971", -- [27]
			"98161:111420", -- [28]
			"98161:92560:114718:96813:112926", -- [29]
			"98161:92560:114718", -- [30]
			"111327:98966:96565:114666", -- [31]
			"97860:95688:100550:100468:100459:93940:114837", -- [32]
			"98108:111420:93465", -- [33]
			"98108:111420:111323:120272", -- [2]
			"98108:111420:111323:120118", -- [3]			
			["m"] = 634,
			["f"] = 0,
			["direct"] = "98161:97860:98972:111327",
			["coord"] = 3861650254,
		},
		[96813] = {
			"111624:90556", -- [1]
			"111624:90639", -- [2]
			"112866:88110", -- [3]
			"111624:93447", -- [4]
			"111624:93447:93940", -- [5]
			"111675:114666:100550:95688", -- [6]
			"114718:92560", -- [7]
			"111420:98105", -- [8]
			"114718:92560:98124", -- [9]
			"111420:98161", -- [10]
			"111675:98966:97860", -- [11]
			"111675:114666:100550:94973:97868", -- [12]
			"111675:114666:100550:97870", -- [13]
			"111675:114666:100550:94973:97868:98066", -- [14]
			"111675:96565", -- [15]
			"111675:98966", -- [16]
			"114718:92560:98124:98972", -- [17]
			"111675:114666:100468", -- [18]
			"111624:93447:100459", -- [19]
			"111675:114666:100550:94973", -- [20]
			"111675:114666:100550", -- [21]
			"111675:98966:100559", -- [22]
			"112866:108888", -- [23]
			"111420:98161:111314", -- [24]
			"114718:92560:111327", -- [25]
			"112866:88110:110971", -- [26]
			"111675:114666", -- [27]
			"111624:90639:114837", -- [28]
			"111323:93465", -- [29]
			"111675:114666:100550:98968:97868", -- [1]
			"111675:114666:100550:98968:97868:98066", -- [2]
			"111675:114666:100550:98968", -- [3]			
			"111624:93447:100459:107457", -- [1]
			"111323:120118", -- [1]
			["m"] = 627,
			["coord"] = 3012264314,
			["direct"] = "112866:111323:111675:111624:111418:111420:112926:114718",
			["f"] = 0,
		},
		[109467] = {
			"109457:109451", -- [1]
			"109469:109558", -- [2]
			"109469:109558:109561", -- [3]
			"109457:109451:109789:109572:109571", -- [4]
			"109457:109451:109789:109572", -- [5]
			"109457:109451:109789", -- [6]
			["m"] = 680,
			["f"] = 0,
			["direct"] = "109457:109469",
			["coord"] = 3014899171,
			requirements = "cls:HUNTER"
		},
		[109558] = {
			"109469:109467:109457", -- [1]
			"109469:109467:109457:109451", -- [2]
			"109469:109467", -- [3]
			"109561:109571", -- [4]
			"109561:109571:109572", -- [5]
			"109469:109467:109457:109451:109789", -- [6]
			["m"] = 630,
			["f"] = 0,
			["direct"] = "109469:109561",
			["coord"] = 2188889228,
			requirements = "cls:HUNTER"
		},
		[109469] = {
			"109467:109457", -- [1]
			"109467:109457:109451", -- [2]
			"109558:109561", -- [3]
			"109558:109561:109571", -- [4]
			"109467:109457:109451:109789:109572", -- [5]
			"109467:109457:109451:109789", -- [6]
			["m"] = 680,
			["f"] = 0,
			["direct"] = "109467:109558",
			["coord"] = 1775293492,
			requirements = "cls:HUNTER"
		},
		[109561] = {
			"109558:109469:109467:109457", -- [1]
			"109571:109572:109789:109451", -- [2]
			"109558:109469:109467", -- [3]
			"109558:109469", -- [4]
			"109571:109572", -- [5]
			"109571:109572:109789", -- [6]
			["m"] = 630,
			["f"] = 0,
			["direct"] = "109558:109571",
			["coord"] = 1053912676,
			requirements = "cls:HUNTER"
		},
		[109457] = {
			"109467:109469", -- [1]
			"109467:109469:109558", -- [2]
			"109467:109469:109558:109561", -- [3]
			"109451:109789:109572:109571", -- [4]
			"109451:109789:109572", -- [5]
			"109451:109789", -- [6]
			["m"] = 634,
			["f"] = 0,
			["direct"] = "109451:109467",
			["coord"] = 1635895994,
			requirements = "cls:HUNTER"
		},
		[109789] = {
			"109451:109457", -- [1]
			"109451:109457:109467", -- [2]
			"109451:109457:109467:109469", -- [3]
			"109451:109457:109467:109469:109558", -- [4]
			"109572:109571:109561", -- [5]
			"109572:109571", -- [6]
			["m"] = 650,
			["f"] = 0,
			["direct"] = "109451:109572",
			["coord"] = 2433723769,
			requirements = "cls:HUNTER"
		},
		[109572] = {
			"109789:109451:109457", -- [1]
			"109789:109451", -- [2]
			"109789:109451:109457:109467", -- [3]
			"109789:109451:109457:109467:109469", -- [4]
			"109571:109561:109558", -- [5]
			"109571:109561", -- [6]
			["m"] = 739,
			["direct"] = "109571:109789",
			["coord"] = 1708018224,
			["f"] = 0,
			requirements = "cls:HUNTER",
		},
		[109571] = {
			"109572:109789:109451:109457", -- [1]
			"109572:109789:109451", -- [2]
			"109572:109789:109451:109457:109467", -- [3]
			"109561:109558:109469", -- [4]
			"109561:109558", -- [5]
			"109572:109789", -- [6]
			["m"] = 641,
			["f"] = 0,
			["direct"] = "109561:109572",
			["coord"] = 1894393429,
			requirements = "cls:HUNTER"
		},
		[109451] = {
			"109457:109467", -- [1]
			"109457:109467:109469", -- [2]
			"109457:109467:109469:109558", -- [3]
			"109789:109572:109571:109561", -- [4]
			"109789:109572:109571", -- [5]
			"109789:109572", -- [6]
			["m"] = 634,
			["f"] = 0,
			["direct"] = "109457:109789",
			["coord"] = 1972394897,
			requirements = "cls:HUNTER"
		},
		[98968] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"95688:100559:92560", -- [7]
			"95688:100559:92560:98105", -- [8]
			"97860:98124", -- [9]
			"97860:98124:111327:98161", -- [10]
			"97868:98066", -- [11]
			"100550:96565", -- [12]
			"95688:98966", -- [13]
			"97868:98972", -- [14]
			"100550:100468", -- [15]
			"100550:100468:100459", -- [16]
			"100550:114666:111675:96813", -- [17]
			"95688:100559", -- [18]
			"97860:98124:111327", -- [19]
			"100550:114666:111675", -- [20]
			"100550:114666:111624", -- [21]
			"100550:114666:90639:110971", -- [22]
			"95688:100559:92560:98105:111420", -- [23]
			"100550:96565:114718", -- [24]
			"100550:114666", -- [25]
			["m"] = 739,
			["f"] = 0,
			["direct"] = "95688:97860:97868:97870:94973:100550",
			["coord"] = 1563641753,
			requirements = "cls:HUNTER"
		},
		[107457] = {
			"100459:93447:90556", -- [1]
			"93940:90639", -- [2]
			"100459:93447:90556:88110", -- [3]
			"100459:93447:90556:112866", -- [4]
			"100459:93447", -- [5]
			"100459:100468:100550:95688", -- [6]
			"100459:100468:100550:95688:100559:92560", -- [7]
			"100459:100468:100550:95688:100559:92560:98105", -- [8]
			"100459:100468:100550:95688:100559:98124", -- [9]
			"100459:100468:100550:95688:100559:92560:98161", -- [10]
			"97870:97868:97860", -- [11]
			"97870:97868", -- [12]
			"97870:98066", -- [13]
			"100459:100468:96565", -- [14]
			"100459:100468:96565:98966", -- [15]
			"97870:97868:98972", -- [16]
			"100459:100468", -- [17]
			"100459:100468:100550:94973", -- [18]
			"100459:114666:111675:96813", -- [19]
			"100459:100468:100550", -- [20]
			"100459:100468:100550:95688:100559", -- [21]
			"100459:100468:100550:95688:100559:98124:111327", -- [22]
			"100459:114666:111675", -- [23]
			"100459:93447:111624", -- [24]
			"93940:90639:110971", -- [25]
			"100459:114666:111675:114718:111420", -- [26]
			"100459:114666:111675:114718", -- [27]
			"100459:114666", -- [28]
			["m"] = 747,
			["coord"] = 2676053642,
			["direct"] = "93940:97870:100459",
			["f"] = 0,
			requirements = "cls:DRUID"
		},		
	},	
	[9] = {
		[118830] = {
			--["name"] = "Krokul Hovel, Krokuun",
			["direct"] = "123139:123260:124569:124313:122509:125407:125410:126951",
			["m"] = 830,
			["coord"] = 2383064171,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125461] = {
			--["name"] = "Vindicaar, Mac'Aree",
			["direct"] = "118830:123139:123260:124569:124313:122509:125407:125410:125514:126951",
			["m"] = 883,
			["coord"] = 2091072516,
			["f"] = 0,
			["isSpaceship"] = true,
		},
		[122509] = {
			--["name"] = "Triumvirate's End, Mac'Aree",
			["direct"] = "118830:123260:124569:125461:124313:125407:125410:126951",
			["m"] = 882,
			["coord"] = 2270347563,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[123260] = {
			--["name"] = "Shattered Fields, Krokuun",
			["direct"] = "118830:123139:124569:124313:122509:125407:125410:126951",
			["m"] = 830,
			["coord"] = 1731109521,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[126951] = {
			--["name"] = "City Center, Mac'Aree",
			["direct"] = "118830:123260:124569:125461:124313:122509:125407:125410",
			["m"] = 882,
			["coord"] = 2020118034,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125407] = {
			--["name"] = "Hope's Landing, Antoran Wastes",
			["direct"] = "118830:123260:124569:124313:122509:125410:125514:126951",
			["m"] = 885,
			["coord"] = 3133768023,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[124313] = {
			--["name"] = "Conservatory of the Arcane, Mac'Aree",
			["direct"] = "118830:123260:124569:125461:122509:125407:125410:126951",
			["m"] = 882,
			["coord"] = 2699191586,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[124569] = {
			--["name"] = "Destiny Point, Krokuun",
			["direct"] = "118830:123139:123260:124313:122509:125407:125410:126951",
			["m"] = 830,
			["coord"] = 2692513213,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125410] = { --Dynamic
			--["name"] = "Light's Purchase, Antoran Wastes",
			["direct"] = "118830:123260:124569:124313:122509:125407:125514:126951",
			["m"] = 885,
			["coord"] = 3119956734,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125514] = {
			--["name"] = "Vindicaar, Antoran Wastes",
			["direct"] = "118830:123139:123260:124569:125461:124313:122509:125407:125410:126951",
			["m"] = 886,
			["coord"] = 1407291736,
			["f"] = 0,
			["isSpaceship"] = true,
		},
		[123139] = {
			["m"] = 831,
			["direct"] = "118830:123260:124569:125461:124313:122509:125407:125410:125514:126951",
			["coord"] = 1809529829,
			["f"] = 0,
			["isSpaceship"] = true,
		},
		[125409] = { --Dynamic
            --["name"] = "The Veiled Den, Antoran Wastes",
			["m"] = 885,
			["f"] = 0,
			["direct"] = "118830:123260:124569:124313:122509:125407:125514:126951",
			["coord"] = 3034464598,
			["isBeacon"] = true,
		}, 
	},
	[875] = {
		[128695] = {
			"129365:124107:121828", -- [1]
			"129365:124107:122191", -- [2]
			"129365:124107:122191:121207", -- [3]
			"129365:124107:122191:121207:122198", -- [4]
			"129365:135654:128334:130787:122689:121252", -- [5]
			"129365:135654:128334:130787:122689", -- [6]
			"129365:124107:121828:123006", -- [7]
			"129365:135654:128334:130787:122689:123060", -- [8]
			"129365:135654:128334:130787:122689:127818:123817", -- [9]
			"129365:124107:122191:121207:124456", -- [10]
			"129365:135654:128334:130787:122689:127818", -- [11]
			"129365:135654:128334:130787:129483", -- [12]
			"129365:135654:128334:130787", -- [13]
			"129365:135654:128334:130787:130790", -- [14]
			"129365:135654:128334:130787:133242", -- [15]
			"129365:135654:128334:130787:122689:121252:134008", -- [16]
			"129365:135654:128334:130787:122689:123060:134011", -- [17]
			"129365:124107", -- [18]
			"129365:135654:128334", -- [19]
			"135385:135387", -- [20]
			"129365:124107:121828:123006:136331", -- [21]
			"129365:135654", -- [22]
			"129365:135654:128334:130787:122689:121252:140653:140650", -- [23]
			"129365:135654:128334:130787:122689:121252:140653", -- [24]
			["m"] = 864,
			["direct"] = "135385:129365",
			["coord"] = 1187873011,
			["f"] = 0,
		},	
		[130790] = {
			"130787:121828", -- [1]
			"130787:121828:122191", -- [2]
			"130787:121828:121207", -- [3]
			"130787:121828:121207:122198", -- [4]
			"122689:121252", -- [5]
			"130787:123006", -- [6]
			"122689:123060", -- [7]
			"122689:127818:123817", -- [8]
			"130787:123006:124456", -- [9]
			"122689:127818", -- [10]
			"122689:133242", -- [11]
			"122689:121252:134008", -- [12]
			"122689:123060:134011", -- [13]
			"130787:121828:124107:135385", -- [14]
			"130787:121828:124107", -- [15]
			"130787:128334", -- [16]
			"130787:128334:135654:129365:128695", -- [17]
			"130787:121828:122191:135387", -- [18]
			"122689:133242:136331", -- [19]
			"130787:128334:135654", -- [20]
			"130787:128334:135654:129365", -- [21]
			"122689:121252:140653:140650", -- [22]
			"122689:121252:140653", -- [23]
			["m"] = 862,
			["direct"] = "122689:129483:130787",
			["coord"] = 1982028733,
			["f"] = 0,
		},	
		[134011] = {
			"136331:123006:121828", -- [1]
			"136331:123006:121828:122191", -- [2]
			"124456:121207", -- [3]
			"124456:121207:122198", -- [4]
			"123060:121252", -- [5]
			"123060:122689", -- [6]
			"136331:123006", -- [7]
			"123060:121252:127818:123817", -- [8]
			"123060:121252:127818", -- [9]
			"123060:133242:129483", -- [10]
			"123060:133242:130787", -- [11]
			"123060:133242", -- [12]
			"136331:123006:121828:124107:135385", -- [13]
			"136331:123006:121828:124107", -- [14]
			"123060:133242:130787:128334", -- [15]
			"136331:123006:121828:124107:129365:128695", -- [16]
			"136331:123006:121828:122191:135387", -- [17]
			"123060:133242:130787:128334:135654", -- [18]
			"136331:123006:121828:124107:129365", -- [19]
			"123060:121252:140653:140650", -- [20]
			"123060:121252:140653", -- [21]
			"123060:122689:130790", -- [22]
			--["name"] = "Atal'Gral, Zuldazar",
			["direct"] = "123060:124456:134008:136331",
			["f"] = 0,
			["m"] = 862,
			["coord"] = 3434703392,
		},
		[123817] = {
			"127818:129483:130787:121828", -- [1]
			"127818:129483:130787:121828:122191", -- [2]
			"127818:122689:133242:123006:121207", -- [3]
			"127818:122689:133242:123006:121207:122198", -- [4]
			"127818:121252", -- [5]
			"127818:122689", -- [6]
			"127818:122689:133242:123006", -- [7]
			"127818:122689:123060", -- [8]
			"127818:122689:133242:136331:124456", -- [9]
			"127818:129483", -- [10]
			"127818:129483:130787", -- [11]
			"127818:122689:133242", -- [12]
			"127818:121252:134008", -- [13]
			"127818:122689:123060:134011", -- [14]
			"127818:129483:130787:121828:124107:135385", -- [15]
			"127818:129483:130787:121828:124107", -- [16]
			"127818:129483:130787:128334", -- [17]
			"127818:129483:130787:128334:135654:129365:128695", -- [18]
			"127818:129483:130787:121828:122191:135387", -- [19]
			"127818:122689:133242:136331", -- [20]
			"127818:129483:130787:128334:135654", -- [21]
			"127818:129483:130787:128334:135654:129365", -- [22]
			"140650:140653", -- [23]
			"127818:129483:130790", -- [24]
			--["name"] = "Xibala, Zuldazar",
			["direct"] = "127818:140650",
			["coord"] = 1925757125,
			["m"] = 862,
			["f"] = 0,
		},
		[140653] = {
			"121252:129483:130787:121828", -- [1]
			"121252:129483:130787:121828:122191", -- [2]
			"121252:122689:133242:123006:121207", -- [3]
			"121252:122689:133242:123006:121207:122198", -- [4]
			"121252:122689", -- [5]
			"121252:122689:133242:123006", -- [6]
			"121252:123060", -- [7]
			"140650:123817", -- [8]
			"121252:136331:124456", -- [9]
			"121252:127818", -- [10]
			"121252:129483", -- [11]
			"121252:129483:130787", -- [12]
			"121252:122689:133242", -- [13]
			"134008:134011", -- [14]
			"121252:129483:130787:121828:124107:135385", -- [15]
			"121252:129483:130787:121828:124107", -- [16]
			"121252:129483:130787:128334", -- [17]
			"121252:129483:130787:128334:135654:129365:128695", -- [18]
			"121252:129483:130787:121828:122191:135387", -- [19]
			"121252:136331", -- [20]
			"121252:129483:130787:128334:135654", -- [21]
			"121252:129483:130787:128334:135654:129365", -- [22]
			--["name"] = "Tusk Isle, Zuldazar",
			["direct"] = "121252:134008:140650",
			["coord"] = 2549204879,
			["m"] = 862,
			["f"] = 0,
		},
		[135387] = {
			"122191:121828", -- [1]
			"122191:121207", -- [2]
			"122191:121207:122198", -- [3]
			"122191:121828:130787:122689:121252", -- [4]
			"122191:121828:130787:122689", -- [5]
			"122191:121828:123006", -- [6]
			"122191:121828:133242:123060", -- [7]
			"122191:121828:130787:122689:127818:123817", -- [8]
			"122191:121207:124456", -- [9]
			"122191:121828:130787:122689:127818", -- [10]
			"122191:121828:130787:129483", -- [11]
			"122191:121828:130787", -- [12]
			"122191:121828:133242", -- [13]
			"122191:121828:130787:122689:121252:134008", -- [14]
			"122191:121207:124456:134011", -- [15]
			"124107:128334", -- [16]
			"135385:128695", -- [17]
			"122191:121828:123006:136331", -- [18]
			"124107:129365:135654", -- [19]
			"124107:129365", -- [20]
			"122191:121828:130787:122689:121252:140653:140650", -- [21]
			"122191:121828:130787:122689:121252:140653", -- [22]
			"122191:121828:130787:130790", -- [23]
			--["name"] = "Tortaka Refuge, Vol'dun",
			["direct"] = "122191:135385:124107",
			["f"] = 0,
			["m"] = 864,
			["coord"] = 2656712569,
		},
		[121252] = {
			"129483:130787:121828", -- [1]
			"129483:130787:121828:122191", -- [2]
			"122689:133242:123006:121207", -- [3]
			"122689:133242:123006:121207:122198", -- [4]
			"122689:133242:123006", -- [5]
			"127818:123817", -- [6]
			"136331:124456", -- [7]
			"129483:130787", -- [8]
			"122689:133242", -- [9]
			"123060:134011", -- [10]
			"129483:130787:121828:124107:135385", -- [11]
			"129483:130787:121828:124107", -- [12]
			"129483:130787:128334", -- [13]
			"129483:130787:128334:135654:129365:128695", -- [14]
			"129483:130787:121828:122191:135387", -- [15]
			"129483:130787:128334:135654", -- [16]
			"129483:130787:128334:135654:129365", -- [17]
			"140653:140650", -- [18]
			"129483:130790", -- [19]
			--["name"] = "Port of Zandalar, Zuldazar",
			["direct"] = "122689:123060:127818:129483:134008:136331:140653",
			["f"] = 0,
			["m"] = 1165,
			["coord"] = 2237261376,
			["requirements"] = "qid:52131",
		},
		[134008] = {
			"134011:136331:123006:121828", -- [1]
			"134011:136331:123006:121828:122191", -- [2]
			"134011:124456:121207", -- [3]
			"134011:124456:121207:122198", -- [4]
			"121252:122689", -- [5]
			"134011:136331:123006", -- [6]
			"134011:123060", -- [7]
			"140653:140650:123817", -- [8]
			"134011:124456", -- [9]
			"121252:127818", -- [10]
			"121252:129483", -- [11]
			"121252:129483:130787", -- [12]
			"121252:122689:133242", -- [13]
			"134011:136331:123006:121828:124107:135385", -- [14]
			"134011:136331:123006:121828:124107", -- [15]
			"121252:129483:130787:128334", -- [16]
			"121252:129483:130787:128334:135654:129365:128695", -- [17]
			"134011:136331:123006:121828:122191:135387", -- [18]
			"134011:136331", -- [19]
			"121252:129483:130787:128334:135654", -- [20]
			"121252:129483:130787:128334:135654:129365", -- [21]
			"140653:140650", -- [22]
			"121252:129483:130790", -- [23]
			--["name"] = "Seeker's Outpost, Zuldazar",
			["direct"] = "121252:134011:140653",
			["coord"] = 3025839895,
			["m"] = 862,
			["f"] = 0,
		},
		[140650] = {
			"123817:127818:129483:130787:121828", -- [1]
			"123817:127818:129483:130787:121828:122191", -- [2]
			"123817:127818:122689:133242:123006:121207", -- [3]
			"123817:127818:122689:133242:123006:121207:122198", -- [4]
			"140653:121252", -- [5]
			"123817:127818:122689", -- [6]
			"123817:127818:122689:133242:123006", -- [7]
			"140653:121252:123060", -- [8]
			"140653:121252:136331:124456", -- [9]
			"123817:127818", -- [10]
			"123817:127818:129483", -- [11]
			"123817:127818:129483:130787", -- [12]
			"123817:127818:122689:133242", -- [13]
			"140653:134008", -- [14]
			"140653:134008:134011", -- [15]
			"123817:127818:129483:130787:121828:124107:135385", -- [16]
			"123817:127818:129483:130787:121828:124107", -- [17]
			"123817:127818:129483:130787:128334", -- [18]
			"123817:127818:129483:130787:128334:135654:129365:128695", -- [19]
			"123817:127818:129483:130787:121828:122191:135387", -- [20]
			"140653:121252:136331", -- [21]
			"123817:127818:129483:130787:128334:135654", -- [22]
			"123817:127818:129483:130787:128334:135654:129365", -- [23]
			--["name"] = "Isle of Fangs, Zuldazar",
			["direct"] = "123817:140653",
			["coord"] = 2337726145,
			["m"] = 862,
			["f"] = 0,
		},
		[123060] = {
			"136331:123006:121828", -- [1]
			"136331:123006:121828:122191", -- [2]
			"136331:123006:121207", -- [3]
			"136331:123006:121207:122198", -- [4]
			"136331:123006", -- [5]
			"121252:127818:123817", -- [6]
			"136331:124456", -- [7]
			"121252:127818", -- [8]
			"133242:129483", -- [9]
			"133242:130787", -- [10]
			"121252:134008", -- [11]
			"136331:123006:121828:124107:135385", -- [12]
			"136331:123006:121828:124107", -- [13]
			"133242:130787:128334", -- [14]
			"133242:130787:128334:135654:129365:128695", -- [15]
			"136331:123006:121828:122191:135387", -- [16]
			"133242:130787:128334:135654", -- [17]
			"133242:130787:128334:135654:129365", -- [18]
			"121252:140653:140650", -- [19]
			"121252:140653", -- [20]
			"122689:130790", -- [21]
			--["name"] = "Warbeast Kraal, Zuldazar",
			["direct"] = "121252:122689:133242:134011:136331",
			["f"] = 0,
			["m"] = 862,
			["coord"] = 2887740943,
		},
		[128334] = {
			"130787:121828", -- [1]
			"124107:122191", -- [2]
			"124107:122191:121207", -- [3]
			"124107:122191:121207:122198", -- [4]
			"130787:122689:121252", -- [5]
			"130787:122689", -- [6]
			"130787:123006", -- [7]
			"130787:122689:123060", -- [8]
			"130787:122689:127818:123817", -- [9]
			"130787:123006:124456", -- [10]
			"130787:122689:127818", -- [11]
			"130787:129483", -- [12]
			"130787:133242", -- [13]
			"130787:122689:121252:134008", -- [14]
			"130787:122689:123060:134011", -- [15]
			"124107:135385", -- [16]
			"135654:129365:128695", -- [17]
			"124107:135387", -- [18]
			"130787:133242:136331", -- [19]
			"135654:129365", -- [20]
			"130787:122689:121252:140653:140650", -- [21]
			"130787:122689:121252:140653", -- [22]
			"130787:130790", -- [21]
			--["name"] = "Temple of Akunda, Vol'dun",
			["direct"] = "130787:124107:135654",
			["f"] = 0,
			["m"] = 864,
			["coord"] = 2307384439,
		},
		[129483] = {
			"130787:121828", -- [1]
			"130787:121828:122191", -- [2]
			"133242:123006:121207", -- [3]
			"133242:123006:121207:122198", -- [4]
			"133242:123006", -- [5]
			"122689:123060", -- [6]
			"127818:123817", -- [7]
			"133242:136331:124456", -- [8]
			"121252:134008", -- [9]
			"122689:123060:134011", -- [10]
			"130787:121828:124107:135385", -- [11]
			"130787:121828:124107", -- [12]
			"130787:128334", -- [13]
			"130787:128334:135654:129365:128695", -- [14]
			"130787:121828:122191:135387", -- [15]
			"133242:136331", -- [16]
			"130787:128334:135654", -- [17]
			"130787:128334:135654:129365", -- [18]
			"121252:140653:140650", -- [19]
			"121252:140653", -- [20]
			--["name"] = "Temple of the Prophet, Zuldazar",
			["direct"] = "121252:122689:127818:130787:133242",
			["f"] = 0,
			["m"] = 862,
			["coord"] = 2137289216,
		},
		[123006] = {
			"121828:122191", -- [1]
			"121207:122198", -- [2]
			"136331:121252", -- [3]
			"133242:122689", -- [4]
			"136331:123060", -- [5]
			"133242:122689:127818:123817", -- [6]
			"133242:122689:127818", -- [7]
			"133242:129483", -- [8]
			"136331:121252:134008", -- [9]
			"136331:134011", -- [10]
			"121828:124107:135385", -- [11]
			"121828:124107", -- [12]
			"130787:128334", -- [13]
			"121828:124107:129365:128695", -- [14]
			"121828:122191:135387", -- [15]
			"130787:128334:135654", -- [16]
			"121828:124107:129365", -- [17]
			"136331:121252:140653:140650", -- [18]
			"136331:121252:140653", -- [19]
			"130787:130790", -- [20]
			--["name"] = "Nesingwary's Gameland, Zuldazar",
			["direct"] = "121828:121207:124456:130787:133242:136331",
			["coord"] = 2844863786,
			["m"] = 862,
			["f"] = 0,
		},
		[129365] = {
			"124107:121828", -- [1]
			"124107:122191", -- [2]
			"124107:122191:121207", -- [3]
			"124107:122191:121207:122198", -- [4]
			"135654:128334:130787:122689:121252", -- [5]
			"135654:128334:130787:122689", -- [6]
			"124107:121828:123006", -- [7]
			"135654:128334:130787:122689:123060", -- [8]
			"135654:128334:130787:122689:127818:123817", -- [9]
			"124107:122191:121207:124456", -- [10]
			"135654:128334:130787:122689:127818", -- [11]
			"135654:128334:130787:129483", -- [12]
			"135654:128334:130787", -- [13]
			"135654:128334:130787:133242", -- [14]
			"135654:128334:130787:122689:121252:134008", -- [15]
			"135654:128334:130787:122689:123060:134011", -- [16]
			"135654:128334", -- [17]
			"124107:135387", -- [18]
			"124107:121828:123006:136331", -- [19]
			"135654:128334:130787:122689:121252:140653:140650", -- [20]
			"135654:128334:130787:122689:121252:140653", -- [21]
			"135654:128334:130787:130790", -- [22]
			--["name"] = "Goldtusk Inn, Vol'dun",
			["direct"] = "135385:124107:128695:135654",
			["f"] = 0,
			["m"] = 864,
			["coord"] = 1835965584,
		},
		[133242] = {
			"121828:122191", -- [1]
			"123006:121207", -- [2]
			"123006:121207:122198", -- [3]
			"122689:121252", -- [4]
			"122689:127818:123817", -- [5]
			"136331:124456", -- [6]
			"122689:127818", -- [7]
			"122689:121252:134008", -- [8]
			"123060:134011", -- [9]
			"121828:124107:135385", -- [10]
			"121828:124107", -- [11]
			"130787:128334", -- [12]
			"130787:128334:135654:129365:128695", -- [13]
			"121828:122191:135387", -- [14]
			"130787:128334:135654", -- [15]
			"130787:128334:135654:129365", -- [16]
			"122689:121252:140653:140650", -- [17]
			"122689:121252:140653", -- [18]
			"122689:130790", -- [19]
			--["name"] = "The Sliver, Zuldazar",
			["direct"] = "121828:122689:123006:123060:129483:130787:136331",
			["f"] = 0,
			["m"] = 1165,
			["coord"] = 2281648464,
		},
		[135385] = {
			"124107:121828", -- [1]
			"124107:122191", -- [2]
			"124107:122191:121207", -- [3]
			"124107:122191:121207:122198", -- [4]
			"124107:121828:130787:122689:121252", -- [5]
			"124107:121828:130787:122689", -- [6]
			"124107:121828:123006", -- [7]
			"124107:121828:133242:123060", -- [8]
			"124107:121828:130787:122689:127818:123817", -- [9]
			"124107:122191:121207:124456", -- [10]
			"124107:121828:130787:122689:127818", -- [11]
			"124107:121828:130787:129483", -- [12]
			"124107:121828:130787", -- [13]
			"124107:121828:133242", -- [14]
			"124107:121828:130787:122689:121252:134008", -- [15]
			"124107:121828:123006:136331:134011", -- [16]
			"124107:128334", -- [17]
			"124107:121828:123006:136331", -- [18]
			"129365:135654", -- [19]
			"124107:121828:130787:122689:121252:140653:140650", -- [20]
			"124107:121828:130787:122689:121252:140653", -- [21]
			"124107:121828:130787:130790", -- [22]
			--["name"] = "Vorrik's Sanctum, Vol'dun",
			["direct"] = "124107:128695:135387:129365",
			["f"] = 0,
			["m"] = 864,
			["coord"] = 2029869576,
		},
		[127818] = {
			"129483:130787:121828", -- [1]
			"129483:130787:121828:122191", -- [2]
			"122689:133242:123006:121207", -- [3]
			"122689:133242:123006:121207:122198", -- [4]
			"122689:133242:123006", -- [5]
			"122689:123060", -- [6]
			"122689:133242:136331:124456", -- [7]
			"129483:130787", -- [8]
			"122689:133242", -- [9]
			"121252:134008", -- [10]
			"122689:123060:134011", -- [11]
			"129483:130787:121828:124107:135385", -- [12]
			"129483:130787:121828:124107", -- [13]
			"129483:130787:128334", -- [14]
			"129483:130787:128334:135654:129365:128695", -- [15]
			"129483:130787:121828:122191:135387", -- [16]
			"122689:133242:136331", -- [17]
			"129483:130787:128334:135654", -- [18]
			"129483:130787:128334:135654:129365", -- [19]
			"123817:140650", -- [20]
			"121252:140653", -- [21]
			--["name"] = "Warport Rastari, Zuldazar",
			["direct"] = "121252:122689:123817:129483",
			["f"] = 0,
			["m"] = 862,
			["coord"] = 2070846044,
		},
		[136331] = {
			"123006:121828", -- [1]
			"123006:121828:122191", -- [2]
			"123006:121207", -- [3]
			"123006:121207:122198", -- [4]
			"133242:122689", -- [5]
			"121252:127818:123817", -- [6]
			"121252:127818", -- [7]
			"133242:129483", -- [8]
			"133242:130787", -- [9]
			"121252:134008", -- [10]
			"123006:121828:124107:135385", -- [11]
			"123006:121828:124107", -- [12]
			"133242:130787:128334", -- [13]
			"123006:121828:124107:129365:128695", -- [14]
			"123006:121828:122191:135387", -- [15]
			"133242:130787:128334:135654", -- [16]
			"123006:121828:124107:129365", -- [17]
			"121252:140653:140650", -- [18]
			"121252:140653", -- [19]
			"133242:122689:130790", -- [20]
			--["name"] = "Scaletrader Post, Zuldazar",
			["direct"] = "121252:123006:123060:124456:133242:134011",
			["f"] = 0,
			["m"] = 862,
			["coord"] = 3040037831,
		},
		[130787] = {
			"121828:122191", -- [1]
			"121828:121207", -- [2]
			"121828:121207:122198", -- [3]
			"122689:121252", -- [4]
			"122689:123060", -- [5]
			"122689:127818:123817", -- [6]
			"123006:124456", -- [7]
			"122689:127818", -- [8]
			"122689:121252:134008", -- [9]
			"122689:123060:134011", -- [10]
			"121828:124107:135385", -- [11]
			"121828:124107", -- [12]
			"128334:135654:129365:128695", -- [13]
			"121828:122191:135387", -- [14]
			"133242:136331", -- [15]
			"128334:135654", -- [16]
			"128334:135654:129365", -- [17]
			"122689:121252:140653:140650", -- [18]
			"122689:121252:140653", -- [19]
			--["name"] = "Garden of the Loa, Zuldazar",
			["direct"] = "121828:122689:123006:129483:133242:128334:130790",
			["f"] = 0,
			["m"] = 862,
			["coord"] = 2135114573,
		},
		[122689] = {
			"130787:121828", -- [1]
			"130787:121828:122191", -- [2]
			"133242:123006:121207", -- [3]
			"133242:123006:121207:122198", -- [4]
			"133242:123006", -- [5]
			"127818:123817", -- [6]
			"133242:136331:124456", -- [7]
			"121252:134008", -- [8]
			"123060:134011", -- [9]
			"130787:121828:124107:135385", -- [10]
			"130787:121828:124107", -- [11]
			"130787:128334", -- [12]
			"130787:128334:135654:129365:128695", -- [13]
			"130787:121828:122191:135387", -- [14]
			"133242:136331", -- [15]
			"130787:128334:135654", -- [16]
			"130787:128334:135654:129365", -- [17]
			"121252:140653:140650", -- [18]
			"121252:140653", -- [19]
			--["name"] = "The Great Seal",
			["direct"] = "121252:123060:127818:129483:130787:130790:133242",
			["coord"] = 2227202436,
			["m"] = 1165,
			["f"] = 0,
		},
		[122191] = {
			"121207:122198", -- [1]
			"121828:130787:122689:121252", -- [2]
			"121828:130787:122689", -- [3]
			"121828:123006", -- [4]
			"121828:133242:123060", -- [5]
			"121828:130787:122689:127818:123817", -- [6]
			"121207:124456", -- [7]
			"121828:130787:122689:127818", -- [8]
			"121828:130787:129483", -- [9]
			"121828:130787", -- [10]
			"121828:133242", -- [11]
			"121828:130787:122689:121252:134008", -- [12]
			"121207:124456:134011", -- [13]
			"124107:135385", -- [14]
			"124107:128334", -- [15]
			"124107:129365:128695", -- [16]
			"121828:123006:136331", -- [17]
			"124107:129365:135654", -- [18]
			"124107:129365", -- [19]
			"121828:130787:122689:121252:140653:140650", -- [20]
			"121828:130787:122689:121252:140653", -- [21]
			"121828:130787:130790", -- [22]
			--["name"] = "Zo'bal Ruins, Nazmir",
			["direct"] = "121828:121207:124107:135387",
			["coord"] = 1725394360,
			["m"] = 863,
			["f"] = 0,
		},
		[124456] = {
			"123006:121828", -- [1]
			"121207:122191", -- [2]
			"121207:122198", -- [3]
			"136331:121252", -- [4]
			"136331:133242:122689", -- [5]
			"136331:123060", -- [6]
			"136331:121252:127818:123817", -- [7]
			"136331:121252:127818", -- [8]
			"136331:133242:129483", -- [9]
			"123006:130787", -- [10]
			"136331:133242", -- [11]
			"134011:134008", -- [12]
			"123006:121828:124107:135385", -- [13]
			"123006:121828:124107", -- [14]
			"123006:130787:128334", -- [15]
			"123006:121828:124107:129365:128695", -- [16]
			"121207:122191:135387", -- [17]
			"123006:130787:128334:135654", -- [18]
			"123006:121828:124107:129365", -- [19]
			"136331:121252:140653:140650", -- [20]
			"136331:121252:140653", -- [21]
			--["name"] = "Zeb'ahari, Zuldazar",
			["direct"] = "121207:123006:134011:136331",
			["f"] = 0,
			["m"] = 862,
			["coord"] = 3321243475,
		},
		[121828] = {
			"121207:122198", -- [1]
			"130787:122689:121252", -- [2]
			"130787:122689", -- [3]
			"133242:123060", -- [4]
			"130787:122689:127818:123817", -- [5]
			"123006:124456", -- [6]
			"130787:122689:127818", -- [7]
			"130787:129483", -- [8]
			"130787:122689:121252:134008", -- [9]
			"123006:136331:134011", -- [10]
			"124107:135385", -- [11]
			"130787:128334", -- [12]
			"124107:129365:128695", -- [13]
			"122191:135387", -- [14]
			"123006:136331", -- [15]
			"130787:128334:135654", -- [16]
			"124107:129365", -- [17]
			"130787:122689:121252:140653:140650", -- [18]
			"130787:122689:121252:140653", -- [19]
			--["name"] = "Zul'jan, Nazmir",
			["direct"] = "122191:121207:123006:130787:133242:124107",
			["f"] = 0,
			["m"] = 863,
			["coord"] = 1672464344,
		},
		[135654] = {
			"128334:130787:121828", -- [1]
			"129365:124107:122191", -- [2]
			"129365:124107:122191:121207", -- [3]
			"129365:124107:122191:121207:122198", -- [4]
			"128334:130787:122689:121252", -- [5]
			"128334:130787:122689", -- [6]
			"128334:130787:123006", -- [7]
			"128334:130787:122689:123060", -- [8]
			"128334:130787:122689:127818:123817", -- [9]
			"128334:130787:123006:124456", -- [10]
			"128334:130787:122689:127818", -- [11]
			"128334:130787:129483", -- [12]
			"128334:130787", -- [13]
			"128334:130787:133242", -- [14]
			"128334:130787:122689:121252:134008", -- [15]
			"128334:130787:122689:123060:134011", -- [16]
			"129365:135385", -- [17]
			"129365:124107", -- [18]
			"129365:128695", -- [19]
			"129365:124107:135387", -- [20]
			"128334:130787:133242:136331", -- [21]
			"128334:130787:122689:121252:140653:140650", -- [22]
			"128334:130787:122689:121252:140653", -- [23]
			"128334:130787:130790", -- [24]
			--["name"] = "Scorched Sands Outpost, Vol'dun",
			["direct"] = "128334:129365",
			["f"] = 0,
			["m"] = 864,
			["coord"] = 1885520539,
		},
		[121207] = {
			"123006:136331:121252", -- [1]
			"123006:133242:122689", -- [2]
			"123006:136331:123060", -- [3]
			"123006:133242:122689:127818:123817", -- [4]
			"123006:133242:122689:127818", -- [5]
			"123006:133242:129483", -- [6]
			"121828:130787", -- [7]
			"123006:133242", -- [8]
			"124456:134011:134008", -- [9]
			"124456:134011", -- [10]
			"122191:124107:135385", -- [11]
			"122191:124107", -- [12]
			"121828:130787:128334", -- [13]
			"122191:124107:129365:128695", -- [14]
			"122191:135387", -- [15]
			"123006:136331", -- [16]
			"122191:124107:129365:135654", -- [17]
			"122191:124107:129365", -- [18]
			"123006:136331:121252:140653:140650", -- [19]
			"123006:136331:121252:140653", -- [20]
			"121828:130787:130790", -- [21]
			["m"] = 863,
			["direct"] = "121828:122191:122198:123006:124456",
			["coord"] = 2877517751,
			["f"] = 0,
		},
		[124107] = {
			"122191:121207", -- [1]
			"122191:121207:122198", -- [2]
			"121828:130787:122689:121252", -- [3]
			"121828:130787:122689", -- [4]
			"121828:123006", -- [5]
			"121828:133242:123060", -- [6]
			"121828:130787:122689:127818:123817", -- [7]
			"122191:121207:124456", -- [8]
			"121828:130787:122689:127818", -- [9]
			"121828:130787:129483", -- [10]
			"121828:130787", -- [11]
			"121828:133242", -- [12]
			"121828:130787:122689:121252:134008", -- [13]
			"121828:123006:136331:134011", -- [14]
			"129365:128695", -- [15]
			"121828:123006:136331", -- [16]
			"129365:135654", -- [17]
			"121828:130787:122689:121252:140653:140650", -- [18]
			"121828:130787:122689:121252:140653", -- [19]
			"121828:130787:130790", -- [20]
			--["name"] = "Vulpera Hideaway, Vol'dun",
			["direct"] = "121828:122191:135385:128334:135387:129365",
			["f"] = 0,
			["m"] = 864,
			["coord"] = 2446622267,
		},
		[122198] = {
			"121207:121828", -- [1]
			"121207:122191", -- [2]
			"121207:123006:136331:121252", -- [3]
			"121207:123006:133242:122689", -- [4]
			"121207:123006", -- [5]
			"121207:123006:136331:123060", -- [6]
			"121207:123006:133242:122689:127818:123817", -- [7]
			"121207:124456", -- [8]
			"121207:123006:133242:122689:127818", -- [9]
			"121207:123006:133242:129483", -- [10]
			"121207:121828:130787", -- [11]
			"121207:123006:133242", -- [12]
			"121207:124456:134011:134008", -- [13]
			"121207:124456:134011", -- [14]
			"121207:122191:124107:135385", -- [15]
			"121207:122191:124107", -- [16]
			"121207:121828:130787:128334", -- [17]
			"121207:122191:124107:129365:128695", -- [18]
			"121207:122191:135387", -- [19]
			"121207:123006:136331", -- [20]
			"121207:122191:124107:129365:135654", -- [21]
			"121207:122191:124107:129365", -- [22]
			"121207:123006:136331:121252:140653:140650", -- [23]
			"121207:123006:136331:121252:140653", -- [24]
			"121207:121828:130787:130790", -- [1]
			--["name"] = "Forlorn Ruins, Nazmir",
			["direct"] = "121207",
			["m"] = 863,
			["f"] = 0,
			["coord"] = 3526706255,
		},
		[127427] = {
			"130787:121828", -- [1]
			"124107:122191", -- [2]
			"124107:122191:121207", -- [3]
			"124107:122191:121207:122198", -- [4]
			"130787:122689:121252", -- [5]
			"130787:122689", -- [6]
			"130787:123006", -- [7]
			"130787:122689:123060", -- [8]
			"130787:122689:127818:123817", -- [9]
			"130787:123006:124456", -- [10]
			"130787:122689:127818", -- [11]
			"130787:129483", -- [12]
			"130787:130790", -- [13]
			"130787:133242", -- [14]
			"130787:122689:121252:134008", -- [15]
			"130787:122689:123060:134011", -- [16]
			"130787:133242:136331", -- [17]
			"130787:122689:121252:140653:140650", -- [18]
			"130787:122689:121252:140653", -- [19]
			["m"] = 864,
			["coord"] = 2304894035,
			["direct"] = "130787:124107",
			["f"] = 0,
		},		
	},
	[876] = {
		[138022] = {
			"2007284134:2160243705:129098", -- [1]
			"1924041156:133861", -- [2]
			"2007284134:2160243705:129098:128224", -- [3]
			"135025:142740:2127384098:137318", -- [4]
			"1924041156:2381474700:2393595189:134848", -- [5]
			"1924041156:2381474700:2393595189:134850", -- [6]
			"1924041156:2381474700:2393595189:134848:138097", -- [7]
			"1924041156:2381474700:2393595189:134850:134853", -- [8]
			"1924041156:133861:138265", -- [9]
			"135025:142740", -- [10]
			"1924041156:2381474700:134842:134848", -- [6]
			"1924041156:2381474700:134842:134850", -- [7]
			"1924041156:2381474700:134842:134848:138097", -- [8]
			"1924041156:2381474700:134842:134850:134853", -- [9]			
			"1898220961:133861:138265:143548", -- [10]
			"135025:150634", -- [11]			
			--["name"] = "Krazzlefrazz Outpost, Drustvar",
			["m"] = 896,
			["coord"] = 1604730323,
			["direct"] = "135025:135988",
			["f"] = 0,
		},
		[135988] = {
			"2007284134:2160243705:129098", -- [1]
			"2007284134:2160243705:133861", -- [2]
			"2007284134:2160243705:129098:128224", -- [3]
			"135025:142740:2127384098:137318", -- [4]
			"135025:142740:2127384098:134848", -- [5]
			"135025:142740:2381474700:2393595189:134850", -- [6]
			"135025:142740:2127384098:137318:138097", -- [7]
			"135025:142740:2381474700:2393595189:134850:134853", -- [8]
			"2007284134:2160243705:133861:138265", -- [9]
			"135025:142740", -- [10]
			--["name"] = "Anyport, Drustvar",
			["m"] = 896,
			["coord"] = 823619296,
			["direct"] = "135025:138022",
			["f"] = 0,
		},
		[142740] = {
			"1924041156:133861:129098", -- [1]
			"1924041156:133861", -- [2]
			"1924041156:133861:128224", -- [3]
			"2127384098:137318", -- [4]
			"2127384098:134848", -- [5]
			"2381474700:2393595189:134850", -- [6]
			"2127384098:137318:138097", -- [7]
			"2381474700:2393595189:134850:134853", -- [8]
			"135025:135988", -- [9]
			"1924041156:138022", -- [10]
			"1924041156:133861:138265", -- [11]
			"140939:133861:129098", -- [1]
			"140939:133861", -- [2]
			"140939:133861:128224", -- [3]			
			"140939:133861:1`38265", -- [12]
			"140939:2007284134", -- [13]
			"140939:2007284134:2160243705", -- [14]			
			"140939:138022", -- [10]	
			"1898220961:133861:129098", -- [1]
			"1898220961:133861", -- [2]
			"1898220961:133861:128224", -- [3]
			"2097107569:137318", -- [4]
			"2097107569:134848", -- [5]
			"2345496483:2357354855:134850", -- [6]
			"2097107569:137318:138097", -- [7]
			"2345496483:2357354855:134850:134853", -- [8]
			"1898220961:138022", -- [9]
			"1898220961:133861:138265", -- [10]
			"1898220961:133861:138265:143548", -- [11]
			"135025:150634", -- [12]
			--["name"] = "Waning Glacier, Tiragarde Sound",
			["m"] = 895,
			["coord"] = 1704144718,
			["direct"] = "135025:140939",
			["f"] = 0,
		},
		[150634] = {
			"135025:138022:1979628839:2129180549:129098", -- [1]
			"135025:138022:1898220961:133861", -- [2]
			"135025:138022:1979628839:2129180549:129098:128224", -- [3]
			"137318:138097:134848", -- [4]
			"137318:138097:134848:134850", -- [5]
			"137318:138097:2509252230:134853", -- [6]
			"135025:135988", -- [7]
			"135025:138022", -- [8]
			"135025:138022:1898220961:133861:138265", -- [9]
			"135025:142740", -- [10]
			"135025:138022:1898220961:133861:138265:143548", -- [11]
			["direct"] = "137318:138097:135025",
			["m"] = 1462,
			["coord"] = 3154723323,
			["f"] = 0,
		},	
		[134848] = {
			"134842:2381474700:133861:129098", -- [1]
			"134842:2381474700", -- [2]
			"134842:2381474700:133861", -- [3]
			"134842:2381474700:133861:128224", -- [4]		
			"2393595189:2381474700:133861:129098", -- [1]
			"2393595189:2381474700:133861", -- [2]
			"2393595189:2381474700:133861:128224", -- [3]
			"138097:137318", -- [4]
			"138097:2548965858:134853", -- [5]
			"2127384098:142740:135025", -- [6]
			"2127384098:142740:135025:135988", -- [7]
			"2127384098:142740:1924041156:138022", -- [8]
			"2393595189:2381474700:133861:138265", -- [9]
			"2127384098:142740", -- [10]
			"134842:2381474700:133861:138265", -- [9]
			"134842:2381474700:140772", -- [11]
			"2357354855:2345496483:133861:129098", -- [1]
			"2357354855:2345496483:133861", -- [2]
			"2357354855:2345496483:133861:128224", -- [3]
			"138097:2509252230:134853", -- [4]
			"2097107569:142740:135025", -- [5]
			"2097107569:142740:135025:135988", -- [6]
			"2097107569:142740:1898220961:138022", -- [7]
			"2357354855:2345496483:133861:138265", -- [8]
			"2097107569:142740", -- [9]
			"2357354855:2345496483:133861:138265:143548", -- [10]
			"138097:137318:150634", -- [11]			
			--["name"] = "Diretusk Hollow, Stormsong Valley",
			["m"] = 942,
			["coord"] = 2330820120,
			["direct"] = "134850:138097",
			["f"] = 0,
		},
		[128224] = {
			"133861:2381474700:2393595189:2127384098:137318", -- [1]
			"133861:2381474700:2393595189:134848", -- [2]
			"133861:2381474700:2393595189:134850", -- [3]
			"133861:2381474700:2393595189:134848:138097", -- [4]
			"133861:2381474700:2393595189:134850:134853", -- [5]
			"133861:1924041156:138022:135025", -- [6]
			"129098:2160243705:2007284134:135988", -- [7]
			"133861:1924041156:138022", -- [8]
			"133861:1924041156:142740", -- [9]
			"133861:1898220961:138022:135025:150634", -- [10]
			--["name"] = "Castaway Point, Tiragarde Sound",
			["m"] = 895,
			["coord"] = 3710701347,
			["direct"] = "129098:133861:138265:143548",
			["f"] = 0,
		},
		[137318] = {
			"2127384098:2393595189:2381474700:133861:129098", -- [1]
			"2127384098:2393595189:2381474700:133861", -- [2]
			"2127384098:2393595189:2381474700:133861:128224", -- [3]
			"138097:134848", -- [4]
			"138097:134848:134850", -- [5]
			"138097:2548965858:134853", -- [6]
			"2127384098:142740:135025", -- [7]
			"2127384098:142740:135025:135988", -- [8]
			"2127384098:142740:1924041156:138022", -- [9]
			"2127384098:2393595189:2381474700:133861:138265", -- [10]
			"2127384098:142740", -- [11]
			--["name"] = "Seekers Vista, Stormsong Valley",
			["m"] = 942,
			["coord"] = 1721261926,
			["direct"] = "138097",
			["f"] = 0,
		},
		[135025] = {
			"138022:2007284134:2160243705:129098", -- [1]
			"138022:1924041156:133861", -- [2]
			"138022:2007284134:2160243705:129098:128224", -- [3]
			"142740:2127384098:137318", -- [4]
			"142740:2127384098:134848", -- [5]
			"142740:2381474700:2393595189:134850", -- [6]
			"142740:2127384098:137318:138097", -- [7]
			"142740:2381474700:2393595189:134850:134853", -- [8]
			"138022:1924041156:133861:138265", -- [9]
			"138022:140772:2160243705:129098", -- [1]			
			--["name"] = "Whitegrove Chapel, Drustvar",
			["m"] = 896,
			["coord"] = 1103899222,
			["direct"] = "135988:138022:142740:150634",
			["f"] = 0,
		},
		[134850] = {
			"2393595189:2381474700:133861:129098", -- [1]
			"2393595189:2381474700:133861", -- [2]
			"2393595189:2381474700:133861:128224", -- [3]
			"134848:138097:137318", -- [4]
			"134848:138097", -- [5]
			"2393595189:2381474700:142740:135025", -- [6]
			"2393595189:2381474700:1924041156:138022:135988", -- [7]
			"2393595189:2381474700:1924041156:138022", -- [8]
			"2393595189:2381474700:133861:138265", -- [9]
			"2393595189:2381474700:142740", -- [10]
			"134842:2381474700:133861:129098", -- [1]
			"134842:2381474700", -- [2]
			"134842:2381474700:133861", -- [3]
			"134842:2381474700:133861:128224", -- [4]
			"134842:2381474700:142740:135025", -- [5]
			"134842:2381474700:1924041156:138022:135988", -- [6]
			"134842:2381474700:1924041156:138022", -- [7]
			"134842:2381474700:133861:138265", -- [8]
			"134842:2381474700:142740", -- [9]
			"134842:2381474700:140772", -- [10]			
			"2357354855:2345496483:133861:129098", -- [1]
			"2357354855:2345496483:133861", -- [2]
			"2357354855:2345496483:133861:128224", -- [3]
			"2357354855:2345496483:142740:135025", -- [4]
			"2357354855:2345496483:1898220961:138022:135988", -- [5]
			"2357354855:2345496483:1898220961:138022", -- [6]
			"2357354855:2345496483:133861:138265", -- [7]
			"2357354855:2345496483:142740", -- [8]
			"2357354855:2345496483:133861:138265:143548", -- [9]
			"134848:138097:137318:150634", -- [10]			
			--["name"] = "Ironmaul Overlook, Stormsong Valley",
			["m"] = 942,
			["coord"] = 3261047832,
			["direct"] = "134848:134853",
			["f"] = 0,
		},
		[129098] = {
			"133861:2381474700:2393595189:2127384098:137318", -- [1]
			"133861:2381474700:2393595189:134848", -- [2]
			"133861:2381474700:2393595189:134850", -- [3]
			"133861:2381474700:2393595189:134848:138097", -- [4]
			"133861:2381474700:2393595189:134850:134853", -- [5]
			"2160243705:2007284134:138022:135025", -- [6]
			"2160243705:2007284134:135988", -- [7]
			"2160243705:2007284134:138022", -- [8]
			"128224:138265", -- [9]
			"133861:1924041156:142740", -- [10]
			"133861:133331", -- [1]
			"133861:133331:134842:2127384098:137318", -- [2]
			"133861:133331:134842:134848", -- [3]
			"133861:133331:134842:134850", -- [4]
			"133861:133331:134842:134848:138097", -- [5]
			"133861:133331:134842:134850:134853", -- [6]
			"2160243705:140772:138022:135025", -- [7]
			"2160243705:140772:135988", -- [8]
			"2160243705:140772:138022", -- [9]
			"133861:1924041156:142740", -- [10]			
			"133861:1898220961:142740", -- [9]
			"128224:143548", -- [10]
			"2129180549:1979628839:138022:135025:150634", -- [11]			
			--["name"] = "Freehold, Tiragarde Sound",
			["m"] = 895,
			["coord"] = 3310343229,
			["direct"] = "133861:128224",
			["f"] = 0,
		},
		[133861] = {
			"2381474700:2393595189:2127384098:137318", -- [1]
			"2381474700:2393595189:134848", -- [2]
			"2381474700:2393595189:134850", -- [3]
			"2381474700:2393595189:134848:138097", -- [4]
			"2381474700:2393595189:134850:134853", -- [5]
			"133331:134842:2127384098:137318", -- [1]
			"133331:134842:134848", -- [2]
			"133331:134842:134850", -- [3]
			"133331:134842:134848:138097", -- [4]
			"133331:134842:134850:134853", -- [5]			
			"1924041156:138022:135025", -- [6]
			"2160243705:2007284134:135988", -- [7]
			"1924041156:138022", -- [8]
			"1924041156:142740", -- [9]
			"2160243705:140772:135988", -- [7]
			"1898220961:138022", -- [8]
			"1898220961:142740", -- [9]
			"138265:143548", -- [10]
			"1898220961:138022:135025:150634", -- [11]			
			--["name"] = "Timberfell Outpost, Tiragarde Sound",
			["m"] = 895,
			["coord"] = 3097789664,
			["direct"] = "129098:128224:138265",
			["f"] = 0,
		},
		[134853] = {
			"134850:134842:133331:133861", -- [1]
			"134850:134842:133331:133861:128224", -- [2]		
			"134850:2393595189:2381474700:133861:129098", -- [1]
			"134850:2393595189:2381474700:133861", -- [2]
			"134850:2393595189:2381474700:133861:128224", -- [3]
			"2548965858:138097:137318", -- [4]
			"2548965858:138097:134848", -- [5]
			"2548965858:138097", -- [6]
			"2548965858:138097:137318:2127384098:142740:135025", -- [7]
			"2548965858:138097:137318:2127384098:142740:135025:135988", -- [8]
			"134850:2393595189:2381474700:1924041156:138022", -- [9]
			"134850:2393595189:2381474700:133861:138265", -- [10]
			"2548965858:138097:137318:2127384098:142740", -- [11]
			"134850:134842:133331:1924041156:138022", -- [6]
			"134850:134842:133331:133861:138265", -- [7]			
			"134850:2357354855:2345496483:133861:129098", -- [1]
			"134850:2357354855:2345496483:133861", -- [2]
			"134850:2357354855:2345496483:133861:128224", -- [3]
			"2509252230:138097:137318", -- [4]
			"2509252230:138097:134848", -- [5]
			"2509252230:138097", -- [6]
			"2509252230:138097:137318:2097107569:142740:135025", -- [7]
			"2509252230:138097:137318:2097107569:142740:135025:135988", -- [8]
			"134850:2357354855:2345496483:1898220961:138022", -- [9]
			"134850:2357354855:2345496483:133861:138265", -- [10]
			"2509252230:138097:137318:2097107569:142740", -- [11]
			"134850:2357354855:2345496483:133861:138265:143548", -- [12]
			"2509252230:138097:137318:150634", -- [13]			
			["direct"] = "134850",
			["coord"] = 3347398043,
			["m"] = 942,
			["f"] = 0,
		},
		[138097] = {
			"134848:134842:2381474700:133861:129098", -- [1]
			"134848:134842:2381474700", -- [2]
			"134848:134842:2381474700:133861", -- [3]
			"134848:134842:2381474700:133861:128224", -- [4]		
			"134848:2393595189:2381474700:133861:129098", -- [1]
			"134848:2393595189:2381474700:133861", -- [2]
			"134848:2393595189:2381474700:133861:128224", -- [3]
			"134848:134850", -- [4]
			"2548965858:134853", -- [5]
			"137318:2127384098:142740:135025", -- [6]
			"137318:2127384098:142740:135025:135988", -- [7]
			"137318:2127384098:142740:1924041156:138022", -- [8]
			"134848:2393595189:2381474700:133861:138265", -- [9]
			"134848:134842:2381474700:133861:138265", -- [9]
			"137318:2127384098:142740", -- [10]
			--["name"] = "Warfang Hold, Stormsong Valley",
			["m"] = 942,
			["coord"] = 2209568298,
			["direct"] = "137318:134848",
			["f"] = 0,
		},
		[138265] = {
			"133861:129098", -- [1]
			"133861:2381474700:2393595189:2127384098:137318", -- [2]
			"133861:2381474700:2393595189:134848", -- [3]
			"133861:2381474700:2393595189:134850", -- [4]
			"133861:2381474700:2393595189:134848:138097", -- [5]
			"133861:2381474700:2393595189:134850:134853", -- [6]
			"133861:1924041156:138022:135025", -- [7]
			"133861:2160243705:2007284134:135988", -- [8]
			"133861:1924041156:138022", -- [9]
			"133861:1924041156:142740", -- [10]
			"133861:2345496483:2357354855:2097107569:137318", -- [1]
			"133861:2345496483:2357354855:134848", -- [2]
			"133861:2345496483:2357354855:134850", -- [3]
			"133861:2345496483:2357354855:134848:138097", -- [4]
			"133861:2345496483:2357354855:134850:134853", -- [5]
			"133861:1898220961:138022:135025", -- [6]
			"133861:2129180549:1979628839:135988", -- [7]
			"133861:1898220961:138022", -- [8]
			"133861:1898220961:142740", -- [9]			
			"133861:2345496483:2357354855:2097107569:137318", -- [1]
			"133861:2345496483:2357354855:134848", -- [2]
			"133861:2345496483:2357354855:134850", -- [3]
			"133861:2345496483:2357354855:134848:138097", -- [4]
			"133861:2345496483:2357354855:134850:134853", -- [5]
			"133861:1898220961:138022:135025", -- [6]
			"133861:2129180549:1979628839:135988", -- [7]
			"133861:1898220961:138022", -- [8]
			"133861:1898220961:142740", -- [9]			
			"133861:1898220961:138022:135025:150634", -- [10]
			--["name"] = "Plunder Harbor, Tiragarde Sound",
			["m"] = 895,
			["coord"] = 3749740958,
			["direct"] = "133861:128224:143548",
			["f"] = 0,
		},
		[143548] = {
			"128224:129098", -- [1]
			"138265:133861", -- [2]
			"138265:133861:2345496483:2357354855:2097107569:137318", -- [3]
			"138265:133861:2345496483:2357354855:134848", -- [4]
			"138265:133861:2345496483:2357354855:134850", -- [5]
			"138265:133861:2345496483:2357354855:134848:138097", -- [6]
			"138265:133861:2345496483:2357354855:134850:134853", -- [7]
			"138265:133861:1898220961:138022:135025", -- [8]
			"138265:133861:2129180549:1979628839:135988", -- [9]
			"138265:133861:1898220961:138022", -- [10]
			"138265:133861:1898220961:142740", -- [11]
			"138265:133861:1898220961:138022:135025:150634", -- [12]
			--["name"] = "Tol Dagor, Tiragarde Sound",
			["m"] = 1169,
			["f"] = 0,
			["direct"] = "128224:138265",
			["coord"] = 987986451,
		},		
		[134842] = {
			"2381474700:133861:129098", -- [1]
			"2381474700:133861", -- [2]
			"2381474700:133861:128224", -- [3]
			"2127384098:137318", -- [4]
			"134848:138097", -- [5]
			"134850:134853", -- [6]
			"2381474700:142740:135025", -- [7]
			"2381474700:1924041156:138022:135988", -- [8]
			"2381474700:1924041156:138022", -- [9]
			"2381474700:133861:138265", -- [10]
			"2381474700:142740", -- [11]
			"2381474700:2007284134", -- [12]
			"134848:138097:2548965858", -- [13]
			"2381474700:1924041156", -- [14]
			"2381474700:2160243705", -- [15]
			"133331:133861:129098", -- [16]
			"133331:133861", -- [17]
			"133331:133861:128224", -- [18]
			"133331:142740:135025", -- [19]
			"133331:140939:138022:135988", -- [20]
			"133331:140939:138022", -- [21]
			"133331:133861:138265", -- [22]
			"133331:142740", -- [23]
			"133331:140772", -- [24]
			"133331:140939", -- [25]
			"133331:140533", -- [26]
			--["name"] = "Hillcrest Pasture, Stormsong Valley",
			["direct"] = "133331:2127384098:134848:134850",
			["m"] = 942,
			["coord"] = 2267204938,
			["f"] = 0,
			["requirements"] = "qid:52479",
		},		
		[138251] = {
			"138097:134848:134842:133331:133861:129098", -- [1]
			"138097:134848:134842:133331", -- [2]
			"138097:134848:134842:133331:133861", -- [3]
			"138097:134848:134842:133331:133861:128224", -- [4]
			"138097:137318", -- [5]
			"138097:134848:134842", -- [6]
			"138097:137318:134844", -- [7]
			"138097:134848", -- [8]
			"134853:134850", -- [9]
			"138097:137318:134844:142740:135025", -- [10]
			"138097:137318:134844:142740:135025:135988", -- [11]
			"138097:137318:134844:142740:140939:138022", -- [12]
			"138097:134848:134842:133331:133861:138265", -- [13]
			"138097:137318:134844:142740", -- [14]
			"138097:134848:134842:133331:140772", -- [15]
			"138097:137318:134844:142740:140939", -- [16]
			"138097:134848:134842:133331:140533", -- [17]
			["m"] = 942,
			["direct"] = "138097:134853",
			["coord"] = 2612872606,
			["f"] = 0,
			["requirements"] = "qid:52320",
		},		
		[140772] = {
			"2160243705:129098", -- [1]
			"2160243705:133861", -- [2]
			"2160243705:129098:128224", -- [3]
			"133331:134842:2127384098:137318", -- [4]
			"133331:134842:134848", -- [5]
			"133331:134842:134850", -- [6]
			"133331:134842:134848:138097", -- [7]
			"133331:134842:134850:134853", -- [8]
			"138022:135025", -- [9]
			"2160243705:133861:138265", -- [10]
			"1924041156:142740", -- [11]
			"2381474700:134842:2127384098:137318", -- [12]
			"2381474700:134842:134848", -- [13]
			"2381474700:134842:134850", -- [14]
			"2381474700:134842:134848:138097", -- [15]
			"2381474700:134842:134850:134853", -- [16]
			"2381474700:2393595189:2127384098:137318", -- [17]
			"2381474700:2393595189", -- [18]
			"2381474700:2393595189:2127384098", -- [19]
			"2381474700:2393595189:134848", -- [20]
			"2381474700:2393595189:134850", -- [21]
			"2381474700:2393595189:134848:138097", -- [22]
			"2381474700:2393595189:134850:134853", -- [23]
			"2381474700:2393595189:134848:138097:2548965858", -- [24]
			--["name"] = "Swiftwind Post, Drustvar",
			["m"] = 896,
			["coord"] = 2851510268,
			["direct"] = "2381474700:135988:138022:1924041156:2160243705",
			["f"] = 0,
			["requirements"] = "qid:52276",
		},	
		[134844] = {
			"134842:2381474700:133861:129098", -- [1]
			"134842:2381474700", -- [2]
			"134842:2381474700:133861", -- [3]
			"134842:2381474700:133861:128224", -- [4]
			"134848:134850", -- [5]
			"137318:138097", -- [6]
			"137318:138097:2548965858:134853", -- [7]
			"142740:135025", -- [8]
			"142740:135025:135988", -- [9]
			"142740:1924041156:138022", -- [10]
			"137318:138097:2548965858", -- [11]
			"134842:2381474700:133861:138265", -- [12]
			"142740:1924041156:2007284134", -- [13]
			"142740:1924041156", -- [14]
			"134842:2381474700:2160243705", -- [15]
			"134842:133331:133861:129098", -- [16]
			"134842:133331", -- [17]
			"134842:133331:133861", -- [18]
			"134842:133331:133861:128224", -- [19]
			"142740:140939:138022", -- [20]
			"134842:133331:133861:138265", -- [21]
			"142740:140939:140772", -- [22]
			"142740:140939", -- [23]
			"134842:133331:140533", -- [24]
			--["name"] = "Stonetusk Watch, Stormsong Valley",
			["m"] = 942,
			["direct"] = "137318:134842:134848:142740",
			["coord"] = 1668065993,
			["f"] = 0,
			["requirements"] = "qid:52777",
		},		
		[133331] = {
			"133861:128224", -- [1]
			"134842:2127384098:137318", -- [2]
			"134842:134848", -- [3]
			"134842:134850", -- [4]
			"134842:134848:138097", -- [5]
			"134842:134850:134853", -- [6]
			"142740:135025", -- [7]
			"1924041156:138022:135988", -- [8]
			"1924041156:138022", -- [9]
			"133861:138265", -- [10]
			"133861:129098", -- [11]
			"2393595189:2127384098:137318", -- [12]
			"2393595189:2127384098", -- [13]
			"2393595189:134848", -- [14]
			"2393595189:134850", -- [15]
			"2393595189:134848:138097", -- [16]
			"2393595189:134850:134853", -- [17]
			"140939:138022:135988", -- [18]
			"140939:138022", -- [19]
			"2393595189:134848:138097:2548965858", -- [20]
			--["name"] = "Wolf's Den, Tiragarde Sound",
			["direct"] = "133861:2393595189:142740:140772:140939:140533",
			["m"] = 895,
			["coord"] = 2668503700,
			["f"] = 0,
			["requirements"] = "qid:52127",
		},		
		[140939] = {
			"133861:129098", -- [1]
			"133861:128224", -- [2]
			"142740:2127384098:137318", -- [3]
			"2381474700:2393595189", -- [4]
			"142740:2127384098", -- [5]
			"2381474700:2393595189:134848", -- [6]
			"2381474700:2393595189:134850", -- [7]
			"2381474700:2393595189:134848:138097", -- [8]
			"2381474700:2393595189:134850:134853", -- [9]
			"138022:135025", -- [10]
			"138022:135988", -- [11]
			"2381474700:2393595189:134848:138097:2548965858", -- [12]
			"133861:138265", -- [13]
			"2007284134:2160243705", -- [14]
			"140772:140533", -- [15]
			--["name"] = "Mudfisher Cove, Drustvar",
			["m"] = 896,
			["f"] = 0,
			["direct"] = "2381474700:133861:138022:142740:140772",
			["coord"] = 2666736421,
			["requirements"] = "qid:140947",
		},		
		[140533] = {
			"129098:128224", -- [1]
			"2381474700:2393595189:2127384098:137318", -- [2]
			"2381474700:2393595189", -- [3]
			"2381474700:2393595189:2127384098", -- [4]
			"2381474700:2393595189:134848", -- [5]
			"2381474700:2393595189:134850", -- [6]
			"2381474700:2393595189:134848:138097", -- [7]
			"2381474700:2393595189:134850:134853", -- [8]
			"140772:138022:135025", -- [9]
			"140772:135988", -- [10]
			"140772:138022", -- [11]
			"2381474700:2393595189:134848:138097:2548965858", -- [12]
			"133861:138265", -- [13]
			"140772:1924041156:142740", -- [14]
			"140772:1924041156", -- [15]
			--["name"] = "Stonefist Watch, Tiragarde Sound",
			["m"] = 895,
			["direct"] = "129098:2381474700:133861:140772",
			["coord"] = 2284822938,
			["f"] = 0,
			["requirements"] = "qid:52222",
		},		
		[2548965858] = {
			["m"] = 876,
			["coord"] = 2548965858,
		},		
		[2393595189] = {
			["m"] = 876,
			["coord"] = 2393595189,
		},	
		[2381474700] = {
			["m"] = 876,
			["coord"] = 2381474700,
		},	
		[2127384098] = {
			["m"] = 876,
			["coord"] = 2127384098,
		},	
		[2160243705] = {
			["m"] = 876,
			["coord"] = 2160243705,
		},	
		[1924041156] = {
			["m"] = 876,
			["coord"] = 1924041156,
		},	
		[2007284134] = {
			["m"] = 876,
			["coord"] = 2007284134,
		},	
		[2357354855] = {
			["m"] = 876,
			["coord"] = 2357354855,
		},	
		[2345496483] = {
			["m"] = 876,
			["coord"] = 2345496483,
		},	
		[2509252230] = {
			["m"] = 876,
			["coord"] = 2509252230,
		},	
		[2097107569] = {
			["m"] = 876,
			["coord"] = 2097107569,
		},			
		[1979628839] = {
			["m"] = 876,
			["coord"] = 1979628839,
		},
		[1898220961] = {
			["m"] = 876,
			["coord"] = 1898220961,
		},			
		[2129180549] = {
			["m"] = 876,
			["coord"] = 2129180549,
		},			
	},
	[1355] = {
		[153757] = {
			"153863:153772", -- [1]
			"153863:153772:153850", -- [2]
			--["name"] = "Kelya's Grave, Nazjatar",
			["direct"] = "153762:153863",
			["f"] = 0,
			["m"] = 1355,
			["coord"] = 3185000407,
		},
		[153863] = {
			"153772:153850", -- [1]
			--["name"] = "Ekka's Hideaway, Nazjatar",
			["m"] = 1355,
			["f"] = 0,
			["direct"] = "153772:153762",
			["coord"] = 2748941475,
		},
		[153850] = {
			--["name"] = "Wreck of the Hungry Riverbeast, Nazjatar",
			["direct"] = "153772:153762",
			["f"] = 0,
			["m"] = 1355,
			["coord"] = 1552405133,
		},
		[153762] = {
			--["name"] = "Ashen Strand, Nazjatar",
			["direct"] = "153772",
			["f"] = 0,
			["m"] = 1355,
			["coord"] = 1481007018,
		},
		[153772] = {
			"153863:153757", -- [1]
			"153863:153864", -- [2]
			["m"] = 1355,
			["direct"] = "153762:153850:153863",
			["coord"] = 2039521719,
			["f"] = 0,
		},
		[153864] = {
			"153863:153772", -- [1]
			"153863:153772:153850", -- [2]
			--["name"] = "Zin'Azshari, Nazjatar",
			["direct"] = "153757:153762:153863",
			["f"] = 0,
			["m"] = 1355,
			["coord"] = 3413664011,
		},
	},
	[1550] = {
		[183969] = {
			--["name"] = "Pilgrim's Grace, Zereth Mortis",
			["m"] = 1970,
			["direct"] = "183963:183966",
			["coord"] = 2641789184,
			["f"] = 0,
		},
		[183966] = {
			--["name"] = "Faith's Repose, Zereth Mortis",
			["direct"] = "183963:183969",
			["m"] = 1970,
			["coord"] = 1531605468,
			["f"] = 0,
		},
		[183963] = {
			--["name"] = "Haven, Zereth Mortis",
			["direct"] = "183966:183969",
			["m"] = 1970,
			["coord"] = 1530570374,
			["f"] = 0,
		},
		[183968] = {
			--["name"] = "Zovaal's Grasp, Zereth Mortis",
			["direct"] = "184337",
			["coord"] = 1978415011,
			["m"] = 1970,
			["f"] = 0,
		},
		[184337] = {
			--["name"] = "Antecedent Isle, Zereth Mortis",
			["direct"] = "183968",
			["m"] = 1970,
			["coord"] = 2035949950,
			["f"] = 0,
		},
		[183970] = {
			--["name"] = "Sepulcher Overlook, Zereth Mortis",
			["direct"] = "184332",
			["m"] = 1970,
			["coord"] = 2780006677,
			["f"] = 0,
		},
		[184332] = {
			--["name"] = "Sepulcher Of The First Ones, Zereth Mortis",
			["direct"] = "183970",
			["m"] = 1970,
			["f"] = 0,
			["coord"] = 3141306562,
		},
		[171105] = {
			["m"] = 1533,
			["direct"] = "171036:171037:171091:171097:171101:171102:171103:171104",
			["coord"] = 1520318503,
			["f"] = 0,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171104] = {
			--["name"] = "Temple of Humility, Bastion",
			["direct"] = "171036:171037:171091:171097:171101:171102:171103:171105",
			["f"] = 0,
			["m"] = 1533,
			["coord"] = 2859235995,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171103] = {
			--["name"] = "Seat of Eternal Hymns, Bastion",
			["direct"] = "171036:171037:171091:171097:171101:171102:171105:171104",
			["f"] = 0,
			["m"] = 1533,
			["coord"] = 2506772299,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171097] = {
			--["name"] = "Xandria's Vigil, Bastion",
			["direct"] = "171036:171037:171091:171101:171102:171103:171105:171104",
			["f"] = 0,
			["m"] = 1533,
			["coord"] = 1748602196,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171091] = {
			--["name"] = "Aspirant's Rest, Bastion",
			["direct"] = "171036:171037:171097:171101:171102:171103:171105:171104",
			["f"] = 0,
			["m"] = 1533,
			["coord"] = 2075048589,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171036] = {
			["m"] = 1707,
			["direct"] = "171037:171091:171097:171101:171102:171103:171105:171104",
			["coord"] = 2069732764,
			["f"] = 0,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171037] = {
			--["name"] = "Hero's Rest, Bastion",
			["direct"] = "171036:171091:171097:171101:171102:171103:171105:171104",
			["f"] = 0,
			["m"] = 1533,
			["coord"] = 2222684117,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171101] = {
			--["name"] = "Sagehaven, Bastion",
			["direct"] = "171036:171037:171091:171097:171102:171103:171105:171104",
			["f"] = 0,
			["m"] = 1533,
			["coord"] = 1896764554,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171102] = {
			--["name"] = "Temple of Purity, Bastion",
			["direct"] = "171036:171037:171091:171097:171101:171103:171105:171104",
			["f"] = 0,
			["m"] = 1533,
			["coord"] = 2552284520,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[159421] = {
			"159423:159127:162666", -- [1]
			"159423:159127:162666:158526:156295", -- [2]
			"159423:159127:162666:158526:156196:158416", -- [3]
			"159423:159127:162666:158526:158417", -- [4]
			"159423:159127:162666:158526:156295:158517", -- [5]
			"159423:159127:162666:158526", -- [6]
			"159423:159127:162666:158526:156196:158416:158533", -- [7]
			"159423:159127:162666:158526:156295:158517:158564", -- [8]
			"159423:159127:162666:158526:156196", -- [9]
			"159423:159127", -- [10]
			"159423:159127:162666:158526:156196:160202", -- [11]
			"159423:159127:162666:157540:157519", -- [12]
			"159423:159127:162666:157540:157518", -- [13]
			"159423:159127:162666:157540:157517", -- [14]
			"159423:159127:162666:157540:157516", -- [15]
			"159423:159127:162666:157540", -- [16]
			"159423:159127:162666:157540:157515", -- [17]
			"159423:159127:162666:165164:167243", -- [18]
			"159423:159127:162666:165164", -- [19]
			"159423:159127:162666:165164:165166", -- [20]
			"159423:159127:162666:165164:167255:167265", -- [21]
			"159423:159127:162666:165164:165166:167247", -- [22]
			"159423:159127:162666:165164:167255", -- [23]
			--["name"] = "Elysian Hold, Bastion",
			["direct"] = "159125:159423",
			["f"] = 0,
			["m"] = 1707,
			["coord"] = 2183298110,
			["requirements"] = "qid:60492", --Kyrian
		},
		[165701] = {
			"165164:162666", -- [1]
			"165164:162666:158526:156295", -- [2]
			"165164:162666:158526:156196:158416", -- [3]
			"165164:162666:158526:158417", -- [4]
			"165164:162666:158526:156295:158517", -- [5]
			"165164:162666:158526", -- [6]
			"165164:162666:158526:156196:158416:158533", -- [7]
			"165164:162666:158526:156295:158517:158564", -- [8]
			"165164:162666:158526:156196", -- [9]
			"165164:162666:159127", -- [10]
			"165164:162666:159127:159423:159125", -- [11]
			"165164:162666:159127:159423", -- [12]
			"165164:162666:158526:156196:160202", -- [13]
			"165164:162666:157540:157519", -- [14]
			"165164:162666:157540:157518", -- [15]
			"165164:162666:157540:157517", -- [16]
			"165164:162666:157540:157516", -- [17]
			"165164:162666:157540", -- [18]
			"165164:162666:157540:157515", -- [19]
			"165164:162666:159127:159423:159125:175457", -- [20]
			--["name"] = "Heart of the Forest, Ardenweald",
			["direct"] = "167243:165164:165166:167265:167247",
			["f"] = 0,
			["m"] = 1701,
			["coord"] = 2210075703,
			["requirements"] = "qid:61479", --available if chose Night Fae Covenant
		},
		[157540] = {
			"162666:159127:159423:159421", -- [1]
			"162666:165164:165701", -- [1]
			"162666:165164:165701:167265", -- [2]		
			"162666:158526:156196:158416:162702", -- [1]
			"162666:159127:159423:159125:175457", -- [2]		
			"162666:158526:156295", -- [1]
			"162666:158526:156196:158416", -- [2]
			"162666:158526:158417", -- [3]
			"162666:158526:156295:158517", -- [4]
			"162666:158526", -- [5]
			"162666:158526:156196:158416:158533", -- [6]
			"162666:158526:156295:158517:158564", -- [7]
			"162666:158526:156196", -- [8]
			"162666:159127", -- [9]
			"162666:159127:159423:159125", -- [10]
			"162666:159127:159423", -- [11]
			"162666:158526:156196:160202", -- [12]
			"162666:165164:167243", -- [13]
			"162666:165164", -- [14]
			"162666:165164:165166", -- [15]
			"162666:165164:167255:167265", -- [16]
			"162666:165164:165166:167247", -- [17]
			"162666:165164:167255", -- [18]
			--["name"] = "Theater of Pain, Maldraxxus",
			["direct"] = "162666:157519:157518:157517:157516:157515",
			["m"] = 1536,
			["coord"] = 2143324253,
			["f"] = 0,
		},
		[159125] = {
			"159423:159127:162666:165164:165701", -- [1]
			"159423:159127:162666:165164:165701:167265", -- [2]		
			"159423:159127:162666:158526:156196:158416:162702", -- [1]
			"159423:159127:162666", -- [1]
			"159423:159127:162666:158526:156295", -- [2]
			"159423:159127:162666:158526:156196:158416", -- [3]
			"159423:159127:162666:158526:158417", -- [4]
			"159423:159127:162666:158526:156295:158517", -- [5]
			"159423:159127:162666:158526", -- [6]
			"159423:159127:162666:158526:156196:158416:158533", -- [7]
			"159423:159127:162666:158526:156295:158517:158564", -- [8]
			"159423:159127:162666:158526:156196", -- [9]
			"159423:159127", -- [10]
			"159423:159127:162666:158526:156196:160202", -- [11]
			"159423:159127:162666:157540:157519", -- [12]
			"159423:159127:162666:157540:157518", -- [13]
			"159423:159127:162666:157540:157517", -- [14]
			"159423:159127:162666:157540:157516", -- [15]
			"159423:159127:162666:157540", -- [16]
			"159423:159127:162666:157540:157515", -- [17]
			"159423:159127:162666:165164:167243", -- [18]
			"159423:159127:162666:165164", -- [19]
			"159423:159127:162666:165164:165166", -- [20]
			"159423:159127:162666:165164:167255:167265", -- [21]
			"159423:159127:162666:165164:165166:167247", -- [22]
			"159423:159127:162666:165164:167255", -- [23]
			--["name"] = "Sagehaven, Bastion",
			["m"] = 1533,
			["direct"] = "159421:159423:175457",
			["coord"] = 1893815057,
			["f"] = 0,
		},
		[158416] = {
			"156196:158526:162666:159127:159423:159421", -- [1]
			"156196:158526:162666:165164:165701", -- [1]
			"156196:158526:162666:165164:165701:167265", -- [2]		
			"156196:158526:162666:159127:159423:159125:175457", -- [1]
			"156196:158526:162666", -- [1]
			"160202:156295", -- [2]
			"160202:158517:158417", -- [3]
			"160202:158517", -- [4]
			"156196:158526", -- [5]
			"156196:158526:162666:159127", -- [6]
			"156196:158526:162666:159127:159423:159125", -- [7]
			"156196:158526:162666:159127:159423", -- [8]
			"156196:158526:162666:157540:157519", -- [9]
			"156196:158526:162666:157540:157518", -- [10]
			"156196:158526:162666:157540:157517", -- [11]
			"156196:158526:162666:157540:157516", -- [12]
			"156196:158526:162666:157540", -- [13]
			"156196:158526:162666:157540:157515", -- [14]
			"156196:158526:162666:165164:167243", -- [15]
			"156196:158526:162666:165164", -- [16]
			"156196:158526:162666:165164:165166", -- [17]
			"156196:158526:162666:165164:167255:167265", -- [18]
			"156196:158526:162666:165164:165166:167247", -- [19]
			"156196:158526:162666:165164:167255", -- [20]
			--["name"] = "Sanctuary of the Mad, Revendreth",
			["direct"] = "158533:158564:156196:160202:162702",
			["m"] = 1525,
			["coord"] = 1312914622,
			["f"] = 0,
		},
		[167255] = {
			"165164:162666:159127:159423:159421", -- [1]
			"165164:162666:158526:156196:158416:162702", -- [1]
			"165164:162666:159127:159423:159125:175457", -- [2]		
			"165164:162666", -- [1]
			"165164:162666:158526:156295", -- [2]
			"165164:162666:158526:156196:158416", -- [3]
			"165164:162666:158526:158417", -- [4]
			"165164:162666:158526:156295:158517", -- [5]
			"165164:162666:158526", -- [6]
			"165164:162666:158526:156196:158416:158533", -- [7]
			"165164:162666:158526:156295:158517:158564", -- [8]
			"165164:162666:158526:156196", -- [9]
			"165164:162666:159127", -- [10]
			"165164:162666:159127:159423:159125", -- [11]
			"165164:162666:159127:159423", -- [12]
			"165164:162666:158526:156196:160202", -- [13]
			"165164:162666:157540:157519", -- [14]
			"165164:162666:157540:157518", -- [15]
			"165164:162666:157540:157517", -- [16]
			"165164:162666:157540:157516", -- [17]
			"165164:162666:157540", -- [18]
			"165164:162666:157540:157515", -- [19]
			--["name"] = "Refugee Camp, Ardenweald",
			["direct"] = "167243:165164:165166:167265:167247",
			["requirements"] = "nqid:61479", --Not available if chose Night Fae Covenant
			["m"] = 1565,
			["coord"] = 2117567702,
			["f"] = 0,
		},
		[158517] = {
			"156295:158526:162666:159127:159423:159421", -- [1]
			"156295:158526:162666:165164:165701", -- [1]
			"156295:158526:162666:165164:165701:167265", -- [2]		
			"160202:158416:162702", -- [1]
			"156295:158526:162666:159127:159423:159125:175457", -- [2]		
			"156295:158526:162666", -- [1]
			"160202:158416", -- [2]
			"156295:158526", -- [3]
			"158564:158533", -- [4]
			"156295:158526:162666:159127", -- [5]
			"156295:158526:162666:159127:159423:159125", -- [6]
			"156295:158526:162666:159127:159423", -- [7]
			"156295:158526:162666:157540:157519", -- [8]
			"156295:158526:162666:157540:157518", -- [9]
			"156295:158526:162666:157540:157517", -- [10]
			"156295:158526:162666:157540:157516", -- [11]
			"156295:158526:162666:157540", -- [12]
			"156295:158526:162666:157540:157515", -- [13]
			"156295:158526:162666:165164:167243", -- [14]
			"156295:158526:162666:165164", -- [15]
			"156295:158526:162666:165164:165166", -- [16]
			"156295:158526:162666:165164:167255:167265", -- [17]
			"156295:158526:162666:165164:165166:167247", -- [18]
			"156295:158526:162666:165164:167255", -- [19]
			--["name"] = "Old Gate, Revendreth",
			["direct"] = "156295:158417:158564:156196:160202",
			["m"] = 1525,
			["coord"] = 2629198652,
			["f"] = 0,
		},
		[156196] = {
			"156295:158526:162666:159127:159423:159421", -- [1]
			"158526:162666:165164:165701", -- [1]
			"158526:162666:165164:165701:167265", -- [2]		
			"158416:162702", -- [1]
			"158526:162666:159127:159423:159125:175457", -- [2]		
			"158526:162666", -- [1]
			"156295:158417", -- [2]
			"158416:158533", -- [3]
			"160202:158564", -- [4]
			"158526:162666:159127", -- [5]
			"158526:162666:159127:159423:159125", -- [6]
			"158526:162666:159127:159423", -- [7]
			"158526:162666:157540:157519", -- [8]
			"158526:162666:157540:157518", -- [9]
			"158526:162666:157540:157517", -- [10]
			"158526:162666:157540:157516", -- [11]
			"158526:162666:157540", -- [12]
			"158526:162666:157540:157515", -- [13]
			"158526:162666:165164:167243", -- [14]
			"158526:162666:165164", -- [15]
			"158526:162666:165164:165166", -- [16]
			"158526:162666:165164:167255:167265", -- [17]
			"158526:162666:165164:165166:167247", -- [18]
			"158526:162666:165164:167255", -- [19]
			--["name"] = "Wanecrypt Hill, Revendreth",
			["direct"] = "156295:158416:158517:158526:160202",
			["m"] = 1525,
			["coord"] = 2057417215,
			["f"] = 0,
		},
		[158564] = {
			"158517:156295:158526:162666:159127:159423:159421", -- [1]
			"158517:156295:158526:162666:165164:165701", -- [1]
			"158517:156295:158526:162666:165164:165701:167265", -- [2]		
			"158416:162702", -- [1]
			"158517:156295:158526:162666:159127:159423:159125:175457", -- [2]		
			"158517:156295:158526:162666", -- [1]
			"158517:156295", -- [2]
			"158517:158417", -- [3]
			"158517:156295:158526", -- [4]
			"158517:156196", -- [5]
			"158517:156295:158526:162666:159127", -- [6]
			"158517:156295:158526:162666:159127:159423:159125", -- [7]
			"158517:156295:158526:162666:159127:159423", -- [8]
			"158517:156295:158526:162666:157540:157519", -- [9]
			"158517:156295:158526:162666:157540:157518", -- [10]
			"158517:156295:158526:162666:157540:157517", -- [11]
			"158517:156295:158526:162666:157540:157516", -- [12]
			"158517:156295:158526:162666:157540", -- [13]
			"158517:156295:158526:162666:157540:157515", -- [14]
			"158517:156295:158526:162666:165164:167243", -- [15]
			"158517:156295:158526:162666:165164", -- [16]
			"158517:156295:158526:162666:165164:165166", -- [17]
			"158517:156295:158526:162666:165164:167255:167265", -- [18]
			"158517:156295:158526:162666:165164:165166:167247", -- [19]
			"158517:156295:158526:162666:165164:167255", -- [20]
			--["name"] = "Menagerie of the Master, Revendreth",
			["direct"] = "158416:158517:158533:160202",
			["m"] = 1525,
			["coord"] = 2327134608,
			["f"] = 0,
		},
		[157514] = {
			"157540:162666", -- [1]
			"157540:162666:158526:156295", -- [2]
			"157540:162666:158526:156196:158416", -- [3]
			"157540:162666:158526:158417", -- [4]
			"157540:162666:158526:156295:158517", -- [5]
			"157540:162666:158526", -- [6]
			"157540:162666:158526:156196:158416:158533", -- [7]
			"157540:162666:158526:156295:158517:158564", -- [8]
			"157540:162666:158526:156196", -- [9]
			"157540:162666:159127", -- [10]
			"157540:162666:159127:159423:159125", -- [11]
			"157540:162666:159127:159423", -- [12]
			"157540:162666:158526:156196:160202", -- [13]
			"157540:157517", -- [14]
			"157540:162666:165164:167243", -- [15]
			"157540:162666:165164", -- [16]
			"157540:162666:165164:165166", -- [17]
			"157540:162666:165164:167255:167265", -- [18]
			"157540:162666:165164:165166:167247", -- [19]
			"157540:162666:165164:167255", -- [20]
			"157540:162666:159127:159423:159125:175457", -- [21]
			--["name"] = "Bleak Redoubt, Maldraxxus",
			["requirements"] = "qid:58609", -- Necrolord 
			["direct"] = "157519:157518:157516:157540:157515",
			["coord"] = 2253761843,
			["m"] = 1536,
			["f"] = 0,
		},		
		[158417] = {
			"158526:162666:159127:159423:159421", -- [1]
			"158526:162666:165164:165701", -- [1]
			"158526:162666:165164:165701:167265", -- [2]
			"158526:162666:159127:159423:159125:175457", -- [3]		
			"160202:158416:162702", -- [1]
			"156295:158526:162666:159127:159423:159125:175457", -- [2]		
			"158526:162666", -- [1]
			"158517:160202:158416", -- [2]
			"158517:158564:158533", -- [3]
			"158517:158564", -- [4]
			"156295:156196", -- [5]
			"158526:162666:159127", -- [6]
			"158526:162666:159127:159423:159125", -- [7]
			"158526:162666:159127:159423", -- [8]
			"158517:160202", -- [9]
			"158526:162666:157540:157519", -- [10]
			"158526:162666:157540:157518", -- [11]
			"158526:162666:157540:157517", -- [12]
			"158526:162666:157540:157516", -- [13]
			"158526:162666:157540", -- [14]
			"158526:162666:157540:157515", -- [15]
			"158526:162666:165164:167243", -- [16]
			"158526:162666:165164", -- [17]
			"158526:162666:165164:165166", -- [18]
			"158526:162666:165164:167255:167265", -- [19]
			"158526:162666:165164:165166:167247", -- [20]
			"158526:162666:165164:167255", -- [21]
			--["name"] = "Halls of Atonement, Revendreth",
			["direct"] = "156295:158517:158526",
			["m"] = 1525,
			["coord"] = 3070977703,
			["f"] = 0,
		},
		[158526] = {
			"162666:159127:159423:159421", -- [1]
			"162666:165164:165701", -- [1]
			"162666:165164:165701:167265", -- [2]		
			"156196:158416:162702", -- [1]
			"162666:159127:159423:159125:175457", -- [2]		
			"156196:158416", -- [1]
			"156295:158517", -- [2]
			"156196:158416:158533", -- [3]
			"156295:158517:158564", -- [4]
			"162666:159127", -- [5]
			"162666:159127:159423:159125", -- [6]
			"162666:159127:159423", -- [7]
			"156196:160202", -- [8]
			"162666:157540:157519", -- [9]
			"162666:157540:157518", -- [10]
			"162666:157540:157517", -- [11]
			"162666:157540:157516", -- [12]
			"162666:157540", -- [13]
			"162666:157540:157515", -- [14]
			"162666:165164:167243", -- [15]
			"162666:165164", -- [16]
			"162666:165164:165166", -- [17]
			"162666:165164:167255:167265", -- [18]
			"162666:165164:165166:167247", -- [19]
			"162666:165164:167255", -- [20]
			--["name"] = "Pridefall Hamlet, Revendreth",
			["direct"] = "162666:156295:158417:156196",
			["m"] = 1525,
			["coord"] = 3022180288,
			["f"] = 0,
		},
		[165164] = {
			"162666:159127:159423:159421", -- [1]
			"165701:167265", -- [1]
			"162666:158526:156196:158416:162702", -- [1]
			"162666:159127:159423:159125:175457", -- [2]		
			"162666:158526:156295", -- [1]
			"162666:158526:156196:158416", -- [2]
			"162666:158526:158417", -- [3]
			"162666:158526:156295:158517", -- [4]
			"162666:158526", -- [5]
			"162666:158526:156196:158416:158533", -- [6]
			"162666:158526:156295:158517:158564", -- [7]
			"162666:158526:156196", -- [8]
			"162666:159127", -- [9]
			"162666:159127:159423:159125", -- [10]
			"162666:159127:159423", -- [11]
			"162666:158526:156196:160202", -- [12]
			"162666:157540:157519", -- [13]
			"162666:157540:157518", -- [14]
			"162666:157540:157517", -- [15]
			"162666:157540:157516", -- [16]
			"162666:157540", -- [17]
			"162666:157540:157515", -- [18]
			"167255:167265", -- [19]
			"165166:167247", -- [20]
			--["name"] = "Tirna Vaal, Ardenweald",
			["direct"] = "162666:167243:165166:167255:165701",
			["m"] = 1565,
			["coord"] = 2722586628,
			["f"] = 0,
		},
		[159127] = {
			"159423:159421", -- [1]
			"162666:165164:165701", -- [1]
			"162666:165164:165701:167265", -- [2]		
			"162666:158526:156196:158416:162702", -- [1]
			"159423:159125:175457", -- [2]		
			"162666:158526:156295", -- [1]
			"162666:158526:156196:158416", -- [2]
			"162666:158526:158417", -- [3]
			"162666:158526:156295:158517", -- [4]
			"162666:158526", -- [5]
			"162666:158526:156196:158416:158533", -- [6]
			"162666:158526:156295:158517:158564", -- [7]
			"162666:158526:156196", -- [8]
			"159423:159125", -- [9]
			"162666:158526:156196:160202", -- [10]
			"162666:157540:157519", -- [11]
			"162666:157540:157518", -- [12]
			"162666:157540:157517", -- [13]
			"162666:157540:157516", -- [14]
			"162666:157540", -- [15]
			"162666:157540:157515", -- [16]
			"162666:165164:167243", -- [17]
			"162666:165164", -- [18]
			"162666:165164:165166", -- [19]
			"162666:165164:167255:167265", -- [20]
			"162666:165164:165166:167247", -- [21]
			"162666:165164:167255", -- [22]
			--["name"] = "Aspirant's Rest, Bastion",
			["direct"] = "162666:159423",
			["m"] = 1533,
			["coord"] = 2066726380,
			["f"] = 0,
		},
		[157519] = {
			"157540:162666:159127:159423:159421", -- [1]
			"157540:162666:158526:156196:158416:162702", -- [1]
			"157540:162666:159127:159423:159125:175457", -- [2]		
			"157540:162666", -- [1]
			"157540:162666:158526:156295", -- [2]
			"157540:162666:158526:156196:158416", -- [3]
			"157540:162666:158526:158417", -- [4]
			"157540:162666:158526:156295:158517", -- [5]
			"157540:162666:158526", -- [6]
			"157540:162666:158526:156196:158416:158533", -- [7]
			"157540:162666:158526:156295:158517:158564", -- [8]
			"157540:162666:158526:156196", -- [9]
			"157540:162666:159127", -- [10]
			"157540:162666:159127:159423:159125", -- [11]
			"157540:162666:159127:159423", -- [12]
			"157540:162666:158526:156196:160202", -- [13]
			"157540:157516", -- [14]
			"157540:162666:165164:167243", -- [15]
			"157540:162666:165164", -- [16]
			"157540:162666:165164:165166", -- [17]
			"157540:162666:165164:167255:167265", -- [18]
			"157540:162666:165164:165166:167247", -- [19]
			"157540:162666:165164:167255", -- [20]
			--["name"] = "The Spearhead, Maldraxxus",
			["direct"] = "157518:157517:157540:157515",
			["m"] = 1536,
			["coord"] = 1677823375,
			["f"] = 0,
		},
		[157515] = {
			"157540:162666:159127:159423:159421", -- [1]
			"157540:162666:165164:165701", -- [1]
			"157540:162666:165164:165701:167265", -- [2]		
			"157540:162666:158526:156196:158416:162702", -- [1]
			"157540:157518", -- [2]
			"157540:162666:159127:159423:159125:175457", -- [3]		
			"157540:162666", -- [1]
			"157540:162666:158526:156295", -- [2]
			"157540:162666:158526:156196:158416", -- [3]
			"157540:162666:158526:158417", -- [4]
			"157540:162666:158526:156295:158517", -- [5]
			"157540:162666:158526", -- [6]
			"157540:162666:158526:156196:158416:158533", -- [7]
			"157540:162666:158526:156295:158517:158564", -- [8]
			"157540:162666:158526:156196", -- [9]
			"157540:162666:159127", -- [10]
			"157540:162666:159127:159423:159125", -- [11]
			"157540:162666:159127:159423", -- [12]
			"157540:162666:158526:156196:160202", -- [13]
			"157514:157518", -- [14]
			"157540:157517", -- [15]
			"157540:162666:165164:167243", -- [16]
			"157540:162666:165164", -- [17]
			"157540:162666:165164:165166", -- [18]
			"157540:162666:165164:167255:167265", -- [19]
			"157540:162666:165164:165166:167247", -- [20]
			"157540:162666:165164:167255", -- [21]
			--["name"] = "Plague Watch, Maldraxxus",
			["direct"] = "157519:157516:157540",
			["m"] = 1536,
			["coord"] = 2499524914,
			["f"] = 0,
		},
		[167247] = {
			"165166:165164:162666:159127:159423:159421", -- [1]
			"165701:167243", -- [1]
			"165166:165164:162666:158526:156196:158416:162702", -- [1]
			"165166:165164:162666:159127:159423:159125:175457", -- [2]		
			"165166:165164:162666", -- [1]
			"165166:165164:162666:158526:156295", -- [2]
			"165166:165164:162666:158526:156196:158416", -- [3]
			"165166:165164:162666:158526:158417", -- [4]
			"165166:165164:162666:158526:156295:158517", -- [5]
			"165166:165164:162666:158526", -- [6]
			"165166:165164:162666:158526:156196:158416:158533", -- [7]
			"165166:165164:162666:158526:156295:158517:158564", -- [8]
			"165166:165164:162666:158526:156196", -- [9]
			"165166:165164:162666:159127", -- [10]
			"165166:165164:162666:159127:159423:159125", -- [11]
			"165166:165164:162666:159127:159423", -- [12]
			"165166:165164:162666:158526:156196:160202", -- [13]
			"165166:165164:162666:157540:157519", -- [14]
			"165166:165164:162666:157540:157518", -- [15]
			"165166:165164:162666:157540:157517", -- [16]
			"165166:165164:162666:157540:157516", -- [17]
			"165166:165164:162666:157540", -- [18]
			"165166:165164:162666:157540:157515", -- [19]
			"167255:167243", -- [20]
			"165166:165164", -- [21]
			--["name"] = "Claw's Edge, Ardenweald",
			["direct"] = "165166:167265:167255:165701",
			["m"] = 1565,
			["coord"] = 2202252864,
			["f"] = 0,
		},
		[167265] = {
			"167255:165164:162666:159127:159423:159421", -- [1]
			"165701:165164:162666", -- [1]
			"165701:165164:162666:158526:156295", -- [2]
			"165701:165164:162666:158526:156196:158416", -- [3]
			"165701:165164:162666:158526:158417", -- [4]
			"165701:165164:162666:158526:156295:158517", -- [5]
			"165701:165164:162666:158526", -- [6]
			"165701:165164:162666:158526:156196:158416:158533", -- [7]
			"165701:165164:162666:158526:156295:158517:158564", -- [8]
			"165701:165164:162666:158526:156196", -- [9]
			"165701:165164:162666:159127", -- [10]
			"165701:165164:162666:159127:159423:159125", -- [11]
			"165701:165164:162666:159127:159423", -- [12]
			"165701:165164:162666:158526:156196:160202", -- [13]
			"165701:165164:162666:157540:157519", -- [14]
			"165701:165164:162666:157540:157518", -- [15]
			"165701:165164:162666:157540:157517", -- [16]
			"165701:165164:162666:157540:157516", -- [17]
			"165701:165164:162666:157540", -- [18]
			"165701:165164:162666:157540:157515", -- [19]
			"165701:165164", -- [20]
			"165701:165166", -- [21]
			"165701:165164:162666:159127:159423:159125:175457", -- [22]		
			"167255:165164:162666:158526:156196:158416:162702", -- [1]
			"167255:165164:162666:159127:159423:159125:175457", -- [2]		
			"167255:165164:162666", -- [1]
			"167255:165164:162666:158526:156295", -- [2]
			"167255:165164:162666:158526:156196:158416", -- [3]
			"167255:165164:162666:158526:158417", -- [4]
			"167255:165164:162666:158526:156295:158517", -- [5]
			"167255:165164:162666:158526", -- [6]
			"167255:165164:162666:158526:156196:158416:158533", -- [7]
			"167255:165164:162666:158526:156295:158517:158564", -- [8]
			"167255:165164:162666:158526:156196", -- [9]
			"167255:165164:162666:159127", -- [10]
			"167255:165164:162666:159127:159423:159125", -- [11]
			"167255:165164:162666:159127:159423", -- [12]
			"167255:165164:162666:158526:156196:160202", -- [13]
			"167255:165164:162666:157540:157519", -- [14]
			"167255:165164:162666:157540:157518", -- [15]
			"167255:165164:162666:157540:157517", -- [16]
			"167255:165164:162666:157540:157516", -- [17]
			"167255:165164:162666:157540", -- [18]
			"167255:165164:162666:157540:157515", -- [19]
			"167255:165164", -- [20]
			"167255:165166", -- [21]
			--["name"] = "Root-Home, Ardenweald",
			["direct"] = "167243:167247:167255:165701",
			["m"] = 1565,
			["coord"] = 1512277105,
			["f"] = 0,
		},
		[156295] = {
			"158526:162666:159127:159423:159421", -- [1]
			"158526:162666:165164:165701", -- [1]
			"158526:162666:165164:165701:167265", -- [2]		
			"160202:158416:162702", -- [1]
			"158526:162666:159127:159423:159125:175457", -- [2]		
			"158526:162666", -- [1]
			"160202:158416", -- [2]
			"160202:158416:158533", -- [3]
			"158517:158564", -- [4]
			"158526:162666:159127", -- [5]
			"158526:162666:159127:159423:159125", -- [6]
			"158526:162666:159127:159423", -- [7]
			"158526:162666:157540:157519", -- [8]
			"158526:162666:157540:157518", -- [9]
			"158526:162666:157540:157517", -- [10]
			"158526:162666:157540:157516", -- [11]
			"158526:162666:157540", -- [12]
			"158526:162666:157540:157515", -- [13]
			"158526:162666:165164:167243", -- [14]
			"158526:162666:165164", -- [15]
			"158526:162666:165164:165166", -- [16]
			"158526:162666:165164:167255:167265", -- [17]
			"158526:162666:165164:165166:167247", -- [18]
			"158526:162666:165164:167255", -- [19]
			--["name"] = "Darkhaven, Revendreth",
			["direct"] = "158417:158517:158526:156196:160202",
			["m"] = 1525,
			["coord"] = 2599197532,
			["f"] = 0,
		},
		[165166] = {
			"165164:162666:159127:159423:159421", -- [1]
			"165164:162666:158526:156196:158416:162702", -- [1]
			"165164:162666:159127:159423:159125:175457", -- [2]		
			"165164:162666", -- [1]
			"165164:162666:158526:156295", -- [2]
			"165164:162666:158526:156196:158416", -- [3]
			"165164:162666:158526:158417", -- [4]
			"165164:162666:158526:156295:158517", -- [5]
			"165164:162666:158526", -- [6]
			"165164:162666:158526:156196:158416:158533", -- [7]
			"165164:162666:158526:156295:158517:158564", -- [8]
			"165164:162666:158526:156196", -- [9]
			"165164:162666:159127", -- [10]
			"165164:162666:159127:159423:159125", -- [11]
			"165164:162666:159127:159423", -- [12]
			"165164:162666:158526:156196:160202", -- [13]
			"165164:162666:157540:157519", -- [14]
			"165164:162666:157540:157518", -- [15]
			"165164:162666:157540:157517", -- [16]
			"165164:162666:157540:157516", -- [17]
			"165164:162666:157540", -- [18]
			"165164:162666:157540:157515", -- [19]
			"167255:167265", -- [20]
			--["name"] = "Hibernal Hollow, Ardenweald",
			["direct"] = "167243:165164:167247:167255",
			["m"] = 1565,
			["coord"] = 2588903648,
			["f"] = 0,
		},
		[175457] = {
			"159125:159421", -- [1]
			"159125:159423:159127:162666:165164:165701", -- [1]
			"159125:159423:159127:162666:165164:165701:167265", -- [2]		
			"159125:159423:159127:162666", -- [1]
			"159125:159423:159127:162666:158526:156295", -- [2]
			"159125:159423:159127:162666:158526:156196:158416", -- [3]
			"159125:159423:159127:162666:158526:158417", -- [4]
			"159125:159423:159127:162666:158526:156295:158517", -- [5]
			"159125:159423:159127:162666:158526", -- [6]
			"159125:159423:159127:162666:158526:156196:158416:158533", -- [7]
			"159125:159423:159127:162666:158526:156295:158517:158564", -- [8]
			"159125:159423:159127:162666:158526:156196", -- [9]
			"159125:159423:159127", -- [10]
			"159125:159423", -- [11]
			"159125:159423:159127:162666:158526:156196:160202", -- [12]
			"159125:159423:159127:162666:158526:156196:158416:162702", -- [13]
			"159125:159423:159127:162666:157540:157519", -- [14]
			"159125:159423:159127:162666:157540:157518", -- [15]
			"159125:159423:159127:162666:157540:157517", -- [16]
			"159125:159423:159127:162666:157540:157516", -- [17]
			"159125:159423:159127:162666:157540", -- [18]
			"159125:159423:159127:162666:157540:157515", -- [19]
			"159125:159423:159127:162666:165164:167243", -- [20]
			"159125:159423:159127:162666:165164", -- [21]
			"159125:159423:159127:162666:165164:165166", -- [22]
			"159125:159423:159127:162666:165164:167255:167265", -- [23]
			"159125:159423:159127:162666:165164:165166:167247", -- [24]
			"159125:159423:159127:162666:165164:167255", -- [25]
			--["name"] = "Terrace of the Collectors, Bastion",
			["direct"] = "159125",
			["m"] = 1533,
			["coord"] = 1536636424,
			["f"] = 0,
		},		
		[167243] = {
			"165164:162666:159127:159423:159421", -- [1]
			"165701:167265", -- [1]
			"165164:162666:158526:156196:158416:162702", -- [1]
			"165164:162666:159127:159423:159125:175457", -- [2]		
			"165164:162666", -- [1]
			"165164:162666:158526:156295", -- [2]
			"165164:162666:158526:156196:158416", -- [3]
			"165164:162666:158526:158417", -- [4]
			"165164:162666:158526:156295:158517", -- [5]
			"165164:162666:158526", -- [6]
			"165164:162666:158526:156196:158416:158533", -- [7]
			"165164:162666:158526:156295:158517:158564", -- [8]
			"165164:162666:158526:156196", -- [9]
			"165164:162666:159127", -- [10]
			"165164:162666:159127:159423:159125", -- [11]
			"165164:162666:159127:159423", -- [12]
			"165164:162666:158526:156196:160202", -- [13]
			"165164:162666:157540:157519", -- [14]
			"165164:162666:157540:157518", -- [15]
			"165164:162666:157540:157517", -- [16]
			"165164:162666:157540:157516", -- [17]
			"165164:162666:157540", -- [18]
			"165164:162666:157540:157515", -- [19]
			"167255:167247", -- [20]
			--["name"] = "Glitterfall Basin, Ardenweald",
			["direct"] = "165164:165166:167265:167255:165701",
			["m"] = 1565,
			["coord"] = 2211141678,
			["f"] = 0,
		},
		[157516] = {
			"157540:162666:159127:159423:159421", -- [1]
			"157540:162666:165164:165701", -- [1]
			"157540:162666:165164:165701:167265", -- [2]
			"157540:162666:158526:156196:158416:162702", -- [1]
			"157540:162666:159127:159423:159125:175457", -- [2]
			"157540:162666", -- [1]
			"157540:162666:158526:156295", -- [2]
			"157540:162666:158526:156196:158416", -- [3]
			"157540:162666:158526:158417", -- [4]
			"157540:162666:158526:156295:158517", -- [5]
			"157540:162666:158526", -- [6]
			"157540:162666:158526:156196:158416:158533", -- [7]
			"157540:162666:158526:156295:158517:158564", -- [8]
			"157540:162666:158526:156196", -- [9]
			"157540:162666:159127", -- [10]
			"157540:162666:159127:159423:159125", -- [11]
			"157540:162666:159127:159423", -- [12]
			"157540:162666:158526:156196:160202", -- [13]
			"157540:157519", -- [14]
			"157540:162666:165164:167243", -- [15]
			"157540:162666:165164", -- [16]
			"157540:162666:165164:165166", -- [17]
			"157540:162666:165164:167255:167265", -- [18]
			"157540:162666:165164:165166:167247", -- [19]
			"157540:162666:165164:167255", -- [20]
			--["name"] = "Renounced Bastille, Maldraxxus",
			["direct"] = "157518:157517:157540:157515",
			["m"] = 1536,
			["coord"] = 2914481499,
			["f"] = 0,
		},
		[162666] = {
			"159127:159423:159421", -- [1]
			"165164:165701", -- [1]
			"165164:165701:167265", -- [2]		
			"158526:156196:158416:162702", -- [1]
			"159127:159423:159125:175457", -- [2]		
			"158526:156295", -- [1]
			"158526:156196:158416", -- [2]
			"158526:158417", -- [3]
			"158526:156295:158517", -- [4]
			"158526:156196:158416:158533", -- [5]
			"158526:156295:158517:158564", -- [6]
			"158526:156196", -- [7]
			"159127:159423:159125", -- [8]
			"159127:159423", -- [9]
			"158526:156196:160202", -- [10]
			"157540:157519", -- [11]
			"157540:157518", -- [12]
			"157540:157517", -- [13]
			"157540:157516", -- [14]
			"157540:157515", -- [15]
			"165164:167243", -- [16]
			"165164:165166", -- [17]
			"165164:167255:167265", -- [18]
			"165164:165166:167247", -- [19]
			"165164:167255", -- [20]
			--["name"] = "Oribos",
			["direct"] = "158526:159127:157540:165164",
			["m"] = 1671,
			["coord"] = 2585046256,
			["f"] = 0,
		},
		[157517] = {
			"157540:162666:159127:159423:159421", -- [1]
			"157540:162666:165164:165701", -- [1]
			"157540:162666:165164:165701:167265", -- [2]		
			"157540:162666:158526:156196:158416:162702", -- [1]
			"157540:162666:159127:159423:159125:175457", -- [2]		
			"157540:162666", -- [1]
			"157540:162666:158526:156295", -- [2]
			"157540:162666:158526:156196:158416", -- [3]
			"157540:162666:158526:158417", -- [4]
			"157540:162666:158526:156295:158517", -- [5]
			"157540:162666:158526", -- [6]
			"157540:162666:158526:156196:158416:158533", -- [7]
			"157540:162666:158526:156295:158517:158564", -- [8]
			"157540:162666:158526:156196", -- [9]
			"157540:162666:159127", -- [10]
			"157540:162666:159127:159423:159125", -- [11]
			"157540:162666:159127:159423", -- [12]
			"157540:162666:158526:156196:160202", -- [13]
			"157540:157515", -- [14]
			"157540:162666:165164:167243", -- [15]
			"157540:162666:165164", -- [16]
			"157540:162666:165164:165166", -- [17]
			"157540:162666:165164:167255:167265", -- [18]
			"157540:162666:165164:165166:167247", -- [19]
			"157540:162666:165164:167255", -- [20]
			--["name"] = "Keres' Rest, Maldraxxus",
			["direct"] = "157519:157518:157516:157540",
			["m"] = 1536,
			["coord"] = 2313571922,
			["f"] = 0,
		},
		[157518] = {
			"157540:162666:159127:159423:159421", -- [1]
			"157540:162666:165164:165701", -- [1]
			"157540:162666:165164:165701:167265", -- [2]		
			"157540:162666:158526:156196:158416:162702", -- [1]
			"157540:157515", -- [2]
			"157540:162666:159127:159423:159125:175457", -- [3]		
			"157540:162666", -- [1]
			"157540:162666:158526:156295", -- [2]
			"157540:162666:158526:156196:158416", -- [3]
			"157540:162666:158526:158417", -- [4]
			"157540:162666:158526:156295:158517", -- [5]
			"157540:162666:158526", -- [6]
			"157540:162666:158526:156196:158416:158533", -- [7]
			"157540:162666:158526:156295:158517:158564", -- [8]
			"157540:162666:158526:156196", -- [9]
			"157540:162666:159127", -- [10]
			"157540:162666:159127:159423:159125", -- [11]
			"157540:162666:159127:159423", -- [12]
			"157540:162666:158526:156196:160202", -- [13]
			"157514:157515", -- [14]
			"157540:162666:165164:167243", -- [15]
			"157540:162666:165164", -- [16]
			"157540:162666:165164:165166", -- [17]
			"157540:162666:165164:167255:167265", -- [18]
			"157540:162666:165164:165166:167247", -- [19]
			"157540:162666:165164:167255", -- [20]
			--["name"] = "Spider's Watch, Maldraxxus",
			["direct"] = "157519:157517:157516:157540",
			["m"] = 1536,
			["coord"] = 1612597947,
			["f"] = 0,
		},
		[159423] = {
			"159127:162666:165164:165701", -- [1]
			"159127:162666:165164:165701:167265", -- [2]		
			"159127:162666:158526:156196:158416:162702", -- [1]
			"159125:175457", -- [2]		
			"159127:162666", -- [1]
			"159127:162666:158526:156295", -- [2]
			"159127:162666:158526:156196:158416", -- [3]
			"159127:162666:158526:158417", -- [4]
			"159127:162666:158526:156295:158517", -- [5]
			"159127:162666:158526", -- [6]
			"159127:162666:158526:156196:158416:158533", -- [7]
			"159127:162666:158526:156295:158517:158564", -- [8]
			"159127:162666:158526:156196", -- [9]
			"159127:162666:158526:156196:160202", -- [10]
			"159127:162666:157540:157519", -- [11]
			"159127:162666:157540:157518", -- [12]
			"159127:162666:157540:157517", -- [13]
			"159127:162666:157540:157516", -- [14]
			"159127:162666:157540", -- [15]
			"159127:162666:157540:157515", -- [16]
			"159127:162666:165164:167243", -- [17]
			"159127:162666:165164", -- [18]
			"159127:162666:165164:165166", -- [19]
			"159127:162666:165164:167255:167265", -- [20]
			"159127:162666:165164:165166:167247", -- [21]
			"159127:162666:165164:167255", -- [22]
			--["name"] = "Hero's Rest, Bastion",
			["direct"] = "159127:159125:159421",
			["m"] = 1533,
			["coord"] = 2208790454,
			["f"] = 0,
		},
		[160202] = {
			"156295:158526:162666:159127:159423:159421", -- [1]
			"156295:158526:162666:165164:165701", -- [1]
			"156295:158526:162666:165164:165701:167265", -- [2]		
			"158416:162702", -- [1]
			"156295:158526:162666:159127:159423:159125:175457", -- [2]		
			"156295:158526:162666", -- [1]
			"158517:158417", -- [2]
			"156295:158526", -- [3]
			"158416:158533", -- [4]
			"156295:158526:162666:159127", -- [5]
			"156295:158526:162666:159127:159423:159125", -- [6]
			"156295:158526:162666:159127:159423", -- [7]
			"156295:158526:162666:157540:157519", -- [8]
			"156295:158526:162666:157540:157518", -- [9]
			"156295:158526:162666:157540:157517", -- [10]
			"156295:158526:162666:157540:157516", -- [11]
			"156295:158526:162666:157540", -- [12]
			"156295:158526:162666:157540:157515", -- [13]
			"156295:158526:162666:165164:167243", -- [14]
			"156295:158526:162666:165164", -- [15]
			"156295:158526:162666:165164:165166", -- [16]
			"156295:158526:162666:165164:167255:167265", -- [17]
			"156295:158526:162666:165164:165166:167247", -- [18]
			"156295:158526:162666:165164:167255", -- [19]
			--["name"] = "Charred Ramparts, Revendreth",
			["direct"] = "156295:158416:158517:158564:156196",
			["m"] = 1525,
			["coord"] = 1673821706,
			["f"] = 0,
		},
		[162702] = {
			"158416:156196:158526:162666", -- [1]
			"158416:160202:156295", -- [2]
			"158416:160202:158517:158417", -- [3]
			"158416:160202:158517", -- [4]
			"158416:156196:158526", -- [5]
			"158416:158533", -- [6]
			"158416:158564", -- [7]
			"158416:156196", -- [8]
			"158416:156196:158526:162666:159127", -- [9]
			"158416:156196:158526:162666:159127:159423:159125", -- [10]
			"158416:156196:158526:162666:159127:159423", -- [11]
			"158416:160202", -- [12]
			"158416:156196:158526:162666:157540:157519", -- [13]
			"158416:156196:158526:162666:157540:157518", -- [14]
			"158416:156196:158526:162666:157540:157517", -- [15]
			"158416:156196:158526:162666:157540:157516", -- [16]
			"158416:156196:158526:162666:157540", -- [17]
			"158416:156196:158526:162666:157540:157515", -- [18]
			"158416:156196:158526:162666:165164:167243", -- [19]
			"158416:156196:158526:162666:165164", -- [20]
			"158416:156196:158526:162666:165164:165166", -- [21]
			"158416:156196:158526:162666:165164:167255:167265", -- [22]
			"158416:156196:158526:162666:165164:165166:167247", -- [23]
			"158416:156196:158526:162666:165164:167255", -- [24]
			"158416:156196:158526:162666:159127:159423:159125:175457", -- [25]
			--["name"] = "Sinfall, Revendreth",
			["requirements"] = "qid:59315", -- Revendreth 
			["direct"] = "158416",
			["f"] = 0,
			["m"] = 1699,
			["coord"] = 2871802302,
		},		
		[158533] = {
			"158416:156196:158526:162666:159127:159423:159421", -- [1]
			"158416:156196:158526:162666:165164:165701", -- [1]
			"158416:156196:158526:162666:165164:165701:167265", -- [2]
			"158416:156196:158526:162666:159127:159423:159125:175457", -- [3]		
			"158416:156196:158526:162666", -- [1]
			"158416:160202:156295", -- [2]
			"158564:158517:158417", -- [3]
			"158564:158517", -- [4]
			"158416:156196:158526", -- [5]
			"158416:156196", -- [6]
			"158416:156196:158526:162666:159127", -- [7]
			"158416:156196:158526:162666:159127:159423:159125", -- [8]
			"158416:156196:158526:162666:159127:159423", -- [9]
			"158416:160202", -- [10]
			"158416:156196:158526:162666:157540:157519", -- [11]
			"158416:156196:158526:162666:157540:157518", -- [12]
			"158416:156196:158526:162666:157540:157517", -- [13]
			"158416:156196:158526:162666:157540:157516", -- [14]
			"158416:156196:158526:162666:157540", -- [15]
			"158416:156196:158526:162666:157540:157515", -- [16]
			"158416:156196:158526:162666:165164:167243", -- [17]
			"158416:156196:158526:162666:165164", -- [18]
			"158416:156196:158526:162666:165164:165166", -- [19]
			"158416:156196:158526:162666:165164:167255:167265", -- [20]
			"158416:156196:158526:162666:165164:165166:167247", -- [21]
			"158416:156196:158526:162666:165164:167255", -- [22]
			--["name"] = "Dominance Keep, Revendreth",
			["direct"] = "158416:158564",
			["m"] = 1525,
			["coord"] = 1117931970,
			["f"] = 0,
		},
	},
	[1978] = {
		[216283] = {
			"186487:190332:189459", -- [1]
			"186487:190332:189116", -- [2]
			"186487:186443", -- [3]
			"186487:190332:189116:186782", -- [4]
			"186487:192865:192838:191999:191976", -- [5]
			"186487:192865:192838:191999", -- [6]
			"186487:192865:192838:191999:186742", -- [7]
			"186487:190332", -- [8]
			"186487:191814:191263:184630", -- [9]
			"186487:191814:191263", -- [10]
			"186487:192865:192838", -- [11]
			"186487:192865", -- [12]
			"186487:191814", -- [13]
			"186487:191814:191263:190049", -- [14]
			"186487:191814:191263:191622", -- [15]
			"186487:191814:191263:196259", -- [16]
			"186487:191814:192494", -- [17]
			"186487:191814:192494:192493", -- [18]
			"186487:191814:192494:192493:188336", -- [19]
			"186487:191814:192494:192493:188444:XY-2194584631:192472", -- [20]
			"186487:191814:191263:184630:192491:192484:192490", -- [21]
			"186487:191814:191263:184630:192491:192484", -- [22]
			"186487:191814:191263:184630:192491", -- [23]
			"186487:191814:192494:192493:188444", -- [24]
			"186487:191814:191263:190049:192843", -- [25]
			"186487:191814:191263:196259:193321", -- [26]
			"186487:191814:191263:196259:193321:189018", -- [27]
			"186487:191814:191263:196259:193454:193458:187013", -- [28]
			"186487:191814:191263:196259:193321:189339", -- [29]
			"186487:191814:191263:196259:193321:189339:189237", -- [30]
			"186487:191814:191263:196259:193454", -- [31]
			"186487:191814:191263:196259:193454:193458", -- [32]
			"186487:191814:191263:184630:192491:192484:193477", -- [33]
			"186487:191814:191263:196259:193321:189018:193508", -- [34]
			"186487:192865:195235", -- [35]
			"186487:191814:191263:196259:193321:200561", -- [36]
			"186487:XY-1551657170:XY-1497641724:200300:202467", -- [37]
			"186487:XY-1551657170:XY-1497641724:200300:200893", -- [38]
			"186487:XY-1551657170:XY-1497641724:200300", -- [39]
			["direct"] = "186487",
			["coord"] = 2154008274,
			["m"] = 2239,
			["f"] = 0,
		},
		[209427] = {
			"211353:208280", -- [1]
			--["name"] = "Wellspring Overlook, The Emerald Dream",
			["m"] = 2200,
			["direct"] = "207636:211353",
			["coord"] = 1533564447,
			["f"] = 0,
		},
		[207636] = {
			--["name"] = "Central Encampment, The Emerald Dream",
			["direct"] = "208280:211353:209427",
			["m"] = 2200,
			["coord"] = 2192875461,
			["f"] = 0,
		},
		[208280] = {
			"211353:209427", -- [1]
			["direct"] = "207636:211353",
			["m"] = 2200,
			["coord"] = 2955709399,
			["f"] = 0,
		},
		[211353] = {
			--["name"] = "Eye of Ysera, The Emerald Dream",
			["direct"] = "207636:208280:209427",
			["m"] = 2200,
			["coord"] = 2376682442,
			["f"] = 0,
		},		
		[189339] = {
			"193321:196259:191622:191999:189116:189459", -- [1]
			"193321:196259:191622:191999:189116", -- [2]
			"193321:196259:191263:190332:186443", -- [3]
			"189018:193458:186742:191976:186782", -- [4]
			"189018:193458:186742:191976", -- [5]
			"193321:196259:191622:191999", -- [6]
			"189018:193458:186742", -- [7]
			"193321:196259:191263:190332", -- [8]
			"193321:184630", -- [9]
			"193321:196259:191263", -- [10]
			"193321:196259:191622:192838", -- [11]
			"193321:196259:191263:192865", -- [12]
			"193321:196259:191263:191814", -- [13]
			"193321:196259:191263:191814:186487", -- [14]
			"193321:184630:190049", -- [15]
			"193321:196259:191622", -- [16]
			"193321:196259", -- [17]
			"192491:188444:192493:192494", -- [18]
			"192491:188444:192493", -- [19]
			"192491:188444:188336", -- [20]
			"192484:XY-2194584631:192472", -- [21]
			"193477:192490", -- [22]
			"192491:188444", -- [23]
			"192491:192843", -- [24]
			"193321:193454", -- [25]
			"189018:193458", -- [26]
			"193321:196259:191263:195235", -- [27]
			--["name"] = "Algeth'era, Thaldraszus",
			["direct"] = "192484:192491:193321:189018:189237:193477:193508",
			["f"] = 0,
			["m"] = 2025,
			["coord"] = 2126146364,
		},
		[184630] = {
			"196259:191622:191999:189116:189459", -- [1]
			"196259:191622:191999:189116", -- [2]
			"191263:190332:186443", -- [3]
			"196259:193454:186742:191976:186782", -- [4]
			"196259:193454:186742:191976", -- [5]
			"196259:191622:191999", -- [6]
			"196259:193454:186742", -- [7]
			"191263:190332", -- [8]
			"196259:191622:192838", -- [9]
			"191263:192865", -- [10]
			"191263:191814", -- [11]
			"191263:191814:186487", -- [12]
			"196259:191622", -- [13]
			"190049:192493:192494", -- [14]
			"190049:192493", -- [15]
			"192843:188444:188336", -- [16]
			"192491:192484:XY-2194584631:192472", -- [17]
			"192491:192484:192490", -- [18]
			"192491:192484", -- [19]
			"192843:188444", -- [20]
			"193321:189018", -- [21]
			"193321:189339", -- [22]
			"196259:193454", -- [23]
			"193321:189018:193458", -- [24]
			"192491:192484:193477", -- [25]
			"193321:189018:193508", -- [26]
			"191263:195235", -- [27]
			--["name"] = "Timberstep Outpost, Ohn'ahran Plains",
			["direct"] = "191263:190049:196259:192491:192843:193321",
			["coord"] = 3660004793,
			["m"] = 2023,
			["f"] = 0,
		},
		[193458] = {
			"186742:191976:189116:189459", -- [1]
			"186742:191976:189116", -- [2]
			"186742:191976:189116:186443", -- [3]
			"186742:191976:186782", -- [4]
			"186742:191976", -- [5]
			"186742:191999", -- [6]
			"186742:191999:190332", -- [7]
			"189018:193321:184630", -- [8]
			"189018:193321:196259:191263", -- [9]
			"186742:191999:192838", -- [10]
			"186742:191999:192838:192865", -- [11]
			"189018:193321:196259:191263:191814", -- [12]
			"189018:193321:196259:191263:191814:186487", -- [13]
			"189018:193321:184630:190049", -- [14]
			"193454:191622", -- [15]
			"189018:193321:196259", -- [16]
			"189018:193321:184630:190049:192493:192494", -- [17]
			"189018:193321:184630:190049:192493", -- [18]
			"189018:193321:184630:192843:188444:188336", -- [19]
			"189018:189339:192484:XY-2194584631:192472", -- [20]
			"189018:189339:193477:192490", -- [21]
			"189018:189339:192484", -- [22]
			"189018:193321:192491", -- [23]
			"189018:193321:184630:192843:188444", -- [24]
			"189018:193321:184630:192843", -- [25]
			"189018:193321", -- [26]
			"189018:189339", -- [27]
			"189018:189339:193477", -- [28]
			"189018:193508", -- [29]
			"186742:191999:192838:195235", -- [30]
			--["name"] = "Shifting Sands, Thaldraszus",
			["direct"] = "186742:189018:193454",
			["coord"] = 2473314872,
			["m"] = 2025,
			["f"] = 0,
		},
		[190332] = {
			"189116:186782", -- [1]
			"191999:191976", -- [2]
			"191999:186742", -- [3]
			"191263:184630", -- [4]
			"192865:191814", -- [5]
			"192865:186487", -- [6]
			"191263:190049", -- [7]
			"191999:191622", -- [8]
			"191263:196259", -- [9]
			"192865:191814:192494", -- [10]
			"192865:191814:192494:192493", -- [11]
			"192865:191814:192494:192493:188336", -- [12]
			"191263:190049:188444:XY-2194584631:192472", -- [13]
			"191263:184630:192491:192484:192490", -- [14]
			"191263:184630:192491:192484", -- [15]
			"191263:184630:192491", -- [16]
			"191263:190049:188444", -- [17]
			"191263:190049:192843", -- [18]
			"191263:196259:193321", -- [19]
			"191263:196259:193321:189018", -- [20]
			"191263:196259:193321:189339", -- [21]
			"191263:196259:193454", -- [22]
			"191999:186742:193458", -- [23]
			"191263:184630:192491:192484:193477", -- [24]
			"191263:196259:193321:189018:193508", -- [25]
			"192865:195235", -- [26]
			--["name"] = "Three-Falls Lookout, Azure Span",
			["direct"] = "189459:189116:186443:191999:191263:192838:192865",
			["coord"] = 822164670,
			["m"] = 2024,
			["f"] = 0,
		},
		[192490] = {
			"192484:192491:184630:196259:191622:191999:189116:189459", -- [1]
			"192484:192491:184630:196259:191622:191999:189116", -- [2]
			"192484:192491:192843:190049:191263:190332:186443", -- [3]
			"193477:189339:189018:193458:186742:191976:186782", -- [4]
			"193477:189339:189018:193458:186742:191976", -- [5]
			"192484:192491:184630:196259:191622:191999", -- [6]
			"193477:189339:189018:193458:186742", -- [7]
			"192484:192491:192843:190049:191263:190332", -- [8]
			"192484:192491:184630", -- [9]
			"192484:192491:192843:190049:191263", -- [10]
			"192484:192491:184630:196259:191622:192838", -- [11]
			"192484:192491:192843:190049:191263:192865", -- [12]
			"192484:192491:192843:190049:191263:191814", -- [13]
			"192484:192491:192843:190049:191263:191814:186487", -- [14]
			"192484:192491:192843:190049", -- [15]
			"192484:192491:184630:196259:191622", -- [16]
			"192484:192491:184630:196259", -- [17]
			"XY-2194584631:188444:192493:192494", -- [18]
			"XY-2194584631:188444:192493", -- [19]
			"XY-2194584631:188336", -- [20]
			"XY-2194584631:192472", -- [21]
			"192484:192491", -- [22]
			"XY-2194584631:188444", -- [23]
			"192484:192491:192843", -- [24]
			"193477:189339:193321", -- [25]
			"193477:189339:189018", -- [26]
			"193477:189339", -- [27]
			"193477:189339:193321:193454", -- [28]
			"193477:189339:189018:193458", -- [29]
			"193477:189339:193508", -- [30]
			"192484:192491:192843:190049:191263:195235", -- [31]
			--["name"] = "Wingrest Embassy, The Waking Shores",
			["direct"] = "192484:193477",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 3265092022,
		},
		[190049] = {
			"191263:191622:191999:189116:189459", -- [1]
			"191263:191622:191999:189116", -- [2]
			"191263:190332:186443", -- [3]
			"184630:196259:193454:186742:191976:186782", -- [4]
			"184630:196259:193454:186742:191976", -- [5]
			"191263:191622:191999", -- [6]
			"184630:196259:193454:186742", -- [7]
			"191263:190332", -- [8]
			"191263:192838", -- [9]
			"191263:192865", -- [10]
			"191263:191814", -- [11]
			"191263:191814:186487", -- [12]
			"191263:191622", -- [13]
			"184630:196259", -- [14]
			"192493:192494", -- [15]
			"188444:188336", -- [16]
			"188444:XY-2194584631:192472", -- [17]
			"192843:192491:192484:192490", -- [18]
			"192843:192491:192484", -- [19]
			"192843:192491", -- [20]
			"184630:193321", -- [21]
			"184630:193321:189018", -- [22]
			"184630:193321:189339", -- [23]
			"184630:196259:193454", -- [24]
			"184630:193321:189018:193458", -- [25]
			"192843:192491:192484:193477", -- [26]
			"184630:193321:189018:193508", -- [27]
			"191263:195235", -- [28]
			--["name"] = "Emberwatch, Ohn'ahran Plains",
			["direct"] = "184630:191263:192493:188444:192843",
			["f"] = 0,
			["m"] = 2023,
			["coord"] = 2869903515,
		},
		[186742] = {
			"191976:189116:189459", -- [1]
			"191976:189116", -- [2]
			"191976:189116:186443", -- [3]
			"191976:186782", -- [4]
			"191999:190332", -- [5]
			"193454:196259:184630", -- [6]
			"193454:196259:191263", -- [7]
			"191999:192838", -- [8]
			"191999:192838:192865", -- [9]
			"193454:196259:191263:191814", -- [10]
			"191999:192838:192865:186487", -- [11]
			"193454:196259:184630:190049", -- [12]
			"191999:191622", -- [13]
			"193454:196259", -- [14]
			"193454:196259:191263:191814:192494", -- [15]
			"193454:196259:184630:190049:192493", -- [16]
			"193454:196259:184630:192843:188444:188336", -- [17]
			"193458:189018:189339:192484:XY-2194584631:192472", -- [18]
			"193458:189018:189339:193477:192490", -- [19]
			"193458:189018:189339:192484", -- [20]
			"193454:193321:192491", -- [21]
			"193454:196259:184630:192843:188444", -- [22]
			"193454:196259:184630:192843", -- [23]
			"193454:193321", -- [24]
			"193458:189018", -- [25]
			"193458:189018:189339", -- [26]
			"193458:189018:189339:193477", -- [27]
			"193458:189018:193508", -- [28]
			"191999:192838:195235", -- [29]
			--["name"] = "Theron's Watch, Azure Span",
			["direct"] = "191976:191999:193454:193458",
			["coord"] = 2806458851,
			["m"] = 2024,
			["f"] = 0,
		},
		[189459] = {
			"189116:191976", -- [1]
			"189116:191999", -- [2]
			"189116:191999:186742", -- [3]
			"189116:191999:191622:196259:184630", -- [4]
			"189116:191999:191622:191263", -- [5]
			"189116:191999:192838", -- [6]
			"190332:192865", -- [7]
			"190332:192865:191814", -- [8]
			"190332:192865:186487", -- [9]
			"189116:191999:191622:191263:190049", -- [10]
			"189116:191999:191622", -- [11]
			"189116:191999:191622:196259", -- [12]
			"190332:192865:191814:192494", -- [13]
			"190332:192865:191814:192494:192493", -- [14]
			"189116:191999:191622:196259:184630:192843:188444:188336", -- [15]
			"189116:191999:191622:196259:184630:192491:192484:XY-2194584631:192472", -- [16]
			"189116:191999:191622:196259:184630:192491:192484:192490", -- [17]
			"189116:191999:191622:196259:184630:192491:192484", -- [18]
			"189116:191999:191622:196259:184630:192491", -- [19]
			"189116:191999:191622:196259:184630:192843:188444", -- [20]
			"189116:191999:191622:196259:184630:192843", -- [21]
			"189116:191999:191622:196259:193321", -- [22]
			"189116:191999:186742:193458:189018", -- [23]
			"189116:191999:191622:196259:193321:189339", -- [24]
			"189116:191999:193454", -- [25]
			"189116:191999:186742:193458", -- [26]
			"189116:191999:191622:196259:184630:192491:192484:193477", -- [27]
			"189116:191999:186742:193458:189018:193508", -- [28]
			"189116:191999:192838:195235", -- [29]
			--["name"] = "Azure Archives, Azure Span",
			["direct"] = "189116:186443:186782:190332",
			["coord"] = 1593416626,
			["m"] = 2024,
			["f"] = 0,
		},
		[186443] = {
			"189116:186782", -- [1]
			"189116:191976", -- [2]
			"189116:191999", -- [3]
			"189116:191999:186742", -- [4]
			"190332:191263:184630", -- [5]
			"190332:191263", -- [6]
			"190332:192838", -- [7]
			"190332:192865", -- [8]
			"190332:192865:191814", -- [9]
			"190332:191263:190049", -- [10]
			"189116:191999:191622", -- [11]
			"190332:191263:196259", -- [12]
			"190332:192865:191814:192494", -- [13]
			"190332:192865:191814:192494:192493", -- [14]
			"190332:192865:191814:192494:192493:188336", -- [15]
			"190332:191263:190049:188444:XY-2194584631:192472", -- [16]
			"190332:191263:184630:192491:192484:192490", -- [17]
			"190332:191263:184630:192491:192484", -- [18]
			"190332:191263:184630:192491", -- [19]
			"190332:191263:190049:188444", -- [20]
			"190332:191263:190049:192843", -- [21]
			"190332:191263:196259:193321", -- [22]
			"189116:191999:186742:193458:189018", -- [23]
			"190332:191263:196259:193321:189339", -- [24]
			"189116:191999:193454", -- [25]
			"189116:191999:186742:193458", -- [26]
			"190332:191263:184630:192491:192484:193477", -- [27]
			"189116:191999:186742:193458:189018:193508", -- [28]
			"190332:192865:195235", -- [29]
			--["name"] = "Iskaara, Azure Span",
			["direct"] = "189459:189116:190332:186487",
			["coord"] = 569933036,
			["m"] = 2024,
			["f"] = 0,
		},
		[191814] = {
			"192865:190332:189459", -- [1]
			"191263:191622:191999:189116", -- [2]
			"186487:186443", -- [3]
			"191263:191622:191999:189116:186782", -- [4]
			"191263:191622:191999:191976", -- [5]
			"191263:191622:191999", -- [6]
			"191263:196259:193454:186742", -- [7]
			"192865:190332", -- [8]
			"191263:184630", -- [9]
			"191263:192838", -- [10]
			"191263:190049", -- [11]
			"191263:191622", -- [12]
			"191263:196259", -- [13]
			"192494:192493", -- [14]
			"192494:192493:188336", -- [15]
			"192494:192493:188444:XY-2194584631:192472", -- [16]
			"191263:184630:192491:192484:192490", -- [17]
			"191263:184630:192491:192484", -- [18]
			"191263:184630:192491", -- [19]
			"192494:192493:188444", -- [20]
			"191263:190049:192843", -- [21]
			"191263:196259:193321", -- [22]
			"191263:196259:193321:189018", -- [23]
			"191263:196259:193321:189339", -- [24]
			"191263:196259:193454", -- [25]
			"191263:196259:193454:193458", -- [26]
			"191263:184630:192491:192484:193477", -- [27]
			"191263:196259:193321:189018:193508", -- [28]
			"192865:195235", -- [29]
			--["name"] = "Broadhoof Outpost, Ohn'ahran Plains",
			["direct"] = "191263:192865:186487:192494",
			["f"] = 0,
			["m"] = 2023,
			["coord"] = 1998612962,
		},
		[186782] = {
			"189116:186443", -- [1]
			"189116:191999", -- [2]
			"191976:186742", -- [3]
			"189116:190332", -- [4]
			"189116:191999:191622:196259:184630", -- [5]
			"189116:191999:191622:191263", -- [6]
			"189116:191999:192838", -- [7]
			"189116:190332:192865", -- [8]
			"189116:191999:191622:191263:191814", -- [9]
			"189116:190332:192865:186487", -- [10]
			"189116:191999:191622:191263:190049", -- [11]
			"189116:191999:191622", -- [12]
			"189116:191999:191622:196259", -- [13]
			"189116:191999:191622:191263:191814:192494", -- [14]
			"189116:191999:191622:191263:190049:192493", -- [15]
			"189116:191999:191622:196259:184630:192843:188444:188336", -- [16]
			"191976:186742:193458:189018:189339:192484:XY-2194584631:192472", -- [17]
			"191976:186742:193458:189018:189339:193477:192490", -- [18]
			"191976:186742:193458:189018:189339:192484", -- [19]
			"191976:186742:193454:193321:192491", -- [20]
			"189116:191999:191622:196259:184630:192843:188444", -- [21]
			"189116:191999:191622:196259:184630:192843", -- [22]
			"191976:186742:193454:193321", -- [23]
			"191976:186742:193458:189018", -- [24]
			"191976:186742:193458:189018:189339", -- [25]
			"191976:186742:193454", -- [26]
			"191976:186742:193458", -- [27]
			"191976:186742:193458:189018:189339:193477", -- [28]
			"191976:186742:193458:189018:193508", -- [29]
			"189116:191999:192838:195235", -- [30]
			--["name"] = "Camp Nowhere, Azure Span",
			["direct"] = "189459:189116:191976",
			["coord"] = 2725025325,
			["m"] = 2024,
			["f"] = 0,
		},
		[191263] = {
			"191622:191999:189116:189459", -- [1]
			"191622:191999:189116", -- [2]
			"190332:186443", -- [3]
			"191622:191999:189116:186782", -- [4]
			"191622:191999:191976", -- [5]
			"191622:191999", -- [6]
			"196259:193454:186742", -- [7]
			"191814:186487", -- [8]
			"191814:192494", -- [9]
			"190049:192493", -- [10]
			"190049:188444:188336", -- [11]
			"190049:188444:XY-2194584631:192472", -- [12]
			"184630:192491:192484:192490", -- [13]
			"184630:192491:192484", -- [14]
			"184630:192491", -- [15]
			"190049:188444", -- [16]
			"190049:192843", -- [17]
			"196259:193321", -- [18]
			"196259:193321:189018", -- [19]
			"196259:193321:189339", -- [20]
			"196259:193454", -- [21]
			"196259:193454:193458", -- [22]
			"184630:192491:192484:193477", -- [23]
			"196259:193321:189018:193508", -- [24]
			--["name"] = "Maruukai, Ohn'ahran Plains",
			["direct"] = "190332:184630:192838:192865:191814:190049:191622:196259:195235",
			["f"] = 0,
			["m"] = 2023,
			["coord"] = 2706074598,
		},
		[188444] = {
			"192843:184630:196259:191622:191999:189116:189459", -- [1]
			"192843:184630:196259:191622:191999:189116", -- [2]
			"190049:191263:190332:186443", -- [3]
			"192843:184630:196259:193454:186742:191976:186782", -- [4]
			"192843:184630:196259:193454:186742:191976", -- [5]
			"192843:184630:196259:191622:191999", -- [6]
			"192843:184630:196259:193454:186742", -- [7]
			"190049:191263:190332", -- [8]
			"192843:184630", -- [9]
			"190049:191263", -- [10]
			"190049:191263:192838", -- [11]
			"190049:191263:192865", -- [12]
			"192493:192494:191814", -- [13]
			"192493:192494:191814:186487", -- [14]
			"192843:184630:196259:191622", -- [15]
			"192843:184630:196259", -- [16]
			"192493:192494", -- [17]
			"XY-2194584631:192472", -- [18]
			"XY-2194584631:192490", -- [19]
			"192491:192484", -- [20]
			"192843:184630:193321", -- [21]
			"192843:184630:193321:189018", -- [22]
			"192491:189339", -- [23]
			"192843:184630:196259:193454", -- [24]
			"192843:184630:193321:189018:193458", -- [25]
			"192491:192484:193477", -- [26]
			"192491:189339:193508", -- [27]
			"190049:191263:195235", -- [28]
			--["name"] = "Obsidian Bulwark, The Waking Shores",
			["direct"] = "190049:192493:188336:192491:192843",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 1814997409,
		},
		[192484] = {
			"192491:184630:196259:191622:191999:189116:189459", -- [1]
			"192491:184630:196259:191622:191999:189116", -- [2]
			"192491:192843:190049:191263:190332:186443", -- [3]
			"189339:189018:193458:186742:191976:186782", -- [4]
			"189339:189018:193458:186742:191976", -- [5]
			"192491:184630:196259:191622:191999", -- [6]
			"189339:189018:193458:186742", -- [7]
			"192491:192843:190049:191263:190332", -- [8]
			"192491:184630", -- [9]
			"192491:192843:190049:191263", -- [10]
			"192491:184630:196259:191622:192838", -- [11]
			"192491:192843:190049:191263:192865", -- [12]
			"192491:192843:190049:191263:191814", -- [13]
			"192491:192843:190049:191263:191814:186487", -- [14]
			"192491:192843:190049", -- [15]
			"192491:184630:196259:191622", -- [16]
			"192491:184630:196259", -- [17]
			"192491:188444:192493:192494", -- [18]
			"192491:188444:192493", -- [19]
			"XY-2194584631:188336", -- [20]
			"XY-2194584631:192472", -- [21]
			"192491:188444", -- [22]
			"192491:192843", -- [23]
			"192491:193321", -- [24]
			"189339:189018", -- [25]
			"192491:193321:193454", -- [26]
			"189339:189018:193458", -- [27]
			"189339:193508", -- [28]
			"192491:192843:190049:191263:195235", -- [29]
			--["name"] = "Life Vault Ruins, The Waking Shores",
			["direct"] = "192490:192491:189339:193477",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 2792854226,
		},
		[193508] = {
			"189018:193458:186742:191976:189116:189459", -- [1]
			"189018:193458:186742:191976:189116", -- [2]
			"189018:193458:186742:191976:189116:186443", -- [3]
			"189018:193458:186742:191976:186782", -- [4]
			"189018:193458:186742:191976", -- [5]
			"189018:193458:186742:191999", -- [6]
			"189018:193458:186742", -- [7]
			"189018:193321:196259:191263:190332", -- [8]
			"189018:193321:184630", -- [9]
			"189018:193321:196259:191263", -- [10]
			"189018:193321:196259:191622:192838", -- [11]
			"189018:193321:196259:191263:192865", -- [12]
			"189018:193321:196259:191263:191814", -- [13]
			"189018:193321:196259:191263:191814:186487", -- [14]
			"189018:193321:184630:190049", -- [15]
			"189018:193321:196259:191622", -- [16]
			"189018:193321:196259", -- [17]
			"189018:193321:184630:190049:192493:192494", -- [18]
			"189018:193321:184630:190049:192493", -- [19]
			"189339:192491:188444:188336", -- [20]
			"189339:192484:XY-2194584631:192472", -- [21]
			"189339:193477:192490", -- [22]
			"189339:192484", -- [23]
			"189339:192491", -- [24]
			"189339:192491:188444", -- [25]
			"189018:193321:184630:192843", -- [26]
			"189018:193321", -- [27]
			"189018:193454", -- [28]
			"189018:193458", -- [29]
			"189339:193477", -- [30]
			"189018:193321:196259:191263:195235", -- [31]
			--["name"] = "Vault of the Incarnates, Thaldraszus",
			["direct"] = "189018:189339",
			["coord"] = 3099037839,
			["m"] = 2025,
			["f"] = 0,
		},
		[193477] = {
			"192484:192491:184630:196259:191622:191999:189116:189459", -- [1]
			"192484:192491:184630:196259:191622:191999:189116", -- [2]
			"192484:192491:192843:190049:191263:190332:186443", -- [3]
			"189339:189018:193458:186742:191976:186782", -- [4]
			"189339:189018:193458:186742:191976", -- [5]
			"192484:192491:184630:196259:191622:191999", -- [6]
			"189339:189018:193458:186742", -- [7]
			"192484:192491:192843:190049:191263:190332", -- [8]
			"192484:192491:184630", -- [9]
			"192484:192491:192843:190049:191263", -- [10]
			"192484:192491:184630:196259:191622:192838", -- [11]
			"192484:192491:192843:190049:191263:192865", -- [12]
			"192484:192491:192843:190049:191263:191814", -- [13]
			"192484:192491:192843:190049:191263:191814:186487", -- [14]
			"192484:192491:192843:190049", -- [15]
			"192484:192491:184630:196259:191622", -- [16]
			"192484:192491:184630:196259", -- [17]
			"192484:192491:188444:192493:192494", -- [18]
			"192484:192491:188444:192493", -- [19]
			"192484:XY-2194584631:188336", -- [20]
			"192484:XY-2194584631:192472", -- [21]
			"192484:192491", -- [22]
			"192484:192491:188444", -- [23]
			"192484:192491:192843", -- [24]
			"189339:193321", -- [25]
			"189339:189018", -- [26]
			"189339:193321:193454", -- [27]
			"189339:189018:193458", -- [28]
			"189339:193508", -- [29]
			"192484:192491:192843:190049:191263:195235", -- [30]
			--["name"] = "Skytop Observatory, The Waking Shores",
			["direct"] = "192490:192484:189339",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 3126691053,
		},
		[192493] = {
			"190049:191263:191622:191999:189116:189459", -- [1]
			"190049:191263:191622:191999:189116", -- [2]
			"192494:191814:186487:186443", -- [3]
			"190049:184630:196259:193454:186742:191976:186782", -- [4]
			"190049:184630:196259:193454:186742:191976", -- [5]
			"190049:191263:191622:191999", -- [6]
			"190049:184630:196259:193454:186742", -- [7]
			"192494:191814:192865:190332", -- [8]
			"190049:184630", -- [9]
			"190049:191263", -- [10]
			"190049:191263:192838", -- [11]
			"192494:191814:192865", -- [12]
			"192494:191814", -- [13]
			"192494:191814:186487", -- [14]
			"190049:191263:191622", -- [15]
			"190049:184630:196259", -- [16]
			"188444:XY-2194584631:192472", -- [17]
			"188444:XY-2194584631:192490", -- [18]
			"188444:192491:192484", -- [19]
			"188444:192491", -- [20]
			"188444:192843", -- [21]
			"190049:184630:193321", -- [22]
			"190049:184630:193321:189018", -- [23]
			"188444:192491:189339", -- [24]
			"190049:184630:196259:193454", -- [25]
			"190049:184630:193321:189018:193458", -- [26]
			"188444:192491:192484:193477", -- [27]
			"190049:184630:193321:189018:193508", -- [28]
			"190049:191263:195235", -- [29]
			--["name"] = "Apex Observatory, The Waking Shores",
			["direct"] = "190049:192494:188336:188444",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 1021498578,
		},
		[193454] = {
			"191999:189116:189459", -- [1]
			"191999:189116", -- [2]
			"191999:189116:186443", -- [3]
			"186742:191976:186782", -- [4]
			"186742:191976", -- [5]
			"196259:191263:190332", -- [6]
			"196259:184630", -- [7]
			"196259:191263", -- [8]
			"191622:192838", -- [9]
			"196259:191263:192865", -- [10]
			"196259:191263:191814", -- [11]
			"196259:191263:191814:186487", -- [12]
			"196259:184630:190049", -- [13]
			"196259:191263:191814:192494", -- [14]
			"196259:184630:190049:192493", -- [15]
			"196259:184630:192843:188444:188336", -- [16]
			"193321:192491:192484:XY-2194584631:192472", -- [17]
			"193321:192491:192484:192490", -- [18]
			"193321:192491:192484", -- [19]
			"193321:192491", -- [20]
			"196259:184630:192843:188444", -- [21]
			"196259:184630:192843", -- [22]
			"193321:189339", -- [23]
			"193321:189339:193477", -- [24]
			"189018:193508", -- [25]
			"191622:192838:195235", -- [26]
			--["name"] = "Garden Shrine, Thaldraszus",
			["direct"] = "191999:186742:191622:196259:193321:189018:193458",
			["coord"] = 1528744438,
			["m"] = 2025,
			["f"] = 0,
		},
		[188336] = {
			"188444:192843:184630:196259:191622:191999:189116:189459", -- [1]
			"188444:192843:184630:196259:191622:191999:189116", -- [2]
			"192493:192494:191814:186487:186443", -- [3]
			"188444:192843:184630:196259:193454:186742:191976:186782", -- [4]
			"188444:192843:184630:196259:193454:186742:191976", -- [5]
			"188444:192843:184630:196259:191622:191999", -- [6]
			"188444:192843:184630:196259:193454:186742", -- [7]
			"188444:190049:191263:190332", -- [8]
			"188444:192843:184630", -- [9]
			"188444:190049:191263", -- [10]
			"188444:190049:191263:192838", -- [11]
			"192493:192494:191814:192865", -- [12]
			"192493:192494:191814", -- [13]
			"192493:192494:191814:186487", -- [14]
			"188444:190049", -- [15]
			"188444:192843:184630:196259:191622", -- [16]
			"188444:192843:184630:196259", -- [17]
			"192493:192494", -- [18]
			"XY-2194584631:192472", -- [19]
			"XY-2194584631:192490", -- [20]
			"XY-2194584631:192484", -- [21]
			"188444:192491", -- [22]
			"188444:192843", -- [23]
			"188444:192843:184630:193321", -- [24]
			"188444:192843:184630:193321:189018", -- [25]
			"188444:192491:189339", -- [26]
			"188444:192843:184630:196259:193454", -- [27]
			"188444:192843:184630:193321:189018:193458", -- [28]
			"XY-2194584631:192484:193477", -- [29]
			"188444:192491:189339:193508", -- [30]
			"188444:190049:191263:195235", -- [31]
			--["name"] = "Obsidian Throne, The Waking Shores",
			["direct"] = "192493:188444",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 1087345070,
		},
		[193321] = {
			"189018:193458:187013", -- [1]
			"XY-2241298411:XY-3139928389:202467", -- [2]
			"XY-2241298411:XY-3139928389:202467:200893", -- [3]
			"196259:191263:192865:XY-1551657170:XY-1497641724:200300", -- [4]		
			"196259:191622:191999:189116:189459", -- [1]
			"196259:191622:191999:189116", -- [2]
			"196259:191263:190332:186443", -- [3]
			"193454:186742:191976:186782", -- [4]
			"193454:186742:191976", -- [5]
			"196259:191622:191999", -- [6]
			"193454:186742", -- [7]
			"196259:191263:190332", -- [8]
			"196259:191263", -- [9]
			"196259:191622:192838", -- [10]
			"196259:191263:192865", -- [11]
			"196259:191263:191814", -- [12]
			"196259:191263:191814:186487", -- [13]
			"184630:190049", -- [14]
			"196259:191622", -- [15]
			"184630:190049:192493:192494", -- [16]
			"184630:190049:192493", -- [17]
			"184630:192843:188444:188336", -- [18]
			"192491:192484:XY-2194584631:192472", -- [19]
			"192491:192484:192490", -- [20]
			"192491:192484", -- [21]
			"184630:192843:188444", -- [22]
			"184630:192843", -- [23]
			"189018:193458", -- [24]
			"189339:193477", -- [25]
			"189018:193508", -- [26]
			"196259:191263:195235", -- [27]
			--["name"] = "Valdrakken, Thaldraszus",
			["direct"] = "184630:196259:192491:189018:189339:193454",
			["coord"] = 1902554428,
			["m"] = 2112,
			["f"] = 0,
		},
		[189116] = {
			"190332:186487", -- [1]
			"191999:186742:193458:187013", -- [2]
			"191999:191622:196259:193321:200561", -- [3]
			"191999:191622:196259:193321:XY-2241298411:XY-3139928389:202467", -- [4]
			"191999:191622:196259:193321:XY-2241298411:XY-3139928389:202467:200893", -- [5]
			"190332:192865:XY-1551657170:XY-1497641724:200300", -- [6]		
			"191999:186742", -- [1]
			"191999:191622:196259:184630", -- [2]
			"191999:191622:191263", -- [3]
			"191999:192838", -- [4]
			"190332:192865", -- [5]
			"191999:191622:191263:191814", -- [6]
			"190332:192865:186487", -- [7]
			"191999:191622:191263:190049", -- [8]
			"191999:191622", -- [9]
			"191999:191622:196259", -- [10]
			"191999:191622:191263:191814:192494", -- [11]
			"191999:191622:191263:190049:192493", -- [12]
			"191999:191622:196259:184630:192843:188444:188336", -- [13]
			"191999:191622:196259:184630:192491:192484:XY-2194584631:192472", -- [14]
			"191999:191622:196259:184630:192491:192484:192490", -- [15]
			"191999:191622:196259:184630:192491:192484", -- [16]
			"191999:191622:196259:184630:192491", -- [17]
			"191999:191622:196259:184630:192843:188444", -- [18]
			"191999:191622:196259:184630:192843", -- [19]
			"191999:191622:196259:193321", -- [20]
			"191999:186742:193458:189018", -- [21]
			"191999:191622:196259:193321:189339", -- [22]
			"191999:193454", -- [23]
			"191999:186742:193458", -- [24]
			"191999:191622:196259:184630:192491:192484:193477", -- [25]
			"191999:186742:193458:189018:193508", -- [26]
			"191999:192838:195235", -- [27]
			--["name"] = "Camp Antonidas, Azure Span",
			["direct"] = "189459:186443:186782:191976:191999:190332",
			["coord"] = 2007655772,
			["m"] = 2024,
			["f"] = 0,
		},
		[195235] = {
			"192838:191999:186742:193458:187013", -- [1]
			"191263:196259:193321:200561", -- [2]
			"192865:XY-1551657170:XY-1497641724:200300:202467", -- [3]
			"192865:XY-1551657170:XY-1497641724:200300:200893", -- [4]
			"192865:XY-1551657170:XY-1497641724:200300", -- [5]		
			"192838:191999:189116:189459", -- [1]
			"192838:191999:189116", -- [2]
			"192865:190332:186443", -- [3]
			"192838:191999:189116:186782", -- [4]
			"192838:191999:191976", -- [5]
			"192838:191999", -- [6]
			"192838:191999:186742", -- [7]
			"192865:190332", -- [8]
			"191263:184630", -- [9]
			"192865:191814", -- [10]
			"192865:186487", -- [11]
			"191263:190049", -- [12]
			"192838:191622", -- [13]
			"191263:196259", -- [14]
			"192865:191814:192494", -- [15]
			"191263:190049:192493", -- [16]
			"191263:190049:188444:188336", -- [17]
			"191263:190049:188444:XY-2194584631:192472", -- [18]
			"191263:184630:192491:192484:192490", -- [19]
			"191263:184630:192491:192484", -- [20]
			"191263:184630:192491", -- [21]
			"191263:190049:188444", -- [22]
			"191263:190049:192843", -- [23]
			"191263:196259:193321", -- [24]
			"191263:196259:193321:189018", -- [25]
			"191263:196259:193321:189339", -- [26]
			"192838:191622:193454", -- [27]
			"192838:191999:186742:193458", -- [28]
			"191263:184630:192491:192484:193477", -- [29]
			"191263:196259:193321:189018:193508", -- [30]
			--["name"] = "Ohn'iri Springs, Ohn'ahran Plains",
			["direct"] = "191263:192838:192865",
			["f"] = 0,
			["m"] = 2023,
			["coord"] = 2436416505,
		},
		[196259] = {
			"191622:191999:189116:189459", -- [1]
			"191622:191999:189116", -- [2]
			"191263:190332:186443", -- [3]
			"193454:186742:191976:186782", -- [4]
			"193454:186742:191976", -- [5]
			"191622:191999", -- [6]
			"193454:186742", -- [7]
			"191263:190332", -- [8]
			"191622:192838", -- [9]
			"191263:192865", -- [10]
			"191263:191814", -- [11]
			"191263:191814:186487", -- [12]
			"184630:190049", -- [13]
			"191263:191814:192494", -- [14]
			"184630:190049:192493", -- [15]
			"184630:192843:188444:188336", -- [16]
			"184630:192491:192484:XY-2194584631:192472", -- [17]
			"184630:192491:192484:192490", -- [18]
			"184630:192491:192484", -- [19]
			"184630:192491", -- [20]
			"184630:192843:188444", -- [21]
			"184630:192843", -- [22]
			"193321:189018", -- [23]
			"193321:189339", -- [24]
			"193454:193458", -- [25]
			"184630:192491:192484:193477", -- [26]
			"193321:189018:193508", -- [27]
			"191263:195235", -- [28]
			--["name"] = "Rusza'thar Reach, Ohn'ahran Plains",
			["direct"] = "184630:191263:191622:193321:193454",
			["coord"] = 3636289181,
			["m"] = 2023,
			["f"] = 0,
		},
		[192865] = {
			"191263:196259:193454:193458:187013", -- [1]
			"191263:196259:193321:200561", -- [2]
			"XY-1551657170:XY-1497641724:200300:202467", -- [3]
			"XY-1551657170:XY-1497641724:200300:200893", -- [4]
			"XY-1551657170:XY-1497641724:200300", -- [5]		
			"190332:189459", -- [1]
			"190332:189116", -- [2]
			"190332:186443", -- [3]
			"190332:189116:186782", -- [4]
			"192838:191999:191976", -- [5]
			"192838:191999", -- [6]
			"192838:191999:186742", -- [7]
			"191263:184630", -- [8]
			"191263:190049", -- [9]
			"191263:191622", -- [10]
			"191263:196259", -- [11]
			"191814:192494", -- [12]
			"191814:192494:192493", -- [13]
			"191814:192494:192493:188336", -- [14]
			"191814:192494:192493:188444:XY-2194584631:192472", -- [15]
			"191263:184630:192491:192484:192490", -- [16]
			"191263:184630:192491:192484", -- [17]
			"191263:184630:192491", -- [18]
			"191814:192494:192493:188444", -- [19]
			"191263:190049:192843", -- [20]
			"191263:196259:193321", -- [21]
			"191263:196259:193321:189018", -- [22]
			"191263:196259:193321:189339", -- [23]
			"191263:196259:193454", -- [24]
			"191263:196259:193454:193458", -- [25]
			"191263:184630:192491:192484:193477", -- [26]
			"191263:196259:193321:189018:193508", -- [27]
			--["name"] = "Teerakai, Ohn'ahran Plains",
			["direct"] = "190332:191263:192838:191814:186487:195235",
			["f"] = 0,
			["m"] = 2023,
			["coord"] = 1718852779,
		},
		[187013] = {
			"193458:186742:191976:189116:189459", -- [1]
			"193458:186742:191976:189116", -- [2]
			"193458:186742:191976:189116:186443", -- [3]
			"193458:186742:191976:186782", -- [4]
			"193458:186742:191976", -- [5]
			"193458:186742:191999", -- [6]
			"193458:186742", -- [7]
			"193458:186742:191999:190332", -- [8]
			"193458:189018:193321:184630", -- [9]
			"193458:189018:193321:196259:191263", -- [10]
			"193458:186742:191999:192838", -- [11]
			"193458:186742:191999:192838:192865", -- [12]
			"193458:189018:193321:196259:191263:191814", -- [13]
			"193458:189018:193321:196259:191263:191814:186487", -- [14]
			"193458:189018:193321:184630:190049", -- [15]
			"193458:193454:191622", -- [16]
			"193458:189018:193321:196259", -- [17]
			"193458:189018:193321:184630:190049:192493", -- [18]
			"193458:189018:193321:184630:192843:188444:188336", -- [19]
			"193458:189018:189339:192484:XY-2194584631:192472", -- [20]
			"193458:189018:189339:193477:192490", -- [21]
			"193458:189018:189339:192484", -- [22]
			"193458:189018:193321:192491", -- [23]
			"193458:189018:193321:184630:192843:188444", -- [24]
			"193458:189018:193321:184630:192843", -- [25]
			"193458:189018:193321", -- [26]
			"193458:189018", -- [27]
			"193458:189018:189339", -- [28]
			"193458:189018:189339:189237", -- [29]
			"193458:193454", -- [30]
			"193458:189018:189339:193477", -- [31]
			"193458:189018:193508", -- [32]
			"193458:186742:191999:192838:195235", -- [33]
			"193458:189018:189339:189237:200561", -- [34]
			"193458:189018:193321:XY-2241298411:XY-3139928389:202467", -- [35]
			"193458:189018:193321:XY-2241298411:XY-3139928389:202467:200893", -- [36]
			"193458:186742:191999:192838:192865:XY-1551657170:XY-1497641724:200300", -- [37]
			--["name"] = "Temporal Conflux, Thaldraszus",
			["m"] = 2025,
			["coord"] = 2572800093,
			["direct"] = "193458",
			["f"] = 0,
		},		
		[191999] = {
			"186742:193458:187013", -- [1]
			"191622:196259:193321:200561", -- [2]
			"191622:196259:193321:XY-2241298411:XY-3139928389:202467", -- [3]
			"191622:196259:193321:XY-2241298411:XY-3139928389:202467:200893", -- [4]
			"192838:192865:XY-1551657170:XY-1497641724:200300", -- [5]		
			"189116:189459", -- [1]
			"189116:186443", -- [2]
			"189116:186782", -- [3]
			"191622:196259:184630", -- [4]
			"191622:191263", -- [5]
			"192838:192865", -- [6]
			"191622:191263:191814", -- [7]
			"192838:192865:186487", -- [8]
			"191622:191263:190049", -- [9]
			"191622:196259", -- [10]
			"191622:191263:191814:192494", -- [11]
			"191622:191263:190049:192493", -- [12]
			"191622:196259:184630:192843:188444:188336", -- [13]
			"191622:196259:184630:192491:192484:XY-2194584631:192472", -- [14]
			"191622:196259:184630:192491:192484:192490", -- [15]
			"191622:196259:184630:192491:192484", -- [16]
			"191622:196259:184630:192491", -- [17]
			"191622:196259:184630:192843:188444", -- [18]
			"191622:196259:184630:192843", -- [19]
			"191622:196259:193321", -- [20]
			"186742:193458:189018", -- [21]
			"191622:196259:193321:189339", -- [22]
			"186742:193458", -- [23]
			"191622:196259:184630:192491:192484:193477", -- [24]
			"186742:193458:189018:193508", -- [25]
			"192838:195235", -- [26]
			--["name"] = "Cobalt Assembly, Azure Span",
			["direct"] = "189116:191976:186742:190332:192838:191622:193454",
			["coord"] = 2109684260,
			["m"] = 2024,
			["f"] = 0,
		},
		[192472] = {
			"XY-2194584631:192484:192491:184630:196259:191622:191999:189116:189459", -- [1]
			"XY-2194584631:192484:192491:184630:196259:191622:191999:189116", -- [2]
			"XY-2194584631:188444:190049:191263:190332:186443", -- [3]
			"XY-2194584631:192484:189339:189018:193458:186742:191976:186782", -- [4]
			"XY-2194584631:192484:189339:189018:193458:186742:191976", -- [5]
			"XY-2194584631:192484:192491:184630:196259:191622:191999", -- [6]
			"XY-2194584631:192484:189339:189018:193458:186742", -- [7]
			"XY-2194584631:188444:190049:191263:190332", -- [8]
			"XY-2194584631:192484:192491:184630", -- [9]
			"XY-2194584631:188444:190049:191263", -- [10]
			"XY-2194584631:192484:192491:184630:196259:191622:192838", -- [11]
			"XY-2194584631:188444:190049:191263:192865", -- [12]
			"XY-2194584631:188444:192493:192494:191814", -- [13]
			"XY-2194584631:188444:192493:192494:191814:186487", -- [14]
			"XY-2194584631:188444:190049", -- [15]
			"XY-2194584631:192484:192491:184630:196259:191622", -- [16]
			"XY-2194584631:192484:192491:184630:196259", -- [17]
			"XY-2194584631:188444:192493:192494", -- [18]
			"XY-2194584631:188444:192493", -- [19]
			"XY-2194584631:188336", -- [20]
			"XY-2194584631:192490", -- [21]
			"XY-2194584631:192484", -- [22]
			"XY-2194584631:192484:192491", -- [23]
			"XY-2194584631:188444", -- [24]
			"XY-2194584631:188444:192843", -- [25]
			"XY-2194584631:192484:192491:193321", -- [26]
			"XY-2194584631:192484:189339:189018", -- [27]
			"XY-2194584631:192484:189339", -- [28]
			"XY-2194584631:192484:192491:193321:193454", -- [29]
			"XY-2194584631:192484:189339:189018:193458", -- [30]
			"XY-2194584631:192484:193477", -- [31]
			"XY-2194584631:192484:189339:193508", -- [32]
			"XY-2194584631:188444:190049:191263:195235", -- [33]
			--["name"] = "Uktulut Pier, The Waking Shores",
			["m"] = 2022,
			["f"] = 0,
			["coord"] = 1968981624,
		},
		[191976] = {
			"189116:189459", -- [1]
			"189116:186443", -- [2]
			"191999:190332", -- [3]
			"186742:193454:196259:184630", -- [4]
			"191999:191622:191263", -- [5]
			"191999:192838", -- [6]
			"191999:192838:192865", -- [7]
			"191999:191622:191263:191814", -- [8]
			"191999:192838:192865:186487", -- [9]
			"191999:191622:191263:190049", -- [10]
			"191999:191622", -- [11]
			"186742:193454:196259", -- [12]
			"191999:191622:191263:191814:192494", -- [13]
			"191999:191622:191263:190049:192493", -- [14]
			"186742:193454:196259:184630:192843:188444:188336", -- [15]
			"186742:193458:189018:189339:192484:XY-2194584631:192472", -- [16]
			"186742:193458:189018:189339:193477:192490", -- [17]
			"186742:193458:189018:189339:192484", -- [18]
			"186742:193454:193321:192491", -- [19]
			"186742:193454:196259:184630:192843:188444", -- [20]
			"186742:193454:196259:184630:192843", -- [21]
			"186742:193454:193321", -- [22]
			"186742:193458:189018", -- [23]
			"186742:193458:189018:189339", -- [24]
			"186742:193454", -- [25]
			"186742:193458", -- [26]
			"186742:193458:189018:189339:193477", -- [27]
			"186742:193458:189018:193508", -- [28]
			"191999:192838:195235", -- [29]
			--["name"] = "Rhonin's Shield, Azure Span",
			["direct"] = "189116:186782:191999:186742",
			["coord"] = 2834579721,
			["m"] = 2024,
			["f"] = 0,
		},
		[189018] = {
			"193458:186742:191976:189116:189459", -- [1]
			"193458:186742:191976:189116", -- [2]
			"193458:186742:191976:189116:186443", -- [3]
			"193458:186742:191976:186782", -- [4]
			"193458:186742:191976", -- [5]
			"193458:186742:191999", -- [6]
			"193458:186742", -- [7]
			"193321:196259:191263:190332", -- [8]
			"193321:184630", -- [9]
			"193321:196259:191263", -- [10]
			"193321:196259:191622:192838", -- [11]
			"193321:196259:191263:192865", -- [12]
			"193321:196259:191263:191814", -- [13]
			"193321:196259:191263:191814:186487", -- [14]
			"193321:184630:190049", -- [15]
			"193321:196259:191622", -- [16]
			"193321:196259", -- [17]
			"193321:184630:190049:192493:192494", -- [18]
			"193321:184630:190049:192493", -- [19]
			"193321:184630:192843:188444:188336", -- [20]
			"189339:192484:XY-2194584631:192472", -- [21]
			"189339:193477:192490", -- [22]
			"189339:192484", -- [23]
			"193321:192491", -- [24]
			"193321:184630:192843:188444", -- [25]
			"193321:184630:192843", -- [26]
			"189339:193477", -- [27]
			"193321:196259:191263:195235", -- [28]
			--["name"] = "Gelikyr Post, Thaldraszus",
			["direct"] = "193321:189339:193454:193458:193508",
			["coord"] = 2195827620,
			["m"] = 2025,
			["f"] = 0,
		},
		[192494] = {
			"191814:192865:190332:189459", -- [1]
			"191814:191263:191622:191999:189116", -- [2]
			"191814:186487:186443", -- [3]
			"191814:191263:191622:191999:189116:186782", -- [4]
			"191814:191263:191622:191999:191976", -- [5]
			"191814:191263:191622:191999", -- [6]
			"191814:191263:196259:193454:186742", -- [7]
			"191814:192865:190332", -- [8]
			"192493:190049:184630", -- [9]
			"191814:191263", -- [10]
			"191814:191263:192838", -- [11]
			"191814:192865", -- [12]
			"191814:186487", -- [13]
			"192493:190049", -- [14]
			"191814:191263:191622", -- [15]
			"191814:191263:196259", -- [16]
			"192493:188336", -- [17]
			"192493:188444:XY-2194584631:192472", -- [18]
			"192493:188444:XY-2194584631:192490", -- [19]
			"192493:188444:192491:192484", -- [20]
			"192493:188444:192491", -- [21]
			"192493:188444", -- [22]
			"192493:188444:192843", -- [23]
			"192493:190049:184630:193321", -- [24]
			"192493:190049:184630:193321:189018", -- [25]
			"192493:188444:192491:189339", -- [26]
			"191814:191263:196259:193454", -- [27]
			"192493:190049:184630:193321:189018:193458", -- [28]
			"192493:188444:192491:192484:193477", -- [29]
			"192493:190049:184630:193321:189018:193508", -- [30]
			"191814:192865:195235", -- [31]
			--["name"] = "Uktulut Outpost, The Waking Shores",
			["direct"] = "191814:192493",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 752149271,
		},
		[191622] = {
			"191999:189116:189459", -- [1]
			"191999:189116", -- [2]
			"191999:189116:186443", -- [3]
			"191999:189116:186782", -- [4]
			"191999:191976", -- [5]
			"191999:186742", -- [6]
			"191263:190332", -- [7]
			"196259:184630", -- [8]
			"191263:192865", -- [9]
			"191263:191814", -- [10]
			"191263:191814:186487", -- [11]
			"191263:190049", -- [12]
			"191263:191814:192494", -- [13]
			"191263:190049:192493", -- [14]
			"196259:184630:192843:188444:188336", -- [15]
			"196259:184630:192491:192484:XY-2194584631:192472", -- [16]
			"196259:184630:192491:192484:192490", -- [17]
			"196259:184630:192491:192484", -- [18]
			"196259:184630:192491", -- [19]
			"196259:184630:192843:188444", -- [20]
			"196259:184630:192843", -- [21]
			"196259:193321", -- [22]
			"193454:189018", -- [23]
			"196259:193321:189339", -- [24]
			"193454:193458", -- [25]
			"196259:184630:192491:192484:193477", -- [26]
			"193454:189018:193508", -- [27]
			"192838:195235", -- [28]
			--["name"] = "Pinewood Post, Ohn'ahran Plains",
			["direct"] = "191999:191263:192838:196259:193454",
			["coord"] = 3455292502,
			["m"] = 2023,
			["f"] = 0,
		},
		[186487] = {
			"190332:189459", -- [1]
			"190332:189116", -- [2]
			"190332:189116:186782", -- [3]
			"191814:191263:196259:193454:193458:187013", -- [4]
			"191814:191263:196259:193321:200561", -- [5]
			"XY-1551657170:XY-1497641724:200300:202467", -- [6]
			"XY-1551657170:XY-1497641724:200300:200893", -- [7]
			"XY-1551657170:XY-1497641724:200300", -- [8]		
			"186443:189459", -- [1]
			"192865:190332:189116", -- [2]
			"192865:190332:189116:186782", -- [3]
			"192865:192838:191999:191976", -- [4]
			"192865:192838:191999", -- [5]
			"192865:192838:191999:186742", -- [6]
			"192865:190332", -- [7]
			"191814:191263:184630", -- [8]
			"191814:191263", -- [9]
			"192865:192838", -- [10]
			"191814:191263:190049", -- [11]
			"191814:191263:191622", -- [12]
			"191814:191263:196259", -- [13]
			"191814:192494", -- [14]
			"191814:192494:192493", -- [15]
			"191814:192494:192493:188336", -- [16]
			"191814:192494:192493:188444:XY-2194584631:192472", -- [17]
			"191814:191263:184630:192491:192484:192490", -- [18]
			"191814:191263:184630:192491:192484", -- [19]
			"191814:191263:184630:192491", -- [20]
			"191814:192494:192493:188444", -- [21]
			"191814:191263:190049:192843", -- [22]
			"191814:191263:196259:193321", -- [23]
			"191814:191263:196259:193321:189018", -- [24]
			"191814:191263:196259:193321:189339", -- [25]
			"191814:191263:196259:193454", -- [26]
			"191814:191263:196259:193454:193458", -- [27]
			"191814:191263:184630:192491:192484:193477", -- [28]
			"191814:191263:196259:193321:189018:193508", -- [29]
			"192865:195235", -- [30]
			"191814:191263:196259:193321:189339:189237", -- [1]
			--["name"] = "Shady Sanctuary, Ohn'ahran Plains",
			["direct"] = "186443:190332:192865:191814:216283",
			["f"] = 0,
			["m"] = 2023,
			["coord"] = 1280086983,
		},
		[192838] = {
			"184630:193321:189018:193458:187013", -- [1]
			"192491:192484:192490:200561", -- [2]
			"184630:193321:XY-2241298411:XY-3139928389:202467", -- [3]
			"184630:193321:XY-2241298411:XY-3139928389:202467:200893", -- [4]
			"190049:191263:192865:XY-1551657170:XY-1497641724:200300", -- [5]		
			"191999:186742:193458:187013", -- [1]
			"191622:196259:193321:200561", -- [2]
			"191622:196259:193321:XY-2241298411:XY-3139928389:202467", -- [3]
			"192865:XY-1551657170:XY-1497641724:200300:200893", -- [4]
			"192865:XY-1551657170:XY-1497641724:200300", -- [5]		
			"191999:189116:189459", -- [1]
			"191999:189116", -- [2]
			"190332:186443", -- [3]
			"191999:189116:186782", -- [4]
			"191999:191976", -- [5]
			"191999:186742", -- [6]
			"191622:196259:184630", -- [7]
			"191263:191814", -- [8]
			"192865:186487", -- [9]
			"191263:190049", -- [10]
			"191622:196259", -- [11]
			"191263:191814:192494", -- [12]
			"191263:190049:192493", -- [13]
			"191263:190049:188444:188336", -- [14]
			"191263:190049:188444:XY-2194584631:192472", -- [15]
			"191622:196259:184630:192491:192484:192490", -- [16]
			"191622:196259:184630:192491:192484", -- [17]
			"191622:196259:184630:192491", -- [18]
			"191263:190049:188444", -- [19]
			"191263:190049:192843", -- [20]
			"191622:196259:193321", -- [21]
			"191622:193454:189018", -- [22]
			"191622:196259:193321:189339", -- [23]
			"191622:193454", -- [24]
			"191999:186742:193458", -- [25]
			"191622:196259:184630:192491:192484:193477", -- [26]
			"191622:193454:189018:193508", -- [27]
			--["name"] = "Forkriver Crossing, Ohn'ahran Plains",
			["direct"] = "191999:190332:191263:192865:191622:195235",
			["coord"] = 3078146718,
			["m"] = 2023,
			["f"] = 0,
		},
		[202467] = {
			"XY-3139928389:XY-2241298411:193321:196259:191622:191999:189116:189459", -- [1]
			"XY-3139928389:XY-2241298411:193321:196259:191622:191999:189116", -- [2]
			"200300:XY-1545475988:XY-1669749166:190332:186443", -- [3]
			"XY-3139928389:XY-2241298411:193321:193454:186742:191976:186782", -- [4]
			"XY-3139928389:XY-2241298411:193321:193454:186742:191976", -- [5]
			"XY-3139928389:XY-2241298411:193321:196259:191622:191999", -- [6]
			"XY-3139928389:XY-2241298411:193321:193454:186742", -- [7]
			"200300:XY-1545475988:XY-1669749166:190332", -- [8]
			"XY-3139928389:XY-2241298411:193321:184630", -- [9]
			"XY-3139928389:XY-2241298411:193321:196259:191263", -- [10]
			"XY-3139928389:XY-2241298411:193321:196259:191622:192838", -- [11]
			"XY-3139928389:XY-2241298411:193321:196259:191263:192865", -- [12]
			"XY-3139928389:XY-2241298411:193321:196259:191263:191814", -- [13]
			"200300:XY-1497641724:XY-1551657170:186487", -- [14]
			"XY-3139928389:XY-2241298411:193321:184630:190049", -- [15]
			"XY-3139928389:XY-2241298411:193321:196259:191622", -- [16]
			"XY-3139928389:XY-2241298411:193321:196259", -- [17]
			"XY-3139928389:XY-2241298411:193321:184630:190049:192493", -- [18]
			"XY-3139928389:XY-2241298411:193321:184630:192843:188444:188336", -- [19]
			"XY-3139928389:XY-2241298411:193321:192491:192484:XY-2194584631:192472", -- [20]
			"XY-3139928389:XY-2241298411:193321:192491:192484:192490", -- [21]
			"XY-3139928389:XY-2241298411:193321:192491:192484", -- [22]
			"XY-3139928389:XY-2241298411:193321:192491", -- [23]
			"XY-3139928389:XY-2241298411:193321:184630:192843:188444", -- [24]
			"XY-3139928389:XY-2241298411:193321:184630:192843", -- [25]
			"XY-3139928389:XY-2241298411:193321", -- [26]
			"XY-3139928389:XY-2241298411:193321:189018", -- [27]
			"XY-3139928389:XY-2241298411:193321:189018:193458:187013", -- [28]
			"XY-3139928389:XY-2241298411:193321:189339", -- [29]
			"XY-3139928389:XY-2241298411:193321:189339:189237", -- [30]
			"XY-3139928389:XY-2241298411:193321:193454", -- [31]
			"XY-3139928389:XY-2241298411:193321:189018:193458", -- [32]
			"XY-3139928389:XY-2241298411:193321:189339:193477", -- [33]
			"XY-3139928389:XY-2241298411:193321:189018:193508", -- [34]
			"XY-3139928389:XY-2241298411:193321:196259:191263:195235", -- [35]
			"XY-3139928389:XY-2241298411:193321:200561", -- [36]
			--["name"] = "Loamm, Zaralek Cavern",
			["m"] = 2133,
			["f"] = 0,
			["direct"] = "200893:200300",
			["coord"] = 2388888642,
		},		
		[192843] = {
			"184630:196259:191622:191999:189116:189459", -- [1]
			"184630:196259:191622:191999:189116", -- [2]
			"190049:191263:190332:186443", -- [3]
			"184630:196259:193454:186742:191976:186782", -- [4]
			"184630:196259:193454:186742:191976", -- [5]
			"184630:196259:191622:191999", -- [6]
			"184630:196259:193454:186742", -- [7]
			"190049:191263:190332", -- [8]
			"190049:191263", -- [9]
			"184630:196259:191622:192838", -- [10]
			"190049:191263:192865", -- [11]
			"190049:191263:191814", -- [12]
			"190049:191263:191814:186487", -- [13]
			"184630:196259:191622", -- [14]
			"184630:196259", -- [15]
			"188444:192493:192494", -- [16]
			"188444:192493", -- [17]
			"188444:188336", -- [18]
			"188444:XY-2194584631:192472", -- [19]
			"192491:192484:192490", -- [20]
			"192491:192484", -- [21]
			"184630:193321", -- [22]
			"184630:193321:189018", -- [23]
			"192491:189339", -- [24]
			"184630:196259:193454", -- [25]
			"184630:193321:189018:193458", -- [26]
			"192491:192484:193477", -- [27]
			"184630:193321:189018:193508", -- [28]
			"190049:191263:195235", -- [29]
			--["name"] = "Dragonscale Basecamp, The Waking Shores",
			["direct"] = "184630:190049:192491:188444",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 2057753930,
		},
		[192491] = {
			"193321:189018:193458:187013", -- [1]
			"192484:192490:200561", -- [2]
			"193321:XY-2241298411:XY-3139928389:202467", -- [3]
			"193321:XY-2241298411:XY-3139928389:202467:200893", -- [4]
			"192843:190049:191263:192865:XY-1551657170:XY-1497641724:200300", -- [5]		
			"184630:196259:191622:191999:189116:189459", -- [1]
			"184630:196259:191622:191999:189116", -- [2]
			"192843:190049:191263:190332:186443", -- [3]
			"193321:193454:186742:191976:186782", -- [4]
			"193321:193454:186742:191976", -- [5]
			"184630:196259:191622:191999", -- [6]
			"193321:193454:186742", -- [7]
			"192843:190049:191263:190332", -- [8]
			"192843:190049:191263", -- [9]
			"184630:196259:191622:192838", -- [10]
			"192843:190049:191263:192865", -- [11]
			"192843:190049:191263:191814", -- [12]
			"192843:190049:191263:191814:186487", -- [13]
			"192843:190049", -- [14]
			"184630:196259:191622", -- [15]
			"184630:196259", -- [16]
			"188444:192493:192494", -- [17]
			"188444:192493", -- [18]
			"188444:188336", -- [19]
			"192484:XY-2194584631:192472", -- [20]
			"192484:192490", -- [21]
			"193321:189018", -- [22]
			"193321:193454", -- [23]
			"193321:189018:193458", -- [24]
			"192484:193477", -- [25]
			"189339:193508", -- [26]
			"192843:190049:191263:195235", -- [27]
			--["name"] = "Ruby Life Pools, The Waking Shores",
			["direct"] = "184630:192484:188444:192843:193321:189339",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 2483007014,
		},
		[189237] = {
			"189339:193321:196259:191622:191999:189116:189459", -- [1]
			"189339:193321:196259:191622:191999:189116", -- [2]
			"189339:193321:196259:191263:190332:186443", -- [3]
			"189339:189018:193458:186742:191976:186782", -- [4]
			"189339:189018:193458:186742:191976", -- [5]
			"189339:193321:196259:191622:191999", -- [6]
			"189339:189018:193458:186742", -- [7]
			"189339:193321:196259:191263:190332", -- [8]
			"189339:193321:184630", -- [9]
			"189339:193321:196259:191263", -- [10]
			"189339:193321:196259:191622:192838", -- [11]
			"189339:193321:196259:191263:192865", -- [12]
			"189339:193321:196259:191263:191814", -- [13]
			"189339:193321:196259:191263:191814:186487", -- [14]
			"193477:192484:192491:192843:190049", -- [15]
			"189339:193321:196259:191622", -- [16]
			"189339:193321:196259", -- [17]
			"193477:192484:192491:188444:192493:192494", -- [18]
			"193477:192484:192491:188444:192493", -- [19]
			"192490:XY-2194584631:188336", -- [20]
			"192490:XY-2194584631:192472", -- [21]
			"193477:192484", -- [22]
			"193477:192484:192491", -- [23]
			"193477:192484:192491:188444", -- [24]
			"193477:192484:192491:192843", -- [25]
			"189339:193321", -- [26]
			"189339:189018", -- [27]
			"189339:193321:193454", -- [28]
			"189339:189018:193458", -- [29]
			"189339:193321:196259:191263:195235", -- [30]
			["m"] = 2025,
			["coord"] = 2666344523,
			["direct"] = "192490:189339:193477:193508",
			["f"] = 0,
		},
	},
	[2274] = {
		[249811] = {
		--["name"] = "Ruins of Yaathron",
		["direct"] = "249744:249747:249754:249761:249764:249765:249768:249771:249775:249778:249781:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 2207230942,
		["isPhase"] = true,
		},
		[249764] = {
		--["name"] = "Serrated Peaks",
		["direct"] = "249744:249747:249754:249761:249765:249768:249771:249775:249778:249781:249811:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 2198502510,
		["isPhase"] = true,
		},
		[249765] = {
		--["name"] = "Overlook Zo'Shuul",
		["direct"] = "249744:249747:249754:249761:249764:249768:249771:249775:249778:249781:249811:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 2165398860,
		["isPhase"] = true,
		},
		[249781] = {
		--["name"] = "Untethered Space",
		["direct"] = "249744:249747:249754:249761:249764:249765:249768:249771:249775:249778:249811:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 2316125313,
		["isPhase"] = true,
		},
		[249775] = {
		--["name"] = "Naakroa",
		["direct"] = "249744:249747:249754:249761:249764:249765:249768:249771:249778:249781:249811:249841",
		["coord"] = 2529530925,
		["m"] = 2371,
		["f"] = 0,
		["isPhase"] = true,
		},
		[249744] = {
		--["name"] = "Tazavesh, the Veiled Market",
		["direct"] = "249747:249754:249761:249764:249765:249768:249771:249775:249778:249781:249811:249841",
		["f"] = 0,
		["m"] = 2472,
		["coord"] = 2010943967,
		["isPhase"] = true,
		},
		[249768] = {
		--["name"] = "Lunnall River",
		["direct"] = "249744:249747:249754:249761:249764:249765:249771:249775:249778:249781:249811:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 2811329214,
		["isPhase"] = true,
		},
		[249761] = {
		--["name"] = "Shadow Point",
		["direct"] = "249744:249747:249754:249764:249765:249768:249771:249775:249778:249781:249811:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 1941454100,
		["isPhase"] = true,
		},
		[249754] = {
		--["name"] = "Shan'dorah",
		["direct"] = "249744:249747:249761:249764:249765:249768:249771:249775:249778:249781:249811:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 2586004069,
		["isPhase"] = true,
		},
		[249841] = {
		--["name"] = "Hosaas' Rest",
		["direct"] = "249744:249747:249754:249761:249764:249765:249768:249771:249775:249781:249811",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 2311627439,
		["isPhase"] = true,
		},
		[249747] = {
		["m"] = 2371,
		["f"] = 0,
		["direct"] = "249744:249754:249761:249764:249765:249768:249771:249775:249778:249781:249811:249841",
		["coord"] = 3258930414,
		["isPhase"] = true,
		},
		[249771] = {
		--["name"] = "North Sufaad",
		["direct"] = "249744:249747:249754:249761:249764:249765:249768:249775:249778:249781:249811:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 3313597755,
		["isPhase"] = true,
		},
		[234692] = {
		"234722:234718",
		"234701:234724:234719",
		"234701:234724",
		--["name"] = "Tazavesh, K'aresh",
		["m"] = 2472,
		["direct"] = "234722:234721:234701",
		["coord"] = 1492916753,
		["f"] = 0,
		},
		[234719] = {
		"234724:234701:234692",
		"234724:234722",
		"234721:234718",
		"234724:234701",
		--["name"] = "Shadow Point, K'aresh",
		["m"] = 2371,
		["direct"] = "234721:234724",
		["coord"] = 1814313484,
		["f"] = 0,
		},
		[234701] = {
		"234692:234722",
		"234724:234721",
		"234724:234719",
		--["name"] = "Hosaas Rest, K'aresh",
		["m"] = 2371,
		["direct"] = "234692:234718:234724",
		["coord"] = 2328404166,
		["f"] = 0,
		},
		[234724] = {
		"234701:234692",
		"234721:234718",
		--["name"] = "Overlook Zo'Shuul, K'aresh",
		["direct"] = "234722:234721:234719:234701",
		["m"] = 2371,
		["coord"] = 2053398366,
		["f"] = 0,
		},
		[234721] = {
		"234718:234722",
		"234724:234701",
		--["name"] = "Shan'dorah, K'aresh",
		["direct"] = "234692:234718:234719:234724",
		["m"] = 2371,
		["coord"] = 2602650286,
		["f"] = 0,
		},
		[234718] = {
		"234722:234692",
		"234721:234719",
		"234721:234724",
		["direct"] = "234722:234721:234701",
		["m"] = 2371,
		["coord"] = 3292027245,
		["f"] = 0,
		},
		[234722] = {
		"234718:234721",
		"234724:234719",
		"234692:234701",
		--["name"] = "Eco-Dome: Rhovan, K'aresh",
		["m"] = 2371,
		["direct"] = "234692:234718:234724",
		["coord"] = 3014827013,
		["f"] = 0,
		},
	[208384] = {
		"216972:209330",
		"216972:216979",
		"216973:218298:217639",
		"216973:224940:224884",
		"216973:224940",
		"216973:218298:215563:212369",
		"216973:218298:215563:212369:217439",
		"216973:218298:215563:212369:217542",
		"216973:218298:215563:212369:217543",
		"218304:218305",
		"218304:218305:218323",
		"218304:218305:218295",
		"218304:218300:206537",
		"216973:218298",
		"216973:218298:215563",
		"216973:224940:218388",
		--["name"] = "Wildcamp Or'lay, Azj-Kahet",
		["m"] = 2255,
		["coord"] = 996639466,
		["direct"] = "207470:216972:216973:218304",
		["f"] = 0,
		},
		[216979] = {
		"216972:208384",
		"207470:216973",
		"207470:216973:218298:217639",
		"216972:208384:218304",
		"207470:216973:224940:224884",
		"207470:216973:224940",
		"207470:216973:218298:215563:212369",
		"207470:216973:218298:215563:212369:217439",
		"207470:216973:218298:215563:212369:217542",
		"207470:216973:218298:215563:212369:217543",
		"216972:208384:218304:218305",
		"216972:208384:218304:218305:218323",
		"207470:216973:218298:217639:218295",
		"207470:216973:218298:217639:206537",
		"207470:216973:218298",
		"207470:216973:218298:215563",
		"207470:216973:224940:218388",
		--["name"] = "Mmarl, Azj-Kahet",
		["direct"] = "207470:209330:216972",
		["coord"] = 3301287163,
		["m"] = 2255,
		["f"] = 0,
		},
		[207470] = {
		"216973:218298:217639",
		"208384:218304",
		"216973:224940:224884",
		"216973:224940",
		"216973:218298:215563:212369",
		"216973:218298:215563:212369:217439",
		"216973:218298:215563:212369:217542",
		"216973:218298:215563:212369:217543",
		"208384:218304:218305",
		"216973:218298:218323",
		"216973:218298:217639:218295",
		"216973:218298:217639:206537",
		"216973:218298",
		"216973:218298:215563",
		"216973:224940:218388",
		--["name"] = "Weaver's Lair, Azj-Kahet",
		["m"] = 2255,
		["coord"] = 2443737166,
		["direct"] = "208384:209330:216972:216973:216979",
		["f"] = 0,
		},
		[216972] = {
		"207470:216973",
		"207470:216973:218298:217639",
		"208384:218304",
		"207470:216973:224940:224884",
		"207470:216973:224940",
		"207470:216973:218298:215563:212369",
		"207470:216973:218298:215563:212369:217439",
		"207470:216973:218298:215563:212369:217542",
		"207470:216973:218298:215563:212369:217543",
		"208384:218304:218305",
		"208384:218304:218305:218323",
		"208384:218304:218305:218295",
		"207470:216973:218298:217639:206537",
		"207470:216973:218298",
		"207470:216973:218298:215563",
		"207470:216973:224940:218388",
		--["name"] = "Wildcamp Ul'ar, Azj-Kahet",
		["m"] = 2255,
		["coord"] = 1912253613,
		["direct"] = "207470:208384:209330:216979",
		["f"] = 0,
		},
		[217542] = {
		"212369:215563:218298:216973:207470",
		"212369:215563:217639:218300:218304:208384",
		"212369:215563:218298:216973:207470:209330",
		"212369:215563:218298:216973:207470:216972",
		"212369:215563:218298:216973",
		"212369:215563:218298:216973:207470:216979",
		"212369:215563:217639",
		"212369:215563:217639:218300:218304",
		"212369:215563:224940:224884",
		"212369:215563:224940",
		"212369:217439",
		"212369:215563:217639:218305",
		"212369:215563:217639:218295:218323",
		"212369:215563:217639:218295",
		"212369:215563:217639:206537",
		"212369:215563:218298",
		"212369:215563",
		"212369:215563:218388",
		"212369:215563:224940:224884:228137",
		["m"] = 2248,
		["direct"] = "212369:217543",
		["coord"] = 2897047267,
		["f"] = 0,
		},
		[217639] = {
		"218298:216973:207470",
		"218300:218304:208384",
		"218298:216973:207470:209330",
		"218298:216973:207470:216972",
		"218298:216973",
		"218298:216973:207470:216979",
		"218300:218304",
		"215563:224940:224884",
		"215563:224940",
		"215563:212369",
		"215563:212369:217439",
		"215563:212369:217542",
		"215563:212369:217543",
		"218295:218323",
		"215563:218388",
		--["name"] = "Dunelle's Kindness, Hallowfall",
		["m"] = 2215,
		["f"] = 0,
		["direct"] = "218305:218295:206537:218298:215563",
		["coord"] = 2899276334,
		},
		[218298] = {
		"216973:207470",
		"216973:208384",
		"216973:207470:209330",
		"216973:207470:216972",
		"216973:207470:216979",
		"218300:218304",
		"216973:224940:224884",
		"216973:224940",
		"215563:212369",
		"215563:212369:217439",
		"215563:212369:217542",
		"215563:212369:217543",
		"218300:218305",
		"217639:218295",
		"217639:206537",
		"215563:218388",
		--["name"] = "The Aegis Wall, Hallowfall",
		["m"] = 2215,
		["f"] = 0,
		["direct"] = "216973:217639:218323:215563",
		["coord"] = 3063845001,
		},
		[224940] = {
		"216973:207470",
		"216973:208384",
		"216973:207470:209330",
		"216973:207470:216972",
		"216973:207470:216979",
		"215563:217639",
		"216973:218298:218300:218304",
		"215563:212369",
		"215563:212369:217439",
		"215563:212369:217542",
		"215563:212369:217543",
		"215563:217639:218305",
		"216973:218298:218323",
		"215563:217639:218295",
		"215563:217639:206537",
		"216973:218298",
		--["name"] = "Camp Murroch, The Ringing Deeps",
		["m"] = 2214,
		["f"] = 0,
		["direct"] = "216973:224884:215563:218388",
		["coord"] = 2321654804,
		},
		[228137] = {
		"224884:224940:216973:207470",
		"224884:224940:216973:208384",
		"224884:224940:216973:207470:209330",
		"224884:224940:216973:207470:216972",
		"224884:224940:216973",
		"224884:224940:216973:207470:216979",
		"224884:224940:215563:217639",
		"224884:224940:216973:218298:218300:218304",
		"224884:224940",
		"224884:224940:215563:212369",
		"224884:224940:215563:212369:217439",
		"224884:224940:215563:212369:217542",
		"224884:224940:215563:212369:217543",
		"224884:224940:215563:217639:218305",
		"224884:224940:216973:218298:218323",
		"224884:224940:215563:217639:218295",
		"224884:224940:215563:217639:206537",
		"224884:224940:216973:218298",
		"224884:224940:215563",
		"224884:224940:218388",
		--["name"] = "Gutterville, The Ringing Deeps",
		["direct"] = "224884",
		["f"] = 0,
		["m"] = 2214,
		["coord"] = 3073496433,
		},
		[209330] = {
		"216972:208384",
		"207470:216973",
		"207470:216973:218298:217639",
		"216972:208384:218304",
		"207470:216973:224940:224884",
		"207470:216973:224940",
		"207470:216973:218298:215563:212369",
		"207470:216973:218298:215563:212369:217439",
		"207470:216973:218298:215563:212369:217542",
		"207470:216973:218298:215563:212369:217543",
		"216972:208384:218304:218305",
		"216972:208384:218304:218305:218323",
		"216972:208384:218304:218305:218295",
		"207470:216973:218298:217639:206537",
		"207470:216973:218298",
		"207470:216973:218298:215563",
		"207470:216973:224940:218388",
		--["name"] = "The Burrows, Azj-Kahet",
		["direct"] = "207470:216972:216979",
		["coord"] = 2315481549,
		["m"] = 2216,
		["f"] = 0,
		},
		[217543] = {
		--["name"] = "Rambleshire, Isle of Dorn",
		},
		[215563] = {
		"218298:216973:207470",
		"217639:218300:218304:208384",
		"218298:216973:207470:209330",
		"218298:216973:207470:216972",
		"218298:216973",
		"218298:216973:207470:216979",
		"217639:218300:218304",
		"224940:224884",
		"212369:217439",
		"212369:217542",
		"212369:217543",
		"217639:218305",
		"217639:218295:218323",
		"217639:218295",
		"217639:206537",
		--["name"] = "Gundargaz, The Ringing Deeps",
		["m"] = 2214,
		["f"] = 0,
		["direct"] = "217639:224940:212369:218298:218388",
		["coord"] = 1834833265,
		},
		[218295] = {
		"217639:218298:216973:207470",
		"218305:218304:208384",
		"218305:218304:208384:216972:209330",
		"218305:218304:208384:216972",
		"217639:218298:216973",
		"217639:218298:216973:207470:216979",
		"218305:218304",
		"217639:215563:224940:224884",
		"217639:215563:224940",
		"217639:215563:212369",
		"217639:215563:212369:217439",
		"217639:215563:212369:217542",
		"217639:215563:212369:217543",
		"217639:218298",
		"217639:215563",
		"217639:215563:218388",
		--["name"] = "Lorel's Crossing, Hallowfall",
		["m"] = 2215,
		["f"] = 0,
		["direct"] = "217639:218305:218323:206537",
		["coord"] = 2076469271,
		},
		[212369] = {
		"215563:218298:216973:207470",
		"215563:217639:218300:218304:208384",
		"215563:218298:216973:207470:209330",
		"215563:218298:216973:207470:216972",
		"215563:218298:216973",
		"215563:218298:216973:207470:216979",
		"215563:217639",
		"215563:217639:218300:218304",
		"215563:224940:224884",
		"215563:224940",
		"215563:217639:218305",
		"215563:217639:218295:218323",
		"215563:217639:218295",
		"215563:217639:206537",
		"215563:218298",
		"215563:218388",
		"215563:224940:224884:228137",
		--["name"] = "Dornogal, Isle of Dorn",
		["direct"] = "217439:217542:217543:215563",
		["m"] = 2339,
		["f"] = 0,
		["coord"] = 1922466475,
		},
		[206537] = {
		"217639:218298:216973:207470",
		"218295:218305:218304:208384",
		"217639:218298:216973:207470:209330",
		"217639:218298:216973:207470:216972",
		"217639:218298:216973",
		"217639:218298:216973:207470:216979",
		"218295:218305:218304",
		"217639:215563:224940:224884",
		"217639:215563:224940",
		"217639:215563:212369",
		"217639:215563:212369:217439",
		"217639:215563:212369:217542",
		"217639:215563:212369:217543",
		"218295:218305",
		"218295:218323",
		"217639:218298",
		"217639:215563",
		"217639:215563:218388",
		--["name"] = "Hillhelm Family Farm, Hallowfall",
		["direct"] = "217639:218295",
		["f"] = 0,
		["m"] = 2215,
		["coord"] = 2634174279,
		},
		[217439] = {
		"212369:215563:218298:216973:207470",
		"212369:215563:217639:218300:218304:208384",
		"212369:215563:218298:216973:207470:209330",
		"212369:215563:218298:216973:207470:216972",
		"212369:215563:218298:216973",
		"212369:215563:218298:216973:207470:216979",
		"212369:215563:217639",
		"212369:215563:217639:218300:218304",
		"212369:215563:224940:224884",
		"212369:215563:224940",
		"212369:217542",
		"212369:217543",
		"212369:215563:217639:218305",
		"212369:215563:217639:218295:218323",
		"212369:215563:217639:218295",
		"212369:215563:217639:206537",
		"212369:215563:218298",
		"212369:215563",
		"212369:215563:218388",
		"212369:215563:224940:224884:228137",
		--["name"] = "Freywold Village, Isle of Dorn",
		["direct"] = "212369",
		["m"] = 2248,
		["coord"] = 1763949255,
		["f"] = 0,
		},
		[216973] = {
		"207470:209330",
		"207470:216972",
		"207470:216979",
		"218298:217639",
		"218298:218300:218304",
		"224940:224884",
		"218298:215563:212369",
		"218298:215563:212369:217439",
		"218298:215563:212369:217542",
		"218298:215563:212369:217543",
		"218298:218300:218305",
		"218298:218323",
		"218298:217639:218295",
		"218298:217639:206537",
		"218298:215563",
		"224940:218388",
		--["name"] = "Faerin's Advance, Azj-Kahet",
		["m"] = 2255,
		["f"] = 0,
		["direct"] = "207470:208384:224940:218298",
		["coord"] = 2574266368,
		},
		[224884] = {
		"224940:216973:207470",
		"224940:216973:208384",
		"224940:216973:207470:209330",
		"224940:216973:207470:216972",
		"224940:216973",
		"224940:216973:207470:216979",
		"224940:215563:217639",
		"224940:216973:218298:218300:218304",
		"224940:215563:212369",
		"224940:215563:212369:217439",
		"224940:215563:212369:217542",
		"224940:215563:212369:217543",
		"224940:215563:217639:218305",
		"224940:216973:218298:218323",
		"224940:215563:217639:218295",
		"224940:215563:217639:206537",
		"224940:216973:218298",
		"224940:215563",
		"224940:218388",
		--["name"] = "Opportunity Point, The Ringing Deeps",
		["direct"] = "224940",
		["f"] = 0,
		["m"] = 2214,
		["coord"] = 2600847371,
		},
		[218304] = {
		"208384:207470",
		"208384:216972:209330",
		"208384:216972",
		"218300:218298:216973",
		"208384:216972:216979",
		"218300:217639",
		"218300:218298:216973:224940:224884",
		"218300:218298:216973:224940",
		"218300:217639:215563:212369",
		"218300:217639:215563:212369:217439",
		"218300:217639:215563:212369:217542",
		"218300:217639:215563:212369:217543",
		"218305:218323",
		"218305:218295",
		"218300:206537",
		"218300:218298",
		"218300:217639:215563",
		"218300:217639:215563:218388",
		--["name"] = "Light's Redoubt, Hallowfall",
		["direct"] = "208384:218305",
		["coord"] = 1737537109,
		["m"] = 2215,
		["f"] = 0,
		},
		[218323] = {
		"218295:217639:218298:216973:207470",
		"218304:208384",
		"218304:208384:216972:209330",
		"218304:208384:216972",
		"218295:217639:218298:216973",
		"218295:217639:218298:216973:207470:216979",
		"218295:217639",
		"218295:217639:215563:224940:224884",
		"218295:217639:215563:224940",
		"218295:217639:215563:212369",
		"218295:217639:215563:212369:217439",
		"218295:217639:215563:212369:217542",
		"218295:217639:215563:212369:217543",
		"218295:206537",
		"218295:217639:218298",
		"218295:217639:215563",
		"218295:217639:215563:218388",
		--["name"] = "Priory of the Sacred Flame, Hallowfall",
		["direct"] = "218304:218305:218295",
		["f"] = 0,
		["m"] = 2215,
		["coord"] = 1764513354,
		},
		[218388] = {
		"224940:216973:207470",
		"224940:216973:208384",
		"224940:216973:207470:209330",
		"224940:216973:207470:216972",
		"224940:216973",
		"224940:216973:207470:216979",
		"215563:217639",
		"215563:217639:218300:218304",
		"224940:224884",
		"215563:212369",
		"215563:212369:217439",
		"215563:212369:217542",
		"215563:212369:217543",
		"215563:217639:218305",
		"215563:217639:218295:218323",
		"215563:217639:218295",
		"215563:217639:206537",
		"215563:218298",
		--["name"] = "Shadowvein Point, The Ringing Deeps",
		["direct"] = "224940:215563",
		["f"] = 0,
		["m"] = 2214,
		["coord"] = 2459728570,
		},
		[218305] = {
		"218304:208384:207470",
		"218304:208384",
		"218304:208384:216972:209330",
		"218304:208384:216972",
		"217639:218298:216973",
		"218304:208384:216972:216979",
		"217639:215563:224940:224884",
		"217639:215563:224940",
		"217639:215563:212369",
		"217639:215563:212369:217439",
		"217639:215563:212369:217542",
		"217639:215563:212369:217543",
		"218295:206537",
		"217639:218298",
		"217639:215563",
		"217639:215563:218388",
		--["name"] = "Mereldar, Hallowfall",
		["m"] = 2215,
		["f"] = 0,
		["direct"] = "217639:218304:218323:218295",
		["coord"] = 1785300631,
		},
		[230878] = {
		--["name"] = "Slam Central Station",
		["direct"] = "230879:230882:230881:230880",
		["m"] = 2346,
		["coord"] = 1050379774,
		["f"] = 0,
		},
		[230879] = {
		--["name"] = "The Incontinental Hotel",
		["direct"] = "230882:230878:230881:230880",
		["m"] = 2346,
		["coord"] = 1842771528,
		["f"] = 0,
		},
		[230880] = {
		--["name"] = "The Gallagio",
		["direct"] = "230879:230882:230878:230881",
		["m"] = 2346,
		["coord"] = 2650045235,
		["f"] = 0,
		},
		[230882] = {
		"230879:230878",
		--["name"] = "The Heaps",
		["m"] = 2346,
		["direct"] = "230879:230881:230880",
		["coord"] = 1879427803,
		["f"] = 0,
		},
		[230881] = {
		--["name"] = "Demolition Dome",
		["m"] = 2346,
		["direct"] = "230879:230882:230878:230880",
		["coord"] = 2492864210,
		["f"] = 0,
		},	
	},
	[2537] = {
	[255056] = {
	["m"] = 2576,
	["f"] = 0,
	["direct"] = "248036:254935:254936:247997",
	["coord"] = 3036973132,
	},
	[247997] = {
	--["name"] = "Har'mara, Harandar",
	["direct"] = "248036:255056:254935:254936",
	["f"] = 0,
	["m"] = 2413,
	["coord"] = 1526217967,
	},
	[235703] = {
	["m"] = 2405,
	["f"] = 0,
	["direct"] = "240683:244636:245356",
	["coord"] = 2197336391,
	},
	[254935] = {
	--["name"] = "Har'kuai, Harandar",
	["direct"] = "248036:255056:254936:247997",
	["f"] = 0,
	["m"] = 2413,
	["coord"] = 2774940473,
	},
	[244636] = {
	--["name"] = "Locus Point, Voidstorm",
	["direct"] = "240683:235703:245356",
	["f"] = 0,
	["m"] = 2405,
	["coord"] = 1815329975,
	},
	[245356] = {
	--["name"] = "Masters' Perch, Voidstorm",
	["direct"] = "240683:244636:235703",
	["f"] = 0,
	["m"] = 2444,
	["coord"] = 1638911129,
	},
	[254936] = {
	--["name"] = "Har'alnor, Harandar",
	["direct"] = "248036:255056:254935:247997",
	["f"] = 0,
	["m"] = 2413,
	["coord"] = 1362603169,
	},
	[240683] = {
	--["name"] = "The Ingress, Voidstorm",
	["direct"] = "244636:235703:245356",
	["f"] = 0,
	["m"] = 2405,
	["coord"] = 1584895739,
	},
	[248036] = {
	--["name"] = "Har'athir, Harandar",
	["direct"] = "255056:254935:254936:247997",
	["f"] = 0,
	["m"] = 2413,
	["coord"] = 2979038881,
	},
	},
	},

	["Alliance"] = {
	{
	[4321] = {
	"39212:39210:35136:4407",
	"40358:40367:41383",
	"16227:4267:XY-1974645611:XY-2030030181:10897",
	"16227:4267:22931:12578:11138",
	"16227:4267:22931:12578",
	"7823:10583",
	"16227:4267:XY-1974645611:XY-2030030181:17555:17554",
	"16227:4267:XY-1974645611:XY-2030030181:17555",
	"16227:4267:22931",
	"16227:4267:22935",
	"16227:4267:34374",
	"39212:39210:34378",
	"39212:39210:35136:35137",
	"39212:39210:35136",
	"39212:39210:35136:6706:35138",
	"39212:39210:35136:6706:35481",
	"39212:39210:35136:6706:35478",
	"39212:39210:35136:6706:35556",
	"39212:39210:35136:6706:35562",
	"7823:39175",
	"39212:39210",
	"40358:39211",
	"40358:40768",
	"7823:40827",
	"7823:41214",
	"39212:39210:35136:35137:41240",
	"16227:4267:22935:XY-2454825450:43481",
	"16227:4267:22935:XY-2454825450:43481:41860",
	"16227:4267:22935:XY-2454825450:43481:41861",
	"40358:40367:41383:40966",
	"40358:40367:41580",
	"16227:4267:22931:43073",
	"16227:4267:22931:43079",
	"16227:4267:22935:XY-2454825450",
	"16227:4267:XY-1974645611:XY-2030030181:17555:43991",
	"7823:40827:48275",
	"7823:39175:163253",
	"7823:40827:48275:XY-1868173255",
	"16227:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Theramore, Dustwallow Marsh",
	["m"] = 70,
	["f"] = 0,
	["direct"] = "4267:40367:6706:7823:16227:40358:39212",
	["coord"] = 2897904416,
	},
	[12578] = {
	"XY-1974645611:4267",
	"XY-1974645611:4267:34378:6706:35481:40966:41383:41580:40367",
	"XY-1974645611:4267:16227:4321",
	"XY-1974645611:4407",
	"XY-1974645611:4267:34378:6706",
	"XY-1974645611:4267:34378:39210:39211:40358:40768:7823",
	"XY-1974645611:4267:34378:6706:35481:40966:41383",
	"XY-1974645611:4267:34378:39210:39211:40358:40768:7823:10583",
	"XY-1974645611:4267:16227",
	"XY-2030030181:17555:17554",
	"XY-2030030181:17555",
	"22931:22935",
	"XY-1974645611:4267:34378:39210:39211:40358",
	"XY-1974645611:34374",
	"XY-1974645611:4267:34378",
	"XY-1974645611:4267:34378:35137",
	"XY-1974645611:4267:34378:35136",
	"XY-1974645611:4407:35138",
	"XY-1974645611:4267:34378:6706:35481",
	"XY-1974645611:4267:34378:6706:35478",
	"XY-1974645611:4267:34378:6706:35556",
	"XY-1974645611:4267:34378:6706:35562",
	"XY-1974645611:4267:34378:6706:35481:40966:41383:39175",
	"XY-1974645611:4267:34378:39210",
	"XY-1974645611:4267:34378:39210:39212",
	"XY-1974645611:4267:34378:39210:39211",
	"XY-1974645611:4267:34378:39210:39211:40358:40768",
	"XY-1974645611:4267:34378:39210:39211:40358:40768:7823:40827",
	"XY-1974645611:4267:34378:39210:39211:40358:40768:7823:41214",
	"XY-1974645611:4407:41240",
	"10897:41861:43481",
	"10897:41861:41860",
	"10897:41861",
	"XY-1974645611:4267:34378:6706:35481:40966",
	"XY-1974645611:4267:34378:6706:35481:40966:41383:41580",
	"43073:43079",
	"10897:41861:43481:XY-2454825450",
	"XY-2030030181:17555:43991",
	"XY-1974645611:4267:34378:6706:35481:40966:41383:163253:48275",
	"XY-1974645611:4267:34378:6706:35481:40966:41383:163253",
	"XY-1974645611:4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	"10897:41861:43481:54392",
	--["name"] = "Talonbranch Glade, Felwood",
	["m"] = 77,
	["coord"] = 2600943807,
	["direct"] = "10897:11138:22931:43073",
	["f"] = 0,
	},
	[35556] = {
	"6706:34378:4267",
	"35478:35481:40966:41383:41580:40367",
	"6706:35136:39210:39212:4321",
	"6706:4407",
	"6706:35136:39210:39211:40358:40768:7823",
	"35478:35481:40966:41383",
	"6706:34378:4267:XY-1974645611:XY-2030030181:10897",
	"6706:34378:4267:22931:12578:11138",
	"6706:34378:4267:22931:12578",
	"35478:35481:40966:41383:39175:10583",
	"6706:35136:39210:16227",
	"6706:34378:4267:XY-1974645611:XY-2030030181:17555:17554",
	"6706:34378:4267:XY-1974645611:XY-2030030181:17555",
	"6706:34378:4267:22931",
	"6706:34378:4267:22935",
	"6706:35136:39210:39211:40358",
	"6706:34378:4267:34374",
	"6706:34378",
	"6706:35137",
	"6706:35136",
	"6706:35138",
	"35478:35481",
	"35478:35481:40966:41383:39175",
	"6706:35136:39210",
	"6706:35136:39210:39212",
	"6706:35136:39210:39211",
	"6706:35136:39210:39211:40358:40768",
	"6706:35136:39210:39211:40358:40768:7823:40827",
	"6706:35136:39210:39211:40358:40768:7823:41214",
	"6706:35138:41240",
	"6706:34378:4267:22935:XY-2454825450:43481",
	"6706:34378:4267:22935:XY-2454825450:43481:41860",
	"6706:34378:4267:22935:XY-2454825450:43481:41861",
	"35478:35481:40966",
	"35478:35481:40966:41383:41580",
	"6706:34378:4267:22931:43073",
	"6706:34378:4267:22931:43079",
	"6706:34378:4267:22935:XY-2454825450",
	"6706:34378:4267:XY-1974645611:XY-2030030181:17555:43991",
	"35478:35481:40966:41383:163253:48275",
	"35478:35481:40966:41383:163253",
	"35478:35481:40966:41383:163253:XY-1868173255",
	"6706:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Thunk's Abode, Desolace",
	["m"] = 66,
	["coord"] = 3034666036,
	["direct"] = "6706:35478:35562",
	["f"] = 0,
	},
	[39212] = {
	"16227:4267",
	"4321:40358:40367",
	"39210:35136:4407",
	"39210:35136:6706",
	"4321:7823",
	"4321:40358:40367:41383",
	"16227:4267:XY-1974645611:XY-2030030181:10897",
	"16227:4267:22931:12578:11138",
	"16227:4267:22931:12578",
	"4321:7823:10583",
	"16227:4267:XY-1974645611:XY-2030030181:17555:17554",
	"16227:4267:XY-1974645611:XY-2030030181:17555",
	"16227:4267:22931",
	"16227:4267:22935",
	"4321:40358",
	"16227:4267:34374",
	"39210:34378",
	"39210:35136:35137",
	"39210:35136",
	"39210:35136:6706:35138",
	"39210:35136:6706:35481",
	"39210:35136:6706:35478",
	"39210:35136:6706:35556",
	"39210:35136:6706:35562",
	"4321:7823:39175",
	"4321:40358:40768",
	"4321:7823:40827",
	"4321:7823:41214",
	"39210:35136:35137:41240",
	"16227:4267:22935:XY-2454825450:43481",
	"16227:4267:22935:XY-2454825450:43481:41860",
	"16227:4267:22935:XY-2454825450:43481:41861",
	"39210:35136:6706:35481:40966",
	"4321:40358:40367:41580",
	"16227:4267:22931:43073",
	"16227:4267:22931:43079",
	"16227:4267:22935:XY-2454825450",
	"16227:4267:XY-1974645611:XY-2030030181:17555:43991",
	"4321:7823:40827:48275",
	"4321:7823:39175:163253",
	"4321:7823:40827:48275:XY-1868173255",
	"16227:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Northwatch Hold, Southern Barrens",
	["m"] = 199,
	["f"] = 0,
	["direct"] = "4321:16227:39210:39211",
	["coord"] = 2849601694,
	},
	[41860] = {
	"43481:XY-2454825450:22935:4267",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:41580:40367",
	"43481:XY-2454825450:22935:4267:16227:4321",
	"43481:XY-2454825450:22935:4267:34378:4407",
	"43481:XY-2454825450:22935:4267:34378:6706",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383",
	"41861:10897",
	"41861:11138",
	"41861:10897:12578",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823:10583",
	"43481:XY-2454825450:22935:4267:16227",
	"41861:10897:XY-2030030181:17555:17554",
	"41861:10897:XY-2030030181:17555",
	"43481:XY-2454825450:22935:22931",
	"43481:XY-2454825450:22935",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358",
	"43481:XY-2454825450:22935:4267:34374",
	"43481:XY-2454825450:22935:4267:34378",
	"43481:XY-2454825450:22935:4267:34378:35137",
	"43481:XY-2454825450:22935:4267:34378:35136",
	"43481:XY-2454825450:22935:4267:34378:35137:41240:35138",
	"43481:XY-2454825450:22935:4267:34378:6706:35481",
	"43481:XY-2454825450:22935:4267:34378:6706:35478",
	"43481:XY-2454825450:22935:4267:34378:6706:35556",
	"43481:XY-2454825450:22935:4267:34378:6706:35562",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:39175",
	"43481:XY-2454825450:22935:4267:34378:39210",
	"43481:XY-2454825450:22935:4267:34378:39210:39212",
	"43481:XY-2454825450:22935:4267:34378:39210:39211",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823:40827",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823:41214",
	"43481:XY-2454825450:22935:4267:34378:35137:41240",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:41580",
	"41861:10897:12578:43073",
	"43481:XY-2454825450:22935:22931:43079",
	"43481:XY-2454825450",
	"41861:10897:XY-2030030181:17555:43991",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:163253:48275",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:163253",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	"43481:54392",
	--["name"] = "Grove of Aessina, Hyjal",
	["m"] = 198,
	["coord"] = 841047383,
	["direct"] = "43481:41861",
	["f"] = 0,
	},
	[35562] = {
	"6706:34378:4267",
	"35481:40966:41383:41580:40367",
	"6706:35136:39210:39212:4321",
	"6706:4407",
	"35481:40966:41383:39175:7823",
	"35481:40966:41383",
	"6706:34378:4267:XY-1974645611:XY-2030030181:10897",
	"6706:34378:4267:22931:12578:11138",
	"6706:34378:4267:22931:12578",
	"35481:40966:41383:39175:10583",
	"6706:35136:39210:16227",
	"6706:34378:4267:XY-1974645611:XY-2030030181:17555:17554",
	"6706:34378:4267:XY-1974645611:XY-2030030181:17555",
	"6706:34378:4267:22931",
	"6706:34378:4267:22935",
	"35481:40966:41383:41580:40367:40358",
	"6706:34378:4267:34374",
	"6706:34378",
	"6706:35137",
	"6706:35136",
	"6706:35138",
	"35481:40966:41383:39175",
	"6706:35136:39210",
	"6706:35136:39210:39212",
	"6706:35136:39210:39211",
	"35481:40966:41383:41580:40367:40768",
	"35481:40966:41383:163253:48275:40827",
	"35481:40966:41383:39175:7823:41214",
	"6706:35138:41240",
	"6706:34378:4267:22935:XY-2454825450:43481",
	"6706:34378:4267:22935:XY-2454825450:43481:41860",
	"6706:34378:4267:22935:XY-2454825450:43481:41861",
	"35481:40966",
	"35481:40966:41383:41580",
	"6706:34378:4267:22931:43073",
	"6706:34378:4267:22931:43079",
	"6706:34378:4267:22935:XY-2454825450",
	"6706:34378:4267:XY-1974645611:XY-2030030181:17555:43991",
	"35481:40966:41383:163253:48275",
	"35481:40966:41383:163253",
	"35481:40966:41383:163253:XY-1868173255",
	"6706:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Ethel Rethor, Desolace",
	["m"] = 66,
	["f"] = 0,
	["direct"] = "6706:35481:35478:35556",
	["coord"] = 1676887314,
	},
	[41240] = {
	"35137:34378:4267",
	"35137:6706:35481:40966:41383:41580:40367",
	"35137:35136:39210:39212:4321",
	"35137:6706",
	"35137:35136:39210:39211:40358:40768:7823",
	"35137:6706:35481:40966:41383",
	"4407:XY-2030030181:10897",
	"4407:XY-1974645611:12578:11138",
	"4407:XY-1974645611:12578",
	"35137:6706:35481:40966:41383:39175:10583",
	"35137:35136:39210:16227",
	"4407:XY-2030030181:17555:17554",
	"4407:XY-2030030181:17555",
	"35137:34378:4267:22931",
	"35137:34378:4267:22935",
	"35137:35136:39210:39211:40358",
	"4407:34374",
	"35137:34378",
	"35137:35136",
	"35137:6706:35481",
	"35137:6706:35478",
	"35137:6706:35556",
	"35137:6706:35562",
	"35137:6706:35481:40966:41383:39175",
	"35137:35136:39210",
	"35137:35136:39210:39212",
	"35137:35136:39210:39211",
	"35137:35136:39210:39211:40358:40768",
	"35137:35136:39210:39211:40358:40768:7823:40827",
	"35137:35136:39210:39211:40358:40768:7823:41214",
	"35137:34378:4267:22935:XY-2454825450:43481",
	"35137:34378:4267:22935:XY-2454825450:43481:41860",
	"35137:34378:4267:22935:XY-2454825450:43481:41861",
	"35137:6706:35481:40966",
	"35137:6706:35481:40966:41383:41580",
	"35137:34378:4267:22931:43073",
	"35137:34378:4267:22931:43079",
	"35137:34378:4267:22935:XY-2454825450",
	"4407:XY-2030030181:17555:43991",
	"35137:6706:35481:40966:41383:163253:48275",
	"35137:6706:35481:40966:41383:163253",
	"35137:6706:35481:40966:41383:163253:XY-1868173255",
	"35137:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Mirkfallon Post, Stonetalon Mountains",
	["m"] = 65,
	["coord"] = 2087224264,
	["direct"] = "4407:35137:35138",
	["f"] = 0,
	},
	[43073] = {
	"22931:4267",
	"22931:4267:34378:6706:35481:40966:41383:41580:40367",
	"22931:4267:16227:4321",
	"43079:XY-1974645611:4407",
	"22931:4267:34378:6706",
	"22931:4267:34378:39210:39211:40358:40768:7823",
	"22931:4267:34378:6706:35481:40966:41383",
	"12578:10897",
	"12578:11138",
	"22931:4267:34378:39210:39211:40358:40768:7823:10583",
	"22931:4267:16227",
	"12578:XY-2030030181:17555:17554",
	"12578:XY-2030030181:17555",
	"22931:22935",
	"22931:4267:34378:39210:39211:40358",
	"43079:XY-1974645611:34374",
	"22931:4267:34378",
	"22931:4267:34378:35137",
	"22931:4267:34378:35136",
	"43079:XY-1974645611:4407:35138",
	"22931:4267:34378:6706:35481",
	"22931:4267:34378:6706:35478",
	"22931:4267:34378:6706:35556",
	"22931:4267:34378:6706:35562",
	"22931:4267:34378:6706:35481:40966:41383:39175",
	"22931:4267:34378:39210",
	"22931:4267:34378:39210:39212",
	"22931:4267:34378:39210:39211",
	"22931:4267:34378:39210:39211:40358:40768",
	"22931:4267:34378:39210:39211:40358:40768:7823:40827",
	"22931:4267:34378:39210:39211:40358:40768:7823:41214",
	"22931:4267:34378:35137:41240",
	"12578:10897:41861:43481",
	"12578:10897:41861:41860",
	"12578:10897:41861",
	"22931:4267:34378:6706:35481:40966",
	"22931:4267:34378:6706:35481:40966:41383:41580",
	"22931:22935:XY-2454825450",
	"12578:XY-2030030181:17555:43991",
	"22931:4267:34378:6706:35481:40966:41383:163253:48275",
	"22931:4267:34378:6706:35481:40966:41383:163253",
	"22931:4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	"12578:10897:41861:43481:54392",
	--["name"] = "Whisperwind Grove, Felwood",
	["m"] = 77,
	["coord"] = 1870940558,
	["direct"] = "12578:22931:43079",
	["f"] = 0,
	},
	[35137] = {
	"34378:4267",
	"6706:35481:40966:41383:41580:40367",
	"35136:39210:39212:4321",
	"35136:39210:39211:40358:40768:7823",
	"6706:35481:40966:41383",
	"34378:4267:XY-1974645611:XY-2030030181:10897",
	"34378:4267:22931:12578:11138",
	"34378:4267:22931:12578",
	"6706:35481:40966:41383:39175:10583",
	"35136:39210:16227",
	"34378:4267:XY-1974645611:XY-2030030181:17555:17554",
	"34378:4267:XY-1974645611:XY-2030030181:17555",
	"34378:4267:22931",
	"34378:4267:22935",
	"35136:39210:39211:40358",
	"34378:4267:34374",
	"6706:35481",
	"6706:35478",
	"6706:35556",
	"6706:35562",
	"6706:35481:40966:41383:39175",
	"35136:39210",
	"35136:39210:39212",
	"35136:39210:39211",
	"35136:39210:39211:40358:40768",
	"35136:39210:39211:40358:40768:7823:40827",
	"35136:39210:39211:40358:40768:7823:41214",
	"34378:4267:22935:XY-2454825450:43481",
	"34378:4267:22935:XY-2454825450:43481:41860",
	"34378:4267:22935:XY-2454825450:43481:41861",
	"6706:35481:40966",
	"6706:35481:40966:41383:41580",
	"34378:4267:22931:43073",
	"34378:4267:22931:43079",
	"34378:4267:22935:XY-2454825450",
	"34378:4267:XY-1974645611:XY-2030030181:17555:43991",
	"6706:35481:40966:41383:163253:48275",
	"6706:35481:40966:41383:163253",
	"6706:35481:40966:41383:163253:XY-1868173255",
	"34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Windshear Hold, Stonetalon Mountains",
	["m"] = 65,
	["coord"] = 2525399807,
	["direct"] = "4407:6706:34378:35136:35138:41240",
	["f"] = 0,
	},
	[43079] = {
	"22931:4267",
	"22931:4267:34378:6706:35481:40966:41383:41580:40367",
	"22931:4267:16227:4321",
	"XY-1974645611:4407",
	"22931:4267:34378:6706",
	"22931:4267:34378:39210:39211:40358:40768:7823",
	"22931:4267:34378:6706:35481:40966:41383",
	"43073:12578:10897",
	"43073:12578:11138",
	"43073:12578",
	"22931:4267:34378:39210:39211:40358:40768:7823:10583",
	"22931:4267:16227",
	"XY-1974645611:XY-2030030181:17555:17554",
	"XY-1974645611:XY-2030030181:17555",
	"22931:22935",
	"22931:4267:34378:39210:39211:40358",
	"XY-1974645611:34374",
	"22931:4267:34378",
	"22931:4267:34378:35137",
	"22931:4267:34378:35136",
	"XY-1974645611:4407:35138",
	"22931:4267:34378:6706:35481",
	"22931:4267:34378:6706:35478",
	"22931:4267:34378:6706:35556",
	"22931:4267:34378:6706:35562",
	"22931:4267:34378:6706:35481:40966:41383:39175",
	"22931:4267:34378:39210",
	"22931:4267:34378:39210:39212",
	"22931:4267:34378:39210:39211",
	"22931:4267:34378:39210:39211:40358:40768",
	"22931:4267:34378:39210:39211:40358:40768:7823:40827",
	"22931:4267:34378:39210:39211:40358:40768:7823:41214",
	"XY-1974645611:4407:41240",
	"22931:22935:XY-2454825450:43481",
	"22931:22935:XY-2454825450:43481:41860",
	"43073:12578:10897:41861",
	"22931:4267:34378:6706:35481:40966",
	"22931:4267:34378:6706:35481:40966:41383:41580",
	"22931:22935:XY-2454825450",
	"XY-1974645611:XY-2030030181:17555:43991",
	"22931:4267:34378:6706:35481:40966:41383:163253:48275",
	"22931:4267:34378:6706:35481:40966:41383:163253",
	"22931:4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	"22931:22935:XY-2454825450:43481:54392",
	--["name"] = "Wildheart Point, Felwood",
	["m"] = 77,
	["coord"] = 1903992370,
	["direct"] = "22931:43073",
	["f"] = 0,
	},
	[39175] = {
	"41383:6706:34378:4267",
	"41383:41580:40367",
	"7823:4321",
	"41383:35138:4407",
	"41383:6706",
	"41383:XY-2030030181:10897",
	"41383:6706:34378:4267:22931:12578:11138",
	"41383:6706:34378:4267:22931:12578",
	"7823:16227",
	"41383:XY-2030030181:17555:17554",
	"41383:XY-2030030181:17555",
	"41383:6706:34378:4267:22931",
	"41383:6706:34378:4267:22935",
	"7823:40768:40358",
	"41383:35138:4407:34374",
	"41383:6706:34378",
	"41383:6706:35137",
	"7823:40768:40358:39211:39210:35136",
	"41383:35138",
	"41383:40966:35481",
	"41383:40966:35481:35478",
	"41383:40966:35481:35478:35556",
	"41383:40966:35481:35562",
	"7823:40768:40358:39211:39210",
	"7823:4321:39212",
	"7823:40768:40358:39211",
	"7823:40768",
	"7823:40827",
	"7823:41214",
	"41383:35138:41240",
	"41383:6706:34378:4267:22935:XY-2454825450:43481",
	"41383:6706:34378:4267:22935:XY-2454825450:43481:41860",
	"41383:6706:34378:4267:22935:XY-2454825450:43481:41861",
	"41383:40966",
	"41383:41580",
	"41383:6706:34378:4267:22931:43073",
	"41383:6706:34378:4267:22931:43079",
	"41383:6706:34378:4267:22935:XY-2454825450",
	"41383:XY-2030030181:17555:43991",
	"163253:48275",
	"163253:XY-1868173255",
	"41383:6706:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Mossy Pile, Un'Goro Crater",
	["m"] = 78,
	["f"] = 0,
	["direct"] = "7823:41383:10583:163253",
	["coord"] = 1891526396,
	},
	[11138] = {
	"12578:XY-1974645611:4267",
	"12578:XY-1974645611:4267:34378:6706:35481:40966:41383:41580:40367",
	"12578:XY-1974645611:4267:16227:4321",
	"12578:XY-1974645611:4407",
	"12578:XY-1974645611:4267:34378:6706",
	"12578:XY-1974645611:4267:34378:39210:39211:40358:40768:7823",
	"12578:XY-1974645611:4267:34378:6706:35481:40966:41383",
	"12578:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:10583",
	"12578:XY-1974645611:4267:16227",
	"10897:XY-2030030181:17555:17554",
	"10897:XY-2030030181:17555",
	"12578:22931",
	"41861:43481:XY-2454825450:22935",
	"12578:XY-1974645611:4267:34378:39210:39211:40358",
	"12578:XY-1974645611:34374",
	"12578:XY-1974645611:4267:34378",
	"12578:XY-1974645611:4267:34378:35137",
	"12578:XY-1974645611:4267:34378:35136",
	"12578:XY-1974645611:4407:35138",
	"12578:XY-1974645611:4267:34378:6706:35481",
	"12578:XY-1974645611:4267:34378:6706:35478",
	"12578:XY-1974645611:4267:34378:6706:35556",
	"12578:XY-1974645611:4267:34378:6706:35562",
	"12578:XY-1974645611:4267:34378:6706:35481:40966:41383:39175",
	"12578:XY-1974645611:4267:34378:39210",
	"12578:XY-1974645611:4267:34378:39210:39212",
	"12578:XY-1974645611:4267:34378:39210:39211",
	"12578:XY-1974645611:4267:34378:39210:39211:40358:40768",
	"12578:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:40827",
	"12578:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:41214",
	"12578:XY-1974645611:4407:41240",
	"41861:43481",
	"41861:41860",
	"12578:XY-1974645611:4267:34378:6706:35481:40966",
	"12578:XY-1974645611:4267:34378:6706:35481:40966:41383:41580",
	"12578:43073",
	"12578:43073:43079",
	"41861:43481:XY-2454825450",
	"10897:XY-2030030181:17555:43991",
	"12578:XY-1974645611:4267:34378:6706:35481:40966:41383:163253:48275",
	"12578:XY-1974645611:4267:34378:6706:35481:40966:41383:163253",
	"12578:XY-1974645611:4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	"41861:43481:54392",
	--["name"] = "Everlook, Winterspring",
	["m"] = 83,
	["coord"] = 2619374768,
	["direct"] = "10897:12578:41861",
	["f"] = 0,
	},
	[7823] = {
	"40768:40358:39211:39210:34378:4267",
	"40768:40358:39211:39210:35136:4407",
	"40768:40358:39211:39210:35136:6706",
	"39175:41383",
	"40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:10897",
	"40768:40358:39211:39210:34378:4267:22931:12578:11138",
	"40768:40358:39211:39210:34378:4267:22931:12578",
	"40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555:17554",
	"40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555",
	"40768:40358:39211:39210:34378:4267:22931",
	"40768:40358:39211:39210:34378:4267:22935",
	"40768:40358",
	"40768:40358:39211:39210:34378:4267:34374",
	"40768:40358:39211:39210:34378",
	"40768:40358:39211:39210:35136:35137",
	"40768:40358:39211:39210:35136",
	"40768:40358:39211:39210:35136:6706:35138",
	"39175:41383:40966:35481",
	"39175:41383:40966:35481:35478",
	"40768:40358:39211:39210:35136:6706:35556",
	"39175:41383:40966:35481:35562",
	"40768:40358:39211:39210",
	"4321:39212",
	"40768:40358:39211",
	"40768:40358:39211:39210:35136:35137:41240",
	"40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481",
	"40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481:41860",
	"40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481:41861",
	"39175:41383:40966",
	"40367:41580",
	"40768:40358:39211:39210:34378:4267:22931:43073",
	"40768:40358:39211:39210:34378:4267:22931:43079",
	"40768:40358:39211:39210:34378:4267:22935:XY-2454825450",
	"40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555:43991",
	"40827:48275",
	"39175:163253",
	"40827:48275:XY-1868173255",
	"40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Gadgetzan, Tanaris",
	["m"] = 71,
	["f"] = 0,
	["direct"] = "40367:4321:10583:16227:39175:40768:40827:41214",
	["coord"] = 2206681944,
	},
	[40827] = {
	"7823:40768:40358:39211:39210:34378:4267",
	"7823:40367",
	"7823:4321",
	"7823:40768:40358:39211:39210:35136:4407",
	"7823:40768:40358:39211:39210:35136:6706",
	"48275:163253:41383",
	"7823:40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:10897",
	"7823:40768:40358:39211:39210:34378:4267:22931:12578:11138",
	"7823:40768:40358:39211:39210:34378:4267:22931:12578",
	"7823:10583",
	"7823:16227",
	"7823:40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555:17554",
	"7823:40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555",
	"7823:40768:40358:39211:39210:34378:4267:22931",
	"7823:40768:40358:39211:39210:34378:4267:22935",
	"7823:40768:40358",
	"7823:40768:40358:39211:39210:34378:4267:34374",
	"7823:40768:40358:39211:39210:34378",
	"7823:40768:40358:39211:39210:35136:35137",
	"7823:40768:40358:39211:39210:35136",
	"7823:40768:40358:39211:39210:35136:6706:35138",
	"48275:163253:41383:40966:35481",
	"48275:163253:41383:40966:35481:35478",
	"7823:40768:40358:39211:39210:35136:6706:35556",
	"48275:163253:41383:40966:35481:35562",
	"7823:39175",
	"7823:40768:40358:39211:39210",
	"7823:4321:39212",
	"7823:40768:40358:39211",
	"7823:40768",
	"7823:40768:40358:39211:39210:35136:35137:41240",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481:41860",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481:41861",
	"48275:163253:41383:40966",
	"7823:40367:41580",
	"7823:40768:40358:39211:39210:34378:4267:22931:43073",
	"7823:40768:40358:39211:39210:34378:4267:22931:43079",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450",
	"7823:40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555:43991",
	"48275:163253",
	"48275:XY-1868173255",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Gunstan's Dig, Tanaris",
	["m"] = 71,
	["f"] = 0,
	["direct"] = "7823:41214:48275",
	["coord"] = 1719846525,
	},
	[40768] = {
	"40358:39211:39210:34378:4267",
	"40358:4321",
	"40358:39211:39210:35136:4407",
	"40358:39211:39210:35136:6706",
	"40367:41383",
	"40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:10897",
	"40358:39211:39210:34378:4267:22931:12578:11138",
	"40358:39211:39210:34378:4267:22931:12578",
	"7823:10583",
	"40358:4321:16227",
	"40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555:17554",
	"40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555",
	"40358:39211:39210:34378:4267:22931",
	"40358:39211:39210:34378:4267:22935",
	"40358:39211:39210:34378:4267:34374",
	"40358:39211:39210:34378",
	"40358:39211:39210:35136:35137",
	"40358:39211:39210:35136",
	"40358:39211:39210:35136:6706:35138",
	"40367:41383:40966:35481",
	"40358:39211:39210:35136:6706:35478",
	"40358:39211:39210:35136:6706:35556",
	"40358:39211:39210:35136:6706:35562",
	"7823:39175",
	"40358:39211:39210",
	"40358:4321:39212",
	"40358:39211",
	"7823:40827",
	"7823:41214",
	"40358:39211:39210:35136:35137:41240",
	"40358:39211:39210:34378:4267:22935:XY-2454825450:43481",
	"40358:39211:39210:34378:4267:22935:XY-2454825450:43481:41860",
	"40358:39211:39210:34378:4267:22935:XY-2454825450:43481:41861",
	"40367:41383:40966",
	"40367:41580",
	"40358:39211:39210:34378:4267:22931:43073",
	"40358:39211:39210:34378:4267:22931:43079",
	"40358:39211:39210:34378:4267:22935:XY-2454825450",
	"40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555:43991",
	"7823:40827:48275",
	"7823:39175:163253",
	"7823:40827:48275:XY-1868173255",
	"40358:39211:39210:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Fizzle & Pozzik's Speedbarge, Thousand Needles",
	["m"] = 64,
	["f"] = 0,
	["direct"] = "40367:7823:40358",
	["coord"] = 3398547498,
	},
	[17554] = {
	"17555:XY-2030030181:XY-1974645611:4267",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:41580:40367",
	"17555:XY-2030030181:XY-1974645611:4267:16227:4321",
	"17555:XY-2030030181:XY-1974645611:4407",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383",
	"17555:XY-2030030181:10897",
	"17555:XY-2030030181:12578:11138",
	"17555:XY-2030030181:12578",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:10583",
	"17555:XY-2030030181:XY-1974645611:4267:16227",
	"17555:XY-2030030181:XY-1974645611:22931",
	"17555:XY-2030030181:XY-1974645611:22931:22935",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358",
	"17555:XY-2030030181:XY-1974645611:34374",
	"17555:XY-2030030181:XY-1974645611:4267:34378",
	"17555:XY-2030030181:XY-1974645611:4267:34378:35137",
	"17555:XY-2030030181:XY-1974645611:4267:34378:35136",
	"17555:XY-2030030181:XY-1974645611:4407:35138",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35478",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35556",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35562",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:39175",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39212",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39211",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:40827",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:41214",
	"17555:XY-2030030181:XY-1974645611:4407:41240",
	"17555:XY-2030030181:10897:41861:43481",
	"17555:XY-2030030181:10897:41861:41860",
	"17555:XY-2030030181:10897:41861",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:41580",
	"17555:XY-2030030181:12578:43073",
	"17555:XY-2030030181:XY-1974645611:43079",
	"17555:XY-2030030181:10897:41861:43481:XY-2454825450",
	"17555:43991",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:163253:48275",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:163253",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	"17555:XY-2030030181:10897:41861:43481:54392",
	--["name"] = "Blood Watch, Bloodmyst Isle",
	["m"] = 106,
	["coord"] = 2474412619,
	["direct"] = "17555",
	["f"] = 0,
	},
	[6706] = {
	"34378:4267",
	"35481:40966:41383:41580:40367",
	"35136:39210:39211:40358:40768:7823",
	"34378:4267:XY-1974645611:XY-2030030181:10897",
	"34378:4267:22931:12578:11138",
	"34378:4267:22931:12578",
	"35481:40966:41383:39175:10583",
	"35136:39210:16227",
	"34378:4267:XY-1974645611:XY-2030030181:17555:17554",
	"34378:4267:XY-1974645611:XY-2030030181:17555",
	"34378:4267:22931",
	"34378:4267:22935",
	"35136:39210:39211:40358",
	"34378:4267:34374",
	"35481:40966:41383:39175",
	"35136:39210",
	"35136:39210:39212",
	"35136:39210:39211",
	"35136:39210:39211:40358:40768",
	"35136:39210:39211:40358:40768:7823:40827",
	"35136:39210:39211:40358:40768:7823:41214",
	"35138:41240",
	"34378:4267:22935:XY-2454825450:43481",
	"34378:4267:22935:XY-2454825450:43481:41860",
	"34378:4267:22935:XY-2454825450:43481:41861",
	"35481:40966",
	"35481:40966:41383:41580",
	"34378:4267:22931:43073",
	"34378:4267:22931:43079",
	"34378:4267:22935:XY-2454825450",
	"34378:4267:XY-1974645611:XY-2030030181:17555:43991",
	"35481:40966:41383:163253:48275",
	"35481:40966:41383:163253",
	"35481:40966:41383:163253:XY-1868173255",
	"34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Nijel's Point, Desolace",
	["m"] = 66,
	["coord"] = 2777619127,
	["direct"] = "4321:4407:41383:34378:35137:35136:35138:35481:35478:35556:35562",
	["f"] = 0,
	},
	[4407] = {
	"35481:40966:41383:41580:40367",
	"35136:39210:39212:4321",
	"35136:39210:39211:40358:40768:7823",
	"35481:40966:41383",
	"XY-2030030181:10897",
	"XY-1974645611:12578:11138",
	"XY-1974645611:12578",
	"35481:40966:41383:39175:10583",
	"35136:39210:16227",
	"XY-2030030181:17555:17554",
	"XY-2030030181:17555",
	"34378:4267:22931",
	"34378:4267:22935",
	"35136:39210:39211:40358",
	"6706:35556",
	"6706:35562",
	"35481:40966:41383:39175",
	"35136:39210",
	"35136:39210:39212",
	"35136:39210:39211",
	"35136:39210:39211:40358:40768",
	"35136:39210:39211:40358:40768:7823:40827",
	"35136:39210:39211:40358:40768:7823:41214",
	"34378:4267:22935:XY-2454825450:43481",
	"34378:4267:22935:XY-2454825450:43481:41860",
	"34378:4267:22935:XY-2454825450:43481:41861",
	"35481:40966",
	"35481:40966:41383:41580",
	"XY-1974645611:43079:43073",
	"XY-1974645611:43079",
	"34378:4267:22935:XY-2454825450",
	"XY-2030030181:17555:43991",
	"35481:40966:41383:163253:48275",
	"35481:40966:41383:163253",
	"35481:40966:41383:163253:XY-1868173255",
	"34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Thal'darah Overlook, Stonetalon Mountains",
	["m"] = 65,
	["coord"] = 1720996301,
	["direct"] = "4267:6706:34374:34378:35137:35136:35138:35481:35478:41240",
	["f"] = 0,
	},
	[43991] = {
	"17555:XY-2030030181:XY-1974645611:4267",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:41580:40367",
	"17555:XY-2030030181:XY-1974645611:4267:16227:4321",
	"17555:XY-2030030181:XY-1974645611:4407",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383",
	"17555:XY-2030030181:10897",
	"17555:XY-2030030181:12578:11138",
	"17555:XY-2030030181:12578",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:10583",
	"17555:XY-2030030181:XY-1974645611:4267:16227",
	"17555:17554",
	"17555:XY-2030030181:XY-1974645611:22931",
	"17555:XY-2030030181:XY-1974645611:22931:22935",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358",
	"17555:XY-2030030181:XY-1974645611:34374",
	"17555:XY-2030030181:XY-1974645611:4267:34378",
	"17555:XY-2030030181:XY-1974645611:4267:34378:35137",
	"17555:XY-2030030181:XY-1974645611:4267:34378:35136",
	"17555:XY-2030030181:XY-1974645611:4407:35138",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35478",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35556",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35562",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:39175",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39212",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39211",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:40827",
	"17555:XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:41214",
	"17555:XY-2030030181:XY-1974645611:4407:41240",
	"17555:XY-2030030181:10897:41861:43481",
	"17555:XY-2030030181:10897:41861:41860",
	"17555:XY-2030030181:10897:41861",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:41580",
	"17555:XY-2030030181:12578:43073",
	"17555:XY-2030030181:XY-1974645611:43079",
	"17555:XY-2030030181:10897:41861:43481:XY-2454825450",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:163253:48275",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:163253",
	"17555:XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	"17555:XY-2030030181:10897:41861:43481:54392",
	--["name"] = "Azure Watch, Azuremyst Isle",
	["m"] = 97,
	["coord"] = 2131787270,
	["direct"] = "17555",
	["f"] = 0,
	},
	[163253] = {
	"41383:6706:34378:4267",
	"41383:41580:40367",
	"39175:7823:4321",
	"41383:35138:4407",
	"41383:6706",
	"39175:7823",
	"41383:XY-2030030181:10897",
	"41383:6706:34378:4267:22931:12578:11138",
	"41383:6706:34378:4267:22931:12578",
	"39175:10583",
	"39175:7823:16227",
	"41383:XY-2030030181:17555:17554",
	"41383:XY-2030030181:17555",
	"41383:6706:34378:4267:22931",
	"41383:6706:34378:4267:22935",
	"39175:7823:40768:40358",
	"41383:35138:4407:34374",
	"41383:6706:34378",
	"41383:6706:35137",
	"41383:6706:35136",
	"41383:35138",
	"41383:40966:35481",
	"41383:40966:35481:35478",
	"41383:40966:35481:35478:35556",
	"41383:40966:35481:35562",
	"41383:6706:35136:39210",
	"39175:7823:4321:39212",
	"39175:7823:40768:40358:39211",
	"39175:7823:40768",
	"48275:40827",
	"48275:40827:41214",
	"41383:35138:41240",
	"41383:6706:34378:4267:22935:XY-2454825450:43481",
	"41383:6706:34378:4267:22935:XY-2454825450:43481:41860",
	"41383:6706:34378:4267:22935:XY-2454825450:43481:41861",
	"41383:40966",
	"41383:41580",
	"41383:6706:34378:4267:22931:43073",
	"41383:6706:34378:4267:22931:43079",
	"41383:6706:34378:4267:22935:XY-2454825450",
	"41383:XY-2030030181:17555:43991",
	"41383:6706:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Oasis of Vir'sar, Uldum",
	["m"] = 1527,
	["f"] = 0,
	["direct"] = "41383:39175:48275:XY-1868173255",
	["coord"] = 1144395128,
	},
	[54392] = {
	"43481:XY-2454825450:22935:4267",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:41580:40367",
	"43481:XY-2454825450:22935:4267:16227:4321",
	"43481:XY-2454825450:22935:4267:34378:4407",
	"43481:XY-2454825450:22935:4267:34378:6706",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383",
	"43481:41861:10897",
	"43481:41861:11138",
	"43481:41861:10897:12578",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823:10583",
	"43481:XY-2454825450:22935:4267:16227",
	"43481:41861:10897:XY-2030030181:17555:17554",
	"43481:41861:10897:XY-2030030181:17555",
	"43481:XY-2454825450:22935:22931",
	"43481:XY-2454825450:22935",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358",
	"43481:XY-2454825450:22935:4267:34374",
	"43481:XY-2454825450:22935:4267:34378",
	"43481:XY-2454825450:22935:4267:34378:35137",
	"43481:XY-2454825450:22935:4267:34378:35136",
	"43481:XY-2454825450:22935:4267:34378:35137:41240:35138",
	"43481:XY-2454825450:22935:4267:34378:6706:35481",
	"43481:XY-2454825450:22935:4267:34378:6706:35478",
	"43481:XY-2454825450:22935:4267:34378:6706:35556",
	"43481:XY-2454825450:22935:4267:34378:6706:35562",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:39175",
	"43481:XY-2454825450:22935:4267:34378:39210",
	"43481:XY-2454825450:22935:4267:34378:39210:39212",
	"43481:XY-2454825450:22935:4267:34378:39210:39211",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823:40827",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823:41214",
	"43481:XY-2454825450:22935:4267:34378:35137:41240",
	"43481:41860",
	"43481:41861",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:41580",
	"43481:41861:10897:12578:43073",
	"43481:XY-2454825450:22935:22931:43079",
	"43481:XY-2454825450",
	"43481:41861:10897:XY-2030030181:17555:43991",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:163253:48275",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:163253",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	--["name"] = "Sanctuary of Malorne, Hyjal",
	["m"] = 198,
	["coord"] = 1194894015,
	["direct"] = "43481",
	["f"] = 0,
	},
	[39211] = {
	"39210:34378:4267",
	"40358:40367",
	"40358:4321",
	"39210:35136:4407",
	"39210:35136:6706",
	"40358:40768:7823",
	"40358:40367:41383",
	"39210:34378:4267:XY-1974645611:XY-2030030181:10897",
	"39210:34378:4267:22931:12578:11138",
	"39210:34378:4267:22931:12578",
	"40358:40768:7823:10583",
	"39212:16227",
	"39210:34378:4267:XY-1974645611:XY-2030030181:17555:17554",
	"39210:34378:4267:XY-1974645611:XY-2030030181:17555",
	"39210:34378:4267:22931",
	"39210:34378:4267:22935",
	"39210:34378:4267:34374",
	"39210:34378",
	"39210:35136:35137",
	"39210:35136",
	"39210:35136:6706:35138",
	"39210:35136:6706:35481",
	"39210:35136:6706:35478",
	"39210:35136:6706:35556",
	"39210:35136:6706:35562",
	"40358:40768:7823:39175",
	"40358:40768",
	"40358:40768:7823:40827",
	"40358:40768:7823:41214",
	"39210:35136:35137:41240",
	"39210:34378:4267:22935:XY-2454825450:43481",
	"39210:34378:4267:22935:XY-2454825450:43481:41860",
	"39210:34378:4267:22935:XY-2454825450:43481:41861",
	"40358:40367:41383:40966",
	"40358:40367:41580",
	"39210:34378:4267:22931:43073",
	"39210:34378:4267:22931:43079",
	"39210:34378:4267:22935:XY-2454825450",
	"39210:34378:4267:XY-1974645611:XY-2030030181:17555:43991",
	"40358:40768:7823:40827:48275",
	"40358:40768:7823:39175:163253",
	"40358:40768:7823:40827:48275:XY-1868173255",
	"39210:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Fort Triumph, Southern Barrens",
	["m"] = 199,
	["f"] = 0,
	["direct"] = "40358:39210:39212",
	["coord"] = 2112794020,
	},
	[41861] = {
	"43481:XY-2454825450:22935:4267",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:41580:40367",
	"43481:XY-2454825450:22935:4267:16227:4321",
	"43481:XY-2454825450:22935:4267:34378:4407",
	"43481:XY-2454825450:22935:4267:34378:6706",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383",
	"10897:12578",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823:10583",
	"43481:XY-2454825450:22935:4267:16227",
	"10897:XY-2030030181:17555:17554",
	"10897:XY-2030030181:17555",
	"43481:XY-2454825450:22935:22931",
	"43481:XY-2454825450:22935",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358",
	"43481:XY-2454825450:22935:4267:34374",
	"43481:XY-2454825450:22935:4267:34378",
	"43481:XY-2454825450:22935:4267:34378:35137",
	"43481:XY-2454825450:22935:4267:34378:35136",
	"43481:XY-2454825450:22935:4267:34378:35137:41240:35138",
	"43481:XY-2454825450:22935:4267:34378:6706:35481",
	"43481:XY-2454825450:22935:4267:34378:6706:35478",
	"43481:XY-2454825450:22935:4267:34378:6706:35556",
	"43481:XY-2454825450:22935:4267:34378:6706:35562",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:39175",
	"43481:XY-2454825450:22935:4267:34378:39210",
	"43481:XY-2454825450:22935:4267:34378:39210:39212",
	"43481:XY-2454825450:22935:4267:34378:39210:39211",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823:40827",
	"43481:XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823:41214",
	"43481:XY-2454825450:22935:4267:34378:35137:41240",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:41580",
	"10897:12578:43073",
	"10897:12578:43073:43079",
	"43481:XY-2454825450",
	"10897:XY-2030030181:17555:43991",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:163253:48275",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:163253",
	"43481:XY-2454825450:22935:4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	"43481:54392",
	--["name"] = "Nordrassil, Hyjal",
	["m"] = 198,
	["coord"] = 2671195983,
	["direct"] = "10897:11138:43481:41860",
	["f"] = 0,
	},
	[10897] = {
	"XY-2030030181:XY-1974645611:4267",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:41580:40367",
	"XY-2030030181:XY-1974645611:4267:16227:4321",
	"XY-2030030181:XY-1974645611:4407",
	"XY-2030030181:XY-1974645611:4267:34378:6706",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:10583",
	"XY-2030030181:XY-1974645611:4267:16227",
	"XY-2030030181:17555:17554",
	"XY-2030030181:17555",
	"12578:22931",
	"41861:43481:XY-2454825450:22935",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358",
	"XY-2030030181:XY-1974645611:34374",
	"XY-2030030181:XY-1974645611:4267:34378",
	"XY-2030030181:XY-1974645611:4267:34378:35137",
	"XY-2030030181:XY-1974645611:4267:34378:35136",
	"XY-2030030181:XY-1974645611:4407:35138",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35478",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35556",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35562",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:39175",
	"XY-2030030181:XY-1974645611:4267:34378:39210",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39212",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39211",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:40827",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:41214",
	"XY-2030030181:XY-1974645611:4407:41240",
	"41861:43481",
	"41861:41860",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:41580",
	"12578:43073",
	"12578:43073:43079",
	"41861:43481:XY-2454825450",
	"XY-2030030181:17555:43991",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:163253:48275",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:163253",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	"41861:43481:54392",
	--["name"] = "Moonglade",
	["m"] = 80,
	["coord"] = 2065214594,
	["direct"] = "11138:12578:41861",
	["f"] = 0,
	},
	[34378] = {
	"6706:35481:40966:41383:41580:40367",
	"39210:39212:4321",
	"39210:39211:40358:40768:7823",
	"6706:35481:40966:41383",
	"4267:XY-1974645611:XY-2030030181:10897",
	"4267:22931:12578:11138",
	"4267:22931:12578",
	"39210:39211:40358:40768:7823:10583",
	"39210:16227",
	"4267:XY-1974645611:XY-2030030181:17555:17554",
	"4267:XY-1974645611:XY-2030030181:17555",
	"4267:22931",
	"4267:22935",
	"39210:39211:40358",
	"4267:34374",
	"35137:41240:35138",
	"6706:35481",
	"6706:35478",
	"6706:35556",
	"6706:35562",
	"6706:35481:40966:41383:39175",
	"39210:39212",
	"39210:39211",
	"39210:39211:40358:40768",
	"39210:39211:40358:40768:7823:40827",
	"39210:39211:40358:40768:7823:41214",
	"35137:41240",
	"4267:22935:XY-2454825450:43481",
	"4267:22935:XY-2454825450:43481:41860",
	"4267:22935:XY-2454825450:43481:41861",
	"6706:35481:40966",
	"6706:35481:40966:41383:41580",
	"4267:22931:43073",
	"4267:22931:43079",
	"4267:22935:XY-2454825450",
	"4267:XY-1974645611:XY-2030030181:17555:43991",
	"6706:35481:40966:41383:163253:48275",
	"6706:35481:40966:41383:163253",
	"6706:35481:40966:41383:163253:XY-1868173255",
	"4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Stardust Spire, Ashenvale",
	["m"] = 63,
	["coord"] = 1503705229,
	["direct"] = "4267:4407:6706:35137:35136:39210",
	["f"] = 0,
	},
	[35136] = {
	"34378:4267",
	"6706:35481:40966:41383:41580:40367",
	"39210:39212:4321",
	"39210:39211:40358:40768:7823",
	"6706:35481:40966:41383",
	"34378:4267:XY-1974645611:XY-2030030181:10897",
	"34378:4267:22931:12578:11138",
	"34378:4267:22931:12578",
	"39210:39211:40358:40768:7823:10583",
	"39210:16227",
	"34378:4267:XY-1974645611:XY-2030030181:17555:17554",
	"34378:4267:XY-1974645611:XY-2030030181:17555",
	"34378:4267:22931",
	"34378:4267:22935",
	"39210:39211:40358",
	"34378:4267:34374",
	"6706:35481",
	"6706:35478",
	"6706:35556",
	"6706:35562",
	"39210:39211:40358:40768:7823:39175",
	"39210:39212",
	"39210:39211",
	"39210:39211:40358:40768",
	"39210:39211:40358:40768:7823:40827",
	"39210:39211:40358:40768:7823:41214",
	"35137:41240",
	"34378:4267:22935:XY-2454825450:43481",
	"34378:4267:22935:XY-2454825450:43481:41860",
	"34378:4267:22935:XY-2454825450:43481:41861",
	"6706:35481:40966",
	"6706:35481:40966:41383:41580",
	"34378:4267:22931:43073",
	"34378:4267:22931:43079",
	"34378:4267:22935:XY-2454825450",
	"34378:4267:XY-1974645611:XY-2030030181:17555:43991",
	"39210:39211:40358:40768:7823:40827:48275",
	"6706:35481:40966:41383:163253",
	"6706:35481:40966:41383:163253:XY-1868173255",
	"34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Northwatch Expedition Base Camp, Stonetalon Mountains",
	["m"] = 65,
	["f"] = 0,
	["direct"] = "4407:6706:34378:35137:35138:39210",
	["coord"] = 3045117484,
	},
	[35138] = {
	"41240:35137:34378:4267",
	"41383:41580:40367",
	"35136:39210:39212:4321",
	"35136:39210:39211:40358:40768:7823",
	"4407:XY-2030030181:10897",
	"4407:XY-1974645611:12578:11138",
	"4407:XY-1974645611:12578",
	"41383:39175:10583",
	"35136:39210:16227",
	"4407:XY-2030030181:17555:17554",
	"4407:XY-2030030181:17555",
	"41240:35137:34378:4267:22931",
	"41240:35137:34378:4267:22935",
	"35136:39210:39211:40358",
	"4407:34374",
	"41240:35137:34378",
	"6706:35481",
	"6706:35478",
	"6706:35556",
	"6706:35562",
	"41383:39175",
	"35136:39210",
	"35136:39210:39212",
	"35136:39210:39211",
	"35136:39210:39211:40358:40768",
	"35136:39210:39211:40358:40768:7823:40827",
	"35136:39210:39211:40358:40768:7823:41214",
	"41240:35137:34378:4267:22935:XY-2454825450:43481",
	"41240:35137:34378:4267:22935:XY-2454825450:43481:41860",
	"41240:35137:34378:4267:22935:XY-2454825450:43481:41861",
	"6706:35481:40966",
	"41383:41580",
	"41240:35137:34378:4267:22931:43073",
	"4407:XY-1974645611:43079",
	"41240:35137:34378:4267:22935:XY-2454825450",
	"4407:XY-2030030181:17555:43991",
	"41383:163253:48275",
	"41383:163253",
	"41383:163253:XY-1868173255",
	"41240:35137:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Farwatcher's Glen, Stonetalon Mountains",
	["m"] = 65,
	["coord"] = 1375116844,
	["direct"] = "4407:6706:41383:35137:35136:41240",
	["f"] = 0,
	},
	[40367] = {
	"41383:6706:34378:4267",
	"41383:35138:4407",
	"41383:6706",
	"41383:XY-2030030181:10897",
	"41383:6706:34378:4267:22931:12578:11138",
	"41383:6706:34378:4267:22931:12578",
	"41383:39175:10583",
	"40358:4321:16227",
	"41383:XY-2030030181:17555:17554",
	"41383:XY-2030030181:17555",
	"41383:6706:34378:4267:22931",
	"41383:6706:34378:4267:22935",
	"41383:35138:4407:34374",
	"41383:6706:34378",
	"41383:6706:35137",
	"40358:39211:39210:35136",
	"41383:35138",
	"41383:40966:35481",
	"41383:40966:35481:35478",
	"41383:40966:35481:35478:35556",
	"41383:40966:35481:35562",
	"41383:39175",
	"40358:39211:39210",
	"40358:4321:39212",
	"40358:39211",
	"7823:40827",
	"7823:41214",
	"41383:35138:41240",
	"41383:6706:34378:4267:22935:XY-2454825450:43481",
	"41383:6706:34378:4267:22935:XY-2454825450:43481:41860",
	"41383:6706:34378:4267:22935:XY-2454825450:43481:41861",
	"41383:40966",
	"41383:6706:34378:4267:22931:43073",
	"41383:6706:34378:4267:22931:43079",
	"41383:6706:34378:4267:22935:XY-2454825450",
	"41383:XY-2030030181:17555:43991",
	"41383:163253:48275",
	"41383:163253",
	"41383:163253:XY-1868173255",
	"41383:6706:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Shadebough, Feralas",
	["m"] = 69,
	["f"] = 0,
	["direct"] = "4321:7823:41383:40358:40768:41580",
	["coord"] = 3319697765,
	},
	[4267] = {
	"34378:6706:35481:40966:41383:41580:40367",
	"34378:6706",
	"34378:39210:39211:40358:40768:7823",
	"34378:6706:35481:40966:41383",
	"XY-1974645611:XY-2030030181:10897",
	"22931:12578:11138",
	"22931:12578",
	"34378:39210:39211:40358:40768:7823:10583",
	"XY-1974645611:XY-2030030181:17555:17554",
	"XY-1974645611:XY-2030030181:17555",
	"34378:39210:39211:40358",
	"34378:35137",
	"34378:35136",
	"34378:35137:41240:35138",
	"34378:6706:35481",
	"34378:6706:35478",
	"34378:6706:35556",
	"34378:6706:35562",
	"34378:6706:35481:40966:41383:39175",
	"34378:39210",
	"34378:39210:39212",
	"34378:39210:39211",
	"34378:39210:39211:40358:40768",
	"34378:39210:39211:40358:40768:7823:40827",
	"34378:39210:39211:40358:40768:7823:41214",
	"34378:35137:41240",
	"22935:XY-2454825450:43481",
	"22935:XY-2454825450:43481:41860",
	"22935:XY-2454825450:43481:41861",
	"34378:6706:35481:40966",
	"34378:6706:35481:40966:41383:41580",
	"22931:43073",
	"22931:43079",
	"22935:XY-2454825450",
	"XY-1974645611:XY-2030030181:17555:43991",
	"34378:6706:35481:40966:41383:163253:48275",
	"34378:6706:35481:40966:41383:163253",
	"34378:6706:35481:40966:41383:163253:XY-1868173255",
	"22935:XY-2454825450:43481:54392",
	--["name"] = "Astranaar, Ashenvale",
	["m"] = 63,
	["coord"] = 1481538283,
	["direct"] = "4321:4407:16227:22931:22935:34374:34378",
	["f"] = 0,
	},
	[22931] = {
	"4267:34378:6706:35481:40966:41383:41580:40367",
	"4267:16227:4321",
	"4267:34378:4407",
	"4267:34378:6706",
	"4267:34378:39210:39211:40358:40768:7823",
	"4267:34378:6706:35481:40966:41383",
	"12578:10897",
	"12578:11138",
	"4267:34378:39210:39211:40358:40768:7823:10583",
	"4267:16227",
	"XY-1974645611:XY-2030030181:17555:17554",
	"XY-1974645611:XY-2030030181:17555",
	"4267:34378:39210:39211:40358",
	"4267:34378",
	"4267:34378:35137",
	"4267:34378:35136",
	"4267:34378:35137:41240:35138",
	"4267:34378:6706:35481",
	"4267:34378:6706:35478",
	"4267:34378:6706:35556",
	"4267:34378:6706:35562",
	"4267:34378:6706:35481:40966:41383:39175",
	"4267:34378:39210",
	"4267:34378:39210:39212",
	"4267:34378:39210:39211",
	"4267:34378:39210:39211:40358:40768",
	"4267:34378:39210:39211:40358:40768:7823:40827",
	"4267:34378:39210:39211:40358:40768:7823:41214",
	"4267:34378:35137:41240",
	"22935:XY-2454825450:43481",
	"22935:XY-2454825450:43481:41860",
	"22935:XY-2454825450:43481:41861",
	"4267:34378:6706:35481:40966",
	"4267:34378:6706:35481:40966:41383:41580",
	"22935:XY-2454825450",
	"XY-1974645611:XY-2030030181:17555:43991",
	"4267:34378:6706:35481:40966:41383:163253:48275",
	"4267:34378:6706:35481:40966:41383:163253",
	"4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	"22935:XY-2454825450:43481:54392",
	--["name"] = "Emerald Sanctuary, Felwood",
	["m"] = 77,
	["coord"] = 2213465846,
	["direct"] = "4267:12578:22935:34374:43073:43079",
	["f"] = 0,
	},
	[41383] = {
	"6706:34378:4267",
	"41580:40367:40358:4321",
	"35138:4407",
	"39175:7823",
	"XY-2030030181:10897",
	"6706:34378:4267:22931:12578:11138",
	"6706:34378:4267:22931:12578",
	"39175:10583",
	"41580:40367:40358:4321:16227",
	"XY-2030030181:17555:17554",
	"XY-2030030181:17555",
	"6706:34378:4267:22931",
	"6706:34378:4267:22935",
	"41580:40367:40358",
	"35138:4407:34374",
	"6706:34378",
	"6706:35137",
	"6706:35136",
	"40966:35481:35478",
	"40966:35481:35478:35556",
	"40966:35481:35562",
	"6706:35136:39210",
	"41580:40367:40358:4321:39212",
	"41580:40367:40358:39211",
	"41580:40367:40768",
	"163253:48275:40827",
	"39175:7823:41214",
	"35138:41240",
	"6706:34378:4267:22935:XY-2454825450:43481",
	"6706:34378:4267:22935:XY-2454825450:43481:41860",
	"6706:34378:4267:22935:XY-2454825450:43481:41861",
	"6706:34378:4267:22931:43073",
	"6706:34378:4267:22931:43079",
	"6706:34378:4267:22935:XY-2454825450",
	"XY-2030030181:17555:43991",
	"163253:48275",
	"163253:XY-1868173255",
	"6706:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Feathermoon, Feralas",
	["m"] = 69,
	["f"] = 0,
	["direct"] = "40367:6706:35138:35481:39175:40966:41580:163253",
	["coord"] = 2010346508,
	},
	[40358] = {
	"39211:39210:34378:4267",
	"39211:39210:35136:4407",
	"39211:39210:35136:6706",
	"40768:7823",
	"40367:41383",
	"39211:39210:34378:4267:XY-1974645611:XY-2030030181:10897",
	"39211:39210:34378:4267:22931:12578:11138",
	"39211:39210:34378:4267:22931:12578",
	"40768:7823:10583",
	"4321:16227",
	"39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555:17554",
	"39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555",
	"39211:39210:34378:4267:22931",
	"39211:39210:34378:4267:22935",
	"39211:39210:34378:4267:34374",
	"39211:39210:34378",
	"39211:39210:35136:35137",
	"39211:39210:35136",
	"39211:39210:35136:6706:35138",
	"40367:41383:40966:35481",
	"39211:39210:35136:6706:35478",
	"39211:39210:35136:6706:35556",
	"39211:39210:35136:6706:35562",
	"40768:7823:39175",
	"39211:39210",
	"4321:39212",
	"40768:7823:40827",
	"40768:7823:41214",
	"39211:39210:35136:35137:41240",
	"39211:39210:34378:4267:22935:XY-2454825450:43481",
	"39211:39210:34378:4267:22935:XY-2454825450:43481:41860",
	"39211:39210:34378:4267:22935:XY-2454825450:43481:41861",
	"40367:41383:40966",
	"40367:41580",
	"39211:39210:34378:4267:22931:43073",
	"39211:39210:34378:4267:22931:43079",
	"39211:39210:34378:4267:22935:XY-2454825450",
	"39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555:43991",
	"40768:7823:40827:48275",
	"40768:7823:39175:163253",
	"40768:7823:40827:48275:XY-1868173255",
	"39211:39210:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Mudsprocket, Dustwallow Marsh",
	["m"] = 70,
	["f"] = 0,
	["direct"] = "40367:4321:39211:40768",
	["coord"] = 1840888132,
	},
	[34374] = {
	"4267:34378:6706:35481:40966:41383:41580:40367",
	"4267:16227:4321",
	"4267:34378:6706",
	"4267:34378:39210:39211:40358:40768:7823",
	"4267:34378:6706:35481:40966:41383",
	"XY-1974645611:XY-2030030181:10897",
	"XY-1974645611:12578:11138",
	"XY-1974645611:12578",
	"4267:34378:39210:39211:40358:40768:7823:10583",
	"4267:16227",
	"XY-1974645611:XY-2030030181:17555:17554",
	"XY-1974645611:XY-2030030181:17555",
	"4267:22935",
	"4267:34378:39210:39211:40358",
	"4267:34378",
	"4267:34378:35137",
	"4267:34378:35136",
	"4407:35138",
	"4267:34378:6706:35481",
	"4267:34378:6706:35478",
	"4267:34378:6706:35556",
	"4267:34378:6706:35562",
	"4267:34378:6706:35481:40966:41383:39175",
	"4267:34378:39210",
	"4267:34378:39210:39212",
	"4267:34378:39210:39211",
	"4267:34378:39210:39211:40358:40768",
	"4267:34378:39210:39211:40358:40768:7823:40827",
	"4267:34378:39210:39211:40358:40768:7823:41214",
	"4407:41240",
	"4267:22935:XY-2454825450:43481",
	"4267:22935:XY-2454825450:43481:41860",
	"4267:22935:XY-2454825450:43481:41861",
	"4267:34378:6706:35481:40966",
	"4267:34378:6706:35481:40966:41383:41580",
	"XY-1974645611:43079:43073",
	"XY-1974645611:43079",
	"4267:22935:XY-2454825450",
	"XY-1974645611:XY-2030030181:17555:43991",
	"4267:34378:6706:35481:40966:41383:163253:48275",
	"4267:34378:6706:35481:40966:41383:163253",
	"4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	"4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Blackfathom Camp, Ashenvale",
	["m"] = 63,
	["coord"] = 779695299,
	["direct"] = "4267:4407:22931",
	["f"] = 0,
	},
	[22935] = {
	"4267:34378:6706:35481:40966:41383:41580:40367",
	"4267:16227:4321",
	"4267:34378:4407",
	"4267:34378:6706",
	"4267:34378:39210:39211:40358:40768:7823",
	"4267:34378:6706:35481:40966:41383",
	"XY-2454825450:43481:41861:10897",
	"XY-2454825450:43481:41861:11138",
	"22931:12578",
	"4267:34378:39210:39211:40358:40768:7823:10583",
	"4267:16227",
	"22931:XY-1974645611:XY-2030030181:17555:17554",
	"22931:XY-1974645611:XY-2030030181:17555",
	"4267:34378:39210:39211:40358",
	"4267:34374",
	"4267:34378",
	"4267:34378:35137",
	"4267:34378:35136",
	"4267:34378:35137:41240:35138",
	"4267:34378:6706:35481",
	"4267:34378:6706:35478",
	"4267:34378:6706:35556",
	"4267:34378:6706:35562",
	"4267:34378:6706:35481:40966:41383:39175",
	"4267:34378:39210",
	"4267:34378:39210:39212",
	"4267:34378:39210:39211",
	"4267:34378:39210:39211:40358:40768",
	"4267:34378:39210:39211:40358:40768:7823:40827",
	"4267:34378:39210:39211:40358:40768:7823:41214",
	"4267:34378:35137:41240",
	"XY-2454825450:43481",
	"XY-2454825450:43481:41860",
	"XY-2454825450:43481:41861",
	"4267:34378:6706:35481:40966",
	"4267:34378:6706:35481:40966:41383:41580",
	"22931:43073",
	"22931:43079",
	"22931:XY-1974645611:XY-2030030181:17555:43991",
	"4267:34378:6706:35481:40966:41383:163253:48275",
	"4267:34378:6706:35481:40966:41383:163253",
	"4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	"XY-2454825450:43481:54392",
	--["name"] = "Forest Song, Ashenvale",
	["m"] = 63,
	["coord"] = 3652546366,
	["direct"] = "4267:22931:XY-2454825450",
	["f"] = 0,
	},
	[41580] = {
	"41383:6706:34378:4267",
	"40367:40358:4321",
	"41383:35138:4407",
	"41383:6706",
	"40367:7823",
	"41383:XY-2030030181:10897",
	"41383:6706:34378:4267:22931:12578:11138",
	"41383:6706:34378:4267:22931:12578",
	"41383:39175:10583",
	"40367:40358:4321:16227",
	"41383:XY-2030030181:17555:17554",
	"41383:XY-2030030181:17555",
	"41383:6706:34378:4267:22931",
	"41383:6706:34378:4267:22935",
	"40367:40358",
	"41383:35138:4407:34374",
	"41383:6706:34378",
	"41383:6706:35137",
	"41383:6706:35136",
	"41383:35138",
	"41383:40966:35481",
	"41383:40966:35481:35478",
	"41383:40966:35481:35478:35556",
	"41383:40966:35481:35562",
	"41383:39175",
	"40367:40358:39211:39210",
	"40367:40358:4321:39212",
	"40367:40358:39211",
	"40367:40768",
	"40367:7823:40827",
	"40367:7823:41214",
	"41383:35138:41240",
	"41383:6706:34378:4267:22935:XY-2454825450:43481",
	"41383:6706:34378:4267:22935:XY-2454825450:43481:41860",
	"41383:6706:34378:4267:22935:XY-2454825450:43481:41861",
	"41383:40966",
	"41383:6706:34378:4267:22931:43073",
	"41383:6706:34378:4267:22931:43079",
	"41383:6706:34378:4267:22935:XY-2454825450",
	"41383:XY-2030030181:17555:43991",
	"41383:163253:48275",
	"41383:163253",
	"41383:163253:XY-1868173255",
	"41383:6706:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Tower of Estulan, Feralas",
	["m"] = 69,
	["f"] = 0,
	["direct"] = "40367:41383",
	["coord"] = 2449377781,
	},
	[16227] = {
	"4321:40358:40367",
	"39210:35136:4407",
	"39210:35136:6706",
	"4321:40358:40367:41383",
	"4267:XY-1974645611:XY-2030030181:10897",
	"4267:22931:12578:11138",
	"4267:22931:12578",
	"7823:10583",
	"4267:XY-1974645611:XY-2030030181:17555:17554",
	"4267:XY-1974645611:XY-2030030181:17555",
	"4267:22931",
	"4267:22935",
	"4321:40358",
	"4267:34374",
	"39210:34378",
	"39210:35136:35137",
	"39210:35136",
	"39210:35136:6706:35138",
	"39210:35136:6706:35481",
	"39210:35136:6706:35478",
	"39210:35136:6706:35556",
	"39210:35136:6706:35562",
	"7823:39175",
	"39212:39211",
	"4321:40358:40768",
	"7823:40827",
	"7823:41214",
	"39210:35136:35137:41240",
	"4267:22935:XY-2454825450:43481",
	"4267:22935:XY-2454825450:43481:41860",
	"4267:22935:XY-2454825450:43481:41861",
	"39210:35136:6706:35481:40966",
	"4321:40358:40367:41580",
	"4267:22931:43073",
	"4267:22931:43079",
	"4267:22935:XY-2454825450",
	"4267:XY-1974645611:XY-2030030181:17555:43991",
	"7823:40827:48275",
	"7823:39175:163253",
	"7823:40827:48275:XY-1868173255",
	"4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Ratchet, Northern Barrens",
	["m"] = 10,
	["f"] = 0,
	["direct"] = "4267:4321:7823:39210:39212",
	["coord"] = 2967713022,
	},
	[35481] = {
	"6706:34378:4267",
	"40966:41383:41580:40367",
	"40966:41383:41580:40367:40358:4321",
	"40966:41383:39175:7823",
	"4407:XY-2030030181:10897",
	"4407:XY-1974645611:12578:11138",
	"4407:XY-1974645611:12578",
	"40966:41383:39175:10583",
	"6706:35136:39210:16227",
	"4407:XY-2030030181:17555:17554",
	"4407:XY-2030030181:17555",
	"6706:34378:4267:22931",
	"6706:34378:4267:22935",
	"40966:41383:41580:40367:40358",
	"4407:34374",
	"6706:34378",
	"6706:35137",
	"6706:35136",
	"6706:35138",
	"35478:35556",
	"40966:41383:39175",
	"6706:35136:39210",
	"6706:35136:39210:39212",
	"6706:35136:39210:39211",
	"40966:41383:41580:40367:40768",
	"40966:41383:163253:48275:40827",
	"40966:41383:39175:7823:41214",
	"6706:35138:41240",
	"6706:34378:4267:22935:XY-2454825450:43481",
	"6706:34378:4267:22935:XY-2454825450:43481:41860",
	"6706:34378:4267:22935:XY-2454825450:43481:41861",
	"40966:41383:41580",
	"6706:34378:4267:22931:43073",
	"6706:34378:4267:22931:43079",
	"6706:34378:4267:22935:XY-2454825450",
	"4407:XY-2030030181:17555:43991",
	"40966:41383:163253:48275",
	"40966:41383:163253",
	"40966:41383:163253:XY-1868173255",
	"6706:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Thargad's Camp, Desolace",
	["m"] = 66,
	["f"] = 0,
	["direct"] = "4407:6706:41383:35478:35562:40966",
	["coord"] = 1580644210,
	},
	[35478] = {
	"6706:34378:4267",
	"35481:40966:41383:41580:40367",
	"6706:35136:39210:39212:4321",
	"35481:40966:41383:39175:7823",
	"35481:40966:41383",
	"4407:XY-2030030181:10897",
	"6706:34378:4267:22931:12578:11138",
	"6706:34378:4267:22931:12578",
	"35481:40966:41383:39175:10583",
	"6706:35136:39210:16227",
	"4407:XY-2030030181:17555:17554",
	"4407:XY-2030030181:17555",
	"6706:34378:4267:22931",
	"6706:34378:4267:22935",
	"35481:40966:41383:41580:40367:40358",
	"6706:34378:4267:34374",
	"6706:34378",
	"6706:35137",
	"6706:35136",
	"6706:35138",
	"35481:40966:41383:39175",
	"6706:35136:39210",
	"6706:35136:39210:39212",
	"6706:35136:39210:39211",
	"35481:40966:41383:41580:40367:40768",
	"35481:40966:41383:163253:48275:40827",
	"35481:40966:41383:39175:7823:41214",
	"6706:35138:41240",
	"6706:34378:4267:22935:XY-2454825450:43481",
	"6706:34378:4267:22935:XY-2454825450:43481:41860",
	"6706:34378:4267:22935:XY-2454825450:43481:41861",
	"35481:40966",
	"35481:40966:41383:41580",
	"6706:34378:4267:22931:43073",
	"6706:34378:4267:22931:43079",
	"6706:34378:4267:22935:XY-2454825450",
	"4407:XY-2030030181:17555:43991",
	"35481:40966:41383:163253:48275",
	"35481:40966:41383:163253",
	"35481:40966:41383:163253:XY-1868173255",
	"6706:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Karnum's Glade, Desolace",
	["m"] = 66,
	["f"] = 0,
	["direct"] = "4407:6706:35481:35556:35562",
	["coord"] = 2480242528,
	},
	[10583] = {
	"7823:40768:40358:39211:39210:34378:4267",
	"7823:40367",
	"7823:4321",
	"39175:41383:35138:4407",
	"39175:41383:6706",
	"39175:41383",
	"7823:40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:10897",
	"7823:40768:40358:39211:39210:34378:4267:22931:12578:11138",
	"7823:40768:40358:39211:39210:34378:4267:22931:12578",
	"7823:16227",
	"7823:40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555:17554",
	"7823:40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555",
	"7823:40768:40358:39211:39210:34378:4267:22931",
	"7823:40768:40358:39211:39210:34378:4267:22935",
	"7823:40768:40358",
	"7823:40768:40358:39211:39210:34378:4267:34374",
	"7823:40768:40358:39211:39210:34378",
	"39175:41383:6706:35137",
	"7823:40768:40358:39211:39210:35136",
	"39175:41383:35138",
	"39175:41383:40966:35481",
	"39175:41383:40966:35481:35478",
	"39175:41383:40966:35481:35478:35556",
	"39175:41383:40966:35481:35562",
	"7823:40768:40358:39211:39210",
	"7823:4321:39212",
	"7823:40768:40358:39211",
	"7823:40768",
	"7823:40827",
	"7823:41214",
	"39175:41383:35138:41240",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481:41860",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481:41861",
	"39175:41383:40966",
	"39175:41383:41580",
	"7823:40768:40358:39211:39210:34378:4267:22931:43073",
	"7823:40768:40358:39211:39210:34378:4267:22931:43079",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450",
	"7823:40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555:43991",
	"39175:163253:48275",
	"39175:163253",
	"39175:163253:XY-1868173255",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Marshal's Stand, Un'Goro Crater",
	["m"] = 78,
	["f"] = 0,
	["direct"] = "7823:39175",
	["coord"] = 2408031264,
	},
	[43481] = {
	"XY-2454825450:22935:4267",
	"XY-2454825450:22935:4267:34378:6706:35481:40966:41383:41580:40367",
	"XY-2454825450:22935:4267:16227:4321",
	"XY-2454825450:22935:4267:34378:4407",
	"XY-2454825450:22935:4267:34378:6706",
	"XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823",
	"XY-2454825450:22935:4267:34378:6706:35481:40966:41383",
	"41861:10897",
	"41861:11138",
	"41861:10897:12578",
	"XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823:10583",
	"XY-2454825450:22935:4267:16227",
	"41861:10897:XY-2030030181:17555:17554",
	"41861:10897:XY-2030030181:17555",
	"XY-2454825450:22935:22931",
	"XY-2454825450:22935",
	"XY-2454825450:22935:4267:34378:39210:39211:40358",
	"XY-2454825450:22935:4267:34374",
	"XY-2454825450:22935:4267:34378",
	"XY-2454825450:22935:4267:34378:35137",
	"XY-2454825450:22935:4267:34378:35136",
	"XY-2454825450:22935:4267:34378:35137:41240:35138",
	"XY-2454825450:22935:4267:34378:6706:35481",
	"XY-2454825450:22935:4267:34378:6706:35478",
	"XY-2454825450:22935:4267:34378:6706:35556",
	"XY-2454825450:22935:4267:34378:6706:35562",
	"XY-2454825450:22935:4267:34378:6706:35481:40966:41383:39175",
	"XY-2454825450:22935:4267:34378:39210",
	"XY-2454825450:22935:4267:34378:39210:39212",
	"XY-2454825450:22935:4267:34378:39210:39211",
	"XY-2454825450:22935:4267:34378:39210:39211:40358:40768",
	"XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823:40827",
	"XY-2454825450:22935:4267:34378:39210:39211:40358:40768:7823:41214",
	"XY-2454825450:22935:4267:34378:35137:41240",
	"XY-2454825450:22935:4267:34378:6706:35481:40966",
	"XY-2454825450:22935:4267:34378:6706:35481:40966:41383:41580",
	"41861:10897:12578:43073",
	"XY-2454825450:22935:22931:43079",
	"41861:10897:XY-2030030181:17555:43991",
	"XY-2454825450:22935:4267:34378:6706:35481:40966:41383:163253:48275",
	"XY-2454825450:22935:4267:34378:6706:35481:40966:41383:163253",
	"XY-2454825450:22935:4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	--["name"] = "Shrine of Aviana, Hyjal",
	["m"] = 198,
	["coord"] = 1766747406,
	["direct"] = "41860:41861:XY-2454825450:54392",
	["f"] = 0,
	},
	[41214] = {
	"7823:40768:40358:39211:39210:34378:4267",
	"7823:40367",
	"7823:4321",
	"7823:40768:40358:39211:39210:35136:4407",
	"7823:40768:40358:39211:39210:35136:6706",
	"7823:39175:41383",
	"7823:40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:10897",
	"7823:40768:40358:39211:39210:34378:4267:22931:12578:11138",
	"7823:40768:40358:39211:39210:34378:4267:22931:12578",
	"7823:10583",
	"7823:16227",
	"7823:40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555:17554",
	"7823:40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555",
	"7823:40768:40358:39211:39210:34378:4267:22931",
	"7823:40768:40358:39211:39210:34378:4267:22935",
	"7823:40768:40358",
	"7823:40768:40358:39211:39210:34378:4267:34374",
	"7823:40768:40358:39211:39210:34378",
	"7823:40768:40358:39211:39210:35136:35137",
	"7823:40768:40358:39211:39210:35136",
	"7823:40768:40358:39211:39210:35136:6706:35138",
	"7823:39175:41383:40966:35481",
	"7823:39175:41383:40966:35481:35478",
	"7823:40768:40358:39211:39210:35136:6706:35556",
	"7823:39175:41383:40966:35481:35562",
	"7823:39175",
	"7823:40768:40358:39211:39210",
	"7823:4321:39212",
	"7823:40768:40358:39211",
	"7823:40768",
	"7823:40768:40358:39211:39210:35136:35137:41240",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481:41860",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481:41861",
	"7823:39175:41383:40966",
	"7823:40367:41580",
	"7823:40768:40358:39211:39210:34378:4267:22931:43073",
	"7823:40768:40358:39211:39210:34378:4267:22931:43079",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450",
	"7823:40768:40358:39211:39210:34378:4267:XY-1974645611:XY-2030030181:17555:43991",
	"40827:48275",
	"40827:48275:163253",
	"40827:48275:XY-1868173255",
	"7823:40768:40358:39211:39210:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Bootlegger Outpost, Tanaris",
	["m"] = 71,
	["f"] = 0,
	["direct"] = "7823:40827",
	["coord"] = 2397215500,
	},
	[17555] = {
	"XY-2030030181:XY-1974645611:4267",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:41580:40367",
	"XY-2030030181:XY-1974645611:4267:16227:4321",
	"XY-2030030181:XY-1974645611:4407",
	"XY-2030030181:XY-1974645611:4267:34378:6706",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383",
	"XY-2030030181:10897",
	"XY-2030030181:12578:11138",
	"XY-2030030181:12578",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:10583",
	"XY-2030030181:XY-1974645611:4267:16227",
	"XY-2030030181:XY-1974645611:22931",
	"XY-2030030181:XY-1974645611:22931:22935",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358",
	"XY-2030030181:XY-1974645611:34374",
	"XY-2030030181:XY-1974645611:4267:34378",
	"XY-2030030181:XY-1974645611:4267:34378:35137",
	"XY-2030030181:XY-1974645611:4267:34378:35136",
	"XY-2030030181:XY-1974645611:4407:35138",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35478",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35556",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35562",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:39175",
	"XY-2030030181:XY-1974645611:4267:34378:39210",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39212",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39211",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:40827",
	"XY-2030030181:XY-1974645611:4267:34378:39210:39211:40358:40768:7823:41214",
	"XY-2030030181:XY-1974645611:4407:41240",
	"XY-2030030181:10897:41861:43481",
	"XY-2030030181:10897:41861:41860",
	"XY-2030030181:10897:41861",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:41580",
	"XY-2030030181:12578:43073",
	"XY-2030030181:XY-1974645611:43079",
	"XY-2030030181:10897:41861:43481:XY-2454825450",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:163253:48275",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:163253",
	"XY-2030030181:XY-1974645611:4267:34378:6706:35481:40966:41383:163253:XY-1868173255",
	"XY-2030030181:10897:41861:43481:54392",
	--["name"] = "The Exodar",
	["m"] = 103,
	["coord"] = 2333433210,
	["direct"] = "17554:43991",
	["f"] = 0,
	},
	[40966] = {
	"35481:6706:34378:4267",
	"41383:41580:40367",
	"41383:41580:40367:40358:4321",
	"35481:4407",
	"35481:6706",
	"41383:39175:7823",
	"35481:4407:XY-2030030181:10897",
	"35481:4407:XY-1974645611:12578:11138",
	"35481:4407:XY-1974645611:12578",
	"41383:39175:10583",
	"35481:6706:35136:39210:16227",
	"35481:4407:XY-2030030181:17555:17554",
	"35481:4407:XY-2030030181:17555",
	"35481:6706:34378:4267:22931",
	"35481:6706:34378:4267:22935",
	"41383:41580:40367:40358",
	"35481:4407:34374",
	"35481:6706:34378",
	"35481:6706:35137",
	"35481:6706:35136",
	"35481:6706:35138",
	"35481:35478",
	"35481:35478:35556",
	"35481:35562",
	"41383:39175",
	"35481:6706:35136:39210",
	"41383:41580:40367:40358:4321:39212",
	"41383:41580:40367:40358:39211",
	"41383:41580:40367:40768",
	"41383:163253:48275:40827",
	"41383:39175:7823:41214",
	"35481:6706:35138:41240",
	"35481:6706:34378:4267:22935:XY-2454825450:43481",
	"35481:6706:34378:4267:22935:XY-2454825450:43481:41860",
	"35481:6706:34378:4267:22935:XY-2454825450:43481:41861",
	"41383:41580",
	"35481:6706:34378:4267:22931:43073",
	"35481:6706:34378:4267:22931:43079",
	"35481:6706:34378:4267:22935:XY-2454825450",
	"35481:4407:XY-2030030181:17555:43991",
	"41383:163253:48275",
	"41383:163253",
	"41383:163253:XY-1868173255",
	"35481:6706:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Dreamer's Rest, Feralas",
	["m"] = 69,
	["f"] = 0,
	["direct"] = "41383:35481",
	["coord"] = 2158045972,
	},
	[48275] = {
	"163253:41383:6706:34378:4267",
	"163253:41383:41580:40367",
	"40827:7823:4321",
	"163253:41383:35138:4407",
	"163253:41383:6706",
	"40827:7823",
	"163253:41383",
	"163253:41383:XY-2030030181:10897",
	"163253:41383:6706:34378:4267:22931:12578:11138",
	"163253:41383:6706:34378:4267:22931:12578",
	"163253:39175:10583",
	"40827:7823:16227",
	"163253:41383:XY-2030030181:17555:17554",
	"163253:41383:XY-2030030181:17555",
	"163253:41383:6706:34378:4267:22931",
	"163253:41383:6706:34378:4267:22935",
	"40827:7823:40768:40358",
	"163253:41383:35138:4407:34374",
	"163253:41383:6706:34378",
	"163253:41383:6706:35137",
	"40827:7823:40768:40358:39211:39210:35136",
	"163253:41383:35138",
	"163253:41383:40966:35481",
	"163253:41383:40966:35481:35478",
	"163253:41383:40966:35481:35478:35556",
	"163253:41383:40966:35481:35562",
	"163253:39175",
	"40827:7823:40768:40358:39211:39210",
	"40827:7823:4321:39212",
	"40827:7823:40768:40358:39211",
	"40827:7823:40768",
	"40827:41214",
	"163253:41383:35138:41240",
	"163253:41383:6706:34378:4267:22935:XY-2454825450:43481",
	"163253:41383:6706:34378:4267:22935:XY-2454825450:43481:41860",
	"163253:41383:6706:34378:4267:22935:XY-2454825450:43481:41861",
	"163253:41383:40966",
	"163253:41383:41580",
	"163253:41383:6706:34378:4267:22931:43073",
	"163253:41383:6706:34378:4267:22931:43079",
	"163253:41383:6706:34378:4267:22935:XY-2454825450",
	"163253:41383:XY-2030030181:17555:43991",
	"163253:41383:6706:34378:4267:22935:XY-2454825450:43481:54392",
	--["name"] = "Ramkahen, Uldum",
	["m"] = 1527,
	["f"] = 0,
	["direct"] = "40827:163253:XY-1868173255",
	["coord"] = 2412991987,
	},
	[39210] = {
	"34378:4267",
	"39211:40358:40367",
	"39212:4321",
	"35136:4407",
	"35136:6706",
	"39211:40358:40768:7823",
	"35136:6706:35481:40966:41383",
	"34378:4267:XY-1974645611:XY-2030030181:10897",
	"34378:4267:22931:12578:11138",
	"34378:4267:22931:12578",
	"39211:40358:40768:7823:10583",
	"34378:4267:XY-1974645611:XY-2030030181:17555:17554",
	"34378:4267:XY-1974645611:XY-2030030181:17555",
	"34378:4267:22931",
	"34378:4267:22935",
	"39211:40358",
	"34378:4267:34374",
	"35136:35137",
	"35136:6706:35138",
	"35136:6706:35481",
	"35136:6706:35478",
	"35136:6706:35556",
	"35136:6706:35562",
	"39211:40358:40768:7823:39175",
	"39211:40358:40768",
	"39211:40358:40768:7823:40827",
	"39211:40358:40768:7823:41214",
	"35136:35137:41240",
	"34378:4267:22935:XY-2454825450:43481",
	"34378:4267:22935:XY-2454825450:43481:41860",
	"34378:4267:22935:XY-2454825450:43481:41861",
	"35136:6706:35481:40966",
	"35136:6706:35481:40966:41383:41580",
	"34378:4267:22931:43073",
	"34378:4267:22931:43079",
	"34378:4267:22935:XY-2454825450",
	"34378:4267:XY-1974645611:XY-2030030181:17555:43991",
	"39211:40358:40768:7823:40827:48275",
	"35136:6706:35481:40966:41383:163253",
	"39211:40358:40768:7823:40827:48275:XY-1868173255",
	"34378:4267:22935:XY-2454825450:43481:54392",
	["direct"] = "16227:34378:35136:39212:39211",
	["coord"] = 1672420302,
	["m"] = 199,
	["f"] = 0,
	},
	},
	{
	[236116] = {
	"236112:236111",
	"236112:236119",
	["m"] = 2352,
	["direct"] = "236112:236113:236115:236117:236118",
	["coord"] = 1861907231,
	["f"] = 0,
	},
	[236117] = {
	"236116:236112:236111",
	"236116:236112",
	"236118:236119",
	--["name"] = "Gilded Oaks, Founder's Point",
	["m"] = 2352,
	["f"] = 0,
	["direct"] = "236113:236115:236116:236118",
	["coord"] = 1634967750,
	},
	[29480] = {
	"12617:43570:2835:1572:2941:352",
	"12617:44407:44410:2299:931:523",
	"12617:44407:44410:2299:931",
	"12617:1573",
	"12617:43570:2835:1571",
	"12617:43570:2835:1572",
	"12617:44407:44410:2299:931:2409",
	"12617:43570:2835",
	"12617:44407:44410:2299:931:2409:43045:2859",
	"12617:8018",
	"12617:12596",
	"12617:44407:44410:2299",
	"12617:43570:2835:1572:2941",
	"12617:44230:44233",
	"12617:44230:28621",
	"12617:44230",
	"12617:44231:44232",
	"12617:44407:44410:2299:931:2409:43045",
	"12617:37888",
	"12617:43570:2835:41325:41323",
	"12617:43570:2835:41325:41322",
	"12617:43570:2835:41325",
	"12617:43570:2835:41325:41322:41321",
	"12617:43570:2835:1572:41332",
	"12617:43570:2835:1572:2941:352:42983",
	"12617:44407:44410:2299:931:523:42426",
	"12617:43570:2835:1572:2941:352:42406",
	"12617:44407:44410:2299:931:43000",
	"12617:44407:44410:2299:931:2409:43045:43042",
	"12617:44407:44410:2299:931:2409:43045:43042:43043",
	"12617:44407:44410:2299:43086:43072",
	"12617:44407:44410:2299:43086:43087",
	"12617:44407:44410:2299:43086",
	"12617:44407:44410:2299:931:43088",
	"12617:1573:43290",
	"12617:44407:44410:2299:931:43371",
	"12617:43570",
	"12617:1573:43701",
	"12617:43570:2835:1572:43702",
	"12617:44407:44410:2299:931:2409:43697",
	"12617:44231",
	"12617:44407:44409",
	"12617:44407:44410",
	"12617:44407",
	"12617:37888:46011:46006",
	"12617:37888:46011",
	"12617:43570:2835:1572:XY-2626314551",
	"12617:43570:2835:1572:XY-2626314551:47147:47118",
	"12617:43570:2835:1572:XY-2626314551:47147",
	"12617:43570:2835:1572:XY-2626314551:47147:47154",
	"12617:43570:2835:1572:XY-2626314551:47155",
	"12617:44230:44233:47875",
	"12617:43570:2835:1572:2941:47927",
	"12617:43570:2835:1572:2941:47927:48318",
	"12617:44407:44410:2299:48321",
	"12617:44407:44410:2299:43086:43087:85731",
	"12617:238480:241031:251081:242011",
	"12617:238480:242913:239639:246560",
	"12617:238480:241031:249150",
	"12617:238480:241031:241036",
	"12617:238480:241031",
	"12617:238480:241031:251081",
	"12617:238480:241031:251073",
	"12617:238480:242913:239639",
	"12617:238480:242913",
	"12617:238480",
	"12617:44230:44233:47875:244537",
	["m"] = 23,
	["coord"] = 3601105142,
	["direct"] = "12617",
	["f"] = 0,
	requirements = "cls:DEATHKNIGHT"
	},
	[236111] = {
	"236112:236116:236115",
	"236112:236116",
	"236112:236116:236117",
	--["name"] = "Entrance Portal, Founder's Point",
	["m"] = 2352,
	["f"] = 0,
	["direct"] = "236112:236113:236118:236119",
	["coord"] = 2432452264,
	},
	[236112] = {
	"236116:236115:236113",
	"236116:236115",
	"236116:236117",
	--["name"] = "Town Center, Founder's Point",
	["m"] = 2352,
	["f"] = 0,
	["direct"] = "236111:236116:236118:236119",
	["coord"] = 2202166600,
	},
	[236113] = {
	"236116:236112",
	"236116:236118",
	"236111:236119",
	--["name"] = "Mear's Farm, Founder's Point",
	["m"] = 2352,
	["f"] = 0,
	["direct"] = "236111:236115:236116:236117",
	["coord"] = 1486313370,
	},
	[236115] = {
	"236113:236111",
	"236116:236112",
	"236116:236118",
	"236116:236112:236119",
	--["name"] = "The Outer Banks, Founder's Point",
	["m"] = 2352,
	["f"] = 0,
	["direct"] = "236113:236116:236117",
	["coord"] = 1389393234,
	},
	[236119] = {
	"236112:236116:236115:236113",
	"236112:236116:236115",
	"236112:236116",
	"236118:236117",
	--["name"] = "Stoneveil Ridge, Founder's Point",
	["m"] = 2352,
	["f"] = 0,
	["direct"] = "236111:236112:236118",
	["coord"] = 2735630861,
	},
	[236118] = {
	"236116:236115:236113",
	"236116:236115",
	--["name"] = "Brumewood Hollow, Founder's Point",
	["direct"] = "236111:236112:236116:236117:236119",
	["m"] = 2352,
	["f"] = 0,
	["coord"] = 2419037300,
	},
	[1571] = {
	"1573:2941:352",
	"1573:2941:352:523",
	"1573:2941:2299:931",
	"1573:2941:2299:931:2409",
	"1573:2941:352:2859",
	"2835:8018",
	"2835:8018:12596",
	"2835:43570:12617",
	"1573:2941:2299",
	"1573:2941",
	"2835:43570:12617:44230:44233",
	"2835:43570:12617:44230:28621",
	"2835:43570:12617:44230",
	"2835:43570:12617:44231:44232",
	"1573:2941:352:43045",
	"2835:8018:12596:37888",
	"41323:41322",
	"41323:41325",
	"41323:41322:41321",
	"41323:41322:41321:1572:41332",
	"1573:2941:352:42983",
	"1573:2941:352:523:42426",
	"1573:2941:352:42406",
	"1573:2941:2299:931:43000",
	"1573:2941:352:43045:43042",
	"1573:2941:352:43045:43042:43043",
	"1573:2941:2299:43086:43072",
	"1573:2941:2299:43086:43087",
	"1573:2941:2299:43086",
	"1573:2941:2299:931:43088",
	"1573:2941:2299:931:43371",
	"2835:43570",
	"1573:43701",
	"1573:43702",
	"1573:2941:352:523:43697",
	"2835:43570:12617:44231",
	"41323:41322:41321:1572:44409",
	"41323:41322:41321:1572:44409:44410",
	"41323:41322:41321:1572:44409:44407",
	"2835:8018:46006",
	"2835:8018:46006:46011",
	"41323:41322:41321:1572:XY-2626314551",
	"41323:41322:41321:1572:XY-2626314551:47147:47118",
	"41323:41322:41321:1572:XY-2626314551:47147",
	"41323:41322:41321:1572:XY-2626314551:47147:47154",
	"41323:41322:41321:1572:XY-2626314551:47155",
	"2835:8018:46006:46011:47875",
	"1573:2941:47927",
	"1573:2941:47927:48318",
	"1573:2941:47927:48318:48321",
	"1573:2941:2299:43086:43087:85731",
	"2835:43570:12617:238480:241031:251081:242011",
	"2835:43570:12617:238480:242913:239639:246560",
	"2835:43570:12617:238480:241031:249150",
	"2835:43570:12617:238480:241031:241036",
	"2835:43570:12617:238480:241031",
	"2835:43570:12617:238480:241031:251081",
	"2835:43570:12617:238480:241031:251073",
	"2835:43570:12617:238480:242913:239639",
	"2835:43570:12617:238480:242913",
	"2835:43570:12617:238480",
	--["name"] = "Menethil Harbor, Wetlands",
	["m"] = 56,
	["coord"] = 403085391,
	["direct"] = "1573:1572:2835:41323",
	["f"] = 0,
	},
	[43043] = {
	"43042:43045:352",
	"43042:43045:523",
	"43042:43045:2409:931",
	"43042:43045:352:1573",
	"43042:43045:352:1573:1571",
	"43042:43045:2409:931:2299:44410:44409:1572",
	"43042:43045:2409",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"43042:43045:2409:931:2299",
	"43042:43045:352:2941",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"43042:43045",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41323",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325",
	"43042:43045:2409:931:2299:44410:44409:1572:41321",
	"43042:43045:2409:931:2299:44410:44407:41332",
	"43042:43045:2409:42983",
	"43042:43045:523:42426",
	"43042:43045:523:42406",
	"43042:43045:2409:931:43000",
	"43042:43045:2409:931:43371:43072",
	"43042:43045:85731:43087",
	"43042:43045:2409:931:43371:43072:43086",
	"43042:43045:2409:931:43088",
	"43042:43045:2409:931:43371",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570",
	"43042:43045:352:1573:43701",
	"43042:43045:2409:931:2299:44410:44409:1572:43702",
	"43042:43045:43697",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"43042:43045:2409:931:2299:44410:44409",
	"43042:43045:2409:931:2299:44410",
	"43042:43045:2409:931:2299:44410:44407",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"43042:43045:2409:931:2299:44410:44409:1572:XY-2626314551",
	"43042:43045:2409:931:2299:44410:44409:1572:XY-2626314551:47147:47118",
	"43042:43045:2409:931:2299:44410:44409:1572:XY-2626314551:47147",
	"43042:43045:2409:931:2299:44410:44409:1572:XY-2626314551:47147:47154",
	"43042:43045:2409:931:2299:44410:44409:1572:XY-2626314551:47155",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"43042:43045:2409:931:2299:48321:48318:47927",
	"43042:43045:2409:931:2299:48321:48318",
	"43042:43045:2409:931:2299:48321",
	"43042:43045:85731",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Explorers' League Digsite, Stranglethorn",
	["m"] = 210,
	["f"] = 0,
	["direct"] = "2859:43042",
	["coord"] = 2390976907,
	},
	[249150] = {
	"241031:238480:244537:47875:46011:12596:1573:2941:352",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:523",
	"241031:238480:12617:44407:44410:2299:931",
	"241031:238480:244537:47875:46011:12596:1573",
	"241031:238480:12617:43570:2835:1571",
	"241031:238480:12617:43570:2835:1572",
	"241031:238480:12617:44407:44410:2299:931:2409",
	"241031:238480:12617:43570:2835",
	"241031:238480:12617:44407:44410:2299:931:2409:43045:2859",
	"241031:238480:12617:8018",
	"241031:238480:244537:47875:46011:12596",
	"241031:238480:12617",
	"241031:238480:12617:44407:44410:2299",
	"241031:238480:244537:47875:46011:12596:1573:2941",
	"241031:238480:244537:47875:44233",
	"241031:238480:12617:44230:28621",
	"241031:238480:12617:44230",
	"241031:238480:12617:44231:44232",
	"241031:238480:12617:44407:44410:2299:931:2409:43045",
	"241031:238480:244537:47875:46011:37888",
	"241031:238480:12617:43570:2835:41325:41323",
	"241031:238480:12617:43570:2835:41325:41322",
	"241031:238480:12617:43570:2835:41325",
	"241031:238480:12617:43570:2835:41325:41322:41321",
	"241031:238480:12617:43570:2835:1572:41332",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:42983",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:523:42426",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:42406",
	"241031:238480:12617:44407:44410:2299:931:43000",
	"241031:238480:12617:44407:44410:2299:931:2409:43045:43042",
	"241031:238480:12617:44407:44410:2299:931:2409:43045:43042:43043",
	"241031:238480:12617:44407:44410:2299:43086:43072",
	"241031:238480:12617:44407:44410:2299:43086:43087",
	"241031:238480:12617:44407:44410:2299:43086",
	"241031:238480:12617:44407:44410:2299:931:43088",
	"241031:238480:12617:44407:44410:2299:931:43371",
	"241031:238480:12617:43570",
	"241031:238480:244537:47875:46011:12596:1573:43701",
	"241031:238480:244537:47875:46011:12596:1573:43702",
	"241031:238480:12617:44407:44410:2299:931:2409:43697",
	"241031:238480:12617:44231",
	"241031:238480:12617:44407:44409",
	"241031:238480:12617:44407:44410",
	"241031:238480:12617:44407",
	"241031:238480:244537:47875:46011:46006",
	"241031:238480:244537:47875:46011",
	"241031:238480:12617:43570:2835:1572:XY-2626314551",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47147:47118",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47147",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47147:47154",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47155",
	"241031:238480:244537:47875",
	"241031:238480:244537:47875:46011:12596:1573:2941:47927",
	"241031:238480:244537:47875:46011:12596:1573:2941:47927:48318",
	"241031:238480:12617:44407:44410:2299:48321",
	"241031:238480:12617:44407:44410:2299:43086:43087:85731",
	"241031:251081:242011",
	"241031:238480:242913:239639:246560",
	"241031:251081",
	"241031:251073",
	"241031:238480:242913:239639",
	"241031:238480:242913",
	"241031:238480",
	--["name"] = "Torntusk Overlook, Zul'Aman",
	["m"] = 2437,
	["f"] = 0,
	["direct"] = "241036:241031",
	["coord"] = 1455278232,
	},
	[1572] = {
	"2941:352",
	"2941:352:523",
	"44409:44410:2299:931",
	"44409:44410:2299:931:2409",
	"2941:352:2859",
	"41321:41322:41325:2835:8018",
	"41321:41322:41325:2835:8018:12596",
	"41321:41322:41325:2835:43570:12617",
	"44409:44410:2299",
	"41321:41322:41325:2835:43570:12617:44230:44233",
	"41321:41322:41325:2835:43570:12617:44230:28621",
	"41321:41322:41325:2835:43570:12617:44230",
	"41321:41322:41325:2835:43570:12617:44231:44232",
	"2941:352:43045",
	"41321:41322:41325:2835:8018:12596:37888",
	"41321:41322:41323",
	"41321:41322",
	"41321:41322:41325",
	"2941:352:42983",
	"2941:352:523:42426",
	"2941:352:42406",
	"44409:44410:2299:931:43000",
	"2941:352:43045:43042",
	"2941:352:43045:43042:43043",
	"44409:44410:2299:43086:43072",
	"44409:44410:2299:43086:43087",
	"44409:44410:2299:43086",
	"44409:44410:2299:931:43088",
	"44409:44410:2299:931:43371",
	"41321:41322:41325:2835:43570",
	"43702:43701",
	"2941:352:523:43697",
	"41321:41322:41325:2835:43570:12617:44231",
	"44409:44410",
	"44409:44407",
	"41321:41322:41325:2835:8018:46006",
	"41321:41322:41325:2835:8018:46006:46011",
	"XY-2626314551:47147:47118",
	"XY-2626314551:47147",
	"XY-2626314551:47147:47154",
	"XY-2626314551:47155",
	"41321:41322:41325:2835:8018:46006:46011:47875",
	"2941:47927",
	"2941:47927:48318",
	"2941:47927:48318:48321",
	"44409:44410:2299:43086:43087:85731",
	"41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"41321:41322:41325:2835:43570:12617:238480:241031",
	"41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"41321:41322:41325:2835:43570:12617:238480:242913",
	"41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Thelsamar, Loch Modan",
	["m"] = 48,
	["coord"] = 1457816072,
	["direct"] = "1573:1571:2835:2941:41321:41332:43702:44409:XY-2626314551",
	["f"] = 0,
	},
	[43702] = {
	"1572:2941:352",
	"1572:2941:352:523",
	"1572:44409:44410:2299:931",
	"1573:1571",
	"1572:44409:44410:2299:931:2409",
	"1572:41321:41322:41325:2835",
	"1572:2941:352:2859",
	"1572:41321:41322:41325:2835:8018",
	"1573:12596",
	"1572:41321:41322:41325:2835:43570:12617",
	"1572:44409:44410:2299",
	"1572:2941",
	"1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"1572:41321:41322:41325:2835:43570:12617:44230",
	"1573:12596:37888:44232",
	"1572:2941:352:43045",
	"1573:12596:37888",
	"1572:41321:41322:41323",
	"1572:41321:41322",
	"1572:41321:41322:41325",
	"1572:41321",
	"1572:41332",
	"1572:2941:352:42983",
	"1572:2941:352:523:42426",
	"1572:2941:352:42406",
	"1572:44409:44410:2299:931:43000",
	"1572:2941:352:43045:43042",
	"1572:2941:352:43045:43042:43043",
	"1572:44409:44410:2299:43086:43072",
	"1572:44409:44410:2299:43086:43087",
	"1572:44409:44410:2299:43086",
	"1572:44409:44410:2299:931:43088",
	"1572:44409:44410:2299:931:43371",
	"1572:41321:41322:41325:2835:43570",
	"1572:2941:352:523:43697",
	"1572:41321:41322:41325:2835:43570:12617:44231",
	"1572:44409",
	"1572:44409:44410",
	"1572:44409:44407",
	"1572:41321:41322:41325:2835:8018:46006",
	"1573:12596:46011",
	"1572:XY-2626314551",
	"1572:XY-2626314551:47147:47118",
	"1572:XY-2626314551:47147",
	"1572:XY-2626314551:47147:47154",
	"1572:XY-2626314551:47155",
	"1573:12596:46011:47875",
	"1572:2941:47927",
	"1572:2941:47927:48318",
	"1572:2941:47927:48318:48321",
	"1572:44409:44410:2299:43086:43087:85731",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Gol'Bolar Quarry, Dun Morogh",
	["m"] = 27,
	["coord"] = 3258616573,
	["direct"] = "1573:1572:43701",
	["f"] = 0,
	},
	[47147] = {
	"XY-2626314551:1572:2941:352",
	"XY-2626314551:1572:2941:352:523",
	"XY-2626314551:1572:44409:44410:2299:931",
	"XY-2626314551:1572:1573",
	"XY-2626314551:1572:1571",
	"XY-2626314551:1572",
	"XY-2626314551:1572:44409:44410:2299:931:2409",
	"XY-2626314551:1572:41321:41322:41325:2835",
	"XY-2626314551:1572:2941:352:2859",
	"XY-2626314551:1572:41321:41322:41325:2835:8018",
	"XY-2626314551:1572:41321:41322:41325:2835:8018:12596",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617",
	"XY-2626314551:1572:44409:44410:2299",
	"XY-2626314551:1572:2941",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44230",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"XY-2626314551:1572:2941:352:43045",
	"XY-2626314551:1572:41321:41322:41325:2835:8018:12596:37888",
	"XY-2626314551:1572:41321:41322:41323",
	"XY-2626314551:1572:41321:41322",
	"XY-2626314551:1572:41321:41322:41325",
	"XY-2626314551:1572:41321",
	"XY-2626314551:1572:41332",
	"XY-2626314551:1572:2941:352:42983",
	"XY-2626314551:1572:2941:352:523:42426",
	"XY-2626314551:1572:2941:352:42406",
	"XY-2626314551:1572:44409:44410:2299:931:43000",
	"XY-2626314551:1572:2941:352:43045:43042",
	"XY-2626314551:1572:2941:352:43045:43042:43043",
	"XY-2626314551:1572:44409:44410:2299:43086:43072",
	"XY-2626314551:1572:44409:44410:2299:43086:43087",
	"XY-2626314551:1572:44409:44410:2299:43086",
	"XY-2626314551:1572:44409:44410:2299:931:43088",
	"XY-2626314551:1572:44409:44410:2299:931:43371",
	"XY-2626314551:1572:41321:41322:41325:2835:43570",
	"XY-2626314551:1572:43702:43701",
	"XY-2626314551:1572:43702",
	"XY-2626314551:1572:2941:352:523:43697",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44231",
	"XY-2626314551:1572:44409",
	"XY-2626314551:1572:44409:44410",
	"XY-2626314551:1572:44409:44407",
	"XY-2626314551:1572:41321:41322:41325:2835:8018:46006",
	"XY-2626314551:1572:41321:41322:41325:2835:8018:46006:46011",
	"XY-2626314551:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"XY-2626314551:1572:2941:47927",
	"XY-2626314551:1572:2941:47927:48318",
	"XY-2626314551:1572:2941:47927:48318:48321",
	"XY-2626314551:1572:44409:44410:2299:43086:43087:85731",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Firebeard's Patrol, Twilight Highlands",
	["m"] = 241,
	["coord"] = 2594280361,
	["direct"] = "XY-2626314551:47118:47154:47155",
	["f"] = 0,
	},
	[44230] = {
	"12617:43570:2835:1572:2941:352",
	"12617:44407:44410:2299:931:523",
	"12617:44407:44410:2299:931",
	"44231:44232:37888:12596:1573",
	"12617:43570:2835:1571",
	"12617:43570:2835:1572",
	"12617:44407:44410:2299:931:2409",
	"12617:43570:2835",
	"12617:44407:44410:2299:931:2409:43045:2859",
	"12617:8018",
	"44231:44232:37888:12596",
	"12617:44407:44410:2299",
	"12617:43570:2835:1572:2941",
	"44231:44232",
	"12617:44407:44410:2299:931:2409:43045",
	"44231:44232:37888",
	"12617:43570:2835:41325:41323",
	"12617:43570:2835:41325:41322",
	"12617:43570:2835:41325",
	"12617:43570:2835:41325:41322:41321",
	"12617:43570:2835:1572:41332",
	"12617:43570:2835:1572:2941:352:42983",
	"12617:44407:44410:2299:931:523:42426",
	"12617:43570:2835:1572:2941:352:42406",
	"12617:44407:44410:2299:931:43000",
	"12617:44407:44410:2299:931:2409:43045:43042",
	"12617:44407:44410:2299:931:2409:43045:43042:43043",
	"12617:44407:44410:2299:43086:43072",
	"12617:44407:44410:2299:43086:43087",
	"12617:44407:44410:2299:43086",
	"12617:44407:44410:2299:931:43088",
	"12617:44407:44410:2299:931:43371",
	"12617:43570",
	"44231:44232:37888:12596:1573:43701",
	"12617:43570:2835:1572:43702",
	"12617:44407:44410:2299:931:2409:43697",
	"12617:44407:44409",
	"12617:44407:44410",
	"12617:44407",
	"44231:44232:37888:46011:46006",
	"44231:44232:37888:46011",
	"12617:43570:2835:1572:XY-2626314551",
	"12617:43570:2835:1572:XY-2626314551:47147:47118",
	"12617:43570:2835:1572:XY-2626314551:47147",
	"12617:43570:2835:1572:XY-2626314551:47147:47154",
	"12617:43570:2835:1572:XY-2626314551:47155",
	"44233:47875",
	"12617:43570:2835:1572:2941:47927",
	"12617:43570:2835:1572:2941:47927:48318",
	"12617:44407:44410:2299:48321",
	"12617:44407:44410:2299:43086:43087:85731",
	"12617:238480:241031:251081:242011",
	"12617:238480:242913:239639:246560",
	"12617:238480:241031:249150",
	"12617:238480:241031:241036",
	"12617:238480:241031",
	"12617:238480:241031:251081",
	"12617:238480:241031:251073",
	"12617:238480:242913:239639",
	"12617:238480:242913",
	"12617:238480",
	--["name"] = "Eastwall Tower, Eastern Plaguelands",
	["m"] = 23,
	["f"] = 0,
	["direct"] = "12617:44233:28621:44231",
	["coord"] = 2644471905,
	},
	[47155] = {
	"XY-2626314551:1572:2941:352",
	"XY-2626314551:1572:2941:352:523",
	"XY-2626314551:1572:44409:44410:2299:931",
	"XY-2626314551:1572:1573",
	"XY-2626314551:1572:1571",
	"XY-2626314551:1572",
	"XY-2626314551:1572:44409:44410:2299:931:2409",
	"XY-2626314551:1572:41321:41322:41325:2835",
	"XY-2626314551:1572:2941:352:2859",
	"XY-2626314551:1572:41321:41322:41325:2835:8018",
	"XY-2626314551:1572:41321:41322:41325:2835:8018:12596",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617",
	"XY-2626314551:1572:44409:44410:2299",
	"XY-2626314551:1572:2941",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44230",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"XY-2626314551:1572:2941:352:43045",
	"XY-2626314551:1572:41321:41322:41325:2835:8018:12596:37888",
	"XY-2626314551:1572:41321:41322:41323",
	"XY-2626314551:1572:41321:41322",
	"XY-2626314551:1572:41321:41322:41325",
	"XY-2626314551:1572:41321",
	"XY-2626314551:1572:41332",
	"XY-2626314551:1572:2941:352:42983",
	"XY-2626314551:1572:2941:352:523:42426",
	"XY-2626314551:1572:2941:352:42406",
	"XY-2626314551:1572:44409:44410:2299:931:43000",
	"XY-2626314551:1572:2941:352:43045:43042",
	"XY-2626314551:1572:2941:352:43045:43042:43043",
	"XY-2626314551:1572:44409:44410:2299:43086:43072",
	"XY-2626314551:1572:44409:44410:2299:43086:43087",
	"XY-2626314551:1572:44409:44410:2299:43086",
	"XY-2626314551:1572:44409:44410:2299:931:43088",
	"XY-2626314551:1572:44409:44410:2299:931:43371",
	"XY-2626314551:1572:41321:41322:41325:2835:43570",
	"XY-2626314551:1572:43702:43701",
	"XY-2626314551:1572:43702",
	"XY-2626314551:1572:2941:352:523:43697",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44231",
	"XY-2626314551:1572:44409",
	"XY-2626314551:1572:44409:44410",
	"XY-2626314551:1572:44409:44407",
	"XY-2626314551:1572:41321:41322:41325:2835:8018:46006",
	"XY-2626314551:1572:41321:41322:41325:2835:8018:46006:46011",
	"47154:47118",
	"XY-2626314551:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"XY-2626314551:1572:2941:47927",
	"XY-2626314551:1572:2941:47927:48318",
	"XY-2626314551:1572:2941:47927:48318:48321",
	"XY-2626314551:1572:44409:44410:2299:43086:43087:85731",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Kirthaven, Twilight Highlands",
	["m"] = 241,
	["coord"] = 2436376277,
	["direct"] = "XY-2626314551:47147:47154",
	["f"] = 0,
	},
	[37888] = {
	"12596:1573:2941:352",
	"12596:1573:2941:352:523",
	"12596:1573:2941:2299:931",
	"12596:1573",
	"43570:2835:1571",
	"43570:2835:1572",
	"12596:1573:2941:2299:931:2409",
	"43570:2835",
	"12596:1573:2941:352:2859",
	"12596:8018",
	"12596:1573:2941:2299",
	"12596:1573:2941",
	"44232:44233",
	"44232:28621",
	"44232:44231:44230",
	"12596:1573:2941:352:43045",
	"43570:2835:41325:41323",
	"43570:2835:41325:41322",
	"43570:2835:41325",
	"43570:2835:41325:41322:41321",
	"43570:2835:1572:41332",
	"12596:1573:2941:352:42983",
	"12596:1573:2941:352:523:42426",
	"12596:1573:2941:352:42406",
	"12596:1573:2941:2299:931:43000",
	"12596:1573:2941:352:43045:43042",
	"12596:1573:2941:352:43045:43042:43043",
	"12596:1573:2941:2299:43086:43072",
	"12596:1573:2941:2299:43086:43087",
	"12596:1573:2941:2299:43086",
	"12596:1573:2941:2299:931:43088",
	"12596:1573:2941:2299:931:43371",
	"12596:1573:43701",
	"12596:1573:43702",
	"12596:1573:2941:352:523:43697",
	"44232:44231",
	"43570:2835:1572:44409",
	"43570:2835:1572:44409:44410",
	"12617:44407",
	"46011:46006",
	"43570:2835:1572:XY-2626314551",
	"43570:2835:1572:XY-2626314551:47147:47118",
	"43570:2835:1572:XY-2626314551:47147",
	"43570:2835:1572:XY-2626314551:47147:47154",
	"43570:2835:1572:XY-2626314551:47155",
	"46011:47875",
	"12596:1573:2941:47927",
	"12596:1573:2941:47927:48318",
	"12596:1573:2941:47927:48318:48321",
	"12596:1573:2941:2299:43086:43087:85731",
	"46011:47875:244537:238480:241031:251081:242011",
	"46011:47875:244537:238480:242913:239639:246560",
	"46011:47875:244537:238480:241031:249150",
	"46011:47875:244537:238480:241031:241036",
	"46011:47875:244537:238480:241031",
	"46011:47875:244537:238480:241031:251081",
	"46011:47875:244537:238480:241031:251073",
	"46011:47875:244537:238480:242913:239639",
	"46011:47875:244537:238480:242913",
	"46011:47875:244537:238480",
	--["name"] = "Thondroril River, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 433629293,
	["direct"] = "12596:12617:44232:43570:46011",
	["f"] = 0,
	},
	[41321] = {
	"1572:2941:352",
	"1572:2941:352:523",
	"1572:44409:44410:2299:931",
	"1572:1573",
	"41322:41323:1571",
	"1572:44409:44410:2299:931:2409",
	"41322:41325:2835",
	"1572:2941:352:2859",
	"41322:41325:2835:8018",
	"41322:41325:2835:8018:12596",
	"41322:41325:2835:43570:12617",
	"1572:44409:44410:2299",
	"1572:2941",
	"41322:41325:2835:43570:12617:44230:44233",
	"41322:41325:2835:43570:12617:44230:28621",
	"41322:41325:2835:43570:12617:44230",
	"41322:41325:2835:43570:12617:44231:44232",
	"1572:2941:352:43045",
	"41322:41325:2835:8018:12596:37888",
	"41322:41323",
	"41322:41325",
	"1572:41332",
	"1572:2941:352:42983",
	"1572:2941:352:523:42426",
	"1572:2941:352:42406",
	"1572:44409:44410:2299:931:43000",
	"1572:2941:352:43045:43042",
	"1572:2941:352:43045:43042:43043",
	"1572:44409:44410:2299:43086:43072",
	"1572:44409:44410:2299:43086:43087",
	"1572:44409:44410:2299:43086",
	"1572:44409:44410:2299:931:43088",
	"1572:44409:44410:2299:931:43371",
	"41322:41325:2835:43570",
	"1572:43702:43701",
	"1572:43702",
	"1572:2941:352:523:43697",
	"41322:41325:2835:43570:12617:44231",
	"1572:44409",
	"1572:44409:44410",
	"1572:44409:44407",
	"41322:41325:2835:8018:46006",
	"41322:41325:2835:8018:46006:46011",
	"1572:XY-2626314551",
	"1572:XY-2626314551:47147:47118",
	"1572:XY-2626314551:47147",
	"1572:XY-2626314551:47147:47154",
	"1572:XY-2626314551:47155",
	"41322:41325:2835:8018:46006:46011:47875",
	"1572:2941:47927",
	"1572:2941:47927:48318",
	"1572:2941:47927:48318:48321",
	"1572:44409:44410:2299:43086:43087:85731",
	"41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"41322:41325:2835:43570:12617:238480:241031:249150",
	"41322:41325:2835:43570:12617:238480:241031:241036",
	"41322:41325:2835:43570:12617:238480:241031",
	"41322:41325:2835:43570:12617:238480:241031:251081",
	"41322:41325:2835:43570:12617:238480:241031:251073",
	"41322:41325:2835:43570:12617:238480:242913:239639",
	"41322:41325:2835:43570:12617:238480:242913",
	"41322:41325:2835:43570:12617:238480",
	--["name"] = "Slabchisel's Survey, Wetlands",
	["m"] = 56,
	["coord"] = 2442638923,
	["direct"] = "1572:41322",
	["f"] = 0,
	},
	[41325] = {
	"41322:41321:1572:2941:352",
	"41322:41321:1572:2941:352:523",
	"41322:41321:1572:44409:44410:2299:931",
	"41323:1571:1573",
	"41323:1571",
	"41322:41321:1572",
	"41322:41321:1572:44409:44410:2299:931:2409",
	"41322:41321:1572:2941:352:2859",
	"2835:8018",
	"2835:8018:12596",
	"2835:43570:12617",
	"41322:41321:1572:44409:44410:2299",
	"41322:41321:1572:2941",
	"2835:43570:12617:44230:44233",
	"2835:43570:12617:44230:28621",
	"2835:43570:12617:44230",
	"2835:43570:12617:44231:44232",
	"41322:41321:1572:2941:352:43045",
	"2835:8018:12596:37888",
	"41322:41321",
	"41322:41321:1572:41332",
	"41322:41321:1572:2941:352:42983",
	"41322:41321:1572:2941:352:523:42426",
	"41322:41321:1572:2941:352:42406",
	"41322:41321:1572:44409:44410:2299:931:43000",
	"41322:41321:1572:2941:352:43045:43042",
	"41322:41321:1572:2941:352:43045:43042:43043",
	"41322:41321:1572:44409:44410:2299:43086:43072",
	"41322:41321:1572:44409:44410:2299:43086:43087",
	"41322:41321:1572:44409:44410:2299:43086",
	"41322:41321:1572:44409:44410:2299:931:43088",
	"41322:41321:1572:44409:44410:2299:931:43371",
	"2835:43570",
	"41323:1571:1573:43701",
	"41322:41321:1572:43702",
	"41322:41321:1572:2941:352:523:43697",
	"2835:43570:12617:44231",
	"41322:41321:1572:44409",
	"41322:41321:1572:44409:44410",
	"41322:41321:1572:44409:44407",
	"2835:8018:46006",
	"2835:8018:46006:46011",
	"41322:41321:1572:XY-2626314551",
	"41322:41321:1572:XY-2626314551:47147:47118",
	"41322:41321:1572:XY-2626314551:47147",
	"41322:41321:1572:XY-2626314551:47147:47154",
	"41322:41321:1572:XY-2626314551:47155",
	"2835:8018:46006:46011:47875",
	"41322:41321:1572:2941:47927",
	"41322:41321:1572:2941:47927:48318",
	"41322:41321:1572:2941:47927:48318:48321",
	"41322:41321:1572:44409:44410:2299:43086:43087:85731",
	"2835:43570:12617:238480:241031:251081:242011",
	"2835:43570:12617:238480:242913:239639:246560",
	"2835:43570:12617:238480:241031:249150",
	"2835:43570:12617:238480:241031:241036",
	"2835:43570:12617:238480:241031",
	"2835:43570:12617:238480:241031:251081",
	"2835:43570:12617:238480:241031:251073",
	"2835:43570:12617:238480:242913:239639",
	"2835:43570:12617:238480:242913",
	"2835:43570:12617:238480",
	--["name"] = "Dun Modr, Wetlands",
	["m"] = 56,
	["coord"] = 2146774894,
	["direct"] = "2835:41323:41322",
	["f"] = 0,
	},
	[48318] = {
	"47927:2941:352",
	"48321:2299:931:523",
	"48321:2299:931",
	"47927:2941:1573",
	"47927:2941:1573:1571",
	"47927:2941:1572",
	"48321:2299:931:2409",
	"47927:2941:1572:41321:41322:41325:2835",
	"48321:2299:931:2409:43045:2859",
	"47927:2941:1572:41321:41322:41325:2835:8018",
	"47927:2941:1573:12596",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617",
	"48321:2299",
	"47927:2941",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617:44230",
	"47927:2941:1573:12596:37888:44232",
	"48321:2299:931:2409:43045",
	"47927:2941:1573:12596:37888",
	"47927:2941:1572:41321:41322:41323",
	"47927:2941:1572:41321:41322",
	"47927:2941:1572:41321:41322:41325",
	"47927:2941:1572:41321",
	"47927:2941:1572:41332",
	"48321:2299:931:43000:42983",
	"48321:2299:931:523:42426",
	"47927:2941:352:42406",
	"48321:2299:931:43000",
	"48321:2299:931:2409:43045:43042",
	"48321:2299:931:2409:43045:43042:43043",
	"48321:2299:43086:43072",
	"48321:2299:43086:43087",
	"48321:2299:43086",
	"48321:2299:931:43088",
	"48321:2299:931:43371",
	"47927:2941:1572:41321:41322:41325:2835:43570",
	"47927:2941:1573:43701",
	"47927:2941:1572:43702",
	"48321:2299:931:2409:43697",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617:44231",
	"48321:2299:44410:44409",
	"48321:2299:44410",
	"48321:2299:44410:44407",
	"47927:2941:1573:12596:46006",
	"47927:2941:1573:12596:46011",
	"47927:2941:1572:XY-2626314551",
	"47927:2941:1572:XY-2626314551:47147:47118",
	"47927:2941:1572:XY-2626314551:47147",
	"47927:2941:1572:XY-2626314551:47147:47154",
	"47927:2941:1572:XY-2626314551:47155",
	"47927:2941:1573:12596:46011:47875",
	"48321:2299:43086:43087:85731",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"47927:2941:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Flamestar Post, Burning Steppes",
	["m"] = 36,
	["f"] = 0,
	["direct"] = "47927:48321",
	["coord"] = 768771832,
	},
	[251073] = {
	"241031:238480:244537:47875:46011:12596:1573:2941:352",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:523",
	"241031:238480:12617:44407:44410:2299:931",
	"241031:238480:244537:47875:46011:12596:1573",
	"241031:238480:12617:43570:2835:1571",
	"241031:238480:12617:43570:2835:1572",
	"241031:238480:12617:44407:44410:2299:931:2409",
	"241031:238480:12617:43570:2835",
	"241031:238480:12617:44407:44410:2299:931:2409:43045:2859",
	"241031:238480:12617:8018",
	"241031:238480:244537:47875:46011:12596",
	"241031:238480:12617",
	"241031:238480:12617:44407:44410:2299",
	"241031:238480:244537:47875:46011:12596:1573:2941",
	"241031:238480:244537:47875:44233",
	"241031:238480:12617:44230:28621",
	"241031:238480:12617:44230",
	"241031:238480:12617:44231:44232",
	"241031:238480:12617:44407:44410:2299:931:2409:43045",
	"241031:238480:244537:47875:46011:37888",
	"241031:238480:12617:43570:2835:41325:41323",
	"241031:238480:12617:43570:2835:41325:41322",
	"241031:238480:12617:43570:2835:41325",
	"241031:238480:12617:43570:2835:41325:41322:41321",
	"241031:238480:12617:43570:2835:1572:41332",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:42983",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:523:42426",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:42406",
	"241031:238480:12617:44407:44410:2299:931:43000",
	"241031:238480:12617:44407:44410:2299:931:2409:43045:43042",
	"241031:238480:12617:44407:44410:2299:931:2409:43045:43042:43043",
	"241031:238480:12617:44407:44410:2299:43086:43072",
	"241031:238480:12617:44407:44410:2299:43086:43087",
	"241031:238480:12617:44407:44410:2299:43086",
	"241031:238480:12617:44407:44410:2299:931:43088",
	"241031:238480:12617:44407:44410:2299:931:43371",
	"241031:238480:12617:43570",
	"241031:238480:244537:47875:46011:12596:1573:43701",
	"241031:238480:244537:47875:46011:12596:1573:43702",
	"241031:238480:12617:44407:44410:2299:931:2409:43697",
	"241031:238480:12617:44231",
	"241031:238480:12617:44407:44409",
	"241031:238480:12617:44407:44410",
	"241031:238480:12617:44407",
	"241031:238480:244537:47875:46011:46006",
	"241031:238480:244537:47875:46011",
	"241031:238480:12617:43570:2835:1572:XY-2626314551",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47147:47118",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47147",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47147:47154",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47155",
	"241031:238480:244537:47875",
	"241031:238480:244537:47875:46011:12596:1573:2941:47927",
	"241031:238480:244537:47875:46011:12596:1573:2941:47927:48318",
	"241031:238480:12617:44407:44410:2299:48321",
	"241031:238480:12617:44407:44410:2299:43086:43087:85731",
	"239639:246560",
	"241031:249150",
	"251081:241036",
	"241031:238480",
	--["name"] = "Witherbark Bluffs, Zul'Aman",
	["m"] = 2437,
	["f"] = 0,
	["direct"] = "242011:241031:251081:239639:242913",
	["coord"] = 1670265695,
	},
	[43000] = {
	"42983:352",
	"42983:352:523",
	"931:2299:2941:1573",
	"931:2299:44410:44409:1572:1571",
	"931:2299:44410:44409:1572",
	"931:2409",
	"931:2299:44410:44409:1572:41321:41322:41325:2835",
	"931:2409:43045:2859",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"931:2299",
	"931:2299:2941",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"931:2409:43045",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"931:2299:44410:44409:1572:41321:41322:41323",
	"931:2299:44410:44409:1572:41321:41322",
	"931:2299:44410:44409:1572:41321:41322:41325",
	"931:2299:44410:44409:1572:41321",
	"931:2299:44410:44407:41332",
	"42983:352:523:42426",
	"42983:352:42406",
	"931:2409:43045:43042",
	"931:2409:43045:43042:43043",
	"931:43371:43072",
	"931:43088:43087",
	"931:43371:43072:43086",
	"931:43088",
	"931:43371",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570",
	"931:2299:44410:44409:1572:43702:43701",
	"931:2299:44410:44409:1572:43702",
	"931:2409:43697",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"931:2299:44410:44409",
	"931:2299:44410",
	"931:2299:44410:44407",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"931:2299:44410:44409:1572:XY-2626314551",
	"931:2299:44410:44409:1572:XY-2626314551:47147:47118",
	"931:2299:44410:44409:1572:XY-2626314551:47147",
	"931:2299:44410:44409:1572:XY-2626314551:47147:47154",
	"931:2299:44410:44409:1572:XY-2626314551:47155",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"931:2299:48321:48318:47927",
	"931:2299:48321:48318",
	"931:2299:48321",
	"931:43088:43087:85731",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Eastvale Logging Camp, Elwynn",
	["m"] = 37,
	["f"] = 0,
	["direct"] = "931:42983",
	["coord"] = 3515263574,
	},
	[44409] = {
	"44410:2299:352",
	"44410:2299:931:523",
	"44410:2299:931",
	"1572:1573",
	"1572:1571",
	"44410:2299:931:2409",
	"1572:41321:41322:41325:2835",
	"44410:2299:931:2409:43045:2859",
	"1572:41321:41322:41325:2835:8018",
	"1572:41321:41322:41325:2835:8018:12596",
	"1572:41321:41322:41325:2835:43570:12617",
	"44410:2299",
	"1572:2941",
	"1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"1572:41321:41322:41325:2835:43570:12617:44230",
	"1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"44410:2299:931:2409:43045",
	"1572:41321:41322:41325:2835:8018:12596:37888",
	"1572:41321:41322:41323",
	"1572:41321:41322",
	"1572:41321:41322:41325",
	"1572:41321",
	"44407:41332",
	"44410:2299:931:43000:42983",
	"44410:2299:931:523:42426",
	"44410:2299:352:42406",
	"44410:2299:931:43000",
	"44410:2299:931:2409:43045:43042",
	"44410:2299:931:2409:43045:43042:43043",
	"44410:2299:43086:43072",
	"44410:2299:43086:43087",
	"44410:2299:43086",
	"44410:2299:931:43088",
	"44410:2299:931:43371",
	"1572:41321:41322:41325:2835:43570",
	"1572:43702:43701",
	"1572:43702",
	"44410:2299:931:2409:43697",
	"1572:41321:41322:41325:2835:43570:12617:44231",
	"1572:41321:41322:41325:2835:8018:46006",
	"1572:41321:41322:41325:2835:8018:46006:46011",
	"1572:XY-2626314551",
	"1572:XY-2626314551:47147:47118",
	"1572:XY-2626314551:47147",
	"1572:XY-2626314551:47147:47154",
	"1572:XY-2626314551:47155",
	"1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"1572:2941:47927",
	"44410:2299:48321:48318",
	"44410:2299:48321",
	"44410:2299:43086:43087:85731",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Dustwind Dig, Badlands",
	["m"] = 15,
	["coord"] = 2106940630,
	["direct"] = "1572:44410:44407",
	["f"] = 0,
	},
	[28621] = {
	"44232:37888:12596:1573:2941:352",
	"44232:37888:12596:1573:2941:352:523",
	"44230:12617:44407:44410:2299:931",
	"44232:37888:12596:1573",
	"44230:12617:43570:2835:1571",
	"44230:12617:43570:2835:1572",
	"44230:12617:44407:44410:2299:931:2409",
	"44230:12617:43570:2835",
	"44230:12617:44407:44410:2299:931:2409:43045:2859",
	"44230:12617:8018",
	"44232:37888:12596",
	"44230:12617",
	"44230:12617:44407:44410:2299",
	"44232:37888:12596:1573:2941",
	"44230:12617:44407:44410:2299:931:2409:43045",
	"44232:37888",
	"44230:12617:43570:2835:41325:41323",
	"44230:12617:43570:2835:41325:41322",
	"44230:12617:43570:2835:41325",
	"44230:12617:43570:2835:41325:41322:41321",
	"44230:12617:43570:2835:1572:41332",
	"44232:37888:12596:1573:2941:352:42983",
	"44232:37888:12596:1573:2941:352:523:42426",
	"44232:37888:12596:1573:2941:352:42406",
	"44230:12617:44407:44410:2299:931:43000",
	"44230:12617:44407:44410:2299:931:2409:43045:43042",
	"44230:12617:44407:44410:2299:931:2409:43045:43042:43043",
	"44230:12617:44407:44410:2299:43086:43072",
	"44230:12617:44407:44410:2299:43086:43087",
	"44230:12617:44407:44410:2299:43086",
	"44230:12617:44407:44410:2299:931:43088",
	"44230:12617:44407:44410:2299:931:43371",
	"44230:12617:43570",
	"44232:37888:12596:1573:43701",
	"44232:37888:12596:1573:43702",
	"44230:12617:44407:44410:2299:931:2409:43697",
	"44230:44231",
	"44230:12617:44407:44409",
	"44230:12617:44407:44410",
	"44230:12617:44407",
	"44232:37888:46011:46006",
	"44232:37888:46011",
	"44230:12617:43570:2835:1572:XY-2626314551",
	"44230:12617:43570:2835:1572:XY-2626314551:47147:47118",
	"44230:12617:43570:2835:1572:XY-2626314551:47147",
	"44230:12617:43570:2835:1572:XY-2626314551:47147:47154",
	"44230:12617:43570:2835:1572:XY-2626314551:47155",
	"44233:47875",
	"44232:37888:12596:1573:2941:47927",
	"44232:37888:12596:1573:2941:47927:48318",
	"44230:12617:44407:44410:2299:48321",
	"44230:12617:44407:44410:2299:43086:43087:85731",
	"44230:12617:238480:241031:251081:242011",
	"44230:12617:238480:242913:239639:246560",
	"44230:12617:238480:241031:249150",
	"44230:12617:238480:241031:241036",
	"44230:12617:238480:241031",
	"44230:12617:238480:241031:251081",
	"44230:12617:238480:241031:251073",
	"44230:12617:238480:242913:239639",
	"44230:12617:238480:242913",
	"44230:12617:238480",
	--["name"] = "Northpass Tower, Eastern Plaguelands",
	["m"] = 23,
	["f"] = 0,
	["direct"] = "44233:44230:44232",
	["coord"] = 2202547784,
	},
	[43290] = {
	"1573:2941:352",
	"1573:2941:352:523",
	"1573:2941:2299:931",
	"1573:1571",
	"1573:1572",
	"1573:2941:2299:931:2409",
	"1573:2835",
	"1573:2941:352:2859",
	"1573:8018",
	"1573:12596",
	"1573:12617",
	"1573:2941:2299",
	"1573:2941",
	"1573:12596:46011:47875:44233",
	"1573:12617:44230:28621",
	"1573:12617:44230",
	"1573:12596:37888:44232",
	"1573:2941:352:43045",
	"1573:12596:37888",
	"1573:1571:41323",
	"1573:1571:41323:41322",
	"1573:1571:41323:41325",
	"1573:1572:41321",
	"1573:1572:41332",
	"1573:2941:352:42983",
	"1573:2941:352:523:42426",
	"1573:2941:352:42406",
	"1573:2941:2299:931:43000",
	"1573:2941:352:43045:43042",
	"1573:2941:352:43045:43042:43043",
	"1573:2941:2299:43086:43072",
	"1573:2941:2299:43086:43087",
	"1573:2941:2299:43086",
	"1573:2941:2299:931:43088",
	"1573:2941:2299:931:43371",
	"1573:2835:43570",
	"1573:43701",
	"1573:43702",
	"1573:2941:352:523:43697",
	"1573:12617:44231",
	"1573:1572:44409",
	"1573:1572:44409:44410",
	"1573:1572:44409:44407",
	"1573:12596:46006",
	"1573:12596:46011",
	"1573:1572:XY-2626314551",
	"1573:1572:XY-2626314551:47147:47118",
	"1573:1572:XY-2626314551:47147",
	"1573:1572:XY-2626314551:47147:47154",
	"1573:1572:XY-2626314551:47155",
	"1573:12596:46011:47875",
	"1573:2941:47927",
	"1573:2941:47927:48318",
	"1573:2941:47927:48318:48321",
	"1573:2941:2299:43086:43087:85731",
	"1573:12617:238480:241031:251081:242011",
	"1573:12617:238480:242913:239639:246560",
	"1573:12617:238480:241031:249150",
	"1573:12617:238480:241031:241036",
	"1573:12617:238480:241031",
	"1573:12617:238480:241031:251081",
	"1573:12617:238480:241031:251073",
	"1573:12617:238480:242913:239639",
	"1573:12617:238480:242913",
	"1573:12617:238480",
	--["name"] = "Sandy Beach, Vashj'ir",
	["direct"] = "1573",
	["coord"] = 2450664415,
	["m"] = 205,
	["f"] = 0,
	},
	[8018] = {
	"2835:1572:2941:352",
	"2835:1572:2941:352:523",
	"2835:1572:44409:44410:2299:931",
	"2835:1571",
	"2835:1572",
	"2835:1572:44409:44410:2299:931:2409",
	"2835:1572:2941:352:2859",
	"2835:1572:44409:44410:2299",
	"2835:1572:2941",
	"46006:46011:47875:44233",
	"12617:44230:28621",
	"12617:44230",
	"12596:37888:44232",
	"2835:1572:2941:352:43045",
	"12596:37888",
	"2835:41325:41323",
	"2835:41325:41322",
	"2835:41325",
	"2835:41325:41322:41321",
	"2835:1572:41332",
	"2835:1572:2941:352:42983",
	"2835:1572:2941:352:523:42426",
	"2835:1572:2941:352:42406",
	"2835:1572:44409:44410:2299:931:43000",
	"2835:1572:2941:352:43045:43042",
	"2835:1572:2941:352:43045:43042:43043",
	"2835:1572:44409:44410:2299:43086:43072",
	"2835:1572:44409:44410:2299:43086:43087",
	"2835:1572:44409:44410:2299:43086",
	"2835:1572:44409:44410:2299:931:43088",
	"2835:1572:44409:44410:2299:931:43371",
	"1573:43701",
	"2835:1572:43702",
	"2835:1572:2941:352:523:43697",
	"12617:44231",
	"2835:1572:44409",
	"2835:1572:44409:44410",
	"2835:1572:44409:44407",
	"46006:46011",
	"2835:1572:XY-2626314551",
	"2835:1572:XY-2626314551:47147:47118",
	"2835:1572:XY-2626314551:47147",
	"2835:1572:XY-2626314551:47147:47154",
	"2835:1572:XY-2626314551:47155",
	"46006:46011:47875",
	"2835:1572:2941:47927",
	"2835:1572:2941:47927:48318",
	"2835:1572:2941:47927:48318:48321",
	"2835:1572:44409:44410:2299:43086:43087:85731",
	"46006:46011:47875:244537:238480:241031:251081:242011",
	"46006:46011:47875:244537:238480:242913:239639:246560",
	"46006:46011:47875:244537:238480:241031:249150",
	"46006:46011:47875:244537:238480:241031:241036",
	"46006:46011:47875:244537:238480:241031",
	"46006:46011:47875:244537:238480:241031:251081",
	"46006:46011:47875:244537:238480:241031:251073",
	"46006:46011:47875:244537:238480:242913:239639",
	"46006:46011:47875:244537:238480:242913",
	"46006:46011:47875:244537:238480",
	--["name"] = "Aerie Peak, The Hinterlands",
	["m"] = 26,
	["coord"] = 477263357,
	["direct"] = "1573:2835:12596:12617:43570:46006",
	["f"] = 0,
	},
	[43072] = {
	"43371:931:352",
	"43371:931:523",
	"43371:931",
	"43371:931:2299:2941:1573",
	"43371:931:2299:44410:44409:1572:1571",
	"43371:931:2299:44410:44409:1572",
	"43371:931:2409",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835",
	"43371:931:2409:43045:2859",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:8018",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"43371:931:2299",
	"43371:931:2299:2941",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"43371:931:2409:43045",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"43371:931:2299:44410:44409:1572:41321:41322:41323",
	"43371:931:2299:44410:44409:1572:41321:41322",
	"43371:931:2299:44410:44409:1572:41321:41322:41325",
	"43371:931:2299:44410:44409:1572:41321",
	"43371:931:2299:44410:44407:41332",
	"43371:931:43000:42983",
	"43371:931:523:42426",
	"43371:931:352:42406",
	"43371:931:43000",
	"43371:931:2409:43045:43042",
	"43371:931:2409:43045:43042:43043",
	"43086:43087",
	"43371:931:43088",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570",
	"43371:931:2299:44410:44409:1572:43702:43701",
	"43371:931:2299:44410:44409:1572:43702",
	"43371:931:2409:43697",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"43371:931:2299:44410:44409",
	"43371:931:2299:44410",
	"43371:931:2299:44410:44407",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"43371:931:2299:44410:44409:1572:XY-2626314551",
	"43371:931:2299:44410:44409:1572:XY-2626314551:47147:47118",
	"43371:931:2299:44410:44409:1572:XY-2626314551:47147",
	"43371:931:2299:44410:44409:1572:XY-2626314551:47147:47154",
	"43371:931:2299:44410:44409:1572:XY-2626314551:47155",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"43371:931:2299:48321:48318:47927",
	"43371:931:2299:48321:48318",
	"43371:931:2299:48321",
	"43086:43087:85731",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Shalewind Canyon, Redridge",
	["m"] = 49,
	["f"] = 0,
	["direct"] = "43086:43371",
	["coord"] = 3345262790,
	},
	[242011] = {
	"251081:241031:238480:244537:47875:46011:12596:1573:2941:352",
	"251081:241031:238480:244537:47875:46011:12596:1573:2941:352:523",
	"251081:241031:238480:12617:44407:44410:2299:931",
	"251081:241031:238480:244537:47875:46011:12596:1573",
	"251081:241031:238480:12617:43570:2835:1571",
	"251081:241031:238480:12617:43570:2835:1572",
	"251081:241031:238480:12617:44407:44410:2299:931:2409",
	"251081:241031:238480:12617:43570:2835",
	"251081:241031:238480:12617:44407:44410:2299:931:2409:43045:2859",
	"251081:241031:238480:12617:8018",
	"251081:241031:238480:244537:47875:46011:12596",
	"251081:241031:238480:12617",
	"251081:241031:238480:12617:44407:44410:2299",
	"251081:241031:238480:244537:47875:46011:12596:1573:2941",
	"251081:241031:238480:244537:47875:44233",
	"251081:241031:238480:12617:44230:28621",
	"251081:241031:238480:12617:44230",
	"251081:241031:238480:12617:44231:44232",
	"251081:241031:238480:12617:44407:44410:2299:931:2409:43045",
	"251081:241031:238480:244537:47875:46011:37888",
	"251081:241031:238480:12617:43570:2835:41325:41323",
	"251081:241031:238480:12617:43570:2835:41325:41322",
	"251081:241031:238480:12617:43570:2835:41325",
	"251081:241031:238480:12617:43570:2835:41325:41322:41321",
	"251081:241031:238480:12617:43570:2835:1572:41332",
	"251081:241031:238480:244537:47875:46011:12596:1573:2941:352:42983",
	"251081:241031:238480:244537:47875:46011:12596:1573:2941:352:523:42426",
	"251081:241031:238480:244537:47875:46011:12596:1573:2941:352:42406",
	"251081:241031:238480:12617:44407:44410:2299:931:43000",
	"251081:241031:238480:12617:44407:44410:2299:931:2409:43045:43042",
	"251081:241031:238480:12617:44407:44410:2299:931:2409:43045:43042:43043",
	"251081:241031:238480:12617:44407:44410:2299:43086:43072",
	"251081:241031:238480:12617:44407:44410:2299:43086:43087",
	"251081:241031:238480:12617:44407:44410:2299:43086",
	"251081:241031:238480:12617:44407:44410:2299:931:43088",
	"251081:241031:238480:12617:44407:44410:2299:931:43371",
	"251081:241031:238480:12617:43570",
	"251081:241031:238480:244537:47875:46011:12596:1573:43701",
	"251081:241031:238480:244537:47875:46011:12596:1573:43702",
	"251081:241031:238480:12617:44407:44410:2299:931:2409:43697",
	"251081:241031:238480:12617:44231",
	"251081:241031:238480:12617:44407:44409",
	"251081:241031:238480:12617:44407:44410",
	"251081:241031:238480:12617:44407",
	"251081:241031:238480:244537:47875:46011:46006",
	"251081:241031:238480:244537:47875:46011",
	"251081:241031:238480:12617:43570:2835:1572:XY-2626314551",
	"251081:241031:238480:12617:43570:2835:1572:XY-2626314551:47147:47118",
	"251081:241031:238480:12617:43570:2835:1572:XY-2626314551:47147",
	"251081:241031:238480:12617:43570:2835:1572:XY-2626314551:47147:47154",
	"251081:241031:238480:12617:43570:2835:1572:XY-2626314551:47155",
	"251081:241031:238480:244537:47875",
	"251081:241031:238480:244537:47875:46011:12596:1573:2941:47927",
	"251081:241031:238480:244537:47875:46011:12596:1573:2941:47927:48318",
	"251081:241031:238480:12617:44407:44410:2299:48321",
	"251081:241031:238480:12617:44407:44410:2299:43086:43087:85731",
	"251073:239639:246560",
	"251081:241031:249150",
	"251081:241036",
	"251081:241031",
	"251073:239639",
	"251073:242913",
	"251081:241031:238480",
	--["name"] = "Camp Stonewash, Zul'Aman",
	["m"] = 2437,
	["f"] = 0,
	["direct"] = "251081:251073",
	["coord"] = 2030715212,
	},
	[43088] = {
	"931:352",
	"931:523",
	"931:2299:2941:1573",
	"931:2299:44410:44409:1572:1571",
	"931:2299:44410:44409:1572",
	"931:2409",
	"931:2299:44410:44409:1572:41321:41322:41325:2835",
	"931:2409:43045:2859",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"931:2299",
	"931:2299:2941",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"931:2409:43045",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"931:2299:44410:44409:1572:41321:41322:41323",
	"931:2299:44410:44409:1572:41321:41322",
	"931:2299:44410:44409:1572:41321:41322:41325",
	"931:2299:44410:44409:1572:41321",
	"931:2299:44410:44407:41332",
	"931:43000:42983",
	"931:523:42426",
	"931:352:42406",
	"931:43000",
	"931:2409:43045:43042",
	"931:2409:43045:43042:43043",
	"931:43371:43072",
	"43087:43086",
	"931:43371",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570",
	"931:2299:44410:44409:1572:43702:43701",
	"931:2299:44410:44409:1572:43702",
	"931:2409:43697",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"931:2299:44410:44409",
	"931:2299:44410",
	"931:2299:44410:44407",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"931:2299:44410:44409:1572:XY-2626314551",
	"931:2299:44410:44409:1572:XY-2626314551:47147:47118",
	"931:2299:44410:44409:1572:XY-2626314551:47147",
	"931:2299:44410:44409:1572:XY-2626314551:47147:47154",
	"931:2299:44410:44409:1572:XY-2626314551:47155",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"931:2299:48321:48318:47927",
	"931:2299:48321:48318",
	"931:2299:48321",
	"43087:85731",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "The Harborage, Swamp of Sorrows",
	["m"] = 51,
	["f"] = 0,
	["direct"] = "931:43087",
	["coord"] = 1321425042,
	},
	[41322] = {
	"41321:1572:2941:352",
	"41321:1572:2941:352:523",
	"41321:1572:44409:44410:2299:931",
	"41323:1571:1573",
	"41323:1571",
	"41321:1572",
	"41321:1572:44409:44410:2299:931:2409",
	"41325:2835",
	"41321:1572:2941:352:2859",
	"41325:2835:8018",
	"41325:2835:8018:12596",
	"41325:2835:43570:12617",
	"41321:1572:44409:44410:2299",
	"41321:1572:2941",
	"41325:2835:43570:12617:44230:44233",
	"41325:2835:43570:12617:44230:28621",
	"41325:2835:43570:12617:44230",
	"41325:2835:43570:12617:44231:44232",
	"41321:1572:2941:352:43045",
	"41325:2835:8018:12596:37888",
	"41321:1572:41332",
	"41321:1572:2941:352:42983",
	"41321:1572:2941:352:523:42426",
	"41321:1572:2941:352:42406",
	"41321:1572:44409:44410:2299:931:43000",
	"41321:1572:2941:352:43045:43042",
	"41321:1572:2941:352:43045:43042:43043",
	"41321:1572:44409:44410:2299:43086:43072",
	"41321:1572:44409:44410:2299:43086:43087",
	"41321:1572:44409:44410:2299:43086",
	"41321:1572:44409:44410:2299:931:43088",
	"41321:1572:44409:44410:2299:931:43371",
	"41325:2835:43570",
	"41321:1572:43702:43701",
	"41321:1572:43702",
	"41321:1572:2941:352:523:43697",
	"41325:2835:43570:12617:44231",
	"41321:1572:44409",
	"41321:1572:44409:44410",
	"41321:1572:44409:44407",
	"41325:2835:8018:46006",
	"41325:2835:8018:46006:46011",
	"41321:1572:XY-2626314551",
	"41321:1572:XY-2626314551:47147:47118",
	"41321:1572:XY-2626314551:47147",
	"41321:1572:XY-2626314551:47147:47154",
	"41321:1572:XY-2626314551:47155",
	"41325:2835:8018:46006:46011:47875",
	"41321:1572:2941:47927",
	"41321:1572:2941:47927:48318",
	"41321:1572:2941:47927:48318:48321",
	"41321:1572:44409:44410:2299:43086:43087:85731",
	"41325:2835:43570:12617:238480:241031:251081:242011",
	"41325:2835:43570:12617:238480:242913:239639:246560",
	"41325:2835:43570:12617:238480:241031:249150",
	"41325:2835:43570:12617:238480:241031:241036",
	"41325:2835:43570:12617:238480:241031",
	"41325:2835:43570:12617:238480:241031:251081",
	"41325:2835:43570:12617:238480:241031:251073",
	"41325:2835:43570:12617:238480:242913:239639",
	"41325:2835:43570:12617:238480:242913",
	"41325:2835:43570:12617:238480",
	--["name"] = "Greenwarden's Grove, Wetlands",
	["m"] = 56,
	["coord"] = 2418961312,
	["direct"] = "41323:41325:41321",
	["f"] = 0,
	},
	[2409] = {
	"931:2299:2941:1573",
	"931:2299:44410:44409:1572:1571",
	"931:2299:44410:44409:1572",
	"931:2299:44410:44409:1572:41321:41322:41325:2835",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"931:2299",
	"931:2299:2941",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"931:2299:44410:44409:1572:41321:41322:41323",
	"931:2299:44410:44409:1572:41321:41322",
	"931:2299:44410:44409:1572:41321:41322:41325",
	"931:2299:44410:44409:1572:41321",
	"931:2299:44410:44407:41332",
	"523:42426",
	"523:42406",
	"931:43000",
	"43045:43042",
	"43045:43042:43043",
	"931:43371:43072",
	"85731:43087",
	"931:43371:43072:43086",
	"931:43088",
	"931:43371",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570",
	"931:2299:44410:44409:1572:43702:43701",
	"931:2299:44410:44409:1572:43702",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"931:2299:44410:44409",
	"931:2299:44410",
	"931:2299:44410:44407",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"931:2299:44410:44409:1572:XY-2626314551",
	"931:2299:44410:44409:1572:XY-2626314551:47147:47118",
	"931:2299:44410:44409:1572:XY-2626314551:47147",
	"931:2299:44410:44409:1572:XY-2626314551:47147:47154",
	"931:2299:44410:44409:1572:XY-2626314551:47155",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"931:2299:48321:48318:47927",
	"931:2299:48321:48318",
	"931:2299:48321",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Darkshire, Duskwood",
	["m"] = 47,
	["f"] = 0,
	["direct"] = "352:523:931:2859:43045:42983:43697:85731",
	["coord"] = 3332927808,
	},
	[523] = {
	"352:1573",
	"352:1573:1571",
	"352:2941:1572",
	"352:2941:1572:41321:41322:41325:2835",
	"352:2941:1572:41321:41322:41325:2835:8018",
	"352:1573:12596",
	"352:2941:1572:41321:41322:41325:2835:43570:12617",
	"931:2299",
	"352:2941",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:44230",
	"352:1573:12596:37888:44232",
	"352:1573:12596:37888",
	"352:2941:1572:41321:41322:41323",
	"352:2941:1572:41321:41322",
	"352:2941:1572:41321:41322:41325",
	"352:2941:1572:41321",
	"931:2299:44410:44407:41332",
	"352:42983",
	"931:43000",
	"43045:43042",
	"43045:43042:43043",
	"931:43371:43072",
	"931:43088:43087",
	"931:43371:43072:43086",
	"931:43088",
	"931:43371",
	"352:2941:1572:41321:41322:41325:2835:43570",
	"352:1573:43701",
	"352:2941:1572:43702",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:44231",
	"931:2299:44410:44409",
	"931:2299:44410",
	"931:2299:44410:44407",
	"352:1573:12596:46006",
	"352:1573:12596:46011",
	"352:2941:1572:XY-2626314551",
	"352:2941:1572:XY-2626314551:47147:47118",
	"352:2941:1572:XY-2626314551:47147",
	"352:2941:1572:XY-2626314551:47147:47154",
	"352:2941:1572:XY-2626314551:47155",
	"352:1573:12596:46011:47875",
	"352:2941:47927",
	"931:2299:48321:48318",
	"931:2299:48321",
	"43697:2409:85731",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Sentinel Hill, Westfall",
	["m"] = 52,
	["f"] = 0,
	["direct"] = "352:931:2409:2859:43045:42426:42406:43697",
	["coord"] = 2432532065,
	},
	[244537] = {
	"47875:46011:12596:1573:2941:352",
	"47875:46011:12596:1573:2941:352:523",
	"47875:46011:12596:1573:2941:2299:931",
	"47875:46011:12596:1573",
	"47875:46011:46006:8018:2835:1571",
	"47875:46011:46006:8018:2835:1572",
	"47875:46011:12596:1573:2941:2299:931:2409",
	"47875:46011:46006:8018:2835",
	"47875:46011:12596:1573:2941:352:2859",
	"47875:46011:46006:8018",
	"47875:46011:12596",
	"47875:44233:44230:12617",
	"47875:46011:12596:1573:2941:2299",
	"47875:46011:12596:1573:2941",
	"47875:44233",
	"47875:44233:28621",
	"47875:44233:44230",
	"47875:44233:44232",
	"47875:46011:12596:1573:2941:352:43045",
	"47875:46011:37888",
	"47875:46011:46006:8018:2835:41325:41323",
	"47875:46011:46006:8018:2835:41325:41322",
	"47875:46011:46006:8018:2835:41325",
	"47875:46011:46006:8018:2835:41325:41322:41321",
	"47875:46011:46006:8018:2835:1572:41332",
	"47875:46011:12596:1573:2941:352:42983",
	"47875:46011:12596:1573:2941:352:523:42426",
	"47875:46011:12596:1573:2941:352:42406",
	"47875:46011:12596:1573:2941:2299:931:43000",
	"47875:46011:12596:1573:2941:352:43045:43042",
	"47875:46011:12596:1573:2941:352:43045:43042:43043",
	"47875:46011:12596:1573:2941:2299:43086:43072",
	"47875:46011:12596:1573:2941:2299:43086:43087",
	"47875:46011:12596:1573:2941:2299:43086",
	"47875:46011:12596:1573:2941:2299:931:43088",
	"47875:46011:12596:1573:43290",
	"47875:46011:12596:1573:2941:2299:931:43371",
	"47875:46011:37888:43570",
	"47875:46011:12596:1573:43701",
	"47875:46011:12596:1573:43702",
	"47875:46011:12596:1573:2941:352:523:43697",
	"47875:44233:44231",
	"47875:46011:46006:8018:2835:1572:44409",
	"47875:46011:46006:8018:2835:1572:44409:44410",
	"47875:46011:46006:8018:2835:1572:44409:44407",
	"47875:46011:46006",
	"47875:46011",
	"47875:46011:46006:8018:2835:1572:XY-2626314551",
	"47875:46011:46006:8018:2835:1572:XY-2626314551:47147:47118",
	"47875:46011:46006:8018:2835:1572:XY-2626314551:47147",
	"47875:46011:46006:8018:2835:1572:XY-2626314551:47147:47154",
	"47875:46011:46006:8018:2835:1572:XY-2626314551:47155",
	"47875:46011:12596:1573:2941:47927",
	"47875:46011:12596:1573:2941:47927:48318",
	"47875:46011:12596:1573:2941:47927:48318:48321",
	"47875:46011:12596:1573:2941:2299:43086:43087:85731",
	"238480:241031:251081:242011",
	"238480:242913:239639:246560",
	"238480:241031:249150",
	"238480:241031:241036",
	"238480:241031",
	"238480:241031:251081",
	"238480:241031:251073",
	"238480:242913:239639",
	"238480:242913",
	["m"] = 2395,
	["f"] = 0,
	["direct"] = "47875:238480",
	["coord"] = 1332602507,
	},
	[44410] = {
	"2299:352",
	"2299:931:523",
	"2299:931",
	"44409:1572:1573",
	"44409:1572:1571",
	"44409:1572",
	"2299:931:2409",
	"44409:1572:41321:41322:41325:2835",
	"2299:931:2409:43045:2859",
	"44409:1572:41321:41322:41325:2835:8018",
	"44409:1572:41321:41322:41325:2835:8018:12596",
	"44409:1572:41321:41322:41325:2835:43570:12617",
	"2299:2941",
	"44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"2299:931:2409:43045",
	"44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"44409:1572:41321:41322:41323",
	"44409:1572:41321:41322",
	"44409:1572:41321:41322:41325",
	"44409:1572:41321",
	"44407:41332",
	"2299:931:43000:42983",
	"2299:931:523:42426",
	"2299:352:42406",
	"2299:931:43000",
	"2299:931:2409:43045:43042",
	"2299:931:2409:43045:43042:43043",
	"2299:43086:43072",
	"2299:43086:43087",
	"2299:43086",
	"2299:931:43088",
	"2299:931:43371",
	"44409:1572:41321:41322:41325:2835:43570",
	"44409:1572:43702:43701",
	"44409:1572:43702",
	"2299:931:2409:43697",
	"44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"44409:1572:41321:41322:41325:2835:8018:46006",
	"44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"44409:1572:XY-2626314551",
	"44409:1572:XY-2626314551:47147:47118",
	"44409:1572:XY-2626314551:47147",
	"44409:1572:XY-2626314551:47147:47154",
	"44409:1572:XY-2626314551:47155",
	"44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"2299:48321:48318:47927",
	"2299:48321:48318",
	"2299:48321",
	"2299:43086:43087:85731",
	"44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Dragon's Mouth, Badlands",
	["m"] = 15,
	["coord"] = 935171033,
	["direct"] = "2299:44409:44407",
	["f"] = 0,
	},
	[42406] = {
	"523:931",
	"352:1573",
	"352:1573:1571",
	"352:2941:1572",
	"523:43697:2409",
	"352:2941:1572:41321:41322:41325:2835",
	"523:2859",
	"352:2941:1572:41321:41322:41325:2835:8018",
	"352:1573:12596",
	"352:2941:1572:41321:41322:41325:2835:43570:12617",
	"352:2299",
	"352:2941",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:44230",
	"352:1573:12596:37888:44232",
	"523:43045",
	"352:1573:12596:37888",
	"352:2941:1572:41321:41322:41323",
	"352:2941:1572:41321:41322",
	"352:2941:1572:41321:41322:41325",
	"352:2941:1572:41321",
	"352:2941:1572:41332",
	"352:42983",
	"523:42426",
	"352:42983:43000",
	"523:43045:43042",
	"523:43045:43042:43043",
	"523:931:43371:43072",
	"523:931:43088:43087",
	"523:931:43371:43072:43086",
	"523:931:43088",
	"523:931:43371",
	"352:2941:1572:41321:41322:41325:2835:43570",
	"352:1573:43701",
	"352:2941:1572:43702",
	"523:43697",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:44231",
	"352:2299:44410:44409",
	"352:2299:44410",
	"352:2299:44410:44407",
	"352:1573:12596:46006",
	"352:1573:12596:46011",
	"352:2941:1572:XY-2626314551",
	"352:2941:1572:XY-2626314551:47147:47118",
	"352:2941:1572:XY-2626314551:47147",
	"352:2941:1572:XY-2626314551:47147:47154",
	"352:2941:1572:XY-2626314551:47155",
	"352:1573:12596:46011:47875",
	"352:2941:47927",
	"352:2299:48321:48318",
	"352:2299:48321",
	"523:43697:2409:85731",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Furlbrow's Pumpkin Farm, Westfall",
	["m"] = 52,
	["f"] = 0,
	["direct"] = "352:523",
	["coord"] = 2138583068,
	},
	[43045] = {
	"2409:931",
	"352:1573",
	"352:1573:1571",
	"2409:931:2299:44410:44409:1572",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"2409:931:2299",
	"352:2941",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"2409:931:2299:44410:44409:1572:41321:41322:41323",
	"2409:931:2299:44410:44409:1572:41321:41322",
	"2409:931:2299:44410:44409:1572:41321:41322:41325",
	"2409:931:2299:44410:44409:1572:41321",
	"2409:931:2299:44410:44407:41332",
	"2409:42983",
	"523:42426",
	"523:42406",
	"2409:931:43000",
	"43042:43043",
	"2409:931:43371:43072",
	"85731:43087",
	"2409:931:43371:43072:43086",
	"2409:931:43088",
	"2409:931:43371",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570",
	"352:1573:43701",
	"2409:931:2299:44410:44409:1572:43702",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"2409:931:2299:44410:44409",
	"2409:931:2299:44410",
	"2409:931:2299:44410:44407",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"2409:931:2299:44410:44409:1572:XY-2626314551",
	"2409:931:2299:44410:44409:1572:XY-2626314551:47147:47118",
	"2409:931:2299:44410:44409:1572:XY-2626314551:47147",
	"2409:931:2299:44410:44409:1572:XY-2626314551:47147:47154",
	"2409:931:2299:44410:44409:1572:XY-2626314551:47155",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"2409:931:2299:48321:48318:47927",
	"2409:931:2299:48321:48318",
	"2409:931:2299:48321",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Rebel Camp, Stranglethorn Vale",
	["m"] = 50,
	["f"] = 0,
	["direct"] = "352:523:2409:2859:43042:43697:85731",
	["coord"] = 2054168210,
	},
	[47875] = {
	"46011:12596:1573:2941:352",
	"46011:12596:1573:2941:352:523",
	"46011:12596:1573:2941:2299:931",
	"46011:12596:1573",
	"46011:46006:8018:2835:1571",
	"46011:46006:8018:2835:1572",
	"46011:12596:1573:2941:2299:931:2409",
	"46011:46006:8018:2835",
	"46011:12596:1573:2941:352:2859",
	"46011:46006:8018",
	"46011:12596",
	"44233:44230:12617",
	"46011:12596:1573:2941:2299",
	"46011:12596:1573:2941",
	"44233:28621",
	"44233:44230",
	"44233:44232",
	"46011:12596:1573:2941:352:43045",
	"46011:37888",
	"46011:46006:8018:2835:41325:41323",
	"46011:46006:8018:2835:41325:41322",
	"46011:46006:8018:2835:41325",
	"46011:46006:8018:2835:41325:41322:41321",
	"46011:46006:8018:2835:1572:41332",
	"46011:12596:1573:2941:352:42983",
	"46011:12596:1573:2941:352:523:42426",
	"46011:12596:1573:2941:352:42406",
	"46011:12596:1573:2941:2299:931:43000",
	"46011:12596:1573:2941:352:43045:43042",
	"46011:12596:1573:2941:352:43045:43042:43043",
	"46011:12596:1573:2941:2299:43086:43072",
	"46011:12596:1573:2941:2299:43086:43087",
	"46011:12596:1573:2941:2299:43086",
	"46011:12596:1573:2941:2299:931:43088",
	"46011:12596:1573:2941:2299:931:43371",
	"46011:37888:43570",
	"46011:12596:1573:43701",
	"46011:12596:1573:43702",
	"46011:12596:1573:2941:352:523:43697",
	"44233:44231",
	"46011:46006:8018:2835:1572:44409",
	"46011:46006:8018:2835:1572:44409:44410",
	"46011:46006:8018:2835:1572:44409:44407",
	"46011:46006",
	"46011:46006:8018:2835:1572:XY-2626314551",
	"46011:46006:8018:2835:1572:XY-2626314551:47147:47118",
	"46011:46006:8018:2835:1572:XY-2626314551:47147",
	"46011:46006:8018:2835:1572:XY-2626314551:47147:47154",
	"46011:46006:8018:2835:1572:XY-2626314551:47155",
	"46011:12596:1573:2941:47927",
	"46011:12596:1573:2941:47927:48318",
	"46011:12596:1573:2941:47927:48318:48321",
	"46011:12596:1573:2941:2299:43086:43087:85731",
	"244537:238480:241031:251081:242011",
	"244537:238480:242913:239639:246560",
	"244537:238480:241031:249150",
	"244537:238480:241031:241036",
	"244537:238480:241031",
	"244537:238480:241031:251081",
	"244537:238480:241031:251073",
	"244537:238480:242913:239639",
	"244537:238480:242913",
	"244537:238480",
	--["name"] = "Hearthglen, Western Plaguelands",
	["m"] = 22,
	["coord"] = 1914908428,
	["direct"] = "44233:46011",
	["f"] = 0,
	},
	[42426] = {
	"523:352",
	"523:931",
	"523:352:1573",
	"523:352:1573:1571",
	"523:352:2941:1572",
	"523:43697:2409",
	"523:352:2941:1572:41321:41322:41325:2835",
	"523:2859",
	"523:352:2941:1572:41321:41322:41325:2835:8018",
	"523:352:1573:12596",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617",
	"523:931:2299",
	"523:352:2941",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617:44230",
	"523:352:1573:12596:37888:44232",
	"523:43045",
	"523:352:1573:12596:37888",
	"523:352:2941:1572:41321:41322:41323",
	"523:352:2941:1572:41321:41322",
	"523:352:2941:1572:41321:41322:41325",
	"523:352:2941:1572:41321",
	"523:931:2299:44410:44407:41332",
	"523:352:42983",
	"523:42406",
	"523:931:43000",
	"523:43045:43042",
	"523:43045:43042:43043",
	"523:931:43371:43072",
	"523:931:43088:43087",
	"523:931:43371:43072:43086",
	"523:931:43088",
	"523:931:43371",
	"523:352:2941:1572:41321:41322:41325:2835:43570",
	"523:352:1573:43701",
	"523:352:2941:1572:43702",
	"523:43697",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617:44231",
	"523:931:2299:44410:44409",
	"523:931:2299:44410",
	"523:931:2299:44410:44407",
	"523:352:1573:12596:46006",
	"523:352:1573:12596:46011",
	"523:352:2941:1572:XY-2626314551",
	"523:352:2941:1572:XY-2626314551:47147:47118",
	"523:352:2941:1572:XY-2626314551:47147",
	"523:352:2941:1572:XY-2626314551:47147:47154",
	"523:352:2941:1572:XY-2626314551:47155",
	"523:352:1573:12596:46011:47875",
	"523:352:2941:47927",
	"523:931:2299:48321:48318",
	"523:931:2299:48321",
	"523:43697:2409:85731",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"523:352:2941:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Moonbrook, Westfall",
	["m"] = 52,
	["f"] = 0,
	["direct"] = "523",
	["coord"] = 1808507402,
	},
	[2859] = {
	"43045:2409:931",
	"352:1573",
	"352:1573:1571",
	"43045:2409:931:2299:44410:44409:1572",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018",
	"352:1573:12596",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"43045:2409:931:2299",
	"352:2941",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"352:1573:12596:37888",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41323",
	"43045:2409:931:2299:44410:44409:1572:41321:41322",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325",
	"43045:2409:931:2299:44410:44409:1572:41321",
	"43045:2409:931:2299:44410:44407:41332",
	"43045:2409:42983",
	"523:42426",
	"523:42406",
	"43045:2409:931:43000",
	"43043:43042",
	"43045:2409:931:43371:43072",
	"43045:85731:43087",
	"43045:2409:931:43371:43072:43086",
	"43045:2409:931:43088",
	"43045:2409:931:43371",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570",
	"352:1573:43701",
	"43045:2409:931:2299:44410:44409:1572:43702",
	"43045:43697",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"43045:2409:931:2299:44410:44409",
	"43045:2409:931:2299:44410",
	"43045:2409:931:2299:44410:44407",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"352:1573:12596:46011",
	"43045:2409:931:2299:44410:44409:1572:XY-2626314551",
	"43045:2409:931:2299:44410:44409:1572:XY-2626314551:47147:47118",
	"43045:2409:931:2299:44410:44409:1572:XY-2626314551:47147",
	"43045:2409:931:2299:44410:44409:1572:XY-2626314551:47147:47154",
	"43045:2409:931:2299:44410:44409:1572:XY-2626314551:47155",
	"352:1573:12596:46011:47875",
	"352:2941:47927",
	"43045:2409:931:2299:48321:48318",
	"43045:2409:931:2299:48321",
	"43045:85731",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Booty Bay, Stranglethorn",
	["m"] = 210,
	["f"] = 0,
	["direct"] = "352:523:2409:43045:43043",
	["coord"] = 1789640278,
	},
	[46006] = {
	"12596:1573:2941:352",
	"12596:1573:2941:352:523",
	"12596:1573:2941:2299:931",
	"12596:1573",
	"8018:2835:1571",
	"8018:2835:1572",
	"12596:1573:2941:2299:931:2409",
	"8018:2835",
	"12596:1573:2941:352:2859",
	"46011:37888:12617",
	"12596:1573:2941:2299",
	"12596:1573:2941",
	"46011:47875:44233",
	"46011:37888:44232:28621",
	"46011:37888:44232:44231:44230",
	"46011:37888:44232",
	"12596:1573:2941:352:43045",
	"46011:37888",
	"8018:2835:41325:41323",
	"8018:2835:41325:41322",
	"8018:2835:41325",
	"8018:2835:41325:41322:41321",
	"8018:2835:1572:41332",
	"12596:1573:2941:352:42983",
	"12596:1573:2941:352:523:42426",
	"12596:1573:2941:352:42406",
	"12596:1573:2941:2299:931:43000",
	"12596:1573:2941:352:43045:43042",
	"12596:1573:2941:352:43045:43042:43043",
	"12596:1573:2941:2299:43086:43072",
	"12596:1573:2941:2299:43086:43087",
	"12596:1573:2941:2299:43086",
	"12596:1573:2941:2299:931:43088",
	"12596:1573:2941:2299:931:43371",
	"8018:43570",
	"12596:1573:43701",
	"12596:1573:43702",
	"12596:1573:2941:352:523:43697",
	"46011:37888:44232:44231",
	"8018:2835:1572:44409",
	"8018:2835:1572:44409:44410",
	"8018:2835:1572:44409:44407",
	"8018:2835:1572:XY-2626314551",
	"8018:2835:1572:XY-2626314551:47147:47118",
	"8018:2835:1572:XY-2626314551:47147",
	"8018:2835:1572:XY-2626314551:47147:47154",
	"8018:2835:1572:XY-2626314551:47155",
	"46011:47875",
	"12596:1573:2941:47927",
	"12596:1573:2941:47927:48318",
	"12596:1573:2941:47927:48318:48321",
	"12596:1573:2941:2299:43086:43087:85731",
	"46011:47875:244537:238480:241031:251081:242011",
	"46011:47875:244537:238480:242913:239639:246560",
	"46011:47875:244537:238480:241031:249150",
	"46011:47875:244537:238480:241031:241036",
	"46011:47875:244537:238480:241031",
	"46011:47875:244537:238480:241031:251081",
	"46011:47875:244537:238480:241031:251073",
	"46011:47875:244537:238480:242913:239639",
	"46011:47875:244537:238480:242913",
	"46011:47875:244537:238480",
	--["name"] = "Andorhal, Western Plaguelands",
	["m"] = 22,
	["coord"] = 1695592908,
	["direct"] = "8018:12596:46011",
	["f"] = 0,
	},
	[44232] = {
	"37888:12596:1573:2941:352",
	"37888:12596:1573:2941:352:523",
	"37888:12596:1573:2941:2299:931",
	"37888:12596:1573",
	"37888:43570:2835:1571",
	"37888:43570:2835:1572",
	"37888:12596:1573:2941:2299:931:2409",
	"37888:43570:2835",
	"37888:12596:1573:2941:352:2859",
	"37888:12596:8018",
	"37888:12596",
	"44231:12617",
	"37888:12596:1573:2941:2299",
	"37888:12596:1573:2941",
	"44231:44230",
	"37888:12596:1573:2941:352:43045",
	"37888:43570:2835:41325:41323",
	"37888:43570:2835:41325:41322",
	"37888:43570:2835:41325",
	"37888:43570:2835:41325:41322:41321",
	"37888:43570:2835:1572:41332",
	"37888:12596:1573:2941:352:42983",
	"37888:12596:1573:2941:352:523:42426",
	"37888:12596:1573:2941:352:42406",
	"37888:12596:1573:2941:2299:931:43000",
	"37888:12596:1573:2941:352:43045:43042",
	"37888:12596:1573:2941:352:43045:43042:43043",
	"37888:12596:1573:2941:2299:43086:43072",
	"37888:12596:1573:2941:2299:43086:43087",
	"37888:12596:1573:2941:2299:43086",
	"37888:12596:1573:2941:2299:931:43088",
	"37888:12596:1573:2941:2299:931:43371",
	"37888:43570",
	"37888:12596:1573:43701",
	"37888:12596:1573:43702",
	"37888:12596:1573:2941:352:523:43697",
	"44231:12617:44407:44409",
	"44231:12617:44407:44410",
	"44231:12617:44407",
	"37888:46011:46006",
	"37888:46011",
	"37888:43570:2835:1572:XY-2626314551",
	"37888:43570:2835:1572:XY-2626314551:47147:47118",
	"37888:43570:2835:1572:XY-2626314551:47147",
	"37888:43570:2835:1572:XY-2626314551:47147:47154",
	"37888:43570:2835:1572:XY-2626314551:47155",
	"44233:47875",
	"37888:12596:1573:2941:47927",
	"37888:12596:1573:2941:47927:48318",
	"37888:12596:1573:2941:47927:48318:48321",
	"37888:12596:1573:2941:2299:43086:43087:85731",
	"44231:12617:238480:241031:251081:242011",
	"44231:12617:238480:242913:239639:246560",
	"44231:12617:238480:241031:249150",
	"44231:12617:238480:241031:241036",
	"44231:12617:238480:241031",
	"44231:12617:238480:241031:251081",
	"44231:12617:238480:241031:251073",
	"44231:12617:238480:242913:239639",
	"44231:12617:238480:242913",
	"44231:12617:238480",
	--["name"] = "Crown Guard Tower, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 1497804315,
	["direct"] = "44233:28621:37888:44231",
	["f"] = 0,
	},
	[41323] = {
	"41322:41321:1572:2941:352",
	"41322:41321:1572:2941:352:523",
	"41322:41321:1572:44409:44410:2299:931",
	"1571:1573",
	"41322:41321:1572",
	"41322:41321:1572:44409:44410:2299:931:2409",
	"41325:2835",
	"41322:41321:1572:2941:352:2859",
	"41325:2835:8018",
	"41325:2835:8018:12596",
	"41325:2835:43570:12617",
	"41322:41321:1572:44409:44410:2299",
	"41322:41321:1572:2941",
	"41325:2835:43570:12617:44230:44233",
	"41325:2835:43570:12617:44230:28621",
	"41325:2835:43570:12617:44230",
	"41325:2835:43570:12617:44231:44232",
	"41322:41321:1572:2941:352:43045",
	"41325:2835:8018:12596:37888",
	"41322:41321",
	"41322:41321:1572:41332",
	"41322:41321:1572:2941:352:42983",
	"41322:41321:1572:2941:352:523:42426",
	"41322:41321:1572:2941:352:42406",
	"41322:41321:1572:44409:44410:2299:931:43000",
	"41322:41321:1572:2941:352:43045:43042",
	"41322:41321:1572:2941:352:43045:43042:43043",
	"41322:41321:1572:44409:44410:2299:43086:43072",
	"41322:41321:1572:44409:44410:2299:43086:43087",
	"41322:41321:1572:44409:44410:2299:43086",
	"41322:41321:1572:44409:44410:2299:931:43088",
	"41322:41321:1572:44409:44410:2299:931:43371",
	"41325:2835:43570",
	"1571:1573:43701",
	"41322:41321:1572:43702",
	"41322:41321:1572:2941:352:523:43697",
	"41325:2835:43570:12617:44231",
	"41322:41321:1572:44409",
	"41322:41321:1572:44409:44410",
	"41322:41321:1572:44409:44407",
	"41325:2835:8018:46006",
	"41325:2835:8018:46006:46011",
	"41322:41321:1572:XY-2626314551",
	"41322:41321:1572:XY-2626314551:47147:47118",
	"41322:41321:1572:XY-2626314551:47147",
	"41322:41321:1572:XY-2626314551:47147:47154",
	"41322:41321:1572:XY-2626314551:47155",
	"41325:2835:8018:46006:46011:47875",
	"41322:41321:1572:2941:47927",
	"41322:41321:1572:2941:47927:48318",
	"41322:41321:1572:2941:47927:48318:48321",
	"41322:41321:1572:44409:44410:2299:43086:43087:85731",
	"41325:2835:43570:12617:238480:241031:251081:242011",
	"41325:2835:43570:12617:238480:242913:239639:246560",
	"41325:2835:43570:12617:238480:241031:249150",
	"41325:2835:43570:12617:238480:241031:241036",
	"41325:2835:43570:12617:238480:241031",
	"41325:2835:43570:12617:238480:241031:251081",
	"41325:2835:43570:12617:238480:241031:251073",
	"41325:2835:43570:12617:238480:242913:239639",
	"41325:2835:43570:12617:238480:242913",
	"41325:2835:43570:12617:238480",
	--["name"] = "Whelgar's Retreat, Wetlands",
	["m"] = 56,
	["coord"] = 1661625304,
	["direct"] = "1571:41322:41325",
	["f"] = 0,
	},
	[43371] = {
	"931:352",
	"931:523",
	"931:2299:2941:1573",
	"931:2299:44410:44409:1572:1571",
	"931:2299:44410:44409:1572",
	"931:2409",
	"931:2299:44410:44409:1572:41321:41322:41325:2835",
	"931:2409:43045:2859",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"931:2299",
	"931:2299:2941",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"931:2409:43045",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"931:2299:44410:44409:1572:41321:41322:41323",
	"931:2299:44410:44409:1572:41321:41322",
	"931:2299:44410:44409:1572:41321:41322:41325",
	"931:2299:44410:44409:1572:41321",
	"931:2299:44410:44407:41332",
	"931:43000:42983",
	"931:523:42426",
	"931:352:42406",
	"931:43000",
	"931:2409:43045:43042",
	"931:2409:43045:43042:43043",
	"43072:43086:43087",
	"43072:43086",
	"931:43088",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570",
	"931:2299:44410:44409:1572:43702:43701",
	"931:2299:44410:44409:1572:43702",
	"931:2409:43697",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"931:2299:44410:44409",
	"931:2299:44410",
	"931:2299:44410:44407",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"931:2299:44410:44409:1572:XY-2626314551",
	"931:2299:44410:44409:1572:XY-2626314551:47147:47118",
	"931:2299:44410:44409:1572:XY-2626314551:47147",
	"931:2299:44410:44409:1572:XY-2626314551:47147:47154",
	"931:2299:44410:44409:1572:XY-2626314551:47155",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"931:2299:48321:48318:47927",
	"931:2299:48321:48318",
	"931:2299:48321",
	"43072:43086:43087:85731",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Camp Everstill, Redridge",
	["m"] = 49,
	["f"] = 0,
	["direct"] = "931:43072",
	["coord"] = 2276494369,
	},
	[251081] = {
	"241031:238480:244537:47875:46011:12596:1573:2941:352",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:523",
	"241031:238480:12617:44407:44410:2299:931",
	"241031:238480:244537:47875:46011:12596:1573",
	"241031:238480:12617:43570:2835:1571",
	"241031:238480:12617:43570:2835:1572",
	"241031:238480:12617:44407:44410:2299:931:2409",
	"241031:238480:12617:43570:2835",
	"241031:238480:12617:44407:44410:2299:931:2409:43045:2859",
	"241031:238480:12617:8018",
	"241031:238480:244537:47875:46011:12596",
	"241031:238480:12617",
	"241031:238480:12617:44407:44410:2299",
	"241031:238480:244537:47875:46011:12596:1573:2941",
	"241031:238480:244537:47875:44233",
	"241031:238480:12617:44230:28621",
	"241031:238480:12617:44230",
	"241031:238480:12617:44231:44232",
	"241031:238480:12617:44407:44410:2299:931:2409:43045",
	"241031:238480:244537:47875:46011:37888",
	"241031:238480:12617:43570:2835:41325:41323",
	"241031:238480:12617:43570:2835:41325:41322",
	"241031:238480:12617:43570:2835:41325",
	"241031:238480:12617:43570:2835:41325:41322:41321",
	"241031:238480:12617:43570:2835:1572:41332",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:42983",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:523:42426",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:42406",
	"241031:238480:12617:44407:44410:2299:931:43000",
	"241031:238480:12617:44407:44410:2299:931:2409:43045:43042",
	"241031:238480:12617:44407:44410:2299:931:2409:43045:43042:43043",
	"241031:238480:12617:44407:44410:2299:43086:43072",
	"241031:238480:12617:44407:44410:2299:43086:43087",
	"241031:238480:12617:44407:44410:2299:43086",
	"241031:238480:12617:44407:44410:2299:931:43088",
	"241031:238480:12617:44407:44410:2299:931:43371",
	"241031:238480:12617:43570",
	"241031:238480:244537:47875:46011:12596:1573:43701",
	"241031:238480:244537:47875:46011:12596:1573:43702",
	"241031:238480:12617:44407:44410:2299:931:2409:43697",
	"241031:238480:12617:44231",
	"241031:238480:12617:44407:44409",
	"241031:238480:12617:44407:44410",
	"241031:238480:12617:44407",
	"241031:238480:244537:47875:46011:46006",
	"241031:238480:244537:47875:46011",
	"241031:238480:12617:43570:2835:1572:XY-2626314551",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47147:47118",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47147",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47147:47154",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47155",
	"241031:238480:244537:47875",
	"241031:238480:244537:47875:46011:12596:1573:2941:47927",
	"241031:238480:244537:47875:46011:12596:1573:2941:47927:48318",
	"241031:238480:12617:44407:44410:2299:48321",
	"241031:238480:12617:44407:44410:2299:43086:43087:85731",
	"251073:239639:246560",
	"241031:249150",
	"251073:239639",
	"251073:242913",
	"241031:238480",
	--["name"] = "Shadebasin Watch, Zul'Aman",
	["m"] = 2437,
	["f"] = 0,
	["direct"] = "242011:241036:241031:251073",
	["coord"] = 1890342442,
	},
	[352] = {
	"1573:1571",
	"2941:1572",
	"2941:1572:41321:41322:41325:2835",
	"2941:1572:41321:41322:41325:2835:8018",
	"1573:12596",
	"2941:1572:41321:41322:41325:2835:43570:12617",
	"2941:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"2941:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"2941:1572:41321:41322:41325:2835:43570:12617:44230",
	"1573:12596:37888:44232",
	"1573:12596:37888",
	"2941:1572:41321:41322:41323",
	"2941:1572:41321:41322",
	"2941:1572:41321:41322:41325",
	"2941:1572:41321",
	"2941:1572:41332",
	"523:42426",
	"42983:43000",
	"43045:43042",
	"43045:43042:43043",
	"931:43371:43072",
	"931:43088:43087",
	"931:43371:43072:43086",
	"931:43088",
	"931:43371",
	"2941:1572:41321:41322:41325:2835:43570",
	"1573:43701",
	"2941:1572:43702",
	"523:43697",
	"2941:1572:41321:41322:41325:2835:43570:12617:44231",
	"2299:44410:44409",
	"2299:44410",
	"2299:44410:44407",
	"1573:12596:46006",
	"1573:12596:46011",
	"2941:1572:XY-2626314551",
	"2941:1572:XY-2626314551:47147:47118",
	"2941:1572:XY-2626314551:47147",
	"2941:1572:XY-2626314551:47147:47154",
	"2941:1572:XY-2626314551:47155",
	"1573:12596:46011:47875",
	"2941:47927",
	"2299:48321:48318",
	"2299:48321",
	"42983:2409:85731",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Stormwind, Elwynn",
	["m"] = 84,
	["coord"] = 3050420598,
	["direct"] = "523:931:1573:2409:2859:2299:2941:43045:42983:42406",
	["f"] = 0,
	},
	[12596] = {
	"1573:2941:352",
	"1573:2941:352:523",
	"1573:2941:2299:931",
	"8018:2835:1571",
	"8018:2835:1572",
	"1573:2941:2299:931:2409",
	"8018:2835",
	"1573:2941:352:2859",
	"1573:2941:2299",
	"1573:2941",
	"46011:47875:44233",
	"37888:44232:28621",
	"37888:44232:44231:44230",
	"37888:44232",
	"1573:2941:352:43045",
	"8018:2835:41325:41323",
	"8018:2835:41325:41322",
	"8018:2835:41325",
	"8018:2835:41325:41322:41321",
	"8018:2835:1572:41332",
	"1573:2941:352:42983",
	"1573:2941:352:523:42426",
	"1573:2941:352:42406",
	"1573:2941:2299:931:43000",
	"1573:2941:352:43045:43042",
	"1573:2941:352:43045:43042:43043",
	"1573:2941:2299:43086:43072",
	"1573:2941:2299:43086:43087",
	"1573:2941:2299:43086",
	"1573:2941:2299:931:43088",
	"1573:2941:2299:931:43371",
	"8018:43570",
	"1573:43701",
	"1573:43702",
	"1573:2941:352:523:43697",
	"37888:44232:44231",
	"8018:2835:1572:44409",
	"8018:2835:1572:44409:44410",
	"8018:2835:1572:44409:44407",
	"8018:2835:1572:XY-2626314551",
	"8018:2835:1572:XY-2626314551:47147:47118",
	"8018:2835:1572:XY-2626314551:47147",
	"8018:2835:1572:XY-2626314551:47147:47154",
	"8018:2835:1572:XY-2626314551:47155",
	"46011:47875",
	"1573:2941:47927",
	"1573:2941:47927:48318",
	"1573:2941:47927:48318:48321",
	"1573:2941:2299:43086:43087:85731",
	"46011:47875:244537:238480:241031:251081:242011",
	"46011:47875:244537:238480:242913:239639:246560",
	"46011:47875:244537:238480:241031:249150",
	"46011:47875:244537:238480:241031:241036",
	"46011:47875:244537:238480:241031",
	"46011:47875:244537:238480:241031:251081",
	"46011:47875:244537:238480:241031:251073",
	"46011:47875:244537:238480:242913:239639",
	"46011:47875:244537:238480:242913",
	"46011:47875:244537:238480",
	--["name"] = "Chillwind Camp, Western Plaguelands",
	["m"] = 22,
	["coord"] = 1844631931,
	["direct"] = "1573:8018:12617:37888:46006:46011",
	["f"] = 0,
	},
	[44407] = {
	"44410:2299:352",
	"44410:2299:931:523",
	"44410:2299:931",
	"44409:1572:1573",
	"44409:1572:1571",
	"44409:1572",
	"44410:2299:931:2409",
	"44409:1572:41321:41322:41325:2835",
	"44410:2299:931:2409:43045:2859",
	"44409:1572:41321:41322:41325:2835:8018",
	"44409:1572:41321:41322:41325:2835:8018:12596",
	"44410:2299",
	"44409:1572:2941",
	"12617:44230:44233",
	"12617:44230:28621",
	"12617:44230",
	"12617:44231:44232",
	"44410:2299:931:2409:43045",
	"44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"44409:1572:41321:41322:41323",
	"44409:1572:41321:41322",
	"44409:1572:41321:41322:41325",
	"44409:1572:41321",
	"44410:2299:931:43000:42983",
	"44410:2299:931:523:42426",
	"44410:2299:352:42406",
	"44410:2299:931:43000",
	"44410:2299:931:2409:43045:43042",
	"44410:2299:931:2409:43045:43042:43043",
	"44410:2299:43086:43072",
	"44410:2299:43086:43087",
	"44410:2299:43086",
	"44410:2299:931:43088",
	"44410:2299:931:43371",
	"44409:1572:41321:41322:41325:2835:43570",
	"44409:1572:43702:43701",
	"44409:1572:43702",
	"44410:2299:931:2409:43697",
	"12617:44231",
	"44409:1572:41321:41322:41325:2835:8018:46006",
	"44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"44409:1572:XY-2626314551",
	"44409:1572:XY-2626314551:47147:47118",
	"44409:1572:XY-2626314551:47147",
	"44409:1572:XY-2626314551:47147:47154",
	"44409:1572:XY-2626314551:47155",
	"44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"44409:1572:2941:47927",
	"44410:2299:48321:48318",
	"44410:2299:48321",
	"44410:2299:43086:43087:85731",
	"12617:238480:241031:251081:242011",
	"12617:238480:242913:239639:246560",
	"12617:238480:241031:249150",
	"12617:238480:241031:241036",
	"12617:238480:241031",
	"12617:238480:241031:251081",
	"12617:238480:241031:251073",
	"12617:238480:242913:239639",
	"12617:238480:242913",
	"12617:238480",
	--["name"] = "Fuselight, Badlands",
	["m"] = 15,
	["coord"] = 2762430918,
	["direct"] = "12617:41332:44409:44410",
	["f"] = 0,
	},
	[47927] = {
	"2941:352",
	"2941:352:523",
	"48318:48321:2299:931",
	"2941:1573",
	"2941:1573:1571",
	"2941:1572",
	"48318:48321:2299:931:2409",
	"2941:1572:41321:41322:41325:2835",
	"2941:352:2859",
	"2941:1572:41321:41322:41325:2835:8018",
	"2941:1573:12596",
	"2941:1572:41321:41322:41325:2835:43570:12617",
	"48318:48321:2299",
	"2941:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"2941:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"2941:1572:41321:41322:41325:2835:43570:12617:44230",
	"2941:1573:12596:37888:44232",
	"2941:352:43045",
	"2941:1573:12596:37888",
	"2941:1572:41321:41322:41323",
	"2941:1572:41321:41322",
	"2941:1572:41321:41322:41325",
	"2941:1572:41321",
	"2941:1572:41332",
	"2941:352:42983",
	"2941:352:523:42426",
	"2941:352:42406",
	"48318:48321:2299:931:43000",
	"2941:352:43045:43042",
	"2941:352:43045:43042:43043",
	"48318:48321:2299:43086:43072",
	"48318:48321:2299:43086:43087",
	"48318:48321:2299:43086",
	"48318:48321:2299:931:43088",
	"48318:48321:2299:931:43371",
	"2941:1572:41321:41322:41325:2835:43570",
	"2941:1573:43701",
	"2941:1572:43702",
	"2941:352:523:43697",
	"2941:1572:41321:41322:41325:2835:43570:12617:44231",
	"2941:1572:44409",
	"48318:48321:2299:44410",
	"2941:1572:44409:44407",
	"2941:1573:12596:46006",
	"2941:1573:12596:46011",
	"2941:1572:XY-2626314551",
	"2941:1572:XY-2626314551:47147:47118",
	"2941:1572:XY-2626314551:47147",
	"2941:1572:XY-2626314551:47147:47154",
	"2941:1572:XY-2626314551:47155",
	"2941:1573:12596:46011:47875",
	"48318:48321",
	"48318:48321:2299:43086:43087:85731",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"2941:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Iron Summit, Searing Gorge",
	["m"] = 32,
	["coord"] = 1761849332,
	["direct"] = "2941:48318",
	["f"] = 0,
	},
	[241031] = {
	"238480:244537:47875:46011:12596:1573:2941:352",
	"238480:244537:47875:46011:12596:1573:2941:352:523",
	"238480:12617:44407:44410:2299:931",
	"238480:244537:47875:46011:12596:1573",
	"238480:12617:43570:2835:1571",
	"238480:12617:43570:2835:1572",
	"238480:12617:44407:44410:2299:931:2409",
	"238480:12617:43570:2835",
	"238480:12617:44407:44410:2299:931:2409:43045:2859",
	"238480:12617:8018",
	"238480:244537:47875:46011:12596",
	"238480:12617",
	"238480:12617:44407:44410:2299",
	"238480:244537:47875:46011:12596:1573:2941",
	"238480:244537:47875:44233",
	"238480:12617:44230:28621",
	"238480:12617:44230",
	"238480:12617:44231:44232",
	"238480:12617:44407:44410:2299:931:2409:43045",
	"238480:244537:47875:46011:37888",
	"238480:12617:43570:2835:41325:41323",
	"238480:12617:43570:2835:41325:41322",
	"238480:12617:43570:2835:41325",
	"238480:12617:43570:2835:41325:41322:41321",
	"238480:12617:43570:2835:1572:41332",
	"238480:244537:47875:46011:12596:1573:2941:352:42983",
	"238480:244537:47875:46011:12596:1573:2941:352:523:42426",
	"238480:244537:47875:46011:12596:1573:2941:352:42406",
	"238480:12617:44407:44410:2299:931:43000",
	"238480:12617:44407:44410:2299:931:2409:43045:43042",
	"238480:12617:44407:44410:2299:931:2409:43045:43042:43043",
	"238480:12617:44407:44410:2299:43086:43072",
	"238480:12617:44407:44410:2299:43086:43087",
	"238480:12617:44407:44410:2299:43086",
	"238480:12617:44407:44410:2299:931:43088",
	"238480:12617:44407:44410:2299:931:43371",
	"238480:12617:43570",
	"238480:244537:47875:46011:12596:1573:43701",
	"238480:244537:47875:46011:12596:1573:43702",
	"238480:12617:44407:44410:2299:931:2409:43697",
	"238480:12617:44231",
	"238480:12617:44407:44409",
	"238480:12617:44407:44410",
	"238480:12617:44407",
	"238480:244537:47875:46011:46006",
	"238480:244537:47875:46011",
	"238480:12617:43570:2835:1572:XY-2626314551",
	"238480:12617:43570:2835:1572:XY-2626314551:47147:47118",
	"238480:12617:43570:2835:1572:XY-2626314551:47147",
	"238480:12617:43570:2835:1572:XY-2626314551:47147:47154",
	"238480:12617:43570:2835:1572:XY-2626314551:47155",
	"238480:244537:47875",
	"238480:244537:47875:46011:12596:1573:2941:47927",
	"238480:244537:47875:46011:12596:1573:2941:47927:48318",
	"238480:12617:44407:44410:2299:48321",
	"238480:12617:44407:44410:2299:43086:43087:85731",
	"251081:242011",
	"238480:242913:239639:246560",
	"238480:242913:239639",
	"238480:242913",
	--["name"] = "Atal'Aman, Zul'Aman",
	["m"] = 2536,
	["f"] = 0,
	["direct"] = "249150:241036:251081:251073:238480",
	["coord"] = 1721592164,
	},
	[44231] = {
	"44232:37888:12596:1573:2941:352",
	"44232:37888:12596:1573:2941:352:523",
	"12617:44407:44410:2299:931",
	"44232:37888:12596:1573",
	"12617:43570:2835:1571",
	"12617:43570:2835:1572",
	"12617:44407:44410:2299:931:2409",
	"12617:43570:2835",
	"12617:44407:44410:2299:931:2409:43045:2859",
	"44232:37888:12596:8018",
	"44232:37888:12596",
	"12617:44407:44410:2299",
	"44232:37888:12596:1573:2941",
	"44230:28621",
	"12617:44407:44410:2299:931:2409:43045",
	"44232:37888",
	"12617:43570:2835:41325:41323",
	"12617:43570:2835:41325:41322",
	"12617:43570:2835:41325",
	"12617:43570:2835:41325:41322:41321",
	"12617:43570:2835:1572:41332",
	"44232:37888:12596:1573:2941:352:42983",
	"44232:37888:12596:1573:2941:352:523:42426",
	"44232:37888:12596:1573:2941:352:42406",
	"12617:44407:44410:2299:931:43000",
	"12617:44407:44410:2299:931:2409:43045:43042",
	"12617:44407:44410:2299:931:2409:43045:43042:43043",
	"12617:44407:44410:2299:43086:43072",
	"12617:44407:44410:2299:43086:43087",
	"12617:44407:44410:2299:43086",
	"12617:44407:44410:2299:931:43088",
	"12617:44407:44410:2299:931:43371",
	"12617:43570",
	"44232:37888:12596:1573:43701",
	"44232:37888:12596:1573:43702",
	"12617:44407:44410:2299:931:2409:43697",
	"12617:44407:44409",
	"12617:44407:44410",
	"12617:44407",
	"44232:37888:46011:46006",
	"44232:37888:46011",
	"12617:43570:2835:1572:XY-2626314551",
	"12617:43570:2835:1572:XY-2626314551:47147:47118",
	"12617:43570:2835:1572:XY-2626314551:47147",
	"12617:43570:2835:1572:XY-2626314551:47147:47154",
	"12617:43570:2835:1572:XY-2626314551:47155",
	"44233:47875",
	"44232:37888:12596:1573:2941:47927",
	"44232:37888:12596:1573:2941:47927:48318",
	"12617:44407:44410:2299:48321",
	"12617:44407:44410:2299:43086:43087:85731",
	"12617:238480:241031:251081:242011",
	"12617:238480:242913:239639:246560",
	"12617:238480:241031:249150",
	"12617:238480:241031:241036",
	"12617:238480:241031",
	"12617:238480:241031:251081",
	"12617:238480:241031:251073",
	"12617:238480:242913:239639",
	"12617:238480:242913",
	"12617:238480",
	--["name"] = "Light's Shield Tower, Eastern Plaguelands",
	["m"] = 23,
	["f"] = 0,
	["direct"] = "12617:44233:44230:44232",
	["coord"] = 2262927709,
	},
	[43042] = {
	"43045:352",
	"43045:523",
	"43045:2409:931",
	"43045:352:1573",
	"43045:352:1573:1571",
	"43045:2409:931:2299:44410:44409:1572",
	"43045:2409",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835",
	"43043:2859",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"43045:2409:931:2299",
	"43045:352:2941",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41323",
	"43045:2409:931:2299:44410:44409:1572:41321:41322",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325",
	"43045:2409:931:2299:44410:44409:1572:41321",
	"43045:2409:931:2299:44410:44407:41332",
	"43045:2409:42983",
	"43045:523:42426",
	"43045:523:42406",
	"43045:2409:931:43000",
	"43045:2409:931:43371:43072",
	"43045:85731:43087",
	"43045:2409:931:43371:43072:43086",
	"43045:2409:931:43088",
	"43045:2409:931:43371",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570",
	"43045:352:1573:43701",
	"43045:2409:931:2299:44410:44409:1572:43702",
	"43045:43697",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"43045:2409:931:2299:44410:44409",
	"43045:2409:931:2299:44410",
	"43045:2409:931:2299:44410:44407",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"43045:2409:931:2299:44410:44409:1572:XY-2626314551",
	"43045:2409:931:2299:44410:44409:1572:XY-2626314551:47147:47118",
	"43045:2409:931:2299:44410:44409:1572:XY-2626314551:47147",
	"43045:2409:931:2299:44410:44409:1572:XY-2626314551:47147:47154",
	"43045:2409:931:2299:44410:44409:1572:XY-2626314551:47155",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"43045:2409:931:2299:48321:48318:47927",
	"43045:2409:931:2299:48321:48318",
	"43045:2409:931:2299:48321",
	"43045:85731",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Fort Livingston, Stranglethorn",
	["m"] = 50,
	["f"] = 0,
	["direct"] = "43045:43043",
	["coord"] = 2260576629,
	},
	[43570] = {
	"2835:1572:2941:352",
	"2835:1572:2941:352:523",
	"2835:1572:44409:44410:2299:931",
	"2835:1571:1573",
	"2835:1571",
	"2835:1572",
	"2835:1572:44409:44410:2299:931:2409",
	"2835:1572:2941:352:2859",
	"8018:12596",
	"2835:1572:44409:44410:2299",
	"2835:1572:2941",
	"12617:44230:44233",
	"12617:44230:28621",
	"12617:44230",
	"12617:44231:44232",
	"2835:1572:2941:352:43045",
	"2835:41325:41323",
	"2835:41325:41322",
	"2835:41325",
	"2835:41325:41322:41321",
	"2835:1572:41332",
	"2835:1572:2941:352:42983",
	"2835:1572:2941:352:523:42426",
	"2835:1572:2941:352:42406",
	"2835:1572:44409:44410:2299:931:43000",
	"2835:1572:2941:352:43045:43042",
	"2835:1572:2941:352:43045:43042:43043",
	"2835:1572:44409:44410:2299:43086:43072",
	"2835:1572:44409:44410:2299:43086:43087",
	"2835:1572:44409:44410:2299:43086",
	"2835:1572:44409:44410:2299:931:43088",
	"2835:1572:44409:44410:2299:931:43371",
	"2835:1571:1573:43701",
	"2835:1572:43702",
	"2835:1572:2941:352:523:43697",
	"12617:44231",
	"2835:1572:44409",
	"2835:1572:44409:44410",
	"2835:1572:44409:44407",
	"8018:46006",
	"37888:46011",
	"2835:1572:XY-2626314551",
	"2835:1572:XY-2626314551:47147:47118",
	"2835:1572:XY-2626314551:47147",
	"2835:1572:XY-2626314551:47147:47154",
	"2835:1572:XY-2626314551:47155",
	"37888:46011:47875",
	"2835:1572:2941:47927",
	"2835:1572:2941:47927:48318",
	"2835:1572:2941:47927:48318:48321",
	"2835:1572:44409:44410:2299:43086:43087:85731",
	"12617:238480:241031:251081:242011",
	"12617:238480:242913:239639:246560",
	"12617:238480:241031:249150",
	"12617:238480:241031:241036",
	"12617:238480:241031",
	"12617:238480:241031:251081",
	"12617:238480:241031:251073",
	"12617:238480:242913:239639",
	"12617:238480:242913",
	"12617:238480",
	--["name"] = "Stormfeather Outpost, The Hinterlands",
	["m"] = 26,
	["coord"] = 2822861603,
	["direct"] = "2835:8018:12617:37888",
	["f"] = 0,
	},
	[239639] = {
	"242913:238480:244537:47875:46011:12596:1573:2941:352",
	"242913:238480:244537:47875:46011:12596:1573:2941:352:523",
	"242913:238480:12617:44407:44410:2299:931",
	"242913:238480:244537:47875:46011:12596:1573",
	"242913:238480:12617:43570:2835:1571",
	"242913:238480:12617:43570:2835:1572",
	"242913:238480:12617:44407:44410:2299:931:2409",
	"242913:238480:12617:43570:2835",
	"242913:238480:12617:44407:44410:2299:931:2409:43045:2859",
	"242913:238480:12617:8018",
	"242913:238480:244537:47875:46011:12596",
	"242913:238480:12617",
	"242913:238480:12617:44407:44410:2299",
	"242913:238480:244537:47875:46011:12596:1573:2941",
	"242913:238480:244537:47875:44233",
	"242913:238480:12617:44230:28621",
	"242913:238480:12617:44230",
	"242913:238480:12617:44231:44232",
	"242913:238480:12617:44407:44410:2299:931:2409:43045",
	"242913:238480:244537:47875:46011:37888",
	"242913:238480:12617:43570:2835:41325:41323",
	"242913:238480:12617:43570:2835:41325:41322",
	"242913:238480:12617:43570:2835:41325",
	"242913:238480:12617:43570:2835:41325:41322:41321",
	"242913:238480:12617:43570:2835:1572:41332",
	"242913:238480:244537:47875:46011:12596:1573:2941:352:42983",
	"242913:238480:244537:47875:46011:12596:1573:2941:352:523:42426",
	"242913:238480:244537:47875:46011:12596:1573:2941:352:42406",
	"242913:238480:12617:44407:44410:2299:931:43000",
	"242913:238480:12617:44407:44410:2299:931:2409:43045:43042",
	"242913:238480:12617:44407:44410:2299:931:2409:43045:43042:43043",
	"242913:238480:12617:44407:44410:2299:43086:43072",
	"242913:238480:12617:44407:44410:2299:43086:43087",
	"242913:238480:12617:44407:44410:2299:43086",
	"242913:238480:12617:44407:44410:2299:931:43088",
	"242913:238480:12617:44407:44410:2299:931:43371",
	"242913:238480:12617:43570",
	"242913:238480:244537:47875:46011:12596:1573:43701",
	"242913:238480:244537:47875:46011:12596:1573:43702",
	"242913:238480:12617:44407:44410:2299:931:2409:43697",
	"242913:238480:12617:44231",
	"242913:238480:12617:44407:44409",
	"242913:238480:12617:44407:44410",
	"242913:238480:12617:44407",
	"242913:238480:244537:47875:46011:46006",
	"242913:238480:244537:47875:46011",
	"242913:238480:12617:43570:2835:1572:XY-2626314551",
	"242913:238480:12617:43570:2835:1572:XY-2626314551:47147:47118",
	"242913:238480:12617:43570:2835:1572:XY-2626314551:47147",
	"242913:238480:12617:43570:2835:1572:XY-2626314551:47147:47154",
	"242913:238480:12617:43570:2835:1572:XY-2626314551:47155",
	"242913:238480:244537:47875",
	"242913:238480:244537:47875:46011:12596:1573:2941:47927",
	"242913:238480:244537:47875:46011:12596:1573:2941:47927:48318",
	"242913:238480:12617:44407:44410:2299:48321",
	"242913:238480:12617:44407:44410:2299:43086:43087:85731",
	"251073:242011",
	"242913:238480:241031:249150",
	"251073:251081:241036",
	"242913:238480:241031",
	"251073:251081",
	"242913:238480",
	--["name"] = "Sanctum of Light, Silvermoon City",
	["m"] = 2393,
	["f"] = 0,
	["direct"] = "246560:251073:242913",
	["coord"] = 2189342322,
	},
	[47118] = {
	"47147:XY-2626314551:1572:2941:352",
	"47147:XY-2626314551:1572:2941:352:523",
	"47147:XY-2626314551:1572:44409:44410:2299:931",
	"47147:XY-2626314551:1572:1573",
	"47147:XY-2626314551:1572:1571",
	"47147:XY-2626314551:1572",
	"47147:XY-2626314551:1572:44409:44410:2299:931:2409",
	"47147:XY-2626314551:1572:41321:41322:41325:2835",
	"47147:XY-2626314551:1572:2941:352:2859",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:8018",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:8018:12596",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617",
	"47147:XY-2626314551:1572:44409:44410:2299",
	"47147:XY-2626314551:1572:2941",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44230",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"47147:XY-2626314551:1572:2941:352:43045",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:8018:12596:37888",
	"47147:XY-2626314551:1572:41321:41322:41323",
	"47147:XY-2626314551:1572:41321:41322",
	"47147:XY-2626314551:1572:41321:41322:41325",
	"47147:XY-2626314551:1572:41321",
	"47147:XY-2626314551:1572:41332",
	"47147:XY-2626314551:1572:2941:352:42983",
	"47147:XY-2626314551:1572:2941:352:523:42426",
	"47147:XY-2626314551:1572:2941:352:42406",
	"47147:XY-2626314551:1572:44409:44410:2299:931:43000",
	"47147:XY-2626314551:1572:2941:352:43045:43042",
	"47147:XY-2626314551:1572:2941:352:43045:43042:43043",
	"47147:XY-2626314551:1572:44409:44410:2299:43086:43072",
	"47147:XY-2626314551:1572:44409:44410:2299:43086:43087",
	"47147:XY-2626314551:1572:44409:44410:2299:43086",
	"47147:XY-2626314551:1572:44409:44410:2299:931:43088",
	"47147:XY-2626314551:1572:44409:44410:2299:931:43371",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570",
	"47147:XY-2626314551:1572:43702:43701",
	"47147:XY-2626314551:1572:43702",
	"47147:XY-2626314551:1572:2941:352:523:43697",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44231",
	"47147:XY-2626314551:1572:44409",
	"47147:XY-2626314551:1572:44409:44410",
	"47147:XY-2626314551:1572:44409:44407",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:8018:46006",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:8018:46006:46011",
	"47147:XY-2626314551",
	"47154:47155",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"47147:XY-2626314551:1572:2941:47927",
	"47147:XY-2626314551:1572:2941:47927:48318",
	"47147:XY-2626314551:1572:2941:47927:48318:48321",
	"47147:XY-2626314551:1572:44409:44410:2299:43086:43087:85731",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Victor's Point, Twilight Highlands",
	["m"] = 241,
	["coord"] = 1883738764,
	["direct"] = "47147:47154",
	["f"] = 0,
	},
	[85731] = {
	"2409:352",
	"2409:523",
	"43087:43088:931",
	"43087:43086:2299:2941:1573",
	"43087:43086:2299:44410:44409:1572:1571",
	"43087:43086:2299:44410:44409:1572",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835",
	"43045:2859",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"43087:43086:2299",
	"43087:43086:2299:2941",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"43087:43086:2299:44410:44409:1572:41321:41322:41323",
	"43087:43086:2299:44410:44409:1572:41321:41322",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325",
	"43087:43086:2299:44410:44409:1572:41321",
	"43087:43086:2299:44410:44407:41332",
	"2409:42983",
	"2409:523:42426",
	"2409:523:42406",
	"43087:43088:931:43000",
	"43045:43042",
	"43045:43042:43043",
	"43087:43086:43072",
	"43087:43086",
	"43087:43088",
	"43087:43086:43072:43371",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570",
	"43087:43086:2299:44410:44409:1572:43702:43701",
	"43087:43086:2299:44410:44409:1572:43702",
	"2409:43697",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"43087:43086:2299:44410:44409",
	"43087:43086:2299:44410",
	"43087:43086:2299:44410:44407",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"43087:43086:2299:44410:44409:1572:XY-2626314551",
	"43087:43086:2299:44410:44409:1572:XY-2626314551:47147:47118",
	"43087:43086:2299:44410:44409:1572:XY-2626314551:47147",
	"43087:43086:2299:44410:44409:1572:XY-2626314551:47147:47154",
	"43087:43086:2299:44410:44409:1572:XY-2626314551:47155",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"43087:43086:2299:48321:48318:47927",
	"43087:43086:2299:48321:48318",
	"43087:43086:2299:48321",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Shattered Beachhead, Blasted Lands",
	["m"] = 17,
	["f"] = 0,
	["direct"] = "2409:43045:43087",
	["coord"] = 2904180566,
	},
	[43697] = {
	"523:352",
	"2409:931",
	"523:352:1573",
	"523:352:1573:1571",
	"2409:931:2299:44410:44409:1572",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835",
	"43045:2859",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"2409:931:2299",
	"523:352:2941",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"2409:931:2299:44410:44409:1572:41321:41322:41323",
	"2409:931:2299:44410:44409:1572:41321:41322",
	"2409:931:2299:44410:44409:1572:41321:41322:41325",
	"2409:931:2299:44410:44409:1572:41321",
	"2409:931:2299:44410:44407:41332",
	"2409:42983",
	"523:42426",
	"523:42406",
	"2409:931:43000",
	"43045:43042",
	"43045:43042:43043",
	"2409:931:43371:43072",
	"2409:85731:43087",
	"2409:931:43371:43072:43086",
	"2409:931:43088",
	"2409:931:43371",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570",
	"2409:931:2299:44410:44409:1572:43702:43701",
	"2409:931:2299:44410:44409:1572:43702",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"2409:931:2299:44410:44409",
	"2409:931:2299:44410",
	"2409:931:2299:44410:44407",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"2409:931:2299:44410:44409:1572:XY-2626314551",
	"2409:931:2299:44410:44409:1572:XY-2626314551:47147:47118",
	"2409:931:2299:44410:44409:1572:XY-2626314551:47147",
	"2409:931:2299:44410:44409:1572:XY-2626314551:47147:47154",
	"2409:931:2299:44410:44409:1572:XY-2626314551:47155",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"2409:931:2299:48321:48318:47927",
	"2409:931:2299:48321:48318",
	"2409:931:2299:48321",
	"2409:85731",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Raven Hill, Duskwood",
	["m"] = 47,
	["f"] = 0,
	["direct"] = "523:2409:43045",
	["coord"] = 903123159,
	},
	[43701] = {
	"1573:2941:352",
	"1573:2941:352:523",
	"1573:2941:2299:931",
	"1573:1571",
	"43702:1572",
	"1573:2941:2299:931:2409",
	"1573:2835",
	"1573:2941:352:2859",
	"1573:8018",
	"1573:12596",
	"1573:12617",
	"1573:2941:2299",
	"1573:2941",
	"1573:12596:46011:47875:44233",
	"1573:12617:44230:28621",
	"1573:12617:44230",
	"1573:12596:37888:44232",
	"1573:2941:352:43045",
	"1573:12596:37888",
	"1573:1571:41323",
	"43702:1572:41321:41322",
	"43702:1572:41321:41322:41325",
	"43702:1572:41321",
	"43702:1572:41332",
	"1573:2941:352:42983",
	"1573:2941:352:523:42426",
	"1573:2941:352:42406",
	"1573:2941:2299:931:43000",
	"1573:2941:352:43045:43042",
	"1573:2941:352:43045:43042:43043",
	"1573:2941:2299:43086:43072",
	"1573:2941:2299:43086:43087",
	"1573:2941:2299:43086",
	"1573:2941:2299:931:43088",
	"1573:2941:2299:931:43371",
	"1573:2835:43570",
	"1573:2941:352:523:43697",
	"1573:12617:44231",
	"43702:1572:44409",
	"43702:1572:44409:44410",
	"43702:1572:44409:44407",
	"1573:12596:46006",
	"1573:12596:46011",
	"43702:1572:XY-2626314551",
	"43702:1572:XY-2626314551:47147:47118",
	"43702:1572:XY-2626314551:47147",
	"43702:1572:XY-2626314551:47147:47154",
	"43702:1572:XY-2626314551:47155",
	"1573:12596:46011:47875",
	"1573:2941:47927",
	"1573:2941:47927:48318",
	"1573:2941:47927:48318:48321",
	"1573:2941:2299:43086:43087:85731",
	"1573:12617:238480:241031:251081:242011",
	"1573:12617:238480:242913:239639:246560",
	"1573:12617:238480:241031:249150",
	"1573:12617:238480:241031:241036",
	"1573:12617:238480:241031",
	"1573:12617:238480:241031:251081",
	"1573:12617:238480:241031:251073",
	"1573:12617:238480:242913:239639",
	"1573:12617:238480:242913",
	"1573:12617:238480",
	--["name"] = "Kharanos, Dun Morogh",
	["m"] = 27,
	["coord"] = 2308343503,
	["direct"] = "1573:43702",
	["f"] = 0,
	},
	[48321] = {
	"2299:352",
	"2299:931:523",
	"2299:931",
	"48318:47927:2941:1573",
	"48318:47927:2941:1573:1571",
	"48318:47927:2941:1572",
	"2299:931:2409",
	"48318:47927:2941:1572:41321:41322:41325:2835",
	"2299:931:2409:43045:2859",
	"48318:47927:2941:1572:41321:41322:41325:2835:8018",
	"48318:47927:2941:1573:12596",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617",
	"48318:47927:2941",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:44230",
	"48318:47927:2941:1573:12596:37888:44232",
	"2299:931:2409:43045",
	"48318:47927:2941:1573:12596:37888",
	"48318:47927:2941:1572:41321:41322:41323",
	"48318:47927:2941:1572:41321:41322",
	"48318:47927:2941:1572:41321:41322:41325",
	"48318:47927:2941:1572:41321",
	"2299:44410:44407:41332",
	"2299:931:43000:42983",
	"2299:931:523:42426",
	"2299:352:42406",
	"2299:931:43000",
	"2299:931:2409:43045:43042",
	"2299:931:2409:43045:43042:43043",
	"2299:43086:43072",
	"2299:43086:43087",
	"2299:43086",
	"2299:931:43088",
	"2299:931:43371",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570",
	"48318:47927:2941:1573:43701",
	"48318:47927:2941:1572:43702",
	"2299:931:2409:43697",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:44231",
	"2299:44410:44409",
	"2299:44410",
	"2299:44410:44407",
	"48318:47927:2941:1573:12596:46006",
	"48318:47927:2941:1573:12596:46011",
	"48318:47927:2941:1572:XY-2626314551",
	"48318:47927:2941:1572:XY-2626314551:47147:47118",
	"48318:47927:2941:1572:XY-2626314551:47147",
	"48318:47927:2941:1572:XY-2626314551:47147:47154",
	"48318:47927:2941:1572:XY-2626314551:47155",
	"48318:47927:2941:1573:12596:46011:47875",
	"48318:47927",
	"2299:43086:43087:85731",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Chiselgrip, Burning Steppes",
	["m"] = 36,
	["f"] = 0,
	["direct"] = "2299:48318",
	["coord"] = 1982294744,
	},
	[42983] = {
	"352:523",
	"43000:931",
	"352:1573",
	"352:1573:1571",
	"352:2941:1572",
	"352:2941:1572:41321:41322:41325:2835",
	"2409:43045:2859",
	"352:2941:1572:41321:41322:41325:2835:8018",
	"352:1573:12596",
	"352:2941:1572:41321:41322:41325:2835:43570:12617",
	"43000:931:2299",
	"352:2941",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:44230",
	"352:1573:12596:37888:44232",
	"2409:43045",
	"352:1573:12596:37888",
	"352:2941:1572:41321:41322:41323",
	"352:2941:1572:41321:41322",
	"352:2941:1572:41321:41322:41325",
	"352:2941:1572:41321",
	"352:2941:1572:41332",
	"352:523:42426",
	"352:42406",
	"2409:43045:43042",
	"2409:43045:43042:43043",
	"43000:931:43371:43072",
	"43000:931:43088:43087",
	"43000:931:43371:43072:43086",
	"43000:931:43088",
	"43000:931:43371",
	"352:2941:1572:41321:41322:41325:2835:43570",
	"352:1573:43701",
	"352:2941:1572:43702",
	"2409:43697",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:44231",
	"43000:931:2299:44410:44409",
	"43000:931:2299:44410",
	"43000:931:2299:44410:44407",
	"352:1573:12596:46006",
	"352:1573:12596:46011",
	"352:2941:1572:XY-2626314551",
	"352:2941:1572:XY-2626314551:47147:47118",
	"352:2941:1572:XY-2626314551:47147",
	"352:2941:1572:XY-2626314551:47147:47154",
	"352:2941:1572:XY-2626314551:47155",
	"352:1573:12596:46011:47875",
	"352:2941:47927",
	"43000:931:2299:48321:48318",
	"43000:931:2299:48321",
	"2409:85731",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"352:2941:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Goldshire, Elwynn",
	["m"] = 37,
	["f"] = 0,
	["direct"] = "352:2409:43000",
	["coord"] = 1794680136,
	},
	[931] = {
	"2299:2941:1573",
	"2299:44410:44409:1572:1571",
	"2299:44410:44409:1572",
	"2299:44410:44409:1572:41321:41322:41325:2835",
	"2409:43045:2859",
	"2299:44410:44409:1572:41321:41322:41325:2835:8018",
	"2299:44410:44409:1572:41321:41322:41325:2835:8018:12596",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"2299:2941",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"2409:43045",
	"2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"2299:44410:44409:1572:41321:41322:41323",
	"2299:44410:44409:1572:41321:41322",
	"2299:44410:44409:1572:41321:41322:41325",
	"2299:44410:44409:1572:41321",
	"2299:44410:44407:41332",
	"43000:42983",
	"523:42426",
	"352:42406",
	"2409:43045:43042",
	"2409:43045:43042:43043",
	"43371:43072",
	"43088:43087",
	"43371:43072:43086",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570",
	"2299:44410:44409:1572:43702:43701",
	"2299:44410:44409:1572:43702",
	"2409:43697",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"2299:44410:44409",
	"2299:44410",
	"2299:44410:44407",
	"2299:44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"2299:44410:44409:1572:XY-2626314551",
	"2299:44410:44409:1572:XY-2626314551:47147:47118",
	"2299:44410:44409:1572:XY-2626314551:47147",
	"2299:44410:44409:1572:XY-2626314551:47147:47154",
	"2299:44410:44409:1572:XY-2626314551:47155",
	"2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"2299:48321:48318:47927",
	"2299:48321:48318",
	"2299:48321",
	"43088:43087:85731",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Lakeshire, Redridge",
	["m"] = 49,
	["f"] = 0,
	["direct"] = "352:523:2409:2299:43000:43088:43371",
	["coord"] = 1266452990,
	},
	[44233] = {
	"44232:37888:12596:1573:2941:352",
	"44232:37888:12596:1573:2941:352:523",
	"44230:12617:44407:44410:2299:931",
	"44232:37888:12596:1573",
	"44230:12617:43570:2835:1571",
	"44230:12617:43570:2835:1572",
	"44230:12617:44407:44410:2299:931:2409",
	"44230:12617:43570:2835",
	"44230:12617:44407:44410:2299:931:2409:43045:2859",
	"44232:37888:12596:8018",
	"44232:37888:12596",
	"44230:12617",
	"44230:12617:44407:44410:2299",
	"44232:37888:12596:1573:2941",
	"44230:12617:44407:44410:2299:931:2409:43045",
	"44232:37888",
	"44230:12617:43570:2835:41325:41323",
	"44230:12617:43570:2835:41325:41322",
	"44230:12617:43570:2835:41325",
	"44230:12617:43570:2835:41325:41322:41321",
	"44230:12617:43570:2835:1572:41332",
	"44232:37888:12596:1573:2941:352:42983",
	"44232:37888:12596:1573:2941:352:523:42426",
	"44232:37888:12596:1573:2941:352:42406",
	"44230:12617:44407:44410:2299:931:43000",
	"44230:12617:44407:44410:2299:931:2409:43045:43042",
	"44230:12617:44407:44410:2299:931:2409:43045:43042:43043",
	"44230:12617:44407:44410:2299:43086:43072",
	"44230:12617:44407:44410:2299:43086:43087",
	"44230:12617:44407:44410:2299:43086",
	"44230:12617:44407:44410:2299:931:43088",
	"44230:12617:44407:44410:2299:931:43371",
	"44230:12617:43570",
	"44232:37888:12596:1573:43701",
	"44232:37888:12596:1573:43702",
	"44232:37888:12596:1573:2941:352:523:43697",
	"44230:12617:44407:44409",
	"44230:12617:44407:44410",
	"44230:12617:44407",
	"47875:46011:46006",
	"47875:46011",
	"44230:12617:43570:2835:1572:XY-2626314551",
	"44230:12617:43570:2835:1572:XY-2626314551:47147:47118",
	"44230:12617:43570:2835:1572:XY-2626314551:47147",
	"44230:12617:43570:2835:1572:XY-2626314551:47147:47154",
	"44230:12617:43570:2835:1572:XY-2626314551:47155",
	"44232:37888:12596:1573:2941:47927",
	"44232:37888:12596:1573:2941:47927:48318",
	"44230:12617:44407:44410:2299:48321",
	"44230:12617:44407:44410:2299:43086:43087:85731",
	"47875:244537:238480:241031:251081:242011",
	"47875:244537:238480:242913:239639:246560",
	"47875:244537:238480:241031:249150",
	"47875:244537:238480:241031:241036",
	"47875:244537:238480:241031",
	"47875:244537:238480:241031:251081",
	"47875:244537:238480:241031:251073",
	"47875:244537:238480:242913:239639",
	"47875:244537:238480:242913",
	"47875:244537:238480",
	--["name"] = "Plaguewood Tower, Eastern Plaguelands",
	["m"] = 23,
	["coord"] = 793396743,
	["direct"] = "28621:44230:44232:44231:47875",
	["f"] = 0,
	},
	[43086] = {
	"43072:43371:931:352",
	"43072:43371:931:523",
	"43072:43371:931",
	"2299:2941:1573",
	"2299:44410:44409:1572:1571",
	"2299:44410:44409:1572",
	"43072:43371:931:2409",
	"2299:44410:44409:1572:41321:41322:41325:2835",
	"43072:43371:931:2409:43045:2859",
	"2299:44410:44409:1572:41321:41322:41325:2835:8018",
	"2299:44410:44409:1572:41321:41322:41325:2835:8018:12596",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"2299:2941",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"43072:43371:931:2409:43045",
	"2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"2299:44410:44409:1572:41321:41322:41323",
	"2299:44410:44409:1572:41321:41322",
	"2299:44410:44409:1572:41321:41322:41325",
	"2299:44410:44409:1572:41321",
	"2299:44410:44407:41332",
	"43072:43371:931:43000:42983",
	"43072:43371:931:523:42426",
	"43072:43371:931:352:42406",
	"43072:43371:931:43000",
	"43072:43371:931:2409:43045:43042",
	"43072:43371:931:2409:43045:43042:43043",
	"43087:43088",
	"43072:43371",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570",
	"2299:44410:44409:1572:43702:43701",
	"2299:44410:44409:1572:43702",
	"43072:43371:931:2409:43697",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"2299:44410:44409",
	"2299:44410",
	"2299:44410:44407",
	"2299:44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"2299:44410:44409:1572:XY-2626314551",
	"2299:44410:44409:1572:XY-2626314551:47147:47118",
	"2299:44410:44409:1572:XY-2626314551:47147",
	"2299:44410:44409:1572:XY-2626314551:47147:47154",
	"2299:44410:44409:1572:XY-2626314551:47155",
	"2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"2299:48321:48318:47927",
	"2299:48321:48318",
	"2299:48321",
	"43087:85731",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Bogpaddle, Swamp of Sorrows",
	["m"] = 51,
	["f"] = 0,
	["direct"] = "2299:43072:43087",
	["coord"] = 3093634765,
	},
	[46011] = {
	"12596:1573:2941:352",
	"12596:1573:2941:352:523",
	"12596:1573:2941:2299:931",
	"12596:1573",
	"46006:8018:2835:1571",
	"46006:8018:2835:1572",
	"12596:1573:2941:2299:931:2409",
	"46006:8018:2835",
	"12596:1573:2941:352:2859",
	"46006:8018",
	"37888:12617",
	"12596:1573:2941:2299",
	"12596:1573:2941",
	"47875:44233",
	"37888:44232:28621",
	"37888:44232:44231:44230",
	"37888:44232",
	"12596:1573:2941:352:43045",
	"46006:8018:2835:41325:41323",
	"46006:8018:2835:41325:41322",
	"46006:8018:2835:41325",
	"46006:8018:2835:41325:41322:41321",
	"46006:8018:2835:1572:41332",
	"12596:1573:2941:352:42983",
	"12596:1573:2941:352:523:42426",
	"12596:1573:2941:352:42406",
	"12596:1573:2941:2299:931:43000",
	"12596:1573:2941:352:43045:43042",
	"12596:1573:2941:352:43045:43042:43043",
	"12596:1573:2941:2299:43086:43072",
	"12596:1573:2941:2299:43086:43087",
	"12596:1573:2941:2299:43086",
	"12596:1573:2941:2299:931:43088",
	"12596:1573:2941:2299:931:43371",
	"37888:43570",
	"12596:1573:43701",
	"12596:1573:43702",
	"12596:1573:2941:352:523:43697",
	"37888:44232:44231",
	"46006:8018:2835:1572:44409",
	"46006:8018:2835:1572:44409:44410",
	"46006:8018:2835:1572:44409:44407",
	"46006:8018:2835:1572:XY-2626314551",
	"46006:8018:2835:1572:XY-2626314551:47147:47118",
	"46006:8018:2835:1572:XY-2626314551:47147",
	"46006:8018:2835:1572:XY-2626314551:47147:47154",
	"46006:8018:2835:1572:XY-2626314551:47155",
	"12596:1573:2941:47927",
	"12596:1573:2941:47927:48318",
	"12596:1573:2941:47927:48318:48321",
	"12596:1573:2941:2299:43086:43087:85731",
	"47875:244537:238480:241031:251081:242011",
	"47875:244537:238480:242913:239639:246560",
	"47875:244537:238480:241031:249150",
	"47875:244537:238480:241031:241036",
	"47875:244537:238480:241031",
	"47875:244537:238480:241031:251081",
	"47875:244537:238480:241031:251073",
	"47875:244537:238480:242913:239639",
	"47875:244537:238480:242913",
	"47875:244537:238480",
	--["name"] = "The Menders' Stead, Western Plaguelands",
	["m"] = 22,
	["coord"] = 2169931306,
	["direct"] = "12596:37888:46006:47875",
	["f"] = 0,
	},
	[43087] = {
	"43088:931:352",
	"43088:931:523",
	"43088:931",
	"43086:2299:2941:1573",
	"43086:2299:44410:44409:1572:1571",
	"43086:2299:44410:44409:1572",
	"85731:2409",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835",
	"85731:43045:2859",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:8018",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"43086:2299",
	"43086:2299:2941",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"85731:43045",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"43086:2299:44410:44409:1572:41321:41322:41323",
	"43086:2299:44410:44409:1572:41321:41322",
	"43086:2299:44410:44409:1572:41321:41322:41325",
	"43086:2299:44410:44409:1572:41321",
	"43086:2299:44410:44407:41332",
	"43088:931:43000:42983",
	"43088:931:523:42426",
	"43088:931:352:42406",
	"43088:931:43000",
	"85731:43045:43042",
	"85731:43045:43042:43043",
	"43086:43072",
	"43086:43072:43371",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570",
	"43086:2299:44410:44409:1572:43702:43701",
	"43086:2299:44410:44409:1572:43702",
	"85731:2409:43697",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"43086:2299:44410:44409",
	"43086:2299:44410",
	"43086:2299:44410:44407",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"43086:2299:44410:44409:1572:XY-2626314551",
	"43086:2299:44410:44409:1572:XY-2626314551:47147:47118",
	"43086:2299:44410:44409:1572:XY-2626314551:47147",
	"43086:2299:44410:44409:1572:XY-2626314551:47147:47154",
	"43086:2299:44410:44409:1572:XY-2626314551:47155",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"43086:2299:48321:48318:47927",
	"43086:2299:48321:48318",
	"43086:2299:48321",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Marshtide Watch, Swamp of Sorrows",
	["m"] = 51,
	["f"] = 0,
	["direct"] = "43086:43088:85731",
	["coord"] = 3007210198,
	},
	[12617] = {
	"43570:2835:1572:2941:352",
	"44407:44410:2299:931:523",
	"44407:44410:2299:931",
	"43570:2835:1571",
	"43570:2835:1572",
	"44407:44410:2299:931:2409",
	"43570:2835",
	"44407:44410:2299:931:2409:43045:2859",
	"44407:44410:2299",
	"43570:2835:1572:2941",
	"44230:44233",
	"44230:28621",
	"44231:44232",
	"44407:44410:2299:931:2409:43045",
	"43570:2835:41325:41323",
	"43570:2835:41325:41322",
	"43570:2835:41325",
	"43570:2835:41325:41322:41321",
	"43570:2835:1572:41332",
	"43570:2835:1572:2941:352:42983",
	"44407:44410:2299:931:523:42426",
	"43570:2835:1572:2941:352:42406",
	"44407:44410:2299:931:43000",
	"44407:44410:2299:931:2409:43045:43042",
	"44407:44410:2299:931:2409:43045:43042:43043",
	"44407:44410:2299:43086:43072",
	"44407:44410:2299:43086:43087",
	"44407:44410:2299:43086",
	"44407:44410:2299:931:43088",
	"44407:44410:2299:931:43371",
	"1573:43701",
	"43570:2835:1572:43702",
	"44407:44410:2299:931:2409:43697",
	"44407:44409",
	"44407:44410",
	"37888:46011:46006",
	"37888:46011",
	"43570:2835:1572:XY-2626314551",
	"43570:2835:1572:XY-2626314551:47147:47118",
	"43570:2835:1572:XY-2626314551:47147",
	"43570:2835:1572:XY-2626314551:47147:47154",
	"43570:2835:1572:XY-2626314551:47155",
	"44230:44233:47875",
	"43570:2835:1572:2941:47927",
	"43570:2835:1572:2941:47927:48318",
	"44407:44410:2299:48321",
	"44407:44410:2299:43086:43087:85731",
	"238480:241031:251081:242011",
	"238480:242913:239639:246560",
	"238480:241031:249150",
	"238480:241031:241036",
	"238480:241031",
	"238480:241031:251081",
	"238480:241031:251073",
	"238480:242913:239639",
	"238480:242913",
	--["name"] = "Light's Hope Chapel, Eastern Plaguelands",
	["m"] = 23,
	["f"] = 0,
	["direct"] = "1573:8018:12596:44230:37888:43570:44231:44407:238480",
	["coord"] = 3253045378,
	},
	[246560] = {
	"239639:242913:238480:244537:47875:46011:12596:1573:2941:352",
	"239639:242913:238480:244537:47875:46011:12596:1573:2941:352:523",
	"239639:242913:238480:12617:44407:44410:2299:931",
	"239639:242913:238480:244537:47875:46011:12596:1573",
	"239639:242913:238480:12617:43570:2835:1571",
	"239639:242913:238480:12617:43570:2835:1572",
	"239639:242913:238480:12617:44407:44410:2299:931:2409",
	"239639:242913:238480:12617:43570:2835",
	"239639:242913:238480:12617:44407:44410:2299:931:2409:43045:2859",
	"239639:242913:238480:12617:8018",
	"239639:242913:238480:244537:47875:46011:12596",
	"239639:242913:238480:12617",
	"239639:242913:238480:12617:44407:44410:2299",
	"239639:242913:238480:244537:47875:46011:12596:1573:2941",
	"239639:242913:238480:244537:47875:44233",
	"239639:242913:238480:12617:44230:28621",
	"239639:242913:238480:12617:44230",
	"239639:242913:238480:12617:44231:44232",
	"239639:242913:238480:12617:44407:44410:2299:931:2409:43045",
	"239639:242913:238480:244537:47875:46011:37888",
	"239639:242913:238480:12617:43570:2835:41325:41323",
	"239639:242913:238480:12617:43570:2835:41325:41322",
	"239639:242913:238480:12617:43570:2835:41325",
	"239639:242913:238480:12617:43570:2835:41325:41322:41321",
	"239639:242913:238480:12617:43570:2835:1572:41332",
	"239639:242913:238480:244537:47875:46011:12596:1573:2941:352:42983",
	"239639:242913:238480:244537:47875:46011:12596:1573:2941:352:523:42426",
	"239639:242913:238480:244537:47875:46011:12596:1573:2941:352:42406",
	"239639:242913:238480:12617:44407:44410:2299:931:43000",
	"239639:242913:238480:12617:44407:44410:2299:931:2409:43045:43042",
	"239639:242913:238480:12617:44407:44410:2299:931:2409:43045:43042:43043",
	"239639:242913:238480:12617:44407:44410:2299:43086:43072",
	"239639:242913:238480:12617:44407:44410:2299:43086:43087",
	"239639:242913:238480:12617:44407:44410:2299:43086",
	"239639:242913:238480:12617:44407:44410:2299:931:43088",
	"239639:242913:238480:12617:44407:44410:2299:931:43371",
	"239639:242913:238480:12617:43570",
	"239639:242913:238480:244537:47875:46011:12596:1573:43701",
	"239639:242913:238480:244537:47875:46011:12596:1573:43702",
	"239639:242913:238480:12617:44407:44410:2299:931:2409:43697",
	"239639:242913:238480:12617:44231",
	"239639:242913:238480:12617:44407:44409",
	"239639:242913:238480:12617:44407:44410",
	"239639:242913:238480:12617:44407",
	"239639:242913:238480:244537:47875:46011:46006",
	"239639:242913:238480:244537:47875:46011",
	"239639:242913:238480:12617:43570:2835:1572:XY-2626314551",
	"239639:242913:238480:12617:43570:2835:1572:XY-2626314551:47147:47118",
	"239639:242913:238480:12617:43570:2835:1572:XY-2626314551:47147",
	"239639:242913:238480:12617:43570:2835:1572:XY-2626314551:47147:47154",
	"239639:242913:238480:12617:43570:2835:1572:XY-2626314551:47155",
	"239639:242913:238480:244537:47875",
	"239639:242913:238480:244537:47875:46011:12596:1573:2941:47927",
	"239639:242913:238480:244537:47875:46011:12596:1573:2941:47927:48318",
	"239639:242913:238480:12617:44407:44410:2299:48321",
	"239639:242913:238480:12617:44407:44410:2299:43086:43087:85731",
	"239639:251073:242011",
	"239639:242913:238480:241031:249150",
	"239639:251073:251081:241036",
	"239639:242913:238480:241031",
	"239639:251073:251081",
	"239639:251073",
	"239639:242913",
	"239639:242913:238480",
	--["name"] = "Terrace of the Sun, Isle of Quel'Danas",
	["m"] = 2424,
	["f"] = 0,
	["direct"] = "239639",
	["coord"] = 2473416357,
	},
	[47154] = {
	"47147:XY-2626314551:1572:2941:352",
	"47147:XY-2626314551:1572:2941:352:523",
	"47147:XY-2626314551:1572:44409:44410:2299:931",
	"47147:XY-2626314551:1572:1573",
	"47147:XY-2626314551:1572:1571",
	"47147:XY-2626314551:1572",
	"47147:XY-2626314551:1572:44409:44410:2299:931:2409",
	"47147:XY-2626314551:1572:41321:41322:41325:2835",
	"47147:XY-2626314551:1572:2941:352:2859",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:8018",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:8018:12596",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617",
	"47147:XY-2626314551:1572:44409:44410:2299",
	"47147:XY-2626314551:1572:2941",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44230",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"47147:XY-2626314551:1572:2941:352:43045",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:8018:12596:37888",
	"47147:XY-2626314551:1572:41321:41322:41323",
	"47147:XY-2626314551:1572:41321:41322",
	"47147:XY-2626314551:1572:41321:41322:41325",
	"47147:XY-2626314551:1572:41321",
	"47147:XY-2626314551:1572:41332",
	"47147:XY-2626314551:1572:2941:352:42983",
	"47147:XY-2626314551:1572:2941:352:523:42426",
	"47147:XY-2626314551:1572:2941:352:42406",
	"47147:XY-2626314551:1572:44409:44410:2299:931:43000",
	"47147:XY-2626314551:1572:2941:352:43045:43042",
	"47147:XY-2626314551:1572:2941:352:43045:43042:43043",
	"47147:XY-2626314551:1572:44409:44410:2299:43086:43072",
	"47147:XY-2626314551:1572:44409:44410:2299:43086:43087",
	"47147:XY-2626314551:1572:44409:44410:2299:43086",
	"47147:XY-2626314551:1572:44409:44410:2299:931:43088",
	"47147:XY-2626314551:1572:44409:44410:2299:931:43371",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570",
	"47147:XY-2626314551:1572:43702:43701",
	"47147:XY-2626314551:1572:43702",
	"47147:XY-2626314551:1572:2941:352:523:43697",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:44231",
	"47147:XY-2626314551:1572:44409",
	"47147:XY-2626314551:1572:44409:44410",
	"47147:XY-2626314551:1572:44409:44407",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:8018:46006",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:8018:46006:46011",
	"47147:XY-2626314551",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"47147:XY-2626314551:1572:2941:47927",
	"47147:XY-2626314551:1572:2941:47927:48318",
	"47147:XY-2626314551:1572:2941:47927:48318:48321",
	"47147:XY-2626314551:1572:44409:44410:2299:43086:43087:85731",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"47147:XY-2626314551:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Thundermar, Twilight Highlands",
	["m"] = 241,
	["coord"] = 2083407912,
	["direct"] = "47118:47147:47155",
	["f"] = 0,
	},
	[41332] = {
	"1572:2941:352",
	"1572:2941:352:523",
	"44407:44410:2299:931",
	"1572:1573",
	"1572:1571",
	"44407:44410:2299:931:2409",
	"1572:41321:41322:41325:2835",
	"44407:44410:2299:931:2409:43045:2859",
	"1572:41321:41322:41325:2835:8018",
	"1572:41321:41322:41325:2835:8018:12596",
	"1572:41321:41322:41325:2835:43570:12617",
	"44407:44410:2299",
	"1572:2941",
	"1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"1572:41321:41322:41325:2835:43570:12617:44230",
	"1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"44407:44410:2299:931:2409:43045",
	"1572:41321:41322:41325:2835:8018:12596:37888",
	"1572:41321:41322:41323",
	"1572:41321:41322",
	"1572:41321:41322:41325",
	"1572:41321",
	"1572:2941:352:42983",
	"1572:2941:352:523:42426",
	"1572:2941:352:42406",
	"44407:44410:2299:931:43000",
	"44407:44410:2299:931:2409:43045:43042",
	"44407:44410:2299:931:2409:43045:43042:43043",
	"44407:44410:2299:43086:43072",
	"44407:44410:2299:43086:43087",
	"44407:44410:2299:43086",
	"44407:44410:2299:931:43088",
	"44407:44410:2299:931:43371",
	"1572:41321:41322:41325:2835:43570",
	"1572:43702:43701",
	"1572:43702",
	"44407:44410:2299:931:2409:43697",
	"1572:41321:41322:41325:2835:43570:12617:44231",
	"44407:44409",
	"44407:44410",
	"1572:41321:41322:41325:2835:8018:46006",
	"1572:41321:41322:41325:2835:8018:46006:46011",
	"1572:XY-2626314551",
	"1572:XY-2626314551:47147:47118",
	"1572:XY-2626314551:47147",
	"1572:XY-2626314551:47147:47154",
	"1572:XY-2626314551:47155",
	"1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"1572:2941:47927",
	"1572:2941:47927:48318",
	"44407:44410:2299:48321",
	"44407:44410:2299:43086:43087:85731",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Farstrider Lodge, Loch Modan",
	["m"] = 48,
	["coord"] = 3517686770,
	["direct"] = "1572:44407",
	["f"] = 0,
	},
	[238480] = {
	"244537:47875:46011:12596:1573:2941:352",
	"244537:47875:46011:12596:1573:2941:352:523",
	"12617:44407:44410:2299:931",
	"244537:47875:46011:12596:1573",
	"12617:43570:2835:1571",
	"12617:43570:2835:1572",
	"12617:44407:44410:2299:931:2409",
	"12617:43570:2835",
	"12617:44407:44410:2299:931:2409:43045:2859",
	"12617:8018",
	"244537:47875:46011:12596",
	"12617:44407:44410:2299",
	"244537:47875:46011:12596:1573:2941",
	"244537:47875:44233",
	"12617:44230:28621",
	"12617:44230",
	"12617:44231:44232",
	"12617:44407:44410:2299:931:2409:43045",
	"244537:47875:46011:37888",
	"12617:43570:2835:41325:41323",
	"12617:43570:2835:41325:41322",
	"12617:43570:2835:41325",
	"12617:43570:2835:41325:41322:41321",
	"12617:43570:2835:1572:41332",
	"244537:47875:46011:12596:1573:2941:352:42983",
	"244537:47875:46011:12596:1573:2941:352:523:42426",
	"244537:47875:46011:12596:1573:2941:352:42406",
	"12617:44407:44410:2299:931:43000",
	"12617:44407:44410:2299:931:2409:43045:43042",
	"12617:44407:44410:2299:931:2409:43045:43042:43043",
	"12617:44407:44410:2299:43086:43072",
	"12617:44407:44410:2299:43086:43087",
	"12617:44407:44410:2299:43086",
	"12617:44407:44410:2299:931:43088",
	"12617:44407:44410:2299:931:43371",
	"12617:43570",
	"244537:47875:46011:12596:1573:43701",
	"244537:47875:46011:12596:1573:43702",
	"12617:44407:44410:2299:931:2409:43697",
	"12617:44231",
	"12617:44407:44409",
	"12617:44407:44410",
	"12617:44407",
	"244537:47875:46011:46006",
	"244537:47875:46011",
	"12617:43570:2835:1572:XY-2626314551",
	"12617:43570:2835:1572:XY-2626314551:47147:47118",
	"12617:43570:2835:1572:XY-2626314551:47147",
	"12617:43570:2835:1572:XY-2626314551:47147:47154",
	"12617:43570:2835:1572:XY-2626314551:47155",
	"244537:47875",
	"244537:47875:46011:12596:1573:2941:47927",
	"244537:47875:46011:12596:1573:2941:47927:48318",
	"12617:44407:44410:2299:48321",
	"12617:44407:44410:2299:43086:43087:85731",
	"241031:251081:242011",
	"242913:239639:246560",
	"241031:249150",
	"241031:241036",
	"241031:251081",
	"241031:251073",
	"242913:239639",
	--["name"] = "Tranquillien, Eversong Woods",
	["m"] = 2395,
	["f"] = 0,
	["direct"] = "12617:241031:242913",
	["coord"] = 2053680111,
	},
	[241036] = {
	"241031:238480:244537:47875:46011:12596:1573:2941:352",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:523",
	"241031:238480:12617:44407:44410:2299:931",
	"241031:238480:244537:47875:46011:12596:1573",
	"241031:238480:12617:43570:2835:1571",
	"241031:238480:12617:43570:2835:1572",
	"241031:238480:12617:44407:44410:2299:931:2409",
	"241031:238480:12617:43570:2835",
	"241031:238480:12617:44407:44410:2299:931:2409:43045:2859",
	"241031:238480:12617:8018",
	"241031:238480:244537:47875:46011:12596",
	"241031:238480:12617",
	"241031:238480:12617:44407:44410:2299",
	"241031:238480:244537:47875:46011:12596:1573:2941",
	"241031:238480:244537:47875:44233",
	"241031:238480:12617:44230:28621",
	"241031:238480:12617:44230",
	"241031:238480:12617:44231:44232",
	"241031:238480:12617:44407:44410:2299:931:2409:43045",
	"241031:238480:244537:47875:46011:37888",
	"241031:238480:12617:43570:2835:41325:41323",
	"241031:238480:12617:43570:2835:41325:41322",
	"241031:238480:12617:43570:2835:41325",
	"241031:238480:12617:43570:2835:41325:41322:41321",
	"241031:238480:12617:43570:2835:1572:41332",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:42983",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:523:42426",
	"241031:238480:244537:47875:46011:12596:1573:2941:352:42406",
	"241031:238480:12617:44407:44410:2299:931:43000",
	"241031:238480:12617:44407:44410:2299:931:2409:43045:43042",
	"241031:238480:12617:44407:44410:2299:931:2409:43045:43042:43043",
	"241031:238480:12617:44407:44410:2299:43086:43072",
	"241031:238480:12617:44407:44410:2299:43086:43087",
	"241031:238480:12617:44407:44410:2299:43086",
	"241031:238480:12617:44407:44410:2299:931:43088",
	"241031:238480:12617:44407:44410:2299:931:43371",
	"241031:238480:12617:43570",
	"241031:238480:244537:47875:46011:12596:1573:43701",
	"241031:238480:244537:47875:46011:12596:1573:43702",
	"241031:238480:12617:44407:44410:2299:931:2409:43697",
	"241031:238480:12617:44231",
	"241031:238480:12617:44407:44409",
	"241031:238480:12617:44407:44410",
	"241031:238480:12617:44407",
	"241031:238480:244537:47875:46011:46006",
	"241031:238480:244537:47875:46011",
	"241031:238480:12617:43570:2835:1572:XY-2626314551",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47147:47118",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47147",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47147:47154",
	"241031:238480:12617:43570:2835:1572:XY-2626314551:47155",
	"241031:238480:244537:47875",
	"241031:238480:244537:47875:46011:12596:1573:2941:47927",
	"241031:238480:244537:47875:46011:12596:1573:2941:47927:48318",
	"241031:238480:12617:44407:44410:2299:48321",
	"241031:238480:12617:44407:44410:2299:43086:43087:85731",
	"251081:242011",
	"241031:238480:242913:239639:246560",
	"241031:251073",
	"241031:238480:242913:239639",
	"241031:238480:242913",
	"241031:238480",
	--["name"] = "Amani'Zar Village, Zul'Aman",
	["m"] = 2437,
	["f"] = 0,
	["direct"] = "249150:241031:251081",
	["coord"] = 1924704132,
	},
	[2835] = {
	"1572:2941:352",
	"1572:2941:352:523",
	"1572:44409:44410:2299:931",
	"1572:44409:44410:2299:931:2409",
	"1572:2941:352:2859",
	"8018:12596",
	"43570:12617",
	"1572:44409:44410:2299",
	"1572:2941",
	"43570:12617:44230:44233",
	"43570:12617:44230:28621",
	"43570:12617:44230",
	"43570:12617:44231:44232",
	"1572:2941:352:43045",
	"8018:12596:37888",
	"41325:41323",
	"41325:41322",
	"41325:41322:41321",
	"1572:41332",
	"1572:2941:352:42983",
	"1572:2941:352:523:42426",
	"1572:2941:352:42406",
	"1572:44409:44410:2299:931:43000",
	"1572:2941:352:43045:43042",
	"1572:2941:352:43045:43042:43043",
	"1572:44409:44410:2299:43086:43072",
	"1572:44409:44410:2299:43086:43087",
	"1572:44409:44410:2299:43086",
	"1572:44409:44410:2299:931:43088",
	"1572:44409:44410:2299:931:43371",
	"1571:1573:43701",
	"1572:43702",
	"1572:2941:352:523:43697",
	"43570:12617:44231",
	"1572:44409",
	"1572:44409:44410",
	"1572:44409:44407",
	"8018:46006",
	"8018:46006:46011",
	"1572:XY-2626314551",
	"1572:XY-2626314551:47147:47118",
	"1572:XY-2626314551:47147",
	"1572:XY-2626314551:47147:47154",
	"1572:XY-2626314551:47155",
	"8018:46006:46011:47875",
	"1572:2941:47927",
	"1572:2941:47927:48318",
	"1572:2941:47927:48318:48321",
	"1572:44409:44410:2299:43086:43087:85731",
	"43570:12617:238480:241031:251081:242011",
	"43570:12617:238480:242913:239639:246560",
	"43570:12617:238480:241031:249150",
	"43570:12617:238480:241031:241036",
	"43570:12617:238480:241031",
	"43570:12617:238480:241031:251081",
	"43570:12617:238480:241031:251073",
	"43570:12617:238480:242913:239639",
	"43570:12617:238480:242913",
	"43570:12617:238480",
	--["name"] = "Refuge Pointe, Arathi",
	["m"] = 14,
	["coord"] = 1714518352,
	["direct"] = "1573:1571:1572:8018:41325:43570",
	["f"] = 0,
	},
	[2299] = {
	"931:523",
	"2941:1573",
	"44410:44409:1572:1571",
	"44410:44409:1572",
	"931:2409",
	"44410:44409:1572:41321:41322:41325:2835",
	"931:2409:43045:2859",
	"44410:44409:1572:41321:41322:41325:2835:8018",
	"44410:44409:1572:41321:41322:41325:2835:8018:12596",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:44230",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232",
	"931:2409:43045",
	"44410:44409:1572:41321:41322:41325:2835:8018:12596:37888",
	"44410:44409:1572:41321:41322:41323",
	"44410:44409:1572:41321:41322",
	"44410:44409:1572:41321:41322:41325",
	"44410:44409:1572:41321",
	"44410:44407:41332",
	"931:43000:42983",
	"931:523:42426",
	"352:42406",
	"931:43000",
	"931:2409:43045:43042",
	"931:2409:43045:43042:43043",
	"43086:43072",
	"43086:43087",
	"931:43088",
	"931:43371",
	"44410:44409:1572:41321:41322:41325:2835:43570",
	"44410:44409:1572:43702:43701",
	"44410:44409:1572:43702",
	"931:2409:43697",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:44231",
	"44410:44409",
	"44410:44407",
	"44410:44409:1572:41321:41322:41325:2835:8018:46006",
	"44410:44409:1572:41321:41322:41325:2835:8018:46006:46011",
	"44410:44409:1572:XY-2626314551",
	"44410:44409:1572:XY-2626314551:47147:47118",
	"44410:44409:1572:XY-2626314551:47147",
	"44410:44409:1572:XY-2626314551:47147:47154",
	"44410:44409:1572:XY-2626314551:47155",
	"44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875",
	"48321:48318:47927",
	"48321:48318",
	"43086:43087:85731",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"44410:44409:1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Morgan's Vigil, Burning Steppes",
	["m"] = 36,
	["f"] = 0,
	["direct"] = "352:931:2941:43086:44410:48321",
	["coord"] = 3098257440,
	},
	[242913] = {
	"238480:244537:47875:46011:12596:1573:2941:352",
	"238480:244537:47875:46011:12596:1573:2941:352:523",
	"238480:12617:44407:44410:2299:931",
	"238480:244537:47875:46011:12596:1573",
	"238480:12617:43570:2835:1571",
	"238480:12617:43570:2835:1572",
	"238480:12617:44407:44410:2299:931:2409",
	"238480:12617:43570:2835",
	"238480:12617:44407:44410:2299:931:2409:43045:2859",
	"238480:12617:8018",
	"238480:244537:47875:46011:12596",
	"238480:12617",
	"238480:12617:44407:44410:2299",
	"238480:244537:47875:46011:12596:1573:2941",
	"238480:244537:47875:44233",
	"238480:12617:44230:28621",
	"238480:12617:44230",
	"238480:12617:44231:44232",
	"238480:12617:44407:44410:2299:931:2409:43045",
	"238480:244537:47875:46011:37888",
	"238480:12617:43570:2835:41325:41323",
	"238480:12617:43570:2835:41325:41322",
	"238480:12617:43570:2835:41325",
	"238480:12617:43570:2835:41325:41322:41321",
	"238480:12617:43570:2835:1572:41332",
	"238480:244537:47875:46011:12596:1573:2941:352:42983",
	"238480:244537:47875:46011:12596:1573:2941:352:523:42426",
	"238480:244537:47875:46011:12596:1573:2941:352:42406",
	"238480:12617:44407:44410:2299:931:43000",
	"238480:12617:44407:44410:2299:931:2409:43045:43042",
	"238480:12617:44407:44410:2299:931:2409:43045:43042:43043",
	"238480:12617:44407:44410:2299:43086:43072",
	"238480:12617:44407:44410:2299:43086:43087",
	"238480:12617:44407:44410:2299:43086",
	"238480:12617:44407:44410:2299:931:43088",
	"238480:12617:44407:44410:2299:931:43371",
	"238480:12617:43570",
	"238480:244537:47875:46011:12596:1573:43701",
	"238480:244537:47875:46011:12596:1573:43702",
	"238480:12617:44407:44410:2299:931:2409:43697",
	"238480:12617:44231",
	"238480:12617:44407:44409",
	"238480:12617:44407:44410",
	"238480:12617:44407",
	"238480:244537:47875:46011:46006",
	"238480:244537:47875:46011",
	"238480:12617:43570:2835:1572:XY-2626314551",
	"238480:12617:43570:2835:1572:XY-2626314551:47147:47118",
	"238480:12617:43570:2835:1572:XY-2626314551:47147",
	"238480:12617:43570:2835:1572:XY-2626314551:47147:47154",
	"238480:12617:43570:2835:1572:XY-2626314551:47155",
	"238480:244537:47875",
	"238480:244537:47875:46011:12596:1573:2941:47927",
	"238480:244537:47875:46011:12596:1573:2941:47927:48318",
	"238480:12617:44407:44410:2299:48321",
	"238480:12617:44407:44410:2299:43086:43087:85731",
	"251073:242011",
	"239639:246560",
	"238480:241031:249150",
	"238480:241031:241036",
	"238480:241031",
	"251073:251081",
	--["name"] = "Fairbreeze Village, Eversong Woods",
	["m"] = 2395,
	["f"] = 0,
	["direct"] = "251073:239639:238480",
	["coord"] = 1918006081,
	},
	[2941] = {
	"352:523",
	"2299:931",
	"1573:1571",
	"2299:931:2409",
	"1572:41321:41322:41325:2835",
	"352:2859",
	"1572:41321:41322:41325:2835:8018",
	"1573:12596",
	"1572:41321:41322:41325:2835:43570:12617",
	"1572:41321:41322:41325:2835:43570:12617:44230:44233",
	"1572:41321:41322:41325:2835:43570:12617:44230:28621",
	"1572:41321:41322:41325:2835:43570:12617:44230",
	"1573:12596:37888:44232",
	"352:43045",
	"1573:12596:37888",
	"1572:41321:41322:41323",
	"1572:41321:41322",
	"1572:41321:41322:41325",
	"1572:41321",
	"1572:41332",
	"352:42983",
	"352:523:42426",
	"352:42406",
	"2299:931:43000",
	"352:43045:43042",
	"352:43045:43042:43043",
	"2299:43086:43072",
	"2299:43086:43087",
	"2299:43086",
	"2299:931:43088",
	"2299:931:43371",
	"1572:41321:41322:41325:2835:43570",
	"1573:43701",
	"1572:43702",
	"352:523:43697",
	"1572:41321:41322:41325:2835:43570:12617:44231",
	"1572:44409",
	"2299:44410",
	"1572:44409:44407",
	"1573:12596:46006",
	"1573:12596:46011",
	"1572:XY-2626314551",
	"1572:XY-2626314551:47147:47118",
	"1572:XY-2626314551:47147",
	"1572:XY-2626314551:47147:47154",
	"1572:XY-2626314551:47155",
	"1573:12596:46011:47875",
	"47927:48318",
	"47927:48318:48321",
	"2299:43086:43087:85731",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:251081:242011",
	"1572:41321:41322:41325:2835:43570:12617:238480:242913:239639:246560",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:249150",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:241036",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:251081",
	"1572:41321:41322:41325:2835:43570:12617:238480:241031:251073",
	"1572:41321:41322:41325:2835:43570:12617:238480:242913:239639",
	"1572:41321:41322:41325:2835:43570:12617:238480:242913",
	"1572:41321:41322:41325:2835:43570:12617:238480",
	--["name"] = "Thorium Point, Searing Gorge",
	["m"] = 32,
	["coord"] = 1630359272,
	["direct"] = "352:1573:1572:2299:47927",
	["f"] = 0,
	},
	[1573] = {
	"2941:352:523",
	"2941:2299:931",
	"2941:2299:931:2409",
	"2941:352:2859",
	"2941:2299",
	"12596:46011:47875:44233",
	"12617:44230:28621",
	"12617:44230",
	"12596:37888:44232",
	"2941:352:43045",
	"12596:37888",
	"1571:41323",
	"1571:41323:41322",
	"1571:41323:41325",
	"1572:41321",
	"1572:41332",
	"2941:352:42983",
	"2941:352:523:42426",
	"2941:352:42406",
	"2941:2299:931:43000",
	"2941:352:43045:43042",
	"2941:352:43045:43042:43043",
	"2941:2299:43086:43072",
	"2941:2299:43086:43087",
	"2941:2299:43086",
	"2941:2299:931:43088",
	"2941:2299:931:43371",
	"2835:43570",
	"2941:352:523:43697",
	"12617:44231",
	"1572:44409",
	"1572:44409:44410",
	"1572:44409:44407",
	"12596:46006",
	"12596:46011",
	"1572:XY-2626314551",
	"1572:XY-2626314551:47147:47118",
	"1572:XY-2626314551:47147",
	"1572:XY-2626314551:47147:47154",
	"1572:XY-2626314551:47155",
	"12596:46011:47875",
	"2941:47927",
	"2941:47927:48318",
	"2941:47927:48318:48321",
	"2941:2299:43086:43087:85731",
	"12617:238480:241031:251081:242011",
	"12617:238480:242913:239639:246560",
	"12617:238480:241031:249150",
	"12617:238480:241031:241036",
	"12617:238480:241031",
	"12617:238480:241031:251081",
	"12617:238480:241031:251073",
	"12617:238480:242913:239639",
	"12617:238480:242913",
	"12617:238480",
	--["name"] = "Ironforge, Dun Morogh",
	["m"] = 87,
	["coord"] = 2400090763,
	["direct"] = "352:1571:1572:2835:8018:12596:12617:2941:43701:43702",
	["f"] = 0,
	},
	},
	{
		[22485] = {
			"18788:18785:16822", -- [1]
			"18788:18785", -- [2]
			"18788:18789", -- [3]
			"18788:18940:18809", -- [4]
			"18937:18938", -- [5]
			"18788:18940:18809:18939", -- [6]
			"18788:18940", -- [7]
			"18788:18785:16822:18931", -- [8]
			"18937:19583", -- [9]
			"18788:18940:18809:18939:19581", -- [10]
			"18788:18785:16822:20234", -- [11]
			"18937:18938:20515", -- [12]
			"18788:21107", -- [13]
			"18937:22216", -- [14]
			["direct"] = "18788:18937",
			["coord"] = 1773488635,
			["m"] = 102,
			["f"] = 0,
		},
		[21107] = {
			"18788:18785:16822", -- [1]
			"18788:18785", -- [2]
			"18788:18789", -- [3]
			"18788:18940:18809", -- [4]
			"18788:18940:18809:18939", -- [5]
			"18788:18940", -- [6]
			"18788:18785:16822:18931", -- [7]
			"18938:19583", -- [8]
			"18788:18940:18809:18939:19581", -- [9]
			"18788:18785:16822:20234", -- [10]
			"18938:20515", -- [11]
			"18788:22485", -- [12]
			["direct"] = "18788:18938:18937:22216",
			["coord"] = 2623648913,
			["m"] = 105,
			["f"] = 0,
		},
		[18938] = {
			"21107:18788:18785:16822", -- [1]
			"21107:18788:18785", -- [2]
			"21107:18788", -- [3]
			"21107:18788:18789", -- [4]
			"21107:18788:18940:18809", -- [5]
			"21107:18788:18940:18809:18939", -- [6]
			"21107:18788:18940", -- [7]
			"21107:18788:18785:16822:18931", -- [8]
			"21107:18788:18940:18809:18939:19581", -- [9]
			"21107:18788:18785:16822:20234", -- [10]
			"18937:22485", -- [11]
			["direct"] = "18937:19583:20515:21107:22216",
			["coord"] = 1451467664,
			["m"] = 109,
			["f"] = 0,
		},
		[18939] = {
			"18809:16822", -- [1]
			"18809:16822:18785", -- [2]
			"18809:18940:18788", -- [3]
			"18809:18789", -- [4]
			"18809:18940:18788:21107:18938", -- [5]
			"18809:18940:18788:18937", -- [6]
			"18809:18940", -- [7]
			"18809:16822:18931", -- [8]
			"18809:18940:18788:21107:18938:19583", -- [9]
			"18809:16822:20234", -- [10]
			"18809:18940:18788:21107:18938:20515", -- [11]
			"18809:18940:18788:21107", -- [12]
			"18809:18940:18788:21107:22216", -- [13]
			"18809:18940:18788:22485", -- [14]
			["direct"] = "18809:19581",
			["coord"] = 1615302149,
			["m"] = 104,
			["f"] = 0,
		},
		[18940] = {
			"18788:18785", -- [1]
			"18788:21107:18938", -- [2]
			"18809:18939", -- [3]
			"18788:18937", -- [4]
			"16822:18931", -- [5]
			"18788:21107:18938:19583", -- [6]
			"18809:18939:19581", -- [7]
			"16822:20234", -- [8]
			"18788:21107:18938:20515", -- [9]
			"18788:21107", -- [10]
			"18788:21107:22216", -- [11]
			"18788:22485", -- [12]
			["direct"] = "16822:18788:18789:18809",
			["coord"] = 2743757380,
			["m"] = 111,
			["f"] = 0,
		},
		[18788] = {
			"18785:16822", -- [1]
			"18940:18809", -- [2]
			"21107:18938", -- [3]
			"18940:18809:18939", -- [4]
			"18785:16822:18931", -- [5]
			"21107:18938:19583", -- [6]
			"18940:18809:18939:19581", -- [7]
			"18785:16822:20234", -- [8]
			"21107:18938:20515", -- [9]
			"21107:22216", -- [10]
			["direct"] = "18785:18789:18937:18940:21107:22485",
			["f"] = 0,
			["m"] = 102,
			["coord"] = 2914485116,
		},
		[18789] = {
			"18940:16822", -- [1]
			"18788:18785", -- [2]
			"18788:21107:18938", -- [3]
			"18809:18939", -- [4]
			"18788:18937", -- [5]
			"18940:16822:18931", -- [6]
			"18788:21107:18938:19583", -- [7]
			"18809:18939:19581", -- [8]
			"18940:16822:20234", -- [9]
			"18788:21107:18938:20515", -- [10]
			"18788:21107", -- [11]
			"18788:21107:22216", -- [12]
			"18788:22485", -- [13]
			["direct"] = "18788:18809:18940",
			["coord"] = 2325856347,
			["m"] = 107,
			["f"] = 0,
		},
		[16822] = {
			"18785:18788", -- [1]
			"18940:18789", -- [2]
			"18785:18788:21107:18938", -- [3]
			"18809:18939", -- [4]
			"18785:18788:18937", -- [5]
			"18785:18788:21107:18938:19583", -- [6]
			"18809:18939:19581", -- [7]
			"18785:18788:21107:18938:20515", -- [8]
			"18785:18788:21107", -- [9]
			"18785:18788:21107:22216", -- [10]
			"18785:18788:22485", -- [11]
			["direct"] = "18785:18809:18940:18931:20234",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 2347147235,
		},
		[22216] = {
			"21107:18788:18785:16822", -- [1]
			"21107:18788:18785", -- [2]
			"21107:18788", -- [3]
			"21107:18788:18789", -- [4]
			"21107:18788:18940:18809", -- [5]
			"21107:18788:18940:18809:18939", -- [6]
			"21107:18788:18940", -- [7]
			"21107:18788:18785:16822:18931", -- [8]
			"18938:19583", -- [9]
			"21107:18788:18940:18809:18939:19581", -- [10]
			"21107:18788:18785:16822:20234", -- [11]
			"18938:20515", -- [12]
			"18937:22485", -- [13]
			["direct"] = "18938:18937:21107",
			["coord"] = 2648008034,
			["m"] = 105,
			["f"] = 0,
		},
		[18931] = {
			"18785:18788", -- [1]
			"16822:18940:18789", -- [2]
			"16822:18809", -- [3]
			"18785:18788:21107:18938", -- [4]
			"16822:18809:18939", -- [5]
			"18785:18788:18937", -- [6]
			"16822:18940", -- [7]
			"18785:18788:21107:18938:19583", -- [8]
			"16822:18809:18939:19581", -- [9]
			"18785:18788:21107:18938:20515", -- [10]
			"18785:18788:21107", -- [11]
			"18785:18788:21107:22216", -- [12]
			"18785:18788:22485", -- [13]
			["direct"] = "16822:18785:20234",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 3755968055,
		},
		[19583] = {
			"18938:21107:18788:18785:16822", -- [1]
			"18938:21107:18788:18785", -- [2]
			"18938:21107:18788", -- [3]
			"18938:21107:18788:18789", -- [4]
			"18938:21107:18788:18940:18809", -- [5]
			"18938:21107:18788:18940:18809:18939", -- [6]
			"18938:21107:18788:18940", -- [7]
			"18938:21107:18788:18785:16822:18931", -- [8]
			"18938:21107:18788:18940:18809:18939:19581", -- [9]
			"18938:21107:18788:18785:16822:20234", -- [10]
			"18938:21107", -- [11]
			"18938:22216", -- [12]
			"18937:22485", -- [13]
			["direct"] = "18938:18937:20515",
			["f"] = 0,
			["m"] = 109,
			["coord"] = 1944213875,
		},
		[20234] = {
			"16822:18785", -- [1]
			"16822:18785:18788", -- [2]
			"16822:18940:18789", -- [3]
			"16822:18809", -- [4]
			"16822:18785:18788:21107:18938", -- [5]
			"16822:18809:18939", -- [6]
			"16822:18785:18788:18937", -- [7]
			"16822:18940", -- [8]
			"16822:18785:18788:21107:18938:19583", -- [9]
			"16822:18809:18939:19581", -- [10]
			"16822:18785:18788:21107:18938:20515", -- [11]
			"16822:18785:18788:21107", -- [12]
			"16822:18785:18788:21107:22216", -- [13]
			"16822:18785:18788:22485", -- [14]
			["direct"] = "16822:18931",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 3370277268,
		},
		[18937] = {
			"18788:18785:16822", -- [1]
			"18788:18785", -- [2]
			"18788:18789", -- [3]
			"18788:18940:18809", -- [4]
			"18788:18940:18809:18939", -- [5]
			"18788:18940", -- [6]
			"18788:18785:16822:18931", -- [7]
			"18788:18940:18809:18939:19581", -- [8]
			"18788:18785:16822:20234", -- [9]
			"18938:20515", -- [10]
			["direct"] = "18788:18938:19583:21107:22216:22485",
			["f"] = 0,
			["m"] = 105,
			["coord"] = 1624087928,
		},
		[18809] = {
			"16822:18785", -- [1]
			"18940:18788", -- [2]
			"18940:18788:21107:18938", -- [3]
			"18940:18788:18937", -- [4]
			"16822:18931", -- [5]
			"18940:18788:21107:18938:19583", -- [6]
			"18939:19581", -- [7]
			"16822:20234", -- [8]
			"18940:18788:21107:18938:20515", -- [9]
			"18940:18788:21107", -- [10]
			"18940:18788:21107:22216", -- [11]
			"18940:18788:22485", -- [12]
			["direct"] = "16822:18789:18939:18940",
			["coord"] = 2554891688,
			["m"] = 108,
			["f"] = 0,
		},
		[18785] = {
			"18788:18789", -- [1]
			"16822:18809", -- [2]
			"18788:21107:18938", -- [3]
			"16822:18809:18939", -- [4]
			"18788:18937", -- [5]
			"18788:18940", -- [6]
			"16822:18931", -- [7]
			"18788:21107:18938:19583", -- [8]
			"16822:18809:18939:19581", -- [9]
			"16822:20234", -- [10]
			"18788:21107:18938:20515", -- [11]
			"18788:21107", -- [12]
			"18788:21107:22216", -- [13]
			"18788:22485", -- [14]
			["direct"] = "16822:18788",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 1079467854,
		},
		[20515] = {
			"18938:21107:18788:18785:16822", -- [1]
			"18938:21107:18788:18785", -- [2]
			"18938:21107:18788", -- [3]
			"18938:21107:18788:18789", -- [4]
			"18938:21107:18788:18940:18809", -- [5]
			"18938:21107:18788:18940:18809:18939", -- [6]
			"18938:18937", -- [7]
			"18938:21107:18788:18940", -- [8]
			"18938:21107:18788:18785:16822:18931", -- [9]
			"18938:21107:18788:18940:18809:18939:19581", -- [10]
			"18938:21107:18788:18785:16822:20234", -- [11]
			"18938:21107", -- [12]
			"18938:22216", -- [13]
			"18938:18937:22485", -- [14]
			["m"] = 109,
			["f"] = 0,
			["direct"] = "18938:19583",
			["coord"] = 2800462568,
		},
		[19581] = {
			"18939:18809:16822", -- [1]
			"18939:18809:16822:18785", -- [2]
			"18939:18809:18940:18788", -- [3]
			"18939:18809:18789", -- [4]
			"18939:18809", -- [5]
			"18939:18809:18940:18788:21107:18938", -- [6]
			"18939:18809:18940:18788:18937", -- [7]
			"18939:18809:18940", -- [8]
			"18939:18809:16822:18931", -- [9]
			"18939:18809:18940:18788:21107:18938:19583", -- [10]
			"18939:18809:16822:20234", -- [11]
			"18939:18809:18940:18788:21107:18938:20515", -- [12]
			"18939:18809:18940:18788:21107", -- [13]
			"18939:18809:18940:18788:21107:22216", -- [14]
			"18939:18809:18940:18788:22485", -- [15]
			["direct"] = "18939",
			["coord"] = 2718322169,
			["m"] = 104,
			["f"] = 0,
		},
	}, -- [3]
	{
		[29750] = {
			"30433:28674:23736", -- [1]
			"29721:28615:28623:26876:24061", -- [2]
			"29721:28615:26878:23859", -- [3]
			"30433:28674:26879:24795:27046", -- [4]
			"29721:28615:26878", -- [5]
			"30433:28674:26879", -- [6]
			"30433:28674:28574:26602", -- [7]
			"30433:28674:26877:26881", -- [8]
			"30433:28674:26877", -- [9]
			"29721:28615:26851", -- [10]
			"29721:28615:28618:26880", -- [11]
			"29721:28615:28623:26876", -- [12]
			"30433:28674:26879:24795", -- [13]
			"30433:28674:28196", -- [14]
			"29721:28615:26878:23859:28197", -- [15]
			"30433:28674:26877:26881:28195", -- [16]
			"30433:31069:30869", -- [17]
			"29721:28615:28623", -- [18]
			"29721:28615", -- [19]
			"29721:28615:28618", -- [20]
			"29721:28615:28623:28624", -- [21]
			"30433:28674:28574", -- [22]
			"30433:28674:28574:28037", -- [23]
			"30433:28674", -- [24]

			"29721:32571", -- [25]
			"30433:31069:31078", -- [26]
			"29721:28615:28623:28624:30569", -- [27]
			"29950:30314", -- [28]
			"30433:31069", -- [29]
			"29721:30271", -- [30]
			"29950:33849", -- [31]
			["direct"] = "29721:29951:29950:30433",
			["coord"] = 1267777152,
			["m"] = 120,
			["f"] = 0,
		},
		[26602] = {
			"28195:28196:28197:23736", -- [1]
			"26881:26878:26880:24061", -- [2]
			"26881:26878:23859", -- [3]
			"24795:27046", -- [4]
			"26881:26878", -- [5]
			"26881:26877", -- [6]
			"26881:26851", -- [7]
			"26881:26878:26880", -- [8]
			"26881:26878:26880:26876", -- [9]
			"28195:28196", -- [10]
			"28195:28196:28197", -- [11]
			"26881:30869", -- [12]
			"26881:26878:28615:28623", -- [13]
			"26881:26878:28615", -- [14]
			"26881:26878:28618", -- [15]
			"26881:26878:28615:28623:28624", -- [16]
			"28574:28674", -- [17]
			"28574:28674:29721", -- [18]
			"28574:28674:30433:29750", -- [19]
			"28574:28674:29721:32571", -- [20]
			"28574:31078", -- [21]
			"28574:31078:30314:29950:29951", -- [22]
			"28574:31078:30314:29950", -- [23]
			"26881:26878:28615:28623:28624:30569", -- [24]
			"28574:31078:30314", -- [25]
			"28574:28674:30433", -- [26]
			"28574:28674:31069", -- [27]
			"28574:28674:30271", -- [28]
			"28574:31078:30314:33849", -- [29]
			["m"] = 114,
			["f"] = 0,
			["direct"] = "26879:26881:24795:28195:28574:28037",
			["coord"] = 2427204436,
		},
		[31078] = {
			"30869:26877:26878:23859:23736", -- [1]
			"30869:26877:26878:26880:24061", -- [2]
			"30869:26877:26878:23859", -- [3]
			"28574:26602:24795:27046", -- [4]
			"30869:26877:26878", -- [5]
			"28574:26602:26879", -- [6]
			"28574:26602", -- [7]
			"30869:26881", -- [8]
			"30869:26877", -- [9]
			"30869:26877:26851", -- [10]
			"30869:26877:26878:26880", -- [11]
			"31069:30433:28674:28615:28623:26876", -- [12]
			"28574:26602:24795", -- [13]
			"30869:26881:28196", -- [14]
			"30869:26877:26878:23859:28197", -- [15]
			"28574:26602:28195", -- [16]
			"31069:30433:28674:28615:28623", -- [17]
			"31069:30433:28674:28615", -- [18]
			"31069:30433:28674:28615:28618", -- [19]
			"30314:29950:29951:28624", -- [20]
			"31069:30433:28674", -- [21]
			"31069:30433:28674:29721", -- [22]
			"31069:30433:29750", -- [23]
			"30314:29950:29951:32571", -- [24]
			"30314:29950:29951", -- [25]
			"30314:29950", -- [26]
			"30314:29950:29951:28624:30569", -- [27]
			"31069:30433", -- [28]
			"31069:30433:28674:30271", -- [29]
			"30314:33849", -- [30]
			["direct"] = "30869:28574:28037:30314:31069",
			["coord"] = 832469612,
			["m"] = 118,
			["f"] = 0,
		},
		[28623] = {
			"26876:24061:23736", -- [1]
			"26876:24061", -- [2]
			"28618:26880:23859", -- [3]
			"28615:26851:26881:26602:24795:27046", -- [4]
			"28618:26878", -- [5]
			"28615:26851:26881:26879", -- [6]
			"28615:26851:26881:26602", -- [7]
			"28615:26851:26881", -- [8]
			"28615:26877", -- [9]
			"28615:26851", -- [10]
			"28618:26880", -- [11]
			"28615:26851:26881:26602:24795", -- [12]
			"28615:26851:28196", -- [13]
			"28618:26880:23859:28197", -- [14]
			"28615:26851:26881:28195", -- [15]
			"28615:26877:30869", -- [16]
			"28615:28674:28574", -- [17]
			"28615:28674:28574:28037", -- [18]
			"28615:28674", -- [19]
			"28615:29721", -- [20]
			"28615:29721:29750", -- [21]
			"28624:32571", -- [22]
			"28615:28674:31069:31078", -- [23]
			"28624:29951", -- [24]
			"28615:29721:29750:29950", -- [25]
			"28624:30569", -- [26]
			"28615:28674:31069:30314", -- [27]
			"28615:28674:30433", -- [28]
			"28615:28674:31069", -- [29]
			"28615:30271", -- [30]
			"28615:28674:33849", -- [31]
			["direct"] = "26876:28615:28618:28624",
			["coord"] = 1782293786,
			["m"] = 121,
			["f"] = 0,
		},
		[28624] = {
			"26876:24061:23736", -- [1]
			"26876:24061", -- [2]
			"26876:26880:23859", -- [3]
			"28623:28615:26851:26881:26602:24795:27046", -- [4]
			"28623:28618:26878", -- [5]
			"28623:28615:26851:26881:26879", -- [6]
			"28623:28615:26851:26881:26602", -- [7]
			"28623:28615:26851:26881", -- [8]
			"28623:28615:26877", -- [9]
			"28623:28615:26851", -- [10]
			"26876:26880", -- [11]
			"28623:28615:26851:26881:26602:24795", -- [12]
			"28623:28615:26851:28196", -- [13]
			"26876:26880:23859:28197", -- [14]
			"28623:28615:26851:26881:28195", -- [15]
			"28623:28615:26877:30869", -- [16]
			"28623:28615", -- [17]
			"28623:28618", -- [18]
			"28623:28615:28674:28574", -- [19]
			"28623:28615:28674:28574:28037", -- [20]
			"28623:28615:28674", -- [21]
			"28623:28615:29721", -- [22]
			"28623:28615:29721:29750", -- [23]
			"28623:28615:28674:31069:31078", -- [24]
			"29951:29950", -- [25]
			"29951:29950:30314", -- [26]
			"28623:28615:28674:30433", -- [27]
			"28623:28615:28674:31069", -- [28]
			"28623:28615:30271", -- [29]
			"29951:29950:33849", -- [30]
			["m"] = 121,
			["coord"] = 2575864175,
			["direct"] = "26876:28623:32571:29951:30569",
			["f"] = 0,
		},
		[29950] = {
			"29951:28624:26876:24061:23736", -- [1]
			"29951:28624:26876:24061", -- [2]
			"29750:29721:28615:26878:23859", -- [3]
			"30314:31078:28574:26602:24795:27046", -- [4]
			"29750:29721:28615:26878", -- [5]
			"29750:30433:28674:26879", -- [6]
			"30314:31078:28574:26602", -- [7]
			"29750:30433:28674:26877:26881", -- [8]
			"29750:30433:28674:26877", -- [9]
			"29750:29721:28615:26851", -- [10]
			"29750:29721:28615:28618:26880", -- [11]
			"29951:28624:26876", -- [12]
			"30314:31078:28574:26602:24795", -- [13]
			"29750:30433:28674:28196", -- [14]
			"29750:29721:28615:26878:23859:28197", -- [15]
			"29750:30433:28674:26877:26881:28195", -- [16]
			"33849:31069:30869", -- [17]
			"29750:29721:28615:28623", -- [18]
			"29750:29721:28615", -- [19]
			"29750:29721:28615:28618", -- [20]
			"29951:28624", -- [21]
			"30314:31078:28574", -- [22]
			"30314:31078:28037", -- [23]
			"29750:30433:28674", -- [24]
			"29750:29721", -- [25]
			"29951:32571", -- [26]
			"30314:31078", -- [27]
			"29951:28624:30569", -- [28]
			"29750:30433", -- [29]
			"33849:31069", -- [30]
			"29750:29721:30271", -- [31]
			["direct"] = "29750:29951:30314:33849",
			["coord"] = 1314938152,
			["m"] = 120,
			["f"] = 0,
		},
		[29951] = {
			"28624:26876:24061:23736", -- [1]
			"28624:26876:24061", -- [2]
			"28624:26876:26880:23859", -- [3]
			"29950:30314:31078:28574:26602:24795:27046", -- [4]
			"29750:29721:28615:26878", -- [5]
			"29750:30433:28674:26879", -- [6]
			"29950:30314:31078:28574:26602", -- [7]
			"29750:30433:28674:26877:26881", -- [8]
			"29750:30433:28674:26877", -- [9]
			"29750:29721:28615:26851", -- [10]
			"28624:26876:26880", -- [11]
			"28624:26876", -- [12]
			"29950:30314:31078:28574:26602:24795", -- [13]
			"29750:30433:28674:28196", -- [14]
			"28624:26876:26880:23859:28197", -- [15]
			"29750:30433:28674:26877:26881:28195", -- [16]
			"29750:30433:31069:30869", -- [17]
			"28624:28623", -- [18]
			"29750:29721:28615", -- [19]
			"28624:28623:28618", -- [20]
			"29950:30314:31078:28574", -- [21]
			"29950:30314:31078:28037", -- [22]
			"29750:30433:28674", -- [23]
			"29750:29721", -- [24]
			"29950:30314:31078", -- [25]
			"28624:30569", -- [26]
			"29950:30314", -- [27]
			"29750:30433", -- [28]
			"29750:30433:31069", -- [29]
			"29750:29721:30271", -- [30]
			"29950:33849", -- [31]
			["direct"] = "28624:29750:32571:29950",
			["coord"] = 1911834618,
			["m"] = 120,
			["f"] = 0,
		},
		[30271] = {
			"26878:23859:23736", -- [1]
			"28615:28623:26876:24061", -- [2]
			"26878:23859", -- [3]
			"26878:26881:26602:24795:27046", -- [4]
			"28674:26879", -- [5]
			"26878:26881:26602", -- [6]
			"26878:26881", -- [7]
			"28674:26877", -- [8]
			"26878:26851", -- [9]
			"26878:26880", -- [10]
			"28615:28623:26876", -- [11]
			"26878:26881:26602:24795", -- [12]
			"26878:28196", -- [13]
			"26878:23859:28197", -- [14]
			"26878:26881:28195", -- [15]
			"28674:30869", -- [16]
			"28615:28623", -- [17]
			"28615:28618", -- [18]
			"28615:28623:28624", -- [19]
			"28674:28574", -- [20]
			"28674:28574:28037", -- [21]
			"29721:29750", -- [22]
			"29721:32571", -- [23]
			"28674:31069:31078", -- [24]
			"29721:29750:29951", -- [25]
			"29721:29750:29950", -- [26]
			"28615:28623:28624:30569", -- [27]
			"28674:31069:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"28674:33849", -- [31]
			["direct"] = "26878:28615:28674:29721",
			["coord"] = 3097480930,
			["m"] = 127,
			["f"] = 0,
		},
		[28195] = {
			"28196:28197:23736", -- [1]
			"28196:26878:26880:24061", -- [2]
			"28196:26878:23859", -- [3]
			"26879:24795:27046", -- [4]
			"28196:26878", -- [5]
			"26881:26877", -- [6]
			"28196:26851", -- [7]
			"28196:26878:26880", -- [8]
			"28196:26878:26880:26876", -- [9]
			"26879:24795", -- [10]
			"28196:28197", -- [11]
			"26881:30869", -- [12]
			"28196:26878:28615:28623", -- [13]
			"28196:26878:28615", -- [14]
			"28196:26878:28618", -- [15]
			"28196:26878:28615:28623:28624", -- [16]
			"26602:28574", -- [17]
			"26602:28037", -- [18]
			"28196:28674", -- [19]
			"28196:28674:29721", -- [20]
			"28196:28674:30433:29750", -- [21]
			"28196:28674:29721:32571", -- [22]
			"26602:28574:31078", -- [23]
			"28196:28674:30433:29750:29951", -- [24]
			"28196:28674:30433:29750:29950", -- [25]
			"28196:26878:28615:28623:28624:30569", -- [26]
			"26881:30869:30314", -- [27]
			"28196:28674:30433", -- [28]
			"26881:30869:31069", -- [29]
			"28196:26878:30271", -- [30]
			"28196:28674:33849", -- [31]
			["direct"] = "26879:26602:26881:28196",
			["coord"] = 3371205577,
			["m"] = 114,
			["f"] = 0,
		},
		[28574] = {
			"30869:26877:26878:23859:23736", -- [1]
			"30869:26877:26878:26880:24061", -- [2]
			"30869:26877:26878:23859", -- [3]
			"26602:24795:27046", -- [4]
			"30869:26877:26878", -- [5]
			"26602:26879", -- [6]
			"26602:26881", -- [7]
			"30869:26877", -- [8]
			"30869:26877:26851", -- [9]
			"30869:26877:26878:26880", -- [10]
			"28674:28615:28623:26876", -- [11]
			"26602:24795", -- [12]
			"26602:28195:28196", -- [13]
			"26602:28195:28196:28197", -- [14]
			"26602:28195", -- [15]
			"28674:28615:28623", -- [16]
			"28674:28615", -- [17]
			"28674:28615:28618", -- [18]
			"28674:28615:28623:28624", -- [19]
			"28674:29721", -- [20]
			"28674:30433:29750", -- [21]
			"28674:29721:32571", -- [22]
			"31078:30314:29950:29951", -- [23]
			"31078:30314:29950", -- [24]
			"28674:28615:28623:28624:30569", -- [25]
			"31078:30314", -- [26]
			"28674:30433", -- [27]
			"28674:31069", -- [28]
			"28674:30271", -- [29]
			"31078:30314:33849", -- [30]
			["m"] = 119,
			["f"] = 0,
			["direct"] = "26602:30869:28037:28674:31078",
			["coord"] = 2150407428,
		},
		[24795] = {
			"26602:28195:28196:28197:23736", -- [1]
			"26602:26881:26878:26880:24061", -- [2]
			"26602:26881:26878:23859", -- [3]
			"26602:26881:26878", -- [4]
			"26602:26881", -- [5]
			"26602:26881:26877", -- [6]
			"26602:26881:26851", -- [7]
			"26602:26881:26878:26880", -- [8]
			"26602:26881:26878:26880:26876", -- [9]
			"26602:28195:28196", -- [10]
			"26602:28195:28196:28197", -- [11]
			"26602:28195", -- [12]
			"26602:26881:30869", -- [13]
			"26602:26881:26878:28615:28623", -- [14]
			"26602:26881:26878:28615", -- [15]
			"26602:26881:26878:28618", -- [16]
			"26602:26881:26878:28615:28623:28624", -- [17]
			"26602:28574", -- [18]
			"26602:28037", -- [19]
			"26602:28574:28674", -- [20]
			"26602:28574:28674:29721", -- [21]
			"26602:28574:28674:30433:29750", -- [22]
			"26602:28574:28674:29721:32571", -- [23]
			"26602:28574:31078", -- [24]
			"26602:28574:31078:30314:29950:29951", -- [25]
			"26602:28574:31078:30314:29950", -- [26]
			"26602:26881:26878:28615:28623:28624:30569", -- [27]
			"26602:28574:31078:30314", -- [28]
			"26602:28574:28674:30433", -- [29]
			"26602:28574:28674:31069", -- [30]
			"26602:28574:28674:30271", -- [31]
			"26602:28574:31078:30314:33849", -- [32]
			["direct"] = "27046:26879:26602",
			["coord"] = 1939691395,
			["m"] = 114,
			["f"] = 0,
		},

		[26876] = {
			"24061:23736", -- [1]
			"26880:23859", -- [2]
			"26880:26878:26881:26602:24795:27046", -- [3]
			"26880:26878", -- [4]
			"26880:26878:26881:26879", -- [5]
			"26880:26878:26881:26602", -- [6]
			"26880:26878:26881", -- [7]
			"28623:28615:26877", -- [8]
			"26880:26878:26851", -- [9]
			"26880:26878:26881:26602:24795", -- [10]
			"26880:26878:28196", -- [11]
			"26880:23859:28197", -- [12]
			"26880:26878:26881:28195", -- [13]
			"28623:28615:26877:30869", -- [14]
			"28623:28615", -- [15]
			"28623:28618", -- [16]
			"28623:28615:28674:28574", -- [17]
			"28623:28615:28674:28574:28037", -- [18]
			"28623:28615:28674", -- [19]
			"28623:28615:29721", -- [20]
			"28623:28615:29721:29750", -- [21]
			"28624:32571", -- [22]
			"28623:28615:28674:31069:31078", -- [23]
			"28624:29951", -- [24]
			"28624:29951:29950", -- [25]
			"28624:30569", -- [26]
			"28623:28615:28674:31069:30314", -- [27]
			"28623:28615:28674:30433", -- [28]
			"28623:28615:28674:31069", -- [29]
			"28623:28615:30271", -- [30]
			"28623:28615:28674:33849", -- [31]
			["direct"] = "24061:26880:28623:28624",
			["coord"] = 2572305445,
			["m"] = 116,
			["f"] = 0,
		},
		[26877] = {
			"26878:23859:23736", -- [1]
			"26878:26880:24061", -- [2]
			"26878:23859", -- [3]
			"26881:26602:24795:27046", -- [4]
			"26881:26879", -- [5]
			"26881:26602", -- [6]
			"26878:26880", -- [7]
			"26878:26880:26876", -- [8]
			"26881:26602:24795", -- [9]
			"26851:28196", -- [10]
			"26878:23859:28197", -- [11]
			"26881:28195", -- [12]
			"28615:28623", -- [13]
			"28615:28618", -- [14]
			"28615:28623:28624", -- [15]
			"30869:28574", -- [16]
			"30869:28574:28037", -- [17]
			"28674:29721", -- [18]
			"28674:30433:29750", -- [19]
			"28674:29721:32571", -- [20]
			"30869:31078", -- [21]
			"28674:30433:29750:29951", -- [22]
			"28674:30433:29750:29950", -- [23]
			"28615:28623:28624:30569", -- [24]
			"30869:30314", -- [25]
			"28674:30433", -- [26]
			"28674:31069", -- [27]
			"28674:30271", -- [28]
			"28674:33849", -- [29]
			["m"] = 115,
			["coord"] = 1698185732,
			["direct"] = "26878:26881:26851:30869:28615:28674",
			["f"] = 0,
		},
		[26878] = {
			"23859:23736", -- [1]
			"26880:24061", -- [2]
			"26881:26602:24795:27046", -- [3]
			"26881:26879", -- [4]
			"26881:26602", -- [5]
			"26880:26876", -- [6]
			"26881:26602:24795", -- [7]
			"23859:28197", -- [8]
			"26881:28195", -- [9]
			"26877:30869", -- [10]
			"28615:28623", -- [11]
			"28615:28623:28624", -- [12]
			"26877:30869:28574", -- [13]
			"26881:26602:28037", -- [14]
			"30271:28674", -- [15]
			"28615:29721", -- [16]
			"28615:29721:29750", -- [17]
			"28615:29721:32571", -- [18]
			"26877:30869:31078", -- [19]
			"28615:29721:29750:29951", -- [20]
			"28615:29721:29750:29950", -- [21]
			"28615:28623:28624:30569", -- [22]
			"30271:28674:31069:30314", -- [23]
			"30271:28674:30433", -- [24]
			"30271:28674:31069", -- [25]
			"30271:28674:33849", -- [26]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "23859:26881:26877:26851:26880:28196:28615:28618:30271",
			["coord"] = 3309797249,
		},
		[26879] = {
			"28195:28196:28197:23736", -- [1]
			"28195:28196:26878:26880:24061", -- [2]
			"28195:28196:26878:23859", -- [3]
			"24795:27046", -- [4]
			"28195:28196:26878", -- [5]
			"26881:26877", -- [6]
			"28195:28196:26851", -- [7]
			"28195:28196:26878:26880", -- [8]
			"28195:28196:26878:26880:26876", -- [9]
			"28195:28196", -- [10]
			"28195:28196:28197", -- [11]
			"26881:30869", -- [12]
			"28195:28196:26878:28615:28623", -- [13]
			"28195:28196:26878:28615", -- [14]
			"28195:28196:26878:28618", -- [15]
			"28195:28196:26878:28615:28623:28624", -- [16]
			"26602:28574", -- [17]
			"26602:28037", -- [18]
			"28674:29721", -- [19]
			"28674:30433:29750", -- [20]
			"28674:29721:32571", -- [21]
			"26602:28574:31078", -- [22]
			"28674:30433:29750:29951", -- [23]
			"28674:30433:29750:29950", -- [24]
			"28195:28196:26878:28615:28623:28624:30569", -- [25]
			"26602:28574:31078:30314", -- [26]
			"28674:30433", -- [27]
			"28674:31069", -- [28]
			"28674:30271", -- [29]
			"28674:33849", -- [30]
			["m"] = 114,
			["coord"] = 2531241699,
			["direct"] = "26602:26881:24795:28195:28674",
			["f"] = 0,
		},
		[26880] = {
			"23859:23736", -- [1]
			"26878:26881:26602:24795:27046", -- [2]
			"26878:26881:26879", -- [3]
			"26878:26881:26602", -- [4]
			"26878:26881", -- [5]
			"26878:26877", -- [6]
			"26878:26851", -- [7]
			"26878:26881:26602:24795", -- [8]
			"26878:28196", -- [9]
			"23859:28197", -- [10]
			"26878:26881:28195", -- [11]
			"26878:26877:30869", -- [12]
			"28618:28623", -- [13]
			"28618:28615", -- [14]
			"28618:28623:28624", -- [15]
			"26878:26877:30869:28574", -- [16]
			"26878:26881:26602:28037", -- [17]
			"28618:28615:28674", -- [18]
			"28618:28615:29721", -- [19]
			"28618:28615:29721:29750", -- [20]
			"28618:28623:28624:32571", -- [21]
			"28618:28615:28674:31069:31078", -- [22]
			"28618:28615:29721:29750:29951", -- [23]
			"28618:28615:29721:29750:29950", -- [24]
			"28618:28623:28624:30569", -- [25]
			"28618:28615:28674:31069:30314", -- [26]
			"28618:28615:28674:30433", -- [27]
			"28618:28615:28674:31069", -- [28]
			"28618:28615:30271", -- [29]
			"28618:28615:28674:33849", -- [30]
			["direct"] = "24061:23859:26878:26876:28618",
			["f"] = 0,
			["m"] = 116,
			["coord"] = 1344706413,
		},
		[26881] = {
			"26878:23859:23736", -- [1]
			"26878:26880:24061", -- [2]
			"26878:23859", -- [3]
			"26602:24795:27046", -- [4]
			"26878:26880", -- [5]
			"26878:26880:26876", -- [6]
			"26602:24795", -- [7]
			"28196:28197", -- [8]
			"26878:28615:28623", -- [9]
			"26878:28615", -- [10]
			"26878:28618", -- [11]
			"26878:28615:28623:28624", -- [12]
			"26602:28574", -- [13]
			"26602:28037", -- [14]
			"26877:28674", -- [15]
			"26877:28674:29721", -- [16]
			"26877:28674:30433:29750", -- [17]
			"26877:28674:29721:32571", -- [18]
			"30869:31078", -- [19]
			"26877:28674:30433:29750:29951", -- [20]
			"26877:28674:30433:29750:29950", -- [21]
			"26878:28615:28623:28624:30569", -- [22]
			"30869:30314", -- [23]
			"26877:28674:30433", -- [24]
			"30869:31069", -- [25]
			"26878:30271", -- [26]
			"26877:28674:33849", -- [27]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "26878:26879:26602:26877:26851:28196:28195:30869",
			["coord"] = 1252167107,
		},
		[23859] = {
			"26878:26881:26602:24795:27046", -- [1]
			"26878:26881:26879", -- [2]
			"26878:26881:26602", -- [3]
			"26878:26881", -- [4]
			"26878:26877", -- [5]
			"26878:26851", -- [6]
			"26880:26876", -- [7]
			"26878:26881:26602:24795", -- [8]
			"28197:28196", -- [9]
			"26878:26881:28195", -- [10]
			"26878:26877:30869", -- [11]
			"26880:28618:28623", -- [12]
			"26880:28618:28615", -- [13]
			"26880:28618", -- [14]
			"26880:28618:28623:28624", -- [15]
			"26878:26877:30869:28574", -- [16]
			"26878:26881:26602:28037", -- [17]
			"26880:28618:28615:28674", -- [18]
			"26880:28618:28615:29721", -- [19]
			"26880:28618:28615:29721:29750", -- [20]
			"26880:28618:28623:28624:32571", -- [21]
			"26880:28618:28615:28674:31069:31078", -- [22]
			"26880:28618:28615:29721:29750:29951", -- [23]
			"26880:28618:28615:29721:29750:29950", -- [24]
			"26880:28618:28623:28624:30569", -- [25]
			"26880:28618:28615:28674:31069:30314", -- [26]
			"26880:28618:28615:28674:30433", -- [27]
			"26880:28618:28615:28674:31069", -- [28]
			"26880:28618:28615:30271", -- [29]
			"26880:28618:28615:28674:33849", -- [30]
			["m"] = 117,
			["f"] = 0,
			["direct"] = "23736:24061:26878:26880:28197",
			["coord"] = 1342664869,
		},
		[29721] = {
			"28615:26878:23859:23736", -- [1]
			"28615:28623:26876:24061", -- [2]
			"28615:26878:23859", -- [3]
			"28615:26851:26881:26602:24795:27046", -- [4]
			"28615:26878", -- [5]
			"28674:26879", -- [6]
			"28615:26851:26881:26602", -- [7]
			"28615:26851:26881", -- [8]
			"28615:26877", -- [9]
			"28615:26851", -- [10]
			"28615:28618:26880", -- [11]
			"28615:28623:26876", -- [12]
			"28615:26851:26881:26602:24795", -- [13]
			"28615:26851:28196", -- [14]
			"28615:26878:23859:28197", -- [15]
			"28615:26851:26881:28195", -- [16]
			"28674:30869", -- [17]
			"28615:28623", -- [18]
			"28615:28618", -- [19]
			"28615:28623:28624", -- [20]
			"28674:28574", -- [21]
			"28674:28574:28037", -- [22]
			"29750:30433:31069:31078", -- [23]
			"29750:29951", -- [24]
			"29750:29950", -- [25]
			"28615:28623:28624:30569", -- [26]
			"29750:29950:30314", -- [27]
			"29750:30433", -- [28]
			"29750:30433:31069", -- [29]
			"29750:29950:33849", -- [30]
			["m"] = 120,
			["coord"] = 1747966095,
			["direct"] = "28615:28674:29750:32571:30271",
			["f"] = 0,
		},
		[24061] = {
			"26880:26878:26881:26602:24795:27046", -- [1]
			"26880:26878", -- [2]
			"26880:26878:26881:26879", -- [3]
			"26880:26878:26881:26602", -- [4]
			"26880:26878:26881", -- [5]
			"26880:26878:26877", -- [6]
			"26880:26878:26851", -- [7]
			"26880:26878:26881:26602:24795", -- [8]
			"26880:26878:28196", -- [9]
			"23859:28197", -- [10]
			"26880:26878:26881:28195", -- [11]
			"26880:26878:26877:30869", -- [12]
			"26876:28623", -- [13]
			"26880:28618:28615", -- [14]
			"26880:28618", -- [15]
			"26876:28624", -- [16]
			"26880:26878:26877:30869:28574", -- [17]
			"26880:26878:26881:26602:28037", -- [18]
			"26880:28618:28615:28674", -- [19]
			"26880:28618:28615:29721", -- [20]
			"26880:28618:28615:29721:29750", -- [21]
			"26876:28624:32571", -- [22]
			"26880:28618:28615:28674:31069:31078", -- [23]
			"26876:28624:29951", -- [24]
			"26880:28618:28615:29721:29750:29950", -- [25]
			"26876:28624:30569", -- [26]
			"26880:28618:28615:28674:31069:30314", -- [27]
			"26880:28618:28615:28674:30433", -- [28]
			"26880:28618:28615:28674:31069", -- [29]
			"26880:28618:28615:30271", -- [30]
			"26880:28618:28615:28674:33849", -- [31]
			["direct"] = "23736:23859:26880:26876",
			["coord"] = 2580097316,
			["m"] = 117,
			["f"] = 0,
		},
		[30869] = {
			"26877:26878:23859:23736", -- [1]
			"26877:26878:26880:24061", -- [2]
			"26877:26878:23859", -- [3]
			"28574:26602:24795:27046", -- [4]
			"26877:26878", -- [5]
			"26881:26879", -- [6]
			"28574:26602", -- [7]
			"26877:26851", -- [8]
			"26877:26878:26880", -- [9]
			"26877:26878:26880:26876", -- [10]
			"28574:26602:24795", -- [11]
			"26881:28196", -- [12]
			"26877:26878:23859:28197", -- [13]
			"26881:28195", -- [14]
			"26877:28615:28623", -- [15]
			"26877:28615", -- [16]
			"26877:28615:28618", -- [17]
			"26877:28615:28623:28624", -- [18]
			"28574:28037", -- [19]
			"28674:29721", -- [20]
			"28674:30433:29750", -- [21]
			"28674:29721:32571", -- [22]
			"28674:30433:29750:29951", -- [23]
			"28674:30433:29750:29950", -- [24]
			"26877:28615:28623:28624:30569", -- [25]
			"28674:30433", -- [26]
			"28674:30271", -- [27]
			"31069:33849", -- [28]
			["m"] = 123,
			["f"] = 0,
			["direct"] = "26881:26877:28574:28674:31078:30314:31069",
			["coord"] = 3094564733,
		},
		[32571] = {
			"28624:26876:24061:23736", -- [1]
			"28624:26876:24061", -- [2]
			"28624:26876:26880:23859", -- [3]
			"29721:28615:26851:26881:26602:24795:27046", -- [4]
			"29721:28615:26878", -- [5]
			"29721:28674:26879", -- [6]
			"29721:28615:26851:26881:26602", -- [7]
			"29721:28615:26851:26881", -- [8]
			"29721:28615:26877", -- [9]
			"29721:28615:26851", -- [10]
			"28624:26876:26880", -- [11]
			"28624:26876", -- [12]
			"29721:28615:26851:26881:26602:24795", -- [13]
			"29721:28615:26851:28196", -- [14]
			"28624:26876:26880:23859:28197", -- [15]
			"29721:28615:26851:26881:28195", -- [16]
			"29721:28674:30869", -- [17]
			"28624:28623", -- [18]
			"29721:28615", -- [19]
			"28624:28623:28618", -- [20]
			"29721:28674:28574", -- [21]
			"29721:28674:28574:28037", -- [22]
			"29721:28674", -- [23]
			"29721:29750", -- [24]
			"29951:29950:30314:31078", -- [25]
			"29951:29950", -- [26]
			"28624:30569", -- [27]
			"29951:29950:30314", -- [28]
			"29721:29750:30433", -- [29]
			"29721:29750:30433:31069", -- [30]
			"29721:30271", -- [31]
			"29951:29950:33849", -- [32]
			"29762:29757", -- [35]
			["direct"] = "28624:29721:29951",
			["coord"] = 2686753797,
			["m"] = 120,
			["f"] = 0,
		},
		[23736] = {
			"23859:26878:26881:26602:24795:27046", -- [1]
			"23859:26878", -- [2]
			"23859:26878:26881:26879", -- [3]
			"23859:26878:26881:26602", -- [4]
			"23859:26878:26881", -- [5]
			"23859:26878:26877", -- [6]
			"23859:26878:26851", -- [7]
			"23859:26880", -- [8]
			"24061:26876", -- [9]
			"23859:26878:26881:26602:24795", -- [10]
			"28197:28196", -- [11]
			"28197:28196:28195", -- [12]
			"23859:26878:26877:30869", -- [13]
			"24061:26876:28623", -- [14]
			"23859:26880:28618:28615", -- [15]
			"23859:26880:28618", -- [16]
			"24061:26876:28624", -- [17]
			"28674:28574", -- [18]
			"28674:28574:28037", -- [19]
			"23859:26880:28618:28615:29721", -- [20]
			"23859:26880:28618:28615:29721:29750", -- [21]
			"24061:26876:28624:32571", -- [22]
			"28674:31069:31078", -- [23]
			"24061:26876:28624:29951", -- [24]
			"23859:26880:28618:28615:29721:29750:29950", -- [25]
			"24061:26876:28624:30569", -- [26]
			"28674:31069:30314", -- [27]
			"28674:30433", -- [28]
			"28674:31069", -- [29]
			"23859:26880:28618:28615:30271", -- [30]
			"28674:33849", -- [31]
			["direct"] = "24061:23859:28197:28674",
			["coord"] = 2565448190,
			["m"] = 117,
			["f"] = 0,
		},
		[28037] = {
			"26602:28195:28196:28197:23736", -- [1]
			"26602:26881:26878:26880:24061", -- [2]
			"26602:26881:26878:23859", -- [3]
			"26602:24795:27046", -- [4]
			"26602:26881:26878", -- [5]
			"26602:26879", -- [6]
			"26602:26881", -- [7]
			"28574:30869:26877", -- [8]
			"26602:26881:26851", -- [9]
			"26602:26881:26878:26880", -- [10]
			"28574:28674:28615:28623:26876", -- [11]
			"26602:24795", -- [12]
			"26602:28195:28196", -- [13]
			"26602:28195:28196:28197", -- [14]
			"26602:28195", -- [15]
			"28574:30869", -- [16]
			"28574:28674:28615:28623", -- [17]
			"28574:28674:28615", -- [18]
			"28574:28674:28615:28618", -- [19]
			"28574:28674:28615:28623:28624", -- [20]
			"28574:28674", -- [21]
			"28574:28674:29721", -- [22]
			"28574:28674:30433:29750", -- [23]
			"28574:28674:29721:32571", -- [24]
			"31078:30314:29950:29951", -- [25]
			"31078:30314:29950", -- [26]
			"28574:28674:28615:28623:28624:30569", -- [27]
			"31078:30314", -- [28]
			"28574:28674:30433", -- [29]
			"31078:31069", -- [30]
			"28574:28674:30271", -- [31]
			"31078:30314:33849", -- [32]
			["direct"] = "26602:28574:31078",
			["coord"] = 1087608149,
			["m"] = 119,
			["f"] = 0,
			["requirements"] = "qid:12523"
		},
		[28615] = {
			"26878:23859:23736", -- [1]
			"28623:26876:24061", -- [2]
			"26878:23859", -- [3]
			"26851:26881:26602:24795:27046", -- [4]
			"26851:26881:26879", -- [5]
			"26851:26881:26602", -- [6]
			"26851:26881", -- [7]
			"28618:26880", -- [8]
			"28623:26876", -- [9]
			"26851:26881:26602:24795", -- [10]
			"26851:28196", -- [11]
			"26878:23859:28197", -- [12]
			"26851:26881:28195", -- [13]
			"26877:30869", -- [14]
			"28623:28624", -- [15]
			"28674:28574", -- [16]
			"28674:28574:28037", -- [17]
			"29721:29750", -- [18]
			"29721:32571", -- [19]
			"28674:31069:31078", -- [20]
			"29721:29750:29951", -- [21]
			"29721:29750:29950", -- [22]
			"28623:28624:30569", -- [23]
			"28674:31069:30314", -- [24]
			"28674:30433", -- [25]
			"28674:31069", -- [26]
			"28674:33849", -- [27]
			["m"] = 121,
			["coord"] = 603962466,
			["direct"] = "26878:26877:26851:28623:28618:28674:29721:30271",
			["f"] = 0,
		},
		[30433] = {
			"28674:23736", -- [1]
			"28674:28615:28623:26876:24061", -- [2]
			"28674:30271:26878:23859", -- [3]
			"28674:26879:24795:27046", -- [4]
			"28674:30271:26878", -- [5]
			"28674:26879", -- [6]
			"28674:28574:26602", -- [7]
			"28674:26877:26881", -- [8]
			"28674:26877", -- [9]
			"28674:26851", -- [10]
			"28674:30271:26878:26880", -- [11]
			"28674:28615:28623:26876", -- [12]
			"28674:26879:24795", -- [13]
			"28674:28196", -- [14]
			"28674:30271:26878:23859:28197", -- [15]
			"28674:26877:26881:28195", -- [16]
			"31069:30869", -- [17]
			"28674:28615:28623", -- [18]
			"28674:28615", -- [19]
			"28674:28615:28618", -- [20]
			"28674:28615:28623:28624", -- [21]
			"28674:28574", -- [22]
			"28674:28574:28037", -- [23]
			"28674:29721", -- [24]
			"28674:29721:32571", -- [25]
			"31069:31078", -- [26]
			"29750:29951", -- [27]
			"29750:29950", -- [28]
			"28674:28615:28623:28624:30569", -- [29]
			"28674:30271", -- [30]
			"31069:33849", -- [31]
			["direct"] = "28674:29750:30314:31069",
			["coord"] = 3770468289,
			["m"] = 118,
			["f"] = 0,
		},
		[28618] = {
			"26880:23859:23736", -- [1]
			"28623:26876:24061", -- [2]
			"26880:23859", -- [3]
			"28615:26851:26881:26602:24795:27046", -- [4]
			"28615:26851:26881:26879", -- [5]
			"28615:26851:26881:26602", -- [6]
			"28615:26851:26881", -- [7]
			"28615:26877", -- [8]
			"28615:26851", -- [9]
			"28623:26876", -- [10]
			"28615:26851:26881:26602:24795", -- [11]
			"26878:28196", -- [12]
			"26880:23859:28197", -- [13]
			"28615:26851:26881:28195", -- [14]
			"28615:26877:30869", -- [15]
			"28623:28624", -- [16]
			"28615:28674:28574", -- [17]
			"28615:28674:28574:28037", -- [18]
			"28615:28674", -- [19]
			"28615:29721", -- [20]
			"28615:29721:29750", -- [21]
			"28623:28624:32571", -- [22]
			"28615:28674:31069:31078", -- [23]
			"28615:29721:29750:29951", -- [24]
			"28615:29721:29750:29950", -- [25]
			"28623:28624:30569", -- [26]
			"28615:28674:31069:30314", -- [27]
			"28615:28674:30433", -- [28]
			"28615:28674:31069", -- [29]
			"28615:30271", -- [30]
			"28615:28674:33849", -- [31]
			["direct"] = "26878:26880:28623:28615",
			["coord"] = 1381678745,
			["m"] = 121,
			["f"] = 0,
		},
		[30569] = {
			"28624:26876:24061:23736", -- [1]
			"28624:26876:24061", -- [2]
			"28624:26876:26880:23859", -- [3]
			"28624:28623:28615:26851:26881:26602:24795:27046", -- [4]
			"28624:28623:28618:26878", -- [5]
			"28624:28623:28615:26851:26881:26879", -- [6]
			"28624:28623:28615:26851:26881:26602", -- [7]
			"28624:28623:28615:26851:26881", -- [8]
			"28624:28623:28615:26877", -- [9]
			"28624:28623:28615:26851", -- [10]
			"28624:26876:26880", -- [11]
			"28624:26876", -- [12]
			"28624:28623:28615:26851:26881:26602:24795", -- [13]
			"28624:28623:28615:26851:28196", -- [14]
			"28624:26876:26880:23859:28197", -- [15]
			"28624:28623:28615:26851:26881:28195", -- [16]
			"28624:28623:28615:26877:30869", -- [17]
			"28624:28623", -- [18]
			"28624:28623:28615", -- [19]
			"28624:28623:28618", -- [20]
			"28624:28623:28615:28674:28574", -- [21]
			"28624:28623:28615:28674:28574:28037", -- [22]
			"28624:28623:28615:28674", -- [23]
			"28624:28623:28615:29721", -- [24]
			"28624:28623:28615:29721:29750", -- [25]
			"28624:32571", -- [26]
			"28624:28623:28615:28674:31069:31078", -- [27]
			"28624:29951", -- [28]
			"28624:29951:29950", -- [29]
			"28624:29951:29950:30314", -- [30]
			"28624:28623:28615:28674:30433", -- [31]
			"28624:28623:28615:28674:31069", -- [32]
			"28624:28623:28615:30271", -- [33]
			"28624:29951:29950:33849", -- [34]
			["direct"] = "28624",
			["coord"] = 3025877835,
			["m"] = 121,
			["f"] = 0,
		},
		[27046] = {
			"24795:26602:28195:28196:28197:23736", -- [1]
			"24795:26602:26881:26878:26880:24061", -- [2]
			"24795:26602:26881:26878:23859", -- [3]
			"24795:26602:26881:26878", -- [4]
			"24795:26879", -- [5]
			"24795:26602", -- [6]
			"24795:26602:26881", -- [7]
			"24795:26602:26881:26877", -- [8]
			"24795:26602:26881:26851", -- [9]
			"24795:26602:26881:26878:26880", -- [10]
			"24795:26602:26881:26878:26880:26876", -- [11]
			"24795:26602:28195:28196", -- [12]
			"24795:26602:28195:28196:28197", -- [13]
			"24795:26602:28195", -- [14]
			"24795:26602:26881:30869", -- [15]
			"24795:26602:26881:26878:28615:28623", -- [16]
			"24795:26602:26881:26878:28615", -- [17]
			"24795:26602:26881:26878:28618", -- [18]
			"24795:26602:26881:26878:28615:28623:28624", -- [19]
			"24795:26602:28574", -- [20]
			"24795:26602:28037", -- [21]
			"24795:26602:28574:28674", -- [22]
			"24795:26602:28574:28674:29721", -- [23]
			"24795:26602:28574:28674:30433:29750", -- [24]
			"24795:26602:28574:28674:29721:32571", -- [25]
			"24795:26602:28574:31078", -- [26]
			"24795:26602:28574:31078:30314:29950:29951", -- [27]
			"24795:26602:28574:31078:30314:29950", -- [28]
			"24795:26602:26881:26878:28615:28623:28624:30569", -- [29]
			"24795:26602:28574:31078:30314", -- [30]
			"24795:26602:28574:28674:30433", -- [31]
			"24795:26602:28574:28674:31069", -- [32]
			"24795:26602:28574:28674:30271", -- [33]
			"24795:26602:28574:31078:30314:33849", -- [34]
			["direct"] = "24795",
			["coord"] = 1422481428,
			["m"] = 114,
			["f"] = 0,
		},
		[28196] = {
			"28197:23736", -- [1]
			"26878:26880:24061", -- [2]
			"26878:23859", -- [3]
			"26881:26602:24795:27046", -- [4]
			"26881:26879", -- [5]
			"26881:26602", -- [6]
			"26851:26877", -- [7]
			"26878:26880", -- [8]
			"26878:26880:26876", -- [9]
			"26881:26602:24795", -- [10]
			"26881:30869", -- [11]
			"26878:28615:28623", -- [12]
			"26878:28615", -- [13]
			"26878:28618", -- [14]
			"26878:28615:28623:28624", -- [15]
			"26881:26602:28574", -- [16]
			"26881:26602:28037", -- [17]
			"28674:29721", -- [18]
			"28674:30433:29750", -- [19]
			"28674:29721:32571", -- [20]
			"26881:30869:31078", -- [21]
			"28674:30433:29750:29951", -- [22]
			"28674:30433:29750:29950", -- [23]
			"26878:28615:28623:28624:30569", -- [24]
			"26881:30869:30314", -- [25]
			"28674:30433", -- [26]
			"28674:31069", -- [27]
			"26878:30271", -- [28]
			"28674:33849", -- [29]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "26878:26881:26851:28197:28195:28674",
			["coord"] = 2081603196,
		},
		[28674] = {
			"28615:28623:26876:24061", -- [1]
			"30271:26878:23859", -- [2]
			"26879:24795:27046", -- [3]
			"30271:26878", -- [4]
			"28574:26602", -- [5]
			"26877:26881", -- [6]
			"30271:26878:26880", -- [7]
			"28615:28623:26876", -- [8]
			"26879:24795", -- [9]
			"30271:26878:23859:28197", -- [10]
			"26877:26881:28195", -- [11]
			"28615:28623", -- [12]
			"28615:28618", -- [13]
			"28615:28623:28624", -- [14]
			"28574:28037", -- [15]
			"30433:29750", -- [16]
			"29721:32571", -- [17]
			"31069:31078", -- [18]
			"30433:29750:29951", -- [19]
			"30433:29750:29950", -- [20]
			"28615:28623:28624:30569", -- [21]
			"31069:30314", -- [22]
			["m"] = 125,
			["coord"] = 3092739228,
			["direct"] = "23736:26879:26877:26851:28196:30869:28615:28574:29721:30433:31069:30271:33849",
			["f"] = 0,
		},
		[31069] = {
			"30433:28674:23736", -- [1]
			"30433:28674:28615:28623:26876:24061", -- [2]
			"30433:28674:30271:26878:23859", -- [3]
			"30869:28574:26602:24795:27046", -- [4]
			"30433:28674:30271:26878", -- [5]
			"30869:26881:26879", -- [6]
			"30869:28574:26602", -- [7]
			"30869:26881", -- [8]
			"30869:26877", -- [9]
			"30433:28674:26851", -- [10]
			"30433:28674:30271:26878:26880", -- [11]
			"30433:28674:28615:28623:26876", -- [12]
			"30869:28574:26602:24795", -- [13]
			"30433:28674:28196", -- [14]
			"30433:28674:30271:26878:23859:28197", -- [15]
			"30869:26881:28195", -- [16]
			"30433:28674:28615:28623", -- [17]
			"30433:28674:28615", -- [18]
			"30433:28674:28615:28618", -- [19]
			"30433:28674:28615:28623:28624", -- [20]
			"30869:28574", -- [21]
			"31078:28037", -- [22]
			"30433:28674:29721", -- [23]
			"30433:29750", -- [24]
			"30433:28674:29721:32571", -- [25]
			"30433:29750:29951", -- [26]
			"30433:29750:29950", -- [27]
			"30433:28674:28615:28623:28624:30569", -- [28]
			"30433:28674:30271", -- [29]
			["m"] = 118,
			["coord"] = 3408050485,
			["direct"] = "30869:28674:31078:30314:30433:33849",
			["f"] = 0,
		},
		[30314] = {
			"30433:28674:23736", -- [1]
			"29950:29951:28624:26876:24061", -- [2]
			"30869:26877:26878:23859", -- [3]
			"31078:28574:26602:24795:27046", -- [4]
			"30869:26877:26878", -- [5]
			"31078:28574:26602:26879", -- [6]
			"31078:28574:26602", -- [7]
			"30869:26881", -- [8]
			"30869:26877", -- [9]
			"30869:26877:26851", -- [10]
			"30869:26877:26878:26880", -- [11]
			"29950:29951:28624:26876", -- [12]
			"31078:28574:26602:24795", -- [13]
			"30869:26881:28196", -- [14]
			"30869:26877:26878:23859:28197", -- [15]
			"30869:26881:28195", -- [16]
			"30433:28674:28615:28623", -- [17]
			"30433:28674:28615", -- [18]
			"30433:28674:28615:28618", -- [19]
			"29950:29951:28624", -- [20]
			"31078:28574", -- [21]
			"31078:28037", -- [22]
			"30433:28674", -- [23]
			"30433:28674:29721", -- [24]
			"30433:29750", -- [25]
			"29950:29951:32571", -- [26]
			"29950:29951", -- [27]
			"29950:29951:28624:30569", -- [28]
			"30433:28674:30271", -- [29]
			["m"] = 118,
			["coord"] = 1877360227,
			["direct"] = "30869:31078:29950:30433:31069:33849",
			["f"] = 0,
		},
		[26851] = {
			"26878:23859:23736", -- [1]
			"26878:26880:24061", -- [2]
			"26878:23859", -- [3]
			"26881:26602:24795:27046", -- [4]
			"26881:26879", -- [5]
			"26881:26602", -- [6]
			"26878:26880", -- [7]
			"26878:26880:26876", -- [8]
			"26881:26602:24795", -- [9]
			"26878:23859:28197", -- [10]
			"26881:28195", -- [11]
			"26877:30869", -- [12]
			"28615:28623", -- [13]
			"26878:28618", -- [14]
			"28615:28623:28624", -- [15]
			"26877:30869:28574", -- [16]
			"26881:26602:28037", -- [17]
			"28615:29721", -- [18]
			"28674:30433:29750", -- [19]
			"28615:29721:32571", -- [20]
			"26877:30869:31078", -- [21]
			"28674:30433:29750:29951", -- [22]
			"28674:30433:29750:29950", -- [23]
			"28615:28623:28624:30569", -- [24]
			"28674:31069:30314", -- [25]
			"28674:30433", -- [26]
			"28674:31069", -- [27]
			"26878:30271", -- [28]
			"28674:33849", -- [29]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "26878:26881:26877:28196:28615:28674",
			["coord"] = 2588115855,
		},
		[33849] = {
			"31069:30433:28674:23736", -- [1]
			"29950:29951:28624:26876:24061", -- [2]
			"31069:30433:28674:30271:26878:23859", -- [3]
			"30314:31078:28574:26602:24795:27046", -- [4]
			"31069:30433:28674:30271:26878", -- [5]
			"31069:30869:26881:26879", -- [6]
			"30314:31078:28574:26602", -- [7]
			"31069:30869:26881", -- [8]
			"31069:30869:26877", -- [9]
			"31069:30433:28674:26851", -- [10]
			"31069:30433:28674:30271:26878:26880", -- [11]
			"29950:29951:28624:26876", -- [12]
			"30314:31078:28574:26602:24795", -- [13]
			"31069:30433:28674:28196", -- [14]
			"31069:30433:28674:30271:26878:23859:28197", -- [15]
			"31069:30869:26881:28195", -- [16]
			"31069:30869", -- [17]
			"31069:30433:28674:28615:28623", -- [18]
			"31069:30433:28674:28615", -- [19]
			"31069:30433:28674:28615:28618", -- [20]
			"29950:29951:28624", -- [21]
			"30314:31078:28574", -- [22]
			"30314:31078:28037", -- [23]
			"29950:29750:29721", -- [24]
			"29950:29750", -- [25]
			"29950:29951:32571", -- [26]
			"30314:31078", -- [27]
			"29950:29951", -- [28]
			"29950:29951:28624:30569", -- [29]
			"31069:30433", -- [30]
			"31069:30433:28674:30271", -- [31]
			["direct"] = "28674:29950:30314:31069",
			["coord"] = 3118414356,
			["m"] = 118,
			["f"] = 0,
		},
		[28197] = {
			"23859:24061", -- [1]
			"28196:26881:26602:24795:27046", -- [2]
			"23859:26878", -- [3]
			"28196:26881:26879", -- [4]
			"28196:26881:26602", -- [5]
			"28196:26881", -- [6]
			"23859:26878:26877", -- [7]
			"23859:26878:26851", -- [8]
			"23859:26880", -- [9]
			"23859:26880:26876", -- [10]
			"28196:26881:26602:24795", -- [11]
			"28196:28195", -- [12]
			"28196:26881:30869", -- [13]
			"23859:26880:28618:28623", -- [14]
			"23859:26880:28618:28615", -- [15]
			"23859:26880:28618", -- [16]
			"23859:26880:28618:28623:28624", -- [17]
			"28196:26881:26602:28574", -- [18]
			"28196:26881:26602:28037", -- [19]
			"23859:26880:28618:28615:28674", -- [20]
			"23859:26880:28618:28615:29721", -- [21]
			"23859:26880:28618:28615:29721:29750", -- [22]
			"23859:26880:28618:28623:28624:32571", -- [23]
			"28196:26881:30869:31078", -- [24]
			"23859:26880:28618:28615:29721:29750:29951", -- [25]
			"23859:26880:28618:28615:29721:29750:29950", -- [26]
			"23859:26880:28618:28623:28624:30569", -- [27]
			"23859:26880:28618:28615:28674:31069:30314", -- [28]
			"23859:26880:28618:28615:28674:30433", -- [29]
			"23859:26880:28618:28615:28674:31069", -- [30]
			"23859:26880:28618:28615:30271", -- [31]
			"23859:26880:28618:28615:28674:33849", -- [32]
			["m"] = 117,
			["f"] = 0,
			["direct"] = "23736:23859:28196",
			["coord"] = 1058378765,
		},
	}, -- [4]
	[6] = {
		[61512] = {
			"60416:61744:61474:61759:60230:59186", -- [1]
			"60416:61744:61474:66023", -- [2]
			"60416:61744:61474:61759:60230:59186:59732", -- [3]
			"60416:61744:61474:61759:60230:59186:59727", -- [4]
			"60416:61744:61474:61759:60230:59186:59735:59733", -- [5]
			"60416:61744:61474:61759:60230:59186:59735", -- [6]
			"60416:61744:61474:61759:60230:59186:59736", -- [7]
			"60416:61744:61474:66023:56737", -- [8]
			"60416:61744:61474:61759:60230", -- [9]
			"60416:61744:61474:61759:62658:60231", -- [10]
			"60416:61744:61474:60232", -- [11]
			"60416:61744:61474:61759:62658:60231:59049", -- [12]
			"62901:62903:63500:63501:58843", -- [13]
			"62901:62903:63500:63501:59048", -- [14]
			"62901:62903:63500:63501:59048:65189", -- [15]
			"62901:62903:63500:63501:59048:60441", -- [16]
			"60416:61744:61474", -- [17]
			"60416:61504:61118", -- [18]
			"60416:61744", -- [19]
			"60416:61504:61118:61511", -- [20]
			"60416:61504", -- [21]
			"60416:61473", -- [22]
			"60416:61744:61474:61759", -- [23]
			"60416:61744:61474:61759:62658", -- [24]
			"62901:62903", -- [25]
			"62901:62898", -- [26]
			"62901:62898:62909", -- [27]
			"60416:61744:61121", -- [28]
			"62901:62903:63500:63501", -- [29]
			"63497:63498", -- [30]
			"62901:62903:63500", -- [31]
			"60416:61744:61474:61759:60230:59186:64310", -- [32]
			"62901:62903:63500:63501:65511", -- [33]
			"60416:61744:61121:65865", -- [34]
			"60416:61744:61474:66023:56737:71940", -- [35]
			--["name"] = "Winter's Blossom, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "60416:62901:63497",
			["coord"] = 1483577174,
		},
		[62658] = {
			"60230:59186", -- [1]
			"60231:60232:66023", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59727", -- [4]
			"60230:59186:59735:59733", -- [5]
			"60230:59186:59735", -- [6]
			"60230:59186:59736", -- [7]
			"60231:60232:66023:56737", -- [8]
			"60231:60232", -- [9]
			"60231:59049", -- [10]
			"60231:58843", -- [11]
			"60231:59048", -- [12]
			"60231:65189", -- [13]
			"60231:59049:60441", -- [14]
			"61759:61474", -- [15]
			"61759:61474:61118", -- [16]
			"61759:61474:61744", -- [17]
			"61759:61474:61118:61511", -- [18]
			"61759:61474:61504", -- [19]
			"61759:61474:61744:60416", -- [20]
			"61759:61474:61744:61473", -- [21]
			"61759:61474:61744:60416:61512", -- [22]
			"61759:61474:61744:61473:62901", -- [23]
			"61759:61474:61744:61473:62903", -- [24]
			"61759:61474:61744:61473:62903:62898", -- [25]
			"61759:61474:61744:61473:62903:62898:62909", -- [26]
			"60231:58843:63501", -- [27]
			"60231:58843:63501:63498", -- [28]
			"61121:63500", -- [29]
			"61121:63497", -- [30]
			"60230:59186:64310", -- [31]
			"60231:58843:63501:65511", -- [32]
			"61121:65865", -- [33]
			"60231:60232:66023:56737:71940", -- [34]
			--["name"] = "Grassy Cline, Valley of the Four Winds",
			["m"] = 376,
			["f"] = 0,
			["direct"] = "60230:60231:61759:61121",
			["coord"] = 3041672744,
		},
		[61473] = {
			"61744:61474:61759:60230:59186", -- [1]
			"61744:61474:66023", -- [2]
			"61744:61474:61759:60230:59186:59732", -- [3]
			"61744:61474:61759:60230:59186:59727", -- [4]
			"61744:61474:61759:60230:59186:59735:59733", -- [5]
			"61744:61474:61759:60230:59186:59735", -- [6]
			"61744:61474:61759:60230:59186:59736", -- [7]
			"61744:61474:66023:56737", -- [8]
			"61744:61474:61759:60230", -- [9]
			"61744:61474:61759:62658:60231", -- [10]
			"61744:61474:60232", -- [11]
			"61744:61474:61759:62658:60231:59049", -- [12]
			"62903:63500:63501:58843", -- [13]
			"62903:63500:63501:59048", -- [14]
			"62903:63500:63501:59048:65189", -- [15]
			"62903:63500:63501:59048:60441", -- [16]
			"61744:61474", -- [17]
			"60416:61504:61118", -- [18]
			"60416:61504:61118:61511", -- [19]
			"60416:61504", -- [20]
			"60416:61512", -- [21]
			"61744:61474:61759", -- [22]
			"61744:61474:61759:62658", -- [23]
			"62903:62898", -- [24]
			"62903:62898:62909", -- [25]
			"61744:61121", -- [26]
			"62903:63500:63501", -- [27]
			"62903:63500:63501:63498", -- [28]
			"62903:63500", -- [29]
			"62903:63500:63497", -- [30]
			"61744:61474:61759:60230:59186:64310", -- [31]
			"62903:63500:63501:65511", -- [32]
			"61744:61121:65865", -- [33]
			"61744:61474:66023:56737:71940", -- [34]
			--["name"] = "Shado-Pan Fallback, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "61744:60416:62901:62903",
			["coord"] = 1887954259,
		},
		[64310] = {
			"56737:66023", -- [1]
			"59186:59732", -- [2]
			"56737:59727", -- [3]
			"59186:59735:59733", -- [4]
			"59186:59735", -- [5]
			"59186:59736", -- [6]
			"59186:60230", -- [7]
			"56737:66023:60232:60231", -- [8]
			"56737:66023:60232", -- [9]
			"56737:66023:60232:60231:59049", -- [10]
			"56737:66023:60232:60231:58843", -- [11]
			"56737:66023:60232:60231:59048", -- [12]
			"56737:66023:60232:60231:65189", -- [13]
			"56737:66023:60232:60231:59049:60441", -- [14]
			"59186:60230:61759:61474", -- [15]
			"59186:60230:61759:61474:61118", -- [16]
			"59186:60230:61759:61474:61744", -- [17]
			"59186:60230:61759:61474:61118:61511", -- [18]
			"59186:60230:61759:61474:61504", -- [19]
			"59186:60230:61759:61474:61744:60416", -- [20]
			"59186:60230:61759:61474:61744:61473", -- [21]
			"59186:60230:61759:61474:61744:60416:61512", -- [22]
			"59186:60230:61759", -- [23]
			"59186:60230:62658", -- [24]
			"59186:60230:61759:61474:61744:61473:62901", -- [25]
			"59186:60230:61759:61474:61744:61473:62903", -- [26]
			"59186:60230:61759:61474:61744:61473:62903:62898", -- [27]
			"59186:60230:61759:61474:61744:61473:62903:62898:62909", -- [28]
			"59186:60230:62658:61121", -- [29]
			"56737:66023:60232:60231:58843:63501", -- [30]
			"56737:66023:60232:60231:58843:63501:63498", -- [31]
			"59186:60230:62658:61121:63500", -- [32]
			"59186:60230:62658:61121:63497", -- [33]
			"56737:66023:60232:60231:58843:63501:65511", -- [34]
			"59186:60230:62658:61121:65865", -- [35]
			"56737:71940", -- [36]
			--["name"] = "Serpent's Overlook, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59186:56737",
			["coord"] = 1851699009,
		},
		[65511] = {
			"63501:58843:60231:60230:59186", -- [1]
			"63501:58843:60231:60232:66023", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60232:66023:59727", -- [4]
			"63501:58843:60231:60230:59186:59735:59733", -- [5]
			"63501:58843:60231:60230:59186:59735", -- [6]
			"63501:58843:60231:60230:59186:59736", -- [7]
			"63501:58843:60231:60232:66023:56737", -- [8]
			"63501:58843:60231:60230", -- [9]
			"63501:58843:60231", -- [10]
			"63501:58843:60231:60232", -- [11]
			"63501:58843:60231:59049", -- [12]
			"63501:58843", -- [13]
			"63501:59048", -- [14]
			"63501:59048:65189", -- [15]
			"63501:59048:60441", -- [16]
			"63501:63500:62903:61473:61744:61474", -- [17]
			"63501:63500:62903:61473:60416:61504:61118", -- [18]
			"63501:63500:62903:61473:61744", -- [19]
			"63501:63500:62903:61473:60416:61504:61118:61511", -- [20]
			"63501:63500:62903:61473:60416:61504", -- [21]
			"63501:63500:62903:61473:60416", -- [22]
			"63501:63500:62903:61473", -- [23]
			"63501:63497:61512", -- [24]
			"63501:58843:60231:62658:61759", -- [25]
			"63501:58843:60231:62658", -- [26]
			"63501:63500:62903:62901", -- [27]
			"63501:63500:62903", -- [28]
			"63501:63500:62903:62898", -- [29]
			"63501:63500:62903:62898:62909", -- [30]
			"63501:61121", -- [31]
			"63501:63500", -- [32]
			"63501:63497", -- [33]
			"63501:58843:60231:60232:66023:56737:64310", -- [34]
			"63501:61121:65865", -- [35]
			"63501:58843:60231:60232:66023:56737:71940", -- [36]
			--["name"] = "The Briny Muck, Dread Wastes",
			["m"] = 422,
			["f"] = 0,
			["direct"] = "63501:63498",
			["coord"] = 1829473930,
		},
		[63497] = {
			"61121:60230:59186", -- [1]
			"61121:66023", -- [2]
			"61121:60230:59186:59732", -- [3]
			"61121:60230:59186:59727", -- [4]
			"61121:60230:59186:59735:59733", -- [5]
			"61121:60230:59186:59735", -- [6]
			"61121:60230:59186:59736", -- [7]
			"61121:66023:56737", -- [8]
			"61121:60230", -- [9]
			"63501:58843:60231", -- [10]
			"63501:58843:60231:60232", -- [11]
			"63501:58843:60231:59049", -- [12]
			"63501:58843", -- [13]
			"63501:59048", -- [14]
			"63501:59048:65189", -- [15]
			"63501:59048:60441", -- [16]
			"61121:61474", -- [17]
			"61512:60416:61504:61118", -- [18]
			"61121:61744", -- [19]
			"61512:60416:61504:61118:61511", -- [20]
			"61512:60416:61504", -- [21]
			"61512:60416", -- [22]
			"63500:62903:61473", -- [23]
			"61121:62658:61759", -- [24]
			"61121:62658", -- [25]
			"63500:62903:62901", -- [26]
			"63500:62903", -- [27]
			"63500:62903:62898", -- [28]
			"63500:62903:62898:62909", -- [29]
			"61121:60230:59186:64310", -- [30]
			"63501:65511", -- [31]
			"61121:65865", -- [32]
			"61121:66023:56737:71940", -- [33]
			--["name"] = "Serpent's Spine, Vale of Eternal Blossoms",
			["m"] = 390,
			["f"] = 0,
			["direct"] = "61512:61121:63501:63498:63500",
			["coord"] = 603966145,
		},
		[63501] = {
			"58843:60231:60230:59186", -- [1]
			"58843:60231:60232:66023", -- [2]
			"58843:60231:60230:59186:59732", -- [3]
			"58843:60231:60232:66023:59727", -- [4]
			"58843:60231:60230:59186:59735:59733", -- [5]
			"58843:60231:60230:59186:59735", -- [6]
			"58843:60231:60230:59186:59736", -- [7]
			"58843:60231:60232:66023:56737", -- [8]
			"58843:60231:60230", -- [9]
			"58843:60231", -- [10]
			"58843:60231:60232", -- [11]
			"58843:60231:59049", -- [12]
			"59048:65189", -- [13]
			"59048:60441", -- [14]
			"63500:62903:61473:61744:61474", -- [15]
			"63500:62903:61473:60416:61504:61118", -- [16]
			"63500:62903:61473:61744", -- [17]
			"63500:62903:61473:60416:61504:61118:61511", -- [18]
			"63500:62903:61473:60416:61504", -- [19]
			"63500:62903:61473:60416", -- [20]
			"63500:62903:61473", -- [21]
			"63497:61512", -- [22]
			"58843:60231:62658:61759", -- [23]
			"58843:60231:62658", -- [24]
			"63500:62903:62901", -- [25]
			"63500:62903", -- [26]
			"63500:62903:62898", -- [27]
			"63500:62903:62898:62909", -- [28]
			"58843:60231:60232:66023:56737:64310", -- [29]
			"61121:65865", -- [30]
			"58843:60231:60232:66023:56737:71940", -- [31]
			--["name"] = "Klaxxi'vess, Dread Wastes",
			["direct"] = "58843:59048:61121:63498:63500:63497:65511",
			["f"] = 0,
			["m"] = 422,
			["coord"] = 2397264188,
		},
		[60416] = {
			"61744:61474:61759:60230:59186", -- [1]
			"61744:61474:66023", -- [2]
			"61744:61474:61759:60230:59186:59732", -- [3]
			"61744:61474:61759:60230:59186:59727", -- [4]
			"61744:61474:61759:60230:59186:59735:59733", -- [5]
			"61744:61474:61759:60230:59186:59735", -- [6]
			"61744:61474:61759:60230:59186:59736", -- [7]
			"61744:61474:66023:56737", -- [8]
			"61744:61474:61759:60230", -- [9]
			"61744:61474:61759:62658:60231", -- [10]
			"61744:61474:60232", -- [11]
			"61744:61474:61759:62658:60231:59049", -- [12]
			"61473:62903:63500:63501:58843", -- [13]
			"61473:62903:63500:63501:59048", -- [14]
			"61473:62903:63500:63501:59048:65189", -- [15]
			"61744:61474:61759:62658:60231:59049:60441", -- [16]
			"61744:61474", -- [17]
			"61504:61118", -- [18]
			"61504:61118:61511", -- [19]
			"61744:61474:61759", -- [20]
			"61744:61474:61759:62658", -- [21]
			"61512:62901", -- [22]
			"61473:62903", -- [23]
			"61512:62901:62898", -- [24]
			"61512:62901:62898:62909", -- [25]
			"61744:61121", -- [26]
			"61473:62903:63500:63501", -- [27]
			"61473:62903:63500:63501:63498", -- [28]
			"61473:62903:63500", -- [29]
			"61512:63497", -- [30]
			"61744:61474:61759:60230:59186:64310", -- [31]
			"61473:62903:63500:63501:65511", -- [32]
			"61744:61121:65865", -- [33]
			"61744:61474:66023:56737:71940", -- [34]
			--["name"] = "Kota Basecamp, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "61744:61504:61473:61512",
			["coord"] = 1836691981,
		},
		[58843] = {
			"60231:60230:59186", -- [1]
			"60231:60232:66023", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60232:66023:59727", -- [4]
			"60231:60230:59186:59735:59733", -- [5]
			"60231:60230:59186:59735", -- [6]
			"60231:60230:59186:59736", -- [7]
			"60231:60232:66023:56737", -- [8]
			"60231:60230", -- [9]
			"60231:60232", -- [10]
			"59048:60441", -- [11]
			"60231:62658:61759:61474", -- [12]
			"60231:62658:61759:61474:61118", -- [13]
			"60231:62658:61759:61474:61744", -- [14]
			"60231:62658:61759:61474:61118:61511", -- [15]
			"60231:62658:61759:61474:61504", -- [16]
			"63501:63500:62903:61473:60416", -- [17]
			"63501:63500:62903:61473", -- [18]
			"63501:63497:61512", -- [19]
			"60231:62658:61759", -- [20]
			"60231:62658", -- [21]
			"63501:63500:62903:62901", -- [22]
			"63501:63500:62903", -- [23]
			"63501:63500:62903:62898", -- [24]
			"63501:63500:62903:62898:62909", -- [25]
			"60231:61121", -- [26]
			"63501:63498", -- [27]
			"63501:63500", -- [28]
			"63501:63497", -- [29]
			"60231:60232:66023:56737:64310", -- [30]
			"63501:65511", -- [31]
			"60231:61121:65865", -- [32]
			"60231:60232:66023:56737:71940", -- [33]
			--["name"] = "Stoneplow, Valley of the Four Winds",
			["m"] = 376,
			["f"] = 0,
			["direct"] = "60231:59049:59048:65189:63501",
			["coord"] = 869897766,
		},
		[60231] = {
			"60230:59186", -- [1]
			"60232:66023", -- [2]
			"60230:59186:59732", -- [3]
			"60232:66023:59727", -- [4]
			"60230:59186:59735:59733", -- [5]
			"60230:59186:59735", -- [6]
			"60230:59186:59736", -- [7]
			"60232:66023:56737", -- [8]
			"59049:60441", -- [9]
			"62658:61759:61474", -- [10]
			"62658:61759:61474:61118", -- [11]
			"62658:61759:61474:61744", -- [12]
			"62658:61759:61474:61118:61511", -- [13]
			"62658:61759:61474:61504", -- [14]
			"62658:61759:61474:61744:60416", -- [15]
			"62658:61759:61474:61744:61473", -- [16]
			"62658:61759:61474:61744:60416:61512", -- [17]
			"62658:61759", -- [18]
			"62658:61759:61474:61744:61473:62901", -- [19]
			"58843:63501:63500:62903", -- [20]
			"58843:63501:63500:62903:62898", -- [21]
			"58843:63501:63500:62903:62898:62909", -- [22]
			"58843:63501", -- [23]
			"58843:63501:63498", -- [24]
			"58843:63501:63500", -- [25]
			"61121:63497", -- [26]
			"60232:66023:56737:64310", -- [27]
			"58843:63501:65511", -- [28]
			"61121:65865", -- [29]
			"60232:66023:56737:71940", -- [30]
			--["name"] = "Halfhill, Valley of the Four Winds",
			["direct"] = "60230:60232:59049:58843:59048:65189:62658:61121",
			["f"] = 0,
			["m"] = 376,
			["coord"] = 2423292124,
		},
		[71940] = {
			"56737:66023", -- [1]
			"56737:59727:59732", -- [2]
			"56737:59727", -- [3]
			"59186:59735:59733", -- [4]
			"59186:59735", -- [5]
			"59186:59736", -- [6]
			"56737:66023:60232:60230", -- [7]
			"56737:66023:60232:60231", -- [8]
			"56737:66023:60232", -- [9]
			"56737:66023:60232:60231:59049", -- [10]
			"56737:66023:60232:60231:58843", -- [11]
			"56737:66023:60232:60231:59048", -- [12]
			"56737:66023:60232:60231:65189", -- [13]
			"56737:66023:60232:60231:59049:60441", -- [14]
			"56737:66023:61474", -- [15]
			"56737:66023:61474:61118", -- [16]
			"56737:66023:61474:61744", -- [17]
			"56737:66023:61474:61118:61511", -- [18]
			"56737:66023:61474:61504", -- [19]
			"56737:66023:61474:61744:60416", -- [20]
			"56737:66023:61474:61744:61473", -- [21]
			"56737:66023:61474:61744:60416:61512", -- [22]
			"56737:66023:60232:60230:61759", -- [23]
			"56737:66023:60232:60230:62658", -- [24]
			"56737:66023:61474:61744:61473:62901", -- [25]
			"56737:66023:61474:61744:61473:62903", -- [26]
			"56737:66023:61474:61744:61473:62903:62898", -- [27]
			"56737:66023:61474:61744:61473:62903:62898:62909", -- [28]
			"56737:66023:61121", -- [29]
			"56737:66023:60232:60231:58843:63501", -- [30]
			"56737:66023:60232:60231:58843:63501:63498", -- [31]
			"56737:66023:61121:63500", -- [32]
			"56737:66023:61121:63497", -- [33]
			"56737:64310", -- [34]
			"56737:66023:60232:60231:58843:63501:65511", -- [35]
			"56737:66023:61121:65865", -- [36]
			--["name"] = "Tushui Landing, Timeless Isle",
			["m"] = 554,
			["f"] = 0,
			["direct"] = "59186:56737",
			["coord"] = 994620814,
		},
		[59733] = {
			"59735:59186", -- [1]
			"59735:59186:66023", -- [2]
			"59732:59727", -- [3]
			"59735:59736", -- [4]
			"59732:59727:56737", -- [5]
			"59735:59186:60230", -- [6]
			"59735:59186:60230:60231", -- [7]
			"59735:59186:60230:60232", -- [8]
			"59735:59186:60230:60231:59049", -- [9]
			"59735:59186:60230:60231:58843", -- [10]
			"59735:59186:60230:60231:59048", -- [11]
			"59735:59186:60230:60231:65189", -- [12]
			"59735:59186:60230:60231:59049:60441", -- [13]
			"59735:59186:60230:61759:61474", -- [14]
			"59735:59186:60230:61759:61474:61118", -- [15]
			"59735:59186:60230:61759:61474:61744", -- [16]
			"59735:59186:60230:61759:61474:61118:61511", -- [17]
			"59735:59186:60230:61759:61474:61504", -- [18]
			"59735:59186:60230:61759:61474:61744:60416", -- [19]
			"59735:59186:60230:61759:61474:61744:61473", -- [20]
			"59735:59186:60230:61759:61474:61744:60416:61512", -- [21]
			"59735:59186:60230:61759", -- [22]
			"59735:59186:60230:62658", -- [23]
			"59735:59186:60230:61759:61474:61744:61473:62901", -- [24]
			"59735:59186:60230:61759:61474:61744:61473:62903", -- [25]
			"59735:59186:60230:61759:61474:61744:61473:62903:62898", -- [26]
			"59735:59186:60230:61759:61474:61744:61473:62903:62898:62909", -- [27]
			"59735:59186:60230:62658:61121", -- [28]
			"59735:59186:60230:60231:58843:63501", -- [29]
			"59735:59186:60230:60231:58843:63501:63498", -- [30]
			"59735:59186:60230:62658:61121:63500", -- [31]
			"59735:59186:60230:62658:61121:63497", -- [32]
			"59735:59186:64310", -- [33]
			"59735:59186:60230:60231:58843:63501:65511", -- [34]
			"59735:59186:60230:62658:61121:65865", -- [35]
			"59732:59727:56737:71940", -- [36]
			--["name"] = "Sri-La Village, Jade Forest",
			["m"] = 371,
			["coord"] = 2380414099,
			["direct"] = "59732:59735",
			["f"] = 0,
		},
		[59735] = {
			"59186:66023", -- [1]
			"59186:59732", -- [2]
			"59186:59727", -- [3]
			"59186:59727:56737", -- [4]
			"59186:60230", -- [5]
			"59186:60230:60231", -- [6]
			"59186:60230:60232", -- [7]
			"59186:60230:60231:59049", -- [8]
			"59186:60230:60231:58843", -- [9]
			"59186:60230:60231:59048", -- [10]
			"59186:60230:60231:65189", -- [11]
			"59186:60230:60231:59049:60441", -- [12]
			"59186:60230:61759:61474", -- [13]
			"59186:60230:61759:61474:61118", -- [14]
			"59186:60230:61759:61474:61744", -- [15]
			"59186:60230:61759:61474:61118:61511", -- [16]
			"59186:60230:61759:61474:61504", -- [17]
			"59186:60230:61759:61474:61744:60416", -- [18]
			"59186:60230:61759:61474:61744:61473", -- [19]
			"59186:60230:61759:61474:61744:60416:61512", -- [20]
			"59186:60230:61759", -- [21]
			"59186:60230:62658", -- [22]
			"59186:60230:61759:61474:61744:61473:62901", -- [23]
			"59186:60230:61759:61474:61744:61473:62903", -- [24]
			"59186:60230:61759:61474:61744:61473:62903:62898", -- [25]
			"59186:60230:61759:61474:61744:61473:62903:62898:62909", -- [26]
			"59186:60230:62658:61121", -- [27]
			"59186:60230:60231:58843:63501", -- [28]
			"59186:60230:60231:58843:63501:63498", -- [29]
			"59186:60230:62658:61121:63500", -- [30]
			"59186:60230:62658:61121:63497", -- [31]
			"59186:64310", -- [32]
			"59186:60230:60231:58843:63501:65511", -- [33]
			"59186:60230:62658:61121:65865", -- [34]
			"59186:71940", -- [35]
			--["name"] = "Emperor's Omen, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59186:59733:59736",
			["coord"] = 2184266963,
		},
		[59048] = {
			"60231:60230:59186", -- [1]
			"60231:60232:66023", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60232:66023:59727", -- [4]
			"60231:60230:59186:59735:59733", -- [5]
			"60231:60230:59186:59735", -- [6]
			"60231:60230:59186:59736", -- [7]
			"60231:60232:66023:56737", -- [8]
			"60231:60230", -- [9]
			"60231:60232", -- [10]
			"60231:62658:61759:61474", -- [11]
			"60231:62658:61759:61474:61118", -- [12]
			"60231:62658:61759:61474:61744", -- [13]
			"60231:62658:61759:61474:61118:61511", -- [14]
			"60231:62658:61759:61474:61504", -- [15]
			"63501:63500:62903:61473:60416", -- [16]
			"63501:63500:62903:61473", -- [17]
			"63501:63497:61512", -- [18]
			"60231:62658:61759", -- [19]
			"60231:62658", -- [20]
			"63501:63500:62903:62901", -- [21]
			"63501:63500:62903", -- [22]
			"63501:63500:62903:62898", -- [23]
			"63501:63500:62903:62898:62909", -- [24]
			"60231:61121", -- [25]
			"63501:63498", -- [26]
			"63501:63500", -- [27]
			"63501:63497", -- [28]
			"60231:60232:66023:56737:64310", -- [29]
			"63501:65511", -- [30]
			"60231:61121:65865", -- [31]
			"60231:60232:66023:56737:71940", -- [32]
			--["name"] = "Sentinel Basecamp, Krasarang Wilds",
			["direct"] = "60231:59049:58843:65189:60441:63501",
			["f"] = 0,
			["m"] = 418,
			["coord"] = 1078875572,
		},
		[61759] = {
			"60230:59186", -- [1]
			"60230:60232:66023", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59727", -- [4]
			"60230:59186:59735:59733", -- [5]
			"60230:59186:59735", -- [6]
			"60230:59186:59736", -- [7]
			"60230:60232:66023:56737", -- [8]
			"62658:60231", -- [9]
			"60230:60232", -- [10]
			"62658:60231:59049", -- [11]
			"62658:60231:58843", -- [12]
			"62658:60231:59048", -- [13]
			"62658:60231:65189", -- [14]
			"62658:60231:59049:60441", -- [15]
			"61474:61118", -- [16]
			"61474:61744", -- [17]
			"61474:61118:61511", -- [18]
			"61474:61504", -- [19]
			"61474:61744:60416", -- [20]
			"61474:61744:61473", -- [21]
			"61474:61744:60416:61512", -- [22]
			"61474:61744:61473:62901", -- [23]
			"61474:61744:61473:62903", -- [24]
			"61474:61744:61473:62903:62898", -- [25]
			"61474:61744:61473:62903:62898:62909", -- [26]
			"62658:61121", -- [27]
			"62658:60231:58843:63501", -- [28]
			"62658:60231:58843:63501:63498", -- [29]
			"62658:61121:63500", -- [30]
			"62658:61121:63497", -- [31]
			"60230:59186:64310", -- [32]
			"62658:60231:58843:63501:65511", -- [33]
			"62658:61121:65865", -- [34]
			"60230:60232:66023:56737:71940", -- [35]
			--["name"] = "Tavern in the Mists, The Veiled Stair",
			["m"] = 433,
			["f"] = 0,
			["direct"] = "60230:61474:62658",
			["coord"] = 2433204651,
		},
		[61511] = {
			"61118:61474:61759:60230:59186", -- [1]
			"61118:61474:66023", -- [2]
			"61118:61474:61759:60230:59186:59732", -- [3]
			"61118:61474:61759:60230:59186:59727", -- [4]
			"61118:61474:61759:60230:59186:59735:59733", -- [5]
			"61118:61474:61759:60230:59186:59735", -- [6]
			"61118:61474:61759:60230:59186:59736", -- [7]
			"61118:61474:66023:56737", -- [8]
			"61118:61474:61759:60230", -- [9]
			"61118:61474:61759:62658:60231", -- [10]
			"61118:61474:60232", -- [11]
			"61118:61474:61759:62658:60231:59049", -- [12]
			"61118:61474:61759:62658:60231:58843", -- [13]
			"61118:61474:61759:62658:60231:59048", -- [14]
			"61118:61474:61759:62658:60231:65189", -- [15]
			"61118:61474:61759:62658:60231:59049:60441", -- [16]
			"61118:61474", -- [17]
			"61504:60416", -- [18]
			"61744:61473", -- [19]
			"61504:60416:61512", -- [20]
			"61118:61474:61759", -- [21]
			"61118:61474:61759:62658", -- [22]
			"61504:60416:61512:62901", -- [23]
			"61744:61473:62903", -- [24]
			"61744:61473:62903:62898", -- [25]
			"61744:61473:62903:62898:62909", -- [26]
			"61744:61121", -- [27]
			"61744:61473:62903:63500:63501", -- [28]
			"61744:61473:62903:63500:63501:63498", -- [29]
			"61744:61473:62903:63500", -- [30]
			"61744:61121:63497", -- [31]
			"61118:61474:61759:60230:59186:64310", -- [32]
			"61744:61473:62903:63500:63501:65511", -- [33]
			"61744:61121:65865", -- [34]
			"61118:61474:66023:56737:71940", -- [35]
			--["name"] = "Zouchin Village, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "61118:61744:61504",
			["coord"] = 2681621769,
		},
		[62901] = {
			"61473:61744:61474:61759:60230:59186", -- [1]
			"61473:61744:61474:66023", -- [2]
			"61473:61744:61474:61759:60230:59186:59732", -- [3]
			"61473:61744:61474:61759:60230:59186:59727", -- [4]
			"61473:61744:61474:61759:60230:59186:59735:59733", -- [5]
			"61473:61744:61474:61759:60230:59186:59735", -- [6]
			"61473:61744:61474:61759:60230:59186:59736", -- [7]
			"61473:61744:61474:66023:56737", -- [8]
			"61473:61744:61474:61759:60230", -- [9]
			"61473:61744:61474:61759:62658:60231", -- [10]
			"61473:61744:61474:60232", -- [11]
			"61473:61744:61474:61759:62658:60231:59049", -- [12]
			"62903:63500:63501:58843", -- [13]
			"62903:63500:63501:59048", -- [14]
			"62903:63500:63501:59048:65189", -- [15]
			"62903:63500:63501:59048:60441", -- [16]
			"61473:61744:61474", -- [17]
			"61512:60416:61504:61118", -- [18]
			"61473:61744", -- [19]
			"61512:60416:61504:61118:61511", -- [20]
			"61512:60416:61504", -- [21]
			"61512:60416", -- [22]
			"61473:61744:61474:61759", -- [23]
			"61473:61744:61474:61759:62658", -- [24]
			"62898:62909", -- [25]
			"61473:61744:61121", -- [26]
			"62903:63500:63501", -- [27]
			"62903:63500:63501:63498", -- [28]
			"62903:63500", -- [29]
			"62903:63500:63497", -- [30]
			"61473:61744:61474:61759:60230:59186:64310", -- [31]
			"62903:63500:63501:65511", -- [32]
			"61473:61744:61121:65865", -- [33]
			"61473:61744:61474:66023:56737:71940", -- [34]
			--["name"] = "Longying Outpost, Townlong Steppes",
			["m"] = 388,
			["f"] = 0,
			["direct"] = "61473:61512:62903:62898",
			["coord"] = 3054473921,
		},
		[59186] = {
			"59735:59733", -- [1]
			"60230:60231", -- [2]
			"60230:60232", -- [3]
			"60230:60231:59049", -- [4]
			"60230:60231:58843", -- [5]
			"60230:60231:59048", -- [6]
			"60230:60231:65189", -- [7]
			"60230:60231:59049:60441", -- [8]
			"60230:61759:61474", -- [9]
			"60230:61759:61474:61118", -- [10]
			"60230:61759:61474:61744", -- [11]
			"60230:61759:61474:61118:61511", -- [12]
			"60230:61759:61474:61504", -- [13]
			"60230:61759:61474:61744:60416", -- [14]
			"60230:61759:61474:61744:61473", -- [15]
			"60230:61759:61474:61744:60416:61512", -- [16]
			"60230:61759", -- [17]
			"60230:62658", -- [18]
			"60230:61759:61474:61744:61473:62901", -- [19]
			"60230:61759:61474:61744:61473:62903", -- [20]
			"60230:61759:61474:61744:61473:62903:62898", -- [21]
			"60230:61759:61474:61744:61473:62903:62898:62909", -- [22]
			"60230:60231:58843:63501", -- [23]
			"60230:60231:58843:63501:63498", -- [24]
			"60230:62658:61121:63500", -- [25]
			"60230:62658:61121:63497", -- [26]
			"60230:60231:58843:63501:65511", -- [27]
			"60230:62658:61121:65865", -- [28]
			--["name"] = "Dawn's Blossom, Jade Forest",
			["direct"] = "66023:59732:59727:59735:59736:56737:60230:61121:64310:71940",
			["f"] = 0,
			["m"] = 371,
			["coord"] = 2019325514,
		},
		[62909] = {
			"62898:62903:61473:61744:61474:61759:60230:59186", -- [1]
			"62898:62903:61473:61744:61474:66023", -- [2]
			"62898:62903:61473:61744:61474:61759:60230:59186:59732", -- [3]
			"62898:62903:61473:61744:61474:61759:60230:59186:59727", -- [4]
			"62898:62903:61473:61744:61474:61759:60230:59186:59735:59733", -- [5]
			"62898:62903:61473:61744:61474:61759:60230:59186:59735", -- [6]
			"62898:62903:61473:61744:61474:61759:60230:59186:59736", -- [7]
			"62898:62903:61473:61744:61474:66023:56737", -- [8]
			"62898:62903:61473:61744:61474:61759:60230", -- [9]
			"62898:62903:63500:63501:58843:60231", -- [10]
			"62898:62903:63500:63501:58843:60231:60232", -- [11]
			"62898:62903:63500:63501:58843:60231:59049", -- [12]
			"62898:62903:63500:63501:58843", -- [13]
			"62898:62903:63500:63501:59048", -- [14]
			"62898:62903:63500:63501:59048:65189", -- [15]
			"62898:62903:63500:63501:59048:60441", -- [16]
			"62898:62903:61473:61744:61474", -- [17]
			"62898:62901:61512:60416:61504:61118", -- [18]
			"62898:62903:61473:61744", -- [19]
			"62898:62901:61512:60416:61504:61118:61511", -- [20]
			"62898:62901:61512:60416:61504", -- [21]
			"62898:62901:61512:60416", -- [22]
			"62898:62903:61473", -- [23]
			"62898:62901:61512", -- [24]
			"62898:62903:61473:61744:61474:61759", -- [25]
			"62898:62903:61473:61744:61474:61759:62658", -- [26]
			"62898:62901", -- [27]
			"62898:62903", -- [28]
			"62898:62903:61473:61744:61121", -- [29]
			"62898:62903:63500:63501", -- [30]
			"62898:62903:63500:63501:63498", -- [31]
			"62898:62903:63500", -- [32]
			"62898:62903:63500:63497", -- [33]
			"62898:62903:61473:61744:61474:61759:60230:59186:64310", -- [34]
			"62898:62903:63500:63501:65511", -- [35]
			"62898:62903:61473:61744:61121:65865", -- [36]
			"62898:62903:61473:61744:61474:66023:56737:71940", -- [37]
			--["name"] = "Shado-Pan Garrison, Townlong Steppes",
			["m"] = 388,
			["f"] = 0,
			["direct"] = "62898",
			["coord"] = 2149824560,
		},
		[56737] = {
			"59727:59732", -- [1]
			"59727:59732:59733", -- [2]
			"59186:59735", -- [3]
			"59186:59736", -- [4]
			"66023:60232:60230", -- [5]
			"66023:60232:60231", -- [6]
			"66023:60232", -- [7]
			"66023:60232:60231:59049", -- [8]
			"66023:60232:60231:58843", -- [9]
			"66023:60232:60231:59048", -- [10]
			"66023:60232:60231:65189", -- [11]
			"66023:60232:60231:59049:60441", -- [12]
			"66023:61474", -- [13]
			"66023:61474:61118", -- [14]
			"66023:61474:61744", -- [15]
			"66023:61474:61118:61511", -- [16]
			"66023:61474:61504", -- [17]
			"66023:61474:61744:60416", -- [18]
			"66023:61474:61744:61473", -- [19]
			"66023:61474:61744:60416:61512", -- [20]
			"66023:60232:60230:61759", -- [21]
			"66023:60232:60230:62658", -- [22]
			"66023:61474:61744:61473:62901", -- [23]
			"66023:61474:61744:61473:62903", -- [24]
			"66023:61474:61744:61473:62903:62898", -- [25]
			"66023:61474:61744:61473:62903:62898:62909", -- [26]
			"66023:61121", -- [27]
			"66023:60232:60231:58843:63501", -- [28]
			"66023:60232:60231:58843:63501:63498", -- [29]
			"66023:61121:63500", -- [30]
			"66023:61121:63497", -- [31]
			"66023:60232:60231:58843:63501:65511", -- [32]
			"66023:61121:65865", -- [33]
			--["name"] = "Pearlfin Village, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59186:66023:59727:64310:71940",
			["coord"] = 2488849182,
		},
		[66023] = {
			"59727:59732", -- [1]
			"59727:59732:59733", -- [2]
			"59186:59735", -- [3]
			"59186:59736", -- [4]
			"60232:60230", -- [5]
			"60232:60231", -- [6]
			"60232:60231:59049", -- [7]
			"60232:60231:58843", -- [8]
			"60232:60231:59048", -- [9]
			"60232:60231:65189", -- [10]
			"60232:60231:59049:60441", -- [11]
			"61474:61118", -- [12]
			"61474:61744", -- [13]
			"61474:61118:61511", -- [14]
			"61474:61504", -- [15]
			"61474:61744:60416", -- [16]
			"61474:61744:61473", -- [17]
			"61474:61744:60416:61512", -- [18]
			"60232:60230:61759", -- [19]
			"60232:60230:62658", -- [20]
			"61474:61744:61473:62901", -- [21]
			"61474:61744:61473:62903", -- [22]
			"61474:61744:61473:62903:62898", -- [23]
			"61474:61744:61473:62903:62898:62909", -- [24]
			"60232:60231:58843:63501", -- [25]
			"60232:60231:58843:63501:63498", -- [26]
			"61121:63500", -- [27]
			"61121:63497", -- [28]
			"56737:64310", -- [29]
			"60232:60231:58843:63501:65511", -- [30]
			"61121:65865", -- [31]
			"56737:71940", -- [32]
			--["name"] = "Paw'Don Village, Jade Forest",
			["direct"] = "59186:59727:56737:60232:61474:61121",
			["f"] = 0,
			["m"] = 371,
			["coord"] = 1977276871,
		},
		[65189] = {
			"60231:60230:59186", -- [1]
			"60231:60232:66023", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60232:66023:59727", -- [4]
			"60231:60230:59186:59735:59733", -- [5]
			"60231:60230:59186:59735", -- [6]
			"60231:60230:59186:59736", -- [7]
			"60231:60232:66023:56737", -- [8]
			"60231:60230", -- [9]
			"60231:60232", -- [10]
			"60231:62658:61759:61474", -- [11]
			"60231:62658:61759:61474:61118", -- [12]
			"60231:62658:61759:61474:61744", -- [13]
			"60231:62658:61759:61474:61118:61511", -- [14]
			"60231:62658:61759:61474:61504", -- [15]
			"59048:63501:63500:62903:61473:60416", -- [16]
			"59048:63501:63500:62903:61473", -- [17]
			"59048:63501:63497:61512", -- [18]
			"60231:62658:61759", -- [19]
			"60231:62658", -- [20]
			"59048:63501:63500:62903:62901", -- [21]
			"59048:63501:63500:62903", -- [22]
			"59048:63501:63500:62903:62898", -- [23]
			"59048:63501:63500:62903:62898:62909", -- [24]
			"60231:61121", -- [25]
			"59048:63501", -- [26]
			"59048:63501:63498", -- [27]
			"59048:63501:63500", -- [28]
			"59048:63501:63497", -- [29]
			"60231:60232:66023:56737:64310", -- [30]
			"59048:63501:65511", -- [31]
			"60231:61121:65865", -- [32]
			"60231:60232:66023:56737:71940", -- [33]
			--["name"] = "Cradle of Chi-Ji, Krasarang Wilds",
			["m"] = 418,
			["f"] = 0,
			["direct"] = "60231:59049:58843:59048:60441",
			["coord"] = 1341694345,
		},
		[61474] = {
			"61759:60230:59186", -- [1]
			"61759:60230:59186:59732", -- [2]
			"61759:60230:59186:59727", -- [3]
			"61759:60230:59186:59735:59733", -- [4]
			"61759:60230:59186:59735", -- [5]
			"61759:60230:59186:59736", -- [6]
			"66023:56737", -- [7]
			"61759:60230", -- [8]
			"61759:62658:60231", -- [9]
			"61759:62658:60231:59049", -- [10]
			"61759:62658:60231:58843", -- [11]
			"61759:62658:60231:59048", -- [12]
			"61759:62658:60231:65189", -- [13]
			"61759:62658:60231:59049:60441", -- [14]
			"61118:61511", -- [15]
			"61744:60416", -- [16]
			"61744:61473", -- [17]
			"61744:60416:61512", -- [18]
			"61759:62658", -- [19]
			"61744:61473:62901", -- [20]
			"61744:61473:62903", -- [21]
			"61744:61473:62903:62898", -- [22]
			"61744:61473:62903:62898:62909", -- [23]
			"61744:61473:62903:63500:63501", -- [24]
			"61744:61473:62903:63500:63501:63498", -- [25]
			"61744:61473:62903:63500", -- [26]
			"61121:63497", -- [27]
			"61759:60230:59186:64310", -- [28]
			"61744:61473:62903:63500:63501:65511", -- [29]
			"61121:65865", -- [30]
			"66023:56737:71940", -- [31]
			--["name"] = "Binan Village, Kun-Lai Summit",
			["direct"] = "66023:60232:61118:61744:61504:61759:61121",
			["f"] = 0,
			["m"] = 379,
			["coord"] = 3112694019,
		},
		[62903] = {
			"61473:61744:61474:61759:60230:59186", -- [1]
			"61473:61744:61474:66023", -- [2]
			"61473:61744:61474:61759:60230:59186:59732", -- [3]
			"61473:61744:61474:61759:60230:59186:59727", -- [4]
			"61473:61744:61474:61759:60230:59186:59735:59733", -- [5]
			"61473:61744:61474:61759:60230:59186:59735", -- [6]
			"61473:61744:61474:61759:60230:59186:59736", -- [7]
			"61473:61744:61474:66023:56737", -- [8]
			"61473:61744:61474:61759:60230", -- [9]
			"63500:63501:58843:60231", -- [10]
			"63500:63501:58843:60231:60232", -- [11]
			"63500:63501:58843:60231:59049", -- [12]
			"63500:63501:58843", -- [13]
			"63500:63501:59048", -- [14]
			"63500:63501:59048:65189", -- [15]
			"63500:63501:59048:60441", -- [16]
			"61473:61744:61474", -- [17]
			"61473:60416:61504:61118", -- [18]
			"61473:61744", -- [19]
			"61473:60416:61504:61118:61511", -- [20]
			"61473:60416:61504", -- [21]
			"61473:60416", -- [22]
			"62901:61512", -- [23]
			"61473:61744:61474:61759", -- [24]
			"61473:61744:61474:61759:62658", -- [25]
			"62898:62909", -- [26]
			"61473:61744:61121", -- [27]
			"63500:63501", -- [28]
			"63500:63501:63498", -- [29]
			"63500:63497", -- [30]
			"61473:61744:61474:61759:60230:59186:64310", -- [31]
			"63500:63501:65511", -- [32]
			"61473:61744:61121:65865", -- [33]
			"61473:61744:61474:66023:56737:71940", -- [34]
			--["name"] = "Gao-Ran Battlefront, Townlong Steppes",
			["m"] = 388,
			["f"] = 0,
			["direct"] = "61473:62901:62898:63500",
			["coord"] = 3196440686,
		},
		[65865] = {
			"61121:60230:59186", -- [1]
			"61121:66023", -- [2]
			"61121:60230:59186:59732", -- [3]
			"61121:60230:59186:59727", -- [4]
			"61121:60230:59186:59735:59733", -- [5]
			"61121:60230:59186:59735", -- [6]
			"61121:60230:59186:59736", -- [7]
			"61121:66023:56737", -- [8]
			"61121:60230", -- [9]
			"61121:60231", -- [10]
			"61121:60231:60232", -- [11]
			"61121:60231:59049", -- [12]
			"61121:60231:58843", -- [13]
			"61121:60231:59048", -- [14]
			"61121:60231:65189", -- [15]
			"61121:60231:59049:60441", -- [16]
			"61121:61474", -- [17]
			"61121:61744:61504:61118", -- [18]
			"61121:61744", -- [19]
			"61121:61744:61504:61118:61511", -- [20]
			"61121:61744:61504", -- [21]
			"61121:61744:60416", -- [22]
			"61121:61744:61473", -- [23]
			"61121:61744:60416:61512", -- [24]
			"61121:62658:61759", -- [25]
			"61121:62658", -- [26]
			"61121:61744:61473:62901", -- [27]
			"61121:61744:61473:62903", -- [28]
			"61121:61744:61473:62903:62898", -- [29]
			"61121:61744:61473:62903:62898:62909", -- [30]
			"61121:63501", -- [31]
			"61121:63497:63498", -- [32]
			"61121:63500", -- [33]
			"61121:63497", -- [34]
			"61121:60230:59186:64310", -- [35]
			"61121:63501:65511", -- [36]
			"61121:66023:56737:71940", -- [37]
			--["name"] = "The Lion's Redoubt, Dread Wastes",
			["m"] = 424,
			["f"] = 0,
			["direct"] = "61121",
			["coord"] = 1814536065,
		},
		[63498] = {
			"63501:58843:60231:60230:59186", -- [1]
			"63501:58843:60231:60232:66023", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60232:66023:59727", -- [4]
			"63501:58843:60231:60230:59186:59735:59733", -- [5]
			"63501:58843:60231:60230:59186:59735", -- [6]
			"63501:58843:60231:60230:59186:59736", -- [7]
			"63501:58843:60231:60232:66023:56737", -- [8]
			"63501:58843:60231:60230", -- [9]
			"63501:58843:60231", -- [10]
			"63501:58843:60231:60232", -- [11]
			"63501:58843:60231:59049", -- [12]
			"63501:58843", -- [13]
			"63501:59048", -- [14]
			"63501:59048:65189", -- [15]
			"63501:59048:60441", -- [16]
			"63501:63500:62903:61473:61744:61474", -- [17]
			"63501:63500:62903:61473:60416:61504:61118", -- [18]
			"63501:63500:62903:61473:61744", -- [19]
			"63501:63500:62903:61473:60416:61504:61118:61511", -- [20]
			"63501:63500:62903:61473:60416:61504", -- [21]
			"63501:63500:62903:61473:60416", -- [22]
			"63501:63500:62903:61473", -- [23]
			"63497:61512", -- [24]
			"63501:58843:60231:62658:61759", -- [25]
			"63501:58843:60231:62658", -- [26]
			"63501:63500:62903:62901", -- [27]
			"63501:63500:62903", -- [28]
			"63501:63500:62903:62898", -- [29]
			"63501:63500:62903:62898:62909", -- [30]
			"63497:61121", -- [31]
			"63501:63500", -- [32]
			"63501:58843:60231:60232:66023:56737:64310", -- [33]
			"63497:61121:65865", -- [34]
			"63501:58843:60231:60232:66023:56737:71940", -- [35]
			--["name"] = "Soggy's Gamble, Dread Wastes",
			["m"] = 422,
			["f"] = 0,
			["direct"] = "63501:63497:65511",
			["coord"] = 2410197898,
		},
		[63500] = {
			"63501:58843:60231:60230:59186", -- [1]
			"63501:58843:60231:60232:66023", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60232:66023:59727", -- [4]
			"63501:58843:60231:60230:59186:59735:59733", -- [5]
			"63501:58843:60231:60230:59186:59735", -- [6]
			"63501:58843:60231:60230:59186:59736", -- [7]
			"63501:58843:60231:60232:66023:56737", -- [8]
			"63501:58843:60231:60230", -- [9]
			"63501:58843:60231", -- [10]
			"63501:58843:60231:60232", -- [11]
			"63501:58843:60231:59049", -- [12]
			"63501:58843", -- [13]
			"63501:59048", -- [14]
			"63501:59048:65189", -- [15]
			"63501:59048:60441", -- [16]
			"62903:61473:61744:61474", -- [17]
			"62903:61473:60416:61504:61118", -- [18]
			"62903:61473:61744", -- [19]
			"62903:61473:60416:61504:61118:61511", -- [20]
			"62903:61473:60416:61504", -- [21]
			"62903:61473:60416", -- [22]
			"62903:61473", -- [23]
			"62903:62901:61512", -- [24]
			"63501:58843:60231:62658:61759", -- [25]
			"63501:58843:60231:62658", -- [26]
			"62903:62901", -- [27]
			"62903:62898", -- [28]
			"62903:62898:62909", -- [29]
			"63501:63498", -- [30]
			"63501:58843:60231:60232:66023:56737:64310", -- [31]
			"63501:65511", -- [32]
			"61121:65865", -- [33]
			"63501:58843:60231:60232:66023:56737:71940", -- [34]
			--["name"] = "The Sunset Brewgarden, Dread Wastes",
			["m"] = 422,
			["f"] = 0,
			["direct"] = "62903:61121:63501:63497",
			["coord"] = 2156797729,
		},
		[61121] = {
			"60230:59186:59732", -- [1]
			"60230:59186:59727", -- [2]
			"60230:59186:59735:59733", -- [3]
			"60230:59186:59735", -- [4]
			"60230:59186:59736", -- [5]
			"66023:56737", -- [6]
			"60231:60232", -- [7]
			"60231:59049", -- [8]
			"60231:58843", -- [9]
			"60231:59048", -- [10]
			"60231:65189", -- [11]
			"60231:59049:60441", -- [12]
			"61744:61504:61118", -- [13]
			"61744:61504:61118:61511", -- [14]
			"61744:61504", -- [15]
			"61744:60416", -- [16]
			"61744:61473", -- [17]
			"61744:60416:61512", -- [18]
			"62658:61759", -- [19]
			"61744:61473:62901", -- [20]
			"61744:61473:62903", -- [21]
			"61744:61473:62903:62898", -- [22]
			"61744:61473:62903:62898:62909", -- [23]
			"63497:63498", -- [24]
			"60230:59186:64310", -- [25]
			"63501:65511", -- [26]
			"66023:56737:71940", -- [27]
			--["name"] = "Shrine of Seven Stars, Vale of Eternal Blossoms",
			["direct"] = "59186:66023:60230:60231:61474:61744:62658:63501:63500:63497:65865",
			["f"] = 0,
			["m"] = 390,
			["coord"] = 3639713665,
		},
		[62898] = {
			"62903:61473:61744:61474:61759:60230:59186", -- [1]
			"62903:61473:61744:61474:66023", -- [2]
			"62903:61473:61744:61474:61759:60230:59186:59732", -- [3]
			"62903:61473:61744:61474:61759:60230:59186:59727", -- [4]
			"62903:61473:61744:61474:61759:60230:59186:59735:59733", -- [5]
			"62903:61473:61744:61474:61759:60230:59186:59735", -- [6]
			"62903:61473:61744:61474:61759:60230:59186:59736", -- [7]
			"62903:61473:61744:61474:66023:56737", -- [8]
			"62903:61473:61744:61474:61759:60230", -- [9]
			"62903:63500:63501:58843:60231", -- [10]
			"62903:63500:63501:58843:60231:60232", -- [11]
			"62903:63500:63501:58843:60231:59049", -- [12]
			"62903:63500:63501:58843", -- [13]
			"62903:63500:63501:59048", -- [14]
			"62903:63500:63501:59048:65189", -- [15]
			"62903:63500:63501:59048:60441", -- [16]
			"62903:61473:61744:61474", -- [17]
			"62901:61512:60416:61504:61118", -- [18]
			"62903:61473:61744", -- [19]
			"62901:61512:60416:61504:61118:61511", -- [20]
			"62901:61512:60416:61504", -- [21]
			"62901:61512:60416", -- [22]
			"62903:61473", -- [23]
			"62901:61512", -- [24]
			"62903:61473:61744:61474:61759", -- [25]
			"62903:61473:61744:61474:61759:62658", -- [26]
			"62903:61473:61744:61121", -- [27]
			"62903:63500:63501", -- [28]
			"62903:63500:63501:63498", -- [29]
			"62903:63500", -- [30]
			"62903:63500:63497", -- [31]
			"62903:61473:61744:61474:61759:60230:59186:64310", -- [32]
			"62903:63500:63501:65511", -- [33]
			"62903:61473:61744:61121:65865", -- [34]
			"62903:61473:61744:61474:66023:56737:71940", -- [35]
			--["name"] = "Rensai's Watchpost, Townlong Steppes",
			["m"] = 388,
			["f"] = 0,
			["direct"] = "62901:62903:62909",
			["coord"] = 2329659992,
		},
		[60230] = {
			"60232:66023", -- [1]
			"59186:59732", -- [2]
			"59186:59727", -- [3]
			"59186:59735:59733", -- [4]
			"59186:59735", -- [5]
			"59186:59736", -- [6]
			"60232:66023:56737", -- [7]
			"60231:59049", -- [8]
			"60231:58843", -- [9]
			"60231:59048", -- [10]
			"60231:65189", -- [11]
			"60231:59049:60441", -- [12]
			"61759:61474", -- [13]
			"61759:61474:61118", -- [14]
			"61759:61474:61744", -- [15]
			"61759:61474:61118:61511", -- [16]
			"61759:61474:61504", -- [17]
			"61759:61474:61744:60416", -- [18]
			"61759:61474:61744:61473", -- [19]
			"61759:61474:61744:60416:61512", -- [20]
			"61759:61474:61744:61473:62901", -- [21]
			"61759:61474:61744:61473:62903", -- [22]
			"61759:61474:61744:61473:62903:62898", -- [23]
			"61759:61474:61744:61473:62903:62898:62909", -- [24]
			"60231:58843:63501", -- [25]
			"60231:58843:63501:63498", -- [26]
			"62658:61121:63500", -- [27]
			"62658:61121:63497", -- [28]
			"59186:64310", -- [29]
			"60231:58843:63501:65511", -- [30]
			"62658:61121:65865", -- [31]
			"60232:66023:56737:71940", -- [32]
			--["name"] = "Pang's Stead, Valley of the Four Winds",
			["direct"] = "59186:60231:60232:61759:62658:61121",
			["f"] = 0,
			["m"] = 376,
			["coord"] = 3629594111,
		},
		[60232] = {
			"60230:59186", -- [1]
			"60230:59186:59732", -- [2]
			"66023:59727", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:59186:59736", -- [6]
			"66023:56737", -- [7]
			"60231:59049", -- [8]
			"60231:58843", -- [9]
			"60231:59048", -- [10]
			"60231:65189", -- [11]
			"60231:59049:60441", -- [12]
			"61474:61118", -- [13]
			"61474:61744", -- [14]
			"61474:61118:61511", -- [15]
			"61474:61504", -- [16]
			"61474:61744:60416", -- [17]
			"61474:61744:61473", -- [18]
			"61474:61744:60416:61512", -- [19]
			"60230:61759", -- [20]
			"60230:62658", -- [21]
			"61474:61744:61473:62901", -- [22]
			"61474:61744:61473:62903", -- [23]
			"61474:61744:61473:62903:62898", -- [24]
			"61474:61744:61473:62903:62898:62909", -- [25]
			"60231:61121", -- [26]
			"60231:58843:63501", -- [27]
			"60231:58843:63501:63498", -- [28]
			"60231:58843:63501:63500", -- [29]
			"60231:61121:63497", -- [30]
			"66023:56737:64310", -- [31]
			"60231:58843:63501:65511", -- [32]
			"60231:61121:65865", -- [33]
			"66023:56737:71940", -- [34]
			--["name"] = "Zhu's Watch, Krasarang Wilds",
			["m"] = 418,
			["f"] = 0,
			["direct"] = "66023:60230:60231:61474",
			["coord"] = 3294762427,
		},
		[59732] = {
			"59727:66023", -- [1]
			"59186:59735", -- [2]
			"59186:59736", -- [3]
			"59727:56737", -- [4]
			"59186:60230", -- [5]
			"59186:60230:60231", -- [6]
			"59727:66023:60232", -- [7]
			"59186:60230:60231:59049", -- [8]
			"59186:60230:60231:58843", -- [9]
			"59186:60230:60231:59048", -- [10]
			"59186:60230:60231:65189", -- [11]
			"59186:60230:60231:59049:60441", -- [12]
			"59186:60230:61759:61474", -- [13]
			"59186:60230:61759:61474:61118", -- [14]
			"59186:60230:61759:61474:61744", -- [15]
			"59186:60230:61759:61474:61118:61511", -- [16]
			"59186:60230:61759:61474:61504", -- [17]
			"59186:60230:61759:61474:61744:60416", -- [18]
			"59186:60230:61759:61474:61744:61473", -- [19]
			"59186:60230:61759:61474:61744:60416:61512", -- [20]
			"59186:60230:61759", -- [21]
			"59186:60230:62658", -- [22]
			"59186:60230:61759:61474:61744:61473:62901", -- [23]
			"59186:60230:61759:61474:61744:61473:62903", -- [24]
			"59186:60230:61759:61474:61744:61473:62903:62898", -- [25]
			"59186:60230:61759:61474:61744:61473:62903:62898:62909", -- [26]
			"59186:60230:62658:61121", -- [27]
			"59186:60230:60231:58843:63501", -- [28]
			"59186:60230:60231:58843:63501:63498", -- [29]
			"59186:60230:62658:61121:63500", -- [30]
			"59186:60230:62658:61121:63497", -- [31]
			"59186:64310", -- [32]
			"59186:60230:60231:58843:63501:65511", -- [33]
			"59186:60230:62658:61121:65865", -- [34]
			"59727:56737:71940", -- [35]
			--["name"] = "The Arboretum, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59186:59727:59733",
			["coord"] = 2449305813,
		},
		[61118] = {
			"61474:61759:60230:59186", -- [1]
			"61474:66023", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:61759:60230:59186:59727", -- [4]
			"61474:61759:60230:59186:59735:59733", -- [5]
			"61474:61759:60230:59186:59735", -- [6]
			"61474:61759:60230:59186:59736", -- [7]
			"61474:66023:56737", -- [8]
			"61474:61759:60230", -- [9]
			"61474:61759:62658:60231", -- [10]
			"61474:60232", -- [11]
			"61474:61759:62658:60231:59049", -- [12]
			"61474:61759:62658:60231:58843", -- [13]
			"61474:61759:62658:60231:59048", -- [14]
			"61474:61759:62658:60231:65189", -- [15]
			"61474:61759:62658:60231:59049:60441", -- [16]
			"61504:60416", -- [17]
			"61744:61473", -- [18]
			"61504:60416:61512", -- [19]
			"61474:61759", -- [20]
			"61474:61759:62658", -- [21]
			"61504:60416:61512:62901", -- [22]
			"61744:61473:62903", -- [23]
			"61744:61473:62903:62898", -- [24]
			"61744:61473:62903:62898:62909", -- [25]
			"61744:61121", -- [26]
			"61744:61473:62903:63500:63501", -- [27]
			"61744:61473:62903:63500:63501:63498", -- [28]
			"61744:61473:62903:63500", -- [29]
			"61744:61121:63497", -- [30]
			"61474:61759:60230:59186:64310", -- [31]
			"61744:61473:62903:63500:63501:65511", -- [32]
			"61744:61121:65865", -- [33]
			"61474:66023:56737:71940", -- [34]
			--["name"] = "Temple of the White Tiger, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "61474:61744:61511:61504",
			["coord"] = 2847310268,
		},
		[61744] = {
			"61474:61759:60230:59186", -- [1]
			"61474:66023", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:61759:60230:59186:59727", -- [4]
			"61474:61759:60230:59186:59735:59733", -- [5]
			"61474:61759:60230:59186:59735", -- [6]
			"61474:61759:60230:59186:59736", -- [7]
			"61474:66023:56737", -- [8]
			"61474:61759:60230", -- [9]
			"61474:61759:62658:60231", -- [10]
			"61474:60232", -- [11]
			"61474:61759:62658:60231:59049", -- [12]
			"61473:62903:63500:63501:58843", -- [13]
			"61473:62903:63500:63501:59048", -- [14]
			"61474:61759:62658:60231:65189", -- [15]
			"61474:61759:62658:60231:59049:60441", -- [16]
			"60416:61512", -- [17]
			"61474:61759", -- [18]
			"61474:61759:62658", -- [19]
			"61473:62901", -- [20]
			"61473:62903", -- [21]
			"61473:62903:62898", -- [22]
			"61473:62903:62898:62909", -- [23]
			"61473:62903:63500:63501", -- [24]
			"61473:62903:63500:63501:63498", -- [25]
			"61473:62903:63500", -- [26]
			"61121:63497", -- [27]
			"61474:61759:60230:59186:64310", -- [28]
			"61473:62903:63500:63501:65511", -- [29]
			"61121:65865", -- [30]
			"61474:66023:56737:71940", -- [31]
			--["name"] = "Westwind Rest, Kun-Lai Summit",
			["direct"] = "61474:61118:61511:61504:60416:61473:61121",
			["f"] = 0,
			["m"] = 379,
			["coord"] = 2316752808,
		},
		[59736] = {
			"59186:66023", -- [1]
			"59186:59732", -- [2]
			"59186:59727", -- [3]
			"59735:59733", -- [4]
			"59186:59727:56737", -- [5]
			"59186:60230", -- [6]
			"59186:60230:60231", -- [7]
			"59186:60230:60232", -- [8]
			"59186:60230:60231:59049", -- [9]
			"59186:60230:60231:58843", -- [10]
			"59186:60230:60231:59048", -- [11]
			"59186:60230:60231:65189", -- [12]
			"59186:60230:60231:59049:60441", -- [13]
			"59186:60230:61759:61474", -- [14]
			"59186:60230:61759:61474:61118", -- [15]
			"59186:60230:61759:61474:61744", -- [16]
			"59186:60230:61759:61474:61118:61511", -- [17]
			"59186:60230:61759:61474:61504", -- [18]
			"59186:60230:61759:61474:61744:60416", -- [19]
			"59186:60230:61759:61474:61744:61473", -- [20]
			"59186:60230:61759:61474:61744:60416:61512", -- [21]
			"59186:60230:61759", -- [22]
			"59186:60230:62658", -- [23]
			"59186:60230:61759:61474:61744:61473:62901", -- [24]
			"59186:60230:61759:61474:61744:61473:62903", -- [25]
			"59186:60230:61759:61474:61744:61473:62903:62898", -- [26]
			"59186:60230:61759:61474:61744:61473:62903:62898:62909", -- [27]
			"59186:60230:62658:61121", -- [28]
			"59186:60230:60231:58843:63501", -- [29]
			"59186:60230:60231:58843:63501:63498", -- [30]
			"59186:60230:62658:61121:63500", -- [31]
			"59186:60230:62658:61121:63497", -- [32]
			"59186:64310", -- [33]
			"59186:60230:60231:58843:63501:65511", -- [34]
			"59186:60230:62658:61121:65865", -- [35]
			"59186:71940", -- [36]
			--["name"] = "Tian Monastery, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59186:59735",
			["coord"] = 1870937816,
		},
		[59727] = {
			"59732:59733", -- [1]
			"59186:59735", -- [2]
			"59186:59736", -- [3]
			"59186:60230", -- [4]
			"66023:60232:60231", -- [5]
			"66023:60232", -- [6]
			"66023:60232:60231:59049", -- [7]
			"66023:60232:60231:58843", -- [8]
			"66023:60232:60231:59048", -- [9]
			"66023:60232:60231:65189", -- [10]
			"66023:60232:60231:59049:60441", -- [11]
			"66023:61474", -- [12]
			"66023:61474:61118", -- [13]
			"66023:61474:61744", -- [14]
			"66023:61474:61118:61511", -- [15]
			"66023:61474:61504", -- [16]
			"66023:61474:61744:60416", -- [17]
			"66023:61474:61744:61473", -- [18]
			"66023:61474:61744:60416:61512", -- [19]
			"59186:60230:61759", -- [20]
			"59186:60230:62658", -- [21]
			"66023:61474:61744:61473:62901", -- [22]
			"66023:61474:61744:61473:62903", -- [23]
			"66023:61474:61744:61473:62903:62898", -- [24]
			"66023:61474:61744:61473:62903:62898:62909", -- [25]
			"66023:61121", -- [26]
			"66023:60232:60231:58843:63501", -- [27]
			"66023:60232:60231:58843:63501:63498", -- [28]
			"66023:61121:63500", -- [29]
			"66023:61121:63497", -- [30]
			"56737:64310", -- [31]
			"66023:60232:60231:58843:63501:65511", -- [32]
			"66023:61121:65865", -- [33]
			"56737:71940", -- [34]
			--["name"] = "Jade Temple Grounds, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59186:66023:59732:56737",
			["coord"] = 2343935577,
		},
		[61504] = {
			"61474:61759:60230:59186", -- [1]
			"61474:66023", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:61759:60230:59186:59727", -- [4]
			"61474:61759:60230:59186:59735:59733", -- [5]
			"61474:61759:60230:59186:59735", -- [6]
			"61474:61759:60230:59186:59736", -- [7]
			"61474:66023:56737", -- [8]
			"61474:61759:60230", -- [9]
			"61474:61759:62658:60231", -- [10]
			"61474:60232", -- [11]
			"61474:61759:62658:60231:59049", -- [12]
			"61474:61759:62658:60231:58843", -- [13]
			"61474:61759:62658:60231:59048", -- [14]
			"61474:61759:62658:60231:65189", -- [15]
			"61474:61759:62658:60231:59049:60441", -- [16]
			"60416:61473", -- [17]
			"60416:61512", -- [18]
			"61474:61759", -- [19]
			"61474:61759:62658", -- [20]
			"60416:61512:62901", -- [21]
			"60416:61473:62903", -- [22]
			"60416:61512:62901:62898", -- [23]
			"60416:61512:62901:62898:62909", -- [24]
			"61744:61121", -- [25]
			"60416:61473:62903:63500:63501", -- [26]
			"60416:61473:62903:63500:63501:63498", -- [27]
			"60416:61473:62903:63500", -- [28]
			"61744:61121:63497", -- [29]
			"61474:61759:60230:59186:64310", -- [30]
			"60416:61473:62903:63500:63501:65511", -- [31]
			"61744:61121:65865", -- [32]
			"61474:66023:56737:71940", -- [33]
			--["name"] = "One Keg, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "61474:61118:61744:61511:60416",
			["coord"] = 2481101060,
		},
		[59049] = {
			"60231:60230:59186", -- [1]
			"60231:60232:66023", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60232:66023:59727", -- [4]
			"60231:60230:59186:59735:59733", -- [5]
			"60231:60230:59186:59735", -- [6]
			"60231:60230:59186:59736", -- [7]
			"60231:60232:66023:56737", -- [8]
			"60231:60230", -- [9]
			"60231:60232", -- [10]
			"60231:62658:61759:61474", -- [11]
			"60231:62658:61759:61474:61118", -- [12]
			"60231:62658:61759:61474:61744", -- [13]
			"60231:62658:61759:61474:61118:61511", -- [14]
			"60231:62658:61759:61474:61504", -- [15]
			"60231:62658:61759:61474:61744:60416", -- [16]
			"60231:62658:61759:61474:61744:61473", -- [17]
			"60231:62658:61759:61474:61744:60416:61512", -- [18]
			"60231:62658:61759", -- [19]
			"60231:62658", -- [20]
			"60231:62658:61759:61474:61744:61473:62901", -- [21]
			"58843:63501:63500:62903", -- [22]
			"58843:63501:63500:62903:62898", -- [23]
			"58843:63501:63500:62903:62898:62909", -- [24]
			"60231:61121", -- [25]
			"58843:63501", -- [26]
			"58843:63501:63498", -- [27]
			"58843:63501:63500", -- [28]
			"60231:61121:63497", -- [29]
			"60231:60232:66023:56737:64310", -- [30]
			"58843:63501:65511", -- [31]
			"60231:61121:65865", -- [32]
			"60231:60232:66023:56737:71940", -- [33]
			--["name"] = "The Incursion, Krasarang Wilds",
			["m"] = 418,
			["f"] = 0,
			["direct"] = "60231:58843:59048:65189:60441",
			["coord"] = 2909688611,
		},
		[60441] = {
			"59049:60231:60230:59186", -- [1]
			"59049:60231:60232:66023", -- [2]
			"59049:60231:60230:59186:59732", -- [3]
			"59049:60231:60232:66023:59727", -- [4]
			"59049:60231:60230:59186:59735:59733", -- [5]
			"59049:60231:60230:59186:59735", -- [6]
			"59049:60231:60230:59186:59736", -- [7]
			"59049:60231:60232:66023:56737", -- [8]
			"59049:60231:60230", -- [9]
			"59049:60231", -- [10]
			"59049:60231:60232", -- [11]
			"65189:58843", -- [12]
			"59049:60231:62658:61759:61474", -- [13]
			"59049:60231:62658:61759:61474:61118", -- [14]
			"59049:60231:62658:61759:61474:61744", -- [15]
			"59049:60231:62658:61759:61474:61118:61511", -- [16]
			"59049:60231:62658:61759:61474:61504", -- [17]
			"59049:60231:62658:61759:61474:61744:60416", -- [18]
			"59049:60231:62658:61759:61474:61744:61473", -- [19]
			"59049:60231:62658:61759:61474:61744:60416:61512", -- [20]
			"59049:60231:62658:61759", -- [21]
			"59049:60231:62658", -- [22]
			"65189:59048:63501:63500:62903:62901", -- [23]
			"65189:59048:63501:63500:62903", -- [24]
			"65189:59048:63501:63500:62903:62898", -- [25]
			"65189:59048:63501:63500:62903:62898:62909", -- [26]
			"59049:60231:61121", -- [27]
			"65189:59048:63501", -- [28]
			"65189:59048:63501:63498", -- [29]
			"65189:59048:63501:63500", -- [30]
			"65189:59048:63501:63497", -- [31]
			"59049:60231:60232:66023:56737:64310", -- [32]
			"65189:59048:63501:65511", -- [33]
			"59049:60231:61121:65865", -- [34]
			"59049:60231:60232:66023:56737:71940", -- [35]
			["direct"] = "59049:59048:65189",
			["m"] = 418,
			["coord"] = 2252325879,
			["f"] = 0,
		},
	},
	[7] = {

		[84507] = {
			"91940:80932:81103:76840", -- [1]
			"91940:80932:81103:76839", -- [2]
			"91940:90562:81289:76851", -- [3]
			"91940:90562:76850", -- [4]
			"84993:76787", -- [5]
			"90560:90960:85959", -- [6]
			"91940:80932", -- [7]
			"91940:81060:81061", -- [8]
			"91940:81060:81061:81064", -- [9]
			"91940:80932:81067", -- [10]
			"91940:81060:81061:81064:81068", -- [11]
			"91940:81060:81061:81077", -- [12]
			"91940:81060:81061:81354", -- [13]
			"91940:80932:81103:76840:81284", -- [14]
			"91940:90562:81289", -- [15]
			"91940:80932:81103:76839:81285", -- [16]
			"91940:81060:83567", -- [17]
			"91940:81060:81061:81064:83924", -- [18]
			"84993:82844", -- [19]
			"91940:81060:81061:81064:82309", -- [20]
			"91940:81060:81061:81064:83924:81250", -- [21]
			"91940:81060:81061:81354:84515:84498", -- [22]
			"91940:81060:88584:84504", -- [23]
			"91940:81060:81061:81354:84515:82511", -- [24]
			"91940:81060:81061:81064:84509", -- [25]
			"91940:81060:81061:81354:84515", -- [26]
			"81888:81074", -- [27]
			"81888:86492", -- [28]
			"81888:86492:84700", -- [29]
			"91940:80932:81103:83427", -- [30]
			"84993:85829", -- [31]
			"91940:90562:81289:86685", -- [32]
			"81884:84714", -- [33]
			"91940:81060:88584", -- [34]
			"91940:81060:81061:81064:83924:81250:87395", -- [35]
			"91940:81060:81061:81064:82309:88653", -- [36]
			"84993:82844:88668", -- [37]
			"81884:84714:88757", -- [38]
			"90560:90960", -- [39]
			"91940:90562", -- [40]
			"90560:92808", -- [41]
			"91940:92809", -- [42]
			--["name"] = "Bastion Rise, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "81060:81103:81884:81888:84993:90560:91940",
			["coord"] = 1991765149,
		},
		[84700] = {
			"84714:92808:90562:76850:76840", -- [1]
			"84714:92808:90562:76850:76840:76839", -- [2]
			"84714:92808:90562:81289:76851", -- [3]
			"84714:92808:90562:76850", -- [4]
			"85829:76787", -- [5]
			"81884:85959", -- [6]
			"86492:81888:84507:91940:80932", -- [7]
			"81074:81060", -- [8]
			"81074:81060:81061", -- [9]
			"85829:84993:81064", -- [10]
			"81074:81060:81067", -- [11]
			"85829:84993:81064:81068", -- [12]
			"85829:84993:81064:81077", -- [13]
			"81074:81060:81061:81354", -- [14]
			"84714:92808:90562:76850:76840:81284", -- [15]
			"84714:92808:90562:81289", -- [16]
			"84714:92808:90562:76850:76840:76839:81285", -- [17]
			"84714:92808:90562:81103", -- [18]
			"81074:81060:83567", -- [19]
			"85829:84993:82844:83924", -- [20]
			"85829:84993:82844", -- [21]
			"85829:84993:82844:82309", -- [22]
			"85829:84993:82844:81250", -- [23]
			"85829:84993:81064:84509:84498", -- [24]
			"81074:81060:88584:84504", -- [25]
			"81074:81060:81061:81354:84515:82511", -- [26]
			"86492:81888:84507", -- [27]
			"85829:84993:81064:84509", -- [28]
			"81074:81060:81061:81354:84515", -- [29]
			"86492:81888", -- [30]
			"85829:84993", -- [31]
			"84714:92808:90562:76850:83427", -- [32]
			"84714:92808:90562:81289:86685", -- [33]
			"81074:81060:88584", -- [34]
			"85829:76787:87395", -- [35]
			"85829:84993:82844:82309:88653", -- [36]
			"85829:84993:82844:88668", -- [37]
			"84714:88757", -- [38]
			"84714:92808:90960", -- [39]
			"81884:90560", -- [40]
			"86492:81888:84507:91940", -- [41]
			"84714:92808:90562", -- [42]
			"84714:92808", -- [43]
			"84714:92808:92809", -- [44]
			--["name"] = "Iron Docks, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "81884:81074:86492:85829:84714",
			["coord"] = 1850160084,
		},
		[84515] = {
			"84504:76839:76840", -- [1]
			"84504:76839", -- [2]
			"84504:76839:76851", -- [3]
			"84504:76850", -- [4]
			"81354:81064:76787", -- [5]
			"88584:85959", -- [6]
			"81354:80932", -- [7]
			"81354:81061:81060", -- [8]
			"81354:81061", -- [9]
			"81354:81064", -- [10]
			"81354:81067", -- [11]
			"84509:81068", -- [12]
			"84509:81077", -- [13]
			"84504:76839:81284", -- [14]
			"84504:76839:76851:81289", -- [15]
			"84504:81285", -- [16]
			"84498:83567", -- [17]
			"81354:81064:83924", -- [18]
			"81354:81064:83924:82844", -- [19]
			"81354:81064:82309", -- [20]
			"81354:81064:83924:81250", -- [21]
			"81354:80932:91940:84507", -- [22]
			"81354:80932:90560:81884", -- [23]
			"81354:81061:81060:81074", -- [24]
			"81354:81064:84993:86492", -- [25]
			"81354:80932:91940:84507:81888", -- [26]
			"81354:80932:90560:81884:84700", -- [27]
			"81354:81064:84993", -- [28]
			"84504:81285:83427", -- [29]
			"81354:81064:84993:85829", -- [30]
			"84504:76839:81284:86685", -- [31]
			"81354:80932:90560:81884:84714", -- [32]
			"81354:81064:83924:81250:87395", -- [33]
			"84498:83567:88653", -- [34]
			"81354:81064:83924:81250:88668", -- [35]
			"81354:80932:90560:81884:84714:88757", -- [36]
			"81103:90562:90960", -- [37]
			"81354:80932:90560", -- [38]
			"81354:80932:91940", -- [39]
			"81103:90562", -- [40]
			"81354:80932:92809:92808", -- [41]
			"81354:80932:92809", -- [42]
			--["name"] = "Crow's Crook, Spires of Arak",
			["m"] = 542,
			["coord"] = 2222935940,
			["direct"] = "81354:81103:84498:84504:82511:84509:88584",
			["f"] = 0,
		},
		[80932] = {
			"81103:76840", -- [1]
			"81103:76839", -- [2]
			"81103:76840:76851", -- [3]
			"81067:76850", -- [4]
			"91940:84507:84993:76787", -- [5]
			"90562:90960:85959", -- [6]
			"81060:81061", -- [7]
			"81060:81061:81064", -- [8]
			"81354:81077:81068", -- [9]
			"81354:81077", -- [10]
			"81103:76840:81284", -- [11]
			"81103:81289", -- [12]
			"81103:76839:81285", -- [13]
			"81354:84515:84498:83567", -- [14]
			"81060:81061:81064:83924", -- [15]
			"81060:81061:81064:83924:82844", -- [16]
			"81060:81061:81064:82309", -- [17]
			"81060:81061:81064:83924:81250", -- [18]
			"81354:84515:84498", -- [19]
			"81354:84515:84504", -- [20]
			"81354:84515:82511", -- [21]
			"91940:84507", -- [22]
			"81354:81077:84509", -- [23]
			"81354:84515", -- [24]
			"90560:81884", -- [25]
			"91940:84507:81888:81074", -- [26]
			"91940:84507:81888:86492", -- [27]
			"91940:84507:81888", -- [28]
			"90560:81884:84700", -- [29]
			"91940:84507:84993", -- [30]
			"81103:83427", -- [31]
			"90560:81884:85829", -- [32]
			"81103:76840:76851:86685", -- [33]
			"90560:81884:84714", -- [34]
			"81103:88584", -- [35]
			"81060:81061:81064:83924:81250:87395", -- [36]
			"81060:81061:81064:82309:88653", -- [37]
			"81060:81061:81064:83924:81250:88668", -- [38]
			"90560:81884:84714:88757", -- [39]
			"90562:90960", -- [40]
			"92809:92808", -- [41]
			--["name"] = "Zangarra, Talador",
			["m"] = 535,
			["coord"] = 3452649745,
			["direct"] = "81060:81067:81354:81103:90560:91940:90562:92809",
			["f"] = 0,
		},
		[82511] = {
			"84504:76839:76840", -- [1]
			"84504:76839", -- [2]
			"84504:76839:76851", -- [3]
			"84504:76850", -- [4]
			"84504:88584:81064:76787", -- [5]
			"84504:76839:76851:81289:85959", -- [6]
			"84504:81067:80932", -- [7]
			"84504:81067:81060", -- [8]
			"84504:88584:81354:81061", -- [9]
			"84504:88584:81064", -- [10]
			"84504:81067", -- [11]
			"83567:84509:81068", -- [12]
			"83567:84509:81077", -- [13]
			"84504:88584:81354", -- [14]
			"84504:76839:81284", -- [15]
			"84504:76839:76851:81289", -- [16]
			"84504:81285", -- [17]
			"84504:88584:81103", -- [18]
			"84504:88584:81064:83924", -- [19]
			"84504:88584:81064:83924:82844", -- [20]
			"83567:82309", -- [21]
			"83567:82309:81250", -- [22]
			"84504:81067:80932:91940:84507", -- [23]
			"83567:84509", -- [24]
			"84504:81067:80932:90560:81884", -- [25]
			"84504:81067:81060:81074", -- [26]
			"84504:81067:81060:81074:86492", -- [27]
			"84504:81067:81060:81888", -- [28]
			"84504:81067:80932:90560:81884:84700", -- [29]
			"84504:81067:81060:84993", -- [30]
			"84504:81285:83427", -- [31]
			"84504:81067:81060:84993:85829", -- [32]
			"84504:76839:81284:86685", -- [33]
			"84504:81067:80932:90560:81884:84714", -- [34]
			"83567:82309:87395", -- [35]
			"83567:88653", -- [36]
			"83567:82309:81250:88668", -- [37]
			"84504:81067:80932:90560:81884:84714:88757", -- [38]
			"84504:76850:90562:90960", -- [39]
			"84504:81067:80932:90560", -- [40]
			"84504:81067:80932:91940", -- [41]
			"84504:76850:90562", -- [42]
			"84504:81067:80932:92809:92808", -- [43]
			"84504:81067:80932:92809", -- [44]
			--["name"] = "Pinchwhistle Gearworks, Spires of Arak",
			["m"] = 542,
			["coord"] = 2613754812,
			["direct"] = "83567:84498:84504:84515:88584",
			["f"] = 0,
		},
		[86492] = {
			"81888:84507:91940:80932:81103:76840", -- [1]
			"81888:84507:91940:80932:81103:76839", -- [2]
			"81888:84507:91940:90562:81289:76851", -- [3]
			"81888:84507:91940:90562:76850", -- [4]
			"85829:76787", -- [5]
			"81074:81884:85959", -- [6]
			"81888:84507:91940:80932", -- [7]
			"81888:81060", -- [8]
			"81888:81060:81061", -- [9]
			"84993:81064", -- [10]
			"81888:84507:91940:80932:81067", -- [11]
			"84993:81064:81068", -- [12]
			"84993:81064:81077", -- [13]
			"81888:81060:81061:81354", -- [14]
			"81888:84507:91940:80932:81103:76840:81284", -- [15]
			"81888:84507:91940:90562:81289", -- [16]
			"81888:81060:88584:81285", -- [17]
			"81888:84507:91940:80932:81103", -- [18]
			"81888:81060:83567", -- [19]
			"84993:82844:83924", -- [20]
			"84993:82844", -- [21]
			"84993:82844:82309", -- [22]
			"84993:82844:81250", -- [23]
			"81888:81060:81061:81354:84515:84498", -- [24]
			"81888:81060:88584:84504", -- [25]
			"81888:81060:81061:81354:84515:82511", -- [26]
			"81888:84507", -- [27]
			"84993:81064:84509", -- [28]
			"81888:81060:81061:81354:84515", -- [29]
			"81074:81884", -- [30]
			"81888:84507:91940:80932:81103:83427", -- [31]
			"81888:84507:91940:90562:81289:86685", -- [32]
			"81888:81060:88584", -- [33]
			"84993:82844:88668:87395", -- [34]
			"84993:82844:82309:88653", -- [35]
			"84993:82844:88668", -- [36]
			"84714:88757", -- [37]
			"81074:81884:90960", -- [38]
			"81888:84507:90560", -- [39]
			"81888:84507:91940", -- [40]
			"81888:84507:91940:90562", -- [41]
			"84714:92808", -- [42]
			"81888:84507:91940:92809", -- [43]
			--["name"] = "Breaker's Crown, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "81074:81888:84700:84993:85829:84714",
			["coord"] = 1970048188,
		},
		[86685] = {
			"76851:76840", -- [1]
			"76851:76839", -- [2]
			"81289:76850", -- [3]
			"81289:90562:91940:84507:84993:76787", -- [4]
			"81289:85959", -- [5]
			"76851:76840:81103:81067:80932", -- [6]
			"76851:76840:81103:81067:81060", -- [7]
			"81289:76850:81354:81061", -- [8]
			"81289:76850:81354:81064", -- [9]
			"76851:76840:81103:81067", -- [10]
			"81289:76850:81077:81068", -- [11]
			"81289:76850:81077", -- [12]
			"81289:76850:81354", -- [13]
			"81284:81285", -- [14]
			"76851:76840:81103", -- [15]
			"76851:76839:84504:84498:83567", -- [16]
			"81289:76850:81354:81064:83924", -- [17]
			"81289:76850:81354:81064:83924:82844", -- [18]
			"76851:76840:81103:82309", -- [19]
			"81289:76850:81354:81064:83924:81250", -- [20]
			"76851:76839:84504:84498", -- [21]
			"76851:76839:84504", -- [22]
			"76851:76839:84504:82511", -- [23]
			"81289:90562:91940:84507", -- [24]
			"76851:76839:84504:84498:84509", -- [25]
			"76851:76839:84504:84515", -- [26]
			"81289:90562:90960:81884", -- [27]
			"76851:76840:81103:81074", -- [28]
			"81289:90562:91940:84507:81888:86492", -- [29]
			"81289:90562:91940:84507:81888", -- [30]
			"81289:90562:92808:84714:84700", -- [31]
			"81289:90562:91940:84507:84993", -- [32]
			"81284:83427", -- [33]
			"81289:90562:92808:84714:85829", -- [34]
			"81289:90562:92808:84714", -- [35]
			"81289:76850:88584", -- [36]
			"81289:76850:81354:81064:83924:81250:87395", -- [37]
			"76851:76840:81103:82309:88653", -- [38]
			"81289:76850:81354:81064:83924:81250:88668", -- [39]
			"81289:90562:92808:84714:88757", -- [40]
			"81289:90562:90960", -- [41]
			"81289:90562:92809:90560", -- [42]
			"81289:90562:91940", -- [43]
			"81289:90562", -- [44]
			"81289:90562:92808", -- [45]
			"81289:90562:92809", -- [46]
			--["name"] = "Tranquil Court, Shadowmoon Valley",
			["m"] = 539,
			["f"] = 0,
			["direct"] = "76851:81284:81289",
			["coord"] = 3024716070,
		},
		[92808] = {
			"90562:76850:76840", -- [1]
			"90562:76850:76840:76839", -- [2]
			"90562:81289:76851", -- [3]
			"90562:76850", -- [4]
			"90560:84507:84993:76787", -- [5]
			"90960:85959", -- [6]
			"92809:80932", -- [7]
			"90560:91940:81060", -- [8]
			"90560:91940:81060:81061", -- [9]
			"90560:91940:81060:81061:81064", -- [10]
			"92809:80932:81067", -- [11]
			"90560:91940:81060:81061:81064:81068", -- [12]
			"92809:80932:81354:81077", -- [13]
			"92809:80932:81354", -- [14]
			"90562:76850:76840:81284", -- [15]
			"90562:81289", -- [16]
			"90562:76850:76840:76839:81285", -- [17]
			"90562:81103", -- [18]
			"90562:81103:84515:84498:83567", -- [19]
			"90560:91940:81060:81061:81064:83924", -- [20]
			"90560:84507:84993:82844", -- [21]
			"90560:91940:81060:81061:81064:82309", -- [22]
			"90560:91940:81060:81061:81064:83924:81250", -- [23]
			"90562:81103:84515:84498", -- [24]
			"90562:81103:88584:84504", -- [25]
			"90562:81103:88584:82511", -- [26]
			"90560:84507", -- [27]
			"92809:80932:81354:81077:84509", -- [28]
			"90562:81103:84515", -- [29]
			"90560:81884", -- [30]
			"90560:84507:81888:81074", -- [31]
			"90560:84507:81888:86492", -- [32]
			"90560:84507:81888", -- [33]
			"84714:84700", -- [34]
			"90560:84507:84993", -- [35]
			"90562:76850:83427", -- [36]
			"84714:85829", -- [37]
			"90562:81289:86685", -- [38]
			"90562:81103:88584", -- [39]
			"90560:91940:81060:81061:81064:83924:81250:87395", -- [40]
			"90560:91940:81060:81061:81064:82309:88653", -- [41]
			"90560:91940:81060:81061:81064:83924:81250:88668", -- [42]
			"84714:88757", -- [43]
			"90560:91940", -- [44]
			--["name"] = "Malo's Lookout, Tanaan Jungle",
			["m"] = 534,
			["f"] = 0,
			["direct"] = "84714:90960:90560:90562:92809",
			["coord"] = 1867738098,
		},
		[81354] = {
			"76850:76840", -- [1]
			"76850:76840:76839", -- [2]
			"76850:76840:76851", -- [3]
			"81064:76787", -- [4]
			"80932:90562:90960:85959", -- [5]
			"81061:81060", -- [6]
			"81077:81068", -- [7]
			"76850:76840:81284", -- [8]
			"76850:81289", -- [9]
			"88584:81285", -- [10]
			"81067:81103", -- [11]
			"84515:84498:83567", -- [12]
			"81064:83924", -- [13]
			"81064:83924:82844", -- [14]
			"81064:82309", -- [15]
			"81064:83924:81250", -- [16]
			"84515:84498", -- [17]
			"84515:84504", -- [18]
			"84515:82511", -- [19]
			"80932:91940:84507", -- [20]
			"81077:84509", -- [21]
			"80932:90560:81884", -- [22]
			"81061:81060:81074", -- [23]
			"81064:84993:86492", -- [24]
			"80932:91940:84507:81888", -- [25]
			"80932:90560:81884:84700", -- [26]
			"81064:84993", -- [27]
			"88584:81285:83427", -- [28]
			"81064:84993:85829", -- [29]
			"76850:81289:86685", -- [30]
			"80932:90560:81884:84714", -- [31]
			"81064:83924:81250:87395", -- [32]
			"81064:82309:88653", -- [33]
			"81064:83924:81250:88668", -- [34]
			"80932:90560:81884:84714:88757", -- [35]
			"80932:90562:90960", -- [36]
			"80932:90560", -- [37]
			"80932:91940", -- [38]
			"80932:90562", -- [39]
			"80932:92809:92808", -- [40]
			"80932:92809", -- [41]
			--["name"] = "Terokkar Refuge, Talador",
			["m"] = 535,
			["coord"] = 3022164529,
			["direct"] = "76850:80932:81061:81064:81067:81077:84515:88584",
			["f"] = 0,
		},
		[83567] = {
			"84498:84504:76839:76840", -- [1]
			"84498:84504:76839", -- [2]
			"84498:84504:76839:76851", -- [3]
			"88584:76850", -- [4]
			"84509:81077:81064:76787", -- [5]
			"88584:85959", -- [6]
			"88584:81354:80932", -- [7]
			"84509:81077:81061", -- [8]
			"84509:81077:81067", -- [9]
			"84509:81068", -- [10]
			"84509:81077", -- [11]
			"88584:81354", -- [12]
			"81285:81284", -- [13]
			"84498:84504:76839:76851:81289", -- [14]
			"84509:81068:83924", -- [15]
			"84509:81068:83924:82844", -- [16]
			"82309:81250", -- [17]
			"84498:84504", -- [18]
			"81060:84507", -- [19]
			"84509:84515", -- [20]
			"81060:84507:81884", -- [21]
			"81060:81074", -- [22]
			"84509:81077:81064:84993:86492", -- [23]
			"81060:81888", -- [24]
			"84509:81077:81064:84993:85829:84700", -- [25]
			"84509:81077:81064:84993", -- [26]
			"81285:83427", -- [27]
			"84509:81077:81064:84993:85829", -- [28]
			"81285:81284:86685", -- [29]
			"81060:81074:84714", -- [30]
			"82309:87395", -- [31]
			"82309:81250:88668", -- [32]
			"81060:81074:84714:88757", -- [33]
			"88584:81103:90562:90960", -- [34]
			"88584:81354:80932:90560", -- [35]
			"81060:91940", -- [36]
			"88584:81103:90562", -- [37]
			"88584:81354:80932:92809:92808", -- [38]
			"88584:81354:80932:92809", -- [39]
			--["name"] = "Southport, Spires of Arak",
			["m"] = 542,
			["coord"] = 1676910161,
			["direct"] = "81060:81064:81285:81103:82309:84498:82511:84509:88584:88653",
			["f"] = 0,
		},
		[81067] = {
			"76850:76840", -- [1]
			"81103:76839", -- [2]
			"76850:76840:76851", -- [3]
			"81354:81064:76787", -- [4]
			"81103:85959", -- [5]
			"81354:81061", -- [6]
			"81354:81064", -- [7]
			"81354:81077:81068", -- [8]
			"76850:76840:81284", -- [9]
			"76850:81289", -- [10]
			"81103:76839:81285", -- [11]
			"81354:84515:84498:83567", -- [12]
			"81354:81064:83924", -- [13]
			"81354:81064:83924:82844", -- [14]
			"81354:81064:82309", -- [15]
			"81354:81064:83924:81250", -- [16]
			"81354:84515:84498", -- [17]
			"81354:84515:82511", -- [18]
			"80932:91940:84507", -- [19]
			"81354:81077:84509", -- [20]
			"81354:84515", -- [21]
			"80932:90560:81884", -- [22]
			"81060:81074", -- [23]
			"81060:81074:86492", -- [24]
			"81060:81888", -- [25]
			"80932:90560:81884:84700", -- [26]
			"81060:84993", -- [27]
			"81103:83427", -- [28]
			"81060:84993:85829", -- [29]
			"76850:81289:86685", -- [30]
			"80932:90560:81884:84714", -- [31]
			"81354:88584", -- [32]
			"81354:81064:83924:81250:87395", -- [33]
			"81354:81064:82309:88653", -- [34]
			"81354:81064:83924:81250:88668", -- [35]
			"80932:90560:81884:84714:88757", -- [36]
			"80932:90562:90960", -- [37]
			"80932:90560", -- [38]
			"80932:91940", -- [39]
			"80932:90562", -- [40]
			"80932:92809:92808", -- [41]
			"80932:92809", -- [42]
			--["name"] = "Anchorite's Sojourn, Talador",
			["m"] = 535,
			["coord"] = 3438973281,
			["direct"] = "76850:80932:81060:81077:81354:81103:84504",
			["f"] = 0,
		},
		[76850] = {
			"76840:76839", -- [1]
			"76840:76851", -- [2]
			"81354:81064:76787", -- [3]
			"81289:85959", -- [4]
			"81067:80932", -- [5]
			"81067:81060", -- [6]
			"81354:81061", -- [7]
			"81354:81064", -- [8]
			"81077:81068", -- [9]
			"76840:81284", -- [10]
			"88584:83567", -- [11]
			"81354:81064:83924", -- [12]
			"81354:81064:83924:82844", -- [13]
			"81354:81064:82309", -- [14]
			"81354:81064:83924:81250", -- [15]
			"88584:84515:84498", -- [16]
			"84504:82511", -- [17]
			"81103:84507", -- [18]
			"88584:84515:84509", -- [19]
			"88584:84515", -- [20]
			"90562:90960:81884", -- [21]
			"81067:81060:81074", -- [22]
			"81103:84507:81888:86492", -- [23]
			"81103:84507:81888", -- [24]
			"90562:92808:84714:84700", -- [25]
			"81103:84507:84993", -- [26]
			"90562:92808:84714:85829", -- [27]
			"81289:86685", -- [28]
			"90562:92808:84714", -- [29]
			"81354:81064:83924:81250:87395", -- [30]
			"81354:81064:82309:88653", -- [31]
			"81354:81064:83924:81250:88668", -- [32]
			"90562:92808:84714:88757", -- [33]
			"90562:90960", -- [34]
			"90562:92809:90560", -- [35]
			"90562:91940", -- [36]
			"90562:92808", -- [37]
			"90562:92809", -- [38]
			--["name"] = "Exile's Rise, Shadowmoon Valley",
			["m"] = 539,
			["f"] = 0,
			["direct"] = "76840:81067:81077:81354:81289:81285:81103:84504:83427:88584:90562",
			["coord"] = 1956528394,
		},
		[76787] = {
			"84993:81060:80932:81103:76840", -- [1]
			"84993:81060:80932:81103:76839", -- [2]
			"84993:84507:91940:90562:81289:76851", -- [3]
			"84993:84507:91940:90562:76850", -- [4]
			"85829:81884:85959", -- [5]
			"84993:81060:80932", -- [6]
			"84993:81060", -- [7]
			"84993:81060:81061", -- [8]
			"84993:81060:81067", -- [9]
			"81064:81068", -- [10]
			"81064:81077", -- [11]
			"81064:81354", -- [12]
			"84993:81060:80932:81103:76840:81284", -- [13]
			"84993:84507:91940:90562:81289", -- [14]
			"81064:88584:81285", -- [15]
			"84993:81060:80932:81103", -- [16]
			"81064:83567", -- [17]
			"82844:83924", -- [18]
			"82844:82309", -- [19]
			"82844:81250", -- [20]
			"81064:84509:84498", -- [21]
			"81064:84509:84515:84504", -- [22]
			"81064:84509:84498:82511", -- [23]
			"84993:84507", -- [24]
			"81064:84509", -- [25]
			"81064:84509:84515", -- [26]
			"85829:81884", -- [27]
			"85829:81074", -- [28]
			"85829:86492", -- [29]
			"84993:81888", -- [30]
			"85829:84700", -- [31]
			"81064:88584:81285:83427", -- [32]
			"84993:84507:91940:90562:81289:86685", -- [33]
			"85829:84714", -- [34]
			"81064:88584", -- [35]
			"82844:82309:88653", --