local DGV = DugisGuideViewer
if not DGV then return end
local L = DugisLocals

local LuaUtils = LuaUtils

local Talents = DGV:RegisterModule("Talents")

function Talents:Initialize()
	Talents.className2SpecializationRules = {
		DEATHKNIGHT = {
			{spec = 1, talentsIds = {2,2,2,1,3,2,2}}, --Blood
			{spec = 2, talentsIds = {3,2,2,3,3,2,2}}, --Frost
			{spec = 3, talentsIds = {3,2,2,3,2,3,2}}, --Unholy
		},
		DEMONHUNTER = {
			{spec = 1, talentsIds = {3,2,1,2,2,2,2}}, --Havoc
			{spec = 2, talentsIds = {1,2,1,3,1,2,1}}, --Vengeance
		},
		DRUID = {
			{spec = 1, talentsIds = {3,1,3,3,2,2,2}}, --Balance
			{spec = 2, talentsIds = {2,3,1,1,2,2,2}}, --Feral
			{spec = 3, talentsIds = {1,1,1,1,2,3,1}}, --Guardian
			{spec = 4, talentsIds = {1,1,2,1,2,3,2}}, --Restoration
		},
		HUNTER = {
			{spec = 1, talentsIds = {1,1,3,3,2,2,1}}, --Beast Mastery
			{spec = 2, talentsIds = {3,3,1,2,1,2,2}}, --Marksmanship
			{spec = 3, talentsIds = {1,1,2,1,1,1,1}}, --Survival
		},
		MAGE = {
			{spec = 1, talentsIds = {2,1,2,1,2,1,3}}, --Arcane
			{spec = 2, talentsIds = {1,2,1,1,2,2,3}}, --Fire
			{spec = 3, talentsIds = {3,2,1,3,2,2,3}}, --Frost
		},
		MONK = {
			{spec = 1, talentsIds = {3,3,3,2,2,2,3}}, --Brewmaster
			{spec = 2, talentsIds = {1,3,1,3,1,1,1}}, --Mistweaver
			{spec = 3, talentsIds = {1,1,2,2,1,3,2}}, --Windwalker
		},
		PALADIN = {
			{spec = 1, talentsIds = {1,2,1,1,3,2,3}}, --Holy
			{spec = 2, talentsIds = {3,2,1,2,3,1,2}}, --Protection
			{spec = 3, talentsIds = {2,3,1,3,2,1,3}}, --Retribution
		},
		PRIEST = {
			{spec = 1, talentsIds = {2,3,3,1,3,1,3}}, --Discipline
			{spec = 2, talentsIds = {2,3,2,2,2,2,2}}, --Holy
			{spec = 3, talentsIds = {1,2,2,1,3,2,2}}, --Shadow
		},
		ROGUE = {
			{spec = 1, talentsIds = {2,2,1,2,1,2,1}}, --Assassination
			{spec = 2, talentsIds = {2,3,1,2,3,2,3}}, --Outlaw
			{spec = 3, talentsIds = {2,3,3,2,2,3,1}}, --Subtlety
		},
		SHAMAN = {
			{spec = 1, talentsIds = {2,1,1,1,1,1,1}}, --Elemental
			{spec = 2, talentsIds = {3,1,1,1,2,3,3}}, --Enhancement
			{spec = 3, talentsIds = {2,3,1,1,1,1,3}}, --Restoration
		},
		WARLOCK = {
			{spec = 1, talentsIds = {3,2,1,1,2,2,2}}, --Affliction
			{spec = 2, talentsIds = {2,3,1,2,2,1,1}}, --Demonology
			{spec = 3, talentsIds = {1,3,2,3,1,2,2}}, --Destruction
		},
		WARRIOR = {
			{spec = 1, talentsIds = {2,1,2,1,3,2,2}}, --Arms
			{spec = 2, talentsIds = {1,1,2,2,1,2,1}}, --Fury
			{spec = 3, talentsIds = {1,2,2,3,2,1,1}}, --Protection
		},
	}
	
	function Talents:InitializeUI()
		if not DGV:UserSetting(DGV_TALENT_ADVISOR) then
            return
        end

		if Talents.initializedUI then return end

		Talents.initializedUI = true

		--Preparing the UI
		Talents.iconsBuffer = {}
		for i=1, MAX_TALENT_TIERS do
			local parent=_G["PlayerTalentFrameTalentsTalentRow"..i.."Talent1"]
			local icon = CreateFrame("Button", nil, parent)
			icon:SetNormalTexture("Interface\\AddOns\\DugisGuideViewerZ\\Artwork\\UpgradeArrow")
			icon:SetFrameLevel(70)
			icon:SetFrameStrata("HIGH")
			icon:SetSize(18, 18)
			icon:Hide()
			icon:SetScript("OnEnter", function() 
				GameTooltip:SetOwner(icon, "ANCHOR_TOP")
				GameTooltip:SetText("Dugi Talent Advisor")
				GameTooltip:Show()
			end)
			icon:SetScript("OnLeave", function() 
				GameTooltip:Hide()
			end)
			Talents.iconsBuffer[i] = icon
		end

		Talents.SetTalents = function() 
			for _,icon in pairs(Talents.iconsBuffer or {}) do icon:Hide() end

			if not DGV:UserSetting(DGV_TALENT_ADVISOR) then
				return
			end

			local _, playerClass = UnitClass("player")

			local playerSpec = GetSpecialization()
			if not playerSpec then return end
		
			local suggestedSpecializationInfo
			if Talents.className2SpecializationRules[playerClass] then
				for specialization, info in pairs(Talents.className2SpecializationRules[playerClass]) do
					if info.spec==playerSpec then
						suggestedSpecializationInfo = info
					end
				end
			end

			local talentsIds = suggestedSpecializationInfo.talentsIds
		
			for rowIndex, talentId in pairs(talentsIds) do
				local parent = _G["PlayerTalentFrameTalentsTalentRow"..rowIndex.."Talent"..talentId]
				local icon = Talents.iconsBuffer[rowIndex]
				icon:ClearAllPoints()
				icon:SetParent(parent)
				icon:SetPoint("TOPRIGHT", -5, -5)
				icon:Show()
			end
		end
	end

	function Talents:Load()
		hooksecurefunc("TalentFrame_LoadUI", function()
			hooksecurefunc("PlayerTalentFrame_ShowTalentTab", function()
				Talents.InitializeUI()
				if Talents.SetTalents then
					Talents.SetTalents()
				end
			end)
		end)
	end

	function Talents:Unload()
	end
end
