-- 1 - Auctioneer
-- 2 - Banker
-- 3 - Battlemasters
-- 4 - Class Trainer
-- 6 - Vendor (food)
-- 7 - Innkeeper:Inn name
-- 8 - Mailbox
-- 9 - Vendor (weapons)
-- 10 - Profession trainer npc:spell
-- 11 - Reagents
-- 12 - Repair

DugisWorldMapTrackingPoints = {
	["Horde"] = {
		[1447] = { --Azshara
			"6:937723227:3621::M", -- [1]
			"12:951616282:10361::M", -- [2]
			"16:14.4,78.6:6491::F",
			"16:54.2,71.4:6491::F",
			"16:70.4,15.6:6491::F",
		},
		[1417] = { --Arathi Highlands
			"6:3184350897:4954::M", -- [1]
			"8:3171308767:33768::M", -- [2]
			"7:3171308362:9501:Hammerfall:M", -- [3]
			"6:3181204234:2820::M", -- [4]
			"10:3152502392:12920:3273:M", -- [5]
			"12:3155184656:15126::M", -- [6]
			"16:48.8,55.4:6491::F",
			--"3:3158460809:19905::F", -- [7]
		},
		[1449] = { --Un'Goro Crater
			"12:1891832457:3000::M", -- [1]
			"6:1858868181:12959::M", -- [2]
			"16:80.0,49.8:6491::F",
		},
		[1450] = { --Moonglade
			"10:45.6,46.8:12025:2368:M", -- [2]		
			"6:2094097598:12019::M", -- [1]
			"12:2230080578:4184::F", -- [2]
			"12:2288086364:12029::F", -- [3]
			"6:1940871484:12021::F", -- [4]
			"6:1912035020:12026::F", -- [5]
			"16:62.0,69.6:6491::F",
		},
		[1451] = { --Silithus
			"8:2223792395:49379::M", -- [1]
			"7:2228905015:15174:Cenarion Hold:F", -- [2]
			"6:2228905015:15174::F", -- [3]
			"12:2197775187:15176::M", -- [4]
			"11:2094030521:15175::M", -- [5]
			"16:47.0,38.6:6491::F",
		},
		[1421] = { --Silverpine Forest
			"12:1924621418:3554::F", -- [1]
			"12:1917674532:3552::F", -- [2]
			"6:1888708104:2140::M", -- [3]
			"6:1889560061:5886::F", -- [4]
			"8:1865247323:12917::M", -- [5]
			"7:1854433727:6739:The Sepulcher:M", -- [6]
			"16:44.4,41.6:6491::F",
		},
		[1454] = { --Orgrimmar
			"10:82.2,23.0:3355:3100:M", -- [2]	
			"10:80.6,23.4:10266:3100:M", -- [2]	
			"10:75.8,25.2:3412:4036:M", -- [2]	
			"10:76.0,25.0:11017:4036:M", -- [2
			"10:75.8,24.4:2857:4036:M", -- [2			]	
			"10:73.0,26.4:3357:2575:M", -- [2]	
			"10:69.8,29.6:3332:7731:M", -- [2]			
			"10:55.6,39.6:3404:2368:M", -- [2]
			"10:53.8,38.4:3345:7411:M", -- [2]	
			"10:53.6,38.2:11066:7411:M", -- [2]		
			"4:1552932942:6014:Priest:M", -- [1]
			"10:1463408624:3373:3273:M", -- [2]
			"4:1530519548:6018:Priest:M", -- [3]
			"4:1675484282:7311:Mage:M", -- [4]
			"4:1649532109:5885:Mage:F", -- [5]
			"4:1644616427:5882:Mage:F", -- [6]
			"4:1658641289:5883:Mage:F", -- [7]
			"12:1281146145:3349::M", -- [8]
			"6:2069548511:3313::M", -- [9]
			"12:2041032535:3314::M", -- [10]
			"8:2180559890:42149::M", -- [11]
			"2:2109256357:3320::M", -- [12]
			"2:2127278476:3309::M", -- [13]
			"2:2148511614:3318::M", -- [14]
			"6:2349444522:5611::M", -- [15]
			"1:2384766468:8724::M", -- [16]
			"1:2392432940:8673::M", -- [17]
			"1:2365234953:9856::M", -- [18]
			"12:2246352869:3322::F", -- [19]
			"11:1953862040:3323::M", -- [20]
			"6:2460977270:3368::M", -- [21]
			"6:2460977270:3400::M", -- [22]
			"10:2470873419:3399:2550:F", -- [23]
			"12:2696052951:3315::M", -- [24]
			"10:2729410566:3363:3908:M", -- [25]
			"12:2702733949:3316::M", -- [26]
			"10:2723378401:7088:8613:M", -- [27]
			"10:2699784473:3365:2108:M", -- [28]
			"8:2671339491:41975::M", -- [29]
			"10:2437960819:3347:2259:M", -- [30]
			"12:1896905651:5816::F", -- [31]
			"12:1901231026:3330::M", -- [32]
			"11:1973843381:3335::M", -- [33]
			"4:2062382438:3324:Warlock:M", -- [34]
			"4:2068149427:3326:Warlock:M", -- [35]
			"6:2104068905:3329::M", -- [36]
			"4:1848347036:3401:Rogue:M", -- [37]
			"4:1842119397:3327:Rogue:M", -- [38]
			"12:1955303214:3331::M", -- [39]
			"6:1612023339:3342::F", -- [40]
			"4:1665162261:13417:Shaman:M", -- [41]
			"4:1669422348:3344:Shaman:F", -- [42]
			"4:1382767419:23128:Paladin:M", -- [43]
			"12:3140054029:3359::F", -- [44]
			--"3:3388362774:14942::F", -- [45]
			--"3:3405663740:3890::M", -- [46]
			"4:3417657347:3353:Warrior:M", -- [47]
			"4:3449377470:3354:Warrior:M", -- [48]
			--"3:3460714042:19912::M", -- [49]
			"4:3455470737:3408:Warrior:M", -- [50]
			--"3:3422571273:15006::F", -- [51]
			"10:3139781378:3357:2575:M", -- [52]
			"10:2998356887:3332:7731:M", -- [53]
			"6:1975150706:3350::M", -- [54]
			"11:1964599369:3351::M", -- [55]
			"4:2918526412:3407:Hunter:F", -- [59]
			"4:2887529388:3406:Hunter:M", -- [60]
			"4:2837458751:3352:Hunter:M", -- [61]			
		},
		[1424] = { --Hillsbrad Foothills
			"6:2705863145:2397::M", -- [1]
			"10:2733978965:2399:3908:M", -- [2]
			"10:61.6,19.6:2390:2368:M", -- [2]
			"6:2655336107:3544::M", -- [3]
			"10:2643931449:2391:2259:M", -- [4]
			"8:2677682793:12916::M", -- [5]
			"7:2695114926:2388:Tarren Mill:M", -- [6]
			"16:63.6,19.6:6491::F",
			"12:60.8,19.8:3537::M", -- [32]
			"12:80.0,39.0:3536::M", -- [32]
			"12:60.4,26.0:3539::M", -- [32]
		},
		[1456] = { --Thunder Bluff
			"4:967779899:3047:Mage:M", -- [1]
			"4:1049311561:3045:Priest:M", -- [2]
			"4:1092039850:3046:Priest:M", -- [3]
			"4:1092039850:3049:Mage:M", -- [4]
			"4:1086269389:3044:Priest:M", -- [5]
			"4:1110123734:3048:Mage:F", -- [6]
			"10:1264924223:2798:3273:M", -- [7]
			"4:963588348:3032:Shaman:M", -- [8]
			"4:1010315473:3031:Shaman:M", -- [9]
			"4:976959462:3030:Shaman:F", -- [10]
			"10:1471583011:3001:2575:M", -- [11]
			"6:1663280475:8362::M", -- [12]
			"11:1730781096:8361::F", -- [13]
			"12:1779736293:2997::F", -- [14]
			"8:1937217505:12913::M", -- [15]
			"2:2034669002:2996::M", -- [16]
			"2:2028967940:8357::M", -- [17]
			"2:2021889099:8356::F", -- [18]
			"7:1962910951:6746:Thunder Bluff:F", -- [19]
			"6:1962910951:6746::F", -- [20]
			"6:1775929873:3003::F", -- [21]
			"1:1731232782:8674::M", -- [22]
			"1:1665302852:8722::M", -- [23]
			"12:2006414545:3015::F", -- [24]
			"6:2035641629:3017::F", -- [25]
			"12:1841066494:3095::F", -- [26]
			"12:1830973110:3093::M", -- [27]
			"12:1869902053:3092::F", -- [28]
			"10:1901229018:3004:3908:F", -- [29]
			"10:1928159657:3011:7411:M", -- [30]
			"10:2005292463:3009:2259:F", -- [31]
			"10:39.6,55.2:2998:3100:M", -- [29]
			"10:39.2,56.2:10278:3100:M", -- [29]
			"10:44.6,43.0:7089:8613:M", -- [29]
			"10:44.0,44.4:11051:3908:M", -- [29]
			"10:42.2,43.2:3008:2108:M", -- [29]
			"10:42.4,43.0:11084:2108:M", -- [29]
			"10:45.0,38.4:11071:7411:M", -- [29]
			"10:49.8,39.8:3013:2368:M", -- [29]
			"10:56.0,46.8:3028:7731:M", -- [29]
			"10:47.0,34.6:11047:2259:M", -- [29]
			"4:3309848006:3034:Druid:F", -- [32]
			"4:3300869832:3033:Druid:M", -- [33]
			"4:3309718518:3036:Druid:F", -- [34]
			--"3:2545075796:20388::M", -- [35]
			--"3:2445460461:7427::M", -- [36]
			--"3:2440086766:10360::M", -- [37]
			--"3:2520827013:12198::M", -- [38]
			--"3:2527249707:20499::M", -- [39]
			"4:2488589097:3043:Warrior:F", -- [40]
			"4:2467225379:3041:Warrior:M", -- [41]
			"4:2449859600:3042:Warrior:M", -- [42]
			"4:2468013393:3039:Hunter:M", -- [43]
			"4:2515591560:3038:Hunter:F", -- [44]
			"4:2539249027:3040:Hunter:M", -- [45]
		},
		[1458] = { --Undercity
			"1:60.6,41.2:15684::M", -- [22]
			"1:64.2.35.8:15683::M", -- [22]
			"1:67.8,36.0:15682::M", -- [22]
			"1:71.4,41.4:15676::M", -- [22]
			"1:71.2,47.0:15675::M", -- [22]
			"1:67.8,52.2:8672::M", -- [22]
			"1:64.2,52.2:8721::M", -- [22]
			"1:60.6,46.8:15686::M", -- [22]
			"10:81.0,31.8:4573:7731:M", -- [2]
			"10:54.4,49.4:4614:2368:M", -- [2]		
			"10:2053815279:4611:2259:M", -- [1]
			"10:3267345626:11031:4036:M", -- [2]
			"12:3046001738:4580::F", -- [3]
			"10:3037220417:4576:3908:M", -- [4]
			"12:3031321115:5821::M", -- [5]
			"12:2994292090:5754::M", -- [6]
			"12:2981774988:4570::F", -- [7]
			"12:2643610186:5819::F", -- [8]
			"12:2634632363:4597::M", -- [9]
			"10:2636205970:4596:3100:M", -- [10]
			"12:2519618621:4602::M", -- [11]
			"12:2519618621:4600::M", -- [12]
			"12:2521584498:4601::M", -- [13]
			"10:2416009100:4598:2575:M", -- [14]
			"12:2356306657:4604::F", -- [15]
			"10:2684591620:4616:7411:F", -- [16]
			"10:3003684460:7087:8613:M", -- [17]
			"12:3036124620:5820::F", -- [18]
			"10:3009844066:4588:2108:M", -- [19]
			"10:3152907854:4591:3273:F", -- [20]
			"12:3310059459:4569::M", -- [21]
			"12:3326246944:4592::M", -- [22]
			"2:2836099650:4549::M", -- [23]
			"2:2829938889:4550::M", -- [24]
			"2:2833739674:2458::M", -- [25]
			"2:2843635826:2459::M", -- [26]
			"12:2647943875:4556::M", -- [27]
			"12:2633656583:4557::M", -- [28]
			"12:2682479650:4559::M", -- [29]
			"12:2681103367:4560::M", -- [30]
			"12:2750374135:4558::F", -- [31]
			"6:2905891242:6741::M", -- [32]
			"8:2919195291:45972::M", -- [33]
			"4:3693619443:4563:Warlock:M", -- [34]
			"4:3704170298:4564:Warlock:M", -- [35]
			"4:3659080771:4566:Mage:M", -- [36]
			"4:3668255558:4567:Mage:M", -- [37]
			"4:3650624035:4568:Mage:F", -- [38]
			"4:3820300575:4565:Warlock:M", -- [39]
			"4:3663640066:4583:Rogue:M", -- [40]
			"4:3640966289:4584:Rogue:M", -- [41]
			"4:3598039125:4582:Rogue:F", -- [42]
			--"3:2624974325:15007::M", -- [43]
			--"3:2419055271:347::M", -- [44]
			"4:2022713571:4593:Warrior:M", -- [45]
			"4:2082154845:4594:Warrior:F", -- [46]
			"4:2031692830:4595:Warrior:M", -- [47]
			"4:2115513169:4606:Priest:M", -- [48]
			"4:2048208992:4608:Priest:M", -- [49]
			"12:2672444577:4603::M", -- [50]
			"11:2981651539:4562::M", -- [51]
			"6:2962849039:4555::F", -- [52]
			"7:2907463787:6741:Undercity:M", -- [53]
		},
		[1428] = { --Burning Steppes
			"6:2821340526:3708::F", -- [1]
			"12:2838902877:9544::F", -- [2]
			"16:63.2,23.6:6491::F",
		},
		[1418] = { --Badlands
			"8:167409951:32241::M", -- [1]
			"12:125794590:1407::F", -- [2]
			"7:122844548:9356:Kargath:M", -- [3]
			"6:122844548:9356::M", -- [4]
			"6:126580128:2908::M", -- [5]
			"16:8.2,55.6:6491::F",
			"16:57.0,24.6:6491::F",
		},
		[1423] = { --Eastern Plaguelands
			"8:3475871226:50164::M", -- [1]
			"7:3504772249:16256:Light's Hope Chapel:F", -- [2]
			"16:39.0,92.6:6491::F",
			"16:80.0,64.6:6491::F",
			"16:47.2,44.2:6491::F",
		},
		[1452] = { --Winterspring
			"2:2638503613:13917::M", -- [1]
			"1:2638503678:9857::F", -- [2]
			"12:2648269076:11183::M", -- [3]
			"12:2648269076:11182::M", -- [4]
			"12:2649448770:11184::M", -- [5]
			"8:2632278737:45332::M", -- [6]
			"7:2635359111:11118:Everlook:F", -- [7]
			"6:2635359111:11118::F", -- [8]
			"16:61.2,34.8:6491::F",
		},
		[1444] = { --Feralas
			"10:76.0,43.4:8146:2368:M", -- [2]
			"6:3242946678:8143::F", -- [1]
			"10:3194711629:11098:2108:F", -- [2]
			"10:3197726258:8144:8613:M", -- [3]
			"12:3207228712:8159::M", -- [4]
			"8:3216732329:12914::M", -- [5]
			"11:3205460737:3500::M", -- [6]
			"7:3212669840:7737:Camp Mojache:F", -- [7]
			"6:3212669840:7737::F", -- [8]
			"12:3217913072:9548::M", -- [9]
			"4:3264375901:8142:Druid:M", -- [10]
			"16:54.8,47.8:6491::F",
			"16:73.0,44.8:6491::F",
		},
		[1412] = { --Mulgore
			"10:44.6,60.6:5938:7731:M", -- [2]
			"4:1900724671:3061:Hunter:M", -- [1]
			"4:1890566904:3059:Warrior:M", -- [2]
			"6:1945027543:3072::F", -- [3]
			"4:1936310968:3062:Shaman:F", -- [4]
			"4:1936310968:3060:Druid:M", -- [5]
			"12:1900529178:3075::M", -- [6]
			"12:1896007218:3073::M", -- [7]
			"12:1896596983:3074::F", -- [8]
			"6:1918486335:3883::M", -- [9]
			"7:2003475538:6747:Bloodhoof Village:M", -- [10]
			"6:2003475538:6747::M", -- [11]
			"6:2004917164:6776::M", -- [12]
			"10:2007538615:5939:3273:F", -- [13]
			"8:2016254558:12912::M", -- [14]
			"6:2042666338:3884::F", -- [15]
			"4:2124913443:3063:Warrior:M", -- [16]
			"4:2078054263:3066:Shaman:M", -- [17]
			"4:2083756187:3064:Druid:F", -- [18]
			"4:2051575419:3065:Hunter:M", -- [19]
			"10:1956090893:6290:8613:M", -- [20]
			"10:1954714682:3069:2108:M", -- [21]
			"10:1952421026:3067:2550:M", -- [22]
			"12:1953994110:3078::M", -- [23]
			"12:1960875422:3077::M", -- [24]
			"12:1967560181:3079::M", -- [25]
			"12:1974441492:3080::M", -- [26]
			"16:42.6,78.0:6491::F",
			"16:46.4,55.6:6491::F",
		},
		[1434] = { --Stranglethorn Vale
			"10:27.6,77.0:2834:7731:M", -- [2]			
			"10:27.6,77.8:908:2368:M", -- [2]
			"6:1383615171:7485::M", -- [1]
			"10:1363823069:1385:2108:M", -- [2]
			"10:32.2,27.6:2856:2368:M", -- [2]
			"4:1339967878:1404:Hunter:M", -- [3]
			"7:1350716424:5814:Grom'gol Base Camp:M", -- [4]
			"6:1350716424:5814::M", -- [5]
			"12:1388005268:1146::M", -- [6]
			"12:1396197286:1381::M", -- [7]
			"8:1396263290:32573::M", -- [8]
			"6:1356744602:1149::M", -- [9]
			"10:1346652084:1382:2550:M", -- [10]
			"7:1161479650:6807:Booty Bay:M", -- [11]
			"6:1161479650:6807::M", -- [12]
			"6:1162855863:2832::M", -- [13]
			"8:1145422733:13054::M", -- [14]
			"1:1142277008:15681::M", -- [15]
			"2:1140835242:8123::M", -- [16]
			"2:1142473708:2625::M", -- [17]
			"12:1179698761:2843::F", -- [18]
			"1:1219019355:15677::M", -- [19]
			"12:1217511685:2482::F", -- [20]
			"12:1214431365:2840::M", -- [21]
			"12:1216659181:2839::M", -- [22]
			"6:1211481676:2664::M", -- [23]
			"12:1248444727:2847::M", -- [24]
			"10:1246085457:2836:3100:M", -- [25]
			"12:1247002609:2845::M", -- [26]
			"12:1243594789:2844::M", -- [27]
			"10:1234814135:2627:3908:M", -- [28]
			"8:1172817479:13055::M", -- [29]
			"6:1203225841:2842::M", -- [30]
			"16:38.4,8.8:6491::F",
			"16:30.0,73.0:6491::F",
		},
		[1435] = { --Swamp of Sorrows
			"11:1966769933:983::M", -- [1]
			"4:2088930914:988:Warlock:M", -- [2]
			"10:2077003480:1386:2259:M", -- [3]
			"12:1958839272:8176::M", -- [4]
			"12:1964671584:981::M", -- [5]
			"12:1934721328:980::M", -- [6]
			"8:1955237111:26565::M", -- [7]
			"4:1929810628:985:Warrior:M", -- [8]
			"7:1933938916:6930:Stonard:M", -- [9]
			"6:1933938916:6930::M", -- [10]
			"12:1933280069:984::M", -- [11]
			"16:50.2,62.2:6491::F",
		},
		[1442] = { --Stonetalon Mountains
			"10:49.2,57.2:11074:4036:M",
			"12:1947965225:9549::M", -- [1]
			"12:58.2,51.6:4085::M", -- [1]
			"12:62.6,40.2:4086::M", -- [1]			
			"6:1971033649:4082::M", -- [2]
			"6:1983223150:5870::M", -- [3]
			"8:2062392420:12911::M", -- [4]
			"7:2040438496:7731:Sun Rock Retreat:F", -- [5]
			"6:2040438496:7731::F", -- [6]
			"16:57.6,62.0:6491::F",
		},
		[1427] = { --Searing Gorge
			"12:1665353885:14624::M", -- [1]
			"16:35.6,22.8:6491::F",
		},
		[1448] = { --Felwood
			"6:1492289551:2806::M", -- [1]
			"12:1492289551:10379::M", -- [2]
			"8:1494058843:56188::M", -- [3]
			"16:49.6,30.8:6491::F",
			"16:56.2,86.6:6491::F",
		},
		[1425] = { --The Hinterlands
			"10:3449278622:14740:7731:M", -- [1]
			"8:3388001806:48823::M", -- [2]
			"6:3406416497:14738::M", -- [3]
			"11:3384920200:14739::F", -- [4]
			"12:3330198962:14737::M", -- [5]
			"7:3357593659:14731:Revantusk Village:M", -- [6]
			"6:3357593659:14731::M", -- [7]
			"16:72.6,68.0:6491::F",
		},
		[1440] = { --Ashenvale
			"10:53.2,81.6:5941:7731:M", -- [2]			
			"6:505567066:12962::M", -- [1]
			"7:3176700750:12196:Splintertree Post:F", -- [2]
			"6:3176700750:12196::F", -- [3]
			"12:3156908625:6028::M", -- [4]
			"8:3161365471:47792::M", -- [5]
			"16:40.2,53.0:6491::F",
			"16:80.6,58.0:6491::F",
			"10:50.6,67.0:3965:2368:M", -- [2]
		},
		[1441] = { --Thousand Needles
			"11:1940685321:4878::M", -- [1]
			"6:1950450402:4875::M", -- [2]
			"8:1967424156:45252::M", -- [3]
			"7:1978106816:11116:Freewind Post:M", -- [4]
			"6:1979220975:11116::M", -- [5]
			"6:1976140801:4876::M", -- [6]
			"16:30.6,23.6:6491::F",
			"16:69.0,53.4:6491::F",
		},
		[1411] = { --Durotar
			"10:55.4,75.0:3185:2368:M", -- [2]		
			"12:2281334950:3166::M", -- [1]
			"12:2275961087:3165::M", -- [2]
			"4:2336909714:3172:Warlock:M", -- [3]
			"8:2230479857:12909::M", -- [4]
			"7:2213440158:6928:Razor Hill:M", -- [5]
			"12:2231462251:3167::M", -- [6]
			"12:2233755565:3163::M", -- [7]
			"10:2236049449:3174:3100:M", -- [8]
			"10:2242013285:11025:4036:M", -- [9]
			"10:2226743481:3175:2575:M", -- [10]
			"6:2197777696:3881::M", -- [11]
			"4:2227990352:3171:Hunter:M", -- [12]
			"4:2326228166:3169:Warrior:M", -- [13]
			"4:2328653280:3706:Priest:F", -- [14]
			"4:2336582943:3173:Shaman:M", -- [15]
			"6:2335403080:3164::M", -- [16]
			"10:2327145339:5943:3273:M", -- [17]
			"6:2387262523:3933::M", -- [18]
			"4:2417016879:5880:Mage:M", -- [19]
			"12:2424748882:10369::M", -- [20]
			"6:2419506112:3186::F", -- [21]
			"4:1842721190:3153:Warrior:M", -- [22]
			"4:1840230772:3154:Hunter:F", -- [23]
			"4:1821683952:5884:Mage:F", -- [24]
			"4:1820962993:3157:Shaman:F", -- [25]
			"4:1819455543:3707:Priest:M", -- [26]
			"4:1771744812:3155:Rogue:M", -- [27]
			"12:1744481710:3160::M", -- [28]
			"12:1740942924:3159::M", -- [29]
			"12:1741270485:3161::M", -- [30]
			"4:1745596190:3156:Warlock:M", -- [31]
			"6:1831578745:3158::F", -- [32]
			"6:1833872469:3882::M", -- [33]
			"16:47.0,17.6:6491::F",
			"16:53.4,44.6:6491::F",
			"16:44.2,69.4:6491::F",
			"16:57.4,73.2:6491::F",
		},
		[1443] = { --Desolace
			"10:22.6,72.6:12032:7731:M", -- [2]			
			"10:977058203:12032:7731:F", -- [1]
			"10:999666303:12030:8613:M", -- [2]
			"6:1125626457:12033::M", -- [3]
			"12:1105704357:12045::F", -- [4]
			"6:1070708716:12027::M", -- [5]
			"7:1036103368:11106:Shadowprey Village:F", -- [6]
			"6:1036103368:11106::F", -- [7]
			"8:1065660479:48824::M", -- [8]
			"16:50.2,62.8:6491::F",
		},
		[1413] = { --The Barrens
			"6:2248887847:3480::F", -- [1]
			"8:2234338804:12910::M", -- [2]
			"7:2232175771:3934:The Crossroads:M", -- [3]
			"6:2232175771:3934::M", -- [4]
			"6:2230864922:5871::M", -- [5]
			"11:2208845164:3490::M", -- [6]
			"12:2195016291:3488::M", -- [7]
			"12:2199669435:3479::M", -- [8]
			"12:2198293105:3483::M", -- [9]
			"12:2197178931:3477::M", -- [10]
			"10:2202487321:3478:3100:M", -- [11]
			"10:2242466103:3484:3908:M", -- [12]
			"12:2242269565:3486::F", -- [13]
			"6:2660262732:3498::M", -- [14]
			"8:2669700160:13053::M", -- [15]
			"7:2664654046:6791:Ratchet:M", -- [16]
			"6:2664654046:6791::M", -- [17]
			"12:2672975870:3491::M", -- [18]
			"2:2690539491:3496::M", -- [19]
			"2:2691784660:8119::M", -- [20]
			"10:2693225705:8738:4036:M", -- [21]
			"10:2693160169:3494:4036:M", -- [22]
			"7:1957140245:7714:Camp Taurajo:M", -- [23]
			"6:1957140245:7714::M", -- [24]
			"8:1937086002:22506::M", -- [25]
			"12:1937413899:10380::M", -- [26]
			"10:1935710019:6387:8613:M", -- [27]
			"10:1926535212:3703:2108:M", -- [28]
			"10:1929484273:3704:3908:F", -- [29]
			"6:1921030172:3705::M", -- [30]
			"16:45.2,61.0:6491::F",
			"16:50.8,32.4:6491::F",
			"16:60.2,39.8:6491::F",
		},
		[1445] = { --Dustwallow Marsh
			"12:1553748299:4884::M", -- [1]
			"7:1583502041:24208:Brackenwall Village:M", -- [2]
			"6:1583502041:24208::M", -- [3]
			"16:39.6,30.8:6491::F",
		},
		[1446] = { --Tanaris
			"10:2253669873:8126:4036:M", -- [1]
			"10:2245150432:8736:4036:M", -- [2]
			"8:2246723360:13040::M", -- [3]
			"7:2254915474:7733:Gadgetzan:M", -- [4]
			"6:2254915474:7733::M", -- [5]
			"6:2259372005:8125::M", -- [6]
			"2:2246527478:7799::M", -- [7]
			"2:2248034791:8124::M", -- [8]
			"1:2231454649:8661::M", -- [9]
			"12:2212055476:5411::M", -- [10]
			"10:2195212234:8128:2575:M", -- [11]
			"12:2180662944:8131::M", -- [12]
			"12:2181252817:8129::M", -- [13]
			"16:54.0,28.6:6491::F",
		},
		[1420] = { --Tirisfal
			"10:67.2,51.0:5690:7731:M", -- [2]		
			"10:59.8,52.0:2114:2368:M", -- [2]
			"4:1330424272:2126:Warlock:M", -- [1]
			"4:1327540507:2124:Mage:F", -- [2]
			"4:1334421802:2123:Priest:M", -- [3]
			"12:1389275564:2116::M", -- [4]
			"12:1389079014:2117::M", -- [5]
			"6:1387440033:2115::M", -- [6]
			"4:1393272831:2122:Rogue:M", -- [7]
			"4:1401333774:2119:Warrior:M", -- [8]
			"12:1394845634:2113::M", -- [9]
			"6:2563146861:3547::M", -- [10]
			"12:2591655716:2137::F", -- [11]
			"12:2585888922:2136::M", -- [12]
			"12:2585299017:2135::M", -- [13]
			"6:2624423600:2134::F", -- [14]
			"8:2636679110:12918::M", -- [15]
			"10:2653062952:5759:3273:F", -- [16]
			"7:2650768716:5688:Gallows' End Tavern:F", -- [17]
			"6:2650768716:5688::F", -- [18]
			"4:2658960959:2128:Mage:M", -- [19]
			"4:2648344138:2127:Warlock:M", -- [20]
			"4:2651358570:2130:Rogue:F", -- [21]
			"4:2647950766:2129:Priest:M", -- [22]
			"10:2651292713:5695:7411:M", -- [23]
			"4:2654045730:2131:Warrior:M", -- [24]
			"16:31.2,64.8:6491::F",
			"16:56.2,49.4:6491::F",
			"16:79.0,40.8:6491::F",
			"16:82.0,69.6:6491::F",
		},
		[1419] = { --Blasted Lands
			"16:51.0,12.2:6491::F",
		},		
		[1431] = { --Duskwood
			"16:20.0,49.4:6491::F",
		},
		[1433] = { --Redridge Mountains
			"16:20.8,56.6:6491::F",
		},
		[1422] = { --Western Plaguelands
			"16:65.6,74.6:6491::F",			
		},		
	},
	["Alliance"] = {
		[1411] = { --Durotar
			"16:53.4,44.6:6491::F",
		},		
		[1442] = { --Stonetalon Mountains
			"8:1548030606:50567::M", -- [1]
			"12:1531056836:4188::F", -- [2]
			"6:1527386118:4084::F", -- [3]
			"7:1534660270:16458:Stonetalon Peak:F", -- [4]
			"6:1534660270:16458::F", -- [5]
			"16:57.6,62.0:6491::F",
			"12:58.2,51.6:4085::M", -- [1]
			"12:62.6,40.2:4086::M", -- [1]				
		},
		[1446] = { --Tanaris
			"12:2210023868:5411::M", -- [1]
			"1:2231782364:8661::M", -- [2]
			"8:2246002484:13040::M", -- [3]
			"7:2255636301:7733:Gadgetzan:M", -- [4]
			"6:2255636301:7733::M", -- [5]
			"6:2261010405:8125::M", -- [6]
			"10:2253407730:8126:4036:M", -- [7]
			"10:2248034004:8736:4036:M", -- [8]
			"12:2178107025:8131::M", -- [9]
			"12:2181908173:8129::M", -- [10]
			"10:2194819040:8128:2575:M", -- [11]
			"16:54.0,28.6:6491::F",
		},
		[1450] = { --Moonglade
			"12:2289790270:12029::F", -- [1]
			"6:1944344755:12021::F", -- [2]
			"6:1914656498:12026::F", -- [3]
			"16:62.0,69.6:6491::F",
		},
		[1419] = { --Blasted Lands
			"12:2838178899:5508::M", -- [1]
			"8:2747019466:33546::M", -- [2]
			"16:51.0,12.2:6491::F",
		},
		[1427] = { --Searing Gorge
			"12:1661880597:14624::M", -- [1]
			"16:35.6,22.8:6491::F",
		},
		[1431] = { --Duskwood
			"10:3323427980:1676:4036:M", -- [1]
			"6:3259399336:3138::M", -- [2]
			"8:3170661905:11017::M", -- [3]
			"6:3188945585:227::F", -- [4]
			"7:3175117268:6790:Darkshire:F", -- [5]
			"6:3175117268:6790::F", -- [6]
			"6:3166925133:274::M", -- [7]
			"12:3176103060:226::M", -- [8]
			"10:3176103060:3136:3100:F", -- [9]
			"12:3162996577:225::M", -- [10]
			"10:3178069821:3137:2575:M", -- [11]
			"16:20.0,49.4:6491::F",
			"16:75.0,59.0:6491::F",
		},
		[1439] = { --Darkshore
			"6:1578201485:4200::M", -- [1]
			"7:1587638512:6737:Auberdine:F", -- [2]
			"6:1587638512:6737::F", -- [3]
			"6:1594322866:4191::F", -- [4]
			"6:1582919776:4192::M", -- [5]
			"10:1641900282:6297:2575:M", -- [6]
			"10:1639147705:6299:3100:M", -- [7]
			"10:1644063027:11037:4036:F", -- [8]
			"12:1639541070:6300::F", -- [9]
			"10:1640130515:4193:3908:M", -- [10]
			"12:1639212943:4185::F", -- [11]
			"6:1608017827:4182::M", -- [12]
			"12:1612474244:4183::M", -- [13]
			"12:1590192482:4186::F", -- [14]
			"12:1590913495:4187::M", -- [15]
			"16:43.6,92.2:6491::F",
			"16:41.8,36.6:6491::F",			
		},
		[1443] = { --Desolace
			"7:2846691524:11103:Nijel's Point:F", -- [1]
			"6:2842759449:11103::F", -- [2]
			"6:2845118698:8150::F", -- [3]
			"16:50.2,62.8:6491::F",			
		},
		[1447] = { --Azshara
			"12:514115748:14301::F", -- [1]
			"16:14.4,78.6:6491::F",
			"16:54.2,71.4:6491::F",
			"16:70.4,15.6:6491::F",			
		},
		[1451] = { --Silithus
			"8:2220843306:49379::M", -- [1]
			"12:2196398975:15176::M", -- [2]
			"7:2229691443:15174:Cenarion Hold:F", -- [3]
			"6:2229691443:15174::F", -- [4]
			"16:47.0,38.6:6491::F",			
		},
		[1455] = { --Ironforge
			"10:54.8,58.6:5150:3273:M", -- [2]	
			"10:52.2,41.6:4258:3100:M", -- [2]	
			"10:52.0,42.4:10276:3100:M", -- [2]	
			"10:51.8,42.2:10277:3100:M", -- [2]				
			"10:43.2,29.0:5153:3908:M", -- [2]
			"10:43.6,28.2:1703:3908:M", -- [2]
			"10:39.8,33.4:5127:2108:M", -- [2]
			"10:39.0,32.8:1466:2108:M", -- [2]		
			"10:39.6,32.6:6291:8613:M", -- [2]									
			"10:60.0,36.8:5159:2550:M", -- [2]
			"10:60.0,45.4:5157:7411:M", -- [2]
			"10:60.4,45.0:11065:7411:M", -- [2]										
			"10:50.2,26.0:4254:2575:M", -- [2]												
			"10:48.4,6.4:5161:7731:M", -- [2]		
			"10:55.6,58.8:5137:2368:M", -- [2]		
			"10:66.4,55.2:1246:2259:M", -- [2]					
			"4:1046219961:5148:Paladin:M", -- [1]
			"4:1124274517:5145:Mage:F", -- [2]
			"4:1170216325:7312:Mage:M", -- [3]
			"4:1170216325:5144:Mage:F", -- [4]
			"4:1075387166:5143:Priest:M", -- [5]
			"4:1064900369:5142:Priest:F", -- [6]
			"4:995758130:5149:Paladin:M", -- [7]
			"4:998117927:11406:Priest:M", -- [8]
			"4:1033114908:5141:Priest:M", -- [9]
			"4:1005456467:5147:Paladin:M", -- [10]
			"4:1115950976:5146:Mage:M", -- [11]
			"12:973941157:5152::M", -- [12]
			"12:986982796:5133::M", -- [13]
			"12:1651445474:5155::F", -- [14]
			"12:1939214613:5170::M", -- [15]
			"10:2070024223:5161:7731:M", -- [16]
			"4:2162102143:5172:Warlock:M", -- [17]
			"4:2185040196:5171:Warlock:M", -- [18]
			"4:2152927959:5173:Warlock:M", -- [19]
			"4:2217682662:5167:Rogue:M", -- [20]
			"4:2252809712:5166:Rogue:M", -- [21]
			"4:2215585048:5165:Rogue:M", -- [22]
			"10:2943709348:5174:4036:M", -- [23]
			"10:2996404032:7944:4036:M", -- [24]
			"10:2866974299:5177:2259:F", -- [25]
			"8:3098967623:40680::M", -- [26]
			"8:3040917724:40484::M", -- [27]
			"12:3102975848:5123::F", -- [28]
			"12:3081939465:5122::M", -- [29]
			"6:3102327550:5140::F", -- [30]
			"4:3045971488:5116:Hunter:M", -- [31]
			"4:3001144288:5117:Hunter:M", -- [32]
			"4:2842878363:5114:Warrior:M", -- [33]
			"4:2867455384:1901:Warrior:M", -- [34]
			--"3:2989811632:12197::M", -- [35]
			--"3:3003180666:20374::M", -- [36]
			--"3:3004752979:857::M", -- [37]
			--"3:3009405886:19915::M", -- [38]
			--"3:3040011339:14982::F", -- [39]
			"4:3044992357:5115:Hunter:F", -- [40]
			"4:3027757046:5113:Warrior:M", -- [41]
			"12:2670256931:5121::M", -- [42]
			"12:2645156799:7976::M", -- [43]
			"12:2341397252:5129::F", -- [44]
			"12:2328158115:5126::M", -- [45]
			"8:1429186267:40627::M", -- [46]
			"2:1528732450:2461::M", -- [47]
			"2:1565433749:5099::F", -- [48]
			"2:1483904773:2460::M", -- [49]
			"12:1383961777:5107::M", -- [50]
			"12:1399100276:5108::F", -- [51]
			"8:897550050:32349::M", -- [52]
			"6:812549393:5112::F", -- [53]
			"7:782926744:5111:Ironforge:M", -- [54]
			"6:782926744:5111::M", -- [55]
			"1:24.0,72.0:8671::M", -- [55]
			"1:24.2,74.4:8720::M", -- [55]
			"1:25.8,75.2:9859::M", -- [55]			
		},
		[1424] = { --Hillsbrad Foothills
			"10:50.6,61.0:2367:7731:M", -- [2]		
			"6:2104069439:2381::M", -- [1]
			"6:2108919003:3541::F", -- [2]
			"8:2163512950:12915::M", -- [3]
			"7:2196477673:2352:Southshore:M", -- [4]
			"6:2196477673:2352::M", -- [5]
			"6:2193200948:2364::F", -- [6]
			"6:2210502128:2366::M", -- [7]
			"11:2184681264:3542::M", -- [8]
			"16:51.8,52.6:6491::F",			
			"12:60.8,19.8:3537::M", -- [32]
			"12:80.0,39.0:3536::M", -- [32]
			"12:51.2,57.0:3543::M", -- [32]			
		},
		[1428] = { --Burning Steppes
			"6:3620777377:3298::F", -- [1]
			"12:3655577353:1296::M", -- [2]
			"16:63.2,23.6:6491::F",
		},
		[1432] = { --Loch Modan
			"10:40.6,39.6:1683:7731:M", -- [2]	
			"10:36.6,48.4:1473:2368:M", -- [2]		
			"8:1490844215:11031::M", -- [1]
			"7:1524988913:6734:Stoutlager Inn:M", -- [2]
			"6:1524988913:6734::M", -- [3]
			"6:1497398421:1682::F", -- [4]
			"6:1515224845:3948::F", -- [5]
			"10:1590787523:1470:2259:M", -- [6]
			"10:1594784382:1681:2575:M", -- [7]
			"12:1462204256:167::M", -- [8]
			"16:32.6,47.0:6491::F",
		},
		[1436] = { --Westfall
			"12:2477361668:1668::M", -- [1]
			"6:2478934367:1670::M", -- [2]
			"6:2443868386:491::M", -- [3]
			"8:2281211974:22644::M", -- [4]
			"7:2270988653:8931:Sentinel Hill:F", -- [5]
			"6:2270988653:8931::F", -- [6]
			"16:51.8,49.4:6491::F",
		},
		[1440] = { --Ashenvale
			"11:1503558671:3970::F", -- [1]
			"12:1486126987:3953::M", -- [2]
			"12:1479835290:3952::F", -- [3]
			"6:1498776145:3962::M", -- [4]
			"12:1535673625:11137::M", -- [5]
			"10:1544389990:3967:2108:F", -- [6]
			"8:1557889225:11045::M", -- [7]
			"6:1572896712:3961::F", -- [8]
			"7:1588231685:6738:Astranaar:F", -- [9]
			"6:1588231685:6738::F", -- [10]
			"16:40.2,53.0:6491::F",
			"16:80.6,58.0:6491::F",			
		},
		[1444] = { --Feralas
			"10:32.2,41.6:7946:7731:M", -- [2]		
			"12:1319988835:10293::F", -- [1]
			"6:1330409256:7736::F", -- [2]
			"7:1330409256:7736:Feathermoon Stronghold:F", -- [3]
			"11:1327983581:3700::M", -- [4]
			"6:1332180562:7943::M", -- [5]
			"10:1401188385:7948:2259:F", -- [6]
			"16:31.6,48.0:6491::F",
			"16:54.8,47,8:6491::F",	
		},
		[1448] = { --Felwood
			"4:2661105335:9465:Druid:M", -- [1]
			"6:2676048274:2803::M", -- [2]
			"12:2680111636:15315::F", -- [3]
			"16:49.6,30.8:6491::F",
			"16:56.2,86.6:6491::F",			
		},
		[1452] = { --Winterspring
			"12:2649120992:11183::M", -- [1]
			"12:2647089401:11182::M", -- [2]
			"12:2649579838:11184::M", -- [3]
			"1:2636930831:9857::F", -- [4]
			"2:2639683261:13917::M", -- [5]
			"8:2631688908:45332::M", -- [6]
			"6:2633327667:11187::M", -- [7]
			"7:2635162446:11118:Everlook:F", -- [8]
			"6:2635162446:11118::F", -- [9]
			"16:61.2,34.8:6491::F",
		},
		[1413] = { --The Barrens
			"10:2693356775:8738:4036:M", -- [1]
			"10:2691980528:3494:4036:M", -- [2]
			"2:2692767702:8119::M", -- [3]
			"2:2691063778:3496::M", -- [4]
			"12:2673565698:3491::M", -- [5]
			"12:2670027359:3492::M", -- [6]
			"12:2671010383:3493::M", -- [7]
			"12:2652135909:3658::M", -- [8]
			"6:2660459338:3498::M", -- [9]
			"8:2670224462:13053::M", -- [10]
			"7:2665374955:6791:Ratchet:M", -- [11]
			"6:2665374955:6791::M", -- [12]
			"16:45.2,61.0:6491::F",
			"16:60.2,39.8:6491::F",
		},
		[1417] = { --Arathi Highlands
			"12:1976726547:15127::M", -- [1]
			--"3:1987146341:19855::M", -- [2]
			"6:1992980850:2808::F", -- [3]
			"6:1956018544:2814::M", -- [4]
			"16:48.8,55.4:6491::F",
		},
		[1425] = { --The Hinterlands
			"10:575500052:11097:2108:M", -- [1]
			"16:16.8,44.8:6491::F",
		},
		[1429] = { --Elwynn Forest
			"10:47.6,62.2:1651:7731:M", -- [2]	
			"10:39.8,48.4:1218:2368:M", -- [2]
			"12:1792780309:2046::M", -- [1]
			"12:1784391879:54::F", -- [2]
			"10:1789962198:514:3100:M", -- [3]
			"12:1780197403:74::M", -- [4]
			"4:1765648594:927:Paladin:M", -- [5]
			"4:1764534448:913:Warrior:F", -- [6]
			"8:1843308508:11003::M", -- [7]
			"7:1880598714:295:Goldshire:M", -- [8]
			"6:1880598714:295::M", -- [9]
			"6:1887479892:465::M", -- [10]
			"6:1885251735:151::M", -- [11]
			"6:1896458460:3935::M", -- [12]
			"10:1901504831:1430:2550:M", -- [13]
			"4:1909631309:906:Warlock:M", -- [14]
			"4:1860217217:328:Mage:M", -- [15]
			"10:1864935440:2329:3273:F", -- [16]
			"4:1864935440:377:Priest:F", -- [17]
			"4:1881974983:917:Rogue:F", -- [18]
			"12:2043898427:190::M", -- [19]
			"12:2035510124:78::M", -- [20]
			"6:2037672641:152::M", -- [21]
			"4:2140564750:459:Warlock:F", -- [22]
			"4:2166515329:915:Rogue:M", -- [23]
			"12:2051500457:1213::M", -- [24]
			"4:2154589181:911:Warrior:M", -- [25]
			"4:2167434219:925:Paladin:M", -- [26]
			"4:2138924365:375:Priest:F", -- [27]
			"4:2130863327:198:Mage:M", -- [28]
			"16:39.6,60.4:6491::F",
			"16:49.6,43.2:6491::F",
			"16:83.6,69.6:6491::F",
		},
		[1433] = { --Redridge Mountains
			"6:1240758587:791::F", -- [1]
			"12:1317435243:793::F", -- [2]
			"12:1317435243:956::M", -- [3]
			"8:1141012299:11021::M", -- [4]
			"12:1161524373:789::F", -- [5]
			"6:1148547336:5620::M", -- [6]
			"6:1153003290:3089::M", -- [7]
			"6:1145270134:3085::F", -- [8]
			"7:1157198560:6727:Lakeshire:F", -- [9]
			"6:1157198560:6727::F", -- [10]
			"10:979070846:3087:2550:F", -- [11]
			"10:21.8,45.8:812:2368:F", -- [11]
			"6:978809191:3086::F", -- [12]
			"6:899249894:1671::M", -- [13]
			"16:20.8,56.6:6491::F",
		},
		[1437] = { --Wetlands
			"10:8.0,58.6:3179:7731:M", -- [2]		
			"10:8.0,55.8:1458:2368:M", -- [2]		
			"8:462526655:11022::M", -- [1]
			"7:457481152:1464:Deepwater Tavern:M", -- [2]
			"6:457481152:1464::M", -- [3]
			"6:457481152:4963::M", -- [4]
			"10:465542407:3181:3273:M", -- [5]
			"12:482645430:1459::F", -- [6]
			"12:477926839:1462::F", -- [7]
			"12:495229201:1450::M", -- [8]
			"12:495753362:1441::M", -- [9]
			"12:489199676:1461::M", -- [10]
			"6:514167861:1452::M", -- [11]
			"12:350457618:1454::F", -- [12]
			"6:346854739:3178::M", -- [13]
			"16:11.6,43.2:6491::F",
			"16:49.6,41.6:6491::F",
		},
		[1445] = { --Dustwallow Marsh
			"6:2897249309:4896::F", -- [1]
			"4:2893576562:8140:Paladin:M", -- [2]
			"8:2831774712:11023::M", -- [3]
			"7:2859627475:6272:Theramore Isle:F", -- [4]
			"6:2863297503:4893::F", -- [5]
			"6:2870440929:4894::M", -- [6]
			"10:2745793017:4900:2259:M", -- [7]
			"10:64.0,47.6:4898:2368:M", -- [2]
			"12:2776596529:4888::F", -- [8]
			"12:2776858874:4886::M", -- [9]
			"16:63.6,43.0:6491::F",
		},
		[1449] = { --Un'goro
			"12:1893536424:3000::M", -- [1]
			"6:1858081860:12959::M", -- [2]
			"16:80.0,49.8:6491::F",
		},
		[1453] = { --Stormwind City
			"10:45.8,58.2:5493:7731:M", -- [2]		
			"10:44.8,77.0:5566:2368:M", -- [2]	
			"10:2893840186:5564:2108:M", -- [32]
			"10:2907798771:1292:8613:F", -- [33]
			"10:3249168112:5482:2550:M", -- [39]
			"10:1849181042:2327:3273:F", -- [6]	
			"10:1141098268:9584:3908:F", -- [45]				
			"10:43.0,64.4:1317:7411:F", -- [45]	
			"10:43.2,63.8:11068:7411:F", -- [45]	
			"10:57.2,16.4:957:3100:F", -- [45]	
			"10:56.8,16.4:5511:3100:F", -- [45]
			"10:54.8,7.8:5518:4036:F", -- [45]	
			"10:54.6,8.0:11026:4036:F", -- [45]
			"10:51.0,17.2:5513:2575:F", -- [45]	
			"10:15.2,49.8:5502:2368:F", -- [45]			
			"10:46.4,79.4:5499:2259:F", -- [45]			
			"10:46.4,79.0:5500:2259:F", -- [45]																			
			"4:1657553576:376:Priest:F", -- [1]
			"4:1654801410:5489:Priest:M", -- [2]
			"4:1603556594:928:Paladin:M", -- [3]
			"4:1605063293:5492:Paladin:F", -- [4]
			"4:1653494960:5491:Paladin:M", -- [5]
			"11:1856717742:1351::M", -- [7]
			"12:1582523668:1348::M", -- [8]
			"4:813074442:5506:Druid:M", -- [9]
			"4:911377228:5505:Druid:M", -- [10]
			"4:898928134:5504:Druid:M", -- [11]
			"8:952603796:11003::M", -- [12]
			"11:1396165921:1307::F", -- [13]
			"4:1585959071:5498:Mage:F", -- [14]
			"4:1650576078:5497:Mage:F", -- [15]
			"7:2269816781:6740:Stormwind City:F", -- [16]
			"6:2269816781:6740::F", -- [17]
			"8:2330962572:13059::M", -- [18]
			"2:2424159142:2457::M", -- [19]
			"2:2446506641:2456::M", -- [20]
			"2:2471213405:2455::F", -- [21]
			"1:2299631903:15659::F", -- [22]
			"1:2298518221:8719::M", -- [23]
			"1:2281610124:8670::M", -- [24]
			"12:2458358227:1287::F", -- [25]
			"12:2465895056:1289::M", -- [26]
			"11:2417796808:1275::F", -- [27]
			"11:2405934751:1257::M", -- [28]
			"6:2591662739:4981::M", -- [29]
			"6:2591662739:483::F", -- [30]
			"12:2756406748:1319::M", -- [31]						
			"4:3205531382:918:Rogue:M", -- [34]
			"4:3363738444:13283:Rogue:M", -- [35]
			"12:3182980584:1324::M", -- [36]
			"6:3178652525:1328::F", -- [37]
			"6:3258605322:5483::F", -- [38]
			"8:3056756526:13056::M", -- [40]
			--"3:3507103228:20381::M", -- [41]
			"4:3382867117:5479:Warrior:M", -- [42]
			"4:3371660594:5480:Warrior:F", -- [43]
			"4:3360913783:914:Warrior:M", -- [44]
			"4:1120322927:5495:Warlock:F", -- [46]
			"4:1091225469:461:Warlock:F", -- [47]
			"4:1117375092:5496:Warlock:M", -- [48]
			"4:62.4,14.6:5517:Hunter:F", -- [47]
			"4:61.6,15.4:5516:Hunter:F", -- [47]			
			"4:62.0,15.0:5515:Hunter:M", -- [48]			
		},
		[1457] = { --Darnassus
			"10:55.0,23.8:4160:2259:M", -- [2]
			"10:56.2,24.2:11042:2259:M", -- [2]		
			"10:55.2,22.8:11041:2259:M", -- [2]			
			"10:47.4,56.6:4156:7731:M", -- [2]
			"10:48.0,68.6:4204:2368:M", -- [2]
			"10:64.0,22.0:6292:8613:M", -- [2]
			"10:64.6,21.6:11081:2108:M", -- [2]
			"10:64.4,21.2:11083:2108:M", -- [2]									
			"4:1633539014:4091:Priest:F", -- [1]
			"4:1725293469:4092:Priest:F", -- [2]
			"4:1696583658:11401:Priest:F", -- [3]
			"4:1650708264:4090:Priest:F", -- [4]
			"2:1712417846:4209::M", -- [5]
			"2:1717857144:4208::M", -- [6]
			"2:1709796522:4155::F", -- [7]
			"8:1781754794:11038::M", -- [8]
			"4:1588738142:4163:Rogue:F", -- [9]
			"4:1621636668:4215:Rogue:M", -- [10]
			"4:1498431769:4214:Rogue:M", -- [11]
			"11:1455102043:4220::M", -- [12]
			"4:1434981814:4219:Druid:M", -- [13]
			"4:1494028946:4218:Druid:M", -- [14]
			"4:1520768191:4217:Druid:M", -- [15]
			"4:1718097379:4146:Hunter:F", -- [16]
			"4:1702039275:4138:Hunter:F", -- [17]
			"4:1812271990:4205:Hunter:M", -- [18]
			"6:2097559318:4223::M", -- [19]
			"10:2099459850:4210:2550:M", -- [20]
			"10:2218598462:4211:3273:M", -- [21]
			"10:2519867806:4213:7411:M", -- [22]
			"10:2714909066:4159:3908:F", -- [23]
			--"8:2878941633:57051::M", -- [24]
			"7:2893359362:6735:Craftsmen's Terrace:F", -- [25]
			"6:2893359362:6735::F", -- [26]
			"1:2430240079:8669::M", -- [27]
			"1:2426243722:8723::M", -- [28]
			"1:2450884525:15678::M", -- [29]
			"1:2390197933:15679::M", -- [30]
			"12:2544203564:4164::F", -- [31]
			"12:2523099568:4203::F", -- [32]
			--"3:2516737630:20497::F", -- [33]
			--"3:2491309808:907::M", -- [34]
			--"3:2523422215:2302::F", -- [35]
			--"3:2531417549:20383::F", -- [36]
			--"3:2545835189:5118::M", -- [37]
			"4:2528074552:7315:Warrior:M", -- [38]
			"4:2515950133:4087:Warrior:F", -- [39]
			"12:2712840677:4173::F", -- [40]
			"6:2798497716:4169::F", -- [41]
			"12:2694752338:4235::M", -- [42]
			"12:2601629894:4175::F", -- [43]
			"12:2596059165:4180::F", -- [44]
			"12:2815203540:4171::F", -- [45]
			"12:2800131155:4233::M", -- [46]
			"12:2747963111:4232::M", -- [47]
			"12:2783746629:4231::M", -- [48]
		},
		[1422] = { --Western Plaguelands
			"12:1850398755:12942::M", -- [1]
			"12:1838929521:10857::M", -- [2]
			"16:45.6,85.6:6491::F",
			"16:65.6,74.6:6491::F",			
		},
		[1426] = { --Dun Morogh
			"10:35.6,40.4:1700:7731:M", -- [2]	
			"6:1291106105:829::M", -- [1]
			"4:1251847398:895:Hunter:M", -- [2]
			"12:1237691842:1104::M", -- [3]
			"12:1230351720:945::M", -- [4]
			"4:1220127949:916:Rogue:M", -- [5]
			"4:1237298247:912:Warrior:M", -- [6]
			"4:1229236747:837:Priest:M", -- [7]
			"4:1232579087:944:Mage:M", -- [8]
			"12:1236445701:836::M", -- [9]
			"4:1228777833:460:Warlock:M", -- [10]
			"12:1947108331:1690::M", -- [11]
			"12:1941341296:1240::M", -- [12]
			"12:1941538060:1238::M", -- [13]
			"12:1946715555:1273::M", -- [14]
			"10:1945732354:1241:3100:M", -- [15]
			"8:2017298048:11030::M", -- [16]
			"4:2043381035:1232:Paladin:M", -- [17]
			"4:2039776558:1228:Mage:M", -- [18]
			"6:2027849164:1691::M", -- [19]
			"10:2026342009:2326:3273:M", -- [20]
			"4:2032568012:1229:Warrior:M", -- [21]
			"4:2030077347:1226:Priest:M", -- [22]
			"10:2044298757:1699:2550:M", -- [23]
			"16:29.6,69.8:6491::F",
			"16:47.0,55.0:6491::F",
			"16:54.2,39.0:6491::F",									
		},
		[1434] = { --Stranglethorn
			"10:27.6,77.8:908:2368:M", -- [2]
			"6:1630930903:734::M", -- [1]
			"8:1172751941:13055::M", -- [2]
			"12:1177929313:2843::F", -- [3]
			"8:1145422734:13054::M", -- [4]
			"1:1142342542:15681::M", -- [5]
			"2:1140835246:8123::M", -- [6]
			"2:1142146005:2625::M", -- [7]
			"6:1201194207:2842::M", -- [8]
			"1:1194050885:9858::M", -- [9]
			"10:1205061543:2837:2259:M", -- [10]
			"10:1234617520:2627:3908:M", -- [11]
			"12:1210828421:2849::M", -- [12]
			"10:1217774429:7406:4036:M", -- [13]
			"12:1247854895:2847::M", -- [14]
			"10:1246871877:2836:3100:M", -- [15]
			"12:1244905446:2845::M", -- [16]
			"12:1244119099:2844::M", -- [17]
			"1:1220985404:15677::M", -- [18]
			"12:1217118519:2482::F", -- [19]
			"12:1214038140:2840::M", -- [20]
			"12:1215020766:2839::M", -- [21]
			"6:1213054563:2664::M", -- [22]
			"16:38.4,8.8:6491::F",
			"16:30.0,73.0:6491::F",			
		},
		[1438] = { --Teldrassil
			"10:55.8,93.4:3607:7731:M", -- [2]				
			"10:57.6,60.6:3604:2368:M", -- [2]		
			"8:2407044518:11037::M", -- [1]
			"12:2401015672:3610::F", -- [2]
			"4:2412287894:3598:Warrior:F", -- [3]
			"12:2414385139:3613::F", -- [4]
			"12:2415040594:3609::M", -- [5]
			"12:2415237284:3612::F", -- [6]
			"12:2409470520:3611::M", -- [7]
			"4:2420480509:3599:Rogue:M", -- [8]
			"7:2391316771:6736:Dolanaar:M", -- [9]
			"6:2391316771:6736::M", -- [10]
			"10:2451741902:6286:2550:M", -- [11]
			"6:2454953164:4265::F", -- [12]
			"4:2402655643:3602:Druid:M", -- [13]
			"4:2431817871:3601:Hunter:M", -- [14]
			"10:2376372577:6094:3273:F", -- [15]
			"4:2385350943:3600:Priest:F", -- [16]
			"6:2379846224:4266::F", -- [17]
			"6:2383581702:3608::F", -- [18]
			"12:2550032728:3589::F", -- [19]
			"6:2559600674:6091::F", -- [20]
			"12:2534434216:3591::F", -- [21]
			"12:2523096478:3588::M", -- [22]
			"12:2524079571:3592::M", -- [23]
			"4:2559533717:3593:Warrior:F", -- [24]
			"4:2559075050:3594:Rogue:M", -- [25]
			"4:2516871034:3597:Druid:M", -- [26]
			"4:2518574967:3596:Hunter:F", -- [27]
			"16:58.8,42.6:6491::F",
			"16:56.2,63.2:6491::F",					
		},
	},
}