

local DGV = DugisGuideViewer


DGV.TalentAdvisorButtonMap = {

	DRUID = {
			{--Balance
		["Nature's Grasp"] = 1,
		["Improved Wrath"] = 2,
		["Improved Moonfire"] = 3,
		["Nature's Reach"] = 4,
		["Natural Shapeshifter"] = 5,
		["Improved Thorns"] = 6,
		["Moonglow"] = 7,
		["Improved Starfire"] = 8,
		["Improved Entangling Roots"] = 9,
		["Omen of Clarity"] = 10,
		["Nature's Grace"] = 11,
		["Moonfury"] = 12,
		["Natural Weapons"] = 13,
		["Vengeance"] = 14,
		["Moonkin Form"] = 15,
		["Improved Nature's Grasp"] = 16,
			},
			{--Feral Combat
		["Thick Hide"] = 1,
		["Feral Aggression"] = 2,
		["Ferocity"] = 3,
		["Brutal Impact"] = 4,
		["Sharpened Claws"] = 5,
		["Feral Instinct"] = 6,
		["Blood Frenzy"] = 7,
		["Primal Fury"] = 8,
		["Improved Shred"] = 9,
		["Predatory Strikes"] = 10,
		["Feral Charge"] = 11,
		["Savage Fury"] = 12,
		["Feline Swiftness"] = 13,
		["Heart of the Wild"] = 14,
		["Leader of the Pack"] = 15,
		["Faerie Fire (Feral)"] = 16,
			},
			{--Restoration
		["Improved Mark of the Wild"] = 1,
		["Furor"] = 2,
		["Nature's Focus"] = 3,
		["Improved Healing Touch"] = 4,
		["Improved Regrowth"] = 5,
		["Improved Enrage"] = 6,
		["Insect Swarm"] = 7,
		["Gift of Nature"] = 8,
		["Reflection"] = 9,
		["Improved Rejuvenation"] = 10,
		["Nature's Swiftness"] = 11,
		["Subtlety"] = 12,
		["Improved Tranquility"] = 13,
		["Tranquil Spirit"] = 14,
		["Swiftmend"] = 15,
			}
	},
	HUNTER = {
			{--Beast Mastery
		["Improved Aspect of the Monkey"] = 1,
		["Improved Aspect of the Hawk"] = 2,
		["Pathfinding"] = 3,
		["Improved Mend Pet"] = 4,
		["Bestial Wrath"] = 5,
		["Intimidation"] = 6,
		["Spirit Bond"] = 7,
		["Endurance Training"] = 8,
		["Bestial Discipline"] = 9,
		["Bestial Swiftness"] = 10,
		["Ferocity"] = 11,
		["Thick Hide"] = 12,
		["Unleashed Fury"] = 13,
		["Frenzy"] = 14,
		["Improved Eyes of the Beast"] = 15,
		["Improved Revive Pet"] = 16,
			},
			{--Marksmanship
		["Improved Concussive Shot"] = 1,
		["Efficiency"] = 2,
		["Improved Hunter's Mark"] = 3,
		["Lethal Shots"] = 4,
		["Aimed Shot"] = 5,
		["Improved Arcane Shot"] = 6,
		["Barrage"] = 7,
		["Improved Serpent Sting"] = 8,
		["Mortal Shots"] = 9,
		["Improved Scorpid Sting"] = 10,
		["Hawk Eye"] = 11,
		["Scatter Shot"] = 12,
		["Trueshot Aura"] = 13,
		["Ranged Weapon Specialization"] = 14,
			},
			{--Survival
		["Humanoid Slaying"] = 1,
		["Lightning Reflexes"] = 2,
		["Entrapment"] = 3,
		["Improved Wing Clip"] = 4,
		["Clever Traps"] = 5,
		["Deterrence"] = 6,
		["Improved Feign Death"] = 7,
		["Surefooted"] = 8,
		["Deflection"] = 9,
		["Counterattack"] = 10,
		["Killer Instinct"] = 11,
		["Trap Mastery"] = 12,
		["Wyvern Sting"] = 13,
		["Savage Strikes"] = 14,
		["Survivalist"] = 15,
		["Monster Slaying"] = 16,
			}
	},
	MAGE = {
			{--Arcane
		["Arcane Subtlety"] = 1,
		["Arcane Concentration"] = 2,
		["Arcane Focus"] = 3,
		["Arcane Mind"] = 4,
		["Wand Specialization"] = 5,
		["Improved Arcane Missiles"] = 6,
		["Improved Arcane Explosion"] = 7,
		["Magic Attunement"] = 8,
		["Improved Mana Shield"] = 9,
		["Arcane Resilience"] = 10,
		["Presence of Mind"] = 11,
		["Arcane Power"] = 12,
		["Improved Counterspell"] = 13,
		["Arcane Instability"] = 14,
		["Arcane Meditation"] = 15,
		["Magic Absorption"] = 16,
			},
			{--Fire
		["Burning Soul"] = 1,
		["Improved Fire Ward"] = 2,
		["Improved Scorch"] = 3,
		["Improved Fireball"] = 4,
		["Improved Fire Blast"] = 5,
		["Flame Throwing"] = 6,
		["Pyroblast"] = 7,
		["Impact"] = 8,
		["Improved Flamestrike"] = 9,
		["Blast Wave"] = 10,
		["Critical Mass"] = 11,
		["Ignite"] = 12,
		["Fire Power"] = 13,
		["Combustion"] = 14,
		["Incinerate"] = 15,
		["Master of Elements"] = 16,
			},
			{--Frost
		["Improved Frostbolt"] = 1,
		["Frostbite"] = 2,
		["Piercing Ice"] = 3,
		["Improved Frost Nova"] = 4,
		["Improved Blizzard"] = 5,
		["Improved Cone of Cold"] = 6,
		["Permafrost"] = 7,
		["Frost Channeling"] = 8,
		["Shatter"] = 9,
		["Winter's Chill"] = 10,
		["Cold Snap"] = 11,
		["Frost Warding"] = 12,
		["Ice Barrier"] = 13,
		["Ice Block"] = 14,
		["Ice Shards"] = 15,
		["Arctic Reach"] = 16,
		["Elemental Precision"] = 17,
			},
	},
	PALADIN = {
			{--Holy
		["Spiritual Focus"] = 1,
		["Divine Favor"] = 2,
		["Consecration"] = 3,
		["Improved Lay on Hands"] = 4,
		["Healing Light"] = 5,
		["Improved Blessing of Wisdom"] = 6,
		["Divine Intellect"] = 7,
		["Divine Strength"] = 8,
		["Illumination"] = 9,
		["Improved Seal of Righteousness"] = 10,
		["Lasting Judgement"] = 11,
		["Holy Shock"] = 12,
		["Holy Power"] = 13,
		["Unyielding Faith"] = 14,
			},
			{--Protection
		["Redoubt"] = 1,
		["Improved Devotion Aura"] = 2,
		["Toughness"] = 3,
		["Shield Specialization"] = 4,
		["Guardian's Favor"] = 5,
		["Reckoning"] = 6,
		["One-Handed Weapon Specialization"] = 7,
		["Holy Shield"] = 8,
		["Blessing of Sanctuary"] = 9,
		["Blessing of Kings"] = 10,
		["Improved Righteous Fury"] = 11,
		["Improved Hammer of Justice"] = 12,
		["Improved Concentration Aura"] = 13,
		["Anticipation"] = 14,
		["Precision"] = 15,
			},
			{--Retribution
		["Improved Blessing of Might"] = 1,
		["Vengeance"] = 2,
		["Deflection"] = 3,
		["Improved Retribution Aura"] = 4,
		["Benediction"] = 5,
		["Sanctity Aura"] = 6,
		["Two-Handed Weapon Specialization"] = 7,
		["Conviction"] = 8,
		["Repentance"] = 9,
		["Improved Seal of the Crusader"] = 10,
		["Seal of Command"] = 11,
		["Improved Judgement"] = 12,
		["Eye for an Eye"] = 13,
		["Vindication"] = 14,
		["Pursuit of Justice"] = 15,
			}
	},
	PRIEST = {
			{--Discipline
		["Martyrdom"] = 1,
		["Power Infusion"] = 2,
		["Mental Agility"] = 3,
		["Unbreakable Will"] = 4,
		["Improved Power Word: Shield"] = 5,
		["Improved Power Word: Fortitude"] = 6,
		["Wand Specialization"] = 7,
		["Improved Inner Fire"] = 8,
		["Meditation"] = 9,
		["Inner Focus"] = 10,
		["Improved Mana Burn"] = 11,
		["Divine Spirit"] = 12,
		["Silent Resolve"] = 13,
		["Mental Strength"] = 14,
		["Force of Will"] = 15,
			},
			{--Holy
		["Inspiration"] = 1,
		["Holy Specialization"] = 2,
		["Spiritual Guidance"] = 3,
		["Searing Light"] = 4,
		["Spiritual Healing"] = 5,
		["Improved Renew"] = 6,
		["Improved Healing"] = 7,
		["Healing Focus"] = 8,
		["Spell Warding"] = 9,
		["Improved Prayer of Healing"] = 10,
		["Holy Nova"] = 11,
		["Divine Fury"] = 12,
		["Spirit of Redemption"] = 13,
		["Holy Reach"] = 14,
		["Blessed Recovery"] = 15,
		["Lightwell"] = 16,
			},
			{--Shadow
		["Shadow Weaving"] = 1,
		["Darkness"] = 2,
		["Shadow Focus"] = 3,
		["Blackout"] = 4,
		["Spirit Tap"] = 5,
		["Shadow Affinity"] = 6,
		["Improved Mind Blast"] = 7,
		["Improved Shadow Word: Pain"] = 8,
		["Improved Fade"] = 9,
		["Vampiric Embrace"] = 10,
		["Mind Flay"] = 11,
		["Shadowform"] = 12,
		["Silence"] = 13,
		["Improved Psychic Scream"] = 14,
		["Shadow Reach"] = 15,
		["Improved Vampiric Embrace"] = 16,
			}
	},
	ROGUE = {
			{--Assassination
		["Improved Poisons"] = 1,
		["Lethality"] = 2,
		["Malice"] = 3,
		["Remorseless Attacks"] = 4,
		["Ruthlessness"] = 5,
		["Murder"] = 6,
		["Improved Eviscerate"] = 7,
		["Improved Slice and Dice"] = 8,
		["Improved Expose Armor"] = 9,
		["Improved Kidney Shot"] = 10,
		["Cold Blood"] = 11,
		["Relentless Strikes"] = 12,
		["Seal Fate"] = 13,
		["Vigor"] = 14,
		["Vile Poisons"] = 15,
			},
			{--Combat
		["Precision"] = 1,
		["Dagger Specialization"] = 2,
		["Fist Weapon Specialization"] = 3,
		["Mace Specialization"] = 4,
		["Lightning Reflexes"] = 5,
		["Deflection"] = 6,
		["Improved Sinister Strike"] = 7,
		["Improved Backstab"] = 8,
		["Improved Gouge"] = 9,
		["Endurance"] = 10,
		["Adrenaline Rush"] = 11,
		["Improved Kick"] = 12,
		["Dual Wield Specialization"] = 13,
		["Improved Sprint"] = 14,
		["Blade Flurry"] = 15,
		["Sword Specialization"] = 16,
		["Riposte"] = 17,
		["Aggression"] = 18,
		["Weapon Expertise"] = 19,
			},
			{--Subtlety
		["Master of Deception"] = 1,
		["Camouflage"] = 2,
		["Initiative"] = 3,
		["Setup"] = 4,
		["Elusiveness"] = 5,
		["Opportunity"] = 6,
		["Improved Sap"] = 7,
		["Improved Ambush"] = 8,
		["Dirty Deeds"] = 9,
		["Preparation"] = 10,
		["Ghostly Strike"] = 11,
		["Premeditation"] = 12,
		["Hemorrhage"] = 13,
		["Serrated Blades"] = 14,
		["Sleight of Hand"] = 15,
		["Heightened Senses"] = 16,
		["Deadliness"] = 17,
			}
	},
		
	SHAMAN = {
			{--Elemental
		["Call of Flame"] = 1,
		["Call of Thunder"] = 2,
		["Concussion"] = 3,
		["Convection"] = 4,
		["Elemental Fury"] = 5,
		["Improved Fire Totems"] = 6,
		["Earth's Grasp"] = 7,
		["Elemental Mastery"] = 8,
		["Elemental Focus"] = 9,
		["Reverberation"] = 10,
		["Lightning Mastery"] = 11,
		["Elemental Warding"] = 12,
		["Storm Reach"] = 13,
		["Eye of the Storm"] = 14,
		["Elemental Devastation"] = 15,
			},
			{--Enhancement
		["Anticipation"] = 1,
		["Flurry"] = 2,
		["Improved Ghost Wolf"] = 3,
		["Improved Lightning Shield"] = 4,
		["Guardian Totems"] = 5,
		["Enhancing Totems"] = 6,
		["Elemental Weapons"] = 7,
		["Shield Specialization"] = 8,
		["Thundering Strikes"] = 9,
		["Ancestral Knowledge"] = 10,
		["Toughness"] = 11,
		["Parry"] = 12,
		["Two-Handed Axes and Maces"] = 13,
		["Stormstrike"] = 14,
		["Weapon Mastery"] = 15,
		["Improved Weapon Totems"] = 16,
			},
			{--Restoration
		["Ancestral Healing"] = 1,
		["Totemic Mastery"] = 2,
		["Nature's Guidance"] = 3,
		["Improved Healing Wave"] = 4,
		["Healing Focus"] = 5,
		["Restorative Totems"] = 6,
		["Improved Reincarnation"] = 7,
		["Mana Tide Totem"] = 8,
		["Nature's Swiftness"] = 9,
		["Purification"] = 10,
		["Tidal Focus"] = 11,
		["Tidal Mastery"] = 12,
		["Totemic Focus"] = 13,
		["Healing Grace"] = 14,
		["Healing Way"] = 15,
			}
	},
	WARLOCK = {
			{--Affliction
		["Fel Concentration"] = 1,
		["Nightfall"] = 2,
		["Improved Corruption"] = 3,
		["Improved Drain Life"] = 4,
		["Suppression"] = 5,
		["Improved Curse of Weakness"] = 6,
		["Improved Life Tap"] = 7,
		["Grim Reach"] = 8,
		["Dark Pact"] = 9,
		["Siphon Life"] = 10,
		["Shadow Mastery"] = 11,
		["Amplify Curse"] = 12,
		["Curse of Exhaustion"] = 13,
		["Improved Curse of Exhaustion"] = 14,
		["Improved Drain Soul"] = 15,
		["Improved Drain Mana"] = 16,
		["Improved Curse of Agony"] = 17,
			},
			{--Demonology
		["Improved Healthstone"] = 1,
		["Improved Imp"] = 2,
		["Demonic Embrace"] = 3,
		["Improved Health Funnel"] = 4,
		["Improved Voidwalker"] = 5,
		["Fel Domination"] = 6,
		["Master Summoner"] = 7,
		["Fel Stamina"] = 8,
		["Fel Intellect"] = 9,
		["Improved Sayaad"] = 10,
		["Master Demonologist"] = 11,
		["Improved Firestone"] = 12,
		["Unholy Power"] = 13,
		["Improved Spellstone"] = 14,
		["Demonic Sacrifice"] = 15,
		["Soul Link"] = 16,
		["Improved Subjugate Demon"] = 17,
			},
			{--Destruction
		["Cataclysm"] = 1,
		["Bane"] = 2,
		["Improved Shadow Bolt"] = 3,
		["Improved Immolate"] = 4,
		["Shadowburn"] = 5,
		["Destructive Reach"] = 6,
		["Improved Searing Pain"] = 7,
		["Emberstorm"] = 8,
		["Ruin"] = 9,
		["Conflagrate"] = 10,
		["Devastation"] = 11,
		["Aftermath"] = 12,
		["Improved Firebolt"] = 13,
		["Improved Lash of Pain"] = 14,
		["Intensity"] = 15,
		["Pyroclasm"] = 16,
			}
	},
    WARRIOR = {
            { -- Arms
		["Deep Wounds"] = 1,
		["Sword Specialization"] = 2,
		["Improved Heroic Strike"] = 3,
		["Mace Specialization"] = 4,
		["Improved Charge"] = 5,
		["Improved Rend"] = 6,
		["Improved Thunder Clap"] = 7,
		["Improved Hamstring"] = 8,
		["Deflection"] = 9,
		["Improved Overpower"] = 10,
		["Axe Specialization"] = 11,
		["Sweeping Strikes"] = 12,
		["Polearm Specialization"] = 13,
		["Mortal Strike"] = 14,
		["Two-Handed Weapon Specialization"] = 15,
		["Anger Management"] = 16,
		["Tactical Mastery"] = 17,
		["Impale"] = 18,
           },
           { --Fury
		["Improved Battle Shout"] = 1,
		["Enrage"] = 2,
		["Flurry"] = 3,
		["Cruelty"] = 4,
		["Booming Voice"] = 5,
		["Unbridled Wrath"] = 6,
		["Piercing Howl"] = 7,
		["Improved Demoralizing Shout"] = 8,
		["Death Wish"] = 9,
		["Improved Cleave"] = 10,
		["Bloodthirst"] = 11,
		["Improved Slam"] = 12,
		["Blood Craze"] = 13,
		["Improved Berserker Rage"] = 14,
		["Improved Execute"] = 15,
		["Improved Intercept"] = 16,
		["Dual Wield Specialization"] = 17,
           },
            { --Protection
		["Anticipation"] = 1,
		["Toughness"] = 2,
		["Iron Will"] = 3,
		["Improved Bloodrage"] = 4,
		["Improved Taunt"] = 5,
		["Defiance"] = 6,
		["Improved Shield Block"] = 7,
		["Improved Sunder Armor"] = 8,
		["Improved Revenge"] = 9,
		["Shield Slam"] = 10,
		["Improved Shield Bash"] = 11,
		["Improved Shield Wall"] = 12,
		["Improved Disarm"] = 13,
		["Concussion Blow"] = 14,
		["Last Stand"] = 15,
		["One-Handed Weapon Specialization"] = 16,
		["Shield Specialization"] = 17,
           }
    },


}


DGV.TalentTemplates = {

    DRUID = {
	["Feral Leveling 10-40"] = {
		order = 1,
		["Ferocity"] = 5, --132190
		["Feral Aggression"] = 5, --132121
		--["Feral Instinct"] = 3, --132089
		--["Brutal Impact"] = 4, --132114
		--["Thick Hide"] = 5, --134355
		["Feline Swiftness"] = 2, --136095
		["Feral Charge"] = 1, --132183
		["Sharpened Claws"] = 3, --134297
		["Improved Shred"] = 2, --136231
		["Predatory Strikes"] = 3, --132185
		["Blood Frenzy"] = 2, --132152
		--["Primal Fury"] = 12, --132278
		["Savage Fury"] = 2, --132141
		["Faerie Fire (Feral)"] = 1, --136033
		["Heart of the Wild"] = 5, --135879
		["Leader of the Pack"] = 1, --136112
    },
	["Feral Leveling 40-60"] = {
		order = 2,
		["Ferocity"] = 5, --132190
		["Feral Aggression"] = 5, --132121
		--["Feral Instinct"] = 3, --132089
		--["Brutal Impact"] = 4, --132114
		--["Thick Hide"] = 5, --134355
		["Feline Swiftness"] = 2, --136095
		["Feral Charge"] = 1, --132183
		["Sharpened Claws"] = 3, --134297
		["Improved Shred"] = 2, --136231
		["Predatory Strikes"] = 3, --132185
		["Blood Frenzy"] = 2, --132152
		--["Primal Fury"] = 12, --132278
		["Savage Fury"] = 2, --132141
		["Faerie Fire (Feral)"] = 1, --136033
		["Heart of the Wild"] = 5, --135879
		["Leader of the Pack"] = 1, --136112
		--["Improved Wrath"] = 1, --136006
		["Nature's Grasp"] = 1, --136063
		["Improved Nature's Grasp"] = 4, --136063
		["Improved Entangling Roots"] = 4, --136100
		--["Improved Moonfire"] = 5, --136096
		["Natural Weapons"] = 5, --135138
		["Natural Shapeshifter"] = 3, --136116
		--["Improved Thorns"] = 8, --136104
		["Omen of Clarity"] = 1, --136017
		--["Nature's Reach"] = 10, --136065				
		["Furor"] = 5, --135881
    },	
	["Balance Leveling 10-40"] = {
		order = 3,
		["Improved Wrath"] = 5, --136006
		["Nature's Grasp"] = 1, --136063
		--["Improved Nature's Grasp"] = 3, --136063
		["Improved Entangling Roots"] = 3, --136100
		["Improved Moonfire"] = 5, --136096
		--["Natural Weapons"] = 6, --135138
		--["Natural Shapeshifter"] = 7, --136116
		--["Improved Thorns"] = 8, --136104
		--["Omen of Clarity"] = 9, --136017
		["Nature's Reach"] = 2, --136065
		["Vengeance"] = 5, --136075
		["Improved Starfire"] = 5, --135753
		["Nature's Grace"] = 1, --136062
		["Moonglow"] = 3, --136087
		["Moonfury"] = 5, --136057
		["Moonkin Form"] = 1, --136036	
	},
	["Balance Leveling 40-60"] = {
		order = 4,
		["Improved Wrath"] = 5, --136006
		["Nature's Grasp"] = 1, --136063
		--["Improved Nature's Grasp"] = 3, --136063
		["Improved Entangling Roots"] = 3, --136100
		["Improved Moonfire"] = 5, --136096
		--["Natural Weapons"] = 6, --135138
		--["Natural Shapeshifter"] = 7, --136116
		--["Improved Thorns"] = 8, --136104
		--["Omen of Clarity"] = 9, --136017
		["Nature's Reach"] = 2, --136065
		["Vengeance"] = 5, --136075
		["Improved Starfire"] = 5, --135753
		["Nature's Grace"] = 1, --136062
		["Moonglow"] = 3, --136087
		["Moonfury"] = 5, --136057
		["Moonkin Form"] = 1, --136036		
		["Improved Mark of the Wild"] = 5, --136078
		--["Furor"] = 2, --135881
		["Improved Healing Touch"] = 5, --136041
		["Nature's Focus"] = 1, --136042
		--["Improved Enrage"] = 5, --132126
		["Reflection"] = 3, --135863
		["Insect Swarm"] = 1, --136045
	},	
	["Restoration Leveling 10-40"] = {
		order = 5,
		["Improved Mark of the Wild"] = 5, --136078
		--["Furor"] = 2, --135881
		["Improved Healing Touch"] = 5, --136041
		--["Nature's Focus"] = 4, --136042
		--["Improved Enrage"] = 5, --132126
		["Reflection"] = 3, --135863
		["Insect Swarm"] = 1, --136045
		["Subtlety"] = 1, --132150
		["Tranquil Spirit"] = 5, --135900
		--["Improved Rejuvenation"] = 10, --136081
		["Nature's Swiftness"] = 1, --136076
		["Gift of Nature"] = 5, --136074
		--["Improved Tranquility"] = 13, --136107
		["Improved Regrowth"] = 5, --136085
		["Swiftmend"] = 1, --134914	
	},
	["Restoration Leveling 40-60"] = {
		order = 6,
		["Improved Mark of the Wild"] = 5, --136078
		--["Furor"] = 2, --135881
		["Improved Healing Touch"] = 5, --136041
		--["Nature's Focus"] = 4, --136042
		--["Improved Enrage"] = 5, --132126
		["Reflection"] = 3, --135863
		["Insect Swarm"] = 1, --136045
		["Subtlety"] = 1, --132150
		["Tranquil Spirit"] = 5, --135900
		--["Improved Rejuvenation"] = 10, --136081
		["Nature's Swiftness"] = 1, --136076
		["Gift of Nature"] = 5, --136074
		--["Improved Tranquility"] = 13, --136107
		["Improved Regrowth"] = 5, --136085
		["Swiftmend"] = 1, --134914	
		["Improved Wrath"] = 5, --136006
		["Nature's Grasp"] = 1, --136063
		--["Improved Nature's Grasp"] = 3, --136063
		--["Improved Entangling Roots"] = 4, --136100
		["Improved Moonfire"] = 5, --136096
		--["Natural Weapons"] = 6, --135138
		--["Natural Shapeshifter"] = 2, --136116
		--["Improved Thorns"] = 8, --136104
		--["Omen of Clarity"] = 9, --136017
		["Nature's Reach"] = 2, --136065
		["Vengeance"] = 4, --136075
	},
	},
    HUNTER = {
	["Beast Mastery Leveling 10-40"] = {
		order = 1,
		["Improved Aspect of the Hawk"] = 5, --136076
		--["Endurance Training"] = 2, --136080
		--["Improved Eyes of the Beast"] = 3, --132150
		--["Improved Aspect of the Monkey"] = 4, --132159
		["Thick Hide"] = 3, --134355
		["Improved Revive Pet"] = 2, --132163
		["Pathfinding"] = 2, --132242
		["Bestial Swiftness"] = 1, --132120
		["Unleashed Fury"] = 5, --132091
		--["Improved Mend Pet"] = 10, --132179
		["Ferocity"] = 5, --134297
		--["Spirit Bond"] = 12, --132121
		["Intimidation"] = 1, --132111
		["Bestial Discipline"] = 1, --136006
		["Frenzy"] = 5, --134296
		["Bestial Wrath"] = 1, --132127	
	},
	["Beast Mastery Leveling 40-60"] = {
		order = 2,
		["Improved Aspect of the Hawk"] = 5, --136076
		--["Endurance Training"] = 2, --136080
		--["Improved Eyes of the Beast"] = 3, --132150
		--["Improved Aspect of the Monkey"] = 4, --132159
		["Thick Hide"] = 3, --134355
		["Improved Revive Pet"] = 2, --132163
		["Pathfinding"] = 2, --132242
		["Bestial Swiftness"] = 1, --132120
		["Unleashed Fury"] = 5, --132091
		--["Improved Mend Pet"] = 10, --132179
		["Ferocity"] = 5, --134297
		--["Spirit Bond"] = 12, --132121
		["Intimidation"] = 1, --132111
		["Bestial Discipline"] = 1, --136006
		["Frenzy"] = 5, --134296
		["Bestial Wrath"] = 1, --132127	
		["Improved Concussive Shot"] = 5, --135860
		["Efficiency"] = 1, --135865
		--["Improved Hunter's Mark"] = 3, --132212
		["Lethal Shots"] = 5, --132312
		["Aimed Shot"] = 1, --135130
		--["Improved Arcane Shot"] = 6, --132218
		["Hawk Eye"] = 3, --132327
		--["Improved Serpent Sting"] = 8, --132204
		["Mortal Shots"] = 5, --132271
	},	
	["Marksmanship Leveling 10-40"] = {
		order = 3,
		--["Improved Concussive Shot"] = 1, --135860
		["Efficiency"] = 5, --135865
		["Improved Hunter's Mark"] = 1, --132212
		["Lethal Shots"] = 5, --132312
		["Aimed Shot"] = 1, --135130
		--["Improved Arcane Shot"] = 6, --132218
		["Hawk Eye"] = 3, --132327
		["Improved Serpent Sting"] = 1, --132204
		["Mortal Shots"] = 5, --132271
		["Scatter Shot"] = 1, --132153
		["Barrage"] = 3, --132330
		--["Improved Scorpid Sting"] = 12, --132169
		["Ranged Weapon Specialization"] = 5, --135615
		["Trueshot Aura"] = 1, --132329
	},	
	["Marksmanship Leveling 40-60"] = {
		order = 4,
		--["Improved Concussive Shot"] = 1, --135860
		["Efficiency"] = 5, --135865
		["Improved Hunter's Mark"] = 1, --132212
		["Lethal Shots"] = 5, --132312
		["Aimed Shot"] = 1, --135130
		--["Improved Arcane Shot"] = 6, --132218
		["Hawk Eye"] = 3, --132327
		["Improved Serpent Sting"] = 1, --132204
		["Mortal Shots"] = 5, --132271
		["Scatter Shot"] = 1, --132153
		["Barrage"] = 3, --132330
		--["Improved Scorpid Sting"] = 12, --132169
		["Ranged Weapon Specialization"] = 5, --135615
		["Trueshot Aura"] = 1, --132329
		["Improved Aspect of the Hawk"] = 5, --136076
		--["Endurance Training"] = 2, --136080
		--["Improved Eyes of the Beast"] = 3, --132150
		--["Improved Aspect of the Monkey"] = 4, --132159
		["Thick Hide"] = 3, --134355
		["Improved Revive Pet"] = 2, --132163
		["Pathfinding"] = 2, --132242
		["Bestial Swiftness"] = 1, --132120
		["Unleashed Fury"] = 3, --132091
	},		
	["Survival Leveling 10-40"] = {
		order = 5,
		["Monster Slaying"] = 3, --134154
		["Humanoid Slaying"] = 3, --135942
		--["Deflection"] = 3, --132269
		--["Entrapment"] = 4, --136100
		["Savage Strikes"] = 2, --132277
		["Improved Wing Clip"] = 5, --132309
		--["Clever Traps"] = 7, --136106
		["Survivalist"] = 2, --136223
		["Deterrence"] = 5, --132369
		--["Trap Mastery"] = 10, --132149
		["Surefooted"] = 3, --132219
		["Improved Feign Death"] = 2, --132293
		["Killer Instinct"] = 3, --135881
		["Counterattack"] = 1, --132336
		["Lightning Reflexes"] = 5, --136047
		["Wyvern Sting"] = 1, --135125	
	},	
	["Survival Leveling 40-60"] = {
		order = 6,
		["Monster Slaying"] = 3, --134154
		["Humanoid Slaying"] = 3, --135942
		--["Deflection"] = 3, --132269
		--["Entrapment"] = 4, --136100
		["Savage Strikes"] = 2, --132277
		["Improved Wing Clip"] = 5, --132309
		--["Clever Traps"] = 7, --136106
		["Survivalist"] = 2, --136223
		["Deterrence"] = 5, --132369
		--["Trap Mastery"] = 10, --132149
		["Surefooted"] = 3, --132219
		["Improved Feign Death"] = 2, --132293
		["Killer Instinct"] = 3, --135881
		["Counterattack"] = 1, --132336
		["Lightning Reflexes"] = 5, --136047
		["Wyvern Sting"] = 1, --135125	
		--["Improved Concussive Shot"] = 1, --135860
		["Efficiency"] = 5, --135865
		---["Improved Hunter's Mark"] = 1, --132212
		["Lethal Shots"] = 5, --132312
		["Aimed Shot"] = 1, --135130
		--["Improved Arcane Shot"] = 6, --132218
		["Hawk Eye"] = 3, --132327
		["Improved Aspect of the Hawk"] = 5, --136076
		["Improved Revive Pet"] = 1, --132163
	},		
    },
    MAGE = {
	["Frost Leveling 10-40"] = {
		order = 1,
		--["Frost Warding"] = 1, --135850
		["Improved Frostbolt"] = 5, --135846
		["Elemental Precision"] = 3, --135989
		["Ice Shards"] = 2, --135855
		["Frostbite"] = 3, --135842
		["Improved Frost Nova"] = 2, --135840
		--["Permafrost"] = 7, --135864
		["Piercing Ice"] = 3, --135845
		["Cold Snap"] = 1, --135865
		--["Improved Blizzard"] = 10, --135857
		["Arctic Reach"] = 2, --136141
		["Frost Channeling"] = 3, --135860
		["Shatter"] = 5, --135849
		["Ice Block"] = 1, --135841
		--["Improved Cone of Cold"] = 15, --135852
		--["Winter's Chill"] = 16, --135836
		["Ice Barrier"] = 1, --135988	
	},
	["Frost Leveling 40-60"] = {
		order = 2,
		--["Frost Warding"] = 1, --135850
		["Improved Frostbolt"] = 5, --135846
		["Elemental Precision"] = 3, --135989
		["Ice Shards"] = 5, --135855
		["Frostbite"] = 3, --135842
		["Improved Frost Nova"] = 2, --135840
		--["Permafrost"] = 7, --135864
		["Piercing Ice"] = 3, --135845
		["Cold Snap"] = 1, --135865
		--["Improved Blizzard"] = 10, --135857
		["Arctic Reach"] = 2, --136141
		["Frost Channeling"] = 3, --135860
		["Shatter"] = 5, --135849
		["Ice Block"] = 1, --135841
		--["Improved Cone of Cold"] = 15, --135852
		--["Winter's Chill"] = 16, --135836
		["Ice Barrier"] = 1, --135988	
		["Arcane Subtlety"] = 2, --135894
		["Arcane Focus"] = 3, --135892
		--["Improved Arcane Missiles"] = 3, --136096
		["Wand Specialization"] = 2, --135463
		--["Magic Absorption"] = 5, --136011
		--["Arcane Concentration"] = 5, --136170
		--["Magic Attunement"] = 7, --136006
		["Improved Arcane Explosion"] = 2, --136116
		["Arcane Resilience"] = 1, --135733
		--["Improved Mana Shield"] = 10, --136153
		--["Improved Counterspell"] = 11, --135856
		["Arcane Meditation"] = 2, --136208
	},	
	["Fire Leveling 10-40"] = {
		order = 3,
		["Improved Fireball"] = 5, --135812
		["Impact"] = 5, --135821
		["Ignite"] = 5, --135818
		["Flame Throwing"] = 1, --135815
		--["Improved Fire Blast"] = 5, --135807
		["Incinerate"] = 2, --135813
		--["Improved Flamestrike"] = 7, --135826
		["Pyroblast"] = 1, --135808
		["Burning Soul"] = 2, --135805
		--["Improved Scorch"] = 10, --135827
		--["Improved Fire Ward"] = 11, --135806
		--["Master of Elements"] = 12, --135820
		["Critical Mass"] = 3, --136115
		["Blast Wave"] = 1, --135903
		["Fire Power"] = 5, --135817
		["Combustion"] = 1, --135824
	},	
	["Fire Leveling 40-60"] = {
		order = 4,
		["Improved Fireball"] = 5, --135812
		["Impact"] = 5, --135821
		["Ignite"] = 5, --135818
		["Flame Throwing"] = 1, --135815
		--["Improved Fire Blast"] = 5, --135807
		["Incinerate"] = 2, --135813
		--["Improved Flamestrike"] = 7, --135826
		["Pyroblast"] = 1, --135808
		["Burning Soul"] = 2, --135805
		["Improved Scorch"] = 3, --135827
		--["Improved Fire Ward"] = 11, --135806
		["Master of Elements"] = 3, --135820
		["Critical Mass"] = 3, --136115
		["Blast Wave"] = 1, --135903
		["Fire Power"] = 5, --135817
		["Combustion"] = 1, --135824
		["Arcane Subtlety"] = 2, --135894
		["Arcane Focus"] = 3, --135892
		--["Improved Arcane Missiles"] = 3, --136096
		--["Wand Specialization"] = 4, --135463
		--["Magic Absorption"] = 5, --136011
		["Arcane Concentration"] = 5, --136170
		--["Magic Attunement"] = 7, --136006
		--["Improved Arcane Explosion"] = 8, --136116
		["Arcane Resilience"] = 1, --135733
		["Elemental Precision"] = 3, --135989
	},	
	["Arcane Leveling 10-40"] = {
		order = 5,
		--["Arcane Subtlety"] = 1, --135894
		["Arcane Focus"] = 2, --135892
		["Improved Arcane Missiles"] = 5, --136096
		["Wand Specialization"] = 2, --135463
		--["Magic Absorption"] = 5, --136011
		["Arcane Concentration"] = 5, --136170
		--["Magic Attunement"] = 7, --136006
		["Improved Arcane Explosion"] = 3, --136116
		["Arcane Resilience"] = 1, --135733
		--["Improved Mana Shield"] = 10, --136153
		--["Improved Counterspell"] = 11, --135856
		["Arcane Meditation"] = 3, --136208
		["Presence of Mind"] = 1, --136031
		["Arcane Mind"] = 5, --136129
		["Arcane Instability"] = 3, --136222
		["Arcane Power"] = 1, --136048
	},		
	["Arcane Leveling 40-60"] = {
		order = 6,
		--["Arcane Subtlety"] = 1, --135894
		["Arcane Focus"] = 2, --135892
		["Improved Arcane Missiles"] = 5, --136096
		["Wand Specialization"] = 2, --135463
		--["Magic Absorption"] = 5, --136011
		["Arcane Concentration"] = 5, --136170
		--["Magic Attunement"] = 7, --136006
		["Improved Arcane Explosion"] = 3, --136116
		["Arcane Resilience"] = 1, --135733
		--["Improved Mana Shield"] = 10, --136153
		--["Improved Counterspell"] = 11, --135856
		["Arcane Meditation"] = 3, --136208
		["Presence of Mind"] = 1, --136031
		["Arcane Mind"] = 5, --136129
		["Arcane Instability"] = 3, --136222
		["Arcane Power"] = 1, --136048
		--["Frost Warding"] = 1, --135850
		["Improved Frostbolt"] = 5, --135846
		["Elemental Precision"] = 3, --135989
		["Ice Shards"] = 5, --135855
		--["Frostbite"] = 5, --135842
		--["Improved Frost Nova"] = 6, --135840
		--["Permafrost"] = 7, --135864
		["Piercing Ice"] = 3, --135845
		--["Cold Snap"] = 9, --135865
		--["Improved Blizzard"] = 10, --135857
		["Arctic Reach"] = 1, --136141
		["Frost Channeling"] = 3, --135860
	},			
    },
    PALADIN = {
	["Holy Leveling 10-40"] = {
			order = 1,
			--["Divine Strength"] = 1, --132154
			["Divine Intellect"] = 5, --136090
			["Spiritual Focus"] = 5, --135736
			--["Improved Seal of Righteousness"] = 4, --132325
			["Healing Light"] = 3, --135920
			["Consecration"] = 1, --135926
			["Improved Lay on Hands"] = 2, --135928
			--["Unyielding Faith"] = 8, --135984
			["Illumination"] = 5, --135913
			["Improved Blessing of Wisdom"] = 2, --135970
			["Divine Favor"] = 1, --135915
			["Lasting Judgement"] = 1, --135917
			["Holy Power"] = 5, --135938
			["Holy Shock"] = 1, --135972
		},
	["Holy Leveling 40-60"] = {
			order = 2,
			--["Divine Strength"] = 1, --132154
			["Divine Intellect"] = 5, --136090
			["Spiritual Focus"] = 5, --135736
			--["Improved Seal of Righteousness"] = 4, --132325
			["Healing Light"] = 3, --135920
			["Consecration"] = 1, --135926
			["Improved Lay on Hands"] = 2, --135928
			--["Unyielding Faith"] = 8, --135984
			["Illumination"] = 5, --135913
			["Improved Blessing of Wisdom"] = 2, --135970
			["Divine Favor"] = 1, --135915
			["Lasting Judgement"] = 2, --135917
			["Holy Power"] = 5, --135938
			["Holy Shock"] = 1, --135972
			["Improved Devotion Aura"] = 5, --135893
			["Guardian's Favor"] = 2, --135964
			["Improved Blessing of Might"] = 5, --135906
			["Benediction"] = 5, --135863
			--["Improved Judgement"] = 3, --135959
			--["Improved Seal of the Crusader"] = 4, --135924
			--["Deflection"] = 5, --132269
			--["Vindication"] = 6, --135985
			--["Conviction"] = 7, --135957
			--["Seal of Command"] = 8, --132347
			["Pursuit of Justice"] = 2, --135937			
		},		
	["Retribution Leveling 10-40"] = {
			order = 3,
			["Improved Blessing of Might"] = 1, --135906
			["Benediction"] = 5, --135863
			["Improved Judgement"] = 2, --135959
			--["Improved Seal of the Crusader"] = 4, --135924
			["Deflection"] = 5, --132269
			--["Vindication"] = 6, --135985
			["Conviction"] = 5, --135957
			["Seal of Command"] = 1, --132347
			["Pursuit of Justice"] = 2, --135937
			--["Eye for an Eye"] = 10, --135904
			--["Improved Retribution Aura"] = 11, --135873
			["Two-Handed Weapon Specialization"] = 5, --133041
			["Sanctity Aura"] = 1, --135934
			["Vengeance"] = 5, --132275
			["Repentance"] = 1, --135942
		},		
	["Retribution Leveling 40-60"] = {
			order = 4,
			["Improved Blessing of Might"] = 1, --135906
			["Benediction"] = 5, --135863
			["Improved Judgement"] = 2, --135959
			--["Improved Seal of the Crusader"] = 4, --135924
			["Deflection"] = 5, --132269
			--["Vindication"] = 6, --135985
			["Conviction"] = 5, --135957
			["Seal of Command"] = 1, --132347
			["Pursuit of Justice"] = 2, --135937
			--["Eye for an Eye"] = 10, --135904
			--["Improved Retribution Aura"] = 11, --135873
			["Two-Handed Weapon Specialization"] = 5, --133041
			["Sanctity Aura"] = 1, --135934
			["Vengeance"] = 5, --132275
			["Repentance"] = 1, --135942
			["Divine Strength"] = 5, --132154
			--["Divine Intellect"] = 2, --136090
			--["Spiritual Focus"] = 3, --135736
			["Improved Seal of Righteousness"] = 5, --132325
			["Healing Light"] = 3, --135920
			["Consecration"] = 1, --135926
			["Improved Lay on Hands"] = 2, --135928
		},			
	["Protection Leveling 10-40"] = {
			order = 5,
			--["Improved Devotion Aura"] = 1, --135893
			["Redoubt"] = 5, --132110
			["Precision"] = 3, --132282
			["Guardian's Favor"] = 2, --135964
			--["Toughness"] = 5, --135892
			["Blessing of Kings"] = 1, --135995
			--["Improved Righteous Fury"] = 7, --135962
			["Shield Specialization"] = 3, --134952
			["Anticipation"] = 1, --135994
			["Improved Hammer of Justice"] = 3, --135963
			["Improved Concentration Aura"] = 2, --135933
			["Blessing of Sanctuary"] = 1, --136051
			["Reckoning"] = 4, --135882
			["One-Handed Weapon Specialization"] = 5, --135321
			["Holy Shield"] = 1, --135880
		},		
	["Protection Leveling 40-60"] = {
			order = 6,
			--["Improved Devotion Aura"] = 1, --135893
			["Redoubt"] = 5, --132110
			["Precision"] = 3, --132282
			["Guardian's Favor"] = 2, --135964
			--["Toughness"] = 5, --135892
			["Blessing of Kings"] = 1, --135995
			--["Improved Righteous Fury"] = 7, --135962
			["Shield Specialization"] = 3, --134952
			["Anticipation"] = 1, --135994
			["Improved Hammer of Justice"] = 3, --135963
			["Improved Concentration Aura"] = 2, --135933
			["Blessing of Sanctuary"] = 1, --136051
			["Reckoning"] = 4, --135882
			["One-Handed Weapon Specialization"] = 5, --135321
			["Holy Shield"] = 1, --135880
			["Benediction"] = 5, --135863
			["Improved Judgement"] = 2, --135959		
			["Divine Strength"] = 5, --132154
			["Improved Seal of Righteousness"] = 5, --132325			
			["Consecration"] = 1, --135926
		},			
    },
    PRIEST = {
	["Discipline Leveling 10-40"] = {
		order = 1,
		--["Unbreakable Will"] = 1, --135995
		["Wand Specialization"] = 5, --135463
		--["Silent Resolve"] = 3, --136053
		["Improved Power Word: Fortitude"] = 2, --135987
		["Improved Power Word: Shield"] = 3, --135940
		["Martyrdom"] = 1, --136107
		["Inner Focus"] = 1, --135863
		["Meditation"] = 3, --136090
		--["Improved Inner Fire"] = 9, --135926
		["Mental Agility"] = 5, --132156
		--["Improved Mana Burn"] = 11, --136170
		["Mental Strength"] = 5, --136031
		["Divine Spirit"] = 1, --135898
		["Force of Will"] = 4, --136092
		["Power Infusion"] = 1, --135939
		},	
	["Discipline Leveling 40-60"] = {
		order = 2,
		--["Unbreakable Will"] = 1, --135995
		["Wand Specialization"] = 5, --135463
		--["Silent Resolve"] = 3, --136053
		["Improved Power Word: Fortitude"] = 2, --135987
		["Improved Power Word: Shield"] = 3, --135940
		["Martyrdom"] = 2, --136107
		["Inner Focus"] = 1, --135863
		["Meditation"] = 3, --136090
		--["Improved Inner Fire"] = 9, --135926
		["Mental Agility"] = 5, --132156
		--["Improved Mana Burn"] = 11, --136170
		["Mental Strength"] = 5, --136031
		["Divine Spirit"] = 1, --135898
		["Force of Will"] = 5, --136092
		["Power Infusion"] = 1, --135939
		["Healing Focus"] = 2, --135918
		--["Improved Renew"] = 2, --135953
		["Holy Specialization"] = 5, --135967
		["Spell Warding"] = 4, --135976
		["Divine Fury"] = 5, --135971
		["Holy Nova"] = 1, --135922		
		["Spirit Tap"] = 5, --136188
		},			
	["Holy Leveling 10-40"] = {
		order = 3,
		--["Unbreakable Will"] = 1, --135995
		["Wand Specialization"] = 5, --135463
		["Healing Focus"] = 2, --135918
		["Improved Renew"] = 3, --135953
		["Holy Specialization"] = 5, --135967
		--["Spell Warding"] = 4, --135976
		["Divine Fury"] = 5, --135971
		["Holy Nova"] = 1, --135922
		--["Blessed Recovery"] = 7, --135877
		--["Inspiration"] = 8, --135928
		["Holy Reach"] = 2, --135949
		--["Improved Healing"] = 10, --135916
		["Searing Light"] = 2, --135973
		},			
	["Holy Leveling 40-60"] = {
		order = 4,
		--["Unbreakable Will"] = 1, --135995
		["Wand Specialization"] = 5, --135463
		["Healing Focus"] = 2, --135918
		["Improved Renew"] = 3, --135953
		["Holy Specialization"] = 5, --135967
		--["Spell Warding"] = 4, --135976
		["Divine Fury"] = 5, --135971
		["Holy Nova"] = 1, --135922
		--["Blessed Recovery"] = 7, --135877
		--["Inspiration"] = 8, --135928
		["Holy Reach"] = 2, --135949
		["Improved Healing"] = 2, --135916
		["Searing Light"] = 2, --135973
		["Spirit Tap"] = 5, --136188
		--["Silent Resolve"] = 3, --136053
		["Improved Power Word: Fortitude"] = 2, --135987
		["Improved Power Word: Shield"] = 3, --135940
		--["Martyrdom"] = 6, --136107
		["Inner Focus"] = 1, --135863
		["Meditation"] = 3, --136090	
		--["Improved Prayer of Healing"] = 12, --135943
		["Spirit of Redemption"] = 13, --132864
		["Spiritual Guidance"] = 5, --135977
		["Spiritual Healing"] = 4, --136057		
		},	
	["Shadow Leveling 10-40"] = {
		order = 5,
		["Spirit Tap"] = 5, --136188
		["Blackout"] = 5, --136160
		--["Shadow Affinity"] = 3, --136205
		["Improved Shadow Word: Pain"] = 2, --136207
		["Shadow Focus"] = 2, --136126
		--["Improved Psychic Scream"] = 6, --136184
		["Improved Mind Blast"] = 4, --136224
		["Mind Flay"] = 1, --136208
		--["Improved Fade"] = 9, --135994
		["Shadow Reach"] = 3, --136130
		["Shadow Weaving"] = 2, --136123
		--["Silence"] = 12, --136164
		["Vampiric Embrace"] = 1, --136230
		--["Improved Vampiric Embrace"] = 14, --136165
		["Darkness"] = 5, --136223
		["Shadowform"] = 1, --136200
		},				
	["Shadow Leveling 40-60"] = {
		order = 6,
		["Spirit Tap"] = 5, --136188
		["Blackout"] = 5, --136160
		--["Shadow Affinity"] = 3, --136205
		["Improved Shadow Word: Pain"] = 2, --136207
		["Shadow Focus"] = 2, --136126
		["Improved Psychic Scream"] = 2, --136184
		["Improved Mind Blast"] = 4, --136224
		["Mind Flay"] = 1, --136208
		--["Improved Fade"] = 9, --135994
		["Shadow Reach"] = 3, --136130
		["Shadow Weaving"] = 5, --136123
		["Silence"] = 1, --136164
		["Vampiric Embrace"] = 1, --136230
		--["Improved Vampiric Embrace"] = 14, --136165
		["Darkness"] = 5, --136223
		["Shadowform"] = 1, --136200
		--["Unbreakable Will"] = 1, --135995
		["Wand Specialization"] = 5, --135463
		--["Silent Resolve"] = 3, --136053
		["Improved Power Word: Fortitude"] = 2, --135987
		["Improved Power Word: Shield"] = 3, --135940
		--["Martyrdom"] = 6, --136107
		["Inner Focus"] = 1, --135863
		["Meditation"] = 3, --136090	
		},		
    },
    ROGUE = {
	["Sword Leveling 10-40"] = {
			order = 1,
			["Improved Gouge"] = 3, --132155
			["Improved Sinister Strike"] = 3, --136189
			--["Lightning Reflexes"] = 3, --136047
			--["Improved Backstab"] = 4, --132090
			["Deflection"] = 5, --132269
			["Precision"] = 5, --132222
			["Endurance"] = 2, --136205
			["Riposte"] = 1, --132336
			["Improved Sprint"] = 1, --132307
			--["Improved Kick"] = 10, --132219
			--["Dagger Specialization"] = 11, --135641
			["Dual Wield Specialization"] = 5, --132147
			--["Mace Specialization"] = 13, --133476
			["Blade Flurry"] = 1, --132350
			--["Sword Specialization"] = 15, --135328
			--["Fist Weapon Specialization"] = 16, --132938
			["Weapon Expertise"] = 2, --135882
			["Aggression"] = 3, --132275
			["Adrenaline Rush"] = 1, --136206
		},
	["Sword Leveling 40-60"] = {
			order = 2,
			["Improved Gouge"] = 3, --132155
			["Improved Sinister Strike"] = 3, --136189
			--["Lightning Reflexes"] = 3, --136047
			--["Improved Backstab"] = 4, --132090
			["Deflection"] = 5, --132269
			["Precision"] = 5, --132222
			["Endurance"] = 2, --136205
			["Riposte"] = 1, --132336
			["Improved Sprint"] = 2, --132307
			--["Improved Kick"] = 10, --132219
			--["Dagger Specialization"] = 11, --135641
			["Dual Wield Specialization"] = 5, --132147
			--["Mace Specialization"] = 13, --133476
			["Blade Flurry"] = 1, --132350
			--["Sword Specialization"] = 15, --135328
			--["Fist Weapon Specialization"] = 16, --132938
			["Weapon Expertise"] = 2, --135882
			["Aggression"] = 3, --132275
			["Adrenaline Rush"] = 1, --136206
			["Improved Eviscerate"] = 1, --132292
			["Remorseless Attacks"] = 2, --132151
			["Malice"] = 5, --132277
			["Ruthlessness"] = 3, --132122
			["Murder"] = 2, --136147
			["Improved Slice and Dice"] = 3, --132306
			["Relentless Strikes"] = 1, --132340
			--["Improved Expose Armor"] = 8, --132354	
		},		
	["Dagger Leveling 10-40"] = {
			order = 3,
			["Improved Gouge"] = 3, --132155
			["Improved Sinister Strike"] = 3, --136189
			--["Lightning Reflexes"] = 3, --136047
			["Improved Backstab"] = 3, --132090
			--["Deflection"] = 5, --132269
			["Precision"] = 5, --132222
			["Endurance"] = 2, --136205
			--["Riposte"] = 1, --132336
			["Improved Sprint"] = 2, --132307
			--["Improved Kick"] = 10, --132219
			--["Dagger Specialization"] = 11, --135641
			["Dual Wield Specialization"] = 5, --132147
			--["Mace Specialization"] = 13, --133476
			["Blade Flurry"] = 1, --132350
			--["Sword Specialization"] = 15, --135328
			--["Fist Weapon Specialization"] = 16, --132938
			["Weapon Expertise"] = 2, --135882
			--["Aggression"] = 3, --132275
			["Adrenaline Rush"] = 1, --136206
		},	
	["Dagger Leveling 10-40"] = {
			order = 4,
			["Improved Gouge"] = 3, --132155
			["Improved Sinister Strike"] = 3, --136189
			--["Lightning Reflexes"] = 3, --136047
			["Improved Backstab"] = 3, --132090
			--["Deflection"] = 5, --132269
			["Precision"] = 5, --132222
			["Endurance"] = 2, --136205
			--["Riposte"] = 1, --132336
			["Improved Sprint"] = 2, --132307
			--["Improved Kick"] = 10, --132219
			--["Dagger Specialization"] = 11, --135641
			["Dual Wield Specialization"] = 5, --132147
			--["Mace Specialization"] = 13, --133476
			["Blade Flurry"] = 1, --132350
			--["Sword Specialization"] = 15, --135328
			--["Fist Weapon Specialization"] = 16, --132938
			["Weapon Expertise"] = 2, --135882
			--["Aggression"] = 3, --132275
			["Adrenaline Rush"] = 1, --136206
			["Opportunity"] = 5, --132366
			--["Improved Eviscerate"] = 1, --132292
			--["Remorseless Attacks"] = 2, --132151
			["Malice"] = 5, --132277
			--["Ruthlessness"] = 4, --132122
			["Murder"] = 2, --136147
			["Improved Slice and Dice"] = 3, --132306
			--["Relentless Strikes"] = 7, --132340
			--["Improved Expose Armor"] = 8, --132354
			["Lethality"] = 5, --132109		
		},			
    },
    SHAMAN = {
	["Enchancement Leveling 10-40"] = {
		order = 1,
		--["Ancestral Knowledge"] = 1, --136162
		["Shield Specialization"] = 5, --134952
		--["Guardian Totems"] = 3, --136098
		["Thundering Strikes"] = 5, --132325
		--["Improved Ghost Wolf"] = 5, --136095
		["Improved Lightning Shield"] = 3, --136051
		--["Enhancing Totems"] = 7, --136023
		["Two-Handed Axes and Maces"] = 1, --132401
		["Anticipation"] = 2, --136056
		["Flurry"] = 5, --132152
		--["Toughness"] = 11, --135892
		--["Improved Weapon Totems"] = 12, --135792
		["Elemental Weapons"] = 3, --135814
		["Parry"] = 1, --132269
		["Weapon Mastery"] = 5, --132215
		["Stormstrike"] = 1, --135963
	},
	["Enchancement Leveling 40-60"] = {
		order = 2,
		--["Ancestral Knowledge"] = 1, --136162
		["Shield Specialization"] = 5, --134952
		--["Guardian Totems"] = 3, --136098
		["Thundering Strikes"] = 5, --132325
		--["Improved Ghost Wolf"] = 5, --136095
		["Improved Lightning Shield"] = 3, --136051
		["Enhancing Totems"] = 2, --136023
		["Two-Handed Axes and Maces"] = 1, --132401
		["Anticipation"] = 5, --136056
		["Flurry"] = 5, --132152
		--["Toughness"] = 11, --135892
		["Improved Weapon Totems"] = 2, --135792
		["Elemental Weapons"] = 3, --135814
		["Parry"] = 1, --132269
		["Weapon Mastery"] = 5, --132215
		["Stormstrike"] = 1, --135963
		["Improved Healing Wave"] = 5, --136052
		--["Tidal Focus"] = 2, --135859
		["Improved Reincarnation"] = 3, --136080
		--["Ancestral Healing"] = 3, --136109
		["Totemic Focus"] = 3, --136057
		["Nature's Guidance"] = 3, --135860		
	},	
	["Elemental Leveling 10-40"] = {
		order = 3,
		["Convection"] = 5, --136116
		["Concussion"] = 5, --135807
		--["Earth's Grasp"] = 3, --136097
		--["Elemental Warding"] = 4, --136094
		["Call of Flame"] = 3, --135817
		["Elemental Focus"] = 1, --136170
		--["Reverberation"] = 7, --135850
		["Call of Thunder"] = 5, --136014
		--["Improved Fire Totems"] = 9, --135824
		["Eye of the Storm"] = 3, --136032
		--["Elemental Devastation"] = 11, --135791
		["Storm Reach"] = 2, --136099
		["Elemental Fury"] = 1, --135830
		["Lightning Mastery"] = 5, --135990
		["Elemental Mastery"] = 1, --136115		
	},
	["Elemental Leveling 40-60"] = {
		order = 4,
		["Convection"] = 5, --136116
		["Concussion"] = 5, --135807
		--["Earth's Grasp"] = 3, --136097
		--["Elemental Warding"] = 4, --136094
		["Call of Flame"] = 3, --135817
		["Elemental Focus"] = 1, --136170
		--["Reverberation"] = 7, --135850
		["Call of Thunder"] = 5, --136014
		--["Improved Fire Totems"] = 9, --135824
		["Eye of the Storm"] = 3, --136032
		--["Elemental Devastation"] = 11, --135791
		["Storm Reach"] = 2, --136099
		["Elemental Fury"] = 1, --135830
		["Lightning Mastery"] = 5, --135990
		["Elemental Mastery"] = 1, --136115		
		["Improved Healing Wave"] = 5, --136052
		--["Tidal Focus"] = 2, --135859
		["Improved Reincarnation"] = 2, --136080
		--["Ancestral Healing"] = 4, --136109
		["Totemic Focus"] = 4, --136057
		["Nature's Guidance"] = 3, --135860
		--["Healing Focus"] = 7, --136043
		["Totemic Mastery"] = 1, --136069
		--["Healing Grace"] = 9, --136041
		--["Restorative Totems"] = 10, --136053
		["Tidal Mastery"] = 5, --136107
	},	
	["Restoration Leveling 10-40"] = {
		order = 5,
		["Improved Healing Wave"] = 5, --136052
		--["Tidal Focus"] = 2, --135859
		["Improved Reincarnation"] = 2, --136080
		["Ancestral Healing"] = 3, --136109
		--["Totemic Focus"] = 5, --136057
		["Nature's Guidance"] = 3, --135860
		["Healing Focus"] = 1, --136043
		["Totemic Mastery"] = 1, --136069
		--["Healing Grace"] = 9, --136041
		["Restorative Totems"] = 5, --136053
		["Tidal Mastery"] = 5, --136107
		--["Healing Way"] = 12, --136044
		["Nature's Swiftness"] = 1, --136076
		["Purification"] = 4, --135865
		["Mana Tide Totem"] = 1, --135861			
	},	
	["Restoration Leveling 40-60"] = {
		order = 6,
		["Improved Healing Wave"] = 5, --136052
		--["Tidal Focus"] = 2, --135859
		["Improved Reincarnation"] = 2, --136080
		["Ancestral Healing"] = 3, --136109
		--["Totemic Focus"] = 5, --136057
		["Nature's Guidance"] = 3, --135860
		["Healing Focus"] = 1, --136043
		["Totemic Mastery"] = 1, --136069
		--["Healing Grace"] = 9, --136041
		["Restorative Totems"] = 5, --136053
		["Tidal Mastery"] = 5, --136107
		--["Healing Way"] = 12, --136044
		["Nature's Swiftness"] = 1, --136076
		["Purification"] = 4, --135865
		["Mana Tide Totem"] = 1, --135861			
		["Convection"] = 5, --136116
		["Concussion"] = 5, --135807
		--["Earth's Grasp"] = 3, --136097
		--["Elemental Warding"] = 4, --136094
		["Call of Flame"] = 3, --135817
		["Elemental Focus"] = 1, --136170
		--["Reverberation"] = 2, --135850
		--["Call of Thunder"] = 5, --136014
		--["Improved Fire Totems"] = 9, --135824
		--["Eye of the Storm"] = 3, --136032
		["Elemental Devastation"] = 3, --135791
	},		
    },
    WARLOCK = {
	["Affliction Leveling 10-39"] = {
		order = 1,
		["Suppression"] = 5, --136230
		["Improved Corruption"] = 5, --136118
		--["Improved Curse of Weakness"] = 3, --136138
		["Improved Drain Soul"] = 2, --136163
		["Improved Life Tap"] = 2, --136126
		--["Improved Drain Life"] = 6, --136169
		["Improved Curse of Agony"] = 3, --136139
		--["Fel Concentration"] = 8, --136157
		["Amplify Curse"] = 1, --136132
		["Grim Reach"] = 2, --136127
		["Nightfall"] = 2, --136223
		--["Improved Drain Mana"] = 12, --136208
		["Siphon Life"] = 1, --136188
		["Curse of Exhaustion"] = 1, --136162
		["Improved Curse of Exhaustion"] = 1, --136162
		["Shadow Mastery"] = 5, --136195
		--["Dark Pact"] = 17, --136141	
	},
	["Affliction Leveling 39-60"] = {
		order = 2,
		["Suppression"] = 5, --136230
		["Improved Corruption"] = 5, --136118
		--["Improved Curse of Weakness"] = 3, --136138
		["Improved Drain Soul"] = 2, --136163
		["Improved Life Tap"] = 2, --136126
		--["Improved Drain Life"] = 6, --136169
		["Improved Curse of Agony"] = 3, --136139
		--["Fel Concentration"] = 8, --136157
		["Amplify Curse"] = 1, --136132
		["Grim Reach"] = 2, --136127
		["Nightfall"] = 2, --136223
		--["Improved Drain Mana"] = 12, --136208
		["Siphon Life"] = 1, --136188
		["Curse of Exhaustion"] = 1, --136162
		["Improved Curse of Exhaustion"] = 1, --136162
		["Shadow Mastery"] = 5, --136195
		--["Dark Pact"] = 17, --136141	
		["Improved Healthstone"] = 2, --135230
		--["Improved Imp"] = 2, --136218
		["Demonic Embrace"] = 3, --136172
		--["Improved Health Funnel"] = 4, --136168
		["Improved Voidwalker"] = 3, --136221
		["Fel Intellect"] = 2, --135932
		--["Improved Succubus"] = 7, --136220
		["Fel Domination"] = 1, --136082
		["Fel Stamina"] = 4, --136121
		["Master Summoner"] = 2, --136164
		["Unholy Power"] = 4, --136206
    },
	["Demonology Leveling 10-40"] = {
		order = 3,
		["Improved Healthstone"] = 2, --135230
		["Improved Imp"] = 3, --136218
		["Demonic Embrace"] = 3, --136172
		--["Improved Health Funnel"] = 4, --136168
		--["Improved Voidwalker"] = 5, --136221
		["Fel Intellect"] = 5, --135932
		["Improved Succubus"] = 3, --136220
		["Fel Domination"] = 1, --136082
		--["Fel Stamina"] = 9, --136121
		["Master Summoner"] = 2, --136164
		["Unholy Power"] = 5, --136206
		--["Improved Enslave Demon"] = 12, --136154
		["Demonic Sacrifice"] = 1, --136184
		--["Improved Firestone"] = 14, --132386
		["Master Demonologist"] = 5, --136203
		["Soul Link"] = 1, --136160
		--["Improved Spellstone"] = 17, --134131
	},	
	["Demonology Leveling 40-60"] = {
		order = 4,
		["Improved Healthstone"] = 2, --135230
		["Improved Imp"] = 3, --136218
		["Demonic Embrace"] = 3, --136172
		--["Improved Health Funnel"] = 4, --136168
		--["Improved Voidwalker"] = 5, --136221
		["Fel Intellect"] = 5, --135932
		["Improved Succubus"] = 3, --136220
		["Fel Domination"] = 1, --136082
		--["Fel Stamina"] = 9, --136121
		["Master Summoner"] = 2, --136164
		["Unholy Power"] = 5, --136206
		--["Improved Enslave Demon"] = 12, --136154
		["Demonic Sacrifice"] = 1, --136184
		--["Improved Firestone"] = 14, --132386
		["Master Demonologist"] = 5, --136203
		["Soul Link"] = 1, --136160
		--["Improved Spellstone"] = 17, --134131
		["Suppression"] = 3, --136230
		["Improved Corruption"] = 5, --136118
		--["Improved Curse of Weakness"] = 3, --136138
		["Improved Drain Soul"] = 2, --136163
		["Improved Life Tap"] = 2, --136126
		--["Improved Drain Life"] = 6, --136169
		["Improved Curse of Agony"] = 3, --136139
		--["Fel Concentration"] = 8, --136157
		["Amplify Curse"] = 1, --136132
		["Grim Reach"] = 2, --136127
		["Nightfall"] = 2, --136223		
	},		
	["Destruction Leveling 10-40"] = {	
		order = 5,
		--["Improved Shadow Bolt"] = 1, --136197
		["Cataclysm"] = 5, --135831
		--["Bane"] = 3, --136146
		["Aftermath"] = 5, --135805
		--["Improved Firebolt"] = 5, --135809
		--["Improved Lash of Pain"] = 6, --136136
		["Devastation"] = 5, --135813
		["Shadowburn"] = 1, --136191
		["Intensity"] = 2, --135819
		["Destructive Reach"] = 2, --136133
		--["Improved Searing Pain"] = 11, --135827
		["Pyroclasm"] = 2, --135830
		["Improved Immolate"] = 5, --135817
		["Ruin"] = 1, --136207
		["Emberstorm"] = 2, --135826
		["Conflagrate"] = 1, --135807	
	},
	["Destruction Leveling 40-60"] = {	
		order = 6,
		--["Improved Shadow Bolt"] = 1, --136197
		["Cataclysm"] = 5, --135831
		--["Bane"] = 3, --136146
		["Aftermath"] = 5, --135805
		--["Improved Firebolt"] = 5, --135809
		--["Improved Lash of Pain"] = 6, --136136
		["Devastation"] = 5, --135813
		["Shadowburn"] = 1, --136191
		["Intensity"] = 2, --135819
		["Destructive Reach"] = 2, --136133
		--["Improved Searing Pain"] = 11, --135827
		["Pyroclasm"] = 2, --135830
		["Improved Immolate"] = 5, --135817
		["Ruin"] = 1, --136207
		["Emberstorm"] = 5, --135826
		["Conflagrate"] = 1, --135807	
		["Suppression"] = 2, --136230
		["Improved Corruption"] = 5, --136118
		--["Improved Curse of Weakness"] = 3, --136138
		["Improved Drain Soul"] = 2, --136163
		["Improved Life Tap"] = 2, --136126
		--["Improved Drain Life"] = 6, --136169
		["Improved Curse of Agony"] = 3, --136139
		--["Fel Concentration"] = 8, --136157
		["Amplify Curse"] = 1, --136132
		--["Grim Reach"] = 10, --136127
		["Nightfall"] = 2, --136223	
	},	
},
    WARRIOR = {
        ["Fury Dual Wield Leveling 10-40"] = {
			order = 1,
			--["Booming Voice"] = 5,
			["Cruelty"] = 5,
			--["Improved Demoralizing Shout"] = 3,
			["Unbridled Wrath"] = 5,
			--["Improved Cleave"] = 5,
			["Piercing Howl"] = 1,
			["Blood Craze"] = 3,
			["Improved Battle Shout"] = 1,
			["Dual Wield Specialization"] = 4,
			--["Improved Execute"] = 10,
			["Enrage"] = 5,
			--["Improved Slam"] = 12,
			["Death Wish"] = 1,
			--["Improved Intercept"] = 14,
			--["Improved Berserker Rage"] = 15,
			["Flurry"] = 5,
			["Bloodthirst"] = 1,
        },
        ["Fury Dual Wield Leveling 40-60"] = {
			order = 2,
			--["Booming Voice"] = 5,
			["Cruelty"] = 5,
			--["Improved Demoralizing Shout"] = 3,
			["Unbridled Wrath"] = 5,
			--["Improved Cleave"] = 5,
			["Piercing Howl"] = 1,
			["Blood Craze"] = 3,
			["Improved Battle Shout"] = 1,
			["Dual Wield Specialization"] = 5,
			--["Improved Execute"] = 10,
			["Enrage"] = 5,
			--["Improved Slam"] = 12,
			["Death Wish"] = 1,
			--["Improved Intercept"] = 14,
			["Improved Berserker Rage"] = 1,
			["Flurry"] = 5,
			["Bloodthirst"] = 1,
			--["Improved Heroic Strike"] = 1,
			["Deflection"] = 2,
			["Improved Rend"] = 3,
			["Improved Charge"] = 2,
			["Tactical Mastery"] = 3,
			--["Improved Thunder Clap"] = 6,
			["Improved Overpower"] = 2,
			["Anger Management"] = 1,
			["Deep Wounds"] = 3,
			--["Two-Handed Weapon Specialization"] = 3,
			["Impale"] = 2,
			--["Axe Specialization"] = 5,
			--["Sweeping Strikes"] = 1,
			--["Mace Specialization"] = 14,
			--["Sword Specialization"] = 15,
			--["Polearm Specialization"] = 16,
			--["Improved Hamstring"] = 3,
			--["Mortal Strike"] = 1,			
        },
        ["Arms Leveling 10-40"] = {
			order = 3,
			--["Improved Heroic Strike"] = 1,
			["Deflection"] = 3,
			["Improved Rend"] = 3,
			["Improved Charge"] = 2,
			["Tactical Mastery"] = 5,
			--["Improved Thunder Clap"] = 6,
			["Improved Overpower"] = 2,
			["Anger Management"] = 1,
			["Deep Wounds"] = 3,
			["Two-Handed Weapon Specialization"] = 5,
			["Impale"] = 2,
			["Axe Specialization"] = 5,
			["Sweeping Strikes"] = 1,
			--["Mace Specialization"] = 14,
			--["Sword Specialization"] = 15,
			--["Polearm Specialization"] = 16,
			--["Improved Hamstring"] = 3,
			["Mortal Strike"] = 1,
        },
        ["Arms Leveling 10-60"] = {
			order = 4,
			--["Improved Heroic Strike"] = 1,
			["Deflection"] = 3,
			["Improved Rend"] = 3,
			["Improved Charge"] = 2,
			["Tactical Mastery"] = 5,
			--["Improved Thunder Clap"] = 6,
			["Improved Overpower"] = 2,
			["Anger Management"] = 1,
			["Deep Wounds"] = 3,
			["Two-Handed Weapon Specialization"] = 5,
			["Impale"] = 2,
			["Axe Specialization"] = 5,
			["Sweeping Strikes"] = 1,
			--["Mace Specialization"] = 14,
			--["Sword Specialization"] = 15,
			--["Polearm Specialization"] = 16,
			--["Improved Hamstring"] = 3,
			["Mortal Strike"] = 1,		
			["Booming Voice"] = 5,
			["Cruelty"] = 5,
			--["Improved Demoralizing Shout"] = 3,
			--["Unbridled Wrath"] = 4,
			--["Improved Cleave"] = 5,
			["Piercing Howl"] = 1,
			["Blood Craze"] = 3,
			["Improved Battle Shout"] = 1,
			--["Dual Wield Specialization"] = 9,
			--["Improved Execute"] = 10,
			["Enrage"] = 5,
			--["Improved Slam"] = 12,
			--["Death Wish"] = 13,
			--["Improved Intercept"] = 14,
			--["Improved Berserker Rage"] = 15,
			--["Flurry"] = 16,
			--["Bloodthirst"] = 17,
        },	
        ["Protection Leveling 10-40"] = {
			order = 5,
			["Shield Specialization"] = 5,
			["Anticipation"] = 5,
			["Improved Bloodrage"] = 2,
			["Toughness"] = 5,
			--["Iron Will"] = 5,
			["Last Stand"] = 1,
			["Improved Shield Block"] = 1,
			["Improved Revenge"] = 3,
			--["Defiance"] = 9,
			--["Improved Sunder Armor"] = 10,
			--["Improved Disarm"] = 11,
			--["Improved Taunt"] = 12,
			--["Improved Shield Wall"] = 13,
			["Concussion Blow"] = 1,
			["Improved Shield Bash"] = 2,
			["One-Handed Weapon Specialization"] = 5,
			["Shield Slam"] = 1,			
        },
		["Protection Leveling 10-60"] = {
			order = 6,
			--["Deflection"] = 2,
			["Shield Specialization"] = 5,
			["Anticipation"] = 5,
			["Improved Bloodrage"] = 2,
			["Toughness"] = 5,
			--["Iron Will"] = 5,
			["Last Stand"] = 1,
			["Improved Shield Block"] = 1,
			["Improved Revenge"] = 3,
			--["Defiance"] = 9,
			--["Improved Sunder Armor"] = 10,
			--["Improved Disarm"] = 11,
			--["Improved Taunt"] = 12,
			--["Improved Shield Wall"] = 13,
			["Concussion Blow"] = 1,
			["Improved Shield Bash"] = 2,
			["One-Handed Weapon Specialization"] = 5,
			["Shield Slam"] = 1,		
			["Improved Heroic Strike"] = 3,
			--["Deflection"] = 0,
			["Improved Rend"] = 3,
			--["Improved Charge"] = 2,
			["Tactical Mastery"] = 5,
			--["Improved Thunder Clap"] = 6,
			--["Improved Overpower"] = 2,
			["Anger Management"] = 1,
			["Deep Wounds"] = 3,
			["Cruelty"] = 5,
        },
    },
}