local DGV = DugisGuideViewer
if not DGV then return end

local TaxiData = DGV:RegisterModule("TaxiData")
TaxiData.essential = true

--Possible modes: "veiled-den", "lights-purchase"
TaxiData.currentBeaconMode = "unknown"

function TaxiData:Initialize()

	local fullData
	function TaxiData:GetFullData()
		--107457 Druid
		--98968 Hunter 
		--93465 Death Knight 
		--98114 Alliance Skyfire Triage Camp Stormheim
		--98113 Alliance Lorna's Watch Stormheim
		--98108 Alliance Greywatch Stormheim
		--92560 Horde Cullen's Post Stormheim
		if not fullData then
			fullData = {
	["Neutral"] = {},
	["Horde"] = {
		[1414] = {
			[11900] = {
				"3615:2995", -- [1]
				"11901:4312", -- [2]
				"3615:4317", -- [3]
				"11901:4312:6726", -- [4]
				"3615:4317:7824", -- [5]
				"3615:8020", -- [6]
				"3615:16227:11899", -- [7]
				"3615:8020:15178", -- [9]
				"3615:4317:7824:10583", -- [10]
				"3615:16227", -- [11]
				["m"] = 1448,
				["direct"] = "3310:3615:8610:11139:11901:12740",
				["coord"] = 1477675493,
			},
			[10583] = {
				"7824:2995", -- [1]
				"7824:16227:3310", -- [2]
				"7824:4317:3615", -- [3]
				"7824:4317:3615:4312", -- [4]
				"7824:4317", -- [5]
				"15178:8020:6726", -- [6]
				"15178:8020", -- [7]
				"7824:16227:3310:8610", -- [8]
				"7824:4317:3615:11900", -- [9]
				"7824:16227:3310:8610:11139", -- [10]
				"7824:4317:11899", -- [11]
				"7824:4317:3615:11901", -- [12]
				"7824:16227:3310:12616", -- [13]
				"7824:4317:3615:11900:12740", -- [14]
				"7824:4317:10378", -- [15]
				"7824:16227", -- [16]
				["direct"] = "7824:15178",
				["m"] = 1449,
				["coord"] = 1945046773,
			},
			[11901] = {
				"12616:3310", -- [1]
				"3615:4317", -- [2]
				"4312:6726", -- [3]
				"3615:4317:7824", -- [4]
				"4312:6726:8020", -- [5]
				"12616:8610", -- [6]
				"11900:11139", -- [7]
				"3615:16227:11899", -- [8]
				"11900:12740", -- [9]
				"4312:6726:8020:15178", -- [10]
				"3615:4317:7824:10583", -- [11]
				"3615:16227", -- [12]
				["m"] = 1440,
				["direct"] = "2995:3615:4312:11900:12616",
				["coord"] = 524113510,
			},
			[3310] = {
				"3615:4312", -- [1]
				"3615:4317", -- [2]
				"3615:2995:6726", -- [3]
				"3615:8020", -- [4]
				"12616:11901", -- [5]
				"8610:11139:12740", -- [6]
				"3615:8020:15178", -- [7]
				"3615:10378", -- [8]
				"16227:7824:10583", -- [9]
				["m"] = 1454,
				["direct"] = "2995:3615:7824:8610:11900:11139:11899:12616:16227",
				["coord"] = 1936958556,
			},
			[8020] = {
				"3615:3310", -- [1]
				"6726:4312", -- [2]
				"3615:8610", -- [3]
				"3615:11900", -- [4]
				"3615:8610:11139", -- [5]
				"4317:11899", -- [6]
				"3615:11901", -- [7]
				"3615:12616", -- [8]
				"3615:11900:12740", -- [9]
				"4317:10378", -- [10]
				"15178:10583", -- [11]
				"4317:11899:16227", -- [12]
				["m"] = 1444,
				["direct"] = "2995:3615:4317:6726:7824:15178",
				["coord"] = 3239670126,
			},
			[16227] = {
				"3615:2995", -- [1]
				"3615:4312", -- [2]
				"11899:4317", -- [3]
				"3615:2995:6726", -- [4]
				"3615:8020", -- [5]
				"3310:8610", -- [6]
				"3615:11900", -- [7]
				"3310:8610:11139", -- [8]
				"3615:11901", -- [9]
				"3310:12616", -- [10]
				"3310:8610:11139:12740", -- [11]
				"7824:10583:15178", -- [12]
				"3615:10378", -- [13]
				"7824:10583", -- [14]
				["m"] = 1413,
				["direct"] = "3310:3615:7824:11899",
				["coord"] = 2710331135,
			},
			[6726] = {
				"2995:3310", -- [1]
				"2995:3615", -- [2]
				"8020:4317", -- [3]
				"8020:4317:7824", -- [4]
				"2995:8610", -- [5]
				"4312:11901:11900", -- [6]
				"2995:8610:11139", -- [7]
				"8020:4317:11899", -- [8]
				"4312:11901", -- [9]
				"2995:3615:12616", -- [10]
				"4312:11901:11900:12740", -- [11]
				"8020:15178", -- [12]
				"8020:15178:10583", -- [13]
				"2995:3615:16227", -- [14]
				["m"] = 1443,
				["direct"] = "2995:4312:8020",
				["coord"] = 924171661,
			},
			[4312] = {
				"3615:3310", -- [1]
				"3615:4317", -- [2]
				"3615:4317:7824", -- [3]
				"6726:8020", -- [4]
				"3615:8610", -- [5]
				"11901:11900", -- [6]
				"3615:8610:11139", -- [7]
				"3615:10378:11899", -- [8]
				"11901:12616", -- [9]
				"11901:11900:12740", -- [10]
				"6726:8020:15178", -- [11]
				"3615:10378", -- [12]
				"3615:4317:7824:10583", -- [13]
				"3615:16227", -- [14]
				"3615:16227:11899", -- [17]
				["direct"] = "2995:3615:6726:11901",
				["m"] = 1442,
				["coord"] = 1941084520,
			},
			[8610] = {
				"3615:4312", -- [1]
				"3615:4317", -- [2]
				"2995:6726", -- [3]
				"3615:4317:7824", -- [4]
				"3615:8020", -- [5]
				"3615:10378:11899", -- [6]
				"12616:11901", -- [7]
				"11139:12740", -- [8]
				"3615:8020:15178", -- [9]
				"3615:10378", -- [10]
				"3615:4317:7824:10583", -- [11]
				"3310:16227", -- [12]
				["m"] = 1447,
				["direct"] = "2995:3310:3615:11900:11139:12616",
				["coord"] = 942440280,
			},
			[10378] = {
				"3615:3310", -- [1]
				"3615:4312", -- [2]
				"2995:6726", -- [3]
				"4317:7824", -- [4]
				"4317:8020", -- [5]
				"3615:8610", -- [6]
				"3615:11900", -- [7]
				"3615:8610:11139", -- [8]
				"3615:11901", -- [9]
				"3615:12616", -- [10]
				"3615:11900:12740", -- [11]
				"4317:8020:15178", -- [12]
				"4317:7824:10583", -- [13]
				"3615:16227", -- [14]
				["m"] = 1413,
				["direct"] = "2995:3615:4317:11899",
				["coord"] = 1909167943,
			},
			[2995] = {
				"3615:11900", -- [1]
				"8610:11139", -- [2]
				"3615:12616", -- [3]
				"8610:11139:12740", -- [4]
				"8020:15178", -- [5]
				"7824:10583", -- [6]
				"3615:16227", -- [7]
				["direct"] = "3310:3615:4312:4317:6726:7824:8020:8610:11899:11901",
				["m"] = 1456,
				["coord"] = 2016182223,
			},
			[4317] = {
				"11899:16227:3310", -- [1]
				"3615:4312", -- [2]
				"8020:6726", -- [3]
				"3615:8610", -- [4]
				"3615:11900", -- [5]
				"3615:8610:11139", -- [6]
				"3615:11901", -- [7]
				"3615:12616", -- [8]
				"3615:11900:12740", -- [9]
				"8020:15178", -- [10]
				"7824:10583", -- [11]
				"11899:16227", -- [12]
				["m"] = 1441,
				["direct"] = "2995:3615:7824:8020:11899:10378",
				["coord"] = 1935506908,
			},
			[7824] = {
				"4317:3615:4312", -- [1]
				"8020:6726", -- [2]
				"16227:3310:8610", -- [3]
				"4317:3615:11900", -- [4]
				"16227:3310:8610:11139", -- [5]
				"4317:3615:11901", -- [6]
				"16227:3310:12616", -- [7]
				"4317:3615:11900:12740", -- [8]
				"4317:10378", -- [11]
				["m"] = 1446,
				["direct"] = "2995:3310:3615:4317:8020:11899:15178:10583:16227",
				["coord"] = 2216968535,
			},
			[12616] = {
				"3615:2995", -- [1]
				"11901:4312", -- [2]
				"3615:4317", -- [3]
				"3615:2995:6726", -- [4]
				"3615:4317:7824", -- [5]
				"3615:8020", -- [6]
				"8610:11139", -- [8]
				"3615:10378:11899", -- [9]
				"3615:8020:15178", -- [11]
				"3615:10378", -- [12]
				"3615:4317:7824:10583", -- [13]
				"3310:16227", -- [14]
				["m"] = 1440,
				["direct"] = "3310:3615:8610:11901",
				["coord"] = 3143933277,
			},
			[11139] = {
				"8610:2995", -- [1]
				"8610:3615", -- [2]
				"8610:3615:4312", -- [3]
				"8610:3615:4317", -- [4]
				"8610:2995:6726", -- [5]
				"8610:3615:4317:7824", -- [6]
				"8610:3615:8020", -- [7]
				"8610:3615:10378:11899", -- [8]
				"11900:11901", -- [9]
				"8610:12616", -- [10]
				"8610:3615:8020:15178", -- [11]
				"8610:3615:10378", -- [12]
				"8610:3615:4317:7824:10583", -- [13]
				"8610:3310:16227", -- [14]
				["m"] = 1452,
				["direct"] = "3310:8610:11900:12740",
				["coord"] = 2597215497,
			},
			[11899] = {
				"3615:4312", -- [1]
				"7824:4317", -- [2]
				"2995:6726", -- [3]
				"3615:8020", -- [4]
				"3310:8610", -- [5]
				"3615:11900", -- [6]
				"3310:8610:11139", -- [7]
				"3615:11901", -- [8]
				"3310:12616", -- [9]
				"3615:11900:12740", -- [10]
				"3615:10378", -- [11]
				"7824:10583", -- [12]
				"3615:16227", -- [13]
				--["name"] = "Brackenwall Village, Dustwallow Marsh",
				["m"] = 1445,
				["f"] = 0,
				["direct"] = "2995:3310:3615:7824",
				["coord"] = 1527796105,
			},
			[3615] = {
				"2995:6726", -- [1]
				"8610:11139", -- [2]
				"11900:12740", -- [3]
				"8020:15178", -- [4]
				"4317:7824:10583", -- [5]
				["direct"] = "2995:3310:4312:4317:7824:8020:8610:11900:11899:11901:12616:10378:16227",
				["m"] = 1413,
				["coord"] = 2212777390,
			},
			[15178] = {
				"8020:2995", -- [1]
				"8020:3615:3310", -- [2]
				"8020:3615", -- [3]
				"8020:6726:4312", -- [4]
				"8020:4317", -- [5]
				"8020:6726", -- [6]
				"8020:3615:8610", -- [7]
				"8020:3615:11900", -- [8]
				"8020:3615:8610:11139", -- [9]
				"8020:4317:11899", -- [10]
				"8020:3615:11901", -- [11]
				"8020:3615:12616", -- [12]
				"8020:3615:11900:12740", -- [13]
				"8020:4317:10378", -- [14]
				"8020:4317:11899:16227", -- [15]
				["m"] = 1451,
				["direct"] = "7824:8020:10583",
				["coord"] = 2095537650,
			},
			[12740] = {
				"11900:3615:2995", -- [1]
				"11139:8610:3310", -- [2]
				"11900:3615", -- [3]
				"11900:11901:4312", -- [4]
				"11900:3615:4317", -- [5]
				"11900:11901:4312:6726", -- [6]
				"11900:3615:4317:7824", -- [7]
				"11900:3615:8020", -- [8]
				"11139:8610", -- [9]
				"11900:3615:10378:11899", -- [10]
				"11900:11901", -- [11]
				"11900:3615:8020:15178", -- [13]
				"11900:3615:10378", -- [14]
				"11900:3615:4317:7824:10583", -- [15]
				"11900:3615:16227", -- [16]
				["direct"] = "11900:11139",
				["m"] = 1450,
				["coord"] = 1379117617,
			},
		},
		[1415] = {
			[2858] = {
				"2861:2851:2389:2226", -- [1]
				"2861:4551", -- [2]
				"2861:2851:2389", -- [3]
				"2861:2851", -- [4]
				"2861:2851:4314:12636", -- [5]
				"1387:13177", -- [6]
				"1387:13177:3305", -- [7]
				"2861:2851:4314", -- [8]
				["m"] = 1434,
				["direct"] = "1387:2861:6026",
				["coord"] = 1154598255,
			},
			[2851] = {
				"2389:2226", -- [1]
				"2861:2858", -- [2]
				"2861:1387", -- [3]
				"2861:6026", -- [4]
				"4314:12636", -- [5]
				"2861:13177", -- [6]
				"2861:3305", -- [7]
				["m"] = 1417,
				["direct"] = "4551:2389:2861:4314",
				["coord"] = 3133428612,
			},
			[3305] = {
				"2861:2851:2389:2226", -- [1]
				"2861:4551", -- [2]
				"2861:2851:2389", -- [3]
				"2861:2851", -- [4]
				"13177:1387:2858", -- [5]
				"13177:1387", -- [6]
				"13177:6026", -- [7]
				"2861:2851:4314:12636", -- [8]
				"2861:2851:4314", -- [9]
				["m"] = 1427,
				["direct"] = "2861:13177",
				["coord"] = 1493716690,
			},
			[6026] = {
				"2861:2851:2389:2226", -- [1]
				"2861:4551", -- [2]
				"2861:2851:2389", -- [3]
				"2861:2851", -- [4]
				"2861:2851:4314:12636", -- [5]
				"13177:3305", -- [6]
				"2861:2851:4314", -- [7]
				["m"] = 1435,
				["direct"] = "2858:1387:2861:13177",
				["coord"] = 1981254574,
			},
			[4551] = {
				"2861:2858", -- [1]
				"2861:1387", -- [2]
				"2861:6026", -- [3]
				"2861:13177", -- [4]
				"2861:3305", -- [5]
				["direct"] = "2226:2389:2851:2861:12636:4314",
				["m"] = 1458,
				["coord"] = 2729409447,
			},
			[2861] = {
				"2851:2389:2226", -- [1]
				"2851:2389", -- [2]
				"2851:4314:12636", -- [3]
				"2851:4314", -- [4]
				["direct"] = "4551:2851:2858:1387:6026:13177:3305",
				["m"] = 1418,
				["coord"] = 179270355,
			},
			[2389] = {
				"2851:2861:2858", -- [1]
				"2851:2861:1387", -- [2]
				"2851:2861", -- [3]
				"2851:2861:6026", -- [4]
				"4314:12636", -- [5]
				"2851:2861:13177", -- [6]
				"2851:2861:3305", -- [7]
				["m"] = 1424,
				["direct"] = "2226:4551:2851:4314",
				["coord"] = 2584162263,
			},
			[4314] = {
				"2389:2226", -- [1]
				"2851:2861:2858", -- [2]
				"2851:2861:1387", -- [3]
				"2851:2861", -- [4]
				"2851:2861:6026", -- [5]
				"2851:2861:13177", -- [6]
				"2851:2861:3305", -- [7]
				["m"] = 1425,
				["direct"] = "4551:2389:2851:12636",
				["coord"] = 3508261239,
			},
			[12636] = {
				"4551:2226", -- [1]
				"4314:2389", -- [2]
				"4314:2851", -- [3]
				"4314:2851:2861:2858", -- [4]
				"4314:2851:2861:1387", -- [5]
				"4314:2851:2861", -- [6]
				"4314:2851:2861:6026", -- [7]
				"4314:2851:2861:13177", -- [8]
				"4314:2851:2861:3305", -- [9]
				["m"] = 1423,
				["direct"] = "4551:4314",
				["coord"] = 3442774499,
			},
			[2226] = {
				"2389:2851", -- [1]
				"2389:2851:2861:2858", -- [2]
				"2389:2851:2861:1387", -- [3]
				"2389:2851:2861", -- [4]
				"2389:2851:2861:6026", -- [5]
				"4551:12636", -- [6]
				"2389:2851:2861:13177", -- [7]
				"2389:2851:2861:3305", -- [8]
				"2389:4314", -- [9]
				["m"] = 1421,
				["direct"] = "4551:2389",
				["coord"] = 1957129431,
			},
			[1387] = {
				"2861:2851:2389:2226", -- [1]
				"2861:4551", -- [2]
				"2861:2851:2389", -- [3]
				"2861:2851", -- [4]
				"2861:2851:4314:12636", -- [5]
				"13177:3305", -- [6]
				"2861:2851:4314", -- [7]
				["m"] = 1434,
				["direct"] = "2858:2861:6026:13177",
				["coord"] = 1397443303,
			},
			[13177] = {
				"2861:2851:2389:2226", -- [1]
				"2861:4551", -- [2]
				"2861:2851:2389", -- [3]
				"2861:2851", -- [4]
				"1387:2858", -- [5]
				"2861:2851:4314:12636", -- [6]
				"2861:2851:4314", -- [7]
				["m"] = 1428,
				["direct"] = "1387:2861:6026:3305",
				["coord"] = 2816556625,
			},
		},
},
	["Alliance"] = {
		[1414] = {
			[8019] = {
				"3841:3838", -- [1]
				"6706:4407:4267", -- [2]
				"6706:4407", -- [4]
				"4319:7823", -- [5]
				"3841:10897", -- [6]
				"3841:12578", -- [9]
				"15177:10583", -- [10]
				["m"] = 1444,
				["direct"] = "3841:4319:6706:15177",
				["coord"] = 1298558664,
			},
			[10583] = {
				"7823:16227:4267:3841", -- [1]
				"7823:16227:4267:3841:3838", -- [2]
				"7823:16227:4267", -- [3]
				"7823:4319", -- [4]
				"7823:4321", -- [5]
				"15177:8019:6706:4407", -- [6]
				"15177:8019:6706", -- [7]
				"15177:8019", -- [8]
				"7823:16227:12577:11138:10897", -- [9]
				"7823:16227:12577:11138", -- [10]
				"7823:16227:12577", -- [11]
				"7823:16227", -- [13]
				["m"] = 1449,
				["direct"] = "7823:15177",
				["coord"] = 1945833214,
			},
			[4319] = {
				"8019:6706:4407", -- [4]
				"8019:6706", -- [5]
				"8019:15177", -- [10]
				"7823:10583", -- [11]
				["m"] = 1444,
				["direct"] = "4321:7823:8019",
				["coord"] = 3842471266,
			},
			[3841] = {
				"4321:4319", -- [1]
				"4321:7823", -- [2]
				"10897:11138", -- [3]
				"8019:15177", -- [4]
				"4321:7823:10583", -- [5]
				"4267:16227", -- [6]
				["direct"] = "3838:4267:4321:4407:6706:8019:10897:12577:12578",
				["m"] = 1439,
				["coord"] = 1562539207,
			},
			[16227] = {
				"4267:3841", -- [1]
				"4267:3841:3838", -- [2]
				"4321:4319", -- [3]
				"4267:4407", -- [4]
				"4321:6706", -- [5]
				"4321:4319:8019", -- [6]
				"12577:11138:10897", -- [7]
				"12577:11138", -- [8]
				"7823:15177", -- [10]
				"7823:10583", -- [11]
				["m"] = 1413,
				["direct"] = "4267:4321:7823:12577",
				["coord"] = 2709675804,
			},
			[12577] = {
				"4267:3841:3838", -- [1]
				"4321:4319", -- [2]
				"4267:4407", -- [3]
				"4267:4407:6706", -- [4]
				"16227:7823", -- [5]
				"4321:4319:8019", -- [6]
				"11138:10897", -- [7]
				"16227:7823:15177", -- [8]
				"16227:7823:10583", -- [9]
				["m"] = 1447,
				["direct"] = "3841:4267:4321:11138:12578:16227",
				["coord"] = 511428183,
			},
			[7823] = {
				"16227:4267:3841", -- [1]
				"16227:4267:3841:3838", -- [2]
				"16227:4267", -- [3]
				"16227:4267:4407", -- [4]
				"4321:6706", -- [5]
				"4319:8019", -- [6]
				"16227:12577:11138:10897", -- [7]
				"16227:12577:11138", -- [8]
				"16227:12577", -- [9]
				["m"] = 1446,
				["direct"] = "4319:4321:15177:10583:16227",
				["coord"] = 2188528405,
			},
			[12578] = {
				"3841:3838", -- [1]
				"3841:6706", -- [6]
				"3841:8019", -- [8]
				"3841:8019:15177", -- [9]
				["m"] = 1448,
				["direct"] = "3841:10897:11138:12577:22931",
				["coord"] = 2682994159,
			},
			[10897] = {
				"3841:3838", -- [1]
				"11138:12577:4321:4319", -- [3]
				"11138:12577:4321", -- [4]
				"3841:4407", -- [5]
				"3841:6706", -- [6]
				"11138:12577:16227:7823", -- [7]
				"3841:8019", -- [8]
				"11138:12577", -- [9]
				"3841:8019:15177", -- [10]
				"11138:12577:16227:7823:10583", -- [11]
				"11138:12577:16227", -- [12]
				["m"] = 1450,
				["direct"] = "3841:11138:12578",
				["coord"] = 2065017862,
			},
			[11138] = {
				"10897:3841", -- [1]
				"10897:3841:3838", -- [2]
				"12577:4321:4319", -- [4]
				"12577:4321", -- [5]
				"10897:3841:4407", -- [6]
				"10897:3841:6706", -- [7]
				"12577:16227:7823", -- [8]
				"10897:3841:8019", -- [9]
				"12577:16227:7823:15177", -- [10]
				"12577:16227:7823:10583", -- [11]
				"12577:16227", -- [12]
				["m"] = 1452,
				["direct"] = "10897:12577:12578",
				["coord"] = 2676973008,
			},
			[4321] = {
				"3841:3838", -- [1]
				"6706:4407", -- [2]
				"4319:8019", -- [3]
				"12577:11138:10897", -- [4]
				"12577:11138", -- [5]
				"7823:15177", -- [7]
				"7823:10583", -- [8]
				["m"] = 1445,
				["direct"] = "3841:4267:4319:6706:7823:12577:16227",
				["coord"] = 2898297645,
			},
			[3838] = {
				"3841:4267", -- [1]
				"3841:4321:4319", -- [2]
				"3841:4321", -- [3]
				"3841:4407", -- [4]
				"3841:6706", -- [5]
				"3841:4321:7823", -- [6]
				"3841:8019", -- [7]
				"3841:10897", -- [8]
				"3841:10897:11138", -- [9]
				"3841:12577", -- [10]
				"3841:12578", -- [11]
				"3841:8019:15177", -- [12]
				"3841:4321:7823:10583", -- [13]
				"3841:4267:16227", -- [14]
				["m"] = 1438,
				["direct"] = "3841",
				["coord"] = 2508583036,
			},
			[4267] = {
				"3841:3838", -- [1]
				"16227:4321:4319", -- [2]
				"4407:6706", -- [3]
				"16227:7823", -- [4]
				"4407:6706:8019", -- [5]
				"16227:7823:15177", -- [9]
				"16227:7823:10583", -- [10]
				["m"] = 1440,
				["direct"] = "3841:4321:4407:12577:16227",
				["coord"] = 1480030934,
			},
			[23612] = {
				"4321:3841", -- [1]
				"4321:3841:3838", -- [2]
				"4321:16227:4267", -- [3]
				"4321:6706:4407", -- [4]
				"4321:6706", -- [5]
				"4321:7823", -- [6]
				"4319:8019", -- [7]
				"4321:12577:11138:10897", -- [8]
				"4321:12577:11138", -- [9]
				"4321:12577", -- [10]
				"4321:7823:15177", -- [12]
				"4321:7823:10583", -- [13]
				"4321:16227", -- [14]
				["direct"] = "4319:4321",
				["m"] = 1445,
				["coord"] = 1837480315,
			},
			[4407] = {
				"3841:3838", -- [1]
				"6706:8019:4319", -- [2]
				"6706:4321", -- [3]
				"6706:4321:7823", -- [4]
				"6706:8019", -- [5]
				"3841:10897", -- [6]
				"3841:10897:11138", -- [7]
				"4267:12577", -- [8]
				"6706:8019:15177", -- [10]
				"6706:8019:15177:10583", -- [11]
				"4267:16227", -- [12]
				["m"] = 1440,
				["direct"] = "3841:4267:6706",
				["coord"] = 174752921,
			},
			[6706] = {
				"3841:3838", -- [1]
				"4407:4267", -- [2]
				"8019:4319", -- [3]
				"4321:7823", -- [4]
				"3841:10897", -- [5]
				"3841:10897:11138", -- [6]
				"4407:4267:12577", -- [7]
				"3841:12578", -- [8]
				"8019:15177", -- [9]
				"8019:15177:10583", -- [10]
				"4321:16227", -- [11]
				["m"] = 1443,
				["direct"] = "3841:4321:4407:8019",
				["coord"] = 2780306183,
			},
			[15177] = {
				"8019:3841", -- [1]
				"8019:3841:3838", -- [2]
				"7823:16227:4267", -- [3]
				"8019:4319", -- [4]
				"7823:4321", -- [5]
				"8019:6706:4407", -- [6]
				"8019:6706", -- [7]
				"8019:3841:10897", -- [8]
				"7823:16227:12577:11138", -- [9]
				"7823:16227:12577", -- [10]
				"7823:16227", -- [12]
				["m"] = 1451,
				["direct"] = "7823:8019:10583",
				["coord"] = 2175883361,
			},
		},
		[1415] = {
			[523] = {
				"352:1573", -- [1]
				"352:1573:1571", -- [2]
				"352:1573:1572", -- [3]
				"352:1573:1571:2432", -- [4]
				"352:1573:1571:2835", -- [5]
				"352:1573:8018", -- [6]
				"2409:8609", -- [7]
				"931:2299", -- [8]
				"931:2299:2941", -- [9]
				["direct"] = "352:931:2409:2859",
				["m"] = 1436,
				["coord"] = 2428733058,
				["f"] = 0,
			},
			[8609] = {
				"2409:523", -- [1]
				"2299:2941:1573:1572", -- [2]
				"2299:2941:1573:1571:2432", -- [3]
				"2299:2941:1573:1571:2835", -- [4]
				"2409:2859", -- [5]
				"2299:2941:1573:8018", -- [6]
				"2409:931", -- [1]
				"2299:2941:1573", -- [2]
				"2299:2941:1573:1571", -- [3]
				"2299:2941:1572", -- [4]
				"2299:2941:1573:2432", -- [5]
				"2299:2941:1572:2835", -- [6]
				"2299:2941:1572:2835:8018", -- [8]
				"2299:2941:1573:12596", -- [9]
				"2299:2941", -- [10]
				"2299:2941:1573:12617", -- [13]
				["m"] = 1419,
				["direct"] = "352:2409:2299",
				["coord"] = 2812493456,
			},
			[2432] = {
				"1571:1573:2941:352", -- [1]
				"1571:1573:2941:2299:931", -- [2]
				"1571:1573:352:523", -- [2]
				"2835:1572", -- [3]
				"1571:1573:2941:2299:931:2409", -- [4]
				"1571:1573:2941:352:2859", -- [5]
				"1571:1573:2941:2299:8609", -- [6]
				"1571:1573:2941:2299", -- [7]
				"1571:1573:2941", -- [8]
				"12596:12617", -- [11]
				"1571:1573:352", -- [1]
				"1571:1573:352:2859", -- [5]
				"1571:1573:352:8609", -- [6]	
				["direct"] = "1573:1571:2835:8018:12596",
				["m"] = 1424,
				["coord"] = 2120844799,
			},
			[2941] = {
				"2299:931", -- [1]
				"1573:1571", -- [2]
				"2299:931:2409", -- [3]
				"1573:2432", -- [4]
				"1572:2835", -- [5]
				"352:2859", -- [6]
				"1572:2835:8018", -- [7]
				"2299:8609", -- [8]
				"1573:12596", -- [9]
				"1573:12617", -- [12]
				"2299:352", -- [1]
				"2299:931:523", -- [2]
				"2299:931", -- [3]
				"1573:1572", -- [4]
				"2299:931:2409", -- [5]
				"1573:1571:2432", -- [6]
				"1573:1571:2835", -- [7]
				"2299:931:2409:2859", -- [8]
				"1573:8018", -- [9]
				"2299:8609", -- [10]				
				["m"] = 1427,
				["direct"] = "352:1573:1572:2299",
				["coord"] = 1626558080,
			},
			[2409] = {
				"931:2299:2941:1573", -- [1]
				"931:2299:2941:1573:1571", -- [2]
				"931:2299:2941:1572", -- [3]
				"931:2299:2941:1573:2432", -- [4]
				"931:2299:2941:1572:2835", -- [5]
				"931:2299:2941:1572:2835:8018", -- [6]
				"931:2299:2941:1573:12596", -- [7]
				"931:2299", -- [8]
				"931:2299:2941", -- [9]
				"931:2299:2941:1573:12617", -- [11]
				"931:2299:2941:1573:1572", -- [1]
				"931:2299:2941:1573:1571:2432", -- [2]
				"931:2299:2941:1573:1571:2835", -- [3]
				"931:2299:2941:1573:8018", -- [4]				
				["direct"] = "352:523:931:2859:8609",
				["m"] = 1431,
				["coord"] = 3327750549,
			},
			[1572] = {
				"2941:352", -- [1]
				"2941:2299:931", -- [2]
				"2941:2299:931:2409", -- [3]
				"2835:2432", -- [4]
				"2941:352:2859", -- [5]
				"2835:8018", -- [6]
				"2941:2299:8609", -- [7]
				"2835:8018:12596", -- [8]
				"2941:2299", -- [9]
				"2835:8018:12617", -- [12]
				"1573:352", -- [1]
				"1573:352:523", -- [2]
				"1573:2941:2299:931", -- [3]
				"1573:2941:2299:931:2409", -- [4]
				"1573:352:2859", -- [6]
				"1573:352:8609", -- [8]
				"1573:2941:2299", -- [9]
				"1573:2941", -- [10]				
				["direct"] = "1573:1571:2835:2941",
				["m"] = 1432,
				["coord"] = 1456964172,
			},
			[352] = {
				"1573:1571", -- [1]
				"2941:1572", -- [2]
				"1573:2432", -- [3]
				"2941:1572:2835", -- [4]
				"1573:8018", -- [5]
				"1573:12596", -- [6]
				"1573:12617", -- [8]
				"2299:2941", -- [6]
				"1573:1572", -- [2]
				"1573:1571:2432", -- [3]
				"1573:1571:2835", -- [4]
				["m"] = 1453,
				["direct"] = "931:1573:2409:2859:8609:2299:2941",
				["coord"] = 2842468151,
			},
			[12596] = {
				"1573:2941:352", -- [1]
				"1573:2941:2299:931", -- [2]
				"2432:1571", -- [3]
				"8018:2835:1572", -- [4]
				"1573:2941:2299:931:2409", -- [5]
				"8018:2835", -- [6]
				"1573:2941:352:2859", -- [7]
				"1573:2941:2299:8609", -- [8]
				"1573:2941:2299", -- [9]
				"1573:2941", -- [10]
				"1573:2941:352", -- [11]
				["m"] = 1422,
				["direct"] = "1573:2432:8018:12617",
				["coord"] = 1844042079,
			},
			[2859] = {
				"352:1573", -- [2]
				"352:1573:1571", -- [3]
				"352:2941:1572", -- [4]
				"352:1573:2432", -- [5]
				"352:2941:1572:2835", -- [6]
				"352:1573:8018", -- [7]
				"352:1573:12596", -- [9]
				"352:2941", -- [11]
				"352:1573:12617", -- [13]
				["m"] = 1434,
				["direct"] = "352:2409",
				["coord"] = 1183368912,
			},
			[8018] = {
				"2835:1572:2941:352", -- [1]
				"2835:1572:2941:2299:931", -- [2]
				"2432:1571", -- [3]
				"2835:1572", -- [4]
				"2835:1572:2941:2299:931:2409", -- [5]
				"2835:1572:2941:352:2859", -- [6]
				"2835:1572:2941:2299:8609", -- [7]
				"2835:1572:2941:2299", -- [8]
				"2835:1572:2941", -- [9]
				"1573:352", -- [1]
				"1573:352:523", -- [2]
				"1573:2941:2299:931", -- [3]
				"1573:2941:2299:931:2409", -- [5]
				"1573:352:2859", -- [6]
				"1573:352:8609", -- [7]
				"1573:2941:2299", -- [8]
				"1573:2941", -- [9]	
				["m"] = 1425,
				["direct"] = "1573:2432:2835:12596:12617",
				["coord"] = 477328902,
			},
			[12617] = {
				"1573:2941:352", -- [1]
				"1573:2941:2299:931", -- [2]
				"8018:2432:1571", -- [3]
				"8018:2835:1572", -- [4]
				"1573:2941:2299:931:2409", -- [5]
				"8018:2432", -- [6]
				"8018:2835", -- [7]
				"1573:2941:352:2859", -- [8]
				"1573:2941:2299:8609", -- [9]
				"1573:2941:2299", -- [10]
				"1573:2941", -- [11]
				["m"] = 1423,
				["direct"] = "1573:8018:12596",
				["coord"] = 3508312027,
			},
			[1571] = {
				"1573:2941:352", -- [1]
				"1573:352:523", -- [2]
				"1573:2941:2299:931", -- [2]
				"1573:2941:2299:931:2409", -- [3]
				"1573:2941:352:2859", -- [4]
				"2432:8018", -- [5]
				"1573:2941:2299:8609", -- [6]
				"2432:12596", -- [7]
				"1573:2941:2299", -- [8]
				"1573:2941", -- [9]
				"2432:12596:12617", -- [12]
				"1573:352", -- [1]	
				["direct"] = "1573:1572:2432:2835",
				["m"] = 1437,
				["coord"] = 408852657,
			},
			[2299] = {
				"2941:1573", -- [1]
				"2941:1573:1571", -- [2]
				"2941:1572", -- [3]
				"931:2409", -- [4]
				"2941:1573:2432", -- [5]
				"2941:1572:2835", -- [6]
				"2941:1572:2835:8018", -- [8]
				"2941:1573:12596", -- [9]
				"2941:1573:12617", -- [12]
				"931:523", -- [1]
				"2941:1573:1572", -- [2]
				"931:2409", -- [3]
				"2941:1573:1571:2432", -- [4]
				"2941:1573:1571:2835", -- [5]
				"931:2409:2859", -- [6]
				"2941:1573:8018", -- [7]				
				["m"] = 1428,
				["direct"] = "352:931:8609:2941",
				["coord"] = 3623595713,
			},
			[931] = {
				"2299:2941:1573", -- [1]
				"2299:2941:1573:1571", -- [2]
				"2299:2941:1572", -- [3]
				"2299:2941:1573:2432", -- [4]
				"2299:2941:1572:2835", -- [5]
				"2299:2941:1572:2835:8018", -- [7]
				"2409:8609", -- [8]
				"2299:2941:1573:12596", -- [9]
				"2299:2941", -- [10]
				"2299:2941:1573:12617", -- [13]
				"2299:2941:1573:1572", -- [1]
				"2299:2941:1573:1571:2432", -- [2]
				"2299:2941:1573:1571:2835", -- [3]
				"2409:2859", -- [4]
				"2299:2941:1573:8018", -- [5]
				"2409:8609", -- [6]				
				["m"] = 1433,
				["direct"] = "352:523:2409:2299",
				["coord"] = 1317640195,
			},
			[1573] = {
				"352:523", -- [1]
				"2941:2299:931", -- [2]
				"2941:2299:931:2409", -- [3]
				"2941:352:2859", -- [4]
				"2941:2299:8609", -- [5]
				"2941:2299", -- [6]
				"352:2859", -- [4]
				"352:8609", -- [5]				
				["direct"] = "352:1571:1572:2432:2835:8018:12596:12617:2941",
				["m"] = 1455,
				["coord"] = 2406251298,
			},
			[2835] = {
				"1571:1573:352", -- [1]
				"1571:1573:352:523", -- [2]
				"1571:1573:2941:2299:931", -- [3]
				"1571:1573:2941:2299:931:2409", -- [4]
				"1571:1573:352:2859", -- [5]
				"1571:1573:352:8609", -- [6]
				"1571:1573:2941:2299", -- [7]
				"1571:1573:2941", -- [8]
				"1572:2941:352", -- [1]
				"1571:1573:352:523", -- [2]
				"1572:2941:2299:931", -- [2]
				"1572:2941:2299:931:2409", -- [3]
				"1572:2941:352:2859", -- [4]
				"1572:2941:2299:8609", -- [5]
				"8018:12596", -- [6]
				"1572:2941:2299", -- [7]
				"1572:2941", -- [8]
				"1572:2941:352:24366", -- [9]
				"8018:12617", -- [11]
				["direct"] = "1573:1571:1572:2432:8018",
				["m"] = 1417,
				["coord"] = 1967027777,
			},
		},
}
}
		end
		local faction = UnitFactionGroup("player")
      
        --Checking for dynamic flight nodes

        --Saving original subtable for Argus (9) for further use.
        TaxiData.copies = TaxiData.copies or {}
        TaxiData.copies[faction] = TaxiData.copies[faction] or {}
        TaxiData.copies[faction][9] = TaxiData.copies[faction][9] or LuaUtils:clone(fullData[faction][9])
        
        --Restoring original table
        fullData[faction][9] = LuaUtils:clone(TaxiData.copies[faction][9])
        
        local result = fullData[faction]
        
        --Checking for mode
        if TaxiData.currentBeaconMode == "veiled-den" then
            result[9][125410] = nil
        end
        
        if TaxiData.currentBeaconMode == "lights-purchase" then
            result[9][125409] = nil
        end
        
		return result
	end

	TaxiData.NonZeroOpenWorldFloors = {
	}
	TaxiData.ZoneTransData ={
		[1414] = {
			[1411] = { --Durotar
				[1454] = "45.52,12.34-1454::48.95,93.17",  --Orgrimmar
				[1413] = "35.03,42.30-1413::62.62,19.23|37.74,16.11-1413::64.08,5.87", --The Barrens
			},
			[1454] = { --Orgrimmar
				[1411] = "48.95,93.17-1411::45.52,12.34", --Durotar
				[1413] = "63.96,0.37-1454::15.92,62.65", --The Barrens
			},
			[1413] = { --The Barrens
				[1411] = "62.62,19.23-1411::35.03,42.30|64.08,5.87-1411::37.74,16.11", -- Durotar
				[1454] = "15.92,62.65-1413::63.96,0.37",--Orgrimmar
				[1440] = "47.98,5.62-1440::68.59,85.90|63.96,0.90-1440::94.35,76.04", -- Ashenvale
				[1442] = "33.86,27.46", --Stonetalon
				[1412] = "41.57,58.56-1412::68.74,60.69", --Mulgore
				[1445] = "49.84,78.42-1445::29.02,47.16", --Dustwallow				
				[1441] = "44.30,91.44-1441::32.21,24.03", --Thousand Needles	
			},
			[1440] = { --Ashenvale
				[1447] = "94.53,47.51-1447::10.80,75.34", --Azshara
				[1413] = "68.59,85.90-1413::47.98,5.62|94.35,76.04-1413::63.96,0.90", --The Barrens
				[1448] = "55.75,30.16-1448::54.91,92.10",  --Felwood
				[1439] = "29.15,15.00-1439::43.85,94.97", --Darkshore
				[1442] = "42.29,71.12-1442::78.27,42.72", --Stonetalon
			}, 
			[1447] = { --Azshara
				[1440] = "10.80,75.34-1440::94.53,47.51", --Ashenvale
			}, 
			[1448] = { --Felwood
				[1440] = "54.91,92.10-1440::55.75,30.16", --Ashenvale
				[1439] = "32.67,50.71-1439::47.70,72.70", --Darkshore
				[1452] = "64.99,8.35-1452::27.94,34.51",--Winterspring
				[1448] = "64.99,8.35-1448::35.59,72.25",--Moonglade
			},
			[1439] = { --Darkshore
				[1448] = "47.70,72.70-1448::32.67,50.71", --Felwood
				[1440] = "43.85,94.97-1440::29.15,15.00", --Darkshore
			},
			[1452] = { --Winterspring
				[1448] = "27.94,34.51-1448::64.99,8.35",--Felwood
				[1450] = "27.94,34.51-1450::35.59,72.25",--Moonglade
			},
			[1450] = { --Moonglade
				[1448] = "35.59,72.25-1448::64.99,8.35",--Felwood
				[1452] = "35.59,72.25-1452::27.94,34.51",--Winterspring
			},
			[1438] = { --Teldrassil
				[1457] = "36.39,54.36-1457::85.38,35.99", --Darnassus
			},
			[1457] = { --Darnassus
				[1438] = "85.38,35.99-1438::36.39,54.36", --Teldrassil
			},
			[1442] = { --Stonetalon
				[1440] = "78.27,42.72-1440::42.29,71.12", --Ashenvale
				[1413] = "83.75,97.23", --The Barrens
				[1443] = "30.08,77.12-1443::53.75,4.10", --Desolace
			},
			[1443] = { --Desolace
				[1442] = "53.75,4.10-1442::30.08,77.12", --Stonetalon
				[1444] = "42.20,96.37-1444::45.60,3.23", --Desolace
			},
			[1444] = { --Feralas
				[1443] = "45.60,3.23-1443::42.20,96.37", --Desolace
				[1441] = "89.44,40.11-1441::8.54,11.7", --Thousand Needles
			},
			[1441] = { --Thousand Needles
				[1444] = "8.54,11.7-1444::89.44,40.11",--Feralas
				[1446] = "75.30,96.30-1446::51.26,21.5", --Tanaris		
				[1413] = "32.21,24.03-1413::44.30,91.44", --Thousand Needles			
			},
			[1456] = { --Thunder Bluff
				[1412] = "35.14,75.50-1412::38.17,33.58|54.72,26.601412::42.31,19.99", --Mulgore
			}, 
			[1412] = { --Mulgore 
				[1456] = "38.17,33.58-1456::35.14,75.50|42.31,19.99-1456::54.72,26.60", --Thunder Bluff 
				[1413] = "68.74,60.69-1413::41.57,58.56", --The Barrens
			},
			[1445] = { --Dustwallow
				[1413] = "29.02,47.16-1413::49.84,78.42", --The Barrens
			},
			[1446] = { --Tanaris
				[1441] = "51.26,21.5-1441::75.30,96.30", --Thousand Needles
				[1449] = "26.94,52.86-1449::70.80,90.69", --Tanaris
			},
			[1449] = { --Un'Goro
				[1446] = "70.80,90.69-1446::26.94,52.86", --Tanaris
				[1451] = "28.25,10.27-1451::85.16,12.90", --Silithus
			},
			[1451] = { --Silithus
				[1449] = "85.16,12.90-1449::28.25,10.27", --Un'Goro
			},
		}, -- [1]
		[1415] = {
			[1431] = { --Duskwood
				[1434] = "44.53,86.42-1434::40.83,4.29", --Stranglethorn
				[1436] = "8.99,63.73-1436::67.25,62.79", --Westfall
				[1429] = "8.27,29.8-1429::25.87,96.84|51.21,11.55-1429::59.21,82.93", --Elwynn
				[1433] = "92.96,12.64-1433::7.15,89.42", --Redridge
				[1430] = "88.23,40.82-1430::34.67,35.89", --Deadwind
			},
			[1434] = { --Stranglethorn
				[1431] = "40.83,4.29-1431::44.53,86.42", --Duskwood
			},
			[1436] = { --Westfall
				[1431] = "67.25,62.79-1431::8.99,63.73", --Duskwood
				[1429] = "62.73,30.41-1429::23.28,93.35|61.61,18.19-1429::21.16,79.31", --Elwynn
			},
			[1429] = { --Elwynn
				[1436] = "23.28,93.35-1436::62.73,30.41|21.16,79.31-1436::61.61,18.19", --Westfall
				[1431] = "25.87,96.84-1431::8.27,29.8|59.21,82.93-1431::51.21,11.55", --Duskwood
				[1453] = "32.49,50.06-1453::69.76,86.36", --Stormwind
				[1433] = "92.39,72.59-1433::9.72,71.87", --Redridge
			}, 
			[1453] = { --Stormwind
				[1429] = "69.76,86.36-1429::32.49,50.06", --Elwynn
			},
			[1433] = { --Redridge
				[1429] = "9.72,71.87-1429::92.39,72.59", --Elwynn
				[1431] = "7.15,89.42-1431::92.96,12.64", --Duskwood
				[1428] = "46.70,10.21-1428::78.58,79.84", --Burning Steppes
			},
			[1435] = { --Swamp
				[1430] = "5.87,60.61-1430::57.85,41.69", --Deadwind
				[1419] = "34.28,64.98-1419::52.01,5.9", --Blasted Lands
			},
			[1430] = { --Deadwind
				[1435] = "57.85,41.69-1435::5.87,60.61", --Swamp
				[1431] = "34.67,35.89-1431::88.23,40.82", --Deadwind				
			},			
			[1419] = { --Blasted Lands
				[1435] = "52.01,5.9-1435::34.28,64.98", --Swamp
			},
			[1428] = { --Burning Steppes
				[1433] = "78.58,79.84-1433::46.70,10.21", --Redridge
				[1427] = "32.47,50.50-1427::34.14,82.49", --Burning Steppes
			},
			[1427] = { --Searing
				[1428] = "34.14,82.49-1428::32.47,50.50", --Burning Steppes
				[1432] = "78.81,17.01-1432::18.10,83.92", --Loch Modan
				[1418] = "76.59,56.69-1418::1.13,62.96" --Badlands
			},
			[1432] = { --Loch Modan
				[1427] = "18.10,83.92-1427::78.81,17.01", --Searing
				[1426] = "19.64,63.02-1426::85.54,50.85|19.38,17.16-1426::84.39,31.07", --Dun Morogh		
				[1437] = "25.59,10.93-1437::55.62,84.16", --Wetlands
				[1418] = "47.16,81.00-1418::49.28,8.77" --Badlands
			},
			[1426] = { --Dun Morogh
				[1432] = "85.54,50.85-1432::19.64,63.02|84.39,31.07-1432::19.38,17.16", --Loch Modan
				[1455] = "53.17,35.20-1455::19.25,80.99", --Ironforge
			},
			[1437] = { --Wetlands
				[1432] = "55.62,84.16-1432::25.59,10.93", --Loch Modan
				[1417] = "51.08,12.01-1417::45.48,88.73",--Wetlands
			},
			[1455] = { --Ironforge
				[1426] = "19.25,80.99-1426::53.17,35.20", --Ironforge
			},
			[1417] = { --Arathi
				[1437] = "45.48,88.73-1437::51.08,12.01",--Wetlands
				[1424] = "20.54,30.05-1424::81.57,56.44", --Hillsbrad				
			},
			[1424] = { --Hillsbrad
				[1417] = "81.57,56.44-1417::20.54,30.05", --Arathi
				[1425] = "88.68,27.11-1425::6.41,61.15", --Hillsbrad
				[1416] = "70.42,10.11-1416::73.00,66.13|54.87,11.48-1416::51.58,68.22|47.39,26.96-1416::42.63,84.59|31.50,28.43-1416::21.51,89.09", --Alterac			
				[1421] = "16.98,46.38-1421::65.93,79.57", --Silverpine			
			},
			[1425] = { --The Hinterlands
				[1424] = "6.41,61.15-1424::88.68,27.11", --Hillsbrad
				[1422] = "22.50,27.29-1422::65.36,88.68", --The Hinterlands				
			},
			[1422] = { --Western Plaguelands
				[1425] = "65.36,88.68-1425::22.50,27.29", --The Hinterlands
				[1416] = "43.98,85.52-1416::80.63,36.33", --Alterac
				[1420] = "28.53,57.48-1420::84.00,70.46", --Tirisfal
				[1423] = "69.47,50.31-1423::11.81,72.68", --Western Plaguelands			
			},
			[1416] = { --Alterac
				[1422] = "80.63,36.33-1422::43.98,85.52", --Western Plaguelands
				[1424] = "73.00,66.13-1424::70.42,10.11|51.58,68.22-1424::54.87,11.48|42.63,84.59-1424::47.39,26.96|21.51,89.09-1424::31.50,28.43", --Hillsbrad
			},
			[1421] = { --Silverpine
				[1424] = "65.93,79.57-1424::16.98,46.38", --Hillsbrad
				[1420] = "66.53,6.89-1420::54.16,75.60", --Silverpine
			},
			[1420] = { --Tirisfal
				[1421] = "54.16,75.60-1421::66.53,6.89", --Silverpine
				[1458] = "61.90,64.36-1458::66.16,2.04|50.97,71.32-1458::14.60,34.55", --Undercity
				[1422] = "84.00,70.46-1422::28.53,57.48", --Western Plaguelands				
			},
			[1458] = { --Undercity
				[1420] = "66.16,2.04-1420::61.90,64.36|14.60,34.55-1420::50.97,71.32", --Tirisfal		
			},
			[1423] = { --Eastern Plaguelands
				[1422] = "11.81,72.68-1422::69.47,50.31", --Western Plaguelands
			},
			[1418] = { --Badlands
				[1432] = "49.28,8.77-1432::47.16,81.00", --Loch Modan
				[1427] = "1.13,62.96-1427::76.59,56.69", --Searing Gorge
			},
		}, -- [2]
	}
	
	--[[
	[1414]="Kalimdor",
	[1415]="Eastern Kingdoms",
	]]
	
	TaxiData.UnboundTeleportData = 
	{
		[1414] = {
			[3567] = "3567:1454::38.57,85.95:fac:Horde", --Teleport: Orgrimmar
			[3566] = "3566:1456::22.35,16.52:fac:Horde", --Teleport: Thunder Bluff		
			[3565] = "3565:1457::40.13,81.83:fac:Alliance", --Teleport: Darnassus
			[18984] = "23442:1452::2560458565", --Dimensional Ripper - Everlook
			[18986] = "23441:1446::2243577666", --Ultrasafe Transporter: Gadgetzan
			[18960] = "18960:1450::56.26,32.46", --Teleport: Moonglade
		}, --Kalimdor
		[1415] = {
			[3563] = "3563:1458::84.65,16.32:fac:Horde", --Teleport: Undercity		
			[3562] = "3562:1455::25.52,8.41:fac:Alliance", --Teleport: Ironforge			
			[3561] = "3561:1453::38.01,80.84:fac:Alliance", --Teleport: Stormwind
		}, --Eastern Kingdom
	}
	
	TaxiData.LocalPortalData = 
	{
		[1414] = {
			":1457:0:1302948379:1438:0:2401559951", --Darnassus > Ruth'eran Village
			":1438:0:2401559951:1457:0:1302948379:450", --Ruth'eran Village > Darnassus	
		}, -- Kalimdor
		[1415] = {
		}, --Eastern Kingdom
	}

	TaxiData.StaticPortalData = 
	{
		[1414] = {
		}, --Kalimdor
		[1415] = {	
		}, --Eastern Kingdom
	}
	
	TaxiData.BoatData = 
	{
		[1414] = {
			"1439::33.20,40.09:1438::54.87,96.80:300:Boat:fac:Alliance", --Darkshore > Teldrassil
			"1438::54.87,96.80:1439::33.20,40.09:300:Boat:fac:Alliance", --Teldrassil > Darkshore
			"1434::25.87,73.10:1413::63.70,38.62:300:Boat:fac:Alliance", --Stranglethorn > The Barrens
			"1437::4.69,57.16:1439::32.39,43.86:300:Boat:fac:Alliance", --Wetlands > Darkshore
			"1437::5.05,63.45:1445::71.52,56.35:300:Boat:fac:Alliance", --Wetlands > Dustwallow
			"1420::60.66,58.75:1411::50.88,13.94:300:Zeppelin:fac:Horde", --Tirisfal > Durotar
			"1434::31.35,30.20:1411::50.55,12.61:300:Zeppelin:fac:Horde", --Stranglethorn > Durotar
			--"1450::56.22,30.64:1456::46.70,49.92:300:Dendrite Starblaze:cls:DRUID:fac:Horde", --Druid Moonglade to Thunderbluff	
			--"1450::44.17,45.21:1456::46.70,49.92:300:Silva Filnaveth:cls:DRUID:fac:Alliance", --Druid Moonglade to Teldrassil	
			"1444::31.03,39.73:1444::43.31,42.73:1:Boat", --Feathermoon > Feralas Boat
			"1444::43.31,42.73:1444::31.03,39.73:1:Boat", --Feralas > Feathermoon Boat
		},
		[1415] = {
			"1413::63.70,38.62:1434::25.87,73.10:300:Boat:fac:Alliance", --The Barrens > Stranglethorn
			"1445::71.52,56.35:1437::4.69,57.16:300:Boat:fac:Alliance", --Darkshore > Wetlands
			"1439::32.39,43.86:1437::5.05,63.45:300:Boat:fac:Alliance", --Dustwallow > Wetlands
			"1411::50.88,13.94:1420::60.66,58.75:300:Zeppelin:fac:Horde", --Durotar >Tirisfal
			"1411::50.55,12.61:1434::31.35,30.20:300:Zeppelin:fac:Horde", --Durotar > Stranglethorn
			"1420::61.90,59.13:1434::31.56,29.12:300:Zeppelin:fac:Horde", --Tirisfal > Stranglethorn 
			"1434::31.56,29.12:1420::61.90,59.13:300:Zeppelin:fac:Horde", --Stranglethorn > Tirisfal
			"1453::63.87,8.17:1455::76.31,51.13:300:Tram:fac:Alliance", --Deeprun Tram
			"1455::76.31,51.13:1453::63.87,8.17:300:Tram:fac:Alliance", --Deeprun Tram
		},
	}
	
	--Debug ShowLocation:  player location=38::3259134883
	--Debug ShowLocation:  player location=687::2146904192
	--465::2046724389 ramparts 797
	TaxiData.InstancePortals = 
	{
	}
	
	function TaxiData:GetLookupTable()
		if not DugisFlightmasterLookupTable then
			DugisFlightmasterLookupTable = {
				["Horde"] = {
					[1414] = {
						[2602814795] = 7824,
						[2310458218] = 12740,
						[1930457152] = 2995,
						[2267978801] = 10378,
						[2697301629] = 3310,
						[1752139522] = 4312,
						[2437241789] = 11899,
						[2601481071] = 16227,
						[2710461605] = 8610,
						[1759797161] = 11901,
						[1788097844] = 15178,
						[2393798706] = 3615,
						[2710479706] = 8610,
						[2267964366] = 10378,
						[1930465215] = 2995,
						[2749416576] = 11139,
						[1759813718] = 11901,
						[2602775220] = 7824,
						[1900564059] = 8020,
						[2749381503] = 11139,
						[1995223591] = 11900,
						[2310419605] = 12740,
						[2137341066] = 10583,
						[2361768968] = 4317,
						[1900589476] = 8020,
						[1359768128] = 6726,
						[2393802701] = 3615,
						[2697294210] = 3310,
						[2361738231] = 4317,
						[1752135933] = 4312,
						[1359779263] = 6726,
						[2381212400] = 12616,
						[2137375605] = 10583,
						[2381223183] = 12616,
						[1995197912] = 11900,
						[2601487504] = 16227,
						[2437260354] = 11899,
					},
					[1415] = {
						[2123545518] = 2389,
						[1958056686] = 2389,
						[2643087124] = 2851,
						[2643112171] = 2851,
						[1853681142] = 2858,
						[2385142668] = 13177,
						[2154911734] = 2861,
						[1993889962] = 3305,
						[1651294542] = 2226,
						[2351336137] = 2851,
						[2618271647] = 12636,
						[2170851662] = 3305,
						[2884193223] = 4314,
						[1925305886] = 1387,
						[2156023867] = 13177,
						[2318874107] = 6026,
						[2385157235] = 13177,
						[2383637956] = 2861,
						[1808016533] = 1387,
						[1753813642] = 2858,
						[1901317658] = 4551,
						[2533789001] = 4314,
						[2383647291] = 2861,
						[1789894880] = 4551,
						[1651261105] = 2226,
						[1600689968] = 2226,
						[1853624841] = 2858,
						[2170842801] = 3305,
						[2600255266] = 6026,
						[2600222941] = 6026,
						[2123514961] = 2389,
						[2884219960] = 4314,
						[1901277669] = 4551,
						[1925261793] = 1387,
					},
				},
				["Alliance"] = {
					[1414] = {
						[1787353025] = 3838,
						[2772581284] = 11138,
						[2772616283] = 11138,
						[1799539270] = 15177,
						[1986763412] = 4267,
						[1346613544] = 8019,
						[1677813492] = 4407,
						[1677826315] = 4407,
						[1837318261] = 3841,
						[2137341066] = 10583,
						[2772550740] = 11138,
						[2601487504] = 16227,
						[1986749803] = 4267,
						[2732676252] = 4321,
						[2279752162] = 12578,
						[1701805647] = 6706,
						[1799501241] = 15177,
						[2072661401] = 4319,
						[2594713821] = 7823,
						[2601481071] = 16227,
						[2732698467] = 4321,
						[2279783965] = 12578,
						[2374579381] = 10897,
						[2620496249] = 12577,
						[2594754338] = 7823,
						[2620483206] = 12577,
						[2137375605] = 10583,
						[1346588375] = 8019,
						[2374617930] = 10897,
						[1837350794] = 3841,
						[2072687206] = 4319,
						[1701806512] = 6706,
					},
					[1415] = {
						[2449691363] = 2835,
						[1857596454] = 352,
						[2235877022] = 12596,
						[2631088427] = 8609,
						[2204927976] = 2835,
						[1857573849] = 352,
						[2202714066] = 2409,
						[2108460836] = 1571,
						[2162573086] = 931,
						[2342203432] = 8609,
						[2181725427] = 1573,
						[1946644793] = 1571,
						[2004048048] = 2941,
						[2631124692] = 8609,
						[1749860647] = 523,
						[2493687439] = 2299,
						[2181726988] = 1573,
						[2128516468] = 8018,
						[2393787632] = 931,
						[2348695804] = 8018,
						[2184277688] = 2941,
						[2449714460] = 2835,
						[3006409125] = 12617,
						[2108453083] = 1571,
						[2235840865] = 12596,
						[2531427327] = 1572,
						[1760563784] = 2859,
						[2055621804] = 2432,
						[2184286535] = 2941,
						[2002151442] = 1573,
						[1749827288] = 523,
						[2017998198] = 2409,
						[3006453338] = 12617,
						[2626332446] = 12617,
						[2531425280] = 1572,
						[1862659661] = 2859,
						[2238204052] = 2299,
						[1756775513] = 352,
						[2348728067] = 8018,
						[2266784445] = 1572,
						[1906740379] = 2432,
						[1862603186] = 2859,
						[2043124534] = 12596,
						[2055648083] = 2432,
						[2493667696] = 2299,
						[2393813775] = 931,
						[2202681389] = 2409,
					},
				}
	}
		end
		local faction = UnitFactionGroup("player")
		return DugisFlightmasterLookupTable[faction]
	end
	

	function TaxiData:Load()
	end
	
	function TaxiData:Unload()
	end
    
    function TaxiData:IsFerryMaster(npcId)
        local ferryMastersList = {
        } 
        
        return npcId and ferryMastersList[npcId]
    end
	
end
