--[[
Name: LibBabble-Faction-3.0
Revision: $Rev: 230 $
Maintainers: ckknight, nevcairiel, Ackis
Website: http://www.wowace.com/projects/libbabble-faction-3-0/
Dependencies: None
License: MIT
]]

local MAJOR_VERSION = "LibBabble-Faction-3.0"
local MINOR_VERSION = 90000 + tonumber(("$Rev: 230 $"):match("%d+"))

if not LibStub then error(MAJOR_VERSION .. " requires LibStub.") end
local lib = LibStub("LibBabble-3.0"):New(MAJOR_VERSION, MINOR_VERSION)
if not lib then return end

local GAME_LOCALE = GetLocale()

lib:SetBaseTranslations {
	["7th Legion"] = "7th Legion",
	["7th Legion (Paragon)"] = "7th Legion (Paragon)",
	["Acquaintance"] = "Acquaintance",
	["Aeda Brightdawn"] = "Aeda Brightdawn",
	["Akama's Trust"] = "Akama's Trust",
	["Akule Riverhorn"] = "Akule Riverhorn",
	["Alexandros Mograine"] = "Alexandros Mograine",
	["Alliance"] = "Alliance",
	["Alliance Vanguard"] = "Alliance Vanguard",
	["Arakkoa Outcasts"] = "Arakkoa Outcasts",
	["Arcane Thirst (Oculeth)"] = "Arcane Thirst (Oculeth)",
	["Arcane Thirst (Thalyssra)"] = "Arcane Thirst (Thalyssra)",
	["Arcane Thirst (Valtrois)"] = "Arcane Thirst (Valtrois)",
	["Argent Crusade"] = "Argent Crusade",
	["Argent Dawn"] = "Argent Dawn",
	["Argussian Reach"] = "Argussian Reach",
	["Argussian Reach (Paragon)"] = "Argussian Reach (Paragon)",
	["Armies of Legionfall"] = "Armies of Legionfall",
	["Armies of Legionfall (Paragon)"] = "Armies of Legionfall (Paragon)",
	["Army of the Light"] = "Army of the Light",
	["Army of the Light (Paragon)"] = "Army of the Light (Paragon)",
	["Ashtongue Deathsworn"] = "Ashtongue Deathsworn",
	["Avengers of Hyjal"] = "Avengers of Hyjal",
	["Baradin's Wardens"] = "Baradin's Wardens",
	["Baroness Vashj"] = "Baroness Vashj",
	["Barracks Bodyguards"] = "Barracks Bodyguards",
	["Best Friend"] = "Best Friend",
	["Bilgewater Cartel"] = "Bilgewater Cartel",
	["Bizmo's Brawlpub"] = "Bizmo's Brawlpub",
	["Bizmo's Brawlpub (Season 1)"] = "Bizmo's Brawlpub (Season 1)",
	["Bizmo's Brawlpub (Season 2)"] = "Bizmo's Brawlpub (Season 2)",
	["Bizmo's Brawlpub (Season 3)"] = "Bizmo's Brawlpub (Season 3)",
	["Bladesman Inowari"] = "Bladesman Inowari",
	["Bloodsail Buccaneers"] = "Bloodsail Buccaneers",
	["Booty Bay"] = "Booty Bay",
	["Brawl'gar Arena"] = "Brawl'gar Arena",
	["Brawl'gar Arena (Season 1)"] = "Brawl'gar Arena (Season 1)",
	["Brawl'gar Arena (Season 2)"] = "Brawl'gar Arena (Season 2)",
	["Brawl'gar Arena (Season 3)"] = "Brawl'gar Arena (Season 3)",
	["Brood of Nozdormu"] = "Brood of Nozdormu",
	["Buddy"] = "Buddy",
	["Cenarion Circle"] = "Cenarion Circle",
	["Cenarion Expedition"] = "Cenarion Expedition",
	["Champions of Azeroth"] = "Champions of Azeroth",
	["Champions of Azeroth (Paragon)"] = "Champions of Azeroth (Paragon)",
	["Chee Chee"] = "Chee Chee",
	["Choofa"] = "Choofa",
	["Chromie"] = "Chromie",
	["Conjurer Margoss"] = "Conjurer Margoss",
	["Corbyn"] = "Corbyn",
	["Council of Exarchs"] = "Council of Exarchs",
	["Court of Farondis"] = "Court of Farondis",
	["Court of Farondis (Paragon)"] = "Court of Farondis (Paragon)",
	["Court of Harvesters"] = "Court of Harvesters",
	["Court of Harvesters (Paragon)"] = "Court of Harvesters (Paragon)",
	["Court of Night"] = "Court of Night",
	["Cryptkeeper Kassir"] = "Cryptkeeper Kassir",
	["Darkmoon Faire"] = "Darkmoon Faire",
	["Darkspear Rebellion"] = "Darkspear Rebellion",
	["Darkspear Trolls"] = "Darkspear Trolls",
	["Darnassus"] = "Darnassus",
	["Defender Illona"] = "Defender Illona",
	["Delvar Ironfist"] = "Delvar Ironfist",
	["Dominance Offensive"] = "Dominance Offensive",
	["Dragonmaw Clan"] = "Dragonmaw Clan",
	["Dreamweavers"] = "Dreamweavers",
	["Dreamweavers (Paragon)"] = "Dreamweavers (Paragon)",
	["Droman Aliothe"] = "Droman Aliothe",
	["Ella"] = "Ella",
	["Emperor Shaohao"] = "Emperor Shaohao",
	["Everlook"] = "Everlook",
	["Exalted"] = "Exalted",
	["Exodar"] = "Exodar",
	["Explorers' League"] = "Explorers' League",
	["Farmer Fung"] = "Farmer Fung",
	["Farseer Ori"] = "Farseer Ori",
	["Fish Fellreed"] = "Fish Fellreed",
	["Forest Hozen"] = "Forest Hozen",
	["Frenzyheart Tribe"] = "Frenzyheart Tribe",
	["Friend"] = "Friend",
	["Friendly"] = "Friendly",
	["Frostwolf Clan"] = "Frostwolf Clan",
	["Frostwolf Orcs"] = "Frostwolf Orcs",
	["Gadgetzan"] = "Gadgetzan",
	["Gelkis Clan Centaur"] = "Gelkis Clan Centaur",
	["Gilnean Survivors"] = "Gilnean Survivors",
	["Gilneas"] = "Gilneas",
	["Gina Mudclaw"] = "Gina Mudclaw",
	["Gnomeregan"] = "Gnomeregan",
	["Gnomeregan Exiles"] = "Gnomeregan Exiles",
	["Golden Lotus"] = "Golden Lotus",
	["Good Friend"] = "Good Friend",
	["Grandmaster Vole"] = "Grandmaster Vole",
	["Guardians of Hyjal"] = "Guardians of Hyjal",
	["Guild"] = "Guild",
	["Hand of the Prophet"] = "Hand of the Prophet",
	["Haohan Mudclaw"] = "Haohan Mudclaw",
	["Hellscream's Reach"] = "Hellscream's Reach",
	["Highmountain Tribe"] = "Highmountain Tribe",
	["Highmountain Tribe (Paragon)"] = "Highmountain Tribe (Paragon)",
	["Honeyback Hive"] = "Honeyback Hive",
	["Honor Hold"] = "Honor Hold",
	["Honored"] = "Honored",
	["Horde"] = "Horde",
	["Horde Expedition"] = "Horde Expedition",
	["Hunt-Captain Korayn"] = "Hunt-Captain Korayn",
	["Hunter Akana"] = "Hunter Akana",
	["Huojin Pandaren"] = "Huojin Pandaren",
	["Hydraxian Waterlords"] = "Hydraxian Waterlords",
	["Illidari"] = "Illidari",
	["Ilyssia of the Waters"] = "Ilyssia of the Waters",
	["Impus"] = "Impus",
	["Ironforge"] = "Ironforge",
	["Jandvik Vrykul"] = "Jandvik Vrykul",
	["Jogu the Drunk"] = "Jogu the Drunk",
	["Keeper Raynae"] = "Keeper Raynae",
	["Keepers of Time"] = "Keepers of Time",
	["Kirin Tor"] = "Kirin Tor",
	["Kirin Tor Offensive"] = "Kirin Tor Offensive",
	["Kleia and Pelagos"] = "Kleia and Pelagos",
	["Knights of the Ebon Blade"] = "Knights of the Ebon Blade",
	["Kurenai"] = "Kurenai",
	["Lady Moonberry"] = "Lady Moonberry",
	["Laughing Skull Orcs"] = "Laughing Skull Orcs",
	["Leorajh"] = "Leorajh",
	["Lower City"] = "Lower City",
	["Magram Clan Centaur"] = "Magram Clan Centaur",
	["Marasmius"] = "Marasmius",
	["Mikanikos"] = "Mikanikos",
	["Moon Guard"] = "Moon Guard",
	["Moonguard"] = "Moonguard",
	["Nat Pagle"] = "Nat Pagle",
	["Neri Sharpfin"] = "Neri Sharpfin",
	["Netherwing"] = "Netherwing",
	["Neutral"] = "Neutral",
	["Night Fae"] = "Night Fae",
	["Nomi"] = "Nomi",
	["Ogri'la"] = "Ogri'la",
	["Old Hillpaw"] = "Old Hillpaw",
	["Operation: Aardvark"] = "Operation: Aardvark",
	["Operation: Shieldwall"] = "Operation: Shieldwall",
	["Order of Embers"] = "Order of Embers",
	["Order of Embers (Paragon)"] = "Order of Embers (Paragon)",
	["Order of the Awakened"] = "Order of the Awakened",
	["Order of the Cloud Serpent"] = "Order of the Cloud Serpent",
	["Orgrimmar"] = "Orgrimmar",
	["Pearlfin Jinyu"] = "Pearlfin Jinyu",
	["Plague Deviser Marileth"] = "Plague Deviser Marileth",
	["Poen Gillbrack"] = "Poen Gillbrack",
	["Polemarch Adrestes"] = "Polemarch Adrestes",
	["Proudmoore Admiralty"] = "Proudmoore Admiralty",
	["Proudmoore Admiralty (Paragon)"] = "Proudmoore Admiralty (Paragon)",
	["Rajani"] = "Rajani",
	["Rajani (Paragon)"] = "Rajani (Paragon)",
	["Ramkahen"] = "Ramkahen",
	["Rank 1"] = "Rank 1",
	["Rank 2"] = "Rank 2",
	["Rank 3"] = "Rank 3",
	["Rank 4"] = "Rank 4",
	["Rank 5"] = "Rank 5",
	["Rank 6"] = "Rank 6",
	["Rank 7"] = "Rank 7",
	["Rank 8"] = "Rank 8",
	["Ratchet"] = "Ratchet",
	["Ravenholdt"] = "Ravenholdt",
	["Rendle and Cudgelface"] = "Rendle and Cudgelface",
	["Revered"] = "Revered",
	["Rustbolt Resistance"] = "Rustbolt Resistance",
	["Rustbolt Resistance (Paragon)"] = "Rustbolt Resistance (Paragon)",
	["Shado-Pan"] = "Shado-Pan",
	["Shado-Pan Assault"] = "Shado-Pan Assault",
	["Shadowmoon Exiles"] = "Shadowmoon Exiles",
	["Sha'leth"] = "Sha'leth",
	["Shang Xi's Academy"] = "Shang Xi's Academy",
	["Sha'tari Defense"] = "Sha'tari Defense",
	["Sha'tari Skyguard"] = "Sha'tari Skyguard",
	["Shattered Sun Offensive"] = "Shattered Sun Offensive",
	["Shen'dralar"] = "Shen'dralar",
	["Sho"] = "Sho",
	["Sika"] = "Sika",
	["Silvermoon City"] = "Silvermoon City",
	["Silverwing Sentinels"] = "Silverwing Sentinels",
	["Sporeggar"] = "Sporeggar",
	["Steamwheedle Draenor Expedition"] = "Steamwheedle Draenor Expedition",
	["Steamwheedle Preservation Society"] = "Steamwheedle Preservation Society",
	["Stitchmasters"] = "Stitchmasters",
	["Stonehead"] = "Stonehead",
	["Stormpike Guard"] = "Stormpike Guard",
	["Storm's Wake"] = "Storm's Wake",
	["Storm's Wake (Paragon)"] = "Storm's Wake (Paragon)",
	["Stormwind"] = "Stormwind",
	["Stranger"] = "Stranger",
	["Sunreaver Onslaught"] = "Sunreaver Onslaught",
	["Syndicate"] = "Syndicate",
	["Talanji's Expedition"] = "Talanji's Expedition",
	["Talanji's Expedition (Paragon)"] = "Talanji's Expedition (Paragon)",
	["Talonpriest Ishaal"] = "Talonpriest Ishaal",
	["Talon's Vengeance"] = "Talon's Vengeance",
	["The Aldor"] = "The Aldor",
	["The Anglers"] = "The Anglers",
	["The Ascended"] = "The Ascended",
	["The Ascended (Paragon)"] = "The Ascended (Paragon)",
	["The Ashen Verdict"] = "The Ashen Verdict",
	["The August Celestials"] = "The August Celestials",
	["The Avowed"] = "The Avowed",
	["The Black Prince"] = "The Black Prince",
	["The Brewmasters"] = "The Brewmasters",
	["The Consortium"] = "The Consortium",
	["The Countess"] = "The Countess",
	["The Defilers"] = "The Defilers",
	["The Earthen Ring"] = "The Earthen Ring",
	["The Ember Court"] = "The Ember Court",
	["The First Responders"] = "The First Responders",
	["The Frostborn"] = "The Frostborn",
	["The Hand of Vengeance"] = "The Hand of Vengeance",
	["The Honorbound"] = "The Honorbound",
	["The Honorbound (Paragon)"] = "The Honorbound (Paragon)",
	["The Kalu'ak"] = "The Kalu'ak",
	["The Klaxxi"] = "The Klaxxi",
	["The League of Arathor"] = "The League of Arathor",
	["The Lorewalkers"] = "The Lorewalkers",
	["The Mag'har"] = "The Mag'har",
	["The Nightfallen"] = "The Nightfallen",
	["The Nightfallen (Paragon)"] = "The Nightfallen (Paragon)",
	["The Oracles"] = "The Oracles",
	["The Saberstalkers"] = "The Saberstalkers",
	["The Scale of the Sands"] = "The Scale of the Sands",
	["The Scryers"] = "The Scryers",
	["The Sha'tar"] = "The Sha'tar",
	["The Silver Covenant"] = "The Silver Covenant",
	["The Sons of Hodir"] = "The Sons of Hodir",
	["The Sunreavers"] = "The Sunreavers",
	["The Taunka"] = "The Taunka",
	["The Tillers"] = "The Tillers",
	["The Undying Army"] = "The Undying Army",
	["The Undying Army (Paragon)"] = "The Undying Army (Paragon)",
	["The Unshackled"] = "The Unshackled",
	["The Unshackled (Paragon)"] = "The Unshackled (Paragon)",
	["The Violet Eye"] = "The Violet Eye",
	["The Wardens"] = "The Wardens",
	["The Wardens (Paragon)"] = "The Wardens (Paragon)",
	["The Wild Hunt"] = "The Wild Hunt",
	["The Wild Hunt (Paragon)"] = "The Wild Hunt (Paragon)",
	["The Wyrmrest Accord"] = "The Wyrmrest Accord",
	["Therazane"] = "Therazane",
	["Thorium Brotherhood"] = "Thorium Brotherhood",
	["Thrallmar"] = "Thrallmar",
	["Thunder Bluff"] = "Thunder Bluff",
	["Timbermaw Hold"] = "Timbermaw Hold",
	["Tina Mudclaw"] = "Tina Mudclaw",
	["Tormmok"] = "Tormmok",
	["Tortollan Seekers"] = "Tortollan Seekers",
	["Tortollan Seekers (Paragon)"] = "Tortollan Seekers (Paragon)",
	["Tranquillien"] = "Tranquillien",
	["Tushui Pandaren"] = "Tushui Pandaren",
	["Uldum Accord"] = "Uldum Accord",
	["Uldum Accord (Paragon)"] = "Uldum Accord (Paragon)",
	["Undercity"] = "Undercity",
	["Valarjar"] = "Valarjar",
	["Valarjar (Paragon)"] = "Valarjar (Paragon)",
	["Valiance Expedition"] = "Valiance Expedition",
	["Ve'nari"] = "Ve'nari",
	["Vim Brineheart"] = "Vim Brineheart",
	["Vivianne"] = "Vivianne",
	["Voldunai"] = "Voldunai",
	["Voldunai (Paragon)"] = "Voldunai (Paragon)",
	["Vol'jin's Headhunters"] = "Vol'jin's Headhunters",
	["Vol'jin's Spear"] = "Vol'jin's Spear",
	["Warsong Offensive"] = "Warsong Offensive",
	["Warsong Outriders"] = "Warsong Outriders",
	["Waveblade Ankoan"] = "Waveblade Ankoan",
	["Waveblade Ankoan (Paragon)"] = "Waveblade Ankoan (Paragon)",
	["Wildhammer Clan"] = "Wildhammer Clan",
	["Winterfin Retreat"] = "Winterfin Retreat",
	["Wintersaber Trainers"] = "Wintersaber Trainers",
	["Wrynn's Vanguard"] = "Wrynn's Vanguard",
	["Zandalar Tribe"] = "Zandalar Tribe",
	["Zandalari Empire"] = "Zandalari Empire",
	["Zandalari Empire (Paragon)"] = "Zandalari Empire (Paragon)"
}

if GAME_LOCALE == "enUS" then
	lib:SetCurrentTranslations(true)

elseif GAME_LOCALE == "deDE" then
	lib:SetCurrentTranslations {
	["7th Legion"] = "7. Legion",
	["7th Legion (Paragon)"] = "7. Legion (huldigend)",
	["Acquaintance"] = "Bekannter",
	["Aeda Brightdawn"] = "Aeda Morgenglanz",
	["Akama's Trust"] = "Akamas Vertrauen",
	["Akule Riverhorn"] = "Akule Flusshorn",
	["Alexandros Mograine"] = "Alexandros Mograine",
	["Alliance"] = "Allianz",
	["Alliance Vanguard"] = "Vorhut der Allianz",
	["Arakkoa Outcasts"] = "Ausgestoßene Arakkoa",
	["Arcane Thirst (Oculeth)"] = "Arkaner Durst (Oculeth)",
	["Arcane Thirst (Thalyssra)"] = "Arkaner Durst (Thalyssra)",
	["Arcane Thirst (Valtrois)"] = "Arkaner Durst (Valtrois)",
	["Argent Crusade"] = "Argentumkreuzzug",
	["Argent Dawn"] = "Argentumdämmerung",
	["Argussian Reach"] = "Der Argusvorstoß",
	--[[Translation missing --]]
	--[[ ["Argussian Reach (Paragon)"] = "Argussian Reach (Paragon)",--]] 
	["Armies of Legionfall"] = "Die Legionsrichter",
	["Armies of Legionfall (Paragon)"] = "Die Legionsrichter (huldigend)",
	["Army of the Light"] = "Armee des Lichts",
	--[[Translation missing --]]
	--[[ ["Army of the Light (Paragon)"] = "Army of the Light (Paragon)",--]] 
	["Ashtongue Deathsworn"] = "Die Todeshörigen",
	["Avengers of Hyjal"] = "Rächer des Hyjal",
	["Baradin's Wardens"] = "Wächter von Baradin",
	["Baroness Vashj"] = "Baronin Vashj",
	["Barracks Bodyguards"] = "Kasernenleibwächter",
	["Best Friend"] = "Bester Freund",
	["Bilgewater Cartel"] = "Bilgewasserkartell",
	["Bizmo's Brawlpub"] = "Bizmos Boxbar",
	["Bizmo's Brawlpub (Season 1)"] = "Bizmos Boxbar (Saison 1)",
	["Bizmo's Brawlpub (Season 2)"] = "Bizmos Boxbar (Saison 2)",
	["Bizmo's Brawlpub (Season 3)"] = "Bizmos Boxbar (Saison 3)",
	["Bladesman Inowari"] = "Klingenkämpfer Inowari",
	["Bloodsail Buccaneers"] = "Blutsegelbukaniere",
	["Booty Bay"] = "Beutebucht",
	["Brawl'gar Arena"] = "Shlae'gararena",
	["Brawl'gar Arena (Season 1)"] = "Shlae'gararena (Saison 1)",
	["Brawl'gar Arena (Season 2)"] = "Shlae'gararena (Saison 2)",
	["Brawl'gar Arena (Season 3)"] = "Shlae'gararena (Saison 3)",
	["Brood of Nozdormu"] = "Brut Nozdormus",
	["Buddy"] = "Kumpel",
	["Cenarion Circle"] = "Zirkel des Cenarius",
	["Cenarion Expedition"] = "Expedition des Cenarius",
	["Champions of Azeroth"] = "Champions von Azeroth",
	["Champions of Azeroth (Paragon)"] = "Champions von Azeroth (huldigend)",
	["Chee Chee"] = "Chi-Chi",
	["Choofa"] = "Choofa",
	["Chromie"] = "Chromie",
	["Conjurer Margoss"] = "Beschwörer Margoss",
	["Corbyn"] = "Corbyn",
	["Council of Exarchs"] = "Exarchenrat",
	["Court of Farondis"] = "Farondis' Hofstaat",
	["Court of Farondis (Paragon)"] = "Farondis' Hofstaat (huldigend)",
	["Court of Harvesters"] = "Hof der Ernter",
	["Court of Harvesters (Paragon)"] = "Hof der Ernter (huldigend)",
	["Court of Night"] = "Hof der Nacht",
	["Cryptkeeper Kassir"] = "Grufthüter Kassir",
	["Darkmoon Faire"] = "Dunkelmond-Jahrmarkt",
	["Darkspear Rebellion"] = "Rebellion der Dunkelspeere",
	["Darkspear Trolls"] = "Dunkelspeertrolle",
	["Darnassus"] = "Darnassus",
	["Defender Illona"] = "Beschützerin Illona",
	["Delvar Ironfist"] = "Delvar Eisenfaust",
	["Dominance Offensive"] = "Herrschaftsoffensive",
	["Dragonmaw Clan"] = "Drachenmalklan",
	["Dreamweavers"] = "Die Traumweber",
	["Dreamweavers (Paragon)"] = "Die Traumweber (huldigend)",
	["Droman Aliothe"] = "Dromanin Aliothe",
	["Ella"] = "Ella",
	["Emperor Shaohao"] = "Kaiser Shaohao",
	["Everlook"] = "Ewige Warte",
	["Exalted"] = "Ehrfürchtig",
	["Exodar"] = "Die Exodar",
	["Explorers' League"] = "Forscherliga",
	["Farmer Fung"] = "Bauer Fung",
	["Farseer Ori"] = "Scharfseher Ori",
	["Fish Fellreed"] = "Fischi Rohrroder",
	["Forest Hozen"] = "Wald-Ho-zen",
	["Frenzyheart Tribe"] = "Stamm der Wildherzen",
	["Friend"] = "Freund",
	["Friendly"] = "Freundlich",
	["Frostwolf Clan"] = "Frostwolfklan",
	["Frostwolf Orcs"] = "Frostwolforcs",
	["Gadgetzan"] = "Gadgetzan",
	["Gelkis Clan Centaur"] = "Gelkisklan",
	["Gilnean Survivors"] = "Gilnearischer Überlebender",
	["Gilneas"] = "Gilneas",
	["Gina Mudclaw"] = "Gina Lehmkrall",
	["Gnomeregan"] = "Gnomeregan",
	["Gnomeregan Exiles"] = "Gnomeregangnome",
	["Golden Lotus"] = "Goldener Lotus",
	["Good Friend"] = "Guter Freund",
	["Grandmaster Vole"] = "Großmeister Vole",
	["Guardians of Hyjal"] = "Wächter des Hyjal",
	["Guild"] = "Gilde",
	["Hand of the Prophet"] = "Hand des Propheten",
	["Haohan Mudclaw"] = "Haohan Lehmkrall",
	["Hellscream's Reach"] = "Höllschreis Hand",
	["Highmountain Tribe"] = "Der Hochbergstamm",
	["Highmountain Tribe (Paragon)"] = "Der Hochbergstamm (huldigend)",
	["Honeyback Hive"] = "Honigrückenschwarm",
	["Honor Hold"] = "Ehrenfeste",
	["Honored"] = "Wohlwollend",
	["Horde"] = "Horde",
	["Horde Expedition"] = "Expedition der Horde",
	["Hunt-Captain Korayn"] = "Jagdhauptmann Korayn",
	["Hunter Akana"] = "Jäger Akana",
	["Huojin Pandaren"] = "Die Huojin",
	["Hydraxian Waterlords"] = "Hydraxianer",
	["Illidari"] = "Illidari",
	["Ilyssia of the Waters"] = "Ilyssia von den Wassern",
	["Impus"] = "Wichtlus",
	["Ironforge"] = "Eisenschmiede",
	["Jandvik Vrykul"] = "Vrykul von Jandvik",
	["Jogu the Drunk"] = "Jogu der Betrunkene",
	["Keeper Raynae"] = "Hüterin Raynae",
	["Keepers of Time"] = "Hüter der Zeit",
	["Kirin Tor"] = "Kirin Tor",
	["Kirin Tor Offensive"] = "Offensive der Kirin Tor",
	["Kleia and Pelagos"] = "Kleia und Pelagos",
	["Knights of the Ebon Blade"] = "Ritter der Schwarzen Klinge",
	["Kurenai"] = "Kurenai",
	["Lady Moonberry"] = "Lady Mondbeere",
	["Laughing Skull Orcs"] = "Orcs des Lachenden Schädels",
	["Leorajh"] = "Leorajh",
	["Lower City"] = "Unteres Viertel",
	["Magram Clan Centaur"] = "Magramklan",
	["Marasmius"] = "Marasmius",
	["Mikanikos"] = "Mikanikos",
	["Moon Guard"] = "Mondwache",
	["Moonguard"] = "Mondwache",
	["Nat Pagle"] = "Nat Pagle",
	["Neri Sharpfin"] = "Neri Scharffinne",
	["Netherwing"] = "Netherschwingen",
	["Neutral"] = "Neutral",
	["Night Fae"] = "Nachtfae",
	["Nomi"] = "Nomi",
	["Ogri'la"] = "Ogri'la",
	["Old Hillpaw"] = "Der alte Hügelpranke",
	--[[Translation missing --]]
	--[[ ["Operation: Aardvark"] = "Operation: Aardvark",--]] 
	["Operation: Shieldwall"] = "Operation Schildwall",
	["Order of Embers"] = "Glutorden",
	["Order of Embers (Paragon)"] = "Glutorden (huldigend)",
	["Order of the Awakened"] = "Orden der Erwachten",
	["Order of the Cloud Serpent"] = "Orden der Wolkenschlange",
	["Orgrimmar"] = "Orgrimmar",
	["Pearlfin Jinyu"] = "Jinyu der Perlflossen",
	["Plague Deviser Marileth"] = "Seuchenerfinder Marileth",
	["Poen Gillbrack"] = "Poen Kiembrack",
	["Polemarch Adrestes"] = "Polemarch Adrestes",
	["Proudmoore Admiralty"] = "Prachtmeeradmiralität",
	["Proudmoore Admiralty (Paragon)"] = "Prachtmeeradmiralität (huldigend)",
	["Rajani"] = "Rajani",
	["Rajani (Paragon)"] = "Rajani (huldigend)",
	["Ramkahen"] = "Ramkahen",
	["Rank 1"] = "Rang 1",
	["Rank 2"] = "Rang 2",
	["Rank 3"] = "Rang 3",
	["Rank 4"] = "Rang 4",
	["Rank 5"] = "Rang 5",
	["Rank 6"] = "Rang 6",
	["Rank 7"] = "Rang 7",
	["Rank 8"] = "Rang 8",
	["Ratchet"] = "Ratschet",
	["Ravenholdt"] = "Rabenholdt",
	["Rendle and Cudgelface"] = "Rendel und Knüppelfratze",
	["Revered"] = "Respektvoll",
	["Rustbolt Resistance"] = "Rostbolzenwiderstand",
	["Rustbolt Resistance (Paragon)"] = "Rostbolzenwiderstand (huldigend)",
	["Shado-Pan"] = "Shado-Pan",
	["Shado-Pan Assault"] = "Shado-Pan-Vorstoß",
	["Shadowmoon Exiles"] = "Exilanten des Schattenmondklans",
	["Sha'leth"] = "Sha'leth",
	["Shang Xi's Academy"] = "Akademie des Shang Xi",
	["Sha'tari Defense"] = "Sha'tarverteidigung",
	["Sha'tari Skyguard"] = "Himmelswache der Sha'tari",
	["Shattered Sun Offensive"] = "Offensive der Zerschmetterten Sonne",
	["Shen'dralar"] = "Shen'dralar",
	["Sho"] = "Sho",
	["Sika"] = "Sika",
	["Silvermoon City"] = "Silbermond",
	["Silverwing Sentinels"] = "Silberschwingen",
	["Sporeggar"] = "Sporeggar",
	["Steamwheedle Draenor Expedition"] = "Draenorexpedition des Dampfdruckkartells",
	["Steamwheedle Preservation Society"] = "Werterhaltungsgesellschaft des Dampfdruckkartells",
	["Stitchmasters"] = "Flickmeister",
	["Stonehead"] = "Steinkopf",
	["Stormpike Guard"] = "Sturmlanzengarde",
	["Storm's Wake"] = "Die Sturmwacht",
	["Storm's Wake (Paragon)"] = "Die Sturmwacht (huldigend)",
	["Stormwind"] = "Sturmwind",
	["Stranger"] = "Fremder",
	["Sunreaver Onslaught"] = "Sonnenhäscheransturm",
	["Syndicate"] = "Syndikat",
	["Talanji's Expedition"] = "Talanjis Expedition",
	["Talanji's Expedition (Paragon)"] = "Talanjis Expedition (huldigend)",
	["Talonpriest Ishaal"] = "Krallenpriester Ishaal",
	["Talon's Vengeance"] = "Rache der Kralle",
	["The Aldor"] = "Die Aldor",
	["The Anglers"] = "Die Angler",
	["The Ascended"] = "Die Aufgestiegenen",
	["The Ascended (Paragon)"] = "Die Aufgestiegenen (huldigend)",
	["The Ashen Verdict"] = "Das Äscherne Verdikt",
	["The August Celestials"] = "Die Himmlischen Erhabenen",
	["The Avowed"] = "Die Eingeschworenen",
	["The Black Prince"] = "Der Schwarze Prinz",
	["The Brewmasters"] = "Die Braumeister",
	["The Consortium"] = "Das Konsortium",
	["The Countess"] = "Die Gräfin",
	["The Defilers"] = "Die Entweihten",
	["The Earthen Ring"] = "Der Irdene Ring",
	["The Ember Court"] = "Der Gluthof",
	["The First Responders"] = "Die Ersthelfer",
	["The Frostborn"] = "Die Frosterben",
	["The Hand of Vengeance"] = "Die Hand der Rache",
	["The Honorbound"] = "Die Eidgebundenen",
	["The Honorbound (Paragon)"] = "Die Eidgebundenen (huldigend)",
	["The Kalu'ak"] = "Die Kalu'ak",
	["The Klaxxi"] = "Die Klaxxi",
	["The League of Arathor"] = "Der Bund von Arathor",
	["The Lorewalkers"] = "Die Lehrensucher",
	["The Mag'har"] = "Die Mag'har",
	["The Nightfallen"] = "Die Nachtsüchtigen",
	["The Nightfallen (Paragon)"] = "Die Nachtsüchtigen (huldigend)",
	["The Oracles"] = "Die Orakel",
	["The Saberstalkers"] = "Die Säbelzahnpirscher",
	["The Scale of the Sands"] = "Die Wächter der Sande",
	["The Scryers"] = "Die Seher",
	["The Sha'tar"] = "Die Sha'tar",
	["The Silver Covenant"] = "Der Silberbund",
	["The Sons of Hodir"] = "Die Söhne Hodirs",
	["The Sunreavers"] = "Die Sonnenhäscher",
	["The Taunka"] = "Die Taunka",
	["The Tillers"] = "Die Ackerbauern",
	["The Undying Army"] = "Die Unvergängliche Armee",
	["The Undying Army (Paragon)"] = "Die Uvergängliche Armee (huldigend)",
	["The Unshackled"] = "Die Entfesselten",
	["The Unshackled (Paragon)"] = "Die Entfesselten (huldigend)",
	["The Violet Eye"] = "Das Violette Auge",
	["The Wardens"] = "Die Wächterinnen",
	["The Wardens (Paragon)"] = "Die Wächterinnen (huldigend)",
	["The Wild Hunt"] = "Die Wilde Jagd",
	["The Wild Hunt (Paragon)"] = "Die Wilde Jagd (huldigend)",
	["The Wyrmrest Accord"] = "Der Wyrmruhpakt",
	["Therazane"] = "Therazane",
	["Thorium Brotherhood"] = "Thoriumbruderschaft",
	["Thrallmar"] = "Thrallmar",
	["Thunder Bluff"] = "Donnerfels",
	["Timbermaw Hold"] = "Holzschlundfeste",
	["Tina Mudclaw"] = "Tina Lehmkrall",
	["Tormmok"] = "Tormmok",
	["Tortollan Seekers"] = "Tortollanische Sucher",
	["Tortollan Seekers (Paragon)"] = "Tortollanische Sucher (huldigend)",
	["Tranquillien"] = "Tristessa",
	["Tushui Pandaren"] = "Die Tushui",
	["Uldum Accord"] = "Abkommen von Uldum",
	["Uldum Accord (Paragon)"] = "Abkommen von Uldum (huldigend)",
	["Undercity"] = "Unterstadt",
	["Valarjar"] = "Valarjar",
	["Valarjar (Paragon)"] = "Valarjar (huldigend)",
	["Valiance Expedition"] = "Expedition Valianz",
	["Ve'nari"] = "Ve'nari",
	["Vim Brineheart"] = "Vim Salzherz",
	["Vivianne"] = "Vivianne",
	["Voldunai"] = "Voldunai",
	["Voldunai (Paragon)"] = "Voldunai (huldigend)",
	["Vol'jin's Headhunters"] = "Vol'jins Kopfjäger",
	["Vol'jin's Spear"] = "Vol'jins Speer",
	["Warsong Offensive"] = "Kriegshymnenoffensive",
	["Warsong Outriders"] = "Kriegshymnenklan",
	["Waveblade Ankoan"] = "Ankoaner der Meeresklinge",
	["Waveblade Ankoan (Paragon)"] = "Ankoaner der Meeresklinge (huldigend)",
	["Wildhammer Clan"] = "Wildhammerklan",
	["Winterfin Retreat"] = "Zuflucht der Winterflossen",
	["Wintersaber Trainers"] = "Wintersäblerausbilder",
	["Wrynn's Vanguard"] = "Wrynns Vorhut",
	["Zandalar Tribe"] = "Stamm der Zandalari",
	["Zandalari Empire"] = "Zandalariimperium",
	["Zandalari Empire (Paragon)"] = "Zandalariimperium (huldigend)"
}
elseif GAME_LOCALE == "frFR" then
	lib:SetCurrentTranslations {
	["7th Legion"] = "7e Légion",
	["7th Legion (Paragon)"] = "7e Légion (parangon)",
	["Acquaintance"] = "Connaissance",
	["Aeda Brightdawn"] = "Aeda Brillaube",
	["Akama's Trust"] = "Confiance d’Akama",
	["Akule Riverhorn"] = "Akule Ruissecorne",
	["Alexandros Mograine"] = "Alexandros Mograine",
	["Alliance"] = "Alliance",
	["Alliance Vanguard"] = "Avant-garde de l'Alliance",
	["Arakkoa Outcasts"] = "Parias arakkoa",
	["Arcane Thirst (Oculeth)"] = "Soif des Arcanes (Oculeth)",
	["Arcane Thirst (Thalyssra)"] = "Soif des Arcanes (Thalyssra)",
	["Arcane Thirst (Valtrois)"] = "Soif des Arcanes (Valtrois)",
	["Argent Crusade"] = "Croisade d'argent",
	["Argent Dawn"] = "Aube d'argent",
	["Argussian Reach"] = "Front argusséen",
	--[[Translation missing --]]
	--[[ ["Argussian Reach (Paragon)"] = "Argussian Reach (Paragon)",--]] 
	["Armies of Legionfall"] = "Armées du Déclin de la Légion",
	["Armies of Legionfall (Paragon)"] = "Armées du Déclin de la Légion (parangon)",
	["Army of the Light"] = "Armée de la Lumière",
	--[[Translation missing --]]
	--[[ ["Army of the Light (Paragon)"] = "Army of the Light (Paragon)",--]] 
	["Ashtongue Deathsworn"] = "Ligemort cendrelangue",
	["Avengers of Hyjal"] = "Vengeurs d’Hyjal",
	["Baradin's Wardens"] = "Gardiens de Baradin",
	["Baroness Vashj"] = "Baronne Vashj",
	["Barracks Bodyguards"] = "Gardes du corps de caserne",
	["Best Friend"] = "Meilleur ami",
	["Bilgewater Cartel"] = "Cartel Baille-Fonds",
	["Bizmo's Brawlpub"] = "Bar-Tabasse de Bizmo",
	["Bizmo's Brawlpub (Season 1)"] = "Bar-Tabasse de Bizmo (saison 1)",
	["Bizmo's Brawlpub (Season 2)"] = "Bar-Tabasse de Bizmo (saison 2)",
	["Bizmo's Brawlpub (Season 3)"] = "Bar-Tabasse de Bizmo (saison 3)",
	["Bladesman Inowari"] = "Maître-lame Inowari",
	["Bloodsail Buccaneers"] = "La Voile sanglante",
	["Booty Bay"] = "Baie-du-Butin",
	["Brawl'gar Arena"] = "Arène de Castagn’ar",
	["Brawl'gar Arena (Season 1)"] = "Arène de Castagn’ar (saison 1)",
	["Brawl'gar Arena (Season 2)"] = "Arène de Castagn’ar (saison 2)",
	["Brawl'gar Arena (Season 3)"] = "Arène de Castagn’ar (saison 3)",
	["Brood of Nozdormu"] = "Progéniture de Nozdormu",
	["Buddy"] = "Camarade",
	["Cenarion Circle"] = "Cercle cénarien",
	["Cenarion Expedition"] = "Expédition cénarienne",
	["Champions of Azeroth"] = "Champions d’Azeroth",
	["Champions of Azeroth (Paragon)"] = "Champions d’Azeroth (parangon)",
	["Chee Chee"] = "Chii Chii",
	["Choofa"] = "Choufa",
	["Chromie"] = "Chromie",
	["Conjurer Margoss"] = "Adjurateur Margoss",
	["Corbyn"] = "Corbyn",
	["Council of Exarchs"] = "Conseil des exarques",
	["Court of Farondis"] = "Cour de Farondis",
	["Court of Farondis (Paragon)"] = "Cour de Farondis (parangon)",
	["Court of Harvesters"] = "Cour des Moissonneurs",
	["Court of Harvesters (Paragon)"] = "Cour des Moissonneurs (parangon)",
	["Court of Night"] = "Cour de la Nuit",
	["Cryptkeeper Kassir"] = "Gardien de la crypte Kassir",
	["Darkmoon Faire"] = "Foire de Sombrelune",
	["Darkspear Rebellion"] = "Rébellion sombrelance",
	["Darkspear Trolls"] = "Trolls sombrelances",
	["Darnassus"] = "Darnassus",
	["Defender Illona"] = "Défenseur Illona",
	["Delvar Ironfist"] = "Delvar Poing-de-Fer",
	["Dominance Offensive"] = "Offensive Domination",
	["Dragonmaw Clan"] = "Clan Gueule-de-dragon",
	["Dreamweavers"] = "Tisse-Rêves",
	["Dreamweavers (Paragon)"] = "Tisse-Rêves (parangon)",
	["Droman Aliothe"] = "Dromane Aliothe",
	["Ella"] = "Ella",
	["Emperor Shaohao"] = "Empereur Shaohao",
	["Everlook"] = "Long-Guet",
	["Exalted"] = "Exalté",
	["Exodar"] = "Exodar",
	["Explorers' League"] = "Ligue des explorateurs",
	["Farmer Fung"] = "Fermier Fung",
	["Farseer Ori"] = "Long-voyant Ori",
	["Fish Fellreed"] = "Marée Pelage de Roseau",
	["Forest Hozen"] = "Hozen des forêts",
	["Frenzyheart Tribe"] = "Tribu Frénécœur",
	["Friend"] = "Ami",
	["Friendly"] = "Amical",
	["Frostwolf Clan"] = "Clan Loup-de-Givre",
	["Frostwolf Orcs"] = "Orcs loups-de-givre",
	["Gadgetzan"] = "Gadgetzan",
	["Gelkis Clan Centaur"] = "Centaures (Gelkis)",
	["Gilnean Survivors"] = "Survivants gilnéens",
	["Gilneas"] = "Gilnéas",
	["Gina Mudclaw"] = "Gina Griffe de Tourbe",
	["Gnomeregan"] = "Gnomeregan",
	["Gnomeregan Exiles"] = "Exilés de Gnomeregan",
	["Golden Lotus"] = "Lotus doré",
	["Good Friend"] = "Bon ami",
	["Grandmaster Vole"] = "Grand maître Vole",
	["Guardians of Hyjal"] = "Gardiens d'Hyjal",
	["Guild"] = "Guilde",
	["Hand of the Prophet"] = "Main du prophète",
	["Haohan Mudclaw"] = "Haohan Griffe de Tourbe",
	["Hellscream's Reach"] = "Poing de Hurlenfer",
	["Highmountain Tribe"] = "Tribu de Haut-Roc",
	["Highmountain Tribe (Paragon)"] = "Tribu de Haut-Roc (parangon)",
	["Honeyback Hive"] = "Essaim Dos-de-Miel",
	["Honor Hold"] = "Bastion de l'Honneur",
	["Honored"] = "Honoré",
	["Horde"] = "Horde",
	["Horde Expedition"] = "Expédition de la Horde",
	["Hunt-Captain Korayn"] = "Capitaine de l’Hallali Korayn",
	["Hunter Akana"] = "Chasseur Akana",
	["Huojin Pandaren"] = "Pandarens huojin",
	["Hydraxian Waterlords"] = "Hydraxiens",
	["Illidari"] = "Illidari",
	["Ilyssia of the Waters"] = "Ilyssia des Eaux",
	["Impus"] = "Diablotus",
	["Ironforge"] = "Forgefer",
	["Jandvik Vrykul"] = "Vrykuls de Jandvik",
	["Jogu the Drunk"] = "Jogu l’Ivrogne",
	["Keeper Raynae"] = "Gardienne Raynae",
	["Keepers of Time"] = "Gardiens du Temps",
	["Kirin Tor"] = "Kirin Tor",
	["Kirin Tor Offensive"] = "Offensive du Kirin Tor",
	["Kleia and Pelagos"] = "Kléia et Pélagos",
	["Knights of the Ebon Blade"] = "Chevaliers de la Lame d'ébène",
	["Kurenai"] = "Kurenaï",
	["Lady Moonberry"] = "Dame Baie-de-Lune",
	["Laughing Skull Orcs"] = "Orcs du Crâne-Ricanant",
	["Leorajh"] = "Leorajh",
	["Lower City"] = "Ville basse",
	["Magram Clan Centaur"] = "Centaures (Magram)",
	["Marasmius"] = "Marasmius",
	["Mikanikos"] = "Mikanikos",
	["Moon Guard"] = "Garde de la Lune",
	["Moonguard"] = "Garde de la Lune",
	["Nat Pagle"] = "Nat Pagle",
	["Neri Sharpfin"] = "Néri Tranchécaille",
	["Netherwing"] = "Aile-du-Néant",
	["Neutral"] = "Neutre",
	["Night Fae"] = "Faë nocturnes",
	["Nomi"] = "Nomi",
	["Ogri'la"] = "Ogri'la",
	["Old Hillpaw"] = "Vieux Patte des Hauts",
	["Operation: Aardvark"] = "Opération Fourmilier",
	["Operation: Shieldwall"] = "Opération Bouclier",
	["Order of Embers"] = "Ordre des Braises",
	["Order of Embers (Paragon)"] = "Ordre des Braises (parangon)",
	["Order of the Awakened"] = "Ordre des Éveillés",
	["Order of the Cloud Serpent"] = "L’ordre du Serpent-nuage",
	["Orgrimmar"] = "Orgrimmar",
	["Pearlfin Jinyu"] = "Jinyu de Nageperle",
	["Plague Deviser Marileth"] = "Marileth, catalyseur de peste",
	["Poen Gillbrack"] = "Poën Seldemer",
	["Polemarch Adrestes"] = "Marchedroit Adrestès",
	["Proudmoore Admiralty"] = "Amirauté des Portvaillant",
	["Proudmoore Admiralty (Paragon)"] = "Amirauté des Portvaillant (parangon)",
	["Rajani"] = "Rajani",
	["Rajani (Paragon)"] = "Rajani (parangon)",
	["Ramkahen"] = "Ramkahen",
	["Rank 1"] = "Rang 1",
	["Rank 2"] = "Rang 2",
	["Rank 3"] = "Rang 3",
	["Rank 4"] = "Rang 4",
	["Rank 5"] = "Rang 5",
	["Rank 6"] = "Rang 6",
	["Rank 7"] = "Rang 7",
	["Rank 8"] = "Rang 8",
	["Ratchet"] = "Cabestan",
	["Ravenholdt"] = "Ravenholdt",
	["Rendle and Cudgelface"] = "Rondel et Férul",
	["Revered"] = "Révéré",
	["Rustbolt Resistance"] = "Résistance de Mécarouille",
	["Rustbolt Resistance (Paragon)"] = "Résistance de Mécarouille (parangon)",
	["Shado-Pan"] = "Pandashan",
	["Shado-Pan Assault"] = "Assaut des Pandashan",
	["Shadowmoon Exiles"] = "Exilés ombrelunes",
	["Sha'leth"] = "Sha’leth",
	["Shang Xi's Academy"] = "Académie de Shang Xi",
	["Sha'tari Defense"] = "Défense sha’tari",
	["Sha'tari Skyguard"] = "Garde-ciel sha'tari",
	["Shattered Sun Offensive"] = "Opération Soleil brisé",
	["Shen'dralar"] = "Shen'dralar",
	["Sho"] = "Sho",
	["Sika"] = "Sika",
	["Silvermoon City"] = "Lune-d’Argent",
	["Silverwing Sentinels"] = "Sentinelles d'Aile-argent",
	["Sporeggar"] = "Sporeggar",
	["Steamwheedle Draenor Expedition"] = "Expédition de Gentepression en Draenor",
	["Steamwheedle Preservation Society"] = "Société de Conservation de Gentepression",
	["Stitchmasters"] = "Maîtres des sutures",
	["Stonehead"] = "Tête-de-Caillasse",
	["Stormpike Guard"] = "Garde Foudrepique",
	["Storm's Wake"] = "Sillage des tempêtes",
	["Storm's Wake (Paragon)"] = "Sillage des tempêtes (parangon)",
	["Stormwind"] = "Hurlevent",
	["Stranger"] = "Etranger",
	["Sunreaver Onslaught"] = "Assaut des Saccage-Soleil",
	["Syndicate"] = "Syndicat",
	["Talanji's Expedition"] = "Expédition de Talanji",
	["Talanji's Expedition (Paragon)"] = "Expédition de Talanji (parangon)",
	["Talonpriest Ishaal"] = "Prêtre de la serre Ishaal",
	["Talon's Vengeance"] = "Serre vengeresse",
	["The Aldor"] = "L'Aldor",
	["The Anglers"] = "Hameçonneurs",
	["The Ascended"] = "Transcendés",
	["The Ascended (Paragon)"] = "Transcendés (parangon)",
	["The Ashen Verdict"] = "Verdict des cendres",
	["The August Celestials"] = "Astres vénérables",
	["The Avowed"] = "Les Confirmés",
	["The Black Prince"] = "Prince noir",
	["The Brewmasters"] = "Maîtres brasseurs",
	["The Consortium"] = "Consortium",
	["The Countess"] = "La comtesse",
	["The Defilers"] = "Profanateurs",
	["The Earthen Ring"] = "Cercle terrestre",
	["The Ember Court"] = "Cour des Braises",
	["The First Responders"] = "Guérisseuses",
	["The Frostborn"] = "Givre-nés",
	["The Hand of Vengeance"] = "Main de la vengeance",
	["The Honorbound"] = "Brigade de l’Honneur",
	["The Honorbound (Paragon)"] = "Brigade de l’Honneur (parangon)",
	["The Kalu'ak"] = "Kalu'aks",
	["The Klaxxi"] = "Klaxxi",
	["The League of Arathor"] = "Ligue d'Arathor",
	["The Lorewalkers"] = "Chroniqueurs",
	["The Mag'har"] = "Mag'har",
	["The Nightfallen"] = "Souffrenuit",
	["The Nightfallen (Paragon)"] = "Souffrenuit (parangon)",
	["The Oracles"] = "Oracles",
	["The Saberstalkers"] = "Traquesabres",
	["The Scale of the Sands"] = "Balance des sables",
	["The Scryers"] = "Clairvoyants",
	["The Sha'tar"] = "Sha'tar",
	["The Silver Covenant"] = "Concordat argenté",
	["The Sons of Hodir"] = "Fils de Hodir",
	["The Sunreavers"] = "Saccage-Soleil",
	["The Taunka"] = "Taunkas",
	["The Tillers"] = "Laboureurs",
	["The Undying Army"] = "Armée immortelle",
	["The Undying Army (Paragon)"] = "Armée immortelle (parangon)",
	["The Unshackled"] = "Affranchis",
	["The Unshackled (Paragon)"] = "Affranchis (parangon)",
	["The Violet Eye"] = "L'Œil pourpre",
	["The Wardens"] = "Gardiennes",
	["The Wardens (Paragon)"] = "Gardiennes (parangon)",
	["The Wild Hunt"] = "L’Hallali",
	["The Wild Hunt (Paragon)"] = "L’Hallali (parangon)",
	["The Wyrmrest Accord"] = "Accord du Repos du ver",
	["Therazane"] = "Therazane",
	["Thorium Brotherhood"] = "Confrérie du thorium",
	["Thrallmar"] = "Thrallmar",
	["Thunder Bluff"] = "Pitons-du-Tonnerre",
	["Timbermaw Hold"] = "Grumegueules",
	["Tina Mudclaw"] = "Tina Griffe de Tourbe",
	["Tormmok"] = "Tormmok",
	["Tortollan Seekers"] = "Chercheurs tortollans",
	["Tortollan Seekers (Paragon)"] = "Chercheurs tortollans (parangon)",
	["Tranquillien"] = "Tranquillien",
	["Tushui Pandaren"] = "Pandarens tushui",
	["Uldum Accord"] = "Accord d’Uldum",
	["Uldum Accord (Paragon)"] = "Accord d’Uldum (parangon)",
	["Undercity"] = "Fossoyeuse",
	["Valarjar"] = "Valarjar",
	["Valarjar (Paragon)"] = "Valarjar (parangon)",
	["Valiance Expedition"] = "Expédition de la Bravoure",
	["Ve'nari"] = "Ve’nari",
	["Vim Brineheart"] = "Vim Saumecœur",
	["Vivianne"] = "Vivianne",
	["Voldunai"] = "Volduni",
	["Voldunai (Paragon)"] = "Volduni (parangon)",
	["Vol'jin's Headhunters"] = "Chasseurs de têtes de Vol’jin",
	["Vol'jin's Spear"] = "Lance de Vol’jin",
	["Warsong Offensive"] = "Offensive chanteguerre",
	["Warsong Outriders"] = "Voltigeurs Chanteguerre",
	["Waveblade Ankoan"] = "Ankoïens du Brisant",
	["Waveblade Ankoan (Paragon)"] = "Ankoïens du Brisant (parangon)",
	["Wildhammer Clan"] = "Clan Marteau-Hardi",
	["Winterfin Retreat"] = "Retraite des Ailerons-d'hiver",
	["Wintersaber Trainers"] = "Éleveurs de sabres-d'hiver",
	["Wrynn's Vanguard"] = "Avant-garde de Wrynn",
	["Zandalar Tribe"] = "Tribu Zandalar",
	["Zandalari Empire"] = "Empire zandalari",
	["Zandalari Empire (Paragon)"] = "Empire zandalari (parangon)"
}
elseif GAME_LOCALE == "koKR" then
	lib:SetCurrentTranslations {
	["7th Legion"] = "7군단",
	["7th Legion (Paragon)"] = "7군단 (불멸의 동맹)",
	["Acquaintance"] = "지인",
	["Aeda Brightdawn"] = "에이다 브라이트돈",
	["Akama's Trust"] = "아카마의 믿음",
	["Akule Riverhorn"] = "아쿨레 리버혼",
	["Alexandros Mograine"] = "알렉산드로스 모그레인",
	["Alliance"] = "얼라이언스",
	["Alliance Vanguard"] = "얼라이언스 선봉대",
	["Arakkoa Outcasts"] = "추방된 아라코아",
	["Arcane Thirst (Oculeth)"] = "비전 갈증 (오큘레스)",
	["Arcane Thirst (Thalyssra)"] = "비전 갈증 (탈리스라)",
	["Arcane Thirst (Valtrois)"] = "비전 갈증 (발트와)",
	["Argent Crusade"] = "은빛십자군",
	["Argent Dawn"] = "은빛 여명회",
	["Argussian Reach"] = "아르거스 세력단",
	--[[Translation missing --]]
	--[[ ["Argussian Reach (Paragon)"] = "Argussian Reach (Paragon)",--]] 
	["Armies of Legionfall"] = "군단척결군",
	["Armies of Legionfall (Paragon)"] = "군단척결군 (불멸의 동맹)",
	["Army of the Light"] = "빛의 군대",
	--[[Translation missing --]]
	--[[ ["Army of the Light (Paragon)"] = "Army of the Light (Paragon)",--]] 
	["Ashtongue Deathsworn"] = "잿빛혓바닥 결사단",
	["Avengers of Hyjal"] = "하이잘의 복수자",
	["Baradin's Wardens"] = "바라딘 집행단",
	["Baroness Vashj"] = "남작 바쉬",
	["Barracks Bodyguards"] = "병영 경호원",
	["Best Friend"] = "가장 친한 친구",
	["Bilgewater Cartel"] = "빌지워터 무역회사",
	["Bizmo's Brawlpub"] = "비즈모의 싸움굴",
	["Bizmo's Brawlpub (Season 1)"] = "비즈모의 싸움굴 (1 시즌)",
	["Bizmo's Brawlpub (Season 2)"] = "비즈모의 싸움굴 (2 시즌)",
	["Bizmo's Brawlpub (Season 3)"] = "비즈모의 싸움굴 (3 시즌)",
	["Bladesman Inowari"] = "검객 이노와리",
	["Bloodsail Buccaneers"] = "붉은 해적단",
	["Booty Bay"] = "무법항",
	["Brawl'gar Arena"] = "싸울가르 투기장",
	["Brawl'gar Arena (Season 1)"] = "싸울가르 투기장 (1 시즌)",
	["Brawl'gar Arena (Season 2)"] = "싸울가르 투기장 (2 시즌)",
	["Brawl'gar Arena (Season 3)"] = "싸울가르 투기장 (3 시즌)",
	["Brood of Nozdormu"] = "노즈도르무 혈족",
	["Buddy"] = "동료",
	["Cenarion Circle"] = "세나리온 의회",
	["Cenarion Expedition"] = "세나리온 원정대",
	["Champions of Azeroth"] = "아제로스의 용사들",
	["Champions of Azeroth (Paragon)"] = "아제로스의 용사들 (불멸의 동맹)",
	["Chee Chee"] = "치 치",
	["Choofa"] = "츄파",
	["Chromie"] = "크로미",
	["Conjurer Margoss"] = "창조술사 마르고스",
	["Corbyn"] = "코르빈",
	["Council of Exarchs"] = "총독의 의회",
	["Court of Farondis"] = "파론디스의 궁정",
	["Court of Farondis (Paragon)"] = "파론디스의 궁정 (불멸의 동맹)",
	["Court of Harvesters"] = "수확자의 궁정",
	["Court of Harvesters (Paragon)"] = "수확자의 궁정 (불멸의 동맹)",
	["Court of Night"] = "밤의 궁정",
	["Cryptkeeper Kassir"] = "묘지지기 카시르",
	["Darkmoon Faire"] = "다크문 유랑단",
	["Darkspear Rebellion"] = "검은창 부족 저항군",
	["Darkspear Trolls"] = "검은창 트롤",
	["Darnassus"] = "다르나서스",
	["Defender Illona"] = "수호병 일로나",
	["Delvar Ironfist"] = "델바 아이언피스트",
	["Dominance Offensive"] = "지배령 선봉대",
	["Dragonmaw Clan"] = "용아귀 부족",
	["Dreamweavers"] = "몽술사",
	["Dreamweavers (Paragon)"] = "몽술사 (불멸의 동맹)",
	["Droman Aliothe"] = "수풀사령관 알리오테",
	["Ella"] = "엘라",
	["Emperor Shaohao"] = "황제 샤오하오",
	["Everlook"] = "눈망루 마을",
	["Exalted"] = "확고한 동맹",
	["Exodar"] = "엑소다르",
	["Explorers' League"] = "탐험가 연맹",
	["Farmer Fung"] = "농부 펑",
	["Farseer Ori"] = "선견자 오리",
	["Fish Fellreed"] = "피시 펠리드",
	["Forest Hozen"] = "숲 호젠",
	["Frenzyheart Tribe"] = "광란심장 일족",
	["Friend"] = "친구",
	["Friendly"] = "약간 우호적",
	["Frostwolf Clan"] = "서리늑대 부족",
	["Frostwolf Orcs"] = "서리늑대 오크",
	["Gadgetzan"] = "가젯잔",
	["Gelkis Clan Centaur"] = "켄타우로스 - 겔키스 일족",
	--[[Translation missing --]]
	--[[ ["Gilnean Survivors"] = "Gilnean Survivors",--]] 
	["Gilneas"] = "길니아스",
	["Gina Mudclaw"] = "지나 머드클로",
	["Gnomeregan"] = "놈리건",
	["Gnomeregan Exiles"] = "놈리건",
	["Golden Lotus"] = "황금 연꽃",
	["Good Friend"] = "좋은 친구",
	["Grandmaster Vole"] = "투사단장 볼",
	["Guardians of Hyjal"] = "하이잘의 수호자",
	["Guild"] = "길드",
	["Hand of the Prophet"] = "예언자의 손",
	["Haohan Mudclaw"] = "하오한 머드클로",
	["Hellscream's Reach"] = "헬스크림 세력단",
	["Highmountain Tribe"] = "높은산 부족",
	["Highmountain Tribe (Paragon)"] = "높은산 부족 (불멸의 동맹)",
	["Honeyback Hive"] = "벌꿀등 벌집",
	["Honor Hold"] = "명예의 요새",
	["Honored"] = "우호적",
	["Horde"] = "호드",
	["Horde Expedition"] = "호드 원정대",
	["Hunt-Captain Korayn"] = "사냥대장 코레인",
	["Hunter Akana"] = "사냥꾼 아카나",
	["Huojin Pandaren"] = "후오진 판다렌",
	["Hydraxian Waterlords"] = "히드락시안 물의 군주",
	--[[Translation missing --]]
	--[[ ["Illidari"] = "Illidari",--]] 
	["Ilyssia of the Waters"] = "물의 일리시아",
	["Impus"] = "임푸스",
	["Ironforge"] = "아이언포지",
	--[[Translation missing --]]
	--[[ ["Jandvik Vrykul"] = "Jandvik Vrykul",--]] 
	["Jogu the Drunk"] = "주정뱅이 조구",
	["Keeper Raynae"] = "수호자 레이내",
	["Keepers of Time"] = "시간의 수호자",
	["Kirin Tor"] = "키린 토",
	["Kirin Tor Offensive"] = "키린 토 선봉대",
	["Kleia and Pelagos"] = "클레이아와 펠라고스",
	["Knights of the Ebon Blade"] = "칠흑의 기사단",
	["Kurenai"] = "쿠레나이",
	["Lady Moonberry"] = "대신 문베리",
	["Laughing Skull Orcs"] = "웃는 해골 오크",
	["Leorajh"] = "레오라즈",
	["Lower City"] = "고난의 거리",
	["Magram Clan Centaur"] = "켄타우로스 - 마그람 일족",
	["Marasmius"] = "마라스미우스",
	["Mikanikos"] = "미카니코스",
	--[[Translation missing --]]
	--[[ ["Moon Guard"] = "Moon Guard",--]] 
	["Moonguard"] = "달빛 수호자",
	["Nat Pagle"] = "내트 페이글",
	["Neri Sharpfin"] = "네리 샤프핀",
	["Netherwing"] = "황천의 용군단",
	["Neutral"] = "중립적",
	["Night Fae"] = "나이트 페이",
	["Nomi"] = "노미",
	["Ogri'la"] = "오그릴라",
	["Old Hillpaw"] = "늙은 힐포우",
	--[[Translation missing --]]
	--[[ ["Operation: Aardvark"] = "Operation: Aardvark",--]] 
	["Operation: Shieldwall"] = "철벽방패 작전대",
	["Order of Embers"] = "잿불단",
	["Order of Embers (Paragon)"] = "잿불단 (불멸의 동맹)",
	["Order of the Awakened"] = "깨어난 자들의 의회",
	["Order of the Cloud Serpent"] = "운룡단",
	["Orgrimmar"] = "오그리마",
	["Pearlfin Jinyu"] = "진주지느러미 진위",
	["Plague Deviser Marileth"] = "역병 설계자 메릴레트",
	["Poen Gillbrack"] = "포엔 길브랙",
	["Polemarch Adrestes"] = "군정관 아드레스테스",
	["Proudmoore Admiralty"] = "프라우드무어 해군",
	["Proudmoore Admiralty (Paragon)"] = "프라우드무어 해군 (불멸의 동맹)",
	["Rajani"] = "라자니",
	["Rajani (Paragon)"] = "라자니 (불멸의 동맹)",
	["Ramkahen"] = "람카헨",
	["Rank 1"] = "1 레벨",
	["Rank 2"] = "2 레벨",
	["Rank 3"] = "3 레벨",
	["Rank 4"] = "4 레벨",
	["Rank 5"] = "5 레벨",
	["Rank 6"] = "6 레벨",
	["Rank 7"] = "7 레벨",
	["Rank 8"] = "8 레벨",
	["Ratchet"] = "톱니항",
	["Ravenholdt"] = "라벤홀트 암살단",
	["Rendle and Cudgelface"] = "렌들과 곤봉얼굴",
	["Revered"] = "매우 우호적",
	["Rustbolt Resistance"] = "녹슨나사 저항군",
	["Rustbolt Resistance (Paragon)"] = "녹슨나사 저항군 (불멸의 동맹)",
	["Shado-Pan"] = "음영파",
	["Shado-Pan Assault"] = "음영파 강습단",
	["Shadowmoon Exiles"] = "어둠달 유배자",
	["Sha'leth"] = "샤레스",
	["Shang Xi's Academy"] = "샹 시 도장",
	["Sha'tari Defense"] = "샤타리 수호자",
	["Sha'tari Skyguard"] = "샤타리 하늘경비대",
	["Shattered Sun Offensive"] = "무너진 태양 공격대",
	["Shen'dralar"] = "셴드랄라",
	["Sho"] = "쇼",
	["Sika"] = "시카",
	["Silvermoon City"] = "실버문",
	["Silverwing Sentinels"] = "은빛날개 파수대",
	["Sporeggar"] = "스포어가르",
	["Steamwheedle Draenor Expedition"] = "스팀휘들 드레노어 원정대",
	["Steamwheedle Preservation Society"] = "스팀휘들 유물 복원회",
	["Stitchmasters"] = "바느질 대가",
	["Stonehead"] = "바위머리",
	["Stormpike Guard"] = "스톰파이크 경비대",
	["Storm's Wake"] = "깨어난 폭풍",
	["Storm's Wake (Paragon)"] = "깨어난 폭풍 (불멸의 동맹)",
	["Stormwind"] = "스톰윈드",
	["Stranger"] = "이방인",
	["Sunreaver Onslaught"] = "선리버 돌격대",
	["Syndicate"] = "비밀결사대",
	["Talanji's Expedition"] = "탈란지의 원정대",
	["Talanji's Expedition (Paragon)"] = "탈란지의 원정대 (불멸의 동맹)",
	["Talonpriest Ishaal"] = "갈퀴사제 이샤알",
	["Talon's Vengeance"] = "갈퀴발톱의 복수",
	["The Aldor"] = "알도르 사제회",
	["The Anglers"] = "강태공 연합",
	["The Ascended"] = "승천자",
	["The Ascended (Paragon)"] = "승천자 (불멸의 동맹)",
	["The Ashen Verdict"] = "잿빛 선고단",
	["The August Celestials"] = "위대한 천신회",
	["The Avowed"] = "선언단",
	["The Black Prince"] = "검은 왕자",
	["The Brewmasters"] = "양조사 연합",
	["The Consortium"] = "무역연합",
	["The Countess"] = "백작",
	["The Defilers"] = "포세이큰 파멸단",
	["The Earthen Ring"] = "대지 고리회",
	["The Ember Court"] = "잿불 궁정",
	--[[Translation missing --]]
	--[[ ["The First Responders"] = "The First Responders",--]] 
	["The Frostborn"] = "서릿결 부족",
	["The Hand of Vengeance"] = "복수의 대리인",
	["The Honorbound"] = "명예결속단",
	["The Honorbound (Paragon)"] = "명예결속단 (불멸의 동맹)",
	["The Kalu'ak"] = "칼루아크",
	["The Klaxxi"] = "클락시",
	["The League of Arathor"] = "아라소르 연맹",
	["The Lorewalkers"] = "전승지기",
	["The Mag'har"] = "마그하르",
	["The Nightfallen"] = "나이트폴른",
	["The Nightfallen (Paragon)"] = "나이트폴른 (불멸의 동맹)",
	["The Oracles"] = "점쟁이 조합",
	["The Saberstalkers"] = "서슬추적자",
	["The Scale of the Sands"] = "시간의 중재자",
	["The Scryers"] = "점술가 길드",
	["The Sha'tar"] = "샤타르",
	["The Silver Covenant"] = "은빛 서약단",
	["The Sons of Hodir"] = "호디르의 후예",
	["The Sunreavers"] = "선리버",
	["The Taunka"] = "타운카",
	["The Tillers"] = "농사꾼 연합",
	["The Undying Army"] = "죽지 않는 군대",
	["The Undying Army (Paragon)"] = "죽지 않는 군대 (불멸의 동맹)",
	["The Unshackled"] = "속박 풀린 자",
	["The Unshackled (Paragon)"] = "속박 풀린 자 (불멸의 동맹)",
	["The Violet Eye"] = "보랏빛 눈의 감시자",
	["The Wardens"] = "감시관",
	["The Wardens (Paragon)"] = "감시관 (불멸의 동맹)",
	["The Wild Hunt"] = "야생 사냥단",
	["The Wild Hunt (Paragon)"] = "야생 사냥단 (불멸의 동맹)",
	["The Wyrmrest Accord"] = "고룡쉼터 사원 용군단",
	["Therazane"] = "테라제인",
	["Thorium Brotherhood"] = "토륨 대장조합",
	["Thrallmar"] = "스랄마",
	["Thunder Bluff"] = "썬더 블러프",
	["Timbermaw Hold"] = "나무구렁 요새",
	["Tina Mudclaw"] = "티나 머드클로",
	["Tormmok"] = "토르모크",
	["Tortollan Seekers"] = "토르톨란 탐구단",
	["Tortollan Seekers (Paragon)"] = "토르톨란 탐구단 (불멸의 동맹)",
	["Tranquillien"] = "트랜퀼리엔",
	["Tushui Pandaren"] = "투슈이 판다렌",
	["Uldum Accord"] = "울둠 협의회",
	["Uldum Accord (Paragon)"] = "울둠 협의회 (불멸의 동맹)",
	["Undercity"] = "언더시티",
	["Valarjar"] = "발라리아르",
	["Valarjar (Paragon)"] = "발라리아르 (불멸의 동맹)",
	["Valiance Expedition"] = "용맹의 원정대",
	["Ve'nari"] = "베나리",
	["Vim Brineheart"] = "빔 브라인하트",
	["Vivianne"] = "비비안",
	["Voldunai"] = "볼두나이",
	["Voldunai (Paragon)"] = "볼두나이 (불멸의 동맹)",
	["Vol'jin's Headhunters"] = "볼진의 인간사냥꾼",
	["Vol'jin's Spear"] = "볼진의 창",
	["Warsong Offensive"] = "전쟁노래 공격대",
	["Warsong Outriders"] = "전쟁노래 정찰대",
	["Waveblade Ankoan"] = "파도칼날 안코안",
	["Waveblade Ankoan (Paragon)"] = "파도칼날 안코안 (불멸의 동맹)",
	["Wildhammer Clan"] = "와일드해머 드워프",
	["Winterfin Retreat"] = "겨울지느러미 은신처",
	["Wintersaber Trainers"] = "눈호랑이 조련사",
	["Wrynn's Vanguard"] = "린의 선봉대",
	["Zandalar Tribe"] = "잔달라 부족",
	["Zandalari Empire"] = "잔달라 제국",
	["Zandalari Empire (Paragon)"] = "잔달라 제국 (불멸의 동맹)"
}
elseif GAME_LOCALE == "esES" then
	lib:SetCurrentTranslations {
	["7th Legion"] = "Séptima Legión",
	["7th Legion (Paragon)"] = "Séptima Legión (baluarte)",
	["Acquaintance"] = "Conocido",
	["Aeda Brightdawn"] = "Aeda Alba Brillante",
	["Akama's Trust"] = "Confianza de Akama",
	["Akule Riverhorn"] = "Akule Cuerno de Río",
	["Alexandros Mograine"] = "Alexandros Mograine",
	["Alliance"] = "Alianza",
	["Alliance Vanguard"] = "Vanguardia de la Alianza",
	["Arakkoa Outcasts"] = "Arakkoa desterrados",
	["Arcane Thirst (Oculeth)"] = "Sedientos de lo Arcano (Oculeth)",
	["Arcane Thirst (Thalyssra)"] = "Sedientos de lo Arcano (Thalyssra)",
	["Arcane Thirst (Valtrois)"] = "Ansia Arcana (Valtrois)",
	["Argent Crusade"] = "Cruzada Argenta",
	["Argent Dawn"] = "El Alba Argenta",
	["Argussian Reach"] = "Gloria de Argus",
	["Argussian Reach (Paragon)"] = "Gloria de Argus (baluarte)",
	["Armies of Legionfall"] = "Ocaso de la Legión",
	["Armies of Legionfall (Paragon)"] = "Ocaso de la Legión (baluarte)",
	["Army of the Light"] = "Ejército de la Luz",
	["Army of the Light (Paragon)"] = "Ejército de la Luz (baluarte)",
	["Ashtongue Deathsworn"] = "Juramorte Lengua de Ceniza",
	["Avengers of Hyjal"] = "Vengadores de Hyjal",
	["Baradin's Wardens"] = "Celadores de Baradin",
	["Baroness Vashj"] = "Baronesa Vashj",
	["Barracks Bodyguards"] = "Guardaespaldas del cuartel",
	["Best Friend"] = "Mejor amigo",
	["Bilgewater Cartel"] = "Cártel Pantoque",
	["Bizmo's Brawlpub"] = "Club de Lucha de Bizmo",
	["Bizmo's Brawlpub (Season 1)"] = "Club de Lucha de Bizmo (Temporada 1)",
	["Bizmo's Brawlpub (Season 2)"] = "Club de Lucha de Bizmo (temporada 2)",
	["Bizmo's Brawlpub (Season 3)"] = "Club de Lucha de Bizmo (temporada 3)",
	["Bladesman Inowari"] = "Esgrimidor Inowari",
	["Bloodsail Buccaneers"] = "Bucaneros Velasangre",
	["Booty Bay"] = "Bahía del Botín",
	["Brawl'gar Arena"] = "Arena Liza'gar",
	["Brawl'gar Arena (Season 1)"] = "Arena Liza'gar (Temporada 1)",
	["Brawl'gar Arena (Season 2)"] = "Arena Liza'gar (temporada 2)",
	["Brawl'gar Arena (Season 3)"] = "Arena Liza'gar (temporada 3)",
	["Brood of Nozdormu"] = "Linaje de Nozdormu",
	["Buddy"] = "Compañero",
	["Cenarion Circle"] = "Círculo Cenarion",
	["Cenarion Expedition"] = "Expedición Cenarion",
	["Champions of Azeroth"] = "Campeones de Azeroth",
	["Champions of Azeroth (Paragon)"] = "Campeones de Azeroth (baluarte)",
	["Chee Chee"] = "Chee Chee",
	["Choofa"] = "Choofa",
	["Chromie"] = "Cromi",
	["Conjurer Margoss"] = "Conjurador Margoss",
	["Corbyn"] = "Corbyn",
	["Council of Exarchs"] = "Consejo de Exarcas",
	["Court of Farondis"] = "Corte de Farondis",
	["Court of Farondis (Paragon)"] = "Corte de Farondis (baluarte)",
	["Court of Harvesters"] = "Corte de los Cosechadores",
	["Court of Harvesters (Paragon)"] = "Corte de los Cosechadores (dechado)",
	["Court of Night"] = "Corte de la Noche",
	["Cryptkeeper Kassir"] = "Guardacriptas Kassir",
	["Darkmoon Faire"] = "Feria de la Luna Negra",
	["Darkspear Rebellion"] = "Rebelión Lanza Negra",
	["Darkspear Trolls"] = "Trols Lanza Negra",
	["Darnassus"] = "Darnassus",
	["Defender Illona"] = "Defensora Illona",
	["Delvar Ironfist"] = "Delvar Puño de Hierro",
	["Dominance Offensive"] = "Ofensiva de Dominancia",
	["Dragonmaw Clan"] = "Clan Faucedraco",
	["Dreamweavers"] = "Tejesueños",
	["Dreamweavers (Paragon)"] = "Tejesueños (baluarte)",
	["Droman Aliothe"] = "Droman Aliothe",
	["Ella"] = "Ella",
	["Emperor Shaohao"] = "Emperador Shaohao",
	["Everlook"] = "Vista Eterna",
	["Exalted"] = "Exaltado",
	["Exodar"] = "El Exodar",
	["Explorers' League"] = "Liga de Expedicionarios",
	["Farmer Fung"] = "Granjero Fung",
	["Farseer Ori"] = "Clarividente Ori",
	["Fish Fellreed"] = "Pez Junco Talado",
	["Forest Hozen"] = "Hozen del bosque",
	["Frenzyheart Tribe"] = "Tribu Corazón Frenético",
	["Friend"] = "Amigo",
	["Friendly"] = "Amistoso",
	["Frostwolf Clan"] = "Clan Lobo Gélido",
	["Frostwolf Orcs"] = "Orcos Lobo Gélido",
	["Gadgetzan"] = "Gadgetzan",
	["Gelkis Clan Centaur"] = "Centauros del clan Gelkis",
	["Gilnean Survivors"] = "Supervivientes de Gilneas",
	["Gilneas"] = "Gilneas",
	["Gina Mudclaw"] = "Gina Zarpa Fangosa",
	["Gnomeregan"] = "Gnomeregan",
	["Gnomeregan Exiles"] = "Exiliados de Gnomeregan",
	["Golden Lotus"] = "Loto Dorado",
	["Good Friend"] = "Buen amigo",
	["Grandmaster Vole"] = "Gran maestro Vole",
	["Guardians of Hyjal"] = "Guardianes de Hyjal",
	["Guild"] = "Hermandad",
	["Hand of the Prophet"] = "Mano del Profeta",
	["Haohan Mudclaw"] = "Haohan Zarpa Fangosa",
	["Hellscream's Reach"] = "Mando Grito Infernal",
	["Highmountain Tribe"] = "Tribu Monte Alto",
	["Highmountain Tribe (Paragon)"] = "Tribu Monte Alto (baluarte)",
	["Honeyback Hive"] = "Colmena mielabdomen",
	["Honor Hold"] = "Bastión del Honor",
	["Honored"] = "Honorable",
	["Horde"] = "Horda",
	["Horde Expedition"] = "Expedición de la Horda",
	["Hunt-Captain Korayn"] = "Capitana de caza Korayn",
	["Hunter Akana"] = "Cazador Akana",
	["Huojin Pandaren"] = "Pandaren huojin",
	["Hydraxian Waterlords"] = "Srs. del Agua de Hydraxis",
	["Illidari"] = "Illidari",
	["Ilyssia of the Waters"] = "Ilyssia de las Aguas",
	["Impus"] = "Diablillus",
	["Ironforge"] = "Forjaz",
	["Jandvik Vrykul"] = "Vrykul Jandvik",
	["Jogu the Drunk"] = "Jogu el Ebrio",
	["Keeper Raynae"] = "Guardiana Raynae",
	["Keepers of Time"] = "Vigilantes del Tiempo",
	["Kirin Tor"] = "Kirin Tor",
	["Kirin Tor Offensive"] = "Ofensiva del Kirin Tor",
	["Kleia and Pelagos"] = "Kleia y Pelagos",
	["Knights of the Ebon Blade"] = "Caballeros de la Espada de Ébano",
	["Kurenai"] = "Kurenai",
	["Lady Moonberry"] = "Lady Bayalunar",
	["Laughing Skull Orcs"] = "Orcos Riecráneos",
	["Leorajh"] = "Leorajh",
	["Lower City"] = "Bajo Arrabal",
	["Magram Clan Centaur"] = "Centauros del clan Magram",
	["Marasmius"] = "Marasmius",
	["Mikanikos"] = "Mikanikos",
	["Moon Guard"] = "Guardia Lunar",
	["Moonguard"] = "Guardia Lunar",
	["Nat Pagle"] = "Nat Pagle",
	["Neri Sharpfin"] = "Neri Escama Letal",
	["Netherwing"] = "Ala Abisal",
	["Neutral"] = "Neutral",
	["Night Fae"] = "Sílfides nocturnas",
	["Nomi"] = "Nomi",
	["Ogri'la"] = "Ogri'la",
	["Old Hillpaw"] = "Viejo Zarpa Collado",
	["Operation: Aardvark"] = "Operación: Oricteropo",
	["Operation: Shieldwall"] = "Muro de escudos",
	["Order of Embers"] = "Orden de Ascuas",
	["Order of Embers (Paragon)"] = "Orden de Ascuas (baluarte)",
	["Order of the Awakened"] = "Orden de los Despiertos",
	["Order of the Cloud Serpent"] = "Orden del Dragón Nimbo",
	["Orgrimmar"] = "Orgrimmar",
	["Pearlfin Jinyu"] = "Jinyu Aleta de Nácar",
	["Plague Deviser Marileth"] = "Inventor de pestes Marileth",
	["Poen Gillbrack"] = "Poen Branquiano",
	["Polemarch Adrestes"] = "Polemarca Adrestes",
	["Proudmoore Admiralty"] = "Almirantazgo de la Casa Valiente",
	["Proudmoore Admiralty (Paragon)"] = "Almirantazgo de la Casa Valiente (baluarte)",
	["Rajani"] = "Rajani",
	["Rajani (Paragon)"] = "Rajani (baluarte)",
	["Ramkahen"] = "Ramkahen",
	["Rank 1"] = "Rango 1",
	["Rank 2"] = "Rango 2",
	["Rank 3"] = "Rango 3",
	["Rank 4"] = "Rango 4",
	["Rank 5"] = "Rango 5",
	["Rank 6"] = "Rango 6",
	["Rank 7"] = "Rango 7",
	["Rank 8"] = "Rango 8",
	["Ratchet"] = "Trinquete",
	["Ravenholdt"] = "Ravenholdt",
	["Rendle and Cudgelface"] = "Rendle y Caragarrote",
	["Revered"] = "Reverenciado",
	["Rustbolt Resistance"] = "Resistencia de Pernoóxido",
	["Rustbolt Resistance (Paragon)"] = "Resistencia de Pernoóxido (baluarte)",
	["Shado-Pan"] = "Shadopan",
	["Shado-Pan Assault"] = "Asalto del Shadopan",
	["Shadowmoon Exiles"] = "Exiliados Sombraluna",
	["Sha'leth"] = "Sha'leth",
	["Shang Xi's Academy"] = "Academia de Shang Xi",
	["Sha'tari Defense"] = "Defensa Sha'tari",
	["Sha'tari Skyguard"] = "Guardia del cielo Sha'tari",
	["Shattered Sun Offensive"] = "Ofensiva Sol Devastado",
	["Shen'dralar"] = "Shen'dralar",
	["Sho"] = "Sho",
	["Sika"] = "Sika",
	["Silvermoon City"] = "Lunargenta",
	["Silverwing Sentinels"] = "Centinelas Ala de Plata",
	["Sporeggar"] = "Esporaggar",
	["Steamwheedle Draenor Expedition"] = "Expedición Bonvapor de Draenor",
	["Steamwheedle Preservation Society"] = "Sociedad Patrimonial Bonvapor",
	["Stitchmasters"] = "Maestros de costura",
	["Stonehead"] = "Cabeza Pétrea",
	["Stormpike Guard"] = "Guardia Pico Tormenta",
	["Storm's Wake"] = "Despertar de la Tormenta",
	["Storm's Wake (Paragon)"] = "Despertar de la Tormenta (baluarte)",
	["Stormwind"] = "Ventormenta",
	["Stranger"] = "Extraño",
	["Sunreaver Onslaught"] = "Embate de los Atracasol",
	["Syndicate"] = "La Hermandad",
	["Talanji's Expedition"] = "Expedición de Talanji",
	["Talanji's Expedition (Paragon)"] = "Expedición de Talanji (baluarte)",
	["Talonpriest Ishaal"] = "Sacerdote de la garra Ishaal",
	["Talon's Vengeance"] = "Venganza de la Garfa",
	["The Aldor"] = "Los Aldor",
	["The Anglers"] = "Los Pescadores",
	["The Ascended"] = "Los Ascendidos",
	["The Ascended (Paragon)"] = "Los Ascendidos (dechado)",
	["The Ashen Verdict"] = "El Veredicto Cinéreo",
	["The August Celestials"] = "Los Augustos Celestiales",
	["The Avowed"] = "Los Declarados",
	["The Black Prince"] = "El Príncipe Negro",
	["The Brewmasters"] = "Los Maestros Cerveceros",
	["The Consortium"] = "El Consorcio",
	["The Countess"] = "La condesa",
	["The Defilers"] = "Los Rapiñadores",
	["The Earthen Ring"] = "Anillo de la Tierra",
	["The Ember Court"] = "La Corte de Ascuas",
	["The First Responders"] = "Los primeros intervinientes",
	["The Frostborn"] = "Los Natoescarcha",
	["The Hand of Vengeance"] = "La Mano de la Venganza",
	["The Honorbound"] = "Defensores del Honor",
	["The Honorbound (Paragon)"] = "Defensores del Honor (baluarte)",
	["The Kalu'ak"] = "Los Kalu'ak",
	["The Klaxxi"] = "Los Klaxxi",
	["The League of Arathor"] = "Liga de Arathor",
	["The Lorewalkers"] = "Los Eremitas",
	["The Mag'har"] = "Los Mag'har",
	["The Nightfallen"] = "Caídos de la Noche",
	["The Nightfallen (Paragon)"] = "Caídos de la Noche (baluarte)",
	["The Oracles"] = "Los Oráculos",
	["The Saberstalkers"] = "Acechasablerones",
	["The Scale of the Sands"] = "La Escama de las Arenas",
	["The Scryers"] = "Los Arúspices",
	["The Sha'tar"] = "Los Sha'tar",
	["The Silver Covenant"] = "El Pacto de Plata",
	["The Sons of Hodir"] = "Los Hijos de Hodir",
	["The Sunreavers"] = "Los Atracasol",
	["The Taunka"] = "Los taunka",
	["The Tillers"] = "Los Labradores",
	["The Undying Army"] = "El Ejército Inmortal",
	["The Undying Army (Paragon)"] = "El Ejército Inmortal (dechado)",
	["The Unshackled"] = "Desencadenados",
	["The Unshackled (Paragon)"] = "Desencadenados (baluarte)",
	["The Violet Eye"] = "El Ojo Violeta",
	["The Wardens"] = "Las Celadoras",
	["The Wardens (Paragon)"] = "Las Celadoras (baluarte)",
	["The Wild Hunt"] = "La Cacería Salvaje",
	["The Wild Hunt (Paragon)"] = "La Cacería Salvaje (dechado)",
	["The Wyrmrest Accord"] = "Acuerdo del Reposo del Dragón",
	["Therazane"] = "Therazane",
	["Thorium Brotherhood"] = "Hermandad del Torio",
	["Thrallmar"] = "Thrallmar",
	["Thunder Bluff"] = "Cima del Trueno",
	["Timbermaw Hold"] = "Bastión Fauces de Madera",
	["Tina Mudclaw"] = "Tina Zarpa Fangosa",
	["Tormmok"] = "Tormmok",
	["Tortollan Seekers"] = "Buscadores Tortolianos",
	["Tortollan Seekers (Paragon)"] = "Buscadores Tortolianos (baluarte)",
	["Tranquillien"] = "Tranquillien",
	["Tushui Pandaren"] = "Pandaren tushui",
	["Uldum Accord"] = "Acuerdo de Uldum",
	["Uldum Accord (Paragon)"] = "Acuerdo de Uldum (baluarte)",
	["Undercity"] = "Entrañas",
	["Valarjar"] = "Valarjar",
	["Valarjar (Paragon)"] = "Valarjar (baluarte)",
	["Valiance Expedition"] = "Expedición de Denuedo",
	["Ve'nari"] = "Ve'nari",
	["Vim Brineheart"] = "Vim Almasalmuera",
	["Vivianne"] = "Vivianne",
	["Voldunai"] = "Voldunai",
	["Voldunai (Paragon)"] = "Voldunai (baluarte)",
	["Vol'jin's Headhunters"] = "Rebanacabezas de Vol'jin",
	["Vol'jin's Spear"] = "Lanza de Vol'jin",
	["Warsong Offensive"] = "Ofensiva Grito de Guerra",
	["Warsong Outriders"] = "Escoltas Grito de Guerra",
	["Waveblade Ankoan"] = "Ankoan Hojamarea",
	["Waveblade Ankoan (Paragon)"] = "Ankoan Hojamarea (baluarte)",
	["Wildhammer Clan"] = "Clan Martillo Salvaje",
	["Winterfin Retreat"] = "Retiro Aleta Invernal",
	["Wintersaber Trainers"] = "Instructores de sableinvernales",
	["Wrynn's Vanguard"] = "Vanguardia de Wrynn",
	["Zandalar Tribe"] = "Tribu Zandalar",
	["Zandalari Empire"] = "Imperio Zandalari",
	["Zandalari Empire (Paragon)"] = "Imperio Zandalari (baluarte)"
}
elseif GAME_LOCALE == "esMX" then
	lib:SetCurrentTranslations {
	["7th Legion"] = "La Séptima Legión",
	["7th Legion (Paragon)"] = "Séptima Legión (Dechado)",
	["Acquaintance"] = "Conocido",
	["Aeda Brightdawn"] = "Aeda Alba Brillante",
	["Akama's Trust"] = "Confianza de Akama",
	["Akule Riverhorn"] = "Akule Cuerno de Río",
	["Alexandros Mograine"] = "Alexandros Mograine",
	["Alliance"] = "Alianza",
	["Alliance Vanguard"] = "Vanguardia de la Alianza",
	["Arakkoa Outcasts"] = "Desterrados Arakkoa",
	["Arcane Thirst (Oculeth)"] = "Sed Arcana (Oculeth)",
	["Arcane Thirst (Thalyssra)"] = "Sed Arcana (Thalyssra)",
	["Arcane Thirst (Valtrois)"] = "Sed Arcana (Valtrois)",
	["Argent Crusade"] = "Cruzada Argenta",
	["Argent Dawn"] = "El Alba Argenta",
	["Argussian Reach"] = "Dominio argusiano",
	--[[Translation missing --]]
	--[[ ["Argussian Reach (Paragon)"] = "Argussian Reach (Paragon)",--]] 
	["Armies of Legionfall"] = "Ejércitos de Legión caída",
	["Armies of Legionfall (Paragon)"] = "Ejércitos de Legión caída (Dechado)",
	["Army of the Light"] = "Ejército de la Luz",
	--[[Translation missing --]]
	--[[ ["Army of the Light (Paragon)"] = "Army of the Light (Paragon)",--]] 
	["Ashtongue Deathsworn"] = "Juramorte Lengua de ceniza",
	["Avengers of Hyjal"] = "Vengadores de Hyjal",
	["Baradin's Wardens"] = "Celadores de Baradin",
	["Baroness Vashj"] = "Baronesa Vashj",
	--[[Translation missing --]]
	--[[ ["Barracks Bodyguards"] = "Barracks Bodyguards",--]] 
	["Best Friend"] = "Mejor Amigo",
	["Bilgewater Cartel"] = "Cártel Pantoque",
	["Bizmo's Brawlpub"] = "Club de Lucha de Bizmo",
	["Bizmo's Brawlpub (Season 1)"] = "Club de Lucha de Bizmo (Temporada 1)",
	["Bizmo's Brawlpub (Season 2)"] = "Club de Lucha de Bizmo (Temporada 2)",
	["Bizmo's Brawlpub (Season 3)"] = "Club de Lucha de Bizmo (temporada 3)",
	["Bladesman Inowari"] = "Esgrimidor Inowari",
	["Bloodsail Buccaneers"] = "Bucaneros Velasangre",
	["Booty Bay"] = "Bahía del Botín",
	["Brawl'gar Arena"] = "Arena Liza'gar",
	["Brawl'gar Arena (Season 1)"] = "Arena Liza'gar (Temporada 1)",
	["Brawl'gar Arena (Season 2)"] = "Arena Liza'gar (Temporada 2)",
	["Brawl'gar Arena (Season 3)"] = "Arena Liza'gar (temporada 3)",
	["Brood of Nozdormu"] = "Linaje de Nozdormu",
	--[[Translation missing --]]
	--[[ ["Buddy"] = "Buddy",--]] 
	["Cenarion Circle"] = "Círculo Cenarion",
	["Cenarion Expedition"] = "Expedición Cenarion",
	["Champions of Azeroth"] = "Campeones de Azeroth",
	["Champions of Azeroth (Paragon)"] = "Campeones de Azeroth (Dechado)",
	["Chee Chee"] = "Chee Chee",
	["Choofa"] = "Chufa",
	["Chromie"] = "Cromi",
	["Conjurer Margoss"] = "Conjurador Margoss",
	["Corbyn"] = "Corbyn",
	["Council of Exarchs"] = "Consejo de Exarcas",
	["Court of Farondis"] = "Corte de Farondis",
	["Court of Farondis (Paragon)"] = "Corte de Farondis (Dechado)",
	["Court of Harvesters"] = "Corte de Cosechadores",
	["Court of Harvesters (Paragon)"] = "Corte de Cosechadores (Dechado)",
	["Court of Night"] = "Corte de la Noche",
	["Cryptkeeper Kassir"] = "Guardián de criptas Kassir",
	["Darkmoon Faire"] = "Feria de la Luna Negra",
	["Darkspear Rebellion"] = "Rebelión Lanza Negra",
	["Darkspear Trolls"] = "Trols Lanza Negra",
	["Darnassus"] = "Darnassus",
	["Defender Illona"] = "Defensora Illona",
	["Delvar Ironfist"] = "Delvar Puño de Hierro",
	["Dominance Offensive"] = "Ofensiva de Dominancia",
	["Dragonmaw Clan"] = "Clan Faucedraco",
	["Dreamweavers"] = "Tejesueños",
	["Dreamweavers (Paragon)"] = "Tejesueños (Dechado)",
	["Droman Aliothe"] = "Droman Aliothe",
	["Ella"] = "Ella",
	["Emperor Shaohao"] = "Emperador Shaohao",
	["Everlook"] = "Vista Eterna",
	["Exalted"] = "Exaltado",
	["Exodar"] = "El Exodar",
	["Explorers' League"] = "Liga de Expedicionarios",
	["Farmer Fung"] = "Granjero Fung",
	["Farseer Ori"] = "Clarividente Ori",
	["Fish Fellreed"] = "Pez Junco Talado",
	["Forest Hozen"] = "Hozen del bosque",
	["Frenzyheart Tribe"] = "Tribu Corazón Frenético",
	["Friend"] = "Amigo",
	["Friendly"] = "Amistoso",
	["Frostwolf Clan"] = "Clan Lobo Gélido",
	["Frostwolf Orcs"] = "Orcos Lobo Gélido",
	["Gadgetzan"] = "Gadgetzan",
	["Gelkis Clan Centaur"] = "Centauros del clan Gelkis",
	--[[Translation missing --]]
	--[[ ["Gilnean Survivors"] = "Gilnean Survivors",--]] 
	["Gilneas"] = "Gilneas",
	["Gina Mudclaw"] = "Gina Zarpa Fangosa",
	["Gnomeregan"] = "Gnomeregan",
	["Gnomeregan Exiles"] = "Exiliados de Gnomeregan",
	["Golden Lotus"] = "Loto Dorado",
	["Good Friend"] = "Buen Amigo",
	["Grandmaster Vole"] = "Gran maestro Vole",
	["Guardians of Hyjal"] = "Guardianes de Hyjal",
	["Guild"] = "Hermandad",
	["Hand of the Prophet"] = "Mano del Profeta",
	["Haohan Mudclaw"] = "Haohan Zarpa Fangosa",
	["Hellscream's Reach"] = "Mando de Grito Infernal",
	["Highmountain Tribe"] = "Tribu Altamontaña",
	["Highmountain Tribe (Paragon)"] = "Tribu Altamontaña (Dechado)",
	["Honeyback Hive"] = "Colmena mielomo",
	["Honor Hold"] = "Bastión del Honor",
	["Honored"] = "Honorable",
	["Horde"] = "Horda",
	["Horde Expedition"] = "Expedición de la Horda",
	["Hunt-Captain Korayn"] = "Capitana de los Cazadores Korayn",
	["Hunter Akana"] = "Cazador Akana",
	["Huojin Pandaren"] = "Pandaren huojin",
	["Hydraxian Waterlords"] = "Srs. del Agua de Hydraxis",
	--[[Translation missing --]]
	--[[ ["Illidari"] = "Illidari",--]] 
	["Ilyssia of the Waters"] = "Ilyssia de las aguas",
	["Impus"] = "Diablillus",
	["Ironforge"] = "Forjaz",
	--[[Translation missing --]]
	--[[ ["Jandvik Vrykul"] = "Jandvik Vrykul",--]] 
	["Jogu the Drunk"] = "Jogu el Ebrio",
	["Keeper Raynae"] = "Guardiana Raynae",
	["Keepers of Time"] = "Vigilantes del Tiempo",
	["Kirin Tor"] = "Kirin Tor",
	["Kirin Tor Offensive"] = "Ofensiva del Kirin Tor",
	["Kleia and Pelagos"] = "Kleia y Pelagos",
	["Knights of the Ebon Blade"] = "Caballeros Espada de Ébano",
	["Kurenai"] = "Kurenai",
	["Lady Moonberry"] = "Lady Baya Lunar",
	["Laughing Skull Orcs"] = "Orcos Riecráneos",
	["Leorajh"] = "Leorajh",
	["Lower City"] = "Bajo Arrabal",
	["Magram Clan Centaur"] = "Centauros del clan Magram",
	["Marasmius"] = "Marasmius",
	["Mikanikos"] = "Mikanikos",
	--[[Translation missing --]]
	--[[ ["Moon Guard"] = "Moon Guard",--]] 
	["Moonguard"] = "Guardia Lunar",
	["Nat Pagle"] = "Nat Pagle",
	["Neri Sharpfin"] = "Neri Escama Letal",
	["Netherwing"] = "Ala Abisal",
	["Neutral"] = "Neutral",
	["Night Fae"] = "Noctifeéricos",
	["Nomi"] = "Nomi",
	["Ogri'la"] = "Ogri'la",
	["Old Hillpaw"] = "Viejo Zarpa Collado",
	--[[Translation missing --]]
	--[[ ["Operation: Aardvark"] = "Operation: Aardvark",--]] 
	["Operation: Shieldwall"] = "Muro de escudos",
	["Order of Embers"] = "Orden de las Ascuas",
	["Order of Embers (Paragon)"] = "Orden de las Ascuas (Dechado)",
	["Order of the Awakened"] = "La orden de los despertados",
	["Order of the Cloud Serpent"] = "Orden del dragón nimbo",
	["Orgrimmar"] = "Orgrimmar",
	["Pearlfin Jinyu"] = "Jinyu Aleta de Nácar",
	["Plague Deviser Marileth"] = "Maestro de plagas Marileth",
	["Poen Gillbrack"] = "Poen Branquen",
	["Polemarch Adrestes"] = "Polemarca Adrestes",
	["Proudmoore Admiralty"] = "Almirantazgo Valiente",
	["Proudmoore Admiralty (Paragon)"] = "Almirantazgo Valiente (Dechado)",
	["Rajani"] = "Rajani",
	["Rajani (Paragon)"] = "Rajani (Dechado)",
	["Ramkahen"] = "Ramkahen",
	["Rank 1"] = "Rango 1",
	["Rank 2"] = "Rango 2",
	["Rank 3"] = "Rango 3",
	["Rank 4"] = "Rango 4",
	["Rank 5"] = "Rango 5",
	["Rank 6"] = "Rango 6",
	["Rank 7"] = "Rango 7",
	["Rank 8"] = "Rango 8",
	["Ratchet"] = "Trinquete",
	["Ravenholdt"] = "Ravenholdt",
	["Rendle and Cudgelface"] = "Rendle y Garrotero",
	["Revered"] = "Reverenciado",
	["Rustbolt Resistance"] = "Resistencia de Pernoxidado",
	["Rustbolt Resistance (Paragon)"] = "Resistencia de Pernoxidado (Dechado)",
	["Shado-Pan"] = "Shadopan",
	["Shado-Pan Assault"] = "Asalto del Shadopan",
	--[[Translation missing --]]
	--[[ ["Shadowmoon Exiles"] = "Shadowmoon Exiles",--]] 
	["Sha'leth"] = "Sha'leth",
	["Shang Xi's Academy"] = "Academia de Shang Xi",
	["Sha'tari Defense"] = "Defensa Sha'tari",
	["Sha'tari Skyguard"] = "Guardia del cielo Sha'tari",
	["Shattered Sun Offensive"] = "Ofensiva Sol Devastado",
	["Shen'dralar"] = "Shen'dralar",
	["Sho"] = "Sho",
	["Sika"] = "Sika",
	["Silvermoon City"] = "Lunargenta",
	["Silverwing Sentinels"] = "Centinelas Ala de Plata",
	["Sporeggar"] = "Esporaggar",
	["Steamwheedle Draenor Expedition"] = "Expedición Bonvapor de Draenor",
	["Steamwheedle Preservation Society"] = "Sociedad de preservación de Bonvapor",
	["Stitchmasters"] = "Maestros de puntadas",
	["Stonehead"] = "Cefalopétreo",
	["Stormpike Guard"] = "Guardia Pico Tormenta",
	["Storm's Wake"] = "Estela de la Tormenta",
	["Storm's Wake (Paragon)"] = "Estela de la Tormenta (Dechado)",
	["Stormwind"] = "Ventormenta",
	["Stranger"] = "Extraño",
	["Sunreaver Onslaught"] = "Embate de los Atracasol",
	["Syndicate"] = "La Hermandad",
	["Talanji's Expedition"] = "Expedición de Talanji",
	["Talanji's Expedition (Paragon)"] = "Expedición de Talanji (Dechado)",
	["Talonpriest Ishaal"] = "Sacerdote de la Garra Ishaal",
	["Talon's Vengeance"] = "Venganza de Garfa",
	["The Aldor"] = "Los Aldor",
	["The Anglers"] = "Los Pescadores",
	["The Ascended"] = "Los Ascendidos",
	["The Ascended (Paragon)"] = "Los Ascendidos (Dechado)",
	["The Ashen Verdict"] = "El Veredicto Cinéreo",
	["The August Celestials"] = "Los Augustos Celestiales",
	["The Avowed"] = "Los Declarados",
	["The Black Prince"] = "El Príncipe Negro",
	["The Brewmasters"] = "Los Maestros Cerveceros",
	["The Consortium"] = "El Consorcio",
	["The Countess"] = "La Condesa",
	["The Defilers"] = "Los Rapiñadores",
	["The Earthen Ring"] = "El Anillo de la Tierra",
	["The Ember Court"] = "La Corte de Brasas",
	--[[Translation missing --]]
	--[[ ["The First Responders"] = "The First Responders",--]] 
	["The Frostborn"] = "Los Natoescarcha",
	["The Hand of Vengeance"] = "La Mano de la Venganza",
	["The Honorbound"] = "Los Honorables",
	["The Honorbound (Paragon)"] = "Los Honorables (Dechado)",
	["The Kalu'ak"] = "Los Kalu'ak",
	["The Klaxxi"] = "Los Klaxxi",
	["The League of Arathor"] = "Liga de Arathor",
	["The Lorewalkers"] = "Los Eremitas",
	["The Mag'har"] = "Los Mag'har",
	["The Nightfallen"] = "Los caídos de la noche",
	["The Nightfallen (Paragon)"] = "Los caídos de la noche (Dechado)",
	["The Oracles"] = "Los Oráculos",
	["The Saberstalkers"] = "Los Acechadores de sable",
	["The Scale of the Sands"] = "La Escama de las Arenas",
	["The Scryers"] = "Los Arúspices",
	["The Sha'tar"] = "Los Sha'tar",
	["The Silver Covenant"] = "El Pacto de Plata",
	["The Sons of Hodir"] = "Los Hijos de Hodir",
	["The Sunreavers"] = "Los Atracasol",
	["The Taunka"] = "Los taunka",
	["The Tillers"] = "Los Labradores",
	["The Undying Army"] = "El Ejército Inmortal",
	["The Undying Army (Paragon)"] = "El Ejército Inmortal (Dechado)",
	["The Unshackled"] = "Los Desencadenados",
	["The Unshackled (Paragon)"] = "Los Desencadenados (Dechado)",
	["The Violet Eye"] = "El Ojo Violeta",
	["The Wardens"] = "Las Celadoras",
	["The Wardens (Paragon)"] = "Las Celadoras (Dechado)",
	["The Wild Hunt"] = "Cazadores salvajes",
	["The Wild Hunt (Paragon)"] = "Cazadores salvajes (Dechado)",
	["The Wyrmrest Accord"] = "Acuerdo Reposo Dragón",
	["Therazane"] = "Therazane",
	["Thorium Brotherhood"] = "Hermandad del Torio",
	["Thrallmar"] = "Thrallmar",
	["Thunder Bluff"] = "Cima del Trueno",
	["Timbermaw Hold"] = "Bastión Fauces de Madera",
	["Tina Mudclaw"] = "Tina Zarpa Fangosa",
	["Tormmok"] = "Tormmok",
	["Tortollan Seekers"] = "Buscadores tortollanos",
	["Tortollan Seekers (Paragon)"] = "Buscadores tortollanos (Dechado)",
	["Tranquillien"] = "Tranquillien",
	["Tushui Pandaren"] = "Pandaren tushui",
	["Uldum Accord"] = "Acuerdo de Uldum",
	["Uldum Accord (Paragon)"] = "Acuerdo de Uldum (Dechado)",
	["Undercity"] = "Entrañas",
	["Valarjar"] = "Valarjar",
	["Valarjar (Paragon)"] = "Valarjar (Dechado)",
	["Valiance Expedition"] = "Expedición de Denuedo",
	["Ve'nari"] = "Ve'nari",
	["Vim Brineheart"] = "Vim Salmuerazón",
	["Vivianne"] = "Vivianne",
	["Voldunai"] = "Voldunai",
	["Voldunai (Paragon)"] = "Voldunai (Dechado)",
	["Vol'jin's Headhunters"] = "Rebanacabezas de Vol'jin",
	["Vol'jin's Spear"] = "Lanza de Vol'jin",
	["Warsong Offensive"] = "Ofensiva Grito de Guerra",
	["Warsong Outriders"] = "Escoltas Grito de Guerra",
	["Waveblade Ankoan"] = "Ankoano Cuchilla marina",
	["Waveblade Ankoan (Paragon)"] = "Ankoano Cuchilla marina (Dechado)",
	["Wildhammer Clan"] = "Clan Martillo Salvaje",
	["Winterfin Retreat"] = "Retiro Aleta Invernal",
	["Wintersaber Trainers"] = "Instructores de sableinvernales",
	["Wrynn's Vanguard"] = "Vanguardia de Wrynn",
	["Zandalar Tribe"] = "Tribu Zandalar",
	["Zandalari Empire"] = "Imperio zandalari",
	["Zandalari Empire (Paragon)"] = "Imperio zandalari (Dechado)"
}
elseif GAME_LOCALE == "ptBR" then
	lib:SetCurrentTranslations {
	["7th Legion"] = "7ª Legião",
	["7th Legion (Paragon)"] = "7ª Legião (Paragão)",
	["Acquaintance"] = "Conhecido",
	["Aeda Brightdawn"] = "Aeda Brilhalvo",
	["Akama's Trust"] = "Confiança de Akama",
	["Akule Riverhorn"] = "Akule Chifre do Rio",
	["Alexandros Mograine"] = "Alexandros Mograine",
	["Alliance"] = "Aliança",
	["Alliance Vanguard"] = "Vanguarda da Aliança",
	["Arakkoa Outcasts"] = "Arakkoas Proscritos",
	["Arcane Thirst (Oculeth)"] = "Sede Arcana (Oculeth)",
	["Arcane Thirst (Thalyssra)"] = "Sede Arcana (Thalyssra)",
	["Arcane Thirst (Valtrois)"] = "Sede Arcana (Valtrois)",
	["Argent Crusade"] = "Cruzada Argêntea",
	["Argent Dawn"] = "Aurora Argêntea",
	["Argussian Reach"] = "Casta Argussiana",
	--[[Translation missing --]]
	--[[ ["Argussian Reach (Paragon)"] = "Argussian Reach (Paragon)",--]] 
	["Armies of Legionfall"] = "Exércitos da Queda da Legião",
	["Armies of Legionfall (Paragon)"] = "Exércitos da Queda da Legião (Paragão)",
	["Army of the Light"] = "Exército da Luz",
	--[[Translation missing --]]
	--[[ ["Army of the Light (Paragon)"] = "Army of the Light (Paragon)",--]] 
	["Ashtongue Deathsworn"] = "Devotos da Morte Grislíngua",
	["Avengers of Hyjal"] = "Vingadores de Hyjal",
	["Baradin's Wardens"] = "Protetores de Baradin",
	["Baroness Vashj"] = "Baronesa Vashj",
	--[[Translation missing --]]
	--[[ ["Barracks Bodyguards"] = "Barracks Bodyguards",--]] 
	["Best Friend"] = "Melhor Amigo",
	["Bilgewater Cartel"] = "Cartel Borraquilha",
	["Bizmo's Brawlpub"] = "Bar Brigalhada do Bizmo",
	["Bizmo's Brawlpub (Season 1)"] = "Bar Brigalhada do Bizmo (Temporada 1)",
	["Bizmo's Brawlpub (Season 2)"] = "Bar Brigalhada do Bizmo (Temporada 2)",
	["Bizmo's Brawlpub (Season 3)"] = "Bar Brigalhada do Bizmo (Temporada 3)",
	["Bladesman Inowari"] = "Espadachim Inowari",
	["Bloodsail Buccaneers"] = "Bucaneiros da Vela Sangrenta",
	["Booty Bay"] = "Angra do Butim",
	["Brawl'gar Arena"] = "Arena de Brig'ga Fea",
	["Brawl'gar Arena (Season 1)"] = "Arena de Brig'ga Fea (Temporada 1)",
	["Brawl'gar Arena (Season 2)"] = "Arena de Brig'ga Fea (Temporada 2)",
	["Brawl'gar Arena (Season 3)"] = "Arena de Brig'ga Fea (Temporada 3)",
	["Brood of Nozdormu"] = "Prole de Nozdormu",
	["Buddy"] = "Camarada",
	["Cenarion Circle"] = "Círculo Cenariano",
	["Cenarion Expedition"] = "Expedição Cenariana",
	["Champions of Azeroth"] = "Campeões de Azeroth",
	["Champions of Azeroth (Paragon)"] = "Campeões de Azeroth (Paragão)",
	["Chee Chee"] = "Tchi Tchi",
	["Choofa"] = "Xufa",
	["Chromie"] = "Crona",
	["Conjurer Margoss"] = "Conjurador Margoss",
	["Corbyn"] = "Corbyn",
	["Council of Exarchs"] = "Conselho de Exarcas",
	["Court of Farondis"] = "Corte de Farondis",
	["Court of Farondis (Paragon)"] = "Corte de Farondis (Paragão)",
	["Court of Harvesters"] = "Corte dos Ceifadores",
	["Court of Harvesters (Paragon)"] = "Corte dos Ceifadores (Paragão)",
	["Court of Night"] = "Corte da Noite",
	["Cryptkeeper Kassir"] = "Guardião da Cripta Kassir",
	["Darkmoon Faire"] = "Feira de Negraluna",
	["Darkspear Rebellion"] = "Rebelião dos Lançanegra",
	["Darkspear Trolls"] = "Trolls Lançanegra",
	["Darnassus"] = "Darnassus",
	["Defender Illona"] = "Defensora Illona",
	["Delvar Ironfist"] = "Delvar Punho de Ferro",
	["Dominance Offensive"] = "Ofensiva de Dominância",
	["Dragonmaw Clan"] = "Clã Presa do Dragão",
	["Dreamweavers"] = "Tece-sonhos",
	["Dreamweavers (Paragon)"] = "Tece-sonhos (Paragão)",
	["Droman Aliothe"] = "Droman Aliothe",
	["Ella"] = "Ella",
	["Emperor Shaohao"] = "Imperador Shaohao",
	["Everlook"] = "Visteterna",
	["Exalted"] = "Exaltado",
	["Exodar"] = "Exodar",
	["Explorers' League"] = "Liga dos Exploradores",
	["Farmer Fung"] = "Fazendeiro Fung",
	["Farseer Ori"] = "Clarividente Ori",
	["Fish Fellreed"] = "Peixe Cana Alta",
	["Forest Hozen"] = "Hozens da Floresta",
	["Frenzyheart Tribe"] = "Tribo Feralma",
	["Friend"] = "Amigo",
	["Friendly"] = "Respeitado",
	["Frostwolf Clan"] = "Clã Lobo do Gelo",
	["Frostwolf Orcs"] = "Orcs Lobo do Gelo",
	["Gadgetzan"] = "Geringontzan",
	["Gelkis Clan Centaur"] = "Clã dos Centauros Gelkis",
	--[[Translation missing --]]
	--[[ ["Gilnean Survivors"] = "Gilnean Survivors",--]] 
	["Gilneas"] = "Guilnéas",
	["Gina Mudclaw"] = "Gina Garra de Barro",
	["Gnomeregan"] = "Gnomeregan",
	["Gnomeregan Exiles"] = "Gnomeregan",
	["Golden Lotus"] = "Lótus Dourado",
	["Good Friend"] = "Bom Amigo",
	["Grandmaster Vole"] = "Grão-mestre Vole",
	["Guardians of Hyjal"] = "Guardiões de Hyjal",
	["Guild"] = "Guilda",
	["Hand of the Prophet"] = "Mão do Profeta",
	["Haohan Mudclaw"] = "Haohan Garra de Barro",
	["Hellscream's Reach"] = "Punho de Grito Infernal",
	["Highmountain Tribe"] = "Tribo Alta Montanha",
	["Highmountain Tribe (Paragon)"] = "Tribo Alta Montanha (Paragão)",
	["Honeyback Hive"] = "Colmeia Meleira",
	["Honor Hold"] = "Fortaleza da Honra",
	["Honored"] = "Honrado",
	["Horde"] = "Horda",
	["Horde Expedition"] = "Expedição da Horda",
	["Hunt-Captain Korayn"] = "Capitã de Caça Korayn",
	["Hunter Akana"] = "Caçador Akana",
	["Huojin Pandaren"] = "Pandarens Huojin",
	["Hydraxian Waterlords"] = "Senhores das Águas Hidraxianos",
	--[[Translation missing --]]
	--[[ ["Illidari"] = "Illidari",--]] 
	["Ilyssia of the Waters"] = "Ilyssia das Águas",
	["Impus"] = "Diabrius",
	["Ironforge"] = "Altaforja",
	--[[Translation missing --]]
	--[[ ["Jandvik Vrykul"] = "Jandvik Vrykul",--]] 
	["Jogu the Drunk"] = "Be Bum, o Ébrio",
	["Keeper Raynae"] = "Guardiã Raynae",
	["Keepers of Time"] = "Defensores do Tempo",
	["Kirin Tor"] = "Kirin Tor",
	["Kirin Tor Offensive"] = "Ofensiva do Kirin Tor",
	["Kleia and Pelagos"] = "Kleia e Pelagos",
	["Knights of the Ebon Blade"] = "Cavaleiros da Lâmina de Ébano",
	["Kurenai"] = "Kurenai",
	["Lady Moonberry"] = "Lady Lunamora",
	["Laughing Skull Orcs"] = "Orcs Cargaveira",
	["Leorajh"] = "Leorajh",
	["Lower City"] = "Bairro Inferior",
	["Magram Clan Centaur"] = "Clã dos Centauros Magram",
	["Marasmius"] = "Marasmius",
	["Mikanikos"] = "Mikâniko",
	--[[Translation missing --]]
	--[[ ["Moon Guard"] = "Moon Guard",--]] 
	["Moonguard"] = "Guarda da Lua",
	["Nat Pagle"] = "Nat Pagle",
	["Neri Sharpfin"] = "Neri Pinafiada",
	["Netherwing"] = "Asa Etérea",
	["Neutral"] = "Tolerado",
	["Night Fae"] = "Feérios Noturnos",
	["Nomi"] = "Nomi",
	["Ogri'la"] = "Ogri'la",
	["Old Hillpaw"] = "Velho Pata do Monte",
	--[[Translation missing --]]
	--[[ ["Operation: Aardvark"] = "Operation: Aardvark",--]] 
	["Operation: Shieldwall"] = "Operação: Muralha de Escudos",
	["Order of Embers"] = "Ordem das Brasas",
	["Order of Embers (Paragon)"] = "Ordem das Brasas (Paragão)",
	["Order of the Awakened"] = "Ordem dos Despertos",
	["Order of the Cloud Serpent"] = "Ordem da Serpente das Nuvens",
	["Orgrimmar"] = "Orgrimmar",
	["Pearlfin Jinyu"] = "Jinyus Barbatana de Pérola",
	["Plague Deviser Marileth"] = "Arquiteto da Peste Marileth",
	["Poen Gillbrack"] = "Xablau Guelbraque",
	["Polemarch Adrestes"] = "Polemarco Adrestes",
	["Proudmoore Admiralty"] = "Almirantado Proudmore",
	["Proudmoore Admiralty (Paragon)"] = "Almirantado Proudmore (Paragão)",
	["Rajani"] = "Rajani",
	["Rajani (Paragon)"] = "Rajani (Paragão)",
	["Ramkahen"] = "Ramkahen",
	["Rank 1"] = "Rank 1",
	["Rank 2"] = "Rank 2",
	["Rank 3"] = "Rank 3",
	["Rank 4"] = "Rank 4",
	["Rank 5"] = "Rank 5",
	["Rank 6"] = "Rank 5",
	["Rank 7"] = "Rank 6",
	["Rank 8"] = "Rank 8",
	["Ratchet"] = "Vila Catraca",
	["Ravenholdt"] = "Corvoforte",
	["Rendle and Cudgelface"] = "Rasgão e Cara-de-clava",
	["Revered"] = "Reverenciado",
	["Rustbolt Resistance"] = "Resistência Ferrúgia",
	["Rustbolt Resistance (Paragon)"] = "Resistência Ferrúgia (Paragão)",
	["Shado-Pan"] = "Shado-pan",
	["Shado-Pan Assault"] = "Ataque Shado-Pan",
	--[[Translation missing --]]
	--[[ ["Shadowmoon Exiles"] = "Shadowmoon Exiles",--]] 
	["Sha'leth"] = "Sha'leth",
	["Shang Xi's Academy"] = "Academia de Shang Xi",
	["Sha'tari Defense"] = "Defesa Sha'tari",
	["Sha'tari Skyguard"] = "Guarda Aérea Sha'tari",
	["Shattered Sun Offensive"] = "Ofensiva Sol Partido",
	["Shen'dralar"] = "Shen'dralar",
	["Sho"] = "Sho",
	["Sika"] = "Sika",
	["Silvermoon City"] = "Luaprata",
	["Silverwing Sentinels"] = "Sentinelas da Asa de Prata",
	["Sporeggar"] = "Sporeggar",
	["Steamwheedle Draenor Expedition"] = "Expedição a Draenor de Bondebico",
	["Steamwheedle Preservation Society"] = "Sociedade de Preservação de Bondebico",
	["Stitchmasters"] = "Mestres-das-suturas",
	["Stonehead"] = "Cabeça-de-pedra",
	["Stormpike Guard"] = "Guarda de Lançatroz",
	["Storm's Wake"] = "Rastro da Tempestade",
	["Storm's Wake (Paragon)"] = "Rastro da Tempestade (Paragão)",
	["Stormwind"] = "Ventobravo",
	["Stranger"] = "Estranho",
	["Sunreaver Onslaught"] = "Investida Fendessol",
	["Syndicate"] = "Camarilha",
	["Talanji's Expedition"] = "Expedição de Talanji",
	["Talanji's Expedition (Paragon)"] = "Expedição de Talanji (Paragão)",
	["Talonpriest Ishaal"] = "Sacerdote da Garra Ishaal",
	["Talon's Vengeance"] = "Vingança da Garra",
	["The Aldor"] = "Os Aldor",
	["The Anglers"] = "Os Pescadores",
	["The Ascended"] = "Os Ascendidos",
	["The Ascended (Paragon)"] = "Os Ascendidos (Paragão)",
	["The Ashen Verdict"] = "Veredito Cinzento",
	["The August Celestials"] = "Os Celestiais Majestosos",
	["The Avowed"] = "Os Confessos",
	["The Black Prince"] = "O Príncipe Negro",
	["The Brewmasters"] = "Os Mestres Cervejeiros",
	["The Consortium"] = "O Consórcio",
	["The Countess"] = "A Condessa",
	["The Defilers"] = "Os Profanadores",
	["The Earthen Ring"] = "Harmonia Telúrica",
	["The Ember Court"] = "A Corte das Brasas",
	--[[Translation missing --]]
	--[[ ["The First Responders"] = "The First Responders",--]] 
	["The Frostborn"] = "Os Gelonatos",
	["The Hand of Vengeance"] = "A Mão da Vingança",
	["The Honorbound"] = "Brigada da Honra",
	["The Honorbound (Paragon)"] = "Brigada da Honra (Paragão)",
	["The Kalu'ak"] = "Os Kalu'ak",
	["The Klaxxi"] = "Os Klaxxi",
	["The League of Arathor"] = "A Liga de Arathor",
	["The Lorewalkers"] = "Os Andarilhos das Lendas",
	["The Mag'har"] = "Os Mag'har",
	["The Nightfallen"] = "Os Noctívoros",
	["The Nightfallen (Paragon)"] = "Os Noctívoros (Paragão)",
	["The Oracles"] = "Os Oráculos",
	["The Saberstalkers"] = "Os Espreitapresa",
	["The Scale of the Sands"] = "A Escama das Areias",
	["The Scryers"] = "Os Áugures",
	["The Sha'tar"] = "Os Sha'tar",
	["The Silver Covenant"] = "O Pacto de Prata",
	["The Sons of Hodir"] = "Os Filhos de Hodir",
	["The Sunreavers"] = "Os Fendessol",
	["The Taunka"] = "Os Taunka",
	["The Tillers"] = "Os Lavradores",
	["The Undying Army"] = "O Exército Imorredouro",
	["The Undying Army (Paragon)"] = "O Exército Imorredouro (Paragão)",
	["The Unshackled"] = "Os Libertos",
	["The Unshackled (Paragon)"] = "Os Libertos (Paragão)",
	["The Violet Eye"] = "O Olho Violeta",
	["The Wardens"] = "As Guardiãs",
	["The Wardens (Paragon)"] = "As Guardiãs (Paragão)",
	["The Wild Hunt"] = "A Caçada Selvagem",
	["The Wild Hunt (Paragon)"] = "A Caçada Selvagem (Paragão)",
	["The Wyrmrest Accord"] = "A Aliança do Repouso das Serpes",
	["Therazane"] = "Therazane",
	["Thorium Brotherhood"] = "Irmandade do Tório",
	["Thrallmar"] = "Thrallmar",
	["Thunder Bluff"] = "Penhasco do Trovão",
	["Timbermaw Hold"] = "Domínio dos Presamatos",
	["Tina Mudclaw"] = "Tina Garra de Barro",
	["Tormmok"] = "Tormmok",
	["Tortollan Seekers"] = "Peregrinos Tortollanos",
	["Tortollan Seekers (Paragon)"] = "Peregrinos Tortollanos (Paragão)",
	["Tranquillien"] = "Tranquillien",
	["Tushui Pandaren"] = "Pandarens Tushui",
	["Uldum Accord"] = "Acordo de Uldum",
	["Uldum Accord (Paragon)"] = "Acordo de Uldum (Paragão)",
	["Undercity"] = "Cidade Baixa",
	["Valarjar"] = "Valarjares",
	["Valarjar (Paragon)"] = "Valarjar (Paragão)",
	["Valiance Expedition"] = "Expedição Valentia",
	["Ve'nari"] = "Ve'nari",
	["Vim Brineheart"] = "Vim Salcárdio",
	["Vivianne"] = "Vivianne",
	["Voldunai"] = "Voldunai",
	["Voldunai (Paragon)"] = "Voldunai (Paragão)",
	["Vol'jin's Headhunters"] = "Caçadores de Cabeças de Vol'jin",
	["Vol'jin's Spear"] = "Lança de Vol'jin",
	["Warsong Offensive"] = "Ofensiva Brado Guerreiro",
	["Warsong Outriders"] = "Pioneiros do Brado Guerreiro",
	["Waveblade Ankoan"] = "Ankoano Lamionda",
	["Waveblade Ankoan (Paragon)"] = "Ankoano Lamionda (Paragão)",
	["Wildhammer Clan"] = "Clã Martelo Feroz",
	["Winterfin Retreat"] = "Retiro da Falésia Invernal",
	["Wintersaber Trainers"] = "Treinadores de Sabres-do-inverno",
	["Wrynn's Vanguard"] = "Vanguarda de Wrynn",
	["Zandalar Tribe"] = "Tribo Zandalar",
	["Zandalari Empire"] = "Império Zandalari",
	["Zandalari Empire (Paragon)"] = "Império Zandalari (Paragão)"
}
elseif GAME_LOCALE == "itIT" then
	lib:SetCurrentTranslations {
	["7th Legion"] = "VII Legione",
	["7th Legion (Paragon)"] = "VII Legione (Eccellenza)",
	["Acquaintance"] = "Conoscente",
	["Aeda Brightdawn"] = "Aeda Albaluce",
	["Akama's Trust"] = "Fiducia di Akama",
	["Akule Riverhorn"] = "Akule Corno Sinuoso",
	["Alexandros Mograine"] = "Alexandros Mograine",
	["Alliance"] = "Alleanza",
	["Alliance Vanguard"] = "Avanguardia dell'Alleanza",
	["Arakkoa Outcasts"] = "Esiliati Arakkoa",
	["Arcane Thirst (Oculeth)"] = "Sete Arcana (Oculeth)",
	["Arcane Thirst (Thalyssra)"] = "Sete Arcana (Thalyssra)",
	["Arcane Thirst (Valtrois)"] = "Sete Arcana (Valtrois)",
	["Argent Crusade"] = "Crociata d'Argento",
	["Argent Dawn"] = "Alba d'Argento",
	["Argussian Reach"] = "Redentori di Argus",
	--[[Translation missing --]]
	--[[ ["Argussian Reach (Paragon)"] = "Argussian Reach (Paragon)",--]] 
	["Armies of Legionfall"] = "Armata Spezzalegione",
	["Armies of Legionfall (Paragon)"] = "Armata Spezzalegione (Eccellenza)",
	["Army of the Light"] = "Armata della Luce",
	--[[Translation missing --]]
	--[[ ["Army of the Light (Paragon)"] = "Army of the Light (Paragon)",--]] 
	["Ashtongue Deathsworn"] = "Congiurati di Linguamorta",
	["Avengers of Hyjal"] = "Vendicatori di Hyjal",
	["Baradin's Wardens"] = "Custodi di Baradin",
	["Baroness Vashj"] = "Baronessa Vashj",
	["Barracks Bodyguards"] = "Guardie del Corpo della Caserma",
	["Best Friend"] = "Miglior Amico",
	["Bilgewater Cartel"] = "Cartello degli Acqualorda",
	["Bizmo's Brawlpub"] = "Club dei Combattenti di Bizmo",
	["Bizmo's Brawlpub (Season 1)"] = "Club dei Combattenti di Bizmo (Stagione 1)",
	["Bizmo's Brawlpub (Season 2)"] = "Club dei Combattenti di Bizmo (Stagione 2)",
	["Bizmo's Brawlpub (Season 3)"] = "Club dei Combattenti di Bizmo (Stagione 3)",
	["Bladesman Inowari"] = "Spadaccino Inowari",
	["Bloodsail Buccaneers"] = "Bucanieri Velerosse",
	["Booty Bay"] = "Baia del Bottino",
	["Brawl'gar Arena"] = "Arena dei Combattenti",
	["Brawl'gar Arena (Season 1)"] = "Arena dei Combattenti (Stagione 1)",
	["Brawl'gar Arena (Season 2)"] = "Arena dei Combattenti (Stagione 2)",
	["Brawl'gar Arena (Season 3)"] = "Arena dei Combattenti (Stagione 3)",
	["Brood of Nozdormu"] = "Stirpe di Nozdormu",
	["Buddy"] = "Compagno",
	["Cenarion Circle"] = "Circolo Cenariano",
	["Cenarion Expedition"] = "Spedizione Cenariana",
	["Champions of Azeroth"] = "Campioni di Azeroth",
	["Champions of Azeroth (Paragon)"] = "Campioni di Azeroth (Eccellenza)",
	["Chee Chee"] = "Ghi Ghi",
	["Choofa"] = "Chufa",
	["Chromie"] = "Cromie",
	["Conjurer Margoss"] = "Evocatore Margoss",
	["Corbyn"] = "Corbyn",
	["Council of Exarchs"] = "Concilio degli Esarchi",
	["Court of Farondis"] = "Corte di Farondis",
	["Court of Farondis (Paragon)"] = "Corte di Farondis (Eccellenza)",
	["Court of Harvesters"] = "Corte dei Mietitori",
	["Court of Harvesters (Paragon)"] = "Corte dei Mietitori (Eccellenza)",
	["Court of Night"] = "Corte della Notte",
	["Cryptkeeper Kassir"] = "Custode delle Cripte Kassir",
	["Darkmoon Faire"] = "Fiera di Lunacupa",
	["Darkspear Rebellion"] = "Ribellione dei Lanciascura",
	["Darkspear Trolls"] = "Troll Lanciascura",
	["Darnassus"] = "Darnassus",
	["Defender Illona"] = "Difensore Illona",
	["Delvar Ironfist"] = "Delvar Pugnoferreo",
	["Dominance Offensive"] = "Offensiva del Dominio",
	["Dragonmaw Clan"] = "Clan Fauci di Drago",
	["Dreamweavers"] = "Plasmasogni",
	["Dreamweavers (Paragon)"] = "Plasmasogni (Eccellenza)",
	["Droman Aliothe"] = "Droman Aliothe",
	["Ella"] = "Ella",
	["Emperor Shaohao"] = "Imperatore Shaohao",
	["Everlook"] = "Lungavista",
	["Exalted"] = "Osannato",
	["Exodar"] = "Exodar",
	["Explorers' League"] = "Lega degli Esploratori",
	["Farmer Fung"] = "Contadino Fung",
	["Farseer Ori"] = "Chiaroveggente Ori",
	["Fish Fellreed"] = "Trota Mezza Canna",
	["Forest Hozen"] = "Hozen della Foresta",
	["Frenzyheart Tribe"] = "Tribù dei Cuorferoce",
	["Friend"] = "Amico",
	["Friendly"] = "Amichevole",
	["Frostwolf Clan"] = "Clan Lupi Bianchi",
	["Frostwolf Orcs"] = "Orchi Lupi Bianchi",
	["Gadgetzan"] = "Meccania",
	["Gelkis Clan Centaur"] = "Centauri del Clan Gelkis",
	["Gilnean Survivors"] = "Sopravissuti di Gilneas",
	["Gilneas"] = "Gilneas",
	["Gina Mudclaw"] = "Gina Palmo Florido",
	["Gnomeregan"] = "Gnomeregan",
	["Gnomeregan Exiles"] = "Esiliati di Gnomeregan",
	["Golden Lotus"] = "Loto Dorato",
	["Good Friend"] = "Amico Intimo",
	["Grandmaster Vole"] = "Gran Maestro Vole",
	["Guardians of Hyjal"] = "Guardiani di Hyjal",
	["Guild"] = "Gilda",
	["Hand of the Prophet"] = "Mano del Profeta",
	["Haohan Mudclaw"] = "Haohan Palmo Florido",
	["Hellscream's Reach"] = "Avanguardia di Malogrido",
	["Highmountain Tribe"] = "Tribù Alto Monte",
	["Highmountain Tribe (Paragon)"] = "Tribù Alto Monte (Eccellenza)",
	["Honeyback Hive"] = "Alveare Dolcedorso",
	["Honor Hold"] = "Rocca dell'Onore",
	["Honored"] = "Onorato",
	["Horde"] = "Orda",
	["Horde Expedition"] = "Spedizione dell'Orda",
	["Hunt-Captain Korayn"] = "Capitano della Caccia Korayn",
	["Hunter Akana"] = "Cacciatore Akana",
	["Huojin Pandaren"] = "Pandaren Huojin",
	["Hydraxian Waterlords"] = "Seguaci di Idraxis",
	["Illidari"] = "Illidari",
	["Ilyssia of the Waters"] = "Ilyssia delle Acque",
	["Impus"] = "Impus",
	["Ironforge"] = "Forgiardente",
	["Jandvik Vrykul"] = "Vrykul di Jandvik",
	["Jogu the Drunk"] = "Jogu l'Ubriaco",
	["Keeper Raynae"] = "Custode Raynae",
	["Keepers of Time"] = "Custodi del Tempo",
	["Kirin Tor"] = "Kirin Tor",
	["Kirin Tor Offensive"] = "Rivalsa del Kirin Tor",
	["Kleia and Pelagos"] = "Kleia e Pelagos",
	["Knights of the Ebon Blade"] = "Cavalieri della Spada d'Ebano",
	["Kurenai"] = "Kurenai",
	["Lady Moonberry"] = "Dama Baccaluna",
	["Laughing Skull Orcs"] = "Orchi Teschio Ridente",
	["Leorajh"] = "Leorajh",
	["Lower City"] = "Città Bassa",
	["Magram Clan Centaur"] = "Centauri del Clan Magram",
	["Marasmius"] = "Marasmio",
	["Mikanikos"] = "Mikanikos",
	["Moon Guard"] = "Guardie della Luna",
	["Moonguard"] = "Guardie della Luna",
	["Nat Pagle"] = "Nat Pagle",
	["Neri Sharpfin"] = "Neri Pinnafine",
	["Netherwing"] = "Alafatua",
	["Neutral"] = "Neutrale",
	["Night Fae"] = "Silfi della Notte",
	["Nomi"] = "Nomi",
	["Ogri'la"] = "Ogri'la",
	["Old Hillpaw"] = "Vecchio Zampa Brulla",
	["Operation: Aardvark"] = "Operazione: Aardvark",
	["Operation: Shieldwall"] = "Operazione Baluardo",
	["Order of Embers"] = "Ordine delle Braci",
	["Order of Embers (Paragon)"] = "Ordine delle Braci (Eccellenza)",
	["Order of the Awakened"] = "Ordine dei Risvegliati",
	["Order of the Cloud Serpent"] = "Ordine della Serpe delle Nubi",
	["Orgrimmar"] = "Orgrimmar",
	["Pearlfin Jinyu"] = "Jinyu Pinnavitrea",
	["Plague Deviser Marileth"] = "Architetto della Piaga Marileth",
	["Poen Gillbrack"] = "Poen Branchiak",
	["Polemarch Adrestes"] = "Polemarco Adrestes",
	["Proudmoore Admiralty"] = "Ammiragliato dei Marefiero",
	["Proudmoore Admiralty (Paragon)"] = "Ammiragliato dei Marefiero (Eccellenza)",
	["Rajani"] = "Rajani",
	["Rajani (Paragon)"] = "Rajani (Eccellenza)",
	["Ramkahen"] = "Ramkahen",
	["Rank 1"] = "Grado 1",
	["Rank 2"] = "Grado 2",
	["Rank 3"] = "Grado 3",
	["Rank 4"] = "Grado 4",
	["Rank 5"] = "Grado 5",
	["Rank 6"] = "Grado 6",
	["Rank 7"] = "Grado 7",
	["Rank 8"] = "Grado 8",
	["Ratchet"] = "Porto Paranco",
	["Ravenholdt"] = "Corvolesto",
	["Rendle and Cudgelface"] = "Squartacus e Mazzafaccia",
	["Revered"] = "Riverito",
	["Rustbolt Resistance"] = "Resistenza di Bullonaccio",
	["Rustbolt Resistance (Paragon)"] = "Resistenza di Bullonaccio (Eccellenza)",
	["Shado-Pan"] = "Shandaren",
	["Shado-Pan Assault"] = "Avanzata degli Shandaren",
	["Shadowmoon Exiles"] = "Esiliati Torvaluna",
	["Sha'leth"] = "Sha'leth",
	["Shang Xi's Academy"] = "Accademia di Shang Xi",
	["Sha'tari Defense"] = "Protettori Sha'tari",
	["Sha'tari Skyguard"] = "Guardacieli Sha'tari",
	["Shattered Sun Offensive"] = "Offensiva del Sole Infranto",
	["Shen'dralar"] = "Shen'dralar",
	["Sho"] = "Sho",
	["Sika"] = "Sika",
	["Silvermoon City"] = "Lunargenta",
	["Silverwing Sentinels"] = "Sentinelle Alargentea",
	["Sporeggar"] = "Sporeggar",
	["Steamwheedle Draenor Expedition"] = "Spedizione su Draenor degli Spargifumo",
	["Steamwheedle Preservation Society"] = "Società di Preservazione degli Spargifumo",
	["Stitchmasters"] = "Maestri delle Suture",
	["Stonehead"] = "Testaroccia",
	["Stormpike Guard"] = "Guardia dei Piccatonante",
	["Storm's Wake"] = "Destatempesta",
	["Storm's Wake (Paragon)"] = "Destatempesta (Eccellenza)",
	["Stormwind"] = "Roccavento",
	["Stranger"] = "Estraneo",
	["Sunreaver Onslaught"] = "Furia dei Predatori del Sole",
	["Syndicate"] = "Lega dei Tagliagole",
	["Talanji's Expedition"] = "Spedizione di Talanji",
	["Talanji's Expedition (Paragon)"] = "Spedizione di Talanji (Eccellenza)",
	["Talonpriest Ishaal"] = "Sacerdote dell'Artiglio Ishaal",
	["Talon's Vengeance"] = "Vendetta dell'Artiglio",
	["The Aldor"] = "Aldor",
	["The Anglers"] = "Lancialenza",
	["The Ascended"] = "Gli Ascesi",
	["The Ascended (Paragon)"] = "Gli Ascesi (Eccellenza)",
	["The Ashen Verdict"] = "Verdetto Cinereo",
	["The August Celestials"] = "Venerabili Celestiali",
	["The Avowed"] = "Gli Affermati",
	["The Black Prince"] = "Principe Nero",
	["The Brewmasters"] = "Mastri Birrai",
	["The Consortium"] = "Consorzio",
	["The Countess"] = "La Contessa",
	["The Defilers"] = "Profanatori",
	["The Earthen Ring"] = "Circolo della Terra",
	["The Ember Court"] = "La Corte delle Braci",
	["The First Responders"] = "Primi Soccorsi",
	["The Frostborn"] = "Figli del Gelo",
	["The Hand of Vengeance"] = "Mano della Vendetta",
	["The Honorbound"] = "Brigata dell'Onore",
	["The Honorbound (Paragon)"] = "Brigata dell'Onore (Eccellenza)",
	["The Kalu'ak"] = "Kalu'ak",
	["The Klaxxi"] = "Klaxxi",
	["The League of Arathor"] = "Lega di Arathor",
	["The Lorewalkers"] = "Raminghi della Sapienza",
	["The Mag'har"] = "Mag'har",
	["The Nightfallen"] = "Esuli Oscuri",
	["The Nightfallen (Paragon)"] = "Esuli Oscuri (Eccellenza)",
	["The Oracles"] = "Tribù degli Oracoli",
	["The Saberstalkers"] = "Bracconieri Selvaggi",
	["The Scale of the Sands"] = "Scaglie delle Sabbie",
	["The Scryers"] = "Veggenti",
	["The Sha'tar"] = "Sha'tar",
	["The Silver Covenant"] = "Patto d'Argento",
	["The Sons of Hodir"] = "Figli di Hodir",
	["The Sunreavers"] = "Predatori del Sole",
	["The Taunka"] = "Taunka",
	["The Tillers"] = "Coltivatori",
	["The Undying Army"] = "L'Armata Imperitura",
	["The Undying Army (Paragon)"] = "L'Armata Imperitura (Eccellenza)",
	["The Unshackled"] = "Liberti",
	["The Unshackled (Paragon)"] = "Liberti (Eccellenza)",
	["The Violet Eye"] = "Occhio Violaceo",
	["The Wardens"] = "Custodi",
	["The Wardens (Paragon)"] = "Custodi (Eccellenza)",
	["The Wild Hunt"] = "La Caccia Selvaggia",
	["The Wild Hunt (Paragon)"] = "La Caccia Selvaggia (Eccellenza)",
	["The Wyrmrest Accord"] = "Lega dei Draghi",
	["Therazane"] = "Therazane",
	["Thorium Brotherhood"] = "Fratellanza del Torio",
	["Thrallmar"] = "Thrallmar",
	["Thunder Bluff"] = "Picco del Tuono",
	["Timbermaw Hold"] = "Rifugio dei Mordilegno",
	["Tina Mudclaw"] = "Tina Palmo Florido",
	["Tormmok"] = "Tormmok",
	["Tortollan Seekers"] = "Cercatori Tortolliani",
	["Tortollan Seekers (Paragon)"] = "Cercatori Tortolliani (Eccellenza)",
	["Tranquillien"] = "Tranquillien",
	["Tushui Pandaren"] = "Pandaren Tushui",
	["Uldum Accord"] = "Coalizione di Uldum",
	["Uldum Accord (Paragon)"] = "Coalizione di Uldum (Eccellenza)",
	["Undercity"] = "Sepulcra",
	["Valarjar"] = "Valarjar",
	["Valarjar (Paragon)"] = "Valarjar (Eccellenza)",
	["Valiance Expedition"] = "Spedizione degli Arditi",
	["Ve'nari"] = "Ve'nari",
	["Vim Brineheart"] = "Vim Cuorsalmastro",
	["Vivianne"] = "Vivianne",
	["Voldunai"] = "Voldunai",
	["Voldunai (Paragon)"] = "Voldunai (Eccellenza)",
	["Vol'jin's Headhunters"] = "Cacciatori di Teste di Vol'jin",
	["Vol'jin's Spear"] = "Lancia di Vol'jin",
	["Warsong Offensive"] = "Offensiva dei Cantaguerra",
	["Warsong Outriders"] = "Predoni Cantaguerra",
	["Waveblade Ankoan"] = "Ankoan Lamaonda",
	["Waveblade Ankoan (Paragon)"] = "Ankoan Lamaonda (Eccellenza)",
	["Wildhammer Clan"] = "Clan Granmartello",
	["Winterfin Retreat"] = "Rifugio dei Pinnafredda",
	["Wintersaber Trainers"] = "Addestratori delle Fiere Glaciali",
	["Wrynn's Vanguard"] = "Avanguardia di Wrynn",
	["Zandalar Tribe"] = "Tribù Zandalari",
	["Zandalari Empire"] = "Impero degli Zandalari",
	["Zandalari Empire (Paragon)"] = "Impero degli Zandalari (Eccellenza)"
}
elseif GAME_LOCALE == "ruRU" then
	lib:SetCurrentTranslations {
	["7th Legion"] = "7-й легион",
	["7th Legion (Paragon)"] = "7-й легион (идеал)",
	["Acquaintance"] = "Знакомый",
	["Aeda Brightdawn"] = "Аеда Ясная Заря",
	["Akama's Trust"] = "Акама",
	["Akule Riverhorn"] = "Акуле Речной Рог",
	["Alexandros Mograine"] = "Александрос Могрейн",
	["Alliance"] = "Альянс",
	["Alliance Vanguard"] = "Авангард Альянса",
	["Arakkoa Outcasts"] = "Араккоа-изгои",
	["Arcane Thirst (Oculeth)"] = "Жажда магии Окулета",
	["Arcane Thirst (Thalyssra)"] = "Жажда магии Талисры",
	["Arcane Thirst (Valtrois)"] = "Жажда магии Вальтруа",
	["Argent Crusade"] = "Серебряный Авангард",
	["Argent Dawn"] = "Серебряный Рассвет",
	["Argussian Reach"] = "Защитники Аргуса",
	["Argussian Reach (Paragon)"] = "Защитники Аргуса (идеал)",
	["Armies of Legionfall"] = "Армия погибели Легиона",
	["Armies of Legionfall (Paragon)"] = "Армия погибели Легиона (идеал)",
	["Army of the Light"] = "Армия Света",
	["Army of the Light (Paragon)"] = "Армия Света (идеал)",
	["Ashtongue Deathsworn"] = "Пеплоусты-служители",
	["Avengers of Hyjal"] = "Хиджальские мстители",
	["Baradin's Wardens"] = "Защитники Тол Барада",
	["Baroness Vashj"] = "Баронесса Вайш",
	["Barracks Bodyguards"] = "Телохранители из казарм",
	["Best Friend"] = "Лучший друг",
	["Bilgewater Cartel"] = "Картель Трюмных Вод",
	["Bizmo's Brawlpub"] = "Потасовочная У Бизмо",
	["Bizmo's Brawlpub (Season 1)"] = "Потасовочная У Бизмо (сезон 1)",
	["Bizmo's Brawlpub (Season 2)"] = "Потасовочная У Бизмо (сезон 2)",
	["Bizmo's Brawlpub (Season 3)"] = "Потасовочная У Бизмо (3-й сезон)",
	["Bladesman Inowari"] = "Мастер клинка Иновари",
	["Bloodsail Buccaneers"] = "Пираты Кровавого Паруса",
	["Booty Bay"] = "Пиратская Бухта",
	["Brawl'gar Arena"] = "Арена Морд'Бой",
	["Brawl'gar Arena (Season 1)"] = "Арена Морд'Бой (сезон 1)",
	["Brawl'gar Arena (Season 2)"] = "Арена Морд'Бой (сезон 2)",
	["Brawl'gar Arena (Season 3)"] = "Арена Морд'Бой (3-й сезон)",
	["Brood of Nozdormu"] = "Род Ноздорму",
	["Buddy"] = "Приятель",
	["Cenarion Circle"] = "Круг Кенария",
	["Cenarion Expedition"] = "Кенарийская экспедиция",
	["Champions of Azeroth"] = "Защитники Азерот",
	["Champions of Azeroth (Paragon)"] = "Защитники Азерот (идеал)",
	["Chee Chee"] = "Чи-Чи",
	["Choofa"] = "Чуфа",
	["Chromie"] = "Хроми",
	["Conjurer Margoss"] = "Кудесник Маргосс",
	["Corbyn"] = "Корбин",
	["Council of Exarchs"] = "Совет экзархов",
	["Court of Farondis"] = "Двор Фарондиса",
	["Court of Farondis (Paragon)"] = "Двор Фарондиса (идеал)",
	["Court of Harvesters"] = "Двор Жнецов",
	["Court of Harvesters (Paragon)"] = "Двор Жнецов (Идеал)",
	["Court of Night"] = "Двор Ночи",
	["Cryptkeeper Kassir"] = "Хранитель склепа Каззир",
	["Darkmoon Faire"] = "Ярмарка Новолуния",
	["Darkspear Rebellion"] = "Восстание Черного Копья",
	["Darkspear Trolls"] = "Племя Черного Копья",
	["Darnassus"] = "Дарнас",
	["Defender Illona"] = "Защитница Иллона",
	["Delvar Ironfist"] = "Делвар Железный Кулак",
	["Dominance Offensive"] = "Армия Покорителей",
	["Dragonmaw Clan"] = "Клан Драконьей Пасти",
	["Dreamweavers"] = "Ткачи Снов",
	["Dreamweavers (Paragon)"] = "Ткачи Снов (идеал)",
	["Droman Aliothe"] = "Дроман Алиот",
	["Ella"] = "Элла",
	["Emperor Shaohao"] = "Император Шаохао",
	["Everlook"] = "Круговзор",
	["Exalted"] = "Превознесение",
	["Exodar"] = "Экзодар",
	["Explorers' League"] = "Лига исследователей",
	["Farmer Fung"] = "Фермер Фун",
	["Farseer Ori"] = "Оракул Ори",
	["Fish Fellreed"] = "Рыба Тростниковая Шкура",
	["Forest Hozen"] = "Лесные хозены",
	["Frenzyheart Tribe"] = "Племя Бешеного Сердца",
	["Friend"] = "Друг",
	["Friendly"] = "Дружелюбие",
	["Frostwolf Clan"] = "Азеротский клан Северного Волка",
	["Frostwolf Orcs"] = "Клан Северного Волка",
	["Gadgetzan"] = "Прибамбасск",
	["Gelkis Clan Centaur"] = "Кентавры из племени Гелкис",
	["Gilnean Survivors"] = "Выжившие из Гилнеаса",
	["Gilneas"] = "Гилнеас",
	["Gina Mudclaw"] = "Джина Грязный Коготь",
	["Gnomeregan"] = "Гномреган",
	["Gnomeregan Exiles"] = "Изгнанники Гномрегана",
	["Golden Lotus"] = "Золотой Лотос",
	["Good Friend"] = "Хороший друг",
	["Grandmaster Vole"] = "Великий мастер Воул",
	["Guardians of Hyjal"] = "Стражи Хиджала",
	["Guild"] = "Гильдия",
	["Hand of the Prophet"] = "Длань Пророка",
	["Haohan Mudclaw"] = "Хаохань Грязный Коготь",
	["Hellscream's Reach"] = "Батальон Адского Крика",
	["Highmountain Tribe"] = "Племена Крутогорья",
	["Highmountain Tribe (Paragon)"] = "Племена Крутогорья (идеал)",
	["Honeyback Hive"] = "Улей Медокрылов",
	["Honor Hold"] = "Оплот Чести",
	["Honored"] = "Уважение",
	["Horde"] = "Орда",
	["Horde Expedition"] = "Экспедиция Орды",
	["Hunt-Captain Korayn"] = "Капитан-егерь Корейн",
	["Hunter Akana"] = "Мастер охоты Акана",
	["Huojin Pandaren"] = "Пандарены Хоцзинь",
	["Hydraxian Waterlords"] = "Гидраксианские Повелители Вод",
	["Illidari"] = "Иллидари",
	["Ilyssia of the Waters"] = "Илиссия Водная",
	["Impus"] = "Бесс",
	["Ironforge"] = "Стальгорн",
	["Jandvik Vrykul"] = "Яндвикские врайкулы",
	["Jogu the Drunk"] = "Йогу Пьяный",
	["Keeper Raynae"] = "Хранительница Рейна",
	["Keepers of Time"] = "Хранители Времени",
	["Kirin Tor"] = "Кирин-Тор",
	["Kirin Tor Offensive"] = "Армия Кирин-Тора",
	["Kleia and Pelagos"] = "Клейя и Пелагий",
	["Knights of the Ebon Blade"] = "Рыцари Черного Клинка",
	["Kurenai"] = "Куренай",
	["Lady Moonberry"] = "Леди Лунная Ягода",
	["Laughing Skull Orcs"] = "Клан Веселого Черепа",
	["Leorajh"] = "Леорадж",
	["Lower City"] = "Нижний Город",
	["Magram Clan Centaur"] = "Кентавры из племени Маграм",
	["Marasmius"] = "Чесночник",
	["Mikanikos"] = "Миканикос",
	["Moon Guard"] = "Лунные стражи",
	["Moonguard"] = "Лунные стражи",
	["Nat Pagle"] = "Нат Пэгл",
	["Neri Sharpfin"] = "Нери Остроерш",
	["Netherwing"] = "Крылья Пустоты",
	["Neutral"] = "Равнодушие",
	["Night Fae"] = "Ночной народец",
	["Nomi"] = "Номи",
	["Ogri'la"] = "Огри'ла",
	["Old Hillpaw"] = "Старик Горная Лапа",
	["Operation: Aardvark"] = "Операция: Аадварк",
	["Operation: Shieldwall"] = "Операция Заслон",
	["Order of Embers"] = "Орден Пылающих Углей",
	["Order of Embers (Paragon)"] = "Орден Пылающих Углей (идеал)",
	["Order of the Awakened"] = "Орден Пробудившихся",
	["Order of the Cloud Serpent"] = "Орден Облачного Змея",
	["Orgrimmar"] = "Оргриммар",
	["Pearlfin Jinyu"] = "Цзинь-юй Жемчужного Плавника",
	["Plague Deviser Marileth"] = "Изобретатель чумы Марилет",
	["Poen Gillbrack"] = "Поэн Солежабрик",
	["Polemarch Adrestes"] = "Полемарх Адрест",
	["Proudmoore Admiralty"] = "Адмиралтейство Праудмуров",
	["Proudmoore Admiralty (Paragon)"] = "Адмиралтейство Праудмуров (идеал)",
	["Rajani"] = "Раджани",
	["Rajani (Paragon)"] = "Раджани (идеал)",
	["Ramkahen"] = "Рамкахены",
	["Rank 1"] = "Ранг 1",
	["Rank 2"] = "Ранг 2",
	["Rank 3"] = "Ранг 3",
	["Rank 4"] = "Ранг 4",
	["Rank 5"] = "Ранг 5",
	["Rank 6"] = "Ранг 6",
	["Rank 7"] = "Ранг 7",
	["Rank 8"] = "Ранг 8",
	["Ratchet"] = "Кабестан",
	["Ravenholdt"] = "Черный Ворон",
	["Rendle and Cudgelface"] = "Рендл и Дуборыл",
	["Revered"] = "Почтение",
	["Rustbolt Resistance"] = "Ржавоболтское сопротивление",
	["Rustbolt Resistance (Paragon)"] = "Ржавоболтское сопротивление (идеал)",
	["Shado-Pan"] = "Шадо-Пан",
	["Shado-Pan Assault"] = "Натиск Шадо-Пан",
	["Shadowmoon Exiles"] = "Изгнанники клана Призрачной Луны",
	["Sha'leth"] = "Ша'лет",
	["Shang Xi's Academy"] = "Академия Шан Си",
	["Sha'tari Defense"] = "Защитники Ша'тар",
	["Sha'tari Skyguard"] = "Стражи небес Ша'тар",
	["Shattered Sun Offensive"] = "Армия Расколотого Солнца",
	["Shen'dralar"] = "Шен'дралар",
	["Sho"] = "Шо",
	["Sika"] = "Сика",
	["Silvermoon City"] = "Луносвет",
	["Silverwing Sentinels"] = "Среброкрылые Часовые",
	["Sporeggar"] = "Спореггар",
	["Steamwheedle Draenor Expedition"] = "Дренорcкая Экспедиция Хитрой Шестеренки",
	["Steamwheedle Preservation Society"] = "Археологическое общество Хитрой Шестеренки",
	["Stitchmasters"] = "Штопальщики",
	["Stonehead"] = "Камнелоб",
	["Stormpike Guard"] = "Стража Грозовой Вершины",
	["Storm's Wake"] = "Орден Возрождения Шторма",
	["Storm's Wake (Paragon)"] = "Орден Возрождения Шторма (идеал)",
	["Stormwind"] = "Штормград",
	["Stranger"] = "Незнакомец",
	["Sunreaver Onslaught"] = "Войска Похитителей Солнца",
	["Syndicate"] = "Синдикат",
	["Talanji's Expedition"] = "Экспедиция Таланджи",
	["Talanji's Expedition (Paragon)"] = "Экспедиция Таланджи (идеал)",
	["Talonpriest Ishaal"] = "Жрец Когтя Ишааль",
	["Talon's Vengeance"] = "Отмщение Когтя",
	["The Aldor"] = "Алдоры",
	["The Anglers"] = "Рыболовы",
	["The Ascended"] = "Перерожденные",
	["The Ascended (Paragon)"] = "Перерожденные (Идеал)",
	["The Ashen Verdict"] = "Пепельный союз",
	["The August Celestials"] = "Небожители",
	["The Avowed"] = "Нераскаявшиеся",
	["The Black Prince"] = "Черный принц",
	["The Brewmasters"] = "Хмелевары",
	["The Consortium"] = "Консорциум",
	["The Countess"] = "Графиня",
	["The Defilers"] = "Осквернители",
	["The Earthen Ring"] = "Служители Земли",
	["The Ember Court"] = "Пепельный двор",
	["The First Responders"] = "Спасатели",
	["The Frostborn"] = "Зиморожденные",
	["The Hand of Vengeance"] = "Карающая Длань",
	["The Honorbound"] = "Армия Чести",
	["The Honorbound (Paragon)"] = "Армия Чести (идеал)",
	["The Kalu'ak"] = "Калу'ак",
	["The Klaxxi"] = "Клакси",
	["The League of Arathor"] = "Лига Аратора",
	["The Lorewalkers"] = "Хранители истории",
	["The Mag'har"] = "Маг'хары",
	["The Nightfallen"] = "Помраченные",
	["The Nightfallen (Paragon)"] = "Помраченные (идеал)",
	["The Oracles"] = "Оракулы",
	["The Saberstalkers"] = "Охотники за саблеронами",
	["The Scale of the Sands"] = "Песчаная Чешуя",
	["The Scryers"] = "Провидцы",
	["The Sha'tar"] = "Ша'тар",
	["The Silver Covenant"] = "Серебряный Союз",
	["The Sons of Hodir"] = "Сыны Ходира",
	["The Sunreavers"] = "Похитители Солнца",
	["The Taunka"] = "Таунка",
	["The Tillers"] = "Земледельцы",
	["The Undying Army"] = "Неумирающая армия",
	["The Undying Army (Paragon)"] = "Неумирающая армия (Идеал)",
	["The Unshackled"] = "Освобожденные",
	["The Unshackled (Paragon)"] = "Освобожденные (идеал)",
	["The Violet Eye"] = "Аметистовое Око",
	["The Wardens"] = "Стражи",
	["The Wardens (Paragon)"] = "Стражи (идеал)",
	["The Wild Hunt"] = "Дикая Охота",
	["The Wild Hunt (Paragon)"] = "Дикая Охота (Идеал)",
	["The Wyrmrest Accord"] = "Драконий союз",
	["Therazane"] = "Теразан",
	["Thorium Brotherhood"] = "Братство Тория",
	["Thrallmar"] = "Траллмар",
	["Thunder Bluff"] = "Громовой Утес",
	["Timbermaw Hold"] = "Древобрюхи",
	["Tina Mudclaw"] = "Тина Грязный Коготь",
	["Tormmok"] = "Тормок",
	["Tortollan Seekers"] = "Тортолланские искатели",
	["Tortollan Seekers (Paragon)"] = "Тортолланские искатели (идеал)",
	["Tranquillien"] = "Транквиллион",
	["Tushui Pandaren"] = "Пандарены Тушуй",
	["Uldum Accord"] = "Ульдумский союз",
	["Uldum Accord (Paragon)"] = "Ульдумский союз (идеал)",
	["Undercity"] = "Подгород",
	["Valarjar"] = "Валарьяры",
	["Valarjar (Paragon)"] = "Валарьяры (идеал)",
	["Valiance Expedition"] = "Экспедиция Отважных",
	["Ve'nari"] = "Ве'нари",
	["Vim Brineheart"] = "Вим Соленодух",
	["Vivianne"] = "Вивианна",
	["Voldunai"] = "Жители Вол'дуна",
	["Voldunai (Paragon)"] = "Жители Вол'дуна (идеал)",
	["Vol'jin's Headhunters"] = "Охотники за головами",
	["Vol'jin's Spear"] = "Копье Вол'джина",
	["Warsong Offensive"] = "Армия Песни Войны",
	["Warsong Outriders"] = "Всадники Песни Войны",
	["Waveblade Ankoan"] = "Клинки Волн",
	["Waveblade Ankoan (Paragon)"] = "Анкоа из клана Клинков Волн (идеал)",
	["Wildhammer Clan"] = "Клан Громового Молота",
	["Winterfin Retreat"] = "Холодный Плавник",
	["Wintersaber Trainers"] = "Укротители ледопардов",
	["Wrynn's Vanguard"] = "Авангард Ринна",
	["Zandalar Tribe"] = "Племя Зандалари",
	["Zandalari Empire"] = "Империя Зандалари",
	["Zandalari Empire (Paragon)"] = "Империя Зандалари (идеал)"
}
elseif GAME_LOCALE == "zhCN" then
	lib:SetCurrentTranslations {
	["7th Legion"] = "第七军团",
	["7th Legion (Paragon)"] = "第七军团（典范）",
	["Acquaintance"] = "熟人",
	["Aeda Brightdawn"] = "艾达·晨光",
	["Akama's Trust"] = "阿卡玛的信任",
	["Akule Riverhorn"] = "阿库勒·河角",
	["Alexandros Mograine"] = "亚历山德罗斯·莫格莱尼",
	["Alliance"] = "联盟",
	["Alliance Vanguard"] = "联盟先遣军",
	["Arakkoa Outcasts"] = "鸦人流亡者",
	["Arcane Thirst (Oculeth)"] = "魔瘾（欧库勒斯）",
	["Arcane Thirst (Thalyssra)"] = "魔瘾（塔莉萨）",
	["Arcane Thirst (Valtrois)"] = "魔瘾（瓦尔托伊）",
	["Argent Crusade"] = "银色北伐军",
	["Argent Dawn"] = "银色黎明",
	["Argussian Reach"] = "阿古斯防卫军",
	["Argussian Reach (Paragon)"] = "阿古斯防卫军（巅峰）",
	["Armies of Legionfall"] = "抗魔联军",
	["Armies of Legionfall (Paragon)"] = "抗魔联军（典范）",
	["Army of the Light"] = "圣光军团",
	["Army of the Light (Paragon)"] = "圣光军团（巅峰）",
	["Ashtongue Deathsworn"] = "灰舌死誓者",
	["Avengers of Hyjal"] = "海加尔复仇者",
	["Baradin's Wardens"] = "巴拉丁典狱官",
	["Baroness Vashj"] = "瓦丝琪女男爵",
	["Barracks Bodyguards"] = "要塞保镖",
	["Best Friend"] = "挚友",
	["Bilgewater Cartel"] = "锈水财阀",
	["Bizmo's Brawlpub"] = "比兹莫搏击俱乐部",
	["Bizmo's Brawlpub (Season 1)"] = "比兹莫搏击俱乐部（第1赛季）",
	["Bizmo's Brawlpub (Season 2)"] = "比兹莫搏击俱乐部（第2赛季）",
	["Bizmo's Brawlpub (Season 3)"] = "比兹莫搏击俱乐部（第3赛季）",
	["Bladesman Inowari"] = "剑客伊诺瓦里",
	["Bloodsail Buccaneers"] = "血帆海盗",
	["Booty Bay"] = "藏宝海湾",
	["Brawl'gar Arena"] = "搏击竞技场",
	["Brawl'gar Arena (Season 1)"] = "搏击竞技场（第1赛季）",
	["Brawl'gar Arena (Season 2)"] = "搏击竞技场（第2赛季）",
	["Brawl'gar Arena (Season 3)"] = "搏击竞技场（第3赛季）",
	["Brood of Nozdormu"] = "诺兹多姆的子嗣",
	["Buddy"] = "哥们",
	["Cenarion Circle"] = "塞纳里奥议会",
	["Cenarion Expedition"] = "塞纳里奥远征队",
	["Champions of Azeroth"] = "艾泽拉斯的勇士",
	["Champions of Azeroth (Paragon)"] = "艾泽拉斯的勇士（典范）",
	["Chee Chee"] = "吱吱",
	["Choofa"] = "丘法",
	["Chromie"] = "克罗米",
	["Conjurer Margoss"] = "咒法师马戈斯",
	["Corbyn"] = "科尔宾",
	["Council of Exarchs"] = "主教议会",
	["Court of Farondis"] = "法罗迪斯宫廷",
	["Court of Farondis (Paragon)"] = "法罗迪斯宫廷（典范）",
	["Court of Harvesters"] = "收割者之庭",
	["Court of Harvesters (Paragon)"] = "收割者之庭（典范）",
	["Court of Night"] = "魅夜王庭",
	["Cryptkeeper Kassir"] = "地穴看守者卡希尔",
	["Darkmoon Faire"] = "暗月马戏团",
	["Darkspear Rebellion"] = "暗矛起义军",
	["Darkspear Trolls"] = "暗矛巨魔",
	["Darnassus"] = "达纳苏斯",
	["Defender Illona"] = "防御者艾萝娜",
	["Delvar Ironfist"] = "德尔瓦·铁拳",
	["Dominance Offensive"] = "统御先锋军",
	["Dragonmaw Clan"] = "龙喉氏族",
	["Dreamweavers"] = "织梦者",
	["Dreamweavers (Paragon)"] = "织梦者（典范）",
	["Droman Aliothe"] = "宗主艾莉奥瑟",
	["Ella"] = "艾拉",
	["Emperor Shaohao"] = "皇帝少昊",
	["Everlook"] = "永望镇",
	["Exalted"] = "崇拜",
	["Exodar"] = "埃索达",
	["Explorers' League"] = "探险者协会",
	["Farmer Fung"] = "农夫老方",
	["Farseer Ori"] = "先知奥利",
	["Fish Fellreed"] = "玉儿·采苇",
	["Forest Hozen"] = "森林猢狲",
	["Frenzyheart Tribe"] = "狂心氏族",
	["Friend"] = "朋友",
	["Friendly"] = "友善",
	["Frostwolf Clan"] = "霜狼氏族",
	["Frostwolf Orcs"] = "霜狼兽人",
	["Gadgetzan"] = "加基森",
	["Gelkis Clan Centaur"] = "吉尔吉斯半人马",
	["Gilnean Survivors"] = "吉尔尼斯幸存者",
	["Gilneas"] = "吉尔尼斯",
	["Gina Mudclaw"] = "吉娜·泥爪",
	["Gnomeregan"] = "诺莫瑞根",
	["Gnomeregan Exiles"] = "诺莫瑞根流亡者",
	["Golden Lotus"] = "金莲教",
	["Good Friend"] = "好友",
	["Grandmaster Vole"] = "沃尔大师",
	["Guardians of Hyjal"] = "海加尔守护者",
	["Guild"] = "公会",
	["Hand of the Prophet"] = "先知之手",
	["Haohan Mudclaw"] = "郝瀚·泥爪",
	["Hellscream's Reach"] = "地狱咆哮近卫军",
	["Highmountain Tribe"] = "高岭部族",
	["Highmountain Tribe (Paragon)"] = "高岭部族（典范）",
	["Honeyback Hive"] = "蜜背蜂群",
	["Honor Hold"] = "荣耀堡",
	["Honored"] = "尊敬",
	["Horde"] = "部落",
	["Horde Expedition"] = "部落先遣军",
	["Hunt-Captain Korayn"] = "狩猎队长柯莱恩",
	["Hunter Akana"] = "猎人阿卡纳",
	["Huojin Pandaren"] = "火金派熊猫人",
	["Hydraxian Waterlords"] = "海达希亚水元素",
	["Illidari"] = "伊利达雷",
	["Ilyssia of the Waters"] = "“活水”伊丽西娅",
	["Impus"] = "英帕斯",
	["Ironforge"] = "铁炉堡",
	["Jandvik Vrykul"] = "贾德维克维库人",
	["Jogu the Drunk"] = "醉鬼贾古",
	["Keeper Raynae"] = "守护者蕾娜",
	["Keepers of Time"] = "时光守护者",
	["Kirin Tor"] = "肯瑞托",
	["Kirin Tor Offensive"] = "肯瑞托远征军",
	["Kleia and Pelagos"] = "克雷雅和裴拉戈斯",
	["Knights of the Ebon Blade"] = "黑锋骑士团",
	["Kurenai"] = "库雷尼",
	["Lady Moonberry"] = "月莓女勋爵",
	["Laughing Skull Orcs"] = "嘲颅兽人",
	["Leorajh"] = "利奥拉",
	["Lower City"] = "贫民窟",
	["Magram Clan Centaur"] = "玛格拉姆半人马",
	["Marasmius"] = "玛拉斯缪斯",
	["Mikanikos"] = "米卡尼科斯",
	["Moon Guard"] = "月之守卫",
	["Moonguard"] = "月之守卫",
	["Nat Pagle"] = "纳特·帕格",
	["Neri Sharpfin"] = "奈莉·锐鳍",
	["Netherwing"] = "灵翼之龙",
	["Neutral"] = "中立",
	["Night Fae"] = "法夜",
	["Nomi"] = "Nomi",
	["Ogri'la"] = "奥格瑞拉",
	["Old Hillpaw"] = "老农山掌",
	["Operation: Aardvark"] = "阿德瓦克讨伐军",
	["Operation: Shieldwall"] = "神盾守备军",
	["Order of Embers"] = "灰烬骑士团",
	["Order of Embers (Paragon)"] = "灰烬骑士团（典范）",
	["Order of the Awakened"] = "觉醒教派",
	["Order of the Cloud Serpent"] = "云端翔龙骑士团",
	["Orgrimmar"] = "奥格瑞玛",
	["Pearlfin Jinyu"] = "珠鳍锦鱼人",
	["Plague Deviser Marileth"] = "魔药设计师马里莱斯",
	["Poen Gillbrack"] = "鲍恩·分腮",
	["Polemarch Adrestes"] = "文官阿得赖斯提斯",
	["Proudmoore Admiralty"] = "普罗德摩尔海军部",
	["Proudmoore Admiralty (Paragon)"] = "普罗德摩尔海军部（典范）",
	["Rajani"] = "莱加尼",
	["Rajani (Paragon)"] = "莱加尼（典范）",
	["Ramkahen"] = "拉穆卡恒",
	["Rank 1"] = "1级",
	["Rank 2"] = "2级",
	["Rank 3"] = "3级",
	["Rank 4"] = "4级",
	["Rank 5"] = "5级",
	["Rank 6"] = "6级",
	["Rank 7"] = "7级",
	["Rank 8"] = "8级",
	["Ratchet"] = "棘齿城",
	["Ravenholdt"] = "拉文霍德",
	["Rendle and Cudgelface"] = "伦德尔和棍脸",
	["Revered"] = "崇敬",
	["Rustbolt Resistance"] = "锈栓抵抗军",
	["Rustbolt Resistance (Paragon)"] = "锈栓抵抗军（典范）",
	["Shado-Pan"] = "影踪派",
	["Shado-Pan Assault"] = "影踪突袭营",
	["Shadowmoon Exiles"] = "影月流亡者",
	["Sha'leth"] = "莎乐丝",
	["Shang Xi's Academy"] = "尚喜武院",
	["Sha'tari Defense"] = "沙塔尔防御者",
	["Sha'tari Skyguard"] = "沙塔尔天空卫队",
	["Shattered Sun Offensive"] = "破碎残阳",
	["Shen'dralar"] = "辛德拉",
	["Sho"] = "阿烁",
	["Sika"] = "西卡",
	["Silvermoon City"] = "银月城",
	["Silverwing Sentinels"] = "银翼要塞",
	["Sporeggar"] = "孢子村",
	["Steamwheedle Draenor Expedition"] = "热砂港德拉诺探险队",
	["Steamwheedle Preservation Society"] = "热砂保护协会",
	["Stitchmasters"] = "缝合大师",
	["Stonehead"] = "石首",
	["Stormpike Guard"] = "雷矛卫队",
	["Storm's Wake"] = "风暴之末",
	["Storm's Wake (Paragon)"] = "风暴之末（典范）",
	["Stormwind"] = "暴风城",
	["Stranger"] = "陌生人",
	["Sunreaver Onslaught"] = "夺日者先锋军",
	["Syndicate"] = "辛迪加",
	["Talanji's Expedition"] = "塔兰吉远征队",
	["Talanji's Expedition (Paragon)"] = "塔兰吉远征队（典范）",
	["Talonpriest Ishaal"] = "鸦爪祭司伊沙尔",
	["Talon's Vengeance"] = "复仇之爪",
	["The Aldor"] = "奥尔多",
	["The Anglers"] = "垂钓翁",
	["The Ascended"] = "晋升者",
	["The Ascended (Paragon)"] = "晋升者（典范）",
	["The Ashen Verdict"] = "灰烬审判军",
	["The August Celestials"] = "至尊天神",
	["The Avowed"] = "宣罪者",
	["The Black Prince"] = "黑王子",
	["The Brewmasters"] = "酒仙会",
	["The Consortium"] = "星界财团",
	["The Countess"] = "女伯爵",
	["The Defilers"] = "污染者",
	["The Earthen Ring"] = "大地之环",
	["The Ember Court"] = "灰烬王庭",
	["The First Responders"] = "急救队",
	["The Frostborn"] = "霜脉矮人",
	["The Hand of Vengeance"] = "复仇之手",
	["The Honorbound"] = "荣耀战团",
	["The Honorbound (Paragon)"] = "荣耀战团（典范）",
	["The Kalu'ak"] = "卡鲁亚克",
	["The Klaxxi"] = "卡拉克西",
	["The League of Arathor"] = "阿拉索联军",
	["The Lorewalkers"] = "游学者",
	["The Mag'har"] = "玛格汉",
	["The Nightfallen"] = "堕夜精灵",
	["The Nightfallen (Paragon)"] = "堕夜精灵（典范）",
	["The Oracles"] = "神谕者",
	["The Saberstalkers"] = "刃牙追猎者",
	["The Scale of the Sands"] = "流沙之鳞",
	["The Scryers"] = "占星者",
	["The Sha'tar"] = "沙塔尔",
	["The Silver Covenant"] = "银色盟约",
	["The Sons of Hodir"] = "霍迪尔之子",
	["The Sunreavers"] = "夺日者",
	["The Taunka"] = "牦牛人",
	["The Tillers"] = "阡陌客",
	["The Undying Army"] = "不朽军团",
	["The Undying Army (Paragon)"] = "不朽军团（典范）",
	["The Unshackled"] = "破镣者",
	["The Unshackled (Paragon)"] = "破镣者（典范）",
	["The Violet Eye"] = "紫罗兰之眼",
	["The Wardens"] = "守望者",
	["The Wardens (Paragon)"] = "守望者（典范）",
	["The Wild Hunt"] = "荒猎团",
	["The Wild Hunt (Paragon)"] = "荒猎团（典范）",
	["The Wyrmrest Accord"] = "龙眠联军",
	["Therazane"] = "塞拉赞恩",
	["Thorium Brotherhood"] = "瑟银兄弟会",
	["Thrallmar"] = "萨尔玛",
	["Thunder Bluff"] = "雷霆崖",
	["Timbermaw Hold"] = "木喉要塞",
	["Tina Mudclaw"] = "迪娜·泥爪",
	["Tormmok"] = "托莫克",
	["Tortollan Seekers"] = "始祖龟求知者",
	["Tortollan Seekers (Paragon)"] = "始祖龟求知者（典范）",
	["Tranquillien"] = "塔奎林",
	["Tushui Pandaren"] = "土水派熊猫人",
	["Uldum Accord"] = "奥丹姆联军",
	["Uldum Accord (Paragon)"] = "奥丹姆联军（典范）",
	["Undercity"] = "幽暗城",
	["Valarjar"] = "瓦拉加尔",
	["Valarjar (Paragon)"] = "瓦拉加尔（典范）",
	["Valiance Expedition"] = "无畏远征军",
	["Ve'nari"] = "威·娜莉",
	["Vim Brineheart"] = "维姆·盐心",
	["Vivianne"] = "薇薇安",
	["Voldunai"] = "沃顿奈",
	["Voldunai (Paragon)"] = "沃顿奈（典范）",
	["Vol'jin's Headhunters"] = "沃金之锋",
	["Vol'jin's Spear"] = "沃金之矛",
	["Warsong Offensive"] = "战歌远征军",
	["Warsong Outriders"] = "战歌氏族",
	["Waveblade Ankoan"] = "波涛之刃剑鱼人",
	["Waveblade Ankoan (Paragon)"] = "波涛之刃剑鱼人（典范）",
	["Wildhammer Clan"] = "蛮锤部族",
	["Winterfin Retreat"] = "冬鳞避难所",
	["Wintersaber Trainers"] = "冬刃豹训练师",
	["Wrynn's Vanguard"] = "乌瑞恩先锋军",
	["Zandalar Tribe"] = "赞达拉部族",
	["Zandalari Empire"] = "赞达拉帝国",
	["Zandalari Empire (Paragon)"] = "赞达拉帝国（典范）"
}
elseif GAME_LOCALE == "zhTW" then
	lib:SetCurrentTranslations {
	["7th Legion"] = "第七軍團",
	["7th Legion (Paragon)"] = "第七軍團(典範)",
	["Acquaintance"] = "熟識",
	["Aeda Brightdawn"] = "愛伊達‧明曦",
	["Akama's Trust"] = "阿卡瑪之信",
	["Akule Riverhorn"] = "阿庫爾‧河角",
	["Alexandros Mograine"] = "亞歷山卓斯‧莫格萊尼",
	["Alliance"] = "聯盟",
	["Alliance Vanguard"] = "聯盟先鋒",
	["Arakkoa Outcasts"] = "阿拉卡流亡者",
	["Arcane Thirst (Oculeth)"] = "秘法飢渴(歐庫雷斯)",
	["Arcane Thirst (Thalyssra)"] = "秘法飢渴(薩莉瑟拉)",
	["Arcane Thirst (Valtrois)"] = "秘法飢渴(薇兒塔)",
	["Argent Crusade"] = "銀白十字軍",
	["Argent Dawn"] = "銀色黎明",
	["Argussian Reach"] = "阿古斯守望",
	["Argussian Reach (Paragon)"] = "阿古斯守望(典範)",
	["Armies of Legionfall"] = "軍團之殞部隊",
	["Armies of Legionfall (Paragon)"] = "軍團之殞部隊(典範)",
	["Army of the Light"] = "聖光軍團",
	["Army of the Light (Paragon)"] = "聖光軍團(典範)",
	["Ashtongue Deathsworn"] = "灰舌死亡誓言者",
	["Avengers of Hyjal"] = "海加爾復仇者",
	["Baradin's Wardens"] = "巴拉丁鐵衛",
	["Baroness Vashj"] = "瓦許女爵",
	["Barracks Bodyguards"] = "兵營保鏢",
	["Best Friend"] = "最好的朋友",
	["Bilgewater Cartel"] = "污水企業聯合",
	["Bizmo's Brawlpub"] = "畢茲摩鬥陣俱樂部",
	["Bizmo's Brawlpub (Season 1)"] = "畢茲摩鬥陣俱樂部(第一季)",
	["Bizmo's Brawlpub (Season 2)"] = "畢茲摩鬥陣俱樂部(第2季)",
	["Bizmo's Brawlpub (Season 3)"] = "畢茲摩鬥陣俱樂部(第三季)",
	["Bladesman Inowari"] = "劍客伊野斬",
	["Bloodsail Buccaneers"] = "血帆海盜",
	["Booty Bay"] = "藏寶海灣",
	["Brawl'gar Arena"] = "鬥陣競技場",
	["Brawl'gar Arena (Season 1)"] = "鬥陣競技場(第一季)",
	["Brawl'gar Arena (Season 2)"] = "鬥陣競技場(第2季)",
	["Brawl'gar Arena (Season 3)"] = "鬥陣競技場(第三季)",
	["Brood of Nozdormu"] = "諾茲多姆的子嗣",
	["Buddy"] = "夥伴",
	["Cenarion Circle"] = "塞納里奧議會",
	["Cenarion Expedition"] = "塞納里奧遠征隊",
	["Champions of Azeroth"] = "艾澤拉斯的勇士",
	["Champions of Azeroth (Paragon)"] = "艾澤拉斯的勇士(典範)",
	["Chee Chee"] = "奇奇",
	["Choofa"] = "丘發",
	["Chromie"] = "克羅米",
	["Conjurer Margoss"] = "咒術師瑪苟斯",
	["Corbyn"] = "柯爾賓",
	["Council of Exarchs"] = "主教議會",
	["Court of Farondis"] = "法隆迪斯廷衛",
	["Court of Farondis (Paragon)"] = "法隆迪斯廷衛(典範)",
	["Court of Harvesters"] = "收割者廷衛",
	["Court of Harvesters (Paragon)"] = "收割者廷衛(典範)",
	["Court of Night"] = "暗夜之廷",
	["Cryptkeeper Kassir"] = "墓穴守衛者凱希爾",
	["Darkmoon Faire"] = "暗月馬戲團",
	["Darkspear Rebellion"] = "暗矛反抗軍",
	["Darkspear Trolls"] = "暗矛食人妖",
	["Darnassus"] = "達納蘇斯",
	["Defender Illona"] = "防衛者伊蘿娜",
	["Delvar Ironfist"] = "德爾瓦‧鐵拳",
	["Dominance Offensive"] = "制霸先鋒軍",
	["Dragonmaw Clan"] = "龍喉氏族",
	["Dreamweavers"] = "織夢者",
	["Dreamweavers (Paragon)"] = "織夢者(典範)",
	["Droman Aliothe"] = "艾利歐德樹林長",
	["Ella"] = "艾拉",
	["Emperor Shaohao"] = "紹昊大帝",
	["Everlook"] = "永望鎮",
	["Exalted"] = "崇拜",
	["Exodar"] = "艾克索達",
	["Explorers' League"] = "探險者協會",
	["Farmer Fung"] = "農夫老豐",
	["Farseer Ori"] = "先知歐里",
	["Fish Fellreed"] = "小魚‧跌蘆",
	["Forest Hozen"] = "森林猴人",
	["Frenzyheart Tribe"] = "狂心部族",
	["Friend"] = "朋友",
	["Friendly"] = "友方",
	["Frostwolf Clan"] = "霜狼氏族",
	["Frostwolf Orcs"] = "霜狼獸人",
	["Gadgetzan"] = "加基森",
	["Gelkis Clan Centaur"] = "吉爾吉斯半人馬",
	["Gilnean Survivors"] = "吉爾尼斯倖存者",
	["Gilneas"] = "吉爾尼斯",
	["Gina Mudclaw"] = "吉娜‧泥爪",
	["Gnomeregan"] = "諾姆瑞根",
	["Gnomeregan Exiles"] = "諾姆瑞根流亡者",
	["Golden Lotus"] = "金蓮會",
	["Good Friend"] = "好朋友",
	["Grandmaster Vole"] = "沃爾大師",
	["Guardians of Hyjal"] = "海加爾守護者",
	["Guild"] = "公會",
	["Hand of the Prophet"] = "預言者之手",
	["Haohan Mudclaw"] = "好漢‧泥爪",
	["Hellscream's Reach"] = "地獄吼先鋒",
	["Highmountain Tribe"] = "高嶺部族",
	["Highmountain Tribe (Paragon)"] = "高嶺部族(典範)",
	["Honeyback Hive"] = "蜜背蜂巢",
	["Honor Hold"] = "榮譽堡",
	["Honored"] = "尊敬",
	["Horde"] = "部落",
	["Horde Expedition"] = "部落遠征軍",
	["Hunt-Captain Korayn"] = "狩獵隊長克芮恩",
	["Hunter Akana"] = "獵手阿卡納",
	["Huojin Pandaren"] = "火金熊貓人",
	["Hydraxian Waterlords"] = "海達希亞水元素",
	["Illidari"] = "伊利達瑞",
	["Ilyssia of the Waters"] = "『水之守衛者』伊莉西亞",
	["Impus"] = "英普斯",
	["Ironforge"] = "鐵爐堡",
	["Jandvik Vrykul"] = "詹德維克維酷人",
	["Jogu the Drunk"] = "『酒鬼』酒骨",
	["Keeper Raynae"] = "守護者蕾奈",
	["Keepers of Time"] = "時光守望者",
	["Kirin Tor"] = "祈倫托",
	["Kirin Tor Offensive"] = "祈倫托先遣軍",
	["Kleia and Pelagos"] = "克蕾雅與佩拉苟斯",
	["Knights of the Ebon Blade"] = "黯刃騎士團",
	["Kurenai"] = "卡爾奈",
	["Lady Moonberry"] = "月莓女士",
	["Laughing Skull Orcs"] = "獰笑骷髏獸人",
	["Leorajh"] = "雷歐拉杰",
	["Lower City"] = "陰鬱城",
	["Magram Clan Centaur"] = "瑪格拉姆半人馬",
	["Marasmius"] = "瑪拉茲莫斯",
	["Mikanikos"] = "米卡尼寇斯",
	["Moon Guard"] = "月之守衛",
	["Moonguard"] = "月之守衛",
	["Nat Pagle"] = "納特‧帕格",
	["Neri Sharpfin"] = "奈莉‧銳鰭",
	["Netherwing"] = "虛空之翼",
	["Neutral"] = "中立",
	["Night Fae"] = "暗夜妖精",
	["Nomi"] = "糯米",
	["Ogri'la"] = "歐格利拉",
	["Old Hillpaw"] = "老丘爪",
	["Operation: Aardvark"] = "土豚行動",
	["Operation: Shieldwall"] = "鐵壁特遣行動",
	["Order of Embers"] = "燼火會",
	["Order of Embers (Paragon)"] = "燼火會(典範)",
	["Order of the Awakened"] = "覺醒者衛隊",
	["Order of the Cloud Serpent"] = "雲蛟衛",
	["Orgrimmar"] = "奧格瑪",
	["Pearlfin Jinyu"] = "珠鰭錦魚人",
	["Plague Deviser Marileth"] = "瘟疫設計者瑪利雷斯",
	["Poen Gillbrack"] = "波恩‧括鰭",
	["Polemarch Adrestes"] = "軍政官阿德雷特斯",
	["Proudmoore Admiralty"] = "普勞德摩爾海軍府",
	["Proudmoore Admiralty (Paragon)"] = "普勞德摩爾海軍府(典範)",
	["Rajani"] = "萊加尼",
	["Rajani (Paragon)"] = "萊加尼(典範)",
	["Ramkahen"] = "蘭姆卡韓",
	["Rank 1"] = "第1階",
	["Rank 2"] = "第2階",
	["Rank 3"] = "第3階",
	["Rank 4"] = "第4階",
	["Rank 5"] = "第5階",
	["Rank 6"] = "第6階",
	["Rank 7"] = "第7階",
	["Rank 8"] = "第8階",
	["Ratchet"] = "棘齒城",
	["Ravenholdt"] = "拉文霍德",
	["Rendle and Cudgelface"] = "倫德與棍臉",
	["Revered"] = "崇敬",
	["Rustbolt Resistance"] = "鏽栓反抗軍",
	["Rustbolt Resistance (Paragon)"] = "鏽栓反抗軍(典範)",
	["Shado-Pan"] = "影潘",
	["Shado-Pan Assault"] = "影潘之襲",
	["Shadowmoon Exiles"] = "影月流亡者",
	["Sha'leth"] = "夏蕾斯",
	["Shang Xi's Academy"] = "尚羲學院",
	["Sha'tari Defense"] = "撒塔斯守軍",
	["Sha'tari Skyguard"] = "薩塔禦天者",
	["Shattered Sun Offensive"] = "破碎之日進攻部隊",
	["Shen'dralar"] = "辛德拉",
	["Sho"] = "阿秀",
	["Sika"] = "西卡",
	["Silvermoon City"] = "銀月城",
	["Silverwing Sentinels"] = "銀翼哨兵",
	["Sporeggar"] = "斯博格爾",
	["Steamwheedle Draenor Expedition"] = "熱砂德拉諾遠征隊",
	["Steamwheedle Preservation Society"] = "熱砂保護協會",
	["Stitchmasters"] = "縫合大師",
	["Stonehead"] = "岩石頭",
	["Stormpike Guard"] = "雷矛衛隊",
	["Storm's Wake"] = "風暴守望",
	["Storm's Wake (Paragon)"] = "風暴守望(典範)",
	["Stormwind"] = "暴風城",
	["Stranger"] = "陌生人",
	["Sunreaver Onslaught"] = "奪日者先鋒軍",
	["Syndicate"] = "辛迪加",
	["Talanji's Expedition"] = "塔蘭姬的遠征隊",
	["Talanji's Expedition (Paragon)"] = "塔蘭姬的遠征隊(典範)",
	["Talonpriest Ishaal"] = "魔爪祭司艾夏歐",
	["Talon's Vengeance"] = "復仇之爪",
	["The Aldor"] = "奧多爾",
	["The Anglers"] = "釣手隊",
	["The Ascended"] = "晉升者",
	["The Ascended (Paragon)"] = "晉升者(典範)",
	["The Ashen Verdict"] = "灰燼裁決軍",
	["The August Celestials"] = "聖獸天尊",
	["The Avowed"] = "誓復者",
	["The Black Prince"] = "黑龍王子",
	["The Brewmasters"] = "釀酒大師",
	["The Consortium"] = "聯合團",
	["The Countess"] = "女伯爵",
	["The Defilers"] = "污染者",
	["The Earthen Ring"] = "陶土議會",
	["The Ember Court"] = "餘燼宴會",
	["The First Responders"] = "第一應援者",
	["The Frostborn"] = "霜誕矮人",
	["The Hand of Vengeance"] = "復仇之手",
	["The Honorbound"] = "榮勛軍團",
	["The Honorbound (Paragon)"] = "榮勛軍團(典範)",
	["The Kalu'ak"] = "卡魯耶克",
	["The Klaxxi"] = "卡拉西",
	["The League of Arathor"] = "阿拉索聯軍",
	["The Lorewalkers"] = "博學行者",
	["The Mag'har"] = "瑪格哈",
	["The Nightfallen"] = "夜落精靈",
	["The Nightfallen (Paragon)"] = "夜落精靈(典範)",
	["The Oracles"] = "神諭者",
	["The Saberstalkers"] = "劍齒潛獵者",
	["The Scale of the Sands"] = "流沙之鱗",
	["The Scryers"] = "占卜者",
	["The Sha'tar"] = "薩塔",
	["The Silver Covenant"] = "白銀誓盟",
	["The Sons of Hodir"] = "霍迪爾之子",
	["The Sunreavers"] = "奪日者",
	["The Taunka"] = "坦卡族",
	["The Tillers"] = "耕者工會",
	["The Undying Army"] = "不死軍團",
	["The Undying Army (Paragon)"] = "不死軍團(典範)",
	["The Unshackled"] = "破縛者",
	["The Unshackled (Paragon)"] = "破縛者(典範)",
	["The Violet Eye"] = "紫羅蘭之眼",
	["The Wardens"] = "看守者",
	["The Wardens (Paragon)"] = "看守者(典範)",
	["The Wild Hunt"] = "曠野獵者",
	["The Wild Hunt (Paragon)"] = "曠野獵者(典範)",
	["The Wyrmrest Accord"] = "龍眠協調者",
	["Therazane"] = "瑟拉贊恩",
	["Thorium Brotherhood"] = "瑟銀兄弟會",
	["Thrallmar"] = "索爾瑪",
	["Thunder Bluff"] = "雷霆崖",
	["Timbermaw Hold"] = "木喉要塞",
	["Tina Mudclaw"] = "蒂娜‧泥爪",
	["Tormmok"] = "托爾瑪克",
	["Tortollan Seekers"] = "托爾托追尋者",
	["Tortollan Seekers (Paragon)"] = "托爾托追尋者(典範)",
	["Tranquillien"] = "安寧地",
	["Tushui Pandaren"] = "土水熊貓人",
	["Uldum Accord"] = "奧丹姆協議者",
	["Uldum Accord (Paragon)"] = "奧丹姆協議者(典範)",
	["Undercity"] = "幽暗城",
	["Valarjar"] = "華爾拉亞",
	["Valarjar (Paragon)"] = "華爾拉亞(典範)",
	["Valiance Expedition"] = "驍勇遠征軍",
	["Ve'nari"] = "維娜里",
	["Vim Brineheart"] = "維姆‧鹽心",
	["Vivianne"] = "薇薇安妮",
	["Voldunai"] = "沃魯敦人",
	["Voldunai (Paragon)"] = "沃魯敦人(典範)",
	["Vol'jin's Headhunters"] = "沃金獵頭者",
	["Vol'jin's Spear"] = "沃金之矛",
	["Warsong Offensive"] = "戰歌進攻部隊",
	["Warsong Outriders"] = "戰歌先遣騎",
	["Waveblade Ankoan"] = "潮刃安寇恩",
	["Waveblade Ankoan (Paragon)"] = "潮刃安寇恩(典範)",
	["Wildhammer Clan"] = "蠻錘氏族",
	["Winterfin Retreat"] = "冬鰭避居地",
	["Wintersaber Trainers"] = "冬刃豹訓練師",
	["Wrynn's Vanguard"] = "烏瑞恩先鋒",
	["Zandalar Tribe"] = "贊達拉部族",
	["Zandalari Empire"] = "贊達拉帝國",
	["Zandalari Empire (Paragon)"] = "贊達拉帝國(典範)"
}
else
	error(("%s: Locale %q not supported"):format(MAJOR_VERSION, GAME_LOCALE))
end
