local DGV = DugisGuideViewer
if not DGV then return end

local WF = DGV:RegisterModule("DugisWatchFrame")
WF.essential = true

local smallAndObjectiveFrameOneBkg = false

local function GetSmallFrame()
	if DugisGuideViewer.Modules.SmallFrame and DugisSmallFrameContainer and DugisGuideViewer.chardb.EssentialsMode ~= 1 then
		return DugisGuideViewer.Modules.SmallFrame
	end
end

local function GetContainerContentsHeight(container)
	local bottom
	for i, module in ipairs(container.modules) do
		local heightUsed = module:GetContentsHeight();
		if heightUsed > 0 then
			bottom = math.min(bottom or container:GetTop(), module:GetBottom())
		end
	end
	return container:GetTop() - (bottom or container:GetAvailableHeight()) + ObjectiveTrackerFrame.bottomModulePadding
end

function WF:Initialize()  
	if WF.initialized then return end
	WF.initialized = true

	if ElvUI then
		local ElvUI_ = unpack(ElvUI);

		hooksecurefunc(ElvUI_, "UpdateFontTemplates", function()
			DGV.Modules.Objectives:Update()
			ObjectiveTracker_OnFocusedQuestChanged()
		end)
	end   
    

	local flashGroup, flash
	local L, RegisterMethodReaction = DugisLocals, DGV.RegisterMethodReaction
	
	function WF:ShouldModWatchFrame(forceLoaded)
		if forceLoaded then return true end
		return (WF.loaded or forceLoaded)
	end

	function WF:Reset()
	end

	local objectiveTrackerUpdateReaction--, manageFramePositionsReaction
	function WF:Load()
		objectiveTrackerUpdateReaction = RegisterMethodReaction(ObjectiveTrackerFrame, "Update", nil, function()
			if DugisGuideViewer.NamePlate and DugisGuideViewer.NamePlate.OnObjectiveTracker_Update then
				DugisGuideViewer.NamePlate:OnObjectiveTracker_Update()
			end
		end)
	end

	function WF:Unload()
		objectiveTrackerUpdateReaction:Dispose()
	end
	
	if C_AddOns.IsAddOnLoaded("DBM-Core") and DugisGuideViewer:GuideOn() and DugisGuideViewer.chardb.EssentialsMode ~= 1 then 
		hooksecurefunc(DBM, "StartCombat", function()
			DGV:OnDBMUpdate()
		end)	
		hooksecurefunc(DBM, "EndCombat", function()
			DGV:OnDBMUpdate()
		end)		
	end
end