local DGV = DugisGuideViewer
if not DGV then return end

local TaxiData = DGV:RegisterModule("TaxiData")
TaxiData.essential = true

--Possible modes: "veiled-den", "lights-purchase"
TaxiData.currentBeaconMode = "unknown"

function TaxiData:Initialize()

	local fullData
	function TaxiData:GetFullData()
		--107457 Druid
		--98968 Hunter 
		--93465 Death Knight 
		--98114 Alliance Skyfire Triage Camp Stormheim
		--98113 Alliance Lorna's Watch Stormheim
		--98108 Alliance Greywatch Stormheim
		--92560 Horde Cullen's Post Stormheim
		if not fullData then
			fullData = {
	["Neutral"] = {
	},
	["Horde"] = {
	{
		[227902] = {
		"227878:227801",
		"227896:227894",
		"227901:227900",
		"227878:227952",
		["direct"] = "227901:227878:227896",
		["coord"] = 1834061533,
		["m"] = 2351,
		["f"] = 0,
		},
		[227801] = {
		--["name"] = "Entrance Gate, Razorwind Shores",
		["m"] = 2351,
		["coord"] = 2352841513,
		["f"] = 0,
		},
		[227878] = {
		--["name"] = "The Common, Razorwind Shores",
		["direct"] = "227801",
		["coord"] = 2304415981,
		["m"] = 2351,
		["f"] = 0,
		},
		[227901] = {
		"227878:227801",
		--["name"] = "Runetotem's Bounty South, Razorwind Shores",
		["m"] = 2351,
		["coord"] = 2049880821,
		["direct"] = "227878",
		["f"] = 0,
		},
		[227952] = {
		"227896:227878:227801",
		"227896:227894",
		"227896:227901",
		"227896:227900",
		--["name"] = "Cragthorn Highlands, Razorwind Shores",
		["m"] = 2351,
		["coord"] = 2845806808,
		["direct"] = "227878:227896",
		["f"] = 0,
		},
		[227894] = {
		"227896:227878:227801",
		"227896:227901",
		"227896:227900",
		"227896:227878",
		--["name"] = "Saltfang Shoals East, Razorwind Shores",
		["m"] = 2351,
		["coord"] = 2927935853,
		["direct"] = "227896",
		["f"] = 0,
		},
		[227896] = {
		"227878:227801",
		--["name"] = "The Bloom, Razorwind Shores",
		["m"] = 2351,
		["coord"] = 2542254114,
		["direct"] = "227901:227900:227878",
		["f"] = 0,
		},
		[227900] = {
		"227896:227878:227801",
		"227896:227878",
		--["name"] = "The Bluffs, Razorwind Shores",
		["direct"] = "227901",
		["coord"] = 2262946094,
		["m"] = 2351,
		["f"] = 0,
		},
		[11798] = {
			direct = "2995",
			m = 80,
			f = 0,
			coord = 1902015812,
			requirements = "cls:DRUID",
			overridePlayerData = true
		},	
		[52060] = {
			"3615:3310", -- [1]
			"3615:4312", -- [2]
			"2995:6726", -- [3]
			"39330:40358:40769:7824", -- [4]
			"39330:39898", -- [5]
			"3615:8610", -- [6]
			"3615:3310:11139", -- [7]
			"3615:34927:34429:11901", -- [8]
			"3615:34927:12616", -- [9]
			"3615:34927:12616:22931:43073:43085:12740", -- [10]
			"39330:39898:15178", -- [11]
			"39330:40358:40769:7824:10583", -- [12]
			"3615:16227", -- [13]
			"3615:34927:12616:22931", -- [14]
			"39330:40358", -- [15]
			"3615:34927:34429", -- [16]
			"3615:34927", -- [17]
			"3615:34927:34943", -- [18]
			"3615:4312:35141", -- [19]
			"2995:35139:35140", -- [20]
			"2995:35139", -- [21]
			"2995:35556:35562:35315", -- [22]
			"2995:35556:35478", -- [23]
			"2995:35556", -- [24]
			"2995:35556:35562", -- [25]
			"39330:40358:40769:7824:39175", -- [26]
			"2995:40809", -- [27]
			"3615:40558", -- [28]
			"39330:40358:40769", -- [29]
			"39330:40358:40769:7824:41215", -- [30]
			"3615:3310:41140:41142", -- [31]
			"3615:3310:41140", -- [32]
			"39330:40358:40769:7824:41214", -- [33]
			"3615:4312:41246", -- [34]
			"3615:3310:43549:50084", -- [35]
			"3615:3310:43549:50084:53783", -- [36]
			"3615:3310:43549:50084:41861", -- [37]
			"39330:39898:41605:40473", -- [38]
			"39330:39898:41605", -- [39]
			"3615:34927:12616:22931:43073", -- [40]
			"3615:34927:12616:22931:43079", -- [41]
			"3615:34927:12616:22931:43073:43085", -- [42]
			"3615:3310:37005", -- [43]
			"3615:8610:43328", -- [44]
			"3615:3310:43549", -- [45]
			"39330:40358:40769:7824:41215:48275", -- [46]
			"39330:39898:15178:48274", -- [47]
			"39330:39898:15178:48274:48273", -- [48]
			"3615:34927:12616:36728", -- [49]
			"3615:3310:43549:50084:54393", -- [50]
			--["name"] = "Vendetta Point, Southern Barrens",
			["m"] = 199,
			["f"] = 0,
			["direct"] = "2995:3615:44399:11899:39340:39330",
			["coord"] = 1784969748,
		},
		[35556] = {
			"2995:3310", -- [1]
			"2995:3615", -- [2]
			"35478:4312", -- [3]
			"2995:44399", -- [4]
			"35478:6726", -- [5]
			"2995:7824", -- [6]
			"2995:52060:39330:39898", -- [7]
			"2995:8610", -- [8]
			"2995:8610:11139", -- [9]
			"2995:52060:11899", -- [10]
			"35478:4312:11901", -- [11]
			"2995:3615:34927:12616", -- [12]
			"2995:3615:34927:12616:22931:43073:43085:12740", -- [13]
			"35478:6726:40473:41605:15178", -- [14]
			"2995:52060", -- [15]
			"2995:7824:10583", -- [16]
			"2995:3615:16227", -- [17]
			"2995:3615:34927:12616:22931", -- [18]
			"2995:52060:39330:40358", -- [19]
			"35478:4312:34429", -- [20]
			"2995:3615:34927", -- [21]
			"2995:35139:35140:34943", -- [22]
			"35478:4312:35141", -- [23]
			"2995:35139:35140", -- [24]
			"2995:35139", -- [25]
			"35562:35315", -- [26]
			"2995:7824:39175", -- [27]
			"2995:39340", -- [28]
			"2995:52060:39330", -- [29]
			"2995:40809", -- [30]
			"2995:3615:40558", -- [31]
			"2995:52060:39330:40358:40769", -- [32]
			"2995:7824:41215", -- [33]
			"2995:3310:41140:41142", -- [34]
			"2995:3310:41140", -- [35]
			"2995:7824:41214", -- [36]
			"35478:4312:41246", -- [37]
			"2995:3310:43549:50084", -- [38]
			"2995:3310:43549:50084:53783", -- [39]
			"2995:3310:43549:50084:41861", -- [40]
			"35478:6726:40473", -- [41]
			"35478:6726:40473:41605", -- [42]
			"2995:3615:34927:12616:22931:43073", -- [43]
			"2995:3615:34927:12616:22931:43079", -- [44]
			"2995:3615:34927:12616:22931:43073:43085", -- [45]
			"2995:3310:37005", -- [46]
			"2995:8610:43328", -- [47]
			"2995:3310:43549", -- [48]
			"2995:7824:41215:48275", -- [49]
			"35478:6726:40473:41605:15178:48274", -- [50]
			"35478:6726:40473:41605:15178:48274:48273", -- [51]
			"2995:3615:34927:12616:36728", -- [52]
			"2995:3310:43549:50084:54393", -- [53]
			--["name"] = "Thunk's Abode, Desolace",
			["m"] = 66,
			["coord"] = 3034666036,
			["direct"] = "2995:35478:35562",
			["f"] = 0,
		},
		[8610] = {
			"12616:34943:35140:4312", -- [1]
			"3310:3615:44399", -- [2]
			"2995:6726", -- [3]
			"3310:7824", -- [4]
			"3310:3615:52060:39330:39898", -- [5]
			"3310:16227:11899", -- [6]
			"12616:34429:11901", -- [7]
			"11139:12740", -- [8]
			"3310:3615:52060:39330:39898:15178", -- [9]
			"3310:3615:52060", -- [10]
			"3310:7824:10583", -- [11]
			"3310:16227", -- [12]
			"12616:22931", -- [13]
			"3310:16227:11899:40358", -- [14]
			"12616:34429", -- [15]
			"12616:34927", -- [16]
			"12616:34943", -- [17]
			"12616:34429:35141", -- [18]
			"12616:34943:35140", -- [19]
			"3310:3615:35139", -- [20]
			"12616:34943:35140:4312:35315", -- [21]
			"2995:35556:35478", -- [22]
			"2995:35556", -- [23]
			"12616:34943:35140:4312:35315:35562", -- [24]
			"3310:7824:39175", -- [25]
			"3310:3615:39340", -- [26]
			"3310:3615:52060:39330", -- [27]
			"2995:40809", -- [28]
			"3310:40558", -- [29]
			"3310:16227:11899:40358:40769", -- [30]
			"3310:7824:41215", -- [31]
			"3310:41140:41142", -- [32]
			"3310:41140", -- [33]
			"3310:7824:41214", -- [34]
			"12616:34943:35140:41246", -- [35]
			"36728:43549:50084", -- [36]
			"36728:43549:50084:53783", -- [37]
			"36728:43549:50084:41861", -- [38]
			"2995:6726:40473", -- [39]
			"3310:3615:52060:39330:39898:41605", -- [40]
			"11139:43085:43073", -- [41]
			"12616:22931:43079", -- [42]
			"11139:43085", -- [43]
			"36728:43549", -- [44]
			"3310:7824:41215:48275", -- [45]
			"3310:3615:52060:39330:39898:15178:48274", -- [46]
			"3310:3615:52060:39330:39898:15178:48274:48273", -- [47]
			"36728:43549:50084:54393", -- [48]
			--["name"] = "Bilgewater Harbor, Azshara",
			["m"] = 76,
			["f"] = 0,
			["direct"] = "2995:3310:3615:11139:12616:37005:43328:36728",
			["coord"] = 2275573679,
		},
		[39340] = {
			"3615:3310", -- [1]
			"3615:4312", -- [2]
			"52060:44399", -- [3]
			"2995:6726", -- [4]
			"52060:39330:40358:40769:7824", -- [5]
			"52060:39330:39898", -- [6]
			"3615:8610", -- [7]
			"3615:3310:11139", -- [8]
			"52060:11899", -- [9]
			"3615:34927:34429:11901", -- [10]
			"3615:34927:12616", -- [11]
			"3615:34927:12616:22931:43073:43085:12740", -- [12]
			"52060:39330:39898:15178", -- [13]
			"52060:39330:40358:40769:7824:10583", -- [14]
			"3615:16227", -- [15]
			"3615:34927:12616:22931", -- [16]
			"52060:39330:40358", -- [17]
			"3615:34927:34429", -- [18]
			"3615:34927", -- [19]
			"3615:34927:34943", -- [20]
			"2995:35139:35141", -- [21]
			"2995:35139:35140", -- [22]
			"2995:35139", -- [23]
			"2995:35556:35562:35315", -- [24]
			"2995:35556:35478", -- [25]
			"2995:35556", -- [26]
			"2995:35556:35562", -- [27]
			"52060:39330:40358:40769:7824:39175", -- [28]
			"2995:40809", -- [29]
			"3615:40558", -- [30]
			"52060:39330:40358:40769", -- [31]
			"52060:39330:40358:40769:7824:41215", -- [32]
			"3615:3310:41140:41142", -- [33]
			"3615:3310:41140", -- [34]
			"52060:39330:40358:40769:7824:41214", -- [35]
			"3615:4312:41246", -- [36]
			"3615:3310:43549:50084", -- [37]
			"3615:3310:43549:50084:53783", -- [38]
			"3615:3310:43549:50084:41861", -- [39]
			"2995:6726:40473", -- [40]
			"52060:39330:39898:41605", -- [41]
			"3615:34927:12616:22931:43073", -- [42]
			"3615:34927:12616:22931:43079", -- [43]
			"3615:34927:12616:22931:43073:43085", -- [44]
			"3615:3310:37005", -- [45]
			"3615:8610:43328", -- [46]
			"3615:3310:43549", -- [47]
			"52060:39330:40358:40769:7824:41215:48275", -- [48]
			"52060:39330:39898:15178:48274", -- [49]
			"52060:39330:39898:15178:48274:48273", -- [50]
			"3615:34927:12616:36728", -- [51]
			"3615:3310:43549:50084:54393", -- [52]
			--["name"] = "Hunter's Hill, Southern Barrens",
			["m"] = 199,
			["f"] = 0,
			["direct"] = "2995:3615:52060:39330",
			["coord"] = 1707619315,
		},
		[35562] = {
			"35556:2995", -- [1]
			"35556:2995:3310", -- [2]
			"35556:2995:3615", -- [3]
			"35315:4312", -- [4]
			"35556:2995:44399", -- [5]
			"35556:2995:7824", -- [6]
			"35315:39898", -- [7]
			"35556:2995:8610", -- [8]
			"35556:2995:8610:11139", -- [9]
			"35556:2995:52060:11899", -- [10]
			"35315:4312:11901", -- [11]
			"35315:4312:35140:34943:12616", -- [12]
			"35315:4312:34429:22931:43073:43085:12740", -- [13]
			"35315:6726:40473:41605:15178", -- [14]
			"35556:2995:52060", -- [15]
			"35315:6726:40473:41605:15178:39175:10583", -- [16]
			"35556:2995:3615:16227", -- [17]
			"35315:4312:34429:22931", -- [18]
			"35556:2995:52060:39330:40358", -- [19]
			"35315:4312:34429", -- [20]
			"35556:2995:3615:34927", -- [21]
			"35315:4312:35140:34943", -- [22]
			"35315:4312:35141", -- [23]
			"35315:4312:35140", -- [24]
			"35556:2995:35139", -- [25]
			"35315:6726:40473:41605:15178:39175", -- [26]
			"35556:2995:39340", -- [27]
			"35556:2995:52060:39330", -- [28]
			"35556:2995:40809", -- [29]
			"35556:2995:3615:40558", -- [30]
			"35556:2995:52060:39330:40358:40769", -- [31]
			"35556:2995:7824:41215", -- [32]
			"35556:2995:3310:41140:41142", -- [33]
			"35556:2995:3310:41140", -- [34]
			"35556:2995:7824:41214", -- [35]
			"35315:4312:41246", -- [36]
			"35556:2995:3310:43549:50084", -- [37]
			"35556:2995:3310:43549:50084:53783", -- [38]
			"35556:2995:3310:43549:50084:41861", -- [39]
			"35315:6726:40473", -- [40]
			"35315:6726:40473:41605", -- [41]
			"35315:4312:34429:22931:43073", -- [42]
			"35315:4312:34429:22931:43079", -- [43]
			"35315:4312:34429:22931:43073:43085", -- [44]
			"35556:2995:3310:37005", -- [45]
			"35556:2995:8610:43328", -- [46]
			"35556:2995:3310:43549", -- [47]
			"35315:6726:40473:41605:15178:48274:48275", -- [48]
			"35315:6726:40473:41605:15178:48274", -- [49]
			"35315:6726:40473:41605:15178:48274:48273", -- [50]
			"35315:4312:35140:34943:12616:36728", -- [51]
			"35556:2995:3310:43549:50084:54393", -- [52]
			--["name"] = "Ethel Rethor, Desolace",
			["m"] = 66,
			["coord"] = 1675838727,
			["direct"] = "6726:35315:35478:35556",
			["f"] = 0,
		},
		[40358] = {
			"11899:52060:2995", -- [1]
			"11899:16227:3310", -- [2]
			"11899:52060:3615", -- [3]
			"11899:52060:3615:4312", -- [4]
			"44399:39898:41605:40473:6726", -- [5]
			"40769:7824", -- [6]
			"44399:39898", -- [7]
			"11899:16227:3310:8610", -- [8]
			"11899:16227:3310:11139", -- [9]
			"11899:52060:3615:34927:34429:11901", -- [10]
			"11899:52060:3615:34927:12616", -- [11]
			"11899:52060:3615:34927:12616:22931:43073:43085:12740", -- [12]
			"40769:7824:39175:15178", -- [13]
			"11899:52060", -- [14]
			"40769:7824:10583", -- [15]
			"11899:16227", -- [16]
			"11899:52060:3615:34927:12616:22931", -- [17]
			"11899:52060:3615:34927:34429", -- [18]
			"11899:52060:3615:34927", -- [19]
			"11899:52060:3615:34927:34943", -- [20]
			"11899:52060:3615:4312:35141", -- [21]
			"11899:52060:2995:35139:35140", -- [22]
			"11899:52060:2995:35139", -- [23]
			"11899:52060:2995:35556:35562:35315", -- [24]
			"11899:52060:2995:35556:35478", -- [25]
			"11899:52060:2995:35556", -- [26]
			"11899:52060:2995:35556:35562", -- [27]
			"40769:7824:39175", -- [28]
			"11899:52060:39340", -- [29]
			"11899:52060:2995:40809", -- [30]
			"11899:52060:3615:40558", -- [31]
			"40769:7824:41215", -- [32]
			"11899:16227:3310:41140:41142", -- [33]
			"11899:16227:3310:41140", -- [34]
			"40769:7824:41214", -- [35]
			"11899:52060:3615:4312:41246", -- [36]
			"11899:16227:3310:43549:50084", -- [37]
			"11899:16227:3310:43549:50084:53783", -- [38]
			"11899:16227:3310:43549:50084:41861", -- [39]
			"44399:39898:41605:40473", -- [40]
			"44399:39898:41605", -- [41]
			"11899:52060:3615:34927:12616:22931:43073", -- [42]
			"11899:52060:3615:34927:12616:22931:43079", -- [43]
			"11899:52060:3615:34927:12616:22931:43073:43085", -- [44]
			"11899:16227:3310:37005", -- [45]
			"11899:16227:3310:8610:43328", -- [46]
			"11899:16227:3310:43549", -- [47]
			"40769:7824:41215:48275", -- [48]
			"40769:7824:39175:15178:48274", -- [49]
			"40769:7824:41215:48275:48273", -- [50]
			"11899:16227:3310:36728", -- [51]
			"11899:16227:3310:43549:50084:54393", -- [52]
			--["name"] = "Mudsprocket, Dustwallow Marsh",
			["m"] = 70,
			["coord"] = 1841609026,
			["direct"] = "44399:11899:39330:40769",
			["f"] = 0,
		},
		[12740] = {
			"43085:43073:22931:34429:4312:35139:2995", -- [1]
			"41861:50084:43549:3310", -- [2]
			"43085:43073:22931:12616:34927:3615", -- [3]
			"43085:43073:22931:34429:4312", -- [4]
			"43085:43073:22931:12616:34927:3615:44399", -- [5]
			"43085:43073:22931:34429:4312:6726", -- [6]
			"41861:50084:43549:3310:7824", -- [7]
			"43085:43073:22931:12616:34927:3615:52060:39330:39898", -- [8]
			"11139:8610", -- [9]
			"43085:43073:22931:12616:34927:3615:52060:11899", -- [10]
			"43085:43073:22931:34429:11901", -- [11]
			"43085:43073:22931:12616", -- [12]
			"43085:43073:22931:12616:34927:3615:52060:39330:39898:15178", -- [13]
			"43085:43073:22931:12616:34927:3615:52060", -- [14]
			"41861:50084:43549:3310:7824:10583", -- [15]
			"41861:50084:43549:3310:16227", -- [16]
			"43085:43073:22931", -- [17]
			"43085:43073:22931:12616:34927:3615:52060:39330:40358", -- [18]
			"43085:43073:22931:34429", -- [19]
			"43085:43073:22931:12616:34927", -- [20]
			"43085:43073:22931:34429:34943", -- [21]
			"43085:43073:22931:34429:35141", -- [22]
			"43085:43073:22931:34429:34943:35140", -- [23]
			"43085:43073:22931:34429:4312:35139", -- [24]
			"43085:43073:22931:34429:4312:35315", -- [25]
			"43085:43073:22931:34429:4312:35478", -- [26]
			"43085:43073:22931:34429:4312:35478:35556", -- [27]
			"43085:43073:22931:34429:4312:35315:35562", -- [28]
			"41861:50084:43549:3310:7824:39175", -- [29]
			"43085:43073:22931:12616:34927:3615:39340", -- [30]
			"43085:43073:22931:12616:34927:3615:52060:39330", -- [31]
			"43085:43073:22931:34429:4312:35139:2995:40809", -- [32]
			"41861:50084:43549:3310:40558", -- [33]
			"43085:43073:22931:12616:34927:3615:52060:39330:40358:40769", -- [34]
			"41861:50084:43549:3310:7824:41215", -- [35]
			"41861:50084:43549:3310:41140:41142", -- [36]
			"41861:50084:43549:3310:41140", -- [37]
			"41861:50084:43549:3310:7824:41214", -- [38]
			"43085:43073:22931:34429:35141:41246", -- [39]
			"41861:50084", -- [40]
			"41861:53783", -- [41]
			"43085:43073:22931:34429:4312:6726:40473", -- [42]
			"43085:43073:22931:12616:34927:3615:52060:39330:39898:41605", -- [43]
			"43085:43073", -- [44]
			"43085:43073:43079", -- [45]
			"11139:8610:37005", -- [46]
			"11139:8610:43328", -- [47]
			"41861:50084:43549", -- [48]
			"41861:50084:43549:3310:7824:41215:48275", -- [49]
			"43085:43073:22931:12616:34927:3615:52060:39330:39898:15178:48274", -- [50]
			"43085:43073:22931:12616:34927:3615:52060:39330:39898:15178:48274:48273", -- [51]
			"41861:50084:43549:36728", -- [52]
			"41861:50084:54393", -- [53]
			--["name"] = "Moonglade",
			["m"] = 80,
			["f"] = 0,
			["direct"] = "11139:41861:43085",
			["coord"] = 1380886992,
		},
		[41246] = {
			"4312:35139:2995", -- [1]
			"35140:34927:3310", -- [2]
			"4312:3615", -- [3]
			"4312:35139:2995:44399", -- [4]
			"4312:6726", -- [5]
			"4312:35139:2995:7824", -- [6]
			"4312:35139:2995:52060:39330:39898", -- [7]
			"35140:34943:12616:36728:8610", -- [8]
			"35141:34429:22931:43073:43085:11139", -- [9]
			"4312:35139:2995:52060:11899", -- [10]
			"35141:11901", -- [11]
			"35140:34943:12616", -- [12]
			"35141:34429:22931:43073:43085:12740", -- [13]
			"4312:6726:40473:41605:15178", -- [14]
			"4312:35139:2995:52060", -- [15]
			"4312:6726:40473:41605:15178:39175:10583", -- [16]
			"4312:3615:16227", -- [17]
			"35141:34429:22931", -- [18]
			"4312:35139:2995:52060:39330:40358", -- [19]
			"35141:34429", -- [20]
			"35140:34927", -- [21]
			"35140:34943", -- [22]
			"4312:35139", -- [23]
			"4312:35315", -- [24]
			"4312:35478", -- [25]
			"4312:35478:35556", -- [26]
			"4312:35315:35562", -- [27]
			"4312:6726:40473:41605:15178:39175", -- [28]
			"4312:35139:2995:39340", -- [29]
			"4312:35139:2995:52060:39330", -- [30]
			"4312:35139:2995:40809", -- [31]
			"35140:34927:40558", -- [32]
			"4312:35139:2995:52060:39330:40358:40769", -- [33]
			"4312:35139:2995:7824:41215", -- [34]
			"35140:34927:3310:41140:41142", -- [35]
			"35140:34927:3310:41140", -- [36]
			"4312:35139:2995:7824:41214", -- [37]
			"35140:34943:12616:36728:43549:50084", -- [38]
			"35140:34943:12616:36728:43549:50084:53783", -- [39]
			"35140:34943:12616:36728:43549:50084:41861", -- [40]
			"4312:6726:40473", -- [41]
			"4312:6726:40473:41605", -- [42]
			"35141:34429:22931:43073", -- [43]
			"35141:34429:22931:43079", -- [44]
			"35141:34429:22931:43073:43085", -- [45]
			"35140:34943:12616:36728:8610:37005", -- [46]
			"35140:34943:12616:36728:8610:43328", -- [47]
			"35140:34943:12616:36728:43549", -- [48]
			"4312:6726:40473:41605:15178:48274:48275", -- [49]
			"4312:6726:40473:41605:15178:48274", -- [50]
			"4312:6726:40473:41605:15178:48274:48273", -- [51]
			"35140:34943:12616:36728", -- [52]
			"35140:34943:12616:36728:43549:50084:54393", -- [53]
			--["name"] = "The Sludgewerks, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "4312:35141:35140",
			["coord"] = 2311153336,
		},
		[40809] = {
			"2995:3310", -- [1]
			"2995:3615", -- [2]
			"2995:35139:4312", -- [3]
			"2995:44399", -- [4]
			"2995:6726", -- [5]
			"2995:7824", -- [6]
			"2995:52060:39330:39898", -- [7]
			"2995:8610", -- [8]
			"2995:8610:11139", -- [9]
			"2995:52060:11899", -- [10]
			"2995:35139:35141:11901", -- [11]
			"2995:3615:34927:12616", -- [12]
			"2995:3615:34927:12616:22931:43073:43085:12740", -- [13]
			"2995:52060:39330:39898:15178", -- [14]
			"2995:52060", -- [15]
			"2995:7824:10583", -- [16]
			"2995:3615:16227", -- [17]
			"2995:3615:34927:12616:22931", -- [18]
			"2995:52060:39330:40358", -- [19]
			"2995:35139:4312:34429", -- [20]
			"2995:3615:34927", -- [21]
			"2995:35139:35140:34943", -- [22]
			"2995:35139:35141", -- [23]
			"2995:35139:35140", -- [24]
			"2995:35139", -- [25]
			"2995:35556:35562:35315", -- [26]
			"2995:35556:35478", -- [27]
			"2995:35556", -- [28]
			"2995:35556:35562", -- [29]
			"2995:7824:39175", -- [30]
			"2995:39340", -- [31]
			"2995:52060:39330", -- [32]
			"2995:3615:40558", -- [33]
			"2995:52060:39330:40358:40769", -- [34]
			"2995:7824:41215", -- [35]
			"2995:3310:41140:41142", -- [36]
			"2995:3310:41140", -- [37]
			"2995:7824:41214", -- [38]
			"2995:35139:4312:41246", -- [39]
			"2995:3310:43549:50084", -- [40]
			"2995:3310:43549:50084:53783", -- [41]
			"2995:3310:43549:50084:41861", -- [42]
			"2995:6726:40473", -- [43]
			"2995:52060:39330:39898:41605", -- [44]
			"2995:3615:34927:12616:22931:43073", -- [45]
			"2995:3615:34927:12616:22931:43079", -- [46]
			"2995:3615:34927:12616:22931:43073:43085", -- [47]
			"2995:3310:37005", -- [48]
			"2995:8610:43328", -- [49]
			"2995:3310:43549", -- [50]
			"2995:7824:41215:48275", -- [51]
			"2995:52060:39330:39898:15178:48274", -- [52]
			"2995:52060:39330:39898:15178:48274:48273", -- [53]
			"2995:3615:34927:12616:36728", -- [54]
			"2995:3310:43549:50084:54393", -- [55]
			--["name"] = "Bloodhoof Village, Mulgore",
			["m"] = 7,
			["f"] = 0,
			["direct"] = "2995",
			["coord"] = 2035783201,
		},
		[35141] = {
			"35139:2995", -- [1]
			"34429:12616:3310", -- [2]
			"35139:3615", -- [3]
			"35139:2995:44399", -- [4]
			"41246:4312:6726", -- [5]
			"35139:2995:7824", -- [6]
			"35139:2995:52060:39330:39898", -- [7]
			"34429:12616:36728:8610", -- [8]
			"34429:22931:43073:43085:11139", -- [9]
			"35139:2995:52060:11899", -- [10]
			"34429:12616", -- [11]
			"34429:22931:43073:43085:12740", -- [12]
			"41246:4312:6726:40473:41605:15178", -- [13]
			"35139:2995:52060", -- [14]
			"35139:2995:7824:10583", -- [15]
			"35139:3615:16227", -- [16]
			"34429:22931", -- [17]
			"35139:2995:52060:39330:40358", -- [18]
			"35140:34927", -- [19]
			"34429:34943", -- [20]
			"41246:4312:35315", -- [21]
			"41246:4312:35478", -- [22]
			"41246:4312:35478:35556", -- [23]
			"41246:4312:35315:35562", -- [24]
			"41246:4312:6726:40473:41605:15178:39175", -- [25]
			"35139:2995:39340", -- [26]
			"35139:2995:52060:39330", -- [27]
			"35139:2995:40809", -- [28]
			"35139:3615:40558", -- [29]
			"35139:2995:52060:39330:40358:40769", -- [30]
			"35139:2995:7824:41215", -- [31]
			"34429:12616:3310:41140:41142", -- [32]
			"34429:12616:3310:41140", -- [33]
			"35139:2995:7824:41214", -- [34]
			"34429:12616:36728:43549:50084", -- [35]
			"34429:12616:36728:43549:50084:53783", -- [36]
			"34429:12616:36728:43549:50084:41861", -- [37]
			"41246:4312:6726:40473", -- [38]
			"41246:4312:6726:40473:41605", -- [39]
			"34429:22931:43073", -- [40]
			"34429:22931:43079", -- [41]
			"34429:22931:43073:43085", -- [42]
			"34429:12616:36728:8610:37005", -- [43]
			"34429:12616:36728:8610:43328", -- [44]
			"34429:12616:36728:43549", -- [45]
			"41246:4312:6726:40473:41605:15178:48274:48275", -- [46]
			"41246:4312:6726:40473:41605:15178:48274", -- [47]
			"41246:4312:6726:40473:41605:15178:48274:48273", -- [48]
			"34429:12616:36728", -- [49]
			"34429:12616:36728:43549:50084:54393", -- [50]
			--["name"] = "Cliffwalker Post, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "4312:11901:34429:35140:35139:41246",
			["coord"] = 1936477991,
		},
		[39175] = {
			"7824:2995", -- [1]
			"7824:16227:3310", -- [2]
			"7824:3615", -- [3]
			"7824:2995:35139:4312", -- [4]
			"7824:44399", -- [5]
			"7824:39898:41605:40473:6726", -- [6]
			"7824:39898", -- [7]
			"7824:16227:3310:8610", -- [8]
			"7824:16227:3310:11139", -- [9]
			"7824:40769:40358:11899", -- [10]
			"7824:3615:34927:34429:11901", -- [11]
			"7824:3615:34927:12616", -- [12]
			"7824:16227:3310:43549:50084:41861:12740", -- [13]
			"7824:40769:40358:11899:52060", -- [14]
			"7824:16227", -- [15]
			"7824:3615:34927:12616:22931", -- [16]
			"7824:40769:40358", -- [17]
			"7824:3615:34927:34429", -- [18]
			"7824:3615:34927", -- [19]
			"7824:3615:34927:34943", -- [20]
			"7824:2995:35139:35141", -- [21]
			"7824:2995:35139:35140", -- [22]
			"7824:2995:35139", -- [23]
			"7824:2995:35556:35562:35315", -- [24]
			"7824:2995:35556:35478", -- [25]
			"7824:2995:35556", -- [26]
			"7824:2995:35556:35562", -- [27]
			"7824:40769:40358:11899:52060:39340", -- [28]
			"7824:40769:40358:39330", -- [29]
			"7824:2995:40809", -- [30]
			"7824:3615:40558", -- [31]
			"7824:40769", -- [32]
			"7824:41215", -- [33]
			"7824:16227:3310:41140:41142", -- [34]
			"7824:16227:3310:41140", -- [35]
			"7824:41214", -- [36]
			"7824:2995:35139:4312:41246", -- [37]
			"7824:16227:3310:43549:50084", -- [38]
			"7824:16227:3310:43549:50084:53783", -- [39]
			"7824:16227:3310:43549:50084:41861", -- [40]
			"7824:39898:41605:40473", -- [41]
			"7824:39898:41605", -- [42]
			"7824:3615:34927:12616:22931:43073", -- [43]
			"7824:3615:34927:12616:22931:43079", -- [44]
			"7824:3615:34927:12616:22931:43073:43085", -- [45]
			"7824:16227:3310:37005", -- [46]
			"7824:16227:3310:8610:43328", -- [47]
			"7824:16227:3310:43549", -- [48]
			"7824:41215:48275", -- [49]
			"7824:41215:48275:48274", -- [50]
			"7824:41215:48275:48273", -- [51]
			"7824:16227:3310:36728", -- [52]
			"7824:16227:3310:43549:50084:54393", -- [53]
			--["name"] = "Mossy Pile, Un'Goro Crater",
			["m"] = 78,
			["coord"] = 1890412268,
			["direct"] = "7824:10583",
			["f"] = 0,
		},
		[43085] = {
			"43073:22931:34429:4312:35139:2995", -- [1]
			"43073:22931:12616:3310", -- [2]
			"43073:22931:12616:34927:3615", -- [3]
			"43073:22931:34429:4312", -- [4]
			"43073:22931:12616:34927:3615:44399", -- [5]
			"43073:22931:34429:4312:6726", -- [6]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824", -- [7]
			"43073:22931:12616:34927:3615:52060:39330:39898", -- [8]
			"11139:8610", -- [9]
			"43073:22931:12616:34927:3615:52060:11899", -- [10]
			"43073:22931:34429:11901", -- [11]
			"43073:22931:12616", -- [12]
			"43073:22931:12616:34927:3615:52060:39330:39898:15178", -- [13]
			"43073:22931:12616:34927:3615:52060", -- [14]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:10583", -- [15]
			"43073:22931:12616:34927:3615:16227", -- [16]
			"43073:22931", -- [17]
			"43073:22931:12616:34927:3615:52060:39330:40358", -- [18]
			"43073:22931:34429", -- [19]
			"43073:22931:12616:34927", -- [20]
			"43073:22931:34429:34943", -- [21]
			"43073:22931:34429:35141", -- [22]
			"43073:22931:34429:34943:35140", -- [23]
			"43073:22931:34429:4312:35139", -- [24]
			"43073:22931:34429:4312:35315", -- [25]
			"43073:22931:34429:4312:35478", -- [26]
			"43073:22931:34429:4312:35478:35556", -- [27]
			"43073:22931:34429:4312:35315:35562", -- [28]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:39175", -- [29]
			"43073:22931:12616:34927:3615:39340", -- [30]
			"43073:22931:12616:34927:3615:52060:39330", -- [31]
			"43073:22931:34429:4312:35139:2995:40809", -- [32]
			"43073:22931:12616:34927:40558", -- [33]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769", -- [34]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:41215", -- [35]
			"43073:22931:12616:3310:41140:41142", -- [36]
			"43073:22931:12616:3310:41140", -- [37]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:41214", -- [38]
			"43073:22931:34429:35141:41246", -- [39]
			"12740:41861:50084", -- [40]
			"12740:41861:53783", -- [41]
			"12740:41861", -- [42]
			"43073:22931:34429:4312:6726:40473", -- [43]
			"43073:22931:12616:34927:3615:52060:39330:39898:41605", -- [44]
			"43073:43079", -- [45]
			"11139:8610:37005", -- [46]
			"11139:8610:43328", -- [47]
			"12740:41861:50084:43549", -- [48]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769:7824:41215:48275", -- [49]
			"43073:22931:12616:34927:3615:52060:39330:39898:15178:48274", -- [50]
			"43073:22931:12616:34927:3615:52060:39330:39898:15178:48274:48273", -- [51]
			"43073:22931:12616:36728", -- [52]
			"12740:41861:50084:54393", -- [53]
			--["name"] = "Irontree Clearing, Felwood",
			["m"] = 77,
			["f"] = 0,
			["direct"] = "11139:12740:43073",
			["coord"] = 2421691862,
		},
		[54393] = {
			"50084:43549:3310:3615:2995", -- [1]
			"50084:43549:3310", -- [2]
			"50084:43549:3310:3615", -- [3]
			"50084:43549:36728:12616:34943:35140:4312", -- [4]
			"50084:43549:3310:3615:44399", -- [5]
			"50084:43549:36728:12616:34943:35140:4312:6726", -- [6]
			"50084:43549:3310:7824", -- [7]
			"50084:43549:3310:3615:52060:39330:39898", -- [8]
			"50084:43549:36728:8610", -- [9]
			"50084:41861:11139", -- [10]
			"50084:43549:3310:16227:11899", -- [11]
			"50084:43549:36728:12616:34429:11901", -- [12]
			"50084:43549:36728:12616", -- [13]
			"50084:41861:12740", -- [14]
			"50084:43549:3310:3615:52060:39330:39898:15178", -- [15]
			"50084:43549:3310:3615:52060", -- [16]
			"50084:43549:3310:7824:10583", -- [17]
			"50084:43549:3310:16227", -- [18]
			"50084:43549:36728:12616:22931", -- [19]
			"50084:43549:3310:16227:11899:40358", -- [20]
			"50084:43549:36728:12616:34429", -- [21]
			"50084:43549:36728:12616:34927", -- [22]
			"50084:43549:36728:12616:34943", -- [23]
			"50084:43549:36728:12616:34429:35141", -- [24]
			"50084:43549:36728:12616:34943:35140", -- [25]
			"50084:43549:36728:12616:34943:35140:35139", -- [26]
			"50084:43549:36728:12616:34943:35140:4312:35315", -- [27]
			"50084:43549:36728:12616:34943:35140:4312:35478", -- [28]
			"50084:43549:3310:3615:2995:35556", -- [29]
			"50084:43549:36728:12616:34943:35140:4312:35315:35562", -- [30]
			"50084:43549:3310:7824:39175", -- [31]
			"50084:43549:3310:3615:39340", -- [32]
			"50084:43549:3310:3615:52060:39330", -- [33]
			"50084:43549:3310:3615:2995:40809", -- [34]
			"50084:43549:3310:40558", -- [35]
			"50084:43549:3310:16227:11899:40358:40769", -- [36]
			"50084:43549:3310:7824:41215", -- [37]
			"50084:43549:3310:41140:41142", -- [38]
			"50084:43549:3310:41140", -- [39]
			"50084:43549:3310:7824:41214", -- [40]
			"50084:43549:36728:12616:34943:35140:41246", -- [41]
			"50084:53783", -- [42]
			"50084:41861", -- [43]
			"50084:43549:36728:12616:34943:35140:4312:6726:40473", -- [44]
			"50084:43549:3310:3615:52060:39330:39898:41605", -- [45]
			"50084:41861:12740:43085:43073", -- [46]
			"50084:43549:36728:12616:22931:43079", -- [47]
			"50084:41861:12740:43085", -- [48]
			"50084:43549:36728:8610:37005", -- [49]
			"50084:43549:36728:8610:43328", -- [50]
			"50084:43549", -- [51]
			"50084:43549:3310:7824:41215:48275", -- [52]
			"50084:43549:3310:3615:52060:39330:39898:15178:48274", -- [53]
			"50084:43549:3310:3615:52060:39330:39898:15178:48274:48273", -- [54]
			"50084:43549:36728", -- [55]
			--["name"] = "Sanctuary of Malorne, Hyjal",
			["m"] = 198,
			["f"] = 0,
			["direct"] = "50084",
			["coord"] = 1192010387,
		},
		[43073] = {
			"22931:34429:4312:35139:2995", -- [1]
			"22931:12616:3310", -- [2]
			"22931:12616:34927:3615", -- [3]
			"22931:34429:4312", -- [4]
			"22931:12616:34927:3615:44399", -- [5]
			"22931:34429:4312:6726", -- [6]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824", -- [7]
			"22931:12616:34927:3615:52060:39330:39898", -- [8]
			"43085:11139:8610", -- [9]
			"43085:11139", -- [10]
			"22931:12616:34927:3615:52060:11899", -- [11]
			"22931:34429:11901", -- [12]
			"22931:12616", -- [13]
			"43085:12740", -- [14]
			"22931:12616:34927:3615:52060:39330:39898:15178", -- [15]
			"22931:12616:34927:3615:52060", -- [16]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:10583", -- [17]
			"22931:12616:34927:3615:16227", -- [18]
			"22931:12616:34927:3615:52060:39330:40358", -- [19]
			"22931:34429", -- [20]
			"22931:12616:34927", -- [21]
			"22931:34429:34943", -- [22]
			"22931:34429:35141", -- [23]
			"22931:34429:34943:35140", -- [24]
			"22931:34429:4312:35139", -- [25]
			"22931:34429:4312:35315", -- [26]
			"22931:34429:4312:35478", -- [27]
			"22931:34429:4312:35478:35556", -- [28]
			"22931:34429:4312:35315:35562", -- [29]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:39175", -- [30]
			"22931:12616:34927:3615:39340", -- [31]
			"22931:12616:34927:3615:52060:39330", -- [32]
			"22931:34429:4312:35139:2995:40809", -- [33]
			"22931:12616:34927:40558", -- [34]
			"22931:12616:34927:3615:52060:39330:40358:40769", -- [35]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:41215", -- [36]
			"22931:12616:3310:41140:41142", -- [37]
			"22931:12616:3310:41140", -- [38]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:41214", -- [39]
			"22931:34429:35141:41246", -- [40]
			"43085:12740:41861:50084", -- [41]
			"43085:12740:41861:53783", -- [42]
			"43085:12740:41861", -- [43]
			"22931:34429:4312:6726:40473", -- [44]
			"22931:12616:34927:3615:52060:39330:39898:41605", -- [45]
			"43085:11139:8610:37005", -- [46]
			"43085:11139:8610:43328", -- [47]
			"22931:12616:36728:43549", -- [48]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:41215:48275", -- [49]
			"22931:12616:34927:3615:52060:39330:39898:15178:48274", -- [50]
			"22931:12616:34927:3615:52060:39330:39898:15178:48274:48273", -- [51]
			"22931:12616:36728", -- [52]
			"43085:12740:41861:50084:54393", -- [53]
			--["name"] = "Whisperwind Grove, Felwood",
			["m"] = 77,
			["f"] = 0,
			["direct"] = "22931:43079:43085",
			["coord"] = 1872382313,
		},
		[36728] = {
			"3310:3615:2995", -- [1]
			"3310:3615", -- [2]
			"12616:34943:35140:4312", -- [3]
			"3310:3615:44399", -- [4]
			"12616:34943:35140:4312:6726", -- [5]
			"3310:7824", -- [6]
			"3310:3615:52060:39330:39898", -- [7]
			"8610:11139", -- [8]
			"3310:16227:11899", -- [9]
			"12616:34429:11901", -- [10]
			"43549:50084:41861:12740", -- [11]
			"3310:3615:52060:39330:39898:15178", -- [12]
			"3310:3615:52060", -- [13]
			"3310:7824:10583", -- [14]
			"3310:16227", -- [15]
			"12616:22931", -- [16]
			"3310:16227:11899:40358", -- [17]
			"12616:34429", -- [18]
			"12616:34927", -- [19]
			"12616:34943", -- [20]
			"12616:34429:35141", -- [21]
			"12616:34943:35140", -- [22]
			"12616:34943:35140:35139", -- [23]
			"12616:34943:35140:4312:35315", -- [24]
			"12616:34943:35140:4312:35478", -- [25]
			"3310:3615:2995:35556", -- [26]
			"12616:34943:35140:4312:35315:35562", -- [27]
			"3310:7824:39175", -- [28]
			"3310:3615:39340", -- [29]
			"3310:3615:52060:39330", -- [30]
			"3310:3615:2995:40809", -- [31]
			"3310:40558", -- [32]
			"3310:16227:11899:40358:40769", -- [33]
			"3310:7824:41215", -- [34]
			"3310:41140:41142", -- [35]
			"3310:41140", -- [36]
			"3310:7824:41214", -- [37]
			"12616:34943:35140:41246", -- [38]
			"43549:50084", -- [39]
			"43549:50084:53783", -- [40]
			"43549:50084:41861", -- [41]
			"12616:34943:35140:4312:6726:40473", -- [42]
			"3310:3615:52060:39330:39898:41605", -- [43]
			"12616:22931:43073", -- [44]
			"12616:22931:43079", -- [45]
			"12616:22931:43073:43085", -- [46]
			"8610:37005", -- [47]
			"8610:43328", -- [48]
			"3310:7824:41215:48275", -- [49]
			"3310:3615:52060:39330:39898:15178:48274", -- [50]
			"3310:3615:52060:39330:39898:15178:48274:48273", -- [51]
			"43549:50084:54393", -- [52]
			--["name"] = "Valormok, Azshara",
			["m"] = 76,
			["f"] = 0,
			["direct"] = "3310:8610:12616:43549",
			["coord"] = 614114972,
		},
		[41140] = {
			"3310:3615:2995", -- [1]
			"3310:3615", -- [2]
			"3310:3615:4312", -- [3]
			"3310:3615:44399", -- [4]
			"3310:3615:2995:6726", -- [5]
			"3310:7824", -- [6]
			"3310:3615:52060:39330:39898", -- [7]
			"3310:8610", -- [8]
			"3310:11139", -- [9]
			"3310:16227:11899", -- [10]
			"3310:12616:34429:11901", -- [11]
			"3310:12616", -- [12]
			"3310:43549:50084:41861:12740", -- [13]
			"3310:3615:52060:39330:39898:15178", -- [14]
			"3310:3615:52060", -- [15]
			"3310:7824:10583", -- [16]
			"3310:16227", -- [17]
			"3310:12616:22931", -- [18]
			"3310:16227:11899:40358", -- [19]
			"3310:12616:34429", -- [20]
			"3310:34927", -- [21]
			"3310:12616:34943", -- [22]
			"3310:12616:34429:35141", -- [23]
			"3310:12616:34943:35140", -- [24]
			"3310:3615:35139", -- [25]
			"3310:3615:2995:35556:35562:35315", -- [26]
			"3310:3615:2995:35556:35478", -- [27]
			"3310:3615:2995:35556", -- [28]
			"3310:3615:2995:35556:35562", -- [29]
			"3310:7824:39175", -- [30]
			"3310:3615:39340", -- [31]
			"3310:3615:52060:39330", -- [32]
			"3310:3615:2995:40809", -- [33]
			"3310:40558", -- [34]
			"3310:16227:11899:40358:40769", -- [35]
			"3310:7824:41215", -- [36]
			"3310:7824:41214", -- [37]
			"3310:12616:34943:35140:41246", -- [38]
			"3310:43549:50084", -- [39]
			"3310:43549:50084:53783", -- [40]
			"3310:43549:50084:41861", -- [41]
			"3310:3615:2995:6726:40473", -- [42]
			"3310:3615:52060:39330:39898:41605", -- [43]
			"3310:12616:22931:43073", -- [44]
			"3310:12616:22931:43079", -- [45]
			"3310:12616:22931:43073:43085", -- [46]
			"3310:37005", -- [47]
			"3310:8610:43328", -- [48]
			"3310:43549", -- [49]
			"3310:7824:41215:48275", -- [50]
			"3310:3615:52060:39330:39898:15178:48274", -- [51]
			"3310:3615:52060:39330:39898:15178:48274:48273", -- [52]
			"3310:36728", -- [53]
			"3310:43549:50084:54393", -- [54]
			--["name"] = "Razor Hill, Durotar",
			["m"] = 1,
			["f"] = 0,
			["direct"] = "3310:41142",
			["coord"] = 2277863354,
		},
		[41142] = {
			"41140:3310:3615:2995", -- [1]
			"41140:3310", -- [2]
			"41140:3310:3615", -- [3]
			"41140:3310:3615:4312", -- [4]
			"41140:3310:3615:44399", -- [5]
			"41140:3310:3615:2995:6726", -- [6]
			"41140:3310:7824", -- [7]
			"41140:3310:3615:52060:39330:39898", -- [8]
			"41140:3310:8610", -- [9]
			"41140:3310:11139", -- [10]
			"41140:3310:16227:11899", -- [11]
			"41140:3310:12616:34429:11901", -- [12]
			"41140:3310:12616", -- [13]
			"41140:3310:43549:50084:41861:12740", -- [14]
			"41140:3310:3615:52060:39330:39898:15178", -- [15]
			"41140:3310:3615:52060", -- [16]
			"41140:3310:7824:10583", -- [17]
			"41140:3310:16227", -- [18]
			"41140:3310:12616:22931", -- [19]
			"41140:3310:16227:11899:40358", -- [20]
			"41140:3310:12616:34429", -- [21]
			"41140:3310:34927", -- [22]
			"41140:3310:12616:34943", -- [23]
			"41140:3310:12616:34429:35141", -- [24]
			"41140:3310:12616:34943:35140", -- [25]
			"41140:3310:3615:35139", -- [26]
			"41140:3310:3615:2995:35556:35562:35315", -- [27]
			"41140:3310:3615:2995:35556:35478", -- [28]
			"41140:3310:3615:2995:35556", -- [29]
			"41140:3310:3615:2995:35556:35562", -- [30]
			"41140:3310:7824:39175", -- [31]
			"41140:3310:3615:39340", -- [32]
			"41140:3310:3615:52060:39330", -- [33]
			"41140:3310:3615:2995:40809", -- [34]
			"41140:3310:40558", -- [35]
			"41140:3310:16227:11899:40358:40769", -- [36]
			"41140:3310:7824:41215", -- [37]
			"41140:3310:7824:41214", -- [38]
			"41140:3310:12616:34943:35140:41246", -- [39]
			"41140:3310:43549:50084", -- [40]
			"41140:3310:43549:50084:53783", -- [41]
			"41140:3310:43549:50084:41861", -- [42]
			"41140:3310:3615:2995:6726:40473", -- [43]
			"41140:3310:3615:52060:39330:39898:41605", -- [44]
			"41140:3310:12616:22931:43073", -- [45]
			"41140:3310:12616:22931:43079", -- [46]
			"41140:3310:12616:22931:43073:43085", -- [47]
			"41140:3310:37005", -- [48]
			"41140:3310:8610:43328", -- [49]
			"41140:3310:43549", -- [50]
			"41140:3310:7824:41215:48275", -- [51]
			"41140:3310:3615:52060:39330:39898:15178:48274", -- [52]
			"41140:3310:3615:52060:39330:39898:15178:48274:48273", -- [53]
			"41140:3310:36728", -- [54]
			"41140:3310:43549:50084:54393", -- [55]
			--["name"] = "Sen'jin Village, Durotar",
			["m"] = 1,
			["f"] = 0,
			["direct"] = "41140",
			["coord"] = 2378218495,
		},
		[48274] = {
			"15178:39898:44399:2995", -- [1]
			"15178:39898:44399:11899:16227:3310", -- [2]
			"15178:39898:39330:52060:3615", -- [3]
			"15178:41605:40473:6726:35478:4312", -- [4]
			"15178:39898:44399", -- [5]
			"15178:41605:40473:6726", -- [6]
			"15178:39175:7824", -- [7]
			"15178:39898", -- [8]
			"15178:39898:39330:52060:3615:8610", -- [9]
			"15178:39898:44399:11899:16227:3310:11139", -- [10]
			"15178:39898:44399:11899", -- [11]
			"15178:41605:40473:6726:35478:4312:11901", -- [12]
			"15178:39898:39330:52060:3615:34927:12616", -- [13]
			"15178:39898:39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [14]
			"15178:39898:39330:52060", -- [15]
			"15178:39175:10583", -- [16]
			"15178:39898:44399:11899:16227", -- [17]
			"15178:39898:39330:52060:3615:34927:12616:22931", -- [18]
			"15178:39898:44399:40358", -- [19]
			"15178:39898:39330:52060:3615:34927:34429", -- [20]
			"15178:39898:39330:52060:3615:34927", -- [21]
			"15178:39898:39330:52060:3615:34927:34943", -- [22]
			"15178:41605:40473:6726:35478:4312:35141", -- [23]
			"15178:41605:40473:6726:35478:4312:35140", -- [24]
			"15178:41605:40473:6726:35139", -- [25]
			"15178:41605:40473:6726:35315", -- [26]
			"15178:41605:40473:6726:35478", -- [27]
			"15178:41605:40473:6726:35478:35556", -- [28]
			"15178:41605:40473:6726:35315:35562", -- [29]
			"15178:39175", -- [30]
			"15178:39898:39330:39340", -- [31]
			"15178:39898:39330", -- [32]
			"15178:39898:44399:2995:40809", -- [33]
			"15178:39898:39330:52060:3615:40558", -- [34]
			"15178:39175:7824:40769", -- [35]
			"48275:41215", -- [36]
			"15178:39898:44399:11899:16227:3310:41140:41142", -- [37]
			"15178:39898:44399:11899:16227:3310:41140", -- [38]
			"48275:41215:41214", -- [39]
			"15178:41605:40473:6726:35478:4312:41246", -- [40]
			"15178:39898:44399:11899:16227:3310:43549:50084", -- [41]
			"15178:39898:44399:11899:16227:3310:43549:50084:53783", -- [42]
			"15178:39898:44399:11899:16227:3310:43549:50084:41861", -- [43]
			"15178:41605:40473", -- [44]
			"15178:41605", -- [45]
			"15178:39898:39330:52060:3615:34927:12616:22931:43073", -- [46]
			"15178:39898:39330:52060:3615:34927:12616:22931:43079", -- [47]
			"15178:39898:39330:52060:3615:34927:12616:22931:43073:43085", -- [48]
			"15178:39898:44399:11899:16227:3310:37005", -- [49]
			"15178:39898:39330:52060:3615:8610:43328", -- [50]
			"15178:39898:44399:11899:16227:3310:43549", -- [51]
			"15178:39898:39330:52060:3615:34927:12616:36728", -- [52]
			"15178:39898:44399:11899:16227:3310:43549:50084:54393", -- [53]
			--["name"] = "Oasis of Vir'sar, Uldum",
			["m"] = 249,
			["coord"] = 1144395128,
			["direct"] = "15178:48275:48273",
			["f"] = 0,
		},
		[11899] = {
			"52060:3615:4312", -- [1]
			"52060:2995:6726", -- [2]
			"39330:39898", -- [3]
			"16227:3310:8610", -- [4]
			"16227:3310:11139", -- [5]
			"52060:3615:34927:34429:11901", -- [6]
			"52060:3615:34927:12616", -- [7]
			"52060:3615:34927:12616:22931:43073:43085:12740", -- [8]
			"39330:39898:15178", -- [9]
			"40358:40769:7824:10583", -- [10]
			"52060:3615:34927:12616:22931", -- [11]
			"52060:3615:34927:34429", -- [12]
			"52060:3615:34927", -- [13]
			"52060:3615:34927:34943", -- [14]
			"52060:3615:4312:35141", -- [15]
			"52060:2995:35139:35140", -- [16]
			"52060:2995:35139", -- [17]
			"52060:2995:35556:35562:35315", -- [18]
			"52060:2995:35556:35478", -- [19]
			"52060:2995:35556", -- [20]
			"52060:2995:35556:35562", -- [21]
			"40358:40769:7824:39175", -- [22]
			"52060:39340", -- [23]
			"52060:2995:40809", -- [24]
			"52060:3615:40558", -- [25]
			"40358:40769", -- [26]
			"40358:40769:7824:41215", -- [27]
			"16227:3310:41140:41142", -- [28]
			"16227:3310:41140", -- [29]
			"40358:40769:7824:41214", -- [30]
			"52060:3615:4312:41246", -- [31]
			"16227:3310:43549:50084", -- [32]
			"16227:3310:43549:50084:53783", -- [33]
			"16227:3310:43549:50084:41861", -- [34]
			"39330:39898:41605:40473", -- [35]
			"39330:39898:41605", -- [36]
			"52060:3615:34927:12616:22931:43073", -- [37]
			"52060:3615:34927:12616:22931:43079", -- [38]
			"52060:3615:34927:12616:22931:43073:43085", -- [39]
			"16227:3310:37005", -- [40]
			"16227:3310:8610:43328", -- [41]
			"16227:3310:43549", -- [42]
			"40358:40769:7824:41215:48275", -- [43]
			"39330:39898:15178:48274", -- [44]
			"40358:40769:7824:41215:48275:48273", -- [45]
			"16227:3310:36728", -- [46]
			"16227:3310:43549:50084:54393", -- [47]
			--["name"] = "Brackenwall Village, Dustwallow Marsh",
			["m"] = 70,
			["f"] = 0,
			["direct"] = "2995:3310:3615:44399:7824:52060:16227:40358:39330",
			["coord"] = 1527533948,
		},
		[35478] = {
			"35556:2995", -- [1]
			"35556:2995:3310", -- [2]
			"35556:2995:3615", -- [3]
			"35556:2995:44399", -- [4]
			"35556:2995:7824", -- [5]
			"6726:39898", -- [6]
			"35556:2995:8610", -- [7]
			"35556:2995:8610:11139", -- [8]
			"35556:2995:52060:11899", -- [9]
			"4312:11901", -- [10]
			"4312:35140:34943:12616", -- [11]
			"4312:34429:22931:43073:43085:12740", -- [12]
			"6726:40473:41605:15178", -- [13]
			"35556:2995:52060", -- [14]
			"6726:40473:41605:15178:39175:10583", -- [15]
			"35556:2995:3615:16227", -- [16]
			"4312:34429:22931", -- [17]
			"35556:2995:52060:39330:40358", -- [18]
			"4312:34429", -- [19]
			"35556:2995:3615:34927", -- [20]
			"4312:35140:34943", -- [21]
			"4312:35141", -- [22]
			"4312:35140", -- [23]
			"35556:2995:35139", -- [24]
			"6726:40473:41605:15178:39175", -- [25]
			"35556:2995:39340", -- [26]
			"35556:2995:52060:39330", -- [27]
			"35556:2995:40809", -- [28]
			"35556:2995:3615:40558", -- [29]
			"35556:2995:52060:39330:40358:40769", -- [30]
			"35556:2995:7824:41215", -- [31]
			"35556:2995:3310:41140:41142", -- [32]
			"35556:2995:3310:41140", -- [33]
			"35556:2995:7824:41214", -- [34]
			"4312:41246", -- [35]
			"35556:2995:3310:43549:50084", -- [36]
			"35556:2995:3310:43549:50084:53783", -- [37]
			"35556:2995:3310:43549:50084:41861", -- [38]
			"6726:40473", -- [39]
			"6726:40473:41605", -- [40]
			"4312:34429:22931:43073", -- [41]
			"4312:34429:22931:43079", -- [42]
			"4312:34429:22931:43073:43085", -- [43]
			"35556:2995:3310:37005", -- [44]
			"35556:2995:8610:43328", -- [45]
			"35556:2995:3310:43549", -- [46]
			"6726:40473:41605:15178:48274:48275", -- [47]
			"6726:40473:41605:15178:48274", -- [48]
			"6726:40473:41605:15178:48274:48273", -- [49]
			"4312:35140:34943:12616:36728", -- [50]
			"35556:2995:3310:43549:50084:54393", -- [51]
			--["name"] = "Karnum's Glade, Desolace",
			["m"] = 66,
			["coord"] = 2479390534,
			["direct"] = "4312:6726:35315:35556:35562",
			["f"] = 0,
		},
		[4312] = {
			"3615:3310", -- [1]
			"35139:2995:44399", -- [2]
			"35139:2995:7824", -- [3]
			"35139:2995:52060:39330:39898", -- [4]
			"35140:34943:12616:36728:8610", -- [5]
			"34429:22931:43073:43085:11139", -- [6]
			"35139:2995:52060:11899", -- [7]
			"35140:34943:12616", -- [8]
			"34429:22931:43073:43085:12740", -- [9]
			"6726:40473:41605:15178", -- [10]
			"35139:2995:52060", -- [11]
			"6726:40473:41605:15178:39175:10583", -- [12]
			"3615:16227", -- [13]
			"34429:22931", -- [14]
			"35139:2995:52060:39330:40358", -- [15]
			"35140:34927", -- [16]
			"35140:34943", -- [17]
			"35478:35556", -- [18]
			"35315:35562", -- [19]
			"6726:40473:41605:15178:39175", -- [20]
			"35139:2995:39340", -- [21]
			"35139:2995:52060:39330", -- [22]
			"35139:2995:40809", -- [23]
			"3615:40558", -- [24]
			"35139:2995:52060:39330:40358:40769", -- [25]
			"35139:2995:7824:41215", -- [26]
			"3615:3310:41140:41142", -- [27]
			"3615:3310:41140", -- [28]
			"35139:2995:7824:41214", -- [29]
			"35140:34943:12616:36728:43549:50084", -- [30]
			"35140:34943:12616:36728:43549:50084:53783", -- [31]
			"35140:34943:12616:36728:43549:50084:41861", -- [32]
			"6726:40473", -- [33]
			"6726:40473:41605", -- [34]
			"34429:22931:43073", -- [35]
			"34429:22931:43079", -- [36]
			"34429:22931:43073:43085", -- [37]
			"35140:34943:12616:36728:8610:37005", -- [38]
			"35140:34943:12616:36728:8610:43328", -- [39]
			"35140:34943:12616:36728:43549", -- [40]
			"6726:40473:41605:15178:48274:48275", -- [41]
			"6726:40473:41605:15178:48274", -- [42]
			"6726:40473:41605:15178:48274:48273", -- [43]
			"35140:34943:12616:36728", -- [44]
			"35140:34943:12616:36728:43549:50084:54393", -- [45]
			--["name"] = "Sun Rock Retreat, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "2995:3615:6726:11901:34429:35141:35140:35139:35315:35478:41246",
			["coord"] = 2083298982,
		},
		[41215] = {
			"7824:2995", -- [1]
			"7824:16227:3310", -- [2]
			"7824:3615", -- [3]
			"7824:2995:35139:4312", -- [4]
			"7824:44399", -- [5]
			"48275:48274:15178:41605:40473:6726", -- [6]
			"7824:39898", -- [7]
			"7824:16227:3310:8610", -- [8]
			"7824:16227:3310:11139", -- [9]
			"7824:40769:40358:11899", -- [10]
			"7824:3615:34927:34429:11901", -- [11]
			"7824:3615:34927:12616", -- [12]
			"7824:16227:3310:43549:50084:41861:12740", -- [13]
			"48275:48274:15178", -- [14]
			"7824:40769:40358:11899:52060", -- [15]
			"7824:10583", -- [16]
			"7824:16227", -- [17]
			"7824:3615:34927:12616:22931", -- [18]
			"7824:40769:40358", -- [19]
			"7824:3615:34927:34429", -- [20]
			"7824:3615:34927", -- [21]
			"7824:3615:34927:34943", -- [22]
			"7824:2995:35139:35141", -- [23]
			"7824:2995:35139:35140", -- [24]
			"7824:2995:35139", -- [25]
			"48275:48274:15178:41605:40473:6726:35315", -- [26]
			"7824:2995:35556:35478", -- [27]
			"7824:2995:35556", -- [28]
			"7824:2995:35556:35562", -- [29]
			"7824:39175", -- [30]
			"7824:40769:40358:11899:52060:39340", -- [31]
			"7824:40769:40358:39330", -- [32]
			"7824:2995:40809", -- [33]
			"7824:3615:40558", -- [34]
			"7824:40769", -- [35]
			"7824:16227:3310:41140:41142", -- [36]
			"7824:16227:3310:41140", -- [37]
			"7824:2995:35139:4312:41246", -- [38]
			"7824:16227:3310:43549:50084", -- [39]
			"7824:16227:3310:43549:50084:53783", -- [40]
			"7824:16227:3310:43549:50084:41861", -- [41]
			"48275:48274:15178:41605:40473", -- [42]
			"48275:48274:15178:41605", -- [43]
			"7824:3615:34927:12616:22931:43073", -- [44]
			"7824:3615:34927:12616:22931:43079", -- [45]
			"7824:3615:34927:12616:22931:43073:43085", -- [46]
			"7824:16227:3310:37005", -- [47]
			"7824:16227:3310:8610:43328", -- [48]
			"7824:16227:3310:43549", -- [49]
			"48275:48274", -- [50]
			"48275:48273", -- [51]
			"7824:16227:3310:36728", -- [52]
			"7824:16227:3310:43549:50084:54393", -- [53]
			--["name"] = "Dawnrise Expedition, Tanaris",
			["m"] = 71,
			["coord"] = 1431946726,
			["direct"] = "7824:41214:48275",
			["f"] = 0,
		},
		[48273] = {
			"48274:15178:39898:44399:2995", -- [1]
			"48275:41215:7824:16227:3310", -- [2]
			"48274:15178:39898:39330:52060:3615", -- [3]
			"48274:15178:41605:40473:6726:35478:4312", -- [4]
			"48274:15178:39898:44399", -- [5]
			"48274:15178:41605:40473:6726", -- [6]
			"48275:41215:7824", -- [7]
			"48274:15178:39898", -- [8]
			"48275:41215:7824:16227:3310:8610", -- [9]
			"48275:41215:7824:16227:3310:11139", -- [10]
			"48274:15178:39898:44399:11899", -- [11]
			"48274:15178:41605:40473:6726:35478:4312:11901", -- [12]
			"48274:15178:39898:39330:52060:3615:34927:12616", -- [13]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [14]
			"48274:15178", -- [15]
			"48274:15178:39898:39330:52060", -- [16]
			"48274:15178:39175:10583", -- [17]
			"48275:41215:7824:16227", -- [18]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931", -- [19]
			"48275:41215:7824:40769:40358", -- [20]
			"48274:15178:39898:39330:52060:3615:34927:34429", -- [21]
			"48274:15178:39898:39330:52060:3615:34927", -- [22]
			"48274:15178:39898:39330:52060:3615:34927:34943", -- [23]
			"48274:15178:41605:40473:6726:35478:4312:35141", -- [24]
			"48274:15178:41605:40473:6726:35478:4312:35140", -- [25]
			"48274:15178:41605:40473:6726:35139", -- [26]
			"48274:15178:41605:40473:6726:35315", -- [27]
			"48274:15178:41605:40473:6726:35478", -- [28]
			"48274:15178:41605:40473:6726:35478:35556", -- [29]
			"48274:15178:41605:40473:6726:35315:35562", -- [30]
			"48274:15178:39175", -- [31]
			"48274:15178:39898:39330:39340", -- [32]
			"48274:15178:39898:39330", -- [33]
			"48274:15178:39898:44399:2995:40809", -- [34]
			"48274:15178:39898:39330:52060:3615:40558", -- [35]
			"48275:41215:7824:40769", -- [36]
			"48275:41215", -- [37]
			"48275:41215:7824:16227:3310:41140:41142", -- [38]
			"48275:41215:7824:16227:3310:41140", -- [39]
			"48275:41215:41214", -- [40]
			"48274:15178:41605:40473:6726:35478:4312:41246", -- [41]
			"48275:41215:7824:16227:3310:43549:50084", -- [42]
			"48275:41215:7824:16227:3310:43549:50084:53783", -- [43]
			"48275:41215:7824:16227:3310:43549:50084:41861", -- [44]
			"48274:15178:41605:40473", -- [45]
			"48274:15178:41605", -- [46]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931:43073", -- [47]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931:43079", -- [48]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931:43073:43085", -- [49]
			"48275:41215:7824:16227:3310:37005", -- [50]
			"48275:41215:7824:16227:3310:8610:43328", -- [51]
			"48275:41215:7824:16227:3310:43549", -- [52]
			"48275:41215:7824:16227:3310:36728", -- [53]
			"48275:41215:7824:16227:3310:43549:50084:54393", -- [54]
			--["name"] = "Schnottz's Landing, Uldum",
			["m"] = 249,
			["coord"] = 958375507,
			["direct"] = "48275:48274",
			["f"] = 0,
		},
		[48275] = {
			"41215:7824:2995", -- [1]
			"41215:7824:16227:3310", -- [2]
			"41215:7824:3615", -- [3]
			"48274:15178:41605:40473:6726:35478:4312", -- [4]
			"48274:15178:39898:44399", -- [5]
			"48274:15178:41605:40473:6726", -- [6]
			"41215:7824", -- [7]
			"48274:15178:39898", -- [8]
			"41215:7824:16227:3310:8610", -- [9]
			"41215:7824:16227:3310:11139", -- [10]
			"41215:7824:40769:40358:11899", -- [11]
			"48274:15178:41605:40473:6726:35478:4312:11901", -- [12]
			"41215:7824:3615:34927:12616", -- [13]
			"41215:7824:16227:3310:43549:50084:41861:12740", -- [14]
			"48274:15178", -- [15]
			"41215:7824:40769:40358:11899:52060", -- [16]
			"48274:15178:39175:10583", -- [17]
			"41215:7824:16227", -- [18]
			"41215:7824:3615:34927:12616:22931", -- [19]
			"41215:7824:40769:40358", -- [20]
			"41215:7824:3615:34927:34429", -- [21]
			"41215:7824:3615:34927", -- [22]
			"41215:7824:3615:34927:34943", -- [23]
			"48274:15178:41605:40473:6726:35478:4312:35141", -- [24]
			"48274:15178:41605:40473:6726:35478:4312:35140", -- [25]
			"41215:7824:2995:35139", -- [26]
			"48274:15178:41605:40473:6726:35315", -- [27]
			"48274:15178:41605:40473:6726:35478", -- [28]
			"48274:15178:41605:40473:6726:35478:35556", -- [29]
			"48274:15178:41605:40473:6726:35315:35562", -- [30]
			"48274:15178:39175", -- [31]
			"41215:7824:40769:40358:11899:52060:39340", -- [32]
			"48274:15178:39898:39330", -- [33]
			"41215:7824:2995:40809", -- [34]
			"41215:7824:3615:40558", -- [35]
			"41215:7824:40769", -- [36]
			"41215:7824:16227:3310:41140:41142", -- [37]
			"41215:7824:16227:3310:41140", -- [38]
			"41215:41214", -- [39]
			"48274:15178:41605:40473:6726:35478:4312:41246", -- [40]
			"41215:7824:16227:3310:43549:50084", -- [41]
			"41215:7824:16227:3310:43549:50084:53783", -- [42]
			"41215:7824:16227:3310:43549:50084:41861", -- [43]
			"48274:15178:41605:40473", -- [44]
			"48274:15178:41605", -- [45]
			"41215:7824:3615:34927:12616:22931:43073", -- [46]
			"41215:7824:3615:34927:12616:22931:43079", -- [47]
			"41215:7824:3615:34927:12616:22931:43073:43085", -- [48]
			"41215:7824:16227:3310:37005", -- [49]
			"41215:7824:16227:3310:8610:43328", -- [50]
			"41215:7824:16227:3310:43549", -- [51]
			"41215:7824:16227:3310:36728", -- [52]
			"41215:7824:16227:3310:43549:50084:54393", -- [53]
			--["name"] = "Ramkahen, Uldum",
			["m"] = 249,
			["coord"] = 2416399851,
			["direct"] = "41215:48274:48273",
			["f"] = 0,
		},
		[39898] = {
			"44399:11899:16227:3310", -- [1]
			"41605:40473:6726:35478:4312", -- [2]
			"39330:52060:3615:8610", -- [3]
			"44399:11899:16227:3310:11139", -- [4]
			"44399:11899", -- [5]
			"39330:52060:3615:34927:34429:11901", -- [6]
			"39330:52060:3615:34927:12616", -- [7]
			"39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [8]
			"39330:52060", -- [9]
			"15178:39175:10583", -- [10]
			"44399:11899:16227", -- [11]
			"39330:52060:3615:34927:12616:22931", -- [12]
			"44399:40358", -- [13]
			"39330:52060:3615:34927:34429", -- [14]
			"39330:52060:3615:34927", -- [15]
			"39330:52060:3615:34927:34943", -- [16]
			"41605:40473:6726:35478:4312:35141", -- [17]
			"44399:2995:35139:35140", -- [18]
			"44399:2995:35139", -- [19]
			"41605:40473:6726:35478", -- [20]
			"41605:40473:6726:35478:35556", -- [21]
			"35315:35562", -- [22]
			"15178:39175", -- [23]
			"39330:39340", -- [24]
			"44399:2995:40809", -- [25]
			"39330:52060:3615:40558", -- [26]
			"44399:40769", -- [27]
			"44399:40769:7824:41215", -- [28]
			"44399:11899:16227:3310:41140:41142", -- [29]
			"44399:11899:16227:3310:41140", -- [30]
			"44399:40769:7824:41214", -- [31]
			"41605:40473:6726:35478:4312:41246", -- [32]
			"44399:11899:16227:3310:43549:50084", -- [33]
			"44399:11899:16227:3310:43549:50084:53783", -- [34]
			"44399:11899:16227:3310:43549:50084:41861", -- [35]
			"41605:40473", -- [36]
			"39330:52060:3615:34927:12616:22931:43073", -- [37]
			"39330:52060:3615:34927:12616:22931:43079", -- [38]
			"39330:52060:3615:34927:12616:22931:43073:43085", -- [39]
			"44399:11899:16227:3310:37005", -- [40]
			"39330:52060:3615:8610:43328", -- [41]
			"44399:11899:16227:3310:43549", -- [42]
			"15178:48274:48275", -- [43]
			"15178:48274", -- [44]
			"15178:48274:48273", -- [45]
			"39330:52060:3615:34927:12616:36728", -- [46]
			"44399:11899:16227:3310:43549:50084:54393", -- [47]
			--["name"] = "Camp Mojache, Feralas",
			["m"] = 69,
			["coord"] = 3239670129,
			["direct"] = "2995:3615:44399:6726:7824:15178:35315:39330:41605",
			["f"] = 0,
		},
		[11139] = {
			"8610:2995", -- [1]
			"8610:3310:3615", -- [2]
			"43085:43073:22931:34429:4312", -- [3]
			"8610:3310:3615:44399", -- [4]
			"43085:43073:22931:34429:4312:6726", -- [5]
			"8610:3310:7824", -- [6]
			"8610:3310:3615:52060:39330:39898", -- [7]
			"8610:3310:16227:11899", -- [8]
			"43085:43073:22931:34429:11901", -- [9]
			"8610:12616", -- [10]
			"8610:3310:3615:52060:39330:39898:15178", -- [11]
			"8610:3310:3615:52060", -- [12]
			"8610:3310:7824:10583", -- [13]
			"8610:3310:16227", -- [14]
			"43085:43073:22931", -- [15]
			"8610:3310:16227:11899:40358", -- [16]
			"43085:43073:22931:34429", -- [17]
			"8610:12616:34927", -- [18]
			"8610:12616:34943", -- [19]
			"43085:43073:22931:34429:35141", -- [20]
			"8610:12616:34943:35140", -- [21]
			"8610:3310:3615:35139", -- [22]
			"43085:43073:22931:34429:4312:35315", -- [23]
			"43085:43073:22931:34429:4312:35478", -- [24]
			"8610:2995:35556", -- [25]
			"43085:43073:22931:34429:4312:35315:35562", -- [26]
			"8610:3310:7824:39175", -- [27]
			"8610:3310:3615:39340", -- [28]
			"8610:3310:3615:52060:39330", -- [29]
			"8610:2995:40809", -- [30]
			"8610:3310:40558", -- [31]
			"8610:3310:16227:11899:40358:40769", -- [32]
			"8610:3310:7824:41215", -- [33]
			"8610:3310:41140:41142", -- [34]
			"8610:3310:41140", -- [35]
			"8610:3310:7824:41214", -- [36]
			"43085:43073:22931:34429:35141:41246", -- [37]
			"41861:50084", -- [38]
			"41861:53783", -- [39]
			"43085:43073:22931:34429:4312:6726:40473", -- [40]
			"8610:3310:3615:52060:39330:39898:41605", -- [41]
			"43085:43073", -- [42]
			"43085:43073:43079", -- [43]
			"8610:37005", -- [44]
			"8610:43328", -- [45]
			"41861:50084:43549", -- [46]
			"8610:3310:7824:41215:48275", -- [47]
			"8610:3310:3615:52060:39330:39898:15178:48274", -- [48]
			"8610:3310:3615:52060:39330:39898:15178:48274:48273", -- [49]
			"8610:36728", -- [50]
			"41861:50084:54393", -- [51]
			--["name"] = "Everlook, Winterspring",
			["m"] = 83,
			["f"] = 0,
			["direct"] = "3310:8610:12740:41861:43085",
			["coord"] = 2527689643,
		},
		[11901] = {
			"12616:3310", -- [1]
			"35141:35139:2995:44399", -- [2]
			"4312:6726", -- [3]
			"35141:35139:2995:7824", -- [4]
			"35141:35139:2995:52060:39330:39898", -- [5]
			"12616:36728:8610", -- [6]
			"22931:43073:43085:11139", -- [7]
			"35141:35139:2995:52060:11899", -- [8]
			"22931:43073:43085:12740", -- [9]
			"4312:6726:40473:41605:15178", -- [10]
			"35141:35139:2995:52060", -- [11]
			"35141:35139:2995:7824:10583", -- [12]
			"3615:16227", -- [13]
			"35141:35139:2995:52060:39330:40358", -- [14]
			"34429:34943:34927", -- [15]
			"34429:34943", -- [16]
			"35141:35140", -- [17]
			"35141:35139", -- [18]
			"4312:35315", -- [19]
			"4312:35478", -- [20]
			"4312:35478:35556", -- [21]
			"4312:35315:35562", -- [22]
			"4312:6726:40473:41605:15178:39175", -- [23]
			"35141:35139:2995:39340", -- [24]
			"35141:35139:2995:52060:39330", -- [25]
			"35141:35139:2995:40809", -- [26]
			"34429:34943:34927:40558", -- [27]
			"35141:35139:2995:52060:39330:40358:40769", -- [28]
			"35141:35139:2995:7824:41215", -- [29]
			"12616:3310:41140:41142", -- [30]
			"12616:3310:41140", -- [31]
			"35141:35139:2995:7824:41214", -- [32]
			"35141:41246", -- [33]
			"12616:36728:43549:50084", -- [34]
			"12616:36728:43549:50084:53783", -- [35]
			"12616:36728:43549:50084:41861", -- [36]
			"4312:6726:40473", -- [37]
			"4312:6726:40473:41605", -- [38]
			"22931:43073", -- [39]
			"22931:43079", -- [40]
			"22931:43073:43085", -- [41]
			"12616:36728:8610:37005", -- [42]
			"12616:36728:8610:43328", -- [43]
			"12616:36728:43549", -- [44]
			"4312:6726:40473:41605:15178:48274:48275", -- [45]
			"4312:6726:40473:41605:15178:48274", -- [46]
			"4312:6726:40473:41605:15178:48274:48273", -- [47]
			"12616:36728", -- [48]
			"12616:36728:43549:50084:54393", -- [49]
			--["name"] = "Zoram'gar Outpost, Ashenvale",
			["m"] = 63,
			["f"] = 0,
			["direct"] = "2995:3615:4312:12616:22931:34429:35141",
			["coord"] = 482367485,
		},
		[41605] = {
			"40473:6726:35478:35556:2995", -- [1]
			"39898:44399:11899:16227:3310", -- [2]
			"39898:39330:52060:3615", -- [3]
			"40473:6726:35478:4312", -- [4]
			"39898:44399", -- [5]
			"40473:6726", -- [6]
			"39898:44399:40769:7824", -- [7]
			"39898:39330:52060:3615:8610", -- [8]
			"39898:44399:11899:16227:3310:11139", -- [9]
			"39898:44399:11899", -- [10]
			"40473:6726:35478:4312:11901", -- [11]
			"39898:39330:52060:3615:34927:12616", -- [12]
			"39898:39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [13]
			"39898:39330:52060", -- [14]
			"15178:39175:10583", -- [15]
			"39898:44399:11899:16227", -- [16]
			"39898:39330:52060:3615:34927:12616:22931", -- [17]
			"39898:44399:40358", -- [18]
			"40473:6726:35478:4312:34429", -- [19]
			"39898:39330:52060:3615:34927", -- [20]
			"40473:6726:35478:4312:35140:34943", -- [21]
			"40473:6726:35478:4312:35141", -- [22]
			"40473:6726:35478:4312:35140", -- [23]
			"40473:6726:35139", -- [24]
			"40473:6726:35315", -- [25]
			"40473:6726:35478", -- [26]
			"40473:6726:35478:35556", -- [27]
			"40473:6726:35315:35562", -- [28]
			"15178:39175", -- [29]
			"39898:39330:39340", -- [30]
			"39898:39330", -- [31]
			"40473:6726:35478:35556:2995:40809", -- [32]
			"39898:39330:52060:3615:40558", -- [33]
			"39898:44399:40769", -- [34]
			"15178:48274:48275:41215", -- [35]
			"39898:44399:11899:16227:3310:41140:41142", -- [36]
			"39898:44399:11899:16227:3310:41140", -- [37]
			"39898:44399:40769:7824:41214", -- [38]
			"40473:6726:35478:4312:41246", -- [39]
			"39898:44399:11899:16227:3310:43549:50084", -- [40]
			"39898:44399:11899:16227:3310:43549:50084:53783", -- [41]
			"39898:44399:11899:16227:3310:43549:50084:41861", -- [42]
			"39898:39330:52060:3615:34927:12616:22931:43073", -- [43]
			"39898:39330:52060:3615:34927:12616:22931:43079", -- [44]
			"39898:39330:52060:3615:34927:12616:22931:43073:43085", -- [45]
			"39898:44399:11899:16227:3310:37005", -- [46]
			"39898:39330:52060:3615:8610:43328", -- [47]
			"39898:44399:11899:16227:3310:43549", -- [48]
			"15178:48274:48275", -- [49]
			"15178:48274", -- [50]
			"15178:48274:48273", -- [51]
			"39898:39330:52060:3615:34927:12616:36728", -- [52]
			"39898:44399:11899:16227:3310:43549:50084:54393", -- [53]
			--["name"] = "Stonemaul Hold, Feralas",
			["m"] = 69,
			["coord"] = 2189786049,
			["direct"] = "39898:15178:40473",
			["f"] = 0,
		},
		[15178] = {
			"39898:44399:2995", -- [1]
			"39898:44399:11899:16227:3310", -- [2]
			"39898:39330:52060:3615", -- [3]
			"41605:40473:6726:35478:4312", -- [4]
			"39898:44399", -- [5]
			"41605:40473:6726", -- [6]
			"39898:39330:52060:3615:8610", -- [7]
			"39898:44399:11899:16227:3310:11139", -- [8]
			"39898:44399:11899", -- [9]
			"41605:40473:6726:35478:4312:11901", -- [10]
			"39898:39330:52060:3615:34927:12616", -- [11]
			"39898:39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [12]
			"39898:39330:52060", -- [13]
			"39898:44399:11899:16227", -- [14]
			"39898:39330:52060:3615:34927:12616:22931", -- [15]
			"39898:44399:40358", -- [16]
			"39898:39330:52060:3615:34927:34429", -- [17]
			"39898:39330:52060:3615:34927", -- [18]
			"39898:39330:52060:3615:34927:34943", -- [19]
			"41605:40473:6726:35478:4312:35141", -- [20]
			"41605:40473:6726:35478:4312:35140", -- [21]
			"41605:40473:6726:35139", -- [22]
			"41605:40473:6726:35315", -- [23]
			"41605:40473:6726:35478", -- [24]
			"41605:40473:6726:35478:35556", -- [25]
			"41605:40473:6726:35315:35562", -- [26]
			"39898:39330:39340", -- [27]
			"39898:39330", -- [28]
			"39898:44399:2995:40809", -- [29]
			"39898:39330:52060:3615:40558", -- [30]
			"39175:7824:40769", -- [31]
			"48274:48275:41215", -- [32]
			"39898:44399:11899:16227:3310:41140:41142", -- [33]
			"39898:44399:11899:16227:3310:41140", -- [34]
			"39175:7824:41214", -- [35]
			"41605:40473:6726:35478:4312:41246", -- [36]
			"39898:44399:11899:16227:3310:43549:50084", -- [37]
			"39898:44399:11899:16227:3310:43549:50084:53783", -- [38]
			"39898:44399:11899:16227:3310:43549:50084:41861", -- [39]
			"41605:40473", -- [40]
			"39898:39330:52060:3615:34927:12616:22931:43073", -- [41]
			"39898:39330:52060:3615:34927:12616:22931:43079", -- [42]
			"39898:39330:52060:3615:34927:12616:22931:43073:43085", -- [43]
			"39898:44399:11899:16227:3310:37005", -- [44]
			"39898:39330:52060:3615:8610:43328", -- [45]
			"39898:44399:11899:16227:3310:43549", -- [46]
			"48274:48275", -- [47]
			"48274:48273", -- [48]
			"39898:39330:52060:3615:34927:12616:36728", -- [49]
			"39898:44399:11899:16227:3310:43549:50084:54393", -- [50]
			--["name"] = "Cenarion Hold, Silithus",
			["m"] = 81,
			["coord"] = 2269468846,
			["direct"] = "7824:39898:10583:39175:41605:48274",
			["f"] = 0,
		},
		[41861] = {
			"50084:43549:3310:3615:2995", -- [1]
			"50084:43549:3310", -- [2]
			"50084:43549:3310:3615", -- [3]
			"50084:43549:36728:12616:34943:35140:4312", -- [4]
			"50084:43549:3310:3615:44399", -- [5]
			"50084:43549:36728:12616:34943:35140:4312:6726", -- [6]
			"50084:43549:3310:7824", -- [7]
			"50084:43549:3310:3615:52060:39330:39898", -- [8]
			"50084:43549:36728:8610", -- [9]
			"50084:43549:3310:16227:11899", -- [10]
			"50084:43549:36728:12616:34429:11901", -- [11]
			"50084:43549:36728:12616", -- [12]
			"50084:43549:3310:3615:52060:39330:39898:15178", -- [13]
			"50084:43549:3310:3615:52060", -- [14]
			"50084:43549:3310:7824:10583", -- [15]
			"50084:43549:3310:16227", -- [16]
			"50084:43549:36728:12616:22931", -- [17]
			"50084:43549:3310:16227:11899:40358", -- [18]
			"50084:43549:36728:12616:34429", -- [19]
			"50084:43549:36728:12616:34927", -- [20]
			"50084:43549:36728:12616:34943", -- [21]
			"50084:43549:36728:12616:34429:35141", -- [22]
			"50084:43549:36728:12616:34943:35140", -- [23]
			"50084:43549:36728:12616:34943:35140:35139", -- [24]
			"50084:43549:36728:12616:34943:35140:4312:35315", -- [25]
			"50084:43549:36728:12616:34943:35140:4312:35478", -- [26]
			"50084:43549:3310:3615:2995:35556", -- [27]
			"50084:43549:36728:12616:34943:35140:4312:35315:35562", -- [28]
			"50084:43549:3310:7824:39175", -- [29]
			"50084:43549:3310:3615:39340", -- [30]
			"50084:43549:3310:3615:52060:39330", -- [31]
			"50084:43549:3310:3615:2995:40809", -- [32]
			"50084:43549:3310:40558", -- [33]
			"50084:43549:3310:16227:11899:40358:40769", -- [34]
			"50084:43549:3310:7824:41215", -- [35]
			"50084:43549:3310:41140:41142", -- [36]
			"50084:43549:3310:41140", -- [37]
			"50084:43549:3310:7824:41214", -- [38]
			"50084:43549:36728:12616:34943:35140:41246", -- [39]
			"50084:43549:36728:12616:34943:35140:4312:6726:40473", -- [40]
			"50084:43549:3310:3615:52060:39330:39898:41605", -- [41]
			"12740:43085:43073", -- [42]
			"12740:43085:43073:43079", -- [43]
			"12740:43085", -- [44]
			"50084:43549:36728:8610:37005", -- [45]
			"50084:43549:36728:8610:43328", -- [46]
			"50084:43549", -- [47]
			"50084:43549:3310:7824:41215:48275", -- [48]
			"50084:43549:3310:3615:52060:39330:39898:15178:48274", -- [49]
			"50084:43549:3310:3615:52060:39330:39898:15178:48274:48273", -- [50]
			"50084:43549:36728", -- [51]
			"50084:54393", -- [52]
			--["name"] = "Nordrassil, Hyjal",
			["m"] = 198,
			["f"] = 0,
			["direct"] = "11139:12740:50084:53783",
			["coord"] = 2671195983,
		},
		[34429] = {
			"4312:35139:2995", -- [1]
			"12616:3310", -- [2]
			"34943:34927:3615", -- [3]
			"34943:34927:3615:44399", -- [4]
			"4312:6726", -- [5]
			"34943:34927:3615:52060:39330:40358:40769:7824", -- [6]
			"34943:34927:3615:52060:39330:39898", -- [7]
			"12616:36728:8610", -- [8]
			"22931:43073:43085:11139", -- [9]
			"34943:34927:3615:52060:11899", -- [10]
			"22931:43073:43085:12740", -- [11]
			"4312:6726:40473:41605:15178", -- [12]
			"34943:34927:3615:52060", -- [13]
			"34943:34927:3615:52060:39330:40358:40769:7824:10583", -- [14]
			"34943:34927:3615:16227", -- [15]
			"34943:34927:3615:52060:39330:40358", -- [16]
			"34943:35140", -- [17]
			"4312:35139", -- [18]
			"4312:35315", -- [19]
			"4312:35478", -- [20]
			"4312:35478:35556", -- [21]
			"4312:35315:35562", -- [22]
			"34943:34927:3615:52060:39330:40358:40769:7824:39175", -- [23]
			"34943:34927:3615:39340", -- [24]
			"34943:34927:3615:52060:39330", -- [25]
			"4312:35139:2995:40809", -- [26]
			"34943:34927:40558", -- [27]
			"34943:34927:3615:52060:39330:40358:40769", -- [28]
			"34943:34927:3615:52060:39330:40358:40769:7824:41215", -- [29]
			"12616:3310:41140:41142", -- [30]
			"12616:3310:41140", -- [31]
			"34943:34927:3615:52060:39330:40358:40769:7824:41214", -- [32]
			"35141:41246", -- [33]
			"12616:36728:43549:50084", -- [34]
			"12616:36728:43549:50084:53783", -- [35]
			"12616:36728:43549:50084:41861", -- [36]
			"4312:6726:40473", -- [37]
			"4312:6726:40473:41605", -- [38]
			"22931:43073", -- [39]
			"22931:43079", -- [40]
			"22931:43073:43085", -- [41]
			"12616:36728:8610:37005", -- [42]
			"12616:36728:8610:43328", -- [43]
			"12616:36728:43549", -- [44]
			"4312:6726:40473:41605:15178:48274:48275", -- [45]
			"4312:6726:40473:41605:15178:48274", -- [46]
			"4312:6726:40473:41605:15178:48274:48273", -- [47]
			"12616:36728", -- [48]
			"12616:36728:43549:50084:54393", -- [49]
			--["name"] = "Hellscream's Watch, Ashenvale",
			["m"] = 63,
			["f"] = 0,
			["direct"] = "4312:11901:12616:22931:34927:34943:35141",
			["coord"] = 1637772326,
		},
		[40769] = {
			"40358:11899:52060:2995", -- [1]
			"40358:11899:16227:3310", -- [2]
			"40358:11899:52060:3615", -- [3]
			"40358:11899:52060:3615:4312", -- [4]
			"44399:39898:41605:40473:6726", -- [5]
			"44399:39898", -- [6]
			"40358:11899:16227:3310:8610", -- [7]
			"40358:11899:16227:3310:11139", -- [8]
			"40358:11899", -- [9]
			"40358:11899:52060:3615:34927:34429:11901", -- [10]
			"40358:11899:52060:3615:34927:12616", -- [11]
			"40358:11899:52060:3615:34927:12616:22931:43073:43085:12740", -- [12]
			"7824:39175:15178", -- [13]
			"40358:11899:52060", -- [14]
			"7824:10583", -- [15]
			"40358:11899:16227", -- [16]
			"40358:11899:52060:3615:34927:12616:22931", -- [17]
			"40358:11899:52060:3615:34927:34429", -- [18]
			"40358:11899:52060:3615:34927", -- [19]
			"40358:11899:52060:3615:34927:34943", -- [20]
			"40358:11899:52060:3615:4312:35141", -- [21]
			"40358:11899:52060:2995:35139:35140", -- [22]
			"40358:11899:52060:2995:35139", -- [23]
			"44399:39898:35315", -- [24]
			"40358:11899:52060:2995:35556:35478", -- [25]
			"40358:11899:52060:2995:35556", -- [26]
			"40358:11899:52060:2995:35556:35562", -- [27]
			"7824:39175", -- [28]
			"40358:11899:52060:39340", -- [29]
			"40358:39330", -- [30]
			"40358:11899:52060:2995:40809", -- [31]
			"40358:11899:52060:3615:40558", -- [32]
			"7824:41215", -- [33]
			"40358:11899:16227:3310:41140:41142", -- [34]
			"40358:11899:16227:3310:41140", -- [35]
			"7824:41214", -- [36]
			"40358:11899:52060:3615:4312:41246", -- [37]
			"40358:11899:16227:3310:43549:50084", -- [38]
			"40358:11899:16227:3310:43549:50084:53783", -- [39]
			"40358:11899:16227:3310:43549:50084:41861", -- [40]
			"44399:39898:41605:40473", -- [41]
			"44399:39898:41605", -- [42]
			"40358:11899:52060:3615:34927:12616:22931:43073", -- [43]
			"40358:11899:52060:3615:34927:12616:22931:43079", -- [44]
			"40358:11899:52060:3615:34927:12616:22931:43073:43085", -- [45]
			"40358:11899:16227:3310:37005", -- [46]
			"40358:11899:16227:3310:8610:43328", -- [47]
			"40358:11899:16227:3310:43549", -- [48]
			"7824:41215:48275", -- [49]
			"7824:39175:15178:48274", -- [50]
			"7824:41215:48275:48273", -- [51]
			"40358:11899:16227:3310:36728", -- [52]
			"40358:11899:16227:3310:43549:50084:54393", -- [53]
			--["name"] = "Fizzle & Pozzik's Speedbarge, Thousand Needles",
			["m"] = 64,
			["coord"] = 3397892142,
			["direct"] = "44399:7824:40358",
			["f"] = 0,
		},
		[35315] = {
			"35562:35556:2995", -- [1]
			"35562:35556:2995:3310", -- [2]
			"35562:35556:2995:3615", -- [3]
			"39898:44399", -- [4]
			"35562:35556:2995:7824", -- [5]
			"35562:35556:2995:8610", -- [6]
			"35562:35556:2995:8610:11139", -- [7]
			"35562:35556:2995:52060:11899", -- [8]
			"4312:11901", -- [9]
			"4312:35140:34943:12616", -- [10]
			"4312:34429:22931:43073:43085:12740", -- [11]
			"6726:40473:41605:15178", -- [12]
			"35562:35556:2995:52060", -- [13]
			"6726:40473:41605:15178:39175:10583", -- [14]
			"35562:35556:2995:3615:16227", -- [15]
			"4312:34429:22931", -- [16]
			"35562:35556:2995:52060:39330:40358", -- [17]
			"4312:34429", -- [18]
			"35562:35556:2995:3615:34927", -- [19]
			"4312:35140:34943", -- [20]
			"4312:35141", -- [21]
			"4312:35140", -- [22]
			"35562:35556:2995:35139", -- [23]
			"35562:35556", -- [24]
			"6726:40473:41605:15178:39175", -- [25]
			"35562:35556:2995:39340", -- [26]
			"35562:35556:2995:52060:39330", -- [27]
			"35562:35556:2995:40809", -- [28]
			"35562:35556:2995:3615:40558", -- [29]
			"35562:35556:2995:52060:39330:40358:40769", -- [30]
			"35562:35556:2995:7824:41215", -- [31]
			"35562:35556:2995:3310:41140:41142", -- [32]
			"35562:35556:2995:3310:41140", -- [33]
			"35562:35556:2995:7824:41214", -- [34]
			"4312:41246", -- [35]
			"4312:35140:34943:12616:36728:43549:50084", -- [36]
			"4312:35140:34943:12616:36728:43549:50084:53783", -- [37]
			"4312:35140:34943:12616:36728:43549:50084:41861", -- [38]
			"6726:40473", -- [39]
			"6726:40473:41605", -- [40]
			"4312:34429:22931:43073", -- [41]
			"4312:34429:22931:43079", -- [42]
			"4312:34429:22931:43073:43085", -- [43]
			"35562:35556:2995:3310:37005", -- [44]
			"35562:35556:2995:8610:43328", -- [45]
			"4312:35140:34943:12616:36728:43549", -- [46]
			"6726:40473:41605:15178:48274:48275", -- [47]
			"6726:40473:41605:15178:48274", -- [48]
			"6726:40473:41605:15178:48274:48273", -- [49]
			"4312:35140:34943:12616:36728", -- [50]
			"4312:35140:34943:12616:36728:43549:50084:54393", -- [51]
			--["name"] = "Furien's Post, Desolace",
			["m"] = 66,
			["coord"] = 1901743131,
			["direct"] = "4312:6726:39898:35478:35562",
			["f"] = 0,
		},
		[3615] = {
			"2995:6726", -- [1]
			"3310:11139", -- [2]
			"34927:12616:22931:43073:43085:12740", -- [3]
			"52060:39330:39898:15178", -- [4]
			"52060:39330:40358:40769:7824:10583", -- [5]
			"34927:12616:22931", -- [6]
			"52060:39330:40358", -- [7]
			"34927:34429", -- [8]
			"34927:34943", -- [9]
			"4312:35141", -- [10]
			"4312:35140", -- [11]
			"2995:35556:35562:35315", -- [12]
			"2995:35556:35478", -- [13]
			"2995:35556", -- [14]
			"2995:35556:35562", -- [15]
			"52060:39330:40358:40769:7824:39175", -- [16]
			"52060:39330", -- [17]
			"2995:40809", -- [18]
			"52060:39330:40358:40769", -- [19]
			"52060:39330:40358:40769:7824:41215", -- [20]
			"3310:41140:41142", -- [21]
			"3310:41140", -- [22]
			"52060:39330:40358:40769:7824:41214", -- [23]
			"4312:41246", -- [24]
			"3310:43549:50084", -- [25]
			"3310:43549:50084:53783", -- [26]
			"3310:43549:50084:41861", -- [27]
			"2995:6726:40473", -- [28]
			"52060:39330:39898:41605", -- [29]
			"34927:12616:22931:43073", -- [30]
			"34927:12616:22931:43079", -- [31]
			"34927:12616:22931:43073:43085", -- [32]
			"3310:37005", -- [33]
			"8610:43328", -- [34]
			"3310:43549", -- [35]
			"52060:39330:40358:40769:7824:41215:48275", -- [36]
			"52060:39330:39898:15178:48274", -- [37]
			"52060:39330:39898:15178:48274:48273", -- [38]
			"34927:12616:36728", -- [39]
			"3310:43549:50084:54393", -- [40]
			--["name"] = "The Crossroads, Northern Barrens",
			["m"] = 10,
			["f"] = 0,
			["direct"] = "2995:3310:4312:44399:7824:39898:8610:11899:11901:12616:52060:16227:34927:35139:39340:40558",
			["coord"] = 2091619965,
		},
		[3310] = {
			"3615:4312", -- [1]
			"3615:44399", -- [2]
			"3615:2995:6726", -- [3]
			"3615:52060:39330:39898", -- [4]
			"12616:34429:11901", -- [5]
			"43549:50084:41861:12740", -- [6]
			"3615:52060", -- [7]
			"7824:10583", -- [8]
			"12616:22931", -- [9]
			"16227:11899:40358", -- [10]
			"12616:34429", -- [11]
			"12616:34943", -- [12]
			"12616:34429:35141", -- [13]
			"12616:34943:35140", -- [14]
			"3615:35139", -- [15]
			"3615:2995:35556:35562:35315", -- [16]
			"3615:2995:35556:35478", -- [17]
			"3615:2995:35556", -- [18]
			"3615:2995:35556:35562", -- [19]
			"7824:39175", -- [20]
			"3615:39340", -- [21]
			"3615:52060:39330", -- [22]
			"3615:2995:40809", -- [23]
			"16227:11899:40358:40769", -- [24]
			"7824:41215", -- [25]
			"41140:41142", -- [26]
			"7824:41214", -- [27]
			"12616:34943:35140:41246", -- [28]
			"43549:50084", -- [29]
			"43549:50084:53783", -- [30]
			"43549:50084:41861", -- [31]
			"3615:2995:6726:40473", -- [32]
			"3615:52060:39330:39898:41605", -- [33]
			"12616:22931:43073", -- [34]
			"12616:22931:43079", -- [35]
			"12616:22931:43073:43085", -- [36]
			"8610:43328", -- [37]
			"7824:41215:48275", -- [38]
			"7824:41215:48275:48274", -- [39]
			"7824:41215:48275:48273", -- [40]
			"43549:50084:54393", -- [41]
			--["name"] = "Orgrimmar, Durotar",
			["m"] = 85,
			["coord"] = 2132580095,
			["direct"] = "2995:3615:7824:8610:11139:11899:12616:16227:34927:40558:41140:37005:43549:36728",
			["f"] = 0,
		},
		[34943] = {
			"35140:35139:2995", -- [1]
			"34927:3310", -- [2]
			"34927:3615", -- [3]
			"35140:4312", -- [4]
			"34927:3615:44399", -- [5]
			"35140:4312:6726", -- [6]
			"34927:3615:52060:39330:40358:40769:7824", -- [7]
			"34927:3615:52060:39330:39898", -- [8]
			"12616:36728:8610", -- [9]
			"12616:36728:8610:11139", -- [10]
			"34927:3615:52060:11899", -- [11]
			"34429:11901", -- [12]
			"34429:22931:43073:43085:12740", -- [13]
			"34927:3615:52060:39330:39898:15178", -- [14]
			"34927:3615:52060", -- [15]
			"34927:3615:52060:39330:40358:40769:7824:10583", -- [16]
			"34927:3615:16227", -- [17]
			"34429:22931", -- [18]
			"34927:3615:52060:39330:40358", -- [19]
			"34429:35141", -- [20]
			"35140:35139", -- [21]
			"35140:4312:35315", -- [22]
			"35140:4312:35478", -- [23]
			"35140:35139:2995:35556", -- [24]
			"35140:4312:35315:35562", -- [25]
			"34927:3615:52060:39330:40358:40769:7824:39175", -- [26]
			"34927:3615:39340", -- [27]
			"34927:3615:52060:39330", -- [28]
			"35140:35139:2995:40809", -- [29]
			"34927:40558", -- [30]
			"34927:3615:52060:39330:40358:40769", -- [31]
			"34927:3615:52060:39330:40358:40769:7824:41215", -- [32]
			"34927:3310:41140:41142", -- [33]
			"34927:3310:41140", -- [34]
			"34927:3615:52060:39330:40358:40769:7824:41214", -- [35]
			"35140:41246", -- [36]
			"12616:36728:43549:50084", -- [37]
			"12616:36728:43549:50084:53783", -- [38]
			"12616:36728:43549:50084:41861", -- [39]
			"35140:4312:6726:40473", -- [40]
			"34927:3615:52060:39330:39898:41605", -- [41]
			"34429:22931:43073", -- [42]
			"34429:22931:43079", -- [43]
			"34429:22931:43073:43085", -- [44]
			"12616:36728:8610:37005", -- [45]
			"12616:36728:8610:43328", -- [46]
			"12616:36728:43549", -- [47]
			"34927:3615:52060:39330:40358:40769:7824:41215:48275", -- [48]
			"34927:3615:52060:39330:39898:15178:48274", -- [49]
			"34927:3615:52060:39330:39898:15178:48274:48273", -- [50]
			"12616:36728", -- [51]
			"12616:36728:43549:50084:54393", -- [52]
			--["name"] = "Silverwind Refuge, Ashenvale",
			["m"] = 63,
			["f"] = 0,
			["direct"] = "12616:34429:34927:35140",
			["coord"] = 2118297444,
		},
		[10583] = {
			"7824:2995", -- [1]
			"7824:16227:3310", -- [2]
			"7824:3615", -- [3]
			"39175:15178:41605:40473:6726:35478:4312", -- [4]
			"7824:44399", -- [5]
			"39175:15178:41605:40473:6726", -- [6]
			"39175:15178:39898", -- [7]
			"7824:16227:3310:8610", -- [8]
			"7824:16227:3310:11139", -- [9]
			"7824:40769:40358:11899", -- [10]
			"7824:3615:34927:34429:11901", -- [11]
			"7824:3615:34927:12616", -- [12]
			"7824:16227:3310:43549:50084:41861:12740", -- [13]
			"7824:40769:40358:11899:52060", -- [14]
			"7824:16227", -- [15]
			"7824:3615:34927:12616:22931", -- [16]
			"7824:40769:40358", -- [17]
			"7824:3615:34927:34429", -- [18]
			"7824:3615:34927", -- [19]
			"7824:3615:34927:34943", -- [20]
			"7824:2995:35139:35141", -- [21]
			"7824:2995:35139:35140", -- [22]
			"7824:2995:35139", -- [23]
			"39175:15178:41605:40473:6726:35315", -- [24]
			"39175:15178:41605:40473:6726:35478", -- [25]
			"39175:15178:41605:40473:6726:35478:35556", -- [26]
			"39175:15178:41605:40473:6726:35315:35562", -- [27]
			"7824:40769:40358:11899:52060:39340", -- [28]
			"7824:40769:40358:39330", -- [29]
			"7824:2995:40809", -- [30]
			"7824:3615:40558", -- [31]
			"7824:40769", -- [32]
			"7824:41215", -- [33]
			"7824:16227:3310:41140:41142", -- [34]
			"7824:16227:3310:41140", -- [35]
			"7824:41214", -- [36]
			"39175:15178:41605:40473:6726:35478:4312:41246", -- [37]
			"7824:16227:3310:43549:50084", -- [38]
			"7824:16227:3310:43549:50084:53783", -- [39]
			"7824:16227:3310:43549:50084:41861", -- [40]
			"39175:15178:41605:40473", -- [41]
			"39175:15178:41605", -- [42]
			"7824:3615:34927:12616:22931:43073", -- [43]
			"7824:3615:34927:12616:22931:43079", -- [44]
			"7824:3615:34927:12616:22931:43073:43085", -- [45]
			"7824:16227:3310:37005", -- [46]
			"7824:16227:3310:8610:43328", -- [47]
			"7824:16227:3310:43549", -- [48]
			"39175:15178:48274:48275", -- [49]
			"39175:15178:48274", -- [50]
			"39175:15178:48274:48273", -- [51]
			"7824:16227:3310:36728", -- [52]
			"7824:16227:3310:43549:50084:54393", -- [53]
			--["name"] = "Marshal's Stand, Un'Goro Crater",
			["m"] = 78,
			["coord"] = 2408031264,
			["direct"] = "7824:15178:39175",
			["f"] = 0,
		},
		[6726] = {
			"35478:35556:2995:3310", -- [1]
			"35139:3615", -- [2]
			"39898:44399", -- [3]
			"39898:44399:40769:7824", -- [4]
			"35478:35556:2995:8610", -- [5]
			"35478:35556:2995:8610:11139", -- [6]
			"35478:35556:2995:52060:11899", -- [7]
			"35478:4312:11901", -- [8]
			"35478:4312:35140:34943:12616", -- [9]
			"35478:4312:34429:22931:43073:43085:12740", -- [10]
			"40473:41605:15178", -- [11]
			"35478:35556:2995:52060", -- [12]
			"40473:41605:15178:39175:10583", -- [13]
			"35139:3615:16227", -- [14]
			"35478:4312:34429:22931", -- [15]
			"39898:44399:40358", -- [16]
			"35478:4312:34429", -- [17]
			"35139:3615:34927", -- [18]
			"35478:4312:35140:34943", -- [19]
			"35478:4312:35141", -- [20]
			"35478:4312:35140", -- [21]
			"35478:35556", -- [22]
			"40473:41605:15178:39175", -- [23]
			"35478:35556:2995:39340", -- [24]
			"35478:35556:2995:52060:39330", -- [25]
			"35478:35556:2995:40809", -- [26]
			"35139:3615:40558", -- [27]
			"39898:44399:40769", -- [28]
			"40473:41605:15178:48274:48275:41215", -- [29]
			"35478:35556:2995:3310:41140:41142", -- [30]
			"35478:35556:2995:3310:41140", -- [31]
			"39898:44399:40769:7824:41214", -- [32]
			"35478:4312:41246", -- [33]
			"35478:35556:2995:3310:43549:50084", -- [34]
			"35478:35556:2995:3310:43549:50084:53783", -- [35]
			"35478:35556:2995:3310:43549:50084:41861", -- [36]
			"40473:41605", -- [37]
			"35478:4312:34429:22931:43073", -- [38]
			"35478:4312:34429:22931:43079", -- [39]
			"35478:4312:34429:22931:43073:43085", -- [40]
			"35478:35556:2995:3310:37005", -- [41]
			"35478:35556:2995:8610:43328", -- [42]
			"35478:35556:2995:3310:43549", -- [43]
			"40473:41605:15178:48274:48275", -- [44]
			"40473:41605:15178:48274", -- [45]
			"40473:41605:15178:48274:48273", -- [46]
			"35478:4312:35140:34943:12616:36728", -- [47]
			"35478:35556:2995:3310:43549:50084:54393", -- [48]
			--["name"] = "Shadowprey Village, Desolace",
			["m"] = 66,
			["coord"] = 926137739,
			["direct"] = "2995:4312:39898:35139:35315:35478:35562:40473",
			["f"] = 0,
		},
		[44399] = {
			"11899:16227:3310", -- [1]
			"3615:4312", -- [2]
			"39898:41605:40473:6726", -- [3]
			"11899:16227:3310:8610", -- [4]
			"11899:16227:3310:11139", -- [5]
			"3615:34927:34429:11901", -- [6]
			"3615:34927:12616", -- [7]
			"3615:34927:12616:22931:43073:43085:12740", -- [8]
			"39898:15178", -- [9]
			"40769:7824:10583", -- [10]
			"11899:16227", -- [11]
			"3615:34927:12616:22931", -- [12]
			"3615:34927:34429", -- [13]
			"3615:34927", -- [14]
			"3615:34927:34943", -- [15]
			"2995:35139:35141", -- [16]
			"2995:35139:35140", -- [17]
			"2995:35139", -- [18]
			"39898:35315", -- [19]
			"39898:41605:40473:6726:35478", -- [20]
			"2995:35556", -- [21]
			"39898:35315:35562", -- [22]
			"40769:7824:39175", -- [23]
			"52060:39340", -- [24]
			"2995:40809", -- [25]
			"3615:40558", -- [26]
			"40769:7824:41215", -- [27]
			"11899:16227:3310:41140:41142", -- [28]
			"11899:16227:3310:41140", -- [29]
			"40769:7824:41214", -- [30]
			"3615:4312:41246", -- [31]
			"11899:16227:3310:43549:50084", -- [32]
			"11899:16227:3310:43549:50084:53783", -- [33]
			"11899:16227:3310:43549:50084:41861", -- [34]
			"39898:41605:40473", -- [35]
			"39898:41605", -- [36]
			"3615:34927:12616:22931:43073", -- [37]
			"3615:34927:12616:22931:43079", -- [38]
			"3615:34927:12616:22931:43073:43085", -- [39]
			"11899:16227:3310:37005", -- [40]
			"11899:16227:3310:8610:43328", -- [41]
			"11899:16227:3310:43549", -- [42]
			"39898:15178:48274:48275", -- [43]
			"39898:15178:48274", -- [44]
			"39898:15178:48274:48273", -- [45]
			"3615:34927:12616:36728", -- [46]
			"11899:16227:3310:43549:50084:54393", -- [47]
			--["name"] = "Westreach Summit, Thousand Needles",
			["m"] = 64,
			["coord"] = 481959428,
			["direct"] = "2995:3615:7824:39898:11899:52060:40358:39330:40769",
			["f"] = 0,
		},
		[35140] = {
			"35139:2995", -- [1]
			"34927:3310", -- [2]
			"35139:3615", -- [3]
			"35139:2995:44399", -- [4]
			"4312:6726", -- [5]
			"35139:2995:7824", -- [6]
			"35139:2995:52060:39330:39898", -- [7]
			"34943:12616:36728:8610", -- [8]
			"34943:12616:36728:8610:11139", -- [9]
			"35139:2995:52060:11899", -- [10]
			"35141:11901", -- [11]
			"34943:12616", -- [12]
			"34943:34429:22931:43073:43085:12740", -- [13]
			"4312:6726:40473:41605:15178", -- [14]
			"35139:2995:52060", -- [15]
			"35139:2995:7824:10583", -- [16]
			"35139:3615:16227", -- [17]
			"34943:34429:22931", -- [18]
			"35139:2995:52060:39330:40358", -- [19]
			"34943:34429", -- [20]
			"4312:35315", -- [21]
			"4312:35478", -- [22]
			"35139:2995:35556", -- [23]
			"4312:35315:35562", -- [24]
			"35139:2995:7824:39175", -- [25]
			"35139:2995:39340", -- [26]
			"35139:2995:52060:39330", -- [27]
			"35139:2995:40809", -- [28]
			"34927:40558", -- [29]
			"35139:2995:52060:39330:40358:40769", -- [30]
			"35139:2995:7824:41215", -- [31]
			"34927:3310:41140:41142", -- [32]
			"34927:3310:41140", -- [33]
			"35139:2995:7824:41214", -- [34]
			"34943:12616:36728:43549:50084", -- [35]
			"34943:12616:36728:43549:50084:53783", -- [36]
			"34943:12616:36728:43549:50084:41861", -- [37]
			"4312:6726:40473", -- [38]
			"4312:6726:40473:41605", -- [39]
			"34943:34429:22931:43073", -- [40]
			"34943:34429:22931:43079", -- [41]
			"34943:34429:22931:43073:43085", -- [42]
			"34943:12616:36728:8610:37005", -- [43]
			"34943:12616:36728:8610:43328", -- [44]
			"34943:12616:36728:43549", -- [45]
			"4312:6726:40473:41605:15178:48274:48275", -- [46]
			"4312:6726:40473:41605:15178:48274", -- [47]
			"4312:6726:40473:41605:15178:48274:48273", -- [48]
			"34943:12616:36728", -- [49]
			"34943:12616:36728:43549:50084:54393", -- [50]
			--["name"] = "Krom'gar Fortress, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "4312:34927:34943:35141:35139:41246",
			["coord"] = 2857476284,
		},
		[35139] = {
			"3615:3310", -- [1]
			"2995:44399", -- [2]
			"2995:7824", -- [3]
			"2995:52060:39330:39898", -- [4]
			"3615:8610", -- [5]
			"3615:3310:11139", -- [6]
			"2995:52060:11899", -- [7]
			"35141:11901", -- [8]
			"3615:34927:12616", -- [9]
			"4312:34429:22931:43073:43085:12740", -- [10]
			"2995:52060:39330:39898:15178", -- [11]
			"2995:52060", -- [12]
			"2995:7824:10583", -- [13]
			"3615:16227", -- [14]
			"4312:34429:22931", -- [15]
			"2995:52060:39330:40358", -- [16]
			"4312:34429", -- [17]
			"3615:34927", -- [18]
			"35140:34943", -- [19]
			"4312:35315", -- [20]
			"2995:35556:35478", -- [21]
			"2995:35556", -- [22]
			"2995:35556:35562", -- [23]
			"2995:7824:39175", -- [24]
			"2995:39340", -- [25]
			"2995:52060:39330", -- [26]
			"2995:40809", -- [27]
			"3615:40558", -- [28]
			"2995:52060:39330:40358:40769", -- [29]
			"2995:7824:41215", -- [30]
			"3615:3310:41140:41142", -- [31]
			"3615:3310:41140", -- [32]
			"2995:7824:41214", -- [33]
			"4312:41246", -- [34]
			"3615:3310:43549:50084", -- [35]
			"3615:3310:43549:50084:53783", -- [36]
			"3615:3310:43549:50084:41861", -- [37]
			"6726:40473", -- [38]
			"6726:40473:41605", -- [39]
			"4312:34429:22931:43073", -- [40]
			"4312:34429:22931:43079", -- [41]
			"4312:34429:22931:43073:43085", -- [42]
			"3615:3310:37005", -- [43]
			"3615:8610:43328", -- [44]
			"3615:3310:43549", -- [45]
			"2995:7824:41215:48275", -- [46]
			"2995:52060:39330:39898:15178:48274", -- [47]
			"2995:52060:39330:39898:15178:48274:48273", -- [48]
			"3615:34927:12616:36728", -- [49]
			"3615:3310:43549:50084:54393", -- [50]
			--["name"] = "Malaka'jin, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "2995:3615:4312:6726:35141:35140",
			["coord"] = 3032343762,
		},
		[22931] = {
			"34429:4312:35139:2995", -- [1]
			"12616:3310", -- [2]
			"12616:34927:3615", -- [3]
			"34429:4312", -- [4]
			"12616:34927:3615:44399", -- [5]
			"34429:4312:6726", -- [6]
			"12616:34927:3615:52060:39330:40358:40769:7824", -- [7]
			"12616:34927:3615:52060:39330:39898", -- [8]
			"12616:36728:8610", -- [9]
			"43073:43085:11139", -- [10]
			"12616:34927:3615:52060:11899", -- [11]
			"43073:43085:12740", -- [12]
			"12616:34927:3615:52060:39330:39898:15178", -- [13]
			"12616:34927:3615:52060", -- [14]
			"12616:34927:3615:52060:39330:40358:40769:7824:10583", -- [15]
			"12616:34927:3615:16227", -- [16]
			"12616:34927:3615:52060:39330:40358", -- [17]
			"12616:34927", -- [18]
			"34429:34943", -- [19]
			"34429:35141", -- [20]
			"34429:34943:35140", -- [21]
			"34429:4312:35139", -- [22]
			"34429:4312:35315", -- [23]
			"34429:4312:35478", -- [24]
			"34429:4312:35478:35556", -- [25]
			"34429:4312:35315:35562", -- [26]
			"12616:34927:3615:52060:39330:40358:40769:7824:39175", -- [27]
			"12616:34927:3615:39340", -- [28]
			"12616:34927:3615:52060:39330", -- [29]
			"34429:4312:35139:2995:40809", -- [30]
			"12616:34927:40558", -- [31]
			"12616:34927:3615:52060:39330:40358:40769", -- [32]
			"12616:34927:3615:52060:39330:40358:40769:7824:41215", -- [33]
			"12616:3310:41140:41142", -- [34]
			"12616:3310:41140", -- [35]
			"12616:34927:3615:52060:39330:40358:40769:7824:41214", -- [36]
			"34429:35141:41246", -- [37]
			"12616:36728:43549:50084", -- [38]
			"12616:36728:43549:50084:53783", -- [39]
			"12616:36728:43549:50084:41861", -- [40]
			"34429:4312:6726:40473", -- [41]
			"12616:34927:3615:52060:39330:39898:41605", -- [42]
			"43073:43085", -- [43]
			"12616:36728:8610:37005", -- [44]
			"12616:36728:8610:43328", -- [45]
			"12616:36728:43549", -- [46]
			"12616:34927:3615:52060:39330:40358:40769:7824:41215:48275", -- [47]
			"12616:34927:3615:52060:39330:39898:15178:48274", -- [48]
			"12616:34927:3615:52060:39330:39898:15178:48274:48273", -- [49]
			"12616:36728", -- [50]
			"12616:36728:43549:50084:54393", -- [51]
			--["name"] = "Emerald Sanctuary, Felwood",
			["m"] = 77,
			["f"] = 0,
			["direct"] = "11901:12616:34429:43073:43079",
			["coord"] = 2212089545,
		},
		[50084] = {
			"43549:3310:3615:2995", -- [1]
			"43549:3310", -- [2]
			"43549:3310:3615", -- [3]
			"43549:36728:12616:34943:35140:4312", -- [4]
			"43549:3310:3615:44399", -- [5]
			"43549:36728:12616:34943:35140:4312:6726", -- [6]
			"43549:3310:7824", -- [7]
			"43549:3310:3615:52060:39330:39898", -- [8]
			"43549:36728:8610", -- [9]
			"41861:11139", -- [10]
			"43549:3310:16227:11899", -- [11]
			"43549:36728:12616:34429:11901", -- [12]
			"43549:36728:12616", -- [13]
			"41861:12740", -- [14]
			"43549:3310:3615:52060:39330:39898:15178", -- [15]
			"43549:3310:3615:52060", -- [16]
			"43549:3310:7824:10583", -- [17]
			"43549:3310:16227", -- [18]
			"43549:36728:12616:22931", -- [19]
			"43549:3310:16227:11899:40358", -- [20]
			"43549:36728:12616:34429", -- [21]
			"43549:36728:12616:34927", -- [22]
			"43549:36728:12616:34943", -- [23]
			"43549:36728:12616:34429:35141", -- [24]
			"43549:36728:12616:34943:35140", -- [25]
			"43549:36728:12616:34943:35140:35139", -- [26]
			"43549:36728:12616:34943:35140:4312:35315", -- [27]
			"43549:36728:12616:34943:35140:4312:35478", -- [28]
			"43549:3310:3615:2995:35556", -- [29]
			"43549:36728:12616:34943:35140:4312:35315:35562", -- [30]
			"43549:3310:7824:39175", -- [31]
			"43549:3310:3615:39340", -- [32]
			"43549:3310:3615:52060:39330", -- [33]
			"43549:3310:3615:2995:40809", -- [34]
			"43549:3310:40558", -- [35]
			"43549:3310:16227:11899:40358:40769", -- [36]
			"43549:3310:7824:41215", -- [37]
			"43549:3310:41140:41142", -- [38]
			"43549:3310:41140", -- [39]
			"43549:3310:7824:41214", -- [40]
			"43549:36728:12616:34943:35140:41246", -- [41]
			"43549:36728:12616:34943:35140:4312:6726:40473", -- [42]
			"43549:3310:3615:52060:39330:39898:41605", -- [43]
			"41861:12740:43085:43073", -- [44]
			"43549:36728:12616:22931:43079", -- [45]
			"41861:12740:43085", -- [46]
			"43549:36728:8610:37005", -- [47]
			"43549:36728:8610:43328", -- [48]
			"43549:3310:7824:41215:48275", -- [49]
			"43549:3310:3615:52060:39330:39898:15178:48274", -- [50]
			"43549:3310:3615:52060:39330:39898:15178:48274:48273", -- [51]
			"43549:36728", -- [52]
			["direct"] = "53783:41861:43549:54393",
			["f"] = 0,
			["m"] = 198,
			["coord"] = 1766616413,
		},
		[37005] = {
			"3310:3615:2995", -- [1]
			"3310:3615", -- [2]
			"3310:3615:4312", -- [3]
			"3310:3615:44399", -- [4]
			"3310:3615:2995:6726", -- [5]
			"3310:7824", -- [6]
			"3310:3615:52060:39330:39898", -- [7]
			"8610:11139", -- [8]
			"3310:16227:11899", -- [9]
			"3310:12616:34429:11901", -- [10]
			"3310:12616", -- [11]
			"8610:11139:12740", -- [12]
			"3310:3615:52060:39330:39898:15178", -- [13]
			"3310:3615:52060", -- [14]
			"3310:7824:10583", -- [15]
			"3310:16227", -- [16]
			"3310:12616:22931", -- [17]
			"3310:16227:11899:40358", -- [18]
			"3310:12616:34429", -- [19]
			"3310:34927", -- [20]
			"3310:12616:34943", -- [21]
			"3310:12616:34429:35141", -- [22]
			"3310:12616:34943:35140", -- [23]
			"3310:3615:35139", -- [24]
			"3310:3615:2995:35556:35562:35315", -- [25]
			"3310:3615:2995:35556:35478", -- [26]
			"3310:3615:2995:35556", -- [27]
			"3310:3615:2995:35556:35562", -- [28]
			"3310:7824:39175", -- [29]
			"3310:3615:39340", -- [30]
			"3310:3615:52060:39330", -- [31]
			"3310:3615:2995:40809", -- [32]
			"3310:40558", -- [33]
			"3310:16227:11899:40358:40769", -- [34]
			"3310:7824:41215", -- [35]
			"3310:41140:41142", -- [36]
			"3310:41140", -- [37]
			"3310:7824:41214", -- [38]
			"3310:12616:34943:35140:41246", -- [39]
			"8610:36728:43549:50084", -- [40]
			"8610:36728:43549:50084:53783", -- [41]
			"8610:36728:43549:50084:41861", -- [42]
			"3310:3615:2995:6726:40473", -- [43]
			"3310:3615:52060:39330:39898:41605", -- [44]
			"8610:11139:43085:43073", -- [45]
			"3310:12616:22931:43079", -- [46]
			"8610:11139:43085", -- [47]
			"8610:43328", -- [48]
			"8610:36728:43549", -- [49]
			"3310:7824:41215:48275", -- [50]
			"3310:3615:52060:39330:39898:15178:48274", -- [51]
			"3310:3615:52060:39330:39898:15178:48274:48273", -- [52]
			"8610:36728", -- [53]
			"8610:36728:43549:50084:54393", -- [54]
			--["name"] = "Southern Rocketway, Azshara",
			["m"] = 76,
			["f"] = 0,
			["direct"] = "3310:8610",
			["coord"] = 2213068365,
		},
		[34927] = {
			"3615:2995", -- [1]
			"35140:4312", -- [2]
			"3615:44399", -- [3]
			"3615:2995:6726", -- [4]
			"3615:52060:39330:40358:40769:7824", -- [5]
			"3615:52060:39330:39898", -- [6]
			"12616:36728:8610", -- [7]
			"12616:36728:8610:11139", -- [8]
			"3615:52060:11899", -- [9]
			"34429:11901", -- [10]
			"12616:22931:43073:43085:12740", -- [11]
			"3615:52060:39330:39898:15178", -- [12]
			"3615:52060", -- [13]
			"3615:52060:39330:40358:40769:7824:10583", -- [14]
			"3615:16227", -- [15]
			"12616:22931", -- [16]
			"3615:52060:39330:40358", -- [17]
			"34429:35141", -- [18]
			"3615:35139", -- [19]
			"35140:4312:35315", -- [20]
			"3615:2995:35556:35478", -- [21]
			"3615:2995:35556", -- [22]
			"3615:2995:35556:35562", -- [23]
			"3615:52060:39330:40358:40769:7824:39175", -- [24]
			"3615:39340", -- [25]
			"3615:52060:39330", -- [26]
			"3615:2995:40809", -- [27]
			"3615:52060:39330:40358:40769", -- [28]
			"3615:52060:39330:40358:40769:7824:41215", -- [29]
			"3310:41140:41142", -- [30]
			"3310:41140", -- [31]
			"3615:52060:39330:40358:40769:7824:41214", -- [32]
			"35140:41246", -- [33]
			"12616:36728:43549:50084", -- [34]
			"12616:36728:43549:50084:53783", -- [35]
			"12616:36728:43549:50084:41861", -- [36]
			"3615:2995:6726:40473", -- [37]
			"3615:52060:39330:39898:41605", -- [38]
			"12616:22931:43073", -- [39]
			"12616:22931:43079", -- [40]
			"12616:22931:43073:43085", -- [41]
			"3310:37005", -- [42]
			"12616:36728:8610:43328", -- [43]
			"12616:36728:43549", -- [44]
			"3615:52060:39330:40358:40769:7824:41215:48275", -- [45]
			"3615:52060:39330:39898:15178:48274", -- [46]
			"3615:52060:39330:39898:15178:48274:48273", -- [47]
			"12616:36728", -- [48]
			"12616:36728:43549:50084:54393", -- [49]
			--["name"] = "The Mor'Shan Ramparts, Ashenvale",
			["m"] = 10,
			["f"] = 0,
			["direct"] = "3310:3615:12616:34429:34943:35140:40558",
			["coord"] = 1802381409,
		},
		[40558] = {
			"3615:2995", -- [1]
			"3615:4312", -- [2]
			"3615:44399", -- [3]
			"3615:2995:6726", -- [4]
			"3615:52060:39330:40358:40769:7824", -- [5]
			"3615:52060:39330:39898", -- [6]
			"3310:8610", -- [7]
			"3310:11139", -- [8]
			"3615:52060:11899", -- [9]
			"34927:34429:11901", -- [10]
			"34927:12616", -- [11]
			"34927:12616:22931:43073:43085:12740", -- [12]
			"3615:52060:39330:39898:15178", -- [13]
			"3615:52060", -- [14]
			"3615:52060:39330:40358:40769:7824:10583", -- [15]
			"3615:16227", -- [16]
			"34927:12616:22931", -- [17]
			"3615:52060:39330:40358", -- [18]
			"34927:34429", -- [19]
			"34927:34943", -- [20]
			"34927:34429:35141", -- [21]
			"34927:35140", -- [22]
			"3615:35139", -- [23]
			"3615:2995:35556:35562:35315", -- [24]
			"3615:2995:35556:35478", -- [25]
			"3615:2995:35556", -- [26]
			"3615:2995:35556:35562", -- [27]
			"3615:52060:39330:40358:40769:7824:39175", -- [28]
			"3615:39340", -- [29]
			"3615:52060:39330", -- [30]
			"3615:2995:40809", -- [31]
			"3615:52060:39330:40358:40769", -- [32]
			"3615:52060:39330:40358:40769:7824:41215", -- [33]
			"3310:41140:41142", -- [34]
			"3310:41140", -- [35]
			"3615:52060:39330:40358:40769:7824:41214", -- [36]
			"34927:35140:41246", -- [37]
			"3310:43549:50084", -- [38]
			"3310:43549:50084:53783", -- [39]
			"3310:43549:50084:41861", -- [40]
			"3615:2995:6726:40473", -- [41]
			"3615:52060:39330:39898:41605", -- [42]
			"34927:12616:22931:43073", -- [43]
			"34927:12616:22931:43079", -- [44]
			"34927:12616:22931:43073:43085", -- [45]
			"3310:37005", -- [46]
			"3310:8610:43328", -- [47]
			"3310:43549", -- [48]
			"3615:52060:39330:40358:40769:7824:41215:48275", -- [49]
			"3615:52060:39330:39898:15178:48274", -- [50]
			"3615:52060:39330:39898:15178:48274:48273", -- [51]
			"3310:36728", -- [52]
			"3310:43549:50084:54393", -- [53]
			--["name"] = "Nozzlepot's Outpost, Northern Barrens",
			["m"] = 10,
			["f"] = 0,
			["direct"] = "3310:3615:34927",
			["coord"] = 2678860788,
		},
		[40473] = {
			"6726:35478:35556:2995", -- [1]
			"6726:35478:35556:2995:3310", -- [2]
			"6726:35139:3615", -- [3]
			"6726:35478:4312", -- [4]
			"41605:39898:44399", -- [5]
			"41605:39898:44399:40769:7824", -- [6]
			"41605:39898", -- [7]
			"6726:35478:35556:2995:8610", -- [8]
			"6726:35478:35556:2995:8610:11139", -- [9]
			"41605:39898:44399:11899", -- [10]
			"6726:35478:4312:11901", -- [11]
			"6726:35478:4312:35140:34943:12616", -- [12]
			"6726:35478:4312:34429:22931:43073:43085:12740", -- [13]
			"41605:15178", -- [14]
			"41605:39898:39330:52060", -- [15]
			"41605:15178:39175:10583", -- [16]
			"6726:35139:3615:16227", -- [17]
			"6726:35478:4312:34429:22931", -- [18]
			"41605:39898:44399:40358", -- [19]
			"6726:35478:4312:34429", -- [20]
			"6726:35139:3615:34927", -- [21]
			"6726:35478:4312:35140:34943", -- [22]
			"6726:35478:4312:35141", -- [23]
			"6726:35478:4312:35140", -- [24]
			"6726:35139", -- [25]
			"6726:35315", -- [26]
			"6726:35478", -- [27]
			"6726:35478:35556", -- [28]
			"6726:35315:35562", -- [29]
			"41605:15178:39175", -- [30]
			"6726:35478:35556:2995:39340", -- [31]
			"41605:39898:39330", -- [32]
			"6726:35478:35556:2995:40809", -- [33]
			"6726:35139:3615:40558", -- [34]
			"41605:39898:44399:40769", -- [35]
			"41605:15178:48274:48275:41215", -- [36]
			"6726:35478:35556:2995:3310:41140:41142", -- [37]
			"6726:35478:35556:2995:3310:41140", -- [38]
			"41605:39898:44399:40769:7824:41214", -- [39]
			"6726:35478:4312:41246", -- [40]
			"6726:35478:35556:2995:3310:43549:50084", -- [41]
			"6726:35478:35556:2995:3310:43549:50084:53783", -- [42]
			"6726:35478:35556:2995:3310:43549:50084:41861", -- [43]
			"6726:35478:4312:34429:22931:43073", -- [44]
			"6726:35478:4312:34429:22931:43079", -- [45]
			"6726:35478:4312:34429:22931:43073:43085", -- [46]
			"6726:35478:35556:2995:3310:37005", -- [47]
			"6726:35478:35556:2995:8610:43328", -- [48]
			"6726:35478:35556:2995:3310:43549", -- [49]
			"41605:15178:48274:48275", -- [50]
			"41605:15178:48274", -- [51]
			"41605:15178:48274:48273", -- [52]
			"6726:35478:4312:35140:34943:12616:36728", -- [53]
			"6726:35478:35556:2995:3310:43549:50084:54393", -- [54]
			--["name"] = "Camp Ataya, Feralas",
			["m"] = 69,
			["coord"] = 1782589281,
			["direct"] = "6726:41605",
			["f"] = 0,
		},
		[16227] = {
			"3615:2995", -- [1]
			"3615:4312", -- [2]
			"11899:44399", -- [3]
			"3615:2995:6726", -- [4]
			"11899:39330:39898", -- [5]
			"3310:8610", -- [6]
			"3310:11139", -- [7]
			"3615:34927:34429:11901", -- [8]
			"3615:34927:12616", -- [9]
			"3310:43549:50084:41861:12740", -- [10]
			"11899:39330:39898:15178", -- [11]
			"3615:52060", -- [12]
			"7824:10583", -- [13]
			"3615:34927:12616:22931", -- [14]
			"11899:40358", -- [15]
			"3615:34927:34429", -- [16]
			"3615:34927", -- [17]
			"3615:34927:34943", -- [18]
			"3615:4312:35141", -- [19]
			"3615:4312:35140", -- [20]
			"3615:35139", -- [21]
			"3615:2995:35556:35562:35315", -- [22]
			"3615:2995:35556:35478", -- [23]
			"3615:2995:35556", -- [24]
			"3615:2995:35556:35562", -- [25]
			"7824:39175", -- [26]
			"3615:39340", -- [27]
			"11899:39330", -- [28]
			"3615:2995:40809", -- [29]
			"3615:40558", -- [30]
			"11899:40358:40769", -- [31]
			"7824:41215", -- [32]
			"3310:41140:41142", -- [33]
			"3310:41140", -- [34]
			"7824:41214", -- [35]
			"3615:4312:41246", -- [36]
			"3310:43549:50084", -- [37]
			"3310:43549:50084:53783", -- [38]
			"3310:43549:50084:41861", -- [39]
			"3615:2995:6726:40473", -- [40]
			"11899:39330:39898:41605", -- [41]
			"3615:34927:12616:22931:43073", -- [42]
			"3615:34927:12616:22931:43079", -- [43]
			"3615:34927:12616:22931:43073:43085", -- [44]
			"3310:37005", -- [45]
			"3310:8610:43328", -- [46]
			"3310:43549", -- [47]
			"7824:41215:48275", -- [48]
			"11899:39330:39898:15178:48274", -- [49]
			"7824:41215:48275:48273", -- [50]
			"3310:36728", -- [51]
			"3310:43549:50084:54393", -- [52]
			--["name"] = "Ratchet, Northern Barrens",
			["m"] = 10,
			["f"] = 0,
			["direct"] = "3310:3615:7824:11899",
			["coord"] = 2971382975,
		},
		[43328] = {
			"8610:2995", -- [1]
			"8610:3310", -- [2]
			"8610:3310:3615", -- [3]
			"8610:12616:34943:35140:4312", -- [4]
			"8610:3310:3615:44399", -- [5]
			"8610:2995:6726", -- [6]
			"8610:3310:7824", -- [7]
			"8610:3310:3615:52060:39330:39898", -- [8]
			"8610:11139", -- [9]
			"8610:3310:16227:11899", -- [10]
			"8610:12616:34429:11901", -- [11]
			"8610:12616", -- [12]
			"8610:11139:12740", -- [13]
			"8610:3310:3615:52060:39330:39898:15178", -- [14]
			"8610:3310:3615:52060", -- [15]
			"8610:3310:7824:10583", -- [16]
			"8610:3310:16227", -- [17]
			"8610:12616:22931", -- [18]
			"8610:3310:16227:11899:40358", -- [19]
			"8610:12616:34429", -- [20]
			"8610:12616:34927", -- [21]
			"8610:12616:34943", -- [22]
			"8610:12616:34429:35141", -- [23]
			"8610:12616:34943:35140", -- [24]
			"8610:3310:3615:35139", -- [25]
			"8610:12616:34943:35140:4312:35315", -- [26]
			"8610:2995:35556:35478", -- [27]
			"8610:2995:35556", -- [28]
			"8610:12616:34943:35140:4312:35315:35562", -- [29]
			"8610:3310:7824:39175", -- [30]
			"8610:3310:3615:39340", -- [31]
			"8610:3310:3615:52060:39330", -- [32]
			"8610:2995:40809", -- [33]
			"8610:3310:40558", -- [34]
			"8610:3310:16227:11899:40358:40769", -- [35]
			"8610:3310:7824:41215", -- [36]
			"8610:3310:41140:41142", -- [37]
			"8610:3310:41140", -- [38]
			"8610:3310:7824:41214", -- [39]
			"8610:12616:34943:35140:41246", -- [40]
			"8610:36728:43549:50084", -- [41]
			"8610:36728:43549:50084:53783", -- [42]
			"8610:36728:43549:50084:41861", -- [43]
			"8610:2995:6726:40473", -- [44]
			"8610:3310:3615:52060:39330:39898:41605", -- [45]
			"8610:11139:43085:43073", -- [46]
			"8610:12616:22931:43079", -- [47]
			"8610:11139:43085", -- [48]
			"8610:37005", -- [49]
			"8610:36728:43549", -- [50]
			"8610:3310:7824:41215:48275", -- [51]
			"8610:3310:3615:52060:39330:39898:15178:48274", -- [52]
			"8610:3310:3615:52060:39330:39898:15178:48274:48273", -- [53]
			"8610:36728", -- [54]
			"8610:36728:43549:50084:54393", -- [55]
			--["name"] = "Northern Rocketway, Azshara",
			["m"] = 76,
			["f"] = 0,
			["direct"] = "8610",
			["coord"] = 2857448856,
		},
		[12616] = {
			"34927:3615:2995", -- [1]
			"34943:35140:4312", -- [2]
			"34927:3615:44399", -- [3]
			"34943:35140:4312:6726", -- [4]
			"34927:3615:52060:39330:40358:40769:7824", -- [5]
			"34927:3615:52060:39330:39898", -- [6]
			"36728:8610:11139", -- [7]
			"34927:3615:52060:11899", -- [8]
			"22931:43073:43085:12740", -- [9]
			"34927:3615:52060:39330:39898:15178", -- [10]
			"34927:3615:52060", -- [11]
			"34927:3615:52060:39330:40358:40769:7824:10583", -- [12]
			"34927:3615:16227", -- [13]
			"34927:3615:52060:39330:40358", -- [14]
			"34429:35141", -- [15]
			"34943:35140", -- [16]
			"34943:35140:35139", -- [17]
			"34943:35140:4312:35315", -- [18]
			"34943:35140:4312:35478", -- [19]
			"34927:3615:2995:35556", -- [20]
			"34943:35140:4312:35315:35562", -- [21]
			"34927:3615:52060:39330:40358:40769:7824:39175", -- [22]
			"34927:3615:39340", -- [23]
			"34927:3615:52060:39330", -- [24]
			"34927:3615:2995:40809", -- [25]
			"34927:40558", -- [26]
			"34927:3615:52060:39330:40358:40769", -- [27]
			"34927:3615:52060:39330:40358:40769:7824:41215", -- [28]
			"3310:41140:41142", -- [29]
			"3310:41140", -- [30]
			"34927:3615:52060:39330:40358:40769:7824:41214", -- [31]
			"34943:35140:41246", -- [32]
			"36728:43549:50084", -- [33]
			"36728:43549:50084:53783", -- [34]
			"36728:43549:50084:41861", -- [35]
			"34943:35140:4312:6726:40473", -- [36]
			"34927:3615:52060:39330:39898:41605", -- [37]
			"22931:43073", -- [38]
			"22931:43079", -- [39]
			"22931:43073:43085", -- [40]
			"36728:8610:37005", -- [41]
			"36728:8610:43328", -- [42]
			"36728:43549", -- [43]
			"34927:3615:52060:39330:40358:40769:7824:41215:48275", -- [44]
			"34927:3615:52060:39330:39898:15178:48274", -- [45]
			"34927:3615:52060:39330:39898:15178:48274:48273", -- [46]
			"36728:43549:50084:54393", -- [47]
			--["name"] = "Splintertree Post, Ashenvale",
			["m"] = 63,
			["f"] = 0,
			["direct"] = "3310:3615:8610:11901:22931:34429:34927:34943:36728",
			["coord"] = 3146423777,
		},
		[2995] = {
			"8610:11139", -- [1]
			"3615:34927:12616", -- [2]
			"3615:34927:12616:22931:43073:43085:12740", -- [3]
			"52060:39330:39898:15178", -- [4]
			"7824:10583", -- [5]
			"3615:16227", -- [6]
			"3615:34927:12616:22931", -- [7]
			"52060:39330:40358", -- [8]
			"35139:4312:34429", -- [9]
			"3615:34927", -- [10]
			"35139:35140:34943", -- [11]
			"35139:35141", -- [12]
			"35139:35140", -- [13]
			"35556:35562:35315", -- [14]
			"35556:35478", -- [15]
			"35556:35562", -- [16]
			"7824:39175", -- [17]
			"52060:39330", -- [18]
			"3615:40558", -- [19]
			"52060:39330:40358:40769", -- [20]
			"7824:41215", -- [21]
			"3310:41140:41142", -- [22]
			"3310:41140", -- [23]
			"7824:41214", -- [24]
			"35139:4312:41246", -- [25]
			"3310:43549:50084", -- [26]
			"3310:43549:50084:53783", -- [27]
			"3310:43549:50084:41861", -- [28]
			"6726:40473", -- [29]
			"52060:39330:39898:41605", -- [30]
			"3615:34927:12616:22931:43073", -- [31]
			"3615:34927:12616:22931:43079", -- [32]
			"3615:34927:12616:22931:43073:43085", -- [33]
			"3310:37005", -- [34]
			"8610:43328", -- [35]
			"3310:43549", -- [36]
			"7824:41215:48275", -- [37]
			"52060:39330:39898:15178:48274", -- [38]
			"52060:39330:39898:15178:48274:48273", -- [39]
			"3615:34927:12616:36728", -- [40]
			"3310:43549:50084:54393", -- [41]
			--["name"] = "Thunder Bluff, Mulgore",
			["m"] = 88,
			["f"] = 0,
			["direct"] = "3310:3615:4312:44399:6726:7824:39898:8610:11899:11901:52060:35139:35556:39340:40809",
			["coord"] = 2003861436,
		},
		[43079] = {
			"22931:34429:4312:35139:2995", -- [1]
			"22931:12616:3310", -- [2]
			"22931:12616:34927:3615", -- [3]
			"22931:34429:4312", -- [4]
			"22931:12616:34927:3615:44399", -- [5]
			"22931:34429:4312:6726", -- [6]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824", -- [7]
			"22931:12616:34927:3615:52060:39330:39898", -- [8]
			"22931:12616:36728:8610", -- [9]
			"43073:43085:11139", -- [10]
			"22931:12616:34927:3615:52060:11899", -- [11]
			"22931:34429:11901", -- [12]
			"22931:12616", -- [13]
			"43073:43085:12740", -- [14]
			"22931:12616:34927:3615:52060:39330:39898:15178", -- [15]
			"22931:12616:34927:3615:52060", -- [16]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:10583", -- [17]
			"22931:12616:34927:3615:16227", -- [18]
			"22931:12616:34927:3615:52060:39330:40358", -- [19]
			"22931:34429", -- [20]
			"22931:12616:34927", -- [21]
			"22931:34429:34943", -- [22]
			"22931:34429:35141", -- [23]
			"22931:34429:34943:35140", -- [24]
			"22931:34429:4312:35139", -- [25]
			"22931:34429:4312:35315", -- [26]
			"22931:34429:4312:35478", -- [27]
			"22931:34429:4312:35478:35556", -- [28]
			"22931:34429:4312:35315:35562", -- [29]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:39175", -- [30]
			"22931:12616:34927:3615:39340", -- [31]
			"22931:12616:34927:3615:52060:39330", -- [32]
			"22931:34429:4312:35139:2995:40809", -- [33]
			"22931:12616:34927:40558", -- [34]
			"22931:12616:34927:3615:52060:39330:40358:40769", -- [35]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:41215", -- [36]
			"22931:12616:3310:41140:41142", -- [37]
			"22931:12616:3310:41140", -- [38]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:41214", -- [39]
			"22931:34429:35141:41246", -- [40]
			"22931:12616:36728:43549:50084", -- [41]
			"22931:12616:36728:43549:50084:53783", -- [42]
			"43073:43085:12740:41861", -- [43]
			"22931:34429:4312:6726:40473", -- [44]
			"22931:12616:34927:3615:52060:39330:39898:41605", -- [45]
			"43073:43085", -- [46]
			"22931:12616:36728:8610:37005", -- [47]
			"22931:12616:36728:8610:43328", -- [48]
			"22931:12616:36728:43549", -- [49]
			"22931:12616:34927:3615:52060:39330:40358:40769:7824:41215:48275", -- [50]
			"22931:12616:34927:3615:52060:39330:39898:15178:48274", -- [51]
			"22931:12616:34927:3615:52060:39330:39898:15178:48274:48273", -- [52]
			"22931:12616:36728", -- [53]
			"22931:12616:36728:43549:50084:54393", -- [54]
			--["name"] = "Wildheart Point, Felwood",
			["m"] = 77,
			["f"] = 0,
			["direct"] = "22931:43073",
			["coord"] = 1899863695,
		},
		[41214] = {
			"7824:2995", -- [1]
			"7824:16227:3310", -- [2]
			"7824:3615", -- [3]
			"7824:2995:35139:4312", -- [4]
			"7824:44399", -- [5]
			"7824:39898:41605:40473:6726", -- [6]
			"7824:39898", -- [7]
			"7824:16227:3310:8610", -- [8]
			"7824:16227:3310:11139", -- [9]
			"7824:40769:40358:11899", -- [10]
			"7824:3615:34927:34429:11901", -- [11]
			"7824:3615:34927:12616", -- [12]
			"7824:16227:3310:43549:50084:41861:12740", -- [13]
			"7824:39175:15178", -- [14]
			"7824:40769:40358:11899:52060", -- [15]
			"7824:10583", -- [16]
			"7824:16227", -- [17]
			"7824:3615:34927:12616:22931", -- [18]
			"7824:40769:40358", -- [19]
			"7824:3615:34927:34429", -- [20]
			"7824:3615:34927", -- [21]
			"7824:3615:34927:34943", -- [22]
			"7824:2995:35139:35141", -- [23]
			"7824:2995:35139:35140", -- [24]
			"7824:2995:35139", -- [25]
			"7824:2995:35556:35562:35315", -- [26]
			"7824:2995:35556:35478", -- [27]
			"7824:2995:35556", -- [28]
			"7824:2995:35556:35562", -- [29]
			"7824:39175", -- [30]
			"7824:40769:40358:11899:52060:39340", -- [31]
			"7824:40769:40358:39330", -- [32]
			"7824:2995:40809", -- [33]
			"7824:3615:40558", -- [34]
			"7824:40769", -- [35]
			"7824:16227:3310:41140:41142", -- [36]
			"7824:16227:3310:41140", -- [37]
			"7824:2995:35139:4312:41246", -- [38]
			"7824:16227:3310:43549:50084", -- [39]
			"7824:16227:3310:43549:50084:53783", -- [40]
			"7824:16227:3310:43549:50084:41861", -- [41]
			"7824:39898:41605:40473", -- [42]
			"7824:39898:41605", -- [43]
			"7824:3615:34927:12616:22931:43073", -- [44]
			"7824:3615:34927:12616:22931:43079", -- [45]
			"7824:3615:34927:12616:22931:43073:43085", -- [46]
			"7824:16227:3310:37005", -- [47]
			"7824:16227:3310:8610:43328", -- [48]
			"7824:16227:3310:43549", -- [49]
			"41215:48275", -- [50]
			"41215:48275:48274", -- [51]
			"41215:48275:48273", -- [52]
			"7824:16227:3310:36728", -- [53]
			"7824:16227:3310:43549:50084:54393", -- [54]
			--["name"] = "Bootlegger Outpost, Tanaris",
			["m"] = 71,
			["coord"] = 2397215500,
			["direct"] = "7824:41215",
			["f"] = 0,
		},
		[7824] = {
			"2995:35139:4312", -- [1]
			"39898:41605:40473:6726", -- [2]
			"16227:3310:8610", -- [3]
			"16227:3310:11139", -- [4]
			"3615:34927:34429:11901", -- [5]
			"3615:34927:12616", -- [6]
			"16227:3310:43549:50084:41861:12740", -- [7]
			"40769:40358:11899:52060", -- [8]
			"3615:34927:12616:22931", -- [9]
			"40769:40358", -- [10]
			"3615:34927:34429", -- [11]
			"3615:34927", -- [12]
			"3615:34927:34943", -- [13]
			"2995:35139:35141", -- [14]
			"2995:35139:35140", -- [15]
			"2995:35139", -- [16]
			"2995:35556:35562:35315", -- [17]
			"2995:35556:35478", -- [18]
			"2995:35556", -- [19]
			"2995:35556:35562", -- [20]
			"40769:40358:11899:52060:39340", -- [21]
			"40769:40358:39330", -- [22]
			"2995:40809", -- [23]
			"3615:40558", -- [24]
			"16227:3310:41140:41142", -- [25]
			"16227:3310:41140", -- [26]
			"2995:35139:4312:41246", -- [27]
			"16227:3310:43549:50084", -- [28]
			"16227:3310:43549:50084:53783", -- [29]
			"16227:3310:43549:50084:41861", -- [30]
			"39898:41605:40473", -- [31]
			"39898:41605", -- [32]
			"3615:34927:12616:22931:43073", -- [33]
			"3615:34927:12616:22931:43079", -- [34]
			"3615:34927:12616:22931:43073:43085", -- [35]
			"16227:3310:37005", -- [36]
			"16227:3310:8610:43328", -- [37]
			"16227:3310:43549", -- [38]
			"41215:48275", -- [39]
			"39175:15178:48274", -- [40]
			"41215:48275:48273", -- [41]
			"16227:3310:36728", -- [42]
			"16227:3310:43549:50084:54393", -- [43]
			--["name"] = "Gadgetzan, Tanaris",
			["m"] = 71,
			["coord"] = 2233812594,
			["direct"] = "2995:3310:3615:44399:39898:11899:15178:10583:16227:39175:40769:41215:41214",
			["f"] = 0,
		},
		[43549] = {
			"3310:3615:2995", -- [1]
			"3310:3615", -- [2]
			"36728:12616:34943:35140:4312", -- [3]
			"3310:3615:44399", -- [4]
			"36728:12616:34943:35140:4312:6726", -- [5]
			"3310:7824", -- [6]
			"3310:3615:52060:39330:39898", -- [7]
			"36728:8610", -- [8]
			"50084:41861:11139", -- [9]
			"3310:16227:11899", -- [10]
			"36728:12616:34429:11901", -- [11]
			"36728:12616", -- [12]
			"50084:41861:12740", -- [13]
			"3310:3615:52060:39330:39898:15178", -- [14]
			"3310:3615:52060", -- [15]
			"3310:7824:10583", -- [16]
			"3310:16227", -- [17]
			"36728:12616:22931", -- [18]
			"3310:16227:11899:40358", -- [19]
			"36728:12616:34429", -- [20]
			"36728:12616:34927", -- [21]
			"36728:12616:34943", -- [22]
			"36728:12616:34429:35141", -- [23]
			"36728:12616:34943:35140", -- [24]
			"36728:12616:34943:35140:35139", -- [25]
			"36728:12616:34943:35140:4312:35315", -- [26]
			"36728:12616:34943:35140:4312:35478", -- [27]
			"3310:3615:2995:35556", -- [28]
			"36728:12616:34943:35140:4312:35315:35562", -- [29]
			"3310:7824:39175", -- [30]
			"3310:3615:39340", -- [31]
			"3310:3615:52060:39330", -- [32]
			"3310:3615:2995:40809", -- [33]
			"3310:40558", -- [34]
			"3310:16227:11899:40358:40769", -- [35]
			"3310:7824:41215", -- [36]
			"3310:41140:41142", -- [37]
			"3310:41140", -- [38]
			"3310:7824:41214", -- [39]
			"36728:12616:34943:35140:41246", -- [40]
			"50084:53783", -- [41]
			"50084:41861", -- [42]
			"36728:12616:34943:35140:4312:6726:40473", -- [43]
			"3310:3615:52060:39330:39898:41605", -- [44]
			"36728:12616:22931:43073", -- [45]
			"36728:12616:22931:43079", -- [46]
			"50084:41861:12740:43085", -- [47]
			"36728:8610:37005", -- [48]
			"36728:8610:43328", -- [49]
			"3310:7824:41215:48275", -- [50]
			"3310:3615:52060:39330:39898:15178:48274", -- [51]
			"3310:3615:52060:39330:39898:15178:48274:48273", -- [52]
			"50084:54393", -- [53]
			--["name"] = "Gates of Sothann, Hyjal",
			["m"] = 198,
			["f"] = 0,
			["direct"] = "3310:50084:36728",
			["coord"] = 3072770348,
		},
		[39330] = {
			"52060:2995", -- [1]
			"11899:16227:3310", -- [2]
			"52060:3615", -- [3]
			"52060:3615:4312", -- [4]
			"39898:41605:40473:6726", -- [5]
			"40358:40769:7824", -- [6]
			"52060:3615:8610", -- [7]
			"11899:16227:3310:11139", -- [8]
			"52060:3615:34927:34429:11901", -- [9]
			"52060:3615:34927:12616", -- [10]
			"52060:3615:34927:12616:22931:43073:43085:12740", -- [11]
			"39898:15178", -- [12]
			"40358:40769:7824:10583", -- [13]
			"11899:16227", -- [14]
			"52060:3615:34927:12616:22931", -- [15]
			"52060:3615:34927:34429", -- [16]
			"52060:3615:34927", -- [17]
			"52060:3615:34927:34943", -- [18]
			"52060:3615:4312:35141", -- [19]
			"52060:2995:35139:35140", -- [20]
			"52060:2995:35139", -- [21]
			"52060:2995:35556:35562:35315", -- [22]
			"52060:2995:35556:35478", -- [23]
			"52060:2995:35556", -- [24]
			"52060:2995:35556:35562", -- [25]
			"40358:40769:7824:39175", -- [26]
			"52060:2995:40809", -- [27]
			"52060:3615:40558", -- [28]
			"40358:40769", -- [29]
			"40358:40769:7824:41215", -- [30]
			"11899:16227:3310:41140:41142", -- [31]
			"11899:16227:3310:41140", -- [32]
			"40358:40769:7824:41214", -- [33]
			"52060:3615:4312:41246", -- [34]
			"11899:16227:3310:43549:50084", -- [35]
			"11899:16227:3310:43549:50084:53783", -- [36]
			"11899:16227:3310:43549:50084:41861", -- [37]
			"39898:41605:40473", -- [38]
			"39898:41605", -- [39]
			"52060:3615:34927:12616:22931:43073", -- [40]
			"52060:3615:34927:12616:22931:43079", -- [41]
			"52060:3615:34927:12616:22931:43073:43085", -- [42]
			"11899:16227:3310:37005", -- [43]
			"52060:3615:8610:43328", -- [44]
			"11899:16227:3310:43549", -- [45]
			"40358:40769:7824:41215:48275", -- [46]
			"39898:15178:48274", -- [47]
			"39898:15178:48274:48273", -- [48]
			"52060:3615:34927:12616:36728", -- [49]
			"11899:16227:3310:43549:50084:54393", -- [50]
			--["name"] = "Desolation Hold, Southern Barrens",
			["m"] = 199,
			["f"] = 0,
			["direct"] = "44399:39898:11899:52060:40358:39340",
			["coord"] = 1769714932,
		},
		[53783] = {
			"50084:43549:3310:3615:2995", -- [1]
			"50084:43549:3310", -- [2]
			"50084:43549:3310:3615", -- [3]
			"50084:43549:36728:12616:34943:35140:4312", -- [4]
			"50084:43549:3310:3615:44399", -- [5]
			"50084:43549:36728:12616:34943:35140:4312:6726", -- [6]
			"50084:43549:3310:7824", -- [7]
			"50084:43549:3310:3615:52060:39330:39898", -- [8]
			"50084:43549:36728:8610", -- [9]
			"41861:11139", -- [10]
			"50084:43549:3310:16227:11899", -- [11]
			"50084:43549:36728:12616:34429:11901", -- [12]
			"50084:43549:36728:12616", -- [13]
			"41861:12740", -- [14]
			"50084:43549:3310:3615:52060:39330:39898:15178", -- [15]
			"50084:43549:3310:3615:52060", -- [16]
			"50084:43549:3310:7824:10583", -- [17]
			"50084:43549:3310:16227", -- [18]
			"50084:43549:36728:12616:22931", -- [19]
			"50084:43549:3310:16227:11899:40358", -- [20]
			"50084:43549:36728:12616:34429", -- [21]
			"50084:43549:36728:12616:34927", -- [22]
			"50084:43549:36728:12616:34943", -- [23]
			"50084:43549:36728:12616:34429:35141", -- [24]
			"50084:43549:36728:12616:34943:35140", -- [25]
			"50084:43549:36728:12616:34943:35140:35139", -- [26]
			"50084:43549:36728:12616:34943:35140:4312:35315", -- [27]
			"50084:43549:36728:12616:34943:35140:4312:35478", -- [28]
			"50084:43549:3310:3615:2995:35556", -- [29]
			"50084:43549:36728:12616:34943:35140:4312:35315:35562", -- [30]
			"50084:43549:3310:7824:39175", -- [31]
			"50084:43549:3310:3615:39340", -- [32]
			"50084:43549:3310:3615:52060:39330", -- [33]
			"50084:43549:3310:3615:2995:40809", -- [34]
			"50084:43549:3310:40558", -- [35]
			"50084:43549:3310:16227:11899:40358:40769", -- [36]
			"50084:43549:3310:7824:41215", -- [37]
			"50084:43549:3310:41140:41142", -- [38]
			"50084:43549:3310:41140", -- [39]
			"50084:43549:3310:7824:41214", -- [40]
			"50084:43549:36728:12616:34943:35140:41246", -- [41]
			"50084:43549:36728:12616:34943:35140:4312:6726:40473", -- [42]
			"50084:43549:3310:3615:52060:39330:39898:41605", -- [43]
			"41861:12740:43085:43073", -- [44]
			"50084:43549:36728:12616:22931:43079", -- [45]
			"41861:12740:43085", -- [46]
			"50084:43549:36728:8610:37005", -- [47]
			"50084:43549:36728:8610:43328", -- [48]
			"50084:43549", -- [49]
			"50084:43549:3310:7824:41215:48275", -- [50]
			"50084:43549:3310:3615:52060:39330:39898:15178:48274", -- [51]
			"50084:43549:3310:3615:52060:39330:39898:15178:48274:48273", -- [52]
			"50084:43549:36728", -- [53]
			"50084:54393", -- [54]
			--["name"] = "Grove of Aessina, Hyjal",
			["m"] = 198,
			["f"] = 0,
			["direct"] = "50084:41861",
			["coord"] = 841047383,
		},
	}, -- [1]
	{
		[43114] = {
			"43121:6026:43086:13177:2861:2851:2389:2226", -- [1]
			"43121:6026:43086:13177:2861:4551", -- [2]
			"43121:6026:43086:13177:2861:2851:2389", -- [3]
			"43121:6026:43086:13177:2861:2851", -- [4]
			"2858:1387", -- [5]
			"43121:6026:43086:13177:2861", -- [6]
			"43121:6026", -- [7]
			"43121:6026:43086:13177:2861:44407:12636", -- [8]
			"43121:6026:43086:13177", -- [9]
			"43121:6026:43086:13177:3305", -- [10]
			"43121:6026:43086:13177:2861:2851:4314", -- [11]
			"43121:6026:43086:13177:2861:44407:12636:16189:16192", -- [12]
			"43121:6026:43086:13177:2861:44407:12636:16189", -- [13]
			"43121:6026:43086:13177:2861:2851:43573:37888:44232:44233", -- [14]
			"43121:6026:43086:13177:2861:44407:12636:44230:28621", -- [15]
			"43121:6026:43086:13177:2861:44407:12636:44230", -- [16]
			"43121:6026:43086:13177:2861:2851:43573:37888:44232", -- [17]
			"43121:6026:43086:13177:2861:44407:12636:24851", -- [18]
			"43121:6026:43086:13177:2861:44407:12636:24851:26560", -- [19]
			"43121:6026:43086:13177:2861:2851:43573:37888", -- [20]
			"43121:6026:43086:13177:2861:2851:43573:46004:37915", -- [21]
			"43121:6026:43086:13177:2861:2851:43573:46004:37915:43124", -- [22]
			"2858:43053", -- [23]
			"2858:43053:43052", -- [24]
			"43121:6026:43086", -- [25]
			"43121:6026:43086:13177:2861:2851:43104", -- [26]
			"43121:6026:43086:13177:2861:2851:43573", -- [27]
			"43121:6026:43086:13177:2861:44407:12636:16189:44036", -- [28]
			"43121:6026:43086:13177:2861:2851:43573:37888:44232:44231", -- [29]
			"43121:6026:43086:13177:2861:44407:12636:16189:16192:44244", -- [30]
			"43121:6026:43086:13177:2861:44408", -- [31]
			"43121:6026:43086:13177:2861:44407", -- [32]
			"43121:6026:43086:13177:2861:2851:43573:46004:37915:44825", -- [33]
			"43121:6026:43086:13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [34]
			"43121:6026:43086:13177:2861:2851:43573:46004", -- [35]
			"43121:6026:43086:13177:2861:2851:43573:46004:46011", -- [36]
			"43121:6026:43086:13177:2861:2851:43104:47661:47644:47655:46552", -- [37]
			"43121:6026:43086:13177:2861:47121:47133:47116", -- [38]
			"43121:6026:43086:13177:2861:47121:47133", -- [39]
			"43121:6026:43086:13177:2861:47121", -- [40]
			"43121:6026:43086:13177:2861:47121:47133:47156", -- [41]
			"43121:6026:43086:13177:2861:47174:47061", -- [42]
			"43121:6026:43086:13177:2861:47174", -- [43]
			"43121:6026:43086:13177:2861:2851:43104:47661:47644", -- [44]
			"43121:6026:43086:13177:2861:2851:43104:47661:47644:47655", -- [45]
			"43121:6026:43086:13177:2861:2851:43104:47661", -- [46]
			"43121:6026:43086:13177:2861:2851:2389:47665", -- [47]
			"43121:6026:43086:13177:2861:2851:43573:46004:46011:47875", -- [48]
			"43121:6026:43086:13177:48321:48318:47927", -- [49]
			"43121:6026:43086:13177:48321:48318", -- [50]
			"43121:6026:43086:13177:48321", -- [51]
			"43121:6026:43086:13177:2861:2851:43573:46004:37915:44825:50463", -- [52]
			["direct"] = "2858:43121",
			["coord"] = 2189605479,
			["m"] = 17,
			["f"] = 0,
		},
		[13177] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"1387:2858", -- [5]
			"2861:44407:12636", -- [6]
			"2861:2851:4314", -- [7]
			"2861:44407:12636:16189:16192", -- [8]
			"2861:44407:12636:16189", -- [9]
			"2861:2851:43573:37888:44232:44233", -- [10]
			"2861:44407:12636:44230:28621", -- [11]
			"2861:44407:12636:44230", -- [12]
			"2861:2851:43573:37888:44232", -- [13]
			"2861:44407:12636:24851", -- [14]
			"2861:44407:12636:24851:26560", -- [15]
			"2861:2851:43573:37888", -- [16]
			"2861:2851:43573:46004:37915", -- [17]
			"2861:2851:43573:46004:37915:43124", -- [18]
			"1387:43053", -- [19]
			"1387:43052", -- [20]
			"2861:2851:43104", -- [21]
			"2861:2851:43573", -- [22]
			"2861:44407:12636:16189:44036", -- [23]
			"2861:2851:43573:37888:44232:44231", -- [24]
			"2861:44407:12636:16189:16192:44244", -- [25]
			"2861:44408", -- [26]
			"2861:44407", -- [27]
			"2861:2851:43573:46004:37915:44825", -- [28]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [29]
			"2861:2851:43573:46004", -- [30]
			"2861:2851:43573:46004:46011", -- [31]
			"2861:2851:43104:47661:47644:47655:46552", -- [32]
			"2861:47121:47133:47116", -- [33]
			"2861:47121:47133", -- [34]
			"2861:47121", -- [35]
			"2861:47121:47133:47156", -- [36]
			"2861:47174:47061", -- [37]
			"2861:47174", -- [38]
			"2861:2851:43104:47661:47644", -- [39]
			"2861:2851:43104:47661:47644:47655", -- [40]
			"2861:2851:43104:47661", -- [41]
			"2861:2851:2389:47665", -- [42]
			"2861:2851:43573:46004:46011:47875", -- [43]
			"48321:48318:47927", -- [44]
			"48321:48318", -- [45]
			"2861:2851:43573:46004:37915:44825:50463", -- [46]
			"43086:6026:85734", -- [47]
			--["name"] = "Flame Crest, Burning Steppes",
			["m"] = 36,
			["f"] = 0,
			["direct"] = "1387:2861:6026:3305:43086:48321",
			["coord"] = 2330279398,
		},
		[28621] = {
			"44232:37888:37915:44825:2226", -- [1]
			"44232:37888:4551", -- [2]
			"44232:37888:2389", -- [3]
			"44232:37888:43573:2851", -- [4]
			"44230:12636:44407:2861:2858", -- [5]
			"44230:12636:44407:2861:1387", -- [6]
			"44230:12636:44407:2861", -- [7]
			"44230:12636:44407:2861:13177:43086:6026", -- [8]
			"44230:12636", -- [9]
			"44230:12636:44407:2861:13177", -- [10]
			"44230:12636:44407:2861:3305", -- [11]
			"44230:12636:4314", -- [12]
			"44230:12636:16189:16192", -- [13]
			"44230:12636:16189", -- [14]
			"44230:12636:24851", -- [15]
			"44230:12636:24851:26560", -- [16]
			"44232:37888", -- [17]
			"44232:37888:37915", -- [18]
			"44232:37888:37915:43124", -- [19]
			"44230:12636:44407:2861:1387:43053", -- [20]
			"44230:12636:44407:2861:1387:43052", -- [21]
			"44230:12636:44407:2861:13177:43086", -- [22]
			"44232:37888:2389:43104", -- [23]
			"44232:37888:43573", -- [24]
			"44230:12636:16189:44036", -- [25]
			"44230:44231", -- [26]
			"44230:12636:16189:16192:44244", -- [27]
			"44230:12636:44407:44408", -- [28]
			"44230:12636:44407", -- [29]
			"44232:37888:37915:44825", -- [30]
			"44232:37888:37915:44825:2226:46552:45479", -- [31]
			"44232:37888:46011:46004", -- [32]
			"44232:37888:46011", -- [33]
			"44232:37888:37915:44825:2226:46552", -- [34]
			"44232:37888:43573:2851:47121:47133:47116", -- [35]
			"44232:37888:43573:2851:47121:47133", -- [36]
			"44232:37888:43573:2851:47121", -- [37]
			"44232:37888:43573:2851:47121:47133:47156", -- [38]
			"44232:37888:43573:2851:47121:47133:47156:47061", -- [39]
			"44232:37888:43573:2851:47174", -- [40]
			"44232:37888:2389:47644", -- [41]
			"44232:37888:2389:47644:47655", -- [42]
			"44232:37888:2389:47661", -- [43]
			"44232:37888:37915:47665", -- [44]
			"44233:47875", -- [45]
			"44230:12636:44407:2861:3305:47927", -- [46]
			"44230:12636:44407:2861:13177:48321:48318", -- [47]
			"44230:12636:44407:2861:13177:48321", -- [48]
			"44232:37888:37915:44825:50463", -- [49]
			"44230:12636:44407:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Northpass Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 2202547784,
			["direct"] = "44233:44230:44232",
			["f"] = 0,
		},
		[47156] = {
			"47133:47121:2851:2389:2226", -- [1]
			"47133:47121:2851:43573:46004:37915:4551", -- [2]
			"47133:47121:2851:2389", -- [3]
			"47133:47121:2851", -- [4]
			"47133:47121:2861:2858", -- [5]
			"47133:47121:2861:1387", -- [6]
			"47133:47121:2861", -- [7]
			"47133:47121:2861:13177:43086:6026", -- [8]
			"47133:47121:2851:43573:37888:12636", -- [9]
			"47133:47121:2861:13177", -- [10]
			"47133:47121:2861:3305", -- [11]
			"47133:47121:2851:4314", -- [12]
			"47133:47121:2851:43573:37888:12636:16189:16192", -- [13]
			"47133:47121:2851:43573:37888:12636:16189", -- [14]
			"47133:47121:2851:43573:37888:44232:44233", -- [15]
			"47133:47121:2851:43573:37888:44232:28621", -- [16]
			"47133:47121:2851:43573:37888:44232:44231:44230", -- [17]
			"47133:47121:2851:43573:37888:44232", -- [18]
			"47133:47121:2851:43573:37888:12636:24851", -- [19]
			"47133:47121:2851:43573:37888:12636:24851:26560", -- [20]
			"47133:47121:2851:43573:37888", -- [21]
			"47133:47121:2851:43573:46004:37915", -- [22]
			"47133:47121:2851:43573:46004:37915:43124", -- [23]
			"47133:47121:2861:1387:43053", -- [24]
			"47133:47121:2861:1387:43052", -- [25]
			"47133:47121:2861:13177:43086", -- [26]
			"47133:47121:2851:43104", -- [27]
			"47133:47121:2851:43573", -- [28]
			"47133:47121:2851:43573:37888:12636:16189:44036", -- [29]
			"47133:47121:2851:43573:37888:44232:44231", -- [30]
			"47133:47121:2851:43573:37888:12636:16189:16192:44244", -- [31]
			"47133:47121:2861:44408", -- [32]
			"47133:47121:2861:44407", -- [33]
			"47133:47121:2851:43573:46004:37915:44825", -- [34]
			"47133:47121:2851:43104:47661:47644:47655:46552:45479", -- [35]
			"47133:47121:2851:43573:46004", -- [36]
			"47133:47121:2851:43573:46004:46011", -- [37]
			"47133:47121:2851:43104:47661:47644:47655:46552", -- [38]
			"47133:47121", -- [39]
			"47133:47121:2851:43104:47661:47644", -- [40]
			"47133:47121:2851:43104:47661:47644:47655", -- [41]
			"47133:47121:2851:43104:47661", -- [42]
			"47133:47121:2851:2389:47665", -- [43]
			"47133:47121:2851:43573:46004:46011:47875", -- [44]
			"47133:47121:2861:3305:47927", -- [45]
			"47133:47121:2861:13177:48321:48318", -- [46]
			"47133:47121:2861:13177:48321", -- [47]
			"47133:47121:2851:43573:46004:37915:44825:50463", -- [48]
			"47133:47121:2861:13177:43086:6026:85734", -- [49]
			--["name"] = "Bloodgulch, Twilight Highlands",
			["m"] = 241,
			["f"] = 0,
			["direct"] = "47116:47133:47061:47174",
			["coord"] = 2322885606,
		},
		[43573] = {
			"2389:2226", -- [1]
			"46004:37915:4551", -- [2]
			"2851:2861:2858", -- [3]
			"2851:2861:1387", -- [4]
			"2851:2861", -- [5]
			"2851:2861:13177:43086:6026", -- [6]
			"37888:12636", -- [7]
			"2851:2861:13177", -- [8]
			"2851:2861:3305", -- [9]
			"37888:12636:16189:16192", -- [10]
			"37888:12636:16189", -- [11]
			"37888:44232:44233", -- [12]
			"37888:44232:28621", -- [13]
			"37888:44232:44231:44230", -- [14]
			"37888:44232", -- [15]
			"37888:12636:24851", -- [16]
			"37888:12636:24851:26560", -- [17]
			"46004:37915", -- [18]
			"46004:37915:43124", -- [19]
			"2851:2861:1387:43053", -- [20]
			"2851:2861:1387:43052", -- [21]
			"2851:2861:13177:43086", -- [22]
			"2851:43104", -- [23]
			"37888:12636:16189:44036", -- [24]
			"37888:44232:44231", -- [25]
			"37888:12636:16189:16192:44244", -- [26]
			"2851:2861:44408", -- [27]
			"2851:2861:44407", -- [28]
			"46004:37915:44825", -- [29]
			"2389:47644:47655:46552:45479", -- [30]
			"46004:46011", -- [31]
			"2389:47644:47655:46552", -- [32]
			"2851:47121:47133:47116", -- [33]
			"2851:47121:47133", -- [34]
			"2851:47121", -- [35]
			"2851:47121:47133:47156", -- [36]
			"2851:47121:47133:47156:47061", -- [37]
			"2851:47174", -- [38]
			"2389:47644", -- [39]
			"2389:47644:47655", -- [40]
			"2389:47661", -- [41]
			"2389:47665", -- [42]
			"46004:46011:47875", -- [43]
			"2851:2861:3305:47927", -- [44]
			"2851:2861:13177:48321:48318", -- [45]
			"2851:2861:13177:48321", -- [46]
			"46004:37915:44825:50463", -- [47]
			"2851:2861:13177:43086:6026:85734", -- [48]
			--["name"] = "Hiri'watha Research Station, The Hinterlands",
			["m"] = 26,
			["f"] = 0,
			["direct"] = "2389:2851:4314:37888:46004",
			["coord"] = 1390908635,
		},
		[43124] = {
			"44825:2226", -- [1]
			"37915:2389", -- [2]
			"37915:46004:43573:2851", -- [3]
			"37915:46004:43573:2851:2861:2858", -- [4]
			"37915:46004:43573:2851:2861:1387", -- [5]
			"37915:46004:43573:2851:2861", -- [6]
			"37915:46004:43573:2851:2861:13177:43086:6026", -- [7]
			"37915:37888:12636", -- [8]
			"37915:46004:43573:2851:2861:13177", -- [9]
			"37915:46004:43573:2851:2861:3305", -- [10]
			"37915:46004:43573:4314", -- [11]
			"37915:37888:12636:16189:16192", -- [12]
			"37915:37888:12636:16189", -- [13]
			"37915:46004:46011:47875:44233", -- [14]
			"37915:37888:44232:28621", -- [15]
			"37915:37888:44232:44231:44230", -- [16]
			"37915:37888:44232", -- [17]
			"37915:37888:12636:24851", -- [18]
			"37915:37888:12636:24851:26560", -- [19]
			"37915:37888", -- [20]
			"37915:46004:43573:2851:2861:1387:43053", -- [21]
			"37915:46004:43573:2851:2861:1387:43052", -- [22]
			"37915:46004:43573:2851:2861:13177:43086", -- [23]
			"37915:2389:43104", -- [24]
			"37915:46004:43573", -- [25]
			"37915:37888:12636:16189:44036", -- [26]
			"37915:37888:44232:44231", -- [27]
			"37915:37888:12636:16189:16192:44244", -- [28]
			"37915:46004:43573:2851:2861:44408", -- [29]
			"37915:46004:43573:2851:2861:44407", -- [30]
			"44825:2226:46552:45479", -- [31]
			"37915:46004", -- [32]
			"37915:46004:46011", -- [33]
			"44825:2226:46552", -- [34]
			"37915:46004:43573:2851:47121:47133:47116", -- [35]
			"37915:46004:43573:2851:47121:47133", -- [36]
			"37915:46004:43573:2851:47121", -- [37]
			"37915:46004:43573:2851:47121:47133:47156", -- [38]
			"37915:46004:43573:2851:47121:47133:47156:47061", -- [39]
			"37915:46004:43573:2851:47174", -- [40]
			"37915:2389:47644", -- [41]
			"44825:2226:46552:47655", -- [42]
			"37915:2389:47661", -- [43]
			"37915:47665", -- [44]
			"37915:46004:46011:47875", -- [45]
			"37915:46004:43573:2851:2861:3305:47927", -- [46]
			"37915:46004:43573:2851:2861:13177:48321:48318", -- [47]
			"37915:46004:43573:2851:2861:13177:48321", -- [48]
			"44825:50463", -- [49]
			"37915:46004:43573:2851:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Brill, Tirisfal Glades",
			["m"] = 18,
			["f"] = 0,
			["direct"] = "4551:37915:44825",
			["coord"] = 2529461497,
		},
		[37915] = {
			"44825:2226", -- [1]
			"46004:43573:2851", -- [2]
			"46004:43573:2851:2861:2858", -- [3]
			"46004:43573:2851:2861:1387", -- [4]
			"46004:43573:2851:2861", -- [5]
			"46004:43573:2851:2861:13177:43086:6026", -- [6]
			"37888:12636", -- [7]
			"46004:43573:2851:2861:13177", -- [8]
			"46004:43573:2851:2861:3305", -- [9]
			"46004:43573:4314", -- [10]
			"37888:12636:16189:16192", -- [11]
			"37888:12636:16189", -- [12]
			"46004:46011:47875:44233", -- [13]
			"37888:44232:28621", -- [14]
			"37888:44232:44231:44230", -- [15]
			"37888:44232", -- [16]
			"37888:12636:24851", -- [17]
			"37888:12636:24851:26560", -- [18]
			"46004:43573:2851:2861:1387:43053", -- [19]
			"46004:43573:2851:2861:1387:43052", -- [20]
			"46004:43573:2851:2861:13177:43086", -- [21]
			"2389:43104", -- [22]
			"46004:43573", -- [23]
			"37888:12636:16189:44036", -- [24]
			"37888:44232:44231", -- [25]
			"37888:12636:16189:16192:44244", -- [26]
			"46004:43573:2851:2861:44408", -- [27]
			"46004:43573:2851:2861:44407", -- [28]
			"44825:2226:46552:45479", -- [29]
			"46004:46011", -- [30]
			"44825:2226:46552", -- [31]
			"46004:43573:2851:47121:47133:47116", -- [32]
			"46004:43573:2851:47121:47133", -- [33]
			"46004:43573:2851:47121", -- [34]
			"46004:43573:2851:47121:47133:47156", -- [35]
			"46004:43573:2851:47121:47133:47156:47061", -- [36]
			"46004:43573:2851:47174", -- [37]
			"2389:47644", -- [38]
			"2389:47644:47655", -- [39]
			"2389:47661", -- [40]
			"46004:46011:47875", -- [41]
			"46004:43573:2851:2861:3305:47927", -- [42]
			"46004:43573:2851:2861:13177:48321:48318", -- [43]
			"46004:43573:2851:2861:13177:48321", -- [44]
			"44825:50463", -- [45]
			"46004:43573:2851:2861:13177:43086:6026:85734", -- [46]
			--["name"] = "The Bulwark, Tirisfal",
			["m"] = 18,
			["f"] = 0,
			["direct"] = "4551:2389:37888:43124:44825:46004:47665",
			["coord"] = 3587421025,
		},
		[44408] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"2861:2858", -- [5]
			"2861:1387", -- [6]
			"2861:13177:43086:6026", -- [7]
			"44407:12636", -- [8]
			"2861:13177", -- [9]
			"2861:3305", -- [10]
			"2861:2851:4314", -- [11]
			"44407:12636:16189:16192", -- [12]
			"44407:12636:16189", -- [13]
			"44407:12636:44230:44233", -- [14]
			"44407:12636:44230:28621", -- [15]
			"44407:12636:44230", -- [16]
			"44407:12636:44231:44232", -- [17]
			"44407:12636:24851", -- [18]
			"44407:12636:24851:26560", -- [19]
			"2861:2851:43573:37888", -- [20]
			"2861:2851:43573:46004:37915", -- [21]
			"2861:2851:43573:46004:37915:43124", -- [22]
			"2861:1387:43053", -- [23]
			"2861:1387:43052", -- [24]
			"2861:13177:43086", -- [25]
			"2861:2851:43104", -- [26]
			"2861:2851:43573", -- [27]
			"44407:12636:16189:44036", -- [28]
			"44407:12636:44231", -- [29]
			"44407:12636:16189:16192:44244", -- [30]
			"2861:2851:43573:46004:37915:44825", -- [31]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [32]
			"2861:2851:43573:46004", -- [33]
			"2861:2851:43573:46004:46011", -- [34]
			"2861:2851:43104:47661:47644:47655:46552", -- [35]
			"2861:47121:47133:47116", -- [36]
			"2861:47121:47133", -- [37]
			"2861:47121", -- [38]
			"2861:47121:47133:47156", -- [39]
			"2861:47174:47061", -- [40]
			"2861:47174", -- [41]
			"2861:2851:43104:47661:47644", -- [42]
			"2861:2851:43104:47661:47644:47655", -- [43]
			"2861:2851:43104:47661", -- [44]
			"2861:2851:2389:47665", -- [45]
			"2861:2851:43573:46004:46011:47875", -- [46]
			"2861:3305:47927", -- [47]
			"2861:13177:48321:48318", -- [48]
			"2861:13177:48321", -- [49]
			"2861:2851:43573:46004:37915:44825:50463", -- [50]
			"2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Bloodwatcher Point, Badlands",
			["m"] = 15,
			["f"] = 0,
			["direct"] = "2861:44407",
			["coord"] = 2250867271,
		},
		[24851] = {
			"12636:37888:37915:44825:2226", -- [1]
			"12636:37888:4551", -- [2]
			"12636:37888:2389", -- [3]
			"12636:4314:2851", -- [4]
			"12636:44407:2861:2858", -- [5]
			"12636:44407:2861:1387", -- [6]
			"12636:44407:2861", -- [7]
			"12636:44407:2861:13177:43086:6026", -- [8]
			"12636:44407:2861:13177", -- [9]
			"12636:44407:2861:3305", -- [10]
			"12636:4314", -- [11]
			"16189:16192", -- [12]
			"12636:44230:44233", -- [13]
			"12636:44230:28621", -- [14]
			"12636:44230", -- [15]
			"12636:44231:44232", -- [16]
			"12636:37888", -- [17]
			"12636:37888:37915", -- [18]
			"12636:37888:37915:43124", -- [19]
			"12636:44407:2861:1387:43053", -- [20]
			"12636:44407:2861:1387:43052", -- [21]
			"12636:44407:2861:13177:43086", -- [22]
			"12636:37888:2389:43104", -- [23]
			"12636:37888:43573", -- [24]
			"16189:44036", -- [25]
			"12636:44231", -- [26]
			"16189:16192:44244", -- [27]
			"12636:44407:44408", -- [28]
			"12636:44407", -- [29]
			"12636:37888:37915:44825", -- [30]
			"12636:37888:37915:44825:2226:46552:45479", -- [31]
			"12636:37888:46011:46004", -- [32]
			"12636:37888:46011", -- [33]
			"12636:37888:37915:44825:2226:46552", -- [34]
			"12636:4314:2851:47121:47133:47116", -- [35]
			"12636:4314:2851:47121:47133", -- [36]
			"12636:4314:2851:47121", -- [37]
			"12636:4314:2851:47121:47133:47156", -- [38]
			"12636:4314:2851:47121:47133:47156:47061", -- [39]
			"12636:4314:2851:47174", -- [40]
			"12636:37888:2389:47644", -- [41]
			"12636:37888:2389:47644:47655", -- [42]
			"12636:37888:2389:47661", -- [43]
			"12636:37888:37915:47665", -- [44]
			"12636:44230:44233:47875", -- [45]
			"12636:44407:2861:3305:47927", -- [46]
			"12636:44407:2861:13177:48321:48318", -- [47]
			"12636:44407:2861:13177:48321", -- [48]
			"12636:37888:37915:44825:50463", -- [49]
			"12636:44407:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Zul'Aman, Ghostlands",
			["m"] = 95,
			["coord"] = 3207244762,
			["direct"] = "12636:16189:26560",
			["f"] = 0,
		},
		[6026] = {
			"43086:13177:2861:2851:2389:2226", -- [1]
			"43086:13177:2861:4551", -- [2]
			"43086:13177:2861:2851:2389", -- [3]
			"43086:13177:2861:2851", -- [4]
			"43086:13177:2861:44407:12636", -- [5]
			"43086:13177:3305", -- [6]
			"43086:13177:2861:2851:4314", -- [7]
			"43086:13177:2861:44407:12636:16189:16192", -- [8]
			"43086:13177:2861:44407:12636:16189", -- [9]
			"43086:13177:2861:2851:43573:37888:44232:44233", -- [10]
			"43086:13177:2861:44407:12636:44230:28621", -- [11]
			"43086:13177:2861:44407:12636:44230", -- [12]
			"43086:13177:2861:2851:43573:37888:44232", -- [13]
			"43086:13177:2861:44407:12636:24851", -- [14]
			"43086:13177:2861:44407:12636:24851:26560", -- [15]
			"43086:13177:2861:2851:43573:37888", -- [16]
			"43086:13177:2861:2851:43573:46004:37915", -- [17]
			"43086:13177:2861:2851:43573:46004:37915:43124", -- [18]
			"1387:43053", -- [19]
			"85734:43052", -- [20]
			"43086:13177:2861:2851:43104", -- [21]
			"43086:13177:2861:2851:43573", -- [22]
			"43086:13177:2861:44407:12636:16189:44036", -- [23]
			"43086:13177:2861:2851:43573:37888:44232:44231", -- [24]
			"43086:13177:2861:44407:12636:16189:16192:44244", -- [25]
			"43086:13177:2861:44408", -- [26]
			"43086:13177:2861:44407", -- [27]
			"43086:13177:2861:2851:43573:46004:37915:44825", -- [28]
			"43086:13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [29]
			"43086:13177:2861:2851:43573:46004", -- [30]
			"43086:13177:2861:2851:43573:46004:46011", -- [31]
			"43086:13177:2861:2851:43104:47661:47644:47655:46552", -- [32]
			"43086:13177:2861:47121:47133:47116", -- [33]
			"43086:13177:2861:47121:47133", -- [34]
			"43086:13177:2861:47121", -- [35]
			"43086:13177:2861:47121:47133:47156", -- [36]
			"43086:13177:2861:47174:47061", -- [37]
			"43086:13177:2861:47174", -- [38]
			"43086:13177:2861:2851:43104:47661:47644", -- [39]
			"43086:13177:2861:2851:43104:47661:47644:47655", -- [40]
			"43086:13177:2861:2851:43104:47661", -- [41]
			"43086:13177:2861:2851:2389:47665", -- [42]
			"43086:13177:2861:2851:43573:46004:46011:47875", -- [43]
			"43086:13177:48321:48318:47927", -- [44]
			"43086:13177:48321:48318", -- [45]
			"43086:13177:48321", -- [46]
			"43086:13177:2861:2851:43573:46004:37915:44825:50463", -- [47]
			--["name"] = "Stonard, Swamp of Sorrows",
			["m"] = 51,
			["coord"] = 2051378439,
			["direct"] = "2858:1387:2861:13177:43086",
			["f"] = 0,
		},
		[3305] = {
			"2861:2851:2389:2226", -- [1]
			"43220:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"13177:1387:2858", -- [5]
			"13177:1387", -- [6]
			"13177:43086:6026", -- [7]
			"2861:44407:12636", -- [8]
			"2861:2851:4314", -- [9]
			"2861:44407:12636:16189:16192", -- [10]
			"2861:44407:12636:16189", -- [11]
			"2861:2851:43573:37888:44232:44233", -- [12]
			"2861:44407:12636:44230:28621", -- [13]
			"2861:44407:12636:44230", -- [14]
			"2861:2851:43573:37888:44232", -- [15]
			"2861:44407:12636:24851", -- [16]
			"2861:44407:12636:24851:26560", -- [17]
			"2861:2851:43573:37888", -- [18]
			"2861:2851:43573:46004:37915", -- [19]
			"2861:2851:43573:46004:37915:43124", -- [20]
			"13177:1387:43053", -- [21]
			"13177:1387:43052", -- [22]
			"13177:43086", -- [23]
			"2861:2851:43104", -- [24]
			"2861:2851:43573", -- [25]
			"2861:44407:12636:16189:44036", -- [26]
			"2861:2851:43573:37888:44232:44231", -- [27]
			"2861:44407:12636:16189:16192:44244", -- [28]
			"2861:44408", -- [29]
			"2861:44407", -- [30]
			"2861:2851:43573:46004:37915:44825", -- [31]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [32]
			"2861:2851:43573:46004", -- [33]
			"2861:2851:43573:46004:46011", -- [34]
			"2861:2851:43104:47661:47644:47655:46552", -- [35]
			"2861:47121:47133:47116", -- [36]
			"2861:47121:47133", -- [37]
			"2861:47121", -- [38]
			"2861:47121:47133:47156", -- [39]
			"2861:47174:47061", -- [40]
			"2861:47174", -- [41]
			"2861:2851:43104:47661:47644", -- [42]
			"2861:2851:43104:47661:47644:47655", -- [43]
			"2861:2851:43104:47661", -- [44]
			"2861:2851:2389:47665", -- [45]
			"2861:2851:43573:46004:46011:47875", -- [46]
			"47927:48318", -- [47]
			"13177:48321", -- [48]
			"2861:2851:43573:46004:37915:44825:50463", -- [49]
			"13177:43086:6026:85734", -- [50]
			["direct"] = "2861:13177:43220:47927",
			["m"] = 32,
			["coord"] = 1496010313,
			["f"] = 0,
		},
		[45479] = {
			"2226:4551", -- [1]
			"46552:47655:47644:2389", -- [2]
			"46552:47655:47644:47661:43104:2851", -- [3]
			"46552:47655:47644:47661:43104:2851:2861:2858", -- [4]
			"46552:47655:47644:47661:43104:2851:2861:1387", -- [5]
			"46552:47655:47644:47661:43104:2851:2861", -- [6]
			"46552:47655:47644:47661:43104:2851:2861:13177:43086:6026", -- [7]
			"46552:47655:47644:2389:37888:12636", -- [8]
			"46552:47655:47644:47661:43104:2851:2861:13177", -- [9]
			"46552:47655:47644:47661:43104:2851:2861:3305", -- [10]
			"46552:47655:47644:2389:4314", -- [11]
			"46552:47655:47644:2389:37888:12636:16189:16192", -- [12]
			"46552:47655:47644:2389:37888:12636:16189", -- [13]
			"2226:44825:37915:46004:46011:47875:44233", -- [14]
			"46552:47655:47644:2389:37888:44232:28621", -- [15]
			"46552:47655:47644:2389:37888:44232:44231:44230", -- [16]
			"46552:47655:47644:2389:37888:44232", -- [17]
			"46552:47655:47644:2389:37888:12636:24851", -- [18]
			"46552:47655:47644:2389:37888:12636:24851:26560", -- [19]
			"46552:47655:47644:2389:37888", -- [20]
			"2226:44825:37915", -- [21]
			"2226:44825:43124", -- [22]
			"46552:47655:47644:47661:43104:2851:2861:1387:43053", -- [23]
			"46552:47655:47644:47661:43104:2851:2861:1387:43052", -- [24]
			"46552:47655:47644:47661:43104:2851:2861:13177:43086", -- [25]
			"46552:47655:47644:47661:43104", -- [26]
			"46552:47655:47644:2389:43573", -- [27]
			"46552:47655:47644:2389:37888:12636:16189:44036", -- [28]
			"46552:47655:47644:2389:37888:44232:44231", -- [29]
			"46552:47655:47644:2389:37888:12636:16189:16192:44244", -- [30]
			"46552:47655:47644:47661:43104:2851:2861:44408", -- [31]
			"46552:47655:47644:47661:43104:2851:2861:44407", -- [32]
			"2226:44825", -- [33]
			"2226:44825:37915:46004", -- [34]
			"2226:44825:37915:46004:46011", -- [35]
			"46552:47655:47644:47661:43104:2851:47121:47133:47116", -- [36]
			"46552:47655:47644:47661:43104:2851:47121:47133", -- [37]
			"46552:47655:47644:47661:43104:2851:47121", -- [38]
			"46552:47655:47644:47661:43104:2851:47121:47133:47156", -- [39]
			"46552:47655:47644:47661:43104:2851:47121:47133:47156:47061", -- [40]
			"46552:47655:47644:47661:43104:2851:47174", -- [41]
			"46552:47655:47644", -- [42]
			"46552:47655", -- [43]
			"46552:47655:47644:47661", -- [44]
			"46552:47655:47644:2389:47665", -- [45]
			"2226:44825:37915:46004:46011:47875", -- [46]
			"46552:47655:47644:47661:43104:2851:2861:3305:47927", -- [47]
			"46552:47655:47644:47661:43104:2851:2861:13177:48321:48318", -- [48]
			"46552:47655:47644:47661:43104:2851:2861:13177:48321", -- [49]
			"2226:50463", -- [50]
			"46552:47655:47644:47661:43104:2851:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Forsaken Forward Command, Gilneas",
			["m"] = 217,
			["f"] = 0,
			["direct"] = "2226:46552",
			["coord"] = 2460364228,
		},
		[46552] = {
			"2226:4551", -- [1]
			"47655:47644:2389", -- [2]
			"47655:47644:47661:43104:2851", -- [3]
			"47655:47644:47661:43104:2851:2861:2858", -- [4]
			"47655:47644:47661:43104:2851:2861:1387", -- [5]
			"47655:47644:47661:43104:2851:2861", -- [6]
			"47655:47644:47661:43104:2851:2861:13177:43086:6026", -- [7]
			"47655:47644:2389:37888:12636", -- [8]
			"47655:47644:47661:43104:2851:2861:13177", -- [9]
			"47655:47644:47661:43104:2851:2861:3305", -- [10]
			"47655:47644:2389:4314", -- [11]
			"47655:47644:2389:37888:12636:16189:16192", -- [12]
			"47655:47644:2389:37888:12636:16189", -- [13]
			"47655:47644:2389:37888:44232:44233", -- [14]
			"47655:47644:2389:37888:44232:28621", -- [15]
			"47655:47644:2389:37888:44232:44231:44230", -- [16]
			"47655:47644:2389:37888:44232", -- [17]
			"47655:47644:2389:37888:12636:24851", -- [18]
			"47655:47644:2389:37888:12636:24851:26560", -- [19]
			"47655:47644:2389:37888", -- [20]
			"2226:44825:37915", -- [21]
			"2226:44825:43124", -- [22]
			"47655:47644:47661:43104:2851:2861:1387:43053", -- [23]
			"47655:47644:47661:43104:2851:2861:1387:43052", -- [24]
			"47655:47644:47661:43104:2851:2861:13177:43086", -- [25]
			"47655:47644:47661:43104", -- [26]
			"47655:47644:2389:43573", -- [27]
			"47655:47644:2389:37888:12636:16189:44036", -- [28]
			"47655:47644:2389:37888:44232:44231", -- [29]
			"47655:47644:2389:37888:12636:16189:16192:44244", -- [30]
			"47655:47644:47661:43104:2851:2861:44408", -- [31]
			"47655:47644:47661:43104:2851:2861:44407", -- [32]
			"2226:44825", -- [33]
			"2226:44825:37915:46004", -- [34]
			"2226:44825:37915:46004:46011", -- [35]
			"47655:47644:47661:43104:2851:47121:47133:47116", -- [36]
			"47655:47644:47661:43104:2851:47121:47133", -- [37]
			"47655:47644:47661:43104:2851:47121", -- [38]
			"47655:47644:47661:43104:2851:47121:47133:47156", -- [39]
			"47655:47644:47661:43104:2851:47121:47133:47156:47061", -- [40]
			"47655:47644:47661:43104:2851:47174", -- [41]
			"47655:47644", -- [42]
			"47655:47644:47661", -- [43]
			"47655:47644:2389:47665", -- [44]
			"2226:44825:37915:46004:46011:47875", -- [45]
			"47655:47644:47661:43104:2851:2861:3305:47927", -- [46]
			"47655:47644:47661:43104:2851:2861:13177:48321:48318", -- [47]
			"47655:47644:47661:43104:2851:2861:13177:48321", -- [48]
			"2226:50463", -- [49]
			"47655:47644:47661:43104:2851:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "The Forsaken Front, Silverpine Forest",
			["m"] = 21,
			["f"] = 0,
			["direct"] = "2226:45479:47655",
			["coord"] = 2186060496,
		},
		[47121] = {
			"2851:2389:2226", -- [1]
			"2851:43573:46004:37915:4551", -- [2]
			"2851:2389", -- [3]
			"2861:2858", -- [4]
			"2861:1387", -- [5]
			"2861:13177:43086:6026", -- [6]
			"2851:43573:37888:12636", -- [7]
			"2861:13177", -- [8]
			"2861:3305", -- [9]
			"2851:4314", -- [10]
			"2851:43573:37888:12636:16189:16192", -- [11]
			"2851:43573:37888:12636:16189", -- [12]
			"2851:43573:37888:44232:44233", -- [13]
			"2851:43573:37888:44232:28621", -- [14]
			"2851:43573:37888:44232:44231:44230", -- [15]
			"2851:43573:37888:44232", -- [16]
			"2851:43573:37888:12636:24851", -- [17]
			"2851:43573:37888:12636:24851:26560", -- [18]
			"2851:43573:37888", -- [19]
			"2851:43573:46004:37915", -- [20]
			"2851:43573:46004:37915:43124", -- [21]
			"2861:1387:43053", -- [22]
			"2861:1387:43052", -- [23]
			"2861:13177:43086", -- [24]
			"2851:43104", -- [25]
			"2851:43573", -- [26]
			"2851:43573:37888:12636:16189:44036", -- [27]
			"2851:43573:37888:44232:44231", -- [28]
			"2851:43573:37888:12636:16189:16192:44244", -- [29]
			"2861:44408", -- [30]
			"2861:44407", -- [31]
			"2851:43573:46004:37915:44825", -- [32]
			"2851:43104:47661:47644:47655:46552:45479", -- [33]
			"2851:43573:46004", -- [34]
			"2851:43573:46004:46011", -- [35]
			"2851:43104:47661:47644:47655:46552", -- [36]
			"47133:47116", -- [37]
			"47133:47156", -- [38]
			"47133:47156:47061", -- [39]
			"47133:47156:47174", -- [40]
			"2851:43104:47661:47644", -- [41]
			"2851:43104:47661:47644:47655", -- [42]
			"2851:43104:47661", -- [43]
			"2851:2389:47665", -- [44]
			"2851:43573:46004:46011:47875", -- [45]
			"2861:3305:47927", -- [46]
			"2861:13177:48321:48318", -- [47]
			"2861:13177:48321", -- [48]
			"2851:43573:46004:37915:44825:50463", -- [49]
			"2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Vermillion Redoubt, Twilight Highlands",
			["m"] = 241,
			["f"] = 0,
			["direct"] = "2851:2861:47133",
			["coord"] = 1225146328,
		},
		[44036] = {
			"16189:12636:37888:37915:44825:2226", -- [1]
			"16189:12636:37888:4551", -- [2]
			"16189:12636:37888:2389", -- [3]
			"16189:12636:4314:2851", -- [4]
			"16189:12636:44407:2861:2858", -- [5]
			"16189:12636:44407:2861:1387", -- [6]
			"16189:12636:44407:2861", -- [7]
			"16189:12636:44407:2861:13177:43086:6026", -- [8]
			"16189:12636", -- [9]
			"16189:12636:44407:2861:13177", -- [10]
			"16189:12636:44407:2861:3305", -- [11]
			"16189:12636:4314", -- [12]
			"16189:12636:44230:44233", -- [13]
			"16189:12636:44230:28621", -- [14]
			"16189:12636:44230", -- [15]
			"16189:12636:44231:44232", -- [16]
			"16189:24851", -- [17]
			"16192:26560", -- [18]
			"16189:12636:37888", -- [19]
			"16189:12636:37888:37915", -- [20]
			"16189:12636:37888:37915:43124", -- [21]
			"16189:12636:44407:2861:1387:43053", -- [22]
			"16189:12636:44407:2861:1387:43052", -- [23]
			"16189:12636:44407:2861:13177:43086", -- [24]
			"16189:12636:37888:2389:43104", -- [25]
			"16189:12636:37888:43573", -- [26]
			"16189:12636:44231", -- [27]
			"16192:44244", -- [28]
			"16189:12636:44407:44408", -- [29]
			"16189:12636:44407", -- [30]
			"16189:12636:37888:37915:44825", -- [31]
			"16189:12636:37888:37915:44825:2226:46552:45479", -- [32]
			"16189:12636:37888:46011:46004", -- [33]
			"16189:12636:37888:46011", -- [34]
			"16189:12636:37888:37915:44825:2226:46552", -- [35]
			"16189:12636:4314:2851:47121:47133:47116", -- [36]
			"16189:12636:4314:2851:47121:47133", -- [37]
			"16189:12636:4314:2851:47121", -- [38]
			"16189:12636:4314:2851:47121:47133:47156", -- [39]
			"16189:12636:4314:2851:47121:47133:47156:47061", -- [40]
			"16189:12636:4314:2851:47174", -- [41]
			"16189:12636:37888:2389:47644", -- [42]
			"16189:12636:37888:2389:47644:47655", -- [43]
			"16189:12636:37888:2389:47661", -- [44]
			"16189:12636:37888:37915:47665", -- [45]
			"16189:12636:44230:44233:47875", -- [46]
			"16189:12636:44407:2861:3305:47927", -- [47]
			"16189:12636:44407:2861:13177:48321:48318", -- [48]
			"16189:12636:44407:2861:13177:48321", -- [49]
			"16189:12636:37888:37915:44825:50463", -- [50]
			"16189:12636:44407:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Fairbreeze Village, Eversong Woods",
			["m"] = 94,
			["coord"] = 1889448706,
			["direct"] = "16192:16189",
			["f"] = 0,
		},
		[46004] = {
			"37915:44825:2226", -- [1]
			"37915:4551", -- [2]
			"37915:2389", -- [3]
			"43573:2851", -- [4]
			"43573:2851:2861:2858", -- [5]
			"43573:2851:2861:1387", -- [6]
			"43573:2851:2861", -- [7]
			"43573:2851:2861:13177:43086:6026", -- [8]
			"46011:37888:12636", -- [9]
			"43573:2851:2861:13177", -- [10]
			"43573:2851:2861:3305", -- [11]
			"43573:4314", -- [12]
			"46011:37888:12636:16189:16192", -- [13]
			"46011:37888:12636:16189", -- [14]
			"46011:47875:44233", -- [15]
			"46011:37888:44232:28621", -- [16]
			"46011:37888:44232:44231:44230", -- [17]
			"46011:37888:44232", -- [18]
			"46011:37888:12636:24851", -- [19]
			"46011:37888:12636:24851:26560", -- [20]
			"46011:37888", -- [21]
			"37915:43124", -- [22]
			"43573:2851:2861:1387:43053", -- [23]
			"43573:2851:2861:1387:43052", -- [24]
			"43573:2851:2861:13177:43086", -- [25]
			"37915:2389:43104", -- [26]
			"46011:37888:12636:16189:44036", -- [27]
			"46011:37888:44232:44231", -- [28]
			"46011:37888:12636:16189:16192:44244", -- [29]
			"43573:2851:2861:44408", -- [30]
			"43573:2851:2861:44407", -- [31]
			"37915:44825", -- [32]
			"37915:44825:2226:46552:45479", -- [33]
			"37915:44825:2226:46552", -- [34]
			"43573:2851:47121:47133:47116", -- [35]
			"43573:2851:47121:47133", -- [36]
			"43573:2851:47121", -- [37]
			"43573:2851:47121:47133:47156", -- [38]
			"43573:2851:47121:47133:47156:47061", -- [39]
			"43573:2851:47174", -- [40]
			"37915:2389:47644", -- [41]
			"37915:2389:47644:47655", -- [42]
			"37915:2389:47661", -- [43]
			"37915:47665", -- [44]
			"46011:47875", -- [45]
			"43573:2851:2861:3305:47927", -- [46]
			"43573:2851:2861:13177:48321:48318", -- [47]
			"43573:2851:2861:13177:48321", -- [48]
			"37915:44825:50463", -- [49]
			"43573:2851:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Andorhal, Western Plaguelands",
			["m"] = 22,
			["coord"] = 2001315236,
			["direct"] = "37915:43573:46011",
			["f"] = 0,
		},
		[26560] = {
			"24851:12636:37888:37915:44825:2226", -- [1]
			"24851:12636:37888:4551", -- [2]
			"24851:12636:37888:2389", -- [3]
			"24851:12636:4314:2851", -- [4]
			"24851:12636:44407:2861:2858", -- [5]
			"24851:12636:44407:2861:1387", -- [6]
			"24851:12636:44407:2861", -- [7]
			"24851:12636:44407:2861:13177:43086:6026", -- [8]
			"24851:12636", -- [9]
			"24851:12636:44407:2861:13177", -- [10]
			"24851:12636:44407:2861:3305", -- [11]
			"24851:12636:4314", -- [12]
			"16192:16189", -- [13]
			"24851:12636:44230:44233", -- [14]
			"24851:12636:44230:28621", -- [15]
			"24851:12636:44230", -- [16]
			"24851:12636:44231:44232", -- [17]
			"24851:12636:37888", -- [18]
			"24851:12636:37888:37915", -- [19]
			"24851:12636:37888:37915:43124", -- [20]
			"24851:12636:44407:2861:1387:43053", -- [21]
			"24851:12636:44407:2861:1387:43052", -- [22]
			"24851:12636:44407:2861:13177:43086", -- [23]
			"24851:12636:37888:2389:43104", -- [24]
			"24851:12636:37888:43573", -- [25]
			"16192:44036", -- [26]
			"24851:12636:44231", -- [27]
			"16192:44244", -- [28]
			"24851:12636:44407:44408", -- [29]
			"24851:12636:44407", -- [30]
			"24851:12636:37888:37915:44825", -- [31]
			"24851:12636:37888:37915:44825:2226:46552:45479", -- [32]
			"24851:12636:37888:46011:46004", -- [33]
			"24851:12636:37888:46011", -- [34]
			"24851:12636:37888:37915:44825:2226:46552", -- [35]
			"24851:12636:4314:2851:47121:47133:47116", -- [36]
			"24851:12636:4314:2851:47121:47133", -- [37]
			"24851:12636:4314:2851:47121", -- [38]
			"24851:12636:4314:2851:47121:47133:47156", -- [39]
			"24851:12636:4314:2851:47121:47133:47156:47061", -- [40]
			"24851:12636:4314:2851:47174", -- [41]
			"24851:12636:37888:2389:47644", -- [42]
			"24851:12636:37888:2389:47644:47655", -- [43]
			"24851:12636:37888:2389:47661", -- [44]
			"24851:12636:37888:37915:47665", -- [45]
			"24851:12636:44230:44233:47875", -- [46]
			"24851:12636:44407:2861:3305:47927", -- [47]
			"24851:12636:44407:2861:13177:48321:48318", -- [48]
			"24851:12636:44407:2861:13177:48321", -- [49]
			"24851:12636:37888:37915:44825:50463", -- [50]
			"24851:12636:44407:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Shattered Sun Staging Area",
			["m"] = 122,
			["coord"] = 2073575464,
			["direct"] = "16192:24851",
			["f"] = 0,
		},
		[44231] = {
			"44232:37888:37915:44825:2226", -- [1]
			"44232:37888:4551", -- [2]
			"44232:37888:2389", -- [3]
			"44232:37888:43573:2851", -- [4]
			"12636:44407:2861:2858", -- [5]
			"12636:44407:2861:1387", -- [6]
			"12636:44407:2861", -- [7]
			"12636:44407:2861:13177:43086:6026", -- [8]
			"12636:44407:2861:13177", -- [9]
			"12636:44407:2861:3305", -- [10]
			"12636:4314", -- [11]
			"12636:16189:16192", -- [12]
			"12636:16189", -- [13]
			"44230:28621", -- [14]
			"12636:24851", -- [15]
			"12636:24851:26560", -- [16]
			"44232:37888", -- [17]
			"44232:37888:37915", -- [18]
			"44232:37888:37915:43124", -- [19]
			"12636:44407:2861:1387:43053", -- [20]
			"12636:44407:2861:1387:43052", -- [21]
			"12636:44407:2861:13177:43086", -- [22]
			"44232:37888:2389:43104", -- [23]
			"44232:37888:43573", -- [24]
			"12636:16189:44036", -- [25]
			"12636:16189:16192:44244", -- [26]
			"12636:44407:44408", -- [27]
			"12636:44407", -- [28]
			"44232:37888:37915:44825", -- [29]
			"44232:37888:37915:44825:2226:46552:45479", -- [30]
			"44232:37888:46011:46004", -- [31]
			"44232:37888:46011", -- [32]
			"44232:37888:37915:44825:2226:46552", -- [33]
			"44232:37888:43573:2851:47121:47133:47116", -- [34]
			"44232:37888:43573:2851:47121:47133", -- [35]
			"44232:37888:43573:2851:47121", -- [36]
			"44232:37888:43573:2851:47121:47133:47156", -- [37]
			"44232:37888:43573:2851:47121:47133:47156:47061", -- [38]
			"44232:37888:43573:2851:47174", -- [39]
			"44232:37888:2389:47644", -- [40]
			"44232:37888:2389:47644:47655", -- [41]
			"44232:37888:2389:47661", -- [42]
			"44232:37888:37915:47665", -- [43]
			"44233:47875", -- [44]
			"12636:44407:2861:3305:47927", -- [45]
			"12636:44407:2861:13177:48321:48318", -- [46]
			"12636:44407:2861:13177:48321", -- [47]
			"44232:37888:37915:44825:50463", -- [48]
			"12636:44407:2861:13177:43086:6026:85734", -- [49]
			--["name"] = "Light's Shield Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 2262927709,
			["direct"] = "12636:44233:44230:44232",
			["f"] = 0,
		},
		[44233] = {
			"44232:37888:37915:44825:2226", -- [1]
			"44232:37888:4551", -- [2]
			"44232:37888:2389", -- [3]
			"44232:37888:43573:2851", -- [4]
			"44230:12636:44407:2861:2858", -- [5]
			"44230:12636:44407:2861:1387", -- [6]
			"44230:12636:44407:2861", -- [7]
			"44230:12636:44407:2861:13177:43086:6026", -- [8]
			"44230:12636", -- [9]
			"44230:12636:44407:2861:13177", -- [10]
			"44230:12636:44407:2861:3305", -- [11]
			"44230:12636:4314", -- [12]
			"44230:12636:16189:16192", -- [13]
			"44230:12636:16189", -- [14]
			"44230:12636:24851", -- [15]
			"44230:12636:24851:26560", -- [16]
			"44232:37888", -- [17]
			"44232:37888:37915", -- [18]
			"44232:37888:37915:43124", -- [19]
			"44230:12636:44407:2861:1387:43053", -- [20]
			"44230:12636:44407:2861:1387:43052", -- [21]
			"44230:12636:44407:2861:13177:43086", -- [22]
			"44232:37888:2389:43104", -- [23]
			"44232:37888:43573", -- [24]
			"44230:12636:16189:44036", -- [25]
			"44230:12636:16189:16192:44244", -- [26]
			"44230:12636:44407:44408", -- [27]
			"44230:12636:44407", -- [28]
			"44232:37888:37915:44825", -- [29]
			"44232:37888:37915:44825:2226:46552:45479", -- [30]
			"47875:46011:46004", -- [31]
			"47875:46011", -- [32]
			"44232:37888:37915:44825:2226:46552", -- [33]
			"44232:37888:43573:2851:47121:47133:47116", -- [34]
			"44232:37888:43573:2851:47121:47133", -- [35]
			"44232:37888:43573:2851:47121", -- [36]
			"44232:37888:43573:2851:47121:47133:47156", -- [37]
			"44232:37888:43573:2851:47121:47133:47156:47061", -- [38]
			"44232:37888:43573:2851:47174", -- [39]
			"44232:37888:2389:47644", -- [40]
			"44232:37888:2389:47644:47655", -- [41]
			"44232:37888:2389:47661", -- [42]
			"44232:37888:37915:47665", -- [43]
			"44230:12636:44407:2861:3305:47927", -- [44]
			"44230:12636:44407:2861:13177:48321:48318", -- [45]
			"44230:12636:44407:2861:13177:48321", -- [46]
			"44232:37888:37915:44825:50463", -- [47]
			"44230:12636:44407:2861:13177:43086:6026:85734", -- [48]
			--["name"] = "Plaguewood Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 794904154,
			["direct"] = "28621:44230:44232:44231:47875",
			["f"] = 0,
		},
		[47133] = {
			"47121:2851:2389:2226", -- [1]
			"47121:2851:43573:46004:37915:4551", -- [2]
			"47121:2851:2389", -- [3]
			"47121:2851", -- [4]
			"47121:2861:2858", -- [5]
			"47121:2861:1387", -- [6]
			"47121:2861", -- [7]
			"47121:2861:13177:43086:6026", -- [8]
			"47121:2851:43573:37888:12636", -- [9]
			"47121:2861:13177", -- [10]
			"47121:2861:3305", -- [11]
			"47121:2851:4314", -- [12]
			"47121:2851:43573:37888:12636:16189:16192", -- [13]
			"47121:2851:43573:37888:12636:16189", -- [14]
			"47121:2851:43573:37888:44232:44233", -- [15]
			"47121:2851:43573:37888:44232:28621", -- [16]
			"47121:2851:43573:37888:44232:44231:44230", -- [17]
			"47121:2851:43573:37888:44232", -- [18]
			"47121:2851:43573:37888:12636:24851", -- [19]
			"47121:2851:43573:37888:12636:24851:26560", -- [20]
			"47121:2851:43573:37888", -- [21]
			"47121:2851:43573:46004:37915", -- [22]
			"47121:2851:43573:46004:37915:43124", -- [23]
			"47121:2861:1387:43053", -- [24]
			"47121:2861:1387:43052", -- [25]
			"47121:2861:13177:43086", -- [26]
			"47121:2851:43104", -- [27]
			"47121:2851:43573", -- [28]
			"47121:2851:43573:37888:12636:16189:44036", -- [29]
			"47121:2851:43573:37888:44232:44231", -- [30]
			"47121:2851:43573:37888:12636:16189:16192:44244", -- [31]
			"47121:2861:44408", -- [32]
			"47121:2861:44407", -- [33]
			"47121:2851:43573:46004:37915:44825", -- [34]
			"47121:2851:43104:47661:47644:47655:46552:45479", -- [35]
			"47121:2851:43573:46004", -- [36]
			"47121:2851:43573:46004:46011", -- [37]
			"47121:2851:43104:47661:47644:47655:46552", -- [38]
			"47156:47061", -- [39]
			"47156:47174", -- [40]
			"47121:2851:43104:47661:47644", -- [41]
			"47121:2851:43104:47661:47644:47655", -- [42]
			"47121:2851:43104:47661", -- [43]
			"47121:2851:2389:47665", -- [44]
			"47121:2851:43573:46004:46011:47875", -- [45]
			"47121:2861:3305:47927", -- [46]
			"47121:2861:13177:48321:48318", -- [47]
			"47121:2861:13177:48321", -- [48]
			"47121:2851:43573:46004:37915:44825:50463", -- [49]
			"47121:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "The Gullet, Twilight Highlands",
			["m"] = 241,
			["f"] = 0,
			["direct"] = "47116:47121:47156",
			["coord"] = 1582457212,
		},
		[48318] = {
			"48321:13177:2861:2851:2389:2226", -- [1]
			"47927:3305:43220:4551", -- [2]
			"48321:13177:2861:2851:2389", -- [3]
			"48321:13177:2861:2851", -- [4]
			"48321:13177:1387:2858", -- [5]
			"48321:13177:1387", -- [6]
			"48321:13177:2861", -- [7]
			"48321:13177:43086:6026", -- [8]
			"48321:13177:2861:44407:12636", -- [9]
			"48321:13177", -- [10]
			"47927:3305", -- [11]
			"48321:13177:2861:2851:4314", -- [12]
			"48321:13177:2861:44407:12636:16189:16192", -- [13]
			"48321:13177:2861:44407:12636:16189", -- [14]
			"48321:13177:2861:2851:43573:37888:44232:44233", -- [15]
			"48321:13177:2861:44407:12636:44230:28621", -- [16]
			"48321:13177:2861:44407:12636:44230", -- [17]
			"48321:13177:2861:2851:43573:37888:44232", -- [18]
			"48321:13177:2861:44407:12636:24851", -- [19]
			"48321:13177:2861:44407:12636:24851:26560", -- [20]
			"48321:13177:2861:2851:43573:37888", -- [21]
			"48321:13177:2861:2851:43573:46004:37915", -- [22]
			"48321:13177:2861:2851:43573:46004:37915:43124", -- [23]
			"48321:13177:1387:43053", -- [24]
			"48321:13177:1387:43052", -- [25]
			"48321:13177:43086", -- [26]
			"48321:13177:2861:2851:43104", -- [27]
			"48321:13177:2861:2851:43573", -- [28]
			"48321:13177:2861:44407:12636:16189:44036", -- [29]
			"48321:13177:2861:2851:43573:37888:44232:44231", -- [30]
			"48321:13177:2861:44407:12636:16189:16192:44244", -- [31]
			"48321:13177:2861:44408", -- [32]
			"48321:13177:2861:44407", -- [33]
			"48321:13177:2861:2851:43573:46004:37915:44825", -- [34]
			"48321:13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [35]
			"48321:13177:2861:2851:43573:46004", -- [36]
			"48321:13177:2861:2851:43573:46004:46011", -- [37]
			"48321:13177:2861:2851:43104:47661:47644:47655:46552", -- [38]
			"48321:13177:2861:47121:47133:47116", -- [39]
			"48321:13177:2861:47121:47133", -- [40]
			"48321:13177:2861:47121", -- [41]
			"48321:13177:2861:47121:47133:47156", -- [42]
			"48321:13177:2861:47174:47061", -- [43]
			"48321:13177:2861:47174", -- [44]
			"48321:13177:2861:2851:43104:47661:47644", -- [45]
			"48321:13177:2861:2851:43104:47661:47644:47655", -- [46]
			"48321:13177:2861:2851:43104:47661", -- [47]
			"48321:13177:2861:2851:2389:47665", -- [48]
			"48321:13177:2861:2851:43573:46004:46011:47875", -- [49]
			"48321:13177:2861:2851:43573:46004:37915:44825:50463", -- [50]
			"48321:13177:43086:6026:85734", -- [51]
			--["name"] = "Flamestar Post, Burning Steppes",
			["m"] = 36,
			["f"] = 0,
			["direct"] = "47927:48321",
			["coord"] = 764708591,
		},
		[46011] = {
			"46004:37915:44825:2226", -- [1]
			"46004:37915:4551", -- [2]
			"37888:2389", -- [3]
			"46004:43573:2851", -- [4]
			"46004:43573:2851:2861:2858", -- [5]
			"46004:43573:2851:2861:1387", -- [6]
			"46004:43573:2851:2861", -- [7]
			"46004:43573:2851:2861:13177:43086:6026", -- [8]
			"37888:12636", -- [9]
			"46004:43573:2851:2861:13177", -- [10]
			"46004:43573:2851:2861:3305", -- [11]
			"46004:43573:4314", -- [12]
			"37888:12636:16189:16192", -- [13]
			"37888:12636:16189", -- [14]
			"47875:44233", -- [15]
			"37888:44232:28621", -- [16]
			"37888:44232:44231:44230", -- [17]
			"37888:44232", -- [18]
			"37888:12636:24851", -- [19]
			"37888:12636:24851:26560", -- [20]
			"46004:37915", -- [21]
			"46004:37915:43124", -- [22]
			"46004:43573:2851:2861:1387:43053", -- [23]
			"46004:43573:2851:2861:1387:43052", -- [24]
			"46004:43573:2851:2861:13177:43086", -- [25]
			"37888:2389:43104", -- [26]
			"46004:43573", -- [27]
			"37888:12636:16189:44036", -- [28]
			"37888:44232:44231", -- [29]
			"37888:12636:16189:16192:44244", -- [30]
			"46004:43573:2851:2861:44408", -- [31]
			"37888:12636:44407", -- [32]
			"46004:37915:44825", -- [33]
			"46004:37915:44825:2226:46552:45479", -- [34]
			"46004:37915:44825:2226:46552", -- [35]
			"46004:43573:2851:47121:47133:47116", -- [36]
			"46004:43573:2851:47121:47133", -- [37]
			"46004:43573:2851:47121", -- [38]
			"46004:43573:2851:47121:47133:47156", -- [39]
			"46004:43573:2851:47121:47133:47156:47061", -- [40]
			"46004:43573:2851:47174", -- [41]
			"37888:2389:47644", -- [42]
			"37888:2389:47644:47655", -- [43]
			"37888:2389:47661", -- [44]
			"46004:37915:47665", -- [45]
			"46004:43573:2851:2861:3305:47927", -- [46]
			"46004:43573:2851:2861:13177:48321:48318", -- [47]
			"46004:43573:2851:2861:13177:48321", -- [48]
			"46004:37915:44825:50463", -- [49]
			"46004:43573:2851:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "The Menders' Stead, Western Plaguelands",
			["m"] = 22,
			["coord"] = 2169931306,
			["direct"] = "37888:46004:47875",
			["f"] = 0,
		},
		[4314] = {
			"43573:2389:2226", -- [1]
			"2851:2861:2858", -- [2]
			"2851:2861:1387", -- [3]
			"2851:2861", -- [4]
			"2851:2861:13177:43086:6026", -- [5]
			"2851:2861:13177", -- [6]
			"2851:2861:3305", -- [7]
			"12636:16189:16192", -- [8]
			"12636:16189", -- [9]
			"12636:44230:44233", -- [10]
			"12636:44230:28621", -- [11]
			"12636:44230", -- [12]
			"43573:37888:44232", -- [13]
			"12636:24851", -- [14]
			"12636:24851:26560", -- [15]
			"43573:37888", -- [16]
			"43573:46004:37915", -- [17]
			"43573:46004:37915:43124", -- [18]
			"2851:2861:1387:43053", -- [19]
			"2851:2861:1387:43052", -- [20]
			"2851:2861:13177:43086", -- [21]
			"2851:43104", -- [22]
			"12636:16189:44036", -- [23]
			"12636:44231", -- [24]
			"12636:16189:16192:44244", -- [25]
			"2851:2861:44408", -- [26]
			"2851:2861:44407", -- [27]
			"43573:46004:37915:44825", -- [28]
			"43573:2389:47644:47655:46552:45479", -- [29]
			"43573:46004", -- [30]
			"43573:46004:46011", -- [31]
			"43573:2389:47644:47655:46552", -- [32]
			"2851:47121:47133:47116", -- [33]
			"2851:47121:47133", -- [34]
			"2851:47121", -- [35]
			"2851:47121:47133:47156", -- [36]
			"2851:47121:47133:47156:47061", -- [37]
			"2851:47174", -- [38]
			"43573:2389:47644", -- [39]
			"43573:2389:47644:47655", -- [40]
			"43573:2389:47661", -- [41]
			"43573:2389:47665", -- [42]
			"43573:46004:46011:47875", -- [43]
			"2851:2861:3305:47927", -- [44]
			"2851:2861:13177:48321:48318", -- [45]
			"2851:2861:13177:48321", -- [46]
			"43573:46004:37915:44825:50463", -- [47]
			"2851:2861:13177:43086:6026:85734", -- [48]
			--["name"] = "Revantusk Village, The Hinterlands",
			["m"] = 26,
			["f"] = 0,
			["direct"] = "4551:2389:2851:12636:43573",
			["coord"] = 3509047718,
		},
		[44232] = {
			"37888:37915:44825:2226", -- [1]
			"37888:4551", -- [2]
			"37888:2389", -- [3]
			"37888:43573:2851", -- [4]
			"37888:43573:2851:2861:2858", -- [5]
			"37888:43573:2851:2861:1387", -- [6]
			"37888:43573:2851:2861", -- [7]
			"37888:43573:2851:2861:13177:43086:6026", -- [8]
			"44231:12636", -- [9]
			"37888:43573:2851:2861:13177", -- [10]
			"37888:43573:2851:2861:3305", -- [11]
			"37888:43573:4314", -- [12]
			"44231:12636:16189:16192", -- [13]
			"44231:12636:16189", -- [14]
			"44231:44230", -- [15]
			"44231:12636:24851", -- [16]
			"44231:12636:24851:26560", -- [17]
			"37888:37915", -- [18]
			"37888:37915:43124", -- [19]
			"37888:43573:2851:2861:1387:43053", -- [20]
			"37888:43573:2851:2861:1387:43052", -- [21]
			"37888:43573:2851:2861:13177:43086", -- [22]
			"37888:2389:43104", -- [23]
			"37888:43573", -- [24]
			"44231:12636:16189:44036", -- [25]
			"44231:12636:16189:16192:44244", -- [26]
			"44231:12636:44407:44408", -- [27]
			"44231:12636:44407", -- [28]
			"37888:37915:44825", -- [29]
			"37888:37915:44825:2226:46552:45479", -- [30]
			"37888:46011:46004", -- [31]
			"37888:46011", -- [32]
			"37888:37915:44825:2226:46552", -- [33]
			"37888:43573:2851:47121:47133:47116", -- [34]
			"37888:43573:2851:47121:47133", -- [35]
			"37888:43573:2851:47121", -- [36]
			"37888:43573:2851:47121:47133:47156", -- [37]
			"37888:43573:2851:47121:47133:47156:47061", -- [38]
			"37888:43573:2851:47174", -- [39]
			"37888:2389:47644", -- [40]
			"37888:2389:47644:47655", -- [41]
			"37888:2389:47661", -- [42]
			"37888:37915:47665", -- [43]
			"44233:47875", -- [44]
			"37888:43573:2851:2861:3305:47927", -- [45]
			"37888:43573:2851:2861:13177:48321:48318", -- [46]
			"37888:43573:2851:2861:13177:48321", -- [47]
			"37888:37915:44825:50463", -- [48]
			"37888:43573:2851:2861:13177:43086:6026:85734", -- [49]
			--["name"] = "Crown Guard Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 1497804315,
			["direct"] = "44233:28621:37888:44231",
			["f"] = 0,
		},
		[4551] = {
			"2861:2858", -- [1]
			"2861:1387", -- [2]
			"2861:13177:43086:6026", -- [3]
			"2861:13177", -- [4]
			"43220:3305", -- [5]
			"37888:12636:16189:16192", -- [6]
			"37888:12636:16189", -- [7]
			"37915:46004:46011:47875:44233", -- [8]
			"37888:44232:28621", -- [9]
			"37888:44232:44231:44230", -- [10]
			"37888:44232", -- [11]
			"37888:12636:24851", -- [12]
			"37888:12636:24851:26560", -- [13]
			"2861:1387:43053", -- [14]
			"2861:1387:43052", -- [15]
			"2861:13177:43086", -- [16]
			"37915:46004:43573", -- [17]
			"37888:12636:16189:44036", -- [18]
			"37888:44232:44231", -- [19]
			"37888:12636:16189:16192:44244", -- [20]
			"2861:44408", -- [21]
			"2861:44407", -- [22]
			"2226:46552:45479", -- [23]
			"37915:46004", -- [24]
			"37915:46004:46011", -- [25]
			"2226:46552", -- [26]
			"2389:2851:47121:47133:47116", -- [27]
			"2389:2851:47121:47133", -- [28]
			"2389:2851:47121", -- [29]
			"2389:2851:47121:47133:47156", -- [30]
			"2389:2851:47121:47133:47156:47061", -- [31]
			"2389:2851:47174", -- [32]
			"2389:47644", -- [33]
			"2226:46552:47655", -- [34]
			"2389:47661", -- [35]
			"37915:47665", -- [36]
			"37915:46004:46011:47875", -- [37]
			"43220:3305:47927", -- [38]
			"2861:13177:48321:48318", -- [39]
			"2861:13177:48321", -- [40]
			"44825:50463", -- [41]
			"2861:13177:43086:6026:85734", -- [42]
			--["name"] = "Undercity, Tirisfal",
			["m"] = 90,
			["f"] = 0,
			["direct"] = "2226:2389:2851:2861:12636:4314:37888:37915:43124:43104:44825",
			["coord"] = 2715646852,
		},
		[2858] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"2861:44407:12636", -- [5]
			"1387:13177", -- [6]
			"1387:13177:3305", -- [7]
			"2861:2851:4314", -- [8]
			"2861:44407:12636:16189:16192", -- [9]
			"2861:44407:12636:16189", -- [10]
			"2861:2851:43573:37888:44232:44233", -- [11]
			"2861:44407:12636:44230:28621", -- [12]
			"2861:44407:12636:44230", -- [13]
			"2861:2851:43573:37888:44232", -- [14]
			"2861:44407:12636:24851", -- [15]
			"2861:44407:12636:24851:26560", -- [16]
			"2861:2851:43573:37888", -- [17]
			"2861:2851:43573:46004:37915", -- [18]
			"2861:2851:43573:46004:37915:43124", -- [19]
			"43053:43052", -- [20]
			"6026:43086", -- [21]
			"2861:2851:43104", -- [22]
			"2861:2851:43573", -- [23]
			"2861:44407:12636:16189:44036", -- [24]
			"2861:2851:43573:37888:44232:44231", -- [25]
			"2861:44407:12636:16189:16192:44244", -- [26]
			"2861:44408", -- [27]
			"2861:44407", -- [28]
			"2861:2851:43573:46004:37915:44825", -- [29]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [30]
			"2861:2851:43573:46004", -- [31]
			"2861:2851:43573:46004:46011", -- [32]
			"2861:2851:43104:47661:47644:47655:46552", -- [33]
			"2861:47121:47133:47116", -- [34]
			"2861:47121:47133", -- [35]
			"2861:47121", -- [36]
			"2861:47121:47133:47156", -- [37]
			"2861:47174:47061", -- [38]
			"2861:47174", -- [39]
			"2861:2851:43104:47661:47644", -- [40]
			"2861:2851:43104:47661:47644:47655", -- [41]
			"2861:2851:43104:47661", -- [42]
			"2861:2851:2389:47665", -- [43]
			"2861:2851:43573:46004:46011:47875", -- [44]
			"1387:13177:48321:48318:47927", -- [45]
			"1387:13177:48321:48318", -- [46]
			"1387:13177:48321", -- [47]
			"2861:2851:43573:46004:37915:44825:50463", -- [48]
			"43053:43052:85734", -- [49]
			--["name"] = "Booty Bay, Stranglethorn",
			["m"] = 210,
			["f"] = 0,
			["direct"] = "1387:2861:6026:43053",
			["coord"] = 1742060479,
		},
		[43052] = {
			"1387:2861:2851:2389:2226", -- [1]
			"1387:2861:4551", -- [2]
			"1387:2861:2851:2389", -- [3]
			"1387:2861:2851", -- [4]
			"43053:2858", -- [5]
			"1387:2861", -- [6]
			"85734:6026", -- [7]
			"1387:2861:44407:12636", -- [8]
			"1387:13177", -- [9]
			"1387:13177:3305", -- [10]
			"1387:2861:2851:4314", -- [11]
			"1387:2861:44407:12636:16189:16192", -- [12]
			"1387:2861:44407:12636:16189", -- [13]
			"1387:2861:2851:43573:37888:44232:44233", -- [14]
			"1387:2861:44407:12636:44230:28621", -- [15]
			"1387:2861:44407:12636:44230", -- [16]
			"1387:2861:2851:43573:37888:44232", -- [17]
			"1387:2861:44407:12636:24851", -- [18]
			"1387:2861:44407:12636:24851:26560", -- [19]
			"1387:2861:2851:43573:37888", -- [20]
			"1387:2861:2851:43573:46004:37915", -- [21]
			"1387:2861:2851:43573:46004:37915:43124", -- [22]
			"85734:6026:43086", -- [23]
			"1387:2861:2851:43104", -- [24]
			"1387:2861:2851:43573", -- [25]
			"1387:2861:44407:12636:16189:44036", -- [26]
			"1387:2861:2851:43573:37888:44232:44231", -- [27]
			"1387:2861:44407:12636:16189:16192:44244", -- [28]
			"1387:2861:44408", -- [29]
			"1387:2861:44407", -- [30]
			"1387:2861:2851:43573:46004:37915:44825", -- [31]
			"1387:2861:2851:43104:47661:47644:47655:46552:45479", -- [32]
			"1387:2861:2851:43573:46004", -- [33]
			"1387:2861:2851:43573:46004:46011", -- [34]
			"1387:2861:2851:43104:47661:47644:47655:46552", -- [35]
			"1387:2861:47121:47133:47116", -- [36]
			"1387:2861:47121:47133", -- [37]
			"1387:2861:47121", -- [38]
			"1387:2861:47121:47133:47156", -- [39]
			"1387:2861:47174:47061", -- [40]
			"1387:2861:47174", -- [41]
			"1387:2861:2851:43104:47661:47644", -- [42]
			"1387:2861:2851:43104:47661:47644:47655", -- [43]
			"1387:2861:2851:43104:47661", -- [44]
			"1387:2861:2851:2389:47665", -- [45]
			"1387:2861:2851:43573:46004:46011:47875", -- [46]
			"1387:13177:48321:48318:47927", -- [47]
			"1387:13177:48321:48318", -- [48]
			"1387:13177:48321", -- [49]
			"1387:2861:2851:43573:46004:37915:44825:50463", -- [50]
			--["name"] = "Bambala, Stranglethorn",
			["m"] = 50,
			["f"] = 0,
			["direct"] = "1387:43053:85734",
			["coord"] = 2679465147,
		},
		[37888] = {
			"37915:44825:2226", -- [1]
			"43573:2851", -- [2]
			"43573:2851:2861:2858", -- [3]
			"43573:2851:2861:1387", -- [4]
			"43573:2851:2861", -- [5]
			"43573:2851:2861:13177:43086:6026", -- [6]
			"43573:2851:2861:13177", -- [7]
			"43573:2851:2861:3305", -- [8]
			"43573:4314", -- [9]
			"12636:16189:16192", -- [10]
			"12636:16189", -- [11]
			"44232:44233", -- [12]
			"44232:28621", -- [13]
			"44232:44231:44230", -- [14]
			"12636:24851", -- [15]
			"12636:24851:26560", -- [16]
			"37915:43124", -- [17]
			"43573:2851:2861:1387:43053", -- [18]
			"43573:2851:2861:1387:43052", -- [19]
			"43573:2851:2861:13177:43086", -- [20]
			"2389:43104", -- [21]
			"12636:16189:44036", -- [22]
			"44232:44231", -- [23]
			"12636:16189:16192:44244", -- [24]
			"43573:2851:2861:44408", -- [25]
			"12636:44407", -- [26]
			"37915:44825", -- [27]
			"37915:44825:2226:46552:45479", -- [28]
			"46011:46004", -- [29]
			"37915:44825:2226:46552", -- [30]
			"43573:2851:47121:47133:47116", -- [31]
			"43573:2851:47121:47133", -- [32]
			"43573:2851:47121", -- [33]
			"43573:2851:47121:47133:47156", -- [34]
			"43573:2851:47121:47133:47156:47061", -- [35]
			"43573:2851:47174", -- [36]
			"2389:47644", -- [37]
			"2389:47644:47655", -- [38]
			"2389:47661", -- [39]
			"37915:47665", -- [40]
			"46011:47875", -- [41]
			"43573:2851:2861:3305:47927", -- [42]
			"43573:2851:2861:13177:48321:48318", -- [43]
			"43573:2851:2861:13177:48321", -- [44]
			"37915:44825:50463", -- [45]
			"43573:2851:2861:13177:43086:6026:85734", -- [46]
			--["name"] = "Thondroril River, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 433629293,
			["direct"] = "4551:2389:12636:44232:37915:43573:46011",
			["f"] = 0,
		},
		[47655] = {
			"46552:2226", -- [1]
			"46552:2226:4551", -- [2]
			"47644:2389", -- [3]
			"47644:47661:43104:2851", -- [4]
			"47644:47661:43104:2851:2861:2858", -- [5]
			"47644:47661:43104:2851:2861:1387", -- [6]
			"47644:47661:43104:2851:2861", -- [7]
			"47644:47661:43104:2851:2861:13177:43086:6026", -- [8]
			"47644:2389:37888:12636", -- [9]
			"47644:47661:43104:2851:2861:13177", -- [10]
			"47644:47661:43104:2851:2861:3305", -- [11]
			"47644:2389:4314", -- [12]
			"47644:2389:37888:12636:16189:16192", -- [13]
			"47644:2389:37888:12636:16189", -- [14]
			"47644:2389:37888:44232:44233", -- [15]
			"47644:2389:37888:44232:28621", -- [16]
			"47644:2389:37888:44232:44231:44230", -- [17]
			"47644:2389:37888:44232", -- [18]
			"47644:2389:37888:12636:24851", -- [19]
			"47644:2389:37888:12636:24851:26560", -- [20]
			"47644:2389:37888", -- [21]
			"47644:2389:37915", -- [22]
			"47644:2389:37915:43124", -- [23]
			"47644:47661:43104:2851:2861:1387:43053", -- [24]
			"47644:47661:43104:2851:2861:1387:43052", -- [25]
			"47644:47661:43104:2851:2861:13177:43086", -- [26]
			"47644:47661:43104", -- [27]
			"47644:2389:43573", -- [28]
			"47644:2389:37888:12636:16189:44036", -- [29]
			"47644:2389:37888:44232:44231", -- [30]
			"47644:2389:37888:12636:16189:16192:44244", -- [31]
			"47644:47661:43104:2851:2861:44408", -- [32]
			"47644:47661:43104:2851:2861:44407", -- [33]
			"46552:2226:44825", -- [34]
			"46552:45479", -- [35]
			"47644:2389:37915:46004", -- [36]
			"47644:2389:37915:46004:46011", -- [37]
			"47644:47661:43104:2851:47121:47133:47116", -- [38]
			"47644:47661:43104:2851:47121:47133", -- [39]
			"47644:47661:43104:2851:47121", -- [40]
			"47644:47661:43104:2851:47121:47133:47156", -- [41]
			"47644:47661:43104:2851:47121:47133:47156:47061", -- [42]
			"47644:47661:43104:2851:47174", -- [43]
			"47644:47661", -- [44]
			"47644:2389:47665", -- [45]
			"47644:2389:37915:46004:46011:47875", -- [46]
			"47644:47661:43104:2851:2861:3305:47927", -- [47]
			"47644:47661:43104:2851:2861:13177:48321:48318", -- [48]
			"47644:47661:43104:2851:2861:13177:48321", -- [49]
			"46552:2226:50463", -- [50]
			"47644:47661:43104:2851:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Southpoint Gate, Hillsbrad",
			["m"] = 25,
			["f"] = 0,
			["direct"] = "46552:47644",
			["coord"] = 1249420485,
		},
		[43121] = {
			"6026:43086:13177:2861:2851:2389:2226", -- [1]
			"6026:43086:13177:2861:4551", -- [2]
			"6026:43086:13177:2861:2851:2389", -- [3]
			"6026:43086:13177:2861:2851", -- [4]
			"43114:2858", -- [5]
			"6026:1387", -- [6]
			"6026:43086:13177:2861", -- [7]
			"6026:43086:13177:2861:44407:12636", -- [8]
			"6026:43086:13177", -- [9]
			"6026:43086:13177:3305", -- [10]
			"6026:43086:13177:2861:2851:4314", -- [11]
			"6026:43086:13177:2861:44407:12636:16189:16192", -- [12]
			"6026:43086:13177:2861:44407:12636:16189", -- [13]
			"6026:43086:13177:2861:2851:43573:37888:44232:44233", -- [14]
			"6026:43086:13177:2861:44407:12636:44230:28621", -- [15]
			"6026:43086:13177:2861:44407:12636:44230", -- [16]
			"6026:43086:13177:2861:2851:43573:37888:44232", -- [17]
			"6026:43086:13177:2861:44407:12636:24851", -- [18]
			"6026:43086:13177:2861:44407:12636:24851:26560", -- [19]
			"6026:43086:13177:2861:2851:43573:37888", -- [20]
			"6026:43086:13177:2861:2851:43573:46004:37915", -- [21]
			"6026:43086:13177:2861:2851:43573:46004:37915:43124", -- [22]
			"6026:1387:43053", -- [23]
			"6026:1387:43052", -- [24]
			"6026:43086", -- [25]
			"6026:43086:13177:2861:2851:43104", -- [26]
			"6026:43086:13177:2861:2851:43573", -- [27]
			"6026:43086:13177:2861:44407:12636:16189:44036", -- [28]
			"6026:43086:13177:2861:2851:43573:37888:44232:44231", -- [29]
			"6026:43086:13177:2861:44407:12636:16189:16192:44244", -- [30]
			"6026:43086:13177:2861:44408", -- [31]
			"6026:43086:13177:2861:44407", -- [32]
			"6026:43086:13177:2861:2851:43573:46004:37915:44825", -- [33]
			"6026:43086:13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [34]
			"6026:43086:13177:2861:2851:43573:46004", -- [35]
			"6026:43086:13177:2861:2851:43573:46004:46011", -- [36]
			"6026:43086:13177:2861:2851:43104:47661:47644:47655:46552", -- [37]
			"6026:43086:13177:2861:47121:47133:47116", -- [38]
			"6026:43086:13177:2861:47121:47133", -- [39]
			"6026:43086:13177:2861:47121", -- [40]
			"6026:43086:13177:2861:47121:47133:47156", -- [41]
			"6026:43086:13177:2861:47174:47061", -- [42]
			"6026:43086:13177:2861:47174", -- [43]
			"6026:43086:13177:2861:2851:43104:47661:47644", -- [44]
			"6026:43086:13177:2861:2851:43104:47661:47644:47655", -- [45]
			"6026:43086:13177:2861:2851:43104:47661", -- [46]
			"6026:43086:13177:2861:2851:2389:47665", -- [47]
			"6026:43086:13177:2861:2851:43573:46004:46011:47875", -- [48]
			"6026:43086:13177:48321:48318:47927", -- [49]
			"6026:43086:13177:48321:48318", -- [50]
			"6026:43086:13177:48321", -- [51]
			"6026:43086:13177:2861:2851:43573:46004:37915:44825:50463", -- [52]
			--["name"] = "Dreadmaul Hold, Blasted Lands",
			["m"] = 17,
			["coord"] = 1871324316,
			["direct"] = "6026:43114",
			["f"] = 0,
		},
		[43220] = {
			"4551:2226", -- [1]
			"4551:2389", -- [2]
			"3305:2861:2851", -- [3]
			"3305:13177:1387:2858", -- [4]
			"3305:13177:1387", -- [5]
			"3305:2861", -- [6]
			"3305:13177:43086:6026", -- [7]
			"4551:37888:12636", -- [8]
			"3305:13177", -- [9]
			"3305:2861:2851:4314", -- [10]
			"4551:37888:12636:16189:16192", -- [11]
			"4551:37888:12636:16189", -- [12]
			"4551:37915:46004:46011:47875:44233", -- [13]
			"4551:37888:44232:28621", -- [14]
			"4551:37888:44232:44231:44230", -- [15]
			"4551:37888:44232", -- [16]
			"4551:37888:12636:24851", -- [17]
			"4551:37888:12636:24851:26560", -- [18]
			"4551:37888", -- [19]
			"4551:37915", -- [20]
			"4551:43124", -- [21]
			"3305:13177:1387:43053", -- [22]
			"3305:13177:1387:43052", -- [23]
			"3305:13177:43086", -- [24]
			"3305:2861:2851:43104", -- [25]
			"3305:2861:2851:43573", -- [26]
			"4551:37888:12636:16189:44036", -- [27]
			"4551:37888:44232:44231", -- [28]
			"4551:37888:12636:16189:16192:44244", -- [29]
			"3305:2861:44408", -- [30]
			"3305:2861:44407", -- [31]
			"4551:44825", -- [32]
			"4551:2226:46552:45479", -- [33]
			"4551:37915:46004", -- [34]
			"4551:37915:46004:46011", -- [35]
			"4551:2226:46552", -- [36]
			"3305:2861:47121:47133:47116", -- [37]
			"3305:2861:47121:47133", -- [38]
			"3305:2861:47121", -- [39]
			"3305:2861:47121:47133:47156", -- [40]
			"3305:2861:47174:47061", -- [41]
			"3305:2861:47174", -- [42]
			"4551:2389:47644", -- [43]
			"4551:2226:46552:47655", -- [44]
			"4551:2389:47661", -- [45]
			"4551:37915:47665", -- [46]
			"4551:37915:46004:46011:47875", -- [47]
			"3305:47927", -- [48]
			"3305:47927:48318", -- [49]
			"3305:13177:48321", -- [50]
			"4551:44825:50463", -- [51]
			"3305:13177:43086:6026:85734", -- [52]
			--["name"] = "Sandy Beach, Vashj'ir",
			["m"] = 205,
			["direct"] = "4551:3305",
			["coord"] = 2621458599,
			["f"] = 0,
		},
		[47661] = {
			"2389:2226", -- [1]
			"2389:4551", -- [2]
			"43104:2851", -- [3]
			"43104:2851:2861:2858", -- [4]
			"43104:2851:2861:1387", -- [5]
			"43104:2851:2861", -- [6]
			"43104:2851:2861:13177:43086:6026", -- [7]
			"2389:37888:12636", -- [8]
			"43104:2851:2861:13177", -- [9]
			"43104:2851:2861:3305", -- [10]
			"2389:4314", -- [11]
			"2389:37888:12636:16189:16192", -- [12]
			"2389:37888:12636:16189", -- [13]
			"2389:37888:44232:44233", -- [14]
			"2389:37888:44232:28621", -- [15]
			"2389:37888:44232:44231:44230", -- [16]
			"2389:37888:44232", -- [17]
			"2389:37888:12636:24851", -- [18]
			"2389:37888:12636:24851:26560", -- [19]
			"2389:37888", -- [20]
			"2389:37915", -- [21]
			"2389:37915:43124", -- [22]
			"43104:2851:2861:1387:43053", -- [23]
			"43104:2851:2861:1387:43052", -- [24]
			"43104:2851:2861:13177:43086", -- [25]
			"2389:43573", -- [26]
			"2389:37888:12636:16189:44036", -- [27]
			"2389:37888:44232:44231", -- [28]
			"2389:37888:12636:16189:16192:44244", -- [29]
			"43104:2851:2861:44408", -- [30]
			"43104:2851:2861:44407", -- [31]
			"2389:37915:44825", -- [32]
			"47644:47655:46552:45479", -- [33]
			"2389:37915:46004", -- [34]
			"2389:37915:46004:46011", -- [35]
			"47644:47655:46552", -- [36]
			"43104:2851:47121:47133:47116", -- [37]
			"43104:2851:47121:47133", -- [38]
			"43104:2851:47121", -- [39]
			"43104:2851:47121:47133:47156", -- [40]
			"43104:2851:47121:47133:47156:47061", -- [41]
			"43104:2851:47174", -- [42]
			"47644:47655", -- [43]
			"2389:47665", -- [44]
			"2389:37915:46004:46011:47875", -- [45]
			"43104:2851:2861:3305:47927", -- [46]
			"43104:2851:2861:13177:48321:48318", -- [47]
			"43104:2851:2861:13177:48321", -- [48]
			"2389:2226:50463", -- [49]
			"43104:2851:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Eastpoint Tower, Hillsbrad",
			["m"] = 25,
			["f"] = 0,
			["direct"] = "2389:43104:47644",
			["coord"] = 2562564542,
		},
		[2851] = {
			"2389:2226", -- [1]
			"2861:2858", -- [2]
			"2861:1387", -- [3]
			"2861:13177:43086:6026", -- [4]
			"43573:37888:12636", -- [5]
			"2861:13177", -- [6]
			"2861:3305", -- [7]
			"43573:37888:12636:16189:16192", -- [8]
			"43573:37888:12636:16189", -- [9]
			"43573:37888:44232:44233", -- [10]
			"43573:37888:44232:28621", -- [11]
			"43573:37888:44232:44231:44230", -- [12]
			"43573:37888:44232", -- [13]
			"43573:37888:12636:24851", -- [14]
			"43573:37888:12636:24851:26560", -- [15]
			"43573:37888", -- [16]
			"43573:46004:37915", -- [17]
			"43573:46004:37915:43124", -- [18]
			"2861:1387:43053", -- [19]
			"2861:1387:43052", -- [20]
			"2861:13177:43086", -- [21]
			"43573:37888:12636:16189:44036", -- [22]
			"43573:37888:44232:44231", -- [23]
			"43573:37888:12636:16189:16192:44244", -- [24]
			"2861:44408", -- [25]
			"2861:44407", -- [26]
			"43573:46004:37915:44825", -- [27]
			"43104:47661:47644:47655:46552:45479", -- [28]
			"43573:46004", -- [29]
			"43573:46004:46011", -- [30]
			"43104:47661:47644:47655:46552", -- [31]
			"47121:47133:47116", -- [32]
			"47121:47133", -- [33]
			"47121:47133:47156", -- [34]
			"47121:47133:47156:47061", -- [35]
			"43104:47661:47644", -- [36]
			"43104:47661:47644:47655", -- [37]
			"43104:47661", -- [38]
			"2389:47665", -- [39]
			"43573:46004:46011:47875", -- [40]
			"2861:3305:47927", -- [41]
			"2861:13177:48321:48318", -- [42]
			"2861:13177:48321", -- [43]
			"43573:46004:37915:44825:50463", -- [44]
			"2861:13177:43086:6026:85734", -- [45]
			--["name"] = "Hammerfall, Arathi",
			["m"] = 14,
			["f"] = 0,
			["direct"] = "4551:2389:2861:4314:43104:43573:47121:47174",
			["coord"] = 2927252869,
		},
		[47665] = {
			"2389:2226", -- [1]
			"37915:4551", -- [2]
			"2389:2851", -- [3]
			"2389:2851:2861:2858", -- [4]
			"2389:2851:2861:1387", -- [5]
			"2389:2851:2861", -- [6]
			"2389:2851:2861:13177:43086:6026", -- [7]
			"37915:37888:12636", -- [8]
			"2389:2851:2861:13177", -- [9]
			"2389:2851:2861:3305", -- [10]
			"2389:4314", -- [11]
			"37915:37888:12636:16189:16192", -- [12]
			"37915:37888:12636:16189", -- [13]
			"37915:46004:46011:47875:44233", -- [14]
			"37915:37888:44232:28621", -- [15]
			"37915:37888:44232:44231:44230", -- [16]
			"37915:37888:44232", -- [17]
			"37915:37888:12636:24851", -- [18]
			"37915:37888:12636:24851:26560", -- [19]
			"37915:37888", -- [20]
			"37915:43124", -- [21]
			"2389:2851:2861:1387:43053", -- [22]
			"2389:2851:2861:1387:43052", -- [23]
			"2389:2851:2861:13177:43086", -- [24]
			"2389:43104", -- [25]
			"2389:43573", -- [26]
			"37915:37888:12636:16189:44036", -- [27]
			"37915:37888:44232:44231", -- [28]
			"37915:37888:12636:16189:16192:44244", -- [29]
			"2389:2851:2861:44408", -- [30]
			"2389:2851:2861:44407", -- [31]
			"37915:44825", -- [32]
			"2389:47644:47655:46552:45479", -- [33]
			"37915:46004", -- [34]
			"37915:46004:46011", -- [35]
			"2389:47644:47655:46552", -- [36]
			"2389:2851:47121:47133:47116", -- [37]
			"2389:2851:47121:47133", -- [38]
			"2389:2851:47121", -- [39]
			"2389:2851:47121:47133:47156", -- [40]
			"2389:2851:47121:47133:47156:47061", -- [41]
			"2389:2851:47174", -- [42]
			"2389:47644", -- [43]
			"2389:47644:47655", -- [44]
			"2389:47661", -- [45]
			"37915:46004:46011:47875", -- [46]
			"2389:2851:2861:3305:47927", -- [47]
			"2389:2851:2861:13177:48321:48318", -- [48]
			"2389:2851:2861:13177:48321", -- [49]
			"37915:44825:50463", -- [50]
			"2389:2851:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Strahnbrad, Alterac Mountains",
			["m"] = 25,
			["coord"] = 2499298249,
			["direct"] = "2389:37915",
			["f"] = 0,
		},
		[16189] = {
			"12636:37888:37915:44825:2226", -- [1]
			"12636:37888:4551", -- [2]
			"12636:37888:2389", -- [3]
			"12636:4314:2851", -- [4]
			"12636:44407:2861:2858", -- [5]
			"12636:44407:2861:1387", -- [6]
			"12636:44407:2861", -- [7]
			"12636:44407:2861:13177:43086:6026", -- [8]
			"12636:44407:2861:13177", -- [9]
			"12636:44407:2861:3305", -- [10]
			"12636:4314", -- [11]
			"12636:44230:44233", -- [12]
			"12636:44230:28621", -- [13]
			"12636:44230", -- [14]
			"12636:44231:44232", -- [15]
			"16192:26560", -- [16]
			"12636:37888", -- [17]
			"12636:37888:37915", -- [18]
			"12636:37888:37915:43124", -- [19]
			"12636:44407:2861:1387:43053", -- [20]
			"12636:44407:2861:1387:43052", -- [21]
			"12636:44407:2861:13177:43086", -- [22]
			"12636:37888:2389:43104", -- [23]
			"12636:37888:43573", -- [24]
			"12636:44231", -- [25]
			"16192:44244", -- [26]
			"12636:44407:44408", -- [27]
			"12636:44407", -- [28]
			"12636:37888:37915:44825", -- [29]
			"12636:37888:37915:44825:2226:46552:45479", -- [30]
			"12636:37888:46011:46004", -- [31]
			"12636:37888:46011", -- [32]
			"12636:37888:37915:44825:2226:46552", -- [33]
			"12636:4314:2851:47121:47133:47116", -- [34]
			"12636:4314:2851:47121:47133", -- [35]
			"12636:4314:2851:47121", -- [36]
			"12636:4314:2851:47121:47133:47156", -- [37]
			"12636:4314:2851:47121:47133:47156:47061", -- [38]
			"12636:4314:2851:47174", -- [39]
			"12636:37888:2389:47644", -- [40]
			"12636:37888:2389:47644:47655", -- [41]
			"12636:37888:2389:47661", -- [42]
			"12636:37888:37915:47665", -- [43]
			"12636:44230:44233:47875", -- [44]
			"12636:44407:2861:3305:47927", -- [45]
			"12636:44407:2861:13177:48321:48318", -- [46]
			"12636:44407:2861:13177:48321", -- [47]
			"12636:37888:37915:44825:50463", -- [48]
			"12636:44407:2861:13177:43086:6026:85734", -- [49]
			--["name"] = "Tranquillien, Ghostlands",
			["m"] = 95,
			["coord"] = 1953517111,
			["direct"] = "12636:16192:24851:44036",
			["f"] = 0,
		},
		[50463] = {
			"44825:4551", -- [1]
			"2226:2389", -- [2]
			"2226:2389:2851", -- [3]
			"2226:2389:2851:2861:2858", -- [4]
			"2226:2389:2851:2861:1387", -- [5]
			"2226:2389:2851:2861", -- [6]
			"2226:2389:2851:2861:13177:43086:6026", -- [7]
			"44825:37915:37888:12636", -- [8]
			"2226:2389:2851:2861:13177", -- [9]
			"2226:2389:2851:2861:3305", -- [10]
			"2226:2389:4314", -- [11]
			"44825:37915:37888:12636:16189:16192", -- [12]
			"44825:37915:37888:12636:16189", -- [13]
			"44825:37915:46004:46011:47875:44233", -- [14]
			"44825:37915:37888:44232:28621", -- [15]
			"44825:37915:37888:44232:44231:44230", -- [16]
			"44825:37915:37888:44232", -- [17]
			"44825:37915:37888:12636:24851", -- [18]
			"44825:37915:37888:12636:24851:26560", -- [19]
			"44825:37915:37888", -- [20]
			"44825:37915", -- [21]
			"44825:43124", -- [22]
			"2226:2389:2851:2861:1387:43053", -- [23]
			"2226:2389:2851:2861:1387:43052", -- [24]
			"2226:2389:2851:2861:13177:43086", -- [25]
			"2226:2389:43104", -- [26]
			"44825:37915:46004:43573", -- [27]
			"44825:37915:37888:12636:16189:44036", -- [28]
			"44825:37915:37888:44232:44231", -- [29]
			"44825:37915:37888:12636:16189:16192:44244", -- [30]
			"2226:2389:2851:2861:44408", -- [31]
			"2226:2389:2851:2861:44407", -- [32]
			"2226:46552:45479", -- [33]
			"44825:37915:46004", -- [34]
			"44825:37915:46004:46011", -- [35]
			"2226:46552", -- [36]
			"2226:2389:2851:47121:47133:47116", -- [37]
			"2226:2389:2851:47121:47133", -- [38]
			"2226:2389:2851:47121", -- [39]
			"2226:2389:2851:47121:47133:47156", -- [40]
			"2226:2389:2851:47121:47133:47156:47061", -- [41]
			"2226:2389:2851:47174", -- [42]
			"2226:46552:47655:47644", -- [43]
			"2226:46552:47655", -- [44]
			"2226:46552:47655:47644:47661", -- [45]
			"44825:37915:47665", -- [46]
			"44825:37915:46004:46011:47875", -- [47]
			"2226:2389:2851:2861:3305:47927", -- [48]
			"2226:2389:2851:2861:13177:48321:48318", -- [49]
			"2226:2389:2851:2861:13177:48321", -- [50]
			"2226:2389:2851:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Forsaken Rear Guard, Silverpine Forest",
			["m"] = 21,
			["f"] = 0,
			["direct"] = "2226:44825",
			["coord"] = 1971861489,
		},
		[43053] = {
			"1387:2861:2851:2389:2226", -- [1]
			"1387:2861:4551", -- [2]
			"1387:2861:2851:2389", -- [3]
			"1387:2861:2851", -- [4]
			"1387:2861", -- [5]
			"1387:6026", -- [6]
			"1387:2861:44407:12636", -- [7]
			"1387:13177", -- [8]
			"1387:13177:3305", -- [9]
			"1387:2861:2851:4314", -- [10]
			"1387:2861:44407:12636:16189:16192", -- [11]
			"1387:2861:44407:12636:16189", -- [12]
			"1387:2861:2851:43573:37888:44232:44233", -- [13]
			"1387:2861:44407:12636:44230:28621", -- [14]
			"1387:2861:44407:12636:44230", -- [15]
			"1387:2861:2851:43573:37888:44232", -- [16]
			"1387:2861:44407:12636:24851", -- [17]
			"1387:2861:44407:12636:24851:26560", -- [18]
			"1387:2861:2851:43573:37888", -- [19]
			"1387:2861:2851:43573:46004:37915", -- [20]
			"1387:2861:2851:43573:46004:37915:43124", -- [21]
			"1387:6026:43086", -- [22]
			"1387:2861:2851:43104", -- [23]
			"1387:2861:2851:43573", -- [24]
			"1387:2861:44407:12636:16189:44036", -- [25]
			"1387:2861:2851:43573:37888:44232:44231", -- [26]
			"1387:2861:44407:12636:16189:16192:44244", -- [27]
			"1387:2861:44408", -- [28]
			"1387:2861:44407", -- [29]
			"1387:2861:2851:43573:46004:37915:44825", -- [30]
			"1387:2861:2851:43104:47661:47644:47655:46552:45479", -- [31]
			"1387:2861:2851:43573:46004", -- [32]
			"1387:2861:2851:43573:46004:46011", -- [33]
			"1387:2861:2851:43104:47661:47644:47655:46552", -- [34]
			"1387:2861:47121:47133:47116", -- [35]
			"1387:2861:47121:47133", -- [36]
			"1387:2861:47121", -- [37]
			"1387:2861:47121:47133:47156", -- [38]
			"1387:2861:47174:47061", -- [39]
			"1387:2861:47174", -- [40]
			"1387:2861:2851:43104:47661:47644", -- [41]
			"1387:2861:2851:43104:47661:47644:47655", -- [42]
			"1387:2861:2851:43104:47661", -- [43]
			"1387:2861:2851:2389:47665", -- [44]
			"1387:2861:2851:43573:46004:46011:47875", -- [45]
			"1387:13177:48321:48318:47927", -- [46]
			"1387:13177:48321:48318", -- [47]
			"1387:13177:48321", -- [48]
			"1387:2861:2851:43573:46004:37915:44825:50463", -- [49]
			"43052:85734", -- [50]
			--["name"] = "Hardwrench Hideaway, Stranglethorn",
			["m"] = 210,
			["f"] = 0,
			["direct"] = "2858:1387:43052",
			["coord"] = 1508985618,
		},
		[85734] = {
			"6026:43086:13177:2861:2851:2389:2226", -- [1]
			"6026:43086:13177:2861:4551", -- [2]
			"6026:43086:13177:2861:2851:2389", -- [3]
			"6026:43086:13177:2861:2851", -- [4]
			"43052:43053:2858", -- [5]
			"43052:1387", -- [6]
			"6026:43086:13177:2861", -- [7]
			"6026:43086:13177:2861:44407:12636", -- [8]
			"6026:43086:13177", -- [9]
			"6026:43086:13177:3305", -- [10]
			"6026:43086:13177:2861:2851:4314", -- [11]
			"6026:43086:13177:2861:44407:12636:16189:16192", -- [12]
			"6026:43086:13177:2861:44407:12636:16189", -- [13]
			"6026:43086:13177:2861:2851:43573:37888:44232:44233", -- [14]
			"6026:43086:13177:2861:44407:12636:44230:28621", -- [15]
			"6026:43086:13177:2861:44407:12636:44230", -- [16]
			"6026:43086:13177:2861:2851:43573:37888:44232", -- [17]
			"6026:43086:13177:2861:44407:12636:24851", -- [18]
			"6026:43086:13177:2861:44407:12636:24851:26560", -- [19]
			"6026:43086:13177:2861:2851:43573:37888", -- [20]
			"6026:43086:13177:2861:2851:43573:46004:37915", -- [21]
			"6026:43086:13177:2861:2851:43573:46004:37915:43124", -- [22]
			"43052:43053", -- [23]
			"6026:43086", -- [24]
			"6026:43086:13177:2861:2851:43104", -- [25]
			"6026:43086:13177:2861:2851:43573", -- [26]
			"6026:43086:13177:2861:44407:12636:16189:44036", -- [27]
			"6026:43086:13177:2861:2851:43573:37888:44232:44231", -- [28]
			"6026:43086:13177:2861:44407:12636:16189:16192:44244", -- [29]
			"6026:43086:13177:2861:44408", -- [30]
			"6026:43086:13177:2861:44407", -- [31]
			"6026:43086:13177:2861:2851:43573:46004:37915:44825", -- [32]
			"6026:43086:13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [33]
			"6026:43086:13177:2861:2851:43573:46004", -- [34]
			"6026:43086:13177:2861:2851:43573:46004:46011", -- [35]
			"6026:43086:13177:2861:2851:43104:47661:47644:47655:46552", -- [36]
			"6026:43086:13177:2861:47121:47133:47116", -- [37]
			"6026:43086:13177:2861:47121:47133", -- [38]
			"6026:43086:13177:2861:47121", -- [39]
			"6026:43086:13177:2861:47121:47133:47156", -- [40]
			"6026:43086:13177:2861:47174:47061", -- [41]
			"6026:43086:13177:2861:47174", -- [42]
			"6026:43086:13177:2861:2851:43104:47661:47644", -- [43]
			"6026:43086:13177:2861:2851:43104:47661:47644:47655", -- [44]
			"6026:43086:13177:2861:2851:43104:47661", -- [45]
			"6026:43086:13177:2861:2851:2389:47665", -- [46]
			"6026:43086:13177:2861:2851:43573:46004:46011:47875", -- [47]
			"6026:43086:13177:48321:48318:47927", -- [48]
			"6026:43086:13177:48321:48318", -- [49]
			"6026:43086:13177:48321", -- [50]
			"6026:43086:13177:2861:2851:43573:46004:37915:44825:50463", -- [51]
			--["name"] = "Shattered Landing, Blasted Lands",
			["m"] = 17,
			["coord"] = 3131014275,
			["direct"] = "6026:43052",
			["f"] = 0,
		},
		[47927] = {
			"3305:2861:2851:2389:2226", -- [1]
			"3305:43220:4551", -- [2]
			"3305:2861:2851:2389", -- [3]
			"3305:2861:2851", -- [4]
			"3305:13177:1387:2858", -- [5]
			"3305:13177:1387", -- [6]
			"3305:2861", -- [7]
			"3305:13177:43086:6026", -- [8]
			"3305:2861:44407:12636", -- [9]
			"3305:13177", -- [10]
			"3305:2861:2851:4314", -- [11]
			"3305:2861:44407:12636:16189:16192", -- [12]
			"3305:2861:44407:12636:16189", -- [13]
			"3305:2861:2851:43573:37888:44232:44233", -- [14]
			"3305:2861:44407:12636:44230:28621", -- [15]
			"3305:2861:44407:12636:44230", -- [16]
			"3305:2861:2851:43573:37888:44232", -- [17]
			"3305:2861:44407:12636:24851", -- [18]
			"3305:2861:44407:12636:24851:26560", -- [19]
			"3305:2861:2851:43573:37888", -- [20]
			"3305:2861:2851:43573:46004:37915", -- [21]
			"3305:2861:2851:43573:46004:37915:43124", -- [22]
			"3305:13177:1387:43053", -- [23]
			"3305:13177:1387:43052", -- [24]
			"3305:13177:43086", -- [25]
			"3305:2861:2851:43104", -- [26]
			"3305:2861:2851:43573", -- [27]
			"3305:2861:44407:12636:16189:44036", -- [28]
			"3305:2861:2851:43573:37888:44232:44231", -- [29]
			"3305:2861:44407:12636:16189:16192:44244", -- [30]
			"3305:2861:44408", -- [31]
			"3305:2861:44407", -- [32]
			"3305:2861:2851:43573:46004:37915:44825", -- [33]
			"3305:2861:2851:43104:47661:47644:47655:46552:45479", -- [34]
			"3305:2861:2851:43573:46004", -- [35]
			"3305:2861:2851:43573:46004:46011", -- [36]
			"3305:2861:2851:43104:47661:47644:47655:46552", -- [37]
			"3305:2861:47121:47133:47116", -- [38]
			"3305:2861:47121:47133", -- [39]
			"3305:2861:47121", -- [40]
			"3305:2861:47121:47133:47156", -- [41]
			"3305:2861:47174:47061", -- [42]
			"3305:2861:47174", -- [43]
			"3305:2861:2851:43104:47661:47644", -- [44]
			"3305:2861:2851:43104:47661:47644:47655", -- [45]
			"3305:2861:2851:43104:47661", -- [46]
			"3305:2861:2851:2389:47665", -- [47]
			"3305:2861:2851:43573:46004:46011:47875", -- [48]
			"48318:48321", -- [49]
			"3305:2861:2851:43573:46004:37915:44825:50463", -- [50]
			"3305:13177:43086:6026:85734", -- [51]
			--["name"] = "Iron Summit, Searing Gorge",
			["m"] = 32,
			["coord"] = 1758769171,
			["direct"] = "3305:48318",
			["f"] = 0,
		},
		[47116] = {
			"47133:47121:2851:2389:2226", -- [1]
			"47133:47121:2851:43573:46004:37915:4551", -- [2]
			"47133:47121:2851:2389", -- [3]
			"47133:47121:2851", -- [4]
			"47133:47121:2861:2858", -- [5]
			"47133:47121:2861:1387", -- [6]
			"47133:47121:2861", -- [7]
			"47133:47121:2861:13177:43086:6026", -- [8]
			"47133:47121:2851:43573:37888:12636", -- [9]
			"47133:47121:2861:13177", -- [10]
			"47133:47121:2861:3305", -- [11]
			"47133:47121:2851:4314", -- [12]
			"47133:47121:2851:43573:37888:12636:16189:16192", -- [13]
			"47133:47121:2851:43573:37888:12636:16189", -- [14]
			"47133:47121:2851:43573:37888:44232:44233", -- [15]
			"47133:47121:2851:43573:37888:44232:28621", -- [16]
			"47133:47121:2851:43573:37888:44232:44231:44230", -- [17]
			"47133:47121:2851:43573:37888:44232", -- [18]
			"47133:47121:2851:43573:37888:12636:24851", -- [19]
			"47133:47121:2851:43573:37888:12636:24851:26560", -- [20]
			"47133:47121:2851:43573:37888", -- [21]
			"47133:47121:2851:43573:46004:37915", -- [22]
			"47133:47121:2851:43573:46004:37915:43124", -- [23]
			"47133:47121:2861:1387:43053", -- [24]
			"47133:47121:2861:1387:43052", -- [25]
			"47133:47121:2861:13177:43086", -- [26]
			"47133:47121:2851:43104", -- [27]
			"47133:47121:2851:43573", -- [28]
			"47133:47121:2851:43573:37888:12636:16189:44036", -- [29]
			"47133:47121:2851:43573:37888:44232:44231", -- [30]
			"47133:47121:2851:43573:37888:12636:16189:16192:44244", -- [31]
			"47133:47121:2861:44408", -- [32]
			"47133:47121:2861:44407", -- [33]
			"47133:47121:2851:43573:46004:37915:44825", -- [34]
			"47133:47121:2851:43104:47661:47644:47655:46552:45479", -- [35]
			"47133:47121:2851:43573:46004", -- [36]
			"47133:47121:2851:43573:46004:46011", -- [37]
			"47133:47121:2851:43104:47661:47644:47655:46552", -- [38]
			"47133:47121", -- [39]
			"47156:47061", -- [40]
			"47133:47121:2851:43104:47661:47644", -- [41]
			"47133:47121:2851:43104:47661:47644:47655", -- [42]
			"47133:47121:2851:43104:47661", -- [43]
			"47133:47121:2851:2389:47665", -- [44]
			"47133:47121:2851:43573:46004:46011:47875", -- [45]
			"47133:47121:2861:3305:47927", -- [46]
			"47133:47121:2861:13177:48321:48318", -- [47]
			"47133:47121:2861:13177:48321", -- [48]
			"47133:47121:2851:43573:46004:37915:44825:50463", -- [49]
			"47133:47121:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Crushblow, Twilight Highlands",
			["m"] = 241,
			["f"] = 0,
			["direct"] = "47133:47156:47174",
			["coord"] = 1965474545,
		},
		[16192] = {
			"16189:12636:37888:37915:44825:2226", -- [1]
			"16189:12636:37888:4551", -- [2]
			"16189:12636:37888:2389", -- [3]
			"16189:12636:4314:2851", -- [4]
			"16189:12636:44407:2861:2858", -- [5]
			"16189:12636:44407:2861:1387", -- [6]
			"16189:12636:44407:2861", -- [7]
			"16189:12636:44407:2861:13177:43086:6026", -- [8]
			"16189:12636", -- [9]
			"16189:12636:44407:2861:13177", -- [10]
			"16189:12636:44407:2861:3305", -- [11]
			"16189:12636:4314", -- [12]
			"16189:12636:44230:44233", -- [13]
			"16189:12636:44230:28621", -- [14]
			"16189:12636:44230", -- [15]
			"16189:12636:44231:44232", -- [16]
			"16189:24851", -- [17]
			"16189:12636:37888", -- [18]
			"16189:12636:37888:37915", -- [19]
			"16189:12636:37888:37915:43124", -- [20]
			"16189:12636:44407:2861:1387:43053", -- [21]
			"16189:12636:44407:2861:1387:43052", -- [22]
			"16189:12636:44407:2861:13177:43086", -- [23]
			"16189:12636:37888:2389:43104", -- [24]
			"16189:12636:37888:43573", -- [25]
			"16189:12636:44231", -- [26]
			"16189:12636:44407:44408", -- [27]
			"16189:12636:44407", -- [28]
			"16189:12636:37888:37915:44825", -- [29]
			"16189:12636:37888:37915:44825:2226:46552:45479", -- [30]
			"16189:12636:37888:46011:46004", -- [31]
			"16189:12636:37888:46011", -- [32]
			"16189:12636:37888:37915:44825:2226:46552", -- [33]
			"16189:12636:4314:2851:47121:47133:47116", -- [34]
			"16189:12636:4314:2851:47121:47133", -- [35]
			"16189:12636:4314:2851:47121", -- [36]
			"16189:12636:4314:2851:47121:47133:47156", -- [37]
			"16189:12636:4314:2851:47121:47133:47156:47061", -- [38]
			"16189:12636:4314:2851:47174", -- [39]
			"16189:12636:37888:2389:47644", -- [40]
			"16189:12636:37888:2389:47644:47655", -- [41]
			"16189:12636:37888:2389:47661", -- [42]
			"16189:12636:37888:37915:47665", -- [43]
			"16189:12636:44230:44233:47875", -- [44]
			"16189:12636:44407:2861:3305:47927", -- [45]
			"16189:12636:44407:2861:13177:48321:48318", -- [46]
			"16189:12636:44407:2861:13177:48321", -- [47]
			"16189:12636:37888:37915:44825:50463", -- [48]
			"16189:12636:44407:2861:13177:43086:6026:85734", -- [49]
			--["name"] = "Silvermoon City",
			["m"] = 94,
			["coord"] = 2335736303,
			["direct"] = "16189:26560:44036:44244",
			["f"] = 0,
		},
		[44407] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"2861:2858", -- [5]
			"2861:1387", -- [6]
			"2861:13177:43086:6026", -- [7]
			"2861:13177", -- [8]
			"2861:3305", -- [9]
			"2861:2851:4314", -- [10]
			"12636:16189:16192", -- [11]
			"12636:16189", -- [12]
			"12636:44230:44233", -- [13]
			"12636:44230:28621", -- [14]
			"12636:44230", -- [15]
			"12636:44231:44232", -- [16]
			"12636:24851", -- [17]
			"12636:24851:26560", -- [18]
			"2861:2851:43573:37888", -- [19]
			"2861:2851:43573:46004:37915", -- [20]
			"2861:2851:43573:46004:37915:43124", -- [21]
			"2861:1387:43053", -- [22]
			"2861:1387:43052", -- [23]
			"2861:13177:43086", -- [24]
			"2861:2851:43104", -- [25]
			"2861:2851:43573", -- [26]
			"12636:16189:44036", -- [27]
			"12636:44231", -- [28]
			"12636:16189:16192:44244", -- [29]
			"2861:2851:43573:46004:37915:44825", -- [30]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [31]
			"2861:2851:43573:46004", -- [32]
			"2861:2851:43573:46004:46011", -- [33]
			"2861:2851:43104:47661:47644:47655:46552", -- [34]
			"2861:47121:47133:47116", -- [35]
			"2861:47121:47133", -- [36]
			"2861:47121", -- [37]
			"2861:47121:47133:47156", -- [38]
			"2861:47174:47061", -- [39]
			"2861:47174", -- [40]
			"2861:2851:43104:47661:47644", -- [41]
			"2861:2851:43104:47661:47644:47655", -- [42]
			"2861:2851:43104:47661", -- [43]
			"2861:2851:2389:47665", -- [44]
			"2861:2851:43573:46004:46011:47875", -- [45]
			"2861:3305:47927", -- [46]
			"2861:13177:48321:48318", -- [47]
			"2861:13177:48321", -- [48]
			"2861:2851:43573:46004:37915:44825:50463", -- [49]
			"2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Fuselight, Badlands",
			["m"] = 15,
			["f"] = 0,
			["direct"] = "2861:12636:44408",
			["coord"] = 2759481903,
		},
		[1387] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"2861:44407:12636", -- [5]
			"13177:3305", -- [6]
			"2861:2851:4314", -- [7]
			"2861:44407:12636:16189:16192", -- [8]
			"2861:44407:12636:16189", -- [9]
			"2861:2851:43573:37888:44232:44233", -- [10]
			"2861:44407:12636:44230:28621", -- [11]
			"2861:44407:12636:44230", -- [12]
			"2861:2851:43573:37888:44232", -- [13]
			"2861:44407:12636:24851", -- [14]
			"2861:44407:12636:24851:26560", -- [15]
			"2861:2851:43573:37888", -- [16]
			"2861:2851:43573:46004:37915", -- [17]
			"2861:2851:43573:46004:37915:43124", -- [18]
			"6026:43086", -- [19]
			"2861:2851:43104", -- [20]
			"2861:2851:43573", -- [21]
			"2861:44407:12636:16189:44036", -- [22]
			"2861:2851:43573:37888:44232:44231", -- [23]
			"2861:44407:12636:16189:16192:44244", -- [24]
			"2861:44408", -- [25]
			"2861:44407", -- [26]
			"2861:2851:43573:46004:37915:44825", -- [27]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [28]
			"2861:2851:43573:46004", -- [29]
			"2861:2851:43573:46004:46011", -- [30]
			"2861:2851:43104:47661:47644:47655:46552", -- [31]
			"2861:47121:47133:47116", -- [32]
			"2861:47121:47133", -- [33]
			"2861:47121", -- [34]
			"2861:47121:47133:47156", -- [35]
			"2861:47174:47061", -- [36]
			"2861:47174", -- [37]
			"2861:2851:43104:47661:47644", -- [38]
			"2861:2851:43104:47661:47644:47655", -- [39]
			"2861:2851:43104:47661", -- [40]
			"2861:2851:2389:47665", -- [41]
			"2861:2851:43573:46004:46011:47875", -- [42]
			"13177:48321:48318:47927", -- [43]
			"13177:48321:48318", -- [44]
			"13177:48321", -- [45]
			"2861:2851:43573:46004:37915:44825:50463", -- [46]
			"43052:85734", -- [47]
			--["name"] = "Grom'gol, Stranglethorn",
			["m"] = 50,
			["f"] = 0,
			["direct"] = "2858:2861:6026:13177:43053:43052",
			["coord"] = 1673429731,
		},
		[43086] = {
			"13177:2861:2851:2389:2226", -- [1]
			"13177:2861:4551", -- [2]
			"13177:2861:2851:2389", -- [3]
			"13177:2861:2851", -- [4]
			"6026:2858", -- [5]
			"6026:1387", -- [6]
			"13177:2861", -- [7]
			"13177:2861:44407:12636", -- [8]
			"13177:3305", -- [9]
			"13177:2861:2851:4314", -- [10]
			"13177:2861:44407:12636:16189:16192", -- [11]
			"13177:2861:44407:12636:16189", -- [12]
			"13177:2861:2851:43573:37888:44232:44233", -- [13]
			"13177:2861:44407:12636:44230:28621", -- [14]
			"13177:2861:44407:12636:44230", -- [15]
			"13177:2861:2851:43573:37888:44232", -- [16]
			"13177:2861:44407:12636:24851", -- [17]
			"13177:2861:44407:12636:24851:26560", -- [18]
			"13177:2861:2851:43573:37888", -- [19]
			"13177:2861:2851:43573:46004:37915", -- [20]
			"13177:2861:2851:43573:46004:37915:43124", -- [21]
			"6026:1387:43053", -- [22]
			"6026:85734:43052", -- [23]
			"13177:2861:2851:43104", -- [24]
			"13177:2861:2851:43573", -- [25]
			"13177:2861:44407:12636:16189:44036", -- [26]
			"13177:2861:2851:43573:37888:44232:44231", -- [27]
			"13177:2861:44407:12636:16189:16192:44244", -- [28]
			"13177:2861:44408", -- [29]
			"13177:2861:44407", -- [30]
			"13177:2861:2851:43573:46004:37915:44825", -- [31]
			"13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [32]
			"13177:2861:2851:43573:46004", -- [33]
			"13177:2861:2851:43573:46004:46011", -- [34]
			"13177:2861:2851:43104:47661:47644:47655:46552", -- [35]
			"13177:2861:47121:47133:47116", -- [36]
			"13177:2861:47121:47133", -- [37]
			"13177:2861:47121", -- [38]
			"13177:2861:47121:47133:47156", -- [39]
			"13177:2861:47174:47061", -- [40]
			"13177:2861:47174", -- [41]
			"13177:2861:2851:43104:47661:47644", -- [42]
			"13177:2861:2851:43104:47661:47644:47655", -- [43]
			"13177:2861:2851:43104:47661", -- [44]
			"13177:2861:2851:2389:47665", -- [45]
			"13177:2861:2851:43573:46004:46011:47875", -- [46]
			"13177:48321:48318:47927", -- [47]
			"13177:48321:48318", -- [48]
			"13177:48321", -- [49]
			"13177:2861:2851:43573:46004:37915:44825:50463", -- [50]
			"6026:85734", -- [51]
			--["name"] = "Bogpaddle, Swamp of Sorrows",
			["m"] = 51,
			["f"] = 0,
			["direct"] = "6026:13177",
			["coord"] = 3096714937,
		},
		[2226] = {
			"2389:2851", -- [1]
			"2389:2851:2861:2858", -- [2]
			"2389:2851:2861:1387", -- [3]
			"2389:2851:2861", -- [4]
			"2389:2851:2861:13177:43086:6026", -- [5]
			"44825:37915:37888:12636", -- [6]
			"2389:2851:2861:13177", -- [7]
			"2389:2851:2861:3305", -- [8]
			"2389:4314", -- [9]
			"44825:37915:37888:12636:16189:16192", -- [10]
			"44825:37915:37888:12636:16189", -- [11]
			"44825:37915:46004:46011:47875:44233", -- [12]
			"44825:37915:37888:44232:28621", -- [13]
			"44825:37915:37888:44232:44231:44230", -- [14]
			"44825:37915:37888:44232", -- [15]
			"44825:37915:37888:12636:24851", -- [16]
			"44825:37915:37888:12636:24851:26560", -- [17]
			"44825:37915:37888", -- [18]
			"44825:37915", -- [19]
			"44825:43124", -- [20]
			"2389:2851:2861:1387:43053", -- [21]
			"2389:2851:2861:1387:43052", -- [22]
			"2389:2851:2861:13177:43086", -- [23]
			"2389:43104", -- [24]
			"2389:43573", -- [25]
			"44825:37915:37888:12636:16189:44036", -- [26]
			"44825:37915:37888:44232:44231", -- [27]
			"44825:37915:37888:12636:16189:16192:44244", -- [28]
			"2389:2851:2861:44408", -- [29]
			"2389:2851:2861:44407", -- [30]
			"44825:37915:46004", -- [31]
			"44825:37915:46004:46011", -- [32]
			"2389:2851:47121:47133:47116", -- [33]
			"2389:2851:47121:47133", -- [34]
			"2389:2851:47121", -- [35]
			"2389:2851:47121:47133:47156", -- [36]
			"2389:2851:47121:47133:47156:47061", -- [37]
			"2389:2851:47174", -- [38]
			"46552:47655:47644", -- [39]
			"46552:47655", -- [40]
			"46552:47655:47644:47661", -- [41]
			"2389:47665", -- [42]
			"44825:37915:46004:46011:47875", -- [43]
			"2389:2851:2861:3305:47927", -- [44]
			"2389:2851:2861:13177:48321:48318", -- [45]
			"2389:2851:2861:13177:48321", -- [46]
			"2389:2851:2861:13177:43086:6026:85734", -- [47]
			--["name"] = "The Sepulcher, Silverpine Forest",
			["m"] = 21,
			["f"] = 0,
			["direct"] = "4551:2389:44825:45479:46552:50463",
			["coord"] = 1953000628,
		},
		[47061] = {
			"47174:2851:2389:2226", -- [1]
			"47174:2851:43573:46004:37915:4551", -- [2]
			"47174:2851:2389", -- [3]
			"47174:2851", -- [4]
			"47174:2861:2858", -- [5]
			"47174:2861:1387", -- [6]
			"47174:2861", -- [7]
			"47174:2861:13177:43086:6026", -- [8]
			"47174:2851:43573:37888:12636", -- [9]
			"47174:2861:13177", -- [10]
			"47174:2861:3305", -- [11]
			"47174:2851:4314", -- [12]
			"47174:2851:43573:37888:12636:16189:16192", -- [13]
			"47174:2851:43573:37888:12636:16189", -- [14]
			"47174:2851:43573:37888:44232:44233", -- [15]
			"47174:2851:43573:37888:44232:28621", -- [16]
			"47174:2851:43573:37888:44232:44231:44230", -- [17]
			"47174:2851:43573:37888:44232", -- [18]
			"47174:2851:43573:37888:12636:24851", -- [19]
			"47174:2851:43573:37888:12636:24851:26560", -- [20]
			"47174:2851:43573:37888", -- [21]
			"47174:2851:43573:46004:37915", -- [22]
			"47174:2851:43573:46004:37915:43124", -- [23]
			"47174:2861:1387:43053", -- [24]
			"47174:2861:1387:43052", -- [25]
			"47174:2861:13177:43086", -- [26]
			"47174:2851:43104", -- [27]
			"47174:2851:43573", -- [28]
			"47174:2851:43573:37888:12636:16189:44036", -- [29]
			"47174:2851:43573:37888:44232:44231", -- [30]
			"47174:2851:43573:37888:12636:16189:16192:44244", -- [31]
			"47174:2861:44408", -- [32]
			"47174:2861:44407", -- [33]
			"47174:2851:43573:46004:37915:44825", -- [34]
			"47174:2851:43104:47661:47644:47655:46552:45479", -- [35]
			"47174:2851:43573:46004", -- [36]
			"47174:2851:43573:46004:46011", -- [37]
			"47174:2851:43104:47661:47644:47655:46552", -- [38]
			"47174:47116", -- [39]
			"47156:47133", -- [40]
			"47156:47133:47121", -- [41]
			"47174:2851:43104:47661:47644", -- [42]
			"47174:2851:43104:47661:47644:47655", -- [43]
			"47174:2851:43104:47661", -- [44]
			"47174:2851:2389:47665", -- [45]
			"47174:2851:43573:46004:46011:47875", -- [46]
			"47174:2861:3305:47927", -- [47]
			"47174:2861:13177:48321:48318", -- [48]
			"47174:2861:13177:48321", -- [49]
			"47174:2851:43573:46004:37915:44825:50463", -- [50]
			"47174:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "The Krazzworks, Twilight Highlands",
			["m"] = 241,
			["f"] = 0,
			["direct"] = "47156:47174",
			["coord"] = 3236441458,
		},
		[48321] = {
			"13177:2861:2851:2389:2226", -- [1]
			"13177:2861:4551", -- [2]
			"13177:2861:2851:2389", -- [3]
			"13177:2861:2851", -- [4]
			"13177:1387:2858", -- [5]
			"13177:1387", -- [6]
			"13177:2861", -- [7]
			"13177:43086:6026", -- [8]
			"13177:2861:44407:12636", -- [9]
			"13177:3305", -- [10]
			"13177:2861:2851:4314", -- [11]
			"13177:2861:44407:12636:16189:16192", -- [12]
			"13177:2861:44407:12636:16189", -- [13]
			"13177:2861:2851:43573:37888:44232:44233", -- [14]
			"13177:2861:44407:12636:44230:28621", -- [15]
			"13177:2861:44407:12636:44230", -- [16]
			"13177:2861:2851:43573:37888:44232", -- [17]
			"13177:2861:44407:12636:24851", -- [18]
			"13177:2861:44407:12636:24851:26560", -- [19]
			"13177:2861:2851:43573:37888", -- [20]
			"13177:2861:2851:43573:46004:37915", -- [21]
			"13177:2861:2851:43573:46004:37915:43124", -- [22]
			"13177:1387:43053", -- [23]
			"13177:1387:43052", -- [24]
			"13177:43086", -- [25]
			"13177:2861:2851:43104", -- [26]
			"13177:2861:2851:43573", -- [27]
			"13177:2861:44407:12636:16189:44036", -- [28]
			"13177:2861:2851:43573:37888:44232:44231", -- [29]
			"13177:2861:44407:12636:16189:16192:44244", -- [30]
			"13177:2861:44408", -- [31]
			"13177:2861:44407", -- [32]
			"13177:2861:2851:43573:46004:37915:44825", -- [33]
			"13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [34]
			"13177:2861:2851:43573:46004", -- [35]
			"13177:2861:2851:43573:46004:46011", -- [36]
			"13177:2861:2851:43104:47661:47644:47655:46552", -- [37]
			"13177:2861:47121:47133:47116", -- [38]
			"13177:2861:47121:47133", -- [39]
			"13177:2861:47121", -- [40]
			"13177:2861:47121:47133:47156", -- [41]
			"13177:2861:47174:47061", -- [42]
			"13177:2861:47174", -- [43]
			"13177:2861:2851:43104:47661:47644", -- [44]
			"13177:2861:2851:43104:47661:47644:47655", -- [45]
			"13177:2861:2851:43104:47661", -- [46]
			"13177:2861:2851:2389:47665", -- [47]
			"13177:2861:2851:43573:46004:46011:47875", -- [48]
			"48318:47927", -- [49]
			"13177:2861:2851:43573:46004:37915:44825:50463", -- [50]
			"13177:43086:6026:85734", -- [51]
			--["name"] = "Chiselgrip, Burning Steppes",
			["m"] = 36,
			["f"] = 0,
			["direct"] = "13177:48318",
			["coord"] = 1982425941,
		},
		[12636] = {
			"37888:37915:44825:2226", -- [1]
			"37888:2389", -- [2]
			"4314:2851", -- [3]
			"44407:2861:2858", -- [4]
			"44407:2861:1387", -- [5]
			"44407:2861", -- [6]
			"44407:2861:13177:43086:6026", -- [7]
			"44407:2861:13177", -- [8]
			"44407:2861:3305", -- [9]
			"16189:16192", -- [10]
			"44230:44233", -- [11]
			"44230:28621", -- [12]
			"44231:44232", -- [13]
			"24851:26560", -- [14]
			"37888:37915", -- [15]
			"37888:37915:43124", -- [16]
			"44407:2861:1387:43053", -- [17]
			"44407:2861:1387:43052", -- [18]
			"44407:2861:13177:43086", -- [19]
			"37888:2389:43104", -- [20]
			"37888:43573", -- [21]
			"16189:44036", -- [22]
			"16189:16192:44244", -- [23]
			"44407:44408", -- [24]
			"37888:37915:44825", -- [25]
			"37888:37915:44825:2226:46552:45479", -- [26]
			"37888:46011:46004", -- [27]
			"37888:46011", -- [28]
			"37888:37915:44825:2226:46552", -- [29]
			"4314:2851:47121:47133:47116", -- [30]
			"4314:2851:47121:47133", -- [31]
			"4314:2851:47121", -- [32]
			"4314:2851:47121:47133:47156", -- [33]
			"4314:2851:47121:47133:47156:47061", -- [34]
			"4314:2851:47174", -- [35]
			"37888:2389:47644", -- [36]
			"37888:2389:47644:47655", -- [37]
			"37888:2389:47661", -- [38]
			"37888:37915:47665", -- [39]
			"44230:44233:47875", -- [40]
			"44407:2861:3305:47927", -- [41]
			"44407:2861:13177:48321:48318", -- [42]
			"44407:2861:13177:48321", -- [43]
			"37888:37915:44825:50463", -- [44]
			"44407:2861:13177:43086:6026:85734", -- [45]
			--["name"] = "Light's Hope Chapel, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 3255470232,
			["direct"] = "4551:4314:16189:44230:24851:37888:44231:44407",
			["f"] = 0,
		},
		[44230] = {
			"44231:44232:37888:37915:44825:2226", -- [1]
			"44231:44232:37888:4551", -- [2]
			"44231:44232:37888:2389", -- [3]
			"44231:44232:37888:43573:2851", -- [4]
			"12636:44407:2861:2858", -- [5]
			"12636:44407:2861:1387", -- [6]
			"12636:44407:2861", -- [7]
			"12636:44407:2861:13177:43086:6026", -- [8]
			"12636:44407:2861:13177", -- [9]
			"12636:44407:2861:3305", -- [10]
			"12636:4314", -- [11]
			"12636:16189:16192", -- [12]
			"12636:16189", -- [13]
			"44231:44232", -- [14]
			"12636:24851", -- [15]
			"12636:24851:26560", -- [16]
			"44231:44232:37888", -- [17]
			"44231:44232:37888:37915", -- [18]
			"44231:44232:37888:37915:43124", -- [19]
			"12636:44407:2861:1387:43053", -- [20]
			"12636:44407:2861:1387:43052", -- [21]
			"12636:44407:2861:13177:43086", -- [22]
			"44231:44232:37888:2389:43104", -- [23]
			"44231:44232:37888:43573", -- [24]
			"12636:16189:44036", -- [25]
			"12636:16189:16192:44244", -- [26]
			"12636:44407:44408", -- [27]
			"12636:44407", -- [28]
			"44231:44232:37888:37915:44825", -- [29]
			"44231:44232:37888:37915:44825:2226:46552:45479", -- [30]
			"44231:44232:37888:46011:46004", -- [31]
			"44231:44232:37888:46011", -- [32]
			"44231:44232:37888:37915:44825:2226:46552", -- [33]
			"44231:44232:37888:43573:2851:47121:47133:47116", -- [34]
			"44231:44232:37888:43573:2851:47121:47133", -- [35]
			"44231:44232:37888:43573:2851:47121", -- [36]
			"44231:44232:37888:43573:2851:47121:47133:47156", -- [37]
			"44231:44232:37888:43573:2851:47121:47133:47156:47061", -- [38]
			"44231:44232:37888:43573:2851:47174", -- [39]
			"44231:44232:37888:2389:47644", -- [40]
			"44231:44232:37888:2389:47644:47655", -- [41]
			"44231:44232:37888:2389:47661", -- [42]
			"44231:44232:37888:37915:47665", -- [43]
			"44233:47875", -- [44]
			"12636:44407:2861:3305:47927", -- [45]
			"12636:44407:2861:13177:48321:48318", -- [46]
			"12636:44407:2861:13177:48321", -- [47]
			"44231:44232:37888:37915:44825:50463", -- [48]
			"12636:44407:2861:13177:43086:6026:85734", -- [49]
			--["name"] = "Eastwall Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 2644471905,
			["direct"] = "12636:44233:28621:44231",
			["f"] = 0,
		},
		[2861] = {
			"2851:2389:2226", -- [1]
			"2851:2389", -- [2]
			"44407:12636", -- [3]
			"2851:4314", -- [4]
			"44407:12636:16189:16192", -- [5]
			"44407:12636:16189", -- [6]
			"2851:43573:37888:44232:44233", -- [7]
			"44407:12636:44230:28621", -- [8]
			"44407:12636:44230", -- [9]
			"2851:43573:37888:44232", -- [10]
			"44407:12636:24851", -- [11]
			"44407:12636:24851:26560", -- [12]
			"2851:43573:37888", -- [13]
			"2851:43573:46004:37915", -- [14]
			"2851:43573:46004:37915:43124", -- [15]
			"1387:43053", -- [16]
			"1387:43052", -- [17]
			"13177:43086", -- [18]
			"2851:43104", -- [19]
			"2851:43573", -- [20]
			"44407:12636:16189:44036", -- [21]
			"2851:43573:37888:44232:44231", -- [22]
			"44407:12636:16189:16192:44244", -- [23]
			"2851:43573:46004:37915:44825", -- [24]
			"2851:43104:47661:47644:47655:46552:45479", -- [25]
			"2851:43573:46004", -- [26]
			"2851:43573:46004:46011", -- [27]
			"2851:43104:47661:47644:47655:46552", -- [28]
			"47121:47133:47116", -- [29]
			"47121:47133", -- [30]
			"47121:47133:47156", -- [31]
			"47174:47061", -- [32]
			"2851:43104:47661:47644", -- [33]
			"2851:43104:47661:47644:47655", -- [34]
			"2851:43104:47661", -- [35]
			"2851:2389:47665", -- [36]
			"2851:43573:46004:46011:47875", -- [37]
			"3305:47927", -- [38]
			"13177:48321:48318", -- [39]
			"13177:48321", -- [40]
			"2851:43573:46004:37915:44825:50463", -- [41]
			"13177:43086:6026:85734", -- [42]
			--["name"] = "New Kargath, Badlands",
			["m"] = 15,
			["f"] = 0,
			["direct"] = "4551:2851:2858:1387:6026:13177:3305:44408:44407:47121:47174",
			["coord"] = 740452012,
		},
		[44825] = {
			"2226:2389", -- [1]
			"2226:2389:2851", -- [2]
			"2226:2389:2851:2861:2858", -- [3]
			"2226:2389:2851:2861:1387", -- [4]
			"2226:2389:2851:2861", -- [5]
			"2226:2389:2851:2861:13177:43086:6026", -- [6]
			"37915:37888:12636", -- [7]
			"2226:2389:2851:2861:13177", -- [8]
			"2226:2389:2851:2861:3305", -- [9]
			"37915:46004:43573:4314", -- [10]
			"37915:37888:12636:16189:16192", -- [11]
			"37915:37888:12636:16189", -- [12]
			"37915:46004:46011:47875:44233", -- [13]
			"37915:37888:44232:28621", -- [14]
			"37915:37888:44232:44231:44230", -- [15]
			"37915:37888:44232", -- [16]
			"37915:37888:12636:24851", -- [17]
			"37915:37888:12636:24851:26560", -- [18]
			"37915:37888", -- [19]
			"2226:2389:2851:2861:1387:43053", -- [20]
			"2226:2389:2851:2861:1387:43052", -- [21]
			"2226:2389:2851:2861:13177:43086", -- [22]
			"2226:2389:43104", -- [23]
			"37915:46004:43573", -- [24]
			"37915:37888:12636:16189:44036", -- [25]
			"37915:37888:44232:44231", -- [26]
			"37915:37888:12636:16189:16192:44244", -- [27]
			"2226:2389:2851:2861:44408", -- [28]
			"2226:2389:2851:2861:44407", -- [29]
			"2226:46552:45479", -- [30]
			"37915:46004", -- [31]
			"37915:46004:46011", -- [32]
			"2226:46552", -- [33]
			"2226:2389:2851:47121:47133:47116", -- [34]
			"2226:2389:2851:47121:47133", -- [35]
			"2226:2389:2851:47121", -- [36]
			"2226:2389:2851:47121:47133:47156", -- [37]
			"2226:2389:2851:47121:47133:47156:47061", -- [38]
			"2226:2389:2851:47174", -- [39]
			"2226:46552:47655:47644", -- [40]
			"2226:46552:47655", -- [41]
			"2226:46552:47655:47644:47661", -- [42]
			"37915:47665", -- [43]
			"37915:46004:46011:47875", -- [44]
			"2226:2389:2851:2861:3305:47927", -- [45]
			"2226:2389:2851:2861:13177:48321:48318", -- [46]
			"2226:2389:2851:2861:13177:48321", -- [47]
			"2226:2389:2851:2861:13177:43086:6026:85734", -- [48]
			--["name"] = "Forsaken High Command, Silverpine Forest",
			["m"] = 21,
			["f"] = 0,
			["direct"] = "2226:4551:37915:43124:50463",
			["coord"] = 2486769270,
		},
		[47875] = {
			"46011:46004:37915:44825:2226", -- [1]
			"46011:46004:37915:4551", -- [2]
			"46011:37888:2389", -- [3]
			"46011:46004:43573:2851", -- [4]
			"46011:46004:43573:2851:2861:2858", -- [5]
			"46011:46004:43573:2851:2861:1387", -- [6]
			"46011:46004:43573:2851:2861", -- [7]
			"46011:46004:43573:2851:2861:13177:43086:6026", -- [8]
			"44233:44230:12636", -- [9]
			"46011:46004:43573:2851:2861:13177", -- [10]
			"46011:46004:43573:2851:2861:3305", -- [11]
			"46011:46004:43573:4314", -- [12]
			"44233:44230:12636:16189:16192", -- [13]
			"44233:44230:12636:16189", -- [14]
			"44233:28621", -- [15]
			"44233:44230", -- [16]
			"44233:44232", -- [17]
			"44233:44230:12636:24851", -- [18]
			"44233:44230:12636:24851:26560", -- [19]
			"46011:37888", -- [20]
			"46011:46004:37915", -- [21]
			"46011:46004:37915:43124", -- [22]
			"46011:46004:43573:2851:2861:1387:43053", -- [23]
			"46011:46004:43573:2851:2861:1387:43052", -- [24]
			"46011:46004:43573:2851:2861:13177:43086", -- [25]
			"46011:37888:2389:43104", -- [26]
			"46011:46004:43573", -- [27]
			"44233:44230:12636:16189:44036", -- [28]
			"44233:44231", -- [29]
			"44233:44230:12636:16189:16192:44244", -- [30]
			"44233:44230:12636:44407:44408", -- [31]
			"44233:44230:12636:44407", -- [32]
			"46011:46004:37915:44825", -- [33]
			"46011:46004:37915:44825:2226:46552:45479", -- [34]
			"46011:46004", -- [35]
			"46011:46004:37915:44825:2226:46552", -- [36]
			"46011:46004:43573:2851:47121:47133:47116", -- [37]
			"46011:46004:43573:2851:47121:47133", -- [38]
			"46011:46004:43573:2851:47121", -- [39]
			"46011:46004:43573:2851:47121:47133:47156", -- [40]
			"46011:46004:43573:2851:47121:47133:47156:47061", -- [41]
			"46011:46004:43573:2851:47174", -- [42]
			"46011:37888:2389:47644", -- [43]
			"46011:37888:2389:47644:47655", -- [44]
			"46011:37888:2389:47661", -- [45]
			"46011:46004:37915:47665", -- [46]
			"46011:46004:43573:2851:2861:3305:47927", -- [47]
			"46011:46004:43573:2851:2861:13177:48321:48318", -- [48]
			"46011:46004:43573:2851:2861:13177:48321", -- [49]
			"46011:46004:37915:44825:50463", -- [50]
			"46011:46004:43573:2851:2861:13177:43086:6026:85734", -- [51]
			--["name"] = "Hearthglen, Western Plaguelands",
			["m"] = 22,
			["coord"] = 1914908428,
			["direct"] = "44233:46011",
			["f"] = 0,
		},
		[43104] = {
			"2389:2226", -- [1]
			"2851:2861:2858", -- [2]
			"2851:2861:1387", -- [3]
			"2851:2861", -- [4]
			"2851:2861:13177:43086:6026", -- [5]
			"2389:37888:12636", -- [6]
			"2851:2861:13177", -- [7]
			"2851:2861:3305", -- [8]
			"2851:4314", -- [9]
			"2389:37888:12636:16189:16192", -- [10]
			"2389:37888:12636:16189", -- [11]
			"2389:37888:44232:44233", -- [12]
			"2389:37888:44232:28621", -- [13]
			"2389:37888:44232:44231:44230", -- [14]
			"2389:37888:44232", -- [15]
			"2389:37888:12636:24851", -- [16]
			"2389:37888:12636:24851:26560", -- [17]
			"2389:37888", -- [18]
			"2389:37915", -- [19]
			"2389:37915:43124", -- [20]
			"2851:2861:1387:43053", -- [21]
			"2851:2861:1387:43052", -- [22]
			"2851:2861:13177:43086", -- [23]
			"2851:43573", -- [24]
			"2389:37888:12636:16189:44036", -- [25]
			"2389:37888:44232:44231", -- [26]
			"2389:37888:12636:16189:16192:44244", -- [27]
			"2851:2861:44408", -- [28]
			"2851:2861:44407", -- [29]
			"2389:37915:44825", -- [30]
			"47661:47644:47655:46552:45479", -- [31]
			"2389:37915:46004", -- [32]
			"2389:37915:46004:46011", -- [33]
			"47661:47644:47655:46552", -- [34]
			"2851:47121:47133:47116", -- [35]
			"2851:47121:47133", -- [36]
			"2851:47121", -- [37]
			"2851:47121:47133:47156", -- [38]
			"2851:47121:47133:47156:47061", -- [39]
			"2851:47174", -- [40]
			"47661:47644", -- [41]
			"47661:47644:47655", -- [42]
			"2389:47665", -- [43]
			"2389:37915:46004:46011:47875", -- [44]
			"2851:2861:3305:47927", -- [45]
			"2851:2861:13177:48321:48318", -- [46]
			"2851:2861:13177:48321", -- [47]
			"2389:2226:50463", -- [48]
			"2851:2861:13177:43086:6026:85734", -- [49]
			--["name"] = "Galen's Fall, Arathi",
			["m"] = 14,
			["f"] = 0,
			["direct"] = "4551:2389:2851:47661",
			["coord"] = 566516098,
		},
		[2389] = {
			"2851:2861:2858", -- [1]
			"2851:2861:1387", -- [2]
			"2851:2861", -- [3]
			"2851:2861:13177:43086:6026", -- [4]
			"37888:12636", -- [5]
			"2851:2861:13177", -- [6]
			"2851:2861:3305", -- [7]
			"37888:12636:16189:16192", -- [8]
			"37888:12636:16189", -- [9]
			"37888:44232:44233", -- [10]
			"37888:44232:28621", -- [11]
			"37888:44232:44231:44230", -- [12]
			"37888:44232", -- [13]
			"37888:12636:24851", -- [14]
			"37888:12636:24851:26560", -- [15]
			"37915:43124", -- [16]
			"2851:2861:1387:43053", -- [17]
			"2851:2861:1387:43052", -- [18]
			"2851:2861:13177:43086", -- [19]
			"37888:12636:16189:44036", -- [20]
			"37888:44232:44231", -- [21]
			"37888:12636:16189:16192:44244", -- [22]
			"2851:2861:44408", -- [23]
			"2851:2861:44407", -- [24]
			"37915:44825", -- [25]
			"47644:47655:46552:45479", -- [26]
			"37915:46004", -- [27]
			"37915:46004:46011", -- [28]
			"47644:47655:46552", -- [29]
			"2851:47121:47133:47116", -- [30]
			"2851:47121:47133", -- [31]
			"2851:47121", -- [32]
			"2851:47121:47133:47156", -- [33]
			"2851:47121:47133:47156:47061", -- [34]
			"2851:47174", -- [35]
			"47644:47655", -- [36]
			"37915:46004:46011:47875", -- [37]
			"2851:2861:3305:47927", -- [38]
			"2851:2861:13177:48321:48318", -- [39]
			"2851:2861:13177:48321", -- [40]
			"2226:50463", -- [41]
			"2851:2861:13177:43086:6026:85734", -- [42]
			--["name"] = "Tarren Mill, Hillsbrad",
			["m"] = 25,
			["coord"] = 2406250079,
			["direct"] = "2226:4551:2851:4314:37888:37915:43104:43573:47644:47661:47665",
			["f"] = 0,
		},
		[47644] = {
			"47655:46552:2226", -- [1]
			"2389:4551", -- [2]
			"47661:43104:2851", -- [3]
			"47661:43104:2851:2861:2858", -- [4]
			"47661:43104:2851:2861:1387", -- [5]
			"47661:43104:2851:2861", -- [6]
			"47661:43104:2851:2861:13177:43086:6026", -- [7]
			"2389:37888:12636", -- [8]
			"47661:43104:2851:2861:13177", -- [9]
			"47661:43104:2851:2861:3305", -- [10]
			"2389:4314", -- [11]
			"2389:37888:12636:16189:16192", -- [12]
			"2389:37888:12636:16189", -- [13]
			"2389:37888:44232:44233", -- [14]
			"2389:37888:44232:28621", -- [15]
			"2389:37888:44232:44231:44230", -- [16]
			"2389:37888:44232", -- [17]
			"2389:37888:12636:24851", -- [18]
			"2389:37888:12636:24851:26560", -- [19]
			"2389:37888", -- [20]
			"2389:37915", -- [21]
			"2389:37915:43124", -- [22]
			"47661:43104:2851:2861:1387:43053", -- [23]
			"47661:43104:2851:2861:1387:43052", -- [24]
			"47661:43104:2851:2861:13177:43086", -- [25]
			"47661:43104", -- [26]
			"2389:43573", -- [27]
			"2389:37888:12636:16189:44036", -- [28]
			"2389:37888:44232:44231", -- [29]
			"2389:37888:12636:16189:16192:44244", -- [30]
			"47661:43104:2851:2861:44408", -- [31]
			"47661:43104:2851:2861:44407", -- [32]
			"2389:37915:44825", -- [33]
			"47655:46552:45479", -- [34]
			"2389:37915:46004", -- [35]
			"2389:37915:46004:46011", -- [36]
			"47655:46552", -- [37]
			"47661:43104:2851:47121:47133:47116", -- [38]
			"47661:43104:2851:47121:47133", -- [39]
			"47661:43104:2851:47121", -- [40]
			"47661:43104:2851:47121:47133:47156", -- [41]
			"47661:43104:2851:47121:47133:47156:47061", -- [42]
			"47661:43104:2851:47174", -- [43]
			"2389:47665", -- [44]
			"2389:37915:46004:46011:47875", -- [45]
			"47661:43104:2851:2861:3305:47927", -- [46]
			"47661:43104:2851:2861:13177:48321:48318", -- [47]
			"47661:43104:2851:2861:13177:48321", -- [48]
			"47655:46552:2226:50463", -- [49]
			"47661:43104:2851:2861:13177:43086:6026:85734", -- [50]
			--["name"] = "Ruins of Southshore, Hillsbrad",
			["m"] = 25,
			["f"] = 0,
			["direct"] = "2389:47655:47661",
			["coord"] = 2107943229,
		},
		[44244] = {
			"16192:16189:12636:37888:37915:44825:2226", -- [1]
			"16192:16189:12636:37888:4551", -- [2]
			"16192:16189:12636:37888:2389", -- [3]
			"16192:16189:12636:4314:2851", -- [4]
			"16192:16189:12636:44407:2861:2858", -- [5]
			"16192:16189:12636:44407:2861:1387", -- [6]
			"16192:16189:12636:44407:2861", -- [7]
			"16192:16189:12636:44407:2861:13177:43086:6026", -- [8]
			"16192:16189:12636", -- [9]
			"16192:16189:12636:44407:2861:13177", -- [10]
			"16192:16189:12636:44407:2861:3305", -- [11]
			"16192:16189:12636:4314", -- [12]
			"16192:16189", -- [13]
			"16192:16189:12636:44230:44233", -- [14]
			"16192:16189:12636:44230:28621", -- [15]
			"16192:16189:12636:44230", -- [16]
			"16192:16189:12636:44231:44232", -- [17]
			"16192:16189:24851", -- [18]
			"16192:26560", -- [19]
			"16192:16189:12636:37888", -- [20]
			"16192:16189:12636:37888:37915", -- [21]
			"16192:16189:12636:37888:37915:43124", -- [22]
			"16192:16189:12636:44407:2861:1387:43053", -- [23]
			"16192:16189:12636:44407:2861:1387:43052", -- [24]
			"16192:16189:12636:44407:2861:13177:43086", -- [25]
			"16192:16189:12636:37888:2389:43104", -- [26]
			"16192:16189:12636:37888:43573", -- [27]
			"16192:44036", -- [28]
			"16192:16189:12636:44231", -- [29]
			"16192:16189:12636:44407:44408", -- [30]
			"16192:16189:12636:44407", -- [31]
			"16192:16189:12636:37888:37915:44825", -- [32]
			"16192:16189:12636:37888:37915:44825:2226:46552:45479", -- [33]
			"16192:16189:12636:37888:46011:46004", -- [34]
			"16192:16189:12636:37888:46011", -- [35]
			"16192:16189:12636:37888:37915:44825:2226:46552", -- [36]
			"16192:16189:12636:4314:2851:47121:47133:47116", -- [37]
			"16192:16189:12636:4314:2851:47121:47133", -- [38]
			"16192:16189:12636:4314:2851:47121", -- [39]
			"16192:16189:12636:4314:2851:47121:47133:47156", -- [40]
			"16192:16189:12636:4314:2851:47121:47133:47156:47061", -- [41]
			"16192:16189:12636:4314:2851:47174", -- [42]
			"16192:16189:12636:37888:2389:47644", -- [43]
			"16192:16189:12636:37888:2389:47644:47655", -- [44]
			"16192:16189:12636:37888:2389:47661", -- [45]
			"16192:16189:12636:37888:37915:47665", -- [46]
			"16192:16189:12636:44230:44233:47875", -- [47]
			"16192:16189:12636:44407:2861:3305:47927", -- [48]
			"16192:16189:12636:44407:2861:13177:48321:48318", -- [49]
			"16192:16189:12636:44407:2861:13177:48321", -- [50]
			"16192:16189:12636:37888:37915:44825:50463", -- [51]
			"16192:16189:12636:44407:2861:13177:43086:6026:85734", -- [52]
			--["name"] = "Falconwing Square, Eversong Woods",
			["m"] = 94,
			["coord"] = 1987999758,
			["direct"] = "16192",
			["f"] = 0,
		},
		[47174] = {
			"2851:2389:2226", -- [1]
			"2851:43573:46004:37915:4551", -- [2]
			"2851:2389", -- [3]
			"2861:2858", -- [4]
			"2861:1387", -- [5]
			"2861:13177:43086:6026", -- [6]
			"2851:43573:37888:12636", -- [7]
			"2861:13177", -- [8]
			"2861:3305", -- [9]
			"2851:4314", -- [10]
			"2851:43573:37888:12636:16189:16192", -- [11]
			"2851:43573:37888:12636:16189", -- [12]
			"2851:43573:37888:44232:44233", -- [13]
			"2851:43573:37888:44232:28621", -- [14]
			"2851:43573:37888:44232:44231:44230", -- [15]
			"2851:43573:37888:44232", -- [16]
			"2851:43573:37888:12636:24851", -- [17]
			"2851:43573:37888:12636:24851:26560", -- [18]
			"2851:43573:37888", -- [19]
			"2851:43573:46004:37915", -- [20]
			"2851:43573:46004:37915:43124", -- [21]
			"2861:1387:43053", -- [22]
			"2861:1387:43052", -- [23]
			"2861:13177:43086", -- [24]
			"2851:43104", -- [25]
			"2851:43573", -- [26]
			"2851:43573:37888:12636:16189:44036", -- [27]
			"2851:43573:37888:44232:44231", -- [28]
			"2851:43573:37888:12636:16189:16192:44244", -- [29]
			"2861:44408", -- [30]
			"2861:44407", -- [31]
			"2851:43573:46004:37915:44825", -- [32]
			"2851:43104:47661:47644:47655:46552:45479", -- [33]
			"2851:43573:46004", -- [34]
			"2851:43573:46004:46011", -- [35]
			"2851:43104:47661:47644:47655:46552", -- [36]
			"47156:47133", -- [37]
			"47156:47133:47121", -- [38]
			"2851:43104:47661:47644", -- [39]
			"2851:43104:47661:47644:47655", -- [40]
			"2851:43104:47661", -- [41]
			"2851:2389:47665", -- [42]
			"2851:43573:46004:46011:47875", -- [43]
			"2861:3305:47927", -- [44]
			"2861:13177:48321:48318", -- [45]
			"2861:13177:48321", -- [46]
			"2851:43573:46004:37915:44825:50463", -- [47]
			"2861:13177:43086:6026:85734", -- [48]
			--["name"] = "Dragonmaw Port, Twilight Highlands",
			["m"] = 241,
			["f"] = 0,
			["direct"] = "2851:2861:47116:47156:47061",
			["coord"] = 3171256117,
		},
	}, -- [2]
	{
		[22455] = {
			"20762:18942:16587", -- [1]
			"20762:18942", -- [2]
			"20762:18791", -- [3]
			"20762:18940:18808", -- [4]
			"20762:18940:18807:19317", -- [5]
			"20762:18940:18807", -- [6]
			"20762:18940", -- [7]
			"20762:18942:16587:18930", -- [8]
			"18938:19583", -- [9]
			"20762:18940:18807:19317:19581", -- [10]
			"20762:18942:16587:19558", -- [11]
			"18938:20515", -- [12]
			"18953:22216", -- [13]
			["direct"] = "18938:18953:20762",
			["f"] = 0,
			["m"] = 105,
			["coord"] = 3279595658,
		},
		[18953] = {
			"20762:18942:16587", -- [1]
			"20762:18942", -- [2]
			"18791:18808", -- [3]
			"20762:18940:18807:19317", -- [4]
			"20762:18940:18807", -- [5]
			"20762:18940", -- [6]
			"20762:18942:16587:18930", -- [7]
			"20762:18940:18807:19317:19581", -- [8]
			"20762:18942:16587:19558", -- [9]
			"18938:20515", -- [10]
			["direct"] = "18791:18938:19583:20762:22216:22455",
			["coord"] = 2236451551,
			["m"] = 105,
			["f"] = 0,
		},
		[19558] = {
			"16587:18942", -- [1]
			"16587:18942:18791", -- [2]
			"16587:18942:18808", -- [3]
			"16587:18942:20762:22455:18938", -- [4]
			"16587:18807:19317", -- [5]
			"16587:18942:20762:18953", -- [6]
			"16587:18807", -- [7]
			"16587:18940", -- [8]
			"16587:18930", -- [9]
			"16587:18942:20762:22455:18938:19583", -- [10]
			"16587:18807:19317:19581", -- [11]
			"16587:18942:20762:22455:18938:20515", -- [12]
			"16587:18942:20762", -- [13]
			"16587:18942:20762:18953:22216", -- [14]
			"16587:18942:20762:22455", -- [15]
			["direct"] = "16587",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 2645348352,
		},
		[18940] = {
			"20762:22455:18938", -- [1]
			"18807:19317", -- [2]
			"20762:18953", -- [3]
			"16587:18930", -- [4]
			"20762:22455:18938:19583", -- [5]
			"18807:19317:19581", -- [6]
			"16587:19558", -- [7]
			"20762:22455:18938:20515", -- [8]
			"20762:18953:22216", -- [9]
			"20762:22455", -- [10]
			["direct"] = "16587:18942:18791:18808:18807:20762",
			["f"] = 0,
			["m"] = 111,
			["coord"] = 2745330149,
		},
		[18942] = {
			"20762:22455:18938", -- [1]
			"18940:18807:19317", -- [2]
			"20762:18953", -- [3]
			"18940:18807", -- [4]
			"16587:18930", -- [5]
			"20762:22455:18938:19583", -- [6]
			"18940:18807:19317:19581", -- [7]
			"16587:19558", -- [8]
			"20762:22455:18938:20515", -- [9]
			"20762:18953:22216", -- [10]
			"20762:22455", -- [11]
			["direct"] = "16587:18791:18808:18940:20762",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 1196333511,
		},
		[16587] = {
			"18942:18791", -- [1]
			"18942:18808", -- [2]
			"18942:20762:22455:18938", -- [3]
			"18807:19317", -- [4]
			"18942:20762:18953", -- [5]
			"18942:20762:22455:18938:19583", -- [6]
			"18807:19317:19581", -- [7]
			"18942:20762:22455:18938:20515", -- [8]
			"18942:20762", -- [9]
			"18942:20762:18953:22216", -- [10]
			"18942:20762:22455", -- [11]
			["direct"] = "18942:18807:18940:18930:19558",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 2416663840,
		},
		[19317] = {
			"18807:16587", -- [1]
			"18807:18940:18942", -- [2]
			"18807:18940:18791", -- [3]
			"18807:18940:18808", -- [4]
			"18807:18940:20762:22455:18938", -- [5]
			"18807:18940:20762:18953", -- [6]
			"18807:18940", -- [7]
			"18807:16587:18930", -- [8]
			"18807:18940:20762:22455:18938:19583", -- [9]
			"18807:16587:19558", -- [10]
			"18807:18940:20762:22455:18938:20515", -- [11]
			"18807:18940:20762", -- [12]
			"18807:18940:20762:18953:22216", -- [13]
			"18807:18940:20762:22455", -- [14]
			["direct"] = "18807:19581",
			["f"] = 0,
			["m"] = 104,
			["coord"] = 1302481601,
		},
		[19581] = {
			"19317:18807:16587", -- [1]
			"19317:18807:18940:18942", -- [2]
			"19317:18807:18940:18791", -- [3]
			"19317:18807:18940:18808", -- [4]
			"19317:18807:18940:20762:22455:18938", -- [5]
			"19317:18807:18940:20762:18953", -- [6]
			"19317:18807", -- [7]
			"19317:18807:18940", -- [8]
			"19317:18807:16587:18930", -- [9]
			"19317:18807:18940:20762:22455:18938:19583", -- [10]
			"19317:18807:16587:19558", -- [11]
			"19317:18807:18940:20762:22455:18938:20515", -- [12]
			"19317:18807:18940:20762", -- [13]
			"19317:18807:18940:20762:18953:22216", -- [14]
			"19317:18807:18940:20762:22455", -- [15]
			["direct"] = "19317",
			["f"] = 0,
			["m"] = 104,
			["coord"] = 2717011449,
		},
		[18791] = {
			"18942:16587", -- [1]
			"18953:18938", -- [2]
			"18940:18807:19317", -- [3]
			"18940:18807", -- [4]
			"18942:16587:18930", -- [5]
			"18953:18938:19583", -- [6]
			"18940:18807:19317:19581", -- [7]
			"18942:16587:19558", -- [8]
			"18953:18938:20515", -- [9]
			"18953:22216", -- [10]
			"18953:22455", -- [11]
			["direct"] = "18942:18808:18953:18940:20762",
			["f"] = 0,
			["m"] = 102,
			["coord"] = 1417380620,
		},
		[18807] = {
			"18940:18942", -- [1]
			"18940:18791", -- [2]
			"18940:18808", -- [3]
			"18940:20762:22455:18938", -- [4]
			"18940:20762:18953", -- [5]
			"16587:18930", -- [6]
			"18940:20762:22455:18938:19583", -- [7]
			"19317:19581", -- [8]
			"16587:19558", -- [9]
			"18940:20762:22455:18938:20515", -- [10]
			"18940:20762", -- [11]
			"18940:20762:18953:22216", -- [12]
			"18940:20762:22455", -- [13]
			["direct"] = "16587:19317:18940",
			["f"] = 0,
			["m"] = 108,
			["coord"] = 2115268468,
		},
		[18938] = {
			"22455:20762:18942:16587", -- [1]
			"22455:20762:18942", -- [2]
			"22455:20762:18791", -- [3]
			"22455:20762:18940:18808", -- [4]
			"22455:20762:18940:18807:19317", -- [5]
			"22455:20762:18940:18807", -- [6]
			"22455:20762:18940", -- [7]
			"22455:20762:18942:16587:18930", -- [8]
			"22455:20762:18940:18807:19317:19581", -- [9]
			"22455:20762:18942:16587:19558", -- [10]
			"22455:20762", -- [11]
			["direct"] = "18953:19583:20515:22216:22455",
			["f"] = 0,
			["m"] = 109,
			["coord"] = 1451533221,
		},
		[18808] = {
			"18942:16587", -- [1]
			"18791:18953:18938", -- [2]
			"18940:18807:19317", -- [3]
			"18791:18953", -- [4]
			"18940:18807", -- [5]
			"18942:16587:18930", -- [6]
			"18791:18953:18938:19583", -- [7]
			"18940:18807:19317:19581", -- [8]
			"18942:16587:19558", -- [9]
			"18791:18953:18938:20515", -- [10]
			"18940:20762", -- [11]
			"18791:18953:22216", -- [12]
			"18940:20762:22455", -- [13]
			["direct"] = "18942:18791:18940",
			["f"] = 0,
			["m"] = 107,
			["coord"] = 2458409611,
		},
		[18930] = {
			"18942:18791", -- [1]
			"18942:18808", -- [2]
			"18942:20762:22455:18938", -- [3]
			"16587:18807:19317", -- [4]
			"18942:20762:18953", -- [5]
			"16587:18807", -- [6]
			"16587:18940", -- [7]
			"18942:20762:22455:18938:19583", -- [8]
			"16587:18807:19317:19581", -- [9]
			"16587:19558", -- [10]
			"18942:20762:22455:18938:20515", -- [11]
			"18942:20762", -- [12]
			"18942:20762:18953:22216", -- [13]
			"18942:20762:22455", -- [14]
			["direct"] = "16587:18942",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 3752950617,
		},
		[20762] = {
			"18942:16587", -- [1]
			"18940:18808", -- [2]
			"22455:18938", -- [3]
			"18940:18807:19317", -- [4]
			"18940:18807", -- [5]
			"18942:16587:18930", -- [6]
			"22455:18938:19583", -- [7]
			"18940:18807:19317:19581", -- [8]
			"18942:16587:19558", -- [9]
			"22455:18938:20515", -- [10]
			"18953:22216", -- [11]
			["direct"] = "18942:18791:18953:18940:22455",
			["f"] = 0,
			["m"] = 102,
			["coord"] = 3639643342,
		},
		[19583] = {
			"18938:22455:20762:18942:16587", -- [1]
			"18938:22455:20762:18942", -- [2]
			"18953:18791", -- [3]
			"18938:22455:20762:18940:18808", -- [4]
			"18938:22455:20762:18940:18807:19317", -- [5]
			"18938:22455:20762:18940:18807", -- [6]
			"18938:22455:20762:18940", -- [7]
			"18938:22455:20762:18942:16587:18930", -- [8]
			"18938:22455:20762:18940:18807:19317:19581", -- [9]
			"18938:22455:20762:18942:16587:19558", -- [10]
			"18938:22455:20762", -- [11]
			"18938:22216", -- [12]
			"18938:22455", -- [13]
			["direct"] = "18938:18953:20515",
			["f"] = 0,
			["m"] = 109,
			["coord"] = 1944213875,
		},
		[20515] = {
			"18938:22455:20762:18942:16587", -- [1]
			"18938:22455:20762:18942", -- [2]
			"18938:22455:20762:18791", -- [3]
			"18938:22455:20762:18940:18808", -- [4]
			"18938:22455:20762:18940:18807:19317", -- [5]
			"18938:18953", -- [6]
			"18938:22455:20762:18940:18807", -- [7]
			"18938:22455:20762:18940", -- [8]
			"18938:22455:20762:18942:16587:18930", -- [9]
			"18938:22455:20762:18940:18807:19317:19581", -- [10]
			"18938:22455:20762:18942:16587:19558", -- [11]
			"18938:22455:20762", -- [12]
			"18938:22216", -- [13]
			"18938:22455", -- [14]
			["direct"] = "18938:19583",
			["f"] = 0,
			["m"] = 109,
			["coord"] = 2800462568,
		},
		[22216] = {
			"18953:20762:18942:16587", -- [1]
			"18953:20762:18942", -- [2]
			"18953:18791", -- [3]
			"18953:18791:18808", -- [4]
			"18953:20762:18940:18807:19317", -- [5]
			"18953:20762:18940:18807", -- [6]
			"18953:20762:18940", -- [7]
			"18953:20762:18942:16587:18930", -- [8]
			"18938:19583", -- [9]
			"18953:20762:18940:18807:19317:19581", -- [10]
			"18953:20762:18942:16587:19558", -- [11]
			"18938:20515", -- [12]
			"18953:20762", -- [13]
			"18953:22455", -- [14]
			["direct"] = "18938:18953",
			["coord"] = 2648008034,
			["m"] = 105,
			["f"] = 0,
		},
	}, -- [3]
	{
		[26852] = {
			"26844:24155", -- [1]
			"24032:27344", -- [2]
			"26845:26851:26566:26847:24795:27046", -- [3]
			"26845:26851", -- [4]
			"26845:26851:26566", -- [5]
			"26845:28196:28195:25288", -- [6]
			"26845:26851:26566:26847", -- [7]
			"26845:26851:26566:26847:26848", -- [8]
			"26845:26851:26850", -- [9]
			"26845:26851:26566:26847:24795", -- [10]
			"26845:28196", -- [11]
			"26844:28197", -- [12]
			"26845:28196:28195", -- [13]
			"28618:28623", -- [14]
			"28618:28615", -- [15]
			"28618:28623:28624", -- [16]
			"28618:28615:28674:28574", -- [17]
			"28618:28615:28674", -- [18]
			"28618:28615:29721", -- [19]
			"28618:28623:28624:32571", -- [20]
			"28618:28615:29721:29757", -- [21]
			"28618:28615:29721:29762", -- [22]
			"28618:28615:28674:31069:31078", -- [23]
			"28618:28615:29721:29757:29951", -- [24]
			"28618:28615:29721:29757:29950", -- [25]
			"28618:28623:28624:30569", -- [26]
			"26845:26851:26566:30870", -- [27]
			"28618:28615:28674:31069:30314", -- [28]
			"28618:28615:28674:30433", -- [29]
			"28618:28615:28674:31069", -- [30]
			"28618:28615:30269", -- [31]
			"28618:28615:28674:33849", -- [32]
			"28618:28615:28674:28574:28037", -- [33]
			["m"] = 116,
			["coord"] = 942974243,
			["direct"] = "24032:26844:26853:26845:28618",
			["f"] = 0,
		},
		[26853] = {
			"24032:24155", -- [1]
			"28618:28615:26850:26566:26847:24795:27046", -- [2]
			"24032:26844", -- [3]
			"28618:28615:26851", -- [4]
			"26852:26845", -- [5]
			"28618:28615:26850:26566", -- [6]
			"28618:28615:28674:25288", -- [7]
			"28618:28615:26850:26566:26847", -- [8]
			"28618:28615:28674:28574:26848", -- [9]
			"28618:28615:26850", -- [10]
			"28618:28615:26850:26566:26847:24795", -- [11]
			"26852:26845:28196", -- [12]
			"24032:26844:28197", -- [13]
			"26852:26845:28196:28195", -- [14]
			"28618:28615", -- [15]
			"28618:28615:28674:28574", -- [16]
			"28618:28615:28674", -- [17]
			"28618:28615:29721", -- [18]
			"28624:32571", -- [19]
			"28618:28615:29721:29757", -- [20]
			"28624:29762", -- [21]
			"28618:28615:28674:31069:31078", -- [22]
			"28624:29951", -- [23]
			"28618:28615:29721:29757:29950", -- [24]
			"28624:30569", -- [25]
			"28618:28615:28674:30870", -- [26]
			"28618:28615:28674:31069:30314", -- [27]
			"28618:28615:28674:30433", -- [28]
			"28618:28615:28674:31069", -- [29]
			"28618:28615:30269", -- [30]
			"28618:28615:28674:33849", -- [31]
			"28618:28615:28674:28574:28037", -- [32]
			["m"] = 116,
			["coord"] = 2789373946,
			["direct"] = "27344:24032:26852:28623:28618:28624",
			["f"] = 0,
		},
		[28618] = {
			"26852:26844:24155", -- [1]
			"26853:27344", -- [2]
			"26853:24032", -- [3]
			"28615:26850:26566:26847:24795:27046", -- [4]
			"26852:26844", -- [5]
			"28615:26851", -- [6]
			"28615:26850:26566", -- [7]
			"28615:28674:25288", -- [8]
			"28615:26850:26566:26847", -- [9]
			"28615:28674:28574:26848", -- [10]
			"28615:26850", -- [11]
			"28615:26850:26566:26847:24795", -- [12]
			"28615:26851:28196", -- [13]
			"26852:26844:28197", -- [14]
			"28615:26851:28196:28195", -- [15]
			"28623:28624", -- [16]
			"28615:28674:28574", -- [17]
			"28615:28674", -- [18]
			"28615:29721", -- [19]
			"28623:28624:32571", -- [20]
			"28615:29721:29757", -- [21]
			"28615:29721:29762", -- [22]
			"28615:28674:31069:31078", -- [23]
			"28615:29721:29757:29951", -- [24]
			"28615:29721:29757:29950", -- [25]
			"28623:28624:30569", -- [26]
			"28615:28674:30870", -- [27]
			"28615:28674:31069:30314", -- [28]
			"28615:28674:30433", -- [29]
			"28615:28674:31069", -- [30]
			"28615:30269", -- [31]
			"28615:28674:33849", -- [32]
			"28615:28674:28574:28037", -- [33]
			["m"] = 121,
			["f"] = 0,
			["direct"] = "26853:26852:26845:28623:28615",
			["coord"] = 1381678745,
		},
		[31078] = {
			"30870:26566:26845:24155", -- [1]
			"30870:26566:26845:26852:24032:27344", -- [2]
			"30870:26566:26845:26852:24032", -- [3]
			"28574:26848:24795:27046", -- [4]
			"30870:26566:26845:26844", -- [5]
			"30870:26566:26845:26852:26853", -- [6]
			"30870:26566:26845:26852", -- [7]
			"30870:26566:26851", -- [8]
			"30870:26566:26845", -- [9]
			"30870:26566", -- [10]
			"28574:26848:25288", -- [11]
			"30870:26847", -- [12]
			"28574:26848", -- [13]
			"30870:26566:26850", -- [14]
			"28574:26848:24795", -- [15]
			"30870:26566:28196", -- [16]
			"30870:26566:26845:26844:28197", -- [17]
			"30870:26847:28195", -- [18]
			"31069:30433:28674:28615:28623", -- [19]
			"31069:30433:28674:28615", -- [20]
			"31069:30433:28674:28615:28618", -- [21]
			"30314:29950:29951:28624", -- [22]
			"31069:30433:28674", -- [23]
			"31069:30433:28674:29721", -- [24]
			"30314:29950:29951:32571", -- [25]
			"30314:29950:29757", -- [26]
			"30314:29950:29951:29762", -- [27]
			"30314:29950:29951", -- [28]
			"30314:29950", -- [29]
			"30314:29950:29951:28624:30569", -- [30]
			"31069:30433", -- [31]
			"31069:30433:28674:30269", -- [32]
			"30314:33849", -- [33]
			"28037:26848:24795:27046", -- [34]
			"28037:26848:25288", -- [35]
			"28037:26848", -- [36]
			"28037:26848:24795", -- [37]
			["direct"] = "28574:28037:30870:30314:31069",
			["f"] = 0,
			["m"] = 118,
			["coord"] = 831814222,
		},
		[28623] = {
			"26853:24032:24155", -- [1]
			"26853:27344", -- [2]
			"26853:24032", -- [3]
			"28615:26850:26566:26847:24795:27046", -- [4]
			"28618:26852:26844", -- [5]
			"28618:26852", -- [6]
			"28615:26851", -- [7]
			"28618:26845", -- [8]
			"28615:26850:26566", -- [9]
			"28615:28674:25288", -- [10]
			"28615:26850:26566:26847", -- [11]
			"28615:28674:28574:26848", -- [12]
			"28615:26850", -- [13]
			"28615:26850:26566:26847:24795", -- [14]
			"28615:26851:28196", -- [15]
			"28618:26852:26844:28197", -- [16]
			"28615:26851:28196:28195", -- [17]
			"28615:28674:28574", -- [18]
			"28615:28674", -- [19]
			"28615:29721", -- [20]
			"28624:32571", -- [21]
			"28615:29721:29757", -- [22]
			"28624:29762", -- [23]
			"28615:28674:31069:31078", -- [24]
			"28624:29951", -- [25]
			"28615:29721:29757:29950", -- [26]
			"28624:30569", -- [27]
			"28615:28674:30870", -- [28]
			"28615:28674:31069:30314", -- [29]
			"28615:28674:30433", -- [30]
			"28615:28674:31069", -- [31]
			"28615:30269", -- [32]
			"28615:28674:33849", -- [33]
			"28615:28674:28574:28037", -- [34]
			["direct"] = "26853:28615:28618:28624",
			["f"] = 0,
			["m"] = 121,
			["coord"] = 1782293786,
		},
		[28624] = {
			"26853:24032:24155", -- [1]
			"26853:27344", -- [2]
			"26853:24032", -- [3]
			"28623:28615:26850:26566:26847:24795:27046", -- [4]
			"26853:24032:26844", -- [5]
			"28623:28618:26852", -- [6]
			"28623:28615:26851", -- [7]
			"28623:28618:26845", -- [8]
			"28623:28615:26850:26566", -- [9]
			"28623:28615:28674:25288", -- [10]
			"28623:28615:26850:26566:26847", -- [11]
			"28623:28615:28674:28574:26848", -- [12]
			"28623:28615:26850", -- [13]
			"28623:28615:26850:26566:26847:24795", -- [14]
			"28623:28615:26851:28196", -- [15]
			"26853:24032:26844:28197", -- [16]
			"28623:28615:26851:28196:28195", -- [17]
			"28623:28615", -- [18]
			"28623:28618", -- [19]
			"28623:28615:28674:28574", -- [20]
			"28623:28615:28674", -- [21]
			"28623:28615:29721", -- [22]
			"29762:29757", -- [23]
			"28623:28615:28674:31069:31078", -- [24]
			"29951:29950", -- [25]
			"28623:28615:28674:30870", -- [26]
			"29951:29950:30314", -- [27]
			"28623:28615:28674:30433", -- [28]
			"28623:28615:28674:31069", -- [29]
			"28623:28615:30269", -- [30]
			"29951:29950:33849", -- [31]
			"28623:28615:28674:28574:28037", -- [32]
			["m"] = 121,

			["f"] = 0,
			["direct"] = "26853:28623:32571:29762:29951:30569",
			["coord"] = 2575864175,
		},
		[25288] = {
			"26847:26566:26845:24155", -- [1]
			"26847:26566:26845:26852:24032:27344", -- [2]
			"26847:26566:26845:26852:24032", -- [3]
			"24795:27046", -- [4]
			"26847:26566:26845:26844", -- [5]
			"26847:26566:26845:26852:26853", -- [6]
			"26847:26566:26845:26852", -- [7]
			"26847:26566:26851", -- [8]
			"26847:26566:26845", -- [9]
			"26847:26566", -- [10]
			"26847:26566:26850", -- [11]
			"28195:28196", -- [12]
			"28195:28196:28197", -- [13]
			"26847:26566:26851:28615:28623", -- [14]
			"26847:26566:26851:28615", -- [15]
			"26847:26566:26845:28618", -- [16]
			"26847:26566:26851:28615:28623:28624", -- [17]
			"26848:28574", -- [18]
			"28674:29721", -- [19]
			"28674:29721:32571", -- [20]
			"28674:29721:29757", -- [21]
			"28674:29721:29762", -- [22]
			"26848:28574:31078", -- [23]
			"28674:29721:29757:29951", -- [24]
			"26848:28574:31078:30314:29950", -- [25]
			"26847:26566:26851:28615:28623:28624:30569", -- [26]
			"26847:30870", -- [27]
			"26848:28574:31078:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"28674:30269", -- [31]
			"26848:28574:31078:30314:33849", -- [32]
			"26848:28037", -- [33]
			"26848:28037:31078", -- [34]
			"26848:28037:31078:30314:29950", -- [35]
			"26848:28037:31078:30314", -- [36]
			"26848:28037:31078:30314:33849", -- [37]
			["m"] = 114,
			["f"] = 0,
			["direct"] = "26847:26848:24795:28195:28674",
			["coord"] = 1731232670,
		},
		[24155] = {
			"28197:28196:28195:26847:24795:27046", -- [1]
			"24032:26853", -- [2]
			"26844:26852", -- [3]
			"26845:26851", -- [4]
			"26845:26851:26566", -- [5]
			"28197:28196:28195:25288", -- [6]
			"28197:28196:28195:26847", -- [7]
			"28197:28196:28195:26847:26848", -- [8]
			"26845:26851:26850", -- [9]
			"28197:28196:28195:26847:24795", -- [10]
			"28197:28196", -- [11]
			"28197:28196:28195", -- [12]
			"24032:26853:28623", -- [13]
			"26844:26852:28618:28615", -- [14]
			"26844:26852:28618", -- [15]
			"24032:26853:28624", -- [16]
			"26845:26851:26566:30870:28574", -- [17]
			"26844:26852:28618:28615:28674", -- [18]
			"26844:26852:28618:28615:29721", -- [19]
			"24032:26853:28624:32571", -- [20]
			"26844:26852:28618:28615:29721:29757", -- [21]
			"24032:26853:28624:29762", -- [22]
			"26844:26852:28618:28615:28674:31069:31078", -- [23]
			"24032:26853:28624:29951", -- [24]
			"26844:26852:28618:28615:29721:29757:29950", -- [25]
			"24032:26853:28624:30569", -- [26]
			"26845:26851:26566:30870", -- [27]
			"26844:26852:28618:28615:28674:31069:30314", -- [28]
			"26844:26852:28618:28615:28674:30433", -- [29]
			"26844:26852:28618:28615:28674:31069", -- [30]
			"26844:26852:28618:28615:30269", -- [31]
			"26844:26852:28618:28615:28674:33849", -- [32]
			"28197:28196:28195:26847:26848:28037", -- [33]
			["m"] = 117,
			["coord"] = 2235214962,
			["direct"] = "27344:24032:26844:26845:28197",
			["f"] = 0,
		},
		[24032] = {
			"26844:26845:26851:26566:26847:24795:27046", -- [1]
			"26844:26845:26851", -- [2]
			"26844:26845", -- [3]
			"26844:26845:26851:26566", -- [4]
			"26844:26845:28196:28195:25288", -- [5]
			"26844:26845:26851:26566:26847", -- [6]
			"26844:26845:26851:26566:26847:26848", -- [7]
			"26844:26845:26851:26850", -- [8]
			"26844:26845:26851:26566:26847:24795", -- [9]
			"26844:26845:28196", -- [10]
			"26844:28197", -- [11]
			"26844:26845:28196:28195", -- [12]
			"26853:28623", -- [13]
			"26853:28618:28615", -- [14]
			"26853:28618", -- [15]
			"26853:28624", -- [16]
			"26853:28618:28615:28674:28574", -- [17]
			"26853:28618:28615:28674", -- [18]
			"26853:28618:28615:29721", -- [19]
			"26853:28624:32571", -- [20]
			"26853:28618:28615:29721:29757", -- [21]
			"26853:28624:29762", -- [22]
			"26853:28618:28615:28674:31069:31078", -- [23]
			"26853:28624:29951", -- [24]
			"26853:28618:28615:29721:29757:29950", -- [25]
			"26853:28624:30569", -- [26]
			"26844:26845:26851:26566:30870", -- [27]
			"26853:28618:28615:28674:31069:30314", -- [28]
			"26853:28618:28615:28674:30433", -- [29]
			"26853:28618:28615:28674:31069", -- [30]
			"26853:28618:28615:30269", -- [31]
			"26853:28618:28615:28674:33849", -- [32]
			"26853:28618:28615:28674:28574:28037", -- [33]
			["m"] = 117,
			["coord"] = 2127502707,
			["direct"] = "24155:27344:26844:26853:26852",
			["f"] = 0,
		},
		[28195] = {
			"28196:28197:24155", -- [1]
			"28196:26845:26852:24032:27344", -- [2]
			"28196:26845:26852:24032", -- [3]
			"26847:24795:27046", -- [4]
			"28196:26845:26844", -- [5]
			"28196:26845:26852:26853", -- [6]
			"28196:26845:26852", -- [7]
			"26847:26566:26851", -- [8]
			"28196:26845", -- [9]
			"26847:26566", -- [10]
			"26847:26848", -- [11]
			"26847:26566:26850", -- [12]
			"26847:24795", -- [13]
			"28196:28197", -- [14]
			"28196:26845:28615:28623", -- [15]
			"28196:26845:28615", -- [16]
			"28196:26845:28618", -- [17]
			"28196:26845:28615:28623:28624", -- [18]
			"26847:26848:28574", -- [19]
			"26847:26566:26850:28674", -- [20]
			"26847:26566:26850:28674:29721", -- [21]
			"26847:26566:26850:28674:29721:32571", -- [22]
			"26847:26566:26850:28674:29721:29757", -- [23]
			"26847:26566:26850:28674:29721:29762", -- [24]
			"26847:30870:31078", -- [25]
			"26847:26566:26850:28674:29721:29757:29951", -- [26]
			"26847:30870:30314:29950", -- [27]
			"28196:26845:28615:28623:28624:30569", -- [28]
			"26847:30870", -- [29]
			"26847:30870:30314", -- [30]
			"26847:26566:26850:28674:30433", -- [31]
			"26847:30870:31069", -- [32]
			"28196:26845:28615:30269", -- [33]
			"26847:30870:30314:33849", -- [34]
			"26847:26848:28037", -- [35]
			["direct"] = "25288:26847:28196",
			["coord"] = 3371205577,
			["m"] = 114,
			["f"] = 0,
		},
		[28196] = {
			"28197:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"28195:26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"28195:25288", -- [8]
			"28195:26847", -- [9]
			"28195:26847:26848", -- [10]
			"26851:26850", -- [11]
			"28195:26847:24795", -- [12]
			"26845:28615:28623", -- [13]
			"26845:28615", -- [14]
			"26845:28618", -- [15]
			"26845:28615:28623:28624", -- [16]
			"26566:30870:28574", -- [17]
			"28674:29721", -- [18]
			"28674:29721:32571", -- [19]
			"28674:29721:29757", -- [20]
			"28674:29721:29762", -- [21]
			"26566:30870:31078", -- [22]
			"28674:29721:29757:29951", -- [23]
			"28674:29721:29757:29950", -- [24]
			"26845:28615:28623:28624:30569", -- [25]
			"26566:30870", -- [26]
			"28674:31069:30314", -- [27]
			"28674:30433", -- [28]
			"28674:31069", -- [29]
			"26845:28615:30269", -- [30]
			"28674:33849", -- [31]
			"28195:26847:26848:28037", -- [32]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "26851:26845:26566:28197:28195:28674",
			["coord"] = 2081603196,
		},
		[28197] = {
			"24155:27344", -- [1]
			"26844:24032", -- [2]
			"28196:28195:26847:24795:27046", -- [3]
			"26844:24032:26853", -- [4]
			"26844:26852", -- [5]
			"26844:26845:26851", -- [6]
			"26844:26845", -- [7]
			"28196:26566", -- [8]
			"28196:28195:25288", -- [9]
			"28196:28195:26847", -- [10]
			"28196:28195:26847:26848", -- [11]
			"26844:26845:26851:26850", -- [12]
			"28196:28195:26847:24795", -- [13]
			"28196:28195", -- [14]
			"26844:26852:28618:28623", -- [15]
			"26844:26852:28618:28615", -- [16]
			"26844:26852:28618", -- [17]
			"26844:24032:26853:28624", -- [18]
			"28196:26566:30870:28574", -- [19]
			"26844:26852:28618:28615:28674", -- [20]
			"26844:26852:28618:28615:29721", -- [21]
			"26844:24032:26853:28624:32571", -- [22]
			"26844:26852:28618:28615:29721:29757", -- [23]
			"26844:24032:26853:28624:29762", -- [24]
			"28196:26566:30870:31078", -- [25]
			"26844:26852:28618:28615:29721:29757:29951", -- [26]
			"26844:26852:28618:28615:29721:29757:29950", -- [27]
			"26844:24032:26853:28624:30569", -- [28]
			"28196:26566:30870", -- [29]
			"26844:26852:28618:28615:28674:31069:30314", -- [30]
			"26844:26852:28618:28615:28674:30433", -- [31]
			"26844:26852:28618:28615:28674:31069", -- [32]
			"26844:26852:28618:28615:30269", -- [33]
			"26844:26852:28618:28615:28674:33849", -- [34]
			"28196:28195:26847:26848:28037", -- [35]
			["direct"] = "24155:26844:28196",
			["f"] = 0,
			["m"] = 117,
			["coord"] = 1058378765,
		},
		[26566] = {
			"26845:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"26847:25288", -- [8]
			"26847:26848", -- [9]
			"26847:24795", -- [10]
			"26845:26844:28197", -- [11]
			"26847:28195", -- [12]
			"26851:28615:28623", -- [13]
			"26851:28615", -- [14]
			"26845:28618", -- [15]
			"26851:28615:28623:28624", -- [16]
			"30870:28574", -- [17]
			"26850:28674", -- [18]
			"26850:28674:29721", -- [19]
			"26850:28674:29721:32571", -- [20]
			"26850:28674:29721:29757", -- [21]
			"26850:28674:29721:29762", -- [22]
			"30870:31078", -- [23]
			"26850:28674:29721:29757:29951", -- [24]
			"26850:28674:29721:29757:29950", -- [25]
			"26851:28615:28623:28624:30569", -- [26]
			"30870:30314", -- [27]
			"26850:28674:30433", -- [28]
			"26850:28674:31069", -- [29]
			"26850:28674:30269", -- [30]
			"26850:28674:33849", -- [31]
			"26847:26848:28037", -- [32]
			["m"] = 115,
			["coord"] = 1609331968,
			["direct"] = "26851:26845:26847:26850:28196:30870",
			["f"] = 0,
		},
		[29721] = {
			"28615:28618:26852:26844:24155", -- [1]
			"28615:28618:26853:27344", -- [2]
			"28615:28618:26853:24032", -- [3]
			"28674:25288:24795:27046", -- [4]
			"28615:28618:26852:26844", -- [5]
			"28615:28618:26853", -- [6]
			"28615:28618:26852", -- [7]
			"28615:26851", -- [8]
			"28615:26845", -- [9]
			"28674:26850:26566", -- [10]
			"28674:25288", -- [11]
			"28674:26850:26566:26847", -- [12]
			"28674:28574:26848", -- [13]
			"28674:26850", -- [14]
			"28674:25288:24795", -- [15]
			"28615:26851:28196", -- [16]
			"28615:28618:26852:26844:28197", -- [17]
			"28615:26851:28196:28195", -- [18]
			"28615:28623", -- [19]
			"28615:28618", -- [20]
			"28615:28623:28624", -- [21]
			"28674:28574", -- [22]
			"28674:31069:31078", -- [23]
			"29757:29951", -- [24]
			"29757:29950", -- [25]
			"28615:28623:28624:30569", -- [26]
			"28674:30870", -- [27]
			"29757:29950:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"29757:29950:33849", -- [31]
			"28674:28574:28037", -- [32]
			["m"] = 120,
			["coord"] = 1750521958,
			["direct"] = "28615:28674:32571:29757:29762:30269",
			["f"] = 0,
		},
		[30569] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"28624:28623:28615:26850:26566:26847:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"28624:28623:28618:26852", -- [7]
			"28624:28623:28615:26851", -- [8]
			"28624:28623:28618:26845", -- [9]
			"28624:28623:28615:26850:26566", -- [10]
			"28624:28623:28615:28674:25288", -- [11]
			"28624:28623:28615:26850:26566:26847", -- [12]
			"28624:28623:28615:28674:28574:26848", -- [13]
			"28624:28623:28615:26850", -- [14]
			"28624:28623:28615:26850:26566:26847:24795", -- [15]
			"28624:28623:28615:26851:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"28624:28623:28615:26851:28196:28195", -- [18]
			"28624:28623", -- [19]
			"28624:28623:28615", -- [20]
			"28624:28623:28618", -- [21]
			"28624:28623:28615:28674:28574", -- [22]
			"28624:28623:28615:28674", -- [23]
			"28624:28623:28615:29721", -- [24]
			"28624:32571", -- [25]
			"28624:29762:29757", -- [26]
			"28624:29762", -- [27]
			"28624:28623:28615:28674:31069:31078", -- [28]
			"28624:29951", -- [29]
			"28624:29951:29950", -- [30]
			"28624:28623:28615:28674:30870", -- [31]
			"28624:29951:29950:30314", -- [32]
			"28624:28623:28615:28674:30433", -- [33]
			"28624:28623:28615:28674:31069", -- [34]
			"28624:28623:28615:30269", -- [35]
			"28624:29951:29950:33849", -- [36]
			"28624:28623:28615:28674:28574:28037", -- [37]
			["direct"] = "28624",
			["coord"] = 3025877835,
			["m"] = 121,
			["f"] = 0,
		},
		[33849] = {
			"29950:29951:28624:26853:24032:24155", -- [1]
			"31069:30433:28674:27344", -- [2]
			"29950:29951:28624:26853:24032", -- [3]
			"30314:30870:26847:24795:27046", -- [4]
			"31069:30433:28674:28615:28618:26852:26844", -- [5]
			"29950:29951:28624:26853", -- [6]
			"31069:30433:28674:28615:28618:26852", -- [7]
			"31069:30433:28674:26851", -- [8]
			"31069:30433:28674:26850:26845", -- [9]
			"31069:30433:28674:26850:26566", -- [10]
			"30314:30870:26847:25288", -- [11]
			"30314:30870:26847", -- [12]
			"30314:31078:28574:26848", -- [13]
			"31069:30433:28674:26850", -- [14]
			"30314:30870:26847:24795", -- [15]
			"31069:30433:28674:28196", -- [16]
			"31069:30433:28674:28615:28618:26852:26844:28197", -- [17]
			"30314:30870:26847:28195", -- [18]
			"31069:30433:28674:28615:28623", -- [19]
			"31069:30433:28674:28615", -- [20]
			"31069:30433:28674:28615:28618", -- [21]
			"29950:29951:28624", -- [22]
			"30314:31078:28574", -- [23]
			"29950:29757:29721", -- [24]
			"29950:29951:32571", -- [25]
			"29950:29757", -- [26]
			"29950:29951:29762", -- [27]
			"30314:31078", -- [28]
			"29950:29951", -- [29]
			"29950:29951:28624:30569", -- [30]
			"30314:30870", -- [31]
			"31069:30433", -- [32]
			"31069:30433:28674:30269", -- [33]
			"30314:31078:28037:26848", -- [34]
			"30314:31078:28037", -- [35]			
			["direct"] = "28674:29950:30314:31069",
			["coord"] = 3118086692,
			["m"] = 118,
			["f"] = 0,
		},
		[29951] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"29950:30314:30870:26847:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"29757:29721:28615:28618:26852", -- [7]
			"29757:29721:28615:26851", -- [8]
			"29757:29721:28615:26845", -- [9]
			"29757:30433:28674:26850:26566", -- [10]
			"29757:30433:28674:25288", -- [11]
			"29950:30314:30870:26847", -- [12]
			"29950:30314:31078:28574:26848", -- [13]
			"29757:30433:28674:26850", -- [14]
			"29950:30314:30870:26847:24795", -- [15]
			"29757:30433:28674:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"29950:30314:30870:26847:28195", -- [18]
			"28624:28623", -- [19]
			"29757:29721:28615", -- [20]
			"29757:29721:28615:28618", -- [21]
			"29950:30314:31078:28574", -- [22]
			"29757:30433:28674", -- [23]
			"29757:29721", -- [24]
			"29950:30314:31078", -- [25]
			"28624:30569", -- [26]
			"29950:30314:30870", -- [27]
			"29950:30314", -- [28]
			"29757:30433", -- [29]
			"29757:30433:31069", -- [30]
			"29757:29721:30269", -- [31]
			"29950:33849", -- [32]
			"29950:30314:31078:28037:26848", -- [33]
			"29950:30314:31078:28037", -- [34]			
			["m"] = 120,
			["coord"] = 1911834618,
			["direct"] = "28624:32571:29757:29762:29950",
			["f"] = 0,
		},
		[29757] = {
			"29721:28615:28618:26852:26844:24155", -- [1]
			"29762:28624:26853:27344", -- [2]
			"29762:28624:26853:24032", -- [3]
			"30433:28674:25288:24795:27046", -- [4]
			"29721:28615:28618:26852:26844", -- [5]
			"29762:28624:26853", -- [6]
			"29721:28615:28618:26852", -- [7]
			"29721:28615:26851", -- [8]
			"29721:28615:26845", -- [9]
			"30433:28674:26850:26566", -- [10]
			"30433:28674:25288", -- [11]
			"30433:31069:30870:26847", -- [12]
			"30433:28674:28574:26848", -- [13]
			"30433:28674:26850", -- [14]
			"30433:28674:25288:24795", -- [15]
			"30433:28674:28196", -- [16]
			"29721:28615:28618:26852:26844:28197", -- [17]
			"30433:31069:30870:26847:28195", -- [18]
			"29721:28615:28623", -- [19]
			"29721:28615", -- [20]
			"29721:28615:28618", -- [21]
			"29762:28624", -- [22]
			"30433:28674:28574", -- [23]
			"30433:28674", -- [24]
			"29762:32571", -- [25]
			"29950:30314:31078", -- [26]
			"29762:28624:30569", -- [27]
			"30433:31069:30870", -- [28]
			"29950:30314", -- [29]
			"30433:31069", -- [30]
			"29721:30269", -- [31]
			"29950:33849", -- [32]
			"29950:30314:31078:28037", -- [33]			
			["m"] = 120,
			["coord"] = 1555988062,
			["direct"] = "29721:29762:29951:29950:30433",
			["f"] = 0,
		},
		[31069] = {
			"30433:28674:26850:26845:24155", -- [1]
			"30433:28674:27344", -- [2]
			"30433:28674:28615:28618:26853:24032", -- [3]
			"30870:26847:24795:27046", -- [4]
			"30433:28674:28615:28618:26852:26844", -- [5]
			"30433:28674:28615:28618:26853", -- [6]
			"30433:28674:28615:28618:26852", -- [7]
			"30433:28674:26851", -- [8]
			"30433:28674:26850:26845", -- [9]
			"30433:28674:26850:26566", -- [10]
			"30870:26847:25288", -- [11]
			"30870:26847", -- [12]
			"30870:28574:26848", -- [13]
			"30433:28674:26850", -- [14]
			"30870:26847:24795", -- [15]
			"30433:28674:28196", -- [16]
			"30433:28674:28615:28618:26852:26844:28197", -- [17]
			"30870:26847:28195", -- [18]
			"30433:28674:28615:28623", -- [19]
			"30433:28674:28615", -- [20]
			"30433:28674:28615:28618", -- [21]
			"30433:28674:28615:28623:28624", -- [22]
			"30870:28574", -- [23]
			"30433:28674:29721", -- [24]
			"30433:28674:29721:32571", -- [25]
			"30433:29757", -- [26]
			"30433:28674:29721:29762", -- [27]
			"30433:29757:29951", -- [28]
			"33849:29950", -- [29]
			"30433:28674:28615:28623:28624:30569", -- [30]
			"30433:28674:30269", -- [31]
			"30870:28574:28037", -- [1]			
			["m"] = 118,
			["coord"] = 3408050485,
			["direct"] = "28674:31078:30870:30314:30433:33849",
			["f"] = 0,
		},
		[28674] = {
			"26850:26845:24155", -- [1]
			"28615:28618:26853:24032", -- [2]
			"25288:24795:27046", -- [3]
			"28615:28618:26852:26844", -- [4]
			"28615:28618:26853", -- [5]
			"28615:28618:26852", -- [6]
			"26850:26845", -- [7]
			"26850:26566", -- [8]
			"26850:26566:26847", -- [9]
			"28574:26848", -- [10]
			"25288:24795", -- [11]
			"28615:28618:26852:26844:28197", -- [12]
			"26850:26566:26847:28195", -- [13]
			"28615:28623", -- [14]
			"28615:28618", -- [15]
			"28615:28623:28624", -- [16]
			"29721:32571", -- [17]
			"29721:29757", -- [18]
			"29721:29762", -- [19]
			"31069:31078", -- [20]
			"29721:29757:29951", -- [21]
			"29721:29757:29950", -- [22]
			"28615:28623:28624:30569", -- [23]
			"31069:30314", -- [24]
			"28574:28037", -- [25]
			"28574:28037", -- [26]			
			["m"] = 125,
			["coord"] = 3111024148,
			["direct"] = "27344:26851:25288:26850:28196:28615:28574:29721:30870:30433:31069:30269:33849",
			["f"] = 0,
		},
		[29950] = {
			"29951:28624:26853:24032:24155", -- [1]
			"29951:28624:26853:27344", -- [2]
			"29951:28624:26853:24032", -- [3]
			"30314:30870:26847:24795:27046", -- [4]
			"29757:29721:28615:28618:26852:26844", -- [5]
			"29951:28624:26853", -- [6]
			"29757:29721:28615:28618:26852", -- [7]
			"29757:29721:28615:26851", -- [8]
			"29757:29721:28615:26845", -- [9]
			"29757:30433:28674:26850:26566", -- [10]
			"30314:30870:26847:25288", -- [11]
			"30314:30870:26847", -- [12]
			"30314:31078:28574:26848", -- [13]
			"29757:30433:28674:26850", -- [14]
			"30314:30870:26847:24795", -- [15]
			"29757:30433:28674:28196", -- [16]
			"29757:29721:28615:28618:26852:26844:28197", -- [17]
			"30314:30870:26847:28195", -- [18]
			"29757:29721:28615:28623", -- [19]
			"29757:29721:28615", -- [20]
			"29757:29721:28615:28618", -- [21]
			"29951:28624", -- [22]
			"30314:31078:28574", -- [23]
			"29757:30433:28674", -- [24]
			"29757:29721", -- [25]
			"29951:32571", -- [26]
			"29951:29762", -- [27]
			"30314:31078", -- [28]
			"29951:28624:30569", -- [29]
			"30314:30870", -- [30]
			"29757:30433", -- [31]
			"33849:31069", -- [32]
			"29757:29721:30269", -- [33]
			"30314:31078:28037:26848", -- [34]
			"30314:31078:28037", -- [35]			
			["direct"] = "29757:29951:30314:33849",
			["coord"] = 1315200266,
			["m"] = 120,
			["f"] = 0,
		},
		[24795] = {
			"26847:26566:26845:24155", -- [1]
			"26847:26566:26845:26852:24032:27344", -- [2]
			"26847:26566:26845:26852:24032", -- [3]
			"26847:26566:26845:26844", -- [4]
			"26847:26566:26845:26852:26853", -- [5]
			"26847:26566:26845:26852", -- [6]
			"26847:26566:26851", -- [7]
			"26847:26566:26845", -- [8]
			"26847:26566", -- [9]
			"26847:26566:26850", -- [10]
			"26847:28195:28196", -- [11]
			"26847:26566:26845:26844:28197", -- [12]
			"26847:28195", -- [13]
			"26847:26566:26851:28615:28623", -- [14]
			"26847:26566:26851:28615", -- [15]
			"26847:26566:26845:28618", -- [16]
			"26847:26566:26851:28615:28623:28624", -- [17]
			"26848:28574", -- [18]
			"26847:26566:26850:28674", -- [19]
			"26847:26566:26850:28674:29721", -- [20]
			"26847:26566:26850:28674:29721:32571", -- [21]
			"26847:26566:26850:28674:29721:29757", -- [22]
			"26847:26566:26850:28674:29721:29762", -- [23]
			"26848:28574:31078", -- [24]
			"26848:28574:31078:30314:29950:29951", -- [25]
			"26848:28574:31078:30314:29950", -- [26]
			"26847:26566:26851:28615:28623:28624:30569", -- [27]
			"26847:30870", -- [28]
			"26848:28574:31078:30314", -- [29]
			"26847:26566:26850:28674:30433", -- [30]
			"26847:30870:31069", -- [31]
			"26847:26566:26850:28674:30269", -- [32]
			"26848:28574:31078:30314:33849", -- [33]
			"26848:28037", -- [34]
			"26848:28037:31078", -- [35]
			"26848:28037:31078:30314:29950:29951", -- [36]
			"26848:28037:31078:30314:29950", -- [37]
			"26848:28037:31078:30314", -- [38]
			"26848:28037:31078:30314:33849", -- [39]			
			["direct"] = "27046:25288:26847:26848",
			["f"] = 0,
			["m"] = 114,
			["coord"] = 1939560416,
		},
		[32571] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"29721:28674:25288:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"28624:28623:28618:26852", -- [7]
			"29721:28615:26851", -- [8]
			"29721:28615:26845", -- [9]
			"29721:28674:26850:26566", -- [10]
			"29721:28674:25288", -- [11]
			"29721:28674:26850:26566:26847", -- [12]
			"29721:28674:28574:26848", -- [13]
			"29721:28674:26850", -- [14]
			"29721:28674:25288:24795", -- [15]
			"29721:28615:26851:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"29721:28615:26851:28196:28195", -- [18]
			"28624:28623", -- [19]
			"29721:28615", -- [20]
			"28624:28623:28618", -- [21]
			"29721:28674:28574", -- [22]
			"29721:28674", -- [23]
			"29951:29757", -- [24]
			"29951:29950:30314:31078", -- [25]
			"29951:29950", -- [26]
			"28624:30569", -- [27]
			"29721:28674:30870", -- [28]
			"29951:29950:30314", -- [29]
			"29721:28674:30433", -- [30]
			"29721:28674:31069", -- [31]
			"29721:30269", -- [32]
			"29951:29950:33849", -- [33]
			"29721:28674:28574:28037", -- [34]
			"29762:29757", -- [35]
			["direct"] = "28624:29721:29762:29951",
			["coord"] = 2686753797,
			["m"] = 120,
			["f"] = 0,
		},
		[30870] = {
			"26566:26845:24155", -- [1]
			"26566:26845:26852:24032:27344", -- [2]
			"26566:26845:26852:24032", -- [3]
			"26847:24795:27046", -- [4]
			"26566:26845:26844", -- [5]
			"26566:26845:26852:26853", -- [6]
			"26566:26845:26852", -- [7]
			"26566:26851", -- [8]
			"26566:26845", -- [9]
			"26847:25288", -- [10]
			"28574:26848", -- [11]
			"26566:26850", -- [12]
			"26847:24795", -- [13]
			"26566:28196", -- [14]
			"26566:26845:26844:28197", -- [15]
			"26847:28195", -- [16]
			"28674:28615:28623", -- [17]
			"28674:28615", -- [18]
			"28674:28615:28618", -- [19]
			"28674:28615:28623:28624", -- [20]
			"28674:29721", -- [21]
			"28674:29721:32571", -- [22]
			"28674:29721:29757", -- [23]
			"28674:29721:29762", -- [24]
			"28674:29721:29757:29951", -- [25]
			"30314:29950", -- [26]
			"28674:28615:28623:28624:30569", -- [27]
			"28674:30433", -- [28]
			"28674:30269", -- [29]
			"30314:33849", -- [30]
			"28574:28037", -- [31]
			["m"] = 123,
			["coord"] = 929192263,
			["direct"] = "26566:26847:28574:28674:31078:30314:31069",
			["f"] = 0,
		},
		[28037] = {
			"26848:26847:26566:26845:24155", -- [1]
			"26848:26847:26566:26845:26852:24032:27344", -- [2]
			"26848:26847:26566:26845:26852:24032", -- [3]
			"26848:24795:27046", -- [4]
			"26848:26847:26566:26845:26844", -- [5]
			"26848:26847:26566:26845:26852:26853", -- [6]
			"26848:26847:26566:26845:26852", -- [7]
			"26848:26847:26566:26851", -- [8]
			"26848:26847:26566:26845", -- [9]
			"26848:26847:26566", -- [10]
			"26848:25288", -- [11]
			"26848:26847", -- [12]
			"26848:26847:26566:26850", -- [13]
			"26848:24795", -- [14]
			"26848:26847:28195:28196", -- [15]
			"26848:26847:26566:26845:26844:28197", -- [16]
			"26848:26847:28195", -- [17]
			"28574:28674:28615:28623", -- [18]
			"28574:28674:28615", -- [19]
			"28574:28674:28615:28618", -- [20]
			"28574:28674:28615:28623:28624", -- [21]
			"28574:28674", -- [22]
			"28574:28674:29721", -- [23]
			"28574:28674:29721:32571", -- [24]
			"31078:30314:29950:29757", -- [25]
			"28574:28674:29721:29762", -- [26]
			"31078:30314:29950:29951", -- [27]
			"31078:30314:29950", -- [28]
			"28574:28674:28615:28623:28624:30569", -- [29]
			"28574:30870", -- [30]
			"31078:30314", -- [31]
			"28574:28674:30433", -- [32]
			"31078:31069", -- [33]
			"28574:28674:30269", -- [34]
			"31078:30314:33849", -- [35]
			["direct"] = "26848:28574:31078",
			["coord"] = 1083348327,
			["m"] = 119,
			["f"] = 0,
			["requirements"] = "qid:12523"
		},		
		[29762] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"29721:28674:25288:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"28624:28623:28618:26852", -- [7]
			"29721:28615:26851", -- [8]
			"29721:28615:26845", -- [9]
			"29721:28674:26850:26566", -- [10]
			"29721:28674:25288", -- [11]
			"29721:28674:26850:26566:26847", -- [12]
			"29721:28674:28574:26848", -- [13]
			"29721:28674:26850", -- [14]
			"29721:28674:25288:24795", -- [15]
			"29721:28615:26851:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"29721:28615:26851:28196:28195", -- [18]
			"28624:28623", -- [19]
			"29721:28615", -- [20]
			"28624:28623:28618", -- [21]
			"29721:28674:28574", -- [22]
			"29721:28674", -- [23]
			"29951:29950:30314:31078", -- [24]
			"29951:29950", -- [25]
			"28624:30569", -- [26]
			"29721:28674:30870", -- [27]
			"29951:29950:30314", -- [28]
			"29757:30433", -- [29]
			"29757:30433:31069", -- [30]
			"29721:30269", -- [31]
			"29951:29950:33849", -- [32]
			"29951:29950:30314:31078:28037", -- [33]
			["m"] = 120,
			["coord"] = 2809037259,
			["direct"] = "28624:29721:32571:29757:29951",
			["f"] = 0,
		},
		[27344] = {
			"24032:26844:26845:26851:26566:26847:24795:27046", -- [1]
			"24032:26844", -- [2]
			"24032:26852", -- [3]
			"24032:26844:26845:26851", -- [4]
			"24032:26844:26845", -- [5]
			"24032:26844:26845:26851:26566", -- [6]
			"24032:26844:26845:28196:28195:25288", -- [7]
			"24032:26844:26845:26851:26566:26847", -- [8]
			"24032:26844:26845:26851:26566:26847:26848", -- [9]
			"26853:28618:28615:26850", -- [10]
			"24032:26844:26845:26851:26566:26847:24795", -- [11]
			"24032:26844:26845:28196", -- [12]
			"24155:28197", -- [13]
			"24032:26844:26845:28196:28195", -- [14]
			"26853:28623", -- [15]
			"26853:28618:28615", -- [16]
			"26853:28618", -- [17]
			"26853:28624", -- [18]
			"28674:28574", -- [19]
			"26853:28618:28615:29721", -- [20]
			"26853:28624:32571", -- [21]
			"26853:28618:28615:29721:29757", -- [22]
			"26853:28624:29762", -- [23]
			"28674:31069:31078", -- [24]
			"26853:28624:29951", -- [25]
			"26853:28618:28615:29721:29757:29950", -- [26]
			"26853:28624:30569", -- [27]
			"28674:30870", -- [28]
			"28674:31069:30314", -- [29]
			"28674:30433", -- [30]
			"28674:31069", -- [31]
			"26853:28618:28615:30269", -- [32]
			"28674:33849", -- [33]
			"28674:28574:28037", -- [34]
			["direct"] = "24155:24032:26853:28674",
			["coord"] = 3394259988,
			["m"] = 117,
			["f"] = 0,
		},
		[30269] = {
			"28615:28618:26852:26844:24155", -- [1]
			"28615:28618:26853:27344", -- [2]
			"28615:28618:26853:24032", -- [3]
			"28674:25288:24795:27046", -- [4]
			"28615:28618:26852:26844", -- [5]
			"28615:28618:26853", -- [6]
			"28615:28618:26852", -- [7]
			"28615:26851", -- [8]
			"28615:26845", -- [9]
			"28674:26850:26566", -- [10]
			"28674:25288", -- [11]
			"28674:26850:26566:26847", -- [12]
			"28674:28574:26848", -- [13]
			"28674:26850", -- [14]
			"28674:25288:24795", -- [15]
			"28615:26851:28196", -- [16]
			"28615:28618:26852:26844:28197", -- [17]
			"28615:26851:28196:28195", -- [18]
			"28615:28623", -- [19]
			"28615:28618", -- [20]
			"28615:28623:28624", -- [21]
			"28674:28574", -- [22]
			"29721:32571", -- [23]
			"29721:29757", -- [24]
			"29721:29762", -- [25]
			"28674:31069:31078", -- [26]
			"29721:29757:29951", -- [27]
			"29721:29757:29950", -- [28]
			"28615:28623:28624:30569", -- [29]
			"28674:30870", -- [30]
			"28674:31069:30314", -- [31]
			"28674:30433", -- [32]
			"28674:31069", -- [33]
			"28674:33849", -- [34]
			"28674:28574:28037", -- [269]			
			["direct"] = "28615:28674:29721",
			["f"] = 0,
			["m"] = 127,
			["coord"] = 3370746011,
		},
		[30433] = {
			"28674:26850:26845:24155", -- [1]
			"28674:27344", -- [2]
			"28674:28615:28618:26853:24032", -- [3]
			"28674:25288:24795:27046", -- [4]
			"28674:28615:28618:26852:26844", -- [5]
			"28674:28615:28618:26853", -- [6]
			"28674:28615:28618:26852", -- [7]
			"28674:26851", -- [8]
			"28674:26850:26845", -- [9]
			"28674:26850:26566", -- [10]
			"28674:25288", -- [11]
			"31069:30870:26847", -- [12]
			"28674:28574:26848", -- [13]
			"28674:26850", -- [14]
			"28674:25288:24795", -- [15]
			"28674:28196", -- [16]
			"28674:28615:28618:26852:26844:28197", -- [17]
			"31069:30870:26847:28195", -- [18]
			"28674:28615:28623", -- [19]
			"28674:28615", -- [20]
			"28674:28615:28618", -- [21]
			"28674:28615:28623:28624", -- [22]
			"28674:28574", -- [23]
			"28674:29721", -- [24]
			"28674:29721:32571", -- [25]
			"28674:29721:29762", -- [26]
			"31069:31078", -- [27]
			"29757:29951", -- [28]
			"29757:29950", -- [29]
			"28674:28615:28623:28624:30569", -- [30]
			"31069:30870", -- [31]
			"28674:30269", -- [32]
			"31069:33849", -- [33]
			"28674:28574:28037", -- [34]
			["direct"] = "28674:29757:30314:31069",
			["f"] = 0,
			["m"] = 118,
			["coord"] = 3770468289,
		},
		[27046] = {
			"24795:26847:26566:26845:24155", -- [1]
			"24795:26847:26566:26845:26852:24032:27344", -- [2]
			"24795:26847:26566:26845:26852:24032", -- [3]
			"24795:26847:26566:26845:26844", -- [4]
			"24795:26847:26566:26845:26852:26853", -- [5]
			"24795:26847:26566:26845:26852", -- [6]
			"24795:26847:26566:26851", -- [7]
			"24795:26847:26566:26845", -- [8]
			"24795:26847:26566", -- [9]
			"24795:25288", -- [10]
			"24795:26847", -- [11]
			"24795:26848", -- [12]
			"24795:26847:26566:26850", -- [13]
			"24795:26847:28195:28196", -- [14]
			"24795:26847:26566:26845:26844:28197", -- [15]
			"24795:26847:28195", -- [16]
			"24795:26847:26566:26851:28615:28623", -- [17]
			"24795:26847:26566:26851:28615", -- [18]
			"24795:26847:26566:26845:28618", -- [19]
			"24795:26847:26566:26851:28615:28623:28624", -- [20]
			"24795:26848:28574", -- [21]
			"24795:26847:26566:26850:28674", -- [22]
			"24795:26847:26566:26850:28674:29721", -- [23]
			"24795:26847:26566:26850:28674:29721:32571", -- [24]
			"24795:26847:26566:26850:28674:29721:29757", -- [25]
			"24795:26847:26566:26850:28674:29721:29762", -- [26]
			"24795:26848:28574:31078", -- [27]
			"24795:26848:28574:31078:30314:29950:29951", -- [28]
			"24795:26848:28574:31078:30314:29950", -- [29]
			"24795:26847:26566:26851:28615:28623:28624:30569", -- [30]
			"24795:26847:30870", -- [31]
			"24795:26848:28574:31078:30314", -- [32]
			"24795:26847:26566:26850:28674:30433", -- [33]
			"24795:26847:30870:31069", -- [34]
			"24795:26847:26566:26850:28674:30269", -- [35]
			"24795:26848:28574:31078:30314:33849", -- [36]
			"24795:26848:28037", -- [37]
			"24795:26848:28037:31078", -- [38]
			"24795:26848:28037:31078:30314:29950:29951", -- [39]
			"24795:26848:28037:31078:30314:29950", -- [40]
			"24795:26848:28037:31078:30314", -- [41]
			"24795:26848:28037:31078:30314:33849", -- [43]			
			["direct"] = "24795",
			["f"] = 0,
			["m"] = 114,
			["coord"] = 1422481428,
		},
		[26844] = {
			"24032:27344", -- [1]
			"26845:26851:26566:26847:24795:27046", -- [2]
			"24032:26853", -- [3]
			"26845:26851", -- [4]
			"26845:26851:26566", -- [5]
			"26845:28196:28195:25288", -- [6]
			"26845:26851:26566:26847", -- [7]
			"26845:26851:26566:26847:26848", -- [8]
			"26845:26851:26850", -- [9]
			"26845:26851:26566:26847:24795", -- [10]
			"26845:28196", -- [11]
			"26845:28196:28195", -- [12]
			"26852:28618:28623", -- [13]
			"26852:28618:28615", -- [14]
			"26852:28618", -- [15]
			"24032:26853:28624", -- [16]
			"26845:26851:26566:30870:28574", -- [17]
			"26852:28618:28615:28674", -- [18]
			"26852:28618:28615:29721", -- [19]
			"24032:26853:28624:32571", -- [20]
			"26852:28618:28615:29721:29757", -- [21]
			"24032:26853:28624:29762", -- [22]
			"26852:28618:28615:28674:31069:31078", -- [23]
			"26852:28618:28615:29721:29757:29951", -- [24]
			"26852:28618:28615:29721:29757:29950", -- [25]
			"24032:26853:28624:30569", -- [26]
			"26845:26851:26566:30870", -- [27]
			"26852:28618:28615:28674:31069:30314", -- [28]
			"26852:28618:28615:28674:30433", -- [29]
			"26852:28618:28615:28674:31069", -- [30]
			"26852:28618:28615:30269", -- [31]
			"26852:28618:28615:28674:33849", -- [32]
			"26845:26851:26566:26847:26848:28037", -- [33]
			["m"] = 117,
			["coord"] = 1115308011,
			["direct"] = "24155:24032:26852:26845:28197",
			["f"] = 0,
		},
		[26845] = {
			"26852:24032:27344", -- [1]
			"26852:24032", -- [2]
			"26851:26566:26847:24795:27046", -- [3]
			"26852:26853", -- [4]
			"28196:28195:25288", -- [5]
			"26851:26566:26847", -- [6]
			"26851:26566:26847:26848", -- [7]
			"26851:26566:26847:24795", -- [8]
			"26844:28197", -- [9]
			"28196:28195", -- [10]
			"28615:28623", -- [11]
			"28615:28623:28624", -- [12]
			"26851:26566:30870:28574", -- [13]
			"26851:28674", -- [14]
			"28615:29721", -- [15]
			"28615:29721:32571", -- [16]
			"28615:29721:29757", -- [17]
			"28615:29721:29762", -- [18]
			"26851:26566:30870:31078", -- [19]
			"28615:29721:29757:29951", -- [20]
			"28615:29721:29757:29950", -- [21]
			"28615:28623:28624:30569", -- [22]
			"26851:26566:30870", -- [23]
			"26851:28674:31069:30314", -- [24]
			"26851:28674:30433", -- [25]
			"26851:28674:31069", -- [26]
			"28615:30269", -- [27]
			"26851:28674:33849", -- [28]
			"26851:26566:26847:26848:28037", -- [29]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "24155:26844:26852:26851:26566:26850:28196:28615:28618",
			["coord"] = 3285163912,
		},
		[28574] = {
			"30870:26566:26845:24155", -- [1]
			"30870:26566:26845:26852:24032:27344", -- [2]
			"30870:26566:26845:26852:24032", -- [3]
			"26848:24795:27046", -- [4]
			"30870:26566:26845:26844", -- [5]
			"28674:28615:28618:26853", -- [6]
			"30870:26566:26845:26852", -- [7]
			"30870:26566:26851", -- [8]
			"30870:26566:26845", -- [9]
			"30870:26566", -- [10]
			"26848:25288", -- [11]
			"26848:26847", -- [12]
			"30870:26566:26850", -- [13]
			"26848:24795", -- [14]
			"30870:26566:28196", -- [15]
			"30870:26566:26845:26844:28197", -- [16]
			"26848:26847:28195", -- [17]
			"28674:28615:28623", -- [18]
			"28674:28615", -- [19]
			"28674:28615:28618", -- [20]
			"28674:28615:28623:28624", -- [21]
			"28674:29721", -- [22]
			"28674:29721:32571", -- [23]
			"28674:29721:29757", -- [24]
			"28674:29721:29762", -- [25]
			"31078:30314:29950:29951", -- [26]
			"31078:30314:29950", -- [27]
			"28674:28615:28623:28624:30569", -- [28]
			"31078:30314", -- [29]
			"28674:30433", -- [30]
			"28674:31069", -- [31]
			"28674:30269", -- [32]
			"31078:30314:33849", -- [33]
			["direct"] = "26848:28037:28674:31078:30870",
			["coord"] = 2150407428,
			["m"] = 119,
			["f"] = 0,
		},
		[26847] = {
			"26566:26845:24155", -- [1]
			"26566:26845:26852:24032:27344", -- [2]
			"26566:26845:26852:24032", -- [3]
			"24795:27046", -- [4]
			"26566:26845:26844", -- [5]
			"26566:26845:26852:26853", -- [6]
			"26566:26845:26852", -- [7]
			"26566:26851", -- [8]
			"26566:26845", -- [9]
			"26566:26850", -- [10]
			"28195:28196", -- [11]
			"26566:26845:26844:28197", -- [12]
			"26566:26851:28615:28623", -- [13]
			"26566:26851:28615", -- [14]
			"26566:26845:28618", -- [15]
			"26566:26851:28615:28623:28624", -- [16]
			"26848:28574", -- [17]
			"26566:26850:28674", -- [18]
			"26566:26850:28674:29721", -- [19]
			"26566:26850:28674:29721:32571", -- [20]
			"26566:26850:28674:29721:29757", -- [21]
			"26566:26850:28674:29721:29762", -- [22]
			"30870:31078", -- [23]
			"26566:26850:28674:29721:29757:29951", -- [24]
			"30870:30314:29950", -- [25]
			"26566:26851:28615:28623:28624:30569", -- [26]
			"30870:30314", -- [27]
			"26566:26850:28674:30433", -- [28]
			"30870:31069", -- [29]
			"26566:26850:28674:30269", -- [30]
			"30870:30314:33849", -- [31]
			"26848:28037", -- [32]
			["m"] = 114,
			["coord"] = 3338821751,
			["direct"] = "26566:25288:26848:24795:28195:30870",
			["f"] = 0,
		},
		[26848] = {
			"26847:26566:26845:24155", -- [1]
			"26847:26566:26845:26852:24032:27344", -- [2]
			"26847:26566:26845:26852:24032", -- [3]
			"24795:27046", -- [4]
			"26847:26566:26845:26844", -- [5]
			"26847:26566:26845:26852:26853", -- [6]
			"26847:26566:26845:26852", -- [7]
			"26847:26566:26851", -- [8]
			"26847:26566:26845", -- [9]
			"26847:26566", -- [10]
			"26847:26566:26850", -- [11]
			"26847:28195:28196", -- [12]
			"26847:26566:26845:26844:28197", -- [13]
			"26847:28195", -- [14]
			"26847:26566:26851:28615:28623", -- [15]
			"26847:26566:26851:28615", -- [16]
			"26847:26566:26845:28618", -- [17]
			"26847:26566:26851:28615:28623:28624", -- [18]
			"28574:28674", -- [19]
			"28574:28674:29721", -- [20]
			"28574:28674:29721:32571", -- [21]
			"28574:28674:29721:29757", -- [22]
			"28574:28674:29721:29762", -- [23]
			"28574:31078", -- [24]
			"28574:31078:30314:29950:29951", -- [25]
			"28574:31078:30314:29950", -- [26]
			"26847:26566:26851:28615:28623:28624:30569", -- [27]
			"28574:30870", -- [28]
			"28574:31078:30314", -- [29]
			"28574:28674:30433", -- [30]
			"28574:28674:31069", -- [31]
			"28574:28674:30269", -- [32]
			"28574:31078:30314:33849", -- [33]
			"28037:31078", -- [34]
			"28037:31078:30314:29950:29951", -- [35]
			"28037:31078:30314:29950", -- [36]
			"28037:31078:30314", -- [37]
			"28037:31078:30314:33849", -- [38]			
			["direct"] = "25288:26847:24795:28574:28037",
			["f"] = 0,
			["m"] = 114,
			["coord"] = 2129861678,
		},
		[30314] = {
			"30870:26566:26845:24155", -- [1]
			"30433:28674:27344", -- [2]
			"30433:28674:28615:28618:26853:24032", -- [3]
			"30870:26847:24795:27046", -- [4]
			"30870:26566:26845:26844", -- [5]
			"30433:28674:28615:28618:26853", -- [6]
			"30433:28674:28615:28618:26852", -- [7]
			"30433:28674:26851", -- [8]
			"30870:26566:26845", -- [9]
			"30870:26566", -- [10]
			"30870:26847:25288", -- [11]
			"30870:26847", -- [12]
			"31078:28574:26848", -- [13]
			"30433:28674:26850", -- [14]
			"30870:26847:24795", -- [15]
			"30870:26566:28196", -- [16]
			"30870:26566:26845:26844:28197", -- [17]
			"30870:26847:28195", -- [18]
			"30433:28674:28615:28623", -- [19]
			"30433:28674:28615", -- [20]
			"30433:28674:28615:28618", -- [21]
			"29950:29951:28624", -- [22]
			"31078:28574", -- [23]
			"30433:28674", -- [24]
			"30433:28674:29721", -- [25]
			"29950:29951:32571", -- [26]
			"29950:29757", -- [27]
			"29950:29951:29762", -- [28]
			"29950:29951", -- [29]
			"29950:29951:28624:30569", -- [30]
			"30433:28674:30269", -- [31]
			"31078:28037:26848", -- [32]
			"31078:28037", -- [33]			
			["m"] = 118,
			["coord"] = 1878408808,
			["direct"] = "31078:29950:30870:30433:31069:33849",
			["f"] = 0,
		},
		[26850] = {
			"26845:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"26566:26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"26566:26847:25288", -- [8]
			"26566:26847", -- [9]
			"26566:26847:26848", -- [10]
			"26566:26847:24795", -- [11]
			"26566:28196", -- [12]
			"26845:26844:28197", -- [13]
			"26566:26847:28195", -- [14]
			"28615:28623", -- [15]
			"28615:28618", -- [16]
			"28615:28623:28624", -- [17]
			"26566:30870:28574", -- [18]
			"28674:29721", -- [19]
			"28674:29721:32571", -- [20]
			"28674:29721:29757", -- [21]
			"28674:29721:29762", -- [22]
			"28674:31069:31078", -- [23]
			"28674:29721:29757:29951", -- [24]
			"28674:29721:29757:29950", -- [25]
			"28615:28623:28624:30569", -- [26]
			"26566:30870", -- [27]
			"28674:31069:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"28674:30269", -- [31]
			"28674:33849", -- [32]
			"26566:26847:26848:28037", -- [33]
			["m"] = 115,
			["coord"] = 1884760835,
			["direct"] = "26851:26845:26566:28615:28674",
			["f"] = 0,
		},
		[26851] = {
			"26845:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"26566:26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"26566:26847:25288", -- [8]
			"26566:26847", -- [9]
			"26566:26847:26848", -- [10]
			"26566:26847:24795", -- [11]
			"26845:26844:28197", -- [12]
			"28196:28195", -- [13]
			"28615:28623", -- [14]
			"28615:28618", -- [15]
			"28615:28623:28624", -- [16]
			"26566:30870:28574", -- [17]
			"28615:29721", -- [18]
			"28615:29721:32571", -- [19]
			"28615:29721:29757", -- [20]
			"28615:29721:29762", -- [21]
			"26566:30870:31078", -- [22]
			"28615:29721:29757:29951", -- [23]
			"28615:29721:29757:29950", -- [24]
			"28615:28623:28624:30569", -- [25]
			"26566:30870", -- [26]
			"28674:31069:30314", -- [27]
			"28674:30433", -- [28]
			"28674:31069", -- [29]
			"28615:30269", -- [30]
			"28674:33849", -- [31]
			"26566:26847:26848:28037", -- [32]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "26845:26566:26850:28196:28615:28674",
			["coord"] = 2588115855,
		},
		[28615] = {
			"28618:26852:26844:24155", -- [1]
			"28618:26853:27344", -- [2]
			"28618:26853:24032", -- [3]
			"26850:26566:26847:24795:27046", -- [4]
			"28618:26852:26844", -- [5]
			"28618:26853", -- [6]
			"28618:26852", -- [7]
			"26850:26566", -- [8]
			"28674:25288", -- [9]
			"26850:26566:26847", -- [10]
			"28674:28574:26848", -- [11]
			"26850:26566:26847:24795", -- [12]
			"26851:28196", -- [13]
			"28618:26852:26844:28197", -- [14]
			"26851:28196:28195", -- [15]
			"28623:28624", -- [16]
			"28674:28574", -- [17]
			"29721:32571", -- [18]
			"29721:29757", -- [19]
			"29721:29762", -- [20]
			"28674:31069:31078", -- [21]
			"29721:29757:29951", -- [22]
			"29721:29757:29950", -- [23]
			"28623:28624:30569", -- [24]
			"28674:30870", -- [25]
			"28674:31069:30314", -- [26]
			"28674:30433", -- [27]
			"28674:31069", -- [28]
			"28674:33849", -- [29]
			"28674:28574:28037", -- [30]
			["m"] = 121,
			["f"] = 0,
			["direct"] = "26851:26845:26850:28623:28618:28674:29721:30269",
			["coord"] = 603962466,
		},
	}, -- [4]
	[6] = {
		[65863] = {
			"61122:60230:60952", -- [1]
			"61122:60230:59186", -- [2]
			"61122:60230:59186:59732", -- [3]
			"62901:61473:61745:61474:66227:59736:59735:59733", -- [4]
			"62901:61473:61745:61474:66227:59736:59735", -- [5]
			"62901:61473:61745:61474:66227:59736", -- [6]
			"62901:61473:61745:61474:66227", -- [7]
			"61122:60230", -- [8]
			"61122:60231", -- [9]
			"61122:60231:60232", -- [10]
			"61122:60231:59046", -- [11]
			"62903:63500:63501:58843", -- [12]
			"62903:63500:63501:58843:59047", -- [13]
			"62903:63500:63501:58843:65189", -- [14]
			"62903:63500:63501:58843:59047:60441", -- [15]
			"62901:61473:61745:61474", -- [16]
			"62901:61512:60416:61504:61118", -- [17]
			"62901:61473:61745", -- [18]
			"62901:61512:60416:61504:61118:61511", -- [19]
			"62901:61512:60416:61504", -- [20]
			"62901:61512:60416", -- [21]
			"62901:61473", -- [22]
			"62901:61512", -- [23]
			"61122:62658:61759", -- [24]
			"61122:62658", -- [25]
			"62901:62898", -- [26]
			"62901:62898:62909", -- [27]
			"62903:63500:63501", -- [28]
			"62903:63500:63501:63498", -- [29]
			"62903:63500", -- [30]
			"62903:63500:63497", -- [31]
			"61122:60230:59186:64310", -- [32]
			"62903:63500:63501:65511", -- [33]
			"61122:60230:59186:71939", -- [34]
			--["name"] = "Serpent's Spine, Kun-Lai Summit",
			["m"] = 379,
			["direct"] = "62901:62903:61122",
			["coord"] = 1545786979,
			["f"] = 0,
		},
		[60441] = {
			"59046:60230:60952", -- [1]
			"59046:60230:59186", -- [2]
			"59046:60230:59186:59732", -- [3]
			"59046:60230:59186:59735:59733", -- [4]
			"59046:60230:59186:59735", -- [5]
			"59046:60230:60952:59736", -- [6]
			"59046:60230:60952:66227", -- [7]
			"59046:60230", -- [8]
			"59046:60231", -- [9]
			"59046:60232", -- [10]
			"65189:58843", -- [11]
			"59046:60231:62658:61759:61474", -- [12]
			"59046:60231:62658:61759:61474:61118", -- [13]
			"59046:60231:62658:61759:61474:61745", -- [14]
			"59046:60231:62658:61759:61474:61118:61511", -- [15]
			"59046:60231:62658:61759:61474:61504", -- [16]
			"59046:60231:62658:61759:61474:61745:60416", -- [17]
			"59046:60231:62658:61759:61474:61745:61473", -- [18]
			"59046:60231:62658:61759:61474:61745:60416:61512", -- [19]
			"59046:60231:62658:61759", -- [20]
			"59046:60231:62658", -- [21]
			"59046:60231:61122:65863:62901", -- [22]
			"65189:59047:63501:63500:62903", -- [23]
			"65189:59047:63501:63500:62903:62898", -- [24]
			"65189:59047:63501:63500:62903:62898:62909", -- [25]
			"59046:60231:61122", -- [26]
			"65189:59047:63501", -- [27]
			"65189:59047:63501:63498", -- [28]
			"65189:59047:63501:63500", -- [29]
			"65189:59047:63501:63497", -- [30]
			"59046:60230:59186:64310", -- [31]
			"65189:59047:63501:65511", -- [32]
			"59046:60231:61122:65863", -- [33]
			"59046:60230:59186:71939", -- [34]
			--["name"] = "Marista, Krasarang Wilds",
			["m"] = 418,
			["f"] = 0,
			["direct"] = "59046:59047:65189",
			["coord"] = 2250621975,
		},
		[62658] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"61759:61474:66227", -- [7]
			"60231:60232", -- [8]
			"60231:59046", -- [9]
			"60231:58843", -- [10]
			"60231:58843:59047", -- [11]
			"60231:65189", -- [12]
			"60231:59046:60441", -- [13]
			"61759:61474", -- [14]
			"61759:61474:61118", -- [15]
			"61759:61474:61745", -- [16]
			"61759:61474:61118:61511", -- [17]
			"61759:61474:61504", -- [18]
			"61759:61474:61745:60416", -- [19]
			"61759:61474:61745:61473", -- [20]
			"61759:61474:61745:60416:61512", -- [21]
			"61122:65863:62901", -- [22]
			"61759:61474:61745:61473:62903", -- [23]
			"61759:61474:61745:61473:62903:62898", -- [24]
			"61759:61474:61745:61473:62903:62898:62909", -- [25]
			"60231:58843:63501", -- [26]
			"60231:58843:63501:63498", -- [27]
			"61122:63500", -- [28]
			"61122:63497", -- [29]
			"60230:59186:64310", -- [30]
			"60231:58843:63501:65511", -- [31]
			"61122:65863", -- [32]
			"60230:59186:71939", -- [33]
			--["name"] = "Grassy Cline, Valley of the Four Winds",
			["m"] = 376,
			["f"] = 0,
			["direct"] = "60230:60231:61759:61122",
			["coord"] = 3041672744,
		},
		[61473] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:66227:59736:59735:59733", -- [4]
			"61745:61474:66227:59736:59735", -- [5]
			"61745:61474:66227:59736", -- [6]
			"61745:61474:66227", -- [7]
			"61745:61474:61759:60230", -- [8]
			"61745:61474:61759:62658:60231", -- [9]
			"61745:61474:60232", -- [10]
			"61745:61474:61759:62658:60231:59046", -- [11]
			"62903:63500:63501:58843", -- [12]
			"62903:63500:63501:58843:59047", -- [13]
			"62903:63500:63501:58843:65189", -- [14]
			"62903:63500:63501:58843:59047:60441", -- [15]
			"61745:61474", -- [16]
			"60416:61504:61118", -- [17]
			"60416:61504:61118:61511", -- [18]
			"60416:61504", -- [19]
			"60416:61512", -- [20]
			"61745:61474:61759", -- [21]
			"61745:61474:61759:62658", -- [22]
			"62903:62898", -- [23]
			"62903:62898:62909", -- [24]
			"61745:61122", -- [25]
			"62903:63500:63501", -- [26]
			"62903:63500:63501:63498", -- [27]
			"62903:63500", -- [28]
			"62903:63500:63497", -- [29]
			"61745:61474:61759:60230:59186:64310", -- [30]
			"62903:63500:63501:65511", -- [31]
			"62903:65863", -- [32]
			"61745:61474:61759:60230:59186:71939", -- [33]
			["direct"] = "61745:60416:62901:62903",
			["m"] = 379,
			["coord"] = 1887954259,
			["f"] = 0,
		},
		[64310] = {
			"59186:59732", -- [1]
			"59186:59735:59733", -- [2]
			"59186:59735", -- [3]
			"59186:59736", -- [4]
			"60952:66227", -- [5]
			"60952:60230", -- [6]
			"60952:60230:60231", -- [7]
			"60952:60230:60232", -- [8]
			"60952:60230:59046", -- [9]
			"60952:60230:60231:58843", -- [10]
			"60952:60230:59046:59047", -- [11]
			"60952:60230:60231:65189", -- [12]
			"60952:60230:59046:60441", -- [13]
			"60952:60230:61759:61474", -- [14]
			"60952:60230:61759:61474:61118", -- [15]
			"60952:60230:61759:61474:61745", -- [16]
			"60952:60230:61759:61474:61118:61511", -- [17]
			"60952:60230:61759:61474:61504", -- [18]
			"60952:60230:61759:61474:61745:60416", -- [19]
			"60952:60230:61759:61474:61745:61473", -- [20]
			"60952:60230:61759:61474:61745:60416:61512", -- [21]
			"60952:60230:61759", -- [22]
			"60952:60230:62658", -- [23]
			"60952:60230:62658:61122:65863:62901", -- [24]
			"60952:60230:61759:61474:61745:61473:62903", -- [25]
			"60952:60230:61759:61474:61745:61473:62903:62898", -- [26]
			"60952:60230:61759:61474:61745:61473:62903:62898:62909", -- [27]
			"60952:60230:62658:61122", -- [28]
			"60952:60230:60231:58843:63501", -- [29]
			"60952:60230:60231:58843:63501:63498", -- [30]
			"60952:60230:62658:61122:63500", -- [31]
			"60952:60230:62658:61122:63497", -- [32]
			"60952:60230:60231:58843:63501:65511", -- [33]
			"60952:60230:62658:61122:65863", -- [34]
			"59186:71939", -- [35]
			--["name"] = "Serpent's Overlook, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "60952:59186",
			["coord"] = 1851699009,
		},
		[65511] = {
			"63501:58843:60231:60230:60952", -- [1]
			"63501:58843:60231:60230:59186", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60230:59186:59735:59733", -- [4]
			"63501:58843:60231:60230:59186:59735", -- [5]
			"63501:58843:60231:60230:60952:59736", -- [6]
			"63501:61122:66227", -- [7]
			"63501:58843:60231:60230", -- [8]
			"63501:58843:60231", -- [9]
			"63501:58843:60231:60232", -- [10]
			"63501:58843:60231:59046", -- [11]
			"63501:58843", -- [12]
			"63501:58843:59047", -- [13]
			"63501:58843:65189", -- [14]
			"63501:58843:59047:60441", -- [15]
			"63501:58843:60231:62658:61759:61474", -- [16]
			"63501:63500:62903:61473:60416:61504:61118", -- [17]
			"63501:63500:62903:61473:61745", -- [18]
			"63501:63500:62903:61473:60416:61504:61118:61511", -- [19]
			"63501:63500:62903:61473:60416:61504", -- [20]
			"63501:63500:62903:61473:60416", -- [21]
			"63501:63500:62903:61473", -- [22]
			"63501:63497:61512", -- [23]
			"63501:58843:60231:62658:61759", -- [24]
			"63501:58843:60231:62658", -- [25]
			"63501:63500:62903:62901", -- [26]
			"63501:63500:62903", -- [27]
			"63501:63500:62903:62898", -- [28]
			"63501:63500:62903:62898:62909", -- [29]
			"63501:61122", -- [30]
			"63501:63500", -- [31]
			"63501:63497", -- [32]
			"63501:58843:60231:60230:59186:64310", -- [33]
			"63501:63500:62903:65863", -- [34]
			"63501:58843:60231:60230:59186:71939", -- [35]
			--["name"] = "The Briny Muck, Dread Wastes",
			["m"] = 422,
			["f"] = 0,
			["direct"] = "63501:63498",
			["coord"] = 1829473930,
		},
		[63497] = {
			"61122:60230:60952", -- [1]
			"61122:60230:59186", -- [2]
			"61122:60230:59186:59732", -- [3]
			"61122:66227:59736:59735:59733", -- [4]
			"61122:66227:59736:59735", -- [5]
			"61122:66227:59736", -- [6]
			"61122:66227", -- [7]
			"61122:60230", -- [8]
			"63501:58843:60231", -- [9]
			"63501:58843:60231:60232", -- [10]
			"63501:58843:60231:59046", -- [11]
			"63501:58843", -- [12]
			"63501:58843:59047", -- [13]
			"63501:58843:65189", -- [14]
			"63501:58843:59047:60441", -- [15]
			"61122:61474", -- [16]
			"61122:61745:61118", -- [17]
			"61122:61745", -- [18]
			"61122:61745:61511", -- [19]
			"61122:61745:61504", -- [20]
			"61512:60416", -- [21]
			"63500:62903:61473", -- [22]
			"61122:62658:61759", -- [23]
			"61122:62658", -- [24]
			"63500:62903:62901", -- [25]
			"63500:62903", -- [26]
			"63500:62903:62898", -- [27]
			"63500:62903:62898:62909", -- [28]
			"61122:60230:59186:64310", -- [29]
			"63501:65511", -- [30]
			"63500:62903:65863", -- [31]
			"61122:60230:59186:71939", -- [32]
			--["name"] = "Serpent's Spine, Vale of Eternal Blossoms",
			["direct"] = "61512:61122:63501:63498:63500",
			["f"] = 0,
			["m"] = 390,
			["coord"] = 603966145,
		},
		[63501] = {
			"58843:60231:60230:60952", -- [1]
			"58843:60231:60230:59186", -- [2]
			"58843:60231:60230:59186:59732", -- [3]
			"58843:60231:60230:59186:59735:59733", -- [4]
			"58843:60231:60230:59186:59735", -- [5]
			"58843:60231:60230:60952:59736", -- [6]
			"61122:66227", -- [7]
			"58843:60231:60230", -- [8]
			"58843:60231", -- [9]
			"58843:60231:60232", -- [10]
			"58843:60231:59046", -- [11]
			"58843:65189", -- [12]
			"58843:59047:60441", -- [13]
			"58843:60231:62658:61759:61474", -- [14]
			"63500:62903:61473:60416:61504:61118", -- [15]
			"63500:62903:61473:61745", -- [16]
			"63500:62903:61473:60416:61504:61118:61511", -- [17]
			"63500:62903:61473:60416:61504", -- [18]
			"63500:62903:61473:60416", -- [19]
			"63500:62903:61473", -- [20]
			"63497:61512", -- [21]
			"58843:60231:62658:61759", -- [22]
			"58843:60231:62658", -- [23]
			"63500:62903:62901", -- [24]
			"63500:62903", -- [25]
			"63500:62903:62898", -- [26]
			"63500:62903:62898:62909", -- [27]
			"58843:60231:60230:59186:64310", -- [28]
			"63500:62903:65863", -- [29]
			"58843:60231:60230:59186:71939", -- [30]
			--["name"] = "Klaxxi'vess, Dread Wastes",
			["direct"] = "58843:59047:61122:63498:63500:63497:65511",
			["f"] = 0,
			["m"] = 422,
			["coord"] = 2397264188,
		},
		[60416] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:66227:59736:59735:59733", -- [4]
			"61745:61474:66227:59736:59735", -- [5]
			"61745:61474:66227:59736", -- [6]
			"61745:61474:66227", -- [7]
			"61745:61474:61759:60230", -- [8]
			"61745:61474:61759:62658:60231", -- [9]
			"61745:61474:60232", -- [10]
			"61745:61474:61759:62658:60231:59046", -- [11]
			"61473:62903:63500:63501:58843", -- [12]
			"61473:62903:63500:63501:58843:59047", -- [13]
			"61473:62903:63500:63501:58843:65189", -- [14]
			"61473:62903:63500:63501:58843:59047:60441", -- [15]
			"61745:61474", -- [16]
			"61504:61118", -- [17]
			"61504:61118:61511", -- [18]
			"61745:61474:61759", -- [19]
			"61745:61474:61759:62658", -- [20]
			"61512:62901", -- [21]
			"61473:62903", -- [22]
			"61512:62901:62898", -- [23]
			"61512:62901:62898:62909", -- [24]
			"61745:61122", -- [25]
			"61473:62903:63500:63501", -- [26]
			"61473:62903:63500:63501:63498", -- [27]
			"61473:62903:63500", -- [28]
			"61512:63497", -- [29]
			"61745:61474:61759:60230:59186:64310", -- [30]
			"61473:62903:63500:63501:65511", -- [31]
			"61512:62901:65863", -- [32]
			"61745:61474:61759:60230:59186:71939", -- [33]
			--["name"] = "Kota Basecamp, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "61745:61504:61473:61512",
			["coord"] = 1836691981,
		},
		[58843] = {
			"60231:60230:60952", -- [1]
			"60231:60230:59186", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60230:59186:59735:59733", -- [4]
			"60231:60230:59186:59735", -- [5]
			"60231:60230:60952:59736", -- [6]
			"60231:62658:61759:61474:66227", -- [7]
			"60231:60230", -- [8]
			"60231:60232", -- [9]
			"60231:59046", -- [10]
			"59047:60441", -- [11]
			"60231:62658:61759:61474", -- [12]
			"60231:62658:61759:61474:61118", -- [13]
			"60231:62658:61759:61474:61745", -- [14]
			"60231:62658:61759:61474:61118:61511", -- [15]
			"60231:62658:61759:61474:61504", -- [16]
			"63501:63500:62903:61473:60416", -- [17]
			"63501:63500:62903:61473", -- [18]
			"63501:63497:61512", -- [19]
			"60231:62658:61759", -- [20]
			"60231:62658", -- [21]
			"63501:63500:62903:62901", -- [22]
			"63501:63500:62903", -- [23]
			"63501:63500:62903:62898", -- [24]
			"63501:63500:62903:62898:62909", -- [25]
			"60231:61122", -- [26]
			"63501:63498", -- [27]
			"63501:63500", -- [28]
			"63501:63497", -- [29]
			"60231:60230:59186:64310", -- [30]
			"63501:65511", -- [31]
			"63501:63500:62903:65863", -- [32]
			"60231:60230:59186:71939", -- [33]
			--["name"] = "Stoneplow, Valley of the Four Winds",
			["m"] = 376,
			["f"] = 0,
			["direct"] = "60231:59047:65189:63501",
			["coord"] = 867145194,
		},
		[60231] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"62658:61759:61474:66227", -- [7]
			"58843:59047", -- [8]
			"59046:60441", -- [9]
			"62658:61759:61474", -- [10]
			"62658:61759:61474:61118", -- [11]
			"62658:61759:61474:61745", -- [12]
			"62658:61759:61474:61118:61511", -- [13]
			"62658:61759:61474:61504", -- [14]
			"62658:61759:61474:61745:60416", -- [15]
			"62658:61759:61474:61745:61473", -- [16]
			"62658:61759:61474:61745:60416:61512", -- [17]
			"62658:61759", -- [18]
			"61122:65863:62901", -- [19]
			"58843:63501:63500:62903", -- [20]
			"58843:63501:63500:62903:62898", -- [21]
			"58843:63501:63500:62903:62898:62909", -- [22]
			"58843:63501", -- [23]
			"58843:63501:63498", -- [24]
			"58843:63501:63500", -- [25]
			"58843:63501:63497", -- [26]
			"60230:59186:64310", -- [27]
			"58843:63501:65511", -- [28]
			"61122:65863", -- [29]
			"60230:59186:71939", -- [30]
			--["name"] = "Halfhill, Valley of the Four Winds",
			["direct"] = "60230:60232:59046:58843:65189:62658:61122",
			["f"] = 0,
			["m"] = 376,
			["coord"] = 2423292124,
		},
		[61745] = {
			"61474:61759:60230:60952", -- [1]
			"61474:61759:60230:59186", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:66227:59736:59735:59733", -- [4]
			"61474:66227:59736:59735", -- [5]
			"61474:66227:59736", -- [6]
			"61474:66227", -- [7]
			"61474:61759:60230", -- [8]
			"61474:61759:62658:60231", -- [9]
			"61474:60232", -- [10]
			"61474:61759:62658:60231:59046", -- [11]
			"61474:61759:62658:60231:58843", -- [12]
			"61474:61759:62658:60231:58843:59047", -- [13]
			"61474:61759:62658:60231:65189", -- [14]
			"61474:61759:62658:60231:59046:60441", -- [15]
			"60416:61512", -- [16]
			"61474:61759", -- [17]
			"61474:61759:62658", -- [18]
			"61473:62901", -- [19]
			"61473:62903", -- [20]
			"61473:62903:62898", -- [21]
			"61473:62903:62898:62909", -- [22]
			"61473:62903:63500:63501", -- [23]
			"61473:62903:63500:63501:63498", -- [24]
			"61473:62903:63500", -- [25]
			"61122:63497", -- [26]
			"61474:61759:60230:59186:64310", -- [27]
			"61473:62903:63500:63501:65511", -- [28]
			"61473:62903:65863", -- [29]
			"61474:61759:60230:59186:71939", -- [30]
			--["name"] = "Eastwind Rest, Kun-Lai Summit",
			["direct"] = "61474:61118:61511:61504:60416:61473:61122",
			["f"] = 0,
			["m"] = 379,
			["coord"] = 2682375861,
		},
		[59733] = {
			"59735:59736:60952", -- [1]
			"59735:59186", -- [2]
			"59735:59736", -- [3]
			"59735:59736:66227", -- [4]
			"59735:59186:60230", -- [5]
			"59735:59186:60230:60231", -- [6]
			"59735:59186:60230:60232", -- [7]
			"59735:59186:60230:59046", -- [8]
			"59735:59186:60230:60231:58843", -- [9]
			"59735:59186:60230:59046:59047", -- [10]
			"59735:59186:60230:60231:65189", -- [11]
			"59735:59186:60230:59046:60441", -- [12]
			"59735:59736:66227:61474", -- [13]
			"59735:59736:66227:61474:61118", -- [14]
			"59735:59736:66227:61474:61745", -- [15]
			"59735:59736:66227:61474:61118:61511", -- [16]
			"59735:59736:66227:61474:61504", -- [17]
			"59735:59736:66227:61474:61745:60416", -- [18]
			"59735:59736:66227:61474:61745:61473", -- [19]
			"59735:59736:66227:61474:61745:60416:61512", -- [20]
			"59735:59186:60230:61759", -- [21]
			"59735:59186:60230:62658", -- [22]
			"59735:59736:66227:61474:61745:61473:62901", -- [23]
			"59735:59736:66227:61474:61745:61473:62903", -- [24]
			"59735:59736:66227:61474:61745:61473:62903:62898", -- [25]
			"59735:59736:66227:61474:61745:61473:62903:62898:62909", -- [26]
			"59735:59736:66227:61122", -- [27]
			"59735:59186:60230:60231:58843:63501", -- [28]
			"59735:59186:60230:60231:58843:63501:63498", -- [29]
			"59735:59736:66227:61474:61745:61473:62903:63500", -- [30]
			"59735:59736:66227:61122:63497", -- [31]
			"59735:59186:64310", -- [32]
			"59735:59186:60230:60231:58843:63501:65511", -- [33]
			"59735:59736:66227:61474:61745:61473:62903:65863", -- [34]
			"59735:59186:71939", -- [35]
			--["name"] = "Sri-La Village, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59732:59735",
			["coord"] = 2380414099,
		},
		[59735] = {
			"59736:60952", -- [1]
			"59186:59732", -- [2]
			"59736:66227", -- [3]
			"59186:60230", -- [4]
			"59186:60230:60231", -- [5]
			"59186:60230:60232", -- [6]
			"59186:60230:59046", -- [7]
			"59186:60230:60231:58843", -- [8]
			"59186:60230:59046:59047", -- [9]
			"59186:60230:60231:65189", -- [10]
			"59186:60230:59046:60441", -- [11]
			"59736:66227:61474", -- [12]
			"59736:66227:61474:61118", -- [13]
			"59736:66227:61474:61745", -- [14]
			"59736:66227:61474:61118:61511", -- [15]
			"59736:66227:61474:61504", -- [16]
			"59736:66227:61474:61745:60416", -- [17]
			"59736:66227:61474:61745:61473", -- [18]
			"59736:66227:61474:61745:60416:61512", -- [19]
			"59186:60230:61759", -- [20]
			"59186:60230:62658", -- [21]
			"59736:66227:61474:61745:61473:62901", -- [22]
			"59736:66227:61474:61745:61473:62903", -- [23]
			"59736:66227:61474:61745:61473:62903:62898", -- [24]
			"59736:66227:61474:61745:61473:62903:62898:62909", -- [25]
			"59736:66227:61122", -- [26]
			"59186:60230:60231:58843:63501", -- [27]
			"59186:60230:60231:58843:63501:63498", -- [28]
			"59736:66227:61474:61745:61473:62903:63500", -- [29]
			"59736:66227:61122:63497", -- [30]
			"59186:64310", -- [31]
			"59186:60230:60231:58843:63501:65511", -- [32]
			"59736:66227:61474:61745:61473:62903:65863", -- [33]
			"59186:71939", -- [34]
			--["name"] = "Emperor's Omen, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59186:59733:59736",
			["coord"] = 2184266963,
		},
		[59046] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"60230:60952:66227", -- [7]
			"60231:58843", -- [8]
			"59047:65189", -- [9]
			"60231:62658:61759:61474", -- [10]
			"60231:62658:61759:61474:61118", -- [11]
			"60231:62658:61759:61474:61745", -- [12]
			"60231:62658:61759:61474:61118:61511", -- [13]
			"60231:62658:61759:61474:61504", -- [14]
			"60231:62658:61759:61474:61745:60416", -- [15]
			"60231:62658:61759:61474:61745:61473", -- [16]
			"60231:62658:61759:61474:61745:60416:61512", -- [17]
			"60231:62658:61759", -- [18]
			"60231:62658", -- [19]
			"60231:61122:65863:62901", -- [20]
			"60231:58843:63501:63500:62903", -- [21]
			"60231:58843:63501:63500:62903:62898", -- [22]
			"60231:58843:63501:63500:62903:62898:62909", -- [23]
			"60231:61122", -- [24]
			"60231:58843:63501", -- [25]
			"60231:58843:63501:63498", -- [26]
			"60231:58843:63501:63500", -- [27]
			"60231:58843:63501:63497", -- [28]
			"60230:59186:64310", -- [29]
			"60231:58843:63501:65511", -- [30]
			"60231:61122:65863", -- [31]
			"60230:59186:71939", -- [32]
			--["name"] = "Thunder Cleft, Krasarang Wilds",
			["direct"] = "60230:60231:60232:59047:60441",
			["f"] = 0,
			["m"] = 418,
			["coord"] = 2543992551,
		},
		[61759] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"61474:66227", -- [7]
			"62658:60231", -- [8]
			"60230:60232", -- [9]
			"62658:60231:59046", -- [10]
			"62658:60231:58843", -- [11]
			"62658:60231:58843:59047", -- [12]
			"62658:60231:65189", -- [13]
			"62658:60231:59046:60441", -- [14]
			"61474:61118", -- [15]
			"61474:61745", -- [16]
			"61474:61118:61511", -- [17]
			"61474:61504", -- [18]
			"61474:61745:60416", -- [19]
			"61474:61745:61473", -- [20]
			"61474:61745:60416:61512", -- [21]
			"61474:61745:61473:62901", -- [22]
			"61474:61745:61473:62903", -- [23]
			"61474:61745:61473:62903:62898", -- [24]
			"61474:61745:61473:62903:62898:62909", -- [25]
			"62658:61122", -- [26]
			"62658:60231:58843:63501", -- [27]
			"62658:60231:58843:63501:63498", -- [28]
			"62658:61122:63500", -- [29]
			"62658:61122:63497", -- [30]
			"60230:59186:64310", -- [31]
			"62658:60231:58843:63501:65511", -- [32]
			"62658:61122:65863", -- [33]
			"60230:59186:71939", -- [34]
			--["name"] = "Tavern in the Mists, The Veiled Stair",
			["m"] = 433,
			["f"] = 0,
			["direct"] = "60230:61474:62658",
			["coord"] = 2433204651,
		},
		[61511] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:66227:59736:59735:59733", -- [4]
			"61745:61474:66227:59736:59735", -- [5]
			"61745:61474:66227:59736", -- [6]
			"61745:61474:66227", -- [7]
			"61745:61474:61759:60230", -- [8]
			"61745:61474:61759:62658:60231", -- [9]
			"61745:61474:60232", -- [10]
			"61745:61474:61759:62658:60231:59046", -- [11]
			"61745:61474:61759:62658:60231:58843", -- [12]
			"61745:61474:61759:62658:60231:58843:59047", -- [13]
			"61745:61474:61759:62658:60231:65189", -- [14]
			"61745:61474:61759:62658:60231:59046:60441", -- [15]
			"61745:61474", -- [16]
			"61504:60416", -- [17]
			"61745:61473", -- [18]
			"61504:60416:61512", -- [19]
			"61745:61474:61759", -- [20]
			"61745:61474:61759:62658", -- [21]
			"61504:60416:61512:62901", -- [22]
			"61745:61473:62903", -- [23]
			"61504:60416:61512:62901:62898", -- [24]
			"61504:60416:61512:62901:62898:62909", -- [25]
			"61745:61122", -- [26]
			"61745:61473:62903:63500:63501", -- [27]
			"61745:61473:62903:63500:63501:63498", -- [28]
			"61745:61473:62903:63500", -- [29]
			"61745:61122:63497", -- [30]
			"61745:61474:61759:60230:59186:64310", -- [31]
			"61745:61473:62903:63500:63501:65511", -- [32]
			"61504:60416:61512:62901:65863", -- [33]
			"61745:61474:61759:60230:59186:71939", -- [34]
			--["name"] = "Zouchin Village, Kun-Lai Summit",
			["m"] = 379,
			["direct"] = "61118:61745:61504",
			["f"] = 0,
			["coord"] = 2681031944,
		},
		[62901] = {
			"61473:61745:61474:61759:60230:60952", -- [1]
			"61473:61745:61474:61759:60230:59186", -- [2]
			"61473:61745:61474:61759:60230:59186:59732", -- [3]
			"61473:61745:61474:66227:59736:59735:59733", -- [4]
			"61473:61745:61474:66227:59736:59735", -- [5]
			"61473:61745:61474:66227:59736", -- [6]
			"61473:61745:61474:66227", -- [7]
			"61473:61745:61474:61759:60230", -- [8]
			"65863:61122:60231", -- [9]
			"61473:61745:61474:60232", -- [10]
			"65863:61122:60231:59046", -- [11]
			"62903:63500:63501:58843", -- [12]
			"62903:63500:63501:58843:59047", -- [13]
			"62903:63500:63501:58843:65189", -- [14]
			"62903:63500:63501:58843:59047:60441", -- [15]
			"61473:61745:61474", -- [16]
			"61512:60416:61504:61118", -- [17]
			"61473:61745", -- [18]
			"61512:60416:61504:61118:61511", -- [19]
			"61512:60416:61504", -- [20]
			"61512:60416", -- [21]
			"61473:61745:61474:61759", -- [22]
			"61473:61745:61474:61759:62658", -- [23]
			"62898:62909", -- [24]
			"65863:61122", -- [25]
			"62903:63500:63501", -- [26]
			"62903:63500:63501:63498", -- [27]
			"62903:63500", -- [28]
			"62903:63500:63497", -- [29]
			"61473:61745:61474:61759:60230:59186:64310", -- [30]
			"62903:63500:63501:65511", -- [31]
			"61473:61745:61474:61759:60230:59186:71939", -- [32]
			--["name"] = "Longying Outpost, Townlong Steppes",
			["direct"] = "61473:61512:62903:62898:65863",
			["m"] = 388,
			["coord"] = 3054473921,
			["f"] = 0,
		},
		[59186] = {
			"59735:59733", -- [1]
			"60230:60231", -- [2]
			"60230:60232", -- [3]
			"60230:59046", -- [4]
			"60230:60231:58843", -- [5]
			"60230:59046:59047", -- [6]
			"60230:60231:65189", -- [7]
			"60230:59046:60441", -- [8]
			"60230:61759:61474", -- [9]
			"60230:61759:61474:61118", -- [10]
			"60230:61759:61474:61745", -- [11]
			"60230:61759:61474:61118:61511", -- [12]
			"60230:61759:61474:61504", -- [13]
			"60230:61759:61474:61745:60416", -- [14]
			"60230:61759:61474:61745:61473", -- [15]
			"60230:61759:61474:61745:60416:61512", -- [16]
			"60230:61759", -- [17]
			"60230:62658", -- [18]
			"61122:65863:62901", -- [19]
			"60230:61759:61474:61745:61473:62903", -- [20]
			"60230:61759:61474:61745:61473:62903:62898", -- [21]
			"60230:61759:61474:61745:61473:62903:62898:62909", -- [22]
			"60230:60231:58843:63501", -- [23]
			"60230:60231:58843:63501:63498", -- [24]
			"61122:63500", -- [25]
			"61122:63497", -- [26]
			"60230:60231:58843:63501:65511", -- [27]
			"61122:65863", -- [28]
			--["name"] = "Dawn's Blossom, Jade Forest",
			["direct"] = "60952:59732:59735:59736:66227:60230:61122:64310:71939",
			["m"] = 371,
			["coord"] = 2019849771,
			["f"] = 0,
		},
		[60952] = {
			"59186:59732", -- [1]
			"59736:59735:59733", -- [2]
			"59736:59735", -- [3]
			"60230:60231", -- [4]
			"60230:60232", -- [5]
			"60230:59046", -- [6]
			"60230:60231:58843", -- [7]
			"60230:59046:59047", -- [8]
			"60230:60231:65189", -- [9]
			"60230:59046:60441", -- [10]
			"60230:61759:61474", -- [11]
			"60230:61759:61474:61118", -- [12]
			"60230:61759:61474:61745", -- [13]
			"60230:61759:61474:61118:61511", -- [14]
			"60230:61759:61474:61504", -- [15]
			"60230:61759:61474:61745:60416", -- [16]
			"60230:61759:61474:61745:61473", -- [17]
			"60230:61759:61474:61745:60416:61512", -- [18]
			"60230:61759", -- [19]
			"60230:62658", -- [20]
			"60230:62658:61122:65863:62901", -- [21]
			"60230:61759:61474:61745:61473:62903", -- [22]
			"60230:61759:61474:61745:61473:62903:62898", -- [23]
			"60230:61759:61474:61745:61473:62903:62898:62909", -- [24]
			"60230:62658:61122", -- [25]
			"60230:60231:58843:63501", -- [26]
			"60230:60231:58843:63501:63498", -- [27]
			"60230:62658:61122:63500", -- [28]
			"60230:62658:61122:63497", -- [29]
			"60230:60231:58843:63501:65511", -- [30]
			"60230:62658:61122:65863", -- [31]
			"59186:71939", -- [32]
			--["name"] = "Grookin Hill, Jade Forest",
			["direct"] = "59186:59736:66227:60230:64310",
			["f"] = 0,
			["m"] = 371,
			["coord"] = 1193048794,
		},
		[62909] = {
			"62898:62903:61473:61745:61474:61759:60230:60952", -- [1]
			"62898:62903:61473:61745:61474:61759:60230:59186", -- [2]
			"62898:62903:61473:61745:61474:61759:60230:59186:59732", -- [3]
			"62898:62903:61473:61745:61474:66227:59736:59735:59733", -- [4]
			"62898:62903:61473:61745:61474:66227:59736:59735", -- [5]
			"62898:62903:61473:61745:61474:66227:59736", -- [6]
			"62898:62903:61473:61745:61474:66227", -- [7]
			"62898:62903:61473:61745:61474:61759:60230", -- [8]
			"62898:62903:63500:63501:58843:60231", -- [9]
			"62898:62903:63500:63501:58843:60231:60232", -- [10]
			"62898:62903:63500:63501:58843:60231:59046", -- [11]
			"62898:62903:63500:63501:58843", -- [12]
			"62898:62903:63500:63501:58843:59047", -- [13]
			"62898:62903:63500:63501:58843:65189", -- [14]
			"62898:62903:63500:63501:58843:59047:60441", -- [15]
			"62898:62903:61473:61745:61474", -- [16]
			"62898:62901:61512:60416:61504:61118", -- [17]
			"62898:62903:61473:61745", -- [18]
			"62898:62901:61512:60416:61504:61118:61511", -- [19]
			"62898:62901:61512:60416:61504", -- [20]
			"62898:62901:61512:60416", -- [21]
			"62898:62903:61473", -- [22]
			"62898:62901:61512", -- [23]
			"62898:62903:61473:61745:61474:61759", -- [24]
			"62898:62903:61473:61745:61474:61759:62658", -- [25]
			"62898:62901", -- [26]
			"62898:62903", -- [27]
			"62898:62903:65863:61122", -- [28]
			"62898:62903:63500:63501", -- [29]
			"62898:62903:63500:63501:63498", -- [30]
			"62898:62903:63500", -- [31]
			"62898:62903:63500:63497", -- [32]
			"62898:62903:61473:61745:61474:61759:60230:59186:64310", -- [33]
			"62898:62903:63500:63501:65511", -- [34]
			"62898:62903:65863", -- [35]
			"62898:62903:61473:61745:61474:61759:60230:59186:71939", -- [36]
			--["name"] = "Shado-Pan Garrison, Townlong Steppes",
			["m"] = 388,
			["f"] = 0,
			["direct"] = "62898",
			["coord"] = 2149824560,
		},
		[65189] = {
			"60231:60230:60952", -- [1]
			"60231:60230:59186", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60230:59186:59735:59733", -- [4]
			"60231:60230:59186:59735", -- [5]
			"60231:60230:60952:59736", -- [6]
			"60231:62658:61759:61474:66227", -- [7]
			"60231:60230", -- [8]
			"59047:59046:60232", -- [9]
			"59047:59046", -- [10]
			"60231:62658:61759:61474", -- [11]
			"60231:62658:61759:61474:61118", -- [12]
			"60231:62658:61759:61474:61745", -- [13]
			"60231:62658:61759:61474:61118:61511", -- [14]
			"60231:62658:61759:61474:61504", -- [15]
			"59047:63501:63500:62903:61473:60416", -- [16]
			"59047:63501:63500:62903:61473", -- [17]
			"59047:63501:63497:61512", -- [18]
			"60231:62658:61759", -- [19]
			"60231:62658", -- [20]
			"59047:63501:63500:62903:62901", -- [21]
			"59047:63501:63500:62903", -- [22]
			"59047:63501:63500:62903:62898", -- [23]
			"59047:63501:63500:62903:62898:62909", -- [24]
			"60231:61122", -- [25]
			"59047:63501", -- [26]
			"59047:63501:63498", -- [27]
			"59047:63501:63500", -- [28]
			"59047:63501:63497", -- [29]
			"60231:60230:59186:64310", -- [30]
			"59047:63501:65511", -- [31]
			"59047:63501:63500:62903:65863", -- [32]
			"60231:60230:59186:71939", -- [33]
			--["name"] = "Cradle of Chi-Ji, Krasarang Wilds",
			["m"] = 418,
			["f"] = 0,
			["direct"] = "60231:58843:59047:60441",
			["coord"] = 1341694345,
		},
		[61474] = {
			"61759:60230:60952", -- [1]
			"61759:60230:59186", -- [2]
			"61759:60230:59186:59732", -- [3]
			"66227:59736:59735:59733", -- [4]
			"66227:59736:59735", -- [5]
			"66227:59736", -- [6]
			"61759:60230", -- [7]
			"61759:62658:60231", -- [8]
			"61759:62658:60231:59046", -- [9]
			"61759:62658:60231:58843", -- [10]
			"61759:62658:60231:58843:59047", -- [11]
			"61759:62658:60231:65189", -- [12]
			"61759:62658:60231:59046:60441", -- [13]
			"61118:61511", -- [14]
			"61745:60416", -- [15]
			"61745:61473", -- [16]
			"61745:60416:61512", -- [17]
			"61759:62658", -- [18]
			"61745:61473:62901", -- [19]
			"61745:61473:62903", -- [20]
			"61745:61473:62903:62898", -- [21]
			"61745:61473:62903:62898:62909", -- [22]
			"61745:61473:62903:63500:63501", -- [23]
			"61122:63497:63498", -- [24]
			"61745:61473:62903:63500", -- [25]
			"61122:63497", -- [26]
			"61759:60230:59186:64310", -- [27]
			"61745:61473:62903:63500:63501:65511", -- [28]
			"61745:61473:62903:65863", -- [29]
			"61759:60230:59186:71939", -- [30]
			--["name"] = "Binan Village, Kun-Lai Summit",
			["direct"] = "66227:60232:61118:61745:61504:61759:61122",
			["f"] = 0,
			["m"] = 379,
			["coord"] = 3113808134,
		},
		[61512] = {
			"60416:61745:61474:61759:60230:60952", -- [1]
			"60416:61745:61474:61759:60230:59186", -- [2]
			"60416:61745:61474:61759:60230:59186:59732", -- [3]
			"60416:61745:61474:66227:59736:59735:59733", -- [4]
			"60416:61745:61474:66227:59736:59735", -- [5]
			"60416:61745:61474:66227:59736", -- [6]
			"60416:61745:61474:66227", -- [7]
			"60416:61745:61474:61759:60230", -- [8]
			"60416:61745:61474:61759:62658:60231", -- [9]
			"60416:61745:61474:60232", -- [10]
			"60416:61745:61474:61759:62658:60231:59046", -- [11]
			"62901:62903:63500:63501:58843", -- [12]
			"62901:62903:63500:63501:58843:59047", -- [13]
			"62901:62903:63500:63501:58843:65189", -- [14]
			"62901:62903:63500:63501:58843:59047:60441", -- [15]
			"60416:61745:61474", -- [16]
			"60416:61504:61118", -- [17]
			"60416:61745", -- [18]
			"60416:61504:61118:61511", -- [19]
			"60416:61504", -- [20]
			"60416:61473", -- [21]
			"60416:61745:61474:61759", -- [22]
			"60416:61745:61474:61759:62658", -- [23]
			"62901:62903", -- [24]
			"62901:62898", -- [25]
			"62901:62898:62909", -- [26]
			"62901:65863:61122", -- [27]
			"62901:62903:63500:63501", -- [28]
			"63497:63498", -- [29]
			"62901:62903:63500", -- [30]
			"60416:61745:61474:61759:60230:59186:64310", -- [31]
			"62901:62903:63500:63501:65511", -- [32]
			"62901:65863", -- [33]
			"60416:61745:61474:61759:60230:59186:71939", -- [34]
			--["name"] = "Winter's Blossom, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "60416:62901:63497",
			["coord"] = 1483577174,
		},
		[63498] = {
			"63501:58843:60231:60230:60952", -- [1]
			"63501:58843:60231:60230:59186", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60230:59186:59735:59733", -- [4]
			"63501:58843:60231:60230:59186:59735", -- [5]
			"63501:58843:60231:60230:60952:59736", -- [6]
			"63497:61122:66227", -- [7]
			"63501:58843:60231:60230", -- [8]
			"63501:58843:60231", -- [9]
			"63501:58843:60231:60232", -- [10]
			"63501:58843:60231:59046", -- [11]
			"63501:58843", -- [12]
			"63501:58843:59047", -- [13]
			"63501:58843:65189", -- [14]
			"63501:58843:59047:60441", -- [15]
			"63497:61122:61474", -- [16]
			"63501:63500:62903:61473:60416:61504:61118", -- [17]
			"63501:63500:62903:61473:61745", -- [18]
			"63501:63500:62903:61473:60416:61504:61118:61511", -- [19]
			"63501:63500:62903:61473:60416:61504", -- [20]
			"63501:63500:62903:61473:60416", -- [21]
			"63501:63500:62903:61473", -- [22]
			"63497:61512", -- [23]
			"63501:58843:60231:62658:61759", -- [24]
			"63501:58843:60231:62658", -- [25]
			"63501:63500:62903:62901", -- [26]
			"63501:63500:62903", -- [27]
			"63501:63500:62903:62898", -- [28]
			"63501:63500:62903:62898:62909", -- [29]
			"63497:61122", -- [30]
			"63501:63500", -- [31]
			"63501:58843:60231:60230:59186:64310", -- [32]
			"63501:63500:62903:65863", -- [33]
			"63501:58843:60231:60230:59186:71939", -- [34]
			--["name"] = "Soggy's Gamble, Dread Wastes",
			["m"] = 422,
			["f"] = 0,
			["direct"] = "63501:63497:65511",
			["coord"] = 2410197898,
		},
		[63500] = {
			"63501:58843:60231:60230:60952", -- [1]
			"63501:58843:60231:60230:59186", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"62903:61473:61745:61474:66227:59736:59735:59733", -- [4]
			"62903:61473:61745:61474:66227:59736:59735", -- [5]
			"62903:61473:61745:61474:66227:59736", -- [6]
			"62903:61473:61745:61474:66227", -- [7]
			"63501:58843:60231:60230", -- [8]
			"63501:58843:60231", -- [9]
			"63501:58843:60231:60232", -- [10]
			"63501:58843:60231:59046", -- [11]
			"63501:58843", -- [12]
			"63501:58843:59047", -- [13]
			"63501:58843:65189", -- [14]
			"63501:58843:59047:60441", -- [15]
			"62903:61473:61745:61474", -- [16]
			"62903:61473:60416:61504:61118", -- [17]
			"62903:61473:61745", -- [18]
			"62903:61473:60416:61504:61118:61511", -- [19]
			"62903:61473:60416:61504", -- [20]
			"62903:61473:60416", -- [21]
			"62903:61473", -- [22]
			"62903:62901:61512", -- [23]
			"63501:58843:60231:62658:61759", -- [24]
			"63501:58843:60231:62658", -- [25]
			"62903:62901", -- [26]
			"62903:62898", -- [27]
			"62903:62898:62909", -- [28]
			"63501:63498", -- [29]
			"63501:58843:60231:60230:59186:64310", -- [30]
			"63501:65511", -- [31]
			"62903:65863", -- [32]
			"63501:58843:60231:60230:59186:71939", -- [33]
			--["name"] = "The Sunset Brewgarden, Dread Wastes",
			["m"] = 422,
			["f"] = 0,
			["direct"] = "62903:61122:63501:63497",
			["coord"] = 2156797729,
		},
		[62898] = {
			"62903:61473:61745:61474:61759:60230:60952", -- [1]
			"62903:61473:61745:61474:61759:60230:59186", -- [2]
			"62903:61473:61745:61474:61759:60230:59186:59732", -- [3]
			"62903:61473:61745:61474:66227:59736:59735:59733", -- [4]
			"62903:61473:61745:61474:66227:59736:59735", -- [5]
			"62903:61473:61745:61474:66227:59736", -- [6]
			"62903:61473:61745:61474:66227", -- [7]
			"62903:61473:61745:61474:61759:60230", -- [8]
			"62903:63500:63501:58843:60231", -- [9]
			"62903:63500:63501:58843:60231:60232", -- [10]
			"62903:63500:63501:58843:60231:59046", -- [11]
			"62903:63500:63501:58843", -- [12]
			"62903:63500:63501:58843:59047", -- [13]
			"62903:63500:63501:58843:65189", -- [14]
			"62903:63500:63501:58843:59047:60441", -- [15]
			"62903:61473:61745:61474", -- [16]
			"62901:61512:60416:61504:61118", -- [17]
			"62903:61473:61745", -- [18]
			"62901:61512:60416:61504:61118:61511", -- [19]
			"62901:61512:60416:61504", -- [20]
			"62901:61512:60416", -- [21]
			"62903:61473", -- [22]
			"62901:61512", -- [23]
			"62903:61473:61745:61474:61759", -- [24]
			"62903:61473:61745:61474:61759:62658", -- [25]
			"62903:65863:61122", -- [26]
			"62903:63500:63501", -- [27]
			"62903:63500:63501:63498", -- [28]
			"62903:63500", -- [29]
			"62903:63500:63497", -- [30]
			"62903:61473:61745:61474:61759:60230:59186:64310", -- [31]
			"62903:63500:63501:65511", -- [32]
			"62903:65863", -- [33]
			"62903:61473:61745:61474:61759:60230:59186:71939", -- [34]
			--["name"] = "Rensai's Watchpost, Townlong Steppes",
			["m"] = 388,
			["f"] = 0,
			["direct"] = "62901:62903:62909",
			["coord"] = 2329659992,
		},
		[61504] = {
			"61474:61759:60230:60952", -- [1]
			"61474:61759:60230:59186", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:66227:59736:59735:59733", -- [4]
			"61474:66227:59736:59735", -- [5]
			"61474:66227:59736", -- [6]
			"61474:66227", -- [7]
			"61474:61759:60230", -- [8]
			"61474:61759:62658:60231", -- [9]
			"61474:60232", -- [10]
			"61474:61759:62658:60231:59046", -- [11]
			"61474:61759:62658:60231:58843", -- [12]
			"61474:61759:62658:60231:58843:59047", -- [13]
			"61474:61759:62658:60231:65189", -- [14]
			"61474:61759:62658:60231:59046:60441", -- [15]
			"60416:61473", -- [16]
			"60416:61512", -- [17]
			"61474:61759", -- [18]
			"61474:61759:62658", -- [19]
			"60416:61512:62901", -- [20]
			"60416:61473:62903", -- [21]
			"60416:61512:62901:62898", -- [22]
			"60416:61512:62901:62898:62909", -- [23]
			"61745:61122", -- [24]
			"60416:61473:62903:63500:63501", -- [25]
			"60416:61473:62903:63500:63501:63498", -- [26]
			"60416:61473:62903:63500", -- [27]
			"61745:61122:63497", -- [28]
			"61474:61759:60230:59186:64310", -- [29]
			"60416:61473:62903:63500:63501:65511", -- [30]
			"60416:61512:62901:65863", -- [31]
			"61474:61759:60230:59186:71939", -- [32]
			--["name"] = "One Keg, Kun-Lai Summit",
			["direct"] = "61474:61118:61745:61511:60416",
			["f"] = 0,
			["m"] = 379,
			["coord"] = 2481101060,
		},
		[60230] = {
			"59186:59732", -- [1]
			"59186:59735:59733", -- [2]
			"59186:59735", -- [3]
			"60952:59736", -- [4]
			"60952:66227", -- [5]
			"60231:58843", -- [6]
			"59046:59047", -- [7]
			"60231:65189", -- [8]
			"59046:60441", -- [9]
			"61759:61474", -- [10]
			"61759:61474:61118", -- [11]
			"61759:61474:61745", -- [12]
			"61759:61474:61118:61511", -- [13]
			"61759:61474:61504", -- [14]
			"61759:61474:61745:60416", -- [15]
			"61759:61474:61745:61473", -- [16]
			"61759:61474:61745:60416:61512", -- [17]
			"62658:61122:65863:62901", -- [18]
			"61759:61474:61745:61473:62903", -- [19]
			"61759:61474:61745:61473:62903:62898", -- [20]
			"61759:61474:61745:61473:62903:62898:62909", -- [21]
			"60231:58843:63501", -- [22]
			"60231:58843:63501:63498", -- [23]
			"62658:61122:63500", -- [24]
			"62658:61122:63497", -- [25]
			"59186:64310", -- [26]
			"60231:58843:63501:65511", -- [27]
			"62658:61122:65863", -- [28]
			"59186:71939", -- [29]
			--["name"] = "Pang's Stead, Valley of the Four Winds",
			["direct"] = "60952:59186:60231:60232:59046:61759:62658:61122",
			["f"] = 0,
			["m"] = 376,
			["coord"] = 3629594111,
		},
		[60232] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:60952:59736", -- [6]
			"60230:60952:66227", -- [7]
			"60231:58843", -- [8]
			"59046:59047", -- [9]
			"60231:65189", -- [10]
			"59046:60441", -- [11]
			"61474:61118", -- [12]
			"61474:61745", -- [13]
			"61474:61118:61511", -- [14]
			"61474:61504", -- [15]
			"61474:61745:60416", -- [16]
			"61474:61745:61473", -- [17]
			"61474:61745:60416:61512", -- [18]
			"60230:61759", -- [19]
			"60230:62658", -- [20]
			"60231:61122:65863:62901", -- [21]
			"61474:61745:61473:62903", -- [22]
			"61474:61745:61473:62903:62898", -- [23]
			"61474:61745:61473:62903:62898:62909", -- [24]
			"60231:61122", -- [25]
			"60231:58843:63501", -- [26]
			"60231:58843:63501:63498", -- [27]
			"60231:58843:63501:63500", -- [28]
			"60231:58843:63501:63497", -- [29]
			"60230:59186:64310", -- [30]
			"60231:58843:63501:65511", -- [31]
			"60231:61122:65863", -- [32]
			"60230:59186:71939", -- [33]
			--["name"] = "Zhu's Watch, Krasarang Wilds",
			["m"] = 418,
			["f"] = 0,
			["direct"] = "60230:60231:59046:61474",
			["coord"] = 3294762427,
		},
		[62903] = {
			"61473:61745:61474:61759:60230:60952", -- [1]
			"61473:61745:61474:61759:60230:59186", -- [2]
			"61473:61745:61474:61759:60230:59186:59732", -- [3]
			"61473:61745:61474:66227:59736:59735:59733", -- [4]
			"61473:61745:61474:66227:59736:59735", -- [5]
			"61473:61745:61474:66227:59736", -- [6]
			"61473:61745:61474:66227", -- [7]
			"61473:61745:61474:61759:60230", -- [8]
			"63500:63501:58843:60231", -- [9]
			"63500:63501:58843:60231:60232", -- [10]
			"63500:63501:58843:60231:59046", -- [11]
			"63500:63501:58843", -- [12]
			"63500:63501:58843:59047", -- [13]
			"63500:63501:58843:65189", -- [14]
			"63500:63501:58843:59047:60441", -- [15]
			"61473:61745:61474", -- [16]
			"61473:60416:61504:61118", -- [17]
			"61473:61745", -- [18]
			"61473:60416:61504:61118:61511", -- [19]
			"61473:60416:61504", -- [20]
			"61473:60416", -- [21]
			"62901:61512", -- [22]
			"61473:61745:61474:61759", -- [23]
			"61473:61745:61474:61759:62658", -- [24]
			"62898:62909", -- [25]
			"65863:61122", -- [26]
			"63500:63501", -- [27]
			"63500:63501:63498", -- [28]
			"63500:63497", -- [29]
			"61473:61745:61474:61759:60230:59186:64310", -- [30]
			"63500:63501:65511", -- [31]
			"61473:61745:61474:61759:60230:59186:71939", -- [32]
			--["name"] = "Gao-Ran Battlefront, Townlong Steppes",
			["direct"] = "61473:62901:62898:63500:65863",
			["f"] = 0,
			["m"] = 388,
			["coord"] = 3196440686,
		},
		[61118] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:66227:59736:59735:59733", -- [4]
			"61745:61474:66227:59736:59735", -- [5]
			"61745:61474:66227:59736", -- [6]
			"61745:61474:66227", -- [7]
			"61745:61474:61759:60230", -- [8]
			"61745:61474:61759:62658:60231", -- [9]
			"61745:61474:60232", -- [10]
			"61745:61474:61759:62658:60231:59046", -- [11]
			"61745:61474:61759:62658:60231:58843", -- [12]
			"61745:61474:61759:62658:60231:58843:59047", -- [13]
			"61745:61474:61759:62658:60231:65189", -- [14]
			"61745:61474:61759:62658:60231:59046:60441", -- [15]
			"61504:60416", -- [16]
			"61745:61473", -- [17]
			"61504:60416:61512", -- [18]
			"61745:61474:61759", -- [19]
			"61745:61474:61759:62658", -- [20]
			"61504:60416:61512:62901", -- [21]
			"61745:61473:62903", -- [22]
			"61745:61473:62903:62898", -- [23]
			"61745:61473:62903:62898:62909", -- [24]
			"61745:61122", -- [25]
			"61745:61473:62903:63500:63501", -- [26]
			"61745:61473:62903:63500:63501:63498", -- [27]
			"61745:61473:62903:63500", -- [28]
			"61745:61122:63497", -- [29]
			"61745:61474:61759:60230:59186:64310", -- [30]
			"61745:61473:62903:63500:63501:65511", -- [31]
			"61504:60416:61512:62901:65863", -- [32]
			"61745:61474:61759:60230:59186:71939", -- [33]
			--["name"] = "Temple of the White Tiger, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "61474:61745:61511:61504",
			["coord"] = 2847310268,
		},
		[59736] = {
			"59186:59732", -- [1]
			"59735:59733", -- [2]
			"60952:60230", -- [3]
			"60952:60230:60231", -- [4]
			"60952:60230:60232", -- [5]
			"60952:60230:59046", -- [6]
			"60952:60230:60231:58843", -- [7]
			"60952:60230:59046:59047", -- [8]
			"60952:60230:60231:65189", -- [9]
			"60952:60230:59046:60441", -- [10]
			"66227:61474", -- [11]
			"66227:61474:61118", -- [12]
			"66227:61474:61745", -- [13]
			"66227:61474:61118:61511", -- [14]
			"66227:61474:61504", -- [15]
			"66227:61474:61745:60416", -- [16]
			"66227:61474:61745:61473", -- [17]
			"66227:61474:61745:60416:61512", -- [18]
			"60952:60230:61759", -- [19]
			"60952:60230:62658", -- [20]
			"66227:61474:61745:61473:62901", -- [21]
			"66227:61474:61745:61473:62903", -- [22]
			"66227:61474:61745:61473:62903:62898", -- [23]
			"66227:61474:61745:61473:62903:62898:62909", -- [24]
			"66227:61122", -- [25]
			"60952:60230:60231:58843:63501", -- [26]
			"60952:60230:60231:58843:63501:63498", -- [27]
			"66227:61474:61745:61473:62903:63500", -- [28]
			"66227:61122:63497", -- [29]
			"59186:64310", -- [30]
			"60952:60230:60231:58843:63501:65511", -- [31]
			"66227:61474:61745:61473:62903:65863", -- [32]
			"59186:71939", -- [33]
			--["name"] = "Tian Monastery, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "60952:59186:59735:66227",
			["coord"] = 1871527691,
		},
		[61122] = {
			"60230:60952", -- [1]
			"60230:59186:59732", -- [2]
			"66227:59736:59735:59733", -- [3]
			"66227:59736:59735", -- [4]
			"66227:59736", -- [5]
			"60231:60232", -- [6]
			"60231:59046", -- [7]
			"60231:58843", -- [8]
			"60231:58843:59047", -- [9]
			"60231:65189", -- [10]
			"60231:59046:60441", -- [11]
			"61745:61118", -- [12]
			"61745:61511", -- [13]
			"61745:61504", -- [14]
			"61745:60416", -- [15]
			"61745:61473", -- [16]
			"65863:62901:61512", -- [17]
			"62658:61759", -- [18]
			"65863:62901", -- [19]
			"65863:62903", -- [20]
			"65863:62901:62898", -- [21]
			"65863:62901:62898:62909", -- [22]
			"63497:63498", -- [23]
			"60230:59186:64310", -- [24]
			"63501:65511", -- [25]
			"60230:59186:71939", -- [26]
			--["name"] = "Shrine of Two Moons, Vale of Eternal Blossoms",
			["direct"] = "59186:66227:60230:60231:61474:61745:62658:63501:63500:63497:65863",
			["f"] = 0,
			["m"] = 390,
			["coord"] = 2690660296,
		},
		[59732] = {
			"59186:60952", -- [1]
			"59186:59735", -- [2]
			"59186:59736", -- [3]
			"59186:66227", -- [4]
			"59186:60230", -- [5]
			"59186:60230:60231", -- [6]
			"59186:60230:60232", -- [7]
			"59186:60230:59046", -- [8]
			"59186:60230:60231:58843", -- [9]
			"59186:60230:59046:59047", -- [10]
			"59186:60230:60231:65189", -- [11]
			"59186:60230:59046:60441", -- [12]
			"59186:60230:61759:61474", -- [13]
			"59186:60230:61759:61474:61118", -- [14]
			"59186:60230:61759:61474:61745", -- [15]
			"59186:60230:61759:61474:61118:61511", -- [16]
			"59186:60230:61759:61474:61504", -- [17]
			"59186:60230:61759:61474:61745:60416", -- [18]
			"59186:60230:61759:61474:61745:61473", -- [19]
			"59186:60230:61759:61474:61745:60416:61512", -- [20]
			"59186:60230:61759", -- [21]
			"59186:60230:62658", -- [22]
			"59186:61122:65863:62901", -- [23]
			"59186:60230:61759:61474:61745:61473:62903", -- [24]
			"59186:60230:61759:61474:61745:61473:62903:62898", -- [25]
			"59186:60230:61759:61474:61745:61473:62903:62898:62909", -- [26]
			"59186:61122", -- [27]
			"59186:60230:60231:58843:63501", -- [28]
			"59186:60230:60231:58843:63501:63498", -- [29]
			"59186:61122:63500", -- [30]
			"59186:61122:63497", -- [31]
			"59186:64310", -- [32]
			"59186:60230:60231:58843:63501:65511", -- [33]
			"59186:61122:65863", -- [34]
			"59186:71939", -- [35]
			--["name"] = "The Arboretum, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59186:59733",
			["coord"] = 2449305813,
		},
		[59047] = {
			"59046:60230:60952", -- [1]
			"59046:60230:59186", -- [2]
			"59046:60230:59186:59732", -- [3]
			"59046:60230:59186:59735:59733", -- [4]
			"59046:60230:59186:59735", -- [5]
			"59046:60230:60952:59736", -- [6]
			"59046:60230:60952:66227", -- [7]
			"59046:60230", -- [8]
			"59046:60231", -- [9]
			"59046:60232", -- [10]
			"59046:60231:62658:61759:61474", -- [11]
			"59046:60231:62658:61759:61474:61118", -- [12]
			"59046:60231:62658:61759:61474:61745", -- [13]
			"59046:60231:62658:61759:61474:61118:61511", -- [14]
			"59046:60231:62658:61759:61474:61504", -- [15]
			"63501:63500:62903:61473:60416", -- [16]
			"63501:63500:62903:61473", -- [17]
			"63501:63497:61512", -- [18]
			"59046:60231:62658:61759", -- [19]
			"59046:60231:62658", -- [20]
			"63501:63500:62903:62901", -- [21]
			"63501:63500:62903", -- [22]
			"63501:63500:62903:62898", -- [23]
			"63501:63500:62903:62898:62909", -- [24]
			"59046:60231:61122", -- [25]
			"63501:63498", -- [26]
			"63501:63500", -- [27]
			"63501:63497", -- [28]
			"59046:60230:59186:64310", -- [29]
			"63501:65511", -- [30]
			"63501:63500:62903:65863", -- [31]
			"59046:60230:59186:71939", -- [32]
			--["name"] = "Dawnchaser Retreat, Krasarang Wilds",
			["direct"] = "59046:58843:65189:60441:63501",
			["f"] = 0,
			["m"] = 418,
			["coord"] = 1243906316,
		},
		[71939] = {
			"59186:60952", -- [1]
			"59186:59732", -- [2]
			"59186:59735:59733", -- [3]
			"59186:59735", -- [4]
			"59186:59736", -- [5]
			"59186:66227", -- [6]
			"59186:60230", -- [7]
			"59186:60230:60231", -- [8]
			"59186:60230:60232", -- [9]
			"59186:60230:59046", -- [10]
			"59186:60230:60231:58843", -- [11]
			"59186:60230:59046:59047", -- [12]
			"59186:60230:60231:65189", -- [13]
			"59186:60230:59046:60441", -- [14]
			"59186:60230:61759:61474", -- [15]
			"59186:60230:61759:61474:61118", -- [16]
			"59186:60230:61759:61474:61745", -- [17]
			"59186:60230:61759:61474:61118:61511", -- [18]
			"59186:60230:61759:61474:61504", -- [19]
			"59186:60230:61759:61474:61745:60416", -- [20]
			"59186:60230:61759:61474:61745:61473", -- [21]
			"59186:60230:61759:61474:61745:60416:61512", -- [22]
			"59186:60230:61759", -- [23]
			"59186:60230:62658", -- [24]
			"59186:61122:65863:62901", -- [25]
			"59186:60230:61759:61474:61745:61473:62903", -- [26]
			"59186:60230:61759:61474:61745:61473:62903:62898", -- [27]
			"59186:60230:61759:61474:61745:61473:62903:62898:62909", -- [28]
			"59186:61122", -- [29]
			"59186:60230:60231:58843:63501", -- [30]
			"59186:60230:60231:58843:63501:63498", -- [31]
			"59186:61122:63500", -- [32]
			"59186:61122:63497", -- [33]
			"59186:64310", -- [34]
			"59186:60230:60231:58843:63501:65511", -- [35]
			"59186:61122:65863", -- [36]
			--["name"] = "Huojin Landing, Timeless Isle",
			["m"] = 554,
			["f"] = 0,
			["direct"] = "59186",
			["coord"] = 940008994,
		},
		[66227] = {
			"59186:59732", -- [1]
			"59736:59735:59733", -- [2]
			"59736:59735", -- [3]
			"60952:60230", -- [4]
			"61474:61759:62658:60231", -- [5]
			"60952:60230:60232", -- [6]
			"60952:60230:59046", -- [7]
			"61474:61759:62658:60231:58843", -- [8]
			"61474:61759:62658:60231:58843:59047", -- [9]
			"61474:61759:62658:60231:65189", -- [10]
			"60952:60230:59046:60441", -- [11]
			"61474:61118", -- [12]
			"61474:61745", -- [13]
			"61474:61118:61511", -- [14]
			"61474:61504", -- [15]
			"61474:61745:60416", -- [16]
			"61474:61745:61473", -- [17]
			"61474:61745:60416:61512", -- [18]
			"61474:61759", -- [19]
			"61474:61759:62658", -- [20]
			"61474:61745:61473:62901", -- [21]
			"61474:61745:61473:62903", -- [22]
			"61474:61745:61473:62903:62898", -- [23]
			"61474:61745:61473:62903:62898:62909", -- [24]
			"61122:63501", -- [25]
			"61122:63497:63498", -- [26]
			"61474:61745:61473:62903:63500", -- [27]
			"61122:63497", -- [28]
			"59186:64310", -- [29]
			"61122:63501:65511", -- [30]
			"61474:61745:61473:62903:65863", -- [31]
			"59186:71939", -- [32]
			--["name"] = "Honeydew Village, Jade Forest",
			["direct"] = "60952:59186:59736:61474:61122",
			["f"] = 0,
			["m"] = 371,
			["coord"] = 1207707634,
		},
	},
	[7] = {
		[84700] = {
			"84714:92808:90562:76850", -- [1]
			"85829:76787:76781:76782", -- [2]
			"85829:76787:76781", -- [3]
			"85829:76787:76783", -- [4]
			"85829:76787", -- [5]
			"85829:76787:78699:76879", -- [6]
			"85829:76784", -- [7]
			"85829:76787:78699", -- [8]
			"85829:86049", -- [9]
			"85829:76784:79407", -- [10]
			"85829:81055:84508:90552:80932", -- [11]
			"85829:81055:84508:81053", -- [12]
			"85829:76784:81057", -- [13]
			"85829:76784:81064:81058", -- [14]
			"85829:76784:81064", -- [15]
			"85829:76784:81064:81068", -- [16]
			"85829:76784:81064:81078", -- [17]
			"85829:76784:81057:81354", -- [18]
			"84714:92808:90562:76850:81285", -- [19]
			"85829:76784:81057:82612", -- [20]
			"85829:76784:79407:82346:83924", -- [21]
			"85829:76784:79407:82844", -- [22]
			"85829:76784:79407:82346", -- [23]
			"85829:76784:79407:82844:82340", -- [24]
			"85829:76784:81057:81354:84515:84498", -- [25]
			"85829:76784:81057:81354:84515:84504", -- [26]
			"85829:76784:81057:81354:84515:82511", -- [27]
			"85829:81055:84508", -- [28]
			"85829:76784:81064:81078:84509", -- [29]
			"85829:84495", -- [30]
			"85829:76784:81057:81354:84515", -- [31]
			"84714:92808:90562:76850:83427", -- [32]
			"85829:76784:87707", -- [33]
			"85829:76784:81057:81354:88584", -- [34]
			"85829:76787:87395", -- [35]
			"85829:76787:87395:88653", -- [36]
			"85829:76784:79407:88668", -- [37]
			"84714:88757", -- [38]
			"84714:92808:90550", -- [39]
			"85829:81055:84508:90560", -- [40]
			"85829:81055:84508:90552", -- [41]
			"84714:92808:90562", -- [42]
			"84714:92808", -- [43]
			"84714:92808:92809", -- [44]
			--["name"] = "Iron Docks, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "81055:86492:85829:84714",
			["coord"] = 1850160084,
		},
		[84515] = {
			"84504:76850", -- [1]
			"81354:81064:79407:76782", -- [2]
			"81354:81064:79407:76781", -- [3]
			"81354:81064:76787:76783", -- [4]
			"81354:81064:76787", -- [5]
			"81354:81064:79407:76879", -- [6]
			"81057:76784", -- [7]
			"81354:81064:79407:78699", -- [8]
			"88584:86049", -- [9]
			"81354:81064:79407", -- [10]
			"81354:80932", -- [11]
			"81057:81053", -- [12]
			"81057:84495:81055", -- [13]
			"81354:81058", -- [14]
			"81354:81064", -- [15]
			"84509:81068", -- [16]
			"84509:81078", -- [17]
			"84504:81285", -- [18]
			"81354:81064:82346:83924", -- [19]
			"81354:81064:82346:82844", -- [20]
			"81354:81064:82346", -- [21]
			"81354:81064:82346:82340", -- [22]
			"81057:84508", -- [23]
			"81057:84495", -- [24]
			"81057:84495:81055:86492", -- [25]
			"81057:84495:81055:84700", -- [26]
			"84504:81285:83427", -- [27]
			"81057:84495:85829", -- [28]
			"81057:76784:87707", -- [29]
			"81057:84495:81055:84714", -- [30]
			"81354:81064:82346:82340:87395", -- [31]
			"84498:82612:88653", -- [32]
			"81354:81064:82346:82844:88668", -- [33]
			"81057:84495:81055:84714:88757", -- [34]
			"81354:80932:90562:90550", -- [35]
			"81354:80932:90560", -- [36]
			"81057:90552", -- [37]
			"81354:80932:90562", -- [38]
			"81354:80932:92809:92808", -- [39]
			"81354:80932:92809", -- [40]
			--["name"] = "Crow's Crook, Spires of Arak",
			["m"] = 542,
			["coord"] = 2222935940,
			["direct"] = "81057:81354:82612:84498:84504:82511:84509:88584",
			["f"] = 0,
		},
		[81058] = {
			"81078:76850", -- [1]
			"81064:79407:76782", -- [2]
			"81064:79407:76781", -- [3]
			"81064:76787:76783", -- [4]
			"81064:76787", -- [5]
			"81064:79407:76879", -- [6]
			"81064:76784", -- [7]
			"81064:79407:78699", -- [8]
			"81053:90552:90550:86049", -- [9]
			"81064:79407", -- [10]
			"81064:81057:80932", -- [11]
			"81053:84495:81055", -- [12]
			"81064:81068", -- [13]
			"81064:88584:81285", -- [14]
			"81078:84509:82612", -- [15]
			"81064:82346:83924", -- [16]
			"81064:82346:82844", -- [17]
			"81064:82346:82340", -- [18]
			"81078:84509:84498", -- [19]
			"81078:84509:84515:84504", -- [20]
			"81078:84509:84498:82511", -- [21]
			"81053:84508", -- [22]
			"81078:84509", -- [23]
			"81053:84495", -- [24]
			"81078:84509:84515", -- [25]
			"81064:76784:86492", -- [26]
			"81064:76784:85829:84700", -- [27]
			"81064:88584:81285:83427", -- [28]
			"81064:76784:85829", -- [29]
			"81064:76784:87707", -- [30]
			"81064:76784:86492:84714", -- [31]
			"81064:88584", -- [32]
			"81064:82346:82340:87395", -- [33]
			"81064:82346:83924:88653", -- [34]
			"81064:82346:82844:88668", -- [35]
			"81064:76784:86492:84714:88757", -- [36]
			"81053:90552:90550", -- [37]
			"81053:90552:90560", -- [38]
			"81053:90552", -- [39]
			"81053:90552:90562", -- [40]
			"81053:90552:92809:92808", -- [41]
			"81053:90552:92809", -- [42]
			--["name"] = "Durotan's Grasp, Talador",
			["m"] = 535,
			["coord"] = 2382587995,
			["direct"] = "81053:81057:81064:81078:81354:82346",
			["f"] = 0,
		},
		[82511] = {
			"84504:76850", -- [1]
			"84504:88584:81064:79407:76782", -- [2]
			"84504:88584:81064:79407:76781", -- [3]
			"84504:88584:81064:76787:76783", -- [4]
			"84504:88584:81064:76787", -- [5]
			"84504:88584:81064:79407:76879", -- [6]
			"84504:88584:81354:81057:76784", -- [7]
			"84504:88584:81064:79407:78699", -- [8]
			"84504:76850:86049", -- [9]
			"84504:88584:81354:80932", -- [10]
			"84504:88584:81354:81057:81053", -- [11]
			"84504:88584:81354:81057:84495:81055", -- [12]
			"84504:88584:81354:81057", -- [13]
			"84504:88584:81354:81058", -- [14]
			"84504:88584:81064", -- [15]
			"84498:84509:81068", -- [16]
			"84498:84509:81078", -- [17]
			"84504:88584:81354", -- [18]
			"84504:81285", -- [19]
			"84498:82612", -- [20]
			"84504:88584:81064:82346:83924", -- [21]
			"84504:88584:81064:82346:82844", -- [22]
			"84504:88584:81064:82346", -- [23]
			"84498:82612:88653:82340", -- [24]
			"84504:88584:81354:81057:84508", -- [25]
			"84498:84509", -- [26]
			"84504:88584:81354:81057:84495", -- [27]
			"84504:88584:81354:81057:84495:81055:86492", -- [28]
			"84504:88584:81354:81057:84495:81055:84700", -- [29]
			"84504:81285:83427", -- [30]
			"84504:88584:81354:81057:84495:85829", -- [31]
			"84504:88584:81354:81057:76784:87707", -- [32]
			"84504:88584:81354:81057:84495:81055:84714", -- [33]
			"84498:82612:88653:82340:87395", -- [34]
			"84498:82612:88653", -- [35]
			"84504:88584:81064:82346:82844:88668", -- [36]
			"84504:88584:81354:81057:84495:81055:84714:88757", -- [37]
			"84504:76850:90562:90550", -- [38]
			"84504:88584:81354:80932:90560", -- [39]
			"84504:88584:81354:81057:90552", -- [40]
			"84504:76850:90562", -- [41]
			"84504:76850:90562:92808", -- [42]
			"84504:88584:81354:80932:92809", -- [43]
			--["name"] = "Pinchwhistle Gearworks, Spires of Arak",
			["m"] = 542,
			["f"] = 0,
			["direct"] = "79407:84498:84504:84515:88584",
			["coord"] = 2614672287,
		},
		[76782] = {
			"79407:81057:81354:76850", -- [1]
			"76781:76783", -- [2]
			"76879:78699:76787", -- [3]
			"79407:76784", -- [4]
			"76879:78699", -- [5]
			"79407:86049", -- [6]
			"79407:81057:80932", -- [7]
			"79407:81053", -- [8]
			"79407:81055", -- [9]
			"79407:81057", -- [10]
			"79407:81053:81058", -- [11]
			"79407:81064", -- [12]
			"79407:81064:81068", -- [13]
			"79407:81064:81078", -- [14]
			"79407:81057:81354", -- [15]
			"79407:81064:88584:81285", -- [16]
			"79407:82612", -- [17]
			"79407:82346:83924", -- [18]
			"79407:82844", -- [19]
			"79407:82346", -- [20]
			"79407:82844:82340", -- [21]
			"79407:81064:81078:84509:84498", -- [22]
			"79407:81064:81078:84509:84515:84504", -- [23]
			"79407:82511", -- [24]
			"79407:81053:84508", -- [25]
			"79407:81064:81078:84509", -- [26]
			"79407:76784:84495", -- [27]
			"79407:81064:81078:84509:84515", -- [28]
			"79407:76784:86492", -- [29]
			"76879:78699:76787:85829:84700", -- [30]
			"79407:81057:83427", -- [31]
			"76879:78699:76787:85829", -- [32]
			"79407:87707", -- [33]
			"79407:76784:86492:84714", -- [34]
			"79407:81064:88584", -- [35]
			"79407:87395", -- [36]
			"79407:88668:88653", -- [37]
			"79407:88668", -- [38]
			"79407:76784:86492:84714:88757", -- [39]
			"79407:81053:90552:90550", -- [40]
			"79407:81053:90552:90560", -- [41]
			"79407:81053:90552", -- [42]
			"79407:81053:90552:90562", -- [43]
			"79407:81053:90552:92809:92808", -- [44]
			"79407:81053:90552:92809", -- [45]
			--["name"] = "Wor'gol, Frostfire Ridge",
			["m"] = 525,
			["coord"] = 928157606,
			["direct"] = "76781:76879:79407",
			["f"] = 0,
		},
		[86492] = {
			"81055:84508:90552:90562:76850", -- [1]
			"76784:79407:76782", -- [2]
			"76784:76879:76781", -- [3]
			"85829:76787:76783", -- [4]
			"85829:76787", -- [5]
			"76784:76879", -- [6]
			"76784:87707:78699", -- [7]
			"84714:86049", -- [8]
			"76784:79407", -- [9]
			"81055:84508:90552:80932", -- [10]
			"81055:84508:81053", -- [11]
			"81055:81057", -- [12]
			"81055:84508:81053:81058", -- [13]
			"76784:81064", -- [14]
			"76784:81064:81068", -- [15]
			"76784:81064:81078", -- [16]
			"81055:81057:81354", -- [17]
			"81055:81057:81285", -- [18]
			"81055:81057:82612", -- [19]
			"81055:84508:81053:82346:83924", -- [20]
			"76784:79407:82844", -- [21]
			"81055:84508:81053:82346", -- [22]
			"76784:79407:82844:82340", -- [23]
			"81055:81057:81354:84515:84498", -- [24]
			"81055:81057:81354:84515:84504", -- [25]
			"81055:81057:81354:84515:82511", -- [26]
			"81055:84508", -- [27]
			"76784:81064:81078:84509", -- [28]
			"81055:84495", -- [29]
			"81055:81057:81354:84515", -- [30]
			"81055:81057:83427", -- [31]
			"76784:87707", -- [32]
			"81055:81057:81354:88584", -- [33]
			"76784:79407:87395", -- [34]
			"76784:79407:88668:88653", -- [35]
			"76784:79407:88668", -- [36]
			"84714:88757", -- [37]
			"84714:92808:90550", -- [38]
			"81055:84508:90560", -- [39]
			"81055:84508:90552", -- [40]
			"81055:84508:90552:90562", -- [41]
			"84714:92808", -- [42]
			"81055:84508:90552:92809", -- [43]
			--["name"] = "Breaker's Crown, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "76784:81055:84700:85829:84714",
			["coord"] = 1970048188,
		},
		[81078] = {
			"81064:79407:76782", -- [1]
			"81064:79407:76781", -- [2]
			"81064:76787:76783", -- [3]
			"81064:76787", -- [4]
			"81064:79407:76879", -- [5]
			"81064:76784", -- [6]
			"81064:79407:78699", -- [7]
			"81354:80932:90562:90550:86049", -- [8]
			"81064:79407", -- [9]
			"81354:80932", -- [10]
			"81058:81053", -- [11]
			"81354:81057:84495:81055", -- [12]
			"81354:81057", -- [13]
			"84509:82612", -- [14]
			"81064:82346:83924", -- [15]
			"81064:82346:82844", -- [16]
			"81064:82346", -- [17]
			"81064:82346:82340", -- [18]
			"84509:84498", -- [19]
			"84509:84515:84504", -- [20]
			"84509:84498:82511", -- [21]
			"81354:81057:84508", -- [22]
			"81354:81057:84495", -- [23]
			"84509:84515", -- [24]
			"81064:76784:86492", -- [25]
			"81064:76784:85829:84700", -- [26]
			"81285:83427", -- [27]
			"81064:76784:85829", -- [28]
			"81064:76784:87707", -- [29]
			"81064:76784:86492:84714", -- [30]
			"81064:82346:82340:87395", -- [31]
			"81064:82346:83924:88653", -- [32]
			"81064:82346:82844:88668", -- [33]
			"81064:76784:86492:84714:88757", -- [34]
			"81354:80932:90562:90550", -- [35]
			"81354:80932:90560", -- [36]
			"81354:81057:90552", -- [37]
			"81354:80932:90562", -- [38]
			"81354:80932:92809:92808", -- [39]
			"81354:80932:92809", -- [40]
			--["name"] = "Exarch's Refuge, Talador",
			["m"] = 535,
			["coord"] = 2342432177,
			["direct"] = "76850:81058:81064:81068:81354:81285:84509:88584",
			["f"] = 0,
		},
		[82346] = {
			"81064:81078:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"79407:78699:76783", -- [4]
			"79407:76787", -- [5]
			"79407:76879", -- [6]
			"79407:76784", -- [7]
			"79407:78699", -- [8]
			"81053:90552:90550:86049", -- [9]
			"81057:80932", -- [10]
			"83924:81068", -- [11]
			"81064:81078", -- [12]
			"81058:81354", -- [13]
			"81064:88584:81285", -- [14]
			"83924:81068:84509:84498", -- [15]
			"83924:81068:84509:84515:84504", -- [16]
			"83924:81068:84509:84498:82511", -- [17]
			"81053:84508", -- [18]
			"83924:81068:84509", -- [19]
			"81053:84495", -- [20]
			"83924:81068:84509:84515", -- [21]
			"81055:86492", -- [22]
			"81055:84700", -- [23]
			"81064:88584:81285:83427", -- [24]
			"81055:85829", -- [25]
			"79407:87707", -- [26]
			"81055:84714", -- [27]
			"81064:88584", -- [28]
			"82340:87395", -- [29]
			"83924:88653", -- [30]
			"82844:88668", -- [31]
			"81055:84714:88757", -- [32]
			"81053:90552:90550", -- [33]
			"81053:90552:90560", -- [34]
			"81053:90552", -- [35]
			"81053:90552:90562", -- [36]
			"81053:90552:92809:92808", -- [37]
			"81053:90552:92809", -- [38]
			--["name"] = "Wor'var, Nagrand",
			["m"] = 550,
			["f"] = 0,
			["direct"] = "79407:81053:81055:81057:81058:81064:82612:83924:82844:82340",
			["coord"] = 3575018026,
		},
		[92808] = {
			"90562:76850", -- [1]
			"90560:84508:84495:76784:79407:76782", -- [2]
			"90560:84508:84495:76784:76879:76781", -- [3]
			"90560:84508:84495:76784:76787:76783", -- [4]
			"90560:84508:84495:76784:76787", -- [5]
			"90560:84508:84495:76784:76879", -- [6]
			"90560:84508:84495:76784", -- [7]
			"90560:84508:84495:76784:87707:78699", -- [8]
			"90550:86049", -- [9]
			"90560:84508:84495:76784:79407", -- [10]
			"92809:80932", -- [11]
			"90560:84508:81053", -- [12]
			"90560:84508:81055", -- [13]
			"90560:90552:81057", -- [14]
			"90560:84508:81053:81058", -- [15]
			"90560:84508:81053:81058:81064", -- [16]
			"90560:84508:81053:81058:81064:81068", -- [17]
			"92809:80932:81354:81078", -- [18]
			"92809:80932:81354", -- [19]
			"90562:76850:81285", -- [20]
			"90562:76850:88584:82612", -- [21]
			"90560:84508:81053:82346:83924", -- [22]
			"90560:84508:81053:82346:82844", -- [23]
			"90560:84508:81053:82346", -- [24]
			"90560:84508:81053:82346:82340", -- [25]
			"92809:80932:81354:84515:84498", -- [26]
			"90562:76850:84504", -- [27]
			"90562:76850:84504:82511", -- [28]
			"90560:84508", -- [29]
			"92809:80932:81354:81078:84509", -- [30]
			"90560:84508:84495", -- [31]
			"92809:80932:81354:84515", -- [32]
			"90560:84508:81055:86492", -- [33]
			"84714:84700", -- [34]
			"90562:76850:83427", -- [35]
			"84714:85829", -- [36]
			"90560:84508:84495:76784:87707", -- [37]
			"90562:76850:88584", -- [38]
			"90560:84508:81053:82346:82340:87395", -- [39]
			"90560:84508:81053:82346:83924:88653", -- [40]
			"90560:84508:81053:82346:82844:88668", -- [41]
			"84714:88757", -- [42]
			"90560:90552", -- [43]
			["direct"] = "84714:90550:90560:90562:92809",
			["m"] = 534,
			["coord"] = 1863937064,
			["f"] = 0,
		},
		[81354] = {
			"81064:79407:76782", -- [1]
			"81064:79407:76781", -- [2]
			"81064:76787:76783", -- [3]
			"81064:76787", -- [4]
			"81064:79407:76879", -- [5]
			"81057:76784", -- [6]
			"81064:79407:78699", -- [7]
			"80932:90562:90550:86049", -- [8]
			"81064:79407", -- [9]
			"81057:81053", -- [10]
			"81057:84495:81055", -- [11]
			"81078:81068", -- [12]
			"88584:81285", -- [13]
			"84515:84498:82612", -- [14]
			"81064:82346:83924", -- [15]
			"81064:82346:82844", -- [16]
			"81064:82346", -- [17]
			"81064:82346:82340", -- [18]
			"84515:84498", -- [19]
			"84515:84504", -- [20]
			"84515:82511", -- [21]
			"81057:84508", -- [22]
			"81078:84509", -- [23]
			"81057:84495", -- [24]
			"81057:84495:81055:86492", -- [25]
			"81057:84495:81055:84700", -- [26]
			"88584:81285:83427", -- [27]
			"81057:84495:85829", -- [28]
			"81057:76784:87707", -- [29]
			"81057:84495:81055:84714", -- [30]
			"81064:82346:82340:87395", -- [31]
			"81064:82346:83924:88653", -- [32]
			"81064:82346:82844:88668", -- [33]
			"81057:84495:81055:84714:88757", -- [34]
			"80932:90562:90550", -- [35]
			"80932:90560", -- [36]
			"81057:90552", -- [37]
			"80932:90562", -- [38]
			"80932:92809:92808", -- [39]
			"80932:92809", -- [40]
			--["name"] = "Terokkar Refuge, Talador",
			["m"] = 535,
			["coord"] = 3022164527,
			["direct"] = "76850:80932:81057:81058:81064:81078:84515:88584",
			["f"] = 0,
		},
		[84508] = {
			"90552:90562:76850", -- [1]
			"84495:76784:79407:76782", -- [2]
			"84495:76784:76879:76781", -- [3]
			"84495:76784:76787:76783", -- [4]
			"84495:76784:76787", -- [5]
			"84495:76784:76879", -- [6]
			"84495:76784", -- [7]
			"84495:76784:87707:78699", -- [8]
			"84495:76784:79407", -- [9]
			"90552:80932", -- [10]
			"81053:81058", -- [11]
			"81053:81058:81064", -- [12]
			"81053:81058:81064:81068", -- [13]
			"81053:81058:81078", -- [14]
			"81057:81354", -- [15]
			"81057:81285", -- [16]
			"81057:82612", -- [17]
			"81053:82346:83924", -- [18]
			"81053:82346:82844", -- [19]
			"81053:82346", -- [20]
			"81053:82346:82340", -- [21]
			"81057:81354:84515:84498", -- [22]
			"81057:81354:84515:84504", -- [23]
			"81057:81354:84515:82511", -- [24]
			"81053:81058:81078:84509", -- [25]
			"81057:81354:84515", -- [26]
			"81055:86492", -- [27]
			"81055:84700", -- [28]
			"81057:83427", -- [29]
			"81055:85829", -- [30]
			"84495:76784:87707", -- [31]
			"81055:84714", -- [32]
			"81057:81354:88584", -- [33]
			"81053:82346:82340:87395", -- [34]
			"81053:82346:83924:88653", -- [35]
			"81053:82346:82844:88668", -- [36]
			"81055:84714:88757", -- [37]
			"90560:90550", -- [38]
			"90552:90562", -- [39]
			"90560:92808", -- [40]
			"90552:92809", -- [41]
			--["name"] = "Bastion Rise, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "86049:81053:81055:81057:84495:90560:90552",
			["coord"] = 2037246059,
		},
		[90560] = {
			"90562:76850", -- [1]
			"84508:84495:76784:79407:76782", -- [2]
			"84508:84495:76784:76879:76781", -- [3]
			"84508:84495:76784:76787:76783", -- [4]
			"84508:84495:76784:76787", -- [5]
			"84508:84495:76784:76879", -- [6]
			"84508:84495:76784", -- [7]
			"84508:84495:76784:87707:78699", -- [8]
			"90550:86049", -- [9]
			"84508:84495:76784:79407", -- [10]
			"84508:81053", -- [11]
			"84508:81055", -- [12]
			"90552:81057", -- [13]
			"84508:81053:81058", -- [14]
			"84508:81053:81058:81064", -- [15]
			"84508:81053:81058:81064:81068", -- [16]
			"80932:81354:81078", -- [17]
			"80932:81354", -- [18]
			"90562:76850:81285", -- [19]
			"90552:81057:82612", -- [20]
			"84508:81053:82346:83924", -- [21]
			"84508:81053:82346:82844", -- [22]
			"84508:81053:82346", -- [23]
			"84508:81053:82346:82340", -- [24]
			"80932:81354:84515:84498", -- [25]
			"80932:81354:84515:84504", -- [26]
			"80932:81354:84515:82511", -- [27]
			"80932:81354:81078:84509", -- [28]
			"84508:84495", -- [29]
			"80932:81354:84515", -- [30]
			"84508:81055:86492", -- [31]
			"84508:81055:84700", -- [32]
			"90562:76850:83427", -- [33]
			"84508:81055:85829", -- [34]
			"84508:84495:76784:87707", -- [35]
			"84508:81055:84714", -- [36]
			"80932:81354:88584", -- [37]
			"84508:81053:82346:82340:87395", -- [38]
			"84508:81053:82346:83924:88653", -- [39]
			"84508:81053:82346:82844:88668", -- [40]
			"84508:81055:84714:88757", -- [41]
			--["name"] = "Aktar's Post, Tanaan Jungle",
			["m"] = 534,
			["f"] = 0,
			["direct"] = "80932:84508:90550:90552:90562:92808:92809",
			["coord"] = 1123443651,
		},
		[81055] = {
			"84508:90552:90562:76850", -- [1]
			"79407:76782", -- [2]
			"76784:76879:76781", -- [3]
			"76784:76787:76783", -- [4]
			"76784:76787", -- [5]
			"76784:76879", -- [6]
			"76784:87707:78699", -- [7]
			"84508:90552:80932", -- [8]
			"84508:81053", -- [9]
			"84508:81053:81058", -- [10]
			"84508:81053:81058:81064", -- [11]
			"84508:81053:81058:81064:81068", -- [12]
			"84508:81053:81058:81078", -- [13]
			"81057:81354", -- [14]
			"81057:81285", -- [15]
			"81057:82612", -- [16]
			"84508:81053:82346:83924", -- [17]
			"79407:82844", -- [18]
			"84508:81053:82346:82340", -- [19]
			"81057:81354:84515:84498", -- [20]
			"81057:81354:84515:84504", -- [21]
			"81057:81354:84515:82511", -- [22]
			"84508:81053:81058:81078:84509", -- [23]
			"81057:81354:84515", -- [24]
			"81057:83427", -- [25]
			"76784:87707", -- [26]
			"81057:81354:88584", -- [27]
			"79407:87395", -- [28]
			"84508:81053:82346:83924:88653", -- [29]
			"79407:88668", -- [30]
			"84714:88757", -- [31]
			"84508:90560:90550", -- [32]
			"84508:90560", -- [33]
			"84508:90552", -- [34]
			"84508:90552:90562", -- [35]
			"84508:90560:92808", -- [36]
			"84508:90552:92809", -- [37]
			--["name"] = "Beastwatch, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "76784:86049:79407:81057:82346:84508:84495:86492:84700:85829:84714",
			["coord"] = 1976152391,
		},
		[76783] = {
			"78699:79407:81057:81354:76850", -- [1]
			"76781:76782", -- [2]
			"76781:76879", -- [3]
			"76787:76784", -- [4]
			"76787:85829:86049", -- [5]
			"78699:79407", -- [6]
			"78699:79407:81057:80932", -- [7]
			"78699:79407:81053", -- [8]
			"76787:76784:81055", -- [9]
			"78699:79407:81057", -- [10]
			"78699:79407:81053:81058", -- [11]
			"78699:79407:81064", -- [12]
			"78699:79407:81064:81068", -- [13]
			"78699:79407:81064:81078", -- [14]
			"78699:79407:81057:81354", -- [15]
			"78699:79407:81064:88584:81285", -- [16]
			"78699:79407:82612", -- [17]
			"78699:79407:82346:83924", -- [18]
			"78699:79407:82844", -- [19]
			"78699:79407:82346", -- [20]
			"78699:79407:82844:82340", -- [21]
			"78699:79407:81064:81078:84509:84498", -- [22]
			"78699:79407:81064:81078:84509:84515:84504", -- [23]
			"78699:79407:82511", -- [24]
			"76787:76784:81055:84508", -- [25]
			"78699:79407:81064:81078:84509", -- [26]
			"76787:76784:84495", -- [27]
			"78699:79407:81064:81078:84509:84515", -- [28]
			"76787:85829:86492", -- [29]
			"76787:85829:84700", -- [30]
			"78699:79407:81057:83427", -- [31]
			"76787:85829", -- [32]
			"78699:87707", -- [33]
			"76787:85829:84714", -- [34]
			"78699:79407:81064:88584", -- [35]
			"78699:79407:87395", -- [36]
			"78699:79407:88668:88653", -- [37]
			"78699:79407:88668", -- [38]
			"76787:85829:84714:88757", -- [39]
			"78699:79407:81053:90552:90550", -- [40]
			"76787:76784:81055:84508:90560", -- [41]
			"78699:79407:81053:90552", -- [42]
			"78699:79407:81053:90552:90562", -- [43]
			"78699:79407:81053:90552:92809:92808", -- [44]
			"78699:79407:81053:90552:92809", -- [45]
			--["name"] = "Throm'Var, Frostfire Ridge",
			["m"] = 525,
			["coord"] = 1367283875,
			["direct"] = "76781:76787:78699",
			["f"] = 0,
		},
		[76850] = {
			"81354:81064:79407:76782", -- [1]
			"81354:81064:79407:76781", -- [2]
			"81354:81064:76787:76783", -- [3]
			"81354:81064:76787", -- [4]
			"81354:81064:79407:76879", -- [5]
			"81354:81057:76784", -- [6]
			"81354:81064:79407:78699", -- [7]
			"81354:81064:79407", -- [8]
			"81354:80932", -- [9]
			"81354:81057:81053", -- [10]
			"90562:92809:90560:84508:81055", -- [11]
			"81354:81057", -- [12]
			"81354:81058", -- [13]
			"81354:81064", -- [14]
			"81078:81068", -- [15]
			"88584:82612", -- [16]
			"81354:81064:82346:83924", -- [17]
			"81354:81064:82346:82844", -- [18]
			"81354:81064:82346", -- [19]
			"81354:81064:82346:82340", -- [20]
			"88584:84515:84498", -- [21]
			"84504:82511", -- [22]
			"90562:92809:90560:84508", -- [23]
			"88584:84515:84509", -- [24]
			"81354:81057:84495", -- [25]
			"88584:84515", -- [26]
			"90562:92809:90560:84508:81055:86492", -- [27]
			"90562:92808:84714:84700", -- [28]
			"90562:92808:84714:85829", -- [29]
			"81354:81057:76784:87707", -- [30]
			"90562:92808:84714", -- [31]
			"81354:81064:82346:82340:87395", -- [32]
			"81354:81064:82346:83924:88653", -- [33]
			"81354:81064:82346:82844:88668", -- [34]
			"90562:92808:84714:88757", -- [35]
			"90562:90550", -- [36]
			"90562:92809:90560", -- [37]
			"90562:90552", -- [38]
			"90562:92808", -- [39]
			"90562:92809", -- [40]
			--["name"] = "Exile's Rise, Shadowmoon Valley",
			["m"] = 539,
			["coord"] = 1960067326,
			["direct"] = "86049:81078:81354:81285:84504:83427:88584:90562",
			["f"] = 0,
		},
		[88584] = {
			"81064:79407:76782", -- [1]
			"81064:79407:76781", -- [2]
			"81064:76787:76783", -- [3]
			"81064:76787", -- [4]
			"81064:79407:76879", -- [5]
			"81354:81057:76784", -- [6]
			"81064:79407:78699", -- [7]
			"81064:79407", -- [8]
			"81354:80932", -- [9]
			"81354:81057:81053", -- [10]
			"81354:81057:84495:81055", -- [11]
			"81354:81058", -- [12]
			"81078:81068", -- [13]
			"81064:82346:83924", -- [14]
			"81064:82346:82844", -- [15]
			"81064:82346", -- [16]
			"81064:82346:82340", -- [17]
			"84515:84498", -- [18]
			"81354:81057:84508", -- [19]
			"84515:84509", -- [20]
			"81354:81057:84495", -- [21]
			"81354:81057:84495:81055:86492", -- [22]
			"81354:81057:84495:81055:84700", -- [23]
			"81285:83427", -- [24]
			"81354:81057:84495:85829", -- [25]
			"81354:81057:76784:87707", -- [26]
			"81354:81057:84495:81055:84714", -- [27]
			"81064:82346:82340:87395", -- [28]
			"82612:88653", -- [29]
			"81064:82346:82844:88668", -- [30]
			"81354:81057:84495:81055:84714:88757", -- [31]
			"76850:90562:90550", -- [32]
			"81354:80932:90560", -- [33]
			"81354:81057:90552", -- [34]
			"76850:90562", -- [35]
			"81354:80932:92809:92808", -- [36]
			"81354:80932:92809", -- [37]
			--["name"] = "Akeeta's Hovel, Shadowmoon Valley",
			["m"] = 542,
			["coord"] = 2820484300,
			["direct"] = "76850:86049:81057:81064:81078:81354:81285:82612:84504:82511:84515",
			["f"] = 0,
		},
		[92809] = {
			"90562:76850", -- [1]
			"90552:81053:79407:76782", -- [2]
			"90560:84508:84495:76784:76879:76781", -- [3]
			"90560:84508:84495:76784:76787:76783", -- [4]
			"90560:84508:84495:76784:76787", -- [5]
			"90560:84508:84495:76784:76879", -- [6]
			"90560:84508:84495:76784", -- [7]
			"90560:84508:84495:76784:87707:78699", -- [8]
			"92808:90550:86049", -- [9]
			"90552:81053:79407", -- [10]
			"90552:81053", -- [11]
			"90560:84508:81055", -- [12]
			"80932:81057", -- [13]
			"80932:81057:81058", -- [14]
			"80932:81057:81058:81064", -- [15]
			"80932:81354:81078:81068", -- [16]
			"80932:81354:81078", -- [17]
			"80932:81354", -- [18]
			"90562:76850:81285", -- [19]
			"80932:81354:84515:84498:82612", -- [20]
			"90552:81053:82346:83924", -- [21]
			"90552:81053:82346:82844", -- [22]
			"90552:81053:82346", -- [23]
			"90552:81053:82346:82340", -- [24]
			"80932:81354:84515:84498", -- [25]
			"80932:81354:84515:84504", -- [26]
			"80932:81354:84515:82511", -- [27]
			"90560:84508", -- [28]
			"80932:81354:81078:84509", -- [29]
			"90560:84508:84495", -- [30]
			"80932:81354:84515", -- [31]
			"90560:84508:81055:86492", -- [32]
			"92808:84714:84700", -- [33]
			"90562:76850:83427", -- [34]
			"90560:84508:81055:85829", -- [35]
			"90560:84508:84495:76784:87707", -- [36]
			"92808:84714", -- [37]
			"80932:81354:88584", -- [38]
			"90552:81053:82346:82340:87395", -- [39]
			"90552:81053:82346:83924:88653", -- [40]
			"90552:81053:82346:82844:88668", -- [41]
			"92808:84714:88757", -- [42]
			"92808:90550", -- [43]
			--["name"] = "Sha'naari Refuge, Tanaan Jungle",
			["m"] = 534,
			["f"] = 0,
			["direct"] = "80932:90560:90552:90562:92808",
			["coord"] = 1268425030,
		},
		[87395] = {
			"88668:82844:83924:81064:81078:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"76787:76783", -- [4]
			"79407:76879", -- [5]
			"79407:76784", -- [6]
			"79407:78699", -- [7]
			"79407:86049", -- [8]
			"88668:82844:82346:81057:80932", -- [9]
			"88668:82844:82346:81053", -- [10]
			"79407:81055", -- [11]
			"88668:82844:82346:81057", -- [12]
			"88668:82844:82346:81058", -- [13]
			"88668:82844:83924:81064", -- [14]
			"88668:82844:83924:81068", -- [15]
			"88668:82844:83924:81064:81078", -- [16]
			"88668:82844:83924:81064:81354", -- [17]
			"88653:82612:81285", -- [18]
			"88653:82612", -- [19]
			"88668:82844:83924", -- [20]
			"88668:82844", -- [21]
			"88668:82844:82346", -- [22]
			"88668:82844:83924:81068:84509:84498", -- [23]
			"88668:82844:83924:81068:84509:84515:84504", -- [24]
			"88668:82844:83924:81068:84509:84498:82511", -- [25]
			"88668:82844:82346:81053:84508", -- [26]
			"88668:82844:83924:81068:84509", -- [27]
			"88668:82844:82346:81053:84495", -- [28]
			"88668:82844:83924:81068:84509:84515", -- [29]
			"79407:76784:86492", -- [30]
			"79407:76784:85829:84700", -- [31]
			"88653:82612:81285:83427", -- [32]
			"79407:76784:85829", -- [33]
			"79407:87707", -- [34]
			"79407:76784:86492:84714", -- [35]
			"88668:82844:83924:81064:88584", -- [36]
			"79407:76784:86492:84714:88757", -- [37]
			"88668:82844:82346:81053:90552:90550", -- [38]
			"88668:82844:82346:81053:90552:90560", -- [39]
			"88668:82844:82346:81053:90552", -- [40]
			"88668:82844:82346:81053:90552:90562", -- [41]
			"88668:82844:82346:81053:90552:92809:92808", -- [42]
			"88668:82844:82346:81053:90552:92809", -- [43]
			--["name"] = "Rilzit's Holdfast, Nagrand",
			["m"] = 550,
			["f"] = 0,
			["direct"] = "76787:79407:82340:88653:88668",
			["coord"] = 2178240153,
		},
		[84509] = {
			"84515:84504:76850", -- [1]
			"81078:81064:79407:76782", -- [2]
			"81078:81064:79407:76781", -- [3]
			"81078:81064:76787:76783", -- [4]
			"81078:81064:76787", -- [5]
			"81078:81064:79407:76879", -- [6]
			"81078:81064:76784", -- [7]
			"81078:81064:79407:78699", -- [8]
			"84515:88584:86049", -- [9]
			"81078:81354:80932", -- [10]
			"81078:81058:81053", -- [11]
			"81078:81354:81057:84495:81055", -- [12]
			"81078:81354:81057", -- [13]
			"81078:81058", -- [14]
			"81078:81354", -- [15]
			"84515:84504:81285", -- [16]
			"81068:83924", -- [17]
			"81068:83924:82844", -- [18]
			"81078:81064:82346", -- [19]
			"81078:81064:82346:82340", -- [20]
			"84515:84504", -- [21]
			"84498:82511", -- [22]
			"81078:81354:81057:84508", -- [23]
			"81078:81354:81057:84495", -- [24]
			"81078:81064:76784:86492", -- [25]
			"81078:81064:76784:85829:84700", -- [26]
			"84515:84504:81285:83427", -- [27]
			"81078:81064:76784:85829", -- [28]
			"81078:81064:76784:87707", -- [29]
			"81078:81064:76784:86492:84714", -- [30]
			"84515:88584", -- [31]
			"81078:81064:82346:82340:87395", -- [32]
			"82612:88653", -- [33]
			"81068:83924:82844:88668", -- [34]
			"81078:81064:76784:86492:84714:88757", -- [35]
			"81078:81354:80932:90562:90550", -- [36]
			"81078:81354:80932:90560", -- [37]
			"81078:81354:81057:90552", -- [38]
			"81078:81354:80932:90562", -- [39]
			"81078:81354:80932:92809:92808", -- [40]
			"81078:81354:80932:92809", -- [41]
			--["name"] = "Apexis Excavation, Spires of Arak",
			["m"] = 542,
			["coord"] = 1586446107,
			["direct"] = "79407:81064:81068:81078:82612:84498:84515",
			["f"] = 0,
		},
		[76787] = {
			"76784:81057:81354:76850", -- [1]
			"76781:76782", -- [2]
			"78699:76879", -- [3]
			"85829:86049", -- [4]
			"76784:81057:80932", -- [5]
			"78699:79407:81053", -- [6]
			"76784:81055", -- [7]
			"76784:81057", -- [8]
			"78699:79407:81053:81058", -- [9]
			"78699:79407:81064:81068", -- [10]
			"78699:79407:81064:81078", -- [11]
			"76784:81057:81354", -- [12]
			"78699:79407:81064:88584:81285", -- [13]
			"78699:79407:82612", -- [14]
			"78699:79407:82346:83924", -- [15]
			"78699:79407:82346", -- [16]
			"87395:82340", -- [17]
			"78699:79407:81064:81078:84509:84498", -- [18]
			"78699:79407:81064:81078:84509:84515:84504", -- [19]
			"78699:79407:82511", -- [20]
			"76784:81055:84508", -- [21]
			"78699:79407:81064:81078:84509", -- [22]
			"76784:84495", -- [23]
			"78699:79407:81064:81078:84509:84515", -- [24]
			"85829:86492", -- [25]
			"85829:84700", -- [26]
			"76784:81057:83427", -- [27]
			"78699:87707", -- [28]
			"85829:84714", -- [29]
			"78699:79407:81064:88584", -- [30]
			"87395:88653", -- [31]
			"78699:79407:88668", -- [32]
			"85829:84714:88757", -- [33]
			"78699:79407:81053:90552:90550", -- [34]
			"76784:81055:84508:90560", -- [35]
			"78699:79407:81053:90552", -- [36]
			"78699:79407:81053:90552:90562", -- [37]
			"85829:84714:92808", -- [38]
			"78699:79407:81053:90552:92809", -- [39]
			--["name"] = "Bloodmaul Slag Mines, Frostfire Ridge",
			["m"] = 525,
			["coord"] = 2211067641,
			["direct"] = "76781:76783:76784:78699:79407:81064:82844:85829:87395",
			["f"] = 0,
		},
		[80932] = {
			"81354:76850", -- [1]
			"81057:79407:76782", -- [2]
			"81057:79407:76781", -- [3]
			"90552:84508:84495:76784:76787:76783", -- [4]
			"90552:84508:84495:76784:76787", -- [5]
			"81057:79407:76879", -- [6]
			"90552:84508:84495:76784", -- [7]
			"90552:84508:84495:76784:87707:78699", -- [8]
			"90562:90550:86049", -- [9]
			"81057:79407", -- [10]
			"81057:81053", -- [11]
			"90552:84508:81055", -- [12]
			"81057:81058", -- [13]
			"81057:81058:81064", -- [14]
			"81354:81078:81068", -- [15]
			"81354:81078", -- [16]
			"81354:88584:81285", -- [17]
			"81354:84515:84498:82612", -- [18]
			"81057:82346:83924", -- [19]
			"81057:82346:82844", -- [20]
			"81057:82346", -- [21]
			"81057:82346:82340", -- [22]
			"81354:84515:84498", -- [23]
			"81354:84515:84504", -- [24]
			"81354:84515:82511", -- [25]
			"90552:84508", -- [26]
			"81354:81078:84509", -- [27]
			"90552:84508:84495", -- [28]
			"81354:84515", -- [29]
			"90552:84508:81055:86492", -- [30]
			"90552:84508:81055:84700", -- [31]
			"81057:83427", -- [32]
			"90552:84508:81055:85829", -- [33]
			"90552:84508:84495:76784:87707", -- [34]
			"92809:92808:84714", -- [35]
			"81354:88584", -- [36]
			"81057:82346:82340:87395", -- [37]
			"81057:82346:83924:88653", -- [38]
			"81057:82346:82844:88668", -- [39]
			"92809:92808:84714:88757", -- [40]
			"90562:90550", -- [41]
			"92809:92808", -- [42]
			--["name"] = "Zangarra, Talador",
			["m"] = 535,
			["f"] = 0,
			["direct"] = "81057:81354:90560:90552:90562:92809",
			["coord"] = 3452649745,
		},
		[84714] = {
			"92808:90562:76850", -- [1]
			"86492:76784:79407:76782", -- [2]
			"85829:76787:76781", -- [3]
			"85829:76787:76783", -- [4]
			"85829:76787", -- [5]
			"86492:76784:76879", -- [6]
			"86492:76784", -- [7]
			"86492:76784:87707:78699", -- [8]
			"86492:76784:79407", -- [9]
			"92808:92809:80932", -- [10]
			"81055:84508:81053", -- [11]
			"81055:81057", -- [12]
			"81055:84508:81053:81058", -- [13]
			"86492:76784:81064", -- [14]
			"86492:76784:81064:81068", -- [15]
			"86492:76784:81064:81078", -- [16]
			"81055:81057:81354", -- [17]
			"92808:90562:76850:81285", -- [18]
			"81055:81057:82612", -- [19]
			"81055:84508:81053:82346:83924", -- [20]
			"86492:76784:79407:82844", -- [21]
			"81055:84508:81053:82346", -- [22]
			"86492:76784:79407:82844:82340", -- [23]
			"81055:81057:81354:84515:84498", -- [24]
			"81055:81057:81354:84515:84504", -- [25]
			"81055:81057:81354:84515:82511", -- [26]
			"81055:84508", -- [27]
			"86492:76784:81064:81078:84509", -- [28]
			"81055:84495", -- [29]
			"81055:81057:81354:84515", -- [30]
			"92808:90562:76850:83427", -- [31]
			"86492:76784:87707", -- [32]
			"81055:81057:81354:88584", -- [33]
			"86492:76784:79407:87395", -- [34]
			"81055:84508:81053:82346:83924:88653", -- [35]
			"86492:76784:79407:88668", -- [36]
			"92808:90550", -- [37]
			"92808:90560", -- [38]
			"81055:84508:90552", -- [39]
			"92808:90562", -- [40]
			"92808:92809", -- [41]
			--["name"] = "Everbloom Wilds, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "86049:81055:86492:84700:85829:88757:92808",
			["coord"] = 2448848193,
		},
		[81064] = {
			"81078:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"76787:76783", -- [4]
			"79407:76879", -- [5]
			"79407:78699", -- [6]
			"81057:80932", -- [7]
			"81058:81053", -- [8]
			"81058:81053:84495:81055", -- [9]
			"88584:81285", -- [10]
			"82346:82844", -- [11]
			"82346:82340", -- [12]
			"81078:84509:84498", -- [13]
			"81078:84509:84515:84504", -- [14]
			"81078:84509:84498:82511", -- [15]
			"81058:81053:84508", -- [16]
			"81058:81053:84495", -- [17]
			"81078:84509:84515", -- [18]
			"76784:86492", -- [19]
			"76784:85829:84700", -- [20]
			"88584:81285:83427", -- [21]
			"76784:85829", -- [22]
			"76784:87707", -- [23]
			"76784:86492:84714", -- [24]
			"82346:82340:87395", -- [25]
			"82346:83924:88653", -- [26]
			"82346:82844:88668", -- [27]
			"76784:86492:84714:88757", -- [28]
			"81057:90552:90550", -- [29]
			"81057:90552:90560", -- [30]
			"81057:90552", -- [31]
			"81057:80932:90562", -- [32]
			"81057:80932:92809:92808", -- [33]
			"81057:80932:92809", -- [34]
			--["name"] = "Shattrath City, Talador",
			["m"] = 535,
			["coord"] = 2201709926,
			["direct"] = "76787:76784:86049:79407:81057:81058:81068:81078:81354:82612:83924:82346:84509:88584",
			["f"] = 0,
		},
		[81068] = {
			"81078:76850", -- [1]
			"83924:82844:79407:76782", -- [2]
			"83924:82844:79407:76781", -- [3]
			"81078:81064:76787:76783", -- [4]
			"81078:81064:76787", -- [5]
			"83924:82844:79407:76879", -- [6]
			"81078:81064:76784", -- [7]
			"83924:82844:79407:78699", -- [8]
			"81078:81354:80932:90562:90550:86049", -- [9]
			"83924:82844:79407", -- [10]
			"81078:81354:80932", -- [11]
			"81078:81058:81053", -- [12]
			"81078:81354:81057:84495:81055", -- [13]
			"81078:81354:81057", -- [14]
			"81078:81058", -- [15]
			"81078:81354", -- [16]
			"84509:84515:84504:81285", -- [17]
			"84509:82612", -- [18]
			"83924:82844", -- [19]
			"83924:82346", -- [20]
			"83924:82340", -- [21]
			"84509:84498", -- [22]
			"84509:84515:84504", -- [23]
			"84509:84498:82511", -- [24]
			"81078:81354:81057:84508", -- [25]
			"81078:81354:81057:84495", -- [26]
			"84509:84515", -- [27]
			"81078:81064:76784:86492", -- [28]
			"81078:81064:76784:85829:84700", -- [29]
			"84509:84515:84504:81285:83427", -- [30]
			"81078:81064:76784:85829", -- [31]
			"81078:81064:76784:87707", -- [32]
			"81078:81064:76784:86492:84714", -- [33]
			"81078:88584", -- [34]
			"83924:82340:87395", -- [35]
			"83924:88653", -- [36]
			"83924:82844:88668", -- [37]
			"81078:81064:76784:86492:84714:88757", -- [38]
			"81078:81354:80932:90562:90550", -- [39]
			"81078:81354:80932:90560", -- [40]
			"81078:81354:81057:90552", -- [41]
			"81078:81354:80932:90562", -- [42]
			"81078:81354:80932:92809:92808", -- [43]
			"81078:81354:80932:92809", -- [44]
			--["name"] = "Retribution Point, Talador",
			["m"] = 535,
			["coord"] = 1810089110,
			["direct"] = "81064:81078:83924:84509",
			["f"] = 0,
		},
		[86049] = {
			"79407:76782", -- [1]
			"79407:76781", -- [2]
			"85829:76787:76783", -- [3]
			"85829:76787", -- [4]
			"79407:76879", -- [5]
			"81055:76784", -- [6]
			"81055:76784:87707:78699", -- [7]
			"90550:90562:80932", -- [8]
			"84508:81053", -- [9]
			"84508:81053:81058", -- [10]
			"81064:81068", -- [11]
			"81064:81078", -- [12]
			"90550:90562:80932:81354", -- [13]
			"88584:82612", -- [14]
			"84508:81053:82346:83924", -- [15]
			"84508:81053:82346:82844", -- [16]
			"84508:81053:82346", -- [17]
			"84508:81053:82346:82340", -- [18]
			"88584:84515:84498", -- [19]
			"88584:84504", -- [20]
			"88584:82511", -- [21]
			"88584:84515:84509", -- [22]
			"88584:84515", -- [23]
			"84714:86492", -- [24]
			"84714:84700", -- [25]
			"81055:76784:87707", -- [26]
			"79407:87395", -- [27]
			"84508:81053:82346:83924:88653", -- [28]
			"84508:81053:82346:82844:88668", -- [29]
			"84714:88757", -- [30]
			"90550:90560", -- [31]
			"90550:90552", -- [32]
			"90550:90562", -- [33]
			"90550:92808", -- [34]
			"90550:92808:92809", -- [35]
			--["name"] = "Warspear, Ashran",
			["m"] = 624,
			["f"] = 0,
			["direct"] = "76850:79407:81055:81057:81064:81285:84508:84495:83427:85829:84714:88584:90550",
			["coord"] = 1893095686,
		},
		[82612] = {
			"88584:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"79407:78699:76783", -- [4]
			"81064:76787", -- [5]
			"79407:76879", -- [6]
			"81064:76784", -- [7]
			"79407:78699", -- [8]
			"88584:86049", -- [9]
			"84515:81354:80932", -- [10]
			"81057:81053", -- [11]
			"81057:84495:81055", -- [12]
			"81064:81058", -- [13]
			"84509:81068", -- [14]
			"84509:81078", -- [15]
			"84515:81354", -- [16]
			"82346:83924", -- [17]
			"82346:82844", -- [18]
			"84498:84504", -- [19]
			"84498:82511", -- [20]
			"81057:84508", -- [21]
			"81057:84495", -- [22]
			"81064:76784:86492", -- [23]
			"81064:76784:85829:84700", -- [24]
			"81285:83427", -- [25]
			"81064:76784:85829", -- [26]
			"81064:76784:87707", -- [27]
			"81064:76784:86492:84714", -- [28]
			"88653:82340:87395", -- [29]
			"88653:88668", -- [30]
			"81064:76784:86492:84714:88757", -- [31]
			"88584:76850:90562:90550", -- [32]
			"84515:81354:80932:90560", -- [33]
			"81057:90552", -- [34]
			"88584:76850:90562", -- [35]
			"84515:81354:80932:92809:92808", -- [36]
			"84515:81354:80932:92809", -- [37]
			--["name"] = "Axefall, Spires of Arak",
			["m"] = 542,
			["coord"] = 1694068478,
			["direct"] = "79407:81057:81064:81285:82346:82340:84498:84509:84515:88584:88653",
			["f"] = 0,
		},
		[82844] = {
			"83924:81064:81078:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"79407:78699:76783", -- [4]
			"79407:76879", -- [5]
			"79407:76784", -- [6]
			"79407:78699", -- [7]
			"79407:86049", -- [8]
			"82346:81057:80932", -- [9]
			"82346:81053", -- [10]
			"79407:81055", -- [11]
			"82346:81057", -- [12]
			"82346:81058", -- [13]
			"83924:81064", -- [14]
			"83924:81068", -- [15]
			"83924:81064:81078", -- [16]
			"83924:81064:81354", -- [17]
			"83924:81068:84509:84515:84504:81285", -- [18]
			"83924:81068:84509:82612", -- [19]
			"83924:81068:84509:84498", -- [20]
			"83924:81068:84509:84515:84504", -- [21]
			"83924:81068:84509:84498:82511", -- [22]
			"82346:81053:84508", -- [23]
			"83924:81068:84509", -- [24]
			"82346:81053:84495", -- [25]
			"83924:81068:84509:84515", -- [26]
			"79407:76784:86492", -- [27]
			"79407:76784:85829:84700", -- [28]
			"83924:81068:84509:84515:84504:81285:83427", -- [29]
			"79407:76784:85829", -- [30]
			"79407:87707", -- [31]
			"79407:76784:86492:84714", -- [32]
			"83924:81064:88584", -- [33]
			"88668:87395", -- [34]
			"88668:88653", -- [35]
			"79407:76784:86492:84714:88757", -- [36]
			"82346:81053:90552:90550", -- [37]
			"82346:81053:90552:90560", -- [38]
			"82346:81053:90552", -- [39]
			"82346:81053:90552:90562", -- [40]
			"82346:81053:90552:92809:92808", -- [41]
			"82346:81053:90552:92809", -- [42]
			--["name"] = "Throne of the Elements, Nagrand",
			["m"] = 550,
			["f"] = 0,
			["direct"] = "76787:79407:83924:82346:82340:88668",
			["coord"] = 3163571228,
		},
		[78699] = {
			"79407:81057:81354:76850", -- [1]
			"76879:76782", -- [2]
			"76879:76781", -- [3]
			"87707:76784", -- [4]
			"79407:86049", -- [5]
			"79407:81057:80932", -- [6]
			"79407:81053", -- [7]
			"87707:76784:81055", -- [8]
			"79407:81057", -- [9]
			"79407:81053:81058", -- [10]
			"79407:81064", -- [11]
			"79407:81064:81068", -- [12]
			"79407:81064:81078", -- [13]
			"79407:81057:81354", -- [14]
			"79407:81064:88584:81285", -- [15]
			"79407:82612", -- [16]
			"79407:82346:83924", -- [17]
			"79407:82844", -- [18]
			"79407:82346", -- [19]
			"79407:82844:82340", -- [20]
			"79407:81064:81078:84509:84498", -- [21]
			"79407:81064:81078:84509:84515:84504", -- [22]
			"79407:82511", -- [23]
			"79407:81053:84508", -- [24]
			"79407:81064:81078:84509", -- [25]
			"87707:76784:84495", -- [26]
			"79407:81064:81078:84509:84515", -- [27]
			"87707:76784:86492", -- [28]
			"76787:85829:84700", -- [29]
			"79407:81057:83427", -- [30]
			"76787:85829", -- [31]
			"87707:76784:86492:84714", -- [32]
			"79407:81064:88584", -- [33]
			"79407:87395", -- [34]
			"79407:88668:88653", -- [35]
			"79407:88668", -- [36]
			"87707:76784:86492:84714:88757", -- [37]
			"79407:81053:90552:90550", -- [38]
			"79407:81053:90552:90560", -- [39]
			"79407:81053:90552", -- [40]
			"79407:81053:90552:90562", -- [41]
			"79407:81053:90552:92809:92808", -- [42]
			"79407:81053:90552:92809", -- [43]
			--["name"] = "Darkspear's Edge, Frostfire Ridge",
			["m"] = 525,
			["coord"] = 2222156076,
			["direct"] = "76783:76787:76879:79407:87707",
			["f"] = 0,
		},
		[79407] = {
			"81057:81354:76850", -- [1]
			"78699:76783", -- [2]
			"81057:80932", -- [3]
			"81053:81058", -- [4]
			"81064:81068", -- [5]
			"81064:81078", -- [6]
			"81057:81354", -- [7]
			"81064:88584:81285", -- [8]
			"82346:83924", -- [9]
			"81064:81078:84509:84498", -- [10]
			"81064:81078:84509:84515:84504", -- [11]
			"81053:84508", -- [12]
			"76784:84495", -- [13]
			"81064:81078:84509:84515", -- [14]
			"76784:86492", -- [15]
			"76784:85829:84700", -- [16]
			"81057:83427", -- [17]
			"76784:85829", -- [18]
			"76784:86492:84714", -- [19]
			"81064:88584", -- [20]
			"88668:88653", -- [21]
			"76784:86492:84714:88757", -- [22]
			"81053:90552:90550", -- [23]
			"81053:90552:90560", -- [24]
			"81053:90552", -- [25]
			"81053:90552:90562", -- [26]
			"81053:90552:92809:92808", -- [27]
			"81053:90552:92809", -- [28]
			["direct"] = "76782:76781:76787:76879:76784:78699:86049:81053:81055:81057:81064:82612:82844:82346:82340:82511:84509:87707:87395:88668",
			["m"] = 590,
			--["name"] = "Frostwall Garrison, Frostfire Ridge",
			["f"] = 0,
		},
		[87707] = {
			"76784:81057:81354:76850", -- [1]
			"79407:76782", -- [2]
			"78699:76879:76781", -- [3]
			"78699:76783", -- [4]
			"78699:76787", -- [5]
			"78699:76879", -- [6]
			"76784:81055:86049", -- [7]
			"76784:81057:80932", -- [8]
			"79407:81053", -- [9]
			"76784:81055", -- [10]
			"76784:81057", -- [11]
			"76784:81064:81058", -- [12]
			"76784:81064", -- [13]
			"76784:81064:81068", -- [14]
			"76784:81064:81078", -- [15]
			"76784:81057:81354", -- [16]
			"76784:81057:81285", -- [17]
			"76784:81057:82612", -- [18]
			"79407:82346:83924", -- [19]
			"79407:82844", -- [20]
			"79407:82346", -- [21]
			"79407:82844:82340", -- [22]
			"76784:81057:81354:84515:84498", -- [23]
			"76784:81057:81354:84515:84504", -- [24]
			"76784:81057:81354:84515:82511", -- [25]
			"76784:81055:84508", -- [26]
			"76784:81064:81078:84509", -- [27]
			"76784:84495", -- [28]
			"76784:81057:81354:84515", -- [29]
			"76784:86492", -- [30]
			"76784:85829:84700", -- [31]
			"76784:81057:83427", -- [32]
			"76784:85829", -- [33]
			"76784:86492:84714", -- [34]
			"76784:81057:81354:88584", -- [35]
			"79407:87395", -- [36]
			"79407:88668:88653", -- [37]
			"79407:88668", -- [38]
			"76784:86492:84714:88757", -- [39]
			"76784:81055:84508:90560:90550", -- [40]
			"76784:81055:84508:90560", -- [41]
			"76784:81055:84508:90552", -- [42]
			"76784:81055:84508:90552:90562", -- [43]
			"76784:81055:84508:90560:92808", -- [44]
			"76784:81055:84508:90552:92809", -- [45]
			--["name"] = "Wolf's Stand, Frostfire Ridge",
			["m"] = 525,
			["f"] = 0,
			["direct"] = "76784:78699:79407",
			["coord"] = 3162347895,
		},
		[84498] = {
			"84504:76850", -- [1]
			"82612:79407:76782", -- [2]
			"82612:79407:76781", -- [3]
			"82612:79407:78699:76783", -- [4]
			"84509:81078:81064:76787", -- [5]
			"82612:79407:76879", -- [6]
			"84509:81078:81064:76784", -- [7]
			"82612:79407:78699", -- [8]
			"84504:76850:86049", -- [9]
			"82612:79407", -- [10]
			"84504:88584:81354:80932", -- [11]
			"82612:81057:81053", -- [12]
			"82612:81057:84495:81055", -- [13]
			"82612:81057", -- [14]
			"84509:81078:81058", -- [15]
			"84509:81078:81064", -- [16]
			"84509:81068", -- [17]
			"84509:81078", -- [18]
			"84504:88584:81354", -- [19]
			"84504:81285", -- [20]
			"84509:81068:83924", -- [21]
			"82612:82346:82844", -- [22]
			"82612:82346", -- [23]
			"82612:88653:82340", -- [24]
			"82612:81057:84508", -- [25]
			"82612:81057:84495", -- [26]
			"84509:81078:81064:76784:86492", -- [27]
			"84509:81078:81064:76784:85829:84700", -- [28]
			"84504:81285:83427", -- [29]
			"84509:81078:81064:76784:85829", -- [30]
			"84509:81078:81064:76784:87707", -- [31]
			"84509:81078:81064:76784:86492:84714", -- [32]
			"84504:88584", -- [33]
			"82612:88653:82340:87395", -- [34]
			"82612:88653", -- [35]
			"82612:88653:88668", -- [36]
			"84509:81078:81064:76784:86492:84714:88757", -- [37]
			"84504:76850:90562:90550", -- [38]
			"84504:88584:81354:80932:90560", -- [39]
			"82612:81057:90552", -- [40]
			"84504:76850:90562", -- [41]
			"84504:76850:90562:92808", -- [42]
			"84504:88584:81354:80932:92809", -- [43]
			--["name"] = "Veil Terokk, Spires of Arak",
			["m"] = 542,
			["coord"] = 1985114355,
			["direct"] = "82612:84504:82511:84509:84515",
			["f"] = 0,
		},
		[76879] = {
			"79407:81057:81354:76850", -- [1]
			"78699:76783", -- [2]
			"78699:76787", -- [3]
			"79407:86049", -- [4]
			"79407:81057:80932", -- [5]
			"79407:81053", -- [6]
			"76784:81055", -- [7]
			"79407:81057", -- [8]
			"79407:81053:81058", -- [9]
			"79407:81064", -- [10]
			"79407:81064:81068", -- [11]
			"79407:81064:81078", -- [12]
			"79407:81057:81354", -- [13]
			"79407:81064:88584:81285", -- [14]
			"79407:82612", -- [15]
			"79407:82346:83924", -- [16]
			"79407:82844", -- [17]
			"79407:82346", -- [18]
			"79407:82844:82340", -- [19]
			"79407:81064:81078:84509:84498", -- [20]
			"79407:81064:81078:84509:84515:84504", -- [21]
			"79407:82511", -- [22]
			"79407:81053:84508", -- [23]
			"79407:81064:81078:84509", -- [24]
			"76784:84495", -- [25]
			"79407:81064:81078:84509:84515", -- [26]
			"76784:86492", -- [27]
			"78699:76787:85829:84700", -- [28]
			"79407:81057:83427", -- [29]
			"78699:76787:85829", -- [30]
			"78699:87707", -- [31]
			"76784:86492:84714", -- [32]
			"79407:81064:88584", -- [33]
			"79407:87395", -- [34]
			"79407:88668:88653", -- [35]
			"79407:88668", -- [36]
			"76784:86492:84714:88757", -- [37]
			"79407:81053:90552:90550", -- [38]
			"79407:81053:90552:90560", -- [39]
			"79407:81053:90552", -- [40]
			"79407:81053:90552:90562", -- [41]
			"79407:81053:90552:92809:92808", -- [42]
			"79407:81053:90552:92809", -- [43]
			--["name"] = "Stonefang Outpost, Frostfire Ridge",
			["m"] = 525,
			["coord"] = 1723630835,
			["direct"] = "76782:76781:76784:78699:79407",
			["f"] = 0,
		},
		[85829] = {
			"84714:92808:90562:76850", -- [1]
			"76787:76781:76782", -- [2]
			"76787:76781", -- [3]
			"76787:76783", -- [4]
			"76787:78699:76879", -- [5]
			"76787:78699", -- [6]
			"76784:79407", -- [7]
			"81055:84508:90552:80932", -- [8]
			"81055:84508:81053", -- [9]
			"76784:81057", -- [10]
			"76784:81064:81058", -- [11]
			"76784:81064", -- [12]
			"76784:81064:81068", -- [13]
			"76784:81064:81078", -- [14]
			"76784:81057:81354", -- [15]
			"76784:81057:81285", -- [16]
			"76784:81057:82612", -- [17]
			"76784:79407:82346:83924", -- [18]
			"76784:79407:82844", -- [19]
			"76784:79407:82346", -- [20]
			"76784:79407:82844:82340", -- [21]
			"76784:81057:81354:84515:84498", -- [22]
			"76784:81057:81354:84515:84504", -- [23]
			"76784:81057:81354:84515:82511", -- [24]
			"81055:84508", -- [25]
			"76784:81064:81078:84509", -- [26]
			"76784:81057:81354:84515", -- [27]
			"76784:81057:83427", -- [28]
			"76784:87707", -- [29]
			"76784:81057:81354:88584", -- [30]
			"76787:87395", -- [31]
			"76787:87395:88653", -- [32]
			"76784:79407:88668", -- [33]
			"84714:88757", -- [34]
			"84714:92808:90550", -- [35]
			"81055:84508:90560", -- [36]
			"81055:84508:90552", -- [37]
			"84714:92808:90562", -- [38]
			"84714:92808", -- [39]
			"81055:84508:90552:92809", -- [40]
			--["name"] = "Skysea Ridge, Gorgrond",
			["m"] = 543,
			["coord"] = 1700486562,
			["direct"] = "76787:76784:86049:81055:84495:86492:84700:84714",
			["f"] = 0,
		},
		[88668] = {
			"82844:83924:81064:81078:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"79407:78699:76783", -- [4]
			"79407:76787", -- [5]
			"79407:76879", -- [6]
			"79407:76784", -- [7]
			"79407:78699", -- [8]
			"79407:86049", -- [9]
			"82844:82346:81057:80932", -- [10]
			"82844:82346:81053", -- [11]
			"79407:81055", -- [12]
			"82844:82346:81057", -- [13]
			"82844:82346:81058", -- [14]
			"82844:83924:81064", -- [15]
			"82844:83924:81068", -- [16]
			"82844:83924:81064:81078", -- [17]
			"82844:83924:81064:81354", -- [18]
			"82844:83924:81068:84509:84515:84504:81285", -- [19]
			"82844:83924:81068:84509:82612", -- [20]
			"82844:82346", -- [21]
			"82844:83924:81068:84509:84498", -- [22]
			"82844:83924:81068:84509:84515:84504", -- [23]
			"82844:83924:81068:84509:84498:82511", -- [24]
			"82844:82346:81053:84508", -- [25]
			"82844:83924:81068:84509", -- [26]
			"82844:82346:81053:84495", -- [27]
			"82844:83924:81068:84509:84515", -- [28]
			"79407:76784:86492", -- [29]
			"79407:76784:85829:84700", -- [30]
			"82844:83924:81068:84509:84515:84504:81285:83427", -- [31]
			"79407:76784:85829", -- [32]
			"79407:87707", -- [33]
			"79407:76784:86492:84714", -- [34]
			"82844:83924:81064:88584", -- [35]
			"79407:76784:86492:84714:88757", -- [36]
			"82844:82346:81053:90552:90550", -- [37]
			"82844:82346:81053:90552:90560", -- [38]
			"82844:82346:81053:90552", -- [39]
			"82844:82346:81053:90552:90562", -- [40]
			"82844:82346:81053:90552:92809:92808", -- [41]
			"82844:82346:81053:90552:92809", -- [42]
			--["name"] = "Joz's Rylaks, Nagrand",
			["m"] = 550,
			["f"] = 0,
			["direct"] = "79407:83924:82844:82340:87395:88653",
			["coord"] = 2673169503,
		},
		[90562] = {
			"90552:81053:79407:76782", -- [1]
			"92809:90560:84508:84495:76784:76879:76781", -- [2]
			"92809:90560:84508:84495:76784:76787:76783", -- [3]
			"92809:90560:84508:84495:76784:76787", -- [4]
			"92809:90560:84508:84495:76784:76879", -- [5]
			"92809:90560:84508:84495:76784", -- [6]
			"92809:90560:84508:84495:76784:87707:78699", -- [7]
			"90550:86049", -- [8]
			"90552:81053:79407", -- [9]
			"90552:81053", -- [10]
			"92809:90560:84508:81055", -- [11]
			"80932:81057", -- [12]
			"80932:81057:81058", -- [13]
			"80932:81057:81058:81064", -- [14]
			"80932:81354:81078:81068", -- [15]
			"80932:81354:81078", -- [16]
			"80932:81354", -- [17]
			"76850:81285", -- [18]
			"76850:88584:82612", -- [19]
			"90552:81053:82346:83924", -- [20]
			"90552:81053:82346:82844", -- [21]
			"90552:81053:82346", -- [22]
			"90552:81053:82346:82340", -- [23]
			"76850:88584:84515:84498", -- [24]
			"76850:84504", -- [25]
			"76850:84504:82511", -- [26]
			"92809:90560:84508", -- [27]
			"80932:81354:81078:84509", -- [28]
			"92809:90560:84508:84495", -- [29]
			"76850:88584:84515", -- [30]
			"92809:90560:84508:81055:86492", -- [31]
			"92808:84714:84700", -- [32]
			"76850:83427", -- [33]
			"92808:84714:85829", -- [34]
			"92809:90560:84508:84495:76784:87707", -- [35]
			"92808:84714", -- [36]
			"76850:88584", -- [37]
			"90552:81053:82346:82340:87395", -- [38]
			"90552:81053:82346:83924:88653", -- [39]
			"90552:81053:82346:82844:88668", -- [40]
			"92808:84714:88757", -- [41]
			--["name"] = "Vault of the Earth, Tanaan Jungle",
			["m"] = 534,
			["f"] = 0,
			["direct"] = "76850:80932:90550:90560:90552:92808:92809",
			["coord"] = 2021438409,
		},
		[81053] = {
			"90552:90562:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"84495:76784:76787:76783", -- [4]
			"84495:76784:76787", -- [5]
			"79407:76879", -- [6]
			"84495:76784", -- [7]
			"79407:78699", -- [8]
			"90552:90550:86049", -- [9]
			"90552:80932", -- [10]
			"84495:81055", -- [11]
			"81058:81064", -- [12]
			"81058:81064:81068", -- [13]
			"81058:81078", -- [14]
			"81057:81354", -- [15]
			"81058:81064:88584:81285", -- [16]
			"81058:81078:84509:82612", -- [17]
			"82346:83924", -- [18]
			"82346:82844", -- [19]
			"82346:82340", -- [20]
			"81058:81078:84509:84498", -- [21]
			"81058:81078:84509:84515:84504", -- [22]
			"81058:81078:84509:84498:82511", -- [23]
			"81058:81078:84509", -- [24]
			"81058:81078:84509:84515", -- [25]
			"84495:81055:86492", -- [26]
			"84495:81055:84700", -- [27]
			"81057:83427", -- [28]
			"84495:85829", -- [29]
			"84495:76784:87707", -- [30]
			"84495:81055:84714", -- [31]
			"81058:81064:88584", -- [32]
			"82346:82340:87395", -- [33]
			"82346:83924:88653", -- [34]
			"82346:82844:88668", -- [35]
			"84495:81055:84714:88757", -- [36]
			"90552:90550", -- [37]
			"90552:90560", -- [38]
			"90552:90562", -- [39]
			"90552:92809:92808", -- [40]
			"90552:92809", -- [41]
			--["name"] = "Frostwolf Overlook, Talador",
			["m"] = 535,
			["f"] = 0,
			["direct"] = "79407:81057:81058:82346:84508:84495:90552",
			["coord"] = 2641042192,
		},
		[81057] = {
			"81354:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76781", -- [3]
			"76784:76787:76783", -- [4]
			"76784:76787", -- [5]
			"79407:76879", -- [6]
			"76784:87707:78699", -- [7]
			"81058:81064:81068", -- [8]
			"81058:81078", -- [9]
			"82346:83924", -- [10]
			"82346:82844", -- [11]
			"82346:82340", -- [12]
			"81354:84515:84498", -- [13]
			"81354:84515:84504", -- [14]
			"81354:84515:82511", -- [15]
			"81058:81078:84509", -- [16]
			"84495:81055:86492", -- [17]
			"84495:81055:84700", -- [18]
			"84495:85829", -- [19]
			"76784:87707", -- [20]
			"84495:81055:84714", -- [21]
			"82346:82340:87395", -- [22]
			"82346:83924:88653", -- [23]
			"82346:82844:88668", -- [24]
			"84495:81055:84714:88757", -- [25]
			"90552:90550", -- [26]
			"90552:90560", -- [27]
			"80932:90562", -- [28]
			"80932:92809:92808", -- [29]
			"80932:92809", -- [30]
			--["name"] = "Vol'jin's Pride, Talador",
			["direct"] = "76784:86049:79407:80932:81053:81055:81058:81064:81354:81285:82612:82346:84508:84495:84515:83427:88584:90552",
			["f"] = 0,
			["m"] = 535,
			["coord"] = 3040365391,
		},
		[76784] = {
			"81057:81354:76850", -- [1]
			"79407:76782", -- [2]
			"76879:76781", -- [3]
			"76787:76783", -- [4]
			"87707:78699", -- [5]
			"81055:86049", -- [6]
			"81057:80932", -- [7]
			"84495:81053", -- [8]
			"81064:81058", -- [9]
			"81064:81068", -- [10]
			"81064:81078", -- [11]
			"81057:81354", -- [12]
			"81057:81285", -- [13]
			"81057:82612", -- [14]
			"79407:82346:83924", -- [15]
			"79407:82844", -- [16]
			"79407:82346", -- [17]
			"79407:82844:82340", -- [18]
			"81057:81354:84515:84498", -- [19]
			"81057:81354:84515:84504", -- [20]
			"81057:81354:84515:82511", -- [21]
			"81055:84508", -- [22]
			"81064:81078:84509", -- [23]
			"81057:81354:84515", -- [24]
			"85829:84700", -- [25]
			"81057:83427", -- [26]
			"86492:84714", -- [27]
			"81057:81354:88584", -- [28]
			"79407:87395", -- [29]
			"79407:88668:88653", -- [30]
			"79407:88668", -- [31]
			"86492:84714:88757", -- [32]
			"81055:84508:90560:90550", -- [33]
			"81055:84508:90560", -- [34]
			"81055:84508:90552", -- [35]
			"81055:84508:90552:90562", -- [36]
			"81055:84508:90560:92808", -- [37]
			"81055:84508:90552:92809", -- [38]
			--["name"] = "Thunder Pass, Frostfire Ridge",
			["m"] = 525,
			["coord"] = 3590298597,
			["direct"] = "76787:76879:79407:81055:81057:81064:84495:86492:85829:87707",
			["f"] = 0,
		},
		[76781] = {
			"79407:81057:81354:76850", -- [1]
			"76879:76784", -- [2]
			"76879:78699", -- [3]
			"79407:86049", -- [4]
			"79407:81057:80932", -- [5]
			"79407:81053", -- [6]
			"79407:81055", -- [7]
			"79407:81057", -- [8]
			"79407:81053:81058", -- [9]
			"79407:81064", -- [10]
			"79407:81064:81068", -- [11]
			"79407:81064:81078", -- [12]
			"79407:81057:81354", -- [13]
			"79407:81064:88584:81285", -- [14]
			"79407:82612", -- [15]
			"79407:82346:83924", -- [16]
			"79407:82844", -- [17]
			"79407:82346", -- [18]
			"79407:82844:82340", -- [19]
			"79407:81064:81078:84509:84498", -- [20]
			"79407:81064:81078:84509:84515:84504", -- [21]
			"79407:82511", -- [22]
			"79407:81053:84508", -- [23]
			"79407:81064:81078:84509", -- [24]
			"76879:76784:84495", -- [25]
			"79407:81064:81078:84509:84515", -- [26]
			"76879:76784:86492", -- [27]
			"76787:85829:84700", -- [28]
			"79407:81057:83427", -- [29]
			"76787:85829", -- [30]
			"79407:87707", -- [31]
			"76879:76784:86492:84714", -- [32]
			"79407:81064:88584", -- [33]
			"79407:87395", -- [34]
			"79407:88668:88653", -- [35]
			"79407:88668", -- [36]
			"76879:76784:86492:84714:88757", -- [37]
			"79407:81053:90552:90550", -- [38]
			"79407:81053:90552:90560", -- [39]
			"79407:81053:90552", -- [40]
			"79407:81053:90552:90562", -- [41]
			"79407:81053:90552:92809:92808", -- [42]
			"79407:81053:90552:92809", -- [43]
			--["name"] = "Bladespire Citadel, Frostfire Ridge",
			["m"] = 526,
			["coord"] = 870286654,
			["direct"] = "76782:76783:76787:76879:79407",
			["f"] = 0,
		},
		[82340] = {
			"83924:81064:81078:76850", -- [1]
			"88668:79407:76782", -- [2]
			"88668:79407:76781", -- [3]
			"88668:79407:78699:76783", -- [4]
			"88668:79407:76787", -- [5]
			"88668:79407:76879", -- [6]
			"88668:79407:76784", -- [7]
			"88668:79407:78699", -- [8]
			"82346:81053:90552:90550:86049", -- [9]
			"82346:81057:80932", -- [10]
			"82346:81053", -- [11]
			"88668:79407:81055", -- [12]
			"82346:81057", -- [13]
			"82346:81058", -- [14]
			"83924:81064", -- [15]
			"83924:81068", -- [16]
			"83924:81064:81078", -- [17]
			"83924:81064:81354", -- [18]
			"88653:82612:81285", -- [19]
			"88653:82612:84498", -- [20]
			"83924:81068:84509:84515:84504", -- [21]
			"88653:82612:84498:82511", -- [22]
			"82346:81053:84508", -- [23]
			"83924:81068:84509", -- [24]
			"82346:81053:84495", -- [25]
			"83924:81068:84509:84515", -- [26]
			"88668:79407:76784:86492", -- [27]
			"88668:79407:76784:85829:84700", -- [28]
			"88653:82612:81285:83427", -- [29]
			"88668:79407:76784:85829", -- [30]
			"88668:79407:87707", -- [31]
			"88668:79407:76784:86492:84714", -- [32]
			"83924:81064:88584", -- [33]
			"88668:79407:76784:86492:84714:88757", -- [34]
			"82346:81053:90552:90550", -- [35]
			"82346:81053:90552:90560", -- [36]
			"82346:81053:90552", -- [37]
			"82346:81053:90552:90562", -- [38]
			"82346:81053:90552:92809:92808", -- [39]
			"82346:81053:90552:92809", -- [40]
			--["name"] = "Riverside Post, Nagrand",
			["m"] = 550,
			["f"] = 0,
			["direct"] = "79407:82612:83924:82844:82346:87395:88653:88668",
			["coord"] = 2125101864,
		},
		[90552] = {
			"90562:76850", -- [1]
			"81053:79407:76782", -- [2]
			"81053:79407:76781", -- [3]
			"84508:84495:76784:76787:76783", -- [4]
			"84508:84495:76784:76787", -- [5]
			"84508:84495:76784:76879", -- [6]
			"84508:84495:76784", -- [7]
			"84508:84495:76784:87707:78699", -- [8]
			"90550:86049", -- [9]
			"81053:79407", -- [10]
			"84508:81055", -- [11]
			"81053:81058", -- [12]
			"81053:81058:81064", -- [13]
			"81053:81058:81064:81068", -- [14]
			"81053:81058:81078", -- [15]
			"81057:81354", -- [16]
			"81057:81285", -- [17]
			"81057:82612", -- [18]
			"81053:82346:83924", -- [19]
			"81053:82346:82844", -- [20]
			"81053:82346", -- [21]
			"81053:82346:82340", -- [22]
			"81057:81354:84515:84498", -- [23]
			"81057:81354:84515:84504", -- [24]
			"81057:81354:84515:82511", -- [25]
			"81053:81058:81078:84509", -- [26]
			"84508:84495", -- [27]
			"81057:81354:84515", -- [28]
			"84508:81055:86492", -- [29]
			"84508:81055:84700", -- [30]
			"81057:83427", -- [31]
			"84508:81055:85829", -- [32]
			"84508:84495:76784:87707", -- [33]
			"84508:81055:84714", -- [34]
			"81057:81354:88584", -- [35]
			"81053:82346:82340:87395", -- [36]
			"81053:82346:83924:88653", -- [37]
			"81053:82346:82844:88668", -- [38]
			"84508:81055:84714:88757", -- [39]
			"92809:92808", -- [40]
			--["name"] = "The Iron Front, Tanaan Jungle",
			["m"] = 534,
			["f"] = 0,
			["direct"] = "80932:81053:81057:84508:90550:90560:90562:92809",
			["coord"] = 398823228,
		},
		[88653] = {
			"83924:81064:81078:76850", -- [1]
			"88668:79407:76782", -- [2]
			"88668:79407:76781", -- [3]
			"88668:79407:78699:76783", -- [4]
			"88668:79407:76787", -- [5]
			"88668:79407:76879", -- [6]
			"88668:79407:76784", -- [7]
			"88668:79407:78699", -- [8]
			"83924:82346:81053:90552:90550:86049", -- [9]
			"88668:79407", -- [10]
			"83924:82346:81057:80932", -- [11]
			"83924:82346:81053", -- [12]
			"83924:82346:81055", -- [13]
			"83924:82346:81057", -- [14]
			"83924:81064:81058", -- [15]
			"83924:81064", -- [16]
			"83924:81068", -- [17]
			"83924:81064:81078", -- [18]
			"83924:81064:81354", -- [19]
			"82612:81285", -- [20]
			"88668:82844", -- [21]
			"83924:82346", -- [22]
			"82612:84498", -- [23]
			"82612:84498:84504", -- [24]
			"82612:84498:82511", -- [25]
			"83924:82346:81053:84508", -- [26]
			"82612:84509", -- [27]
			"83924:82346:81053:84495", -- [28]
			"82612:84515", -- [29]
			"88668:79407:76784:86492", -- [30]
			"88668:79407:76784:85829:84700", -- [31]
			"82612:81285:83427", -- [32]
			"88668:79407:76784:85829", -- [33]
			"88668:79407:87707", -- [34]
			"88668:79407:76784:86492:84714", -- [35]
			"82612:88584", -- [36]
			"88668:79407:76784:86492:84714:88757", -- [37]
			"83924:82346:81053:90552:90550", -- [38]
			"83924:82346:81053:90552:90560", -- [39]
			"83924:82346:81053:90552", -- [40]
			"83924:82346:81053:90552:90562", -- [41]
			"83924:82346:81053:90552:92809:92808", -- [42]
			"83924:82346:81053:90552:92809", -- [43]
			--["name"] = "Nivek's Overlook, Nagrand",
			["m"] = 550,
			["f"] = 0,
			["direct"] = "82612:83924:82340:87395:88668",
			["coord"] = 2119811621,
		},
		[90550] = {
			"90562:76850", -- [1]
			"90560:84508:84495:76784:79407:76782", -- [2]
			"90560:84508:84495:76784:76879:76781", -- [3]
			"90560:84508:84495:76784:76787:76783", -- [4]
			"90560:84508:84495:76784:76787", -- [5]
			"90560:84508:84495:76784:76879", -- [6]
			"90560:84508:84495:76784", -- [7]
			"90560:84508:84495:76784:87707:78699", -- [8]
			"90560:84508:84495:76784:79407", -- [9]
			"90562:80932", -- [10]
			"90552:81053", -- [11]
			"90560:84508:81055", -- [12]
			"90552:81057", -- [13]
			"90552:81053:81058", -- [14]
			"90552:81053:81058:81064", -- [15]
			"90552:81053:81058:81064:81068", -- [16]
			"90562:80932:81354:81078", -- [17]
			"90562:80932:81354", -- [18]
			"90562:76850:81285", -- [19]
			"90562:76850:88584:82612", -- [20]
			"90552:81053:82346:83924", -- [21]
			"90552:81053:82346:82844", -- [22]
			"90552:81053:82346", -- [23]
			"90552:81053:82346:82340", -- [24]
			"90562:76850:88584:84515:84498", -- [25]
			"90562:76850:84504", -- [26]
			"90562:76850:84504:82511", -- [27]
			"90560:84508", -- [28]
			"90562:80932:81354:81078:84509", -- [29]
			"90560:84508:84495", -- [30]
			"90562:76850:88584:84515", -- [31]
			"90560:84508:81055:86492", -- [32]
			"92808:84714:84700", -- [33]
			"90562:76850:83427", -- [34]
			"92808:84714:85829", -- [35]
			"90560:84508:84495:76784:87707", -- [36]
			"92808:84714", -- [37]
			"90562:76850:88584", -- [38]
			"90552:81053:82346:82340:87395", -- [39]
			"90552:81053:82346:83924:88653", -- [40]
			"90552:81053:82346:82844:88668", -- [41]
			"92808:84714:88757", -- [42]
			"92808:92809", -- [43]
			--["name"] = "Vol'mar, Tanaan Jungle",
			["m"] = 534,
			["f"] = 0,
			["direct"] = "86049:90560:90552:90562:92808",
			["coord"] = 2596304611,
		},
		[81285] = {
			"88584:81064:79407:76782", -- [1]
			"88584:81064:79407:76781", -- [2]
			"88584:81064:76787:76783", -- [3]
			"88584:81064:76787", -- [4]
			"88584:81064:79407:76879", -- [5]
			"81057:76784", -- [6]
			"88584:81064:79407:78699", -- [7]
			"88584:81064:79407", -- [8]
			"88584:81354:80932", -- [9]
			"81057:81053", -- [10]
			"81057:84495:81055", -- [11]
			"88584:81354:81058", -- [12]
			"88584:81064", -- [13]
			"81078:81068", -- [14]
			"88584:81354", -- [15]
			"88584:81064:82346:83924", -- [16]
			"88584:81064:82346:82844", -- [17]
			"88584:81064:82346", -- [18]
			"88584:81064:82346:82340", -- [19]
			"84504:84498", -- [20]
			"84504:82511", -- [21]
			"81057:84508", -- [22]
			"82612:84509", -- [23]
			"81057:84495", -- [24]
			"84504:84515", -- [25]
			"81057:84495:81055:86492", -- [26]
			"81057:84495:81055:84700", -- [27]
			"81057:84495:85829", -- [28]
			"81057:76784:87707", -- [29]
			"76850:90562:92808:84714", -- [30]
			"88584:81064:82346:82340:87395", -- [31]
			"82612:88653", -- [32]
			"88584:81064:82346:82844:88668", -- [33]
			"76850:90562:92808:84714:88757", -- [34]
			"76850:90562:90550", -- [35]
			"88584:81354:80932:90560", -- [36]
			"81057:90552", -- [37]
			"76850:90562", -- [38]
			"76850:90562:92808", -- [39]
			"88584:81354:80932:92809", -- [40]
			--["name"] = "Socrethar's Rise, Shadowmoon Valley",
			["m"] = 539,
			["coord"] = 1884800591,
			["direct"] = "76850:86049:81057:81078:82612:84504:83427:88584",
			["f"] = 0,
		},
		[83924] = {
			"81064:81078:76850", -- [1]
			"82844:79407:76782", -- [2]
			"82844:79407:76781", -- [3]
			"82844:79407:78699:76783", -- [4]
			"82844:76787", -- [5]
			"82844:79407:76879", -- [6]
			"82844:79407:76784", -- [7]
			"82844:79407:78699", -- [8]
			"82346:81053:90552:90550:86049", -- [9]
			"82844:79407", -- [10]
			"82346:81057:80932", -- [11]
			"82346:81053", -- [12]
			"82346:81055", -- [13]
			"82346:81057", -- [14]
			"81064:81058", -- [15]
			"81064:81078", -- [16]
			"81064:81354", -- [17]
			"81068:84509:84515:84504:81285", -- [18]
			"81068:84509:82612", -- [19]
			"81068:84509:84498", -- [20]
			"81068:84509:84515:84504", -- [21]
			"81068:84509:84498:82511", -- [22]
			"82346:81053:84508", -- [23]
			"81068:84509", -- [24]
			"82346:81053:84495", -- [25]
			"81068:84509:84515", -- [26]
			"82346:81055:86492", -- [27]
			"82346:81055:84700", -- [28]
			"81068:84509:84515:84504:81285:83427", -- [29]
			"82844:79407:76784:85829", -- [30]
			"82844:79407:87707", -- [31]
			"82346:81055:84714", -- [32]
			"81064:88584", -- [33]
			"82340:87395", -- [34]
			"82844:88668", -- [35]
			"82346:81055:84714:88757", -- [36]
			"82346:81053:90552:90550", -- [37]
			"82346:81053:90552:90560", -- [38]
			"82346:81053:90552", -- [39]
			"82346:81053:90552:90562", -- [40]
			"82346:81053:90552:92809:92808", -- [41]
			"82346:81053:90552:92809", -- [42]
			--["name"] = "The Ring of Trials, Nagrand",
			["m"] = 550,
			["f"] = 0,
			["direct"] = "81064:81068:82844:82346:82340:88653",
			["coord"] = 3424812890,
		},
		[84495] = {
			"84508:90552:90562:76850", -- [1]
			"76784:79407:76782", -- [2]
			"76784:76879:76781", -- [3]
			"76784:76787:76783", -- [4]
			"76784:76787", -- [5]
			"76784:76879", -- [6]
			"76784:87707:78699", -- [7]
			"76784:79407", -- [8]
			"84508:90552:80932", -- [9]
			"81053:81058", -- [10]
			"81053:81058:81064", -- [11]
			"81053:81058:81064:81068", -- [12]
			"81053:81058:81078", -- [13]
			"81057:81354", -- [14]
			"81057:81285", -- [15]
			"81057:82612", -- [16]
			"81053:82346:83924", -- [17]
			"81053:82346:82844", -- [18]
			"81053:82346", -- [19]
			"81053:82346:82340", -- [20]
			"81057:81354:84515:84498", -- [21]
			"81057:81354:84515:84504", -- [22]
			"81057:81354:84515:82511", -- [23]
			"81053:81058:81078:84509", -- [24]
			"81057:81354:84515", -- [25]
			"81055:86492", -- [26]
			"81055:84700", -- [27]
			"81057:83427", -- [28]
			"76784:87707", -- [29]
			"81055:84714", -- [30]
			"81057:81354:88584", -- [31]
			"81053:82346:82340:87395", -- [32]
			"81053:82346:83924:88653", -- [33]
			"81053:82346:82844:88668", -- [34]
			"81055:84714:88757", -- [35]
			"84508:90560:90550", -- [36]
			"84508:90560", -- [37]
			"84508:90552", -- [38]
			"84508:90552:90562", -- [39]
			"84508:90560:92808", -- [40]
			"84508:90552:92809", -- [41]
			--["name"] = "Evermorn Springs, Gorgrond",
			["m"] = 543,
			["f"] = 0,
			["direct"] = "76784:86049:81053:81055:81057:84508:85829",
			["coord"] = 1774837558,
		},
		[83427] = {
			"81057:79407:76782", -- [1]
			"81057:79407:76781", -- [2]
			"81057:76784:76787:76783", -- [3]
			"81057:76784:76787", -- [4]
			"81057:79407:76879", -- [5]
			"81057:76784", -- [6]
			"81057:76784:87707:78699", -- [7]
			"81057:79407", -- [8]
			"81285:88584:81354:80932", -- [9]
			"81057:81053", -- [10]
			"81057:84495:81055", -- [11]
			"81285:88584:81354:81058", -- [12]
			"81285:88584:81064", -- [13]
			"81285:81078:81068", -- [14]
			"81285:81078", -- [15]
			"81285:88584:81354", -- [16]
			"81285:82612", -- [17]
			"81285:88584:81064:82346:83924", -- [18]
			"81285:88584:81064:82346:82844", -- [19]
			"81285:88584:81064:82346", -- [20]
			"81285:88584:81064:82346:82340", -- [21]
			"81285:84504:84498", -- [22]
			"81285:84504", -- [23]
			"81285:84504:82511", -- [24]
			"81057:84508", -- [25]
			"81285:82612:84509", -- [26]
			"81057:84495", -- [27]
			"81285:84504:84515", -- [28]
			"81057:84495:81055:86492", -- [29]
			"81057:84495:81055:84700", -- [30]
			"81057:84495:85829", -- [31]
			"81057:76784:87707", -- [32]
			"76850:90562:92808:84714", -- [33]
			"81285:88584", -- [34]
			"81285:88584:81064:82346:82340:87395", -- [35]
			"81285:82612:88653", -- [36]
			"81285:88584:81064:82346:82844:88668", -- [37]
			"76850:90562:92808:84714:88757", -- [38]
			"76850:90562:90550", -- [39]
			"76850:90562:92809:90560", -- [40]
			"81057:90552", -- [41]
			"76850:90562", -- [42]
			"76850:90562:92808", -- [43]
			"76850:90562:92809", -- [44]
			--["name"] = "Darktide Roost, Shadowmoon Valley",
			["m"] = 539,
			["coord"] = 2569326670,
			["direct"] = "76850:86049:81057:81285",
			["f"] = 0,
		},
		[84504] = {
			"88584:81064:79407:76782", -- [1]
			"88584:81064:79407:76781", -- [2]
			"88584:81064:76787:76783", -- [3]
			"88584:81064:76787", -- [4]
			"88584:81064:79407:76879", -- [5]
			"88584:81354:81057:76784", -- [6]
			"88584:81064:79407:78699", -- [7]
			"76850:86049", -- [8]
			"88584:81064:79407", -- [9]
			"88584:81354:80932", -- [10]
			"88584:81354:81057:81053", -- [11]
			"88584:81354:81057:84495:81055", -- [12]
			"88584:81354:81057", -- [13]
			"88584:81354:81058", -- [14]
			"88584:81064", -- [15]
			"84498:84509:81068", -- [16]
			"88584:81078", -- [17]
			"88584:81354", -- [18]
			"84498:82612", -- [19]
			"88584:81064:82346:83924", -- [20]
			"88584:81064:82346:82844", -- [21]
			"88584:81064:82346", -- [22]
			"88584:81064:82346:82340", -- [23]
			"88584:81354:81057:84508", -- [24]
			"84498:84509", -- [25]
			"88584:81354:81057:84495", -- [26]
			"88584:81354:81057:84495:81055:86492", -- [27]
			"88584:81354:81057:84495:81055:84700", -- [28]
			"81285:83427", -- [29]
			"88584:81354:81057:84495:85829", -- [30]
			"88584:81354:81057:76784:87707", -- [31]
			"88584:81354:81057:84495:81055:84714", -- [32]
			"88584:81064:82346:82340:87395", -- [33]
			"84498:82612:88653", -- [34]
			"88584:81064:82346:82844:88668", -- [35]
			"88584:81354:81057:84495:81055:84714:88757", -- [36]
			"76850:90562:90550", -- [37]
			"88584:81354:80932:90560", -- [38]
			"88584:81354:81057:90552", -- [39]
			"76850:90562", -- [40]
			"76850:90562:92808", -- [41]
			"88584:81354:80932:92809", -- [42]
			--["name"] = "Talon Watch, Spires of Arak",
			["m"] = 542,
			["coord"] = 2659347716,
			["direct"] = "76850:81285:84498:82511:84515:88584",
			["f"] = 0,
		},
		[88757] = {
			"84714:92808:90562:76850", -- [1]
			"84714:86492:76784:79407:76782", -- [2]
			"84714:85829:76787:76781", -- [3]
			"84714:85829:76787:76783", -- [4]
			"84714:85829:76787", -- [5]
			"84714:86492:76784:76879", -- [6]
			"84714:86492:76784", -- [7]
			"84714:86492:76784:87707:78699", -- [8]
			"84714:86049", -- [9]
			"84714:86492:76784:79407", -- [10]
			"84714:92808:92809:80932", -- [11]
			"84714:81055:84508:81053", -- [12]
			"84714:81055", -- [13]
			"84714:81055:81057", -- [14]
			"84714:81055:84508:81053:81058", -- [15]
			"84714:86492:76784:81064", -- [16]
			"84714:86492:76784:81064:81068", -- [17]
			"84714:86492:76784:81064:81078", -- [18]
			"84714:81055:81057:81354", -- [19]
			"84714:92808:90562:76850:81285", -- [20]
			"84714:81055:81057:82612", -- [21]
			"84714:81055:84508:81053:82346:83924", -- [22]
			"84714:86492:76784:79407:82844", -- [23]
			"84714:81055:84508:81053:82346", -- [24]
			"84714:86492:76784:79407:82844:82340", -- [25]
			"84714:81055:81057:81354:84515:84498", -- [26]
			"84714:81055:81057:81354:84515:84504", -- [27]
			"84714:81055:81057:81354:84515:82511", -- [28]
			"84714:81055:84508", -- [29]
			"84714:86492:76784:81064:81078:84509", -- [30]
			"84714:81055:84495", -- [31]
			"84714:81055:81057:81354:84515", -- [32]
			"84714:86492", -- [33]
			"84714:84700", -- [34]
			"84714:92808:90562:76850:83427", -- [35]
			"84714:85829", -- [36]
			"84714:86492:76784:87707", -- [37]
			"84714:81055:81057:81354:88584", -- [38]
			"84714:86492:76784:79407:87395", -- [39]
			"84714:81055:84508:81053:82346:83924:88653", -- [40]
			"84714:86492:76784:79407:88668", -- [41]
			"84714:92808:90550", -- [42]
			"84714:92808:90560", -- [43]
			"84714:81055:84508:90552", -- [44]
			"84714:92808:90562", -- [45]
			"84714:92808", -- [46]
			"84714:92808:92809", -- [47]
			--["name"] = "Everbloom Overlook, Gorgrond",
			["m"] = 543,
			["coord"] = 2952612266,
			["direct"] = "84714",
			["f"] = 0,
		},
},
	[8] = {
		[108888] = {
			"88110:90556", -- [1]
			"110971:90639", -- [2]
			"88110:90556:93447", -- [3]
			"88110:90556:93447:93940", -- [4]
			"112866:111624:114666:100550:95688", -- [5]
			"112866:111624:111675:114718:92560", -- [6]
			"112866:111624:111675:114718:111420:98105", -- [7]
			"112866:111624:111675:98966:98124", -- [8]
			"112866:111624:111675:114718:92560:98161", -- [9]
			"112866:111624:114666:100550:94973:97860", -- [10]
			"112866:111624:114666:100550:94973:97868", -- [11]
			"112866:111624:114666:100550:97870", -- [12]
			"112866:111624:114666:100550:94973:97868:98066", -- [13]
			"112866:111624:114666:96565", -- [14]
			"112866:111624:111675:98966", -- [15]
			"112866:111624:114666:100550:94973:97860:98972", -- [16]
			"112866:111624:114666:100468", -- [17]
			"88110:90556:93447:100459", -- [18]
			"112866:111624:114666:100550:94973", -- [19]
			"112866:96813", -- [20]
			"112866:111624:114666:100550", -- [21]
			"112866:111624:111675:98966:100559", -- [22]
			"112866:111624:111675:114718:92560:98161:111314", -- [23]
			"112866:96813:111323", -- [24]
			"112866:111624:111675:98966:111327", -- [25]
			"112866:111624:111675", -- [26]
			"112866:111624", -- [27]
			"112866:111624:111675:114718:111420", -- [28]
			"111418:112926", -- [29]
			"112866:111624:111675:114718", -- [30]
			"112866:111624:114666", -- [31]
			"110971:90639:114837", -- [32]
			"112866:96813:111323:93465", -- [33]
			"112866:96813:120272", -- [1]
			"112866:96813:111323:120118", -- [2]			
			["m"] = 630,
			["coord"] = 2070330066,
			["direct"] = "88110:112866:111418:110971",
			["f"] = 0,
		},
		[110971] = {
			"88110:90556", -- [1]
			"88110:112866", -- [2]
			"90639:93447", -- [3]
			"90639:93940", -- [4]
			"90639:93447:100459:100468:100550:95688", -- [5]
			"88110:90556:111675:114718:92560", -- [6]
			"88110:90556:111675:114718:111420:98105", -- [7]
			"88110:90556:111675:98966:98124", -- [8]
			"88110:90556:111675:114718:92560:98161", -- [9]
			"90639:93447:100459:100468:100550:94973:97860", -- [10]
			"90639:93447:100459:100468:100550:94973:97868", -- [11]
			"90639:93447:100459:100468:100550:97870", -- [12]
			"90639:93447:100459:100468:100550:94973:97868:98066", -- [13]
			"90639:114666:96565", -- [14]
			"88110:90556:111675:98966", -- [15]
			"90639:93447:100459:100468:100550:94973:97860:98972", -- [16]
			"90639:93447:100459:100468", -- [17]
			"90639:93447:100459", -- [18]
			"90639:93447:100459:100468:100550:94973", -- [19]
			"88110:112866:96813", -- [20]
			"90639:93447:100459:100468:100550", -- [21]
			"88110:90556:111675:98966:100559", -- [22]
			"88110:90556:111675:114718:92560:98161:111314", -- [23]
			"88110:112866:96813:111323", -- [24]
			"88110:90556:111675:98966:111327", -- [25]
			"88110:90556:111675", -- [26]
			"88110:90556:111624", -- [27]
			"108888:111418", -- [28]
			"88110:90556:111675:114718:111420", -- [29]
			"108888:111418:112926", -- [30]
			"88110:90556:111675:114718", -- [31]
			"90639:114666", -- [32]
			"90639:114837", -- [33]
			"88110:112866:96813:111323:93465", -- [34]
			"90639:93447:100459:100468:100550:98968:97868", -- [7]
			"90639:93447:100459:100468:100550:98968:97868:98066", -- [8]
			"90639:93447:100459:100468:100550:98968", -- [11]
			"90639:93940:107457", -- [20]
			"88110:112866:96813:120272", -- [1]
			"88110:112866:96813:111323:120118", -- [2]			
			["direct"] = "90639:88110:108888",
			["coord"] = 1367111308,
			["m"] = 630,
			["f"] = 0,
		},
		[94973] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"95688:100559:92560", -- [7]
			"95688:100559:92560:98105", -- [8]
			"95688:100559:98124", -- [9]
			"95688:100559:92560:98161", -- [10]
			"97868:98066", -- [11]
			"100550:96565", -- [12]
			"95688:98966", -- [13]
			"97860:98972", -- [14]
			"100550:100468", -- [15]
			"100550:100468:100459", -- [16]
			"100550:114666:111675:96813", -- [17]
			"95688:100559", -- [18]
			"100550:114666:111624:112866:108888", -- [19]
			"97860:111314", -- [20]
			"100550:114666:111675:111323", -- [21]
			"95688:100559:98124:111327", -- [22]
			"100550:114666:111675", -- [23]
			"100550:114666:111624", -- [24]
			"100550:114666:111624:112866:108888:111418", -- [25]
			"100550:114666:90639:110971", -- [26]
			"95688:100559:92560:98105:111420", -- [27]
			"100550:114666:111624:112866:112926", -- [28]
			"100550:96565:114718", -- [29]
			"100550:114666", -- [30]
			"100550:100468:100459:93940:114837", -- [31]
			"100550:96565:114718:93465", -- [32]
			"97870:107457", -- [9]
			"100550:114666:111675:111323:120272", -- [1]
			"100550:114666:111675:111323:120118", -- [2]			
			["m"] = 650,
			["f"] = 0,
			["direct"] = "95688:97860:97868:97870:100550:98968",
			["coord"] = 1728546507,
		},
		[88110] = {
			"90556:90639", -- [1]
			"90556:93447", -- [2]
			"90556:93447:93940", -- [3]
			"90556:114666:100550:95688", -- [4]
			"90556:111675:114718:92560", -- [5]
			"90556:111675:114718:111420:98105", -- [6]
			"90556:111675:98966:98124", -- [7]
			"90556:111675:114718:92560:98161", -- [8]
			"90556:114666:100550:94973:97860", -- [9]
			"90556:114666:100550:94973:97868", -- [10]
			"90556:114666:100550:97870", -- [11]
			"90556:114666:100550:94973:97868:98066", -- [12]
			"90556:114666:96565", -- [13]
			"90556:111675:98966", -- [14]
			"90556:114666:100550:94973:97860:98972", -- [15]
			"90556:93447:100459:100468", -- [16]
			"90556:93447:100459", -- [17]
			"90556:114666:100550:94973", -- [18]
			"112866:96813", -- [19]
			"90556:114666:100550", -- [20]
			"90556:111675:98966:100559", -- [21]
			"90556:111675:114718:92560:98161:111314", -- [22]
			"112866:96813:111323", -- [23]
			"90556:111675:98966:111327", -- [24]
			"90556:111675", -- [25]
			"90556:111624", -- [26]
			"108888:111418", -- [27]
			"90556:111675:114718:111420", -- [28]
			"108888:111418:112926", -- [29]
			"90556:111675:114718", -- [30]
			"90556:114666", -- [31]
			"90556:90639:114837", -- [32]
			"112866:96813:111323:93465", -- [33]
			"90556:93447:100459:107457", -- [22]
			"112866:96813:120272", -- [1]
			"112866:96813:111323:120118", -- [2]			
			["m"] = 630,
			["coord"] = 1916301339,
			["direct"] = "90556:112866:108888:110971",
			["f"] = 0,
		},
		[120118] = {
			"120272:96813:111624:90556", -- [1]
			"120272:96813:111624:90639", -- [2]
			"120272:96813:112866:88110", -- [3]
			"120272:96813:112866", -- [4]
			"111323:111675:114666:93447", -- [5]
			"111323:111675:114666:100459:93940", -- [6]
			"111323:111675:114666:100550:95688", -- [7]
			"111323:111420:98105:92560", -- [8]
			"111323:111420:98105", -- [9]
			"111323:111420:98105:92560:98124", -- [10]
			"111323:111420:98161", -- [11]
			"111323:111420:98105:92560:100559:97860", -- [12]
			"111323:111675:114666:100550:94973:97868", -- [13]
			"111323:111675:114666:100550:97870", -- [14]
			"111323:111675:114666:100550:94973:97868:98066", -- [15]
			"111323:111675:96565", -- [16]
			"111323:111675:98966", -- [17]
			"111323:111420:98105:92560:98124:98972", -- [18]
			"111323:111675:114666:100468", -- [19]
			"111323:111675:114666:100459", -- [20]
			"111323:111675:114666:100550:94973", -- [21]
			"120272:96813", -- [22]
			"111323:111675:114666:100550", -- [23]
			"111323:111420:98105:92560:100559", -- [24]
			"120272:96813:112866:108888", -- [25]
			"111323:111420:98161:111314", -- [26]
			"111323:111420:98161:111327", -- [27]
			"111323:111675", -- [28]
			"120272:96813:111624", -- [29]
			"120272:96813:111418", -- [30]
			"120272:96813:112866:88110:110971", -- [31]
			"111323:111420", -- [32]
			"111323:112926", -- [33]
			"111323:114718", -- [34]
			"111323:111675:114666", -- [35]
			"120272:96813:111624:90639:114837", -- [36]
			["m"] = 646,
			["direct"] = "111323:120272",
			["coord"] = 3035986385,
			["f"] = 0,
		},		
		[98966] = {
			"96565:114666:90556", -- [1]
			"96565:114666:90639", -- [2]
			"96565:114666:90556:88110", -- [3]
			"111675:111624:112866", -- [4]
			"96565:114666:93447", -- [5]
			"96565:114666:100459:93940", -- [6]
			"92560:98105", -- [7]
			"92560:98161", -- [8]
			"95688:94973:97868", -- [9]
			"95688:94973:97870", -- [10]
			"95688:94973:97868:98066", -- [11]
			"97860:98972", -- [12]
			"96565:100468", -- [13]
			"96565:114666:100459", -- [14]
			"95688:94973", -- [15]
			"111675:96813", -- [16]
			"95688:100550", -- [17]
			"111675:111624:112866:108888", -- [18]
			"111327:111314", -- [19]
			"114718:111323", -- [20]
			"111675:111624", -- [21]
			"111675:111624:112866:108888:111418", -- [22]
			"96565:114666:90639:110971", -- [23]
			"92560:98105:111420", -- [24]
			"111675:96813:112926", -- [25]
			"96565:114666", -- [26]
			"96565:114666:100459:93940:114837", -- [27]
			"114718:93465", -- [28]
			"114718:111323:120272", -- [1]
			"114718:111323:120118", -- [2]			
			["m"] = 650,
			["coord"] = 2441074353,
			["direct"] = "95688:92560:98124:97860:96565:100559:111327:111675:114718",
			["f"] = 0,
		},
		[120272] = {
			"96813:111624:90556", -- [1]
			"96813:111624:90639", -- [2]
			"96813:112866:88110", -- [3]
			"96813:112866", -- [4]
			"96813:111624:93447", -- [5]
			"96813:111624:93447:93940", -- [6]
			"111323:111675:114666:100550:95688", -- [7]
			"111323:111420:98105:92560", -- [8]
			"111323:111420:98105", -- [9]
			"111323:111420:98105:92560:98124", -- [10]
			"111323:111420:98161", -- [11]
			"111323:111420:98105:92560:100559:97860", -- [12]
			"111323:111675:114666:100550:94973:97868", -- [13]
			"111323:111675:114666:100550:97870", -- [14]
			"111323:111675:114666:100550:94973:97868:98066", -- [15]
			"111323:111675:96565", -- [16]
			"111323:111675:98966", -- [17]
			"111323:111420:98105:92560:98124:98972", -- [18]
			"111323:111675:114666:100468", -- [19]
			"96813:111624:93447:100459", -- [20]
			"111323:111675:114666:100550:94973", -- [21]
			"111323:111675:114666:100550", -- [22]
			"111323:111420:98105:92560:100559", -- [23]
			"96813:112866:108888", -- [24]
			"111323:111420:98161:111314", -- [25]
			"111323:111420:98161:111327", -- [26]
			"111323:111675", -- [27]
			"96813:111624", -- [28]
			"96813:111418", -- [29]
			"96813:112866:88110:110971", -- [30]
			"111323:111420", -- [31]
			"96813:112926", -- [32]
			"111323:114718", -- [33]
			"111323:111675:114666", -- [34]
			"96813:111624:90639:114837", -- [35]
			["m"] = 646,
			["direct"] = "96813:111323:120118",
			["coord"] = 1938924524,
			["f"] = 0,
		},		
		[92560] = {
			"114718:111675:90556", -- [1]
			"114718:111675:90639", -- [2]
			"114718:111675:90556:88110", -- [3]
			"114718:111675:111624:112866", -- [4]
			"114718:111675:114666:93447", -- [5]
			"114718:111675:114666:100459:93940", -- [6]
			"100559:95688", -- [7]
			"100559:97860", -- [8]
			"100559:95688:94973:97868", -- [9]
			"100559:95688:94973:97870", -- [10]
			"98124:98972:98066", -- [11]
			"98966:96565", -- [12]
			"98124:98972", -- [13]
			"100559:95688:100550:100468", -- [14]
			"114718:111675:114666:100459", -- [15]
			"100559:95688:94973", -- [16]
			"114718:96813", -- [17]
			"100559:95688:100550", -- [18]
			"114718:111675:111624:112866:108888", -- [19]
			"98161:111314", -- [20]
			"114718:111323", -- [21]
			"114718:111675", -- [22]
			"114718:111675:111624", -- [23]
			"114718:96813:111418", -- [24]
			"114718:111675:90556:88110:110971", -- [25]
			"98105:111420", -- [26]
			"114718:96813:112926", -- [27]
			"114718:111675:114666", -- [28]
			"114718:111675:90639:114837", -- [29]
			"100559:95688:94973:98968", -- [8]		
			"114718:111675:114666:100459:107457", -- [10]	
			"114718:111323:120272", -- [1]
			"114718:111323:120118", -- [2]		
			["m"] = 634,
			["f"] = 0,
			["direct"] = "98105:98124:98161:98966:100559:111327:114718",
			["coord"] = 1930074009,
		},
		[97860] = {
			"95688:100550:114666:90556", -- [1]
			"95688:100550:114666:90639", -- [2]
			"95688:100550:114666:90556:88110", -- [3]
			"95688:100550:114666:111624:112866", -- [4]
			"95688:100550:100468:100459:93447", -- [5]
			"95688:100550:100468:100459:93940", -- [6]
			"100559:92560", -- [7]
			"100559:92560:98105", -- [8]
			"98124:111327:98161", -- [9]
			"94973:97870", -- [10]
			"95688:96565", -- [11]
			"95688:100550:100468", -- [12]
			"95688:100550:100468:100459", -- [13]
			"95688:96565:111675:96813", -- [14]
			"95688:100550", -- [15]
			"95688:100550:114666:111624:112866:108888", -- [16]
			"100559:92560:114718:111323", -- [17]
			"98124:111327", -- [18]
			"95688:96565:111675", -- [19]
			"95688:100550:114666:111624", -- [20]
			"95688:100550:114666:111624:112866:108888:111418", -- [21]
			"95688:100550:114666:90639:110971", -- [22]
			"100559:92560:98105:111420", -- [23]
			"95688:96565:111675:96813:112926", -- [24]
			"100559:92560:114718", -- [25]
			"95688:100550:114666", -- [26]
			"95688:100550:100468:100459:93940:114837", -- [27]
			"98968:97870", -- [10]
			"94973:97870:107457", -- [16]
			"100559:92560:114718:111323:120272", -- [1]
			"100559:92560:114718:111323:120118", -- [2]			
			["m"] = 650,
			["f"] = 0,
			["direct"] = "95688:98124:97868:98066:98966:98972:94973:100559:111314:98968",
			["coord"] = 2258727865,
		},
		[90556] = {
			"93447:93940", -- [1]
			"114666:100550:95688", -- [2]
			"111675:114718:92560", -- [3]
			"111675:114718:111420:98105", -- [4]
			"111675:98966:98124", -- [5]
			"111675:114718:92560:98161", -- [6]
			"114666:100550:94973:97860", -- [7]
			"114666:100550:94973:97868", -- [8]
			"114666:100550:97870", -- [9]
			"114666:100550:94973:97868:98066", -- [10]
			"114666:96565", -- [11]
			"111675:98966", -- [12]
			"114666:100550:94973:97860:98972", -- [13]
			"93447:100459:100468", -- [14]
			"93447:100459", -- [15]
			"114666:100550:94973", -- [16]
			"111624:96813", -- [17]
			"114666:100550", -- [18]
			"111675:98966:100559", -- [19]
			"88110:108888", -- [20]
			"111675:114718:92560:98161:111314", -- [21]
			"111624:96813:111323", -- [22]
			"111675:98966:111327", -- [23]
			"88110:108888:111418", -- [24]
			"88110:110971", -- [25]
			"111675:114718:111420", -- [26]
			"112866:112926", -- [27]
			"111675:114718", -- [28]
			"90639:114837", -- [29]
			"114666:100550:98968:97868", -- [7]
			"114666:100550:98968:97868:98066", -- [9]
			"114666:100550:98968", -- [12]
			"93447:100459:107457", -- [18]
			"111624:96813:120272", -- [1]
			"111624:96813:111323:120118", -- [2]			
			["m"] = 630,
			["coord"] = 2077378472,
			["direct"] = "90639:88110:112866:93447:111675:111624:114666",
			["f"] = 0,
		},
		[97868] = {
			"94973:100550:114666:90556", -- [1]
			"94973:100550:114666:90639", -- [2]
			"94973:100550:114666:90556:88110", -- [3]
			"94973:100550:114666:111624:112866", -- [4]
			"94973:100550:100468:100459:93447", -- [5]
			"94973:100550:100468:100459:93940", -- [6]
			"95688:100559:92560", -- [7]
			"95688:100559:92560:98105", -- [8]
			"97860:98124", -- [9]
			"97860:98124:111327:98161", -- [10]
			"95688:96565", -- [11]
			"95688:98966", -- [12]
			"94973:100550:100468", -- [13]
			"94973:100550:100468:100459", -- [14]
			"95688:96565:111675:96813", -- [15]
			"94973:100550", -- [16]
			"95688:100559", -- [17]
			"94973:100550:114666:111624:112866:108888", -- [18]
			"98972:111314", -- [19]
			"95688:96565:111675:111323", -- [20]
			"97860:98124:111327", -- [21]
			"95688:96565:111675", -- [22]
			"94973:100550:114666:111624", -- [23]
			"94973:100550:114666:111624:112866:108888:111418", -- [24]
			"94973:100550:114666:90639:110971", -- [25]
			"95688:100559:92560:98105:111420", -- [26]
			"95688:96565:111675:96813:112926", -- [27]
			"95688:96565:114718", -- [28]
			"94973:100550:114666", -- [29]
			"94973:100550:100468:100459:93940:114837", -- [30]
			"98968:100550:114666:90556", -- [1]
			"98968:100550:114666:90639", -- [2]
			"98968:100550:114666:90556:88110", -- [3]
			"98968:100550:114666:111624:112866", -- [4]
			"98968:100550:100468:100459:93447", -- [5]
			"98968:100550:100468:100459:93940", -- [6]
			"98968:100550:100468", -- [13]
			"98968:100550:100468:100459", -- [14]
			"98968:100550:114666:111675:96813", -- [15]
			"98968:100550", -- [16]
			"98968:100550:114666:111675", -- [19]
			"98968:100550:114666:111624", -- [20]
			"98968:100550:114666:90639:110971", -- [21]			
			"98968:100550:114666", -- [24]	
			"97870:107457", -- [18]			
			"95688:96565:111675:111323:120272", -- [1]
			"95688:96565:111675:111323:120118", -- [2]			
			["m"] = 650,
			["f"] = 0,
			["direct"] = "95688:97860:97870:98066:98972:94973:98968",
			["coord"] = 1645634648,
		},
		[112866] = {
			"90556:90639", -- [1]
			"111624:93447", -- [2]
			"111624:93447:93940", -- [3]
			"111624:114666:100550:95688", -- [4]
			"111624:111675:114718:92560", -- [5]
			"111624:111675:114718:111420:98105", -- [6]
			"111624:111675:98966:98124", -- [7]
			"111624:111675:114718:92560:98161", -- [8]
			"111624:114666:100550:94973:97860", -- [9]
			"111624:114666:100550:94973:97868", -- [10]
			"111624:114666:100550:97870", -- [11]
			"111624:114666:100550:94973:97868:98066", -- [12]
			"111624:114666:96565", -- [13]
			"111624:111675:98966", -- [14]
			"111624:114666:100550:94973:97860:98972", -- [15]
			"111624:114666:100468", -- [16]
			"111624:93447:100459", -- [17]
			"111624:114666:100550:94973", -- [18]
			"111624:114666:100550", -- [19]
			"111624:111675:98966:100559", -- [20]
			"111624:111675:114718:92560:98161:111314", -- [21]
			"96813:111323", -- [22]
			"111624:111675:98966:111327", -- [23]
			"111624:111675", -- [24]
			"108888:111418", -- [25]
			"88110:110971", -- [26]
			"111624:111675:114718:111420", -- [27]
			"111624:111675:114718", -- [28]
			"111624:114666", -- [29]
			"90556:90639:114837", -- [30]
			"96813:111323:93465", -- [31]
			"111624:93447:100459:107457", -- [20]
			"96813:120272", -- [1]
			"96813:111323:120118", -- [2]			
			["m"] = 630,
			["coord"] = 2412353262,
			["direct"] = "90556:88110:96813:108888:111624:112926",
			["f"] = 0,
		},
		[100459] = {
			"93447:90556", -- [1]
			"93447:90639", -- [2]
			"93447:90556:88110", -- [3]
			"93447:90556:112866", -- [4]
			"100468:100550:95688", -- [5]
			"100468:100550:95688:100559:92560", -- [6]
			"100468:100550:95688:100559:92560:98105", -- [7]
			"100468:100550:95688:100559:98124", -- [8]
			"100468:100550:95688:100559:92560:98161", -- [9]
			"100468:100550:94973:97860", -- [10]
			"100468:100550:94973:97868", -- [11]
			"100468:100550:97870", -- [12]
			"100468:100550:94973:97868:98066", -- [13]
			"100468:96565", -- [14]
			"100468:96565:98966", -- [15]
			"100468:100550:94973:97860:98972", -- [16]
			"100468:100550:94973", -- [17]
			"114666:111675:96813", -- [18]
			"100468:100550", -- [19]
			"100468:100550:95688:100559", -- [20]
			"93447:90556:88110:108888", -- [21]
			"100468:100550:95688:100559:98124:111327:111314", -- [22]
			"114666:111675:111323", -- [23]
			"100468:100550:95688:100559:98124:111327", -- [24]
			"114666:111675", -- [25]
			"93447:111624", -- [26]
			"93447:90556:88110:108888:111418", -- [27]
			"93447:90639:110971", -- [28]
			"114666:111675:114718:111420", -- [29]
			"93447:90556:112866:112926", -- [30]
			"114666:111675:114718", -- [31]
			"93940:114837", -- [32]
			"100468:100550:98968:97868", -- [5]
			"100468:100550:98968:97868:98066", -- [6]
			"100468:100550:98968", -- [7]			
			"114666:111675:111323:120272", -- [1]
			"114666:111675:111323:120118", -- [2]			
			["m"] = 641,
			["coord"] = 2436207577,
			["direct"] = "93447:93940:100468:114666:107457",
			["f"] = 0,
		},
		[90639] = {
			"90556:88110", -- [1]
			"90556:112866", -- [2]
			"93447:100459:100468:100550:95688", -- [3]
			"111675:114718:92560", -- [4]
			"111675:114718:111420:98105", -- [5]
			"93447:100459:100468:100550:95688:100559:98124", -- [6]
			"111675:114718:92560:98161", -- [7]
			"93447:100459:100468:100550:94973:97860", -- [8]
			"93447:100459:100468:100550:94973:97868", -- [9]
			"93447:100459:100468:100550:97870", -- [10]
			"93447:100459:100468:100550:94973:97868:98066", -- [11]
			"114666:96565", -- [12]
			"114666:96565:98966", -- [13]
			"93447:100459:100468:100550:94973:97860:98972", -- [14]
			"93447:100459:100468", -- [15]
			"93447:100459", -- [16]
			"93447:100459:100468:100550:94973", -- [17]
			"111624:96813", -- [18]
			"93447:100459:100468:100550", -- [19]
			"93447:100459:100468:100550:95688:100559", -- [20]
			"110971:108888", -- [21]
			"111675:114718:92560:98161:111314", -- [22]
			"111675:111323", -- [23]
			"114666:96565:98966:111327", -- [24]
			"110971:108888:111418", -- [25]
			"111675:114718:111420", -- [26]
			"90556:112866:112926", -- [27]
			"111675:114718", -- [28]
			"111675:114718:93465", -- [29]
			"93447:100459:100468:100550:98968:97868", -- [6]
			"93447:100459:100468:100550:98968:97868:98066", -- [7]		
			"93447:100459:100468:100550:98968", -- [10]
			"93940:107457", -- [20]
			"111624:96813:120272", -- [1]
			"111675:111323:120118", -- [2]			
			["m"] = 630,
			["coord"] = 1753618256,
			["direct"] = "90556:93447:93940:111675:111624:110971:114666:114837",
			["f"] = 0,
		},
		[96565] = {
			"114666:90556", -- [1]
			"114666:90639", -- [2]
			"114666:90556:88110", -- [3]
			"114666:111624:112866", -- [4]
			"114666:93447", -- [5]
			"114666:100459:93940", -- [6]
			"98966:92560", -- [7]
			"98966:92560:98105", -- [8]
			"98966:98124", -- [9]
			"98966:92560:98161", -- [10]
			"95688:97860", -- [11]
			"100550:94973:97868", -- [12]
			"100550:97870", -- [13]
			"100550:94973:97868:98066", -- [14]
			"95688:97860:98972", -- [15]
			"114666:100459", -- [16]
			"100550:94973", -- [17]
			"111675:96813", -- [18]
			"98966:100559", -- [19]
			"114666:111624:112866:108888", -- [20]
			"98966:111327:111314", -- [21]
			"111675:111323", -- [22]
			"98966:111327", -- [23]
			"114666:111624", -- [24]
			"114666:111624:112866:108888:111418", -- [25]
			"114666:90639:110971", -- [26]
			"114718:111420", -- [27]
			"111675:96813:112926", -- [28]
			"114666:100459:93940:114837", -- [29]
			"114718:93465", -- [30]
			"100550:98968:97868", -- [7]
			"100550:98968:97868:98066", -- [9]
			"100550:98968", -- [10]			
			"114666:100459:107457", -- [2]
			"111675:111323:120272", -- [1]
			"111675:111323:120118", -- [2]			
			["m"] = 650,
			["coord"] = 2030950571,
			["direct"] = "95688:98966:100468:100550:111675:114718:114666",
			["f"] = 0,
		},
		[111323] = {
			"96813:111624:90556", -- [1]
			"96813:111624:90639", -- [2]
			"96813:112866:88110", -- [3]
			"96813:112866", -- [4]
			"111675:114666:93447", -- [5]
			"111675:114666:100459:93940", -- [6]
			"111675:114666:100550:95688", -- [7]
			"111420:98105:92560", -- [8]
			"111420:98105", -- [9]
			"111420:98105:92560:98124", -- [10]
			"111420:98161", -- [11]
			"111420:98105:92560:100559:97860", -- [12]
			"111675:114666:100550:94973:97868", -- [13]
			"111675:114666:100550:97870", -- [14]
			"111675:114666:100550:94973:97868:98066", -- [15]
			"111675:96565", -- [16]
			"111675:98966", -- [17]
			"111420:98105:92560:98124:98972", -- [18]
			"111675:114666:100468", -- [19]
			"111675:114666:100459", -- [20]
			"111675:114666:100550:94973", -- [21]
			"111675:114666:100550", -- [22]
			"111420:98105:92560:100559", -- [23]
			"96813:112866:108888", -- [24]
			"111420:98161:111314", -- [25]
			"111420:98161:111327", -- [26]
			"96813:111624", -- [27]
			"96813:111418", -- [28]
			"96813:112866:88110:110971", -- [29]
			"111675:114666", -- [30]
			"96813:111624:90639:114837", -- [31]
			["m"] = 646,
			["coord"] = 2136815043,
			["direct"] = "96813:111675:111420:112926:114718:120272:120118",
			["f"] = 0,
		},
		[111327] = {
			"92560:114718:111675:90556", -- [1]
			"92560:114718:111675:90639", -- [2]
			"92560:114718:111675:90556:88110", -- [3]
			"92560:114718:111675:111624:112866", -- [4]
			"98966:96565:114666:93447", -- [5]
			"100559:95688:100550:100468:100459:93940", -- [6]
			"100559:95688", -- [7]
			"98161:98105", -- [8]
			"98124:97860", -- [9]
			"100559:95688:94973:97868", -- [10]
			"100559:95688:94973:97870", -- [11]
			"98972:98066", -- [12]
			"98966:96565", -- [13]
			"100559:95688:100550:100468", -- [14]
			"100559:95688:100550:100468:100459", -- [15]
			"100559:95688:94973", -- [16]
			"92560:114718:96813", -- [17]
			"100559:95688:100550", -- [18]
			"92560:114718:111675:111624:112866:108888", -- [19]
			"98161:111420:111323", -- [20]
			"92560:114718:111675", -- [21]
			"92560:114718:111675:111624", -- [22]
			"92560:114718:96813:111418", -- [23]
			"92560:114718:111675:90556:88110:110971", -- [24]
			"98161:111420", -- [25]
			"92560:114718:96813:112926", -- [26]
			"92560:114718", -- [27]
			"98966:96565:114666", -- [28]
			"100559:95688:100550:100468:100459:93940:114837", -- [29]
			"100559:95688:94973:97870:107457", -- [9]
			"98161:111420:111323", -- [1]
			"98161:111420:111323:120272", -- [2]
			"98161:111420:111323:120118", -- [3]		
			["m"] = 634,
			["f"] = 0,
			["direct"] = "92560:98124:98161:98966:98972:100559:111314",
			["coord"] = 2233489604,
		},

		[98105] = {
			"92560:114718:111675:90556", -- [1]
			"92560:114718:111675:90639", -- [2]
			"92560:114718:111675:90556:88110", -- [3]
			"92560:114718:111675:111624:112866", -- [4]
			"92560:114718:111675:114666:93447", -- [5]
			"92560:114718:111675:114666:100459:93940", -- [6]
			"92560:100559:95688", -- [7]
			"92560:98124", -- [8]
			"92560:100559:97860", -- [9]
			"92560:100559:95688:94973:97868", -- [10]
			"92560:100559:95688:94973:97870", -- [11]
			"92560:98124:98972:98066", -- [12]
			"92560:98966:96565", -- [13]
			"92560:98966", -- [14]
			"92560:98124:98972", -- [15]
			"92560:100559:95688:100550:100468", -- [16]
			"92560:114718:111675:114666:100459", -- [17]
			"92560:100559:95688:94973", -- [18]
			"111420:96813", -- [19]
			"92560:100559:95688:100550", -- [20]
			"92560:100559", -- [21]
			"92560:114718:111675:111624:112866:108888", -- [22]
			"98161:111314", -- [23]
			"111420:111323", -- [24]
			"98161:111327", -- [25]
			"92560:114718:111675", -- [26]
			"92560:114718:111675:111624", -- [27]
			"111420:96813:111418", -- [28]
			"92560:114718:111675:90556:88110:110971", -- [29]
			"111420:111323:112926", -- [30]
			"92560:114718", -- [31]
			"92560:114718:111675:114666", -- [32]
			"92560:114718:111675:90639:114837", -- [33]
			"92560:100559:95688:94973:98968", -- [15]
			"92560:114718:111675:114666:100459:107457", -- [22]
			"111420:111323:120272", -- [1]
			"111420:111323:120118", -- [2]			
			["direct"] = "92560:98161:111420",
			["f"] = 0,
			["m"] = 634,
			["coord"] = 2341583537,
		},
		[93447] = {
			"90556:88110", -- [1]
			"90556:112866", -- [2]
			"100459:100468:100550:95688", -- [3]
			"114666:111675:114718:92560", -- [4]
			"114666:111675:114718:111420:98105", -- [5]
			"100459:100468:100550:95688:100559:98124", -- [6]
			"114666:111675:114718:92560:98161", -- [7]
			"100459:100468:100550:94973:97860", -- [8]
			"100459:100468:100550:94973:97868", -- [9]
			"100459:100468:100550:97870", -- [10]
			"100459:100468:100550:94973:97868:98066", -- [11]
			"114666:96565", -- [12]
			"114666:96565:98966", -- [13]
			"100459:100468:100550:94973:97860:98972", -- [14]
			"100459:100468", -- [15]
			"100459:100468:100550:94973", -- [16]
			"111624:96813", -- [17]
			"100459:100468:100550", -- [18]
			"100459:100468:100550:95688:100559", -- [19]
			"90556:88110:108888", -- [20]
			"100459:100468:100550:95688:100559:98124:111327:111314", -- [21]
			"114666:111675:111323", -- [22]
			"100459:100468:100550:95688:100559:98124:111327", -- [23]
			"114666:111675", -- [24]
			"90556:88110:108888:111418", -- [25]
			"90639:110971", -- [26]
			"114666:111675:114718:111420", -- [27]
			"90556:112866:112926", -- [28]
			"114666:111675:114718", -- [29]
			"93940:114837", -- [30]
			"114666:111675:114718:93465", -- [31]
			"100459:100468:100550:98968:97868", -- [6]
			"100459:100468:100550:98968:97868:98066", -- [7]	
			"100459:100468:100550:98968", -- [10]			
			"100459:107457", -- [20]
			"111624:96813:120272", -- [8]
			"114666:111675:111323:120118", -- [9]			
			"111624:96813:120272", -- [1]
			"114666:111675:111323:120118", -- [2]			
			["m"] = 641,
			["coord"] = 2360588730,
			["direct"] = "90556:90639:93940:100459:111624:114666",
			["f"] = 0,
		},
		[112926] = {
			"112866:90556", -- [1]
			"112866:90556:90639", -- [2]
			"112866:88110", -- [3]
			"112866:111624:93447", -- [4]
			"112866:111624:93447:93940", -- [5]
			"112866:111624:114666:100550:95688", -- [6]
			"96813:114718:92560", -- [7]
			"111323:111420:98105", -- [8]
			"96813:114718:92560:98124", -- [9]
			"111323:111420:98161", -- [10]
			"112866:111624:114666:100550:94973:97860", -- [11]
			"112866:111624:114666:100550:94973:97868", -- [12]
			"112866:111624:114666:100550:97870", -- [13]
			"112866:111624:114666:100550:94973:97868:98066", -- [14]
			"96813:111675:96565", -- [15]
			"96813:111675:98966", -- [16]
			"96813:114718:92560:98124:98972", -- [17]
			"112866:111624:114666:100468", -- [18]
			"112866:111624:93447:100459", -- [19]
			"112866:111624:114666:100550:94973", -- [20]
			"112866:111624:114666:100550", -- [21]
			"96813:111675:98966:100559", -- [22]
			"111418:108888", -- [23]
			"111323:111420:98161:111314", -- [24]
			"111323:111420:98161:111327", -- [25]
			"96813:111675", -- [26]
			"112866:111624", -- [27]
			"111418:108888:110971", -- [28]
			"111323:111420", -- [29]
			"96813:114718", -- [30]
			"112866:111624:114666", -- [31]
			"112866:90556:90639:114837", -- [32]
			["m"] = 790,
			["coord"] = 1645180346,
			["direct"] = "112866:96813:111323:111418",
			["f"] = 0,
		},
		[111418] = {
			"108888:88110:90556", -- [1]
			"108888:110971:90639", -- [2]
			"108888:88110", -- [3]
			"108888:112866", -- [4]
			"108888:88110:90556:93447", -- [5]
			"108888:88110:90556:93447:93940", -- [6]
			"108888:112866:111624:114666:100550:95688", -- [7]
			"108888:112866:111624:111675:114718:92560", -- [8]
			"96813:111420:98105", -- [9]
			"108888:112866:111624:111675:98966:98124", -- [10]
			"96813:111420:98161", -- [11]
			"108888:112866:111624:114666:100550:94973:97860", -- [12]
			"108888:112866:111624:114666:100550:94973:97868", -- [13]
			"108888:112866:111624:114666:100550:97870", -- [14]
			"108888:112866:111624:114666:100550:94973:97868:98066", -- [15]
			"108888:112866:111624:114666:96565", -- [16]
			"108888:112866:111624:111675:98966", -- [17]
			"108888:112866:111624:114666:100550:94973:97860:98972", -- [18]
			"108888:112866:111624:114666:100468", -- [19]
			"108888:88110:90556:93447:100459", -- [20]
			"108888:112866:111624:114666:100550:94973", -- [21]
			"108888:112866:111624:114666:100550", -- [22]
			"108888:112866:111624:111675:98966:100559", -- [23]
			"96813:111420:98161:111314", -- [24]
			"96813:111323", -- [25]
			"108888:112866:111624:111675:98966:111327", -- [26]
			"108888:112866:111624:111675", -- [27]
			"108888:112866:111624", -- [28]
			"108888:110971", -- [29]
			"96813:111420", -- [30]
			"108888:112866:111624:111675:114718", -- [31]
			"108888:112866:111624:114666", -- [32]
			"108888:110971:90639:114837", -- [33]
			["direct"] = "96813:108888:112926",
			["coord"] = 2223034959,
			["m"] = 630,
			["f"] = 0,
		},
		[98066] = {
			"97870:100550:114666:90556", -- [1]
			"97870:100550:114666:90639", -- [2]
			"97870:100550:114666:90556:88110", -- [3]
			"97870:100550:114666:111624:112866", -- [4]
			"97870:100550:100468:100459:93447", -- [5]
			"97870:100550:100468:100459:93940", -- [6]
			"97868:95688", -- [7]
			"98972:98124:92560", -- [8]

			"98972:98124:92560:98105", -- [9]
			"98972:98124", -- [10]
			"98972:111327:98161", -- [11]
			"97870:100550:96565", -- [12]
			"97860:100559:98966", -- [13]
			"97870:100550:100468", -- [14]
			"97870:100550:100468:100459", -- [15]
			"97868:94973", -- [16]
			"97870:100550:114666:111675:96813", -- [17]
			"97870:100550", -- [18]
			"97860:100559", -- [19]
			"97870:100550:114666:111624:112866:108888", -- [20]
			"98972:111314", -- [21]
			"98972:98124:92560:114718:111323", -- [22]
			"98972:111327", -- [23]
			"97870:100550:114666:111675", -- [24]
			"97870:100550:114666:111624", -- [25]
			"97870:100550:114666:111624:112866:108888:111418", -- [26]
			"97870:100550:114666:90639:110971", -- [27]
			"98972:111327:98161:111420", -- [28]
			"97870:100550:114666:111624:112866:112926", -- [29]
			"98972:98124:92560:114718", -- [30]
			"97870:100550:114666", -- [31]
			"97870:100550:100468:100459:93940:114837", -- [32]
			"97868:98968", -- [14]
			"97870:107457:93940", -- [1]
			"97870:107457", -- [12]
			"107457:97870", -- [11]
			"107457:97870:98066", -- [12]
			"98972:98124:92560:114718:111323:120272", -- [1]
			"98972:98124:92560:114718:111323:120118", -- [2]
			["m"] = 650,
			["f"] = 0,
			["direct"] = "97860:97868:97870:98972:107457",
			["coord"] = 1799625409,
		},
		[100468] = {
			"100459:93447:90556", -- [1]
			"100459:93447:90639", -- [2]
			"100459:93447:90556:88110", -- [3]
			"114666:111624:112866", -- [4]
			"100459:93447", -- [5]
			"100459:93940", -- [6]
			"100550:95688", -- [7]
			"100550:95688:100559:92560", -- [8]
			"100550:95688:100559:92560:98105", -- [9]
			"100550:95688:100559:98124", -- [10]
			"100550:95688:100559:92560:98161", -- [11]
			"100550:94973:97860", -- [12]
			"100550:94973:97868", -- [13]
			"100550:97870", -- [14]
			"100550:94973:97868:98066", -- [15]
			"96565:98966", -- [16]
			"100550:94973:97860:98972", -- [17]
			"100550:94973", -- [18]
			"114666:111675:96813", -- [19]
			"100550:95688:100559", -- [20]
			"114666:111624:112866:108888", -- [21]
			"100550:95688:100559:98124:111327:111314", -- [22]
			"114666:111675:111323", -- [23]
			"100550:95688:100559:98124:111327", -- [24]
			"114666:111675", -- [25]
			"114666:111624", -- [26]
			"114666:111624:112866:108888:111418", -- [27]
			"100459:93447:90639:110971", -- [28]
			"96565:114718:111420", -- [29]
			"114666:111624:112866:112926", -- [30]
			"96565:114718", -- [31]
			"100459:93940:114837", -- [32]
			"100550:98968:97868", -- [7]
			"100550:98968:97868:98066", -- [8]
			"100550:98968", -- [9]			
			"100459:107457", -- [15]
			"114666:111675:111323:120272", -- [1]
			"114666:111675:111323:120118", -- [2]			
			["m"] = 641,
			["coord"] = 2963243589,
			["direct"] = "96565:100459:100550:114666",
			["f"] = 0,
		},
		[95688] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"100559:92560", -- [7]
			"100559:92560:98105", -- [8]
			"100559:98124", -- [9]
			"100559:92560:98161", -- [10]
			"94973:97868:98066", -- [11]
			"97860:98972", -- [12]
			"100550:100468", -- [13]
			"100550:100468:100459", -- [14]
			"96565:111675:96813", -- [15]
			"100550:114666:111624:112866:108888", -- [16]
			"100559:98124:111327:111314", -- [17]
			"96565:111675:111323", -- [18]
			"100559:98124:111327", -- [19]
			"96565:111675", -- [20]
			"100550:114666:111624", -- [21]
			"100550:114666:111624:112866:108888:111418", -- [22]
			"100550:114666:90639:110971", -- [23]
			"100559:92560:98105:111420", -- [24]
			"96565:111675:96813:112926", -- [25]
			"96565:114718", -- [26]
			"100550:114666", -- [27]
			"100550:100468:100459:93940:114837", -- [28]
			"94973:97870:107457", -- [6]
			"96565:111675:111323:120272", -- [1]
			"96565:111675:111323:120118", -- [2]			
			["m"] = 750,
			["coord"] = 1919771391,
			["direct"] = "97860:97868:97870:96565:98966:94973:100550:100559:98968",
			["f"] = 0,
		},
		[114718] = {
			"111675:90556", -- [1]
			"111675:90639", -- [2]
			"111675:90556:88110", -- [3]
			"111675:111624:112866", -- [4]
			"111675:114666:93447", -- [5]
			"111675:114666:100459:93940", -- [6]
			"96565:95688", -- [7]
			"111420:98105", -- [8]
			"92560:98124", -- [9]
			"92560:98161", -- [10]
			"92560:100559:97860", -- [11]
			"96565:100550:94973:97868", -- [12]
			"96565:100550:97870", -- [13]
			"92560:98124:98972:98066", -- [14]
			"92560:98124:98972", -- [15]
			"96565:100468", -- [16]
			"111675:114666:100459", -- [17]
			"96565:100550:94973", -- [18]
			"96565:100550", -- [19]
			"92560:100559", -- [20]
			"111675:111624:112866:108888", -- [21]
			"92560:98161:111314", -- [22]
			"92560:111327", -- [23]
			"111675:111624", -- [24]
			"96813:111418", -- [25]
			"111675:90556:88110:110971", -- [26]
			"96813:112926", -- [27]
			"111675:114666", -- [28]
			"111675:90639:114837", -- [29]
			"96565:100550:98968:97868", -- [8]
			"96565:100550:98968", -- [10]
			"111675:114666:100459:107457", -- [7]
			"111323:120272", -- [1]
			"111323:120118", -- [2]			
			["m"] = 680,
			["f"] = 0,
			["direct"] = "92560:96565:98966:96813:111323:111675:111420",
			["coord"] = 2758765422,
		},
		[98972] = {
			"97860:95688:100550:114666:90556", -- [1]
			"97860:95688:100550:114666:90639", -- [2]
			"97860:95688:100550:114666:90556:88110", -- [3]
			"97860:95688:100550:114666:111624:112866", -- [4]
			"97860:95688:100550:100468:100459:93447", -- [5]
			"97860:95688:100550:100468:100459:93940", -- [6]
			"97860:95688", -- [7]
			"98124:92560", -- [8]
			"98124:92560:98105", -- [9]
			"111327:98161", -- [10]
			"97868:97870", -- [11]
			"97860:95688:96565", -- [12]
			"97860:100559:98966", -- [13]
			"97860:95688:100550:100468", -- [14]
			"97860:95688:100550:100468:100459", -- [15]
			"97860:94973", -- [16]
			"98124:92560:114718:96813", -- [17]
			"97860:95688:100550", -- [18]
			"97860:100559", -- [19]
			"97860:95688:100550:114666:111624:112866:108888", -- [20]
			"98124:92560:114718:111323", -- [21]
			"97860:95688:96565:111675", -- [22]
			"97860:95688:100550:114666:111624", -- [23]
			"97860:95688:100550:114666:111624:112866:108888:111418", -- [24]
			"97860:95688:100550:114666:90639:110971", -- [25]
			"111327:98161:111420", -- [26]
			"98124:92560:114718:96813:112926", -- [27]
			"98124:92560:114718", -- [28]
			"97860:95688:100550:114666", -- [29]
			"97860:95688:100550:100468:100459:93940:114837", -- [30]
			"97868:98968", -- [14]
			"97868:97870:107457", -- [20]
			"98124:92560:114718:111323:120272", -- [1]
			"98124:92560:114718:111323:120118", -- [2]			
			["m"] = 650,
			["f"] = 0,
			["direct"] = "98124:97860:97868:98066:111314:111327",
			["coord"] = 2493204809,
		},
		[93940] = {
			"93447:90556", -- [1]
			"93447:90556:88110", -- [2]
			"93447:90556:112866", -- [3]
			"100459:100468:100550:95688", -- [4]
			"100459:100468:100550:95688:100559:92560", -- [5]
			"100459:100468:100550:95688:100559:92560:98105", -- [6]
			"100459:100468:100550:95688:100559:98124", -- [7]
			"100459:100468:100550:95688:100559:92560:98161", -- [8]
			"100459:100468:100550:94973:97860", -- [9]
			"100459:100468:100550:94973:97868", -- [10]
			"100459:100468:100550:97870", -- [11]
			"100459:100468:100550:94973:97868:98066", -- [12]
			"100459:100468:96565", -- [13]
			"100459:100468:96565:98966", -- [14]
			"100459:100468:100550:94973:97860:98972", -- [15]
			"100459:100468", -- [16]
			"100459:100468:100550:94973", -- [17]
			"93447:111624:96813", -- [18]
			"100459:100468:100550", -- [19]
			"100459:100468:100550:95688:100559", -- [20]
			"93447:90556:88110:108888", -- [21]
			"100459:100468:100550:95688:100559:98124:111327:111314", -- [22]
			"100459:114666:111675:111323", -- [23]
			"100459:100468:100550:95688:100559:98124:111327", -- [24]
			"100459:114666:111675", -- [25]
			"93447:111624", -- [26]
			"93447:90556:88110:108888:111418", -- [27]
			"90639:110971", -- [28]
			"100459:114666:111675:114718:111420", -- [29]
			"93447:90556:112866:112926", -- [30]
			"100459:114666:111675:114718", -- [31]
			"100459:114666", -- [32]
			"93447:111624:96813:120272", -- [1]
			"100459:114666:111675:111323:120118", -- [2]			
			["m"] = 641,
			["coord"] = 1816434143,
			["direct"] = "90639:93447:100459:114837",
			["f"] = 0,
		},
		[100559] = {
			"98966:96565:114666:90556", -- [1]
			"98966:96565:114666:90639", -- [2]
			"98966:96565:114666:90556:88110", -- [3]
			"98966:111675:111624:112866", -- [4]
			"95688:100550:100468:100459:93447", -- [5]
			"95688:100550:100468:100459:93940", -- [6]
			"92560:98105", -- [7]
			"92560:98161", -- [8]
			"95688:94973:97868", -- [9]
			"95688:94973:97870", -- [10]
			"97860:98066", -- [11]
			"98966:96565", -- [12]
			"97860:98972", -- [13]
			"95688:100550:100468", -- [14]
			"95688:100550:100468:100459", -- [15]
			"95688:94973", -- [16]
			"92560:114718:96813", -- [17]
			"95688:100550", -- [18]
			"98966:111675:111624:112866:108888", -- [19]
			"98124:111327:111314", -- [20]
			"92560:114718:111323", -- [21]
			"98966:111675", -- [22]
			"98966:111675:111624", -- [23]
			"98966:111675:111624:112866:108888:111418", -- [24]
			"98966:96565:114666:90639:110971", -- [25]
			"92560:98105:111420", -- [26]
			"92560:114718:96813:112926", -- [27]
			"92560:114718", -- [28]
			"98966:96565:114666", -- [29]
			"95688:100550:100468:100459:93940:114837", -- [30]
			"95688:94973:98968", -- [10]			
			"95688:94973:97870:107457", -- [9]
			"92560:114718:111323:120272", -- [1]
			"92560:114718:111323:120118", -- [2]			
			["m"] = 650,
			["f"] = 0,
			["direct"] = "95688:92560:98124:97860:98966:111327",
			["coord"] = 2544608943,
		},
		[97870] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"94973:95688:100559:92560", -- [7]
			"94973:95688:100559:92560:98105", -- [8]
			"94973:95688:100559:98124", -- [9]
			"94973:95688:100559:92560:98161", -- [10]
			"97868:97860", -- [11]
			"100550:96565", -- [12]
			"94973:95688:98966", -- [13]
			"97868:98972", -- [14]
			"100550:100468", -- [15]
			"100550:100468:100459", -- [16]
			"100550:114666:111675:96813", -- [17]
			"94973:95688:100559", -- [18]
			"100550:114666:111624:112866:108888", -- [19]
			"97868:98972:111314", -- [20]
			"100550:114666:111675:111323", -- [21]
			"94973:95688:100559:98124:111327", -- [22]
			"100550:114666:111675", -- [23]
			"100550:114666:111624", -- [24]
			"100550:114666:111624:112866:108888:111418", -- [25]
			"100550:114666:90639:110971", -- [26]
			"94973:95688:100559:92560:98105:111420", -- [27]
			"100550:114666:111624:112866:112926", -- [28]
			"100550:96565:114718", -- [29]
			"100550:114666", -- [30]
			"100550:100468:100459:93940:114837", -- [31]
			"107457:93940", -- [1]
			"100550:114666:111675:111323:120272", -- [1]
			"100550:114666:111675:111323:120118", -- [2]			
			["m"] = 650,
			["f"] = 0,
			["direct"] = "95688:97868:98066:94973:100550:98968:107457",
			["coord"] = 1286038703,
		},
		[111675] = {
			"90556:88110", -- [1]
			"111624:112866", -- [2]
			"114666:93447", -- [3]
			"114666:100459:93940", -- [4]
			"114666:100550:95688", -- [5]
			"114718:92560", -- [6]
			"114718:111420:98105", -- [7]
			"98966:98124", -- [8]
			"114718:92560:98161", -- [9]
			"98966:97860", -- [10]
			"114666:100550:94973:97868", -- [11]
			"114666:100550:97870", -- [12]
			"114666:100550:94973:97868:98066", -- [13]
			"98966:97860:98972", -- [14]
			"114666:100468", -- [15]
			"114666:100459", -- [16]
			"114666:100550:94973", -- [17]
			"114666:100550", -- [18]
			"98966:100559", -- [19]
			"111624:112866:108888", -- [20]
			"114718:92560:98161:111314", -- [21]
			"98966:111327", -- [22]
			"111624:112866:108888:111418", -- [23]
			"90556:88110:110971", -- [24]
			"114718:111420", -- [25]
			"96813:112926", -- [26]
			"90639:114837", -- [27]
			"114666:100550:98968:97868", -- [2]
			"114666:100550:98968:97868:98066", -- [3]
			"114666:100550:98968", -- [4]
			"114666:100459:107457", -- [18]
			"111323:120272", -- [1]
			"111323:120118", -- [2]			
			["m"] = 680,
			["coord"] = 1475313302,
			["direct"] = "90556:90639:96565:98966:96813:111323:111624:114718:114666",
			["f"] = 0,
		},
		[111624] = {
			"90556:88110", -- [1]
			"93447:93940", -- [2]
			"114666:100550:95688", -- [3]
			"111675:114718:92560", -- [4]
			"111675:114718:111420:98105", -- [5]
			"111675:98966:98124", -- [6]
			"111675:114718:92560:98161", -- [7]
			"114666:100550:94973:97860", -- [8]
			"114666:100550:94973:97868", -- [9]
			"114666:100550:97870", -- [10]
			"114666:100550:94973:97868:98066", -- [11]
			"114666:96565", -- [12]
			"111675:98966", -- [13]
			"114666:100550:94973:97860:98972", -- [14]
			"114666:100468", -- [15]
			"93447:100459", -- [16]
			"114666:100550:94973", -- [17]
			"114666:100550", -- [18]
			"111675:98966:100559", -- [19]
			"112866:108888", -- [20]
			"111675:114718:92560:98161:111314", -- [21]
			"96813:111323", -- [22]
			"111675:98966:111327", -- [23]
			"112866:108888:111418", -- [24]
			"90556:88110:110971", -- [25]
			"111675:114718:111420", -- [26]
			"112866:112926", -- [27]
			"111675:114718", -- [28]
			"90639:114837", -- [29]
			"96813:111323:93465", -- [30]
			"114666:100550:98968:97868", -- [1]
			"114666:100550:98968:97868:98066", -- [2]
			"114666:100550:98968", -- [3]			
			"93447:100459:107457", -- [17]
			"96813:120272", -- [1]
			"96813:111323:120118", -- [2]			
			["m"] = 630,
			["coord"] = 2739030261,
			["direct"] = "90556:90639:112866:93447:96813:111675:114666",
			["f"] = 0,
		},
		[114837] = {
			"90639:90556", -- [1]
			"90639:90556:88110", -- [2]
			"90639:90556:112866", -- [3]
			"93940:93447", -- [4]
			"93940:100459:100468:100550:95688", -- [5]
			"93940:100459:100468:100550:95688:100559:92560", -- [6]
			"93940:100459:100468:100550:95688:100559:92560:98105", -- [7]
			"93940:100459:100468:100550:95688:100559:98124", -- [8]
			"93940:100459:100468:100550:95688:100559:92560:98161", -- [9]
			"93940:100459:100468:100550:94973:97860", -- [10]
			"93940:100459:100468:100550:94973:97868", -- [11]
			"93940:100459:100468:100550:97870", -- [12]
			"93940:100459:100468:100550:94973:97868:98066", -- [13]
			"93940:100459:100468:96565", -- [14]
			"93940:100459:100468:96565:98966", -- [15]
			"93940:100459:100468:100550:94973:97860:98972", -- [16]
			"93940:100459:100468", -- [17]
			"93940:100459", -- [18]
			"93940:100459:100468:100550:94973", -- [19]
			"90639:111624:96813", -- [20]
			"93940:100459:100468:100550", -- [21]
			"93940:100459:100468:100550:95688:100559", -- [22]
			"90639:110971:108888", -- [23]
			"93940:100459:100468:100550:95688:100559:98124:111327:111314", -- [24]
			"93940:100459:114666:111675:111323", -- [25]
			"93940:100459:100468:100550:95688:100559:98124:111327", -- [26]
			"93940:100459:114666:111675", -- [27]
			"90639:111624", -- [28]
			"90639:110971:108888:111418", -- [29]
			"90639:110971", -- [30]
			"93940:100459:114666:111675:114718:111420", -- [31]
			"90639:90556:112866:112926", -- [32]
			"93940:100459:114666:111675:114718", -- [33]
			"93940:100459:114666", -- [34]
			"90639:111624:96813:120272", -- [5]
			"93940:100459:114666:111675:111323:120118", -- [6]			
			["direct"] = "90639:93940",
			["coord"] = 1115662876,
			["m"] = 641,
			["f"] = 0,
		},
		[114666] = {
			"90556:88110", -- [1]
			"111624:112866", -- [2]
			"100459:93940", -- [3]
			"100550:95688", -- [4]
			"111675:114718:92560", -- [5]
			"111675:114718:111420:98105", -- [6]
			"96565:98966:98124", -- [7]
			"111675:114718:92560:98161", -- [8]
			"100550:94973:97860", -- [9]
			"100550:94973:97868", -- [10]
			"100550:97870", -- [11]
			"100550:94973:97868:98066", -- [12]
			"96565:98966", -- [13]
			"100550:94973:97860:98972", -- [14]
			"100550:94973", -- [15]
			"111675:96813", -- [16]
			"96565:98966:100559", -- [17]
			"111624:112866:108888", -- [18]
			"96565:98966:111327:111314", -- [19]
			"111675:111323", -- [20]
			"96565:98966:111327", -- [21]
			"111624:112866:108888:111418", -- [22]
			"90639:110971", -- [23]
			"111675:114718:111420", -- [24]
			"111624:112866:112926", -- [25]
			"111675:114718", -- [26]
			"100459:93940:114837", -- [27]
			"111675:114718:93465", -- [28]
			"100550:98968:97868", -- [5]
			"100550:98968:97868:98066", -- [6]
			"100550:98968", -- [7]			
			"100459:107457", -- [15]
			"111675:111323:120272", -- [8]
			"111675:111323:120118", -- [9]		
			"111675:111323:120272", -- [1]
			"111675:111323:120118", -- [2]			
			["m"] = 680,
			["coord"] = 1095979364,
			["direct"] = "90556:90639:93447:96565:100468:100459:100550:111675:111624",
			["f"] = 0,
		},
		[111420] = {
			"114718:111675:90556", -- [1]
			"114718:111675:90639", -- [2]
			"114718:111675:90556:88110", -- [3]
			"96813:112866", -- [4]
			"114718:111675:114666:93447", -- [5]
			"114718:111675:114666:100459:93940", -- [6]
			"98105:92560:100559:95688", -- [7]
			"98105:92560", -- [8]
			"98105:92560:98124", -- [9]
			"98105:92560:100559:97860", -- [10]
			"98105:92560:100559:95688:94973:97868", -- [11]
			"98105:92560:100559:95688:94973:97870", -- [12]
			"98105:92560:98124:98972:98066", -- [13]
			"114718:96565", -- [14]
			"98105:92560:98966", -- [15]
			"98105:92560:98124:98972", -- [16]
			"114718:96565:100468", -- [17]
			"114718:111675:114666:100459", -- [18]
			"98105:92560:100559:95688:94973", -- [19]
			"98105:92560:100559:95688:100550", -- [20]
			"98105:92560:100559", -- [21]
			"96813:112866:108888", -- [22]
			"98161:111314", -- [23]
			"98161:111327", -- [24]
			"114718:111675", -- [25]
			"114718:111675:111624", -- [26]
			"96813:111418", -- [27]
			"114718:111675:90556:88110:110971", -- [28]
			"111323:112926", -- [29]
			"114718:111675:114666", -- [30]
			"114718:111675:90639:114837", -- [31]
			"98105:92560:100559:95688:94973:98968", -- [16]
			"114718:111675:114666:100459:107457", -- [22]
			"111323:120272", -- [1]
			"111323:120118", -- [2]			
			["m"] = 634,
			["f"] = 0,
			["direct"] = "98105:98108:98161:96813:111323:114718",
			["coord"] = 2387795914,
		},
		[98124] = {
			"98966:96565:114666:90556", -- [1]
			"98966:96565:114666:90639", -- [2]
			"98966:96565:114666:90556:88110", -- [3]
			"98966:111675:111624:112866", -- [4]
			"98966:96565:114666:93447", -- [5]
			"100559:95688:100550:100468:100459:93940", -- [6]
			"100559:95688", -- [7]
			"92560:98105", -- [8]
			"111327:98161", -- [9]
			"97860:97868", -- [10]
			"100559:95688:94973:97870", -- [11]
			"98972:98066", -- [12]
			"98966:96565", -- [13]
			"100559:95688:100550:100468", -- [14]
			"100559:95688:100550:100468:100459", -- [15]
			"100559:95688:94973", -- [16]
			"92560:114718:96813", -- [17]
			"100559:95688:100550", -- [18]
			"98966:111675:111624:112866:108888", -- [19]
			"111327:111314", -- [20]
			"92560:114718:111323", -- [21]
			"98966:111675", -- [22]
			"98966:111675:111624", -- [23]
			"92560:114718:96813:111418", -- [24]
			"98966:96565:114666:90639:110971", -- [25]
			"92560:98105:111420", -- [26]
			"92560:114718:96813:112926", -- [27]
			"92560:114718", -- [28]
			"98966:96565:114666", -- [29]
			"100559:95688:100550:100468:100459:93940:114837", -- [30]
			"97860:98968", -- [10]
			"100559:95688:94973:97870:107457", -- [10]
			"92560:114718:111323:120272", -- [1]
			"92560:114718:111323:120118", -- [2]			
			["m"] = 634,
			["f"] = 0,
			["direct"] = "92560:97860:98966:98972:100559:111327",
			["coord"] = 1568099994,
		},
		[98161] = {
			"92560:114718:111675:90556", -- [1]
			"92560:114718:111675:90639", -- [2]
			"92560:114718:111675:90556:88110", -- [3]
			"92560:114718:111675:111624:112866", -- [4]
			"92560:114718:111675:114666:93447", -- [5]
			"92560:114718:111675:114666:100459:93940", -- [6]
			"92560:100559:95688", -- [7]
			"111327:98124", -- [8]
			"111327:98124:97860", -- [9]
			"92560:100559:95688:94973:97868", -- [10]
			"92560:100559:95688:94973:97870", -- [11]
			"111327:98972:98066", -- [12]
			"92560:98966:96565", -- [13]
			"92560:98966", -- [14]
			"111327:98972", -- [15]
			"92560:100559:95688:100550:100468", -- [16]
			"92560:114718:111675:114666:100459", -- [17]
			"92560:100559:95688:94973", -- [18]
			"92560:114718:96813", -- [19]
			"92560:100559:95688:100550", -- [20]
			"92560:100559", -- [21]
			"92560:114718:111675:111624:112866:108888", -- [22]
			"111420:111323", -- [23]
			"92560:114718:111675", -- [24]
			"92560:114718:111675:111624", -- [25]
			"92560:114718:96813:111418", -- [26]
			"92560:114718:111675:90556:88110:110971", -- [27]
			"92560:114718:96813:112926", -- [28]
			"92560:114718", -- [29]
			"92560:114718:111675:114666", -- [30]
			"92560:114718:111675:90639:114837", -- [31]
			"92560:100559:95688:94973:98968", -- [12]
			"92560:114718:111675:114666:100459:107457", -- [18]
			"111420:111323:120272", -- [1]
			"111420:111323:120118", -- [2]			
			["m"] = 634,
			["f"] = 0,
			["direct"] = "92560:98105:111314:111327:111420",
			["coord"] = 2606596687,
		},
		[100550] = {
			"98968:97868", -- [7]
			"98968:97868:98066", -- [8]		
			"114666:90556", -- [1]
			"114666:90639", -- [2]
			"114666:90556:88110", -- [3]
			"114666:111624:112866", -- [4]
			"100468:100459:93447", -- [5]
			"100468:100459:93940", -- [6]
			"95688:100559:92560", -- [7]
			"95688:100559:92560:98105", -- [8]
			"95688:100559:98124", -- [9]
			"95688:100559:92560:98161", -- [10]
			"94973:97860", -- [11]
			"94973:97868", -- [12]
			"94973:97868:98066", -- [13]
			"96565:98966", -- [14]
			"94973:97860:98972", -- [15]
			"100468:100459", -- [16]
			"114666:111675:96813", -- [17]
			"95688:100559", -- [18]
			"114666:111624:112866:108888", -- [19]
			"95688:100559:98124:111327:111314", -- [20]
			"114666:111675:111323", -- [21]
			"95688:100559:98124:111327", -- [22]
			"114666:111675", -- [23]
			"114666:111624", -- [24]
			"114666:111624:112866:108888:111418", -- [25]
			"114666:90639:110971", -- [26]
			"96565:114718:111420", -- [27]
			"114666:111624:112866:112926", -- [28]
			"96565:114718", -- [29]
			"100468:100459:93940:114837", -- [30]
			"96565:114718:93465", -- [31]
			"100468:100459:107457", -- [12]
			["m"] = 650,
			["f"] = 0,
			["direct"] = "95688:97870:96565:100468:94973:114666",
			["coord"] = 1540597954,
		},
		[111314] = {
			"98161:92560:114718:111675:90556", -- [1]
			"98161:92560:114718:111675:90639", -- [2]
			"98161:92560:114718:111675:90556:88110", -- [3]
			"98161:92560:114718:111675:111624:112866", -- [4]
			"97860:95688:100550:100468:100459:93447", -- [5]
			"97860:95688:100550:100468:100459:93940", -- [6]
			"97860:95688", -- [7]
			"98161:92560", -- [8]
			"98161:98105", -- [9]
			"111327:98124", -- [10]
			"97860:97868", -- [11]
			"97860:94973:97870", -- [12]
			"98972:98066", -- [13]
			"111327:98966:96565", -- [14]
			"111327:98966", -- [15]
			"97860:95688:100550:100468", -- [16]
			"97860:95688:100550:100468:100459", -- [17]
			"97860:94973", -- [18]
			"98161:92560:114718:96813", -- [19]
			"97860:95688:100550", -- [20]
			"111327:100559", -- [21]
			"98161:92560:114718:111675:111624:112866:108888", -- [22]
			"98161:111420:111323", -- [23]
			"98161:92560:114718:111675", -- [24]
			"98161:92560:114718:111675:111624", -- [25]
			"98161:92560:114718:96813:111418", -- [26]
			"98161:92560:114718:111675:90556:88110:110971", -- [27]
			"98161:111420", -- [28]
			"98161:92560:114718:96813:112926", -- [29]
			"98161:92560:114718", -- [30]
			"111327:98966:96565:114666", -- [31]
			"97860:95688:100550:100468:100459:93940:114837", -- [32]
			"98108:111420:93465", -- [33]
			"98108:111420:111323:120272", -- [2]
			"98108:111420:111323:120118", -- [3]			
			["m"] = 634,
			["f"] = 0,
			["direct"] = "98161:97860:98972:111327",
			["coord"] = 3861650254,
		},
		[96813] = {
			"111624:90556", -- [1]
			"111624:90639", -- [2]
			"112866:88110", -- [3]
			"111624:93447", -- [4]
			"111624:93447:93940", -- [5]
			"111675:114666:100550:95688", -- [6]
			"114718:92560", -- [7]
			"111420:98105", -- [8]
			"114718:92560:98124", -- [9]
			"111420:98161", -- [10]
			"111675:98966:97860", -- [11]
			"111675:114666:100550:94973:97868", -- [12]
			"111675:114666:100550:97870", -- [13]
			"111675:114666:100550:94973:97868:98066", -- [14]
			"111675:96565", -- [15]
			"111675:98966", -- [16]
			"114718:92560:98124:98972", -- [17]
			"111675:114666:100468", -- [18]
			"111624:93447:100459", -- [19]
			"111675:114666:100550:94973", -- [20]
			"111675:114666:100550", -- [21]
			"111675:98966:100559", -- [22]
			"112866:108888", -- [23]
			"111420:98161:111314", -- [24]
			"114718:92560:111327", -- [25]
			"112866:88110:110971", -- [26]
			"111675:114666", -- [27]
			"111624:90639:114837", -- [28]
			"111323:93465", -- [29]
			"111675:114666:100550:98968:97868", -- [1]
			"111675:114666:100550:98968:97868:98066", -- [2]
			"111675:114666:100550:98968", -- [3]			
			"111624:93447:100459:107457", -- [1]
			"111323:120118", -- [1]
			["m"] = 627,
			["coord"] = 3012264314,
			["direct"] = "112866:111323:111675:111624:111418:111420:112926:114718",
			["f"] = 0,
		},
		[109467] = {
			"109457:109451", -- [1]
			"109469:109558", -- [2]
			"109469:109558:109561", -- [3]
			"109457:109451:109789:109572:109571", -- [4]
			"109457:109451:109789:109572", -- [5]
			"109457:109451:109789", -- [6]
			["m"] = 680,
			["f"] = 0,
			["direct"] = "109457:109469",
			["coord"] = 3014899171,
			requirements = "cls:HUNTER"
		},
		[109558] = {
			"109469:109467:109457", -- [1]
			"109469:109467:109457:109451", -- [2]
			"109469:109467", -- [3]
			"109561:109571", -- [4]
			"109561:109571:109572", -- [5]
			"109469:109467:109457:109451:109789", -- [6]
			["m"] = 630,
			["f"] = 0,
			["direct"] = "109469:109561",
			["coord"] = 2188889228,
			requirements = "cls:HUNTER"
		},
		[109469] = {
			"109467:109457", -- [1]
			"109467:109457:109451", -- [2]
			"109558:109561", -- [3]
			"109558:109561:109571", -- [4]
			"109467:109457:109451:109789:109572", -- [5]
			"109467:109457:109451:109789", -- [6]
			["m"] = 680,
			["f"] = 0,
			["direct"] = "109467:109558",
			["coord"] = 1775293492,
			requirements = "cls:HUNTER"
		},
		[109561] = {
			"109558:109469:109467:109457", -- [1]
			"109571:109572:109789:109451", -- [2]
			"109558:109469:109467", -- [3]
			"109558:109469", -- [4]
			"109571:109572", -- [5]
			"109571:109572:109789", -- [6]
			["m"] = 630,
			["f"] = 0,
			["direct"] = "109558:109571",
			["coord"] = 1053912676,
			requirements = "cls:HUNTER"
		},
		[109457] = {
			"109467:109469", -- [1]
			"109467:109469:109558", -- [2]
			"109467:109469:109558:109561", -- [3]
			"109451:109789:109572:109571", -- [4]
			"109451:109789:109572", -- [5]
			"109451:109789", -- [6]
			["m"] = 634,
			["f"] = 0,
			["direct"] = "109451:109467",
			["coord"] = 1635895994,
			requirements = "cls:HUNTER"
		},
		[109789] = {
			"109451:109457", -- [1]
			"109451:109457:109467", -- [2]
			"109451:109457:109467:109469", -- [3]
			"109451:109457:109467:109469:109558", -- [4]
			"109572:109571:109561", -- [5]
			"109572:109571", -- [6]
			["m"] = 650,
			["f"] = 0,
			["direct"] = "109451:109572",
			["coord"] = 2433723769,
			requirements = "cls:HUNTER"
		},
		[109572] = {
			"109789:109451:109457", -- [1]
			"109789:109451", -- [2]
			"109789:109451:109457:109467", -- [3]
			"109789:109451:109457:109467:109469", -- [4]
			"109571:109561:109558", -- [5]
			"109571:109561", -- [6]
			["m"] = 739,
			["direct"] = "109571:109789",
			["coord"] = 1708018224,
			["f"] = 0,
			requirements = "cls:HUNTER",
		},
		[109571] = {
			"109572:109789:109451:109457", -- [1]
			"109572:109789:109451", -- [2]
			"109572:109789:109451:109457:109467", -- [3]
			"109561:109558:109469", -- [4]
			"109561:109558", -- [5]
			"109572:109789", -- [6]
			["m"] = 641,
			["f"] = 0,
			["direct"] = "109561:109572",
			["coord"] = 1894393429,
			requirements = "cls:HUNTER"
		},
		[109451] = {
			"109457:109467", -- [1]
			"109457:109467:109469", -- [2]
			"109457:109467:109469:109558", -- [3]
			"109789:109572:109571:109561", -- [4]
			"109789:109572:109571", -- [5]
			"109789:109572", -- [6]
			["m"] = 634,
			["f"] = 0,
			["direct"] = "109457:109789",
			["coord"] = 1972394897,
			requirements = "cls:HUNTER"
		},
		[98968] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"95688:100559:92560", -- [7]
			"95688:100559:92560:98105", -- [8]
			"97860:98124", -- [9]
			"97860:98124:111327:98161", -- [10]
			"97868:98066", -- [11]
			"100550:96565", -- [12]
			"95688:98966", -- [13]
			"97868:98972", -- [14]
			"100550:100468", -- [15]
			"100550:100468:100459", -- [16]
			"100550:114666:111675:96813", -- [17]
			"95688:100559", -- [18]
			"97860:98124:111327", -- [19]
			"100550:114666:111675", -- [20]
			"100550:114666:111624", -- [21]
			"100550:114666:90639:110971", -- [22]
			"95688:100559:92560:98105:111420", -- [23]
			"100550:96565:114718", -- [24]
			"100550:114666", -- [25]
			["m"] = 739,
			["f"] = 0,
			["direct"] = "95688:97860:97868:97870:94973:100550",
			["coord"] = 1563641753,
			requirements = "cls:HUNTER"
		},
		[107457] = {
			"100459:93447:90556", -- [1]
			"93940:90639", -- [2]
			"100459:93447:90556:88110", -- [3]
			"100459:93447:90556:112866", -- [4]
			"100459:93447", -- [5]
			"100459:100468:100550:95688", -- [6]
			"100459:100468:100550:95688:100559:92560", -- [7]
			"100459:100468:100550:95688:100559:92560:98105", -- [8]
			"100459:100468:100550:95688:100559:98124", -- [9]
			"100459:100468:100550:95688:100559:92560:98161", -- [10]
			"97870:97868:97860", -- [11]
			"97870:97868", -- [12]
			"97870:98066", -- [13]
			"100459:100468:96565", -- [14]
			"100459:100468:96565:98966", -- [15]
			"97870:97868:98972", -- [16]
			"100459:100468", -- [17]
			"100459:100468:100550:94973", -- [18]
			"100459:114666:111675:96813", -- [19]
			"100459:100468:100550", -- [20]
			"100459:100468:100550:95688:100559", -- [21]
			"100459:100468:100550:95688:100559:98124:111327", -- [22]
			"100459:114666:111675", -- [23]
			"100459:93447:111624", -- [24]
			"93940:90639:110971", -- [25]
			"100459:114666:111675:114718:111420", -- [26]
			"100459:114666:111675:114718", -- [27]
			"100459:114666", -- [28]
			["m"] = 747,
			["coord"] = 2676053642,
			["direct"] = "93940:97870:100459",
			["f"] = 0,
			requirements = "cls:DRUID"
		},		
	},	
	[9] = {
		[118830] = {
			--["name"] = "Krokul Hovel, Krokuun",
			["direct"] = "123139:123260:124569:124313:122509:125407:125410:126951",
			["m"] = 830,
			["coord"] = 2383064171,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125461] = {
			--["name"] = "Vindicaar, Mac'Aree",
			["direct"] = "118830:123139:123260:124569:124313:122509:125407:125410:125514:126951",
			["m"] = 883,
			["coord"] = 2091072516,
			["f"] = 0,
			["isSpaceship"] = true,
		},
		[122509] = {
			--["name"] = "Triumvirate's End, Mac'Aree",
			["direct"] = "118830:123260:124569:125461:124313:125407:125410:126951",
			["m"] = 882,
			["coord"] = 2270347563,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[123260] = {
			--["name"] = "Shattered Fields, Krokuun",
			["direct"] = "118830:123139:124569:124313:122509:125407:125410:126951",
			["m"] = 830,
			["coord"] = 1731109521,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[126951] = {
			--["name"] = "City Center, Mac'Aree",
			["direct"] = "118830:123260:124569:125461:124313:122509:125407:125410",
			["m"] = 882,
			["coord"] = 2020118034,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125407] = {
			--["name"] = "Hope's Landing, Antoran Wastes",
			["direct"] = "118830:123260:124569:124313:122509:125410:125514:126951",
			["m"] = 885,
			["coord"] = 3133768023,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[124313] = {
			--["name"] = "Conservatory of the Arcane, Mac'Aree",
			["direct"] = "118830:123260:124569:125461:122509:125407:125410:126951",
			["m"] = 882,
			["coord"] = 2699191586,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[124569] = {
			--["name"] = "Destiny Point, Krokuun",
			["direct"] = "118830:123139:123260:124313:122509:125407:125410:126951",
			["m"] = 830,
			["coord"] = 2692513213,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125410] = { --Dynamic
			--["name"] = "Light's Purchase, Antoran Wastes",
			["direct"] = "118830:123260:124569:124313:122509:125407:125514:126951",
			["m"] = 885,
			["coord"] = 3119956734,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125514] = {
			--["name"] = "Vindicaar, Antoran Wastes",
			["direct"] = "118830:123139:123260:124569:125461:124313:122509:125407:125410:126951",
			["m"] = 886,
			["coord"] = 1407291736,
			["f"] = 0,
			["isSpaceship"] = true,
		},
		[123139] = {
			["m"] = 831,
			["direct"] = "118830:123260:124569:125461:124313:122509:125407:125410:125514:126951",
			["coord"] = 1809529829,
			["f"] = 0,
			["isSpaceship"] = true,
		},
		[125409] = { --Dynamic
            --["name"] = "The Veiled Den, Antoran Wastes",
			["m"] = 885,
			["f"] = 0,
			["direct"] = "118830:123260:124569:124313:122509:125407:125514:126951",
			["coord"] = 3034464598,
			["isBeacon"] = true,
		}, 
	},
	[875] = {
		[128695] = {
			"129365:124107:121828", -- [1]
			"129365:124107:122191", -- [2]
			"129365:124107:122191:121207", -- [3]
			"129365:124107:122191:121207:122198", -- [4]
			"129365:135654:128334:130787:122689:121252", -- [5]
			"129365:135654:128334:130787:122689", -- [6]
			"129365:124107:121828:123006", -- [7]
			"129365:135654:128334:130787:122689:123060", -- [8]
			"129365:135654:128334:130787:122689:127818:123817", -- [9]
			"129365:124107:122191:121207:124456", -- [10]
			"129365:135654:128334:130787:122689:127818", -- [11]
			"129365:135654:128334:130787:129483", -- [12]
			"129365:135654:128334:130787", -- [13]
			"129365:135654:128334:130787:130790", -- [14]
			"129365:135654:128334:130787:133242", -- [15]
			"129365:135654:128334:130787:122689:121252:134008", -- [16]
			"129365:135654:128334:130787:122689:123060:134011", -- [17]
			"129365:124107", -- [18]
			"129365:135654:128334", -- [19]
			"135385:135387", -- [20]
			"129365:124107:121828:123006:136331", -- [21]
			"129365:135654", -- [22]
			"129365:135654:128334:130787:122689:121252:140653:140650", -- [23]
			"129365:135654:128334:130787:122689:121252:140653", -- [24]
			["m"] = 864,
			["direct"] = "135385:129365",
			["coord"] = 1187873011,
			["f"] = 0,
		},	
		[130790] = {
			"130787:121828", -- [1]
			"130787:121828:122191", -- [2]
			"130787:121828:121207", -- [3]
			"130787:121828:121207:122198", -- [4]
			"122689:121252", -- [5]
			"130787:123006", -- [6]
			"122689:123060", -- [7]
			"122689:127818:123817", -- [8]
			"130787:123006:124456", -- [9]
			"122689:127818", -- [10]
			"122689:133242", -- [11]
			"122689:121252:134008", -- [12]
			"122689:123060:134011", -- [13]
			"130787:121828:124107:135385", -- [14]
			"130787:121828:124107", -- [15]
			"130787:128334", -- [16]
			"130787:128334:135654:129365:128695", -- [17]
			"130787:121828:122191:135387", -- [18]
			"122689:133242:136331", -- [19]
			"130787:128334:135654", -- [20]
			"130787:128334:135654:129365", -- [21]
			"122689:121252:140653:140650", -- [22]
			"122689:121252:140653", -- [23]
			["m"] = 862,
			["direct"] = "122689:129483:130787",
			["coord"] = 1982028733,
			["f"] = 0,
		},	
		[134011] = {
			"136331:123006:121828", -- [1]
			"136331:123006:121828:122191", -- [2]
			"124456:121207", -- [3]
			"124456:121207:122198", -- [4]
			"123060:121252", -- [5]
			"123060:122689", -- [6]
			"136331:123006", -- [7]
			"123060:121252:127818:123817", -- [8]
			"123060:121252:127818", -- [9]
			"123060:133242:129483", -- [10]
			"123060:133242:130787", -- [11]
			"123060:133242", -- [12]
			"136331:123006:121828:124107:135385", -- [13]
			"136331:123006:121828:124107", -- [14]
			"123060:133242:130787:128334", -- [15]
			"136331:123006:121828:124107:129365:128695", -- [16]
			"136331:123006:121828:122191:135387", -- [17]
			"123060:133242:130787:128334:135654", -- [18]
			"136331:123006:121828:124107:129365", -- [19]
			"123060:121252:140653:140650", -- [20]
			"123060:121252:140653", -- [21]
			"123060:122689:130790", -- [22]
			--["name"] = "Atal'Gral, Zuldazar",
			["direct"] = "123060:124456:134008:136331",
			["f"] = 0,
			["m"] = 862,
			["coord"] = 3434703392,
		},
		[123817] = {
			"127818:129483:130787:121828", -- [1]
			"127818:129483:130787:121828:122191", -- [2]
			"127818:122689:133242:123006:121207", -- [3]
			"127818:122689:133242:123006:121207:122198", -- [4]
			"127818:121252", -- [5]
			"127818:122689", -- [6]
			"127818:122689:133242:123006", -- [7]
			"127818:122689:123060", -- [8]
			"127818:122689:133242:136331:124456", -- [9]
			"127818:129483", -- [10]
			"127818:129483:130787", -- [11]
			"127818:122689:133242", -- [12]
			"127818:121252:134008", -- [13]
			"127818:122689:123060:134011", -- [14]
			"127818:129483:130787:121828:124107:135385", -- [15]
			"127818:129483:130787:121828:124107", -- [16]
			"127818:129483:130787:128334", -- [17]
			"127818:129483:130787:128334:135654:129365:128695", -- [18]
			"127818:129483:130787:121828:122191:135387", -- [19]
			"127818:122689:133242:136331", -- [20]
			"127818:129483:130787:128334:135654", -- [21]
			"127818:129483:130787:128334:135654:129365", -- [22]
			"140650:140653", -- [23]
			"127818:129483:130790", -- [24]
			--["name"] = "Xibala, Zuldazar",
			["direct"] = "127818:140650",
			["coord"] = 1925757125,
			["m"] = 862,
			["f"] = 0,
		},
		[140653] = {
			"121252:129483:130787:121828", -- [1]
			"121252:129483:130787:121828:122191", -- [2]
			"121252:122689:133242:123006:121207", -- [3]
			"121252:122689:133242:123006:121207:122198", -- [4]
			"121252:122689", -- [5]
			"121252:122689:133242:123006", -- [6]
			"121252:123060", -- [7]
			"140650:123817", -- [8]
			"121252:136331:124456", -- [9]
			"121252:127818", -- [10]
			"121252:129483", -- [11]
			"121252:129483:130787", -- [12]
			"121252:122689:133242", -- [13]
			"134008:134011", -- [14]
			"121252:129483:130787:121828:124107:135385", -- [15]
			"121252:129483:130787:121828:124107", -- [16]
			"121252:129483:130787:128334", -- [17]
			"121252:129483:130787:128334:135654:129365:128695", -- [18]
			"121252:129483:130787:121828:122191:135387", -- [19]
			"121252:136331", -- [20]
			"121252:129483:130787:128334:135654", -- [21]
			"121252:129483:130787:128334:135654:129365", -- [22]
			--["name"] = "Tusk Isle, Zuldazar",
			["direct"] = "121252:134008:140650",
			["coord"] = 2549204879,
			["m"] = 862,
			["f"] = 0,
		},
		[135387] = {
			"122191:121828", -- [1]
			"122191:121207", -- [2]
			"122191:121207:122198", -- [3]
			"122191:121828:130787:122689:121252", -- [4]
			"122191:121828:130787:122689", -- [5]
			"122191:121828:123006", -- [6]
			"122191:121828:133242:123060", -- [7]
			"122191:121828:130787:122689:127818:123817", -- [8]
			"122191:121207:124456", -- [9]
			"122191:121828:130787:122689:127818", -- [10]
			"122191:121828:130787:129483", -- [11]
			"122191:121828:130787", -- [12]
			"122191:121828:133242", -- [13]
			"122191:121828:130787:122689:121252:134008", -- [14]
			"122191:121207:124456:134011", -- [15]
			"124107:128334", -- [16]
			"135385:128695", -- [17]
			"122191:121828:123006:136331", -- [18]
			"124107:129365:135654", -- [19]
			"124107:129365", -- [20]
			"122191:121828:130787:122689:121252:140653:140650", -- [21]
			"122191:121828:130787:122689:121252:140653", -- [22]
			"122191:121828:130787:130790", -- [23]
			--["name"] = "Tortaka Refuge, Vol'dun",
			["direct"] = "122191:135385:124107",
			["f"] = 0,
			["m"] = 864,
			["coord"] = 2656712569,
		},
		[121252] = {
			"129483:130787:121828", -- [1]
			"129483:130787:121828:122191", -- [2]
			"122689:133242:123006:121207", -- [3]
			"122689:133242:123006:121207:122198", -- [4]
			"122689:133242:123006", -- [5]
			"127818:123817", -- [6]
			"136331:124456", -- [7]
			"129483:130787", -- [8]
			"122689:133242", -- [9]
			"123060:134011", -- [10]
			"129483:130787:121828:124107:135385", -- [11]
			"129483:130787:121828:124107", -- [12]
			"129483:130787:128334", -- [13]
			"129483:130787:128334:135654:129365:128695", -- [14]
			"129483:130787:121828:122191:135387", -- [15]
			"129483:130787:128334:135654", -- [16]
			"129483:130787:128334:135654:129365", -- [17]
			"140653:140650", -- [18]
			"129483:130790", -- [19]
			--["name"] = "Port of Zandalar, Zuldazar",
			["direct"] = "122689:123060:127818:129483:134008:136331:140653",
			["f"] = 0,
			["m"] = 1165,
			["coord"] = 2237261376,
			["requirements"] = "qid:52131",
		},
		[134008] = {
			"134011:136331:123006:121828", -- [1]
			"134011:136331:123006:121828:122191", -- [2]
			"134011:124456:121207", -- [3]
			"134011:124456:121207:122198", -- [4]
			"121252:122689", -- [5]
			"134011:136331:123006", -- [6]
			"134011:123060", -- [7]
			"140653:140650:123817", -- [8]
			"134011:124456", -- [9]
			"121252:127818", -- [10]
			"121252:129483", -- [11]
			"121252:129483:130787", -- [12]
			"121252:122689:133242", -- [13]
			"134011:136331:123006:121828:124107:135385", -- [14]
			"134011:136331:123006:121828:124107", -- [15]
			"121252:129483:130787:128334", -- [16]
			"121252:129483:130787:128334:135654:129365:128695", -- [17]
			"134011:136331:123006:121828:122191:135387", -- [18]
			"134011:136331", -- [19]
			"121252:129483:130787:128334:135654", -- [20]
			"121252:129483:130787:128334:135654:129365", -- [21]
			"140653:140650", -- [22]
			"121252:129483:130790", -- [23]
			--["name"] = "Seeker's Outpost, Zuldazar",
			["direct"] = "121252:134011:140653",
			["coord"] = 3025839895,
			["m"] = 862,
			["f"] = 0,
		},
		[140650] = {
			"123817:127818:129483:130787:121828", -- [1]
			"123817:127818:129483:130787:121828:122191", -- [2]
			"123817:127818:122689:133242:123006:121207", -- [3]
			"123817:127818:122689:133242:123006:121207:122198", -- [4]
			"140653:121252", -- [5]
			"123817:127818:122689", -- [6]
			"123817:127818:122689:133242:123006", -- [7]
			"140653:121252:123060", -- [8]
			"140653:121252:136331:124456", -- [9]
			"123817:127818", -- [10]
			"123817:127818:129483", -- [11]
			"123817:127818:129483:130787", -- [12]
			"123817:127818:122689:133242", -- [13]
			"140653:134008", -- [14]
			"140653:134008:134011", -- [15]
			"123817:127818:129483:130787:121828:124107:135385", -- [16]
			"123817:127818:129483:130787:121828:124107", -- [17]
			"123817:127818:129483:130787:128334", -- [18]
			"123817:127818:129483:130787:128334:135654:129365:128695", -- [19]
			"123817:127818:129483:130787:121828:122191:135387", -- [20]
			"140653:121252:136331", -- [21]
			"123817:127818:129483:130787:128334:135654", -- [22]
			"123817:127818:129483:130787:128334:135654:129365", -- [23]
			--["name"] = "Isle of Fangs, Zuldazar",
			["direct"] = "123817:140653",
			["coord"] = 2337726145,
			["m"] = 862,
			["f"] = 0,
		},
		[123060] = {
			"136331:123006:121828", -- [1]
			"136331:123006:121828:122191", -- [2]
			"136331:123006:121207", -- [3]
			"136331:123006:121207:122198", -- [4]
			"136331:123006", -- [5]
			"121252:127818:123817", -- [6]
			"136331:124456", -- [7]
			"121252:127818", -- [8]
			"133242:129483", -- [9]
			"133242:130787", -- [10]
			"121252:134008", -- [11]
			"136331:123006:121828:124107:135385", -- [12]
			"136331:123006:121828:124107", -- [13]
			"133242:130787:128334", -- [14]
			"133242:130787:128334:135654:129365:128695", -- [15]
			"136331:123006:121828:122191:135387", -- [16]
			"133242:130787:128334:135654", -- [17]
			"133242:130787:128334:135654:129365", -- [18]
			"121252:140653:140650", -- [19]
			"121252:140653", -- [20]
			"122689:130790", -- [21]
			--["name"] = "Warbeast Kraal, Zuldazar",
			["direct"] = "121252:122689:133242:134011:136331",
			["f"] = 0,
			["m"] = 862,
			["coord"] = 2887740943,
		},
		[128334] = {
			"130787:121828", -- [1]
			"124107:122191", -- [2]
			"124107:122191:121207", -- [3]
			"124107:122191:121207:122198", -- [4]
			"130787:122689:121252", -- [5]
			"130787:122689", -- [6]
			"130787:123006", -- [7]
			"130787:122689:123060", -- [8]
			"130787:122689:127818:123817", -- [9]
			"130787:123006:124456", -- [10]
			"130787:122689:127818", -- [11]
			"130787:129483", -- [12]
			"130787:133242", -- [13]
			"130787:122689:121252:134008", -- [14]
			"130787:122689:123060:134011", -- [15]
			"124107:135385", -- [16]
			"135654:129365:128695", -- [17]
			"124107:135387", -- [18]
			"130787:133242:136331", -- [19]
			"135654:129365", -- [20]
			"130787:122689:121252:140653:140650", -- [21]
			"130787:122689:121252:140653", -- [22]
			"130787:130790", -- [21]
			--["name"] = "Temple of Akunda, Vol'dun",
			["direct"] = "130787:124107:135654",
			["f"] = 0,
			["m"] = 864,
			["coord"] = 2307384439,
		},
		[129483] = {
			"130787:121828", -- [1]
			"130787:121828:122191", -- [2]
			"133242:123006:121207", -- [3]
			"133242:123006:121207:122198", -- [4]
			"133242:123006", -- [5]
			"122689:123060", -- [6]
			"127818:123817", -- [7]
			"133242:136331:124456", -- [8]
			"121252:134008", -- [9]
			"122689:123060:134011", -- [10]
			"130787:121828:124107:135385", -- [11]
			"130787:121828:124107", -- [12]
			"130787:128334", -- [13]
			"130787:128334:135654:129365:128695", -- [14]
			"130787:121828:122191:135387", -- [15]
			"133242:136331", -- [16]
			"130787:128334:135654", -- [17]
			"130787:128334:135654:129365", -- [18]
			"121252:140653:140650", -- [19]
			"121252:140653", -- [20]
			--["name"] = "Temple of the Prophet, Zuldazar",
			["direct"] = "121252:122689:127818:130787:133242",
			["f"] = 0,
			["m"] = 862,
			["coord"] = 2137289216,
		},
		[123006] = {
			"121828:122191", -- [1]
			"121207:122198", -- [2]
			"136331:121252", -- [3]
			"133242:122689", -- [4]
			"136331:123060", -- [5]
			"133242:122689:127818:123817", -- [6]
			"133242:122689:127818", -- [7]
			"133242:129483", -- [8]
			"136331:121252:134008", -- [9]
			"136331:134011", -- [10]
			"121828:124107:135385", -- [11]
			"121828:124107", -- [12]
			"130787:128334", -- [13]
			"121828:124107:129365:128695", -- [14]
			"121828:122191:135387", -- [15]
			"130787:128334:135654", -- [16]
			"121828:124107:129365", -- [17]
			"136331:121252:140653:140650", -- [18]
			"136331:121252:140653", -- [19]
			"130787:130790", -- [20]
			--["name"] = "Nesingwary's Gameland, Zuldazar",
			["direct"] = "121828:121207:124456:130787:133242:136331",
			["coord"] = 2844863786,
			["m"] = 862,
			["f"] = 0,
		},
		[129365] = {
			"124107:121828", -- [1]
			"124107:122191", -- [2]
			"124107:122191:121207", -- [3]
			"124107:122191:121207:122198", -- [4]
			"135654:128334:130787:122689:121252", -- [5]
			"135654:128334:130787:122689", -- [6]
			"124107:121828:123006", -- [7]
			"135654:128334:130787:122689:123060", -- [8]
			"135654:128334:130787:122689:127818:123817", -- [9]
			"124107:122191:121207:124456", -- [10]
			"135654:128334:130787:122689:127818", -- [11]
			"135654:128334:130787:129483", -- [12]
			"135654:128334:130787", -- [13]
			"135654:128334:130787:133242", -- [14]
			"135654:128334:130787:122689:121252:134008", -- [15]
			"135654:128334:130787:122689:123060:134011", -- [16]
			"135654:128334", -- [17]
			"124107:135387", -- [18]
			"124107:121828:123006:136331", -- [19]
			"135654:128334:130787:122689:121252:140653:140650", -- [20]
			"135654:128334:130787:122689:121252:140653", -- [21]
			"135654:128334:130787:130790", -- [22]
			--["name"] = "Goldtusk Inn, Vol'dun",
			["direct"] = "135385:124107:128695:135654",
			["f"] = 0,
			["m"] = 864,
			["coord"] = 1835965584,
		},
		[133242] = {
			"121828:122191", -- [1]
			"123006:121207", -- [2]
			"123006:121207:122198", -- [3]
			"122689:121252", -- [4]
			"122689:127818:123817", -- [5]
			"136331:124456", -- [6]
			"122689:127818", -- [7]
			"122689:121252:134008", -- [8]
			"123060:134011", -- [9]
			"121828:124107:135385", -- [10]
			"121828:124107", -- [11]
			"130787:128334", -- [12]
			"130787:128334:135654:129365:128695", -- [13]
			"121828:122191:135387", -- [14]
			"130787:128334:135654", -- [15]
			"130787:128334:135654:129365", -- [16]
			"122689:121252:140653:140650", -- [17]
			"122689:121252:140653", -- [18]
			"122689:130790", -- [19]
			--["name"] = "The Sliver, Zuldazar",
			["direct"] = "121828:122689:123006:123060:129483:130787:136331",
			["f"] = 0,
			["m"] = 1165,
			["coord"] = 2281648464,
		},
		[135385] = {
			"124107:121828", -- [1]
			"124107:122191", -- [2]
			"124107:122191:121207", -- [3]
			"124107:122191:121207:122198", -- [4]
			"124107:121828:130787:122689:121252", -- [5]
			"124107:121828:130787:122689", -- [6]
			"124107:121828:123006", -- [7]
			"124107:121828:133242:123060", -- [8]
			"124107:121828:130787:122689:127818:123817", -- [9]
			"124107:122191:121207:124456", -- [10]
			"124107:121828:130787:122689:127818", -- [11]
			"124107:121828:130787:129483", -- [12]
			"124107:121828:130787", -- [13]
			"124107:121828:133242", -- [14]
			"124107:121828:130787:122689:121252:134008", -- [15]
			"124107:121828:123006:136331:134011", -- [16]
			"124107:128334", -- [17]
			"124107:121828:123006:136331", -- [18]
			"129365:135654", -- [19]
			"124107:121828:130787:122689:121252:140653:140650", -- [20]
			"124107:121828:130787:122689:121252:140653", -- [21]
			"124107:121828:130787:130790", -- [22]
			--["name"] = "Vorrik's Sanctum, Vol'dun",
			["direct"] = "124107:128695:135387:129365",
			["f"] = 0,
			["m"] = 864,
			["coord"] = 2029869576,
		},
		[127818] = {
			"129483:130787:121828", -- [1]
			"129483:130787:121828:122191", -- [2]
			"122689:133242:123006:121207", -- [3]
			"122689:133242:123006:121207:122198", -- [4]
			"122689:133242:123006", -- [5]
			"122689:123060", -- [6]
			"122689:133242:136331:124456", -- [7]
			"129483:130787", -- [8]
			"122689:133242", -- [9]
			"121252:134008", -- [10]
			"122689:123060:134011", -- [11]
			"129483:130787:121828:124107:135385", -- [12]
			"129483:130787:121828:124107", -- [13]
			"129483:130787:128334", -- [14]
			"129483:130787:128334:135654:129365:128695", -- [15]
			"129483:130787:121828:122191:135387", -- [16]
			"122689:133242:136331", -- [17]
			"129483:130787:128334:135654", -- [18]
			"129483:130787:128334:135654:129365", -- [19]
			"123817:140650", -- [20]
			"121252:140653", -- [21]
			--["name"] = "Warport Rastari, Zuldazar",
			["direct"] = "121252:122689:123817:129483",
			["f"] = 0,
			["m"] = 862,
			["coord"] = 2070846044,
		},
		[136331] = {
			"123006:121828", -- [1]
			"123006:121828:122191", -- [2]
			"123006:121207", -- [3]
			"123006:121207:122198", -- [4]
			"133242:122689", -- [5]
			"121252:127818:123817", -- [6]
			"121252:127818", -- [7]
			"133242:129483", -- [8]
			"133242:130787", -- [9]
			"121252:134008", -- [10]
			"123006:121828:124107:135385", -- [11]
			"123006:121828:124107", -- [12]
			"133242:130787:128334", -- [13]
			"123006:121828:124107:129365:128695", -- [14]
			"123006:121828:122191:135387", -- [15]
			"133242:130787:128334:135654", -- [16]
			"123006:121828:124107:129365", -- [17]
			"121252:140653:140650", -- [18]
			"121252:140653", -- [19]
			"133242:122689:130790", -- [20]
			--["name"] = "Scaletrader Post, Zuldazar",
			["direct"] = "121252:123006:123060:124456:133242:134011",
			["f"] = 0,
			["m"] = 862,
			["coord"] = 3040037831,
		},
		[130787] = {
			"121828:122191", -- [1]
			"121828:121207", -- [2]
			"121828:121207:122198", -- [3]
			"122689:121252", -- [4]
			"122689:123060", -- [5]
			"122689:127818:123817", -- [6]
			"123006:124456", -- [7]
			"122689:127818", -- [8]
			"122689:121252:134008", -- [9]
			"122689:123060:134011", -- [10]
			"121828:124107:135385", -- [11]
			"121828:124107", -- [12]
			"128334:135654:129365:128695", -- [13]
			"121828:122191:135387", -- [14]
			"133242:136331", -- [15]
			"128334:135654", -- [16]
			"128334:135654:129365", -- [17]
			"122689:121252:140653:140650", -- [18]
			"122689:121252:140653", -- [19]
			--["name"] = "Garden of the Loa, Zuldazar",
			["direct"] = "121828:122689:123006:129483:133242:128334:130790",
			["f"] = 0,
			["m"] = 862,
			["coord"] = 2135114573,
		},
		[122689] = {
			"130787:121828", -- [1]
			"130787:121828:122191", -- [2]
			"133242:123006:121207", -- [3]
			"133242:123006:121207:122198", -- [4]
			"133242:123006", -- [5]
			"127818:123817", -- [6]
			"133242:136331:124456", -- [7]
			"121252:134008", -- [8]
			"123060:134011", -- [9]
			"130787:121828:124107:135385", -- [10]
			"130787:121828:124107", -- [11]
			"130787:128334", -- [12]
			"130787:128334:135654:129365:128695", -- [13]
			"130787:121828:122191:135387", -- [14]
			"133242:136331", -- [15]
			"130787:128334:135654", -- [16]
			"130787:128334:135654:129365", -- [17]
			"121252:140653:140650", -- [18]
			"121252:140653", -- [19]
			--["name"] = "The Great Seal",
			["direct"] = "121252:123060:127818:129483:130787:130790:133242",
			["coord"] = 2227202436,
			["m"] = 1165,
			["f"] = 0,
		},
		[122191] = {
			"121207:122198", -- [1]
			"121828:130787:122689:121252", -- [2]
			"121828:130787:122689", -- [3]
			"121828:123006", -- [4]
			"121828:133242:123060", -- [5]
			"121828:130787:122689:127818:123817", -- [6]
			"121207:124456", -- [7]
			"121828:130787:122689:127818", -- [8]
			"121828:130787:129483", -- [9]
			"121828:130787", -- [10]
			"121828:133242", -- [11]
			"121828:130787:122689:121252:134008", -- [12]
			"121207:124456:134011", -- [13]
			"124107:135385", -- [14]
			"124107:128334", -- [15]
			"124107:129365:128695", -- [16]
			"121828:123006:136331", -- [17]
			"124107:129365:135654", -- [18]
			"124107:129365", -- [19]
			"121828:130787:122689:121252:140653:140650", -- [20]
			"121828:130787:122689:121252:140653", -- [21]
			"121828:130787:130790", -- [22]
			--["name"] = "Zo'bal Ruins, Nazmir",
			["direct"] = "121828:121207:124107:135387",
			["coord"] = 1725394360,
			["m"] = 863,
			["f"] = 0,
		},
		[124456] = {
			"123006:121828", -- [1]
			"121207:122191", -- [2]
			"121207:122198", -- [3]
			"136331:121252", -- [4]
			"136331:133242:122689", -- [5]
			"136331:123060", -- [6]
			"136331:121252:127818:123817", -- [7]
			"136331:121252:127818", -- [8]
			"136331:133242:129483", -- [9]
			"123006:130787", -- [10]
			"136331:133242", -- [11]
			"134011:134008", -- [12]
			"123006:121828:124107:135385", -- [13]
			"123006:121828:124107", -- [14]
			"123006:130787:128334", -- [15]
			"123006:121828:124107:129365:128695", -- [16]
			"121207:122191:135387", -- [17]
			"123006:130787:128334:135654", -- [18]
			"123006:121828:124107:129365", -- [19]
			"136331:121252:140653:140650", -- [20]
			"136331:121252:140653", -- [21]
			--["name"] = "Zeb'ahari, Zuldazar",
			["direct"] = "121207:123006:134011:136331",
			["f"] = 0,
			["m"] = 862,
			["coord"] = 3321243475,
		},
		[121828] = {
			"121207:122198", -- [1]
			"130787:122689:121252", -- [2]
			"130787:122689", -- [3]
			"133242:123060", -- [4]
			"130787:122689:127818:123817", -- [5]
			"123006:124456", -- [6]
			"130787:122689:127818", -- [7]
			"130787:129483", -- [8]
			"130787:122689:121252:134008", -- [9]
			"123006:136331:134011", -- [10]
			"124107:135385", -- [11]
			"130787:128334", -- [12]
			"124107:129365:128695", -- [13]
			"122191:135387", -- [14]
			"123006:136331", -- [15]
			"130787:128334:135654", -- [16]
			"124107:129365", -- [17]
			"130787:122689:121252:140653:140650", -- [18]
			"130787:122689:121252:140653", -- [19]
			--["name"] = "Zul'jan, Nazmir",
			["direct"] = "122191:121207:123006:130787:133242:124107",
			["f"] = 0,
			["m"] = 863,
			["coord"] = 1672464344,
		},
		[135654] = {
			"128334:130787:121828", -- [1]
			"129365:124107:122191", -- [2]
			"129365:124107:122191:121207", -- [3]
			"129365:124107:122191:121207:122198", -- [4]
			"128334:130787:122689:121252", -- [5]
			"128334:130787:122689", -- [6]
			"128334:130787:123006", -- [7]
			"128334:130787:122689:123060", -- [8]
			"128334:130787:122689:127818:123817", -- [9]
			"128334:130787:123006:124456", -- [10]
			"128334:130787:122689:127818", -- [11]
			"128334:130787:129483", -- [12]
			"128334:130787", -- [13]
			"128334:130787:133242", -- [14]
			"128334:130787:122689:121252:134008", -- [15]
			"128334:130787:122689:123060:134011", -- [16]
			"129365:135385", -- [17]
			"129365:124107", -- [18]
			"129365:128695", -- [19]
			"129365:124107:135387", -- [20]
			"128334:130787:133242:136331", -- [21]
			"128334:130787:122689:121252:140653:140650", -- [22]
			"128334:130787:122689:121252:140653", -- [23]
			"128334:130787:130790", -- [24]
			--["name"] = "Scorched Sands Outpost, Vol'dun",
			["direct"] = "128334:129365",
			["f"] = 0,
			["m"] = 864,
			["coord"] = 1885520539,
		},
		[121207] = {
			"123006:136331:121252", -- [1]
			"123006:133242:122689", -- [2]
			"123006:136331:123060", -- [3]
			"123006:133242:122689:127818:123817", -- [4]
			"123006:133242:122689:127818", -- [5]
			"123006:133242:129483", -- [6]
			"121828:130787", -- [7]
			"123006:133242", -- [8]
			"124456:134011:134008", -- [9]
			"124456:134011", -- [10]
			"122191:124107:135385", -- [11]
			"122191:124107", -- [12]
			"121828:130787:128334", -- [13]
			"122191:124107:129365:128695", -- [14]
			"122191:135387", -- [15]
			"123006:136331", -- [16]
			"122191:124107:129365:135654", -- [17]
			"122191:124107:129365", -- [18]
			"123006:136331:121252:140653:140650", -- [19]
			"123006:136331:121252:140653", -- [20]
			"121828:130787:130790", -- [21]
			["m"] = 863,
			["direct"] = "121828:122191:122198:123006:124456",
			["coord"] = 2877517751,
			["f"] = 0,
		},
		[124107] = {
			"122191:121207", -- [1]
			"122191:121207:122198", -- [2]
			"121828:130787:122689:121252", -- [3]
			"121828:130787:122689", -- [4]
			"121828:123006", -- [5]
			"121828:133242:123060", -- [6]
			"121828:130787:122689:127818:123817", -- [7]
			"122191:121207:124456", -- [8]
			"121828:130787:122689:127818", -- [9]
			"121828:130787:129483", -- [10]
			"121828:130787", -- [11]
			"121828:133242", -- [12]
			"121828:130787:122689:121252:134008", -- [13]
			"121828:123006:136331:134011", -- [14]
			"129365:128695", -- [15]
			"121828:123006:136331", -- [16]
			"129365:135654", -- [17]
			"121828:130787:122689:121252:140653:140650", -- [18]
			"121828:130787:122689:121252:140653", -- [19]
			"121828:130787:130790", -- [20]
			--["name"] = "Vulpera Hideaway, Vol'dun",
			["direct"] = "121828:122191:135385:128334:135387:129365",
			["f"] = 0,
			["m"] = 864,
			["coord"] = 2446622267,
		},
		[122198] = {
			"121207:121828", -- [1]
			"121207:122191", -- [2]
			"121207:123006:136331:121252", -- [3]
			"121207:123006:133242:122689", -- [4]
			"121207:123006", -- [5]
			"121207:123006:136331:123060", -- [6]
			"121207:123006:133242:122689:127818:123817", -- [7]
			"121207:124456", -- [8]
			"121207:123006:133242:122689:127818", -- [9]
			"121207:123006:133242:129483", -- [10]
			"121207:121828:130787", -- [11]
			"121207:123006:133242", -- [12]
			"121207:124456:134011:134008", -- [13]
			"121207:124456:134011", -- [14]
			"121207:122191:124107:135385", -- [15]
			"121207:122191:124107", -- [16]
			"121207:121828:130787:128334", -- [17]
			"121207:122191:124107:129365:128695", -- [18]
			"121207:122191:135387", -- [19]
			"121207:123006:136331", -- [20]
			"121207:122191:124107:129365:135654", -- [21]
			"121207:122191:124107:129365", -- [22]
			"121207:123006:136331:121252:140653:140650", -- [23]
			"121207:123006:136331:121252:140653", -- [24]
			"121207:121828:130787:130790", -- [1]
			--["name"] = "Forlorn Ruins, Nazmir",
			["direct"] = "121207",
			["m"] = 863,
			["f"] = 0,
			["coord"] = 3526706255,
		},
		[127427] = {
			"130787:121828", -- [1]
			"124107:122191", -- [2]
			"124107:122191:121207", -- [3]
			"124107:122191:121207:122198", -- [4]
			"130787:122689:121252", -- [5]
			"130787:122689", -- [6]
			"130787:123006", -- [7]
			"130787:122689:123060", -- [8]
			"130787:122689:127818:123817", -- [9]
			"130787:123006:124456", -- [10]
			"130787:122689:127818", -- [11]
			"130787:129483", -- [12]
			"130787:130790", -- [13]
			"130787:133242", -- [14]
			"130787:122689:121252:134008", -- [15]
			"130787:122689:123060:134011", -- [16]
			"130787:133242:136331", -- [17]
			"130787:122689:121252:140653:140650", -- [18]
			"130787:122689:121252:140653", -- [19]
			["m"] = 864,
			["coord"] = 2304894035,
			["direct"] = "130787:124107",
			["f"] = 0,
		},		
	},
	[876] = {
		[138022] = {
			"2007284134:2160243705:129098", -- [1]
			"1924041156:133861", -- [2]
			"2007284134:2160243705:129098:128224", -- [3]
			"135025:142740:2127384098:137318", -- [4]
			"1924041156:2381474700:2393595189:134848", -- [5]
			"1924041156:2381474700:2393595189:134850", -- [6]
			"1924041156:2381474700:2393595189:134848:138097", -- [7]
			"1924041156:2381474700:2393595189:134850:134853", -- [8]
			"1924041156:133861:138265", -- [9]
			"135025:142740", -- [10]
			"1924041156:2381474700:134842:134848", -- [6]
			"1924041156:2381474700:134842:134850", -- [7]
			"1924041156:2381474700:134842:134848:138097", -- [8]
			"1924041156:2381474700:134842:134850:134853", -- [9]			
			"1898220961:133861:138265:143548", -- [10]
			"135025:150634", -- [11]			
			--["name"] = "Krazzlefrazz Outpost, Drustvar",
			["m"] = 896,
			["coord"] = 1604730323,
			["direct"] = "135025:135988",
			["f"] = 0,
		},
		[135988] = {
			"2007284134:2160243705:129098", -- [1]
			"2007284134:2160243705:133861", -- [2]
			"2007284134:2160243705:129098:128224", -- [3]
			"135025:142740:2127384098:137318", -- [4]
			"135025:142740:2127384098:134848", -- [5]
			"135025:142740:2381474700:2393595189:134850", -- [6]
			"135025:142740:2127384098:137318:138097", -- [7]
			"135025:142740:2381474700:2393595189:134850:134853", -- [8]
			"2007284134:2160243705:133861:138265", -- [9]
			"135025:142740", -- [10]
			--["name"] = "Anyport, Drustvar",
			["m"] = 896,
			["coord"] = 823619296,
			["direct"] = "135025:138022",
			["f"] = 0,
		},
		[142740] = {
			"1924041156:133861:129098", -- [1]
			"1924041156:133861", -- [2]
			"1924041156:133861:128224", -- [3]
			"2127384098:137318", -- [4]
			"2127384098:134848", -- [5]
			"2381474700:2393595189:134850", -- [6]
			"2127384098:137318:138097", -- [7]
			"2381474700:2393595189:134850:134853", -- [8]
			"135025:135988", -- [9]
			"1924041156:138022", -- [10]
			"1924041156:133861:138265", -- [11]
			"140939:133861:129098", -- [1]
			"140939:133861", -- [2]
			"140939:133861:128224", -- [3]			
			"140939:133861:1`38265", -- [12]
			"140939:2007284134", -- [13]
			"140939:2007284134:2160243705", -- [14]			
			"140939:138022", -- [10]	
			"1898220961:133861:129098", -- [1]
			"1898220961:133861", -- [2]
			"1898220961:133861:128224", -- [3]
			"2097107569:137318", -- [4]
			"2097107569:134848", -- [5]
			"2345496483:2357354855:134850", -- [6]
			"2097107569:137318:138097", -- [7]
			"2345496483:2357354855:134850:134853", -- [8]
			"1898220961:138022", -- [9]
			"1898220961:133861:138265", -- [10]
			"1898220961:133861:138265:143548", -- [11]
			"135025:150634", -- [12]
			--["name"] = "Waning Glacier, Tiragarde Sound",
			["m"] = 895,
			["coord"] = 1704144718,
			["direct"] = "135025:140939",
			["f"] = 0,
		},
		[150634] = {
			"135025:138022:1979628839:2129180549:129098", -- [1]
			"135025:138022:1898220961:133861", -- [2]
			"135025:138022:1979628839:2129180549:129098:128224", -- [3]
			"137318:138097:134848", -- [4]
			"137318:138097:134848:134850", -- [5]
			"137318:138097:2509252230:134853", -- [6]
			"135025:135988", -- [7]
			"135025:138022", -- [8]
			"135025:138022:1898220961:133861:138265", -- [9]
			"135025:142740", -- [10]
			"135025:138022:1898220961:133861:138265:143548", -- [11]
			["direct"] = "137318:138097:135025",
			["m"] = 1462,
			["coord"] = 3154723323,
			["f"] = 0,
		},	
		[134848] = {
			"134842:2381474700:133861:129098", -- [1]
			"134842:2381474700", -- [2]
			"134842:2381474700:133861", -- [3]
			"134842:2381474700:133861:128224", -- [4]		
			"2393595189:2381474700:133861:129098", -- [1]
			"2393595189:2381474700:133861", -- [2]
			"2393595189:2381474700:133861:128224", -- [3]
			"138097:137318", -- [4]
			"138097:2548965858:134853", -- [5]
			"2127384098:142740:135025", -- [6]
			"2127384098:142740:135025:135988", -- [7]
			"2127384098:142740:1924041156:138022", -- [8]
			"2393595189:2381474700:133861:138265", -- [9]
			"2127384098:142740", -- [10]
			"134842:2381474700:133861:138265", -- [9]
			"134842:2381474700:140772", -- [11]
			"2357354855:2345496483:133861:129098", -- [1]
			"2357354855:2345496483:133861", -- [2]
			"2357354855:2345496483:133861:128224", -- [3]
			"138097:2509252230:134853", -- [4]
			"2097107569:142740:135025", -- [5]
			"2097107569:142740:135025:135988", -- [6]
			"2097107569:142740:1898220961:138022", -- [7]
			"2357354855:2345496483:133861:138265", -- [8]
			"2097107569:142740", -- [9]
			"2357354855:2345496483:133861:138265:143548", -- [10]
			"138097:137318:150634", -- [11]			
			--["name"] = "Diretusk Hollow, Stormsong Valley",
			["m"] = 942,
			["coord"] = 2330820120,
			["direct"] = "134850:138097",
			["f"] = 0,
		},
		[128224] = {
			"133861:2381474700:2393595189:2127384098:137318", -- [1]
			"133861:2381474700:2393595189:134848", -- [2]
			"133861:2381474700:2393595189:134850", -- [3]
			"133861:2381474700:2393595189:134848:138097", -- [4]
			"133861:2381474700:2393595189:134850:134853", -- [5]
			"133861:1924041156:138022:135025", -- [6]
			"129098:2160243705:2007284134:135988", -- [7]
			"133861:1924041156:138022", -- [8]
			"133861:1924041156:142740", -- [9]
			"133861:1898220961:138022:135025:150634", -- [10]
			--["name"] = "Castaway Point, Tiragarde Sound",
			["m"] = 895,
			["coord"] = 3710701347,
			["direct"] = "129098:133861:138265:143548",
			["f"] = 0,
		},
		[137318] = {
			"2127384098:2393595189:2381474700:133861:129098", -- [1]
			"2127384098:2393595189:2381474700:133861", -- [2]
			"2127384098:2393595189:2381474700:133861:128224", -- [3]
			"138097:134848", -- [4]
			"138097:134848:134850", -- [5]
			"138097:2548965858:134853", -- [6]
			"2127384098:142740:135025", -- [7]
			"2127384098:142740:135025:135988", -- [8]
			"2127384098:142740:1924041156:138022", -- [9]
			"2127384098:2393595189:2381474700:133861:138265", -- [10]
			"2127384098:142740", -- [11]
			--["name"] = "Seekers Vista, Stormsong Valley",
			["m"] = 942,
			["coord"] = 1721261926,
			["direct"] = "138097",
			["f"] = 0,
		},
		[135025] = {
			"138022:2007284134:2160243705:129098", -- [1]
			"138022:1924041156:133861", -- [2]
			"138022:2007284134:2160243705:129098:128224", -- [3]
			"142740:2127384098:137318", -- [4]
			"142740:2127384098:134848", -- [5]
			"142740:2381474700:2393595189:134850", -- [6]
			"142740:2127384098:137318:138097", -- [7]
			"142740:2381474700:2393595189:134850:134853", -- [8]
			"138022:1924041156:133861:138265", -- [9]
			"138022:140772:2160243705:129098", -- [1]			
			--["name"] = "Whitegrove Chapel, Drustvar",
			["m"] = 896,
			["coord"] = 1103899222,
			["direct"] = "135988:138022:142740:150634",
			["f"] = 0,
		},
		[134850] = {
			"2393595189:2381474700:133861:129098", -- [1]
			"2393595189:2381474700:133861", -- [2]
			"2393595189:2381474700:133861:128224", -- [3]
			"134848:138097:137318", -- [4]
			"134848:138097", -- [5]
			"2393595189:2381474700:142740:135025", -- [6]
			"2393595189:2381474700:1924041156:138022:135988", -- [7]
			"2393595189:2381474700:1924041156:138022", -- [8]
			"2393595189:2381474700:133861:138265", -- [9]
			"2393595189:2381474700:142740", -- [10]
			"134842:2381474700:133861:129098", -- [1]
			"134842:2381474700", -- [2]
			"134842:2381474700:133861", -- [3]
			"134842:2381474700:133861:128224", -- [4]
			"134842:2381474700:142740:135025", -- [5]
			"134842:2381474700:1924041156:138022:135988", -- [6]
			"134842:2381474700:1924041156:138022", -- [7]
			"134842:2381474700:133861:138265", -- [8]
			"134842:2381474700:142740", -- [9]
			"134842:2381474700:140772", -- [10]			
			"2357354855:2345496483:133861:129098", -- [1]
			"2357354855:2345496483:133861", -- [2]
			"2357354855:2345496483:133861:128224", -- [3]
			"2357354855:2345496483:142740:135025", -- [4]
			"2357354855:2345496483:1898220961:138022:135988", -- [5]
			"2357354855:2345496483:1898220961:138022", -- [6]
			"2357354855:2345496483:133861:138265", -- [7]
			"2357354855:2345496483:142740", -- [8]
			"2357354855:2345496483:133861:138265:143548", -- [9]
			"134848:138097:137318:150634", -- [10]			
			--["name"] = "Ironmaul Overlook, Stormsong Valley",
			["m"] = 942,
			["coord"] = 3261047832,
			["direct"] = "134848:134853",
			["f"] = 0,
		},
		[129098] = {
			"133861:2381474700:2393595189:2127384098:137318", -- [1]
			"133861:2381474700:2393595189:134848", -- [2]
			"133861:2381474700:2393595189:134850", -- [3]
			"133861:2381474700:2393595189:134848:138097", -- [4]
			"133861:2381474700:2393595189:134850:134853", -- [5]
			"2160243705:2007284134:138022:135025", -- [6]
			"2160243705:2007284134:135988", -- [7]
			"2160243705:2007284134:138022", -- [8]
			"128224:138265", -- [9]
			"133861:1924041156:142740", -- [10]
			"133861:133331", -- [1]
			"133861:133331:134842:2127384098:137318", -- [2]
			"133861:133331:134842:134848", -- [3]
			"133861:133331:134842:134850", -- [4]
			"133861:133331:134842:134848:138097", -- [5]
			"133861:133331:134842:134850:134853", -- [6]
			"2160243705:140772:138022:135025", -- [7]
			"2160243705:140772:135988", -- [8]
			"2160243705:140772:138022", -- [9]
			"133861:1924041156:142740", -- [10]			
			"133861:1898220961:142740", -- [9]
			"128224:143548", -- [10]
			"2129180549:1979628839:138022:135025:150634", -- [11]			
			--["name"] = "Freehold, Tiragarde Sound",
			["m"] = 895,
			["coord"] = 3310343229,
			["direct"] = "133861:128224",
			["f"] = 0,
		},
		[133861] = {
			"2381474700:2393595189:2127384098:137318", -- [1]
			"2381474700:2393595189:134848", -- [2]
			"2381474700:2393595189:134850", -- [3]
			"2381474700:2393595189:134848:138097", -- [4]
			"2381474700:2393595189:134850:134853", -- [5]
			"133331:134842:2127384098:137318", -- [1]
			"133331:134842:134848", -- [2]
			"133331:134842:134850", -- [3]
			"133331:134842:134848:138097", -- [4]
			"133331:134842:134850:134853", -- [5]			
			"1924041156:138022:135025", -- [6]
			"2160243705:2007284134:135988", -- [7]
			"1924041156:138022", -- [8]
			"1924041156:142740", -- [9]
			"2160243705:140772:135988", -- [7]
			"1898220961:138022", -- [8]
			"1898220961:142740", -- [9]
			"138265:143548", -- [10]
			"1898220961:138022:135025:150634", -- [11]			
			--["name"] = "Timberfell Outpost, Tiragarde Sound",
			["m"] = 895,
			["coord"] = 3097789664,
			["direct"] = "129098:128224:138265",
			["f"] = 0,
		},
		[134853] = {
			"134850:134842:133331:133861", -- [1]
			"134850:134842:133331:133861:128224", -- [2]		
			"134850:2393595189:2381474700:133861:129098", -- [1]
			"134850:2393595189:2381474700:133861", -- [2]
			"134850:2393595189:2381474700:133861:128224", -- [3]
			"2548965858:138097:137318", -- [4]
			"2548965858:138097:134848", -- [5]
			"2548965858:138097", -- [6]
			"2548965858:138097:137318:2127384098:142740:135025", -- [7]
			"2548965858:138097:137318:2127384098:142740:135025:135988", -- [8]
			"134850:2393595189:2381474700:1924041156:138022", -- [9]
			"134850:2393595189:2381474700:133861:138265", -- [10]
			"2548965858:138097:137318:2127384098:142740", -- [11]
			"134850:134842:133331:1924041156:138022", -- [6]
			"134850:134842:133331:133861:138265", -- [7]			
			"134850:2357354855:2345496483:133861:129098", -- [1]
			"134850:2357354855:2345496483:133861", -- [2]
			"134850:2357354855:2345496483:133861:128224", -- [3]
			"2509252230:138097:137318", -- [4]
			"2509252230:138097:134848", -- [5]
			"2509252230:138097", -- [6]
			"2509252230:138097:137318:2097107569:142740:135025", -- [7]
			"2509252230:138097:137318:2097107569:142740:135025:135988", -- [8]
			"134850:2357354855:2345496483:1898220961:138022", -- [9]
			"134850:2357354855:2345496483:133861:138265", -- [10]
			"2509252230:138097:137318:2097107569:142740", -- [11]
			"134850:2357354855:2345496483:133861:138265:143548", -- [12]
			"2509252230:138097:137318:150634", -- [13]			
			["direct"] = "134850",
			["coord"] = 3347398043,
			["m"] = 942,
			["f"] = 0,
		},
		[138097] = {
			"134848:134842:2381474700:133861:129098", -- [1]
			"134848:134842:2381474700", -- [2]
			"134848:134842:2381474700:133861", -- [3]
			"134848:134842:2381474700:133861:128224", -- [4]		
			"134848:2393595189:2381474700:133861:129098", -- [1]
			"134848:2393595189:2381474700:133861", -- [2]
			"134848:2393595189:2381474700:133861:128224", -- [3]
			"134848:134850", -- [4]
			"2548965858:134853", -- [5]
			"137318:2127384098:142740:135025", -- [6]
			"137318:2127384098:142740:135025:135988", -- [7]
			"137318:2127384098:142740:1924041156:138022", -- [8]
			"134848:2393595189:2381474700:133861:138265", -- [9]
			"134848:134842:2381474700:133861:138265", -- [9]
			"137318:2127384098:142740", -- [10]
			--["name"] = "Warfang Hold, Stormsong Valley",
			["m"] = 942,
			["coord"] = 2209568298,
			["direct"] = "137318:134848",
			["f"] = 0,
		},
		[138265] = {
			"133861:129098", -- [1]
			"133861:2381474700:2393595189:2127384098:137318", -- [2]
			"133861:2381474700:2393595189:134848", -- [3]
			"133861:2381474700:2393595189:134850", -- [4]
			"133861:2381474700:2393595189:134848:138097", -- [5]
			"133861:2381474700:2393595189:134850:134853", -- [6]
			"133861:1924041156:138022:135025", -- [7]
			"133861:2160243705:2007284134:135988", -- [8]
			"133861:1924041156:138022", -- [9]
			"133861:1924041156:142740", -- [10]
			"133861:2345496483:2357354855:2097107569:137318", -- [1]
			"133861:2345496483:2357354855:134848", -- [2]
			"133861:2345496483:2357354855:134850", -- [3]
			"133861:2345496483:2357354855:134848:138097", -- [4]
			"133861:2345496483:2357354855:134850:134853", -- [5]
			"133861:1898220961:138022:135025", -- [6]
			"133861:2129180549:1979628839:135988", -- [7]
			"133861:1898220961:138022", -- [8]
			"133861:1898220961:142740", -- [9]			
			"133861:2345496483:2357354855:2097107569:137318", -- [1]
			"133861:2345496483:2357354855:134848", -- [2]
			"133861:2345496483:2357354855:134850", -- [3]
			"133861:2345496483:2357354855:134848:138097", -- [4]
			"133861:2345496483:2357354855:134850:134853", -- [5]
			"133861:1898220961:138022:135025", -- [6]
			"133861:2129180549:1979628839:135988", -- [7]
			"133861:1898220961:138022", -- [8]
			"133861:1898220961:142740", -- [9]			
			"133861:1898220961:138022:135025:150634", -- [10]
			--["name"] = "Plunder Harbor, Tiragarde Sound",
			["m"] = 895,
			["coord"] = 3749740958,
			["direct"] = "133861:128224:143548",
			["f"] = 0,
		},
		[143548] = {
			"128224:129098", -- [1]
			"138265:133861", -- [2]
			"138265:133861:2345496483:2357354855:2097107569:137318", -- [3]
			"138265:133861:2345496483:2357354855:134848", -- [4]
			"138265:133861:2345496483:2357354855:134850", -- [5]
			"138265:133861:2345496483:2357354855:134848:138097", -- [6]
			"138265:133861:2345496483:2357354855:134850:134853", -- [7]
			"138265:133861:1898220961:138022:135025", -- [8]
			"138265:133861:2129180549:1979628839:135988", -- [9]
			"138265:133861:1898220961:138022", -- [10]
			"138265:133861:1898220961:142740", -- [11]
			"138265:133861:1898220961:138022:135025:150634", -- [12]
			--["name"] = "Tol Dagor, Tiragarde Sound",
			["m"] = 1169,
			["f"] = 0,
			["direct"] = "128224:138265",
			["coord"] = 987986451,
		},		
		[134842] = {
			"2381474700:133861:129098", -- [1]
			"2381474700:133861", -- [2]
			"2381474700:133861:128224", -- [3]
			"2127384098:137318", -- [4]
			"134848:138097", -- [5]
			"134850:134853", -- [6]
			"2381474700:142740:135025", -- [7]
			"2381474700:1924041156:138022:135988", -- [8]
			"2381474700:1924041156:138022", -- [9]
			"2381474700:133861:138265", -- [10]
			"2381474700:142740", -- [11]
			"2381474700:2007284134", -- [12]
			"134848:138097:2548965858", -- [13]
			"2381474700:1924041156", -- [14]
			"2381474700:2160243705", -- [15]
			"133331:133861:129098", -- [16]
			"133331:133861", -- [17]
			"133331:133861:128224", -- [18]
			"133331:142740:135025", -- [19]
			"133331:140939:138022:135988", -- [20]
			"133331:140939:138022", -- [21]
			"133331:133861:138265", -- [22]
			"133331:142740", -- [23]
			"133331:140772", -- [24]
			"133331:140939", -- [25]
			"133331:140533", -- [26]
			--["name"] = "Hillcrest Pasture, Stormsong Valley",
			["direct"] = "133331:2127384098:134848:134850",
			["m"] = 942,
			["coord"] = 2267204938,
			["f"] = 0,
			["requirements"] = "qid:52479",
		},		
		[138251] = {
			"138097:134848:134842:133331:133861:129098", -- [1]
			"138097:134848:134842:133331", -- [2]
			"138097:134848:134842:133331:133861", -- [3]
			"138097:134848:134842:133331:133861:128224", -- [4]
			"138097:137318", -- [5]
			"138097:134848:134842", -- [6]
			"138097:137318:134844", -- [7]
			"138097:134848", -- [8]
			"134853:134850", -- [9]
			"138097:137318:134844:142740:135025", -- [10]
			"138097:137318:134844:142740:135025:135988", -- [11]
			"138097:137318:134844:142740:140939:138022", -- [12]
			"138097:134848:134842:133331:133861:138265", -- [13]
			"138097:137318:134844:142740", -- [14]
			"138097:134848:134842:133331:140772", -- [15]
			"138097:137318:134844:142740:140939", -- [16]
			"138097:134848:134842:133331:140533", -- [17]
			["m"] = 942,
			["direct"] = "138097:134853",
			["coord"] = 2612872606,
			["f"] = 0,
			["requirements"] = "qid:52320",
		},		
		[140772] = {
			"2160243705:129098", -- [1]
			"2160243705:133861", -- [2]
			"2160243705:129098:128224", -- [3]
			"133331:134842:2127384098:137318", -- [4]
			"133331:134842:134848", -- [5]
			"133331:134842:134850", -- [6]
			"133331:134842:134848:138097", -- [7]
			"133331:134842:134850:134853", -- [8]
			"138022:135025", -- [9]
			"2160243705:133861:138265", -- [10]
			"1924041156:142740", -- [11]
			"2381474700:134842:2127384098:137318", -- [12]
			"2381474700:134842:134848", -- [13]
			"2381474700:134842:134850", -- [14]
			"2381474700:134842:134848:138097", -- [15]
			"2381474700:134842:134850:134853", -- [16]
			"2381474700:2393595189:2127384098:137318", -- [17]
			"2381474700:2393595189", -- [18]
			"2381474700:2393595189:2127384098", -- [19]
			"2381474700:2393595189:134848", -- [20]
			"2381474700:2393595189:134850", -- [21]
			"2381474700:2393595189:134848:138097", -- [22]
			"2381474700:2393595189:134850:134853", -- [23]
			"2381474700:2393595189:134848:138097:2548965858", -- [24]
			--["name"] = "Swiftwind Post, Drustvar",
			["m"] = 896,
			["coord"] = 2851510268,
			["direct"] = "2381474700:135988:138022:1924041156:2160243705",
			["f"] = 0,
			["requirements"] = "qid:52276",
		},	
		[134844] = {
			"134842:2381474700:133861:129098", -- [1]
			"134842:2381474700", -- [2]
			"134842:2381474700:133861", -- [3]
			"134842:2381474700:133861:128224", -- [4]
			"134848:134850", -- [5]
			"137318:138097", -- [6]
			"137318:138097:2548965858:134853", -- [7]
			"142740:135025", -- [8]
			"142740:135025:135988", -- [9]
			"142740:1924041156:138022", -- [10]
			"137318:138097:2548965858", -- [11]
			"134842:2381474700:133861:138265", -- [12]
			"142740:1924041156:2007284134", -- [13]
			"142740:1924041156", -- [14]
			"134842:2381474700:2160243705", -- [15]
			"134842:133331:133861:129098", -- [16]
			"134842:133331", -- [17]
			"134842:133331:133861", -- [18]
			"134842:133331:133861:128224", -- [19]
			"142740:140939:138022", -- [20]
			"134842:133331:133861:138265", -- [21]
			"142740:140939:140772", -- [22]
			"142740:140939", -- [23]
			"134842:133331:140533", -- [24]
			--["name"] = "Stonetusk Watch, Stormsong Valley",
			["m"] = 942,
			["direct"] = "137318:134842:134848:142740",
			["coord"] = 1668065993,
			["f"] = 0,
			["requirements"] = "qid:52777",
		},		
		[133331] = {
			"133861:128224", -- [1]
			"134842:2127384098:137318", -- [2]
			"134842:134848", -- [3]
			"134842:134850", -- [4]
			"134842:134848:138097", -- [5]
			"134842:134850:134853", -- [6]
			"142740:135025", -- [7]
			"1924041156:138022:135988", -- [8]
			"1924041156:138022", -- [9]
			"133861:138265", -- [10]
			"133861:129098", -- [11]
			"2393595189:2127384098:137318", -- [12]
			"2393595189:2127384098", -- [13]
			"2393595189:134848", -- [14]
			"2393595189:134850", -- [15]
			"2393595189:134848:138097", -- [16]
			"2393595189:134850:134853", -- [17]
			"140939:138022:135988", -- [18]
			"140939:138022", -- [19]
			"2393595189:134848:138097:2548965858", -- [20]
			--["name"] = "Wolf's Den, Tiragarde Sound",
			["direct"] = "133861:2393595189:142740:140772:140939:140533",
			["m"] = 895,
			["coord"] = 2668503700,
			["f"] = 0,
			["requirements"] = "qid:52127",
		},		
		[140939] = {
			"133861:129098", -- [1]
			"133861:128224", -- [2]
			"142740:2127384098:137318", -- [3]
			"2381474700:2393595189", -- [4]
			"142740:2127384098", -- [5]
			"2381474700:2393595189:134848", -- [6]
			"2381474700:2393595189:134850", -- [7]
			"2381474700:2393595189:134848:138097", -- [8]
			"2381474700:2393595189:134850:134853", -- [9]
			"138022:135025", -- [10]
			"138022:135988", -- [11]
			"2381474700:2393595189:134848:138097:2548965858", -- [12]
			"133861:138265", -- [13]
			"2007284134:2160243705", -- [14]
			"140772:140533", -- [15]
			--["name"] = "Mudfisher Cove, Drustvar",
			["m"] = 896,
			["f"] = 0,
			["direct"] = "2381474700:133861:138022:142740:140772",
			["coord"] = 2666736421,
			["requirements"] = "qid:140947",
		},		
		[140533] = {
			"129098:128224", -- [1]
			"2381474700:2393595189:2127384098:137318", -- [2]
			"2381474700:2393595189", -- [3]
			"2381474700:2393595189:2127384098", -- [4]
			"2381474700:2393595189:134848", -- [5]
			"2381474700:2393595189:134850", -- [6]
			"2381474700:2393595189:134848:138097", -- [7]
			"2381474700:2393595189:134850:134853", -- [8]
			"140772:138022:135025", -- [9]
			"140772:135988", -- [10]
			"140772:138022", -- [11]
			"2381474700:2393595189:134848:138097:2548965858", -- [12]
			"133861:138265", -- [13]
			"140772:1924041156:142740", -- [14]
			"140772:1924041156", -- [15]
			--["name"] = "Stonefist Watch, Tiragarde Sound",
			["m"] = 895,
			["direct"] = "129098:2381474700:133861:140772",
			["coord"] = 2284822938,
			["f"] = 0,
			["requirements"] = "qid:52222",
		},		
		[2548965858] = {
			["m"] = 876,
			["coord"] = 2548965858,
		},		
		[2393595189] = {
			["m"] = 876,
			["coord"] = 2393595189,
		},	
		[2381474700] = {
			["m"] = 876,
			["coord"] = 2381474700,
		},	
		[2127384098] = {
			["m"] = 876,
			["coord"] = 2127384098,
		},	
		[2160243705] = {
			["m"] = 876,
			["coord"] = 2160243705,
		},	
		[1924041156] = {
			["m"] = 876,
			["coord"] = 1924041156,
		},	
		[2007284134] = {
			["m"] = 876,
			["coord"] = 2007284134,
		},	
		[2357354855] = {
			["m"] = 876,
			["coord"] = 2357354855,
		},	
		[2345496483] = {
			["m"] = 876,
			["coord"] = 2345496483,
		},	
		[2509252230] = {
			["m"] = 876,
			["coord"] = 2509252230,
		},	
		[2097107569] = {
			["m"] = 876,
			["coord"] = 2097107569,
		},			
		[1979628839] = {
			["m"] = 876,
			["coord"] = 1979628839,
		},
		[1898220961] = {
			["m"] = 876,
			["coord"] = 1898220961,
		},			
		[2129180549] = {
			["m"] = 876,
			["coord"] = 2129180549,
		},			
	},
	[1355] = {
		[153757] = {
			"153863:153772", -- [1]
			"153863:153772:153850", -- [2]
			--["name"] = "Kelya's Grave, Nazjatar",
			["direct"] = "153762:153863",
			["f"] = 0,
			["m"] = 1355,
			["coord"] = 3185000407,
		},
		[153863] = {
			"153772:153850", -- [1]
			--["name"] = "Ekka's Hideaway, Nazjatar",
			["m"] = 1355,
			["f"] = 0,
			["direct"] = "153772:153762",
			["coord"] = 2748941475,
		},
		[153850] = {
			--["name"] = "Wreck of the Hungry Riverbeast, Nazjatar",
			["direct"] = "153772:153762",
			["f"] = 0,
			["m"] = 1355,
			["coord"] = 1552405133,
		},
		[153762] = {
			--["name"] = "Ashen Strand, Nazjatar",
			["direct"] = "153772",
			["f"] = 0,
			["m"] = 1355,
			["coord"] = 1481007018,
		},
		[153772] = {
			"153863:153757", -- [1]
			"153863:153864", -- [2]
			["m"] = 1355,
			["direct"] = "153762:153850:153863",
			["coord"] = 2039521719,
			["f"] = 0,
		},
		[153864] = {
			"153863:153772", -- [1]
			"153863:153772:153850", -- [2]
			--["name"] = "Zin'Azshari, Nazjatar",
			["direct"] = "153757:153762:153863",
			["f"] = 0,
			["m"] = 1355,
			["coord"] = 3413664011,
		},
	},
	[1550] = {
		[183969] = {
			--["name"] = "Pilgrim's Grace, Zereth Mortis",
			["m"] = 1970,
			["direct"] = "183963:183966",
			["coord"] = 2641789184,
			["f"] = 0,
		},
		[183966] = {
			--["name"] = "Faith's Repose, Zereth Mortis",
			["direct"] = "183963:183969",
			["m"] = 1970,
			["coord"] = 1531605468,
			["f"] = 0,
		},
		[183963] = {
			--["name"] = "Haven, Zereth Mortis",
			["direct"] = "183966:183969",
			["m"] = 1970,
			["coord"] = 1530570374,
			["f"] = 0,
		},
		[183968] = {
			--["name"] = "Zovaal's Grasp, Zereth Mortis",
			["direct"] = "184337",
			["coord"] = 1978415011,
			["m"] = 1970,
			["f"] = 0,
		},
		[184337] = {
			--["name"] = "Antecedent Isle, Zereth Mortis",
			["direct"] = "183968",
			["m"] = 1970,
			["coord"] = 2035949950,
			["f"] = 0,
		},
		[183970] = {
			--["name"] = "Sepulcher Overlook, Zereth Mortis",
			["direct"] = "184332",
			["m"] = 1970,
			["coord"] = 2780006677,
			["f"] = 0,
		},
		[184332] = {
			--["name"] = "Sepulcher Of The First Ones, Zereth Mortis",
			["direct"] = "183970",
			["m"] = 1970,
			["f"] = 0,
			["coord"] = 3141306562,
		},
		[171105] = {
			["m"] = 1533,
			["direct"] = "171036:171037:171091:171097:171101:171102:171103:171104",
			["coord"] = 1520318503,
			["f"] = 0,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171104] = {
			--["name"] = "Temple of Humility, Bastion",
			["direct"] = "171036:171037:171091:171097:171101:171102:171103:171105",
			["f"] = 0,
			["m"] = 1533,
			["coord"] = 2859235995,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171103] = {
			--["name"] = "Seat of Eternal Hymns, Bastion",
			["direct"] = "171036:171037:171091:171097:171101:171102:171105:171104",
			["f"] = 0,
			["m"] = 1533,
			["coord"] = 2506772299,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171097] = {
			--["name"] = "Xandria's Vigil, Bastion",
			["direct"] = "171036:171037:171091:171101:171102:171103:171105:171104",
			["f"] = 0,
			["m"] = 1533,
			["coord"] = 1748602196,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171091] = {
			--["name"] = "Aspirant's Rest, Bastion",
			["direct"] = "171036:171037:171097:171101:171102:171103:171105:171104",
			["f"] = 0,
			["m"] = 1533,
			["coord"] = 2075048589,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171036] = {
			["m"] = 1707,
			["direct"] = "171037:171091:171097:171101:171102:171103:171105:171104",
			["coord"] = 2069732764,
			["f"] = 0,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171037] = {
			--["name"] = "Hero's Rest, Bastion",
			["direct"] = "171036:171091:171097:171101:171102:171103:171105:171104",
			["f"] = 0,
			["m"] = 1533,
			["coord"] = 2222684117,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171101] = {
			--["name"] = "Sagehaven, Bastion",
			["direct"] = "171036:171037:171091:171097:171102:171103:171105:171104",
			["f"] = 0,
			["m"] = 1533,
			["coord"] = 1896764554,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[171102] = {
			--["name"] = "Temple of Purity, Bastion",
			["direct"] = "171036:171037:171091:171097:171101:171103:171105:171104",
			["f"] = 0,
			["m"] = 1533,
			["coord"] = 2552284520,
			["isGateway"] = true,
			["requirements"] = "qid:63052", --Kyrian
		},
		[159421] = {
			"159423:159127:162666", -- [1]
			"159423:159127:162666:158526:156295", -- [2]
			"159423:159127:162666:158526:156196:158416", -- [3]
			"159423:159127:162666:158526:158417", -- [4]
			"159423:159127:162666:158526:156295:158517", -- [5]
			"159423:159127:162666:158526", -- [6]
			"159423:159127:162666:158526:156196:158416:158533", -- [7]
			"159423:159127:162666:158526:156295:158517:158564", -- [8]
			"159423:159127:162666:158526:156196", -- [9]
			"159423:159127", -- [10]
			"159423:159127:162666:158526:156196:160202", -- [11]
			"159423:159127:162666:157540:157519", -- [12]
			"159423:159127:162666:157540:157518", -- [13]
			"159423:159127:162666:157540:157517", -- [14]
			"159423:159127:162666:157540:157516", -- [15]
			"159423:159127:162666:157540", -- [16]
			"159423:159127:162666:157540:157515", -- [17]
			"159423:159127:162666:165164:167243", -- [18]
			"159423:159127:162666:165164", -- [19]
			"159423:159127:162666:165164:165166", -- [20]
			"159423:159127:162666:165164:167255:167265", -- [21]
			"159423:159127:162666:165164:165166:167247", -- [22]
			"159423:159127:162666:165164:167255", -- [23]
			--["name"] = "Elysian Hold, Bastion",
			["direct"] = "159125:159423",
			["f"] = 0,
			["m"] = 1707,
			["coord"] = 2183298110,
			["requirements"] = "qid:60492", --Kyrian
		},
		[165701] = {
			"165164:162666", -- [1]
			"165164:162666:158526:156295", -- [2]
			"165164:162666:158526:156196:158416", -- [3]
			"165164:162666:158526:158417", -- [4]
			"165164:162666:158526:156295:158517", -- [5]
			"165164:162666:158526", -- [6]
			"165164:162666:158526:156196:158416:158533", -- [7]
			"165164:162666:158526:156295:158517:158564", -- [8]
			"165164:162666:158526:156196", -- [9]
			"165164:162666:159127", -- [10]
			"165164:162666:159127:159423:159125", -- [11]
			"165164:162666:159127:159423", -- [12]
			"165164:162666:158526:156196:160202", -- [13]
			"165164:162666:157540:157519", -- [14]
			"165164:162666:157540:157518", -- [15]
			"165164:162666:157540:157517", -- [16]
			"165164:162666:157540:157516", -- [17]
			"165164:162666:157540", -- [18]
			"165164:162666:157540:157515", -- [19]
			"165164:162666:159127:159423:159125:175457", -- [20]
			--["name"] = "Heart of the Forest, Ardenweald",
			["direct"] = "167243:165164:165166:167265:167247",
			["f"] = 0,
			["m"] = 1701,
			["coord"] = 2210075703,
			["requirements"] = "qid:61479", --available if chose Night Fae Covenant
		},
		[157540] = {
			"162666:159127:159423:159421", -- [1]
			"162666:165164:165701", -- [1]
			"162666:165164:165701:167265", -- [2]		
			"162666:158526:156196:158416:162702", -- [1]
			"162666:159127:159423:159125:175457", -- [2]		
			"162666:158526:156295", -- [1]
			"162666:158526:156196:158416", -- [2]
			"162666:158526:158417", -- [3]
			"162666:158526:156295:158517", -- [4]
			"162666:158526", -- [5]
			"162666:158526:156196:158416:158533", -- [6]
			"162666:158526:156295:158517:158564", -- [7]
			"162666:158526:156196", -- [8]
			"162666:159127", -- [9]
			"162666:159127:159423:159125", -- [10]
			"162666:159127:159423", -- [11]
			"162666:158526:156196:160202", -- [12]
			"162666:165164:167243", -- [13]
			"162666:165164", -- [14]
			"162666:165164:165166", -- [15]
			"162666:165164:167255:167265", -- [16]
			"162666:165164:165166:167247", -- [17]
			"162666:165164:167255", -- [18]
			--["name"] = "Theater of Pain, Maldraxxus",
			["direct"] = "162666:157519:157518:157517:157516:157515",
			["m"] = 1536,
			["coord"] = 2143324253,
			["f"] = 0,
		},
		[159125] = {
			"159423:159127:162666:165164:165701", -- [1]
			"159423:159127:162666:165164:165701:167265", -- [2]		
			"159423:159127:162666:158526:156196:158416:162702", -- [1]
			"159423:159127:162666", -- [1]
			"159423:159127:162666:158526:156295", -- [2]
			"159423:159127:162666:158526:156196:158416", -- [3]
			"159423:159127:162666:158526:158417", -- [4]
			"159423:159127:162666:158526:156295:158517", -- [5]
			"159423:159127:162666:158526", -- [6]
			"159423:159127:162666:158526:156196:158416:158533", -- [7]
			"159423:159127:162666:158526:156295:158517:158564", -- [8]
			"159423:159127:162666:158526:156196", -- [9]
			"159423:159127", -- [10]
			"159423:159127:162666:158526:156196:160202", -- [11]
			"159423:159127:162666:157540:157519", -- [12]
			"159423:159127:162666:157540:157518", -- [13]
			"159423:159127:162666:157540:157517", -- [14]
			"159423:159127:162666:157540:157516", -- [15]
			"159423:159127:162666:157540", -- [16]
			"159423:159127:162666:157540:157515", -- [17]
			"159423:159127:162666:165164:167243", -- [18]
			"159423:159127:162666:165164", -- [19]
			"159423:159127:162666:165164:165166", -- [20]
			"159423:159127:162666:165164:167255:167265", -- [21]
			"159423:159127:162666:165164:165166:167247", -- [22]
			"159423:159127:162666:165164:167255", -- [23]
			--["name"] = "Sagehaven, Bastion",
			["m"] = 1533,
			["direct"] = "159421:159423:175457",
			["coord"] = 1893815057,
			["f"] = 0,
		},
		[158416] = {
			"156196:158526:162666:159127:159423:159421", -- [1]
			"156196:158526:162666:165164:165701", -- [1]
			"156196:158526:162666:165164:165701:167265", -- [2]		
			"156196:158526:162666:159127:159423:159125:175457", -- [1]
			"156196:158526:162666", -- [1]
			"160202:156295", -- [2]
			"160202:158517:158417", -- [3]
			"160202:158517", -- [4]
			"156196:158526", -- [5]
			"156196:158526:162666:159127", -- [6]
			"156196:158526:162666:159127:159423:159125", -- [7]
			"156196:158526:162666:159127:159423", -- [8]
			"156196:158526:162666:157540:157519", -- [9]
			"156196:158526:162666:157540:157518", -- [10]
			"156196:158526:162666:157540:157517", -- [11]
			"156196:158526:162666:157540:157516", -- [12]
			"156196:158526:162666:157540", -- [13]
			"156196:158526:162666:157540:157515", -- [14]
			"156196:158526:162666:165164:167243", -- [15]
			"156196:158526:162666:165164", -- [16]
			"156196:158526:162666:165164:165166", -- [17]
			"156196:158526:162666:165164:167255:167265", -- [18]
			"156196:158526:162666:165164:165166:167247", -- [19]
			"156196:158526:162666:165164:167255", -- [20]
			--["name"] = "Sanctuary of the Mad, Revendreth",
			["direct"] = "158533:158564:156196:160202:162702",
			["m"] = 1525,
			["coord"] = 1312914622,
			["f"] = 0,
		},
		[167255] = {
			"165164:162666:159127:159423:159421", -- [1]
			"165164:162666:158526:156196:158416:162702", -- [1]
			"165164:162666:159127:159423:159125:175457", -- [2]		
			"165164:162666", -- [1]
			"165164:162666:158526:156295", -- [2]
			"165164:162666:158526:156196:158416", -- [3]
			"165164:162666:158526:158417", -- [4]
			"165164:162666:158526:156295:158517", -- [5]
			"165164:162666:158526", -- [6]
			"165164:162666:158526:156196:158416:158533", -- [7]
			"165164:162666:158526:156295:158517:158564", -- [8]
			"165164:162666:158526:156196", -- [9]
			"165164:162666:159127", -- [10]
			"165164:162666:159127:159423:159125", -- [11]
			"165164:162666:159127:159423", -- [12]
			"165164:162666:158526:156196:160202", -- [13]
			"165164:162666:157540:157519", -- [14]
			"165164:162666:157540:157518", -- [15]
			"165164:162666:157540:157517", -- [16]
			"165164:162666:157540:157516", -- [17]
			"165164:162666:157540", -- [18]
			"165164:162666:157540:157515", -- [19]
			--["name"] = "Refugee Camp, Ardenweald",
			["direct"] = "167243:165164:165166:167265:167247",
			["requirements"] = "nqid:61479", --Not available if chose Night Fae Covenant
			["m"] = 1565,
			["coord"] = 2117567702,
			["f"] = 0,
		},
		[158517] = {
			"156295:158526:162666:159127:159423:159421", -- [1]
			"156295:158526:162666:165164:165701", -- [1]
			"156295:158526:162666:165164:165701:167265", -- [2]		
			"160202:158416:162702", -- [1]
			"156295:158526:162666:159127:159423:159125:175457", -- [2]		
			"156295:158526:162666", -- [1]
			"160202:158416", -- [2]
			"156295:158526", -- [3]
			"158564:158533", -- [4]
			"156295:158526:162666:159127", -- [5]
			"156295:158526:162666:159127:159423:159125", -- [6]
			"156295:158526:162666:159127:159423", -- [7]
			"156295:158526:162666:157540:157519", -- [8]
			"156295:158526:162666:157540:157518", -- [9]
			"156295:158526:162666:157540:157517", -- [10]
			"156295:158526:162666:157540:157516", -- [11]
			"156295:158526:162666:157540", -- [12]
			"156295:158526:162666:157540:157515", -- [13]
			"156295:158526:162666:165164:167243", -- [14]
			"156295:158526:162666:165164", -- [15]
			"156295:158526:162666:165164:165166", -- [16]
			"156295:158526:162666:165164:167255:167265", -- [17]
			"156295:158526:162666:165164:165166:167247", -- [18]
			"156295:158526:162666:165164:167255", -- [19]
			--["name"] = "Old Gate, Revendreth",
			["direct"] = "156295:158417:158564:156196:160202",
			["m"] = 1525,
			["coord"] = 2629198652,
			["f"] = 0,
		},
		[156196] = {
			"156295:158526:162666:159127:159423:159421", -- [1]
			"158526:162666:165164:165701", -- [1]
			"158526:162666:165164:165701:167265", -- [2]		
			"158416:162702", -- [1]
			"158526:162666:159127:159423:159125:175457", -- [2]		
			"158526:162666", -- [1]
			"156295:158417", -- [2]
			"158416:158533", -- [3]
			"160202:158564", -- [4]
			"158526:162666:159127", -- [5]
			"158526:162666:159127:159423:159125", -- [6]
			"158526:162666:159127:159423", -- [7]
			"158526:162666:157540:157519", -- [8]
			"158526:162666:157540:157518", -- [9]
			"158526:162666:157540:157517", -- [10]
			"158526:162666:157540:157516", -- [11]
			"158526:162666:157540", -- [12]
			"158526:162666:157540:157515", -- [13]
			"158526:162666:165164:167243", -- [14]
			"158526:162666:165164", -- [15]
			"158526:162666:165164:165166", -- [16]
			"158526:162666:165164:167255:167265", -- [17]
			"158526:162666:165164:165166:167247", -- [18]
			"158526:162666:165164:167255", -- [19]
			--["name"] = "Wanecrypt Hill, Revendreth",
			["direct"] = "156295:158416:158517:158526:160202",
			["m"] = 1525,
			["coord"] = 2057417215,
			["f"] = 0,
		},
		[158564] = {
			"158517:156295:158526:162666:159127:159423:159421", -- [1]
			"158517:156295:158526:162666:165164:165701", -- [1]
			"158517:156295:158526:162666:165164:165701:167265", -- [2]		
			"158416:162702", -- [1]
			"158517:156295:158526:162666:159127:159423:159125:175457", -- [2]		
			"158517:156295:158526:162666", -- [1]
			"158517:156295", -- [2]
			"158517:158417", -- [3]
			"158517:156295:158526", -- [4]
			"158517:156196", -- [5]
			"158517:156295:158526:162666:159127", -- [6]
			"158517:156295:158526:162666:159127:159423:159125", -- [7]
			"158517:156295:158526:162666:159127:159423", -- [8]
			"158517:156295:158526:162666:157540:157519", -- [9]
			"158517:156295:158526:162666:157540:157518", -- [10]
			"158517:156295:158526:162666:157540:157517", -- [11]
			"158517:156295:158526:162666:157540:157516", -- [12]
			"158517:156295:158526:162666:157540", -- [13]
			"158517:156295:158526:162666:157540:157515", -- [14]
			"158517:156295:158526:162666:165164:167243", -- [15]
			"158517:156295:158526:162666:165164", -- [16]
			"158517:156295:158526:162666:165164:165166", -- [17]
			"158517:156295:158526:162666:165164:167255:167265", -- [18]
			"158517:156295:158526:162666:165164:165166:167247", -- [19]
			"158517:156295:158526:162666:165164:167255", -- [20]
			--["name"] = "Menagerie of the Master, Revendreth",
			["direct"] = "158416:158517:158533:160202",
			["m"] = 1525,
			["coord"] = 2327134608,
			["f"] = 0,
		},
		[157514] = {
			"157540:162666", -- [1]
			"157540:162666:158526:156295", -- [2]
			"157540:162666:158526:156196:158416", -- [3]
			"157540:162666:158526:158417", -- [4]
			"157540:162666:158526:156295:158517", -- [5]
			"157540:162666:158526", -- [6]
			"157540:162666:158526:156196:158416:158533", -- [7]
			"157540:162666:158526:156295:158517:158564", -- [8]
			"157540:162666:158526:156196", -- [9]
			"157540:162666:159127", -- [10]
			"157540:162666:159127:159423:159125", -- [11]
			"157540:162666:159127:159423", -- [12]
			"157540:162666:158526:156196:160202", -- [13]
			"157540:157517", -- [14]
			"157540:162666:165164:167243", -- [15]
			"157540:162666:165164", -- [16]
			"157540:162666:165164:165166", -- [17]
			"157540:162666:165164:167255:167265", -- [18]
			"157540:162666:165164:165166:167247", -- [19]
			"157540:162666:165164:167255", -- [20]
			"157540:162666:159127:159423:159125:175457", -- [21]
			--["name"] = "Bleak Redoubt, Maldraxxus",
			["requirements"] = "qid:58609", -- Necrolord 
			["direct"] = "157519:157518:157516:157540:157515",
			["coord"] = 2253761843,
			["m"] = 1536,
			["f"] = 0,
		},		
		[158417] = {
			"158526:162666:159127:159423:159421", -- [1]
			"158526:162666:165164:165701", -- [1]
			"158526:162666:165164:165701:167265", -- [2]
			"158526:162666:159127:159423:159125:175457", -- [3]		
			"160202:158416:162702", -- [1]
			"156295:158526:162666:159127:159423:159125:175457", -- [2]		
			"158526:162666", -- [1]
			"158517:160202:158416", -- [2]
			"158517:158564:158533", -- [3]
			"158517:158564", -- [4]
			"156295:156196", -- [5]
			"158526:162666:159127", -- [6]
			"158526:162666:159127:159423:159125", -- [7]
			"158526:162666:159127:159423", -- [8]
			"158517:160202", -- [9]
			"158526:162666:157540:157519", -- [10]
			"158526:162666:157540:157518", -- [11]
			"158526:162666:157540:157517", -- [12]
			"158526:162666:157540:157516", -- [13]
			"158526:162666:157540", -- [14]
			"158526:162666:157540:157515", -- [15]
			"158526:162666:165164:167243", -- [16]
			"158526:162666:165164", -- [17]
			"158526:162666:165164:165166", -- [18]
			"158526:162666:165164:167255:167265", -- [19]
			"158526:162666:165164:165166:167247", -- [20]
			"158526:162666:165164:167255", -- [21]
			--["name"] = "Halls of Atonement, Revendreth",
			["direct"] = "156295:158517:158526",
			["m"] = 1525,
			["coord"] = 3070977703,
			["f"] = 0,
		},
		[158526] = {
			"162666:159127:159423:159421", -- [1]
			"162666:165164:165701", -- [1]
			"162666:165164:165701:167265", -- [2]		
			"156196:158416:162702", -- [1]
			"162666:159127:159423:159125:175457", -- [2]		
			"156196:158416", -- [1]
			"156295:158517", -- [2]
			"156196:158416:158533", -- [3]
			"156295:158517:158564", -- [4]
			"162666:159127", -- [5]
			"162666:159127:159423:159125", -- [6]
			"162666:159127:159423", -- [7]
			"156196:160202", -- [8]
			"162666:157540:157519", -- [9]
			"162666:157540:157518", -- [10]
			"162666:157540:157517", -- [11]
			"162666:157540:157516", -- [12]
			"162666:157540", -- [13]
			"162666:157540:157515", -- [14]
			"162666:165164:167243", -- [15]
			"162666:165164", -- [16]
			"162666:165164:165166", -- [17]
			"162666:165164:167255:167265", -- [18]
			"162666:165164:165166:167247", -- [19]
			"162666:165164:167255", -- [20]
			--["name"] = "Pridefall Hamlet, Revendreth",
			["direct"] = "162666:156295:158417:156196",
			["m"] = 1525,
			["coord"] = 3022180288,
			["f"] = 0,
		},
		[165164] = {
			"162666:159127:159423:159421", -- [1]
			"165701:167265", -- [1]
			"162666:158526:156196:158416:162702", -- [1]
			"162666:159127:159423:159125:175457", -- [2]		
			"162666:158526:156295", -- [1]
			"162666:158526:156196:158416", -- [2]
			"162666:158526:158417", -- [3]
			"162666:158526:156295:158517", -- [4]
			"162666:158526", -- [5]
			"162666:158526:156196:158416:158533", -- [6]
			"162666:158526:156295:158517:158564", -- [7]
			"162666:158526:156196", -- [8]
			"162666:159127", -- [9]
			"162666:159127:159423:159125", -- [10]
			"162666:159127:159423", -- [11]
			"162666:158526:156196:160202", -- [12]
			"162666:157540:157519", -- [13]
			"162666:157540:157518", -- [14]
			"162666:157540:157517", -- [15]
			"162666:157540:157516", -- [16]
			"162666:157540", -- [17]
			"162666:157540:157515", -- [18]
			"167255:167265", -- [19]
			"165166:167247", -- [20]
			--["name"] = "Tirna Vaal, Ardenweald",
			["direct"] = "162666:167243:165166:167255:165701",
			["m"] = 1565,
			["coord"] = 2722586628,
			["f"] = 0,
		},
		[159127] = {
			"159423:159421", -- [1]
			"162666:165164:165701", -- [1]
			"162666:165164:165701:167265", -- [2]		
			"162666:158526:156196:158416:162702", -- [1]
			"159423:159125:175457", -- [2]		
			"162666:158526:156295", -- [1]
			"162666:158526:156196:158416", -- [2]
			"162666:158526:158417", -- [3]
			"162666:158526:156295:158517", -- [4]
			"162666:158526", -- [5]
			"162666:158526:156196:158416:158533", -- [6]
			"162666:158526:156295:158517:158564", -- [7]
			"162666:158526:156196", -- [8]
			"159423:159125", -- [9]
			"162666:158526:156196:160202", -- [10]
			"162666:157540:157519", -- [11]
			"162666:157540:157518", -- [12]
			"162666:157540:157517", -- [13]
			"162666:157540:157516", -- [14]
			"162666:157540", -- [15]
			"162666:157540:157515", -- [16]
			"162666:165164:167243", -- [17]
			"162666:165164", -- [18]
			"162666:165164:165166", -- [19]
			"162666:165164:167255:167265", -- [20]
			"162666:165164:165166:167247", -- [21]
			"162666:165164:167255", -- [22]
			--["name"] = "Aspirant's Rest, Bastion",
			["direct"] = "162666:159423",
			["m"] = 1533,
			["coord"] = 2066726380,
			["f"] = 0,
		},
		[157519] = {
			"157540:162666:159127:159423:159421", -- [1]
			"157540:162666:158526:156196:158416:162702", -- [1]
			"157540:162666:159127:159423:159125:175457", -- [2]		
			"157540:162666", -- [1]
			"157540:162666:158526:156295", -- [2]
			"157540:162666:158526:156196:158416", -- [3]
			"157540:162666:158526:158417", -- [4]
			"157540:162666:158526:156295:158517", -- [5]
			"157540:162666:158526", -- [6]
			"157540:162666:158526:156196:158416:158533", -- [7]
			"157540:162666:158526:156295:158517:158564", -- [8]
			"157540:162666:158526:156196", -- [9]
			"157540:162666:159127", -- [10]
			"157540:162666:159127:159423:159125", -- [11]
			"157540:162666:159127:159423", -- [12]
			"157540:162666:158526:156196:160202", -- [13]
			"157540:157516", -- [14]
			"157540:162666:165164:167243", -- [15]
			"157540:162666:165164", -- [16]
			"157540:162666:165164:165166", -- [17]
			"157540:162666:165164:167255:167265", -- [18]
			"157540:162666:165164:165166:167247", -- [19]
			"157540:162666:165164:167255", -- [20]
			--["name"] = "The Spearhead, Maldraxxus",
			["direct"] = "157518:157517:157540:157515",
			["m"] = 1536,
			["coord"] = 1677823375,
			["f"] = 0,
		},
		[157515] = {
			"157540:162666:159127:159423:159421", -- [1]
			"157540:162666:165164:165701", -- [1]
			"157540:162666:165164:165701:167265", -- [2]		
			"157540:162666:158526:156196:158416:162702", -- [1]
			"157540:157518", -- [2]
			"157540:162666:159127:159423:159125:175457", -- [3]		
			"157540:162666", -- [1]
			"157540:162666:158526:156295", -- [2]
			"157540:162666:158526:156196:158416", -- [3]
			"157540:162666:158526:158417", -- [4]
			"157540:162666:158526:156295:158517", -- [5]
			"157540:162666:158526", -- [6]
			"157540:162666:158526:156196:158416:158533", -- [7]
			"157540:162666:158526:156295:158517:158564", -- [8]
			"157540:162666:158526:156196", -- [9]
			"157540:162666:159127", -- [10]
			"157540:162666:159127:159423:159125", -- [11]
			"157540:162666:159127:159423", -- [12]
			"157540:162666:158526:156196:160202", -- [13]
			"157514:157518", -- [14]
			"157540:157517", -- [15]
			"157540:162666:165164:167243", -- [16]
			"157540:162666:165164", -- [17]
			"157540:162666:165164:165166", -- [18]
			"157540:162666:165164:167255:167265", -- [19]
			"157540:162666:165164:165166:167247", -- [20]
			"157540:162666:165164:167255", -- [21]
			--["name"] = "Plague Watch, Maldraxxus",
			["direct"] = "157519:157516:157540",
			["m"] = 1536,
			["coord"] = 2499524914,
			["f"] = 0,
		},
		[167247] = {
			"165166:165164:162666:159127:159423:159421", -- [1]
			"165701:167243", -- [1]
			"165166:165164:162666:158526:156196:158416:162702", -- [1]
			"165166:165164:162666:159127:159423:159125:175457", -- [2]		
			"165166:165164:162666", -- [1]
			"165166:165164:162666:158526:156295", -- [2]
			"165166:165164:162666:158526:156196:158416", -- [3]
			"165166:165164:162666:158526:158417", -- [4]
			"165166:165164:162666:158526:156295:158517", -- [5]
			"165166:165164:162666:158526", -- [6]
			"165166:165164:162666:158526:156196:158416:158533", -- [7]
			"165166:165164:162666:158526:156295:158517:158564", -- [8]
			"165166:165164:162666:158526:156196", -- [9]
			"165166:165164:162666:159127", -- [10]
			"165166:165164:162666:159127:159423:159125", -- [11]
			"165166:165164:162666:159127:159423", -- [12]
			"165166:165164:162666:158526:156196:160202", -- [13]
			"165166:165164:162666:157540:157519", -- [14]
			"165166:165164:162666:157540:157518", -- [15]
			"165166:165164:162666:157540:157517", -- [16]
			"165166:165164:162666:157540:157516", -- [17]
			"165166:165164:162666:157540", -- [18]
			"165166:165164:162666:157540:157515", -- [19]
			"167255:167243", -- [20]
			"165166:165164", -- [21]
			--["name"] = "Claw's Edge, Ardenweald",
			["direct"] = "165166:167265:167255:165701",
			["m"] = 1565,
			["coord"] = 2202252864,
			["f"] = 0,
		},
		[167265] = {
			"167255:165164:162666:159127:159423:159421", -- [1]
			"165701:165164:162666", -- [1]
			"165701:165164:162666:158526:156295", -- [2]
			"165701:165164:162666:158526:156196:158416", -- [3]
			"165701:165164:162666:158526:158417", -- [4]
			"165701:165164:162666:158526:156295:158517", -- [5]
			"165701:165164:162666:158526", -- [6]
			"165701:165164:162666:158526:156196:158416:158533", -- [7]
			"165701:165164:162666:158526:156295:158517:158564", -- [8]
			"165701:165164:162666:158526:156196", -- [9]
			"165701:165164:162666:159127", -- [10]
			"165701:165164:162666:159127:159423:159125", -- [11]
			"165701:165164:162666:159127:159423", -- [12]
			"165701:165164:162666:158526:156196:160202", -- [13]
			"165701:165164:162666:157540:157519", -- [14]
			"165701:165164:162666:157540:157518", -- [15]
			"165701:165164:162666:157540:157517", -- [16]
			"165701:165164:162666:157540:157516", -- [17]
			"165701:165164:162666:157540", -- [18]
			"165701:165164:162666:157540:157515", -- [19]
			"165701:165164", -- [20]
			"165701:165166", -- [21]
			"165701:165164:162666:159127:159423:159125:175457", -- [22]		
			"167255:165164:162666:158526:156196:158416:162702", -- [1]
			"167255:165164:162666:159127:159423:159125:175457", -- [2]		
			"167255:165164:162666", -- [1]
			"167255:165164:162666:158526:156295", -- [2]
			"167255:165164:162666:158526:156196:158416", -- [3]
			"167255:165164:162666:158526:158417", -- [4]
			"167255:165164:162666:158526:156295:158517", -- [5]
			"167255:165164:162666:158526", -- [6]
			"167255:165164:162666:158526:156196:158416:158533", -- [7]
			"167255:165164:162666:158526:156295:158517:158564", -- [8]
			"167255:165164:162666:158526:156196", -- [9]
			"167255:165164:162666:159127", -- [10]
			"167255:165164:162666:159127:159423:159125", -- [11]
			"167255:165164:162666:159127:159423", -- [12]
			"167255:165164:162666:158526:156196:160202", -- [13]
			"167255:165164:162666:157540:157519", -- [14]
			"167255:165164:162666:157540:157518", -- [15]
			"167255:165164:162666:157540:157517", -- [16]
			"167255:165164:162666:157540:157516", -- [17]
			"167255:165164:162666:157540", -- [18]
			"167255:165164:162666:157540:157515", -- [19]
			"167255:165164", -- [20]
			"167255:165166", -- [21]
			--["name"] = "Root-Home, Ardenweald",
			["direct"] = "167243:167247:167255:165701",
			["m"] = 1565,
			["coord"] = 1512277105,
			["f"] = 0,
		},
		[156295] = {
			"158526:162666:159127:159423:159421", -- [1]
			"158526:162666:165164:165701", -- [1]
			"158526:162666:165164:165701:167265", -- [2]		
			"160202:158416:162702", -- [1]
			"158526:162666:159127:159423:159125:175457", -- [2]		
			"158526:162666", -- [1]
			"160202:158416", -- [2]
			"160202:158416:158533", -- [3]
			"158517:158564", -- [4]
			"158526:162666:159127", -- [5]
			"158526:162666:159127:159423:159125", -- [6]
			"158526:162666:159127:159423", -- [7]
			"158526:162666:157540:157519", -- [8]
			"158526:162666:157540:157518", -- [9]
			"158526:162666:157540:157517", -- [10]
			"158526:162666:157540:157516", -- [11]
			"158526:162666:157540", -- [12]
			"158526:162666:157540:157515", -- [13]
			"158526:162666:165164:167243", -- [14]
			"158526:162666:165164", -- [15]
			"158526:162666:165164:165166", -- [16]
			"158526:162666:165164:167255:167265", -- [17]
			"158526:162666:165164:165166:167247", -- [18]
			"158526:162666:165164:167255", -- [19]
			--["name"] = "Darkhaven, Revendreth",
			["direct"] = "158417:158517:158526:156196:160202",
			["m"] = 1525,
			["coord"] = 2599197532,
			["f"] = 0,
		},
		[165166] = {
			"165164:162666:159127:159423:159421", -- [1]
			"165164:162666:158526:156196:158416:162702", -- [1]
			"165164:162666:159127:159423:159125:175457", -- [2]		
			"165164:162666", -- [1]
			"165164:162666:158526:156295", -- [2]
			"165164:162666:158526:156196:158416", -- [3]
			"165164:162666:158526:158417", -- [4]
			"165164:162666:158526:156295:158517", -- [5]
			"165164:162666:158526", -- [6]
			"165164:162666:158526:156196:158416:158533", -- [7]
			"165164:162666:158526:156295:158517:158564", -- [8]
			"165164:162666:158526:156196", -- [9]
			"165164:162666:159127", -- [10]
			"165164:162666:159127:159423:159125", -- [11]
			"165164:162666:159127:159423", -- [12]
			"165164:162666:158526:156196:160202", -- [13]
			"165164:162666:157540:157519", -- [14]
			"165164:162666:157540:157518", -- [15]
			"165164:162666:157540:157517", -- [16]
			"165164:162666:157540:157516", -- [17]
			"165164:162666:157540", -- [18]
			"165164:162666:157540:157515", -- [19]
			"167255:167265", -- [20]
			--["name"] = "Hibernal Hollow, Ardenweald",
			["direct"] = "167243:165164:167247:167255",
			["m"] = 1565,
			["coord"] = 2588903648,
			["f"] = 0,
		},
		[175457] = {
			"159125:159421", -- [1]
			"159125:159423:159127:162666:165164:165701", -- [1]
			"159125:159423:159127:162666:165164:165701:167265", -- [2]		
			"159125:159423:159127:162666", -- [1]
			"159125:159423:159127:162666:158526:156295", -- [2]
			"159125:159423:159127:162666:158526:156196:158416", -- [3]
			"159125:159423:159127:162666:158526:158417", -- [4]
			"159125:159423:159127:162666:158526:156295:158517", -- [5]
			"159125:159423:159127:162666:158526", -- [6]
			"159125:159423:159127:162666:158526:156196:158416:158533", -- [7]
			"159125:159423:159127:162666:158526:156295:158517:158564", -- [8]
			"159125:159423:159127:162666:158526:156196", -- [9]
			"159125:159423:159127", -- [10]
			"159125:159423", -- [11]
			"159125:159423:159127:162666:158526:156196:160202", -- [12]
			"159125:159423:159127:162666:158526:156196:158416:162702", -- [13]
			"159125:159423:159127:162666:157540:157519", -- [14]
			"159125:159423:159127:162666:157540:157518", -- [15]
			"159125:159423:159127:162666:157540:157517", -- [16]
			"159125:159423:159127:162666:157540:157516", -- [17]
			"159125:159423:159127:162666:157540", -- [18]
			"159125:159423:159127:162666:157540:157515", -- [19]
			"159125:159423:159127:162666:165164:167243", -- [20]
			"159125:159423:159127:162666:165164", -- [21]
			"159125:159423:159127:162666:165164:165166", -- [22]
			"159125:159423:159127:162666:165164:167255:167265", -- [23]
			"159125:159423:159127:162666:165164:165166:167247", -- [24]
			"159125:159423:159127:162666:165164:167255", -- [25]
			--["name"] = "Terrace of the Collectors, Bastion",
			["direct"] = "159125",
			["m"] = 1533,
			["coord"] = 1536636424,
			["f"] = 0,
		},		
		[167243] = {
			"165164:162666:159127:159423:159421", -- [1]
			"165701:167265", -- [1]
			"165164:162666:158526:156196:158416:162702", -- [1]
			"165164:162666:159127:159423:159125:175457", -- [2]		
			"165164:162666", -- [1]
			"165164:162666:158526:156295", -- [2]
			"165164:162666:158526:156196:158416", -- [3]
			"165164:162666:158526:158417", -- [4]
			"165164:162666:158526:156295:158517", -- [5]
			"165164:162666:158526", -- [6]
			"165164:162666:158526:156196:158416:158533", -- [7]
			"165164:162666:158526:156295:158517:158564", -- [8]
			"165164:162666:158526:156196", -- [9]
			"165164:162666:159127", -- [10]
			"165164:162666:159127:159423:159125", -- [11]
			"165164:162666:159127:159423", -- [12]
			"165164:162666:158526:156196:160202", -- [13]
			"165164:162666:157540:157519", -- [14]
			"165164:162666:157540:157518", -- [15]
			"165164:162666:157540:157517", -- [16]
			"165164:162666:157540:157516", -- [17]
			"165164:162666:157540", -- [18]
			"165164:162666:157540:157515", -- [19]
			"167255:167247", -- [20]
			--["name"] = "Glitterfall Basin, Ardenweald",
			["direct"] = "165164:165166:167265:167255:165701",
			["m"] = 1565,
			["coord"] = 2211141678,
			["f"] = 0,
		},
		[157516] = {
			"157540:162666:159127:159423:159421", -- [1]
			"157540:162666:165164:165701", -- [1]
			"157540:162666:165164:165701:167265", -- [2]
			"157540:162666:158526:156196:158416:162702", -- [1]
			"157540:162666:159127:159423:159125:175457", -- [2]
			"157540:162666", -- [1]
			"157540:162666:158526:156295", -- [2]
			"157540:162666:158526:156196:158416", -- [3]
			"157540:162666:158526:158417", -- [4]
			"157540:162666:158526:156295:158517", -- [5]
			"157540:162666:158526", -- [6]
			"157540:162666:158526:156196:158416:158533", -- [7]
			"157540:162666:158526:156295:158517:158564", -- [8]
			"157540:162666:158526:156196", -- [9]
			"157540:162666:159127", -- [10]
			"157540:162666:159127:159423:159125", -- [11]
			"157540:162666:159127:159423", -- [12]
			"157540:162666:158526:156196:160202", -- [13]
			"157540:157519", -- [14]
			"157540:162666:165164:167243", -- [15]
			"157540:162666:165164", -- [16]
			"157540:162666:165164:165166", -- [17]
			"157540:162666:165164:167255:167265", -- [18]
			"157540:162666:165164:165166:167247", -- [19]
			"157540:162666:165164:167255", -- [20]
			--["name"] = "Renounced Bastille, Maldraxxus",
			["direct"] = "157518:157517:157540:157515",
			["m"] = 1536,
			["coord"] = 2914481499,
			["f"] = 0,
		},
		[162666] = {
			"159127:159423:159421", -- [1]
			"165164:165701", -- [1]
			"165164:165701:167265", -- [2]		
			"158526:156196:158416:162702", -- [1]
			"159127:159423:159125:175457", -- [2]		
			"158526:156295", -- [1]
			"158526:156196:158416", -- [2]
			"158526:158417", -- [3]
			"158526:156295:158517", -- [4]
			"158526:156196:158416:158533", -- [5]
			"158526:156295:158517:158564", -- [6]
			"158526:156196", -- [7]
			"159127:159423:159125", -- [8]
			"159127:159423", -- [9]
			"158526:156196:160202", -- [10]
			"157540:157519", -- [11]
			"157540:157518", -- [12]
			"157540:157517", -- [13]
			"157540:157516", -- [14]
			"157540:157515", -- [15]
			"165164:167243", -- [16]
			"165164:165166", -- [17]
			"165164:167255:167265", -- [18]
			"165164:165166:167247", -- [19]
			"165164:167255", -- [20]
			--["name"] = "Oribos",
			["direct"] = "158526:159127:157540:165164",
			["m"] = 1671,
			["coord"] = 2585046256,
			["f"] = 0,
		},
		[157517] = {
			"157540:162666:159127:159423:159421", -- [1]
			"157540:162666:165164:165701", -- [1]
			"157540:162666:165164:165701:167265", -- [2]		
			"157540:162666:158526:156196:158416:162702", -- [1]
			"157540:162666:159127:159423:159125:175457", -- [2]		
			"157540:162666", -- [1]
			"157540:162666:158526:156295", -- [2]
			"157540:162666:158526:156196:158416", -- [3]
			"157540:162666:158526:158417", -- [4]
			"157540:162666:158526:156295:158517", -- [5]
			"157540:162666:158526", -- [6]
			"157540:162666:158526:156196:158416:158533", -- [7]
			"157540:162666:158526:156295:158517:158564", -- [8]
			"157540:162666:158526:156196", -- [9]
			"157540:162666:159127", -- [10]
			"157540:162666:159127:159423:159125", -- [11]
			"157540:162666:159127:159423", -- [12]
			"157540:162666:158526:156196:160202", -- [13]
			"157540:157515", -- [14]
			"157540:162666:165164:167243", -- [15]
			"157540:162666:165164", -- [16]
			"157540:162666:165164:165166", -- [17]
			"157540:162666:165164:167255:167265", -- [18]
			"157540:162666:165164:165166:167247", -- [19]
			"157540:162666:165164:167255", -- [20]
			--["name"] = "Keres' Rest, Maldraxxus",
			["direct"] = "157519:157518:157516:157540",
			["m"] = 1536,
			["coord"] = 2313571922,
			["f"] = 0,
		},
		[157518] = {
			"157540:162666:159127:159423:159421", -- [1]
			"157540:162666:165164:165701", -- [1]
			"157540:162666:165164:165701:167265", -- [2]		
			"157540:162666:158526:156196:158416:162702", -- [1]
			"157540:157515", -- [2]
			"157540:162666:159127:159423:159125:175457", -- [3]		
			"157540:162666", -- [1]
			"157540:162666:158526:156295", -- [2]
			"157540:162666:158526:156196:158416", -- [3]
			"157540:162666:158526:158417", -- [4]
			"157540:162666:158526:156295:158517", -- [5]
			"157540:162666:158526", -- [6]
			"157540:162666:158526:156196:158416:158533", -- [7]
			"157540:162666:158526:156295:158517:158564", -- [8]
			"157540:162666:158526:156196", -- [9]
			"157540:162666:159127", -- [10]
			"157540:162666:159127:159423:159125", -- [11]
			"157540:162666:159127:159423", -- [12]
			"157540:162666:158526:156196:160202", -- [13]
			"157514:157515", -- [14]
			"157540:162666:165164:167243", -- [15]
			"157540:162666:165164", -- [16]
			"157540:162666:165164:165166", -- [17]
			"157540:162666:165164:167255:167265", -- [18]
			"157540:162666:165164:165166:167247", -- [19]
			"157540:162666:165164:167255", -- [20]
			--["name"] = "Spider's Watch, Maldraxxus",
			["direct"] = "157519:157517:157516:157540",
			["m"] = 1536,
			["coord"] = 1612597947,
			["f"] = 0,
		},
		[159423] = {
			"159127:162666:165164:165701", -- [1]
			"159127:162666:165164:165701:167265", -- [2]		
			"159127:162666:158526:156196:158416:162702", -- [1]
			"159125:175457", -- [2]		
			"159127:162666", -- [1]
			"159127:162666:158526:156295", -- [2]
			"159127:162666:158526:156196:158416", -- [3]
			"159127:162666:158526:158417", -- [4]
			"159127:162666:158526:156295:158517", -- [5]
			"159127:162666:158526", -- [6]
			"159127:162666:158526:156196:158416:158533", -- [7]
			"159127:162666:158526:156295:158517:158564", -- [8]
			"159127:162666:158526:156196", -- [9]
			"159127:162666:158526:156196:160202", -- [10]
			"159127:162666:157540:157519", -- [11]
			"159127:162666:157540:157518", -- [12]
			"159127:162666:157540:157517", -- [13]
			"159127:162666:157540:157516", -- [14]
			"159127:162666:157540", -- [15]
			"159127:162666:157540:157515", -- [16]
			"159127:162666:165164:167243", -- [17]
			"159127:162666:165164", -- [18]
			"159127:162666:165164:165166", -- [19]
			"159127:162666:165164:167255:167265", -- [20]
			"159127:162666:165164:165166:167247", -- [21]
			"159127:162666:165164:167255", -- [22]
			--["name"] = "Hero's Rest, Bastion",
			["direct"] = "159127:159125:159421",
			["m"] = 1533,
			["coord"] = 2208790454,
			["f"] = 0,
		},
		[160202] = {
			"156295:158526:162666:159127:159423:159421", -- [1]
			"156295:158526:162666:165164:165701", -- [1]
			"156295:158526:162666:165164:165701:167265", -- [2]		
			"158416:162702", -- [1]
			"156295:158526:162666:159127:159423:159125:175457", -- [2]		
			"156295:158526:162666", -- [1]
			"158517:158417", -- [2]
			"156295:158526", -- [3]
			"158416:158533", -- [4]
			"156295:158526:162666:159127", -- [5]
			"156295:158526:162666:159127:159423:159125", -- [6]
			"156295:158526:162666:159127:159423", -- [7]
			"156295:158526:162666:157540:157519", -- [8]
			"156295:158526:162666:157540:157518", -- [9]
			"156295:158526:162666:157540:157517", -- [10]
			"156295:158526:162666:157540:157516", -- [11]
			"156295:158526:162666:157540", -- [12]
			"156295:158526:162666:157540:157515", -- [13]
			"156295:158526:162666:165164:167243", -- [14]
			"156295:158526:162666:165164", -- [15]
			"156295:158526:162666:165164:165166", -- [16]
			"156295:158526:162666:165164:167255:167265", -- [17]
			"156295:158526:162666:165164:165166:167247", -- [18]
			"156295:158526:162666:165164:167255", -- [19]
			--["name"] = "Charred Ramparts, Revendreth",
			["direct"] = "156295:158416:158517:158564:156196",
			["m"] = 1525,
			["coord"] = 1673821706,
			["f"] = 0,
		},
		[162702] = {
			"158416:156196:158526:162666", -- [1]
			"158416:160202:156295", -- [2]
			"158416:160202:158517:158417", -- [3]
			"158416:160202:158517", -- [4]
			"158416:156196:158526", -- [5]
			"158416:158533", -- [6]
			"158416:158564", -- [7]
			"158416:156196", -- [8]
			"158416:156196:158526:162666:159127", -- [9]
			"158416:156196:158526:162666:159127:159423:159125", -- [10]
			"158416:156196:158526:162666:159127:159423", -- [11]
			"158416:160202", -- [12]
			"158416:156196:158526:162666:157540:157519", -- [13]
			"158416:156196:158526:162666:157540:157518", -- [14]
			"158416:156196:158526:162666:157540:157517", -- [15]
			"158416:156196:158526:162666:157540:157516", -- [16]
			"158416:156196:158526:162666:157540", -- [17]
			"158416:156196:158526:162666:157540:157515", -- [18]
			"158416:156196:158526:162666:165164:167243", -- [19]
			"158416:156196:158526:162666:165164", -- [20]
			"158416:156196:158526:162666:165164:165166", -- [21]
			"158416:156196:158526:162666:165164:167255:167265", -- [22]
			"158416:156196:158526:162666:165164:165166:167247", -- [23]
			"158416:156196:158526:162666:165164:167255", -- [24]
			"158416:156196:158526:162666:159127:159423:159125:175457", -- [25]
			--["name"] = "Sinfall, Revendreth",
			["requirements"] = "qid:59315", -- Revendreth 
			["direct"] = "158416",
			["f"] = 0,
			["m"] = 1699,
			["coord"] = 2871802302,
		},		
		[158533] = {
			"158416:156196:158526:162666:159127:159423:159421", -- [1]
			"158416:156196:158526:162666:165164:165701", -- [1]
			"158416:156196:158526:162666:165164:165701:167265", -- [2]
			"158416:156196:158526:162666:159127:159423:159125:175457", -- [3]		
			"158416:156196:158526:162666", -- [1]
			"158416:160202:156295", -- [2]
			"158564:158517:158417", -- [3]
			"158564:158517", -- [4]
			"158416:156196:158526", -- [5]
			"158416:156196", -- [6]
			"158416:156196:158526:162666:159127", -- [7]
			"158416:156196:158526:162666:159127:159423:159125", -- [8]
			"158416:156196:158526:162666:159127:159423", -- [9]
			"158416:160202", -- [10]
			"158416:156196:158526:162666:157540:157519", -- [11]
			"158416:156196:158526:162666:157540:157518", -- [12]
			"158416:156196:158526:162666:157540:157517", -- [13]
			"158416:156196:158526:162666:157540:157516", -- [14]
			"158416:156196:158526:162666:157540", -- [15]
			"158416:156196:158526:162666:157540:157515", -- [16]
			"158416:156196:158526:162666:165164:167243", -- [17]
			"158416:156196:158526:162666:165164", -- [18]
			"158416:156196:158526:162666:165164:165166", -- [19]
			"158416:156196:158526:162666:165164:167255:167265", -- [20]
			"158416:156196:158526:162666:165164:165166:167247", -- [21]
			"158416:156196:158526:162666:165164:167255", -- [22]
			--["name"] = "Dominance Keep, Revendreth",
			["direct"] = "158416:158564",
			["m"] = 1525,
			["coord"] = 1117931970,
			["f"] = 0,
		},
	},
	[1978] = {
		[216283] = {
			"186487:190332:189459", -- [1]
			"186487:190332:189116", -- [2]
			"186487:186443", -- [3]
			"186487:190332:189116:186782", -- [4]
			"186487:192865:192838:191999:191976", -- [5]
			"186487:192865:192838:191999", -- [6]
			"186487:192865:192838:191999:186742", -- [7]
			"186487:190332", -- [8]
			"186487:191814:191263:184630", -- [9]
			"186487:191814:191263", -- [10]
			"186487:192865:192838", -- [11]
			"186487:192865", -- [12]
			"186487:191814", -- [13]
			"186487:191814:191263:190049", -- [14]
			"186487:191814:191263:191622", -- [15]
			"186487:191814:191263:196259", -- [16]
			"186487:191814:192494", -- [17]
			"186487:191814:192494:192493", -- [18]
			"186487:191814:192494:192493:188336", -- [19]
			"186487:191814:192494:192493:188444:XY-2194584631:192472", -- [20]
			"186487:191814:191263:184630:192491:192484:192490", -- [21]
			"186487:191814:191263:184630:192491:192484", -- [22]
			"186487:191814:191263:184630:192491", -- [23]
			"186487:191814:192494:192493:188444", -- [24]
			"186487:191814:191263:190049:192843", -- [25]
			"186487:191814:191263:196259:193321", -- [26]
			"186487:191814:191263:196259:193321:189018", -- [27]
			"186487:191814:191263:196259:193454:193458:187013", -- [28]
			"186487:191814:191263:196259:193321:189339", -- [29]
			"186487:191814:191263:196259:193321:189339:189237", -- [30]
			"186487:191814:191263:196259:193454", -- [31]
			"186487:191814:191263:196259:193454:193458", -- [32]
			"186487:191814:191263:184630:192491:192484:193477", -- [33]
			"186487:191814:191263:196259:193321:189018:193508", -- [34]
			"186487:192865:195235", -- [35]
			"186487:191814:191263:196259:193321:200561", -- [36]
			"186487:XY-1551657170:XY-1497641724:200300:202467", -- [37]
			"186487:XY-1551657170:XY-1497641724:200300:200893", -- [38]
			"186487:XY-1551657170:XY-1497641724:200300", -- [39]
			["direct"] = "186487",
			["coord"] = 2154008274,
			["m"] = 2239,
			["f"] = 0,
		},
		[209427] = {
			"211353:208280", -- [1]
			--["name"] = "Wellspring Overlook, The Emerald Dream",
			["m"] = 2200,
			["direct"] = "207636:211353",
			["coord"] = 1533564447,
			["f"] = 0,
		},
		[207636] = {
			--["name"] = "Central Encampment, The Emerald Dream",
			["direct"] = "208280:211353:209427",
			["m"] = 2200,
			["coord"] = 2192875461,
			["f"] = 0,
		},
		[208280] = {
			"211353:209427", -- [1]
			["direct"] = "207636:211353",
			["m"] = 2200,
			["coord"] = 2955709399,
			["f"] = 0,
		},
		[211353] = {
			--["name"] = "Eye of Ysera, The Emerald Dream",
			["direct"] = "207636:208280:209427",
			["m"] = 2200,
			["coord"] = 2376682442,
			["f"] = 0,
		},		
		[189339] = {
			"193321:196259:191622:191999:189116:189459", -- [1]
			"193321:196259:191622:191999:189116", -- [2]
			"193321:196259:191263:190332:186443", -- [3]
			"189018:193458:186742:191976:186782", -- [4]
			"189018:193458:186742:191976", -- [5]
			"193321:196259:191622:191999", -- [6]
			"189018:193458:186742", -- [7]
			"193321:196259:191263:190332", -- [8]
			"193321:184630", -- [9]
			"193321:196259:191263", -- [10]
			"193321:196259:191622:192838", -- [11]
			"193321:196259:191263:192865", -- [12]
			"193321:196259:191263:191814", -- [13]
			"193321:196259:191263:191814:186487", -- [14]
			"193321:184630:190049", -- [15]
			"193321:196259:191622", -- [16]
			"193321:196259", -- [17]
			"192491:188444:192493:192494", -- [18]
			"192491:188444:192493", -- [19]
			"192491:188444:188336", -- [20]
			"192484:XY-2194584631:192472", -- [21]
			"193477:192490", -- [22]
			"192491:188444", -- [23]
			"192491:192843", -- [24]
			"193321:193454", -- [25]
			"189018:193458", -- [26]
			"193321:196259:191263:195235", -- [27]
			--["name"] = "Algeth'era, Thaldraszus",
			["direct"] = "192484:192491:193321:189018:189237:193477:193508",
			["f"] = 0,
			["m"] = 2025,
			["coord"] = 2126146364,
		},
		[184630] = {
			"196259:191622:191999:189116:189459", -- [1]
			"196259:191622:191999:189116", -- [2]
			"191263:190332:186443", -- [3]
			"196259:193454:186742:191976:186782", -- [4]
			"196259:193454:186742:191976", -- [5]
			"196259:191622:191999", -- [6]
			"196259:193454:186742", -- [7]
			"191263:190332", -- [8]
			"196259:191622:192838", -- [9]
			"191263:192865", -- [10]
			"191263:191814", -- [11]
			"191263:191814:186487", -- [12]
			"196259:191622", -- [13]
			"190049:192493:192494", -- [14]
			"190049:192493", -- [15]
			"192843:188444:188336", -- [16]
			"192491:192484:XY-2194584631:192472", -- [17]
			"192491:192484:192490", -- [18]
			"192491:192484", -- [19]
			"192843:188444", -- [20]
			"193321:189018", -- [21]
			"193321:189339", -- [22]
			"196259:193454", -- [23]
			"193321:189018:193458", -- [24]
			"192491:192484:193477", -- [25]
			"193321:189018:193508", -- [26]
			"191263:195235", -- [27]
			--["name"] = "Timberstep Outpost, Ohn'ahran Plains",
			["direct"] = "191263:190049:196259:192491:192843:193321",
			["coord"] = 3660004793,
			["m"] = 2023,
			["f"] = 0,
		},
		[193458] = {
			"186742:191976:189116:189459", -- [1]
			"186742:191976:189116", -- [2]
			"186742:191976:189116:186443", -- [3]
			"186742:191976:186782", -- [4]
			"186742:191976", -- [5]
			"186742:191999", -- [6]
			"186742:191999:190332", -- [7]
			"189018:193321:184630", -- [8]
			"189018:193321:196259:191263", -- [9]
			"186742:191999:192838", -- [10]
			"186742:191999:192838:192865", -- [11]
			"189018:193321:196259:191263:191814", -- [12]
			"189018:193321:196259:191263:191814:186487", -- [13]
			"189018:193321:184630:190049", -- [14]
			"193454:191622", -- [15]
			"189018:193321:196259", -- [16]
			"189018:193321:184630:190049:192493:192494", -- [17]
			"189018:193321:184630:190049:192493", -- [18]
			"189018:193321:184630:192843:188444:188336", -- [19]
			"189018:189339:192484:XY-2194584631:192472", -- [20]
			"189018:189339:193477:192490", -- [21]
			"189018:189339:192484", -- [22]
			"189018:193321:192491", -- [23]
			"189018:193321:184630:192843:188444", -- [24]
			"189018:193321:184630:192843", -- [25]
			"189018:193321", -- [26]
			"189018:189339", -- [27]
			"189018:189339:193477", -- [28]
			"189018:193508", -- [29]
			"186742:191999:192838:195235", -- [30]
			--["name"] = "Shifting Sands, Thaldraszus",
			["direct"] = "186742:189018:193454",
			["coord"] = 2473314872,
			["m"] = 2025,
			["f"] = 0,
		},
		[190332] = {
			"189116:186782", -- [1]
			"191999:191976", -- [2]
			"191999:186742", -- [3]
			"191263:184630", -- [4]
			"192865:191814", -- [5]
			"192865:186487", -- [6]
			"191263:190049", -- [7]
			"191999:191622", -- [8]
			"191263:196259", -- [9]
			"192865:191814:192494", -- [10]
			"192865:191814:192494:192493", -- [11]
			"192865:191814:192494:192493:188336", -- [12]
			"191263:190049:188444:XY-2194584631:192472", -- [13]
			"191263:184630:192491:192484:192490", -- [14]
			"191263:184630:192491:192484", -- [15]
			"191263:184630:192491", -- [16]
			"191263:190049:188444", -- [17]
			"191263:190049:192843", -- [18]
			"191263:196259:193321", -- [19]
			"191263:196259:193321:189018", -- [20]
			"191263:196259:193321:189339", -- [21]
			"191263:196259:193454", -- [22]
			"191999:186742:193458", -- [23]
			"191263:184630:192491:192484:193477", -- [24]
			"191263:196259:193321:189018:193508", -- [25]
			"192865:195235", -- [26]
			--["name"] = "Three-Falls Lookout, Azure Span",
			["direct"] = "189459:189116:186443:191999:191263:192838:192865",
			["coord"] = 822164670,
			["m"] = 2024,
			["f"] = 0,
		},
		[192490] = {
			"192484:192491:184630:196259:191622:191999:189116:189459", -- [1]
			"192484:192491:184630:196259:191622:191999:189116", -- [2]
			"192484:192491:192843:190049:191263:190332:186443", -- [3]
			"193477:189339:189018:193458:186742:191976:186782", -- [4]
			"193477:189339:189018:193458:186742:191976", -- [5]
			"192484:192491:184630:196259:191622:191999", -- [6]
			"193477:189339:189018:193458:186742", -- [7]
			"192484:192491:192843:190049:191263:190332", -- [8]
			"192484:192491:184630", -- [9]
			"192484:192491:192843:190049:191263", -- [10]
			"192484:192491:184630:196259:191622:192838", -- [11]
			"192484:192491:192843:190049:191263:192865", -- [12]
			"192484:192491:192843:190049:191263:191814", -- [13]
			"192484:192491:192843:190049:191263:191814:186487", -- [14]
			"192484:192491:192843:190049", -- [15]
			"192484:192491:184630:196259:191622", -- [16]
			"192484:192491:184630:196259", -- [17]
			"XY-2194584631:188444:192493:192494", -- [18]
			"XY-2194584631:188444:192493", -- [19]
			"XY-2194584631:188336", -- [20]
			"XY-2194584631:192472", -- [21]
			"192484:192491", -- [22]
			"XY-2194584631:188444", -- [23]
			"192484:192491:192843", -- [24]
			"193477:189339:193321", -- [25]
			"193477:189339:189018", -- [26]
			"193477:189339", -- [27]
			"193477:189339:193321:193454", -- [28]
			"193477:189339:189018:193458", -- [29]
			"193477:189339:193508", -- [30]
			"192484:192491:192843:190049:191263:195235", -- [31]
			--["name"] = "Wingrest Embassy, The Waking Shores",
			["direct"] = "192484:193477",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 3265092022,
		},
		[190049] = {
			"191263:191622:191999:189116:189459", -- [1]
			"191263:191622:191999:189116", -- [2]
			"191263:190332:186443", -- [3]
			"184630:196259:193454:186742:191976:186782", -- [4]
			"184630:196259:193454:186742:191976", -- [5]
			"191263:191622:191999", -- [6]
			"184630:196259:193454:186742", -- [7]
			"191263:190332", -- [8]
			"191263:192838", -- [9]
			"191263:192865", -- [10]
			"191263:191814", -- [11]
			"191263:191814:186487", -- [12]
			"191263:191622", -- [13]
			"184630:196259", -- [14]
			"192493:192494", -- [15]
			"188444:188336", -- [16]
			"188444:XY-2194584631:192472", -- [17]
			"192843:192491:192484:192490", -- [18]
			"192843:192491:192484", -- [19]
			"192843:192491", -- [20]
			"184630:193321", -- [21]
			"184630:193321:189018", -- [22]
			"184630:193321:189339", -- [23]
			"184630:196259:193454", -- [24]
			"184630:193321:189018:193458", -- [25]
			"192843:192491:192484:193477", -- [26]
			"184630:193321:189018:193508", -- [27]
			"191263:195235", -- [28]
			--["name"] = "Emberwatch, Ohn'ahran Plains",
			["direct"] = "184630:191263:192493:188444:192843",
			["f"] = 0,
			["m"] = 2023,
			["coord"] = 2869903515,
		},
		[186742] = {
			"191976:189116:189459", -- [1]
			"191976:189116", -- [2]
			"191976:189116:186443", -- [3]
			"191976:186782", -- [4]
			"191999:190332", -- [5]
			"193454:196259:184630", -- [6]
			"193454:196259:191263", -- [7]
			"191999:192838", -- [8]
			"191999:192838:192865", -- [9]
			"193454:196259:191263:191814", -- [10]
			"191999:192838:192865:186487", -- [11]
			"193454:196259:184630:190049", -- [12]
			"191999:191622", -- [13]
			"193454:196259", -- [14]
			"193454:196259:191263:191814:192494", -- [15]
			"193454:196259:184630:190049:192493", -- [16]
			"193454:196259:184630:192843:188444:188336", -- [17]
			"193458:189018:189339:192484:XY-2194584631:192472", -- [18]
			"193458:189018:189339:193477:192490", -- [19]
			"193458:189018:189339:192484", -- [20]
			"193454:193321:192491", -- [21]
			"193454:196259:184630:192843:188444", -- [22]
			"193454:196259:184630:192843", -- [23]
			"193454:193321", -- [24]
			"193458:189018", -- [25]
			"193458:189018:189339", -- [26]
			"193458:189018:189339:193477", -- [27]
			"193458:189018:193508", -- [28]
			"191999:192838:195235", -- [29]
			--["name"] = "Theron's Watch, Azure Span",
			["direct"] = "191976:191999:193454:193458",
			["coord"] = 2806458851,
			["m"] = 2024,
			["f"] = 0,
		},
		[189459] = {
			"189116:191976", -- [1]
			"189116:191999", -- [2]
			"189116:191999:186742", -- [3]
			"189116:191999:191622:196259:184630", -- [4]
			"189116:191999:191622:191263", -- [5]
			"189116:191999:192838", -- [6]
			"190332:192865", -- [7]
			"190332:192865:191814", -- [8]
			"190332:192865:186487", -- [9]
			"189116:191999:191622:191263:190049", -- [10]
			"189116:191999:191622", -- [11]
			"189116:191999:191622:196259", -- [12]
			"190332:192865:191814:192494", -- [13]
			"190332:192865:191814:192494:192493", -- [14]
			"189116:191999:191622:196259:184630:192843:188444:188336", -- [15]
			"189116:191999:191622:196259:184630:192491:192484:XY-2194584631:192472", -- [16]
			"189116:191999:191622:196259:184630:192491:192484:192490", -- [17]
			"189116:191999:191622:196259:184630:192491:192484", -- [18]
			"189116:191999:191622:196259:184630:192491", -- [19]
			"189116:191999:191622:196259:184630:192843:188444", -- [20]
			"189116:191999:191622:196259:184630:192843", -- [21]
			"189116:191999:191622:196259:193321", -- [22]
			"189116:191999:186742:193458:189018", -- [23]
			"189116:191999:191622:196259:193321:189339", -- [24]
			"189116:191999:193454", -- [25]
			"189116:191999:186742:193458", -- [26]
			"189116:191999:191622:196259:184630:192491:192484:193477", -- [27]
			"189116:191999:186742:193458:189018:193508", -- [28]
			"189116:191999:192838:195235", -- [29]
			--["name"] = "Azure Archives, Azure Span",
			["direct"] = "189116:186443:186782:190332",
			["coord"] = 1593416626,
			["m"] = 2024,
			["f"] = 0,
		},
		[186443] = {
			"189116:186782", -- [1]
			"189116:191976", -- [2]
			"189116:191999", -- [3]
			"189116:191999:186742", -- [4]
			"190332:191263:184630", -- [5]
			"190332:191263", -- [6]
			"190332:192838", -- [7]
			"190332:192865", -- [8]
			"190332:192865:191814", -- [9]
			"190332:191263:190049", -- [10]
			"189116:191999:191622", -- [11]
			"190332:191263:196259", -- [12]
			"190332:192865:191814:192494", -- [13]
			"190332:192865:191814:192494:192493", -- [14]
			"190332:192865:191814:192494:192493:188336", -- [15]
			"190332:191263:190049:188444:XY-2194584631:192472", -- [16]
			"190332:191263:184630:192491:192484:192490", -- [17]
			"190332:191263:184630:192491:192484", -- [18]
			"190332:191263:184630:192491", -- [19]
			"190332:191263:190049:188444", -- [20]
			"190332:191263:190049:192843", -- [21]
			"190332:191263:196259:193321", -- [22]
			"189116:191999:186742:193458:189018", -- [23]
			"190332:191263:196259:193321:189339", -- [24]
			"189116:191999:193454", -- [25]
			"189116:191999:186742:193458", -- [26]
			"190332:191263:184630:192491:192484:193477", -- [27]
			"189116:191999:186742:193458:189018:193508", -- [28]
			"190332:192865:195235", -- [29]
			--["name"] = "Iskaara, Azure Span",
			["direct"] = "189459:189116:190332:186487",
			["coord"] = 569933036,
			["m"] = 2024,
			["f"] = 0,
		},
		[191814] = {
			"192865:190332:189459", -- [1]
			"191263:191622:191999:189116", -- [2]
			"186487:186443", -- [3]
			"191263:191622:191999:189116:186782", -- [4]
			"191263:191622:191999:191976", -- [5]
			"191263:191622:191999", -- [6]
			"191263:196259:193454:186742", -- [7]
			"192865:190332", -- [8]
			"191263:184630", -- [9]
			"191263:192838", -- [10]
			"191263:190049", -- [11]
			"191263:191622", -- [12]
			"191263:196259", -- [13]
			"192494:192493", -- [14]
			"192494:192493:188336", -- [15]
			"192494:192493:188444:XY-2194584631:192472", -- [16]
			"191263:184630:192491:192484:192490", -- [17]
			"191263:184630:192491:192484", -- [18]
			"191263:184630:192491", -- [19]
			"192494:192493:188444", -- [20]
			"191263:190049:192843", -- [21]
			"191263:196259:193321", -- [22]
			"191263:196259:193321:189018", -- [23]
			"191263:196259:193321:189339", -- [24]
			"191263:196259:193454", -- [25]
			"191263:196259:193454:193458", -- [26]
			"191263:184630:192491:192484:193477", -- [27]
			"191263:196259:193321:189018:193508", -- [28]
			"192865:195235", -- [29]
			--["name"] = "Broadhoof Outpost, Ohn'ahran Plains",
			["direct"] = "191263:192865:186487:192494",
			["f"] = 0,
			["m"] = 2023,
			["coord"] = 1998612962,
		},
		[186782] = {
			"189116:186443", -- [1]
			"189116:191999", -- [2]
			"191976:186742", -- [3]
			"189116:190332", -- [4]
			"189116:191999:191622:196259:184630", -- [5]
			"189116:191999:191622:191263", -- [6]
			"189116:191999:192838", -- [7]
			"189116:190332:192865", -- [8]
			"189116:191999:191622:191263:191814", -- [9]
			"189116:190332:192865:186487", -- [10]
			"189116:191999:191622:191263:190049", -- [11]
			"189116:191999:191622", -- [12]
			"189116:191999:191622:196259", -- [13]
			"189116:191999:191622:191263:191814:192494", -- [14]
			"189116:191999:191622:191263:190049:192493", -- [15]
			"189116:191999:191622:196259:184630:192843:188444:188336", -- [16]
			"191976:186742:193458:189018:189339:192484:XY-2194584631:192472", -- [17]
			"191976:186742:193458:189018:189339:193477:192490", -- [18]
			"191976:186742:193458:189018:189339:192484", -- [19]
			"191976:186742:193454:193321:192491", -- [20]
			"189116:191999:191622:196259:184630:192843:188444", -- [21]
			"189116:191999:191622:196259:184630:192843", -- [22]
			"191976:186742:193454:193321", -- [23]
			"191976:186742:193458:189018", -- [24]
			"191976:186742:193458:189018:189339", -- [25]
			"191976:186742:193454", -- [26]
			"191976:186742:193458", -- [27]
			"191976:186742:193458:189018:189339:193477", -- [28]
			"191976:186742:193458:189018:193508", -- [29]
			"189116:191999:192838:195235", -- [30]
			--["name"] = "Camp Nowhere, Azure Span",
			["direct"] = "189459:189116:191976",
			["coord"] = 2725025325,
			["m"] = 2024,
			["f"] = 0,
		},
		[191263] = {
			"191622:191999:189116:189459", -- [1]
			"191622:191999:189116", -- [2]
			"190332:186443", -- [3]
			"191622:191999:189116:186782", -- [4]
			"191622:191999:191976", -- [5]
			"191622:191999", -- [6]
			"196259:193454:186742", -- [7]
			"191814:186487", -- [8]
			"191814:192494", -- [9]
			"190049:192493", -- [10]
			"190049:188444:188336", -- [11]
			"190049:188444:XY-2194584631:192472", -- [12]
			"184630:192491:192484:192490", -- [13]
			"184630:192491:192484", -- [14]
			"184630:192491", -- [15]
			"190049:188444", -- [16]
			"190049:192843", -- [17]
			"196259:193321", -- [18]
			"196259:193321:189018", -- [19]
			"196259:193321:189339", -- [20]
			"196259:193454", -- [21]
			"196259:193454:193458", -- [22]
			"184630:192491:192484:193477", -- [23]
			"196259:193321:189018:193508", -- [24]
			--["name"] = "Maruukai, Ohn'ahran Plains",
			["direct"] = "190332:184630:192838:192865:191814:190049:191622:196259:195235",
			["f"] = 0,
			["m"] = 2023,
			["coord"] = 2706074598,
		},
		[188444] = {
			"192843:184630:196259:191622:191999:189116:189459", -- [1]
			"192843:184630:196259:191622:191999:189116", -- [2]
			"190049:191263:190332:186443", -- [3]
			"192843:184630:196259:193454:186742:191976:186782", -- [4]
			"192843:184630:196259:193454:186742:191976", -- [5]
			"192843:184630:196259:191622:191999", -- [6]
			"192843:184630:196259:193454:186742", -- [7]
			"190049:191263:190332", -- [8]
			"192843:184630", -- [9]
			"190049:191263", -- [10]
			"190049:191263:192838", -- [11]
			"190049:191263:192865", -- [12]
			"192493:192494:191814", -- [13]
			"192493:192494:191814:186487", -- [14]
			"192843:184630:196259:191622", -- [15]
			"192843:184630:196259", -- [16]
			"192493:192494", -- [17]
			"XY-2194584631:192472", -- [18]
			"XY-2194584631:192490", -- [19]
			"192491:192484", -- [20]
			"192843:184630:193321", -- [21]
			"192843:184630:193321:189018", -- [22]
			"192491:189339", -- [23]
			"192843:184630:196259:193454", -- [24]
			"192843:184630:193321:189018:193458", -- [25]
			"192491:192484:193477", -- [26]
			"192491:189339:193508", -- [27]
			"190049:191263:195235", -- [28]
			--["name"] = "Obsidian Bulwark, The Waking Shores",
			["direct"] = "190049:192493:188336:192491:192843",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 1814997409,
		},
		[192484] = {
			"192491:184630:196259:191622:191999:189116:189459", -- [1]
			"192491:184630:196259:191622:191999:189116", -- [2]
			"192491:192843:190049:191263:190332:186443", -- [3]
			"189339:189018:193458:186742:191976:186782", -- [4]
			"189339:189018:193458:186742:191976", -- [5]
			"192491:184630:196259:191622:191999", -- [6]
			"189339:189018:193458:186742", -- [7]
			"192491:192843:190049:191263:190332", -- [8]
			"192491:184630", -- [9]
			"192491:192843:190049:191263", -- [10]
			"192491:184630:196259:191622:192838", -- [11]
			"192491:192843:190049:191263:192865", -- [12]
			"192491:192843:190049:191263:191814", -- [13]
			"192491:192843:190049:191263:191814:186487", -- [14]
			"192491:192843:190049", -- [15]
			"192491:184630:196259:191622", -- [16]
			"192491:184630:196259", -- [17]
			"192491:188444:192493:192494", -- [18]
			"192491:188444:192493", -- [19]
			"XY-2194584631:188336", -- [20]
			"XY-2194584631:192472", -- [21]
			"192491:188444", -- [22]
			"192491:192843", -- [23]
			"192491:193321", -- [24]
			"189339:189018", -- [25]
			"192491:193321:193454", -- [26]
			"189339:189018:193458", -- [27]
			"189339:193508", -- [28]
			"192491:192843:190049:191263:195235", -- [29]
			--["name"] = "Life Vault Ruins, The Waking Shores",
			["direct"] = "192490:192491:189339:193477",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 2792854226,
		},
		[193508] = {
			"189018:193458:186742:191976:189116:189459", -- [1]
			"189018:193458:186742:191976:189116", -- [2]
			"189018:193458:186742:191976:189116:186443", -- [3]
			"189018:193458:186742:191976:186782", -- [4]
			"189018:193458:186742:191976", -- [5]
			"189018:193458:186742:191999", -- [6]
			"189018:193458:186742", -- [7]
			"189018:193321:196259:191263:190332", -- [8]
			"189018:193321:184630", -- [9]
			"189018:193321:196259:191263", -- [10]
			"189018:193321:196259:191622:192838", -- [11]
			"189018:193321:196259:191263:192865", -- [12]
			"189018:193321:196259:191263:191814", -- [13]
			"189018:193321:196259:191263:191814:186487", -- [14]
			"189018:193321:184630:190049", -- [15]
			"189018:193321:196259:191622", -- [16]
			"189018:193321:196259", -- [17]
			"189018:193321:184630:190049:192493:192494", -- [18]
			"189018:193321:184630:190049:192493", -- [19]
			"189339:192491:188444:188336", -- [20]
			"189339:192484:XY-2194584631:192472", -- [21]
			"189339:193477:192490", -- [22]
			"189339:192484", -- [23]
			"189339:192491", -- [24]
			"189339:192491:188444", -- [25]
			"189018:193321:184630:192843", -- [26]
			"189018:193321", -- [27]
			"189018:193454", -- [28]
			"189018:193458", -- [29]
			"189339:193477", -- [30]
			"189018:193321:196259:191263:195235", -- [31]
			--["name"] = "Vault of the Incarnates, Thaldraszus",
			["direct"] = "189018:189339",
			["coord"] = 3099037839,
			["m"] = 2025,
			["f"] = 0,
		},
		[193477] = {
			"192484:192491:184630:196259:191622:191999:189116:189459", -- [1]
			"192484:192491:184630:196259:191622:191999:189116", -- [2]
			"192484:192491:192843:190049:191263:190332:186443", -- [3]
			"189339:189018:193458:186742:191976:186782", -- [4]
			"189339:189018:193458:186742:191976", -- [5]
			"192484:192491:184630:196259:191622:191999", -- [6]
			"189339:189018:193458:186742", -- [7]
			"192484:192491:192843:190049:191263:190332", -- [8]
			"192484:192491:184630", -- [9]
			"192484:192491:192843:190049:191263", -- [10]
			"192484:192491:184630:196259:191622:192838", -- [11]
			"192484:192491:192843:190049:191263:192865", -- [12]
			"192484:192491:192843:190049:191263:191814", -- [13]
			"192484:192491:192843:190049:191263:191814:186487", -- [14]
			"192484:192491:192843:190049", -- [15]
			"192484:192491:184630:196259:191622", -- [16]
			"192484:192491:184630:196259", -- [17]
			"192484:192491:188444:192493:192494", -- [18]
			"192484:192491:188444:192493", -- [19]
			"192484:XY-2194584631:188336", -- [20]
			"192484:XY-2194584631:192472", -- [21]
			"192484:192491", -- [22]
			"192484:192491:188444", -- [23]
			"192484:192491:192843", -- [24]
			"189339:193321", -- [25]
			"189339:189018", -- [26]
			"189339:193321:193454", -- [27]
			"189339:189018:193458", -- [28]
			"189339:193508", -- [29]
			"192484:192491:192843:190049:191263:195235", -- [30]
			--["name"] = "Skytop Observatory, The Waking Shores",
			["direct"] = "192490:192484:189339",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 3126691053,
		},
		[192493] = {
			"190049:191263:191622:191999:189116:189459", -- [1]
			"190049:191263:191622:191999:189116", -- [2]
			"192494:191814:186487:186443", -- [3]
			"190049:184630:196259:193454:186742:191976:186782", -- [4]
			"190049:184630:196259:193454:186742:191976", -- [5]
			"190049:191263:191622:191999", -- [6]
			"190049:184630:196259:193454:186742", -- [7]
			"192494:191814:192865:190332", -- [8]
			"190049:184630", -- [9]
			"190049:191263", -- [10]
			"190049:191263:192838", -- [11]
			"192494:191814:192865", -- [12]
			"192494:191814", -- [13]
			"192494:191814:186487", -- [14]
			"190049:191263:191622", -- [15]
			"190049:184630:196259", -- [16]
			"188444:XY-2194584631:192472", -- [17]
			"188444:XY-2194584631:192490", -- [18]
			"188444:192491:192484", -- [19]
			"188444:192491", -- [20]
			"188444:192843", -- [21]
			"190049:184630:193321", -- [22]
			"190049:184630:193321:189018", -- [23]
			"188444:192491:189339", -- [24]
			"190049:184630:196259:193454", -- [25]
			"190049:184630:193321:189018:193458", -- [26]
			"188444:192491:192484:193477", -- [27]
			"190049:184630:193321:189018:193508", -- [28]
			"190049:191263:195235", -- [29]
			--["name"] = "Apex Observatory, The Waking Shores",
			["direct"] = "190049:192494:188336:188444",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 1021498578,
		},
		[193454] = {
			"191999:189116:189459", -- [1]
			"191999:189116", -- [2]
			"191999:189116:186443", -- [3]
			"186742:191976:186782", -- [4]
			"186742:191976", -- [5]
			"196259:191263:190332", -- [6]
			"196259:184630", -- [7]
			"196259:191263", -- [8]
			"191622:192838", -- [9]
			"196259:191263:192865", -- [10]
			"196259:191263:191814", -- [11]
			"196259:191263:191814:186487", -- [12]
			"196259:184630:190049", -- [13]
			"196259:191263:191814:192494", -- [14]
			"196259:184630:190049:192493", -- [15]
			"196259:184630:192843:188444:188336", -- [16]
			"193321:192491:192484:XY-2194584631:192472", -- [17]
			"193321:192491:192484:192490", -- [18]
			"193321:192491:192484", -- [19]
			"193321:192491", -- [20]
			"196259:184630:192843:188444", -- [21]
			"196259:184630:192843", -- [22]
			"193321:189339", -- [23]
			"193321:189339:193477", -- [24]
			"189018:193508", -- [25]
			"191622:192838:195235", -- [26]
			--["name"] = "Garden Shrine, Thaldraszus",
			["direct"] = "191999:186742:191622:196259:193321:189018:193458",
			["coord"] = 1528744438,
			["m"] = 2025,
			["f"] = 0,
		},
		[188336] = {
			"188444:192843:184630:196259:191622:191999:189116:189459", -- [1]
			"188444:192843:184630:196259:191622:191999:189116", -- [2]
			"192493:192494:191814:186487:186443", -- [3]
			"188444:192843:184630:196259:193454:186742:191976:186782", -- [4]
			"188444:192843:184630:196259:193454:186742:191976", -- [5]
			"188444:192843:184630:196259:191622:191999", -- [6]
			"188444:192843:184630:196259:193454:186742", -- [7]
			"188444:190049:191263:190332", -- [8]
			"188444:192843:184630", -- [9]
			"188444:190049:191263", -- [10]
			"188444:190049:191263:192838", -- [11]
			"192493:192494:191814:192865", -- [12]
			"192493:192494:191814", -- [13]
			"192493:192494:191814:186487", -- [14]
			"188444:190049", -- [15]
			"188444:192843:184630:196259:191622", -- [16]
			"188444:192843:184630:196259", -- [17]
			"192493:192494", -- [18]
			"XY-2194584631:192472", -- [19]
			"XY-2194584631:192490", -- [20]
			"XY-2194584631:192484", -- [21]
			"188444:192491", -- [22]
			"188444:192843", -- [23]
			"188444:192843:184630:193321", -- [24]
			"188444:192843:184630:193321:189018", -- [25]
			"188444:192491:189339", -- [26]
			"188444:192843:184630:196259:193454", -- [27]
			"188444:192843:184630:193321:189018:193458", -- [28]
			"XY-2194584631:192484:193477", -- [29]
			"188444:192491:189339:193508", -- [30]
			"188444:190049:191263:195235", -- [31]
			--["name"] = "Obsidian Throne, The Waking Shores",
			["direct"] = "192493:188444",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 1087345070,
		},
		[193321] = {
			"189018:193458:187013", -- [1]
			"XY-2241298411:XY-3139928389:202467", -- [2]
			"XY-2241298411:XY-3139928389:202467:200893", -- [3]
			"196259:191263:192865:XY-1551657170:XY-1497641724:200300", -- [4]		
			"196259:191622:191999:189116:189459", -- [1]
			"196259:191622:191999:189116", -- [2]
			"196259:191263:190332:186443", -- [3]
			"193454:186742:191976:186782", -- [4]
			"193454:186742:191976", -- [5]
			"196259:191622:191999", -- [6]
			"193454:186742", -- [7]
			"196259:191263:190332", -- [8]
			"196259:191263", -- [9]
			"196259:191622:192838", -- [10]
			"196259:191263:192865", -- [11]
			"196259:191263:191814", -- [12]
			"196259:191263:191814:186487", -- [13]
			"184630:190049", -- [14]
			"196259:191622", -- [15]
			"184630:190049:192493:192494", -- [16]
			"184630:190049:192493", -- [17]
			"184630:192843:188444:188336", -- [18]
			"192491:192484:XY-2194584631:192472", -- [19]
			"192491:192484:192490", -- [20]
			"192491:192484", -- [21]
			"184630:192843:188444", -- [22]
			"184630:192843", -- [23]
			"189018:193458", -- [24]
			"189339:193477", -- [25]
			"189018:193508", -- [26]
			"196259:191263:195235", -- [27]
			--["name"] = "Valdrakken, Thaldraszus",
			["direct"] = "184630:196259:192491:189018:189339:193454",
			["coord"] = 1902554428,
			["m"] = 2112,
			["f"] = 0,
		},
		[189116] = {
			"190332:186487", -- [1]
			"191999:186742:193458:187013", -- [2]
			"191999:191622:196259:193321:200561", -- [3]
			"191999:191622:196259:193321:XY-2241298411:XY-3139928389:202467", -- [4]
			"191999:191622:196259:193321:XY-2241298411:XY-3139928389:202467:200893", -- [5]
			"190332:192865:XY-1551657170:XY-1497641724:200300", -- [6]		
			"191999:186742", -- [1]
			"191999:191622:196259:184630", -- [2]
			"191999:191622:191263", -- [3]
			"191999:192838", -- [4]
			"190332:192865", -- [5]
			"191999:191622:191263:191814", -- [6]
			"190332:192865:186487", -- [7]
			"191999:191622:191263:190049", -- [8]
			"191999:191622", -- [9]
			"191999:191622:196259", -- [10]
			"191999:191622:191263:191814:192494", -- [11]
			"191999:191622:191263:190049:192493", -- [12]
			"191999:191622:196259:184630:192843:188444:188336", -- [13]
			"191999:191622:196259:184630:192491:192484:XY-2194584631:192472", -- [14]
			"191999:191622:196259:184630:192491:192484:192490", -- [15]
			"191999:191622:196259:184630:192491:192484", -- [16]
			"191999:191622:196259:184630:192491", -- [17]
			"191999:191622:196259:184630:192843:188444", -- [18]
			"191999:191622:196259:184630:192843", -- [19]
			"191999:191622:196259:193321", -- [20]
			"191999:186742:193458:189018", -- [21]
			"191999:191622:196259:193321:189339", -- [22]
			"191999:193454", -- [23]
			"191999:186742:193458", -- [24]
			"191999:191622:196259:184630:192491:192484:193477", -- [25]
			"191999:186742:193458:189018:193508", -- [26]
			"191999:192838:195235", -- [27]
			--["name"] = "Camp Antonidas, Azure Span",
			["direct"] = "189459:186443:186782:191976:191999:190332",
			["coord"] = 2007655772,
			["m"] = 2024,
			["f"] = 0,
		},
		[195235] = {
			"192838:191999:186742:193458:187013", -- [1]
			"191263:196259:193321:200561", -- [2]
			"192865:XY-1551657170:XY-1497641724:200300:202467", -- [3]
			"192865:XY-1551657170:XY-1497641724:200300:200893", -- [4]
			"192865:XY-1551657170:XY-1497641724:200300", -- [5]		
			"192838:191999:189116:189459", -- [1]
			"192838:191999:189116", -- [2]
			"192865:190332:186443", -- [3]
			"192838:191999:189116:186782", -- [4]
			"192838:191999:191976", -- [5]
			"192838:191999", -- [6]
			"192838:191999:186742", -- [7]
			"192865:190332", -- [8]
			"191263:184630", -- [9]
			"192865:191814", -- [10]
			"192865:186487", -- [11]
			"191263:190049", -- [12]
			"192838:191622", -- [13]
			"191263:196259", -- [14]
			"192865:191814:192494", -- [15]
			"191263:190049:192493", -- [16]
			"191263:190049:188444:188336", -- [17]
			"191263:190049:188444:XY-2194584631:192472", -- [18]
			"191263:184630:192491:192484:192490", -- [19]
			"191263:184630:192491:192484", -- [20]
			"191263:184630:192491", -- [21]
			"191263:190049:188444", -- [22]
			"191263:190049:192843", -- [23]
			"191263:196259:193321", -- [24]
			"191263:196259:193321:189018", -- [25]
			"191263:196259:193321:189339", -- [26]
			"192838:191622:193454", -- [27]
			"192838:191999:186742:193458", -- [28]
			"191263:184630:192491:192484:193477", -- [29]
			"191263:196259:193321:189018:193508", -- [30]
			--["name"] = "Ohn'iri Springs, Ohn'ahran Plains",
			["direct"] = "191263:192838:192865",
			["f"] = 0,
			["m"] = 2023,
			["coord"] = 2436416505,
		},
		[196259] = {
			"191622:191999:189116:189459", -- [1]
			"191622:191999:189116", -- [2]
			"191263:190332:186443", -- [3]
			"193454:186742:191976:186782", -- [4]
			"193454:186742:191976", -- [5]
			"191622:191999", -- [6]
			"193454:186742", -- [7]
			"191263:190332", -- [8]
			"191622:192838", -- [9]
			"191263:192865", -- [10]
			"191263:191814", -- [11]
			"191263:191814:186487", -- [12]
			"184630:190049", -- [13]
			"191263:191814:192494", -- [14]
			"184630:190049:192493", -- [15]
			"184630:192843:188444:188336", -- [16]
			"184630:192491:192484:XY-2194584631:192472", -- [17]
			"184630:192491:192484:192490", -- [18]
			"184630:192491:192484", -- [19]
			"184630:192491", -- [20]
			"184630:192843:188444", -- [21]
			"184630:192843", -- [22]
			"193321:189018", -- [23]
			"193321:189339", -- [24]
			"193454:193458", -- [25]
			"184630:192491:192484:193477", -- [26]
			"193321:189018:193508", -- [27]
			"191263:195235", -- [28]
			--["name"] = "Rusza'thar Reach, Ohn'ahran Plains",
			["direct"] = "184630:191263:191622:193321:193454",
			["coord"] = 3636289181,
			["m"] = 2023,
			["f"] = 0,
		},
		[192865] = {
			"191263:196259:193454:193458:187013", -- [1]
			"191263:196259:193321:200561", -- [2]
			"XY-1551657170:XY-1497641724:200300:202467", -- [3]
			"XY-1551657170:XY-1497641724:200300:200893", -- [4]
			"XY-1551657170:XY-1497641724:200300", -- [5]		
			"190332:189459", -- [1]
			"190332:189116", -- [2]
			"190332:186443", -- [3]
			"190332:189116:186782", -- [4]
			"192838:191999:191976", -- [5]
			"192838:191999", -- [6]
			"192838:191999:186742", -- [7]
			"191263:184630", -- [8]
			"191263:190049", -- [9]
			"191263:191622", -- [10]
			"191263:196259", -- [11]
			"191814:192494", -- [12]
			"191814:192494:192493", -- [13]
			"191814:192494:192493:188336", -- [14]
			"191814:192494:192493:188444:XY-2194584631:192472", -- [15]
			"191263:184630:192491:192484:192490", -- [16]
			"191263:184630:192491:192484", -- [17]
			"191263:184630:192491", -- [18]
			"191814:192494:192493:188444", -- [19]
			"191263:190049:192843", -- [20]
			"191263:196259:193321", -- [21]
			"191263:196259:193321:189018", -- [22]
			"191263:196259:193321:189339", -- [23]
			"191263:196259:193454", -- [24]
			"191263:196259:193454:193458", -- [25]
			"191263:184630:192491:192484:193477", -- [26]
			"191263:196259:193321:189018:193508", -- [27]
			--["name"] = "Teerakai, Ohn'ahran Plains",
			["direct"] = "190332:191263:192838:191814:186487:195235",
			["f"] = 0,
			["m"] = 2023,
			["coord"] = 1718852779,
		},
		[187013] = {
			"193458:186742:191976:189116:189459", -- [1]
			"193458:186742:191976:189116", -- [2]
			"193458:186742:191976:189116:186443", -- [3]
			"193458:186742:191976:186782", -- [4]
			"193458:186742:191976", -- [5]
			"193458:186742:191999", -- [6]
			"193458:186742", -- [7]
			"193458:186742:191999:190332", -- [8]
			"193458:189018:193321:184630", -- [9]
			"193458:189018:193321:196259:191263", -- [10]
			"193458:186742:191999:192838", -- [11]
			"193458:186742:191999:192838:192865", -- [12]
			"193458:189018:193321:196259:191263:191814", -- [13]
			"193458:189018:193321:196259:191263:191814:186487", -- [14]
			"193458:189018:193321:184630:190049", -- [15]
			"193458:193454:191622", -- [16]
			"193458:189018:193321:196259", -- [17]
			"193458:189018:193321:184630:190049:192493", -- [18]
			"193458:189018:193321:184630:192843:188444:188336", -- [19]
			"193458:189018:189339:192484:XY-2194584631:192472", -- [20]
			"193458:189018:189339:193477:192490", -- [21]
			"193458:189018:189339:192484", -- [22]
			"193458:189018:193321:192491", -- [23]
			"193458:189018:193321:184630:192843:188444", -- [24]
			"193458:189018:193321:184630:192843", -- [25]
			"193458:189018:193321", -- [26]
			"193458:189018", -- [27]
			"193458:189018:189339", -- [28]
			"193458:189018:189339:189237", -- [29]
			"193458:193454", -- [30]
			"193458:189018:189339:193477", -- [31]
			"193458:189018:193508", -- [32]
			"193458:186742:191999:192838:195235", -- [33]
			"193458:189018:189339:189237:200561", -- [34]
			"193458:189018:193321:XY-2241298411:XY-3139928389:202467", -- [35]
			"193458:189018:193321:XY-2241298411:XY-3139928389:202467:200893", -- [36]
			"193458:186742:191999:192838:192865:XY-1551657170:XY-1497641724:200300", -- [37]
			--["name"] = "Temporal Conflux, Thaldraszus",
			["m"] = 2025,
			["coord"] = 2572800093,
			["direct"] = "193458",
			["f"] = 0,
		},		
		[191999] = {
			"186742:193458:187013", -- [1]
			"191622:196259:193321:200561", -- [2]
			"191622:196259:193321:XY-2241298411:XY-3139928389:202467", -- [3]
			"191622:196259:193321:XY-2241298411:XY-3139928389:202467:200893", -- [4]
			"192838:192865:XY-1551657170:XY-1497641724:200300", -- [5]		
			"189116:189459", -- [1]
			"189116:186443", -- [2]
			"189116:186782", -- [3]
			"191622:196259:184630", -- [4]
			"191622:191263", -- [5]
			"192838:192865", -- [6]
			"191622:191263:191814", -- [7]
			"192838:192865:186487", -- [8]
			"191622:191263:190049", -- [9]
			"191622:196259", -- [10]
			"191622:191263:191814:192494", -- [11]
			"191622:191263:190049:192493", -- [12]
			"191622:196259:184630:192843:188444:188336", -- [13]
			"191622:196259:184630:192491:192484:XY-2194584631:192472", -- [14]
			"191622:196259:184630:192491:192484:192490", -- [15]
			"191622:196259:184630:192491:192484", -- [16]
			"191622:196259:184630:192491", -- [17]
			"191622:196259:184630:192843:188444", -- [18]
			"191622:196259:184630:192843", -- [19]
			"191622:196259:193321", -- [20]
			"186742:193458:189018", -- [21]
			"191622:196259:193321:189339", -- [22]
			"186742:193458", -- [23]
			"191622:196259:184630:192491:192484:193477", -- [24]
			"186742:193458:189018:193508", -- [25]
			"192838:195235", -- [26]
			--["name"] = "Cobalt Assembly, Azure Span",
			["direct"] = "189116:191976:186742:190332:192838:191622:193454",
			["coord"] = 2109684260,
			["m"] = 2024,
			["f"] = 0,
		},
		[192472] = {
			"XY-2194584631:192484:192491:184630:196259:191622:191999:189116:189459", -- [1]
			"XY-2194584631:192484:192491:184630:196259:191622:191999:189116", -- [2]
			"XY-2194584631:188444:190049:191263:190332:186443", -- [3]
			"XY-2194584631:192484:189339:189018:193458:186742:191976:186782", -- [4]
			"XY-2194584631:192484:189339:189018:193458:186742:191976", -- [5]
			"XY-2194584631:192484:192491:184630:196259:191622:191999", -- [6]
			"XY-2194584631:192484:189339:189018:193458:186742", -- [7]
			"XY-2194584631:188444:190049:191263:190332", -- [8]
			"XY-2194584631:192484:192491:184630", -- [9]
			"XY-2194584631:188444:190049:191263", -- [10]
			"XY-2194584631:192484:192491:184630:196259:191622:192838", -- [11]
			"XY-2194584631:188444:190049:191263:192865", -- [12]
			"XY-2194584631:188444:192493:192494:191814", -- [13]
			"XY-2194584631:188444:192493:192494:191814:186487", -- [14]
			"XY-2194584631:188444:190049", -- [15]
			"XY-2194584631:192484:192491:184630:196259:191622", -- [16]
			"XY-2194584631:192484:192491:184630:196259", -- [17]
			"XY-2194584631:188444:192493:192494", -- [18]
			"XY-2194584631:188444:192493", -- [19]
			"XY-2194584631:188336", -- [20]
			"XY-2194584631:192490", -- [21]
			"XY-2194584631:192484", -- [22]
			"XY-2194584631:192484:192491", -- [23]
			"XY-2194584631:188444", -- [24]
			"XY-2194584631:188444:192843", -- [25]
			"XY-2194584631:192484:192491:193321", -- [26]
			"XY-2194584631:192484:189339:189018", -- [27]
			"XY-2194584631:192484:189339", -- [28]
			"XY-2194584631:192484:192491:193321:193454", -- [29]
			"XY-2194584631:192484:189339:189018:193458", -- [30]
			"XY-2194584631:192484:193477", -- [31]
			"XY-2194584631:192484:189339:193508", -- [32]
			"XY-2194584631:188444:190049:191263:195235", -- [33]
			--["name"] = "Uktulut Pier, The Waking Shores",
			["m"] = 2022,
			["f"] = 0,
			["coord"] = 1968981624,
		},
		[191976] = {
			"189116:189459", -- [1]
			"189116:186443", -- [2]
			"191999:190332", -- [3]
			"186742:193454:196259:184630", -- [4]
			"191999:191622:191263", -- [5]
			"191999:192838", -- [6]
			"191999:192838:192865", -- [7]
			"191999:191622:191263:191814", -- [8]
			"191999:192838:192865:186487", -- [9]
			"191999:191622:191263:190049", -- [10]
			"191999:191622", -- [11]
			"186742:193454:196259", -- [12]
			"191999:191622:191263:191814:192494", -- [13]
			"191999:191622:191263:190049:192493", -- [14]
			"186742:193454:196259:184630:192843:188444:188336", -- [15]
			"186742:193458:189018:189339:192484:XY-2194584631:192472", -- [16]
			"186742:193458:189018:189339:193477:192490", -- [17]
			"186742:193458:189018:189339:192484", -- [18]
			"186742:193454:193321:192491", -- [19]
			"186742:193454:196259:184630:192843:188444", -- [20]
			"186742:193454:196259:184630:192843", -- [21]
			"186742:193454:193321", -- [22]
			"186742:193458:189018", -- [23]
			"186742:193458:189018:189339", -- [24]
			"186742:193454", -- [25]
			"186742:193458", -- [26]
			"186742:193458:189018:189339:193477", -- [27]
			"186742:193458:189018:193508", -- [28]
			"191999:192838:195235", -- [29]
			--["name"] = "Rhonin's Shield, Azure Span",
			["direct"] = "189116:186782:191999:186742",
			["coord"] = 2834579721,
			["m"] = 2024,
			["f"] = 0,
		},
		[189018] = {
			"193458:186742:191976:189116:189459", -- [1]
			"193458:186742:191976:189116", -- [2]
			"193458:186742:191976:189116:186443", -- [3]
			"193458:186742:191976:186782", -- [4]
			"193458:186742:191976", -- [5]
			"193458:186742:191999", -- [6]
			"193458:186742", -- [7]
			"193321:196259:191263:190332", -- [8]
			"193321:184630", -- [9]
			"193321:196259:191263", -- [10]
			"193321:196259:191622:192838", -- [11]
			"193321:196259:191263:192865", -- [12]
			"193321:196259:191263:191814", -- [13]
			"193321:196259:191263:191814:186487", -- [14]
			"193321:184630:190049", -- [15]
			"193321:196259:191622", -- [16]
			"193321:196259", -- [17]
			"193321:184630:190049:192493:192494", -- [18]
			"193321:184630:190049:192493", -- [19]
			"193321:184630:192843:188444:188336", -- [20]
			"189339:192484:XY-2194584631:192472", -- [21]
			"189339:193477:192490", -- [22]
			"189339:192484", -- [23]
			"193321:192491", -- [24]
			"193321:184630:192843:188444", -- [25]
			"193321:184630:192843", -- [26]
			"189339:193477", -- [27]
			"193321:196259:191263:195235", -- [28]
			--["name"] = "Gelikyr Post, Thaldraszus",
			["direct"] = "193321:189339:193454:193458:193508",
			["coord"] = 2195827620,
			["m"] = 2025,
			["f"] = 0,
		},
		[192494] = {
			"191814:192865:190332:189459", -- [1]
			"191814:191263:191622:191999:189116", -- [2]
			"191814:186487:186443", -- [3]
			"191814:191263:191622:191999:189116:186782", -- [4]
			"191814:191263:191622:191999:191976", -- [5]
			"191814:191263:191622:191999", -- [6]
			"191814:191263:196259:193454:186742", -- [7]
			"191814:192865:190332", -- [8]
			"192493:190049:184630", -- [9]
			"191814:191263", -- [10]
			"191814:191263:192838", -- [11]
			"191814:192865", -- [12]
			"191814:186487", -- [13]
			"192493:190049", -- [14]
			"191814:191263:191622", -- [15]
			"191814:191263:196259", -- [16]
			"192493:188336", -- [17]
			"192493:188444:XY-2194584631:192472", -- [18]
			"192493:188444:XY-2194584631:192490", -- [19]
			"192493:188444:192491:192484", -- [20]
			"192493:188444:192491", -- [21]
			"192493:188444", -- [22]
			"192493:188444:192843", -- [23]
			"192493:190049:184630:193321", -- [24]
			"192493:190049:184630:193321:189018", -- [25]
			"192493:188444:192491:189339", -- [26]
			"191814:191263:196259:193454", -- [27]
			"192493:190049:184630:193321:189018:193458", -- [28]
			"192493:188444:192491:192484:193477", -- [29]
			"192493:190049:184630:193321:189018:193508", -- [30]
			"191814:192865:195235", -- [31]
			--["name"] = "Uktulut Outpost, The Waking Shores",
			["direct"] = "191814:192493",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 752149271,
		},
		[191622] = {
			"191999:189116:189459", -- [1]
			"191999:189116", -- [2]
			"191999:189116:186443", -- [3]
			"191999:189116:186782", -- [4]
			"191999:191976", -- [5]
			"191999:186742", -- [6]
			"191263:190332", -- [7]
			"196259:184630", -- [8]
			"191263:192865", -- [9]
			"191263:191814", -- [10]
			"191263:191814:186487", -- [11]
			"191263:190049", -- [12]
			"191263:191814:192494", -- [13]
			"191263:190049:192493", -- [14]
			"196259:184630:192843:188444:188336", -- [15]
			"196259:184630:192491:192484:XY-2194584631:192472", -- [16]
			"196259:184630:192491:192484:192490", -- [17]
			"196259:184630:192491:192484", -- [18]
			"196259:184630:192491", -- [19]
			"196259:184630:192843:188444", -- [20]
			"196259:184630:192843", -- [21]
			"196259:193321", -- [22]
			"193454:189018", -- [23]
			"196259:193321:189339", -- [24]
			"193454:193458", -- [25]
			"196259:184630:192491:192484:193477", -- [26]
			"193454:189018:193508", -- [27]
			"192838:195235", -- [28]
			--["name"] = "Pinewood Post, Ohn'ahran Plains",
			["direct"] = "191999:191263:192838:196259:193454",
			["coord"] = 3455292502,
			["m"] = 2023,
			["f"] = 0,
		},
		[186487] = {
			"190332:189459", -- [1]
			"190332:189116", -- [2]
			"190332:189116:186782", -- [3]
			"191814:191263:196259:193454:193458:187013", -- [4]
			"191814:191263:196259:193321:200561", -- [5]
			"XY-1551657170:XY-1497641724:200300:202467", -- [6]
			"XY-1551657170:XY-1497641724:200300:200893", -- [7]
			"XY-1551657170:XY-1497641724:200300", -- [8]		
			"186443:189459", -- [1]
			"192865:190332:189116", -- [2]
			"192865:190332:189116:186782", -- [3]
			"192865:192838:191999:191976", -- [4]
			"192865:192838:191999", -- [5]
			"192865:192838:191999:186742", -- [6]
			"192865:190332", -- [7]
			"191814:191263:184630", -- [8]
			"191814:191263", -- [9]
			"192865:192838", -- [10]
			"191814:191263:190049", -- [11]
			"191814:191263:191622", -- [12]
			"191814:191263:196259", -- [13]
			"191814:192494", -- [14]
			"191814:192494:192493", -- [15]
			"191814:192494:192493:188336", -- [16]
			"191814:192494:192493:188444:XY-2194584631:192472", -- [17]
			"191814:191263:184630:192491:192484:192490", -- [18]
			"191814:191263:184630:192491:192484", -- [19]
			"191814:191263:184630:192491", -- [20]
			"191814:192494:192493:188444", -- [21]
			"191814:191263:190049:192843", -- [22]
			"191814:191263:196259:193321", -- [23]
			"191814:191263:196259:193321:189018", -- [24]
			"191814:191263:196259:193321:189339", -- [25]
			"191814:191263:196259:193454", -- [26]
			"191814:191263:196259:193454:193458", -- [27]
			"191814:191263:184630:192491:192484:193477", -- [28]
			"191814:191263:196259:193321:189018:193508", -- [29]
			"192865:195235", -- [30]
			"191814:191263:196259:193321:189339:189237", -- [1]
			--["name"] = "Shady Sanctuary, Ohn'ahran Plains",
			["direct"] = "186443:190332:192865:191814:216283",
			["f"] = 0,
			["m"] = 2023,
			["coord"] = 1280086983,
		},
		[192838] = {
			"184630:193321:189018:193458:187013", -- [1]
			"192491:192484:192490:200561", -- [2]
			"184630:193321:XY-2241298411:XY-3139928389:202467", -- [3]
			"184630:193321:XY-2241298411:XY-3139928389:202467:200893", -- [4]
			"190049:191263:192865:XY-1551657170:XY-1497641724:200300", -- [5]		
			"191999:186742:193458:187013", -- [1]
			"191622:196259:193321:200561", -- [2]
			"191622:196259:193321:XY-2241298411:XY-3139928389:202467", -- [3]
			"192865:XY-1551657170:XY-1497641724:200300:200893", -- [4]
			"192865:XY-1551657170:XY-1497641724:200300", -- [5]		
			"191999:189116:189459", -- [1]
			"191999:189116", -- [2]
			"190332:186443", -- [3]
			"191999:189116:186782", -- [4]
			"191999:191976", -- [5]
			"191999:186742", -- [6]
			"191622:196259:184630", -- [7]
			"191263:191814", -- [8]
			"192865:186487", -- [9]
			"191263:190049", -- [10]
			"191622:196259", -- [11]
			"191263:191814:192494", -- [12]
			"191263:190049:192493", -- [13]
			"191263:190049:188444:188336", -- [14]
			"191263:190049:188444:XY-2194584631:192472", -- [15]
			"191622:196259:184630:192491:192484:192490", -- [16]
			"191622:196259:184630:192491:192484", -- [17]
			"191622:196259:184630:192491", -- [18]
			"191263:190049:188444", -- [19]
			"191263:190049:192843", -- [20]
			"191622:196259:193321", -- [21]
			"191622:193454:189018", -- [22]
			"191622:196259:193321:189339", -- [23]
			"191622:193454", -- [24]
			"191999:186742:193458", -- [25]
			"191622:196259:184630:192491:192484:193477", -- [26]
			"191622:193454:189018:193508", -- [27]
			--["name"] = "Forkriver Crossing, Ohn'ahran Plains",
			["direct"] = "191999:190332:191263:192865:191622:195235",
			["coord"] = 3078146718,
			["m"] = 2023,
			["f"] = 0,
		},
		[202467] = {
			"XY-3139928389:XY-2241298411:193321:196259:191622:191999:189116:189459", -- [1]
			"XY-3139928389:XY-2241298411:193321:196259:191622:191999:189116", -- [2]
			"200300:XY-1545475988:XY-1669749166:190332:186443", -- [3]
			"XY-3139928389:XY-2241298411:193321:193454:186742:191976:186782", -- [4]
			"XY-3139928389:XY-2241298411:193321:193454:186742:191976", -- [5]
			"XY-3139928389:XY-2241298411:193321:196259:191622:191999", -- [6]
			"XY-3139928389:XY-2241298411:193321:193454:186742", -- [7]
			"200300:XY-1545475988:XY-1669749166:190332", -- [8]
			"XY-3139928389:XY-2241298411:193321:184630", -- [9]
			"XY-3139928389:XY-2241298411:193321:196259:191263", -- [10]
			"XY-3139928389:XY-2241298411:193321:196259:191622:192838", -- [11]
			"XY-3139928389:XY-2241298411:193321:196259:191263:192865", -- [12]
			"XY-3139928389:XY-2241298411:193321:196259:191263:191814", -- [13]
			"200300:XY-1497641724:XY-1551657170:186487", -- [14]
			"XY-3139928389:XY-2241298411:193321:184630:190049", -- [15]
			"XY-3139928389:XY-2241298411:193321:196259:191622", -- [16]
			"XY-3139928389:XY-2241298411:193321:196259", -- [17]
			"XY-3139928389:XY-2241298411:193321:184630:190049:192493", -- [18]
			"XY-3139928389:XY-2241298411:193321:184630:192843:188444:188336", -- [19]
			"XY-3139928389:XY-2241298411:193321:192491:192484:XY-2194584631:192472", -- [20]
			"XY-3139928389:XY-2241298411:193321:192491:192484:192490", -- [21]
			"XY-3139928389:XY-2241298411:193321:192491:192484", -- [22]
			"XY-3139928389:XY-2241298411:193321:192491", -- [23]
			"XY-3139928389:XY-2241298411:193321:184630:192843:188444", -- [24]
			"XY-3139928389:XY-2241298411:193321:184630:192843", -- [25]
			"XY-3139928389:XY-2241298411:193321", -- [26]
			"XY-3139928389:XY-2241298411:193321:189018", -- [27]
			"XY-3139928389:XY-2241298411:193321:189018:193458:187013", -- [28]
			"XY-3139928389:XY-2241298411:193321:189339", -- [29]
			"XY-3139928389:XY-2241298411:193321:189339:189237", -- [30]
			"XY-3139928389:XY-2241298411:193321:193454", -- [31]
			"XY-3139928389:XY-2241298411:193321:189018:193458", -- [32]
			"XY-3139928389:XY-2241298411:193321:189339:193477", -- [33]
			"XY-3139928389:XY-2241298411:193321:189018:193508", -- [34]
			"XY-3139928389:XY-2241298411:193321:196259:191263:195235", -- [35]
			"XY-3139928389:XY-2241298411:193321:200561", -- [36]
			--["name"] = "Loamm, Zaralek Cavern",
			["m"] = 2133,
			["f"] = 0,
			["direct"] = "200893:200300",
			["coord"] = 2388888642,
		},		
		[192843] = {
			"184630:196259:191622:191999:189116:189459", -- [1]
			"184630:196259:191622:191999:189116", -- [2]
			"190049:191263:190332:186443", -- [3]
			"184630:196259:193454:186742:191976:186782", -- [4]
			"184630:196259:193454:186742:191976", -- [5]
			"184630:196259:191622:191999", -- [6]
			"184630:196259:193454:186742", -- [7]
			"190049:191263:190332", -- [8]
			"190049:191263", -- [9]
			"184630:196259:191622:192838", -- [10]
			"190049:191263:192865", -- [11]
			"190049:191263:191814", -- [12]
			"190049:191263:191814:186487", -- [13]
			"184630:196259:191622", -- [14]
			"184630:196259", -- [15]
			"188444:192493:192494", -- [16]
			"188444:192493", -- [17]
			"188444:188336", -- [18]
			"188444:XY-2194584631:192472", -- [19]
			"192491:192484:192490", -- [20]
			"192491:192484", -- [21]
			"184630:193321", -- [22]
			"184630:193321:189018", -- [23]
			"192491:189339", -- [24]
			"184630:196259:193454", -- [25]
			"184630:193321:189018:193458", -- [26]
			"192491:192484:193477", -- [27]
			"184630:193321:189018:193508", -- [28]
			"190049:191263:195235", -- [29]
			--["name"] = "Dragonscale Basecamp, The Waking Shores",
			["direct"] = "184630:190049:192491:188444",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 2057753930,
		},
		[192491] = {
			"193321:189018:193458:187013", -- [1]
			"192484:192490:200561", -- [2]
			"193321:XY-2241298411:XY-3139928389:202467", -- [3]
			"193321:XY-2241298411:XY-3139928389:202467:200893", -- [4]
			"192843:190049:191263:192865:XY-1551657170:XY-1497641724:200300", -- [5]		
			"184630:196259:191622:191999:189116:189459", -- [1]
			"184630:196259:191622:191999:189116", -- [2]
			"192843:190049:191263:190332:186443", -- [3]
			"193321:193454:186742:191976:186782", -- [4]
			"193321:193454:186742:191976", -- [5]
			"184630:196259:191622:191999", -- [6]
			"193321:193454:186742", -- [7]
			"192843:190049:191263:190332", -- [8]
			"192843:190049:191263", -- [9]
			"184630:196259:191622:192838", -- [10]
			"192843:190049:191263:192865", -- [11]
			"192843:190049:191263:191814", -- [12]
			"192843:190049:191263:191814:186487", -- [13]
			"192843:190049", -- [14]
			"184630:196259:191622", -- [15]
			"184630:196259", -- [16]
			"188444:192493:192494", -- [17]
			"188444:192493", -- [18]
			"188444:188336", -- [19]
			"192484:XY-2194584631:192472", -- [20]
			"192484:192490", -- [21]
			"193321:189018", -- [22]
			"193321:193454", -- [23]
			"193321:189018:193458", -- [24]
			"192484:193477", -- [25]
			"189339:193508", -- [26]
			"192843:190049:191263:195235", -- [27]
			--["name"] = "Ruby Life Pools, The Waking Shores",
			["direct"] = "184630:192484:188444:192843:193321:189339",
			["f"] = 0,
			["m"] = 2022,
			["coord"] = 2483007014,
		},
		[189237] = {
			"189339:193321:196259:191622:191999:189116:189459", -- [1]
			"189339:193321:196259:191622:191999:189116", -- [2]
			"189339:193321:196259:191263:190332:186443", -- [3]
			"189339:189018:193458:186742:191976:186782", -- [4]
			"189339:189018:193458:186742:191976", -- [5]
			"189339:193321:196259:191622:191999", -- [6]
			"189339:189018:193458:186742", -- [7]
			"189339:193321:196259:191263:190332", -- [8]
			"189339:193321:184630", -- [9]
			"189339:193321:196259:191263", -- [10]
			"189339:193321:196259:191622:192838", -- [11]
			"189339:193321:196259:191263:192865", -- [12]
			"189339:193321:196259:191263:191814", -- [13]
			"189339:193321:196259:191263:191814:186487", -- [14]
			"193477:192484:192491:192843:190049", -- [15]
			"189339:193321:196259:191622", -- [16]
			"189339:193321:196259", -- [17]
			"193477:192484:192491:188444:192493:192494", -- [18]
			"193477:192484:192491:188444:192493", -- [19]
			"192490:XY-2194584631:188336", -- [20]
			"192490:XY-2194584631:192472", -- [21]
			"193477:192484", -- [22]
			"193477:192484:192491", -- [23]
			"193477:192484:192491:188444", -- [24]
			"193477:192484:192491:192843", -- [25]
			"189339:193321", -- [26]
			"189339:189018", -- [27]
			"189339:193321:193454", -- [28]
			"189339:189018:193458", -- [29]
			"189339:193321:196259:191263:195235", -- [30]
			["m"] = 2025,
			["coord"] = 2666344523,
			["direct"] = "192490:189339:193477:193508",
			["f"] = 0,
		},
	},
	[2274] = {
		[249811] = {
		--["name"] = "Ruins of Yaathron",
		["direct"] = "249744:249747:249754:249761:249764:249765:249768:249771:249775:249778:249781:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 2207230942,
		["isPhase"] = true,
		},
		[249764] = {
		--["name"] = "Serrated Peaks",
		["direct"] = "249744:249747:249754:249761:249765:249768:249771:249775:249778:249781:249811:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 2198502510,
		["isPhase"] = true,
		},
		[249765] = {
		--["name"] = "Overlook Zo'Shuul",
		["direct"] = "249744:249747:249754:249761:249764:249768:249771:249775:249778:249781:249811:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 2165398860,
		["isPhase"] = true,
		},
		[249781] = {
		--["name"] = "Untethered Space",
		["direct"] = "249744:249747:249754:249761:249764:249765:249768:249771:249775:249778:249811:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 2316125313,
		["isPhase"] = true,
		},
		[249775] = {
		--["name"] = "Naakroa",
		["direct"] = "249744:249747:249754:249761:249764:249765:249768:249771:249778:249781:249811:249841",
		["coord"] = 2529530925,
		["m"] = 2371,
		["f"] = 0,
		["isPhase"] = true,
		},
		[249744] = {
		--["name"] = "Tazavesh, the Veiled Market",
		["direct"] = "249747:249754:249761:249764:249765:249768:249771:249775:249778:249781:249811:249841",
		["f"] = 0,
		["m"] = 2472,
		["coord"] = 2010943967,
		["isPhase"] = true,
		},
		[249768] = {
		--["name"] = "Lunnall River",
		["direct"] = "249744:249747:249754:249761:249764:249765:249771:249775:249778:249781:249811:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 2811329214,
		["isPhase"] = true,
		},
		[249761] = {
		--["name"] = "Shadow Point",
		["direct"] = "249744:249747:249754:249764:249765:249768:249771:249775:249778:249781:249811:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 1941454100,
		["isPhase"] = true,
		},
		[249754] = {
		--["name"] = "Shan'dorah",
		["direct"] = "249744:249747:249761:249764:249765:249768:249771:249775:249778:249781:249811:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 2586004069,
		["isPhase"] = true,
		},
		[249841] = {
		--["name"] = "Hosaas' Rest",
		["direct"] = "249744:249747:249754:249761:249764:249765:249768:249771:249775:249781:249811",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 2311627439,
		["isPhase"] = true,
		},
		[249747] = {
		["m"] = 2371,
		["f"] = 0,
		["direct"] = "249744:249754:249761:249764:249765:249768:249771:249775:249778:249781:249811:249841",
		["coord"] = 3258930414,
		["isPhase"] = true,
		},
		[249771] = {
		--["name"] = "North Sufaad",
		["direct"] = "249744:249747:249754:249761:249764:249765:249768:249775:249778:249781:249811:249841",
		["f"] = 0,
		["m"] = 2371,
		["coord"] = 3313597755,
		["isPhase"] = true,
		},
		[234692] = {
		"234722:234718",
		"234701:234724:234719",
		"234701:234724",
		--["name"] = "Tazavesh, K'aresh",
		["m"] = 2472,
		["direct"] = "234722:234721:234701",
		["coord"] = 1492916753,
		["f"] = 0,
		},
		[234719] = {
		"234724:234701:234692",
		"234724:234722",
		"234721:234718",
		"234724:234701",
		--["name"] = "Shadow Point, K'aresh",
		["m"] = 2371,
		["direct"] = "234721:234724",
		["coord"] = 1814313484,
		["f"] = 0,
		},
		[234701] = {
		"234692:234722",
		"234724:234721",
		"234724:234719",
		--["name"] = "Hosaas Rest, K'aresh",
		["m"] = 2371,
		["direct"] = "234692:234718:234724",
		["coord"] = 2328404166,
		["f"] = 0,
		},
		[234724] = {
		"234701:234692",
		"234721:234718",
		--["name"] = "Overlook Zo'Shuul, K'aresh",
		["direct"] = "234722:234721:234719:234701",
		["m"] = 2371,
		["coord"] = 2053398366,
		["f"] = 0,
		},
		[234721] = {
		"234718:234722",
		"234724:234701",
		--["name"] = "Shan'dorah, K'aresh",
		["direct"] = "234692:234718:234719:234724",
		["m"] = 2371,
		["coord"] = 2602650286,
		["f"] = 0,
		},
		[234718] = {
		"234722:234692",
		"234721:234719",
		"234721:234724",
		["direct"] = "234722:234721:234701",
		["m"] = 2371,
		["coord"] = 3292027245,
		["f"] = 0,
		},
		[234722] = {
		"234718:234721",
		"234724:234719",
		"234692:234701",
		--["name"] = "Eco-Dome: Rhovan, K'aresh",
		["m"] = 2371,
		["direct"] = "234692:234718:234724",
		["coord"] = 3014827013,
		["f"] = 0,
		},
	[208384] = {
		"216972:209330",
		"216972:216979",
		"216973:218298:217639",
		"216973:224940:224884",
		"216973:224940",
		"216973:218298:215563:212369",
		"216973:218298:215563:212369:217439",
		"216973:218298:215563:212369:217542",
		"216973:218298:215563:212369:217543",
		"218304:218305",
		"218304:218305:218323",
		"218304:218305:218295",
		"218304:218300:206537",
		"216973:218298",
		"216973:218298:215563",
		"216973:224940:218388",
		--["name"] = "Wildcamp Or'lay, Azj-Kahet",
		["m"] = 2255,
		["coord"] = 996639466,
		["direct"] = "207470:216972:216973:218304",
		["f"] = 0,
		},
		[216979] = {
		"216972:208384",
		"207470:216973",
		"207470:216973:218298:217639",
		"216972:208384:218304",
		"207470:216973:224940:224884",
		"207470:216973:224940",
		"207470:216973:218298:215563:212369",
		"207470:216973:218298:215563:212369:217439",
		"207470:216973:218298:215563:212369:217542",
		"207470:216973:218298:215563:212369:217543",
		"216972:208384:218304:218305",
		"216972:208384:218304:218305:218323",
		"207470:216973:218298:217639:218295",
		"207470:216973:218298:217639:206537",
		"207470:216973:218298",
		"207470:216973:218298:215563",
		"207470:216973:224940:218388",
		--["name"] = "Mmarl, Azj-Kahet",
		["direct"] = "207470:209330:216972",
		["coord"] = 3301287163,
		["m"] = 2255,
		["f"] = 0,
		},
		[207470] = {
		"216973:218298:217639",
		"208384:218304",
		"216973:224940:224884",
		"216973:224940",
		"216973:218298:215563:212369",
		"216973:218298:215563:212369:217439",
		"216973:218298:215563:212369:217542",
		"216973:218298:215563:212369:217543",
		"208384:218304:218305",
		"216973:218298:218323",
		"216973:218298:217639:218295",
		"216973:218298:217639:206537",
		"216973:218298",
		"216973:218298:215563",
		"216973:224940:218388",
		--["name"] = "Weaver's Lair, Azj-Kahet",
		["m"] = 2255,
		["coord"] = 2443737166,
		["direct"] = "208384:209330:216972:216973:216979",
		["f"] = 0,
		},
		[216972] = {
		"207470:216973",
		"207470:216973:218298:217639",
		"208384:218304",
		"207470:216973:224940:224884",
		"207470:216973:224940",
		"207470:216973:218298:215563:212369",
		"207470:216973:218298:215563:212369:217439",
		"207470:216973:218298:215563:212369:217542",
		"207470:216973:218298:215563:212369:217543",
		"208384:218304:218305",
		"208384:218304:218305:218323",
		"208384:218304:218305:218295",
		"207470:216973:218298:217639:206537",
		"207470:216973:218298",
		"207470:216973:218298:215563",
		"207470:216973:224940:218388",
		--["name"] = "Wildcamp Ul'ar, Azj-Kahet",
		["m"] = 2255,
		["coord"] = 1912253613,
		["direct"] = "207470:208384:209330:216979",
		["f"] = 0,
		},
		[217542] = {
		"212369:215563:218298:216973:207470",
		"212369:215563:217639:218300:218304:208384",
		"212369:215563:218298:216973:207470:209330",
		"212369:215563:218298:216973:207470:216972",
		"212369:215563:218298:216973",
		"212369:215563:218298:216973:207470:216979",
		"212369:215563:217639",
		"212369:215563:217639:218300:218304",
		"212369:215563:224940:224884",
		"212369:215563:224940",
		"212369:217439",
		"212369:215563:217639:218305",
		"212369:215563:217639:218295:218323",
		"212369:215563:217639:218295",
		"212369:215563:217639:206537",
		"212369:215563:218298",
		"212369:215563",
		"212369:215563:218388",
		"212369:215563:224940:224884:228137",
		["m"] = 2248,
		["direct"] = "212369:217543",
		["coord"] = 2897047267,
		["f"] = 0,
		},
		[217639] = {
		"218298:216973:207470",
		"218300:218304:208384",
		"218298:216973:207470:209330",
		"218298:216973:207470:216972",
		"218298:216973",
		"218298:216973:207470:216979",
		"218300:218304",
		"215563:224940:224884",
		"215563:224940",
		"215563:212369",
		"215563:212369:217439",
		"215563:212369:217542",
		"215563:212369:217543",
		"218295:218323",
		"215563:218388",
		--["name"] = "Dunelle's Kindness, Hallowfall",
		["m"] = 2215,
		["f"] = 0,
		["direct"] = "218305:218295:206537:218298:215563",
		["coord"] = 2899276334,
		},
		[218298] = {
		"216973:207470",
		"216973:208384",
		"216973:207470:209330",
		"216973:207470:216972",
		"216973:207470:216979",
		"218300:218304",
		"216973:224940:224884",
		"216973:224940",
		"215563:212369",
		"215563:212369:217439",
		"215563:212369:217542",
		"215563:212369:217543",
		"218300:218305",
		"217639:218295",
		"217639:206537",
		"215563:218388",
		--["name"] = "The Aegis Wall, Hallowfall",
		["m"] = 2215,
		["f"] = 0,
		["direct"] = "216973:217639:218323:215563",
		["coord"] = 3063845001,
		},
		[224940] = {
		"216973:207470",
		"216973:208384",
		"216973:207470:209330",
		"216973:207470:216972",
		"216973:207470:216979",
		"215563:217639",
		"216973:218298:218300:218304",
		"215563:212369",
		"215563:212369:217439",
		"215563:212369:217542",
		"215563:212369:217543",
		"215563:217639:218305",
		"216973:218298:218323",
		"215563:217639:218295",
		"215563:217639:206537",
		"216973:218298",
		--["name"] = "Camp Murroch, The Ringing Deeps",
		["m"] = 2214,
		["f"] = 0,
		["direct"] = "216973:224884:215563:218388",
		["coord"] = 2321654804,
		},
		[228137] = {
		"224884:224940:216973:207470",
		"224884:224940:216973:208384",
		"224884:224940:216973:207470:209330",
		"224884:224940:216973:207470:216972",
		"224884:224940:216973",
		"224884:224940:216973:207470:216979",
		"224884:224940:215563:217639",
		"224884:224940:216973:218298:218300:218304",
		"224884:224940",
		"224884:224940:215563:212369",
		"224884:224940:215563:212369:217439",
		"224884:224940:215563:212369:217542",
		"224884:224940:215563:212369:217543",
		"224884:224940:215563:217639:218305",
		"224884:224940:216973:218298:218323",
		"224884:224940:215563:217639:218295",
		"224884:224940:215563:217639:206537",
		"224884:224940:216973:218298",
		"224884:224940:215563",
		"224884:224940:218388",
		--["name"] = "Gutterville, The Ringing Deeps",
		["direct"] = "224884",
		["f"] = 0,
		["m"] = 2214,
		["coord"] = 3073496433,
		},
		[209330] = {
		"216972:208384",
		"207470:216973",
		"207470:216973:218298:217639",
		"216972:208384:218304",
		"207470:216973:224940:224884",
		"207470:216973:224940",
		"207470:216973:218298:215563:212369",
		"207470:216973:218298:215563:212369:217439",
		"207470:216973:218298:215563:212369:217542",
		"207470:216973:218298:215563:212369:217543",
		"216972:208384:218304:218305",
		"216972:208384:218304:218305:218323",
		"216972:208384:218304:218305:218295",
		"207470:216973:218298:217639:206537",
		"207470:216973:218298",
		"207470:216973:218298:215563",
		"207470:216973:224940:218388",
		--["name"] = "The Burrows, Azj-Kahet",
		["direct"] = "207470:216972:216979",
		["coord"] = 2315481549,
		["m"] = 2216,
		["f"] = 0,
		},
		[217543] = {
		--["name"] = "Rambleshire, Isle of Dorn",
		},
		[215563] = {
		"218298:216973:207470",
		"217639:218300:218304:208384",
		"218298:216973:207470:209330",
		"218298:216973:207470:216972",
		"218298:216973",
		"218298:216973:207470:216979",
		"217639:218300:218304",
		"224940:224884",
		"212369:217439",
		"212369:217542",
		"212369:217543",
		"217639:218305",
		"217639:218295:218323",
		"217639:218295",
		"217639:206537",
		--["name"] = "Gundargaz, The Ringing Deeps",
		["m"] = 2214,
		["f"] = 0,
		["direct"] = "217639:224940:212369:218298:218388",
		["coord"] = 1834833265,
		},
		[218295] = {
		"217639:218298:216973:207470",
		"218305:218304:208384",
		"218305:218304:208384:216972:209330",
		"218305:218304:208384:216972",
		"217639:218298:216973",
		"217639:218298:216973:207470:216979",
		"218305:218304",
		"217639:215563:224940:224884",
		"217639:215563:224940",
		"217639:215563:212369",
		"217639:215563:212369:217439",
		"217639:215563:212369:217542",
		"217639:215563:212369:217543",
		"217639:218298",
		"217639:215563",
		"217639:215563:218388",
		--["name"] = "Lorel's Crossing, Hallowfall",
		["m"] = 2215,
		["f"] = 0,
		["direct"] = "217639:218305:218323:206537",
		["coord"] = 2076469271,
		},
		[212369] = {
		"215563:218298:216973:207470",
		"215563:217639:218300:218304:208384",
		"215563:218298:216973:207470:209330",
		"215563:218298:216973:207470:216972",
		"215563:218298:216973",
		"215563:218298:216973:207470:216979",
		"215563:217639",
		"215563:217639:218300:218304",
		"215563:224940:224884",
		"215563:224940",
		"215563:217639:218305",
		"215563:217639:218295:218323",
		"215563:217639:218295",
		"215563:217639:206537",
		"215563:218298",
		"215563:218388",
		"215563:224940:224884:228137",
		--["name"] = "Dornogal, Isle of Dorn",
		["direct"] = "217439:217542:217543:215563",
		["m"] = 2339,
		["f"] = 0,
		["coord"] = 1922466475,
		},
		[206537] = {
		"217639:218298:216973:207470",
		"218295:218305:218304:208384",
		"217639:218298:216973:207470:209330",
		"217639:218298:216973:207470:216972",
		"217639:218298:216973",
		"217639:218298:216973:207470:216979",
		"218295:218305:218304",
		"217639:215563:224940:224884",
		"217639:215563:224940",
		"217639:215563:212369",
		"217639:215563:212369:217439",
		"217639:215563:212369:217542",
		"217639:215563:212369:217543",
		"218295:218305",
		"218295:218323",
		"217639:218298",
		"217639:215563",
		"217639:215563:218388",
		--["name"] = "Hillhelm Family Farm, Hallowfall",
		["direct"] = "217639:218295",
		["f"] = 0,
		["m"] = 2215,
		["coord"] = 2634174279,
		},
		[217439] = {
		"212369:215563:218298:216973:207470",
		"212369:215563:217639:218300:218304:208384",
		"212369:215563:218298:216973:207470:209330",
		"212369:215563:218298:216973:207470:216972",
		"212369:215563:218298:216973",
		"212369:215563:218298:216973:207470:216979",
		"212369:215563:217639",
		"212369:215563:217639:218300:218304",
		"212369:215563:224940:224884",
		"212369:215563:224940",
		"212369:217542",
		"212369:217543",
		"212369:215563:217639:218305",
		"212369:215563:217639:218295:218323",
		"212369:215563:217639:218295",
		"212369:215563:217639:206537",
		"212369:215563:218298",
		"212369:215563",
		"212369:215563:218388",
		"212369:215563:224940:224884:228137",
		--["name"] = "Freywold Village, Isle of Dorn",
		["direct"] = "212369",
		["m"] = 2248,
		["coord"] = 1763949255,
		["f"] = 0,
		},
		[216973] = {
		"207470:209330",
		"207470:216972",
		"207470:216979",
		"218298:217639",
		"218298:218300:218304",
		"224940:224884",
		"218298:215563:212369",
		"218298:215563:212369:217439",
		"218298:215563:212369:217542",
		"218298:215563:212369:217543",
		"218298:218300:218305",
		"218298:218323",
		"218298:217639:218295",
		"218298:217639:206537",
		"218298:215563",
		"224940:218388",
		--["name"] = "Faerin's Advance, Azj-Kahet",
		["m"] = 2255,
		["f"] = 0,
		["direct"] = "207470:208384:224940:218298",
		["coord"] = 2574266368,
		},
		[224884] = {
		"224940:216973:207470",
		"224940:216973:208384",
		"224940:216973:207470:209330",
		"224940:216973:207470:216972",
		"224940:216973",
		"224940:216973:207470:216979",
		"224940:215563:217639",
		"224940:216973:218298:218300:218304",
		"224940:215563:212369",
		"224940:215563:212369:217439",
		"224940:215563:212369:217542",
		"224940:215563:212369:217543",
		"224940:215563:217639:218305",
		"224940:216973:218298:218323",
		"224940:215563:217639:218295",
		"224940:215563:217639:206537",
		"224940:216973:218298",
		"224940:215563",
		"224940:218388",
		--["name"] = "Opportunity Point, The Ringing Deeps",
		["direct"] = "224940",
		["f"] = 0,
		["m"] = 2214,
		["coord"] = 2600847371,
		},
		[218304] = {
		"208384:207470",
		"208384:216972:209330",
		"208384:216972",
		"218300:218298:216973",
		"208384:216972:216979",
		"218300:217639",
		"218300:218298:216973:224940:224884",
		"218300:218298:216973:224940",
		"218300:217639:215563:212369",
		"218300:217639:215563:212369:217439",
		"218300:217639:215563:212369:217542",
		"218300:217639:215563:212369:217543",
		"218305:218323",
		"218305:218295",
		"218300:206537",
		"218300:218298",
		"218300:217639:215563",
		"218300:217639:215563:218388",
		--["name"] = "Light's Redoubt, Hallowfall",
		["direct"] = "208384:218305",
		["coord"] = 1737537109,
		["m"] = 2215,
		["f"] = 0,
		},
		[218323] = {
		"218295:217639:218298:216973:207470",
		"218304:208384",
		"218304:208384:216972:209330",
		"218304:208384:216972",
		"218295:217639:218298:216973",
		"218295:217639:218298:216973:207470:216979",
		"218295:217639",
		"218295:217639:215563:224940:224884",
		"218295:217639:215563:224940",
		"218295:217639:215563:212369",
		"218295:217639:215563:212369:217439",
		"218295:217639:215563:212369:217542",
		"218295:217639:215563:212369:217543",
		"218295:206537",
		"218295:217639:218298",
		"218295:217639:215563",
		"218295:217639:215563:218388",
		--["name"] = "Priory of the Sacred Flame, Hallowfall",
		["direct"] = "218304:218305:218295",
		["f"] = 0,
		["m"] = 2215,
		["coord"] = 1764513354,
		},
		[218388] = {
		"224940:216973:207470",
		"224940:216973:208384",
		"224940:216973:207470:209330",
		"224940:216973:207470:216972",
		"224940:216973",
		"224940:216973:207470:216979",
		"215563:217639",
		"215563:217639:218300:218304",
		"224940:224884",
		"215563:212369",
		"215563:212369:217439",
		"215563:212369:217542",
		"215563:212369:217543",
		"215563:217639:218305",
		"215563:217639:218295:218323",
		"215563:217639:218295",
		"215563:217639:206537",
		"215563:218298",
		--["name"] = "Shadowvein Point, The Ringing Deeps",
		["direct"] = "224940:215563",
		["f"] = 0,
		["m"] = 2214,
		["coord"] = 2459728570,
		},
		[218305] = {
		"218304:208384:207470",
		"218304:208384",
		"218304:208384:216972:209330",
		"218304:208384:216972",
		"217639:218298:216973",
		"218304:208384:216972:216979",
		"217639:215563:224940:224884",
		"217639:215563:224940",
		"217639:215563:212369",
		"217639:215563:212369:217439",
		"217639:215563:212369:217542",
		"217639:215563:212369:217543",
		"218295:206537",
		"217639:218298",
		"217639:215563",
		"217639:215563:218388",
		--["name"] = "Mereldar, Hallowfall",
		["m"] = 2215,
		["f"] = 0,
		["direct"] = "217639:218304:218323:218295",
		["coord"] = 1785300631,
		},
		[230878] = {
		--["name"] = "Slam Central Station",
		["direct"] = "230879:230882:230881:230880",
		["m"] = 2346,
		["coord"] = 1050379774,
		["f"] = 0,
		},
		[230879] = {
		--["name"] = "The Incontinental Hotel",
		["direct"] = "230882:230878:230881:230880",
		["m"] = 2346,
		["coord"] = 1842771528,
		["f"] = 0,
		},
		[230880] = {
		--["name"] = "The Gallagio",
		["direct"] = "230879:230882:230878:230881",
		["m"] = 2346,
		["coord"] = 2650045235,
		["f"] = 0,
		},
		[230882] = {
		"230879:230878",
		--["name"] = "The Heaps",
		["m"] = 2346,
		["direct"] = "230879:230881:230880",
		["coord"] = 1879427803,
		["f"] = 0,
		},
		[230881] = {
		--["name"] = "Demolition Dome",
		["m"] = 2346,
		["direct"] = "230879:230882:230878:230880",
		["coord"] = 2492864210,
		["f"] = 0,
		},	
	},
	},

	["Alliance"] = {
	{
		[11800] = {
			direct = "3838",
			m = 80,
			f = 0,
			coord = 1897034694,
			requirements = "cls:DRUID",
			overridePlayerData = true
		},	
		[4321] = {
			"16227:4267:33253:3841:3838", -- [1]
			"39212:39210:35136:4407", -- [2]
			"40358:40367:41383", -- [3]
			"16227:4267:33253:3841:10897", -- [4]
			"16227:4267:22931:12578:11138", -- [5]
			"16227:4267:22931:12578", -- [6]
			"7823:39175:15177", -- [7]
			"7823:10583", -- [8]
			"16227:4267:33253:3841:17555:17554", -- [9]
			"16227:4267:33253:3841:17555", -- [10]
			"16227:4267:22931", -- [11]
			"16227:4267:22935", -- [12]
			"16227:4267:34374", -- [13]
			"16227:4267:33253", -- [14]
			"39212:39210:34378", -- [15]
			"39212:39210:35136:35137", -- [16]
			"39212:39210:35136", -- [17]
			"39212:39210:35136:6706:35138", -- [18]
			"39212:39210:35136:6706:35481", -- [19]
			"39212:39210:35136:6706:35478", -- [20]
			"39212:39210:35136:6706:35556", -- [21]
			"39212:39210:35136:6706:35562", -- [22]
			"7823:39175", -- [23]
			"39212:39210", -- [24]
			"40358:39211", -- [25]
			"16227:4267:33253:3841:3838:40552:40553", -- [26]
			"16227:4267:33253:3841:3838:40552", -- [27]
			"40358:40768", -- [28]
			"7823:40827", -- [29]
			"7823:41214", -- [30]
			"39212:39210:35136:35137:41240", -- [31]
			"16227:4267:22935:43549:50084", -- [32]
			"16227:4267:22935:43549:50084:53783", -- [33]
			"16227:4267:22935:43549:50084:41861", -- [34]
			"40358:40367:41383:40966", -- [35]
			"40358:40367:41580", -- [36]
			"16227:4267:22931:43073", -- [37]
			"16227:4267:22931:43079", -- [38]
			"16227:4267:22935:43549", -- [39]
			"16227:4267:33253:3841:17555:43991", -- [40]
			"16227:4267:22935:43549:50084:54393", -- [41]
			--["name"] = "Theramore, Dustwallow Marsh",
			["m"] = 70,
			["f"] = 0,
			["direct"] = "3841:4267:40367:6706:7823:16227:40358:39212",
			["coord"] = 2897314579,
		},
		[12578] = {
			"3841:3838", -- [1]
			"33253:4267", -- [2]
			"33253:4267:34378:6706:35481:40966:41383:41580:40367", -- [3]
			"33253:4267:16227:4321", -- [4]
			"33253:4407", -- [5]
			"33253:4267:34378:6706", -- [6]
			"33253:4267:34378:39210:39211:40358:40768:7823", -- [7]
			"33253:4267:34378:6706:35481:40966:41383", -- [8]
			"33253:4267:34378:6706:35481:40966:41383:15177", -- [9]
			"33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [10]
			"33253:4267:16227", -- [11]
			"3841:17555:17554", -- [12]
			"3841:17555", -- [13]
			"22931:22935", -- [14]
			"33253:4267:34378:39210:39211:40358", -- [15]
			"33253:34374", -- [16]
			"33253:4267:34378", -- [17]
			"33253:4267:34378:35137", -- [18]
			"33253:4267:34378:35136", -- [19]
			"33253:4407:35138", -- [20]
			"33253:4267:34378:6706:35481", -- [21]
			"33253:4267:34378:6706:35478", -- [22]
			"33253:4267:34378:6706:35556", -- [23]
			"33253:4267:34378:6706:35562", -- [24]
			"33253:4267:34378:6706:35481:40966:41383:15177:39175", -- [25]
			"33253:4267:34378:39210", -- [26]
			"33253:4267:34378:39210:39212", -- [27]
			"33253:4267:34378:39210:39211", -- [28]
			"3841:3838:40552:40553", -- [29]
			"3841:3838:40552", -- [30]
			"33253:4267:34378:39210:39211:40358:40768", -- [31]
			"33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [32]
			"33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [33]
			"33253:4407:41240", -- [34]
			"10897:41861:50084", -- [35]
			"10897:41861:53783", -- [36]
			"10897:41861", -- [37]
			"33253:4267:34378:6706:35481:40966", -- [38]
			"33253:4267:34378:6706:35481:40966:41383:41580", -- [39]
			"43073:43079", -- [40]
			"10897:41861:50084:43549", -- [41]
			"3841:17555:43991", -- [42]
			"10897:41861:50084:54393", -- [43]
			--["name"] = "Talonbranch Glade, Felwood",
			["m"] = 77,
			["coord"] = 2601533647,
			["direct"] = "3841:10897:11138:22931:33253:43073",
			["f"] = 0,
		},
		[39210] = {
			"34378:4267:33253:3841", -- [1]
			"34378:4267:33253:3841:3838", -- [2]
			"34378:4267", -- [3]
			"39211:40358:40367", -- [4]
			"39212:4321", -- [5]
			"35136:4407", -- [6]
			"35136:6706", -- [7]
			"39211:40358:40768:7823", -- [8]
			"35136:6706:35481:40966:41383", -- [9]
			"34378:4267:33253:3841:10897", -- [10]
			"34378:4267:22931:12578:11138", -- [11]
			"34378:4267:22931:12578", -- [12]
			"35136:6706:35481:40966:41383:15177", -- [13]
			"39211:40358:40768:7823:10583", -- [14]
			"34378:4267:33253:3841:17555:17554", -- [15]
			"34378:4267:33253:3841:17555", -- [16]
			"34378:4267:22931", -- [17]
			"34378:4267:22935", -- [18]
			"39211:40358", -- [19]
			"34378:4267:34374", -- [20]
			"34378:4267:33253", -- [21]
			"35136:35137", -- [22]
			"35136:6706:35138", -- [23]
			"35136:6706:35481", -- [24]
			"35136:6706:35478", -- [25]
			"35136:6706:35556", -- [26]
			"35136:6706:35562", -- [27]
			"39211:40358:40768:7823:39175", -- [28]
			"34378:4267:33253:3841:3838:40552:40553", -- [29]
			"34378:4267:33253:3841:3838:40552", -- [30]
			"39211:40358:40768", -- [31]
			"39211:40358:40768:7823:40827", -- [32]
			"39211:40358:40768:7823:41214", -- [33]
			"35136:35137:41240", -- [34]
			"34378:4267:22935:43549:50084", -- [35]
			"34378:4267:22935:43549:50084:53783", -- [36]
			"34378:4267:22935:43549:50084:41861", -- [37]
			"35136:6706:35481:40966", -- [38]
			"35136:6706:35481:40966:41383:41580", -- [39]
			"34378:4267:22931:43073", -- [40]
			"34378:4267:22931:43079", -- [41]
			"34378:4267:22935:43549", -- [42]
			"34378:4267:33253:3841:17555:43991", -- [43]
			"34378:4267:22935:43549:50084:54393", -- [44]
			--["name"] = "Honor's Stand, Southern Barrens",
			["m"] = 199,
			["f"] = 0,
			["direct"] = "16227:34378:35136:39212:39211",
			["coord"] = 1673731057,
		},
		[39212] = {
			"16227:4267:33253:3841", -- [1]
			"16227:4267:33253:3841:3838", -- [2]
			"16227:4267", -- [3]
			"4321:40358:40367", -- [4]
			"39210:35136:4407", -- [5]
			"39210:35136:6706", -- [6]
			"4321:7823", -- [7]
			"4321:40358:40367:41383", -- [8]
			"16227:4267:33253:3841:10897", -- [9]
			"16227:4267:22931:12578:11138", -- [10]
			"16227:4267:22931:12578", -- [11]
			"4321:7823:39175:15177", -- [12]
			"4321:7823:10583", -- [13]
			"16227:4267:33253:3841:17555:17554", -- [14]
			"16227:4267:33253:3841:17555", -- [15]
			"16227:4267:22931", -- [16]
			"16227:4267:22935", -- [17]
			"4321:40358", -- [18]
			"16227:4267:34374", -- [19]
			"16227:4267:33253", -- [20]
			"39210:34378", -- [21]
			"39210:35136:35137", -- [22]
			"39210:35136", -- [23]
			"39210:35136:6706:35138", -- [24]
			"39210:35136:6706:35481", -- [25]
			"39210:35136:6706:35478", -- [26]
			"39210:35136:6706:35556", -- [27]
			"39210:35136:6706:35562", -- [28]
			"4321:7823:39175", -- [29]
			"16227:4267:33253:3841:3838:40552:40553", -- [30]
			"16227:4267:33253:3841:3838:40552", -- [31]
			"4321:40358:40768", -- [32]
			"4321:7823:40827", -- [33]
			"4321:7823:41214", -- [34]
			"39210:35136:35137:41240", -- [35]
			"16227:4267:22935:43549:50084", -- [36]
			"16227:4267:22935:43549:50084:53783", -- [37]
			"16227:4267:22935:43549:50084:41861", -- [38]
			"39210:35136:6706:35481:40966", -- [39]
			"4321:40358:40367:41580", -- [40]
			"16227:4267:22931:43073", -- [41]
			"16227:4267:22931:43079", -- [42]
			"16227:4267:22935:43549", -- [43]
			"16227:4267:33253:3841:17555:43991", -- [44]
			"16227:4267:22935:43549:50084:54393", -- [45]
			--["name"] = "Northwatch Hold, Southern Barrens",
			["m"] = 199,
			["f"] = 0,
			["direct"] = "4321:16227:39210:39211",
			["coord"] = 2849601694,
		},
		[35562] = {
			"6706:34378:4267:33253:3841", -- [1]
			"6706:34378:4267:33253:3841:3838", -- [2]
			"6706:34378:4267", -- [3]
			"35481:40966:41383:41580:40367", -- [4]
			"6706:35136:39210:39212:4321", -- [5]
			"6706:4407", -- [6]
			"35481:40966:41383:15177:39175:7823", -- [7]
			"35481:40966:41383", -- [8]
			"6706:34378:4267:33253:3841:10897", -- [9]
			"6706:34378:4267:22931:12578:11138", -- [10]
			"6706:34378:4267:22931:12578", -- [11]
			"35481:40966:41383:15177", -- [12]
			"35481:40966:41383:15177:39175:10583", -- [13]
			"6706:35136:39210:16227", -- [14]
			"6706:34378:4267:33253:3841:17555:17554", -- [15]
			"6706:34378:4267:33253:3841:17555", -- [16]
			"6706:34378:4267:22931", -- [17]
			"6706:34378:4267:22935", -- [18]
			"35481:40966:41383:41580:40367:40358", -- [19]
			"6706:34378:4267:34374", -- [20]
			"6706:34378:4267:33253", -- [21]
			"6706:34378", -- [22]
			"6706:35137", -- [23]
			"6706:35136", -- [24]
			"6706:35138", -- [25]
			"35481:40966:41383:15177:39175", -- [26]
			"6706:35136:39210", -- [27]
			"6706:35136:39210:39212", -- [28]
			"6706:35136:39210:39211", -- [29]
			"6706:34378:4267:33253:3841:3838:40552:40553", -- [30]
			"6706:34378:4267:33253:3841:3838:40552", -- [31]
			"35481:40966:41383:41580:40367:40768", -- [32]
			"35481:40966:41383:15177:48274:48275:40827", -- [33]
			"35481:40966:41383:15177:39175:7823:41214", -- [34]
			"6706:35138:41240", -- [35]
			"6706:34378:4267:22935:43549:50084", -- [36]
			"6706:34378:4267:22935:43549:50084:53783", -- [37]
			"6706:34378:4267:22935:43549:50084:41861", -- [38]
			"35481:40966", -- [39]
			"35481:40966:41383:41580", -- [40]
			"6706:34378:4267:22931:43073", -- [41]
			"6706:34378:4267:22931:43079", -- [42]
			"6706:34378:4267:22935:43549", -- [43]
			"6706:34378:4267:33253:3841:17555:43991", -- [44]
			"6706:34378:4267:22935:43549:50084:54393", -- [45]
			--["name"] = "Ethel Rethor, Desolace",
			["m"] = 66,
			["f"] = 0,
			["direct"] = "6706:35481:35478:35556",
			["coord"] = 1676035340,
		},
		[41240] = {
			"4407:3841", -- [1]
			"4407:3841:3838", -- [2]
			"35137:34378:4267", -- [3]
			"35137:6706:35481:40966:41383:41580:40367", -- [4]
			"35137:35136:39210:39212:4321", -- [5]
			"35137:6706", -- [6]
			"35137:35136:39210:39211:40358:40768:7823", -- [7]
			"35137:6706:35481:40966:41383", -- [8]
			"4407:3841:10897", -- [9]
			"4407:33253:12578:11138", -- [10]
			"4407:33253:12578", -- [11]
			"35137:6706:35481:40966:41383:15177", -- [12]
			"35137:6706:35481:40966:41383:15177:39175:10583", -- [13]
			"35137:35136:39210:16227", -- [14]
			"4407:3841:17555:17554", -- [15]
			"4407:3841:17555", -- [16]
			"35137:34378:4267:22931", -- [17]
			"35137:34378:4267:22935", -- [18]
			"35137:35136:39210:39211:40358", -- [19]
			"4407:34374", -- [20]
			"4407:33253", -- [21]
			"35137:34378", -- [22]
			"35137:35136", -- [23]
			"35137:6706:35481", -- [24]
			"35137:6706:35478", -- [25]
			"35137:6706:35556", -- [26]
			"35137:6706:35562", -- [27]
			"35137:6706:35481:40966:41383:15177:39175", -- [28]
			"35137:35136:39210", -- [29]
			"35137:35136:39210:39212", -- [30]
			"35137:35136:39210:39211", -- [31]
			"4407:3841:3838:40552:40553", -- [32]
			"4407:3841:3838:40552", -- [33]
			"35137:35136:39210:39211:40358:40768", -- [34]
			"35137:35136:39210:39211:40358:40768:7823:40827", -- [35]
			"35137:35136:39210:39211:40358:40768:7823:41214", -- [36]
			"35137:34378:4267:22935:43549:50084", -- [37]
			"35137:34378:4267:22935:43549:50084:53783", -- [38]
			"35137:34378:4267:22935:43549:50084:41861", -- [39]
			"35137:6706:35481:40966", -- [40]
			"35137:6706:35481:40966:41383:41580", -- [41]
			"35137:34378:4267:22931:43073", -- [42]
			"35137:34378:4267:22931:43079", -- [43]
			"35137:34378:4267:22935:43549", -- [44]
			"4407:3841:17555:43991", -- [45]
			"35137:34378:4267:22935:43549:50084:54393", -- [46]
			--["name"] = "Mirkfallon Post, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "4407:35137:35138",
			["coord"] = 2087224264,
		},
		[43073] = {
			"12578:3841", -- [1]
			"12578:3841:3838", -- [2]
			"22931:4267", -- [3]
			"22931:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"22931:4267:16227:4321", -- [5]
			"43079:33253:4407", -- [6]
			"22931:4267:34378:6706", -- [7]
			"22931:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"22931:4267:34378:6706:35481:40966:41383", -- [9]
			"12578:10897", -- [10]
			"12578:11138", -- [11]
			"22931:4267:34378:6706:35481:40966:41383:15177", -- [12]
			"22931:4267:34378:39210:39211:40358:40768:7823:10583", -- [13]
			"22931:4267:16227", -- [14]
			"12578:3841:17555:17554", -- [15]
			"12578:3841:17555", -- [16]
			"22931:22935", -- [17]
			"22931:4267:34378:39210:39211:40358", -- [18]
			"43079:33253:34374", -- [19]
			"43079:33253", -- [20]
			"22931:4267:34378", -- [21]
			"22931:4267:34378:35137", -- [22]
			"22931:4267:34378:35136", -- [23]
			"43079:33253:4407:35138", -- [24]
			"22931:4267:34378:6706:35481", -- [25]
			"22931:4267:34378:6706:35478", -- [26]
			"22931:4267:34378:6706:35556", -- [27]
			"22931:4267:34378:6706:35562", -- [28]
			"22931:4267:34378:6706:35481:40966:41383:15177:39175", -- [29]
			"22931:4267:34378:39210", -- [30]
			"22931:4267:34378:39210:39212", -- [31]
			"22931:4267:34378:39210:39211", -- [32]
			"12578:3841:3838:40552:40553", -- [33]
			"12578:3841:3838:40552", -- [34]
			"22931:4267:34378:39210:39211:40358:40768", -- [35]
			"22931:4267:34378:39210:39211:40358:40768:7823:40827", -- [36]
			"22931:4267:34378:39210:39211:40358:40768:7823:41214", -- [37]
			"22931:4267:34378:35137:41240", -- [38]
			"12578:10897:41861:50084", -- [39]
			"12578:10897:41861:53783", -- [40]
			"12578:10897:41861", -- [41]
			"22931:4267:34378:6706:35481:40966", -- [42]
			"22931:4267:34378:6706:35481:40966:41383:41580", -- [43]
			"22931:22935:43549", -- [44]
			"12578:3841:17555:43991", -- [45]
			"12578:10897:41861:50084:54393", -- [46]
			--["name"] = "Whisperwind Grove, Felwood",
			["m"] = 77,
			["f"] = 0,
			["direct"] = "12578:22931:43079",
			["coord"] = 1872382313,
		},
		[35137] = {
			"34378:4267:33253:3841", -- [1]
			"34378:4267:33253:3841:3838", -- [2]
			"34378:4267", -- [3]
			"6706:35481:40966:41383:41580:40367", -- [4]
			"35136:39210:39212:4321", -- [5]
			"35136:39210:39211:40358:40768:7823", -- [6]
			"6706:35481:40966:41383", -- [7]
			"34378:4267:33253:3841:10897", -- [8]
			"34378:4267:22931:12578:11138", -- [9]
			"34378:4267:22931:12578", -- [10]
			"6706:35481:40966:41383:15177", -- [11]
			"6706:35481:40966:41383:15177:39175:10583", -- [12]
			"35136:39210:16227", -- [13]
			"34378:4267:33253:3841:17555:17554", -- [14]
			"34378:4267:33253:3841:17555", -- [15]
			"34378:4267:22931", -- [16]
			"34378:4267:22935", -- [17]
			"35136:39210:39211:40358", -- [18]
			"34378:4267:34374", -- [19]
			"34378:4267:33253", -- [20]
			"6706:35481", -- [21]
			"6706:35478", -- [22]
			"6706:35556", -- [23]
			"6706:35562", -- [24]
			"6706:35481:40966:41383:15177:39175", -- [25]
			"35136:39210", -- [26]
			"35136:39210:39212", -- [27]
			"35136:39210:39211", -- [28]
			"34378:4267:33253:3841:3838:40552:40553", -- [29]
			"34378:4267:33253:3841:3838:40552", -- [30]
			"35136:39210:39211:40358:40768", -- [31]
			"35136:39210:39211:40358:40768:7823:40827", -- [32]
			"35136:39210:39211:40358:40768:7823:41214", -- [33]
			"34378:4267:22935:43549:50084", -- [34]
			"34378:4267:22935:43549:50084:53783", -- [35]
			"34378:4267:22935:43549:50084:41861", -- [36]
			"6706:35481:40966", -- [37]
			"6706:35481:40966:41383:41580", -- [38]
			"34378:4267:22931:43073", -- [39]
			"34378:4267:22931:43079", -- [40]
			"34378:4267:22935:43549", -- [41]
			"34378:4267:33253:3841:17555:43991", -- [42]
			"34378:4267:22935:43549:50084:54393", -- [43]
			--["name"] = "Windshear Hold, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "4407:6706:34378:35136:35138:41240",
			["coord"] = 2525399807,
		},
		[43079] = {
			"33253:3841", -- [1]
			"33253:3841:3838", -- [2]
			"22931:4267", -- [3]
			"22931:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"22931:4267:16227:4321", -- [5]
			"33253:4407", -- [6]
			"22931:4267:34378:6706", -- [7]
			"22931:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"22931:4267:34378:6706:35481:40966:41383", -- [9]
			"43073:12578:10897", -- [10]
			"43073:12578:11138", -- [11]
			"43073:12578", -- [12]
			"22931:4267:34378:6706:35481:40966:41383:15177", -- [13]
			"22931:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"22931:4267:16227", -- [15]
			"33253:3841:17555:17554", -- [16]
			"33253:3841:17555", -- [17]
			"22931:22935", -- [18]
			"22931:4267:34378:39210:39211:40358", -- [19]
			"33253:34374", -- [20]
			"22931:4267:34378", -- [21]
			"22931:4267:34378:35137", -- [22]
			"22931:4267:34378:35136", -- [23]
			"33253:4407:35138", -- [24]
			"22931:4267:34378:6706:35481", -- [25]
			"22931:4267:34378:6706:35478", -- [26]
			"22931:4267:34378:6706:35556", -- [27]
			"22931:4267:34378:6706:35562", -- [28]
			"22931:4267:34378:6706:35481:40966:41383:15177:39175", -- [29]
			"22931:4267:34378:39210", -- [30]
			"22931:4267:34378:39210:39212", -- [31]
			"22931:4267:34378:39210:39211", -- [32]
			"33253:3841:3838:40552:40553", -- [33]
			"33253:3841:3838:40552", -- [34]
			"22931:4267:34378:39210:39211:40358:40768", -- [35]
			"22931:4267:34378:39210:39211:40358:40768:7823:40827", -- [36]
			"22931:4267:34378:39210:39211:40358:40768:7823:41214", -- [37]
			"33253:4407:41240", -- [38]
			"22931:22935:43549:50084", -- [39]
			"22931:22935:43549:50084:53783", -- [40]
			"43073:12578:10897:41861", -- [41]
			"22931:4267:34378:6706:35481:40966", -- [42]
			"22931:4267:34378:6706:35481:40966:41383:41580", -- [43]
			"22931:22935:43549", -- [44]
			"33253:3841:17555:43991", -- [45]
			"22931:22935:43549:50084:54393", -- [46]
			--["name"] = "Wildheart Point, Felwood",
			["m"] = 77,
			["f"] = 0,
			["direct"] = "22931:33253:43073",
			["coord"] = 1902288499,
		},
		[33253] = {
			"3841:3838", -- [1]
			"4267:34378:6706:35481:40966:41383:41580:40367", -- [2]
			"4267:16227:4321", -- [3]
			"4267:34378:6706", -- [4]
			"4267:34378:39210:39211:40358:40768:7823", -- [5]
			"4267:34378:6706:35481:40966:41383", -- [6]
			"3841:10897", -- [7]
			"12578:11138", -- [8]
			"4267:34378:6706:35481:40966:41383:15177", -- [9]
			"4267:34378:39210:39211:40358:40768:7823:10583", -- [10]
			"4267:16227", -- [11]
			"3841:17555:17554", -- [12]
			"3841:17555", -- [13]
			"22931:22935", -- [14]
			"4267:34378:39210:39211:40358", -- [15]
			"4267:34378", -- [16]
			"4267:34378:35137", -- [17]
			"4267:34378:35136", -- [18]
			"4407:35138", -- [19]
			"4267:34378:6706:35481", -- [20]
			"4267:34378:6706:35478", -- [21]
			"4267:34378:6706:35556", -- [22]
			"4267:34378:6706:35562", -- [23]
			"4267:34378:6706:35481:40966:41383:15177:39175", -- [24]
			"4267:34378:39210", -- [25]
			"4267:34378:39210:39212", -- [26]
			"4267:34378:39210:39211", -- [27]
			"3841:3838:40552:40553", -- [28]
			"3841:3838:40552", -- [29]
			"4267:34378:39210:39211:40358:40768", -- [30]
			"4267:34378:39210:39211:40358:40768:7823:40827", -- [31]
			"4267:34378:39210:39211:40358:40768:7823:41214", -- [32]
			"4407:41240", -- [33]
			"22931:22935:43549:50084", -- [34]
			"22931:22935:43549:50084:53783", -- [35]
			"3841:10897:41861", -- [36]
			"4267:34378:6706:35481:40966", -- [37]
			"4267:34378:6706:35481:40966:41383:41580", -- [38]
			"43079:43073", -- [39]
			"22931:22935:43549", -- [40]
			"3841:17555:43991", -- [41]
			"22931:22935:43549:50084:54393", -- [42]
			--["name"] = "Grove of the Ancients, Darkshore",
			["m"] = 62,
			["f"] = 0,
			["direct"] = "3841:4267:4407:12578:22931:34374:43079",
			["coord"] = 1906098474,
		},
		[11138] = {
			"10897:3841", -- [1]
			"10897:3841:3838", -- [2]
			"12578:33253:4267", -- [3]
			"12578:33253:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"12578:33253:4267:16227:4321", -- [5]
			"12578:33253:4407", -- [6]
			"12578:33253:4267:34378:6706", -- [7]
			"12578:33253:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"12578:33253:4267:34378:6706:35481:40966:41383", -- [9]
			"12578:33253:4267:34378:6706:35481:40966:41383:15177", -- [10]
			"12578:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [11]
			"12578:33253:4267:16227", -- [12]
			"10897:3841:17555:17554", -- [13]
			"10897:3841:17555", -- [14]
			"12578:22931", -- [15]
			"41861:50084:43549:22935", -- [16]
			"12578:33253:4267:34378:39210:39211:40358", -- [17]
			"12578:33253:34374", -- [18]
			"12578:33253", -- [19]
			"12578:33253:4267:34378", -- [20]
			"12578:33253:4267:34378:35137", -- [21]
			"12578:33253:4267:34378:35136", -- [22]
			"12578:33253:4407:35138", -- [23]
			"12578:33253:4267:34378:6706:35481", -- [24]
			"12578:33253:4267:34378:6706:35478", -- [25]
			"12578:33253:4267:34378:6706:35556", -- [26]
			"12578:33253:4267:34378:6706:35562", -- [27]
			"12578:33253:4267:34378:6706:35481:40966:41383:15177:39175", -- [28]
			"12578:33253:4267:34378:39210", -- [29]
			"12578:33253:4267:34378:39210:39212", -- [30]
			"12578:33253:4267:34378:39210:39211", -- [31]
			"10897:3841:3838:40552:40553", -- [32]
			"10897:3841:3838:40552", -- [33]
			"12578:33253:4267:34378:39210:39211:40358:40768", -- [34]
			"12578:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [35]
			"12578:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [36]
			"12578:33253:4407:41240", -- [37]
			"41861:50084", -- [38]
			"41861:53783", -- [39]
			"12578:33253:4267:34378:6706:35481:40966", -- [40]
			"12578:33253:4267:34378:6706:35481:40966:41383:41580", -- [41]
			"12578:43073", -- [42]
			"12578:43073:43079", -- [43]
			"41861:50084:43549", -- [44]
			"10897:3841:17555:43991", -- [45]
			"41861:50084:54393", -- [46]
			--["name"] = "Everlook, Winterspring",
			["m"] = 83,
			["coord"] = 2619374768,
			["direct"] = "10897:12578:41861",
			["f"] = 0,
		},
		[50084] = {
			"41861:10897:3841", -- [1]
			"41861:10897:3841:3838", -- [2]
			"43549:22935:4267", -- [3]
			"43549:22935:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"43549:22935:4267:16227:4321", -- [5]
			"43549:22935:4267:34378:4407", -- [6]
			"43549:22935:4267:34378:6706", -- [7]
			"43549:22935:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"43549:22935:4267:34378:6706:35481:40966:41383", -- [9]
			"41861:10897", -- [10]
			"41861:11138", -- [11]
			"41861:10897:12578", -- [12]
			"43549:22935:4267:34378:6706:35481:40966:41383:15177", -- [13]
			"43549:22935:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"43549:22935:4267:16227", -- [15]
			"41861:10897:3841:17555:17554", -- [16]
			"41861:10897:3841:17555", -- [17]
			"43549:22935:22931", -- [18]
			"43549:22935", -- [19]
			"43549:22935:4267:34378:39210:39211:40358", -- [20]
			"43549:22935:4267:34374", -- [21]
			"43549:22935:22931:33253", -- [22]
			"43549:22935:4267:34378", -- [23]
			"43549:22935:4267:34378:35137", -- [24]
			"43549:22935:4267:34378:35136", -- [25]
			"43549:22935:4267:34378:35137:41240:35138", -- [26]
			"43549:22935:4267:34378:6706:35481", -- [27]
			"43549:22935:4267:34378:6706:35478", -- [28]
			"43549:22935:4267:34378:6706:35556", -- [29]
			"43549:22935:4267:34378:6706:35562", -- [30]
			"43549:22935:4267:34378:6706:35481:40966:41383:15177:39175", -- [31]
			"43549:22935:4267:34378:39210", -- [32]
			"43549:22935:4267:34378:39210:39212", -- [33]
			"43549:22935:4267:34378:39210:39211", -- [34]
			"41861:10897:3841:3838:40552:40553", -- [35]
			"41861:10897:3841:3838:40552", -- [36]
			"43549:22935:4267:34378:39210:39211:40358:40768", -- [37]
			"43549:22935:4267:34378:39210:39211:40358:40768:7823:40827", -- [38]
			"43549:22935:4267:34378:39210:39211:40358:40768:7823:41214", -- [39]
			"43549:22935:4267:34378:35137:41240", -- [40]
			"43549:22935:4267:34378:6706:35481:40966", -- [41]
			"43549:22935:4267:34378:6706:35481:40966:41383:41580", -- [42]
			"41861:10897:12578:43073", -- [43]
			"43549:22935:22931:43079", -- [44]
			"41861:10897:3841:17555:43991", -- [45]
			--["name"] = "Shrine of Aviana, Hyjal",
			["m"] = 198,
			["coord"] = 1767271736,
			["direct"] = "53783:41861:43549:54393",
			["f"] = 0,
		},
		[7823] = {
			"40768:40358:39211:39210:34378:4267:33253:3841", -- [1]
			"40768:40358:39211:39210:34378:4267:33253:3841:3838", -- [2]
			"40768:40358:39211:39210:34378:4267", -- [3]
			"40768:40358:39211:39210:35136:4407", -- [4]
			"40768:40358:39211:39210:35136:6706", -- [5]
			"39175:15177:41383", -- [6]
			"40768:40358:39211:39210:34378:4267:33253:3841:10897", -- [7]
			"40768:40358:39211:39210:34378:4267:22931:12578:11138", -- [8]
			"40768:40358:39211:39210:34378:4267:22931:12578", -- [9]
			"40768:40358:39211:39210:34378:4267:33253:3841:17555:17554", -- [10]
			"40768:40358:39211:39210:34378:4267:33253:3841:17555", -- [11]
			"40768:40358:39211:39210:34378:4267:22931", -- [12]
			"40768:40358:39211:39210:34378:4267:22935", -- [13]
			"40768:40358", -- [14]
			"40768:40358:39211:39210:34378:4267:34374", -- [15]
			"40768:40358:39211:39210:34378:4267:33253", -- [16]
			"40768:40358:39211:39210:34378", -- [17]
			"40768:40358:39211:39210:35136:35137", -- [18]
			"40768:40358:39211:39210:35136", -- [19]
			"40768:40358:39211:39210:35136:6706:35138", -- [20]
			"39175:15177:41383:40966:35481", -- [21]
			"39175:15177:41383:40966:35481:35478", -- [22]
			"40768:40358:39211:39210:35136:6706:35556", -- [23]
			"40768:40358:39211:39210:35136:6706:35562", -- [24]
			"40768:40358:39211:39210", -- [25]
			"4321:39212", -- [26]
			"40768:40358:39211", -- [27]
			"40768:40358:39211:39210:34378:4267:33253:3841:3838:40552:40553", -- [28]
			"40768:40358:39211:39210:34378:4267:33253:3841:3838:40552", -- [29]
			"40768:40358:39211:39210:35136:35137:41240", -- [30]
			"40768:40358:39211:39210:34378:4267:22935:43549:50084", -- [31]
			"40768:40358:39211:39210:34378:4267:22935:43549:50084:53783", -- [32]
			"40768:40358:39211:39210:34378:4267:22935:43549:50084:41861", -- [33]
			"39175:15177:41383:40966", -- [34]
			"40367:41580", -- [35]
			"40768:40358:39211:39210:34378:4267:22931:43073", -- [36]
			"40768:40358:39211:39210:34378:4267:22931:43079", -- [37]
			"40768:40358:39211:39210:34378:4267:22935:43549", -- [38]
			"40768:40358:39211:39210:34378:4267:33253:3841:17555:43991", -- [39]
			"40768:40358:39211:39210:34378:4267:22935:43549:50084:54393", -- [40]
			--["name"] = "Gadgetzan, Tanaris",
			["m"] = 71,
			["f"] = 0,
			["direct"] = "40367:4321:15177:10583:16227:39175:40768:40827:41214",
			["coord"] = 2206681944,
		},
		[40827] = {
			"7823:40768:40358:39211:39210:34378:4267:33253:3841", -- [1]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838", -- [2]
			"7823:40768:40358:39211:39210:34378:4267", -- [3]
			"7823:40367", -- [4]
			"7823:4321", -- [5]
			"7823:40768:40358:39211:39210:35136:4407", -- [6]
			"7823:40768:40358:39211:39210:35136:6706", -- [7]
			"48275:48274:15177:41383", -- [8]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:10897", -- [9]
			"7823:40768:40358:39211:39210:34378:4267:22931:12578:11138", -- [10]
			"7823:40768:40358:39211:39210:34378:4267:22931:12578", -- [11]
			"48275:48274:15177", -- [12]
			"7823:10583", -- [13]
			"7823:16227", -- [14]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:17555:17554", -- [15]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:17555", -- [16]
			"7823:40768:40358:39211:39210:34378:4267:22931", -- [17]
			"7823:40768:40358:39211:39210:34378:4267:22935", -- [18]
			"7823:40768:40358", -- [19]
			"7823:40768:40358:39211:39210:34378:4267:34374", -- [20]
			"7823:40768:40358:39211:39210:34378:4267:33253", -- [21]
			"7823:40768:40358:39211:39210:34378", -- [22]
			"7823:40768:40358:39211:39210:35136:35137", -- [23]
			"7823:40768:40358:39211:39210:35136", -- [24]
			"48275:48274:15177:41383:35138", -- [25]
			"48275:48274:15177:41383:40966:35481", -- [26]
			"48275:48274:15177:41383:40966:35481:35478", -- [27]
			"7823:40768:40358:39211:39210:35136:6706:35556", -- [28]
			"48275:48274:15177:41383:40966:35481:35562", -- [29]
			"7823:39175", -- [30]
			"7823:40768:40358:39211:39210", -- [31]
			"7823:4321:39212", -- [32]
			"7823:40768:40358:39211", -- [33]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552:40553", -- [34]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552", -- [35]
			"7823:40768", -- [36]
			"7823:40768:40358:39211:39210:35136:35137:41240", -- [37]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084", -- [38]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:53783", -- [39]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:41861", -- [40]
			"48275:48274:15177:41383:40966", -- [41]
			"7823:40367:41580", -- [42]
			"7823:40768:40358:39211:39210:34378:4267:22931:43073", -- [43]
			"7823:40768:40358:39211:39210:34378:4267:22931:43079", -- [44]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549", -- [45]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:17555:43991", -- [46]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:54393", -- [47]
			--["name"] = "Gunstan's Dig, Tanaris",
			["m"] = 71,
			["f"] = 0,
			["direct"] = "7823:41214",
			["coord"] = 1719977559,
		},
		[40768] = {
			"40358:39211:39210:34378:4267:33253:3841", -- [1]
			"40358:39211:39210:34378:4267:33253:3841:3838", -- [2]
			"40358:39211:39210:34378:4267", -- [3]
			"40358:4321", -- [4]
			"40358:39211:39210:35136:4407", -- [5]
			"40358:39211:39210:35136:6706", -- [6]
			"40367:41383", -- [7]
			"40358:39211:39210:34378:4267:33253:3841:10897", -- [8]
			"40358:39211:39210:34378:4267:22931:12578:11138", -- [9]
			"40358:39211:39210:34378:4267:22931:12578", -- [10]
			"7823:39175:15177", -- [11]
			"7823:10583", -- [12]
			"40358:4321:16227", -- [13]
			"40358:39211:39210:34378:4267:33253:3841:17555:17554", -- [14]
			"40358:39211:39210:34378:4267:33253:3841:17555", -- [15]
			"40358:39211:39210:34378:4267:22931", -- [16]
			"40358:39211:39210:34378:4267:22935", -- [17]
			"40358:39211:39210:34378:4267:34374", -- [18]
			"40358:39211:39210:34378:4267:33253", -- [19]
			"40358:39211:39210:34378", -- [20]
			"40358:39211:39210:35136:35137", -- [21]
			"40358:39211:39210:35136", -- [22]
			"40358:39211:39210:35136:6706:35138", -- [23]
			"40367:41383:40966:35481", -- [24]
			"40358:39211:39210:35136:6706:35478", -- [25]
			"40358:39211:39210:35136:6706:35556", -- [26]
			"40358:39211:39210:35136:6706:35562", -- [27]
			"7823:39175", -- [28]
			"40358:39211:39210", -- [29]
			"40358:4321:39212", -- [30]
			"40358:39211", -- [31]
			"40358:39211:39210:34378:4267:33253:3841:3838:40552:40553", -- [32]
			"40358:39211:39210:34378:4267:33253:3841:3838:40552", -- [33]
			"7823:40827", -- [34]
			"7823:41214", -- [35]
			"40358:39211:39210:35136:35137:41240", -- [36]
			"40358:39211:39210:34378:4267:22935:43549:50084", -- [37]
			"40358:39211:39210:34378:4267:22935:43549:50084:53783", -- [38]
			"40358:39211:39210:34378:4267:22935:43549:50084:41861", -- [39]
			"40367:41383:40966", -- [40]
			"40367:41580", -- [41]
			"40358:39211:39210:34378:4267:22931:43073", -- [42]
			"40358:39211:39210:34378:4267:22931:43079", -- [43]
			"40358:39211:39210:34378:4267:22935:43549", -- [44]
			"40358:39211:39210:34378:4267:33253:3841:17555:43991", -- [45]
			"40358:39211:39210:34378:4267:22935:43549:50084:54393", -- [46]
			--["name"] = "Fizzle & Pozzik's Speedbarge, Thousand Needles",
			["m"] = 64,
			["f"] = 0,
			["direct"] = "40367:7823:40358",
			["coord"] = 3398547493,
		},
		[17554] = {
			"17555:3841", -- [1]
			"17555:3838", -- [2]
			"17555:3841:33253:4267", -- [3]
			"17555:3841:33253:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"17555:3841:33253:4267:16227:4321", -- [5]
			"17555:3841:33253:4407", -- [6]
			"17555:3841:33253:4267:34378:6706", -- [7]
			"17555:3841:33253:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"17555:3841:33253:4267:34378:6706:35481:40966:41383", -- [9]
			"17555:3841:10897", -- [10]
			"17555:3841:12578:11138", -- [11]
			"17555:3841:12578", -- [12]
			"17555:3841:33253:4267:34378:6706:35481:40966:41383:15177", -- [13]
			"17555:3841:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"17555:3841:33253:4267:16227", -- [15]
			"17555:3841:33253:22931", -- [16]
			"17555:3841:33253:22931:22935", -- [17]
			"17555:3841:33253:4267:34378:39210:39211:40358", -- [18]
			"17555:3841:33253:34374", -- [19]
			"17555:3841:33253", -- [20]
			"17555:3841:33253:4267:34378", -- [21]
			"17555:3841:33253:4267:34378:35137", -- [22]
			"17555:3841:33253:4267:34378:35136", -- [23]
			"17555:3841:33253:4407:35138", -- [24]
			"17555:3841:33253:4267:34378:6706:35481", -- [25]
			"17555:3841:33253:4267:34378:6706:35478", -- [26]
			"17555:3841:33253:4267:34378:6706:35556", -- [27]
			"17555:3841:33253:4267:34378:6706:35562", -- [28]
			"17555:3841:33253:4267:34378:6706:35481:40966:41383:15177:39175", -- [29]
			"17555:3841:33253:4267:34378:39210", -- [30]
			"17555:3841:33253:4267:34378:39210:39212", -- [31]
			"17555:3841:33253:4267:34378:39210:39211", -- [32]
			"17555:3838:40552:40553", -- [33]
			"17555:3838:40552", -- [34]
			"17555:3841:33253:4267:34378:39210:39211:40358:40768", -- [35]
			"17555:3841:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [36]
			"17555:3841:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [37]
			"17555:3841:33253:4407:41240", -- [38]
			"17555:3841:10897:41861:50084", -- [39]
			"17555:3841:10897:41861:53783", -- [40]
			"17555:3841:10897:41861", -- [41]
			"17555:3841:33253:4267:34378:6706:35481:40966", -- [42]
			"17555:3841:33253:4267:34378:6706:35481:40966:41383:41580", -- [43]
			"17555:3841:12578:43073", -- [44]
			"17555:3841:33253:43079", -- [45]
			"17555:3841:10897:41861:50084:43549", -- [46]
			"17555:43991", -- [47]
			"17555:3841:10897:41861:50084:54393", -- [48]
			--["name"] = "Blood Watch, Bloodmyst Isle",
			["m"] = 106,
			["f"] = 0,
			["direct"] = "17555",
			["coord"] = 2474412619,
		},
		[17555] = {
			"3841:33253:4267", -- [1]
			"3841:33253:4267:34378:6706:35481:40966:41383:41580:40367", -- [2]
			"3841:33253:4267:16227:4321", -- [3]
			"3841:33253:4407", -- [4]
			"3841:33253:4267:34378:6706", -- [5]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823", -- [6]
			"3841:33253:4267:34378:6706:35481:40966:41383", -- [7]
			"3841:10897", -- [8]
			"3841:12578:11138", -- [9]
			"3841:12578", -- [10]
			"3841:33253:4267:34378:6706:35481:40966:41383:15177", -- [11]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [12]
			"3841:33253:4267:16227", -- [13]
			"3841:33253:22931", -- [14]
			"3841:33253:22931:22935", -- [15]
			"3841:33253:4267:34378:39210:39211:40358", -- [16]
			"3841:33253:34374", -- [17]
			"3841:33253", -- [18]
			"3841:33253:4267:34378", -- [19]
			"3841:33253:4267:34378:35137", -- [20]
			"3841:33253:4267:34378:35136", -- [21]
			"3841:33253:4407:35138", -- [22]
			"3841:33253:4267:34378:6706:35481", -- [23]
			"3841:33253:4267:34378:6706:35478", -- [24]
			"3841:33253:4267:34378:6706:35556", -- [25]
			"3841:33253:4267:34378:6706:35562", -- [26]
			"3841:33253:4267:34378:6706:35481:40966:41383:15177:39175", -- [27]
			"3841:33253:4267:34378:39210", -- [28]
			"3841:33253:4267:34378:39210:39212", -- [29]
			"3841:33253:4267:34378:39210:39211", -- [30]
			"3838:40552:40553", -- [31]
			"3838:40552", -- [32]
			"3841:33253:4267:34378:39210:39211:40358:40768", -- [33]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [34]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [35]
			"3841:33253:4407:41240", -- [36]
			"3841:10897:41861:50084", -- [37]
			"3841:10897:41861:53783", -- [38]
			"3841:10897:41861", -- [39]
			"3841:33253:4267:34378:6706:35481:40966", -- [40]
			"3841:33253:4267:34378:6706:35481:40966:41383:41580", -- [41]
			"3841:12578:43073", -- [42]
			"3841:33253:43079", -- [43]
			"3841:10897:41861:50084:43549", -- [44]
			"3841:10897:41861:50084:54393", -- [45]
			--["name"] = "The Exodar",
			["m"] = 103,
			["f"] = 0,
			["direct"] = "3841:3838:17554:43991",
			["coord"] = 2335858098,
		},
		[35556] = {
			"6706:34378:4267:33253:3841", -- [1]
			"6706:34378:4267:33253:3841:3838", -- [2]
			"6706:34378:4267", -- [3]
			"35478:35481:40966:41383:41580:40367", -- [4]
			"6706:35136:39210:39212:4321", -- [5]
			"6706:4407", -- [6]
			"6706:35136:39210:39211:40358:40768:7823", -- [7]
			"35478:35481:40966:41383", -- [8]
			"6706:34378:4267:33253:3841:10897", -- [9]
			"6706:34378:4267:22931:12578:11138", -- [10]
			"6706:34378:4267:22931:12578", -- [11]
			"35478:35481:40966:41383:15177", -- [12]
			"35478:35481:40966:41383:15177:39175:10583", -- [13]
			"6706:35136:39210:16227", -- [14]
			"6706:34378:4267:33253:3841:17555:17554", -- [15]
			"6706:34378:4267:33253:3841:17555", -- [16]
			"6706:34378:4267:22931", -- [17]
			"6706:34378:4267:22935", -- [18]
			"6706:35136:39210:39211:40358", -- [19]
			"6706:34378:4267:34374", -- [20]
			"6706:34378:4267:33253", -- [21]
			"6706:34378", -- [22]
			"6706:35137", -- [23]
			"6706:35136", -- [24]
			"6706:35138", -- [25]
			"35478:35481", -- [26]
			"35478:35481:40966:41383:15177:39175", -- [27]
			"6706:35136:39210", -- [28]
			"6706:35136:39210:39212", -- [29]
			"6706:35136:39210:39211", -- [30]
			"6706:34378:4267:33253:3841:3838:40552:40553", -- [31]
			"6706:34378:4267:33253:3841:3838:40552", -- [32]
			"6706:35136:39210:39211:40358:40768", -- [33]
			"6706:35136:39210:39211:40358:40768:7823:40827", -- [34]
			"6706:35136:39210:39211:40358:40768:7823:41214", -- [35]
			"6706:35138:41240", -- [36]
			"6706:34378:4267:22935:43549:50084", -- [37]
			"6706:34378:4267:22935:43549:50084:53783", -- [38]
			"6706:34378:4267:22935:43549:50084:41861", -- [39]
			"35478:35481:40966", -- [40]
			"35478:35481:40966:41383:41580", -- [41]
			"6706:34378:4267:22931:43073", -- [42]
			"6706:34378:4267:22931:43079", -- [43]
			"6706:34378:4267:22935:43549", -- [44]
			"6706:34378:4267:33253:3841:17555:43991", -- [45]
			"6706:34378:4267:22935:43549:50084:54393", -- [46]
			--["name"] = "Thunk's Abode, Desolace",
			["m"] = 66,
			["coord"] = 3034666036,
			["direct"] = "6706:35478:35562",
			["f"] = 0,
		},
		[4407] = {
			"3841:3838", -- [1]
			"35481:40966:41383:41580:40367", -- [2]
			"35136:39210:39212:4321", -- [3]
			"35136:39210:39211:40358:40768:7823", -- [4]
			"35481:40966:41383", -- [5]
			"3841:10897", -- [6]
			"33253:12578:11138", -- [7]
			"33253:12578", -- [8]
			"35481:40966:41383:15177", -- [9]
			"35481:40966:41383:15177:39175:10583", -- [10]
			"35136:39210:16227", -- [11]
			"3841:17555:17554", -- [12]
			"3841:17555", -- [13]
			"34378:4267:22931", -- [14]
			"34378:4267:22935", -- [15]
			"35136:39210:39211:40358", -- [16]
			"6706:35556", -- [17]
			"6706:35562", -- [18]
			"35481:40966:41383:15177:39175", -- [19]
			"35136:39210", -- [20]
			"35136:39210:39212", -- [21]
			"35136:39210:39211", -- [22]
			"3841:3838:40552:40553", -- [23]
			"3841:3838:40552", -- [24]
			"35136:39210:39211:40358:40768", -- [25]
			"35136:39210:39211:40358:40768:7823:40827", -- [26]
			"35136:39210:39211:40358:40768:7823:41214", -- [27]
			"34378:4267:22935:43549:50084", -- [28]
			"34378:4267:22935:43549:50084:53783", -- [29]
			"34378:4267:22935:43549:50084:41861", -- [30]
			"35481:40966", -- [31]
			"35481:40966:41383:41580", -- [32]
			"33253:43079:43073", -- [33]
			"33253:43079", -- [34]
			"34378:4267:22935:43549", -- [35]
			"3841:17555:43991", -- [36]
			"34378:4267:22935:43549:50084:54393", -- [37]
			--["name"] = "Thal'darah Overlook, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "3841:4267:6706:34374:33253:34378:35137:35136:35138:35481:35478:41240",
			["coord"] = 1720996301,
		},
		[43991] = {
			"17555:3841", -- [1]
			"17555:3838", -- [2]
			"17555:3841:33253:4267", -- [3]
			"17555:3841:33253:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"17555:3841:33253:4267:16227:4321", -- [5]
			"17555:3841:33253:4407", -- [6]
			"17555:3841:33253:4267:34378:6706", -- [7]
			"17555:3841:33253:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"17555:3841:33253:4267:34378:6706:35481:40966:41383", -- [9]
			"17555:3841:10897", -- [10]
			"17555:3841:12578:11138", -- [11]
			"17555:3841:12578", -- [12]
			"17555:3841:33253:4267:34378:6706:35481:40966:41383:15177", -- [13]
			"17555:3841:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"17555:3841:33253:4267:16227", -- [15]
			"17555:17554", -- [16]
			"17555:3841:33253:22931", -- [17]
			"17555:3841:33253:22931:22935", -- [18]
			"17555:3841:33253:4267:34378:39210:39211:40358", -- [19]
			"17555:3841:33253:34374", -- [20]
			"17555:3841:33253", -- [21]
			"17555:3841:33253:4267:34378", -- [22]
			"17555:3841:33253:4267:34378:35137", -- [23]
			"17555:3841:33253:4267:34378:35136", -- [24]
			"17555:3841:33253:4407:35138", -- [25]
			"17555:3841:33253:4267:34378:6706:35481", -- [26]
			"17555:3841:33253:4267:34378:6706:35478", -- [27]
			"17555:3841:33253:4267:34378:6706:35556", -- [28]
			"17555:3841:33253:4267:34378:6706:35562", -- [29]
			"17555:3841:33253:4267:34378:6706:35481:40966:41383:15177:39175", -- [30]
			"17555:3841:33253:4267:34378:39210", -- [31]
			"17555:3841:33253:4267:34378:39210:39212", -- [32]
			"17555:3841:33253:4267:34378:39210:39211", -- [33]
			"17555:3838:40552:40553", -- [34]
			"17555:3838:40552", -- [35]
			"17555:3841:33253:4267:34378:39210:39211:40358:40768", -- [36]
			"17555:3841:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [37]
			"17555:3841:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [38]
			"17555:3841:33253:4407:41240", -- [39]
			"17555:3841:10897:41861:50084", -- [40]
			"17555:3841:10897:41861:53783", -- [41]
			"17555:3841:10897:41861", -- [42]
			"17555:3841:33253:4267:34378:6706:35481:40966", -- [43]
			"17555:3841:33253:4267:34378:6706:35481:40966:41383:41580", -- [44]
			"17555:3841:12578:43073", -- [45]
			"17555:3841:33253:43079", -- [46]
			"17555:3841:10897:41861:50084:43549", -- [47]
			"17555:3841:10897:41861:50084:54393", -- [48]
			--["name"] = "Azure Watch, Azuremyst Isle",
			["m"] = 97,
			["f"] = 0,
			["direct"] = "17555",
			["coord"] = 2131787270,
		},
		[35478] = {
			"4407:3841", -- [1]
			"4407:3841:3838", -- [2]
			"6706:34378:4267", -- [3]
			"35481:40966:41383:41580:40367", -- [4]
			"6706:35136:39210:39212:4321", -- [5]
			"35481:40966:41383:15177:39175:7823", -- [6]
			"35481:40966:41383", -- [7]
			"4407:3841:10897", -- [8]
			"6706:34378:4267:22931:12578:11138", -- [9]
			"6706:34378:4267:22931:12578", -- [10]
			"35481:40966:41383:15177", -- [11]
			"35481:40966:41383:15177:39175:10583", -- [12]
			"6706:35136:39210:16227", -- [13]
			"4407:3841:17555:17554", -- [14]
			"4407:3841:17555", -- [15]
			"6706:34378:4267:22931", -- [16]
			"6706:34378:4267:22935", -- [17]
			"35481:40966:41383:41580:40367:40358", -- [18]
			"6706:34378:4267:34374", -- [19]
			"6706:34378:4267:33253", -- [20]
			"6706:34378", -- [21]
			"6706:35137", -- [22]
			"6706:35136", -- [23]
			"6706:35138", -- [24]
			"35481:40966:41383:15177:39175", -- [25]
			"6706:35136:39210", -- [26]
			"6706:35136:39210:39212", -- [27]
			"6706:35136:39210:39211", -- [28]
			"4407:3841:3838:40552:40553", -- [29]
			"4407:3841:3838:40552", -- [30]
			"35481:40966:41383:41580:40367:40768", -- [31]
			"35481:40966:41383:15177:48274:48275:40827", -- [32]
			"35481:40966:41383:15177:39175:7823:41214", -- [33]
			"6706:35138:41240", -- [34]
			"6706:34378:4267:22935:43549:50084", -- [35]
			"6706:34378:4267:22935:43549:50084:53783", -- [36]
			"6706:34378:4267:22935:43549:50084:41861", -- [37]
			"35481:40966", -- [38]
			"35481:40966:41383:41580", -- [39]
			"6706:34378:4267:22931:43073", -- [40]
			"6706:34378:4267:22931:43079", -- [41]
			"6706:34378:4267:22935:43549", -- [42]
			"4407:3841:17555:43991", -- [43]
			"6706:34378:4267:22935:43549:50084:54393", -- [44]
			--["name"] = "Karnum's Glade, Desolace",
			["m"] = 66,
			["f"] = 0,
			["direct"] = "4407:6706:35481:35556:35562",
			["coord"] = 2479390534,
		},
		[43549] = {
			"50084:41861:10897:3841", -- [1]
			"50084:41861:10897:3841:3838", -- [2]
			"22935:4267", -- [3]
			"22935:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"22935:4267:16227:4321", -- [5]
			"22935:4267:34378:4407", -- [6]
			"22935:4267:34378:6706", -- [7]
			"22935:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"22935:4267:34378:6706:35481:40966:41383", -- [9]
			"50084:41861:10897", -- [10]
			"50084:41861:11138", -- [11]
			"50084:41861:10897:12578", -- [12]
			"22935:4267:34378:6706:35481:40966:41383:15177", -- [13]
			"22935:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"22935:4267:16227", -- [15]
			"50084:41861:10897:3841:17555:17554", -- [16]
			"50084:41861:10897:3841:17555", -- [17]
			"22935:22931", -- [18]
			"22935:4267:34378:39210:39211:40358", -- [19]
			"22935:4267:34374", -- [20]
			"22935:22931:33253", -- [21]
			"22935:4267:34378", -- [22]
			"22935:4267:34378:35137", -- [23]
			"22935:4267:34378:35136", -- [24]
			"22935:4267:34378:35137:41240:35138", -- [25]
			"22935:4267:34378:6706:35481", -- [26]
			"22935:4267:34378:6706:35478", -- [27]
			"22935:4267:34378:6706:35556", -- [28]
			"22935:4267:34378:6706:35562", -- [29]
			"22935:4267:34378:6706:35481:40966:41383:15177:39175", -- [30]
			"22935:4267:34378:39210", -- [31]
			"22935:4267:34378:39210:39212", -- [32]
			"22935:4267:34378:39210:39211", -- [33]
			"50084:41861:10897:3841:3838:40552:40553", -- [34]
			"50084:41861:10897:3841:3838:40552", -- [35]
			"22935:4267:34378:39210:39211:40358:40768", -- [36]
			"22935:4267:34378:39210:39211:40358:40768:7823:40827", -- [37]
			"22935:4267:34378:39210:39211:40358:40768:7823:41214", -- [38]
			"22935:4267:34378:35137:41240", -- [39]
			"50084:53783", -- [40]
			"50084:41861", -- [41]
			"22935:4267:34378:6706:35481:40966", -- [42]
			"22935:4267:34378:6706:35481:40966:41383:41580", -- [43]
			"22935:22931:43073", -- [44]
			"22935:22931:43079", -- [45]
			"50084:41861:10897:3841:17555:43991", -- [46]
			"50084:54393", -- [47]
			--["name"] = "Gates of Sothann, Hyjal",
			["m"] = 198,
			["coord"] = 3072770348,
			["direct"] = "22935:50084",
			["f"] = 0,
		},
		[15177] = {
			"41383:3841", -- [1]
			"41383:3841:3838", -- [2]
			"41383:6706:34378:4267", -- [3]
			"41383:41580:40367", -- [4]
			"39175:7823:4321", -- [5]
			"41383:35138:4407", -- [6]
			"41383:6706", -- [7]
			"41383:3841:10897", -- [8]
			"41383:6706:34378:4267:22931:12578:11138", -- [9]
			"41383:6706:34378:4267:22931:12578", -- [10]
			"39175:7823:16227", -- [11]
			"41383:3841:17555:17554", -- [12]
			"41383:3841:17555", -- [13]
			"41383:6706:34378:4267:22931", -- [14]
			"41383:6706:34378:4267:22935", -- [15]
			"39175:7823:40768:40358", -- [16]
			"41383:35138:4407:34374", -- [17]
			"41383:35138:4407:33253", -- [18]
			"41383:6706:34378", -- [19]
			"41383:6706:35137", -- [20]
			"41383:6706:35136", -- [21]
			"41383:35138", -- [22]
			"41383:40966:35481", -- [23]
			"41383:40966:35481:35478", -- [24]
			"41383:40966:35481:35478:35556", -- [25]
			"41383:40966:35481:35562", -- [26]
			"39175:7823:40768:40358:39211:39210", -- [27]
			"39175:7823:4321:39212", -- [28]
			"39175:7823:40768:40358:39211", -- [29]
			"41383:3841:3838:40552:40553", -- [30]
			"41383:3841:3838:40552", -- [31]
			"39175:7823:40768", -- [32]
			"48274:48275:40827", -- [33]
			"39175:7823:41214", -- [34]
			"41383:35138:41240", -- [35]
			"41383:6706:34378:4267:22935:43549:50084", -- [36]
			"41383:6706:34378:4267:22935:43549:50084:53783", -- [37]
			"41383:6706:34378:4267:22935:43549:50084:41861", -- [38]
			"41383:40966", -- [39]
			"41383:41580", -- [40]
			"41383:6706:34378:4267:22931:43073", -- [41]
			"41383:6706:34378:4267:22931:43079", -- [42]
			"41383:6706:34378:4267:22935:43549", -- [43]
			"41383:3841:17555:43991", -- [44]
			"41383:6706:34378:4267:22935:43549:50084:54393", -- [45]
			--["name"] = "Cenarion Hold, Silithus",
			["m"] = 81,
			["f"] = 0,
			["direct"] = "7823:41383:10583:39175",
			["coord"] = 2340246549,
		},
		[39211] = {
			"39210:34378:4267:33253:3841", -- [1]
			"39210:34378:4267:33253:3841:3838", -- [2]
			"39210:34378:4267", -- [3]
			"40358:40367", -- [4]
			"40358:4321", -- [5]
			"39210:35136:4407", -- [6]
			"39210:35136:6706", -- [7]
			"40358:40768:7823", -- [8]
			"40358:40367:41383", -- [9]
			"39210:34378:4267:33253:3841:10897", -- [10]
			"39210:34378:4267:22931:12578:11138", -- [11]
			"39210:34378:4267:22931:12578", -- [12]
			"40358:40768:7823:39175:15177", -- [13]
			"40358:40768:7823:10583", -- [14]
			"39212:16227", -- [15]
			"39210:34378:4267:33253:3841:17555:17554", -- [16]
			"39210:34378:4267:33253:3841:17555", -- [17]
			"39210:34378:4267:22931", -- [18]
			"39210:34378:4267:22935", -- [19]
			"39210:34378:4267:34374", -- [20]
			"39210:34378:4267:33253", -- [21]
			"39210:34378", -- [22]
			"39210:35136:35137", -- [23]
			"39210:35136", -- [24]
			"39210:35136:6706:35138", -- [25]
			"39210:35136:6706:35481", -- [26]
			"39210:35136:6706:35478", -- [27]
			"39210:35136:6706:35556", -- [28]
			"39210:35136:6706:35562", -- [29]
			"40358:40768:7823:39175", -- [30]
			"39210:34378:4267:33253:3841:3838:40552:40553", -- [31]
			"39210:34378:4267:33253:3841:3838:40552", -- [32]
			"40358:40768", -- [33]
			"40358:40768:7823:40827", -- [34]
			"40358:40768:7823:41214", -- [35]
			"39210:35136:35137:41240", -- [36]
			"39210:34378:4267:22935:43549:50084", -- [37]
			"39210:34378:4267:22935:43549:50084:53783", -- [38]
			"39210:34378:4267:22935:43549:50084:41861", -- [39]
			"40358:40367:41383:40966", -- [40]
			"40358:40367:41580", -- [41]
			"39210:34378:4267:22931:43073", -- [42]
			"39210:34378:4267:22931:43079", -- [43]
			"39210:34378:4267:22935:43549", -- [44]
			"39210:34378:4267:33253:3841:17555:43991", -- [45]
			"39210:34378:4267:22935:43549:50084:54393", -- [46]
			--["name"] = "Fort Triumph, Southern Barrens",
			["m"] = 199,
			["f"] = 0,
			["direct"] = "40358:39210:39212",
			["coord"] = 2111942053,
		},
		[6706] = {
			"34378:4267:33253:3841:3838", -- [1]
			"34378:4267", -- [2]
			"35481:40966:41383:41580:40367", -- [3]
			"35136:39210:39211:40358:40768:7823", -- [4]
			"34378:4267:33253:3841:10897", -- [5]
			"34378:4267:22931:12578:11138", -- [6]
			"34378:4267:22931:12578", -- [7]
			"35481:40966:41383:15177", -- [8]
			"35481:40966:41383:15177:39175:10583", -- [9]
			"35136:39210:16227", -- [10]
			"34378:4267:33253:3841:17555:17554", -- [11]
			"34378:4267:33253:3841:17555", -- [12]
			"34378:4267:22931", -- [13]
			"34378:4267:22935", -- [14]
			"35136:39210:39211:40358", -- [15]
			"34378:4267:34374", -- [16]
			"34378:4267:33253", -- [17]
			"35481:40966:41383:15177:39175", -- [18]
			"35136:39210", -- [19]
			"35136:39210:39212", -- [20]
			"35136:39210:39211", -- [21]
			"34378:4267:33253:3841:3838:40552:40553", -- [22]
			"34378:4267:33253:3841:3838:40552", -- [23]
			"35136:39210:39211:40358:40768", -- [24]
			"35136:39210:39211:40358:40768:7823:40827", -- [25]
			"35136:39210:39211:40358:40768:7823:41214", -- [26]
			"35138:41240", -- [27]
			"34378:4267:22935:43549:50084", -- [28]
			"34378:4267:22935:43549:50084:53783", -- [29]
			"34378:4267:22935:43549:50084:41861", -- [30]
			"35481:40966", -- [31]
			"35481:40966:41383:41580", -- [32]
			"34378:4267:22931:43073", -- [33]
			"34378:4267:22931:43079", -- [34]
			"34378:4267:22935:43549", -- [35]
			"34378:4267:33253:3841:17555:43991", -- [36]
			"34378:4267:22935:43549:50084:54393", -- [37]
			--["name"] = "Nijel's Point, Desolace",
			["m"] = 66,
			["f"] = 0,
			["direct"] = "3841:4321:4407:41383:34378:35137:35136:35138:35481:35478:35556:35562",
			["coord"] = 2776963794,
		},
		[41861] = {
			"10897:3841", -- [1]
			"10897:3841:3838", -- [2]
			"50084:43549:22935:4267", -- [3]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"50084:43549:22935:4267:16227:4321", -- [5]
			"50084:43549:22935:4267:34378:4407", -- [6]
			"50084:43549:22935:4267:34378:6706", -- [7]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383", -- [9]
			"10897:12578", -- [10]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177", -- [11]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:10583", -- [12]
			"50084:43549:22935:4267:16227", -- [13]
			"10897:3841:17555:17554", -- [14]
			"10897:3841:17555", -- [15]
			"50084:43549:22935:22931", -- [16]
			"50084:43549:22935", -- [17]
			"50084:43549:22935:4267:34378:39210:39211:40358", -- [18]
			"50084:43549:22935:4267:34374", -- [19]
			"10897:3841:33253", -- [20]
			"50084:43549:22935:4267:34378", -- [21]
			"50084:43549:22935:4267:34378:35137", -- [22]
			"50084:43549:22935:4267:34378:35136", -- [23]
			"50084:43549:22935:4267:34378:35137:41240:35138", -- [24]
			"50084:43549:22935:4267:34378:6706:35481", -- [25]
			"50084:43549:22935:4267:34378:6706:35478", -- [26]
			"50084:43549:22935:4267:34378:6706:35556", -- [27]
			"50084:43549:22935:4267:34378:6706:35562", -- [28]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:39175", -- [29]
			"50084:43549:22935:4267:34378:39210", -- [30]
			"50084:43549:22935:4267:34378:39210:39212", -- [31]
			"50084:43549:22935:4267:34378:39210:39211", -- [32]
			"10897:3841:3838:40552:40553", -- [33]
			"10897:3841:3838:40552", -- [34]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768", -- [35]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:40827", -- [36]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:41214", -- [37]
			"50084:43549:22935:4267:34378:35137:41240", -- [38]
			"50084:43549:22935:4267:34378:6706:35481:40966", -- [39]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:41580", -- [40]
			"10897:12578:43073", -- [41]
			"10897:12578:43073:43079", -- [42]
			"50084:43549", -- [43]
			"10897:3841:17555:43991", -- [44]
			"50084:54393", -- [45]
			--["name"] = "Nordrassil, Hyjal",
			["m"] = 198,
			["coord"] = 2671195983,
			["direct"] = "10897:11138:50084:53783",
			["f"] = 0,
		},
		[41214] = {
			"7823:40768:40358:39211:39210:34378:4267:33253:3841", -- [1]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838", -- [2]
			"7823:40768:40358:39211:39210:34378:4267", -- [3]
			"7823:40367", -- [4]
			"7823:4321", -- [5]
			"7823:40768:40358:39211:39210:35136:4407", -- [6]
			"7823:40768:40358:39211:39210:35136:6706", -- [7]
			"7823:39175:15177:41383", -- [8]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:10897", -- [9]
			"7823:40768:40358:39211:39210:34378:4267:22931:12578:11138", -- [10]
			"7823:40768:40358:39211:39210:34378:4267:22931:12578", -- [11]
			"7823:39175:15177", -- [12]
			"7823:10583", -- [13]
			"7823:16227", -- [14]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:17555:17554", -- [15]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:17555", -- [16]
			"7823:40768:40358:39211:39210:34378:4267:22931", -- [17]
			"7823:40768:40358:39211:39210:34378:4267:22935", -- [18]
			"7823:40768:40358", -- [19]
			"7823:40768:40358:39211:39210:34378:4267:34374", -- [20]
			"7823:40768:40358:39211:39210:34378:4267:33253", -- [21]
			"7823:40768:40358:39211:39210:34378", -- [22]
			"7823:40768:40358:39211:39210:35136:35137", -- [23]
			"7823:40768:40358:39211:39210:35136", -- [24]
			"7823:40768:40358:39211:39210:35136:6706:35138", -- [25]
			"7823:39175:15177:41383:40966:35481", -- [26]
			"7823:39175:15177:41383:40966:35481:35478", -- [27]
			"7823:40768:40358:39211:39210:35136:6706:35556", -- [28]
			"7823:40768:40358:39211:39210:35136:6706:35562", -- [29]
			"7823:39175", -- [30]
			"7823:40768:40358:39211:39210", -- [31]
			"7823:4321:39212", -- [32]
			"7823:40768:40358:39211", -- [33]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552:40553", -- [34]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552", -- [35]
			"7823:40768", -- [36]
			"7823:40768:40358:39211:39210:35136:35137:41240", -- [37]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084", -- [38]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:53783", -- [39]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:41861", -- [40]
			"7823:39175:15177:41383:40966", -- [41]
			"7823:40367:41580", -- [42]
			"7823:40768:40358:39211:39210:34378:4267:22931:43073", -- [43]
			"7823:40768:40358:39211:39210:34378:4267:22931:43079", -- [44]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549", -- [45]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:17555:43991", -- [46]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:54393", -- [47]
			--["name"] = "Bootlegger Outpost, Tanaris",
			["m"] = 71,
			["f"] = 0,
			["direct"] = "7823:40827",
			["coord"] = 2397215500,
		},
		[3841] = {
			"33253:4267:34378:6706:35481:40966:41383:41580:40367", -- [1]
			"33253:4267:34378:39210:39211:40358:40768:7823", -- [2]
			"12578:11138", -- [3]
			"33253:4267:34378:6706:35481:40966:41383:15177", -- [4]
			"33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [5]
			"33253:4267:16227", -- [6]
			"17555:17554", -- [7]
			"33253:22931", -- [8]
			"33253:22931:22935", -- [9]
			"33253:4267:34378:39210:39211:40358", -- [10]
			"33253:34374", -- [11]
			"33253:4267:34378", -- [12]
			"33253:4267:34378:35137", -- [13]
			"33253:4267:34378:35136", -- [14]
			"33253:4407:35138", -- [15]
			"33253:4267:34378:6706:35481", -- [16]
			"33253:4267:34378:6706:35478", -- [17]
			"33253:4267:34378:6706:35556", -- [18]
			"33253:4267:34378:6706:35562", -- [19]
			"33253:4267:34378:6706:35481:40966:41383:15177:39175", -- [20]
			"33253:4267:34378:39210", -- [21]
			"33253:4267:34378:39210:39212", -- [22]
			"33253:4267:34378:39210:39211", -- [23]
			"3838:40552:40553", -- [24]
			"3838:40552", -- [25]
			"33253:4267:34378:39210:39211:40358:40768", -- [26]
			"33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [27]
			"33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [28]
			"33253:4407:41240", -- [29]
			"10897:41861:50084", -- [30]
			"10897:41861:53783", -- [31]
			"10897:41861", -- [32]
			"33253:4267:34378:6706:35481:40966", -- [33]
			"33253:4267:34378:6706:35481:40966:41383:41580", -- [34]
			"12578:43073", -- [35]
			"33253:43079", -- [36]
			"10897:41861:50084:43549", -- [37]
			"17555:43991", -- [38]
			"10897:41861:50084:54393", -- [39]
			--["name"] = "Lor'danel, Darkshore",
			["m"] = 62,
			["coord"] = 2221223249,
			["direct"] = "3838:4267:4321:4407:6706:41383:10897:12578:17555:33253",
			["f"] = 0,
		},
		[40358] = {
			"39211:39210:34378:4267:33253:3841", -- [1]
			"39211:39210:34378:4267:33253:3841:3838", -- [2]
			"39211:39210:34378:4267", -- [3]
			"39211:39210:35136:4407", -- [4]
			"39211:39210:35136:6706", -- [5]
			"40768:7823", -- [6]
			"40367:41383", -- [7]
			"39211:39210:34378:4267:33253:3841:10897", -- [8]
			"39211:39210:34378:4267:22931:12578:11138", -- [9]
			"39211:39210:34378:4267:22931:12578", -- [10]
			"40768:7823:39175:15177", -- [11]
			"40768:7823:10583", -- [12]
			"4321:16227", -- [13]
			"39211:39210:34378:4267:33253:3841:17555:17554", -- [14]
			"39211:39210:34378:4267:33253:3841:17555", -- [15]
			"39211:39210:34378:4267:22931", -- [16]
			"39211:39210:34378:4267:22935", -- [17]
			"39211:39210:34378:4267:34374", -- [18]
			"39211:39210:34378:4267:33253", -- [19]
			"39211:39210:34378", -- [20]
			"39211:39210:35136:35137", -- [21]
			"39211:39210:35136", -- [22]
			"39211:39210:35136:6706:35138", -- [23]
			"40367:41383:40966:35481", -- [24]
			"39211:39210:35136:6706:35478", -- [25]
			"39211:39210:35136:6706:35556", -- [26]
			"39211:39210:35136:6706:35562", -- [27]
			"40768:7823:39175", -- [28]
			"39211:39210", -- [29]
			"4321:39212", -- [30]
			"39211:39210:34378:4267:33253:3841:3838:40552:40553", -- [31]
			"39211:39210:34378:4267:33253:3841:3838:40552", -- [32]
			"40768:7823:40827", -- [33]
			"40768:7823:41214", -- [34]
			"39211:39210:35136:35137:41240", -- [35]
			"39211:39210:34378:4267:22935:43549:50084", -- [36]
			"39211:39210:34378:4267:22935:43549:50084:53783", -- [37]
			"39211:39210:34378:4267:22935:43549:50084:41861", -- [38]
			"40367:41383:40966", -- [39]
			"40367:41580", -- [40]
			"39211:39210:34378:4267:22931:43073", -- [41]
			"39211:39210:34378:4267:22931:43079", -- [42]
			"39211:39210:34378:4267:22935:43549", -- [43]
			"39211:39210:34378:4267:33253:3841:17555:43991", -- [44]
			"39211:39210:34378:4267:22935:43549:50084:54393", -- [45]
			--["name"] = "Mudsprocket, Dustwallow Marsh",
			["m"] = 70,
			["f"] = 0,
			["direct"] = "40367:4321:39211:40768",
			["coord"] = 1841609026,
		},
		[10897] = {
			"3841:3838", -- [1]
			"3841:33253:4267", -- [2]
			"3841:33253:4267:34378:6706:35481:40966:41383:41580:40367", -- [3]
			"3841:33253:4267:16227:4321", -- [4]
			"3841:33253:4407", -- [5]
			"3841:33253:4267:34378:6706", -- [6]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823", -- [7]
			"3841:33253:4267:34378:6706:35481:40966:41383", -- [8]
			"3841:33253:4267:34378:6706:35481:40966:41383:15177", -- [9]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [10]
			"3841:33253:4267:16227", -- [11]
			"3841:17555:17554", -- [12]
			"3841:17555", -- [13]
			"12578:22931", -- [14]
			"41861:50084:43549:22935", -- [15]
			"3841:33253:4267:34378:39210:39211:40358", -- [16]
			"3841:33253:34374", -- [17]
			"3841:33253", -- [18]
			"3841:33253:4267:34378", -- [19]
			"3841:33253:4267:34378:35137", -- [20]
			"3841:33253:4267:34378:35136", -- [21]
			"3841:33253:4407:35138", -- [22]
			"3841:33253:4267:34378:6706:35481", -- [23]
			"3841:33253:4267:34378:6706:35478", -- [24]
			"3841:33253:4267:34378:6706:35556", -- [25]
			"3841:33253:4267:34378:6706:35562", -- [26]
			"3841:33253:4267:34378:6706:35481:40966:41383:15177:39175", -- [27]
			"3841:33253:4267:34378:39210", -- [28]
			"3841:33253:4267:34378:39210:39212", -- [29]
			"3841:33253:4267:34378:39210:39211", -- [30]
			"3841:3838:40552:40553", -- [31]
			"3841:3838:40552", -- [32]
			"3841:33253:4267:34378:39210:39211:40358:40768", -- [33]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [34]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [35]
			"3841:33253:4407:41240", -- [36]
			"41861:50084", -- [37]
			"41861:53783", -- [38]
			"3841:33253:4267:34378:6706:35481:40966", -- [39]
			"3841:33253:4267:34378:6706:35481:40966:41383:41580", -- [40]
			"12578:43073", -- [41]
			"12578:43073:43079", -- [42]
			"41861:50084:43549", -- [43]
			"3841:17555:43991", -- [44]
			"41861:50084:54393", -- [45]
			--["name"] = "Moonglade",
			["m"] = 80,
			["coord"] = 2062068772,
			["direct"] = "3841:11138:12578:41861",
			["f"] = 0,
		},
		[34374] = {
			"33253:3841", -- [1]
			"33253:3841:3838", -- [2]
			"4267:34378:6706:35481:40966:41383:41580:40367", -- [3]
			"4267:16227:4321", -- [4]
			"4267:34378:6706", -- [5]
			"4267:34378:39210:39211:40358:40768:7823", -- [6]
			"4267:34378:6706:35481:40966:41383", -- [7]
			"33253:3841:10897", -- [8]
			"33253:12578:11138", -- [9]
			"33253:12578", -- [10]
			"4267:34378:6706:35481:40966:41383:15177", -- [11]
			"4267:34378:39210:39211:40358:40768:7823:10583", -- [12]
			"4267:16227", -- [13]
			"33253:3841:17555:17554", -- [14]
			"33253:3841:17555", -- [15]
			"4267:22935", -- [16]
			"4267:34378:39210:39211:40358", -- [17]
			"4267:34378", -- [18]
			"4267:34378:35137", -- [19]
			"4267:34378:35136", -- [20]
			"4407:35138", -- [21]
			"4267:34378:6706:35481", -- [22]
			"4267:34378:6706:35478", -- [23]
			"4267:34378:6706:35556", -- [24]
			"4267:34378:6706:35562", -- [25]
			"4267:34378:6706:35481:40966:41383:15177:39175", -- [26]
			"4267:34378:39210", -- [27]
			"4267:34378:39210:39212", -- [28]
			"4267:34378:39210:39211", -- [29]
			"33253:3841:3838:40552:40553", -- [30]
			"33253:3841:3838:40552", -- [31]
			"4267:34378:39210:39211:40358:40768", -- [32]
			"4267:34378:39210:39211:40358:40768:7823:40827", -- [33]
			"4267:34378:39210:39211:40358:40768:7823:41214", -- [34]
			"4407:41240", -- [35]
			"4267:22935:43549:50084", -- [36]
			"4267:22935:43549:50084:53783", -- [37]
			"4267:22935:43549:50084:41861", -- [38]
			"4267:34378:6706:35481:40966", -- [39]
			"4267:34378:6706:35481:40966:41383:41580", -- [40]
			"33253:43079:43073", -- [41]
			"33253:43079", -- [42]
			"4267:22935:43549", -- [43]
			"33253:3841:17555:43991", -- [44]
			"4267:22935:43549:50084:54393", -- [45]
			--["name"] = "Blackfathom Camp, Ashenvale",
			["m"] = 63,
			["f"] = 0,
			["direct"] = "4267:4407:22931:33253",
			["coord"] = 778908870,
		},
		[40552] = {
			"3838:3841", -- [1]
			"3838:3841:33253:4267", -- [2]
			"3838:3841:33253:4267:34378:6706:35481:40966:41383:41580:40367", -- [3]
			"3838:3841:33253:4267:16227:4321", -- [4]
			"3838:3841:33253:4407", -- [5]
			"3838:3841:33253:4267:34378:6706", -- [6]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823", -- [7]
			"3838:3841:33253:4267:34378:6706:35481:40966:41383", -- [8]
			"3838:3841:10897", -- [9]
			"3838:3841:12578:11138", -- [10]
			"3838:3841:12578", -- [11]
			"3838:3841:33253:4267:34378:6706:35481:40966:41383:15177", -- [12]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [13]
			"3838:3841:33253:4267:16227", -- [14]
			"3838:17555:17554", -- [15]
			"3838:17555", -- [16]
			"3838:3841:33253:22931", -- [17]
			"3838:3841:33253:22931:22935", -- [18]
			"3838:3841:33253:4267:34378:39210:39211:40358", -- [19]
			"3838:3841:33253:34374", -- [20]
			"3838:3841:33253", -- [21]
			"3838:3841:33253:4267:34378", -- [22]
			"3838:3841:33253:4267:34378:35137", -- [23]
			"3838:3841:33253:4267:34378:35136", -- [24]
			"3838:3841:33253:4407:35138", -- [25]
			"3838:3841:33253:4267:34378:6706:35481", -- [26]
			"3838:3841:33253:4267:34378:6706:35478", -- [27]
			"3838:3841:33253:4267:34378:6706:35556", -- [28]
			"3838:3841:33253:4267:34378:6706:35562", -- [29]
			"3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:39175", -- [30]
			"3838:3841:33253:4267:34378:39210", -- [31]
			"3838:3841:33253:4267:34378:39210:39212", -- [32]
			"3838:3841:33253:4267:34378:39210:39211", -- [33]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768", -- [34]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [35]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [36]
			"3838:3841:33253:4407:41240", -- [37]
			"3838:3841:10897:41861:50084", -- [38]
			"3838:3841:10897:41861:53783", -- [39]
			"3838:3841:10897:41861", -- [40]
			"3838:3841:33253:4267:34378:6706:35481:40966", -- [41]
			"3838:3841:33253:4267:34378:6706:35481:40966:41383:41580", -- [42]
			"3838:3841:12578:43073", -- [43]
			"3838:3841:33253:43079", -- [44]
			"3838:3841:10897:41861:50084:43549", -- [45]
			"3838:17555:43991", -- [46]
			"3838:3841:10897:41861:50084:54393", -- [47]
			--["name"] = "Darnassus, Teldrassil",
			["m"] = 89,
			["coord"] = 1569225184,
			["direct"] = "3838:40553",
			["f"] = 0,
		},
		[10583] = {
			"7823:40768:40358:39211:39210:34378:4267:33253:3841", -- [1]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838", -- [2]
			"7823:40768:40358:39211:39210:34378:4267", -- [3]
			"7823:40367", -- [4]
			"7823:4321", -- [5]
			"39175:15177:41383:35138:4407", -- [6]
			"39175:15177:41383:6706", -- [7]
			"39175:15177:41383", -- [8]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:10897", -- [9]
			"7823:40768:40358:39211:39210:34378:4267:22931:12578:11138", -- [10]
			"7823:40768:40358:39211:39210:34378:4267:22931:12578", -- [11]
			"7823:16227", -- [12]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:17555:17554", -- [13]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:17555", -- [14]
			"7823:40768:40358:39211:39210:34378:4267:22931", -- [15]
			"7823:40768:40358:39211:39210:34378:4267:22935", -- [16]
			"7823:40768:40358", -- [17]
			"7823:40768:40358:39211:39210:34378:4267:34374", -- [18]
			"7823:40768:40358:39211:39210:34378:4267:33253", -- [19]
			"7823:40768:40358:39211:39210:34378", -- [20]
			"7823:40768:40358:39211:39210:35136:35137", -- [21]
			"7823:40768:40358:39211:39210:35136", -- [22]
			"39175:15177:41383:35138", -- [23]
			"39175:15177:41383:40966:35481", -- [24]
			"39175:15177:41383:40966:35481:35478", -- [25]
			"39175:15177:41383:40966:35481:35478:35556", -- [26]
			"39175:15177:41383:40966:35481:35562", -- [27]
			"7823:40768:40358:39211:39210", -- [28]
			"7823:4321:39212", -- [29]
			"7823:40768:40358:39211", -- [30]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552:40553", -- [31]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552", -- [32]
			"7823:40768", -- [33]
			"7823:40827", -- [34]
			"7823:41214", -- [35]
			"39175:15177:41383:35138:41240", -- [36]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084", -- [37]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:53783", -- [38]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:41861", -- [39]
			"39175:15177:41383:40966", -- [40]
			"39175:15177:41383:41580", -- [41]
			"7823:40768:40358:39211:39210:34378:4267:22931:43073", -- [42]
			"7823:40768:40358:39211:39210:34378:4267:22931:43079", -- [43]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549", -- [44]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:17555:43991", -- [45]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:54393", -- [46]
			--["name"] = "Marshal's Stand, Un'Goro Crater",
			["m"] = 78,
			["f"] = 0,
			["direct"] = "7823:15177:39175",
			["coord"] = 2408031264,
		},
		[35136] = {
			"34378:4267:33253:3841", -- [1]
			"34378:4267:33253:3841:3838", -- [2]
			"34378:4267", -- [3]
			"6706:35481:40966:41383:41580:40367", -- [4]
			"39210:39212:4321", -- [5]
			"39210:39211:40358:40768:7823", -- [6]
			"6706:35481:40966:41383", -- [7]
			"34378:4267:33253:3841:10897", -- [8]
			"34378:4267:22931:12578:11138", -- [9]
			"34378:4267:22931:12578", -- [10]
			"6706:35481:40966:41383:15177", -- [11]
			"39210:39211:40358:40768:7823:10583", -- [12]
			"39210:16227", -- [13]
			"34378:4267:33253:3841:17555:17554", -- [14]
			"34378:4267:33253:3841:17555", -- [15]
			"34378:4267:22931", -- [16]
			"34378:4267:22935", -- [17]
			"39210:39211:40358", -- [18]
			"34378:4267:34374", -- [19]
			"34378:4267:33253", -- [20]
			"6706:35481", -- [21]
			"6706:35478", -- [22]
			"6706:35556", -- [23]
			"6706:35562", -- [24]
			"39210:39211:40358:40768:7823:39175", -- [25]
			"39210:39212", -- [26]
			"39210:39211", -- [27]
			"34378:4267:33253:3841:3838:40552:40553", -- [28]
			"34378:4267:33253:3841:3838:40552", -- [29]
			"39210:39211:40358:40768", -- [30]
			"39210:39211:40358:40768:7823:40827", -- [31]
			"39210:39211:40358:40768:7823:41214", -- [32]
			"35137:41240", -- [33]
			"34378:4267:22935:43549:50084", -- [34]
			"34378:4267:22935:43549:50084:53783", -- [35]
			"34378:4267:22935:43549:50084:41861", -- [36]
			"6706:35481:40966", -- [37]
			"6706:35481:40966:41383:41580", -- [38]
			"34378:4267:22931:43073", -- [39]
			"34378:4267:22931:43079", -- [40]
			"34378:4267:22935:43549", -- [41]
			"34378:4267:33253:3841:17555:43991", -- [42]
			"34378:4267:22935:43549:50084:54393", -- [43]
			--["name"] = "Northwatch Expedition Base Camp, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "4407:6706:34378:35137:35138:39210",
			["coord"] = 3045445139,
		},
		[40367] = {
			"41383:3841", -- [1]
			"41383:3841:3838", -- [2]
			"41383:6706:34378:4267", -- [3]
			"41383:35138:4407", -- [4]
			"41383:6706", -- [5]
			"41383:3841:10897", -- [6]
			"41383:6706:34378:4267:22931:12578:11138", -- [7]
			"41383:6706:34378:4267:22931:12578", -- [8]
			"41383:15177", -- [9]
			"41383:15177:39175:10583", -- [10]
			"40358:4321:16227", -- [11]
			"41383:3841:17555:17554", -- [12]
			"41383:3841:17555", -- [13]
			"41383:6706:34378:4267:22931", -- [14]
			"41383:6706:34378:4267:22935", -- [15]
			"41383:35138:4407:34374", -- [16]
			"41383:35138:4407:33253", -- [17]
			"41383:6706:34378", -- [18]
			"41383:6706:35137", -- [19]
			"40358:39211:39210:35136", -- [20]
			"41383:35138", -- [21]
			"41383:40966:35481", -- [22]
			"41383:40966:35481:35478", -- [23]
			"41383:40966:35481:35478:35556", -- [24]
			"41383:40966:35481:35562", -- [25]
			"41383:15177:39175", -- [26]
			"40358:39211:39210", -- [27]
			"40358:4321:39212", -- [28]
			"40358:39211", -- [29]
			"41383:3841:3838:40552:40553", -- [30]
			"41383:3841:3838:40552", -- [31]
			"7823:40827", -- [32]
			"7823:41214", -- [33]
			"41383:35138:41240", -- [34]
			"41383:6706:34378:4267:22935:43549:50084", -- [35]
			"41383:6706:34378:4267:22935:43549:50084:53783", -- [36]
			"41383:6706:34378:4267:22935:43549:50084:41861", -- [37]
			"41383:40966", -- [38]
			"41383:6706:34378:4267:22931:43073", -- [39]
			"41383:6706:34378:4267:22931:43079", -- [40]
			"41383:6706:34378:4267:22935:43549", -- [41]
			"41383:3841:17555:43991", -- [42]
			"41383:6706:34378:4267:22935:43549:50084:54393", -- [43]
			--["name"] = "Shadebough, Feralas",
			["m"] = 69,
			["f"] = 0,
			["direct"] = "4321:7823:41383:40358:40768:41580",
			["coord"] = 3317207379,
		},
		[40553] = {
			"40552:3838:3841", -- [1]
			"40552:3838", -- [2]
			"40552:3838:3841:33253:4267", -- [3]
			"40552:3838:3841:33253:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"40552:3838:3841:33253:4267:16227:4321", -- [5]
			"40552:3838:3841:33253:4407", -- [6]
			"40552:3838:3841:33253:4267:34378:6706", -- [7]
			"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"40552:3838:3841:33253:4267:34378:6706:35481:40966:41383", -- [9]
			"40552:3838:3841:10897", -- [10]
			"40552:3838:3841:12578:11138", -- [11]
			"40552:3838:3841:12578", -- [12]
			"40552:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177", -- [13]
			"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"40552:3838:3841:33253:4267:16227", -- [15]
			"40552:3838:17555:17554", -- [16]
			"40552:3838:17555", -- [17]
			"40552:3838:3841:33253:22931", -- [18]
			"40552:3838:3841:33253:22931:22935", -- [19]
			"40552:3838:3841:33253:4267:34378:39210:39211:40358", -- [20]
			"40552:3838:3841:33253:34374", -- [21]
			"40552:3838:3841:33253", -- [22]
			"40552:3838:3841:33253:4267:34378", -- [23]
			"40552:3838:3841:33253:4267:34378:35137", -- [24]
			"40552:3838:3841:33253:4267:34378:35136", -- [25]
			"40552:3838:3841:33253:4407:35138", -- [26]
			"40552:3838:3841:33253:4267:34378:6706:35481", -- [27]
			"40552:3838:3841:33253:4267:34378:6706:35478", -- [28]
			"40552:3838:3841:33253:4267:34378:6706:35556", -- [29]
			"40552:3838:3841:33253:4267:34378:6706:35562", -- [30]
			"40552:3838:3841:33253:4267:34378:6706:35481:40966:41383:15177:39175", -- [31]
			"40552:3838:3841:33253:4267:34378:39210", -- [32]
			"40552:3838:3841:33253:4267:34378:39210:39212", -- [33]
			"40552:3838:3841:33253:4267:34378:39210:39211", -- [34]
			"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768", -- [35]
			"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [36]
			"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [37]
			"40552:3838:3841:33253:4407:41240", -- [38]
			"40552:3838:3841:10897:41861:50084", -- [39]
			"40552:3838:3841:10897:41861:53783", -- [40]
			"40552:3838:3841:10897:41861", -- [41]
			"40552:3838:3841:33253:4267:34378:6706:35481:40966", -- [42]
			"40552:3838:3841:33253:4267:34378:6706:35481:40966:41383:41580", -- [43]
			"40552:3838:3841:12578:43073", -- [44]
			"40552:3838:3841:33253:43079", -- [45]
			"40552:3838:3841:10897:41861:50084:43549", -- [46]
			"40552:3838:17555:43991", -- [47]
			"40552:3838:3841:10897:41861:50084:54393", -- [48]
			--["name"] = "Dolanaar, Teldrassil",
			["m"] = 57,
			["coord"] = 2381611283,
			["direct"] = "40552",
			["f"] = 0,
		},
		[53783] = {
			"41861:10897:3841", -- [1]
			"41861:10897:3841:3838", -- [2]
			"50084:43549:22935:4267", -- [3]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"50084:43549:22935:4267:16227:4321", -- [5]
			"50084:43549:22935:4267:34378:4407", -- [6]
			"50084:43549:22935:4267:34378:6706", -- [7]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383", -- [9]
			"41861:10897", -- [10]
			"41861:11138", -- [11]
			"41861:10897:12578", -- [12]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177", -- [13]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"50084:43549:22935:4267:16227", -- [15]
			"41861:10897:3841:17555:17554", -- [16]
			"41861:10897:3841:17555", -- [17]
			"50084:43549:22935:22931", -- [18]
			"50084:43549:22935", -- [19]
			"50084:43549:22935:4267:34378:39210:39211:40358", -- [20]
			"50084:43549:22935:4267:34374", -- [21]
			"50084:43549:22935:22931:33253", -- [22]
			"50084:43549:22935:4267:34378", -- [23]
			"50084:43549:22935:4267:34378:35137", -- [24]
			"50084:43549:22935:4267:34378:35136", -- [25]
			"50084:43549:22935:4267:34378:35137:41240:35138", -- [26]
			"50084:43549:22935:4267:34378:6706:35481", -- [27]
			"50084:43549:22935:4267:34378:6706:35478", -- [28]
			"50084:43549:22935:4267:34378:6706:35556", -- [29]
			"50084:43549:22935:4267:34378:6706:35562", -- [30]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:39175", -- [31]
			"50084:43549:22935:4267:34378:39210", -- [32]
			"50084:43549:22935:4267:34378:39210:39212", -- [33]
			"50084:43549:22935:4267:34378:39210:39211", -- [34]
			"41861:10897:3841:3838:40552:40553", -- [35]
			"41861:10897:3841:3838:40552", -- [36]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768", -- [37]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:40827", -- [38]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:41214", -- [39]
			"50084:43549:22935:4267:34378:35137:41240", -- [40]
			"50084:43549:22935:4267:34378:6706:35481:40966", -- [41]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:41580", -- [42]
			"41861:10897:12578:43073", -- [43]
			"50084:43549:22935:22931:43079", -- [44]
			"50084:43549", -- [45]
			"41861:10897:3841:17555:43991", -- [46]
			"50084:54393", -- [47]
			--["name"] = "Grove of Aessina, Hyjal",
			["m"] = 198,
			["coord"] = 842030342,
			["direct"] = "50084:41861",
			["f"] = 0,
		},
		[22931] = {
			"33253:3841", -- [1]
			"33253:3841:3838", -- [2]
			"4267:34378:6706:35481:40966:41383:41580:40367", -- [3]
			"4267:16227:4321", -- [4]
			"4267:34378:4407", -- [5]
			"4267:34378:6706", -- [6]
			"4267:34378:39210:39211:40358:40768:7823", -- [7]
			"4267:34378:6706:35481:40966:41383", -- [8]
			"12578:10897", -- [9]
			"12578:11138", -- [10]
			"4267:34378:6706:35481:40966:41383:15177", -- [11]
			"4267:34378:39210:39211:40358:40768:7823:10583", -- [12]
			"4267:16227", -- [13]
			"33253:3841:17555:17554", -- [14]
			"33253:3841:17555", -- [15]
			"4267:34378:39210:39211:40358", -- [16]
			"4267:34378", -- [17]
			"4267:34378:35137", -- [18]
			"4267:34378:35136", -- [19]
			"4267:34378:35137:41240:35138", -- [20]
			"4267:34378:6706:35481", -- [21]
			"4267:34378:6706:35478", -- [22]
			"4267:34378:6706:35556", -- [23]
			"4267:34378:6706:35562", -- [24]
			"4267:34378:6706:35481:40966:41383:15177:39175", -- [25]
			"4267:34378:39210", -- [26]
			"4267:34378:39210:39212", -- [27]
			"4267:34378:39210:39211", -- [28]
			"33253:3841:3838:40552:40553", -- [29]
			"33253:3841:3838:40552", -- [30]
			"4267:34378:39210:39211:40358:40768", -- [31]
			"4267:34378:39210:39211:40358:40768:7823:40827", -- [32]
			"4267:34378:39210:39211:40358:40768:7823:41214", -- [33]
			"4267:34378:35137:41240", -- [34]
			"22935:43549:50084", -- [35]
			"22935:43549:50084:53783", -- [36]
			"22935:43549:50084:41861", -- [37]
			"4267:34378:6706:35481:40966", -- [38]
			"4267:34378:6706:35481:40966:41383:41580", -- [39]
			"22935:43549", -- [40]
			"33253:3841:17555:43991", -- [41]
			"22935:43549:50084:54393", -- [42]
			--["name"] = "Emerald Sanctuary, Felwood",
			["m"] = 77,
			["coord"] = 2212089545,
			["direct"] = "4267:12578:22935:34374:33253:43073:43079",
			["f"] = 0,
		},
		[41383] = {
			"3841:3838", -- [1]
			"6706:34378:4267", -- [2]
			"41580:40367:40358:4321", -- [3]
			"35138:4407", -- [4]
			"15177:39175:7823", -- [5]
			"3841:10897", -- [6]
			"6706:34378:4267:22931:12578:11138", -- [7]
			"6706:34378:4267:22931:12578", -- [8]
			"15177:39175:10583", -- [9]
			"41580:40367:40358:4321:16227", -- [10]
			"3841:17555:17554", -- [11]
			"3841:17555", -- [12]
			"6706:34378:4267:22931", -- [13]
			"6706:34378:4267:22935", -- [14]
			"41580:40367:40358", -- [15]
			"35138:4407:34374", -- [16]
			"35138:4407:33253", -- [17]
			"6706:34378", -- [18]
			"6706:35137", -- [19]
			"6706:35136", -- [20]
			"40966:35481:35478", -- [21]
			"40966:35481:35478:35556", -- [22]
			"40966:35481:35562", -- [23]
			"15177:39175", -- [24]
			"6706:35136:39210", -- [25]
			"41580:40367:40358:4321:39212", -- [26]
			"41580:40367:40358:39211", -- [27]
			"3841:3838:40552:40553", -- [28]
			"3841:3838:40552", -- [29]
			"41580:40367:40768", -- [30]
			"15177:48274:48275:40827", -- [31]
			"15177:39175:7823:41214", -- [32]
			"35138:41240", -- [33]
			"6706:34378:4267:22935:43549:50084", -- [34]
			"6706:34378:4267:22935:43549:50084:53783", -- [35]
			"6706:34378:4267:22935:43549:50084:41861", -- [36]
			"6706:34378:4267:22931:43073", -- [37]
			"6706:34378:4267:22931:43079", -- [38]
			"6706:34378:4267:22935:43549", -- [39]
			"3841:17555:43991", -- [40]
			"6706:34378:4267:22935:43549:50084:54393", -- [41]
			--["name"] = "Feathermoon, Feralas",
			["m"] = 69,
			["f"] = 0,
			["direct"] = "3841:40367:6706:15177:35138:35481:40966:41580",
			["coord"] = 2010149894,
		},
		[34378] = {
			"4267:33253:3841", -- [1]
			"4267:33253:3841:3838", -- [2]
			"6706:35481:40966:41383:41580:40367", -- [3]
			"39210:39212:4321", -- [4]
			"39210:39211:40358:40768:7823", -- [5]
			"6706:35481:40966:41383", -- [6]
			"4267:33253:3841:10897", -- [7]
			"4267:22931:12578:11138", -- [8]
			"4267:22931:12578", -- [9]
			"6706:35481:40966:41383:15177", -- [10]
			"39210:39211:40358:40768:7823:10583", -- [11]
			"39210:16227", -- [12]
			"4267:33253:3841:17555:17554", -- [13]
			"4267:33253:3841:17555", -- [14]
			"4267:22931", -- [15]
			"4267:22935", -- [16]
			"39210:39211:40358", -- [17]
			"4267:34374", -- [18]
			"4267:33253", -- [19]
			"35137:41240:35138", -- [20]
			"6706:35481", -- [21]
			"6706:35478", -- [22]
			"6706:35556", -- [23]
			"6706:35562", -- [24]
			"6706:35481:40966:41383:15177:39175", -- [25]
			"39210:39212", -- [26]
			"39210:39211", -- [27]
			"4267:33253:3841:3838:40552:40553", -- [28]
			"4267:33253:3841:3838:40552", -- [29]
			"39210:39211:40358:40768", -- [30]
			"39210:39211:40358:40768:7823:40827", -- [31]
			"39210:39211:40358:40768:7823:41214", -- [32]
			"35137:41240", -- [33]
			"4267:22935:43549:50084", -- [34]
			"4267:22935:43549:50084:53783", -- [35]
			"4267:22935:43549:50084:41861", -- [36]
			"6706:35481:40966", -- [37]
			"6706:35481:40966:41383:41580", -- [38]
			"4267:22931:43073", -- [39]
			"4267:22931:43079", -- [40]
			"4267:22935:43549", -- [41]
			"4267:33253:3841:17555:43991", -- [42]
			"4267:22935:43549:50084:54393", -- [43]
			--["name"] = "Stardust Spire, Ashenvale",
			["m"] = 63,
			["f"] = 0,
			["direct"] = "4267:4407:6706:35137:35136:39210",
			["coord"] = 1505998935,
		},
		[4267] = {
			"33253:3841:3838", -- [1]
			"34378:6706:35481:40966:41383:41580:40367", -- [2]
			"34378:6706", -- [3]
			"34378:39210:39211:40358:40768:7823", -- [4]
			"34378:6706:35481:40966:41383", -- [5]
			"33253:3841:10897", -- [6]
			"22931:12578:11138", -- [7]
			"22931:12578", -- [8]
			"34378:6706:35481:40966:41383:15177", -- [9]
			"34378:39210:39211:40358:40768:7823:10583", -- [10]
			"33253:3841:17555:17554", -- [11]
			"33253:3841:17555", -- [12]
			"34378:39210:39211:40358", -- [13]
			"34378:35137", -- [14]
			"34378:35136", -- [15]
			"34378:35137:41240:35138", -- [16]
			"34378:6706:35481", -- [17]
			"34378:6706:35478", -- [18]
			"34378:6706:35556", -- [19]
			"34378:6706:35562", -- [20]
			"34378:6706:35481:40966:41383:15177:39175", -- [21]
			"34378:39210", -- [22]
			"34378:39210:39212", -- [23]
			"34378:39210:39211", -- [24]
			"33253:3841:3838:40552:40553", -- [25]
			"33253:3841:3838:40552", -- [26]
			"34378:39210:39211:40358:40768", -- [27]
			"34378:39210:39211:40358:40768:7823:40827", -- [28]
			"34378:39210:39211:40358:40768:7823:41214", -- [29]
			"34378:35137:41240", -- [30]
			"22935:43549:50084", -- [31]
			"22935:43549:50084:53783", -- [32]
			"22935:43549:50084:41861", -- [33]
			"34378:6706:35481:40966", -- [34]
			"34378:6706:35481:40966:41383:41580", -- [35]
			"22931:43073", -- [36]
			"22931:43079", -- [37]
			"22935:43549", -- [38]
			"33253:3841:17555:43991", -- [39]
			"22935:43549:50084:54393", -- [40]
			--["name"] = "Astranaar, Ashenvale",
			["m"] = 63,
			["coord"] = 1481538283,
			["direct"] = "3841:4321:4407:16227:22931:22935:34374:33253:34378",
			["f"] = 0,
		},
		[22935] = {
			"22931:33253:3841", -- [1]
			"22931:33253:3841:3838", -- [2]
			"4267:34378:6706:35481:40966:41383:41580:40367", -- [3]
			"4267:16227:4321", -- [4]
			"4267:34378:4407", -- [5]
			"4267:34378:6706", -- [6]
			"4267:34378:39210:39211:40358:40768:7823", -- [7]
			"4267:34378:6706:35481:40966:41383", -- [8]
			"43549:50084:41861:10897", -- [9]
			"43549:50084:41861:11138", -- [10]
			"22931:12578", -- [11]
			"4267:34378:6706:35481:40966:41383:15177", -- [12]
			"4267:34378:39210:39211:40358:40768:7823:10583", -- [13]
			"4267:16227", -- [14]
			"22931:33253:3841:17555:17554", -- [15]
			"22931:33253:3841:17555", -- [16]
			"4267:34378:39210:39211:40358", -- [17]
			"4267:34374", -- [18]
			"22931:33253", -- [19]
			"4267:34378", -- [20]
			"4267:34378:35137", -- [21]
			"4267:34378:35136", -- [22]
			"4267:34378:35137:41240:35138", -- [23]
			"4267:34378:6706:35481", -- [24]
			"4267:34378:6706:35478", -- [25]
			"4267:34378:6706:35556", -- [26]
			"4267:34378:6706:35562", -- [27]
			"4267:34378:6706:35481:40966:41383:15177:39175", -- [28]
			"4267:34378:39210", -- [29]
			"4267:34378:39210:39212", -- [30]
			"4267:34378:39210:39211", -- [31]
			"22931:33253:3841:3838:40552:40553", -- [32]
			"22931:33253:3841:3838:40552", -- [33]
			"4267:34378:39210:39211:40358:40768", -- [34]
			"4267:34378:39210:39211:40358:40768:7823:40827", -- [35]
			"4267:34378:39210:39211:40358:40768:7823:41214", -- [36]
			"4267:34378:35137:41240", -- [37]
			"43549:50084", -- [38]
			"43549:50084:53783", -- [39]
			"43549:50084:41861", -- [40]
			"4267:34378:6706:35481:40966", -- [41]
			"4267:34378:6706:35481:40966:41383:41580", -- [42]
			"22931:43073", -- [43]
			"22931:43079", -- [44]
			"22931:33253:3841:17555:43991", -- [45]
			"43549:50084:54393", -- [46]
			--["name"] = "Forest Song, Ashenvale",
			["m"] = 63,
			["coord"] = 3651235686,
			["direct"] = "4267:22931:43549",
			["f"] = 0,
		},
		[41580] = {
			"41383:3841", -- [1]
			"41383:3841:3838", -- [2]
			"41383:6706:34378:4267", -- [3]
			"40367:40358:4321", -- [4]
			"41383:35138:4407", -- [5]
			"41383:6706", -- [6]
			"40367:7823", -- [7]
			"41383:3841:10897", -- [8]
			"41383:6706:34378:4267:22931:12578:11138", -- [9]
			"41383:6706:34378:4267:22931:12578", -- [10]
			"41383:15177", -- [11]
			"41383:15177:39175:10583", -- [12]
			"40367:40358:4321:16227", -- [13]
			"41383:3841:17555:17554", -- [14]
			"41383:3841:17555", -- [15]
			"41383:6706:34378:4267:22931", -- [16]
			"41383:6706:34378:4267:22935", -- [17]
			"40367:40358", -- [18]
			"41383:35138:4407:34374", -- [19]
			"41383:35138:4407:33253", -- [20]
			"41383:6706:34378", -- [21]
			"41383:6706:35137", -- [22]
			"41383:6706:35136", -- [23]
			"41383:35138", -- [24]
			"41383:40966:35481", -- [25]
			"41383:40966:35481:35478", -- [26]
			"41383:40966:35481:35478:35556", -- [27]
			"41383:40966:35481:35562", -- [28]
			"41383:15177:39175", -- [29]
			"40367:40358:39211:39210", -- [30]
			"40367:40358:4321:39212", -- [31]
			"40367:40358:39211", -- [32]
			"41383:3841:3838:40552:40553", -- [33]
			"41383:3841:3838:40552", -- [34]
			"40367:40768", -- [35]
			"40367:7823:40827", -- [36]
			"40367:7823:41214", -- [37]
			"41383:35138:41240", -- [38]
			"41383:6706:34378:4267:22935:43549:50084", -- [39]
			"41383:6706:34378:4267:22935:43549:50084:53783", -- [40]
			"41383:6706:34378:4267:22935:43549:50084:41861", -- [41]
			"41383:40966", -- [42]
			"41383:6706:34378:4267:22931:43073", -- [43]
			"41383:6706:34378:4267:22931:43079", -- [44]
			"41383:6706:34378:4267:22935:43549", -- [45]
			"41383:3841:17555:43991", -- [46]
			"41383:6706:34378:4267:22935:43549:50084:54393", -- [47]
			--["name"] = "Tower of Estulan, Feralas",
			["m"] = 69,
			["f"] = 0,
			["direct"] = "40367:41383",
			["coord"] = 2449377781,
		},
		[16227] = {
			"4267:33253:3841", -- [1]
			"4267:33253:3841:3838", -- [2]
			"4321:40358:40367", -- [3]
			"39210:35136:4407", -- [4]
			"39210:35136:6706", -- [5]
			"4321:40358:40367:41383", -- [6]
			"4267:33253:3841:10897", -- [7]
			"4267:22931:12578:11138", -- [8]
			"4267:22931:12578", -- [9]
			"7823:39175:15177", -- [10]
			"7823:10583", -- [11]
			"4267:33253:3841:17555:17554", -- [12]
			"4267:33253:3841:17555", -- [13]
			"4267:22931", -- [14]
			"4267:22935", -- [15]
			"4321:40358", -- [16]
			"4267:34374", -- [17]
			"4267:33253", -- [18]
			"39210:34378", -- [19]
			"39210:35136:35137", -- [20]
			"39210:35136", -- [21]
			"39210:35136:6706:35138", -- [22]
			"39210:35136:6706:35481", -- [23]
			"39210:35136:6706:35478", -- [24]
			"39210:35136:6706:35556", -- [25]
			"39210:35136:6706:35562", -- [26]
			"7823:39175", -- [27]
			"39212:39211", -- [28]
			"4267:33253:3841:3838:40552:40553", -- [29]
			"4267:33253:3841:3838:40552", -- [30]
			"4321:40358:40768", -- [31]
			"7823:40827", -- [32]
			"7823:41214", -- [33]
			"39210:35136:35137:41240", -- [34]
			"4267:22935:43549:50084", -- [35]
			"4267:22935:43549:50084:53783", -- [36]
			"4267:22935:43549:50084:41861", -- [37]
			"39210:35136:6706:35481:40966", -- [38]
			"4321:40358:40367:41580", -- [39]
			"4267:22931:43073", -- [40]
			"4267:22931:43079", -- [41]
			"4267:22935:43549", -- [42]
			"4267:33253:3841:17555:43991", -- [43]
			"4267:22935:43549:50084:54393", -- [44]
			--["name"] = "Ratchet, Northern Barrens",
			["m"] = 10,
			["f"] = 0,
			["direct"] = "4267:4321:7823:39210:39212",
			["coord"] = 2968696052,
		},
		[35138] = {
			"4407:3841", -- [1]
			"4407:3841:3838", -- [2]
			"41240:35137:34378:4267", -- [3]
			"41383:41580:40367", -- [4]
			"35136:39210:39212:4321", -- [5]
			"35136:39210:39211:40358:40768:7823", -- [6]
			"4407:3841:10897", -- [7]
			"4407:33253:12578:11138", -- [8]
			"4407:33253:12578", -- [9]
			"41383:15177", -- [10]
			"41383:15177:39175:10583", -- [11]
			"35136:39210:16227", -- [12]
			"4407:3841:17555:17554", -- [13]
			"4407:3841:17555", -- [14]
			"41240:35137:34378:4267:22931", -- [15]
			"41240:35137:34378:4267:22935", -- [16]
			"35136:39210:39211:40358", -- [17]
			"4407:34374", -- [18]
			"4407:33253", -- [19]
			"41240:35137:34378", -- [20]
			"6706:35481", -- [21]
			"6706:35478", -- [22]
			"6706:35556", -- [23]
			"6706:35562", -- [24]
			"41383:15177:39175", -- [25]
			"35136:39210", -- [26]
			"35136:39210:39212", -- [27]
			"35136:39210:39211", -- [28]
			"4407:3841:3838:40552:40553", -- [29]
			"4407:3841:3838:40552", -- [30]
			"35136:39210:39211:40358:40768", -- [31]
			"35136:39210:39211:40358:40768:7823:40827", -- [32]
			"35136:39210:39211:40358:40768:7823:41214", -- [33]
			"41240:35137:34378:4267:22935:43549:50084", -- [34]
			"41240:35137:34378:4267:22935:43549:50084:53783", -- [35]
			"41240:35137:34378:4267:22935:43549:50084:41861", -- [36]
			"6706:35481:40966", -- [37]
			"41383:41580", -- [38]
			"41240:35137:34378:4267:22931:43073", -- [39]
			"4407:33253:43079", -- [40]
			"41240:35137:34378:4267:22935:43549", -- [41]
			"4407:3841:17555:43991", -- [42]
			"41240:35137:34378:4267:22935:43549:50084:54393", -- [43]
			--["name"] = "Farwatcher's Glen, Stonetalon Mountains",
			["m"] = 65,
			["f"] = 0,
			["direct"] = "4407:6706:41383:35137:35136:41240",
			["coord"] = 1375116844,
		},
		[54393] = {
			"50084:41861:10897:3841", -- [1]
			"50084:41861:10897:3841:3838", -- [2]
			"50084:43549:22935:4267", -- [3]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"50084:43549:22935:4267:16227:4321", -- [5]
			"50084:43549:22935:4267:34378:4407", -- [6]
			"50084:43549:22935:4267:34378:6706", -- [7]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383", -- [9]
			"50084:41861:10897", -- [10]
			"50084:41861:11138", -- [11]
			"50084:41861:10897:12578", -- [12]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177", -- [13]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"50084:43549:22935:4267:16227", -- [15]
			"50084:41861:10897:3841:17555:17554", -- [16]
			"50084:41861:10897:3841:17555", -- [17]
			"50084:43549:22935:22931", -- [18]
			"50084:43549:22935", -- [19]
			"50084:43549:22935:4267:34378:39210:39211:40358", -- [20]
			"50084:43549:22935:4267:34374", -- [21]
			"50084:43549:22935:22931:33253", -- [22]
			"50084:43549:22935:4267:34378", -- [23]
			"50084:43549:22935:4267:34378:35137", -- [24]
			"50084:43549:22935:4267:34378:35136", -- [25]
			"50084:43549:22935:4267:34378:35137:41240:35138", -- [26]
			"50084:43549:22935:4267:34378:6706:35481", -- [27]
			"50084:43549:22935:4267:34378:6706:35478", -- [28]
			"50084:43549:22935:4267:34378:6706:35556", -- [29]
			"50084:43549:22935:4267:34378:6706:35562", -- [30]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:39175", -- [31]
			"50084:43549:22935:4267:34378:39210", -- [32]
			"50084:43549:22935:4267:34378:39210:39212", -- [33]
			"50084:43549:22935:4267:34378:39210:39211", -- [34]
			"50084:41861:10897:3841:3838:40552:40553", -- [35]
			"50084:41861:10897:3841:3838:40552", -- [36]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768", -- [37]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:40827", -- [38]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:41214", -- [39]
			"50084:43549:22935:4267:34378:35137:41240", -- [40]
			"50084:53783", -- [41]
			"50084:41861", -- [42]
			"50084:43549:22935:4267:34378:6706:35481:40966", -- [43]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:41580", -- [44]
			"50084:41861:10897:12578:43073", -- [45]
			"50084:43549:22935:22931:43079", -- [46]
			"50084:43549", -- [47]
			"50084:41861:10897:3841:17555:43991", -- [48]
			--["name"] = "Sanctuary of Malorne, Hyjal",
			["m"] = 198,
			["f"] = 0,
			["direct"] = "50084",
			["coord"] = 1192010387,
		},
		[39175] = {
			"15177:41383:3841", -- [1]
			"15177:41383:3841:3838", -- [2]
			"15177:41383:6706:34378:4267", -- [3]
			"15177:41383:41580:40367", -- [4]
			"7823:4321", -- [5]
			"15177:41383:35138:4407", -- [6]
			"15177:41383:6706", -- [7]
			"15177:41383", -- [8]
			"15177:41383:3841:10897", -- [9]
			"15177:41383:6706:34378:4267:22931:12578:11138", -- [10]
			"15177:41383:6706:34378:4267:22931:12578", -- [11]
			"7823:16227", -- [12]
			"15177:41383:3841:17555:17554", -- [13]
			"15177:41383:3841:17555", -- [14]
			"15177:41383:6706:34378:4267:22931", -- [15]
			"15177:41383:6706:34378:4267:22935", -- [16]
			"7823:40768:40358", -- [17]
			"15177:41383:35138:4407:34374", -- [18]
			"15177:41383:35138:4407:33253", -- [19]
			"15177:41383:6706:34378", -- [20]
			"15177:41383:6706:35137", -- [21]
			"7823:40768:40358:39211:39210:35136", -- [22]
			"15177:41383:35138", -- [23]
			"15177:41383:40966:35481", -- [24]
			"15177:41383:40966:35481:35478", -- [25]
			"15177:41383:40966:35481:35478:35556", -- [26]
			"15177:41383:40966:35481:35562", -- [27]
			"7823:40768:40358:39211:39210", -- [28]
			"7823:4321:39212", -- [29]
			"7823:40768:40358:39211", -- [30]
			"15177:41383:3841:3838:40552:40553", -- [31]
			"15177:41383:3841:3838:40552", -- [32]
			"7823:40768", -- [33]
			"7823:40827", -- [34]
			"7823:41214", -- [35]
			"15177:41383:35138:41240", -- [36]
			"15177:41383:6706:34378:4267:22935:43549:50084", -- [37]
			"15177:41383:6706:34378:4267:22935:43549:50084:53783", -- [38]
			"15177:41383:6706:34378:4267:22935:43549:50084:41861", -- [39]
			"15177:41383:40966", -- [40]
			"15177:41383:41580", -- [41]
			"15177:41383:6706:34378:4267:22931:43073", -- [42]
			"15177:41383:6706:34378:4267:22931:43079", -- [43]
			"15177:41383:6706:34378:4267:22935:43549", -- [44]
			"15177:41383:3841:17555:43991", -- [45]
			"15177:41383:6706:34378:4267:22935:43549:50084:54393", -- [46]
			--["name"] = "Mossy Pile, Un'Goro Crater",
			["m"] = 78,
			["f"] = 0,
			["direct"] = "7823:15177:10583",
			["coord"] = 1890412268,
		},
		[40966] = {
			"35481:4407:3841", -- [1]
			"35481:4407:3841:3838", -- [2]
			"35481:6706:34378:4267", -- [3]
			"41383:41580:40367", -- [4]
			"41383:41580:40367:40358:4321", -- [5]
			"35481:4407", -- [6]
			"35481:6706", -- [7]
			"41383:15177:39175:7823", -- [8]
			"35481:4407:3841:10897", -- [9]
			"35481:4407:33253:12578:11138", -- [10]
			"35481:4407:33253:12578", -- [11]
			"41383:15177", -- [12]
			"41383:15177:39175:10583", -- [13]
			"35481:6706:35136:39210:16227", -- [14]
			"35481:4407:3841:17555:17554", -- [15]
			"35481:4407:3841:17555", -- [16]
			"35481:6706:34378:4267:22931", -- [17]
			"35481:6706:34378:4267:22935", -- [18]
			"41383:41580:40367:40358", -- [19]
			"35481:4407:34374", -- [20]
			"35481:4407:33253", -- [21]
			"35481:6706:34378", -- [22]
			"35481:6706:35137", -- [23]
			"35481:6706:35136", -- [24]
			"35481:6706:35138", -- [25]
			"35481:35478", -- [26]
			"35481:35478:35556", -- [27]
			"35481:35562", -- [28]
			"41383:15177:39175", -- [29]
			"35481:6706:35136:39210", -- [30]
			"41383:41580:40367:40358:4321:39212", -- [31]
			"41383:41580:40367:40358:39211", -- [32]
			"35481:4407:3841:3838:40552:40553", -- [33]
			"35481:4407:3841:3838:40552", -- [34]
			"41383:41580:40367:40768", -- [35]
			"41383:15177:48274:48275:40827", -- [36]
			"41383:15177:39175:7823:41214", -- [37]
			"35481:6706:35138:41240", -- [38]
			"35481:6706:34378:4267:22935:43549:50084", -- [39]
			"35481:6706:34378:4267:22935:43549:50084:53783", -- [40]
			"35481:6706:34378:4267:22935:43549:50084:41861", -- [41]
			"41383:41580", -- [42]
			"35481:6706:34378:4267:22931:43073", -- [43]
			"35481:6706:34378:4267:22931:43079", -- [44]
			"35481:6706:34378:4267:22935:43549", -- [45]
			"35481:4407:3841:17555:43991", -- [46]
			"35481:6706:34378:4267:22935:43549:50084:54393", -- [47]
			--["name"] = "Dreamer's Rest, Feralas",
			["m"] = 69,
			["f"] = 0,
			["direct"] = "41383:35481",
			["coord"] = 2156735114,
		},
		[35481] = {
			"4407:3841", -- [1]
			"4407:3841:3838", -- [2]
			"6706:34378:4267", -- [3]
			"40966:41383:41580:40367", -- [4]
			"40966:41383:41580:40367:40358:4321", -- [5]
			"40966:41383:15177:39175:7823", -- [6]
			"4407:3841:10897", -- [7]
			"4407:33253:12578:11138", -- [8]
			"4407:33253:12578", -- [9]
			"40966:41383:15177", -- [10]
			"40966:41383:15177:39175:10583", -- [11]
			"6706:35136:39210:16227", -- [12]
			"4407:3841:17555:17554", -- [13]
			"4407:3841:17555", -- [14]
			"6706:34378:4267:22931", -- [15]
			"6706:34378:4267:22935", -- [16]
			"40966:41383:41580:40367:40358", -- [17]
			"4407:34374", -- [18]
			"4407:33253", -- [19]
			"6706:34378", -- [20]
			"6706:35137", -- [21]
			"6706:35136", -- [22]
			"6706:35138", -- [23]
			"35478:35556", -- [24]
			"40966:41383:15177:39175", -- [25]
			"6706:35136:39210", -- [26]
			"6706:35136:39210:39212", -- [27]
			"6706:35136:39210:39211", -- [28]
			"4407:3841:3838:40552:40553", -- [29]
			"4407:3841:3838:40552", -- [30]
			"40966:41383:41580:40367:40768", -- [31]
			"40966:41383:15177:48274:48275:40827", -- [32]
			"40966:41383:15177:39175:7823:41214", -- [33]
			"6706:35138:41240", -- [34]
			"6706:34378:4267:22935:43549:50084", -- [35]
			"6706:34378:4267:22935:43549:50084:53783", -- [36]
			"6706:34378:4267:22935:43549:50084:41861", -- [37]
			"40966:41383:41580", -- [38]
			"6706:34378:4267:22931:43073", -- [39]
			"6706:34378:4267:22931:43079", -- [40]
			"6706:34378:4267:22935:43549", -- [41]
			"4407:3841:17555:43991", -- [42]
			"6706:34378:4267:22935:43549:50084:54393", -- [43]
			--["name"] = "Thargad's Camp, Desolace",
			["m"] = 66,
			["f"] = 0,
			["direct"] = "4407:6706:41383:35478:35562:40966",
			["coord"] = 1581758285,
		},
		[3838] = {
			"3841:33253:4267", -- [1]
			"3841:33253:4267:34378:6706:35481:40966:41383:41580:40367", -- [2]
			"3841:33253:4267:16227:4321", -- [3]
			"3841:33253:4407", -- [4]
			"3841:33253:4267:34378:6706", -- [5]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823", -- [6]
			"3841:33253:4267:34378:6706:35481:40966:41383", -- [7]
			"3841:10897", -- [8]
			"3841:12578:11138", -- [9]
			"3841:12578", -- [10]
			"3841:33253:4267:34378:6706:35481:40966:41383:15177", -- [11]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [12]
			"3841:33253:4267:16227", -- [13]
			"17555:17554", -- [14]
			"3841:33253:22931", -- [15]
			"3841:33253:22931:22935", -- [16]
			"3841:33253:4267:34378:39210:39211:40358", -- [17]
			"3841:33253:34374", -- [18]
			"3841:33253", -- [19]
			"3841:33253:4267:34378", -- [20]
			"3841:33253:4267:34378:35137", -- [21]
			"3841:33253:4267:34378:35136", -- [22]
			"3841:33253:4407:35138", -- [23]
			"3841:33253:4267:34378:6706:35481", -- [24]
			"3841:33253:4267:34378:6706:35478", -- [25]
			"3841:33253:4267:34378:6706:35556", -- [26]
			"3841:33253:4267:34378:6706:35562", -- [27]
			"3841:33253:4267:34378:6706:35481:40966:41383:15177:39175", -- [28]
			"3841:33253:4267:34378:39210", -- [29]
			"3841:33253:4267:34378:39210:39212", -- [30]
			"3841:33253:4267:34378:39210:39211", -- [31]
			"40552:40553", -- [32]
			"3841:33253:4267:34378:39210:39211:40358:40768", -- [33]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [34]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [35]
			"3841:33253:4407:41240", -- [36]
			"3841:10897:41861:50084", -- [37]
			"3841:10897:41861:53783", -- [38]
			"3841:10897:41861", -- [39]
			"3841:33253:4267:34378:6706:35481:40966", -- [40]
			"3841:33253:4267:34378:6706:35481:40966:41383:41580", -- [41]
			"3841:12578:43073", -- [42]
			"3841:33253:43079", -- [43]
			"3841:10897:41861:50084:43549", -- [44]
			"17555:43991", -- [45]
			"3841:10897:41861:50084:54393", -- [46]
			--["name"] = "Rut'theran Village, Teldrassil",
			["m"] = 57,
			["coord"] = 2379211371,
			["direct"] = "3841:17555:40552",
			["f"] = 0,
		},
		[48274] = {
			"15177:41383:3841", -- [1]
			"15177:41383:3841:3838", -- [2]
			"15177:41383:6706:34378:4267", -- [3]
			"15177:41383:41580:40367", -- [4]
			"15177:39175:7823:4321", -- [5]
			"15177:41383:35138:4407", -- [6]
			"15177:41383:6706", -- [7]
			"15177:39175:7823", -- [8]
			"15177:41383", -- [9]
			"15177:41383:3841:10897", -- [10]
			"15177:41383:6706:34378:4267:22931:12578:11138", -- [11]
			"15177:41383:6706:34378:4267:22931:12578", -- [12]
			"15177:39175:10583", -- [13]
			"15177:39175:7823:16227", -- [14]
			"15177:41383:3841:17555:17554", -- [15]
			"15177:41383:3841:17555", -- [16]
			"15177:41383:6706:34378:4267:22931", -- [17]
			"15177:41383:6706:34378:4267:22935", -- [18]
			"15177:39175:7823:40768:40358", -- [19]
			"15177:41383:35138:4407:34374", -- [20]
			"15177:41383:35138:4407:33253", -- [21]
			"15177:41383:6706:34378", -- [22]
			"15177:41383:6706:35137", -- [23]
			"15177:41383:6706:35136", -- [24]
			"15177:41383:35138", -- [25]
			"15177:41383:40966:35481", -- [26]
			"15177:41383:40966:35481:35478", -- [27]
			"15177:41383:40966:35481:35478:35556", -- [28]
			"15177:41383:40966:35481:35562", -- [29]
			"15177:39175", -- [30]
			"15177:39175:7823:40768:40358:39211:39210", -- [31]
			"15177:39175:7823:4321:39212", -- [32]
			"15177:39175:7823:40768:40358:39211", -- [33]
			"15177:41383:3841:3838:40552:40553", -- [34]
			"15177:41383:3841:3838:40552", -- [35]
			"15177:39175:7823:40768", -- [36]
			"48275:40827", -- [37]
			"48275:40827:41214", -- [38]
			"15177:41383:35138:41240", -- [39]
			"15177:41383:6706:34378:4267:22935:43549:50084", -- [40]
			"15177:41383:6706:34378:4267:22935:43549:50084:53783", -- [41]
			"15177:41383:6706:34378:4267:22935:43549:50084:41861", -- [42]
			"15177:41383:40966", -- [43]
			"15177:41383:41580", -- [44]
			"15177:41383:6706:34378:4267:22931:43073", -- [45]
			"15177:41383:6706:34378:4267:22931:43079", -- [46]
			"15177:41383:6706:34378:4267:22935:43549", -- [47]
			"15177:41383:3841:17555:43991", -- [48]
			"15177:41383:6706:34378:4267:22935:43549:50084:54393", -- [49]
			--["name"] = "Oasis of Vir'sar, Uldum",
			["m"] = 249,
			["f"] = 0,
			["direct"] = "15177:48275:48273",
			["coord"] = 1142756747,
		},
		[48275] = {
			"48274:15177:41383:3841", -- [1]
			"48274:15177:41383:3841:3838", -- [2]
			"48274:15177:41383:6706:34378:4267", -- [3]
			"48274:15177:41383:41580:40367", -- [4]
			"40827:7823:4321", -- [5]
			"48274:15177:41383:35138:4407", -- [6]
			"48274:15177:41383:6706", -- [7]
			"40827:7823", -- [8]
			"48274:15177:41383", -- [9]
			"48274:15177:41383:3841:10897", -- [10]
			"48274:15177:41383:6706:34378:4267:22931:12578:11138", -- [11]
			"48274:15177:41383:6706:34378:4267:22931:12578", -- [12]
			"48274:15177", -- [13]
			"48274:15177:39175:10583", -- [14]
			"40827:7823:16227", -- [15]
			"48274:15177:41383:3841:17555:17554", -- [16]
			"48274:15177:41383:3841:17555", -- [17]
			"48274:15177:41383:6706:34378:4267:22931", -- [18]
			"48274:15177:41383:6706:34378:4267:22935", -- [19]
			"40827:7823:40768:40358", -- [20]
			"48274:15177:41383:35138:4407:34374", -- [21]
			"48274:15177:41383:35138:4407:33253", -- [22]
			"48274:15177:41383:6706:34378", -- [23]
			"48274:15177:41383:6706:35137", -- [24]
			"40827:7823:40768:40358:39211:39210:35136", -- [25]
			"48274:15177:41383:35138", -- [26]
			"48274:15177:41383:40966:35481", -- [27]
			"48274:15177:41383:40966:35481:35478", -- [28]
			"48274:15177:41383:40966:35481:35478:35556", -- [29]
			"48274:15177:41383:40966:35481:35562", -- [30]
			"48274:15177:39175", -- [31]
			"40827:7823:40768:40358:39211:39210", -- [32]
			"40827:7823:4321:39212", -- [33]
			"40827:7823:40768:40358:39211", -- [34]
			"48274:15177:41383:3841:3838:40552:40553", -- [35]
			"48274:15177:41383:3841:3838:40552", -- [36]
			"40827:7823:40768", -- [37]
			"40827:41214", -- [38]
			"48274:15177:41383:35138:41240", -- [39]
			"48274:15177:41383:6706:34378:4267:22935:43549:50084", -- [40]
			"48274:15177:41383:6706:34378:4267:22935:43549:50084:53783", -- [41]
			"48274:15177:41383:6706:34378:4267:22935:43549:50084:41861", -- [42]
			"48274:15177:41383:40966", -- [43]
			"48274:15177:41383:41580", -- [44]
			"48274:15177:41383:6706:34378:4267:22931:43073", -- [45]
			"48274:15177:41383:6706:34378:4267:22931:43079", -- [46]
			"48274:15177:41383:6706:34378:4267:22935:43549", -- [47]
			"48274:15177:41383:3841:17555:43991", -- [48]
			"48274:15177:41383:6706:34378:4267:22935:43549:50084:54393", -- [49]
			--["name"] = "Ramkahen, Uldum",
			["m"] = 249,
			["coord"] = 2416399851,
			["direct"] = "40827:48274:48273",
			["f"] = 0,
		},
		[48273] = {
			"48274:15177:41383:3841", -- [1]
			"48274:15177:41383:3841:3838", -- [2]
			"48274:15177:41383:6706:34378:4267", -- [3]
			"48274:15177:41383:41580:40367", -- [4]
			"48275:40827:7823:4321", -- [5]
			"48274:15177:41383:35138:4407", -- [6]
			"48274:15177:41383:6706", -- [7]
			"48275:40827:7823", -- [8]
			"48274:15177:41383", -- [9]
			"48274:15177:41383:3841:10897", -- [10]
			"48274:15177:41383:6706:34378:4267:22931:12578:11138", -- [11]
			"48274:15177:41383:6706:34378:4267:22931:12578", -- [12]
			"48274:15177", -- [13]
			"48274:15177:39175:10583", -- [14]
			"48275:40827:7823:16227", -- [15]
			"48274:15177:41383:3841:17555:17554", -- [16]
			"48274:15177:41383:3841:17555", -- [17]
			"48274:15177:41383:6706:34378:4267:22931", -- [18]
			"48274:15177:41383:6706:34378:4267:22935", -- [19]
			"48275:40827:7823:40768:40358", -- [20]
			"48274:15177:41383:35138:4407:34374", -- [21]
			"48274:15177:41383:35138:4407:33253", -- [22]
			"48274:15177:41383:6706:34378", -- [23]
			"48274:15177:41383:6706:35137", -- [24]
			"48274:15177:41383:6706:35136", -- [25]
			"48274:15177:41383:35138", -- [26]
			"48274:15177:41383:40966:35481", -- [27]
			"48274:15177:41383:40966:35481:35478", -- [28]
			"48274:15177:41383:40966:35481:35478:35556", -- [29]
			"48274:15177:41383:40966:35481:35562", -- [30]
			"48274:15177:39175", -- [31]
			"48275:40827:7823:40768:40358:39211:39210", -- [32]
			"48275:40827:7823:4321:39212", -- [33]
			"48275:40827:7823:40768:40358:39211", -- [34]
			"48274:15177:41383:3841:3838:40552:40553", -- [35]
			"48274:15177:41383:3841:3838:40552", -- [36]
			"48275:40827:7823:40768", -- [37]
			"48275:40827", -- [38]
			"48275:40827:41214", -- [39]
			"48274:15177:41383:35138:41240", -- [40]
			"48274:15177:41383:6706:34378:4267:22935:43549:50084", -- [41]
			"48274:15177:41383:6706:34378:4267:22935:43549:50084:53783", -- [42]
			"48274:15177:41383:6706:34378:4267:22935:43549:50084:41861", -- [43]
			"48274:15177:41383:40966", -- [44]
			"48274:15177:41383:41580", -- [45]
			"48274:15177:41383:6706:34378:4267:22931:43073", -- [46]
			"48274:15177:41383:6706:34378:4267:22931:43079", -- [47]
			"48274:15177:41383:6706:34378:4267:22935:43549", -- [48]
			"48274:15177:41383:3841:17555:43991", -- [49]
			"48274:15177:41383:6706:34378:4267:22935:43549:50084:54393", -- [50]
			["direct"] = "48275:48274",
			["coord"] = 958375507,
			["m"] = 249,
			["f"] = 0,
		},
	}, -- [1]
	{
		[236112] = {
		"236116:236115:236113",
		"236116:236115",
		"236116:236117",
		--["name"] = "Town Center, Founder's Point",
		["m"] = 2352,
		["coord"] = 2202166596,
		["direct"] = "236116",
		["f"] = 0,
		},
		[236113] = {
		--["name"] = "Mear's Farm, Founder's Point",
		["m"] = 2352,
		["coord"] = 1486837655,
		["f"] = 0,
		},
		[236118] = {
		"236116:236115:236113",
		"236116:236115",
		--["name"] = "Brumewood Hollow, Founder's Point",
		["direct"] = "236112:236116:236117:236119",
		["coord"] = 2419102865,
		["m"] = 2352,
		["f"] = 0,
		},
		[236115] = {
		--["name"] = "The Outer Banks, Founder's Point",
		["direct"] = "236113",
		["coord"] = 1391031651,
		["m"] = 2352,
		["f"] = 0,
		},
		[236116] = {
		--["name"] = "Small Aerie, Founder's Point",
		["direct"] = "236113:236115:236117",
		["coord"] = 1860596469,
		["m"] = 2352,
		["f"] = 0,
		},
		[236117] = {
		--["name"] = "Gilded Oaks, Founder's Point",
		["direct"] = "236113:236115",
		["coord"] = 1634640041,
		["m"] = 2352,
		["f"] = 0,
		},
		[236111] = {
		"236112:236116:236115",
		"236112:236116",
		"236112:236116:236117",
		["direct"] = "236112:236113:236118:236119",
		["coord"] = 2432648872,
		["m"] = 2352,
		["f"] = 0,
		},
		[236119] = {
		"236112:236116:236115:236113",
		"236112:236116:236115",
		"236112:236116",
		"236118:236117",
		--["name"] = "Stoneveil Ridge, Founder's Point",
		["m"] = 2352,
		["coord"] = 2735237631,
		["direct"] = "236112",
		["f"] = 0,
		},
	[1573] = {
			"2941:352:523", -- [1]
			"2941:2299:931", -- [2]
			"2941:2299:931:2409", -- [3]
			"2941:352:2859", -- [4]
			"2941:2299", -- [5]
			"12596:46011:47875:44233", -- [6]
			"12617:44230:28621", -- [7]
			"12617:44230", -- [8]
			"12596:37888:44232", -- [9]
			"2941:352:43045", -- [10]
			"12596:37888", -- [11]
			"1571:41323", -- [12]
			"1571:41323:41322", -- [13]
			"1571:41323:41325", -- [14]
			"1572:41321", -- [15]
			"1572:41332", -- [16]
			"2941:352:42983", -- [17]
			"2941:352:523:42426", -- [18]
			"2941:352:42406", -- [19]
			"2941:2299:931:43000", -- [20]
			"2941:352:43045:43042", -- [21]
			"2941:352:43045:43042:43043", -- [22]
			"2941:2299:43086:43072", -- [23]
			"2941:2299:43086:43087", -- [24]
			"2941:2299:43086", -- [25]
			"2941:2299:931:43088", -- [26]
			"2941:2299:931:43371", -- [27]
			"2835:43570", -- [28]
			"2941:352:523:43697", -- [29]
			"12617:44231", -- [30]
			"1572:44409", -- [31]
			"1572:44409:44410", -- [32]
			"1572:44409:44407", -- [33]
			"12596:46006", -- [34]
			"12596:46011", -- [35]
			"1572:47119", -- [36]
			"47121:47154:47118", -- [37]
			"1572:47119:47147", -- [38]
			"47121:47154", -- [39]
			"47121:47154:47155", -- [40]
			"12596:46011:47875", -- [41]
			"2941:47927", -- [42]
			"2941:47927:48318", -- [43]
			"2941:47927:48318:48321", -- [44]
			--["name"] = "Ironforge, Dun Morogh",
			["m"] = 87,
			["coord"] = 2400090763,
			["direct"] = "352:1571:1572:2835:8018:12596:12617:2941:26560:43701:43702:47121",
			["f"] = 0,
		},
		[2941] = {
			"352:523", -- [1]
			"2299:931", -- [2]
			"1573:1571", -- [3]
			"2299:931:2409", -- [4]
			"1572:41321:41322:41325:2835", -- [5]
			"352:2859", -- [6]
			"1572:41321:41322:41325:2835:8018", -- [7]
			"1573:12596", -- [8]
			"1572:41321:41322:41325:2835:43570:12617", -- [9]
			"1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [10]
			"1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [11]
			"1572:41321:41322:41325:2835:43570:12617:44230", -- [12]
			"1573:12596:37888:44232", -- [13]
			"352:43045", -- [14]
			"1573:26560", -- [15]
			"1573:12596:37888", -- [16]
			"1572:41321:41322:41323", -- [17]
			"1572:41321:41322", -- [18]
			"1572:41321:41322:41325", -- [19]
			"1572:41321", -- [20]
			"1572:41332", -- [21]
			"352:42983", -- [22]
			"352:523:42426", -- [23]
			"352:42406", -- [24]
			"2299:931:43000", -- [25]
			"352:43045:43042", -- [26]
			"352:43045:43042:43043", -- [27]
			"2299:43086:43072", -- [28]
			"2299:43086:43087", -- [29]
			"2299:43086", -- [30]
			"2299:931:43088", -- [31]
			"2299:931:43371", -- [32]
			"1572:41321:41322:41325:2835:43570", -- [33]
			"1573:43701", -- [34]
			"1572:43702", -- [35]
			"352:523:43697", -- [36]
			"1572:41321:41322:41325:2835:43570:12617:44231", -- [37]
			"1572:44409", -- [38]
			"2299:44410", -- [39]
			"1572:44409:44407", -- [40]
			"1573:12596:46006", -- [41]
			"1573:12596:46011", -- [42]
			"1572:41321:41322:47121", -- [43]
			"1572:47119", -- [44]
			"1572:41321:41322:47121:47154:47118", -- [45]
			"1572:47119:47147", -- [46]
			"1572:41321:41322:47121:47154", -- [47]
			"1572:41321:41322:47121:47154:47155", -- [48]
			"1573:12596:46011:47875", -- [49]
			"47927:48318", -- [50]
			"47927:48318:48321", -- [51]
			--["name"] = "Thorium Point, Searing Gorge",
			["m"] = 32,
			["coord"] = 1628458635,
			["direct"] = "352:1573:1572:2299:47927",
			["f"] = 0,
		},
		[47154] = {
			"47121:41322:41321:1572:2941:352", -- [1]
			"47121:41322:41321:1572:2941:352:523", -- [2]
			"47121:41322:41321:1572:44409:44410:2299:931", -- [3]
			"47121:41322:41323:1571:1573", -- [4]
			"47121:41322:41323:1571", -- [5]
			"47121:41322:41321:1572", -- [6]
			"47121:41322:41321:1572:44409:44410:2299:931:2409", -- [7]
			"47121:2835", -- [8]
			"47121:41322:41321:1572:2941:352:2859", -- [9]
			"47121:2835:8018", -- [10]
			"47121:2835:8018:12596", -- [11]
			"47121:2835:43570:12617", -- [12]
			"47121:41322:41321:1572:44409:44410:2299", -- [13]
			"47121:41322:41321:1572:2941", -- [14]
			"47121:2835:43570:12617:44230:44233", -- [15]
			"47121:2835:43570:12617:44230:28621", -- [16]
			"47121:2835:43570:12617:44230", -- [17]
			"47121:2835:43570:12617:44231:44232", -- [18]
			"47121:41322:41321:1572:2941:352:43045", -- [19]
			"47121:2835:43570:12617:26560", -- [20]
			"47121:2835:8018:12596:37888", -- [21]
			"47121:41322:41323", -- [22]
			"47121:41322", -- [23]
			"47121:41322:41325", -- [24]
			"47121:41322:41321", -- [25]
			"47121:41322:41321:1572:41332", -- [26]
			"47121:41322:41321:1572:2941:352:42983", -- [27]
			"47121:41322:41321:1572:2941:352:523:42426", -- [28]
			"47121:41322:41321:1572:2941:352:42406", -- [29]
			"47121:41322:41321:1572:44409:44410:2299:931:43000", -- [30]
			"47121:41322:41321:1572:2941:352:43045:43042", -- [31]
			"47121:41322:41321:1572:2941:352:43045:43042:43043", -- [32]
			"47121:41322:41321:1572:44409:44410:2299:43086:43072", -- [33]
			"47121:41322:41321:1572:44409:44410:2299:43086:43087", -- [34]
			"47121:41322:41321:1572:44409:44410:2299:43086", -- [35]
			"47121:41322:41321:1572:44409:44410:2299:931:43088", -- [36]
			"47121:41322:41321:1572:44409:44410:2299:931:43371", -- [37]
			"47121:2835:43570", -- [38]
			"47121:41322:41321:1572:43702:43701", -- [39]
			"47121:41322:41321:1572:43702", -- [40]
			"47121:41322:41321:1572:2941:352:523:43697", -- [41]
			"47121:2835:43570:12617:44231", -- [42]
			"47121:41322:41321:1572:44409", -- [43]
			"47121:41322:41321:1572:44409:44410", -- [44]
			"47121:41322:41321:1572:44409:44407", -- [45]
			"47121:2835:8018:46006", -- [46]
			"47121:2835:8018:46006:46011", -- [47]
			"47147:47119", -- [48]
			"47121:2835:8018:46006:46011:47875", -- [49]
			"47121:41322:41321:1572:2941:47927", -- [50]
			"47121:41322:41321:1572:2941:47927:48318", -- [51]
			"47121:41322:41321:1572:2941:47927:48318:48321", -- [52]
			--["name"] = "Thundermar, Twilight Highlands",
			["m"] = 241,
			["coord"] = 2084522004,
			["direct"] = "47121:47118:47147:47155",
			["f"] = 0,
		},
		[523] = {
			"352:1573", -- [1]
			"352:1573:1571", -- [2]
			"352:2941:1572", -- [3]
			"352:2941:1572:41321:41322:41325:2835", -- [4]
			"352:2941:1572:41321:41322:41325:2835:8018", -- [5]
			"352:1573:12596", -- [6]
			"352:2941:1572:41321:41322:41325:2835:43570:12617", -- [7]
			"931:2299", -- [8]
			"352:2941", -- [9]
			"352:2941:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [10]
			"352:2941:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [11]
			"352:2941:1572:41321:41322:41325:2835:43570:12617:44230", -- [12]
			"352:1573:12596:37888:44232", -- [13]
			"352:1573:26560", -- [14]
			"352:1573:12596:37888", -- [15]
			"352:2941:1572:41321:41322:41323", -- [16]
			"352:2941:1572:41321:41322", -- [17]
			"352:2941:1572:41321:41322:41325", -- [18]
			"352:2941:1572:41321", -- [19]
			"931:2299:44410:44407:41332", -- [20]
			"352:42983", -- [21]
			"931:43000", -- [22]
			"43045:43042", -- [23]
			"43045:43042:43043", -- [24]
			"931:43371:43072", -- [25]
			"931:43088:43087", -- [26]
			"931:43371:43072:43086", -- [27]
			"931:43088", -- [28]
			"931:43371", -- [29]
			"352:2941:1572:41321:41322:41325:2835:43570", -- [30]
			"352:1573:43701", -- [31]
			"352:2941:1572:43702", -- [32]
			"352:2941:1572:41321:41322:41325:2835:43570:12617:44231", -- [33]
			"931:2299:44410:44409", -- [34]
			"931:2299:44410", -- [35]
			"931:2299:44410:44407", -- [36]
			"352:1573:12596:46006", -- [37]
			"352:1573:12596:46011", -- [38]
			"352:2941:1572:41321:41322:47121", -- [39]
			"352:2941:1572:47119", -- [40]
			"352:2941:1572:41321:41322:47121:47154:47118", -- [41]
			"352:2941:1572:47119:47147", -- [42]
			"352:2941:1572:41321:41322:47121:47154", -- [43]
			"352:2941:1572:41321:41322:47121:47154:47155", -- [44]
			"352:1573:12596:46011:47875", -- [45]
			"352:2941:47927", -- [46]
			"931:2299:48321:48318", -- [47]
			"931:2299:48321", -- [48]
			--["name"] = "Sentinel Hill, Westfall",
			["m"] = 52,
			["coord"] = 2432532065,
			["direct"] = "352:931:2409:2859:43045:42426:42406:43697",
			["f"] = 0,
		},
		[43000] = {
			"42983:352", -- [1]
			"42983:352:523", -- [2]
			"931:2299:2941:1573", -- [3]
			"931:2299:44410:44409:1572:1571", -- [4]
			"931:2299:44410:44409:1572", -- [5]
			"931:2409", -- [6]
			"931:2299:44410:44409:1572:41321:41322:41325:2835", -- [7]
			"931:2409:43045:2859", -- [8]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [9]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [10]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [11]
			"931:2299", -- [12]
			"931:2299:2941", -- [13]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [14]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [15]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [16]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [17]
			"931:2409:43045", -- [18]
			"931:2299:2941:1573:26560", -- [19]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [20]
			"931:2299:44410:44409:1572:41321:41322:41323", -- [21]
			"931:2299:44410:44409:1572:41321:41322", -- [22]
			"931:2299:44410:44409:1572:41321:41322:41325", -- [23]
			"931:2299:44410:44409:1572:41321", -- [24]
			"931:2299:44410:44407:41332", -- [25]
			"42983:352:523:42426", -- [26]
			"42983:352:42406", -- [27]
			"931:2409:43045:43042", -- [28]
			"931:2409:43045:43042:43043", -- [29]
			"931:43371:43072", -- [30]
			"931:43088:43087", -- [31]
			"931:43371:43072:43086", -- [32]
			"931:43088", -- [33]
			"931:43371", -- [34]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [35]
			"931:2299:44410:44409:1572:43702:43701", -- [36]
			"931:2299:44410:44409:1572:43702", -- [37]
			"931:2409:43697", -- [38]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [39]
			"931:2299:44410:44409", -- [40]
			"931:2299:44410", -- [41]
			"931:2299:44410:44407", -- [42]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [43]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [44]
			"931:2299:44410:44409:1572:41321:41322:47121", -- [45]
			"931:2299:44410:44409:1572:47119", -- [46]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [47]
			"931:2299:44410:44409:1572:47119:47147", -- [48]
			"931:2299:44410:44409:1572:41321:41322:47121:47154", -- [49]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [50]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [51]
			"931:2299:48321:48318:47927", -- [52]
			"931:2299:48321:48318", -- [53]
			"931:2299:48321", -- [54]
			--["name"] = "Eastvale Logging Camp, Elwynn",
			["m"] = 37,
			["coord"] = 3515853316,
			["direct"] = "931:42983",
			["f"] = 0,
		},
		[43697] = {
			"523:352", -- [1]
			"2409:931", -- [2]
			"523:352:1573", -- [3]
			"523:352:1573:1571", -- [4]
			"2409:931:2299:44410:44409:1572", -- [5]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835", -- [6]
			"43045:2859", -- [7]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [8]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [9]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [10]
			"2409:931:2299", -- [11]
			"523:352:2941", -- [12]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [13]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [14]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [15]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [16]
			"523:352:1573:26560", -- [17]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [18]
			"2409:931:2299:44410:44409:1572:41321:41322:41323", -- [19]
			"2409:931:2299:44410:44409:1572:41321:41322", -- [20]
			"2409:931:2299:44410:44409:1572:41321:41322:41325", -- [21]
			"2409:931:2299:44410:44409:1572:41321", -- [22]
			"2409:931:2299:44410:44407:41332", -- [23]
			"2409:42983", -- [24]
			"523:42426", -- [25]
			"523:42406", -- [26]
			"2409:931:43000", -- [27]
			"43045:43042", -- [28]
			"43045:43042:43043", -- [29]
			"2409:931:43371:43072", -- [30]
			"2409:85731:43087", -- [31]
			"2409:931:43371:43072:43086", -- [32]
			"2409:931:43088", -- [33]
			"2409:931:43371", -- [34]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [35]
			"2409:931:2299:44410:44409:1572:43702:43701", -- [36]
			"2409:931:2299:44410:44409:1572:43702", -- [37]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [38]
			"2409:931:2299:44410:44409", -- [39]
			"2409:931:2299:44410", -- [40]
			"2409:931:2299:44410:44407", -- [41]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [42]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [43]
			"2409:931:2299:44410:44409:1572:41321:41322:47121", -- [44]
			"2409:931:2299:44410:44409:1572:47119", -- [45]
			"2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [46]
			"2409:931:2299:44410:44409:1572:47119:47147", -- [47]
			"2409:931:2299:44410:44409:1572:41321:41322:47121:47154", -- [48]
			"2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [49]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [50]
			"2409:931:2299:48321:48318:47927", -- [51]
			"2409:931:2299:48321:48318", -- [52]
			"2409:931:2299:48321", -- [53]
			--["name"] = "Raven Hill, Duskwood",
			["m"] = 47,
			["coord"] = 903778573,
			["direct"] = "523:2409:43045",
			["f"] = 0,
		},
		[43087] = {
			"43088:931:352", -- [1]
			"43088:931:523", -- [2]
			"43088:931", -- [3]
			"43086:2299:2941:1573", -- [4]
			"43086:2299:44410:44409:1572:1571", -- [5]
			"43086:2299:44410:44409:1572", -- [6]
			"85731:2409", -- [7]
			"43086:2299:44410:44409:1572:41321:41322:41325:2835", -- [8]
			"85731:43045:2859", -- [9]
			"43086:2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [10]
			"43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [11]
			"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [12]
			"43086:2299", -- [13]
			"43086:2299:2941", -- [14]
			"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [15]
			"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [16]
			"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [17]
			"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [18]
			"85731:43045", -- [19]
			"43086:2299:2941:1573:26560", -- [20]
			"43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [21]
			"43086:2299:44410:44409:1572:41321:41322:41323", -- [22]
			"43086:2299:44410:44409:1572:41321:41322", -- [23]
			"43086:2299:44410:44409:1572:41321:41322:41325", -- [24]
			"43086:2299:44410:44409:1572:41321", -- [25]
			"43086:2299:44410:44407:41332", -- [26]
			"43088:931:43000:42983", -- [27]
			"43088:931:523:42426", -- [28]
			"43088:931:352:42406", -- [29]
			"43088:931:43000", -- [30]
			"85731:43045:43042", -- [31]
			"85731:43045:43042:43043", -- [32]
			"43086:43072", -- [33]
			"43086:43072:43371", -- [34]
			"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [35]
			"43086:2299:44410:44409:1572:43702:43701", -- [36]
			"43086:2299:44410:44409:1572:43702", -- [37]
			"85731:2409:43697", -- [38]
			"43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [39]
			"43086:2299:44410:44409", -- [40]
			"43086:2299:44410", -- [41]
			"43086:2299:44410:44407", -- [42]
			"43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [43]
			"43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [44]
			"43086:2299:44410:44409:1572:41321:41322:47121", -- [45]
			"43086:2299:44410:44409:1572:47119", -- [46]
			"43086:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [47]
			"43086:2299:44410:44409:1572:47119:47147", -- [48]
			"43086:2299:44410:44409:1572:41321:41322:47121:47154", -- [49]
			"43086:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [50]
			"43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [51]
			"43086:2299:48321:48318:47927", -- [52]
			"43086:2299:48321:48318", -- [53]
			"43086:2299:48321", -- [54]
			["direct"] = "43086:43088:85731",
			["m"] = 51,
			["coord"] = 3005506078,
			["f"] = 0,
		},
		[43701] = {
			"1573:2941:352", -- [1]
			"1573:2941:352:523", -- [2]
			"1573:2941:2299:931", -- [3]
			"1573:1571", -- [4]
			"43702:1572", -- [5]
			"1573:2941:2299:931:2409", -- [6]
			"1573:2835", -- [7]
			"1573:2941:352:2859", -- [8]
			"1573:8018", -- [9]
			"1573:12596", -- [10]
			"1573:12617", -- [11]
			"1573:2941:2299", -- [12]
			"1573:2941", -- [13]
			"1573:12596:46011:47875:44233", -- [14]
			"1573:12617:44230:28621", -- [15]
			"1573:12617:44230", -- [16]
			"1573:12596:37888:44232", -- [17]
			"1573:2941:352:43045", -- [18]
			"1573:26560", -- [19]
			"1573:12596:37888", -- [20]
			"1573:1571:41323", -- [21]
			"43702:1572:41321:41322", -- [22]
			"43702:1572:41321:41322:41325", -- [23]
			"43702:1572:41321", -- [24]
			"43702:1572:41332", -- [25]
			"1573:2941:352:42983", -- [26]
			"1573:2941:352:523:42426", -- [27]
			"1573:2941:352:42406", -- [28]
			"1573:2941:2299:931:43000", -- [29]
			"1573:2941:352:43045:43042", -- [30]
			"1573:2941:352:43045:43042:43043", -- [31]
			"1573:2941:2299:43086:43072", -- [32]
			"1573:2941:2299:43086:43087", -- [33]
			"1573:2941:2299:43086", -- [34]
			"1573:2941:2299:931:43088", -- [35]
			"1573:2941:2299:931:43371", -- [36]
			"1573:2835:43570", -- [37]
			"1573:2941:352:523:43697", -- [38]
			"1573:12617:44231", -- [39]
			"43702:1572:44409", -- [40]
			"43702:1572:44409:44410", -- [41]
			"43702:1572:44409:44407", -- [42]
			"1573:12596:46006", -- [43]
			"1573:12596:46011", -- [44]
			"43702:1572:41321:41322:47121", -- [45]
			"43702:1572:47119", -- [46]
			"43702:1572:41321:41322:47121:47154:47118", -- [47]
			"43702:1572:47119:47147", -- [48]
			"43702:1572:41321:41322:47121:47154", -- [49]
			"43702:1572:41321:41322:47121:47154:47155", -- [50]
			"1573:12596:46011:47875", -- [51]
			"1573:2941:47927", -- [52]
			"1573:2941:47927:48318", -- [53]
			"1573:2941:47927:48318:48321", -- [54]
			--["name"] = "Kharanos, Dun Morogh",
			["m"] = 27,
			["coord"] = 2308343503,
			["direct"] = "1573:43702",
			["f"] = 0,
		},
		[46006] = {
			"12596:1573:2941:352", -- [1]
			"12596:1573:2941:352:523", -- [2]
			"12596:1573:2941:2299:931", -- [3]
			"12596:1573", -- [4]
			"8018:2835:1571", -- [5]
			"8018:2835:1572", -- [6]
			"12596:1573:2941:2299:931:2409", -- [7]
			"8018:2835", -- [8]
			"12596:1573:2941:352:2859", -- [9]
			"46011:37888:12617", -- [10]
			"12596:1573:2941:2299", -- [11]
			"12596:1573:2941", -- [12]
			"46011:47875:44233", -- [13]
			"46011:37888:44232:28621", -- [14]
			"46011:37888:44232:44231:44230", -- [15]
			"46011:37888:44232", -- [16]
			"12596:1573:2941:352:43045", -- [17]
			"46011:37888:12617:26560", -- [18]
			"46011:37888", -- [19]
			"8018:2835:41325:41323", -- [20]
			"8018:2835:41325:41322", -- [21]
			"8018:2835:41325", -- [22]
			"8018:2835:41325:41322:41321", -- [23]
			"8018:2835:1572:41332", -- [24]
			"12596:1573:2941:352:42983", -- [25]
			"12596:1573:2941:352:523:42426", -- [26]
			"12596:1573:2941:352:42406", -- [27]
			"12596:1573:2941:2299:931:43000", -- [28]
			"12596:1573:2941:352:43045:43042", -- [29]
			"12596:1573:2941:352:43045:43042:43043", -- [30]
			"12596:1573:2941:2299:43086:43072", -- [31]
			"12596:1573:2941:2299:43086:43087", -- [32]
			"12596:1573:2941:2299:43086", -- [33]
			"12596:1573:2941:2299:931:43088", -- [34]
			"12596:1573:2941:2299:931:43371", -- [35]
			"8018:43570", -- [36]
			"12596:1573:43701", -- [37]
			"12596:1573:43702", -- [38]
			"12596:1573:2941:352:523:43697", -- [39]
			"46011:37888:44232:44231", -- [40]
			"8018:2835:1572:44409", -- [41]
			"8018:2835:1572:44409:44410", -- [42]
			"8018:2835:1572:44409:44407", -- [43]
			"8018:2835:47121", -- [44]
			"8018:2835:47121:47154:47147:47119", -- [45]
			"8018:2835:47121:47154:47118", -- [46]
			"8018:2835:47121:47154:47147", -- [47]
			"8018:2835:47121:47154", -- [48]
			"8018:2835:47121:47154:47155", -- [49]
			"46011:47875", -- [50]
			"12596:1573:2941:47927", -- [51]
			"12596:1573:2941:47927:48318", -- [52]
			"12596:1573:2941:47927:48318:48321", -- [53]
			--["name"] = "Andorhal, Western Plaguelands",
			["m"] = 22,
			["coord"] = 1696575982,
			["direct"] = "8018:12596:46011",
			["f"] = 0,
		},
		[47119] = {
			"1572:2941:352", -- [1]
			"1572:2941:352:523", -- [2]
			"1572:44409:44410:2299:931", -- [3]
			"1572:1573", -- [4]
			"47147:47154:47121:41322:41323:1571", -- [5]
			"1572:44409:44410:2299:931:2409", -- [6]
			"47147:47154:47121:2835", -- [7]
			"1572:2941:352:2859", -- [8]
			"47147:47154:47121:2835:8018", -- [9]
			"47147:47154:47121:2835:8018:12596", -- [10]
			"47147:47154:47121:2835:43570:12617", -- [11]
			"1572:44409:44410:2299", -- [12]
			"1572:2941", -- [13]
			"47147:47154:47121:2835:43570:12617:44230:44233", -- [14]
			"47147:47154:47121:2835:43570:12617:44230:28621", -- [15]
			"47147:47154:47121:2835:43570:12617:44230", -- [16]
			"47147:47154:47121:2835:43570:12617:44231:44232", -- [17]
			"1572:2941:352:43045", -- [18]
			"47147:47154:47121:2835:43570:12617:26560", -- [19]
			"47147:47154:47121:2835:8018:12596:37888", -- [20]
			"47147:47154:47121:41322:41323", -- [21]
			"47147:47154:47121:41322", -- [22]
			"47147:47154:47121:41322:41325", -- [23]
			"1572:41321", -- [24]
			"1572:41332", -- [25]
			"1572:2941:352:42983", -- [26]
			"1572:2941:352:523:42426", -- [27]
			"1572:2941:352:42406", -- [28]
			"1572:44409:44410:2299:931:43000", -- [29]
			"1572:2941:352:43045:43042", -- [30]
			"1572:2941:352:43045:43042:43043", -- [31]
			"1572:44409:44410:2299:43086:43072", -- [32]
			"1572:44409:44410:2299:43086:43087", -- [33]
			"1572:44409:44410:2299:43086", -- [34]
			"1572:44409:44410:2299:931:43088", -- [35]
			"1572:44409:44410:2299:931:43371", -- [36]
			"47147:47154:47121:2835:43570", -- [37]
			"1572:43702:43701", -- [38]
			"1572:43702", -- [39]
			"1572:2941:352:523:43697", -- [40]
			"47147:47154:47121:2835:43570:12617:44231", -- [41]
			"1572:44409", -- [42]
			"1572:44409:44410", -- [43]
			"1572:44409:44407", -- [44]
			"47147:47154:47121:2835:8018:46006", -- [45]
			"47147:47154:47121:2835:8018:46006:46011", -- [46]
			"47147:47154:47121", -- [47]
			"47147:47118", -- [48]
			"47147:47154", -- [49]
			"47147:47154:47121:2835:8018:46006:46011:47875", -- [50]
			"1572:2941:47927", -- [51]
			"1572:2941:47927:48318", -- [52]
			"1572:2941:47927:48318:48321", -- [53]
			--["name"] = "Highbank, Twilight Highlands",
			["m"] = 241,
			["coord"] = 3506423082,
			["direct"] = "1572:47147:47155",
			["f"] = 0,
		},
		[41323] = {
			"41322:41321:1572:2941:352", -- [1]
			"41322:41321:1572:2941:352:523", -- [2]
			"41322:41321:1572:44409:44410:2299:931", -- [3]
			"1571:1573", -- [4]
			"41322:41321:1572", -- [5]
			"41322:41321:1572:44409:44410:2299:931:2409", -- [6]
			"41325:2835", -- [7]
			"41322:41321:1572:2941:352:2859", -- [8]
			"41325:2835:8018", -- [9]
			"41325:2835:8018:12596", -- [10]
			"41325:2835:43570:12617", -- [11]
			"41322:41321:1572:44409:44410:2299", -- [12]
			"41322:41321:1572:2941", -- [13]
			"41325:2835:43570:12617:44230:44233", -- [14]
			"41325:2835:43570:12617:44230:28621", -- [15]
			"41325:2835:43570:12617:44230", -- [16]
			"41325:2835:43570:12617:44231:44232", -- [17]
			"41322:41321:1572:2941:352:43045", -- [18]
			"41325:2835:43570:12617:26560", -- [19]
			"41325:2835:8018:12596:37888", -- [20]
			"41322:41321", -- [21]
			"41322:41321:1572:41332", -- [22]
			"41322:41321:1572:2941:352:42983", -- [23]
			"41322:41321:1572:2941:352:523:42426", -- [24]
			"41322:41321:1572:2941:352:42406", -- [25]
			"41322:41321:1572:44409:44410:2299:931:43000", -- [26]
			"41322:41321:1572:2941:352:43045:43042", -- [27]
			"41322:41321:1572:2941:352:43045:43042:43043", -- [28]
			"41322:41321:1572:44409:44410:2299:43086:43072", -- [29]
			"41322:41321:1572:44409:44410:2299:43086:43087", -- [30]
			"41322:41321:1572:44409:44410:2299:43086", -- [31]
			"41322:41321:1572:44409:44410:2299:931:43088", -- [32]
			"41322:41321:1572:44409:44410:2299:931:43371", -- [33]
			"41325:2835:43570", -- [34]
			"1571:1573:43701", -- [35]
			"41322:41321:1572:43702", -- [36]
			"41322:41321:1572:2941:352:523:43697", -- [37]
			"41325:2835:43570:12617:44231", -- [38]
			"41322:41321:1572:44409", -- [39]
			"41322:41321:1572:44409:44410", -- [40]
			"41322:41321:1572:44409:44407", -- [41]
			"41325:2835:8018:46006", -- [42]
			"41325:2835:8018:46006:46011", -- [43]
			"41322:47121", -- [44]
			"41322:47121:47154:47147:47119", -- [45]
			"41322:47121:47154:47118", -- [46]
			"41322:47121:47154:47147", -- [47]
			"41322:47121:47154", -- [48]
			"41322:47121:47154:47155", -- [49]
			"41325:2835:8018:46006:46011:47875", -- [50]
			"41322:41321:1572:2941:47927", -- [51]
			"41322:41321:1572:2941:47927:48318", -- [52]
			"41322:41321:1572:2941:47927:48318:48321", -- [53]
			--["name"] = "Whelgar's Retreat, Wetlands",
			["m"] = 56,
			["coord"] = 1661625304,
			["direct"] = "1571:41322:41325",
			["f"] = 0,
		},
		[47121] = {
			"41322:41321:1572:2941:352", -- [1]
			"41322:41321:1572:2941:352:523", -- [2]
			"41322:41321:1572:44409:44410:2299:931", -- [3]
			"41322:41323:1571", -- [4]
			"41322:41321:1572", -- [5]
			"41322:41321:1572:44409:44410:2299:931:2409", -- [6]
			"41322:41321:1572:2941:352:2859", -- [7]
			"2835:8018", -- [8]
			"2835:8018:12596", -- [9]
			"2835:43570:12617", -- [10]
			"41322:41321:1572:44409:44410:2299", -- [11]
			"41322:41321:1572:2941", -- [12]
			"2835:43570:12617:44230:44233", -- [13]
			"2835:43570:12617:44230:28621", -- [14]
			"2835:43570:12617:44230", -- [15]
			"2835:43570:12617:44231:44232", -- [16]
			"41322:41321:1572:2941:352:43045", -- [17]
			"2835:43570:12617:26560", -- [18]
			"2835:8018:12596:37888", -- [19]
			"41322:41323", -- [20]
			"41322:41325", -- [21]
			"41322:41321", -- [22]
			"41322:41321:1572:41332", -- [23]
			"41322:41321:1572:2941:352:42983", -- [24]
			"41322:41321:1572:2941:352:523:42426", -- [25]
			"41322:41321:1572:2941:352:42406", -- [26]
			"41322:41321:1572:44409:44410:2299:931:43000", -- [27]
			"41322:41321:1572:2941:352:43045:43042", -- [28]
			"41322:41321:1572:2941:352:43045:43042:43043", -- [29]
			"41322:41321:1572:44409:44410:2299:43086:43072", -- [30]
			"41322:41321:1572:44409:44410:2299:43086:43087", -- [31]
			"41322:41321:1572:44409:44410:2299:43086", -- [32]
			"41322:41321:1572:44409:44410:2299:931:43088", -- [33]
			"41322:41321:1572:44409:44410:2299:931:43371", -- [34]
			"2835:43570", -- [35]
			"41322:41321:1572:43702:43701", -- [36]
			"41322:41321:1572:43702", -- [37]
			"41322:41321:1572:2941:352:523:43697", -- [38]
			"2835:43570:12617:44231", -- [39]
			"41322:41321:1572:44409", -- [40]
			"41322:41321:1572:44409:44410", -- [41]
			"41322:41321:1572:44409:44407", -- [42]
			"2835:8018:46006", -- [43]
			"2835:8018:46006:46011", -- [44]
			"47154:47147:47119", -- [45]
			"47154:47118", -- [46]
			"47154:47147", -- [47]
			"47154:47155", -- [48]
			"2835:8018:46006:46011:47875", -- [49]
			"41322:41321:1572:2941:47927", -- [50]
			"41322:41321:1572:2941:47927:48318", -- [51]
			"41322:41321:1572:2941:47927:48318:48321", -- [52]
			--["name"] = "Vermillion Redoubt, Twilight Highlands",
			["m"] = 241,
			["coord"] = 1222197197,
			["direct"] = "1573:2835:41322:47154",
			["f"] = 0,
		},
		[12617] = {
			"43570:2835:1572:2941:352", -- [1]
			"44407:44410:2299:931:523", -- [2]
			"44407:44410:2299:931", -- [3]
			"43570:2835:1571", -- [4]
			"43570:2835:1572", -- [5]
			"44407:44410:2299:931:2409", -- [6]
			"43570:2835", -- [7]
			"44407:44410:2299:931:2409:43045:2859", -- [8]
			"44407:44410:2299", -- [9]
			"43570:2835:1572:2941", -- [10]
			"44230:44233", -- [11]
			"44230:28621", -- [12]
			"44231:44232", -- [13]
			"44407:44410:2299:931:2409:43045", -- [14]
			"43570:2835:41325:41323", -- [15]
			"43570:2835:41325:41322", -- [16]
			"43570:2835:41325", -- [17]
			"43570:2835:41325:41322:41321", -- [18]
			"43570:2835:1572:41332", -- [19]
			"43570:2835:1572:2941:352:42983", -- [20]
			"44407:44410:2299:931:523:42426", -- [21]
			"43570:2835:1572:2941:352:42406", -- [22]
			"44407:44410:2299:931:43000", -- [23]
			"44407:44410:2299:931:2409:43045:43042", -- [24]
			"44407:44410:2299:931:2409:43045:43042:43043", -- [25]
			"44407:44410:2299:43086:43072", -- [26]
			"44407:44410:2299:43086:43087", -- [27]
			"44407:44410:2299:43086", -- [28]
			"44407:44410:2299:931:43088", -- [29]
			"44407:44410:2299:931:43371", -- [30]
			"1573:43701", -- [31]
			"43570:2835:1572:43702", -- [32]
			"44407:44410:2299:931:2409:43697", -- [33]
			"44407:44409", -- [34]
			"44407:44410", -- [35]
			"37888:46011:46006", -- [36]
			"37888:46011", -- [37]
			"43570:2835:47121", -- [38]
			"43570:2835:47121:47154:47147:47119", -- [39]
			"43570:2835:47121:47154:47118", -- [40]
			"43570:2835:47121:47154:47147", -- [41]
			"43570:2835:47121:47154", -- [42]
			"43570:2835:47121:47154:47155", -- [43]
			"44230:44233:47875", -- [44]
			"43570:2835:1572:2941:47927", -- [45]
			"43570:2835:1572:2941:47927:48318", -- [46]
			"44407:44410:2299:48321", -- [47]
			--["name"] = "Light's Hope Chapel, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 3258026199,
			["direct"] = "1573:8018:12596:44230:26560:37888:43570:44231:44407",
			["f"] = 0,
		},
		[1571] = {
			"1573:2941:352", -- [1]
			"1573:2941:352:523", -- [2]
			"1573:2941:2299:931", -- [3]
			"1573:2941:2299:931:2409", -- [4]
			"1573:2941:352:2859", -- [5]
			"2835:8018", -- [6]
			"2835:8018:12596", -- [7]
			"2835:43570:12617", -- [8]
			"1573:2941:2299", -- [9]
			"1573:2941", -- [10]
			"2835:43570:12617:44230:44233", -- [11]
			"2835:43570:12617:44230:28621", -- [12]
			"2835:43570:12617:44230", -- [13]
			"2835:43570:12617:44231:44232", -- [14]
			"1573:2941:352:43045", -- [15]
			"2835:43570:12617:26560", -- [16]
			"2835:8018:12596:37888", -- [17]
			"41323:41322", -- [18]
			"41323:41325", -- [19]
			"41323:41322:41321", -- [20]
			"41323:41322:41321:1572:41332", -- [21]
			"1573:2941:352:42983", -- [22]
			"1573:2941:352:523:42426", -- [23]
			"1573:2941:352:42406", -- [24]
			"1573:2941:2299:931:43000", -- [25]
			"1573:2941:352:43045:43042", -- [26]
			"1573:2941:352:43045:43042:43043", -- [27]
			"1573:2941:2299:43086:43072", -- [28]
			"1573:2941:2299:43086:43087", -- [29]
			"1573:2941:2299:43086", -- [30]
			"1573:2941:2299:931:43088", -- [31]
			"1573:2941:2299:931:43371", -- [32]
			"2835:43570", -- [33]
			"1573:43701", -- [34]
			"1573:43702", -- [35]
			"1573:2941:352:523:43697", -- [36]
			"2835:43570:12617:44231", -- [37]
			"41323:41322:41321:1572:44409", -- [38]
			"41323:41322:41321:1572:44409:44410", -- [39]
			"41323:41322:41321:1572:44409:44407", -- [40]
			"2835:8018:46006", -- [41]
			"2835:8018:46006:46011", -- [42]
			"41323:41322:47121", -- [43]
			"41323:41322:47121:47154:47147:47119", -- [44]
			"41323:41322:47121:47154:47118", -- [45]
			"41323:41322:47121:47154:47147", -- [46]
			"41323:41322:47121:47154", -- [47]
			"41323:41322:47121:47154:47155", -- [48]
			"2835:8018:46006:46011:47875", -- [49]
			"1573:2941:47927", -- [50]
			"1573:2941:47927:48318", -- [51]
			"1573:2941:47927:48318:48321", -- [52]
			--["name"] = "Menethil Harbor, Wetlands",
			["m"] = 56,
			["coord"] = 403085391,
			["direct"] = "1573:1572:2835:41323",
			["f"] = 0,
		},
		[41321] = {
			"1572:2941:352", -- [1]
			"1572:2941:352:523", -- [2]
			"1572:44409:44410:2299:931", -- [3]
			"1572:1573", -- [4]
			"41322:41323:1571", -- [5]
			"1572:44409:44410:2299:931:2409", -- [6]
			"41322:41325:2835", -- [7]
			"1572:2941:352:2859", -- [8]
			"41322:41325:2835:8018", -- [9]
			"41322:41325:2835:8018:12596", -- [10]
			"41322:41325:2835:43570:12617", -- [11]
			"1572:44409:44410:2299", -- [12]
			"1572:2941", -- [13]
			"41322:41325:2835:43570:12617:44230:44233", -- [14]
			"41322:41325:2835:43570:12617:44230:28621", -- [15]
			"41322:41325:2835:43570:12617:44230", -- [16]
			"41322:41325:2835:43570:12617:44231:44232", -- [17]
			"1572:2941:352:43045", -- [18]
			"41322:41325:2835:43570:12617:26560", -- [19]
			"41322:41325:2835:8018:12596:37888", -- [20]
			"41322:41323", -- [21]
			"41322:41325", -- [22]
			"1572:41332", -- [23]
			"1572:2941:352:42983", -- [24]
			"1572:2941:352:523:42426", -- [25]
			"1572:2941:352:42406", -- [26]
			"1572:44409:44410:2299:931:43000", -- [27]
			"1572:2941:352:43045:43042", -- [28]
			"1572:2941:352:43045:43042:43043", -- [29]
			"1572:44409:44410:2299:43086:43072", -- [30]
			"1572:44409:44410:2299:43086:43087", -- [31]
			"1572:44409:44410:2299:43086", -- [32]
			"1572:44409:44410:2299:931:43088", -- [33]
			"1572:44409:44410:2299:931:43371", -- [34]
			"41322:41325:2835:43570", -- [35]
			"1572:43702:43701", -- [36]
			"1572:43702", -- [37]
			"1572:2941:352:523:43697", -- [38]
			"41322:41325:2835:43570:12617:44231", -- [39]
			"1572:44409", -- [40]
			"1572:44409:44410", -- [41]
			"1572:44409:44407", -- [42]
			"41322:41325:2835:8018:46006", -- [43]
			"41322:41325:2835:8018:46006:46011", -- [44]
			"41322:47121", -- [45]
			"1572:47119", -- [46]
			"41322:47121:47154:47118", -- [47]
			"41322:47121:47154:47147", -- [48]
			"41322:47121:47154", -- [49]
			"41322:47121:47154:47155", -- [50]
			"41322:41325:2835:8018:46006:46011:47875", -- [51]
			"1572:2941:47927", -- [52]
			"1572:2941:47927:48318", -- [53]
			"1572:2941:47927:48318:48321", -- [54]
			--["name"] = "Slabchisel's Survey, Wetlands",
			["m"] = 56,
			["coord"] = 2442638918,
			["direct"] = "1572:41322",
			["f"] = 0,
		},
		[47875] = {
			"46011:12596:1573:2941:352", -- [1]
			"46011:12596:1573:2941:352:523", -- [2]
			"46011:12596:1573:2941:2299:931", -- [3]
			"46011:12596:1573", -- [4]
			"46011:46006:8018:2835:1571", -- [5]
			"46011:46006:8018:2835:1572", -- [6]
			"46011:12596:1573:2941:2299:931:2409", -- [7]
			"46011:46006:8018:2835", -- [8]
			"46011:12596:1573:2941:352:2859", -- [9]
			"46011:46006:8018", -- [10]
			"46011:12596", -- [11]
			"44233:44230:12617", -- [12]
			"46011:12596:1573:2941:2299", -- [13]
			"46011:12596:1573:2941", -- [14]
			"44233:28621", -- [15]
			"44233:44230", -- [16]
			"44233:44232", -- [17]
			"46011:12596:1573:2941:352:43045", -- [18]
			"44233:44230:12617:26560", -- [19]
			"46011:37888", -- [20]
			"46011:46006:8018:2835:41325:41323", -- [21]
			"46011:46006:8018:2835:41325:41322", -- [22]
			"46011:46006:8018:2835:41325", -- [23]
			"46011:46006:8018:2835:41325:41322:41321", -- [24]
			"46011:46006:8018:2835:1572:41332", -- [25]
			"46011:12596:1573:2941:352:42983", -- [26]
			"46011:12596:1573:2941:352:523:42426", -- [27]
			"46011:12596:1573:2941:352:42406", -- [28]
			"46011:12596:1573:2941:2299:931:43000", -- [29]
			"46011:12596:1573:2941:352:43045:43042", -- [30]
			"46011:12596:1573:2941:352:43045:43042:43043", -- [31]
			"46011:12596:1573:2941:2299:43086:43072", -- [32]
			"46011:12596:1573:2941:2299:43086:43087", -- [33]
			"46011:12596:1573:2941:2299:43086", -- [34]
			"46011:12596:1573:2941:2299:931:43088", -- [35]
			"46011:12596:1573:2941:2299:931:43371", -- [36]
			"46011:37888:43570", -- [37]
			"46011:12596:1573:43701", -- [38]
			"46011:12596:1573:43702", -- [39]
			"46011:12596:1573:2941:352:523:43697", -- [40]
			"44233:44231", -- [41]
			"46011:46006:8018:2835:1572:44409", -- [42]
			"46011:46006:8018:2835:1572:44409:44410", -- [43]
			"46011:46006:8018:2835:1572:44409:44407", -- [44]
			"46011:46006", -- [45]
			"46011:46006:8018:2835:47121", -- [46]
			"46011:46006:8018:2835:47121:47154:47147:47119", -- [47]
			"46011:46006:8018:2835:47121:47154:47118", -- [48]
			"46011:46006:8018:2835:47121:47154:47147", -- [49]
			"46011:46006:8018:2835:47121:47154", -- [50]
			"46011:46006:8018:2835:47121:47154:47155", -- [51]
			"46011:12596:1573:2941:47927", -- [52]
			"46011:12596:1573:2941:47927:48318", -- [53]
			"46011:12596:1573:2941:47927:48318:48321", -- [54]
			--["name"] = "Hearthglen, Western Plaguelands",
			["m"] = 22,
			["coord"] = 1915498328,
			["direct"] = "44233:46011",
			["f"] = 0,
		},
		[48318] = {
			"47927:2941:352", -- [1]
			"48321:2299:931:523", -- [2]
			"48321:2299:931", -- [3]
			"47927:2941:1573", -- [4]
			"47927:2941:1573:1571", -- [5]
			"47927:2941:1572", -- [6]
			"48321:2299:931:2409", -- [7]
			"47927:2941:1572:41321:41322:41325:2835", -- [8]
			"48321:2299:931:2409:43045:2859", -- [9]
			"47927:2941:1572:41321:41322:41325:2835:8018", -- [10]
			"47927:2941:1573:12596", -- [11]
			"47927:2941:1572:41321:41322:41325:2835:43570:12617", -- [12]
			"48321:2299", -- [13]
			"47927:2941", -- [14]
			"47927:2941:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [15]
			"47927:2941:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [16]
			"47927:2941:1572:41321:41322:41325:2835:43570:12617:44230", -- [17]
			"47927:2941:1573:12596:37888:44232", -- [18]
			"48321:2299:931:2409:43045", -- [19]
			"47927:2941:1573:26560", -- [20]
			"47927:2941:1573:12596:37888", -- [21]
			"47927:2941:1572:41321:41322:41323", -- [22]
			"47927:2941:1572:41321:41322", -- [23]
			"47927:2941:1572:41321:41322:41325", -- [24]
			"47927:2941:1572:41321", -- [25]
			"47927:2941:1572:41332", -- [26]
			"48321:2299:931:43000:42983", -- [27]
			"48321:2299:931:523:42426", -- [28]
			"47927:2941:352:42406", -- [29]
			"48321:2299:931:43000", -- [30]
			"48321:2299:931:2409:43045:43042", -- [31]
			"48321:2299:931:2409:43045:43042:43043", -- [32]
			"48321:2299:43086:43072", -- [33]
			"48321:2299:43086:43087", -- [34]
			"48321:2299:43086", -- [35]
			"48321:2299:931:43088", -- [36]
			"48321:2299:931:43371", -- [37]
			"47927:2941:1572:41321:41322:41325:2835:43570", -- [38]
			"47927:2941:1573:43701", -- [39]
			"47927:2941:1572:43702", -- [40]
			"48321:2299:931:2409:43697", -- [41]
			"47927:2941:1572:41321:41322:41325:2835:43570:12617:44231", -- [42]
			"48321:2299:44410:44409", -- [43]
			"48321:2299:44410", -- [44]
			"48321:2299:44410:44407", -- [45]
			"47927:2941:1573:12596:46006", -- [46]
			"47927:2941:1573:12596:46011", -- [47]
			"47927:2941:1572:41321:41322:47121", -- [48]
			"47927:2941:1572:47119", -- [49]
			"47927:2941:1572:41321:41322:47121:47154:47118", -- [50]
			"47927:2941:1572:47119:47147", -- [51]
			"47927:2941:1572:41321:41322:47121:47154", -- [52]
			"47927:2941:1572:41321:41322:47121:47154:47155", -- [53]
			"47927:2941:1573:12596:46011:47875", -- [54]
			--["name"] = "Flamestar Post, Burning Steppes",
			["m"] = 36,
			["coord"] = 764708591,
			["direct"] = "47927:48321",
			["f"] = 0,
		},
		[43371] = {
			"931:352", -- [1]
			"931:523", -- [2]
			"931:2299:2941:1573", -- [3]
			"931:2299:44410:44409:1572:1571", -- [4]
			"931:2299:44410:44409:1572", -- [5]
			"931:2409", -- [6]
			"931:2299:44410:44409:1572:41321:41322:41325:2835", -- [7]
			"931:2409:43045:2859", -- [8]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [9]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [10]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [11]
			"931:2299", -- [12]
			"931:2299:2941", -- [13]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [14]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [15]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [16]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [17]
			"931:2409:43045", -- [18]
			"931:2299:2941:1573:26560", -- [19]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [20]
			"931:2299:44410:44409:1572:41321:41322:41323", -- [21]
			"931:2299:44410:44409:1572:41321:41322", -- [22]
			"931:2299:44410:44409:1572:41321:41322:41325", -- [23]
			"931:2299:44410:44409:1572:41321", -- [24]
			"931:2299:44410:44407:41332", -- [25]
			"931:43000:42983", -- [26]
			"931:523:42426", -- [27]
			"931:352:42406", -- [28]
			"931:43000", -- [29]
			"931:2409:43045:43042", -- [30]
			"931:2409:43045:43042:43043", -- [31]
			"43072:43086:43087", -- [32]
			"43072:43086", -- [33]
			"931:43088", -- [34]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [35]
			"931:2299:44410:44409:1572:43702:43701", -- [36]
			"931:2299:44410:44409:1572:43702", -- [37]
			"931:2409:43697", -- [38]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [39]
			"931:2299:44410:44409", -- [40]
			"931:2299:44410", -- [41]
			"931:2299:44410:44407", -- [42]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [43]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [44]
			"931:2299:44410:44409:1572:41321:41322:47121", -- [45]
			"931:2299:44410:44409:1572:47119", -- [46]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [47]
			"931:2299:44410:44409:1572:47119:47147", -- [48]
			"931:2299:44410:44409:1572:41321:41322:47121:47154", -- [49]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [50]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [51]
			"931:2299:48321:48318:47927", -- [52]
			"931:2299:48321:48318", -- [53]
			"931:2299:48321", -- [54]
			--["name"] = "Camp Everstill, Redridge",
			["m"] = 49,
			["coord"] = 2270333779,
			["direct"] = "931:43072",
			["f"] = 0,
		},
		[931] = {
			"2299:2941:1573", -- [1]
			"2299:44410:44409:1572:1571", -- [2]
			"2299:44410:44409:1572", -- [3]
			"2299:44410:44409:1572:41321:41322:41325:2835", -- [4]
			"2409:43045:2859", -- [5]
			"2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [6]
			"2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [7]
			"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [8]
			"2299:2941", -- [9]
			"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [10]
			"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [11]
			"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [12]
			"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [13]
			"2409:43045", -- [14]
			"2299:2941:1573:26560", -- [15]
			"2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [16]
			"2299:44410:44409:1572:41321:41322:41323", -- [17]
			"2299:44410:44409:1572:41321:41322", -- [18]
			"2299:44410:44409:1572:41321:41322:41325", -- [19]
			"2299:44410:44409:1572:41321", -- [20]
			"2299:44410:44407:41332", -- [21]
			"43000:42983", -- [22]
			"523:42426", -- [23]
			"352:42406", -- [24]
			"2409:43045:43042", -- [25]
			"2409:43045:43042:43043", -- [26]
			"43371:43072", -- [27]
			"43088:43087", -- [28]
			"43371:43072:43086", -- [29]
			"2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [30]
			"2299:44410:44409:1572:43702:43701", -- [31]
			"2299:44410:44409:1572:43702", -- [32]
			"2409:43697", -- [33]
			"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [34]
			"2299:44410:44409", -- [35]
			"2299:44410", -- [36]
			"2299:44410:44407", -- [37]
			"2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [38]
			"2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [39]
			"2299:44410:44409:1572:41321:41322:47121", -- [40]
			"2299:44410:44409:1572:47119", -- [41]
			"2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [42]
			"2299:44410:44409:1572:47119:47147", -- [43]
			"2299:44410:44409:1572:41321:41322:47121:47154", -- [44]
			"2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [45]
			"2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [46]
			"2299:48321:48318:47927", -- [47]
			"2299:48321:48318", -- [48]
			"2299:48321", -- [49]
			--["name"] = "Lakeshire, Redridge",
			["m"] = 49,
			["coord"] = 1261603139,
			["direct"] = "352:523:2409:2299:43000:43088:43371",
			["f"] = 0,
		},
		[26560] = {
			"12617:43570:2835:1572:2941:352", -- [1]
			"12617:44407:44410:2299:931:523", -- [2]
			"12617:44407:44410:2299:931", -- [3]
			"12617:1573", -- [4]
			"12617:43570:2835:1571", -- [5]
			"12617:43570:2835:1572", -- [6]
			"12617:44407:44410:2299:931:2409", -- [7]
			"12617:43570:2835", -- [8]
			"12617:44407:44410:2299:931:2409:43045:2859", -- [9]
			"12617:8018", -- [10]
			"12617:12596", -- [11]
			"12617:44407:44410:2299", -- [12]
			"12617:43570:2835:1572:2941", -- [13]
			"12617:44230:44233", -- [14]
			"12617:44230:28621", -- [15]
			"12617:44230", -- [16]
			"12617:44231:44232", -- [17]
			"12617:44407:44410:2299:931:2409:43045", -- [18]
			"12617:37888", -- [19]
			"12617:43570:2835:41325:41323", -- [20]
			"12617:43570:2835:41325:41322", -- [21]
			"12617:43570:2835:41325", -- [22]
			"12617:43570:2835:41325:41322:41321", -- [23]
			"12617:43570:2835:1572:41332", -- [24]
			"12617:43570:2835:1572:2941:352:42983", -- [25]
			"12617:44407:44410:2299:931:523:42426", -- [26]
			"12617:43570:2835:1572:2941:352:42406", -- [27]
			"12617:44407:44410:2299:931:43000", -- [28]
			"12617:44407:44410:2299:931:2409:43045:43042", -- [29]
			"12617:44407:44410:2299:931:2409:43045:43042:43043", -- [30]
			"12617:44407:44410:2299:43086:43072", -- [31]
			"12617:44407:44410:2299:43086:43087", -- [32]
			"12617:44407:44410:2299:43086", -- [33]
			"12617:44407:44410:2299:931:43088", -- [34]
			"12617:44407:44410:2299:931:43371", -- [35]
			"12617:43570", -- [36]
			"12617:1573:43701", -- [37]
			"12617:43570:2835:1572:43702", -- [38]
			"12617:44407:44410:2299:931:2409:43697", -- [39]
			"12617:44231", -- [40]
			"12617:44407:44409", -- [41]
			"12617:44407:44410", -- [42]
			"12617:44407", -- [43]
			"12617:37888:46011:46006", -- [44]
			"12617:37888:46011", -- [45]
			"12617:43570:2835:47121", -- [46]
			"12617:43570:2835:47121:47154:47147:47119", -- [47]
			"12617:43570:2835:47121:47154:47118", -- [48]
			"12617:43570:2835:47121:47154:47147", -- [49]
			"12617:43570:2835:47121:47154", -- [50]
			"12617:43570:2835:47121:47154:47155", -- [51]
			"12617:44230:44233:47875", -- [52]
			"12617:43570:2835:1572:2941:47927", -- [53]
			"12617:43570:2835:1572:2941:47927:48318", -- [54]
			"12617:44407:44410:2299:48321", -- [55]
			--["name"] = "Shattered Sun Staging Area",
			["m"] = 122,
			["coord"] = 2073575464,
			["direct"] = "12617",
			["f"] = 0,
		},
		[44231] = {
			"44232:37888:12596:1573:2941:352", -- [1]
			"44232:37888:12596:1573:2941:352:523", -- [2]
			"12617:44407:44410:2299:931", -- [3]
			"44232:37888:12596:1573", -- [4]
			"12617:43570:2835:1571", -- [5]
			"12617:43570:2835:1572", -- [6]
			"12617:44407:44410:2299:931:2409", -- [7]
			"12617:43570:2835", -- [8]
			"12617:44407:44410:2299:931:2409:43045:2859", -- [9]
			"44232:37888:12596:8018", -- [10]
			"44232:37888:12596", -- [11]
			"12617:44407:44410:2299", -- [12]
			"44232:37888:12596:1573:2941", -- [13]
			"44230:28621", -- [14]
			"12617:44407:44410:2299:931:2409:43045", -- [15]
			"12617:26560", -- [16]
			"44232:37888", -- [17]
			"12617:43570:2835:41325:41323", -- [18]
			"12617:43570:2835:41325:41322", -- [19]
			"12617:43570:2835:41325", -- [20]
			"12617:43570:2835:41325:41322:41321", -- [21]
			"12617:43570:2835:1572:41332", -- [22]
			"44232:37888:12596:1573:2941:352:42983", -- [23]
			"44232:37888:12596:1573:2941:352:523:42426", -- [24]
			"44232:37888:12596:1573:2941:352:42406", -- [25]
			"12617:44407:44410:2299:931:43000", -- [26]
			"12617:44407:44410:2299:931:2409:43045:43042", -- [27]
			"12617:44407:44410:2299:931:2409:43045:43042:43043", -- [28]
			"12617:44407:44410:2299:43086:43072", -- [29]
			"12617:44407:44410:2299:43086:43087", -- [30]
			"12617:44407:44410:2299:43086", -- [31]
			"12617:44407:44410:2299:931:43088", -- [32]
			"12617:44407:44410:2299:931:43371", -- [33]
			"12617:43570", -- [34]
			"44232:37888:12596:1573:43701", -- [35]
			"44232:37888:12596:1573:43702", -- [36]
			"12617:44407:44410:2299:931:2409:43697", -- [37]
			"12617:44407:44409", -- [38]
			"12617:44407:44410", -- [39]
			"12617:44407", -- [40]
			"44232:37888:46011:46006", -- [41]
			"44232:37888:46011", -- [42]
			"12617:43570:2835:47121", -- [43]
			"12617:43570:2835:47121:47154:47147:47119", -- [44]
			"12617:43570:2835:47121:47154:47118", -- [45]
			"12617:43570:2835:47121:47154:47147", -- [46]
			"12617:43570:2835:47121:47154", -- [47]
			"12617:43570:2835:47121:47154:47155", -- [48]
			"44233:47875", -- [49]
			"44232:37888:12596:1573:2941:47927", -- [50]
			"44232:37888:12596:1573:2941:47927:48318", -- [51]
			"12617:44407:44410:2299:48321", -- [52]
			--["name"] = "Light's Shield Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 2262927709,
			["direct"] = "12617:44233:44230:44232",
			["f"] = 0,
		},
		[44233] = {
			"44232:37888:12596:1573:2941:352", -- [1]
			"44232:37888:12596:1573:2941:352:523", -- [2]
			"44230:12617:44407:44410:2299:931", -- [3]
			"44232:37888:12596:1573", -- [4]
			"44230:12617:43570:2835:1571", -- [5]
			"44230:12617:43570:2835:1572", -- [6]
			"44230:12617:44407:44410:2299:931:2409", -- [7]
			"44230:12617:43570:2835", -- [8]
			"44230:12617:44407:44410:2299:931:2409:43045:2859", -- [9]
			"44232:37888:12596:8018", -- [10]
			"44232:37888:12596", -- [11]
			"44230:12617", -- [12]
			"44230:12617:44407:44410:2299", -- [13]
			"44232:37888:12596:1573:2941", -- [14]
			"44230:12617:44407:44410:2299:931:2409:43045", -- [15]
			"44230:12617:26560", -- [16]
			"44232:37888", -- [17]
			"44230:12617:43570:2835:41325:41323", -- [18]
			"44230:12617:43570:2835:41325:41322", -- [19]
			"44230:12617:43570:2835:41325", -- [20]
			"44230:12617:43570:2835:41325:41322:41321", -- [21]
			"44230:12617:43570:2835:1572:41332", -- [22]
			"44232:37888:12596:1573:2941:352:42983", -- [23]
			"44232:37888:12596:1573:2941:352:523:42426", -- [24]
			"44232:37888:12596:1573:2941:352:42406", -- [25]
			"44230:12617:44407:44410:2299:931:43000", -- [26]
			"44230:12617:44407:44410:2299:931:2409:43045:43042", -- [27]
			"44230:12617:44407:44410:2299:931:2409:43045:43042:43043", -- [28]
			"44230:12617:44407:44410:2299:43086:43072", -- [29]
			"44230:12617:44407:44410:2299:43086:43087", -- [30]
			"44230:12617:44407:44410:2299:43086", -- [31]
			"44230:12617:44407:44410:2299:931:43088", -- [32]
			"44230:12617:44407:44410:2299:931:43371", -- [33]
			"44230:12617:43570", -- [34]
			"44232:37888:12596:1573:43701", -- [35]
			"44232:37888:12596:1573:43702", -- [36]
			"44232:37888:12596:1573:2941:352:523:43697", -- [37]
			"44230:12617:44407:44409", -- [38]
			"44230:12617:44407:44410", -- [39]
			"44230:12617:44407", -- [40]
			"47875:46011:46006", -- [41]
			"47875:46011", -- [42]
			"44230:12617:43570:2835:47121", -- [43]
			"44230:12617:43570:2835:47121:47154:47147:47119", -- [44]
			"44230:12617:43570:2835:47121:47154:47118", -- [45]
			"44230:12617:43570:2835:47121:47154:47147", -- [46]
			"44230:12617:43570:2835:47121:47154", -- [47]
			"44230:12617:43570:2835:47121:47154:47155", -- [48]
			"44232:37888:12596:1573:2941:47927", -- [49]
			"44232:37888:12596:1573:2941:47927:48318", -- [50]
			"44230:12617:44407:44410:2299:48321", -- [51]
			--["name"] = "Plaguewood Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 794904154,
			["direct"] = "28621:44230:44232:44231:47875",
			["f"] = 0,
		},
		[44230] = {
			"12617:43570:2835:1572:2941:352", -- [1]
			"12617:44407:44410:2299:931:523", -- [2]
			"12617:44407:44410:2299:931", -- [3]
			"44231:44232:37888:12596:1573", -- [4]
			"12617:43570:2835:1571", -- [5]
			"12617:43570:2835:1572", -- [6]
			"12617:44407:44410:2299:931:2409", -- [7]
			"12617:43570:2835", -- [8]
			"12617:44407:44410:2299:931:2409:43045:2859", -- [9]
			"12617:8018", -- [10]
			"44231:44232:37888:12596", -- [11]
			"12617:44407:44410:2299", -- [12]
			"12617:43570:2835:1572:2941", -- [13]
			"44231:44232", -- [14]
			"12617:44407:44410:2299:931:2409:43045", -- [15]
			"12617:26560", -- [16]
			"44231:44232:37888", -- [17]
			"12617:43570:2835:41325:41323", -- [18]
			"12617:43570:2835:41325:41322", -- [19]
			"12617:43570:2835:41325", -- [20]
			"12617:43570:2835:41325:41322:41321", -- [21]
			"12617:43570:2835:1572:41332", -- [22]
			"12617:43570:2835:1572:2941:352:42983", -- [23]
			"12617:44407:44410:2299:931:523:42426", -- [24]
			"12617:43570:2835:1572:2941:352:42406", -- [25]
			"12617:44407:44410:2299:931:43000", -- [26]
			"12617:44407:44410:2299:931:2409:43045:43042", -- [27]
			"12617:44407:44410:2299:931:2409:43045:43042:43043", -- [28]
			"12617:44407:44410:2299:43086:43072", -- [29]
			"12617:44407:44410:2299:43086:43087", -- [30]
			"12617:44407:44410:2299:43086", -- [31]
			"12617:44407:44410:2299:931:43088", -- [32]
			"12617:44407:44410:2299:931:43371", -- [33]
			"12617:43570", -- [34]
			"44231:44232:37888:12596:1573:43701", -- [35]
			"12617:43570:2835:1572:43702", -- [36]
			"12617:44407:44410:2299:931:2409:43697", -- [37]
			"12617:44407:44409", -- [38]
			"12617:44407:44410", -- [39]
			"12617:44407", -- [40]
			"44231:44232:37888:46011:46006", -- [41]
			"44231:44232:37888:46011", -- [42]
			"12617:43570:2835:47121", -- [43]
			"12617:43570:2835:47121:47154:47147:47119", -- [44]
			"12617:43570:2835:47121:47154:47118", -- [45]
			"12617:43570:2835:47121:47154:47147", -- [46]
			"12617:43570:2835:47121:47154", -- [47]
			"12617:43570:2835:47121:47154:47155", -- [48]
			"44233:47875", -- [49]
			"12617:43570:2835:1572:2941:47927", -- [50]
			"12617:43570:2835:1572:2941:47927:48318", -- [51]
			"12617:44407:44410:2299:48321", -- [52]
			--["name"] = "Eastwall Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 2645848134,
			["direct"] = "12617:44233:28621:44231",
			["f"] = 0,
		},
		[47155] = {
			"47154:47121:41322:41321:1572:2941:352", -- [1]
			"47154:47121:41322:41321:1572:2941:352:523", -- [2]
			"47154:47121:41322:41321:1572:44409:44410:2299:931", -- [3]
			"47154:47121:41322:41323:1571:1573", -- [4]
			"47154:47121:41322:41323:1571", -- [5]
			"47154:47121:41322:41321:1572", -- [6]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:2409", -- [7]
			"47154:47121:2835", -- [8]
			"47154:47121:41322:41321:1572:2941:352:2859", -- [9]
			"47154:47121:2835:8018", -- [10]
			"47154:47121:2835:8018:12596", -- [11]
			"47154:47121:2835:43570:12617", -- [12]
			"47154:47121:41322:41321:1572:44409:44410:2299", -- [13]
			"47154:47121:41322:41321:1572:2941", -- [14]
			"47154:47121:2835:43570:12617:44230:44233", -- [15]
			"47154:47121:2835:43570:12617:44230:28621", -- [16]
			"47154:47121:2835:43570:12617:44230", -- [17]
			"47154:47121:2835:43570:12617:44231:44232", -- [18]
			"47154:47121:41322:41321:1572:2941:352:43045", -- [19]
			"47154:47121:2835:43570:12617:26560", -- [20]
			"47154:47121:2835:8018:12596:37888", -- [21]
			"47154:47121:41322:41323", -- [22]
			"47154:47121:41322", -- [23]
			"47154:47121:41322:41325", -- [24]
			"47154:47121:41322:41321", -- [25]
			"47154:47121:41322:41321:1572:41332", -- [26]
			"47154:47121:41322:41321:1572:2941:352:42983", -- [27]
			"47154:47121:41322:41321:1572:2941:352:523:42426", -- [28]
			"47154:47121:41322:41321:1572:2941:352:42406", -- [29]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:43000", -- [30]
			"47154:47121:41322:41321:1572:2941:352:43045:43042", -- [31]
			"47154:47121:41322:41321:1572:2941:352:43045:43042:43043", -- [32]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086:43072", -- [33]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086:43087", -- [34]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086", -- [35]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:43088", -- [36]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:43371", -- [37]
			"47154:47121:2835:43570", -- [38]
			"47154:47121:41322:41321:1572:43702:43701", -- [39]
			"47154:47121:41322:41321:1572:43702", -- [40]
			"47154:47121:41322:41321:1572:2941:352:523:43697", -- [41]
			"47154:47121:2835:43570:12617:44231", -- [42]
			"47154:47121:41322:41321:1572:44409", -- [43]
			"47154:47121:41322:41321:1572:44409:44410", -- [44]
			"47154:47121:41322:41321:1572:44409:44407", -- [45]
			"47154:47121:2835:8018:46006", -- [46]
			"47154:47121:2835:8018:46006:46011", -- [47]
			"47154:47121", -- [48]
			"47154:47118", -- [49]
			"47154:47121:2835:8018:46006:46011:47875", -- [50]
			"47154:47121:41322:41321:1572:2941:47927", -- [51]
			"47154:47121:41322:41321:1572:2941:47927:48318", -- [52]
			"47154:47121:41322:41321:1572:2941:47927:48318:48321", -- [53]
			--["name"] = "Kirthaven, Twilight Highlands",
			["m"] = 241,
			["coord"] = 2437424847,
			["direct"] = "47119:47147:47154",
			["f"] = 0,
		},
		[43042] = {
			"43045:352", -- [1]
			"43045:523", -- [2]
			"43045:2409:931", -- [3]
			"43045:352:1573", -- [4]
			"43045:352:1573:1571", -- [5]
			"43045:2409:931:2299:44410:44409:1572", -- [6]
			"43045:2409", -- [7]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835", -- [8]
			"43043:2859", -- [9]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [10]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [11]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [12]
			"43045:2409:931:2299", -- [13]
			"43045:352:2941", -- [14]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [15]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [16]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [17]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [18]
			"43045:352:1573:26560", -- [19]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [20]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41323", -- [21]
			"43045:2409:931:2299:44410:44409:1572:41321:41322", -- [22]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325", -- [23]
			"43045:2409:931:2299:44410:44409:1572:41321", -- [24]
			"43045:2409:931:2299:44410:44407:41332", -- [25]
			"43045:2409:42983", -- [26]
			"43045:523:42426", -- [27]
			"43045:523:42406", -- [28]
			"43045:2409:931:43000", -- [29]
			"43045:2409:931:43371:43072", -- [30]
			"43045:85731:43087", -- [31]
			"43045:2409:931:43371:43072:43086", -- [32]
			"43045:2409:931:43088", -- [33]
			"43045:2409:931:43371", -- [34]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [35]
			"43045:352:1573:43701", -- [36]
			"43045:2409:931:2299:44410:44409:1572:43702", -- [37]
			"43045:43697", -- [38]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [39]
			"43045:2409:931:2299:44410:44409", -- [40]
			"43045:2409:931:2299:44410", -- [41]
			"43045:2409:931:2299:44410:44407", -- [42]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [43]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [44]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:47121", -- [45]
			"43045:2409:931:2299:44410:44409:1572:47119", -- [46]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [47]
			"43045:2409:931:2299:44410:44409:1572:47119:47147", -- [48]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154", -- [49]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [50]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [51]
			"43045:2409:931:2299:48321:48318:47927", -- [52]
			"43045:2409:931:2299:48321:48318", -- [53]
			"43045:2409:931:2299:48321", -- [54]
			--["name"] = "Fort Livingston, Stranglethorn",
			["m"] = 50,
			["coord"] = 2259659072,
			["direct"] = "43045:43043",
			["f"] = 0,
		},
		[43107] = {
			"8609:2409:352", -- [1]
			"8609:2409:523", -- [2]
			"8609:43087:43088:931", -- [3]
			"8609:43087:43086:2299:2941:1573", -- [4]
			"8609:43087:43086:2299:44410:44409:1572:1571", -- [5]
			"8609:43087:43086:2299:44410:44409:1572", -- [6]
			"8609:2409", -- [7]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325:2835", -- [8]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [9]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [10]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [11]
			"8609:43087:43086:2299", -- [12]
			"8609:43087:43086:2299:2941", -- [13]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [14]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [15]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [16]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [17]
			"8609:2409:43045", -- [18]
			"8609:43087:43086:2299:2941:1573:26560", -- [19]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [20]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41323", -- [21]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322", -- [22]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325", -- [23]
			"8609:43087:43086:2299:44410:44409:1572:41321", -- [24]
			"8609:43087:43086:2299:44410:44407:41332", -- [25]
			"8609:2409:42983", -- [26]
			"8609:2409:523:42426", -- [27]
			"8609:2409:523:42406", -- [28]
			"8609:43087:43088:931:43000", -- [29]
			"2859:43043:43042", -- [30]
			"2859:43043", -- [31]
			"8609:43087:43086:43072", -- [32]
			"8609:43087", -- [33]
			"8609:43087:43086", -- [34]
			"8609:43087:43088", -- [35]
			"8609:43087:43086:43072:43371", -- [36]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [37]
			"8609:43087:43086:2299:44410:44409:1572:43702:43701", -- [38]
			"8609:43087:43086:2299:44410:44409:1572:43702", -- [39]
			"8609:2409:43697", -- [40]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [41]
			"8609:43087:43086:2299:44410:44409", -- [42]
			"8609:43087:43086:2299:44410", -- [43]
			"8609:43087:43086:2299:44410:44407", -- [44]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [45]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [46]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:47121", -- [47]
			"8609:43087:43086:2299:44410:44409:1572:47119", -- [48]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [49]
			"8609:43087:43086:2299:44410:44409:1572:47119:47147", -- [50]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:47121:47154", -- [51]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [52]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [53]
			"8609:43087:43086:2299:48321:48318:47927", -- [54]
			"8609:43087:43086:2299:48321:48318", -- [55]
			"8609:43087:43086:2299:48321", -- [56]
			["direct"] = "2859:8609",
			["coord"] = 2025645162,
			["m"] = 17,
			["f"] = 0,
		},
		[42983] = {
			"352:523", -- [1]
			"43000:931", -- [2]
			"352:1573", -- [3]
			"352:1573:1571", -- [4]
			"352:2941:1572", -- [5]
			"352:2941:1572:41321:41322:41325:2835", -- [6]
			"2409:43045:2859", -- [7]
			"352:2941:1572:41321:41322:41325:2835:8018", -- [8]
			"352:1573:12596", -- [9]
			"352:2941:1572:41321:41322:41325:2835:43570:12617", -- [10]
			"43000:931:2299", -- [11]
			"352:2941", -- [12]
			"352:2941:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [13]
			"352:2941:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [14]
			"352:2941:1572:41321:41322:41325:2835:43570:12617:44230", -- [15]
			"352:1573:12596:37888:44232", -- [16]
			"2409:43045", -- [17]
			"352:1573:26560", -- [18]
			"352:1573:12596:37888", -- [19]
			"352:2941:1572:41321:41322:41323", -- [20]
			"352:2941:1572:41321:41322", -- [21]
			"352:2941:1572:41321:41322:41325", -- [22]
			"352:2941:1572:41321", -- [23]
			"352:2941:1572:41332", -- [24]
			"352:523:42426", -- [25]
			"352:42406", -- [26]
			"2409:43045:43042", -- [27]
			"2409:43045:43042:43043", -- [28]
			"43000:931:43371:43072", -- [29]
			"43000:931:43088:43087", -- [30]
			"43000:931:43371:43072:43086", -- [31]
			"43000:931:43088", -- [32]
			"43000:931:43371", -- [33]
			"352:2941:1572:41321:41322:41325:2835:43570", -- [34]
			"352:1573:43701", -- [35]
			"352:2941:1572:43702", -- [36]
			"2409:43697", -- [37]
			"352:2941:1572:41321:41322:41325:2835:43570:12617:44231", -- [38]
			"43000:931:2299:44410:44409", -- [39]
			"43000:931:2299:44410", -- [40]
			"43000:931:2299:44410:44407", -- [41]
			"352:1573:12596:46006", -- [42]
			"352:1573:12596:46011", -- [43]
			"352:2941:1572:41321:41322:47121", -- [44]
			"352:2941:1572:47119", -- [45]
			"352:2941:1572:41321:41322:47121:47154:47118", -- [46]
			"352:2941:1572:47119:47147", -- [47]
			"352:2941:1572:41321:41322:47121:47154", -- [48]
			"352:2941:1572:41321:41322:47121:47154:47155", -- [49]
			"352:1573:12596:46011:47875", -- [50]
			"352:2941:47927", -- [51]
			"43000:931:2299:48321:48318", -- [52]
			"43000:931:2299:48321", -- [53]
			--["name"] = "Goldshire, Elwynn",
			["m"] = 37,
			["coord"] = 1794680136,
			["direct"] = "352:2409:43000",
			["f"] = 0,
		},
		[2409] = {
			"931:2299:2941:1573", -- [1]
			"931:2299:44410:44409:1572:1571", -- [2]
			"931:2299:44410:44409:1572", -- [3]
			"931:2299:44410:44409:1572:41321:41322:41325:2835", -- [4]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [5]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [6]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [7]
			"931:2299", -- [8]
			"931:2299:2941", -- [9]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [10]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [11]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [12]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [13]
			"931:2299:2941:1573:26560", -- [14]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [15]
			"931:2299:44410:44409:1572:41321:41322:41323", -- [16]
			"931:2299:44410:44409:1572:41321:41322", -- [17]
			"931:2299:44410:44409:1572:41321:41322:41325", -- [18]
			"931:2299:44410:44409:1572:41321", -- [19]
			"931:2299:44410:44407:41332", -- [20]
			"523:42426", -- [21]
			"523:42406", -- [22]
			"931:43000", -- [23]
			"43045:43042", -- [24]
			"43045:43042:43043", -- [25]
			"931:43371:43072", -- [26]
			"85731:43087", -- [27]
			"931:43371:43072:43086", -- [28]
			"931:43088", -- [29]
			"931:43371", -- [30]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [31]
			"931:2299:44410:44409:1572:43702:43701", -- [32]
			"931:2299:44410:44409:1572:43702", -- [33]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [34]
			"931:2299:44410:44409", -- [35]
			"931:2299:44410", -- [36]
			"931:2299:44410:44407", -- [37]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [38]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [39]
			"931:2299:44410:44409:1572:41321:41322:47121", -- [40]
			"931:2299:44410:44409:1572:47119", -- [41]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [42]
			"931:2299:44410:44409:1572:47119:47147", -- [43]
			"931:2299:44410:44409:1572:41321:41322:47121:47154", -- [44]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [45]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [46]
			"931:2299:48321:48318:47927", -- [47]
			"931:2299:48321:48318", -- [48]
			"931:2299:48321", -- [49]
			--["name"] = "Darkshire, Duskwood",
			["m"] = 47,
			["f"] = 0,
			["direct"] = "352:523:931:2859:43045:42983:43697",
			["coord"] = 3334828433,
		},
		[46011] = {
			"12596:1573:2941:352", -- [1]
			"12596:1573:2941:352:523", -- [2]
			"12596:1573:2941:2299:931", -- [3]
			"12596:1573", -- [4]
			"46006:8018:2835:1571", -- [5]
			"46006:8018:2835:1572", -- [6]
			"12596:1573:2941:2299:931:2409", -- [7]
			"46006:8018:2835", -- [8]
			"12596:1573:2941:352:2859", -- [9]
			"46006:8018", -- [10]
			"37888:12617", -- [11]
			"12596:1573:2941:2299", -- [12]
			"12596:1573:2941", -- [13]
			"47875:44233", -- [14]
			"37888:44232:28621", -- [15]
			"37888:44232:44231:44230", -- [16]
			"37888:44232", -- [17]
			"12596:1573:2941:352:43045", -- [18]
			"37888:12617:26560", -- [19]
			"46006:8018:2835:41325:41323", -- [20]
			"46006:8018:2835:41325:41322", -- [21]
			"46006:8018:2835:41325", -- [22]
			"46006:8018:2835:41325:41322:41321", -- [23]
			"46006:8018:2835:1572:41332", -- [24]
			"12596:1573:2941:352:42983", -- [25]
			"12596:1573:2941:352:523:42426", -- [26]
			"12596:1573:2941:352:42406", -- [27]
			"12596:1573:2941:2299:931:43000", -- [28]
			"12596:1573:2941:352:43045:43042", -- [29]
			"12596:1573:2941:352:43045:43042:43043", -- [30]
			"12596:1573:2941:2299:43086:43072", -- [31]
			"12596:1573:2941:2299:43086:43087", -- [32]
			"12596:1573:2941:2299:43086", -- [33]
			"12596:1573:2941:2299:931:43088", -- [34]
			"12596:1573:2941:2299:931:43371", -- [35]
			"37888:43570", -- [36]
			"12596:1573:43701", -- [37]
			"12596:1573:43702", -- [38]
			"12596:1573:2941:352:523:43697", -- [39]
			"37888:44232:44231", -- [40]
			"46006:8018:2835:1572:44409", -- [41]
			"46006:8018:2835:1572:44409:44410", -- [42]
			"46006:8018:2835:1572:44409:44407", -- [43]
			"46006:8018:2835:47121", -- [44]
			"46006:8018:2835:47121:47154:47147:47119", -- [45]
			"46006:8018:2835:47121:47154:47118", -- [46]
			"46006:8018:2835:47121:47154:47147", -- [47]
			"46006:8018:2835:47121:47154", -- [48]
			"46006:8018:2835:47121:47154:47155", -- [49]
			"12596:1573:2941:47927", -- [50]
			"12596:1573:2941:47927:48318", -- [51]
			"12596:1573:2941:47927:48318:48321", -- [52]
			--["name"] = "The Menders' Stead, Western Plaguelands",
			["m"] = 22,
			["coord"] = 2169996787,
			["direct"] = "12596:37888:46006:47875",
			["f"] = 0,
		},
		[2299] = {
			"931:523", -- [1]
			"2941:1573", -- [2]
			"44410:44409:1572:1571", -- [3]
			"44410:44409:1572", -- [4]
			"931:2409", -- [5]
			"44410:44409:1572:41321:41322:41325:2835", -- [6]
			"931:2409:43045:2859", -- [7]
			"44410:44409:1572:41321:41322:41325:2835:8018", -- [8]
			"44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [9]
			"44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [10]
			"44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [11]
			"44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [12]
			"44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [13]
			"44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [14]
			"931:2409:43045", -- [15]
			"2941:1573:26560", -- [16]
			"44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [17]
			"44410:44409:1572:41321:41322:41323", -- [18]
			"44410:44409:1572:41321:41322", -- [19]
			"44410:44409:1572:41321:41322:41325", -- [20]
			"44410:44409:1572:41321", -- [21]
			"44410:44407:41332", -- [22]
			"931:43000:42983", -- [23]
			"931:523:42426", -- [24]
			"352:42406", -- [25]
			"931:43000", -- [26]
			"931:2409:43045:43042", -- [27]
			"931:2409:43045:43042:43043", -- [28]
			"43086:43072", -- [29]
			"43086:43087", -- [30]
			"931:43088", -- [31]
			"931:43371", -- [32]
			"44410:44409:1572:41321:41322:41325:2835:43570", -- [33]
			"44410:44409:1572:43702:43701", -- [34]
			"44410:44409:1572:43702", -- [35]
			"931:2409:43697", -- [36]
			"44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [37]
			"44410:44409", -- [38]
			"44410:44407", -- [39]
			"44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [40]
			"44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [41]
			"44410:44409:1572:41321:41322:47121", -- [42]
			"44410:44409:1572:47119", -- [43]
			"44410:44409:1572:41321:41322:47121:47154:47118", -- [44]
			"44410:44409:1572:47119:47147", -- [45]
			"44410:44409:1572:41321:41322:47121:47154", -- [46]
			"44410:44409:1572:41321:41322:47121:47154:47155", -- [47]
			"44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [48]
			"48321:48318:47927", -- [49]
			"48321:48318", -- [50]
			--["name"] = "Morgan's Vigil, Burning Steppes",
			["m"] = 36,
			["coord"] = 3098257440,
			["direct"] = "352:931:2941:43086:44410:48321",
			["f"] = 0,
		},
		[37888] = {
			"12596:1573:2941:352", -- [1]
			"12596:1573:2941:352:523", -- [2]
			"12596:1573:2941:2299:931", -- [3]
			"12596:1573", -- [4]
			"43570:2835:1571", -- [5]
			"43570:2835:1572", -- [6]
			"12596:1573:2941:2299:931:2409", -- [7]
			"43570:2835", -- [8]
			"12596:1573:2941:352:2859", -- [9]
			"12596:8018", -- [10]
			"12596:1573:2941:2299", -- [11]
			"12596:1573:2941", -- [12]
			"44232:44233", -- [13]
			"44232:28621", -- [14]
			"44232:44231:44230", -- [15]
			"12596:1573:2941:352:43045", -- [16]
			"12617:26560", -- [17]
			"43570:2835:41325:41323", -- [18]
			"43570:2835:41325:41322", -- [19]
			"43570:2835:41325", -- [20]
			"43570:2835:41325:41322:41321", -- [21]
			"43570:2835:1572:41332", -- [22]
			"12596:1573:2941:352:42983", -- [23]
			"12596:1573:2941:352:523:42426", -- [24]
			"12596:1573:2941:352:42406", -- [25]
			"12596:1573:2941:2299:931:43000", -- [26]
			"12596:1573:2941:352:43045:43042", -- [27]
			"12596:1573:2941:352:43045:43042:43043", -- [28]
			"12596:1573:2941:2299:43086:43072", -- [29]
			"12596:1573:2941:2299:43086:43087", -- [30]
			"12596:1573:2941:2299:43086", -- [31]
			"12596:1573:2941:2299:931:43088", -- [32]
			"12596:1573:2941:2299:931:43371", -- [33]
			"12596:1573:43701", -- [34]
			"12596:1573:43702", -- [35]
			"12596:1573:2941:352:523:43697", -- [36]
			"44232:44231", -- [37]
			"43570:2835:1572:44409", -- [38]
			"43570:2835:1572:44409:44410", -- [39]
			"12617:44407", -- [40]
			"46011:46006", -- [41]
			"43570:2835:47121", -- [42]
			"43570:2835:47121:47154:47147:47119", -- [43]
			"43570:2835:47121:47154:47118", -- [44]
			"43570:2835:47121:47154:47147", -- [45]
			"43570:2835:47121:47154", -- [46]
			"43570:2835:47121:47154:47155", -- [47]
			"46011:47875", -- [48]
			"12596:1573:2941:47927", -- [49]
			"12596:1573:2941:47927:48318", -- [50]
			"12596:1573:2941:47927:48318:48321", -- [51]
			--["name"] = "Thondroril River, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 433629293,
			["direct"] = "12596:12617:44232:43570:46011",
			["f"] = 0,
		},
		[42426] = {
			"523:352", -- [1]
			"523:931", -- [2]
			"523:352:1573", -- [3]
			"523:352:1573:1571", -- [4]
			"523:352:2941:1572", -- [5]
			"523:43697:2409", -- [6]
			"523:352:2941:1572:41321:41322:41325:2835", -- [7]
			"523:2859", -- [8]
			"523:352:2941:1572:41321:41322:41325:2835:8018", -- [9]
			"523:352:1573:12596", -- [10]
			"523:352:2941:1572:41321:41322:41325:2835:43570:12617", -- [11]
			"523:931:2299", -- [12]
			"523:352:2941", -- [13]
			"523:352:2941:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [14]
			"523:352:2941:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [15]
			"523:352:2941:1572:41321:41322:41325:2835:43570:12617:44230", -- [16]
			"523:352:1573:12596:37888:44232", -- [17]
			"523:43045", -- [18]
			"523:352:1573:26560", -- [19]
			"523:352:1573:12596:37888", -- [20]
			"523:352:2941:1572:41321:41322:41323", -- [21]
			"523:352:2941:1572:41321:41322", -- [22]
			"523:352:2941:1572:41321:41322:41325", -- [23]
			"523:352:2941:1572:41321", -- [24]
			"523:931:2299:44410:44407:41332", -- [25]
			"523:352:42983", -- [26]
			"523:42406", -- [27]
			"523:931:43000", -- [28]
			"523:43045:43042", -- [29]
			"523:43045:43042:43043", -- [30]
			"523:931:43371:43072", -- [31]
			"523:931:43088:43087", -- [32]
			"523:931:43371:43072:43086", -- [33]
			"523:931:43088", -- [34]
			"523:931:43371", -- [35]
			"523:352:2941:1572:41321:41322:41325:2835:43570", -- [36]
			"523:352:1573:43701", -- [37]
			"523:352:2941:1572:43702", -- [38]
			"523:43697", -- [39]
			"523:352:2941:1572:41321:41322:41325:2835:43570:12617:44231", -- [40]
			"523:931:2299:44410:44409", -- [41]
			"523:931:2299:44410", -- [42]
			"523:931:2299:44410:44407", -- [43]
			"523:352:1573:12596:46006", -- [44]
			"523:352:1573:12596:46011", -- [45]
			"523:352:2941:1572:41321:41322:47121", -- [46]
			"523:352:2941:1572:47119", -- [47]
			"523:352:2941:1572:41321:41322:47121:47154:47118", -- [48]
			"523:352:2941:1572:47119:47147", -- [49]
			"523:352:2941:1572:41321:41322:47121:47154", -- [50]
			"523:352:2941:1572:41321:41322:47121:47154:47155", -- [51]
			"523:352:1573:12596:46011:47875", -- [52]
			"523:352:2941:47927", -- [53]
			"523:931:2299:48321:48318", -- [54]
			"523:931:2299:48321", -- [55]
			--["name"] = "Moonbrook, Westfall",
			["m"] = 52,
			["coord"] = 1808507402,
			["direct"] = "523",
			["f"] = 0,
		},
		[12596] = {
			"1573:2941:352", -- [1]
			"1573:2941:352:523", -- [2]
			"1573:2941:2299:931", -- [3]
			"8018:2835:1571", -- [4]
			"8018:2835:1572", -- [5]
			"1573:2941:2299:931:2409", -- [6]
			"8018:2835", -- [7]
			"1573:2941:352:2859", -- [8]
			"1573:2941:2299", -- [9]
			"1573:2941", -- [10]
			"46011:47875:44233", -- [11]
			"37888:44232:28621", -- [12]
			"37888:44232:44231:44230", -- [13]
			"37888:44232", -- [14]
			"1573:2941:352:43045", -- [15]
			"12617:26560", -- [16]
			"8018:2835:41325:41323", -- [17]
			"8018:2835:41325:41322", -- [18]
			"8018:2835:41325", -- [19]
			"8018:2835:41325:41322:41321", -- [20]
			"8018:2835:1572:41332", -- [21]
			"1573:2941:352:42983", -- [22]
			"1573:2941:352:523:42426", -- [23]
			"1573:2941:352:42406", -- [24]
			"1573:2941:2299:931:43000", -- [25]
			"1573:2941:352:43045:43042", -- [26]
			"1573:2941:352:43045:43042:43043", -- [27]
			"1573:2941:2299:43086:43072", -- [28]
			"1573:2941:2299:43086:43087", -- [29]
			"1573:2941:2299:43086", -- [30]
			"1573:2941:2299:931:43088", -- [31]
			"1573:2941:2299:931:43371", -- [32]
			"8018:43570", -- [33]
			"1573:43701", -- [34]
			"1573:43702", -- [35]
			"1573:2941:352:523:43697", -- [36]
			"37888:44232:44231", -- [37]
			"8018:2835:1572:44409", -- [38]
			"8018:2835:1572:44409:44410", -- [39]
			"8018:2835:1572:44409:44407", -- [40]
			"8018:2835:47121", -- [41]
			"8018:2835:47121:47154:47147:47119", -- [42]
			"8018:2835:47121:47154:47118", -- [43]
			"8018:2835:47121:47154:47147", -- [44]
			"8018:2835:47121:47154", -- [45]
			"8018:2835:47121:47154:47155", -- [46]
			"46011:47875", -- [47]
			"1573:2941:47927", -- [48]
			"1573:2941:47927:48318", -- [49]
			"1573:2941:47927:48318:48321", -- [50]
			--["name"] = "Chillwind Camp, Western Plaguelands",
			["m"] = 22,
			["coord"] = 1844631931,
			["direct"] = "1573:8018:12617:37888:46006:46011",
			["f"] = 0,
		},
		[2835] = {
			"1572:2941:352", -- [1]
			"1572:2941:352:523", -- [2]
			"1572:44409:44410:2299:931", -- [3]
			"1572:44409:44410:2299:931:2409", -- [4]
			"1572:2941:352:2859", -- [5]
			"8018:12596", -- [6]
			"43570:12617", -- [7]
			"1572:44409:44410:2299", -- [8]
			"1572:2941", -- [9]
			"43570:12617:44230:44233", -- [10]
			"43570:12617:44230:28621", -- [11]
			"43570:12617:44230", -- [12]
			"43570:12617:44231:44232", -- [13]
			"1572:2941:352:43045", -- [14]
			"43570:12617:26560", -- [15]
			"8018:12596:37888", -- [16]
			"41325:41323", -- [17]
			"41325:41322", -- [18]
			"41325:41322:41321", -- [19]
			"1572:41332", -- [20]
			"1572:2941:352:42983", -- [21]
			"1572:2941:352:523:42426", -- [22]
			"1572:2941:352:42406", -- [23]
			"1572:44409:44410:2299:931:43000", -- [24]
			"1572:2941:352:43045:43042", -- [25]
			"1572:2941:352:43045:43042:43043", -- [26]
			"1572:44409:44410:2299:43086:43072", -- [27]
			"1572:44409:44410:2299:43086:43087", -- [28]
			"1572:44409:44410:2299:43086", -- [29]
			"1572:44409:44410:2299:931:43088", -- [30]
			"1572:44409:44410:2299:931:43371", -- [31]
			"1571:1573:43701", -- [32]
			"1572:43702", -- [33]
			"1572:2941:352:523:43697", -- [34]
			"43570:12617:44231", -- [35]
			"1572:44409", -- [36]
			"1572:44409:44410", -- [37]
			"1572:44409:44407", -- [38]
			"8018:46006", -- [39]
			"8018:46006:46011", -- [40]
			"47121:47154:47147:47119", -- [41]
			"47121:47154:47118", -- [42]
			"47121:47154:47147", -- [43]
			"47121:47154", -- [44]
			"47121:47154:47155", -- [45]
			"8018:46006:46011:47875", -- [46]
			"1572:2941:47927", -- [47]
			"1572:2941:47927:48318", -- [48]
			"1572:2941:47927:48318:48321", -- [49]
			--["name"] = "Refuge Pointe, Arathi",
			["m"] = 14,
			["coord"] = 1714518352,
			["direct"] = "1573:1571:1572:8018:41325:43570:47121",
			["f"] = 0,
		},
		[2859] = {
			"43045:2409:931", -- [1]
			"352:1573", -- [2]
			"352:1573:1571", -- [3]
			"43045:2409:931:2299:44410:44409:1572", -- [4]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835", -- [5]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [6]
			"352:1573:12596", -- [7]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [8]
			"43045:2409:931:2299", -- [9]
			"352:2941", -- [10]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [11]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [12]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [13]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [14]
			"352:1573:26560", -- [15]
			"352:1573:12596:37888", -- [16]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41323", -- [17]
			"43045:2409:931:2299:44410:44409:1572:41321:41322", -- [18]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325", -- [19]
			"43045:2409:931:2299:44410:44409:1572:41321", -- [20]
			"43045:2409:931:2299:44410:44407:41332", -- [21]
			"43045:2409:42983", -- [22]
			"523:42426", -- [23]
			"523:42406", -- [24]
			"43045:2409:931:43000", -- [25]
			"43043:43042", -- [26]
			"43045:2409:931:43371:43072", -- [27]
			"43045:85731:43087", -- [28]
			"43045:2409:931:43371:43072:43086", -- [29]
			"43045:2409:931:43088", -- [30]
			"43045:2409:931:43371", -- [31]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [32]
			"352:1573:43701", -- [33]
			"43045:2409:931:2299:44410:44409:1572:43702", -- [34]
			"43045:43697", -- [35]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [36]
			"43045:2409:931:2299:44410:44409", -- [37]
			"43045:2409:931:2299:44410", -- [38]
			"43045:2409:931:2299:44410:44407", -- [39]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [40]
			"352:1573:12596:46011", -- [41]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:47121", -- [42]
			"43045:2409:931:2299:44410:44409:1572:47119", -- [43]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [44]
			"43045:2409:931:2299:44410:44409:1572:47119:47147", -- [45]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154", -- [46]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [47]
			"352:1573:12596:46011:47875", -- [48]
			"352:2941:47927", -- [49]
			"43045:2409:931:2299:48321:48318", -- [50]
			"43045:2409:931:2299:48321", -- [51]
			--["name"] = "Booty Bay, Stranglethorn",
			["m"] = 210,
			["coord"] = 1789640278,
			["direct"] = "352:523:2409:43045:43043",
			["f"] = 0,
		},
		[44410] = {
			"2299:352", -- [1]
			"2299:931:523", -- [2]
			"2299:931", -- [3]
			"44409:1572:1573", -- [4]
			"44409:1572:1571", -- [5]
			"44409:1572", -- [6]
			"2299:931:2409", -- [7]
			"44409:1572:41321:41322:41325:2835", -- [8]
			"2299:931:2409:43045:2859", -- [9]
			"44409:1572:41321:41322:41325:2835:8018", -- [10]
			"44409:1572:41321:41322:41325:2835:8018:12596", -- [11]
			"44409:1572:41321:41322:41325:2835:43570:12617", -- [12]
			"2299:2941", -- [13]
			"44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [14]
			"44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [15]
			"44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [16]
			"44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [17]
			"2299:931:2409:43045", -- [18]
			"44409:1572:41321:41322:41325:2835:43570:12617:26560", -- [19]
			"44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [20]
			"44409:1572:41321:41322:41323", -- [21]
			"44409:1572:41321:41322", -- [22]
			"44409:1572:41321:41322:41325", -- [23]
			"44409:1572:41321", -- [24]
			"44407:41332", -- [25]
			"2299:931:43000:42983", -- [26]
			"2299:931:523:42426", -- [27]
			"2299:352:42406", -- [28]
			"2299:931:43000", -- [29]
			"2299:931:2409:43045:43042", -- [30]
			"2299:931:2409:43045:43042:43043", -- [31]
			"2299:43086:43072", -- [32]
			"2299:43086:43087", -- [33]
			"2299:43086", -- [34]
			"2299:931:43088", -- [35]
			"2299:931:43371", -- [36]
			"44409:1572:41321:41322:41325:2835:43570", -- [37]
			"44409:1572:43702:43701", -- [38]
			"44409:1572:43702", -- [39]
			"2299:931:2409:43697", -- [40]
			"44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [41]
			"44409:1572:41321:41322:41325:2835:8018:46006", -- [42]
			"44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [43]
			"44409:1572:41321:41322:47121", -- [44]
			"44409:1572:47119", -- [45]
			"44409:1572:41321:41322:47121:47154:47118", -- [46]
			"44409:1572:47119:47147", -- [47]
			"44409:1572:41321:41322:47121:47154", -- [48]
			"44409:1572:41321:41322:47121:47154:47155", -- [49]
			"44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [50]
			"2299:48321:48318:47927", -- [51]
			"2299:48321:48318", -- [52]
			"2299:48321", -- [53]
			--["name"] = "Dragon's Mouth, Badlands",
			["m"] = 15,
			["coord"] = 935302066,
			["direct"] = "2299:44409:44407",
			["f"] = 0,
		},
		[43570] = {
			"2835:1572:2941:352", -- [1]
			"2835:1572:2941:352:523", -- [2]
			"2835:1572:44409:44410:2299:931", -- [3]
			"2835:1571:1573", -- [4]
			"2835:1571", -- [5]
			"2835:1572", -- [6]
			"2835:1572:44409:44410:2299:931:2409", -- [7]
			"2835:1572:2941:352:2859", -- [8]
			"8018:12596", -- [9]
			"2835:1572:44409:44410:2299", -- [10]
			"2835:1572:2941", -- [11]
			"12617:44230:44233", -- [12]
			"12617:44230:28621", -- [13]
			"12617:44230", -- [14]
			"12617:44231:44232", -- [15]
			"2835:1572:2941:352:43045", -- [16]
			"12617:26560", -- [17]
			"2835:41325:41323", -- [18]
			"2835:41325:41322", -- [19]
			"2835:41325", -- [20]
			"2835:41325:41322:41321", -- [21]
			"2835:1572:41332", -- [22]
			"2835:1572:2941:352:42983", -- [23]
			"2835:1572:2941:352:523:42426", -- [24]
			"2835:1572:2941:352:42406", -- [25]
			"2835:1572:44409:44410:2299:931:43000", -- [26]
			"2835:1572:2941:352:43045:43042", -- [27]
			"2835:1572:2941:352:43045:43042:43043", -- [28]
			"2835:1572:44409:44410:2299:43086:43072", -- [29]
			"2835:1572:44409:44410:2299:43086:43087", -- [30]
			"2835:1572:44409:44410:2299:43086", -- [31]
			"2835:1572:44409:44410:2299:931:43088", -- [32]
			"2835:1572:44409:44410:2299:931:43371", -- [33]
			"2835:1571:1573:43701", -- [34]
			"2835:1572:43702", -- [35]
			"2835:1572:2941:352:523:43697", -- [36]
			"12617:44231", -- [37]
			"2835:1572:44409", -- [38]
			"2835:1572:44409:44410", -- [39]
			"2835:1572:44409:44407", -- [40]
			"8018:46006", -- [41]
			"37888:46011", -- [42]
			"2835:47121", -- [43]
			"2835:47121:47154:47147:47119", -- [44]
			"2835:47121:47154:47118", -- [45]
			"2835:47121:47154:47147", -- [46]
			"2835:47121:47154", -- [47]
			"2835:47121:47154:47155", -- [48]
			"37888:46011:47875", -- [49]
			"2835:1572:2941:47927", -- [50]
			"2835:1572:2941:47927:48318", -- [51]
			"2835:1572:2941:47927:48318:48321", -- [52]
			--["name"] = "Stormfeather Outpost, The Hinterlands",
			["m"] = 26,
			["coord"] = 2822861603,
			["direct"] = "2835:8018:12617:37888",
			["f"] = 0,
		},
		[44409] = {
			"44410:2299:352", -- [1]
			"44410:2299:931:523", -- [2]
			"44410:2299:931", -- [3]
			"1572:1573", -- [4]
			"1572:1571", -- [5]
			"44410:2299:931:2409", -- [6]
			"1572:41321:41322:41325:2835", -- [7]
			"44410:2299:931:2409:43045:2859", -- [8]
			"1572:41321:41322:41325:2835:8018", -- [9]
			"1572:41321:41322:41325:2835:8018:12596", -- [10]
			"1572:41321:41322:41325:2835:43570:12617", -- [11]
			"44410:2299", -- [12]
			"1572:2941", -- [13]
			"1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [14]
			"1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [15]
			"1572:41321:41322:41325:2835:43570:12617:44230", -- [16]
			"1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [17]
			"44410:2299:931:2409:43045", -- [18]
			"1572:41321:41322:41325:2835:43570:12617:26560", -- [19]
			"1572:41321:41322:41325:2835:8018:12596:37888", -- [20]
			"1572:41321:41322:41323", -- [21]
			"1572:41321:41322", -- [22]
			"1572:41321:41322:41325", -- [23]
			"1572:41321", -- [24]
			"44407:41332", -- [25]
			"44410:2299:931:43000:42983", -- [26]
			"44410:2299:931:523:42426", -- [27]
			"44410:2299:352:42406", -- [28]
			"44410:2299:931:43000", -- [29]
			"44410:2299:931:2409:43045:43042", -- [30]
			"44410:2299:931:2409:43045:43042:43043", -- [31]
			"44410:2299:43086:43072", -- [32]
			"44410:2299:43086:43087", -- [33]
			"44410:2299:43086", -- [34]
			"44410:2299:931:43088", -- [35]
			"44410:2299:931:43371", -- [36]
			"1572:41321:41322:41325:2835:43570", -- [37]
			"1572:43702:43701", -- [38]
			"1572:43702", -- [39]
			"44410:2299:931:2409:43697", -- [40]
			"1572:41321:41322:41325:2835:43570:12617:44231", -- [41]
			"1572:41321:41322:41325:2835:8018:46006", -- [42]
			"1572:41321:41322:41325:2835:8018:46006:46011", -- [43]
			"1572:41321:41322:47121", -- [44]
			"1572:47119", -- [45]
			"1572:41321:41322:47121:47154:47118", -- [46]
			"1572:47119:47147", -- [47]
			"1572:41321:41322:47121:47154", -- [48]
			"1572:41321:41322:47121:47154:47155", -- [49]
			"1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [50]
			"1572:2941:47927", -- [51]
			"44410:2299:48321:48318", -- [52]
			"44410:2299:48321", -- [53]
			--["name"] = "Dustwind Dig, Badlands",
			["m"] = 15,
			["coord"] = 2096716950,
			["direct"] = "1572:44410:44407",
			["f"] = 0,
		},
		[43072] = {
			"43371:931:352", -- [1]
			"43371:931:523", -- [2]
			"43371:931", -- [3]
			"43371:931:2299:2941:1573", -- [4]
			"43371:931:2299:44410:44409:1572:1571", -- [5]
			"43371:931:2299:44410:44409:1572", -- [6]
			"43371:931:2409", -- [7]
			"43371:931:2299:44410:44409:1572:41321:41322:41325:2835", -- [8]
			"43371:931:2409:43045:2859", -- [9]
			"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [10]
			"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [11]
			"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [12]
			"43371:931:2299", -- [13]
			"43371:931:2299:2941", -- [14]
			"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [15]
			"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [16]
			"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [17]
			"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [18]
			"43371:931:2409:43045", -- [19]
			"43371:931:2299:2941:1573:26560", -- [20]
			"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [21]
			"43371:931:2299:44410:44409:1572:41321:41322:41323", -- [22]
			"43371:931:2299:44410:44409:1572:41321:41322", -- [23]
			"43371:931:2299:44410:44409:1572:41321:41322:41325", -- [24]
			"43371:931:2299:44410:44409:1572:41321", -- [25]
			"43371:931:2299:44410:44407:41332", -- [26]
			"43371:931:43000:42983", -- [27]
			"43371:931:523:42426", -- [28]
			"43371:931:352:42406", -- [29]
			"43371:931:43000", -- [30]
			"43371:931:2409:43045:43042", -- [31]
			"43371:931:2409:43045:43042:43043", -- [32]
			"43086:43087", -- [33]
			"43371:931:43088", -- [34]
			"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [35]
			"43371:931:2299:44410:44409:1572:43702:43701", -- [36]
			"43371:931:2299:44410:44409:1572:43702", -- [37]
			"43371:931:2409:43697", -- [38]
			"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [39]
			"43371:931:2299:44410:44409", -- [40]
			"43371:931:2299:44410", -- [41]
			"43371:931:2299:44410:44407", -- [42]
			"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [43]
			"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [44]
			"43371:931:2299:44410:44409:1572:41321:41322:47121", -- [45]
			"43371:931:2299:44410:44409:1572:47119", -- [46]
			"43371:931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [47]
			"43371:931:2299:44410:44409:1572:47119:47147", -- [48]
			"43371:931:2299:44410:44409:1572:41321:41322:47121:47154", -- [49]
			"43371:931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [50]
			"43371:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [51]
			"43371:931:2299:48321:48318:47927", -- [52]
			"43371:931:2299:48321:48318", -- [53]
			"43371:931:2299:48321", -- [54]
			--["name"] = "Shalewind Canyon, Redridge",
			["m"] = 49,
			["coord"] = 3344410749,
			["direct"] = "43086:43371",
			["f"] = 0,
		},
		[43702] = {
			"1572:2941:352", -- [1]
			"1572:2941:352:523", -- [2]
			"1572:44409:44410:2299:931", -- [3]
			"1573:1571", -- [4]
			"1572:44409:44410:2299:931:2409", -- [5]
			"1572:41321:41322:41325:2835", -- [6]
			"1572:2941:352:2859", -- [7]
			"1572:41321:41322:41325:2835:8018", -- [8]
			"1573:12596", -- [9]
			"1572:41321:41322:41325:2835:43570:12617", -- [10]
			"1572:44409:44410:2299", -- [11]
			"1572:2941", -- [12]
			"1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [13]
			"1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [14]
			"1572:41321:41322:41325:2835:43570:12617:44230", -- [15]
			"1573:12596:37888:44232", -- [16]
			"1572:2941:352:43045", -- [17]
			"1573:26560", -- [18]
			"1573:12596:37888", -- [19]
			"1572:41321:41322:41323", -- [20]
			"1572:41321:41322", -- [21]
			"1572:41321:41322:41325", -- [22]
			"1572:41321", -- [23]
			"1572:41332", -- [24]
			"1572:2941:352:42983", -- [25]
			"1572:2941:352:523:42426", -- [26]
			"1572:2941:352:42406", -- [27]
			"1572:44409:44410:2299:931:43000", -- [28]
			"1572:2941:352:43045:43042", -- [29]
			"1572:2941:352:43045:43042:43043", -- [30]
			"1572:44409:44410:2299:43086:43072", -- [31]
			"1572:44409:44410:2299:43086:43087", -- [32]
			"1572:44409:44410:2299:43086", -- [33]
			"1572:44409:44410:2299:931:43088", -- [34]
			"1572:44409:44410:2299:931:43371", -- [35]
			"1572:41321:41322:41325:2835:43570", -- [36]
			"1572:2941:352:523:43697", -- [37]
			"1572:41321:41322:41325:2835:43570:12617:44231", -- [38]
			"1572:44409", -- [39]
			"1572:44409:44410", -- [40]
			"1572:44409:44407", -- [41]
			"1572:41321:41322:41325:2835:8018:46006", -- [42]
			"1573:12596:46011", -- [43]
			"1572:41321:41322:47121", -- [44]
			"1572:47119", -- [45]
			"1572:41321:41322:47121:47154:47118", -- [46]
			"1572:47119:47147", -- [47]
			"1572:41321:41322:47121:47154", -- [48]
			"1572:41321:41322:47121:47154:47155", -- [49]
			"1573:12596:46011:47875", -- [50]
			"1572:2941:47927", -- [51]
			"1572:2941:47927:48318", -- [52]
			"1572:2941:47927:48318:48321", -- [53]
			--["name"] = "Gol'Bolar Quarry, Dun Morogh",
			["m"] = 27,
			["coord"] = 3258616573,
			["direct"] = "1573:1572:43701",
			["f"] = 0,
		},
		[41322] = {
			"41321:1572:2941:352", -- [1]
			"41321:1572:2941:352:523", -- [2]
			"41321:1572:44409:44410:2299:931", -- [3]
			"41323:1571:1573", -- [4]
			"41323:1571", -- [5]
			"41321:1572", -- [6]
			"41321:1572:44409:44410:2299:931:2409", -- [7]
			"41325:2835", -- [8]
			"41321:1572:2941:352:2859", -- [9]
			"41325:2835:8018", -- [10]
			"41325:2835:8018:12596", -- [11]
			"41325:2835:43570:12617", -- [12]
			"41321:1572:44409:44410:2299", -- [13]
			"41321:1572:2941", -- [14]
			"41325:2835:43570:12617:44230:44233", -- [15]
			"41325:2835:43570:12617:44230:28621", -- [16]
			"41325:2835:43570:12617:44230", -- [17]
			"41325:2835:43570:12617:44231:44232", -- [18]
			"41321:1572:2941:352:43045", -- [19]
			"41325:2835:43570:12617:26560", -- [20]
			"41325:2835:8018:12596:37888", -- [21]
			"41321:1572:41332", -- [22]
			"41321:1572:2941:352:42983", -- [23]
			"41321:1572:2941:352:523:42426", -- [24]
			"41321:1572:2941:352:42406", -- [25]
			"41321:1572:44409:44410:2299:931:43000", -- [26]
			"41321:1572:2941:352:43045:43042", -- [27]
			"41321:1572:2941:352:43045:43042:43043", -- [28]
			"41321:1572:44409:44410:2299:43086:43072", -- [29]
			"41321:1572:44409:44410:2299:43086:43087", -- [30]
			"41321:1572:44409:44410:2299:43086", -- [31]
			"41321:1572:44409:44410:2299:931:43088", -- [32]
			"41321:1572:44409:44410:2299:931:43371", -- [33]
			"41325:2835:43570", -- [34]
			"41321:1572:43702:43701", -- [35]
			"41321:1572:43702", -- [36]
			"41321:1572:2941:352:523:43697", -- [37]
			"41325:2835:43570:12617:44231", -- [38]
			"41321:1572:44409", -- [39]
			"41321:1572:44409:44410", -- [40]
			"41321:1572:44409:44407", -- [41]
			"41325:2835:8018:46006", -- [42]
			"41325:2835:8018:46006:46011", -- [43]
			"47121:47154:47147:47119", -- [44]
			"47121:47154:47118", -- [45]
			"47121:47154:47147", -- [46]
			"47121:47154", -- [47]
			"47121:47154:47155", -- [48]
			"41325:2835:8018:46006:46011:47875", -- [49]
			"41321:1572:2941:47927", -- [50]
			"41321:1572:2941:47927:48318", -- [51]
			"41321:1572:2941:47927:48318:48321", -- [52]
			--["name"] = "Greenwarden's Grove, Wetlands",
			["m"] = 56,
			["coord"] = 2418961312,
			["direct"] = "41323:41325:41321:47121",
			["f"] = 0,
		},
		[47927] = {
			"2941:352", -- [1]
			"2941:352:523", -- [2]
			"48318:48321:2299:931", -- [3]
			"2941:1573", -- [4]
			"2941:1573:1571", -- [5]
			"2941:1572", -- [6]
			"48318:48321:2299:931:2409", -- [7]
			"2941:1572:41321:41322:41325:2835", -- [8]
			"2941:352:2859", -- [9]
			"2941:1572:41321:41322:41325:2835:8018", -- [10]
			"2941:1573:12596", -- [11]
			"2941:1572:41321:41322:41325:2835:43570:12617", -- [12]
			"48318:48321:2299", -- [13]
			"2941:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [14]
			"2941:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [15]
			"2941:1572:41321:41322:41325:2835:43570:12617:44230", -- [16]
			"2941:1573:12596:37888:44232", -- [17]
			"2941:352:43045", -- [18]
			"2941:1573:26560", -- [19]
			"2941:1573:12596:37888", -- [20]
			"2941:1572:41321:41322:41323", -- [21]
			"2941:1572:41321:41322", -- [22]
			"2941:1572:41321:41322:41325", -- [23]
			"2941:1572:41321", -- [24]
			"2941:1572:41332", -- [25]
			"2941:352:42983", -- [26]
			"2941:352:523:42426", -- [27]
			"2941:352:42406", -- [28]
			"48318:48321:2299:931:43000", -- [29]
			"2941:352:43045:43042", -- [30]
			"2941:352:43045:43042:43043", -- [31]
			"48318:48321:2299:43086:43072", -- [32]
			"48318:48321:2299:43086:43087", -- [33]
			"48318:48321:2299:43086", -- [34]
			"48318:48321:2299:931:43088", -- [35]
			"48318:48321:2299:931:43371", -- [36]
			"2941:1572:41321:41322:41325:2835:43570", -- [37]
			"2941:1573:43701", -- [38]
			"2941:1572:43702", -- [39]
			"2941:352:523:43697", -- [40]
			"2941:1572:41321:41322:41325:2835:43570:12617:44231", -- [41]
			"2941:1572:44409", -- [42]
			"48318:48321:2299:44410", -- [43]
			"2941:1572:44409:44407", -- [44]
			"2941:1573:12596:46006", -- [45]
			"2941:1573:12596:46011", -- [46]
			"2941:1572:41321:41322:47121", -- [47]
			"2941:1572:47119", -- [48]
			"2941:1572:41321:41322:47121:47154:47118", -- [49]
			"2941:1572:47119:47147", -- [50]
			"2941:1572:41321:41322:47121:47154", -- [51]
			"2941:1572:41321:41322:47121:47154:47155", -- [52]
			"2941:1573:12596:46011:47875", -- [53]
			"48318:48321", -- [54]
			--["name"] = "Iron Summit, Searing Gorge",
			["m"] = 32,
			["coord"] = 1758769171,
			["direct"] = "2941:48318",
			["f"] = 0,
		},
		[8018] = {
			"2835:1572:2941:352", -- [1]
			"2835:1572:2941:352:523", -- [2]
			"2835:1572:44409:44410:2299:931", -- [3]
			"2835:1571", -- [4]
			"2835:1572", -- [5]
			"2835:1572:44409:44410:2299:931:2409", -- [6]
			"2835:1572:2941:352:2859", -- [7]
			"2835:1572:44409:44410:2299", -- [8]
			"2835:1572:2941", -- [9]
			"46006:46011:47875:44233", -- [10]
			"12617:44230:28621", -- [11]
			"12617:44230", -- [12]
			"12596:37888:44232", -- [13]
			"2835:1572:2941:352:43045", -- [14]
			"12617:26560", -- [15]
			"12596:37888", -- [16]
			"2835:41325:41323", -- [17]
			"2835:41325:41322", -- [18]
			"2835:41325", -- [19]
			"2835:41325:41322:41321", -- [20]
			"2835:1572:41332", -- [21]
			"2835:1572:2941:352:42983", -- [22]
			"2835:1572:2941:352:523:42426", -- [23]
			"2835:1572:2941:352:42406", -- [24]
			"2835:1572:44409:44410:2299:931:43000", -- [25]
			"2835:1572:2941:352:43045:43042", -- [26]
			"2835:1572:2941:352:43045:43042:43043", -- [27]
			"2835:1572:44409:44410:2299:43086:43072", -- [28]
			"2835:1572:44409:44410:2299:43086:43087", -- [29]
			"2835:1572:44409:44410:2299:43086", -- [30]
			"2835:1572:44409:44410:2299:931:43088", -- [31]
			"2835:1572:44409:44410:2299:931:43371", -- [32]
			"1573:43701", -- [33]
			"2835:1572:43702", -- [34]
			"2835:1572:2941:352:523:43697", -- [35]
			"12617:44231", -- [36]
			"2835:1572:44409", -- [37]
			"2835:1572:44409:44410", -- [38]
			"2835:1572:44409:44407", -- [39]
			"46006:46011", -- [40]
			"2835:47121", -- [41]
			"2835:47121:47154:47147:47119", -- [42]
			"2835:47121:47154:47118", -- [43]
			"2835:47121:47154:47147", -- [44]
			"2835:47121:47154", -- [45]
			"2835:47121:47154:47155", -- [46]
			"46006:46011:47875", -- [47]
			"2835:1572:2941:47927", -- [48]
			"2835:1572:2941:47927:48318", -- [49]
			"2835:1572:2941:47927:48318:48321", -- [50]
			--["name"] = "Aerie Peak, The Hinterlands",
			["m"] = 26,
			["coord"] = 477263357,
			["direct"] = "1573:2835:12596:12617:43570:46006",
			["f"] = 0,
		},
		[47118] = {
			"47154:47121:41322:41321:1572:2941:352", -- [1]
			"47154:47121:41322:41321:1572:2941:352:523", -- [2]
			"47154:47121:41322:41321:1572:44409:44410:2299:931", -- [3]
			"47154:47121:41322:41323:1571:1573", -- [4]
			"47154:47121:41322:41323:1571", -- [5]
			"47154:47121:41322:41321:1572", -- [6]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:2409", -- [7]
			"47154:47121:2835", -- [8]
			"47154:47121:41322:41321:1572:2941:352:2859", -- [9]
			"47154:47121:2835:8018", -- [10]
			"47154:47121:2835:8018:12596", -- [11]
			"47154:47121:2835:43570:12617", -- [12]
			"47154:47121:41322:41321:1572:44409:44410:2299", -- [13]
			"47154:47121:41322:41321:1572:2941", -- [14]
			"47154:47121:2835:43570:12617:44230:44233", -- [15]
			"47154:47121:2835:43570:12617:44230:28621", -- [16]
			"47154:47121:2835:43570:12617:44230", -- [17]
			"47154:47121:2835:43570:12617:44231:44232", -- [18]
			"47154:47121:41322:41321:1572:2941:352:43045", -- [19]
			"47154:47121:2835:43570:12617:26560", -- [20]
			"47154:47121:2835:8018:12596:37888", -- [21]
			"47154:47121:41322:41323", -- [22]
			"47154:47121:41322", -- [23]
			"47154:47121:41322:41325", -- [24]
			"47154:47121:41322:41321", -- [25]
			"47154:47121:41322:41321:1572:41332", -- [26]
			"47154:47121:41322:41321:1572:2941:352:42983", -- [27]
			"47154:47121:41322:41321:1572:2941:352:523:42426", -- [28]
			"47154:47121:41322:41321:1572:2941:352:42406", -- [29]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:43000", -- [30]
			"47154:47121:41322:41321:1572:2941:352:43045:43042", -- [31]
			"47154:47121:41322:41321:1572:2941:352:43045:43042:43043", -- [32]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086:43072", -- [33]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086:43087", -- [34]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086", -- [35]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:43088", -- [36]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:43371", -- [37]
			"47154:47121:2835:43570", -- [38]
			"47154:47121:41322:41321:1572:43702:43701", -- [39]
			"47154:47121:41322:41321:1572:43702", -- [40]
			"47154:47121:41322:41321:1572:2941:352:523:43697", -- [41]
			"47154:47121:2835:43570:12617:44231", -- [42]
			"47154:47121:41322:41321:1572:44409", -- [43]
			"47154:47121:41322:41321:1572:44409:44410", -- [44]
			"47154:47121:41322:41321:1572:44409:44407", -- [45]
			"47154:47121:2835:8018:46006", -- [46]
			"47154:47121:2835:8018:46006:46011", -- [47]
			"47154:47121", -- [48]
			"47147:47119", -- [49]
			"47154:47155", -- [50]
			"47154:47121:2835:8018:46006:46011:47875", -- [51]
			"47154:47121:41322:41321:1572:2941:47927", -- [52]
			"47154:47121:41322:41321:1572:2941:47927:48318", -- [53]
			"47154:47121:41322:41321:1572:2941:47927:48318:48321", -- [54]
			--["name"] = "Victor's Point, Twilight Highlands",
			["m"] = 241,
			["coord"] = 1883476665,
			["direct"] = "47147:47154",
			["f"] = 0,
		},
		[1572] = {
			"2941:352", -- [1]
			"2941:352:523", -- [2]
			"44409:44410:2299:931", -- [3]
			"44409:44410:2299:931:2409", -- [4]
			"2941:352:2859", -- [5]
			"41321:41322:41325:2835:8018", -- [6]
			"41321:41322:41325:2835:8018:12596", -- [7]
			"41321:41322:41325:2835:43570:12617", -- [8]
			"44409:44410:2299", -- [9]
			"41321:41322:41325:2835:43570:12617:44230:44233", -- [10]
			"41321:41322:41325:2835:43570:12617:44230:28621", -- [11]
			"41321:41322:41325:2835:43570:12617:44230", -- [12]
			"41321:41322:41325:2835:43570:12617:44231:44232", -- [13]
			"2941:352:43045", -- [14]
			"41321:41322:41325:2835:43570:12617:26560", -- [15]
			"41321:41322:41325:2835:8018:12596:37888", -- [16]
			"41321:41322:41323", -- [17]
			"41321:41322", -- [18]
			"41321:41322:41325", -- [19]
			"2941:352:42983", -- [20]
			"2941:352:523:42426", -- [21]
			"2941:352:42406", -- [22]
			"44409:44410:2299:931:43000", -- [23]
			"2941:352:43045:43042", -- [24]
			"2941:352:43045:43042:43043", -- [25]
			"44409:44410:2299:43086:43072", -- [26]
			"44409:44410:2299:43086:43087", -- [27]
			"44409:44410:2299:43086", -- [28]
			"44409:44410:2299:931:43088", -- [29]
			"44409:44410:2299:931:43371", -- [30]
			"41321:41322:41325:2835:43570", -- [31]
			"43702:43701", -- [32]
			"2941:352:523:43697", -- [33]
			"41321:41322:41325:2835:43570:12617:44231", -- [34]
			"44409:44410", -- [35]
			"44409:44407", -- [36]
			"41321:41322:41325:2835:8018:46006", -- [37]
			"41321:41322:41325:2835:8018:46006:46011", -- [38]
			"41321:41322:47121", -- [39]
			"41321:41322:47121:47154:47118", -- [40]
			"47119:47147", -- [41]
			"41321:41322:47121:47154", -- [42]
			"41321:41322:47121:47154:47155", -- [43]
			"41321:41322:41325:2835:8018:46006:46011:47875", -- [44]
			"2941:47927", -- [45]
			"2941:47927:48318", -- [46]
			"2941:47927:48318:48321", -- [47]
			--["name"] = "Thelsamar, Loch Modan",
			["m"] = 48,
			["coord"] = 1457816072,
			["direct"] = "1573:1571:2835:2941:41321:41332:43702:44409:47119",
			["f"] = 0,
		},
		[44407] = {
			"44410:2299:352", -- [1]
			"44410:2299:931:523", -- [2]
			"44410:2299:931", -- [3]
			"44409:1572:1573", -- [4]
			"44409:1572:1571", -- [5]
			"44409:1572", -- [6]
			"44410:2299:931:2409", -- [7]
			"44409:1572:41321:41322:41325:2835", -- [8]
			"44410:2299:931:2409:43045:2859", -- [9]
			"44409:1572:41321:41322:41325:2835:8018", -- [10]
			"44409:1572:41321:41322:41325:2835:8018:12596", -- [11]
			"44410:2299", -- [12]
			"44409:1572:2941", -- [13]
			"12617:44230:44233", -- [14]
			"12617:44230:28621", -- [15]
			"12617:44230", -- [16]
			"12617:44231:44232", -- [17]
			"44410:2299:931:2409:43045", -- [18]
			"12617:26560", -- [19]
			"44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [20]
			"44409:1572:41321:41322:41323", -- [21]
			"44409:1572:41321:41322", -- [22]
			"44409:1572:41321:41322:41325", -- [23]
			"44409:1572:41321", -- [24]
			"44410:2299:931:43000:42983", -- [25]
			"44410:2299:931:523:42426", -- [26]
			"44410:2299:352:42406", -- [27]
			"44410:2299:931:43000", -- [28]
			"44410:2299:931:2409:43045:43042", -- [29]
			"44410:2299:931:2409:43045:43042:43043", -- [30]
			"44410:2299:43086:43072", -- [31]
			"44410:2299:43086:43087", -- [32]
			"44410:2299:43086", -- [33]
			"44410:2299:931:43088", -- [34]
			"44410:2299:931:43371", -- [35]
			"44409:1572:41321:41322:41325:2835:43570", -- [36]
			"44409:1572:43702:43701", -- [37]
			"44409:1572:43702", -- [38]
			"44410:2299:931:2409:43697", -- [39]
			"12617:44231", -- [40]
			"44409:1572:41321:41322:41325:2835:8018:46006", -- [41]
			"44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [42]
			"44409:1572:41321:41322:47121", -- [43]
			"44409:1572:47119", -- [44]
			"44409:1572:41321:41322:47121:47154:47118", -- [45]
			"44409:1572:47119:47147", -- [46]
			"44409:1572:41321:41322:47121:47154", -- [47]
			"44409:1572:41321:41322:47121:47154:47155", -- [48]
			"44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [49]
			"44409:1572:2941:47927", -- [50]
			"44410:2299:48321:48318", -- [51]
			"44410:2299:48321", -- [52]
			--["name"] = "Fuselight, Badlands",
			["m"] = 15,
			["coord"] = 2759481903,
			["direct"] = "12617:41332:44409:44410",
			["f"] = 0,
		},
		[43086] = {
			"43072:43371:931:352", -- [1]
			"43072:43371:931:523", -- [2]
			"43072:43371:931", -- [3]
			"2299:2941:1573", -- [4]
			"2299:44410:44409:1572:1571", -- [5]
			"2299:44410:44409:1572", -- [6]
			"43072:43371:931:2409", -- [7]
			"2299:44410:44409:1572:41321:41322:41325:2835", -- [8]
			"43072:43371:931:2409:43045:2859", -- [9]
			"2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [10]
			"2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [11]
			"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [12]
			"2299:2941", -- [13]
			"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [14]
			"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [15]
			"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [16]
			"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [17]
			"43072:43371:931:2409:43045", -- [18]
			"2299:2941:1573:26560", -- [19]
			"2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [20]
			"2299:44410:44409:1572:41321:41322:41323", -- [21]
			"2299:44410:44409:1572:41321:41322", -- [22]
			"2299:44410:44409:1572:41321:41322:41325", -- [23]
			"2299:44410:44409:1572:41321", -- [24]
			"2299:44410:44407:41332", -- [25]
			"43072:43371:931:43000:42983", -- [26]
			"43072:43371:931:523:42426", -- [27]
			"43072:43371:931:352:42406", -- [28]
			"43072:43371:931:43000", -- [29]
			"43072:43371:931:2409:43045:43042", -- [30]
			"43072:43371:931:2409:43045:43042:43043", -- [31]
			"43087:43088", -- [32]
			"43072:43371", -- [33]
			"2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [34]
			"2299:44410:44409:1572:43702:43701", -- [35]
			"2299:44410:44409:1572:43702", -- [36]
			"43072:43371:931:2409:43697", -- [37]
			"2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [38]
			"2299:44410:44409", -- [39]
			"2299:44410", -- [40]
			"2299:44410:44407", -- [41]
			"2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [42]
			"2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [43]
			"2299:44410:44409:1572:41321:41322:47121", -- [44]
			"2299:44410:44409:1572:47119", -- [45]
			"2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [46]
			"2299:44410:44409:1572:47119:47147", -- [47]
			"2299:44410:44409:1572:41321:41322:47121:47154", -- [48]
			"2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [49]
			"2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [50]
			"2299:48321:48318:47927", -- [51]
			"2299:48321:48318", -- [52]
			"2299:48321", -- [53]
			--["name"] = "Bogpaddle, Swamp of Sorrows",
			["m"] = 51,
			["coord"] = 3098287836,
			["direct"] = "2299:43072:43087",
			["f"] = 0,
		},
		[43088] = {
			"931:352", -- [1]
			"931:523", -- [2]
			"931:2299:2941:1573", -- [3]
			"931:2299:44410:44409:1572:1571", -- [4]
			"931:2299:44410:44409:1572", -- [5]
			"931:2409", -- [6]
			"931:2299:44410:44409:1572:41321:41322:41325:2835", -- [7]
			"931:2409:43045:2859", -- [8]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [9]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [10]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [11]
			"931:2299", -- [12]
			"931:2299:2941", -- [13]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [14]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [15]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [16]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [17]
			"931:2409:43045", -- [18]
			"931:2299:2941:1573:26560", -- [19]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [20]
			"931:2299:44410:44409:1572:41321:41322:41323", -- [21]
			"931:2299:44410:44409:1572:41321:41322", -- [22]
			"931:2299:44410:44409:1572:41321:41322:41325", -- [23]
			"931:2299:44410:44409:1572:41321", -- [24]
			"931:2299:44410:44407:41332", -- [25]
			"931:43000:42983", -- [26]
			"931:523:42426", -- [27]
			"931:352:42406", -- [28]
			"931:43000", -- [29]
			"931:2409:43045:43042", -- [30]
			"931:2409:43045:43042:43043", -- [31]
			"931:43371:43072", -- [32]
			"43087:43086", -- [33]
			"931:43371", -- [34]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [35]
			"931:2299:44410:44409:1572:43702:43701", -- [36]
			"931:2299:44410:44409:1572:43702", -- [37]
			"931:2409:43697", -- [38]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [39]
			"931:2299:44410:44409", -- [40]
			"931:2299:44410", -- [41]
			"931:2299:44410:44407", -- [42]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [43]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [44]
			"931:2299:44410:44409:1572:41321:41322:47121", -- [45]
			"931:2299:44410:44409:1572:47119", -- [46]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [47]
			"931:2299:44410:44409:1572:47119:47147", -- [48]
			"931:2299:44410:44409:1572:41321:41322:47121:47154", -- [49]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [50]
			"931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [51]
			"931:2299:48321:48318:47927", -- [52]
			"931:2299:48321:48318", -- [53]
			"931:2299:48321", -- [54]
			--["name"] = "The Harborage, Swamp of Sorrows",
			["m"] = 51,
			["f"] = 0,
			["direct"] = "931:43087",
			["coord"] = 1319590159,
		},
		[28621] = {
			"44232:37888:12596:1573:2941:352", -- [1]
			"44232:37888:12596:1573:2941:352:523", -- [2]
			"44230:12617:44407:44410:2299:931", -- [3]
			"44232:37888:12596:1573", -- [4]
			"44230:12617:43570:2835:1571", -- [5]
			"44230:12617:43570:2835:1572", -- [6]
			"44230:12617:44407:44410:2299:931:2409", -- [7]
			"44230:12617:43570:2835", -- [8]
			"44230:12617:44407:44410:2299:931:2409:43045:2859", -- [9]
			"44230:12617:8018", -- [10]
			"44232:37888:12596", -- [11]
			"44230:12617", -- [12]
			"44230:12617:44407:44410:2299", -- [13]
			"44232:37888:12596:1573:2941", -- [14]
			"44230:12617:44407:44410:2299:931:2409:43045", -- [15]
			"44230:12617:26560", -- [16]
			"44232:37888", -- [17]
			"44230:12617:43570:2835:41325:41323", -- [18]
			"44230:12617:43570:2835:41325:41322", -- [19]
			"44230:12617:43570:2835:41325", -- [20]
			"44230:12617:43570:2835:41325:41322:41321", -- [21]
			"44230:12617:43570:2835:1572:41332", -- [22]
			"44232:37888:12596:1573:2941:352:42983", -- [23]
			"44232:37888:12596:1573:2941:352:523:42426", -- [24]
			"44232:37888:12596:1573:2941:352:42406", -- [25]
			"44230:12617:44407:44410:2299:931:43000", -- [26]
			"44230:12617:44407:44410:2299:931:2409:43045:43042", -- [27]
			"44230:12617:44407:44410:2299:931:2409:43045:43042:43043", -- [28]
			"44230:12617:44407:44410:2299:43086:43072", -- [29]
			"44230:12617:44407:44410:2299:43086:43087", -- [30]
			"44230:12617:44407:44410:2299:43086", -- [31]
			"44230:12617:44407:44410:2299:931:43088", -- [32]
			"44230:12617:44407:44410:2299:931:43371", -- [33]
			"44230:12617:43570", -- [34]
			"44232:37888:12596:1573:43701", -- [35]
			"44232:37888:12596:1573:43702", -- [36]
			"44230:12617:44407:44410:2299:931:2409:43697", -- [37]
			"44230:44231", -- [38]
			"44230:12617:44407:44409", -- [39]
			"44230:12617:44407:44410", -- [40]
			"44230:12617:44407", -- [41]
			"44232:37888:46011:46006", -- [42]
			"44232:37888:46011", -- [43]
			"44230:12617:43570:2835:47121", -- [44]
			"44230:12617:43570:2835:47121:47154:47147:47119", -- [45]
			"44230:12617:43570:2835:47121:47154:47118", -- [46]
			"44230:12617:43570:2835:47121:47154:47147", -- [47]
			"44230:12617:43570:2835:47121:47154", -- [48]
			"44230:12617:43570:2835:47121:47154:47155", -- [49]
			"44233:47875", -- [50]
			"44232:37888:12596:1573:2941:47927", -- [51]
			"44232:37888:12596:1573:2941:47927:48318", -- [52]
			"44230:12617:44407:44410:2299:48321", -- [53]
			--["name"] = "Northpass Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 2202547784,
			["direct"] = "44233:44230:44232",
			["f"] = 0,
		},
		[48321] = {
			"2299:352", -- [1]
			"2299:931:523", -- [2]
			"2299:931", -- [3]
			"48318:47927:2941:1573", -- [4]
			"48318:47927:2941:1573:1571", -- [5]
			"48318:47927:2941:1572", -- [6]
			"2299:931:2409", -- [7]
			"48318:47927:2941:1572:41321:41322:41325:2835", -- [8]
			"2299:931:2409:43045:2859", -- [9]
			"48318:47927:2941:1572:41321:41322:41325:2835:8018", -- [10]
			"48318:47927:2941:1573:12596", -- [11]
			"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617", -- [12]
			"48318:47927:2941", -- [13]
			"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [14]
			"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [15]
			"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:44230", -- [16]
			"48318:47927:2941:1573:12596:37888:44232", -- [17]
			"2299:931:2409:43045", -- [18]
			"48318:47927:2941:1573:26560", -- [19]
			"48318:47927:2941:1573:12596:37888", -- [20]
			"48318:47927:2941:1572:41321:41322:41323", -- [21]
			"48318:47927:2941:1572:41321:41322", -- [22]
			"48318:47927:2941:1572:41321:41322:41325", -- [23]
			"48318:47927:2941:1572:41321", -- [24]
			"2299:44410:44407:41332", -- [25]
			"2299:931:43000:42983", -- [26]
			"2299:931:523:42426", -- [27]
			"2299:352:42406", -- [28]
			"2299:931:43000", -- [29]
			"2299:931:2409:43045:43042", -- [30]
			"2299:931:2409:43045:43042:43043", -- [31]
			"2299:43086:43072", -- [32]
			"2299:43086:43087", -- [33]
			"2299:43086", -- [34]
			"2299:931:43088", -- [35]
			"2299:931:43371", -- [36]
			"48318:47927:2941:1572:41321:41322:41325:2835:43570", -- [37]
			"48318:47927:2941:1573:43701", -- [38]
			"48318:47927:2941:1572:43702", -- [39]
			"2299:931:2409:43697", -- [40]
			"48318:47927:2941:1572:41321:41322:41325:2835:43570:12617:44231", -- [41]
			"2299:44410:44409", -- [42]
			"2299:44410", -- [43]
			"2299:44410:44407", -- [44]
			"48318:47927:2941:1573:12596:46006", -- [45]
			"48318:47927:2941:1573:12596:46011", -- [46]
			"48318:47927:2941:1572:41321:41322:47121", -- [47]
			"48318:47927:2941:1572:47119", -- [48]
			"48318:47927:2941:1572:41321:41322:47121:47154:47118", -- [49]
			"48318:47927:2941:1572:47119:47147", -- [50]
			"48318:47927:2941:1572:41321:41322:47121:47154", -- [51]
			"48318:47927:2941:1572:41321:41322:47121:47154:47155", -- [52]
			"48318:47927:2941:1573:12596:46011:47875", -- [53]
			"48318:47927", -- [54]
			--["name"] = "Chiselgrip, Burning Steppes",
			["m"] = 36,
			["coord"] = 1982425835,
			["direct"] = "2299:48318",
			["f"] = 0,
		},
		[85731] = {
			"2409:352", -- [1]
			"2409:523", -- [2]
			"43087:43088:931", -- [3]
			"43087:43086:2299:2941:1573", -- [4]
			"43087:43086:2299:44410:44409:1572:1571", -- [5]
			"43087:43086:2299:44410:44409:1572", -- [6]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835", -- [7]
			"43045:2859", -- [8]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [9]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [10]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [11]
			"43087:43086:2299", -- [12]
			"43087:43086:2299:2941", -- [13]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [14]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [15]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [16]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [17]
			"43087:43086:2299:2941:1573:26560", -- [18]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [19]
			"43087:43086:2299:44410:44409:1572:41321:41322:41323", -- [20]
			"43087:43086:2299:44410:44409:1572:41321:41322", -- [21]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325", -- [22]
			"43087:43086:2299:44410:44409:1572:41321", -- [23]
			"43087:43086:2299:44410:44407:41332", -- [24]
			"2409:42983", -- [25]
			"2409:523:42426", -- [26]
			"2409:523:42406", -- [27]
			"43087:43088:931:43000", -- [28]
			"43045:43042", -- [29]
			"43045:43042:43043", -- [30]
			"43087:43086:43072", -- [31]
			"43087:43086", -- [32]
			"43087:43088", -- [33]
			"43087:43086:43072:43371", -- [34]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [35]
			"43087:43086:2299:44410:44409:1572:43702:43701", -- [36]
			"43087:43086:2299:44410:44409:1572:43702", -- [37]
			"2409:43697", -- [38]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [39]
			"43087:43086:2299:44410:44409", -- [40]
			"43087:43086:2299:44410", -- [41]
			"43087:43086:2299:44410:44407", -- [42]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [43]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [44]
			"43087:43086:2299:44410:44409:1572:41321:41322:47121", -- [45]
			"43087:43086:2299:44410:44409:1572:47119", -- [46]
			"43087:43086:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [47]
			"43087:43086:2299:44410:44409:1572:47119:47147", -- [48]
			"43087:43086:2299:44410:44409:1572:41321:41322:47121:47154", -- [49]
			"43087:43086:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [50]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [51]
			"43087:43086:2299:48321:48318:47927", -- [52]
			"43087:43086:2299:48321:48318", -- [53]
			"43087:43086:2299:48321", -- [54]
			--["name"] = "Shattered Beachhead, Blasted Lands",
			["m"] = 17,
			["direct"] = "2409:43045:43087",
			["f"] = 0,
			["coord"] = 2904442696,
		},
		[41332] = {
			"1572:2941:352", -- [1]
			"1572:2941:352:523", -- [2]
			"44407:44410:2299:931", -- [3]
			"1572:1573", -- [4]
			"1572:1571", -- [5]
			"44407:44410:2299:931:2409", -- [6]
			"1572:41321:41322:41325:2835", -- [7]
			"44407:44410:2299:931:2409:43045:2859", -- [8]
			"1572:41321:41322:41325:2835:8018", -- [9]
			"1572:41321:41322:41325:2835:8018:12596", -- [10]
			"1572:41321:41322:41325:2835:43570:12617", -- [11]
			"44407:44410:2299", -- [12]
			"1572:2941", -- [13]
			"1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [14]
			"1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [15]
			"1572:41321:41322:41325:2835:43570:12617:44230", -- [16]
			"1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [17]
			"44407:44410:2299:931:2409:43045", -- [18]
			"1572:41321:41322:41325:2835:43570:12617:26560", -- [19]
			"1572:41321:41322:41325:2835:8018:12596:37888", -- [20]
			"1572:41321:41322:41323", -- [21]
			"1572:41321:41322", -- [22]
			"1572:41321:41322:41325", -- [23]
			"1572:41321", -- [24]
			"1572:2941:352:42983", -- [25]
			"1572:2941:352:523:42426", -- [26]
			"1572:2941:352:42406", -- [27]
			"44407:44410:2299:931:43000", -- [28]
			"44407:44410:2299:931:2409:43045:43042", -- [29]
			"44407:44410:2299:931:2409:43045:43042:43043", -- [30]
			"44407:44410:2299:43086:43072", -- [31]
			"44407:44410:2299:43086:43087", -- [32]
			"44407:44410:2299:43086", -- [33]
			"44407:44410:2299:931:43088", -- [34]
			"44407:44410:2299:931:43371", -- [35]
			"1572:41321:41322:41325:2835:43570", -- [36]
			"1572:43702:43701", -- [37]
			"1572:43702", -- [38]
			"44407:44410:2299:931:2409:43697", -- [39]
			"1572:41321:41322:41325:2835:43570:12617:44231", -- [40]
			"44407:44409", -- [41]
			"44407:44410", -- [42]
			"1572:41321:41322:41325:2835:8018:46006", -- [43]
			"1572:41321:41322:41325:2835:8018:46006:46011", -- [44]
			"1572:41321:41322:47121", -- [45]
			"1572:47119", -- [46]
			"1572:41321:41322:47121:47154:47118", -- [47]
			"1572:47119:47147", -- [48]
			"1572:41321:41322:47121:47154", -- [49]
			"1572:41321:41322:47121:47154:47155", -- [50]
			"1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [51]
			"1572:2941:47927", -- [52]
			"1572:2941:47927:48318", -- [53]
			"44407:44410:2299:48321", -- [54]
			--["name"] = "Farstrider Lodge, Loch Modan",
			["m"] = 48,
			["coord"] = 3518473298,
			["direct"] = "1572:44407",
			["f"] = 0,
		},
		[44232] = {
			"37888:12596:1573:2941:352", -- [1]
			"37888:12596:1573:2941:352:523", -- [2]
			"37888:12596:1573:2941:2299:931", -- [3]
			"37888:12596:1573", -- [4]
			"37888:43570:2835:1571", -- [5]
			"37888:43570:2835:1572", -- [6]
			"37888:12596:1573:2941:2299:931:2409", -- [7]
			"37888:43570:2835", -- [8]
			"37888:12596:1573:2941:352:2859", -- [9]
			"37888:12596:8018", -- [10]
			"37888:12596", -- [11]
			"44231:12617", -- [12]
			"37888:12596:1573:2941:2299", -- [13]
			"37888:12596:1573:2941", -- [14]
			"44231:44230", -- [15]
			"37888:12596:1573:2941:352:43045", -- [16]
			"44231:12617:26560", -- [17]
			"37888:43570:2835:41325:41323", -- [18]
			"37888:43570:2835:41325:41322", -- [19]
			"37888:43570:2835:41325", -- [20]
			"37888:43570:2835:41325:41322:41321", -- [21]
			"37888:43570:2835:1572:41332", -- [22]
			"37888:12596:1573:2941:352:42983", -- [23]
			"37888:12596:1573:2941:352:523:42426", -- [24]
			"37888:12596:1573:2941:352:42406", -- [25]
			"37888:12596:1573:2941:2299:931:43000", -- [26]
			"37888:12596:1573:2941:352:43045:43042", -- [27]
			"37888:12596:1573:2941:352:43045:43042:43043", -- [28]
			"37888:12596:1573:2941:2299:43086:43072", -- [29]
			"37888:12596:1573:2941:2299:43086:43087", -- [30]
			"37888:12596:1573:2941:2299:43086", -- [31]
			"37888:12596:1573:2941:2299:931:43088", -- [32]
			"37888:12596:1573:2941:2299:931:43371", -- [33]
			"37888:43570", -- [34]
			"37888:12596:1573:43701", -- [35]
			"37888:12596:1573:43702", -- [36]
			"37888:12596:1573:2941:352:523:43697", -- [37]
			"44231:12617:44407:44409", -- [38]
			"44231:12617:44407:44410", -- [39]
			"44231:12617:44407", -- [40]
			"37888:46011:46006", -- [41]
			"37888:46011", -- [42]
			"37888:43570:2835:47121", -- [43]
			"37888:43570:2835:47121:47154:47147:47119", -- [44]
			"37888:43570:2835:47121:47154:47118", -- [45]
			"37888:43570:2835:47121:47154:47147", -- [46]
			"37888:43570:2835:47121:47154", -- [47]
			"37888:43570:2835:47121:47154:47155", -- [48]
			"44233:47875", -- [49]
			"37888:12596:1573:2941:47927", -- [50]
			"37888:12596:1573:2941:47927:48318", -- [51]
			"37888:12596:1573:2941:47927:48318:48321", -- [52]
			--["name"] = "Crown Guard Tower, Eastern Plaguelands",
			["m"] = 23,
			["coord"] = 1498000888,
			["direct"] = "44233:28621:37888:44231",
			["f"] = 0,
		},
		[47147] = {
			"47119:1572:2941:352", -- [1]
			"47119:1572:2941:352:523", -- [2]
			"47119:1572:44409:44410:2299:931", -- [3]
			"47154:47121:41322:41323:1571:1573", -- [4]
			"47154:47121:41322:41323:1571", -- [5]
			"47119:1572", -- [6]
			"47119:1572:44409:44410:2299:931:2409", -- [7]
			"47154:47121:2835", -- [8]
			"47119:1572:2941:352:2859", -- [9]
			"47154:47121:2835:8018", -- [10]
			"47154:47121:2835:8018:12596", -- [11]
			"47154:47121:2835:43570:12617", -- [12]
			"47119:1572:44409:44410:2299", -- [13]
			"47119:1572:2941", -- [14]
			"47154:47121:2835:43570:12617:44230:44233", -- [15]
			"47154:47121:2835:43570:12617:44230:28621", -- [16]
			"47154:47121:2835:43570:12617:44230", -- [17]
			"47154:47121:2835:43570:12617:44231:44232", -- [18]
			"47119:1572:2941:352:43045", -- [19]
			"47154:47121:2835:43570:12617:26560", -- [20]
			"47154:47121:2835:8018:12596:37888", -- [21]
			"47154:47121:41322:41323", -- [22]
			"47154:47121:41322", -- [23]
			"47154:47121:41322:41325", -- [24]
			"47154:47121:41322:41321", -- [25]
			"47119:1572:41332", -- [26]
			"47119:1572:2941:352:42983", -- [27]
			"47119:1572:2941:352:523:42426", -- [28]
			"47119:1572:2941:352:42406", -- [29]
			"47119:1572:44409:44410:2299:931:43000", -- [30]
			"47119:1572:2941:352:43045:43042", -- [31]
			"47119:1572:2941:352:43045:43042:43043", -- [32]
			"47119:1572:44409:44410:2299:43086:43072", -- [33]
			"47119:1572:44409:44410:2299:43086:43087", -- [34]
			"47119:1572:44409:44410:2299:43086", -- [35]
			"47119:1572:44409:44410:2299:931:43088", -- [36]
			"47119:1572:44409:44410:2299:931:43371", -- [37]
			"47154:47121:2835:43570", -- [38]
			"47119:1572:43702:43701", -- [39]
			"47119:1572:43702", -- [40]
			"47119:1572:2941:352:523:43697", -- [41]
			"47154:47121:2835:43570:12617:44231", -- [42]
			"47119:1572:44409", -- [43]
			"47119:1572:44409:44410", -- [44]
			"47119:1572:44409:44407", -- [45]
			"47154:47121:2835:8018:46006", -- [46]
			"47154:47121:2835:8018:46006:46011", -- [47]
			"47154:47121", -- [48]
			"47154:47121:2835:8018:46006:46011:47875", -- [49]
			"47119:1572:2941:47927", -- [50]
			"47119:1572:2941:47927:48318", -- [51]
			"47119:1572:2941:47927:48318:48321", -- [52]
			--["name"] = "Firebeard's Patrol, Twilight Highlands",
			["m"] = 241,
			["coord"] = 2593428401,
			["direct"] = "47119:47118:47154:47155",
			["f"] = 0,
		},
		[42406] = {
			"523:931", -- [1]
			"352:1573", -- [2]
			"352:1573:1571", -- [3]
			"352:2941:1572", -- [4]
			"523:43697:2409", -- [5]
			"352:2941:1572:41321:41322:41325:2835", -- [6]
			"523:2859", -- [7]
			"352:2941:1572:41321:41322:41325:2835:8018", -- [8]
			"352:1573:12596", -- [9]
			"352:2941:1572:41321:41322:41325:2835:43570:12617", -- [10]
			"352:2299", -- [11]
			"352:2941", -- [12]
			"352:2941:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [13]
			"352:2941:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [14]
			"352:2941:1572:41321:41322:41325:2835:43570:12617:44230", -- [15]
			"352:1573:12596:37888:44232", -- [16]
			"523:43045", -- [17]
			"352:1573:26560", -- [18]
			"352:1573:12596:37888", -- [19]
			"352:2941:1572:41321:41322:41323", -- [20]
			"352:2941:1572:41321:41322", -- [21]
			"352:2941:1572:41321:41322:41325", -- [22]
			"352:2941:1572:41321", -- [23]
			"352:2941:1572:41332", -- [24]
			"352:42983", -- [25]
			"523:42426", -- [26]
			"352:42983:43000", -- [27]
			"523:43045:43042", -- [28]
			"523:43045:43042:43043", -- [29]
			"523:931:43371:43072", -- [30]
			"523:931:43088:43087", -- [31]
			"523:931:43371:43072:43086", -- [32]
			"523:931:43088", -- [33]
			"523:931:43371", -- [34]
			"352:2941:1572:41321:41322:41325:2835:43570", -- [35]
			"352:1573:43701", -- [36]
			"352:2941:1572:43702", -- [37]
			"523:43697", -- [38]
			"352:2941:1572:41321:41322:41325:2835:43570:12617:44231", -- [39]
			"352:2299:44410:44409", -- [40]
			"352:2299:44410", -- [41]
			"352:2299:44410:44407", -- [42]
			"352:1573:12596:46006", -- [43]
			"352:1573:12596:46011", -- [44]
			"352:2941:1572:41321:41322:47121", -- [45]
			"352:2941:1572:47119", -- [46]
			"352:2941:1572:41321:41322:47121:47154:47118", -- [47]
			"352:2941:1572:47119:47147", -- [48]
			"352:2941:1572:41321:41322:47121:47154", -- [49]
			"352:2941:1572:41321:41322:47121:47154:47155", -- [50]
			"352:1573:12596:46011:47875", -- [51]
			"352:2941:47927", -- [52]
			"352:2299:48321:48318", -- [53]
			"352:2299:48321", -- [54]
			--["name"] = "Furlbrow's Pumpkin Farm, Westfall",
			["m"] = 52,
			["coord"] = 2139566119,
			["direct"] = "352:523",
			["f"] = 0,
		},
		[41325] = {
			"41322:41321:1572:2941:352", -- [1]
			"41322:41321:1572:2941:352:523", -- [2]
			"41322:41321:1572:44409:44410:2299:931", -- [3]
			"41323:1571:1573", -- [4]
			"41323:1571", -- [5]
			"41322:41321:1572", -- [6]
			"41322:41321:1572:44409:44410:2299:931:2409", -- [7]
			"41322:41321:1572:2941:352:2859", -- [8]
			"2835:8018", -- [9]
			"2835:8018:12596", -- [10]
			"2835:43570:12617", -- [11]
			"41322:41321:1572:44409:44410:2299", -- [12]
			"41322:41321:1572:2941", -- [13]
			"2835:43570:12617:44230:44233", -- [14]
			"2835:43570:12617:44230:28621", -- [15]
			"2835:43570:12617:44230", -- [16]
			"2835:43570:12617:44231:44232", -- [17]
			"41322:41321:1572:2941:352:43045", -- [18]
			"2835:43570:12617:26560", -- [19]
			"2835:8018:12596:37888", -- [20]
			"41322:41321", -- [21]
			"41322:41321:1572:41332", -- [22]
			"41322:41321:1572:2941:352:42983", -- [23]
			"41322:41321:1572:2941:352:523:42426", -- [24]
			"41322:41321:1572:2941:352:42406", -- [25]
			"41322:41321:1572:44409:44410:2299:931:43000", -- [26]
			"41322:41321:1572:2941:352:43045:43042", -- [27]
			"41322:41321:1572:2941:352:43045:43042:43043", -- [28]
			"41322:41321:1572:44409:44410:2299:43086:43072", -- [29]
			"41322:41321:1572:44409:44410:2299:43086:43087", -- [30]
			"41322:41321:1572:44409:44410:2299:43086", -- [31]
			"41322:41321:1572:44409:44410:2299:931:43088", -- [32]
			"41322:41321:1572:44409:44410:2299:931:43371", -- [33]
			"2835:43570", -- [34]
			"41323:1571:1573:43701", -- [35]
			"41322:41321:1572:43702", -- [36]
			"41322:41321:1572:2941:352:523:43697", -- [37]
			"2835:43570:12617:44231", -- [38]
			"41322:41321:1572:44409", -- [39]
			"41322:41321:1572:44409:44410", -- [40]
			"41322:41321:1572:44409:44407", -- [41]
			"2835:8018:46006", -- [42]
			"2835:8018:46006:46011", -- [43]
			"41322:47121", -- [44]
			"41322:47121:47154:47147:47119", -- [45]
			"41322:47121:47154:47118", -- [46]
			"41322:47121:47154:47147", -- [47]
			"41322:47121:47154", -- [48]
			"41322:47121:47154:47155", -- [49]
			"2835:8018:46006:46011:47875", -- [50]
			"41322:41321:1572:2941:47927", -- [51]
			"41322:41321:1572:2941:47927:48318", -- [52]
			"41322:41321:1572:2941:47927:48318:48321", -- [53]
			--["name"] = "Dun Modr, Wetlands",
			["m"] = 56,
			["coord"] = 2145791861,
			["direct"] = "2835:41323:41322",
			["f"] = 0,
		},
		[43043] = {
			"43042:43045:352", -- [1]
			"43042:43045:523", -- [2]
			"43042:43045:2409:931", -- [3]
			"43042:43045:352:1573", -- [4]
			"43042:43045:352:1573:1571", -- [5]
			"43042:43045:2409:931:2299:44410:44409:1572", -- [6]
			"43042:43045:2409", -- [7]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835", -- [8]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [9]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [10]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [11]
			"43042:43045:2409:931:2299", -- [12]
			"43042:43045:352:2941", -- [13]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [14]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [15]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [16]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [17]
			"43042:43045", -- [18]
			"43042:43045:352:1573:26560", -- [19]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [20]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41323", -- [21]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322", -- [22]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325", -- [23]
			"43042:43045:2409:931:2299:44410:44409:1572:41321", -- [24]
			"43042:43045:2409:931:2299:44410:44407:41332", -- [25]
			"43042:43045:2409:42983", -- [26]
			"43042:43045:523:42426", -- [27]
			"43042:43045:523:42406", -- [28]
			"43042:43045:2409:931:43000", -- [29]
			"43042:43045:2409:931:43371:43072", -- [30]
			"43042:43045:85731:43087", -- [31]
			"43042:43045:2409:931:43371:43072:43086", -- [32]
			"43042:43045:2409:931:43088", -- [33]
			"43042:43045:2409:931:43371", -- [34]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [35]
			"43042:43045:352:1573:43701", -- [36]
			"43042:43045:2409:931:2299:44410:44409:1572:43702", -- [37]
			"43042:43045:43697", -- [38]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [39]
			"43042:43045:2409:931:2299:44410:44409", -- [40]
			"43042:43045:2409:931:2299:44410", -- [41]
			"43042:43045:2409:931:2299:44410:44407", -- [42]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [43]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [44]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:47121", -- [45]
			"43042:43045:2409:931:2299:44410:44409:1572:47119", -- [46]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [47]
			"43042:43045:2409:931:2299:44410:44409:1572:47119:47147", -- [48]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154", -- [49]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [50]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [51]
			"43042:43045:2409:931:2299:48321:48318:47927", -- [52]
			"43042:43045:2409:931:2299:48321:48318", -- [53]
			"43042:43045:2409:931:2299:48321", -- [54]
			--["name"] = "Explorers' League Digsite, Stranglethorn",
			["m"] = 210,
			["coord"] = 2391107979,
			["direct"] = "2859:43042",
			["f"] = 0,
		},
		[43045] = {
			"2409:931", -- [1]
			"352:1573", -- [2]
			"352:1573:1571", -- [3]
			"2409:931:2299:44410:44409:1572", -- [4]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835", -- [5]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [6]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [7]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [8]
			"2409:931:2299", -- [9]
			"352:2941", -- [10]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [11]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [12]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [13]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [14]
			"352:1573:26560", -- [15]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [16]
			"2409:931:2299:44410:44409:1572:41321:41322:41323", -- [17]
			"2409:931:2299:44410:44409:1572:41321:41322", -- [18]
			"2409:931:2299:44410:44409:1572:41321:41322:41325", -- [19]
			"2409:931:2299:44410:44409:1572:41321", -- [20]
			"2409:931:2299:44410:44407:41332", -- [21]
			"2409:42983", -- [22]
			"523:42426", -- [23]
			"523:42406", -- [24]
			"2409:931:43000", -- [25]
			"43042:43043", -- [26]
			"2409:931:43371:43072", -- [27]
			"85731:43087", -- [28]
			"2409:931:43371:43072:43086", -- [29]
			"2409:931:43088", -- [30]
			"2409:931:43371", -- [31]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [32]
			"352:1573:43701", -- [33]
			"2409:931:2299:44410:44409:1572:43702", -- [34]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [35]
			"2409:931:2299:44410:44409", -- [36]
			"2409:931:2299:44410", -- [37]
			"2409:931:2299:44410:44407", -- [38]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [39]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [40]
			"2409:931:2299:44410:44409:1572:41321:41322:47121", -- [41]
			"2409:931:2299:44410:44409:1572:47119", -- [42]
			"2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [43]
			"2409:931:2299:44410:44409:1572:47119:47147", -- [44]
			"2409:931:2299:44410:44409:1572:41321:41322:47121:47154", -- [45]
			"2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [46]
			"2409:931:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [47]
			"2409:931:2299:48321:48318:47927", -- [48]
			"2409:931:2299:48321:48318", -- [49]
			"2409:931:2299:48321", -- [50]
			--["name"] = "Rebel Camp, Stranglethorn Vale",
			["m"] = 50,
			["coord"] = 2053775015,
			["direct"] = "352:523:2409:2859:43042:43697",
			["f"] = 0,
		},
		[352] = {
			"1573:1571", -- [1]
			"2941:1572", -- [2]
			"2941:1572:41321:41322:41325:2835", -- [3]
			"2941:1572:41321:41322:41325:2835:8018", -- [4]
			"1573:12596", -- [5]
			"2941:1572:41321:41322:41325:2835:43570:12617", -- [6]
			"2941:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [7]
			"2941:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [8]
			"2941:1572:41321:41322:41325:2835:43570:12617:44230", -- [9]
			"1573:12596:37888:44232", -- [10]
			"1573:26560", -- [11]
			"1573:12596:37888", -- [12]
			"2941:1572:41321:41322:41323", -- [13]
			"2941:1572:41321:41322", -- [14]
			"2941:1572:41321:41322:41325", -- [15]
			"2941:1572:41321", -- [16]
			"2941:1572:41332", -- [17]
			"523:42426", -- [18]
			"42983:43000", -- [19]
			"43045:43042", -- [20]
			"43045:43042:43043", -- [21]
			"931:43371:43072", -- [22]
			"931:43088:43087", -- [23]
			"931:43371:43072:43086", -- [24]
			"931:43088", -- [25]
			"931:43371", -- [26]
			"2941:1572:41321:41322:41325:2835:43570", -- [27]
			"1573:43701", -- [28]
			"2941:1572:43702", -- [29]
			"523:43697", -- [30]
			"2941:1572:41321:41322:41325:2835:43570:12617:44231", -- [31]
			"2299:44410:44409", -- [32]
			"2299:44410", -- [33]
			"2299:44410:44407", -- [34]
			"1573:12596:46006", -- [35]
			"1573:12596:46011", -- [36]
			"2941:1572:41321:41322:47121", -- [37]
			"2941:1572:47119", -- [38]
			"2941:1572:41321:41322:47121:47154:47118", -- [39]
			"2941:1572:47119:47147", -- [40]
			"2941:1572:41321:41322:47121:47154", -- [41]
			"2941:1572:41321:41322:47121:47154:47155", -- [42]
			"1573:12596:46011:47875", -- [43]
			"2941:47927", -- [44]
			"2299:48321:48318", -- [45]
			"2299:48321", -- [46]
			--["name"] = "Stormwind, Elwynn",
			["m"] = 84,
			["f"] = 0,
			["direct"] = "523:931:1573:2409:2859:2299:2941:43045:42983:42406",
			["coord"] = 3048651352,
		},
		[8609] = {
			"2409:523", -- [1]
			"43087:43088:931", -- [2]
			"43087:43086:2299:2941:1573", -- [3]
			"43087:43086:2299:44410:44409:1572:1571", -- [4]
			"43087:43086:2299:44410:44409:1572", -- [5]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835", -- [6]
			"43107:2859", -- [7]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018", -- [8]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596", -- [9]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617", -- [10]
			"43087:43086:2299:2941", -- [11]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:44233", -- [12]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230:28621", -- [13]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44230", -- [14]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231:44232", -- [15]
			"2409:43045", -- [16]
			"43087:43086:2299:2941:1573:26560", -- [17]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:12596:37888", -- [18]
			"43087:43086:2299:44410:44409:1572:41321:41322:41323", -- [19]
			"43087:43086:2299:44410:44409:1572:41321:41322", -- [20]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325", -- [21]
			"43087:43086:2299:44410:44409:1572:41321", -- [22]
			"43087:43086:2299:44410:44407:41332", -- [23]
			"2409:42983", -- [24]
			"2409:523:42426", -- [25]
			"2409:523:42406", -- [26]
			"43087:43088:931:43000", -- [27]
			"2409:43045:43042", -- [28]
			"2409:43045:43042:43043", -- [29]
			"43087:43086:43072", -- [30]
			"43087:43086", -- [31]
			"43087:43088", -- [32]
			"43087:43086:43072:43371", -- [33]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570", -- [34]
			"43087:43086:2299:44410:44409:1572:43702:43701", -- [35]
			"43087:43086:2299:44410:44409:1572:43702", -- [36]
			"2409:43697", -- [37]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:43570:12617:44231", -- [38]
			"43087:43086:2299:44410:44409", -- [39]
			"43087:43086:2299:44410", -- [40]
			"43087:43086:2299:44410:44407", -- [41]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006", -- [42]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011", -- [43]
			"43087:43086:2299:44410:44409:1572:41321:41322:47121", -- [44]
			"43087:43086:2299:44410:44409:1572:47119", -- [45]
			"43087:43086:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [46]
			"43087:43086:2299:44410:44409:1572:47119:47147", -- [47]
			"43087:43086:2299:44410:44409:1572:41321:41322:47121:47154", -- [48]
			"43087:43086:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [49]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325:2835:8018:46006:46011:47875", -- [50]
			"43087:43086:2299:48321:48318:47927", -- [51]
			"43087:43086:2299:48321:48318", -- [52]
			"43087:43086:2299:48321", -- [53]
			--["name"] = "Nethergarde Keep, Blasted Lands",
			["m"] = 17,
			["coord"] = 2629056374,
			["direct"] = "352:2409:2299:43087:43107",
			["f"] = 0,
		},
	}, -- [2]
	{
		[22485] = {
			"18788:18785:16822", -- [1]
			"18788:18785", -- [2]
			"18788:18789", -- [3]
			"18788:18940:18809", -- [4]
			"18937:18938", -- [5]
			"18788:18940:18809:18939", -- [6]
			"18788:18940", -- [7]
			"18788:18785:16822:18931", -- [8]
			"18937:19583", -- [9]
			"18788:18940:18809:18939:19581", -- [10]
			"18788:18785:16822:20234", -- [11]
			"18937:18938:20515", -- [12]
			"18788:21107", -- [13]
			"18937:22216", -- [14]
			["direct"] = "18788:18937",
			["coord"] = 1773488635,
			["m"] = 102,
			["f"] = 0,
		},
		[21107] = {
			"18788:18785:16822", -- [1]
			"18788:18785", -- [2]
			"18788:18789", -- [3]
			"18788:18940:18809", -- [4]
			"18788:18940:18809:18939", -- [5]
			"18788:18940", -- [6]
			"18788:18785:16822:18931", -- [7]
			"18938:19583", -- [8]
			"18788:18940:18809:18939:19581", -- [9]
			"18788:18785:16822:20234", -- [10]
			"18938:20515", -- [11]
			"18788:22485", -- [12]
			["direct"] = "18788:18938:18937:22216",
			["coord"] = 2623648913,
			["m"] = 105,
			["f"] = 0,
		},
		[18938] = {
			"21107:18788:18785:16822", -- [1]
			"21107:18788:18785", -- [2]
			"21107:18788", -- [3]
			"21107:18788:18789", -- [4]
			"21107:18788:18940:18809", -- [5]
			"21107:18788:18940:18809:18939", -- [6]
			"21107:18788:18940", -- [7]
			"21107:18788:18785:16822:18931", -- [8]
			"21107:18788:18940:18809:18939:19581", -- [9]
			"21107:18788:18785:16822:20234", -- [10]
			"18937:22485", -- [11]
			["direct"] = "18937:19583:20515:21107:22216",
			["coord"] = 1451467664,
			["m"] = 109,
			["f"] = 0,
		},
		[18939] = {
			"18809:16822", -- [1]
			"18809:16822:18785", -- [2]
			"18809:18940:18788", -- [3]
			"18809:18789", -- [4]
			"18809:18940:18788:21107:18938", -- [5]
			"18809:18940:18788:18937", -- [6]
			"18809:18940", -- [7]
			"18809:16822:18931", -- [8]
			"18809:18940:18788:21107:18938:19583", -- [9]
			"18809:16822:20234", -- [10]
			"18809:18940:18788:21107:18938:20515", -- [11]
			"18809:18940:18788:21107", -- [12]
			"18809:18940:18788:21107:22216", -- [13]
			"18809:18940:18788:22485", -- [14]
			["direct"] = "18809:19581",
			["coord"] = 1615302149,
			["m"] = 104,
			["f"] = 0,
		},
		[18940] = {
			"18788:18785", -- [1]
			"18788:21107:18938", -- [2]
			"18809:18939", -- [3]
			"18788:18937", -- [4]
			"16822:18931", -- [5]
			"18788:21107:18938:19583", -- [6]
			"18809:18939:19581", -- [7]
			"16822:20234", -- [8]
			"18788:21107:18938:20515", -- [9]
			"18788:21107", -- [10]
			"18788:21107:22216", -- [11]
			"18788:22485", -- [12]
			["direct"] = "16822:18788:18789:18809",
			["coord"] = 2743757380,
			["m"] = 111,
			["f"] = 0,
		},
		[18788] = {
			"18785:16822", -- [1]
			"18940:18809", -- [2]
			"21107:18938", -- [3]
			"18940:18809:18939", -- [4]
			"18785:16822:18931", -- [5]
			"21107:18938:19583", -- [6]
			"18940:18809:18939:19581", -- [7]
			"18785:16822:20234", -- [8]
			"21107:18938:20515", -- [9]
			"21107:22216", -- [10]
			["direct"] = "18785:18789:18937:18940:21107:22485",
			["f"] = 0,
			["m"] = 102,
			["coord"] = 2914485116,
		},
		[18789] = {
			"18940:16822", -- [1]
			"18788:18785", -- [2]
			"18788:21107:18938", -- [3]
			"18809:18939", -- [4]
			"18788:18937", -- [5]
			"18940:16822:18931", -- [6]
			"18788:21107:18938:19583", -- [7]
			"18809:18939:19581", -- [8]
			"18940:16822:20234", -- [9]
			"18788:21107:18938:20515", -- [10]
			"18788:21107", -- [11]
			"18788:21107:22216", -- [12]
			"18788:22485", -- [13]
			["direct"] = "18788:18809:18940",
			["coord"] = 2325856347,
			["m"] = 107,
			["f"] = 0,
		},
		[16822] = {
			"18785:18788", -- [1]
			"18940:18789", -- [2]
			"18785:18788:21107:18938", -- [3]
			"18809:18939", -- [4]
			"18785:18788:18937", -- [5]
			"18785:18788:21107:18938:19583", -- [6]
			"18809:18939:19581", -- [7]
			"18785:18788:21107:18938:20515", -- [8]
			"18785:18788:21107", -- [9]
			"18785:18788:21107:22216", -- [10]
			"18785:18788:22485", -- [11]
			["direct"] = "18785:18809:18940:18931:20234",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 2347147235,
		},
		[22216] = {
			"21107:18788:18785:16822", -- [1]
			"21107:18788:18785", -- [2]
			"21107:18788", -- [3]
			"21107:18788:18789", -- [4]
			"21107:18788:18940:18809", -- [5]
			"21107:18788:18940:18809:18939", -- [6]
			"21107:18788:18940", -- [7]
			"21107:18788:18785:16822:18931", -- [8]
			"18938:19583", -- [9]
			"21107:18788:18940:18809:18939:19581", -- [10]
			"21107:18788:18785:16822:20234", -- [11]
			"18938:20515", -- [12]
			"18937:22485", -- [13]
			["direct"] = "18938:18937:21107",
			["coord"] = 2648008034,
			["m"] = 105,
			["f"] = 0,
		},
		[18931] = {
			"18785:18788", -- [1]
			"16822:18940:18789", -- [2]
			"16822:18809", -- [3]
			"18785:18788:21107:18938", -- [4]
			"16822:18809:18939", -- [5]
			"18785:18788:18937", -- [6]
			"16822:18940", -- [7]
			"18785:18788:21107:18938:19583", -- [8]
			"16822:18809:18939:19581", -- [9]
			"18785:18788:21107:18938:20515", -- [10]
			"18785:18788:21107", -- [11]
			"18785:18788:21107:22216", -- [12]
			"18785:18788:22485", -- [13]
			["direct"] = "16822:18785:20234",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 3755968055,
		},
		[19583] = {
			"18938:21107:18788:18785:16822", -- [1]
			"18938:21107:18788:18785", -- [2]
			"18938:21107:18788", -- [3]
			"18938:21107:18788:18789", -- [4]
			"18938:21107:18788:18940:18809", -- [5]
			"18938:21107:18788:18940:18809:18939", -- [6]
			"18938:21107:18788:18940", -- [7]
			"18938:21107:18788:18785:16822:18931", -- [8]
			"18938:21107:18788:18940:18809:18939:19581", -- [9]
			"18938:21107:18788:18785:16822:20234", -- [10]
			"18938:21107", -- [11]
			"18938:22216", -- [12]
			"18937:22485", -- [13]
			["direct"] = "18938:18937:20515",
			["f"] = 0,
			["m"] = 109,
			["coord"] = 1944213875,
		},
		[20234] = {
			"16822:18785", -- [1]
			"16822:18785:18788", -- [2]
			"16822:18940:18789", -- [3]
			"16822:18809", -- [4]
			"16822:18785:18788:21107:18938", -- [5]
			"16822:18809:18939", -- [6]
			"16822:18785:18788:18937", -- [7]
			"16822:18940", -- [8]
			"16822:18785:18788:21107:18938:19583", -- [9]
			"16822:18809:18939:19581", -- [10]
			"16822:18785:18788:21107:18938:20515", -- [11]
			"16822:18785:18788:21107", -- [12]
			"16822:18785:18788:21107:22216", -- [13]
			"16822:18785:18788:22485", -- [14]
			["direct"] = "16822:18931",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 3370277268,
		},
		[18937] = {
			"18788:18785:16822", -- [1]
			"18788:18785", -- [2]
			"18788:18789", -- [3]
			"18788:18940:18809", -- [4]
			"18788:18940:18809:18939", -- [5]
			"18788:18940", -- [6]
			"18788:18785:16822:18931", -- [7]
			"18788:18940:18809:18939:19581", -- [8]
			"18788:18785:16822:20234", -- [9]
			"18938:20515", -- [10]
			["direct"] = "18788:18938:19583:21107:22216:22485",
			["f"] = 0,
			["m"] = 105,
			["coord"] = 1624087928,
		},
		[18809] = {
			"16822:18785", -- [1]
			"18940:18788", -- [2]
			"18940:18788:21107:18938", -- [3]
			"18940:18788:18937", -- [4]
			"16822:18931", -- [5]
			"18940:18788:21107:18938:19583", -- [6]
			"18939:19581", -- [7]
			"16822:20234", -- [8]
			"18940:18788:21107:18938:20515", -- [9]
			"18940:18788:21107", -- [10]
			"18940:18788:21107:22216", -- [11]
			"18940:18788:22485", -- [12]
			["direct"] = "16822:18789:18939:18940",
			["coord"] = 2554891688,
			["m"] = 108,
			["f"] = 0,
		},
		[18785] = {
			"18788:18789", -- [1]
			"16822:18809", -- [2]
			"18788:21107:18938", -- [3]
			"16822:18809:18939", -- [4]
			"18788:18937", -- [5]
			"18788:18940", -- [6]
			"16822:18931", -- [7]
			"18788:21107:18938:19583", -- [8]
			"16822:18809:18939:19581", -- [9]
			"16822:20234", -- [10]
			"18788:21107:18938:20515", -- [11]
			"18788:21107", -- [12]
			"18788:21107:22216", -- [13]
			"18788:22485", -- [14]
			["direct"] = "16822:18788",
			["f"] = 0,
			["m"] = 100,
			["coord"] = 1079467854,
		},
		[20515] = {
			"18938:21107:18788:18785:16822", -- [1]
			"18938:21107:18788:18785", -- [2]
			"18938:21107:18788", -- [3]
			"18938:21107:18788:18789", -- [4]
			"18938:21107:18788:18940:18809", -- [5]
			"18938:21107:18788:18940:18809:18939", -- [6]
			"18938:18937", -- [7]
			"18938:21107:18788:18940", -- [8]
			"18938:21107:18788:18785:16822:18931", -- [9]
			"18938:21107:18788:18940:18809:18939:19581", -- [10]
			"18938:21107:18788:18785:16822:20234", -- [11]
			"18938:21107", -- [12]
			"18938:22216", -- [13]
			"18938:18937:22485", -- [14]
			["m"] = 109,
			["f"] = 0,
			["direct"] = "18938:19583",
			["coord"] = 2800462568,
		},
		[19581] = {
			"18939:18809:16822", -- [1]
			"18939:18809:16822:18785", -- [2]
			"18939:18809:18940:18788", -- [3]
			"18939:18809:18789", -- [4]
			"18939:18809", -- [5]
			"18939:18809:18940:18788:21107:18938", -- [6]
			"18939:18809:18940:18788:18937", -- [7]
			"18939:18809:18940", -- [8]
			"18939:18809:16822:18931", -- [9]
			"18939:18809:18940:18788:21107:18938:19583", -- [10]
			"18939:18809:16822:20234", -- [11]
			"18939:18809:18940:18788:21107:18938:20515", -- [12]
			"18939:18809:18940:18788:21107", -- [13]
			"18939:18809:18940:18788:21107:22216", -- [14]
			"18939:18809:18940:18788:22485", -- [15]
			["direct"] = "18939",
			["coord"] = 2718322169,
			["m"] = 104,
			["f"] = 0,
		},
	}, -- [3]
	{
		[29750] = {
			"30433:28674:23736", -- [1]
			"29721:28615:28623:26876:24061", -- [2]
			"29721:28615:26878:23859", -- [3]
			"30433:28674:26879:24795:27046", -- [4]
			"29721:28615:26878", -- [5]
			"30433:28674:26879", -- [6]
			"30433:28674:28574:26602", -- [7]
			"30433:28674:26877:26881", -- [8]
			"30433:28674:26877", -- [9]
			"29721:28615:26851", -- [10]
			"29721:28615:28618:26880", -- [11]
			"29721:28615:28623:26876", -- [12]
			"30433:28674:26879:24795", -- [13]
			"30433:28674:28196", -- [14]
			"29721:28615:26878:23859:28197", -- [15]
			"30433:28674:26877:26881:28195", -- [16]
			"30433:31069:30869", -- [17]
			"29721:28615:28623", -- [18]
			"29721:28615", -- [19]
			"29721:28615:28618", -- [20]
			"29721:28615:28623:28624", -- [21]
			"30433:28674:28574", -- [22]
			"30433:28674:28574:28037", -- [23]
			"30433:28674", -- [24]

			"29721:32571", -- [25]
			"30433:31069:31078", -- [26]
			"29721:28615:28623:28624:30569", -- [27]
			"29950:30314", -- [28]
			"30433:31069", -- [29]
			"29721:30271", -- [30]
			"29950:33849", -- [31]
			["direct"] = "29721:29951:29950:30433",
			["coord"] = 1267777152,
			["m"] = 120,
			["f"] = 0,
		},
		[26602] = {
			"28195:28196:28197:23736", -- [1]
			"26881:26878:26880:24061", -- [2]
			"26881:26878:23859", -- [3]
			"24795:27046", -- [4]
			"26881:26878", -- [5]
			"26881:26877", -- [6]
			"26881:26851", -- [7]
			"26881:26878:26880", -- [8]
			"26881:26878:26880:26876", -- [9]
			"28195:28196", -- [10]
			"28195:28196:28197", -- [11]
			"26881:30869", -- [12]
			"26881:26878:28615:28623", -- [13]
			"26881:26878:28615", -- [14]
			"26881:26878:28618", -- [15]
			"26881:26878:28615:28623:28624", -- [16]
			"28574:28674", -- [17]
			"28574:28674:29721", -- [18]
			"28574:28674:30433:29750", -- [19]
			"28574:28674:29721:32571", -- [20]
			"28574:31078", -- [21]
			"28574:31078:30314:29950:29951", -- [22]
			"28574:31078:30314:29950", -- [23]
			"26881:26878:28615:28623:28624:30569", -- [24]
			"28574:31078:30314", -- [25]
			"28574:28674:30433", -- [26]
			"28574:28674:31069", -- [27]
			"28574:28674:30271", -- [28]
			"28574:31078:30314:33849", -- [29]
			["m"] = 114,
			["f"] = 0,
			["direct"] = "26879:26881:24795:28195:28574:28037",
			["coord"] = 2427204436,
		},
		[31078] = {
			"30869:26877:26878:23859:23736", -- [1]
			"30869:26877:26878:26880:24061", -- [2]
			"30869:26877:26878:23859", -- [3]
			"28574:26602:24795:27046", -- [4]
			"30869:26877:26878", -- [5]
			"28574:26602:26879", -- [6]
			"28574:26602", -- [7]
			"30869:26881", -- [8]
			"30869:26877", -- [9]
			"30869:26877:26851", -- [10]
			"30869:26877:26878:26880", -- [11]
			"31069:30433:28674:28615:28623:26876", -- [12]
			"28574:26602:24795", -- [13]
			"30869:26881:28196", -- [14]
			"30869:26877:26878:23859:28197", -- [15]
			"28574:26602:28195", -- [16]
			"31069:30433:28674:28615:28623", -- [17]
			"31069:30433:28674:28615", -- [18]
			"31069:30433:28674:28615:28618", -- [19]
			"30314:29950:29951:28624", -- [20]
			"31069:30433:28674", -- [21]
			"31069:30433:28674:29721", -- [22]
			"31069:30433:29750", -- [23]
			"30314:29950:29951:32571", -- [24]
			"30314:29950:29951", -- [25]
			"30314:29950", -- [26]
			"30314:29950:29951:28624:30569", -- [27]
			"31069:30433", -- [28]
			"31069:30433:28674:30271", -- [29]
			"30314:33849", -- [30]
			["direct"] = "30869:28574:28037:30314:31069",
			["coord"] = 832469612,
			["m"] = 118,
			["f"] = 0,
		},
		[28623] = {
			"26876:24061:23736", -- [1]
			"26876:24061", -- [2]
			"28618:26880:23859", -- [3]
			"28615:26851:26881:26602:24795:27046", -- [4]
			"28618:26878", -- [5]
			"28615:26851:26881:26879", -- [6]
			"28615:26851:26881:26602", -- [7]
			"28615:26851:26881", -- [8]
			"28615:26877", -- [9]
			"28615:26851", -- [10]
			"28618:26880", -- [11]
			"28615:26851:26881:26602:24795", -- [12]
			"28615:26851:28196", -- [13]
			"28618:26880:23859:28197", -- [14]
			"28615:26851:26881:28195", -- [15]
			"28615:26877:30869", -- [16]
			"28615:28674:28574", -- [17]
			"28615:28674:28574:28037", -- [18]
			"28615:28674", -- [19]
			"28615:29721", -- [20]
			"28615:29721:29750", -- [21]
			"28624:32571", -- [22]
			"28615:28674:31069:31078", -- [23]
			"28624:29951", -- [24]
			"28615:29721:29750:29950", -- [25]
			"28624:30569", -- [26]
			"28615:28674:31069:30314", -- [27]
			"28615:28674:30433", -- [28]
			"28615:28674:31069", -- [29]
			"28615:30271", -- [30]
			"28615:28674:33849", -- [31]
			["direct"] = "26876:28615:28618:28624",
			["coord"] = 1782293786,
			["m"] = 121,
			["f"] = 0,
		},
		[28624] = {
			"26876:24061:23736", -- [1]
			"26876:24061", -- [2]
			"26876:26880:23859", -- [3]
			"28623:28615:26851:26881:26602:24795:27046", -- [4]
			"28623:28618:26878", -- [5]
			"28623:28615:26851:26881:26879", -- [6]
			"28623:28615:26851:26881:26602", -- [7]
			"28623:28615:26851:26881", -- [8]
			"28623:28615:26877", -- [9]
			"28623:28615:26851", -- [10]
			"26876:26880", -- [11]
			"28623:28615:26851:26881:26602:24795", -- [12]
			"28623:28615:26851:28196", -- [13]
			"26876:26880:23859:28197", -- [14]
			"28623:28615:26851:26881:28195", -- [15]
			"28623:28615:26877:30869", -- [16]
			"28623:28615", -- [17]
			"28623:28618", -- [18]
			"28623:28615:28674:28574", -- [19]
			"28623:28615:28674:28574:28037", -- [20]
			"28623:28615:28674", -- [21]
			"28623:28615:29721", -- [22]
			"28623:28615:29721:29750", -- [23]
			"28623:28615:28674:31069:31078", -- [24]
			"29951:29950", -- [25]
			"29951:29950:30314", -- [26]
			"28623:28615:28674:30433", -- [27]
			"28623:28615:28674:31069", -- [28]
			"28623:28615:30271", -- [29]
			"29951:29950:33849", -- [30]
			["m"] = 121,
			["coord"] = 2575864175,
			["direct"] = "26876:28623:32571:29951:30569",
			["f"] = 0,
		},
		[29950] = {
			"29951:28624:26876:24061:23736", -- [1]
			"29951:28624:26876:24061", -- [2]
			"29750:29721:28615:26878:23859", -- [3]
			"30314:31078:28574:26602:24795:27046", -- [4]
			"29750:29721:28615:26878", -- [5]
			"29750:30433:28674:26879", -- [6]
			"30314:31078:28574:26602", -- [7]
			"29750:30433:28674:26877:26881", -- [8]
			"29750:30433:28674:26877", -- [9]
			"29750:29721:28615:26851", -- [10]
			"29750:29721:28615:28618:26880", -- [11]
			"29951:28624:26876", -- [12]
			"30314:31078:28574:26602:24795", -- [13]
			"29750:30433:28674:28196", -- [14]
			"29750:29721:28615:26878:23859:28197", -- [15]
			"29750:30433:28674:26877:26881:28195", -- [16]
			"33849:31069:30869", -- [17]
			"29750:29721:28615:28623", -- [18]
			"29750:29721:28615", -- [19]
			"29750:29721:28615:28618", -- [20]
			"29951:28624", -- [21]
			"30314:31078:28574", -- [22]
			"30314:31078:28037", -- [23]
			"29750:30433:28674", -- [24]
			"29750:29721", -- [25]
			"29951:32571", -- [26]
			"30314:31078", -- [27]
			"29951:28624:30569", -- [28]
			"29750:30433", -- [29]
			"33849:31069", -- [30]
			"29750:29721:30271", -- [31]
			["direct"] = "29750:29951:30314:33849",
			["coord"] = 1314938152,
			["m"] = 120,
			["f"] = 0,
		},
		[29951] = {
			"28624:26876:24061:23736", -- [1]
			"28624:26876:24061", -- [2]
			"28624:26876:26880:23859", -- [3]
			"29950:30314:31078:28574:26602:24795:27046", -- [4]
			"29750:29721:28615:26878", -- [5]
			"29750:30433:28674:26879", -- [6]
			"29950:30314:31078:28574:26602", -- [7]
			"29750:30433:28674:26877:26881", -- [8]
			"29750:30433:28674:26877", -- [9]
			"29750:29721:28615:26851", -- [10]
			"28624:26876:26880", -- [11]
			"28624:26876", -- [12]
			"29950:30314:31078:28574:26602:24795", -- [13]
			"29750:30433:28674:28196", -- [14]
			"28624:26876:26880:23859:28197", -- [15]
			"29750:30433:28674:26877:26881:28195", -- [16]
			"29750:30433:31069:30869", -- [17]
			"28624:28623", -- [18]
			"29750:29721:28615", -- [19]
			"28624:28623:28618", -- [20]
			"29950:30314:31078:28574", -- [21]
			"29950:30314:31078:28037", -- [22]
			"29750:30433:28674", -- [23]
			"29750:29721", -- [24]
			"29950:30314:31078", -- [25]
			"28624:30569", -- [26]
			"29950:30314", -- [27]
			"29750:30433", -- [28]
			"29750:30433:31069", -- [29]
			"29750:29721:30271", -- [30]
			"29950:33849", -- [31]
			["direct"] = "28624:29750:32571:29950",
			["coord"] = 1911834618,
			["m"] = 120,
			["f"] = 0,
		},
		[30271] = {
			"26878:23859:23736", -- [1]
			"28615:28623:26876:24061", -- [2]
			"26878:23859", -- [3]
			"26878:26881:26602:24795:27046", -- [4]
			"28674:26879", -- [5]
			"26878:26881:26602", -- [6]
			"26878:26881", -- [7]
			"28674:26877", -- [8]
			"26878:26851", -- [9]
			"26878:26880", -- [10]
			"28615:28623:26876", -- [11]
			"26878:26881:26602:24795", -- [12]
			"26878:28196", -- [13]
			"26878:23859:28197", -- [14]
			"26878:26881:28195", -- [15]
			"28674:30869", -- [16]
			"28615:28623", -- [17]
			"28615:28618", -- [18]
			"28615:28623:28624", -- [19]
			"28674:28574", -- [20]
			"28674:28574:28037", -- [21]
			"29721:29750", -- [22]
			"29721:32571", -- [23]
			"28674:31069:31078", -- [24]
			"29721:29750:29951", -- [25]
			"29721:29750:29950", -- [26]
			"28615:28623:28624:30569", -- [27]
			"28674:31069:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"28674:33849", -- [31]
			["direct"] = "26878:28615:28674:29721",
			["coord"] = 3097480930,
			["m"] = 127,
			["f"] = 0,
		},
		[28195] = {
			"28196:28197:23736", -- [1]
			"28196:26878:26880:24061", -- [2]
			"28196:26878:23859", -- [3]
			"26879:24795:27046", -- [4]
			"28196:26878", -- [5]
			"26881:26877", -- [6]
			"28196:26851", -- [7]
			"28196:26878:26880", -- [8]
			"28196:26878:26880:26876", -- [9]
			"26879:24795", -- [10]
			"28196:28197", -- [11]
			"26881:30869", -- [12]
			"28196:26878:28615:28623", -- [13]
			"28196:26878:28615", -- [14]
			"28196:26878:28618", -- [15]
			"28196:26878:28615:28623:28624", -- [16]
			"26602:28574", -- [17]
			"26602:28037", -- [18]
			"28196:28674", -- [19]
			"28196:28674:29721", -- [20]
			"28196:28674:30433:29750", -- [21]
			"28196:28674:29721:32571", -- [22]
			"26602:28574:31078", -- [23]
			"28196:28674:30433:29750:29951", -- [24]
			"28196:28674:30433:29750:29950", -- [25]
			"28196:26878:28615:28623:28624:30569", -- [26]
			"26881:30869:30314", -- [27]
			"28196:28674:30433", -- [28]
			"26881:30869:31069", -- [29]
			"28196:26878:30271", -- [30]
			"28196:28674:33849", -- [31]
			["direct"] = "26879:26602:26881:28196",
			["coord"] = 3371205577,
			["m"] = 114,
			["f"] = 0,
		},
		[28574] = {
			"30869:26877:26878:23859:23736", -- [1]
			"30869:26877:26878:26880:24061", -- [2]
			"30869:26877:26878:23859", -- [3]
			"26602:24795:27046", -- [4]
			"30869:26877:26878", -- [5]
			"26602:26879", -- [6]
			"26602:26881", -- [7]
			"30869:26877", -- [8]
			"30869:26877:26851", -- [9]
			"30869:26877:26878:26880", -- [10]
			"28674:28615:28623:26876", -- [11]
			"26602:24795", -- [12]
			"26602:28195:28196", -- [13]
			"26602:28195:28196:28197", -- [14]
			"26602:28195", -- [15]
			"28674:28615:28623", -- [16]
			"28674:28615", -- [17]
			"28674:28615:28618", -- [18]
			"28674:28615:28623:28624", -- [19]
			"28674:29721", -- [20]
			"28674:30433:29750", -- [21]
			"28674:29721:32571", -- [22]
			"31078:30314:29950:29951", -- [23]
			"31078:30314:29950", -- [24]
			"28674:28615:28623:28624:30569", -- [25]
			"31078:30314", -- [26]
			"28674:30433", -- [27]
			"28674:31069", -- [28]
			"28674:30271", -- [29]
			"31078:30314:33849", -- [30]
			["m"] = 119,
			["f"] = 0,
			["direct"] = "26602:30869:28037:28674:31078",
			["coord"] = 2150407428,
		},
		[24795] = {
			"26602:28195:28196:28197:23736", -- [1]
			"26602:26881:26878:26880:24061", -- [2]
			"26602:26881:26878:23859", -- [3]
			"26602:26881:26878", -- [4]
			"26602:26881", -- [5]
			"26602:26881:26877", -- [6]
			"26602:26881:26851", -- [7]
			"26602:26881:26878:26880", -- [8]
			"26602:26881:26878:26880:26876", -- [9]
			"26602:28195:28196", -- [10]
			"26602:28195:28196:28197", -- [11]
			"26602:28195", -- [12]
			"26602:26881:30869", -- [13]
			"26602:26881:26878:28615:28623", -- [14]
			"26602:26881:26878:28615", -- [15]
			"26602:26881:26878:28618", -- [16]
			"26602:26881:26878:28615:28623:28624", -- [17]
			"26602:28574", -- [18]
			"26602:28037", -- [19]
			"26602:28574:28674", -- [20]
			"26602:28574:28674:29721", -- [21]
			"26602:28574:28674:30433:29750", -- [22]
			"26602:28574:28674:29721:32571", -- [23]
			"26602:28574:31078", -- [24]
			"26602:28574:31078:30314:29950:29951", -- [25]
			"26602:28574:31078:30314:29950", -- [26]
			"26602:26881:26878:28615:28623:28624:30569", -- [27]
			"26602:28574:31078:30314", -- [28]
			"26602:28574:28674:30433", -- [29]
			"26602:28574:28674:31069", -- [30]
			"26602:28574:28674:30271", -- [31]
			"26602:28574:31078:30314:33849", -- [32]
			["direct"] = "27046:26879:26602",
			["coord"] = 1939691395,
			["m"] = 114,
			["f"] = 0,
		},

		[26876] = {
			"24061:23736", -- [1]
			"26880:23859", -- [2]
			"26880:26878:26881:26602:24795:27046", -- [3]
			"26880:26878", -- [4]
			"26880:26878:26881:26879", -- [5]
			"26880:26878:26881:26602", -- [6]
			"26880:26878:26881", -- [7]
			"28623:28615:26877", -- [8]
			"26880:26878:26851", -- [9]
			"26880:26878:26881:26602:24795", -- [10]
			"26880:26878:28196", -- [11]
			"26880:23859:28197", -- [12]
			"26880:26878:26881:28195", -- [13]
			"28623:28615:26877:30869", -- [14]
			"28623:28615", -- [15]
			"28623:28618", -- [16]
			"28623:28615:28674:28574", -- [17]
			"28623:28615:28674:28574:28037", -- [18]
			"28623:28615:28674", -- [19]
			"28623:28615:29721", -- [20]
			"28623:28615:29721:29750", -- [21]
			"28624:32571", -- [22]
			"28623:28615:28674:31069:31078", -- [23]
			"28624:29951", -- [24]
			"28624:29951:29950", -- [25]
			"28624:30569", -- [26]
			"28623:28615:28674:31069:30314", -- [27]
			"28623:28615:28674:30433", -- [28]
			"28623:28615:28674:31069", -- [29]
			"28623:28615:30271", -- [30]
			"28623:28615:28674:33849", -- [31]
			["direct"] = "24061:26880:28623:28624",
			["coord"] = 2572305445,
			["m"] = 116,
			["f"] = 0,
		},
		[26877] = {
			"26878:23859:23736", -- [1]
			"26878:26880:24061", -- [2]
			"26878:23859", -- [3]
			"26881:26602:24795:27046", -- [4]
			"26881:26879", -- [5]
			"26881:26602", -- [6]
			"26878:26880", -- [7]
			"26878:26880:26876", -- [8]
			"26881:26602:24795", -- [9]
			"26851:28196", -- [10]
			"26878:23859:28197", -- [11]
			"26881:28195", -- [12]
			"28615:28623", -- [13]
			"28615:28618", -- [14]
			"28615:28623:28624", -- [15]
			"30869:28574", -- [16]
			"30869:28574:28037", -- [17]
			"28674:29721", -- [18]
			"28674:30433:29750", -- [19]
			"28674:29721:32571", -- [20]
			"30869:31078", -- [21]
			"28674:30433:29750:29951", -- [22]
			"28674:30433:29750:29950", -- [23]
			"28615:28623:28624:30569", -- [24]
			"30869:30314", -- [25]
			"28674:30433", -- [26]
			"28674:31069", -- [27]
			"28674:30271", -- [28]
			"28674:33849", -- [29]
			["m"] = 115,
			["coord"] = 1698185732,
			["direct"] = "26878:26881:26851:30869:28615:28674",
			["f"] = 0,
		},
		[26878] = {
			"23859:23736", -- [1]
			"26880:24061", -- [2]
			"26881:26602:24795:27046", -- [3]
			"26881:26879", -- [4]
			"26881:26602", -- [5]
			"26880:26876", -- [6]
			"26881:26602:24795", -- [7]
			"23859:28197", -- [8]
			"26881:28195", -- [9]
			"26877:30869", -- [10]
			"28615:28623", -- [11]
			"28615:28623:28624", -- [12]
			"26877:30869:28574", -- [13]
			"26881:26602:28037", -- [14]
			"30271:28674", -- [15]
			"28615:29721", -- [16]
			"28615:29721:29750", -- [17]
			"28615:29721:32571", -- [18]
			"26877:30869:31078", -- [19]
			"28615:29721:29750:29951", -- [20]
			"28615:29721:29750:29950", -- [21]
			"28615:28623:28624:30569", -- [22]
			"30271:28674:31069:30314", -- [23]
			"30271:28674:30433", -- [24]
			"30271:28674:31069", -- [25]
			"30271:28674:33849", -- [26]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "23859:26881:26877:26851:26880:28196:28615:28618:30271",
			["coord"] = 3309797249,
		},
		[26879] = {
			"28195:28196:28197:23736", -- [1]
			"28195:28196:26878:26880:24061", -- [2]
			"28195:28196:26878:23859", -- [3]
			"24795:27046", -- [4]
			"28195:28196:26878", -- [5]
			"26881:26877", -- [6]
			"28195:28196:26851", -- [7]
			"28195:28196:26878:26880", -- [8]
			"28195:28196:26878:26880:26876", -- [9]
			"28195:28196", -- [10]
			"28195:28196:28197", -- [11]
			"26881:30869", -- [12]
			"28195:28196:26878:28615:28623", -- [13]
			"28195:28196:26878:28615", -- [14]
			"28195:28196:26878:28618", -- [15]
			"28195:28196:26878:28615:28623:28624", -- [16]
			"26602:28574", -- [17]
			"26602:28037", -- [18]
			"28674:29721", -- [19]
			"28674:30433:29750", -- [20]
			"28674:29721:32571", -- [21]
			"26602:28574:31078", -- [22]
			"28674:30433:29750:29951", -- [23]
			"28674:30433:29750:29950", -- [24]
			"28195:28196:26878:28615:28623:28624:30569", -- [25]
			"26602:28574:31078:30314", -- [26]
			"28674:30433", -- [27]
			"28674:31069", -- [28]
			"28674:30271", -- [29]
			"28674:33849", -- [30]
			["m"] = 114,
			["coord"] = 2531241699,
			["direct"] = "26602:26881:24795:28195:28674",
			["f"] = 0,
		},
		[26880] = {
			"23859:23736", -- [1]
			"26878:26881:26602:24795:27046", -- [2]
			"26878:26881:26879", -- [3]
			"26878:26881:26602", -- [4]
			"26878:26881", -- [5]
			"26878:26877", -- [6]
			"26878:26851", -- [7]
			"26878:26881:26602:24795", -- [8]
			"26878:28196", -- [9]
			"23859:28197", -- [10]
			"26878:26881:28195", -- [11]
			"26878:26877:30869", -- [12]
			"28618:28623", -- [13]
			"28618:28615", -- [14]
			"28618:28623:28624", -- [15]
			"26878:26877:30869:28574", -- [16]
			"26878:26881:26602:28037", -- [17]
			"28618:28615:28674", -- [18]
			"28618:28615:29721", -- [19]
			"28618:28615:29721:29750", -- [20]
			"28618:28623:28624:32571", -- [21]
			"28618:28615:28674:31069:31078", -- [22]
			"28618:28615:29721:29750:29951", -- [23]
			"28618:28615:29721:29750:29950", -- [24]
			"28618:28623:28624:30569", -- [25]
			"28618:28615:28674:31069:30314", -- [26]
			"28618:28615:28674:30433", -- [27]
			"28618:28615:28674:31069", -- [28]
			"28618:28615:30271", -- [29]
			"28618:28615:28674:33849", -- [30]
			["direct"] = "24061:23859:26878:26876:28618",
			["f"] = 0,
			["m"] = 116,
			["coord"] = 1344706413,
		},
		[26881] = {
			"26878:23859:23736", -- [1]
			"26878:26880:24061", -- [2]
			"26878:23859", -- [3]
			"26602:24795:27046", -- [4]
			"26878:26880", -- [5]
			"26878:26880:26876", -- [6]
			"26602:24795", -- [7]
			"28196:28197", -- [8]
			"26878:28615:28623", -- [9]
			"26878:28615", -- [10]
			"26878:28618", -- [11]
			"26878:28615:28623:28624", -- [12]
			"26602:28574", -- [13]
			"26602:28037", -- [14]
			"26877:28674", -- [15]
			"26877:28674:29721", -- [16]
			"26877:28674:30433:29750", -- [17]
			"26877:28674:29721:32571", -- [18]
			"30869:31078", -- [19]
			"26877:28674:30433:29750:29951", -- [20]
			"26877:28674:30433:29750:29950", -- [21]
			"26878:28615:28623:28624:30569", -- [22]
			"30869:30314", -- [23]
			"26877:28674:30433", -- [24]
			"30869:31069", -- [25]
			"26878:30271", -- [26]
			"26877:28674:33849", -- [27]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "26878:26879:26602:26877:26851:28196:28195:30869",
			["coord"] = 1252167107,
		},
		[23859] = {
			"26878:26881:26602:24795:27046", -- [1]
			"26878:26881:26879", -- [2]
			"26878:26881:26602", -- [3]
			"26878:26881", -- [4]
			"26878:26877", -- [5]
			"26878:26851", -- [6]
			"26880:26876", -- [7]
			"26878:26881:26602:24795", -- [8]
			"28197:28196", -- [9]
			"26878:26881:28195", -- [10]
			"26878:26877:30869", -- [11]
			"26880:28618:28623", -- [12]
			"26880:28618:28615", -- [13]
			"26880:28618", -- [14]
			"26880:28618:28623:28624", -- [15]
			"26878:26877:30869:28574", -- [16]
			"26878:26881:26602:28037", -- [17]
			"26880:28618:28615:28674", -- [18]
			"26880:28618:28615:29721", -- [19]
			"26880:28618:28615:29721:29750", -- [20]
			"26880:28618:28623:28624:32571", -- [21]
			"26880:28618:28615:28674:31069:31078", -- [22]
			"26880:28618:28615:29721:29750:29951", -- [23]
			"26880:28618:28615:29721:29750:29950", -- [24]
			"26880:28618:28623:28624:30569", -- [25]
			"26880:28618:28615:28674:31069:30314", -- [26]
			"26880:28618:28615:28674:30433", -- [27]
			"26880:28618:28615:28674:31069", -- [28]
			"26880:28618:28615:30271", -- [29]
			"26880:28618:28615:28674:33849", -- [30]
			["m"] = 117,
			["f"] = 0,
			["direct"] = "23736:24061:26878:26880:28197",
			["coord"] = 1342664869,
		},
		[29721] = {
			"28615:26878:23859:23736", -- [1]
			"28615:28623:26876:24061", -- [2]
			"28615:26878:23859", -- [3]
			"28615:26851:26881:26602:24795:27046", -- [4]
			"28615:26878", -- [5]
			"28674:26879", -- [6]
			"28615:26851:26881:26602", -- [7]
			"28615:26851:26881", -- [8]
			"28615:26877", -- [9]
			"28615:26851", -- [10]
			"28615:28618:26880", -- [11]
			"28615:28623:26876", -- [12]
			"28615:26851:26881:26602:24795", -- [13]
			"28615:26851:28196", -- [14]
			"28615:26878:23859:28197", -- [15]
			"28615:26851:26881:28195", -- [16]
			"28674:30869", -- [17]
			"28615:28623", -- [18]
			"28615:28618", -- [19]
			"28615:28623:28624", -- [20]
			"28674:28574", -- [21]
			"28674:28574:28037", -- [22]
			"29750:30433:31069:31078", -- [23]
			"29750:29951", -- [24]
			"29750:29950", -- [25]
			"28615:28623:28624:30569", -- [26]
			"29750:29950:30314", -- [27]
			"29750:30433", -- [28]
			"29750:30433:31069", -- [29]
			"29750:29950:33849", -- [30]
			["m"] = 120,
			["coord"] = 1747966095,
			["direct"] = "28615:28674:29750:32571:30271",
			["f"] = 0,
		},
		[24061] = {
			"26880:26878:26881:26602:24795:27046", -- [1]
			"26880:26878", -- [2]
			"26880:26878:26881:26879", -- [3]
			"26880:26878:26881:26602", -- [4]
			"26880:26878:26881", -- [5]
			"26880:26878:26877", -- [6]
			"26880:26878:26851", -- [7]
			"26880:26878:26881:26602:24795", -- [8]
			"26880:26878:28196", -- [9]
			"23859:28197", -- [10]
			"26880:26878:26881:28195", -- [11]
			"26880:26878:26877:30869", -- [12]
			"26876:28623", -- [13]
			"26880:28618:28615", -- [14]
			"26880:28618", -- [15]
			"26876:28624", -- [16]
			"26880:26878:26877:30869:28574", -- [17]
			"26880:26878:26881:26602:28037", -- [18]
			"26880:28618:28615:28674", -- [19]
			"26880:28618:28615:29721", -- [20]
			"26880:28618:28615:29721:29750", -- [21]
			"26876:28624:32571", -- [22]
			"26880:28618:28615:28674:31069:31078", -- [23]
			"26876:28624:29951", -- [24]
			"26880:28618:28615:29721:29750:29950", -- [25]
			"26876:28624:30569", -- [26]
			"26880:28618:28615:28674:31069:30314", -- [27]
			"26880:28618:28615:28674:30433", -- [28]
			"26880:28618:28615:28674:31069", -- [29]
			"26880:28618:28615:30271", -- [30]
			"26880:28618:28615:28674:33849", -- [31]
			["direct"] = "23736:23859:26880:26876",
			["coord"] = 2580097316,
			["m"] = 117,
			["f"] = 0,
		},
		[30869] = {
			"26877:26878:23859:23736", -- [1]
			"26877:26878:26880:24061", -- [2]
			"26877:26878:23859", -- [3]
			"28574:26602:24795:27046", -- [4]
			"26877:26878", -- [5]
			"26881:26879", -- [6]
			"28574:26602", -- [7]
			"26877:26851", -- [8]
			"26877:26878:26880", -- [9]
			"26877:26878:26880:26876", -- [10]
			"28574:26602:24795", -- [11]
			"26881:28196", -- [12]
			"26877:26878:23859:28197", -- [13]
			"26881:28195", -- [14]
			"26877:28615:28623", -- [15]
			"26877:28615", -- [16]
			"26877:28615:28618", -- [17]
			"26877:28615:28623:28624", -- [18]
			"28574:28037", -- [19]
			"28674:29721", -- [20]
			"28674:30433:29750", -- [21]
			"28674:29721:32571", -- [22]
			"28674:30433:29750:29951", -- [23]
			"28674:30433:29750:29950", -- [24]
			"26877:28615:28623:28624:30569", -- [25]
			"28674:30433", -- [26]
			"28674:30271", -- [27]
			"31069:33849", -- [28]
			["m"] = 123,
			["f"] = 0,
			["direct"] = "26881:26877:28574:28674:31078:30314:31069",
			["coord"] = 3094564733,
		},
		[32571] = {
			"28624:26876:24061:23736", -- [1]
			"28624:26876:24061", -- [2]
			"28624:26876:26880:23859", -- [3]
			"29721:28615:26851:26881:26602:24795:27046", -- [4]
			"29721:28615:26878", -- [5]
			"29721:28674:26879", -- [6]
			"29721:28615:26851:26881:26602", -- [7]
			"29721:28615:26851:26881", -- [8]
			"29721:28615:26877", -- [9]
			"29721:28615:26851", -- [10]
			"28624:26876:26880", -- [11]
			"28624:26876", -- [12]
			"29721:28615:26851:26881:26602:24795", -- [13]
			"29721:28615:26851:28196", -- [14]
			"28624:26876:26880:23859:28197", -- [15]
			"29721:28615:26851:26881:28195", -- [16]
			"29721:28674:30869", -- [17]
			"28624:28623", -- [18]
			"29721:28615", -- [19]
			"28624:28623:28618", -- [20]
			"29721:28674:28574", -- [21]
			"29721:28674:28574:28037", -- [22]
			"29721:28674", -- [23]
			"29721:29750", -- [24]
			"29951:29950:30314:31078", -- [25]
			"29951:29950", -- [26]
			"28624:30569", -- [27]
			"29951:29950:30314", -- [28]
			"29721:29750:30433", -- [29]
			"29721:29750:30433:31069", -- [30]
			"29721:30271", -- [31]
			"29951:29950:33849", -- [32]
			"29762:29757", -- [35]
			["direct"] = "28624:29721:29951",
			["coord"] = 2686753797,
			["m"] = 120,
			["f"] = 0,
		},
		[23736] = {
			"23859:26878:26881:26602:24795:27046", -- [1]
			"23859:26878", -- [2]
			"23859:26878:26881:26879", -- [3]
			"23859:26878:26881:26602", -- [4]
			"23859:26878:26881", -- [5]
			"23859:26878:26877", -- [6]
			"23859:26878:26851", -- [7]
			"23859:26880", -- [8]
			"24061:26876", -- [9]
			"23859:26878:26881:26602:24795", -- [10]
			"28197:28196", -- [11]
			"28197:28196:28195", -- [12]
			"23859:26878:26877:30869", -- [13]
			"24061:26876:28623", -- [14]
			"23859:26880:28618:28615", -- [15]
			"23859:26880:28618", -- [16]
			"24061:26876:28624", -- [17]
			"28674:28574", -- [18]
			"28674:28574:28037", -- [19]
			"23859:26880:28618:28615:29721", -- [20]
			"23859:26880:28618:28615:29721:29750", -- [21]
			"24061:26876:28624:32571", -- [22]
			"28674:31069:31078", -- [23]
			"24061:26876:28624:29951", -- [24]
			"23859:26880:28618:28615:29721:29750:29950", -- [25]
			"24061:26876:28624:30569", -- [26]
			"28674:31069:30314", -- [27]
			"28674:30433", -- [28]
			"28674:31069", -- [29]
			"23859:26880:28618:28615:30271", -- [30]
			"28674:33849", -- [31]
			["direct"] = "24061:23859:28197:28674",
			["coord"] = 2565448190,
			["m"] = 117,
			["f"] = 0,
		},
		[28037] = {
			"26602:28195:28196:28197:23736", -- [1]
			"26602:26881:26878:26880:24061", -- [2]
			"26602:26881:26878:23859", -- [3]
			"26602:24795:27046", -- [4]
			"26602:26881:26878", -- [5]
			"26602:26879", -- [6]
			"26602:26881", -- [7]
			"28574:30869:26877", -- [8]
			"26602:26881:26851", -- [9]
			"26602:26881:26878:26880", -- [10]
			"28574:28674:28615:28623:26876", -- [11]
			"26602:24795", -- [12]
			"26602:28195:28196", -- [13]
			"26602:28195:28196:28197", -- [14]
			"26602:28195", -- [15]
			"28574:30869", -- [16]
			"28574:28674:28615:28623", -- [17]
			"28574:28674:28615", -- [18]
			"28574:28674:28615:28618", -- [19]
			"28574:28674:28615:28623:28624", -- [20]
			"28574:28674", -- [21]
			"28574:28674:29721", -- [22]
			"28574:28674:30433:29750", -- [23]
			"28574:28674:29721:32571", -- [24]
			"31078:30314:29950:29951", -- [25]
			"31078:30314:29950", -- [26]
			"28574:28674:28615:28623:28624:30569", -- [27]
			"31078:30314", -- [28]
			"28574:28674:30433", -- [29]
			"31078:31069", -- [30]
			"28574:28674:30271", -- [31]
			"31078:30314:33849", -- [32]
			["direct"] = "26602:28574:31078",
			["coord"] = 1087608149,
			["m"] = 119,
			["f"] = 0,
			["requirements"] = "qid:12523"
		},
		[28615] = {
			"26878:23859:23736", -- [1]
			"28623:26876:24061", -- [2]
			"26878:23859", -- [3]
			"26851:26881:26602:24795:27046", -- [4]
			"26851:26881:26879", -- [5]
			"26851:26881:26602", -- [6]
			"26851:26881", -- [7]
			"28618:26880", -- [8]
			"28623:26876", -- [9]
			"26851:26881:26602:24795", -- [10]
			"26851:28196", -- [11]
			"26878:23859:28197", -- [12]
			"26851:26881:28195", -- [13]
			"26877:30869", -- [14]
			"28623:28624", -- [15]
			"28674:28574", -- [16]
			"28674:28574:28037", -- [17]
			"29721:29750", -- [18]
			"29721:32571", -- [19]
			"28674:31069:31078", -- [20]
			"29721:29750:29951", -- [21]
			"29721:29750:29950", -- [22]
			"28623:28624:30569", -- [23]
			"28674:31069:30314", -- [24]
			"28674:30433", -- [25]
			"28674:31069", -- [26]
			"28674:33849", -- [27]
			["m"] = 121,
			["coord"] = 603962466,
			["direct"] = "26878:26877:26851:28623:28618:28674:29721:30271",
			["f"] = 0,
		},
		[30433] = {
			"28674:23736", -- [1]
			"28674:28615:28623:26876:24061", -- [2]
			"28674:30271:26878:23859", -- [3]
			"28674:26879:24795:27046", -- [4]
			"28674:30271:26878", -- [5]
			"28674:26879", -- [6]
			"28674:28574:26602", -- [7]
			"28674:26877:26881", -- [8]
			"28674:26877", -- [9]
			"28674:26851", -- [10]
			"28674:30271:26878:26880", -- [11]
			"28674:28615:28623:26876", -- [12]
			"28674:26879:24795", -- [13]
			"28674:28196", -- [14]
			"28674:30271:26878:23859:28197", -- [15]
			"28674:26877:26881:28195", -- [16]
			"31069:30869", -- [17]
			"28674:28615:28623", -- [18]
			"28674:28615", -- [19]
			"28674:28615:28618", -- [20]
			"28674:28615:28623:28624", -- [21]
			"28674:28574", -- [22]
			"28674:28574:28037", -- [23]
			"28674:29721", -- [24]
			"28674:29721:32571", -- [25]
			"31069:31078", -- [26]
			"29750:29951", -- [27]
			"29750:29950", -- [28]
			"28674:28615:28623:28624:30569", -- [29]
			"28674:30271", -- [30]
			"31069:33849", -- [31]
			["direct"] = "28674:29750:30314:31069",
			["coord"] = 3770468289,
			["m"] = 118,
			["f"] = 0,
		},
		[28618] = {
			"26880:23859:23736", -- [1]
			"28623:26876:24061", -- [2]
			"26880:23859", -- [3]
			"28615:26851:26881:26602:24795:27046", -- [4]
			"28615:26851:26881:26879", -- [5]
			"28615:26851:26881:26602", -- [6]
			"28615:26851:26881", -- [7]
			"28615:26877", -- [8]
			"28615:26851", -- [9]
			"28623:26876", -- [10]
			"28615:26851:26881:26602:24795", -- [11]
			"26878:28196", -- [12]
			"26880:23859:28197", -- [13]
			"28615:26851:26881:28195", -- [14]
			"28615:26877:30869", -- [15]
			"28623:28624", -- [16]
			"28615:28674:28574", -- [17]
			"28615:28674:28574:28037", -- [18]
			"28615:28674", -- [19]
			"28615:29721", -- [20]
			"28615:29721:29750", -- [21]
			"28623:28624:32571", -- [22]
			"28615:28674:31069:31078", -- [23]
			"28615:29721:29750:29951", -- [24]
			"28615:29721:29750:29950", -- [25]
			"28623:28624:30569", -- [26]
			"28615:28674:31069:30314", -- [27]
			"28615:28674:30433", -- [28]
			"28615:28674:31069", -- [29]
			"28615:30271", -- [30]
			"28615:28674:33849", -- [31]
			["direct"] = "26878:26880:28623:28615",
			["coord"] = 1381678745,
			["m"] = 121,
			["f"] = 0,
		},
		[30569] = {
			"28624:26876:24061:23736", -- [1]
			"28624:26876:24061", -- [2]
			"28624:26876:26880:23859", -- [3]
			"28624:28623:28615:26851:26881:26602:24795:27046", -- [4]
			"28624:28623:28618:26878", -- [5]
			"28624:28623:28615:26851:26881:26879", -- [6]
			"28624:28623:28615:26851:26881:26602", -- [7]
			"28624:28623:28615:26851:26881", -- [8]
			"28624:28623:28615:26877", -- [9]
			"28624:28623:28615:26851", -- [10]
			"28624:26876:26880", -- [11]
			"28624:26876", -- [12]
			"28624:28623:28615:26851:26881:26602:24795", -- [13]
			"28624:28623:28615:26851:28196", -- [14]
			"28624:26876:26880:23859:28197", -- [15]
			"28624:28623:28615:26851:26881:28195", -- [16]
			"28624:28623:28615:26877:30869", -- [17]
			"28624:28623", -- [18]
			"28624:28623:28615", -- [19]
			"28624:28623:28618", -- [20]
			"28624:28623:28615:28674:28574", -- [21]
			"28624:28623:28615:28674:28574:28037", -- [22]
			"28624:28623:28615:28674", -- [23]
			"28624:28623:28615:29721", -- [24]
			"28624:28623:28615:29721:29750", -- [25]
			"28624:32571", -- [26]
			"28624:28623:28615:28674:31069:31078", -- [27]
			"28624:29951", -- [28]
			"28624:29951:29950", -- [29]
			"28624:29951:29950:30314", -- [30]
			"28624:28623:28615:28674:30433", -- [31]
			"28624:28623:28615:28674:31069", -- [32]
			"28624:28623:28615:30271", -- [33]
			"28624:29951:29950:33849", -- [34]
			["direct"] = "28624",
			["coord"] = 3025877835,
			["m"] = 121,
			["f"] = 0,
		},
		[27046] = {
			"24795:26602:28195:28196:28197:23736", -- [1]
			"24795:26602:26881:26878:26880:24061", -- [2]
			"24795:26602:26881:26878:23859", -- [3]
			"24795:26602:26881:26878", -- [4]
			"24795:26879", -- [5]
			"24795:26602", -- [6]
			"24795:26602:26881", -- [7]
			"24795:26602:26881:26877", -- [8]
			"24795:26602:26881:26851", -- [9]
			"24795:26602:26881:26878:26880", -- [10]
			"24795:26602:26881:26878:26880:26876", -- [11]
			"24795:26602:28195:28196", -- [12]
			"24795:26602:28195:28196:28197", -- [13]
			"24795:26602:28195", -- [14]
			"24795:26602:26881:30869", -- [15]
			"24795:26602:26881:26878:28615:28623", -- [16]
			"24795:26602:26881:26878:28615", -- [17]
			"24795:26602:26881:26878:28618", -- [18]
			"24795:26602:26881:26878:28615:28623:28624", -- [19]
			"24795:26602:28574", -- [20]
			"24795:26602:28037", -- [21]
			"24795:26602:28574:28674", -- [22]
			"24795:26602:28574:28674:29721", -- [23]
			"24795:26602:28574:28674:30433:29750", -- [24]
			"24795:26602:28574:28674:29721:32571", -- [25]
			"24795:26602:28574:31078", -- [26]
			"24795:26602:28574:31078:30314:29950:29951", -- [27]
			"24795:26602:28574:31078:30314:29950", -- [28]
			"24795:26602:26881:26878:28615:28623:28624:30569", -- [29]
			"24795:26602:28574:31078:30314", -- [30]
			"24795:26602:28574:28674:30433", -- [31]
			"24795:26602:28574:28674:31069", -- [32]
			"24795:26602:28574:28674:30271", -- [33]
			"24795:26602:28574:31078:30314:33849", -- [34]
			["direct"] = "24795",
			["coord"] = 1422481428,
			["m"] = 114,
			["f"] = 0,
		},
		[28196] = {
			"28197:23736", -- [1]
			"26878:26880:24061", -- [2]
			"26878:23859", -- [3]
			"26881:26602:24795:27046", -- [4]
			"26881:26879", -- [5]
			"26881:26602", -- [6]
			"26851:26877", -- [7]
			"26878:26880", -- [8]
			"26878:26880:26876", -- [9]
			"26881:26602:24795", -- [10]
			"26881:30869", -- [11]
			"26878:28615:28623", -- [12]
			"26878:28615", -- [13]
			"26878:28618", -- [14]
			"26878:28615:28623:28624", -- [15]
			"26881:26602:28574", -- [16]
			"26881:26602:28037", -- [17]
			"28674:29721", -- [18]
			"28674:30433:29750", -- [19]
			"28674:29721:32571", -- [20]
			"26881:30869:31078", -- [21]
			"28674:30433:29750:29951", -- [22]
			"28674:30433:29750:29950", -- [23]
			"26878:28615:28623:28624:30569", -- [24]
			"26881:30869:30314", -- [25]
			"28674:30433", -- [26]
			"28674:31069", -- [27]
			"26878:30271", -- [28]
			"28674:33849", -- [29]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "26878:26881:26851:28197:28195:28674",
			["coord"] = 2081603196,
		},
		[28674] = {
			"28615:28623:26876:24061", -- [1]
			"30271:26878:23859", -- [2]
			"26879:24795:27046", -- [3]
			"30271:26878", -- [4]
			"28574:26602", -- [5]
			"26877:26881", -- [6]
			"30271:26878:26880", -- [7]
			"28615:28623:26876", -- [8]
			"26879:24795", -- [9]
			"30271:26878:23859:28197", -- [10]
			"26877:26881:28195", -- [11]
			"28615:28623", -- [12]
			"28615:28618", -- [13]
			"28615:28623:28624", -- [14]
			"28574:28037", -- [15]
			"30433:29750", -- [16]
			"29721:32571", -- [17]
			"31069:31078", -- [18]
			"30433:29750:29951", -- [19]
			"30433:29750:29950", -- [20]
			"28615:28623:28624:30569", -- [21]
			"31069:30314", -- [22]
			["m"] = 125,
			["coord"] = 3092739228,
			["direct"] = "23736:26879:26877:26851:28196:30869:28615:28574:29721:30433:31069:30271:33849",
			["f"] = 0,
		},
		[31069] = {
			"30433:28674:23736", -- [1]
			"30433:28674:28615:28623:26876:24061", -- [2]
			"30433:28674:30271:26878:23859", -- [3]
			"30869:28574:26602:24795:27046", -- [4]
			"30433:28674:30271:26878", -- [5]
			"30869:26881:26879", -- [6]
			"30869:28574:26602", -- [7]
			"30869:26881", -- [8]
			"30869:26877", -- [9]
			"30433:28674:26851", -- [10]
			"30433:28674:30271:26878:26880", -- [11]
			"30433:28674:28615:28623:26876", -- [12]
			"30869:28574:26602:24795", -- [13]
			"30433:28674:28196", -- [14]
			"30433:28674:30271:26878:23859:28197", -- [15]
			"30869:26881:28195", -- [16]
			"30433:28674:28615:28623", -- [17]
			"30433:28674:28615", -- [18]
			"30433:28674:28615:28618", -- [19]
			"30433:28674:28615:28623:28624", -- [20]
			"30869:28574", -- [21]
			"31078:28037", -- [22]
			"30433:28674:29721", -- [23]
			"30433:29750", -- [24]
			"30433:28674:29721:32571", -- [25]
			"30433:29750:29951", -- [26]
			"30433:29750:29950", -- [27]
			"30433:28674:28615:28623:28624:30569", -- [28]
			"30433:28674:30271", -- [29]
			["m"] = 118,
			["coord"] = 3408050485,
			["direct"] = "30869:28674:31078:30314:30433:33849",
			["f"] = 0,
		},
		[30314] = {
			"30433:28674:23736", -- [1]
			"29950:29951:28624:26876:24061", -- [2]
			"30869:26877:26878:23859", -- [3]
			"31078:28574:26602:24795:27046", -- [4]
			"30869:26877:26878", -- [5]
			"31078:28574:26602:26879", -- [6]
			"31078:28574:26602", -- [7]
			"30869:26881", -- [8]
			"30869:26877", -- [9]
			"30869:26877:26851", -- [10]
			"30869:26877:26878:26880", -- [11]
			"29950:29951:28624:26876", -- [12]
			"31078:28574:26602:24795", -- [13]
			"30869:26881:28196", -- [14]
			"30869:26877:26878:23859:28197", -- [15]
			"30869:26881:28195", -- [16]
			"30433:28674:28615:28623", -- [17]
			"30433:28674:28615", -- [18]
			"30433:28674:28615:28618", -- [19]
			"29950:29951:28624", -- [20]
			"31078:28574", -- [21]
			"31078:28037", -- [22]
			"30433:28674", -- [23]
			"30433:28674:29721", -- [24]
			"30433:29750", -- [25]
			"29950:29951:32571", -- [26]
			"29950:29951", -- [27]
			"29950:29951:28624:30569", -- [28]
			"30433:28674:30271", -- [29]
			["m"] = 118,
			["coord"] = 1877360227,
			["direct"] = "30869:31078:29950:30433:31069:33849",
			["f"] = 0,
		},
		[26851] = {
			"26878:23859:23736", -- [1]
			"26878:26880:24061", -- [2]
			"26878:23859", -- [3]
			"26881:26602:24795:27046", -- [4]
			"26881:26879", -- [5]
			"26881:26602", -- [6]
			"26878:26880", -- [7]
			"26878:26880:26876", -- [8]
			"26881:26602:24795", -- [9]
			"26878:23859:28197", -- [10]
			"26881:28195", -- [11]
			"26877:30869", -- [12]
			"28615:28623", -- [13]
			"26878:28618", -- [14]
			"28615:28623:28624", -- [15]
			"26877:30869:28574", -- [16]
			"26881:26602:28037", -- [17]
			"28615:29721", -- [18]
			"28674:30433:29750", -- [19]
			"28615:29721:32571", -- [20]
			"26877:30869:31078", -- [21]
			"28674:30433:29750:29951", -- [22]
			"28674:30433:29750:29950", -- [23]
			"28615:28623:28624:30569", -- [24]
			"28674:31069:30314", -- [25]
			"28674:30433", -- [26]
			"28674:31069", -- [27]
			"26878:30271", -- [28]
			"28674:33849", -- [29]
			["m"] = 115,
			["f"] = 0,
			["direct"] = "26878:26881:26877:28196:28615:28674",
			["coord"] = 2588115855,
		},
		[33849] = {
			"31069:30433:28674:23736", -- [1]
			"29950:29951:28624:26876:24061", -- [2]
			"31069:30433:28674:30271:26878:23859", -- [3]
			"30314:31078:28574:26602:24795:27046", -- [4]
			"31069:30433:28674:30271:26878", -- [5]
			"31069:30869:26881:26879", -- [6]
			"30314:31078:28574:26602", -- [7]
			"31069:30869:26881", -- [8]
			"31069:30869:26877", -- [9]
			"31069:30433:28674:26851", -- [10]
			"31069:30433:28674:30271:26878:26880", -- [11]
			"29950:29951:28624:26876", -- [12]
			"30314:31078:28574:26602:24795", -- [13]
			"31069:30433:28674:28196", -- [14]
			"31069:30433:28674:30271:26878:23859:28197", -- [15]
			"31069:30869:26881:28195", -- [16]
			"31069:30869", -- [17]
			"31069:30433:28674:28615:28623", -- [18]
			"31069:30433:28674:28615", -- [19]
			"31069:30433:28674:28615:28618", -- [20]
			"29950:29951:28624", -- [21]
			"30314:31078:28574", -- [22]
			"30314:31078:28037", -- [23]
			"29950:29750:29721", -- [24]
			"29950:29750", -- [25]
			"29950:29951:32571", -- [26]
			"30314:31078", -- [27]
			"29950:29951", -- [28]
			"29950:29951:28624:30569", -- [29]
			"31069:30433", -- [30]
			"31069:30433:28674:30271", -- [31]
			["direct"] = "28674:29950:30314:31069",
			["coord"] = 3118414356,
			["m"] = 118,
			["f"] = 0,
		},
		[28197] = {
			"23859:24061", -- [1]
			"28196:26881:26602:24795:27046", -- [2]
			"23859:26878", -- [3]
			"28196:26881:26879", -- [4]
			"28196:26881:26602", -- [5]
			"28196:26881", -- [6]
			"23859:26878:26877", -- [7]
			"23859:26878:26851", -- [8]
			"23859:26880", -- [9]
			"23859:26880:26876", -- [10]
			"28196:26881:26602:24795", -- [11]
			"28196:28195", -- [12]
			"28196:26881:30869", -- [13]
			"23859:26880:28618:28623", -- [14]
			"23859:26880:28618:28615", -- [15]
			"23859:26880:28618", -- [16]
			"23859:26880:28618:28623:28624", -- [17]
			"28196:26881:26602:28574", -- [18]
			"28196:26881:26602:28037", -- [19]
			"23859:26880:28618:28615:28674", -- [20]
			"23859:26880:28618:28615:29721", -- [21]
			"23859:26880:28618:28615:29721:29750", -- [22]
			"23859:26880:28618:28623:28624:32571", -- [23]
			"28196:26881:30869:31078", -- [24]
			"23859:26880:28618:28615:29721:29750:29951", -- [25]
			"23859:26880:28618:28615:29721:29750:29950", -- [26]
			"23859:26880:28618:28623:28624:30569", -- [27]
			"23859:26880:28618:28615:28674:31069:30314", -- [28]
			"23859:26880:28618:28615:28674:30433", -- [29]
			"23859:26880:28618:28615:28674:31069", -- [30]
			"23859:26880:28618:28615:30271", -- [31]
			"23859:26880:28618:28615:28674:33849", -- [32]
			["m"] = 117,
			["f"] = 0,
			["direct"] = "23736:23859:28196",
			["coord"] = 1058378765,
		},
	}, -- [4]
	[6] = {
		[61512] = {
			"60416:61744:61474:61759:60230:59186", -- [1]
			"60416:61744:61474:66023", -- [2]
			"60416:61744:61474:61759:60230:59186:59732", -- [3]
			"60416:61744:61474:61759:60230:59186:59727", -- [4]
			"60416:61744:61474:61759:60230:59186:59735:59733", -- [5]
			"60416:61744:61474:61759:60230:59186:59735", -- [6]
			"60416:61744:61474:61759:60230:59186:59736", -- [7]
			"60416:61744:61474:66023:56737", -- [8]
			"60416:61744:61474:61759:60230", -- [9]
			"60416:61744:61474:61759:62658:60231", -- [10]
			"60416:61744:61474:60232", -- [11]
			"60416:61744:61474:61759:62658:60231:59049", -- [12]
			"62901:62903:63500:63501:58843", -- [13]
			"62901:62903:63500:63501:59048", -- [14]
			"62901:62903:63500:63501:59048:65189", -- [15]
			"62901:62903:63500:63501:59048:60441", -- [16]
			"60416:61744:61474", -- [17]
			"60416:61504:61118", -- [18]
			"60416:61744", -- [19]
			"60416:61504:61118:61511", -- [20]
			"60416:61504", -- [21]
			"60416:61473", -- [22]
			"60416:61744:61474:61759", -- [23]
			"60416:61744:61474:61759:62658", -- [24]
			"62901:62903", -- [25]
			"62901:62898", -- [26]
			"62901:62898:62909", -- [27]
			"60416:61744:61121", -- [28]
			"62901:62903:63500:63501", -- [29]
			"63497:63498", -- [30]
			"62901:62903:63500", -- [31]
			"60416:61744:61474:61759:60230:59186:64310", -- [32]
			"62901:62903:63500:63501:65511", -- [33]
			"60416:61744:61121:65865", -- [34]
			"60416:61744:61474:66023:56737:71940", -- [35]
			--["name"] = "Winter's Blossom, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "60416:62901:63497",
			["coord"] = 1483577174,
		},
		[62658] = {
			"60230:59186", -- [1]
			"60231:60232:66023", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59727", -- [4]
			"60230:59186:59735:59733", -- [5]
			"60230:59186:59735", -- [6]
			"60230:59186:59736", -- [7]
			"60231:60232:66023:56737", -- [8]
			"60231:60232", -- [9]
			"60231:59049", -- [10]
			"60231:58843", -- [11]
			"60231:59048", -- [12]
			"60231:65189", -- [13]
			"60231:59049:60441", -- [14]
			"61759:61474", -- [15]
			"61759:61474:61118", -- [16]
			"61759:61474:61744", -- [17]
			"61759:61474:61118:61511", -- [18]
			"61759:61474:61504", -- [19]
			"61759:61474:61744:60416", -- [20]
			"61759:61474:61744:61473", -- [21]
			"61759:61474:61744:60416:61512", -- [22]
			"61759:61474:61744:61473:62901", -- [23]
			"61759:61474:61744:61473:62903", -- [24]
			"61759:61474:61744:61473:62903:62898", -- [25]
			"61759:61474:61744:61473:62903:62898:62909", -- [26]
			"60231:58843:63501", -- [27]
			"60231:58843:63501:63498", -- [28]
			"61121:63500", -- [29]
			"61121:63497", -- [30]
			"60230:59186:64310", -- [31]
			"60231:58843:63501:65511", -- [32]
			"61121:65865", -- [33]
			"60231:60232:66023:56737:71940", -- [34]
			--["name"] = "Grassy Cline, Valley of the Four Winds",
			["m"] = 376,
			["f"] = 0,
			["direct"] = "60230:60231:61759:61121",
			["coord"] = 3041672744,
		},
		[61473] = {
			"61744:61474:61759:60230:59186", -- [1]
			"61744:61474:66023", -- [2]
			"61744:61474:61759:60230:59186:59732", -- [3]
			"61744:61474:61759:60230:59186:59727", -- [4]
			"61744:61474:61759:60230:59186:59735:59733", -- [5]
			"61744:61474:61759:60230:59186:59735", -- [6]
			"61744:61474:61759:60230:59186:59736", -- [7]
			"61744:61474:66023:56737", -- [8]
			"61744:61474:61759:60230", -- [9]
			"61744:61474:61759:62658:60231", -- [10]
			"61744:61474:60232", -- [11]
			"61744:61474:61759:62658:60231:59049", -- [12]
			"62903:63500:63501:58843", -- [13]
			"62903:63500:63501:59048", -- [14]
			"62903:63500:63501:59048:65189", -- [15]
			"62903:63500:63501:59048:60441", -- [16]
			"61744:61474", -- [17]
			"60416:61504:61118", -- [18]
			"60416:61504:61118:61511", -- [19]
			"60416:61504", -- [20]
			"60416:61512", -- [21]
			"61744:61474:61759", -- [22]
			"61744:61474:61759:62658", -- [23]
			"62903:62898", -- [24]
			"62903:62898:62909", -- [25]
			"61744:61121", -- [26]
			"62903:63500:63501", -- [27]
			"62903:63500:63501:63498", -- [28]
			"62903:63500", -- [29]
			"62903:63500:63497", -- [30]
			"61744:61474:61759:60230:59186:64310", -- [31]
			"62903:63500:63501:65511", -- [32]
			"61744:61121:65865", -- [33]
			"61744:61474:66023:56737:71940", -- [34]
			--["name"] = "Shado-Pan Fallback, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "61744:60416:62901:62903",
			["coord"] = 1887954259,
		},
		[64310] = {
			"56737:66023", -- [1]
			"59186:59732", -- [2]
			"56737:59727", -- [3]
			"59186:59735:59733", -- [4]
			"59186:59735", -- [5]
			"59186:59736", -- [6]
			"59186:60230", -- [7]
			"56737:66023:60232:60231", -- [8]
			"56737:66023:60232", -- [9]
			"56737:66023:60232:60231:59049", -- [10]
			"56737:66023:60232:60231:58843", -- [11]
			"56737:66023:60232:60231:59048", -- [12]
			"56737:66023:60232:60231:65189", -- [13]
			"56737:66023:60232:60231:59049:60441", -- [14]
			"59186:60230:61759:61474", -- [15]
			"59186:60230:61759:61474:61118", -- [16]
			"59186:60230:61759:61474:61744", -- [17]
			"59186:60230:61759:61474:61118:61511", -- [18]
			"59186:60230:61759:61474:61504", -- [19]
			"59186:60230:61759:61474:61744:60416", -- [20]
			"59186:60230:61759:61474:61744:61473", -- [21]
			"59186:60230:61759:61474:61744:60416:61512", -- [22]
			"59186:60230:61759", -- [23]
			"59186:60230:62658", -- [24]
			"59186:60230:61759:61474:61744:61473:62901", -- [25]
			"59186:60230:61759:61474:61744:61473:62903", -- [26]
			"59186:60230:61759:61474:61744:61473:62903:62898", -- [27]
			"59186:60230:61759:61474:61744:61473:62903:62898:62909", -- [28]
			"59186:60230:62658:61121", -- [29]
			"56737:66023:60232:60231:58843:63501", -- [30]
			"56737:66023:60232:60231:58843:63501:63498", -- [31]
			"59186:60230:62658:61121:63500", -- [32]
			"59186:60230:62658:61121:63497", -- [33]
			"56737:66023:60232:60231:58843:63501:65511", -- [34]
			"59186:60230:62658:61121:65865", -- [35]
			"56737:71940", -- [36]
			--["name"] = "Serpent's Overlook, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59186:56737",
			["coord"] = 1851699009,
		},
		[65511] = {
			"63501:58843:60231:60230:59186", -- [1]
			"63501:58843:60231:60232:66023", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60232:66023:59727", -- [4]
			"63501:58843:60231:60230:59186:59735:59733", -- [5]
			"63501:58843:60231:60230:59186:59735", -- [6]
			"63501:58843:60231:60230:59186:59736", -- [7]
			"63501:58843:60231:60232:66023:56737", -- [8]
			"63501:58843:60231:60230", -- [9]
			"63501:58843:60231", -- [10]
			"63501:58843:60231:60232", -- [11]
			"63501:58843:60231:59049", -- [12]
			"63501:58843", -- [13]
			"63501:59048", -- [14]
			"63501:59048:65189", -- [15]
			"63501:59048:60441", -- [16]
			"63501:63500:62903:61473:61744:61474", -- [17]
			"63501:63500:62903:61473:60416:61504:61118", -- [18]
			"63501:63500:62903:61473:61744", -- [19]
			"63501:63500:62903:61473:60416:61504:61118:61511", -- [20]
			"63501:63500:62903:61473:60416:61504", -- [21]
			"63501:63500:62903:61473:60416", -- [22]
			"63501:63500:62903:61473", -- [23]
			"63501:63497:61512", -- [24]
			"63501:58843:60231:62658:61759", -- [25]
			"63501:58843:60231:62658", -- [26]
			"63501:63500:62903:62901", -- [27]
			"63501:63500:62903", -- [28]
			"63501:63500:62903:62898", -- [29]
			"63501:63500:62903:62898:62909", -- [30]
			"63501:61121", -- [31]
			"63501:63500", -- [32]
			"63501:63497", -- [33]
			"63501:58843:60231:60232:66023:56737:64310", -- [34]
			"63501:61121:65865", -- [35]
			"63501:58843:60231:60232:66023:56737:71940", -- [36]
			--["name"] = "The Briny Muck, Dread Wastes",
			["m"] = 422,
			["f"] = 0,
			["direct"] = "63501:63498",
			["coord"] = 1829473930,
		},
		[63497] = {
			"61121:60230:59186", -- [1]
			"61121:66023", -- [2]
			"61121:60230:59186:59732", -- [3]
			"61121:60230:59186:59727", -- [4]
			"61121:60230:59186:59735:59733", -- [5]
			"61121:60230:59186:59735", -- [6]
			"61121:60230:59186:59736", -- [7]
			"61121:66023:56737", -- [8]
			"61121:60230", -- [9]
			"63501:58843:60231", -- [10]
			"63501:58843:60231:60232", -- [11]
			"63501:58843:60231:59049", -- [12]
			"63501:58843", -- [13]
			"63501:59048", -- [14]
			"63501:59048:65189", -- [15]
			"63501:59048:60441", -- [16]
			"61121:61474", -- [17]
			"61512:60416:61504:61118", -- [18]
			"61121:61744", -- [19]
			"61512:60416:61504:61118:61511", -- [20]
			"61512:60416:61504", -- [21]
			"61512:60416", -- [22]
			"63500:62903:61473", -- [23]
			"61121:62658:61759", -- [24]
			"61121:62658", -- [25]
			"63500:62903:62901", -- [26]
			"63500:62903", -- [27]
			"63500:62903:62898", -- [28]
			"63500:62903:62898:62909", -- [29]
			"61121:60230:59186:64310", -- [30]
			"63501:65511", -- [31]
			"61121:65865", -- [32]
			"61121:66023:56737:71940", -- [33]
			--["name"] = "Serpent's Spine, Vale of Eternal Blossoms",
			["m"] = 390,
			["f"] = 0,
			["direct"] = "61512:61121:63501:63498:63500",
			["coord"] = 603966145,
		},
		[63501] = {
			"58843:60231:60230:59186", -- [1]
			"58843:60231:60232:66023", -- [2]
			"58843:60231:60230:59186:59732", -- [3]
			"58843:60231:60232:66023:59727", -- [4]
			"58843:60231:60230:59186:59735:59733", -- [5]
			"58843:60231:60230:59186:59735", -- [6]
			"58843:60231:60230:59186:59736", -- [7]
			"58843:60231:60232:66023:56737", -- [8]
			"58843:60231:60230", -- [9]
			"58843:60231", -- [10]
			"58843:60231:60232", -- [11]
			"58843:60231:59049", -- [12]
			"59048:65189", -- [13]
			"59048:60441", -- [14]
			"63500:62903:61473:61744:61474", -- [15]
			"63500:62903:61473:60416:61504:61118", -- [16]
			"63500:62903:61473:61744", -- [17]
			"63500:62903:61473:60416:61504:61118:61511", -- [18]
			"63500:62903:61473:60416:61504", -- [19]
			"63500:62903:61473:60416", -- [20]
			"63500:62903:61473", -- [21]
			"63497:61512", -- [22]
			"58843:60231:62658:61759", -- [23]
			"58843:60231:62658", -- [24]
			"63500:62903:62901", -- [25]
			"63500:62903", -- [26]
			"63500:62903:62898", -- [27]
			"63500:62903:62898:62909", -- [28]
			"58843:60231:60232:66023:56737:64310", -- [29]
			"61121:65865", -- [30]
			"58843:60231:60232:66023:56737:71940", -- [31]
			--["name"] = "Klaxxi'vess, Dread Wastes",
			["direct"] = "58843:59048:61121:63498:63500:63497:65511",
			["f"] = 0,
			["m"] = 422,
			["coord"] = 2397264188,
		},
		[60416] = {
			"61744:61474:61759:60230:59186", -- [1]
			"61744:61474:66023", -- [2]
			"61744:61474:61759:60230:59186:59732", -- [3]
			"61744:61474:61759:60230:59186:59727", -- [4]
			"61744:61474:61759:60230:59186:59735:59733", -- [5]
			"61744:61474:61759:60230:59186:59735", -- [6]
			"61744:61474:61759:60230:59186:59736", -- [7]
			"61744:61474:66023:56737", -- [8]
			"61744:61474:61759:60230", -- [9]
			"61744:61474:61759:62658:60231", -- [10]
			"61744:61474:60232", -- [11]
			"61744:61474:61759:62658:60231:59049", -- [12]
			"61473:62903:63500:63501:58843", -- [13]
			"61473:62903:63500:63501:59048", -- [14]
			"61473:62903:63500:63501:59048:65189", -- [15]
			"61744:61474:61759:62658:60231:59049:60441", -- [16]
			"61744:61474", -- [17]
			"61504:61118", -- [18]
			"61504:61118:61511", -- [19]
			"61744:61474:61759", -- [20]
			"61744:61474:61759:62658", -- [21]
			"61512:62901", -- [22]
			"61473:62903", -- [23]
			"61512:62901:62898", -- [24]
			"61512:62901:62898:62909", -- [25]
			"61744:61121", -- [26]
			"61473:62903:63500:63501", -- [27]
			"61473:62903:63500:63501:63498", -- [28]
			"61473:62903:63500", -- [29]
			"61512:63497", -- [30]
			"61744:61474:61759:60230:59186:64310", -- [31]
			"61473:62903:63500:63501:65511", -- [32]
			"61744:61121:65865", -- [33]
			"61744:61474:66023:56737:71940", -- [34]
			--["name"] = "Kota Basecamp, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "61744:61504:61473:61512",
			["coord"] = 1836691981,
		},
		[58843] = {
			"60231:60230:59186", -- [1]
			"60231:60232:66023", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60232:66023:59727", -- [4]
			"60231:60230:59186:59735:59733", -- [5]
			"60231:60230:59186:59735", -- [6]
			"60231:60230:59186:59736", -- [7]
			"60231:60232:66023:56737", -- [8]
			"60231:60230", -- [9]
			"60231:60232", -- [10]
			"59048:60441", -- [11]
			"60231:62658:61759:61474", -- [12]
			"60231:62658:61759:61474:61118", -- [13]
			"60231:62658:61759:61474:61744", -- [14]
			"60231:62658:61759:61474:61118:61511", -- [15]
			"60231:62658:61759:61474:61504", -- [16]
			"63501:63500:62903:61473:60416", -- [17]
			"63501:63500:62903:61473", -- [18]
			"63501:63497:61512", -- [19]
			"60231:62658:61759", -- [20]
			"60231:62658", -- [21]
			"63501:63500:62903:62901", -- [22]
			"63501:63500:62903", -- [23]
			"63501:63500:62903:62898", -- [24]
			"63501:63500:62903:62898:62909", -- [25]
			"60231:61121", -- [26]
			"63501:63498", -- [27]
			"63501:63500", -- [28]
			"63501:63497", -- [29]
			"60231:60232:66023:56737:64310", -- [30]
			"63501:65511", -- [31]
			"60231:61121:65865", -- [32]
			"60231:60232:66023:56737:71940", -- [33]
			--["name"] = "Stoneplow, Valley of the Four Winds",
			["m"] = 376,
			["f"] = 0,
			["direct"] = "60231:59049:59048:65189:63501",
			["coord"] = 869897766,
		},
		[60231] = {
			"60230:59186", -- [1]
			"60232:66023", -- [2]
			"60230:59186:59732", -- [3]
			"60232:66023:59727", -- [4]
			"60230:59186:59735:59733", -- [5]
			"60230:59186:59735", -- [6]
			"60230:59186:59736", -- [7]
			"60232:66023:56737", -- [8]
			"59049:60441", -- [9]
			"62658:61759:61474", -- [10]
			"62658:61759:61474:61118", -- [11]
			"62658:61759:61474:61744", -- [12]
			"62658:61759:61474:61118:61511", -- [13]
			"62658:61759:61474:61504", -- [14]
			"62658:61759:61474:61744:60416", -- [15]
			"62658:61759:61474:61744:61473", -- [16]
			"62658:61759:61474:61744:60416:61512", -- [17]
			"62658:61759", -- [18]
			"62658:61759:61474:61744:61473:62901", -- [19]
			"58843:63501:63500:62903", -- [20]
			"58843:63501:63500:62903:62898", -- [21]
			"58843:63501:63500:62903:62898:62909", -- [22]
			"58843:63501", -- [23]
			"58843:63501:63498", -- [24]
			"58843:63501:63500", -- [25]
			"61121:63497", -- [26]
			"60232:66023:56737:64310", -- [27]
			"58843:63501:65511", -- [28]
			"61121:65865", -- [29]
			"60232:66023:56737:71940", -- [30]
			--["name"] = "Halfhill, Valley of the Four Winds",
			["direct"] = "60230:60232:59049:58843:59048:65189:62658:61121",
			["f"] = 0,
			["m"] = 376,
			["coord"] = 2423292124,
		},
		[71940] = {
			"56737:66023", -- [1]
			"56737:59727:59732", -- [2]
			"56737:59727", -- [3]
			"59186:59735:59733", -- [4]
			"59186:59735", -- [5]
			"59186:59736", -- [6]
			"56737:66023:60232:60230", -- [7]
			"56737:66023:60232:60231", -- [8]
			"56737:66023:60232", -- [9]
			"56737:66023:60232:60231:59049", -- [10]
			"56737:66023:60232:60231:58843", -- [11]
			"56737:66023:60232:60231:59048", -- [12]
			"56737:66023:60232:60231:65189", -- [13]
			"56737:66023:60232:60231:59049:60441", -- [14]
			"56737:66023:61474", -- [15]
			"56737:66023:61474:61118", -- [16]
			"56737:66023:61474:61744", -- [17]
			"56737:66023:61474:61118:61511", -- [18]
			"56737:66023:61474:61504", -- [19]
			"56737:66023:61474:61744:60416", -- [20]
			"56737:66023:61474:61744:61473", -- [21]
			"56737:66023:61474:61744:60416:61512", -- [22]
			"56737:66023:60232:60230:61759", -- [23]
			"56737:66023:60232:60230:62658", -- [24]
			"56737:66023:61474:61744:61473:62901", -- [25]
			"56737:66023:61474:61744:61473:62903", -- [26]
			"56737:66023:61474:61744:61473:62903:62898", -- [27]
			"56737:66023:61474:61744:61473:62903:62898:62909", -- [28]
			"56737:66023:61121", -- [29]
			"56737:66023:60232:60231:58843:63501", -- [30]
			"56737:66023:60232:60231:58843:63501:63498", -- [31]
			"56737:66023:61121:63500", -- [32]
			"56737:66023:61121:63497", -- [33]
			"56737:64310", -- [34]
			"56737:66023:60232:60231:58843:63501:65511", -- [35]
			"56737:66023:61121:65865", -- [36]
			--["name"] = "Tushui Landing, Timeless Isle",
			["m"] = 554,
			["f"] = 0,
			["direct"] = "59186:56737",
			["coord"] = 994620814,
		},
		[59733] = {
			"59735:59186", -- [1]
			"59735:59186:66023", -- [2]
			"59732:59727", -- [3]
			"59735:59736", -- [4]
			"59732:59727:56737", -- [5]
			"59735:59186:60230", -- [6]
			"59735:59186:60230:60231", -- [7]
			"59735:59186:60230:60232", -- [8]
			"59735:59186:60230:60231:59049", -- [9]
			"59735:59186:60230:60231:58843", -- [10]
			"59735:59186:60230:60231:59048", -- [11]
			"59735:59186:60230:60231:65189", -- [12]
			"59735:59186:60230:60231:59049:60441", -- [13]
			"59735:59186:60230:61759:61474", -- [14]
			"59735:59186:60230:61759:61474:61118", -- [15]
			"59735:59186:60230:61759:61474:61744", -- [16]
			"59735:59186:60230:61759:61474:61118:61511", -- [17]
			"59735:59186:60230:61759:61474:61504", -- [18]
			"59735:59186:60230:61759:61474:61744:60416", -- [19]
			"59735:59186:60230:61759:61474:61744:61473", -- [20]
			"59735:59186:60230:61759:61474:61744:60416:61512", -- [21]
			"59735:59186:60230:61759", -- [22]
			"59735:59186:60230:62658", -- [23]
			"59735:59186:60230:61759:61474:61744:61473:62901", -- [24]
			"59735:59186:60230:61759:61474:61744:61473:62903", -- [25]
			"59735:59186:60230:61759:61474:61744:61473:62903:62898", -- [26]
			"59735:59186:60230:61759:61474:61744:61473:62903:62898:62909", -- [27]
			"59735:59186:60230:62658:61121", -- [28]
			"59735:59186:60230:60231:58843:63501", -- [29]
			"59735:59186:60230:60231:58843:63501:63498", -- [30]
			"59735:59186:60230:62658:61121:63500", -- [31]
			"59735:59186:60230:62658:61121:63497", -- [32]
			"59735:59186:64310", -- [33]
			"59735:59186:60230:60231:58843:63501:65511", -- [34]
			"59735:59186:60230:62658:61121:65865", -- [35]
			"59732:59727:56737:71940", -- [36]
			--["name"] = "Sri-La Village, Jade Forest",
			["m"] = 371,
			["coord"] = 2380414099,
			["direct"] = "59732:59735",
			["f"] = 0,
		},
		[59735] = {
			"59186:66023", -- [1]
			"59186:59732", -- [2]
			"59186:59727", -- [3]
			"59186:59727:56737", -- [4]
			"59186:60230", -- [5]
			"59186:60230:60231", -- [6]
			"59186:60230:60232", -- [7]
			"59186:60230:60231:59049", -- [8]
			"59186:60230:60231:58843", -- [9]
			"59186:60230:60231:59048", -- [10]
			"59186:60230:60231:65189", -- [11]
			"59186:60230:60231:59049:60441", -- [12]
			"59186:60230:61759:61474", -- [13]
			"59186:60230:61759:61474:61118", -- [14]
			"59186:60230:61759:61474:61744", -- [15]
			"59186:60230:61759:61474:61118:61511", -- [16]
			"59186:60230:61759:61474:61504", -- [17]
			"59186:60230:61759:61474:61744:60416", -- [18]
			"59186:60230:61759:61474:61744:61473", -- [19]
			"59186:60230:61759:61474:61744:60416:61512", -- [20]
			"59186:60230:61759", -- [21]
			"59186:60230:62658", -- [22]
			"59186:60230:61759:61474:61744:61473:62901", -- [23]
			"59186:60230:61759:61474:61744:61473:62903", -- [24]
			"59186:60230:61759:61474:61744:61473:62903:62898", -- [25]
			"59186:60230:61759:61474:61744:61473:62903:62898:62909", -- [26]
			"59186:60230:62658:61121", -- [27]
			"59186:60230:60231:58843:63501", -- [28]
			"59186:60230:60231:58843:63501:63498", -- [29]
			"59186:60230:62658:61121:63500", -- [30]
			"59186:60230:62658:61121:63497", -- [31]
			"59186:64310", -- [32]
			"59186:60230:60231:58843:63501:65511", -- [33]
			"59186:60230:62658:61121:65865", -- [34]
			"59186:71940", -- [35]
			--["name"] = "Emperor's Omen, Jade Forest",
			["m"] = 371,
			["f"] = 0,
			["direct"] = "59186:59733:59736",
			["coord"] = 2184266963,
		},
		[59048] = {
			"60231:60230:59186", -- [1]
			"60231:60232:66023", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60232:66023:59727", -- [4]
			"60231:60230:59186:59735:59733", -- [5]
			"60231:60230:59186:59735", -- [6]
			"60231:60230:59186:59736", -- [7]
			"60231:60232:66023:56737", -- [8]
			"60231:60230", -- [9]
			"60231:60232", -- [10]
			"60231:62658:61759:61474", -- [11]
			"60231:62658:61759:61474:61118", -- [12]
			"60231:62658:61759:61474:61744", -- [13]
			"60231:62658:61759:61474:61118:61511", -- [14]
			"60231:62658:61759:61474:61504", -- [15]
			"63501:63500:62903:61473:60416", -- [16]
			"63501:63500:62903:61473", -- [17]
			"63501:63497:61512", -- [18]
			"60231:62658:61759", -- [19]
			"60231:62658", -- [20]
			"63501:63500:62903:62901", -- [21]
			"63501:63500:62903", -- [22]
			"63501:63500:62903:62898", -- [23]
			"63501:63500:62903:62898:62909", -- [24]
			"60231:61121", -- [25]
			"63501:63498", -- [26]
			"63501:63500", -- [27]
			"63501:63497", -- [28]
			"60231:60232:66023:56737:64310", -- [29]
			"63501:65511", -- [30]
			"60231:61121:65865", -- [31]
			"60231:60232:66023:56737:71940", -- [32]
			--["name"] = "Sentinel Basecamp, Krasarang Wilds",
			["direct"] = "60231:59049:58843:65189:60441:63501",
			["f"] = 0,
			["m"] = 418,
			["coord"] = 1078875572,
		},
		[61759] = {
			"60230:59186", -- [1]
			"60230:60232:66023", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59727", -- [4]
			"60230:59186:59735:59733", -- [5]
			"60230:59186:59735", -- [6]
			"60230:59186:59736", -- [7]
			"60230:60232:66023:56737", -- [8]
			"62658:60231", -- [9]
			"60230:60232", -- [10]
			"62658:60231:59049", -- [11]
			"62658:60231:58843", -- [12]
			"62658:60231:59048", -- [13]
			"62658:60231:65189", -- [14]
			"62658:60231:59049:60441", -- [15]
			"61474:61118", -- [16]
			"61474:61744", -- [17]
			"61474:61118:61511", -- [18]
			"61474:61504", -- [19]
			"61474:61744:60416", -- [20]
			"61474:61744:61473", -- [21]
			"61474:61744:60416:61512", -- [22]
			"61474:61744:61473:62901", -- [23]
			"61474:61744:61473:62903", -- [24]
			"61474:61744:61473:62903:62898", -- [25]
			"61474:61744:61473:62903:62898:62909", -- [26]
			"62658:61121", -- [27]
			"62658:60231:58843:63501", -- [28]
			"62658:60231:58843:63501:63498", -- [29]
			"62658:61121:63500", -- [30]
			"62658:61121:63497", -- [31]
			"60230:59186:64310", -- [32]
			"62658:60231:58843:63501:65511", -- [33]
			"62658:61121:65865", -- [34]
			"60230:60232:66023:56737:71940", -- [35]
			--["name"] = "Tavern in the Mists, The Veiled Stair",
			["m"] = 433,
			["f"] = 0,
			["direct"] = "60230:61474:62658",
			["coord"] = 2433204651,
		},
		[61511] = {
			"61118:61474:61759:60230:59186", -- [1]
			"61118:61474:66023", -- [2]
			"61118:61474:61759:60230:59186:59732", -- [3]
			"61118:61474:61759:60230:59186:59727", -- [4]
			"61118:61474:61759:60230:59186:59735:59733", -- [5]
			"61118:61474:61759:60230:59186:59735", -- [6]
			"61118:61474:61759:60230:59186:59736", -- [7]
			"61118:61474:66023:56737", -- [8]
			"61118:61474:61759:60230", -- [9]
			"61118:61474:61759:62658:60231", -- [10]
			"61118:61474:60232", -- [11]
			"61118:61474:61759:62658:60231:59049", -- [12]
			"61118:61474:61759:62658:60231:58843", -- [13]
			"61118:61474:61759:62658:60231:59048", -- [14]
			"61118:61474:61759:62658:60231:65189", -- [15]
			"61118:61474:61759:62658:60231:59049:60441", -- [16]
			"61118:61474", -- [17]
			"61504:60416", -- [18]
			"61744:61473", -- [19]
			"61504:60416:61512", -- [20]
			"61118:61474:61759", -- [21]
			"61118:61474:61759:62658", -- [22]
			"61504:60416:61512:62901", -- [23]
			"61744:61473:62903", -- [24]
			"61744:61473:62903:62898", -- [25]
			"61744:61473:62903:62898:62909", -- [26]
			"61744:61121", -- [27]
			"61744:61473:62903:63500:63501", -- [28]
			"61744:61473:62903:63500:63501:63498", -- [29]
			"61744:61473:62903:63500", -- [30]
			"61744:61121:63497", -- [31]
			"61118:61474:61759:60230:59186:64310", -- [32]
			"61744:61473:62903:63500:63501:65511", -- [33]
			"61744:61121:65865", -- [34]
			"61118:61474:66023:56737:71940", -- [35]
			--["name"] = "Zouchin Village, Kun-Lai Summit",
			["m"] = 379,
			["f"] = 0,
			["direct"] = "61118:61744:61504",
			["coord"] = 2681621769,
		},
		[62901] = {
			"61473:61744:61474:61759:60230:59186", -- [1]
			"61473:61744:61474:66023", -- [2]
			"61473:61744:61474:61759:60230:59186:59732", -- [3]
			"61473:61744:61474:61759:60230:59186:59727", -- [4]
			"61473:61744:61474:61759:60230:59186:59735:59733", -- [5]
			"61473:61744:61474:61759:60230:59186:59735", -- [6]
			"61473:61744:61474:61759:60230:59186:59736", -- [7]
			"61473:61744:61474:66023:56737", -- [8]
			"61473:61744:61474:61759:60230", -- [9]
			"61473:61744:61474:61759:62658:60231", -- [10]
			"61473:61744:61474:60232", -- [11]
			"61473:61744:61474:61759:62658:60231:59049", -- [12]
			"62903:63500:63501:58843", -- [13]
			"62903:63500:63501:59048", -- [14]
			"62903:63500:63501:59048:65189", -- [15]
			"62903:63500:63501:59048:60441", -- [16]
			"61473:61744:61474", -- [17]
			"61512:60416:61504:61118", -- [18]
			"61473:61744", -- [19]
			"61512:60416:61504:61118:61511", -- [20]
			"61512:60416:61504", -- [21]
			"61512:60416", -- [22]
			"61473:61744:61474:61759", -- [23]
			"61473:61744:61474:61759:62658", -- [24]
			"62898:62909", -- [25]
			"61473:61744:61121", -- [26]
			"62903:63500:63501", -- [27]
			"62903:63500:63501:63498", -- [28]
			"62903:63500", -- [29]
			"62903:63500:63497", -- [30]
			"61473:61744:61474:61759:60230:59186:64310", -- [31]
			"62903:63500:63501:65511", -- [32]
			"61473:61744:61121:65865", -- [33]
			"61473:61744:61474:66023:56737:71940", -- [34]
			--["name"] = "Longying Outpost, Townlong Steppes",
			["m"] = 388,
			["f"] = 0,
			["direct"] = "61473:61512:62903:62898",
			["coord"] = 3054473921,
		},
		[59186] = {
			"59735:59733", -- [1]
			"60230:60231", -- [2]
			"60230:60232", -- [3]
			"60230:60231:59049", -- [4]
			"60230:60231:58843", -- [5]
			"60230:60231:59048", -- [6]
			"60230:60231:65189", -- [7]
			"60230:60231:59049:60441", -- [8]
			"60230:61759:61474", -- [9]
			"60230:61759:61474:61118", -- [10]
			"60230:61759:61474:61744", -- [11]
			"60230:61759:61474:61118:61511", -- [12]
			"60230:61759:61474:61504", -- [13]
			"60230:61759:61474:61744:60416", -- [14]
			"60230:61759:61474:61744:61473", -- [15]
			"60230:61759:61474:61744:60416:61512", -- [16]
			"60230:61759", -- [17]
			"60230:62658", -- [18]
			"60230:61759:61474:61744:61473:62901", -- [19]
			"60230:61759:61474:61744:61473:62903", -- [20]
			"60230:61759:61474:61744:61473:62903:62898", -- [21]
			"60230:61759:61474:61744:61473:62903:62898:62909", -- [22]
			"60230:60231:58843:63501", -- [23]
			"60230:60231:58843:63501:63498", -- [24]
			"60230:62658:61121:63500", -- [25]
			"60230:62658:61121:63497", -- [26]
			"60