setmetatable(DugisWorldMapTrackingPoints,
{
	__index = function(t,i)
		t[i] = {}
		return t[i]
	end,
})

local tappend = DugisGuideViewer.TableAppend
local points = DugisWorldMapTrackingPoints

DugisGuideViewer.ExtendedTrackingPointsExists = true


local function safeTappend(key, items)
    if not points[key] then
        points[key] = {}
    end
    
    tappend(points[key], unpack(items))
end


--Dalaran
safeTappend("1014:0", {
--Warbot/Mechanical:
"P:44.6,46.0:227:",
--Blue Clockwork Rocket Bot/Mechanical:
"P:44.6,46.0:254:"
})
--Here the rest of pets ...

safeTappend(1961.0, { --Korthia
	--Anxious Nibbler/Critter:
	"P:25.4,55.6:3134:",
	"P:26,51.4:3134:",
	"P:29.4,52.4:3134:",
	"P:32.4,56.2:3134:",
	"P:32.8,58.6:3134:",
	"P:34.2,40.2:3134:",
	"P:36,32.4:3134:",
	"P:36.2,36.2:3134:",
	"P:37.6,33.6:3134:",
	"P:38,37.2:3134:",
	"P:45,30.2:3134:",
	"P:45.4,32.4:3134:",
	"P:45.4,36:3134:",
	"P:46.2,27.4:3134:",
	"P:47.4,30.4:3134:",
	"P:47.6,35.4:3134:",
	"P:49.4,34.4:3134:",
	"P:49.8,29.4:3134:",
	"P:50.4,27:3134:",
	"P:51.4,37.4:3134:",
	"P:52.2,43.4:3134:",
	"P:53.4,30.2:3134:",
	"P:53.4,36.6:3134:",
	"P:53.4,39.4:3134:",
	"P:55,28.4:3134:",
	"P:55.4,41.4:3134:",
	"P:57.2,43.4:3134:",
	"P:58,45.6:3134:",
	"P:60.4,44.4:3134:",
	--Young Garnetgullet/Critter:
	"P:25.4,55.4:3135:",
	"P:26,51.2:3135:",
	"P:29.4,52.2:3135:",
	"P:32.2,57.8:3135:",
	"P:32.8,55.2:3135:",
	"P:34.4,40.4:3135:",
	"P:36,32.4:3135:",
	"P:36.2,36.4:3135:",
	"P:38.2,36.4:3135:",
	"P:45,29.4:3135:",
	"P:45.2,32.4:3135:",
	"P:45.4,35.8:3135:",
	"P:46.2,27.4:3135:",
	"P:47.4,30.2:3135:",
	"P:47.6,35.4:3135:",
	"P:49.4,34.4:3135:",
	"P:50.2,29.8:3135:",
	"P:50.4,26.4:3135:",
	"P:51.4,37.2:3135:",
	"P:52.2,43.4:3135:",
	"P:53.2,39.4:3135:",
	"P:53.4,30.2:3135:",
	"P:53.4,36.6:3135:",
	"P:55,28.8:3135:",
	"P:55.2,41.6:3135:",
	"P:57.2,42.4:3135:",
	"P:58.2,45.4:3135:",
	"P:60.8,44.6:3135:",
	--Animite Broodling/Flying:
	"P:29.2,44.4:3102:",
	"P:31.4,44.8:3102:",
	"P:34.4,45.4:3102:",
	"P:35.2,47.6:3102:",
	"P:36.4,50.4:3102:",
	"P:36.4,53.8:3102:",
	"P:38.4,47.2:3102:",
	"P:38.4,49.2:3102:",
	"P:39.2,52.4:3102:",
	"P:40.8,47:3102:",
	"P:42.4,48.6:3102:",
	"P:51.4,23.8:3102:",
	"P:53.4,20.4:3102:",
	"P:53.4,22.4:3102:",
	"P:53.8,17.6:3102:",
	"P:54.4,14.4:3102:",
	"P:55.4,22.2:3102:",
	"P:57.4,23:3102:",
	--Devourling/Beast:
	"P:29.4,45:3139:",
	"P:31.4,45.2:3139:",
	"P:34,46:3139:",
	"P:35.4,47.6:3139:",
	"P:38.4,49.8:3139:",
	"P:39.4,53.4:3139:",
	"P:40.4,47:3139:",
	"P:40.4,51.4:3139:",
	"P:42.4,48:3139:",
	"P:51.4,24.4:3139:",
	"P:53.4,15.8:3139:",
	"P:53.4,20.2:3139:",
	"P:53.4,23.2:3139:",
	"P:56,21.4:3139:",
	"P:57.4,23:3139:",
	--Eye of Affliction/Magic:
	"P:44.2,56:3126:",
	"P:45.2,50.4:3126:",
	"P:46.2,54.4:3126:",
	"P:49.4,48.4:3126:",
	"P:49.4,52.4:3126:",
	"P:49.4,54.6:3126:",
	"P:53.4,49.4:3126:",
	"P:53.4,52.6:3126:",
	"P:54.4,47.4:3126:",
	"P:55.2,34.2:3126:",
	"P:55.4,36.4:3126:",
	"P:56.2,54.6:3126:",
	"P:57.2,37.6:3126:",
	"P:57.4,52:3126:",
	"P:58.4,39.6:3126:",
	"P:59.4,33.2:3126:",
	"P:59.8,56.8:3126:",
	"P:60.4,37:3126:",
	"P:60.4,54.4:3126:",
	"P:61.4,46.8:3126:",
	"P:61.6,34.4:3126:",
	"P:62.6,36.2:3126:",
	"P:63.2,49.2:3126:",
	--Treasures
	"A:38344296:15099:1::64222", --Glittering Nest Material
	"A:68902990:15099:2::64234", --Forgotten Feather
	"A:52991477:15099:3::64238", --Lost Memento
	"A:47502920:15099:4::64241", --Dislodged Nest
	"A:29595342:15099:5::64244", --Anima Laden Egg
	"A:50478446:15099:6::64252", --Displaced Relic
	"A:40145892:15099:9::64264", --Infested Vestige
	"A:45336714:15099:10::64268", --,Offering Box
	"A:63713166:15099:::64361", --Nest of Unusual Materials
	--Explore
	"A:40115298:15053:1", --Esruary of Awakening
	"A:35053494:15053:2", --Hope's Ascent
	"A:60812408:15053:3", --Keeper's Respite
	"A:53513101:15053:4", --Mauler's Outlook
	"A:57272249:15053:5", --Sanctuary of Guidance
	"A:61843097:15053:6", --Scholar's Den
	"A:54965391:15053:7", --Seeker's Quorum
	"A:49666462:15053:8", --Vault of Secrets
	"A:30215507:15053:9", --Windswept Aerie
	--Rares
	"R:58211773:180246:Reward (item:187370)\n(item:187399)::64258", --Consumption
	"R:33183938:180014:Reward (item:187423)\n(item:187395)\n(item:186492)::64320", --Escaped Wilderling
	"R:59934371:180042:Reward (item:187424)\n(item:187372)\n(item:186489)::64349", --Fleshwing
	"R:30215490:179472:Reward (item:187375)\n(item:187378)\n(item:187384)\n(item:187397)\n(item:187183)::64246", --Konthrogz the Obliterator
	"R:44222950:179684:Reward (item:187377)\n(item:186645)::64233", --Malbog
	"R:22604140:179931:Reward (item:187403)::64291", --Pelic Breaker Krelva
	"R:44604240:179608:Reward (item:187400)\n(item:187362)::64263", --Screaming Shade
	"R:46507959:179985:Reward (item:187428)\n(item:187386)\n(item:186479)::64313", --Stygian Stonecrusher
	"R:58433556:179760:Reward (item:187373)\n(item:187376)\n(item:187383)\n(item:187392)\n(item:187035)\n(item:187242)\n(item:187241)::64245", --Towering Exterminator
	"R:49182879:180162:Reward (item:187264)\n(item:187404)\n(item:187369)::64457", --Ve'rayn
	"R:44983552:179859:Reward (item:187104)\n(item:187387)\n(item:187368)::64278", --Xyraxz the Unknowable
	"R:58211773:180246:Reward (item:187370)\n(item:187399)::64258", --Carriage Crusher
	"R:59335221:179913:Reward (item:187401)\n(item:187396)::64285", --Deadsoul Hatcher
	"R:51822081:177903:Reward (item:187390)::63830", --Dominated Protector
	"R:59203580:179108:Reward (item:187394)\n(item:187248)\n(item:187250)::64428", --Kroke the Tormented
	"R:50307590:179914:Reward (item:187405)\n(item:187365)\n(item:187420)::64440", --Observer Yorik
	"R:56276617:180160:Reward (item:187388)\n(item:186652)::64455", --Reliwik the Defiant
	"R:57607040:179911:Reward (item:187381)\n(item:187383)::64284", --Silent Soulstalker
	"R:56873237:180032:Reward (item:187423)\n(item:187380)\n(item:187176)\n(item:186483)::64338", --Wild Worldcracker
	"R:39405240:179802:Reward (item:187103)\n(item:187391)\n(item:187366)::64257", --Yarxhov the Pillager
	"R:27755885:177336:Reward (item:187371)\n(item:186542)::64442"}) --Zelnithop

safeTappend(1970.0, { --Zereth Mortis
	--Bufonid Croaker/Aquatic:
	"P:32.6,61.0:3173:",
	"P:34.4,70.8:3173:",
	"P:36.4,70.0:3173:",
	"P:43.8,60.8:3173:",
	"P:44.0,87.6:3173:",
	"P:44.8,58.4:3173:",
	"P:45.2,62.8:3173:",
	"P:47.4,85.6:3173:",
	"P:47.4,88.4:3173:",
	"P:47.6,91.8:3173:",
	"P:48.2,60.6:3173:",
	"P:48.4,74.2:3173:",
	"P:49.6,59.0:3173:",
	"P:50.0,62.6:3173:",
	"P:50.2,72.2:3173:",
	"P:50.4,74.4:3173:",
	"P:50.8,89.6:3173:",
	"P:52.6,90.8:3173:",
	"P:57.8,84.0:3173:",
	"P:60.2,72.2:3173:",
	"P:60.2,74.6:3173:",
	"P:63.6,70.8:3173:",
	"P:75.4,52.6:3173:",
	"P:75.4,54.6:3173:",
	"P:75.6,47.4:3173:",
	"P:76.2,45.0:3173:",
	"P:77.2,60.2:3173:",
	"P:77.6,52.4:3173:",
	"P:80.4,45.2:3173:",
	--Emerald Scarabid/Critter:
	"P:39.4,25.2:3206:",
	"P:41.4,23.6:3206:",
	"P:42.4,31.0:3206:",
	"P:43.4,29.2:3206:",
	"P:43.8,21.4:3206:",
	"P:46.2,23.4:3206:",
	"P:48.4,28.4:3206:",
	"P:49.4,46.4:3206:",
	"P:50.4,44.4:3206:",
	"P:50.8,48.4:3206:",
	"P:53.0,47.8:3206:",
	"P:56.4,50.6:3206:",
	"P:57.0,25.6:3206:",
	"P:58.0,30.6:3206:",
	"P:59.2,52.2:3206:",
	"P:59.4,36.0:3206:",
	"P:60.0,26.0:3206:",
	"P:61.0,34.2:3206:",
	"P:62.4,30.0:3206:",
	"P:62.4,36.0:3206:",
	"P:63.0,22.4:3206:",
	"P:63.8,41.4:3206:",
	"P:65.4,29.0:3206:",
	"P:65.4,37.4:3206:",
	"P:66.0,45.2:3206:",
	"P:66.4,26.8:3206:",
	"P:69.4,33.8:3206:",
	"P:75.2,47.0:3206:",
	"P:75.2,60.8:3206:",
	"P:75.4,58.8:3206:",
	"P:78.4,46.2:3206:",
	"P:80.2,48.6:3206:",
	--Red Viperid/Beast:
	"P:45.2,7.4:3208:",
	"P:47.2,10.4:3208:",
	"P:47.2,25.4:3208:",
	"P:47.8,2.2:3208:",
	"P:47.8,6.2:3208:",
	"P:48.2,50.0:3208:",
	"P:48.4,29.0:3208:",
	"P:49.0,47.6:3208:",
	"P:49.2,13.6:3208:",
	"P:50.2,24.4:3208:",
	"P:50.4,43.4:3208:",
	"P:50.8,45.6:3208:",
	"P:51.6,5.2:3208:",
	"P:51.8,31.2:3208:",
	"P:54.0,48.4:3208:",
	"P:55.2,30.4:3208:",
	"P:56.2,49.2:3208:",
	"P:59.0,24.6:3208:",
	"P:59.0,31.4:3208:",
	"P:59.8,35.4:3208:",
	"P:61.0,29.0:3208:",
	"P:62.0,35.2:3208:",
	"P:62.4,19.4:3208:",
	"P:62.8,46.4:3208:",
	"P:63.2,26.4:3208:",
	"P:63.4,30.2:3208:",
	"P:64.0,32.2:3208:",
	"P:64.4,20.8:3208:",
	"P:64.8,38.8:3208:",
	"P:65.4,43.2:3208:",
	"P:67.0,25.2:3208:",
	"P:67.0,29.8:3208:",
	"P:68.0,37.2:3208:",
	"P:68.4,34.4:3208:",
	--Green Viperid/Beast:
	"P:35.4,55.2:3210:",
	"P:36.2,60.8:3210:",
	"P:36.4,58.2:3210:",
	"P:36.4,64.8:3210:",
	"P:37.4,68.4:3210:",
	"P:38.6,55.8:3210:",
	"P:39.6,46.8:3210:",
	"P:39.8,63.4:3210:",
	"P:40.8,66.0:3210:",
	"P:42.6,67.0:3210:",
	"P:44.2,91.4:3210:",
	"P:45.4,88.0:3210:",
	"P:46.4,81.4:3210:",
	"P:49.0,81.6:3210:",
	"P:50.6,84.0:3210:",
	"P:53.0,83.6:3210:",
	"P:53.2,66.2:3210:",
	"P:54.8,63.6:3210:",
	"P:55.2,68.6:3210:",
	"P:55.2,82.8:3210:",
	"P:55.4,76.4:3210:",
	"P:56.6,81.2:3210:",
	"P:58.0,47.8:3210:",
	"P:58.0,68.2:3210:",
	"P:58.4,77.2:3210:",
	"P:58.4,84.2:3210:",
	"P:60.0,45.6:3210:",
	"P:60.2,43.4:3210:",
	"P:60.4,68.8:3210:",
	"P:62.0,46.8:3210:",
	"P:62.0,49.4:3210:",
	"P:62.4,68.4:3210:",
	"P:63.0,64.2:3210:",
	"P:75.4,45.4:3210:",
	"P:75.8,49.0:3210:",
	"P:78.8,47.2:3210:",
	"P:78.8,59.8:3210:",
	"P:80.8,48.0:3210:",
	--Bloodsucker Vespoid/Flying:
	"P:42.0,34.0:3212:",
	"P:43.8,32.8:3212:",
	"P:46.8,13.6:3212:",
	"P:47.4,29.6:3212:",
	"P:48.8,27.8:3212:",
	"P:50.2,48.4:3212:",
	"P:50.4,6.4:3212:",
	"P:51.8,27.4:3212:",
	"P:52.4,46.0:3212:",
	"P:52.6,25.4:3212:",
	"P:56.4,48.8:3212:",
	"P:59.0,48.8:3212:",
	"P:61.2,54.4:3212:",
	"P:61.4,51.6:3212:",
	"P:61.8,60.6:3212:",
	"P:62.0,57.8:3212:",
	"P:64.2,57.4:3212:",
	--Momma Vombata/Beast:
	"P:33.6,59.4:3214:",
	"P:34.4,57.4:3214:",
	"P:35.0,64.2:3214:",
	"P:37.2,65.2:3214:",
	"P:38.4,68.4:3214:",
	"P:39.8,66.8:3214:",
	"P:40.8,51.2:3214:",
	"P:41.4,46.4:3214:",
	"P:44.0,46.0:3214:",
	"P:45.0,77.2:3214:",
	"P:45.4,74.2:3214:",
	"P:45.8,67.0:3214:",
	"P:46.6,50.2:3214:",
	"P:46.6,78.4:3214:",
	"P:46.8,70.8:3214:",
	"P:46.8,76.2:3214:",
	"P:49.2,68.4:3214:",
	"P:50.4,71.0:3214:",
	"P:59.4,76.4:3214:",
	"P:79.8,60.8:3214:",
	"P:80.2,49.4:3214:",
	"P:80.4,56.4:3214:",
	"P:80.8,59.0:3214:",
	--Ambystan Snapper/Aquatic:
	"P:35.0,56.0:3216:",
	"P:35.4,44.2:3216:",
	"P:39.2,33.8:3216:",
	"P:39.2,71.4:3216:",
	"P:45.4,65.0:3216:",
	"P:48.0,73.8:3216:",
	--Enraged Poultrid/Flying:
	"P:29.0,56.0:3218:",
	"P:29.4,51.8:3218:",
	"P:30.2,49.4:3218:",
	"P:30.6,57.2:3218:",
	"P:32.4,52.0:3218:",
	"P:33.0,63.8:3218:",
	"P:34.8,62.4:3218:",
	"P:34.8,68.0:3218:",
	"P:35.4,47.0:3218:",
	"P:35.4,65.0:3218:",
	"P:36.0,43.4:3218:",
	"P:39.6,49.2:3218:",
	"P:39.8,46.8:3218:",
	"P:39.8,55.4:3218:",
	"P:44.0,83.8:3218:",
	"P:44.8,92.4:3218:",
	"P:48.2,81.2:3218:",
	"P:48.4,95.8:3218:",
	"P:52.4,87.4:3218:",
	"P:53.0,93.2:3218:",
	"P:53.4,84.4:3218:",
	"P:54.8,81.0:3218:",
	--Timid Leporid/Critter:
	"P:32.4,63.2:3191:",
	"P:33.8,65.2:3191:",
	"P:34.6,61.8:3191:",
	"P:35.4,46.4:3191:",
	"P:35.6,67.4:3191:",
	"P:36.2,43.8:3191:",
	"P:36.2,63.0:3191:",
	"P:37.4,70.4:3191:",
	"P:37.8,51.2:3191:",
	"P:38.2,58.6:3191:",
	"P:39.4,61.6:3191:",
	"P:41.8,64.2:3191:",
	"P:42.6,46.0:3191:",
	"P:42.8,49.0:3191:",
	"P:43.2,86.8:3191:",
	"P:45.4,93.4:3191:",
	"P:46.2,45.4:3191:",
	"P:49.4,93.2:3191:",
	"P:51.4,85.4:3191:",
	"P:51.8,82.8:3191:",
	"P:53.2,87.6:3191:",
	"P:53.4,89.8:3191:",
	"P:54.4,83.0:3191:",
	"P:55.4,79.2:3191:",
	"P:58.6,59.8:3191:",
	"P:60.6,71.6:3191:",
	"P:75.8,56.2:3191:",
	"P:76.0,50.8:3191:",
	"P:76.8,48.0:3191:",
	"P:81.2,46.0:3191:",
	--Leaping Leporid/Critter:
	"P:29.4,52.4:3232:",
	"P:29.4,54.6:3232:",
	"P:29.8,49.4:3232:",
	"P:31.4,54.8:3232:",
	"P:33.4,55.4:3232:",
	--Tarachnid Ambusher/Beast:
	"P:37.4,36.2:3203:",
	"P:39.8,34.6:3203:",
	"P:41.0,36.4:3203:",
	"P:45.8,39.4:3203:",
	"P:46.8,42.2:3203:",
	"P:48.2,40.0:3203:",
	"P:49.4,42.2:3203:",
	"P:56.2,36.4:3203:",
	"P:57.4,26.8:3203:",
	"P:58.0,33.4:3203:",
	"P:59.0,36.8:3203:",
	"P:59.8,29.0:3203:",
	"P:60.2,38.4:3203:",
	"P:61.4,31.2:3203:",
	"P:61.6,40.2:3203:",
	"P:62.4,38.0:3203:",
	"P:63.2,42.0:3203:",
	"P:63.8,29.4:3203:",
	"P:64.0,24.2:3203:",
	"P:64.0,36.4:3203:",
	"P:64.2,21.8:3203:",
	"P:65.4,31.0:3203:",
	"P:66.0,41.0:3203:",
	"P:67.2,34.2:3203:",
	"P:67.2,39.2:3203:",
	"P:68.0,27.0:3203:",
	"P:68.4,32.4:3203:",
	--Metallic Scarabid/Critter:
	"P:37.8,38.4:3205:",
	"P:39.2,33.2:3205:",
	"P:39.2,35.4:3205:",
	"P:41.2,33.4:3205:",
	"P:46.6,42.0:3205:",
	"P:47.0,39.0:3205:",
	"P:47.0,49.8:3205:",
	"P:48.6,42.0:3205:",
	"P:49.2,39.2:3205:",
	"P:57.4,52.2:3205:",
	"P:59.8,23.4:3205:",
	"P:60.4,50.8:3205:",
	"P:61.0,42.4:3205:",
	"P:61.6,21.4:3205:",
	"P:61.8,18.6:3205:",
	"P:62.4,58.0:3205:",
	"P:75.0,49.0:3205:",
	"P:76.6,59.0:3205:",
	"P:76.8,61.8:3205:",
	"P:78.6,48.0:3205:",
	--King Viperid/Beast:
	"P:35.4,55.0:3209:",
	"P:36.0,60.8:3209:",
	"P:36.4,64.8:3209:",
	"P:36.6,58.2:3209:",
	"P:37.4,68.4:3209:",
	"P:38.4,56.0:3209:",
	"P:39.4,46.8:3209:",
	"P:39.8,63.4:3209:",
	"P:41.0,65.8:3209:",
	"P:42.6,67.2:3209:",
	"P:45.2,7.4:3209:",
	"P:45.4,88.0:3209:",
	"P:46.4,82.4:3209:",
	"P:47.0,25.4:3209:",
	"P:47.2,10.0:3209:",
	"P:47.8,2.2:3209:",
	"P:48.0,6.0:3209:",
	"P:48.2,50.0:3209:",
	"P:48.4,28.8:3209:",
	"P:48.8,81.4:3209:",
	"P:49.0,47.6:3209:",
	"P:49.4,13.4:3209:",
	"P:50.2,24.4:3209:",
	"P:50.4,43.4:3209:",
	"P:50.4,83.8:3209:",
	"P:51.2,45.8:3209:",
	"P:51.6,5.2:3209:",
	"P:52.0,31.2:3209:",
	"P:53.0,83.6:3209:",
	"P:53.2,66.2:3209:",
	"P:54.4,48.8:3209:",
	"P:54.8,63.6:3209:",
	"P:55.2,30.8:3209:",
	"P:55.2,68.4:3209:",
	"P:55.4,76.2:3209:",
	"P:55.4,82.8:3209:",
	"P:56.6,71.2:3209:",
	"P:57.8,68.6:3209:",
	"P:58.0,47.8:3209:",
	"P:58.2,82.2:3209:",
	"P:58.4,77.4:3209:",
	"P:58.4,84.2:3209:",
	"P:59.0,24.8:3209:",
	"P:59.0,31.2:3209:",
	"P:60.0,35.8:3209:",
	"P:60.0,43.2:3209:",
	"P:60.0,45.4:3209:",
	"P:60.4,64.2:3209:",
	"P:60.4,68.8:3209:",
	"P:61.0,29.0:3209:",
	"P:62.0,35.2:3209:",
	"P:62.0,47.0:3209:",
	"P:62.0,49.4:3209:",
	"P:62.4,19.2:3209:",
	"P:62.4,68.4:3209:",
	"P:62.4,70.8:3209:",
	"P:62.8,64.4:3209:",
	"P:63.2,26.0:3209:",
	"P:63.4,30.4:3209:",
	"P:64.6,20.8:3209:",
	"P:64.8,38.6:3209:",
	"P:65.2,43.2:3209:",
	"P:66.8,29.8:3209:",
	"P:67.2,25.2:3209:",
	"P:68.2,37.2:3209:",
	"P:75.0,47.2:3209:",
	"P:76.2,44.4:3209:",
	"P:77.0,48.2:3209:",
	"P:78.8,47.2:3209:",
	"P:78.8,60.0:3209:",
	"P:80.6,48.2:3209:",
	--Venomous Bufonid/Aquatic:
	"P:32.8,61.0:3180:",
	"P:34.4,70.8:3180:",
	"P:36.4,70.2:3180:",
	"P:43.0,87.8:3180:",
	"P:43.6,60.4:3180:",
	"P:44.8,58.2:3180:",
	"P:45.4,63.0:3180:",
	"P:47.2,88.6:3180:",
	"P:47.4,85.4:3180:",
	"P:47.6,91.8:3180:",
	"P:48.0,60.4:3180:",
	"P:48.6,74.2:3180:",
	"P:49.6,58.8:3180:",
	"P:50.0,62.6:3180:",
	"P:50.2,72.2:3180:",
	"P:50.6,74.4:3180:",
	"P:50.8,89.4:3180:",
	"P:51.2,60.0:3180:",
	"P:52.8,90.8:3180:",
	"P:57.8,84.0:3180:",
	"P:60.0,72.0:3180:",
	"P:60.2,74.4:3180:",
	"P:63.6,71.0:3180:",
	"P:75.0,59.2:3180:",
	"P:75.2,53.8:3180:",
	"P:75.4,45.6:3180:",
	"P:77.0,60.6:3180:",
	"P:77.2,44.0:3180:",
	"P:77.2,51.4:3180:",
	"P:79.0,45.2:3180:",
	"P:81.0,46.0:3180:",
	--Vombata Pup/Beast:
	"P:33.6,59.4:3213:",
	"P:34.6,57.4:3213:",
	"P:35.0,64.2:3213:",
	"P:37.2,65.2:3213:",
	"P:38.4,68.4:3213:",
	"P:39.8,66.8:3213:",
	"P:40.8,51.2:3213:",
	"P:41.4,46.4:3213:",
	"P:43.8,46.2:3213:",
	"P:45.0,77.0:3213:",
	"P:45.4,74.0:3213:",
	"P:45.8,67.0:3213:",
	"P:46.6,50.2:3213:",
	"P:46.6,78.2:3213:",
	"P:46.8,70.8:3213:",
	"P:47.8,75.6:3213:",
	"P:50.4,71.0:3213:",
	"P:59.4,76.4:3213:",
	"P:79.8,60.4:3213:",
	"P:80.2,49.6:3213:",
	"P:80.4,56.6:3213:",
	--Mawtouched Geomental/Elemental:
	"P:58.8,72.0:3215:",
	"P:60.4,69.0:3215:",
	"P:60.8,75.6:3215:",
	"P:61.4,73.4:3215:",
	"P:61.8,67.2:3215:",
	"P:63.2,68.8:3215:",
	"P:64.2,71.2:3215:",
	--Aurelid Floater/Aquatic:
	"P:35.6,71.8:3217:",
	"P:52.4,75.0:3217:",
	"P:57.4,82.4:3217:",
	"P:64.4,68.8:3217:",
	--Predatory Helicid/Critter:
	"P:58.4,82.0:3219:",
	"P:58.4,84.2:3219:",
	--Vicious Leporid/Critter:
	"P:34.8,66.8:3190:",
	"P:35.4,59.4:3190:",
	"P:36.4,46.2:3190:",
	"P:37.4,70.4:3190:",
	"P:41.6,63.4:3190:",
	"P:44.8,42.8:3190:",
	"P:45.2,49.2:3190:",
	"P:45.4,93.2:3190:",
	"P:46.4,73.0:3190:",
	"P:49.6,67.2:3190:",
	"P:51.4,83.0:3190:",
	"P:52.8,70.0:3190:",
	"P:55.4,82.2:3190:",
	"P:62.4,74.0:3190:",
	"P:75.8,45.2:3190:",
	"P:76.8,58.0:3190:",
	"P:80.4,58.6:3190:",
	"P:80.6,48.8:3190:",
	--Proto Avian Fledgling/Flying:
	"P:29.0,56.4:3196:",
	"P:29.4,52.8:3196:",
	"P:32.2,52.2:3196:",
	"P:32.4,55.0:3196:",
	"P:35.4,46.2:3196:",
	"P:35.8,43.8:3196:",
	"P:37.4,45.2:3196:",
	"P:40.6,54.6:3196:",
	"P:41.8,46.2:3196:",
	"P:42.4,33.8:3196:",
	"P:42.4,69.0:3196:",
	"P:43.2,75.0:3196:",
	"P:44.2,31.2:3196:",
	"P:45.4,54.0:3196:",
	"P:47.0,28.4:3196:",
	"P:51.0,63.0:3196:",
	"P:51.8,59.2:3196:",
	"P:63.2,43.0:3196:",
	"P:63.8,49.4:3196:",
	"P:64.6,46.4:3196:",
	--Scarlet Proto Avian/Flying:
	"P:32.2,52.2:3200:",
	"P:37.2,45.8:3200:",
	"P:63.8,49.4:3200:",
	"P:64.6,46.4:3200:",
	--Tarachnid Stalker/Beast:
	"P:49.0,25.4:3202:",
	"P:49.4,45.4:3202:",
	"P:50.0,2.2:3202:",
	"P:50.0,42.4:3202:",
	"P:50.4,8.4:3202:",
	"P:50.4,50.2:3202:",
	"P:51.4,44.0:3202:",
	"P:51.6,26.4:3202:",
	"P:52.0,47.0:3202:",
	"P:52.6,29.4:3202:",
	"P:53.2,50.6:3202:",
	"P:53.6,44.4:3202:",
	"P:54.0,31.0:3202:",
	"P:55.0,46.4:3202:",
	"P:55.2,42.4:3202:",
	"P:56.0,31.4:3202:",
	"P:56.4,28.6:3202:",
	"P:57.0,33.4:3202:",
	"P:57.2,47.2:3202:",
	"P:59.0,22.4:3202:",
	"P:60.4,17.4:3202:",
	"P:60.4,20.2:3202:",
	"P:60.6,15.2:3202:",
	"P:74.8,48.2:3202:",
	"P:75.2,45.0:3202:",
	--Treasures
	"A:58847715:15331:1::65173", --Library Vault (Lost Scroll)
	"A:58737301:15331:2::64545", --Submerged Chest
	"A:38273723:15331:3::64667", --Damaged Jiro Stash
	"A:59614619:15331:4::65175", --Template Archive
	"A:66816944:15331:5::65178", --Forgotten Proto-Vault
	"A:52626301:15331:6::65270", --Symphonic Vault
	"A:60613055:15331:7::65441", --Mawsworn Cache
	"A:37906519:15331:8::65447", --Stolen Relic
	"A:51550992:15331:9::65487", --Fallen Vault
	"A:38987330:15331:10::65480", --Gnawed Valise
	"A:60061800:15331:11::65465", --Domination Cache
	"A:49758725:15331:12::65503", --Filched Artifact
	"A:61223721:15331:13::65520", --Architect's Reserve
	"A:56786417:15331:14::65489", --Crushed Supply Crate
	"A:35244411:15331:15::65536", --Overgrown Protofruit
	"A:53577222:15331:16::65522", --Mistaken Ovoid
	"A:35177023:15331:17::65523", --Drowned Broker Supplies
	"A:34825604:15331:18::65537", --Offering to the First Ones
	"A:46653093:15331:19::65540", --Protomineral Extractor
	"A:60884296:15331:20::65542", --Pilfered Curio
	"A:34046765:15331:21::65543", --Stolen Scroll
	"A:37157828:15331:22::65545", --Grateful Boon
	"A:52577149:15331:23::65546", --Protoflora Harvester
	"A:76875883:15331:24::65565", --Syntactic Vault
	"A:63607371:15331:25::65566", --Ripened Protopear
	"A:51238069:15331:26::65572", --Undulating Foliage
	"A:47449524:15331:27::65573", --Bushel of Progenitor Produce
	--Explore
	"A:27005300:15224:1", --Path of Inception
	"A:34006800:15224:2", --Haven
	"A:38006300:15224:3", --The Great Veldt
	"A:36004300:15224:4", --Faith's Repose
	"A:40004100:15224:5", --Terrace of Formation
	"A:44008700:15224:6", --Catalyst Gardens
	"A:57003100:15224:7", --Deserted Overlook
	"A:52003100:15224:8", --Dimensional Falls
	"A:59002200:15224:9", --The Dread Portal
	"A:46006400:15224:10", --Provis Fauna
	"A:40007200:15224:11", --Genesis Fields
	"A:41003100:15224:12", --Zovaal's Grasp
	"A:59005100:15224:13", --Pilgrim's Grace
	"A:54004700:15224:14", --Plain of Actualization
	"A:66003600:15224:15", --Arrangement Index
	"A:56003600:15224:16", --Lexical Glade
	"A:51002900:15224:17", --Resonant Peaks
	--Rares
	"R:53089305:178778:Reward (item:189929)\n(item:189953)\n(item:190008)\n(item:190049)::65579", --Gluttonous Overgrowth
	"R:61826060:178229:Reward (item:189969)\n(item:189970)\n(item:189936)::65557", --Feasting
	"R:53384707:183927:Reward (item:189927)\n(item:189955)\n(item:189998)::65574", --Sand Matriarch Ileus
	"R:64743369:179006:Reward (item:189903)\n(item:189958)\n(item:190053)::65552", --Akkaris
	"R:49783914:183925:Reward (item:189915)\n(item:189933)\n(item:189954)::65272", --Tahkwitz
	"R:55736915:179043:Reward (item:189912)\n(item:189934)\n(item:189952)::65582", --Orixal
	"R:47044698:183747:Reward (item:189901)\n(item:189922)\n(item:189935)::65584", --Vitiane
	"R:59862111:182318:Reward (item:189968)\n(item:189948)\n(item:190125)::65583", --General Zarathura
	"R:54507344:181249:Reward (item:189928)\n(item:189966)\n(item:190055)::65550", --Tethos
	"R:38872762:189177:Reward (item:189961)\n(item:189984)\n(item:190002)::64668", --Protector of the First Ones
	"R:69073662:180924:Reward (item:189951)\n(item:189937)::64719", --Garudeon
	"R:52287541:180978:Reward (item:189905)\n(item:189946)\n(item:190005)\n(item:187676)::65548", --Hirukon
	"R:58654039:183814:Reward (item:189909)\n(item:189945)\n(item:189957)::65257", --Otaris the Provoked
	"R:58186837:183748:Reward (item:189931)\n(item:189965)\n(item:190054)\n(item:190056)::65551", --Helmix
	"R:43947530:183516:Reward (item:189913)\n(item:189921)\n(item:190006)::65580", --The Engulfer
	"R:43308762:183746:Reward (item:189914)\n(item:189925)\n(item:190046)\n(item:189995)::65556", --Otiosen
	"R:53634435:180917:Reward (item:189910)\n(item:189930)\n(item:189985)\n(item:189999)::64716", --Destabilized Core
	"R:64054975:183737:Reward (item:190052)\n(item:190007)\n(item:190238)::65241", --Xy'rath the Covetous
	"R:49566751:183596:Reward (item:189947)\n(item:189906)\n(item:189994)::65553", --Chitali the Eldest
	"R:35877121:183722:Reward (item:189911)\n(item:189944)\n(item:189962)::65240", --Sorranos
	"R:47474516:184409:Reward (item:189949)\n(item:189956)\n(item:190047)\n(item:189993)::65555", --Euv'ouk
	"R:52612503:178563:Reward (item:189919)\n(item:189942)\n(item:190051)\n(item:190000)::65581", --Hadeon the Stonebreaker
	"R:80384706:178963:Reward (item:189960)\n(item:190001)::63988", --Gorkek
	"R:80324594:178963:Reward (item:189960)\n(item:190001)::63988", --Gorkek
	"R:80844886:178963:Reward (item:189960)\n(item:190001)::63988", --Gorkek
	"R:42302099:184413:Reward (item:189908)\n(item:189916)\n(item:189941)\n(item:189972)::65549", --Shifting Stargorger
	"R:54083493:178508:Reward (item:189923)\n(item:189950)\n(item:190045)::65547", --Mother Phestis
	"R:64585865:183646:Reward (item:189920)\n(item:189932)\n(item:189963)\n(item:190004)::65544", --Furidian
	"R:43513294:183764:Reward (item:189902)\n(item:189924)\n(item:189939)::65251", --Zatojin
	"R:47486228:183953:Reward (item:189907)\n(item:189940)\n(item:190009)::65273", --Corrupted Architect
	"R:39555737:181360:Reward (item:189900)\n(item:189959)\n(item:189997)\n(item:190048)::65239"}) --Vexis

safeTappend(2022.0, {--The Waking Shores
	--Wild Duckling/Aquatic:
	"P:57.0,71.0:3301:",
	"P:68.2,60.8:3301:",
	"P:75.0,48.2:3301:",
	"P:80.0,49.6:3301:",
	"P:83.0,45.4:3301:",
	--Pricklefury Hare/Critter:
	"P:65.2,58.4:3272:",
	"P:66.0,40.2:3272:",
	"P:69.2,41.6:3272:",
	"P:73.0,55.0:3272:",
	"P:73.6,41.4:3272:",
	"P:74.0,53.0:3272:",
	"P:76.0,33.2:3272:",
	"P:77.4,30.8:3272:",
	"P:77.8,49.0:3272:",
	"P:78.0,33.4:3272:",
	"P:81.6,32.2:3272:",
	--Vorquin Runt/Beast:
	"P:18.2,96.2:3336:",
	"P:19.2,85.4:3336:",
	"P:19.4,88.2:3336:",
	"P:21.6,92.4:3336:",
	"P:24.0,94.6:3336:",
	"P:25.4,91.4:3336:",
	"P:27.6,86.2:3336:",
	"P:32.2,79.8:3336:",
	"P:34.2,79.2:3336:",
	"P:37.0,85.2:3336:",
	"P:48.8,38.8:3336:",
	"P:58.0,49.0:3336:",
	"P:60.8,41.4:3336:",
	"P:61.6,43.6:3336:",
	"P:62.4,38.0:3336:",
	"P:62.8,48.0:3336:",
	"P:63.2,41.2:3336:",
	"P:63.8,51.8:3336:",
	"P:65.2,39.4:3336:",
	"P:67.2,40.8:3336:",
	"P:67.6,43.4:3336:",
	"P:67.6,73.2:3336:",
	"P:68.0,47.4:3336:",
	--Plucky Duckling/Aquatic:
	"P:57.0,71.0:3307:",
	--Shyfly/Flying:
	"P:37.6,78.8:3280:",
	"P:38.6,81.4:3280:",
	"P:39.4,77.0:3280:",
	"P:40.2,85.6:3280:",
	"P:40.4,79.6:3280:",
	"P:41.6,81.8:3280:",
	"P:43.0,77.0:3280:",
	"P:43.2,79.4:3280:",
	--Swoglet/Aquatic:
	"P:23.0,93.6:3282:",
	"P:25.0,92.8:3282:",
	"P:25.2,88.8:3282:",
	"P:26.4,86.4:3282:",
	"P:37.4,81.4:3282:",
	"P:38.6,89.0:3282:",
	"P:41.4,82.6:3282:",
	"P:43.0,86.8:3282:",
	"P:43.4,79.8:3282:",
	"P:46.4,77.2:3282:",
	"P:49.0,75.2:3282:",
	"P:50.2,68.8:3282:",
	"P:50.6,35.2:3282:",
	"P:50.8,64.8:3282:",
	"P:51.0,72.4:3282:",
	"P:52.0,39.4:3282:",
	"P:52.0,49.2:3282:",
	"P:52.8,60.2:3282:",
	"P:53.2,57.4:3282:",
	"P:53.4,53.4:3282:",
	"P:53.6,43.6:3282:",
	"P:54.2,62.0:3282:",
	"P:55.0,55.4:3282:",
	"P:55.6,68.6:3282:",
	"P:56.8,44.8:3282:",
	"P:56.8,71.2:3282:",
	"P:57.4,53.0:3282:",
	"P:58.2,47.0:3282:",
	"P:59.8,64.2:3282:",
	"P:63.8,68.8:3282:",
	"P:65.8,65.6:3282:",
	"P:66.0,60.8:3282:",
	"P:66.0,63.4:3282:",
	"P:68.8,72.6:3282:",
	"P:71.8,56.4:3282:",
	--Shore Crab/Aquatic:
	"P:76.2,47.6:388:",
	"P:79.0,46.8:388:",
	"P:81.0,29.2:388:",
	"P:81.4,31.2:388:",
	"P:82.0,36.0:388:",
	--Storm-Touched Stomper/Beast:
	"P:26.2,72.2:3385:",
	"P:26.4,69.8:3385:",
	"P:27.8,73.8:3385:",
	"P:28.4,68.8:3385:",
	"P:29.4,52.6:3385:",
	"P:29.4,55.4:3385:",
	"P:29.4,71.2:3385:",
	"P:30.4,68.4:3385:",
	"P:31.2,56.4:3385:",
	"P:32.0,51.4:3385:",
	"P:63.4,27.4:3385:",
	"P:63.8,30.0:3385:",
	"P:66.0,27.2:3385:",
	"P:66.4,24.4:3385:",
	--Palamanther/Aquatic:
	"P:16.6,86.2:3296:",
	"P:17.0,88.6:3296:",
	"P:23.2,84.2:3296:",
	"P:28.2,88.0:3296:",
	"P:28.6,90.0:3296:",
	"P:37.6,87.2:3296:",
	"P:40.2,90.0:3296:",
	"P:41.0,73.4:3296:",
	"P:44.0,86.2:3296:",
	"P:45.4,76.4:3296:",
	"P:46.2,27.2:3296:",
	"P:46.6,79.4:3296:",
	"P:47.8,25.0:3296:",
	"P:48.4,75.0:3296:",
	"P:49.2,72.6:3296:",
	"P:50.4,47.4:3296:",
	"P:51.6,62.4:3296:",
	"P:53.4,60.2:3296:",
	"P:53.8,54.6:3296:",
	"P:54.4,57.0:3296:",
	"P:59.8,43.4:3296:",
	"P:60.4,51.4:3296:",
	"P:62.0,54.8:3296:",
	"P:64.0,59.0:3296:",
	"P:66.2,42.6:3296:",
	"P:67.2,50.8:3296:",
	"P:69.0,58.2:3296:",
	"P:69.2,43.0:3296:",
	"P:69.4,50.4:3296:",
	"P:69.8,48.2:3296:",
	--Ironbeak Duck/Flying:
	"P:14.8,95.8:3300:",
	"P:16.8,86.4:3300:",
	"P:17.0,91.4:3300:",
	"P:17.6,93.4:3300:",
	"P:22.4,84.6:3300:",
	"P:24.0,81.4:3300:",
	"P:27.0,80.4:3300:",
	"P:53.6,52.2:3300:",
	"P:55.0,44.0:3300:",
	"P:55.6,57.0:3300:",
	"P:72.8,44.4:3300:",
	"P:73.8,41.8:3300:",
	"P:76.4,50.4:3300:",
	"P:77.6,52.6:3300:",
	"P:79.0,42.4:3300:",
	"P:79.0,50.4:3300:",
	--Kindlet/Elemental:
	"P:32.8,64.2:3366:",
	"P:33.2,61.6:3366:",
	"P:37.4,69.6:3366:",
	"P:38.2,73.2:3366:",
	"P:55.6,20.4:3366:",
	"P:55.6,24.4:3366:",
	"P:57.0,22.4:3366:",
	"P:61.0,34.6:3366:",
	"P:62.8,26.0:3366:",
	"P:63.8,28.6:3366:",
	"P:64.0,31.2:3366:",
	"P:66.0,30.8:3366:",
	"P:66.2,28.4:3366:",
	"P:66.8,38.2:3366:",
	"P:68.4,36.2:3366:",
	"P:69.0,62.6:3366:",
	"P:73.0,33.2:3366:",
	"P:74.6,34.8:3366:",
	"P:80.6,35.8:3366:",
	--Scruffy Ottuk/Aquatic:
	"P:14.2,90.0:3281:",
	"P:16.2,91.2:3281:",
	"P:17.4,94.0:3281:",
	"P:18.6,88.4:3281:",
	"P:25.4,79.6:3281:",
	"P:28.2,85.6:3281:",
	"P:37.0,86.4:3281:",
	"P:44.4,27.8:3281:",
	"P:45.6,26.0:3281:",
	"P:47.6,29.4:3281:",
	"P:48.2,24.2:3281:",
	"P:48.8,42.4:3281:",
	"P:50.4,38.8:3281:",
	"P:50.8,65.4:3281:",
	"P:51.6,49.8:3281:",
	"P:53.0,36.0:3281:",
	"P:53.4,59.4:3281:",
	"P:53.8,38.0:3281:",
	"P:54.0,33.8:3281:",
	"P:54.0,57.0:3281:",
	"P:55.0,36.2:3281:",
	"P:55.8,58.4:3281:",
	"P:60.4,48.0:3281:",
	"P:61.0,39.0:3281:",
	"P:62.2,55.8:3281:",
	"P:63.8,43.8:3281:",
	"P:68.4,50.2:3281:",
	"P:68.4,59.8:3281:",
	--Snowlemental/Elemental:
	"P:53.0,81.0:3283:",
	"P:54.4,82.6:3283:",
	"P:55.0,79.4:3283:",
	"P:57.0,80.2:3283:",
	"P:57.2,83.4:3283:",
	"P:58.0,74.0:3283:",
	"P:58.2,77.4:3283:",
	"P:59.2,79.8:3283:",
	"P:59.4,75.6:3283:",
	"P:60.6,83.4:3283:",
	"P:61.0,80.8:3283:",
	--Thunderfoot Calf/Beast:
	"P:45.8,35.2:3318:",
	--Grassland Stomper/Beast:
	"P:41.0,61.8:3313:",
	--Magma Slug/Elemental:
	"P:50.4,32.8:3273:",
	"P:54.4,33.8:3273:",
	"P:59.8,37.2:3273:",
	"P:67.4,37.2:3273:",
	"P:68.2,39.8:3273:",
	"P:77.0,27.0:3273:",
	"P:77.2,29.2:3273:",
	"P:79.4,35.0:3273:",
	"P:83.6,33.0:3273:",
	"P:84.2,35.8:3273:",
	--Igneoid/Elemental:
	"P:41.0,85.4:3295:",
	"P:49.6,68.0:3295:",
	"P:51.0,31.2:3295:",
	"P:53.4,30.4:3295:",
	"P:60.4,79.0:3295:",
	"P:60.4,83.0:3295:",
	--Emberling/Elemental:
	"P:25.2,69.6:3367:",
	"P:26.6,74.2:3367:",
	"P:32.2,71.4:3367:",
	"P:38.6,75.2:3367:",
	"P:39.8,56.4:3367:",
	"P:40.6,62.8:3367:",
	"P:40.6,65.8:3367:",
	"P:58.4,34.6:3367:",
	"P:58.6,31.0:3367:",
	"P:63.6,27.2:3367:",
	"P:65.0,30.0:3367:",
	"P:67.0,33.0:3367:",
	"P:67.8,27.2:3367:",
	"P:69.4,68.8:3367:",
	"P:73.2,33.6:3367:",
	"P:75.6,35.6:3367:",
	"P:79.2,35.4:3367:",
	"P:83.8,34.6:3367:",
	--Treasures
	"A:65804182:16297:1::70600", -- Golden Dragon Goblet
	"A:40454136:16297:2::70599", -- Bubble Drifter
	"A:61347079:16297:3::70598", -- Ruby Gem Cluster
	"A:46713121:16297:4::70345", -- Yennu's Kite
	"A:69314658:16297:5::70346", -- Dead Man's Chestplate
	"A:48498516:16297:6::70378", -- Torn Riding Pack
	"A:58585301:16297:7::65646", -- Misty Treasure Chest
	"A:29454699:16297:8::72020", -- Onyx Gem Cluster
	--Explore
	"A:30488225:16400:1", -- Apex Canopy
	"A:70944277:16400:2", -- Dragonheart Outpost
	"A:51677778:16400:3", -- Frostflash Assault
	"A:55152739:16400:4", -- Life Binder Conservatory
	"A:44776597:16400:5", -- Obsidian Bulwark
	"A:32706206:16400:6", -- Obsidian Citadel
	"A:50143905:16400:7", -- Overflowing Rapids
	"A:51756671:16400:8", -- Ruby Life Pools
	"A:67533890:16400:9", -- Scalecracker Keep
	"A:72655179:16400:10", -- Skytop Observatory
	"A:77163343:16400:11", -- Wild Coast
	"A:39057794:16400:12"}) -- Wild Preserve

safeTappend(2023.0, {--Ohn'ahran Plains
	--The Quackcestor/Undead:
	"P:41.4,45.0:3389:",
	"P:42.4,47.8:3389:",
	"P:42.8,43.4:3389:",
	--Pricklefury Hare/Critter:
	"P:71.8,33.0:3272:",
	"P:76.2,30.8:3272:",
	--Tiny Timbertooth/Beast:
	"P:71.0,72.0:3328:",
	"P:73.0,76.2:3328:",
	"P:73.2,85.8:3328:",
	"P:79.0,48.4:3328:",
	"P:80.0,50.4:3328:",
	"P:81.0,78.2:3328:",
	"P:81.4,45.8:3328:",
	"P:81.4,47.8:3328:",
	--Trunkalumpf/Beast:
	"P:54.6,61.4:3288:",
	"P:55.2,65.2:3288:",
	"P:71.8,53.4:3288:",
	"P:72.6,44.2:3288:",
	"P:74.6,50.8:3288:",
	"P:75.2,33.2:3288:",
	"P:76.4,20.2:3288:",
	"P:76.4,27.4:3288:",
	"P:78.8,35.2:3288:",
	"P:79.8,27.0:3288:",
	"P:80.0,21.2:3288:",
	--Palamanther/Aquatic:
	"P:22.2,63.8:3296:",
	"P:23.6,68.0:3296:",
	"P:24.8,66.0:3296:",
	"P:37.6,55.4:3296:",
	"P:37.8,65.8:3296:",
	"P:42.2,61.2:3296:",
	"P:42.8,44.0:3296:",
	"P:44.2,68.4:3296:",
	"P:47.4,49.0:3296:",
	"P:48.4,66.0:3296:",
	"P:50.4,75.4:3296:",
	"P:50.8,43.4:3296:",
	"P:51.6,66.4:3296:",
	"P:51.8,73.0:3296:",
	"P:52.0,71.0:3296:",
	"P:53.8,70.0:3296:",
	"P:54.2,75.4:3296:",
	"P:54.8,72.6:3296:",
	"P:54.8,77.8:3296:",
	"P:69.0,39.0:3296:",
	"P:70.2,79.2:3296:",
	"P:71.4,83.2:3296:",
	"P:71.8,69.2:3296:",
	"P:72.0,35.4:3296:",
	"P:72.0,65.0:3296:",
	"P:74.4,55.8:3296:",
	"P:78.6,79.4:3296:",
	"P:83.0,76.6:3296:",
	--Black Slyvern Pup/Flying:
	"P:62.4,22.8:3266:",
	"P:63.2,26.4:3266:",
	"P:63.4,28.4:3266:",
	"P:64.0,21.0:3266:",
	--Swoglet/Aquatic:
	"P:29.4,58.4:3282:",
	"P:29.6,51.6:3282:",
	"P:33.0,52.8:3282:",
	"P:36.4,52.6:3282:",
	"P:39.2,53.8:3282:",
	"P:40.2,42.2:3282:",
	"P:41.4,38.0:3282:",
	"P:43.2,59.0:3282:",
	"P:45.6,68.4:3282:",
	"P:47.4,61.2:3282:",
	"P:49.8,69.0:3282:",
	"P:51.6,65.2:3282:",
	"P:53.0,75.4:3282:",
	"P:56.4,80.4:3282:",
	"P:61.8,54.2:3282:",
	"P:73.0,62.4:3282:",
	"P:73.8,82.4:3282:",
	"P:75.2,73.6:3282:",
	"P:78.2,73.2:3282:",
	"P:81.8,71.4:3282:",
	"P:83.8,77.8:3282:",
	"P:84.4,51.4:3282:",
	"P:85.2,44.8:3282:",
	"P:86.2,46.6:3282:",
	--Dusky Timbertooth/Beast:
	"P:71.6,74.0:3327:",
	--Grassland Stomper/Beast:
	"P:48.6,49.4:3313:",
	"P:50.6,47.2:3313:",
	"P:54.0,50.2:3313:",
	"P:55.8,54.0:3313:",
	"P:56.2,51.0:3313:",
	--Treeflitter/Critter:
	"P:28.0,49.4:3276:",
	"P:29.2,54.0:3276:",
	"P:29.2,68.2:3276:",
	"P:29.4,43.8:3276:",
	"P:30.0,47.8:3276:",
	"P:30.2,74.8:3276:",
	"P:31.2,76.8:3276:",
	"P:31.8,69.0:3276:",
	"P:32.2,33.4:3276:",
	"P:32.2,39.0:3276:",
	"P:32.2,62.8:3276:",
	"P:32.8,35.8:3276:",
	"P:33.2,43.0:3276:",
	"P:33.8,50.0:3276:",
	"P:34.2,46.2:3276:",
	"P:34.6,56.6:3276:",
	"P:35.8,32.0:3276:",
	"P:35.8,41.8:3276:",
	"P:36.4,38.8:3276:",
	"P:36.4,50.6:3276:",
	"P:36.4,69.4:3276:",
	"P:37.4,33.6:3276:",
	"P:37.6,46.0:3276:",
	"P:38.4,39.0:3276:",
	"P:38.4,55.0:3276:",
	"P:39.2,44.6:3276:",
	"P:39.6,36.4:3276:",
	"P:39.6,49.2:3276:",
	"P:40.6,39.2:3276:",
	"P:40.8,51.4:3276:",
	"P:41.4,42.2:3276:",
	"P:43.0,37.0:3276:",
	"P:44.8,38.2:3276:",
	"P:45.8,45.4:3276:",
	"P:47.0,36.0:3276:",
	"P:48.2,43.4:3276:",
	"P:49.0,30.6:3276:",
	"P:50.0,28.6:3276:",
	"P:50.4,25.6:3276:",
	"P:51.0,31.2:3276:",
	"P:51.4,40.0:3276:",
	"P:53.4,35.8:3276:",
	"P:55.4,39.4:3276:",
	"P:55.4,42.4:3276:",
	"P:55.8,34.0:3276:",
	"P:57.0,27.2:3276:",
	"P:57.6,23.4:3276:",
	"P:58.0,43.2:3276:",
	"P:58.6,38.2:3276:",
	"P:59.2,20.8:3276:",
	"P:59.8,26.2:3276:",
	"P:60.0,40.2:3276:",
	"P:60.8,23.2:3276:",
	"P:61.4,30.4:3276:",
	"P:61.6,38.2:3276:",
	"P:61.8,15.4:3276:",
	"P:61.8,45.2:3276:",
	"P:63.4,10.8:3276:",
	"P:63.6,32.4:3276:",
	"P:64.2,28.2:3276:",
	"P:64.2,36.6:3276:",
	"P:64.4,45.2:3276:",
	"P:64.8,15.8:3276:",
	"P:65.0,19.2:3276:",
	"P:65.2,53.4:3276:",
	"P:65.4,38.8:3276:",
	"P:65.4,42.8:3276:",
	"P:65.4,60.4:3276:",
	"P:65.4,63.2:3276:",
	"P:65.4,73.8:3276:",
	"P:66.0,70.2:3276:",
	"P:66.2,66.0:3276:",
	"P:67.2,53.8:3276:",
	"P:69.2,59.2:3276:",
	"P:71.2,55.4:3276:",
	"P:71.6,60.4:3276:",
	"P:79.4,31.0:3276:",
	"P:81.4,37.0:3276:",
	"P:81.4,60.8:3276:",
	"P:81.8,57.4:3276:",
	"P:82.2,23.0:3276:",
	"P:82.2,39.0:3276:",
	"P:83.0,59.0:3276:",
	"P:84.4,39.6:3276:",
	"P:84.6,55.6:3276:",
	"P:85.0,60.4:3276:",
	"P:86.0,16.8:3276:",
	"P:86.8,35.2:3276:",
	"P:88.0,13.4:3276:",
	--Storm-Touched Timbertooth/Beast:
	"P:32.6,39.4:3329:",
	"P:33.8,35.4:3329:",
	"P:34.4,33.4:3329:",
	"P:34.6,44.4:3329:",
	"P:35.0,42.4:3329:",
	"P:36.4,34.2:3329:",
	"P:36.4,38.8:3329:",
	--Woodbiter Piculet/Flying:
	"P:60.8,14.8:3322:",
	"P:61.0,52.2:3322:",
	"P:61.4,24.0:3322:",
	"P:62.2,35.2:3322:",
	"P:62.8,25.6:3322:",
	"P:64.0,58.0:3322:",
	"P:64.4,12.8:3322:",
	"P:65.0,18.2:3322:",
	--Ironbeak Duck/Flying:
	"P:26.8,44.6:3300:",
	"P:30.4,58.2:3300:",
	"P:32.0,55.8:3300:",
	"P:34.0,52.6:3300:",
	"P:34.0,59.2:3300:",
	"P:38.2,54.6:3300:",
	"P:39.4,66.6:3300:",
	"P:40.2,54.6:3300:",
	"P:42.0,39.0:3300:",
	"P:42.2,41.8:3300:",
	"P:42.4,47.8:3300:",
	"P:42.8,65.4:3300:",
	"P:44.0,34.2:3300:",
	"P:45.0,53.8:3300:",
	"P:46.4,66.0:3300:",
	"P:48.4,52.4:3300:",
	"P:49.0,68.6:3300:",
	"P:50.4,72.0:3300:",
	"P:52.4,26.4:3300:",
	"P:53.0,29.0:3300:",
	"P:54.4,66.4:3300:",
	"P:54.6,68.6:3300:",
	"P:57.8,36.6:3300:",
	"P:60.8,19.8:3300:",
	"P:63.2,21.2:3300:",
	"P:67.4,34.4:3300:",
	"P:67.8,29.4:3300:",
	"P:69.2,79.2:3300:",
	"P:70.0,37.8:3300:",
	"P:71.2,50.4:3300:",
	"P:72.2,76.4:3300:",
	"P:74.4,78.4:3300:",
	"P:75.0,26.2:3300:",
	"P:76.8,36.2:3300:",
	"P:78.4,38.0:3300:",
	"P:79.8,72.0:3300:",
	"P:82.2,73.8:3300:",
	"P:82.6,33.8:3300:",
	"P:83.4,37.4:3300:",
	"P:85.2,31.8:3300:",
	"P:86.8,61.4:3300:",
	--Stoneshell/Aquatic:
	"P:22.8,56.8:3353:",
	"P:25.8,55.2:3353:",
	"P:44.0,33.2:3353:",
	"P:52.0,26.0:3353:",
	"P:54.4,28.2:3353:",
	"P:56.0,46.2:3353:",
	"P:59.4,48.2:3353:",
	"P:62.8,47.2:3353:",
	"P:66.0,36.8:3353:",
	"P:66.4,48.4:3353:",
	"P:66.8,34.0:3353:",
	"P:68.2,43.4:3353:",
	"P:68.4,31.4:3353:",
	"P:70.4,31.4:3353:",
	"P:72.2,28.0:3353:",
	"P:73.8,35.2:3353:",
	"P:74.0,59.4:3353:",
	"P:75.2,37.2:3353:",
	"P:75.6,23.4:3353:",
	"P:80.8,69.2:3353:",
	"P:82.4,15.0:3353:",
	"P:82.6,27.4:3353:",
	"P:82.8,33.4:3353:",
	"P:82.8,37.4:3353:",
	"P:83.0,72.4:3353:",
	"P:83.2,19.6:3353:",
	"P:85.0,30.6:3353:",
	--Scruffy Ottuk/Aquatic:
	"P:42.0,52.2:3281:",
	"P:42.0,55.2:3281:",
	"P:76.0,55.4:3281:",
	"P:77.2,51.8:3281:",
	"P:78.0,53.8:3281:",
	"P:78.8,40.4:3281:",
	"P:79.8,42.6:3281:",
	"P:86.0,57.4:3281:",
	--Treasures
	"A:32413815:16299:1::67049", -- Nokhud Warspear
	"A:70533549:16299:2::67950", -- Slightly Chewed Duck Egg
	"A:33205532:16299:3::70391", -- Emerald Gem Cluster
	"A:73475616:16299:4::70402", -- Cracked Centaur Horn
	"A:82307338:16299:5::70379", -- Gold Swog Coin
	"A:51985830:16299:6::70400", -- Yennu's Boat
	--Explore
	"A:23045185:16457:1", -- Ancient Bough
	"A:45814144:16457:2", -- Broadhoof Outpost
	"A:65032393:16457:3", -- Emberwatch
	"A:36564595:16457:4", -- Emerald Gardens
	"A:70897966:16457:5", -- Forkriver Crossing
	"A:60984350:16457:6", -- Maruukai
	"A:35103804:16457:7", -- Nokhuddon Hold
	"A:72724025:16457:8", -- Horn of Drusahl
	"A:84893634:16457:9", -- Rusza'thar Reach
	"A:40326276:16457:10", -- Teerakai
	"A:81352706:16457:11", -- Mirewood Fen
	"A:62276781:16457:12"}) -- Windsong Rise

safeTappend(2024.0, {--The Azure Span
	--Tiny Timbertooth/Beast:
	"P:11.4,34.8:3328:",
	"P:12.8,38.2:3328:",
	"P:15.0,34.4:3328:",
	"P:20.2,47.4:3328:",
	"P:20.4,43.0:3328:",
	"P:21.6,38.8:3328:",
	"P:22.6,42.2:3328:",
	"P:25.4,36.6:3328:",
	"P:43.4,36.2:3328:",
	"P:58.2,52.2:3328:",
	"P:58.8,55.4:3328:",
	"P:59.4,57.4:3328:",
	"P:67.4,55.6:3328:",
	"P:67.4,57.6:3328:",
	--Vorquin Runt/Beast:
	"P:16.0,26.0:3336:",
	"P:16.6,28.0:3336:",
	"P:18.8,27.6:3336:",
	"P:20.6,32.2:3336:",
	"P:21.0,34.2:3336:",
	"P:22.8,30.4:3336:",
	"P:30.0,36.4:3336:",
	"P:32.2,39.0:3336:",
	"P:34.2,41.4:3336:",
	"P:36.2,43.0:3336:",
	"P:36.8,35.2:3336:",
	"P:38.8,36.0:3336:",
	"P:40.2,42.4:3336:",
	--Treeflitter/Critter:
	"P:71.0,30.8:3276:",
	--Swoglet/Aquatic:
	"P:10.4,41.2:3282:",
	"P:12.4,44.6:3282:",
	"P:12.8,42.0:3282:",
	"P:14.2,19.0:3282:",
	"P:16.6,17.6:3282:",
	"P:17.0,30.0:3282:",
	"P:18.2,22.4:3282:",
	"P:18.2,27.4:3282:",
	"P:18.8,49.4:3282:",
	"P:19.2,24.4:3282:",
	"P:20.4,40.4:3282:",
	"P:20.8,44.4:3282:",
	"P:23.4,34.2:3282:",
	"P:24.8,30.4:3282:",
	"P:32.6,47.4:3282:",
	"P:33.8,31.4:3282:",
	"P:34.8,47.4:3282:",
	"P:35.8,50.2:3282:",
	"P:37.8,49.0:3282:",
	"P:39.8,31.8:3282:",
	"P:40.0,49.8:3282:",
	"P:41.4,33.6:3282:",
	"P:42.0,49.4:3282:",
	"P:42.8,36.0:3282:",
	"P:44.0,38.0:3282:",
	"P:45.8,36.6:3282:",
	"P:50.0,21.6:3282:",
	"P:50.6,19.4:3282:",
	"P:53.0,19.0:3282:",
	"P:56.2,65.4:3282:",
	"P:58.4,64.6:3282:",
	"P:63.4,41.4:3282:",
	"P:64.8,15.2:3282:",
	"P:66.8,59.4:3282:",
	"P:68.4,49.0:3282:",
	"P:74.4,54.2:3282:",
	--Shore Crab/Aquatic:
	"P:7.2,45.0:388:",
	"P:7.8,48.8:388:",
	"P:10.4,48.2:388:",
	--Trunkalumpf/Beast:
	"P:20.0,43.4:3288:",
	"P:22.4,45.6:3288:",
	"P:26.4,39.4:3288:",
	"P:64.4,56.0:3288:",
	"P:68.4,27.2:3288:",
	"P:70.4,29.2:3288:",
	--Storm-Touched Ottuk/Aquatic:
	"P:11.4,34.8:3354:",
	"P:13.4,35.8:3354:",
	"P:14.4,32.6:3354:",
	"P:15.4,34.8:3354:",
	"P:42.8,31.4:3354:",
	"P:43.6,29.4:3354:",
	"P:57.8,64.2:3354:",
	"P:59.4,68.2:3354:",
	"P:60.2,66.2:3354:",
	--Chalkshell Turtle/Aquatic:
	"P:10.8,48.0:3356:",
	--Palamanther/Aquatic:
	"P:11.0,41.8:3296:",
	"P:11.0,44.4:3296:",
	"P:11.8,46.4:3296:",
	"P:21.8,41.2:3296:",
	"P:22.8,38.6:3296:",
	"P:27.6,37.2:3296:",
	"P:32.8,46.6:3296:",
	"P:34.2,48.4:3296:",
	"P:36.4,48.6:3296:",
	"P:39.4,50.0:3296:",
	"P:41.4,49.4:3296:",
	--Beetle/Critter:
	"P:16.4,32.8:406:",
	--Crimsonspine/Magic:
	"P:60.4,38.0:3358:",
	--Grizzlefur Cub/Beast:
	"P:27.2,31.0:3351:",
	"P:29.2,32.4:3351:",
	"P:30.2,41.2:3351:",
	"P:30.4,43.4:3351:",
	"P:30.6,47.0:3351:",
	"P:32.2,35.4:3351:",
	"P:34.4,37.2:3351:",
	"P:35.2,49.4:3351:",
	"P:35.4,45.2:3351:",
	"P:36.2,33.8:3351:",
	"P:36.8,30.0:3351:",
	"P:37.6,47.0:3351:",
	"P:41.2,48.8:3351:",
	"P:42.8,38.4:3351:",
	"P:42.8,45.0:3351:",
	"P:67.2,50.8:3351:",
	"P:70.4,58.2:3351:",
	"P:71.4,53.6:3351:",
	"P:74.2,54.6:3351:",
	--Scruffy Ottuk/Aquatic:
	"P:12.0,47.4:3281:",
	"P:14.0,49.8:3281:",
	"P:23.8,71.4:3281:",
	"P:44.0,54.6:3281:",
	"P:46.2,53.4:3281:",
	"P:50.4,54.4:3281:",
	"P:52.4,51.4:3281:",
	"P:59.6,68.2:3281:",
	"P:59.8,56.2:3281:",
	"P:60.6,66.4:3281:",
	"P:68.2,50.4:3281:",
	"P:68.2,53.4:3281:",
	"P:68.4,55.8:3281:",
	--Snowlemental/Elemental:
	"P:47.2,39.6:3283:",
	"P:48.8,64.8:3283:",
	"P:49.0,62.2:3283:",
	"P:51.2,58.0:3283:",
	"P:51.2,60.8:3283:",
	"P:53.0,42.2:3283:",
	"P:55.2,21.2:3283:",
	"P:59.4,44.8:3283:",
	"P:66.6,11.4:3283:",
	"P:67.6,19.0:3283:",
	"P:70.0,36.2:3283:",
	"P:70.4,44.0:3283:",
	"P:72.2,42.2:3283:",
	"P:72.4,25.4:3283:",
	"P:73.0,36.4:3283:",
	"P:75.2,23.6:3283:",
	"P:78.2,29.0:3283:",
	"P:78.4,32.4:3283:",
	--Magma Slug/Elemental:
	"P:18.0,95.2:3273:",
	--Snowy Treeflitter/Critter:
	"P:66.4,25.4:3260:",
	"P:68.6,24.0:3260:",
	"P:69.0,29.8:3260:",
	"P:69.2,27.6:3260:",
	"P:71.8,31.0:3260:",
	"P:72.2,28.0:3260:",
	--Whitewhisker/Flying:
	"P:50.4,54.4:3320:",
	"P:51.6,56.0:3320:",
	--Woodbiter Piculet/Flying:
	"P:60.0,53.4:3322:",
	"P:62.2,53.0:3322:",
	"P:63.8,60.0:3322:",
	--Pale Baby Vorquin/Beast:
	"P:44.6,40.4:3335:",
	"P:45.2,38.2:3335:",
	--Azure Crystalspine/Magic:
	"P:14.8,17.4:3357:",
	"P:14.8,26.2:3357:",
	"P:15.0,45.2:3357:",
	"P:15.2,24.0:3357:",
	"P:17.2,25.2:3357:",
	"P:17.4,44.4:3357:",
	"P:17.8,29.0:3357:",
	"P:19.0,46.6:3357:",
	"P:19.8,37.4:3357:",
	"P:21.6,25.4:3357:",
	"P:22.6,23.6:3357:",
	"P:22.8,27.2:3357:",
	"P:24.6,32.0:3357:",
	"P:25.2,38.6:3357:",
	"P:25.4,44.4:3357:",
	"P:27.2,34.0:3357:",
	"P:29.2,40.4:3357:",
	"P:33.8,35.4:3357:",
	"P:34.0,32.2:3357:",
	"P:37.4,31.0:3357:",
	"P:39.0,61.0:3357:",
	"P:40.4,34.4:3357:",
	"P:41.8,62.8:3357:",
	"P:43.6,59.6:3357:",
	"P:43.8,51.8:3357:",
	"P:44.0,32.2:3357:",
	"P:44.6,48.4:3357:",
	"P:45.0,39.8:3357:",
	"P:45.2,62.4:3357:",
	"P:45.4,42.2:3357:",
	"P:46.4,52.2:3357:",
	"P:46.6,35.2:3357:",
	"P:46.8,29.8:3357:",
	"P:47.0,23.4:3357:",
	"P:48.4,49.2:3357:",
	"P:48.6,51.4:3357:",
	"P:49.0,27.8:3357:",
	"P:49.2,47.2:3357:",
	"P:50.4,33.8:3357:",
	"P:50.6,22.8:3357:",
	"P:50.6,51.2:3357:",
	"P:50.8,36.6:3357:",
	"P:51.0,44.2:3357:",
	"P:51.4,53.8:3357:",
	"P:52.8,30.0:3357:",
	"P:53.0,21.0:3357:",
	"P:53.0,26.4:3357:",
	"P:54.0,44.0:3357:",
	"P:54.4,22.6:3357:",
	"P:55.2,55.2:3357:",
	"P:55.4,58.0:3357:",
	"P:56.2,62.4:3357:",
	"P:56.6,39.4:3357:",
	"P:57.0,24.8:3357:",
	"P:57.0,51.8:3357:",
	"P:57.2,66.0:3357:",
	"P:57.4,57.8:3357:",
	"P:57.6,64.0:3357:",
	"P:57.8,36.8:3357:",
	"P:57.8,68.2:3357:",
	"P:58.2,19.4:3357:",
	"P:58.2,60.0:3357:",
	"P:59.0,29.4:3357:",
	"P:59.4,42.4:3357:",
	"P:59.6,46.2:3357:",
	"P:60.0,63.6:3357:",
	"P:60.6,16.2:3357:",
	"P:60.6,33.4:3357:",
	"P:61.0,19.2:3357:",
	"P:61.0,50.4:3357:",
	"P:61.2,56.8:3357:",
	"P:61.6,60.6:3357:",
	"P:62.2,37.2:3357:",
	"P:63.4,25.6:3357:",
	"P:64.0,61.8:3357:",
	"P:64.4,16.6:3357:",
	"P:64.6,31.6:3357:",
	"P:64.8,35.0:3357:",
	"P:65.0,19.4:3357:",
	"P:65.0,53.2:3357:",
	"P:65.0,57.4:3357:",
	"P:66.2,55.0:3357:",
	"P:66.6,15.4:3357:",
	"P:67.4,23.8:3357:",
	"P:67.8,60.4:3357:",
	"P:68.2,30.8:3357:",
	"P:68.2,58.4:3357:",
	"P:68.4,13.2:3357:",
	"P:69.0,16.0:3357:",
	"P:69.6,52.2:3357:",
	"P:69.8,10.4:3357:",
	"P:69.8,18.2:3357:",
	"P:70.2,60.2:3357:",
	"P:71.0,26.8:3357:",
	--Kindlet/Elemental:
	"P:18.2,95.2:3366:",
	--Treasures
	"A:45135939:16300:1::70603", -- Forgotten Jewel Box
	"A:53964377:16300:2::70604", -- Gnoll Fiend Flail
	"A:48632466:16300:3::70605", -- Sapphire Gem Cluster
	"A:74905499:16300:4::70606", -- Lost Compass
	"A:54642933:16300:5::70380", -- Rubber Fish
	"A:26544629:16300:6::70441", -- Pepper Hammer
	--Explore
	"A:44754010:16460:1", -- Camp Antonidas
	"A:40016220:16460:2", -- Azure Archives
	"A:34293542:16460:3", -- Big Tree Hills
	"A:14803711:16460:4", -- Brackenhide Hollow
	"A:63825762:16460:5", -- Camp Nowhere
	"A:49712697:16460:6", -- Cobalt Assembly
	"A:14164660:16460:7", -- Iskaara
	"A:57384393:16460:8", -- Snowhide Den
	"A:64951649:16460:9", -- Theron's Watch
	"A:18142392:16460:10", -- Three-Falls Lookout
	"A:77513124:16460:11"}) -- Valkthros

safeTappend(2025.0, {--Thaldraszus
	--Storm-Touched Bluefeather/Flying:
	"P:58.0,57.8:3384:",
	"P:58.2,55.8:3384:",
	"P:60.8,60.8:3384:",
	"P:61.0,56.2:3384:",
	--Pricklefury Hare/Critter:
	"P:51.6,66.2:3272:",
	"P:52.6,43.4:3272:",
	--Igneoid/Elemental:
	"P:46.4,64.0:3295:",
	"P:47.6,62.0:3295:",
	"P:48.2,57.4:3295:",
	"P:48.4,59.4:3295:",
	"P:50.0,56.0:3295:",
	"P:50.2,51.6:3295:",
	"P:51.4,57.6:3295:",
	"P:52.4,47.8:3295:",
	"P:52.8,51.2:3295:",
	"P:54.0,46.4:3295:",
	--Palamanther/Aquatic:
	"P:38.2,48.4:3296:",
	"P:38.8,45.4:3296:",
	"P:40.6,47.6:3296:",
	"P:48.4,58.2:3296:",
	"P:49.2,60.6:3296:",
	"P:49.4,56.4:3296:",
	"P:50.6,58.4:3296:",
	--Crimsonspine/Magic:
	"P:50.0,64.0:3358:",
	--Grizzlefur Cub/Beast:
	"P:38.2,81.6:3351:",
	"P:47.4,62.0:3351:",
	"P:48.0,56.0:3351:",
	--Blue Dasher/Flying:
	"P:32.2,69.2:3403:",
	"P:33.4,67.0:3403:",
	"P:34.2,71.6:3403:",
	"P:34.8,64.0:3403:",
	"P:36.4,65.4:3403:",
	"P:37.2,76.8:3403:",
	"P:37.8,79.8:3403:",
	"P:38.2,72.8:3403:",
	"P:39.4,78.2:3403:",
	"P:40.4,81.0:3403:",
	"P:42.2,83.0:3403:",
	"P:42.4,78.8:3403:",
	"P:44.4,84.4:3403:",
	"P:53.8,36.2:3403:",
	"P:61.0,15.0:3403:",
	"P:63.0,13.8:3403:",
	"P:63.6,19.6:3403:",
	"P:66.4,21.8:3403:",
	--Treeflitter/Critter:
	"P:41.8,65.0:3276:",
	"P:43.6,66.8:3276:",
	"P:44.8,64.0:3276:",
	"P:49.8,63.2:3276:",
	"P:50.8,65.8:3276:",
	"P:53.8,61.2:3276:",
	--Polliswog/Aquatic:
	"P:34.2,68.4:3404:",
	"P:35.8,66.4:3404:",
	"P:36.6,71.8:3404:",
	"P:37.6,67.4:3404:",
	"P:43.2,83.4:3404:",
	"P:43.6,81.4:3404:",
	"P:53.4,41.6:3404:",
	"P:54.8,39.4:3404:",
	"P:56.2,30.6:3404:",
	"P:60.0,30.0:3404:",
	--Razortooth Bear Cub/Beast:
	"P:47.4,62.0:3352:",
	"P:48.2,57.4:3352:",
	--Grassland Stomper/Beast:
	"P:48.2,50.2:3313:",
	"P:49.2,52.2:3313:",
	"P:51.0,48.8:3313:",
	--Vorquin Runt/Beast:
	"P:32.8,73.0:3336:",
	"P:38.0,78.6:3336:",
	"P:41.0,81.4:3336:",
	"P:41.4,67.8:3336:",
	"P:42.2,65.6:3336:",
	"P:42.8,82.8:3336:",
	"P:44.0,66.8:3336:",
	"P:44.2,64.8:3336:",
	"P:45.2,61.8:3336:",
	"P:45.4,85.2:3336:",
	"P:46.4,65.8:3336:",
	"P:48.2,64.8:3336:",
	"P:49.4,62.4:3336:",
	"P:51.2,65.0:3336:",
	"P:52.2,62.2:3336:",
	"P:53.4,40.4:3336:",
	"P:53.6,60.2:3336:",
	"P:54.0,55.4:3336:",
	--Kindlet/Elemental:
	"P:38.6,48.2:3366:",
	"P:40.8,45.0:3366:",
	--Treasures
	"A:33957694:16301:1::70607", -- Cracked Hourglass
	"A:58158005:16301:2::70608", -- Sandy Wooden Duck
	"A:52607673:16301:3::70408", -- Amber Gem Cluster
	"A:60234160:16301:4::70609", -- Elegant Canvas Brush
	"A:64851650:16301:5::70610", -- Surveyor's Magnifying Glass
	"A:49456291:16301:6::70611", -- Acorn Harvester
	--Explore
	"A:55608279:16518:1", -- Valdrakken
	"A:58766103:16518:2", -- Tyrhold
	"A:50956746:16518:3", -- Gelikyr Post
	"A:38358081:16518:4", -- South Hold Gate
	"A:59878177:16518:5", -- Temporal Conflux
	"A:59684340:16518:6", -- Algeth'ar Academy
	"A:72795597:16518:7", -- Vault of the Incarnates
	"A:60312222:16518:8"}) -- Vield Ossuary

safeTappend(2133.0, {--Zaralek Cavern
	--Stonewhisker/Critter:
	"P:41.4,69.8:3481:",
	"P:42.8,71.6:3481:",
	"P:43,77.4:3481:",
	"P:45,68:3481:",
	"P:47,40.8:3481:",
	"P:47.8,75.4:3481:",
	"P:48.4,39.2:3481:",
	"P:48.4,73:3481:",
	"P:49.2,45.2:3481:",
	"P:51.2,41:3481:",
	"P:51.4,37.8:3481:",
	"P:51.4,43:3481:",
	"P:52,47:3481:",
	"P:53,45:3481:",
	--Sunglow Cobra/Beast:
	"P:45.2,62:3489:",
	"P:46,57.8:3489:",
	"P:46.2,50.8:3489:",
	"P:46.2,59.8:3489:",
	"P:47.2,54.6:3489:",
	"P:48.2,62:3489:",
	"P:48.6,37.4:3489:",
	"P:49.2,56.4:3489:",
	"P:50,35:3489:",
	"P:50.4,59:3489:",
	"P:51.2,61.4:3489:",
	--Cobbleshell/Critter:
	"P:41.2,74.6:3482:",
	"P:42,72.6:3482:",
	"P:42.8,68.4:3482:",
	"P:43.2,74.4:3482:",
	"P:43.6,70.4:3482:",
	"P:44.8,77:3482:",
	"P:45.2,72.4:3482:",
	"P:45.6,74.8:3482:",
	"P:46.8,79.2:3482:",
	"P:47.4,73.8:3482:",
	"P:51.8,75.6:3482:",
	"P:58,65.2:3482:",
	"P:59.2,60:3482:",
	"P:59.2,67.4:3482:",
	"P:59.4,54.6:3482:",
	"P:59.6,64:3482:",
	"P:59.8,57.4:3482:",
	--Ebonwing Moth/Flying:
    "P:41.4,59.4:3490:",
    "P:43.4,43.6:3490:",
    "P:43.4,67.2:3490:",
    "P:43.4,71.4:3490:",
    "P:43.6,76.4:3490:",
    "P:43.8,61.2:3490:",
    "P:44.8,46.2:3490:",
    "P:44.8,73.4:3490:",
    "P:45.6,76:3490:",
    "P:45.8,48:3490:",
    "P:46.2,78:3490:",
    "P:46.4,41:3490:",
    "P:46.4,62:3490:",
    "P:47.2,43.8:3490:",
    "P:47.2,46:3490:",
    "P:47.2,67.6:3490:",
    "P:47.4,49.2:3490:",
    "P:47.8,73.4:3490:",
    "P:48.4,39.4:3490:",
    "P:49,70.8:3490:",
    "P:49.2,77.8:3490:",
    "P:49.6,56.4:3490:",
    "P:49.8,61.8:3490:",
    "P:51.2,45.8:3490:",
    "P:51.6,57.4:3490:",
    "P:53.8,57.8:3490:",
    --Boulderfang/Beast:
    "P:43.6,47.8:3483:",
    "P:45.2,60.4:3483:",
    "P:45.8,56:3483:",
    "P:46,50.8:3483:",
    "P:46,58:3483:",
    "P:46,62.4:3483:",
    "P:47,54.4:3483:",
    "P:48,39.4:3483:",
    "P:48,59:3483:",
    "P:48.2,62:3483:",
    "P:48.4,37.4:3483:",
    "P:49,56.2:3483:",
    "P:50,35.2:3483:",
    "P:50.4,59.2:3483:",
    "P:50.8,51.4:3483:",
    "P:51.2,61.4:3483:",
    --Slabwing/Elemental:
    "P:40,65.8:3484:",
    "P:41.2,69.2:3484:",
    "P:41.6,67:3484:",
    "P:43.6,66.2:3484:",
    "P:48.2,54.8:3484:",
    "P:48.4,51.4:3484:",
    "P:48.6,60.6:3484:",
    "P:50,52.8:3484:",
    "P:50.2,57:3484:",
    "P:50.4,54.8:3484:",
    "P:51.4,59.8:3484:",
    "P:53.2,61:3484:",
    --Puddlehopper/Aquatic:
    "P:43.8,49:3477:",
    "P:44,40.2:3477:",
    "P:44.8,58.4:3477:",
    "P:45,50.8:3477:",
    "P:45.2,56.4:3477:",
    "P:46.2,54:3477:",
    "P:47.2,38.4:3477:",
    "P:48.2,35:3477:",
    "P:48.2,52.4:3477:",
    "P:49,32.4:3477:",
    "P:49.4,39.4:3477:",
    "P:49.4,50.4:3477:",
    "P:50,45.8:3477:",
    "P:50.8,43:3477:",
    "P:50.8,47.8:3477:",
    --Hollow Moth/Flying:
    "P:41.4,59.4:3485:",
    "P:43,60.6:3485:",
    "P:43.4,43.4:3485:",
    "P:43.4,67.2:3485:",
    "P:43.4,71.4:3485:",
    "P:43.4,76.4:3485:",
    "P:44.6,59.4:3485:",
    "P:44.8,73.2:3485:",
    "P:45.2,45.6:3485:",
    "P:45.4,76.4:3485:",
    "P:46,43:3485:",
    "P:46.4,41:3485:",
    "P:46.4,48.2:3485:",
    "P:46.4,62:3485:",
    "P:47,67.6:3485:",
    "P:47.2,46.2:3485:",
    "P:47.2,79.6:3485:",
    "P:47.6,73.6:3485:",
    "P:48.4,39.4:3485:",
    "P:48.4,77.8:3485:",
    "P:48.6,49:3485:",
    "P:49,69.2:3485:",
    "P:49.6,56.4:3485:",
    "P:49.8,62:3485:",
    "P:51.2,45.6:3485:",
    "P:51.6,56.4:3485:",
    "P:53.2,58.8:3485:",
    --Rock Martin/Flying:
    "P:42.6,75.6:3478:",
    "P:42.8,67.4:3478:",
    "P:43.2,77.8:3478:",
    "P:45,68.8:3478:",
    "P:45.2,71:3478:",
    "P:45.2,78:3478:",
    "P:47.2,79:3478:",
    "P:48.2,42.8:3478:",
    "P:48.8,40.8:3478:",
    "P:49,75:3478:",
    "P:49.8,44.6:3478:",
    "P:49.8,72.4:3478:",
    "P:50,77.8:3478:",
    "P:50.8,37.8:3478:",
    --Lithengale/Flying:
    "P:42.6,75.6:3486:",
    "P:42.8,67.6:3486:",
    "P:43.2,78:3486:",
    "P:45,68.8:3486:",
    "P:45,70.8:3486:",
    "P:45.2,77.8:3486:",
    "P:47.2,79:3486:",
    "P:48.2,42.8:3486:",
    "P:48.8,40.8:3486:",
    "P:49,75:3486:",
    "P:49.8,72.4:3486:",
    "P:49.8,78:3486:",
    "P:50,44.4:3486:",
    "P:50.8,38:3486:",
    --Yellabon/Flying:
    "P:47,39.6:3479:",
    "P:47.6,41.6:3479:",
    "P:50,42.8:3479:",
    "P:51.2,37.2:3479:",
    "P:51.4,46.6:3479:",
    "P:51.6,40:3479:",
    --Scarlapod/Critter:
    "P:41.2,74.6:3487:",
    "P:42,72.6:3487:",
    "P:42.8,68.6:3487:",
    "P:43.2,74.4:3487:",
    "P:44.6,77.2:3487:",
    "P:45.2,72.6:3487:",
    "P:45.4,74.8:3487:",
    "P:46.8,79.2:3487:",
    "P:47.4,73.8:3487:",
    "P:58,65.2:3487:",
    "P:59,67.4:3487:",
    "P:59.2,60:3487:",
    "P:59.6,55:3487:",
    "P:59.8,57.4:3487:",
    --Endmite/Critter:
    "P:36.8,77.4:3480:",
    "P:38,75.6:3480:",
    "P:39.2,69.6:3480:",
    "P:39.8,74.6:3480:",
    "P:40.2,67.8:3480:",
    "P:40.2,72.6:3480:",
    "P:43.2,47:3480:",
    "P:43.4,64:3480:",
    "P:43.4,69.8:3480:",
    "P:44,66.4:3480:",
    "P:44.8,45.2:3480:",
    "P:45,49.4:3480:",
    "P:45.2,40.6:3480:",
    "P:45.8,53.2:3480:",
    "P:46.4,47.4:3480:",
    "P:46.8,43.2:3480:",
    "P:47,72.6:3480:",
    "P:47.2,57.4:3480:",
    "P:47.4,45.2:3480:",
    "P:47.6,51.4:3480:",
    "P:49.4,36.8:3480:",
    "P:49.6,34.6:3480:",
    "P:50.2,73.4:3480:",
    "P:50.4,43.8:3480:",
    "P:50.4,50.4:3480:",
    "P:51.4,85.4:3480:",
    "P:52.4,82.4:3480:",
    "P:53.4,79.4:3480:",
    "P:53.6,45.4:3480:",
    --Deepridger/Elemental:
    "P:40.2,65.6:3488:",
    "P:41,68.4:3488:",
    "P:43.4,66.2:3488:",
    "P:48.2,54.8:3488:",
    "P:48.4,51.4:3488:",
    "P:48.6,60.6:3488:",
    "P:50,52.8:3488:",
    "P:50.2,57:3488:",
    "P:50.6,60:3488:",
    "P:50.8,55:3488:",
    "P:52.2,58:3488:",
    "P:53.2,61:3488:",
	--Rares
	"R:56207380:203515:Reward (item:203307)\n(item:205309)\n(item:205318)::75284", -- Alcanon
	"R:48367509:203468:Reward (item:205154)\n(item:205090)\n(item:205295)\n(item:205306)::75270", -- Aquifon
	"R:41518613:203621:Reward (item:205114)\n(item:204847)\n(item:205320)\n(item:205313)::75325", -- Brullo the Strong
	"R:47822342:204093:Reward (item:197364)\n(item:205096)\n(item:205315)\n(item:205330)\n(item:205332)::75475", -- Colossian
	"R:32445127:203664:Reward (item:203363)\n(item:205293)\n(item:205335)::75361", -- Emberdusk
	"R:36324481:203660:Reward (item:197109)\n(item:205303)\n(item:205334)::75357", -- Flowfy
	"R:42521879:203592:Reward (item:205321)::75295", -- General Zskorro
	"R:68734593:203477:Reward (item:203309)\n(item:205296)\n(item:205317)::75273", -- Goopal
	"R:46103346:203627:Reward (item:203328)\n(item:204981)\n(item:205297)\n(item:205329)\n(item:205796)::75335", -- Invoq
	"R:28875085:203646:Reward (item:203320)\n(item:205299)\n(item:205304)\n(item:205419)::75352", -- Dinn
	"R:42176584:203625:Reward (item:203358)\n(item:205203)\n(item:205147)\n(item:205292)\n(item:205298)::75333", -- Karokta
	"R:60293933:203466:Reward (item:205341)\n(item:205310)\n(item:205319)\n(item:205461)\n(item:205462)::75268", -- Kapraku
	"R:53724114:203618:Reward (item:203321)\n(item:205294)\n(item:205301)::75321", -- Klakatak
	"R:65435587:203462:Reward (item:206021)\n(item:205152)\n(item:205147)\n(item:205307)::75266", -- Kob'rok
	"R:41383744:200111:Reward (item:203339)\n(item:205300)\n(item:205311)::75339", -- Magtembo
	"R:55841899:203521:Reward (item:203331)\n(item:205322)\n(item:205333)::75291", -- Professor Gastrinax
	"R:36425329:203643:Reward (item:203321)\n(item:205294)\n(item:205301)::75348", -- Skornak
	"R:53106421:203480:Reward (item:203318)\n(item:205290)\n(item:2005305)\n(item:205326)::75275", -- Spinmarrow
	"R:37954642:203662:Reward (item:203338)\n(item:205312)\n(item:205314)\n(item:205328)::75359", -- Subterrax
	"R:57786911:203593:Reward (item:205159)\n(item:205302)\n(item:205324)\n(item:205325)::75297", -- Underlight Queen
	"R:39407061:201029:Reward (item:203345)\n(item:205316)\n(item:205327)\n(item:205336)::75365", -- Viridian King
    --Treasures
	"A:36694880:17786:1::73697", -- Ancient Zaqali Chest
	"A:28524794:17786:2::72986", -- Blazing Shadowflame Chest
	"A:42976040:17786:3::75232", -- Bloody Body
	"A:30064193:17786:4::73706", -- Charred Egg
	"A:55730366:17786:5::75187", -- Chest of the Flights
	"A:36407426:17786:6::74986", -- Crystal-Encased Chest
	"A:62715375:17786:7::75019", -- Long-Lost Cache
	"A:43068256:17786:8::74995", -- Old Trunk
	"A:32333935:17786:9::73410", -- Seething Cache
	"A:29764055:17786:10::73395", -- Well-Chewed Chest
    --Explore
    "A:48211133:17766:1", -- Aberrus Approach
	"A:53608168:17766:2", -- Buried Vault
	"A:40037869:17766:3", -- Glimmeregg
	"A:56385567:17766:4", -- Loamm
	"A:48497848:17766:5", -- Nal ks'kol
	"A:47784620:17766:6", -- Sulfur Wastes
	"A:59684383:17766:7", -- The Throughway
	"A:44764383:17766:8"}) -- Zaqali Caldera

safeTappend(2200.0, {--Emerald Dream
	--Adventurer
	"R:62007140:209113:::77570", -- Nuoberon
	"R:30002120:209893:Reward (item:208328)\n(item:209881)::78015", -- Firebrand Fystia
	"R:64208400:209898:Reward (item:208327)::77867", -- Reefbreaker Moruud
	"R:53804040:209936:Reward (item:208355)::77982", -- Greedy Gessie
	"R:34806320:209929:Reward (item:208332)\n(item:208337)\n(item:208340)\n(item:208365)::77878", -- Envoy of Winter
	"R:35102260:209902:Reward (item:208374)::77994", -- Talthonei Ashwhisper
	"R:61805180:209365:Reward (item:208361)::77863", -- Splinterlimb
	"R:58405120:209620:Reward (item:208325)::77864", -- Ignit the Firebranded
	"R:66006280:209909:Reward (item:208334)\n(item:208341)::77862", -- Crabtankerous
	"R:63407160:209913:Reward (item:208344)\n(item:208372)\n(item:208388)::77846", -- Fruitface
	"R:26002660:209911:Reward (item:208370)::77990", -- The Apostle
	"R:37603180:209919:Reward (item:208348)::77989", -- Isaqa
	"R:43603100:210111:Reward (item:208330)\n(item:208367)\n(item:207761)::78263", -- Surging Lasher
	"R:40457263:210045:Reward (item:210121)\n(item:210237)::78210", -- Moragh the Slothful
	"R:40304920:210046:Reward (item:210650)::78211", -- Keen-eyed Cian
	"R:43404700:210047:Reward (item:209956)::78212", -- Somnambulant Ori
	"R:51203180:210050:Reward (item:208376)::77942", -- Bloodstripe Great Ray
	"R:41207320:210051:Reward (item:210683)::78213", -- Matriarch Keevah
	"R:46201920:208658:Reward (item:205463)\n(item:208353)::77941", -- Moltenbinder's Disciple
	"R:63803620:210064:Reward (item:208323)::77943", -- Molten Leadspike
	"R:54803680:210070:Reward (item:210647)::77940", -- Mosa Umbramane
	"R:47403030:210075:Reward (item:208357)::77944", -- Henri Snufftail
	"R:44403920:210161:Reward (item:209957)::77890", -- Ristar the Rabid
	"R:38406200:210508:::78214", -- Voracious Mikanji
	--Explore
	"A:72775306:19309:1", -- Ancient Bough
	"A:50496222:19309:2", -- Amirdrassil
	"A:52402879:19309:3", -- Eye of Ysera
	"A:43714871:19309:4", -- Lushdream Crags
	"A:43192656:19309:5", -- Primalist Stronghold
	"A:53207420:19309:6", -- Root-Bound Sanctuary
	"A:62605150:19309:7", -- Shoreline Roots
	"A:36825174:19309:8", -- The Smoldering Copse
	"A:28193150:19309:9", -- Wellspring of Life
	"A:37666777:19309:10", -- Whorlwing Basin
	--Treasures
	"A:34095634:19317:1::77872", -- Triflesnatch's Roving Trove
	"A:47503490:19317:2::77858", -- Hidden Moonkin Stash
	"A:39106550:19317:3::77950", -- Crystalline Glowblossom
	"A:37303070:19317:4::78120", -- Pineshrew Cache
	"A:64306130:19317:5::78005", -- Magical Bloom
	"A:61406320:19317:6::78006", -- Odd Burl
	"A:47105310:19317:7::78107", -- Reliquary of Ursol
	"A:64101920:19317:8::78360", -- Reliquary of Aviana
	"A:63407300:19317:9::78359", -- Reliquary of Ashamane
	"A:33208330:19317:10::78361"}) -- Reliquary of Goldrinn


getmetatable(DugisWorldMapTrackingPoints).__index = nil